// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('flureenjs');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.auth');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.flake');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.operations');
goog.require('fluree.db.permissions');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.graphql_parser');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.sparql_parser');
goog.require('fluree.db.query.sql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('goog.string.format');
goog.require('cljs.nodejs');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.api_js');
goog.require('cljs.js');
goog.require('cljs.analyzer');
goog.require('cljs.env');
goog.require('cljs.compiler');
cljs.nodejs.enable_util_print_BANG_.call(null);
flureenjs.init_state = (function flureenjs$init_state(state){
return cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"rename-macros","rename-macros",1076432512),new cljs.core.Keyword(null,"renames","renames",343278368),new cljs.core.Keyword(null,"use-macros","use-macros",-905638393),new cljs.core.Keyword(null,"excludes","excludes",-1791725945),new cljs.core.Keyword(null,"macros","macros",811339431),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"imports","imports",-1249933394),new cljs.core.Keyword(null,"requires","requires",-1201390927),new cljs.core.Keyword("cljs.spec","speced-vars","cljs.spec/speced-vars",1010010387),new cljs.core.Keyword(null,"uses","uses",232664692),new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.Keyword("cljs.spec","registry-ref","cljs.spec/registry-ref",-71711915),new cljs.core.Keyword(null,"require-macros","require-macros",707947416),new cljs.core.Keyword("cljs.analyzer","constants","cljs.analyzer/constants",1697083770),new cljs.core.Keyword(null,"doc","doc",1913296891)],[cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 34, [new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"null",new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"null",new cljs.core.Symbol(null,"subs","subs",1453849536,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"dec","dec",-766002333,null),"null",new cljs.core.Symbol(null,"<","<",993667236,null),"null",new cljs.core.Symbol(null,"<=","<=",1244895369,null),"null",new cljs.core.Symbol(null,"*","*",345799209,null),"null",new cljs.core.Symbol(null,"min","min",2085523049,null),"null",new cljs.core.Symbol(null,"get","get",-971253014,null),"null",new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"null",new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"null",new cljs.core.Symbol(null,"not=","not=",1466536204,null),"null",new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"null",new cljs.core.Symbol(null,">",">",1085014381,null),"null",new cljs.core.Symbol(null,"mod","mod",1510044207,null),"null",new cljs.core.Symbol(null,"-","-",-471816912,null),"null",new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"null",new cljs.core.Symbol(null,"or","or",1876275696,null),"null",new cljs.core.Symbol(null,"rem","rem",664046770,null),"null",new cljs.core.Symbol(null,"nth","nth",1529209554,null),"null",new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"null",new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"null",new cljs.core.Symbol(null,"not","not",1044554643,null),"null",new cljs.core.Symbol(null,"/","/",-1371932971,null),"null",new cljs.core.Symbol(null,">=",">=",1016916022,null),"null",new cljs.core.Symbol(null,"inc","inc",324505433,null),"null",new cljs.core.Symbol(null,"+","+",-740910886,null),"null",new cljs.core.Symbol(null,"str","str",-1564826950,null),"null",new cljs.core.Symbol(null,"max","max",1701898075,null),"null",new cljs.core.Symbol(null,"==","==",-234118149,null),"null",new cljs.core.Symbol(null,"count","count",-514511684,null),"null",new cljs.core.Symbol(null,"and","and",668631710,null),"null",new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"null"], null), null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block.",new cljs.core.Keyword(null,"line","line",212345235),12,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null)], null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"log","log",45015523,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fdb","fdb",-1644172664,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"util","util",1147903249,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)],[new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.with_meta(new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Finds the maximum predicate value.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null))))], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(30)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"query","query",352022017,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Executes a query",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Fuel required for query"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the flakes from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerce to boolean. Everything except false and nil is true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Decrements any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the floor of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?o","?o",-1814741084,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the object of an predicate from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(1)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objF","objF",-104129083,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all false flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the ceiling of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"add-stack","add-stack",1221952039,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns product of all the numbers in the sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in *"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets min value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get","get",-971253014,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets a value from an subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the most recent object of an predicate, as of the previous block",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if empty or #{nil}, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Quot[ient] of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"now","now",-9994004,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns current epoch milliseconds on the executing machine.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if two (or more) values are not equal.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"raise","raise",1824672588,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates test.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Modulus of num and div. Truncates toward negative infinity.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string lower case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns difference of all the numbers in the sequence with the first number as the minuend.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in -"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a hash-set of values",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of items in hash-set"], null)))),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if any in the sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in or"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether an email is valid, based on its pattern",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"coerce-args","coerce-args",494321873,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?s","?s",456183954,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remainder of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nth","nth",1529209554,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the nth item in a collection",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in collection"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if nil, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cas","cas",1188988307,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Does a compare and set/swap operation as a transaction function.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(20)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Execute a re-find operation of regex pattern on provided string.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a boolean, true returns false, false returns true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string upper-case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Increments any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns sum of each argument.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in +"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenates all in sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objT","objT",1212205659,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all true flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets max value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if arguments in sequence equal each other.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in count"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Follows an subject down the provided path and returns a set of all matching subjects.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + length of path"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?p","?p",-10896580,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate predicates",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"stack","stack",847125597,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current auth _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current user _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether there is a relationship between two subjects",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if all in a sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in and"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))))], null))],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,778,null,778,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,778,null,new cljs.core.Symbol(null,"any","any",-948528346,null),778,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,7,521,null,521,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),null,cljs.core.list(null,null),1,false,521,null,new cljs.core.Symbol(null,"any","any",-948528346,null),521,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),347,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),347,new cljs.core.Keyword(null,"end-column","end-column",1425389514),16,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null))))], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,347,new cljs.core.Symbol(null,"any","any",-948528346,null),347,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null))))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,133,null,133,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,133,null,new cljs.core.Symbol(null,"any","any",-948528346,null),133,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,479,null,479,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),"Executes a query","Fuel required for query"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),null,6,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),479,null,479,6,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query","Fuel required for query"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,7,750,null,750,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,750,null,new cljs.core.Symbol(null,"any","any",-948528346,null),750,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,659,null,659,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),1,false,659,null,new cljs.core.Symbol(null,"any","any",-948528346,null),659,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,545,null,545,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,545,null,new cljs.core.Symbol(null,"any","any",-948528346,null),545,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,401,null,401,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),401,null,new cljs.core.Symbol(null,"any","any",-948528346,null),401,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,7,800,null,800,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,800,null,new cljs.core.Symbol(null,"any","any",-948528346,null),800,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,7,288,null,288,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,288,null,new cljs.core.Symbol(null,"any","any",-948528346,null),288,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,169,null,169,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,169,null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),169,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,738,null,738,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,738,null,new cljs.core.Symbol(null,"any","any",-948528346,null),738,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,788,null,788,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,788,null,new cljs.core.Symbol(null,"any","any",-948528346,null),788,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),39,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),39,new cljs.core.Keyword(null,"end-column","end-column",1425389514),17,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","add-stack","fluree.db.dbfunctions.fns/add-stack",-218303854,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null)),null,cljs.core.list(null,null),1,false,39,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),39,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),"Adds an entry to the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,414,null,414,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),414,null,new cljs.core.Symbol(null,"any","any",-948528346,null),414,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,594,null,594,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),594,null,new cljs.core.Symbol(null,"any","any",-948528346,null),594,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,466,null,466,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets min value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),466,null,new cljs.core.Symbol(null,"any","any",-948528346,null),466,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,270,null,270,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),null,cljs.core.list(null,null),1,false,270,null,new cljs.core.Symbol(null,"any","any",-948528346,null),270,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,300,null,300,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,300,null,new cljs.core.Symbol(null,"any","any",-948528346,null),300,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,7,109,null,109,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,109,null,new cljs.core.Symbol(null,"any","any",-948528346,null),109,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,620,null,620,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,620,null,new cljs.core.Symbol(null,"any","any",-948528346,null),620,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,558,null,558,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,558,null,new cljs.core.Symbol(null,"any","any",-948528346,null),558,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,440,null,440,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),440,null,new cljs.core.Symbol(null,"any","any",-948528346,null),440,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),50,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),50,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","raise","fluree.db.dbfunctions.fns/raise",-2030365545,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null)),null,cljs.core.list(null,null),1,false,50,new cljs.core.Symbol(null,"ignore","ignore",8989494,null),50,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),"Throws an exception with the provided message."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,73,null,73,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),null,cljs.core.list(null,null),1,false,73,null,new cljs.core.Symbol(null,"any","any",-948528346,null),73,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,762,null,762,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),null,3,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),762,null,762,3,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,388,null,388,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),388,null,new cljs.core.Symbol(null,"any","any",-948528346,null),388,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,633,null,633,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,633,null,new cljs.core.Symbol(null,"any","any",-948528346,null),633,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,7,145,null,145,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,145,null,new cljs.core.Symbol(null,"any","any",-948528346,null),145,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,581,null,581,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),581,null,new cljs.core.Symbol(null,"any","any",-948528346,null),581,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),361,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),361,new cljs.core.Keyword(null,"end-column","end-column",1425389514),15,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a hash-set of values",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of items in hash-set"], null)))),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),361,new cljs.core.Symbol(null,"any","any",-948528346,null),361,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,243,null,243,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),243,null,new cljs.core.Symbol(null,"any","any",-948528346,null),243,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,7,684,null,684,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),null,cljs.core.list(null,null),1,false,684,null,new cljs.core.Symbol(null,"any","any",-948528346,null),684,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),20,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),20,new cljs.core.Keyword(null,"end-column","end-column",1425389514),19,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","coerce-args","fluree.db.dbfunctions.fns/coerce-args",1196396954,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,20,new cljs.core.Symbol(null,"any","any",-948528346,null),20,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,201,null,201,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),201,null,201,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,646,null,646,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,646,null,new cljs.core.Symbol(null,"any","any",-948528346,null),646,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,58,null,58,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,58,null,new cljs.core.Symbol(null,"any","any",-948528346,null),58,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,86,null,86,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,86,null,new cljs.core.Symbol(null,"any","any",-948528346,null),86,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,812,null,812,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),null,cljs.core.list(null,null),1,false,812,null,new cljs.core.Symbol(null,"any","any",-948528346,null),812,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,671,null,671,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),null,cljs.core.list(null,null),1,false,671,null,new cljs.core.Symbol(null,"any","any",-948528346,null),671,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,98,null,98,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,98,null,new cljs.core.Symbol(null,"any","any",-948528346,null),98,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword(null,"file","file",-1269645878),null], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),607,null,new cljs.core.Symbol(null,"any","any",-948528346,null),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence","9 + count of numbers in /"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,427,null,427,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),427,null,new cljs.core.Symbol(null,"any","any",-948528346,null),427,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,7,157,null,157,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,157,null,new cljs.core.Symbol(null,"any","any",-948528346,null),157,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,533,null,533,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,533,null,new cljs.core.Symbol(null,"any","any",-948528346,null),533,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,568,null,568,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns sum of each argument.","9 + count of numbers in +"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),568,null,new cljs.core.Symbol(null,"any","any",-948528346,null),568,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.","9 + count of numbers in +"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,121,null,121,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Concatenates all in sequence.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),121,null,new cljs.core.Symbol(null,"any","any",-948528346,null),121,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,726,null,726,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,726,null,new cljs.core.Symbol(null,"any","any",-948528346,null),726,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,453,null,453,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets max value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),453,null,new cljs.core.Symbol(null,"any","any",-948528346,null),453,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,375,null,375,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),375,null,new cljs.core.Symbol(null,"any","any",-948528346,null),375,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,7,256,null,256,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),1,false,256,null,new cljs.core.Symbol(null,"any","any",-948528346,null),256,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,313,null,313,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Follows an subject down the provided path and returns a set of all matching subjects.","9 + length of path"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,313,null,new cljs.core.Symbol(null,"any","any",-948528346,null),313,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Follows an subject down the provided path and returns a set of all matching subjects.","9 + length of path"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,214,null,214,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),214,null,214,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),33,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),33,new cljs.core.Keyword(null,"end-column","end-column",1425389514),12,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","stack","fluree.db.dbfunctions.fns/stack",-729322264,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,33,new cljs.core.Symbol(null,"any","any",-948528346,null),33,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,7,714,null,714,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,714,null,new cljs.core.Symbol(null,"any","any",-948528346,null),714,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),12,new cljs.core.Keyword(null,"column","column",2078222095),11,new cljs.core.Keyword(null,"end-line","end-line",1837326455),12,new cljs.core.Keyword(null,"end-column","end-column",1425389514),18,new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",18,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&form","&form",1482799337,null),new cljs.core.Symbol(null,"&env","&env",-919163083,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),1,false,12,true,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),"null",new cljs.core.Symbol("cljs.core","IList","cljs.core/IList",1015168964,null),"null"], null), null),12,3,false,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"Resolves a value if a channel.\n  Must be used inside of a go-block."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,7,696,null,696,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,696,null,new cljs.core.Symbol(null,"any","any",-948528346,null),696,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,7,506,null,506,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),null,cljs.core.list(null,null),1,false,506,null,new cljs.core.Symbol(null,"any","any",-948528346,null),506,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,230,null,230,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),230,null,new cljs.core.Symbol(null,"any","any",-948528346,null),230,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,188,null,188,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,188,null,new cljs.core.Symbol(null,"any","any",-948528346,null),188,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),332,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),332,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))))], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,332,new cljs.core.Symbol(null,"any","any",-948528346,null),332,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))))])]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"seen","seen",-518999789),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 25, [new cljs.core.Keyword(null,"_id","_id",-789960287),"null",new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),"null",new cljs.core.Keyword(null,"o","o",-1350007228),"null",new cljs.core.Keyword(null,"spent","spent",-62769180),"null",new cljs.core.Keyword(null,"instant","instant",655498374),"null",new cljs.core.Keyword(null,"else","else",-1508377146),"null",new cljs.core.Keyword(null,"db","db",993250759),"null",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"null",new cljs.core.Keyword(null,"recur","recur",-437573268),"null",new cljs.core.Keyword(null,"state","state",-1988618099),"null",new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),"null",new cljs.core.Symbol(null,"if","if",1181717262,null),"null",new cljs.core.Keyword(null,"s","s",1705939918),"null",new cljs.core.Keyword(null,"function","function",-2127255473),"null",new cljs.core.Keyword(null,"pid","pid",1018387698),"null",new cljs.core.Keyword(null,"status","status",-1997798413),"null",new cljs.core.Keyword(null,"result","result",1415092211),"null",new cljs.core.Keyword(null,"credits","credits",785860820),"null",new cljs.core.Keyword(null,"stack","stack",-793405930),"null",new cljs.core.Keyword(null,"user_id","user_id",993497112),"null",new cljs.core.Keyword(null,"error","error",-978969032),"null",new cljs.core.Keyword(null,"flakes","flakes",1977895739),"null",new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),"null",new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),"null",new cljs.core.Keyword(null,"sid","sid",1815016414),"null"], null), null),new cljs.core.Keyword(null,"order","order",-1254677256),new cljs.core.PersistentVector(null, 25, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),new cljs.core.Keyword(null,"recur","recur",-437573268),new cljs.core.Keyword(null,"else","else",-1508377146),new cljs.core.Keyword(null,"stack","stack",-793405930),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"credits","credits",785860820),new cljs.core.Keyword(null,"spent","spent",-62769180),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"o","o",-1350007228),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"user_id","user_id",993497112),new cljs.core.Keyword(null,"flakes","flakes",1977895739)], null)], null),null]));
});
flureenjs.nj_state = cljs.js.empty_state.call(null,flureenjs.init_state);
var st_68432 = flureenjs.nj_state;
(cljs.core._STAR_eval_STAR_ = (function (form){
var result = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"result","result",1415092211),null], null));
var form_str = ((typeof form === 'string')?form:cljs.core.str.cljs$core$IFn$_invoke$arity$1(form));
var name = "rtm";
var opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"eval","eval",-1103567905),cljs.js.js_eval,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.find_ns.call(null,cljs.analyzer._STAR_cljs_ns_STAR_),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"nodejs","nodejs",321212524)], null);
var cb = (function (res){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res))){
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res));
} else {
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(res));
}
});
cljs.js.eval_str.call(null,st_68432,form_str,name,opts,cb);

return new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,result));
}));
if((typeof flureenjs !== 'undefined') && (typeof flureenjs.app_state !== 'undefined')){
} else {
flureenjs.app_state = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"Fluree NodeJs Library",new cljs.core.Keyword(null,"version","version",425292698),"v1.0.0-rc21"], null));
}
cljs.core.println.call(null,new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs.app_state)));
flureenjs.njs_crypto = (function (){try{return require("crypto");
}catch (e68433){var ex = e68433;
fluree.db.util.log.warn.call(null,["Error: Unable to access Node.js crypto module:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ex)].join(''));

fluree.db.util.log.warn.call(null,"Private key generation is not available.");

return null;
}})();
fluree.db.util.log.set_level_BANG_.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureenjs.set_logging = (function flureenjs$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var map__68435 = opts_SINGLEQUOTE_;
var map__68435__$1 = cljs.core.__destructure_map.call(null,map__68435);
var level = cljs.core.get.call(null,map__68435__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_.call(null,cljs.core.keyword.call(null,level));
});
goog.exportSymbol('flureenjs.set_logging', flureenjs.set_logging);
/**
 * Returns account id from either a public key or message and signature.
 */
flureenjs.account_id = (function flureenjs$account_id(var_args){
var G__68437 = arguments.length;
switch (G__68437) {
case 1:
return flureenjs.account_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureenjs.account_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.account_id', flureenjs.account_id);

(flureenjs.account_id.cljs$core$IFn$_invoke$arity$1 = (function (public_key){
return fluree.crypto.account_id_from_public.call(null,public_key);
}));

(flureenjs.account_id.cljs$core$IFn$_invoke$arity$2 = (function (message,signature){
return fluree.crypto.account_id_from_message.call(null,message,signature);
}));

(flureenjs.account_id.cljs$lang$maxFixedArity = 2);

/**
 * Takes an http request and creates an http signature using a private key
 */
flureenjs.http_signature = (function flureenjs$http_signature(var_args){
var G__68440 = arguments.length;
switch (G__68440) {
case 4:
return flureenjs.http_signature.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.http_signature.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.http_signature', flureenjs.http_signature);

(flureenjs.http_signature.cljs$core$IFn$_invoke$arity$4 = (function (req_method,url,request,private_key){
return flureenjs.http_signature.call(null,req_method,url,request,private_key,null);
}));

(flureenjs.http_signature.cljs$core$IFn$_invoke$arity$5 = (function (req_method,url,request,private_key,auth){
var request__$1 = cljs.core.js__GT_clj.call(null,request);
return fluree.db.query.http_signatures.sign_request.call(null,req_method,url,request__$1,private_key,auth);
}));

(flureenjs.http_signature.cljs$lang$maxFixedArity = 5);

/**
 * Returns a public key given a private key.
 */
flureenjs.public_key_from_private = (function flureenjs$public_key_from_private(private_key){
return fluree.crypto.pub_key_from_private.call(null,private_key);
});
goog.exportSymbol('flureenjs.public_key_from_private', flureenjs.public_key_from_private);
/**
 * Returns a public key from a message and a signature.
 */
flureenjs.public_key = (function flureenjs$public_key(message,signature){
return fluree.crypto.pub_key_from_message.call(null,message,signature);
});
goog.exportSymbol('flureenjs.public_key', flureenjs.public_key);
/**
 * Generates a private-public key pair using the Node.js
 *   crypto module. The JavaScript code looks like:
 * 
 *   const ecdh = crypto.createECDH('secp256k1');
 *   ecdh.generateKeys()
 *   return { private: ecdh.getPrivateKey('hex'),
 *            public:  ecdh.getPublicKey('hex','compressed')};
 *   
 */
flureenjs.generate_key_pair = (function flureenjs$generate_key_pair(){
if(cljs.core.truth_(flureenjs.njs_crypto)){
var ecdh = cljs.core.js_invoke.call(null,flureenjs.njs_crypto,"createECDH","secp256k1");
var _ = cljs.core.js_invoke.call(null,ecdh,"generateKeys");
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),cljs.core.js_invoke.call(null,ecdh,"getPrivateKey","hex"),new cljs.core.Keyword(null,"public","public",1566243851),cljs.core.js_invoke.call(null,ecdh,"getPublicKey","hex","compressed")], null);
} else {
throw "Node.js crypto module not accessible";
}
});
/**
 * Generates a new private key, returned in a map along with
 *   the public key and account id. Return keys are :public,
 *   :private, and :id.
 *   
 */
flureenjs.new_private_key = (function flureenjs$new_private_key(){
try{var kp = flureenjs.generate_key_pair.call(null);
var account = fluree.crypto.account_id_from_private.call(null,new cljs.core.Keyword(null,"private","private",-558947994).cljs$core$IFn$_invoke$arity$1(kp));
return cljs.core.assoc.call(null,kp,new cljs.core.Keyword(null,"id","id",-1388402092),account);
}catch (e68442){var e = e68442;
fluree.db.util.log.error.call(null,["Unable to generate private key. Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e)].join(''));

throw e;
}});
goog.exportSymbol('flureenjs.new_private_key', flureenjs.new_private_key);
/**
 * Returns a signature for a message given a private key.
 */
flureenjs.sign = (function flureenjs$sign(message,private_key){
return fluree.crypto.sign_message.call(null,message,private_key);
});
goog.exportSymbol('flureenjs.sign', flureenjs.sign);
/**
 * Sets a new default private key for the entire tx-group, network or db level.
 *   This will only succeed if signed by the default private key for the tx-group,
 *   or if setting for a dbid, either the tx-group or network.
 * 
 *   It will overwrite any existing default private key.
 * 
 *   It will respond with true or false.
 * 
 *   Returns promise that eventually contains the results. 
 */
flureenjs.set_default_key = (function flureenjs$set_default_key(var_args){
var G__68444 = arguments.length;
switch (G__68444) {
case 2:
return flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.set_default_key', flureenjs.set_default_key);

(flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$2 = (function (conn,private_key){
return flureenjs.set_default_key.call(null,conn,null,null,private_key,null);
}));

(flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$3 = (function (conn,network,private_key){
return flureenjs.set_default_key.call(null,conn,network,null,private_key,null);
}));

(flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,private_key){
return flureenjs.set_default_key.call(null,conn,network,dbid,private_key,null);
}));

(flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,private_key,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68500){
var state_val_68501 = (state_68500[(1)]);
if((state_val_68501 === (7))){
var inst_68459 = (state_68500[(7)]);
var state_68500__$1 = state_68500;
var statearr_68502_68543 = state_68500__$1;
(statearr_68502_68543[(2)] = inst_68459);

(statearr_68502_68543[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (20))){
var inst_68471 = (state_68500[(8)]);
var inst_68489 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_68471);
var state_68500__$1 = state_68500;
var statearr_68503_68544 = state_68500__$1;
(statearr_68503_68544[(2)] = inst_68489);

(statearr_68503_68544[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (1))){
var state_68500__$1 = state_68500;
var statearr_68504_68545 = state_68500__$1;
(statearr_68504_68545[(2)] = null);

(statearr_68504_68545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (4))){
var inst_68445 = (state_68500[(2)]);
var inst_68446 = fluree.db.util.log.error.call(null,inst_68445);
var inst_68447 = reject.call(null,inst_68445);
var state_68500__$1 = (function (){var statearr_68505 = state_68500;
(statearr_68505[(9)] = inst_68446);

return statearr_68505;
})();
var statearr_68506_68546 = state_68500__$1;
(statearr_68506_68546[(2)] = inst_68447);

(statearr_68506_68546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (15))){
var inst_68458 = (state_68500[(10)]);
var inst_68477 = (state_68500[(11)]);
var inst_68479 = fluree.crypto.sign_message.call(null,inst_68477,inst_68458);
var state_68500__$1 = state_68500;
var statearr_68507_68547 = state_68500__$1;
(statearr_68507_68547[(2)] = inst_68479);

(statearr_68507_68547[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (21))){
var inst_68491 = (state_68500[(2)]);
var state_68500__$1 = state_68500;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68500__$1,(18),inst_68491);
} else {
if((state_val_68501 === (13))){
var state_68500__$1 = state_68500;
var statearr_68508_68548 = state_68500__$1;
(statearr_68508_68548[(2)] = null);

(statearr_68508_68548[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (6))){
var inst_68456 = (state_68500[(12)]);
var state_68500__$1 = state_68500;
var statearr_68509_68549 = state_68500__$1;
(statearr_68509_68549[(2)] = inst_68456);

(statearr_68509_68549[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (17))){
var inst_68458 = (state_68500[(10)]);
var inst_68482 = (state_68500[(2)]);
var state_68500__$1 = (function (){var statearr_68510 = state_68500;
(statearr_68510[(13)] = inst_68482);

return statearr_68510;
})();
if(cljs.core.truth_(inst_68458)){
var statearr_68511_68550 = state_68500__$1;
(statearr_68511_68550[(1)] = (19));

} else {
var statearr_68512_68551 = state_68500__$1;
(statearr_68512_68551[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (3))){
var inst_68498 = (state_68500[(2)]);
var state_68500__$1 = state_68500;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68500__$1,inst_68498);
} else {
if((state_val_68501 === (12))){
var inst_68471 = (state_68500[(8)]);
var inst_68473 = fluree.db.util.core.without_nils.call(null,inst_68471);
var inst_68474 = fluree.db.util.json.stringify.call(null,inst_68473);
var state_68500__$1 = state_68500;
var statearr_68513_68552 = state_68500__$1;
(statearr_68513_68552[(2)] = inst_68474);

(statearr_68513_68552[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (2))){
var inst_68456 = (state_68500[(12)]);
var _ = (function (){var statearr_68514 = state_68500;
(statearr_68514[(4)] = cljs.core.cons.call(null,(5),(state_68500[(4)])));

return statearr_68514;
})();
var inst_68454 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_68455 = cljs.core.__destructure_map.call(null,inst_68454);
var inst_68456__$1 = cljs.core.get.call(null,inst_68455,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_68457 = cljs.core.get.call(null,inst_68455,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_68458 = cljs.core.get.call(null,inst_68455,new cljs.core.Keyword(null,"signing-key","signing-key",1285642632));
var inst_68459 = fluree.db.util.core.current_time_millis.call(null);
var state_68500__$1 = (function (){var statearr_68515 = state_68500;
(statearr_68515[(10)] = inst_68458);

(statearr_68515[(7)] = inst_68459);

(statearr_68515[(12)] = inst_68456__$1);

(statearr_68515[(14)] = inst_68457);

return statearr_68515;
})();
if(cljs.core.truth_(inst_68456__$1)){
var statearr_68516_68553 = state_68500__$1;
(statearr_68516_68553[(1)] = (6));

} else {
var statearr_68517_68554 = state_68500__$1;
(statearr_68517_68554[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (19))){
var inst_68482 = (state_68500[(13)]);
var inst_68477 = (state_68500[(11)]);
var inst_68484 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_68485 = [inst_68477,inst_68482];
var inst_68486 = cljs.core.PersistentHashMap.fromArrays(inst_68484,inst_68485);
var inst_68487 = fluree.db.operations.command_async.call(null,conn,inst_68486);
var state_68500__$1 = state_68500;
var statearr_68518_68555 = state_68500__$1;
(statearr_68518_68555[(2)] = inst_68487);

(statearr_68518_68555[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (11))){
var inst_68458 = (state_68500[(10)]);
var inst_68463 = (state_68500[(15)]);
var inst_68468 = (state_68500[(2)]);
var inst_68469 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"private-key","private-key",426483388),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_68470 = [new cljs.core.Keyword(null,"default-key","default-key",-2094960617),network,dbid,private_key,inst_68463,inst_68468];
var inst_68471 = cljs.core.PersistentHashMap.fromArrays(inst_68469,inst_68470);
var state_68500__$1 = (function (){var statearr_68520 = state_68500;
(statearr_68520[(8)] = inst_68471);

return statearr_68520;
})();
if(cljs.core.truth_(inst_68458)){
var statearr_68521_68556 = state_68500__$1;
(statearr_68521_68556[(1)] = (12));

} else {
var statearr_68522_68557 = state_68500__$1;
(statearr_68522_68557[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (9))){
var inst_68457 = (state_68500[(14)]);
var state_68500__$1 = state_68500;
var statearr_68523_68558 = state_68500__$1;
(statearr_68523_68558[(2)] = inst_68457);

(statearr_68523_68558[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (5))){
var _ = (function (){var statearr_68524 = state_68500;
(statearr_68524[(4)] = cljs.core.rest.call(null,(state_68500[(4)])));

return statearr_68524;
})();
var state_68500__$1 = state_68500;
var ex68519 = (state_68500__$1[(2)]);
var statearr_68525_68559 = state_68500__$1;
(statearr_68525_68559[(5)] = ex68519);


var statearr_68526_68560 = state_68500__$1;
(statearr_68526_68560[(1)] = (4));

(statearr_68526_68560[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (14))){
var inst_68458 = (state_68500[(10)]);
var inst_68477 = (state_68500[(2)]);
var state_68500__$1 = (function (){var statearr_68527 = state_68500;
(statearr_68527[(11)] = inst_68477);

return statearr_68527;
})();
if(cljs.core.truth_(inst_68458)){
var statearr_68528_68561 = state_68500__$1;
(statearr_68528_68561[(1)] = (15));

} else {
var statearr_68529_68562 = state_68500__$1;
(statearr_68529_68562[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (16))){
var state_68500__$1 = state_68500;
var statearr_68530_68563 = state_68500__$1;
(statearr_68530_68563[(2)] = null);

(statearr_68530_68563[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (10))){
var inst_68459 = (state_68500[(7)]);
var inst_68466 = (inst_68459 + (30000));
var state_68500__$1 = state_68500;
var statearr_68531_68564 = state_68500__$1;
(statearr_68531_68564[(2)] = inst_68466);

(statearr_68531_68564[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (18))){
var inst_68493 = (state_68500[(2)]);
var inst_68494 = cljs.core.clj__GT_js.call(null,inst_68493);
var inst_68495 = resolve.call(null,inst_68494);
var _ = (function (){var statearr_68532 = state_68500;
(statearr_68532[(4)] = cljs.core.rest.call(null,(state_68500[(4)])));

return statearr_68532;
})();
var state_68500__$1 = state_68500;
var statearr_68533_68565 = state_68500__$1;
(statearr_68533_68565[(2)] = inst_68495);

(statearr_68533_68565[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68501 === (8))){
var inst_68457 = (state_68500[(14)]);
var inst_68463 = (state_68500[(2)]);
var state_68500__$1 = (function (){var statearr_68534 = state_68500;
(statearr_68534[(15)] = inst_68463);

return statearr_68534;
})();
if(cljs.core.truth_(inst_68457)){
var statearr_68535_68566 = state_68500__$1;
(statearr_68535_68566[(1)] = (9));

} else {
var statearr_68536_68567 = state_68500__$1;
(statearr_68536_68567[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_68537 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68537[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_68537[(1)] = (1));

return statearr_68537;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_68500){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68500);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68538){var ex__2729__auto__ = e68538;
var statearr_68539_68568 = state_68500;
(statearr_68539_68568[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68500[(4)]))){
var statearr_68540_68569 = state_68500;
(statearr_68540_68569[(1)] = cljs.core.first.call(null,(state_68500[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68570 = state_68500;
state_68500 = G__68570;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_68500){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_68500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68541 = f__2749__auto__.call(null);
(statearr_68541[(6)] = c__2748__auto__);

return statearr_68541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.set_default_key.cljs$lang$maxFixedArity = 5);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureenjs.connect = (function flureenjs$connect(var_args){
var args__4835__auto__ = [];
var len__4829__auto___68577 = arguments.length;
var i__4830__auto___68578 = (0);
while(true){
if((i__4830__auto___68578 < len__4829__auto___68577)){
args__4835__auto__.push((arguments[i__4830__auto___68578]));

var G__68579 = (i__4830__auto___68578 + (1));
i__4830__auto___68578 = G__68579;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});
goog.exportSymbol('flureenjs.connect', flureenjs.connect);

(flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers_string,p__68573){
var vec__68574 = p__68573;
var opts = cljs.core.nth.call(null,vec__68574,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect.call(null,servers_string,clj_opts);
}));

(flureenjs.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(flureenjs.connect.cljs$lang$applyTo = (function (seq68571){
var G__68572 = cljs.core.first.call(null,seq68571);
var seq68571__$1 = cljs.core.next.call(null,seq68571);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68572,seq68571__$1);
}));

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * Returns a promise that eventually contains the connection object.
 */
flureenjs.connect_p = (function flureenjs$connect_p(var_args){
var args__4835__auto__ = [];
var len__4829__auto___68586 = arguments.length;
var i__4830__auto___68587 = (0);
while(true){
if((i__4830__auto___68587 < len__4829__auto___68586)){
args__4835__auto__.push((arguments[i__4830__auto___68587]));

var G__68588 = (i__4830__auto___68587 + (1));
i__4830__auto___68587 = G__68588;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return flureenjs.connect_p.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});
goog.exportSymbol('flureenjs.connect_p', flureenjs.connect_p);

(flureenjs.connect_p.cljs$core$IFn$_invoke$arity$variadic = (function (servers_string,p__68582){
var vec__68583 = p__68582;
var opts = cljs.core.nth.call(null,vec__68583,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect_p.call(null,servers_string,clj_opts);
}));

(flureenjs.connect_p.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(flureenjs.connect_p.cljs$lang$applyTo = (function (seq68580){
var G__68581 = cljs.core.first.call(null,seq68580);
var seq68580__$1 = cljs.core.next.call(null,seq68580);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68581,seq68580__$1);
}));

/**
 * Closes a connection
 */
flureenjs.close = (function flureenjs$close(conn){
return fluree.db.connection_js.close.call(null,conn);
});
goog.exportSymbol('flureenjs.close', flureenjs.close);
/**
 * Attempts to generate a new user auth record account.
 * 
 *   Returns a promise that eventually contains the token or an exception.
 */
flureenjs.password_generate = (function flureenjs$password_generate(var_args){
var G__68590 = arguments.length;
switch (G__68590) {
case 4:
return flureenjs.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.password_generate', flureenjs.password_generate);

(flureenjs.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureenjs.password_generate.call(null,conn,ledger,password,user,null);
}));

(flureenjs.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var data = cljs.core.assoc.call(null,cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true),new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate.call(null,conn,ledger,password,data);
}));

(flureenjs.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 * 
 *   Returns a promise that eventually contains the token or an exception.
 */
flureenjs.password_login = (function flureenjs$password_login(var_args){
var G__68593 = arguments.length;
switch (G__68593) {
case 4:
return flureenjs.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureenjs.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.password_login', flureenjs.password_login);

(flureenjs.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user);
}));

(flureenjs.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,auth,expire);
}));

(flureenjs.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureenjs.renew_token = (function flureenjs$renew_token(var_args){
var G__68596 = arguments.length;
switch (G__68596) {
case 2:
return flureenjs.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.renew_token', flureenjs.renew_token);

(flureenjs.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(flureenjs.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,expire);
}));

(flureenjs.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Takes block event data from (listen...) and adds an :added and
 *   :retracted key containing maps of data organized by subject
 *   and containing full predicate names.
 */
flureenjs.block_event__GT_map = (function flureenjs$block_event__GT_map(conn,ledger,block_event){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68627){
var state_val_68628 = (state_68627[(1)]);
if((state_val_68628 === (1))){
var state_68627__$1 = state_68627;
var statearr_68629_68644 = state_68627__$1;
(statearr_68629_68644[(2)] = null);

(statearr_68629_68644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68628 === (2))){
var _ = (function (){var statearr_68630 = state_68627;
(statearr_68630[(4)] = cljs.core.cons.call(null,(5),(state_68627[(4)])));

return statearr_68630;
})();
var inst_68608 = flureenjs.db_instance.call(null,conn,ledger);
var state_68627__$1 = state_68627;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68627__$1,(6),inst_68608);
} else {
if((state_val_68628 === (3))){
var inst_68625 = (state_68627[(2)]);
var state_68627__$1 = state_68627;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68627__$1,inst_68625);
} else {
if((state_val_68628 === (4))){
var inst_68599 = (state_68627[(2)]);
var inst_68600 = fluree.db.util.log.error.call(null,inst_68599);
var inst_68601 = reject.call(null,inst_68599);
var state_68627__$1 = (function (){var statearr_68632 = state_68627;
(statearr_68632[(7)] = inst_68600);

return statearr_68632;
})();
var statearr_68633_68645 = state_68627__$1;
(statearr_68633_68645[(2)] = inst_68601);

(statearr_68633_68645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68628 === (5))){
var _ = (function (){var statearr_68634 = state_68627;
(statearr_68634[(4)] = cljs.core.rest.call(null,(state_68627[(4)])));

return statearr_68634;
})();
var state_68627__$1 = state_68627;
var ex68631 = (state_68627__$1[(2)]);
var statearr_68635_68646 = state_68627__$1;
(statearr_68635_68646[(5)] = ex68631);


var statearr_68636_68647 = state_68627__$1;
(statearr_68636_68647[(1)] = (4));

(statearr_68636_68647[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68628 === (6))){
var inst_68610 = (state_68627[(2)]);
var inst_68611 = fluree.db.util.async.throw_err.call(null,inst_68610);
var inst_68612 = (function (){var db = inst_68611;
return (function (p1__68598_SHARP_){
return cljs.core.nth.call(null,p1__68598_SHARP_,(4));
});
})();
var inst_68613 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block_event);
var inst_68614 = cljs.core.group_by.call(null,inst_68612,inst_68613);
var inst_68615 = cljs.core.__destructure_map.call(null,inst_68614);
var inst_68616 = cljs.core.get.call(null,inst_68615,true);
var inst_68617 = cljs.core.get.call(null,inst_68615,false);
var inst_68618 = (function (){var db = inst_68611;
var map__68607 = inst_68615;
var add = inst_68616;
var retract = inst_68617;
return (function (flakes){
var by_subj = cljs.core.group_by.call(null,cljs.core.first,flakes);
return cljs.core.reduce_kv.call(null,(function (acc,sid,flakes__$1){
return cljs.core.conj.call(null,acc,cljs.core.reduce.call(null,(function (m,flake){
var p_schema = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"pred","pred",1927423397),cljs.core.second.call(null,flake)], null));
var v = cljs.core.nth.call(null,flake,(2));
if(cljs.core.truth_(new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(p_schema))){
return cljs.core.update.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),cljs.core.conj,v);
} else {
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),v);
}
}),new cljs.core.PersistentArrayMap(null, 1, ["_id",sid], null),flakes__$1));
}),cljs.core.PersistentVector.EMPTY,by_subj);
});
})();
var inst_68619 = inst_68618.call(null,inst_68616);
var inst_68620 = inst_68618.call(null,inst_68617);
var inst_68621 = cljs.core.assoc.call(null,block_event,new cljs.core.Keyword(null,"added","added",2057651688),inst_68619,new cljs.core.Keyword(null,"retracted","retracted",-1399687854),inst_68620);
var inst_68622 = resolve.call(null,inst_68621);
var _ = (function (){var statearr_68637 = state_68627;
(statearr_68637[(4)] = cljs.core.rest.call(null,(state_68627[(4)])));

return statearr_68637;
})();
var state_68627__$1 = state_68627;
var statearr_68638_68648 = state_68627__$1;
(statearr_68638_68648[(2)] = inst_68622);

(statearr_68638_68648[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$block_event__GT_map_$_state_machine__2726__auto__ = null;
var flureenjs$block_event__GT_map_$_state_machine__2726__auto____0 = (function (){
var statearr_68639 = [null,null,null,null,null,null,null,null];
(statearr_68639[(0)] = flureenjs$block_event__GT_map_$_state_machine__2726__auto__);

(statearr_68639[(1)] = (1));

return statearr_68639;
});
var flureenjs$block_event__GT_map_$_state_machine__2726__auto____1 = (function (state_68627){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68627);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68640){var ex__2729__auto__ = e68640;
var statearr_68641_68649 = state_68627;
(statearr_68641_68649[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68627[(4)]))){
var statearr_68642_68650 = state_68627;
(statearr_68642_68650[(1)] = cljs.core.first.call(null,(state_68627[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68651 = state_68627;
state_68627 = G__68651;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$block_event__GT_map_$_state_machine__2726__auto__ = function(state_68627){
switch(arguments.length){
case 0:
return flureenjs$block_event__GT_map_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$block_event__GT_map_$_state_machine__2726__auto____1.call(this,state_68627);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$block_event__GT_map_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$block_event__GT_map_$_state_machine__2726__auto____0;
flureenjs$block_event__GT_map_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$block_event__GT_map_$_state_machine__2726__auto____1;
return flureenjs$block_event__GT_map_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68643 = f__2749__auto__.call(null);
(statearr_68643[(6)] = c__2748__auto__);

return statearr_68643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureenjs.listen = (function flureenjs$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen.call(null,conn,ledger,key,callback);
});
goog.exportSymbol('flureenjs.listen', flureenjs.listen);
/**
 * Closes a listener.
 */
flureenjs.close_listener = (function flureenjs$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener.call(null,conn,ledger,key);
});
goog.exportSymbol('flureenjs.close_listener', flureenjs.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureenjs.listeners = (function flureenjs$listeners(conn){
return fluree.db.connection_js.listeners.call(null,conn);
});
goog.exportSymbol('flureenjs.listeners', flureenjs.listeners);
/**
 * Returns a queryable database from the connection.
 */
flureenjs.db_instance = (function flureenjs$db_instance(var_args){
var G__68653 = arguments.length;
switch (G__68653) {
case 2:
return flureenjs.db_instance.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.db_instance.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs.db_instance.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.db_instance.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.db_instance.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2748__auto___68726 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68699){
var state_val_68700 = (state_68699[(1)]);
if((state_val_68700 === (7))){
var inst_68670 = (state_68699[(7)]);
var state_68699__$1 = state_68699;
if(cljs.core.truth_(inst_68670)){
var statearr_68701_68727 = state_68699__$1;
(statearr_68701_68727[(1)] = (9));

} else {
var statearr_68702_68728 = state_68699__$1;
(statearr_68702_68728[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68700 === (1))){
var state_68699__$1 = state_68699;
var statearr_68703_68729 = state_68699__$1;
(statearr_68703_68729[(2)] = null);

(statearr_68703_68729[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68700 === (4))){
var inst_68654 = (state_68699[(2)]);
var inst_68655 = fluree.db.util.log.error.call(null,inst_68654);
var inst_68656 = cljs.core.async.put_BANG_.call(null,pc,inst_68654);
var inst_68657 = cljs.core.async.close_BANG_.call(null,pc);
var state_68699__$1 = (function (){var statearr_68704 = state_68699;
(statearr_68704[(8)] = inst_68656);

(statearr_68704[(9)] = inst_68655);

return statearr_68704;
})();
var statearr_68705_68730 = state_68699__$1;
(statearr_68705_68730[(2)] = inst_68657);

(statearr_68705_68730[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68700 === (6))){
var inst_68669 = (state_68699[(10)]);
var state_68699__$1 = state_68699;
var statearr_68706_68731 = state_68699__$1;
(statearr_68706_68731[(2)] = inst_68669);

(statearr_68706_68731[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68700 === (3))){
var inst_68697 = (state_68699[(2)]);
var state_68699__$1 = state_68699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68699__$1,inst_68697);
} else {
if((state_val_68700 === (12))){
var inst_68673 = (state_68699[(11)]);
var inst_68674 = (state_68699[(12)]);
var inst_68691 = (state_68699[(2)]);
var inst_68692 = fluree.db.util.async.throw_err.call(null,inst_68691);
var inst_68693 = cljs.core.assoc.call(null,inst_68692,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_68673,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_68674);
var inst_68694 = cljs.core.async.put_BANG_.call(null,pc,inst_68693);
var _ = (function (){var statearr_68707 = state_68699;
(statearr_68707[(4)] = cljs.core.rest.call(null,(state_68699[(4)])));

return statearr_68707;
})();
var state_68699__$1 = state_68699;
var statearr_68708_68732 = state_68699__$1;
(statearr_68708_68732[(2)] = inst_68694);

(statearr_68708_68732[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68700 === (2))){
var inst_68669 = (state_68699[(10)]);
var _ = (function (){var statearr_68709 = state_68699;
(statearr_68709[(4)] = cljs.core.cons.call(null,(5),(state_68699[(4)])));

return statearr_68709;
})();
var inst_68667 = opts;
var inst_68668 = cljs.core.__destructure_map.call(null,inst_68667);
var inst_68669__$1 = cljs.core.get.call(null,inst_68668,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_68670 = cljs.core.get.call(null,inst_68668,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_68671 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_68672 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_68673 = cljs.core.nth.call(null,inst_68672,(0),null);
var inst_68674 = cljs.core.nth.call(null,inst_68672,(1),null);
var state_68699__$1 = (function (){var statearr_68710 = state_68699;
(statearr_68710[(7)] = inst_68670);

(statearr_68710[(10)] = inst_68669__$1);

(statearr_68710[(11)] = inst_68673);

(statearr_68710[(13)] = inst_68671);

(statearr_68710[(12)] = inst_68674);

return statearr_68710;
})();
if(cljs.core.truth_(inst_68669__$1)){
var statearr_68711_68733 = state_68699__$1;
(statearr_68711_68733[(1)] = (6));

} else {
var statearr_68712_68734 = state_68699__$1;
(statearr_68712_68734[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68700 === (11))){
var inst_68685 = (state_68699[(2)]);
var state_68699__$1 = state_68699;
var statearr_68714_68735 = state_68699__$1;
(statearr_68714_68735[(2)] = inst_68685);

(statearr_68714_68735[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68700 === (9))){
var inst_68670 = (state_68699[(7)]);
var inst_68678 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68679 = fluree.db.connection_js.validate_token.call(null,conn,inst_68670);
var inst_68680 = new cljs.core.Keyword(null,"sub","sub",-2093760025).cljs$core$IFn$_invoke$arity$1(inst_68679);
var inst_68681 = ["_auth/id",inst_68680];
var inst_68682 = (new cljs.core.PersistentVector(null,2,(5),inst_68678,inst_68681,null));
var state_68699__$1 = state_68699;
var statearr_68715_68736 = state_68699__$1;
(statearr_68715_68736[(2)] = inst_68682);

(statearr_68715_68736[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68700 === (5))){
var _ = (function (){var statearr_68716 = state_68699;
(statearr_68716[(4)] = cljs.core.rest.call(null,(state_68699[(4)])));

return statearr_68716;
})();
var state_68699__$1 = state_68699;
var ex68713 = (state_68699__$1[(2)]);
var statearr_68717_68737 = state_68699__$1;
(statearr_68717_68737[(5)] = ex68713);


var statearr_68718_68738 = state_68699__$1;
(statearr_68718_68738[(1)] = (4));

(statearr_68718_68738[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68700 === (10))){
var state_68699__$1 = state_68699;
var statearr_68719_68739 = state_68699__$1;
(statearr_68719_68739[(2)] = null);

(statearr_68719_68739[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68700 === (8))){
var inst_68687 = (state_68699[(2)]);
var inst_68688 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_68687);
var inst_68689 = fluree.db.api.ledger.db.call(null,conn,ledger,inst_68688);
var state_68699__$1 = state_68699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68699__$1,(12),inst_68689);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_68720 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68720[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_68720[(1)] = (1));

return statearr_68720;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_68699){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68721){var ex__2729__auto__ = e68721;
var statearr_68722_68740 = state_68699;
(statearr_68722_68740[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68699[(4)]))){
var statearr_68723_68741 = state_68699;
(statearr_68723_68741[(1)] = cljs.core.first.call(null,(state_68699[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68742 = state_68699;
state_68699 = G__68742;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_68699){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_68699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68724 = f__2749__auto__.call(null);
(statearr_68724[(6)] = c__2748__auto___68726);

return statearr_68724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return pc;
}));

(flureenjs.db_instance.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db = (function flureenjs$db(var_args){
var args__4835__auto__ = [];
var len__4829__auto___68750 = arguments.length;
var i__4830__auto___68751 = (0);
while(true){
if((i__4830__auto___68751 < len__4829__auto___68750)){
args__4835__auto__.push((arguments[i__4830__auto___68751]));

var G__68752 = (i__4830__auto___68751 + (1));
i__4830__auto___68751 = G__68752;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return flureenjs.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});
goog.exportSymbol('flureenjs.db', flureenjs.db);

(flureenjs.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__68746){
var vec__68747 = p__68746;
var opts = cljs.core.nth.call(null,vec__68747,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return flureenjs.db_instance.call(null,conn,ledger,clj_opts);
}));

(flureenjs.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db.cljs$lang$applyTo = (function (seq68743){
var G__68744 = cljs.core.first.call(null,seq68743);
var seq68743__$1 = cljs.core.next.call(null,seq68743);
var G__68745 = cljs.core.first.call(null,seq68743__$1);
var seq68743__$2 = cljs.core.next.call(null,seq68743__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68744,G__68745,seq68743__$2);
}));

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db_p = (function flureenjs$db_p(var_args){
var args__4835__auto__ = [];
var len__4829__auto___68792 = arguments.length;
var i__4830__auto___68793 = (0);
while(true){
if((i__4830__auto___68793 < len__4829__auto___68792)){
args__4835__auto__.push((arguments[i__4830__auto___68793]));

var G__68794 = (i__4830__auto___68793 + (1));
i__4830__auto___68793 = G__68794;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return flureenjs.db_p.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});
goog.exportSymbol('flureenjs.db_p', flureenjs.db_p);

(flureenjs.db_p.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__68756){
var vec__68757 = p__68756;
var opts = cljs.core.nth.call(null,vec__68757,(0),null);
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68775){
var state_val_68776 = (state_68775[(1)]);
if((state_val_68776 === (1))){
var state_68775__$1 = state_68775;
var statearr_68777_68795 = state_68775__$1;
(statearr_68777_68795[(2)] = null);

(statearr_68777_68795[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68776 === (2))){
var _ = (function (){var statearr_68778 = state_68775;
(statearr_68778[(4)] = cljs.core.cons.call(null,(5),(state_68775[(4)])));

return statearr_68778;
})();
var inst_68768 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_68769 = flureenjs.db_instance.call(null,conn,ledger,inst_68768);
var inst_68770 = resolve.call(null,inst_68769);
var ___$1 = (function (){var statearr_68779 = state_68775;
(statearr_68779[(4)] = cljs.core.rest.call(null,(state_68775[(4)])));

return statearr_68779;
})();
var state_68775__$1 = state_68775;
var statearr_68780_68796 = state_68775__$1;
(statearr_68780_68796[(2)] = inst_68770);

(statearr_68780_68796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68776 === (3))){
var inst_68773 = (state_68775[(2)]);
var state_68775__$1 = state_68775;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68775__$1,inst_68773);
} else {
if((state_val_68776 === (4))){
var inst_68760 = (state_68775[(2)]);
var inst_68761 = fluree.db.util.log.error.call(null,inst_68760);
var inst_68762 = reject.call(null,inst_68760);
var state_68775__$1 = (function (){var statearr_68782 = state_68775;
(statearr_68782[(7)] = inst_68761);

return statearr_68782;
})();
var statearr_68783_68797 = state_68775__$1;
(statearr_68783_68797[(2)] = inst_68762);

(statearr_68783_68797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68776 === (5))){
var _ = (function (){var statearr_68784 = state_68775;
(statearr_68784[(4)] = cljs.core.rest.call(null,(state_68775[(4)])));

return statearr_68784;
})();
var state_68775__$1 = state_68775;
var ex68781 = (state_68775__$1[(2)]);
var statearr_68785_68798 = state_68775__$1;
(statearr_68785_68798[(5)] = ex68781);


var statearr_68786_68799 = state_68775__$1;
(statearr_68786_68799[(1)] = (4));

(statearr_68786_68799[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_68787 = [null,null,null,null,null,null,null,null];
(statearr_68787[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_68787[(1)] = (1));

return statearr_68787;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_68775){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68775);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68788){var ex__2729__auto__ = e68788;
var statearr_68789_68800 = state_68775;
(statearr_68789_68800[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68775[(4)]))){
var statearr_68790_68801 = state_68775;
(statearr_68790_68801[(1)] = cljs.core.first.call(null,(state_68775[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68802 = state_68775;
state_68775 = G__68802;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_68775){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_68775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68791 = f__2749__auto__.call(null);
(statearr_68791[(6)] = c__2748__auto__);

return statearr_68791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.db_p.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db_p.cljs$lang$applyTo = (function (seq68753){
var G__68754 = cljs.core.first.call(null,seq68753);
var seq68753__$1 = cljs.core.next.call(null,seq68753);
var G__68755 = cljs.core.first.call(null,seq68753__$1);
var seq68753__$2 = cljs.core.next.call(null,seq68753__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__68754,G__68755,seq68753__$2);
}));

/**
 * Returns promise containing collection id given a collection name.
 *   If collection doesn't exist, returns nil.
 */
flureenjs.collection_id = (function flureenjs$collection_id(db,collection){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68822){
var state_val_68823 = (state_68822[(1)]);
if((state_val_68823 === (1))){
var state_68822__$1 = state_68822;
var statearr_68824_68840 = state_68822__$1;
(statearr_68824_68840[(2)] = null);

(statearr_68824_68840[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68823 === (2))){
var _ = (function (){var statearr_68825 = state_68822;
(statearr_68825[(4)] = cljs.core.cons.call(null,(5),(state_68822[(4)])));

return statearr_68825;
})();
var inst_68811 = cljs.core.js__GT_clj.call(null,collection,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_68822__$1 = (function (){var statearr_68826 = state_68822;
(statearr_68826[(7)] = inst_68811);

return statearr_68826;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68822__$1,(6),db);
} else {
if((state_val_68823 === (3))){
var inst_68820 = (state_68822[(2)]);
var state_68822__$1 = state_68822;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68822__$1,inst_68820);
} else {
if((state_val_68823 === (4))){
var inst_68803 = (state_68822[(2)]);
var inst_68804 = fluree.db.util.log.error.call(null,inst_68803);
var inst_68805 = reject.call(null,inst_68803);
var state_68822__$1 = (function (){var statearr_68828 = state_68822;
(statearr_68828[(8)] = inst_68804);

return statearr_68828;
})();
var statearr_68829_68841 = state_68822__$1;
(statearr_68829_68841[(2)] = inst_68805);

(statearr_68829_68841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68823 === (5))){
var _ = (function (){var statearr_68830 = state_68822;
(statearr_68830[(4)] = cljs.core.rest.call(null,(state_68822[(4)])));

return statearr_68830;
})();
var state_68822__$1 = state_68822;
var ex68827 = (state_68822__$1[(2)]);
var statearr_68831_68842 = state_68822__$1;
(statearr_68831_68842[(5)] = ex68827);


var statearr_68832_68843 = state_68822__$1;
(statearr_68832_68843[(1)] = (4));

(statearr_68832_68843[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68823 === (6))){
var inst_68811 = (state_68822[(7)]);
var inst_68813 = (state_68822[(2)]);
var inst_68814 = fluree.db.util.async.throw_err.call(null,inst_68813);
var inst_68815 = fluree.db.dbproto._c_prop.call(null,inst_68814,new cljs.core.Keyword(null,"id","id",-1388402092),inst_68811);
var inst_68816 = cljs.core.clj__GT_js.call(null,inst_68815);
var inst_68817 = resolve.call(null,inst_68816);
var _ = (function (){var statearr_68833 = state_68822;
(statearr_68833[(4)] = cljs.core.rest.call(null,(state_68822[(4)])));

return statearr_68833;
})();
var state_68822__$1 = state_68822;
var statearr_68834_68844 = state_68822__$1;
(statearr_68834_68844[(2)] = inst_68817);

(statearr_68834_68844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$collection_id_$_state_machine__2726__auto__ = null;
var flureenjs$collection_id_$_state_machine__2726__auto____0 = (function (){
var statearr_68835 = [null,null,null,null,null,null,null,null,null];
(statearr_68835[(0)] = flureenjs$collection_id_$_state_machine__2726__auto__);

(statearr_68835[(1)] = (1));

return statearr_68835;
});
var flureenjs$collection_id_$_state_machine__2726__auto____1 = (function (state_68822){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68822);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68836){var ex__2729__auto__ = e68836;
var statearr_68837_68845 = state_68822;
(statearr_68837_68845[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68822[(4)]))){
var statearr_68838_68846 = state_68822;
(statearr_68838_68846[(1)] = cljs.core.first.call(null,(state_68822[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68847 = state_68822;
state_68822 = G__68847;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$collection_id_$_state_machine__2726__auto__ = function(state_68822){
switch(arguments.length){
case 0:
return flureenjs$collection_id_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$collection_id_$_state_machine__2726__auto____1.call(this,state_68822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collection_id_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collection_id_$_state_machine__2726__auto____0;
flureenjs$collection_id_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collection_id_$_state_machine__2726__auto____1;
return flureenjs$collection_id_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68839 = f__2749__auto__.call(null);
(statearr_68839[(6)] = c__2748__auto__);

return statearr_68839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.collection_id', flureenjs.collection_id);
/**
 * Returns promise containing predicate id given a predicate.
 *   If predicate doesn't exist, returns nil.
 */
flureenjs.predicate_id = (function flureenjs$predicate_id(db,predicate){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68867){
var state_val_68868 = (state_68867[(1)]);
if((state_val_68868 === (1))){
var state_68867__$1 = state_68867;
var statearr_68869_68885 = state_68867__$1;
(statearr_68869_68885[(2)] = null);

(statearr_68869_68885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68868 === (2))){
var _ = (function (){var statearr_68870 = state_68867;
(statearr_68870[(4)] = cljs.core.cons.call(null,(5),(state_68867[(4)])));

return statearr_68870;
})();
var inst_68856 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_68867__$1 = (function (){var statearr_68871 = state_68867;
(statearr_68871[(7)] = inst_68856);

return statearr_68871;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68867__$1,(6),db);
} else {
if((state_val_68868 === (3))){
var inst_68865 = (state_68867[(2)]);
var state_68867__$1 = state_68867;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68867__$1,inst_68865);
} else {
if((state_val_68868 === (4))){
var inst_68848 = (state_68867[(2)]);
var inst_68849 = fluree.db.util.log.error.call(null,inst_68848);
var inst_68850 = reject.call(null,inst_68848);
var state_68867__$1 = (function (){var statearr_68873 = state_68867;
(statearr_68873[(8)] = inst_68849);

return statearr_68873;
})();
var statearr_68874_68886 = state_68867__$1;
(statearr_68874_68886[(2)] = inst_68850);

(statearr_68874_68886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68868 === (5))){
var _ = (function (){var statearr_68875 = state_68867;
(statearr_68875[(4)] = cljs.core.rest.call(null,(state_68867[(4)])));

return statearr_68875;
})();
var state_68867__$1 = state_68867;
var ex68872 = (state_68867__$1[(2)]);
var statearr_68876_68887 = state_68867__$1;
(statearr_68876_68887[(5)] = ex68872);


var statearr_68877_68888 = state_68867__$1;
(statearr_68877_68888[(1)] = (4));

(statearr_68877_68888[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68868 === (6))){
var inst_68856 = (state_68867[(7)]);
var inst_68858 = (state_68867[(2)]);
var inst_68859 = fluree.db.util.async.throw_err.call(null,inst_68858);
var inst_68860 = fluree.db.dbproto._p_prop.call(null,inst_68859,new cljs.core.Keyword(null,"id","id",-1388402092),inst_68856);
var inst_68861 = cljs.core.clj__GT_js.call(null,inst_68860);
var inst_68862 = resolve.call(null,inst_68861);
var _ = (function (){var statearr_68878 = state_68867;
(statearr_68878[(4)] = cljs.core.rest.call(null,(state_68867[(4)])));

return statearr_68878;
})();
var state_68867__$1 = state_68867;
var statearr_68879_68889 = state_68867__$1;
(statearr_68879_68889[(2)] = inst_68862);

(statearr_68879_68889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicate_id_$_state_machine__2726__auto__ = null;
var flureenjs$predicate_id_$_state_machine__2726__auto____0 = (function (){
var statearr_68880 = [null,null,null,null,null,null,null,null,null];
(statearr_68880[(0)] = flureenjs$predicate_id_$_state_machine__2726__auto__);

(statearr_68880[(1)] = (1));

return statearr_68880;
});
var flureenjs$predicate_id_$_state_machine__2726__auto____1 = (function (state_68867){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68867);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68881){var ex__2729__auto__ = e68881;
var statearr_68882_68890 = state_68867;
(statearr_68882_68890[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68867[(4)]))){
var statearr_68883_68891 = state_68867;
(statearr_68883_68891[(1)] = cljs.core.first.call(null,(state_68867[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68892 = state_68867;
state_68867 = G__68892;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$predicate_id_$_state_machine__2726__auto__ = function(state_68867){
switch(arguments.length){
case 0:
return flureenjs$predicate_id_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$predicate_id_$_state_machine__2726__auto____1.call(this,state_68867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicate_id_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicate_id_$_state_machine__2726__auto____0;
flureenjs$predicate_id_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicate_id_$_state_machine__2726__auto____1;
return flureenjs$predicate_id_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68884 = f__2749__auto__.call(null);
(statearr_68884[(6)] = c__2748__auto__);

return statearr_68884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.predicate_id', flureenjs.predicate_id);
/**
 * Returns promise containing predicate name given a predicate.
 *   If predicate doesn't exist, returns nil.
 */
flureenjs.predicate_name = (function flureenjs$predicate_name(db,predicate){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68912){
var state_val_68913 = (state_68912[(1)]);
if((state_val_68913 === (1))){
var state_68912__$1 = state_68912;
var statearr_68914_68930 = state_68912__$1;
(statearr_68914_68930[(2)] = null);

(statearr_68914_68930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68913 === (2))){
var _ = (function (){var statearr_68915 = state_68912;
(statearr_68915[(4)] = cljs.core.cons.call(null,(5),(state_68912[(4)])));

return statearr_68915;
})();
var inst_68901 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_68912__$1 = (function (){var statearr_68916 = state_68912;
(statearr_68916[(7)] = inst_68901);

return statearr_68916;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68912__$1,(6),db);
} else {
if((state_val_68913 === (3))){
var inst_68910 = (state_68912[(2)]);
var state_68912__$1 = state_68912;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68912__$1,inst_68910);
} else {
if((state_val_68913 === (4))){
var inst_68893 = (state_68912[(2)]);
var inst_68894 = fluree.db.util.log.error.call(null,inst_68893);
var inst_68895 = reject.call(null,inst_68893);
var state_68912__$1 = (function (){var statearr_68918 = state_68912;
(statearr_68918[(8)] = inst_68894);

return statearr_68918;
})();
var statearr_68919_68931 = state_68912__$1;
(statearr_68919_68931[(2)] = inst_68895);

(statearr_68919_68931[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68913 === (5))){
var _ = (function (){var statearr_68920 = state_68912;
(statearr_68920[(4)] = cljs.core.rest.call(null,(state_68912[(4)])));

return statearr_68920;
})();
var state_68912__$1 = state_68912;
var ex68917 = (state_68912__$1[(2)]);
var statearr_68921_68932 = state_68912__$1;
(statearr_68921_68932[(5)] = ex68917);


var statearr_68922_68933 = state_68912__$1;
(statearr_68922_68933[(1)] = (4));

(statearr_68922_68933[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68913 === (6))){
var inst_68901 = (state_68912[(7)]);
var inst_68903 = (state_68912[(2)]);
var inst_68904 = fluree.db.util.async.throw_err.call(null,inst_68903);
var inst_68905 = fluree.db.dbproto._p_prop.call(null,inst_68904,new cljs.core.Keyword(null,"name","name",1843675177),inst_68901);
var inst_68906 = cljs.core.clj__GT_js.call(null,inst_68905);
var inst_68907 = resolve.call(null,inst_68906);
var _ = (function (){var statearr_68923 = state_68912;
(statearr_68923[(4)] = cljs.core.rest.call(null,(state_68912[(4)])));

return statearr_68923;
})();
var state_68912__$1 = state_68912;
var statearr_68924_68934 = state_68912__$1;
(statearr_68924_68934[(2)] = inst_68907);

(statearr_68924_68934[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicate_name_$_state_machine__2726__auto__ = null;
var flureenjs$predicate_name_$_state_machine__2726__auto____0 = (function (){
var statearr_68925 = [null,null,null,null,null,null,null,null,null];
(statearr_68925[(0)] = flureenjs$predicate_name_$_state_machine__2726__auto__);

(statearr_68925[(1)] = (1));

return statearr_68925;
});
var flureenjs$predicate_name_$_state_machine__2726__auto____1 = (function (state_68912){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68912);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68926){var ex__2729__auto__ = e68926;
var statearr_68927_68935 = state_68912;
(statearr_68927_68935[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68912[(4)]))){
var statearr_68928_68936 = state_68912;
(statearr_68928_68936[(1)] = cljs.core.first.call(null,(state_68912[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68937 = state_68912;
state_68912 = G__68937;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$predicate_name_$_state_machine__2726__auto__ = function(state_68912){
switch(arguments.length){
case 0:
return flureenjs$predicate_name_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$predicate_name_$_state_machine__2726__auto____1.call(this,state_68912);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicate_name_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicate_name_$_state_machine__2726__auto____0;
flureenjs$predicate_name_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicate_name_$_state_machine__2726__auto____1;
return flureenjs$predicate_name_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68929 = f__2749__auto__.call(null);
(statearr_68929[(6)] = c__2748__auto__);

return statearr_68929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.predicate_name', flureenjs.predicate_name);
/**
 * Returns promise containing subject id given a subject
 *   identity or a subject id.
 *   If subject doesn't exist, returns nil.
 */
flureenjs.subid = (function flureenjs$subid(db,ident){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68960){
var state_val_68961 = (state_68960[(1)]);
if((state_val_68961 === (1))){
var state_68960__$1 = state_68960;
var statearr_68962_68978 = state_68960__$1;
(statearr_68962_68978[(2)] = null);

(statearr_68962_68978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68961 === (2))){
var _ = (function (){var statearr_68963 = state_68960;
(statearr_68963[(4)] = cljs.core.cons.call(null,(5),(state_68960[(4)])));

return statearr_68963;
})();
var inst_68946 = cljs.core.js__GT_clj.call(null,ident,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_68960__$1 = (function (){var statearr_68964 = state_68960;
(statearr_68964[(7)] = inst_68946);

return statearr_68964;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68960__$1,(7),db);
} else {
if((state_val_68961 === (3))){
var inst_68958 = (state_68960[(2)]);
var state_68960__$1 = state_68960;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68960__$1,inst_68958);
} else {
if((state_val_68961 === (4))){
var inst_68938 = (state_68960[(2)]);
var inst_68939 = fluree.db.util.log.error.call(null,inst_68938);
var inst_68940 = reject.call(null,inst_68938);
var state_68960__$1 = (function (){var statearr_68966 = state_68960;
(statearr_68966[(8)] = inst_68939);

return statearr_68966;
})();
var statearr_68967_68979 = state_68960__$1;
(statearr_68967_68979[(2)] = inst_68940);

(statearr_68967_68979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68961 === (5))){
var _ = (function (){var statearr_68968 = state_68960;
(statearr_68968[(4)] = cljs.core.rest.call(null,(state_68960[(4)])));

return statearr_68968;
})();
var state_68960__$1 = state_68960;
var ex68965 = (state_68960__$1[(2)]);
var statearr_68969_68980 = state_68960__$1;
(statearr_68969_68980[(5)] = ex68965);


var statearr_68970_68981 = state_68960__$1;
(statearr_68970_68981[(1)] = (4));

(statearr_68970_68981[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68961 === (6))){
var inst_68952 = (state_68960[(2)]);
var inst_68953 = fluree.db.util.async.throw_err.call(null,inst_68952);
var inst_68954 = cljs.core.clj__GT_js.call(null,inst_68953);
var inst_68955 = resolve.call(null,inst_68954);
var _ = (function (){var statearr_68971 = state_68960;
(statearr_68971[(4)] = cljs.core.rest.call(null,(state_68960[(4)])));

return statearr_68971;
})();
var state_68960__$1 = state_68960;
var statearr_68972_68982 = state_68960__$1;
(statearr_68972_68982[(2)] = inst_68955);

(statearr_68972_68982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68961 === (7))){
var inst_68946 = (state_68960[(7)]);
var inst_68948 = (state_68960[(2)]);
var inst_68949 = fluree.db.util.async.throw_err.call(null,inst_68948);
var inst_68950 = fluree.db.dbproto._subid.call(null,inst_68949,inst_68946,false);
var state_68960__$1 = state_68960;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68960__$1,(6),inst_68950);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$subid_$_state_machine__2726__auto__ = null;
var flureenjs$subid_$_state_machine__2726__auto____0 = (function (){
var statearr_68973 = [null,null,null,null,null,null,null,null,null];
(statearr_68973[(0)] = flureenjs$subid_$_state_machine__2726__auto__);

(statearr_68973[(1)] = (1));

return statearr_68973;
});
var flureenjs$subid_$_state_machine__2726__auto____1 = (function (state_68960){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68960);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68974){var ex__2729__auto__ = e68974;
var statearr_68975_68983 = state_68960;
(statearr_68975_68983[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68960[(4)]))){
var statearr_68976_68984 = state_68960;
(statearr_68976_68984[(1)] = cljs.core.first.call(null,(state_68960[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68985 = state_68960;
state_68960 = G__68985;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$subid_$_state_machine__2726__auto__ = function(state_68960){
switch(arguments.length){
case 0:
return flureenjs$subid_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$subid_$_state_machine__2726__auto____1.call(this,state_68960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$subid_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$subid_$_state_machine__2726__auto____0;
flureenjs$subid_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$subid_$_state_machine__2726__auto____1;
return flureenjs$subid_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68977 = f__2749__auto__.call(null);
(statearr_68977[(6)] = c__2748__auto__);

return statearr_68977;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.subid', flureenjs.subid);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureenjs.delete_ledger = (function flureenjs$delete_ledger(var_args){
var G__68987 = arguments.length;
switch (G__68987) {
case 2:
return flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.delete_ledger', flureenjs.delete_ledger);

(flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.delete_ledger.call(null,conn,ledger,null);
}));

(flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_69057){
var state_val_69058 = (state_69057[(1)]);
if((state_val_69058 === (7))){
var inst_69000 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_69057__$1 = state_69057;
var statearr_69059_69104 = state_69057__$1;
(statearr_69059_69104[(2)] = inst_69000);

(statearr_69059_69104[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (20))){
var inst_69008 = (state_69057[(7)]);
var inst_69032 = (state_69057[(2)]);
var state_69057__$1 = (function (){var statearr_69060 = state_69057;
(statearr_69060[(8)] = inst_69032);

return statearr_69060;
})();
if(cljs.core.truth_(inst_69008)){
var statearr_69061_69105 = state_69057__$1;
(statearr_69061_69105[(1)] = (21));

} else {
var statearr_69062_69106 = state_69057__$1;
(statearr_69062_69106[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (1))){
var state_69057__$1 = state_69057;
var statearr_69063_69107 = state_69057__$1;
(statearr_69063_69107[(2)] = null);

(statearr_69063_69107[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (24))){
var inst_69039 = (state_69057[(2)]);
var inst_69040 = fluree.db.util.async.throw_err.call(null,inst_69039);
var state_69057__$1 = state_69057;
var statearr_69064_69108 = state_69057__$1;
(statearr_69064_69108[(2)] = inst_69040);

(statearr_69064_69108[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (4))){
var inst_68988 = (state_69057[(2)]);
var inst_68989 = fluree.db.util.log.error.call(null,inst_68988);
var inst_68990 = reject.call(null,inst_68988);
var state_69057__$1 = (function (){var statearr_69065 = state_69057;
(statearr_69065[(9)] = inst_68989);

return statearr_69065;
})();
var statearr_69066_69109 = state_69057__$1;
(statearr_69066_69109[(2)] = inst_68990);

(statearr_69066_69109[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (15))){
var inst_69021 = (state_69057[(10)]);
var inst_69023 = fluree.db.util.core.without_nils.call(null,inst_69021);
var inst_69024 = fluree.db.util.json.stringify.call(null,inst_69023);
var state_69057__$1 = state_69057;
var statearr_69067_69110 = state_69057__$1;
(statearr_69067_69110[(2)] = inst_69024);

(statearr_69067_69110[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (21))){
var inst_69032 = (state_69057[(8)]);
var inst_69027 = (state_69057[(11)]);
var inst_69034 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_69035 = [inst_69027,inst_69032];
var inst_69036 = cljs.core.PersistentHashMap.fromArrays(inst_69034,inst_69035);
var inst_69037 = fluree.db.operations.command_async.call(null,conn,inst_69036);
var state_69057__$1 = state_69057;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69057__$1,(24),inst_69037);
} else {
if((state_val_69058 === (13))){
var inst_69009 = (state_69057[(12)]);
var inst_69016 = (inst_69009 + (30000));
var state_69057__$1 = state_69057;
var statearr_69068_69111 = state_69057__$1;
(statearr_69068_69111[(2)] = inst_69016);

(statearr_69068_69111[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (22))){
var inst_69021 = (state_69057[(10)]);
var inst_69042 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_69021);
var state_69057__$1 = state_69057;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69057__$1,(25),inst_69042);
} else {
if((state_val_69058 === (6))){
var state_69057__$1 = state_69057;
var statearr_69069_69112 = state_69057__$1;
(statearr_69069_69112[(2)] = null);

(statearr_69069_69112[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (25))){
var inst_69044 = (state_69057[(2)]);
var inst_69045 = fluree.db.util.async.throw_err.call(null,inst_69044);
var state_69057__$1 = state_69057;
var statearr_69070_69113 = state_69057__$1;
(statearr_69070_69113[(2)] = inst_69045);

(statearr_69070_69113[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (17))){
var inst_69008 = (state_69057[(7)]);
var inst_69027 = (state_69057[(2)]);
var state_69057__$1 = (function (){var statearr_69071 = state_69057;
(statearr_69071[(11)] = inst_69027);

return statearr_69071;
})();
if(cljs.core.truth_(inst_69008)){
var statearr_69072_69114 = state_69057__$1;
(statearr_69072_69114[(1)] = (18));

} else {
var statearr_69073_69115 = state_69057__$1;
(statearr_69073_69115[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (3))){
var inst_69055 = (state_69057[(2)]);
var state_69057__$1 = state_69057;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69057__$1,inst_69055);
} else {
if((state_val_69058 === (12))){
var inst_69006 = (state_69057[(13)]);
var state_69057__$1 = state_69057;
var statearr_69074_69116 = state_69057__$1;
(statearr_69074_69116[(2)] = inst_69006);

(statearr_69074_69116[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (2))){
var _ = (function (){var statearr_69075 = state_69057;
(statearr_69075[(4)] = cljs.core.cons.call(null,(5),(state_69057[(4)])));

return statearr_69075;
})();
var inst_68997 = (opts == null);
var state_69057__$1 = state_69057;
if(cljs.core.truth_(inst_68997)){
var statearr_69076_69117 = state_69057__$1;
(statearr_69076_69117[(1)] = (6));

} else {
var statearr_69077_69118 = state_69057__$1;
(statearr_69077_69118[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (23))){
var inst_69047 = (state_69057[(2)]);
var inst_69048 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69049 = [(200),inst_69047];
var inst_69050 = cljs.core.PersistentHashMap.fromArrays(inst_69048,inst_69049);
var inst_69051 = cljs.core.clj__GT_js.call(null,inst_69050);
var inst_69052 = resolve.call(null,inst_69051);
var _ = (function (){var statearr_69078 = state_69057;
(statearr_69078[(4)] = cljs.core.rest.call(null,(state_69057[(4)])));

return statearr_69078;
})();
var state_69057__$1 = state_69057;
var statearr_69079_69119 = state_69057__$1;
(statearr_69079_69119[(2)] = inst_69052);

(statearr_69079_69119[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (19))){
var state_69057__$1 = state_69057;
var statearr_69080_69120 = state_69057__$1;
(statearr_69080_69120[(2)] = null);

(statearr_69080_69120[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (11))){
var inst_69006 = (state_69057[(13)]);
var inst_69013 = (state_69057[(2)]);
var state_69057__$1 = (function (){var statearr_69082 = state_69057;
(statearr_69082[(14)] = inst_69013);

return statearr_69082;
})();
if(cljs.core.truth_(inst_69006)){
var statearr_69083_69121 = state_69057__$1;
(statearr_69083_69121[(1)] = (12));

} else {
var statearr_69084_69122 = state_69057__$1;
(statearr_69084_69122[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (9))){
var inst_69005 = (state_69057[(15)]);
var state_69057__$1 = state_69057;
var statearr_69085_69123 = state_69057__$1;
(statearr_69085_69123[(2)] = inst_69005);

(statearr_69085_69123[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (5))){
var _ = (function (){var statearr_69086 = state_69057;
(statearr_69086[(4)] = cljs.core.rest.call(null,(state_69057[(4)])));

return statearr_69086;
})();
var state_69057__$1 = state_69057;
var ex69081 = (state_69057__$1[(2)]);
var statearr_69087_69124 = state_69057__$1;
(statearr_69087_69124[(5)] = ex69081);


var statearr_69088_69125 = state_69057__$1;
(statearr_69088_69125[(1)] = (4));

(statearr_69088_69125[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (14))){
var inst_69008 = (state_69057[(7)]);
var inst_69013 = (state_69057[(14)]);
var inst_69018 = (state_69057[(2)]);
var inst_69019 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_69020 = [new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),ledger,inst_69013,inst_69018];
var inst_69021 = cljs.core.PersistentHashMap.fromArrays(inst_69019,inst_69020);
var state_69057__$1 = (function (){var statearr_69089 = state_69057;
(statearr_69089[(10)] = inst_69021);

return statearr_69089;
})();
if(cljs.core.truth_(inst_69008)){
var statearr_69090_69126 = state_69057__$1;
(statearr_69090_69126[(1)] = (15));

} else {
var statearr_69091_69127 = state_69057__$1;
(statearr_69091_69127[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (16))){
var state_69057__$1 = state_69057;
var statearr_69092_69128 = state_69057__$1;
(statearr_69092_69128[(2)] = null);

(statearr_69092_69128[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (10))){
var inst_69009 = (state_69057[(12)]);
var state_69057__$1 = state_69057;
var statearr_69093_69129 = state_69057__$1;
(statearr_69093_69129[(2)] = inst_69009);

(statearr_69093_69129[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (18))){
var inst_69008 = (state_69057[(7)]);
var inst_69027 = (state_69057[(11)]);
var inst_69029 = fluree.crypto.sign_message.call(null,inst_69027,inst_69008);
var state_69057__$1 = state_69057;
var statearr_69094_69130 = state_69057__$1;
(statearr_69094_69130[(2)] = inst_69029);

(statearr_69094_69130[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69058 === (8))){
var inst_69005 = (state_69057[(15)]);
var inst_69002 = (state_69057[(2)]);
var inst_69003 = fluree.db.connection_js.check_connection.call(null,conn,inst_69002);
var inst_69004 = cljs.core.__destructure_map.call(null,inst_69002);
var inst_69005__$1 = cljs.core.get.call(null,inst_69004,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_69006 = cljs.core.get.call(null,inst_69004,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_69007 = cljs.core.get.call(null,inst_69004,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_69008 = cljs.core.get.call(null,inst_69004,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_69009 = fluree.db.util.core.current_time_millis.call(null);
var state_69057__$1 = (function (){var statearr_69095 = state_69057;
(statearr_69095[(7)] = inst_69008);

(statearr_69095[(16)] = inst_69003);

(statearr_69095[(15)] = inst_69005__$1);

(statearr_69095[(17)] = inst_69007);

(statearr_69095[(13)] = inst_69006);

(statearr_69095[(12)] = inst_69009);

return statearr_69095;
})();
if(cljs.core.truth_(inst_69005__$1)){
var statearr_69096_69131 = state_69057__$1;
(statearr_69096_69131[(1)] = (9));

} else {
var statearr_69097_69132 = state_69057__$1;
(statearr_69097_69132[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_69098 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69098[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_69098[(1)] = (1));

return statearr_69098;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_69057){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_69057);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e69099){var ex__2729__auto__ = e69099;
var statearr_69100_69133 = state_69057;
(statearr_69100_69133[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_69057[(4)]))){
var statearr_69101_69134 = state_69057;
(statearr_69101_69134[(1)] = cljs.core.first.call(null,(state_69057[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69135 = state_69057;
state_69057 = G__69135;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_69057){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_69057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_69102 = f__2749__auto__.call(null);
(statearr_69102[(6)] = c__2748__auto__);

return statearr_69102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise with ledger's status as a map, including index, indexes, block, and status.
 *   If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledger_info = (function flureenjs$ledger_info(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_69154){
var state_val_69155 = (state_69154[(1)]);
if((state_val_69155 === (1))){
var state_69154__$1 = state_69154;
var statearr_69156_69171 = state_69154__$1;
(statearr_69156_69171[(2)] = null);

(statearr_69156_69171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69155 === (2))){
var _ = (function (){var statearr_69157 = state_69154;
(statearr_69157[(4)] = cljs.core.cons.call(null,(5),(state_69154[(4)])));

return statearr_69157;
})();
var inst_69144 = fluree.db.operations.ledger_info_async.call(null,conn,ledger);
var state_69154__$1 = state_69154;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69154__$1,(6),inst_69144);
} else {
if((state_val_69155 === (3))){
var inst_69152 = (state_69154[(2)]);
var state_69154__$1 = state_69154;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69154__$1,inst_69152);
} else {
if((state_val_69155 === (4))){
var inst_69136 = (state_69154[(2)]);
var inst_69137 = fluree.db.util.log.error.call(null,inst_69136);
var inst_69138 = reject.call(null,inst_69136);
var state_69154__$1 = (function (){var statearr_69159 = state_69154;
(statearr_69159[(7)] = inst_69137);

return statearr_69159;
})();
var statearr_69160_69172 = state_69154__$1;
(statearr_69160_69172[(2)] = inst_69138);

(statearr_69160_69172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69155 === (5))){
var _ = (function (){var statearr_69161 = state_69154;
(statearr_69161[(4)] = cljs.core.rest.call(null,(state_69154[(4)])));

return statearr_69161;
})();
var state_69154__$1 = state_69154;
var ex69158 = (state_69154__$1[(2)]);
var statearr_69162_69173 = state_69154__$1;
(statearr_69162_69173[(5)] = ex69158);


var statearr_69163_69174 = state_69154__$1;
(statearr_69163_69174[(1)] = (4));

(statearr_69163_69174[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69155 === (6))){
var inst_69146 = (state_69154[(2)]);
var inst_69147 = fluree.db.util.async.throw_err.call(null,inst_69146);
var inst_69148 = cljs.core.clj__GT_js.call(null,inst_69147);
var inst_69149 = resolve.call(null,inst_69148);
var _ = (function (){var statearr_69164 = state_69154;
(statearr_69164[(4)] = cljs.core.rest.call(null,(state_69154[(4)])));

return statearr_69164;
})();
var state_69154__$1 = state_69154;
var statearr_69165_69175 = state_69154__$1;
(statearr_69165_69175[(2)] = inst_69149);

(statearr_69165_69175[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledger_info_$_state_machine__2726__auto__ = null;
var flureenjs$ledger_info_$_state_machine__2726__auto____0 = (function (){
var statearr_69166 = [null,null,null,null,null,null,null,null];
(statearr_69166[(0)] = flureenjs$ledger_info_$_state_machine__2726__auto__);

(statearr_69166[(1)] = (1));

return statearr_69166;
});
var flureenjs$ledger_info_$_state_machine__2726__auto____1 = (function (state_69154){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_69154);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e69167){var ex__2729__auto__ = e69167;
var statearr_69168_69176 = state_69154;
(statearr_69168_69176[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_69154[(4)]))){
var statearr_69169_69177 = state_69154;
(statearr_69169_69177[(1)] = cljs.core.first.call(null,(state_69154[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69178 = state_69154;
state_69154 = G__69178;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$ledger_info_$_state_machine__2726__auto__ = function(state_69154){
switch(arguments.length){
case 0:
return flureenjs$ledger_info_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$ledger_info_$_state_machine__2726__auto____1.call(this,state_69154);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledger_info_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledger_info_$_state_machine__2726__auto____0;
flureenjs$ledger_info_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledger_info_$_state_machine__2726__auto____1;
return flureenjs$ledger_info_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_69170 = f__2749__auto__.call(null);
(statearr_69170[(6)] = c__2748__auto__);

return statearr_69170;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.ledger_info', flureenjs.ledger_info);
/**
 * Returns promise with a list of ledgers the connected server is currently serving.
 */
flureenjs.ledger_list = (function flureenjs$ledger_list(conn){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_69197){
var state_val_69198 = (state_69197[(1)]);
if((state_val_69198 === (1))){
var state_69197__$1 = state_69197;
var statearr_69199_69214 = state_69197__$1;
(statearr_69199_69214[(2)] = null);

(statearr_69199_69214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69198 === (2))){
var _ = (function (){var statearr_69200 = state_69197;
(statearr_69200[(4)] = cljs.core.cons.call(null,(5),(state_69197[(4)])));

return statearr_69200;
})();
var inst_69187 = fluree.db.operations.ledgers_async.call(null,conn);
var state_69197__$1 = state_69197;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69197__$1,(6),inst_69187);
} else {
if((state_val_69198 === (3))){
var inst_69195 = (state_69197[(2)]);
var state_69197__$1 = state_69197;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69197__$1,inst_69195);
} else {
if((state_val_69198 === (4))){
var inst_69179 = (state_69197[(2)]);
var inst_69180 = fluree.db.util.log.error.call(null,inst_69179);
var inst_69181 = reject.call(null,inst_69179);
var state_69197__$1 = (function (){var statearr_69202 = state_69197;
(statearr_69202[(7)] = inst_69180);

return statearr_69202;
})();
var statearr_69203_69215 = state_69197__$1;
(statearr_69203_69215[(2)] = inst_69181);

(statearr_69203_69215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69198 === (5))){
var _ = (function (){var statearr_69204 = state_69197;
(statearr_69204[(4)] = cljs.core.rest.call(null,(state_69197[(4)])));

return statearr_69204;
})();
var state_69197__$1 = state_69197;
var ex69201 = (state_69197__$1[(2)]);
var statearr_69205_69216 = state_69197__$1;
(statearr_69205_69216[(5)] = ex69201);


var statearr_69206_69217 = state_69197__$1;
(statearr_69206_69217[(1)] = (4));

(statearr_69206_69217[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69198 === (6))){
var inst_69189 = (state_69197[(2)]);
var inst_69190 = fluree.db.util.async.throw_err.call(null,inst_69189);
var inst_69191 = cljs.core.clj__GT_js.call(null,inst_69190);
var inst_69192 = resolve.call(null,inst_69191);
var _ = (function (){var statearr_69207 = state_69197;
(statearr_69207[(4)] = cljs.core.rest.call(null,(state_69197[(4)])));

return statearr_69207;
})();
var state_69197__$1 = state_69197;
var statearr_69208_69218 = state_69197__$1;
(statearr_69208_69218[(2)] = inst_69192);

(statearr_69208_69218[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledger_list_$_state_machine__2726__auto__ = null;
var flureenjs$ledger_list_$_state_machine__2726__auto____0 = (function (){
var statearr_69209 = [null,null,null,null,null,null,null,null];
(statearr_69209[(0)] = flureenjs$ledger_list_$_state_machine__2726__auto__);

(statearr_69209[(1)] = (1));

return statearr_69209;
});
var flureenjs$ledger_list_$_state_machine__2726__auto____1 = (function (state_69197){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_69197);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e69210){var ex__2729__auto__ = e69210;
var statearr_69211_69219 = state_69197;
(statearr_69211_69219[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_69197[(4)]))){
var statearr_69212_69220 = state_69197;
(statearr_69212_69220[(1)] = cljs.core.first.call(null,(state_69197[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69221 = state_69197;
state_69197 = G__69221;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$ledger_list_$_state_machine__2726__auto__ = function(state_69197){
switch(arguments.length){
case 0:
return flureenjs$ledger_list_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$ledger_list_$_state_machine__2726__auto____1.call(this,state_69197);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledger_list_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledger_list_$_state_machine__2726__auto____0;
flureenjs$ledger_list_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledger_list_$_state_machine__2726__auto____1;
return flureenjs$ledger_list_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_69213 = f__2749__auto__.call(null);
(statearr_69213[(6)] = c__2748__auto__);

return statearr_69213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.ledger_list', flureenjs.ledger_list);
/**
 * Returns promise with ledger stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledger_stats = (function flureenjs$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_69240){
var state_val_69241 = (state_69240[(1)]);
if((state_val_69241 === (1))){
var state_69240__$1 = state_69240;
var statearr_69242_69257 = state_69240__$1;
(statearr_69242_69257[(2)] = null);

(statearr_69242_69257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69241 === (2))){
var _ = (function (){var statearr_69243 = state_69240;
(statearr_69243[(4)] = cljs.core.cons.call(null,(5),(state_69240[(4)])));

return statearr_69243;
})();
var inst_69230 = fluree.db.operations.ledger_stats_async.call(null,conn,ledger);
var state_69240__$1 = state_69240;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69240__$1,(6),inst_69230);
} else {
if((state_val_69241 === (3))){
var inst_69238 = (state_69240[(2)]);
var state_69240__$1 = state_69240;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69240__$1,inst_69238);
} else {
if((state_val_69241 === (4))){
var inst_69222 = (state_69240[(2)]);
var inst_69223 = fluree.db.util.log.error.call(null,inst_69222);
var inst_69224 = reject.call(null,inst_69222);
var state_69240__$1 = (function (){var statearr_69245 = state_69240;
(statearr_69245[(7)] = inst_69223);

return statearr_69245;
})();
var statearr_69246_69258 = state_69240__$1;
(statearr_69246_69258[(2)] = inst_69224);

(statearr_69246_69258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69241 === (5))){
var _ = (function (){var statearr_69247 = state_69240;
(statearr_69247[(4)] = cljs.core.rest.call(null,(state_69240[(4)])));

return statearr_69247;
})();
var state_69240__$1 = state_69240;
var ex69244 = (state_69240__$1[(2)]);
var statearr_69248_69259 = state_69240__$1;
(statearr_69248_69259[(5)] = ex69244);


var statearr_69249_69260 = state_69240__$1;
(statearr_69249_69260[(1)] = (4));

(statearr_69249_69260[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69241 === (6))){
var inst_69232 = (state_69240[(2)]);
var inst_69233 = fluree.db.util.async.throw_err.call(null,inst_69232);
var inst_69234 = cljs.core.clj__GT_js.call(null,inst_69233);
var inst_69235 = resolve.call(null,inst_69234);
var _ = (function (){var statearr_69250 = state_69240;
(statearr_69250[(4)] = cljs.core.rest.call(null,(state_69240[(4)])));

return statearr_69250;
})();
var state_69240__$1 = state_69240;
var statearr_69251_69261 = state_69240__$1;
(statearr_69251_69261[(2)] = inst_69235);

(statearr_69251_69261[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledger_stats_$_state_machine__2726__auto__ = null;
var flureenjs$ledger_stats_$_state_machine__2726__auto____0 = (function (){
var statearr_69252 = [null,null,null,null,null,null,null,null];
(statearr_69252[(0)] = flureenjs$ledger_stats_$_state_machine__2726__auto__);

(statearr_69252[(1)] = (1));

return statearr_69252;
});
var flureenjs$ledger_stats_$_state_machine__2726__auto____1 = (function (state_69240){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_69240);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e69253){var ex__2729__auto__ = e69253;
var statearr_69254_69262 = state_69240;
(statearr_69254_69262[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_69240[(4)]))){
var statearr_69255_69263 = state_69240;
(statearr_69255_69263[(1)] = cljs.core.first.call(null,(state_69240[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69264 = state_69240;
state_69240 = G__69264;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$ledger_stats_$_state_machine__2726__auto__ = function(state_69240){
switch(arguments.length){
case 0:
return flureenjs$ledger_stats_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$ledger_stats_$_state_machine__2726__auto____1.call(this,state_69240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledger_stats_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledger_stats_$_state_machine__2726__auto____0;
flureenjs$ledger_stats_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledger_stats_$_state_machine__2726__auto____1;
return flureenjs$ledger_stats_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_69256 = f__2749__auto__.call(null);
(statearr_69256[(6)] = c__2748__auto__);

return statearr_69256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.ledger_stats', flureenjs.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than db-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 * 
 */
flureenjs.new_ledger = (function flureenjs$new_ledger(var_args){
var G__69266 = arguments.length;
switch (G__69266) {
case 2:
return flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.new_ledger', flureenjs.new_ledger);

(flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.new_ledger.call(null,conn,ledger,null);
}));

(flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_69384){
var state_val_69385 = (state_69384[(1)]);
if((state_val_69385 === (7))){
var inst_69289 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_69384__$1 = state_69384;
var statearr_69386_69451 = state_69384__$1;
(statearr_69386_69451[(2)] = inst_69289);

(statearr_69386_69451[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (20))){
var inst_69296 = (state_69384[(7)]);
var inst_69334 = (state_69384[(2)]);
var inst_69335 = fluree.db.util.core.current_time_millis.call(null);
var state_69384__$1 = (function (){var statearr_69387 = state_69384;
(statearr_69387[(8)] = inst_69334);

(statearr_69387[(9)] = inst_69335);

return statearr_69387;
})();
if(cljs.core.truth_(inst_69296)){
var statearr_69388_69452 = state_69384__$1;
(statearr_69388_69452[(1)] = (21));

} else {
var statearr_69389_69453 = state_69384__$1;
(statearr_69389_69453[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (27))){
var inst_69348 = (state_69384[(10)]);
var inst_69350 = fluree.db.util.core.without_nils.call(null,inst_69348);
var inst_69351 = fluree.db.util.json.stringify.call(null,inst_69350);
var state_69384__$1 = state_69384;
var statearr_69390_69454 = state_69384__$1;
(statearr_69390_69454[(2)] = inst_69351);

(statearr_69390_69454[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (1))){
var state_69384__$1 = state_69384;
var statearr_69391_69455 = state_69384__$1;
(statearr_69391_69455[(2)] = null);

(statearr_69391_69455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (24))){
var inst_69302 = (state_69384[(11)]);
var state_69384__$1 = state_69384;
var statearr_69392_69456 = state_69384__$1;
(statearr_69392_69456[(2)] = inst_69302);

(statearr_69392_69456[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (4))){
var inst_69267 = (state_69384[(2)]);
var inst_69268 = fluree.db.util.log.error.call(null,inst_69267);
var inst_69269 = cljs.core.ex_data.call(null,inst_69267);
var inst_69270 = cljs.core.ex_message.call(null,inst_69267);
var inst_69271 = cljs.core.assoc.call(null,inst_69269,new cljs.core.Keyword(null,"message","message",-406056002),inst_69270);
var inst_69272 = cljs.core.clj__GT_js.call(null,inst_69271);
var inst_69273 = reject.call(null,inst_69272);
var state_69384__$1 = (function (){var statearr_69393 = state_69384;
(statearr_69393[(12)] = inst_69268);

return statearr_69393;
})();
var statearr_69394_69457 = state_69384__$1;
(statearr_69394_69457[(2)] = inst_69273);

(statearr_69394_69457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (15))){
var inst_69324 = (state_69384[(13)]);
var inst_69326 = fluree.db.graphdb.validate_ledger_name.call(null,inst_69324,"alias");
var state_69384__$1 = state_69384;
var statearr_69395_69458 = state_69384__$1;
(statearr_69395_69458[(2)] = inst_69326);

(statearr_69395_69458[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (21))){
var inst_69296 = (state_69384[(7)]);
var state_69384__$1 = state_69384;
var statearr_69396_69459 = state_69384__$1;
(statearr_69396_69459[(2)] = inst_69296);

(statearr_69396_69459[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (31))){
var state_69384__$1 = state_69384;
var statearr_69397_69460 = state_69384__$1;
(statearr_69397_69460[(2)] = null);

(statearr_69397_69460[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (32))){
var inst_69298 = (state_69384[(14)]);
var inst_69359 = (state_69384[(2)]);
var state_69384__$1 = (function (){var statearr_69398 = state_69384;
(statearr_69398[(15)] = inst_69359);

return statearr_69398;
})();
if(cljs.core.truth_(inst_69298)){
var statearr_69399_69461 = state_69384__$1;
(statearr_69399_69461[(1)] = (33));

} else {
var statearr_69400_69462 = state_69384__$1;
(statearr_69400_69462[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (33))){
var inst_69359 = (state_69384[(15)]);
var inst_69354 = (state_69384[(16)]);
var inst_69361 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_69362 = [inst_69354,inst_69359];
var inst_69363 = cljs.core.PersistentHashMap.fromArrays(inst_69361,inst_69362);
var inst_69364 = fluree.db.operations.command_async.call(null,conn,inst_69363);
var state_69384__$1 = state_69384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69384__$1,(36),inst_69364);
} else {
if((state_val_69385 === (13))){
var state_69384__$1 = state_69384;
var statearr_69401_69463 = state_69384__$1;
(statearr_69401_69463[(2)] = null);

(statearr_69401_69463[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (22))){
var inst_69335 = (state_69384[(9)]);
var state_69384__$1 = state_69384;
var statearr_69402_69464 = state_69384__$1;
(statearr_69402_69464[(2)] = inst_69335);

(statearr_69402_69464[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (36))){
var inst_69366 = (state_69384[(2)]);
var inst_69367 = fluree.db.util.async.throw_err.call(null,inst_69366);
var state_69384__$1 = state_69384;
var statearr_69403_69465 = state_69384__$1;
(statearr_69403_69465[(2)] = inst_69367);

(statearr_69403_69465[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (29))){
var inst_69298 = (state_69384[(14)]);
var inst_69354 = (state_69384[(2)]);
var state_69384__$1 = (function (){var statearr_69404 = state_69384;
(statearr_69404[(16)] = inst_69354);

return statearr_69404;
})();
if(cljs.core.truth_(inst_69298)){
var statearr_69405_69466 = state_69384__$1;
(statearr_69405_69466[(1)] = (30));

} else {
var statearr_69406_69467 = state_69384__$1;
(statearr_69406_69467[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (6))){
var state_69384__$1 = state_69384;
var statearr_69407_69468 = state_69384__$1;
(statearr_69407_69468[(2)] = null);

(statearr_69407_69468[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (28))){
var state_69384__$1 = state_69384;
var statearr_69408_69469 = state_69384__$1;
(statearr_69408_69469[(2)] = null);

(statearr_69408_69469[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (25))){
var inst_69335 = (state_69384[(9)]);
var inst_69342 = (inst_69335 + (30000));
var state_69384__$1 = state_69384;
var statearr_69409_69470 = state_69384__$1;
(statearr_69409_69470[(2)] = inst_69342);

(statearr_69409_69470[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (34))){
var inst_69348 = (state_69384[(10)]);
var inst_69369 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_69348);
var state_69384__$1 = state_69384;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69384__$1,(37),inst_69369);
} else {
if((state_val_69385 === (17))){
var inst_69305 = (state_69384[(17)]);
var inst_69329 = (state_69384[(2)]);
var state_69384__$1 = (function (){var statearr_69410 = state_69384;
(statearr_69410[(18)] = inst_69329);

return statearr_69410;
})();
if(cljs.core.truth_(inst_69305)){
var statearr_69411_69471 = state_69384__$1;
(statearr_69411_69471[(1)] = (18));

} else {
var statearr_69412_69472 = state_69384__$1;
(statearr_69412_69472[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (3))){
var inst_69382 = (state_69384[(2)]);
var state_69384__$1 = state_69384;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69384__$1,inst_69382);
} else {
if((state_val_69385 === (12))){
var inst_69319 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var state_69384__$1 = state_69384;
var statearr_69413_69473 = state_69384__$1;
(statearr_69413_69473[(2)] = inst_69319);

(statearr_69413_69473[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (2))){
var _ = (function (){var statearr_69414 = state_69384;
(statearr_69414[(4)] = cljs.core.cons.call(null,(5),(state_69384[(4)])));

return statearr_69414;
})();
var inst_69286 = (opts == null);
var state_69384__$1 = state_69384;
if(cljs.core.truth_(inst_69286)){
var statearr_69415_69474 = state_69384__$1;
(statearr_69415_69474[(1)] = (6));

} else {
var statearr_69416_69475 = state_69384__$1;
(statearr_69416_69475[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (23))){
var inst_69302 = (state_69384[(11)]);
var inst_69339 = (state_69384[(2)]);
var state_69384__$1 = (function (){var statearr_69417 = state_69384;
(statearr_69417[(19)] = inst_69339);

return statearr_69417;
})();
if(cljs.core.truth_(inst_69302)){
var statearr_69418_69476 = state_69384__$1;
(statearr_69418_69476[(1)] = (24));

} else {
var statearr_69419_69477 = state_69384__$1;
(statearr_69419_69477[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (35))){
var inst_69374 = (state_69384[(2)]);
var inst_69375 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69376 = [(200),inst_69374];
var inst_69377 = cljs.core.PersistentHashMap.fromArrays(inst_69375,inst_69376);
var inst_69378 = cljs.core.clj__GT_js.call(null,inst_69377);
var inst_69379 = resolve.call(null,inst_69378);
var _ = (function (){var statearr_69420 = state_69384;
(statearr_69420[(4)] = cljs.core.rest.call(null,(state_69384[(4)])));

return statearr_69420;
})();
var state_69384__$1 = state_69384;
var statearr_69421_69478 = state_69384__$1;
(statearr_69421_69478[(2)] = inst_69379);

(statearr_69421_69478[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (19))){
var state_69384__$1 = state_69384;
var statearr_69422_69479 = state_69384__$1;
(statearr_69422_69479[(2)] = null);

(statearr_69422_69479[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (11))){
var inst_69305 = (state_69384[(17)]);
var inst_69315 = (state_69384[(20)]);
var inst_69308 = (state_69384[(21)]);
var inst_69315__$1 = (state_69384[(2)]);
var inst_69316 = fluree.db.graphdb.validate_ledger_name.call(null,inst_69315__$1,"ledger");
var inst_69317 = fluree.db.graphdb.validate_ledger_name.call(null,inst_69308,"network");
var state_69384__$1 = (function (){var statearr_69424 = state_69384;
(statearr_69424[(22)] = inst_69316);

(statearr_69424[(23)] = inst_69317);

(statearr_69424[(20)] = inst_69315__$1);

return statearr_69424;
})();
if(cljs.core.truth_(inst_69305)){
var statearr_69425_69480 = state_69384__$1;
(statearr_69425_69480[(1)] = (12));

} else {
var statearr_69426_69481 = state_69384__$1;
(statearr_69426_69481[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (9))){
var inst_69309 = (state_69384[(24)]);
var inst_69312 = cljs.core.subs.call(null,inst_69309,(1));
var state_69384__$1 = state_69384;
var statearr_69427_69482 = state_69384__$1;
(statearr_69427_69482[(2)] = inst_69312);

(statearr_69427_69482[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (5))){
var _ = (function (){var statearr_69428 = state_69384;
(statearr_69428[(4)] = cljs.core.rest.call(null,(state_69384[(4)])));

return statearr_69428;
})();
var state_69384__$1 = state_69384;
var ex69423 = (state_69384__$1[(2)]);
var statearr_69429_69483 = state_69384__$1;
(statearr_69429_69483[(5)] = ex69423);


var statearr_69430_69484 = state_69384__$1;
(statearr_69430_69484[(1)] = (4));

(statearr_69430_69484[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (14))){
var inst_69305 = (state_69384[(17)]);
var inst_69322 = (state_69384[(2)]);
var inst_69323 = cljs.core.nth.call(null,inst_69322,(0),null);
var inst_69324 = cljs.core.nth.call(null,inst_69322,(1),null);
var state_69384__$1 = (function (){var statearr_69431 = state_69384;
(statearr_69431[(25)] = inst_69323);

(statearr_69431[(13)] = inst_69324);

return statearr_69431;
})();
if(cljs.core.truth_(inst_69305)){
var statearr_69432_69485 = state_69384__$1;
(statearr_69432_69485[(1)] = (15));

} else {
var statearr_69433_69486 = state_69384__$1;
(statearr_69433_69486[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (26))){
var inst_69299 = (state_69384[(26)]);
var inst_69297 = (state_69384[(27)]);
var inst_69300 = (state_69384[(28)]);
var inst_69295 = (state_69384[(29)]);
var inst_69339 = (state_69384[(19)]);
var inst_69301 = (state_69384[(30)]);
var inst_69315 = (state_69384[(20)]);
var inst_69304 = (state_69384[(31)]);
var inst_69308 = (state_69384[(21)]);
var inst_69303 = (state_69384[(32)]);
var inst_69298 = (state_69384[(14)]);
var inst_69334 = (state_69384[(8)]);
var inst_69306 = (state_69384[(33)]);
var inst_69344 = (state_69384[(2)]);
var inst_69345 = [new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_69346 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69308),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69315)].join('');
var inst_69347 = [inst_69300,inst_69301,inst_69346,new cljs.core.Keyword(null,"new-db","new-db",1305352401),inst_69344,inst_69303,inst_69334,inst_69306,inst_69304,inst_69295,inst_69339,inst_69297,inst_69299];
var inst_69348 = cljs.core.PersistentHashMap.fromArrays(inst_69345,inst_69347);
var state_69384__$1 = (function (){var statearr_69434 = state_69384;
(statearr_69434[(10)] = inst_69348);

return statearr_69434;
})();
if(cljs.core.truth_(inst_69298)){
var statearr_69435_69487 = state_69384__$1;
(statearr_69435_69487[(1)] = (27));

} else {
var statearr_69436_69488 = state_69384__$1;
(statearr_69436_69488[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (16))){
var state_69384__$1 = state_69384;
var statearr_69437_69489 = state_69384__$1;
(statearr_69437_69489[(2)] = null);

(statearr_69437_69489[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (30))){
var inst_69298 = (state_69384[(14)]);
var inst_69354 = (state_69384[(16)]);
var inst_69356 = fluree.crypto.sign_message.call(null,inst_69354,inst_69298);
var state_69384__$1 = state_69384;
var statearr_69438_69490 = state_69384__$1;
(statearr_69438_69490[(2)] = inst_69356);

(statearr_69438_69490[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (10))){
var inst_69309 = (state_69384[(24)]);
var state_69384__$1 = state_69384;
var statearr_69439_69491 = state_69384__$1;
(statearr_69439_69491[(2)] = inst_69309);

(statearr_69439_69491[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (18))){
var inst_69323 = (state_69384[(25)]);
var inst_69324 = (state_69384[(13)]);
var inst_69331 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69323),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69324)].join('');
var state_69384__$1 = state_69384;
var statearr_69440_69492 = state_69384__$1;
(statearr_69440_69492[(2)] = inst_69331);

(statearr_69440_69492[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (37))){
var inst_69371 = (state_69384[(2)]);
var inst_69372 = fluree.db.util.async.throw_err.call(null,inst_69371);
var state_69384__$1 = state_69384;
var statearr_69441_69493 = state_69384__$1;
(statearr_69441_69493[(2)] = inst_69372);

(statearr_69441_69493[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69385 === (8))){
var inst_69309 = (state_69384[(24)]);
var inst_69291 = (state_69384[(2)]);
var inst_69292 = fluree.db.connection_js.check_connection.call(null,conn,inst_69291);
var inst_69293 = cljs.core.__destructure_map.call(null,inst_69291);
var inst_69294 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_69295 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_69296 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_69297 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_69298 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_69299 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_69300 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_69301 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_69302 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_69303 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69304 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_69305 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_69306 = cljs.core.get.call(null,inst_69293,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_69307 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var inst_69308 = cljs.core.nth.call(null,inst_69307,(0),null);
var inst_69309__$1 = cljs.core.nth.call(null,inst_69307,(1),null);
var inst_69310 = clojure.string.starts_with_QMARK_.call(null,inst_69309__$1,"$");
var state_69384__$1 = (function (){var statearr_69442 = state_69384;
(statearr_69442[(26)] = inst_69299);

(statearr_69442[(34)] = inst_69292);

(statearr_69442[(17)] = inst_69305);

(statearr_69442[(27)] = inst_69297);

(statearr_69442[(28)] = inst_69300);

(statearr_69442[(11)] = inst_69302);

(statearr_69442[(24)] = inst_69309__$1);

(statearr_69442[(29)] = inst_69295);

(statearr_69442[(30)] = inst_69301);

(statearr_69442[(31)] = inst_69304);

(statearr_69442[(21)] = inst_69308);

(statearr_69442[(32)] = inst_69303);

(statearr_69442[(14)] = inst_69298);

(statearr_69442[(35)] = inst_69294);

(statearr_69442[(33)] = inst_69306);

(statearr_69442[(7)] = inst_69296);

return statearr_69442;
})();
if(inst_69310){
var statearr_69443_69494 = state_69384__$1;
(statearr_69443_69494[(1)] = (9));

} else {
var statearr_69444_69495 = state_69384__$1;
(statearr_69444_69495[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_69445 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69445[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_69445[(1)] = (1));

return statearr_69445;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_69384){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_69384);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e69446){var ex__2729__auto__ = e69446;
var statearr_69447_69496 = state_69384;
(statearr_69447_69496[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_69384[(4)]))){
var statearr_69448_69497 = state_69384;
(statearr_69448_69497[(1)] = cljs.core.first.call(null,(state_69384[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69498 = state_69384;
state_69384 = G__69498;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_69384){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_69384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_69449 = f__2749__auto__.call(null);
(statearr_69449[(6)] = c__2748__auto__);

return statearr_69449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Resolves a ledger identity in the form of 'network/ledger-or-alias' and returns a
 *   tuple of either [network ledger alias] or [network ledger].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger id.
 * 
 *   If you are providing a ledger id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the db-ident.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias or id of testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 */
flureenjs.resolve_ledger = (function flureenjs$resolve_ledger(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_69514){
var state_val_69515 = (state_69514[(1)]);
if((state_val_69515 === (1))){
var state_69514__$1 = state_69514;
var statearr_69516_69531 = state_69514__$1;
(statearr_69516_69531[(2)] = null);

(statearr_69516_69531[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69515 === (2))){
var _ = (function (){var statearr_69517 = state_69514;
(statearr_69517[(4)] = cljs.core.cons.call(null,(5),(state_69514[(4)])));

return statearr_69517;
})();
var inst_69507 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_69508 = cljs.core.clj__GT_js.call(null,inst_69507);
var inst_69509 = resolve.call(null,inst_69508);
var ___$1 = (function (){var statearr_69518 = state_69514;
(statearr_69518[(4)] = cljs.core.rest.call(null,(state_69514[(4)])));

return statearr_69518;
})();
var state_69514__$1 = state_69514;
var statearr_69519_69532 = state_69514__$1;
(statearr_69519_69532[(2)] = inst_69509);

(statearr_69519_69532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69515 === (3))){
var inst_69512 = (state_69514[(2)]);
var state_69514__$1 = state_69514;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69514__$1,inst_69512);
} else {
if((state_val_69515 === (4))){
var inst_69499 = (state_69514[(2)]);
var inst_69500 = fluree.db.util.log.error.call(null,inst_69499);
var inst_69501 = reject.call(null,inst_69499);
var state_69514__$1 = (function (){var statearr_69521 = state_69514;
(statearr_69521[(7)] = inst_69500);

return statearr_69521;
})();
var statearr_69522_69533 = state_69514__$1;
(statearr_69522_69533[(2)] = inst_69501);

(statearr_69522_69533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69515 === (5))){
var _ = (function (){var statearr_69523 = state_69514;
(statearr_69523[(4)] = cljs.core.rest.call(null,(state_69514[(4)])));

return statearr_69523;
})();
var state_69514__$1 = state_69514;
var ex69520 = (state_69514__$1[(2)]);
var statearr_69524_69534 = state_69514__$1;
(statearr_69524_69534[(5)] = ex69520);


var statearr_69525_69535 = state_69514__$1;
(statearr_69525_69535[(1)] = (4));

(statearr_69525_69535[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$resolve_ledger_$_state_machine__2726__auto__ = null;
var flureenjs$resolve_ledger_$_state_machine__2726__auto____0 = (function (){
var statearr_69526 = [null,null,null,null,null,null,null,null];
(statearr_69526[(0)] = flureenjs$resolve_ledger_$_state_machine__2726__auto__);

(statearr_69526[(1)] = (1));

return statearr_69526;
});
var flureenjs$resolve_ledger_$_state_machine__2726__auto____1 = (function (state_69514){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_69514);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e69527){var ex__2729__auto__ = e69527;
var statearr_69528_69536 = state_69514;
(statearr_69528_69536[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_69514[(4)]))){
var statearr_69529_69537 = state_69514;
(statearr_69529_69537[(1)] = cljs.core.first.call(null,(state_69514[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69538 = state_69514;
state_69514 = G__69538;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$resolve_ledger_$_state_machine__2726__auto__ = function(state_69514){
switch(arguments.length){
case 0:
return flureenjs$resolve_ledger_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$resolve_ledger_$_state_machine__2726__auto____1.call(this,state_69514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$resolve_ledger_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$resolve_ledger_$_state_machine__2726__auto____0;
flureenjs$resolve_ledger_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$resolve_ledger_$_state_machine__2726__auto____1;
return flureenjs$resolve_ledger_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_69530 = f__2749__auto__.call(null);
(statearr_69530[(6)] = c__2748__auto__);

return statearr_69530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.resolve_ledger', flureenjs.resolve_ledger);
/**
 * Returns actual session object for a given ledger.
 */
flureenjs.session = (function flureenjs$session(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_69554){
var state_val_69555 = (state_69554[(1)]);
if((state_val_69555 === (1))){
var state_69554__$1 = state_69554;
var statearr_69556_69571 = state_69554__$1;
(statearr_69556_69571[(2)] = null);

(statearr_69556_69571[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69555 === (2))){
var _ = (function (){var statearr_69557 = state_69554;
(statearr_69557[(4)] = cljs.core.cons.call(null,(5),(state_69554[(4)])));

return statearr_69557;
})();
var inst_69547 = fluree.db.session.session.call(null,conn,ledger);
var inst_69548 = cljs.core.clj__GT_js.call(null,inst_69547);
var inst_69549 = resolve.call(null,inst_69548);
var ___$1 = (function (){var statearr_69558 = state_69554;
(statearr_69558[(4)] = cljs.core.rest.call(null,(state_69554[(4)])));

return statearr_69558;
})();
var state_69554__$1 = state_69554;
var statearr_69559_69572 = state_69554__$1;
(statearr_69559_69572[(2)] = inst_69549);

(statearr_69559_69572[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69555 === (3))){
var inst_69552 = (state_69554[(2)]);
var state_69554__$1 = state_69554;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69554__$1,inst_69552);
} else {
if((state_val_69555 === (4))){
var inst_69539 = (state_69554[(2)]);
var inst_69540 = fluree.db.util.log.error.call(null,inst_69539);
var inst_69541 = reject.call(null,inst_69539);
var state_69554__$1 = (function (){var statearr_69561 = state_69554;
(statearr_69561[(7)] = inst_69540);

return statearr_69561;
})();
var statearr_69562_69573 = state_69554__$1;
(statearr_69562_69573[(2)] = inst_69541);

(statearr_69562_69573[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69555 === (5))){
var _ = (function (){var statearr_69563 = state_69554;
(statearr_69563[(4)] = cljs.core.rest.call(null,(state_69554[(4)])));

return statearr_69563;
})();
var state_69554__$1 = state_69554;
var ex69560 = (state_69554__$1[(2)]);
var statearr_69564_69574 = state_69554__$1;
(statearr_69564_69574[(5)] = ex69560);


var statearr_69565_69575 = state_69554__$1;
(statearr_69565_69575[(1)] = (4));

(statearr_69565_69575[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$session_$_state_machine__2726__auto__ = null;
var flureenjs$session_$_state_machine__2726__auto____0 = (function (){
var statearr_69566 = [null,null,null,null,null,null,null,null];
(statearr_69566[(0)] = flureenjs$session_$_state_machine__2726__auto__);

(statearr_69566[(1)] = (1));

return statearr_69566;
});
var flureenjs$session_$_state_machine__2726__auto____1 = (function (state_69554){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_69554);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e69567){var ex__2729__auto__ = e69567;
var statearr_69568_69576 = state_69554;
(statearr_69568_69576[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_69554[(4)]))){
var statearr_69569_69577 = state_69554;
(statearr_69569_69577[(1)] = cljs.core.first.call(null,(state_69554[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69578 = state_69554;
state_69554 = G__69578;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$session_$_state_machine__2726__auto__ = function(state_69554){
switch(arguments.length){
case 0:
return flureenjs$session_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$session_$_state_machine__2726__auto____1.call(this,state_69554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$session_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$session_$_state_machine__2726__auto____0;
flureenjs$session_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$session_$_state_machine__2726__auto____1;
return flureenjs$session_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_69570 = f__2749__auto__.call(null);
(statearr_69570[(6)] = c__2748__auto__);

return statearr_69570;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.session', flureenjs.session);
/**
 * Returns a promise containing search results of flake parts (flake-parts).
 */
flureenjs.search = (function flureenjs$search(db,flake_parts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_69602){
var state_val_69603 = (state_69602[(1)]);
if((state_val_69603 === (1))){
var state_69602__$1 = state_69602;
var statearr_69604_69620 = state_69602__$1;
(statearr_69604_69620[(2)] = null);

(statearr_69604_69620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (2))){
var _ = (function (){var statearr_69605 = state_69602;
(statearr_69605[(4)] = cljs.core.cons.call(null,(5),(state_69602[(4)])));

return statearr_69605;
})();
var inst_69587 = cljs.core.js__GT_clj.call(null,flake_parts);
var state_69602__$1 = (function (){var statearr_69606 = state_69602;
(statearr_69606[(7)] = inst_69587);

return statearr_69606;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69602__$1,(7),db);
} else {
if((state_val_69603 === (3))){
var inst_69600 = (state_69602[(2)]);
var state_69602__$1 = state_69602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69602__$1,inst_69600);
} else {
if((state_val_69603 === (4))){
var inst_69579 = (state_69602[(2)]);
var inst_69580 = fluree.db.util.log.error.call(null,inst_69579);
var inst_69581 = reject.call(null,inst_69579);
var state_69602__$1 = (function (){var statearr_69608 = state_69602;
(statearr_69608[(8)] = inst_69580);

return statearr_69608;
})();
var statearr_69609_69621 = state_69602__$1;
(statearr_69609_69621[(2)] = inst_69581);

(statearr_69609_69621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (5))){
var _ = (function (){var statearr_69610 = state_69602;
(statearr_69610[(4)] = cljs.core.rest.call(null,(state_69602[(4)])));

return statearr_69610;
})();
var state_69602__$1 = state_69602;
var ex69607 = (state_69602__$1[(2)]);
var statearr_69611_69622 = state_69602__$1;
(statearr_69611_69622[(5)] = ex69607);


var statearr_69612_69623 = state_69602__$1;
(statearr_69612_69623[(1)] = (4));

(statearr_69612_69623[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (6))){
var inst_69593 = (state_69602[(2)]);
var inst_69594 = fluree.db.util.async.throw_err.call(null,inst_69593);
var inst_69595 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_69594);
var inst_69596 = cljs.core.clj__GT_js.call(null,inst_69595);
var inst_69597 = resolve.call(null,inst_69596);
var _ = (function (){var statearr_69613 = state_69602;
(statearr_69613[(4)] = cljs.core.rest.call(null,(state_69602[(4)])));

return statearr_69613;
})();
var state_69602__$1 = state_69602;
var statearr_69614_69624 = state_69602__$1;
(statearr_69614_69624[(2)] = inst_69597);

(statearr_69614_69624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69603 === (7))){
var inst_69587 = (state_69602[(7)]);
var inst_69589 = (state_69602[(2)]);
var inst_69590 = fluree.db.util.async.throw_err.call(null,inst_69589);
var inst_69591 = fluree.db.dbproto._search.call(null,inst_69590,inst_69587);
var state_69602__$1 = state_69602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69602__$1,(6),inst_69591);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$search_$_state_machine__2726__auto__ = null;
var flureenjs$search_$_state_machine__2726__auto____0 = (function (){
var statearr_69615 = [null,null,null,null,null,null,null,null,null];
(statearr_69615[(0)] = flureenjs$search_$_state_machine__2726__auto__);

(statearr_69615[(1)] = (1));

return statearr_69615;
});
var flureenjs$search_$_state_machine__2726__auto____1 = (function (state_69602){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_69602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e69616){var ex__2729__auto__ = e69616;
var statearr_69617_69625 = state_69602;
(statearr_69617_69625[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_69602[(4)]))){
var statearr_69618_69626 = state_69602;
(statearr_69618_69626[(1)] = cljs.core.first.call(null,(state_69602[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69627 = state_69602;
state_69602 = G__69627;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$search_$_state_machine__2726__auto__ = function(state_69602){
switch(arguments.length){
case 0:
return flureenjs$search_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$search_$_state_machine__2726__auto____1.call(this,state_69602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$search_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$search_$_state_machine__2726__auto____0;
flureenjs$search_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$search_$_state_machine__2726__auto____1;
return flureenjs$search_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_69619 = f__2749__auto__.call(null);
(statearr_69619[(6)] = c__2748__auto__);

return statearr_69619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.search', flureenjs.search);
/**
 * Returns a promise containing a new db based on the provided db,
 * including the provided flakes. Flakes can contain one or more 't's,
 * but should be sequential and start after the current 't' of the provided
 * db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.). Remember
 * 't' is negative and thus should be in descending order.
 * 
 * A forward-time-travel db can be further forward-time-traveled.
 * 
 * A forward-time travel DB is held in memory, and is not shared across servers.
 * Ensure you have adequate memory to hold the flakes you generate and add. If
 * access is provided via an external API, do any desired size restrictions or
 * controls within your API endpoint.
 * 
 * Remember schema operations done via forward-time-travel should be done in a
 * 't' prior to the flakes that end up requiring the schema change.
 */
flureenjs.forward_time_travel = (function flureenjs$forward_time_travel(db,flakes){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_69648){
var state_val_69649 = (state_69648[(1)]);
if((state_val_69649 === (1))){
var state_69648__$1 = state_69648;
var statearr_69650_69666 = state_69648__$1;
(statearr_69650_69666[(2)] = null);

(statearr_69650_69666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (2))){
var _ = (function (){var statearr_69651 = state_69648;
(statearr_69651[(4)] = cljs.core.cons.call(null,(5),(state_69648[(4)])));

return statearr_69651;
})();
var inst_69636 = cljs.core.js__GT_clj.call(null,flakes);
var inst_69637 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_69636);
var state_69648__$1 = (function (){var statearr_69652 = state_69648;
(statearr_69652[(7)] = inst_69637);

return statearr_69652;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69648__$1,(6),db);
} else {
if((state_val_69649 === (3))){
var inst_69646 = (state_69648[(2)]);
var state_69648__$1 = state_69648;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69648__$1,inst_69646);
} else {
if((state_val_69649 === (4))){
var inst_69628 = (state_69648[(2)]);
var inst_69629 = fluree.db.util.log.error.call(null,inst_69628);
var inst_69630 = reject.call(null,inst_69628);
var state_69648__$1 = (function (){var statearr_69654 = state_69648;
(statearr_69654[(8)] = inst_69629);

return statearr_69654;
})();
var statearr_69655_69667 = state_69648__$1;
(statearr_69655_69667[(2)] = inst_69630);

(statearr_69655_69667[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (5))){
var _ = (function (){var statearr_69656 = state_69648;
(statearr_69656[(4)] = cljs.core.rest.call(null,(state_69648[(4)])));

return statearr_69656;
})();
var state_69648__$1 = state_69648;
var ex69653 = (state_69648__$1[(2)]);
var statearr_69657_69668 = state_69648__$1;
(statearr_69657_69668[(5)] = ex69653);


var statearr_69658_69669 = state_69648__$1;
(statearr_69658_69669[(1)] = (4));

(statearr_69658_69669[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69649 === (6))){
var inst_69637 = (state_69648[(7)]);
var inst_69639 = (state_69648[(2)]);
var inst_69640 = fluree.db.util.async.throw_err.call(null,inst_69639);
var inst_69641 = fluree.db.graphdb.forward_time_travel.call(null,inst_69640,null,inst_69637);
var inst_69642 = cljs.core.clj__GT_js.call(null,inst_69641);
var inst_69643 = resolve.call(null,inst_69642);
var _ = (function (){var statearr_69659 = state_69648;
(statearr_69659[(4)] = cljs.core.rest.call(null,(state_69648[(4)])));

return statearr_69659;
})();
var state_69648__$1 = state_69648;
var statearr_69660_69670 = state_69648__$1;
(statearr_69660_69670[(2)] = inst_69643);

(statearr_69660_69670[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$forward_time_travel_$_state_machine__2726__auto__ = null;
var flureenjs$forward_time_travel_$_state_machine__2726__auto____0 = (function (){
var statearr_69661 = [null,null,null,null,null,null,null,null,null];
(statearr_69661[(0)] = flureenjs$forward_time_travel_$_state_machine__2726__auto__);

(statearr_69661[(1)] = (1));

return statearr_69661;
});
var flureenjs$forward_time_travel_$_state_machine__2726__auto____1 = (function (state_69648){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_69648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e69662){var ex__2729__auto__ = e69662;
var statearr_69663_69671 = state_69648;
(statearr_69663_69671[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_69648[(4)]))){
var statearr_69664_69672 = state_69648;
(statearr_69664_69672[(1)] = cljs.core.first.call(null,(state_69648[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69673 = state_69648;
state_69648 = G__69673;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$forward_time_travel_$_state_machine__2726__auto__ = function(state_69648){
switch(arguments.length){
case 0:
return flureenjs$forward_time_travel_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$forward_time_travel_$_state_machine__2726__auto____1.call(this,state_69648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$forward_time_travel_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$forward_time_travel_$_state_machine__2726__auto____0;
flureenjs$forward_time_travel_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$forward_time_travel_$_state_machine__2726__auto____1;
return flureenjs$forward_time_travel_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_69665 = f__2749__auto__.call(null);
(statearr_69665[(6)] = c__2748__auto__);

return statearr_69665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.forward_time_travel', flureenjs.forward_time_travel);
/**
 * Returns true if provided db is a forward-time-travel db.
 */
flureenjs.is_forward_time_travel_db = (function flureenjs$is_forward_time_travel_db(db){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_69697){
var state_val_69698 = (state_69697[(1)]);
if((state_val_69698 === (7))){
var state_69697__$1 = state_69697;
var statearr_69699_69718 = state_69697__$1;
(statearr_69699_69718[(2)] = db);

(statearr_69699_69718[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69698 === (1))){
var state_69697__$1 = state_69697;
var statearr_69700_69719 = state_69697__$1;
(statearr_69700_69719[(2)] = null);

(statearr_69700_69719[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69698 === (4))){
var inst_69674 = (state_69697[(2)]);
var inst_69675 = fluree.db.util.log.error.call(null,inst_69674);
var inst_69676 = reject.call(null,inst_69674);
var state_69697__$1 = (function (){var statearr_69701 = state_69697;
(statearr_69701[(7)] = inst_69675);

return statearr_69701;
})();
var statearr_69702_69720 = state_69697__$1;
(statearr_69702_69720[(2)] = inst_69676);

(statearr_69702_69720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69698 === (6))){
var state_69697__$1 = state_69697;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69697__$1,(9),db);
} else {
if((state_val_69698 === (3))){
var inst_69695 = (state_69697[(2)]);
var state_69697__$1 = state_69697;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69697__$1,inst_69695);
} else {
if((state_val_69698 === (2))){
var _ = (function (){var statearr_69704 = state_69697;
(statearr_69704[(4)] = cljs.core.cons.call(null,(5),(state_69697[(4)])));

return statearr_69704;
})();
var inst_69682 = fluree.db.util.async.channel_QMARK_.call(null,db);
var state_69697__$1 = state_69697;
if(inst_69682){
var statearr_69705_69721 = state_69697__$1;
(statearr_69705_69721[(1)] = (6));

} else {
var statearr_69706_69722 = state_69697__$1;
(statearr_69706_69722[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69698 === (9))){
var inst_69685 = (state_69697[(2)]);
var inst_69686 = fluree.db.util.async.throw_err.call(null,inst_69685);
var state_69697__$1 = state_69697;
var statearr_69707_69723 = state_69697__$1;
(statearr_69707_69723[(2)] = inst_69686);

(statearr_69707_69723[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69698 === (5))){
var _ = (function (){var statearr_69708 = state_69697;
(statearr_69708[(4)] = cljs.core.rest.call(null,(state_69697[(4)])));

return statearr_69708;
})();
var state_69697__$1 = state_69697;
var ex69703 = (state_69697__$1[(2)]);
var statearr_69709_69724 = state_69697__$1;
(statearr_69709_69724[(5)] = ex69703);


var statearr_69710_69725 = state_69697__$1;
(statearr_69710_69725[(1)] = (4));

(statearr_69710_69725[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69698 === (8))){
var inst_69689 = (state_69697[(2)]);
var inst_69690 = fluree.db.graphdb.forward_time_travel_db_QMARK_.call(null,inst_69689);
var inst_69691 = cljs.core.clj__GT_js.call(null,inst_69690);
var inst_69692 = resolve.call(null,inst_69691);
var _ = (function (){var statearr_69711 = state_69697;
(statearr_69711[(4)] = cljs.core.rest.call(null,(state_69697[(4)])));

return statearr_69711;
})();
var state_69697__$1 = state_69697;
var statearr_69712_69726 = state_69697__$1;
(statearr_69712_69726[(2)] = inst_69692);

(statearr_69712_69726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$is_forward_time_travel_db_$_state_machine__2726__auto__ = null;
var flureenjs$is_forward_time_travel_db_$_state_machine__2726__auto____0 = (function (){
var statearr_69713 = [null,null,null,null,null,null,null,null];
(statearr_69713[(0)] = flureenjs$is_forward_time_travel_db_$_state_machine__2726__auto__);

(statearr_69713[(1)] = (1));

return statearr_69713;
});
var flureenjs$is_forward_time_travel_db_$_state_machine__2726__auto____1 = (function (state_69697){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_69697);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e69714){var ex__2729__auto__ = e69714;
var statearr_69715_69727 = state_69697;
(statearr_69715_69727[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_69697[(4)]))){
var statearr_69716_69728 = state_69697;
(statearr_69716_69728[(1)] = cljs.core.first.call(null,(state_69697[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69729 = state_69697;
state_69697 = G__69729;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$is_forward_time_travel_db_$_state_machine__2726__auto__ = function(state_69697){
switch(arguments.length){
case 0:
return flureenjs$is_forward_time_travel_db_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$is_forward_time_travel_db_$_state_machine__2726__auto____1.call(this,state_69697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$is_forward_time_travel_db_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$is_forward_time_travel_db_$_state_machine__2726__auto____0;
flureenjs$is_forward_time_travel_db_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$is_forward_time_travel_db_$_state_machine__2726__auto____1;
return flureenjs$is_forward_time_travel_db_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_69717 = f__2749__auto__.call(null);
(statearr_69717[(6)] = c__2748__auto__);

return statearr_69717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.is_forward_time_travel_db', flureenjs.is_forward_time_travel_db);
/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureenjs.monitor_tx = (function flureenjs$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_69749){
var state_val_69750 = (state_69749[(1)]);
if((state_val_69750 === (1))){
var state_69749__$1 = state_69749;
var statearr_69751_69767 = state_69749__$1;
(statearr_69751_69767[(2)] = null);

(statearr_69751_69767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69750 === (2))){
var _ = (function (){var statearr_69752 = state_69749;
(statearr_69752[(4)] = cljs.core.cons.call(null,(5),(state_69749[(4)])));

return statearr_69752;
})();
var inst_69739 = fluree.db.connection_js.check_connection.call(null,conn);
var inst_69740 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,txid,timeout_ms);
var state_69749__$1 = (function (){var statearr_69753 = state_69749;
(statearr_69753[(7)] = inst_69739);

return statearr_69753;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69749__$1,(6),inst_69740);
} else {
if((state_val_69750 === (3))){
var inst_69747 = (state_69749[(2)]);
var state_69749__$1 = state_69749;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69749__$1,inst_69747);
} else {
if((state_val_69750 === (4))){
var inst_69730 = (state_69749[(2)]);
var inst_69731 = fluree.db.util.log.error.call(null,inst_69730);
var inst_69732 = cljs.core.clj__GT_js.call(null,inst_69730);
var inst_69733 = reject.call(null,inst_69732);
var state_69749__$1 = (function (){var statearr_69755 = state_69749;
(statearr_69755[(8)] = inst_69731);

return statearr_69755;
})();
var statearr_69756_69768 = state_69749__$1;
(statearr_69756_69768[(2)] = inst_69733);

(statearr_69756_69768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69750 === (5))){
var _ = (function (){var statearr_69757 = state_69749;
(statearr_69757[(4)] = cljs.core.rest.call(null,(state_69749[(4)])));

return statearr_69757;
})();
var state_69749__$1 = state_69749;
var ex69754 = (state_69749__$1[(2)]);
var statearr_69758_69769 = state_69749__$1;
(statearr_69758_69769[(5)] = ex69754);


var statearr_69759_69770 = state_69749__$1;
(statearr_69759_69770[(1)] = (4));

(statearr_69759_69770[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69750 === (6))){
var inst_69742 = (state_69749[(2)]);
var inst_69743 = cljs.core.clj__GT_js.call(null,inst_69742);
var inst_69744 = resolve.call(null,inst_69743);
var _ = (function (){var statearr_69760 = state_69749;
(statearr_69760[(4)] = cljs.core.rest.call(null,(state_69749[(4)])));

return statearr_69760;
})();
var state_69749__$1 = state_69749;
var statearr_69761_69771 = state_69749__$1;
(statearr_69761_69771[(2)] = inst_69744);

(statearr_69761_69771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$monitor_tx_$_state_machine__2726__auto__ = null;
var flureenjs$monitor_tx_$_state_machine__2726__auto____0 = (function (){
var statearr_69762 = [null,null,null,null,null,null,null,null,null];
(statearr_69762[(0)] = flureenjs$monitor_tx_$_state_machine__2726__auto__);

(statearr_69762[(1)] = (1));

return statearr_69762;
});
var flureenjs$monitor_tx_$_state_machine__2726__auto____1 = (function (state_69749){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_69749);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e69763){var ex__2729__auto__ = e69763;
var statearr_69764_69772 = state_69749;
(statearr_69764_69772[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_69749[(4)]))){
var statearr_69765_69773 = state_69749;
(statearr_69765_69773[(1)] = cljs.core.first.call(null,(state_69749[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69774 = state_69749;
state_69749 = G__69774;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$monitor_tx_$_state_machine__2726__auto__ = function(state_69749){
switch(arguments.length){
case 0:
return flureenjs$monitor_tx_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$monitor_tx_$_state_machine__2726__auto____1.call(this,state_69749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$monitor_tx_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$monitor_tx_$_state_machine__2726__auto____0;
flureenjs$monitor_tx_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$monitor_tx_$_state_machine__2726__auto____1;
return flureenjs$monitor_tx_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_69766 = f__2749__auto__.call(null);
(statearr_69766[(6)] = c__2748__auto__);

return statearr_69766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.monitor_tx', flureenjs.monitor_tx);
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
flureenjs.tx__GT_command = (function flureenjs$tx__GT_command(var_args){
var G__69776 = arguments.length;
switch (G__69776) {
case 3:
return flureenjs.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return flureenjs.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(flureenjs.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_69885){
var state_val_69886 = (state_69885[(1)]);
if((state_val_69886 === (7))){
var state_69885__$1 = state_69885;
var statearr_69887_69954 = state_69885__$1;
(statearr_69887_69954[(2)] = ledger);

(statearr_69887_69954[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (20))){
var inst_69802 = (state_69885[(7)]);
var inst_69842 = (state_69885[(2)]);
var inst_69843 = cljs.core.nth.call(null,inst_69842,(0),null);
var inst_69844 = cljs.core.nth.call(null,inst_69842,(1),null);
var inst_69845 = fluree.db.util.core.current_time_millis.call(null);
var state_69885__$1 = (function (){var statearr_69888 = state_69885;
(statearr_69888[(8)] = inst_69845);

(statearr_69888[(9)] = inst_69844);

(statearr_69888[(10)] = inst_69843);

return statearr_69888;
})();
if(cljs.core.truth_(inst_69802)){
var statearr_69889_69955 = state_69885__$1;
(statearr_69889_69955[(1)] = (27));

} else {
var statearr_69890_69956 = state_69885__$1;
(statearr_69890_69956[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (27))){
var inst_69802 = (state_69885[(7)]);
var state_69885__$1 = state_69885;
var statearr_69891_69957 = state_69885__$1;
(statearr_69891_69957[(2)] = inst_69802);

(statearr_69891_69957[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (1))){
var state_69885__$1 = state_69885;
var statearr_69892_69958 = state_69885__$1;
(statearr_69892_69958[(2)] = null);

(statearr_69892_69958[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (24))){
var inst_69816 = (state_69885[(11)]);
var inst_69833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69834 = [inst_69816,null];
var inst_69835 = (new cljs.core.PersistentVector(null,2,(5),inst_69833,inst_69834,null));
var state_69885__$1 = state_69885;
var statearr_69893_69959 = state_69885__$1;
(statearr_69893_69959[(2)] = inst_69835);

(statearr_69893_69959[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (4))){
var inst_69777 = (state_69885[(2)]);
var inst_69778 = fluree.db.util.log.error.call(null,inst_69777);
var inst_69779 = cljs.core.clj__GT_js.call(null,inst_69777);
var inst_69780 = reject.call(null,inst_69779);
var state_69885__$1 = (function (){var statearr_69894 = state_69885;
(statearr_69894[(12)] = inst_69778);

return statearr_69894;
})();
var statearr_69895_69960 = state_69885__$1;
(statearr_69895_69960[(2)] = inst_69780);

(statearr_69895_69960[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (15))){
var inst_69816 = (state_69885[(11)]);
var inst_69800 = (state_69885[(13)]);
var inst_69818 = cljs.core.not_EQ_.call(null,inst_69800,inst_69816);
var state_69885__$1 = state_69885;
var statearr_69896_69961 = state_69885__$1;
(statearr_69896_69961[(2)] = inst_69818);

(statearr_69896_69961[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (21))){
var inst_69800 = (state_69885[(13)]);
var inst_69828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69829 = [inst_69800,null];
var inst_69830 = (new cljs.core.PersistentVector(null,2,(5),inst_69828,inst_69829,null));
var state_69885__$1 = state_69885;
var statearr_69897_69962 = state_69885__$1;
(statearr_69897_69962[(2)] = inst_69830);

(statearr_69897_69962[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (31))){
var inst_69845 = (state_69885[(8)]);
var inst_69852 = (inst_69845 + (30000));
var state_69885__$1 = state_69885;
var statearr_69898_69963 = state_69885__$1;
(statearr_69898_69963[(2)] = inst_69852);

(statearr_69898_69963[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (32))){
var inst_69854 = (state_69885[(2)]);
var state_69885__$1 = (function (){var statearr_69899 = state_69885;
(statearr_69899[(14)] = inst_69854);

return statearr_69899;
})();
var statearr_69900_69964 = state_69885__$1;
(statearr_69900_69964[(2)] = null);

(statearr_69900_69964[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (33))){
var inst_69854 = (state_69885[(14)]);
var inst_69803 = (state_69885[(15)]);
var inst_69849 = (state_69885[(16)]);
var inst_69844 = (state_69885[(9)]);
var inst_69797 = (state_69885[(17)]);
var inst_69843 = (state_69885[(10)]);
var _ = (function (){var statearr_69901 = state_69885;
(statearr_69901[(4)] = cljs.core.cons.call(null,(36),(state_69885[(4)])));

return statearr_69901;
})();
var inst_69867 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"authority","authority",-551669367),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"deps","deps",1883360319)];
var inst_69868 = [new cljs.core.Keyword(null,"tx","tx",466630418),inst_69797,txn,inst_69849,inst_69843,inst_69844,inst_69854,inst_69803];
var inst_69869 = cljs.core.PersistentHashMap.fromArrays(inst_69867,inst_69868);
var inst_69870 = fluree.db.util.core.without_nils.call(null,inst_69869);
var inst_69871 = fluree.db.util.json.stringify.call(null,inst_69870);
var ___$1 = (function (){var statearr_69902 = state_69885;
(statearr_69902[(4)] = cljs.core.rest.call(null,(state_69885[(4)])));

return statearr_69902;
})();
var state_69885__$1 = state_69885;
var statearr_69903_69965 = state_69885__$1;
(statearr_69903_69965[(2)] = inst_69871);

(statearr_69903_69965[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (13))){
var inst_69808 = ["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('');
var inst_69809 = (new Error(inst_69808));
var inst_69810 = (function(){throw inst_69809})();
var state_69885__$1 = state_69885;
var statearr_69905_69966 = state_69885__$1;
(statearr_69905_69966[(2)] = inst_69810);

(statearr_69905_69966[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (22))){
var state_69885__$1 = state_69885;
var statearr_69906_69967 = state_69885__$1;
(statearr_69906_69967[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (36))){
var _ = (function (){var statearr_69908 = state_69885;
(statearr_69908[(4)] = cljs.core.rest.call(null,(state_69885[(4)])));

return statearr_69908;
})();
var state_69885__$1 = state_69885;
var ex69904 = (state_69885__$1[(2)]);
var statearr_69909_69968 = state_69885__$1;
(statearr_69909_69968[(5)] = ex69904);


var statearr_69910_69969 = state_69885__$1;
(statearr_69910_69969[(1)] = (35));

(statearr_69910_69969[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (29))){
var inst_69801 = (state_69885[(18)]);
var inst_69849 = (state_69885[(2)]);
var state_69885__$1 = (function (){var statearr_69911 = state_69885;
(statearr_69911[(16)] = inst_69849);

return statearr_69911;
})();
if(cljs.core.truth_(inst_69801)){
var statearr_69912_69970 = state_69885__$1;
(statearr_69912_69970[(1)] = (30));

} else {
var statearr_69913_69971 = state_69885__$1;
(statearr_69913_69971[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (6))){
var inst_69792 = cljs.core.first.call(null,ledger);
var inst_69793 = cljs.core.second.call(null,ledger);
var inst_69794 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69792),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_69793)].join('');
var state_69885__$1 = state_69885;
var statearr_69914_69972 = state_69885__$1;
(statearr_69914_69972[(2)] = inst_69794);

(statearr_69914_69972[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (28))){
var inst_69845 = (state_69885[(8)]);
var state_69885__$1 = state_69885;
var statearr_69915_69973 = state_69885__$1;
(statearr_69915_69973[(2)] = inst_69845);

(statearr_69915_69973[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (25))){
var state_69885__$1 = state_69885;
var statearr_69916_69974 = state_69885__$1;
(statearr_69916_69974[(2)] = null);

(statearr_69916_69974[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (34))){
var inst_69874 = (state_69885[(2)]);
var inst_69875 = fluree.crypto.sign_message.call(null,inst_69874,private_key);
var inst_69876 = fluree.crypto.sha3_256.call(null,inst_69874);
var inst_69877 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"db","db",993250759)];
var inst_69878 = [inst_69874,inst_69875,inst_69876,ledger];
var inst_69879 = cljs.core.PersistentHashMap.fromArrays(inst_69877,inst_69878);
var inst_69880 = resolve.call(null,inst_69879);
var _ = (function (){var statearr_69917 = state_69885;
(statearr_69917[(4)] = cljs.core.rest.call(null,(state_69885[(4)])));

return statearr_69917;
})();
var state_69885__$1 = state_69885;
var statearr_69918_69975 = state_69885__$1;
(statearr_69918_69975[(2)] = inst_69880);

(statearr_69918_69975[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (17))){
var inst_69821 = (state_69885[(2)]);
var state_69885__$1 = state_69885;
if(cljs.core.truth_(inst_69821)){
var statearr_69919_69976 = state_69885__$1;
(statearr_69919_69976[(1)] = (18));

} else {
var statearr_69920_69977 = state_69885__$1;
(statearr_69920_69977[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (3))){
var inst_69883 = (state_69885[(2)]);
var state_69885__$1 = state_69885;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69885__$1,inst_69883);
} else {
if((state_val_69886 === (12))){
var state_69885__$1 = state_69885;
var statearr_69921_69978 = state_69885__$1;
(statearr_69921_69978[(2)] = null);

(statearr_69921_69978[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (2))){
var _ = (function (){var statearr_69922 = state_69885;
(statearr_69922[(4)] = cljs.core.cons.call(null,(5),(state_69885[(4)])));

return statearr_69922;
})();
var inst_69790 = cljs.core.sequential_QMARK_.call(null,ledger);
var state_69885__$1 = state_69885;
if(inst_69790){
var statearr_69923_69979 = state_69885__$1;
(statearr_69923_69979[(1)] = (6));

} else {
var statearr_69924_69980 = state_69885__$1;
(statearr_69924_69980[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (23))){
var inst_69840 = (state_69885[(2)]);
var state_69885__$1 = state_69885;
var statearr_69925_69981 = state_69885__$1;
(statearr_69925_69981[(2)] = inst_69840);

(statearr_69925_69981[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (35))){
var inst_69855 = (state_69885[(2)]);
var inst_69856 = fluree.db.util.log.error.call(null,inst_69855);
var inst_69857 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69858 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_69859 = cljs.core.PersistentHashMap.fromArrays(inst_69857,inst_69858);
var inst_69860 = cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",inst_69859);
var inst_69861 = (function(){throw inst_69860})();
var state_69885__$1 = (function (){var statearr_69926 = state_69885;
(statearr_69926[(19)] = inst_69856);

return statearr_69926;
})();
var statearr_69927_69982 = state_69885__$1;
(statearr_69927_69982[(2)] = inst_69861);

(statearr_69927_69982[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (19))){
var inst_69800 = (state_69885[(13)]);
var state_69885__$1 = state_69885;
if(cljs.core.truth_(inst_69800)){
var statearr_69928_69983 = state_69885__$1;
(statearr_69928_69983[(1)] = (21));

} else {
var statearr_69929_69984 = state_69885__$1;
(statearr_69929_69984[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (11))){
var inst_69800 = (state_69885[(13)]);
var inst_69815 = (state_69885[(2)]);
var inst_69816 = fluree.crypto.account_id_from_private.call(null,private_key);
var state_69885__$1 = (function (){var statearr_69931 = state_69885;
(statearr_69931[(20)] = inst_69815);

(statearr_69931[(11)] = inst_69816);

return statearr_69931;
})();
if(cljs.core.truth_(inst_69800)){
var statearr_69932_69985 = state_69885__$1;
(statearr_69932_69985[(1)] = (15));

} else {
var statearr_69933_69986 = state_69885__$1;
(statearr_69933_69986[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (9))){
var inst_69803 = (state_69885[(15)]);
var inst_69805 = cljs.core.sequential_QMARK_.call(null,inst_69803);
var state_69885__$1 = state_69885;
if(inst_69805){
var statearr_69934_69987 = state_69885__$1;
(statearr_69934_69987[(1)] = (12));

} else {
var statearr_69935_69988 = state_69885__$1;
(statearr_69935_69988[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (5))){
var _ = (function (){var statearr_69936 = state_69885;
(statearr_69936[(4)] = cljs.core.rest.call(null,(state_69885[(4)])));

return statearr_69936;
})();
var state_69885__$1 = state_69885;
var ex69930 = (state_69885__$1[(2)]);
var statearr_69937_69989 = state_69885__$1;
(statearr_69937_69989[(5)] = ex69930);


var statearr_69938_69990 = state_69885__$1;
(statearr_69938_69990[(1)] = (4));

(statearr_69938_69990[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (14))){
var inst_69812 = (state_69885[(2)]);
var state_69885__$1 = state_69885;
var statearr_69939_69991 = state_69885__$1;
(statearr_69939_69991[(2)] = inst_69812);

(statearr_69939_69991[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (26))){
var inst_69838 = (state_69885[(2)]);
var state_69885__$1 = state_69885;
var statearr_69940_69992 = state_69885__$1;
(statearr_69940_69992[(2)] = inst_69838);

(statearr_69940_69992[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (16))){
var inst_69800 = (state_69885[(13)]);
var state_69885__$1 = state_69885;
var statearr_69941_69993 = state_69885__$1;
(statearr_69941_69993[(2)] = inst_69800);

(statearr_69941_69993[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (30))){
var inst_69801 = (state_69885[(18)]);
var state_69885__$1 = state_69885;
var statearr_69942_69994 = state_69885__$1;
(statearr_69942_69994[(2)] = inst_69801);

(statearr_69942_69994[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (10))){
var state_69885__$1 = state_69885;
var statearr_69943_69995 = state_69885__$1;
(statearr_69943_69995[(2)] = null);

(statearr_69943_69995[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (18))){
var inst_69816 = (state_69885[(11)]);
var inst_69800 = (state_69885[(13)]);
var inst_69823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69824 = [inst_69800,inst_69816];
var inst_69825 = (new cljs.core.PersistentVector(null,2,(5),inst_69823,inst_69824,null));
var state_69885__$1 = state_69885;
var statearr_69944_69996 = state_69885__$1;
(statearr_69944_69996[(2)] = inst_69825);

(statearr_69944_69996[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69886 === (8))){
var inst_69803 = (state_69885[(15)]);
var inst_69797 = (state_69885[(2)]);
var inst_69798 = opts;
var inst_69799 = cljs.core.__destructure_map.call(null,inst_69798);
var inst_69800 = cljs.core.get.call(null,inst_69799,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69801 = cljs.core.get.call(null,inst_69799,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_69802 = cljs.core.get.call(null,inst_69799,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_69803__$1 = cljs.core.get.call(null,inst_69799,new cljs.core.Keyword(null,"deps","deps",1883360319));
var state_69885__$1 = (function (){var statearr_69945 = state_69885;
(statearr_69945[(15)] = inst_69803__$1);

(statearr_69945[(13)] = inst_69800);

(statearr_69945[(17)] = inst_69797);

(statearr_69945[(18)] = inst_69801);

(statearr_69945[(7)] = inst_69802);

return statearr_69945;
})();
if(cljs.core.truth_(inst_69803__$1)){
var statearr_69946_69997 = state_69885__$1;
(statearr_69946_69997[(1)] = (9));

} else {
var statearr_69947_69998 = state_69885__$1;
(statearr_69947_69998[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_69948 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69948[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_69948[(1)] = (1));

return statearr_69948;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_69885){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_69885);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e69949){var ex__2729__auto__ = e69949;
var statearr_69950_69999 = state_69885;
(statearr_69950_69999[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_69885[(4)]))){
var statearr_69951_70000 = state_69885;
(statearr_69951_70000[(1)] = cljs.core.first.call(null,(state_69885[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70001 = state_69885;
state_69885 = G__70001;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_69885){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_69885);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_69952 = f__2749__auto__.call(null);
(statearr_69952[(6)] = c__2748__auto__);

return statearr_69952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.tx__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 */
flureenjs.transact = (function flureenjs$transact(var_args){
var G__70003 = arguments.length;
switch (G__70003) {
case 3:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.transact', flureenjs.transact);

(flureenjs.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureenjs.transact.call(null,conn,ledger,txn,null);
}));

(flureenjs.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_70029){
var state_val_70030 = (state_70029[(1)]);
if((state_val_70030 === (7))){
var inst_70015 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_70029__$1 = state_70029;
var statearr_70031_70052 = state_70029__$1;
(statearr_70031_70052[(2)] = inst_70015);

(statearr_70031_70052[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70030 === (1))){
var state_70029__$1 = state_70029;
var statearr_70032_70053 = state_70029__$1;
(statearr_70032_70053[(2)] = null);

(statearr_70032_70053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70030 === (4))){
var inst_70004 = (state_70029[(2)]);
var inst_70005 = fluree.db.util.log.error.call(null,inst_70004);
var inst_70006 = reject.call(null,inst_70004);
var state_70029__$1 = (function (){var statearr_70033 = state_70029;
(statearr_70033[(7)] = inst_70005);

return statearr_70033;
})();
var statearr_70034_70054 = state_70029__$1;
(statearr_70034_70054[(2)] = inst_70006);

(statearr_70034_70054[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70030 === (6))){
var state_70029__$1 = state_70029;
var statearr_70035_70055 = state_70029__$1;
(statearr_70035_70055[(2)] = null);

(statearr_70035_70055[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70030 === (3))){
var inst_70027 = (state_70029[(2)]);
var state_70029__$1 = state_70029;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70029__$1,inst_70027);
} else {
if((state_val_70030 === (2))){
var _ = (function (){var statearr_70037 = state_70029;
(statearr_70037[(4)] = cljs.core.cons.call(null,(5),(state_70029[(4)])));

return statearr_70037;
})();
var inst_70012 = (opts == null);
var state_70029__$1 = state_70029;
if(cljs.core.truth_(inst_70012)){
var statearr_70038_70056 = state_70029__$1;
(statearr_70038_70056[(1)] = (6));

} else {
var statearr_70039_70057 = state_70029__$1;
(statearr_70039_70057[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70030 === (9))){
var inst_70022 = (state_70029[(2)]);
var inst_70023 = cljs.core.clj__GT_js.call(null,inst_70022);
var inst_70024 = resolve.call(null,inst_70023);
var _ = (function (){var statearr_70040 = state_70029;
(statearr_70040[(4)] = cljs.core.rest.call(null,(state_70029[(4)])));

return statearr_70040;
})();
var state_70029__$1 = state_70029;
var statearr_70041_70058 = state_70029__$1;
(statearr_70041_70058[(2)] = inst_70024);

(statearr_70041_70058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70030 === (5))){
var _ = (function (){var statearr_70042 = state_70029;
(statearr_70042[(4)] = cljs.core.rest.call(null,(state_70029[(4)])));

return statearr_70042;
})();
var state_70029__$1 = state_70029;
var ex70036 = (state_70029__$1[(2)]);
var statearr_70043_70059 = state_70029__$1;
(statearr_70043_70059[(5)] = ex70036);


var statearr_70044_70060 = state_70029__$1;
(statearr_70044_70060[(1)] = (4));

(statearr_70044_70060[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70030 === (8))){
var inst_70017 = (state_70029[(2)]);
var inst_70018 = fluree.db.connection_js.check_connection.call(null,conn,inst_70017);
var inst_70019 = cljs.core.js__GT_clj.call(null,txn,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70020 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_70019,inst_70017);
var state_70029__$1 = (function (){var statearr_70045 = state_70029;
(statearr_70045[(8)] = inst_70018);

return statearr_70045;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70029__$1,(9),inst_70020);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_70046 = [null,null,null,null,null,null,null,null,null];
(statearr_70046[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_70046[(1)] = (1));

return statearr_70046;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_70029){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_70029);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e70047){var ex__2729__auto__ = e70047;
var statearr_70048_70061 = state_70029;
(statearr_70048_70061[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_70029[(4)]))){
var statearr_70049_70062 = state_70029;
(statearr_70049_70062[(1)] = cljs.core.first.call(null,(state_70029[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70063 = state_70029;
state_70029 = G__70063;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_70029){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_70029);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_70050 = f__2749__auto__.call(null);
(statearr_70050[(6)] = c__2748__auto__);

return statearr_70050;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureenjs.block_range_with_txn = (function flureenjs$block_range_with_txn(var_args){
var G__70065 = arguments.length;
switch (G__70065) {
case 3:
return flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_range_with_txn', flureenjs.block_range_with_txn);

(flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureenjs.block_range_with_txn.call(null,conn,ledger,block_map,null);
}));

(flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_70094){
var state_val_70095 = (state_70094[(1)]);
if((state_val_70095 === (1))){
var state_70094__$1 = state_70094;
var statearr_70096_70113 = state_70094__$1;
(statearr_70096_70113[(2)] = null);

(statearr_70096_70113[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70095 === (2))){
var inst_70075 = (state_70094[(7)]);
var _ = (function (){var statearr_70097 = state_70094;
(statearr_70097[(4)] = cljs.core.cons.call(null,(5),(state_70094[(4)])));

return statearr_70097;
})();
var inst_70075__$1 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70076 = cljs.core.js__GT_clj.call(null,block_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70077 = cljs.core.__destructure_map.call(null,inst_70076);
var inst_70078 = cljs.core.get.call(null,inst_70077,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_70079 = cljs.core.get.call(null,inst_70077,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_70080 = flureenjs.db_instance.call(null,conn,ledger,inst_70075__$1);
var state_70094__$1 = (function (){var statearr_70098 = state_70094;
(statearr_70098[(8)] = inst_70079);

(statearr_70098[(7)] = inst_70075__$1);

(statearr_70098[(9)] = inst_70078);

return statearr_70098;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70094__$1,(6),inst_70080);
} else {
if((state_val_70095 === (3))){
var inst_70092 = (state_70094[(2)]);
var state_70094__$1 = state_70094;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70094__$1,inst_70092);
} else {
if((state_val_70095 === (4))){
var inst_70066 = (state_70094[(2)]);
var inst_70067 = fluree.db.util.log.error.call(null,inst_70066);
var inst_70068 = reject.call(null,inst_70066);
var state_70094__$1 = (function (){var statearr_70100 = state_70094;
(statearr_70100[(10)] = inst_70067);

return statearr_70100;
})();
var statearr_70101_70114 = state_70094__$1;
(statearr_70101_70114[(2)] = inst_70068);

(statearr_70101_70114[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70095 === (5))){
var _ = (function (){var statearr_70102 = state_70094;
(statearr_70102[(4)] = cljs.core.rest.call(null,(state_70094[(4)])));

return statearr_70102;
})();
var state_70094__$1 = state_70094;
var ex70099 = (state_70094__$1[(2)]);
var statearr_70103_70115 = state_70094__$1;
(statearr_70103_70115[(5)] = ex70099);


var statearr_70104_70116 = state_70094__$1;
(statearr_70104_70116[(1)] = (4));

(statearr_70104_70116[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70095 === (6))){
var inst_70079 = (state_70094[(8)]);
var inst_70075 = (state_70094[(7)]);
var inst_70078 = (state_70094[(9)]);
var inst_70082 = (state_70094[(2)]);
var inst_70083 = fluree.db.query.block.block_range.call(null,inst_70082,inst_70078,inst_70079,inst_70075);
var state_70094__$1 = state_70094;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70094__$1,(7),inst_70083);
} else {
if((state_val_70095 === (7))){
var inst_70085 = (state_70094[(2)]);
var inst_70086 = fluree.db.util.async.throw_err.call(null,inst_70085);
var inst_70087 = fluree.db.query.range.block_with_tx_data.call(null,inst_70086);
var inst_70088 = cljs.core.clj__GT_js.call(null,inst_70087);
var inst_70089 = resolve.call(null,inst_70088);
var _ = (function (){var statearr_70105 = state_70094;
(statearr_70105[(4)] = cljs.core.rest.call(null,(state_70094[(4)])));

return statearr_70105;
})();
var state_70094__$1 = state_70094;
var statearr_70106_70117 = state_70094__$1;
(statearr_70106_70117[(2)] = inst_70089);

(statearr_70106_70117[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_70107 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_70107[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_70107[(1)] = (1));

return statearr_70107;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_70094){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_70094);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e70108){var ex__2729__auto__ = e70108;
var statearr_70109_70118 = state_70094;
(statearr_70109_70118[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_70094[(4)]))){
var statearr_70110_70119 = state_70094;
(statearr_70110_70119[(1)] = cljs.core.first.call(null,(state_70094[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70120 = state_70094;
state_70094 = G__70120;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_70094){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_70094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_70111 = f__2749__auto__.call(null);
(statearr_70111[(6)] = c__2748__auto__);

return statearr_70111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureenjs.block_query = (function flureenjs$block_query(var_args){
var G__70122 = arguments.length;
switch (G__70122) {
case 3:
return flureenjs.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_query', flureenjs.block_query);

(flureenjs.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureenjs.block_query.call(null,conn,ledger,query_map,null);
}));

(flureenjs.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_70180){
var state_val_70181 = (state_70180[(1)]);
if((state_val_70181 === (7))){
var state_70180__$1 = state_70180;
var statearr_70182_70223 = state_70180__$1;
(statearr_70182_70223[(2)] = null);

(statearr_70182_70223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (20))){
var inst_70159 = (state_70180[(2)]);
var state_70180__$1 = state_70180;
var statearr_70183_70224 = state_70180__$1;
(statearr_70183_70224[(2)] = inst_70159);

(statearr_70183_70224[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (1))){
var state_70180__$1 = state_70180;
var statearr_70184_70225 = state_70180__$1;
(statearr_70184_70225[(2)] = null);

(statearr_70184_70225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (4))){
var inst_70123 = (state_70180[(2)]);
var inst_70124 = fluree.db.util.log.error.call(null,inst_70123);
var inst_70125 = reject.call(null,inst_70123);
var state_70180__$1 = (function (){var statearr_70185 = state_70180;
(statearr_70185[(7)] = inst_70124);

return statearr_70185;
})();
var statearr_70186_70226 = state_70180__$1;
(statearr_70186_70226[(2)] = inst_70125);

(statearr_70186_70226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (15))){
var state_70180__$1 = state_70180;
var statearr_70187_70227 = state_70180__$1;
(statearr_70187_70227[(2)] = null);

(statearr_70187_70227[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (21))){
var inst_70172 = (state_70180[(2)]);
var inst_70173 = fluree.db.util.async.throw_err.call(null,inst_70172);
var inst_70174 = cljs.core.clj__GT_js.call(null,inst_70173);
var inst_70175 = resolve.call(null,inst_70174);
var _ = (function (){var statearr_70188 = state_70180;
(statearr_70188[(4)] = cljs.core.rest.call(null,(state_70180[(4)])));

return statearr_70188;
})();
var state_70180__$1 = state_70180;
var statearr_70189_70228 = state_70180__$1;
(statearr_70189_70228[(2)] = inst_70175);

(statearr_70189_70228[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (13))){
var inst_70138 = (state_70180[(8)]);
var inst_70147 = (state_70180[(9)]);
var inst_70147__$1 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_70138);
var inst_70148 = (inst_70147__$1 == null);
var state_70180__$1 = (function (){var statearr_70190 = state_70180;
(statearr_70190[(9)] = inst_70147__$1);

return statearr_70190;
})();
if(cljs.core.truth_(inst_70148)){
var statearr_70191_70229 = state_70180__$1;
(statearr_70191_70229[(1)] = (15));

} else {
var statearr_70192_70230 = state_70180__$1;
(statearr_70192_70230[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (6))){
var inst_70134 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_70180__$1 = state_70180;
var statearr_70193_70231 = state_70180__$1;
(statearr_70193_70231[(2)] = inst_70134);

(statearr_70193_70231[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (17))){
var inst_70153 = (state_70180[(10)]);
var inst_70153__$1 = (state_70180[(2)]);
var inst_70154 = (inst_70153__$1 == null);
var state_70180__$1 = (function (){var statearr_70194 = state_70180;
(statearr_70194[(10)] = inst_70153__$1);

return statearr_70194;
})();
if(cljs.core.truth_(inst_70154)){
var statearr_70195_70232 = state_70180__$1;
(statearr_70195_70232[(1)] = (18));

} else {
var statearr_70196_70233 = state_70180__$1;
(statearr_70196_70233[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (3))){
var inst_70178 = (state_70180[(2)]);
var state_70180__$1 = state_70180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70180__$1,inst_70178);
} else {
if((state_val_70181 === (12))){
var inst_70143 = (state_70180[(11)]);
var state_70180__$1 = state_70180;
var statearr_70197_70234 = state_70180__$1;
(statearr_70197_70234[(2)] = inst_70143);

(statearr_70197_70234[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (2))){
var inst_70131 = (state_70180[(12)]);
var _ = (function (){var statearr_70198 = state_70180;
(statearr_70198[(4)] = cljs.core.cons.call(null,(5),(state_70180[(4)])));

return statearr_70198;
})();
var inst_70131__$1 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70132 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_70131__$1);
var state_70180__$1 = (function (){var statearr_70199 = state_70180;
(statearr_70199[(13)] = inst_70132);

(statearr_70199[(12)] = inst_70131__$1);

return statearr_70199;
})();
if(cljs.core.truth_(opts)){
var statearr_70200_70235 = state_70180__$1;
(statearr_70200_70235[(1)] = (6));

} else {
var statearr_70201_70236 = state_70180__$1;
(statearr_70201_70236[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (19))){
var inst_70153 = (state_70180[(10)]);
var inst_70157 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_70153);
var state_70180__$1 = state_70180;
var statearr_70202_70237 = state_70180__$1;
(statearr_70202_70237[(2)] = inst_70157);

(statearr_70202_70237[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (11))){
var inst_70138 = (state_70180[(8)]);
var inst_70131 = (state_70180[(12)]);
var inst_70163 = (state_70180[(2)]);
var inst_70164 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_70165 = [inst_70163];
var inst_70166 = cljs.core.PersistentHashMap.fromArrays(inst_70164,inst_70165);
var inst_70167 = fluree.db.util.core.without_nils.call(null,inst_70166);
var inst_70168 = cljs.core.merge.call(null,inst_70138,inst_70167);
var inst_70169 = cljs.core.update.call(null,inst_70131,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_70168);
var inst_70170 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_70169);
var state_70180__$1 = state_70180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70180__$1,(21),inst_70170);
} else {
if((state_val_70181 === (9))){
var inst_70140 = (state_70180[(14)]);
var state_70180__$1 = state_70180;
var statearr_70204_70238 = state_70180__$1;
(statearr_70204_70238[(2)] = inst_70140);

(statearr_70204_70238[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (5))){
var _ = (function (){var statearr_70205 = state_70180;
(statearr_70205[(4)] = cljs.core.rest.call(null,(state_70180[(4)])));

return statearr_70205;
})();
var state_70180__$1 = state_70180;
var ex70203 = (state_70180__$1[(2)]);
var statearr_70206_70239 = state_70180__$1;
(statearr_70206_70239[(5)] = ex70203);


var statearr_70207_70240 = state_70180__$1;
(statearr_70207_70240[(1)] = (4));

(statearr_70207_70240[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (14))){
var inst_70161 = (state_70180[(2)]);
var state_70180__$1 = state_70180;
var statearr_70208_70241 = state_70180__$1;
(statearr_70208_70241[(2)] = inst_70161);

(statearr_70208_70241[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (16))){
var inst_70147 = (state_70180[(9)]);
var inst_70151 = fluree.db.connection_js.validate_token.call(null,conn,inst_70147);
var state_70180__$1 = state_70180;
var statearr_70209_70242 = state_70180__$1;
(statearr_70209_70242[(2)] = inst_70151);

(statearr_70209_70242[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (10))){
var inst_70138 = (state_70180[(8)]);
var inst_70143 = (state_70180[(11)]);
var inst_70143__$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_70138);
var state_70180__$1 = (function (){var statearr_70210 = state_70180;
(statearr_70210[(11)] = inst_70143__$1);

return statearr_70210;
})();
if(cljs.core.truth_(inst_70143__$1)){
var statearr_70211_70243 = state_70180__$1;
(statearr_70211_70243[(1)] = (12));

} else {
var statearr_70212_70244 = state_70180__$1;
(statearr_70212_70244[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (18))){
var state_70180__$1 = state_70180;
var statearr_70213_70245 = state_70180__$1;
(statearr_70213_70245[(2)] = null);

(statearr_70213_70245[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70181 === (8))){
var inst_70140 = (state_70180[(14)]);
var inst_70132 = (state_70180[(13)]);
var inst_70138 = (state_70180[(8)]);
var inst_70137 = (state_70180[(2)]);
var inst_70138__$1 = cljs.core.merge.call(null,inst_70132,inst_70137);
var inst_70139 = fluree.db.connection_js.check_connection.call(null,conn,inst_70138__$1);
var inst_70140__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_70138__$1);
var state_70180__$1 = (function (){var statearr_70214 = state_70180;
(statearr_70214[(14)] = inst_70140__$1);

(statearr_70214[(8)] = inst_70138__$1);

(statearr_70214[(15)] = inst_70139);

return statearr_70214;
})();
if(cljs.core.truth_(inst_70140__$1)){
var statearr_70215_70246 = state_70180__$1;
(statearr_70215_70246[(1)] = (9));

} else {
var statearr_70216_70247 = state_70180__$1;
(statearr_70216_70247[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_70217 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70217[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_70217[(1)] = (1));

return statearr_70217;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_70180){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_70180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e70218){var ex__2729__auto__ = e70218;
var statearr_70219_70248 = state_70180;
(statearr_70219_70248[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_70180[(4)]))){
var statearr_70220_70249 = state_70180;
(statearr_70220_70249[(1)] = cljs.core.first.call(null,(state_70180[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70250 = state_70180;
state_70180 = G__70250;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_70180){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_70180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_70221 = f__2749__auto__.call(null);
(statearr_70221[(6)] = c__2748__auto__);

return statearr_70221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.block_query.cljs$lang$maxFixedArity = 4);

/**
 * Returns a promise containing blocks from start (inclusive)
 * to end if provided (exclusive).
 * 
 * Each block is a separate map, containing keys :block, :t and :flakes.
 */
flureenjs.block_range = (function flureenjs$block_range(var_args){
var G__70252 = arguments.length;
switch (G__70252) {
case 2:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_range', flureenjs.block_range);

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return flureenjs.block_range.call(null,db,start,null,null);
}));

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return flureenjs.block_range.call(null,db,start,end,null);
}));

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_70276){
var state_val_70277 = (state_70276[(1)]);
if((state_val_70277 === (1))){
var state_70276__$1 = state_70276;
var statearr_70278_70295 = state_70276__$1;
(statearr_70278_70295[(2)] = null);

(statearr_70278_70295[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (2))){
var _ = (function (){var statearr_70279 = state_70276;
(statearr_70279[(4)] = cljs.core.cons.call(null,(5),(state_70276[(4)])));

return statearr_70279;
})();
var inst_70261 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_70276__$1 = (function (){var statearr_70280 = state_70276;
(statearr_70280[(7)] = inst_70261);

return statearr_70280;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70276__$1,(7),db);
} else {
if((state_val_70277 === (3))){
var inst_70274 = (state_70276[(2)]);
var state_70276__$1 = state_70276;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70276__$1,inst_70274);
} else {
if((state_val_70277 === (4))){
var inst_70253 = (state_70276[(2)]);
var inst_70254 = fluree.db.util.log.error.call(null,inst_70253);
var inst_70255 = reject.call(null,inst_70253);
var state_70276__$1 = (function (){var statearr_70282 = state_70276;
(statearr_70282[(8)] = inst_70254);

return statearr_70282;
})();
var statearr_70283_70296 = state_70276__$1;
(statearr_70283_70296[(2)] = inst_70255);

(statearr_70283_70296[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (5))){
var _ = (function (){var statearr_70284 = state_70276;
(statearr_70284[(4)] = cljs.core.rest.call(null,(state_70276[(4)])));

return statearr_70284;
})();
var state_70276__$1 = state_70276;
var ex70281 = (state_70276__$1[(2)]);
var statearr_70285_70297 = state_70276__$1;
(statearr_70285_70297[(5)] = ex70281);


var statearr_70286_70298 = state_70276__$1;
(statearr_70286_70298[(1)] = (4));

(statearr_70286_70298[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (6))){
var inst_70267 = (state_70276[(2)]);
var inst_70268 = fluree.db.util.async.throw_err.call(null,inst_70267);
var inst_70269 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_70268);
var inst_70270 = cljs.core.clj__GT_js.call(null,inst_70269);
var inst_70271 = resolve.call(null,inst_70270);
var _ = (function (){var statearr_70287 = state_70276;
(statearr_70287[(4)] = cljs.core.rest.call(null,(state_70276[(4)])));

return statearr_70287;
})();
var state_70276__$1 = state_70276;
var statearr_70288_70299 = state_70276__$1;
(statearr_70288_70299[(2)] = inst_70271);

(statearr_70288_70299[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70277 === (7))){
var inst_70261 = (state_70276[(7)]);
var inst_70263 = (state_70276[(2)]);
var inst_70264 = fluree.db.util.async.throw_err.call(null,inst_70263);
var inst_70265 = fluree.db.query.block.block_range.call(null,inst_70264,start,end,inst_70261);
var state_70276__$1 = state_70276;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70276__$1,(6),inst_70265);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_70289 = [null,null,null,null,null,null,null,null,null];
(statearr_70289[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_70289[(1)] = (1));

return statearr_70289;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_70276){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_70276);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e70290){var ex__2729__auto__ = e70290;
var statearr_70291_70300 = state_70276;
(statearr_70291_70300[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_70276[(4)]))){
var statearr_70292_70301 = state_70276;
(statearr_70292_70301[(1)] = cljs.core.first.call(null,(state_70276[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70302 = state_70276;
state_70276 = G__70302;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_70276){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_70276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_70293 = f__2749__auto__.call(null);
(statearr_70293[(6)] = c__2748__auto__);

return statearr_70293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.block_range.cljs$lang$maxFixedArity = 4);

/**
 * Returns spot index range for only the requested collection.
 */
flureenjs.collection_flakes = (function flureenjs$collection_flakes(db,collection){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_70325){
var state_val_70326 = (state_70325[(1)]);
if((state_val_70326 === (1))){
var state_70325__$1 = state_70325;
var statearr_70327_70342 = state_70325__$1;
(statearr_70327_70342[(2)] = null);

(statearr_70327_70342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70326 === (2))){
var _ = (function (){var statearr_70328 = state_70325;
(statearr_70328[(4)] = cljs.core.cons.call(null,(5),(state_70325[(4)])));

return statearr_70328;
})();
var state_70325__$1 = state_70325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70325__$1,(7),db);
} else {
if((state_val_70326 === (3))){
var inst_70323 = (state_70325[(2)]);
var state_70325__$1 = state_70325;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70325__$1,inst_70323);
} else {
if((state_val_70326 === (4))){
var inst_70303 = (state_70325[(2)]);
var inst_70304 = fluree.db.util.log.error.call(null,inst_70303);
var inst_70305 = reject.call(null,inst_70303);
var state_70325__$1 = (function (){var statearr_70330 = state_70325;
(statearr_70330[(7)] = inst_70304);

return statearr_70330;
})();
var statearr_70331_70343 = state_70325__$1;
(statearr_70331_70343[(2)] = inst_70305);

(statearr_70331_70343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70326 === (5))){
var _ = (function (){var statearr_70332 = state_70325;
(statearr_70332[(4)] = cljs.core.rest.call(null,(state_70325[(4)])));

return statearr_70332;
})();
var state_70325__$1 = state_70325;
var ex70329 = (state_70325__$1[(2)]);
var statearr_70333_70344 = state_70325__$1;
(statearr_70333_70344[(5)] = ex70329);


var statearr_70334_70345 = state_70325__$1;
(statearr_70334_70345[(1)] = (4));

(statearr_70334_70345[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70326 === (6))){
var inst_70316 = (state_70325[(2)]);
var inst_70317 = fluree.db.util.async.throw_err.call(null,inst_70316);
var inst_70318 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_70317);
var inst_70319 = cljs.core.clj__GT_js.call(null,inst_70318);
var inst_70320 = resolve.call(null,inst_70319);
var _ = (function (){var statearr_70335 = state_70325;
(statearr_70335[(4)] = cljs.core.rest.call(null,(state_70325[(4)])));

return statearr_70335;
})();
var state_70325__$1 = state_70325;
var statearr_70336_70346 = state_70325__$1;
(statearr_70336_70346[(2)] = inst_70320);

(statearr_70336_70346[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70326 === (7))){
var inst_70312 = (state_70325[(2)]);
var inst_70313 = fluree.db.util.async.throw_err.call(null,inst_70312);
var inst_70314 = fluree.db.query.range.collection.call(null,inst_70313,collection);
var state_70325__$1 = state_70325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70325__$1,(6),inst_70314);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$collection_flakes_$_state_machine__2726__auto__ = null;
var flureenjs$collection_flakes_$_state_machine__2726__auto____0 = (function (){
var statearr_70337 = [null,null,null,null,null,null,null,null];
(statearr_70337[(0)] = flureenjs$collection_flakes_$_state_machine__2726__auto__);

(statearr_70337[(1)] = (1));

return statearr_70337;
});
var flureenjs$collection_flakes_$_state_machine__2726__auto____1 = (function (state_70325){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_70325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e70338){var ex__2729__auto__ = e70338;
var statearr_70339_70347 = state_70325;
(statearr_70339_70347[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_70325[(4)]))){
var statearr_70340_70348 = state_70325;
(statearr_70340_70348[(1)] = cljs.core.first.call(null,(state_70325[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70349 = state_70325;
state_70325 = G__70349;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$collection_flakes_$_state_machine__2726__auto__ = function(state_70325){
switch(arguments.length){
case 0:
return flureenjs$collection_flakes_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$collection_flakes_$_state_machine__2726__auto____1.call(this,state_70325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collection_flakes_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collection_flakes_$_state_machine__2726__auto____0;
flureenjs$collection_flakes_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collection_flakes_$_state_machine__2726__auto____1;
return flureenjs$collection_flakes_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_70341 = f__2749__auto__.call(null);
(statearr_70341[(6)] = c__2748__auto__);

return statearr_70341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.collection_flakes', flureenjs.collection_flakes);
/**
 * Execute a graphql query against the specified database.
 */
flureenjs.graphql = (function flureenjs$graphql(var_args){
var G__70351 = arguments.length;
switch (G__70351) {
case 3:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.graphql', flureenjs.graphql);

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,param){
return flureenjs.graphql.call(null,conn,ledger,param,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,param,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_70453){
var state_val_70454 = (state_70453[(1)]);
if((state_val_70454 === (7))){
var state_70453__$1 = state_70453;
var statearr_70455_70507 = state_70453__$1;
(statearr_70455_70507[(2)] = null);

(statearr_70455_70507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (20))){
var inst_70370 = (state_70453[(7)]);
var inst_70377 = (state_70453[(8)]);
var inst_70381 = (state_70453[(9)]);
var inst_70402 = cljs.core.dissoc.call(null,inst_70381,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_70403 = cljs.core.assoc.call(null,inst_70402,new cljs.core.Keyword(null,"opts","opts",155075701),inst_70370);
var inst_70404 = fluree.db.api.query.history_query_async.call(null,inst_70377,inst_70403);
var state_70453__$1 = state_70453;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70453__$1,(23),inst_70404);
} else {
if((state_val_70454 === (27))){
var inst_70416 = (state_70453[(2)]);
var inst_70417 = fluree.db.util.async.throw_err.call(null,inst_70416);
var state_70453__$1 = state_70453;
var statearr_70456_70508 = state_70453__$1;
(statearr_70456_70508[(2)] = inst_70417);

(statearr_70456_70508[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (1))){
var state_70453__$1 = state_70453;
var statearr_70457_70509 = state_70453__$1;
(statearr_70457_70509[(2)] = null);

(statearr_70457_70509[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (24))){
var inst_70370 = (state_70453[(7)]);
var inst_70381 = (state_70453[(9)]);
var inst_70412 = cljs.core.dissoc.call(null,inst_70381,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_70413 = cljs.core.assoc.call(null,inst_70412,new cljs.core.Keyword(null,"opts","opts",155075701),inst_70370);
var inst_70414 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_70413);
var state_70453__$1 = state_70453;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70453__$1,(27),inst_70414);
} else {
if((state_val_70454 === (4))){
var inst_70352 = (state_70453[(2)]);
var inst_70353 = fluree.db.util.log.error.call(null,inst_70352);
var inst_70354 = cljs.core.clj__GT_js.call(null,inst_70352);
var inst_70355 = reject.call(null,inst_70354);
var state_70453__$1 = (function (){var statearr_70458 = state_70453;
(statearr_70458[(10)] = inst_70353);

return statearr_70458;
})();
var statearr_70459_70510 = state_70453__$1;
(statearr_70459_70510[(2)] = inst_70355);

(statearr_70459_70510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (15))){
var inst_70381 = (state_70453[(9)]);
var inst_70399 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_70381);
var inst_70400 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"history","history",-247395220),inst_70399);
var state_70453__$1 = state_70453;
if(inst_70400){
var statearr_70460_70511 = state_70453__$1;
(statearr_70460_70511[(1)] = (20));

} else {
var statearr_70461_70512 = state_70453__$1;
(statearr_70461_70512[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (21))){
var inst_70381 = (state_70453[(9)]);
var inst_70409 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_70381);
var inst_70410 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),inst_70409);
var state_70453__$1 = state_70453;
if(inst_70410){
var statearr_70462_70513 = state_70453__$1;
(statearr_70462_70513[(1)] = (24));

} else {
var statearr_70463_70514 = state_70453__$1;
(statearr_70463_70514[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (31))){
var inst_70424 = (state_70453[(2)]);
var inst_70425 = fluree.db.util.async.throw_err.call(null,inst_70424);
var state_70453__$1 = state_70453;
var statearr_70464_70515 = state_70453__$1;
(statearr_70464_70515[(2)] = inst_70425);

(statearr_70464_70515[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (32))){
var inst_70370 = (state_70453[(7)]);
var inst_70374 = (state_70453[(11)]);
var inst_70381 = (state_70453[(9)]);
var inst_70428 = cljs.core.dissoc.call(null,inst_70381,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_70429 = cljs.core.assoc.call(null,inst_70428,new cljs.core.Keyword(null,"opts","opts",155075701),inst_70370);
var inst_70430 = fluree.db.api.query.multi_query_async.call(null,inst_70374,inst_70429);
var state_70453__$1 = state_70453;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70453__$1,(35),inst_70430);
} else {
if((state_val_70454 === (33))){
var state_70453__$1 = state_70453;
var statearr_70465_70516 = state_70453__$1;
(statearr_70465_70516[(2)] = null);

(statearr_70465_70516[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (13))){
var inst_70446 = (state_70453[(2)]);
var inst_70447 = cljs.core.clj__GT_js.call(null,inst_70446);
var inst_70448 = resolve.call(null,inst_70447);
var _ = (function (){var statearr_70466 = state_70453;
(statearr_70466[(4)] = cljs.core.rest.call(null,(state_70453[(4)])));

return statearr_70466;
})();
var state_70453__$1 = state_70453;
var statearr_70467_70517 = state_70453__$1;
(statearr_70467_70517[(2)] = inst_70448);

(statearr_70467_70517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (22))){
var inst_70442 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
var statearr_70468_70518 = state_70453__$1;
(statearr_70468_70518[(2)] = inst_70442);

(statearr_70468_70518[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (29))){
var state_70453__$1 = state_70453;
var statearr_70469_70519 = state_70453__$1;
(statearr_70469_70519[(1)] = (32));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (6))){
var inst_70366 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_70453__$1 = state_70453;
var statearr_70471_70520 = state_70453__$1;
(statearr_70471_70520[(2)] = inst_70366);

(statearr_70471_70520[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (28))){
var inst_70370 = (state_70453[(7)]);
var inst_70381 = (state_70453[(9)]);
var inst_70421 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_70381);
var inst_70422 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_70421,inst_70370);
var state_70453__$1 = state_70453;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70453__$1,(31),inst_70422);
} else {
if((state_val_70454 === (25))){
var inst_70381 = (state_70453[(9)]);
var inst_70419 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_70381);
var state_70453__$1 = state_70453;
if(cljs.core.truth_(inst_70419)){
var statearr_70472_70521 = state_70453__$1;
(statearr_70472_70521[(1)] = (28));

} else {
var statearr_70473_70522 = state_70453__$1;
(statearr_70473_70522[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (34))){
var inst_70436 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
var statearr_70474_70523 = state_70453__$1;
(statearr_70474_70523[(2)] = inst_70436);

(statearr_70474_70523[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (17))){
var inst_70381 = (state_70453[(9)]);
var inst_70393 = cljs.core.dissoc.call(null,inst_70381,new cljs.core.Keyword(null,"type","type",1174270348));
var state_70453__$1 = state_70453;
var statearr_70475_70524 = state_70453__$1;
(statearr_70475_70524[(2)] = inst_70393);

(statearr_70475_70524[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (3))){
var inst_70451 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70453__$1,inst_70451);
} else {
if((state_val_70454 === (12))){
var inst_70381 = (state_70453[(9)]);
var inst_70385 = [new cljs.core.Keyword(null,"__schema","__schema",-305244223),null,new cljs.core.Keyword(null,"__type","__type",1665433236),null];
var inst_70386 = (new cljs.core.PersistentArrayMap(null,2,inst_70385,null));
var inst_70387 = (new cljs.core.PersistentHashSet(null,inst_70386,null));
var inst_70388 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_70381);
var inst_70389 = inst_70387.call(null,inst_70388);
var state_70453__$1 = state_70453;
if(cljs.core.truth_(inst_70389)){
var statearr_70476_70525 = state_70453__$1;
(statearr_70476_70525[(1)] = (14));

} else {
var statearr_70477_70526 = state_70453__$1;
(statearr_70477_70526[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (2))){
var inst_70363 = (state_70453[(12)]);
var _ = (function (){var statearr_70478 = state_70453;
(statearr_70478[(4)] = cljs.core.cons.call(null,(5),(state_70453[(4)])));

return statearr_70478;
})();
var inst_70362 = fluree.db.util.json.parse.call(null,param);
var inst_70363__$1 = cljs.core.js__GT_clj.call(null,inst_70362,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70364 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_70363__$1);
var state_70453__$1 = (function (){var statearr_70479 = state_70453;
(statearr_70479[(12)] = inst_70363__$1);

(statearr_70479[(13)] = inst_70364);

return statearr_70479;
})();
if(cljs.core.truth_(opts)){
var statearr_70480_70527 = state_70453__$1;
(statearr_70480_70527[(1)] = (6));

} else {
var statearr_70481_70528 = state_70453__$1;
(statearr_70481_70528[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (23))){
var inst_70406 = (state_70453[(2)]);
var inst_70407 = fluree.db.util.async.throw_err.call(null,inst_70406);
var state_70453__$1 = state_70453;
var statearr_70482_70529 = state_70453__$1;
(statearr_70482_70529[(2)] = inst_70407);

(statearr_70482_70529[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (35))){
var inst_70432 = (state_70453[(2)]);
var inst_70433 = fluree.db.util.async.throw_err.call(null,inst_70432);
var state_70453__$1 = state_70453;
var statearr_70483_70530 = state_70453__$1;
(statearr_70483_70530[(2)] = inst_70433);

(statearr_70483_70530[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (19))){
var inst_70397 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
var statearr_70484_70531 = state_70453__$1;
(statearr_70484_70531[(2)] = inst_70397);

(statearr_70484_70531[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (11))){
var inst_70381 = (state_70453[(9)]);
var state_70453__$1 = state_70453;
var statearr_70486_70532 = state_70453__$1;
(statearr_70486_70532[(2)] = inst_70381);

(statearr_70486_70532[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (9))){
var inst_70370 = (state_70453[(7)]);
var inst_70372 = (state_70453[(14)]);
var inst_70373 = (state_70453[(15)]);
var inst_70377 = (state_70453[(8)]);
var inst_70376 = (state_70453[(2)]);
var inst_70377__$1 = fluree.db.util.async.throw_err.call(null,inst_70376);
var inst_70378 = fluree.db.query.graphql_parser.parse_graphql_to_flureeql.call(null,inst_70377__$1,inst_70372,inst_70373,inst_70370);
var state_70453__$1 = (function (){var statearr_70487 = state_70453;
(statearr_70487[(8)] = inst_70377__$1);

return statearr_70487;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70453__$1,(10),inst_70378);
} else {
if((state_val_70454 === (5))){
var _ = (function (){var statearr_70488 = state_70453;
(statearr_70488[(4)] = cljs.core.rest.call(null,(state_70453[(4)])));

return statearr_70488;
})();
var state_70453__$1 = state_70453;
var ex70485 = (state_70453__$1[(2)]);
var statearr_70489_70533 = state_70453__$1;
(statearr_70489_70533[(5)] = ex70485);


var statearr_70490_70534 = state_70453__$1;
(statearr_70490_70534[(1)] = (4));

(statearr_70490_70534[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (14))){
var inst_70370 = (state_70453[(7)]);
var inst_70391 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_70370);
var state_70453__$1 = state_70453;
if(cljs.core.truth_(inst_70391)){
var statearr_70491_70535 = state_70453__$1;
(statearr_70491_70535[(1)] = (17));

} else {
var statearr_70492_70536 = state_70453__$1;
(statearr_70492_70536[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (26))){
var inst_70440 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
var statearr_70493_70537 = state_70453__$1;
(statearr_70493_70537[(2)] = inst_70440);

(statearr_70493_70537[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (16))){
var inst_70444 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
var statearr_70494_70538 = state_70453__$1;
(statearr_70494_70538[(2)] = inst_70444);

(statearr_70494_70538[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (30))){
var inst_70438 = (state_70453[(2)]);
var state_70453__$1 = state_70453;
var statearr_70495_70539 = state_70453__$1;
(statearr_70495_70539[(2)] = inst_70438);

(statearr_70495_70539[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (10))){
var inst_70381 = (state_70453[(9)]);
var inst_70380 = (state_70453[(2)]);
var inst_70381__$1 = fluree.db.util.async.throw_err.call(null,inst_70380);
var inst_70382 = fluree.db.util.core.exception_QMARK_.call(null,inst_70381__$1);
var state_70453__$1 = (function (){var statearr_70496 = state_70453;
(statearr_70496[(9)] = inst_70381__$1);

return statearr_70496;
})();
if(inst_70382){
var statearr_70497_70540 = state_70453__$1;
(statearr_70497_70540[(1)] = (11));

} else {
var statearr_70498_70541 = state_70453__$1;
(statearr_70498_70541[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (18))){
var inst_70381 = (state_70453[(9)]);
var inst_70395 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_70381);
var state_70453__$1 = state_70453;
var statearr_70499_70542 = state_70453__$1;
(statearr_70499_70542[(2)] = inst_70395);

(statearr_70499_70542[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70454 === (8))){
var inst_70363 = (state_70453[(12)]);
var inst_70370 = (state_70453[(7)]);
var inst_70374 = (state_70453[(11)]);
var inst_70364 = (state_70453[(13)]);
var inst_70369 = (state_70453[(2)]);
var inst_70370__$1 = cljs.core.merge.call(null,inst_70364,inst_70369);
var inst_70371 = cljs.core.__destructure_map.call(null,inst_70363);
var inst_70372 = cljs.core.get.call(null,inst_70371,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_70373 = cljs.core.get.call(null,inst_70371,new cljs.core.Keyword(null,"variables","variables",1563680814));
var inst_70374__$1 = flureenjs.db_instance.call(null,conn,ledger,inst_70370__$1);
var state_70453__$1 = (function (){var statearr_70500 = state_70453;
(statearr_70500[(7)] = inst_70370__$1);

(statearr_70500[(11)] = inst_70374__$1);

(statearr_70500[(14)] = inst_70372);

(statearr_70500[(15)] = inst_70373);

return statearr_70500;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70453__$1,(9),inst_70374__$1);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_70501 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70501[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_70501[(1)] = (1));

return statearr_70501;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_70453){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_70453);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e70502){var ex__2729__auto__ = e70502;
var statearr_70503_70543 = state_70453;
(statearr_70503_70543[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_70453[(4)]))){
var statearr_70504_70544 = state_70453;
(statearr_70504_70544[(1)] = cljs.core.first.call(null,(state_70453[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70545 = state_70453;
state_70453 = G__70545;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_70453){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_70453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_70505 = f__2749__auto__.call(null);
(statearr_70505[(6)] = c__2748__auto__);

return statearr_70505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.graphql.cljs$lang$maxFixedArity = 4);

flureenjs.history_query = (function flureenjs$history_query(var_args){
var G__70547 = arguments.length;
switch (G__70547) {
case 2:
return flureenjs.history_query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.history_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.history_query', flureenjs.history_query);

(flureenjs.history_query.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return flureenjs.history_query.call(null,sources,query_map,null);
}));

(flureenjs.history_query.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_70574){
var state_val_70575 = (state_70574[(1)]);
if((state_val_70575 === (1))){
var state_70574__$1 = state_70574;
var statearr_70576_70592 = state_70574__$1;
(statearr_70576_70592[(2)] = null);

(statearr_70576_70592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70575 === (2))){
var _ = (function (){var statearr_70577 = state_70574;
(statearr_70577[(4)] = cljs.core.cons.call(null,(5),(state_70574[(4)])));

return statearr_70577;
})();
var inst_70556 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70557 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_70556);
var inst_70558 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70559 = cljs.core.merge.call(null,inst_70557,inst_70558);
var inst_70560 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_70561 = [inst_70559];
var inst_70562 = cljs.core.PersistentHashMap.fromArrays(inst_70560,inst_70561);
var inst_70563 = cljs.core.merge.call(null,inst_70556,inst_70562);
var inst_70564 = fluree.db.api.query.history_query_async.call(null,sources,inst_70563);
var state_70574__$1 = state_70574;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70574__$1,(6),inst_70564);
} else {
if((state_val_70575 === (3))){
var inst_70572 = (state_70574[(2)]);
var state_70574__$1 = state_70574;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70574__$1,inst_70572);
} else {
if((state_val_70575 === (4))){
var inst_70548 = (state_70574[(2)]);
var inst_70549 = fluree.db.util.log.error.call(null,inst_70548);
var inst_70550 = reject.call(null,inst_70548);
var state_70574__$1 = (function (){var statearr_70579 = state_70574;
(statearr_70579[(7)] = inst_70549);

return statearr_70579;
})();
var statearr_70580_70593 = state_70574__$1;
(statearr_70580_70593[(2)] = inst_70550);

(statearr_70580_70593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70575 === (5))){
var _ = (function (){var statearr_70581 = state_70574;
(statearr_70581[(4)] = cljs.core.rest.call(null,(state_70574[(4)])));

return statearr_70581;
})();
var state_70574__$1 = state_70574;
var ex70578 = (state_70574__$1[(2)]);
var statearr_70582_70594 = state_70574__$1;
(statearr_70582_70594[(5)] = ex70578);


var statearr_70583_70595 = state_70574__$1;
(statearr_70583_70595[(1)] = (4));

(statearr_70583_70595[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70575 === (6))){
var inst_70566 = (state_70574[(2)]);
var inst_70567 = fluree.db.util.async.throw_err.call(null,inst_70566);
var inst_70568 = cljs.core.clj__GT_js.call(null,inst_70567);
var inst_70569 = resolve.call(null,inst_70568);
var _ = (function (){var statearr_70584 = state_70574;
(statearr_70584[(4)] = cljs.core.rest.call(null,(state_70574[(4)])));

return statearr_70584;
})();
var state_70574__$1 = state_70574;
var statearr_70585_70596 = state_70574__$1;
(statearr_70585_70596[(2)] = inst_70569);

(statearr_70585_70596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_70586 = [null,null,null,null,null,null,null,null];
(statearr_70586[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_70586[(1)] = (1));

return statearr_70586;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_70574){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_70574);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e70587){var ex__2729__auto__ = e70587;
var statearr_70588_70597 = state_70574;
(statearr_70588_70597[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_70574[(4)]))){
var statearr_70589_70598 = state_70574;
(statearr_70589_70598[(1)] = cljs.core.first.call(null,(state_70574[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70599 = state_70574;
state_70574 = G__70599;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_70574){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_70574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_70590 = f__2749__auto__.call(null);
(statearr_70590[(6)] = c__2748__auto__);

return statearr_70590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.history_query.cljs$lang$maxFixedArity = 3);

flureenjs.multi_query = (function flureenjs$multi_query(var_args){
var G__70601 = arguments.length;
switch (G__70601) {
case 2:
return flureenjs.multi_query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.multi_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.multi_query', flureenjs.multi_query);

(flureenjs.multi_query.cljs$core$IFn$_invoke$arity$2 = (function (source,multi_query_map){
return flureenjs.multi_query.call(null,source,multi_query_map,null);
}));

(flureenjs.multi_query.cljs$core$IFn$_invoke$arity$3 = (function (source,multi_query_map,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_70628){
var state_val_70629 = (state_70628[(1)]);
if((state_val_70629 === (1))){
var state_70628__$1 = state_70628;
var statearr_70630_70646 = state_70628__$1;
(statearr_70630_70646[(2)] = null);

(statearr_70630_70646[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70629 === (2))){
var _ = (function (){var statearr_70631 = state_70628;
(statearr_70631[(4)] = cljs.core.cons.call(null,(5),(state_70628[(4)])));

return statearr_70631;
})();
var inst_70610 = cljs.core.js__GT_clj.call(null,multi_query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70611 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_70610);
var inst_70612 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70613 = cljs.core.merge.call(null,inst_70611,inst_70612);
var inst_70614 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_70615 = [inst_70613];
var inst_70616 = cljs.core.PersistentHashMap.fromArrays(inst_70614,inst_70615);
var inst_70617 = cljs.core.merge.call(null,inst_70610,inst_70616);
var inst_70618 = fluree.db.api.query.multi_query_async.call(null,source,inst_70617);
var state_70628__$1 = state_70628;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70628__$1,(6),inst_70618);
} else {
if((state_val_70629 === (3))){
var inst_70626 = (state_70628[(2)]);
var state_70628__$1 = state_70628;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70628__$1,inst_70626);
} else {
if((state_val_70629 === (4))){
var inst_70602 = (state_70628[(2)]);
var inst_70603 = fluree.db.util.log.error.call(null,inst_70602);
var inst_70604 = reject.call(null,inst_70602);
var state_70628__$1 = (function (){var statearr_70633 = state_70628;
(statearr_70633[(7)] = inst_70603);

return statearr_70633;
})();
var statearr_70634_70647 = state_70628__$1;
(statearr_70634_70647[(2)] = inst_70604);

(statearr_70634_70647[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70629 === (5))){
var _ = (function (){var statearr_70635 = state_70628;
(statearr_70635[(4)] = cljs.core.rest.call(null,(state_70628[(4)])));

return statearr_70635;
})();
var state_70628__$1 = state_70628;
var ex70632 = (state_70628__$1[(2)]);
var statearr_70636_70648 = state_70628__$1;
(statearr_70636_70648[(5)] = ex70632);


var statearr_70637_70649 = state_70628__$1;
(statearr_70637_70649[(1)] = (4));

(statearr_70637_70649[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70629 === (6))){
var inst_70620 = (state_70628[(2)]);
var inst_70621 = fluree.db.util.async.throw_err.call(null,inst_70620);
var inst_70622 = cljs.core.clj__GT_js.call(null,inst_70621);
var inst_70623 = resolve.call(null,inst_70622);
var _ = (function (){var statearr_70638 = state_70628;
(statearr_70638[(4)] = cljs.core.rest.call(null,(state_70628[(4)])));

return statearr_70638;
})();
var state_70628__$1 = state_70628;
var statearr_70639_70650 = state_70628__$1;
(statearr_70639_70650[(2)] = inst_70623);

(statearr_70639_70650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_70640 = [null,null,null,null,null,null,null,null];
(statearr_70640[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_70640[(1)] = (1));

return statearr_70640;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_70628){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_70628);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e70641){var ex__2729__auto__ = e70641;
var statearr_70642_70651 = state_70628;
(statearr_70642_70651[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_70628[(4)]))){
var statearr_70643_70652 = state_70628;
(statearr_70643_70652[(1)] = cljs.core.first.call(null,(state_70628[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70653 = state_70628;
state_70628 = G__70653;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_70628){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_70628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_70644 = f__2749__auto__.call(null);
(statearr_70644[(6)] = c__2748__auto__);

return statearr_70644;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.multi_query.cljs$lang$maxFixedArity = 3);

/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise that eventually contains the results or
 *   an exception.
 */
flureenjs.query = (function flureenjs$query(source,query_map){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_70674){
var state_val_70675 = (state_70674[(1)]);
if((state_val_70675 === (1))){
var state_70674__$1 = state_70674;
var statearr_70676_70691 = state_70674__$1;
(statearr_70676_70691[(2)] = null);

(statearr_70676_70691[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70675 === (2))){
var _ = (function (){var statearr_70677 = state_70674;
(statearr_70677[(4)] = cljs.core.cons.call(null,(5),(state_70674[(4)])));

return statearr_70677;
})();
var inst_70663 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70664 = fluree.db.api.query.query.call(null,source,inst_70663);
var state_70674__$1 = state_70674;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70674__$1,(6),inst_70664);
} else {
if((state_val_70675 === (3))){
var inst_70672 = (state_70674[(2)]);
var state_70674__$1 = state_70674;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70674__$1,inst_70672);
} else {
if((state_val_70675 === (4))){
var inst_70654 = (state_70674[(2)]);
var inst_70655 = fluree.db.util.log.error.call(null,inst_70654);
var inst_70656 = cljs.core.clj__GT_js.call(null,inst_70654);
var inst_70657 = reject.call(null,inst_70656);
var state_70674__$1 = (function (){var statearr_70679 = state_70674;
(statearr_70679[(7)] = inst_70655);

return statearr_70679;
})();
var statearr_70680_70692 = state_70674__$1;
(statearr_70680_70692[(2)] = inst_70657);

(statearr_70680_70692[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70675 === (5))){
var _ = (function (){var statearr_70681 = state_70674;
(statearr_70681[(4)] = cljs.core.rest.call(null,(state_70674[(4)])));

return statearr_70681;
})();
var state_70674__$1 = state_70674;
var ex70678 = (state_70674__$1[(2)]);
var statearr_70682_70693 = state_70674__$1;
(statearr_70682_70693[(5)] = ex70678);


var statearr_70683_70694 = state_70674__$1;
(statearr_70683_70694[(1)] = (4));

(statearr_70683_70694[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70675 === (6))){
var inst_70666 = (state_70674[(2)]);
var inst_70667 = fluree.db.util.async.throw_err.call(null,inst_70666);
var inst_70668 = cljs.core.clj__GT_js.call(null,inst_70667);
var inst_70669 = resolve.call(null,inst_70668);
var _ = (function (){var statearr_70684 = state_70674;
(statearr_70684[(4)] = cljs.core.rest.call(null,(state_70674[(4)])));

return statearr_70684;
})();
var state_70674__$1 = state_70674;
var statearr_70685_70695 = state_70674__$1;
(statearr_70685_70695[(2)] = inst_70669);

(statearr_70685_70695[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$query_$_state_machine__2726__auto__ = null;
var flureenjs$query_$_state_machine__2726__auto____0 = (function (){
var statearr_70686 = [null,null,null,null,null,null,null,null];
(statearr_70686[(0)] = flureenjs$query_$_state_machine__2726__auto__);

(statearr_70686[(1)] = (1));

return statearr_70686;
});
var flureenjs$query_$_state_machine__2726__auto____1 = (function (state_70674){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_70674);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e70687){var ex__2729__auto__ = e70687;
var statearr_70688_70696 = state_70674;
(statearr_70688_70696[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_70674[(4)]))){
var statearr_70689_70697 = state_70674;
(statearr_70689_70697[(1)] = cljs.core.first.call(null,(state_70674[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70698 = state_70674;
state_70674 = G__70698;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$query_$_state_machine__2726__auto__ = function(state_70674){
switch(arguments.length){
case 0:
return flureenjs$query_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$query_$_state_machine__2726__auto____1.call(this,state_70674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$query_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$query_$_state_machine__2726__auto____0;
flureenjs$query_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$query_$_state_machine__2726__auto____1;
return flureenjs$query_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_70690 = f__2749__auto__.call(null);
(statearr_70690[(6)] = c__2748__auto__);

return statearr_70690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.query', flureenjs.query);
/**
 * Execute a query against a database source, with the
 *   given flakes applied.
 * 
 *   Returns promise that eventually contains the results or
 *   an exception.
 */
flureenjs.query_with = (function flureenjs$query_with(db,param){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_70728){
var state_val_70729 = (state_70728[(1)]);
if((state_val_70729 === (1))){
var state_70728__$1 = state_70728;
var statearr_70730_70746 = state_70728__$1;
(statearr_70730_70746[(2)] = null);

(statearr_70730_70746[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70729 === (2))){
var _ = (function (){var statearr_70731 = state_70728;
(statearr_70731[(4)] = cljs.core.cons.call(null,(5),(state_70728[(4)])));

return statearr_70731;
})();
var inst_70709 = cljs.core.js__GT_clj.call(null,param,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70710 = cljs.core.__destructure_map.call(null,inst_70709);
var inst_70711 = cljs.core.get.call(null,inst_70710,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_70712 = cljs.core.get.call(null,inst_70710,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_70713 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_70712);
var state_70728__$1 = (function (){var statearr_70732 = state_70728;
(statearr_70732[(7)] = inst_70713);

(statearr_70732[(8)] = inst_70711);

return statearr_70732;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70728__$1,(6),db);
} else {
if((state_val_70729 === (3))){
var inst_70726 = (state_70728[(2)]);
var state_70728__$1 = state_70728;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70728__$1,inst_70726);
} else {
if((state_val_70729 === (4))){
var inst_70699 = (state_70728[(2)]);
var inst_70700 = fluree.db.util.log.error.call(null,inst_70699);
var inst_70701 = cljs.core.clj__GT_js.call(null,inst_70699);
var inst_70702 = reject.call(null,inst_70701);
var state_70728__$1 = (function (){var statearr_70734 = state_70728;
(statearr_70734[(9)] = inst_70700);

return statearr_70734;
})();
var statearr_70735_70747 = state_70728__$1;
(statearr_70735_70747[(2)] = inst_70702);

(statearr_70735_70747[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70729 === (5))){
var _ = (function (){var statearr_70736 = state_70728;
(statearr_70736[(4)] = cljs.core.rest.call(null,(state_70728[(4)])));

return statearr_70736;
})();
var state_70728__$1 = state_70728;
var ex70733 = (state_70728__$1[(2)]);
var statearr_70737_70748 = state_70728__$1;
(statearr_70737_70748[(5)] = ex70733);


var statearr_70738_70749 = state_70728__$1;
(statearr_70738_70749[(1)] = (4));

(statearr_70738_70749[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70729 === (6))){
var inst_70713 = (state_70728[(7)]);
var inst_70711 = (state_70728[(8)]);
var inst_70715 = (state_70728[(2)]);
var inst_70716 = fluree.db.util.async.throw_err.call(null,inst_70715);
var inst_70717 = fluree.db.dbproto._forward_time_travel.call(null,inst_70716,inst_70713);
var inst_70718 = fluree.db.api.query.query.call(null,inst_70717,inst_70711);
var state_70728__$1 = state_70728;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70728__$1,(7),inst_70718);
} else {
if((state_val_70729 === (7))){
var inst_70720 = (state_70728[(2)]);
var inst_70721 = fluree.db.util.async.throw_err.call(null,inst_70720);
var inst_70722 = cljs.core.clj__GT_js.call(null,inst_70721);
var inst_70723 = resolve.call(null,inst_70722);
var _ = (function (){var statearr_70739 = state_70728;
(statearr_70739[(4)] = cljs.core.rest.call(null,(state_70728[(4)])));

return statearr_70739;
})();
var state_70728__$1 = state_70728;
var statearr_70740_70750 = state_70728__$1;
(statearr_70740_70750[(2)] = inst_70723);

(statearr_70740_70750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$query_with_$_state_machine__2726__auto__ = null;
var flureenjs$query_with_$_state_machine__2726__auto____0 = (function (){
var statearr_70741 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70741[(0)] = flureenjs$query_with_$_state_machine__2726__auto__);

(statearr_70741[(1)] = (1));

return statearr_70741;
});
var flureenjs$query_with_$_state_machine__2726__auto____1 = (function (state_70728){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_70728);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e70742){var ex__2729__auto__ = e70742;
var statearr_70743_70751 = state_70728;
(statearr_70743_70751[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_70728[(4)]))){
var statearr_70744_70752 = state_70728;
(statearr_70744_70752[(1)] = cljs.core.first.call(null,(state_70728[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70753 = state_70728;
state_70728 = G__70753;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$query_with_$_state_machine__2726__auto__ = function(state_70728){
switch(arguments.length){
case 0:
return flureenjs$query_with_$_state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$query_with_$_state_machine__2726__auto____1.call(this,state_70728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$query_with_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$query_with_$_state_machine__2726__auto____0;
flureenjs$query_with_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$query_with_$_state_machine__2726__auto____1;
return flureenjs$query_with_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_70745 = f__2749__auto__.call(null);
(statearr_70745[(6)] = c__2748__auto__);

return statearr_70745;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
goog.exportSymbol('flureenjs.query_with', flureenjs.query_with);
/**
 * Exceute a sparql query against a specified database
 */
flureenjs.sparql = (function flureenjs$sparql(var_args){
var G__70755 = arguments.length;
switch (G__70755) {
case 2:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sparql', flureenjs.sparql);

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$2 = (function (db,sparql_str){
return flureenjs.sparql.call(null,db,sparql_str,null);
}));

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$3 = (function (db,sparql_str,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_70785){
var state_val_70786 = (state_70785[(1)]);
if((state_val_70786 === (7))){
var state_70785__$1 = state_70785;
var statearr_70787_70808 = state_70785__$1;
(statearr_70787_70808[(2)] = null);

(statearr_70787_70808[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70786 === (1))){
var state_70785__$1 = state_70785;
var statearr_70788_70809 = state_70785__$1;
(statearr_70788_70809[(2)] = null);

(statearr_70788_70809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70786 === (4))){
var inst_70756 = (state_70785[(2)]);
var inst_70757 = fluree.db.util.log.error.call(null,inst_70756);
var inst_70758 = cljs.core.clj__GT_js.call(null,inst_70756);
var inst_70759 = reject.call(null,inst_70758);
var state_70785__$1 = (function (){var statearr_70789 = state_70785;
(statearr_70789[(7)] = inst_70757);

return statearr_70789;
})();
var statearr_70790_70810 = state_70785__$1;
(statearr_70790_70810[(2)] = inst_70759);

(statearr_70790_70810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70786 === (6))){
var inst_70769 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_70785__$1 = state_70785;
var statearr_70791_70811 = state_70785__$1;
(statearr_70791_70811[(2)] = inst_70769);

(statearr_70791_70811[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70786 === (3))){
var inst_70783 = (state_70785[(2)]);
var state_70785__$1 = state_70785;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70785__$1,inst_70783);
} else {
if((state_val_70786 === (2))){
var inst_70766 = (state_70785[(8)]);
var _ = (function (){var statearr_70793 = state_70785;
(statearr_70793[(4)] = cljs.core.cons.call(null,(5),(state_70785[(4)])));

return statearr_70793;
})();
var inst_70765 = fluree.db.util.json.parse.call(null,sparql_str);
var inst_70766__$1 = fluree.db.query.sparql_parser.sparql_to_ad_hoc.call(null,inst_70765);
var inst_70767 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_70766__$1);
var state_70785__$1 = (function (){var statearr_70794 = state_70785;
(statearr_70794[(9)] = inst_70767);

(statearr_70794[(8)] = inst_70766__$1);

return statearr_70794;
})();
if(cljs.core.truth_(opts)){
var statearr_70795_70812 = state_70785__$1;
(statearr_70795_70812[(1)] = (6));

} else {
var statearr_70796_70813 = state_70785__$1;
(statearr_70796_70813[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70786 === (9))){
var inst_70777 = (state_70785[(2)]);
var inst_70778 = fluree.db.util.async.throw_err.call(null,inst_70777);
var inst_70779 = cljs.core.clj__GT_js.call(null,inst_70778);
var inst_70780 = resolve.call(null,inst_70779);
var _ = (function (){var statearr_70797 = state_70785;
(statearr_70797[(4)] = cljs.core.rest.call(null,(state_70785[(4)])));

return statearr_70797;
})();
var state_70785__$1 = state_70785;
var statearr_70798_70814 = state_70785__$1;
(statearr_70798_70814[(2)] = inst_70780);

(statearr_70798_70814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70786 === (5))){
var _ = (function (){var statearr_70799 = state_70785;
(statearr_70799[(4)] = cljs.core.rest.call(null,(state_70785[(4)])));

return statearr_70799;
})();
var state_70785__$1 = state_70785;
var ex70792 = (state_70785__$1[(2)]);
var statearr_70800_70815 = state_70785__$1;
(statearr_70800_70815[(5)] = ex70792);


var statearr_70801_70816 = state_70785__$1;
(statearr_70801_70816[(1)] = (4));

(statearr_70801_70816[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70786 === (8))){
var inst_70767 = (state_70785[(9)]);
var inst_70766 = (state_70785[(8)]);
var inst_70772 = (state_70785[(2)]);
var inst_70773 = cljs.core.merge.call(null,inst_70767,inst_70772);
var inst_70774 = cljs.core.assoc.call(null,inst_70766,new cljs.core.Keyword(null,"opts","opts",155075701),inst_70773);
var inst_70775 = fluree.db.api.query.query_async.call(null,db,inst_70774);
var state_70785__$1 = state_70785;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70785__$1,(9),inst_70775);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_70802 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70802[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_70802[(1)] = (1));

return statearr_70802;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_70785){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_70785);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e70803){var ex__2729__auto__ = e70803;
var statearr_70804_70817 = state_70785;
(statearr_70804_70817[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_70785[(4)]))){
var statearr_70805_70818 = state_70785;
(statearr_70805_70818[(1)] = cljs.core.first.call(null,(state_70785[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70819 = state_70785;
state_70785 = G__70819;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_70785){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_70785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_70806 = f__2749__auto__.call(null);
(statearr_70806[(6)] = c__2748__auto__);

return statearr_70806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.sparql.cljs$lang$maxFixedArity = 3);

/**
 * Exceute a sql query against a specified database
 */
flureenjs.sql = (function flureenjs$sql(var_args){
var G__70821 = arguments.length;
switch (G__70821) {
case 2:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sql', flureenjs.sql);

(flureenjs.sql.cljs$core$IFn$_invoke$arity$2 = (function (db,sql_str){
return flureenjs.sql.call(null,db,sql_str,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.sql.cljs$core$IFn$_invoke$arity$3 = (function (db,sql_str,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_70845){
var state_val_70846 = (state_70845[(1)]);
if((state_val_70846 === (1))){
var state_70845__$1 = state_70845;
var statearr_70847_70863 = state_70845__$1;
(statearr_70847_70863[(2)] = null);

(statearr_70847_70863[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70846 === (2))){
var _ = (function (){var statearr_70848 = state_70845;
(statearr_70848[(4)] = cljs.core.cons.call(null,(5),(state_70845[(4)])));

return statearr_70848;
})();
var inst_70831 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_70832 = fluree.db.util.json.parse.call(null,sql_str);
var inst_70833 = fluree.db.query.sql.parse.call(null,inst_70832);
var inst_70834 = cljs.core.update.call(null,inst_70833,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_70831);
var inst_70835 = fluree.db.api.query.query_async.call(null,db,inst_70834);
var state_70845__$1 = state_70845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70845__$1,(6),inst_70835);
} else {
if((state_val_70846 === (3))){
var inst_70843 = (state_70845[(2)]);
var state_70845__$1 = state_70845;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70845__$1,inst_70843);
} else {
if((state_val_70846 === (4))){
var inst_70822 = (state_70845[(2)]);
var inst_70823 = fluree.db.util.log.error.call(null,inst_70822);
var inst_70824 = cljs.core.clj__GT_js.call(null,inst_70822);
var inst_70825 = reject.call(null,inst_70824);
var state_70845__$1 = (function (){var statearr_70850 = state_70845;
(statearr_70850[(7)] = inst_70823);

return statearr_70850;
})();
var statearr_70851_70864 = state_70845__$1;
(statearr_70851_70864[(2)] = inst_70825);

(statearr_70851_70864[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70846 === (5))){
var _ = (function (){var statearr_70852 = state_70845;
(statearr_70852[(4)] = cljs.core.rest.call(null,(state_70845[(4)])));

return statearr_70852;
})();
var state_70845__$1 = state_70845;
var ex70849 = (state_70845__$1[(2)]);
var statearr_70853_70865 = state_70845__$1;
(statearr_70853_70865[(5)] = ex70849);


var statearr_70854_70866 = state_70845__$1;
(statearr_70854_70866[(1)] = (4));

(statearr_70854_70866[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70846 === (6))){
var inst_70837 = (state_70845[(2)]);
var inst_70838 = fluree.db.util.async.throw_err.call(null,inst_70837);
var inst_70839 = cljs.core.clj__GT_js.call(null,inst_70838);
var inst_70840 = resolve.call(null,inst_70839);
var _ = (function (){var statearr_70855 = state_70845;
(statearr_70855[(4)] = cljs.core.rest.call(null,(state_70845[(4)])));

return statearr_70855;
})();
var state_70845__$1 = state_70845;
var statearr_70856_70867 = state_70845__$1;
(statearr_70856_70867[(2)] = inst_70840);

(statearr_70856_70867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2726__auto__ = null;
var flureenjs$state_machine__2726__auto____0 = (function (){
var statearr_70857 = [null,null,null,null,null,null,null,null];
(statearr_70857[(0)] = flureenjs$state_machine__2726__auto__);

(statearr_70857[(1)] = (1));

return statearr_70857;
});
var flureenjs$state_machine__2726__auto____1 = (function (state_70845){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_70845);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e70858){var ex__2729__auto__ = e70858;
var statearr_70859_70868 = state_70845;
(statearr_70859_70868[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_70845[(4)]))){
var statearr_70860_70869 = state_70845;
(statearr_70860_70869[(1)] = cljs.core.first.call(null,(state_70845[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70870 = state_70845;
state_70845 = G__70870;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
flureenjs$state_machine__2726__auto__ = function(state_70845){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2726__auto____0.call(this);
case 1:
return flureenjs$state_machine__2726__auto____1.call(this,state_70845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2726__auto____0;
flureenjs$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2726__auto____1;
return flureenjs$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_70861 = f__2749__auto__.call(null);
(statearr_70861[(6)] = c__2748__auto__);

return statearr_70861;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(flureenjs.sql.cljs$lang$maxFixedArity = 3);

