// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5753__auto__)){
var st = temp__5753__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__16880 = cljs.core._EQ_;
var expr__16881 = e.getLastErrorCode();
if(cljs.core.truth_(pred__16880.call(null,goog.net.ErrorCode.NO_ERROR,expr__16881))){
return new cljs.core.Keyword("xhttp","no-error","xhttp/no-error",1902047248);
} else {
if(cljs.core.truth_(pred__16880.call(null,goog.net.ErrorCode.EXCEPTION,expr__16881))){
return new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040);
} else {
if(cljs.core.truth_(pred__16880.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__16881))){
return new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305);
} else {
if(cljs.core.truth_(pred__16880.call(null,goog.net.ErrorCode.ABORT,expr__16881))){
return new cljs.core.Keyword("xhttp","abort","xhttp/abort",666776046);
} else {
if(cljs.core.truth_(pred__16880.call(null,goog.net.ErrorCode.TIMEOUT,expr__16881))){
return new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562);
} else {
return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4221__auto__ = status;
if(cljs.core.truth_(and__4221__auto__)){
return (status > (0));
} else {
return and__4221__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__16883 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__16883,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__16883;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__16884 = opts;
var map__16884__$1 = cljs.core.__destructure_map.call(null,map__16884);
var request_timeout = cljs.core.get.call(null,map__16884__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__16884__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__16884__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__16885 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__16885__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__16885,headers):G__16885);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__16885__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__16885__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,cljs.core.js__GT_clj.call(null,xhr.getResponseJson(),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"POST",fluree.db.util.json.stringify.call(null,message),cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e16886){var e_16887 = e16886;
fluree.db.util.log.warn.call(null,"CAUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_16887);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__16888 = opts;
var map__16888__$1 = cljs.core.__destructure_map.call(null,map__16888);
var request_timeout = cljs.core.get.call(null,map__16888__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__16888__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__16888__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__16888__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__16888__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__16889 = cljs.core.PersistentArrayMap.EMPTY;
var G__16889__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__16889,headers):G__16889);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__16889__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__16889__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__16891 = output_format;
var G__16891__$1 = (((G__16891 instanceof cljs.core.Keyword))?G__16891.fqn:null);
switch (G__16891__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"GET",body,cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e16890){var e_16893 = e16890;
fluree.db.util.log.warn.call(null,"CAUUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_16893);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__16894 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__16894,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__16894;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_16927){
var state_val_16928 = (state_16927[(1)]);
if((state_val_16928 === (7))){
var inst_16923 = (state_16927[(2)]);
var state_16927__$1 = state_16927;
var statearr_16929_16954 = state_16927__$1;
(statearr_16929_16954[(2)] = inst_16923);

(statearr_16929_16954[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16928 === (1))){
var state_16927__$1 = state_16927;
var statearr_16930_16955 = state_16927__$1;
(statearr_16930_16955[(2)] = null);

(statearr_16930_16955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16928 === (4))){
var inst_16898 = (state_16927[(7)]);
var inst_16898__$1 = (state_16927[(2)]);
var inst_16899 = (inst_16898__$1 == null);
var state_16927__$1 = (function (){var statearr_16931 = state_16927;
(statearr_16931[(7)] = inst_16898__$1);

return statearr_16931;
})();
if(cljs.core.truth_(inst_16899)){
var statearr_16932_16956 = state_16927__$1;
(statearr_16932_16956[(1)] = (5));

} else {
var statearr_16933_16957 = state_16927__$1;
(statearr_16933_16957[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16928 === (6))){
var inst_16898 = (state_16927[(7)]);
var inst_16906 = cljs.core.nth.call(null,inst_16898,(0),null);
var inst_16907 = cljs.core.nth.call(null,inst_16898,(1),null);
var state_16927__$1 = (function (){var statearr_16934 = state_16927;
(statearr_16934[(8)] = inst_16907);

(statearr_16934[(9)] = inst_16906);

return statearr_16934;
})();
var statearr_16935_16958 = state_16927__$1;
(statearr_16935_16958[(2)] = null);

(statearr_16935_16958[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16928 === (3))){
var inst_16925 = (state_16927[(2)]);
var state_16927__$1 = state_16927;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16927__$1,inst_16925);
} else {
if((state_val_16928 === (2))){
var state_16927__$1 = state_16927;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16927__$1,(4),pub_chan);
} else {
if((state_val_16928 === (11))){
var _ = (function (){var statearr_16937 = state_16927;
(statearr_16937[(4)] = cljs.core.rest.call(null,(state_16927[(4)])));

return statearr_16937;
})();
var state_16927__$1 = state_16927;
var ex16936 = (state_16927__$1[(2)]);
var statearr_16938_16959 = state_16927__$1;
(statearr_16938_16959[(5)] = ex16936);


if((ex16936 instanceof Error)){
var statearr_16939_16960 = state_16927__$1;
(statearr_16939_16960[(1)] = (10));

(statearr_16939_16960[(5)] = null);

} else {
throw ex16936;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16928 === (9))){
var inst_16920 = (state_16927[(2)]);
var state_16927__$1 = (function (){var statearr_16940 = state_16927;
(statearr_16940[(10)] = inst_16920);

return statearr_16940;
})();
var statearr_16941_16961 = state_16927__$1;
(statearr_16941_16961[(2)] = null);

(statearr_16941_16961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16928 === (5))){
var inst_16901 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_16927__$1 = state_16927;
var statearr_16942_16962 = state_16927__$1;
(statearr_16942_16962[(2)] = inst_16901);

(statearr_16942_16962[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16928 === (10))){
var inst_16907 = (state_16927[(8)]);
var inst_16908 = (state_16927[(2)]);
var inst_16909 = fluree.db.util.log.error.call(null,inst_16908,"Websocket send message error:",inst_16908);
var inst_16910 = cljs.core.async.put_BANG_.call(null,inst_16907,false);
var state_16927__$1 = (function (){var statearr_16943 = state_16927;
(statearr_16943[(11)] = inst_16909);

return statearr_16943;
})();
var statearr_16944_16963 = state_16927__$1;
(statearr_16944_16963[(2)] = inst_16910);

(statearr_16944_16963[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16928 === (8))){
var inst_16907 = (state_16927[(8)]);
var inst_16906 = (state_16927[(9)]);
var _ = (function (){var statearr_16945 = state_16927;
(statearr_16945[(4)] = cljs.core.cons.call(null,(11),(state_16927[(4)])));

return statearr_16945;
})();
var inst_16916 = ws.send(inst_16906);
var inst_16917 = cljs.core.async.put_BANG_.call(null,inst_16907,true);
var ___$1 = (function (){var statearr_16946 = state_16927;
(statearr_16946[(4)] = cljs.core.rest.call(null,(state_16927[(4)])));

return statearr_16946;
})();
var state_16927__$1 = (function (){var statearr_16947 = state_16927;
(statearr_16947[(12)] = inst_16916);

return statearr_16947;
})();
var statearr_16948_16964 = state_16927__$1;
(statearr_16948_16964[(2)] = inst_16917);

(statearr_16948_16964[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2726__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2726__auto____0 = (function (){
var statearr_16949 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16949[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2726__auto__);

(statearr_16949[(1)] = (1));

return statearr_16949;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2726__auto____1 = (function (state_16927){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_16927);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e16950){var ex__2729__auto__ = e16950;
var statearr_16951_16965 = state_16927;
(statearr_16951_16965[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_16927[(4)]))){
var statearr_16952_16966 = state_16927;
(statearr_16952_16966[(1)] = cljs.core.first.call(null,(state_16927[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16967 = state_16927;
state_16927 = G__16967;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2726__auto__ = function(state_16927){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2726__auto____1.call(this,state_16927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2726__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2726__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_16953 = f__2749__auto__.call(null);
(statearr_16953[(6)] = c__2748__auto__);

return statearr_16953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__2748__auto___17006 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_16993){
var state_val_16994 = (state_16993[(1)]);
if((state_val_16994 === (1))){
var inst_16972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16973 = [open_QMARK_,timeout_chan];
var inst_16974 = (new cljs.core.PersistentVector(null,2,(5),inst_16972,inst_16973,null));
var state_16993__$1 = state_16993;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16993__$1,(2),inst_16974,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_16994 === (2))){
var inst_16976 = (state_16993[(2)]);
var inst_16977 = cljs.core.nth.call(null,inst_16976,(0),null);
var inst_16978 = cljs.core.nth.call(null,inst_16976,(1),null);
var inst_16979 = cljs.core._EQ_.call(null,inst_16978,timeout_chan);
var state_16993__$1 = (function (){var statearr_16995 = state_16993;
(statearr_16995[(7)] = inst_16977);

return statearr_16995;
})();
if(inst_16979){
var statearr_16996_17007 = state_16993__$1;
(statearr_16996_17007[(1)] = (3));

} else {
var statearr_16997_17008 = state_16993__$1;
(statearr_16997_17008[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16994 === (3))){
var inst_16981 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_16982 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16983 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_16984 = cljs.core.PersistentHashMap.fromArrays(inst_16982,inst_16983);
var inst_16985 = cljs.core.ex_info.call(null,inst_16981,inst_16984);
var inst_16986 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_16985);
var inst_16987 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_16993__$1 = (function (){var statearr_16998 = state_16993;
(statearr_16998[(8)] = inst_16986);

return statearr_16998;
})();
var statearr_16999_17009 = state_16993__$1;
(statearr_16999_17009[(2)] = inst_16987);

(statearr_16999_17009[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16994 === (4))){
var inst_16989 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_16993__$1 = state_16993;
var statearr_17000_17010 = state_16993__$1;
(statearr_17000_17010[(2)] = inst_16989);

(statearr_17000_17010[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16994 === (5))){
var inst_16991 = (state_16993[(2)]);
var state_16993__$1 = state_16993;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16993__$1,inst_16991);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2726__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2726__auto____0 = (function (){
var statearr_17001 = [null,null,null,null,null,null,null,null,null];
(statearr_17001[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2726__auto__);

(statearr_17001[(1)] = (1));

return statearr_17001;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2726__auto____1 = (function (state_16993){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_16993);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e17002){var ex__2729__auto__ = e17002;
var statearr_17003_17011 = state_16993;
(statearr_17003_17011[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_16993[(4)]))){
var statearr_17004_17012 = state_16993;
(statearr_17004_17012[(1)] = cljs.core.first.call(null,(state_16993[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17013 = state_16993;
state_16993 = G__17013;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2726__auto__ = function(state_16993){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2726__auto____1.call(this,state_16993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2726__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2726__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_17005 = f__2749__auto__.call(null);
(statearr_17005[(6)] = c__2748__auto___17006);

return statearr_17005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
