// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k27419,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__27423 = k27419;
var G__27423__$1 = (((G__27423 instanceof cljs.core.Keyword))?G__27423.fqn:null);
switch (G__27423__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27419,else__4475__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4495__auto__,p__27424){
var vec__27425 = p__27424;
var k__4496__auto__ = cljs.core.nth.call(null,vec__27425,(0),null);
var v__4497__auto__ = cljs.core.nth.call(null,vec__27425,(1),null);
return f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__);
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4489__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27418){
var self__ = this;
var G__27418__$1 = this;
return (new cljs.core.RecordIter((0),G__27418__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (coll__4469__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__4469__auto__));
}).call(null,this__4468__auto____$1);
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27420,other27421){
var self__ = this;
var this27420__$1 = this;
return (((!((other27421 == null)))) && ((((this27420__$1.constructor === other27421.constructor)) && (((cljs.core._EQ_.call(null,this27420__$1.conn,other27421.conn)) && (((cljs.core._EQ_.call(null,this27420__$1.network,other27421.network)) && (((cljs.core._EQ_.call(null,this27420__$1.dbid,other27421.dbid)) && (((cljs.core._EQ_.call(null,this27420__$1.db_name,other27421.db_name)) && (((cljs.core._EQ_.call(null,this27420__$1.update_chan,other27421.update_chan)) && (((cljs.core._EQ_.call(null,this27420__$1.transact_chan,other27421.transact_chan)) && (((cljs.core._EQ_.call(null,this27420__$1.state,other27421.state)) && (((cljs.core._EQ_.call(null,this27420__$1.schema_cache,other27421.schema_cache)) && (((cljs.core._EQ_.call(null,this27420__$1.blank_db,other27421.blank_db)) && (((cljs.core._EQ_.call(null,this27420__$1.close,other27421.close)) && (((cljs.core._EQ_.call(null,this27420__$1.id,other27421.id)) && (cljs.core._EQ_.call(null,this27420__$1.__extmap,other27421.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4483__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k27419){
var self__ = this;
var this__4479__auto____$1 = this;
var G__27428 = k27419;
var G__27428__$1 = (((G__27428 instanceof cljs.core.Keyword))?G__27428.fqn:null);
switch (G__27428__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_.call(null,self__.__extmap,k27419);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__27418){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__27429 = cljs.core.keyword_identical_QMARK_;
var expr__27430 = k__4481__auto__;
if(cljs.core.truth_(pred__27429.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27430))){
return (new fluree.db.session.DbSession(G__27418,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27429.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27430))){
return (new fluree.db.session.DbSession(self__.conn,G__27418,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27429.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__27430))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27418,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27429.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__27430))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__27418,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27429.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__27430))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__27418,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27429.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__27430))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__27418,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27429.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__27430))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__27418,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27429.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27430))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27418,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27429.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__27430))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27418,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27429.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__27430))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27418,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27429.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__27430))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27418,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4481__auto__,G__27418),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__27418){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27418,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4478__auto__,(0)),cljs.core._nth.call(null,entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write.call(null,writer__4517__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27422){
var extmap__4512__auto__ = (function (){var G__27432 = cljs.core.dissoc.call(null,G__27422,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__27422)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27432);
} else {
return G__27432;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27422),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27422),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27422),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27422),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27422),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27422),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27422),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27422),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27422),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27422),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27422),null,cljs.core.not_empty.call(null,extmap__4512__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27435 = session;
var map__27435__$1 = cljs.core.__destructure_map.call(null,map__27435);
var network = cljs.core.get.call(null,map__27435__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__27435__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.call(null);
var c__2748__auto___27587 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_27539){
var state_val_27540 = (state_27539[(1)]);
if((state_val_27540 === (7))){
var inst_27456 = (state_27539[(7)]);
var inst_27461 = cljs.core.empty_QMARK_.call(null,inst_27456);
var state_27539__$1 = state_27539;
if(inst_27461){
var statearr_27541_27588 = state_27539__$1;
(statearr_27541_27588[(1)] = (10));

} else {
var statearr_27542_27589 = state_27539__$1;
(statearr_27542_27589[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (20))){
var inst_27449 = (state_27539[(8)]);
var inst_27448 = (state_27539[(9)]);
var inst_27487 = (state_27539[(10)]);
var inst_27447 = (state_27539[(11)]);
var inst_27492 = fluree.db.storage.core.read_block.call(null,inst_27447,inst_27448,inst_27449,inst_27487);
var state_27539__$1 = state_27539;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27539__$1,(22),inst_27492);
} else {
if((state_val_27540 === (27))){
var inst_27523 = (state_27539[(12)]);
var inst_27528 = (state_27539[(13)]);
var inst_27526 = (state_27539[(2)]);
var inst_27527 = fluree.db.util.async.throw_err.call(null,inst_27526);
var inst_27528__$1 = cljs.core.assoc.call(null,inst_27523,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27527);
var inst_27529 = fluree.db.query.schema.setting_map.call(null,inst_27528__$1);
var state_27539__$1 = (function (){var statearr_27543 = state_27539;
(statearr_27543[(13)] = inst_27528__$1);

return statearr_27543;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27539__$1,(28),inst_27529);
} else {
if((state_val_27540 === (1))){
var state_27539__$1 = state_27539;
var statearr_27544_27590 = state_27539__$1;
(statearr_27544_27590[(2)] = null);

(statearr_27544_27590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (24))){
var inst_27449 = (state_27539[(8)]);
var inst_27448 = (state_27539[(9)]);
var inst_27487 = (state_27539[(10)]);
var inst_27509 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27487)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27448),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27449),"."].join('');
var inst_27510 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27511 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27512 = cljs.core.PersistentHashMap.fromArrays(inst_27510,inst_27511);
var inst_27513 = cljs.core.ex_info.call(null,inst_27509,inst_27512);
var inst_27514 = (function(){throw inst_27513})();
var state_27539__$1 = state_27539;
var statearr_27545_27591 = state_27539__$1;
(statearr_27545_27591[(2)] = inst_27514);

(statearr_27545_27591[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (4))){
var inst_27436 = (state_27539[(2)]);
var inst_27437 = cljs.core.async.put_BANG_.call(null,pc,inst_27436);
var state_27539__$1 = state_27539;
var statearr_27546_27592 = state_27539__$1;
(statearr_27546_27592[(2)] = inst_27437);

(statearr_27546_27592[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (15))){
var state_27539__$1 = state_27539;
var statearr_27547_27593 = state_27539__$1;
(statearr_27547_27593[(2)] = null);

(statearr_27547_27593[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (21))){
var inst_27518 = (state_27539[(2)]);
var state_27539__$1 = state_27539;
var statearr_27548_27594 = state_27539__$1;
(statearr_27548_27594[(2)] = inst_27518);

(statearr_27548_27594[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (13))){
var inst_27456 = (state_27539[(7)]);
var inst_27481 = (state_27539[(14)]);
var inst_27480 = (state_27539[(2)]);
var inst_27481__$1 = fluree.db.util.async.throw_err.call(null,inst_27480);
var inst_27482 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27456);
var state_27539__$1 = (function (){var statearr_27549 = state_27539;
(statearr_27549[(15)] = inst_27482);

(statearr_27549[(14)] = inst_27481__$1);

return statearr_27549;
})();
if(cljs.core.truth_(inst_27481__$1)){
var statearr_27550_27595 = state_27539__$1;
(statearr_27550_27595[(1)] = (14));

} else {
var statearr_27551_27596 = state_27539__$1;
(statearr_27551_27596[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (22))){
var inst_27495 = (state_27539[(16)]);
var inst_27494 = (state_27539[(2)]);
var inst_27495__$1 = fluree.db.util.async.throw_err.call(null,inst_27494);
var state_27539__$1 = (function (){var statearr_27552 = state_27539;
(statearr_27552[(16)] = inst_27495__$1);

return statearr_27552;
})();
if(cljs.core.truth_(inst_27495__$1)){
var statearr_27553_27597 = state_27539__$1;
(statearr_27553_27597[(1)] = (23));

} else {
var statearr_27554_27598 = state_27539__$1;
(statearr_27554_27598[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (6))){
var inst_27456 = (state_27539[(7)]);
var inst_27455 = (state_27539[(2)]);
var inst_27456__$1 = fluree.db.util.async.throw_err.call(null,inst_27455);
var inst_27457 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27456__$1);
var inst_27458 = cljs.core.keyword.call(null,inst_27457);
var inst_27459 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),inst_27458);
var state_27539__$1 = (function (){var statearr_27555 = state_27539;
(statearr_27555[(7)] = inst_27456__$1);

return statearr_27555;
})();
if(inst_27459){
var statearr_27556_27599 = state_27539__$1;
(statearr_27556_27599[(1)] = (7));

} else {
var statearr_27557_27600 = state_27539__$1;
(statearr_27557_27600[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (28))){
var inst_27528 = (state_27539[(13)]);
var inst_27531 = (state_27539[(2)]);
var inst_27532 = fluree.db.util.async.throw_err.call(null,inst_27531);
var inst_27533 = cljs.core.assoc.call(null,inst_27528,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27532);
var inst_27534 = cljs.core.async.put_BANG_.call(null,pc,inst_27533);
var _ = (function (){var statearr_27558 = state_27539;
(statearr_27558[(4)] = cljs.core.rest.call(null,(state_27539[(4)])));

return statearr_27558;
})();
var state_27539__$1 = state_27539;
var statearr_27559_27601 = state_27539__$1;
(statearr_27559_27601[(2)] = inst_27534);

(statearr_27559_27601[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (25))){
var inst_27516 = (state_27539[(2)]);
var state_27539__$1 = state_27539;
var statearr_27560_27602 = state_27539__$1;
(statearr_27560_27602[(2)] = inst_27516);

(statearr_27560_27602[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (17))){
var inst_27482 = (state_27539[(15)]);
var inst_27487 = (state_27539[(10)]);
var inst_27489 = (inst_27487 > inst_27482);
var state_27539__$1 = state_27539;
if(cljs.core.truth_(inst_27489)){
var statearr_27561_27603 = state_27539__$1;
(statearr_27561_27603[(1)] = (19));

} else {
var statearr_27562_27604 = state_27539__$1;
(statearr_27562_27604[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (3))){
var inst_27537 = (state_27539[(2)]);
var state_27539__$1 = state_27539;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27539__$1,inst_27537);
} else {
if((state_val_27540 === (12))){
var inst_27468 = (state_27539[(2)]);
var inst_27469 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27470 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27471 = cljs.core.PersistentHashMap.fromArrays(inst_27469,inst_27470);
var inst_27472 = cljs.core.ex_info.call(null,inst_27468,inst_27471);
var inst_27473 = (function(){throw inst_27472})();
var state_27539__$1 = state_27539;
var statearr_27563_27605 = state_27539__$1;
(statearr_27563_27605[(2)] = inst_27473);

(statearr_27563_27605[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (2))){
var inst_27449 = (state_27539[(8)]);
var inst_27448 = (state_27539[(9)]);
var inst_27447 = (state_27539[(11)]);
var _ = (function (){var statearr_27564 = state_27539;
(statearr_27564[(4)] = cljs.core.cons.call(null,(5),(state_27539[(4)])));

return statearr_27564;
})();
var inst_27444 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_27445 = session;
var inst_27446 = cljs.core.__destructure_map.call(null,inst_27445);
var inst_27447__$1 = cljs.core.get.call(null,inst_27446,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_27448__$1 = cljs.core.get.call(null,inst_27446,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_27449__$1 = cljs.core.get.call(null,inst_27446,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_27450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27451 = [inst_27448__$1,inst_27449__$1];
var inst_27452 = (new cljs.core.PersistentVector(null,2,(5),inst_27450,inst_27451,null));
var inst_27453 = fluree.db.operations.ledger_info_async.call(null,inst_27447__$1,inst_27452);
var state_27539__$1 = (function (){var statearr_27565 = state_27539;
(statearr_27565[(8)] = inst_27449__$1);

(statearr_27565[(9)] = inst_27448__$1);

(statearr_27565[(17)] = inst_27444);

(statearr_27565[(11)] = inst_27447__$1);

return statearr_27565;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27539__$1,(6),inst_27453);
} else {
if((state_val_27540 === (23))){
var inst_27495 = (state_27539[(16)]);
var inst_27486 = (state_27539[(18)]);
var inst_27498 = cljs.core.__destructure_map.call(null,inst_27495);
var inst_27499 = cljs.core.get.call(null,inst_27498,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27500 = cljs.core.get.call(null,inst_27498,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27501 = cljs.core.get.call(null,inst_27498,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27502 = fluree.db.dbproto._with.call(null,inst_27486,inst_27500,inst_27499);
var state_27539__$1 = (function (){var statearr_27566 = state_27539;
(statearr_27566[(19)] = inst_27501);

return statearr_27566;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27539__$1,(26),inst_27502);
} else {
if((state_val_27540 === (19))){
var inst_27486 = (state_27539[(18)]);
var state_27539__$1 = state_27539;
var statearr_27567_27606 = state_27539__$1;
(statearr_27567_27606[(2)] = inst_27486);

(statearr_27567_27606[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (11))){
var inst_27449 = (state_27539[(8)]);
var inst_27456 = (state_27539[(7)]);
var inst_27448 = (state_27539[(9)]);
var inst_27465 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27456);
var inst_27466 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27448),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27449)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27465),"."].join('');
var state_27539__$1 = state_27539;
var statearr_27569_27607 = state_27539__$1;
(statearr_27569_27607[(2)] = inst_27466);

(statearr_27569_27607[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (9))){
var inst_27449 = (state_27539[(8)]);
var inst_27456 = (state_27539[(7)]);
var inst_27448 = (state_27539[(9)]);
var inst_27444 = (state_27539[(17)]);
var inst_27447 = (state_27539[(11)]);
var inst_27476 = (state_27539[(2)]);
var inst_27477 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_27456);
var inst_27478 = fluree.db.storage.core.reify_db.call(null,inst_27447,inst_27448,inst_27449,inst_27444,inst_27477);
var state_27539__$1 = (function (){var statearr_27570 = state_27539;
(statearr_27570[(20)] = inst_27476);

return statearr_27570;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27539__$1,(13),inst_27478);
} else {
if((state_val_27540 === (5))){
var _ = (function (){var statearr_27571 = state_27539;
(statearr_27571[(4)] = cljs.core.rest.call(null,(state_27539[(4)])));

return statearr_27571;
})();
var state_27539__$1 = state_27539;
var ex27568 = (state_27539__$1[(2)]);
var statearr_27572_27608 = state_27539__$1;
(statearr_27572_27608[(5)] = ex27568);


var statearr_27573_27609 = state_27539__$1;
(statearr_27573_27609[(1)] = (4));

(statearr_27573_27609[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (14))){
var inst_27481 = (state_27539[(14)]);
var inst_27484 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27481);
var inst_27485 = (inst_27484 + (1));
var inst_27486 = inst_27481;
var inst_27487 = inst_27485;
var state_27539__$1 = (function (){var statearr_27574 = state_27539;
(statearr_27574[(10)] = inst_27487);

(statearr_27574[(18)] = inst_27486);

return statearr_27574;
})();
var statearr_27575_27610 = state_27539__$1;
(statearr_27575_27610[(2)] = null);

(statearr_27575_27610[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (26))){
var inst_27487 = (state_27539[(10)]);
var inst_27504 = (state_27539[(2)]);
var inst_27505 = fluree.db.util.async.throw_err.call(null,inst_27504);
var inst_27506 = (inst_27487 + (1));
var inst_27486 = inst_27505;
var inst_27487__$1 = inst_27506;
var state_27539__$1 = (function (){var statearr_27576 = state_27539;
(statearr_27576[(10)] = inst_27487__$1);

(statearr_27576[(18)] = inst_27486);

return statearr_27576;
})();
var statearr_27577_27611 = state_27539__$1;
(statearr_27577_27611[(2)] = null);

(statearr_27577_27611[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (16))){
var inst_27523 = (state_27539[(12)]);
var inst_27523__$1 = (state_27539[(2)]);
var inst_27524 = fluree.db.query.schema.schema_map.call(null,inst_27523__$1);
var state_27539__$1 = (function (){var statearr_27578 = state_27539;
(statearr_27578[(12)] = inst_27523__$1);

return statearr_27578;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27539__$1,(27),inst_27524);
} else {
if((state_val_27540 === (10))){
var inst_27449 = (state_27539[(8)]);
var inst_27448 = (state_27539[(9)]);
var inst_27463 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27448),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27449)," is not found on this ledger group."].join('');
var state_27539__$1 = state_27539;
var statearr_27579_27612 = state_27539__$1;
(statearr_27579_27612[(2)] = inst_27463);

(statearr_27579_27612[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (18))){
var inst_27520 = (state_27539[(2)]);
var state_27539__$1 = state_27539;
var statearr_27580_27613 = state_27539__$1;
(statearr_27580_27613[(2)] = inst_27520);

(statearr_27580_27613[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27540 === (8))){
var state_27539__$1 = state_27539;
var statearr_27581_27614 = state_27539__$1;
(statearr_27581_27614[(2)] = null);

(statearr_27581_27614[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2726__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2726__auto____0 = (function (){
var statearr_27582 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27582[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2726__auto__);

(statearr_27582[(1)] = (1));

return statearr_27582;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2726__auto____1 = (function (state_27539){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_27539);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e27583){var ex__2729__auto__ = e27583;
var statearr_27584_27615 = state_27539;
(statearr_27584_27615[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_27539[(4)]))){
var statearr_27585_27616 = state_27539;
(statearr_27585_27616[(1)] = cljs.core.first.call(null,(state_27539[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27617 = state_27539;
state_27539 = G__27617;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2726__auto__ = function(state_27539){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2726__auto____1.call(this,state_27539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2726__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2726__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_27586 = f__2749__auto__.call(null);
(statearr_27586[(6)] = c__2748__auto___27587);

return statearr_27586;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.call(null,old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.call(null,new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__27618 = s;
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,G__27618,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),block);
} else {
return G__27618;
}
}));

return cljs.core._EQ_.call(null,block,fluree.db.session.indexing_QMARK_.call(null,session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4223__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4712__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_27620){
var state_val_27621 = (state_27620[(1)]);
if((state_val_27621 === (1))){
var state_27620__$1 = state_27620;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27620__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2726__auto__ = null;
var fluree$db$session$state_machine__2726__auto____0 = (function (){
var statearr_27622 = [null,null,null,null,null,null,null];
(statearr_27622[(0)] = fluree$db$session$state_machine__2726__auto__);

(statearr_27622[(1)] = (1));

return statearr_27622;
});
var fluree$db$session$state_machine__2726__auto____1 = (function (state_27620){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_27620);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e27623){var ex__2729__auto__ = e27623;
var statearr_27624_27627 = state_27620;
(statearr_27624_27627[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_27620[(4)]))){
var statearr_27625_27628 = state_27620;
(statearr_27625_27628[(1)] = cljs.core.first.call(null,(state_27620[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27629 = state_27620;
state_27620 = G__27629;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$session$state_machine__2726__auto__ = function(state_27620){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2726__auto____1.call(this,state_27620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2726__auto____0;
fluree$db$session$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2726__auto____1;
return fluree$db$session$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_27626 = f__2749__auto__.call(null);
(statearr_27626[(6)] = c__2748__auto__);

return statearr_27626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27631){
var map__27632 = p__27631;
var map__27632__$1 = cljs.core.__destructure_map.call(null,map__27632);
var data = map__27632__$1;
var block = cljs.core.get.call(null,map__27632__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__27632__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__27632__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_27691){
var state_val_27692 = (state_27691[(1)]);
if((state_val_27692 === (7))){
var inst_27646 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27647 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27648 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27646),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27647),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_27649 = fluree.db.util.log.info.call(null,inst_27648);
var state_27691__$1 = state_27691;
var statearr_27693_27727 = state_27691__$1;
(statearr_27693_27727[(2)] = inst_27649);

(statearr_27693_27727[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (1))){
var state_27691__$1 = state_27691;
var statearr_27694_27728 = state_27691__$1;
(statearr_27694_27728[(2)] = null);

(statearr_27694_27728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (4))){
var inst_27633 = (state_27691[(2)]);
var state_27691__$1 = state_27691;
var statearr_27695_27729 = state_27691__$1;
(statearr_27695_27729[(2)] = inst_27633);

(statearr_27695_27729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (15))){
var inst_27672 = (state_27691[(2)]);
var state_27691__$1 = state_27691;
var statearr_27696_27730 = state_27691__$1;
(statearr_27696_27730[(2)] = inst_27672);

(statearr_27696_27730[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (13))){
var inst_27663 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27665 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27666 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27667 = [inst_27665,inst_27666];
var inst_27668 = (new cljs.core.PersistentVector(null,2,(5),inst_27664,inst_27667,null));
var inst_27669 = fluree.db.conn_events.process_event.call(null,inst_27663,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_27668,data);
var state_27691__$1 = state_27691;
var statearr_27697_27731 = state_27691__$1;
(statearr_27697_27731[(2)] = inst_27669);

(statearr_27697_27731[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (6))){
var inst_27642 = (state_27691[(7)]);
var inst_27643 = (state_27691[(8)]);
var inst_27641 = (state_27691[(2)]);
var inst_27642__$1 = fluree.db.util.async.throw_err.call(null,inst_27641);
var inst_27643__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27642__$1);
var inst_27644 = (block <= inst_27643__$1);
var state_27691__$1 = (function (){var statearr_27698 = state_27691;
(statearr_27698[(7)] = inst_27642__$1);

(statearr_27698[(8)] = inst_27643__$1);

return statearr_27698;
})();
if(cljs.core.truth_(inst_27644)){
var statearr_27699_27732 = state_27691__$1;
(statearr_27699_27732[(1)] = (7));

} else {
var statearr_27700_27733 = state_27691__$1;
(statearr_27700_27733[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (17))){
var state_27691__$1 = state_27691;
var statearr_27701_27734 = state_27691__$1;
(statearr_27701_27734[(2)] = null);

(statearr_27701_27734[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (3))){
var inst_27689 = (state_27691[(2)]);
var state_27691__$1 = state_27691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27691__$1,inst_27689);
} else {
if((state_val_27692 === (12))){
var inst_27684 = (state_27691[(2)]);
var state_27691__$1 = state_27691;
var statearr_27702_27735 = state_27691__$1;
(statearr_27702_27735[(2)] = inst_27684);

(statearr_27702_27735[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (2))){
var inst_27639 = (state_27691[(9)]);
var _ = (function (){var statearr_27703 = state_27691;
(statearr_27703[(4)] = cljs.core.cons.call(null,(5),(state_27691[(4)])));

return statearr_27703;
})();
var inst_27639__$1 = fluree.db.session.current_db.call(null,session);
var state_27691__$1 = (function (){var statearr_27704 = state_27691;
(statearr_27704[(9)] = inst_27639__$1);

return statearr_27704;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27691__$1,(6),inst_27639__$1);
} else {
if((state_val_27692 === (11))){
var state_27691__$1 = state_27691;
var statearr_27706_27736 = state_27691__$1;
(statearr_27706_27736[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (9))){
var inst_27686 = (state_27691[(2)]);
var _ = (function (){var statearr_27708 = state_27691;
(statearr_27708[(4)] = cljs.core.rest.call(null,(state_27691[(4)])));

return statearr_27708;
})();
var state_27691__$1 = state_27691;
var statearr_27709_27737 = state_27691__$1;
(statearr_27709_27737[(2)] = inst_27686);

(statearr_27709_27737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (5))){
var _ = (function (){var statearr_27710 = state_27691;
(statearr_27710[(4)] = cljs.core.rest.call(null,(state_27691[(4)])));

return statearr_27710;
})();
var state_27691__$1 = state_27691;
var ex27705 = (state_27691__$1[(2)]);
var statearr_27711_27738 = state_27691__$1;
(statearr_27711_27738[(5)] = ex27705);


if((ex27705 instanceof Error)){
var statearr_27712_27739 = state_27691__$1;
(statearr_27712_27739[(1)] = (4));

(statearr_27712_27739[(5)] = null);

} else {
throw ex27705;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (14))){
var state_27691__$1 = state_27691;
var statearr_27713_27740 = state_27691__$1;
(statearr_27713_27740[(2)] = null);

(statearr_27713_27740[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (16))){
var inst_27643 = (state_27691[(8)]);
var inst_27675 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27676 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27677 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27675),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27676),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27643),". Forcing a db reload."].join('');
var inst_27678 = fluree.db.util.log.info.call(null,inst_27677);
var inst_27679 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_27691__$1 = (function (){var statearr_27714 = state_27691;
(statearr_27714[(10)] = inst_27678);

return statearr_27714;
})();
var statearr_27715_27741 = state_27691__$1;
(statearr_27715_27741[(2)] = inst_27679);

(statearr_27715_27741[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (10))){
var inst_27642 = (state_27691[(7)]);
var inst_27639 = (state_27691[(9)]);
var inst_27643 = (state_27691[(8)]);
var inst_27654 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27655 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27656 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27654),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27655),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27657 = fluree.db.util.log.trace.call(null,inst_27656);
var inst_27658 = (function (){var current_db_ch = inst_27639;
var current_db = inst_27642;
var current_block = inst_27643;
return (function (p1__27630_SHARP_){
if((p1__27630_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__27630_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,p1__27630_SHARP_);
}
});
})();
var inst_27659 = cljs.core.map.call(null,inst_27658,flakes);
var inst_27660 = fluree.db.dbproto._with.call(null,inst_27642,block,inst_27659);
var inst_27661 = fluree.db.session.cas_db_BANG_.call(null,session,inst_27639,inst_27660);
var state_27691__$1 = (function (){var statearr_27716 = state_27691;
(statearr_27716[(11)] = inst_27657);

return statearr_27716;
})();
if(inst_27661){
var statearr_27717_27742 = state_27691__$1;
(statearr_27717_27742[(1)] = (13));

} else {
var statearr_27718_27743 = state_27691__$1;
(statearr_27718_27743[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (18))){
var inst_27682 = (state_27691[(2)]);
var state_27691__$1 = state_27691;
var statearr_27719_27744 = state_27691__$1;
(statearr_27719_27744[(2)] = inst_27682);

(statearr_27719_27744[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27692 === (8))){
var inst_27643 = (state_27691[(8)]);
var inst_27651 = ((1) + inst_27643);
var inst_27652 = cljs.core._EQ_.call(null,block,inst_27651);
var state_27691__$1 = state_27691;
if(inst_27652){
var statearr_27720_27745 = state_27691__$1;
(statearr_27720_27745[(1)] = (10));

} else {
var statearr_27721_27746 = state_27691__$1;
(statearr_27721_27746[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2726__auto__ = null;
var fluree$db$session$state_machine__2726__auto____0 = (function (){
var statearr_27722 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27722[(0)] = fluree$db$session$state_machine__2726__auto__);

(statearr_27722[(1)] = (1));

return statearr_27722;
});
var fluree$db$session$state_machine__2726__auto____1 = (function (state_27691){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_27691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e27723){var ex__2729__auto__ = e27723;
var statearr_27724_27747 = state_27691;
(statearr_27724_27747[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_27691[(4)]))){
var statearr_27725_27748 = state_27691;
(statearr_27725_27748[(1)] = cljs.core.first.call(null,(state_27691[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27749 = state_27691;
state_27691 = G__27749;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$session$state_machine__2726__auto__ = function(state_27691){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2726__auto____1.call(this,state_27691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2726__auto____0;
fluree$db$session$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2726__auto____1;
return fluree$db$session$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_27726 = f__2749__auto__.call(null);
(statearr_27726[(6)] = c__2748__auto__);

return statearr_27726;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_27756){
var state_val_27757 = (state_27756[(1)]);
if((state_val_27757 === (1))){
var inst_27750 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_27751 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27752 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27753 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27751),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27752)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_27754 = fluree.db.util.log.debug.call(null,inst_27753);
var state_27756__$1 = (function (){var statearr_27758 = state_27756;
(statearr_27758[(7)] = inst_27750);

(statearr_27758[(8)] = inst_27754);

return statearr_27758;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27756__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2726__auto__ = null;
var fluree$db$session$state_machine__2726__auto____0 = (function (){
var statearr_27759 = [null,null,null,null,null,null,null,null,null];
(statearr_27759[(0)] = fluree$db$session$state_machine__2726__auto__);

(statearr_27759[(1)] = (1));

return statearr_27759;
});
var fluree$db$session$state_machine__2726__auto____1 = (function (state_27756){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_27756);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e27760){var ex__2729__auto__ = e27760;
var statearr_27761_27764 = state_27756;
(statearr_27761_27764[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_27756[(4)]))){
var statearr_27762_27765 = state_27756;
(statearr_27762_27765[(1)] = cljs.core.first.call(null,(state_27756[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27766 = state_27756;
state_27756 = G__27766;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$session$state_machine__2726__auto__ = function(state_27756){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2726__auto____1.call(this,state_27756);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2726__auto____0;
fluree$db$session$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2726__auto____1;
return fluree$db$session$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_27763 = f__2749__auto__.call(null);
(statearr_27763[(6)] = c__2748__auto__);

return statearr_27763;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__27768 = arguments.length;
switch (G__27768) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
return false;
} else {
var map__27769 = session;
var map__27769__$1 = cljs.core.__destructure_map.call(null,map__27769);
var conn = cljs.core.get.call(null,map__27769__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__27769__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__27769__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__27769__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__27769__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__27769__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.call(null,map__27769__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_.call(null,session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,dbid,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache.call(null,network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_27823){
var state_val_27824 = (state_27823[(1)]);
if((state_val_27824 === (7))){
var inst_27819 = (state_27823[(2)]);
var state_27823__$1 = state_27823;
var statearr_27825_27856 = state_27823__$1;
(statearr_27825_27856[(2)] = inst_27819);

(statearr_27825_27856[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (1))){
var state_27823__$1 = state_27823;
var statearr_27826_27857 = state_27823__$1;
(statearr_27826_27857[(2)] = null);

(statearr_27826_27857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (4))){
var inst_27774 = (state_27823[(7)]);
var inst_27773 = (state_27823[(2)]);
var inst_27774__$1 = fluree.db.util.async.throw_err.call(null,inst_27773);
var inst_27775 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_27776 = (inst_27774__$1 == null);
var state_27823__$1 = (function (){var statearr_27827 = state_27823;
(statearr_27827[(7)] = inst_27774__$1);

(statearr_27827[(8)] = inst_27775);

return statearr_27827;
})();
if(cljs.core.truth_(inst_27776)){
var statearr_27828_27858 = state_27823__$1;
(statearr_27828_27858[(1)] = (5));

} else {
var statearr_27829_27859 = state_27823__$1;
(statearr_27829_27859[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (15))){
var inst_27811 = (state_27823[(2)]);
var state_27823__$1 = (function (){var statearr_27830 = state_27823;
(statearr_27830[(9)] = inst_27811);

return statearr_27830;
})();
var statearr_27831_27860 = state_27823__$1;
(statearr_27831_27860[(2)] = null);

(statearr_27831_27860[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (13))){
var inst_27815 = (state_27823[(2)]);
var state_27823__$1 = state_27823;
var statearr_27833_27861 = state_27823__$1;
(statearr_27833_27861[(2)] = inst_27815);

(statearr_27833_27861[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (6))){
var inst_27775 = (state_27823[(8)]);
var inst_27781 = (inst_27775 == null);
var state_27823__$1 = state_27823;
if(cljs.core.truth_(inst_27781)){
var statearr_27834_27862 = state_27823__$1;
(statearr_27834_27862[(1)] = (8));

} else {
var statearr_27835_27863 = state_27823__$1;
(statearr_27835_27863[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (17))){
var _ = (function (){var statearr_27836 = state_27823;
(statearr_27836[(4)] = cljs.core.rest.call(null,(state_27823[(4)])));

return statearr_27836;
})();
var state_27823__$1 = state_27823;
var ex27832 = (state_27823__$1[(2)]);
var statearr_27837_27864 = state_27823__$1;
(statearr_27837_27864[(5)] = ex27832);


var statearr_27838_27865 = state_27823__$1;
(statearr_27838_27865[(1)] = (16));

(statearr_27838_27865[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (3))){
var inst_27821 = (state_27823[(2)]);
var state_27823__$1 = state_27823;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27823__$1,inst_27821);
} else {
if((state_val_27824 === (12))){
var state_27823__$1 = state_27823;
var statearr_27839_27866 = state_27823__$1;
(statearr_27839_27866[(2)] = null);

(statearr_27839_27866[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (2))){
var state_27823__$1 = state_27823;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27823__$1,(4),update_chan);
} else {
if((state_val_27824 === (11))){
var state_27823__$1 = state_27823;
var statearr_27840_27867 = state_27823__$1;
(statearr_27840_27867[(2)] = null);

(statearr_27840_27867[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (9))){
var state_27823__$1 = state_27823;
var statearr_27841_27868 = state_27823__$1;
(statearr_27841_27868[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (5))){
var inst_27778 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_27779 = fluree.db.util.log.info.call(null,inst_27778);
var state_27823__$1 = state_27823;
var statearr_27843_27869 = state_27823__$1;
(statearr_27843_27869[(2)] = inst_27779);

(statearr_27843_27869[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (14))){
var inst_27774 = (state_27823[(7)]);
var inst_27775 = (state_27823[(8)]);
var _ = (function (){var statearr_27844 = state_27823;
(statearr_27844[(4)] = cljs.core.cons.call(null,(17),(state_27823[(4)])));

return statearr_27844;
})();
var inst_27799 = cljs.core.nth.call(null,inst_27774,(0),null);
var inst_27800 = cljs.core.nth.call(null,inst_27774,(1),null);
var inst_27801 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_27802 = cljs.core.pr_str.call(null,inst_27774);
var inst_27803 = fluree.db.util.core.trunc.call(null,inst_27802,(200));
var inst_27804 = fluree.db.util.log.trace.call(null,inst_27801,inst_27803);
var inst_27805 = fluree.db.session.process_ledger_update.call(null,inst_27775,inst_27799,inst_27800);
var state_27823__$1 = (function (){var statearr_27845 = state_27823;
(statearr_27845[(10)] = inst_27804);

return statearr_27845;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27823__$1,(18),inst_27805);
} else {
if((state_val_27824 === (16))){
var inst_27774 = (state_27823[(7)]);
var inst_27789 = (state_27823[(2)]);
var inst_27790 = fluree.db.util.log.error.call(null,inst_27789,"Exception processing ledger updates for message: ",inst_27774);
var state_27823__$1 = state_27823;
var statearr_27846_27870 = state_27823__$1;
(statearr_27846_27870[(2)] = inst_27790);

(statearr_27846_27870[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (10))){
var inst_27817 = (state_27823[(2)]);
var state_27823__$1 = state_27823;
var statearr_27847_27871 = state_27823__$1;
(statearr_27847_27871[(2)] = inst_27817);

(statearr_27847_27871[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (18))){
var inst_27807 = (state_27823[(2)]);
var inst_27808 = fluree.db.util.async.throw_err.call(null,inst_27807);
var _ = (function (){var statearr_27848 = state_27823;
(statearr_27848[(4)] = cljs.core.rest.call(null,(state_27823[(4)])));

return statearr_27848;
})();
var state_27823__$1 = state_27823;
var statearr_27849_27872 = state_27823__$1;
(statearr_27849_27872[(2)] = inst_27808);

(statearr_27849_27872[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27824 === (8))){
var inst_27774 = (state_27823[(7)]);
var inst_27783 = cljs.core.first.call(null,inst_27774);
var inst_27784 = cljs.core.pr_str.call(null,inst_27783);
var inst_27785 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_27784].join('');
var inst_27786 = fluree.db.util.log.warn.call(null,inst_27785);
var state_27823__$1 = state_27823;
var statearr_27850_27873 = state_27823__$1;
(statearr_27850_27873[(2)] = inst_27786);

(statearr_27850_27873[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2726__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2726__auto____0 = (function (){
var statearr_27851 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27851[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2726__auto__);

(statearr_27851[(1)] = (1));

return statearr_27851;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2726__auto____1 = (function (state_27823){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_27823);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e27852){var ex__2729__auto__ = e27852;
var statearr_27853_27874 = state_27823;
(statearr_27853_27874[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_27823[(4)]))){
var statearr_27854_27875 = state_27823;
(statearr_27854_27875[(1)] = cljs.core.first.call(null,(state_27823[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27876 = state_27823;
state_27823 = G__27876;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2726__auto__ = function(state_27823){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2726__auto____1.call(this,state_27823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2726__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2726__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_27855 = f__2749__auto__.call(null);
(statearr_27855[(6)] = c__2748__auto__);

return statearr_27855;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__27877){
var map__27878 = p__27877;
var map__27878__$1 = cljs.core.__destructure_map.call(null,map__27878);
var network = cljs.core.get.call(null,map__27878__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__27878__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.call(null,map__27878__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.call(null,map__27878__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.call(null,map__27878__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__27878__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__27878__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__27878__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__27878__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.call(null);
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return fluree.db.session.current_db.call(null,session);
});
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__27882 = block_result;
var map__27882__$1 = cljs.core.__destructure_map.call(null,map__27882);
var block = cljs.core.get.call(null,map__27882__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__27882__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__27882__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__27882__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__27882__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4223__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__27883 = tx_result;
var map__27883__$1 = cljs.core.__destructure_map.call(null,map__27883);
var t = cljs.core.get.call(null,map__27883__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__27883__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__27879_SHARP_){
return cljs.core._EQ_.call(null,t,p1__27879_SHARP_.t);
}):(function (p1__27880_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__27880_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__27881_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__27881_SHARP_))){
return cljs.core.nth.call(null,p1__27881_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__27884 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__27884,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__27884,(1),null);
var error = cljs.core.nth.call(null,vec__27884,(2),null);
var message = cljs.core.nth.call(null,vec__27884,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__4223__auto__ = message;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));
var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__27888 = arguments.length;
switch (G__27888) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__27889){
var map__27890 = p__27889;
var map__27890__$1 = cljs.core.__destructure_map.call(null,map__27890);
var state = cljs.core.get.call(null,map__27890__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__27890__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__27890__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__27890__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__27891 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__27891,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__27891,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__27891,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4223__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4223__auto____$1 = state;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5753__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__27894 = cljs.core.seq.call(null,tids);
var chunk__27895 = null;
var count__27896 = (0);
var i__27897 = (0);
while(true){
if((i__27897 < count__27896)){
var tid = cljs.core._nth.call(null,chunk__27895,i__27897);
var temp__5753__auto___28010__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5753__auto___28010__$1)){
var keyed_callbacks_28011 = temp__5753__auto___28010__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_28012 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27938_28013 = cljs.core.seq.call(null,keyed_callbacks_28011);
var chunk__27939_28014 = null;
var count__27940_28015 = (0);
var i__27941_28016 = (0);
while(true){
if((i__27941_28016 < count__27940_28015)){
var vec__27950_28017 = cljs.core._nth.call(null,chunk__27939_28014,i__27941_28016);
var k_28018 = cljs.core.nth.call(null,vec__27950_28017,(0),null);
var f_28019 = cljs.core.nth.call(null,vec__27950_28017,(1),null);
try{f_28019.call(null,tx_response_28012);
}catch (e27953){var e_28020 = e27953;
fluree.db.util.log.error.call(null,e_28020,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__28021 = seq__27938_28013;
var G__28022 = chunk__27939_28014;
var G__28023 = count__27940_28015;
var G__28024 = (i__27941_28016 + (1));
seq__27938_28013 = G__28021;
chunk__27939_28014 = G__28022;
count__27940_28015 = G__28023;
i__27941_28016 = G__28024;
continue;
} else {
var temp__5753__auto___28025__$2 = cljs.core.seq.call(null,seq__27938_28013);
if(temp__5753__auto___28025__$2){
var seq__27938_28026__$1 = temp__5753__auto___28025__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27938_28026__$1)){
var c__4649__auto___28027 = cljs.core.chunk_first.call(null,seq__27938_28026__$1);
var G__28028 = cljs.core.chunk_rest.call(null,seq__27938_28026__$1);
var G__28029 = c__4649__auto___28027;
var G__28030 = cljs.core.count.call(null,c__4649__auto___28027);
var G__28031 = (0);
seq__27938_28013 = G__28028;
chunk__27939_28014 = G__28029;
count__27940_28015 = G__28030;
i__27941_28016 = G__28031;
continue;
} else {
var vec__27954_28032 = cljs.core.first.call(null,seq__27938_28026__$1);
var k_28033 = cljs.core.nth.call(null,vec__27954_28032,(0),null);
var f_28034 = cljs.core.nth.call(null,vec__27954_28032,(1),null);
try{f_28034.call(null,tx_response_28012);
}catch (e27957){var e_28035 = e27957;
fluree.db.util.log.error.call(null,e_28035,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__28036 = cljs.core.next.call(null,seq__27938_28026__$1);
var G__28037 = null;
var G__28038 = (0);
var G__28039 = (0);
seq__27938_28013 = G__28036;
chunk__27939_28014 = G__28037;
count__27940_28015 = G__28038;
i__27941_28016 = G__28039;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28040 = seq__27894;
var G__28041 = chunk__27895;
var G__28042 = count__27896;
var G__28043 = (i__27897 + (1));
seq__27894 = G__28040;
chunk__27895 = G__28041;
count__27896 = G__28042;
i__27897 = G__28043;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq.call(null,seq__27894);
if(temp__5753__auto____$1){
var seq__27894__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27894__$1)){
var c__4649__auto__ = cljs.core.chunk_first.call(null,seq__27894__$1);
var G__28044 = cljs.core.chunk_rest.call(null,seq__27894__$1);
var G__28045 = c__4649__auto__;
var G__28046 = cljs.core.count.call(null,c__4649__auto__);
var G__28047 = (0);
seq__27894 = G__28044;
chunk__27895 = G__28045;
count__27896 = G__28046;
i__27897 = G__28047;
continue;
} else {
var tid = cljs.core.first.call(null,seq__27894__$1);
var temp__5753__auto___28048__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5753__auto___28048__$2)){
var keyed_callbacks_28049 = temp__5753__auto___28048__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_28050 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__27958_28051 = cljs.core.seq.call(null,keyed_callbacks_28049);
var chunk__27959_28052 = null;
var count__27960_28053 = (0);
var i__27961_28054 = (0);
while(true){
if((i__27961_28054 < count__27960_28053)){
var vec__27970_28055 = cljs.core._nth.call(null,chunk__27959_28052,i__27961_28054);
var k_28056 = cljs.core.nth.call(null,vec__27970_28055,(0),null);
var f_28057 = cljs.core.nth.call(null,vec__27970_28055,(1),null);
try{f_28057.call(null,tx_response_28050);
}catch (e27973){var e_28058 = e27973;
fluree.db.util.log.error.call(null,e_28058,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__28059 = seq__27958_28051;
var G__28060 = chunk__27959_28052;
var G__28061 = count__27960_28053;
var G__28062 = (i__27961_28054 + (1));
seq__27958_28051 = G__28059;
chunk__27959_28052 = G__28060;
count__27960_28053 = G__28061;
i__27961_28054 = G__28062;
continue;
} else {
var temp__5753__auto___28063__$3 = cljs.core.seq.call(null,seq__27958_28051);
if(temp__5753__auto___28063__$3){
var seq__27958_28064__$1 = temp__5753__auto___28063__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__27958_28064__$1)){
var c__4649__auto___28065 = cljs.core.chunk_first.call(null,seq__27958_28064__$1);
var G__28066 = cljs.core.chunk_rest.call(null,seq__27958_28064__$1);
var G__28067 = c__4649__auto___28065;
var G__28068 = cljs.core.count.call(null,c__4649__auto___28065);
var G__28069 = (0);
seq__27958_28051 = G__28066;
chunk__27959_28052 = G__28067;
count__27960_28053 = G__28068;
i__27961_28054 = G__28069;
continue;
} else {
var vec__27974_28070 = cljs.core.first.call(null,seq__27958_28064__$1);
var k_28071 = cljs.core.nth.call(null,vec__27974_28070,(0),null);
var f_28072 = cljs.core.nth.call(null,vec__27974_28070,(1),null);
try{f_28072.call(null,tx_response_28050);
}catch (e27977){var e_28073 = e27977;
fluree.db.util.log.error.call(null,e_28073,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__28074 = cljs.core.next.call(null,seq__27958_28064__$1);
var G__28075 = null;
var G__28076 = (0);
var G__28077 = (0);
seq__27958_28051 = G__28074;
chunk__27959_28052 = G__28075;
count__27960_28053 = G__28076;
i__27961_28054 = G__28077;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28078 = cljs.core.next.call(null,seq__27894__$1);
var G__28079 = null;
var G__28080 = (0);
var G__28081 = (0);
seq__27894 = G__28078;
chunk__27895 = G__28079;
count__27896 = G__28080;
i__27897 = G__28081;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28082 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2748__auto___28083 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_27994){
var state_val_27995 = (state_27994[(1)]);
if((state_val_27995 === (1))){
var state_27994__$1 = state_27994;
var statearr_27996_28084 = state_27994__$1;
(statearr_27996_28084[(2)] = null);

(statearr_27996_28084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (2))){
var inst_27979 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_27994__$1 = state_27994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27994__$1,(4),inst_27979);
} else {
if((state_val_27995 === (3))){
var inst_27992 = (state_27994[(2)]);
var state_27994__$1 = state_27994;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27994__$1,inst_27992);
} else {
if((state_val_27995 === (4))){
var inst_27981 = (state_27994[(7)]);
var inst_27981__$1 = (state_27994[(2)]);
var inst_27982 = (inst_27981__$1 == null);
var state_27994__$1 = (function (){var statearr_27997 = state_27994;
(statearr_27997[(7)] = inst_27981__$1);

return statearr_27997;
})();
if(cljs.core.truth_(inst_27982)){
var statearr_27998_28085 = state_27994__$1;
(statearr_27998_28085[(1)] = (5));

} else {
var statearr_27999_28086 = state_27994__$1;
(statearr_27999_28086[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (5))){
var inst_27984 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_27985 = fluree.db.util.log.info.call(null,inst_27984);
var state_27994__$1 = state_27994;
var statearr_28000_28087 = state_27994__$1;
(statearr_28000_28087[(2)] = inst_27985);

(statearr_28000_28087[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (6))){
var inst_27981 = (state_27994[(7)]);
var inst_27987 = transact_handler_28082.call(null,conn,inst_27981);
var state_27994__$1 = (function (){var statearr_28001 = state_27994;
(statearr_28001[(8)] = inst_27987);

return statearr_28001;
})();
var statearr_28002_28088 = state_27994__$1;
(statearr_28002_28088[(2)] = null);

(statearr_28002_28088[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27995 === (7))){
var inst_27990 = (state_27994[(2)]);
var state_27994__$1 = state_27994;
var statearr_28003_28089 = state_27994__$1;
(statearr_28003_28089[(2)] = inst_27990);

(statearr_28003_28089[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2726__auto__ = null;
var fluree$db$session$state_machine__2726__auto____0 = (function (){
var statearr_28004 = [null,null,null,null,null,null,null,null,null];
(statearr_28004[(0)] = fluree$db$session$state_machine__2726__auto__);

(statearr_28004[(1)] = (1));

return statearr_28004;
});
var fluree$db$session$state_machine__2726__auto____1 = (function (state_27994){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_27994);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e28005){var ex__2729__auto__ = e28005;
var statearr_28006_28090 = state_27994;
(statearr_28006_28090[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_27994[(4)]))){
var statearr_28007_28091 = state_27994;
(statearr_28007_28091[(1)] = cljs.core.first.call(null,(state_27994[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28092 = state_27994;
state_27994 = G__28092;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$session$state_machine__2726__auto__ = function(state_27994){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2726__auto____1.call(this,state_27994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2726__auto____0;
fluree$db$session$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2726__auto____1;
return fluree$db$session$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_28008 = f__2749__auto__.call(null);
(statearr_28008[(6)] = c__2748__auto___28083);

return statearr_28008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28093_SHARP_){
return cljs.core.assoc.call(null,p1__28093_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__28093_SHARP_) + (1)));
}));

var db = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28094_SHARP_){
return cljs.core.assoc.call(null,p1__28094_SHARP_,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
}));

return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28097 = arguments.length;
switch (G__28097) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28098 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__28095_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__28095_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28098);
} else {
return G__28098;
}
})();
var seq__28099 = cljs.core.seq.call(null,sessions);
var chunk__28100 = null;
var count__28101 = (0);
var i__28102 = (0);
while(true){
if((i__28102 < count__28101)){
var session = cljs.core._nth.call(null,chunk__28100,i__28102);
fluree.db.session.close.call(null,session);


var G__28104 = seq__28099;
var G__28105 = chunk__28100;
var G__28106 = count__28101;
var G__28107 = (i__28102 + (1));
seq__28099 = G__28104;
chunk__28100 = G__28105;
count__28101 = G__28106;
i__28102 = G__28107;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__28099);
if(temp__5753__auto__){
var seq__28099__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28099__$1)){
var c__4649__auto__ = cljs.core.chunk_first.call(null,seq__28099__$1);
var G__28108 = cljs.core.chunk_rest.call(null,seq__28099__$1);
var G__28109 = c__4649__auto__;
var G__28110 = cljs.core.count.call(null,c__4649__auto__);
var G__28111 = (0);
seq__28099 = G__28108;
chunk__28100 = G__28109;
count__28101 = G__28110;
i__28102 = G__28111;
continue;
} else {
var session = cljs.core.first.call(null,seq__28099__$1);
fluree.db.session.close.call(null,session);


var G__28112 = cljs.core.next.call(null,seq__28099__$1);
var G__28113 = null;
var G__28114 = (0);
var G__28115 = (0);
seq__28099 = G__28112;
chunk__28100 = G__28113;
count__28101 = G__28114;
i__28102 = G__28115;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
