// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_19022){
var state_val_19023 = (state_19022[(1)]);
if((state_val_19023 === (1))){
var state_19022__$1 = state_19022;
var statearr_19024_19038 = state_19022__$1;
(statearr_19024_19038[(2)] = null);

(statearr_19024_19038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19023 === (2))){
var _ = (function (){var statearr_19025 = state_19022;
(statearr_19025[(4)] = cljs.core.cons.call(null,(5),(state_19022[(4)])));

return statearr_19025;
})();
var inst_19013 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_19022__$1 = state_19022;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19022__$1,(6),inst_19013);
} else {
if((state_val_19023 === (3))){
var inst_19020 = (state_19022[(2)]);
var state_19022__$1 = state_19022;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19022__$1,inst_19020);
} else {
if((state_val_19023 === (4))){
var inst_19007 = (state_19022[(2)]);
var state_19022__$1 = state_19022;
var statearr_19027_19039 = state_19022__$1;
(statearr_19027_19039[(2)] = inst_19007);

(statearr_19027_19039[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19023 === (5))){
var _ = (function (){var statearr_19028 = state_19022;
(statearr_19028[(4)] = cljs.core.rest.call(null,(state_19022[(4)])));

return statearr_19028;
})();
var state_19022__$1 = state_19022;
var ex19026 = (state_19022__$1[(2)]);
var statearr_19029_19040 = state_19022__$1;
(statearr_19029_19040[(5)] = ex19026);


if((ex19026 instanceof Error)){
var statearr_19030_19041 = state_19022__$1;
(statearr_19030_19041[(1)] = (4));

(statearr_19030_19041[(5)] = null);

} else {
throw ex19026;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19023 === (6))){
var inst_19015 = (state_19022[(2)]);
var inst_19016 = fluree.db.util.async.throw_err.call(null,inst_19015);
var inst_19017 = cljs.core.keyword.call(null,inst_19016);
var _ = (function (){var statearr_19031 = state_19022;
(statearr_19031[(4)] = cljs.core.rest.call(null,(state_19022[(4)])));

return statearr_19031;
})();
var state_19022__$1 = state_19022;
var statearr_19032_19042 = state_19022__$1;
(statearr_19032_19042[(2)] = inst_19017);

(statearr_19032_19042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2726__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2726__auto____0 = (function (){
var statearr_19033 = [null,null,null,null,null,null,null];
(statearr_19033[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2726__auto__);

(statearr_19033[(1)] = (1));

return statearr_19033;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2726__auto____1 = (function (state_19022){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_19022);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e19034){var ex__2729__auto__ = e19034;
var statearr_19035_19043 = state_19022;
(statearr_19035_19043[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_19022[(4)]))){
var statearr_19036_19044 = state_19022;
(statearr_19036_19044[(1)] = cljs.core.first.call(null,(state_19022[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19045 = state_19022;
state_19022 = G__19045;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2726__auto__ = function(state_19022){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2726__auto____1.call(this,state_19022);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2726__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2726__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_19037 = f__2749__auto__.call(null);
(statearr_19037[(6)] = c__2748__auto__);

return statearr_19037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_19077){
var state_val_19078 = (state_19077[(1)]);
if((state_val_19078 === (7))){
var inst_19061 = (state_19077[(7)]);
var inst_19063 = cljs.core.empty_QMARK_.call(null,inst_19061);
var inst_19064 = (!(inst_19063));
var state_19077__$1 = state_19077;
var statearr_19079_19103 = state_19077__$1;
(statearr_19079_19103[(2)] = inst_19064);

(statearr_19079_19103[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19078 === (1))){
var state_19077__$1 = state_19077;
var statearr_19080_19104 = state_19077__$1;
(statearr_19080_19104[(2)] = null);

(statearr_19080_19104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19078 === (4))){
var inst_19047 = (state_19077[(2)]);
var state_19077__$1 = state_19077;
var statearr_19081_19105 = state_19077__$1;
(statearr_19081_19105[(2)] = inst_19047);

(statearr_19081_19105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19078 === (6))){
var inst_19053 = (state_19077[(8)]);
var inst_19061 = (state_19077[(7)]);
var inst_19059 = (state_19077[(2)]);
var inst_19060 = fluree.db.util.async.throw_err.call(null,inst_19059);
var inst_19061__$1 = cljs.core.map.call(null,inst_19053,inst_19060);
var state_19077__$1 = (function (){var statearr_19082 = state_19077;
(statearr_19082[(7)] = inst_19061__$1);

return statearr_19082;
})();
if(cljs.core.truth_(inst_19061__$1)){
var statearr_19083_19106 = state_19077__$1;
(statearr_19083_19106[(1)] = (7));

} else {
var statearr_19084_19107 = state_19077__$1;
(statearr_19084_19107[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19078 === (3))){
var inst_19075 = (state_19077[(2)]);
var state_19077__$1 = state_19077;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19077__$1,inst_19075);
} else {
if((state_val_19078 === (12))){
var inst_19072 = (state_19077[(2)]);
var _ = (function (){var statearr_19085 = state_19077;
(statearr_19085[(4)] = cljs.core.rest.call(null,(state_19077[(4)])));

return statearr_19085;
})();
var state_19077__$1 = state_19077;
var statearr_19086_19108 = state_19077__$1;
(statearr_19086_19108[(2)] = inst_19072);

(statearr_19086_19108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19078 === (2))){
var _ = (function (){var statearr_19087 = state_19077;
(statearr_19087[(4)] = cljs.core.cons.call(null,(5),(state_19077[(4)])));

return statearr_19087;
})();
var inst_19053 = (function (){return (function (p1__19046_SHARP_){
return p1__19046_SHARP_.o;
});
})();
var inst_19054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19055 = [pred_id];
var inst_19056 = (new cljs.core.PersistentVector(null,1,(5),inst_19054,inst_19055,null));
var inst_19057 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_19056);
var state_19077__$1 = (function (){var statearr_19088 = state_19077;
(statearr_19088[(8)] = inst_19053);

return statearr_19088;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19077__$1,(6),inst_19057);
} else {
if((state_val_19078 === (11))){
var state_19077__$1 = state_19077;
var statearr_19090_19109 = state_19077__$1;
(statearr_19090_19109[(2)] = true);

(statearr_19090_19109[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19078 === (9))){
var inst_19067 = (state_19077[(2)]);
var state_19077__$1 = state_19077;
if(cljs.core.truth_(inst_19067)){
var statearr_19091_19110 = state_19077__$1;
(statearr_19091_19110[(1)] = (10));

} else {
var statearr_19092_19111 = state_19077__$1;
(statearr_19092_19111[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19078 === (5))){
var _ = (function (){var statearr_19093 = state_19077;
(statearr_19093[(4)] = cljs.core.rest.call(null,(state_19077[(4)])));

return statearr_19093;
})();
var state_19077__$1 = state_19077;
var ex19089 = (state_19077__$1[(2)]);
var statearr_19094_19112 = state_19077__$1;
(statearr_19094_19112[(5)] = ex19089);


if((ex19089 instanceof Error)){
var statearr_19095_19113 = state_19077__$1;
(statearr_19095_19113[(1)] = (4));

(statearr_19095_19113[(5)] = null);

} else {
throw ex19089;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19078 === (10))){
var inst_19061 = (state_19077[(7)]);
var inst_19069 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_19061);
var state_19077__$1 = state_19077;
var statearr_19096_19114 = state_19077__$1;
(statearr_19096_19114[(2)] = inst_19069);

(statearr_19096_19114[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19078 === (8))){
var inst_19061 = (state_19077[(7)]);
var state_19077__$1 = state_19077;
var statearr_19097_19115 = state_19077__$1;
(statearr_19097_19115[(2)] = inst_19061);

(statearr_19097_19115[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2726__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2726__auto____0 = (function (){
var statearr_19098 = [null,null,null,null,null,null,null,null,null];
(statearr_19098[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2726__auto__);

(statearr_19098[(1)] = (1));

return statearr_19098;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2726__auto____1 = (function (state_19077){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_19077);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e19099){var ex__2729__auto__ = e19099;
var statearr_19100_19116 = state_19077;
(statearr_19100_19116[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_19077[(4)]))){
var statearr_19101_19117 = state_19077;
(statearr_19101_19117[(1)] = cljs.core.first.call(null,(state_19077[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19118 = state_19077;
state_19077 = G__19118;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2726__auto__ = function(state_19077){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2726__auto____1.call(this,state_19077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2726__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2726__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_19102 = f__2749__auto__.call(null);
(statearr_19102[(6)] = c__2748__auto__);

return statearr_19102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_19199){
var state_val_19200 = (state_19199[(1)]);
if((state_val_19200 === (7))){
var state_19199__$1 = state_19199;
var statearr_19201_19238 = state_19199__$1;
(statearr_19201_19238[(2)] = flakes);

(statearr_19201_19238[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (20))){
var inst_19156 = (state_19199[(7)]);
var inst_19189 = (state_19199[(2)]);
var inst_19148 = inst_19156;
var inst_19149 = inst_19189;
var state_19199__$1 = (function (){var statearr_19202 = state_19199;
(statearr_19202[(8)] = inst_19148);

(statearr_19202[(9)] = inst_19149);

return statearr_19202;
})();
var statearr_19203_19239 = state_19199__$1;
(statearr_19203_19239[(2)] = null);

(statearr_19203_19239[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (1))){
var state_19199__$1 = state_19199;
var statearr_19204_19240 = state_19199__$1;
(statearr_19204_19240[(2)] = null);

(statearr_19204_19240[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (4))){
var inst_19121 = (state_19199[(2)]);
var state_19199__$1 = state_19199;
var statearr_19205_19241 = state_19199__$1;
(statearr_19205_19241[(2)] = inst_19121);

(statearr_19205_19241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (15))){
var inst_19155 = (state_19199[(10)]);
var inst_19173 = inst_19155.o;
var state_19199__$1 = state_19199;
var statearr_19206_19242 = state_19199__$1;
(statearr_19206_19242[(2)] = inst_19173);

(statearr_19206_19242[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (13))){
var inst_19192 = (state_19199[(2)]);
var state_19199__$1 = state_19199;
var statearr_19207_19243 = state_19199__$1;
(statearr_19207_19243[(2)] = inst_19192);

(statearr_19207_19243[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (6))){
var inst_19128 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_19199__$1 = state_19199;
var statearr_19208_19244 = state_19199__$1;
(statearr_19208_19244[(2)] = inst_19128);

(statearr_19208_19244[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (17))){
var inst_19170 = (state_19199[(2)]);
var inst_19171 = fluree.db.util.async.throw_err.call(null,inst_19170);
var state_19199__$1 = state_19199;
var statearr_19209_19245 = state_19199__$1;
(statearr_19209_19245[(2)] = inst_19171);

(statearr_19209_19245[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (3))){
var inst_19197 = (state_19199[(2)]);
var state_19199__$1 = state_19199;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19199__$1,inst_19197);
} else {
if((state_val_19200 === (12))){
var inst_19162 = (state_19199[(11)]);
var inst_19155 = (state_19199[(10)]);
var inst_19160 = inst_19155.p;
var inst_19161 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_19160);
var inst_19162__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_19161);
var inst_19163 = inst_19155.op;
var inst_19164 = inst_19163 === false;
var inst_19165 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_19162__$1);
var state_19199__$1 = (function (){var statearr_19210 = state_19199;
(statearr_19210[(11)] = inst_19162__$1);

(statearr_19210[(12)] = inst_19164);

return statearr_19210;
})();
if(inst_19165){
var statearr_19211_19246 = state_19199__$1;
(statearr_19211_19246[(1)] = (14));

} else {
var statearr_19212_19247 = state_19199__$1;
(statearr_19212_19247[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (2))){
var _ = (function (){var statearr_19213 = state_19199;
(statearr_19213[(4)] = cljs.core.cons.call(null,(5),(state_19199[(4)])));

return statearr_19213;
})();
var state_19199__$1 = state_19199;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_19214_19248 = state_19199__$1;
(statearr_19214_19248[(1)] = (6));

} else {
var statearr_19215_19249 = state_19199__$1;
(statearr_19215_19249[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (19))){
var inst_19162 = (state_19199[(11)]);
var inst_19175 = (state_19199[(13)]);
var inst_19155 = (state_19199[(10)]);
var inst_19149 = (state_19199[(9)]);
var inst_19183 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19184 = inst_19155.s;
var inst_19185 = [inst_19184,inst_19162,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_19186 = (new cljs.core.PersistentVector(null,3,(5),inst_19183,inst_19185,null));
var inst_19187 = cljs.core.assoc_in.call(null,inst_19149,inst_19186,inst_19175);
var state_19199__$1 = state_19199;
var statearr_19216_19250 = state_19199__$1;
(statearr_19216_19250[(2)] = inst_19187);

(statearr_19216_19250[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (11))){
var inst_19149 = (state_19199[(9)]);
var state_19199__$1 = state_19199;
var statearr_19218_19251 = state_19199__$1;
(statearr_19218_19251[(2)] = inst_19149);

(statearr_19218_19251[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (9))){
var inst_19155 = (state_19199[(10)]);
var inst_19148 = (state_19199[(8)]);
var inst_19154 = cljs.core.seq.call(null,inst_19148);
var inst_19155__$1 = cljs.core.first.call(null,inst_19154);
var inst_19156 = cljs.core.next.call(null,inst_19154);
var inst_19157 = cljs.core.not.call(null,inst_19155__$1);
var state_19199__$1 = (function (){var statearr_19219 = state_19199;
(statearr_19219[(10)] = inst_19155__$1);

(statearr_19219[(7)] = inst_19156);

return statearr_19219;
})();
if(inst_19157){
var statearr_19220_19252 = state_19199__$1;
(statearr_19220_19252[(1)] = (11));

} else {
var statearr_19221_19253 = state_19199__$1;
(statearr_19221_19253[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (5))){
var _ = (function (){var statearr_19222 = state_19199;
(statearr_19222[(4)] = cljs.core.rest.call(null,(state_19199[(4)])));

return statearr_19222;
})();
var state_19199__$1 = state_19199;
var ex19217 = (state_19199__$1[(2)]);
var statearr_19223_19254 = state_19199__$1;
(statearr_19223_19254[(5)] = ex19217);


if((ex19217 instanceof Error)){
var statearr_19224_19255 = state_19199__$1;
(statearr_19224_19255[(1)] = (4));

(statearr_19224_19255[(5)] = null);

} else {
throw ex19217;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (14))){
var inst_19155 = (state_19199[(10)]);
var inst_19167 = inst_19155.o;
var inst_19168 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_19167,db);
var state_19199__$1 = state_19199;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19199__$1,(17),inst_19168);
} else {
if((state_val_19200 === (16))){
var inst_19164 = (state_19199[(12)]);
var inst_19175 = (state_19199[(2)]);
var state_19199__$1 = (function (){var statearr_19225 = state_19199;
(statearr_19225[(13)] = inst_19175);

return statearr_19225;
})();
if(cljs.core.truth_(inst_19164)){
var statearr_19226_19256 = state_19199__$1;
(statearr_19226_19256[(1)] = (18));

} else {
var statearr_19227_19257 = state_19199__$1;
(statearr_19227_19257[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (10))){
var inst_19194 = (state_19199[(2)]);
var _ = (function (){var statearr_19228 = state_19199;
(statearr_19228[(4)] = cljs.core.rest.call(null,(state_19199[(4)])));

return statearr_19228;
})();
var state_19199__$1 = state_19199;
var statearr_19229_19258 = state_19199__$1;
(statearr_19229_19258[(2)] = inst_19194);

(statearr_19229_19258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (18))){
var inst_19162 = (state_19199[(11)]);
var inst_19175 = (state_19199[(13)]);
var inst_19155 = (state_19199[(10)]);
var inst_19149 = (state_19199[(9)]);
var inst_19177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19178 = inst_19155.s;
var inst_19179 = [inst_19178,inst_19162,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_19180 = (new cljs.core.PersistentVector(null,3,(5),inst_19177,inst_19179,null));
var inst_19181 = cljs.core.assoc_in.call(null,inst_19149,inst_19180,inst_19175);
var state_19199__$1 = state_19199;
var statearr_19230_19259 = state_19199__$1;
(statearr_19230_19259[(2)] = inst_19181);

(statearr_19230_19259[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19200 === (8))){
var inst_19131 = (state_19199[(2)]);
var inst_19132 = cljs.core.PersistentHashSet.EMPTY;
var inst_19133 = cljs.core.vals.call(null,tempids);
var inst_19134 = cljs.core.into.call(null,inst_19132,inst_19133);
var inst_19135 = (function (){var pred_flakes = inst_19131;
var is_new_QMARK_ = inst_19134;
return (function (p1__19119_SHARP_,p2__19120_SHARP_){
return cljs.core.assoc_in.call(null,p1__19119_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__19120_SHARP_.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,p2__19120_SHARP_.s)));
});
})();
var inst_19136 = cljs.core.PersistentHashMap.EMPTY;
var inst_19137 = cljs.core.reduce.call(null,inst_19135,inst_19136,inst_19131);
var inst_19145 = cljs.core.seq.call(null,inst_19131);
var inst_19146 = cljs.core.first.call(null,inst_19145);
var inst_19147 = cljs.core.next.call(null,inst_19145);
var inst_19148 = inst_19131;
var inst_19149 = inst_19137;
var state_19199__$1 = (function (){var statearr_19231 = state_19199;
(statearr_19231[(14)] = inst_19146);

(statearr_19231[(8)] = inst_19148);

(statearr_19231[(9)] = inst_19149);

(statearr_19231[(15)] = inst_19147);

return statearr_19231;
})();
var statearr_19232_19260 = state_19199__$1;
(statearr_19232_19260[(2)] = null);

(statearr_19232_19260[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2726__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2726__auto____0 = (function (){
var statearr_19233 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19233[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2726__auto__);

(statearr_19233[(1)] = (1));

return statearr_19233;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2726__auto____1 = (function (state_19199){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_19199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e19234){var ex__2729__auto__ = e19234;
var statearr_19235_19261 = state_19199;
(statearr_19235_19261[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_19199[(4)]))){
var statearr_19236_19262 = state_19199;
(statearr_19236_19262[(1)] = cljs.core.first.call(null,(state_19199[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19263 = state_19199;
state_19199 = G__19263;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2726__auto__ = function(state_19199){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2726__auto____1.call(this,state_19199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2726__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2726__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_19237 = f__2749__auto__.call(null);
(statearr_19237[(6)] = c__2748__auto__);

return statearr_19237;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__19265 = arguments.length;
switch (G__19265) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__19268 = arguments.length;
switch (G__19268) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_19580){
var state_val_19581 = (state_19580[(1)]);
if((state_val_19581 === (121))){
var inst_19535 = (state_19580[(7)]);
var state_19580__$1 = state_19580;
var statearr_19582_19775 = state_19580__$1;
(statearr_19582_19775[(2)] = inst_19535);

(statearr_19582_19775[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (65))){
var inst_19434 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19434)){
var statearr_19583_19776 = state_19580__$1;
(statearr_19583_19776[(1)] = (66));

} else {
var statearr_19584_19777 = state_19580__$1;
(statearr_19584_19777[(1)] = (67));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (70))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19444 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_19445 = inst_19440.call(null,cljs.core.PersistentArrayMap,null,3,inst_19444,null);
var inst_19446 = inst_19440.call(null,cljs.core.PersistentHashSet,null,inst_19445,null);
var inst_19447 = inst_19446.call(null,inst_19439);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19447)){
var statearr_19585_19778 = state_19580__$1;
(statearr_19585_19778[(1)] = (72));

} else {
var statearr_19586_19779 = state_19580__$1;
(statearr_19586_19779[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (62))){
var inst_19424 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19587_19780 = state_19580__$1;
(statearr_19587_19780[(2)] = inst_19424);

(statearr_19587_19780[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (74))){
var inst_19530 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19588_19781 = state_19580__$1;
(statearr_19588_19781[(2)] = inst_19530);

(statearr_19588_19781[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (110))){
var inst_19557 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19557)){
var statearr_19589_19782 = state_19580__$1;
(statearr_19589_19782[(1)] = (117));

} else {
var statearr_19590_19783 = state_19580__$1;
(statearr_19590_19783[(1)] = (118));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (7))){
var inst_19575 = (state_19580[(2)]);
var _ = (function (){var statearr_19591 = state_19580;
(statearr_19591[(4)] = cljs.core.rest.call(null,(state_19580[(4)])));

return statearr_19591;
})();
var state_19580__$1 = state_19580;
var statearr_19592_19784 = state_19580__$1;
(statearr_19592_19784[(2)] = inst_19575);

(statearr_19592_19784[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (59))){
var inst_19428 = (state_19580[(10)]);
var inst_19308 = (state_19580[(11)]);
var inst_19427 = (state_19580[(2)]);
var inst_19428__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19308);
var state_19580__$1 = (function (){var statearr_19593 = state_19580;
(statearr_19593[(10)] = inst_19428__$1);

(statearr_19593[(12)] = inst_19427);

return statearr_19593;
})();
if(cljs.core.truth_(inst_19428__$1)){
var statearr_19594_19785 = state_19580__$1;
(statearr_19594_19785[(1)] = (63));

} else {
var statearr_19595_19786 = state_19580__$1;
(statearr_19595_19786[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (86))){
var inst_19470 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19596_19787 = state_19580__$1;
(statearr_19596_19787[(2)] = inst_19470);

(statearr_19596_19787[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (20))){
var inst_19334 = (state_19580[(13)]);
var inst_19308 = (state_19580[(11)]);
var inst_19334__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19308);
var state_19580__$1 = (function (){var statearr_19597 = state_19580;
(statearr_19597[(13)] = inst_19334__$1);

return statearr_19597;
})();
if(cljs.core.truth_(inst_19334__$1)){
var statearr_19598_19788 = state_19580__$1;
(statearr_19598_19788[(1)] = (23));

} else {
var statearr_19599_19789 = state_19580__$1;
(statearr_19599_19789[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (72))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19449 = fluree.db.query.schema.type_error.call(null,inst_19439,inst_19440,throw_QMARK_);
var state_19580__$1 = state_19580;
var statearr_19600_19790 = state_19580__$1;
(statearr_19600_19790[(2)] = inst_19449);

(statearr_19600_19790[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (58))){
var inst_19389 = (state_19580[(14)]);
var state_19580__$1 = state_19580;
var statearr_19601_19791 = state_19580__$1;
(statearr_19601_19791[(2)] = inst_19389);

(statearr_19601_19791[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (60))){
var inst_19296 = (state_19580[(15)]);
var inst_19307 = (state_19580[(16)]);
var inst_19415 = fluree.db.dbproto._p_prop.call(null,inst_19296,new cljs.core.Keyword(null,"name","name",1843675177),inst_19307);
var inst_19416 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_19415)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_19417 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19418 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_19419 = cljs.core.PersistentHashMap.fromArrays(inst_19417,inst_19418);
var inst_19420 = cljs.core.ex_info.call(null,inst_19416,inst_19419);
var inst_19421 = (function(){throw inst_19420})();
var state_19580__$1 = state_19580;
var statearr_19602_19792 = state_19580__$1;
(statearr_19602_19792[(2)] = inst_19421);

(statearr_19602_19792[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (27))){
var inst_19337 = (state_19580[(17)]);
var state_19580__$1 = state_19580;
var statearr_19603_19793 = state_19580__$1;
(statearr_19603_19793[(2)] = inst_19337);

(statearr_19603_19793[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (1))){
var state_19580__$1 = state_19580;
var statearr_19604_19794 = state_19580__$1;
(statearr_19604_19794[(2)] = null);

(statearr_19604_19794[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (69))){
var inst_19427 = (state_19580[(12)]);
var state_19580__$1 = state_19580;
var statearr_19605_19795 = state_19580__$1;
(statearr_19605_19795[(2)] = inst_19427);

(statearr_19605_19795[(1)] = (71));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (101))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19508 = fluree.db.query.schema.type_error.call(null,inst_19439,inst_19440,throw_QMARK_);
var state_19580__$1 = state_19580;
var statearr_19606_19796 = state_19580__$1;
(statearr_19606_19796[(2)] = inst_19508);

(statearr_19606_19796[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (24))){
var inst_19334 = (state_19580[(13)]);
var state_19580__$1 = state_19580;
var statearr_19607_19797 = state_19580__$1;
(statearr_19607_19797[(2)] = inst_19334);

(statearr_19607_19797[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (102))){
var inst_19510 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19608_19798 = state_19580__$1;
(statearr_19608_19798[(2)] = inst_19510);

(statearr_19608_19798[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (55))){
var inst_19406 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19609_19799 = state_19580__$1;
(statearr_19609_19799[(2)] = inst_19406);

(statearr_19609_19799[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (85))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19468 = fluree.db.query.schema.type_error.call(null,inst_19439,inst_19440,throw_QMARK_);
var state_19580__$1 = state_19580;
var statearr_19610_19800 = state_19580__$1;
(statearr_19610_19800[(2)] = inst_19468);

(statearr_19610_19800[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (39))){
var inst_19371 = (state_19580[(18)]);
var state_19580__$1 = state_19580;
var statearr_19611_19801 = state_19580__$1;
(statearr_19611_19801[(2)] = inst_19371);

(statearr_19611_19801[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (88))){
var inst_19427 = (state_19580[(12)]);
var state_19580__$1 = state_19580;
var statearr_19612_19802 = state_19580__$1;
(statearr_19612_19802[(2)] = inst_19427);

(statearr_19612_19802[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (46))){
var inst_19308 = (state_19580[(11)]);
var inst_19390 = (state_19580[(19)]);
var inst_19389 = (state_19580[(2)]);
var inst_19390__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_19308);
var state_19580__$1 = (function (){var statearr_19613 = state_19580;
(statearr_19613[(14)] = inst_19389);

(statearr_19613[(19)] = inst_19390__$1);

return statearr_19613;
})();
if(cljs.core.truth_(inst_19390__$1)){
var statearr_19614_19803 = state_19580__$1;
(statearr_19614_19803[(1)] = (47));

} else {
var statearr_19615_19804 = state_19580__$1;
(statearr_19615_19804[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (4))){
var inst_19269 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19616_19805 = state_19580__$1;
(statearr_19616_19805[(2)] = inst_19269);

(statearr_19616_19805[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (77))){
var inst_19528 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19617_19806 = state_19580__$1;
(statearr_19617_19806[(2)] = inst_19528);

(statearr_19617_19806[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (106))){
var inst_19520 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19618_19807 = state_19580__$1;
(statearr_19618_19807[(2)] = inst_19520);

(statearr_19618_19807[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (119))){
var inst_19306 = (state_19580[(20)]);
var inst_19570 = (state_19580[(2)]);
var inst_19295 = inst_19306;
var inst_19296 = inst_19570;
var state_19580__$1 = (function (){var statearr_19619 = state_19580;
(statearr_19619[(21)] = inst_19295);

(statearr_19619[(15)] = inst_19296);

return statearr_19619;
})();
var statearr_19620_19808 = state_19580__$1;
(statearr_19620_19808[(2)] = null);

(statearr_19620_19808[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (95))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19492 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_19493 = inst_19440.call(null,cljs.core.PersistentArrayMap,null,5,inst_19492,null);
var inst_19494 = inst_19440.call(null,cljs.core.PersistentHashSet,null,inst_19493,null);
var inst_19495 = inst_19494.call(null,inst_19439);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19495)){
var statearr_19621_19809 = state_19580__$1;
(statearr_19621_19809[(1)] = (96));

} else {
var statearr_19622_19810 = state_19580__$1;
(statearr_19622_19810[(1)] = (97));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (54))){
var inst_19397 = (state_19580[(22)]);
var state_19580__$1 = state_19580;
var statearr_19623_19811 = state_19580__$1;
(statearr_19623_19811[(2)] = inst_19397);

(statearr_19623_19811[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (92))){
var inst_19427 = (state_19580[(12)]);
var state_19580__$1 = state_19580;
var statearr_19624_19812 = state_19580__$1;
(statearr_19624_19812[(2)] = inst_19427);

(statearr_19624_19812[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (104))){
var inst_19427 = (state_19580[(12)]);
var state_19580__$1 = state_19580;
var statearr_19625_19813 = state_19580__$1;
(statearr_19625_19813[(2)] = inst_19427);

(statearr_19625_19813[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (15))){
var inst_19316 = (state_19580[(23)]);
var state_19580__$1 = state_19580;
var statearr_19626_19814 = state_19580__$1;
(statearr_19626_19814[(2)] = inst_19316);

(statearr_19626_19814[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (48))){
var inst_19390 = (state_19580[(19)]);
var state_19580__$1 = state_19580;
var statearr_19627_19815 = state_19580__$1;
(statearr_19627_19815[(2)] = inst_19390);

(statearr_19627_19815[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (50))){
var inst_19397 = (state_19580[(22)]);
var inst_19308 = (state_19580[(11)]);
var inst_19395 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19396 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19395);
var inst_19397__$1 = inst_19396 === true;
var state_19580__$1 = (function (){var statearr_19628 = state_19580;
(statearr_19628[(22)] = inst_19397__$1);

return statearr_19628;
})();
if(cljs.core.truth_(inst_19397__$1)){
var statearr_19629_19816 = state_19580__$1;
(statearr_19629_19816[(1)] = (53));

} else {
var statearr_19630_19817 = state_19580__$1;
(statearr_19630_19817[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (116))){
var inst_19551 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19631_19818 = state_19580__$1;
(statearr_19631_19818[(2)] = inst_19551);

(statearr_19631_19818[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (75))){
var inst_19440 = (state_19580[(8)]);
var state_19580__$1 = state_19580;
var G__19632_19819 = inst_19440;
var G__19632_19820__$1 = (((G__19632_19819 instanceof cljs.core.Keyword))?G__19632_19819.fqn:null);
switch (G__19632_19820__$1) {
case "long":
var statearr_19633_19822 = state_19580__$1;
(statearr_19633_19822[(1)] = (79));


break;
case "bigint":
var statearr_19634_19823 = state_19580__$1;
(statearr_19634_19823[(1)] = (83));


break;
case "double":
var statearr_19635_19824 = state_19580__$1;
(statearr_19635_19824[(1)] = (87));


break;
case "float":
var statearr_19636_19825 = state_19580__$1;
(statearr_19636_19825[(1)] = (91));


break;
case "bigdec":
var statearr_19637_19826 = state_19580__$1;
(statearr_19637_19826[(1)] = (95));


break;
case "string":
var statearr_19638_19827 = state_19580__$1;
(statearr_19638_19827[(1)] = (99));


break;
case "instant":
var statearr_19639_19828 = state_19580__$1;
(statearr_19639_19828[(1)] = (103));


break;
default:
var statearr_19640_19829 = state_19580__$1;
(statearr_19640_19829[(1)] = (107));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (99))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19502 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_19503 = inst_19440.call(null,cljs.core.PersistentArrayMap,null,5,inst_19502,null);
var inst_19504 = inst_19440.call(null,cljs.core.PersistentHashSet,null,inst_19503,null);
var inst_19505 = inst_19504.call(null,inst_19439);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19505)){
var statearr_19641_19830 = state_19580__$1;
(statearr_19641_19830[(1)] = (100));

} else {
var statearr_19642_19831 = state_19580__$1;
(statearr_19642_19831[(1)] = (101));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (21))){
var inst_19332 = (state_19580[(24)]);
var state_19580__$1 = state_19580;
var statearr_19643_19832 = state_19580__$1;
(statearr_19643_19832[(2)] = inst_19332);

(statearr_19643_19832[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (31))){
var inst_19348 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19644_19833 = state_19580__$1;
(statearr_19644_19833[(2)] = inst_19348);

(statearr_19644_19833[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (113))){
var inst_19554 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19645_19834 = state_19580__$1;
(statearr_19645_19834[(2)] = inst_19554);

(statearr_19645_19834[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (32))){
var state_19580__$1 = state_19580;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_19646_19835 = state_19580__$1;
(statearr_19646_19835[(1)] = (35));

} else {
var statearr_19647_19836 = state_19580__$1;
(statearr_19647_19836[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (40))){
var inst_19384 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19384)){
var statearr_19648_19837 = state_19580__$1;
(statearr_19648_19837[(1)] = (44));

} else {
var statearr_19649_19838 = state_19580__$1;
(statearr_19649_19838[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (91))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19482 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_19483 = inst_19440.call(null,cljs.core.PersistentArrayMap,null,3,inst_19482,null);
var inst_19484 = inst_19440.call(null,cljs.core.PersistentHashSet,null,inst_19483,null);
var inst_19485 = inst_19484.call(null,inst_19439);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19485)){
var statearr_19650_19839 = state_19580__$1;
(statearr_19650_19839[(1)] = (92));

} else {
var statearr_19651_19840 = state_19580__$1;
(statearr_19651_19840[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (117))){
var state_19580__$1 = state_19580;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_19652_19841 = state_19580__$1;
(statearr_19652_19841[(1)] = (120));

} else {
var statearr_19653_19842 = state_19580__$1;
(statearr_19653_19842[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (108))){
var inst_19539 = (state_19580[(25)]);
var inst_19308 = (state_19580[(11)]);
var inst_19539__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_19308);
var state_19580__$1 = (function (){var statearr_19654 = state_19580;
(statearr_19654[(25)] = inst_19539__$1);

return statearr_19654;
})();
if(cljs.core.truth_(inst_19539__$1)){
var statearr_19655_19843 = state_19580__$1;
(statearr_19655_19843[(1)] = (111));

} else {
var statearr_19656_19844 = state_19580__$1;
(statearr_19656_19844[(1)] = (112));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (56))){
var inst_19401 = (state_19580[(2)]);
var inst_19402 = fluree.db.util.async.throw_err.call(null,inst_19401);
var inst_19403 = cljs.core.not.call(null,inst_19402);
var state_19580__$1 = state_19580;
var statearr_19657_19845 = state_19580__$1;
(statearr_19657_19845[(2)] = inst_19403);

(statearr_19657_19845[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (33))){
var inst_19331 = (state_19580[(26)]);
var state_19580__$1 = state_19580;
var statearr_19658_19846 = state_19580__$1;
(statearr_19658_19846[(2)] = inst_19331);

(statearr_19658_19846[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (13))){
var inst_19326 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19326)){
var statearr_19659_19847 = state_19580__$1;
(statearr_19659_19847[(1)] = (17));

} else {
var statearr_19660_19848 = state_19580__$1;
(statearr_19660_19848[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (22))){
var inst_19357 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19357)){
var statearr_19661_19849 = state_19580__$1;
(statearr_19661_19849[(1)] = (32));

} else {
var statearr_19662_19850 = state_19580__$1;
(statearr_19662_19850[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (90))){
var inst_19480 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19663_19851 = state_19580__$1;
(statearr_19663_19851[(2)] = inst_19480);

(statearr_19663_19851[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (109))){
var inst_19537 = (state_19580[(27)]);
var state_19580__$1 = state_19580;
var statearr_19664_19852 = state_19580__$1;
(statearr_19664_19852[(2)] = inst_19537);

(statearr_19664_19852[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (36))){
var inst_19331 = (state_19580[(26)]);
var state_19580__$1 = state_19580;
var statearr_19665_19853 = state_19580__$1;
(statearr_19665_19853[(2)] = inst_19331);

(statearr_19665_19853[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (41))){
var inst_19308 = (state_19580[(11)]);
var inst_19376 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19377 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19376);
var inst_19378 = inst_19377 === true;
var state_19580__$1 = state_19580;
var statearr_19666_19854 = state_19580__$1;
(statearr_19666_19854[(2)] = inst_19378);

(statearr_19666_19854[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (118))){
var inst_19535 = (state_19580[(7)]);
var state_19580__$1 = state_19580;
var statearr_19667_19855 = state_19580__$1;
(statearr_19667_19855[(2)] = inst_19535);

(statearr_19667_19855[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (89))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19478 = fluree.db.query.schema.type_error.call(null,inst_19439,inst_19440,throw_QMARK_);
var state_19580__$1 = state_19580;
var statearr_19668_19856 = state_19580__$1;
(statearr_19668_19856[(2)] = inst_19478);

(statearr_19668_19856[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (100))){
var inst_19427 = (state_19580[(12)]);
var state_19580__$1 = state_19580;
var statearr_19669_19857 = state_19580__$1;
(statearr_19669_19857[(2)] = inst_19427);

(statearr_19669_19857[(1)] = (102));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (122))){
var inst_19567 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19670_19858 = state_19580__$1;
(statearr_19670_19858[(2)] = inst_19567);

(statearr_19670_19858[(1)] = (119));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (43))){
var inst_19381 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19671_19859 = state_19580__$1;
(statearr_19671_19859[(2)] = inst_19381);

(statearr_19671_19859[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (61))){
var inst_19389 = (state_19580[(14)]);
var state_19580__$1 = state_19580;
var statearr_19672_19860 = state_19580__$1;
(statearr_19672_19860[(2)] = inst_19389);

(statearr_19672_19860[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (29))){
var inst_19308 = (state_19580[(11)]);
var inst_19343 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19344 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19343);
var inst_19345 = inst_19344 === true;
var state_19580__$1 = state_19580;
var statearr_19673_19861 = state_19580__$1;
(statearr_19673_19861[(2)] = inst_19345);

(statearr_19673_19861[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (44))){
var inst_19370 = (state_19580[(28)]);
var inst_19386 = fluree.db.query.schema.type_error.call(null,inst_19370,"a component","a non-component",throw_QMARK_);
var state_19580__$1 = state_19580;
var statearr_19674_19862 = state_19580__$1;
(statearr_19674_19862[(2)] = inst_19386);

(statearr_19674_19862[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (93))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19488 = fluree.db.query.schema.type_error.call(null,inst_19439,inst_19440,throw_QMARK_);
var state_19580__$1 = state_19580;
var statearr_19675_19863 = state_19580__$1;
(statearr_19675_19863[(2)] = inst_19488);

(statearr_19675_19863[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (6))){
var inst_19295 = (state_19580[(21)]);
var inst_19307 = (state_19580[(16)]);
var inst_19304 = cljs.core.seq.call(null,inst_19295);
var inst_19305 = cljs.core.first.call(null,inst_19304);
var inst_19306 = cljs.core.next.call(null,inst_19304);
var inst_19307__$1 = cljs.core.nth.call(null,inst_19305,(0),null);
var inst_19308 = cljs.core.nth.call(null,inst_19305,(1),null);
var inst_19309 = cljs.core.not.call(null,inst_19307__$1);
var state_19580__$1 = (function (){var statearr_19676 = state_19580;
(statearr_19676[(16)] = inst_19307__$1);

(statearr_19676[(11)] = inst_19308);

(statearr_19676[(20)] = inst_19306);

return statearr_19676;
})();
if(inst_19309){
var statearr_19677_19864 = state_19580__$1;
(statearr_19677_19864[(1)] = (8));

} else {
var statearr_19678_19865 = state_19580__$1;
(statearr_19678_19865[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (111))){
var inst_19543 = (state_19580[(29)]);
var inst_19308 = (state_19580[(11)]);
var inst_19541 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19542 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19541);
var inst_19543__$1 = inst_19542 === true;
var state_19580__$1 = (function (){var statearr_19679 = state_19580;
(statearr_19679[(29)] = inst_19543__$1);

return statearr_19679;
})();
if(cljs.core.truth_(inst_19543__$1)){
var statearr_19680_19866 = state_19580__$1;
(statearr_19680_19866[(1)] = (114));

} else {
var statearr_19681_19867 = state_19580__$1;
(statearr_19681_19867[(1)] = (115));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (28))){
var inst_19351 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19682_19868 = state_19580__$1;
(statearr_19682_19868[(2)] = inst_19351);

(statearr_19682_19868[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (64))){
var inst_19428 = (state_19580[(10)]);
var state_19580__$1 = state_19580;
var statearr_19683_19869 = state_19580__$1;
(statearr_19683_19869[(2)] = inst_19428);

(statearr_19683_19869[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (103))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19512 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_19513 = inst_19440.call(null,cljs.core.PersistentArrayMap,null,2,inst_19512,null);
var inst_19514 = inst_19440.call(null,cljs.core.PersistentHashSet,null,inst_19513,null);
var inst_19515 = inst_19514.call(null,inst_19439);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19515)){
var statearr_19684_19870 = state_19580__$1;
(statearr_19684_19870[(1)] = (104));

} else {
var statearr_19685_19871 = state_19580__$1;
(statearr_19685_19871[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (51))){
var inst_19393 = (state_19580[(30)]);
var state_19580__$1 = state_19580;
var statearr_19686_19872 = state_19580__$1;
(statearr_19686_19872[(2)] = inst_19393);

(statearr_19686_19872[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (25))){
var inst_19354 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19687_19873 = state_19580__$1;
(statearr_19687_19873[(2)] = inst_19354);

(statearr_19687_19873[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (34))){
var inst_19371 = (state_19580[(18)]);
var inst_19308 = (state_19580[(11)]);
var inst_19370 = (state_19580[(2)]);
var inst_19371__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_19308);
var state_19580__$1 = (function (){var statearr_19688 = state_19580;
(statearr_19688[(18)] = inst_19371__$1);

(statearr_19688[(28)] = inst_19370);

return statearr_19688;
})();
if(cljs.core.truth_(inst_19371__$1)){
var statearr_19689_19874 = state_19580__$1;
(statearr_19689_19874[(1)] = (38));

} else {
var statearr_19690_19875 = state_19580__$1;
(statearr_19690_19875[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (17))){
var inst_19296 = (state_19580[(15)]);
var inst_19328 = fluree.db.query.schema.type_error.call(null,inst_19296,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_19580__$1 = state_19580;
var statearr_19691_19876 = state_19580__$1;
(statearr_19691_19876[(2)] = inst_19328);

(statearr_19691_19876[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (3))){
var inst_19578 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19580__$1,inst_19578);
} else {
if((state_val_19581 === (12))){
var inst_19312 = (state_19580[(31)]);
var state_19580__$1 = state_19580;
var statearr_19692_19877 = state_19580__$1;
(statearr_19692_19877[(2)] = inst_19312);

(statearr_19692_19877[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (2))){
var _ = (function (){var statearr_19693 = state_19580;
(statearr_19693[(4)] = cljs.core.cons.call(null,(5),(state_19580[(4)])));

return statearr_19693;
})();
var inst_19288 = pred_changes;
var inst_19289 = cljs.core.seq.call(null,inst_19288);
var inst_19290 = cljs.core.first.call(null,inst_19289);
var inst_19291 = cljs.core.next.call(null,inst_19289);
var inst_19292 = cljs.core.nth.call(null,inst_19290,(0),null);
var inst_19293 = cljs.core.nth.call(null,inst_19290,(1),null);
var inst_19294 = db;
var inst_19295 = inst_19288;
var inst_19296 = inst_19294;
var state_19580__$1 = (function (){var statearr_19694 = state_19580;
(statearr_19694[(21)] = inst_19295);

(statearr_19694[(15)] = inst_19296);

(statearr_19694[(32)] = inst_19292);

(statearr_19694[(33)] = inst_19293);

(statearr_19694[(34)] = inst_19291);

return statearr_19694;
})();
var statearr_19695_19878 = state_19580__$1;
(statearr_19695_19878[(2)] = null);

(statearr_19695_19878[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (66))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19308 = (state_19580[(11)]);
var inst_19437 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19438 = cljs.core.__destructure_map.call(null,inst_19437);
var inst_19439__$1 = cljs.core.get.call(null,inst_19438,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_19440__$1 = cljs.core.get.call(null,inst_19438,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_19441 = cljs.core._EQ_.call(null,inst_19440__$1,inst_19439__$1);
var state_19580__$1 = (function (){var statearr_19696 = state_19580;
(statearr_19696[(8)] = inst_19440__$1);

(statearr_19696[(9)] = inst_19439__$1);

return statearr_19696;
})();
if(inst_19441){
var statearr_19697_19879 = state_19580__$1;
(statearr_19697_19879[(1)] = (69));

} else {
var statearr_19698_19880 = state_19580__$1;
(statearr_19698_19880[(1)] = (70));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (107))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19522 = fluree.db.query.schema.type_error.call(null,inst_19439,inst_19440,throw_QMARK_);
var state_19580__$1 = state_19580;
var statearr_19699_19881 = state_19580__$1;
(statearr_19699_19881[(2)] = inst_19522);

(statearr_19699_19881[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (23))){
var inst_19308 = (state_19580[(11)]);
var inst_19337 = (state_19580[(17)]);
var inst_19336 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19337__$1 = inst_19336 === true;
var state_19580__$1 = (function (){var statearr_19700 = state_19580;
(statearr_19700[(17)] = inst_19337__$1);

return statearr_19700;
})();
if(cljs.core.truth_(inst_19337__$1)){
var statearr_19701_19882 = state_19580__$1;
(statearr_19701_19882[(1)] = (26));

} else {
var statearr_19702_19883 = state_19580__$1;
(statearr_19702_19883[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (47))){
var inst_19308 = (state_19580[(11)]);
var inst_19393 = (state_19580[(30)]);
var inst_19392 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19393__$1 = cljs.core.not.call(null,inst_19392);
var state_19580__$1 = (function (){var statearr_19703 = state_19580;
(statearr_19703[(30)] = inst_19393__$1);

return statearr_19703;
})();
if(inst_19393__$1){
var statearr_19704_19884 = state_19580__$1;
(statearr_19704_19884[(1)] = (50));

} else {
var statearr_19705_19885 = state_19580__$1;
(statearr_19705_19885[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (35))){
var inst_19360 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19361 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_19362 = cljs.core.PersistentHashMap.fromArrays(inst_19360,inst_19361);
var inst_19363 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_19362);
var inst_19364 = (function(){throw inst_19363})();
var state_19580__$1 = state_19580;
var statearr_19706_19886 = state_19580__$1;
(statearr_19706_19886[(2)] = inst_19364);

(statearr_19706_19886[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (82))){
var inst_19460 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19707_19887 = state_19580__$1;
(statearr_19707_19887[(2)] = inst_19460);

(statearr_19707_19887[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (76))){
var state_19580__$1 = state_19580;
var statearr_19708_19888 = state_19580__$1;
(statearr_19708_19888[(2)] = null);

(statearr_19708_19888[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (97))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19498 = fluree.db.query.schema.type_error.call(null,inst_19439,inst_19440,throw_QMARK_);
var state_19580__$1 = state_19580;
var statearr_19709_19889 = state_19580__$1;
(statearr_19709_19889[(2)] = inst_19498);

(statearr_19709_19889[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (19))){
var inst_19308 = (state_19580[(11)]);
var inst_19332 = (state_19580[(24)]);
var inst_19331 = (state_19580[(2)]);
var inst_19332__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_19308);
var state_19580__$1 = (function (){var statearr_19710 = state_19580;
(statearr_19710[(26)] = inst_19331);

(statearr_19710[(24)] = inst_19332__$1);

return statearr_19710;
})();
if(cljs.core.truth_(inst_19332__$1)){
var statearr_19711_19890 = state_19580__$1;
(statearr_19711_19890[(1)] = (20));

} else {
var statearr_19712_19891 = state_19580__$1;
(statearr_19712_19891[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (57))){
var state_19580__$1 = state_19580;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_19713_19892 = state_19580__$1;
(statearr_19713_19892[(1)] = (60));

} else {
var statearr_19714_19893 = state_19580__$1;
(statearr_19714_19893[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (68))){
var inst_19537 = (state_19580[(27)]);
var inst_19308 = (state_19580[(11)]);
var inst_19535 = (state_19580[(2)]);
var inst_19536 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19537__$1 = inst_19536 === true;
var state_19580__$1 = (function (){var statearr_19715 = state_19580;
(statearr_19715[(27)] = inst_19537__$1);

(statearr_19715[(7)] = inst_19535);

return statearr_19715;
})();
if(cljs.core.truth_(inst_19537__$1)){
var statearr_19716_19894 = state_19580__$1;
(statearr_19716_19894[(1)] = (108));

} else {
var statearr_19717_19895 = state_19580__$1;
(statearr_19717_19895[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (11))){
var inst_19316 = (state_19580[(23)]);
var inst_19308 = (state_19580[(11)]);
var inst_19314 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19315 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19314);
var inst_19316__$1 = inst_19315 === false;
var state_19580__$1 = (function (){var statearr_19718 = state_19580;
(statearr_19718[(23)] = inst_19316__$1);

return statearr_19718;
})();
if(cljs.core.truth_(inst_19316__$1)){
var statearr_19719_19896 = state_19580__$1;
(statearr_19719_19896[(1)] = (14));

} else {
var statearr_19720_19897 = state_19580__$1;
(statearr_19720_19897[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (115))){
var inst_19543 = (state_19580[(29)]);
var state_19580__$1 = state_19580;
var statearr_19722_19898 = state_19580__$1;
(statearr_19722_19898[(2)] = inst_19543);

(statearr_19722_19898[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (9))){
var inst_19308 = (state_19580[(11)]);
var inst_19312 = (state_19580[(31)]);
var inst_19312__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_19308);
var state_19580__$1 = (function (){var statearr_19723 = state_19580;
(statearr_19723[(31)] = inst_19312__$1);

return statearr_19723;
})();
if(cljs.core.truth_(inst_19312__$1)){
var statearr_19724_19899 = state_19580__$1;
(statearr_19724_19899[(1)] = (11));

} else {
var statearr_19725_19900 = state_19580__$1;
(statearr_19725_19900[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (5))){
var _ = (function (){var statearr_19726 = state_19580;
(statearr_19726[(4)] = cljs.core.rest.call(null,(state_19580[(4)])));

return statearr_19726;
})();
var state_19580__$1 = state_19580;
var ex19721 = (state_19580__$1[(2)]);
var statearr_19727_19901 = state_19580__$1;
(statearr_19727_19901[(5)] = ex19721);


if((ex19721 instanceof Error)){
var statearr_19728_19902 = state_19580__$1;
(statearr_19728_19902[(1)] = (4));

(statearr_19728_19902[(5)] = null);

} else {
throw ex19721;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (112))){
var inst_19539 = (state_19580[(25)]);
var state_19580__$1 = state_19580;
var statearr_19729_19903 = state_19580__$1;
(statearr_19729_19903[(2)] = inst_19539);

(statearr_19729_19903[(1)] = (113));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (83))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19462 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_19463 = inst_19440.call(null,cljs.core.PersistentArrayMap,null,3,inst_19462,null);
var inst_19464 = inst_19440.call(null,cljs.core.PersistentHashSet,null,inst_19463,null);
var inst_19465 = inst_19464.call(null,inst_19439);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19465)){
var statearr_19730_19904 = state_19580__$1;
(statearr_19730_19904[(1)] = (84));

} else {
var statearr_19731_19905 = state_19580__$1;
(statearr_19731_19905[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (14))){
var inst_19308 = (state_19580[(11)]);
var inst_19318 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19319 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_19318);
var inst_19320 = inst_19319 === true;
var state_19580__$1 = state_19580;
var statearr_19732_19906 = state_19580__$1;
(statearr_19732_19906[(2)] = inst_19320);

(statearr_19732_19906[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (45))){
var inst_19370 = (state_19580[(28)]);
var state_19580__$1 = state_19580;
var statearr_19733_19907 = state_19580__$1;
(statearr_19733_19907[(2)] = inst_19370);

(statearr_19733_19907[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (53))){
var inst_19296 = (state_19580[(15)]);
var inst_19307 = (state_19580[(16)]);
var inst_19399 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_19296,inst_19307);
var state_19580__$1 = state_19580;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19580__$1,(56),inst_19399);
} else {
if((state_val_19581 === (78))){
var inst_19525 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19734_19908 = state_19580__$1;
(statearr_19734_19908[(2)] = inst_19525);

(statearr_19734_19908[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (26))){
var inst_19341 = (state_19580[(35)]);
var inst_19308 = (state_19580[(11)]);
var inst_19339 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19340 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19339);
var inst_19341__$1 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_19340);
var state_19580__$1 = (function (){var statearr_19735 = state_19580;
(statearr_19735[(35)] = inst_19341__$1);

return statearr_19735;
})();
if(inst_19341__$1){
var statearr_19736_19909 = state_19580__$1;
(statearr_19736_19909[(1)] = (29));

} else {
var statearr_19737_19910 = state_19580__$1;
(statearr_19737_19910[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (16))){
var inst_19323 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19738_19911 = state_19580__$1;
(statearr_19738_19911[(2)] = inst_19323);

(statearr_19738_19911[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (81))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19458 = fluree.db.query.schema.type_error.call(null,inst_19439,inst_19440,throw_QMARK_);
var state_19580__$1 = state_19580;
var statearr_19739_19912 = state_19580__$1;
(statearr_19739_19912[(2)] = inst_19458);

(statearr_19739_19912[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (120))){
var inst_19560 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19561 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_19562 = cljs.core.PersistentHashMap.fromArrays(inst_19560,inst_19561);
var inst_19563 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_19562);
var inst_19564 = (function(){throw inst_19563})();
var state_19580__$1 = state_19580;
var statearr_19740_19913 = state_19580__$1;
(statearr_19740_19913[(2)] = inst_19564);

(statearr_19740_19913[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (79))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19452 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_19453 = inst_19440.call(null,cljs.core.PersistentArrayMap,null,2,inst_19452,null);
var inst_19454 = inst_19440.call(null,cljs.core.PersistentHashSet,null,inst_19453,null);
var inst_19455 = inst_19454.call(null,inst_19439);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19455)){
var statearr_19741_19914 = state_19580__$1;
(statearr_19741_19914[(1)] = (80));

} else {
var statearr_19742_19915 = state_19580__$1;
(statearr_19742_19915[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (38))){
var inst_19374 = (state_19580[(36)]);
var inst_19308 = (state_19580[(11)]);
var inst_19373 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19374__$1 = cljs.core.not.call(null,inst_19373);
var state_19580__$1 = (function (){var statearr_19743 = state_19580;
(statearr_19743[(36)] = inst_19374__$1);

return statearr_19743;
})();
if(inst_19374__$1){
var statearr_19744_19916 = state_19580__$1;
(statearr_19744_19916[(1)] = (41));

} else {
var statearr_19745_19917 = state_19580__$1;
(statearr_19745_19917[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (98))){
var inst_19500 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19746_19918 = state_19580__$1;
(statearr_19746_19918[(2)] = inst_19500);

(statearr_19746_19918[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (87))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19472 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_19473 = inst_19440.call(null,cljs.core.PersistentArrayMap,null,3,inst_19472,null);
var inst_19474 = inst_19440.call(null,cljs.core.PersistentHashSet,null,inst_19473,null);
var inst_19475 = inst_19474.call(null,inst_19439);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19475)){
var statearr_19747_19919 = state_19580__$1;
(statearr_19747_19919[(1)] = (88));

} else {
var statearr_19748_19920 = state_19580__$1;
(statearr_19748_19920[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (30))){
var inst_19341 = (state_19580[(35)]);
var state_19580__$1 = state_19580;
var statearr_19749_19921 = state_19580__$1;
(statearr_19749_19921[(2)] = inst_19341);

(statearr_19749_19921[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (73))){
var state_19580__$1 = state_19580;
var statearr_19750_19922 = state_19580__$1;
(statearr_19750_19922[(1)] = (75));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (96))){
var inst_19427 = (state_19580[(12)]);
var state_19580__$1 = state_19580;
var statearr_19752_19923 = state_19580__$1;
(statearr_19752_19923[(2)] = inst_19427);

(statearr_19752_19923[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (10))){
var inst_19573 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19753_19924 = state_19580__$1;
(statearr_19753_19924[(2)] = inst_19573);

(statearr_19753_19924[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (18))){
var inst_19296 = (state_19580[(15)]);
var state_19580__$1 = state_19580;
var statearr_19754_19925 = state_19580__$1;
(statearr_19754_19925[(2)] = inst_19296);

(statearr_19754_19925[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (105))){
var inst_19440 = (state_19580[(8)]);
var inst_19439 = (state_19580[(9)]);
var inst_19518 = fluree.db.query.schema.type_error.call(null,inst_19439,inst_19440,throw_QMARK_);
var state_19580__$1 = state_19580;
var statearr_19755_19926 = state_19580__$1;
(statearr_19755_19926[(2)] = inst_19518);

(statearr_19755_19926[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (52))){
var inst_19409 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19756_19927 = state_19580__$1;
(statearr_19756_19927[(2)] = inst_19409);

(statearr_19756_19927[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (114))){
var inst_19308 = (state_19580[(11)]);
var inst_19545 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19546 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19545);
var inst_19547 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_19546);
var inst_19548 = (!(inst_19547));
var state_19580__$1 = state_19580;
var statearr_19757_19928 = state_19580__$1;
(statearr_19757_19928[(2)] = inst_19548);

(statearr_19757_19928[(1)] = (116));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (67))){
var inst_19427 = (state_19580[(12)]);
var state_19580__$1 = state_19580;
var statearr_19758_19929 = state_19580__$1;
(statearr_19758_19929[(2)] = inst_19427);

(statearr_19758_19929[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (71))){
var inst_19532 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19759_19930 = state_19580__$1;
(statearr_19759_19930[(2)] = inst_19532);

(statearr_19759_19930[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (42))){
var inst_19374 = (state_19580[(36)]);
var state_19580__$1 = state_19580;
var statearr_19760_19931 = state_19580__$1;
(statearr_19760_19931[(2)] = inst_19374);

(statearr_19760_19931[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (80))){
var inst_19427 = (state_19580[(12)]);
var state_19580__$1 = state_19580;
var statearr_19761_19932 = state_19580__$1;
(statearr_19761_19932[(2)] = inst_19427);

(statearr_19761_19932[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (37))){
var inst_19367 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19762_19933 = state_19580__$1;
(statearr_19762_19933[(2)] = inst_19367);

(statearr_19762_19933[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (63))){
var inst_19308 = (state_19580[(11)]);
var inst_19430 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_19308);
var inst_19431 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_19430);
var state_19580__$1 = state_19580;
var statearr_19763_19934 = state_19580__$1;
(statearr_19763_19934[(2)] = inst_19431);

(statearr_19763_19934[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (94))){
var inst_19490 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
var statearr_19764_19935 = state_19580__$1;
(statearr_19764_19935[(2)] = inst_19490);

(statearr_19764_19935[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (8))){
var inst_19296 = (state_19580[(15)]);
var state_19580__$1 = state_19580;
var statearr_19765_19936 = state_19580__$1;
(statearr_19765_19936[(2)] = inst_19296);

(statearr_19765_19936[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (49))){
var inst_19412 = (state_19580[(2)]);
var state_19580__$1 = state_19580;
if(cljs.core.truth_(inst_19412)){
var statearr_19766_19937 = state_19580__$1;
(statearr_19766_19937[(1)] = (57));

} else {
var statearr_19767_19938 = state_19580__$1;
(statearr_19767_19938[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19581 === (84))){
var inst_19427 = (state_19580[(12)]);
var state_19580__$1 = state_19580;
var statearr_19768_19939 = state_19580__$1;
(statearr_19768_19939[(2)] = inst_19427);

(statearr_19768_19939[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2726__auto__ = null;
var fluree$db$query$schema$state_machine__2726__auto____0 = (function (){
var statearr_19769 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19769[(0)] = fluree$db$query$schema$state_machine__2726__auto__);

(statearr_19769[(1)] = (1));

return statearr_19769;
});
var fluree$db$query$schema$state_machine__2726__auto____1 = (function (state_19580){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_19580);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e19770){var ex__2729__auto__ = e19770;
var statearr_19771_19940 = state_19580;
(statearr_19771_19940[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_19580[(4)]))){
var statearr_19772_19941 = state_19580;
(statearr_19772_19941[(1)] = cljs.core.first.call(null,(state_19580[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19942 = state_19580;
state_19580 = G__19942;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2726__auto__ = function(state_19580){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2726__auto____1.call(this,state_19580);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2726__auto____0;
fluree$db$query$schema$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2726__auto____1;
return fluree$db$query$schema$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_19773 = f__2749__auto__.call(null);
(statearr_19773[(6)] = c__2748__auto__);

return statearr_19773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__19944 = arguments.length;
switch (G__19944) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.call(null,db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_19968){
var state_val_19969 = (state_19968[(1)]);
if((state_val_19969 === (7))){
var state_19968__$1 = state_19968;
var statearr_19970_19990 = state_19968__$1;
(statearr_19970_19990[(2)] = db);

(statearr_19970_19990[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19969 === (1))){
var state_19968__$1 = state_19968;
var statearr_19971_19991 = state_19968__$1;
(statearr_19971_19991[(2)] = null);

(statearr_19971_19991[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19969 === (4))){
var inst_19945 = (state_19968[(2)]);
var state_19968__$1 = state_19968;
var statearr_19972_19992 = state_19968__$1;
(statearr_19972_19992[(2)] = inst_19945);

(statearr_19972_19992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19969 === (6))){
var inst_19954 = (state_19968[(7)]);
var inst_19953 = (state_19968[(2)]);
var inst_19954__$1 = fluree.db.util.async.throw_err.call(null,inst_19953);
var inst_19955 = cljs.core.empty_QMARK_.call(null,inst_19954__$1);
var state_19968__$1 = (function (){var statearr_19973 = state_19968;
(statearr_19973[(7)] = inst_19954__$1);

return statearr_19973;
})();
if(inst_19955){
var statearr_19974_19993 = state_19968__$1;
(statearr_19974_19993[(1)] = (7));

} else {
var statearr_19975_19994 = state_19968__$1;
(statearr_19975_19994[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19969 === (3))){
var inst_19966 = (state_19968[(2)]);
var state_19968__$1 = state_19968;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19968__$1,inst_19966);
} else {
if((state_val_19969 === (2))){
var _ = (function (){var statearr_19977 = state_19968;
(statearr_19977[(4)] = cljs.core.cons.call(null,(5),(state_19968[(4)])));

return statearr_19977;
})();
var inst_19951 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes,filter_QMARK_);
var state_19968__$1 = state_19968;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19968__$1,(6),inst_19951);
} else {
if((state_val_19969 === (9))){
var inst_19963 = (state_19968[(2)]);
var _ = (function (){var statearr_19978 = state_19968;
(statearr_19978[(4)] = cljs.core.rest.call(null,(state_19968[(4)])));

return statearr_19978;
})();
var state_19968__$1 = state_19968;
var statearr_19979_19995 = state_19968__$1;
(statearr_19979_19995[(2)] = inst_19963);

(statearr_19979_19995[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19969 === (5))){
var _ = (function (){var statearr_19980 = state_19968;
(statearr_19980[(4)] = cljs.core.rest.call(null,(state_19968[(4)])));

return statearr_19980;
})();
var state_19968__$1 = state_19968;
var ex19976 = (state_19968__$1[(2)]);
var statearr_19981_19996 = state_19968__$1;
(statearr_19981_19996[(5)] = ex19976);


if((ex19976 instanceof Error)){
var statearr_19982_19997 = state_19968__$1;
(statearr_19982_19997[(1)] = (4));

(statearr_19982_19997[(5)] = null);

} else {
throw ex19976;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19969 === (10))){
var inst_19960 = (state_19968[(2)]);
var inst_19961 = fluree.db.util.async.throw_err.call(null,inst_19960);
var state_19968__$1 = state_19968;
var statearr_19983_19998 = state_19968__$1;
(statearr_19983_19998[(2)] = inst_19961);

(statearr_19983_19998[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19969 === (8))){
var inst_19954 = (state_19968[(7)]);
var inst_19958 = fluree.db.query.schema.predicate_change_error.call(null,inst_19954,db,true);
var state_19968__$1 = state_19968;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19968__$1,(10),inst_19958);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2726__auto__ = null;
var fluree$db$query$schema$state_machine__2726__auto____0 = (function (){
var statearr_19984 = [null,null,null,null,null,null,null,null];
(statearr_19984[(0)] = fluree$db$query$schema$state_machine__2726__auto__);

(statearr_19984[(1)] = (1));

return statearr_19984;
});
var fluree$db$query$schema$state_machine__2726__auto____1 = (function (state_19968){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_19968);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e19985){var ex__2729__auto__ = e19985;
var statearr_19986_19999 = state_19968;
(statearr_19986_19999[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_19968[(4)]))){
var statearr_19987_20000 = state_19968;
(statearr_19987_20000[(1)] = cljs.core.first.call(null,(state_19968[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20001 = state_19968;
state_19968 = G__20001;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2726__auto__ = function(state_19968){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2726__auto____1.call(this,state_19968);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2726__auto____0;
fluree$db$query$schema$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2726__auto____1;
return fluree$db$query$schema$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_19988 = f__2749__auto__.call(null);
(statearr_19988[(6)] = c__2748__auto__);

return statearr_19988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__20003 = arguments.length;
switch (G__20003) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__20005 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__20005,(0),null);
var ns = cljs.core.nth.call(null,vec__20005,(1),null);
var name = cljs.core.nth.call(null,vec__20005,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4221__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4221__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__20008_SHARP_,p2__20009_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__20008_SHARP_,p2__20009_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec.call(null,cljs.core.keep.call(null,(function (p1__20010_SHARP_){
if(cljs.core._EQ_.call(null,spec_pid,p1__20010_SHARP_.p)){
return p1__20010_SHARP_.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_20076){
var state_val_20077 = (state_20076[(1)]);
if((state_val_20077 === (1))){
var state_20076__$1 = state_20076;
var statearr_20078_20095 = state_20076__$1;
(statearr_20078_20095[(2)] = null);

(statearr_20078_20095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20077 === (2))){
var _ = (function (){var statearr_20079 = state_20076;
(statearr_20079[(4)] = cljs.core.cons.call(null,(5),(state_20076[(4)])));

return statearr_20079;
})();
var inst_20028 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20029 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_20030 = [inst_20029];
var inst_20031 = (new cljs.core.PersistentVector(null,1,(5),inst_20028,inst_20030,null));
var inst_20032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20033 = [(0)];
var inst_20034 = (new cljs.core.PersistentVector(null,1,(5),inst_20032,inst_20033,null));
var inst_20035 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_20031,cljs.core._LT__EQ_,inst_20034);
var state_20076__$1 = state_20076;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20076__$1,(6),inst_20035);
} else {
if((state_val_20077 === (3))){
var inst_20074 = (state_20076[(2)]);
var state_20076__$1 = state_20076;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20076__$1,inst_20074);
} else {
if((state_val_20077 === (4))){
var inst_20016 = (state_20076[(2)]);
var state_20076__$1 = state_20076;
var statearr_20081_20096 = state_20076__$1;
(statearr_20081_20096[(2)] = inst_20016);

(statearr_20081_20096[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20077 === (5))){
var _ = (function (){var statearr_20082 = state_20076;
(statearr_20082[(4)] = cljs.core.rest.call(null,(state_20076[(4)])));

return statearr_20082;
})();
var state_20076__$1 = state_20076;
var ex20080 = (state_20076__$1[(2)]);
var statearr_20083_20097 = state_20076__$1;
(statearr_20083_20097[(5)] = ex20080);


if((ex20080 instanceof Error)){
var statearr_20084_20098 = state_20076__$1;
(statearr_20084_20098[(1)] = (4));

(statearr_20084_20098[(5)] = null);

} else {
throw ex20080;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20077 === (6))){
var inst_20037 = (state_20076[(2)]);
var inst_20038 = fluree.db.util.async.throw_err.call(null,inst_20037);
var inst_20039 = (function (){var schema_flakes = inst_20038;
return (function (p1__20011_SHARP_){
return (p1__20011_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_20040 = cljs.core.partition_by.call(null,inst_20039,inst_20038);
var inst_20041 = cljs.core.nth.call(null,inst_20040,(0),null);
var inst_20042 = cljs.core.nth.call(null,inst_20040,(1),null);
var inst_20043 = (function (){var schema_flakes = inst_20038;
var vec__20022 = inst_20040;
var collection_flakes = inst_20041;
var predicate_flakes = inst_20042;
return (function (acc,coll_flakes){
var sid = cljs.core.first.call(null,coll_flakes).s;
var p__GT_v = cljs.core.reduce.call(null,(function (p1__20013_SHARP_,p2__20014_SHARP_){
return cljs.core.assoc.call(null,p1__20013_SHARP_,p2__20014_SHARP_.p,p2__20014_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4223__auto__ = cljs.core.get.call(null,p__GT_v,(47));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.flake.sid__GT_i.call(null,sid);
}
})();
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids.call(null,(43),coll_flakes):null);
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),specs,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),partition,new cljs.core.Keyword(null,"partition","partition",1174740751),partition], null);
return cljs.core.assoc.call(null,acc,partition,c_props,c_name,c_props);
});
})();
var inst_20044 = [(-1),"_tx"];
var inst_20045 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_20046 = ["_tx",(-1),(-1)];
var inst_20047 = cljs.core.PersistentHashMap.fromArrays(inst_20045,inst_20046);
var inst_20048 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_20049 = ["_tx",(-1),(-1)];
var inst_20050 = cljs.core.PersistentHashMap.fromArrays(inst_20048,inst_20049);
var inst_20051 = [inst_20047,inst_20050];
var inst_20052 = cljs.core.PersistentHashMap.fromArrays(inst_20044,inst_20051);
var inst_20053 = (function (){var schema_flakes = inst_20038;
var vec__20022 = inst_20040;
var collection_flakes = inst_20041;
var predicate_flakes = inst_20042;
return (function (p1__20012_SHARP_){
return p1__20012_SHARP_.s;
});
})();
var inst_20054 = cljs.core.partition_by.call(null,inst_20053,inst_20041);
var inst_20055 = cljs.core.reduce.call(null,inst_20043,inst_20052,inst_20054);
var inst_20057 = (function (){var schema_flakes = inst_20038;
var vec__20022 = inst_20040;
var collection_flakes = inst_20041;
var predicate_flakes = inst_20042;
var coll = inst_20055;
return (function (p__20056,pred_flakes){
var vec__20085 = p__20056;
var pred = cljs.core.nth.call(null,vec__20085,(0),null);
var fullText = cljs.core.nth.call(null,vec__20085,(1),null);
var id = cljs.core.first.call(null,pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4223__auto__ = ref_QMARK_;
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"retractDuplicates","retractDuplicates",-757140871),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids.call(null,(24),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.call(null,p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids.call(null,(20),pred_flakes):null),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(29))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_20058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20059 = cljs.core.PersistentHashMap.EMPTY;
var inst_20060 = cljs.core.PersistentHashSet.EMPTY;
var inst_20061 = [inst_20059,inst_20060];
var inst_20062 = (new cljs.core.PersistentVector(null,2,(5),inst_20058,inst_20061,null));
var inst_20063 = (function (){var schema_flakes = inst_20038;
var vec__20022 = inst_20040;
var collection_flakes = inst_20041;
var predicate_flakes = inst_20042;
var coll = inst_20055;
return (function (p1__20015_SHARP_){
return p1__20015_SHARP_.s;
});
})();
var inst_20064 = cljs.core.partition_by.call(null,inst_20063,inst_20042);
var inst_20065 = cljs.core.reduce.call(null,inst_20057,inst_20062,inst_20064);
var inst_20066 = cljs.core.nth.call(null,inst_20065,(0),null);
var inst_20067 = cljs.core.nth.call(null,inst_20065,(1),null);
var inst_20068 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_20069 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_20070 = [inst_20069,inst_20055,inst_20066,inst_20067];
var inst_20071 = cljs.core.PersistentHashMap.fromArrays(inst_20068,inst_20070);
var _ = (function (){var statearr_20088 = state_20076;
(statearr_20088[(4)] = cljs.core.rest.call(null,(state_20076[(4)])));

return statearr_20088;
})();
var state_20076__$1 = state_20076;
var statearr_20089_20099 = state_20076__$1;
(statearr_20089_20099[(2)] = inst_20071);

(statearr_20089_20099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2726__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2726__auto____0 = (function (){
var statearr_20090 = [null,null,null,null,null,null,null];
(statearr_20090[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2726__auto__);

(statearr_20090[(1)] = (1));

return statearr_20090;
});
var fluree$db$query$schema$schema_map_$_state_machine__2726__auto____1 = (function (state_20076){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_20076);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e20091){var ex__2729__auto__ = e20091;
var statearr_20092_20100 = state_20076;
(statearr_20092_20100[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_20076[(4)]))){
var statearr_20093_20101 = state_20076;
(statearr_20093_20101[(1)] = cljs.core.first.call(null,(state_20076[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20102 = state_20076;
state_20076 = G__20102;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2726__auto__ = function(state_20076){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2726__auto____1.call(this,state_20076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2726__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2726__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_20094 = f__2749__auto__.call(null);
(statearr_20094[(6)] = c__2748__auto__);

return statearr_20094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_20144){
var state_val_20145 = (state_20144[(1)]);
if((state_val_20145 === (7))){
var inst_20127 = (state_20144[(2)]);
var inst_20128 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_20127);
var inst_20129 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_20130 = cljs.core.get.call(null,inst_20128,(114));
var inst_20131 = cljs.core.boolean$.call(null,inst_20130);
var inst_20132 = cljs.core.get.call(null,inst_20128,(110));
var inst_20133 = cljs.core.get.call(null,inst_20128,(117));
var inst_20134 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_20133);
var inst_20135 = cljs.core.get.call(null,inst_20128,(111));
var inst_20136 = cljs.core.get.call(null,inst_20128,(115));
var inst_20137 = cljs.core.get.call(null,inst_20128,(112));
var inst_20138 = [inst_20131,inst_20132,inst_20134,inst_20135,inst_20136,inst_20137];
var inst_20139 = cljs.core.PersistentHashMap.fromArrays(inst_20129,inst_20138);
var _ = (function (){var statearr_20146 = state_20144;
(statearr_20146[(4)] = cljs.core.rest.call(null,(state_20144[(4)])));

return statearr_20146;
})();
var state_20144__$1 = state_20144;
var statearr_20147_20170 = state_20144__$1;
(statearr_20147_20170[(2)] = inst_20139);

(statearr_20147_20170[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20145 === (1))){
var state_20144__$1 = state_20144;
var statearr_20148_20171 = state_20144__$1;
(statearr_20148_20171[(2)] = null);

(statearr_20148_20171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20145 === (4))){
var inst_20103 = (state_20144[(2)]);
var state_20144__$1 = state_20144;
var statearr_20149_20172 = state_20144__$1;
(statearr_20149_20172[(2)] = inst_20103);

(statearr_20149_20172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20145 === (6))){
var _ = (function (){var statearr_20150 = state_20144;
(statearr_20150[(4)] = cljs.core.cons.call(null,(9),(state_20144[(4)])));

return statearr_20150;
})();
var inst_20115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20117 = ["_setting/id","root"];
var inst_20118 = (new cljs.core.PersistentVector(null,2,(5),inst_20116,inst_20117,null));
var inst_20119 = [inst_20118];
var inst_20120 = (new cljs.core.PersistentVector(null,1,(5),inst_20115,inst_20119,null));
var inst_20121 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_20120);
var state_20144__$1 = state_20144;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20144__$1,(10),inst_20121);
} else {
if((state_val_20145 === (3))){
var inst_20142 = (state_20144[(2)]);
var state_20144__$1 = state_20144;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20144__$1,inst_20142);
} else {
if((state_val_20145 === (2))){
var _ = (function (){var statearr_20153 = state_20144;
(statearr_20153[(4)] = cljs.core.cons.call(null,(5),(state_20144[(4)])));

return statearr_20153;
})();
var state_20144__$1 = state_20144;
var statearr_20154_20173 = state_20144__$1;
(statearr_20154_20173[(2)] = null);

(statearr_20154_20173[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20145 === (9))){
var _ = (function (){var statearr_20155 = state_20144;
(statearr_20155[(4)] = cljs.core.rest.call(null,(state_20144[(4)])));

return statearr_20155;
})();
var state_20144__$1 = state_20144;
var ex20151 = (state_20144__$1[(2)]);
var statearr_20156_20174 = state_20144__$1;
(statearr_20156_20174[(5)] = ex20151);


var statearr_20157_20175 = state_20144__$1;
(statearr_20157_20175[(1)] = (8));

(statearr_20157_20175[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20145 === (5))){
var _ = (function (){var statearr_20158 = state_20144;
(statearr_20158[(4)] = cljs.core.rest.call(null,(state_20144[(4)])));

return statearr_20158;
})();
var state_20144__$1 = state_20144;
var ex20152 = (state_20144__$1[(2)]);
var statearr_20159_20176 = state_20144__$1;
(statearr_20159_20176[(5)] = ex20152);


if((ex20152 instanceof Error)){
var statearr_20160_20177 = state_20144__$1;
(statearr_20160_20177[(1)] = (4));

(statearr_20160_20177[(5)] = null);

} else {
throw ex20152;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20145 === (10))){
var inst_20123 = (state_20144[(2)]);
var inst_20124 = fluree.db.util.async.throw_err.call(null,inst_20123);
var _ = (function (){var statearr_20161 = state_20144;
(statearr_20161[(4)] = cljs.core.rest.call(null,(state_20144[(4)])));

return statearr_20161;
})();
var state_20144__$1 = state_20144;
var statearr_20162_20178 = state_20144__$1;
(statearr_20162_20178[(2)] = inst_20124);

(statearr_20162_20178[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20145 === (8))){
var inst_20109 = (state_20144[(2)]);
var state_20144__$1 = (function (){var statearr_20163 = state_20144;
(statearr_20163[(7)] = inst_20109);

return statearr_20163;
})();
var statearr_20164_20179 = state_20144__$1;
(statearr_20164_20179[(2)] = null);

(statearr_20164_20179[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2726__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2726__auto____0 = (function (){
var statearr_20165 = [null,null,null,null,null,null,null,null];
(statearr_20165[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2726__auto__);

(statearr_20165[(1)] = (1));

return statearr_20165;
});
var fluree$db$query$schema$setting_map_$_state_machine__2726__auto____1 = (function (state_20144){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_20144);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e20166){var ex__2729__auto__ = e20166;
var statearr_20167_20180 = state_20144;
(statearr_20167_20180[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_20144[(4)]))){
var statearr_20168_20181 = state_20144;
(statearr_20168_20181[(1)] = cljs.core.first.call(null,(state_20144[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20182 = state_20144;
state_20144 = G__20182;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2726__auto__ = function(state_20144){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2726__auto____1.call(this,state_20144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2726__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2726__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_20169 = f__2749__auto__.call(null);
(statearr_20169[(6)] = c__2748__auto__);

return statearr_20169;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
