// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__17016_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17016_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__17020 = coll;
var vec__17021 = G__17020;
var seq__17022 = cljs.core.seq.call(null,vec__17021);
var first__17023 = cljs.core.first.call(null,seq__17022);
var seq__17022__$1 = cljs.core.next.call(null,seq__17022);
var clause = first__17023;
var r = seq__17022__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__17020__$1 = G__17020;
var res__$1 = res;
while(true){
var vec__17027 = G__17020__$1;
var seq__17028 = cljs.core.seq.call(null,vec__17027);
var first__17029 = cljs.core.first.call(null,seq__17028);
var seq__17028__$1 = cljs.core.next.call(null,seq__17028);
var clause__$1 = first__17029;
var r__$1 = seq__17028__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__17030 = r__$1;
var G__17031 = cljs.core.conj.call(null,res__$2,clause__$1);
G__17020__$1 = G__17030;
res__$1 = G__17031;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.call(null,(function (res,p__17032){
var map__17033 = p__17032;
var map__17033__$1 = cljs.core.__destructure_map.call(null,map__17033);
var optional = cljs.core.get.call(null,map__17033__$1,new cljs.core.Keyword(null,"optional","optional",2053951509));
if(cljs.core.truth_(optional)){
return cljs.core.into.call(null,res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__17037 = coll;
var vec__17038 = G__17037;
var seq__17039 = cljs.core.seq.call(null,vec__17038);
var first__17040 = cljs.core.first.call(null,seq__17039);
var seq__17039__$1 = cljs.core.next.call(null,seq__17039);
var clause = first__17040;
var r = seq__17039__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__17037__$1 = G__17037;
var res__$1 = res;
while(true){
var vec__17044 = G__17037__$1;
var seq__17045 = cljs.core.seq.call(null,vec__17044);
var first__17046 = cljs.core.first.call(null,seq__17045);
var seq__17045__$1 = cljs.core.next.call(null,seq__17045);
var clause__$1 = first__17046;
var r__$1 = seq__17045__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__17047 = r__$1;
var G__17048 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__17037__$1 = G__17047;
res__$1 = G__17048;
continue;
} else {
var G__17049 = r__$1;
var G__17050 = res__$2;
G__17037__$1 = G__17049;
res__$1 = G__17050;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__17054 = coll;
var vec__17055 = G__17054;
var seq__17056 = cljs.core.seq.call(null,vec__17055);
var first__17057 = cljs.core.first.call(null,seq__17056);
var seq__17056__$1 = cljs.core.next.call(null,seq__17056);
var clause = first__17057;
var r = seq__17056__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__17054__$1 = G__17054;
var res__$1 = res;
while(true){
var vec__17061 = G__17054__$1;
var seq__17062 = cljs.core.seq.call(null,vec__17061);
var first__17063 = cljs.core.first.call(null,seq__17062);
var seq__17062__$1 = cljs.core.next.call(null,seq__17062);
var clause__$1 = first__17063;
var r__$1 = seq__17062__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__17064 = r__$1;
var G__17065 = res__$2;
G__17054__$1 = G__17064;
res__$1 = G__17065;
continue;
} else {
var G__17066 = r__$1;
var G__17067 = cljs.core.conj.call(null,res__$2,clause__$1);
G__17054__$1 = G__17066;
res__$1 = G__17067;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_((function (){var and__4221__auto__ = typeof string === 'string';
if(and__4221__auto__){
return cljs.core.re_matches.call(null,/^wd(t)*:(P|Q)\d+$/,string);
} else {
return and__4221__auto__;
}
})())){
cljs.core.symbol.call(null,string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__17068 = clause;
var G__17068__$1 = ((cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause)))?cljs.core.drop.call(null,(1),G__17068):G__17068);
var G__17068__$2 = cljs.core.map.call(null,fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,G__17068__$1)
;
var G__17068__$3 = clojure.string.join.call(null," ",G__17068__$2)
;
var G__17068__$4 = goog.string.format("%s .",G__17068__$3)
;
if(cljs.core.truth_(optional_QMARK_)){
return goog.string.format("OPTIONAL {%s}",G__17068__$4);
} else {
return G__17068__$4;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__17072 = opts;
var map__17072__$1 = cljs.core.__destructure_map.call(null,map__17072);
var limit = cljs.core.get.call(null,map__17072__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__17072__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__17072__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__17072__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__17072__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__17069_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17069_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__17070_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__17070_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__17071_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__17071_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4223__auto__ = language;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_17086){
var state_val_17087 = (state_17086[(1)]);
if((state_val_17087 === (1))){
var inst_17073 = fluree.db.util.core.url_encode.call(null,query);
var inst_17074 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17073)].join('');
var inst_17075 = ["User-Agent","Accept"];
var inst_17076 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_17077 = cljs.core.PersistentHashMap.fromArrays(inst_17075,inst_17076);
var inst_17078 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_17079 = [inst_17077,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_17080 = cljs.core.PersistentHashMap.fromArrays(inst_17078,inst_17079);
var inst_17081 = fluree.db.util.xhttp.get.call(null,inst_17074,inst_17080);
var state_17086__$1 = state_17086;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17086__$1,(2),inst_17081);
} else {
if((state_val_17087 === (2))){
var inst_17083 = (state_17086[(2)]);
var inst_17084 = fluree.db.util.async.throw_err.call(null,inst_17083);
var state_17086__$1 = state_17086;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17086__$1,inst_17084);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2726__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2726__auto____0 = (function (){
var statearr_17088 = [null,null,null,null,null,null,null];
(statearr_17088[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2726__auto__);

(statearr_17088[(1)] = (1));

return statearr_17088;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2726__auto____1 = (function (state_17086){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_17086);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e17089){var ex__2729__auto__ = e17089;
var statearr_17090_17093 = state_17086;
(statearr_17090_17093[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_17086[(4)]))){
var statearr_17091_17094 = state_17086;
(statearr_17091_17094[(1)] = cljs.core.first.call(null,(state_17086[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17095 = state_17086;
state_17086 = G__17095;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2726__auto__ = function(state_17086){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2726__auto____1.call(this,state_17086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2726__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2726__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_17092 = f__2749__auto__.call(null);
(statearr_17092[(6)] = c__2748__auto__);

return statearr_17092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_17113){
var state_val_17114 = (state_17113[(1)]);
if((state_val_17114 === (1))){
var inst_17096 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_17113__$1 = state_17113;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17113__$1,(2),inst_17096);
} else {
if((state_val_17114 === (2))){
var inst_17099 = (state_17113[(7)]);
var inst_17098 = (state_17113[(2)]);
var inst_17099__$1 = fluree.db.util.async.throw_err.call(null,inst_17098);
var inst_17100 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_17099__$1);
var inst_17101 = cljs.core.not_EQ_.call(null,(200),inst_17100);
var state_17113__$1 = (function (){var statearr_17115 = state_17113;
(statearr_17115[(7)] = inst_17099__$1);

return statearr_17115;
})();
if(inst_17101){
var statearr_17116_17125 = state_17113__$1;
(statearr_17116_17125[(1)] = (3));

} else {
var statearr_17117_17126 = state_17113__$1;
(statearr_17117_17126[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17114 === (3))){
var inst_17099 = (state_17113[(7)]);
var state_17113__$1 = state_17113;
var statearr_17118_17127 = state_17113__$1;
(statearr_17118_17127[(2)] = inst_17099);

(statearr_17118_17127[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17114 === (4))){
var inst_17099 = (state_17113[(7)]);
var inst_17104 = (function (){var body = inst_17099;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_17105 = cljs.core.second.call(null,inst_17099);
var inst_17106 = cljs.core.second.call(null,inst_17105);
var inst_17107 = cljs.core.first.call(null,inst_17106);
var inst_17108 = cljs.core.second.call(null,inst_17107);
var inst_17109 = cljs.core.mapv.call(null,inst_17104,inst_17108);
var state_17113__$1 = state_17113;
var statearr_17119_17128 = state_17113__$1;
(statearr_17119_17128[(2)] = inst_17109);

(statearr_17119_17128[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17114 === (5))){
var inst_17111 = (state_17113[(2)]);
var state_17113__$1 = state_17113;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17113__$1,inst_17111);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2726__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2726__auto____0 = (function (){
var statearr_17120 = [null,null,null,null,null,null,null,null];
(statearr_17120[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2726__auto__);

(statearr_17120[(1)] = (1));

return statearr_17120;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2726__auto____1 = (function (state_17113){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_17113);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e17121){var ex__2729__auto__ = e17121;
var statearr_17122_17129 = state_17113;
(statearr_17122_17129[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_17113[(4)]))){
var statearr_17123_17130 = state_17113;
(statearr_17123_17130[(1)] = cljs.core.first.call(null,(state_17113[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17131 = state_17113;
state_17113 = G__17131;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2726__auto__ = function(state_17113){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2726__auto____1.call(this,state_17113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2726__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2726__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_17124 = f__2749__auto__.call(null);
(statearr_17124[(6)] = c__2748__auto__);

return statearr_17124;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__17132_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17132_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__17133_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__17133_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__17134_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__17134_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_17180){
var state_val_17181 = (state_17180[(1)]);
if((state_val_17181 === (7))){
var inst_17145 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_17180__$1 = state_17180;
var statearr_17182_17210 = state_17180__$1;
(statearr_17182_17210[(2)] = inst_17145);

(statearr_17182_17210[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (1))){
var state_17180__$1 = state_17180;
var statearr_17183_17211 = state_17180__$1;
(statearr_17183_17211[(2)] = null);

(statearr_17183_17211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (4))){
var inst_17135 = (state_17180[(2)]);
var state_17180__$1 = state_17180;
var statearr_17184_17212 = state_17180__$1;
(statearr_17184_17212[(2)] = inst_17135);

(statearr_17184_17212[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (15))){
var inst_17153 = (state_17180[(7)]);
var inst_17159 = (state_17180[(8)]);
var inst_17154 = (state_17180[(9)]);
var inst_17164 = (state_17180[(2)]);
var inst_17165 = cljs.core.subs.call(null,inst_17159,(0),inst_17164);
var inst_17166 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17167 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_17153);
var inst_17168 = [inst_17154,inst_17167];
var inst_17169 = cljs.core.PersistentHashMap.fromArrays(inst_17166,inst_17168);
var inst_17170 = cljs.core.ex_info.call(null,inst_17165,inst_17169);
var inst_17171 = (function(){throw inst_17170})();
var state_17180__$1 = state_17180;
var statearr_17185_17213 = state_17180__$1;
(statearr_17185_17213[(2)] = inst_17171);

(statearr_17185_17213[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (13))){
var inst_17158 = (state_17180[(10)]);
var state_17180__$1 = state_17180;
var statearr_17186_17214 = state_17180__$1;
(statearr_17186_17214[(2)] = inst_17158);

(statearr_17186_17214[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (6))){
var state_17180__$1 = state_17180;
var statearr_17187_17215 = state_17180__$1;
(statearr_17187_17215[(2)] = null);

(statearr_17187_17215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (3))){
var inst_17178 = (state_17180[(2)]);
var state_17180__$1 = state_17180;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17180__$1,inst_17178);
} else {
if((state_val_17181 === (12))){
var inst_17175 = (state_17180[(2)]);
var _ = (function (){var statearr_17188 = state_17180;
(statearr_17188[(4)] = cljs.core.rest.call(null,(state_17180[(4)])));

return statearr_17188;
})();
var state_17180__$1 = state_17180;
var statearr_17189_17216 = state_17180__$1;
(statearr_17189_17216[(2)] = inst_17175);

(statearr_17189_17216[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (2))){
var _ = (function (){var statearr_17190 = state_17180;
(statearr_17190[(4)] = cljs.core.cons.call(null,(5),(state_17180[(4)])));

return statearr_17190;
})();
var inst_17142 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_17180__$1 = state_17180;
if(inst_17142){
var statearr_17191_17217 = state_17180__$1;
(statearr_17191_17217[(1)] = (6));

} else {
var statearr_17192_17218 = state_17180__$1;
(statearr_17192_17218[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (11))){
var inst_17153 = (state_17180[(7)]);
var inst_17173 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_17153,all_vars);
var state_17180__$1 = state_17180;
var statearr_17194_17219 = state_17180__$1;
(statearr_17194_17219[(2)] = inst_17173);

(statearr_17194_17219[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (9))){
var inst_17153 = (state_17180[(7)]);
var inst_17154 = (state_17180[(9)]);
var inst_17151 = (state_17180[(2)]);
var inst_17152 = fluree.db.util.async.throw_err.call(null,inst_17151);
var inst_17153__$1 = cljs.core.__destructure_map.call(null,inst_17152);
var inst_17154__$1 = cljs.core.get.call(null,inst_17153__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_17155 = cljs.core.get.call(null,inst_17153__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_17156 = cljs.core._EQ_.call(null,(400),inst_17154__$1);
var state_17180__$1 = (function (){var statearr_17195 = state_17180;
(statearr_17195[(7)] = inst_17153__$1);

(statearr_17195[(9)] = inst_17154__$1);

(statearr_17195[(11)] = inst_17155);

return statearr_17195;
})();
if(inst_17156){
var statearr_17196_17220 = state_17180__$1;
(statearr_17196_17220[(1)] = (10));

} else {
var statearr_17197_17221 = state_17180__$1;
(statearr_17197_17221[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (5))){
var _ = (function (){var statearr_17198 = state_17180;
(statearr_17198[(4)] = cljs.core.rest.call(null,(state_17180[(4)])));

return statearr_17198;
})();
var state_17180__$1 = state_17180;
var ex17193 = (state_17180__$1[(2)]);
var statearr_17199_17222 = state_17180__$1;
(statearr_17199_17222[(5)] = ex17193);


if((ex17193 instanceof Error)){
var statearr_17200_17223 = state_17180__$1;
(statearr_17200_17223[(1)] = (4));

(statearr_17200_17223[(5)] = null);

} else {
throw ex17193;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (14))){
var state_17180__$1 = state_17180;
var statearr_17201_17224 = state_17180__$1;
(statearr_17201_17224[(2)] = (1000));

(statearr_17201_17224[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (10))){
var inst_17153 = (state_17180[(7)]);
var inst_17158 = (state_17180[(10)]);
var inst_17155 = (state_17180[(11)]);
var inst_17158__$1 = cljs.core.count.call(null,inst_17155);
var inst_17159 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_17153);
var inst_17160 = (inst_17158__$1 < (1000));
var state_17180__$1 = (function (){var statearr_17202 = state_17180;
(statearr_17202[(8)] = inst_17159);

(statearr_17202[(10)] = inst_17158__$1);

return statearr_17202;
})();
if(cljs.core.truth_(inst_17160)){
var statearr_17203_17225 = state_17180__$1;
(statearr_17203_17225[(1)] = (13));

} else {
var statearr_17204_17226 = state_17180__$1;
(statearr_17204_17226[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17181 === (8))){
var inst_17147 = (state_17180[(2)]);
var inst_17148 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_17147,optional_clauses);
var inst_17149 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_17148);
var state_17180__$1 = state_17180;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17180__$1,(9),inst_17149);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2726__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2726__auto____0 = (function (){
var statearr_17205 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17205[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2726__auto__);

(statearr_17205[(1)] = (1));

return statearr_17205;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2726__auto____1 = (function (state_17180){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_17180);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e17206){var ex__2729__auto__ = e17206;
var statearr_17207_17227 = state_17180;
(statearr_17207_17227[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_17180[(4)]))){
var statearr_17208_17228 = state_17180;
(statearr_17208_17228[(1)] = cljs.core.first.call(null,(state_17180[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17229 = state_17180;
state_17180 = G__17229;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2726__auto__ = function(state_17180){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2726__auto____1.call(this,state_17180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2726__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2726__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_17209 = f__2749__auto__.call(null);
(statearr_17209[(6)] = c__2748__auto__);

return statearr_17209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
