// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"#")) && (cljs.core._EQ_.call(null,cljs.core.second.call(null,cljs.core.name.call(null,form)),"(")))))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"\"")) && (cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.name.call(null,form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.call(null,string);
}catch (e17232){var e = e17232;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some.call(null,(function (p1__17233_SHARP_){
var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,p1__17233_SHARP_);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.coll_QMARK_.call(null,p1__17233_SHARP_)){
return fluree.db.query.analytical.get_vars.call(null,p1__17233_SHARP_);
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv.call(null,(function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_.call(null,key);
var static_value = cljs.core.get.call(null,interm_vars,key_as_var);
if(((cljs.core._EQ_.call(null,idx,(1))) && (((cljs.core.not.call(null,key_as_var)) && (((cljs.core.not_EQ_.call(null,"_id",key)) && (cljs.core.not.call(null,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.re_find.call(null,/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.call(null,["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__17234_SHARP_){
return cljs.core.conj.call(null,p1__17234_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__17235_SHARP_){
return cljs.core.conj.call(null,p1__17235_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.query.analytical.internal_filter_QMARK_.call(null,key);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.call(null,idx,(2));
} else {
return and__4221__auto__;
}
})())){
var filter_code = cljs.reader.read_string.call(null,cljs.core.subs.call(null,key,(1)));
var var$ = (function (){var or__4223__auto__ = fluree.db.query.analytical.get_vars.call(null,filter_code);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.call(null,["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__17240 = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.call(null,vec__17240,(0),null);
var _ = cljs.core.nth.call(null,vec__17240,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn.call(null,var$,fun);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__17236_SHARP_){
return cljs.core.conj.call(null,p1__17236_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"rel","rel",1378823488),var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.call(null,idx,(1));
if(and__4221__auto__){
return cljs.core.re_find.call(null,/\+/,key);
} else {
return and__4221__auto__;
}
})())){
var vec__17243 = clojure.string.split.call(null,key,/\+/);
var pred = cljs.core.nth.call(null,vec__17243,(0),null);
var recur_amt = cljs.core.nth.call(null,vec__17243,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4223__auto__ = fluree.db.query.analytical.safe_read_string.call(null,recur_amt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in.call(null,cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__17237_SHARP_){
return cljs.core.conj.call(null,p1__17237_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"recur","recur",-437573268)], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_.call(null,key)){
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__17238_SHARP_){
return cljs.core.conj.call(null,p1__17238_SHARP_,fluree.db.query.analytical.safe_read_string.call(null,key));
}));
} else {
return cljs.core.update.call(null,acc,new cljs.core.Keyword(null,"search","search",1564939822),(function (p1__17239_SHARP_){
return cljs.core.conj.call(null,p1__17239_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"search","search",1564939822),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"rel","rel",1378823488),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.call(null,(function (array){
return cljs.core.map.call(null,(function (p1__17246_SHARP_){
return cljs.core.nth.call(null,array,p1__17246_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.call(null,(function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.call(null,acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys.call(null,clause);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(rel_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.call(null,(function (acc,key){
if(cljs.core.truth_(a_keys.call(null,key))){
return cljs.core.conj.call(null,acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.call(null,(function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_.call(null,var_smt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.call(null,acc,fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays.call(null,ns,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (add_amount > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fuel;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.volatile_QMARK_.call(null,fuel);
} else {
return and__4221__auto__;
}
})())){
return cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.call(null,(function (clause){
return cljs.core.mapv.call(null,(function (clause_item){
var temp__5751__auto__ = intersecting_vars.call(null,cljs.core.symbol.call(null,clause_item));
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.call(null,vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.call(null,replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__17249,optional_QMARK_,fuel,max_fuel){
var map__17250 = p__17249;
var map__17250__$1 = cljs.core.__destructure_map.call(null,map__17250);
var res = map__17250__$1;
var vars = cljs.core.get.call(null,map__17250__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_17316){
var state_val_17317 = (state_17316[(1)]);
if((state_val_17317 === (7))){
var inst_17305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17306 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses.call(null,r);
var inst_17307 = cljs.core.conj.call(null,inst_17306,clause);
var inst_17308 = [null,inst_17307];
var inst_17309 = (new cljs.core.PersistentVector(null,2,(5),inst_17305,inst_17308,null));
var state_17316__$1 = state_17316;
var statearr_17318_17346 = state_17316__$1;
(statearr_17318_17346[(2)] = inst_17309);

(statearr_17318_17346[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17317 === (1))){
var state_17316__$1 = state_17316;
var statearr_17319_17347 = state_17316__$1;
(statearr_17319_17347[(2)] = null);

(statearr_17319_17347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17317 === (4))){
var inst_17251 = (state_17316[(2)]);
var state_17316__$1 = state_17316;
var statearr_17320_17348 = state_17316__$1;
(statearr_17320_17348[(2)] = inst_17251);

(statearr_17320_17348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17317 === (15))){
var inst_17294 = (state_17316[(2)]);
var inst_17295 = fluree.db.util.async.throw_err.call(null,inst_17294);
var inst_17296 = new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(inst_17295);
var inst_17297 = cljs.core.count.call(null,inst_17296);
var inst_17298 = fluree.db.query.analytical.add_fuel.call(null,inst_17297,fuel,max_fuel);
var inst_17299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17300 = [inst_17295,r];
var inst_17301 = (new cljs.core.PersistentVector(null,2,(5),inst_17299,inst_17300,null));
var state_17316__$1 = (function (){var statearr_17321 = state_17316;
(statearr_17321[(7)] = inst_17298);

return statearr_17321;
})();
var statearr_17322_17349 = state_17316__$1;
(statearr_17322_17349[(2)] = inst_17301);

(statearr_17322_17349[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17317 === (13))){
var inst_17260 = (state_17316[(8)]);
var inst_17273 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_17274 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses.call(null,inst_17273);
var inst_17275 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_17260);
var inst_17276 = cljs.core.apply.call(null,cljs.core.concat,inst_17275);
var inst_17277 = cljs.core.set.call(null,inst_17276);
var inst_17278 = cljs.core.map.call(null,fluree.db.query.analytical.clause__GT_keys,inst_17274);
var inst_17279 = cljs.core.apply.call(null,cljs.core.concat,inst_17278);
var inst_17280 = cljs.core.into.call(null,inst_17277,inst_17279);
var inst_17281 = (function (){var all_wd = inst_17260;
var optional = inst_17274;
var all_wd_vars = inst_17277;
var all_vars = inst_17280;
return (function (p1__17247_SHARP_){
return all_vars.call(null,p1__17247_SHARP_);
});
})();
var inst_17282 = cljs.core.keys.call(null,vars);
var inst_17283 = cljs.core.map.call(null,inst_17281,inst_17282);
var inst_17284 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_17283);
var inst_17285 = cljs.core.set.call(null,inst_17284);
var inst_17286 = (function (){var all_wd = inst_17260;
var optional = inst_17274;
var all_wd_vars = inst_17277;
var all_vars = inst_17280;
var intersecting_vars = inst_17285;
return (function (p1__17248_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,p1__17248_SHARP_);
});
})();
var inst_17287 = cljs.core.map.call(null,inst_17286,inst_17260);
var inst_17288 = cljs.core.apply.call(null,cljs.core.concat,inst_17287);
var inst_17289 = fluree.db.query.analytical.select_from_tuples.call(null,inst_17288,res);
var inst_17290 = fluree.db.query.analytical.replace_vars_wikidata.call(null,inst_17260,inst_17285,vars);
var inst_17291 = cljs.core.remove.call(null,inst_17285,inst_17280);
var inst_17292 = fluree.db.query.analytical_wikidata.get_wikidata_tuples.call(null,q_map,inst_17290,inst_17288,inst_17289,inst_17291,inst_17274);
var state_17316__$1 = state_17316;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17316__$1,(15),inst_17292);
} else {
if((state_val_17317 === (6))){
var inst_17261 = (state_17316[(9)]);
var inst_17259 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(q_map);
var inst_17260 = fluree.db.query.analytical_wikidata.get_all_wd_clauses.call(null,inst_17259);
var inst_17261__$1 = optional_QMARK_;
var state_17316__$1 = (function (){var statearr_17323 = state_17316;
(statearr_17323[(8)] = inst_17260);

(statearr_17323[(9)] = inst_17261__$1);

return statearr_17323;
})();
if(cljs.core.truth_(inst_17261__$1)){
var statearr_17324_17350 = state_17316__$1;
(statearr_17324_17350[(1)] = (9));

} else {
var statearr_17325_17351 = state_17316__$1;
(statearr_17325_17351[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17317 === (3))){
var inst_17314 = (state_17316[(2)]);
var state_17316__$1 = state_17316;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17316__$1,inst_17314);
} else {
if((state_val_17317 === (12))){
var inst_17269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17270 = [null,r];
var inst_17271 = (new cljs.core.PersistentVector(null,2,(5),inst_17269,inst_17270,null));
var state_17316__$1 = state_17316;
var statearr_17326_17352 = state_17316__$1;
(statearr_17326_17352[(2)] = inst_17271);

(statearr_17326_17352[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17317 === (2))){
var _ = (function (){var statearr_17327 = state_17316;
(statearr_17327[(4)] = cljs.core.cons.call(null,(5),(state_17316[(4)])));

return statearr_17327;
})();
var inst_17257 = (r == null);
var state_17316__$1 = state_17316;
if(cljs.core.truth_(inst_17257)){
var statearr_17328_17353 = state_17316__$1;
(statearr_17328_17353[(1)] = (6));

} else {
var statearr_17329_17354 = state_17316__$1;
(statearr_17329_17354[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17317 === (11))){
var inst_17267 = (state_17316[(2)]);
var state_17316__$1 = state_17316;
if(cljs.core.truth_(inst_17267)){
var statearr_17331_17355 = state_17316__$1;
(statearr_17331_17355[(1)] = (12));

} else {
var statearr_17332_17356 = state_17316__$1;
(statearr_17332_17356[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17317 === (9))){
var inst_17260 = (state_17316[(8)]);
var inst_17263 = cljs.core.empty_QMARK_.call(null,inst_17260);
var inst_17264 = (!(inst_17263));
var state_17316__$1 = state_17316;
var statearr_17333_17357 = state_17316__$1;
(statearr_17333_17357[(2)] = inst_17264);

(statearr_17333_17357[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17317 === (5))){
var _ = (function (){var statearr_17334 = state_17316;
(statearr_17334[(4)] = cljs.core.rest.call(null,(state_17316[(4)])));

return statearr_17334;
})();
var state_17316__$1 = state_17316;
var ex17330 = (state_17316__$1[(2)]);
var statearr_17335_17358 = state_17316__$1;
(statearr_17335_17358[(5)] = ex17330);


if((ex17330 instanceof Error)){
var statearr_17336_17359 = state_17316__$1;
(statearr_17336_17359[(1)] = (4));

(statearr_17336_17359[(5)] = null);

} else {
throw ex17330;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17317 === (14))){
var inst_17303 = (state_17316[(2)]);
var state_17316__$1 = state_17316;
var statearr_17337_17360 = state_17316__$1;
(statearr_17337_17360[(2)] = inst_17303);

(statearr_17337_17360[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17317 === (10))){
var inst_17261 = (state_17316[(9)]);
var state_17316__$1 = state_17316;
var statearr_17338_17361 = state_17316__$1;
(statearr_17338_17361[(2)] = inst_17261);

(statearr_17338_17361[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17317 === (8))){
var inst_17311 = (state_17316[(2)]);
var _ = (function (){var statearr_17339 = state_17316;
(statearr_17339[(4)] = cljs.core.rest.call(null,(state_17316[(4)])));

return statearr_17339;
})();
var state_17316__$1 = state_17316;
var statearr_17340_17362 = state_17316__$1;
(statearr_17340_17362[(2)] = inst_17311);

(statearr_17340_17362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2726__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2726__auto____0 = (function (){
var statearr_17341 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17341[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2726__auto__);

(statearr_17341[(1)] = (1));

return statearr_17341;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2726__auto____1 = (function (state_17316){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_17316);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e17342){var ex__2729__auto__ = e17342;
var statearr_17343_17363 = state_17316;
(statearr_17343_17363[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_17316[(4)]))){
var statearr_17344_17364 = state_17316;
(statearr_17344_17364[(1)] = cljs.core.first.call(null,(state_17316[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17365 = state_17316;
state_17316 = G__17365;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2726__auto__ = function(state_17316){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2726__auto____1.call(this,state_17316);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2726__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2726__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_17345 = f__2749__auto__.call(null);
(statearr_17345[(6)] = c__2748__auto__);

return statearr_17345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string.call(null,block);
if(cljs.core.int_QMARK_.call(null,block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find.call(null,/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find.call(null,/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__17367 = arguments.length;
switch (G__17367) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.call(null,db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_17461){
var state_val_17462 = (state_17461[(1)]);
if((state_val_17462 === (7))){
var inst_17374 = (state_17461[(7)]);
var inst_17384 = clojure.string.starts_with_QMARK_.call(null,inst_17374,"$fdb");
var state_17461__$1 = state_17461;
if(inst_17384){
var statearr_17463_17512 = state_17461__$1;
(statearr_17463_17512[(1)] = (9));

} else {
var statearr_17464_17513 = state_17461__$1;
(statearr_17464_17513[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (20))){
var state_17461__$1 = state_17461;
var statearr_17465_17514 = state_17461__$1;
(statearr_17465_17514[(2)] = null);

(statearr_17465_17514[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (27))){
var inst_17424 = (state_17461[(8)]);
var state_17461__$1 = state_17461;
var statearr_17466_17515 = state_17461__$1;
(statearr_17466_17515[(2)] = inst_17424);

(statearr_17466_17515[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (1))){
var state_17461__$1 = state_17461;
var statearr_17467_17516 = state_17461__$1;
(statearr_17467_17516[(2)] = null);

(statearr_17467_17516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (24))){
var inst_17447 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17468_17517 = state_17461__$1;
(statearr_17468_17517[(2)] = inst_17447);

(statearr_17468_17517[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (4))){
var inst_17368 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17469_17518 = state_17461__$1;
(statearr_17469_17518[(2)] = inst_17368);

(statearr_17469_17518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (15))){
var inst_17391 = (state_17461[(9)]);
var inst_17397 = (state_17461[(2)]);
var inst_17398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17399 = cljs.core.PersistentVector.EMPTY;
var inst_17400 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_17401 = cljs.core.into.call(null,inst_17399,inst_17400);
var inst_17402 = [inst_17391,inst_17401];
var inst_17403 = (new cljs.core.PersistentVector(null,2,(5),inst_17398,inst_17402,null));
var state_17461__$1 = (function (){var statearr_17470 = state_17461;
(statearr_17470[(10)] = inst_17397);

return statearr_17470;
})();
var statearr_17471_17519 = state_17461__$1;
(statearr_17471_17519[(2)] = inst_17403);

(statearr_17471_17519[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (21))){
var inst_17450 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17472_17520 = state_17461__$1;
(statearr_17472_17520[(2)] = inst_17450);

(statearr_17472_17520[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (13))){
var inst_17391 = (state_17461[(9)]);
var inst_17394 = (function(){throw inst_17391})();
var state_17461__$1 = state_17461;
var statearr_17473_17521 = state_17461__$1;
(statearr_17473_17521[(2)] = inst_17394);

(statearr_17473_17521[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (22))){
var inst_17413 = (state_17461[(11)]);
var inst_17415 = (state_17461[(12)]);
var inst_17417 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_17413);
var inst_17418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17419 = [new cljs.core.Keyword(null,"sources","sources",-321166424),inst_17415];
var inst_17420 = (new cljs.core.PersistentVector(null,2,(5),inst_17418,inst_17419,null));
var inst_17421 = cljs.core.get_in.call(null,opts,inst_17420);
var state_17461__$1 = (function (){var statearr_17474 = state_17461;
(statearr_17474[(13)] = inst_17417);

return statearr_17474;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17461__$1,(25),inst_17421);
} else {
if((state_val_17462 === (29))){
var inst_17428 = (state_17461[(2)]);
var inst_17429 = fluree.db.util.async.throw_err.call(null,inst_17428);
var state_17461__$1 = state_17461;
var statearr_17475_17522 = state_17461__$1;
(statearr_17475_17522[(2)] = inst_17429);

(statearr_17475_17522[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (6))){
var inst_17377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17378 = cljs.core.PersistentVector.EMPTY;
var inst_17379 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_17380 = cljs.core.into.call(null,inst_17378,inst_17379);
var inst_17381 = [db,inst_17380];
var inst_17382 = (new cljs.core.PersistentVector(null,2,(5),inst_17377,inst_17381,null));
var state_17461__$1 = state_17461;
var statearr_17476_17523 = state_17461__$1;
(statearr_17476_17523[(2)] = inst_17382);

(statearr_17476_17523[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (28))){
var inst_17432 = (state_17461[(2)]);
var inst_17433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17434 = cljs.core.PersistentVector.EMPTY;
var inst_17435 = cljs.core.subvec.call(null,clause,(1),(4));
var inst_17436 = cljs.core.into.call(null,inst_17434,inst_17435);
var inst_17437 = [inst_17432,inst_17436];
var inst_17438 = (new cljs.core.PersistentVector(null,2,(5),inst_17433,inst_17437,null));
var state_17461__$1 = state_17461;
var statearr_17477_17524 = state_17461__$1;
(statearr_17477_17524[(2)] = inst_17438);

(statearr_17477_17524[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (25))){
var inst_17417 = (state_17461[(13)]);
var inst_17423 = (state_17461[(2)]);
var inst_17424 = fluree.db.util.async.throw_err.call(null,inst_17423);
var state_17461__$1 = (function (){var statearr_17478 = state_17461;
(statearr_17478[(8)] = inst_17424);

return statearr_17478;
})();
if(cljs.core.truth_(inst_17417)){
var statearr_17479_17525 = state_17461__$1;
(statearr_17479_17525[(1)] = (26));

} else {
var statearr_17480_17526 = state_17461__$1;
(statearr_17480_17526[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (17))){
var state_17461__$1 = state_17461;
var statearr_17481_17527 = state_17461__$1;
(statearr_17481_17527[(1)] = (19));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (3))){
var inst_17459 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17461__$1,inst_17459);
} else {
if((state_val_17462 === (12))){
var inst_17391 = (state_17461[(9)]);
var inst_17390 = (state_17461[(2)]);
var inst_17391__$1 = fluree.db.util.async.throw_err.call(null,inst_17390);
var inst_17392 = fluree.db.util.core.exception_QMARK_.call(null,inst_17391__$1);
var state_17461__$1 = (function (){var statearr_17483 = state_17461;
(statearr_17483[(9)] = inst_17391__$1);

return statearr_17483;
})();
if(inst_17392){
var statearr_17484_17528 = state_17461__$1;
(statearr_17484_17528[(1)] = (13));

} else {
var statearr_17485_17529 = state_17461__$1;
(statearr_17485_17529[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (2))){
var inst_17374 = (state_17461[(7)]);
var _ = (function (){var statearr_17486 = state_17461;
(statearr_17486[(4)] = cljs.core.cons.call(null,(5),(state_17461[(4)])));

return statearr_17486;
})();
var inst_17374__$1 = cljs.core.first.call(null,clause);
var inst_17375 = cljs.core._EQ_.call(null,"$fdb",inst_17374__$1);
var state_17461__$1 = (function (){var statearr_17487 = state_17461;
(statearr_17487[(7)] = inst_17374__$1);

return statearr_17487;
})();
if(inst_17375){
var statearr_17488_17530 = state_17461__$1;
(statearr_17488_17530[(1)] = (6));

} else {
var statearr_17489_17531 = state_17461__$1;
(statearr_17489_17531[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (23))){
var inst_17374 = (state_17461[(7)]);
var inst_17440 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17374)," is not supported in Fluree"].join('');
var inst_17441 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17442 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17443 = cljs.core.PersistentHashMap.fromArrays(inst_17441,inst_17442);
var inst_17444 = cljs.core.ex_info.call(null,inst_17440,inst_17443);
var inst_17445 = (function(){throw inst_17444})();
var state_17461__$1 = state_17461;
var statearr_17490_17532 = state_17461__$1;
(statearr_17490_17532[(2)] = inst_17445);

(statearr_17490_17532[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (19))){
var inst_17374 = (state_17461[(7)]);
var inst_17415 = (state_17461[(12)]);
var inst_17412 = fluree.db.query.analytical.isolate_source_name.call(null,inst_17374);
var inst_17413 = fluree.db.query.analytical.isolate_source_block.call(null,inst_17374);
var inst_17414 = cljs.core.keyword.call(null,inst_17412);
var inst_17415__$1 = cljs.core.get.call(null,prefixes,inst_17414);
var state_17461__$1 = (function (){var statearr_17491 = state_17461;
(statearr_17491[(11)] = inst_17413);

(statearr_17491[(12)] = inst_17415__$1);

return statearr_17491;
})();
if(cljs.core.truth_(inst_17415__$1)){
var statearr_17492_17533 = state_17461__$1;
(statearr_17492_17533[(1)] = (22));

} else {
var statearr_17493_17534 = state_17461__$1;
(statearr_17493_17534[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (11))){
var inst_17454 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17495_17535 = state_17461__$1;
(statearr_17495_17535[(2)] = inst_17454);

(statearr_17495_17535[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (9))){
var inst_17374 = (state_17461[(7)]);
var inst_17386 = cljs.core.subs.call(null,inst_17374,(4));
var inst_17387 = fluree.db.query.analytical.parse_block_from_source.call(null,inst_17386);
var inst_17388 = fluree.db.time_travel.as_of_block.call(null,db,inst_17387);
var state_17461__$1 = state_17461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17461__$1,(12),inst_17388);
} else {
if((state_val_17462 === (5))){
var _ = (function (){var statearr_17496 = state_17461;
(statearr_17496[(4)] = cljs.core.rest.call(null,(state_17461[(4)])));

return statearr_17496;
})();
var state_17461__$1 = state_17461;
var ex17494 = (state_17461__$1[(2)]);
var statearr_17497_17536 = state_17461__$1;
(statearr_17497_17536[(5)] = ex17494);


if((ex17494 instanceof Error)){
var statearr_17498_17537 = state_17461__$1;
(statearr_17498_17537[(1)] = (4));

(statearr_17498_17537[(5)] = null);

} else {
throw ex17494;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (14))){
var state_17461__$1 = state_17461;
var statearr_17499_17538 = state_17461__$1;
(statearr_17499_17538[(2)] = null);

(statearr_17499_17538[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (26))){
var inst_17424 = (state_17461[(8)]);
var inst_17417 = (state_17461[(13)]);
var inst_17426 = fluree.db.time_travel.as_of_block.call(null,inst_17424,inst_17417);
var state_17461__$1 = state_17461;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17461__$1,(29),inst_17426);
} else {
if((state_val_17462 === (16))){
var inst_17407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17408 = ["$wd",clause];
var inst_17409 = (new cljs.core.PersistentVector(null,2,(5),inst_17407,inst_17408,null));
var state_17461__$1 = state_17461;
var statearr_17500_17539 = state_17461__$1;
(statearr_17500_17539[(2)] = inst_17409);

(statearr_17500_17539[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (10))){
var inst_17374 = (state_17461[(7)]);
var inst_17405 = cljs.core._EQ_.call(null,"$wd",inst_17374);
var state_17461__$1 = state_17461;
if(inst_17405){
var statearr_17501_17540 = state_17461__$1;
(statearr_17501_17540[(1)] = (16));

} else {
var statearr_17502_17541 = state_17461__$1;
(statearr_17502_17541[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (18))){
var inst_17452 = (state_17461[(2)]);
var state_17461__$1 = state_17461;
var statearr_17503_17542 = state_17461__$1;
(statearr_17503_17542[(2)] = inst_17452);

(statearr_17503_17542[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17462 === (8))){
var inst_17456 = (state_17461[(2)]);
var _ = (function (){var statearr_17504 = state_17461;
(statearr_17504[(4)] = cljs.core.rest.call(null,(state_17461[(4)])));

return statearr_17504;
})();
var state_17461__$1 = state_17461;
var statearr_17505_17543 = state_17461__$1;
(statearr_17505_17543[(2)] = inst_17456);

(statearr_17505_17543[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2726__auto__ = null;
var fluree$db$query$analytical$state_machine__2726__auto____0 = (function (){
var statearr_17506 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17506[(0)] = fluree$db$query$analytical$state_machine__2726__auto__);

(statearr_17506[(1)] = (1));

return statearr_17506;
});
var fluree$db$query$analytical$state_machine__2726__auto____1 = (function (state_17461){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_17461);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e17507){var ex__2729__auto__ = e17507;
var statearr_17508_17544 = state_17461;
(statearr_17508_17544[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_17461[(4)]))){
var statearr_17509_17545 = state_17461;
(statearr_17509_17545[(1)] = cljs.core.first.call(null,(state_17461[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17546 = state_17461;
state_17461 = G__17546;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2726__auto__ = function(state_17461){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2726__auto____1.call(this,state_17461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2726__auto____0;
fluree$db$query$analytical$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2726__auto____1;
return fluree$db$query$analytical$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_17510 = f__2749__auto__.call(null);
(statearr_17510[(6)] = c__2748__auto__);

return statearr_17510;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.call(null,(function (acc,p__17547){
var vec__17548 = p__17547;
var sub = cljs.core.nth.call(null,vec__17548,(0),null);
var obj = cljs.core.nth.call(null,vec__17548,(1),null);
return cljs.core.update.call(null,acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap.call(null,cljs.core.keys.call(null,tuple_map),cljs.core.map.call(null,(function (p1__17551_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"done","done",-889844188),new cljs.core.Keyword(null,"followed","followed",821961472),new cljs.core.Keyword(null,"all","all",892129742)],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set.call(null,p1__17551_SHARP_)]);
}),cljs.core.vals.call(null,tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map.call(null,tuple_map);
var G__17555 = subjects;
var vec__17556 = G__17555;
var seq__17557 = cljs.core.seq.call(null,vec__17556);
var first__17558 = cljs.core.first.call(null,seq__17557);
var seq__17557__$1 = cljs.core.next.call(null,seq__17557);
var subject = first__17558;
var r = seq__17557__$1;
var acc = expanded_map;
var G__17555__$1 = G__17555;
var acc__$1 = acc;
while(true){
var vec__17562 = G__17555__$1;
var seq__17563 = cljs.core.seq.call(null,vec__17562);
var first__17564 = cljs.core.first.call(null,seq__17563);
var seq__17563__$1 = cljs.core.next.call(null,seq__17563);
var subject__$1 = first__17564;
var r__$1 = seq__17563__$1;
var acc__$2 = acc__$1;
if(cljs.core.not.call(null,subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
var G__17565 = r__$1;
var G__17566 = acc__$2;
G__17555__$1 = G__17565;
acc__$1 = G__17566;
continue;
} else {
var subject_all = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_followed = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subjects_to_follow = clojure.set.difference.call(null,subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.call(null,((function (G__17555__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__17562,seq__17563,first__17564,seq__17563__$1,subject__$1,r__$1,acc__$2,G__17555,vec__17556,seq__17557,first__17558,seq__17557__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var self_QMARK_ = cljs.core._EQ_.call(null,subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:all_followed.call(null,subject_to_follow));
var acc_SINGLEQUOTE_ = cljs.core.update_in.call(null,acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4223__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"all","all",892129742)], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.call(null,acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null),((function (G__17555__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17562,seq__17563,first__17564,seq__17563__$1,subject__$1,r__$1,acc__$2,G__17555,vec__17556,seq__17557,first__17558,seq__17557__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__17555__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17562,seq__17563,first__17564,seq__17563__$1,subject__$1,r__$1,acc__$2,G__17555,vec__17556,seq__17557,first__17558,seq__17557__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,new cljs.core.Keyword(null,"done","done",-889844188)], null)))){
return cljs.core.update_in.call(null,acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null),((function (G__17555__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17562,seq__17563,first__17564,seq__17563__$1,subject__$1,r__$1,acc__$2,G__17555,vec__17556,seq__17557,first__17558,seq__17557__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.call(null,cljs.core.conj,existing,subject_to_follow_all);
});})(G__17555__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__17562,seq__17563,first__17564,seq__17563__$1,subject__$1,r__$1,acc__$2,G__17555,vec__17556,seq__17557,first__17558,seq__17557__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__17555__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__17562,seq__17563,first__17564,seq__17563__$1,subject__$1,r__$1,acc__$2,G__17555,vec__17556,seq__17557,first__17558,seq__17557__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
var subject_all_count = cljs.core.get_in.call(null,acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"all","all",892129742)], null));
var subject_done_QMARK_ = cljs.core._EQ_.call(null,subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__17567 = r__$1;
var G__17568 = cljs.core.assoc_in.call(null,acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,new cljs.core.Keyword(null,"done","done",-889844188)], null),true);
G__17555__$1 = G__17567;
acc__$1 = G__17568;
continue;
} else {
var G__17569 = subjects;
var G__17570 = acc_STAR_;
G__17555__$1 = G__17569;
acc__$1 = G__17570;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.call(null,(function (acc,subject){
var subject_vals = cljs.core.get_in.call(null,recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"followed","followed",821961472)], null));
return cljs.core.concat.call(null,acc,cljs.core.map.call(null,(function (p1__17571_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__17571_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_17662){
var state_val_17663 = (state_17662[(1)]);
if((state_val_17663 === (7))){
var state_17662__$1 = state_17662;
var statearr_17664_17710 = state_17662__$1;
(statearr_17664_17710[(2)] = (100));

(statearr_17664_17710[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (20))){
var inst_17611 = (state_17662[(7)]);
var state_17662__$1 = state_17662;
var statearr_17665_17711 = state_17662__$1;
(statearr_17665_17711[(2)] = inst_17611);

(statearr_17665_17711[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (1))){
var state_17662__$1 = state_17662;
var statearr_17666_17712 = state_17662__$1;
(statearr_17666_17712[(2)] = null);

(statearr_17666_17712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (24))){
var inst_17583 = (state_17662[(8)]);
var inst_17650 = (state_17662[(9)]);
var inst_17648 = (state_17662[(10)]);
var inst_17649 = (state_17662[(11)]);
var inst_17653 = (function (){var max_depth = inst_17583;
var recur_map__$1 = inst_17649;
var subjects = inst_17648;
var tuples = inst_17650;
return (function (p1__17572_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second.call(null,p1__17572_SHARP_)],null));
});
})();
var inst_17654 = cljs.core.map.call(null,inst_17653,inst_17650);
var inst_17655 = cljs.core.distinct.call(null,inst_17654);
var state_17662__$1 = state_17662;
var statearr_17667_17713 = state_17662__$1;
(statearr_17667_17713[(2)] = inst_17655);

(statearr_17667_17713[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (4))){
var inst_17573 = (state_17662[(2)]);
var state_17662__$1 = state_17662;
var statearr_17668_17714 = state_17662__$1;
(statearr_17668_17714[(2)] = inst_17573);

(statearr_17668_17714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (15))){
var inst_17596 = (state_17662[(12)]);
var inst_17607 = cljs.core.PersistentVector.EMPTY;
var inst_17608 = cljs.core.seq.call(null,inst_17596);
var inst_17609 = cljs.core.first.call(null,inst_17608);
var inst_17610 = cljs.core.next.call(null,inst_17608);
var inst_17611 = inst_17607;
var inst_17612 = inst_17596;
var state_17662__$1 = (function (){var statearr_17669 = state_17662;
(statearr_17669[(13)] = inst_17612);

(statearr_17669[(14)] = inst_17610);

(statearr_17669[(15)] = inst_17609);

(statearr_17669[(7)] = inst_17611);

return statearr_17669;
})();
var statearr_17670_17715 = state_17662__$1;
(statearr_17670_17715[(2)] = null);

(statearr_17670_17715[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (21))){
var inst_17632 = (state_17662[(2)]);
var state_17662__$1 = state_17662;
var statearr_17671_17716 = state_17662__$1;
(statearr_17671_17716[(2)] = inst_17632);

(statearr_17671_17716[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (13))){
var inst_17645 = (state_17662[(2)]);
var state_17662__$1 = state_17662;
var statearr_17672_17717 = state_17662__$1;
(statearr_17672_17717[(2)] = inst_17645);

(statearr_17672_17717[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (22))){
var inst_17619 = (state_17662[(16)]);
var inst_17611 = (state_17662[(7)]);
var inst_17626 = (state_17662[(2)]);
var inst_17627 = fluree.db.util.async.throw_err.call(null,inst_17626);
var inst_17628 = cljs.core.concat.call(null,inst_17611,inst_17627);
var inst_17611__$1 = inst_17628;
var inst_17612 = inst_17619;
var state_17662__$1 = (function (){var statearr_17673 = state_17662;
(statearr_17673[(13)] = inst_17612);

(statearr_17673[(7)] = inst_17611__$1);

return statearr_17673;
})();
var statearr_17674_17718 = state_17662__$1;
(statearr_17674_17718[(2)] = null);

(statearr_17674_17718[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (6))){
var inst_17579 = (state_17662[(17)]);
var state_17662__$1 = state_17662;
var statearr_17675_17719 = state_17662__$1;
(statearr_17675_17719[(2)] = inst_17579);

(statearr_17675_17719[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (25))){
var inst_17657 = (state_17662[(2)]);
var _ = (function (){var statearr_17676 = state_17662;
(statearr_17676[(4)] = cljs.core.rest.call(null,(state_17662[(4)])));

return statearr_17676;
})();
var state_17662__$1 = state_17662;
var statearr_17677_17720 = state_17662__$1;
(statearr_17677_17720[(2)] = inst_17657);

(statearr_17677_17720[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (17))){
var inst_17612 = (state_17662[(13)]);
var inst_17618 = (state_17662[(18)]);
var inst_17617 = cljs.core.seq.call(null,inst_17612);
var inst_17618__$1 = cljs.core.first.call(null,inst_17617);
var inst_17619 = cljs.core.next.call(null,inst_17617);
var state_17662__$1 = (function (){var statearr_17678 = state_17662;
(statearr_17678[(16)] = inst_17619);

(statearr_17678[(18)] = inst_17618__$1);

return statearr_17678;
})();
if(cljs.core.truth_(inst_17618__$1)){
var statearr_17679_17721 = state_17662__$1;
(statearr_17679_17721[(1)] = (19));

} else {
var statearr_17680_17722 = state_17662__$1;
(statearr_17680_17722[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (3))){
var inst_17660 = (state_17662[(2)]);
var state_17662__$1 = state_17662;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17662__$1,inst_17660);
} else {
if((state_val_17663 === (12))){
var inst_17596 = (state_17662[(12)]);
var inst_17585 = (state_17662[(19)]);
var inst_17591 = cljs.core.vals.call(null,inst_17585);
var inst_17592 = cljs.core.flatten.call(null,inst_17591);
var inst_17593 = cljs.core.set.call(null,inst_17592);
var inst_17594 = cljs.core.keys.call(null,inst_17585);
var inst_17595 = cljs.core.set.call(null,inst_17594);
var inst_17596__$1 = clojure.set.difference.call(null,inst_17593,inst_17595);
var inst_17597 = cljs.core.empty_QMARK_.call(null,inst_17596__$1);
var state_17662__$1 = (function (){var statearr_17681 = state_17662;
(statearr_17681[(12)] = inst_17596__$1);

return statearr_17681;
})();
if(inst_17597){
var statearr_17682_17723 = state_17662__$1;
(statearr_17682_17723[(1)] = (14));

} else {
var statearr_17683_17724 = state_17662__$1;
(statearr_17683_17724[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (2))){
var inst_17579 = (state_17662[(17)]);
var _ = (function (){var statearr_17684 = state_17662;
(statearr_17684[(4)] = cljs.core.cons.call(null,(5),(state_17662[(4)])));

return statearr_17684;
})();
var inst_17579__$1 = depth;
var state_17662__$1 = (function (){var statearr_17685 = state_17662;
(statearr_17685[(17)] = inst_17579__$1);

return statearr_17685;
})();
if(cljs.core.truth_(inst_17579__$1)){
var statearr_17686_17725 = state_17662__$1;
(statearr_17686_17725[(1)] = (6));

} else {
var statearr_17687_17726 = state_17662__$1;
(statearr_17687_17726[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (23))){
var inst_17650 = (state_17662[(9)]);
var state_17662__$1 = state_17662;
var statearr_17688_17727 = state_17662__$1;
(statearr_17688_17727[(2)] = inst_17650);

(statearr_17688_17727[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (19))){
var inst_17618 = (state_17662[(18)]);
var inst_17621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17622 = [inst_17618,predicate];
var inst_17623 = (new cljs.core.PersistentVector(null,2,(5),inst_17621,inst_17622,null));
var inst_17624 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_17623);
var state_17662__$1 = state_17662;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17662__$1,(22),inst_17624);
} else {
if((state_val_17663 === (11))){
var inst_17585 = (state_17662[(19)]);
var state_17662__$1 = state_17662;
var statearr_17690_17728 = state_17662__$1;
(statearr_17690_17728[(2)] = inst_17585);

(statearr_17690_17728[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (9))){
var inst_17586 = (state_17662[(20)]);
var inst_17583 = (state_17662[(8)]);
var inst_17588 = (inst_17586 >= inst_17583);
var state_17662__$1 = state_17662;
if(cljs.core.truth_(inst_17588)){
var statearr_17691_17729 = state_17662__$1;
(statearr_17691_17729[(1)] = (11));

} else {
var statearr_17692_17730 = state_17662__$1;
(statearr_17692_17730[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (5))){
var _ = (function (){var statearr_17693 = state_17662;
(statearr_17693[(4)] = cljs.core.rest.call(null,(state_17662[(4)])));

return statearr_17693;
})();
var state_17662__$1 = state_17662;
var ex17689 = (state_17662__$1[(2)]);
var statearr_17694_17731 = state_17662__$1;
(statearr_17694_17731[(5)] = ex17689);


if((ex17689 instanceof Error)){
var statearr_17695_17732 = state_17662__$1;
(statearr_17695_17732[(1)] = (4));

(statearr_17695_17732[(5)] = null);

} else {
throw ex17689;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (14))){
var inst_17585 = (state_17662[(19)]);
var state_17662__$1 = state_17662;
var statearr_17696_17733 = state_17662__$1;
(statearr_17696_17733[(2)] = inst_17585);

(statearr_17696_17733[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (16))){
var inst_17643 = (state_17662[(2)]);
var state_17662__$1 = state_17662;
var statearr_17697_17734 = state_17662__$1;
(statearr_17697_17734[(2)] = inst_17643);

(statearr_17697_17734[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (10))){
var inst_17648 = (state_17662[(10)]);
var inst_17649 = (state_17662[(11)]);
var inst_17647 = (state_17662[(2)]);
var inst_17648__$1 = cljs.core.keys.call(null,inst_17647);
var inst_17649__$1 = fluree.db.query.analytical.follow_all_original_subject_paths.call(null,inst_17648__$1,inst_17647);
var inst_17650 = fluree.db.query.analytical.recur_map__GT_tuples.call(null,inst_17648__$1,inst_17649__$1);
var state_17662__$1 = (function (){var statearr_17698 = state_17662;
(statearr_17698[(9)] = inst_17650);

(statearr_17698[(10)] = inst_17648__$1);

(statearr_17698[(11)] = inst_17649__$1);

return statearr_17698;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_17699_17735 = state_17662__$1;
(statearr_17699_17735[(1)] = (23));

} else {
var statearr_17700_17736 = state_17662__$1;
(statearr_17700_17736[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (18))){
var inst_17586 = (state_17662[(20)]);
var inst_17585 = (state_17662[(19)]);
var inst_17634 = (state_17662[(2)]);
var inst_17635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17636 = [(0),(2)];
var inst_17637 = (new cljs.core.PersistentVector(null,2,(5),inst_17635,inst_17636,null));
var inst_17638 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_17637,inst_17634);
var inst_17639 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_17585,inst_17638);
var inst_17640 = (inst_17586 + (1));
var inst_17585__$1 = inst_17639;
var inst_17586__$1 = inst_17640;
var state_17662__$1 = (function (){var statearr_17701 = state_17662;
(statearr_17701[(20)] = inst_17586__$1);

(statearr_17701[(19)] = inst_17585__$1);

return statearr_17701;
})();
var statearr_17702_17737 = state_17662__$1;
(statearr_17702_17737[(2)] = null);

(statearr_17702_17737[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17663 === (8))){
var inst_17583 = (state_17662[(2)]);
var inst_17584 = recur_map;
var inst_17585 = inst_17584;
var inst_17586 = (1);
var state_17662__$1 = (function (){var statearr_17703 = state_17662;
(statearr_17703[(20)] = inst_17586);

(statearr_17703[(8)] = inst_17583);

(statearr_17703[(19)] = inst_17585);

return statearr_17703;
})();
var statearr_17704_17738 = state_17662__$1;
(statearr_17704_17738[(2)] = null);

(statearr_17704_17738[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2726__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2726__auto____0 = (function (){
var statearr_17705 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17705[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2726__auto__);

(statearr_17705[(1)] = (1));

return statearr_17705;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2726__auto____1 = (function (state_17662){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_17662);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e17706){var ex__2729__auto__ = e17706;
var statearr_17707_17739 = state_17662;
(statearr_17707_17739[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_17662[(4)]))){
var statearr_17708_17740 = state_17662;
(statearr_17708_17740[(1)] = cljs.core.first.call(null,(state_17662[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17741 = state_17662;
state_17662 = G__17741;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2726__auto__ = function(state_17662){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2726__auto____1.call(this,state_17662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2726__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2726__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_17709 = f__2749__auto__.call(null);
(statearr_17709[(6)] = c__2748__auto__);

return statearr_17709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__17742,clause,fuel,max_fuel){
var map__17743 = p__17742;
var map__17743__$1 = cljs.core.__destructure_map.call(null,map__17743);
var res = map__17743__$1;
var headers = cljs.core.get.call(null,map__17743__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__17743__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vars = cljs.core.get.call(null,map__17743__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_17854){
var state_val_17855 = (state_17854[(1)]);
if((state_val_17855 === (7))){
var inst_17760 = (state_17854[(7)]);
var state_17854__$1 = state_17854;
var statearr_17856_17909 = state_17854__$1;
(statearr_17856_17909[(2)] = inst_17760);

(statearr_17856_17909[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (20))){
var inst_17788 = (state_17854[(8)]);
var inst_17819 = typeof inst_17788 === 'number';
var state_17854__$1 = state_17854;
if(cljs.core.truth_(inst_17819)){
var statearr_17857_17910 = state_17854__$1;
(statearr_17857_17910[(1)] = (22));

} else {
var statearr_17858_17911 = state_17854__$1;
(statearr_17858_17911[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (27))){
var inst_17834 = (state_17854[(2)]);
var state_17854__$1 = state_17854;
var statearr_17859_17912 = state_17854__$1;
(statearr_17859_17912[(2)] = inst_17834);

(statearr_17859_17912[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (1))){
var state_17854__$1 = state_17854;
var statearr_17860_17913 = state_17854__$1;
(statearr_17860_17913[(2)] = null);

(statearr_17860_17913[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (24))){
var inst_17836 = (state_17854[(2)]);
var state_17854__$1 = state_17854;
var statearr_17861_17914 = state_17854__$1;
(statearr_17861_17914[(2)] = inst_17836);

(statearr_17861_17914[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (4))){
var inst_17744 = (state_17854[(2)]);
var state_17854__$1 = state_17854;
var statearr_17862_17915 = state_17854__$1;
(statearr_17862_17915[(2)] = inst_17744);

(statearr_17862_17915[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (15))){
var inst_17802 = (state_17854[(2)]);
var inst_17803 = cljs.core.nth.call(null,clause,(2));
var inst_17804 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_17803);
var state_17854__$1 = (function (){var statearr_17863 = state_17854;
(statearr_17863[(9)] = inst_17802);

return statearr_17863;
})();
if(cljs.core.truth_(inst_17804)){
var statearr_17864_17916 = state_17854__$1;
(statearr_17864_17916[(1)] = (16));

} else {
var statearr_17865_17917 = state_17854__$1;
(statearr_17865_17917[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (21))){
var inst_17761 = (state_17854[(10)]);
var inst_17790 = (state_17854[(11)]);
var inst_17791 = (state_17854[(12)]);
var inst_17838 = (state_17854[(2)]);
var inst_17839 = fluree.db.query.analytical.tuples__GT_recur.call(null,db,inst_17791,inst_17838,inst_17761,inst_17790);
var state_17854__$1 = state_17854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17854__$1,(28),inst_17839);
} else {
if((state_val_17855 === (13))){
var inst_17770 = (state_17854[(13)]);
var inst_17794 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17770)].join('');
var inst_17795 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17796 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17797 = cljs.core.PersistentHashMap.fromArrays(inst_17795,inst_17796);
var inst_17798 = cljs.core.ex_info.call(null,inst_17794,inst_17797);
var inst_17799 = (function(){throw inst_17798})();
var state_17854__$1 = state_17854;
var statearr_17866_17918 = state_17854__$1;
(statearr_17866_17918[(2)] = inst_17799);

(statearr_17866_17918[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (22))){
var inst_17786 = (state_17854[(14)]);
var inst_17788 = (state_17854[(8)]);
var inst_17821 = cljs.core.PersistentHashMap.EMPTY;
var inst_17822 = cljs.core.flatten.call(null,inst_17786);
var inst_17823 = cljs.core.assoc.call(null,inst_17821,inst_17788,inst_17822);
var state_17854__$1 = state_17854;
var statearr_17867_17919 = state_17854__$1;
(statearr_17867_17919[(2)] = inst_17823);

(statearr_17867_17919[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (6))){
var inst_17772 = (state_17854[(15)]);
var state_17854__$1 = state_17854;
var statearr_17868_17920 = state_17854__$1;
(statearr_17868_17920[(2)] = inst_17772);

(statearr_17868_17920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (28))){
var inst_17841 = (state_17854[(2)]);
var inst_17842 = fluree.db.util.async.throw_err.call(null,inst_17841);
var state_17854__$1 = state_17854;
var statearr_17869_17921 = state_17854__$1;
(statearr_17869_17921[(2)] = inst_17842);

(statearr_17869_17921[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (25))){
var inst_17782 = (state_17854[(16)]);
var inst_17786 = (state_17854[(14)]);
var inst_17827 = cljs.core.PersistentHashMap.EMPTY;
var inst_17828 = cljs.core.first.call(null,inst_17782);
var inst_17829 = cljs.core.first.call(null,inst_17828);
var inst_17830 = cljs.core.flatten.call(null,inst_17786);
var inst_17831 = cljs.core.assoc.call(null,inst_17827,inst_17829,inst_17830);
var state_17854__$1 = state_17854;
var statearr_17870_17922 = state_17854__$1;
(statearr_17870_17922[(2)] = inst_17831);

(statearr_17870_17922[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (17))){
var inst_17770 = (state_17854[(13)]);
var inst_17807 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_17770)].join('');
var inst_17808 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17809 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17810 = cljs.core.PersistentHashMap.fromArrays(inst_17808,inst_17809);
var inst_17811 = cljs.core.ex_info.call(null,inst_17807,inst_17810);
var inst_17812 = (function(){throw inst_17811})();
var state_17854__$1 = state_17854;
var statearr_17871_17923 = state_17854__$1;
(statearr_17871_17923[(2)] = inst_17812);

(statearr_17871_17923[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (3))){
var inst_17852 = (state_17854[(2)]);
var state_17854__$1 = state_17854;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17854__$1,inst_17852);
} else {
if((state_val_17855 === (12))){
var inst_17757 = (state_17854[(17)]);
var inst_17845 = (state_17854[(2)]);
var inst_17846 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_17847 = cljs.core.keys.call(null,inst_17757);
var inst_17848 = [inst_17847,vars,inst_17845];
var inst_17849 = cljs.core.PersistentHashMap.fromArrays(inst_17846,inst_17848);
var _ = (function (){var statearr_17872 = state_17854;
(statearr_17872[(4)] = cljs.core.rest.call(null,(state_17854[(4)])));

return statearr_17872;
})();
var state_17854__$1 = state_17854;
var statearr_17873_17924 = state_17854__$1;
(statearr_17873_17924[(2)] = inst_17849);

(statearr_17873_17924[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (2))){
var inst_17761 = (state_17854[(10)]);
var inst_17772 = (state_17854[(15)]);
var inst_17757 = (state_17854[(17)]);
var inst_17760 = (state_17854[(7)]);
var _ = (function (){var statearr_17874 = state_17854;
(statearr_17874[(4)] = cljs.core.cons.call(null,(5),(state_17854[(4)])));

return statearr_17874;
})();
var inst_17754 = fluree.db.query.analytical.clause__GT_rel.call(null,db,vars,clause);
var inst_17755 = cljs.core.__destructure_map.call(null,inst_17754);
var inst_17756 = cljs.core.get.call(null,inst_17755,new cljs.core.Keyword(null,"search","search",1564939822));
var inst_17757__$1 = cljs.core.get.call(null,inst_17755,new cljs.core.Keyword(null,"rel","rel",1378823488));
var inst_17758 = cljs.core.get.call(null,inst_17755,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_17759 = fluree.db.query.analytical.intersecting_keys_tuples_clause.call(null,res,clause);
var inst_17760__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_17758);
var inst_17761__$1 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_17758);
var inst_17763 = (function (){var map__17750 = inst_17755;
var search = inst_17756;
var rel = inst_17757__$1;
var opts = inst_17758;
var common_keys = inst_17759;
var object_fn = inst_17760__$1;
var recur_depth = inst_17761__$1;
return (function (p__17762,common_key){
var vec__17875 = p__17762;
var acc = cljs.core.nth.call(null,vec__17875,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.call(null,vec__17875,(1),null);
var idx_of = fluree.db.util.core.index_of.call(null,clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__17878 = cljs.core._EQ_;
var expr__17879 = idx_of;
if(cljs.core.truth_(pred__17878.call(null,(0),expr__17879))){
return new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441);
} else {
if(cljs.core.truth_(pred__17878.call(null,(1),expr__17879))){
return new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845);
} else {
if(cljs.core.truth_(pred__17878.call(null,(2),expr__17879))){
return new cljs.core.Keyword(null,"object-fn","object-fn",1425858481);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__17879)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of.call(null,headers,common_key);
var v = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,cljs.core.first,fluree.db.query.analytical.get_ns_arrays.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,v));
var v__$1 = (cljs.core.truth_((function (){var and__4221__auto__ = (!(single_v_QMARK_));
if(and__4221__auto__){
var and__4221__auto____$1 = object_fn;
if(cljs.core.truth_(and__4221__auto____$1)){
return cljs.core._EQ_.call(null,k,object_fn);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())?cljs.core.comp.call(null,v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.call(null,clause_SINGLEQUOTE_,idx_of,cljs.core.first.call(null,v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_17764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17765 = cljs.core.PersistentHashMap.EMPTY;
var inst_17766 = [inst_17765,inst_17756];
var inst_17767 = (new cljs.core.PersistentVector(null,2,(5),inst_17764,inst_17766,null));
var inst_17768 = cljs.core.reduce.call(null,inst_17763,inst_17767,inst_17759);
var inst_17769 = cljs.core.nth.call(null,inst_17768,(0),null);
var inst_17770 = cljs.core.nth.call(null,inst_17768,(1),null);
var inst_17771 = [new cljs.core.Keyword(null,"object-fn","object-fn",1425858481)];
var inst_17772__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(inst_17769);
var state_17854__$1 = (function (){var statearr_17881 = state_17854;
(statearr_17881[(10)] = inst_17761__$1);

(statearr_17881[(15)] = inst_17772__$1);

(statearr_17881[(13)] = inst_17770);

(statearr_17881[(18)] = inst_17771);

(statearr_17881[(17)] = inst_17757__$1);

(statearr_17881[(7)] = inst_17760__$1);

return statearr_17881;
})();
if(cljs.core.truth_(inst_17772__$1)){
var statearr_17882_17925 = state_17854__$1;
(statearr_17882_17925[(1)] = (6));

} else {
var statearr_17883_17926 = state_17854__$1;
(statearr_17883_17926[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (23))){
var inst_17788 = (state_17854[(8)]);
var inst_17825 = cljs.core.coll_QMARK_.call(null,inst_17788);
var state_17854__$1 = state_17854;
if(inst_17825){
var statearr_17884_17927 = state_17854__$1;
(statearr_17884_17927[(1)] = (25));

} else {
var statearr_17885_17928 = state_17854__$1;
(statearr_17885_17928[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (19))){
var inst_17786 = (state_17854[(14)]);
var inst_17816 = cljs.core.PersistentHashMap.EMPTY;
var inst_17817 = fluree.db.query.analytical.tuples__GT_map.call(null,inst_17816,inst_17786);
var state_17854__$1 = state_17854;
var statearr_17886_17929 = state_17854__$1;
(statearr_17886_17929[(2)] = inst_17817);

(statearr_17886_17929[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (11))){
var inst_17786 = (state_17854[(14)]);
var state_17854__$1 = state_17854;
var statearr_17888_17930 = state_17854__$1;
(statearr_17888_17930[(2)] = inst_17786);

(statearr_17888_17930[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (9))){
var inst_17761 = (state_17854[(10)]);
var inst_17782 = (state_17854[(16)]);
var inst_17757 = (state_17854[(17)]);
var inst_17781 = (state_17854[(2)]);
var inst_17782__$1 = fluree.db.util.async.throw_err.call(null,inst_17781);
var inst_17783 = cljs.core.count.call(null,inst_17782__$1);
var inst_17784 = fluree.db.query.analytical.add_fuel.call(null,inst_17783,fuel,max_fuel);
var inst_17785 = cljs.core.vals.call(null,inst_17757);
var inst_17786 = fluree.db.query.analytical.get_ns_arrays.call(null,inst_17785,inst_17782__$1);
var state_17854__$1 = (function (){var statearr_17889 = state_17854;
(statearr_17889[(16)] = inst_17782__$1);

(statearr_17889[(14)] = inst_17786);

(statearr_17889[(19)] = inst_17784);

return statearr_17889;
})();
if(cljs.core.truth_(inst_17761)){
var statearr_17890_17931 = state_17854__$1;
(statearr_17890_17931[(1)] = (10));

} else {
var statearr_17891_17932 = state_17854__$1;
(statearr_17891_17932[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (5))){
var _ = (function (){var statearr_17892 = state_17854;
(statearr_17892[(4)] = cljs.core.rest.call(null,(state_17854[(4)])));

return statearr_17892;
})();
var state_17854__$1 = state_17854;
var ex17887 = (state_17854__$1[(2)]);
var statearr_17893_17933 = state_17854__$1;
(statearr_17893_17933[(5)] = ex17887);


if((ex17887 instanceof Error)){
var statearr_17894_17934 = state_17854__$1;
(statearr_17894_17934[(1)] = (4));

(statearr_17894_17934[(5)] = null);

} else {
throw ex17887;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (14))){
var state_17854__$1 = state_17854;
var statearr_17895_17935 = state_17854__$1;
(statearr_17895_17935[(2)] = null);

(statearr_17895_17935[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (26))){
var state_17854__$1 = state_17854;
var statearr_17896_17936 = state_17854__$1;
(statearr_17896_17936[(2)] = null);

(statearr_17896_17936[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (16))){
var state_17854__$1 = state_17854;
var statearr_17897_17937 = state_17854__$1;
(statearr_17897_17937[(2)] = null);

(statearr_17897_17937[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (10))){
var inst_17770 = (state_17854[(13)]);
var inst_17791 = (state_17854[(12)]);
var inst_17788 = cljs.core.first.call(null,inst_17770);
var inst_17789 = cljs.core.first.call(null,clause);
var inst_17790 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_17789);
var inst_17791__$1 = cljs.core.nth.call(null,inst_17770,(1));
var inst_17792 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_17791__$1);
var state_17854__$1 = (function (){var statearr_17898 = state_17854;
(statearr_17898[(11)] = inst_17790);

(statearr_17898[(8)] = inst_17788);

(statearr_17898[(12)] = inst_17791__$1);

return statearr_17898;
})();
if(cljs.core.truth_(inst_17792)){
var statearr_17899_17938 = state_17854__$1;
(statearr_17899_17938[(1)] = (13));

} else {
var statearr_17900_17939 = state_17854__$1;
(statearr_17900_17939[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (18))){
var inst_17790 = (state_17854[(11)]);
var inst_17814 = (state_17854[(2)]);
var state_17854__$1 = (function (){var statearr_17901 = state_17854;
(statearr_17901[(20)] = inst_17814);

return statearr_17901;
})();
if(cljs.core.truth_(inst_17790)){
var statearr_17902_17940 = state_17854__$1;
(statearr_17902_17940[(1)] = (19));

} else {
var statearr_17903_17941 = state_17854__$1;
(statearr_17903_17941[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17855 === (8))){
var inst_17770 = (state_17854[(13)]);
var inst_17771 = (state_17854[(18)]);
var inst_17776 = (state_17854[(2)]);
var inst_17777 = [inst_17776];
var inst_17778 = cljs.core.PersistentHashMap.fromArrays(inst_17771,inst_17777);
var inst_17779 = fluree.db.query.range.search.call(null,db,inst_17770,inst_17778);
var state_17854__$1 = state_17854;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17854__$1,(9),inst_17779);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2726__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2726__auto____0 = (function (){
var statearr_17904 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17904[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2726__auto__);

(statearr_17904[(1)] = (1));

return statearr_17904;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2726__auto____1 = (function (state_17854){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_17854);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e17905){var ex__2729__auto__ = e17905;
var statearr_17906_17942 = state_17854;
(statearr_17906_17942[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_17854[(4)]))){
var statearr_17907_17943 = state_17854;
(statearr_17907_17943[(1)] = cljs.core.first.call(null,(state_17854[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17944 = state_17854;
state_17854 = G__17944;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2726__auto__ = function(state_17854){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2726__auto____1.call(this,state_17854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2726__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2726__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_17908 = f__2749__auto__.call(null);
(statearr_17908[(6)] = c__2748__auto__);

return statearr_17908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__17945,res,clause){
var map__17946 = p__17945;
var map__17946__$1 = cljs.core.__destructure_map.call(null,map__17946);
var db = map__17946__$1;
var conn = cljs.core.get.call(null,map__17946__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__17946__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__17946__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
throw cljs.core.ex_info.call(null,"Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_18045){
var state_val_18046 = (state_18045[(1)]);
if((state_val_18046 === (7))){
var inst_17956 = (state_18045[(7)]);
var state_18045__$1 = state_18045;
var statearr_18047_18087 = state_18045__$1;
(statearr_18047_18087[(2)] = inst_17956);

(statearr_18047_18087[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (20))){
var inst_18036 = (state_18045[(2)]);
var state_18045__$1 = state_18045;
var statearr_18048_18088 = state_18045__$1;
(statearr_18048_18088[(2)] = inst_18036);

(statearr_18048_18088[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (1))){
var state_18045__$1 = state_18045;
var statearr_18049_18089 = state_18045__$1;
(statearr_18049_18089[(2)] = null);

(statearr_18049_18089[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (24))){
var inst_18015 = (state_18045[(2)]);
var inst_18016 = fluree.db.util.async.throw_err.call(null,inst_18015);
var state_18045__$1 = state_18045;
var statearr_18050_18090 = state_18045__$1;
(statearr_18050_18090[(2)] = inst_18016);

(statearr_18050_18090[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (4))){
var inst_17949 = (state_18045[(2)]);
var state_18045__$1 = state_18045;
var statearr_18051_18091 = state_18045__$1;
(statearr_18051_18091[(2)] = inst_17949);

(statearr_18051_18091[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (15))){
var inst_17958 = (state_18045[(8)]);
var inst_17956 = (state_18045[(7)]);
var inst_17977 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_17978 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17980 = [inst_17956];
var inst_17981 = (new cljs.core.PersistentVector(null,1,(5),inst_17979,inst_17980,null));
var inst_17982 = (function (){var subject_var = inst_17956;
var object_var = inst_17958;
var min_sid = inst_17977;
var max_sid = (0);
return (function (p1__17947_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__17947_SHARP_);
});
})();
var inst_17983 = cljs.core.range.call(null,inst_17977,(0));
var inst_17984 = cljs.core.map.call(null,inst_17982,inst_17983);
var inst_17985 = cljs.core.PersistentHashMap.EMPTY;
var inst_17986 = [inst_17981,inst_17984,inst_17985];
var inst_17987 = cljs.core.PersistentHashMap.fromArrays(inst_17978,inst_17986);
var state_18045__$1 = state_18045;
var statearr_18052_18092 = state_18045__$1;
(statearr_18052_18092[(2)] = inst_17987);

(statearr_18052_18092[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (21))){
var inst_18009 = (state_18045[(9)]);
var state_18045__$1 = state_18045;
var statearr_18053_18093 = state_18045__$1;
(statearr_18053_18093[(2)] = inst_18009);

(statearr_18053_18093[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (13))){
var inst_17958 = (state_18045[(8)]);
var state_18045__$1 = state_18045;
if(cljs.core.truth_(inst_17958)){
var statearr_18054_18094 = state_18045__$1;
(statearr_18054_18094[(1)] = (18));

} else {
var statearr_18055_18095 = state_18045__$1;
(statearr_18055_18095[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (22))){
var inst_18009 = (state_18045[(9)]);
var inst_18013 = fluree.db.dbproto._subid.call(null,db,inst_18009);
var state_18045__$1 = state_18045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18045__$1,(24),inst_18013);
} else {
if((state_val_18046 === (6))){
var inst_17958 = (state_18045[(8)]);
var state_18045__$1 = state_18045;
var statearr_18056_18096 = state_18045__$1;
(statearr_18056_18096[(2)] = inst_17958);

(statearr_18056_18096[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (17))){
var inst_18006 = (state_18045[(2)]);
var state_18045__$1 = state_18045;
var statearr_18057_18097 = state_18045__$1;
(statearr_18057_18097[(2)] = inst_18006);

(statearr_18057_18097[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (3))){
var inst_18043 = (state_18045[(2)]);
var state_18045__$1 = state_18045;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18045__$1,inst_18043);
} else {
if((state_val_18046 === (12))){
var inst_17971 = ["_tx",null,"_block",null];
var inst_17972 = (new cljs.core.PersistentArrayMap(null,2,inst_17971,null));
var inst_17973 = (new cljs.core.PersistentHashSet(null,inst_17972,null));
var inst_17974 = cljs.core.last.call(null,clause);
var inst_17975 = inst_17973.call(null,inst_17974);
var state_18045__$1 = state_18045;
if(cljs.core.truth_(inst_17975)){
var statearr_18058_18098 = state_18045__$1;
(statearr_18058_18098[(1)] = (15));

} else {
var statearr_18059_18099 = state_18045__$1;
(statearr_18059_18099[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (2))){
var inst_17956 = (state_18045[(7)]);
var _ = (function (){var statearr_18060 = state_18045;
(statearr_18060[(4)] = cljs.core.cons.call(null,(5),(state_18045[(4)])));

return statearr_18060;
})();
var inst_17955 = cljs.core.first.call(null,clause);
var inst_17956__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_17955);
var inst_17957 = cljs.core.last.call(null,clause);
var inst_17958 = fluree.db.query.analytical.variable_QMARK_.call(null,inst_17957);
var state_18045__$1 = (function (){var statearr_18061 = state_18045;
(statearr_18061[(8)] = inst_17958);

(statearr_18061[(7)] = inst_17956__$1);

return statearr_18061;
})();
if(cljs.core.truth_(inst_17956__$1)){
var statearr_18062_18100 = state_18045__$1;
(statearr_18062_18100[(1)] = (6));

} else {
var statearr_18063_18101 = state_18045__$1;
(statearr_18063_18101[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (23))){
var inst_17958 = (state_18045[(8)]);
var inst_18018 = (state_18045[(2)]);
var inst_18019 = fluree.db.flake.sid__GT_cid.call(null,inst_18018);
var inst_18020 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_18019);
var inst_18021 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18023 = [inst_17958];
var inst_18024 = (new cljs.core.PersistentVector(null,1,(5),inst_18022,inst_18023,null));
var inst_18025 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18027 = [inst_18020];
var inst_18028 = (new cljs.core.PersistentVector(null,1,(5),inst_18026,inst_18027,null));
var inst_18029 = [inst_18028];
var inst_18030 = (new cljs.core.PersistentVector(null,1,(5),inst_18025,inst_18029,null));
var inst_18031 = cljs.core.PersistentHashMap.EMPTY;
var inst_18032 = [inst_18024,inst_18030,inst_18031];
var inst_18033 = cljs.core.PersistentHashMap.fromArrays(inst_18021,inst_18032);
var state_18045__$1 = state_18045;
var statearr_18064_18102 = state_18045__$1;
(statearr_18064_18102[(2)] = inst_18033);

(statearr_18064_18102[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (19))){
var state_18045__$1 = state_18045;
var statearr_18065_18103 = state_18045__$1;
(statearr_18065_18103[(2)] = null);

(statearr_18065_18103[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (11))){
var inst_18040 = (state_18045[(2)]);
var _ = (function (){var statearr_18067 = state_18045;
(statearr_18067[(4)] = cljs.core.rest.call(null,(state_18045[(4)])));

return statearr_18067;
})();
var state_18045__$1 = state_18045;
var statearr_18068_18104 = state_18045__$1;
(statearr_18068_18104[(2)] = inst_18040);

(statearr_18068_18104[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (9))){
var inst_17964 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_17965 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_17966 = cljs.core.PersistentHashMap.fromArrays(inst_17964,inst_17965);
var inst_17967 = cljs.core.ex_info.call(null,"When using rdf:type, either a subject or a type (collection) must be specified.",inst_17966);
var inst_17968 = (function(){throw inst_17967})();
var state_18045__$1 = state_18045;
var statearr_18069_18105 = state_18045__$1;
(statearr_18069_18105[(2)] = inst_17968);

(statearr_18069_18105[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (5))){
var _ = (function (){var statearr_18070 = state_18045;
(statearr_18070[(4)] = cljs.core.rest.call(null,(state_18045[(4)])));

return statearr_18070;
})();
var state_18045__$1 = state_18045;
var ex18066 = (state_18045__$1[(2)]);
var statearr_18071_18106 = state_18045__$1;
(statearr_18071_18106[(5)] = ex18066);


if((ex18066 instanceof Error)){
var statearr_18072_18107 = state_18045__$1;
(statearr_18072_18107[(1)] = (4));

(statearr_18072_18107[(5)] = null);

} else {
throw ex18066;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (14))){
var inst_18038 = (state_18045[(2)]);
var state_18045__$1 = state_18045;
var statearr_18073_18108 = state_18045__$1;
(statearr_18073_18108[(2)] = inst_18038);

(statearr_18073_18108[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (16))){
var inst_17958 = (state_18045[(8)]);
var inst_17956 = (state_18045[(7)]);
var inst_17989 = cljs.core.last.call(null,clause);
var inst_17990 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"partition","partition",1174740751),inst_17989);
var inst_17991 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_17992 = cljs.core.get.call(null,inst_17991,inst_17990);
var inst_17993 = fluree.db.flake.min_subject_id.call(null,inst_17990);
var inst_17994 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"tuples","tuples",-676032639),new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_17995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_17996 = [inst_17956];
var inst_17997 = (new cljs.core.PersistentVector(null,1,(5),inst_17995,inst_17996,null));
var inst_17998 = (function (){var subject_var = inst_17956;
var object_var = inst_17958;
var partition = inst_17990;
var max_sid = inst_17992;
var min_sid = inst_17993;
return (function (p1__17948_SHARP_){
return cljs.core.conj.call(null,cljs.core.PersistentVector.EMPTY,p1__17948_SHARP_);
});
})();
var inst_17999 = (inst_17992 + (1));
var inst_18000 = cljs.core.range.call(null,inst_17993,inst_17999);
var inst_18001 = cljs.core.map.call(null,inst_17998,inst_18000);
var inst_18002 = cljs.core.PersistentHashMap.EMPTY;
var inst_18003 = [inst_17997,inst_18001,inst_18002];
var inst_18004 = cljs.core.PersistentHashMap.fromArrays(inst_17994,inst_18003);
var state_18045__$1 = state_18045;
var statearr_18074_18109 = state_18045__$1;
(statearr_18074_18109[(2)] = inst_18004);

(statearr_18074_18109[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (10))){
var inst_17956 = (state_18045[(7)]);
var state_18045__$1 = state_18045;
if(cljs.core.truth_(inst_17956)){
var statearr_18075_18110 = state_18045__$1;
(statearr_18075_18110[(1)] = (12));

} else {
var statearr_18076_18111 = state_18045__$1;
(statearr_18076_18111[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (18))){
var inst_18009 = (state_18045[(9)]);
var inst_18009__$1 = cljs.core.first.call(null,clause);
var inst_18010 = typeof inst_18009__$1 === 'number';
var state_18045__$1 = (function (){var statearr_18077 = state_18045;
(statearr_18077[(9)] = inst_18009__$1);

return statearr_18077;
})();
if(cljs.core.truth_(inst_18010)){
var statearr_18078_18112 = state_18045__$1;
(statearr_18078_18112[(1)] = (21));

} else {
var statearr_18079_18113 = state_18045__$1;
(statearr_18079_18113[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18046 === (8))){
var inst_17962 = (state_18045[(2)]);
var state_18045__$1 = state_18045;
if(cljs.core.truth_(inst_17962)){
var statearr_18080_18114 = state_18045__$1;
(statearr_18080_18114[(1)] = (9));

} else {
var statearr_18081_18115 = state_18045__$1;
(statearr_18081_18115[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2726__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2726__auto____0 = (function (){
var statearr_18082 = [null,null,null,null,null,null,null,null,null,null];
(statearr_18082[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2726__auto__);

(statearr_18082[(1)] = (1));

return statearr_18082;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2726__auto____1 = (function (state_18045){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_18045);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e18083){var ex__2729__auto__ = e18083;
var statearr_18084_18116 = state_18045;
(statearr_18084_18116[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_18045[(4)]))){
var statearr_18085_18117 = state_18045;
(statearr_18085_18117[(1)] = cljs.core.first.call(null,(state_18045[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18118 = state_18045;
state_18045 = G__18118;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2726__auto__ = function(state_18045){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2726__auto____1.call(this,state_18045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2726__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2726__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_18086 = f__2749__auto__.call(null);
(statearr_18086[(6)] = c__2748__auto__);

return statearr_18086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.call(null,cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum.call(null,coll) / cljs.core.count.call(null,coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.call(null,coll);
var size = cljs.core.count.call(null,coll);
var med = (size >> (1));
var G__18124 = cljs.core.nth.call(null,terms,med);
if(cljs.core.even_QMARK_.call(null,size)){
return ((G__18124 + cljs.core.nth.call(null,terms,(med - (1)))) / (2));
} else {
return G__18124;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg.call(null,coll);
var sum__$1 = sum.call(null,(function (){var iter__4622__auto__ = (function fluree$db$query$analytical$variance_$_iter__18125(s__18126){
return (new cljs.core.LazySeq(null,(function (){
var s__18126__$1 = s__18126;
while(true){
var temp__5753__auto__ = cljs.core.seq.call(null,s__18126__$1);
if(temp__5753__auto__){
var s__18126__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__18126__$2)){
var c__4620__auto__ = cljs.core.chunk_first.call(null,s__18126__$2);
var size__4621__auto__ = cljs.core.count.call(null,c__4620__auto__);
var b__18128 = cljs.core.chunk_buffer.call(null,size__4621__auto__);
if((function (){var i__18127 = (0);
while(true){
if((i__18127 < size__4621__auto__)){
var x = cljs.core._nth.call(null,c__4620__auto__,i__18127);
var delta = (x - mean);
cljs.core.chunk_append.call(null,b__18128,(delta * delta));

var G__18129 = (i__18127 + (1));
i__18127 = G__18129;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18128),fluree$db$query$analytical$variance_$_iter__18125.call(null,cljs.core.chunk_rest.call(null,s__18126__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__18128),null);
}
} else {
var x = cljs.core.first.call(null,s__18126__$2);
var delta = (x - mean);
return cljs.core.cons.call(null,(delta * delta),fluree$db$query$analytical$variance_$_iter__18125.call(null,cljs.core.rest.call(null,s__18126__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__.call(null,coll);
})());
return (sum__$1 / cljs.core.count.call(null,coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
return Math.sqrt(variance.call(null,coll));
});
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"variance","variance",-1522424942,null),new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.Symbol(null,"median","median",-2084869638,null),new cljs.core.Symbol(null,"groupconcat","groupconcat",-736310912,null),new cljs.core.Symbol(null,"sum","sum",1777518341,null),new cljs.core.Symbol(null,"abs","abs",1394505050,null),new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"count-distinct","count-distinct",-1566572514,null),new cljs.core.Symbol(null,"avg","avg",1837937727,null),new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.Symbol(null,"stddev","stddev",775056588,null),new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.Symbol(null,"sample","sample",1719555128,null)],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4306__auto__ = n;
var y__4307__auto__ = (- n);
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
}),(function() {
var G__18130 = null;
var G__18130__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__18130__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.last.call(null,acc)) < (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.butlast.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__18130 = function(n,coll){
switch(arguments.length){
case 1:
return G__18130__1.call(this,n);
case 2:
return G__18130__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18130.cljs$core$IFn$_invoke$arity$1 = G__18130__1;
G__18130.cljs$core$IFn$_invoke$arity$2 = G__18130__2;
return G__18130;
})()
,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__18131 = null;
var G__18131__1 = (function (coll){
return cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.compare.call(null,x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first.call(null,coll),cljs.core.next.call(null,coll));
});
var G__18131__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.reduce.call(null,(function (acc,x){
if((cljs.core.count.call(null,acc) < n)){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,acc,x));
} else {
if((cljs.core.compare.call(null,x,cljs.core.first.call(null,acc)) > (0))){
return cljs.core.sort.call(null,cljs.core.compare,cljs.core.conj.call(null,cljs.core.next.call(null,acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__18131 = function(n,coll){
switch(arguments.length){
case 1:
return G__18131__1.call(this,n);
case 2:
return G__18131__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18131.cljs$core$IFn$_invoke$arity$1 = G__18131__1;
G__18131.cljs$core$IFn$_invoke$arity$2 = G__18131__2;
return G__18131;
})()
,(function (coll){
return cljs.core.count.call(null,cljs.core.distinct.call(null,coll));
}),avg,(function (n){
if(cljs.core._EQ_.call(null,n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__18132 = null;
var G__18132__1 = (function (coll){
return cljs.core.rand_nth.call(null,coll);
});
var G__18132__2 = (function (n,coll){
return cljs.core.vec.call(null,cljs.core.repeatedly.call(null,n,(function (){
return cljs.core.rand_nth.call(null,coll);
})));
});
G__18132 = function(n,coll){
switch(arguments.length){
case 1:
return G__18132__1.call(this,n);
case 2:
return G__18132__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__18132.cljs$core$IFn$_invoke$arity$1 = G__18132__1;
G__18132.cljs$core$IFn$_invoke$arity$2 = G__18132__2;
return G__18132;
})()
,(function (n,coll){
return cljs.core.vec.call(null,cljs.core.take.call(null,n,cljs.core.shuffle.call(null,coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches.call(null,/^\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches.call(null,/^#\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.call(null,x);
var as_QMARK_ = cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"as","as",-1505746128,null),cljs.core.first.call(null,list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,list_agg))].join('')):cljs.core.symbol.call(null,["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second.call(null,list_agg);
if(cljs.core.coll_QMARK_.call(null,func_list)){
return func_list;
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})():list_agg);
var list_count = cljs.core.count.call(null,func_list);
var vec__18133 = ((cljs.core._EQ_.call(null,(3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),cljs.core.second.call(null,func_list),cljs.core.last.call(null,func_list)], null):((((cljs.core._EQ_.call(null,(2),list_count)) && (cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"sample","sample",1719555128,null),cljs.core.first.call(null,func_list)))))?(function(){throw cljs.core.ex_info.call(null,["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():((cljs.core._EQ_.call(null,(2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,func_list),null,cljs.core.last.call(null,func_list)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var fun = cljs.core.nth.call(null,vec__18133,(0),null);
var arg = cljs.core.nth.call(null,vec__18133,(1),null);
var var$ = cljs.core.nth.call(null,vec__18133,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = fluree.db.query.analytical.built_in_aggregates.call(null,fun);
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return agg_fn.call(null,arg,coll);
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.call(null,["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vec__18136 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_.call(null,var$)) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,var$),new cljs.core.Symbol(null,"distinct","distinct",-148347594,null))));
var variable = ((distinct_QMARK_)?cljs.core.second.call(null,var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
return agg_fn.call(null,cljs.core.distinct.call(null,coll));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.call(null,vec__18136,(0),null);
var variable = cljs.core.nth.call(null,vec__18136,(1),null);
var _ = (cljs.core.truth_(valid_var.call(null,variable))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"variable","variable",-281346492),variable,new cljs.core.Keyword(null,"as","as",1148689641),as,new cljs.core.Keyword(null,"code","code",1586293142),agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__18139 = agg;
var map__18139__$1 = cljs.core.__destructure_map.call(null,map__18139);
var variable = cljs.core.get.call(null,map__18139__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var as = cljs.core.get.call(null,map__18139__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var code = cljs.core.get.call(null,map__18139__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var agg_params = cljs.core.flatten.call(null,fluree.db.query.analytical.select_from_tuples.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = code.call(null,agg_params);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.call(null,(function (res__$1,agg){
var vec__18141 = fluree.db.query.analytical.calculate_aggregate.call(null,res__$1,agg);
var as = cljs.core.nth.call(null,vec__18141,(0),null);
var agg_result = cljs.core.nth.call(null,vec__18141,(1),null);
var map__18144 = res__$1;
var map__18144__$1 = cljs.core.__destructure_map.call(null,map__18144);
var headers = cljs.core.get.call(null,map__18144__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__18144__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__18140_SHARP_){
return cljs.core.conj.call(null,cljs.core.vec.call(null,p1__18140_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,cljs.core.vec.call(null,headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.call(null,cljs.core.symbol,cljs.core.keys.call(null,q_map));
var vals = cljs.core.vals.call(null,q_map);
return cljs.core.zipmap.call(null,keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.call(null,(function (acc,tuple){
var b_compare = cljs.core.map.call(null,(function (p1__18145_SHARP_){
return cljs.core.nth.call(null,tuple,p1__18145_SHARP_);
}),b_idxs);
return cljs.core.update.call(null,acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq.call(null,cljs.core.reduce.call(null,(function (acc,a_tuple){
var a_compare = cljs.core.map.call(null,(function (p1__18146_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__18146_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.call(null,b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.call(null,(function (p1__18147_SHARP_,p2__18148_SHARP_){
return cljs.core.conj.call(null,p1__18147_SHARP_,cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (idx){
return cljs.core.nth.call(null,p2__18148_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.call(null,acc,cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.call(null,(function (p1__18149_SHARP_){
return cljs.core.nth.call(null,a_tuple,p1__18149_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv.call(null,(function (p__18152,row,b_tuple){
var vec__18153 = p__18152;
var acc = cljs.core.nth.call(null,vec__18153,(0),null);
var b_rows = cljs.core.nth.call(null,vec__18153,(1),null);
if(cljs.core._EQ_.call(null,a_tuple_part,cljs.core.map.call(null,(function (p1__18150_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__18150_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,(function (){var or__4223__auto__ = acc;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.call(null,a_tuple,cljs.core.map.call(null,(function (p1__18151_SHARP_){
return cljs.core.nth.call(null,b_tuple,p1__18151_SHARP_);
}),b_not_idxs))),cljs.core.conj.call(null,b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_res,b_res);
var a_idxs = cljs.core.map.call(null,(function (p1__18156_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),p1__18156_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__18157_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__18157_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__18159_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__18159_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__18158_SHARP_){
return cljs.core.range.call(null,(0),p1__18158_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.call(null,(function (p1__18160_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_res),p1__18160_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_res),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_res)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__18161_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__18161_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__18162_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__18162_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__18164_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__18164_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__18163_SHARP_){
return cljs.core.range.call(null,(0),p1__18163_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var c_tuples = fluree.db.query.analytical.match_tuples_lists.call(null,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__18165_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__18165_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples.call(null,a_tuples,b_tuples);
var a_idxs = cljs.core.map.call(null,(function (p1__18166_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),p1__18166_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.call(null,(function (p1__18167_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__18167_SHARP_);
}),common_keys);
var b_not_idxs = (function (p1__18169_SHARP_){
return cljs.core.apply.call(null,cljs.core.vector,p1__18169_SHARP_);
}).call(null,clojure.set.difference.call(null,cljs.core.set.call(null,(function (p1__18168_SHARP_){
return cljs.core.range.call(null,(0),p1__18168_SHARP_);
}).call(null,cljs.core.count.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples)))),cljs.core.set.call(null,b_idxs)));
var vec__18172 = cljs.core.reduce.call(null,(function (p__18175,a_tuple){
var vec__18176 = p__18175;
var c_tuples = cljs.core.nth.call(null,vec__18176,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__18176,(1),null);
var vec__18179 = fluree.db.query.analytical.find_match_PLUS_row_nums.call(null,a_tuple,a_idxs,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.call(null,vec__18179,(0),null);
var matched_rows = cljs.core.nth.call(null,vec__18179,(1),null);
var matches__$1 = (function (){var or__4223__auto__ = matches;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.call(null,a_tuple,cljs.core.repeat.call(null,cljs.core.count.call(null,b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.call(null,cljs.core.vec.call(null,c_tuples),matches__$1),clojure.set.union.call(null,b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.call(null,vec__18172,(0),null);
var b_matched_rows = cljs.core.nth.call(null,vec__18172,(1),null);
var b_unmatched_rows = cljs.core.remove.call(null,b_matched_rows,cljs.core.range.call(null,(0),cljs.core.count.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.call(null,(function (p1__18170_SHARP_){
return cljs.core.nth.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__18170_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.call(null,(function (p1__18171_SHARP_){
return fluree.db.util.core.index_of.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(b_tuples),p1__18171_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.call(null,(function (b_row){
var b_tuple = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,cljs.core.nth.call(null,new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.call(null,(function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.call(null,b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.call(null,c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),c_headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge.call(null,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(a_tuples),new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(b_tuples)),new cljs.core.Keyword(null,"tuples","tuples",-676032639),c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.call(null," ",filter_code_req),")"].join('');
var vec__18183 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.call(null,vec__18183,(0),null);
var _ = cljs.core.nth.call(null,vec__18183,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.call(null,(function (p1__18182_SHARP_){
return fluree.db.query.analytical_filter.filter_row.call(null,headers,p1__18182_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.call(null,(function (tuples__$1,filt){
var var_atom = cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY);
var vec__18188 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.call(null,filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var filt_STAR_ = cljs.core.nth.call(null,vec__18188,(0),null);
var filt_vars = cljs.core.nth.call(null,vec__18188,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.call(null,(function (p1__18186_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__18186_SHARP_);
}),cljs.core.deref.call(null,filt_vars));
var filtered_tuples = cljs.core.reduce.call(null,(function (acc,clause){
if(cljs.core.every_QMARK_.call(null,(function (p1__18187_SHARP_){
return cljs.core.nth.call(null,clause,p1__18187_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row.call(null,headers,clause,filt_str))){
return cljs.core.conj.call(null,acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.call(null,acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__18191,filters,optional_QMARK_){
var map__18192 = p__18191;
var map__18192__$1 = cljs.core.__destructure_map.call(null,map__18192);
var tuple_map = map__18192__$1;
var headers = cljs.core.get.call(null,map__18192__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__18192__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var tuples = cljs.core.get.call(null,map__18192__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var valid_vars = cljs.core.set.call(null,headers);
var header_vec = cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.call(null,["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters.call(null,filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required.call(null,header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters.call(null,filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty.call(null,filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional.call(null,header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),vars,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__18193 = clause;
var k = cljs.core.nth.call(null,vec__18193,(0),null);
var v = cljs.core.nth.call(null,vec__18193,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_.call(null,k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.call(null,["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var map__18196 = res;
var map__18196__$1 = cljs.core.__destructure_map.call(null,map__18196);
var headers = cljs.core.get.call(null,map__18196__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__18196__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_.call(null,v))?cljs.core.second.call(null,fluree.db.query.analytical.calculate_aggregate.call(null,res,fluree.db.query.analytical.parse_aggregate.call(null,cljs.core.subs.call(null,v,(1)),cljs.core.set.call(null,(function (){var temp__5751__auto__ = cljs.core.keys.call(null,vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.call(null,headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_18252){
var state_val_18253 = (state_18252[(1)]);
if((state_val_18253 === (7))){
var inst_18226 = (state_18252[(7)]);
var inst_18224 = (state_18252[(2)]);
var inst_18225 = fluree.db.util.async.throw_err.call(null,inst_18224);
var inst_18226__$1 = cljs.core.nth.call(null,inst_18225,(0),null);
var inst_18227 = cljs.core.nth.call(null,inst_18225,(1),null);
var inst_18228 = (inst_18226__$1 == null);
var state_18252__$1 = (function (){var statearr_18254 = state_18252;
(statearr_18254[(8)] = inst_18227);

(statearr_18254[(7)] = inst_18226__$1);

return statearr_18254;
})();
if(cljs.core.truth_(inst_18228)){
var statearr_18255_18284 = state_18252__$1;
(statearr_18255_18284[(1)] = (8));

} else {
var statearr_18256_18285 = state_18252__$1;
(statearr_18256_18285[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (1))){
var inst_18204 = optional_clauses;
var inst_18205 = cljs.core.seq.call(null,inst_18204);
var inst_18206 = cljs.core.first.call(null,inst_18205);
var inst_18207 = cljs.core.next.call(null,inst_18205);
var inst_18208 = where_tuples;
var inst_18209 = inst_18204;
var inst_18210 = inst_18208;
var state_18252__$1 = (function (){var statearr_18257 = state_18252;
(statearr_18257[(9)] = inst_18209);

(statearr_18257[(10)] = inst_18207);

(statearr_18257[(11)] = inst_18206);

(statearr_18257[(12)] = inst_18210);

return statearr_18257;
})();
var statearr_18258_18286 = state_18252__$1;
(statearr_18258_18286[(2)] = null);

(statearr_18258_18286[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (4))){
var inst_18216 = (state_18252[(13)]);
var inst_18210 = (state_18252[(12)]);
var inst_18217 = (state_18252[(14)]);
var inst_18222 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_18210,inst_18216,inst_18217,true,fuel,max_fuel,opts);
var state_18252__$1 = state_18252;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18252__$1,(7),inst_18222);
} else {
if((state_val_18253 === (15))){
var state_18252__$1 = state_18252;
var statearr_18259_18287 = state_18252__$1;
(statearr_18259_18287[(2)] = null);

(statearr_18259_18287[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (13))){
var inst_18243 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18260_18288 = state_18252__$1;
(statearr_18260_18288[(2)] = inst_18243);

(statearr_18260_18288[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (6))){
var inst_18248 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18261_18289 = state_18252__$1;
(statearr_18261_18289[(2)] = inst_18248);

(statearr_18261_18289[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (3))){
var inst_18250 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18252__$1,inst_18250);
} else {
if((state_val_18253 === (12))){
var state_18252__$1 = state_18252;
var statearr_18262_18290 = state_18252__$1;
(statearr_18262_18290[(1)] = (14));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (2))){
var inst_18209 = (state_18252[(9)]);
var inst_18216 = (state_18252[(13)]);
var inst_18215 = cljs.core.seq.call(null,inst_18209);
var inst_18216__$1 = cljs.core.first.call(null,inst_18215);
var inst_18217 = cljs.core.next.call(null,inst_18215);
var state_18252__$1 = (function (){var statearr_18264 = state_18252;
(statearr_18264[(13)] = inst_18216__$1);

(statearr_18264[(14)] = inst_18217);

return statearr_18264;
})();
if(cljs.core.truth_(inst_18216__$1)){
var statearr_18265_18291 = state_18252__$1;
(statearr_18265_18291[(1)] = (4));

} else {
var statearr_18266_18292 = state_18252__$1;
(statearr_18266_18292[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (11))){
var inst_18227 = (state_18252[(8)]);
var inst_18226 = (state_18252[(7)]);
var inst_18209 = inst_18227;
var inst_18210 = inst_18226;
var state_18252__$1 = (function (){var statearr_18267 = state_18252;
(statearr_18267[(9)] = inst_18209);

(statearr_18267[(12)] = inst_18210);

return statearr_18267;
})();
var statearr_18268_18293 = state_18252__$1;
(statearr_18268_18293[(2)] = null);

(statearr_18268_18293[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (9))){
var inst_18216 = (state_18252[(13)]);
var inst_18232 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(inst_18216);
var state_18252__$1 = state_18252;
if(cljs.core.truth_(inst_18232)){
var statearr_18269_18294 = state_18252__$1;
(statearr_18269_18294[(1)] = (11));

} else {
var statearr_18270_18295 = state_18252__$1;
(statearr_18270_18295[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (5))){
var inst_18210 = (state_18252[(12)]);
var state_18252__$1 = state_18252;
var statearr_18271_18296 = state_18252__$1;
(statearr_18271_18296[(2)] = inst_18210);

(statearr_18271_18296[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (14))){
var inst_18210 = (state_18252[(12)]);
var inst_18227 = (state_18252[(8)]);
var inst_18226 = (state_18252[(7)]);
var inst_18237 = fluree.db.query.analytical.left_outer_join.call(null,inst_18210,inst_18226);
var inst_18209 = inst_18227;
var inst_18210__$1 = inst_18237;
var state_18252__$1 = (function (){var statearr_18272 = state_18252;
(statearr_18272[(9)] = inst_18209);

(statearr_18272[(12)] = inst_18210__$1);

return statearr_18272;
})();
var statearr_18273_18297 = state_18252__$1;
(statearr_18273_18297[(2)] = null);

(statearr_18273_18297[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (16))){
var inst_18241 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18275_18298 = state_18252__$1;
(statearr_18275_18298[(2)] = inst_18241);

(statearr_18275_18298[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (10))){
var inst_18245 = (state_18252[(2)]);
var state_18252__$1 = state_18252;
var statearr_18276_18299 = state_18252__$1;
(statearr_18276_18299[(2)] = inst_18245);

(statearr_18276_18299[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18253 === (8))){
var inst_18210 = (state_18252[(12)]);
var inst_18227 = (state_18252[(8)]);
var tmp18274 = inst_18210;
var inst_18209 = inst_18227;
var inst_18210__$1 = tmp18274;
var state_18252__$1 = (function (){var statearr_18277 = state_18252;
(statearr_18277[(9)] = inst_18209);

(statearr_18277[(12)] = inst_18210__$1);

return statearr_18277;
})();
var statearr_18278_18300 = state_18252__$1;
(statearr_18278_18300[(2)] = null);

(statearr_18278_18300[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2726__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2726__auto____0 = (function (){
var statearr_18279 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18279[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2726__auto__);

(statearr_18279[(1)] = (1));

return statearr_18279;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2726__auto____1 = (function (state_18252){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_18252);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e18280){var ex__2729__auto__ = e18280;
var statearr_18281_18301 = state_18252;
(statearr_18281_18301[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_18252[(4)]))){
var statearr_18282_18302 = state_18252;
(statearr_18282_18302[(1)] = cljs.core.first.call(null,(state_18252[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18303 = state_18252;
state_18252 = G__18303;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2726__auto__ = function(state_18252){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2726__auto____1.call(this,state_18252);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2726__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2726__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_18283 = f__2749__auto__.call(null);
(statearr_18283[(6)] = c__2748__auto__);

return statearr_18283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.call(null,(function (acc,p__18305){
var vec__18306 = p__18305;
var var_name = cljs.core.nth.call(null,vec__18306,(0),null);
var var_val = cljs.core.nth.call(null,vec__18306,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.call(null,(function (p1__18304_SHARP_){
return cljs.core.conj.call(null,p1__18304_SHARP_,var_val);
}),new cljs.core.Keyword(null,"tuples","tuples",-676032639).cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples_SINGLEQUOTE_,new cljs.core.Keyword(null,"headers","headers",-835030129),headers_SINGLEQUOTE_], null);
}),res,new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__18310,p__18311,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__18312 = p__18310;
var map__18312__$1 = cljs.core.__destructure_map.call(null,map__18312);
var q_map = map__18312__$1;
var prefixes = cljs.core.get.call(null,map__18312__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var map__18313 = p__18311;
var map__18313__$1 = cljs.core.__destructure_map.call(null,map__18313);
var res = map__18313__$1;
var vars = cljs.core.get.call(null,map__18313__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_18526){
var state_val_18527 = (state_18526[(1)]);
if((state_val_18527 === (65))){
var inst_18495 = (state_18526[(7)]);
var inst_18498 = (state_18526[(2)]);
var inst_18499 = fluree.db.util.async.throw_err.call(null,inst_18498);
var inst_18500 = [inst_18499,r];
var inst_18501 = (new cljs.core.PersistentVector(null,2,(5),inst_18495,inst_18500,null));
var state_18526__$1 = state_18526;
var statearr_18528_18625 = state_18526__$1;
(statearr_18528_18625[(2)] = inst_18501);

(statearr_18528_18625[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (62))){
var inst_18477 = (state_18526[(8)]);
var inst_18478 = (state_18526[(9)]);
var inst_18495 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18496 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,inst_18477,res,inst_18478,fuel,max_fuel);
var state_18526__$1 = (function (){var statearr_18529 = state_18526;
(statearr_18529[(7)] = inst_18495);

return statearr_18529;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18526__$1,(65),inst_18496);
} else {
if((state_val_18527 === (7))){
var inst_18419 = (state_18526[(10)]);
var inst_18418 = cljs.core.count.call(null,clause);
var inst_18419__$1 = cljs.core._EQ_.call(null,(3),inst_18418);
var state_18526__$1 = (function (){var statearr_18530 = state_18526;
(statearr_18530[(10)] = inst_18419__$1);

return statearr_18530;
})();
if(inst_18419__$1){
var statearr_18531_18626 = state_18526__$1;
(statearr_18531_18626[(1)] = (31));

} else {
var statearr_18532_18627 = state_18526__$1;
(statearr_18532_18627[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (59))){
var inst_18477 = (state_18526[(8)]);
var inst_18478 = (state_18526[(9)]);
var inst_18489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18490 = fluree.db.query.analytical.full_text__GT_tuples.call(null,inst_18477,res,inst_18478);
var inst_18491 = [inst_18490,r];
var inst_18492 = (new cljs.core.PersistentVector(null,2,(5),inst_18489,inst_18491,null));
var state_18526__$1 = state_18526;
var statearr_18533_18628 = state_18526__$1;
(statearr_18533_18628[(2)] = inst_18492);

(statearr_18533_18628[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (20))){
var inst_18382 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18534_18629 = state_18526__$1;
(statearr_18534_18629[(2)] = inst_18382);

(statearr_18534_18629[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (58))){
var inst_18483 = (state_18526[(2)]);
var inst_18484 = fluree.db.util.async.throw_err.call(null,inst_18483);
var state_18526__$1 = state_18526;
var statearr_18535_18630 = state_18526__$1;
(statearr_18535_18630[(2)] = inst_18484);

(statearr_18535_18630[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (60))){
var state_18526__$1 = state_18526;
var statearr_18536_18631 = state_18526__$1;
(statearr_18536_18631[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (27))){
var inst_18412 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18538_18632 = state_18526__$1;
(statearr_18538_18632[(2)] = inst_18412);

(statearr_18538_18632[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (1))){
var state_18526__$1 = state_18526;
var statearr_18539_18633 = state_18526__$1;
(statearr_18539_18633[(2)] = null);

(statearr_18539_18633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (24))){
var inst_18376 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18540_18634 = state_18526__$1;
(statearr_18540_18634[(2)] = inst_18376);

(statearr_18540_18634[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (55))){
var inst_18478 = (state_18526[(9)]);
var inst_18481 = fluree.db.query.analytical.wikidata__GT_tuples.call(null,q_map,inst_18478,r,res,optional_QMARK_,fuel,max_fuel);
var state_18526__$1 = state_18526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18526__$1,(58),inst_18481);
} else {
if((state_val_18527 === (39))){
var inst_18439 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
if(cljs.core.truth_(inst_18439)){
var statearr_18541_18635 = state_18526__$1;
(statearr_18541_18635[(1)] = (40));

} else {
var statearr_18542_18636 = state_18526__$1;
(statearr_18542_18636[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (46))){
var inst_18515 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18543_18637 = state_18526__$1;
(statearr_18543_18637[(2)] = inst_18515);

(statearr_18543_18637[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (4))){
var inst_18314 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18544_18638 = state_18526__$1;
(statearr_18544_18638[(2)] = inst_18314);

(statearr_18544_18638[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (54))){
var inst_18477 = (state_18526[(8)]);
var inst_18475 = (state_18526[(2)]);
var inst_18476 = fluree.db.util.async.throw_err.call(null,inst_18475);
var inst_18477__$1 = cljs.core.nth.call(null,inst_18476,(0),null);
var inst_18478 = cljs.core.nth.call(null,inst_18476,(1),null);
var inst_18479 = cljs.core._EQ_.call(null,"$wd",inst_18477__$1);
var state_18526__$1 = (function (){var statearr_18545 = state_18526;
(statearr_18545[(8)] = inst_18477__$1);

(statearr_18545[(9)] = inst_18478);

return statearr_18545;
})();
if(inst_18479){
var statearr_18546_18639 = state_18526__$1;
(statearr_18546_18639[(1)] = (55));

} else {
var statearr_18547_18640 = state_18526__$1;
(statearr_18547_18640[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (15))){
var inst_18414 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18548_18641 = state_18526__$1;
(statearr_18548_18641[(2)] = inst_18414);

(statearr_18548_18641[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (48))){
var inst_18463 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18464 = fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,clause);
var inst_18465 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_18464);
var inst_18466 = [inst_18465,r];
var inst_18467 = (new cljs.core.PersistentVector(null,2,(5),inst_18463,inst_18466,null));
var state_18526__$1 = state_18526;
var statearr_18549_18642 = state_18526__$1;
(statearr_18549_18642[(2)] = inst_18467);

(statearr_18549_18642[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (50))){
var inst_18513 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18550_18643 = state_18526__$1;
(statearr_18550_18643[(2)] = inst_18513);

(statearr_18550_18643[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (21))){
var inst_18327 = (state_18526[(11)]);
var inst_18323 = (state_18526[(12)]);
var inst_18353 = (state_18526[(13)]);
var inst_18359 = (state_18526[(14)]);
var inst_18360 = (state_18526[(15)]);
var inst_18350 = (state_18526[(16)]);
var inst_18351 = (state_18526[(17)]);
var inst_18348 = (state_18526[(18)]);
var inst_18352 = (state_18526[(19)]);
var inst_18364 = (state_18526[(2)]);
var inst_18365 = fluree.db.util.async.throw_err.call(null,inst_18364);
var inst_18366 = (function (){var pred__18324 = inst_18327;
var new_res = inst_18365;
var rest = inst_18360;
var seq__18346 = inst_18351;
var expr__18325 = inst_18323;
var tuples = inst_18353;
var seq__18356 = inst_18360;
var first__18347 = inst_18350;
var G__18344 = inst_18352;
var segment_type = inst_18323;
var first__18357 = inst_18359;
var vec__18355 = inst_18352;
var vec__18345 = inst_18348;
var clause_group = inst_18359;
return (function (res__$1,var$){
return cljs.core.update.call(null,new_res,new cljs.core.Keyword(null,"var","var",-769682797),cljs.core.dissoc,var$);
});
})();
var inst_18367 = cljs.core.keys.call(null,vars);
var inst_18368 = cljs.core.reduce.call(null,inst_18366,inst_18365,inst_18367);
var inst_18369 = fluree.db.query.analytical.res_absorb_vars.call(null,inst_18368);
var state_18526__$1 = (function (){var statearr_18551 = state_18526;
(statearr_18551[(20)] = inst_18369);

return statearr_18551;
})();
if(cljs.core.truth_(inst_18353)){
var statearr_18552_18644 = state_18526__$1;
(statearr_18552_18644[(1)] = (22));

} else {
var statearr_18553_18645 = state_18526__$1;
(statearr_18553_18645[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (31))){
var inst_18421 = cljs.core.second.call(null,clause);
var inst_18422 = clojure.string.starts_with_QMARK_.call(null,inst_18421,"fullText:");
var state_18526__$1 = state_18526;
var statearr_18554_18646 = state_18526__$1;
(statearr_18554_18646[(2)] = inst_18422);

(statearr_18554_18646[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (32))){
var inst_18419 = (state_18526[(10)]);
var state_18526__$1 = state_18526;
var statearr_18555_18647 = state_18526__$1;
(statearr_18555_18647[(2)] = inst_18419);

(statearr_18555_18647[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (40))){
var inst_18441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18442 = fluree.db.query.analytical.collection__GT_tuples.call(null,db,res,clause);
var state_18526__$1 = (function (){var statearr_18556 = state_18526;
(statearr_18556[(21)] = inst_18441);

return statearr_18556;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18526__$1,(43),inst_18442);
} else {
if((state_val_18527 === (56))){
var inst_18478 = (state_18526[(9)]);
var inst_18486 = cljs.core.second.call(null,inst_18478);
var inst_18487 = clojure.string.starts_with_QMARK_.call(null,inst_18486,"fullText:");
var state_18526__$1 = state_18526;
if(inst_18487){
var statearr_18557_18648 = state_18526__$1;
(statearr_18557_18648[(1)] = (59));

} else {
var statearr_18558_18649 = state_18526__$1;
(statearr_18558_18649[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (33))){
var inst_18425 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
if(cljs.core.truth_(inst_18425)){
var statearr_18559_18650 = state_18526__$1;
(statearr_18559_18650[(1)] = (34));

} else {
var statearr_18560_18651 = state_18526__$1;
(statearr_18560_18651[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (13))){
var inst_18348 = (state_18526[(18)]);
var inst_18348__$1 = new cljs.core.Keyword(null,"union","union",2142937499).cljs$core$IFn$_invoke$arity$1(clause);
var inst_18349 = cljs.core.seq.call(null,inst_18348__$1);
var inst_18350 = cljs.core.first.call(null,inst_18349);
var inst_18351 = cljs.core.next.call(null,inst_18349);
var inst_18352 = inst_18348__$1;
var inst_18353 = null;
var state_18526__$1 = (function (){var statearr_18561 = state_18526;
(statearr_18561[(13)] = inst_18353);

(statearr_18561[(16)] = inst_18350);

(statearr_18561[(17)] = inst_18351);

(statearr_18561[(18)] = inst_18348__$1);

(statearr_18561[(19)] = inst_18352);

return statearr_18561;
})();
var statearr_18562_18652 = state_18526__$1;
(statearr_18562_18652[(2)] = null);

(statearr_18562_18652[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (22))){
var inst_18353 = (state_18526[(13)]);
var inst_18369 = (state_18526[(20)]);
var inst_18360 = (state_18526[(15)]);
var inst_18371 = fluree.db.query.analytical.outer_union.call(null,inst_18353,inst_18369);
var inst_18352 = inst_18360;
var inst_18353__$1 = inst_18371;
var state_18526__$1 = (function (){var statearr_18563 = state_18526;
(statearr_18563[(13)] = inst_18353__$1);

(statearr_18563[(19)] = inst_18352);

return statearr_18563;
})();
var statearr_18564_18653 = state_18526__$1;
(statearr_18564_18653[(2)] = null);

(statearr_18564_18653[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (36))){
var inst_18519 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18565_18654 = state_18526__$1;
(statearr_18565_18654[(2)] = inst_18519);

(statearr_18565_18654[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (41))){
var inst_18449 = cljs.core.count.call(null,clause);
var inst_18450 = cljs.core._EQ_.call(null,(3),inst_18449);
var state_18526__$1 = state_18526;
if(inst_18450){
var statearr_18566_18655 = state_18526__$1;
(statearr_18566_18655[(1)] = (44));

} else {
var statearr_18567_18656 = state_18526__$1;
(statearr_18567_18656[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (43))){
var inst_18441 = (state_18526[(21)]);
var inst_18444 = (state_18526[(2)]);
var inst_18445 = fluree.db.util.async.throw_err.call(null,inst_18444);
var inst_18446 = [inst_18445,r];
var inst_18447 = (new cljs.core.PersistentVector(null,2,(5),inst_18441,inst_18446,null));
var state_18526__$1 = state_18526;
var statearr_18568_18657 = state_18526__$1;
(statearr_18568_18657[(2)] = inst_18447);

(statearr_18568_18657[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (61))){
var inst_18506 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18569_18658 = state_18526__$1;
(statearr_18569_18658[(2)] = inst_18506);

(statearr_18569_18658[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (29))){
var inst_18323 = (state_18526[(12)]);
var inst_18406 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18323)].join('');
var inst_18407 = (new Error(inst_18406));
var inst_18408 = (function(){throw inst_18407})();
var state_18526__$1 = state_18526;
var statearr_18570_18659 = state_18526__$1;
(statearr_18570_18659[(2)] = inst_18408);

(statearr_18570_18659[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (44))){
var inst_18452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18453 = fluree.db.query.analytical.fdb_clause__GT_tuples.call(null,db,res,clause,fuel,max_fuel);
var state_18526__$1 = (function (){var statearr_18571 = state_18526;
(statearr_18571[(22)] = inst_18452);

return statearr_18571;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18526__$1,(47),inst_18453);
} else {
if((state_val_18527 === (6))){
var inst_18327 = (state_18526[(11)]);
var inst_18323 = (state_18526[(12)]);
var inst_18322 = cljs.core.keys.call(null,clause);
var inst_18323__$1 = cljs.core.first.call(null,inst_18322);
var inst_18327__$1 = cljs.core._EQ_;
var inst_18328 = inst_18327__$1.call(null,new cljs.core.Keyword(null,"optional","optional",2053951509),inst_18323__$1);
var state_18526__$1 = (function (){var statearr_18572 = state_18526;
(statearr_18572[(11)] = inst_18327__$1);

(statearr_18572[(12)] = inst_18323__$1);

return statearr_18572;
})();
if(cljs.core.truth_(inst_18328)){
var statearr_18573_18660 = state_18526__$1;
(statearr_18573_18660[(1)] = (9));

} else {
var statearr_18574_18661 = state_18526__$1;
(statearr_18574_18661[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (28))){
var inst_18400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18401 = new cljs.core.Keyword(null,"filter","filter",-948537934).cljs$core$IFn$_invoke$arity$1(clause);
var inst_18402 = fluree.db.query.analytical.tuples__GT_filtered.call(null,res,inst_18401,optional_QMARK_);
var inst_18403 = [inst_18402,r];
var inst_18404 = (new cljs.core.PersistentVector(null,2,(5),inst_18400,inst_18403,null));
var state_18526__$1 = state_18526;
var statearr_18575_18662 = state_18526__$1;
(statearr_18575_18662[(2)] = inst_18404);

(statearr_18575_18662[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (64))){
var inst_18504 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18576_18663 = state_18526__$1;
(statearr_18576_18663[(2)] = inst_18504);

(statearr_18576_18663[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (51))){
var inst_18473 = fluree.db.query.analytical.get_source_clause.call(null,db,clause,prefixes,opts);
var state_18526__$1 = state_18526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18526__$1,(54),inst_18473);
} else {
if((state_val_18527 === (25))){
var inst_18327 = (state_18526[(11)]);
var inst_18323 = (state_18526[(12)]);
var inst_18388 = new cljs.core.Keyword(null,"bind","bind",-113428417).cljs$core$IFn$_invoke$arity$1(clause);
var inst_18389 = (function (){var segment_type = inst_18323;
var pred__18324 = inst_18327;
var expr__18325 = inst_18323;
var bindings = inst_18388;
return (function (p1__18309_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars.call(null,res,p1__18309_SHARP_);
});
})();
var inst_18390 = cljs.core.map.call(null,inst_18389,inst_18388);
var inst_18391 = cljs.core.PersistentHashMap.EMPTY;
var inst_18392 = cljs.core.into.call(null,inst_18391,inst_18390);
var inst_18393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18394 = cljs.core.update.call(null,res,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.merge,inst_18392);
var inst_18395 = [inst_18394,r];
var inst_18396 = (new cljs.core.PersistentVector(null,2,(5),inst_18393,inst_18395,null));
var state_18526__$1 = state_18526;
var statearr_18577_18664 = state_18526__$1;
(statearr_18577_18664[(2)] = inst_18396);

(statearr_18577_18664[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (34))){
var inst_18427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18428 = fluree.db.query.analytical.full_text__GT_tuples.call(null,db,res,clause);
var inst_18429 = [inst_18428,r];
var inst_18430 = (new cljs.core.PersistentVector(null,2,(5),inst_18427,inst_18429,null));
var state_18526__$1 = state_18526;
var statearr_18578_18665 = state_18526__$1;
(statearr_18578_18665[(2)] = inst_18430);

(statearr_18578_18665[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (17))){
var inst_18384 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18579_18666 = state_18526__$1;
(statearr_18579_18666[(2)] = inst_18384);

(statearr_18579_18666[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (3))){
var inst_18524 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18526__$1,inst_18524);
} else {
if((state_val_18527 === (12))){
var inst_18330 = (state_18526[(23)]);
var inst_18334 = (state_18526[(2)]);
var inst_18335 = fluree.db.util.async.throw_err.call(null,inst_18334);
var inst_18336 = [inst_18335,r];
var inst_18337 = (new cljs.core.PersistentVector(null,2,(5),inst_18330,inst_18336,null));
var state_18526__$1 = state_18526;
var statearr_18580_18667 = state_18526__$1;
(statearr_18580_18667[(2)] = inst_18337);

(statearr_18580_18667[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (2))){
var _ = (function (){var statearr_18581 = state_18526;
(statearr_18581[(4)] = cljs.core.cons.call(null,(5),(state_18526[(4)])));

return statearr_18581;
})();
var inst_18320 = cljs.core.map_QMARK_.call(null,clause);
var state_18526__$1 = state_18526;
if(inst_18320){
var statearr_18582_18668 = state_18526__$1;
(statearr_18582_18668[(1)] = (6));

} else {
var statearr_18583_18669 = state_18526__$1;
(statearr_18583_18669[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (23))){
var inst_18369 = (state_18526[(20)]);
var inst_18360 = (state_18526[(15)]);
var inst_18352 = inst_18360;
var inst_18353 = inst_18369;
var state_18526__$1 = (function (){var statearr_18584 = state_18526;
(statearr_18584[(13)] = inst_18353);

(statearr_18584[(19)] = inst_18352);

return statearr_18584;
})();
var statearr_18585_18670 = state_18526__$1;
(statearr_18585_18670[(2)] = null);

(statearr_18585_18670[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (47))){
var inst_18452 = (state_18526[(22)]);
var inst_18455 = (state_18526[(2)]);
var inst_18456 = fluree.db.util.async.throw_err.call(null,inst_18455);
var inst_18457 = [inst_18456,r];
var inst_18458 = (new cljs.core.PersistentVector(null,2,(5),inst_18452,inst_18457,null));
var state_18526__$1 = state_18526;
var statearr_18586_18671 = state_18526__$1;
(statearr_18586_18671[(2)] = inst_18458);

(statearr_18586_18671[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (35))){
var inst_18433 = (state_18526[(24)]);
var inst_18432 = cljs.core.count.call(null,clause);
var inst_18433__$1 = cljs.core._EQ_.call(null,(3),inst_18432);
var state_18526__$1 = (function (){var statearr_18587 = state_18526;
(statearr_18587[(24)] = inst_18433__$1);

return statearr_18587;
})();
if(inst_18433__$1){
var statearr_18588_18672 = state_18526__$1;
(statearr_18588_18672[(1)] = (37));

} else {
var statearr_18589_18673 = state_18526__$1;
(statearr_18589_18673[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (19))){
var inst_18353 = (state_18526[(13)]);
var inst_18378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18379 = [inst_18353,r];
var inst_18380 = (new cljs.core.PersistentVector(null,2,(5),inst_18378,inst_18379,null));
var state_18526__$1 = state_18526;
var statearr_18590_18674 = state_18526__$1;
(statearr_18590_18674[(2)] = inst_18380);

(statearr_18590_18674[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (57))){
var inst_18508 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18591_18675 = state_18526__$1;
(statearr_18591_18675[(2)] = inst_18508);

(statearr_18591_18675[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (11))){
var inst_18416 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18593_18676 = state_18526__$1;
(statearr_18593_18676[(2)] = inst_18416);

(statearr_18593_18676[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (9))){
var inst_18330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18331 = new cljs.core.Keyword(null,"optional","optional",2053951509).cljs$core$IFn$_invoke$arity$1(clause);
var inst_18332 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_18331,res,fuel,max_fuel,opts);
var state_18526__$1 = (function (){var statearr_18594 = state_18526;
(statearr_18594[(23)] = inst_18330);

return statearr_18594;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18526__$1,(12),inst_18332);
} else {
if((state_val_18527 === (5))){
var _ = (function (){var statearr_18595 = state_18526;
(statearr_18595[(4)] = cljs.core.rest.call(null,(state_18526[(4)])));

return statearr_18595;
})();
var state_18526__$1 = state_18526;
var ex18592 = (state_18526__$1[(2)]);
var statearr_18596_18677 = state_18526__$1;
(statearr_18596_18677[(5)] = ex18592);


if((ex18592 instanceof Error)){
var statearr_18597_18678 = state_18526__$1;
(statearr_18597_18678[(1)] = (4));

(statearr_18597_18678[(5)] = null);

} else {
throw ex18592;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (14))){
var inst_18327 = (state_18526[(11)]);
var inst_18323 = (state_18526[(12)]);
var inst_18386 = inst_18327.call(null,new cljs.core.Keyword(null,"bind","bind",-113428417),inst_18323);
var state_18526__$1 = state_18526;
if(cljs.core.truth_(inst_18386)){
var statearr_18598_18679 = state_18526__$1;
(statearr_18598_18679[(1)] = (25));

} else {
var statearr_18599_18680 = state_18526__$1;
(statearr_18599_18680[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (45))){
var inst_18460 = cljs.core.count.call(null,clause);
var inst_18461 = cljs.core._EQ_.call(null,(2),inst_18460);
var state_18526__$1 = state_18526;
if(inst_18461){
var statearr_18600_18681 = state_18526__$1;
(statearr_18600_18681[(1)] = (48));

} else {
var statearr_18601_18682 = state_18526__$1;
(statearr_18601_18682[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (53))){
var inst_18511 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18602_18683 = state_18526__$1;
(statearr_18602_18683[(2)] = inst_18511);

(statearr_18602_18683[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (26))){
var inst_18327 = (state_18526[(11)]);
var inst_18323 = (state_18526[(12)]);
var inst_18398 = inst_18327.call(null,new cljs.core.Keyword(null,"filter","filter",-948537934),inst_18323);
var state_18526__$1 = state_18526;
if(cljs.core.truth_(inst_18398)){
var statearr_18603_18684 = state_18526__$1;
(statearr_18603_18684[(1)] = (28));

} else {
var statearr_18604_18685 = state_18526__$1;
(statearr_18604_18685[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (16))){
var inst_18359 = (state_18526[(14)]);
var inst_18352 = (state_18526[(19)]);
var inst_18358 = cljs.core.seq.call(null,inst_18352);
var inst_18359__$1 = cljs.core.first.call(null,inst_18358);
var inst_18360 = cljs.core.next.call(null,inst_18358);
var state_18526__$1 = (function (){var statearr_18605 = state_18526;
(statearr_18605[(14)] = inst_18359__$1);

(statearr_18605[(15)] = inst_18360);

return statearr_18605;
})();
if(cljs.core.truth_(inst_18359__$1)){
var statearr_18606_18686 = state_18526__$1;
(statearr_18606_18686[(1)] = (18));

} else {
var statearr_18607_18687 = state_18526__$1;
(statearr_18607_18687[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (38))){
var inst_18433 = (state_18526[(24)]);
var state_18526__$1 = state_18526;
var statearr_18608_18688 = state_18526__$1;
(statearr_18608_18688[(2)] = inst_18433);

(statearr_18608_18688[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (30))){
var inst_18410 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18609_18689 = state_18526__$1;
(statearr_18609_18689[(2)] = inst_18410);

(statearr_18609_18689[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (10))){
var inst_18327 = (state_18526[(11)]);
var inst_18323 = (state_18526[(12)]);
var inst_18339 = inst_18327.call(null,new cljs.core.Keyword(null,"union","union",2142937499),inst_18323);
var state_18526__$1 = state_18526;
if(cljs.core.truth_(inst_18339)){
var statearr_18610_18690 = state_18526__$1;
(statearr_18610_18690[(1)] = (13));

} else {
var statearr_18611_18691 = state_18526__$1;
(statearr_18611_18691[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (18))){
var inst_18359 = (state_18526[(14)]);
var inst_18362 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_18359,q_map,vars,fuel,max_fuel,opts);
var state_18526__$1 = state_18526;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18526__$1,(21),inst_18362);
} else {
if((state_val_18527 === (52))){
var state_18526__$1 = state_18526;
var statearr_18612_18692 = state_18526__$1;
(statearr_18612_18692[(2)] = null);

(statearr_18612_18692[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (42))){
var inst_18517 = (state_18526[(2)]);
var state_18526__$1 = state_18526;
var statearr_18613_18693 = state_18526__$1;
(statearr_18613_18693[(2)] = inst_18517);

(statearr_18613_18693[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (37))){
var inst_18435 = cljs.core.second.call(null,clause);
var inst_18436 = cljs.core._EQ_.call(null,inst_18435,"rdf:type");
var state_18526__$1 = state_18526;
var statearr_18614_18694 = state_18526__$1;
(statearr_18614_18694[(2)] = inst_18436);

(statearr_18614_18694[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (63))){
var state_18526__$1 = state_18526;
var statearr_18615_18695 = state_18526__$1;
(statearr_18615_18695[(2)] = null);

(statearr_18615_18695[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (8))){
var inst_18521 = (state_18526[(2)]);
var _ = (function (){var statearr_18616 = state_18526;
(statearr_18616[(4)] = cljs.core.rest.call(null,(state_18526[(4)])));

return statearr_18616;
})();
var state_18526__$1 = state_18526;
var statearr_18617_18696 = state_18526__$1;
(statearr_18617_18696[(2)] = inst_18521);

(statearr_18617_18696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18527 === (49))){
var state_18526__$1 = state_18526;
var statearr_18618_18697 = state_18526__$1;
(statearr_18618_18697[(1)] = (51));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2726__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2726__auto____0 = (function (){
var statearr_18620 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18620[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2726__auto__);

(statearr_18620[(1)] = (1));

return statearr_18620;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2726__auto____1 = (function (state_18526){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_18526);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e18621){var ex__2729__auto__ = e18621;
var statearr_18622_18698 = state_18526;
(statearr_18622_18698[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_18526[(4)]))){
var statearr_18623_18699 = state_18526;
(statearr_18623_18699[(1)] = cljs.core.first.call(null,(state_18526[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18700 = state_18526;
state_18526 = G__18700;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2726__auto__ = function(state_18526){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2726__auto____1.call(this,state_18526);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2726__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2726__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_18624 = f__2749__auto__.call(null);
(statearr_18624[(6)] = c__2748__auto__);

return statearr_18624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__18702 = arguments.length;
switch (G__18702) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.call(null,db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_18782){
var state_val_18783 = (state_18782[(1)]);
if((state_val_18783 === (7))){
var inst_18777 = (state_18782[(2)]);
var _ = (function (){var statearr_18784 = state_18782;
(statearr_18784[(4)] = cljs.core.rest.call(null,(state_18782[(4)])));

return statearr_18784;
})();
var state_18782__$1 = state_18782;
var statearr_18785_18833 = state_18782__$1;
(statearr_18785_18833[(2)] = inst_18777);

(statearr_18785_18833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (20))){
var inst_18742 = (state_18782[(7)]);
var inst_18754 = (state_18782[(2)]);
var inst_18724 = inst_18742;
var inst_18725 = inst_18754;
var state_18782__$1 = (function (){var statearr_18786 = state_18782;
(statearr_18786[(8)] = inst_18724);

(statearr_18786[(9)] = inst_18725);

return statearr_18786;
})();
var statearr_18787_18834 = state_18782__$1;
(statearr_18787_18834[(2)] = null);

(statearr_18787_18834[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (1))){
var state_18782__$1 = state_18782;
var statearr_18788_18835 = state_18782__$1;
(statearr_18788_18835[(2)] = null);

(statearr_18788_18835[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (24))){
var inst_18742 = (state_18782[(7)]);
var inst_18741 = (state_18782[(10)]);
var inst_18725 = (state_18782[(9)]);
var inst_18762 = fluree.db.query.analytical.inner_join.call(null,inst_18725,inst_18741);
var inst_18724 = inst_18742;
var inst_18725__$1 = inst_18762;
var state_18782__$1 = (function (){var statearr_18789 = state_18782;
(statearr_18789[(8)] = inst_18724);

(statearr_18789[(9)] = inst_18725__$1);

return statearr_18789;
})();
var statearr_18790_18836 = state_18782__$1;
(statearr_18790_18836[(2)] = null);

(statearr_18790_18836[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (4))){
var inst_18703 = (state_18782[(2)]);
var state_18782__$1 = state_18782;
var statearr_18792_18837 = state_18782__$1;
(statearr_18792_18837[(2)] = inst_18703);

(statearr_18792_18837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (15))){
var inst_18741 = (state_18782[(10)]);
var state_18782__$1 = state_18782;
if(cljs.core.truth_(inst_18741)){
var statearr_18793_18838 = state_18782__$1;
(statearr_18793_18838[(1)] = (18));

} else {
var statearr_18794_18839 = state_18782__$1;
(statearr_18794_18839[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (21))){
var inst_18742 = (state_18782[(7)]);
var inst_18725 = (state_18782[(9)]);
var tmp18791 = inst_18725;
var inst_18724 = inst_18742;
var inst_18725__$1 = tmp18791;
var state_18782__$1 = (function (){var statearr_18795 = state_18782;
(statearr_18795[(8)] = inst_18724);

(statearr_18795[(9)] = inst_18725__$1);

return statearr_18795;
})();
var statearr_18796_18840 = state_18782__$1;
(statearr_18796_18840[(2)] = null);

(statearr_18796_18840[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (13))){
var inst_18725 = (state_18782[(9)]);
var inst_18748 = cljs.core.dissoc.call(null,inst_18725,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_18749 = cljs.core.empty_QMARK_.call(null,inst_18748);
var state_18782__$1 = state_18782;
if(inst_18749){
var statearr_18797_18841 = state_18782__$1;
(statearr_18797_18841[(1)] = (15));

} else {
var statearr_18798_18842 = state_18782__$1;
(statearr_18798_18842[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (22))){
var state_18782__$1 = state_18782;
var statearr_18799_18843 = state_18782__$1;
(statearr_18799_18843[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (6))){
var inst_18731 = (state_18782[(11)]);
var inst_18724 = (state_18782[(8)]);
var inst_18730 = cljs.core.seq.call(null,inst_18724);
var inst_18731__$1 = cljs.core.first.call(null,inst_18730);
var inst_18732 = cljs.core.next.call(null,inst_18730);
var state_18782__$1 = (function (){var statearr_18801 = state_18782;
(statearr_18801[(11)] = inst_18731__$1);

(statearr_18801[(12)] = inst_18732);

return statearr_18801;
})();
if(cljs.core.truth_(inst_18731__$1)){
var statearr_18802_18844 = state_18782__$1;
(statearr_18802_18844[(1)] = (8));

} else {
var statearr_18803_18845 = state_18782__$1;
(statearr_18803_18845[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (25))){
var state_18782__$1 = state_18782;
var statearr_18804_18846 = state_18782__$1;
(statearr_18804_18846[(2)] = null);

(statearr_18804_18846[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (17))){
var inst_18770 = (state_18782[(2)]);
var state_18782__$1 = state_18782;
var statearr_18805_18847 = state_18782__$1;
(statearr_18805_18847[(2)] = inst_18770);

(statearr_18805_18847[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (3))){
var inst_18780 = (state_18782[(2)]);
var state_18782__$1 = state_18782;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18782__$1,inst_18780);
} else {
if((state_val_18783 === (12))){
var inst_18742 = (state_18782[(7)]);
var inst_18741 = (state_18782[(10)]);
var inst_18724 = inst_18742;
var inst_18725 = inst_18741;
var state_18782__$1 = (function (){var statearr_18806 = state_18782;
(statearr_18806[(8)] = inst_18724);

(statearr_18806[(9)] = inst_18725);

return statearr_18806;
})();
var statearr_18807_18848 = state_18782__$1;
(statearr_18807_18848[(2)] = null);

(statearr_18807_18848[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (2))){
var _ = (function (){var statearr_18808 = state_18782;
(statearr_18808[(4)] = cljs.core.cons.call(null,(5),(state_18782[(4)])));

return statearr_18808;
})();
var inst_18716 = where;
var inst_18717 = cljs.core.seq.call(null,inst_18716);
var inst_18718 = cljs.core.first.call(null,inst_18717);
var inst_18719 = cljs.core.next.call(null,inst_18717);
var inst_18720 = [new cljs.core.Keyword(null,"vars","vars",-2046957217)];
var inst_18721 = fluree.db.query.analytical.symbolize_keys.call(null,vars);
var inst_18722 = [inst_18721];
var inst_18723 = cljs.core.PersistentHashMap.fromArrays(inst_18720,inst_18722);
var inst_18724 = inst_18716;
var inst_18725 = inst_18723;
var state_18782__$1 = (function (){var statearr_18809 = state_18782;
(statearr_18809[(13)] = inst_18718);

(statearr_18809[(14)] = inst_18719);

(statearr_18809[(8)] = inst_18724);

(statearr_18809[(9)] = inst_18725);

return statearr_18809;
})();
var statearr_18810_18849 = state_18782__$1;
(statearr_18810_18849[(2)] = null);

(statearr_18810_18849[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (23))){
var inst_18768 = (state_18782[(2)]);
var state_18782__$1 = state_18782;
var statearr_18811_18850 = state_18782__$1;
(statearr_18811_18850[(2)] = inst_18768);

(statearr_18811_18850[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (19))){
var inst_18725 = (state_18782[(9)]);
var state_18782__$1 = state_18782;
var statearr_18812_18851 = state_18782__$1;
(statearr_18812_18851[(2)] = inst_18725);

(statearr_18812_18851[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (11))){
var inst_18731 = (state_18782[(11)]);
var inst_18739 = (state_18782[(2)]);
var inst_18740 = fluree.db.util.async.throw_err.call(null,inst_18739);
var inst_18741 = cljs.core.nth.call(null,inst_18740,(0),null);
var inst_18742 = cljs.core.nth.call(null,inst_18740,(1),null);
var inst_18743 = cljs.core.count.call(null,inst_18731);
var inst_18744 = cljs.core._EQ_.call(null,(2),inst_18743);
var state_18782__$1 = (function (){var statearr_18814 = state_18782;
(statearr_18814[(7)] = inst_18742);

(statearr_18814[(10)] = inst_18741);

return statearr_18814;
})();
if(inst_18744){
var statearr_18815_18852 = state_18782__$1;
(statearr_18815_18852[(1)] = (12));

} else {
var statearr_18816_18853 = state_18782__$1;
(statearr_18816_18853[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (9))){
var inst_18725 = (state_18782[(9)]);
var state_18782__$1 = state_18782;
var statearr_18817_18854 = state_18782__$1;
(statearr_18817_18854[(2)] = inst_18725);

(statearr_18817_18854[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (5))){
var _ = (function (){var statearr_18818 = state_18782;
(statearr_18818[(4)] = cljs.core.rest.call(null,(state_18782[(4)])));

return statearr_18818;
})();
var state_18782__$1 = state_18782;
var ex18813 = (state_18782__$1[(2)]);
var statearr_18819_18855 = state_18782__$1;
(statearr_18819_18855[(5)] = ex18813);


if((ex18813 instanceof Error)){
var statearr_18820_18856 = state_18782__$1;
(statearr_18820_18856[(1)] = (4));

(statearr_18820_18856[(5)] = null);

} else {
throw ex18813;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (14))){
var inst_18772 = (state_18782[(2)]);
var state_18782__$1 = state_18782;
var statearr_18821_18857 = state_18782__$1;
(statearr_18821_18857[(2)] = inst_18772);

(statearr_18821_18857[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (26))){
var inst_18766 = (state_18782[(2)]);
var state_18782__$1 = state_18782;
var statearr_18822_18858 = state_18782__$1;
(statearr_18822_18858[(2)] = inst_18766);

(statearr_18822_18858[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (16))){
var inst_18741 = (state_18782[(10)]);
var inst_18757 = (inst_18741 == null);
var state_18782__$1 = state_18782;
if(cljs.core.truth_(inst_18757)){
var statearr_18823_18859 = state_18782__$1;
(statearr_18823_18859[(1)] = (21));

} else {
var statearr_18824_18860 = state_18782__$1;
(statearr_18824_18860[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (10))){
var inst_18775 = (state_18782[(2)]);
var state_18782__$1 = state_18782;
var statearr_18825_18861 = state_18782__$1;
(statearr_18825_18861[(2)] = inst_18775);

(statearr_18825_18861[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (18))){
var inst_18741 = (state_18782[(10)]);
var state_18782__$1 = state_18782;
var statearr_18826_18862 = state_18782__$1;
(statearr_18826_18862[(2)] = inst_18741);

(statearr_18826_18862[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18783 === (8))){
var inst_18731 = (state_18782[(11)]);
var inst_18732 = (state_18782[(12)]);
var inst_18725 = (state_18782[(9)]);
var inst_18737 = fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_18725,inst_18731,inst_18732,false,fuel,max_fuel,opts);
var state_18782__$1 = state_18782;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18782__$1,(11),inst_18737);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__2726__auto__ = null;
var fluree$db$query$analytical$state_machine__2726__auto____0 = (function (){
var statearr_18827 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18827[(0)] = fluree$db$query$analytical$state_machine__2726__auto__);

(statearr_18827[(1)] = (1));

return statearr_18827;
});
var fluree$db$query$analytical$state_machine__2726__auto____1 = (function (state_18782){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_18782);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e18828){var ex__2729__auto__ = e18828;
var statearr_18829_18863 = state_18782;
(statearr_18829_18863[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_18782[(4)]))){
var statearr_18830_18864 = state_18782;
(statearr_18830_18864[(1)] = cljs.core.first.call(null,(state_18782[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18865 = state_18782;
state_18782 = G__18865;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__2726__auto__ = function(state_18782){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__2726__auto____1.call(this,state_18782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__2726__auto____0;
fluree$db$query$analytical$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__2726__auto____1;
return fluree$db$query$analytical$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_18831 = f__2749__auto__.call(null);
(statearr_18831[(6)] = c__2748__auto__);

return statearr_18831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_18900){
var state_val_18901 = (state_18900[(1)]);
if((state_val_18901 === (7))){
var inst_18882 = (state_18900[(7)]);
var inst_18877 = (state_18900[(8)]);
var inst_18884 = fluree.db.query.analytical.optional__GT_left_outer_joins.call(null,db,q_map,inst_18877,inst_18882,fuel,max_fuel,opts);
var state_18900__$1 = state_18900;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18900__$1,(10),inst_18884);
} else {
if((state_val_18901 === (1))){
var state_18900__$1 = state_18900;
var statearr_18902_18927 = state_18900__$1;
(statearr_18902_18927[(2)] = null);

(statearr_18902_18927[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18901 === (4))){
var inst_18866 = (state_18900[(2)]);
var state_18900__$1 = state_18900;
var statearr_18903_18928 = state_18900__$1;
(statearr_18903_18928[(2)] = inst_18866);

(statearr_18903_18928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18901 === (13))){
var inst_18895 = (state_18900[(2)]);
var _ = (function (){var statearr_18904 = state_18900;
(statearr_18904[(4)] = cljs.core.rest.call(null,(state_18900[(4)])));

return statearr_18904;
})();
var state_18900__$1 = state_18900;
var statearr_18905_18929 = state_18900__$1;
(statearr_18905_18929[(2)] = inst_18895);

(statearr_18905_18929[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18901 === (6))){
var inst_18877 = (state_18900[(8)]);
var inst_18881 = (state_18900[(2)]);
var inst_18882 = fluree.db.util.async.throw_err.call(null,inst_18881);
var state_18900__$1 = (function (){var statearr_18906 = state_18900;
(statearr_18906[(7)] = inst_18882);

return statearr_18906;
})();
if(cljs.core.truth_(inst_18877)){
var statearr_18907_18930 = state_18900__$1;
(statearr_18907_18930[(1)] = (7));

} else {
var statearr_18908_18931 = state_18900__$1;
(statearr_18908_18931[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18901 === (3))){
var inst_18898 = (state_18900[(2)]);
var state_18900__$1 = state_18900;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18900__$1,inst_18898);
} else {
if((state_val_18901 === (12))){
var inst_18890 = (state_18900[(9)]);
var state_18900__$1 = state_18900;
var statearr_18909_18932 = state_18900__$1;
(statearr_18909_18932[(2)] = inst_18890);

(statearr_18909_18932[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18901 === (2))){
var _ = (function (){var statearr_18910 = state_18900;
(statearr_18910[(4)] = cljs.core.cons.call(null,(5),(state_18900[(4)])));

return statearr_18910;
})();
var inst_18873 = q_map;
var inst_18874 = cljs.core.__destructure_map.call(null,inst_18873);
var inst_18875 = cljs.core.get.call(null,inst_18874,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var inst_18876 = cljs.core.get.call(null,inst_18874,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_18877 = cljs.core.get.call(null,inst_18874,new cljs.core.Keyword(null,"optional","optional",2053951509));
var inst_18878 = cljs.core.get.call(null,inst_18874,new cljs.core.Keyword(null,"filter","filter",-948537934));
var inst_18879 = fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_18876,q_map,inst_18875,fuel,max_fuel,opts);
var state_18900__$1 = (function (){var statearr_18911 = state_18900;
(statearr_18911[(10)] = inst_18878);

(statearr_18911[(8)] = inst_18877);

return statearr_18911;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18900__$1,(6),inst_18879);
} else {
if((state_val_18901 === (11))){
var inst_18890 = (state_18900[(9)]);
var inst_18878 = (state_18900[(10)]);
var inst_18892 = fluree.db.query.analytical.tuples__GT_filtered.call(null,inst_18890,inst_18878,null);
var state_18900__$1 = state_18900;
var statearr_18913_18933 = state_18900__$1;
(statearr_18913_18933[(2)] = inst_18892);

(statearr_18913_18933[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18901 === (9))){
var inst_18878 = (state_18900[(10)]);
var inst_18890 = (state_18900[(2)]);
var state_18900__$1 = (function (){var statearr_18914 = state_18900;
(statearr_18914[(9)] = inst_18890);

return statearr_18914;
})();
if(cljs.core.truth_(inst_18878)){
var statearr_18915_18934 = state_18900__$1;
(statearr_18915_18934[(1)] = (11));

} else {
var statearr_18916_18935 = state_18900__$1;
(statearr_18916_18935[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18901 === (5))){
var _ = (function (){var statearr_18917 = state_18900;
(statearr_18917[(4)] = cljs.core.rest.call(null,(state_18900[(4)])));

return statearr_18917;
})();
var state_18900__$1 = state_18900;
var ex18912 = (state_18900__$1[(2)]);
var statearr_18918_18936 = state_18900__$1;
(statearr_18918_18936[(5)] = ex18912);


if((ex18912 instanceof Error)){
var statearr_18919_18937 = state_18900__$1;
(statearr_18919_18937[(1)] = (4));

(statearr_18919_18937[(5)] = null);

} else {
throw ex18912;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18901 === (10))){
var inst_18886 = (state_18900[(2)]);
var inst_18887 = fluree.db.util.async.throw_err.call(null,inst_18886);
var state_18900__$1 = state_18900;
var statearr_18920_18938 = state_18900__$1;
(statearr_18920_18938[(2)] = inst_18887);

(statearr_18920_18938[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18901 === (8))){
var inst_18882 = (state_18900[(7)]);
var state_18900__$1 = state_18900;
var statearr_18921_18939 = state_18900__$1;
(statearr_18921_18939[(2)] = inst_18882);

(statearr_18921_18939[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__2726__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__2726__auto____0 = (function (){
var statearr_18922 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18922[(0)] = fluree$db$query$analytical$q_$_state_machine__2726__auto__);

(statearr_18922[(1)] = (1));

return statearr_18922;
});
var fluree$db$query$analytical$q_$_state_machine__2726__auto____1 = (function (state_18900){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_18900);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e18923){var ex__2729__auto__ = e18923;
var statearr_18924_18940 = state_18900;
(statearr_18924_18940[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_18900[(4)]))){
var statearr_18925_18941 = state_18900;
(statearr_18925_18941[(1)] = cljs.core.first.call(null,(state_18900[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18942 = state_18900;
state_18900 = G__18942;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__2726__auto__ = function(state_18900){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__2726__auto____1.call(this,state_18900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__2726__auto____0;
fluree$db$query$analytical$q_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__2726__auto____1;
return fluree$db$query$analytical$q_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_18926 = f__2749__auto__.call(null);
(statearr_18926[(6)] = c__2748__auto__);

return statearr_18926;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
