// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__63115 = arguments.length;
switch (G__63115) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_63157){
var state_val_63158 = (state_63157[(1)]);
if((state_val_63158 === (7))){
var inst_63127 = typeof user === 'string';
var state_63157__$1 = state_63157;
if(cljs.core.truth_(inst_63127)){
var statearr_63159_63188 = state_63157__$1;
(statearr_63159_63188[(1)] = (9));

} else {
var statearr_63160_63189 = state_63157__$1;
(statearr_63160_63189[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (1))){
var state_63157__$1 = state_63157;
var statearr_63161_63190 = state_63157__$1;
(statearr_63161_63190[(2)] = null);

(statearr_63161_63190[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (4))){
var inst_63116 = (state_63157[(2)]);
var inst_63117 = fluree.db.util.log.error.call(null,inst_63116);
var inst_63118 = reject.call(null,inst_63116);
var state_63157__$1 = (function (){var statearr_63162 = state_63157;
(statearr_63162[(7)] = inst_63117);

return statearr_63162;
})();
var statearr_63163_63191 = state_63157__$1;
(statearr_63163_63191[(2)] = inst_63118);

(statearr_63163_63191[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (15))){
var inst_63146 = (state_63157[(2)]);
var inst_63147 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_63146);
var inst_63148 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63149 = cljs.core.constantly.call(null,inst_63147);
var inst_63150 = cljs.core.swap_BANG_.call(null,inst_63148,inst_63149);
var inst_63151 = fluree.db.connection.add_token.call(null,conn,inst_63147);
var inst_63152 = resolve.call(null,inst_63146);
var _ = (function (){var statearr_63164 = state_63157;
(statearr_63164[(4)] = cljs.core.rest.call(null,(state_63157[(4)])));

return statearr_63164;
})();
var state_63157__$1 = (function (){var statearr_63165 = state_63157;
(statearr_63165[(8)] = inst_63151);

(statearr_63165[(9)] = inst_63150);

return statearr_63165;
})();
var statearr_63166_63192 = state_63157__$1;
(statearr_63166_63192[(2)] = inst_63152);

(statearr_63166_63192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (13))){
var state_63157__$1 = state_63157;
var statearr_63167_63193 = state_63157__$1;
(statearr_63167_63193[(2)] = null);

(statearr_63167_63193[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (6))){
var state_63157__$1 = state_63157;
var statearr_63168_63194 = state_63157__$1;
(statearr_63168_63194[(2)] = user);

(statearr_63168_63194[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (3))){
var inst_63155 = (state_63157[(2)]);
var state_63157__$1 = state_63157;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63157__$1,inst_63155);
} else {
if((state_val_63158 === (12))){
var state_63157__$1 = state_63157;
var statearr_63169_63195 = state_63157__$1;
(statearr_63169_63195[(2)] = user);

(statearr_63169_63195[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (2))){
var _ = (function (){var statearr_63170 = state_63157;
(statearr_63170[(4)] = cljs.core.cons.call(null,(5),(state_63157[(4)])));

return statearr_63170;
})();
var inst_63124 = typeof user === 'number';
var state_63157__$1 = state_63157;
if(cljs.core.truth_(inst_63124)){
var statearr_63171_63196 = state_63157__$1;
(statearr_63171_63196[(1)] = (6));

} else {
var statearr_63172_63197 = state_63157__$1;
(statearr_63172_63197[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (11))){
var inst_63138 = (state_63157[(2)]);
var state_63157__$1 = state_63157;
var statearr_63174_63198 = state_63157__$1;
(statearr_63174_63198[(2)] = inst_63138);

(statearr_63174_63198[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (9))){
var inst_63129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63130 = ["_user/username",user];
var inst_63131 = (new cljs.core.PersistentVector(null,2,(5),inst_63129,inst_63130,null));
var state_63157__$1 = state_63157;
var statearr_63175_63199 = state_63157__$1;
(statearr_63175_63199[(2)] = inst_63131);

(statearr_63175_63199[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (5))){
var _ = (function (){var statearr_63176 = state_63157;
(statearr_63176[(4)] = cljs.core.rest.call(null,(state_63157[(4)])));

return statearr_63176;
})();
var state_63157__$1 = state_63157;
var ex63173 = (state_63157__$1[(2)]);
var statearr_63177_63200 = state_63157__$1;
(statearr_63177_63200[(5)] = ex63173);


var statearr_63178_63201 = state_63157__$1;
(statearr_63178_63201[(1)] = (4));

(statearr_63178_63201[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (14))){
var inst_63136 = (state_63157[(2)]);
var state_63157__$1 = state_63157;
var statearr_63179_63202 = state_63157__$1;
(statearr_63179_63202[(2)] = inst_63136);

(statearr_63179_63202[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (10))){
var state_63157__$1 = state_63157;
var statearr_63180_63203 = state_63157__$1;
(statearr_63180_63203[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63158 === (8))){
var inst_63140 = (state_63157[(2)]);
var inst_63141 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_63142 = [account,inst_63140,password,expireSeconds,syncTo];
var inst_63143 = cljs.core.PersistentHashMap.fromArrays(inst_63141,inst_63142);
var inst_63144 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_63143);
var state_63157__$1 = state_63157;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63157__$1,(15),inst_63144);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2726__auto__ = null;
var fluree$db$connection_js$state_machine__2726__auto____0 = (function (){
var statearr_63182 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63182[(0)] = fluree$db$connection_js$state_machine__2726__auto__);

(statearr_63182[(1)] = (1));

return statearr_63182;
});
var fluree$db$connection_js$state_machine__2726__auto____1 = (function (state_63157){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_63157);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e63183){var ex__2729__auto__ = e63183;
var statearr_63184_63204 = state_63157;
(statearr_63184_63204[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_63157[(4)]))){
var statearr_63185_63205 = state_63157;
(statearr_63185_63205[(1)] = cljs.core.first.call(null,(state_63157[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63206 = state_63157;
state_63157 = G__63206;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2726__auto__ = function(state_63157){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2726__auto____1.call(this,state_63157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2726__auto____0;
fluree$db$connection_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2726__auto____1;
return fluree$db$connection_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_63186 = f__2749__auto__.call(null);
(statearr_63186[(6)] = c__2748__auto__);

return statearr_63186;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__63208 = arguments.length;
switch (G__63208) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_63217){
var state_val_63218 = (state_63217[(1)]);
if((state_val_63218 === (1))){
var inst_63209 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63211 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_63212 = (new cljs.core.PersistentVector(null,4,(5),inst_63210,inst_63211,null));
var inst_63213 = cljs.core.async.put_BANG_.call(null,inst_63209,inst_63212);
var inst_63214 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__63219 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__63220 = null;
var count__63221 = (0);
var i__63222 = (0);
while(true){
if((i__63222 < count__63221)){
var k = cljs.core._nth.call(null,chunk__63220,i__63222);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__63230 = seq__63219;
var G__63231 = chunk__63220;
var G__63232 = count__63221;
var G__63233 = (i__63222 + (1));
seq__63219 = G__63230;
chunk__63220 = G__63231;
count__63221 = G__63232;
i__63222 = G__63233;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__63219);
if(temp__5753__auto__){
var seq__63219__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__63219__$1)){
var c__4649__auto__ = cljs.core.chunk_first.call(null,seq__63219__$1);
var G__63234 = cljs.core.chunk_rest.call(null,seq__63219__$1);
var G__63235 = c__4649__auto__;
var G__63236 = cljs.core.count.call(null,c__4649__auto__);
var G__63237 = (0);
seq__63219 = G__63234;
chunk__63220 = G__63235;
count__63221 = G__63236;
i__63222 = G__63237;
continue;
} else {
var k = cljs.core.first.call(null,seq__63219__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__63238 = cljs.core.next.call(null,seq__63219__$1);
var G__63239 = null;
var G__63240 = (0);
var G__63241 = (0);
seq__63219 = G__63238;
chunk__63220 = G__63239;
count__63221 = G__63240;
i__63222 = G__63241;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_63215 = cljs.core.async.take_BANG_.call(null,pc,inst_63214);
var state_63217__$1 = (function (){var statearr_63223 = state_63217;
(statearr_63223[(7)] = inst_63213);

return statearr_63223;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63217__$1,inst_63215);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2726__auto__ = null;
var fluree$db$connection_js$state_machine__2726__auto____0 = (function (){
var statearr_63224 = [null,null,null,null,null,null,null,null];
(statearr_63224[(0)] = fluree$db$connection_js$state_machine__2726__auto__);

(statearr_63224[(1)] = (1));

return statearr_63224;
});
var fluree$db$connection_js$state_machine__2726__auto____1 = (function (state_63217){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_63217);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e63225){var ex__2729__auto__ = e63225;
var statearr_63226_63242 = state_63217;
(statearr_63226_63242[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_63217[(4)]))){
var statearr_63227_63243 = state_63217;
(statearr_63227_63243[(1)] = cljs.core.first.call(null,(state_63217[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63244 = state_63217;
state_63217 = G__63244;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2726__auto__ = function(state_63217){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2726__auto____1.call(this,state_63217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2726__auto____0;
fluree$db$connection_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2726__auto____1;
return fluree$db$connection_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_63228 = f__2749__auto__.call(null);
(statearr_63228[(6)] = c__2748__auto__);

return statearr_63228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__63246 = arguments.length;
switch (G__63246) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_63280){
var state_val_63281 = (state_63280[(1)]);
if((state_val_63281 === (1))){
var state_63280__$1 = state_63280;
var statearr_63282_63303 = state_63280__$1;
(statearr_63282_63303[(2)] = null);

(statearr_63282_63303[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63281 === (2))){
var _ = (function (){var statearr_63283 = state_63280;
(statearr_63283[(4)] = cljs.core.cons.call(null,(5),(state_63280[(4)])));

return statearr_63283;
})();
var inst_63255 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_63256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63257 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_63258 = (new cljs.core.PersistentVector(null,1,(5),inst_63256,inst_63257,null));
var inst_63259 = cljs.core.PersistentHashMap.EMPTY;
var inst_63260 = cljs.core.atom.call(null,inst_63259);
var inst_63261 = cljs.core.assoc_in.call(null,inst_63255,inst_63258,inst_63260);
var inst_63262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63263 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63264 = (new cljs.core.PersistentVector(null,1,(5),inst_63262,inst_63263,null));
var inst_63265 = cljs.core.PersistentHashMap.EMPTY;
var inst_63266 = cljs.core.atom.call(null,inst_63265);
var inst_63267 = cljs.core.assoc_in.call(null,inst_63261,inst_63264,inst_63266);
var inst_63268 = cljs.core.async.promise_chan.call(null);
var inst_63269 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_63267);
var inst_63270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63271 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_63268,null];
var inst_63272 = (new cljs.core.PersistentVector(null,4,(5),inst_63270,inst_63271,null));
var inst_63273 = cljs.core.async.put_BANG_.call(null,inst_63269,inst_63272);
var inst_63274 = (function (){var conn = inst_63267;
var pc = inst_63268;
return (function (x){
if((x == null)){
} else {
var seq__63284_63304 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__63285_63305 = null;
var count__63286_63306 = (0);
var i__63287_63307 = (0);
while(true){
if((i__63287_63307 < count__63286_63306)){
var k_63308 = cljs.core._nth.call(null,chunk__63285_63305,i__63287_63307);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63308], null),cljs.core.get.call(null,x,k_63308,null));


var G__63309 = seq__63284_63304;
var G__63310 = chunk__63285_63305;
var G__63311 = count__63286_63306;
var G__63312 = (i__63287_63307 + (1));
seq__63284_63304 = G__63309;
chunk__63285_63305 = G__63310;
count__63286_63306 = G__63311;
i__63287_63307 = G__63312;
continue;
} else {
var temp__5753__auto___63313 = cljs.core.seq.call(null,seq__63284_63304);
if(temp__5753__auto___63313){
var seq__63284_63314__$1 = temp__5753__auto___63313;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__63284_63314__$1)){
var c__4649__auto___63315 = cljs.core.chunk_first.call(null,seq__63284_63314__$1);
var G__63316 = cljs.core.chunk_rest.call(null,seq__63284_63314__$1);
var G__63317 = c__4649__auto___63315;
var G__63318 = cljs.core.count.call(null,c__4649__auto___63315);
var G__63319 = (0);
seq__63284_63304 = G__63316;
chunk__63285_63305 = G__63317;
count__63286_63306 = G__63318;
i__63287_63307 = G__63319;
continue;
} else {
var k_63320 = cljs.core.first.call(null,seq__63284_63314__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63320], null),cljs.core.get.call(null,x,k_63320,null));


var G__63321 = cljs.core.next.call(null,seq__63284_63314__$1);
var G__63322 = null;
var G__63323 = (0);
var G__63324 = (0);
seq__63284_63304 = G__63321;
chunk__63285_63305 = G__63322;
count__63286_63306 = G__63323;
i__63287_63307 = G__63324;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_63275 = cljs.core.async.take_BANG_.call(null,inst_63268,inst_63274);
var ___$1 = (function (){var statearr_63288 = state_63280;
(statearr_63288[(4)] = cljs.core.rest.call(null,(state_63280[(4)])));

return statearr_63288;
})();
var state_63280__$1 = (function (){var statearr_63289 = state_63280;
(statearr_63289[(7)] = inst_63273);

return statearr_63289;
})();
var statearr_63290_63325 = state_63280__$1;
(statearr_63290_63325[(2)] = inst_63275);

(statearr_63290_63325[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63281 === (3))){
var inst_63278 = (state_63280[(2)]);
var state_63280__$1 = state_63280;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63280__$1,inst_63278);
} else {
if((state_val_63281 === (4))){
var inst_63247 = (state_63280[(2)]);
var inst_63248 = fluree.db.util.log.error.call(null,inst_63247);
var inst_63249 = reject.call(null,inst_63247);
var state_63280__$1 = (function (){var statearr_63292 = state_63280;
(statearr_63292[(8)] = inst_63248);

return statearr_63292;
})();
var statearr_63293_63326 = state_63280__$1;
(statearr_63293_63326[(2)] = inst_63249);

(statearr_63293_63326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63281 === (5))){
var _ = (function (){var statearr_63294 = state_63280;
(statearr_63294[(4)] = cljs.core.rest.call(null,(state_63280[(4)])));

return statearr_63294;
})();
var state_63280__$1 = state_63280;
var ex63291 = (state_63280__$1[(2)]);
var statearr_63295_63327 = state_63280__$1;
(statearr_63295_63327[(5)] = ex63291);


var statearr_63296_63328 = state_63280__$1;
(statearr_63296_63328[(1)] = (4));

(statearr_63296_63328[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2726__auto__ = null;
var fluree$db$connection_js$state_machine__2726__auto____0 = (function (){
var statearr_63297 = [null,null,null,null,null,null,null,null,null];
(statearr_63297[(0)] = fluree$db$connection_js$state_machine__2726__auto__);

(statearr_63297[(1)] = (1));

return statearr_63297;
});
var fluree$db$connection_js$state_machine__2726__auto____1 = (function (state_63280){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_63280);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e63298){var ex__2729__auto__ = e63298;
var statearr_63299_63329 = state_63280;
(statearr_63299_63329[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_63280[(4)]))){
var statearr_63300_63330 = state_63280;
(statearr_63300_63330[(1)] = cljs.core.first.call(null,(state_63280[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63331 = state_63280;
state_63280 = G__63331;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2726__auto__ = function(state_63280){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2726__auto____1.call(this,state_63280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2726__auto____0;
fluree$db$connection_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2726__auto____1;
return fluree$db$connection_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_63301 = f__2749__auto__.call(null);
(statearr_63301[(6)] = c__2748__auto__);

return statearr_63301;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__63333 = arguments.length;
switch (G__63333) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__63335 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__63335,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__63335,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__63338 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__63338,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__63338,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_63391){
var state_val_63392 = (state_63391[(1)]);
if((state_val_63392 === (7))){
var inst_63352 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63353 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63354 = cljs.core.PersistentHashMap.fromArrays(inst_63352,inst_63353);
var inst_63355 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_63354);
var inst_63356 = (function(){throw inst_63355})();
var state_63391__$1 = state_63391;
var statearr_63393_63422 = state_63391__$1;
(statearr_63393_63422[(2)] = inst_63356);

(statearr_63393_63422[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63392 === (1))){
var state_63391__$1 = state_63391;
var statearr_63394_63423 = state_63391__$1;
(statearr_63394_63423[(2)] = null);

(statearr_63394_63423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63392 === (4))){
var inst_63341 = (state_63391[(2)]);
var inst_63342 = cljs.core.clj__GT_js.call(null,inst_63341);
var inst_63343 = reject.call(null,inst_63342);
var state_63391__$1 = state_63391;
var statearr_63395_63424 = state_63391__$1;
(statearr_63395_63424[(2)] = inst_63343);

(statearr_63395_63424[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63392 === (13))){
var inst_63370 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63371 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63372 = cljs.core.PersistentHashMap.fromArrays(inst_63370,inst_63371);
var inst_63373 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_63372);
var inst_63374 = (function(){throw inst_63373})();
var state_63391__$1 = state_63391;
var statearr_63396_63425 = state_63391__$1;
(statearr_63396_63425[(2)] = inst_63374);

(statearr_63396_63425[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63392 === (6))){
var state_63391__$1 = state_63391;
var statearr_63397_63426 = state_63391__$1;
(statearr_63397_63426[(2)] = null);

(statearr_63397_63426[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63392 === (3))){
var inst_63389 = (state_63391[(2)]);
var state_63391__$1 = state_63391;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63391__$1,inst_63389);
} else {
if((state_val_63392 === (12))){
var state_63391__$1 = state_63391;
var statearr_63398_63427 = state_63391__$1;
(statearr_63398_63427[(2)] = null);

(statearr_63398_63427[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63392 === (2))){
var _ = (function (){var statearr_63399 = state_63391;
(statearr_63399[(4)] = cljs.core.cons.call(null,(5),(state_63391[(4)])));

return statearr_63399;
})();
var inst_63349 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_63391__$1 = state_63391;
if(cljs.core.truth_(inst_63349)){
var statearr_63400_63428 = state_63391__$1;
(statearr_63400_63428[(1)] = (6));

} else {
var statearr_63401_63429 = state_63391__$1;
(statearr_63401_63429[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63392 === (11))){
var inst_63367 = (state_63391[(2)]);
var state_63391__$1 = (function (){var statearr_63403 = state_63391;
(statearr_63403[(7)] = inst_63367);

return statearr_63403;
})();
if(cljs.core.truth_(password)){
var statearr_63404_63430 = state_63391__$1;
(statearr_63404_63430[(1)] = (12));

} else {
var statearr_63405_63431 = state_63391__$1;
(statearr_63405_63431[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63392 === (9))){
var state_63391__$1 = state_63391;
var statearr_63406_63432 = state_63391__$1;
(statearr_63406_63432[(2)] = null);

(statearr_63406_63432[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63392 === (5))){
var _ = (function (){var statearr_63407 = state_63391;
(statearr_63407[(4)] = cljs.core.rest.call(null,(state_63391[(4)])));

return statearr_63407;
})();
var state_63391__$1 = state_63391;
var ex63402 = (state_63391__$1[(2)]);
var statearr_63408_63433 = state_63391__$1;
(statearr_63408_63433[(5)] = ex63402);


var statearr_63409_63434 = state_63391__$1;
(statearr_63409_63434[(1)] = (4));

(statearr_63409_63434[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63392 === (14))){
var inst_63376 = (state_63391[(2)]);
var inst_63377 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_63378 = fluree.db.util.core.without_nils.call(null,inst_63377);
var inst_63379 = cljs.core.async.promise_chan.call(null);
var inst_63380 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63382 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_63378,inst_63379,null];
var inst_63383 = (new cljs.core.PersistentVector(null,4,(5),inst_63381,inst_63382,null));
var inst_63384 = cljs.core.async.put_BANG_.call(null,inst_63380,inst_63383);
var inst_63385 = (function (){var _ = inst_63376;
var data = inst_63378;
var pc = inst_63379;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_63386 = cljs.core.async.take_BANG_.call(null,inst_63379,inst_63385);
var _ = (function (){var statearr_63410 = state_63391;
(statearr_63410[(4)] = cljs.core.rest.call(null,(state_63391[(4)])));

return statearr_63410;
})();
var state_63391__$1 = (function (){var statearr_63411 = state_63391;
(statearr_63411[(8)] = inst_63384);

return statearr_63411;
})();
var statearr_63412_63435 = state_63391__$1;
(statearr_63412_63435[(2)] = inst_63386);

(statearr_63412_63435[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63392 === (10))){
var inst_63361 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63362 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63363 = cljs.core.PersistentHashMap.fromArrays(inst_63361,inst_63362);
var inst_63364 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_63363);
var inst_63365 = (function(){throw inst_63364})();
var state_63391__$1 = state_63391;
var statearr_63413_63436 = state_63391__$1;
(statearr_63413_63436[(2)] = inst_63365);

(statearr_63413_63436[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63392 === (8))){
var inst_63358 = (state_63391[(2)]);
var state_63391__$1 = (function (){var statearr_63414 = state_63391;
(statearr_63414[(9)] = inst_63358);

return statearr_63414;
})();
if(cljs.core.truth_(ledger)){
var statearr_63415_63437 = state_63391__$1;
(statearr_63415_63437[(1)] = (9));

} else {
var statearr_63416_63438 = state_63391__$1;
(statearr_63416_63438[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2726__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2726__auto____0 = (function (){
var statearr_63417 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63417[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2726__auto__);

(statearr_63417[(1)] = (1));

return statearr_63417;
});
var fluree$db$connection_js$password_generate_$_state_machine__2726__auto____1 = (function (state_63391){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_63391);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e63418){var ex__2729__auto__ = e63418;
var statearr_63419_63439 = state_63391;
(statearr_63419_63439[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_63391[(4)]))){
var statearr_63420_63440 = state_63391;
(statearr_63420_63440[(1)] = cljs.core.first.call(null,(state_63391[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63441 = state_63391;
state_63391 = G__63441;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2726__auto__ = function(state_63391){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2726__auto____1.call(this,state_63391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2726__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2726__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_63421 = f__2749__auto__.call(null);
(statearr_63421[(6)] = c__2748__auto__);

return statearr_63421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__63443 = arguments.length;
switch (G__63443) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_63510){
var state_val_63511 = (state_63510[(1)]);
if((state_val_63511 === (7))){
var inst_63455 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63456 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63457 = cljs.core.PersistentHashMap.fromArrays(inst_63455,inst_63456);
var inst_63458 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_63457);
var inst_63459 = (function(){throw inst_63458})();
var state_63510__$1 = state_63510;
var statearr_63512_63551 = state_63510__$1;
(statearr_63512_63551[(2)] = inst_63459);

(statearr_63512_63551[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (20))){
var inst_63493 = (state_63510[(2)]);
var inst_63494 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63495 = [ledger,password,user,auth,expire];
var inst_63496 = cljs.core.PersistentHashMap.fromArrays(inst_63494,inst_63495);
var inst_63497 = fluree.db.util.core.without_nils.call(null,inst_63496);
var inst_63498 = cljs.core.async.promise_chan.call(null);
var inst_63499 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63501 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_63497,inst_63498,null];
var inst_63502 = (new cljs.core.PersistentVector(null,4,(5),inst_63500,inst_63501,null));
var inst_63503 = cljs.core.async.put_BANG_.call(null,inst_63499,inst_63502);
var inst_63504 = (function (){var _ = inst_63493;
var data = inst_63497;
var pc = inst_63498;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_63505 = cljs.core.async.take_BANG_.call(null,inst_63498,inst_63504);
var _ = (function (){var statearr_63513 = state_63510;
(statearr_63513[(4)] = cljs.core.rest.call(null,(state_63510[(4)])));

return statearr_63513;
})();
var state_63510__$1 = (function (){var statearr_63514 = state_63510;
(statearr_63514[(7)] = inst_63503);

return statearr_63514;
})();
var statearr_63515_63552 = state_63510__$1;
(statearr_63515_63552[(2)] = inst_63505);

(statearr_63515_63552[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (1))){
var state_63510__$1 = state_63510;
var statearr_63516_63553 = state_63510__$1;
(statearr_63516_63553[(2)] = null);

(statearr_63516_63553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (4))){
var inst_63444 = (state_63510[(2)]);
var inst_63445 = cljs.core.clj__GT_js.call(null,inst_63444);
var inst_63446 = reject.call(null,inst_63445);
var state_63510__$1 = state_63510;
var statearr_63517_63554 = state_63510__$1;
(statearr_63517_63554[(2)] = inst_63446);

(statearr_63517_63554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (15))){
var inst_63480 = (state_63510[(8)]);
var state_63510__$1 = state_63510;
var statearr_63518_63555 = state_63510__$1;
(statearr_63518_63555[(2)] = inst_63480);

(statearr_63518_63555[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (13))){
var inst_63473 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63474 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63475 = cljs.core.PersistentHashMap.fromArrays(inst_63473,inst_63474);
var inst_63476 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_63475);
var inst_63477 = (function(){throw inst_63476})();
var state_63510__$1 = state_63510;
var statearr_63519_63556 = state_63510__$1;
(statearr_63519_63556[(2)] = inst_63477);

(statearr_63519_63556[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (6))){
var state_63510__$1 = state_63510;
var statearr_63520_63557 = state_63510__$1;
(statearr_63520_63557[(2)] = null);

(statearr_63520_63557[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (17))){
var inst_63484 = (state_63510[(2)]);
var state_63510__$1 = state_63510;
if(cljs.core.truth_(inst_63484)){
var statearr_63521_63558 = state_63510__$1;
(statearr_63521_63558[(1)] = (18));

} else {
var statearr_63522_63559 = state_63510__$1;
(statearr_63522_63559[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (3))){
var inst_63508 = (state_63510[(2)]);
var state_63510__$1 = state_63510;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63510__$1,inst_63508);
} else {
if((state_val_63511 === (12))){
var state_63510__$1 = state_63510;
var statearr_63523_63560 = state_63510__$1;
(statearr_63523_63560[(2)] = null);

(statearr_63523_63560[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (2))){
var _ = (function (){var statearr_63524 = state_63510;
(statearr_63524[(4)] = cljs.core.cons.call(null,(5),(state_63510[(4)])));

return statearr_63524;
})();
var inst_63452 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_63510__$1 = state_63510;
if(cljs.core.truth_(inst_63452)){
var statearr_63525_63561 = state_63510__$1;
(statearr_63525_63561[(1)] = (6));

} else {
var statearr_63526_63562 = state_63510__$1;
(statearr_63526_63562[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (19))){
var inst_63487 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63488 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63489 = cljs.core.PersistentHashMap.fromArrays(inst_63487,inst_63488);
var inst_63490 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_63489);
var inst_63491 = (function(){throw inst_63490})();
var state_63510__$1 = state_63510;
var statearr_63527_63563 = state_63510__$1;
(statearr_63527_63563[(2)] = inst_63491);

(statearr_63527_63563[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (11))){
var inst_63470 = (state_63510[(2)]);
var state_63510__$1 = (function (){var statearr_63529 = state_63510;
(statearr_63529[(9)] = inst_63470);

return statearr_63529;
})();
if(cljs.core.truth_(password)){
var statearr_63530_63564 = state_63510__$1;
(statearr_63530_63564[(1)] = (12));

} else {
var statearr_63531_63565 = state_63510__$1;
(statearr_63531_63565[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (9))){
var state_63510__$1 = state_63510;
var statearr_63532_63566 = state_63510__$1;
(statearr_63532_63566[(2)] = null);

(statearr_63532_63566[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (5))){
var _ = (function (){var statearr_63533 = state_63510;
(statearr_63533[(4)] = cljs.core.rest.call(null,(state_63510[(4)])));

return statearr_63533;
})();
var state_63510__$1 = state_63510;
var ex63528 = (state_63510__$1[(2)]);
var statearr_63534_63567 = state_63510__$1;
(statearr_63534_63567[(5)] = ex63528);


var statearr_63535_63568 = state_63510__$1;
(statearr_63535_63568[(1)] = (4));

(statearr_63535_63568[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (14))){
var inst_63480 = (state_63510[(8)]);
var inst_63479 = (state_63510[(2)]);
var inst_63480__$1 = user;
var state_63510__$1 = (function (){var statearr_63536 = state_63510;
(statearr_63536[(10)] = inst_63479);

(statearr_63536[(8)] = inst_63480__$1);

return statearr_63536;
})();
if(cljs.core.truth_(inst_63480__$1)){
var statearr_63537_63569 = state_63510__$1;
(statearr_63537_63569[(1)] = (15));

} else {
var statearr_63538_63570 = state_63510__$1;
(statearr_63538_63570[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (16))){
var state_63510__$1 = state_63510;
var statearr_63539_63571 = state_63510__$1;
(statearr_63539_63571[(2)] = auth);

(statearr_63539_63571[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (10))){
var inst_63464 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63465 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_63466 = cljs.core.PersistentHashMap.fromArrays(inst_63464,inst_63465);
var inst_63467 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_63466);
var inst_63468 = (function(){throw inst_63467})();
var state_63510__$1 = state_63510;
var statearr_63540_63572 = state_63510__$1;
(statearr_63540_63572[(2)] = inst_63468);

(statearr_63540_63572[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (18))){
var state_63510__$1 = state_63510;
var statearr_63541_63573 = state_63510__$1;
(statearr_63541_63573[(2)] = null);

(statearr_63541_63573[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63511 === (8))){
var inst_63461 = (state_63510[(2)]);
var state_63510__$1 = (function (){var statearr_63542 = state_63510;
(statearr_63542[(11)] = inst_63461);

return statearr_63542;
})();
if(cljs.core.truth_(ledger)){
var statearr_63543_63574 = state_63510__$1;
(statearr_63543_63574[(1)] = (9));

} else {
var statearr_63544_63575 = state_63510__$1;
(statearr_63544_63575[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2726__auto__ = null;
var fluree$db$connection_js$state_machine__2726__auto____0 = (function (){
var statearr_63545 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_63545[(0)] = fluree$db$connection_js$state_machine__2726__auto__);

(statearr_63545[(1)] = (1));

return statearr_63545;
});
var fluree$db$connection_js$state_machine__2726__auto____1 = (function (state_63510){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_63510);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e63546){var ex__2729__auto__ = e63546;
var statearr_63547_63576 = state_63510;
(statearr_63547_63576[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_63510[(4)]))){
var statearr_63548_63577 = state_63510;
(statearr_63548_63577[(1)] = cljs.core.first.call(null,(state_63510[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63578 = state_63510;
state_63510 = G__63578;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2726__auto__ = function(state_63510){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2726__auto____1.call(this,state_63510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2726__auto____0;
fluree$db$connection_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2726__auto____1;
return fluree$db$connection_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_63549 = f__2749__auto__.call(null);
(statearr_63549[(6)] = c__2748__auto__);

return statearr_63549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__63580 = arguments.length;
switch (G__63580) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_63615){
var state_val_63616 = (state_63615[(1)]);
if((state_val_63616 === (1))){
var state_63615__$1 = state_63615;
var statearr_63617_63637 = state_63615__$1;
(statearr_63617_63637[(2)] = null);

(statearr_63617_63637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63616 === (2))){
var _ = (function (){var statearr_63618 = state_63615;
(statearr_63618[(4)] = cljs.core.cons.call(null,(5),(state_63615[(4)])));

return statearr_63618;
})();
var inst_63589 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_63615__$1 = state_63615;
if(cljs.core.truth_(inst_63589)){
var statearr_63619_63638 = state_63615__$1;
(statearr_63619_63638[(1)] = (6));

} else {
var statearr_63620_63639 = state_63615__$1;
(statearr_63620_63639[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63616 === (3))){
var inst_63613 = (state_63615[(2)]);
var state_63615__$1 = state_63615;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63615__$1,inst_63613);
} else {
if((state_val_63616 === (4))){
var inst_63581 = (state_63615[(2)]);
var inst_63582 = cljs.core.clj__GT_js.call(null,inst_63581);
var inst_63583 = reject.call(null,inst_63582);
var state_63615__$1 = state_63615;
var statearr_63622_63640 = state_63615__$1;
(statearr_63622_63640[(2)] = inst_63583);

(statearr_63622_63640[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63616 === (5))){
var _ = (function (){var statearr_63623 = state_63615;
(statearr_63623[(4)] = cljs.core.rest.call(null,(state_63615[(4)])));

return statearr_63623;
})();
var state_63615__$1 = state_63615;
var ex63621 = (state_63615__$1[(2)]);
var statearr_63624_63641 = state_63615__$1;
(statearr_63624_63641[(5)] = ex63621);


var statearr_63625_63642 = state_63615__$1;
(statearr_63625_63642[(1)] = (4));

(statearr_63625_63642[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63616 === (6))){
var state_63615__$1 = state_63615;
var statearr_63626_63643 = state_63615__$1;
(statearr_63626_63643[(2)] = null);

(statearr_63626_63643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63616 === (7))){
var inst_63592 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_63593 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_63594 = cljs.core.PersistentHashMap.fromArrays(inst_63592,inst_63593);
var inst_63595 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_63594);
var inst_63596 = (function(){throw inst_63595})();
var state_63615__$1 = state_63615;
var statearr_63627_63644 = state_63615__$1;
(statearr_63627_63644[(2)] = inst_63596);

(statearr_63627_63644[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63616 === (8))){
var inst_63598 = (state_63615[(2)]);
var inst_63599 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_63600 = [jwt,expire];
var inst_63601 = cljs.core.PersistentHashMap.fromArrays(inst_63599,inst_63600);
var inst_63602 = fluree.db.util.core.without_nils.call(null,inst_63601);
var inst_63603 = cljs.core.async.promise_chan.call(null);
var inst_63604 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63606 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_63602,inst_63603,null];
var inst_63607 = (new cljs.core.PersistentVector(null,4,(5),inst_63605,inst_63606,null));
var inst_63608 = cljs.core.async.put_BANG_.call(null,inst_63604,inst_63607);
var inst_63609 = (function (){var _ = inst_63598;
var data = inst_63602;
var pc = inst_63603;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_63610 = cljs.core.async.take_BANG_.call(null,inst_63603,inst_63609);
var _ = (function (){var statearr_63628 = state_63615;
(statearr_63628[(4)] = cljs.core.rest.call(null,(state_63615[(4)])));

return statearr_63628;
})();
var state_63615__$1 = (function (){var statearr_63629 = state_63615;
(statearr_63629[(7)] = inst_63608);

return statearr_63629;
})();
var statearr_63630_63645 = state_63615__$1;
(statearr_63630_63645[(2)] = inst_63610);

(statearr_63630_63645[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2726__auto__ = null;
var fluree$db$connection_js$state_machine__2726__auto____0 = (function (){
var statearr_63631 = [null,null,null,null,null,null,null,null];
(statearr_63631[(0)] = fluree$db$connection_js$state_machine__2726__auto__);

(statearr_63631[(1)] = (1));

return statearr_63631;
});
var fluree$db$connection_js$state_machine__2726__auto____1 = (function (state_63615){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_63615);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e63632){var ex__2729__auto__ = e63632;
var statearr_63633_63646 = state_63615;
(statearr_63633_63646[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_63615[(4)]))){
var statearr_63634_63647 = state_63615;
(statearr_63634_63647[(1)] = cljs.core.first.call(null,(state_63615[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63648 = state_63615;
state_63615 = G__63648;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2726__auto__ = function(state_63615){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2726__auto____1.call(this,state_63615);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2726__auto____0;
fluree$db$connection_js$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2726__auto____1;
return fluree$db$connection_js$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_63635 = f__2749__auto__.call(null);
(statearr_63635[(6)] = c__2748__auto__);

return statearr_63635;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

