// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__4712__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.conn_events.process_event,new cljs.core.Keyword(null,"set-ws-id","set-ws-id",-1586193013),(function (conn,_,___$1,ws_id){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,new cljs.core.Keyword(null,"socket-id","socket-id",1022615280),ws_id);
}));
cljs.core._add_method.call(null,fluree.db.conn_events.process_event,new cljs.core.Keyword(null,"default","default",-1987822328),(function (conn,event_type,subject,event_data){
var callbacks = cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"listeners","listeners",394544445),subject], null));
var seq__18962 = cljs.core.seq.call(null,callbacks);
var chunk__18963 = null;
var count__18964 = (0);
var i__18965 = (0);
while(true){
if((i__18965 < count__18964)){
var vec__18974 = cljs.core._nth.call(null,chunk__18963,i__18965);
var k = cljs.core.nth.call(null,vec__18974,(0),null);
var f = cljs.core.nth.call(null,vec__18974,(1),null);
try{f.call(null,event_type,event_data);
}catch (e18977){var e_18982 = e18977;
fluree.db.util.log.error.call(null,e_18982,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__18983 = seq__18962;
var G__18984 = chunk__18963;
var G__18985 = count__18964;
var G__18986 = (i__18965 + (1));
seq__18962 = G__18983;
chunk__18963 = G__18984;
count__18964 = G__18985;
i__18965 = G__18986;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq.call(null,seq__18962);
if(temp__5753__auto__){
var seq__18962__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__18962__$1)){
var c__4649__auto__ = cljs.core.chunk_first.call(null,seq__18962__$1);
var G__18987 = cljs.core.chunk_rest.call(null,seq__18962__$1);
var G__18988 = c__4649__auto__;
var G__18989 = cljs.core.count.call(null,c__4649__auto__);
var G__18990 = (0);
seq__18962 = G__18987;
chunk__18963 = G__18988;
count__18964 = G__18989;
i__18965 = G__18990;
continue;
} else {
var vec__18978 = cljs.core.first.call(null,seq__18962__$1);
var k = cljs.core.nth.call(null,vec__18978,(0),null);
var f = cljs.core.nth.call(null,vec__18978,(1),null);
try{f.call(null,event_type,event_data);
}catch (e18981){var e_18991 = e18981;
fluree.db.util.log.error.call(null,e_18991,["Error calling registered callback: ",cljs.core.pr_str.call(null,k)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.call(null,event_data),"."].join(''));
}

var G__18992 = cljs.core.next.call(null,seq__18962__$1);
var G__18993 = null;
var G__18994 = (0);
var G__18995 = (0);
seq__18962 = G__18992;
chunk__18963 = G__18993;
count__18964 = G__18994;
i__18965 = G__18995;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.call(null,"Process events: ",msg);
var vec__18998 = msg;
var event_type = cljs.core.nth.call(null,vec__18998,(0),null);
var subject = cljs.core.nth.call(null,vec__18998,(1),null);
var event_data = cljs.core.nth.call(null,vec__18998,(2),null);
var error_data = cljs.core.nth.call(null,vec__18998,(3),null);
var event_type__$1 = cljs.core.keyword.call(null,event_type);
var map__19001 = conn;
var map__19001__$1 = cljs.core.__destructure_map.call(null,map__19001);
var state = cljs.core.get.call(null,map__19001__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var G__19002 = event_type__$1;
var G__19002__$1 = (((G__19002 instanceof cljs.core.Keyword))?G__19002.fqn:null);
switch (G__19002__$1) {
case "response":
var temp__5753__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),subject], null));
if(cljs.core.truth_(temp__5753__auto__)){
var res_chan = temp__5753__auto__;
cljs.core.swap_BANG_.call(null,state,cljs.core.update,new cljs.core.Keyword(null,"pending-req","pending-req",2064800871),(function (p1__18996_SHARP_){
return cljs.core.dissoc.call(null,p1__18996_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__19003 = error_data;
var map__19003__$1 = cljs.core.__destructure_map.call(null,map__19003);
var message = cljs.core.get.call(null,map__19003__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var exception = cljs.core.ex_info.call(null,(function (){var or__4223__auto__ = message;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.pr_str.call(null,error_data);
}
})(),cljs.core.dissoc.call(null,error_data,new cljs.core.Keyword(null,"message","message",-406056002)));
return cljs.core.async.put_BANG_.call(null,res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.call(null,res_chan,event_data);
} else {
return cljs.core.async.close_BANG_.call(null,res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data);

}
}catch (e18997){var e = e18997;
return fluree.db.util.log.error.call(null,e);
}});
