// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.call(null,cljs.core.count.call(null,clojure.string.split.call(null,source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find.call(null,/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__59959 = arguments.length;
switch (G__59959) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2748__auto___60107 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_60046){
var state_val_60047 = (state_60046[(1)]);
if((state_val_60047 === (7))){
var inst_59977 = (state_60046[(7)]);
var inst_59980 = cljs.core.not_EQ_.call(null,(0),inst_59977);
var state_60046__$1 = state_60046;
var statearr_60048_60108 = state_60046__$1;
(statearr_60048_60108[(2)] = inst_59980);

(statearr_60048_60108[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (20))){
var inst_60001 = (state_60046[(8)]);
var inst_59972 = (state_60046[(9)]);
var inst_60005 = fluree.db.auth.roles.call(null,inst_59972,inst_60001);
var state_60046__$1 = state_60046;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60046__$1,(23),inst_60005);
} else {
if((state_val_60047 === (27))){
var inst_59972 = (state_60046[(9)]);
var inst_60020 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60021 = fluree.db.time_travel.as_of_block.call(null,inst_59972,inst_60020);
var state_60046__$1 = state_60046;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60046__$1,(30),inst_60021);
} else {
if((state_val_60047 === (1))){
var state_60046__$1 = state_60046;
var statearr_60049_60109 = state_60046__$1;
(statearr_60049_60109[(2)] = null);

(statearr_60049_60109[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (24))){
var inst_60013 = (state_60046[(10)]);
var inst_59972 = (state_60046[(9)]);
var inst_60015 = fluree.db.permissions.permission_map.call(null,inst_59972,inst_60013,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_60046__$1 = state_60046;
var statearr_60050_60110 = state_60046__$1;
(statearr_60050_60110[(2)] = inst_60015);

(statearr_60050_60110[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (4))){
var inst_59960 = (state_60046[(2)]);
var inst_59961 = cljs.core.async.put_BANG_.call(null,pc,inst_59960);
var inst_59962 = cljs.core.async.close_BANG_.call(null,pc);
var state_60046__$1 = (function (){var statearr_60051 = state_60046;
(statearr_60051[(11)] = inst_59961);

return statearr_60051;
})();
var statearr_60052_60111 = state_60046__$1;
(statearr_60052_60111[(2)] = inst_59962);

(statearr_60052_60111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (15))){
var inst_59977 = (state_60046[(7)]);
var inst_59991 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_59977)," unknown."].join('');
var inst_59992 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_59993 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_59994 = cljs.core.PersistentHashMap.fromArrays(inst_59992,inst_59993);
var inst_59995 = cljs.core.ex_info.call(null,inst_59991,inst_59994);
var inst_59996 = (function(){throw inst_59995})();
var state_60046__$1 = state_60046;
var statearr_60053_60112 = state_60046__$1;
(statearr_60053_60112[(2)] = inst_59996);

(statearr_60053_60112[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (21))){
var state_60046__$1 = state_60046;
var statearr_60054_60113 = state_60046__$1;
(statearr_60054_60113[(2)] = null);

(statearr_60054_60113[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (31))){
var inst_60027 = (state_60046[(12)]);
var inst_59977 = (state_60046[(7)]);
var inst_60029 = cljs.core.assoc.call(null,inst_60027,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_59977);
var state_60046__$1 = state_60046;
var statearr_60055_60114 = state_60046__$1;
(statearr_60055_60114[(2)] = inst_60029);

(statearr_60055_60114[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (32))){
var inst_60027 = (state_60046[(12)]);
var state_60046__$1 = state_60046;
var statearr_60056_60115 = state_60046__$1;
(statearr_60056_60115[(2)] = inst_60027);

(statearr_60056_60115[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (33))){
var inst_60013 = (state_60046[(10)]);
var inst_60032 = (state_60046[(2)]);
var state_60046__$1 = (function (){var statearr_60057 = state_60046;
(statearr_60057[(13)] = inst_60032);

return statearr_60057;
})();
if(cljs.core.truth_(inst_60013)){
var statearr_60058_60116 = state_60046__$1;
(statearr_60058_60116[(1)] = (34));

} else {
var statearr_60059_60117 = state_60046__$1;
(statearr_60059_60117[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (13))){
var inst_59988 = (state_60046[(14)]);
var inst_59987 = (state_60046[(2)]);
var inst_59988__$1 = fluree.db.util.async.throw_err.call(null,inst_59987);
var state_60046__$1 = (function (){var statearr_60060 = state_60046;
(statearr_60060[(14)] = inst_59988__$1);

return statearr_60060;
})();
if(cljs.core.truth_(inst_59988__$1)){
var statearr_60061_60118 = state_60046__$1;
(statearr_60061_60118[(1)] = (14));

} else {
var statearr_60062_60119 = state_60046__$1;
(statearr_60062_60119[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (22))){
var inst_60011 = (state_60046[(2)]);
var state_60046__$1 = state_60046;
var statearr_60063_60120 = state_60046__$1;
(statearr_60063_60120[(2)] = inst_60011);

(statearr_60063_60120[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (36))){
var inst_60040 = (state_60046[(2)]);
var inst_60041 = cljs.core.async.put_BANG_.call(null,pc,inst_60040);
var _ = (function (){var statearr_60064 = state_60046;
(statearr_60064[(4)] = cljs.core.rest.call(null,(state_60046[(4)])));

return statearr_60064;
})();
var state_60046__$1 = state_60046;
var statearr_60065_60121 = state_60046__$1;
(statearr_60065_60121[(2)] = inst_60041);

(statearr_60065_60121[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (29))){
var inst_59977 = (state_60046[(7)]);
var inst_60027 = (state_60046[(2)]);
var state_60046__$1 = (function (){var statearr_60066 = state_60046;
(statearr_60066[(12)] = inst_60027);

return statearr_60066;
})();
if(cljs.core.truth_(inst_59977)){
var statearr_60067_60122 = state_60046__$1;
(statearr_60067_60122[(1)] = (31));

} else {
var statearr_60068_60123 = state_60046__$1;
(statearr_60068_60123[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (6))){
var inst_59977 = (state_60046[(7)]);
var inst_59971 = (state_60046[(2)]);
var inst_59972 = fluree.db.util.async.throw_err.call(null,inst_59971);
var inst_59973 = opts;
var inst_59974 = cljs.core.__destructure_map.call(null,inst_59973);
var inst_59975 = cljs.core.get.call(null,inst_59974,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_59976 = cljs.core.get.call(null,inst_59974,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_59977__$1 = cljs.core.get.call(null,inst_59974,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_59978 = cljs.core.get.call(null,inst_59974,new cljs.core.Keyword(null,"block","block",664686210));
var state_60046__$1 = (function (){var statearr_60069 = state_60046;
(statearr_60069[(15)] = inst_59978);

(statearr_60069[(16)] = inst_59975);

(statearr_60069[(9)] = inst_59972);

(statearr_60069[(7)] = inst_59977__$1);

(statearr_60069[(17)] = inst_59976);

return statearr_60069;
})();
if(cljs.core.truth_(inst_59977__$1)){
var statearr_60070_60124 = state_60046__$1;
(statearr_60070_60124[(1)] = (7));

} else {
var statearr_60071_60125 = state_60046__$1;
(statearr_60071_60125[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (28))){
var inst_59972 = (state_60046[(9)]);
var state_60046__$1 = state_60046;
var statearr_60072_60126 = state_60046__$1;
(statearr_60072_60126[(2)] = inst_59972);

(statearr_60072_60126[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (25))){
var state_60046__$1 = state_60046;
var statearr_60073_60127 = state_60046__$1;
(statearr_60073_60127[(2)] = null);

(statearr_60073_60127[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (34))){
var inst_60018 = (state_60046[(18)]);
var state_60046__$1 = state_60046;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60046__$1,(37),inst_60018);
} else {
if((state_val_60047 === (17))){
var inst_59975 = (state_60046[(16)]);
var state_60046__$1 = state_60046;
var statearr_60074_60128 = state_60046__$1;
(statearr_60074_60128[(2)] = inst_59975);

(statearr_60074_60128[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (3))){
var inst_60044 = (state_60046[(2)]);
var state_60046__$1 = state_60046;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60046__$1,inst_60044);
} else {
if((state_val_60047 === (12))){
var inst_59975 = (state_60046[(16)]);
var inst_60001 = (state_60046[(2)]);
var state_60046__$1 = (function (){var statearr_60075 = state_60046;
(statearr_60075[(8)] = inst_60001);

return statearr_60075;
})();
if(cljs.core.truth_(inst_59975)){
var statearr_60076_60129 = state_60046__$1;
(statearr_60076_60129[(1)] = (17));

} else {
var statearr_60077_60130 = state_60046__$1;
(statearr_60077_60130[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (2))){
var _ = (function (){var statearr_60078 = state_60046;
(statearr_60078[(4)] = cljs.core.cons.call(null,(5),(state_60046[(4)])));

return statearr_60078;
})();
var inst_59969 = fluree.db.session.db.call(null,conn,ledger,null);
var state_60046__$1 = state_60046;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60046__$1,(6),inst_59969);
} else {
if((state_val_60047 === (23))){
var inst_60007 = (state_60046[(2)]);
var inst_60008 = fluree.db.util.async.throw_err.call(null,inst_60007);
var state_60046__$1 = state_60046;
var statearr_60079_60131 = state_60046__$1;
(statearr_60079_60131[(2)] = inst_60008);

(statearr_60079_60131[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (35))){
var inst_60032 = (state_60046[(13)]);
var state_60046__$1 = state_60046;
var statearr_60080_60132 = state_60046__$1;
(statearr_60080_60132[(2)] = inst_60032);

(statearr_60080_60132[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (19))){
var inst_60013 = (state_60046[(10)]);
var inst_60013__$1 = (state_60046[(2)]);
var state_60046__$1 = (function (){var statearr_60081 = state_60046;
(statearr_60081[(10)] = inst_60013__$1);

return statearr_60081;
})();
if(cljs.core.truth_(inst_60013__$1)){
var statearr_60082_60133 = state_60046__$1;
(statearr_60082_60133[(1)] = (24));

} else {
var statearr_60083_60134 = state_60046__$1;
(statearr_60083_60134[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (11))){
var state_60046__$1 = state_60046;
var statearr_60085_60135 = state_60046__$1;
(statearr_60085_60135[(2)] = null);

(statearr_60085_60135[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (9))){
var inst_59983 = (state_60046[(2)]);
var state_60046__$1 = state_60046;
if(cljs.core.truth_(inst_59983)){
var statearr_60086_60136 = state_60046__$1;
(statearr_60086_60136[(1)] = (10));

} else {
var statearr_60087_60137 = state_60046__$1;
(statearr_60087_60137[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (5))){
var _ = (function (){var statearr_60088 = state_60046;
(statearr_60088[(4)] = cljs.core.rest.call(null,(state_60046[(4)])));

return statearr_60088;
})();
var state_60046__$1 = state_60046;
var ex60084 = (state_60046__$1[(2)]);
var statearr_60089_60138 = state_60046__$1;
(statearr_60089_60138[(5)] = ex60084);


var statearr_60090_60139 = state_60046__$1;
(statearr_60090_60139[(1)] = (4));

(statearr_60090_60139[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (14))){
var inst_59988 = (state_60046[(14)]);
var state_60046__$1 = state_60046;
var statearr_60091_60140 = state_60046__$1;
(statearr_60091_60140[(2)] = inst_59988);

(statearr_60091_60140[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (26))){
var inst_59978 = (state_60046[(15)]);
var inst_60018 = (state_60046[(2)]);
var state_60046__$1 = (function (){var statearr_60092 = state_60046;
(statearr_60092[(18)] = inst_60018);

return statearr_60092;
})();
if(cljs.core.truth_(inst_59978)){
var statearr_60093_60141 = state_60046__$1;
(statearr_60093_60141[(1)] = (27));

} else {
var statearr_60094_60142 = state_60046__$1;
(statearr_60094_60142[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (16))){
var inst_59998 = (state_60046[(2)]);
var state_60046__$1 = state_60046;
var statearr_60095_60143 = state_60046__$1;
(statearr_60095_60143[(2)] = inst_59998);

(statearr_60095_60143[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (30))){
var inst_60023 = (state_60046[(2)]);
var inst_60024 = fluree.db.util.async.throw_err.call(null,inst_60023);
var state_60046__$1 = state_60046;
var statearr_60096_60144 = state_60046__$1;
(statearr_60096_60144[(2)] = inst_60024);

(statearr_60096_60144[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (10))){
var inst_59972 = (state_60046[(9)]);
var inst_59977 = (state_60046[(7)]);
var inst_59985 = fluree.db.dbproto._subid.call(null,inst_59972,inst_59977);
var state_60046__$1 = state_60046;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60046__$1,(13),inst_59985);
} else {
if((state_val_60047 === (18))){
var inst_60001 = (state_60046[(8)]);
var state_60046__$1 = state_60046;
if(cljs.core.truth_(inst_60001)){
var statearr_60097_60145 = state_60046__$1;
(statearr_60097_60145[(1)] = (20));

} else {
var statearr_60098_60146 = state_60046__$1;
(statearr_60098_60146[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (37))){
var inst_60032 = (state_60046[(13)]);
var inst_60035 = (state_60046[(2)]);
var inst_60036 = fluree.db.util.async.throw_err.call(null,inst_60035);
var inst_60037 = cljs.core.assoc.call(null,inst_60032,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_60036);
var state_60046__$1 = state_60046;
var statearr_60099_60147 = state_60046__$1;
(statearr_60099_60147[(2)] = inst_60037);

(statearr_60099_60147[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60047 === (8))){
var inst_59977 = (state_60046[(7)]);
var state_60046__$1 = state_60046;
var statearr_60100_60148 = state_60046__$1;
(statearr_60100_60148[(2)] = inst_59977);

(statearr_60100_60148[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2726__auto__ = null;
var fluree$db$api$query$state_machine__2726__auto____0 = (function (){
var statearr_60101 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60101[(0)] = fluree$db$api$query$state_machine__2726__auto__);

(statearr_60101[(1)] = (1));

return statearr_60101;
});
var fluree$db$api$query$state_machine__2726__auto____1 = (function (state_60046){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_60046);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e60102){var ex__2729__auto__ = e60102;
var statearr_60103_60149 = state_60046;
(statearr_60103_60149[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_60046[(4)]))){
var statearr_60104_60150 = state_60046;
(statearr_60104_60150[(1)] = cljs.core.first.call(null,(state_60046[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60151 = state_60046;
state_60046 = G__60151;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2726__auto__ = function(state_60046){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2726__auto____1.call(this,state_60046);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2726__auto____0;
fluree$db$api$query$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2726__auto____1;
return fluree$db$api$query$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_60105 = f__2749__auto__.call(null);
(statearr_60105[(6)] = c__2748__auto___60107);

return statearr_60105;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv.call(null,(function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/[a-z]+/,fluree.db.util.core.keyword__GT_str.call(null,key)))){
} else {
throw cljs.core.ex_info.call(null,["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str.call(null,key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_.call(null,val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id.call(null,val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.call(null,conn,ledger,opts);
return cljs.core.assoc.call(null,acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_60292){
var state_val_60293 = (state_60292[(1)]);
if((state_val_60293 === (7))){
var inst_60172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60173 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60174 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60175 = [inst_60173,inst_60174];
var inst_60176 = (new cljs.core.PersistentVector(null,2,(5),inst_60172,inst_60175,null));
var state_60292__$1 = state_60292;
var statearr_60294_60364 = state_60292__$1;
(statearr_60294_60364[(2)] = inst_60176);

(statearr_60294_60364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (20))){
var inst_60202 = (state_60292[(7)]);
var state_60292__$1 = state_60292;
var statearr_60295_60365 = state_60292__$1;
(statearr_60295_60365[(2)] = inst_60202);

(statearr_60295_60365[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (27))){
var state_60292__$1 = state_60292;
var statearr_60296_60366 = state_60292__$1;
(statearr_60296_60366[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (1))){
var state_60292__$1 = state_60292;
var statearr_60298_60367 = state_60292__$1;
(statearr_60298_60367[(2)] = null);

(statearr_60298_60367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (24))){
var inst_60201 = (state_60292[(8)]);
var state_60292__$1 = state_60292;
if(cljs.core.truth_(inst_60201)){
var statearr_60299_60368 = state_60292__$1;
(statearr_60299_60368[(1)] = (26));

} else {
var statearr_60300_60369 = state_60292__$1;
(statearr_60300_60369[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (39))){
var inst_60248 = (state_60292[(9)]);
var inst_60247 = (state_60292[(10)]);
var inst_60273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60274 = [inst_60247,inst_60248];
var inst_60275 = (new cljs.core.PersistentVector(null,2,(5),inst_60273,inst_60274,null));
var state_60292__$1 = state_60292;
var statearr_60301_60370 = state_60292__$1;
(statearr_60301_60370[(2)] = inst_60275);

(statearr_60301_60370[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (4))){
var inst_60152 = (state_60292[(2)]);
var state_60292__$1 = state_60292;
var statearr_60302_60371 = state_60292__$1;
(statearr_60302_60371[(2)] = inst_60152);

(statearr_60302_60371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (15))){
var inst_60181 = (state_60292[(11)]);
var inst_60186 = (state_60292[(12)]);
var inst_60195 = (state_60292[(2)]);
var inst_60196 = [inst_60186,inst_60195];
var inst_60197 = (new cljs.core.PersistentVector(null,2,(5),inst_60181,inst_60196,null));
var state_60292__$1 = state_60292;
var statearr_60303_60372 = state_60292__$1;
(statearr_60303_60372[(2)] = inst_60197);

(statearr_60303_60372[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (21))){
var inst_60201 = (state_60292[(8)]);
var state_60292__$1 = state_60292;
var statearr_60304_60373 = state_60292__$1;
(statearr_60304_60373[(2)] = inst_60201);

(statearr_60304_60373[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (31))){
var inst_60242 = (state_60292[(2)]);
var state_60292__$1 = state_60292;
var statearr_60305_60374 = state_60292__$1;
(statearr_60305_60374[(2)] = inst_60242);

(statearr_60305_60374[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (32))){
var inst_60248 = (state_60292[(9)]);
var inst_60251 = cljs.core.pos_int_QMARK_.call(null,inst_60248);
var state_60292__$1 = state_60292;
var statearr_60306_60375 = state_60292__$1;
(statearr_60306_60375[(2)] = inst_60251);

(statearr_60306_60375[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (40))){
var inst_60279 = (state_60292[(13)]);
var inst_60203 = (state_60292[(14)]);
var inst_60277 = (state_60292[(2)]);
var inst_60278 = cljs.core.nth.call(null,inst_60277,(0),null);
var inst_60279__$1 = cljs.core.nth.call(null,inst_60277,(1),null);
var inst_60280 = (inst_60279__$1 > inst_60203);
var state_60292__$1 = (function (){var statearr_60307 = state_60292;
(statearr_60307[(15)] = inst_60278);

(statearr_60307[(13)] = inst_60279__$1);

return statearr_60307;
})();
if(cljs.core.truth_(inst_60280)){
var statearr_60308_60376 = state_60292__$1;
(statearr_60308_60376[(1)] = (41));

} else {
var statearr_60309_60377 = state_60292__$1;
(statearr_60309_60377[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (33))){
var inst_60249 = (state_60292[(16)]);
var state_60292__$1 = state_60292;
var statearr_60310_60378 = state_60292__$1;
(statearr_60310_60378[(2)] = inst_60249);

(statearr_60310_60378[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (13))){
var inst_60187 = (state_60292[(17)]);
var inst_60189 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_60187);
var state_60292__$1 = state_60292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60292__$1,(16),inst_60189);
} else {
if((state_val_60293 === (22))){
var inst_60220 = (state_60292[(2)]);
var state_60292__$1 = state_60292;
if(cljs.core.truth_(inst_60220)){
var statearr_60311_60379 = state_60292__$1;
(statearr_60311_60379[(1)] = (23));

} else {
var statearr_60312_60380 = state_60292__$1;
(statearr_60312_60380[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (36))){
var state_60292__$1 = state_60292;
var statearr_60313_60381 = state_60292__$1;
(statearr_60313_60381[(2)] = null);

(statearr_60313_60381[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (41))){
var inst_60203 = (state_60292[(14)]);
var state_60292__$1 = state_60292;
var statearr_60314_60382 = state_60292__$1;
(statearr_60314_60382[(2)] = inst_60203);

(statearr_60314_60382[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (43))){
var inst_60278 = (state_60292[(15)]);
var inst_60284 = (state_60292[(2)]);
var inst_60285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60286 = [inst_60278,inst_60284];
var inst_60287 = (new cljs.core.PersistentVector(null,2,(5),inst_60285,inst_60286,null));
var _ = (function (){var statearr_60315 = state_60292;
(statearr_60315[(4)] = cljs.core.rest.call(null,(state_60292[(4)])));

return statearr_60315;
})();
var state_60292__$1 = state_60292;
var statearr_60316_60383 = state_60292__$1;
(statearr_60316_60383[(2)] = inst_60287);

(statearr_60316_60383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (29))){
var inst_60178 = (state_60292[(18)]);
var inst_60233 = cljs.core.pr_str.call(null,inst_60178);
var inst_60234 = ["Invalid block range provided: ",inst_60233].join('');
var inst_60235 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60236 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60237 = cljs.core.PersistentHashMap.fromArrays(inst_60235,inst_60236);
var inst_60238 = cljs.core.ex_info.call(null,inst_60234,inst_60237);
var inst_60239 = (function(){throw inst_60238})();
var state_60292__$1 = state_60292;
var statearr_60317_60384 = state_60292__$1;
(statearr_60317_60384[(2)] = inst_60239);

(statearr_60317_60384[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (6))){
var inst_60170 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_60292__$1 = state_60292;
var statearr_60318_60385 = state_60292__$1;
(statearr_60318_60385[(2)] = inst_60170);

(statearr_60318_60385[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (28))){
var inst_60244 = (state_60292[(2)]);
var state_60292__$1 = state_60292;
var statearr_60319_60386 = state_60292__$1;
(statearr_60319_60386[(2)] = inst_60244);

(statearr_60319_60386[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (25))){
var inst_60247 = (state_60292[(10)]);
var inst_60249 = (state_60292[(16)]);
var inst_60246 = (state_60292[(2)]);
var inst_60247__$1 = cljs.core.nth.call(null,inst_60246,(0),null);
var inst_60248 = cljs.core.nth.call(null,inst_60246,(1),null);
var inst_60249__$1 = cljs.core.pos_int_QMARK_.call(null,inst_60247__$1);
var state_60292__$1 = (function (){var statearr_60320 = state_60292;
(statearr_60320[(9)] = inst_60248);

(statearr_60320[(10)] = inst_60247__$1);

(statearr_60320[(16)] = inst_60249__$1);

return statearr_60320;
})();
if(inst_60249__$1){
var statearr_60321_60387 = state_60292__$1;
(statearr_60321_60387[(1)] = (32));

} else {
var statearr_60322_60388 = state_60292__$1;
(statearr_60322_60388[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (34))){
var inst_60254 = (state_60292[(2)]);
var inst_60255 = cljs.core.not.call(null,inst_60254);
var state_60292__$1 = state_60292;
if(inst_60255){
var statearr_60323_60389 = state_60292__$1;
(statearr_60323_60389[(1)] = (35));

} else {
var statearr_60324_60390 = state_60292__$1;
(statearr_60324_60390[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (17))){
var inst_60201 = (state_60292[(8)]);
var inst_60203 = (state_60292[(14)]);
var inst_60206 = cljs.core.pr_str.call(null,inst_60201);
var inst_60207 = cljs.core.pr_str.call(null,inst_60203);
var inst_60208 = ["Start block is out of range for this ledger. Start block provided: ",inst_60206,". Database block: ",inst_60207].join('');
var inst_60209 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60210 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60211 = cljs.core.PersistentHashMap.fromArrays(inst_60209,inst_60210);
var inst_60212 = cljs.core.ex_info.call(null,inst_60208,inst_60211);
var inst_60213 = (function(){throw inst_60212})();
var state_60292__$1 = state_60292;
var statearr_60325_60391 = state_60292__$1;
(statearr_60325_60391[(2)] = inst_60213);

(statearr_60325_60391[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (3))){
var inst_60290 = (state_60292[(2)]);
var state_60292__$1 = state_60292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60292__$1,inst_60290);
} else {
if((state_val_60293 === (12))){
var inst_60178 = (state_60292[(18)]);
var inst_60187 = (state_60292[(17)]);
var inst_60185 = (state_60292[(2)]);
var inst_60186 = fluree.db.util.async.throw_err.call(null,inst_60185);
var inst_60187__$1 = cljs.core.second.call(null,inst_60178);
var state_60292__$1 = (function (){var statearr_60326 = state_60292;
(statearr_60326[(12)] = inst_60186);

(statearr_60326[(17)] = inst_60187__$1);

return statearr_60326;
})();
if(cljs.core.truth_(inst_60187__$1)){
var statearr_60327_60392 = state_60292__$1;
(statearr_60327_60392[(1)] = (13));

} else {
var statearr_60328_60393 = state_60292__$1;
(statearr_60328_60393[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (2))){
var _ = (function (){var statearr_60329 = state_60292;
(statearr_60329[(4)] = cljs.core.cons.call(null,(5),(state_60292[(4)])));

return statearr_60329;
})();
var inst_60167 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60168 = cljs.core.sequential_QMARK_.call(null,inst_60167);
var state_60292__$1 = state_60292;
if(inst_60168){
var statearr_60330_60394 = state_60292__$1;
(statearr_60330_60394[(1)] = (6));

} else {
var statearr_60331_60395 = state_60292__$1;
(statearr_60331_60395[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (23))){
var inst_60202 = (state_60292[(7)]);
var inst_60201 = (state_60292[(8)]);
var inst_60222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60223 = [inst_60201,inst_60202];
var inst_60224 = (new cljs.core.PersistentVector(null,2,(5),inst_60222,inst_60223,null));
var state_60292__$1 = state_60292;
var statearr_60332_60396 = state_60292__$1;
(statearr_60332_60396[(2)] = inst_60224);

(statearr_60332_60396[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (35))){
var inst_60178 = (state_60292[(18)]);
var inst_60257 = cljs.core.pr_str.call(null,inst_60178);
var inst_60258 = ["Invalid block range provided: ",inst_60257].join('');
var inst_60259 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60260 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60261 = cljs.core.PersistentHashMap.fromArrays(inst_60259,inst_60260);
var inst_60262 = cljs.core.ex_info.call(null,inst_60258,inst_60261);
var inst_60263 = (function(){throw inst_60262})();
var state_60292__$1 = state_60292;
var statearr_60333_60397 = state_60292__$1;
(statearr_60333_60397[(2)] = inst_60263);

(statearr_60333_60397[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (19))){
var inst_60201 = (state_60292[(8)]);
var inst_60216 = (state_60292[(2)]);
var state_60292__$1 = (function (){var statearr_60334 = state_60292;
(statearr_60334[(19)] = inst_60216);

return statearr_60334;
})();
if(cljs.core.truth_(inst_60201)){
var statearr_60335_60398 = state_60292__$1;
(statearr_60335_60398[(1)] = (20));

} else {
var statearr_60336_60399 = state_60292__$1;
(statearr_60336_60399[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (11))){
var inst_60201 = (state_60292[(8)]);
var inst_60203 = (state_60292[(14)]);
var inst_60200 = (state_60292[(2)]);
var inst_60201__$1 = cljs.core.nth.call(null,inst_60200,(0),null);
var inst_60202 = cljs.core.nth.call(null,inst_60200,(1),null);
var inst_60203__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60204 = (inst_60201__$1 > inst_60203__$1);
var state_60292__$1 = (function (){var statearr_60338 = state_60292;
(statearr_60338[(7)] = inst_60202);

(statearr_60338[(8)] = inst_60201__$1);

(statearr_60338[(14)] = inst_60203__$1);

return statearr_60338;
})();
if(cljs.core.truth_(inst_60204)){
var statearr_60339_60400 = state_60292__$1;
(statearr_60339_60400[(1)] = (17));

} else {
var statearr_60340_60401 = state_60292__$1;
(statearr_60340_60401[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (9))){
var inst_60178 = (state_60292[(18)]);
var inst_60181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60182 = cljs.core.first.call(null,inst_60178);
var inst_60183 = fluree.db.time_travel.block_to_int_format.call(null,db,inst_60182);
var state_60292__$1 = (function (){var statearr_60341 = state_60292;
(statearr_60341[(11)] = inst_60181);

return statearr_60341;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60292__$1,(12),inst_60183);
} else {
if((state_val_60293 === (5))){
var _ = (function (){var statearr_60342 = state_60292;
(statearr_60342[(4)] = cljs.core.rest.call(null,(state_60292[(4)])));

return statearr_60342;
})();
var state_60292__$1 = state_60292;
var ex60337 = (state_60292__$1[(2)]);
var statearr_60343_60402 = state_60292__$1;
(statearr_60343_60402[(5)] = ex60337);


if((ex60337 instanceof Error)){
var statearr_60344_60403 = state_60292__$1;
(statearr_60344_60403[(1)] = (4));

(statearr_60344_60403[(5)] = null);

} else {
throw ex60337;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (14))){
var state_60292__$1 = state_60292;
var statearr_60345_60404 = state_60292__$1;
(statearr_60345_60404[(2)] = null);

(statearr_60345_60404[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (26))){
var inst_60201 = (state_60292[(8)]);
var inst_60227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60228 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60229 = [inst_60201,inst_60228];
var inst_60230 = (new cljs.core.PersistentVector(null,2,(5),inst_60227,inst_60229,null));
var state_60292__$1 = state_60292;
var statearr_60346_60405 = state_60292__$1;
(statearr_60346_60405[(2)] = inst_60230);

(statearr_60346_60405[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (16))){
var inst_60191 = (state_60292[(2)]);
var inst_60192 = fluree.db.util.async.throw_err.call(null,inst_60191);
var state_60292__$1 = state_60292;
var statearr_60347_60406 = state_60292__$1;
(statearr_60347_60406[(2)] = inst_60192);

(statearr_60347_60406[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (38))){
var inst_60248 = (state_60292[(9)]);
var inst_60247 = (state_60292[(10)]);
var inst_60269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60270 = [inst_60248,inst_60247];
var inst_60271 = (new cljs.core.PersistentVector(null,2,(5),inst_60269,inst_60270,null));
var state_60292__$1 = state_60292;
var statearr_60348_60407 = state_60292__$1;
(statearr_60348_60407[(2)] = inst_60271);

(statearr_60348_60407[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (30))){
var state_60292__$1 = state_60292;
var statearr_60349_60408 = state_60292__$1;
(statearr_60349_60408[(2)] = null);

(statearr_60349_60408[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (10))){
var inst_60178 = (state_60292[(18)]);
var state_60292__$1 = state_60292;
var statearr_60350_60409 = state_60292__$1;
(statearr_60350_60409[(2)] = inst_60178);

(statearr_60350_60409[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (18))){
var state_60292__$1 = state_60292;
var statearr_60351_60410 = state_60292__$1;
(statearr_60351_60410[(2)] = null);

(statearr_60351_60410[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (42))){
var inst_60279 = (state_60292[(13)]);
var state_60292__$1 = state_60292;
var statearr_60352_60411 = state_60292__$1;
(statearr_60352_60411[(2)] = inst_60279);

(statearr_60352_60411[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (37))){
var inst_60248 = (state_60292[(9)]);
var inst_60247 = (state_60292[(10)]);
var inst_60266 = (state_60292[(2)]);
var inst_60267 = (inst_60248 < inst_60247);
var state_60292__$1 = (function (){var statearr_60353 = state_60292;
(statearr_60353[(20)] = inst_60266);

return statearr_60353;
})();
if(cljs.core.truth_(inst_60267)){
var statearr_60354_60412 = state_60292__$1;
(statearr_60354_60412[(1)] = (38));

} else {
var statearr_60355_60413 = state_60292__$1;
(statearr_60355_60413[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60293 === (8))){
var inst_60178 = (state_60292[(18)]);
var inst_60178__$1 = (state_60292[(2)]);
var inst_60179 = cljs.core.some.call(null,cljs.core.string_QMARK_,inst_60178__$1);
var state_60292__$1 = (function (){var statearr_60356 = state_60292;
(statearr_60356[(18)] = inst_60178__$1);

return statearr_60356;
})();
if(cljs.core.truth_(inst_60179)){
var statearr_60357_60414 = state_60292__$1;
(statearr_60357_60414[(1)] = (9));

} else {
var statearr_60358_60415 = state_60292__$1;
(statearr_60358_60415[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2726__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2726__auto____0 = (function (){
var statearr_60359 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60359[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2726__auto__);

(statearr_60359[(1)] = (1));

return statearr_60359;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2726__auto____1 = (function (state_60292){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_60292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e60360){var ex__2729__auto__ = e60360;
var statearr_60361_60416 = state_60292;
(statearr_60361_60416[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_60292[(4)]))){
var statearr_60362_60417 = state_60292;
(statearr_60362_60417[(1)] = cljs.core.first.call(null,(state_60292[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60418 = state_60292;
state_60292 = G__60418;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2726__auto__ = function(state_60292){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2726__auto____1.call(this,state_60292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2726__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2726__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_60363 = f__2749__auto__.call(null);
(statearr_60363[(6)] = c__2748__auto__);

return statearr_60363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_60568){
var state_val_60569 = (state_60568[(1)]);
if((state_val_60569 === (7))){
var inst_60480 = (state_60568[(2)]);
var inst_60481 = cljs.core.nth.call(null,inst_60480,(0),null);
var inst_60482 = cljs.core.nth.call(null,inst_60480,(1),null);
var inst_60490 = cljs.core.vals.call(null,inst_60482);
var inst_60491 = cljs.core.seq.call(null,inst_60490);
var inst_60492 = cljs.core.first.call(null,inst_60491);
var inst_60493 = cljs.core.next.call(null,inst_60491);
var inst_60494 = cljs.core.PersistentVector.EMPTY;
var inst_60495 = inst_60490;
var inst_60496 = inst_60494;
var state_60568__$1 = (function (){var statearr_60570 = state_60568;
(statearr_60570[(7)] = inst_60481);

(statearr_60570[(8)] = inst_60496);

(statearr_60570[(9)] = inst_60493);

(statearr_60570[(10)] = inst_60492);

(statearr_60570[(11)] = inst_60495);

return statearr_60570;
})();
var statearr_60571_60624 = state_60568__$1;
(statearr_60571_60624[(2)] = null);

(statearr_60571_60624[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (20))){
var inst_60502 = (state_60568[(12)]);
var inst_60507 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60508 = cljs.core.PersistentHashMap.EMPTY;
var inst_60509 = [true,inst_60508];
var inst_60510 = cljs.core.PersistentHashMap.fromArrays(inst_60507,inst_60509);
var inst_60511 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_60510,inst_60502);
var state_60568__$1 = state_60568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60568__$1,(22),inst_60511);
} else {
if((state_val_60569 === (27))){
var inst_60556 = (state_60568[(2)]);
var state_60568__$1 = state_60568;
var statearr_60572_60625 = state_60568__$1;
(statearr_60572_60625[(2)] = inst_60556);

(statearr_60572_60625[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (1))){
var state_60568__$1 = state_60568;
var statearr_60573_60626 = state_60568__$1;
(statearr_60573_60626[(2)] = null);

(statearr_60573_60626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (24))){
var inst_60520 = (state_60568[(13)]);
var inst_60558 = (state_60568[(2)]);
var inst_60559 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_60560 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60561 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60562 = [inst_60560,inst_60561,inst_60520,inst_60558];
var inst_60563 = cljs.core.PersistentHashMap.fromArrays(inst_60559,inst_60562);
var _ = (function (){var statearr_60575 = state_60568;
(statearr_60575[(4)] = cljs.core.rest.call(null,(state_60568[(4)])));

return statearr_60575;
})();
var state_60568__$1 = state_60568;
var statearr_60576_60627 = state_60568__$1;
(statearr_60576_60627[(2)] = inst_60563);

(statearr_60576_60627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (4))){
var inst_60421 = (state_60568[(2)]);
var state_60568__$1 = state_60568;
var statearr_60577_60628 = state_60568__$1;
(statearr_60577_60628[(2)] = inst_60421);

(statearr_60577_60628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (15))){
var inst_60445 = (state_60568[(14)]);
var inst_60443 = (state_60568[(15)]);
var inst_60437 = (state_60568[(16)]);
var inst_60466 = (state_60568[(17)]);
var inst_60444 = (state_60568[(18)]);
var inst_60461 = (state_60568[(19)]);
var inst_60459 = (state_60568[(20)]);
var inst_60451 = (state_60568[(21)]);
var inst_60439 = (state_60568[(22)]);
var inst_60440 = (state_60568[(23)]);
var inst_60452 = (state_60568[(24)]);
var inst_60472 = (function (){var subject = inst_60459;
var flake = inst_60451;
var vec__60447 = inst_60443;
var r = inst_60452;
var asserted_subjects = inst_60444;
var seq__60448 = inst_60452;
var G__60433 = inst_60443;
var first__60436 = inst_60439;
var flake_SINGLEQUOTE_ = inst_60466;
var retracted_subjects = inst_60445;
var first__60449 = inst_60451;
var seq__60435 = inst_60440;
var asserted_QMARK_ = inst_60461;
var vec__60434 = inst_60437;
return (function (p1__60420_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__60420_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60473 = cljs.core.update.call(null,inst_60445,inst_60459,inst_60472);
var tmp60574 = inst_60444;
var inst_60443__$1 = inst_60452;
var inst_60444__$1 = tmp60574;
var inst_60445__$1 = inst_60473;
var state_60568__$1 = (function (){var statearr_60578 = state_60568;
(statearr_60578[(14)] = inst_60445__$1);

(statearr_60578[(15)] = inst_60443__$1);

(statearr_60578[(18)] = inst_60444__$1);

return statearr_60578;
})();
var statearr_60579_60629 = state_60568__$1;
(statearr_60579_60629[(2)] = null);

(statearr_60579_60629[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (21))){
var inst_60518 = (state_60568[(2)]);
var state_60568__$1 = state_60568;
var statearr_60580_60630 = state_60568__$1;
(statearr_60580_60630[(2)] = inst_60518);

(statearr_60580_60630[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (13))){
var inst_60461 = (state_60568[(19)]);
var inst_60466 = (state_60568[(2)]);
var state_60568__$1 = (function (){var statearr_60581 = state_60568;
(statearr_60581[(17)] = inst_60466);

return statearr_60581;
})();
if(cljs.core.truth_(inst_60461)){
var statearr_60582_60631 = state_60568__$1;
(statearr_60582_60631[(1)] = (14));

} else {
var statearr_60583_60632 = state_60568__$1;
(statearr_60583_60632[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (22))){
var inst_60496 = (state_60568[(8)]);
var inst_60503 = (state_60568[(25)]);
var inst_60513 = (state_60568[(2)]);
var inst_60514 = fluree.db.util.async.throw_err.call(null,inst_60513);
var inst_60515 = cljs.core.conj.call(null,inst_60496,inst_60514);
var inst_60495 = inst_60503;
var inst_60496__$1 = inst_60515;
var state_60568__$1 = (function (){var statearr_60584 = state_60568;
(statearr_60584[(8)] = inst_60496__$1);

(statearr_60584[(11)] = inst_60495);

return statearr_60584;
})();
var statearr_60585_60633 = state_60568__$1;
(statearr_60585_60633[(2)] = null);

(statearr_60585_60633[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (6))){
var inst_60443 = (state_60568[(15)]);
var inst_60451 = (state_60568[(21)]);
var inst_60450 = cljs.core.seq.call(null,inst_60443);
var inst_60451__$1 = cljs.core.first.call(null,inst_60450);
var inst_60452 = cljs.core.next.call(null,inst_60450);
var inst_60453 = cljs.core.not.call(null,inst_60451__$1);
var state_60568__$1 = (function (){var statearr_60586 = state_60568;
(statearr_60586[(21)] = inst_60451__$1);

(statearr_60586[(24)] = inst_60452);

return statearr_60586;
})();
if(inst_60453){
var statearr_60587_60634 = state_60568__$1;
(statearr_60587_60634[(1)] = (8));

} else {
var statearr_60588_60635 = state_60568__$1;
(statearr_60588_60635[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (28))){
var inst_60534 = (state_60568[(26)]);
var inst_60541 = (state_60568[(27)]);
var inst_60551 = (state_60568[(2)]);
var inst_60552 = fluree.db.util.async.throw_err.call(null,inst_60551);
var inst_60553 = cljs.core.conj.call(null,inst_60534,inst_60552);
var inst_60533 = inst_60541;
var inst_60534__$1 = inst_60553;
var state_60568__$1 = (function (){var statearr_60589 = state_60568;
(statearr_60589[(26)] = inst_60534__$1);

(statearr_60589[(28)] = inst_60533);

return statearr_60589;
})();
var statearr_60590_60636 = state_60568__$1;
(statearr_60590_60636[(2)] = null);

(statearr_60590_60636[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (25))){
var inst_60534 = (state_60568[(26)]);
var state_60568__$1 = state_60568;
var statearr_60591_60637 = state_60568__$1;
(statearr_60591_60637[(2)] = inst_60534);

(statearr_60591_60637[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (17))){
var inst_60502 = (state_60568[(12)]);
var inst_60495 = (state_60568[(11)]);
var inst_60501 = cljs.core.seq.call(null,inst_60495);
var inst_60502__$1 = cljs.core.first.call(null,inst_60501);
var inst_60503 = cljs.core.next.call(null,inst_60501);
var inst_60504 = cljs.core.not.call(null,inst_60502__$1);
var state_60568__$1 = (function (){var statearr_60592 = state_60568;
(statearr_60592[(25)] = inst_60503);

(statearr_60592[(12)] = inst_60502__$1);

return statearr_60592;
})();
if(inst_60504){
var statearr_60593_60638 = state_60568__$1;
(statearr_60593_60638[(1)] = (19));

} else {
var statearr_60594_60639 = state_60568__$1;
(statearr_60594_60639[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (3))){
var inst_60566 = (state_60568[(2)]);
var state_60568__$1 = state_60568;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60568__$1,inst_60566);
} else {
if((state_val_60569 === (12))){
var inst_60451 = (state_60568[(21)]);
var inst_60464 = fluree.db.flake.flip_flake.call(null,inst_60451);
var state_60568__$1 = state_60568;
var statearr_60595_60640 = state_60568__$1;
(statearr_60595_60640[(2)] = inst_60464);

(statearr_60595_60640[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (2))){
var inst_60437 = (state_60568[(16)]);
var _ = (function (){var statearr_60596 = state_60568;
(statearr_60596[(4)] = cljs.core.cons.call(null,(5),(state_60568[(4)])));

return statearr_60596;
})();
var inst_60437__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_60438 = cljs.core.seq.call(null,inst_60437__$1);
var inst_60439 = cljs.core.first.call(null,inst_60438);
var inst_60440 = cljs.core.next.call(null,inst_60438);
var inst_60441 = cljs.core.PersistentHashMap.EMPTY;
var inst_60442 = cljs.core.PersistentHashMap.EMPTY;
var inst_60443 = inst_60437__$1;
var inst_60444 = inst_60441;
var inst_60445 = inst_60442;
var state_60568__$1 = (function (){var statearr_60597 = state_60568;
(statearr_60597[(14)] = inst_60445);

(statearr_60597[(15)] = inst_60443);

(statearr_60597[(16)] = inst_60437__$1);

(statearr_60597[(18)] = inst_60444);

(statearr_60597[(22)] = inst_60439);

(statearr_60597[(23)] = inst_60440);

return statearr_60597;
})();
var statearr_60598_60641 = state_60568__$1;
(statearr_60598_60641[(2)] = null);

(statearr_60598_60641[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (23))){
var inst_60540 = (state_60568[(29)]);
var inst_60533 = (state_60568[(28)]);
var inst_60539 = cljs.core.seq.call(null,inst_60533);
var inst_60540__$1 = cljs.core.first.call(null,inst_60539);
var inst_60541 = cljs.core.next.call(null,inst_60539);
var inst_60542 = cljs.core.not.call(null,inst_60540__$1);
var state_60568__$1 = (function (){var statearr_60599 = state_60568;
(statearr_60599[(29)] = inst_60540__$1);

(statearr_60599[(27)] = inst_60541);

return statearr_60599;
})();
if(inst_60542){
var statearr_60600_60642 = state_60568__$1;
(statearr_60600_60642[(1)] = (25));

} else {
var statearr_60601_60643 = state_60568__$1;
(statearr_60601_60643[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (19))){
var inst_60496 = (state_60568[(8)]);
var state_60568__$1 = state_60568;
var statearr_60602_60644 = state_60568__$1;
(statearr_60602_60644[(2)] = inst_60496);

(statearr_60602_60644[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (11))){
var inst_60451 = (state_60568[(21)]);
var state_60568__$1 = state_60568;
var statearr_60604_60645 = state_60568__$1;
(statearr_60604_60645[(2)] = inst_60451);

(statearr_60604_60645[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (9))){
var inst_60461 = (state_60568[(19)]);
var inst_60451 = (state_60568[(21)]);
var inst_60459 = inst_60451.s;
var inst_60460 = inst_60451.op;
var inst_60461__$1 = inst_60460 === true;
var state_60568__$1 = (function (){var statearr_60606 = state_60568;
(statearr_60606[(19)] = inst_60461__$1);

(statearr_60606[(20)] = inst_60459);

return statearr_60606;
})();
if(cljs.core.truth_(inst_60461__$1)){
var statearr_60607_60646 = state_60568__$1;
(statearr_60607_60646[(1)] = (11));

} else {
var statearr_60608_60647 = state_60568__$1;
(statearr_60608_60647[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (5))){
var _ = (function (){var statearr_60609 = state_60568;
(statearr_60609[(4)] = cljs.core.rest.call(null,(state_60568[(4)])));

return statearr_60609;
})();
var state_60568__$1 = state_60568;
var ex60603 = (state_60568__$1[(2)]);
var statearr_60610_60648 = state_60568__$1;
(statearr_60610_60648[(5)] = ex60603);


if((ex60603 instanceof Error)){
var statearr_60611_60649 = state_60568__$1;
(statearr_60611_60649[(1)] = (4));

(statearr_60611_60649[(5)] = null);

} else {
throw ex60603;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (14))){
var inst_60445 = (state_60568[(14)]);
var inst_60443 = (state_60568[(15)]);
var inst_60437 = (state_60568[(16)]);
var inst_60466 = (state_60568[(17)]);
var inst_60444 = (state_60568[(18)]);
var inst_60461 = (state_60568[(19)]);
var inst_60459 = (state_60568[(20)]);
var inst_60451 = (state_60568[(21)]);
var inst_60439 = (state_60568[(22)]);
var inst_60440 = (state_60568[(23)]);
var inst_60452 = (state_60568[(24)]);
var inst_60468 = (function (){var subject = inst_60459;
var flake = inst_60451;
var vec__60447 = inst_60443;
var r = inst_60452;
var asserted_subjects = inst_60444;
var seq__60448 = inst_60452;
var G__60433 = inst_60443;
var first__60436 = inst_60439;
var flake_SINGLEQUOTE_ = inst_60466;
var retracted_subjects = inst_60445;
var first__60449 = inst_60451;
var seq__60435 = inst_60440;
var asserted_QMARK_ = inst_60461;
var vec__60434 = inst_60437;
return (function (p1__60419_SHARP_){
return cljs.core.vec.call(null,cljs.core.conj.call(null,p1__60419_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_60469 = cljs.core.update.call(null,inst_60444,inst_60459,inst_60468);
var tmp60605 = inst_60445;
var inst_60443__$1 = inst_60452;
var inst_60444__$1 = inst_60469;
var inst_60445__$1 = tmp60605;
var state_60568__$1 = (function (){var statearr_60612 = state_60568;
(statearr_60612[(14)] = inst_60445__$1);

(statearr_60612[(15)] = inst_60443__$1);

(statearr_60612[(18)] = inst_60444__$1);

return statearr_60612;
})();
var statearr_60613_60650 = state_60568__$1;
(statearr_60613_60650[(2)] = null);

(statearr_60613_60650[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (26))){
var inst_60540 = (state_60568[(29)]);
var inst_60545 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_60546 = cljs.core.PersistentHashMap.EMPTY;
var inst_60547 = [true,inst_60546];
var inst_60548 = cljs.core.PersistentHashMap.fromArrays(inst_60545,inst_60547);
var inst_60549 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,(1000000),inst_60548,inst_60540);
var state_60568__$1 = state_60568;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60568__$1,(28),inst_60549);
} else {
if((state_val_60569 === (16))){
var inst_60476 = (state_60568[(2)]);
var state_60568__$1 = state_60568;
var statearr_60614_60651 = state_60568__$1;
(statearr_60614_60651[(2)] = inst_60476);

(statearr_60614_60651[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (10))){
var inst_60478 = (state_60568[(2)]);
var state_60568__$1 = state_60568;
var statearr_60615_60652 = state_60568__$1;
(statearr_60615_60652[(2)] = inst_60478);

(statearr_60615_60652[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (18))){
var inst_60481 = (state_60568[(7)]);
var inst_60520 = (state_60568[(2)]);
var inst_60528 = cljs.core.vals.call(null,inst_60481);
var inst_60529 = cljs.core.seq.call(null,inst_60528);
var inst_60530 = cljs.core.first.call(null,inst_60529);
var inst_60531 = cljs.core.next.call(null,inst_60529);
var inst_60532 = cljs.core.PersistentVector.EMPTY;
var inst_60533 = inst_60528;
var inst_60534 = inst_60532;
var state_60568__$1 = (function (){var statearr_60616 = state_60568;
(statearr_60616[(26)] = inst_60534);

(statearr_60616[(13)] = inst_60520);

(statearr_60616[(30)] = inst_60530);

(statearr_60616[(28)] = inst_60533);

(statearr_60616[(31)] = inst_60531);

return statearr_60616;
})();
var statearr_60617_60653 = state_60568__$1;
(statearr_60617_60653[(2)] = null);

(statearr_60617_60653[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60569 === (8))){
var inst_60445 = (state_60568[(14)]);
var inst_60444 = (state_60568[(18)]);
var inst_60455 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60456 = [inst_60444,inst_60445];
var inst_60457 = (new cljs.core.PersistentVector(null,2,(5),inst_60455,inst_60456,null));
var state_60568__$1 = state_60568;
var statearr_60618_60654 = state_60568__$1;
(statearr_60618_60654[(2)] = inst_60457);

(statearr_60618_60654[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2726__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2726__auto____0 = (function (){
var statearr_60619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60619[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2726__auto__);

(statearr_60619[(1)] = (1));

return statearr_60619;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2726__auto____1 = (function (state_60568){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_60568);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e60620){var ex__2729__auto__ = e60620;
var statearr_60621_60655 = state_60568;
(statearr_60621_60655[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_60568[(4)]))){
var statearr_60622_60656 = state_60568;
(statearr_60622_60656[(1)] = cljs.core.first.call(null,(state_60568[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60657 = state_60568;
state_60568 = G__60657;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2726__auto__ = function(state_60568){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2726__auto____1.call(this,state_60568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2726__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2726__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_60623 = f__2749__auto__.call(null);
(statearr_60623[(6)] = c__2748__auto__);

return statearr_60623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_60689){
var state_val_60690 = (state_60689[(1)]);
if((state_val_60690 === (1))){
var inst_60658 = cljs.core.volatile_BANG_.call(null,(0));
var inst_60659 = cljs.core.PersistentHashMap.EMPTY;
var inst_60660 = cljs.core.volatile_BANG_.call(null,inst_60659);
var inst_60661 = cljs.core.first.call(null,resp);
var inst_60662 = cljs.core.rest.call(null,resp);
var inst_60663 = cljs.core.PersistentVector.EMPTY;
var inst_60664 = inst_60658;
var inst_60665 = inst_60660;
var inst_60666 = inst_60661;
var inst_60667 = inst_60662;
var inst_60668 = inst_60663;
var state_60689__$1 = (function (){var statearr_60691 = state_60689;
(statearr_60691[(7)] = inst_60667);

(statearr_60691[(8)] = inst_60665);

(statearr_60691[(9)] = inst_60664);

(statearr_60691[(10)] = inst_60668);

(statearr_60691[(11)] = inst_60666);

return statearr_60691;
})();
var statearr_60692_60707 = state_60689__$1;
(statearr_60692_60707[(2)] = null);

(statearr_60692_60707[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60690 === (2))){
var inst_60665 = (state_60689[(8)]);
var inst_60664 = (state_60689[(9)]);
var inst_60666 = (state_60689[(11)]);
var inst_60670 = fluree.db.api.query.format_block_resp_pretty.call(null,db,inst_60666,inst_60665,inst_60664);
var state_60689__$1 = state_60689;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60689__$1,(4),inst_60670);
} else {
if((state_val_60690 === (3))){
var inst_60687 = (state_60689[(2)]);
var state_60689__$1 = state_60689;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60689__$1,inst_60687);
} else {
if((state_val_60690 === (4))){
var inst_60667 = (state_60689[(7)]);
var inst_60668 = (state_60689[(10)]);
var inst_60672 = (state_60689[(2)]);
var inst_60673 = fluree.db.util.async.throw_err.call(null,inst_60672);
var inst_60674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60675 = [inst_60673];
var inst_60676 = (new cljs.core.PersistentVector(null,1,(5),inst_60674,inst_60675,null));
var inst_60677 = cljs.core.concat.call(null,inst_60668,inst_60676);
var inst_60678 = cljs.core.first.call(null,inst_60667);
var state_60689__$1 = (function (){var statearr_60695 = state_60689;
(statearr_60695[(12)] = inst_60677);

return statearr_60695;
})();
if(cljs.core.truth_(inst_60678)){
var statearr_60696_60708 = state_60689__$1;
(statearr_60696_60708[(1)] = (5));

} else {
var statearr_60697_60709 = state_60689__$1;
(statearr_60697_60709[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60690 === (5))){
var inst_60667 = (state_60689[(7)]);
var inst_60665 = (state_60689[(8)]);
var inst_60664 = (state_60689[(9)]);
var inst_60677 = (state_60689[(12)]);
var inst_60680 = cljs.core.first.call(null,inst_60667);
var inst_60681 = cljs.core.rest.call(null,inst_60667);
var tmp60693 = inst_60665;
var tmp60694 = inst_60664;
var inst_60664__$1 = tmp60694;
var inst_60665__$1 = tmp60693;
var inst_60666 = inst_60680;
var inst_60667__$1 = inst_60681;
var inst_60668 = inst_60677;
var state_60689__$1 = (function (){var statearr_60698 = state_60689;
(statearr_60698[(7)] = inst_60667__$1);

(statearr_60698[(8)] = inst_60665__$1);

(statearr_60698[(9)] = inst_60664__$1);

(statearr_60698[(10)] = inst_60668);

(statearr_60698[(11)] = inst_60666);

return statearr_60698;
})();
var statearr_60699_60710 = state_60689__$1;
(statearr_60699_60710[(2)] = null);

(statearr_60699_60710[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60690 === (6))){
var inst_60677 = (state_60689[(12)]);
var state_60689__$1 = state_60689;
var statearr_60700_60711 = state_60689__$1;
(statearr_60700_60711[(2)] = inst_60677);

(statearr_60700_60711[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60690 === (7))){
var inst_60685 = (state_60689[(2)]);
var state_60689__$1 = state_60689;
var statearr_60701_60712 = state_60689__$1;
(statearr_60701_60712[(2)] = inst_60685);

(statearr_60701_60712[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2726__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2726__auto____0 = (function (){
var statearr_60702 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60702[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2726__auto__);

(statearr_60702[(1)] = (1));

return statearr_60702;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2726__auto____1 = (function (state_60689){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_60689);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e60703){var ex__2729__auto__ = e60703;
var statearr_60704_60713 = state_60689;
(statearr_60704_60713[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_60689[(4)]))){
var statearr_60705_60714 = state_60689;
(statearr_60705_60714[(1)] = cljs.core.first.call(null,(state_60689[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60715 = state_60689;
state_60689 = G__60715;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2726__auto__ = function(state_60689){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2726__auto____1.call(this,state_60689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2726__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2726__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_60706 = f__2749__auto__.call(null);
(statearr_60706[(6)] = c__2748__auto__);

return statearr_60706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.api.query.response_time_formatted = (function fluree$db$api$query$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis.call(null) - start_time)),"ms"].join('');
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__60718 = arguments.length;
switch (G__60718) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.call(null,db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.call(null,db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range.call(null,db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__60720){
var map__60721 = p__60720;
var map__60721__$1 = cljs.core.__destructure_map.call(null,map__60721);
var query = map__60721__$1;
var opts = cljs.core.get.call(null,map__60721__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_60806){
var state_val_60807 = (state_60806[(1)]);
if((state_val_60807 === (7))){
var inst_60732 = (state_60806[(7)]);
var inst_60736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60737 = ["_auth/id",inst_60732];
var inst_60738 = (new cljs.core.PersistentVector(null,2,(5),inst_60736,inst_60737,null));
var state_60806__$1 = state_60806;
var statearr_60808_60852 = state_60806__$1;
(statearr_60808_60852[(2)] = inst_60738);

(statearr_60808_60852[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (20))){
var inst_60786 = (state_60806[(2)]);
var inst_60787 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_60806__$1 = (function (){var statearr_60809 = state_60806;
(statearr_60809[(8)] = inst_60786);

return statearr_60809;
})();
if(cljs.core.truth_(inst_60787)){
var statearr_60810_60853 = state_60806__$1;
(statearr_60810_60853[(1)] = (22));

} else {
var statearr_60811_60854 = state_60806__$1;
(statearr_60811_60854[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (27))){
var inst_60789 = (state_60806[(9)]);
var inst_60733 = (state_60806[(10)]);
var inst_60795 = (state_60806[(2)]);
var inst_60796 = fluree.db.api.query.response_time_formatted.call(null,inst_60733);
var inst_60797 = [(200),inst_60795,(100),inst_60796];
var inst_60798 = cljs.core.PersistentHashMap.fromArrays(inst_60789,inst_60797);
var state_60806__$1 = state_60806;
var statearr_60812_60855 = state_60806__$1;
(statearr_60812_60855[(2)] = inst_60798);

(statearr_60812_60855[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (1))){
var state_60806__$1 = state_60806;
var statearr_60813_60856 = state_60806__$1;
(statearr_60813_60856[(2)] = null);

(statearr_60813_60856[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (24))){
var inst_60801 = (state_60806[(2)]);
var _ = (function (){var statearr_60814 = state_60806;
(statearr_60814[(4)] = cljs.core.rest.call(null,(state_60806[(4)])));

return statearr_60814;
})();
var state_60806__$1 = state_60806;
var statearr_60815_60857 = state_60806__$1;
(statearr_60815_60857[(2)] = inst_60801);

(statearr_60815_60857[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (4))){
var inst_60722 = (state_60806[(2)]);
var state_60806__$1 = state_60806;
var statearr_60816_60858 = state_60806__$1;
(statearr_60816_60858[(2)] = inst_60722);

(statearr_60816_60858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (15))){
var inst_60773 = (state_60806[(11)]);
var state_60806__$1 = state_60806;
var statearr_60817_60859 = state_60806__$1;
(statearr_60817_60859[(2)] = inst_60773);

(statearr_60817_60859[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (21))){
var inst_60782 = (state_60806[(2)]);
var inst_60783 = fluree.db.util.async.throw_err.call(null,inst_60782);
var state_60806__$1 = state_60806;
var statearr_60818_60860 = state_60806__$1;
(statearr_60818_60860[(2)] = inst_60783);

(statearr_60818_60860[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (13))){
var inst_60731 = (state_60806[(12)]);
var inst_60773 = (state_60806[(11)]);
var inst_60772 = (state_60806[(2)]);
var inst_60773__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_60731);
var state_60806__$1 = (function (){var statearr_60819 = state_60806;
(statearr_60819[(11)] = inst_60773__$1);

(statearr_60819[(13)] = inst_60772);

return statearr_60819;
})();
if(cljs.core.truth_(inst_60773__$1)){
var statearr_60820_60861 = state_60806__$1;
(statearr_60820_60861[(1)] = (15));

} else {
var statearr_60821_60862 = state_60806__$1;
(statearr_60821_60862[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (22))){
var inst_60786 = (state_60806[(8)]);
var inst_60789 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_60790 = cljs.core.sequential_QMARK_.call(null,inst_60786);
var state_60806__$1 = (function (){var statearr_60822 = state_60806;
(statearr_60822[(9)] = inst_60789);

return statearr_60822;
})();
if(inst_60790){
var statearr_60823_60863 = state_60806__$1;
(statearr_60823_60863[(1)] = (25));

} else {
var statearr_60824_60864 = state_60806__$1;
(statearr_60824_60864[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (6))){
var inst_60731 = (state_60806[(12)]);
var inst_60747 = (state_60806[(14)]);
var inst_60746 = (state_60806[(2)]);
var inst_60747__$1 = fluree.db.util.async.throw_err.call(null,inst_60746);
var inst_60748 = fluree.db.api.query.resolve_block_range.call(null,inst_60747__$1,inst_60731);
var state_60806__$1 = (function (){var statearr_60825 = state_60806;
(statearr_60825[(14)] = inst_60747__$1);

return statearr_60825;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60806__$1,(10),inst_60748);
} else {
if((state_val_60807 === (25))){
var inst_60786 = (state_60806[(8)]);
var inst_60792 = cljs.core.doall.call(null,inst_60786);
var state_60806__$1 = state_60806;
var statearr_60826_60865 = state_60806__$1;
(statearr_60826_60865[(2)] = inst_60792);

(statearr_60826_60865[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (17))){
var inst_60778 = (state_60806[(2)]);
var state_60806__$1 = state_60806;
if(cljs.core.truth_(inst_60778)){
var statearr_60827_60866 = state_60806__$1;
(statearr_60827_60866[(1)] = (18));

} else {
var statearr_60828_60867 = state_60806__$1;
(statearr_60828_60867[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (3))){
var inst_60804 = (state_60806[(2)]);
var state_60806__$1 = state_60806;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60806__$1,inst_60804);
} else {
if((state_val_60807 === (12))){
var inst_60731 = (state_60806[(12)]);
var inst_60764 = cljs.core.pr_str.call(null,inst_60731);
var inst_60765 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_60764].join('');
var inst_60766 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60767 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60768 = cljs.core.PersistentHashMap.fromArrays(inst_60766,inst_60767);
var inst_60769 = cljs.core.ex_info.call(null,inst_60765,inst_60768);
var inst_60770 = (function(){throw inst_60769})();
var state_60806__$1 = state_60806;
var statearr_60829_60868 = state_60806__$1;
(statearr_60829_60868[(2)] = inst_60770);

(statearr_60829_60868[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (2))){
var inst_60732 = (state_60806[(7)]);
var _ = (function (){var statearr_60830 = state_60806;
(statearr_60830[(4)] = cljs.core.cons.call(null,(5),(state_60806[(4)])));

return statearr_60830;
})();
var inst_60731 = cljs.core.dissoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_60732__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60733 = fluree.db.util.core.current_time_millis.call(null);
var inst_60734 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_60806__$1 = (function (){var statearr_60831 = state_60806;
(statearr_60831[(12)] = inst_60731);

(statearr_60831[(7)] = inst_60732__$1);

(statearr_60831[(15)] = inst_60734);

(statearr_60831[(10)] = inst_60733);

return statearr_60831;
})();
if(cljs.core.truth_(inst_60732__$1)){
var statearr_60832_60869 = state_60806__$1;
(statearr_60832_60869[(1)] = (7));

} else {
var statearr_60833_60870 = state_60806__$1;
(statearr_60833_60870[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (23))){
var inst_60786 = (state_60806[(8)]);
var state_60806__$1 = state_60806;
var statearr_60834_60871 = state_60806__$1;
(statearr_60834_60871[(2)] = inst_60786);

(statearr_60834_60871[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (19))){
var inst_60772 = (state_60806[(13)]);
var state_60806__$1 = state_60806;
var statearr_60835_60872 = state_60806__$1;
(statearr_60835_60872[(2)] = inst_60772);

(statearr_60835_60872[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (11))){
var inst_60753 = (state_60806[(16)]);
var inst_60752 = (state_60806[(17)]);
var inst_60747 = (state_60806[(14)]);
var inst_60759 = fluree.db.api.query.block_range.call(null,inst_60747,inst_60752,inst_60753,opts);
var state_60806__$1 = state_60806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60806__$1,(14),inst_60759);
} else {
if((state_val_60807 === (9))){
var inst_60734 = (state_60806[(15)]);
var inst_60741 = (state_60806[(2)]);
var inst_60742 = [inst_60741];
var inst_60743 = cljs.core.PersistentHashMap.fromArrays(inst_60734,inst_60742);
var inst_60744 = fluree.db.api.query.db.call(null,conn,ledger,inst_60743);
var state_60806__$1 = state_60806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60806__$1,(6),inst_60744);
} else {
if((state_val_60807 === (5))){
var _ = (function (){var statearr_60837 = state_60806;
(statearr_60837[(4)] = cljs.core.rest.call(null,(state_60806[(4)])));

return statearr_60837;
})();
var state_60806__$1 = state_60806;
var ex60836 = (state_60806__$1[(2)]);
var statearr_60838_60873 = state_60806__$1;
(statearr_60838_60873[(5)] = ex60836);


if((ex60836 instanceof Error)){
var statearr_60839_60874 = state_60806__$1;
(statearr_60839_60874[(1)] = (4));

(statearr_60839_60874[(5)] = null);

} else {
throw ex60836;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (14))){
var inst_60761 = (state_60806[(2)]);
var inst_60762 = fluree.db.util.async.throw_err.call(null,inst_60761);
var state_60806__$1 = state_60806;
var statearr_60840_60875 = state_60806__$1;
(statearr_60840_60875[(2)] = inst_60762);

(statearr_60840_60875[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (26))){
var inst_60786 = (state_60806[(8)]);
var state_60806__$1 = state_60806;
var statearr_60841_60876 = state_60806__$1;
(statearr_60841_60876[(2)] = inst_60786);

(statearr_60841_60876[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (16))){
var inst_60731 = (state_60806[(12)]);
var inst_60776 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_60731);
var state_60806__$1 = state_60806;
var statearr_60842_60877 = state_60806__$1;
(statearr_60842_60877[(2)] = inst_60776);

(statearr_60842_60877[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (10))){
var inst_60731 = (state_60806[(12)]);
var inst_60750 = (state_60806[(2)]);
var inst_60751 = fluree.db.util.async.throw_err.call(null,inst_60750);
var inst_60752 = cljs.core.nth.call(null,inst_60751,(0),null);
var inst_60753 = cljs.core.nth.call(null,inst_60751,(1),null);
var inst_60754 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_60755 = cljs.core.dissoc.call(null,inst_60731,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_60756 = cljs.core.keys.call(null,inst_60755);
var inst_60757 = cljs.core._EQ_.call(null,inst_60754,inst_60756);
var state_60806__$1 = (function (){var statearr_60843 = state_60806;
(statearr_60843[(16)] = inst_60753);

(statearr_60843[(17)] = inst_60752);

return statearr_60843;
})();
if(inst_60757){
var statearr_60844_60878 = state_60806__$1;
(statearr_60844_60878[(1)] = (11));

} else {
var statearr_60845_60879 = state_60806__$1;
(statearr_60845_60879[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60807 === (18))){
var inst_60747 = (state_60806[(14)]);
var inst_60772 = (state_60806[(13)]);
var inst_60780 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_60747,inst_60772);
var state_60806__$1 = state_60806;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60806__$1,(21),inst_60780);
} else {
if((state_val_60807 === (8))){
var state_60806__$1 = state_60806;
var statearr_60846_60880 = state_60806__$1;
(statearr_60846_60880[(2)] = null);

(statearr_60846_60880[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2726__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2726__auto____0 = (function (){
var statearr_60847 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60847[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2726__auto__);

(statearr_60847[(1)] = (1));

return statearr_60847;
});
var fluree$db$api$query$block_query_async_$_state_machine__2726__auto____1 = (function (state_60806){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_60806);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e60848){var ex__2729__auto__ = e60848;
var statearr_60849_60881 = state_60806;
(statearr_60849_60881[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_60806[(4)]))){
var statearr_60850_60882 = state_60806;
(statearr_60850_60882[(1)] = cljs.core.first.call(null,(state_60806[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60883 = state_60806;
state_60806 = G__60883;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2726__auto__ = function(state_60806){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2726__auto____1.call(this,state_60806);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2726__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2726__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_60851 = f__2749__auto__.call(null);
(statearr_60851[(6)] = c__2748__auto__);

return statearr_60851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_.call(null,history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_.call(null,history))?((cljs.core.empty_QMARK_.call(null,history))?(function(){throw cljs.core.ex_info.call(null,["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__60884 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.call(null,subject,(0)),cljs.core.get.call(null,subject,(1)),cljs.core.get.call(null,subject,(2)),cljs.core.get.call(null,subject,(3))], null);
var s = cljs.core.nth.call(null,vec__60884,(0),null);
var p = cljs.core.nth.call(null,vec__60884,(1),null);
var o = cljs.core.nth.call(null,vec__60884,(2),null);
var t = cljs.core.nth.call(null,vec__60884,(3),null);
var vec__60887 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((((!((p == null)))) && ((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((((!((p == null)))) && ((!((o == null))))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.call(null,["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.call(null,vec__60887,(0),null);
var idx = cljs.core.nth.call(null,vec__60887,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__60890 = cljs.core.get_in.call(null,t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.call(null,vec__60890,(0),null);
var id = cljs.core.nth.call(null,vec__60890,(1),null);
var or__4223__auto__ = auth_set.call(null,auth);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return auth_set.call(null,id);
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4835__auto__ = [];
var len__4829__auto___60894 = arguments.length;
var i__4830__auto___60895 = (0);
while(true){
if((i__4830__auto___60895 < len__4829__auto___60894)){
args__4835__auto__.push((arguments[i__4830__auto___60895]));

var G__60896 = (i__4830__auto___60895 + (1));
i__4830__auto___60895 = G__60896;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.call(null,cljs.core.min,cljs.core.remove.call(null,cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq60893){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq60893));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_61092){
var state_val_61093 = (state_61092[(1)]);
if((state_val_61093 === (7))){
var inst_61019 = (state_61092[(7)]);
var inst_61012 = (state_61092[(8)]);
var inst_61018 = cljs.core.seq.call(null,inst_61012);
var inst_61019__$1 = cljs.core.first.call(null,inst_61018);
var inst_61020 = cljs.core.next.call(null,inst_61018);
var state_61092__$1 = (function (){var statearr_61094 = state_61092;
(statearr_61094[(7)] = inst_61019__$1);

(statearr_61094[(9)] = inst_61020);

return statearr_61094;
})();
if(cljs.core.truth_(inst_61019__$1)){
var statearr_61095_61195 = state_61092__$1;
(statearr_61095_61195[(1)] = (9));

} else {
var statearr_61096_61196 = state_61092__$1;
(statearr_61096_61196[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (20))){
var inst_61082 = (state_61092[(2)]);
var state_61092__$1 = state_61092;
var statearr_61097_61197 = state_61092__$1;
(statearr_61097_61197[(2)] = inst_61082);

(statearr_61097_61197[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (27))){
var inst_61040 = (state_61092[(10)]);
var inst_61037 = (state_61092[(11)]);
var inst_61058 = (state_61092[(12)]);
var inst_61060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61061 = [inst_61040,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_61062 = (new cljs.core.PersistentVector(null,2,(5),inst_61060,inst_61061,null));
var inst_61063 = cljs.core.update_in.call(null,inst_61058,inst_61062,fluree.db.api.query.min_safe,inst_61037);
var state_61092__$1 = state_61092;
var statearr_61098_61198 = state_61092__$1;
(statearr_61098_61198[(2)] = inst_61063);

(statearr_61098_61198[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (1))){
var state_61092__$1 = state_61092;
var statearr_61099_61199 = state_61092__$1;
(statearr_61099_61199[(2)] = null);

(statearr_61099_61199[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (24))){
var inst_61040 = (state_61092[(10)]);
var inst_61019 = (state_61092[(7)]);
var inst_61050 = (state_61092[(13)]);
var inst_61052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61053 = [inst_61040,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_61054 = (new cljs.core.PersistentVector(null,2,(5),inst_61052,inst_61053,null));
var inst_61055 = cljs.core.update_in.call(null,inst_61050,inst_61054,cljs.core.conj,inst_61019);
var state_61092__$1 = state_61092;
var statearr_61101_61200 = state_61092__$1;
(statearr_61101_61200[(2)] = inst_61055);

(statearr_61101_61200[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (4))){
var inst_60898 = (state_61092[(2)]);
var state_61092__$1 = state_61092;
var statearr_61102_61201 = state_61092__$1;
(statearr_61102_61201[(2)] = inst_60898);

(statearr_61102_61201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (15))){
var inst_61013 = (state_61092[(14)]);
var inst_61020 = (state_61092[(9)]);
var tmp61100 = inst_61013;
var inst_61012 = inst_61020;
var inst_61013__$1 = tmp61100;
var state_61092__$1 = (function (){var statearr_61103 = state_61092;
(statearr_61103[(14)] = inst_61013__$1);

(statearr_61103[(8)] = inst_61012);

return statearr_61103;
})();
var statearr_61104_61202 = state_61092__$1;
(statearr_61104_61202[(2)] = null);

(statearr_61104_61202[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (21))){
var inst_61013 = (state_61092[(14)]);
var inst_61040 = (state_61092[(10)]);
var inst_61044 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61045 = [inst_61040,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61046 = (new cljs.core.PersistentVector(null,2,(5),inst_61044,inst_61045,null));
var inst_61047 = cljs.core.assoc_in.call(null,inst_61013,inst_61046,inst_61040);
var state_61092__$1 = state_61092;
var statearr_61105_61203 = state_61092__$1;
(statearr_61105_61203[(2)] = inst_61047);

(statearr_61105_61203[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (31))){
var inst_61066 = (state_61092[(15)]);
var state_61092__$1 = state_61092;
var statearr_61106_61204 = state_61092__$1;
(statearr_61106_61204[(2)] = inst_61066);

(statearr_61106_61204[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (32))){
var inst_61020 = (state_61092[(9)]);
var inst_61074 = (state_61092[(2)]);
var inst_61012 = inst_61020;
var inst_61013 = inst_61074;
var state_61092__$1 = (function (){var statearr_61107 = state_61092;
(statearr_61107[(14)] = inst_61013);

(statearr_61107[(8)] = inst_61012);

return statearr_61107;
})();
var statearr_61108_61205 = state_61092__$1;
(statearr_61108_61205[(2)] = null);

(statearr_61108_61205[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (33))){
var inst_61013 = (state_61092[(14)]);
var state_61092__$1 = state_61092;
var statearr_61109_61206 = state_61092__$1;
(statearr_61109_61206[(2)] = inst_61013);

(statearr_61109_61206[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (13))){
var inst_61022 = (state_61092[(16)]);
var state_61092__$1 = state_61092;
var statearr_61110_61207 = state_61092__$1;
(statearr_61110_61207[(2)] = inst_61022);

(statearr_61110_61207[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (22))){
var inst_61013 = (state_61092[(14)]);
var state_61092__$1 = state_61092;
var statearr_61111_61208 = state_61092__$1;
(statearr_61111_61208[(2)] = inst_61013);

(statearr_61111_61208[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (29))){
var inst_61066 = (state_61092[(2)]);
var state_61092__$1 = (function (){var statearr_61112 = state_61092;
(statearr_61112[(15)] = inst_61066);

return statearr_61112;
})();
if(cljs.core.truth_(show_auth)){
var statearr_61113_61209 = state_61092__$1;
(statearr_61113_61209[(1)] = (30));

} else {
var statearr_61114_61210 = state_61092__$1;
(statearr_61114_61210[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (6))){
var inst_60998 = (state_61092[(2)]);
var inst_60999 = fluree.db.util.async.throw_err.call(null,inst_60998);
var inst_61007 = resp;
var inst_61008 = cljs.core.seq.call(null,inst_61007);
var inst_61009 = cljs.core.first.call(null,inst_61008);
var inst_61010 = cljs.core.next.call(null,inst_61008);
var inst_61011 = cljs.core.PersistentHashMap.EMPTY;
var inst_61012 = inst_61007;
var inst_61013 = inst_61011;
var state_61092__$1 = (function (){var statearr_61115 = state_61092;
(statearr_61115[(14)] = inst_61013);

(statearr_61115[(17)] = inst_61010);

(statearr_61115[(8)] = inst_61012);

(statearr_61115[(18)] = inst_60999);

(statearr_61115[(19)] = inst_61009);

return statearr_61115;
})();
var statearr_61116_61211 = state_61092__$1;
(statearr_61116_61211[(2)] = null);

(statearr_61116_61211[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (28))){
var inst_61058 = (state_61092[(12)]);
var state_61092__$1 = state_61092;
var statearr_61117_61212 = state_61092__$1;
(statearr_61117_61212[(2)] = inst_61058);

(statearr_61117_61212[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (25))){
var inst_61050 = (state_61092[(13)]);
var state_61092__$1 = state_61092;
var statearr_61118_61213 = state_61092__$1;
(statearr_61118_61213[(2)] = inst_61050);

(statearr_61118_61213[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (34))){
var state_61092__$1 = state_61092;
var statearr_61119_61214 = state_61092__$1;
(statearr_61119_61214[(2)] = null);

(statearr_61119_61214[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (17))){
var inst_61084 = (state_61092[(2)]);
var state_61092__$1 = state_61092;
var statearr_61120_61215 = state_61092__$1;
(statearr_61120_61215[(2)] = inst_61084);

(statearr_61120_61215[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (3))){
var inst_61090 = (state_61092[(2)]);
var state_61092__$1 = state_61092;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61092__$1,inst_61090);
} else {
if((state_val_61093 === (12))){
var inst_61019 = (state_61092[(7)]);
var inst_60999 = (state_61092[(18)]);
var inst_61024 = fluree.db.api.query.auth_match.call(null,auth,inst_60999,inst_61019);
var inst_61025 = cljs.core.not.call(null,inst_61024);
var state_61092__$1 = state_61092;
var statearr_61121_61216 = state_61092__$1;
(statearr_61121_61216[(2)] = inst_61025);

(statearr_61121_61216[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (2))){
var _ = (function (){var statearr_61122 = state_61092;
(statearr_61122[(4)] = cljs.core.cons.call(null,(5),(state_61092[(4)])));

return statearr_61122;
})();
var inst_60904 = (function (){return (function (p1__60897_SHARP_){
return p1__60897_SHARP_.t;
});
})();
var inst_60905 = cljs.core.map.call(null,inst_60904,resp);
var inst_60906 = cljs.core.set.call(null,inst_60905);
var inst_60994 = cljs.core.async.chan.call(null,(1));
var inst_60995 = (function (){var ts = inst_60906;
var c__2748__auto____$1 = inst_60994;
return (function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_60992){
var state_val_60993 = (state_60992[(1)]);
if((state_val_60993 === (7))){
var inst_60938 = (state_60992[(7)]);
var inst_60926 = (state_60992[(8)]);
var inst_60932 = (state_60992[(9)]);
var inst_60920 = (state_60992[(10)]);
var inst_60931 = (state_60992[(2)]);
var inst_60932__$1 = fluree.db.util.async.throw_err.call(null,inst_60931);
var inst_60934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60935 = [inst_60926,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_60936 = (new cljs.core.PersistentVector(null,2,(5),inst_60934,inst_60935,null));
var inst_60937 = cljs.core.assoc_in.call(null,inst_60920,inst_60936,inst_60932__$1);
var inst_60938__$1 = auth;
var state_60992__$1 = (function (){var statearr_61123 = state_60992;
(statearr_61123[(7)] = inst_60938__$1);

(statearr_61123[(11)] = inst_60937);

(statearr_61123[(9)] = inst_60932__$1);

return statearr_61123;
})();
if(cljs.core.truth_(inst_60938__$1)){
var statearr_61124_61217 = state_60992__$1;
(statearr_61124_61217[(1)] = (8));

} else {
var statearr_61125_61218 = state_60992__$1;
(statearr_61125_61218[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60993 === (1))){
var inst_60914 = (state_60992[(12)]);
var inst_60914__$1 = ts;
var inst_60915 = cljs.core.seq.call(null,inst_60914__$1);
var inst_60916 = cljs.core.first.call(null,inst_60915);
var inst_60917 = cljs.core.next.call(null,inst_60915);
var inst_60918 = cljs.core.PersistentHashMap.EMPTY;
var inst_60919 = inst_60914__$1;
var inst_60920 = inst_60918;
var state_60992__$1 = (function (){var statearr_61126 = state_60992;
(statearr_61126[(12)] = inst_60914__$1);

(statearr_61126[(13)] = inst_60916);

(statearr_61126[(14)] = inst_60919);

(statearr_61126[(15)] = inst_60917);

(statearr_61126[(10)] = inst_60920);

return statearr_61126;
})();
var statearr_61127_61219 = state_60992__$1;
(statearr_61127_61219[(2)] = null);

(statearr_61127_61219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60993 === (4))){
var inst_60926 = (state_60992[(8)]);
var inst_60929 = fluree.db.time_travel.non_border_t_to_block.call(null,db,inst_60926);
var state_60992__$1 = state_60992;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60992__$1,(7),inst_60929);
} else {
if((state_val_60993 === (13))){
var inst_60927 = (state_60992[(16)]);
var inst_60984 = (state_60992[(2)]);
var inst_60919 = inst_60927;
var inst_60920 = inst_60984;
var state_60992__$1 = (function (){var statearr_61128 = state_60992;
(statearr_61128[(14)] = inst_60919);

(statearr_61128[(10)] = inst_60920);

return statearr_61128;
})();
var statearr_61129_61220 = state_60992__$1;
(statearr_61129_61220[(2)] = null);

(statearr_61129_61220[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60993 === (6))){
var inst_60988 = (state_60992[(2)]);
var state_60992__$1 = state_60992;
var statearr_61130_61221 = state_60992__$1;
(statearr_61130_61221[(2)] = inst_60988);

(statearr_61130_61221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60993 === (3))){
var inst_60990 = (state_60992[(2)]);
var state_60992__$1 = state_60992;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60992__$1,inst_60990);
} else {
if((state_val_60993 === (12))){
var inst_60937 = (state_60992[(11)]);
var state_60992__$1 = state_60992;
var statearr_61131_61222 = state_60992__$1;
(statearr_61131_61222[(2)] = inst_60937);

(statearr_61131_61222[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60993 === (2))){
var inst_60926 = (state_60992[(8)]);
var inst_60919 = (state_60992[(14)]);
var inst_60925 = cljs.core.seq.call(null,inst_60919);
var inst_60926__$1 = cljs.core.first.call(null,inst_60925);
var inst_60927 = cljs.core.next.call(null,inst_60925);
var state_60992__$1 = (function (){var statearr_61132 = state_60992;
(statearr_61132[(8)] = inst_60926__$1);

(statearr_61132[(16)] = inst_60927);

return statearr_61132;
})();
if(cljs.core.truth_(inst_60926__$1)){
var statearr_61133_61223 = state_60992__$1;
(statearr_61133_61223[(1)] = (4));

} else {
var statearr_61134_61224 = state_60992__$1;
(statearr_61134_61224[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60993 === (11))){
var inst_60926 = (state_60992[(8)]);
var inst_60914 = (state_60992[(12)]);
var inst_60916 = (state_60992[(13)]);
var inst_60919 = (state_60992[(14)]);
var inst_60937 = (state_60992[(11)]);
var inst_60927 = (state_60992[(16)]);
var inst_60917 = (state_60992[(15)]);
var inst_60932 = (state_60992[(9)]);
var inst_60920 = (state_60992[(10)]);
var inst_60944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60945 = [inst_60926,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_60946 = (new cljs.core.PersistentVector(null,2,(5),inst_60944,inst_60945,null));
var inst_60959 = cljs.core.async.chan.call(null,(1));
var inst_60960 = (function (){var c__2748__auto____$2 = inst_60959;
var t = inst_60926;
var vec__60911 = inst_60914;
var vec__60922 = inst_60919;
var first__60924 = inst_60926;
var seq__60912 = inst_60917;
var block = inst_60932;
var r = inst_60927;
var G__60933 = inst_60937;
var first__60913 = inst_60916;
var seq__60923 = inst_60927;
var acc = inst_60920;
var G__60910 = inst_60919;
return (function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_60957){
var state_val_60958 = (state_60957[(1)]);
if((state_val_60958 === (1))){
var state_60957__$1 = state_60957;
var statearr_61135_61225 = state_60957__$1;
(statearr_61135_61225[(2)] = null);

(statearr_61135_61225[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60958 === (2))){
var ___$1 = (function (){var statearr_61136 = state_60957;
(statearr_61136[(4)] = cljs.core.cons.call(null,(5),(state_60957[(4)])));

return statearr_61136;
})();
var ___$2 = (function (){var statearr_61137 = state_60957;
(statearr_61137[(4)] = cljs.core.rest.call(null,(state_60957[(4)])));

return statearr_61137;
})();
var state_60957__$1 = state_60957;
var statearr_61138_61226 = state_60957__$1;
(statearr_61138_61226[(2)] = db);

(statearr_61138_61226[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60958 === (3))){
var inst_60955 = (state_60957[(2)]);
var state_60957__$1 = state_60957;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_60957__$1,inst_60955);
} else {
if((state_val_60958 === (4))){
var inst_60947 = (state_60957[(2)]);
var state_60957__$1 = state_60957;
var statearr_61140_61227 = state_60957__$1;
(statearr_61140_61227[(2)] = inst_60947);

(statearr_61140_61227[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60958 === (5))){
var ___$1 = (function (){var statearr_61141 = state_60957;
(statearr_61141[(4)] = cljs.core.rest.call(null,(state_60957[(4)])));

return statearr_61141;
})();
var state_60957__$1 = state_60957;
var ex61139 = (state_60957__$1[(2)]);
var statearr_61142_61228 = state_60957__$1;
(statearr_61142_61228[(5)] = ex61139);


if((ex61139 instanceof Error)){
var statearr_61143_61229 = state_60957__$1;
(statearr_61143_61229[(1)] = (4));

(statearr_61143_61229[(5)] = null);

} else {
throw ex61139;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____0 = (function (){
var statearr_61144 = [null,null,null,null,null,null,null];
(statearr_61144[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__);

(statearr_61144[(1)] = (1));

return statearr_61144;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____1 = (function (state_60957){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_60957);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e61145){var ex__2729__auto__ = e61145;
var statearr_61146_61230 = state_60957;
(statearr_61146_61230[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_60957[(4)]))){
var statearr_61147_61231 = state_60957;
(statearr_61147_61231[(1)] = cljs.core.first.call(null,(state_60957[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61232 = state_60957;
state_60957 = G__61232;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__ = function(state_60957){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____1.call(this,state_60957);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_61148 = f__2749__auto__.call(null);
(statearr_61148[(6)] = c__2748__auto____$2);

return statearr_61148;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
});
})();
var inst_60961 = cljs.core.async.impl.dispatch.run.call(null,inst_60960);
var inst_60962 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_60963 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60964 = ["?auth","?id"];
var inst_60965 = (new cljs.core.PersistentVector(null,2,(5),inst_60963,inst_60964,null));
var inst_60966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60968 = [inst_60926,"_tx/auth","?auth"];
var inst_60969 = (new cljs.core.PersistentVector(null,3,(5),inst_60967,inst_60968,null));
var inst_60970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60971 = ["?auth","_auth/id","?id"];
var inst_60972 = (new cljs.core.PersistentVector(null,3,(5),inst_60970,inst_60971,null));
var inst_60973 = [inst_60969,inst_60972];
var inst_60974 = (new cljs.core.PersistentVector(null,2,(5),inst_60966,inst_60973,null));
var inst_60975 = [inst_60965,inst_60974];
var inst_60976 = cljs.core.PersistentHashMap.fromArrays(inst_60962,inst_60975);
var inst_60977 = fluree.db.api.query.query_async.call(null,inst_60959,inst_60976);
var state_60992__$1 = (function (){var statearr_61149 = state_60992;
(statearr_61149[(17)] = inst_60946);

(statearr_61149[(18)] = inst_60961);

return statearr_61149;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_60992__$1,(14),inst_60977);
} else {
if((state_val_60993 === (9))){
var state_60992__$1 = state_60992;
var statearr_61150_61233 = state_60992__$1;
(statearr_61150_61233[(2)] = show_auth);

(statearr_61150_61233[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60993 === (5))){
var inst_60920 = (state_60992[(10)]);
var state_60992__$1 = state_60992;
var statearr_61151_61234 = state_60992__$1;
(statearr_61151_61234[(2)] = inst_60920);

(statearr_61151_61234[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60993 === (14))){
var inst_60937 = (state_60992[(11)]);
var inst_60946 = (state_60992[(17)]);
var inst_60979 = (state_60992[(2)]);
var inst_60980 = fluree.db.util.async.throw_err.call(null,inst_60979);
var inst_60981 = cljs.core.assoc_in.call(null,inst_60937,inst_60946,inst_60980);
var state_60992__$1 = state_60992;
var statearr_61152_61235 = state_60992__$1;
(statearr_61152_61235[(2)] = inst_60981);

(statearr_61152_61235[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60993 === (10))){
var inst_60942 = (state_60992[(2)]);
var state_60992__$1 = state_60992;
if(cljs.core.truth_(inst_60942)){
var statearr_61153_61236 = state_60992__$1;
(statearr_61153_61236[(1)] = (11));

} else {
var statearr_61154_61237 = state_60992__$1;
(statearr_61154_61237[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60993 === (8))){
var inst_60938 = (state_60992[(7)]);
var state_60992__$1 = state_60992;
var statearr_61155_61238 = state_60992__$1;
(statearr_61155_61238[(2)] = inst_60938);

(statearr_61155_61238[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____0 = (function (){
var statearr_61156 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61156[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__);

(statearr_61156[(1)] = (1));

return statearr_61156;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____1 = (function (state_60992){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_60992);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e61157){var ex__2729__auto__ = e61157;
var statearr_61158_61239 = state_60992;
(statearr_61158_61239[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_60992[(4)]))){
var statearr_61159_61240 = state_60992;
(statearr_61159_61240[(1)] = cljs.core.first.call(null,(state_60992[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61241 = state_60992;
state_60992 = G__61241;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__ = function(state_60992){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____1.call(this,state_60992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_61160 = f__2749__auto__.call(null);
(statearr_61160[(6)] = c__2748__auto____$1);

return statearr_61160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
});
})();
var inst_60996 = cljs.core.async.impl.dispatch.run.call(null,inst_60995);
var state_61092__$1 = (function (){var statearr_61161 = state_61092;
(statearr_61161[(20)] = inst_60996);

return statearr_61161;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61092__$1,(6),inst_60994);
} else {
if((state_val_61093 === (23))){
var inst_61050 = (state_61092[(2)]);
var state_61092__$1 = (function (){var statearr_61162 = state_61092;
(statearr_61162[(13)] = inst_61050);

return statearr_61162;
})();
var statearr_61163_61242 = state_61092__$1;
(statearr_61163_61242[(1)] = (24));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (35))){
var inst_61080 = (state_61092[(2)]);
var state_61092__$1 = state_61092;
var statearr_61165_61243 = state_61092__$1;
(statearr_61165_61243[(2)] = inst_61080);

(statearr_61165_61243[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (19))){
var state_61092__$1 = state_61092;
var statearr_61166_61244 = state_61092__$1;
(statearr_61166_61244[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (11))){
var inst_61031 = (state_61092[(2)]);
var state_61092__$1 = state_61092;
if(cljs.core.truth_(inst_61031)){
var statearr_61169_61245 = state_61092__$1;
(statearr_61169_61245[(1)] = (15));

} else {
var statearr_61170_61246 = state_61092__$1;
(statearr_61170_61246[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (9))){
var inst_61022 = (state_61092[(16)]);
var inst_61022__$1 = auth;
var state_61092__$1 = (function (){var statearr_61171 = state_61092;
(statearr_61171[(16)] = inst_61022__$1);

return statearr_61171;
})();
if(cljs.core.truth_(inst_61022__$1)){
var statearr_61172_61247 = state_61092__$1;
(statearr_61172_61247[(1)] = (12));

} else {
var statearr_61173_61248 = state_61092__$1;
(statearr_61173_61248[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (5))){
var _ = (function (){var statearr_61174 = state_61092;
(statearr_61174[(4)] = cljs.core.rest.call(null,(state_61092[(4)])));

return statearr_61174;
})();
var state_61092__$1 = state_61092;
var ex61168 = (state_61092__$1[(2)]);
var statearr_61175_61249 = state_61092__$1;
(statearr_61175_61249[(5)] = ex61168);


if((ex61168 instanceof Error)){
var statearr_61176_61250 = state_61092__$1;
(statearr_61176_61250[(1)] = (4));

(statearr_61176_61250[(5)] = null);

} else {
throw ex61168;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (14))){
var inst_61028 = (state_61092[(2)]);
var state_61092__$1 = state_61092;
var statearr_61177_61251 = state_61092__$1;
(statearr_61177_61251[(2)] = inst_61028);

(statearr_61177_61251[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (26))){
var inst_61058 = (state_61092[(2)]);
var state_61092__$1 = (function (){var statearr_61178 = state_61092;
(statearr_61178[(12)] = inst_61058);

return statearr_61178;
})();
var statearr_61179_61252 = state_61092__$1;
(statearr_61179_61252[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (16))){
var inst_61019 = (state_61092[(7)]);
var state_61092__$1 = state_61092;
if(cljs.core.truth_(inst_61019)){
var statearr_61181_61253 = state_61092__$1;
(statearr_61181_61253[(1)] = (18));

} else {
var statearr_61182_61254 = state_61092__$1;
(statearr_61182_61254[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (30))){
var inst_61040 = (state_61092[(10)]);
var inst_61066 = (state_61092[(15)]);
var inst_61041 = (state_61092[(21)]);
var inst_61068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61069 = [inst_61040,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61070 = (new cljs.core.PersistentVector(null,2,(5),inst_61068,inst_61069,null));
var inst_61071 = cljs.core.assoc_in.call(null,inst_61066,inst_61070,inst_61041);
var state_61092__$1 = state_61092;
var statearr_61183_61255 = state_61092__$1;
(statearr_61183_61255[(2)] = inst_61071);

(statearr_61183_61255[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (10))){
var inst_61019 = (state_61092[(7)]);
var state_61092__$1 = state_61092;
var statearr_61184_61256 = state_61092__$1;
(statearr_61184_61256[(2)] = inst_61019);

(statearr_61184_61256[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (18))){
var inst_61019 = (state_61092[(7)]);
var inst_60999 = (state_61092[(18)]);
var inst_61037 = (state_61092[(11)]);
var inst_61037__$1 = inst_61019.t;
var inst_61038 = cljs.core.get.call(null,inst_60999,inst_61037__$1);
var inst_61039 = cljs.core.__destructure_map.call(null,inst_61038);
var inst_61040 = cljs.core.get.call(null,inst_61039,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61041 = cljs.core.get.call(null,inst_61039,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_61092__$1 = (function (){var statearr_61185 = state_61092;
(statearr_61185[(10)] = inst_61040);

(statearr_61185[(11)] = inst_61037__$1);

(statearr_61185[(21)] = inst_61041);

return statearr_61185;
})();
var statearr_61186_61257 = state_61092__$1;
(statearr_61186_61257[(1)] = (21));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61093 === (8))){
var inst_61086 = (state_61092[(2)]);
var inst_61087 = cljs.core.vals.call(null,inst_61086);
var _ = (function (){var statearr_61188 = state_61092;
(statearr_61188[(4)] = cljs.core.rest.call(null,(state_61092[(4)])));

return statearr_61188;
})();
var state_61092__$1 = state_61092;
var statearr_61189_61258 = state_61092__$1;
(statearr_61189_61258[(2)] = inst_61087);

(statearr_61189_61258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____0 = (function (){
var statearr_61190 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61190[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__);

(statearr_61190[(1)] = (1));

return statearr_61190;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____1 = (function (state_61092){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_61092);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e61191){var ex__2729__auto__ = e61191;
var statearr_61192_61259 = state_61092;
(statearr_61192_61259[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_61092[(4)]))){
var statearr_61193_61260 = state_61092;
(statearr_61193_61260[(1)] = cljs.core.first.call(null,(state_61092[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61261 = state_61092;
state_61092 = G__61261;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__ = function(state_61092){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____1.call(this,state_61092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2726__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_61194 = f__2749__auto__.call(null);
(statearr_61194[(6)] = c__2748__auto__);

return statearr_61194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Convert flakes into vectors.
 *   Notes:
 *   Cannot use IPrintWithWriter override since calls to storage-handler
 *   download blocks using the #Flake format to support internal query
 *   handling.
 */
fluree.db.api.query.block_Flakes__GT_vector = (function fluree$db$api$query$block_Flakes__GT_vector(blocks){
return cljs.core.mapv.call(null,(function (block){
return cljs.core.assoc.call(null,block,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.mapv.call(null,cljs.core.vec,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block)));
}),blocks);
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_61388){
var state_val_61389 = (state_61388[(1)]);
if((state_val_61389 === (7))){
var inst_61284 = (state_61388[(7)]);
var inst_61286 = fluree.db.api.query.resolve_block_range.call(null,inst_61284,query_map);
var state_61388__$1 = state_61388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61388__$1,(10),inst_61286);
} else {
if((state_val_61389 === (20))){
var inst_61313 = (state_61388[(2)]);
var inst_61314 = fluree.db.util.async.throw_err.call(null,inst_61313);
var inst_61315 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61314);
var inst_61316 = (inst_61315 - (1));
var state_61388__$1 = state_61388;
var statearr_61390_61453 = state_61388__$1;
(statearr_61390_61453[(2)] = inst_61316);

(statearr_61390_61453[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (27))){
var state_61388__$1 = state_61388;
var statearr_61391_61454 = state_61388__$1;
(statearr_61391_61454[(2)] = null);

(statearr_61391_61454[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (1))){
var state_61388__$1 = state_61388;
var statearr_61392_61455 = state_61388__$1;
(statearr_61392_61455[(2)] = null);

(statearr_61392_61455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (24))){
var inst_61323 = (state_61388[(2)]);
var inst_61324 = fluree.db.util.async.throw_err.call(null,inst_61323);
var inst_61325 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61324);
var state_61388__$1 = state_61388;
var statearr_61393_61456 = state_61388__$1;
(statearr_61393_61456[(2)] = inst_61325);

(statearr_61393_61456[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (39))){
var inst_61360 = (state_61388[(2)]);
var inst_61361 = fluree.db.util.async.throw_err.call(null,inst_61360);
var state_61388__$1 = state_61388;
var statearr_61394_61457 = state_61388__$1;
(statearr_61394_61457[(2)] = inst_61361);

(statearr_61394_61457[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (4))){
var inst_61262 = (state_61388[(2)]);
var state_61388__$1 = state_61388;
var statearr_61395_61458 = state_61388__$1;
(statearr_61395_61458[(2)] = inst_61262);

(statearr_61395_61458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (15))){
var inst_61293 = (state_61388[(8)]);
var state_61388__$1 = state_61388;
var statearr_61396_61459 = state_61388__$1;
(statearr_61396_61459[(2)] = inst_61293);

(statearr_61396_61459[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (21))){
var inst_61284 = (state_61388[(7)]);
var inst_61294 = (state_61388[(9)]);
var inst_61321 = fluree.db.time_travel.as_of_block.call(null,inst_61284,inst_61294);
var state_61388__$1 = state_61388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61388__$1,(24),inst_61321);
} else {
if((state_val_61389 === (31))){
var inst_61278 = (state_61388[(10)]);
var state_61388__$1 = state_61388;
var statearr_61397_61460 = state_61388__$1;
(statearr_61397_61460[(2)] = inst_61278);

(statearr_61397_61460[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (32))){
var inst_61284 = (state_61388[(7)]);
var inst_61344 = (state_61388[(11)]);
var inst_61339 = (state_61388[(12)]);
var inst_61348 = (state_61388[(2)]);
var inst_61349 = fluree.db.api.query.format_history_resp.call(null,inst_61284,inst_61339,inst_61344,inst_61348);
var state_61388__$1 = state_61388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61388__$1,(29),inst_61349);
} else {
if((state_val_61389 === (40))){
var inst_61365 = (state_61388[(13)]);
var inst_61339 = (state_61388[(12)]);
var inst_61367 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_61368 = cljs.core.count.call(null,inst_61339);
var inst_61369 = [inst_61365,inst_61368,(200)];
var inst_61370 = cljs.core.PersistentHashMap.fromArrays(inst_61367,inst_61369);
var state_61388__$1 = state_61388;
var statearr_61398_61461 = state_61388__$1;
(statearr_61398_61461[(2)] = inst_61370);

(statearr_61398_61461[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (33))){
var inst_61277 = (state_61388[(14)]);
var state_61388__$1 = state_61388;
var statearr_61399_61462 = state_61388__$1;
(statearr_61399_61462[(2)] = inst_61277);

(statearr_61399_61462[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (13))){
var inst_61383 = (state_61388[(2)]);
var _ = (function (){var statearr_61400 = state_61388;
(statearr_61400[(4)] = cljs.core.rest.call(null,(state_61388[(4)])));

return statearr_61400;
})();
var state_61388__$1 = state_61388;
var statearr_61401_61463 = state_61388__$1;
(statearr_61401_61463[(2)] = inst_61383);

(statearr_61401_61463[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (22))){
var inst_61284 = (state_61388[(7)]);
var inst_61327 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_61284);
var state_61388__$1 = state_61388;
var statearr_61402_61464 = state_61388__$1;
(statearr_61402_61464[(2)] = inst_61327);

(statearr_61402_61464[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (36))){
var inst_61284 = (state_61388[(7)]);
var inst_61352 = (state_61388[(15)]);
var inst_61358 = fluree.db.api.query.format_blocks_resp_pretty.call(null,inst_61284,inst_61352);
var state_61388__$1 = state_61388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61388__$1,(39),inst_61358);
} else {
if((state_val_61389 === (41))){
var inst_61365 = (state_61388[(13)]);
var state_61388__$1 = state_61388;
var statearr_61403_61465 = state_61388__$1;
(statearr_61403_61465[(2)] = inst_61365);

(statearr_61403_61465[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (29))){
var inst_61277 = (state_61388[(14)]);
var inst_61351 = (state_61388[(2)]);
var inst_61352 = fluree.db.util.async.throw_err.call(null,inst_61351);
var state_61388__$1 = (function (){var statearr_61404 = state_61388;
(statearr_61404[(15)] = inst_61352);

return statearr_61404;
})();
if(cljs.core.truth_(inst_61277)){
var statearr_61405_61466 = state_61388__$1;
(statearr_61405_61466[(1)] = (33));

} else {
var statearr_61406_61467 = state_61388__$1;
(statearr_61406_61467[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (6))){
var inst_61274 = (state_61388[(16)]);
var inst_61283 = (state_61388[(2)]);
var inst_61284 = fluree.db.util.async.throw_err.call(null,inst_61283);
var state_61388__$1 = (function (){var statearr_61407 = state_61388;
(statearr_61407[(7)] = inst_61284);

return statearr_61407;
})();
if(cljs.core.truth_(inst_61274)){
var statearr_61408_61468 = state_61388__$1;
(statearr_61408_61468[(1)] = (7));

} else {
var statearr_61409_61469 = state_61388__$1;
(statearr_61409_61469[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (28))){
var inst_61279 = (state_61388[(17)]);
var inst_61344 = (state_61388[(2)]);
var state_61388__$1 = (function (){var statearr_61410 = state_61388;
(statearr_61410[(11)] = inst_61344);

return statearr_61410;
})();
if(cljs.core.truth_(inst_61279)){
var statearr_61411_61470 = state_61388__$1;
(statearr_61411_61470[(1)] = (30));

} else {
var statearr_61412_61471 = state_61388__$1;
(statearr_61412_61471[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (25))){
var inst_61280 = (state_61388[(18)]);
var inst_61338 = (state_61388[(2)]);
var inst_61339 = fluree.db.util.async.throw_err.call(null,inst_61338);
var state_61388__$1 = (function (){var statearr_61413 = state_61388;
(statearr_61413[(12)] = inst_61339);

return statearr_61413;
})();
if(cljs.core.truth_(inst_61280)){
var statearr_61414_61472 = state_61388__$1;
(statearr_61414_61472[(1)] = (26));

} else {
var statearr_61415_61473 = state_61388__$1;
(statearr_61415_61473[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (34))){
var inst_61276 = (state_61388[(19)]);
var state_61388__$1 = state_61388;
var statearr_61416_61474 = state_61388__$1;
(statearr_61416_61474[(2)] = inst_61276);

(statearr_61416_61474[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (17))){
var inst_61284 = (state_61388[(7)]);
var inst_61293 = (state_61388[(8)]);
var inst_61310 = (inst_61293 - (1));
var inst_61311 = fluree.db.time_travel.as_of_block.call(null,inst_61284,inst_61310);
var state_61388__$1 = state_61388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61388__$1,(20),inst_61311);
} else {
if((state_val_61389 === (3))){
var inst_61386 = (state_61388[(2)]);
var state_61388__$1 = state_61388;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61388__$1,inst_61386);
} else {
if((state_val_61389 === (12))){
var inst_61375 = cljs.core.pr_str.call(null,query_map);
var inst_61376 = ["History query not properly formatted. Provided ",inst_61375].join('');
var inst_61377 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61378 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61379 = cljs.core.PersistentHashMap.fromArrays(inst_61377,inst_61378);
var inst_61380 = cljs.core.ex_info.call(null,inst_61376,inst_61379);
var inst_61381 = (function(){throw inst_61380})();
var state_61388__$1 = state_61388;
var statearr_61417_61475 = state_61388__$1;
(statearr_61417_61475[(2)] = inst_61381);

(statearr_61417_61475[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (2))){
var _ = (function (){var statearr_61418 = state_61388;
(statearr_61418[(4)] = cljs.core.cons.call(null,(5),(state_61388[(4)])));

return statearr_61418;
})();
var inst_61272 = query_map;
var inst_61273 = cljs.core.__destructure_map.call(null,inst_61272);
var inst_61274 = cljs.core.get.call(null,inst_61273,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61275 = cljs.core.get.call(null,inst_61273,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61276 = cljs.core.get.call(null,inst_61273,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_61277 = cljs.core.get.call(null,inst_61273,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_61278 = cljs.core.get.call(null,inst_61273,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_61279 = cljs.core.get.call(null,inst_61273,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_61280 = cljs.core.get.call(null,inst_61273,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_61281 = cljs.core.get.call(null,inst_61273,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_61388__$1 = (function (){var statearr_61419 = state_61388;
(statearr_61419[(10)] = inst_61278);

(statearr_61419[(18)] = inst_61280);

(statearr_61419[(20)] = inst_61281);

(statearr_61419[(17)] = inst_61279);

(statearr_61419[(21)] = inst_61275);

(statearr_61419[(19)] = inst_61276);

(statearr_61419[(16)] = inst_61274);

(statearr_61419[(14)] = inst_61277);

return statearr_61419;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61388__$1,(6),sources);
} else {
if((state_val_61389 === (23))){
var inst_61284 = (state_61388[(7)]);
var inst_61319 = (state_61388[(22)]);
var inst_61275 = (state_61388[(21)]);
var inst_61329 = (state_61388[(2)]);
var inst_61330 = fluree.db.api.query.get_history_pattern.call(null,inst_61275);
var inst_61331 = cljs.core.nth.call(null,inst_61330,(0),null);
var inst_61332 = cljs.core.nth.call(null,inst_61330,(1),null);
var inst_61333 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_61334 = [inst_61319,inst_61329];
var inst_61335 = cljs.core.PersistentHashMap.fromArrays(inst_61333,inst_61334);
var inst_61336 = fluree.db.query.range.time_range.call(null,inst_61284,inst_61332,cljs.core._EQ_,inst_61331,inst_61335);
var state_61388__$1 = state_61388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61388__$1,(25),inst_61336);
} else {
if((state_val_61389 === (35))){
var inst_61356 = (state_61388[(2)]);
var state_61388__$1 = state_61388;
if(cljs.core.truth_(inst_61356)){
var statearr_61420_61476 = state_61388__$1;
(statearr_61420_61476[(1)] = (36));

} else {
var statearr_61421_61477 = state_61388__$1;
(statearr_61421_61477[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (19))){
var inst_61294 = (state_61388[(9)]);
var inst_61319 = (state_61388[(2)]);
var state_61388__$1 = (function (){var statearr_61422 = state_61388;
(statearr_61422[(22)] = inst_61319);

return statearr_61422;
})();
if(cljs.core.truth_(inst_61294)){
var statearr_61423_61478 = state_61388__$1;
(statearr_61423_61478[(1)] = (21));

} else {
var statearr_61424_61479 = state_61388__$1;
(statearr_61424_61479[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (11))){
var inst_61293 = (state_61388[(8)]);
var inst_61281 = (state_61388[(20)]);
var inst_61303 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61281);
var state_61388__$1 = (function (){var statearr_61426 = state_61388;
(statearr_61426[(23)] = inst_61303);

return statearr_61426;
})();
if(cljs.core.truth_(inst_61293)){
var statearr_61427_61480 = state_61388__$1;
(statearr_61427_61480[(1)] = (14));

} else {
var statearr_61428_61481 = state_61388__$1;
(statearr_61428_61481[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (9))){
var inst_61292 = (state_61388[(2)]);
var inst_61293 = cljs.core.nth.call(null,inst_61292,(0),null);
var inst_61294 = cljs.core.nth.call(null,inst_61292,(1),null);
var inst_61295 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_61296 = cljs.core.dissoc.call(null,query_map,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61297 = cljs.core.keys.call(null,inst_61296);
var inst_61298 = cljs.core._EQ_.call(null,inst_61295,inst_61297);
var state_61388__$1 = (function (){var statearr_61429 = state_61388;
(statearr_61429[(8)] = inst_61293);

(statearr_61429[(9)] = inst_61294);

return statearr_61429;
})();
if(inst_61298){
var statearr_61430_61482 = state_61388__$1;
(statearr_61430_61482[(1)] = (11));

} else {
var statearr_61431_61483 = state_61388__$1;
(statearr_61431_61483[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (5))){
var _ = (function (){var statearr_61432 = state_61388;
(statearr_61432[(4)] = cljs.core.rest.call(null,(state_61388[(4)])));

return statearr_61432;
})();
var state_61388__$1 = state_61388;
var ex61425 = (state_61388__$1[(2)]);
var statearr_61433_61484 = state_61388__$1;
(statearr_61433_61484[(5)] = ex61425);


if((ex61425 instanceof Error)){
var statearr_61434_61485 = state_61388__$1;
(statearr_61434_61485[(1)] = (4));

(statearr_61434_61485[(5)] = null);

} else {
throw ex61425;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (14))){
var inst_61293 = (state_61388[(8)]);
var inst_61305 = cljs.core.not_EQ_.call(null,(1),inst_61293);
var state_61388__$1 = state_61388;
var statearr_61435_61486 = state_61388__$1;
(statearr_61435_61486[(2)] = inst_61305);

(statearr_61435_61486[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (26))){
var inst_61280 = (state_61388[(18)]);
var inst_61341 = cljs.core.set.call(null,inst_61280);
var state_61388__$1 = state_61388;
var statearr_61436_61487 = state_61388__$1;
(statearr_61436_61487[(2)] = inst_61341);

(statearr_61436_61487[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (16))){
var inst_61308 = (state_61388[(2)]);
var state_61388__$1 = state_61388;
if(cljs.core.truth_(inst_61308)){
var statearr_61437_61488 = state_61388__$1;
(statearr_61437_61488[(1)] = (17));

} else {
var statearr_61438_61489 = state_61388__$1;
(statearr_61438_61489[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (38))){
var inst_61303 = (state_61388[(23)]);
var inst_61365 = (state_61388[(2)]);
var state_61388__$1 = (function (){var statearr_61439 = state_61388;
(statearr_61439[(13)] = inst_61365);

return statearr_61439;
})();
if(cljs.core.truth_(inst_61303)){
var statearr_61440_61490 = state_61388__$1;
(statearr_61440_61490[(1)] = (40));

} else {
var statearr_61441_61491 = state_61388__$1;
(statearr_61441_61491[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (30))){
var inst_61279 = (state_61388[(17)]);
var state_61388__$1 = state_61388;
var statearr_61442_61492 = state_61388__$1;
(statearr_61442_61492[(2)] = inst_61279);

(statearr_61442_61492[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (10))){
var inst_61288 = (state_61388[(2)]);
var inst_61289 = fluree.db.util.async.throw_err.call(null,inst_61288);
var state_61388__$1 = state_61388;
var statearr_61443_61493 = state_61388__$1;
(statearr_61443_61493[(2)] = inst_61289);

(statearr_61443_61493[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (18))){
var state_61388__$1 = state_61388;
var statearr_61444_61494 = state_61388__$1;
(statearr_61444_61494[(2)] = (-1));

(statearr_61444_61494[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (42))){
var inst_61373 = (state_61388[(2)]);
var state_61388__$1 = state_61388;
var statearr_61445_61495 = state_61388__$1;
(statearr_61445_61495[(2)] = inst_61373);

(statearr_61445_61495[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (37))){
var inst_61352 = (state_61388[(15)]);
var inst_61363 = fluree.db.api.query.block_Flakes__GT_vector.call(null,inst_61352);
var state_61388__$1 = state_61388;
var statearr_61446_61496 = state_61388__$1;
(statearr_61446_61496[(2)] = inst_61363);

(statearr_61446_61496[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61389 === (8))){
var state_61388__$1 = state_61388;
var statearr_61447_61497 = state_61388__$1;
(statearr_61447_61497[(2)] = null);

(statearr_61447_61497[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2726__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2726__auto____0 = (function (){
var statearr_61448 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61448[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2726__auto__);

(statearr_61448[(1)] = (1));

return statearr_61448;
});
var fluree$db$api$query$history_query_async_$_state_machine__2726__auto____1 = (function (state_61388){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_61388);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e61449){var ex__2729__auto__ = e61449;
var statearr_61450_61498 = state_61388;
(statearr_61450_61498[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_61388[(4)]))){
var statearr_61451_61499 = state_61388;
(statearr_61451_61499[(1)] = cljs.core.first.call(null,(state_61388[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61500 = state_61388;
state_61388 = G__61500;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2726__auto__ = function(state_61388){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2726__auto____1.call(this,state_61388);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2726__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2726__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_61452 = f__2749__auto__.call(null);
(statearr_61452[(6)] = c__2748__auto__);

return statearr_61452;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_61633){
var state_val_61634 = (state_61633[(1)]);
if((state_val_61634 === (7))){
var inst_61530 = cljs.core.pr_str.call(null,flureeQL);
var inst_61531 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_61530].join('');
var inst_61532 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61533 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61534 = cljs.core.PersistentHashMap.fromArrays(inst_61532,inst_61533);
var inst_61535 = cljs.core.ex_info.call(null,inst_61531,inst_61534);
var inst_61536 = (function(){throw inst_61535})();
var state_61633__$1 = state_61633;
var statearr_61635_61714 = state_61633__$1;
(statearr_61635_61714[(2)] = inst_61536);

(statearr_61635_61714[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (20))){
var inst_61568 = (state_61633[(2)]);
var state_61633__$1 = state_61633;
if(cljs.core.truth_(inst_61568)){
var statearr_61636_61715 = state_61633__$1;
(statearr_61636_61715[(1)] = (21));

} else {
var statearr_61637_61716 = state_61633__$1;
(statearr_61637_61716[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (27))){
var inst_61512 = (state_61633[(7)]);
var state_61633__$1 = state_61633;
var statearr_61638_61717 = state_61633__$1;
(statearr_61638_61717[(2)] = inst_61512);

(statearr_61638_61717[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (1))){
var state_61633__$1 = state_61633;
var statearr_61639_61718 = state_61633__$1;
(statearr_61639_61718[(2)] = null);

(statearr_61639_61718[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (24))){
var inst_61574 = (state_61633[(8)]);
var state_61633__$1 = state_61633;
var statearr_61640_61719 = state_61633__$1;
(statearr_61640_61719[(2)] = inst_61574);

(statearr_61640_61719[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (39))){
var inst_61518 = (state_61633[(9)]);
var state_61633__$1 = state_61633;
if(cljs.core.truth_(inst_61518)){
var statearr_61641_61720 = state_61633__$1;
(statearr_61641_61720[(1)] = (42));

} else {
var statearr_61642_61721 = state_61633__$1;
(statearr_61642_61721[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (46))){
var inst_61606 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61607 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61608 = cljs.core.PersistentHashMap.fromArrays(inst_61606,inst_61607);
var inst_61609 = cljs.core.ex_info.call(null,"Invalid query.",inst_61608);
var inst_61610 = (function(){throw inst_61609})();
var state_61633__$1 = state_61633;
var statearr_61643_61722 = state_61633__$1;
(statearr_61643_61722[(2)] = inst_61610);

(statearr_61643_61722[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (4))){
var inst_61502 = (state_61633[(2)]);
var state_61633__$1 = state_61633;
var statearr_61644_61723 = state_61633__$1;
(statearr_61644_61723[(2)] = inst_61502);

(statearr_61644_61723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (15))){
var inst_61515 = (state_61633[(10)]);
var inst_61553 = (state_61633[(11)]);
var inst_61555 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_61553);
var inst_61556 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_61553);
var inst_61557 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_61553);
var inst_61558 = fluree.db.api.query.get_sources.call(null,inst_61555,inst_61556,inst_61557,inst_61515);
var state_61633__$1 = state_61633;
var statearr_61645_61724 = state_61633__$1;
(statearr_61645_61724[(2)] = inst_61558);

(statearr_61645_61724[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (48))){
var inst_61563 = (state_61633[(12)]);
var inst_61617 = (state_61633[(2)]);
var inst_61618 = fluree.db.util.async.throw_err.call(null,inst_61617);
var state_61633__$1 = (function (){var statearr_61646 = state_61633;
(statearr_61646[(13)] = inst_61618);

return statearr_61646;
})();
if(cljs.core.truth_(inst_61563)){
var statearr_61647_61725 = state_61633__$1;
(statearr_61647_61725[(1)] = (49));

} else {
var statearr_61648_61726 = state_61633__$1;
(statearr_61648_61726[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (50))){
var inst_61618 = (state_61633[(13)]);
var state_61633__$1 = state_61633;
var statearr_61649_61727 = state_61633__$1;
(statearr_61649_61727[(2)] = inst_61618);

(statearr_61649_61727[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (21))){
var inst_61570 = cljs.core.volatile_BANG_.call(null,(0));
var state_61633__$1 = state_61633;
var statearr_61650_61728 = state_61633__$1;
(statearr_61650_61728[(2)] = inst_61570);

(statearr_61650_61728[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (31))){
var inst_61516 = (state_61633[(14)]);
var state_61633__$1 = state_61633;
if(cljs.core.truth_(inst_61516)){
var statearr_61651_61729 = state_61633__$1;
(statearr_61651_61729[(1)] = (33));

} else {
var statearr_61652_61730 = state_61633__$1;
(statearr_61652_61730[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (32))){
var inst_61593 = (state_61633[(2)]);
var state_61633__$1 = state_61633;
var statearr_61653_61731 = state_61633__$1;
(statearr_61653_61731[(2)] = inst_61593);

(statearr_61653_61731[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (40))){
var inst_61595 = (state_61633[(15)]);
var state_61633__$1 = state_61633;
var statearr_61654_61732 = state_61633__$1;
(statearr_61654_61732[(2)] = inst_61595);

(statearr_61654_61732[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (33))){
var inst_61516 = (state_61633[(14)]);
var state_61633__$1 = state_61633;
var statearr_61655_61733 = state_61633__$1;
(statearr_61655_61733[(2)] = inst_61516);

(statearr_61655_61733[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (13))){
var inst_61513 = (state_61633[(16)]);
var inst_61542 = (state_61633[(2)]);
var inst_61543 = fluree.db.util.async.throw_err.call(null,inst_61542);
var inst_61544 = fluree.db.time_travel.as_of_block.call(null,inst_61543,inst_61513);
var state_61633__$1 = state_61633;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61633__$1,(12),inst_61544);
} else {
if((state_val_61634 === (22))){
var state_61633__$1 = state_61633;
var statearr_61656_61734 = state_61633__$1;
(statearr_61656_61734[(2)] = null);

(statearr_61656_61734[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (36))){
var inst_61520 = (state_61633[(17)]);
var state_61633__$1 = state_61633;
var statearr_61657_61735 = state_61633__$1;
(statearr_61657_61735[(2)] = inst_61520);

(statearr_61657_61735[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (41))){
var inst_61603 = (state_61633[(2)]);
var state_61633__$1 = state_61633;
if(cljs.core.truth_(inst_61603)){
var statearr_61658_61736 = state_61633__$1;
(statearr_61658_61736[(1)] = (45));

} else {
var statearr_61659_61737 = state_61633__$1;
(statearr_61659_61737[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (43))){
var inst_61514 = (state_61633[(18)]);
var state_61633__$1 = state_61633;
var statearr_61660_61738 = state_61633__$1;
(statearr_61660_61738[(2)] = inst_61514);

(statearr_61660_61738[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (29))){
var inst_61595 = (state_61633[(15)]);
var inst_61595__$1 = (state_61633[(2)]);
var state_61633__$1 = (function (){var statearr_61661 = state_61633;
(statearr_61661[(15)] = inst_61595__$1);

return statearr_61661;
})();
if(cljs.core.truth_(inst_61595__$1)){
var statearr_61662_61739 = state_61633__$1;
(statearr_61662_61739[(1)] = (39));

} else {
var statearr_61663_61740 = state_61633__$1;
(statearr_61663_61740[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (44))){
var inst_61600 = (state_61633[(2)]);
var state_61633__$1 = state_61633;
var statearr_61664_61741 = state_61633__$1;
(statearr_61664_61741[(2)] = inst_61600);

(statearr_61664_61741[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (6))){
var state_61633__$1 = state_61633;
var statearr_61665_61742 = state_61633__$1;
(statearr_61665_61742[(2)] = null);

(statearr_61665_61742[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (28))){
var inst_61517 = (state_61633[(19)]);
var state_61633__$1 = state_61633;
if(cljs.core.truth_(inst_61517)){
var statearr_61666_61743 = state_61633__$1;
(statearr_61666_61743[(1)] = (30));

} else {
var statearr_61667_61744 = state_61633__$1;
(statearr_61667_61744[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (51))){
var inst_61628 = (state_61633[(2)]);
var _ = (function (){var statearr_61668 = state_61633;
(statearr_61668[(4)] = cljs.core.rest.call(null,(state_61633[(4)])));

return statearr_61668;
})();
var state_61633__$1 = state_61633;
var statearr_61669_61745 = state_61633__$1;
(statearr_61669_61745[(2)] = inst_61628);

(statearr_61669_61745[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (25))){
var state_61633__$1 = state_61633;
var statearr_61670_61746 = state_61633__$1;
(statearr_61670_61746[(2)] = (1000000));

(statearr_61670_61746[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (34))){
var inst_61520 = (state_61633[(17)]);
var state_61633__$1 = state_61633;
if(cljs.core.truth_(inst_61520)){
var statearr_61671_61747 = state_61633__$1;
(statearr_61671_61747[(1)] = (36));

} else {
var statearr_61672_61748 = state_61633__$1;
(statearr_61672_61748[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (17))){
var inst_61564 = (state_61633[(20)]);
var inst_61519 = (state_61633[(21)]);
var inst_61562 = (state_61633[(2)]);
var inst_61563 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_61519);
var inst_61564__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61519);
var state_61633__$1 = (function (){var statearr_61673 = state_61633;
(statearr_61673[(12)] = inst_61563);

(statearr_61673[(20)] = inst_61564__$1);

(statearr_61673[(22)] = inst_61562);

return statearr_61673;
})();
if(cljs.core.truth_(inst_61564__$1)){
var statearr_61674_61749 = state_61633__$1;
(statearr_61674_61749[(1)] = (18));

} else {
var statearr_61675_61750 = state_61633__$1;
(statearr_61675_61750[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (3))){
var inst_61631 = (state_61633[(2)]);
var state_61633__$1 = state_61633;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61633__$1,inst_61631);
} else {
if((state_val_61634 === (12))){
var inst_61546 = (state_61633[(2)]);
var inst_61547 = fluree.db.util.async.throw_err.call(null,inst_61546);
var state_61633__$1 = state_61633;
var statearr_61676_61751 = state_61633__$1;
(statearr_61676_61751[(2)] = inst_61547);

(statearr_61676_61751[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (2))){
var inst_61511 = (state_61633[(23)]);
var inst_61520 = (state_61633[(17)]);
var inst_61517 = (state_61633[(19)]);
var inst_61516 = (state_61633[(14)]);
var inst_61515 = (state_61633[(10)]);
var inst_61513 = (state_61633[(16)]);
var inst_61512 = (state_61633[(7)]);
var inst_61518 = (state_61633[(9)]);
var inst_61514 = (state_61633[(18)]);
var inst_61519 = (state_61633[(21)]);
var _ = (function (){var statearr_61677 = state_61633;
(statearr_61677[(4)] = cljs.core.cons.call(null,(5),(state_61633[(4)])));

return statearr_61677;
})();
var inst_61509 = flureeQL;
var inst_61510 = cljs.core.__destructure_map.call(null,inst_61509);
var inst_61511__$1 = cljs.core.get.call(null,inst_61510,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_61512__$1 = cljs.core.get.call(null,inst_61510,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_61513__$1 = cljs.core.get.call(null,inst_61510,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61514__$1 = cljs.core.get.call(null,inst_61510,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_61515__$1 = cljs.core.get.call(null,inst_61510,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_61516__$1 = cljs.core.get.call(null,inst_61510,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_61517__$1 = cljs.core.get.call(null,inst_61510,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_61518__$1 = cljs.core.get.call(null,inst_61510,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_61519__$1 = cljs.core.get.call(null,inst_61510,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61520__$1 = cljs.core.get.call(null,inst_61510,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_61521 = (function (){var construct = inst_61511__$1;
var select = inst_61512__$1;
var block = inst_61513__$1;
var where = inst_61514__$1;
var prefixes = inst_61515__$1;
var map__61508 = inst_61510;
var selectDistinct = inst_61516__$1;
var selectOne = inst_61517__$1;
var from = inst_61518__$1;
var opts = inst_61519__$1;
var selectReduced = inst_61520__$1;
return (function (p1__61501_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__61501_SHARP_);
});
})();
var inst_61522 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61523 = [inst_61512__$1,inst_61517__$1,inst_61516__$1,inst_61520__$1];
var inst_61524 = (new cljs.core.PersistentVector(null,4,(5),inst_61522,inst_61523,null));
var inst_61525 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_61524);
var inst_61526 = cljs.core.count.call(null,inst_61525);
var inst_61527 = inst_61521.call(null,inst_61526);
var state_61633__$1 = (function (){var statearr_61678 = state_61633;
(statearr_61678[(23)] = inst_61511__$1);

(statearr_61678[(17)] = inst_61520__$1);

(statearr_61678[(19)] = inst_61517__$1);

(statearr_61678[(14)] = inst_61516__$1);

(statearr_61678[(10)] = inst_61515__$1);

(statearr_61678[(16)] = inst_61513__$1);

(statearr_61678[(7)] = inst_61512__$1);

(statearr_61678[(9)] = inst_61518__$1);

(statearr_61678[(18)] = inst_61514__$1);

(statearr_61678[(21)] = inst_61519__$1);

return statearr_61678;
})();
if(cljs.core.truth_(inst_61527)){
var statearr_61679_61752 = state_61633__$1;
(statearr_61679_61752[(1)] = (6));

} else {
var statearr_61680_61753 = state_61633__$1;
(statearr_61680_61753[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (23))){
var inst_61574 = (state_61633[(8)]);
var inst_61519 = (state_61633[(21)]);
var inst_61573 = (state_61633[(2)]);
var inst_61574__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_61519);
var state_61633__$1 = (function (){var statearr_61681 = state_61633;
(statearr_61681[(24)] = inst_61573);

(statearr_61681[(8)] = inst_61574__$1);

return statearr_61681;
})();
if(cljs.core.truth_(inst_61574__$1)){
var statearr_61682_61754 = state_61633__$1;
(statearr_61682_61754[(1)] = (24));

} else {
var statearr_61683_61755 = state_61633__$1;
(statearr_61683_61755[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (47))){
var inst_61579 = (state_61633[(25)]);
var inst_61553 = (state_61633[(11)]);
var inst_61612 = (state_61633[(2)]);
var inst_61613 = fluree.db.util.core.current_time_millis.call(null);
var inst_61614 = cljs.core.assoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_61579);
var inst_61615 = fluree.db.query.fql.query.call(null,inst_61553,inst_61614);
var state_61633__$1 = (function (){var statearr_61684 = state_61633;
(statearr_61684[(26)] = inst_61612);

(statearr_61684[(27)] = inst_61613);

return statearr_61684;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61633__$1,(48),inst_61615);
} else {
if((state_val_61634 === (35))){
var inst_61591 = (state_61633[(2)]);
var state_61633__$1 = state_61633;
var statearr_61685_61756 = state_61633__$1;
(statearr_61685_61756[(2)] = inst_61591);

(statearr_61685_61756[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (19))){
var inst_61563 = (state_61633[(12)]);
var state_61633__$1 = state_61633;
var statearr_61686_61757 = state_61633__$1;
(statearr_61686_61757[(2)] = inst_61563);

(statearr_61686_61757[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (11))){
var inst_61515 = (state_61633[(10)]);
var inst_61553 = (state_61633[(2)]);
var state_61633__$1 = (function (){var statearr_61688 = state_61633;
(statearr_61688[(11)] = inst_61553);

return statearr_61688;
})();
if(cljs.core.truth_(inst_61515)){
var statearr_61689_61758 = state_61633__$1;
(statearr_61689_61758[(1)] = (15));

} else {
var statearr_61690_61759 = state_61633__$1;
(statearr_61690_61759[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (9))){
var inst_61539 = (state_61633[(28)]);
var state_61633__$1 = state_61633;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61633__$1,(13),inst_61539);
} else {
if((state_val_61634 === (5))){
var _ = (function (){var statearr_61691 = state_61633;
(statearr_61691[(4)] = cljs.core.rest.call(null,(state_61633[(4)])));

return statearr_61691;
})();
var state_61633__$1 = state_61633;
var ex61687 = (state_61633__$1[(2)]);
var statearr_61692_61760 = state_61633__$1;
(statearr_61692_61760[(5)] = ex61687);


if((ex61687 instanceof Error)){
var statearr_61693_61761 = state_61633__$1;
(statearr_61693_61761[(1)] = (4));

(statearr_61693_61761[(5)] = null);

} else {
throw ex61687;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (14))){
var inst_61550 = (state_61633[(2)]);
var inst_61551 = fluree.db.util.async.throw_err.call(null,inst_61550);
var state_61633__$1 = state_61633;
var statearr_61694_61762 = state_61633__$1;
(statearr_61694_61762[(2)] = inst_61551);

(statearr_61694_61762[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (45))){
var state_61633__$1 = state_61633;
var statearr_61695_61763 = state_61633__$1;
(statearr_61695_61763[(2)] = null);

(statearr_61695_61763[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (26))){
var inst_61573 = (state_61633[(24)]);
var inst_61512 = (state_61633[(7)]);
var inst_61562 = (state_61633[(22)]);
var inst_61519 = (state_61633[(21)]);
var inst_61578 = (state_61633[(2)]);
var inst_61579 = cljs.core.assoc.call(null,inst_61519,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_61562,new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_61578,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_61573);
var state_61633__$1 = (function (){var statearr_61696 = state_61633;
(statearr_61696[(25)] = inst_61579);

return statearr_61696;
})();
if(cljs.core.truth_(inst_61512)){
var statearr_61697_61764 = state_61633__$1;
(statearr_61697_61764[(1)] = (27));

} else {
var statearr_61698_61765 = state_61633__$1;
(statearr_61698_61765[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (16))){
var inst_61560 = cljs.core.PersistentHashMap.EMPTY;
var state_61633__$1 = state_61633;
var statearr_61699_61766 = state_61633__$1;
(statearr_61699_61766[(2)] = inst_61560);

(statearr_61699_61766[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (38))){
var inst_61589 = (state_61633[(2)]);
var state_61633__$1 = state_61633;
var statearr_61700_61767 = state_61633__$1;
(statearr_61700_61767[(2)] = inst_61589);

(statearr_61700_61767[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (30))){
var inst_61517 = (state_61633[(19)]);
var state_61633__$1 = state_61633;
var statearr_61701_61768 = state_61633__$1;
(statearr_61701_61768[(2)] = inst_61517);

(statearr_61701_61768[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (10))){
var inst_61539 = (state_61633[(28)]);
var state_61633__$1 = state_61633;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61633__$1,(14),inst_61539);
} else {
if((state_val_61634 === (18))){
var inst_61564 = (state_61633[(20)]);
var state_61633__$1 = state_61633;
var statearr_61702_61769 = state_61633__$1;
(statearr_61702_61769[(2)] = inst_61564);

(statearr_61702_61769[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (42))){
var inst_61518 = (state_61633[(9)]);
var state_61633__$1 = state_61633;
var statearr_61703_61770 = state_61633__$1;
(statearr_61703_61770[(2)] = inst_61518);

(statearr_61703_61770[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (37))){
var inst_61511 = (state_61633[(23)]);
var state_61633__$1 = state_61633;
var statearr_61704_61771 = state_61633__$1;
(statearr_61704_61771[(2)] = inst_61511);

(statearr_61704_61771[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (8))){
var inst_61513 = (state_61633[(16)]);
var inst_61538 = (state_61633[(2)]);
var inst_61539 = sources;
var state_61633__$1 = (function (){var statearr_61705 = state_61633;
(statearr_61705[(29)] = inst_61538);

(statearr_61705[(28)] = inst_61539);

return statearr_61705;
})();
if(cljs.core.truth_(inst_61513)){
var statearr_61706_61772 = state_61633__$1;
(statearr_61706_61772[(1)] = (9));

} else {
var statearr_61707_61773 = state_61633__$1;
(statearr_61707_61773[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61634 === (49))){
var inst_61573 = (state_61633[(24)]);
var inst_61618 = (state_61633[(13)]);
var inst_61613 = (state_61633[(27)]);
var inst_61553 = (state_61633[(11)]);
var inst_61620 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61621 = cljs.core.deref.call(null,inst_61573);
var inst_61622 = fluree.db.api.query.response_time_formatted.call(null,inst_61613);
var inst_61623 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_61553);
var inst_61624 = [(200),inst_61618,inst_61621,inst_61622,inst_61623];
var inst_61625 = cljs.core.PersistentHashMap.fromArrays(inst_61620,inst_61624);
var state_61633__$1 = state_61633;
var statearr_61708_61774 = state_61633__$1;
(statearr_61708_61774[(2)] = inst_61625);

(statearr_61708_61774[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2726__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2726__auto____0 = (function (){
var statearr_61709 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61709[(0)] = fluree$db$api$query$query_async_$_state_machine__2726__auto__);

(statearr_61709[(1)] = (1));

return statearr_61709;
});
var fluree$db$api$query$query_async_$_state_machine__2726__auto____1 = (function (state_61633){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_61633);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e61710){var ex__2729__auto__ = e61710;
var statearr_61711_61775 = state_61633;
(statearr_61711_61775[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_61633[(4)]))){
var statearr_61712_61776 = state_61633;
(statearr_61712_61776[(1)] = cljs.core.first.call(null,(state_61633[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61777 = state_61633;
state_61633 = G__61777;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2726__auto__ = function(state_61633){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2726__auto____1.call(this,state_61633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2726__auto____0;
fluree$db$api$query$query_async_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2726__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_61713 = f__2749__auto__.call(null);
(statearr_61713[(6)] = c__2748__auto__);

return statearr_61713;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_61918){
var state_val_61919 = (state_61918[(1)]);
if((state_val_61919 === (7))){
var inst_61913 = (state_61918[(2)]);
var _ = (function (){var statearr_61920 = state_61918;
(statearr_61920[(4)] = cljs.core.rest.call(null,(state_61918[(4)])));

return statearr_61920;
})();
var state_61918__$1 = state_61918;
var statearr_61921_61997 = state_61918__$1;
(statearr_61921_61997[(2)] = inst_61913);

(statearr_61921_61997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (20))){
var inst_61885 = (state_61918[(2)]);
var state_61918__$1 = state_61918;
var statearr_61922_61998 = state_61918__$1;
(statearr_61922_61998[(2)] = inst_61885);

(statearr_61922_61998[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (27))){
var inst_61865 = (state_61918[(7)]);
var state_61918__$1 = state_61918;
var statearr_61923_61999 = state_61918__$1;
(statearr_61923_61999[(2)] = inst_61865);

(statearr_61923_61999[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (1))){
var state_61918__$1 = state_61918;
var statearr_61924_62000 = state_61918__$1;
(statearr_61924_62000[(2)] = null);

(statearr_61924_62000[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (24))){
var inst_61862 = (state_61918[(8)]);
var state_61918__$1 = state_61918;
var statearr_61925_62001 = state_61918__$1;
(statearr_61925_62001[(2)] = inst_61862);

(statearr_61925_62001[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (39))){
var inst_61852 = (state_61918[(9)]);
var inst_61830 = (state_61918[(10)]);
var inst_61819 = (state_61918[(11)]);
var inst_61896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61897 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_61830];
var inst_61898 = (new cljs.core.PersistentVector(null,2,(5),inst_61896,inst_61897,null));
var inst_61899 = cljs.core.assoc_in.call(null,inst_61819,inst_61898,inst_61852);
var state_61918__$1 = state_61918;
var statearr_61926_62002 = state_61918__$1;
(statearr_61926_62002[(2)] = inst_61899);

(statearr_61926_62002[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (4))){
var inst_61778 = (state_61918[(2)]);
var state_61918__$1 = state_61918;
var statearr_61927_62003 = state_61918__$1;
(statearr_61927_62003[(2)] = inst_61778);

(statearr_61927_62003[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (15))){
var inst_61852 = (state_61918[(9)]);
var inst_61817 = (state_61918[(12)]);
var inst_61855 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_61852);
var inst_61856 = (inst_61817 == null);
var state_61918__$1 = (function (){var statearr_61928 = state_61918;
(statearr_61928[(13)] = inst_61855);

return statearr_61928;
})();
if(cljs.core.truth_(inst_61856)){
var statearr_61929_62004 = state_61918__$1;
(statearr_61929_62004[(1)] = (18));

} else {
var statearr_61930_62005 = state_61918__$1;
(statearr_61930_62005[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (21))){
var inst_61855 = (state_61918[(13)]);
var state_61918__$1 = state_61918;
var statearr_61931_62006 = state_61918__$1;
(statearr_61931_62006[(2)] = inst_61855);

(statearr_61931_62006[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (31))){
var state_61918__$1 = state_61918;
var statearr_61932_62007 = state_61918__$1;
(statearr_61932_62007[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (32))){
var inst_61881 = (state_61918[(2)]);
var state_61918__$1 = state_61918;
var statearr_61934_62008 = state_61918__$1;
(statearr_61934_62008[(2)] = inst_61881);

(statearr_61934_62008[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (40))){
var inst_61850 = (state_61918[(14)]);
var state_61918__$1 = state_61918;
if(cljs.core.truth_(inst_61850)){
var statearr_61935_62009 = state_61918__$1;
(statearr_61935_62009[(1)] = (42));

} else {
var statearr_61936_62010 = state_61918__$1;
(statearr_61936_62010[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (33))){
var inst_61817 = (state_61918[(12)]);
var inst_61855 = (state_61918[(13)]);
var inst_61876 = ((inst_61855 > inst_61817) ? inst_61855 : inst_61817);
var state_61918__$1 = state_61918;
var statearr_61937_62011 = state_61918__$1;
(statearr_61937_62011[(2)] = inst_61876);

(statearr_61937_62011[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (13))){
var inst_61841 = (state_61918[(2)]);
var state_61918__$1 = state_61918;
var statearr_61938_62012 = state_61918__$1;
(statearr_61938_62012[(2)] = inst_61841);

(statearr_61938_62012[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (22))){
var inst_61862 = (state_61918[(8)]);
var inst_61855 = (state_61918[(13)]);
var inst_61862__$1 = cljs.core._EQ_.call(null,(200),inst_61855);
var state_61918__$1 = (function (){var statearr_61939 = state_61918;
(statearr_61939[(8)] = inst_61862__$1);

return statearr_61939;
})();
if(inst_61862__$1){
var statearr_61940_62013 = state_61918__$1;
(statearr_61940_62013[(1)] = (24));

} else {
var statearr_61941_62014 = state_61918__$1;
(statearr_61941_62014[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (36))){
var inst_61852 = (state_61918[(9)]);
var inst_61818 = (state_61918[(15)]);
var inst_61890 = cljs.core.get.call(null,inst_61852,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_61891 = (inst_61818 + inst_61890);
var state_61918__$1 = state_61918;
var statearr_61942_62015 = state_61918__$1;
(statearr_61942_62015[(2)] = inst_61891);

(statearr_61942_62015[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (41))){
var inst_61894 = (state_61918[(16)]);
var inst_61829 = (state_61918[(17)]);
var inst_61888 = (state_61918[(18)]);
var inst_61908 = (state_61918[(2)]);
var inst_61816 = inst_61829;
var inst_61817 = inst_61888;
var inst_61818 = inst_61894;
var inst_61819 = inst_61908;
var state_61918__$1 = (function (){var statearr_61943 = state_61918;
(statearr_61943[(12)] = inst_61817);

(statearr_61943[(19)] = inst_61816);

(statearr_61943[(11)] = inst_61819);

(statearr_61943[(15)] = inst_61818);

return statearr_61943;
})();
var statearr_61944_62016 = state_61918__$1;
(statearr_61944_62016[(2)] = null);

(statearr_61944_62016[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (43))){
var inst_61852 = (state_61918[(9)]);
var state_61918__$1 = state_61918;
var statearr_61945_62017 = state_61918__$1;
(statearr_61945_62017[(2)] = inst_61852);

(statearr_61945_62017[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (29))){
var inst_61870 = (state_61918[(2)]);
var state_61918__$1 = state_61918;
var statearr_61946_62018 = state_61918__$1;
(statearr_61946_62018[(2)] = inst_61870);

(statearr_61946_62018[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (44))){
var inst_61830 = (state_61918[(10)]);
var inst_61819 = (state_61918[(11)]);
var inst_61905 = (state_61918[(2)]);
var inst_61906 = cljs.core.assoc.call(null,inst_61819,inst_61830,inst_61905);
var state_61918__$1 = state_61918;
var statearr_61947_62019 = state_61918__$1;
(statearr_61947_62019[(2)] = inst_61906);

(statearr_61947_62019[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (6))){
var inst_61816 = (state_61918[(19)]);
var inst_61831 = (state_61918[(20)]);
var inst_61827 = cljs.core.seq.call(null,inst_61816);
var inst_61828 = cljs.core.first.call(null,inst_61827);
var inst_61829 = cljs.core.next.call(null,inst_61827);
var inst_61830 = cljs.core.nth.call(null,inst_61828,(0),null);
var inst_61831__$1 = cljs.core.nth.call(null,inst_61828,(1),null);
var inst_61832 = (inst_61831__$1 == null);
var state_61918__$1 = (function (){var statearr_61948 = state_61918;
(statearr_61948[(10)] = inst_61830);

(statearr_61948[(20)] = inst_61831__$1);

(statearr_61948[(17)] = inst_61829);

return statearr_61948;
})();
if(cljs.core.truth_(inst_61832)){
var statearr_61949_62020 = state_61918__$1;
(statearr_61949_62020[(1)] = (8));

} else {
var statearr_61950_62021 = state_61918__$1;
(statearr_61950_62021[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (28))){
var inst_61817 = (state_61918[(12)]);
var inst_61868 = cljs.core._EQ_.call(null,(207),inst_61817);
var state_61918__$1 = state_61918;
var statearr_61951_62022 = state_61918__$1;
(statearr_61951_62022[(2)] = inst_61868);

(statearr_61951_62022[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (25))){
var inst_61817 = (state_61918[(12)]);
var inst_61865 = (state_61918[(7)]);
var inst_61865__$1 = cljs.core._EQ_.call(null,(200),inst_61817);
var state_61918__$1 = (function (){var statearr_61952 = state_61918;
(statearr_61952[(7)] = inst_61865__$1);

return statearr_61952;
})();
if(inst_61865__$1){
var statearr_61953_62023 = state_61918__$1;
(statearr_61953_62023[(1)] = (27));

} else {
var statearr_61954_62024 = state_61918__$1;
(statearr_61954_62024[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (34))){
var state_61918__$1 = state_61918;
var statearr_61955_62025 = state_61918__$1;
(statearr_61955_62025[(2)] = null);

(statearr_61955_62025[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (17))){
var inst_61849 = (state_61918[(21)]);
var inst_61888 = (state_61918[(2)]);
var state_61918__$1 = (function (){var statearr_61956 = state_61918;
(statearr_61956[(18)] = inst_61888);

return statearr_61956;
})();
if(cljs.core.truth_(inst_61849)){
var statearr_61957_62026 = state_61918__$1;
(statearr_61957_62026[(1)] = (36));

} else {
var statearr_61958_62027 = state_61918__$1;
(statearr_61958_62027[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (3))){
var inst_61916 = (state_61918[(2)]);
var state_61918__$1 = state_61918;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_61918__$1,inst_61916);
} else {
if((state_val_61919 === (12))){
var inst_61819 = (state_61918[(11)]);
var state_61918__$1 = state_61918;
var statearr_61959_62028 = state_61918__$1;
(statearr_61959_62028[(2)] = inst_61819);

(statearr_61959_62028[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (2))){
var inst_61792 = (state_61918[(22)]);
var inst_61788 = (state_61918[(23)]);
var inst_61793 = (state_61918[(24)]);
var _ = (function (){var statearr_61960 = state_61918;
(statearr_61960[(4)] = cljs.core.cons.call(null,(5),(state_61918[(4)])));

return statearr_61960;
})();
var inst_61784 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_61785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61786 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_61787 = (new cljs.core.PersistentVector(null,2,(5),inst_61785,inst_61786,null));
var inst_61788__$1 = cljs.core.get_in.call(null,flureeQL,inst_61787);
var inst_61789 = (function (){var global_block = inst_61784;
var global_meta_QMARK_ = inst_61788__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.call(null,query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4223__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4221__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not.call(null,query_meta_QMARK_);
} else {
return and__4221__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.call(null,new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_);
var query_STAR_ = cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return global_block;
}
})());
return cljs.core.assoc.call(null,acc,alias,query_STAR_);
});
})();
var inst_61790 = cljs.core.PersistentHashMap.EMPTY;
var inst_61791 = cljs.core.dissoc.call(null,flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"block","block",664686210));
var inst_61792__$1 = cljs.core.reduce_kv.call(null,inst_61789,inst_61790,inst_61791);
var inst_61793__$1 = fluree.db.util.core.current_time_millis.call(null);
var inst_61795 = (function (){var global_block = inst_61784;
var global_meta_QMARK_ = inst_61788__$1;
var queries = inst_61792__$1;
var start_time = inst_61793__$1;
return (function (p__61794){
var vec__61961 = p__61794;
var alias = cljs.core.nth.call(null,vec__61961,(0),null);
var q = cljs.core.nth.call(null,vec__61961,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,fluree.db.api.query.query.call(null,source,q)], null);
});
})();
var inst_61796 = cljs.core.map.call(null,inst_61795,inst_61792__$1);
var inst_61810 = cljs.core.seq.call(null,inst_61796);
var inst_61811 = cljs.core.first.call(null,inst_61810);
var inst_61812 = cljs.core.next.call(null,inst_61810);
var inst_61813 = cljs.core.nth.call(null,inst_61811,(0),null);
var inst_61814 = cljs.core.nth.call(null,inst_61811,(1),null);
var inst_61815 = cljs.core.PersistentHashMap.EMPTY;
var inst_61816 = inst_61796;
var inst_61817 = null;
var inst_61818 = (0);
var inst_61819 = inst_61815;
var state_61918__$1 = (function (){var statearr_61964 = state_61918;
(statearr_61964[(22)] = inst_61792__$1);

(statearr_61964[(25)] = inst_61814);

(statearr_61964[(12)] = inst_61817);

(statearr_61964[(19)] = inst_61816);

(statearr_61964[(23)] = inst_61788__$1);

(statearr_61964[(11)] = inst_61819);

(statearr_61964[(15)] = inst_61818);

(statearr_61964[(26)] = inst_61812);

(statearr_61964[(24)] = inst_61793__$1);

(statearr_61964[(27)] = inst_61813);

return statearr_61964;
})();
var statearr_61965_62029 = state_61918__$1;
(statearr_61965_62029[(2)] = null);

(statearr_61965_62029[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (23))){
var inst_61883 = (state_61918[(2)]);
var state_61918__$1 = state_61918;
var statearr_61966_62030 = state_61918__$1;
(statearr_61966_62030[(2)] = inst_61883);

(statearr_61966_62030[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (35))){
var inst_61879 = (state_61918[(2)]);
var state_61918__$1 = state_61918;
var statearr_61967_62031 = state_61918__$1;
(statearr_61967_62031[(2)] = inst_61879);

(statearr_61967_62031[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (19))){
var inst_61817 = (state_61918[(12)]);
var inst_61855 = (state_61918[(13)]);
var inst_61859 = cljs.core._EQ_.call(null,inst_61817,inst_61855);
var state_61918__$1 = state_61918;
if(inst_61859){
var statearr_61968_62032 = state_61918__$1;
(statearr_61968_62032[(1)] = (21));

} else {
var statearr_61969_62033 = state_61918__$1;
(statearr_61969_62033[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (11))){
var inst_61817 = (state_61918[(12)]);
var inst_61819 = (state_61918[(11)]);
var inst_61818 = (state_61918[(15)]);
var inst_61793 = (state_61918[(24)]);
var inst_61835 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61836 = fluree.db.api.query.response_time_formatted.call(null,inst_61793);
var inst_61837 = [inst_61819,inst_61818,inst_61817,inst_61836];
var inst_61838 = cljs.core.PersistentHashMap.fromArrays(inst_61835,inst_61837);
var state_61918__$1 = state_61918;
var statearr_61971_62034 = state_61918__$1;
(statearr_61971_62034[(2)] = inst_61838);

(statearr_61971_62034[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (9))){
var inst_61792 = (state_61918[(22)]);
var inst_61830 = (state_61918[(10)]);
var inst_61831 = (state_61918[(20)]);
var inst_61844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61845 = [inst_61830,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_61846 = (new cljs.core.PersistentVector(null,2,(5),inst_61844,inst_61845,null));
var inst_61847 = cljs.core.get_in.call(null,inst_61792,inst_61846);
var inst_61848 = cljs.core.__destructure_map.call(null,inst_61847);
var inst_61849 = cljs.core.get.call(null,inst_61848,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_61850 = cljs.core.get.call(null,inst_61848,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_61918__$1 = (function (){var statearr_61972 = state_61918;
(statearr_61972[(14)] = inst_61850);

(statearr_61972[(21)] = inst_61849);

return statearr_61972;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_61918__$1,(14),inst_61831);
} else {
if((state_val_61919 === (5))){
var _ = (function (){var statearr_61973 = state_61918;
(statearr_61973[(4)] = cljs.core.rest.call(null,(state_61918[(4)])));

return statearr_61973;
})();
var state_61918__$1 = state_61918;
var ex61970 = (state_61918__$1[(2)]);
var statearr_61974_62035 = state_61918__$1;
(statearr_61974_62035[(5)] = ex61970);


var statearr_61975_62036 = state_61918__$1;
(statearr_61975_62036[(1)] = (4));

(statearr_61975_62036[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (14))){
var inst_61852 = (state_61918[(9)]);
var inst_61849 = (state_61918[(21)]);
var inst_61852__$1 = (state_61918[(2)]);
var inst_61853 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_61852__$1);
var state_61918__$1 = (function (){var statearr_61976 = state_61918;
(statearr_61976[(9)] = inst_61852__$1);

(statearr_61976[(28)] = inst_61853);

return statearr_61976;
})();
if(cljs.core.truth_(inst_61849)){
var statearr_61977_62037 = state_61918__$1;
(statearr_61977_62037[(1)] = (15));

} else {
var statearr_61978_62038 = state_61918__$1;
(statearr_61978_62038[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (26))){
var inst_61872 = (state_61918[(2)]);
var state_61918__$1 = state_61918;
if(cljs.core.truth_(inst_61872)){
var statearr_61979_62039 = state_61918__$1;
(statearr_61979_62039[(1)] = (30));

} else {
var statearr_61980_62040 = state_61918__$1;
(statearr_61980_62040[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (16))){
var state_61918__$1 = state_61918;
var statearr_61981_62041 = state_61918__$1;
(statearr_61981_62041[(2)] = null);

(statearr_61981_62041[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (38))){
var inst_61853 = (state_61918[(28)]);
var inst_61894 = (state_61918[(2)]);
var state_61918__$1 = (function (){var statearr_61982 = state_61918;
(statearr_61982[(16)] = inst_61894);

return statearr_61982;
})();
if(cljs.core.truth_(inst_61853)){
var statearr_61983_62042 = state_61918__$1;
(statearr_61983_62042[(1)] = (39));

} else {
var statearr_61984_62043 = state_61918__$1;
(statearr_61984_62043[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (30))){
var state_61918__$1 = state_61918;
var statearr_61985_62044 = state_61918__$1;
(statearr_61985_62044[(2)] = (207));

(statearr_61985_62044[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (10))){
var inst_61911 = (state_61918[(2)]);
var state_61918__$1 = state_61918;
var statearr_61986_62045 = state_61918__$1;
(statearr_61986_62045[(2)] = inst_61911);

(statearr_61986_62045[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (18))){
var inst_61855 = (state_61918[(13)]);
var state_61918__$1 = state_61918;
var statearr_61987_62046 = state_61918__$1;
(statearr_61987_62046[(2)] = inst_61855);

(statearr_61987_62046[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (42))){
var inst_61852 = (state_61918[(9)]);
var inst_61902 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_61852);
var state_61918__$1 = state_61918;
var statearr_61988_62047 = state_61918__$1;
(statearr_61988_62047[(2)] = inst_61902);

(statearr_61988_62047[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (37))){
var state_61918__$1 = state_61918;
var statearr_61989_62048 = state_61918__$1;
(statearr_61989_62048[(2)] = null);

(statearr_61989_62048[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61919 === (8))){
var inst_61788 = (state_61918[(23)]);
var state_61918__$1 = state_61918;
if(cljs.core.truth_(inst_61788)){
var statearr_61990_62049 = state_61918__$1;
(statearr_61990_62049[(1)] = (11));

} else {
var statearr_61991_62050 = state_61918__$1;
(statearr_61991_62050[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2726__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2726__auto____0 = (function (){
var statearr_61992 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61992[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2726__auto__);

(statearr_61992[(1)] = (1));

return statearr_61992;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2726__auto____1 = (function (state_61918){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_61918);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e61993){var ex__2729__auto__ = e61993;
var statearr_61994_62051 = state_61918;
(statearr_61994_62051[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_61918[(4)]))){
var statearr_61995_62052 = state_61918;
(statearr_61995_62052[(1)] = cljs.core.first.call(null,(state_61918[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62053 = state_61918;
state_61918 = G__62053;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2726__auto__ = function(state_61918){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2726__auto____1.call(this,state_61918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2726__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2726__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_61996 = f__2749__auto__.call(null);
(statearr_61996[(6)] = c__2748__auto__);

return statearr_61996;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type.call(null,flureeQL);
var G__62054 = query_type;
var G__62054__$1 = (((G__62054 instanceof cljs.core.Keyword))?G__62054.fqn:null);
switch (G__62054__$1) {
case "standard":
return fluree.db.api.query.query_async.call(null,source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async.call(null,source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async.call(null,conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async.call(null,source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__62054__$1)].join('')));

}
});
