// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__67845 = arguments.length;
switch (G__67845) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5751__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5751__auto__)){
var block = temp__5751__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2748__auto___67884 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_67866){
var state_val_67867 = (state_67866[(1)]);
if((state_val_67867 === (1))){
var state_67866__$1 = state_67866;
var statearr_67868_67885 = state_67866__$1;
(statearr_67868_67885[(2)] = null);

(statearr_67868_67885[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67867 === (2))){
var _ = (function (){var statearr_67869 = state_67866;
(statearr_67869[(4)] = cljs.core.cons.call(null,(5),(state_67866[(4)])));

return statearr_67869;
})();
var inst_67852 = fluree.db.session.db.call(null,conn,ledger,null);
var state_67866__$1 = state_67866;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67866__$1,(7),inst_67852);
} else {
if((state_val_67867 === (3))){
var inst_67862 = (state_67866[(2)]);
var inst_67863 = cljs.core.async.put_BANG_.call(null,pc,inst_67862);
var inst_67864 = cljs.core.async.close_BANG_.call(null,pc);
var state_67866__$1 = (function (){var statearr_67871 = state_67866;
(statearr_67871[(7)] = inst_67863);

return statearr_67871;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67866__$1,inst_67864);
} else {
if((state_val_67867 === (4))){
var inst_67846 = (state_67866[(2)]);
var state_67866__$1 = state_67866;
var statearr_67872_67886 = state_67866__$1;
(statearr_67872_67886[(2)] = inst_67846);

(statearr_67872_67886[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67867 === (5))){
var _ = (function (){var statearr_67873 = state_67866;
(statearr_67873[(4)] = cljs.core.rest.call(null,(state_67866[(4)])));

return statearr_67873;
})();
var state_67866__$1 = state_67866;
var ex67870 = (state_67866__$1[(2)]);
var statearr_67874_67887 = state_67866__$1;
(statearr_67874_67887[(5)] = ex67870);


var statearr_67875_67888 = state_67866__$1;
(statearr_67875_67888[(1)] = (4));

(statearr_67875_67888[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67867 === (6))){
var inst_67858 = (state_67866[(2)]);
var inst_67859 = fluree.db.util.async.throw_err.call(null,inst_67858);
var _ = (function (){var statearr_67876 = state_67866;
(statearr_67876[(4)] = cljs.core.rest.call(null,(state_67866[(4)])));

return statearr_67876;
})();
var state_67866__$1 = state_67866;
var statearr_67877_67889 = state_67866__$1;
(statearr_67877_67889[(2)] = inst_67859);

(statearr_67877_67889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67867 === (7))){
var inst_67854 = (state_67866[(2)]);
var inst_67855 = fluree.db.util.async.throw_err.call(null,inst_67854);
var inst_67856 = fluree.db.time_travel.as_of_block.call(null,inst_67855,block);
var state_67866__$1 = state_67866;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67866__$1,(6),inst_67856);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2726__auto__ = null;
var fluree$db$api$ledger$state_machine__2726__auto____0 = (function (){
var statearr_67878 = [null,null,null,null,null,null,null,null];
(statearr_67878[(0)] = fluree$db$api$ledger$state_machine__2726__auto__);

(statearr_67878[(1)] = (1));

return statearr_67878;
});
var fluree$db$api$ledger$state_machine__2726__auto____1 = (function (state_67866){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_67866);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e67879){var ex__2729__auto__ = e67879;
var statearr_67880_67890 = state_67866;
(statearr_67880_67890[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_67866[(4)]))){
var statearr_67881_67891 = state_67866;
(statearr_67881_67891[(1)] = cljs.core.first.call(null,(state_67866[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67892 = state_67866;
state_67866 = G__67892;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2726__auto__ = function(state_67866){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2726__auto____1.call(this,state_67866);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2726__auto____0;
fluree$db$api$ledger$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2726__auto____1;
return fluree$db$api$ledger$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_67882 = f__2749__auto__.call(null);
(statearr_67882[(6)] = c__2748__auto___67884);

return statearr_67882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Given a db and any time value (block, ISO-8601 time/duration, or t)
 *   will return the underlying ledger's t value as of that time value.
 */
fluree.db.api.ledger.to_t = (function fluree$db$api$ledger$to_t(db,block_or_t_or_time){
return fluree.db.time_travel.to_t.call(null,db,block_or_t_or_time);
});
/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_67933){
var state_val_67934 = (state_67933[(1)]);
if((state_val_67934 === (7))){
var inst_67902 = cljs.core._EQ_.call(null,(0),auth);
var state_67933__$1 = state_67933;
if(inst_67902){
var statearr_67935_67966 = state_67933__$1;
(statearr_67935_67966[(1)] = (9));

} else {
var statearr_67936_67967 = state_67933__$1;
(statearr_67936_67967[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (1))){
var state_67933__$1 = state_67933;
var statearr_67937_67968 = state_67933__$1;
(statearr_67937_67968[(2)] = null);

(statearr_67937_67968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (4))){
var inst_67893 = (state_67933[(2)]);
var state_67933__$1 = state_67933;
var statearr_67938_67969 = state_67933__$1;
(statearr_67938_67969[(2)] = inst_67893);

(statearr_67938_67969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (15))){
var inst_67910 = (state_67933[(7)]);
var inst_67909 = (state_67933[(2)]);
var inst_67910__$1 = fluree.db.util.async.throw_err.call(null,inst_67909);
var state_67933__$1 = (function (){var statearr_67939 = state_67933;
(statearr_67939[(7)] = inst_67910__$1);

return statearr_67939;
})();
if(cljs.core.truth_(inst_67910__$1)){
var statearr_67940_67970 = state_67933__$1;
(statearr_67940_67970[(1)] = (16));

} else {
var statearr_67941_67971 = state_67933__$1;
(statearr_67941_67971[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (13))){
var state_67933__$1 = state_67933;
var statearr_67942_67972 = state_67933__$1;
(statearr_67942_67972[(2)] = null);

(statearr_67942_67972[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (6))){
var state_67933__$1 = state_67933;
var statearr_67943_67973 = state_67933__$1;
(statearr_67943_67973[(2)] = db);

(statearr_67943_67973[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (17))){
var inst_67914 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_67915 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67916 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_67917 = cljs.core.PersistentHashMap.fromArrays(inst_67915,inst_67916);
var inst_67918 = cljs.core.ex_info.call(null,inst_67914,inst_67917);
var inst_67919 = (function(){throw inst_67918})();
var state_67933__$1 = state_67933;
var statearr_67944_67974 = state_67933__$1;
(statearr_67944_67974[(2)] = inst_67919);

(statearr_67944_67974[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (3))){
var inst_67931 = (state_67933[(2)]);
var state_67933__$1 = state_67933;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_67933__$1,inst_67931);
} else {
if((state_val_67934 === (12))){
var inst_67907 = fluree.db.dbproto._subid.call(null,db,auth);
var state_67933__$1 = state_67933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_67933__$1,(15),inst_67907);
} else {
if((state_val_67934 === (2))){
var _ = (function (){var statearr_67945 = state_67933;
(statearr_67945[(4)] = cljs.core.cons.call(null,(5),(state_67933[(4)])));

return statearr_67945;
})();
var inst_67899 = cljs.core.not.call(null,auth);
var state_67933__$1 = state_67933;
if(inst_67899){
var statearr_67946_67975 = state_67933__$1;
(statearr_67946_67975[(1)] = (6));

} else {
var statearr_67947_67976 = state_67933__$1;
(statearr_67947_67976[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (11))){
var inst_67926 = (state_67933[(2)]);
var state_67933__$1 = state_67933;
var statearr_67949_67977 = state_67933__$1;
(statearr_67949_67977[(2)] = inst_67926);

(statearr_67949_67977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (9))){
var inst_67904 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_67933__$1 = state_67933;
var statearr_67950_67978 = state_67933__$1;
(statearr_67950_67978[(2)] = inst_67904);

(statearr_67950_67978[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (5))){
var _ = (function (){var statearr_67951 = state_67933;
(statearr_67951[(4)] = cljs.core.rest.call(null,(state_67933[(4)])));

return statearr_67951;
})();
var state_67933__$1 = state_67933;
var ex67948 = (state_67933__$1[(2)]);
var statearr_67952_67979 = state_67933__$1;
(statearr_67952_67979[(5)] = ex67948);


if((ex67948 instanceof Error)){
var statearr_67953_67980 = state_67933__$1;
(statearr_67953_67980[(1)] = (4));

(statearr_67953_67980[(5)] = null);

} else {
throw ex67948;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (14))){
var inst_67924 = (state_67933[(2)]);
var state_67933__$1 = state_67933;
var statearr_67954_67981 = state_67933__$1;
(statearr_67954_67981[(2)] = inst_67924);

(statearr_67954_67981[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (16))){
var inst_67910 = (state_67933[(7)]);
var inst_67912 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_67910);
var state_67933__$1 = state_67933;
var statearr_67955_67982 = state_67933__$1;
(statearr_67955_67982[(2)] = inst_67912);

(statearr_67955_67982[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (10))){
var state_67933__$1 = state_67933;
var statearr_67956_67983 = state_67933__$1;
(statearr_67956_67983[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (18))){
var inst_67921 = (state_67933[(2)]);
var state_67933__$1 = state_67933;
var statearr_67958_67984 = state_67933__$1;
(statearr_67958_67984[(2)] = inst_67921);

(statearr_67958_67984[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67934 === (8))){
var inst_67928 = (state_67933[(2)]);
var _ = (function (){var statearr_67959 = state_67933;
(statearr_67959[(4)] = cljs.core.rest.call(null,(state_67933[(4)])));

return statearr_67959;
})();
var state_67933__$1 = state_67933;
var statearr_67960_67985 = state_67933__$1;
(statearr_67960_67985[(2)] = inst_67928);

(statearr_67960_67985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2726__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2726__auto____0 = (function (){
var statearr_67961 = [null,null,null,null,null,null,null,null];
(statearr_67961[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2726__auto__);

(statearr_67961[(1)] = (1));

return statearr_67961;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2726__auto____1 = (function (state_67933){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_67933);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e67962){var ex__2729__auto__ = e67962;
var statearr_67963_67986 = state_67933;
(statearr_67963_67986[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_67933[(4)]))){
var statearr_67964_67987 = state_67933;
(statearr_67964_67987[(1)] = cljs.core.first.call(null,(state_67933[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67988 = state_67933;
state_67933 = G__67988;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2726__auto__ = function(state_67933){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2726__auto____1.call(this,state_67933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2726__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2726__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_67965 = f__2749__auto__.call(null);
(statearr_67965[(6)] = c__2748__auto__);

return statearr_67965;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68052){
var state_val_68053 = (state_68052[(1)]);
if((state_val_68053 === (7))){
var inst_67998 = cljs.core._EQ_.call(null,(0),auth);
var state_68052__$1 = state_68052;
if(inst_67998){
var statearr_68054_68103 = state_68052__$1;
(statearr_68054_68103[(1)] = (9));

} else {
var statearr_68055_68104 = state_68052__$1;
(statearr_68055_68104[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (20))){
var inst_68022 = (state_68052[(7)]);
var state_68052__$1 = state_68052;
if(cljs.core.truth_(inst_68022)){
var statearr_68056_68105 = state_68052__$1;
(statearr_68056_68105[(1)] = (22));

} else {
var statearr_68057_68106 = state_68052__$1;
(statearr_68057_68106[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (27))){
var state_68052__$1 = state_68052;
var statearr_68058_68107 = state_68052__$1;
(statearr_68058_68107[(2)] = null);

(statearr_68058_68107[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (1))){
var state_68052__$1 = state_68052;
var statearr_68059_68108 = state_68052__$1;
(statearr_68059_68108[(2)] = null);

(statearr_68059_68108[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (24))){
var inst_68036 = (state_68052[(2)]);
var state_68052__$1 = state_68052;
var statearr_68060_68109 = state_68052__$1;
(statearr_68060_68109[(2)] = inst_68036);

(statearr_68060_68109[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (4))){
var inst_67989 = (state_68052[(2)]);
var state_68052__$1 = state_68052;
var statearr_68061_68110 = state_68052__$1;
(statearr_68061_68110[(2)] = inst_67989);

(statearr_68061_68110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (15))){
var inst_68005 = (state_68052[(8)]);
var inst_68004 = (state_68052[(2)]);
var inst_68005__$1 = fluree.db.util.async.throw_err.call(null,inst_68004);
var state_68052__$1 = (function (){var statearr_68062 = state_68052;
(statearr_68062[(8)] = inst_68005__$1);

return statearr_68062;
})();
if(cljs.core.truth_(inst_68005__$1)){
var statearr_68063_68111 = state_68052__$1;
(statearr_68063_68111[(1)] = (16));

} else {
var statearr_68064_68112 = state_68052__$1;
(statearr_68064_68112[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (21))){
var inst_68038 = (state_68052[(9)]);
var inst_68038__$1 = (state_68052[(2)]);
var state_68052__$1 = (function (){var statearr_68065 = state_68052;
(statearr_68065[(9)] = inst_68038__$1);

return statearr_68065;
})();
if(cljs.core.truth_(inst_68038__$1)){
var statearr_68066_68113 = state_68052__$1;
(statearr_68066_68113[(1)] = (29));

} else {
var statearr_68067_68114 = state_68052__$1;
(statearr_68067_68114[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (31))){
var inst_68038 = (state_68052[(9)]);
var inst_68022 = (state_68052[(7)]);
var inst_68046 = (state_68052[(2)]);
var inst_68047 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_68022,new cljs.core.Keyword(null,"roles","roles",143379530),inst_68038,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_68046);
var _ = (function (){var statearr_68068 = state_68052;
(statearr_68068[(4)] = cljs.core.rest.call(null,(state_68052[(4)])));

return statearr_68068;
})();
var state_68052__$1 = state_68052;
var statearr_68069_68115 = state_68052__$1;
(statearr_68069_68115[(2)] = inst_68047);

(statearr_68069_68115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (32))){
var inst_68042 = (state_68052[(2)]);
var inst_68043 = fluree.db.util.async.throw_err.call(null,inst_68042);
var state_68052__$1 = state_68052;
var statearr_68070_68116 = state_68052__$1;
(statearr_68070_68116[(2)] = inst_68043);

(statearr_68070_68116[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (13))){
var state_68052__$1 = state_68052;
var statearr_68071_68117 = state_68052__$1;
(statearr_68071_68117[(2)] = null);

(statearr_68071_68117[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (22))){
var inst_68022 = (state_68052[(7)]);
var inst_68026 = fluree.db.auth.roles.call(null,db,inst_68022);
var state_68052__$1 = state_68052;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68052__$1,(25),inst_68026);
} else {
if((state_val_68053 === (29))){
var inst_68038 = (state_68052[(9)]);
var inst_68040 = fluree.db.permissions.permission_map.call(null,db,inst_68038,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_68052__$1 = state_68052;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68052__$1,(32),inst_68040);
} else {
if((state_val_68053 === (6))){
var state_68052__$1 = state_68052;
var statearr_68072_68118 = state_68052__$1;
(statearr_68072_68118[(2)] = null);

(statearr_68072_68118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (28))){
var inst_68034 = (state_68052[(2)]);
var state_68052__$1 = state_68052;
var statearr_68073_68119 = state_68052__$1;
(statearr_68073_68119[(2)] = inst_68034);

(statearr_68073_68119[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (25))){
var inst_68028 = (state_68052[(2)]);
var inst_68029 = fluree.db.util.async.throw_err.call(null,inst_68028);
var state_68052__$1 = state_68052;
var statearr_68074_68120 = state_68052__$1;
(statearr_68074_68120[(2)] = inst_68029);

(statearr_68074_68120[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (17))){
var inst_68008 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_68009 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68010 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_68011 = cljs.core.PersistentHashMap.fromArrays(inst_68009,inst_68010);
var inst_68012 = cljs.core.ex_info.call(null,inst_68008,inst_68011);
var inst_68013 = (function(){throw inst_68012})();
var state_68052__$1 = state_68052;
var statearr_68075_68121 = state_68052__$1;
(statearr_68075_68121[(2)] = inst_68013);

(statearr_68075_68121[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (3))){
var inst_68050 = (state_68052[(2)]);
var state_68052__$1 = state_68052;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68052__$1,inst_68050);
} else {
if((state_val_68053 === (12))){
var inst_68002 = fluree.db.dbproto._subid.call(null,db,auth);
var state_68052__$1 = state_68052;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68052__$1,(15),inst_68002);
} else {
if((state_val_68053 === (2))){
var _ = (function (){var statearr_68076 = state_68052;
(statearr_68076[(4)] = cljs.core.cons.call(null,(5),(state_68052[(4)])));

return statearr_68076;
})();
var inst_67995 = (auth == null);
var state_68052__$1 = state_68052;
if(cljs.core.truth_(inst_67995)){
var statearr_68077_68122 = state_68052__$1;
(statearr_68077_68122[(1)] = (6));

} else {
var statearr_68078_68123 = state_68052__$1;
(statearr_68078_68123[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (23))){
var state_68052__$1 = state_68052;
var statearr_68079_68124 = state_68052__$1;
(statearr_68079_68124[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (19))){
var state_68052__$1 = state_68052;
var statearr_68081_68125 = state_68052__$1;
(statearr_68081_68125[(2)] = roles);

(statearr_68081_68125[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (11))){
var inst_68020 = (state_68052[(2)]);
var state_68052__$1 = state_68052;
var statearr_68083_68126 = state_68052__$1;
(statearr_68083_68126[(2)] = inst_68020);

(statearr_68083_68126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (9))){
var state_68052__$1 = state_68052;
var statearr_68084_68127 = state_68052__$1;
(statearr_68084_68127[(2)] = (0));

(statearr_68084_68127[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (5))){
var _ = (function (){var statearr_68085 = state_68052;
(statearr_68085[(4)] = cljs.core.rest.call(null,(state_68052[(4)])));

return statearr_68085;
})();
var state_68052__$1 = state_68052;
var ex68082 = (state_68052__$1[(2)]);
var statearr_68086_68128 = state_68052__$1;
(statearr_68086_68128[(5)] = ex68082);


if((ex68082 instanceof Error)){
var statearr_68087_68129 = state_68052__$1;
(statearr_68087_68129[(1)] = (4));

(statearr_68087_68129[(5)] = null);

} else {
throw ex68082;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (14))){
var inst_68018 = (state_68052[(2)]);
var state_68052__$1 = state_68052;
var statearr_68088_68130 = state_68052__$1;
(statearr_68088_68130[(2)] = inst_68018);

(statearr_68088_68130[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (26))){
var state_68052__$1 = state_68052;
var statearr_68089_68131 = state_68052__$1;
(statearr_68089_68131[(2)] = null);

(statearr_68089_68131[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (16))){
var inst_68005 = (state_68052[(8)]);
var state_68052__$1 = state_68052;
var statearr_68090_68132 = state_68052__$1;
(statearr_68090_68132[(2)] = inst_68005);

(statearr_68090_68132[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (30))){
var state_68052__$1 = state_68052;
var statearr_68091_68133 = state_68052__$1;
(statearr_68091_68133[(2)] = null);

(statearr_68091_68133[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (10))){
var state_68052__$1 = state_68052;
if(cljs.core.truth_(auth)){
var statearr_68092_68134 = state_68052__$1;
(statearr_68092_68134[(1)] = (12));

} else {
var statearr_68093_68135 = state_68052__$1;
(statearr_68093_68135[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (18))){
var inst_68015 = (state_68052[(2)]);
var state_68052__$1 = state_68052;
var statearr_68094_68136 = state_68052__$1;
(statearr_68094_68136[(2)] = inst_68015);

(statearr_68094_68136[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68053 === (8))){
var inst_68022 = (state_68052[(2)]);
var state_68052__$1 = (function (){var statearr_68095 = state_68052;
(statearr_68095[(7)] = inst_68022);

return statearr_68095;
})();
if(cljs.core.truth_(roles)){
var statearr_68096_68137 = state_68052__$1;
(statearr_68096_68137[(1)] = (19));

} else {
var statearr_68097_68138 = state_68052__$1;
(statearr_68097_68138[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2726__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2726__auto____0 = (function (){
var statearr_68098 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68098[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2726__auto__);

(statearr_68098[(1)] = (1));

return statearr_68098;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2726__auto____1 = (function (state_68052){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68052);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68099){var ex__2729__auto__ = e68099;
var statearr_68100_68139 = state_68052;
(statearr_68100_68139[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68052[(4)]))){
var statearr_68101_68140 = state_68052;
(statearr_68101_68140[(1)] = cljs.core.first.call(null,(state_68052[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68141 = state_68052;
state_68052 = G__68141;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2726__auto__ = function(state_68052){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2726__auto____1.call(this,state_68052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2726__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2726__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68102 = f__2749__auto__.call(null);
(statearr_68102[(6)] = c__2748__auto__);

return statearr_68102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__68142 = db;
var map__68142__$1 = cljs.core.__destructure_map.call(null,map__68142);
var conn = cljs.core.get.call(null,map__68142__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__68142__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__68142__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.call(null,"NEW EVENT:",cljs.core.pr_str.call(null,evt),cljs.core.pr_str.call(null,data));

if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);

var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68149){
var state_val_68150 = (state_68149[(1)]);
if((state_val_68150 === (1))){
var inst_68143 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_68144 = fluree.db.session.db.call(null,conn,inst_68143,null);
var state_68149__$1 = state_68149;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68149__$1,(2),inst_68144);
} else {
if((state_val_68150 === (2))){
var inst_68146 = (state_68149[(2)]);
var inst_68147 = cljs.core.async.put_BANG_.call(null,resp_port,inst_68146);
var state_68149__$1 = state_68149;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68149__$1,inst_68147);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto____0 = (function (){
var statearr_68151 = [null,null,null,null,null,null,null];
(statearr_68151[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto__);

(statearr_68151[(1)] = (1));

return statearr_68151;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto____1 = (function (state_68149){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68149);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68152){var ex__2729__auto__ = e68152;
var statearr_68153_68180 = state_68149;
(statearr_68153_68180[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68149[(4)]))){
var statearr_68154_68181 = state_68149;
(statearr_68154_68181[(1)] = cljs.core.first.call(null,(state_68149[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68182 = state_68149;
state_68149 = G__68182;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto__ = function(state_68149){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto____1.call(this,state_68149);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68155 = f__2749__auto__.call(null);
(statearr_68155[(6)] = c__2748__auto__);

return statearr_68155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,dbid,listen_id,event_fn);

var c__2748__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68168){
var state_val_68169 = (state_68168[(1)]);
if((state_val_68169 === (1))){
var inst_68156 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_68157 = fluree.db.session.db.call(null,conn,inst_68156,null);
var state_68168__$1 = state_68168;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68168__$1,(2),inst_68157);
} else {
if((state_val_68169 === (2))){
var inst_68159 = (state_68168[(7)]);
var inst_68159__$1 = (state_68168[(2)]);
var inst_68160 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_68159__$1);
var inst_68161 = newer_block_QMARK_.call(null,inst_68160);
var state_68168__$1 = (function (){var statearr_68170 = state_68168;
(statearr_68170[(7)] = inst_68159__$1);

return statearr_68170;
})();
if(inst_68161){
var statearr_68171_68183 = state_68168__$1;
(statearr_68171_68183[(1)] = (3));

} else {
var statearr_68172_68184 = state_68168__$1;
(statearr_68172_68184[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68169 === (3))){
var inst_68159 = (state_68168[(7)]);
var inst_68163 = cljs.core.async.put_BANG_.call(null,resp_port,inst_68159);
var state_68168__$1 = state_68168;
var statearr_68173_68185 = state_68168__$1;
(statearr_68173_68185[(2)] = inst_68163);

(statearr_68173_68185[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68169 === (4))){
var state_68168__$1 = state_68168;
var statearr_68174_68186 = state_68168__$1;
(statearr_68174_68186[(2)] = null);

(statearr_68174_68186[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68169 === (5))){
var inst_68166 = (state_68168[(2)]);
var state_68168__$1 = state_68168;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68168__$1,inst_68166);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto____0 = (function (){
var statearr_68175 = [null,null,null,null,null,null,null,null];
(statearr_68175[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto__);

(statearr_68175[(1)] = (1));

return statearr_68175;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto____1 = (function (state_68168){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68168);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68176){var ex__2729__auto__ = e68176;
var statearr_68177_68187 = state_68168;
(statearr_68177_68187[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68168[(4)]))){
var statearr_68178_68188 = state_68168;
(statearr_68178_68188[(1)] = cljs.core.first.call(null,(state_68168[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68189 = state_68168;
state_68168 = G__68189;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto__ = function(state_68168){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto____1.call(this,state_68168);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68179 = f__2749__auto__.call(null);
(statearr_68179[(6)] = c__2748__auto__);

return statearr_68179;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

return c__2748__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__68190 = db;
var map__68190__$1 = cljs.core.__destructure_map.call(null,map__68190);
var conn = cljs.core.get.call(null,map__68190__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__68190__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__68190__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__4309__auto__ = syncTimeout;
var y__4310__auto__ = (120000);
return ((x__4309__auto__ < y__4310__auto__) ? x__4309__auto__ : y__4310__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2748__auto___68266 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68240){
var state_val_68241 = (state_68240[(1)]);
if((state_val_68241 === (7))){
var inst_68206 = (state_68240[(7)]);
var inst_68217 = cljs.core._EQ_.call(null,inst_68206,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_68240__$1 = state_68240;
if(inst_68217){
var statearr_68242_68267 = state_68240__$1;
(statearr_68242_68267[(1)] = (9));

} else {
var statearr_68243_68268 = state_68240__$1;
(statearr_68243_68268[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68241 === (1))){
var inst_68191 = (state_68240[(8)]);
var inst_68199 = (state_68240[(9)]);
var inst_68191__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_68199__$1 = res_port;
var inst_68200 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68201 = [inst_68191__$1,inst_68199__$1];
var inst_68202 = (new cljs.core.PersistentVector(null,2,(5),inst_68200,inst_68201,null));
var state_68240__$1 = (function (){var statearr_68244 = state_68240;
(statearr_68244[(8)] = inst_68191__$1);

(statearr_68244[(9)] = inst_68199__$1);

return statearr_68244;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_68240__$1,(2),inst_68202);
} else {
if((state_val_68241 === (4))){
var inst_68206 = (state_68240[(7)]);
var inst_68199 = (state_68240[(9)]);
var inst_68210 = cljs.core._EQ_.call(null,inst_68206,inst_68199);
var state_68240__$1 = state_68240;
if(inst_68210){
var statearr_68245_68269 = state_68240__$1;
(statearr_68245_68269[(1)] = (6));

} else {
var statearr_68246_68270 = state_68240__$1;
(statearr_68246_68270[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68241 === (13))){
var inst_68225 = (state_68240[(10)]);
var inst_68236 = cljs.core.async.put_BANG_.call(null,pc,inst_68225);
var state_68240__$1 = state_68240;
var statearr_68247_68271 = state_68240__$1;
(statearr_68247_68271[(2)] = inst_68236);

(statearr_68247_68271[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68241 === (6))){
var inst_68204 = (state_68240[(11)]);
var inst_68215 = cljs.core.nth.call(null,inst_68204,(0),null);
var state_68240__$1 = state_68240;
var statearr_68248_68272 = state_68240__$1;
(statearr_68248_68272[(2)] = inst_68215);

(statearr_68248_68272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68241 === (3))){
var state_68240__$1 = state_68240;
var statearr_68249_68273 = state_68240__$1;
(statearr_68249_68273[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_68249_68273[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68241 === (12))){
var inst_68229 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_68230 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68231 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_68232 = cljs.core.PersistentHashMap.fromArrays(inst_68230,inst_68231);
var inst_68233 = cljs.core.ex_info.call(null,inst_68229,inst_68232);
var inst_68234 = cljs.core.async.put_BANG_.call(null,pc,inst_68233);
var state_68240__$1 = state_68240;
var statearr_68250_68274 = state_68240__$1;
(statearr_68250_68274[(2)] = inst_68234);

(statearr_68250_68274[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68241 === (2))){
var inst_68206 = (state_68240[(7)]);
var inst_68191 = (state_68240[(8)]);
var inst_68204 = (state_68240[(11)]);
var inst_68204__$1 = (state_68240[(2)]);
var inst_68205 = cljs.core.nth.call(null,inst_68204__$1,(0),null);
var inst_68206__$1 = cljs.core.nth.call(null,inst_68204__$1,(1),null);
var inst_68207 = cljs.core._EQ_.call(null,inst_68206__$1,inst_68191);
var state_68240__$1 = (function (){var statearr_68251 = state_68240;
(statearr_68251[(7)] = inst_68206__$1);

(statearr_68251[(12)] = inst_68205);

(statearr_68251[(11)] = inst_68204__$1);

return statearr_68251;
})();
if(inst_68207){
var statearr_68252_68275 = state_68240__$1;
(statearr_68252_68275[(1)] = (3));

} else {
var statearr_68253_68276 = state_68240__$1;
(statearr_68253_68276[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68241 === (11))){
var inst_68221 = (state_68240[(2)]);
var state_68240__$1 = state_68240;
var statearr_68254_68277 = state_68240__$1;
(statearr_68254_68277[(2)] = inst_68221);

(statearr_68254_68277[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68241 === (9))){
var inst_68205 = (state_68240[(12)]);
var state_68240__$1 = state_68240;
var statearr_68255_68278 = state_68240__$1;
(statearr_68255_68278[(2)] = inst_68205);

(statearr_68255_68278[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68241 === (5))){
var inst_68225 = (state_68240[(10)]);
var inst_68225__$1 = (state_68240[(2)]);
var inst_68226 = fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);
var inst_68227 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_68225__$1);
var state_68240__$1 = (function (){var statearr_68256 = state_68240;
(statearr_68256[(10)] = inst_68225__$1);

(statearr_68256[(13)] = inst_68226);

return statearr_68256;
})();
if(inst_68227){
var statearr_68257_68279 = state_68240__$1;
(statearr_68257_68279[(1)] = (12));

} else {
var statearr_68258_68280 = state_68240__$1;
(statearr_68258_68280[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68241 === (14))){
var inst_68238 = (state_68240[(2)]);
var state_68240__$1 = state_68240;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68240__$1,inst_68238);
} else {
if((state_val_68241 === (10))){
var state_68240__$1 = state_68240;
var statearr_68259_68281 = state_68240__$1;
(statearr_68259_68281[(2)] = null);

(statearr_68259_68281[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68241 === (8))){
var inst_68223 = (state_68240[(2)]);
var state_68240__$1 = state_68240;
var statearr_68260_68282 = state_68240__$1;
(statearr_68260_68282[(2)] = inst_68223);

(statearr_68260_68282[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2726__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2726__auto____0 = (function (){
var statearr_68261 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68261[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2726__auto__);

(statearr_68261[(1)] = (1));

return statearr_68261;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2726__auto____1 = (function (state_68240){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68240);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68262){var ex__2729__auto__ = e68262;
var statearr_68263_68283 = state_68240;
(statearr_68263_68283[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68240[(4)]))){
var statearr_68264_68284 = state_68240;
(statearr_68264_68284[(1)] = cljs.core.first.call(null,(state_68240[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68285 = state_68240;
state_68240 = G__68285;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2726__auto__ = function(state_68240){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2726__auto____1.call(this,state_68240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2726__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2726__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68265 = f__2749__auto__.call(null);
(statearr_68265[(6)] = c__2748__auto___68266);

return statearr_68265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__68287 = arguments.length;
switch (G__68287) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__68288){
var map__68289 = p__68288;
var map__68289__$1 = cljs.core.__destructure_map.call(null,map__68289);
var opts = map__68289__$1;
var roles = cljs.core.get.call(null,map__68289__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__68289__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__68289__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__68289__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__68289__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var opts_SINGLEQUOTE_ = (((cljs.core._STAR_target_STAR_ === "nodejs"))?opts:null);
var c__2748__auto___68378 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2749__auto__ = (function (){var switch__2725__auto__ = (function (state_68340){
var state_val_68341 = (state_68340[(1)]);
if((state_val_68341 === (7))){
var inst_68302 = (state_68340[(7)]);
var inst_68304 = fluree.db.api.ledger.syncTo_db.call(null,inst_68302,syncTo,syncTimeout);
var state_68340__$1 = state_68340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68340__$1,(10),inst_68304);
} else {
if((state_val_68341 === (20))){
var inst_68326 = (state_68340[(8)]);
var state_68340__$1 = state_68340;
var statearr_68342_68379 = state_68340__$1;
(statearr_68342_68379[(2)] = inst_68326);

(statearr_68342_68379[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (1))){
var state_68340__$1 = state_68340;
var statearr_68343_68380 = state_68340__$1;
(statearr_68343_68380[(2)] = null);

(statearr_68343_68380[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (4))){
var inst_68290 = (state_68340[(2)]);
var inst_68291 = cljs.core.async.put_BANG_.call(null,pc,inst_68290);
var inst_68292 = cljs.core.async.close_BANG_.call(null,pc);
var state_68340__$1 = (function (){var statearr_68344 = state_68340;
(statearr_68344[(9)] = inst_68291);

return statearr_68344;
})();
var statearr_68345_68381 = state_68340__$1;
(statearr_68345_68381[(2)] = inst_68292);

(statearr_68345_68381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (15))){
var inst_68318 = (state_68340[(10)]);
var inst_68320 = fluree.db.api.ledger.add_db_permissions.call(null,inst_68318,auth,roles);
var state_68340__$1 = state_68340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68340__$1,(18),inst_68320);
} else {
if((state_val_68341 === (21))){
var inst_68334 = (state_68340[(2)]);
var inst_68335 = cljs.core.async.put_BANG_.call(null,pc,inst_68334);
var _ = (function (){var statearr_68346 = state_68340;
(statearr_68346[(4)] = cljs.core.rest.call(null,(state_68340[(4)])));

return statearr_68346;
})();
var state_68340__$1 = state_68340;
var statearr_68347_68382 = state_68340__$1;
(statearr_68347_68382[(2)] = inst_68335);

(statearr_68347_68382[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (13))){
var inst_68318 = (state_68340[(2)]);
var state_68340__$1 = (function (){var statearr_68348 = state_68340;
(statearr_68348[(10)] = inst_68318);

return statearr_68348;
})();
if(cljs.core.truth_(roles)){
var statearr_68349_68383 = state_68340__$1;
(statearr_68349_68383[(1)] = (15));

} else {
var statearr_68350_68384 = state_68340__$1;
(statearr_68350_68384[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (22))){
var inst_68330 = (state_68340[(2)]);
var inst_68331 = fluree.db.util.async.throw_err.call(null,inst_68330);
var state_68340__$1 = state_68340;
var statearr_68351_68385 = state_68340__$1;
(statearr_68351_68385[(2)] = inst_68331);

(statearr_68351_68385[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (6))){
var inst_68301 = (state_68340[(2)]);
var inst_68302 = fluree.db.util.async.throw_err.call(null,inst_68301);
var state_68340__$1 = (function (){var statearr_68352 = state_68340;
(statearr_68352[(7)] = inst_68302);

return statearr_68352;
})();
if(cljs.core.truth_(syncTo)){
var statearr_68353_68386 = state_68340__$1;
(statearr_68353_68386[(1)] = (7));

} else {
var statearr_68354_68387 = state_68340__$1;
(statearr_68354_68387[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (17))){
var inst_68326 = (state_68340[(2)]);
var state_68340__$1 = (function (){var statearr_68355 = state_68340;
(statearr_68355[(8)] = inst_68326);

return statearr_68355;
})();
if(cljs.core.truth_(auth)){
var statearr_68356_68388 = state_68340__$1;
(statearr_68356_68388[(1)] = (19));

} else {
var statearr_68357_68389 = state_68340__$1;
(statearr_68357_68389[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (3))){
var inst_68338 = (state_68340[(2)]);
var state_68340__$1 = state_68340;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68340__$1,inst_68338);
} else {
if((state_val_68341 === (12))){
var inst_68310 = (state_68340[(11)]);
var state_68340__$1 = state_68340;
var statearr_68358_68390 = state_68340__$1;
(statearr_68358_68390[(2)] = inst_68310);

(statearr_68358_68390[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (2))){
var _ = (function (){var statearr_68359 = state_68340;
(statearr_68359[(4)] = cljs.core.cons.call(null,(5),(state_68340[(4)])));

return statearr_68359;
})();
var inst_68299 = fluree.db.session.db.call(null,conn,ledger,opts_SINGLEQUOTE_);
var state_68340__$1 = state_68340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68340__$1,(6),inst_68299);
} else {
if((state_val_68341 === (19))){
var inst_68326 = (state_68340[(8)]);
var inst_68328 = fluree.db.api.ledger.add_db_permissions.call(null,inst_68326,auth,roles);
var state_68340__$1 = state_68340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68340__$1,(22),inst_68328);
} else {
if((state_val_68341 === (11))){
var inst_68310 = (state_68340[(11)]);
var inst_68312 = fluree.db.time_travel.as_of_block.call(null,inst_68310,block);
var state_68340__$1 = state_68340;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68340__$1,(14),inst_68312);
} else {
if((state_val_68341 === (9))){
var inst_68310 = (state_68340[(2)]);
var state_68340__$1 = (function (){var statearr_68361 = state_68340;
(statearr_68361[(11)] = inst_68310);

return statearr_68361;
})();
if(cljs.core.truth_(block)){
var statearr_68362_68391 = state_68340__$1;
(statearr_68362_68391[(1)] = (11));

} else {
var statearr_68363_68392 = state_68340__$1;
(statearr_68363_68392[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (5))){
var _ = (function (){var statearr_68364 = state_68340;
(statearr_68364[(4)] = cljs.core.rest.call(null,(state_68340[(4)])));

return statearr_68364;
})();
var state_68340__$1 = state_68340;
var ex68360 = (state_68340__$1[(2)]);
var statearr_68365_68393 = state_68340__$1;
(statearr_68365_68393[(5)] = ex68360);


var statearr_68366_68394 = state_68340__$1;
(statearr_68366_68394[(1)] = (4));

(statearr_68366_68394[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (14))){
var inst_68314 = (state_68340[(2)]);
var inst_68315 = fluree.db.util.async.throw_err.call(null,inst_68314);
var state_68340__$1 = state_68340;
var statearr_68367_68395 = state_68340__$1;
(statearr_68367_68395[(2)] = inst_68315);

(statearr_68367_68395[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (16))){
var inst_68318 = (state_68340[(10)]);
var state_68340__$1 = state_68340;
var statearr_68368_68396 = state_68340__$1;
(statearr_68368_68396[(2)] = inst_68318);

(statearr_68368_68396[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (10))){
var inst_68306 = (state_68340[(2)]);
var inst_68307 = fluree.db.util.async.throw_err.call(null,inst_68306);
var state_68340__$1 = state_68340;
var statearr_68369_68397 = state_68340__$1;
(statearr_68369_68397[(2)] = inst_68307);

(statearr_68369_68397[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (18))){
var inst_68322 = (state_68340[(2)]);
var inst_68323 = fluree.db.util.async.throw_err.call(null,inst_68322);
var state_68340__$1 = state_68340;
var statearr_68370_68398 = state_68340__$1;
(statearr_68370_68398[(2)] = inst_68323);

(statearr_68370_68398[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68341 === (8))){
var inst_68302 = (state_68340[(7)]);
var state_68340__$1 = state_68340;
var statearr_68371_68399 = state_68340__$1;
(statearr_68371_68399[(2)] = inst_68302);

(statearr_68371_68399[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2726__auto__ = null;
var fluree$db$api$ledger$state_machine__2726__auto____0 = (function (){
var statearr_68372 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_68372[(0)] = fluree$db$api$ledger$state_machine__2726__auto__);

(statearr_68372[(1)] = (1));

return statearr_68372;
});
var fluree$db$api$ledger$state_machine__2726__auto____1 = (function (state_68340){
while(true){
var ret_value__2727__auto__ = (function (){try{while(true){
var result__2728__auto__ = switch__2725__auto__.call(null,state_68340);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2728__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2728__auto__;
}
break;
}
}catch (e68373){var ex__2729__auto__ = e68373;
var statearr_68374_68400 = state_68340;
(statearr_68374_68400[(2)] = ex__2729__auto__);


if(cljs.core.seq.call(null,(state_68340[(4)]))){
var statearr_68375_68401 = state_68340;
(statearr_68375_68401[(1)] = cljs.core.first.call(null,(state_68340[(4)])));

} else {
throw ex__2729__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2727__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68402 = state_68340;
state_68340 = G__68402;
continue;
} else {
return ret_value__2727__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2726__auto__ = function(state_68340){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2726__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2726__auto____1.call(this,state_68340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2726__auto____0;
fluree$db$api$ledger$state_machine__2726__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2726__auto____1;
return fluree$db$api$ledger$state_machine__2726__auto__;
})()
})();
var state__2750__auto__ = (function (){var statearr_68376 = f__2749__auto__.call(null);
(statearr_68376[(6)] = c__2748__auto___68378);

return statearr_68376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2750__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

