// Compiled by ClojureScript 1.10.866 {:target :nodejs, :nodejs-rt true, :optimizations :simple}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('alphabase.core');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('fluree.crypto.pkcs7');
fluree.crypto.aes.encrypt_STAR_ = (function fluree$crypto$aes$encrypt_STAR_(iv,key_ba,ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var padded = fluree.crypto.pkcs7.encode.call(null,(16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js.call(null,iv));
});
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__4835__auto__ = [];
var len__4829__auto___72253 = arguments.length;
var i__4830__auto___72254 = (0);
while(true){
if((i__4830__auto___72254 < len__4829__auto___72253)){
args__4835__auto__.push((arguments[i__4830__auto___72254]));

var G__72255 = (i__4830__auto___72254 + (1));
i__4830__auto___72254 = G__72255;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

(fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__72247){
var vec__72248 = p__72247;
var map__72251 = cljs.core.nth.call(null,vec__72248,(0),null);
var map__72251__$1 = cljs.core.__destructure_map.call(null,map__72251);
var iv = cljs.core.get.call(null,map__72251__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.call(null,map__72251__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"hex","hex",41691346));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key.call(null,key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes.call(null,x):x);
var encrypted = fluree.crypto.aes.encrypt_STAR_.call(null,iv,key_ba,ba);
var G__72252 = cljs.core.keyword.call(null,output_format);
var G__72252__$1 = (((G__72252 instanceof cljs.core.Keyword))?G__72252.fqn:null);
switch (G__72252__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex.call(null,encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64.call(null,encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__72252__$1)].join('')));

}
}));

(fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq72244){
var G__72245 = cljs.core.first.call(null,seq72244);
var seq72244__$1 = cljs.core.next.call(null,seq72244);
var G__72246 = cljs.core.first.call(null,seq72244__$1);
var seq72244__$2 = cljs.core.next.call(null,seq72244__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72245,G__72246,seq72244__$2);
}));

fluree.crypto.aes.decrypt_STAR_ = (function fluree$crypto$aes$decrypt_STAR_(iv,key_ba,x_ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
return fluree.crypto.pkcs7.decode.call(null,(16),cbc.decrypt(x_ba,cljs.core.clj__GT_js.call(null,iv)));
});
/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__4835__auto__ = [];
var len__4829__auto___72268 = arguments.length;
var i__4830__auto___72269 = (0);
while(true){
if((i__4830__auto___72269 < len__4829__auto___72268)){
args__4835__auto__.push((arguments[i__4830__auto___72269]));

var G__72270 = (i__4830__auto___72269 + (1));
i__4830__auto___72269 = G__72270;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

(fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__72261){
var vec__72262 = p__72261;
var map__72265 = cljs.core.nth.call(null,vec__72262,(0),null);
var map__72265__$1 = cljs.core.__destructure_map.call(null,map__72265);
var iv = cljs.core.get.call(null,map__72265__$1,new cljs.core.Keyword(null,"iv","iv",-1550102132),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.call(null,map__72265__$1,new cljs.core.Keyword(null,"input-format","input-format",-422703481),new cljs.core.Keyword(null,"hex","hex",41691346));
var output_format = cljs.core.get.call(null,map__72265__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"string","string",-1989541586));
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key.call(null,key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__72266 = cljs.core.keyword.call(null,input_format);
var G__72266__$1 = (((G__72266 instanceof cljs.core.Keyword))?G__72266.fqn:null);
switch (G__72266__$1) {
case "hex":
return alphabase.core.hex__GT_bytes.call(null,x);

break;
case "base64":
return alphabase.core.base64__GT_bytes.call(null,x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__72266__$1)].join('')));

}
})():x);
var decrypt_ba = fluree.crypto.aes.decrypt_STAR_.call(null,iv,key_ba,x_ba);
var G__72267 = cljs.core.keyword.call(null,output_format);
var G__72267__$1 = (((G__72267 instanceof cljs.core.Keyword))?G__72267.fqn:null);
switch (G__72267__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex.call(null,decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string.call(null,decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__72267__$1)].join('')));

}
}));

(fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq72258){
var G__72259 = cljs.core.first.call(null,seq72258);
var seq72258__$1 = cljs.core.next.call(null,seq72258);
var G__72260 = cljs.core.first.call(null,seq72258__$1);
var seq72258__$2 = cljs.core.next.call(null,seq72258__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72259,G__72260,seq72258__$2);
}));

