// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__22344 = arguments.length;
switch (G__22344) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__22346 = null;
var G__22346__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22346__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22346__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + fuel_per));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__22346 = function(result,flake){
switch(arguments.length){
case 0:
return G__22346__0.call(this);
case 1:
return G__22346__1.call(this,result);
case 2:
return G__22346__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22346.cljs$core$IFn$_invoke$arity$0 = G__22346__0;
G__22346.cljs$core$IFn$_invoke$arity$1 = G__22346__1;
G__22346.cljs$core$IFn$_invoke$arity$2 = G__22346__2;
return G__22346;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22347 = null;
var G__22347__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22347__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22347__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__22347 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22347__0.call(this);
case 1:
return G__22347__1.call(this,result);
case 2:
return G__22347__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22347.cljs$core$IFn$_invoke$arity$0 = G__22347__0;
G__22347.cljs$core$IFn$_invoke$arity$1 = G__22347__1;
G__22347.cljs$core$IFn$_invoke$arity$2 = G__22347__2;
return G__22347;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__22349 = res;
var G__22349__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__22348_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__22348_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22349):G__22349);
var G__22349__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__22349__$1):G__22349__$1);
var G__22349__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__22349__$2):G__22349__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__22349__$3);
} else {
return G__22349__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22351 = arguments.length;
switch (G__22351) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_22650){
var state_val_22651 = (state_22650[(1)]);
if((state_val_22651 === (65))){
var inst_22391 = (state_22650[(7)]);
var inst_22508 = (state_22650[(8)]);
var inst_22501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22502 = cljs.core.deref(cache);
var inst_22503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22504 = flake.o;
var inst_22505 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22391);
var inst_22506 = [inst_22504,inst_22505];
var inst_22507 = (new cljs.core.PersistentVector(null,2,(5),inst_22503,inst_22506,null));
var inst_22508__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22502,inst_22507);
var state_22650__$1 = (function (){var statearr_22652 = state_22650;
(statearr_22652[(8)] = inst_22508__$1);

(statearr_22652[(9)] = inst_22501);

return statearr_22652;
})();
if(cljs.core.truth_(inst_22508__$1)){
var statearr_22653_22822 = state_22650__$1;
(statearr_22653_22822[(1)] = (68));

} else {
var statearr_22654_22823 = state_22650__$1;
(statearr_22654_22823[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (70))){
var inst_22501 = (state_22650[(9)]);
var inst_22526 = (state_22650[(2)]);
var inst_22527 = [inst_22526,offset_map];
var inst_22528 = (new cljs.core.PersistentVector(null,2,(5),inst_22501,inst_22527,null));
var state_22650__$1 = state_22650;
var statearr_22655_22824 = state_22650__$1;
(statearr_22655_22824[(2)] = inst_22528);

(statearr_22655_22824[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (62))){
var inst_22406 = (state_22650[(10)]);
var inst_22403 = (state_22650[(11)]);
var inst_22408 = (state_22650[(12)]);
var inst_22362 = (state_22650[(13)]);
var inst_22486 = (state_22650[(14)]);
var inst_22391 = (state_22650[(7)]);
var inst_22405 = (state_22650[(15)]);
var inst_22376 = (state_22650[(16)]);
var inst_22409 = (state_22650[(17)]);
var inst_22407 = (state_22650[(18)]);
var inst_22470 = (state_22650[(19)]);
var inst_22402 = (state_22650[(20)]);
var inst_22404 = (state_22650[(21)]);
var inst_22488 = (function (){var p = inst_22409;
var pred_spec__$1 = inst_22376;
var orderBy = inst_22407;
var nested_select_spec = inst_22470;
var multi_QMARK_ = inst_22404;
var limit = inst_22406;
var offset = inst_22408;
var k = inst_22402;
var compact_QMARK_ = inst_22362;
var pred_spec_SINGLEQUOTE_ = inst_22391;
var G__22472 = inst_22486;
var ref_QMARK_ = inst_22405;
var map__22358 = inst_22403;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_22489 = (inst_22488.cljs$core$IFn$_invoke$arity$1 ? inst_22488.cljs$core$IFn$_invoke$arity$1(inst_22486) : inst_22488.call(null,inst_22486));
var state_22650__$1 = state_22650;
var statearr_22656_22825 = state_22650__$1;
(statearr_22656_22825[(2)] = inst_22489);

(statearr_22656_22825[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (74))){
var inst_22535 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
if(cljs.core.truth_(inst_22535)){
var statearr_22657_22826 = state_22650__$1;
(statearr_22657_22826[(1)] = (75));

} else {
var statearr_22658_22827 = state_22650__$1;
(statearr_22658_22827[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (7))){
var inst_22363 = (state_22650[(22)]);
var state_22650__$1 = state_22650;
var statearr_22659_22828 = state_22650__$1;
(statearr_22659_22828[(2)] = inst_22363);

(statearr_22659_22828[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (59))){
var inst_22480 = (state_22650[(23)]);
var inst_22482 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_22483 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_22482,inst_22480);
var state_22650__$1 = state_22650;
var statearr_22660_22829 = state_22650__$1;
(statearr_22660_22829[(2)] = inst_22483);

(statearr_22660_22829[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (86))){
var inst_22406 = (state_22650[(10)]);
var inst_22403 = (state_22650[(11)]);
var inst_22408 = (state_22650[(12)]);
var inst_22362 = (state_22650[(13)]);
var inst_22391 = (state_22650[(7)]);
var inst_22405 = (state_22650[(15)]);
var inst_22376 = (state_22650[(16)]);
var inst_22566 = (state_22650[(24)]);
var inst_22409 = (state_22650[(17)]);
var inst_22407 = (state_22650[(18)]);
var inst_22402 = (state_22650[(20)]);
var inst_22404 = (state_22650[(21)]);
var inst_22548 = (state_22650[(25)]);
var inst_22568 = (function (){var p = inst_22409;
var pred_spec__$1 = inst_22376;
var orderBy = inst_22407;
var children = inst_22548;
var multi_QMARK_ = inst_22404;
var limit = inst_22406;
var offset = inst_22408;
var k = inst_22402;
var compact_QMARK_ = inst_22362;
var pred_spec_SINGLEQUOTE_ = inst_22391;
var G__22560 = inst_22566;
var ref_QMARK_ = inst_22405;
var map__22358 = inst_22403;
return (function (n){
var G__22661 = db;
var G__22662 = cache;
var G__22663 = fuel;
var G__22664 = max_fuel;
var G__22665 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),true,new cljs.core.Keyword(null,"compact?","compact?",1216893298),compact_QMARK_], null);
var G__22666 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__22661,G__22662,G__22663,G__22664,G__22665,G__22666) : fluree.db.query.fql.flakes__GT_res.call(null,G__22661,G__22662,G__22663,G__22664,G__22665,G__22666));
});
})();
var inst_22569 = (inst_22568.cljs$core$IFn$_invoke$arity$1 ? inst_22568.cljs$core$IFn$_invoke$arity$1(inst_22566) : inst_22568.call(null,inst_22566));
var state_22650__$1 = state_22650;
var statearr_22667_22830 = state_22650__$1;
(statearr_22667_22830[(2)] = inst_22569);

(statearr_22667_22830[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (20))){
var inst_22403 = (state_22650[(11)]);
var inst_22391 = (state_22650[(7)]);
var inst_22404 = (state_22650[(21)]);
var inst_22402 = (state_22650[(2)]);
var inst_22403__$1 = cljs.core.__destructure_map(inst_22391);
var inst_22404__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22403__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22405 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22403__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22406 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22403__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22407 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22403__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22408 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22403__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22409 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22403__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22650__$1 = (function (){var statearr_22668 = state_22650;
(statearr_22668[(10)] = inst_22406);

(statearr_22668[(11)] = inst_22403__$1);

(statearr_22668[(12)] = inst_22408);

(statearr_22668[(15)] = inst_22405);

(statearr_22668[(17)] = inst_22409);

(statearr_22668[(18)] = inst_22407);

(statearr_22668[(20)] = inst_22402);

(statearr_22668[(21)] = inst_22404__$1);

return statearr_22668;
})();
if(cljs.core.truth_(inst_22404__$1)){
var statearr_22669_22831 = state_22650__$1;
(statearr_22669_22831[(1)] = (24));

} else {
var statearr_22670_22832 = state_22650__$1;
(statearr_22670_22832[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (72))){
var inst_22391 = (state_22650[(7)]);
var inst_22532 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22391);
var state_22650__$1 = state_22650;
var statearr_22671_22833 = state_22650__$1;
(statearr_22671_22833[(2)] = inst_22532);

(statearr_22671_22833[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (58))){
var inst_22479 = (state_22650[(2)]);
var inst_22480 = fluree.db.util.async.throw_err(inst_22479);
var state_22650__$1 = (function (){var statearr_22672 = state_22650;
(statearr_22672[(23)] = inst_22480);

return statearr_22672;
})();
if(cljs.core.truth_(fuel)){
var statearr_22673_22834 = state_22650__$1;
(statearr_22673_22834[(1)] = (59));

} else {
var statearr_22674_22835 = state_22650__$1;
(statearr_22674_22835[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (60))){
var inst_22480 = (state_22650[(23)]);
var state_22650__$1 = state_22650;
var statearr_22675_22836 = state_22650__$1;
(statearr_22675_22836[(2)] = inst_22480);

(statearr_22675_22836[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (27))){
var inst_22412 = (state_22650[(26)]);
var inst_22408 = (state_22650[(12)]);
var inst_22412__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22408);
var state_22650__$1 = (function (){var statearr_22676 = state_22650;
(statearr_22676[(26)] = inst_22412__$1);

return statearr_22676;
})();
if(inst_22412__$1){
var statearr_22677_22837 = state_22650__$1;
(statearr_22677_22837[(1)] = (30));

} else {
var statearr_22678_22838 = state_22650__$1;
(statearr_22678_22838[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (1))){
var state_22650__$1 = state_22650;
var statearr_22679_22839 = state_22650__$1;
(statearr_22679_22839[(2)] = null);

(statearr_22679_22839[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (69))){
var inst_22391 = (state_22650[(7)]);
var inst_22511 = flake.o;
var inst_22512 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22391);
var inst_22513 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_22511,inst_22512);
var state_22650__$1 = state_22650;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22650__$1,(71),inst_22513);
} else {
if((state_val_22651 === (101))){
var inst_22611 = (state_22650[(27)]);
var inst_22610 = (state_22650[(28)]);
var inst_22402 = (state_22650[(20)]);
var inst_22630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22631 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22402,inst_22610);
var inst_22632 = [inst_22631,inst_22611];
var inst_22633 = (new cljs.core.PersistentVector(null,2,(5),inst_22630,inst_22632,null));
var state_22650__$1 = state_22650;
var statearr_22680_22840 = state_22650__$1;
(statearr_22680_22840[(2)] = inst_22633);

(statearr_22680_22840[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (24))){
var inst_22408 = (state_22650[(12)]);
var state_22650__$1 = state_22650;
if(cljs.core.truth_(inst_22408)){
var statearr_22681_22841 = state_22650__$1;
(statearr_22681_22841[(1)] = (27));

} else {
var statearr_22682_22842 = state_22650__$1;
(statearr_22682_22842[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (102))){
var state_22650__$1 = state_22650;
var statearr_22683_22843 = state_22650__$1;
(statearr_22683_22843[(1)] = (104));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (55))){
var inst_22391 = (state_22650[(7)]);
var inst_22499 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22391);
var state_22650__$1 = state_22650;
if(cljs.core.truth_(inst_22499)){
var statearr_22685_22844 = state_22650__$1;
(statearr_22685_22844[(1)] = (65));

} else {
var statearr_22686_22845 = state_22650__$1;
(statearr_22686_22845[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (85))){
var inst_22566 = (state_22650[(2)]);
var state_22650__$1 = (function (){var statearr_22687 = state_22650;
(statearr_22687[(24)] = inst_22566);

return statearr_22687;
})();
var statearr_22688_22846 = state_22650__$1;
(statearr_22688_22846[(1)] = (86));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (39))){
var inst_22439 = (state_22650[(29)]);
var inst_22407 = (state_22650[(18)]);
var inst_22439__$1 = cljs.core.not(inst_22407);
var state_22650__$1 = (function (){var statearr_22690 = state_22650;
(statearr_22690[(29)] = inst_22439__$1);

return statearr_22690;
})();
if(inst_22439__$1){
var statearr_22691_22847 = state_22650__$1;
(statearr_22691_22847[(1)] = (42));

} else {
var statearr_22692_22848 = state_22650__$1;
(statearr_22692_22848[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (88))){
var inst_22572 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22650__$1,(82),inst_22572);
} else {
if((state_val_22651 === (46))){
var inst_22455 = (state_22650[(30)]);
var inst_22455__$1 = cljs.core.not(recur_QMARK_);
var state_22650__$1 = (function (){var statearr_22693 = state_22650;
(statearr_22693[(30)] = inst_22455__$1);

return statearr_22693;
})();
if(inst_22455__$1){
var statearr_22694_22849 = state_22650__$1;
(statearr_22694_22849[(1)] = (48));

} else {
var statearr_22695_22850 = state_22650__$1;
(statearr_22695_22850[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (4))){
var inst_22352 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22696_22851 = state_22650__$1;
(statearr_22696_22851[(2)] = inst_22352);

(statearr_22696_22851[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (77))){
var inst_22601 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22697_22852 = state_22650__$1;
(statearr_22697_22852[(2)] = inst_22601);

(statearr_22697_22852[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (106))){
var inst_22641 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22698_22853 = state_22650__$1;
(statearr_22698_22853[(2)] = inst_22641);

(statearr_22698_22853[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (95))){
var inst_22404 = (state_22650[(21)]);
var state_22650__$1 = state_22650;
var statearr_22699_22854 = state_22650__$1;
(statearr_22699_22854[(2)] = inst_22404);

(statearr_22699_22854[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (54))){
var inst_22391 = (state_22650[(7)]);
var inst_22467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22468 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22469 = (new cljs.core.PersistentVector(null,3,(5),inst_22467,inst_22468,null));
var inst_22470 = cljs.core.select_keys(inst_22391,inst_22469);
var inst_22471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22474 = flake.o;
var inst_22475 = [inst_22474];
var inst_22476 = (new cljs.core.PersistentVector(null,1,(5),inst_22473,inst_22475,null));
var inst_22477 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22476);
var state_22650__$1 = (function (){var statearr_22700 = state_22650;
(statearr_22700[(31)] = inst_22471);

(statearr_22700[(19)] = inst_22470);

return statearr_22700;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22650__$1,(58),inst_22477);
} else {
if((state_val_22651 === (92))){
var inst_22591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22592 = flake.o;
var inst_22593 = [inst_22592,offset_map];
var inst_22594 = (new cljs.core.PersistentVector(null,2,(5),inst_22591,inst_22593,null));
var state_22650__$1 = state_22650;
var statearr_22701_22855 = state_22650__$1;
(statearr_22701_22855[(2)] = inst_22594);

(statearr_22701_22855[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (104))){
var inst_22611 = (state_22650[(27)]);
var inst_22636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22637 = [acc,inst_22611];
var inst_22638 = (new cljs.core.PersistentVector(null,2,(5),inst_22636,inst_22637,null));
var state_22650__$1 = state_22650;
var statearr_22702_22856 = state_22650__$1;
(statearr_22702_22856[(2)] = inst_22638);

(statearr_22702_22856[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (15))){
var inst_22384 = (state_22650[(32)]);
var inst_22362 = (state_22650[(13)]);
var inst_22388 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22384,new cljs.core.Keyword(null,"compact?","compact?",1216893298),inst_22362);
var state_22650__$1 = state_22650;
var statearr_22703_22857 = state_22650__$1;
(statearr_22703_22857[(2)] = inst_22388);

(statearr_22703_22857[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (48))){
var inst_22391 = (state_22650[(7)]);
var inst_22457 = (state_22650[(33)]);
var inst_22457__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22391);
var state_22650__$1 = (function (){var statearr_22704 = state_22650;
(statearr_22704[(33)] = inst_22457__$1);

return statearr_22704;
})();
if(cljs.core.truth_(inst_22457__$1)){
var statearr_22705_22858 = state_22650__$1;
(statearr_22705_22858[(1)] = (51));

} else {
var statearr_22706_22859 = state_22650__$1;
(statearr_22706_22859[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (50))){
var inst_22465 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
if(cljs.core.truth_(inst_22465)){
var statearr_22707_22860 = state_22650__$1;
(statearr_22707_22860[(1)] = (54));

} else {
var statearr_22708_22861 = state_22650__$1;
(statearr_22708_22861[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (75))){
var inst_22391 = (state_22650[(7)]);
var inst_22537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22538 = flake.o;
var inst_22539 = [inst_22538];
var inst_22540 = (new cljs.core.PersistentVector(null,1,(5),inst_22537,inst_22539,null));
var inst_22541 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22542 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22391);
var inst_22543 = [inst_22542];
var inst_22544 = cljs.core.PersistentHashMap.fromArrays(inst_22541,inst_22543);
var inst_22545 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22540,inst_22544);
var state_22650__$1 = state_22650;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22650__$1,(78),inst_22545);
} else {
if((state_val_22651 === (99))){
var inst_22610 = (state_22650[(28)]);
var inst_22627 = (inst_22610 == null);
var inst_22628 = cljs.core.not(inst_22627);
var state_22650__$1 = state_22650;
if(inst_22628){
var statearr_22709_22862 = state_22650__$1;
(statearr_22709_22862[(1)] = (101));

} else {
var statearr_22710_22863 = state_22650__$1;
(statearr_22710_22863[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (21))){
var inst_22395 = (state_22650[(34)]);
var state_22650__$1 = state_22650;
var statearr_22711_22864 = state_22650__$1;
(statearr_22711_22864[(2)] = inst_22395);

(statearr_22711_22864[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (31))){
var inst_22412 = (state_22650[(26)]);
var state_22650__$1 = state_22650;
var statearr_22712_22865 = state_22650__$1;
(statearr_22712_22865[(2)] = inst_22412);

(statearr_22712_22865[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (32))){
var inst_22418 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22713_22866 = state_22650__$1;
(statearr_22713_22866[(2)] = inst_22418);

(statearr_22713_22866[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (40))){
var inst_22404 = (state_22650[(21)]);
var state_22650__$1 = state_22650;
var statearr_22714_22867 = state_22650__$1;
(statearr_22714_22867[(2)] = inst_22404);

(statearr_22714_22867[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (91))){
var inst_22599 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22715_22868 = state_22650__$1;
(statearr_22715_22868[(2)] = inst_22599);

(statearr_22715_22868[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (56))){
var inst_22605 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22716_22869 = state_22650__$1;
(statearr_22716_22869[(2)] = inst_22605);

(statearr_22716_22869[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (33))){
var inst_22409 = (state_22650[(17)]);
var inst_22426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22427 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22409);
var state_22650__$1 = (function (){var statearr_22717 = state_22650;
(statearr_22717[(35)] = inst_22426);

return statearr_22717;
})();
if(cljs.core.truth_(inst_22427)){
var statearr_22718_22870 = state_22650__$1;
(statearr_22718_22870[(1)] = (36));

} else {
var statearr_22719_22871 = state_22650__$1;
(statearr_22719_22871[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (13))){
var inst_22376 = (state_22650[(16)]);
var state_22650__$1 = state_22650;
var statearr_22720_22872 = state_22650__$1;
(statearr_22720_22872[(2)] = inst_22376);

(statearr_22720_22872[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (22))){
var inst_22391 = (state_22650[(7)]);
var inst_22398 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22391);
var state_22650__$1 = state_22650;
var statearr_22721_22873 = state_22650__$1;
(statearr_22721_22873[(2)] = inst_22398);

(statearr_22721_22873[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (90))){
var state_22650__$1 = state_22650;
var statearr_22722_22874 = state_22650__$1;
(statearr_22722_22874[(1)] = (92));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (36))){
var inst_22409 = (state_22650[(17)]);
var inst_22429 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22409,cljs.core.dec);
var state_22650__$1 = state_22650;
var statearr_22724_22875 = state_22650__$1;
(statearr_22724_22875[(2)] = inst_22429);

(statearr_22724_22875[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (41))){
var inst_22449 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
if(cljs.core.truth_(inst_22449)){
var statearr_22725_22876 = state_22650__$1;
(statearr_22725_22876[(1)] = (45));

} else {
var statearr_22726_22877 = state_22650__$1;
(statearr_22726_22877[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (89))){
var inst_22582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22583 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22584 = flake.o;
var inst_22585 = [inst_22584];
var inst_22586 = cljs.core.PersistentHashMap.fromArrays(inst_22583,inst_22585);
var inst_22587 = [inst_22586,offset_map];
var inst_22588 = (new cljs.core.PersistentVector(null,2,(5),inst_22582,inst_22587,null));
var state_22650__$1 = state_22650;
var statearr_22727_22878 = state_22650__$1;
(statearr_22727_22878[(2)] = inst_22588);

(statearr_22727_22878[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (100))){
var inst_22645 = (state_22650[(2)]);
var _ = (function (){var statearr_22728 = state_22650;
(statearr_22728[(4)] = cljs.core.rest((state_22650[(4)])));

return statearr_22728;
})();
var state_22650__$1 = state_22650;
var statearr_22729_22879 = state_22650__$1;
(statearr_22729_22879[(2)] = inst_22645);

(statearr_22729_22879[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (43))){
var inst_22439 = (state_22650[(29)]);
var state_22650__$1 = state_22650;
var statearr_22730_22880 = state_22650__$1;
(statearr_22730_22880[(2)] = inst_22439);

(statearr_22730_22880[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (61))){
var inst_22486 = (state_22650[(2)]);
var state_22650__$1 = (function (){var statearr_22731 = state_22650;
(statearr_22731[(14)] = inst_22486);

return statearr_22731;
})();
var statearr_22732_22881 = state_22650__$1;
(statearr_22732_22881[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (29))){
var inst_22421 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22734_22882 = state_22650__$1;
(statearr_22734_22882[(2)] = inst_22421);

(statearr_22734_22882[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (44))){
var inst_22446 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22735_22883 = state_22650__$1;
(statearr_22735_22883[(2)] = inst_22446);

(statearr_22735_22883[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (93))){
var state_22650__$1 = state_22650;
var statearr_22736_22884 = state_22650__$1;
(statearr_22736_22884[(2)] = null);

(statearr_22736_22884[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (6))){
var inst_22365 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22366 = (inst_22365 == null);
var state_22650__$1 = state_22650;
var statearr_22737_22885 = state_22650__$1;
(statearr_22737_22885[(2)] = inst_22366);

(statearr_22737_22885[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (28))){
var inst_22408 = (state_22650[(12)]);
var state_22650__$1 = state_22650;
var statearr_22738_22886 = state_22650__$1;
(statearr_22738_22886[(2)] = inst_22408);

(statearr_22738_22886[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (64))){
var inst_22492 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22650__$1,(57),inst_22492);
} else {
if((state_val_22651 === (103))){
var inst_22643 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22739_22887 = state_22650__$1;
(statearr_22739_22887[(2)] = inst_22643);

(statearr_22739_22887[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (51))){
var inst_22457 = (state_22650[(33)]);
var state_22650__$1 = state_22650;
var statearr_22740_22888 = state_22650__$1;
(statearr_22740_22888[(2)] = inst_22457);

(statearr_22740_22888[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (25))){
var inst_22404 = (state_22650[(21)]);
var state_22650__$1 = state_22650;
var statearr_22741_22889 = state_22650__$1;
(statearr_22741_22889[(2)] = inst_22404);

(statearr_22741_22889[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (34))){
var inst_22404 = (state_22650[(21)]);
var state_22650__$1 = state_22650;
if(cljs.core.truth_(inst_22404)){
var statearr_22742_22890 = state_22650__$1;
(statearr_22742_22890[(1)] = (39));

} else {
var statearr_22743_22891 = state_22650__$1;
(statearr_22743_22891[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (17))){
var inst_22392 = (state_22650[(36)]);
var inst_22391 = (state_22650[(7)]);
var inst_22391__$1 = (state_22650[(2)]);
var inst_22392__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22391__$1);
var state_22650__$1 = (function (){var statearr_22744 = state_22650;
(statearr_22744[(36)] = inst_22392__$1);

(statearr_22744[(7)] = inst_22391__$1);

return statearr_22744;
})();
if(cljs.core.truth_(inst_22392__$1)){
var statearr_22745_22892 = state_22650__$1;
(statearr_22745_22892[(1)] = (18));

} else {
var statearr_22746_22893 = state_22650__$1;
(statearr_22746_22893[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (3))){
var inst_22648 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22650__$1,inst_22648);
} else {
if((state_val_22651 === (12))){
var inst_22376 = (state_22650[(16)]);
var inst_22381 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22376,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22650__$1 = state_22650;
var statearr_22747_22894 = state_22650__$1;
(statearr_22747_22894[(2)] = inst_22381);

(statearr_22747_22894[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (2))){
var inst_22363 = (state_22650[(22)]);
var _ = (function (){var statearr_22748 = state_22650;
(statearr_22748[(4)] = cljs.core.cons((5),(state_22650[(4)])));

return statearr_22748;
})();
var inst_22362 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22363__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22650__$1 = (function (){var statearr_22749 = state_22650;
(statearr_22749[(22)] = inst_22363__$1);

(statearr_22749[(13)] = inst_22362);

return statearr_22749;
})();
if(cljs.core.truth_(inst_22363__$1)){
var statearr_22750_22895 = state_22650__$1;
(statearr_22750_22895[(1)] = (6));

} else {
var statearr_22751_22896 = state_22650__$1;
(statearr_22751_22896[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (66))){
var inst_22530 = (state_22650[(37)]);
var inst_22530__$1 = componentFollow_QMARK_;
var state_22650__$1 = (function (){var statearr_22752 = state_22650;
(statearr_22752[(37)] = inst_22530__$1);

return statearr_22752;
})();
if(cljs.core.truth_(inst_22530__$1)){
var statearr_22753_22897 = state_22650__$1;
(statearr_22753_22897[(1)] = (72));

} else {
var statearr_22754_22898 = state_22650__$1;
(statearr_22754_22898[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (23))){
var inst_22400 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22755_22899 = state_22650__$1;
(statearr_22755_22899[(2)] = inst_22400);

(statearr_22755_22899[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (47))){
var inst_22607 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22756_22900 = state_22650__$1;
(statearr_22756_22900[(2)] = inst_22607);

(statearr_22756_22900[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (35))){
var inst_22610 = (state_22650[(28)]);
var inst_22613 = (state_22650[(38)]);
var inst_22609 = (state_22650[(2)]);
var inst_22610__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22609,(0),null);
var inst_22611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22609,(1),null);
var inst_22612 = (inst_22610__$1 == null);
var inst_22613__$1 = cljs.core.not(inst_22612);
var state_22650__$1 = (function (){var statearr_22757 = state_22650;
(statearr_22757[(27)] = inst_22611);

(statearr_22757[(28)] = inst_22610__$1);

(statearr_22757[(38)] = inst_22613__$1);

return statearr_22757;
})();
if(inst_22613__$1){
var statearr_22758_22901 = state_22650__$1;
(statearr_22758_22901[(1)] = (95));

} else {
var statearr_22759_22902 = state_22650__$1;
(statearr_22759_22902[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (82))){
var inst_22559 = (state_22650[(39)]);
var inst_22574 = (state_22650[(2)]);
var inst_22575 = fluree.db.util.async.throw_err(inst_22574);
var inst_22576 = [inst_22575,offset_map];
var inst_22577 = (new cljs.core.PersistentVector(null,2,(5),inst_22559,inst_22576,null));
var state_22650__$1 = state_22650;
var statearr_22760_22903 = state_22650__$1;
(statearr_22760_22903[(2)] = inst_22577);

(statearr_22760_22903[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (76))){
var inst_22405 = (state_22650[(15)]);
var state_22650__$1 = state_22650;
if(cljs.core.truth_(inst_22405)){
var statearr_22761_22904 = state_22650__$1;
(statearr_22761_22904[(1)] = (89));

} else {
var statearr_22762_22905 = state_22650__$1;
(statearr_22762_22905[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (97))){
var inst_22617 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
if(cljs.core.truth_(inst_22617)){
var statearr_22763_22906 = state_22650__$1;
(statearr_22763_22906[(1)] = (98));

} else {
var statearr_22764_22907 = state_22650__$1;
(statearr_22764_22907[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (19))){
var inst_22391 = (state_22650[(7)]);
var inst_22395 = (state_22650[(34)]);
var inst_22395__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22391);
var state_22650__$1 = (function (){var statearr_22765 = state_22650;
(statearr_22765[(34)] = inst_22395__$1);

return statearr_22765;
})();
if(cljs.core.truth_(inst_22395__$1)){
var statearr_22766_22908 = state_22650__$1;
(statearr_22766_22908[(1)] = (21));

} else {
var statearr_22767_22909 = state_22650__$1;
(statearr_22767_22909[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (57))){
var inst_22471 = (state_22650[(31)]);
var inst_22494 = (state_22650[(2)]);
var inst_22495 = fluree.db.util.async.throw_err(inst_22494);
var inst_22496 = [inst_22495,offset_map];
var inst_22497 = (new cljs.core.PersistentVector(null,2,(5),inst_22471,inst_22496,null));
var state_22650__$1 = state_22650;
var statearr_22768_22910 = state_22650__$1;
(statearr_22768_22910[(2)] = inst_22497);

(statearr_22768_22910[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (68))){
var inst_22508 = (state_22650[(8)]);
var state_22650__$1 = state_22650;
var statearr_22769_22911 = state_22650__$1;
(statearr_22769_22911[(2)] = inst_22508);

(statearr_22769_22911[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (11))){
var inst_22376 = (state_22650[(16)]);
var inst_22376__$1 = (state_22650[(2)]);
var inst_22378 = cljs.core.contains_QMARK_(inst_22376__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var inst_22379 = (!(inst_22378));
var state_22650__$1 = (function (){var statearr_22771 = state_22650;
(statearr_22771[(16)] = inst_22376__$1);

return statearr_22771;
})();
if(inst_22379){
var statearr_22772_22912 = state_22650__$1;
(statearr_22772_22912[(1)] = (12));

} else {
var statearr_22773_22913 = state_22650__$1;
(statearr_22773_22913[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (9))){
var inst_22371 = flake.p;
var inst_22372 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22373 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_22371,inst_22372);
var state_22650__$1 = state_22650;
var statearr_22774_22914 = state_22650__$1;
(statearr_22774_22914[(2)] = inst_22373);

(statearr_22774_22914[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (5))){
var _ = (function (){var statearr_22775 = state_22650;
(statearr_22775[(4)] = cljs.core.rest((state_22650[(4)])));

return statearr_22775;
})();
var state_22650__$1 = state_22650;
var ex22770 = (state_22650__$1[(2)]);
var statearr_22776_22915 = state_22650__$1;
(statearr_22776_22915[(5)] = ex22770);


if((ex22770 instanceof Error)){
var statearr_22777_22916 = state_22650__$1;
(statearr_22777_22916[(1)] = (4));

(statearr_22777_22916[(5)] = null);

} else {
throw ex22770;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (83))){
var inst_22548 = (state_22650[(25)]);
var inst_22562 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_22563 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_22562,inst_22548);
var state_22650__$1 = state_22650;
var statearr_22778_22917 = state_22650__$1;
(statearr_22778_22917[(2)] = inst_22563);

(statearr_22778_22917[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (14))){
var inst_22376 = (state_22650[(16)]);
var inst_22384 = (state_22650[(2)]);
var inst_22385 = cljs.core.contains_QMARK_(inst_22376,new cljs.core.Keyword(null,"compact?","compact?",1216893298));
var inst_22386 = (!(inst_22385));
var state_22650__$1 = (function (){var statearr_22779 = state_22650;
(statearr_22779[(32)] = inst_22384);

return statearr_22779;
})();
if(inst_22386){
var statearr_22780_22918 = state_22650__$1;
(statearr_22780_22918[(1)] = (15));

} else {
var statearr_22781_22919 = state_22650__$1;
(statearr_22781_22919[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (45))){
var inst_22451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22452 = [null,offset_map];
var inst_22453 = (new cljs.core.PersistentVector(null,2,(5),inst_22451,inst_22452,null));
var state_22650__$1 = state_22650;
var statearr_22782_22920 = state_22650__$1;
(statearr_22782_22920[(2)] = inst_22453);

(statearr_22782_22920[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (53))){
var inst_22462 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22783_22921 = state_22650__$1;
(statearr_22783_22921[(2)] = inst_22462);

(statearr_22783_22921[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (78))){
var inst_22548 = (state_22650[(25)]);
var inst_22547 = (state_22650[(2)]);
var inst_22548__$1 = fluree.db.util.async.throw_err(inst_22547);
var inst_22549 = cljs.core.empty_QMARK_(inst_22548__$1);
var state_22650__$1 = (function (){var statearr_22784 = state_22650;
(statearr_22784[(25)] = inst_22548__$1);

return statearr_22784;
})();
if(inst_22549){
var statearr_22785_22922 = state_22650__$1;
(statearr_22785_22922[(1)] = (79));

} else {
var statearr_22786_22923 = state_22650__$1;
(statearr_22786_22923[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (26))){
var inst_22424 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
if(cljs.core.truth_(inst_22424)){
var statearr_22787_22924 = state_22650__$1;
(statearr_22787_22924[(1)] = (33));

} else {
var statearr_22788_22925 = state_22650__$1;
(statearr_22788_22925[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (16))){
var inst_22384 = (state_22650[(32)]);
var state_22650__$1 = state_22650;
var statearr_22789_22926 = state_22650__$1;
(statearr_22789_22926[(2)] = inst_22384);

(statearr_22789_22926[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (81))){
var inst_22579 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22790_22927 = state_22650__$1;
(statearr_22790_22927[(2)] = inst_22579);

(statearr_22790_22927[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (79))){
var inst_22551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22552 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_22553 = flake.o;
var inst_22554 = [inst_22553];
var inst_22555 = cljs.core.PersistentHashMap.fromArrays(inst_22552,inst_22554);
var inst_22556 = [inst_22555,offset_map];
var inst_22557 = (new cljs.core.PersistentVector(null,2,(5),inst_22551,inst_22556,null));
var state_22650__$1 = state_22650;
var statearr_22791_22928 = state_22650__$1;
(statearr_22791_22928[(2)] = inst_22557);

(statearr_22791_22928[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (38))){
var inst_22426 = (state_22650[(35)]);
var inst_22434 = (state_22650[(2)]);
var inst_22435 = [null,inst_22434];
var inst_22436 = (new cljs.core.PersistentVector(null,2,(5),inst_22426,inst_22435,null));
var state_22650__$1 = state_22650;
var statearr_22792_22929 = state_22650__$1;
(statearr_22792_22929[(2)] = inst_22436);

(statearr_22792_22929[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (98))){
var inst_22611 = (state_22650[(27)]);
var inst_22610 = (state_22650[(28)]);
var inst_22402 = (state_22650[(20)]);
var inst_22619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22620 = cljs.core.PersistentVector.EMPTY;
var inst_22621 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_22402,inst_22620);
var inst_22622 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22621,inst_22610);
var inst_22623 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22402,inst_22622);
var inst_22624 = [inst_22623,inst_22611];
var inst_22625 = (new cljs.core.PersistentVector(null,2,(5),inst_22619,inst_22624,null));
var state_22650__$1 = state_22650;
var statearr_22793_22930 = state_22650__$1;
(statearr_22793_22930[(2)] = inst_22625);

(statearr_22793_22930[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (87))){
var inst_22566 = (state_22650[(24)]);
var state_22650__$1 = state_22650;
var statearr_22794_22931 = state_22650__$1;
(statearr_22794_22931[(2)] = inst_22566);

(statearr_22794_22931[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (30))){
var inst_22409 = (state_22650[(17)]);
var inst_22414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22409);
var inst_22415 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22414);
var state_22650__$1 = state_22650;
var statearr_22795_22932 = state_22650__$1;
(statearr_22795_22932[(2)] = inst_22415);

(statearr_22795_22932[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (73))){
var inst_22530 = (state_22650[(37)]);
var state_22650__$1 = state_22650;
var statearr_22796_22933 = state_22650__$1;
(statearr_22796_22933[(2)] = inst_22530);

(statearr_22796_22933[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (96))){
var inst_22613 = (state_22650[(38)]);
var state_22650__$1 = state_22650;
var statearr_22797_22934 = state_22650__$1;
(statearr_22797_22934[(2)] = inst_22613);

(statearr_22797_22934[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (10))){
var state_22650__$1 = state_22650;
var statearr_22798_22935 = state_22650__$1;
(statearr_22798_22935[(2)] = pred_spec);

(statearr_22798_22935[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (18))){
var inst_22392 = (state_22650[(36)]);
var state_22650__$1 = state_22650;
var statearr_22799_22936 = state_22650__$1;
(statearr_22799_22936[(2)] = inst_22392);

(statearr_22799_22936[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (105))){
var state_22650__$1 = state_22650;
var statearr_22800_22937 = state_22650__$1;
(statearr_22800_22937[(2)] = null);

(statearr_22800_22937[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (52))){
var inst_22391 = (state_22650[(7)]);
var inst_22460 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22391);
var state_22650__$1 = state_22650;
var statearr_22801_22938 = state_22650__$1;
(statearr_22801_22938[(2)] = inst_22460);

(statearr_22801_22938[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (67))){
var inst_22603 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22802_22939 = state_22650__$1;
(statearr_22802_22939[(2)] = inst_22603);

(statearr_22802_22939[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (71))){
var inst_22391 = (state_22650[(7)]);
var inst_22515 = (state_22650[(2)]);
var inst_22516 = fluree.db.util.async.throw_err(inst_22515);
var inst_22517 = cljs.core._deref(cache);
var inst_22518 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22519 = flake.o;
var inst_22520 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22391);
var inst_22521 = [inst_22519,inst_22520];
var inst_22522 = (new cljs.core.PersistentVector(null,2,(5),inst_22518,inst_22521,null));
var inst_22523 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22517,inst_22522,inst_22516);
var inst_22524 = cljs.core._vreset_BANG_(cache,inst_22523);
var state_22650__$1 = (function (){var statearr_22803 = state_22650;
(statearr_22803[(40)] = inst_22524);

return statearr_22803;
})();
var statearr_22804_22940 = state_22650__$1;
(statearr_22804_22940[(2)] = inst_22516);

(statearr_22804_22940[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (42))){
var inst_22406 = (state_22650[(10)]);
var inst_22402 = (state_22650[(20)]);
var inst_22441 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_22402);
var inst_22442 = cljs.core.count(inst_22441);
var inst_22443 = (inst_22442 >= inst_22406);
var state_22650__$1 = state_22650;
var statearr_22805_22941 = state_22650__$1;
(statearr_22805_22941[(2)] = inst_22443);

(statearr_22805_22941[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (80))){
var inst_22559 = cljs.core.PersistentVector.EMPTY_NODE;
var state_22650__$1 = (function (){var statearr_22806 = state_22650;
(statearr_22806[(39)] = inst_22559);

return statearr_22806;
})();
if(cljs.core.truth_(fuel)){
var statearr_22807_22942 = state_22650__$1;
(statearr_22807_22942[(1)] = (83));

} else {
var statearr_22808_22943 = state_22650__$1;
(statearr_22808_22943[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (37))){
var inst_22408 = (state_22650[(12)]);
var inst_22409 = (state_22650[(17)]);
var inst_22431 = (inst_22408 - (1));
var inst_22432 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22409,inst_22431);
var state_22650__$1 = state_22650;
var statearr_22809_22944 = state_22650__$1;
(statearr_22809_22944[(2)] = inst_22432);

(statearr_22809_22944[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (63))){
var inst_22486 = (state_22650[(14)]);
var state_22650__$1 = state_22650;
var statearr_22810_22945 = state_22650__$1;
(statearr_22810_22945[(2)] = inst_22486);

(statearr_22810_22945[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (94))){
var inst_22597 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
var statearr_22811_22946 = state_22650__$1;
(statearr_22811_22946[(2)] = inst_22597);

(statearr_22811_22946[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (8))){
var inst_22369 = (state_22650[(2)]);
var state_22650__$1 = state_22650;
if(cljs.core.truth_(inst_22369)){
var statearr_22812_22947 = state_22650__$1;
(statearr_22812_22947[(1)] = (9));

} else {
var statearr_22813_22948 = state_22650__$1;
(statearr_22813_22948[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (49))){
var inst_22455 = (state_22650[(30)]);
var state_22650__$1 = state_22650;
var statearr_22814_22949 = state_22650__$1;
(statearr_22814_22949[(2)] = inst_22455);

(statearr_22814_22949[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22651 === (84))){
var inst_22548 = (state_22650[(25)]);
var state_22650__$1 = state_22650;
var statearr_22815_22950 = state_22650__$1;
(statearr_22815_22950[(2)] = inst_22548);

(statearr_22815_22950[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2733__auto__ = null;
var fluree$db$query$fql$state_machine__2733__auto____0 = (function (){
var statearr_22816 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22816[(0)] = fluree$db$query$fql$state_machine__2733__auto__);

(statearr_22816[(1)] = (1));

return statearr_22816;
});
var fluree$db$query$fql$state_machine__2733__auto____1 = (function (state_22650){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_22650);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e22817){var ex__2736__auto__ = e22817;
var statearr_22818_22951 = state_22650;
(statearr_22818_22951[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_22650[(4)]))){
var statearr_22819_22952 = state_22650;
(statearr_22819_22952[(1)] = cljs.core.first((state_22650[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22953 = state_22650;
state_22650 = G__22953;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2733__auto__ = function(state_22650){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2733__auto____1.call(this,state_22650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2733__auto____0;
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2733__auto____1;
return fluree$db$query$fql$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_22820 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_22820[(6)] = c__2755__auto__);

return statearr_22820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_23113){
var state_val_23114 = (state_23113[(1)]);
if((state_val_23114 === (7))){
var inst_23108 = (state_23113[(2)]);
var _ = (function (){var statearr_23115 = state_23113;
(statearr_23115[(4)] = cljs.core.rest((state_23113[(4)])));

return statearr_23115;
})();
var state_23113__$1 = state_23113;
var statearr_23116_23198 = state_23113__$1;
(statearr_23116_23198[(2)] = inst_23108);

(statearr_23116_23198[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (20))){
var inst_23035 = (state_23113[(7)]);
var state_23113__$1 = state_23113;
var statearr_23117_23199 = state_23113__$1;
(statearr_23117_23199[(2)] = inst_23035);

(statearr_23117_23199[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (27))){
var inst_22990 = (state_23113[(8)]);
var state_23113__$1 = state_23113;
if(cljs.core.truth_(inst_22990)){
var statearr_23118_23200 = state_23113__$1;
(statearr_23118_23200[(1)] = (29));

} else {
var statearr_23119_23201 = state_23113__$1;
(statearr_23119_23201[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (1))){
var state_23113__$1 = state_23113;
var statearr_23120_23202 = state_23113__$1;
(statearr_23120_23202[(2)] = null);

(statearr_23120_23202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (24))){
var inst_22991 = (state_23113[(9)]);
var state_23113__$1 = state_23113;
var statearr_23121_23203 = state_23113__$1;
(statearr_23121_23203[(2)] = inst_22991);

(statearr_23121_23203[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (39))){
var inst_23027 = (state_23113[(10)]);
var state_23113__$1 = state_23113;
var statearr_23122_23204 = state_23113__$1;
(statearr_23122_23204[(2)] = inst_23027);

(statearr_23122_23204[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (46))){
var inst_22992 = (state_23113[(11)]);
var state_23113__$1 = state_23113;
var statearr_23123_23205 = state_23113__$1;
(statearr_23123_23205[(2)] = inst_22992);

(statearr_23123_23205[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (4))){
var inst_22954 = (state_23113[(2)]);
var state_23113__$1 = state_23113;
var statearr_23124_23206 = state_23113__$1;
(statearr_23124_23206[(2)] = inst_22954);

(statearr_23124_23206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (15))){
var inst_23003 = (state_23113[(12)]);
var inst_23009 = cljs.core.count(inst_23003);
var inst_23010 = fluree.db.query.fql.add_fuel(fuel,inst_23009,max_fuel);
var state_23113__$1 = state_23113;
var statearr_23125_23207 = state_23113__$1;
(statearr_23125_23207[(2)] = inst_23010);

(statearr_23125_23207[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (48))){
var inst_23094 = (state_23113[(13)]);
var inst_22972 = (state_23113[(14)]);
var inst_22979 = (state_23113[(15)]);
var inst_23102 = (state_23113[(2)]);
var inst_23103 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22972,inst_23102,inst_23094);
var inst_22971 = inst_22979;
var inst_22972__$1 = inst_23103;
var state_23113__$1 = (function (){var statearr_23126 = state_23113;
(statearr_23126[(16)] = inst_22971);

(statearr_23126[(14)] = inst_22972__$1);

return statearr_23126;
})();
var statearr_23127_23208 = state_23113__$1;
(statearr_23127_23208[(2)] = null);

(statearr_23127_23208[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (50))){
var inst_22994 = (state_23113[(17)]);
var state_23113__$1 = state_23113;
var statearr_23128_23209 = state_23113__$1;
(statearr_23128_23209[(2)] = inst_22994);

(statearr_23128_23209[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (21))){
var inst_22991 = (state_23113[(9)]);
var state_23113__$1 = state_23113;
if(cljs.core.truth_(inst_22991)){
var statearr_23130_23210 = state_23113__$1;
(statearr_23130_23210[(1)] = (23));

} else {
var statearr_23131_23211 = state_23113__$1;
(statearr_23131_23211[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (31))){
var inst_23051 = (state_23113[(2)]);
var state_23113__$1 = state_23113;
if(cljs.core.truth_(inst_23051)){
var statearr_23132_23212 = state_23113__$1;
(statearr_23132_23212[(1)] = (32));

} else {
var statearr_23133_23213 = state_23113__$1;
(statearr_23133_23213[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (32))){
var inst_23027 = (state_23113[(10)]);
var inst_23034 = (state_23113[(18)]);
var inst_23026 = (state_23113[(19)]);
var inst_23053 = (inst_23026 + (1));
var tmp23129 = inst_23027;
var inst_23025 = inst_23034;
var inst_23026__$1 = inst_23053;
var inst_23027__$1 = tmp23129;
var state_23113__$1 = (function (){var statearr_23134 = state_23113;
(statearr_23134[(10)] = inst_23027__$1);

(statearr_23134[(19)] = inst_23026__$1);

(statearr_23134[(20)] = inst_23025);

return statearr_23134;
})();
var statearr_23135_23214 = state_23113__$1;
(statearr_23135_23214[(2)] = null);

(statearr_23135_23214[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (40))){
var state_23113__$1 = state_23113;
if(cljs.core.truth_(fuel)){
var statearr_23136_23215 = state_23113__$1;
(statearr_23136_23215[(1)] = (42));

} else {
var statearr_23137_23216 = state_23113__$1;
(statearr_23137_23216[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (33))){
var state_23113__$1 = state_23113;
var statearr_23138_23217 = state_23113__$1;
(statearr_23138_23217[(1)] = (35));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (13))){
var inst_23003 = (state_23113[(12)]);
var state_23113__$1 = state_23113;
var statearr_23140_23218 = state_23113__$1;
(statearr_23140_23218[(2)] = inst_23003);

(statearr_23140_23218[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (22))){
var inst_23044 = (state_23113[(2)]);
var state_23113__$1 = state_23113;
if(cljs.core.truth_(inst_23044)){
var statearr_23141_23219 = state_23113__$1;
(statearr_23141_23219[(1)] = (26));

} else {
var statearr_23142_23220 = state_23113__$1;
(statearr_23142_23220[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (36))){
var state_23113__$1 = state_23113;
var statearr_23143_23221 = state_23113__$1;
(statearr_23143_23221[(2)] = null);

(statearr_23143_23221[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (41))){
var inst_23034 = (state_23113[(18)]);
var inst_23026 = (state_23113[(19)]);
var inst_23083 = (state_23113[(2)]);
var inst_23084 = (inst_23026 + (1));
var inst_23025 = inst_23034;
var inst_23026__$1 = inst_23084;
var inst_23027 = inst_23083;
var state_23113__$1 = (function (){var statearr_23144 = state_23113;
(statearr_23144[(10)] = inst_23027);

(statearr_23144[(19)] = inst_23026__$1);

(statearr_23144[(20)] = inst_23025);

return statearr_23144;
})();
var statearr_23145_23222 = state_23113__$1;
(statearr_23145_23222[(2)] = null);

(statearr_23145_23222[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (43))){
var state_23113__$1 = state_23113;
var statearr_23146_23223 = state_23113__$1;
(statearr_23146_23223[(2)] = null);

(statearr_23146_23223[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (29))){
var inst_23026 = (state_23113[(19)]);
var inst_22990 = (state_23113[(8)]);
var inst_23048 = (inst_23026 < inst_22990);
var state_23113__$1 = state_23113;
var statearr_23147_23224 = state_23113__$1;
(statearr_23147_23224[(2)] = inst_23048);

(statearr_23147_23224[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (44))){
var inst_23063 = (state_23113[(21)]);
var inst_23067 = (state_23113[(22)]);
var inst_23076 = (state_23113[(2)]);
var inst_23077 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23067,inst_23063) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23067,inst_23063));
var state_23113__$1 = (function (){var statearr_23148 = state_23113;
(statearr_23148[(23)] = inst_23076);

return statearr_23148;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23113__$1,(45),inst_23077);
} else {
if((state_val_23114 === (6))){
var inst_22971 = (state_23113[(16)]);
var inst_22978 = (state_23113[(24)]);
var inst_22977 = cljs.core.seq(inst_22971);
var inst_22978__$1 = cljs.core.first(inst_22977);
var inst_22979 = cljs.core.next(inst_22977);
var inst_22980 = cljs.core.not(inst_22978__$1);
var state_23113__$1 = (function (){var statearr_23149 = state_23113;
(statearr_23149[(24)] = inst_22978__$1);

(statearr_23149[(15)] = inst_22979);

return statearr_23149;
})();
if(inst_22980){
var statearr_23150_23225 = state_23113__$1;
(statearr_23150_23225[(1)] = (8));

} else {
var statearr_23151_23226 = state_23113__$1;
(statearr_23151_23226[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (28))){
var inst_23092 = (state_23113[(2)]);
var state_23113__$1 = state_23113;
var statearr_23152_23227 = state_23113__$1;
(statearr_23152_23227[(2)] = inst_23092);

(statearr_23152_23227[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (51))){
var inst_23100 = (state_23113[(2)]);
var state_23113__$1 = state_23113;
var statearr_23153_23228 = state_23113__$1;
(statearr_23153_23228[(2)] = inst_23100);

(statearr_23153_23228[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (25))){
var inst_23042 = (state_23113[(2)]);
var state_23113__$1 = state_23113;
var statearr_23154_23229 = state_23113__$1;
(statearr_23154_23229[(2)] = inst_23042);

(statearr_23154_23229[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (34))){
var inst_23090 = (state_23113[(2)]);
var state_23113__$1 = state_23113;
var statearr_23155_23230 = state_23113__$1;
(statearr_23155_23230[(2)] = inst_23090);

(statearr_23155_23230[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (17))){
var inst_23003 = (state_23113[(12)]);
var inst_23013 = (state_23113[(2)]);
var inst_23021 = cljs.core.seq(inst_23003);
var inst_23022 = cljs.core.first(inst_23021);
var inst_23023 = cljs.core.next(inst_23021);
var inst_23024 = cljs.core.PersistentVector.EMPTY;
var inst_23025 = inst_23003;
var inst_23026 = (0);
var inst_23027 = inst_23024;
var state_23113__$1 = (function (){var statearr_23156 = state_23113;
(statearr_23156[(10)] = inst_23027);

(statearr_23156[(25)] = inst_23023);

(statearr_23156[(19)] = inst_23026);

(statearr_23156[(26)] = inst_23022);

(statearr_23156[(20)] = inst_23025);

(statearr_23156[(27)] = inst_23013);

return statearr_23156;
})();
var statearr_23157_23231 = state_23113__$1;
(statearr_23157_23231[(2)] = null);

(statearr_23157_23231[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (3))){
var inst_23111 = (state_23113[(2)]);
var state_23113__$1 = state_23113;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23113__$1,inst_23111);
} else {
if((state_val_23114 === (12))){
var state_23113__$1 = state_23113;
var statearr_23158_23232 = state_23113__$1;
(statearr_23158_23232[(2)] = fuel);

(statearr_23158_23232[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (2))){
var _ = (function (){var statearr_23159 = state_23113;
(statearr_23159[(4)] = cljs.core.cons((5),(state_23113[(4)])));

return statearr_23159;
})();
var inst_22967 = reverse_refs_specs;
var inst_22968 = cljs.core.seq(inst_22967);
var inst_22969 = cljs.core.first(inst_22968);
var inst_22970 = cljs.core.next(inst_22968);
var inst_22971 = inst_22967;
var inst_22972 = null;
var state_23113__$1 = (function (){var statearr_23160 = state_23113;
(statearr_23160[(28)] = inst_22969);

(statearr_23160[(29)] = inst_22970);

(statearr_23160[(16)] = inst_22971);

(statearr_23160[(14)] = inst_22972);

return statearr_23160;
})();
var statearr_23161_23233 = state_23113__$1;
(statearr_23161_23233[(2)] = null);

(statearr_23161_23233[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (23))){
var inst_23026 = (state_23113[(19)]);
var inst_22991 = (state_23113[(9)]);
var inst_23039 = (inst_23026 >= inst_22991);
var state_23113__$1 = state_23113;
var statearr_23162_23234 = state_23113__$1;
(statearr_23162_23234[(2)] = inst_23039);

(statearr_23162_23234[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (47))){
var inst_22993 = (state_23113[(30)]);
var state_23113__$1 = state_23113;
if(cljs.core.truth_(inst_22993)){
var statearr_23163_23235 = state_23113__$1;
(statearr_23163_23235[(1)] = (49));

} else {
var statearr_23164_23236 = state_23113__$1;
(statearr_23164_23236[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (35))){
var inst_23033 = (state_23113[(31)]);
var inst_23057 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23058 = [inst_23033];
var inst_23059 = (new cljs.core.PersistentVector(null,1,(5),inst_23057,inst_23058,null));
var inst_23060 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23059);
var state_23113__$1 = state_23113;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23113__$1,(38),inst_23060);
} else {
if((state_val_23114 === (19))){
var inst_22992 = (state_23113[(11)]);
var inst_23094 = (state_23113[(2)]);
var state_23113__$1 = (function (){var statearr_23165 = state_23113;
(statearr_23165[(13)] = inst_23094);

return statearr_23165;
})();
if(cljs.core.truth_(inst_22992)){
var statearr_23166_23237 = state_23113__$1;
(statearr_23166_23237[(1)] = (46));

} else {
var statearr_23167_23238 = state_23113__$1;
(statearr_23167_23238[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (11))){
var inst_23003 = (state_23113[(12)]);
var inst_23000 = (state_23113[(2)]);
var inst_23001 = fluree.db.util.async.throw_err(inst_23000);
var inst_23002 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_23001);
var inst_23003__$1 = cljs.core.not_empty(inst_23002);
var state_23113__$1 = (function (){var statearr_23169 = state_23113;
(statearr_23169[(12)] = inst_23003__$1);

return statearr_23169;
})();
if(cljs.core.truth_(inst_23003__$1)){
var statearr_23170_23239 = state_23113__$1;
(statearr_23170_23239[(1)] = (12));

} else {
var statearr_23171_23240 = state_23113__$1;
(statearr_23171_23240[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (9))){
var inst_22988 = (state_23113[(32)]);
var inst_22978 = (state_23113[(24)]);
var inst_22987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22978,(0),null);
var inst_22988__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22978,(1),null);
var inst_22989 = cljs.core.__destructure_map(inst_22988__$1);
var inst_22990 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22989,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22991 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22989,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22992 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22989,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22993 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22989,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_22994 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22989,new cljs.core.Keyword(null,"p","p",151049309));
var inst_22995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22996 = [subject_id,inst_22987];
var inst_22997 = (new cljs.core.PersistentVector(null,2,(5),inst_22995,inst_22996,null));
var inst_22998 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_22997);
var state_23113__$1 = (function (){var statearr_23172 = state_23113;
(statearr_23172[(11)] = inst_22992);

(statearr_23172[(17)] = inst_22994);

(statearr_23172[(32)] = inst_22988__$1);

(statearr_23172[(9)] = inst_22991);

(statearr_23172[(8)] = inst_22990);

(statearr_23172[(30)] = inst_22993);

return statearr_23172;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23113__$1,(11),inst_22998);
} else {
if((state_val_23114 === (5))){
var _ = (function (){var statearr_23173 = state_23113;
(statearr_23173[(4)] = cljs.core.rest((state_23113[(4)])));

return statearr_23173;
})();
var state_23113__$1 = state_23113;
var ex23168 = (state_23113__$1[(2)]);
var statearr_23174_23241 = state_23113__$1;
(statearr_23174_23241[(5)] = ex23168);


if((ex23168 instanceof Error)){
var statearr_23175_23242 = state_23113__$1;
(statearr_23175_23242[(1)] = (4));

(statearr_23175_23242[(5)] = null);

} else {
throw ex23168;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (14))){
var inst_23007 = (state_23113[(2)]);
var state_23113__$1 = state_23113;
if(cljs.core.truth_(inst_23007)){
var statearr_23176_23243 = state_23113__$1;
(statearr_23176_23243[(1)] = (15));

} else {
var statearr_23177_23244 = state_23113__$1;
(statearr_23177_23244[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (45))){
var inst_23027 = (state_23113[(10)]);
var inst_23079 = (state_23113[(2)]);
var inst_23080 = fluree.db.util.async.throw_err(inst_23079);
var inst_23081 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23027,inst_23080);
var state_23113__$1 = state_23113;
var statearr_23178_23245 = state_23113__$1;
(statearr_23178_23245[(2)] = inst_23081);

(statearr_23178_23245[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (26))){
var inst_23027 = (state_23113[(10)]);
var state_23113__$1 = state_23113;
var statearr_23179_23246 = state_23113__$1;
(statearr_23179_23246[(2)] = inst_23027);

(statearr_23179_23246[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (16))){
var state_23113__$1 = state_23113;
var statearr_23180_23247 = state_23113__$1;
(statearr_23180_23247[(2)] = null);

(statearr_23180_23247[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (38))){
var inst_23063 = (state_23113[(21)]);
var inst_22988 = (state_23113[(32)]);
var inst_23062 = (state_23113[(2)]);
var inst_23063__$1 = fluree.db.util.async.throw_err(inst_23062);
var inst_23064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23065 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23066 = (new cljs.core.PersistentVector(null,4,(5),inst_23064,inst_23065,null));
var inst_23067 = cljs.core.select_keys(inst_22988,inst_23066);
var inst_23068 = cljs.core.empty_QMARK_(inst_23063__$1);
var state_23113__$1 = (function (){var statearr_23181 = state_23113;
(statearr_23181[(21)] = inst_23063__$1);

(statearr_23181[(22)] = inst_23067);

return statearr_23181;
})();
if(inst_23068){
var statearr_23182_23248 = state_23113__$1;
(statearr_23182_23248[(1)] = (39));

} else {
var statearr_23183_23249 = state_23113__$1;
(statearr_23183_23249[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (30))){
var inst_22990 = (state_23113[(8)]);
var state_23113__$1 = state_23113;
var statearr_23184_23250 = state_23113__$1;
(statearr_23184_23250[(2)] = inst_22990);

(statearr_23184_23250[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (10))){
var inst_23106 = (state_23113[(2)]);
var state_23113__$1 = state_23113;
var statearr_23185_23251 = state_23113__$1;
(statearr_23185_23251[(2)] = inst_23106);

(statearr_23185_23251[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (18))){
var inst_23033 = (state_23113[(31)]);
var inst_23035 = (state_23113[(7)]);
var inst_23025 = (state_23113[(20)]);
var inst_23032 = cljs.core.seq(inst_23025);
var inst_23033__$1 = cljs.core.first(inst_23032);
var inst_23034 = cljs.core.next(inst_23032);
var inst_23035__$1 = cljs.core.not(inst_23033__$1);
var state_23113__$1 = (function (){var statearr_23186 = state_23113;
(statearr_23186[(31)] = inst_23033__$1);

(statearr_23186[(18)] = inst_23034);

(statearr_23186[(7)] = inst_23035__$1);

return statearr_23186;
})();
if(inst_23035__$1){
var statearr_23187_23252 = state_23113__$1;
(statearr_23187_23252[(1)] = (20));

} else {
var statearr_23188_23253 = state_23113__$1;
(statearr_23188_23253[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (42))){
var inst_23063 = (state_23113[(21)]);
var inst_23072 = cljs.core.count(inst_23063);
var inst_23073 = fluree.db.query.fql.add_fuel(fuel,inst_23072,max_fuel);
var state_23113__$1 = state_23113;
var statearr_23189_23254 = state_23113__$1;
(statearr_23189_23254[(2)] = inst_23073);

(statearr_23189_23254[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (37))){
var inst_23088 = (state_23113[(2)]);
var state_23113__$1 = state_23113;
var statearr_23190_23255 = state_23113__$1;
(statearr_23190_23255[(2)] = inst_23088);

(statearr_23190_23255[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (8))){
var inst_22972 = (state_23113[(14)]);
var state_23113__$1 = state_23113;
var statearr_23191_23256 = state_23113__$1;
(statearr_23191_23256[(2)] = inst_22972);

(statearr_23191_23256[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23114 === (49))){
var inst_22993 = (state_23113[(30)]);
var state_23113__$1 = state_23113;
var statearr_23192_23257 = state_23113__$1;
(statearr_23192_23257[(2)] = inst_22993);

(statearr_23192_23257[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto____0 = (function (){
var statearr_23193 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23193[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto__);

(statearr_23193[(1)] = (1));

return statearr_23193;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto____1 = (function (state_23113){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_23113);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e23194){var ex__2736__auto__ = e23194;
var statearr_23195_23258 = state_23113;
(statearr_23195_23258[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_23113[(4)]))){
var statearr_23196_23259 = state_23113;
(statearr_23196_23259[(1)] = cljs.core.first((state_23113[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23260 = state_23113;
state_23113 = G__23260;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto__ = function(state_23113){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto____1.call(this,state_23113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_23197 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_23197[(6)] = c__2755__auto__);

return statearr_23197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__23261 = select_spec;
var map__23261__$1 = cljs.core.__destructure_map(map__23261);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23261__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23261__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_23323){
var state_val_23324 = (state_23323[(1)]);
if((state_val_23324 === (7))){
var inst_23287 = (state_23323[(7)]);
var inst_23289 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_23290 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23289,inst_23287);
var state_23323__$1 = state_23323;
var statearr_23325_23364 = state_23323__$1;
(statearr_23325_23364[(2)] = inst_23290);

(statearr_23325_23364[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (20))){
var inst_23293 = (state_23323[(8)]);
var inst_23311 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_23312 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23311,inst_23293) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23311,inst_23293));
var state_23323__$1 = state_23323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23323__$1,(22),inst_23312);
} else {
if((state_val_23324 === (1))){
var state_23323__$1 = state_23323;
var statearr_23326_23365 = state_23323__$1;
(statearr_23326_23365[(2)] = null);

(statearr_23326_23365[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (4))){
var inst_23262 = (state_23323[(2)]);
var state_23323__$1 = state_23323;
var statearr_23327_23366 = state_23323__$1;
(statearr_23327_23366[(2)] = inst_23262);

(statearr_23327_23366[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (15))){
var inst_23300 = (state_23323[(2)]);
var state_23323__$1 = state_23323;
var statearr_23328_23367 = state_23323__$1;
(statearr_23328_23367[(2)] = inst_23300);

(statearr_23328_23367[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (21))){
var inst_23318 = (state_23323[(2)]);
var _ = (function (){var statearr_23329 = state_23323;
(statearr_23329[(4)] = cljs.core.rest((state_23323[(4)])));

return statearr_23329;
})();
var state_23323__$1 = state_23323;
var statearr_23330_23368 = state_23323__$1;
(statearr_23330_23368[(2)] = inst_23318);

(statearr_23330_23368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (13))){
var inst_23279 = (state_23323[(9)]);
var state_23323__$1 = state_23323;
var statearr_23331_23369 = state_23323__$1;
(statearr_23331_23369[(2)] = inst_23279);

(statearr_23331_23369[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (22))){
var inst_23308 = (state_23323[(10)]);
var inst_23273 = (state_23323[(11)]);
var inst_23314 = (state_23323[(2)]);
var inst_23315 = fluree.db.util.async.throw_err(inst_23314);
var inst_23316 = (inst_23308.cljs$core$IFn$_invoke$arity$3 ? inst_23308.cljs$core$IFn$_invoke$arity$3(acc,inst_23273,inst_23315) : inst_23308.call(null,acc,inst_23273,inst_23315));
var state_23323__$1 = state_23323;
var statearr_23332_23370 = state_23323__$1;
(statearr_23332_23370[(2)] = inst_23316);

(statearr_23332_23370[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (6))){
var inst_23286 = (state_23323[(2)]);
var inst_23287 = fluree.db.util.async.throw_err(inst_23286);
var state_23323__$1 = (function (){var statearr_23333 = state_23323;
(statearr_23333[(7)] = inst_23287);

return statearr_23333;
})();
if(cljs.core.truth_(fuel)){
var statearr_23334_23371 = state_23323__$1;
(statearr_23334_23371[(1)] = (7));

} else {
var statearr_23335_23372 = state_23323__$1;
(statearr_23335_23372[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (17))){
var inst_23269 = (state_23323[(12)]);
var inst_23302 = (state_23323[(13)]);
var inst_23277 = (state_23323[(14)]);
var inst_23274 = (state_23323[(15)]);
var inst_23276 = (state_23323[(16)]);
var inst_23273 = (state_23323[(11)]);
var inst_23293 = (state_23323[(8)]);
var inst_23275 = (state_23323[(17)]);
var inst_23279 = (state_23323[(9)]);
var inst_23272 = (state_23323[(18)]);
var inst_23271 = (state_23323[(19)]);
var inst_23278 = (state_23323[(20)]);
var inst_23306 = (function (){var recur_seen = inst_23275;
var recur_subject = inst_23269;
var sub_flakes = inst_23293;
var seen_QMARK_ = inst_23278;
var multi_QMARK_ = inst_23272;
var limit = inst_23277;
var recur_depth = inst_23276;
var as = inst_23273;
var max_depth_QMARK_ = inst_23279;
var map__23268 = inst_23271;
var recur = inst_23274;
var stop_QMARK_ = inst_23302;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_23323__$1 = state_23323;
var statearr_23336_23373 = state_23323__$1;
(statearr_23336_23373[(2)] = inst_23306);

(statearr_23336_23373[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (3))){
var inst_23321 = (state_23323[(2)]);
var state_23323__$1 = state_23323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23323__$1,inst_23321);
} else {
if((state_val_23324 === (12))){
var inst_23272 = (state_23323[(18)]);
var inst_23302 = (state_23323[(2)]);
var state_23323__$1 = (function (){var statearr_23337 = state_23323;
(statearr_23337[(13)] = inst_23302);

return statearr_23337;
})();
if(cljs.core.truth_(inst_23272)){
var statearr_23338_23374 = state_23323__$1;
(statearr_23338_23374[(1)] = (16));

} else {
var statearr_23339_23375 = state_23323__$1;
(statearr_23339_23375[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (2))){
var inst_23269 = (state_23323[(12)]);
var inst_23274 = (state_23323[(15)]);
var inst_23276 = (state_23323[(16)]);
var inst_23275 = (state_23323[(17)]);
var inst_23271 = (state_23323[(19)]);
var _ = (function (){var statearr_23340 = state_23323;
(statearr_23340[(4)] = cljs.core.cons((5),(state_23323[(4)])));

return statearr_23340;
})();
var inst_23269__$1 = flake.o;
var inst_23270 = select_spec;
var inst_23271__$1 = cljs.core.__destructure_map(inst_23270);
var inst_23272 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23271__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_23273 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23271__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23274__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23271__$1,new cljs.core.Keyword(null,"recur","recur",-437573268));
var inst_23275__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23271__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_23276__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23271__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_23277 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23271__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23278 = cljs.core.contains_QMARK_(inst_23275__$1,inst_23269__$1);
var inst_23279 = (inst_23276__$1 > inst_23274__$1);
var inst_23281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23282 = [inst_23269__$1];
var inst_23283 = (new cljs.core.PersistentVector(null,1,(5),inst_23281,inst_23282,null));
var inst_23284 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23283);
var state_23323__$1 = (function (){var statearr_23341 = state_23323;
(statearr_23341[(12)] = inst_23269__$1);

(statearr_23341[(14)] = inst_23277);

(statearr_23341[(15)] = inst_23274__$1);

(statearr_23341[(16)] = inst_23276__$1);

(statearr_23341[(11)] = inst_23273);

(statearr_23341[(17)] = inst_23275__$1);

(statearr_23341[(9)] = inst_23279);

(statearr_23341[(18)] = inst_23272);

(statearr_23341[(19)] = inst_23271__$1);

(statearr_23341[(20)] = inst_23278);

return statearr_23341;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23323__$1,(6),inst_23284);
} else {
if((state_val_23324 === (19))){
var state_23323__$1 = state_23323;
var statearr_23342_23376 = state_23323__$1;
(statearr_23342_23376[(2)] = acc);

(statearr_23342_23376[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (11))){
var inst_23279 = (state_23323[(9)]);
var state_23323__$1 = state_23323;
if(cljs.core.truth_(inst_23279)){
var statearr_23344_23377 = state_23323__$1;
(statearr_23344_23377[(1)] = (13));

} else {
var statearr_23345_23378 = state_23323__$1;
(statearr_23345_23378[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (9))){
var inst_23278 = (state_23323[(20)]);
var inst_23293 = (state_23323[(2)]);
var state_23323__$1 = (function (){var statearr_23346 = state_23323;
(statearr_23346[(8)] = inst_23293);

return statearr_23346;
})();
if(cljs.core.truth_(inst_23278)){
var statearr_23347_23379 = state_23323__$1;
(statearr_23347_23379[(1)] = (10));

} else {
var statearr_23348_23380 = state_23323__$1;
(statearr_23348_23380[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (5))){
var _ = (function (){var statearr_23349 = state_23323;
(statearr_23349[(4)] = cljs.core.rest((state_23323[(4)])));

return statearr_23349;
})();
var state_23323__$1 = state_23323;
var ex23343 = (state_23323__$1[(2)]);
var statearr_23350_23381 = state_23323__$1;
(statearr_23350_23381[(5)] = ex23343);


if((ex23343 instanceof Error)){
var statearr_23351_23382 = state_23323__$1;
(statearr_23351_23382[(1)] = (4));

(statearr_23351_23382[(5)] = null);

} else {
throw ex23343;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (14))){
var inst_23293 = (state_23323[(8)]);
var inst_23298 = cljs.core.empty_QMARK_(inst_23293);
var state_23323__$1 = state_23323;
var statearr_23352_23383 = state_23323__$1;
(statearr_23352_23383[(2)] = inst_23298);

(statearr_23352_23383[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (16))){
var inst_23269 = (state_23323[(12)]);
var inst_23302 = (state_23323[(13)]);
var inst_23277 = (state_23323[(14)]);
var inst_23274 = (state_23323[(15)]);
var inst_23276 = (state_23323[(16)]);
var inst_23273 = (state_23323[(11)]);
var inst_23293 = (state_23323[(8)]);
var inst_23275 = (state_23323[(17)]);
var inst_23279 = (state_23323[(9)]);
var inst_23272 = (state_23323[(18)]);
var inst_23271 = (state_23323[(19)]);
var inst_23278 = (state_23323[(20)]);
var inst_23304 = (function (){var recur_seen = inst_23275;
var recur_subject = inst_23269;
var sub_flakes = inst_23293;
var seen_QMARK_ = inst_23278;
var multi_QMARK_ = inst_23272;
var limit = inst_23277;
var recur_depth = inst_23276;
var as = inst_23273;
var max_depth_QMARK_ = inst_23279;
var map__23268 = inst_23271;
var recur = inst_23274;
var stop_QMARK_ = inst_23302;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_23323__$1 = state_23323;
var statearr_23353_23384 = state_23323__$1;
(statearr_23353_23384[(2)] = inst_23304);

(statearr_23353_23384[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (10))){
var inst_23278 = (state_23323[(20)]);
var state_23323__$1 = state_23323;
var statearr_23354_23385 = state_23323__$1;
(statearr_23354_23385[(2)] = inst_23278);

(statearr_23354_23385[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (18))){
var inst_23302 = (state_23323[(13)]);
var inst_23308 = (state_23323[(2)]);
var state_23323__$1 = (function (){var statearr_23355 = state_23323;
(statearr_23355[(10)] = inst_23308);

return statearr_23355;
})();
if(cljs.core.truth_(inst_23302)){
var statearr_23356_23386 = state_23323__$1;
(statearr_23356_23386[(1)] = (19));

} else {
var statearr_23357_23387 = state_23323__$1;
(statearr_23357_23387[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23324 === (8))){
var inst_23287 = (state_23323[(7)]);
var state_23323__$1 = state_23323;
var statearr_23358_23388 = state_23323__$1;
(statearr_23358_23388[(2)] = inst_23287);

(statearr_23358_23388[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto____0 = (function (){
var statearr_23359 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23359[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto__);

(statearr_23359[(1)] = (1));

return statearr_23359;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto____1 = (function (state_23323){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_23323);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e23360){var ex__2736__auto__ = e23360;
var statearr_23361_23389 = state_23323;
(statearr_23361_23389[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_23323[(4)]))){
var statearr_23362_23390 = state_23323;
(statearr_23362_23390[(1)] = cljs.core.first((state_23323[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23391 = state_23323;
state_23323 = G__23391;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto__ = function(state_23323){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto____1.call(this,state_23323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_23363 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_23363[(6)] = c__2755__auto__);

return statearr_23363;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_23569){
var state_val_23570 = (state_23569[(1)]);
if((state_val_23570 === (7))){
var state_23569__$1 = state_23569;
var statearr_23571_23657 = state_23569__$1;
(statearr_23571_23657[(2)] = null);

(statearr_23571_23657[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (20))){
var inst_23430 = cljs.core.PersistentHashMap.EMPTY;
var state_23569__$1 = state_23569;
var statearr_23572_23658 = state_23569__$1;
(statearr_23572_23658[(2)] = inst_23430);

(statearr_23572_23658[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (27))){
var inst_23418 = (state_23569[(7)]);
var inst_23448 = (state_23569[(8)]);
var inst_23432 = (state_23569[(9)]);
var inst_23412 = (state_23569[(10)]);
var inst_23548 = (state_23569[(2)]);
var inst_23549 = (function (){var top_level_subject = inst_23412;
var select_spec = inst_23418;
var base_acc = inst_23432;
var acc_PLUS_refs = inst_23448;
var result = inst_23548;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4223__auto__ = (function (){var and__4221__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4221__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4221__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23550 = cljs.core.PersistentVector.EMPTY;
var inst_23551 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23418);
var inst_23552 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23551);
var inst_23553 = cljs.core.vals(inst_23552);
var inst_23554 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23418);
var inst_23555 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23554);
var inst_23556 = cljs.core.vals(inst_23555);
var inst_23557 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23553,inst_23556);
var inst_23558 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23549,inst_23550,inst_23557);
var inst_23560 = (function (){var top_level_subject = inst_23412;
var select_spec = inst_23418;
var base_acc = inst_23432;
var acc_PLUS_refs = inst_23448;
var result = inst_23548;
var sort_preds = inst_23558;
return (function (acc,p__23559){
var vec__23573 = p__23559;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23573,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23573,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23573,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23573,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_23561 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23560,inst_23548,inst_23558);
var state_23569__$1 = state_23569;
var statearr_23576_23659 = state_23569__$1;
(statearr_23576_23659[(2)] = inst_23561);

(statearr_23576_23659[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (1))){
var state_23569__$1 = state_23569;
var statearr_23577_23660 = state_23569__$1;
(statearr_23577_23660[(2)] = null);

(statearr_23577_23660[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (24))){
var inst_23448 = (state_23569[(8)]);
var inst_23448__$1 = (state_23569[(2)]);
var inst_23449 = flakes;
var inst_23450 = cljs.core.PersistentHashMap.EMPTY;
var inst_23451 = inst_23449;
var inst_23452 = inst_23448__$1;
var inst_23453 = inst_23450;
var state_23569__$1 = (function (){var statearr_23578 = state_23569;
(statearr_23578[(11)] = inst_23451);

(statearr_23578[(8)] = inst_23448__$1);

(statearr_23578[(12)] = inst_23453);

(statearr_23578[(13)] = inst_23452);

return statearr_23578;
})();
var statearr_23579_23661 = state_23569__$1;
(statearr_23579_23661[(2)] = null);

(statearr_23579_23661[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (39))){
var inst_23418 = (state_23569[(7)]);
var inst_23461 = (state_23569[(14)]);
var inst_23467 = (state_23569[(15)]);
var inst_23452 = (state_23569[(13)]);
var inst_23496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23497 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_23452,inst_23418,inst_23461,inst_23467,false);
var state_23569__$1 = (function (){var statearr_23580 = state_23569;
(statearr_23580[(16)] = inst_23496);

return statearr_23580;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23569__$1,(42),inst_23497);
} else {
if((state_val_23570 === (46))){
var inst_23451 = (state_23569[(11)]);
var inst_23461 = (state_23569[(14)]);
var inst_23453 = (state_23569[(12)]);
var inst_23514 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23515 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23516 = inst_23461.s;
var inst_23517 = [inst_23516];
var inst_23518 = cljs.core.PersistentHashMap.fromArrays(inst_23515,inst_23517);
var inst_23519 = cljs.core.rest(inst_23451);
var inst_23520 = [inst_23518,inst_23519,inst_23453];
var inst_23521 = (new cljs.core.PersistentVector(null,3,(5),inst_23514,inst_23520,null));
var state_23569__$1 = state_23569;
var statearr_23581_23662 = state_23569__$1;
(statearr_23581_23662[(2)] = inst_23521);

(statearr_23581_23662[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (4))){
var inst_23392 = (state_23569[(2)]);
var state_23569__$1 = state_23569;
var statearr_23582_23663 = state_23569__$1;
(statearr_23582_23663[(2)] = inst_23392);

(statearr_23582_23663[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (15))){
var inst_23418 = (state_23569[(7)]);
var inst_23419 = (state_23569[(17)]);
var inst_23418__$1 = (state_23569[(2)]);
var inst_23419__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23418__$1);
var state_23569__$1 = (function (){var statearr_23583 = state_23569;
(statearr_23583[(7)] = inst_23418__$1);

(statearr_23583[(17)] = inst_23419__$1);

return statearr_23583;
})();
if(cljs.core.truth_(inst_23419__$1)){
var statearr_23584_23664 = state_23569__$1;
(statearr_23584_23664[(1)] = (16));

} else {
var statearr_23585_23665 = state_23569__$1;
(statearr_23585_23665[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (48))){
var inst_23532 = (state_23569[(2)]);
var state_23569__$1 = state_23569;
var statearr_23586_23666 = state_23569__$1;
(statearr_23586_23666[(2)] = inst_23532);

(statearr_23586_23666[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (50))){
var state_23569__$1 = state_23569;
var statearr_23587_23667 = state_23569__$1;
(statearr_23587_23667[(2)] = null);

(statearr_23587_23667[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (21))){
var inst_23418 = (state_23569[(7)]);
var inst_23432 = (state_23569[(2)]);
var inst_23433 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23434 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23435 = (new cljs.core.PersistentVector(null,2,(5),inst_23433,inst_23434,null));
var inst_23436 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23418,inst_23435);
var state_23569__$1 = (function (){var statearr_23588 = state_23569;
(statearr_23588[(9)] = inst_23432);

return statearr_23588;
})();
if(cljs.core.truth_(inst_23436)){
var statearr_23589_23668 = state_23569__$1;
(statearr_23589_23668[(1)] = (22));

} else {
var statearr_23590_23669 = state_23569__$1;
(statearr_23590_23669[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (31))){
var inst_23466 = (state_23569[(18)]);
var inst_23461 = (state_23569[(14)]);
var inst_23452 = (state_23569[(13)]);
var inst_23470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23471 = fluree.db.query.fql.flake__GT_recur(db,inst_23461,inst_23466,inst_23452,fuel,max_fuel,cache);
var state_23569__$1 = (function (){var statearr_23591 = state_23569;
(statearr_23591[(19)] = inst_23470);

return statearr_23591;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23569__$1,(34),inst_23471);
} else {
if((state_val_23570 === (32))){
var inst_23466 = (state_23569[(18)]);
var state_23569__$1 = state_23569;
if(cljs.core.truth_(inst_23466)){
var statearr_23592_23670 = state_23569__$1;
(statearr_23592_23670[(1)] = (35));

} else {
var statearr_23593_23671 = state_23569__$1;
(statearr_23593_23671[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (40))){
var inst_23507 = (state_23569[(20)]);
var inst_23418 = (state_23569[(7)]);
var inst_23506 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23418);
var inst_23507__$1 = cljs.core.empty_QMARK_(inst_23506);
var state_23569__$1 = (function (){var statearr_23594 = state_23569;
(statearr_23594[(20)] = inst_23507__$1);

return statearr_23594;
})();
if(inst_23507__$1){
var statearr_23595_23672 = state_23569__$1;
(statearr_23595_23672[(1)] = (43));

} else {
var statearr_23596_23673 = state_23569__$1;
(statearr_23596_23673[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (33))){
var inst_23461 = (state_23569[(14)]);
var inst_23538 = (state_23569[(2)]);
var inst_23539 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23538,(0),null);
var inst_23540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23538,(1),null);
var inst_23541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23538,(2),null);
var inst_23542 = inst_23461.s;
var inst_23543 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23539,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23542);
var inst_23451 = inst_23540;
var inst_23452 = inst_23543;
var inst_23453 = inst_23541;
var state_23569__$1 = (function (){var statearr_23597 = state_23569;
(statearr_23597[(11)] = inst_23451);

(statearr_23597[(12)] = inst_23453);

(statearr_23597[(13)] = inst_23452);

return statearr_23597;
})();
var statearr_23598_23674 = state_23569__$1;
(statearr_23598_23674[(2)] = null);

(statearr_23598_23674[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (13))){
var inst_23412 = (state_23569[(10)]);
var inst_23415 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_23412);
var state_23569__$1 = state_23569;
var statearr_23599_23675 = state_23569__$1;
(statearr_23599_23675[(2)] = inst_23415);

(statearr_23599_23675[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (22))){
var inst_23418 = (state_23569[(7)]);
var inst_23438 = cljs.core.first(flakes);
var inst_23439 = fluree.db.query.fql.s(inst_23438);
var inst_23440 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_23418);
var inst_23441 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_23439,inst_23440);
var state_23569__$1 = state_23569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23569__$1,(25),inst_23441);
} else {
if((state_val_23570 === (36))){
var inst_23418 = (state_23569[(7)]);
var inst_23494 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23418);
var state_23569__$1 = state_23569;
if(cljs.core.truth_(inst_23494)){
var statearr_23600_23676 = state_23569__$1;
(statearr_23600_23676[(1)] = (39));

} else {
var statearr_23601_23677 = state_23569__$1;
(statearr_23601_23677[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (41))){
var inst_23534 = (state_23569[(2)]);
var state_23569__$1 = state_23569;
var statearr_23602_23678 = state_23569__$1;
(statearr_23602_23678[(2)] = inst_23534);

(statearr_23602_23678[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (43))){
var inst_23418 = (state_23569[(7)]);
var inst_23509 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23418);
var state_23569__$1 = state_23569;
var statearr_23603_23679 = state_23569__$1;
(statearr_23603_23679[(2)] = inst_23509);

(statearr_23603_23679[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (29))){
var inst_23451 = (state_23569[(11)]);
var inst_23418 = (state_23569[(7)]);
var inst_23466 = (state_23569[(18)]);
var inst_23461 = (state_23569[(14)]);
var inst_23461__$1 = cljs.core.first(inst_23451);
var inst_23462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23463 = inst_23461__$1.p;
var inst_23464 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23463];
var inst_23465 = (new cljs.core.PersistentVector(null,3,(5),inst_23462,inst_23464,null));
var inst_23466__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23418,inst_23465);
var inst_23467 = fluree.db.query.fql.component_follow_QMARK_(inst_23466__$1,inst_23418);
var inst_23468 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23466__$1);
var state_23569__$1 = (function (){var statearr_23604 = state_23569;
(statearr_23604[(18)] = inst_23466__$1);

(statearr_23604[(14)] = inst_23461__$1);

(statearr_23604[(15)] = inst_23467);

return statearr_23604;
})();
if(cljs.core.truth_(inst_23468)){
var statearr_23605_23680 = state_23569__$1;
(statearr_23605_23680[(1)] = (31));

} else {
var statearr_23606_23681 = state_23569__$1;
(statearr_23606_23681[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (44))){
var inst_23507 = (state_23569[(20)]);
var state_23569__$1 = state_23569;
var statearr_23607_23682 = state_23569__$1;
(statearr_23607_23682[(2)] = inst_23507);

(statearr_23607_23682[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (6))){
var state_23569__$1 = state_23569;
var statearr_23608_23683 = state_23569__$1;
(statearr_23608_23683[(2)] = null);

(statearr_23608_23683[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (28))){
var inst_23452 = (state_23569[(13)]);
var state_23569__$1 = state_23569;
var statearr_23609_23684 = state_23569__$1;
(statearr_23609_23684[(2)] = inst_23452);

(statearr_23609_23684[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (51))){
var inst_23530 = (state_23569[(2)]);
var state_23569__$1 = state_23569;
var statearr_23610_23685 = state_23569__$1;
(statearr_23610_23685[(2)] = inst_23530);

(statearr_23610_23685[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (25))){
var inst_23432 = (state_23569[(9)]);
var inst_23443 = (state_23569[(2)]);
var inst_23444 = fluree.db.util.async.throw_err(inst_23443);
var inst_23445 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23432,inst_23444], 0));
var state_23569__$1 = state_23569;
var statearr_23611_23686 = state_23569__$1;
(statearr_23611_23686[(2)] = inst_23445);

(statearr_23611_23686[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (34))){
var inst_23451 = (state_23569[(11)]);
var inst_23470 = (state_23569[(19)]);
var inst_23453 = (state_23569[(12)]);
var inst_23473 = (state_23569[(2)]);
var inst_23474 = fluree.db.util.async.throw_err(inst_23473);
var inst_23475 = cljs.core.rest(inst_23451);
var inst_23476 = [inst_23474,inst_23475,inst_23453];
var inst_23477 = (new cljs.core.PersistentVector(null,3,(5),inst_23470,inst_23476,null));
var state_23569__$1 = state_23569;
var statearr_23612_23687 = state_23569__$1;
(statearr_23612_23687[(2)] = inst_23477);

(statearr_23612_23687[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (17))){
var inst_23418 = (state_23569[(7)]);
var inst_23422 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23418);
var state_23569__$1 = state_23569;
var statearr_23614_23688 = state_23569__$1;
(statearr_23614_23688[(2)] = inst_23422);

(statearr_23614_23688[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (3))){
var inst_23567 = (state_23569[(2)]);
var state_23569__$1 = state_23569;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23569__$1,inst_23567);
} else {
if((state_val_23570 === (12))){
var _ = (function (){var statearr_23615 = state_23569;
(statearr_23615[(4)] = cljs.core.rest((state_23569[(4)])));

return statearr_23615;
})();
var state_23569__$1 = state_23569;
var ex23613 = (state_23569__$1[(2)]);
var statearr_23616_23689 = state_23569__$1;
(statearr_23616_23689[(5)] = ex23613);


var statearr_23617_23690 = state_23569__$1;
(statearr_23617_23690[(1)] = (11));

(statearr_23617_23690[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (2))){
var _ = (function (){var statearr_23618 = state_23569;
(statearr_23618[(4)] = cljs.core.cons((5),(state_23569[(4)])));

return statearr_23618;
})();
var inst_23398 = cljs.core.not_empty(flakes);
var state_23569__$1 = state_23569;
if(cljs.core.truth_(inst_23398)){
var statearr_23619_23691 = state_23569__$1;
(statearr_23619_23691[(1)] = (6));

} else {
var statearr_23620_23692 = state_23569__$1;
(statearr_23620_23692[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (23))){
var inst_23432 = (state_23569[(9)]);
var state_23569__$1 = state_23569;
var statearr_23621_23693 = state_23569__$1;
(statearr_23621_23693[(2)] = inst_23432);

(statearr_23621_23693[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (47))){
var state_23569__$1 = state_23569;
var statearr_23622_23694 = state_23569__$1;
(statearr_23622_23694[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (35))){
var inst_23466 = (state_23569[(18)]);
var inst_23461 = (state_23569[(14)]);
var inst_23453 = (state_23569[(12)]);
var inst_23467 = (state_23569[(15)]);
var inst_23452 = (state_23569[(13)]);
var inst_23483 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_23452,inst_23466,inst_23461,inst_23467,false,inst_23453);
var state_23569__$1 = state_23569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23569__$1,(38),inst_23483);
} else {
if((state_val_23570 === (19))){
var inst_23412 = (state_23569[(10)]);
var inst_23426 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_23427 = [inst_23412];
var inst_23428 = cljs.core.PersistentHashMap.fromArrays(inst_23426,inst_23427);
var state_23569__$1 = state_23569;
var statearr_23624_23695 = state_23569__$1;
(statearr_23624_23695[(2)] = inst_23428);

(statearr_23624_23695[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (11))){
var inst_23400 = (state_23569[(2)]);
var inst_23401 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23400], 0));
var inst_23402 = (function(){throw inst_23400})();
var state_23569__$1 = (function (){var statearr_23626 = state_23569;
(statearr_23626[(21)] = inst_23401);

return statearr_23626;
})();
var statearr_23627_23696 = state_23569__$1;
(statearr_23627_23696[(2)] = inst_23402);

(statearr_23627_23696[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (9))){
var _ = (function (){var statearr_23628 = state_23569;
(statearr_23628[(4)] = cljs.core.cons((12),(state_23569[(4)])));

return statearr_23628;
})();
var inst_23408 = cljs.core.first(flakes);
var inst_23409 = fluree.db.query.fql.s(inst_23408);
var ___$1 = (function (){var statearr_23629 = state_23569;
(statearr_23629[(4)] = cljs.core.rest((state_23569[(4)])));

return statearr_23629;
})();
var state_23569__$1 = state_23569;
var statearr_23630_23697 = state_23569__$1;
(statearr_23630_23697[(2)] = inst_23409);

(statearr_23630_23697[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (5))){
var _ = (function (){var statearr_23631 = state_23569;
(statearr_23631[(4)] = cljs.core.rest((state_23569[(4)])));

return statearr_23631;
})();
var state_23569__$1 = state_23569;
var ex23625 = (state_23569__$1[(2)]);
var statearr_23632_23698 = state_23569__$1;
(statearr_23632_23698[(5)] = ex23625);


if((ex23625 instanceof Error)){
var statearr_23633_23699 = state_23569__$1;
(statearr_23633_23699[(1)] = (4));

(statearr_23633_23699[(5)] = null);

} else {
throw ex23625;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (14))){
var state_23569__$1 = state_23569;
var statearr_23634_23700 = state_23569__$1;
(statearr_23634_23700[(2)] = base_select_spec);

(statearr_23634_23700[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (45))){
var inst_23512 = (state_23569[(2)]);
var state_23569__$1 = state_23569;
if(cljs.core.truth_(inst_23512)){
var statearr_23635_23701 = state_23569__$1;
(statearr_23635_23701[(1)] = (46));

} else {
var statearr_23636_23702 = state_23569__$1;
(statearr_23636_23702[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (26))){
var inst_23451 = (state_23569[(11)]);
var inst_23455 = cljs.core.empty_QMARK_(inst_23451);
var state_23569__$1 = state_23569;
if(inst_23455){
var statearr_23637_23703 = state_23569__$1;
(statearr_23637_23703[(1)] = (28));

} else {
var statearr_23638_23704 = state_23569__$1;
(statearr_23638_23704[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (16))){
var inst_23419 = (state_23569[(17)]);
var state_23569__$1 = state_23569;
var statearr_23639_23705 = state_23569__$1;
(statearr_23639_23705[(2)] = inst_23419);

(statearr_23639_23705[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (38))){
var inst_23451 = (state_23569[(11)]);
var inst_23485 = (state_23569[(2)]);
var inst_23486 = fluree.db.util.async.throw_err(inst_23485);
var inst_23487 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23486,(0),null);
var inst_23488 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23486,(1),null);
var inst_23489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23490 = cljs.core.rest(inst_23451);
var inst_23491 = [inst_23487,inst_23490,inst_23488];
var inst_23492 = (new cljs.core.PersistentVector(null,3,(5),inst_23489,inst_23491,null));
var state_23569__$1 = state_23569;
var statearr_23640_23706 = state_23569__$1;
(statearr_23640_23706[(2)] = inst_23492);

(statearr_23640_23706[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (30))){
var inst_23546 = (state_23569[(2)]);
var state_23569__$1 = state_23569;
var statearr_23641_23707 = state_23569__$1;
(statearr_23641_23707[(2)] = inst_23546);

(statearr_23641_23707[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (10))){
var inst_23412 = (state_23569[(2)]);
var inst_23413 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_23569__$1 = (function (){var statearr_23642 = state_23569;
(statearr_23642[(10)] = inst_23412);

return statearr_23642;
})();
if(cljs.core.truth_(inst_23413)){
var statearr_23643_23708 = state_23569__$1;
(statearr_23643_23708[(1)] = (13));

} else {
var statearr_23644_23709 = state_23569__$1;
(statearr_23644_23709[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (18))){
var inst_23424 = (state_23569[(2)]);
var state_23569__$1 = state_23569;
if(cljs.core.truth_(inst_23424)){
var statearr_23645_23710 = state_23569__$1;
(statearr_23645_23710[(1)] = (19));

} else {
var statearr_23646_23711 = state_23569__$1;
(statearr_23646_23711[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (42))){
var inst_23451 = (state_23569[(11)]);
var inst_23496 = (state_23569[(16)]);
var inst_23453 = (state_23569[(12)]);
var inst_23499 = (state_23569[(2)]);
var inst_23500 = fluree.db.util.async.throw_err(inst_23499);
var inst_23501 = cljs.core.first(inst_23500);
var inst_23502 = cljs.core.rest(inst_23451);
var inst_23503 = [inst_23501,inst_23502,inst_23453];
var inst_23504 = (new cljs.core.PersistentVector(null,3,(5),inst_23496,inst_23503,null));
var state_23569__$1 = state_23569;
var statearr_23647_23712 = state_23569__$1;
(statearr_23647_23712[(2)] = inst_23504);

(statearr_23647_23712[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (37))){
var inst_23536 = (state_23569[(2)]);
var state_23569__$1 = state_23569;
var statearr_23648_23713 = state_23569__$1;
(statearr_23648_23713[(2)] = inst_23536);

(statearr_23648_23713[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (8))){
var inst_23564 = (state_23569[(2)]);
var _ = (function (){var statearr_23649 = state_23569;
(statearr_23649[(4)] = cljs.core.rest((state_23569[(4)])));

return statearr_23649;
})();
var state_23569__$1 = state_23569;
var statearr_23650_23714 = state_23569__$1;
(statearr_23650_23714[(2)] = inst_23564);

(statearr_23650_23714[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23570 === (49))){
var inst_23451 = (state_23569[(11)]);
var inst_23453 = (state_23569[(12)]);
var inst_23452 = (state_23569[(13)]);
var inst_23524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23525 = cljs.core.rest(inst_23451);
var inst_23526 = [inst_23452,inst_23525,inst_23453];
var inst_23527 = (new cljs.core.PersistentVector(null,3,(5),inst_23524,inst_23526,null));
var state_23569__$1 = state_23569;
var statearr_23651_23715 = state_23569__$1;
(statearr_23651_23715[(2)] = inst_23527);

(statearr_23651_23715[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto____0 = (function (){
var statearr_23652 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23652[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto__);

(statearr_23652[(1)] = (1));

return statearr_23652;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto____1 = (function (state_23569){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_23569);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e23653){var ex__2736__auto__ = e23653;
var statearr_23654_23716 = state_23569;
(statearr_23654_23716[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_23569[(4)]))){
var statearr_23655_23717 = state_23569;
(statearr_23655_23717[(1)] = cljs.core.first((state_23569[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23718 = state_23569;
state_23569 = G__23718;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto__ = function(state_23569){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto____1.call(this,state_23569);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_23656 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_23656[(6)] = c__2755__auto__);

return statearr_23656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23721 = arguments.length;
switch (G__23721) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_23763){
var state_val_23764 = (state_23763[(1)]);
if((state_val_23764 === (7))){
var inst_23729 = (state_23763[(7)]);
var state_23763__$1 = state_23763;
var statearr_23765_23795 = state_23763__$1;
(statearr_23765_23795[(2)] = inst_23729);

(statearr_23765_23795[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (1))){
var state_23763__$1 = state_23763;
var statearr_23766_23796 = state_23763__$1;
(statearr_23766_23796[(2)] = null);

(statearr_23766_23796[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (4))){
var inst_23722 = (state_23763[(2)]);
var state_23763__$1 = state_23763;
var statearr_23767_23797 = state_23763__$1;
(statearr_23767_23797[(2)] = inst_23722);

(statearr_23767_23797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (15))){
var inst_23757 = (state_23763[(2)]);
var inst_23758 = fluree.db.util.async.throw_err(inst_23757);
var _ = (function (){var statearr_23768 = state_23763;
(statearr_23768[(4)] = cljs.core.rest((state_23763[(4)])));

return statearr_23768;
})();
var state_23763__$1 = state_23763;
var statearr_23769_23798 = state_23763__$1;
(statearr_23769_23798[(2)] = inst_23758);

(statearr_23769_23798[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (13))){
var inst_23741 = (state_23763[(8)]);
var state_23763__$1 = state_23763;
var statearr_23770_23799 = state_23763__$1;
(statearr_23770_23799[(2)] = inst_23741);

(statearr_23770_23799[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (6))){
var inst_23729 = (state_23763[(7)]);
var inst_23731 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_23732 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23729,inst_23731);
var state_23763__$1 = state_23763;
var statearr_23771_23800 = state_23763__$1;
(statearr_23771_23800[(2)] = inst_23732);

(statearr_23771_23800[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (3))){
var inst_23761 = (state_23763[(2)]);
var state_23763__$1 = state_23763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23763__$1,inst_23761);
} else {
if((state_val_23764 === (12))){
var inst_23741 = (state_23763[(8)]);
var inst_23743 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_23744 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23741,inst_23743);
var state_23763__$1 = state_23763;
var statearr_23772_23801 = state_23763__$1;
(statearr_23772_23801[(2)] = inst_23744);

(statearr_23772_23801[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (2))){
var _ = (function (){var statearr_23773 = state_23763;
(statearr_23773[(4)] = cljs.core.cons((5),(state_23763[(4)])));

return statearr_23773;
})();
var inst_23729 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_23763__$1 = (function (){var statearr_23774 = state_23763;
(statearr_23774[(7)] = inst_23729);

return statearr_23774;
})();
if(cljs.core.truth_(fuel)){
var statearr_23775_23802 = state_23763__$1;
(statearr_23775_23802[(1)] = (6));

} else {
var statearr_23776_23803 = state_23763__$1;
(statearr_23776_23803[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (11))){
var inst_23741 = (state_23763[(2)]);
var state_23763__$1 = (function (){var statearr_23778 = state_23763;
(statearr_23778[(8)] = inst_23741);

return statearr_23778;
})();
if(cljs.core.truth_(limit)){
var statearr_23779_23804 = state_23763__$1;
(statearr_23779_23804[(1)] = (12));

} else {
var statearr_23780_23805 = state_23763__$1;
(statearr_23780_23805[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (9))){
var inst_23735 = (state_23763[(9)]);
var inst_23737 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_23738 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23735,inst_23737);
var state_23763__$1 = state_23763;
var statearr_23781_23806 = state_23763__$1;
(statearr_23781_23806[(2)] = inst_23738);

(statearr_23781_23806[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (5))){
var _ = (function (){var statearr_23782 = state_23763;
(statearr_23782[(4)] = cljs.core.rest((state_23763[(4)])));

return statearr_23782;
})();
var state_23763__$1 = state_23763;
var ex23777 = (state_23763__$1[(2)]);
var statearr_23783_23807 = state_23763__$1;
(statearr_23783_23807[(5)] = ex23777);


if((ex23777 instanceof Error)){
var statearr_23784_23808 = state_23763__$1;
(statearr_23784_23808[(1)] = (4));

(statearr_23784_23808[(5)] = null);

} else {
throw ex23777;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (14))){
var inst_23747 = (state_23763[(2)]);
var inst_23748 = (function (){return (function (x){
var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4221__auto__;
}
});
})();
var inst_23749 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_23748);
var inst_23750 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23747,inst_23749);
var inst_23751 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23750,flakes);
var inst_23752 = cljs.core.PersistentVector.EMPTY;
var inst_23753 = (function (){var xf = inst_23750;
var flakes_by_sub = inst_23751;
return (function (p1__23719_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__23719_SHARP_);
});
})();
var inst_23754 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23753,inst_23751);
var inst_23755 = fluree.db.util.async.merge_into_QMARK_(inst_23752,inst_23754);
var state_23763__$1 = state_23763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23763__$1,(15),inst_23755);
} else {
if((state_val_23764 === (10))){
var inst_23735 = (state_23763[(9)]);
var state_23763__$1 = state_23763;
var statearr_23785_23809 = state_23763__$1;
(statearr_23785_23809[(2)] = inst_23735);

(statearr_23785_23809[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23764 === (8))){
var inst_23735 = (state_23763[(2)]);
var state_23763__$1 = (function (){var statearr_23786 = state_23763;
(statearr_23786[(9)] = inst_23735);

return statearr_23786;
})();
if(cljs.core.truth_(offset)){
var statearr_23787_23810 = state_23763__$1;
(statearr_23787_23810[(1)] = (9));

} else {
var statearr_23788_23811 = state_23763__$1;
(statearr_23788_23811[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2733__auto__ = null;
var fluree$db$query$fql$state_machine__2733__auto____0 = (function (){
var statearr_23789 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23789[(0)] = fluree$db$query$fql$state_machine__2733__auto__);

(statearr_23789[(1)] = (1));

return statearr_23789;
});
var fluree$db$query$fql$state_machine__2733__auto____1 = (function (state_23763){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_23763);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e23790){var ex__2736__auto__ = e23790;
var statearr_23791_23812 = state_23763;
(statearr_23791_23812[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_23763[(4)]))){
var statearr_23792_23813 = state_23763;
(statearr_23792_23813[(1)] = cljs.core.first((state_23763[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23814 = state_23763;
state_23763 = G__23814;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2733__auto__ = function(state_23763){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2733__auto____1.call(this,state_23763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2733__auto____0;
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2733__auto____1;
return fluree$db$query$fql$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_23793 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_23793[(6)] = c__2755__auto__);

return statearr_23793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23816 = arguments.length;
switch (G__23816) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_23897){
var state_val_23898 = (state_23897[(1)]);
if((state_val_23898 === (7))){
var inst_23892 = (state_23897[(2)]);
var _ = (function (){var statearr_23900 = state_23897;
(statearr_23900[(4)] = cljs.core.rest((state_23897[(4)])));

return statearr_23900;
})();
var state_23897__$1 = state_23897;
var statearr_23901_23948 = state_23897__$1;
(statearr_23901_23948[(2)] = inst_23892);

(statearr_23901_23948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (20))){
var inst_23836 = (state_23897[(7)]);
var inst_23837 = (state_23897[(8)]);
var inst_23844 = (state_23897[(9)]);
var inst_23865 = (inst_23836 + (1));
var tmp23899 = inst_23837;
var inst_23835 = inst_23844;
var inst_23836__$1 = inst_23865;
var inst_23837__$1 = tmp23899;
var state_23897__$1 = (function (){var statearr_23902 = state_23897;
(statearr_23902[(7)] = inst_23836__$1);

(statearr_23902[(8)] = inst_23837__$1);

(statearr_23902[(10)] = inst_23835);

return statearr_23902;
})();
var statearr_23903_23949 = state_23897__$1;
(statearr_23903_23949[(2)] = null);

(statearr_23903_23949[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (27))){
var inst_23870 = (state_23897[(11)]);
var inst_23876 = (state_23897[(2)]);
var inst_23877 = fluree.db.util.async.throw_err(inst_23876);
var inst_23878 = (inst_23870.cljs$core$IFn$_invoke$arity$1 ? inst_23870.cljs$core$IFn$_invoke$arity$1(inst_23877) : inst_23870.call(null,inst_23877));
var state_23897__$1 = state_23897;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23897__$1,(26),inst_23878);
} else {
if((state_val_23898 === (1))){
var state_23897__$1 = state_23897;
var statearr_23904_23950 = state_23897__$1;
(statearr_23904_23950[(2)] = null);

(statearr_23904_23950[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (24))){
var state_23897__$1 = state_23897;
var statearr_23905_23951 = state_23897__$1;
(statearr_23905_23951[(2)] = null);

(statearr_23905_23951[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (4))){
var inst_23817 = (state_23897[(2)]);
var state_23897__$1 = state_23897;
var statearr_23906_23952 = state_23897__$1;
(statearr_23906_23952[(2)] = inst_23817);

(statearr_23906_23952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (15))){
var inst_23858 = (state_23897[(12)]);
var inst_23858__$1 = offset;
var state_23897__$1 = (function (){var statearr_23907 = state_23897;
(statearr_23907[(12)] = inst_23858__$1);

return statearr_23907;
})();
if(cljs.core.truth_(inst_23858__$1)){
var statearr_23908_23953 = state_23897__$1;
(statearr_23908_23953[(1)] = (17));

} else {
var statearr_23909_23954 = state_23897__$1;
(statearr_23909_23954[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (21))){
var state_23897__$1 = state_23897;
var statearr_23910_23955 = state_23897__$1;
(statearr_23910_23955[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (13))){
var inst_23853 = (state_23897[(2)]);
var state_23897__$1 = state_23897;
var statearr_23912_23956 = state_23897__$1;
(statearr_23912_23956[(2)] = inst_23853);

(statearr_23912_23956[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (22))){
var inst_23888 = (state_23897[(2)]);
var state_23897__$1 = state_23897;
var statearr_23913_23957 = state_23897__$1;
(statearr_23913_23957[(2)] = inst_23888);

(statearr_23913_23957[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (6))){
var inst_23845 = (state_23897[(13)]);
var inst_23843 = (state_23897[(14)]);
var inst_23835 = (state_23897[(10)]);
var inst_23842 = cljs.core.seq(inst_23835);
var inst_23843__$1 = cljs.core.first(inst_23842);
var inst_23844 = cljs.core.next(inst_23842);
var inst_23845__$1 = (inst_23843__$1 == null);
var state_23897__$1 = (function (){var statearr_23914 = state_23897;
(statearr_23914[(13)] = inst_23845__$1);

(statearr_23914[(14)] = inst_23843__$1);

(statearr_23914[(9)] = inst_23844);

return statearr_23914;
})();
if(cljs.core.truth_(inst_23845__$1)){
var statearr_23915_23958 = state_23897__$1;
(statearr_23915_23958[(1)] = (8));

} else {
var statearr_23916_23959 = state_23897__$1;
(statearr_23916_23959[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (25))){
var inst_23886 = (state_23897[(2)]);
var state_23897__$1 = state_23897;
var statearr_23917_23960 = state_23897__$1;
(statearr_23917_23960[(2)] = inst_23886);

(statearr_23917_23960[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (17))){
var inst_23836 = (state_23897[(7)]);
var inst_23860 = (inst_23836 < offset);
var state_23897__$1 = state_23897;
var statearr_23918_23961 = state_23897__$1;
(statearr_23918_23961[(2)] = inst_23860);

(statearr_23918_23961[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (3))){
var inst_23895 = (state_23897[(2)]);
var state_23897__$1 = state_23897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23897__$1,inst_23895);
} else {
if((state_val_23898 === (12))){
var inst_23848 = (state_23897[(15)]);
var state_23897__$1 = state_23897;
var statearr_23919_23962 = state_23897__$1;
(statearr_23919_23962[(2)] = inst_23848);

(statearr_23919_23962[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (2))){
var inst_23830 = (state_23897[(16)]);
var _ = (function (){var statearr_23920 = state_23897;
(statearr_23920[(4)] = cljs.core.cons((5),(state_23897[(4)])));

return statearr_23920;
})();
var inst_23830__$1 = subjects;
var inst_23831 = cljs.core.seq(inst_23830__$1);
var inst_23832 = cljs.core.first(inst_23831);
var inst_23833 = cljs.core.next(inst_23831);
var inst_23834 = cljs.core.PersistentVector.EMPTY;
var inst_23835 = inst_23830__$1;
var inst_23836 = (0);
var inst_23837 = inst_23834;
var state_23897__$1 = (function (){var statearr_23921 = state_23897;
(statearr_23921[(17)] = inst_23832);

(statearr_23921[(18)] = inst_23833);

(statearr_23921[(7)] = inst_23836);

(statearr_23921[(8)] = inst_23837);

(statearr_23921[(16)] = inst_23830__$1);

(statearr_23921[(10)] = inst_23835);

return statearr_23921;
})();
var statearr_23922_23963 = state_23897__$1;
(statearr_23922_23963[(2)] = null);

(statearr_23922_23963[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (23))){
var inst_23832 = (state_23897[(17)]);
var inst_23833 = (state_23897[(18)]);
var inst_23836 = (state_23897[(7)]);
var inst_23843 = (state_23897[(14)]);
var inst_23837 = (state_23897[(8)]);
var inst_23830 = (state_23897[(16)]);
var inst_23844 = (state_23897[(9)]);
var inst_23835 = (state_23897[(10)]);
var inst_23869 = (inst_23836 + (1));
var inst_23870 = (function (){var seq__23840 = inst_23844;
var first__23829 = inst_23832;
var r = inst_23844;
var acc = inst_23837;
var n = inst_23836;
var s = inst_23843;
var vec__23839 = inst_23835;
var first__23841 = inst_23843;
var seq__23828 = inst_23833;
var G__23826 = inst_23835;
var vec__23827 = inst_23830;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_23871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23872 = [inst_23843];
var inst_23873 = (new cljs.core.PersistentVector(null,1,(5),inst_23871,inst_23872,null));
var inst_23874 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23873);
var state_23897__$1 = (function (){var statearr_23923 = state_23897;
(statearr_23923[(19)] = inst_23869);

(statearr_23923[(11)] = inst_23870);

return statearr_23923;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23897__$1,(27),inst_23874);
} else {
if((state_val_23898 === (19))){
var inst_23863 = (state_23897[(2)]);
var state_23897__$1 = state_23897;
if(cljs.core.truth_(inst_23863)){
var statearr_23924_23964 = state_23897__$1;
(statearr_23924_23964[(1)] = (20));

} else {
var statearr_23925_23965 = state_23897__$1;
(statearr_23925_23965[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (11))){
var inst_23836 = (state_23897[(7)]);
var inst_23850 = (inst_23836 > limit);
var state_23897__$1 = state_23897;
var statearr_23927_23966 = state_23897__$1;
(statearr_23927_23966[(2)] = inst_23850);

(statearr_23927_23966[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (9))){
var inst_23848 = (state_23897[(15)]);
var inst_23848__$1 = limit;
var state_23897__$1 = (function (){var statearr_23928 = state_23897;
(statearr_23928[(15)] = inst_23848__$1);

return statearr_23928;
})();
if(cljs.core.truth_(inst_23848__$1)){
var statearr_23929_23967 = state_23897__$1;
(statearr_23929_23967[(1)] = (11));

} else {
var statearr_23930_23968 = state_23897__$1;
(statearr_23930_23968[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (5))){
var _ = (function (){var statearr_23931 = state_23897;
(statearr_23931[(4)] = cljs.core.rest((state_23897[(4)])));

return statearr_23931;
})();
var state_23897__$1 = state_23897;
var ex23926 = (state_23897__$1[(2)]);
var statearr_23932_23969 = state_23897__$1;
(statearr_23932_23969[(5)] = ex23926);


if((ex23926 instanceof Error)){
var statearr_23933_23970 = state_23897__$1;
(statearr_23933_23970[(1)] = (4));

(statearr_23933_23970[(5)] = null);

} else {
throw ex23926;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (14))){
var inst_23837 = (state_23897[(8)]);
var state_23897__$1 = state_23897;
var statearr_23934_23971 = state_23897__$1;
(statearr_23934_23971[(2)] = inst_23837);

(statearr_23934_23971[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (26))){
var inst_23869 = (state_23897[(19)]);
var inst_23837 = (state_23897[(8)]);
var inst_23844 = (state_23897[(9)]);
var inst_23880 = (state_23897[(2)]);
var inst_23881 = fluree.db.util.async.throw_err(inst_23880);
var inst_23882 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23837,inst_23881);
var inst_23835 = inst_23844;
var inst_23836 = inst_23869;
var inst_23837__$1 = inst_23882;
var state_23897__$1 = (function (){var statearr_23935 = state_23897;
(statearr_23935[(7)] = inst_23836);

(statearr_23935[(8)] = inst_23837__$1);

(statearr_23935[(10)] = inst_23835);

return statearr_23935;
})();
var statearr_23936_23972 = state_23897__$1;
(statearr_23936_23972[(2)] = null);

(statearr_23936_23972[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (16))){
var inst_23890 = (state_23897[(2)]);
var state_23897__$1 = state_23897;
var statearr_23937_23973 = state_23897__$1;
(statearr_23937_23973[(2)] = inst_23890);

(statearr_23937_23973[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (10))){
var inst_23855 = (state_23897[(2)]);
var state_23897__$1 = state_23897;
if(cljs.core.truth_(inst_23855)){
var statearr_23938_23974 = state_23897__$1;
(statearr_23938_23974[(1)] = (14));

} else {
var statearr_23939_23975 = state_23897__$1;
(statearr_23939_23975[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (18))){
var inst_23858 = (state_23897[(12)]);
var state_23897__$1 = state_23897;
var statearr_23940_23976 = state_23897__$1;
(statearr_23940_23976[(2)] = inst_23858);

(statearr_23940_23976[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23898 === (8))){
var inst_23845 = (state_23897[(13)]);
var state_23897__$1 = state_23897;
var statearr_23941_23977 = state_23897__$1;
(statearr_23941_23977[(2)] = inst_23845);

(statearr_23941_23977[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2733__auto__ = null;
var fluree$db$query$fql$state_machine__2733__auto____0 = (function (){
var statearr_23942 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23942[(0)] = fluree$db$query$fql$state_machine__2733__auto__);

(statearr_23942[(1)] = (1));

return statearr_23942;
});
var fluree$db$query$fql$state_machine__2733__auto____1 = (function (state_23897){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_23897);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e23943){var ex__2736__auto__ = e23943;
var statearr_23944_23978 = state_23897;
(statearr_23944_23978[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_23897[(4)]))){
var statearr_23945_23979 = state_23897;
(statearr_23945_23979[(1)] = cljs.core.first((state_23897[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23980 = state_23897;
state_23897 = G__23980;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2733__auto__ = function(state_23897){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2733__auto____1.call(this,state_23897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2733__auto____0;
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2733__auto____1;
return fluree$db$query$fql$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_23946 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_23946[(6)] = c__2755__auto__);

return statearr_23946;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4223__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__23982 = arguments.length;
switch (G__23982) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_24173){
var state_val_24174 = (state_24173[(1)]);
if((state_val_24174 === (7))){
var state_24173__$1 = state_24173;
var statearr_24175_24250 = state_24173__$1;
(statearr_24175_24250[(2)] = null);

(statearr_24175_24250[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (20))){
var inst_24023 = (state_24173[(7)]);
var inst_24025 = (state_24173[(8)]);
var inst_24053 = (state_24173[(2)]);
var inst_24054 = fluree.db.util.async.throw_err(inst_24053);
var inst_24055 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24056 = [inst_24023];
var inst_24057 = (new cljs.core.PersistentVector(null,1,(5),inst_24055,inst_24056,null));
var inst_24058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24059 = [inst_24023,inst_24025];
var inst_24060 = (new cljs.core.PersistentVector(null,2,(5),inst_24058,inst_24059,null));
var inst_24061 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24057,cljs.core._LT_,inst_24060);
var state_24173__$1 = (function (){var statearr_24176 = state_24173;
(statearr_24176[(9)] = inst_24054);

return statearr_24176;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24173__$1,(21),inst_24061);
} else {
if((state_val_24174 === (27))){
var inst_24024 = (state_24173[(10)]);
var inst_24042 = (state_24173[(11)]);
var inst_24090 = (inst_24042.cljs$core$IFn$_invoke$arity$2 ? inst_24042.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_24024) : inst_24042.call(null,cljs.core._GT__EQ_,inst_24024));
var state_24173__$1 = state_24173;
if(cljs.core.truth_(inst_24090)){
var statearr_24177_24251 = state_24173__$1;
(statearr_24177_24251[(1)] = (30));

} else {
var statearr_24178_24252 = state_24173__$1;
(statearr_24178_24252[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (1))){
var state_24173__$1 = state_24173;
var statearr_24179_24253 = state_24173__$1;
(statearr_24179_24253[(2)] = null);

(statearr_24179_24253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (24))){
var inst_24139 = (state_24173[(2)]);
var state_24173__$1 = state_24173;
var statearr_24180_24254 = state_24173__$1;
(statearr_24180_24254[(2)] = inst_24139);

(statearr_24180_24254[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (39))){
var inst_24129 = null;
var state_24173__$1 = state_24173;
var statearr_24181_24255 = state_24173__$1;
(statearr_24181_24255[(2)] = inst_24129);

(statearr_24181_24255[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (46))){
var inst_24151 = (state_24173[(12)]);
var state_24173__$1 = state_24173;
var statearr_24182_24256 = state_24173__$1;
(statearr_24182_24256[(2)] = inst_24151);

(statearr_24182_24256[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (4))){
var inst_23983 = (state_24173[(2)]);
var state_24173__$1 = state_24173;
var statearr_24183_24257 = state_24173__$1;
(statearr_24183_24257[(2)] = inst_23983);

(statearr_24183_24257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (15))){
var state_24173__$1 = state_24173;
var statearr_24184_24258 = state_24173__$1;
(statearr_24184_24258[(2)] = null);

(statearr_24184_24258[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (48))){
var inst_24150 = (state_24173[(13)]);
var state_24173__$1 = state_24173;
var statearr_24185_24259 = state_24173__$1;
(statearr_24185_24259[(2)] = inst_24150);

(statearr_24185_24259[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (50))){
var inst_24161 = (state_24173[(2)]);
var state_24173__$1 = state_24173;
var statearr_24186_24260 = state_24173__$1;
(statearr_24186_24260[(2)] = inst_24161);

(statearr_24186_24260[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (21))){
var inst_24054 = (state_24173[(9)]);
var inst_24063 = (state_24173[(2)]);
var inst_24064 = fluree.db.util.async.throw_err(inst_24063);
var inst_24065 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_24054,inst_24064);
var state_24173__$1 = state_24173;
var statearr_24187_24261 = state_24173__$1;
(statearr_24187_24261[(2)] = inst_24065);

(statearr_24187_24261[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (31))){
var inst_24024 = (state_24173[(10)]);
var inst_24042 = (state_24173[(11)]);
var inst_24103 = (inst_24042.cljs$core$IFn$_invoke$arity$2 ? inst_24042.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_24024) : inst_24042.call(null,cljs.core._LT_,inst_24024));
var state_24173__$1 = state_24173;
if(cljs.core.truth_(inst_24103)){
var statearr_24188_24262 = state_24173__$1;
(statearr_24188_24262[(1)] = (34));

} else {
var statearr_24189_24263 = state_24173__$1;
(statearr_24189_24263[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (32))){
var inst_24135 = (state_24173[(2)]);
var state_24173__$1 = state_24173;
var statearr_24190_24264 = state_24173__$1;
(statearr_24190_24264[(2)] = inst_24135);

(statearr_24190_24264[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (40))){
var inst_24131 = (state_24173[(2)]);
var state_24173__$1 = state_24173;
var statearr_24191_24265 = state_24173__$1;
(statearr_24191_24265[(2)] = inst_24131);

(statearr_24191_24265[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (33))){
var inst_24100 = (state_24173[(2)]);
var inst_24101 = fluree.db.util.async.throw_err(inst_24100);
var state_24173__$1 = state_24173;
var statearr_24192_24266 = state_24173__$1;
(statearr_24192_24266[(2)] = inst_24101);

(statearr_24192_24266[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (13))){
var inst_24163 = (state_24173[(2)]);
var state_24173__$1 = state_24173;
var statearr_24193_24267 = state_24173__$1;
(statearr_24193_24267[(2)] = inst_24163);

(statearr_24193_24267[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (22))){
var inst_24023 = (state_24173[(7)]);
var inst_24025 = (state_24173[(8)]);
var inst_24069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24070 = [inst_24023,inst_24025];
var inst_24071 = (new cljs.core.PersistentVector(null,2,(5),inst_24069,inst_24070,null));
var inst_24072 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_24071);
var state_24173__$1 = state_24173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24173__$1,(25),inst_24072);
} else {
if((state_val_24174 === (36))){
var inst_24133 = (state_24173[(2)]);
var state_24173__$1 = state_24173;
var statearr_24194_24268 = state_24173__$1;
(statearr_24194_24268[(2)] = inst_24133);

(statearr_24194_24268[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (41))){
var inst_24126 = (state_24173[(2)]);
var inst_24127 = fluree.db.util.async.throw_err(inst_24126);
var state_24173__$1 = state_24173;
var statearr_24195_24269 = state_24173__$1;
(statearr_24195_24269[(2)] = inst_24127);

(statearr_24195_24269[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (43))){
var inst_24142 = (state_24173[(14)]);
var inst_24009 = (state_24173[(15)]);
var inst_24143 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24009,inst_24142);
var state_24173__$1 = state_24173;
var statearr_24196_24270 = state_24173__$1;
(statearr_24196_24270[(2)] = inst_24143);

(statearr_24196_24270[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (29))){
var inst_24087 = (state_24173[(2)]);
var inst_24088 = fluree.db.util.async.throw_err(inst_24087);
var state_24173__$1 = state_24173;
var statearr_24197_24271 = state_24173__$1;
(statearr_24197_24271[(2)] = inst_24088);

(statearr_24197_24271[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (44))){
var inst_24142 = (state_24173[(14)]);
var inst_24009 = (state_24173[(15)]);
var inst_24145 = cljs.core.PersistentHashSet.EMPTY;
var inst_24146 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24145,inst_24142);
var inst_24147 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_24009,inst_24146);
var state_24173__$1 = state_24173;
var statearr_24198_24272 = state_24173__$1;
(statearr_24198_24272[(2)] = inst_24147);

(statearr_24198_24272[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (6))){
var inst_23994 = (state_24173[(16)]);
var inst_24004 = cljs.core.seq(inst_23994);
var inst_24005 = cljs.core.first(inst_24004);
var inst_24006 = cljs.core.next(inst_24004);
var inst_24007 = cljs.core.PersistentHashSet.EMPTY;
var inst_24008 = inst_23994;
var inst_24009 = inst_24007;
var state_24173__$1 = (function (){var statearr_24199 = state_24173;
(statearr_24199[(17)] = inst_24008);

(statearr_24199[(18)] = inst_24006);

(statearr_24199[(19)] = inst_24005);

(statearr_24199[(15)] = inst_24009);

return statearr_24199;
})();
var statearr_24200_24273 = state_24173__$1;
(statearr_24200_24273[(2)] = null);

(statearr_24200_24273[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (28))){
var inst_24137 = (state_24173[(2)]);
var state_24173__$1 = state_24173;
var statearr_24201_24274 = state_24173__$1;
(statearr_24201_24274[(2)] = inst_24137);

(statearr_24201_24274[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (25))){
var inst_24074 = (state_24173[(2)]);
var inst_24075 = fluree.db.util.async.throw_err(inst_24074);
var state_24173__$1 = state_24173;
var statearr_24202_24275 = state_24173__$1;
(statearr_24202_24275[(2)] = inst_24075);

(statearr_24202_24275[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (34))){
var inst_24023 = (state_24173[(7)]);
var inst_24025 = (state_24173[(8)]);
var inst_24105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24106 = [inst_24023];
var inst_24107 = (new cljs.core.PersistentVector(null,1,(5),inst_24105,inst_24106,null));
var inst_24108 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24109 = [inst_24023,inst_24025];
var inst_24110 = (new cljs.core.PersistentVector(null,2,(5),inst_24108,inst_24109,null));
var inst_24111 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24107,cljs.core._LT_,inst_24110);
var state_24173__$1 = state_24173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24173__$1,(37),inst_24111);
} else {
if((state_val_24174 === (17))){
var inst_24023 = (state_24173[(7)]);
var inst_24025 = (state_24173[(8)]);
var inst_24045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24046 = [inst_24023,inst_24025];
var inst_24047 = (new cljs.core.PersistentVector(null,2,(5),inst_24045,inst_24046,null));
var inst_24048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24049 = [inst_24023];
var inst_24050 = (new cljs.core.PersistentVector(null,1,(5),inst_24048,inst_24049,null));
var inst_24051 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24047,cljs.core._LT__EQ_,inst_24050);
var state_24173__$1 = state_24173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24173__$1,(20),inst_24051);
} else {
if((state_val_24174 === (3))){
var inst_24171 = (state_24173[(2)]);
var state_24173__$1 = state_24173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24173__$1,inst_24171);
} else {
if((state_val_24174 === (12))){
var inst_24023 = (state_24173[(7)]);
var inst_24015 = (state_24173[(20)]);
var inst_24023__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24015,(0),null);
var inst_24024 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24015,(1),null);
var inst_24025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_24015,(2),null);
var inst_24026 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_24023__$1);
var inst_24027 = cljs.core.not(inst_24026);
var state_24173__$1 = (function (){var statearr_24203 = state_24173;
(statearr_24203[(7)] = inst_24023__$1);

(statearr_24203[(8)] = inst_24025);

(statearr_24203[(10)] = inst_24024);

return statearr_24203;
})();
if(inst_24027){
var statearr_24204_24276 = state_24173__$1;
(statearr_24204_24276[(1)] = (14));

} else {
var statearr_24205_24277 = state_24173__$1;
(statearr_24205_24277[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (2))){
var inst_23994 = (state_24173[(16)]);
var _ = (function (){var statearr_24206 = state_24173;
(statearr_24206[(4)] = cljs.core.cons((5),(state_24173[(4)])));

return statearr_24206;
})();
var inst_23992 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_23993 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23992,(0),null);
var inst_23994__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23992,(1),null);
var inst_23995 = cljs.core.not_empty(inst_23994__$1);
var state_24173__$1 = (function (){var statearr_24207 = state_24173;
(statearr_24207[(21)] = inst_23993);

(statearr_24207[(16)] = inst_23994__$1);

return statearr_24207;
})();
if(cljs.core.truth_(inst_23995)){
var statearr_24208_24278 = state_24173__$1;
(statearr_24208_24278[(1)] = (6));

} else {
var statearr_24209_24279 = state_24173__$1;
(statearr_24209_24279[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (23))){
var inst_24024 = (state_24173[(10)]);
var inst_24042 = (state_24173[(11)]);
var inst_24077 = (inst_24042.cljs$core$IFn$_invoke$arity$2 ? inst_24042.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_24024) : inst_24042.call(null,cljs.core._GT_,inst_24024));
var state_24173__$1 = state_24173;
if(cljs.core.truth_(inst_24077)){
var statearr_24210_24280 = state_24173__$1;
(statearr_24210_24280[(1)] = (26));

} else {
var statearr_24211_24281 = state_24173__$1;
(statearr_24211_24281[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (47))){
var inst_24156 = (state_24173[(2)]);
var state_24173__$1 = state_24173;
if(cljs.core.truth_(inst_24156)){
var statearr_24212_24282 = state_24173__$1;
(statearr_24212_24282[(1)] = (48));

} else {
var statearr_24213_24283 = state_24173__$1;
(statearr_24213_24283[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (35))){
var inst_24024 = (state_24173[(10)]);
var inst_24042 = (state_24173[(11)]);
var inst_24116 = (inst_24042.cljs$core$IFn$_invoke$arity$2 ? inst_24042.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_24024) : inst_24042.call(null,cljs.core._LT__EQ_,inst_24024));
var state_24173__$1 = state_24173;
if(cljs.core.truth_(inst_24116)){
var statearr_24214_24284 = state_24173__$1;
(statearr_24214_24284[(1)] = (38));

} else {
var statearr_24215_24285 = state_24173__$1;
(statearr_24215_24285[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (19))){
var inst_23993 = (state_24173[(21)]);
var inst_24141 = (state_24173[(2)]);
var inst_24142 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_24141);
var state_24173__$1 = (function (){var statearr_24216 = state_24173;
(statearr_24216[(14)] = inst_24142);

return statearr_24216;
})();
var G__24217_24286 = inst_23993;
var G__24217_24287__$1 = (((G__24217_24286 instanceof cljs.core.Keyword))?G__24217_24286.fqn:null);
switch (G__24217_24287__$1) {
case "or":
var statearr_24218_24289 = state_24173__$1;
(statearr_24218_24289[(1)] = (43));


break;
case "and":
var statearr_24219_24290 = state_24173__$1;
(statearr_24219_24290[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24217_24287__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (11))){
var inst_24009 = (state_24173[(15)]);
var state_24173__$1 = state_24173;
var statearr_24221_24291 = state_24173__$1;
(statearr_24221_24291[(2)] = inst_24009);

(statearr_24221_24291[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (9))){
var inst_24008 = (state_24173[(17)]);
var inst_24015 = (state_24173[(20)]);
var inst_24014 = cljs.core.seq(inst_24008);
var inst_24015__$1 = cljs.core.first(inst_24014);
var inst_24016 = cljs.core.next(inst_24014);
var inst_24017 = cljs.core.not(inst_24015__$1);
var state_24173__$1 = (function (){var statearr_24222 = state_24173;
(statearr_24222[(20)] = inst_24015__$1);

(statearr_24222[(22)] = inst_24016);

return statearr_24222;
})();
if(inst_24017){
var statearr_24223_24292 = state_24173__$1;
(statearr_24223_24292[(1)] = (11));

} else {
var statearr_24224_24293 = state_24173__$1;
(statearr_24224_24293[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (5))){
var _ = (function (){var statearr_24225 = state_24173;
(statearr_24225[(4)] = cljs.core.rest((state_24173[(4)])));

return statearr_24225;
})();
var state_24173__$1 = state_24173;
var ex24220 = (state_24173__$1[(2)]);
var statearr_24226_24294 = state_24173__$1;
(statearr_24226_24294[(5)] = ex24220);


if((ex24220 instanceof Error)){
var statearr_24227_24295 = state_24173__$1;
(statearr_24227_24295[(1)] = (4));

(statearr_24227_24295[(5)] = null);

} else {
throw ex24220;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (14))){
var inst_24023 = (state_24173[(7)]);
var inst_24029 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_24023);
var inst_24030 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24029)].join('');
var inst_24031 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_24032 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_24033 = cljs.core.PersistentHashMap.fromArrays(inst_24031,inst_24032);
var inst_24034 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24030,inst_24033);
var inst_24035 = (function(){throw inst_24034})();
var state_24173__$1 = state_24173;
var statearr_24228_24296 = state_24173__$1;
(statearr_24228_24296[(2)] = inst_24035);

(statearr_24228_24296[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (45))){
var inst_24150 = (state_24173[(13)]);
var inst_24153 = cljs.core.empty_QMARK_(inst_24150);
var state_24173__$1 = state_24173;
var statearr_24229_24297 = state_24173__$1;
(statearr_24229_24297[(2)] = inst_24153);

(statearr_24229_24297[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (26))){
var inst_24023 = (state_24173[(7)]);
var inst_24025 = (state_24173[(8)]);
var inst_24079 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24080 = [inst_24023,inst_24025];
var inst_24081 = (new cljs.core.PersistentVector(null,2,(5),inst_24079,inst_24080,null));
var inst_24082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24083 = [inst_24023];
var inst_24084 = (new cljs.core.PersistentVector(null,1,(5),inst_24082,inst_24083,null));
var inst_24085 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_24081,cljs.core._LT__EQ_,inst_24084);
var state_24173__$1 = state_24173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24173__$1,(29),inst_24085);
} else {
if((state_val_24174 === (16))){
var inst_24024 = (state_24173[(10)]);
var inst_24042 = (state_24173[(11)]);
var inst_24038 = (state_24173[(2)]);
var inst_24042__$1 = cljs.core.identical_QMARK_;
var inst_24043 = (inst_24042__$1.cljs$core$IFn$_invoke$arity$2 ? inst_24042__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_24024) : inst_24042__$1.call(null,cljs.core.not_EQ_,inst_24024));
var state_24173__$1 = (function (){var statearr_24230 = state_24173;
(statearr_24230[(23)] = inst_24038);

(statearr_24230[(11)] = inst_24042__$1);

return statearr_24230;
})();
if(cljs.core.truth_(inst_24043)){
var statearr_24231_24298 = state_24173__$1;
(statearr_24231_24298[(1)] = (17));

} else {
var statearr_24232_24299 = state_24173__$1;
(statearr_24232_24299[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (38))){
var inst_24023 = (state_24173[(7)]);
var inst_24025 = (state_24173[(8)]);
var inst_24118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24119 = [inst_24023];
var inst_24120 = (new cljs.core.PersistentVector(null,1,(5),inst_24118,inst_24119,null));
var inst_24121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24122 = [inst_24023,inst_24025];
var inst_24123 = (new cljs.core.PersistentVector(null,2,(5),inst_24121,inst_24122,null));
var inst_24124 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24120,cljs.core._LT__EQ_,inst_24123);
var state_24173__$1 = state_24173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24173__$1,(41),inst_24124);
} else {
if((state_val_24174 === (30))){
var inst_24023 = (state_24173[(7)]);
var inst_24025 = (state_24173[(8)]);
var inst_24092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24093 = [inst_24023,inst_24025];
var inst_24094 = (new cljs.core.PersistentVector(null,2,(5),inst_24092,inst_24093,null));
var inst_24095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24096 = [inst_24023];
var inst_24097 = (new cljs.core.PersistentVector(null,1,(5),inst_24095,inst_24096,null));
var inst_24098 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24094,cljs.core._LT__EQ_,inst_24097);
var state_24173__$1 = state_24173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24173__$1,(33),inst_24098);
} else {
if((state_val_24174 === (10))){
var inst_24165 = (state_24173[(2)]);
var state_24173__$1 = state_24173;
var statearr_24233_24300 = state_24173__$1;
(statearr_24233_24300[(2)] = inst_24165);

(statearr_24233_24300[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (18))){
var inst_24024 = (state_24173[(10)]);
var inst_24042 = (state_24173[(11)]);
var inst_24067 = (inst_24042.cljs$core$IFn$_invoke$arity$2 ? inst_24042.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_24024) : inst_24042.call(null,cljs.core._EQ_,inst_24024));
var state_24173__$1 = state_24173;
if(cljs.core.truth_(inst_24067)){
var statearr_24234_24301 = state_24173__$1;
(statearr_24234_24301[(1)] = (22));

} else {
var statearr_24235_24302 = state_24173__$1;
(statearr_24235_24302[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (42))){
var inst_23993 = (state_24173[(21)]);
var inst_24151 = (state_24173[(12)]);
var inst_24150 = (state_24173[(2)]);
var inst_24151__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_23993);
var state_24173__$1 = (function (){var statearr_24236 = state_24173;
(statearr_24236[(13)] = inst_24150);

(statearr_24236[(12)] = inst_24151__$1);

return statearr_24236;
})();
if(inst_24151__$1){
var statearr_24237_24303 = state_24173__$1;
(statearr_24237_24303[(1)] = (45));

} else {
var statearr_24238_24304 = state_24173__$1;
(statearr_24238_24304[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (37))){
var inst_24113 = (state_24173[(2)]);
var inst_24114 = fluree.db.util.async.throw_err(inst_24113);
var state_24173__$1 = state_24173;
var statearr_24239_24305 = state_24173__$1;
(statearr_24239_24305[(2)] = inst_24114);

(statearr_24239_24305[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (8))){
var inst_24168 = (state_24173[(2)]);
var _ = (function (){var statearr_24240 = state_24173;
(statearr_24240[(4)] = cljs.core.rest((state_24173[(4)])));

return statearr_24240;
})();
var state_24173__$1 = state_24173;
var statearr_24241_24306 = state_24173__$1;
(statearr_24241_24306[(2)] = inst_24168);

(statearr_24241_24306[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24174 === (49))){
var inst_24150 = (state_24173[(13)]);
var inst_24016 = (state_24173[(22)]);
var inst_24008 = inst_24016;
var inst_24009 = inst_24150;
var state_24173__$1 = (function (){var statearr_24242 = state_24173;
(statearr_24242[(17)] = inst_24008);

(statearr_24242[(15)] = inst_24009);

return statearr_24242;
})();
var statearr_24243_24307 = state_24173__$1;
(statearr_24243_24307[(2)] = null);

(statearr_24243_24307[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2733__auto__ = null;
var fluree$db$query$fql$state_machine__2733__auto____0 = (function (){
var statearr_24244 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24244[(0)] = fluree$db$query$fql$state_machine__2733__auto__);

(statearr_24244[(1)] = (1));

return statearr_24244;
});
var fluree$db$query$fql$state_machine__2733__auto____1 = (function (state_24173){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_24173);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e24245){var ex__2736__auto__ = e24245;
var statearr_24246_24308 = state_24173;
(statearr_24246_24308[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_24173[(4)]))){
var statearr_24247_24309 = state_24173;
(statearr_24247_24309[(1)] = cljs.core.first((state_24173[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24310 = state_24173;
state_24173 = G__24310;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2733__auto__ = function(state_24173){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2733__auto____1.call(this,state_24173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2733__auto____0;
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2733__auto____1;
return fluree$db$query$fql$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_24248 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_24248[(6)] = c__2755__auto__);

return statearr_24248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4223__auto__ = cljs.core.every_QMARK_((function (p1__24311_SHARP_){
return ((typeof p1__24311_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__24311_SHARP_)));
}),select_smt);
if(or__4223__auto__){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__24312_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__24312_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__24316 = vars;
var vec__24317 = G__24316;
var seq__24318 = cljs.core.seq(vec__24317);
var first__24319 = cljs.core.first(seq__24318);
var seq__24318__$1 = cljs.core.next(seq__24318);
var var$ = first__24319;
var r = seq__24318__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24316__$1 = G__24316;
var all_vars__$1 = all_vars;
while(true){
var vec__24324 = G__24316__$1;
var seq__24325 = cljs.core.seq(vec__24324);
var first__24326 = cljs.core.first(seq__24325);
var seq__24325__$1 = cljs.core.next(seq__24325);
var var$__$1 = first__24326;
var r__$1 = seq__24325__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__24327 = cljs.core.set(all_vars__$2);
return (fexpr__24327.cljs$core$IFn$_invoke$arity$1 ? fexpr__24327.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__24327.call(null,var$__$1));
})())){
var G__24328 = r__$1;
var G__24329 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__24316__$1 = G__24328;
all_vars__$1 = G__24329;
continue;
} else {
var G__24330 = r__$1;
var G__24331 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__24316__$1 = G__24330;
all_vars__$1 = G__24331;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_24366){
var state_val_24367 = (state_24366[(1)]);
if((state_val_24367 === (1))){
var inst_24339 = functionArray;
var inst_24340 = cljs.core.seq(inst_24339);
var inst_24341 = cljs.core.first(inst_24340);
var inst_24342 = cljs.core.next(inst_24340);
var inst_24343 = cljs.core.PersistentVector.EMPTY;
var inst_24344 = inst_24339;
var inst_24345 = inst_24343;
var state_24366__$1 = (function (){var statearr_24368 = state_24366;
(statearr_24368[(7)] = inst_24344);

(statearr_24368[(8)] = inst_24341);

(statearr_24368[(9)] = inst_24345);

(statearr_24368[(10)] = inst_24342);

return statearr_24368;
})();
var statearr_24369_24382 = state_24366__$1;
(statearr_24369_24382[(2)] = null);

(statearr_24369_24382[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24367 === (2))){
var inst_24344 = (state_24366[(7)]);
var inst_24351 = (state_24366[(11)]);
var inst_24350 = cljs.core.seq(inst_24344);
var inst_24351__$1 = cljs.core.first(inst_24350);
var inst_24352 = cljs.core.next(inst_24350);
var state_24366__$1 = (function (){var statearr_24370 = state_24366;
(statearr_24370[(12)] = inst_24352);

(statearr_24370[(11)] = inst_24351__$1);

return statearr_24370;
})();
if(cljs.core.truth_(inst_24351__$1)){
var statearr_24371_24383 = state_24366__$1;
(statearr_24371_24383[(1)] = (4));

} else {
var statearr_24372_24384 = state_24366__$1;
(statearr_24372_24384[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24367 === (3))){
var inst_24364 = (state_24366[(2)]);
var state_24366__$1 = state_24366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24366__$1,inst_24364);
} else {
if((state_val_24367 === (4))){
var inst_24351 = (state_24366[(11)]);
var inst_24354 = (inst_24351.cljs$core$IFn$_invoke$arity$1 ? inst_24351.cljs$core$IFn$_invoke$arity$1(tuple) : inst_24351.call(null,tuple));
var state_24366__$1 = state_24366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24366__$1,(7),inst_24354);
} else {
if((state_val_24367 === (5))){
var inst_24345 = (state_24366[(9)]);
var state_24366__$1 = state_24366;
var statearr_24373_24385 = state_24366__$1;
(statearr_24373_24385[(2)] = inst_24345);

(statearr_24373_24385[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24367 === (6))){
var inst_24362 = (state_24366[(2)]);
var state_24366__$1 = state_24366;
var statearr_24374_24386 = state_24366__$1;
(statearr_24374_24386[(2)] = inst_24362);

(statearr_24374_24386[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24367 === (7))){
var inst_24352 = (state_24366[(12)]);
var inst_24345 = (state_24366[(9)]);
var inst_24356 = (state_24366[(2)]);
var inst_24357 = fluree.db.util.async.throw_err(inst_24356);
var inst_24358 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24345,inst_24357);
var inst_24344 = inst_24352;
var inst_24345__$1 = inst_24358;
var state_24366__$1 = (function (){var statearr_24375 = state_24366;
(statearr_24375[(7)] = inst_24344);

(statearr_24375[(9)] = inst_24345__$1);

return statearr_24375;
})();
var statearr_24376_24387 = state_24366__$1;
(statearr_24376_24387[(2)] = null);

(statearr_24376_24387[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2733__auto____0 = (function (){
var statearr_24377 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24377[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2733__auto__);

(statearr_24377[(1)] = (1));

return statearr_24377;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2733__auto____1 = (function (state_24366){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_24366);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e24378){var ex__2736__auto__ = e24378;
var statearr_24379_24388 = state_24366;
(statearr_24379_24388[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_24366[(4)]))){
var statearr_24380_24389 = state_24366;
(statearr_24380_24389[(1)] = cljs.core.first((state_24366[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24390 = state_24366;
state_24366 = G__24390;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2733__auto__ = function(state_24366){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2733__auto____1.call(this,state_24366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2733__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2733__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_24381 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_24381[(6)] = c__2755__auto__);

return statearr_24381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__24391){
var vec__24392 = p__24391;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24392,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24392,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_24406){
var state_val_24407 = (state_24406[(1)]);
if((state_val_24407 === (1))){
var inst_24395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24396 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24397 = [query_map,_id,query_opts];
var inst_24398 = cljs.core.PersistentHashMap.fromArrays(inst_24396,inst_24397);
var inst_24399 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_24398) : fluree.db.query.fql.query.call(null,db,inst_24398));
var state_24406__$1 = (function (){var statearr_24408 = state_24406;
(statearr_24408[(7)] = inst_24395);

return statearr_24408;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24406__$1,(2),inst_24399);
} else {
if((state_val_24407 === (2))){
var inst_24395 = (state_24406[(7)]);
var inst_24401 = (state_24406[(2)]);
var inst_24402 = fluree.db.util.async.throw_err(inst_24401);
var inst_24403 = [tuple_index,inst_24402];
var inst_24404 = (new cljs.core.PersistentVector(null,2,(5),inst_24395,inst_24403,null));
var state_24406__$1 = state_24406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24406__$1,inst_24404);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__2733__auto____0 = (function (){
var statearr_24409 = [null,null,null,null,null,null,null,null];
(statearr_24409[(0)] = fluree$db$query$fql$expand_map_$_state_machine__2733__auto__);

(statearr_24409[(1)] = (1));

return statearr_24409;
});
var fluree$db$query$fql$expand_map_$_state_machine__2733__auto____1 = (function (state_24406){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_24406);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e24410){var ex__2736__auto__ = e24410;
var statearr_24411_24414 = state_24406;
(statearr_24411_24414[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_24406[(4)]))){
var statearr_24412_24415 = state_24406;
(statearr_24412_24415[(1)] = cljs.core.first((state_24406[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24416 = state_24406;
state_24406 = G__24416;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__2733__auto__ = function(state_24406){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__2733__auto____1.call(this,state_24406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__2733__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__2733__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_24413 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_24413[(6)] = c__2755__auto__);

return statearr_24413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__24417 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24417,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24417,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_24482){
var state_val_24483 = (state_24482[(1)]);
if((state_val_24483 === (7))){
var inst_24477 = (state_24482[(2)]);
var _ = (function (){var statearr_24484 = state_24482;
(statearr_24484[(4)] = cljs.core.rest((state_24482[(4)])));

return statearr_24484;
})();
var state_24482__$1 = state_24482;
var statearr_24485_24576 = state_24482__$1;
(statearr_24485_24576[(2)] = inst_24477);

(statearr_24485_24576[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (20))){
var inst_24468 = (state_24482[(2)]);
var state_24482__$1 = state_24482;
var statearr_24486_24577 = state_24482__$1;
(statearr_24486_24577[(2)] = inst_24468);

(statearr_24486_24577[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (1))){
var state_24482__$1 = state_24482;
var statearr_24487_24578 = state_24482__$1;
(statearr_24487_24578[(2)] = null);

(statearr_24487_24578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (4))){
var inst_24422 = (state_24482[(2)]);
var state_24482__$1 = state_24482;
var statearr_24488_24579 = state_24482__$1;
(statearr_24488_24579[(2)] = inst_24422);

(statearr_24488_24579[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (15))){
var inst_24442 = (state_24482[(7)]);
var inst_24451 = cljs.core._deref(fuel);
var inst_24452 = cljs.core.second(inst_24442);
var inst_24453 = (inst_24451 + inst_24452);
var inst_24454 = cljs.core._vreset_BANG_(fuel,inst_24453);
var inst_24455 = (inst_24454 > max_fuel);
var state_24482__$1 = state_24482;
if(cljs.core.truth_(inst_24455)){
var statearr_24489_24580 = state_24482__$1;
(statearr_24489_24580[(1)] = (18));

} else {
var statearr_24490_24581 = state_24482__$1;
(statearr_24490_24581[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (13))){
var state_24482__$1 = state_24482;
var statearr_24491_24582 = state_24482__$1;
(statearr_24491_24582[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (6))){
var inst_24430 = (state_24482[(8)]);
var state_24482__$1 = state_24482;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24482__$1,(8),inst_24430);
} else {
if((state_val_24483 === (17))){
var inst_24471 = (state_24482[(2)]);
var state_24482__$1 = state_24482;
var statearr_24493_24583 = state_24482__$1;
(statearr_24493_24583[(2)] = inst_24471);

(statearr_24493_24583[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (3))){
var inst_24480 = (state_24482[(2)]);
var state_24482__$1 = state_24482;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24482__$1,inst_24480);
} else {
if((state_val_24483 === (12))){
var inst_24431 = (state_24482[(9)]);
var inst_24442 = (state_24482[(7)]);
var inst_24448 = (inst_24431.cljs$core$IFn$_invoke$arity$0 ? inst_24431.cljs$core$IFn$_invoke$arity$0() : inst_24431.call(null));
var state_24482__$1 = (function (){var statearr_24494 = state_24482;
(statearr_24494[(10)] = inst_24448);

return statearr_24494;
})();
var statearr_24495_24584 = state_24482__$1;
(statearr_24495_24584[(2)] = inst_24442);

(statearr_24495_24584[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (2))){
var inst_24431 = (state_24482[(9)]);
var inst_24430 = (state_24482[(8)]);
var _ = (function (){var statearr_24496 = state_24482;
(statearr_24496[(4)] = cljs.core.cons((5),(state_24482[(4)])));

return statearr_24496;
})();
var inst_24428 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_24429 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24430__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24431__$1 = (function (){var expandMaps = inst_24428;
var queue_ch = inst_24429;
var res_ch = inst_24430__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_24432 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_24433 = cljs.core.volatile_BANG_((0));
var inst_24434 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_24432,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_24433);
var inst_24435 = (function (){var expandMaps = inst_24428;
var queue_ch = inst_24429;
var res_ch = inst_24430__$1;
var stop_BANG_ = inst_24431__$1;
var opts_STAR_ = inst_24434;
return (function (tuple_res,port){
var c__2755__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_24529){
var state_val_24530 = (state_24529[(1)]);
if((state_val_24530 === (7))){
var state_24529__$1 = state_24529;
var statearr_24531_24585 = state_24529__$1;
(statearr_24531_24585[(2)] = tuple_res);

(statearr_24531_24585[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24530 === (1))){
var state_24529__$1 = state_24529;
var statearr_24532_24586 = state_24529__$1;
(statearr_24532_24586[(2)] = null);

(statearr_24532_24586[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24530 === (4))){
var inst_24497 = (state_24529[(2)]);
var inst_24498 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24497);
var inst_24499 = cljs.core.async.close_BANG_(port);
var state_24529__$1 = (function (){var statearr_24533 = state_24529;
(statearr_24533[(7)] = inst_24498);

return statearr_24533;
})();
var statearr_24534_24587 = state_24529__$1;
(statearr_24534_24587[(2)] = inst_24499);

(statearr_24534_24587[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24530 === (6))){
var inst_24506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24507 = [tuple_res];
var inst_24508 = (new cljs.core.PersistentVector(null,1,(5),inst_24506,inst_24507,null));
var state_24529__$1 = state_24529;
var statearr_24535_24588 = state_24529__$1;
(statearr_24535_24588[(2)] = inst_24508);

(statearr_24535_24588[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24530 === (3))){
var inst_24527 = (state_24529[(2)]);
var state_24529__$1 = state_24529;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24529__$1,inst_24527);
} else {
if((state_val_24530 === (2))){
var ___$1 = (function (){var statearr_24537 = state_24529;
(statearr_24537[(4)] = cljs.core.cons((5),(state_24529[(4)])));

return statearr_24537;
})();
var state_24529__$1 = state_24529;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_24538_24589 = state_24529__$1;
(statearr_24538_24589[(1)] = (6));

} else {
var statearr_24539_24590 = state_24529__$1;
(statearr_24539_24590[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24530 === (9))){
var inst_24511 = (state_24529[(8)]);
var inst_24513 = (state_24529[(9)]);
var inst_24520 = (state_24529[(2)]);
var inst_24521 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_24511,inst_24520);
var inst_24522 = (inst_24513.cljs$core$IFn$_invoke$arity$1 ? inst_24513.cljs$core$IFn$_invoke$arity$1(inst_24521) : inst_24513.call(null,inst_24521));
var inst_24523 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24522);
var inst_24524 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_24540 = state_24529;
(statearr_24540[(4)] = cljs.core.rest((state_24529[(4)])));

return statearr_24540;
})();
var state_24529__$1 = (function (){var statearr_24541 = state_24529;
(statearr_24541[(10)] = inst_24523);

return statearr_24541;
})();
var statearr_24542_24591 = state_24529__$1;
(statearr_24542_24591[(2)] = inst_24524);

(statearr_24542_24591[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24530 === (5))){
var ___$1 = (function (){var statearr_24543 = state_24529;
(statearr_24543[(4)] = cljs.core.rest((state_24529[(4)])));

return statearr_24543;
})();
var state_24529__$1 = state_24529;
var ex24536 = (state_24529__$1[(2)]);
var statearr_24544_24592 = state_24529__$1;
(statearr_24544_24592[(5)] = ex24536);


var statearr_24545_24593 = state_24529__$1;
(statearr_24545_24593[(1)] = (4));

(statearr_24545_24593[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24530 === (8))){
var inst_24511 = (state_24529[(8)]);
var inst_24511__$1 = (state_24529[(2)]);
var inst_24512 = cljs.core.volatile_BANG_((0));
var inst_24513 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24511__$1;
var query_fuel = inst_24512;
return (function (p1__24421_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__24421_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__24421_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_24514 = cljs.core.PersistentVector.EMPTY;
var inst_24515 = (function (){var tuple_res_SINGLEQUOTE_ = inst_24511__$1;
var query_fuel = inst_24512;
return (function (p1__24420_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,new cljs.core.Keyword(null,"fuel","fuel",10405485),fuel),tuple_res_SINGLEQUOTE_,p1__24420_SHARP_);
});
})();
var inst_24516 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_24515,expandMaps);
var inst_24517 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_24516);
var inst_24518 = cljs.core.async.into(inst_24514,inst_24517);
var state_24529__$1 = (function (){var statearr_24546 = state_24529;
(statearr_24546[(8)] = inst_24511__$1);

(statearr_24546[(9)] = inst_24513);

return statearr_24546;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24529__$1,(9),inst_24518);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____0 = (function (){
var statearr_24547 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24547[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__);

(statearr_24547[(1)] = (1));

return statearr_24547;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____1 = (function (state_24529){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_24529);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e24548){var ex__2736__auto__ = e24548;
var statearr_24549_24594 = state_24529;
(statearr_24549_24594[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_24529[(4)]))){
var statearr_24550_24595 = state_24529;
(statearr_24550_24595[(1)] = cljs.core.first((state_24529[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24596 = state_24529;
state_24529 = G__24596;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__ = function(state_24529){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____1.call(this,state_24529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_24551 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_24551[(6)] = c__2755__auto____$1);

return statearr_24551;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto____$1;
});
})();
var inst_24436 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24429,tuples_res);
var inst_24437 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24430__$1,inst_24435,inst_24429);
var inst_24438 = cljs.core.PersistentVector.EMPTY;
var inst_24439 = inst_24438;
var state_24482__$1 = (function (){var statearr_24552 = state_24482;
(statearr_24552[(11)] = inst_24439);

(statearr_24552[(12)] = inst_24437);

(statearr_24552[(13)] = inst_24436);

(statearr_24552[(9)] = inst_24431__$1);

(statearr_24552[(8)] = inst_24430__$1);

return statearr_24552;
})();
var statearr_24553_24597 = state_24482__$1;
(statearr_24553_24597[(2)] = null);

(statearr_24553_24597[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (19))){
var inst_24439 = (state_24482[(11)]);
var inst_24442 = (state_24482[(7)]);
var inst_24464 = cljs.core.first(inst_24442);
var inst_24465 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24439,inst_24464);
var inst_24439__$1 = inst_24465;
var state_24482__$1 = (function (){var statearr_24554 = state_24482;
(statearr_24554[(11)] = inst_24439__$1);

return statearr_24554;
})();
var statearr_24555_24598 = state_24482__$1;
(statearr_24555_24598[(2)] = null);

(statearr_24555_24598[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (11))){
var inst_24475 = (state_24482[(2)]);
var state_24482__$1 = state_24482;
var statearr_24557_24599 = state_24482__$1;
(statearr_24557_24599[(2)] = inst_24475);

(statearr_24557_24599[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (9))){
var inst_24439 = (state_24482[(11)]);
var state_24482__$1 = state_24482;
var statearr_24558_24600 = state_24482__$1;
(statearr_24558_24600[(2)] = inst_24439);

(statearr_24558_24600[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (5))){
var _ = (function (){var statearr_24559 = state_24482;
(statearr_24559[(4)] = cljs.core.rest((state_24482[(4)])));

return statearr_24559;
})();
var state_24482__$1 = state_24482;
var ex24556 = (state_24482__$1[(2)]);
var statearr_24560_24601 = state_24482__$1;
(statearr_24560_24601[(5)] = ex24556);


if((ex24556 instanceof Error)){
var statearr_24561_24602 = state_24482__$1;
(statearr_24561_24602[(1)] = (4));

(statearr_24561_24602[(5)] = null);

} else {
throw ex24556;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (14))){
var inst_24473 = (state_24482[(2)]);
var state_24482__$1 = state_24482;
var statearr_24562_24603 = state_24482__$1;
(statearr_24562_24603[(2)] = inst_24473);

(statearr_24562_24603[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (16))){
var state_24482__$1 = state_24482;
var statearr_24563_24604 = state_24482__$1;
(statearr_24563_24604[(2)] = null);

(statearr_24563_24604[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (10))){
var inst_24442 = (state_24482[(7)]);
var inst_24446 = fluree.db.util.core.exception_QMARK_(inst_24442);
var state_24482__$1 = state_24482;
if(inst_24446){
var statearr_24564_24605 = state_24482__$1;
(statearr_24564_24605[(1)] = (12));

} else {
var statearr_24565_24606 = state_24482__$1;
(statearr_24565_24606[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (18))){
var inst_24431 = (state_24482[(9)]);
var inst_24457 = (inst_24431.cljs$core$IFn$_invoke$arity$0 ? inst_24431.cljs$core$IFn$_invoke$arity$0() : inst_24431.call(null));
var inst_24458 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_24459 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_24460 = [new cljs.core.Keyword("db","insufficient-fuel","db/insufficient-fuel",344386102),(400)];
var inst_24461 = cljs.core.PersistentHashMap.fromArrays(inst_24459,inst_24460);
var inst_24462 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_24458,inst_24461);
var state_24482__$1 = (function (){var statearr_24566 = state_24482;
(statearr_24566[(14)] = inst_24457);

return statearr_24566;
})();
var statearr_24567_24607 = state_24482__$1;
(statearr_24567_24607[(2)] = inst_24462);

(statearr_24567_24607[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24483 === (8))){
var inst_24442 = (state_24482[(7)]);
var inst_24442__$1 = (state_24482[(2)]);
var inst_24443 = (inst_24442__$1 == null);
var state_24482__$1 = (function (){var statearr_24568 = state_24482;
(statearr_24568[(7)] = inst_24442__$1);

return statearr_24568;
})();
if(cljs.core.truth_(inst_24443)){
var statearr_24569_24608 = state_24482__$1;
(statearr_24569_24608[(1)] = (9));

} else {
var statearr_24570_24609 = state_24482__$1;
(statearr_24570_24609[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____0 = (function (){
var statearr_24571 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24571[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__);

(statearr_24571[(1)] = (1));

return statearr_24571;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____1 = (function (state_24482){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_24482);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e24572){var ex__2736__auto__ = e24572;
var statearr_24573_24610 = state_24482;
(statearr_24573_24610[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_24482[(4)]))){
var statearr_24574_24611 = state_24482;
(statearr_24574_24611[(1)] = cljs.core.first((state_24482[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24612 = state_24482;
state_24482 = G__24612;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__ = function(state_24482){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____1.call(this,state_24482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_24575 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_24575[(6)] = c__2755__auto__);

return statearr_24575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__24613 = select;
var map__24613__$1 = cljs.core.__destructure_map(map__24613);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24613__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24613__$1,new cljs.core.Keyword(null,"variable","variable",-281346492));
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24613__$1,new cljs.core.Keyword(null,"value","value",305978217));
var select_val = (function (){var or__4223__auto__ = as;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__24616 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24616,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24616,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24616,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__24614_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24614_SHARP_,compare_idx));
}):(function (p1__24615_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24615_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples))));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24621 = arguments.length;
switch (G__24621) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__24622,p__24623,group_limit,opts){
var map__24624 = p__24622;
var map__24624__$1 = cljs.core.__destructure_map(map__24624);
var res = map__24624__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24624__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24625 = p__24623;
var map__24625__$1 = cljs.core.__destructure_map(map__24625);
var select_spec = map__24625__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24625__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24625__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24625__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24625__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24625__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24625__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24625__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24625__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24625__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24625__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_24762){
var state_val_24763 = (state_24762[(1)]);
if((state_val_24763 === (7))){
var inst_24632 = (state_24762[(7)]);
var state_24762__$1 = state_24762;
var statearr_24764_24866 = state_24762__$1;
(statearr_24764_24866[(2)] = inst_24632);

(statearr_24764_24866[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (59))){
var inst_24755 = (state_24762[(2)]);
var state_24762__$1 = state_24762;
var statearr_24765_24867 = state_24762__$1;
(statearr_24765_24867[(2)] = inst_24755);

(statearr_24765_24867[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (20))){
var inst_24671 = (state_24762[(8)]);
var inst_24668 = (state_24762[(9)]);
var inst_24667 = (state_24762[(2)]);
var inst_24668__$1 = cljs.core.__destructure_map(inst_24667);
var inst_24669 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24668__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24670 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24668__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var inst_24671__$1 = offset;
var state_24762__$1 = (function (){var statearr_24766 = state_24762;
(statearr_24766[(8)] = inst_24671__$1);

(statearr_24766[(10)] = inst_24670);

(statearr_24766[(9)] = inst_24668__$1);

(statearr_24766[(11)] = inst_24669);

return statearr_24766;
})();
if(cljs.core.truth_(inst_24671__$1)){
var statearr_24767_24868 = state_24762__$1;
(statearr_24767_24868[(1)] = (21));

} else {
var statearr_24768_24869 = state_24762__$1;
(statearr_24768_24869[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (58))){
var inst_24747 = (state_24762[(12)]);
var state_24762__$1 = state_24762;
var statearr_24769_24870 = state_24762__$1;
(statearr_24769_24870[(2)] = inst_24747);

(statearr_24769_24870[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (60))){
var inst_24751 = (state_24762[(2)]);
var inst_24752 = fluree.db.util.async.throw_err(inst_24751);
var state_24762__$1 = state_24762;
var statearr_24770_24871 = state_24762__$1;
(statearr_24770_24871[(2)] = inst_24752);

(statearr_24770_24871[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (27))){
var inst_24683 = cljs.core.not(inVector_QMARK_);
var state_24762__$1 = state_24762;
var statearr_24771_24872 = state_24762__$1;
(statearr_24771_24872[(2)] = inst_24683);

(statearr_24771_24872[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (1))){
var state_24762__$1 = state_24762;
var statearr_24772_24873 = state_24762__$1;
(statearr_24772_24873[(2)] = null);

(statearr_24772_24873[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (24))){
var state_24762__$1 = state_24762;
var statearr_24773_24874 = state_24762__$1;
(statearr_24773_24874[(2)] = offset);

(statearr_24773_24874[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (55))){
var inst_24741 = (state_24762[(13)]);
var state_24762__$1 = state_24762;
var statearr_24774_24875 = state_24762__$1;
(statearr_24774_24875[(2)] = inst_24741);

(statearr_24774_24875[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (39))){
var inst_24709 = (state_24762[(14)]);
var inst_24711 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_24712 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24709,inst_24711);
var state_24762__$1 = state_24762;
var statearr_24775_24876 = state_24762__$1;
(statearr_24775_24876[(2)] = inst_24712);

(statearr_24775_24876[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (46))){
var inst_24721 = (state_24762[(15)]);
var state_24762__$1 = state_24762;
var statearr_24776_24877 = state_24762__$1;
(statearr_24776_24877[(2)] = inst_24721);

(statearr_24776_24877[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (4))){
var inst_24626 = (state_24762[(2)]);
var state_24762__$1 = state_24762;
var statearr_24777_24878 = state_24762__$1;
(statearr_24777_24878[(2)] = inst_24626);

(statearr_24777_24878[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (54))){
var inst_24741 = (state_24762[(13)]);
var inst_24735 = (state_24762[(16)]);
var inst_24743 = cljs.core.PersistentVector.EMPTY;
var inst_24744 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_24743,inst_24735,inst_24741);
var state_24762__$1 = state_24762;
var statearr_24778_24879 = state_24762__$1;
(statearr_24778_24879[(2)] = inst_24744);

(statearr_24778_24879[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (15))){
var inst_24653 = (state_24762[(17)]);
var inst_24655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24656 = [inst_24653];
var inst_24657 = (new cljs.core.PersistentVector(null,1,(5),inst_24655,inst_24656,null));
var state_24762__$1 = state_24762;
var statearr_24779_24880 = state_24762__$1;
(statearr_24779_24880[(2)] = inst_24657);

(statearr_24779_24880[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (48))){
var inst_24686 = (state_24762[(18)]);
var inst_24670 = (state_24762[(10)]);
var inst_24691 = (state_24762[(19)]);
var inst_24668 = (state_24762[(9)]);
var inst_24669 = (state_24762[(11)]);
var inst_24727 = (state_24762[(20)]);
var inst_24680 = (state_24762[(21)]);
var inst_24729 = (function (){var map__24662 = inst_24668;
var headers = inst_24669;
var tuples = inst_24670;
var offset_SINGLEQUOTE_ = inst_24680;
var single_result_QMARK_ = inst_24686;
var pp_keys = inst_24691;
var G__24692 = inst_24727;
return (function (p1__24619_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__24619_SHARP_);
});
})();
var inst_24730 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_24729);
var inst_24731 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24727,inst_24730);
var state_24762__$1 = state_24762;
var statearr_24780_24881 = state_24762__$1;
(statearr_24780_24881[(2)] = inst_24731);

(statearr_24780_24881[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (50))){
var inst_24734 = (state_24762[(2)]);
var inst_24735 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_24734);
var state_24762__$1 = (function (){var statearr_24781 = state_24762;
(statearr_24781[(16)] = inst_24735);

return statearr_24781;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24782_24882 = state_24762__$1;
(statearr_24782_24882[(1)] = (51));

} else {
var statearr_24783_24883 = state_24762__$1;
(statearr_24783_24883[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (21))){
var inst_24673 = cljs.core.not(groupBy);
var state_24762__$1 = state_24762;
var statearr_24784_24884 = state_24762__$1;
(statearr_24784_24884[(2)] = inst_24673);

(statearr_24784_24884[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (31))){
var state_24762__$1 = state_24762;
var statearr_24785_24885 = state_24762__$1;
(statearr_24785_24885[(2)] = null);

(statearr_24785_24885[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (32))){
var inst_24686 = (state_24762[(18)]);
var inst_24669 = (state_24762[(11)]);
var inst_24691 = (state_24762[(2)]);
var inst_24693 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24694 = fluree.db.query.fql.select_tuples_fn(inst_24669,vars,select);
var inst_24695 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_24694);
var inst_24696 = [inst_24695];
var inst_24697 = (new cljs.core.PersistentVector(null,1,(5),inst_24693,inst_24696,null));
var state_24762__$1 = (function (){var statearr_24786 = state_24762;
(statearr_24786[(19)] = inst_24691);

(statearr_24786[(22)] = inst_24697);

return statearr_24786;
})();
if(cljs.core.truth_(inst_24686)){
var statearr_24787_24886 = state_24762__$1;
(statearr_24787_24886[(1)] = (33));

} else {
var statearr_24788_24887 = state_24762__$1;
(statearr_24788_24887[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (40))){
var inst_24709 = (state_24762[(14)]);
var state_24762__$1 = state_24762;
var statearr_24789_24888 = state_24762__$1;
(statearr_24789_24888[(2)] = inst_24709);

(statearr_24789_24888[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (56))){
var inst_24747 = (state_24762[(2)]);
var state_24762__$1 = (function (){var statearr_24790 = state_24762;
(statearr_24790[(12)] = inst_24747);

return statearr_24790;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24791_24889 = state_24762__$1;
(statearr_24791_24889[(1)] = (57));

} else {
var statearr_24792_24890 = state_24762__$1;
(statearr_24792_24890[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (33))){
var inst_24697 = (state_24762[(22)]);
var inst_24699 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_24700 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24697,inst_24699);
var state_24762__$1 = state_24762;
var statearr_24793_24891 = state_24762__$1;
(statearr_24793_24891[(2)] = inst_24700);

(statearr_24793_24891[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (13))){
var inst_24642 = (state_24762[(23)]);
var state_24762__$1 = state_24762;
var statearr_24794_24892 = state_24762__$1;
(statearr_24794_24892[(2)] = inst_24642);

(statearr_24794_24892[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (22))){
var inst_24671 = (state_24762[(8)]);
var state_24762__$1 = state_24762;
var statearr_24795_24893 = state_24762__$1;
(statearr_24795_24893[(2)] = inst_24671);

(statearr_24795_24893[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (36))){
var inst_24703 = (state_24762[(24)]);
var inst_24705 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_24706 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24703,inst_24705);
var state_24762__$1 = state_24762;
var statearr_24796_24894 = state_24762__$1;
(statearr_24796_24894[(2)] = inst_24706);

(statearr_24796_24894[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (41))){
var inst_24680 = (state_24762[(21)]);
var inst_24715 = (state_24762[(2)]);
var state_24762__$1 = (function (){var statearr_24797 = state_24762;
(statearr_24797[(25)] = inst_24715);

return statearr_24797;
})();
if(cljs.core.truth_(inst_24680)){
var statearr_24798_24895 = state_24762__$1;
(statearr_24798_24895[(1)] = (42));

} else {
var statearr_24799_24896 = state_24762__$1;
(statearr_24799_24896[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (43))){
var inst_24715 = (state_24762[(25)]);
var state_24762__$1 = state_24762;
var statearr_24800_24897 = state_24762__$1;
(statearr_24800_24897[(2)] = inst_24715);

(statearr_24800_24897[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (29))){
var inst_24686 = (state_24762[(2)]);
var state_24762__$1 = (function (){var statearr_24801 = state_24762;
(statearr_24801[(18)] = inst_24686);

return statearr_24801;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24802_24898 = state_24762__$1;
(statearr_24802_24898[(1)] = (30));

} else {
var statearr_24803_24899 = state_24762__$1;
(statearr_24803_24899[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (44))){
var inst_24721 = (state_24762[(2)]);
var state_24762__$1 = (function (){var statearr_24804 = state_24762;
(statearr_24804[(15)] = inst_24721);

return statearr_24804;
})();
if(cljs.core.truth_(group_limit)){
var statearr_24805_24900 = state_24762__$1;
(statearr_24805_24900[(1)] = (45));

} else {
var statearr_24806_24901 = state_24762__$1;
(statearr_24806_24901[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (6))){
var inst_24634 = cljs.core.count(select);
var inst_24635 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_24634);
var state_24762__$1 = state_24762;
var statearr_24807_24902 = state_24762__$1;
(statearr_24807_24902[(2)] = inst_24635);

(statearr_24807_24902[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (28))){
var inst_24681 = (state_24762[(26)]);
var state_24762__$1 = state_24762;
var statearr_24808_24903 = state_24762__$1;
(statearr_24808_24903[(2)] = inst_24681);

(statearr_24808_24903[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (51))){
var inst_24670 = (state_24762[(10)]);
var inst_24669 = (state_24762[(11)]);
var inst_24738 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_24669,orderBy,inst_24670);
var state_24762__$1 = state_24762;
var statearr_24809_24904 = state_24762__$1;
(statearr_24809_24904[(2)] = inst_24738);

(statearr_24809_24904[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (25))){
var state_24762__$1 = state_24762;
var statearr_24810_24905 = state_24762__$1;
(statearr_24810_24905[(2)] = null);

(statearr_24810_24905[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (34))){
var inst_24697 = (state_24762[(22)]);
var state_24762__$1 = state_24762;
var statearr_24811_24906 = state_24762__$1;
(statearr_24811_24906[(2)] = inst_24697);

(statearr_24811_24906[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (17))){
var inst_24660 = (state_24762[(2)]);
var state_24762__$1 = state_24762;
var statearr_24812_24907 = state_24762__$1;
(statearr_24812_24907[(2)] = inst_24660);

(statearr_24812_24907[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (3))){
var inst_24760 = (state_24762[(2)]);
var state_24762__$1 = state_24762;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24762__$1,inst_24760);
} else {
if((state_val_24763 === (12))){
var inst_24642 = (state_24762[(23)]);
var inst_24644 = cljs.core.first(select);
var inst_24645 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24644);
var inst_24646 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24645);
var inst_24647 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_24646,(1));
var inst_24648 = [inst_24647];
var inst_24649 = [inst_24642];
var inst_24650 = cljs.core.PersistentHashMap.fromArrays(inst_24648,inst_24649);
var state_24762__$1 = state_24762;
var statearr_24813_24908 = state_24762__$1;
(statearr_24813_24908[(2)] = inst_24650);

(statearr_24813_24908[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (2))){
var inst_24632 = (state_24762[(7)]);
var _ = (function (){var statearr_24814 = state_24762;
(statearr_24814[(4)] = cljs.core.cons((5),(state_24762[(4)])));

return statearr_24814;
})();
var inst_24632__$1 = aggregates;
var state_24762__$1 = (function (){var statearr_24815 = state_24762;
(statearr_24815[(7)] = inst_24632__$1);

return statearr_24815;
})();
if(cljs.core.truth_(inst_24632__$1)){
var statearr_24816_24909 = state_24762__$1;
(statearr_24816_24909[(1)] = (6));

} else {
var statearr_24817_24910 = state_24762__$1;
(statearr_24817_24910[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (23))){
var inst_24676 = (state_24762[(2)]);
var state_24762__$1 = state_24762;
if(cljs.core.truth_(inst_24676)){
var statearr_24818_24911 = state_24762__$1;
(statearr_24818_24911[(1)] = (24));

} else {
var statearr_24819_24912 = state_24762__$1;
(statearr_24819_24912[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (47))){
var inst_24727 = (state_24762[(2)]);
var state_24762__$1 = (function (){var statearr_24820 = state_24762;
(statearr_24820[(20)] = inst_24727);

return statearr_24820;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24821_24913 = state_24762__$1;
(statearr_24821_24913[(1)] = (48));

} else {
var statearr_24822_24914 = state_24762__$1;
(statearr_24822_24914[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (35))){
var inst_24703 = (state_24762[(2)]);
var state_24762__$1 = (function (){var statearr_24823 = state_24762;
(statearr_24823[(24)] = inst_24703);

return statearr_24823;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24824_24915 = state_24762__$1;
(statearr_24824_24915[(1)] = (36));

} else {
var statearr_24825_24916 = state_24762__$1;
(statearr_24825_24916[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (19))){
var state_24762__$1 = state_24762;
var statearr_24826_24917 = state_24762__$1;
(statearr_24826_24917[(2)] = res);

(statearr_24826_24917[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (57))){
var inst_24747 = (state_24762[(12)]);
var inst_24686 = (state_24762[(18)]);
var inst_24691 = (state_24762[(19)]);
var inst_24749 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_24691,inst_24686,db,fuel,max_fuel,opts,(8),inst_24747);
var state_24762__$1 = state_24762;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24762__$1,(60),inst_24749);
} else {
if((state_val_24763 === (11))){
var inst_24757 = (state_24762[(2)]);
var _ = (function (){var statearr_24828 = state_24762;
(statearr_24828[(4)] = cljs.core.rest((state_24762[(4)])));

return statearr_24828;
})();
var state_24762__$1 = state_24762;
var statearr_24829_24918 = state_24762__$1;
(statearr_24829_24918[(2)] = inst_24757);

(statearr_24829_24918[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (9))){
var inst_24640 = cljs.core.first(aggregates);
var inst_24641 = fluree.db.query.analytical.calculate_aggregate(res,inst_24640);
var inst_24642 = cljs.core.second(inst_24641);
var state_24762__$1 = (function (){var statearr_24830 = state_24762;
(statearr_24830[(23)] = inst_24642);

return statearr_24830;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24831_24919 = state_24762__$1;
(statearr_24831_24919[(1)] = (12));

} else {
var statearr_24832_24920 = state_24762__$1;
(statearr_24832_24920[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (5))){
var _ = (function (){var statearr_24833 = state_24762;
(statearr_24833[(4)] = cljs.core.rest((state_24762[(4)])));

return statearr_24833;
})();
var state_24762__$1 = state_24762;
var ex24827 = (state_24762__$1[(2)]);
var statearr_24834_24921 = state_24762__$1;
(statearr_24834_24921[(5)] = ex24827);


if((ex24827 instanceof Error)){
var statearr_24835_24922 = state_24762__$1;
(statearr_24835_24922[(1)] = (4));

(statearr_24835_24922[(5)] = null);

} else {
throw ex24827;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (14))){
var inst_24653 = (state_24762[(2)]);
var state_24762__$1 = (function (){var statearr_24836 = state_24762;
(statearr_24836[(17)] = inst_24653);

return statearr_24836;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24837_24923 = state_24762__$1;
(statearr_24837_24923[(1)] = (15));

} else {
var statearr_24838_24924 = state_24762__$1;
(statearr_24838_24924[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (45))){
var inst_24721 = (state_24762[(15)]);
var inst_24723 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_24724 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24721,inst_24723);
var state_24762__$1 = state_24762;
var statearr_24839_24925 = state_24762__$1;
(statearr_24839_24925[(2)] = inst_24724);

(statearr_24839_24925[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (53))){
var inst_24741 = (state_24762[(2)]);
var state_24762__$1 = (function (){var statearr_24840 = state_24762;
(statearr_24840[(13)] = inst_24741);

return statearr_24840;
})();
var statearr_24841_24926 = state_24762__$1;
(statearr_24841_24926[(1)] = (54));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (26))){
var inst_24681 = (state_24762[(26)]);
var inst_24680 = (state_24762[(2)]);
var inst_24681__$1 = cljs.core.not(prettyPrint);
var state_24762__$1 = (function (){var statearr_24843 = state_24762;
(statearr_24843[(26)] = inst_24681__$1);

(statearr_24843[(21)] = inst_24680);

return statearr_24843;
})();
if(inst_24681__$1){
var statearr_24844_24927 = state_24762__$1;
(statearr_24844_24927[(1)] = (27));

} else {
var statearr_24845_24928 = state_24762__$1;
(statearr_24845_24928[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (16))){
var inst_24653 = (state_24762[(17)]);
var state_24762__$1 = state_24762;
var statearr_24846_24929 = state_24762__$1;
(statearr_24846_24929[(2)] = inst_24653);

(statearr_24846_24929[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (38))){
var inst_24709 = (state_24762[(2)]);
var state_24762__$1 = (function (){var statearr_24847 = state_24762;
(statearr_24847[(14)] = inst_24709);

return statearr_24847;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24848_24930 = state_24762__$1;
(statearr_24848_24930[(1)] = (39));

} else {
var statearr_24849_24931 = state_24762__$1;
(statearr_24849_24931[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (30))){
var inst_24688 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_24762__$1 = state_24762;
var statearr_24850_24932 = state_24762__$1;
(statearr_24850_24932[(2)] = inst_24688);

(statearr_24850_24932[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (10))){
var state_24762__$1 = state_24762;
if(cljs.core.truth_(aggregates)){
var statearr_24851_24933 = state_24762__$1;
(statearr_24851_24933[(1)] = (18));

} else {
var statearr_24852_24934 = state_24762__$1;
(statearr_24852_24934[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (18))){
var inst_24664 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_24762__$1 = state_24762;
var statearr_24853_24935 = state_24762__$1;
(statearr_24853_24935[(2)] = inst_24664);

(statearr_24853_24935[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (52))){
var inst_24670 = (state_24762[(10)]);
var state_24762__$1 = state_24762;
var statearr_24854_24936 = state_24762__$1;
(statearr_24854_24936[(2)] = inst_24670);

(statearr_24854_24936[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (42))){
var inst_24715 = (state_24762[(25)]);
var inst_24680 = (state_24762[(21)]);
var inst_24717 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_24680);
var inst_24718 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24715,inst_24717);
var state_24762__$1 = state_24762;
var statearr_24855_24937 = state_24762__$1;
(statearr_24855_24937[(2)] = inst_24718);

(statearr_24855_24937[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (37))){
var inst_24703 = (state_24762[(24)]);
var state_24762__$1 = state_24762;
var statearr_24856_24938 = state_24762__$1;
(statearr_24856_24938[(2)] = inst_24703);

(statearr_24856_24938[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (8))){
var inst_24638 = (state_24762[(2)]);
var state_24762__$1 = state_24762;
if(cljs.core.truth_(inst_24638)){
var statearr_24857_24939 = state_24762__$1;
(statearr_24857_24939[(1)] = (9));

} else {
var statearr_24858_24940 = state_24762__$1;
(statearr_24858_24940[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24763 === (49))){
var inst_24727 = (state_24762[(20)]);
var state_24762__$1 = state_24762;
var statearr_24859_24941 = state_24762__$1;
(statearr_24859_24941[(2)] = inst_24727);

(statearr_24859_24941[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2733__auto__ = null;
var fluree$db$query$fql$state_machine__2733__auto____0 = (function (){
var statearr_24860 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24860[(0)] = fluree$db$query$fql$state_machine__2733__auto__);

(statearr_24860[(1)] = (1));

return statearr_24860;
});
var fluree$db$query$fql$state_machine__2733__auto____1 = (function (state_24762){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_24762);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e24861){var ex__2736__auto__ = e24861;
var statearr_24862_24942 = state_24762;
(statearr_24862_24942[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_24762[(4)]))){
var statearr_24863_24943 = state_24762;
(statearr_24863_24943[(1)] = cljs.core.first((state_24762[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24944 = state_24762;
state_24762 = G__24944;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2733__auto__ = function(state_24762){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2733__auto____1.call(this,state_24762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2733__auto____0;
fluree$db$query$fql$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2733__auto____1;
return fluree$db$query$fql$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_24864 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_24864[(6)] = c__2755__auto__);

return statearr_24864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__24947,groupBy){
var map__24948 = p__24947;
var map__24948__$1 = cljs.core.__destructure_map(map__24948);
var res = map__24948__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24948__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24948__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24949 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24949,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24949,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24945_SHARP_){
return fluree.db.util.core.index_of(headers,p1__24945_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24946_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__24946_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__24952 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24952,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24952,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__24955,p__24956,opts){
var map__24957 = p__24955;
var map__24957__$1 = cljs.core.__destructure_map(map__24957);
var res = map__24957__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24957__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24957__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24958 = p__24956;
var map__24958__$1 = cljs.core.__destructure_map(map__24958);
var select_spec = map__24958__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24958__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24958__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24958__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24958__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24958__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24958__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24958__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_25176){
var state_val_25177 = (state_25176[(1)]);
if((state_val_25177 === (65))){
var inst_25089 = (state_25176[(7)]);
var inst_25117 = cljs.core.empty_QMARK_(inst_25089);
var state_25176__$1 = state_25176;
var statearr_25178_25311 = state_25176__$1;
(statearr_25178_25311[(2)] = inst_25117);

(statearr_25178_25311[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (70))){
var state_25176__$1 = state_25176;
var statearr_25179_25312 = state_25176__$1;
(statearr_25179_25312[(2)] = (1));

(statearr_25179_25312[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (62))){
var state_25176__$1 = state_25176;
var statearr_25180_25313 = state_25176__$1;
(statearr_25180_25313[(2)] = null);

(statearr_25180_25313[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (74))){
var state_25176__$1 = state_25176;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25181_25314 = state_25176__$1;
(statearr_25181_25314[(1)] = (77));

} else {
var statearr_25182_25315 = state_25176__$1;
(statearr_25182_25315[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (7))){
var state_25176__$1 = state_25176;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25183_25316 = state_25176__$1;
(statearr_25183_25316[(1)] = (70));

} else {
var statearr_25184_25317 = state_25176__$1;
(statearr_25184_25317[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (59))){
var state_25176__$1 = state_25176;
var statearr_25185_25318 = state_25176__$1;
(statearr_25185_25318[(1)] = (61));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (20))){
var state_25176__$1 = state_25176;
var statearr_25187_25319 = state_25176__$1;
(statearr_25187_25319[(2)] = (0));

(statearr_25187_25319[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (72))){
var inst_25143 = (state_25176[(2)]);
var inst_25144 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_25143,opts);
var state_25176__$1 = state_25176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25176__$1,(73),inst_25144);
} else {
if((state_val_25177 === (58))){
var inst_25027 = (state_25176[(8)]);
var inst_25101 = (inst_25027 - (1));
var state_25176__$1 = state_25176;
var statearr_25188_25320 = state_25176__$1;
(statearr_25188_25320[(2)] = inst_25101);

(statearr_25188_25320[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (60))){
var inst_25111 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25189_25321 = state_25176__$1;
(statearr_25189_25321[(2)] = inst_25111);

(statearr_25189_25321[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (27))){
var inst_25026 = (state_25176[(9)]);
var inst_25050 = (inst_25026 < (1));
var state_25176__$1 = state_25176;
var statearr_25190_25322 = state_25176__$1;
(statearr_25190_25322[(2)] = inst_25050);

(statearr_25190_25322[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (1))){
var state_25176__$1 = state_25176;
var statearr_25191_25323 = state_25176__$1;
(statearr_25191_25323[(2)] = null);

(statearr_25191_25323[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (69))){
var inst_25113 = (state_25176[(10)]);
var inst_25041 = (state_25176[(11)]);
var inst_25038 = (state_25176[(12)]);
var inst_25096 = (state_25176[(13)]);
var inst_25124 = (state_25176[(2)]);
var inst_25024 = inst_25038;
var inst_25025 = inst_25041;
var inst_25026 = inst_25096;
var inst_25027 = inst_25113;
var inst_25028 = inst_25124;
var state_25176__$1 = (function (){var statearr_25192 = state_25176;
(statearr_25192[(14)] = inst_25028);

(statearr_25192[(15)] = inst_25024);

(statearr_25192[(16)] = inst_25025);

(statearr_25192[(9)] = inst_25026);

(statearr_25192[(8)] = inst_25027);

return statearr_25192;
})();
var statearr_25193_25324 = state_25176__$1;
(statearr_25193_25324[(2)] = null);

(statearr_25193_25324[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (24))){
var inst_25028 = (state_25176[(14)]);
var state_25176__$1 = state_25176;
var statearr_25194_25325 = state_25176__$1;
(statearr_25194_25325[(2)] = inst_25028);

(statearr_25194_25325[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (55))){
var state_25176__$1 = state_25176;
var statearr_25195_25326 = state_25176__$1;
(statearr_25195_25326[(2)] = (0));

(statearr_25195_25326[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (85))){
var inst_25165 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25196_25327 = state_25176__$1;
(statearr_25196_25327[(2)] = inst_25165);

(statearr_25196_25327[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (39))){
var inst_25045 = (state_25176[(17)]);
var inst_25068 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25069 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25070 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_25045,inst_25068,inst_25069);
var state_25176__$1 = state_25176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25176__$1,(42),inst_25070);
} else {
if((state_val_25177 === (46))){
var inst_25026 = (state_25176[(9)]);
var inst_25081 = ((0) < inst_25026);
var state_25176__$1 = state_25176;
var statearr_25197_25328 = state_25176__$1;
(statearr_25197_25328[(2)] = inst_25081);

(statearr_25197_25328[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (4))){
var inst_24959 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25198_25329 = state_25176__$1;
(statearr_25198_25329[(2)] = inst_24959);

(statearr_25198_25329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (77))){
var inst_25147 = (state_25176[(18)]);
var inst_25152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25153 = [inst_25147];
var inst_25154 = (new cljs.core.PersistentVector(null,1,(5),inst_25152,inst_25153,null));
var state_25176__$1 = state_25176;
var statearr_25199_25330 = state_25176__$1;
(statearr_25199_25330[(2)] = inst_25154);

(statearr_25199_25330[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (54))){
var inst_25027 = (state_25176[(8)]);
var inst_25096 = (state_25176[(2)]);
var inst_25097 = (inst_25027 <= (0));
var state_25176__$1 = (function (){var statearr_25200 = state_25176;
(statearr_25200[(13)] = inst_25096);

return statearr_25200;
})();
if(cljs.core.truth_(inst_25097)){
var statearr_25201_25331 = state_25176__$1;
(statearr_25201_25331[(1)] = (55));

} else {
var statearr_25202_25332 = state_25176__$1;
(statearr_25202_25332[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (15))){
var inst_24977 = (state_25176[(19)]);
var inst_24985 = (state_25176[(2)]);
var inst_24986 = fluree.db.util.async.throw_err(inst_24985);
var inst_24987 = [inst_24977];
var inst_24988 = [inst_24986];
var inst_24989 = cljs.core.PersistentHashMap.fromArrays(inst_24987,inst_24988);
var state_25176__$1 = state_25176;
var statearr_25203_25333 = state_25176__$1;
(statearr_25203_25333[(2)] = inst_24989);

(statearr_25203_25333[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (48))){
var inst_25084 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
if(cljs.core.truth_(inst_25084)){
var statearr_25204_25334 = state_25176__$1;
(statearr_25204_25334[(1)] = (49));

} else {
var statearr_25205_25335 = state_25176__$1;
(statearr_25205_25335[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (50))){
var inst_25079 = (state_25176[(20)]);
var state_25176__$1 = state_25176;
var statearr_25206_25336 = state_25176__$1;
(statearr_25206_25336[(2)] = inst_25079);

(statearr_25206_25336[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (75))){
var state_25176__$1 = state_25176;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25207_25337 = state_25176__$1;
(statearr_25207_25337[(1)] = (80));

} else {
var statearr_25208_25338 = state_25176__$1;
(statearr_25208_25338[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (21))){
var inst_25017 = (state_25176[(21)]);
var inst_25009 = (state_25176[(22)]);
var inst_25005 = (state_25176[(23)]);
var inst_25022 = (state_25176[(2)]);
var inst_25023 = cljs.core.PersistentHashMap.EMPTY;
var inst_25024 = inst_25005;
var inst_25025 = inst_25009;
var inst_25026 = inst_25017;
var inst_25027 = inst_25022;
var inst_25028 = inst_25023;
var state_25176__$1 = (function (){var statearr_25209 = state_25176;
(statearr_25209[(14)] = inst_25028);

(statearr_25209[(15)] = inst_25024);

(statearr_25209[(16)] = inst_25025);

(statearr_25209[(9)] = inst_25026);

(statearr_25209[(8)] = inst_25027);

return statearr_25209;
})();
var statearr_25210_25339 = state_25176__$1;
(statearr_25210_25339[(2)] = null);

(statearr_25210_25339[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (31))){
var inst_25042 = (state_25176[(24)]);
var inst_25027 = (state_25176[(8)]);
var inst_25056 = (inst_25027 >= inst_25042);
var state_25176__$1 = state_25176;
if(cljs.core.truth_(inst_25056)){
var statearr_25211_25340 = state_25176__$1;
(statearr_25211_25340[(1)] = (33));

} else {
var statearr_25212_25341 = state_25176__$1;
(statearr_25212_25341[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (32))){
var inst_25132 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25213_25342 = state_25176__$1;
(statearr_25213_25342[(2)] = inst_25132);

(statearr_25213_25342[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (40))){
var state_25176__$1 = state_25176;
var statearr_25214_25343 = state_25176__$1;
(statearr_25214_25343[(2)] = null);

(statearr_25214_25343[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (56))){
var state_25176__$1 = state_25176;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25215_25344 = state_25176__$1;
(statearr_25215_25344[(1)] = (58));

} else {
var statearr_25216_25345 = state_25176__$1;
(statearr_25216_25345[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (33))){
var state_25176__$1 = state_25176;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25217_25346 = state_25176__$1;
(statearr_25217_25346[(1)] = (36));

} else {
var statearr_25218_25347 = state_25176__$1;
(statearr_25218_25347[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (13))){
var inst_25009 = (state_25176[(22)]);
var inst_25005 = (state_25176[(23)]);
var inst_24974 = (state_25176[(25)]);
var inst_25005__$1 = cljs.core.keys(inst_24974);
var inst_25006 = cljs.core.seq(inst_25005__$1);
var inst_25007 = cljs.core.first(inst_25006);
var inst_25008 = cljs.core.next(inst_25006);
var inst_25009__$1 = cljs.core.vals(inst_24974);
var inst_25010 = cljs.core.seq(inst_25009__$1);
var inst_25011 = cljs.core.first(inst_25010);
var inst_25012 = cljs.core.next(inst_25010);
var inst_25013 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_25176__$1 = (function (){var statearr_25219 = state_25176;
(statearr_25219[(26)] = inst_25008);

(statearr_25219[(22)] = inst_25009__$1);

(statearr_25219[(27)] = inst_25011);

(statearr_25219[(28)] = inst_25012);

(statearr_25219[(23)] = inst_25005__$1);

(statearr_25219[(29)] = inst_25007);

return statearr_25219;
})();
if(inst_25013){
var statearr_25220_25348 = state_25176__$1;
(statearr_25220_25348[(1)] = (16));

} else {
var statearr_25221_25349 = state_25176__$1;
(statearr_25221_25349[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (22))){
var inst_25024 = (state_25176[(15)]);
var inst_25025 = (state_25176[(16)]);
var inst_25036 = cljs.core.seq(inst_25024);
var inst_25037 = cljs.core.first(inst_25036);
var inst_25038 = cljs.core.next(inst_25036);
var inst_25039 = cljs.core.seq(inst_25025);
var inst_25040 = cljs.core.first(inst_25039);
var inst_25041 = cljs.core.next(inst_25039);
var inst_25042 = cljs.core.count(inst_25040);
var inst_25043 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25044 = [headers,vars,inst_25040];
var inst_25045 = cljs.core.PersistentHashMap.fromArrays(inst_25043,inst_25044);
var inst_25046 = (inst_25040 == null);
var state_25176__$1 = (function (){var statearr_25222 = state_25176;
(statearr_25222[(30)] = inst_25037);

(statearr_25222[(24)] = inst_25042);

(statearr_25222[(11)] = inst_25041);

(statearr_25222[(17)] = inst_25045);

(statearr_25222[(12)] = inst_25038);

return statearr_25222;
})();
if(cljs.core.truth_(inst_25046)){
var statearr_25223_25350 = state_25176__$1;
(statearr_25223_25350[(1)] = (24));

} else {
var statearr_25224_25351 = state_25176__$1;
(statearr_25224_25351[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (36))){
var inst_25027 = (state_25176[(8)]);
var inst_25059 = (inst_25027 - (1));
var state_25176__$1 = state_25176;
var statearr_25225_25352 = state_25176__$1;
(statearr_25225_25352[(2)] = inst_25059);

(statearr_25225_25352[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (41))){
var inst_25128 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25226_25353 = state_25176__$1;
(statearr_25226_25353[(2)] = inst_25128);

(statearr_25226_25353[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (43))){
var inst_25073 = (state_25176[(31)]);
var inst_25027 = (state_25176[(8)]);
var inst_25076 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_25027,inst_25073);
var state_25176__$1 = state_25176;
var statearr_25227_25354 = state_25176__$1;
(statearr_25227_25354[(2)] = inst_25076);

(statearr_25227_25354[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (61))){
var inst_25042 = (state_25176[(24)]);
var inst_25089 = (state_25176[(7)]);
var inst_25027 = (state_25176[(8)]);
var inst_25104 = cljs.core.count(inst_25089);
var inst_25105 = (inst_25042 - inst_25104);
var inst_25106 = (inst_25027 - inst_25105);
var state_25176__$1 = state_25176;
var statearr_25228_25355 = state_25176__$1;
(statearr_25228_25355[(2)] = inst_25106);

(statearr_25228_25355[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (29))){
var inst_25053 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
if(cljs.core.truth_(inst_25053)){
var statearr_25229_25356 = state_25176__$1;
(statearr_25229_25356[(1)] = (30));

} else {
var statearr_25230_25357 = state_25176__$1;
(statearr_25230_25357[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (44))){
var inst_25073 = (state_25176[(31)]);
var state_25176__$1 = state_25176;
var statearr_25231_25358 = state_25176__$1;
(statearr_25231_25358[(2)] = inst_25073);

(statearr_25231_25358[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (6))){
var inst_24966 = (state_25176[(32)]);
var inst_24966__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_24968 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_25176__$1 = (function (){var statearr_25232 = state_25176;
(statearr_25232[(32)] = inst_24966__$1);

(statearr_25232[(33)] = inst_24968);

return statearr_25232;
})();
if(cljs.core.truth_(inst_24966__$1)){
var statearr_25233_25359 = state_25176__$1;
(statearr_25233_25359[(1)] = (9));

} else {
var statearr_25234_25360 = state_25176__$1;
(statearr_25234_25360[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (28))){
var inst_25026 = (state_25176[(9)]);
var state_25176__$1 = state_25176;
var statearr_25235_25361 = state_25176__$1;
(statearr_25235_25361[(2)] = inst_25026);

(statearr_25235_25361[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (64))){
var inst_25114 = (state_25176[(34)]);
var state_25176__$1 = state_25176;
var statearr_25236_25362 = state_25176__$1;
(statearr_25236_25362[(2)] = inst_25114);

(statearr_25236_25362[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (51))){
var inst_25026 = (state_25176[(9)]);
var inst_25089 = (state_25176[(2)]);
var inst_25090 = (inst_25026 == null);
var state_25176__$1 = (function (){var statearr_25237 = state_25176;
(statearr_25237[(7)] = inst_25089);

return statearr_25237;
})();
if(cljs.core.truth_(inst_25090)){
var statearr_25238_25363 = state_25176__$1;
(statearr_25238_25363[(1)] = (52));

} else {
var statearr_25239_25364 = state_25176__$1;
(statearr_25239_25364[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (25))){
var inst_25026 = (state_25176[(9)]);
var state_25176__$1 = state_25176;
if(cljs.core.truth_(inst_25026)){
var statearr_25240_25365 = state_25176__$1;
(statearr_25240_25365[(1)] = (27));

} else {
var statearr_25241_25366 = state_25176__$1;
(statearr_25241_25366[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (34))){
var state_25176__$1 = state_25176;
var statearr_25242_25367 = state_25176__$1;
(statearr_25242_25367[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (17))){
var state_25176__$1 = state_25176;
var statearr_25244_25368 = state_25176__$1;
(statearr_25244_25368[(2)] = limit);

(statearr_25244_25368[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (3))){
var inst_25174 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25176__$1,inst_25174);
} else {
if((state_val_25177 === (12))){
var inst_24974 = (state_25176[(25)]);
var inst_24976 = cljs.core.keys(inst_24974);
var inst_24977 = cljs.core.first(inst_24976);
var inst_24978 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24979 = cljs.core.vals(inst_24974);
var inst_24980 = cljs.core.first(inst_24979);
var inst_24981 = [headers,vars,inst_24980];
var inst_24982 = cljs.core.PersistentHashMap.fromArrays(inst_24978,inst_24981);
var inst_24983 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_24982,select_spec,limit,opts);
var state_25176__$1 = (function (){var statearr_25245 = state_25176;
(statearr_25245[(19)] = inst_24977);

return statearr_25245;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25176__$1,(15),inst_24983);
} else {
if((state_val_25177 === (2))){
var _ = (function (){var statearr_25246 = state_25176;
(statearr_25246[(4)] = cljs.core.cons((5),(state_25176[(4)])));

return statearr_25246;
})();
var state_25176__$1 = state_25176;
if(cljs.core.truth_(groupBy)){
var statearr_25247_25369 = state_25176__$1;
(statearr_25247_25369[(1)] = (6));

} else {
var statearr_25248_25370 = state_25176__$1;
(statearr_25248_25370[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (66))){
var inst_25119 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
if(cljs.core.truth_(inst_25119)){
var statearr_25249_25371 = state_25176__$1;
(statearr_25249_25371[(1)] = (67));

} else {
var statearr_25250_25372 = state_25176__$1;
(statearr_25250_25372[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (23))){
var inst_25136 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25251_25373 = state_25176__$1;
(statearr_25251_25373[(2)] = inst_25136);

(statearr_25251_25373[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (47))){
var inst_25026 = (state_25176[(9)]);
var state_25176__$1 = state_25176;
var statearr_25252_25374 = state_25176__$1;
(statearr_25252_25374[(2)] = inst_25026);

(statearr_25252_25374[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (35))){
var inst_25130 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25253_25375 = state_25176__$1;
(statearr_25253_25375[(2)] = inst_25130);

(statearr_25253_25375[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (82))){
var inst_25167 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25254_25376 = state_25176__$1;
(statearr_25254_25376[(2)] = inst_25167);

(statearr_25254_25376[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (76))){
var inst_25169 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25255_25377 = state_25176__$1;
(statearr_25255_25377[(2)] = inst_25169);

(statearr_25255_25377[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (19))){
var inst_25018 = (state_25176[(35)]);
var state_25176__$1 = state_25176;
var statearr_25256_25378 = state_25176__$1;
(statearr_25256_25378[(2)] = inst_25018);

(statearr_25256_25378[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (57))){
var inst_25114 = (state_25176[(34)]);
var inst_25089 = (state_25176[(7)]);
var inst_25113 = (state_25176[(2)]);
var inst_25114__$1 = (inst_25089 == null);
var state_25176__$1 = (function (){var statearr_25257 = state_25176;
(statearr_25257[(34)] = inst_25114__$1);

(statearr_25257[(10)] = inst_25113);

return statearr_25257;
})();
if(cljs.core.truth_(inst_25114__$1)){
var statearr_25258_25379 = state_25176__$1;
(statearr_25258_25379[(1)] = (64));

} else {
var statearr_25259_25380 = state_25176__$1;
(statearr_25259_25380[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (68))){
var inst_25028 = (state_25176[(14)]);
var inst_25037 = (state_25176[(30)]);
var inst_25089 = (state_25176[(7)]);
var inst_25122 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25028,inst_25037,inst_25089);
var state_25176__$1 = state_25176;
var statearr_25260_25381 = state_25176__$1;
(statearr_25260_25381[(2)] = inst_25122);

(statearr_25260_25381[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (11))){
var inst_24974 = (state_25176[(2)]);
var state_25176__$1 = (function (){var statearr_25262 = state_25176;
(statearr_25262[(25)] = inst_24974);

return statearr_25262;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25263_25382 = state_25176__$1;
(statearr_25263_25382[(1)] = (12));

} else {
var statearr_25264_25383 = state_25176__$1;
(statearr_25264_25383[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (9))){
var inst_24966 = (state_25176[(32)]);
var inst_24968 = (state_25176[(33)]);
var inst_24970 = cljs.core.sorted_map_by(inst_24966);
var inst_24971 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24970,inst_24968);
var state_25176__$1 = state_25176;
var statearr_25265_25384 = state_25176__$1;
(statearr_25265_25384[(2)] = inst_24971);

(statearr_25265_25384[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (5))){
var _ = (function (){var statearr_25266 = state_25176;
(statearr_25266[(4)] = cljs.core.rest((state_25176[(4)])));

return statearr_25266;
})();
var state_25176__$1 = state_25176;
var ex25261 = (state_25176__$1[(2)]);
var statearr_25267_25385 = state_25176__$1;
(statearr_25267_25385[(5)] = ex25261);


if((ex25261 instanceof Error)){
var statearr_25268_25386 = state_25176__$1;
(statearr_25268_25386[(1)] = (4));

(statearr_25268_25386[(5)] = null);

} else {
throw ex25261;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (83))){
var inst_25147 = (state_25176[(18)]);
var state_25176__$1 = state_25176;
var statearr_25269_25387 = state_25176__$1;
(statearr_25269_25387[(2)] = inst_25147);

(statearr_25269_25387[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (14))){
var inst_25138 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25270_25388 = state_25176__$1;
(statearr_25270_25388[(2)] = inst_25138);

(statearr_25270_25388[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (45))){
var inst_25026 = (state_25176[(9)]);
var inst_25079 = (state_25176[(2)]);
var state_25176__$1 = (function (){var statearr_25271 = state_25176;
(statearr_25271[(20)] = inst_25079);

return statearr_25271;
})();
if(cljs.core.truth_(inst_25026)){
var statearr_25272_25389 = state_25176__$1;
(statearr_25272_25389[(1)] = (46));

} else {
var statearr_25273_25390 = state_25176__$1;
(statearr_25273_25390[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (53))){
var inst_25026 = (state_25176[(9)]);
var inst_25089 = (state_25176[(7)]);
var inst_25093 = cljs.core.count(inst_25089);
var inst_25094 = (inst_25026 - inst_25093);
var state_25176__$1 = state_25176;
var statearr_25274_25391 = state_25176__$1;
(statearr_25274_25391[(2)] = inst_25094);

(statearr_25274_25391[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (78))){
var inst_25147 = (state_25176[(18)]);
var state_25176__$1 = state_25176;
var statearr_25275_25392 = state_25176__$1;
(statearr_25275_25392[(2)] = inst_25147);

(statearr_25275_25392[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (26))){
var inst_25134 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25276_25393 = state_25176__$1;
(statearr_25276_25393[(2)] = inst_25134);

(statearr_25276_25393[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (16))){
var state_25176__$1 = state_25176;
var statearr_25277_25394 = state_25176__$1;
(statearr_25277_25394[(2)] = null);

(statearr_25277_25394[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (81))){
var state_25176__$1 = state_25176;
var statearr_25280_25395 = state_25176__$1;
(statearr_25280_25395[(1)] = (83));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (79))){
var inst_25157 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25282_25396 = state_25176__$1;
(statearr_25282_25396[(2)] = inst_25157);

(statearr_25282_25396[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (38))){
var inst_25028 = (state_25176[(14)]);
var inst_25041 = (state_25176[(11)]);
var inst_25026 = (state_25176[(9)]);
var inst_25038 = (state_25176[(12)]);
var inst_25063 = (state_25176[(2)]);
var tmp25278 = inst_25028;
var tmp25279 = inst_25026;
var inst_25024 = inst_25038;
var inst_25025 = inst_25041;
var inst_25026__$1 = tmp25279;
var inst_25027 = inst_25063;
var inst_25028__$1 = tmp25278;
var state_25176__$1 = (function (){var statearr_25283 = state_25176;
(statearr_25283[(14)] = inst_25028__$1);

(statearr_25283[(15)] = inst_25024);

(statearr_25283[(16)] = inst_25025);

(statearr_25283[(9)] = inst_25026__$1);

(statearr_25283[(8)] = inst_25027);

return statearr_25283;
})();
var statearr_25284_25397 = state_25176__$1;
(statearr_25284_25397[(2)] = null);

(statearr_25284_25397[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (30))){
var inst_25028 = (state_25176[(14)]);
var state_25176__$1 = state_25176;
var statearr_25285_25398 = state_25176__$1;
(statearr_25285_25398[(2)] = inst_25028);

(statearr_25285_25398[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (73))){
var inst_25147 = (state_25176[(18)]);
var inst_25146 = (state_25176[(2)]);
var inst_25147__$1 = fluree.db.util.async.throw_err(inst_25146);
var inst_25148 = cljs.core.coll_QMARK_(inst_25147__$1);
var inst_25149 = (!(inst_25148));
var state_25176__$1 = (function (){var statearr_25286 = state_25176;
(statearr_25286[(18)] = inst_25147__$1);

return statearr_25286;
})();
if(inst_25149){
var statearr_25287_25399 = state_25176__$1;
(statearr_25287_25399[(1)] = (74));

} else {
var statearr_25288_25400 = state_25176__$1;
(statearr_25288_25400[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (10))){
var inst_24968 = (state_25176[(33)]);
var state_25176__$1 = state_25176;
var statearr_25289_25401 = state_25176__$1;
(statearr_25289_25401[(2)] = inst_24968);

(statearr_25289_25401[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (18))){
var inst_25018 = (state_25176[(35)]);
var inst_25017 = (state_25176[(2)]);
var inst_25018__$1 = offset;
var state_25176__$1 = (function (){var statearr_25290 = state_25176;
(statearr_25290[(35)] = inst_25018__$1);

(statearr_25290[(21)] = inst_25017);

return statearr_25290;
})();
if(cljs.core.truth_(inst_25018__$1)){
var statearr_25291_25402 = state_25176__$1;
(statearr_25291_25402[(1)] = (19));

} else {
var statearr_25292_25403 = state_25176__$1;
(statearr_25292_25403[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (52))){
var state_25176__$1 = state_25176;
var statearr_25293_25404 = state_25176__$1;
(statearr_25293_25404[(2)] = null);

(statearr_25293_25404[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (67))){
var inst_25028 = (state_25176[(14)]);
var state_25176__$1 = state_25176;
var statearr_25294_25405 = state_25176__$1;
(statearr_25294_25405[(2)] = inst_25028);

(statearr_25294_25405[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (71))){
var state_25176__$1 = state_25176;
var statearr_25295_25406 = state_25176__$1;
(statearr_25295_25406[(2)] = limit);

(statearr_25295_25406[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (42))){
var inst_25027 = (state_25176[(8)]);
var inst_25072 = (state_25176[(2)]);
var inst_25073 = fluree.db.util.async.throw_err(inst_25072);
var inst_25074 = ((0) < inst_25027);
var state_25176__$1 = (function (){var statearr_25296 = state_25176;
(statearr_25296[(31)] = inst_25073);

return statearr_25296;
})();
if(cljs.core.truth_(inst_25074)){
var statearr_25297_25407 = state_25176__$1;
(statearr_25297_25407[(1)] = (43));

} else {
var statearr_25298_25408 = state_25176__$1;
(statearr_25298_25408[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (80))){
var inst_25147 = (state_25176[(18)]);
var inst_25160 = cljs.core.first(inst_25147);
var state_25176__$1 = state_25176;
var statearr_25299_25409 = state_25176__$1;
(statearr_25299_25409[(2)] = inst_25160);

(statearr_25299_25409[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (37))){
var inst_25042 = (state_25176[(24)]);
var inst_25027 = (state_25176[(8)]);
var inst_25061 = (inst_25027 - inst_25042);
var state_25176__$1 = state_25176;
var statearr_25300_25410 = state_25176__$1;
(statearr_25300_25410[(2)] = inst_25061);

(statearr_25300_25410[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (63))){
var inst_25109 = (state_25176[(2)]);
var state_25176__$1 = state_25176;
var statearr_25301_25411 = state_25176__$1;
(statearr_25301_25411[(2)] = inst_25109);

(statearr_25301_25411[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (8))){
var inst_25171 = (state_25176[(2)]);
var _ = (function (){var statearr_25302 = state_25176;
(statearr_25302[(4)] = cljs.core.rest((state_25176[(4)])));

return statearr_25302;
})();
var state_25176__$1 = state_25176;
var statearr_25303_25412 = state_25176__$1;
(statearr_25303_25412[(2)] = inst_25171);

(statearr_25303_25412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (49))){
var inst_25079 = (state_25176[(20)]);
var inst_25026 = (state_25176[(9)]);
var inst_25086 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_25026,inst_25079);
var state_25176__$1 = state_25176;
var statearr_25304_25413 = state_25176__$1;
(statearr_25304_25413[(2)] = inst_25086);

(statearr_25304_25413[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25177 === (84))){
var state_25176__$1 = state_25176;
var statearr_25305_25414 = state_25176__$1;
(statearr_25305_25414[(2)] = null);

(statearr_25305_25414[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto____0 = (function (){
var statearr_25306 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25306[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto__);

(statearr_25306[(1)] = (1));

return statearr_25306;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto____1 = (function (state_25176){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_25176);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e25307){var ex__2736__auto__ = e25307;
var statearr_25308_25415 = state_25176;
(statearr_25308_25415[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_25176[(4)]))){
var statearr_25309_25416 = state_25176;
(statearr_25309_25416[(1)] = cljs.core.first((state_25176[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25417 = state_25176;
state_25176 = G__25417;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto__ = function(state_25176){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto____1.call(this,state_25176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_25310 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_25310[(6)] = c__2755__auto__);

return statearr_25310;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25420,opts){
var map__25421 = p__25420;
var map__25421__$1 = cljs.core.__destructure_map(map__25421);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25421__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25421__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25421__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25421__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4223__auto__ = selectOne;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = select;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
var or__4223__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4223__auto____$2)){
return or__4223__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__25418_SHARP_){
return cljs.core.contains_QMARK_(p1__25418_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__25419_SHARP_){
return cljs.core.contains_QMARK_(p1__25419_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4223__auto__ = typeof orderBy === 'string';
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4221__auto__){
var G__25423 = cljs.core.first(orderBy);
var fexpr__25422 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__25422.cljs$core$IFn$_invoke$arity$1 ? fexpr__25422.cljs$core$IFn$_invoke$arity$1(G__25423) : fexpr__25422.call(null,G__25423));
} else {
return and__4221__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})(),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4223__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4223__auto__ = selectDistinct;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25424,p__25425){
var map__25426 = p__25424;
var map__25426__$1 = cljs.core.__destructure_map(map__25426);
var query_map = map__25426__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25426__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25427 = p__25425;
var map__25427__$1 = cljs.core.__destructure_map(map__25427);
var where_result = map__25427__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25427__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25427__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25428 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25428,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25428,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25428,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_25461){
var state_val_25462 = (state_25461[(1)]);
if((state_val_25462 === (7))){
var inst_25440 = (state_25461[(7)]);
var state_25461__$1 = state_25461;
var statearr_25463_25486 = state_25461__$1;
(statearr_25463_25486[(2)] = inst_25440);

(statearr_25463_25486[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25462 === (1))){
var state_25461__$1 = state_25461;
var statearr_25464_25487 = state_25461__$1;
(statearr_25464_25487[(2)] = null);

(statearr_25464_25487[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25462 === (4))){
var inst_25431 = (state_25461[(2)]);
var state_25461__$1 = state_25461;
var statearr_25465_25488 = state_25461__$1;
(statearr_25465_25488[(2)] = inst_25431);

(statearr_25465_25488[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25462 === (13))){
var inst_25450 = (state_25461[(2)]);
var inst_25451 = fluree.db.util.async.throw_err(inst_25450);
var state_25461__$1 = state_25461;
var statearr_25466_25489 = state_25461__$1;
(statearr_25466_25489[(2)] = inst_25451);

(statearr_25466_25489[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25462 === (6))){
var inst_25440 = (state_25461[(7)]);
var inst_25439 = (state_25461[(2)]);
var inst_25440__$1 = fluree.db.util.async.throw_err(inst_25439);
var inst_25441 = fluree.db.util.core.exception_QMARK_(inst_25440__$1);
var state_25461__$1 = (function (){var statearr_25467 = state_25461;
(statearr_25467[(7)] = inst_25440__$1);

return statearr_25467;
})();
if(inst_25441){
var statearr_25468_25490 = state_25461__$1;
(statearr_25468_25490[(1)] = (7));

} else {
var statearr_25469_25491 = state_25461__$1;
(statearr_25469_25491[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25462 === (3))){
var inst_25459 = (state_25461[(2)]);
var state_25461__$1 = state_25461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25461__$1,inst_25459);
} else {
if((state_val_25462 === (12))){
var inst_25454 = (state_25461[(2)]);
var state_25461__$1 = state_25461;
var statearr_25470_25492 = state_25461__$1;
(statearr_25470_25492[(2)] = inst_25454);

(statearr_25470_25492[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25462 === (2))){
var _ = (function (){var statearr_25471 = state_25461;
(statearr_25471[(4)] = cljs.core.cons((5),(state_25461[(4)])));

return statearr_25471;
})();
var inst_25437 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_25461__$1 = state_25461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25461__$1,(6),inst_25437);
} else {
if((state_val_25462 === (11))){
var state_25461__$1 = state_25461;
var statearr_25473_25493 = state_25461__$1;
(statearr_25473_25493[(2)] = null);

(statearr_25473_25493[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25462 === (9))){
var inst_25456 = (state_25461[(2)]);
var _ = (function (){var statearr_25474 = state_25461;
(statearr_25474[(4)] = cljs.core.rest((state_25461[(4)])));

return statearr_25474;
})();
var state_25461__$1 = state_25461;
var statearr_25475_25494 = state_25461__$1;
(statearr_25475_25494[(2)] = inst_25456);

(statearr_25475_25494[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25462 === (5))){
var _ = (function (){var statearr_25476 = state_25461;
(statearr_25476[(4)] = cljs.core.rest((state_25461[(4)])));

return statearr_25476;
})();
var state_25461__$1 = state_25461;
var ex25472 = (state_25461__$1[(2)]);
var statearr_25477_25495 = state_25461__$1;
(statearr_25477_25495[(5)] = ex25472);


if((ex25472 instanceof Error)){
var statearr_25478_25496 = state_25461__$1;
(statearr_25478_25496[(1)] = (4));

(statearr_25478_25496[(5)] = null);

} else {
throw ex25472;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25462 === (10))){
var inst_25440 = (state_25461[(7)]);
var inst_25445 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25440);
var inst_25446 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25440);
var inst_25447 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_25445,inst_25446,query_map,opts);
var inst_25448 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_25440,inst_25447,opts);
var state_25461__$1 = state_25461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25461__$1,(13),inst_25448);
} else {
if((state_val_25462 === (8))){
var state_25461__$1 = state_25461;
var statearr_25479_25497 = state_25461__$1;
(statearr_25479_25497[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto____0 = (function (){
var statearr_25481 = [null,null,null,null,null,null,null,null];
(statearr_25481[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto__);

(statearr_25481[(1)] = (1));

return statearr_25481;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto____1 = (function (state_25461){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_25461);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e25482){var ex__2736__auto__ = e25482;
var statearr_25483_25498 = state_25461;
(statearr_25483_25498[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_25461[(4)]))){
var statearr_25484_25499 = state_25461;
(statearr_25484_25499[(1)] = cljs.core.first((state_25461[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25500 = state_25461;
state_25461 = G__25500;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto__ = function(state_25461){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto____1.call(this,state_25461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_25485 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_25485[(6)] = c__2755__auto__);

return statearr_25485;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__25501 = query_map;
var map__25501__$1 = cljs.core.__destructure_map(map__25501);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25501__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25501__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25501__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25501__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25501__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25501__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25501__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25501__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25501__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25501__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25501__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25501__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__25502 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4223__auto__ = offset;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__25502,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__25502;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4223__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.truth_((function (){var or__4223__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_25861){
var state_val_25862 = (state_25861[(1)]);
if((state_val_25862 === (121))){
var inst_25822 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25863_26058 = state_25861__$1;
(statearr_25863_26058[(2)] = inst_25822);

(statearr_25863_26058[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (65))){
var inst_25695 = typeof from === 'string';
var state_25861__$1 = state_25861;
if(cljs.core.truth_(inst_25695)){
var statearr_25864_26059 = state_25861__$1;
(statearr_25864_26059[(1)] = (72));

} else {
var statearr_25865_26060 = state_25861__$1;
(statearr_25865_26060[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (70))){
var inst_25564 = (state_25861[(7)]);
var inst_25566 = (state_25861[(8)]);
var inst_25688 = (state_25861[(2)]);
var inst_25689 = fluree.db.util.async.throw_err(inst_25688);
var inst_25690 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25566,fuel,max_fuel,inst_25564,inst_25689);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25861__$1,(71),inst_25690);
} else {
if((state_val_25862 === (62))){
var inst_25668 = (state_25861[(9)]);
var state_25861__$1 = state_25861;
var statearr_25866_26061 = state_25861__$1;
(statearr_25866_26061[(2)] = inst_25668);

(statearr_25866_26061[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (74))){
var inst_25828 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25867_26062 = state_25861__$1;
(statearr_25867_26062[(2)] = inst_25828);

(statearr_25867_26062[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (110))){
var inst_25761 = (state_25861[(10)]);
var state_25861__$1 = state_25861;
var statearr_25868_26063 = state_25861__$1;
(statearr_25868_26063[(2)] = inst_25761);

(statearr_25868_26063[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (130))){
var inst_25848 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25869_26064 = state_25861__$1;
(statearr_25869_26064[(2)] = inst_25848);

(statearr_25869_26064[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (128))){
var inst_25839 = (state_25861[(11)]);
var inst_25844 = fluree.db.util.core.exception_QMARK_(inst_25839);
var inst_25845 = (!(inst_25844));
var state_25861__$1 = state_25861;
var statearr_25870_26065 = state_25861__$1;
(statearr_25870_26065[(2)] = inst_25845);

(statearr_25870_26065[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (7))){
var inst_25534 = (state_25861[(12)]);
var inst_25534__$1 = selectOne;
var state_25861__$1 = (function (){var statearr_25871 = state_25861;
(statearr_25871[(12)] = inst_25534__$1);

return statearr_25871;
})();
if(cljs.core.truth_(inst_25534__$1)){
var statearr_25872_26066 = state_25861__$1;
(statearr_25872_26066[(1)] = (9));

} else {
var statearr_25873_26067 = state_25861__$1;
(statearr_25873_26067[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (59))){
var inst_25564 = (state_25861[(7)]);
var inst_25554 = (state_25861[(13)]);
var inst_25646 = (state_25861[(14)]);
var inst_25566 = (state_25861[(8)]);
var inst_25660 = (state_25861[(2)]);
var inst_25661 = fluree.db.util.async.throw_err(inst_25660);
var inst_25662 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_25646,inst_25661);
var inst_25663 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_25566,fuel,max_fuel,inst_25564,inst_25662,inst_25554);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25861__$1,(60),inst_25663);
} else {
if((state_val_25862 === (86))){
var inst_25564 = (state_25861[(7)]);
var inst_25554 = (state_25861[(13)]);
var inst_25566 = (state_25861[(8)]);
var inst_25556 = (state_25861[(15)]);
var inst_25728 = (state_25861[(2)]);
var inst_25729 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25566,fuel,max_fuel,inst_25564,inst_25728,inst_25554,inst_25556);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25861__$1,(87),inst_25729);
} else {
if((state_val_25862 === (20))){
var inst_25598 = (state_25861[(2)]);
var inst_25599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25598,(0),null);
var inst_25600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25598,(1),null);
var inst_25601 = typeof where === 'string';
var state_25861__$1 = (function (){var statearr_25874 = state_25861;
(statearr_25874[(16)] = inst_25600);

(statearr_25874[(17)] = inst_25599);

return statearr_25874;
})();
if(cljs.core.truth_(inst_25601)){
var statearr_25875_26068 = state_25861__$1;
(statearr_25875_26068[(1)] = (30));

} else {
var statearr_25876_26069 = state_25861__$1;
(statearr_25876_26069[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (72))){
var inst_25553 = (state_25861[(18)]);
var state_25861__$1 = state_25861;
if(cljs.core.truth_(inst_25553)){
var statearr_25877_26070 = state_25861__$1;
(statearr_25877_26070[(1)] = (75));

} else {
var statearr_25878_26071 = state_25861__$1;
(statearr_25878_26071[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (58))){
var inst_25654 = (state_25861[(2)]);
var inst_25655 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25656 = [from];
var inst_25657 = (new cljs.core.PersistentVector(null,1,(5),inst_25655,inst_25656,null));
var inst_25658 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25657,inst_25654);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25861__$1,(59),inst_25658);
} else {
if((state_val_25862 === (60))){
var inst_25665 = (state_25861[(2)]);
var inst_25666 = fluree.db.util.async.throw_err(inst_25665);
var state_25861__$1 = state_25861;
var statearr_25879_26072 = state_25861__$1;
(statearr_25879_26072[(2)] = inst_25666);

(statearr_25879_26072[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (27))){
var inst_25583 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25584 = [null,null];
var inst_25585 = (new cljs.core.PersistentVector(null,2,(5),inst_25583,inst_25584,null));
var state_25861__$1 = state_25861;
var statearr_25880_26073 = state_25861__$1;
(statearr_25880_26073[(2)] = inst_25585);

(statearr_25880_26073[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (1))){
var state_25861__$1 = state_25861;
var statearr_25881_26074 = state_25861__$1;
(statearr_25881_26074[(2)] = null);

(statearr_25881_26074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (69))){
var inst_25685 = (state_25861[(2)]);
var inst_25686 = fluree.db.query.range._block_or_tx_collection(db,inst_25685);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25861__$1,(70),inst_25686);
} else {
if((state_val_25862 === (101))){
var inst_25795 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25882_26075 = state_25861__$1;
(statearr_25882_26075[(2)] = inst_25795);

(statearr_25882_26075[(1)] = (98));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (24))){
var inst_25553 = (state_25861[(18)]);
var inst_25578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25579 = [inst_25553,"ASC"];
var inst_25580 = (new cljs.core.PersistentVector(null,2,(5),inst_25578,inst_25579,null));
var state_25861__$1 = state_25861;
var statearr_25883_26076 = state_25861__$1;
(statearr_25883_26076[(2)] = inst_25580);

(statearr_25883_26076[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (102))){
var inst_25767 = (state_25861[(19)]);
var state_25861__$1 = state_25861;
var statearr_25884_26077 = state_25861__$1;
(statearr_25884_26077[(2)] = inst_25767);

(statearr_25884_26077[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (55))){
var inst_25553 = (state_25861[(18)]);
var inst_25646 = (state_25861[(2)]);
var state_25861__$1 = (function (){var statearr_25885 = state_25861;
(statearr_25885[(14)] = inst_25646);

return statearr_25885;
})();
if(cljs.core.truth_(inst_25553)){
var statearr_25886_26078 = state_25861__$1;
(statearr_25886_26078[(1)] = (56));

} else {
var statearr_25887_26079 = state_25861__$1;
(statearr_25887_26079[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (85))){
var inst_25720 = (state_25861[(20)]);
var inst_25724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25725 = [inst_25720];
var inst_25726 = (new cljs.core.PersistentVector(null,1,(5),inst_25724,inst_25725,null));
var state_25861__$1 = state_25861;
var statearr_25888_26080 = state_25861__$1;
(statearr_25888_26080[(2)] = inst_25726);

(statearr_25888_26080[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (39))){
var inst_25554 = (state_25861[(13)]);
var state_25861__$1 = state_25861;
var statearr_25889_26081 = state_25861__$1;
(statearr_25889_26081[(2)] = inst_25554);

(statearr_25889_26081[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (88))){
var inst_25734 = cljs.core._deref(fuel);
var inst_25735 = (inst_25734 + (1));
var inst_25736 = cljs.core._vreset_BANG_(fuel,inst_25735);
var state_25861__$1 = state_25861;
var statearr_25890_26082 = state_25861__$1;
(statearr_25890_26082[(2)] = inst_25736);

(statearr_25890_26082[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (46))){
var inst_25631 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
if(cljs.core.truth_(inst_25631)){
var statearr_25891_26083 = state_25861__$1;
(statearr_25891_26083[(1)] = (47));

} else {
var statearr_25892_26084 = state_25861__$1;
(statearr_25892_26084[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (4))){
var inst_25521 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25893_26085 = state_25861__$1;
(statearr_25893_26085[(2)] = inst_25521);

(statearr_25893_26085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (77))){
var inst_25704 = (state_25861[(2)]);
var inst_25705 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_25704);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25861__$1,(78),inst_25705);
} else {
if((state_val_25862 === (106))){
var state_25861__$1 = state_25861;
var statearr_25894_26086 = state_25861__$1;
(statearr_25894_26086[(2)] = null);

(statearr_25894_26086[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (119))){
var inst_25814 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_25815 = ["Invalid 'from' in query:",inst_25814].join('');
var inst_25816 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25817 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25818 = cljs.core.PersistentHashMap.fromArrays(inst_25816,inst_25817);
var inst_25819 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25815,inst_25818);
var state_25861__$1 = state_25861;
var statearr_25895_26087 = state_25861__$1;
(statearr_25895_26087[(2)] = inst_25819);

(statearr_25895_26087[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (95))){
var state_25861__$1 = state_25861;
var statearr_25896_26088 = state_25861__$1;
(statearr_25896_26088[(1)] = (119));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (54))){
var inst_25640 = (state_25861[(21)]);
var state_25861__$1 = state_25861;
var statearr_25898_26089 = state_25861__$1;
(statearr_25898_26089[(2)] = inst_25640);

(statearr_25898_26089[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (92))){
var inst_25741 = (state_25861[(22)]);
var state_25861__$1 = state_25861;
var statearr_25899_26090 = state_25861__$1;
(statearr_25899_26090[(2)] = inst_25741);

(statearr_25899_26090[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (104))){
var inst_25787 = (state_25861[(23)]);
var inst_25787__$1 = (state_25861[(2)]);
var state_25861__$1 = (function (){var statearr_25900 = state_25861;
(statearr_25900[(23)] = inst_25787__$1);

return statearr_25900;
})();
if(cljs.core.truth_(inst_25787__$1)){
var statearr_25901_26091 = state_25861__$1;
(statearr_25901_26091[(1)] = (109));

} else {
var statearr_25902_26092 = state_25861__$1;
(statearr_25902_26092[(1)] = (110));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (15))){
var inst_25555 = (state_25861[(24)]);
var inst_25557 = (state_25861[(25)]);
var inst_25561 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25557,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25555);
var state_25861__$1 = state_25861;
var statearr_25903_26093 = state_25861__$1;
(statearr_25903_26093[(2)] = inst_25561);

(statearr_25903_26093[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (48))){
var inst_25668 = (state_25861[(9)]);
var inst_25668__$1 = typeof from === 'string';
var state_25861__$1 = (function (){var statearr_25904 = state_25861;
(statearr_25904[(9)] = inst_25668__$1);

return statearr_25904;
})();
if(cljs.core.truth_(inst_25668__$1)){
var statearr_25905_26094 = state_25861__$1;
(statearr_25905_26094[(1)] = (61));

} else {
var statearr_25906_26095 = state_25861__$1;
(statearr_25906_26095[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (50))){
var inst_25634 = (state_25861[(26)]);
var inst_25636 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_25637 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_25634,inst_25636);
var state_25861__$1 = state_25861;
var statearr_25907_26096 = state_25861__$1;
(statearr_25907_26096[(2)] = inst_25637);

(statearr_25907_26096[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (116))){
var state_25861__$1 = state_25861;
var statearr_25908_26097 = state_25861__$1;
(statearr_25908_26097[(2)] = null);

(statearr_25908_26097[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (75))){
var inst_25698 = cljs.core.PersistentHashMap.EMPTY;
var state_25861__$1 = state_25861;
var statearr_25909_26098 = state_25861__$1;
(statearr_25909_26098[(2)] = inst_25698);

(statearr_25909_26098[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (99))){
var inst_25761 = (state_25861[(10)]);
var state_25861__$1 = state_25861;
var statearr_25910_26099 = state_25861__$1;
(statearr_25910_26099[(2)] = inst_25761);

(statearr_25910_26099[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (21))){
var inst_25553 = (state_25861[(18)]);
var inst_25570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25571 = cljs.core.second(inst_25553);
var inst_25572 = cljs.core.first(inst_25553);
var inst_25573 = [inst_25571,inst_25572];
var inst_25574 = (new cljs.core.PersistentVector(null,2,(5),inst_25570,inst_25573,null));
var state_25861__$1 = state_25861;
var statearr_25911_26100 = state_25861__$1;
(statearr_25911_26100[(2)] = inst_25574);

(statearr_25911_26100[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (31))){
var inst_25625 = (state_25861[(27)]);
var inst_25625__$1 = typeof from === 'string';
var state_25861__$1 = (function (){var statearr_25912 = state_25861;
(statearr_25912[(27)] = inst_25625__$1);

return statearr_25912;
})();
if(cljs.core.truth_(inst_25625__$1)){
var statearr_25913_26101 = state_25861__$1;
(statearr_25913_26101[(1)] = (44));

} else {
var statearr_25914_26102 = state_25861__$1;
(statearr_25914_26102[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (113))){
var state_25861__$1 = state_25861;
var statearr_25915_26103 = state_25861__$1;
(statearr_25915_26103[(2)] = null);

(statearr_25915_26103[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (32))){
var inst_25599 = (state_25861[(17)]);
var inst_25834 = (state_25861[(2)]);
var state_25861__$1 = (function (){var statearr_25916 = state_25861;
(statearr_25916[(28)] = inst_25834);

return statearr_25916;
})();
if(cljs.core.truth_(inst_25599)){
var statearr_25917_26104 = state_25861__$1;
(statearr_25917_26104[(1)] = (122));

} else {
var statearr_25918_26105 = state_25861__$1;
(statearr_25918_26105[(1)] = (123));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (40))){
var inst_25553 = (state_25861[(18)]);
var inst_25615 = (state_25861[(2)]);
var state_25861__$1 = (function (){var statearr_25919 = state_25861;
(statearr_25919[(29)] = inst_25615);

return statearr_25919;
})();
if(cljs.core.truth_(inst_25553)){
var statearr_25920_26106 = state_25861__$1;
(statearr_25920_26106[(1)] = (41));

} else {
var statearr_25921_26107 = state_25861__$1;
(statearr_25921_26107[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (129))){
var inst_25842 = (state_25861[(30)]);
var state_25861__$1 = state_25861;
var statearr_25922_26108 = state_25861__$1;
(statearr_25922_26108[(2)] = inst_25842);

(statearr_25922_26108[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (91))){
var inst_25743 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_25861__$1 = state_25861;
var statearr_25923_26109 = state_25861__$1;
(statearr_25923_26109[(2)] = inst_25743);

(statearr_25923_26109[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (117))){
var inst_25556 = (state_25861[(15)]);
var state_25861__$1 = state_25861;
var statearr_25924_26110 = state_25861__$1;
(statearr_25924_26110[(2)] = inst_25556);

(statearr_25924_26110[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (108))){
var inst_25784 = (state_25861[(2)]);
var inst_25785 = fluree.db.util.async.throw_err(inst_25784);
var state_25861__$1 = state_25861;
var statearr_25925_26111 = state_25861__$1;
(statearr_25925_26111[(2)] = inst_25785);

(statearr_25925_26111[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (56))){
var inst_25648 = cljs.core.PersistentHashMap.EMPTY;
var state_25861__$1 = state_25861;
var statearr_25926_26112 = state_25861__$1;
(statearr_25926_26112[(2)] = inst_25648);

(statearr_25926_26112[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (33))){
var state_25861__$1 = state_25861;
var statearr_25927_26113 = state_25861__$1;
(statearr_25927_26113[(2)] = from);

(statearr_25927_26113[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (13))){
var inst_25540 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25541 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25542 = cljs.core.PersistentHashMap.fromArrays(inst_25540,inst_25541);
var inst_25543 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_25542);
var inst_25544 = (function(){throw inst_25543})();
var state_25861__$1 = state_25861;
var statearr_25928_26114 = state_25861__$1;
(statearr_25928_26114[(2)] = inst_25544);

(statearr_25928_26114[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (22))){
var inst_25553 = (state_25861[(18)]);
var inst_25576 = typeof inst_25553 === 'string';
var state_25861__$1 = state_25861;
if(cljs.core.truth_(inst_25576)){
var statearr_25929_26115 = state_25861__$1;
(statearr_25929_26115[(1)] = (24));

} else {
var statearr_25930_26116 = state_25861__$1;
(statearr_25930_26116[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (90))){
var inst_25732 = (state_25861[(31)]);
var inst_25739 = (state_25861[(2)]);
var state_25861__$1 = (function (){var statearr_25931 = state_25861;
(statearr_25931[(32)] = inst_25739);

return statearr_25931;
})();
var statearr_25932_26117 = state_25861__$1;
(statearr_25932_26117[(2)] = inst_25732);

(statearr_25932_26117[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (109))){
var inst_25761 = (state_25861[(10)]);
var inst_25787 = (state_25861[(23)]);
var inst_25789 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25761,inst_25787);
var state_25861__$1 = state_25861;
var statearr_25933_26118 = state_25861__$1;
(statearr_25933_26118[(2)] = inst_25789);

(statearr_25933_26118[(1)] = (111));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (36))){
var inst_25553 = (state_25861[(18)]);
var inst_25610 = (state_25861[(2)]);
var inst_25611 = fluree.db.util.async.throw_err(inst_25610);
var state_25861__$1 = (function (){var statearr_25934 = state_25861;
(statearr_25934[(33)] = inst_25611);

return statearr_25934;
})();
if(cljs.core.truth_(inst_25553)){
var statearr_25935_26119 = state_25861__$1;
(statearr_25935_26119[(1)] = (38));

} else {
var statearr_25936_26120 = state_25861__$1;
(statearr_25936_26120[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (41))){
var state_25861__$1 = state_25861;
var statearr_25937_26121 = state_25861__$1;
(statearr_25937_26121[(2)] = null);

(statearr_25937_26121[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (118))){
var inst_25803 = (state_25861[(34)]);
var inst_25564 = (state_25861[(7)]);
var inst_25566 = (state_25861[(8)]);
var inst_25799 = (state_25861[(35)]);
var inst_25807 = (state_25861[(2)]);
var inst_25808 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25566,fuel,max_fuel,inst_25564,inst_25799,inst_25803,inst_25807);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25861__$1,(112),inst_25808);
} else {
if((state_val_25862 === (89))){
var state_25861__$1 = state_25861;
var statearr_25938_26122 = state_25861__$1;
(statearr_25938_26122[(2)] = null);

(statearr_25938_26122[(1)] = (90));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (100))){
var inst_25767 = (state_25861[(19)]);
var inst_25772 = cljs.core.int_QMARK_(inst_25767);
var state_25861__$1 = state_25861;
if(inst_25772){
var statearr_25939_26123 = state_25861__$1;
(statearr_25939_26123[(1)] = (102));

} else {
var statearr_25940_26124 = state_25861__$1;
(statearr_25940_26124[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (131))){
var inst_25839 = (state_25861[(11)]);
var inst_25853 = cljs.core.first(inst_25839);
var state_25861__$1 = state_25861;
var statearr_25941_26125 = state_25861__$1;
(statearr_25941_26125[(2)] = inst_25853);

(statearr_25941_26125[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (122))){
var inst_25600 = (state_25861[(16)]);
var inst_25554 = (state_25861[(13)]);
var inst_25834 = (state_25861[(28)]);
var inst_25599 = (state_25861[(17)]);
var inst_25556 = (state_25861[(15)]);
var inst_25836 = fluree.db.query.fql.sort_offset_and_limit_res(inst_25599,inst_25600,inst_25556,inst_25554,inst_25834);
var state_25861__$1 = state_25861;
var statearr_25942_26126 = state_25861__$1;
(statearr_25942_26126[(2)] = inst_25836);

(statearr_25942_26126[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (43))){
var inst_25564 = (state_25861[(7)]);
var inst_25615 = (state_25861[(29)]);
var inst_25611 = (state_25861[(33)]);
var inst_25566 = (state_25861[(8)]);
var inst_25619 = (state_25861[(2)]);
var inst_25620 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25566,fuel,max_fuel,inst_25564,inst_25611,inst_25615,inst_25619);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25861__$1,(37),inst_25620);
} else {
if((state_val_25862 === (61))){
var inst_25670 = ["_tx",null,"_block",null];
var inst_25671 = (new cljs.core.PersistentArrayMap(null,2,inst_25670,null));
var inst_25672 = (new cljs.core.PersistentHashSet(null,inst_25671,null));
var inst_25673 = (inst_25672.cljs$core$IFn$_invoke$arity$1 ? inst_25672.cljs$core$IFn$_invoke$arity$1(from) : inst_25672.call(null,from));
var state_25861__$1 = state_25861;
var statearr_25943_26127 = state_25861__$1;
(statearr_25943_26127[(2)] = inst_25673);

(statearr_25943_26127[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (29))){
var inst_25588 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25944_26128 = state_25861__$1;
(statearr_25944_26128[(2)] = inst_25588);

(statearr_25944_26128[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (44))){
var inst_25627 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_25628 = clojure.string.includes_QMARK_(inst_25627,"/");
var state_25861__$1 = state_25861;
var statearr_25945_26129 = state_25861__$1;
(statearr_25945_26129[(2)] = inst_25628);

(statearr_25945_26129[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (93))){
var inst_25746 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
if(cljs.core.truth_(inst_25746)){
var statearr_25946_26130 = state_25861__$1;
(statearr_25946_26130[(1)] = (94));

} else {
var statearr_25947_26131 = state_25861__$1;
(statearr_25947_26131[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (6))){
var inst_25531 = (state_25861[(36)]);
var state_25861__$1 = state_25861;
var statearr_25948_26132 = state_25861__$1;
(statearr_25948_26132[(2)] = inst_25531);

(statearr_25948_26132[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (111))){
var inst_25768 = (state_25861[(37)]);
var inst_25792 = (state_25861[(2)]);
var inst_25760 = inst_25768;
var inst_25761 = inst_25792;
var state_25861__$1 = (function (){var statearr_25949 = state_25861;
(statearr_25949[(10)] = inst_25761);

(statearr_25949[(38)] = inst_25760);

return statearr_25949;
})();
var statearr_25950_26133 = state_25861__$1;
(statearr_25950_26133[(2)] = null);

(statearr_25950_26133[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (28))){
var state_25861__$1 = state_25861;
var statearr_25951_26134 = state_25861__$1;
(statearr_25951_26134[(2)] = null);

(statearr_25951_26134[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (64))){
var inst_25553 = (state_25861[(18)]);
var state_25861__$1 = state_25861;
if(cljs.core.truth_(inst_25553)){
var statearr_25952_26135 = state_25861__$1;
(statearr_25952_26135[(1)] = (67));

} else {
var statearr_25953_26136 = state_25861__$1;
(statearr_25953_26136[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (103))){
var state_25861__$1 = state_25861;
if(cljs.core.truth_(fuel)){
var statearr_25954_26137 = state_25861__$1;
(statearr_25954_26137[(1)] = (105));

} else {
var statearr_25955_26138 = state_25861__$1;
(statearr_25955_26138[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (51))){
var inst_25634 = (state_25861[(26)]);
var state_25861__$1 = state_25861;
var statearr_25956_26139 = state_25861__$1;
(statearr_25956_26139[(2)] = inst_25634);

(statearr_25956_26139[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (25))){
var state_25861__$1 = state_25861;
var statearr_25957_26140 = state_25861__$1;
(statearr_25957_26140[(1)] = (27));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (34))){
var state_25861__$1 = state_25861;
var statearr_25959_26141 = state_25861__$1;
(statearr_25959_26141[(2)] = null);

(statearr_25959_26141[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (125))){
var inst_25839 = (state_25861[(11)]);
var inst_25842 = (state_25861[(30)]);
var inst_25842__$1 = cljs.core.coll_QMARK_(inst_25839);
var state_25861__$1 = (function (){var statearr_25960 = state_25861;
(statearr_25960[(30)] = inst_25842__$1);

return statearr_25960;
})();
if(inst_25842__$1){
var statearr_25961_26142 = state_25861__$1;
(statearr_25961_26142[(1)] = (128));

} else {
var statearr_25962_26143 = state_25861__$1;
(statearr_25962_26143[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (17))){
var inst_25553 = (state_25861[(18)]);
var inst_25564 = (state_25861[(2)]);
var inst_25565 = cljs.core.PersistentHashMap.EMPTY;
var inst_25566 = cljs.core.volatile_BANG_(inst_25565);
var state_25861__$1 = (function (){var statearr_25963 = state_25861;
(statearr_25963[(7)] = inst_25564);

(statearr_25963[(8)] = inst_25566);

return statearr_25963;
})();
if(cljs.core.truth_(inst_25553)){
var statearr_25964_26144 = state_25861__$1;
(statearr_25964_26144[(1)] = (18));

} else {
var statearr_25965_26145 = state_25861__$1;
(statearr_25965_26145[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (3))){
var inst_25859 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25861__$1,inst_25859);
} else {
if((state_val_25862 === (12))){
var inst_25537 = (state_25861[(39)]);
var state_25861__$1 = state_25861;
var statearr_25966_26146 = state_25861__$1;
(statearr_25966_26146[(2)] = inst_25537);

(statearr_25966_26146[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (2))){
var inst_25531 = (state_25861[(36)]);
var _ = (function (){var statearr_25967 = state_25861;
(statearr_25967[(4)] = cljs.core.cons((5),(state_25861[(4)])));

return statearr_25967;
})();
var inst_25531__$1 = select;
var state_25861__$1 = (function (){var statearr_25968 = state_25861;
(statearr_25968[(36)] = inst_25531__$1);

return statearr_25968;
})();
if(cljs.core.truth_(inst_25531__$1)){
var statearr_25969_26147 = state_25861__$1;
(statearr_25969_26147[(1)] = (6));

} else {
var statearr_25970_26148 = state_25861__$1;
(statearr_25970_26148[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (66))){
var inst_25830 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25971_26149 = state_25861__$1;
(statearr_25971_26149[(2)] = inst_25830);

(statearr_25971_26149[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (107))){
var inst_25767 = (state_25861[(19)]);
var inst_25781 = (state_25861[(2)]);
var inst_25782 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_25767,false);
var state_25861__$1 = (function (){var statearr_25972 = state_25861;
(statearr_25972[(40)] = inst_25781);

return statearr_25972;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25861__$1,(108),inst_25782);
} else {
if((state_val_25862 === (23))){
var inst_25592 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25973_26150 = state_25861__$1;
(statearr_25973_26150[(2)] = inst_25592);

(statearr_25973_26150[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (47))){
var inst_25634 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_25861__$1 = (function (){var statearr_25974 = state_25861;
(statearr_25974[(26)] = inst_25634);

return statearr_25974;
})();
if(cljs.core.truth_(fuel)){
var statearr_25975_26151 = state_25861__$1;
(statearr_25975_26151[(1)] = (50));

} else {
var statearr_25976_26152 = state_25861__$1;
(statearr_25976_26152[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (35))){
var inst_25607 = (state_25861[(2)]);
var inst_25608 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_25607);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25861__$1,(36),inst_25608);
} else {
if((state_val_25862 === (127))){
var inst_25851 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
if(cljs.core.truth_(inst_25851)){
var statearr_25977_26153 = state_25861__$1;
(statearr_25977_26153[(1)] = (131));

} else {
var statearr_25978_26154 = state_25861__$1;
(statearr_25978_26154[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (82))){
var inst_25826 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25979_26155 = state_25861__$1;
(statearr_25979_26155[(2)] = inst_25826);

(statearr_25979_26155[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (76))){
var inst_25554 = (state_25861[(13)]);
var inst_25556 = (state_25861[(15)]);
var inst_25700 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25701 = [inst_25554,inst_25556];
var inst_25702 = cljs.core.PersistentHashMap.fromArrays(inst_25700,inst_25701);
var state_25861__$1 = state_25861;
var statearr_25980_26156 = state_25861__$1;
(statearr_25980_26156[(2)] = inst_25702);

(statearr_25980_26156[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (97))){
var inst_25767 = (state_25861[(19)]);
var inst_25760 = (state_25861[(38)]);
var inst_25766 = cljs.core.seq(inst_25760);
var inst_25767__$1 = cljs.core.first(inst_25766);
var inst_25768 = cljs.core.next(inst_25766);
var inst_25769 = cljs.core.not(inst_25767__$1);
var state_25861__$1 = (function (){var statearr_25981 = state_25861;
(statearr_25981[(37)] = inst_25768);

(statearr_25981[(19)] = inst_25767__$1);

return statearr_25981;
})();
if(inst_25769){
var statearr_25982_26157 = state_25861__$1;
(statearr_25982_26157[(1)] = (99));

} else {
var statearr_25983_26158 = state_25861__$1;
(statearr_25983_26158[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (19))){
var inst_25594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25595 = [null,null];
var inst_25596 = (new cljs.core.PersistentVector(null,2,(5),inst_25594,inst_25595,null));
var state_25861__$1 = state_25861;
var statearr_25984_26159 = state_25861__$1;
(statearr_25984_26159[(2)] = inst_25596);

(statearr_25984_26159[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (57))){
var inst_25554 = (state_25861[(13)]);
var inst_25556 = (state_25861[(15)]);
var inst_25650 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25651 = [inst_25554,inst_25556];
var inst_25652 = cljs.core.PersistentHashMap.fromArrays(inst_25650,inst_25651);
var state_25861__$1 = state_25861;
var statearr_25985_26160 = state_25861__$1;
(statearr_25985_26160[(2)] = inst_25652);

(statearr_25985_26160[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (68))){
var inst_25554 = (state_25861[(13)]);
var inst_25556 = (state_25861[(15)]);
var inst_25681 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25682 = [inst_25554,inst_25556];
var inst_25683 = cljs.core.PersistentHashMap.fromArrays(inst_25681,inst_25682);
var state_25861__$1 = state_25861;
var statearr_25986_26161 = state_25861__$1;
(statearr_25986_26161[(2)] = inst_25683);

(statearr_25986_26161[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (11))){
var inst_25548 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_25987_26162 = state_25861__$1;
(statearr_25987_26162[(2)] = inst_25548);

(statearr_25987_26162[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (115))){
var inst_25553 = (state_25861[(18)]);
var inst_25803 = (state_25861[(2)]);
var state_25861__$1 = (function (){var statearr_25989 = state_25861;
(statearr_25989[(34)] = inst_25803);

return statearr_25989;
})();
if(cljs.core.truth_(inst_25553)){
var statearr_25990_26163 = state_25861__$1;
(statearr_25990_26163[(1)] = (116));

} else {
var statearr_25991_26164 = state_25861__$1;
(statearr_25991_26164[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (9))){
var inst_25534 = (state_25861[(12)]);
var state_25861__$1 = state_25861;
var statearr_25992_26165 = state_25861__$1;
(statearr_25992_26165[(2)] = inst_25534);

(statearr_25992_26165[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (5))){
var _ = (function (){var statearr_25993 = state_25861;
(statearr_25993[(4)] = cljs.core.rest((state_25861[(4)])));

return statearr_25993;
})();
var state_25861__$1 = state_25861;
var ex25988 = (state_25861__$1[(2)]);
var statearr_25994_26166 = state_25861__$1;
(statearr_25994_26166[(5)] = ex25988);


if((ex25988 instanceof Error)){
var statearr_25995_26167 = state_25861__$1;
(statearr_25995_26167[(1)] = (4));

(statearr_25995_26167[(5)] = null);

} else {
throw ex25988;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (112))){
var inst_25810 = (state_25861[(2)]);
var inst_25811 = fluree.db.util.async.throw_err(inst_25810);
var state_25861__$1 = state_25861;
var statearr_25996_26168 = state_25861__$1;
(statearr_25996_26168[(2)] = inst_25811);

(statearr_25996_26168[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (83))){
var inst_25720 = (state_25861[(20)]);
var inst_25719 = (state_25861[(2)]);
var inst_25720__$1 = fluree.db.util.async.throw_err(inst_25719);
var inst_25721 = (inst_25720__$1 == null);
var state_25861__$1 = (function (){var statearr_25997 = state_25861;
(statearr_25997[(20)] = inst_25720__$1);

return statearr_25997;
})();
if(cljs.core.truth_(inst_25721)){
var statearr_25998_26169 = state_25861__$1;
(statearr_25998_26169[(1)] = (84));

} else {
var statearr_25999_26170 = state_25861__$1;
(statearr_25999_26170[(1)] = (85));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (14))){
var inst_25546 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_26000_26171 = state_25861__$1;
(statearr_26000_26171[(2)] = inst_25546);

(statearr_26000_26171[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (45))){
var inst_25625 = (state_25861[(27)]);
var state_25861__$1 = state_25861;
var statearr_26001_26172 = state_25861__$1;
(statearr_26001_26172[(2)] = inst_25625);

(statearr_26001_26172[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (53))){
var inst_25640 = (state_25861[(21)]);
var inst_25642 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25643 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_25640,inst_25642);
var state_25861__$1 = state_25861;
var statearr_26002_26173 = state_25861__$1;
(statearr_26002_26173[(2)] = inst_25643);

(statearr_26002_26173[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (78))){
var inst_25564 = (state_25861[(7)]);
var inst_25566 = (state_25861[(8)]);
var inst_25707 = (state_25861[(2)]);
var inst_25708 = fluree.db.util.async.throw_err(inst_25707);
var inst_25709 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25566,fuel,max_fuel,inst_25564,inst_25708);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25861__$1,(79),inst_25709);
} else {
if((state_val_25862 === (132))){
var inst_25839 = (state_25861[(11)]);
var state_25861__$1 = state_25861;
var statearr_26003_26174 = state_25861__$1;
(statearr_26003_26174[(2)] = inst_25839);

(statearr_26003_26174[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (26))){
var inst_25590 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_26004_26175 = state_25861__$1;
(statearr_26004_26175[(2)] = inst_25590);

(statearr_26004_26175[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (123))){
var inst_25834 = (state_25861[(28)]);
var state_25861__$1 = state_25861;
var statearr_26005_26176 = state_25861__$1;
(statearr_26005_26176[(2)] = inst_25834);

(statearr_26005_26176[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (16))){
var inst_25557 = (state_25861[(25)]);
var state_25861__$1 = state_25861;
var statearr_26006_26177 = state_25861__$1;
(statearr_26006_26177[(2)] = inst_25557);

(statearr_26006_26177[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (133))){
var inst_25856 = (state_25861[(2)]);
var _ = (function (){var statearr_26007 = state_25861;
(statearr_26007[(4)] = cljs.core.rest((state_25861[(4)])));

return statearr_26007;
})();
var state_25861__$1 = state_25861;
var statearr_26008_26178 = state_25861__$1;
(statearr_26008_26178[(2)] = inst_25856);

(statearr_26008_26178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (81))){
var inst_25741 = (state_25861[(22)]);
var inst_25741__$1 = cljs.core.sequential_QMARK_(from);
var state_25861__$1 = (function (){var statearr_26009 = state_25861;
(statearr_26009[(22)] = inst_25741__$1);

return statearr_26009;
})();
if(inst_25741__$1){
var statearr_26010_26179 = state_25861__$1;
(statearr_26010_26179[(1)] = (91));

} else {
var statearr_26011_26180 = state_25861__$1;
(statearr_26011_26180[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (120))){
var state_25861__$1 = state_25861;
var statearr_26012_26181 = state_25861__$1;
(statearr_26012_26181[(2)] = null);

(statearr_26012_26181[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (79))){
var inst_25711 = (state_25861[(2)]);
var inst_25712 = fluree.db.util.async.throw_err(inst_25711);
var state_25861__$1 = state_25861;
var statearr_26013_26182 = state_25861__$1;
(statearr_26013_26182[(2)] = inst_25712);

(statearr_26013_26182[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (38))){
var state_25861__$1 = state_25861;
var statearr_26014_26183 = state_25861__$1;
(statearr_26014_26183[(2)] = null);

(statearr_26014_26183[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (126))){
var inst_25840 = (state_25861[(41)]);
var state_25861__$1 = state_25861;
var statearr_26015_26184 = state_25861__$1;
(statearr_26015_26184[(2)] = inst_25840);

(statearr_26015_26184[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (98))){
var inst_25553 = (state_25861[(18)]);
var inst_25797 = (state_25861[(2)]);
var inst_25798 = cljs.core.PersistentVector.EMPTY;
var inst_25799 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25798,inst_25797);
var state_25861__$1 = (function (){var statearr_26016 = state_25861;
(statearr_26016[(35)] = inst_25799);

return statearr_26016;
})();
if(cljs.core.truth_(inst_25553)){
var statearr_26017_26185 = state_25861__$1;
(statearr_26017_26185[(1)] = (113));

} else {
var statearr_26018_26186 = state_25861__$1;
(statearr_26018_26186[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (124))){
var inst_25840 = (state_25861[(41)]);
var inst_25839 = (state_25861[(2)]);
var inst_25840__$1 = selectOne;
var state_25861__$1 = (function (){var statearr_26019 = state_25861;
(statearr_26019[(11)] = inst_25839);

(statearr_26019[(41)] = inst_25840__$1);

return statearr_26019;
})();
if(cljs.core.truth_(inst_25840__$1)){
var statearr_26020_26187 = state_25861__$1;
(statearr_26020_26187[(1)] = (125));

} else {
var statearr_26021_26188 = state_25861__$1;
(statearr_26021_26188[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (87))){
var inst_25731 = (state_25861[(2)]);
var inst_25732 = fluree.db.util.async.throw_err(inst_25731);
var state_25861__$1 = (function (){var statearr_26022 = state_25861;
(statearr_26022[(31)] = inst_25732);

return statearr_26022;
})();
if(cljs.core.truth_(fuel)){
var statearr_26023_26189 = state_25861__$1;
(statearr_26023_26189[(1)] = (88));

} else {
var statearr_26024_26190 = state_25861__$1;
(statearr_26024_26190[(1)] = (89));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (30))){
var inst_25603 = typeof from === 'string';
var state_25861__$1 = state_25861;
if(cljs.core.truth_(inst_25603)){
var statearr_26025_26191 = state_25861__$1;
(statearr_26025_26191[(1)] = (33));

} else {
var statearr_26026_26192 = state_25861__$1;
(statearr_26026_26192[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (73))){
var inst_25714 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_25861__$1 = state_25861;
if(inst_25714){
var statearr_26027_26193 = state_25861__$1;
(statearr_26027_26193[(1)] = (80));

} else {
var statearr_26028_26194 = state_25861__$1;
(statearr_26028_26194[(1)] = (81));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (96))){
var inst_25824 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_26029_26195 = state_25861__$1;
(statearr_26029_26195[(2)] = inst_25824);

(statearr_26029_26195[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (10))){
var inst_25537 = (state_25861[(39)]);
var inst_25537__$1 = selectDistinct;
var state_25861__$1 = (function (){var statearr_26030 = state_25861;
(statearr_26030[(39)] = inst_25537__$1);

return statearr_26030;
})();
if(cljs.core.truth_(inst_25537__$1)){
var statearr_26031_26196 = state_25861__$1;
(statearr_26031_26196[(1)] = (12));

} else {
var statearr_26032_26197 = state_25861__$1;
(statearr_26032_26197[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (18))){
var inst_25553 = (state_25861[(18)]);
var inst_25568 = cljs.core.vector_QMARK_(inst_25553);
var state_25861__$1 = state_25861;
if(inst_25568){
var statearr_26033_26198 = state_25861__$1;
(statearr_26033_26198[(1)] = (21));

} else {
var statearr_26034_26199 = state_25861__$1;
(statearr_26034_26199[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (105))){
var inst_25776 = cljs.core._deref(fuel);
var inst_25777 = (inst_25776 + (1));
var inst_25778 = cljs.core._vreset_BANG_(fuel,inst_25777);
var state_25861__$1 = state_25861;
var statearr_26035_26200 = state_25861__$1;
(statearr_26035_26200[(2)] = inst_25778);

(statearr_26035_26200[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (52))){
var inst_25640 = (state_25861[(2)]);
var state_25861__$1 = (function (){var statearr_26036 = state_25861;
(statearr_26036[(21)] = inst_25640);

return statearr_26036;
})();
var statearr_26037_26201 = state_25861__$1;
(statearr_26037_26201[(1)] = (53));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (114))){
var inst_25554 = (state_25861[(13)]);
var state_25861__$1 = state_25861;
var statearr_26039_26202 = state_25861__$1;
(statearr_26039_26202[(2)] = inst_25554);

(statearr_26039_26202[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (67))){
var inst_25679 = cljs.core.PersistentHashMap.EMPTY;
var state_25861__$1 = state_25861;
var statearr_26040_26203 = state_25861__$1;
(statearr_26040_26203[(2)] = inst_25679);

(statearr_26040_26203[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (71))){
var inst_25692 = (state_25861[(2)]);
var inst_25693 = fluree.db.util.async.throw_err(inst_25692);
var state_25861__$1 = state_25861;
var statearr_26041_26204 = state_25861__$1;
(statearr_26041_26204[(2)] = inst_25693);

(statearr_26041_26204[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (42))){
var inst_25556 = (state_25861[(15)]);
var state_25861__$1 = state_25861;
var statearr_26042_26205 = state_25861__$1;
(statearr_26042_26205[(2)] = inst_25556);

(statearr_26042_26205[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (80))){
var inst_25717 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_25861__$1 = state_25861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25861__$1,(83),inst_25717);
} else {
if((state_val_25862 === (37))){
var inst_25622 = (state_25861[(2)]);
var inst_25623 = fluree.db.util.async.throw_err(inst_25622);
var state_25861__$1 = state_25861;
var statearr_26043_26206 = state_25861__$1;
(statearr_26043_26206[(2)] = inst_25623);

(statearr_26043_26206[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (63))){
var inst_25676 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
if(cljs.core.truth_(inst_25676)){
var statearr_26044_26207 = state_25861__$1;
(statearr_26044_26207[(1)] = (64));

} else {
var statearr_26045_26208 = state_25861__$1;
(statearr_26045_26208[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (94))){
var inst_25755 = from;
var inst_25756 = cljs.core.seq(inst_25755);
var inst_25757 = cljs.core.first(inst_25756);
var inst_25758 = cljs.core.next(inst_25756);
var inst_25759 = cljs.core.PersistentVector.EMPTY;
var inst_25760 = inst_25755;
var inst_25761 = inst_25759;
var state_25861__$1 = (function (){var statearr_26046 = state_25861;
(statearr_26046[(10)] = inst_25761);

(statearr_26046[(42)] = inst_25758);

(statearr_26046[(43)] = inst_25757);

(statearr_26046[(38)] = inst_25760);

return statearr_26046;
})();
var statearr_26047_26209 = state_25861__$1;
(statearr_26047_26209[(2)] = null);

(statearr_26047_26209[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (8))){
var inst_25555 = (state_25861[(24)]);
var inst_25550 = (state_25861[(2)]);
var inst_25551 = opts_SINGLEQUOTE_;
var inst_25552 = cljs.core.__destructure_map(inst_25551);
var inst_25553 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25552,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25552,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25555__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25552,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25552,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25557 = fluree.db.query.fql_parser.parse_db(db,inst_25550,opts_SINGLEQUOTE_);
var inst_25558 = (inst_25555__$1 == null);
var inst_25559 = cljs.core.not(inst_25558);
var state_25861__$1 = (function (){var statearr_26048 = state_25861;
(statearr_26048[(24)] = inst_25555__$1);

(statearr_26048[(25)] = inst_25557);

(statearr_26048[(13)] = inst_25554);

(statearr_26048[(18)] = inst_25553);

(statearr_26048[(15)] = inst_25556);

return statearr_26048;
})();
if(inst_25559){
var statearr_26049_26210 = state_25861__$1;
(statearr_26049_26210[(1)] = (15));

} else {
var statearr_26050_26211 = state_25861__$1;
(statearr_26050_26211[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (49))){
var inst_25832 = (state_25861[(2)]);
var state_25861__$1 = state_25861;
var statearr_26051_26212 = state_25861__$1;
(statearr_26051_26212[(2)] = inst_25832);

(statearr_26051_26212[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25862 === (84))){
var state_25861__$1 = state_25861;
var statearr_26052_26213 = state_25861__$1;
(statearr_26052_26213[(2)] = null);

(statearr_26052_26213[(1)] = (86));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2733__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2733__auto____0 = (function (){
var statearr_26053 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26053[(0)] = fluree$db$query$fql$query_$_state_machine__2733__auto__);

(statearr_26053[(1)] = (1));

return statearr_26053;
});
var fluree$db$query$fql$query_$_state_machine__2733__auto____1 = (function (state_25861){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_25861);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e26054){var ex__2736__auto__ = e26054;
var statearr_26055_26214 = state_25861;
(statearr_26055_26214[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_25861[(4)]))){
var statearr_26056_26215 = state_25861;
(statearr_26056_26215[(1)] = cljs.core.first((state_25861[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26216 = state_25861;
state_25861 = G__26216;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2733__auto__ = function(state_25861){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2733__auto____1.call(this,state_25861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2733__auto____0;
fluree$db$query$fql$query_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2733__auto____1;
return fluree$db$query$fql$query_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_26057 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_26057[(6)] = c__2755__auto__);

return statearr_26057;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}

});
