// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return new cljs.core.Keyword(null,"close?","close?",1600185693).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__22046 = arguments.length;
switch (G__22046) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"op","op",-1882987955),operation,new cljs.core.Keyword(null,"req-id","req-id",-471642231),req_id,new cljs.core.Keyword(null,"timestamp","timestamp",579478971),fluree.db.util.core.current_time_millis(),new cljs.core.Keyword(null,"timeout","timeout",-318625318),timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__22049 = arguments.length;
switch (G__22049) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2755__auto___22102 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_22080){
var state_val_22081 = (state_22080[(1)]);
if((state_val_22081 === (1))){
var state_22080__$1 = state_22080;
var statearr_22082_22103 = state_22080__$1;
(statearr_22082_22103[(2)] = null);

(statearr_22082_22103[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22081 === (2))){
var _ = (function (){var statearr_22083 = state_22080;
(statearr_22083[(4)] = cljs.core.cons((5),(state_22080[(4)])));

return statearr_22083;
})();
var inst_22057 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_22080__$1 = state_22080;
if(cljs.core.truth_(inst_22057)){
var statearr_22084_22104 = state_22080__$1;
(statearr_22084_22104[(1)] = (6));

} else {
var statearr_22085_22105 = state_22080__$1;
(statearr_22085_22105[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22081 === (3))){
var inst_22078 = (state_22080[(2)]);
var state_22080__$1 = state_22080;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22080__$1,inst_22078);
} else {
if((state_val_22081 === (4))){
var inst_22050 = (state_22080[(2)]);
var inst_22051 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_22050);
var state_22080__$1 = state_22080;
var statearr_22087_22106 = state_22080__$1;
(statearr_22087_22106[(2)] = inst_22051);

(statearr_22087_22106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22081 === (5))){
var _ = (function (){var statearr_22088 = state_22080;
(statearr_22088[(4)] = cljs.core.rest((state_22080[(4)])));

return statearr_22088;
})();
var state_22080__$1 = state_22080;
var ex22086 = (state_22080__$1[(2)]);
var statearr_22089_22107 = state_22080__$1;
(statearr_22089_22107[(5)] = ex22086);


var statearr_22090_22108 = state_22080__$1;
(statearr_22090_22108[(1)] = (4));

(statearr_22090_22108[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22081 === (6))){
var inst_22059 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_22060 = [(400),new cljs.core.Keyword("db","invalid-connection","db/invalid-connection",2026003745)];
var inst_22061 = cljs.core.PersistentHashMap.fromArrays(inst_22059,inst_22060);
var inst_22062 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_22061);
var inst_22063 = (function(){throw inst_22062})();
var state_22080__$1 = state_22080;
var statearr_22091_22109 = state_22080__$1;
(statearr_22091_22109[(2)] = inst_22063);

(statearr_22091_22109[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22081 === (7))){
var inst_22065 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_22066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22067 = [operation,data,pc,opts];
var inst_22068 = (new cljs.core.PersistentVector(null,4,(5),inst_22066,inst_22067,null));
var inst_22069 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_22065,inst_22068);
var inst_22070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22071 = [operation,data,pc,opts];
var inst_22072 = (new cljs.core.PersistentVector(null,4,(5),inst_22070,inst_22071,null));
var inst_22073 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_22072], 0));
var state_22080__$1 = (function (){var statearr_22092 = state_22080;
(statearr_22092[(7)] = inst_22069);

return statearr_22092;
})();
var statearr_22093_22110 = state_22080__$1;
(statearr_22093_22110[(2)] = inst_22073);

(statearr_22093_22110[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22081 === (8))){
var inst_22075 = (state_22080[(2)]);
var _ = (function (){var statearr_22094 = state_22080;
(statearr_22094[(4)] = cljs.core.rest((state_22080[(4)])));

return statearr_22094;
})();
var state_22080__$1 = state_22080;
var statearr_22095_22111 = state_22080__$1;
(statearr_22095_22111[(2)] = inst_22075);

(statearr_22095_22111[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__2733__auto__ = null;
var fluree$db$operations$state_machine__2733__auto____0 = (function (){
var statearr_22096 = [null,null,null,null,null,null,null,null];
(statearr_22096[(0)] = fluree$db$operations$state_machine__2733__auto__);

(statearr_22096[(1)] = (1));

return statearr_22096;
});
var fluree$db$operations$state_machine__2733__auto____1 = (function (state_22080){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_22080);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e22097){var ex__2736__auto__ = e22097;
var statearr_22098_22112 = state_22080;
(statearr_22098_22112[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_22080[(4)]))){
var statearr_22099_22113 = state_22080;
(statearr_22099_22113[(1)] = cljs.core.first((state_22080[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22114 = state_22080;
state_22080 = G__22114;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2733__auto__ = function(state_22080){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2733__auto____1.call(this,state_22080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2733__auto____0;
fluree$db$operations$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2733__auto____1;
return fluree$db$operations$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_22100 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_22100[(6)] = c__2755__auto___22102);

return statearr_22100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__22116 = arguments.length;
switch (G__22116) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__22117){
var map__22118 = p__22117;
var map__22118__$1 = cljs.core.__destructure_map(map__22118);
var opts = map__22118__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22118__$1,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670));
var map__22119 = session;
var map__22119__$1 = cljs.core.__destructure_map(map__22119);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22119__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22119__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22119__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"snapshot?","snapshot?",99555670),snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4835__auto__ = [];
var len__4829__auto___22146 = arguments.length;
var i__4830__auto___22147 = (0);
while(true){
if((i__4830__auto___22147 < len__4829__auto___22146)){
args__4835__auto__.push((arguments[i__4830__auto___22147]));

var G__22148 = (i__4830__auto___22147 + (1));
i__4830__auto___22147 = G__22148;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__22123){
var vec__22124 = p__22123;
var map__22127 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22124,(0),null);
var map__22127__$1 = cljs.core.__destructure_map(map__22127);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22127__$1,new cljs.core.Keyword(null,"toBlock","toBlock",1609458185));
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22127__$1,new cljs.core.Keyword(null,"toTime","toTime",903224641));
var opts = vec__22124;
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_22139){
var state_val_22140 = (state_22139[(1)]);
if((state_val_22140 === (1))){
var inst_22129 = session;
var inst_22130 = cljs.core.__destructure_map(inst_22129);
var inst_22131 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22130,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_22132 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22130,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_22133 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22130,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_22134 = [new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"toBlock","toBlock",1609458185),new cljs.core.Keyword(null,"toTime","toTime",903224641)];
var inst_22135 = [inst_22131,inst_22132,toBlock,toTime];
var inst_22136 = cljs.core.PersistentHashMap.fromArrays(inst_22134,inst_22135);
var inst_22137 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_22133,new cljs.core.Keyword(null,"garbage","garbage",-2063107600),inst_22136);
var state_22139__$1 = state_22139;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22139__$1,inst_22137);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__2733__auto__ = null;
var fluree$db$operations$state_machine__2733__auto____0 = (function (){
var statearr_22141 = [null,null,null,null,null,null,null];
(statearr_22141[(0)] = fluree$db$operations$state_machine__2733__auto__);

(statearr_22141[(1)] = (1));

return statearr_22141;
});
var fluree$db$operations$state_machine__2733__auto____1 = (function (state_22139){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_22139);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e22142){var ex__2736__auto__ = e22142;
var statearr_22143_22149 = state_22139;
(statearr_22143_22149[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_22139[(4)]))){
var statearr_22144_22150 = state_22139;
(statearr_22144_22150[(1)] = cljs.core.first((state_22139[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22151 = state_22139;
state_22139 = G__22151;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$operations$state_machine__2733__auto__ = function(state_22139){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__2733__auto____1.call(this,state_22139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__2733__auto____0;
fluree$db$operations$state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__2733__auto____1;
return fluree$db$operations$state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_22145 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_22145[(6)] = c__2755__auto__);

return statearr_22145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq22121){
var G__22122 = cljs.core.first(seq22121);
var seq22121__$1 = cljs.core.next(seq22121);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__22122,seq22121__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__22152 = session;
var map__22152__$1 = cljs.core.__destructure_map(map__22152);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22152__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22152__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22152__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"snapshot-db","snapshot-db",199417128),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsigned-cmd","unsigned-cmd",1466012010),unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-info","ledger-info",-161414079),ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"ledger-stats","ledger-stats",765646297),ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"db-list","db-list",230589843),null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"tx","tx",466630418),tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__22154 = arguments.length;
switch (G__22154) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__22155 = opts;
var map__22155__$1 = cljs.core.__destructure_map(map__22155);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22155__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__22155__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4223__auto__ = auth;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"subscribe","subscribe",416253756),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"unsbuscribe","unsbuscribe",888593047),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session)], null));
});
