// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__5663){
var vec__5664 = p__5663;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5664,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5664,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__5667 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5667,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5667,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5667,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5667,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5667,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5753__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__5670 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5670,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5670,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5670,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5670,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5670,(4),null);
var vec__5673 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5673,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5673,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5673,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5673,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5673,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4223__auto__ = source;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4223__auto__ = line;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4223__auto__ = col;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__5676 = segmap;
var map__5676__$1 = cljs.core.__destructure_map(map__5676);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5676__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5676__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5676__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5676__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5676__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__5678 = arguments.length;
switch (G__5678) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__5682 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__5686 = cljs.core.next(segs__$1);
var G__5687 = nrelseg;
var G__5688 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__5686;
relseg__$1 = G__5687;
result__$1 = G__5688;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5682,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5682,(1),null);
var G__5689 = (gline + (1));
var G__5690 = cljs.core.next(lines__$1);
var G__5691 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__5692 = result__$1;
gline = G__5689;
lines__$1 = G__5690;
relseg = G__5691;
result = G__5692;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__5694 = segmap;
var map__5694__$1 = cljs.core.__destructure_map(map__5694);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5694__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5694__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5694__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5694__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5694__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__5693_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__5693_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__5696 = arguments.length;
switch (G__5696) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__5700 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__5704 = cljs.core.next(segs__$1);
var G__5705 = nrelseg;
var G__5706 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__5704;
relseg__$1 = G__5705;
result__$1 = G__5706;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5700,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5700,(1),null);
var G__5707 = (gline + (1));
var G__5708 = cljs.core.next(lines__$1);
var G__5709 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__5710 = result__$1;
gline = G__5707;
lines__$1 = G__5708;
relseg = G__5709;
result = G__5710;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__5711){
var vec__5712 = p__5711;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5712,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5712,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5712,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5712,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5712,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__5715){
var vec__5716 = p__5715;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5716,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5716,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5716,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5716,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5716,(4),null);
var seg = vec__5716;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__5719){
var vec__5720 = p__5719;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5720,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5720,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5720,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5720,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5720,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__5726 = cljs.core.seq(infos);
var chunk__5727 = null;
var count__5728 = (0);
var i__5729 = (0);
while(true){
if((i__5729 < count__5728)){
var info = chunk__5727.cljs$core$IIndexed$_nth$arity$2(null,i__5729);
var segv_6080 = info__GT_segv(info,source_idx,line,col);
var gline_6081 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6082 = cljs.core.count(cljs.core.deref(lines));
if((gline_6081 > (lc_6082 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5726,chunk__5727,count__5728,i__5729,segv_6080,gline_6081,lc_6082,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_6081 - (lc_6082 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6080], null));
});})(seq__5726,chunk__5727,count__5728,i__5729,segv_6080,gline_6081,lc_6082,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5726,chunk__5727,count__5728,i__5729,segv_6080,gline_6081,lc_6082,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6081], null),cljs.core.conj,segv_6080);
});})(seq__5726,chunk__5727,count__5728,i__5729,segv_6080,gline_6081,lc_6082,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6083 = seq__5726;
var G__6084 = chunk__5727;
var G__6085 = count__5728;
var G__6086 = (i__5729 + (1));
seq__5726 = G__6083;
chunk__5727 = G__6084;
count__5728 = G__6085;
i__5729 = G__6086;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__5726);
if(temp__5753__auto__){
var seq__5726__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5726__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__5726__$1);
var G__6087 = cljs.core.chunk_rest(seq__5726__$1);
var G__6088 = c__4649__auto__;
var G__6089 = cljs.core.count(c__4649__auto__);
var G__6090 = (0);
seq__5726 = G__6087;
chunk__5727 = G__6088;
count__5728 = G__6089;
i__5729 = G__6090;
continue;
} else {
var info = cljs.core.first(seq__5726__$1);
var segv_6091 = info__GT_segv(info,source_idx,line,col);
var gline_6092 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_6093 = cljs.core.count(cljs.core.deref(lines));
if((gline_6092 > (lc_6093 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5726,chunk__5727,count__5728,i__5729,segv_6091,gline_6092,lc_6093,info,seq__5726__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_6092 - (lc_6093 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_6091], null));
});})(seq__5726,chunk__5727,count__5728,i__5729,segv_6091,gline_6092,lc_6093,info,seq__5726__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__5726,chunk__5727,count__5728,i__5729,segv_6091,gline_6092,lc_6093,info,seq__5726__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6092], null),cljs.core.conj,segv_6091);
});})(seq__5726,chunk__5727,count__5728,i__5729,segv_6091,gline_6092,lc_6093,info,seq__5726__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__6094 = cljs.core.next(seq__5726__$1);
var G__6095 = null;
var G__6096 = (0);
var G__6097 = (0);
seq__5726 = G__6094;
chunk__5727 = G__6095;
count__5728 = G__6096;
i__5729 = G__6097;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__5730_6098 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__5731_6099 = null;
var count__5732_6100 = (0);
var i__5733_6101 = (0);
while(true){
if((i__5733_6101 < count__5732_6100)){
var vec__5906_6102 = chunk__5731_6099.cljs$core$IIndexed$_nth$arity$2(null,i__5733_6101);
var source_idx_6103 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5906_6102,(0),null);
var vec__5909_6104 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5906_6102,(1),null);
var __6105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5909_6104,(0),null);
var lines_6106__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5909_6104,(1),null);
var seq__5912_6107 = cljs.core.seq(lines_6106__$1);
var chunk__5913_6108 = null;
var count__5914_6109 = (0);
var i__5915_6110 = (0);
while(true){
if((i__5915_6110 < count__5914_6109)){
var vec__5954_6111 = chunk__5913_6108.cljs$core$IIndexed$_nth$arity$2(null,i__5915_6110);
var line_6112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5954_6111,(0),null);
var cols_6113 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5954_6111,(1),null);
var seq__5957_6114 = cljs.core.seq(cols_6113);
var chunk__5958_6115 = null;
var count__5959_6116 = (0);
var i__5960_6117 = (0);
while(true){
if((i__5960_6117 < count__5959_6116)){
var vec__5967_6118 = chunk__5958_6115.cljs$core$IIndexed$_nth$arity$2(null,i__5960_6117);
var col_6119 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5967_6118,(0),null);
var infos_6120 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5967_6118,(1),null);
encode_cols(infos_6120,source_idx_6103,line_6112,col_6119);


var G__6121 = seq__5957_6114;
var G__6122 = chunk__5958_6115;
var G__6123 = count__5959_6116;
var G__6124 = (i__5960_6117 + (1));
seq__5957_6114 = G__6121;
chunk__5958_6115 = G__6122;
count__5959_6116 = G__6123;
i__5960_6117 = G__6124;
continue;
} else {
var temp__5753__auto___6125 = cljs.core.seq(seq__5957_6114);
if(temp__5753__auto___6125){
var seq__5957_6126__$1 = temp__5753__auto___6125;
if(cljs.core.chunked_seq_QMARK_(seq__5957_6126__$1)){
var c__4649__auto___6127 = cljs.core.chunk_first(seq__5957_6126__$1);
var G__6128 = cljs.core.chunk_rest(seq__5957_6126__$1);
var G__6129 = c__4649__auto___6127;
var G__6130 = cljs.core.count(c__4649__auto___6127);
var G__6131 = (0);
seq__5957_6114 = G__6128;
chunk__5958_6115 = G__6129;
count__5959_6116 = G__6130;
i__5960_6117 = G__6131;
continue;
} else {
var vec__5970_6132 = cljs.core.first(seq__5957_6126__$1);
var col_6133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5970_6132,(0),null);
var infos_6134 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5970_6132,(1),null);
encode_cols(infos_6134,source_idx_6103,line_6112,col_6133);


var G__6135 = cljs.core.next(seq__5957_6126__$1);
var G__6136 = null;
var G__6137 = (0);
var G__6138 = (0);
seq__5957_6114 = G__6135;
chunk__5958_6115 = G__6136;
count__5959_6116 = G__6137;
i__5960_6117 = G__6138;
continue;
}
} else {
}
}
break;
}


var G__6139 = seq__5912_6107;
var G__6140 = chunk__5913_6108;
var G__6141 = count__5914_6109;
var G__6142 = (i__5915_6110 + (1));
seq__5912_6107 = G__6139;
chunk__5913_6108 = G__6140;
count__5914_6109 = G__6141;
i__5915_6110 = G__6142;
continue;
} else {
var temp__5753__auto___6143 = cljs.core.seq(seq__5912_6107);
if(temp__5753__auto___6143){
var seq__5912_6144__$1 = temp__5753__auto___6143;
if(cljs.core.chunked_seq_QMARK_(seq__5912_6144__$1)){
var c__4649__auto___6145 = cljs.core.chunk_first(seq__5912_6144__$1);
var G__6146 = cljs.core.chunk_rest(seq__5912_6144__$1);
var G__6147 = c__4649__auto___6145;
var G__6148 = cljs.core.count(c__4649__auto___6145);
var G__6149 = (0);
seq__5912_6107 = G__6146;
chunk__5913_6108 = G__6147;
count__5914_6109 = G__6148;
i__5915_6110 = G__6149;
continue;
} else {
var vec__5973_6150 = cljs.core.first(seq__5912_6144__$1);
var line_6151 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5973_6150,(0),null);
var cols_6152 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5973_6150,(1),null);
var seq__5976_6153 = cljs.core.seq(cols_6152);
var chunk__5977_6154 = null;
var count__5978_6155 = (0);
var i__5979_6156 = (0);
while(true){
if((i__5979_6156 < count__5978_6155)){
var vec__5986_6157 = chunk__5977_6154.cljs$core$IIndexed$_nth$arity$2(null,i__5979_6156);
var col_6158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5986_6157,(0),null);
var infos_6159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5986_6157,(1),null);
encode_cols(infos_6159,source_idx_6103,line_6151,col_6158);


var G__6160 = seq__5976_6153;
var G__6161 = chunk__5977_6154;
var G__6162 = count__5978_6155;
var G__6163 = (i__5979_6156 + (1));
seq__5976_6153 = G__6160;
chunk__5977_6154 = G__6161;
count__5978_6155 = G__6162;
i__5979_6156 = G__6163;
continue;
} else {
var temp__5753__auto___6164__$1 = cljs.core.seq(seq__5976_6153);
if(temp__5753__auto___6164__$1){
var seq__5976_6165__$1 = temp__5753__auto___6164__$1;
if(cljs.core.chunked_seq_QMARK_(seq__5976_6165__$1)){
var c__4649__auto___6166 = cljs.core.chunk_first(seq__5976_6165__$1);
var G__6167 = cljs.core.chunk_rest(seq__5976_6165__$1);
var G__6168 = c__4649__auto___6166;
var G__6169 = cljs.core.count(c__4649__auto___6166);
var G__6170 = (0);
seq__5976_6153 = G__6167;
chunk__5977_6154 = G__6168;
count__5978_6155 = G__6169;
i__5979_6156 = G__6170;
continue;
} else {
var vec__5989_6171 = cljs.core.first(seq__5976_6165__$1);
var col_6172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5989_6171,(0),null);
var infos_6173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5989_6171,(1),null);
encode_cols(infos_6173,source_idx_6103,line_6151,col_6172);


var G__6174 = cljs.core.next(seq__5976_6165__$1);
var G__6175 = null;
var G__6176 = (0);
var G__6177 = (0);
seq__5976_6153 = G__6174;
chunk__5977_6154 = G__6175;
count__5978_6155 = G__6176;
i__5979_6156 = G__6177;
continue;
}
} else {
}
}
break;
}


var G__6178 = cljs.core.next(seq__5912_6144__$1);
var G__6179 = null;
var G__6180 = (0);
var G__6181 = (0);
seq__5912_6107 = G__6178;
chunk__5913_6108 = G__6179;
count__5914_6109 = G__6180;
i__5915_6110 = G__6181;
continue;
}
} else {
}
}
break;
}


var G__6182 = seq__5730_6098;
var G__6183 = chunk__5731_6099;
var G__6184 = count__5732_6100;
var G__6185 = (i__5733_6101 + (1));
seq__5730_6098 = G__6182;
chunk__5731_6099 = G__6183;
count__5732_6100 = G__6184;
i__5733_6101 = G__6185;
continue;
} else {
var temp__5753__auto___6186 = cljs.core.seq(seq__5730_6098);
if(temp__5753__auto___6186){
var seq__5730_6187__$1 = temp__5753__auto___6186;
if(cljs.core.chunked_seq_QMARK_(seq__5730_6187__$1)){
var c__4649__auto___6188 = cljs.core.chunk_first(seq__5730_6187__$1);
var G__6189 = cljs.core.chunk_rest(seq__5730_6187__$1);
var G__6190 = c__4649__auto___6188;
var G__6191 = cljs.core.count(c__4649__auto___6188);
var G__6192 = (0);
seq__5730_6098 = G__6189;
chunk__5731_6099 = G__6190;
count__5732_6100 = G__6191;
i__5733_6101 = G__6192;
continue;
} else {
var vec__5992_6193 = cljs.core.first(seq__5730_6187__$1);
var source_idx_6194 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5992_6193,(0),null);
var vec__5995_6195 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5992_6193,(1),null);
var __6196 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5995_6195,(0),null);
var lines_6197__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5995_6195,(1),null);
var seq__5998_6198 = cljs.core.seq(lines_6197__$1);
var chunk__5999_6199 = null;
var count__6000_6200 = (0);
var i__6001_6201 = (0);
while(true){
if((i__6001_6201 < count__6000_6200)){
var vec__6040_6202 = chunk__5999_6199.cljs$core$IIndexed$_nth$arity$2(null,i__6001_6201);
var line_6203 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6040_6202,(0),null);
var cols_6204 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6040_6202,(1),null);
var seq__6043_6205 = cljs.core.seq(cols_6204);
var chunk__6044_6206 = null;
var count__6045_6207 = (0);
var i__6046_6208 = (0);
while(true){
if((i__6046_6208 < count__6045_6207)){
var vec__6053_6209 = chunk__6044_6206.cljs$core$IIndexed$_nth$arity$2(null,i__6046_6208);
var col_6210 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6053_6209,(0),null);
var infos_6211 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6053_6209,(1),null);
encode_cols(infos_6211,source_idx_6194,line_6203,col_6210);


var G__6212 = seq__6043_6205;
var G__6213 = chunk__6044_6206;
var G__6214 = count__6045_6207;
var G__6215 = (i__6046_6208 + (1));
seq__6043_6205 = G__6212;
chunk__6044_6206 = G__6213;
count__6045_6207 = G__6214;
i__6046_6208 = G__6215;
continue;
} else {
var temp__5753__auto___6216__$1 = cljs.core.seq(seq__6043_6205);
if(temp__5753__auto___6216__$1){
var seq__6043_6217__$1 = temp__5753__auto___6216__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6043_6217__$1)){
var c__4649__auto___6218 = cljs.core.chunk_first(seq__6043_6217__$1);
var G__6219 = cljs.core.chunk_rest(seq__6043_6217__$1);
var G__6220 = c__4649__auto___6218;
var G__6221 = cljs.core.count(c__4649__auto___6218);
var G__6222 = (0);
seq__6043_6205 = G__6219;
chunk__6044_6206 = G__6220;
count__6045_6207 = G__6221;
i__6046_6208 = G__6222;
continue;
} else {
var vec__6056_6223 = cljs.core.first(seq__6043_6217__$1);
var col_6224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6056_6223,(0),null);
var infos_6225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6056_6223,(1),null);
encode_cols(infos_6225,source_idx_6194,line_6203,col_6224);


var G__6226 = cljs.core.next(seq__6043_6217__$1);
var G__6227 = null;
var G__6228 = (0);
var G__6229 = (0);
seq__6043_6205 = G__6226;
chunk__6044_6206 = G__6227;
count__6045_6207 = G__6228;
i__6046_6208 = G__6229;
continue;
}
} else {
}
}
break;
}


var G__6230 = seq__5998_6198;
var G__6231 = chunk__5999_6199;
var G__6232 = count__6000_6200;
var G__6233 = (i__6001_6201 + (1));
seq__5998_6198 = G__6230;
chunk__5999_6199 = G__6231;
count__6000_6200 = G__6232;
i__6001_6201 = G__6233;
continue;
} else {
var temp__5753__auto___6234__$1 = cljs.core.seq(seq__5998_6198);
if(temp__5753__auto___6234__$1){
var seq__5998_6235__$1 = temp__5753__auto___6234__$1;
if(cljs.core.chunked_seq_QMARK_(seq__5998_6235__$1)){
var c__4649__auto___6236 = cljs.core.chunk_first(seq__5998_6235__$1);
var G__6237 = cljs.core.chunk_rest(seq__5998_6235__$1);
var G__6238 = c__4649__auto___6236;
var G__6239 = cljs.core.count(c__4649__auto___6236);
var G__6240 = (0);
seq__5998_6198 = G__6237;
chunk__5999_6199 = G__6238;
count__6000_6200 = G__6239;
i__6001_6201 = G__6240;
continue;
} else {
var vec__6059_6241 = cljs.core.first(seq__5998_6235__$1);
var line_6242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6059_6241,(0),null);
var cols_6243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6059_6241,(1),null);
var seq__6062_6244 = cljs.core.seq(cols_6243);
var chunk__6063_6245 = null;
var count__6064_6246 = (0);
var i__6065_6247 = (0);
while(true){
if((i__6065_6247 < count__6064_6246)){
var vec__6072_6248 = chunk__6063_6245.cljs$core$IIndexed$_nth$arity$2(null,i__6065_6247);
var col_6249 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6072_6248,(0),null);
var infos_6250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6072_6248,(1),null);
encode_cols(infos_6250,source_idx_6194,line_6242,col_6249);


var G__6251 = seq__6062_6244;
var G__6252 = chunk__6063_6245;
var G__6253 = count__6064_6246;
var G__6254 = (i__6065_6247 + (1));
seq__6062_6244 = G__6251;
chunk__6063_6245 = G__6252;
count__6064_6246 = G__6253;
i__6065_6247 = G__6254;
continue;
} else {
var temp__5753__auto___6255__$2 = cljs.core.seq(seq__6062_6244);
if(temp__5753__auto___6255__$2){
var seq__6062_6256__$1 = temp__5753__auto___6255__$2;
if(cljs.core.chunked_seq_QMARK_(seq__6062_6256__$1)){
var c__4649__auto___6257 = cljs.core.chunk_first(seq__6062_6256__$1);
var G__6258 = cljs.core.chunk_rest(seq__6062_6256__$1);
var G__6259 = c__4649__auto___6257;
var G__6260 = cljs.core.count(c__4649__auto___6257);
var G__6261 = (0);
seq__6062_6244 = G__6258;
chunk__6063_6245 = G__6259;
count__6064_6246 = G__6260;
i__6065_6247 = G__6261;
continue;
} else {
var vec__6075_6262 = cljs.core.first(seq__6062_6256__$1);
var col_6263 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6075_6262,(0),null);
var infos_6264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6075_6262,(1),null);
encode_cols(infos_6264,source_idx_6194,line_6242,col_6263);


var G__6265 = cljs.core.next(seq__6062_6256__$1);
var G__6266 = null;
var G__6267 = (0);
var G__6268 = (0);
seq__6062_6244 = G__6265;
chunk__6063_6245 = G__6266;
count__6064_6246 = G__6267;
i__6065_6247 = G__6268;
continue;
}
} else {
}
}
break;
}


var G__6269 = cljs.core.next(seq__5998_6235__$1);
var G__6270 = null;
var G__6271 = (0);
var G__6272 = (0);
seq__5998_6198 = G__6269;
chunk__5999_6199 = G__6270;
count__6000_6200 = G__6271;
i__6001_6201 = G__6272;
continue;
}
} else {
}
}
break;
}


var G__6273 = cljs.core.next(seq__5730_6187__$1);
var G__6274 = null;
var G__6275 = (0);
var G__6276 = (0);
seq__5730_6098 = G__6273;
chunk__5731_6099 = G__6274;
count__5732_6100 = G__6275;
i__5733_6101 = G__6276;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__6078 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__5723_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__5723_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__5724_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__5724_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__5725_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__5725_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__6079 = G__6078;
goog.object.set(G__6079,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__6079;
} else {
return G__6078;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__6277 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6277,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6277,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__6280 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6280,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6280,(1),null);
var G__6285 = cljs.core.next(col_map_seq);
var G__6286 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__6280,col,infos,vec__6277,line,col_map){
return (function (v,p__6283){
var map__6284 = p__6283;
var map__6284__$1 = cljs.core.__destructure_map(map__6284);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6284__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6284__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__6280,col,infos,vec__6277,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__6285;
new_cols = G__6286;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__6287 = cljs.core.next(line_map_seq);
var G__6288 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__6287;
new_lines = G__6288;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__6289_6497 = cljs.core.seq(reverse_map);
var chunk__6290_6498 = null;
var count__6291_6499 = (0);
var i__6292_6500 = (0);
while(true){
if((i__6292_6500 < count__6291_6499)){
var vec__6395_6501 = chunk__6290_6498.cljs$core$IIndexed$_nth$arity$2(null,i__6292_6500);
var line_6502 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6395_6501,(0),null);
var columns_6503 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6395_6501,(1),null);
var seq__6398_6504 = cljs.core.seq(columns_6503);
var chunk__6399_6505 = null;
var count__6400_6506 = (0);
var i__6401_6507 = (0);
while(true){
if((i__6401_6507 < count__6400_6506)){
var vec__6424_6508 = chunk__6399_6505.cljs$core$IIndexed$_nth$arity$2(null,i__6401_6507);
var column_6509 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6424_6508,(0),null);
var column_info_6510 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6424_6508,(1),null);
var seq__6427_6511 = cljs.core.seq(column_info_6510);
var chunk__6428_6512 = null;
var count__6429_6513 = (0);
var i__6430_6514 = (0);
while(true){
if((i__6430_6514 < count__6429_6513)){
var map__6433_6515 = chunk__6428_6512.cljs$core$IIndexed$_nth$arity$2(null,i__6430_6514);
var map__6433_6516__$1 = cljs.core.__destructure_map(map__6433_6515);
var gline_6517 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6433_6516__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6518 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6433_6516__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6519 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6433_6516__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6517], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6427_6511,chunk__6428_6512,count__6429_6513,i__6430_6514,seq__6398_6504,chunk__6399_6505,count__6400_6506,i__6401_6507,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6433_6515,map__6433_6516__$1,gline_6517,gcol_6518,name_6519,vec__6424_6508,column_6509,column_info_6510,vec__6395_6501,line_6502,columns_6503,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6518], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6502,new cljs.core.Keyword(null,"col","col",-1959363084),column_6509,new cljs.core.Keyword(null,"name","name",1843675177),name_6519], null));
});})(seq__6427_6511,chunk__6428_6512,count__6429_6513,i__6430_6514,seq__6398_6504,chunk__6399_6505,count__6400_6506,i__6401_6507,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6433_6515,map__6433_6516__$1,gline_6517,gcol_6518,name_6519,vec__6424_6508,column_6509,column_info_6510,vec__6395_6501,line_6502,columns_6503,inverted))
,cljs.core.sorted_map()));


var G__6520 = seq__6427_6511;
var G__6521 = chunk__6428_6512;
var G__6522 = count__6429_6513;
var G__6523 = (i__6430_6514 + (1));
seq__6427_6511 = G__6520;
chunk__6428_6512 = G__6521;
count__6429_6513 = G__6522;
i__6430_6514 = G__6523;
continue;
} else {
var temp__5753__auto___6524 = cljs.core.seq(seq__6427_6511);
if(temp__5753__auto___6524){
var seq__6427_6525__$1 = temp__5753__auto___6524;
if(cljs.core.chunked_seq_QMARK_(seq__6427_6525__$1)){
var c__4649__auto___6526 = cljs.core.chunk_first(seq__6427_6525__$1);
var G__6527 = cljs.core.chunk_rest(seq__6427_6525__$1);
var G__6528 = c__4649__auto___6526;
var G__6529 = cljs.core.count(c__4649__auto___6526);
var G__6530 = (0);
seq__6427_6511 = G__6527;
chunk__6428_6512 = G__6528;
count__6429_6513 = G__6529;
i__6430_6514 = G__6530;
continue;
} else {
var map__6434_6531 = cljs.core.first(seq__6427_6525__$1);
var map__6434_6532__$1 = cljs.core.__destructure_map(map__6434_6531);
var gline_6533 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6434_6532__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6534 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6434_6532__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6535 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6434_6532__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6533], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6427_6511,chunk__6428_6512,count__6429_6513,i__6430_6514,seq__6398_6504,chunk__6399_6505,count__6400_6506,i__6401_6507,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6434_6531,map__6434_6532__$1,gline_6533,gcol_6534,name_6535,seq__6427_6525__$1,temp__5753__auto___6524,vec__6424_6508,column_6509,column_info_6510,vec__6395_6501,line_6502,columns_6503,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6534], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6502,new cljs.core.Keyword(null,"col","col",-1959363084),column_6509,new cljs.core.Keyword(null,"name","name",1843675177),name_6535], null));
});})(seq__6427_6511,chunk__6428_6512,count__6429_6513,i__6430_6514,seq__6398_6504,chunk__6399_6505,count__6400_6506,i__6401_6507,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6434_6531,map__6434_6532__$1,gline_6533,gcol_6534,name_6535,seq__6427_6525__$1,temp__5753__auto___6524,vec__6424_6508,column_6509,column_info_6510,vec__6395_6501,line_6502,columns_6503,inverted))
,cljs.core.sorted_map()));


var G__6536 = cljs.core.next(seq__6427_6525__$1);
var G__6537 = null;
var G__6538 = (0);
var G__6539 = (0);
seq__6427_6511 = G__6536;
chunk__6428_6512 = G__6537;
count__6429_6513 = G__6538;
i__6430_6514 = G__6539;
continue;
}
} else {
}
}
break;
}


var G__6540 = seq__6398_6504;
var G__6541 = chunk__6399_6505;
var G__6542 = count__6400_6506;
var G__6543 = (i__6401_6507 + (1));
seq__6398_6504 = G__6540;
chunk__6399_6505 = G__6541;
count__6400_6506 = G__6542;
i__6401_6507 = G__6543;
continue;
} else {
var temp__5753__auto___6544 = cljs.core.seq(seq__6398_6504);
if(temp__5753__auto___6544){
var seq__6398_6545__$1 = temp__5753__auto___6544;
if(cljs.core.chunked_seq_QMARK_(seq__6398_6545__$1)){
var c__4649__auto___6546 = cljs.core.chunk_first(seq__6398_6545__$1);
var G__6547 = cljs.core.chunk_rest(seq__6398_6545__$1);
var G__6548 = c__4649__auto___6546;
var G__6549 = cljs.core.count(c__4649__auto___6546);
var G__6550 = (0);
seq__6398_6504 = G__6547;
chunk__6399_6505 = G__6548;
count__6400_6506 = G__6549;
i__6401_6507 = G__6550;
continue;
} else {
var vec__6435_6551 = cljs.core.first(seq__6398_6545__$1);
var column_6552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6435_6551,(0),null);
var column_info_6553 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6435_6551,(1),null);
var seq__6438_6554 = cljs.core.seq(column_info_6553);
var chunk__6439_6555 = null;
var count__6440_6556 = (0);
var i__6441_6557 = (0);
while(true){
if((i__6441_6557 < count__6440_6556)){
var map__6444_6558 = chunk__6439_6555.cljs$core$IIndexed$_nth$arity$2(null,i__6441_6557);
var map__6444_6559__$1 = cljs.core.__destructure_map(map__6444_6558);
var gline_6560 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6444_6559__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6561 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6444_6559__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6562 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6444_6559__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6560], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6438_6554,chunk__6439_6555,count__6440_6556,i__6441_6557,seq__6398_6504,chunk__6399_6505,count__6400_6506,i__6401_6507,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6444_6558,map__6444_6559__$1,gline_6560,gcol_6561,name_6562,vec__6435_6551,column_6552,column_info_6553,seq__6398_6545__$1,temp__5753__auto___6544,vec__6395_6501,line_6502,columns_6503,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6561], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6502,new cljs.core.Keyword(null,"col","col",-1959363084),column_6552,new cljs.core.Keyword(null,"name","name",1843675177),name_6562], null));
});})(seq__6438_6554,chunk__6439_6555,count__6440_6556,i__6441_6557,seq__6398_6504,chunk__6399_6505,count__6400_6506,i__6401_6507,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6444_6558,map__6444_6559__$1,gline_6560,gcol_6561,name_6562,vec__6435_6551,column_6552,column_info_6553,seq__6398_6545__$1,temp__5753__auto___6544,vec__6395_6501,line_6502,columns_6503,inverted))
,cljs.core.sorted_map()));


var G__6563 = seq__6438_6554;
var G__6564 = chunk__6439_6555;
var G__6565 = count__6440_6556;
var G__6566 = (i__6441_6557 + (1));
seq__6438_6554 = G__6563;
chunk__6439_6555 = G__6564;
count__6440_6556 = G__6565;
i__6441_6557 = G__6566;
continue;
} else {
var temp__5753__auto___6567__$1 = cljs.core.seq(seq__6438_6554);
if(temp__5753__auto___6567__$1){
var seq__6438_6568__$1 = temp__5753__auto___6567__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6438_6568__$1)){
var c__4649__auto___6569 = cljs.core.chunk_first(seq__6438_6568__$1);
var G__6570 = cljs.core.chunk_rest(seq__6438_6568__$1);
var G__6571 = c__4649__auto___6569;
var G__6572 = cljs.core.count(c__4649__auto___6569);
var G__6573 = (0);
seq__6438_6554 = G__6570;
chunk__6439_6555 = G__6571;
count__6440_6556 = G__6572;
i__6441_6557 = G__6573;
continue;
} else {
var map__6445_6574 = cljs.core.first(seq__6438_6568__$1);
var map__6445_6575__$1 = cljs.core.__destructure_map(map__6445_6574);
var gline_6576 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6445_6575__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6577 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6445_6575__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6578 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6445_6575__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6576], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6438_6554,chunk__6439_6555,count__6440_6556,i__6441_6557,seq__6398_6504,chunk__6399_6505,count__6400_6506,i__6401_6507,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6445_6574,map__6445_6575__$1,gline_6576,gcol_6577,name_6578,seq__6438_6568__$1,temp__5753__auto___6567__$1,vec__6435_6551,column_6552,column_info_6553,seq__6398_6545__$1,temp__5753__auto___6544,vec__6395_6501,line_6502,columns_6503,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6577], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6502,new cljs.core.Keyword(null,"col","col",-1959363084),column_6552,new cljs.core.Keyword(null,"name","name",1843675177),name_6578], null));
});})(seq__6438_6554,chunk__6439_6555,count__6440_6556,i__6441_6557,seq__6398_6504,chunk__6399_6505,count__6400_6506,i__6401_6507,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6445_6574,map__6445_6575__$1,gline_6576,gcol_6577,name_6578,seq__6438_6568__$1,temp__5753__auto___6567__$1,vec__6435_6551,column_6552,column_info_6553,seq__6398_6545__$1,temp__5753__auto___6544,vec__6395_6501,line_6502,columns_6503,inverted))
,cljs.core.sorted_map()));


var G__6579 = cljs.core.next(seq__6438_6568__$1);
var G__6580 = null;
var G__6581 = (0);
var G__6582 = (0);
seq__6438_6554 = G__6579;
chunk__6439_6555 = G__6580;
count__6440_6556 = G__6581;
i__6441_6557 = G__6582;
continue;
}
} else {
}
}
break;
}


var G__6583 = cljs.core.next(seq__6398_6545__$1);
var G__6584 = null;
var G__6585 = (0);
var G__6586 = (0);
seq__6398_6504 = G__6583;
chunk__6399_6505 = G__6584;
count__6400_6506 = G__6585;
i__6401_6507 = G__6586;
continue;
}
} else {
}
}
break;
}


var G__6587 = seq__6289_6497;
var G__6588 = chunk__6290_6498;
var G__6589 = count__6291_6499;
var G__6590 = (i__6292_6500 + (1));
seq__6289_6497 = G__6587;
chunk__6290_6498 = G__6588;
count__6291_6499 = G__6589;
i__6292_6500 = G__6590;
continue;
} else {
var temp__5753__auto___6591 = cljs.core.seq(seq__6289_6497);
if(temp__5753__auto___6591){
var seq__6289_6592__$1 = temp__5753__auto___6591;
if(cljs.core.chunked_seq_QMARK_(seq__6289_6592__$1)){
var c__4649__auto___6593 = cljs.core.chunk_first(seq__6289_6592__$1);
var G__6594 = cljs.core.chunk_rest(seq__6289_6592__$1);
var G__6595 = c__4649__auto___6593;
var G__6596 = cljs.core.count(c__4649__auto___6593);
var G__6597 = (0);
seq__6289_6497 = G__6594;
chunk__6290_6498 = G__6595;
count__6291_6499 = G__6596;
i__6292_6500 = G__6597;
continue;
} else {
var vec__6446_6598 = cljs.core.first(seq__6289_6592__$1);
var line_6599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6446_6598,(0),null);
var columns_6600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6446_6598,(1),null);
var seq__6449_6601 = cljs.core.seq(columns_6600);
var chunk__6450_6602 = null;
var count__6451_6603 = (0);
var i__6452_6604 = (0);
while(true){
if((i__6452_6604 < count__6451_6603)){
var vec__6475_6605 = chunk__6450_6602.cljs$core$IIndexed$_nth$arity$2(null,i__6452_6604);
var column_6606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6475_6605,(0),null);
var column_info_6607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6475_6605,(1),null);
var seq__6478_6608 = cljs.core.seq(column_info_6607);
var chunk__6479_6609 = null;
var count__6480_6610 = (0);
var i__6481_6611 = (0);
while(true){
if((i__6481_6611 < count__6480_6610)){
var map__6484_6612 = chunk__6479_6609.cljs$core$IIndexed$_nth$arity$2(null,i__6481_6611);
var map__6484_6613__$1 = cljs.core.__destructure_map(map__6484_6612);
var gline_6614 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6484_6613__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6615 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6484_6613__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6616 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6484_6613__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6614], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6478_6608,chunk__6479_6609,count__6480_6610,i__6481_6611,seq__6449_6601,chunk__6450_6602,count__6451_6603,i__6452_6604,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6484_6612,map__6484_6613__$1,gline_6614,gcol_6615,name_6616,vec__6475_6605,column_6606,column_info_6607,vec__6446_6598,line_6599,columns_6600,seq__6289_6592__$1,temp__5753__auto___6591,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6615], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6599,new cljs.core.Keyword(null,"col","col",-1959363084),column_6606,new cljs.core.Keyword(null,"name","name",1843675177),name_6616], null));
});})(seq__6478_6608,chunk__6479_6609,count__6480_6610,i__6481_6611,seq__6449_6601,chunk__6450_6602,count__6451_6603,i__6452_6604,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6484_6612,map__6484_6613__$1,gline_6614,gcol_6615,name_6616,vec__6475_6605,column_6606,column_info_6607,vec__6446_6598,line_6599,columns_6600,seq__6289_6592__$1,temp__5753__auto___6591,inverted))
,cljs.core.sorted_map()));


var G__6617 = seq__6478_6608;
var G__6618 = chunk__6479_6609;
var G__6619 = count__6480_6610;
var G__6620 = (i__6481_6611 + (1));
seq__6478_6608 = G__6617;
chunk__6479_6609 = G__6618;
count__6480_6610 = G__6619;
i__6481_6611 = G__6620;
continue;
} else {
var temp__5753__auto___6621__$1 = cljs.core.seq(seq__6478_6608);
if(temp__5753__auto___6621__$1){
var seq__6478_6622__$1 = temp__5753__auto___6621__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6478_6622__$1)){
var c__4649__auto___6623 = cljs.core.chunk_first(seq__6478_6622__$1);
var G__6624 = cljs.core.chunk_rest(seq__6478_6622__$1);
var G__6625 = c__4649__auto___6623;
var G__6626 = cljs.core.count(c__4649__auto___6623);
var G__6627 = (0);
seq__6478_6608 = G__6624;
chunk__6479_6609 = G__6625;
count__6480_6610 = G__6626;
i__6481_6611 = G__6627;
continue;
} else {
var map__6485_6628 = cljs.core.first(seq__6478_6622__$1);
var map__6485_6629__$1 = cljs.core.__destructure_map(map__6485_6628);
var gline_6630 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6485_6629__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6631 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6485_6629__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6632 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6485_6629__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6630], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6478_6608,chunk__6479_6609,count__6480_6610,i__6481_6611,seq__6449_6601,chunk__6450_6602,count__6451_6603,i__6452_6604,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6485_6628,map__6485_6629__$1,gline_6630,gcol_6631,name_6632,seq__6478_6622__$1,temp__5753__auto___6621__$1,vec__6475_6605,column_6606,column_info_6607,vec__6446_6598,line_6599,columns_6600,seq__6289_6592__$1,temp__5753__auto___6591,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6631], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6599,new cljs.core.Keyword(null,"col","col",-1959363084),column_6606,new cljs.core.Keyword(null,"name","name",1843675177),name_6632], null));
});})(seq__6478_6608,chunk__6479_6609,count__6480_6610,i__6481_6611,seq__6449_6601,chunk__6450_6602,count__6451_6603,i__6452_6604,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6485_6628,map__6485_6629__$1,gline_6630,gcol_6631,name_6632,seq__6478_6622__$1,temp__5753__auto___6621__$1,vec__6475_6605,column_6606,column_info_6607,vec__6446_6598,line_6599,columns_6600,seq__6289_6592__$1,temp__5753__auto___6591,inverted))
,cljs.core.sorted_map()));


var G__6633 = cljs.core.next(seq__6478_6622__$1);
var G__6634 = null;
var G__6635 = (0);
var G__6636 = (0);
seq__6478_6608 = G__6633;
chunk__6479_6609 = G__6634;
count__6480_6610 = G__6635;
i__6481_6611 = G__6636;
continue;
}
} else {
}
}
break;
}


var G__6637 = seq__6449_6601;
var G__6638 = chunk__6450_6602;
var G__6639 = count__6451_6603;
var G__6640 = (i__6452_6604 + (1));
seq__6449_6601 = G__6637;
chunk__6450_6602 = G__6638;
count__6451_6603 = G__6639;
i__6452_6604 = G__6640;
continue;
} else {
var temp__5753__auto___6641__$1 = cljs.core.seq(seq__6449_6601);
if(temp__5753__auto___6641__$1){
var seq__6449_6642__$1 = temp__5753__auto___6641__$1;
if(cljs.core.chunked_seq_QMARK_(seq__6449_6642__$1)){
var c__4649__auto___6643 = cljs.core.chunk_first(seq__6449_6642__$1);
var G__6644 = cljs.core.chunk_rest(seq__6449_6642__$1);
var G__6645 = c__4649__auto___6643;
var G__6646 = cljs.core.count(c__4649__auto___6643);
var G__6647 = (0);
seq__6449_6601 = G__6644;
chunk__6450_6602 = G__6645;
count__6451_6603 = G__6646;
i__6452_6604 = G__6647;
continue;
} else {
var vec__6486_6648 = cljs.core.first(seq__6449_6642__$1);
var column_6649 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6486_6648,(0),null);
var column_info_6650 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6486_6648,(1),null);
var seq__6489_6651 = cljs.core.seq(column_info_6650);
var chunk__6490_6652 = null;
var count__6491_6653 = (0);
var i__6492_6654 = (0);
while(true){
if((i__6492_6654 < count__6491_6653)){
var map__6495_6655 = chunk__6490_6652.cljs$core$IIndexed$_nth$arity$2(null,i__6492_6654);
var map__6495_6656__$1 = cljs.core.__destructure_map(map__6495_6655);
var gline_6657 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6495_6656__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6495_6656__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6659 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6495_6656__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6657], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6489_6651,chunk__6490_6652,count__6491_6653,i__6492_6654,seq__6449_6601,chunk__6450_6602,count__6451_6603,i__6452_6604,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6495_6655,map__6495_6656__$1,gline_6657,gcol_6658,name_6659,vec__6486_6648,column_6649,column_info_6650,seq__6449_6642__$1,temp__5753__auto___6641__$1,vec__6446_6598,line_6599,columns_6600,seq__6289_6592__$1,temp__5753__auto___6591,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6658], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6599,new cljs.core.Keyword(null,"col","col",-1959363084),column_6649,new cljs.core.Keyword(null,"name","name",1843675177),name_6659], null));
});})(seq__6489_6651,chunk__6490_6652,count__6491_6653,i__6492_6654,seq__6449_6601,chunk__6450_6602,count__6451_6603,i__6452_6604,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6495_6655,map__6495_6656__$1,gline_6657,gcol_6658,name_6659,vec__6486_6648,column_6649,column_info_6650,seq__6449_6642__$1,temp__5753__auto___6641__$1,vec__6446_6598,line_6599,columns_6600,seq__6289_6592__$1,temp__5753__auto___6591,inverted))
,cljs.core.sorted_map()));


var G__6660 = seq__6489_6651;
var G__6661 = chunk__6490_6652;
var G__6662 = count__6491_6653;
var G__6663 = (i__6492_6654 + (1));
seq__6489_6651 = G__6660;
chunk__6490_6652 = G__6661;
count__6491_6653 = G__6662;
i__6492_6654 = G__6663;
continue;
} else {
var temp__5753__auto___6664__$2 = cljs.core.seq(seq__6489_6651);
if(temp__5753__auto___6664__$2){
var seq__6489_6665__$1 = temp__5753__auto___6664__$2;
if(cljs.core.chunked_seq_QMARK_(seq__6489_6665__$1)){
var c__4649__auto___6666 = cljs.core.chunk_first(seq__6489_6665__$1);
var G__6667 = cljs.core.chunk_rest(seq__6489_6665__$1);
var G__6668 = c__4649__auto___6666;
var G__6669 = cljs.core.count(c__4649__auto___6666);
var G__6670 = (0);
seq__6489_6651 = G__6667;
chunk__6490_6652 = G__6668;
count__6491_6653 = G__6669;
i__6492_6654 = G__6670;
continue;
} else {
var map__6496_6671 = cljs.core.first(seq__6489_6665__$1);
var map__6496_6672__$1 = cljs.core.__destructure_map(map__6496_6671);
var gline_6673 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6496_6672__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_6674 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6496_6672__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_6675 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__6496_6672__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_6673], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__6489_6651,chunk__6490_6652,count__6491_6653,i__6492_6654,seq__6449_6601,chunk__6450_6602,count__6451_6603,i__6452_6604,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6496_6671,map__6496_6672__$1,gline_6673,gcol_6674,name_6675,seq__6489_6665__$1,temp__5753__auto___6664__$2,vec__6486_6648,column_6649,column_info_6650,seq__6449_6642__$1,temp__5753__auto___6641__$1,vec__6446_6598,line_6599,columns_6600,seq__6289_6592__$1,temp__5753__auto___6591,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_6674], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_6599,new cljs.core.Keyword(null,"col","col",-1959363084),column_6649,new cljs.core.Keyword(null,"name","name",1843675177),name_6675], null));
});})(seq__6489_6651,chunk__6490_6652,count__6491_6653,i__6492_6654,seq__6449_6601,chunk__6450_6602,count__6451_6603,i__6452_6604,seq__6289_6497,chunk__6290_6498,count__6291_6499,i__6292_6500,map__6496_6671,map__6496_6672__$1,gline_6673,gcol_6674,name_6675,seq__6489_6665__$1,temp__5753__auto___6664__$2,vec__6486_6648,column_6649,column_info_6650,seq__6449_6642__$1,temp__5753__auto___6641__$1,vec__6446_6598,line_6599,columns_6600,seq__6289_6592__$1,temp__5753__auto___6591,inverted))
,cljs.core.sorted_map()));


var G__6676 = cljs.core.next(seq__6489_6665__$1);
var G__6677 = null;
var G__6678 = (0);
var G__6679 = (0);
seq__6489_6651 = G__6676;
chunk__6490_6652 = G__6677;
count__6491_6653 = G__6678;
i__6492_6654 = G__6679;
continue;
}
} else {
}
}
break;
}


var G__6680 = cljs.core.next(seq__6449_6642__$1);
var G__6681 = null;
var G__6682 = (0);
var G__6683 = (0);
seq__6449_6601 = G__6680;
chunk__6450_6602 = G__6681;
count__6451_6603 = G__6682;
i__6452_6604 = G__6683;
continue;
}
} else {
}
}
break;
}


var G__6684 = cljs.core.next(seq__6289_6592__$1);
var G__6685 = null;
var G__6686 = (0);
var G__6687 = (0);
seq__6289_6497 = G__6684;
chunk__6290_6498 = G__6685;
count__6291_6499 = G__6686;
i__6292_6500 = G__6687;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
