// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__7101 = (line + (1));
var G__7102 = (1);
var G__7103 = (counter + (1));
line = G__7101;
col = G__7102;
counter = G__7103;
continue;
} else {
var G__7104 = line;
var G__7105 = (col + (1));
var G__7106 = (counter + (1));
line = G__7104;
col = G__7105;
counter = G__7106;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__7107 = cljs.core.next(chars);
var G__7108 = (n__$1 - (1));
chars = G__7107;
n__$1 = G__7108;
continue;
} else {
var G__7109 = cljs.core.next(chars);
var G__7110 = n__$1;
chars = G__7109;
n__$1 = G__7110;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__7111){
var map__7112 = p__7111;
var map__7112__$1 = cljs.core.__destructure_map(map__7112);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7112__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7112__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7112__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7112__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__7113_7121 = cljs.core.seq(full_reasons);
var chunk__7114_7122 = null;
var count__7115_7123 = (0);
var i__7116_7124 = (0);
while(true){
if((i__7116_7124 < count__7115_7123)){
var r_7125 = chunk__7114_7122.cljs$core$IIndexed$_nth$arity$2(null,i__7116_7124);
instaparse.failure.print_reason(r_7125);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__7126 = seq__7113_7121;
var G__7127 = chunk__7114_7122;
var G__7128 = count__7115_7123;
var G__7129 = (i__7116_7124 + (1));
seq__7113_7121 = G__7126;
chunk__7114_7122 = G__7127;
count__7115_7123 = G__7128;
i__7116_7124 = G__7129;
continue;
} else {
var temp__5753__auto___7130 = cljs.core.seq(seq__7113_7121);
if(temp__5753__auto___7130){
var seq__7113_7131__$1 = temp__5753__auto___7130;
if(cljs.core.chunked_seq_QMARK_(seq__7113_7131__$1)){
var c__4649__auto___7132 = cljs.core.chunk_first(seq__7113_7131__$1);
var G__7133 = cljs.core.chunk_rest(seq__7113_7131__$1);
var G__7134 = c__4649__auto___7132;
var G__7135 = cljs.core.count(c__4649__auto___7132);
var G__7136 = (0);
seq__7113_7121 = G__7133;
chunk__7114_7122 = G__7134;
count__7115_7123 = G__7135;
i__7116_7124 = G__7136;
continue;
} else {
var r_7137 = cljs.core.first(seq__7113_7131__$1);
instaparse.failure.print_reason(r_7137);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__7138 = cljs.core.next(seq__7113_7131__$1);
var G__7139 = null;
var G__7140 = (0);
var G__7141 = (0);
seq__7113_7121 = G__7138;
chunk__7114_7122 = G__7139;
count__7115_7123 = G__7140;
i__7116_7124 = G__7141;
continue;
}
} else {
}
}
break;
}

var seq__7117 = cljs.core.seq(partial_reasons);
var chunk__7118 = null;
var count__7119 = (0);
var i__7120 = (0);
while(true){
if((i__7120 < count__7119)){
var r = chunk__7118.cljs$core$IIndexed$_nth$arity$2(null,i__7120);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__7142 = seq__7117;
var G__7143 = chunk__7118;
var G__7144 = count__7119;
var G__7145 = (i__7120 + (1));
seq__7117 = G__7142;
chunk__7118 = G__7143;
count__7119 = G__7144;
i__7120 = G__7145;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__7117);
if(temp__5753__auto__){
var seq__7117__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7117__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__7117__$1);
var G__7146 = cljs.core.chunk_rest(seq__7117__$1);
var G__7147 = c__4649__auto__;
var G__7148 = cljs.core.count(c__4649__auto__);
var G__7149 = (0);
seq__7117 = G__7146;
chunk__7118 = G__7147;
count__7119 = G__7148;
i__7120 = G__7149;
continue;
} else {
var r = cljs.core.first(seq__7117__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__7150 = cljs.core.next(seq__7117__$1);
var G__7151 = null;
var G__7152 = (0);
var G__7153 = (0);
seq__7117 = G__7150;
chunk__7118 = G__7151;
count__7119 = G__7152;
i__7120 = G__7153;
continue;
}
} else {
return null;
}
}
break;
}
});
