// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5753__auto__)){
var st = temp__5753__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__35474 = cljs.core._EQ_;
var expr__35475 = e.getLastErrorCode();
if(cljs.core.truth_((pred__35474.cljs$core$IFn$_invoke$arity$2 ? pred__35474.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__35475) : pred__35474.call(null,goog.net.ErrorCode.NO_ERROR,expr__35475)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__35474.cljs$core$IFn$_invoke$arity$2 ? pred__35474.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__35475) : pred__35474.call(null,goog.net.ErrorCode.EXCEPTION,expr__35475)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__35474.cljs$core$IFn$_invoke$arity$2 ? pred__35474.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__35475) : pred__35474.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__35475)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__35474.cljs$core$IFn$_invoke$arity$2 ? pred__35474.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__35475) : pred__35474.call(null,goog.net.ErrorCode.ABORT,expr__35475)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__35474.cljs$core$IFn$_invoke$arity$2 ? pred__35474.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__35475) : pred__35474.call(null,goog.net.ErrorCode.TIMEOUT,expr__35475)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4221__auto__ = status;
if(cljs.core.truth_(and__4221__auto__)){
return (status > (0));
} else {
return and__4221__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__35477 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__35477,cljs.core.cst$kw$status,status);
} else {
return G__35477;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__35478 = opts;
var map__35478__$1 = cljs.core.__destructure_map(map__35478);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35478__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35478__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35478__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__35479 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__35479__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__35479,headers], 0)):G__35479);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__35479__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__35479__$1;
}
})();
try{var G__35481_35487 = url;
var G__35482_35488 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__35483_35489 = "POST";
var G__35484_35490 = fluree.db.util.json.stringify(message);
var G__35485_35491 = cljs.core.clj__GT_js(headers__$1);
var G__35486_35492 = request_timeout;
goog.net.XhrIo.send(G__35481_35487,G__35482_35488,G__35483_35489,G__35484_35490,G__35485_35491,G__35486_35492);
}catch (e35480){var e_35493 = e35480;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_35493);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__35494 = opts;
var map__35494__$1 = cljs.core.__destructure_map(map__35494);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35494__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35494__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35494__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35494__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__35494__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__35495 = cljs.core.PersistentArrayMap.EMPTY;
var G__35495__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__35495,headers], 0)):G__35495);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__35495__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__35495__$1;
}
})();
try{var G__35497_35504 = url;
var G__35498_35505 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__35503 = output_format;
var G__35503__$1 = (((G__35503 instanceof cljs.core.Keyword))?G__35503.fqn:null);
switch (G__35503__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__35499_35506 = "GET";
var G__35500_35507 = body;
var G__35501_35508 = cljs.core.clj__GT_js(headers__$1);
var G__35502_35509 = request_timeout;
goog.net.XhrIo.send(G__35497_35504,G__35498_35505,G__35499_35506,G__35500_35507,G__35501_35508,G__35502_35509);
}catch (e35496){var e_35511 = e35496;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_35511);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__35512 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__35512,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__35512;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_35545){
var state_val_35546 = (state_35545[(1)]);
if((state_val_35546 === (7))){
var inst_35541 = (state_35545[(2)]);
var state_35545__$1 = state_35545;
var statearr_35547_35572 = state_35545__$1;
(statearr_35547_35572[(2)] = inst_35541);

(statearr_35547_35572[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35546 === (1))){
var state_35545__$1 = state_35545;
var statearr_35548_35573 = state_35545__$1;
(statearr_35548_35573[(2)] = null);

(statearr_35548_35573[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35546 === (4))){
var inst_35516 = (state_35545[(7)]);
var inst_35516__$1 = (state_35545[(2)]);
var inst_35517 = (inst_35516__$1 == null);
var state_35545__$1 = (function (){var statearr_35549 = state_35545;
(statearr_35549[(7)] = inst_35516__$1);

return statearr_35549;
})();
if(cljs.core.truth_(inst_35517)){
var statearr_35550_35574 = state_35545__$1;
(statearr_35550_35574[(1)] = (5));

} else {
var statearr_35551_35575 = state_35545__$1;
(statearr_35551_35575[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35546 === (6))){
var inst_35516 = (state_35545[(7)]);
var inst_35524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35516,(0),null);
var inst_35525 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35516,(1),null);
var state_35545__$1 = (function (){var statearr_35552 = state_35545;
(statearr_35552[(8)] = inst_35524);

(statearr_35552[(9)] = inst_35525);

return statearr_35552;
})();
var statearr_35553_35576 = state_35545__$1;
(statearr_35553_35576[(2)] = null);

(statearr_35553_35576[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35546 === (3))){
var inst_35543 = (state_35545[(2)]);
var state_35545__$1 = state_35545;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35545__$1,inst_35543);
} else {
if((state_val_35546 === (2))){
var state_35545__$1 = state_35545;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35545__$1,(4),pub_chan);
} else {
if((state_val_35546 === (11))){
var _ = (function (){var statearr_35555 = state_35545;
(statearr_35555[(4)] = cljs.core.rest((state_35545[(4)])));

return statearr_35555;
})();
var state_35545__$1 = state_35545;
var ex35554 = (state_35545__$1[(2)]);
var statearr_35556_35577 = state_35545__$1;
(statearr_35556_35577[(5)] = ex35554);


if((ex35554 instanceof Error)){
var statearr_35557_35578 = state_35545__$1;
(statearr_35557_35578[(1)] = (10));

(statearr_35557_35578[(5)] = null);

} else {
throw ex35554;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35546 === (9))){
var inst_35538 = (state_35545[(2)]);
var state_35545__$1 = (function (){var statearr_35558 = state_35545;
(statearr_35558[(10)] = inst_35538);

return statearr_35558;
})();
var statearr_35559_35579 = state_35545__$1;
(statearr_35559_35579[(2)] = null);

(statearr_35559_35579[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35546 === (5))){
var inst_35519 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_35545__$1 = state_35545;
var statearr_35560_35580 = state_35545__$1;
(statearr_35560_35580[(2)] = inst_35519);

(statearr_35560_35580[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35546 === (10))){
var inst_35525 = (state_35545[(9)]);
var inst_35526 = (state_35545[(2)]);
var inst_35527 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35526,"Websocket send message error:",inst_35526], 0));
var inst_35528 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_35525,false);
var state_35545__$1 = (function (){var statearr_35561 = state_35545;
(statearr_35561[(11)] = inst_35527);

return statearr_35561;
})();
var statearr_35562_35581 = state_35545__$1;
(statearr_35562_35581[(2)] = inst_35528);

(statearr_35562_35581[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35546 === (8))){
var inst_35524 = (state_35545[(8)]);
var inst_35525 = (state_35545[(9)]);
var _ = (function (){var statearr_35563 = state_35545;
(statearr_35563[(4)] = cljs.core.cons((11),(state_35545[(4)])));

return statearr_35563;
})();
var inst_35534 = ws.send(inst_35524);
var inst_35535 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_35525,true);
var ___$1 = (function (){var statearr_35564 = state_35545;
(statearr_35564[(4)] = cljs.core.rest((state_35545[(4)])));

return statearr_35564;
})();
var state_35545__$1 = (function (){var statearr_35565 = state_35545;
(statearr_35565[(12)] = inst_35534);

return statearr_35565;
})();
var statearr_35566_35582 = state_35545__$1;
(statearr_35566_35582[(2)] = inst_35535);

(statearr_35566_35582[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16153__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16153__auto____0 = (function (){
var statearr_35567 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35567[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16153__auto__);

(statearr_35567[(1)] = (1));

return statearr_35567;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16153__auto____1 = (function (state_35545){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_35545);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e35568){var ex__16156__auto__ = e35568;
var statearr_35569_35583 = state_35545;
(statearr_35569_35583[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_35545[(4)]))){
var statearr_35570_35584 = state_35545;
(statearr_35570_35584[(1)] = cljs.core.first((state_35545[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__35585 = state_35545;
state_35545 = G__35585;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16153__auto__ = function(state_35545){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16153__auto____1.call(this,state_35545);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16153__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16153__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_35571 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_35571[(6)] = c__16227__auto__);

return statearr_35571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__16227__auto___35624 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_35611){
var state_val_35612 = (state_35611[(1)]);
if((state_val_35612 === (1))){
var inst_35590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35591 = [open_QMARK_,timeout_chan];
var inst_35592 = (new cljs.core.PersistentVector(null,2,(5),inst_35590,inst_35591,null));
var state_35611__$1 = state_35611;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_35611__$1,(2),inst_35592,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_35612 === (2))){
var inst_35594 = (state_35611[(2)]);
var inst_35595 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35594,(0),null);
var inst_35596 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35594,(1),null);
var inst_35597 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35596,timeout_chan);
var state_35611__$1 = (function (){var statearr_35613 = state_35611;
(statearr_35613[(7)] = inst_35595);

return statearr_35613;
})();
if(inst_35597){
var statearr_35614_35625 = state_35611__$1;
(statearr_35614_35625[(1)] = (3));

} else {
var statearr_35615_35626 = state_35611__$1;
(statearr_35615_35626[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35612 === (3))){
var inst_35599 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_35600 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35601 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_35602 = cljs.core.PersistentHashMap.fromArrays(inst_35600,inst_35601);
var inst_35603 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35599,inst_35602);
var inst_35604 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_35603);
var inst_35605 = fluree.db.util.xhttp.close_websocket(ws);
var state_35611__$1 = (function (){var statearr_35616 = state_35611;
(statearr_35616[(8)] = inst_35604);

return statearr_35616;
})();
var statearr_35617_35627 = state_35611__$1;
(statearr_35617_35627[(2)] = inst_35605);

(statearr_35617_35627[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35612 === (4))){
var inst_35607 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_35611__$1 = state_35611;
var statearr_35618_35628 = state_35611__$1;
(statearr_35618_35628[(2)] = inst_35607);

(statearr_35618_35628[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35612 === (5))){
var inst_35609 = (state_35611[(2)]);
var state_35611__$1 = state_35611;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35611__$1,inst_35609);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__16153__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__16153__auto____0 = (function (){
var statearr_35619 = [null,null,null,null,null,null,null,null,null];
(statearr_35619[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__16153__auto__);

(statearr_35619[(1)] = (1));

return statearr_35619;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__16153__auto____1 = (function (state_35611){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_35611);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e35620){var ex__16156__auto__ = e35620;
var statearr_35621_35629 = state_35611;
(statearr_35621_35629[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_35611[(4)]))){
var statearr_35622_35630 = state_35611;
(statearr_35622_35630[(1)] = cljs.core.first((state_35611[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__35631 = state_35611;
state_35611 = G__35631;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__16153__auto__ = function(state_35611){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__16153__auto____1.call(this,state_35611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__16153__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__16153__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_35623 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_35623[(6)] = c__16227__auto___35624);

return statearr_35623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
