// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__29344 = arguments.length;
switch (G__29344) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keyword_DASH_fn,fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__29345 = options;
var map__29345__$1 = cljs.core.__destructure_map(map__29345);
var keyword_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29345__$1,cljs.core.cst$kw$keyword_DASH_fn);
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.cljs$core$IFn$_invoke$arity$2(k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js(x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return (keyword_fn.cljs$core$IFn$_invoke$arity$1 ? keyword_fn.cljs$core$IFn$_invoke$arity$1(x__$1) : keyword_fn.call(null,x__$1));
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_(x__$1)){
var m = ({});
var seq__29372_29393 = cljs.core.seq(x__$1);
var chunk__29373_29394 = null;
var count__29374_29395 = (0);
var i__29375_29396 = (0);
while(true){
if((i__29375_29396 < count__29374_29395)){
var vec__29382_29397 = chunk__29373_29394.cljs$core$IIndexed$_nth$arity$2(null,i__29375_29396);
var k_29398 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29382_29397,(0),null);
var v_29399 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29382_29397,(1),null);
goog.object.set(m,keyfn(k_29398),fluree$db$util$json$thisfn(v_29399));


var G__29400 = seq__29372_29393;
var G__29401 = chunk__29373_29394;
var G__29402 = count__29374_29395;
var G__29403 = (i__29375_29396 + (1));
seq__29372_29393 = G__29400;
chunk__29373_29394 = G__29401;
count__29374_29395 = G__29402;
i__29375_29396 = G__29403;
continue;
} else {
var temp__5753__auto___29404 = cljs.core.seq(seq__29372_29393);
if(temp__5753__auto___29404){
var seq__29372_29405__$1 = temp__5753__auto___29404;
if(cljs.core.chunked_seq_QMARK_(seq__29372_29405__$1)){
var c__4649__auto___29406 = cljs.core.chunk_first(seq__29372_29405__$1);
var G__29407 = cljs.core.chunk_rest(seq__29372_29405__$1);
var G__29408 = c__4649__auto___29406;
var G__29409 = cljs.core.count(c__4649__auto___29406);
var G__29410 = (0);
seq__29372_29393 = G__29407;
chunk__29373_29394 = G__29408;
count__29374_29395 = G__29409;
i__29375_29396 = G__29410;
continue;
} else {
var vec__29385_29411 = cljs.core.first(seq__29372_29405__$1);
var k_29412 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29385_29411,(0),null);
var v_29413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29385_29411,(1),null);
goog.object.set(m,keyfn(k_29412),fluree$db$util$json$thisfn(v_29413));


var G__29414 = cljs.core.next(seq__29372_29405__$1);
var G__29415 = null;
var G__29416 = (0);
var G__29417 = (0);
seq__29372_29393 = G__29414;
chunk__29373_29394 = G__29415;
count__29374_29395 = G__29416;
i__29375_29396 = G__29417;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var arr = [];
var seq__29388_29418 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree$db$util$json$thisfn,x__$1));
var chunk__29389_29419 = null;
var count__29390_29420 = (0);
var i__29391_29421 = (0);
while(true){
if((i__29391_29421 < count__29390_29420)){
var x_29422__$2 = chunk__29389_29419.cljs$core$IIndexed$_nth$arity$2(null,i__29391_29421);
arr.push(x_29422__$2);


var G__29423 = seq__29388_29418;
var G__29424 = chunk__29389_29419;
var G__29425 = count__29390_29420;
var G__29426 = (i__29391_29421 + (1));
seq__29388_29418 = G__29423;
chunk__29389_29419 = G__29424;
count__29390_29420 = G__29425;
i__29391_29421 = G__29426;
continue;
} else {
var temp__5753__auto___29427 = cljs.core.seq(seq__29388_29418);
if(temp__5753__auto___29427){
var seq__29388_29428__$1 = temp__5753__auto___29427;
if(cljs.core.chunked_seq_QMARK_(seq__29388_29428__$1)){
var c__4649__auto___29429 = cljs.core.chunk_first(seq__29388_29428__$1);
var G__29430 = cljs.core.chunk_rest(seq__29388_29428__$1);
var G__29431 = c__4649__auto___29429;
var G__29432 = cljs.core.count(c__4649__auto___29429);
var G__29433 = (0);
seq__29388_29418 = G__29430;
chunk__29389_29419 = G__29431;
count__29390_29420 = G__29432;
i__29391_29421 = G__29433;
continue;
} else {
var x_29434__$2 = cljs.core.first(seq__29388_29428__$1);
arr.push(x_29434__$2);


var G__29435 = cljs.core.next(seq__29388_29428__$1);
var G__29436 = null;
var G__29437 = (0);
var G__29438 = (0);
seq__29388_29418 = G__29435;
chunk__29389_29419 = G__29436;
count__29390_29420 = G__29437;
i__29391_29421 = G__29438;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn(x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string(x))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1(x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js(x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8(fluree.db.util.json.stringify(x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),depth)){
return ((cljs.core.every_QMARK_(cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count(coordinates))));
} else {
return (((!((coordinates == null)))) && (((cljs.core.every_QMARK_(cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29439_SHARP_){
var G__29440 = (depth - (1));
var G__29441 = p1__29439_SHARP_;
return (fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2(G__29440,G__29441) : fluree.db.util.json.valid_coordinates_QMARK_.call(null,G__29440,G__29441));
}),coordinates))))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_(coordinates)) && (((((4) <= cljs.core.count(coordinates))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(coordinates),cljs.core.last(coordinates))))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__29442 = cljs.core.get_global_hierarchy;
return (fexpr__29442.cljs$core$IFn$_invoke$arity$0 ? fexpr__29442.cljs$core$IFn$_invoke$arity$0() : fexpr__29442.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.util.json","valid-geojson?"),cljs.core.cst$kw$type,cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Feature",(function (geometry){
var and__4221__auto__ = (function (){var or__4223__auto__ = (function (){var G__29443 = cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(geometry);
return (fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1(G__29443) : fluree.db.util.json.valid_geojson_QMARK_.call(null,G__29443));
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__4221__auto__)){
return ((cljs.core.map_QMARK_(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(geometry))) || ((cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__4221__auto__;
}
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(cljs.core.cst$kw$geometries.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,cljs.core.cst$kw$geometries.cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((1),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((3),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((3),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((4),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_((function (p1__29444_SHARP_){
return cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,p1__29444_SHARP_);
}),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (geometry){
return false;
}));
