// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_31513){
var state_val_31514 = (state_31513[(1)]);
if((state_val_31514 === (1))){
var state_31513__$1 = state_31513;
var statearr_31515_31529 = state_31513__$1;
(statearr_31515_31529[(2)] = null);

(statearr_31515_31529[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31514 === (2))){
var _ = (function (){var statearr_31516 = state_31513;
(statearr_31516[(4)] = cljs.core.cons((5),(state_31513[(4)])));

return statearr_31516;
})();
var inst_31504 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_31513__$1 = state_31513;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31513__$1,(6),inst_31504);
} else {
if((state_val_31514 === (3))){
var inst_31511 = (state_31513[(2)]);
var state_31513__$1 = state_31513;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31513__$1,inst_31511);
} else {
if((state_val_31514 === (4))){
var inst_31498 = (state_31513[(2)]);
var state_31513__$1 = state_31513;
var statearr_31518_31530 = state_31513__$1;
(statearr_31518_31530[(2)] = inst_31498);

(statearr_31518_31530[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31514 === (5))){
var _ = (function (){var statearr_31519 = state_31513;
(statearr_31519[(4)] = cljs.core.rest((state_31513[(4)])));

return statearr_31519;
})();
var state_31513__$1 = state_31513;
var ex31517 = (state_31513__$1[(2)]);
var statearr_31520_31531 = state_31513__$1;
(statearr_31520_31531[(5)] = ex31517);


if((ex31517 instanceof Error)){
var statearr_31521_31532 = state_31513__$1;
(statearr_31521_31532[(1)] = (4));

(statearr_31521_31532[(5)] = null);

} else {
throw ex31517;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31514 === (6))){
var inst_31506 = (state_31513[(2)]);
var inst_31507 = fluree.db.util.async.throw_err(inst_31506);
var inst_31508 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_31507);
var _ = (function (){var statearr_31522 = state_31513;
(statearr_31522[(4)] = cljs.core.rest((state_31513[(4)])));

return statearr_31522;
})();
var state_31513__$1 = state_31513;
var statearr_31523_31533 = state_31513__$1;
(statearr_31523_31533[(2)] = inst_31508);

(statearr_31523_31533[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16153__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16153__auto____0 = (function (){
var statearr_31524 = [null,null,null,null,null,null,null];
(statearr_31524[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16153__auto__);

(statearr_31524[(1)] = (1));

return statearr_31524;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16153__auto____1 = (function (state_31513){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_31513);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e31525){var ex__16156__auto__ = e31525;
var statearr_31526_31534 = state_31513;
(statearr_31526_31534[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_31513[(4)]))){
var statearr_31527_31535 = state_31513;
(statearr_31527_31535[(1)] = cljs.core.first((state_31513[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__31536 = state_31513;
state_31513 = G__31536;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16153__auto__ = function(state_31513){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16153__auto____1.call(this,state_31513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16153__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16153__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_31528 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_31528[(6)] = c__16227__auto__);

return statearr_31528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_31568){
var state_val_31569 = (state_31568[(1)]);
if((state_val_31569 === (7))){
var inst_31552 = (state_31568[(7)]);
var inst_31554 = cljs.core.empty_QMARK_(inst_31552);
var inst_31555 = (!(inst_31554));
var state_31568__$1 = state_31568;
var statearr_31570_31594 = state_31568__$1;
(statearr_31570_31594[(2)] = inst_31555);

(statearr_31570_31594[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31569 === (1))){
var state_31568__$1 = state_31568;
var statearr_31571_31595 = state_31568__$1;
(statearr_31571_31595[(2)] = null);

(statearr_31571_31595[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31569 === (4))){
var inst_31538 = (state_31568[(2)]);
var state_31568__$1 = state_31568;
var statearr_31572_31596 = state_31568__$1;
(statearr_31572_31596[(2)] = inst_31538);

(statearr_31572_31596[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31569 === (6))){
var inst_31552 = (state_31568[(7)]);
var inst_31544 = (state_31568[(8)]);
var inst_31550 = (state_31568[(2)]);
var inst_31551 = fluree.db.util.async.throw_err(inst_31550);
var inst_31552__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_31544,inst_31551);
var state_31568__$1 = (function (){var statearr_31573 = state_31568;
(statearr_31573[(7)] = inst_31552__$1);

return statearr_31573;
})();
if(cljs.core.truth_(inst_31552__$1)){
var statearr_31574_31597 = state_31568__$1;
(statearr_31574_31597[(1)] = (7));

} else {
var statearr_31575_31598 = state_31568__$1;
(statearr_31575_31598[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31569 === (3))){
var inst_31566 = (state_31568[(2)]);
var state_31568__$1 = state_31568;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31568__$1,inst_31566);
} else {
if((state_val_31569 === (12))){
var inst_31563 = (state_31568[(2)]);
var _ = (function (){var statearr_31576 = state_31568;
(statearr_31576[(4)] = cljs.core.rest((state_31568[(4)])));

return statearr_31576;
})();
var state_31568__$1 = state_31568;
var statearr_31577_31599 = state_31568__$1;
(statearr_31577_31599[(2)] = inst_31563);

(statearr_31577_31599[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31569 === (2))){
var _ = (function (){var statearr_31578 = state_31568;
(statearr_31578[(4)] = cljs.core.cons((5),(state_31568[(4)])));

return statearr_31578;
})();
var inst_31544 = (function (){return (function (p1__31537_SHARP_){
return p1__31537_SHARP_.o;
});
})();
var inst_31545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31546 = [pred_id];
var inst_31547 = (new cljs.core.PersistentVector(null,1,(5),inst_31545,inst_31546,null));
var inst_31548 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_31547);
var state_31568__$1 = (function (){var statearr_31579 = state_31568;
(statearr_31579[(8)] = inst_31544);

return statearr_31579;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31568__$1,(6),inst_31548);
} else {
if((state_val_31569 === (11))){
var state_31568__$1 = state_31568;
var statearr_31581_31600 = state_31568__$1;
(statearr_31581_31600[(2)] = true);

(statearr_31581_31600[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31569 === (9))){
var inst_31558 = (state_31568[(2)]);
var state_31568__$1 = state_31568;
if(cljs.core.truth_(inst_31558)){
var statearr_31582_31601 = state_31568__$1;
(statearr_31582_31601[(1)] = (10));

} else {
var statearr_31583_31602 = state_31568__$1;
(statearr_31583_31602[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31569 === (5))){
var _ = (function (){var statearr_31584 = state_31568;
(statearr_31584[(4)] = cljs.core.rest((state_31568[(4)])));

return statearr_31584;
})();
var state_31568__$1 = state_31568;
var ex31580 = (state_31568__$1[(2)]);
var statearr_31585_31603 = state_31568__$1;
(statearr_31585_31603[(5)] = ex31580);


if((ex31580 instanceof Error)){
var statearr_31586_31604 = state_31568__$1;
(statearr_31586_31604[(1)] = (4));

(statearr_31586_31604[(5)] = null);

} else {
throw ex31580;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31569 === (10))){
var inst_31552 = (state_31568[(7)]);
var inst_31560 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_31552);
var state_31568__$1 = state_31568;
var statearr_31587_31605 = state_31568__$1;
(statearr_31587_31605[(2)] = inst_31560);

(statearr_31587_31605[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31569 === (8))){
var inst_31552 = (state_31568[(7)]);
var state_31568__$1 = state_31568;
var statearr_31588_31606 = state_31568__$1;
(statearr_31588_31606[(2)] = inst_31552);

(statearr_31588_31606[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16153__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16153__auto____0 = (function (){
var statearr_31589 = [null,null,null,null,null,null,null,null,null];
(statearr_31589[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16153__auto__);

(statearr_31589[(1)] = (1));

return statearr_31589;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16153__auto____1 = (function (state_31568){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_31568);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e31590){var ex__16156__auto__ = e31590;
var statearr_31591_31607 = state_31568;
(statearr_31591_31607[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_31568[(4)]))){
var statearr_31592_31608 = state_31568;
(statearr_31592_31608[(1)] = cljs.core.first((state_31568[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__31609 = state_31568;
state_31568 = G__31609;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16153__auto__ = function(state_31568){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16153__auto____1.call(this,state_31568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16153__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16153__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_31593 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_31593[(6)] = c__16227__auto__);

return statearr_31593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_31690){
var state_val_31691 = (state_31690[(1)]);
if((state_val_31691 === (7))){
var state_31690__$1 = state_31690;
var statearr_31692_31730 = state_31690__$1;
(statearr_31692_31730[(2)] = flakes);

(statearr_31692_31730[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (20))){
var inst_31647 = (state_31690[(7)]);
var inst_31680 = (state_31690[(2)]);
var inst_31639 = inst_31647;
var inst_31640 = inst_31680;
var state_31690__$1 = (function (){var statearr_31693 = state_31690;
(statearr_31693[(8)] = inst_31640);

(statearr_31693[(9)] = inst_31639);

return statearr_31693;
})();
var statearr_31694_31731 = state_31690__$1;
(statearr_31694_31731[(2)] = null);

(statearr_31694_31731[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (1))){
var state_31690__$1 = state_31690;
var statearr_31695_31732 = state_31690__$1;
(statearr_31695_31732[(2)] = null);

(statearr_31695_31732[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (4))){
var inst_31612 = (state_31690[(2)]);
var state_31690__$1 = state_31690;
var statearr_31696_31733 = state_31690__$1;
(statearr_31696_31733[(2)] = inst_31612);

(statearr_31696_31733[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (15))){
var inst_31646 = (state_31690[(10)]);
var inst_31664 = inst_31646.o;
var state_31690__$1 = state_31690;
var statearr_31697_31734 = state_31690__$1;
(statearr_31697_31734[(2)] = inst_31664);

(statearr_31697_31734[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (13))){
var inst_31683 = (state_31690[(2)]);
var state_31690__$1 = state_31690;
var statearr_31698_31735 = state_31690__$1;
(statearr_31698_31735[(2)] = inst_31683);

(statearr_31698_31735[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (6))){
var inst_31619 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_31690__$1 = state_31690;
var statearr_31699_31736 = state_31690__$1;
(statearr_31699_31736[(2)] = inst_31619);

(statearr_31699_31736[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (17))){
var inst_31661 = (state_31690[(2)]);
var inst_31662 = fluree.db.util.async.throw_err(inst_31661);
var state_31690__$1 = state_31690;
var statearr_31700_31737 = state_31690__$1;
(statearr_31700_31737[(2)] = inst_31662);

(statearr_31700_31737[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (3))){
var inst_31688 = (state_31690[(2)]);
var state_31690__$1 = state_31690;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31690__$1,inst_31688);
} else {
if((state_val_31691 === (12))){
var inst_31646 = (state_31690[(10)]);
var inst_31653 = (state_31690[(11)]);
var inst_31651 = inst_31646.p;
var inst_31652 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_31651);
var inst_31653__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_31652);
var inst_31654 = inst_31646.op;
var inst_31655 = inst_31654 === false;
var inst_31656 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_31653__$1);
var state_31690__$1 = (function (){var statearr_31701 = state_31690;
(statearr_31701[(12)] = inst_31655);

(statearr_31701[(11)] = inst_31653__$1);

return statearr_31701;
})();
if(inst_31656){
var statearr_31702_31738 = state_31690__$1;
(statearr_31702_31738[(1)] = (14));

} else {
var statearr_31703_31739 = state_31690__$1;
(statearr_31703_31739[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (2))){
var _ = (function (){var statearr_31704 = state_31690;
(statearr_31704[(4)] = cljs.core.cons((5),(state_31690[(4)])));

return statearr_31704;
})();
var state_31690__$1 = state_31690;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_31705_31740 = state_31690__$1;
(statearr_31705_31740[(1)] = (6));

} else {
var statearr_31706_31741 = state_31690__$1;
(statearr_31706_31741[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (19))){
var inst_31646 = (state_31690[(10)]);
var inst_31666 = (state_31690[(13)]);
var inst_31640 = (state_31690[(8)]);
var inst_31653 = (state_31690[(11)]);
var inst_31674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31675 = inst_31646.s;
var inst_31676 = [inst_31675,inst_31653,cljs.core.cst$kw$new];
var inst_31677 = (new cljs.core.PersistentVector(null,3,(5),inst_31674,inst_31676,null));
var inst_31678 = cljs.core.assoc_in(inst_31640,inst_31677,inst_31666);
var state_31690__$1 = state_31690;
var statearr_31707_31742 = state_31690__$1;
(statearr_31707_31742[(2)] = inst_31678);

(statearr_31707_31742[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (11))){
var inst_31640 = (state_31690[(8)]);
var state_31690__$1 = state_31690;
var statearr_31709_31743 = state_31690__$1;
(statearr_31709_31743[(2)] = inst_31640);

(statearr_31709_31743[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (9))){
var inst_31646 = (state_31690[(10)]);
var inst_31639 = (state_31690[(9)]);
var inst_31645 = cljs.core.seq(inst_31639);
var inst_31646__$1 = cljs.core.first(inst_31645);
var inst_31647 = cljs.core.next(inst_31645);
var inst_31648 = cljs.core.not(inst_31646__$1);
var state_31690__$1 = (function (){var statearr_31710 = state_31690;
(statearr_31710[(7)] = inst_31647);

(statearr_31710[(10)] = inst_31646__$1);

return statearr_31710;
})();
if(inst_31648){
var statearr_31711_31744 = state_31690__$1;
(statearr_31711_31744[(1)] = (11));

} else {
var statearr_31712_31745 = state_31690__$1;
(statearr_31712_31745[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (5))){
var _ = (function (){var statearr_31713 = state_31690;
(statearr_31713[(4)] = cljs.core.rest((state_31690[(4)])));

return statearr_31713;
})();
var state_31690__$1 = state_31690;
var ex31708 = (state_31690__$1[(2)]);
var statearr_31714_31746 = state_31690__$1;
(statearr_31714_31746[(5)] = ex31708);


if((ex31708 instanceof Error)){
var statearr_31715_31747 = state_31690__$1;
(statearr_31715_31747[(1)] = (4));

(statearr_31715_31747[(5)] = null);

} else {
throw ex31708;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (14))){
var inst_31646 = (state_31690[(10)]);
var inst_31658 = inst_31646.o;
var inst_31659 = fluree.db.query.schema.convert_type_to_kw(inst_31658,db);
var state_31690__$1 = state_31690;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31690__$1,(17),inst_31659);
} else {
if((state_val_31691 === (16))){
var inst_31655 = (state_31690[(12)]);
var inst_31666 = (state_31690[(2)]);
var state_31690__$1 = (function (){var statearr_31716 = state_31690;
(statearr_31716[(13)] = inst_31666);

return statearr_31716;
})();
if(cljs.core.truth_(inst_31655)){
var statearr_31717_31748 = state_31690__$1;
(statearr_31717_31748[(1)] = (18));

} else {
var statearr_31718_31749 = state_31690__$1;
(statearr_31718_31749[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (10))){
var inst_31685 = (state_31690[(2)]);
var _ = (function (){var statearr_31719 = state_31690;
(statearr_31719[(4)] = cljs.core.rest((state_31690[(4)])));

return statearr_31719;
})();
var state_31690__$1 = state_31690;
var statearr_31720_31750 = state_31690__$1;
(statearr_31720_31750[(2)] = inst_31685);

(statearr_31720_31750[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (18))){
var inst_31646 = (state_31690[(10)]);
var inst_31666 = (state_31690[(13)]);
var inst_31640 = (state_31690[(8)]);
var inst_31653 = (state_31690[(11)]);
var inst_31668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31669 = inst_31646.s;
var inst_31670 = [inst_31669,inst_31653,cljs.core.cst$kw$old];
var inst_31671 = (new cljs.core.PersistentVector(null,3,(5),inst_31668,inst_31670,null));
var inst_31672 = cljs.core.assoc_in(inst_31640,inst_31671,inst_31666);
var state_31690__$1 = state_31690;
var statearr_31721_31751 = state_31690__$1;
(statearr_31721_31751[(2)] = inst_31672);

(statearr_31721_31751[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31691 === (8))){
var inst_31622 = (state_31690[(2)]);
var inst_31623 = cljs.core.PersistentHashSet.EMPTY;
var inst_31624 = cljs.core.vals(tempids);
var inst_31625 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31623,inst_31624);
var inst_31626 = (function (){var pred_flakes = inst_31622;
var is_new_QMARK_ = inst_31625;
return (function (p1__31610_SHARP_,p2__31611_SHARP_){
return cljs.core.assoc_in(p1__31610_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__31611_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__31722 = p2__31611_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__31722) : is_new_QMARK_.call(null,G__31722));
})()));
});
})();
var inst_31627 = cljs.core.PersistentHashMap.EMPTY;
var inst_31628 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_31626,inst_31627,inst_31622);
var inst_31636 = cljs.core.seq(inst_31622);
var inst_31637 = cljs.core.first(inst_31636);
var inst_31638 = cljs.core.next(inst_31636);
var inst_31639 = inst_31622;
var inst_31640 = inst_31628;
var state_31690__$1 = (function (){var statearr_31723 = state_31690;
(statearr_31723[(14)] = inst_31638);

(statearr_31723[(8)] = inst_31640);

(statearr_31723[(15)] = inst_31637);

(statearr_31723[(9)] = inst_31639);

return statearr_31723;
})();
var statearr_31724_31752 = state_31690__$1;
(statearr_31724_31752[(2)] = null);

(statearr_31724_31752[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__16153__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__16153__auto____0 = (function (){
var statearr_31725 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31725[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__16153__auto__);

(statearr_31725[(1)] = (1));

return statearr_31725;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__16153__auto____1 = (function (state_31690){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_31690);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e31726){var ex__16156__auto__ = e31726;
var statearr_31727_31753 = state_31690;
(statearr_31727_31753[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_31690[(4)]))){
var statearr_31728_31754 = state_31690;
(statearr_31728_31754[(1)] = cljs.core.first((state_31690[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__31755 = state_31690;
state_31690 = G__31755;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__16153__auto__ = function(state_31690){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16153__auto____1.call(this,state_31690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__16153__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__16153__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_31729 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_31729[(6)] = c__16227__auto__);

return statearr_31729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__31757 = arguments.length;
switch (G__31757) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__31760 = arguments.length;
switch (G__31760) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_32072){
var state_val_32073 = (state_32072[(1)]);
if((state_val_32073 === (121))){
var inst_32027 = (state_32072[(7)]);
var state_32072__$1 = state_32072;
var statearr_32074_32267 = state_32072__$1;
(statearr_32074_32267[(2)] = inst_32027);

(statearr_32074_32267[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (65))){
var inst_31926 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_31926)){
var statearr_32075_32268 = state_32072__$1;
(statearr_32075_32268[(1)] = (66));

} else {
var statearr_32076_32269 = state_32072__$1;
(statearr_32076_32269[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (70))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31936 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_31937 = (inst_31932.cljs$core$IFn$_invoke$arity$5 ? inst_31932.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_31936,null) : inst_31932.call(null,cljs.core.PersistentArrayMap,null,3,inst_31936,null));
var inst_31938 = (inst_31932.cljs$core$IFn$_invoke$arity$4 ? inst_31932.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31937,null) : inst_31932.call(null,cljs.core.PersistentHashSet,null,inst_31937,null));
var inst_31939 = (inst_31938.cljs$core$IFn$_invoke$arity$1 ? inst_31938.cljs$core$IFn$_invoke$arity$1(inst_31931) : inst_31938.call(null,inst_31931));
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_31939)){
var statearr_32077_32270 = state_32072__$1;
(statearr_32077_32270[(1)] = (72));

} else {
var statearr_32078_32271 = state_32072__$1;
(statearr_32078_32271[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (62))){
var inst_31916 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32079_32272 = state_32072__$1;
(statearr_32079_32272[(2)] = inst_31916);

(statearr_32079_32272[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (74))){
var inst_32022 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32080_32273 = state_32072__$1;
(statearr_32080_32273[(2)] = inst_32022);

(statearr_32080_32273[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (110))){
var inst_32049 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_32049)){
var statearr_32081_32274 = state_32072__$1;
(statearr_32081_32274[(1)] = (117));

} else {
var statearr_32082_32275 = state_32072__$1;
(statearr_32082_32275[(1)] = (118));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (7))){
var inst_32067 = (state_32072[(2)]);
var _ = (function (){var statearr_32083 = state_32072;
(statearr_32083[(4)] = cljs.core.rest((state_32072[(4)])));

return statearr_32083;
})();
var state_32072__$1 = state_32072;
var statearr_32084_32276 = state_32072__$1;
(statearr_32084_32276[(2)] = inst_32067);

(statearr_32084_32276[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (59))){
var inst_31800 = (state_32072[(10)]);
var inst_31920 = (state_32072[(11)]);
var inst_31919 = (state_32072[(2)]);
var inst_31920__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31800);
var state_32072__$1 = (function (){var statearr_32085 = state_32072;
(statearr_32085[(11)] = inst_31920__$1);

(statearr_32085[(12)] = inst_31919);

return statearr_32085;
})();
if(cljs.core.truth_(inst_31920__$1)){
var statearr_32086_32277 = state_32072__$1;
(statearr_32086_32277[(1)] = (63));

} else {
var statearr_32087_32278 = state_32072__$1;
(statearr_32087_32278[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (86))){
var inst_31962 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32088_32279 = state_32072__$1;
(statearr_32088_32279[(2)] = inst_31962);

(statearr_32088_32279[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (20))){
var inst_31826 = (state_32072[(13)]);
var inst_31800 = (state_32072[(10)]);
var inst_31826__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31800);
var state_32072__$1 = (function (){var statearr_32089 = state_32072;
(statearr_32089[(13)] = inst_31826__$1);

return statearr_32089;
})();
if(cljs.core.truth_(inst_31826__$1)){
var statearr_32090_32280 = state_32072__$1;
(statearr_32090_32280[(1)] = (23));

} else {
var statearr_32091_32281 = state_32072__$1;
(statearr_32091_32281[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (72))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31941 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31931,inst_31932,throw_QMARK_);
var state_32072__$1 = state_32072;
var statearr_32092_32282 = state_32072__$1;
(statearr_32092_32282[(2)] = inst_31941);

(statearr_32092_32282[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (58))){
var inst_31881 = (state_32072[(14)]);
var state_32072__$1 = state_32072;
var statearr_32093_32283 = state_32072__$1;
(statearr_32093_32283[(2)] = inst_31881);

(statearr_32093_32283[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (60))){
var inst_31788 = (state_32072[(15)]);
var inst_31799 = (state_32072[(16)]);
var inst_31907 = fluree.db.dbproto._p_prop(inst_31788,cljs.core.cst$kw$name,inst_31799);
var inst_31908 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31907)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_31909 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31910 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_31911 = cljs.core.PersistentHashMap.fromArrays(inst_31909,inst_31910);
var inst_31912 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31908,inst_31911);
var inst_31913 = (function(){throw inst_31912})();
var state_32072__$1 = state_32072;
var statearr_32094_32284 = state_32072__$1;
(statearr_32094_32284[(2)] = inst_31913);

(statearr_32094_32284[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (27))){
var inst_31829 = (state_32072[(17)]);
var state_32072__$1 = state_32072;
var statearr_32095_32285 = state_32072__$1;
(statearr_32095_32285[(2)] = inst_31829);

(statearr_32095_32285[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (1))){
var state_32072__$1 = state_32072;
var statearr_32096_32286 = state_32072__$1;
(statearr_32096_32286[(2)] = null);

(statearr_32096_32286[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (69))){
var inst_31919 = (state_32072[(12)]);
var state_32072__$1 = state_32072;
var statearr_32097_32287 = state_32072__$1;
(statearr_32097_32287[(2)] = inst_31919);

(statearr_32097_32287[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (101))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_32000 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31931,inst_31932,throw_QMARK_);
var state_32072__$1 = state_32072;
var statearr_32098_32288 = state_32072__$1;
(statearr_32098_32288[(2)] = inst_32000);

(statearr_32098_32288[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (24))){
var inst_31826 = (state_32072[(13)]);
var state_32072__$1 = state_32072;
var statearr_32099_32289 = state_32072__$1;
(statearr_32099_32289[(2)] = inst_31826);

(statearr_32099_32289[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (102))){
var inst_32002 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32100_32290 = state_32072__$1;
(statearr_32100_32290[(2)] = inst_32002);

(statearr_32100_32290[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (55))){
var inst_31898 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32101_32291 = state_32072__$1;
(statearr_32101_32291[(2)] = inst_31898);

(statearr_32101_32291[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (85))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31960 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31931,inst_31932,throw_QMARK_);
var state_32072__$1 = state_32072;
var statearr_32102_32292 = state_32072__$1;
(statearr_32102_32292[(2)] = inst_31960);

(statearr_32102_32292[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (39))){
var inst_31863 = (state_32072[(18)]);
var state_32072__$1 = state_32072;
var statearr_32103_32293 = state_32072__$1;
(statearr_32103_32293[(2)] = inst_31863);

(statearr_32103_32293[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (88))){
var inst_31919 = (state_32072[(12)]);
var state_32072__$1 = state_32072;
var statearr_32104_32294 = state_32072__$1;
(statearr_32104_32294[(2)] = inst_31919);

(statearr_32104_32294[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (46))){
var inst_31800 = (state_32072[(10)]);
var inst_31882 = (state_32072[(19)]);
var inst_31881 = (state_32072[(2)]);
var inst_31882__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_31800);
var state_32072__$1 = (function (){var statearr_32105 = state_32072;
(statearr_32105[(14)] = inst_31881);

(statearr_32105[(19)] = inst_31882__$1);

return statearr_32105;
})();
if(cljs.core.truth_(inst_31882__$1)){
var statearr_32106_32295 = state_32072__$1;
(statearr_32106_32295[(1)] = (47));

} else {
var statearr_32107_32296 = state_32072__$1;
(statearr_32107_32296[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (4))){
var inst_31761 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32108_32297 = state_32072__$1;
(statearr_32108_32297[(2)] = inst_31761);

(statearr_32108_32297[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (77))){
var inst_32020 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32109_32298 = state_32072__$1;
(statearr_32109_32298[(2)] = inst_32020);

(statearr_32109_32298[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (106))){
var inst_32012 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32110_32299 = state_32072__$1;
(statearr_32110_32299[(2)] = inst_32012);

(statearr_32110_32299[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (119))){
var inst_31798 = (state_32072[(20)]);
var inst_32062 = (state_32072[(2)]);
var inst_31787 = inst_31798;
var inst_31788 = inst_32062;
var state_32072__$1 = (function (){var statearr_32111 = state_32072;
(statearr_32111[(15)] = inst_31788);

(statearr_32111[(21)] = inst_31787);

return statearr_32111;
})();
var statearr_32112_32300 = state_32072__$1;
(statearr_32112_32300[(2)] = null);

(statearr_32112_32300[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (95))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31984 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_31985 = (inst_31932.cljs$core$IFn$_invoke$arity$5 ? inst_31932.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_31984,null) : inst_31932.call(null,cljs.core.PersistentArrayMap,null,5,inst_31984,null));
var inst_31986 = (inst_31932.cljs$core$IFn$_invoke$arity$4 ? inst_31932.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31985,null) : inst_31932.call(null,cljs.core.PersistentHashSet,null,inst_31985,null));
var inst_31987 = (inst_31986.cljs$core$IFn$_invoke$arity$1 ? inst_31986.cljs$core$IFn$_invoke$arity$1(inst_31931) : inst_31986.call(null,inst_31931));
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_31987)){
var statearr_32113_32301 = state_32072__$1;
(statearr_32113_32301[(1)] = (96));

} else {
var statearr_32114_32302 = state_32072__$1;
(statearr_32114_32302[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (54))){
var inst_31889 = (state_32072[(22)]);
var state_32072__$1 = state_32072;
var statearr_32115_32303 = state_32072__$1;
(statearr_32115_32303[(2)] = inst_31889);

(statearr_32115_32303[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (92))){
var inst_31919 = (state_32072[(12)]);
var state_32072__$1 = state_32072;
var statearr_32116_32304 = state_32072__$1;
(statearr_32116_32304[(2)] = inst_31919);

(statearr_32116_32304[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (104))){
var inst_31919 = (state_32072[(12)]);
var state_32072__$1 = state_32072;
var statearr_32117_32305 = state_32072__$1;
(statearr_32117_32305[(2)] = inst_31919);

(statearr_32117_32305[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (15))){
var inst_31808 = (state_32072[(23)]);
var state_32072__$1 = state_32072;
var statearr_32118_32306 = state_32072__$1;
(statearr_32118_32306[(2)] = inst_31808);

(statearr_32118_32306[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (48))){
var inst_31882 = (state_32072[(19)]);
var state_32072__$1 = state_32072;
var statearr_32119_32307 = state_32072__$1;
(statearr_32119_32307[(2)] = inst_31882);

(statearr_32119_32307[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (50))){
var inst_31889 = (state_32072[(22)]);
var inst_31800 = (state_32072[(10)]);
var inst_31887 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_31888 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31887);
var inst_31889__$1 = inst_31888 === true;
var state_32072__$1 = (function (){var statearr_32120 = state_32072;
(statearr_32120[(22)] = inst_31889__$1);

return statearr_32120;
})();
if(cljs.core.truth_(inst_31889__$1)){
var statearr_32121_32308 = state_32072__$1;
(statearr_32121_32308[(1)] = (53));

} else {
var statearr_32122_32309 = state_32072__$1;
(statearr_32122_32309[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (116))){
var inst_32043 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32123_32310 = state_32072__$1;
(statearr_32123_32310[(2)] = inst_32043);

(statearr_32123_32310[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (75))){
var inst_31932 = (state_32072[(9)]);
var state_32072__$1 = state_32072;
var G__32124_32311 = inst_31932;
var G__32124_32312__$1 = (((G__32124_32311 instanceof cljs.core.Keyword))?G__32124_32311.fqn:null);
switch (G__32124_32312__$1) {
case "long":
var statearr_32125_32314 = state_32072__$1;
(statearr_32125_32314[(1)] = (79));


break;
case "bigint":
var statearr_32126_32315 = state_32072__$1;
(statearr_32126_32315[(1)] = (83));


break;
case "double":
var statearr_32127_32316 = state_32072__$1;
(statearr_32127_32316[(1)] = (87));


break;
case "float":
var statearr_32128_32317 = state_32072__$1;
(statearr_32128_32317[(1)] = (91));


break;
case "bigdec":
var statearr_32129_32318 = state_32072__$1;
(statearr_32129_32318[(1)] = (95));


break;
case "string":
var statearr_32130_32319 = state_32072__$1;
(statearr_32130_32319[(1)] = (99));


break;
case "instant":
var statearr_32131_32320 = state_32072__$1;
(statearr_32131_32320[(1)] = (103));


break;
default:
var statearr_32132_32321 = state_32072__$1;
(statearr_32132_32321[(1)] = (107));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (99))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31994 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_31995 = (inst_31932.cljs$core$IFn$_invoke$arity$5 ? inst_31932.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_31994,null) : inst_31932.call(null,cljs.core.PersistentArrayMap,null,5,inst_31994,null));
var inst_31996 = (inst_31932.cljs$core$IFn$_invoke$arity$4 ? inst_31932.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31995,null) : inst_31932.call(null,cljs.core.PersistentHashSet,null,inst_31995,null));
var inst_31997 = (inst_31996.cljs$core$IFn$_invoke$arity$1 ? inst_31996.cljs$core$IFn$_invoke$arity$1(inst_31931) : inst_31996.call(null,inst_31931));
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_31997)){
var statearr_32133_32322 = state_32072__$1;
(statearr_32133_32322[(1)] = (100));

} else {
var statearr_32134_32323 = state_32072__$1;
(statearr_32134_32323[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (21))){
var inst_31824 = (state_32072[(24)]);
var state_32072__$1 = state_32072;
var statearr_32135_32324 = state_32072__$1;
(statearr_32135_32324[(2)] = inst_31824);

(statearr_32135_32324[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (31))){
var inst_31840 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32136_32325 = state_32072__$1;
(statearr_32136_32325[(2)] = inst_31840);

(statearr_32136_32325[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (113))){
var inst_32046 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32137_32326 = state_32072__$1;
(statearr_32137_32326[(2)] = inst_32046);

(statearr_32137_32326[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (32))){
var state_32072__$1 = state_32072;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_32138_32327 = state_32072__$1;
(statearr_32138_32327[(1)] = (35));

} else {
var statearr_32139_32328 = state_32072__$1;
(statearr_32139_32328[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (40))){
var inst_31876 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_31876)){
var statearr_32140_32329 = state_32072__$1;
(statearr_32140_32329[(1)] = (44));

} else {
var statearr_32141_32330 = state_32072__$1;
(statearr_32141_32330[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (91))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31974 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_31975 = (inst_31932.cljs$core$IFn$_invoke$arity$5 ? inst_31932.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_31974,null) : inst_31932.call(null,cljs.core.PersistentArrayMap,null,3,inst_31974,null));
var inst_31976 = (inst_31932.cljs$core$IFn$_invoke$arity$4 ? inst_31932.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31975,null) : inst_31932.call(null,cljs.core.PersistentHashSet,null,inst_31975,null));
var inst_31977 = (inst_31976.cljs$core$IFn$_invoke$arity$1 ? inst_31976.cljs$core$IFn$_invoke$arity$1(inst_31931) : inst_31976.call(null,inst_31931));
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_31977)){
var statearr_32142_32331 = state_32072__$1;
(statearr_32142_32331[(1)] = (92));

} else {
var statearr_32143_32332 = state_32072__$1;
(statearr_32143_32332[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (117))){
var state_32072__$1 = state_32072;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_32144_32333 = state_32072__$1;
(statearr_32144_32333[(1)] = (120));

} else {
var statearr_32145_32334 = state_32072__$1;
(statearr_32145_32334[(1)] = (121));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (108))){
var inst_31800 = (state_32072[(10)]);
var inst_32031 = (state_32072[(25)]);
var inst_32031__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_31800);
var state_32072__$1 = (function (){var statearr_32146 = state_32072;
(statearr_32146[(25)] = inst_32031__$1);

return statearr_32146;
})();
if(cljs.core.truth_(inst_32031__$1)){
var statearr_32147_32335 = state_32072__$1;
(statearr_32147_32335[(1)] = (111));

} else {
var statearr_32148_32336 = state_32072__$1;
(statearr_32148_32336[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (56))){
var inst_31893 = (state_32072[(2)]);
var inst_31894 = fluree.db.util.async.throw_err(inst_31893);
var inst_31895 = cljs.core.not(inst_31894);
var state_32072__$1 = state_32072;
var statearr_32149_32337 = state_32072__$1;
(statearr_32149_32337[(2)] = inst_31895);

(statearr_32149_32337[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (33))){
var inst_31823 = (state_32072[(26)]);
var state_32072__$1 = state_32072;
var statearr_32150_32338 = state_32072__$1;
(statearr_32150_32338[(2)] = inst_31823);

(statearr_32150_32338[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (13))){
var inst_31818 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_31818)){
var statearr_32151_32339 = state_32072__$1;
(statearr_32151_32339[(1)] = (17));

} else {
var statearr_32152_32340 = state_32072__$1;
(statearr_32152_32340[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (22))){
var inst_31849 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_31849)){
var statearr_32153_32341 = state_32072__$1;
(statearr_32153_32341[(1)] = (32));

} else {
var statearr_32154_32342 = state_32072__$1;
(statearr_32154_32342[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (90))){
var inst_31972 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32155_32343 = state_32072__$1;
(statearr_32155_32343[(2)] = inst_31972);

(statearr_32155_32343[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (109))){
var inst_32029 = (state_32072[(27)]);
var state_32072__$1 = state_32072;
var statearr_32156_32344 = state_32072__$1;
(statearr_32156_32344[(2)] = inst_32029);

(statearr_32156_32344[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (36))){
var inst_31823 = (state_32072[(26)]);
var state_32072__$1 = state_32072;
var statearr_32157_32345 = state_32072__$1;
(statearr_32157_32345[(2)] = inst_31823);

(statearr_32157_32345[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (41))){
var inst_31800 = (state_32072[(10)]);
var inst_31868 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_31869 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31868);
var inst_31870 = inst_31869 === true;
var state_32072__$1 = state_32072;
var statearr_32158_32346 = state_32072__$1;
(statearr_32158_32346[(2)] = inst_31870);

(statearr_32158_32346[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (118))){
var inst_32027 = (state_32072[(7)]);
var state_32072__$1 = state_32072;
var statearr_32159_32347 = state_32072__$1;
(statearr_32159_32347[(2)] = inst_32027);

(statearr_32159_32347[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (89))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31970 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31931,inst_31932,throw_QMARK_);
var state_32072__$1 = state_32072;
var statearr_32160_32348 = state_32072__$1;
(statearr_32160_32348[(2)] = inst_31970);

(statearr_32160_32348[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (100))){
var inst_31919 = (state_32072[(12)]);
var state_32072__$1 = state_32072;
var statearr_32161_32349 = state_32072__$1;
(statearr_32161_32349[(2)] = inst_31919);

(statearr_32161_32349[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (122))){
var inst_32059 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32162_32350 = state_32072__$1;
(statearr_32162_32350[(2)] = inst_32059);

(statearr_32162_32350[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (43))){
var inst_31873 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32163_32351 = state_32072__$1;
(statearr_32163_32351[(2)] = inst_31873);

(statearr_32163_32351[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (61))){
var inst_31881 = (state_32072[(14)]);
var state_32072__$1 = state_32072;
var statearr_32164_32352 = state_32072__$1;
(statearr_32164_32352[(2)] = inst_31881);

(statearr_32164_32352[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (29))){
var inst_31800 = (state_32072[(10)]);
var inst_31835 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_31836 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31835);
var inst_31837 = inst_31836 === true;
var state_32072__$1 = state_32072;
var statearr_32165_32353 = state_32072__$1;
(statearr_32165_32353[(2)] = inst_31837);

(statearr_32165_32353[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (44))){
var inst_31862 = (state_32072[(28)]);
var inst_31878 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_31862,"a component","a non-component",throw_QMARK_);
var state_32072__$1 = state_32072;
var statearr_32166_32354 = state_32072__$1;
(statearr_32166_32354[(2)] = inst_31878);

(statearr_32166_32354[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (93))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31980 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31931,inst_31932,throw_QMARK_);
var state_32072__$1 = state_32072;
var statearr_32167_32355 = state_32072__$1;
(statearr_32167_32355[(2)] = inst_31980);

(statearr_32167_32355[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (6))){
var inst_31799 = (state_32072[(16)]);
var inst_31787 = (state_32072[(21)]);
var inst_31796 = cljs.core.seq(inst_31787);
var inst_31797 = cljs.core.first(inst_31796);
var inst_31798 = cljs.core.next(inst_31796);
var inst_31799__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31797,(0),null);
var inst_31800 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31797,(1),null);
var inst_31801 = cljs.core.not(inst_31799__$1);
var state_32072__$1 = (function (){var statearr_32168 = state_32072;
(statearr_32168[(10)] = inst_31800);

(statearr_32168[(20)] = inst_31798);

(statearr_32168[(16)] = inst_31799__$1);

return statearr_32168;
})();
if(inst_31801){
var statearr_32169_32356 = state_32072__$1;
(statearr_32169_32356[(1)] = (8));

} else {
var statearr_32170_32357 = state_32072__$1;
(statearr_32170_32357[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (111))){
var inst_32035 = (state_32072[(29)]);
var inst_31800 = (state_32072[(10)]);
var inst_32033 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_32034 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32033);
var inst_32035__$1 = inst_32034 === true;
var state_32072__$1 = (function (){var statearr_32171 = state_32072;
(statearr_32171[(29)] = inst_32035__$1);

return statearr_32171;
})();
if(cljs.core.truth_(inst_32035__$1)){
var statearr_32172_32358 = state_32072__$1;
(statearr_32172_32358[(1)] = (114));

} else {
var statearr_32173_32359 = state_32072__$1;
(statearr_32173_32359[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (28))){
var inst_31843 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32174_32360 = state_32072__$1;
(statearr_32174_32360[(2)] = inst_31843);

(statearr_32174_32360[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (64))){
var inst_31920 = (state_32072[(11)]);
var state_32072__$1 = state_32072;
var statearr_32175_32361 = state_32072__$1;
(statearr_32175_32361[(2)] = inst_31920);

(statearr_32175_32361[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (103))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_32004 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_32005 = (inst_31932.cljs$core$IFn$_invoke$arity$5 ? inst_31932.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_32004,null) : inst_31932.call(null,cljs.core.PersistentArrayMap,null,2,inst_32004,null));
var inst_32006 = (inst_31932.cljs$core$IFn$_invoke$arity$4 ? inst_31932.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_32005,null) : inst_31932.call(null,cljs.core.PersistentHashSet,null,inst_32005,null));
var inst_32007 = (inst_32006.cljs$core$IFn$_invoke$arity$1 ? inst_32006.cljs$core$IFn$_invoke$arity$1(inst_31931) : inst_32006.call(null,inst_31931));
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_32007)){
var statearr_32176_32362 = state_32072__$1;
(statearr_32176_32362[(1)] = (104));

} else {
var statearr_32177_32363 = state_32072__$1;
(statearr_32177_32363[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (51))){
var inst_31885 = (state_32072[(30)]);
var state_32072__$1 = state_32072;
var statearr_32178_32364 = state_32072__$1;
(statearr_32178_32364[(2)] = inst_31885);

(statearr_32178_32364[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (25))){
var inst_31846 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32179_32365 = state_32072__$1;
(statearr_32179_32365[(2)] = inst_31846);

(statearr_32179_32365[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (34))){
var inst_31863 = (state_32072[(18)]);
var inst_31800 = (state_32072[(10)]);
var inst_31862 = (state_32072[(2)]);
var inst_31863__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_31800);
var state_32072__$1 = (function (){var statearr_32180 = state_32072;
(statearr_32180[(28)] = inst_31862);

(statearr_32180[(18)] = inst_31863__$1);

return statearr_32180;
})();
if(cljs.core.truth_(inst_31863__$1)){
var statearr_32181_32366 = state_32072__$1;
(statearr_32181_32366[(1)] = (38));

} else {
var statearr_32182_32367 = state_32072__$1;
(statearr_32182_32367[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (17))){
var inst_31788 = (state_32072[(15)]);
var inst_31820 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_31788,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_32072__$1 = state_32072;
var statearr_32183_32368 = state_32072__$1;
(statearr_32183_32368[(2)] = inst_31820);

(statearr_32183_32368[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (3))){
var inst_32070 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32072__$1,inst_32070);
} else {
if((state_val_32073 === (12))){
var inst_31804 = (state_32072[(31)]);
var state_32072__$1 = state_32072;
var statearr_32184_32369 = state_32072__$1;
(statearr_32184_32369[(2)] = inst_31804);

(statearr_32184_32369[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (2))){
var _ = (function (){var statearr_32185 = state_32072;
(statearr_32185[(4)] = cljs.core.cons((5),(state_32072[(4)])));

return statearr_32185;
})();
var inst_31780 = pred_changes;
var inst_31781 = cljs.core.seq(inst_31780);
var inst_31782 = cljs.core.first(inst_31781);
var inst_31783 = cljs.core.next(inst_31781);
var inst_31784 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31782,(0),null);
var inst_31785 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31782,(1),null);
var inst_31786 = db;
var inst_31787 = inst_31780;
var inst_31788 = inst_31786;
var state_32072__$1 = (function (){var statearr_32186 = state_32072;
(statearr_32186[(15)] = inst_31788);

(statearr_32186[(32)] = inst_31785);

(statearr_32186[(33)] = inst_31784);

(statearr_32186[(34)] = inst_31783);

(statearr_32186[(21)] = inst_31787);

return statearr_32186;
})();
var statearr_32187_32370 = state_32072__$1;
(statearr_32187_32370[(2)] = null);

(statearr_32187_32370[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (66))){
var inst_31800 = (state_32072[(10)]);
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31929 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_31930 = cljs.core.__destructure_map(inst_31929);
var inst_31931__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31930,cljs.core.cst$kw$old);
var inst_31932__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31930,cljs.core.cst$kw$new);
var inst_31933 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31932__$1,inst_31931__$1);
var state_32072__$1 = (function (){var statearr_32188 = state_32072;
(statearr_32188[(8)] = inst_31931__$1);

(statearr_32188[(9)] = inst_31932__$1);

return statearr_32188;
})();
if(inst_31933){
var statearr_32189_32371 = state_32072__$1;
(statearr_32189_32371[(1)] = (69));

} else {
var statearr_32190_32372 = state_32072__$1;
(statearr_32190_32372[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (107))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_32014 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31931,inst_31932,throw_QMARK_);
var state_32072__$1 = state_32072;
var statearr_32191_32373 = state_32072__$1;
(statearr_32191_32373[(2)] = inst_32014);

(statearr_32191_32373[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (23))){
var inst_31829 = (state_32072[(17)]);
var inst_31800 = (state_32072[(10)]);
var inst_31828 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_31829__$1 = inst_31828 === true;
var state_32072__$1 = (function (){var statearr_32192 = state_32072;
(statearr_32192[(17)] = inst_31829__$1);

return statearr_32192;
})();
if(cljs.core.truth_(inst_31829__$1)){
var statearr_32193_32374 = state_32072__$1;
(statearr_32193_32374[(1)] = (26));

} else {
var statearr_32194_32375 = state_32072__$1;
(statearr_32194_32375[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (47))){
var inst_31885 = (state_32072[(30)]);
var inst_31800 = (state_32072[(10)]);
var inst_31884 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_31885__$1 = cljs.core.not(inst_31884);
var state_32072__$1 = (function (){var statearr_32195 = state_32072;
(statearr_32195[(30)] = inst_31885__$1);

return statearr_32195;
})();
if(inst_31885__$1){
var statearr_32196_32376 = state_32072__$1;
(statearr_32196_32376[(1)] = (50));

} else {
var statearr_32197_32377 = state_32072__$1;
(statearr_32197_32377[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (35))){
var inst_31852 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31853 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_31854 = cljs.core.PersistentHashMap.fromArrays(inst_31852,inst_31853);
var inst_31855 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_31854);
var inst_31856 = (function(){throw inst_31855})();
var state_32072__$1 = state_32072;
var statearr_32198_32378 = state_32072__$1;
(statearr_32198_32378[(2)] = inst_31856);

(statearr_32198_32378[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (82))){
var inst_31952 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32199_32379 = state_32072__$1;
(statearr_32199_32379[(2)] = inst_31952);

(statearr_32199_32379[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (76))){
var state_32072__$1 = state_32072;
var statearr_32200_32380 = state_32072__$1;
(statearr_32200_32380[(2)] = null);

(statearr_32200_32380[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (97))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31990 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31931,inst_31932,throw_QMARK_);
var state_32072__$1 = state_32072;
var statearr_32201_32381 = state_32072__$1;
(statearr_32201_32381[(2)] = inst_31990);

(statearr_32201_32381[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (19))){
var inst_31824 = (state_32072[(24)]);
var inst_31800 = (state_32072[(10)]);
var inst_31823 = (state_32072[(2)]);
var inst_31824__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_31800);
var state_32072__$1 = (function (){var statearr_32202 = state_32072;
(statearr_32202[(26)] = inst_31823);

(statearr_32202[(24)] = inst_31824__$1);

return statearr_32202;
})();
if(cljs.core.truth_(inst_31824__$1)){
var statearr_32203_32382 = state_32072__$1;
(statearr_32203_32382[(1)] = (20));

} else {
var statearr_32204_32383 = state_32072__$1;
(statearr_32204_32383[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (57))){
var state_32072__$1 = state_32072;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_32205_32384 = state_32072__$1;
(statearr_32205_32384[(1)] = (60));

} else {
var statearr_32206_32385 = state_32072__$1;
(statearr_32206_32385[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (68))){
var inst_31800 = (state_32072[(10)]);
var inst_32029 = (state_32072[(27)]);
var inst_32027 = (state_32072[(2)]);
var inst_32028 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_32029__$1 = inst_32028 === true;
var state_32072__$1 = (function (){var statearr_32207 = state_32072;
(statearr_32207[(7)] = inst_32027);

(statearr_32207[(27)] = inst_32029__$1);

return statearr_32207;
})();
if(cljs.core.truth_(inst_32029__$1)){
var statearr_32208_32386 = state_32072__$1;
(statearr_32208_32386[(1)] = (108));

} else {
var statearr_32209_32387 = state_32072__$1;
(statearr_32209_32387[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (11))){
var inst_31800 = (state_32072[(10)]);
var inst_31808 = (state_32072[(23)]);
var inst_31806 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_31807 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31806);
var inst_31808__$1 = inst_31807 === false;
var state_32072__$1 = (function (){var statearr_32210 = state_32072;
(statearr_32210[(23)] = inst_31808__$1);

return statearr_32210;
})();
if(cljs.core.truth_(inst_31808__$1)){
var statearr_32211_32388 = state_32072__$1;
(statearr_32211_32388[(1)] = (14));

} else {
var statearr_32212_32389 = state_32072__$1;
(statearr_32212_32389[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (115))){
var inst_32035 = (state_32072[(29)]);
var state_32072__$1 = state_32072;
var statearr_32214_32390 = state_32072__$1;
(statearr_32214_32390[(2)] = inst_32035);

(statearr_32214_32390[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (9))){
var inst_31800 = (state_32072[(10)]);
var inst_31804 = (state_32072[(31)]);
var inst_31804__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_31800);
var state_32072__$1 = (function (){var statearr_32215 = state_32072;
(statearr_32215[(31)] = inst_31804__$1);

return statearr_32215;
})();
if(cljs.core.truth_(inst_31804__$1)){
var statearr_32216_32391 = state_32072__$1;
(statearr_32216_32391[(1)] = (11));

} else {
var statearr_32217_32392 = state_32072__$1;
(statearr_32217_32392[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (5))){
var _ = (function (){var statearr_32218 = state_32072;
(statearr_32218[(4)] = cljs.core.rest((state_32072[(4)])));

return statearr_32218;
})();
var state_32072__$1 = state_32072;
var ex32213 = (state_32072__$1[(2)]);
var statearr_32219_32393 = state_32072__$1;
(statearr_32219_32393[(5)] = ex32213);


if((ex32213 instanceof Error)){
var statearr_32220_32394 = state_32072__$1;
(statearr_32220_32394[(1)] = (4));

(statearr_32220_32394[(5)] = null);

} else {
throw ex32213;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (112))){
var inst_32031 = (state_32072[(25)]);
var state_32072__$1 = state_32072;
var statearr_32221_32395 = state_32072__$1;
(statearr_32221_32395[(2)] = inst_32031);

(statearr_32221_32395[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (83))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31954 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_31955 = (inst_31932.cljs$core$IFn$_invoke$arity$5 ? inst_31932.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_31954,null) : inst_31932.call(null,cljs.core.PersistentArrayMap,null,3,inst_31954,null));
var inst_31956 = (inst_31932.cljs$core$IFn$_invoke$arity$4 ? inst_31932.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31955,null) : inst_31932.call(null,cljs.core.PersistentHashSet,null,inst_31955,null));
var inst_31957 = (inst_31956.cljs$core$IFn$_invoke$arity$1 ? inst_31956.cljs$core$IFn$_invoke$arity$1(inst_31931) : inst_31956.call(null,inst_31931));
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_31957)){
var statearr_32222_32396 = state_32072__$1;
(statearr_32222_32396[(1)] = (84));

} else {
var statearr_32223_32397 = state_32072__$1;
(statearr_32223_32397[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (14))){
var inst_31800 = (state_32072[(10)]);
var inst_31810 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_31811 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_31810);
var inst_31812 = inst_31811 === true;
var state_32072__$1 = state_32072;
var statearr_32224_32398 = state_32072__$1;
(statearr_32224_32398[(2)] = inst_31812);

(statearr_32224_32398[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (45))){
var inst_31862 = (state_32072[(28)]);
var state_32072__$1 = state_32072;
var statearr_32225_32399 = state_32072__$1;
(statearr_32225_32399[(2)] = inst_31862);

(statearr_32225_32399[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (53))){
var inst_31788 = (state_32072[(15)]);
var inst_31799 = (state_32072[(16)]);
var inst_31891 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_31788,inst_31799);
var state_32072__$1 = state_32072;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32072__$1,(56),inst_31891);
} else {
if((state_val_32073 === (78))){
var inst_32017 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32226_32400 = state_32072__$1;
(statearr_32226_32400[(2)] = inst_32017);

(statearr_32226_32400[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (26))){
var inst_31800 = (state_32072[(10)]);
var inst_31833 = (state_32072[(35)]);
var inst_31831 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_31832 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31831);
var inst_31833__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_31832);
var state_32072__$1 = (function (){var statearr_32227 = state_32072;
(statearr_32227[(35)] = inst_31833__$1);

return statearr_32227;
})();
if(inst_31833__$1){
var statearr_32228_32401 = state_32072__$1;
(statearr_32228_32401[(1)] = (29));

} else {
var statearr_32229_32402 = state_32072__$1;
(statearr_32229_32402[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (16))){
var inst_31815 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32230_32403 = state_32072__$1;
(statearr_32230_32403[(2)] = inst_31815);

(statearr_32230_32403[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (81))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31950 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31931,inst_31932,throw_QMARK_);
var state_32072__$1 = state_32072;
var statearr_32231_32404 = state_32072__$1;
(statearr_32231_32404[(2)] = inst_31950);

(statearr_32231_32404[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (120))){
var inst_32052 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32053 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_32054 = cljs.core.PersistentHashMap.fromArrays(inst_32052,inst_32053);
var inst_32055 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_32054);
var inst_32056 = (function(){throw inst_32055})();
var state_32072__$1 = state_32072;
var statearr_32232_32405 = state_32072__$1;
(statearr_32232_32405[(2)] = inst_32056);

(statearr_32232_32405[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (79))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31944 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_31945 = (inst_31932.cljs$core$IFn$_invoke$arity$5 ? inst_31932.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_31944,null) : inst_31932.call(null,cljs.core.PersistentArrayMap,null,2,inst_31944,null));
var inst_31946 = (inst_31932.cljs$core$IFn$_invoke$arity$4 ? inst_31932.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31945,null) : inst_31932.call(null,cljs.core.PersistentHashSet,null,inst_31945,null));
var inst_31947 = (inst_31946.cljs$core$IFn$_invoke$arity$1 ? inst_31946.cljs$core$IFn$_invoke$arity$1(inst_31931) : inst_31946.call(null,inst_31931));
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_31947)){
var statearr_32233_32406 = state_32072__$1;
(statearr_32233_32406[(1)] = (80));

} else {
var statearr_32234_32407 = state_32072__$1;
(statearr_32234_32407[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (38))){
var inst_31866 = (state_32072[(36)]);
var inst_31800 = (state_32072[(10)]);
var inst_31865 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_31866__$1 = cljs.core.not(inst_31865);
var state_32072__$1 = (function (){var statearr_32235 = state_32072;
(statearr_32235[(36)] = inst_31866__$1);

return statearr_32235;
})();
if(inst_31866__$1){
var statearr_32236_32408 = state_32072__$1;
(statearr_32236_32408[(1)] = (41));

} else {
var statearr_32237_32409 = state_32072__$1;
(statearr_32237_32409[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (98))){
var inst_31992 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32238_32410 = state_32072__$1;
(statearr_32238_32410[(2)] = inst_31992);

(statearr_32238_32410[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (87))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_31964 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_31965 = (inst_31932.cljs$core$IFn$_invoke$arity$5 ? inst_31932.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_31964,null) : inst_31932.call(null,cljs.core.PersistentArrayMap,null,3,inst_31964,null));
var inst_31966 = (inst_31932.cljs$core$IFn$_invoke$arity$4 ? inst_31932.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31965,null) : inst_31932.call(null,cljs.core.PersistentHashSet,null,inst_31965,null));
var inst_31967 = (inst_31966.cljs$core$IFn$_invoke$arity$1 ? inst_31966.cljs$core$IFn$_invoke$arity$1(inst_31931) : inst_31966.call(null,inst_31931));
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_31967)){
var statearr_32239_32411 = state_32072__$1;
(statearr_32239_32411[(1)] = (88));

} else {
var statearr_32240_32412 = state_32072__$1;
(statearr_32240_32412[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (30))){
var inst_31833 = (state_32072[(35)]);
var state_32072__$1 = state_32072;
var statearr_32241_32413 = state_32072__$1;
(statearr_32241_32413[(2)] = inst_31833);

(statearr_32241_32413[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (73))){
var state_32072__$1 = state_32072;
var statearr_32242_32414 = state_32072__$1;
(statearr_32242_32414[(1)] = (75));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (96))){
var inst_31919 = (state_32072[(12)]);
var state_32072__$1 = state_32072;
var statearr_32244_32415 = state_32072__$1;
(statearr_32244_32415[(2)] = inst_31919);

(statearr_32244_32415[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (10))){
var inst_32065 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32245_32416 = state_32072__$1;
(statearr_32245_32416[(2)] = inst_32065);

(statearr_32245_32416[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (18))){
var inst_31788 = (state_32072[(15)]);
var state_32072__$1 = state_32072;
var statearr_32246_32417 = state_32072__$1;
(statearr_32246_32417[(2)] = inst_31788);

(statearr_32246_32417[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (105))){
var inst_31931 = (state_32072[(8)]);
var inst_31932 = (state_32072[(9)]);
var inst_32010 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31931,inst_31932,throw_QMARK_);
var state_32072__$1 = state_32072;
var statearr_32247_32418 = state_32072__$1;
(statearr_32247_32418[(2)] = inst_32010);

(statearr_32247_32418[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (52))){
var inst_31901 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32248_32419 = state_32072__$1;
(statearr_32248_32419[(2)] = inst_31901);

(statearr_32248_32419[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (114))){
var inst_31800 = (state_32072[(10)]);
var inst_32037 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_32038 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32037);
var inst_32039 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_32038);
var inst_32040 = (!(inst_32039));
var state_32072__$1 = state_32072;
var statearr_32249_32420 = state_32072__$1;
(statearr_32249_32420[(2)] = inst_32040);

(statearr_32249_32420[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (67))){
var inst_31919 = (state_32072[(12)]);
var state_32072__$1 = state_32072;
var statearr_32250_32421 = state_32072__$1;
(statearr_32250_32421[(2)] = inst_31919);

(statearr_32250_32421[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (71))){
var inst_32024 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32251_32422 = state_32072__$1;
(statearr_32251_32422[(2)] = inst_32024);

(statearr_32251_32422[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (42))){
var inst_31866 = (state_32072[(36)]);
var state_32072__$1 = state_32072;
var statearr_32252_32423 = state_32072__$1;
(statearr_32252_32423[(2)] = inst_31866);

(statearr_32252_32423[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (80))){
var inst_31919 = (state_32072[(12)]);
var state_32072__$1 = state_32072;
var statearr_32253_32424 = state_32072__$1;
(statearr_32253_32424[(2)] = inst_31919);

(statearr_32253_32424[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (37))){
var inst_31859 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32254_32425 = state_32072__$1;
(statearr_32254_32425[(2)] = inst_31859);

(statearr_32254_32425[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (63))){
var inst_31800 = (state_32072[(10)]);
var inst_31922 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31800);
var inst_31923 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_31922);
var state_32072__$1 = state_32072;
var statearr_32255_32426 = state_32072__$1;
(statearr_32255_32426[(2)] = inst_31923);

(statearr_32255_32426[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (94))){
var inst_31982 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
var statearr_32256_32427 = state_32072__$1;
(statearr_32256_32427[(2)] = inst_31982);

(statearr_32256_32427[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (8))){
var inst_31788 = (state_32072[(15)]);
var state_32072__$1 = state_32072;
var statearr_32257_32428 = state_32072__$1;
(statearr_32257_32428[(2)] = inst_31788);

(statearr_32257_32428[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (49))){
var inst_31904 = (state_32072[(2)]);
var state_32072__$1 = state_32072;
if(cljs.core.truth_(inst_31904)){
var statearr_32258_32429 = state_32072__$1;
(statearr_32258_32429[(1)] = (57));

} else {
var statearr_32259_32430 = state_32072__$1;
(statearr_32259_32430[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32073 === (84))){
var inst_31919 = (state_32072[(12)]);
var state_32072__$1 = state_32072;
var statearr_32260_32431 = state_32072__$1;
(statearr_32260_32431[(2)] = inst_31919);

(statearr_32260_32431[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__16153__auto__ = null;
var fluree$db$query$schema$state_machine__16153__auto____0 = (function (){
var statearr_32261 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32261[(0)] = fluree$db$query$schema$state_machine__16153__auto__);

(statearr_32261[(1)] = (1));

return statearr_32261;
});
var fluree$db$query$schema$state_machine__16153__auto____1 = (function (state_32072){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_32072);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e32262){var ex__16156__auto__ = e32262;
var statearr_32263_32432 = state_32072;
(statearr_32263_32432[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_32072[(4)]))){
var statearr_32264_32433 = state_32072;
(statearr_32264_32433[(1)] = cljs.core.first((state_32072[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__32434 = state_32072;
state_32072 = G__32434;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__16153__auto__ = function(state_32072){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__16153__auto____1.call(this,state_32072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__16153__auto____0;
fluree$db$query$schema$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__16153__auto____1;
return fluree$db$query$schema$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_32265 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_32265[(6)] = c__16227__auto__);

return statearr_32265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__32436 = arguments.length;
switch (G__32436) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_32460){
var state_val_32461 = (state_32460[(1)]);
if((state_val_32461 === (7))){
var state_32460__$1 = state_32460;
var statearr_32462_32482 = state_32460__$1;
(statearr_32462_32482[(2)] = db);

(statearr_32462_32482[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32461 === (1))){
var state_32460__$1 = state_32460;
var statearr_32463_32483 = state_32460__$1;
(statearr_32463_32483[(2)] = null);

(statearr_32463_32483[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32461 === (4))){
var inst_32437 = (state_32460[(2)]);
var state_32460__$1 = state_32460;
var statearr_32464_32484 = state_32460__$1;
(statearr_32464_32484[(2)] = inst_32437);

(statearr_32464_32484[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32461 === (6))){
var inst_32446 = (state_32460[(7)]);
var inst_32445 = (state_32460[(2)]);
var inst_32446__$1 = fluree.db.util.async.throw_err(inst_32445);
var inst_32447 = cljs.core.empty_QMARK_(inst_32446__$1);
var state_32460__$1 = (function (){var statearr_32465 = state_32460;
(statearr_32465[(7)] = inst_32446__$1);

return statearr_32465;
})();
if(inst_32447){
var statearr_32466_32485 = state_32460__$1;
(statearr_32466_32485[(1)] = (7));

} else {
var statearr_32467_32486 = state_32460__$1;
(statearr_32467_32486[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32461 === (3))){
var inst_32458 = (state_32460[(2)]);
var state_32460__$1 = state_32460;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32460__$1,inst_32458);
} else {
if((state_val_32461 === (2))){
var _ = (function (){var statearr_32469 = state_32460;
(statearr_32469[(4)] = cljs.core.cons((5),(state_32460[(4)])));

return statearr_32469;
})();
var inst_32443 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_32460__$1 = state_32460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32460__$1,(6),inst_32443);
} else {
if((state_val_32461 === (9))){
var inst_32455 = (state_32460[(2)]);
var _ = (function (){var statearr_32470 = state_32460;
(statearr_32470[(4)] = cljs.core.rest((state_32460[(4)])));

return statearr_32470;
})();
var state_32460__$1 = state_32460;
var statearr_32471_32487 = state_32460__$1;
(statearr_32471_32487[(2)] = inst_32455);

(statearr_32471_32487[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32461 === (5))){
var _ = (function (){var statearr_32472 = state_32460;
(statearr_32472[(4)] = cljs.core.rest((state_32460[(4)])));

return statearr_32472;
})();
var state_32460__$1 = state_32460;
var ex32468 = (state_32460__$1[(2)]);
var statearr_32473_32488 = state_32460__$1;
(statearr_32473_32488[(5)] = ex32468);


if((ex32468 instanceof Error)){
var statearr_32474_32489 = state_32460__$1;
(statearr_32474_32489[(1)] = (4));

(statearr_32474_32489[(5)] = null);

} else {
throw ex32468;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32461 === (10))){
var inst_32452 = (state_32460[(2)]);
var inst_32453 = fluree.db.util.async.throw_err(inst_32452);
var state_32460__$1 = state_32460;
var statearr_32475_32490 = state_32460__$1;
(statearr_32475_32490[(2)] = inst_32453);

(statearr_32475_32490[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32461 === (8))){
var inst_32446 = (state_32460[(7)]);
var inst_32450 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_32446,db,true);
var state_32460__$1 = state_32460;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32460__$1,(10),inst_32450);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__16153__auto__ = null;
var fluree$db$query$schema$state_machine__16153__auto____0 = (function (){
var statearr_32476 = [null,null,null,null,null,null,null,null];
(statearr_32476[(0)] = fluree$db$query$schema$state_machine__16153__auto__);

(statearr_32476[(1)] = (1));

return statearr_32476;
});
var fluree$db$query$schema$state_machine__16153__auto____1 = (function (state_32460){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_32460);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e32477){var ex__16156__auto__ = e32477;
var statearr_32478_32491 = state_32460;
(statearr_32478_32491[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_32460[(4)]))){
var statearr_32479_32492 = state_32460;
(statearr_32479_32492[(1)] = cljs.core.first((state_32460[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__32493 = state_32460;
state_32460 = G__32493;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__16153__auto__ = function(state_32460){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__16153__auto____1.call(this,state_32460);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__16153__auto____0;
fluree$db$query$schema$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__16153__auto____1;
return fluree$db$query$schema$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_32480 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_32480[(6)] = c__16227__auto__);

return statearr_32480;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__32495 = arguments.length;
switch (G__32495) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__32497 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32497,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32497,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32497,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4221__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4221__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__32500_SHARP_,p2__32501_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__32500_SHARP_,p2__32501_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__32502_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,p1__32502_SHARP_.p)){
return p1__32502_SHARP_.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_32568){
var state_val_32569 = (state_32568[(1)]);
if((state_val_32569 === (1))){
var state_32568__$1 = state_32568;
var statearr_32570_32588 = state_32568__$1;
(statearr_32570_32588[(2)] = null);

(statearr_32570_32588[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32569 === (2))){
var _ = (function (){var statearr_32571 = state_32568;
(statearr_32571[(4)] = cljs.core.cons((5),(state_32568[(4)])));

return statearr_32571;
})();
var inst_32520 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32521 = fluree.db.flake.max_subject_id((1));
var inst_32522 = [inst_32521];
var inst_32523 = (new cljs.core.PersistentVector(null,1,(5),inst_32520,inst_32522,null));
var inst_32524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32525 = [(0)];
var inst_32526 = (new cljs.core.PersistentVector(null,1,(5),inst_32524,inst_32525,null));
var inst_32527 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_32523,cljs.core._LT__EQ_,inst_32526);
var state_32568__$1 = state_32568;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32568__$1,(6),inst_32527);
} else {
if((state_val_32569 === (3))){
var inst_32566 = (state_32568[(2)]);
var state_32568__$1 = state_32568;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32568__$1,inst_32566);
} else {
if((state_val_32569 === (4))){
var inst_32508 = (state_32568[(2)]);
var state_32568__$1 = state_32568;
var statearr_32573_32589 = state_32568__$1;
(statearr_32573_32589[(2)] = inst_32508);

(statearr_32573_32589[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32569 === (5))){
var _ = (function (){var statearr_32574 = state_32568;
(statearr_32574[(4)] = cljs.core.rest((state_32568[(4)])));

return statearr_32574;
})();
var state_32568__$1 = state_32568;
var ex32572 = (state_32568__$1[(2)]);
var statearr_32575_32590 = state_32568__$1;
(statearr_32575_32590[(5)] = ex32572);


if((ex32572 instanceof Error)){
var statearr_32576_32591 = state_32568__$1;
(statearr_32576_32591[(1)] = (4));

(statearr_32576_32591[(5)] = null);

} else {
throw ex32572;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32569 === (6))){
var inst_32529 = (state_32568[(2)]);
var inst_32530 = fluree.db.util.async.throw_err(inst_32529);
var inst_32531 = (function (){var schema_flakes = inst_32530;
return (function (p1__32503_SHARP_){
return (p1__32503_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_32532 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32531,inst_32530);
var inst_32533 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32532,(0),null);
var inst_32534 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32532,(1),null);
var inst_32535 = (function (){var schema_flakes = inst_32530;
var vec__32514 = inst_32532;
var collection_flakes = inst_32533;
var predicate_flakes = inst_32534;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__32505_SHARP_,p2__32506_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32505_SHARP_,p2__32506_SHARP_.p,p2__32506_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,specs,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,partition,cljs.core.cst$kw$partition,partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_32536 = [(-1),"_tx"];
var inst_32537 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_32538 = ["_tx",(-1),(-1)];
var inst_32539 = cljs.core.PersistentHashMap.fromArrays(inst_32537,inst_32538);
var inst_32540 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_32541 = ["_tx",(-1),(-1)];
var inst_32542 = cljs.core.PersistentHashMap.fromArrays(inst_32540,inst_32541);
var inst_32543 = [inst_32539,inst_32542];
var inst_32544 = cljs.core.PersistentHashMap.fromArrays(inst_32536,inst_32543);
var inst_32545 = (function (){var schema_flakes = inst_32530;
var vec__32514 = inst_32532;
var collection_flakes = inst_32533;
var predicate_flakes = inst_32534;
return (function (p1__32504_SHARP_){
return p1__32504_SHARP_.s;
});
})();
var inst_32546 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32545,inst_32533);
var inst_32547 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32535,inst_32544,inst_32546);
var inst_32549 = (function (){var schema_flakes = inst_32530;
var vec__32514 = inst_32532;
var collection_flakes = inst_32533;
var predicate_flakes = inst_32534;
var coll = inst_32547;
return (function (p__32548,pred_flakes){
var vec__32577 = p__32548;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32577,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32577,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__32580 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__32580.cljs$core$IFn$_invoke$arity$1 ? fexpr__32580.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__32580.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4223__auto__ = ref_QMARK_;
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$retractDuplicates,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_32550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32551 = cljs.core.PersistentHashMap.EMPTY;
var inst_32552 = cljs.core.PersistentHashSet.EMPTY;
var inst_32553 = [inst_32551,inst_32552];
var inst_32554 = (new cljs.core.PersistentVector(null,2,(5),inst_32550,inst_32553,null));
var inst_32555 = (function (){var schema_flakes = inst_32530;
var vec__32514 = inst_32532;
var collection_flakes = inst_32533;
var predicate_flakes = inst_32534;
var coll = inst_32547;
return (function (p1__32507_SHARP_){
return p1__32507_SHARP_.s;
});
})();
var inst_32556 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32555,inst_32534);
var inst_32557 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32549,inst_32554,inst_32556);
var inst_32558 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32557,(0),null);
var inst_32559 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32557,(1),null);
var inst_32560 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_32561 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_32562 = [inst_32561,inst_32547,inst_32558,inst_32559];
var inst_32563 = cljs.core.PersistentHashMap.fromArrays(inst_32560,inst_32562);
var _ = (function (){var statearr_32581 = state_32568;
(statearr_32581[(4)] = cljs.core.rest((state_32568[(4)])));

return statearr_32581;
})();
var state_32568__$1 = state_32568;
var statearr_32582_32592 = state_32568__$1;
(statearr_32582_32592[(2)] = inst_32563);

(statearr_32582_32592[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__16153__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__16153__auto____0 = (function (){
var statearr_32583 = [null,null,null,null,null,null,null];
(statearr_32583[(0)] = fluree$db$query$schema$schema_map_$_state_machine__16153__auto__);

(statearr_32583[(1)] = (1));

return statearr_32583;
});
var fluree$db$query$schema$schema_map_$_state_machine__16153__auto____1 = (function (state_32568){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_32568);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e32584){var ex__16156__auto__ = e32584;
var statearr_32585_32593 = state_32568;
(statearr_32585_32593[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_32568[(4)]))){
var statearr_32586_32594 = state_32568;
(statearr_32586_32594[(1)] = cljs.core.first((state_32568[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__32595 = state_32568;
state_32568 = G__32595;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__16153__auto__ = function(state_32568){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__16153__auto____1.call(this,state_32568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__16153__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__16153__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_32587 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_32587[(6)] = c__16227__auto__);

return statearr_32587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_32637){
var state_val_32638 = (state_32637[(1)]);
if((state_val_32638 === (7))){
var inst_32620 = (state_32637[(2)]);
var inst_32621 = fluree.db.query.schema.flake__GT_pred_map(inst_32620);
var inst_32622 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_32623 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32621,(114));
var inst_32624 = cljs.core.boolean$(inst_32623);
var inst_32625 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32621,(110));
var inst_32626 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32621,(117));
var inst_32627 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_32626);
var inst_32628 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32621,(111));
var inst_32629 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32621,(115));
var inst_32630 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32621,(112));
var inst_32631 = [inst_32624,inst_32625,inst_32627,inst_32628,inst_32629,inst_32630];
var inst_32632 = cljs.core.PersistentHashMap.fromArrays(inst_32622,inst_32631);
var _ = (function (){var statearr_32639 = state_32637;
(statearr_32639[(4)] = cljs.core.rest((state_32637[(4)])));

return statearr_32639;
})();
var state_32637__$1 = state_32637;
var statearr_32640_32663 = state_32637__$1;
(statearr_32640_32663[(2)] = inst_32632);

(statearr_32640_32663[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32638 === (1))){
var state_32637__$1 = state_32637;
var statearr_32641_32664 = state_32637__$1;
(statearr_32641_32664[(2)] = null);

(statearr_32641_32664[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32638 === (4))){
var inst_32596 = (state_32637[(2)]);
var state_32637__$1 = state_32637;
var statearr_32642_32665 = state_32637__$1;
(statearr_32642_32665[(2)] = inst_32596);

(statearr_32642_32665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32638 === (6))){
var _ = (function (){var statearr_32643 = state_32637;
(statearr_32643[(4)] = cljs.core.cons((9),(state_32637[(4)])));

return statearr_32643;
})();
var inst_32608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32610 = ["_setting/id","root"];
var inst_32611 = (new cljs.core.PersistentVector(null,2,(5),inst_32609,inst_32610,null));
var inst_32612 = [inst_32611];
var inst_32613 = (new cljs.core.PersistentVector(null,1,(5),inst_32608,inst_32612,null));
var inst_32614 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_32613);
var state_32637__$1 = state_32637;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32637__$1,(10),inst_32614);
} else {
if((state_val_32638 === (3))){
var inst_32635 = (state_32637[(2)]);
var state_32637__$1 = state_32637;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32637__$1,inst_32635);
} else {
if((state_val_32638 === (2))){
var _ = (function (){var statearr_32646 = state_32637;
(statearr_32646[(4)] = cljs.core.cons((5),(state_32637[(4)])));

return statearr_32646;
})();
var state_32637__$1 = state_32637;
var statearr_32647_32666 = state_32637__$1;
(statearr_32647_32666[(2)] = null);

(statearr_32647_32666[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32638 === (9))){
var _ = (function (){var statearr_32648 = state_32637;
(statearr_32648[(4)] = cljs.core.rest((state_32637[(4)])));

return statearr_32648;
})();
var state_32637__$1 = state_32637;
var ex32644 = (state_32637__$1[(2)]);
var statearr_32649_32667 = state_32637__$1;
(statearr_32649_32667[(5)] = ex32644);


var statearr_32650_32668 = state_32637__$1;
(statearr_32650_32668[(1)] = (8));

(statearr_32650_32668[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32638 === (5))){
var _ = (function (){var statearr_32651 = state_32637;
(statearr_32651[(4)] = cljs.core.rest((state_32637[(4)])));

return statearr_32651;
})();
var state_32637__$1 = state_32637;
var ex32645 = (state_32637__$1[(2)]);
var statearr_32652_32669 = state_32637__$1;
(statearr_32652_32669[(5)] = ex32645);


if((ex32645 instanceof Error)){
var statearr_32653_32670 = state_32637__$1;
(statearr_32653_32670[(1)] = (4));

(statearr_32653_32670[(5)] = null);

} else {
throw ex32645;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32638 === (10))){
var inst_32616 = (state_32637[(2)]);
var inst_32617 = fluree.db.util.async.throw_err(inst_32616);
var _ = (function (){var statearr_32654 = state_32637;
(statearr_32654[(4)] = cljs.core.rest((state_32637[(4)])));

return statearr_32654;
})();
var state_32637__$1 = state_32637;
var statearr_32655_32671 = state_32637__$1;
(statearr_32655_32671[(2)] = inst_32617);

(statearr_32655_32671[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32638 === (8))){
var inst_32602 = (state_32637[(2)]);
var state_32637__$1 = (function (){var statearr_32656 = state_32637;
(statearr_32656[(7)] = inst_32602);

return statearr_32656;
})();
var statearr_32657_32672 = state_32637__$1;
(statearr_32657_32672[(2)] = null);

(statearr_32657_32672[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__16153__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__16153__auto____0 = (function (){
var statearr_32658 = [null,null,null,null,null,null,null,null];
(statearr_32658[(0)] = fluree$db$query$schema$setting_map_$_state_machine__16153__auto__);

(statearr_32658[(1)] = (1));

return statearr_32658;
});
var fluree$db$query$schema$setting_map_$_state_machine__16153__auto____1 = (function (state_32637){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_32637);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e32659){var ex__16156__auto__ = e32659;
var statearr_32660_32673 = state_32637;
(statearr_32660_32673[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_32637[(4)]))){
var statearr_32661_32674 = state_32637;
(statearr_32661_32674[(1)] = cljs.core.first((state_32637[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__32675 = state_32637;
state_32637 = G__32675;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__16153__auto__ = function(state_32637){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__16153__auto____1.call(this,state_32637);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__16153__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__16153__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_32662 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_32662[(6)] = c__16227__auto__);

return statearr_32662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
