// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e35850){var e = e35850;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__35851_SHARP_){
var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__35851_SHARP_);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__35851_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__35851_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__35851_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35852_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35852_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35853_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35853_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4221__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4223__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__35858 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35858,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35858,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35854_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35854_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4221__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4221__auto__;
}
})())){
var vec__35861 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35861,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35861,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4223__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35855_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35855_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35856_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35856_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35857_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35857_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35864_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__35864_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4223__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4221__auto__ = max_fuel;
if(cljs.core.truth_(and__4221__auto__)){
return (add_amount > max_fuel);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = fuel;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4221__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__35865 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__35865) : intersecting_vars.call(null,G__35865));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__35868,optional_QMARK_,fuel,max_fuel){
var map__35869 = p__35868;
var map__35869__$1 = cljs.core.__destructure_map(map__35869);
var res = map__35869__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35869__$1,cljs.core.cst$kw$vars);
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_35935){
var state_val_35936 = (state_35935[(1)]);
if((state_val_35936 === (7))){
var inst_35924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35925 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_35926 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35925,clause);
var inst_35927 = [null,inst_35926];
var inst_35928 = (new cljs.core.PersistentVector(null,2,(5),inst_35924,inst_35927,null));
var state_35935__$1 = state_35935;
var statearr_35937_35965 = state_35935__$1;
(statearr_35937_35965[(2)] = inst_35928);

(statearr_35937_35965[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35936 === (1))){
var state_35935__$1 = state_35935;
var statearr_35938_35966 = state_35935__$1;
(statearr_35938_35966[(2)] = null);

(statearr_35938_35966[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35936 === (4))){
var inst_35870 = (state_35935[(2)]);
var state_35935__$1 = state_35935;
var statearr_35939_35967 = state_35935__$1;
(statearr_35939_35967[(2)] = inst_35870);

(statearr_35939_35967[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35936 === (15))){
var inst_35913 = (state_35935[(2)]);
var inst_35914 = fluree.db.util.async.throw_err(inst_35913);
var inst_35915 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_35914);
var inst_35916 = cljs.core.count(inst_35915);
var inst_35917 = fluree.db.query.analytical.add_fuel(inst_35916,fuel,max_fuel);
var inst_35918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35919 = [inst_35914,r];
var inst_35920 = (new cljs.core.PersistentVector(null,2,(5),inst_35918,inst_35919,null));
var state_35935__$1 = (function (){var statearr_35940 = state_35935;
(statearr_35940[(7)] = inst_35917);

return statearr_35940;
})();
var statearr_35941_35968 = state_35935__$1;
(statearr_35941_35968[(2)] = inst_35920);

(statearr_35941_35968[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35936 === (13))){
var inst_35879 = (state_35935[(8)]);
var inst_35892 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_35893 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_35892);
var inst_35894 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_35879);
var inst_35895 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_35894);
var inst_35896 = cljs.core.set(inst_35895);
var inst_35897 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_35893);
var inst_35898 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_35897);
var inst_35899 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35896,inst_35898);
var inst_35900 = (function (){var all_wd = inst_35879;
var optional = inst_35893;
var all_wd_vars = inst_35896;
var all_vars = inst_35899;
return (function (p1__35866_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__35866_SHARP_) : all_vars.call(null,p1__35866_SHARP_));
});
})();
var inst_35901 = cljs.core.keys(vars);
var inst_35902 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35900,inst_35901);
var inst_35903 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_35902);
var inst_35904 = cljs.core.set(inst_35903);
var inst_35905 = (function (){var all_wd = inst_35879;
var optional = inst_35893;
var all_wd_vars = inst_35896;
var all_vars = inst_35899;
var intersecting_vars = inst_35904;
return (function (p1__35867_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__35867_SHARP_);
});
})();
var inst_35906 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35905,inst_35879);
var inst_35907 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_35906);
var inst_35908 = fluree.db.query.analytical.select_from_tuples(inst_35907,res);
var inst_35909 = fluree.db.query.analytical.replace_vars_wikidata(inst_35879,inst_35904,vars);
var inst_35910 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_35904,inst_35899);
var inst_35911 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_35909,inst_35907,inst_35908,inst_35910,inst_35893);
var state_35935__$1 = state_35935;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35935__$1,(15),inst_35911);
} else {
if((state_val_35936 === (6))){
var inst_35880 = (state_35935[(9)]);
var inst_35878 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_35879 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_35878);
var inst_35880__$1 = optional_QMARK_;
var state_35935__$1 = (function (){var statearr_35942 = state_35935;
(statearr_35942[(8)] = inst_35879);

(statearr_35942[(9)] = inst_35880__$1);

return statearr_35942;
})();
if(cljs.core.truth_(inst_35880__$1)){
var statearr_35943_35969 = state_35935__$1;
(statearr_35943_35969[(1)] = (9));

} else {
var statearr_35944_35970 = state_35935__$1;
(statearr_35944_35970[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35936 === (3))){
var inst_35933 = (state_35935[(2)]);
var state_35935__$1 = state_35935;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35935__$1,inst_35933);
} else {
if((state_val_35936 === (12))){
var inst_35888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35889 = [null,r];
var inst_35890 = (new cljs.core.PersistentVector(null,2,(5),inst_35888,inst_35889,null));
var state_35935__$1 = state_35935;
var statearr_35945_35971 = state_35935__$1;
(statearr_35945_35971[(2)] = inst_35890);

(statearr_35945_35971[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35936 === (2))){
var _ = (function (){var statearr_35946 = state_35935;
(statearr_35946[(4)] = cljs.core.cons((5),(state_35935[(4)])));

return statearr_35946;
})();
var inst_35876 = (r == null);
var state_35935__$1 = state_35935;
if(cljs.core.truth_(inst_35876)){
var statearr_35947_35972 = state_35935__$1;
(statearr_35947_35972[(1)] = (6));

} else {
var statearr_35948_35973 = state_35935__$1;
(statearr_35948_35973[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35936 === (11))){
var inst_35886 = (state_35935[(2)]);
var state_35935__$1 = state_35935;
if(cljs.core.truth_(inst_35886)){
var statearr_35950_35974 = state_35935__$1;
(statearr_35950_35974[(1)] = (12));

} else {
var statearr_35951_35975 = state_35935__$1;
(statearr_35951_35975[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35936 === (9))){
var inst_35879 = (state_35935[(8)]);
var inst_35882 = cljs.core.empty_QMARK_(inst_35879);
var inst_35883 = (!(inst_35882));
var state_35935__$1 = state_35935;
var statearr_35952_35976 = state_35935__$1;
(statearr_35952_35976[(2)] = inst_35883);

(statearr_35952_35976[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35936 === (5))){
var _ = (function (){var statearr_35953 = state_35935;
(statearr_35953[(4)] = cljs.core.rest((state_35935[(4)])));

return statearr_35953;
})();
var state_35935__$1 = state_35935;
var ex35949 = (state_35935__$1[(2)]);
var statearr_35954_35977 = state_35935__$1;
(statearr_35954_35977[(5)] = ex35949);


if((ex35949 instanceof Error)){
var statearr_35955_35978 = state_35935__$1;
(statearr_35955_35978[(1)] = (4));

(statearr_35955_35978[(5)] = null);

} else {
throw ex35949;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35936 === (14))){
var inst_35922 = (state_35935[(2)]);
var state_35935__$1 = state_35935;
var statearr_35956_35979 = state_35935__$1;
(statearr_35956_35979[(2)] = inst_35922);

(statearr_35956_35979[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35936 === (10))){
var inst_35880 = (state_35935[(9)]);
var state_35935__$1 = state_35935;
var statearr_35957_35980 = state_35935__$1;
(statearr_35957_35980[(2)] = inst_35880);

(statearr_35957_35980[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35936 === (8))){
var inst_35930 = (state_35935[(2)]);
var _ = (function (){var statearr_35958 = state_35935;
(statearr_35958[(4)] = cljs.core.rest((state_35935[(4)])));

return statearr_35958;
})();
var state_35935__$1 = state_35935;
var statearr_35959_35981 = state_35935__$1;
(statearr_35959_35981[(2)] = inst_35930);

(statearr_35959_35981[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16153__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16153__auto____0 = (function (){
var statearr_35960 = [null,null,null,null,null,null,null,null,null,null];
(statearr_35960[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16153__auto__);

(statearr_35960[(1)] = (1));

return statearr_35960;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16153__auto____1 = (function (state_35935){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_35935);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e35961){var ex__16156__auto__ = e35961;
var statearr_35962_35982 = state_35935;
(statearr_35962_35982[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_35935[(4)]))){
var statearr_35963_35983 = state_35935;
(statearr_35963_35983[(1)] = cljs.core.first((state_35935[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__35984 = state_35935;
state_35935 = G__35984;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16153__auto__ = function(state_35935){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16153__auto____1.call(this,state_35935);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16153__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16153__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_35964 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_35964[(6)] = c__16227__auto__);

return statearr_35964;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__35986 = arguments.length;
switch (G__35986) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_36080){
var state_val_36081 = (state_36080[(1)]);
if((state_val_36081 === (7))){
var inst_35993 = (state_36080[(7)]);
var inst_36003 = clojure.string.starts_with_QMARK_(inst_35993,"$fdb");
var state_36080__$1 = state_36080;
if(inst_36003){
var statearr_36082_36131 = state_36080__$1;
(statearr_36082_36131[(1)] = (9));

} else {
var statearr_36083_36132 = state_36080__$1;
(statearr_36083_36132[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (20))){
var state_36080__$1 = state_36080;
var statearr_36084_36133 = state_36080__$1;
(statearr_36084_36133[(2)] = null);

(statearr_36084_36133[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (27))){
var inst_36043 = (state_36080[(8)]);
var state_36080__$1 = state_36080;
var statearr_36085_36134 = state_36080__$1;
(statearr_36085_36134[(2)] = inst_36043);

(statearr_36085_36134[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (1))){
var state_36080__$1 = state_36080;
var statearr_36086_36135 = state_36080__$1;
(statearr_36086_36135[(2)] = null);

(statearr_36086_36135[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (24))){
var inst_36066 = (state_36080[(2)]);
var state_36080__$1 = state_36080;
var statearr_36087_36136 = state_36080__$1;
(statearr_36087_36136[(2)] = inst_36066);

(statearr_36087_36136[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (4))){
var inst_35987 = (state_36080[(2)]);
var state_36080__$1 = state_36080;
var statearr_36088_36137 = state_36080__$1;
(statearr_36088_36137[(2)] = inst_35987);

(statearr_36088_36137[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (15))){
var inst_36010 = (state_36080[(9)]);
var inst_36016 = (state_36080[(2)]);
var inst_36017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36018 = cljs.core.PersistentVector.EMPTY;
var inst_36019 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_36020 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36018,inst_36019);
var inst_36021 = [inst_36010,inst_36020];
var inst_36022 = (new cljs.core.PersistentVector(null,2,(5),inst_36017,inst_36021,null));
var state_36080__$1 = (function (){var statearr_36089 = state_36080;
(statearr_36089[(10)] = inst_36016);

return statearr_36089;
})();
var statearr_36090_36138 = state_36080__$1;
(statearr_36090_36138[(2)] = inst_36022);

(statearr_36090_36138[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (21))){
var inst_36069 = (state_36080[(2)]);
var state_36080__$1 = state_36080;
var statearr_36091_36139 = state_36080__$1;
(statearr_36091_36139[(2)] = inst_36069);

(statearr_36091_36139[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (13))){
var inst_36010 = (state_36080[(9)]);
var inst_36013 = (function(){throw inst_36010})();
var state_36080__$1 = state_36080;
var statearr_36092_36140 = state_36080__$1;
(statearr_36092_36140[(2)] = inst_36013);

(statearr_36092_36140[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (22))){
var inst_36034 = (state_36080[(11)]);
var inst_36032 = (state_36080[(12)]);
var inst_36036 = fluree.db.query.analytical.parse_block_from_source(inst_36032);
var inst_36037 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36038 = [cljs.core.cst$kw$sources,inst_36034];
var inst_36039 = (new cljs.core.PersistentVector(null,2,(5),inst_36037,inst_36038,null));
var inst_36040 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_36039);
var state_36080__$1 = (function (){var statearr_36093 = state_36080;
(statearr_36093[(13)] = inst_36036);

return statearr_36093;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36080__$1,(25),inst_36040);
} else {
if((state_val_36081 === (29))){
var inst_36047 = (state_36080[(2)]);
var inst_36048 = fluree.db.util.async.throw_err(inst_36047);
var state_36080__$1 = state_36080;
var statearr_36094_36141 = state_36080__$1;
(statearr_36094_36141[(2)] = inst_36048);

(statearr_36094_36141[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (6))){
var inst_35996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35997 = cljs.core.PersistentVector.EMPTY;
var inst_35998 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_35999 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35997,inst_35998);
var inst_36000 = [db,inst_35999];
var inst_36001 = (new cljs.core.PersistentVector(null,2,(5),inst_35996,inst_36000,null));
var state_36080__$1 = state_36080;
var statearr_36095_36142 = state_36080__$1;
(statearr_36095_36142[(2)] = inst_36001);

(statearr_36095_36142[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (28))){
var inst_36051 = (state_36080[(2)]);
var inst_36052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36053 = cljs.core.PersistentVector.EMPTY;
var inst_36054 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_36055 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36053,inst_36054);
var inst_36056 = [inst_36051,inst_36055];
var inst_36057 = (new cljs.core.PersistentVector(null,2,(5),inst_36052,inst_36056,null));
var state_36080__$1 = state_36080;
var statearr_36096_36143 = state_36080__$1;
(statearr_36096_36143[(2)] = inst_36057);

(statearr_36096_36143[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (25))){
var inst_36036 = (state_36080[(13)]);
var inst_36042 = (state_36080[(2)]);
var inst_36043 = fluree.db.util.async.throw_err(inst_36042);
var state_36080__$1 = (function (){var statearr_36097 = state_36080;
(statearr_36097[(8)] = inst_36043);

return statearr_36097;
})();
if(cljs.core.truth_(inst_36036)){
var statearr_36098_36144 = state_36080__$1;
(statearr_36098_36144[(1)] = (26));

} else {
var statearr_36099_36145 = state_36080__$1;
(statearr_36099_36145[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (17))){
var state_36080__$1 = state_36080;
var statearr_36100_36146 = state_36080__$1;
(statearr_36100_36146[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (3))){
var inst_36078 = (state_36080[(2)]);
var state_36080__$1 = state_36080;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36080__$1,inst_36078);
} else {
if((state_val_36081 === (12))){
var inst_36010 = (state_36080[(9)]);
var inst_36009 = (state_36080[(2)]);
var inst_36010__$1 = fluree.db.util.async.throw_err(inst_36009);
var inst_36011 = fluree.db.util.core.exception_QMARK_(inst_36010__$1);
var state_36080__$1 = (function (){var statearr_36102 = state_36080;
(statearr_36102[(9)] = inst_36010__$1);

return statearr_36102;
})();
if(inst_36011){
var statearr_36103_36147 = state_36080__$1;
(statearr_36103_36147[(1)] = (13));

} else {
var statearr_36104_36148 = state_36080__$1;
(statearr_36104_36148[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (2))){
var inst_35993 = (state_36080[(7)]);
var _ = (function (){var statearr_36105 = state_36080;
(statearr_36105[(4)] = cljs.core.cons((5),(state_36080[(4)])));

return statearr_36105;
})();
var inst_35993__$1 = cljs.core.first(clause);
var inst_35994 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_35993__$1);
var state_36080__$1 = (function (){var statearr_36106 = state_36080;
(statearr_36106[(7)] = inst_35993__$1);

return statearr_36106;
})();
if(inst_35994){
var statearr_36107_36149 = state_36080__$1;
(statearr_36107_36149[(1)] = (6));

} else {
var statearr_36108_36150 = state_36080__$1;
(statearr_36108_36150[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (23))){
var inst_35993 = (state_36080[(7)]);
var inst_36059 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35993)," is not supported in Fluree"].join('');
var inst_36060 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36061 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36062 = cljs.core.PersistentHashMap.fromArrays(inst_36060,inst_36061);
var inst_36063 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36059,inst_36062);
var inst_36064 = (function(){throw inst_36063})();
var state_36080__$1 = state_36080;
var statearr_36109_36151 = state_36080__$1;
(statearr_36109_36151[(2)] = inst_36064);

(statearr_36109_36151[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (19))){
var inst_36034 = (state_36080[(11)]);
var inst_35993 = (state_36080[(7)]);
var inst_36031 = fluree.db.query.analytical.isolate_source_name(inst_35993);
var inst_36032 = fluree.db.query.analytical.isolate_source_block(inst_35993);
var inst_36033 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_36031);
var inst_36034__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_36033);
var state_36080__$1 = (function (){var statearr_36110 = state_36080;
(statearr_36110[(11)] = inst_36034__$1);

(statearr_36110[(12)] = inst_36032);

return statearr_36110;
})();
if(cljs.core.truth_(inst_36034__$1)){
var statearr_36111_36152 = state_36080__$1;
(statearr_36111_36152[(1)] = (22));

} else {
var statearr_36112_36153 = state_36080__$1;
(statearr_36112_36153[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (11))){
var inst_36073 = (state_36080[(2)]);
var state_36080__$1 = state_36080;
var statearr_36114_36154 = state_36080__$1;
(statearr_36114_36154[(2)] = inst_36073);

(statearr_36114_36154[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (9))){
var inst_35993 = (state_36080[(7)]);
var inst_36005 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_35993,(4));
var inst_36006 = fluree.db.query.analytical.parse_block_from_source(inst_36005);
var inst_36007 = fluree.db.time_travel.as_of_block(db,inst_36006);
var state_36080__$1 = state_36080;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36080__$1,(12),inst_36007);
} else {
if((state_val_36081 === (5))){
var _ = (function (){var statearr_36115 = state_36080;
(statearr_36115[(4)] = cljs.core.rest((state_36080[(4)])));

return statearr_36115;
})();
var state_36080__$1 = state_36080;
var ex36113 = (state_36080__$1[(2)]);
var statearr_36116_36155 = state_36080__$1;
(statearr_36116_36155[(5)] = ex36113);


if((ex36113 instanceof Error)){
var statearr_36117_36156 = state_36080__$1;
(statearr_36117_36156[(1)] = (4));

(statearr_36117_36156[(5)] = null);

} else {
throw ex36113;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (14))){
var state_36080__$1 = state_36080;
var statearr_36118_36157 = state_36080__$1;
(statearr_36118_36157[(2)] = null);

(statearr_36118_36157[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (26))){
var inst_36036 = (state_36080[(13)]);
var inst_36043 = (state_36080[(8)]);
var inst_36045 = fluree.db.time_travel.as_of_block(inst_36043,inst_36036);
var state_36080__$1 = state_36080;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36080__$1,(29),inst_36045);
} else {
if((state_val_36081 === (16))){
var inst_36026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36027 = ["$wd",clause];
var inst_36028 = (new cljs.core.PersistentVector(null,2,(5),inst_36026,inst_36027,null));
var state_36080__$1 = state_36080;
var statearr_36119_36158 = state_36080__$1;
(statearr_36119_36158[(2)] = inst_36028);

(statearr_36119_36158[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (10))){
var inst_35993 = (state_36080[(7)]);
var inst_36024 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_35993);
var state_36080__$1 = state_36080;
if(inst_36024){
var statearr_36120_36159 = state_36080__$1;
(statearr_36120_36159[(1)] = (16));

} else {
var statearr_36121_36160 = state_36080__$1;
(statearr_36121_36160[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (18))){
var inst_36071 = (state_36080[(2)]);
var state_36080__$1 = state_36080;
var statearr_36122_36161 = state_36080__$1;
(statearr_36122_36161[(2)] = inst_36071);

(statearr_36122_36161[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36081 === (8))){
var inst_36075 = (state_36080[(2)]);
var _ = (function (){var statearr_36123 = state_36080;
(statearr_36123[(4)] = cljs.core.rest((state_36080[(4)])));

return statearr_36123;
})();
var state_36080__$1 = state_36080;
var statearr_36124_36162 = state_36080__$1;
(statearr_36124_36162[(2)] = inst_36075);

(statearr_36124_36162[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16153__auto__ = null;
var fluree$db$query$analytical$state_machine__16153__auto____0 = (function (){
var statearr_36125 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36125[(0)] = fluree$db$query$analytical$state_machine__16153__auto__);

(statearr_36125[(1)] = (1));

return statearr_36125;
});
var fluree$db$query$analytical$state_machine__16153__auto____1 = (function (state_36080){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_36080);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e36126){var ex__16156__auto__ = e36126;
var statearr_36127_36163 = state_36080;
(statearr_36127_36163[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_36080[(4)]))){
var statearr_36128_36164 = state_36080;
(statearr_36128_36164[(1)] = cljs.core.first((state_36080[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__36165 = state_36080;
state_36080 = G__36165;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16153__auto__ = function(state_36080){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16153__auto____1.call(this,state_36080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16153__auto____0;
fluree$db$query$analytical$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16153__auto____1;
return fluree$db$query$analytical$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_36129 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_36129[(6)] = c__16227__auto__);

return statearr_36129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__36166){
var vec__36167 = p__36166;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36167,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36167,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36170_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__36170_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__36174 = subjects;
var vec__36175 = G__36174;
var seq__36176 = cljs.core.seq(vec__36175);
var first__36177 = cljs.core.first(seq__36176);
var seq__36176__$1 = cljs.core.next(seq__36176);
var subject = first__36177;
var r = seq__36176__$1;
var acc = expanded_map;
var G__36174__$1 = G__36174;
var acc__$1 = acc;
while(true){
var vec__36181 = G__36174__$1;
var seq__36182 = cljs.core.seq(vec__36181);
var first__36183 = cljs.core.first(seq__36182);
var seq__36182__$1 = cljs.core.next(seq__36182);
var subject__$1 = first__36183;
var r__$1 = seq__36182__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__36184 = r__$1;
var G__36185 = acc__$2;
G__36174__$1 = G__36184;
acc__$1 = G__36185;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__36174__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__36181,seq__36182,first__36183,seq__36182__$1,subject__$1,r__$1,acc__$2,G__36174,vec__36175,seq__36176,first__36177,seq__36176__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4223__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__36174__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__36181,seq__36182,first__36183,seq__36182__$1,subject__$1,r__$1,acc__$2,G__36174,vec__36175,seq__36176,first__36177,seq__36176__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__36174__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__36181,seq__36182,first__36183,seq__36182__$1,subject__$1,r__$1,acc__$2,G__36174,vec__36175,seq__36176,first__36177,seq__36176__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__36174__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__36181,seq__36182,first__36183,seq__36182__$1,subject__$1,r__$1,acc__$2,G__36174,vec__36175,seq__36176,first__36177,seq__36176__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__36174__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__36181,seq__36182,first__36183,seq__36182__$1,subject__$1,r__$1,acc__$2,G__36174,vec__36175,seq__36176,first__36177,seq__36176__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__36174__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__36181,seq__36182,first__36183,seq__36182__$1,subject__$1,r__$1,acc__$2,G__36174,vec__36175,seq__36176,first__36177,seq__36176__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__36186 = r__$1;
var G__36187 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__36174__$1 = G__36186;
acc__$1 = G__36187;
continue;
} else {
var G__36188 = subjects;
var G__36189 = acc_STAR_;
G__36174__$1 = G__36188;
acc__$1 = G__36189;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36190_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__36190_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_36281){
var state_val_36282 = (state_36281[(1)]);
if((state_val_36282 === (7))){
var state_36281__$1 = state_36281;
var statearr_36283_36329 = state_36281__$1;
(statearr_36283_36329[(2)] = (100));

(statearr_36283_36329[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (20))){
var inst_36230 = (state_36281[(7)]);
var state_36281__$1 = state_36281;
var statearr_36284_36330 = state_36281__$1;
(statearr_36284_36330[(2)] = inst_36230);

(statearr_36284_36330[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (1))){
var state_36281__$1 = state_36281;
var statearr_36285_36331 = state_36281__$1;
(statearr_36285_36331[(2)] = null);

(statearr_36285_36331[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (24))){
var inst_36268 = (state_36281[(8)]);
var inst_36267 = (state_36281[(9)]);
var inst_36269 = (state_36281[(10)]);
var inst_36202 = (state_36281[(11)]);
var inst_36272 = (function (){var max_depth = inst_36202;
var recur_map__$1 = inst_36268;
var subjects = inst_36267;
var tuples = inst_36269;
return (function (p1__36191_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__36191_SHARP_)],null));
});
})();
var inst_36273 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_36272,inst_36269);
var inst_36274 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_36273);
var state_36281__$1 = state_36281;
var statearr_36286_36332 = state_36281__$1;
(statearr_36286_36332[(2)] = inst_36274);

(statearr_36286_36332[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (4))){
var inst_36192 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
var statearr_36287_36333 = state_36281__$1;
(statearr_36287_36333[(2)] = inst_36192);

(statearr_36287_36333[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (15))){
var inst_36215 = (state_36281[(12)]);
var inst_36226 = cljs.core.PersistentVector.EMPTY;
var inst_36227 = cljs.core.seq(inst_36215);
var inst_36228 = cljs.core.first(inst_36227);
var inst_36229 = cljs.core.next(inst_36227);
var inst_36230 = inst_36226;
var inst_36231 = inst_36215;
var state_36281__$1 = (function (){var statearr_36288 = state_36281;
(statearr_36288[(13)] = inst_36229);

(statearr_36288[(14)] = inst_36231);

(statearr_36288[(15)] = inst_36228);

(statearr_36288[(7)] = inst_36230);

return statearr_36288;
})();
var statearr_36289_36334 = state_36281__$1;
(statearr_36289_36334[(2)] = null);

(statearr_36289_36334[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (21))){
var inst_36251 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
var statearr_36290_36335 = state_36281__$1;
(statearr_36290_36335[(2)] = inst_36251);

(statearr_36290_36335[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (13))){
var inst_36264 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
var statearr_36291_36336 = state_36281__$1;
(statearr_36291_36336[(2)] = inst_36264);

(statearr_36291_36336[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (22))){
var inst_36238 = (state_36281[(16)]);
var inst_36230 = (state_36281[(7)]);
var inst_36245 = (state_36281[(2)]);
var inst_36246 = fluree.db.util.async.throw_err(inst_36245);
var inst_36247 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_36230,inst_36246);
var inst_36230__$1 = inst_36247;
var inst_36231 = inst_36238;
var state_36281__$1 = (function (){var statearr_36292 = state_36281;
(statearr_36292[(14)] = inst_36231);

(statearr_36292[(7)] = inst_36230__$1);

return statearr_36292;
})();
var statearr_36293_36337 = state_36281__$1;
(statearr_36293_36337[(2)] = null);

(statearr_36293_36337[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (6))){
var inst_36198 = (state_36281[(17)]);
var state_36281__$1 = state_36281;
var statearr_36294_36338 = state_36281__$1;
(statearr_36294_36338[(2)] = inst_36198);

(statearr_36294_36338[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (25))){
var inst_36276 = (state_36281[(2)]);
var _ = (function (){var statearr_36295 = state_36281;
(statearr_36295[(4)] = cljs.core.rest((state_36281[(4)])));

return statearr_36295;
})();
var state_36281__$1 = state_36281;
var statearr_36296_36339 = state_36281__$1;
(statearr_36296_36339[(2)] = inst_36276);

(statearr_36296_36339[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (17))){
var inst_36237 = (state_36281[(18)]);
var inst_36231 = (state_36281[(14)]);
var inst_36236 = cljs.core.seq(inst_36231);
var inst_36237__$1 = cljs.core.first(inst_36236);
var inst_36238 = cljs.core.next(inst_36236);
var state_36281__$1 = (function (){var statearr_36297 = state_36281;
(statearr_36297[(18)] = inst_36237__$1);

(statearr_36297[(16)] = inst_36238);

return statearr_36297;
})();
if(cljs.core.truth_(inst_36237__$1)){
var statearr_36298_36340 = state_36281__$1;
(statearr_36298_36340[(1)] = (19));

} else {
var statearr_36299_36341 = state_36281__$1;
(statearr_36299_36341[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (3))){
var inst_36279 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36281__$1,inst_36279);
} else {
if((state_val_36282 === (12))){
var inst_36215 = (state_36281[(12)]);
var inst_36204 = (state_36281[(19)]);
var inst_36210 = cljs.core.vals(inst_36204);
var inst_36211 = cljs.core.flatten(inst_36210);
var inst_36212 = cljs.core.set(inst_36211);
var inst_36213 = cljs.core.keys(inst_36204);
var inst_36214 = cljs.core.set(inst_36213);
var inst_36215__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_36212,inst_36214);
var inst_36216 = cljs.core.empty_QMARK_(inst_36215__$1);
var state_36281__$1 = (function (){var statearr_36300 = state_36281;
(statearr_36300[(12)] = inst_36215__$1);

return statearr_36300;
})();
if(inst_36216){
var statearr_36301_36342 = state_36281__$1;
(statearr_36301_36342[(1)] = (14));

} else {
var statearr_36302_36343 = state_36281__$1;
(statearr_36302_36343[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (2))){
var inst_36198 = (state_36281[(17)]);
var _ = (function (){var statearr_36303 = state_36281;
(statearr_36303[(4)] = cljs.core.cons((5),(state_36281[(4)])));

return statearr_36303;
})();
var inst_36198__$1 = depth;
var state_36281__$1 = (function (){var statearr_36304 = state_36281;
(statearr_36304[(17)] = inst_36198__$1);

return statearr_36304;
})();
if(cljs.core.truth_(inst_36198__$1)){
var statearr_36305_36344 = state_36281__$1;
(statearr_36305_36344[(1)] = (6));

} else {
var statearr_36306_36345 = state_36281__$1;
(statearr_36306_36345[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (23))){
var inst_36269 = (state_36281[(10)]);
var state_36281__$1 = state_36281;
var statearr_36307_36346 = state_36281__$1;
(statearr_36307_36346[(2)] = inst_36269);

(statearr_36307_36346[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (19))){
var inst_36237 = (state_36281[(18)]);
var inst_36240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36241 = [inst_36237,predicate];
var inst_36242 = (new cljs.core.PersistentVector(null,2,(5),inst_36240,inst_36241,null));
var inst_36243 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36242);
var state_36281__$1 = state_36281;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36281__$1,(22),inst_36243);
} else {
if((state_val_36282 === (11))){
var inst_36204 = (state_36281[(19)]);
var state_36281__$1 = state_36281;
var statearr_36309_36347 = state_36281__$1;
(statearr_36309_36347[(2)] = inst_36204);

(statearr_36309_36347[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (9))){
var inst_36205 = (state_36281[(20)]);
var inst_36202 = (state_36281[(11)]);
var inst_36207 = (inst_36205 >= inst_36202);
var state_36281__$1 = state_36281;
if(cljs.core.truth_(inst_36207)){
var statearr_36310_36348 = state_36281__$1;
(statearr_36310_36348[(1)] = (11));

} else {
var statearr_36311_36349 = state_36281__$1;
(statearr_36311_36349[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (5))){
var _ = (function (){var statearr_36312 = state_36281;
(statearr_36312[(4)] = cljs.core.rest((state_36281[(4)])));

return statearr_36312;
})();
var state_36281__$1 = state_36281;
var ex36308 = (state_36281__$1[(2)]);
var statearr_36313_36350 = state_36281__$1;
(statearr_36313_36350[(5)] = ex36308);


if((ex36308 instanceof Error)){
var statearr_36314_36351 = state_36281__$1;
(statearr_36314_36351[(1)] = (4));

(statearr_36314_36351[(5)] = null);

} else {
throw ex36308;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (14))){
var inst_36204 = (state_36281[(19)]);
var state_36281__$1 = state_36281;
var statearr_36315_36352 = state_36281__$1;
(statearr_36315_36352[(2)] = inst_36204);

(statearr_36315_36352[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (16))){
var inst_36262 = (state_36281[(2)]);
var state_36281__$1 = state_36281;
var statearr_36316_36353 = state_36281__$1;
(statearr_36316_36353[(2)] = inst_36262);

(statearr_36316_36353[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (10))){
var inst_36268 = (state_36281[(8)]);
var inst_36267 = (state_36281[(9)]);
var inst_36266 = (state_36281[(2)]);
var inst_36267__$1 = cljs.core.keys(inst_36266);
var inst_36268__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_36267__$1,inst_36266);
var inst_36269 = fluree.db.query.analytical.recur_map__GT_tuples(inst_36267__$1,inst_36268__$1);
var state_36281__$1 = (function (){var statearr_36317 = state_36281;
(statearr_36317[(8)] = inst_36268__$1);

(statearr_36317[(9)] = inst_36267__$1);

(statearr_36317[(10)] = inst_36269);

return statearr_36317;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_36318_36354 = state_36281__$1;
(statearr_36318_36354[(1)] = (23));

} else {
var statearr_36319_36355 = state_36281__$1;
(statearr_36319_36355[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (18))){
var inst_36205 = (state_36281[(20)]);
var inst_36204 = (state_36281[(19)]);
var inst_36253 = (state_36281[(2)]);
var inst_36254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36255 = [(0),(2)];
var inst_36256 = (new cljs.core.PersistentVector(null,2,(5),inst_36254,inst_36255,null));
var inst_36257 = fluree.db.query.analytical.get_ns_arrays(inst_36256,inst_36253);
var inst_36258 = fluree.db.query.analytical.tuples__GT_map(inst_36204,inst_36257);
var inst_36259 = (inst_36205 + (1));
var inst_36204__$1 = inst_36258;
var inst_36205__$1 = inst_36259;
var state_36281__$1 = (function (){var statearr_36320 = state_36281;
(statearr_36320[(20)] = inst_36205__$1);

(statearr_36320[(19)] = inst_36204__$1);

return statearr_36320;
})();
var statearr_36321_36356 = state_36281__$1;
(statearr_36321_36356[(2)] = null);

(statearr_36321_36356[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36282 === (8))){
var inst_36202 = (state_36281[(2)]);
var inst_36203 = recur_map;
var inst_36204 = inst_36203;
var inst_36205 = (1);
var state_36281__$1 = (function (){var statearr_36322 = state_36281;
(statearr_36322[(20)] = inst_36205);

(statearr_36322[(11)] = inst_36202);

(statearr_36322[(19)] = inst_36204);

return statearr_36322;
})();
var statearr_36323_36357 = state_36281__$1;
(statearr_36323_36357[(2)] = null);

(statearr_36323_36357[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16153__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16153__auto____0 = (function (){
var statearr_36324 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36324[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16153__auto__);

(statearr_36324[(1)] = (1));

return statearr_36324;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16153__auto____1 = (function (state_36281){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_36281);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e36325){var ex__16156__auto__ = e36325;
var statearr_36326_36358 = state_36281;
(statearr_36326_36358[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_36281[(4)]))){
var statearr_36327_36359 = state_36281;
(statearr_36327_36359[(1)] = cljs.core.first((state_36281[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__36360 = state_36281;
state_36281 = G__36360;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16153__auto__ = function(state_36281){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16153__auto____1.call(this,state_36281);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16153__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16153__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_36328 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_36328[(6)] = c__16227__auto__);

return statearr_36328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__36361,clause,fuel,max_fuel){
var map__36362 = p__36361;
var map__36362__$1 = cljs.core.__destructure_map(map__36362);
var res = map__36362__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36362__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36362__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36362__$1,cljs.core.cst$kw$vars);
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_36473){
var state_val_36474 = (state_36473[(1)]);
if((state_val_36474 === (7))){
var inst_36379 = (state_36473[(7)]);
var state_36473__$1 = state_36473;
var statearr_36475_36528 = state_36473__$1;
(statearr_36475_36528[(2)] = inst_36379);

(statearr_36475_36528[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (20))){
var inst_36407 = (state_36473[(8)]);
var inst_36438 = typeof inst_36407 === 'number';
var state_36473__$1 = state_36473;
if(cljs.core.truth_(inst_36438)){
var statearr_36476_36529 = state_36473__$1;
(statearr_36476_36529[(1)] = (22));

} else {
var statearr_36477_36530 = state_36473__$1;
(statearr_36477_36530[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (27))){
var inst_36453 = (state_36473[(2)]);
var state_36473__$1 = state_36473;
var statearr_36478_36531 = state_36473__$1;
(statearr_36478_36531[(2)] = inst_36453);

(statearr_36478_36531[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (1))){
var state_36473__$1 = state_36473;
var statearr_36479_36532 = state_36473__$1;
(statearr_36479_36532[(2)] = null);

(statearr_36479_36532[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (24))){
var inst_36455 = (state_36473[(2)]);
var state_36473__$1 = state_36473;
var statearr_36480_36533 = state_36473__$1;
(statearr_36480_36533[(2)] = inst_36455);

(statearr_36480_36533[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (4))){
var inst_36363 = (state_36473[(2)]);
var state_36473__$1 = state_36473;
var statearr_36481_36534 = state_36473__$1;
(statearr_36481_36534[(2)] = inst_36363);

(statearr_36481_36534[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (15))){
var inst_36421 = (state_36473[(2)]);
var inst_36422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_36423 = fluree.db.query.analytical.variable_QMARK_(inst_36422);
var state_36473__$1 = (function (){var statearr_36482 = state_36473;
(statearr_36482[(9)] = inst_36421);

return statearr_36482;
})();
if(cljs.core.truth_(inst_36423)){
var statearr_36483_36535 = state_36473__$1;
(statearr_36483_36535[(1)] = (16));

} else {
var statearr_36484_36536 = state_36473__$1;
(statearr_36484_36536[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (21))){
var inst_36410 = (state_36473[(10)]);
var inst_36380 = (state_36473[(11)]);
var inst_36409 = (state_36473[(12)]);
var inst_36457 = (state_36473[(2)]);
var inst_36458 = fluree.db.query.analytical.tuples__GT_recur(db,inst_36410,inst_36457,inst_36380,inst_36409);
var state_36473__$1 = state_36473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36473__$1,(28),inst_36458);
} else {
if((state_val_36474 === (13))){
var inst_36389 = (state_36473[(13)]);
var inst_36413 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36389)].join('');
var inst_36414 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36415 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36416 = cljs.core.PersistentHashMap.fromArrays(inst_36414,inst_36415);
var inst_36417 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36413,inst_36416);
var inst_36418 = (function(){throw inst_36417})();
var state_36473__$1 = state_36473;
var statearr_36485_36537 = state_36473__$1;
(statearr_36485_36537[(2)] = inst_36418);

(statearr_36485_36537[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (22))){
var inst_36405 = (state_36473[(14)]);
var inst_36407 = (state_36473[(8)]);
var inst_36440 = cljs.core.PersistentHashMap.EMPTY;
var inst_36441 = cljs.core.flatten(inst_36405);
var inst_36442 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36440,inst_36407,inst_36441);
var state_36473__$1 = state_36473;
var statearr_36486_36538 = state_36473__$1;
(statearr_36486_36538[(2)] = inst_36442);

(statearr_36486_36538[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (6))){
var inst_36391 = (state_36473[(15)]);
var state_36473__$1 = state_36473;
var statearr_36487_36539 = state_36473__$1;
(statearr_36487_36539[(2)] = inst_36391);

(statearr_36487_36539[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (28))){
var inst_36460 = (state_36473[(2)]);
var inst_36461 = fluree.db.util.async.throw_err(inst_36460);
var state_36473__$1 = state_36473;
var statearr_36488_36540 = state_36473__$1;
(statearr_36488_36540[(2)] = inst_36461);

(statearr_36488_36540[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (25))){
var inst_36405 = (state_36473[(14)]);
var inst_36401 = (state_36473[(16)]);
var inst_36446 = cljs.core.PersistentHashMap.EMPTY;
var inst_36447 = cljs.core.first(inst_36401);
var inst_36448 = cljs.core.first(inst_36447);
var inst_36449 = cljs.core.flatten(inst_36405);
var inst_36450 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36446,inst_36448,inst_36449);
var state_36473__$1 = state_36473;
var statearr_36489_36541 = state_36473__$1;
(statearr_36489_36541[(2)] = inst_36450);

(statearr_36489_36541[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (17))){
var inst_36389 = (state_36473[(13)]);
var inst_36426 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36389)].join('');
var inst_36427 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36428 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36429 = cljs.core.PersistentHashMap.fromArrays(inst_36427,inst_36428);
var inst_36430 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36426,inst_36429);
var inst_36431 = (function(){throw inst_36430})();
var state_36473__$1 = state_36473;
var statearr_36490_36542 = state_36473__$1;
(statearr_36490_36542[(2)] = inst_36431);

(statearr_36490_36542[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (3))){
var inst_36471 = (state_36473[(2)]);
var state_36473__$1 = state_36473;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36473__$1,inst_36471);
} else {
if((state_val_36474 === (12))){
var inst_36376 = (state_36473[(17)]);
var inst_36464 = (state_36473[(2)]);
var inst_36465 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_36466 = cljs.core.keys(inst_36376);
var inst_36467 = [inst_36466,vars,inst_36464];
var inst_36468 = cljs.core.PersistentHashMap.fromArrays(inst_36465,inst_36467);
var _ = (function (){var statearr_36491 = state_36473;
(statearr_36491[(4)] = cljs.core.rest((state_36473[(4)])));

return statearr_36491;
})();
var state_36473__$1 = state_36473;
var statearr_36492_36543 = state_36473__$1;
(statearr_36492_36543[(2)] = inst_36468);

(statearr_36492_36543[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (2))){
var inst_36380 = (state_36473[(11)]);
var inst_36376 = (state_36473[(17)]);
var inst_36379 = (state_36473[(7)]);
var inst_36391 = (state_36473[(15)]);
var _ = (function (){var statearr_36493 = state_36473;
(statearr_36493[(4)] = cljs.core.cons((5),(state_36473[(4)])));

return statearr_36493;
})();
var inst_36373 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_36374 = cljs.core.__destructure_map(inst_36373);
var inst_36375 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36374,cljs.core.cst$kw$search);
var inst_36376__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36374,cljs.core.cst$kw$rel);
var inst_36377 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36374,cljs.core.cst$kw$opts);
var inst_36378 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_36379__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_36377);
var inst_36380__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_36377);
var inst_36382 = (function (){var map__36369 = inst_36374;
var search = inst_36375;
var rel = inst_36376__$1;
var opts = inst_36377;
var common_keys = inst_36378;
var object_fn = inst_36379__$1;
var recur_depth = inst_36380__$1;
return (function (p__36381,common_key){
var vec__36494 = p__36381;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36494,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36494,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__36497 = cljs.core._EQ_;
var expr__36498 = idx_of;
if(cljs.core.truth_((pred__36497.cljs$core$IFn$_invoke$arity$2 ? pred__36497.cljs$core$IFn$_invoke$arity$2((0),expr__36498) : pred__36497.call(null,(0),expr__36498)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__36497.cljs$core$IFn$_invoke$arity$2 ? pred__36497.cljs$core$IFn$_invoke$arity$2((1),expr__36498) : pred__36497.call(null,(1),expr__36498)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__36497.cljs$core$IFn$_invoke$arity$2 ? pred__36497.cljs$core$IFn$_invoke$arity$2((2),expr__36498) : pred__36497.call(null,(2),expr__36498)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__36498)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4221__auto__ = (!(single_v_QMARK_));
if(and__4221__auto__){
var and__4221__auto____$1 = object_fn;
if(cljs.core.truth_(and__4221__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_36383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36384 = cljs.core.PersistentHashMap.EMPTY;
var inst_36385 = [inst_36384,inst_36375];
var inst_36386 = (new cljs.core.PersistentVector(null,2,(5),inst_36383,inst_36385,null));
var inst_36387 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36382,inst_36386,inst_36378);
var inst_36388 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36387,(0),null);
var inst_36389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36387,(1),null);
var inst_36390 = [cljs.core.cst$kw$object_DASH_fn];
var inst_36391__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_36388);
var state_36473__$1 = (function (){var statearr_36500 = state_36473;
(statearr_36500[(18)] = inst_36390);

(statearr_36500[(11)] = inst_36380__$1);

(statearr_36500[(13)] = inst_36389);

(statearr_36500[(17)] = inst_36376__$1);

(statearr_36500[(7)] = inst_36379__$1);

(statearr_36500[(15)] = inst_36391__$1);

return statearr_36500;
})();
if(cljs.core.truth_(inst_36391__$1)){
var statearr_36501_36544 = state_36473__$1;
(statearr_36501_36544[(1)] = (6));

} else {
var statearr_36502_36545 = state_36473__$1;
(statearr_36502_36545[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (23))){
var inst_36407 = (state_36473[(8)]);
var inst_36444 = cljs.core.coll_QMARK_(inst_36407);
var state_36473__$1 = state_36473;
if(inst_36444){
var statearr_36503_36546 = state_36473__$1;
(statearr_36503_36546[(1)] = (25));

} else {
var statearr_36504_36547 = state_36473__$1;
(statearr_36504_36547[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (19))){
var inst_36405 = (state_36473[(14)]);
var inst_36435 = cljs.core.PersistentHashMap.EMPTY;
var inst_36436 = fluree.db.query.analytical.tuples__GT_map(inst_36435,inst_36405);
var state_36473__$1 = state_36473;
var statearr_36505_36548 = state_36473__$1;
(statearr_36505_36548[(2)] = inst_36436);

(statearr_36505_36548[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (11))){
var inst_36405 = (state_36473[(14)]);
var state_36473__$1 = state_36473;
var statearr_36507_36549 = state_36473__$1;
(statearr_36507_36549[(2)] = inst_36405);

(statearr_36507_36549[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (9))){
var inst_36380 = (state_36473[(11)]);
var inst_36376 = (state_36473[(17)]);
var inst_36401 = (state_36473[(16)]);
var inst_36400 = (state_36473[(2)]);
var inst_36401__$1 = fluree.db.util.async.throw_err(inst_36400);
var inst_36402 = cljs.core.count(inst_36401__$1);
var inst_36403 = fluree.db.query.analytical.add_fuel(inst_36402,fuel,max_fuel);
var inst_36404 = cljs.core.vals(inst_36376);
var inst_36405 = fluree.db.query.analytical.get_ns_arrays(inst_36404,inst_36401__$1);
var state_36473__$1 = (function (){var statearr_36508 = state_36473;
(statearr_36508[(19)] = inst_36403);

(statearr_36508[(14)] = inst_36405);

(statearr_36508[(16)] = inst_36401__$1);

return statearr_36508;
})();
if(cljs.core.truth_(inst_36380)){
var statearr_36509_36550 = state_36473__$1;
(statearr_36509_36550[(1)] = (10));

} else {
var statearr_36510_36551 = state_36473__$1;
(statearr_36510_36551[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (5))){
var _ = (function (){var statearr_36511 = state_36473;
(statearr_36511[(4)] = cljs.core.rest((state_36473[(4)])));

return statearr_36511;
})();
var state_36473__$1 = state_36473;
var ex36506 = (state_36473__$1[(2)]);
var statearr_36512_36552 = state_36473__$1;
(statearr_36512_36552[(5)] = ex36506);


if((ex36506 instanceof Error)){
var statearr_36513_36553 = state_36473__$1;
(statearr_36513_36553[(1)] = (4));

(statearr_36513_36553[(5)] = null);

} else {
throw ex36506;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (14))){
var state_36473__$1 = state_36473;
var statearr_36514_36554 = state_36473__$1;
(statearr_36514_36554[(2)] = null);

(statearr_36514_36554[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (26))){
var state_36473__$1 = state_36473;
var statearr_36515_36555 = state_36473__$1;
(statearr_36515_36555[(2)] = null);

(statearr_36515_36555[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (16))){
var state_36473__$1 = state_36473;
var statearr_36516_36556 = state_36473__$1;
(statearr_36516_36556[(2)] = null);

(statearr_36516_36556[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (10))){
var inst_36410 = (state_36473[(10)]);
var inst_36389 = (state_36473[(13)]);
var inst_36407 = cljs.core.first(inst_36389);
var inst_36408 = cljs.core.first(clause);
var inst_36409 = fluree.db.query.analytical.variable_QMARK_(inst_36408);
var inst_36410__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_36389,(1));
var inst_36411 = fluree.db.query.analytical.variable_QMARK_(inst_36410__$1);
var state_36473__$1 = (function (){var statearr_36517 = state_36473;
(statearr_36517[(10)] = inst_36410__$1);

(statearr_36517[(8)] = inst_36407);

(statearr_36517[(12)] = inst_36409);

return statearr_36517;
})();
if(cljs.core.truth_(inst_36411)){
var statearr_36518_36557 = state_36473__$1;
(statearr_36518_36557[(1)] = (13));

} else {
var statearr_36519_36558 = state_36473__$1;
(statearr_36519_36558[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (18))){
var inst_36409 = (state_36473[(12)]);
var inst_36433 = (state_36473[(2)]);
var state_36473__$1 = (function (){var statearr_36520 = state_36473;
(statearr_36520[(20)] = inst_36433);

return statearr_36520;
})();
if(cljs.core.truth_(inst_36409)){
var statearr_36521_36559 = state_36473__$1;
(statearr_36521_36559[(1)] = (19));

} else {
var statearr_36522_36560 = state_36473__$1;
(statearr_36522_36560[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36474 === (8))){
var inst_36390 = (state_36473[(18)]);
var inst_36389 = (state_36473[(13)]);
var inst_36395 = (state_36473[(2)]);
var inst_36396 = [inst_36395];
var inst_36397 = cljs.core.PersistentHashMap.fromArrays(inst_36390,inst_36396);
var inst_36398 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_36389,inst_36397);
var state_36473__$1 = state_36473;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36473__$1,(9),inst_36398);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16153__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16153__auto____0 = (function (){
var statearr_36523 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36523[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16153__auto__);

(statearr_36523[(1)] = (1));

return statearr_36523;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16153__auto____1 = (function (state_36473){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_36473);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e36524){var ex__16156__auto__ = e36524;
var statearr_36525_36561 = state_36473;
(statearr_36525_36561[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_36473[(4)]))){
var statearr_36526_36562 = state_36473;
(statearr_36526_36562[(1)] = cljs.core.first((state_36473[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__36563 = state_36473;
state_36473 = G__36563;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16153__auto__ = function(state_36473){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16153__auto____1.call(this,state_36473);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16153__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16153__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_36527 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_36527[(6)] = c__16227__auto__);

return statearr_36527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__36564,res,clause){
var map__36565 = p__36564;
var map__36565__$1 = cljs.core.__destructure_map(map__36565);
var db = map__36565__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36565__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36565__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36565__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_36664){
var state_val_36665 = (state_36664[(1)]);
if((state_val_36665 === (7))){
var inst_36575 = (state_36664[(7)]);
var state_36664__$1 = state_36664;
var statearr_36666_36706 = state_36664__$1;
(statearr_36666_36706[(2)] = inst_36575);

(statearr_36666_36706[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (20))){
var inst_36655 = (state_36664[(2)]);
var state_36664__$1 = state_36664;
var statearr_36667_36707 = state_36664__$1;
(statearr_36667_36707[(2)] = inst_36655);

(statearr_36667_36707[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (1))){
var state_36664__$1 = state_36664;
var statearr_36668_36708 = state_36664__$1;
(statearr_36668_36708[(2)] = null);

(statearr_36668_36708[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (24))){
var inst_36634 = (state_36664[(2)]);
var inst_36635 = fluree.db.util.async.throw_err(inst_36634);
var state_36664__$1 = state_36664;
var statearr_36669_36709 = state_36664__$1;
(statearr_36669_36709[(2)] = inst_36635);

(statearr_36669_36709[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (4))){
var inst_36568 = (state_36664[(2)]);
var state_36664__$1 = state_36664;
var statearr_36670_36710 = state_36664__$1;
(statearr_36670_36710[(2)] = inst_36568);

(statearr_36670_36710[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (15))){
var inst_36577 = (state_36664[(8)]);
var inst_36575 = (state_36664[(7)]);
var inst_36596 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_36597 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_36598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36599 = [inst_36575];
var inst_36600 = (new cljs.core.PersistentVector(null,1,(5),inst_36598,inst_36599,null));
var inst_36601 = (function (){var subject_var = inst_36575;
var object_var = inst_36577;
var min_sid = inst_36596;
var max_sid = (0);
return (function (p1__36566_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__36566_SHARP_);
});
})();
var inst_36602 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_36596,(0));
var inst_36603 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_36601,inst_36602);
var inst_36604 = cljs.core.PersistentHashMap.EMPTY;
var inst_36605 = [inst_36600,inst_36603,inst_36604];
var inst_36606 = cljs.core.PersistentHashMap.fromArrays(inst_36597,inst_36605);
var state_36664__$1 = state_36664;
var statearr_36671_36711 = state_36664__$1;
(statearr_36671_36711[(2)] = inst_36606);

(statearr_36671_36711[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (21))){
var inst_36628 = (state_36664[(9)]);
var state_36664__$1 = state_36664;
var statearr_36672_36712 = state_36664__$1;
(statearr_36672_36712[(2)] = inst_36628);

(statearr_36672_36712[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (13))){
var inst_36577 = (state_36664[(8)]);
var state_36664__$1 = state_36664;
if(cljs.core.truth_(inst_36577)){
var statearr_36673_36713 = state_36664__$1;
(statearr_36673_36713[(1)] = (18));

} else {
var statearr_36674_36714 = state_36664__$1;
(statearr_36674_36714[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (22))){
var inst_36628 = (state_36664[(9)]);
var inst_36632 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_36628);
var state_36664__$1 = state_36664;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36664__$1,(24),inst_36632);
} else {
if((state_val_36665 === (6))){
var inst_36577 = (state_36664[(8)]);
var state_36664__$1 = state_36664;
var statearr_36675_36715 = state_36664__$1;
(statearr_36675_36715[(2)] = inst_36577);

(statearr_36675_36715[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (17))){
var inst_36625 = (state_36664[(2)]);
var state_36664__$1 = state_36664;
var statearr_36676_36716 = state_36664__$1;
(statearr_36676_36716[(2)] = inst_36625);

(statearr_36676_36716[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (3))){
var inst_36662 = (state_36664[(2)]);
var state_36664__$1 = state_36664;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36664__$1,inst_36662);
} else {
if((state_val_36665 === (12))){
var inst_36590 = ["_tx",null,"_block",null];
var inst_36591 = (new cljs.core.PersistentArrayMap(null,2,inst_36590,null));
var inst_36592 = (new cljs.core.PersistentHashSet(null,inst_36591,null));
var inst_36593 = cljs.core.last(clause);
var inst_36594 = (inst_36592.cljs$core$IFn$_invoke$arity$1 ? inst_36592.cljs$core$IFn$_invoke$arity$1(inst_36593) : inst_36592.call(null,inst_36593));
var state_36664__$1 = state_36664;
if(cljs.core.truth_(inst_36594)){
var statearr_36677_36717 = state_36664__$1;
(statearr_36677_36717[(1)] = (15));

} else {
var statearr_36678_36718 = state_36664__$1;
(statearr_36678_36718[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (2))){
var inst_36575 = (state_36664[(7)]);
var _ = (function (){var statearr_36679 = state_36664;
(statearr_36679[(4)] = cljs.core.cons((5),(state_36664[(4)])));

return statearr_36679;
})();
var inst_36574 = cljs.core.first(clause);
var inst_36575__$1 = fluree.db.query.analytical.variable_QMARK_(inst_36574);
var inst_36576 = cljs.core.last(clause);
var inst_36577 = fluree.db.query.analytical.variable_QMARK_(inst_36576);
var state_36664__$1 = (function (){var statearr_36680 = state_36664;
(statearr_36680[(8)] = inst_36577);

(statearr_36680[(7)] = inst_36575__$1);

return statearr_36680;
})();
if(cljs.core.truth_(inst_36575__$1)){
var statearr_36681_36719 = state_36664__$1;
(statearr_36681_36719[(1)] = (6));

} else {
var statearr_36682_36720 = state_36664__$1;
(statearr_36682_36720[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (23))){
var inst_36577 = (state_36664[(8)]);
var inst_36637 = (state_36664[(2)]);
var inst_36638 = fluree.db.flake.sid__GT_cid(inst_36637);
var inst_36639 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_36638);
var inst_36640 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_36641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36642 = [inst_36577];
var inst_36643 = (new cljs.core.PersistentVector(null,1,(5),inst_36641,inst_36642,null));
var inst_36644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36646 = [inst_36639];
var inst_36647 = (new cljs.core.PersistentVector(null,1,(5),inst_36645,inst_36646,null));
var inst_36648 = [inst_36647];
var inst_36649 = (new cljs.core.PersistentVector(null,1,(5),inst_36644,inst_36648,null));
var inst_36650 = cljs.core.PersistentHashMap.EMPTY;
var inst_36651 = [inst_36643,inst_36649,inst_36650];
var inst_36652 = cljs.core.PersistentHashMap.fromArrays(inst_36640,inst_36651);
var state_36664__$1 = state_36664;
var statearr_36683_36721 = state_36664__$1;
(statearr_36683_36721[(2)] = inst_36652);

(statearr_36683_36721[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (19))){
var state_36664__$1 = state_36664;
var statearr_36684_36722 = state_36664__$1;
(statearr_36684_36722[(2)] = null);

(statearr_36684_36722[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (11))){
var inst_36659 = (state_36664[(2)]);
var _ = (function (){var statearr_36686 = state_36664;
(statearr_36686[(4)] = cljs.core.rest((state_36664[(4)])));

return statearr_36686;
})();
var state_36664__$1 = state_36664;
var statearr_36687_36723 = state_36664__$1;
(statearr_36687_36723[(2)] = inst_36659);

(statearr_36687_36723[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (9))){
var inst_36583 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36584 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36585 = cljs.core.PersistentHashMap.fromArrays(inst_36583,inst_36584);
var inst_36586 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_36585);
var inst_36587 = (function(){throw inst_36586})();
var state_36664__$1 = state_36664;
var statearr_36688_36724 = state_36664__$1;
(statearr_36688_36724[(2)] = inst_36587);

(statearr_36688_36724[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (5))){
var _ = (function (){var statearr_36689 = state_36664;
(statearr_36689[(4)] = cljs.core.rest((state_36664[(4)])));

return statearr_36689;
})();
var state_36664__$1 = state_36664;
var ex36685 = (state_36664__$1[(2)]);
var statearr_36690_36725 = state_36664__$1;
(statearr_36690_36725[(5)] = ex36685);


if((ex36685 instanceof Error)){
var statearr_36691_36726 = state_36664__$1;
(statearr_36691_36726[(1)] = (4));

(statearr_36691_36726[(5)] = null);

} else {
throw ex36685;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (14))){
var inst_36657 = (state_36664[(2)]);
var state_36664__$1 = state_36664;
var statearr_36692_36727 = state_36664__$1;
(statearr_36692_36727[(2)] = inst_36657);

(statearr_36692_36727[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (16))){
var inst_36577 = (state_36664[(8)]);
var inst_36575 = (state_36664[(7)]);
var inst_36608 = cljs.core.last(clause);
var inst_36609 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,inst_36608);
var inst_36610 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_36611 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36610,inst_36609);
var inst_36612 = fluree.db.flake.min_subject_id(inst_36609);
var inst_36613 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_36614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36615 = [inst_36575];
var inst_36616 = (new cljs.core.PersistentVector(null,1,(5),inst_36614,inst_36615,null));
var inst_36617 = (function (){var subject_var = inst_36575;
var object_var = inst_36577;
var partition = inst_36609;
var max_sid = inst_36611;
var min_sid = inst_36612;
return (function (p1__36567_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__36567_SHARP_);
});
})();
var inst_36618 = (inst_36611 + (1));
var inst_36619 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_36612,inst_36618);
var inst_36620 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_36617,inst_36619);
var inst_36621 = cljs.core.PersistentHashMap.EMPTY;
var inst_36622 = [inst_36616,inst_36620,inst_36621];
var inst_36623 = cljs.core.PersistentHashMap.fromArrays(inst_36613,inst_36622);
var state_36664__$1 = state_36664;
var statearr_36693_36728 = state_36664__$1;
(statearr_36693_36728[(2)] = inst_36623);

(statearr_36693_36728[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (10))){
var inst_36575 = (state_36664[(7)]);
var state_36664__$1 = state_36664;
if(cljs.core.truth_(inst_36575)){
var statearr_36694_36729 = state_36664__$1;
(statearr_36694_36729[(1)] = (12));

} else {
var statearr_36695_36730 = state_36664__$1;
(statearr_36695_36730[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (18))){
var inst_36628 = (state_36664[(9)]);
var inst_36628__$1 = cljs.core.first(clause);
var inst_36629 = typeof inst_36628__$1 === 'number';
var state_36664__$1 = (function (){var statearr_36696 = state_36664;
(statearr_36696[(9)] = inst_36628__$1);

return statearr_36696;
})();
if(cljs.core.truth_(inst_36629)){
var statearr_36697_36731 = state_36664__$1;
(statearr_36697_36731[(1)] = (21));

} else {
var statearr_36698_36732 = state_36664__$1;
(statearr_36698_36732[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36665 === (8))){
var inst_36581 = (state_36664[(2)]);
var state_36664__$1 = state_36664;
if(cljs.core.truth_(inst_36581)){
var statearr_36699_36733 = state_36664__$1;
(statearr_36699_36733[(1)] = (9));

} else {
var statearr_36700_36734 = state_36664__$1;
(statearr_36700_36734[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16153__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16153__auto____0 = (function (){
var statearr_36701 = [null,null,null,null,null,null,null,null,null,null];
(statearr_36701[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16153__auto__);

(statearr_36701[(1)] = (1));

return statearr_36701;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16153__auto____1 = (function (state_36664){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_36664);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e36702){var ex__16156__auto__ = e36702;
var statearr_36703_36735 = state_36664;
(statearr_36703_36735[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_36664[(4)]))){
var statearr_36704_36736 = state_36664;
(statearr_36704_36736[(1)] = cljs.core.first((state_36664[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__36737 = state_36664;
state_36664 = G__36737;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16153__auto__ = function(state_36664){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16153__auto____1.call(this,state_36664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16153__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16153__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_36705 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_36705[(6)] = c__16227__auto__);

return statearr_36705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__36744 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__36744 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__36744;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4622__auto__ = (function fluree$db$query$analytical$variance_$_iter__36745(s__36746){
return (new cljs.core.LazySeq(null,(function (){
var s__36746__$1 = s__36746;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__36746__$1);
if(temp__5753__auto__){
var s__36746__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36746__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__36746__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__36748 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__36747 = (0);
while(true){
if((i__36747 < size__4621__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__36747);
var delta = (x - mean);
cljs.core.chunk_append(b__36748,(delta * delta));

var G__36750 = (i__36747 + (1));
i__36747 = G__36750;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36748),fluree$db$query$analytical$variance_$_iter__36745(cljs.core.chunk_rest(s__36746__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36748),null);
}
} else {
var x = cljs.core.first(s__36746__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__36745(cljs.core.rest(s__36746__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__36749 = variance(coll);
return Math.sqrt(G__36749);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4306__auto__ = n;
var y__4307__auto__ = (- n);
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
}),(function() {
var G__36751 = null;
var G__36751__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__36751__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__36751 = function(n,coll){
switch(arguments.length){
case 1:
return G__36751__1.call(this,n);
case 2:
return G__36751__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36751.cljs$core$IFn$_invoke$arity$1 = G__36751__1;
G__36751.cljs$core$IFn$_invoke$arity$2 = G__36751__2;
return G__36751;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__36752 = null;
var G__36752__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__36752__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__36752 = function(n,coll){
switch(arguments.length){
case 1:
return G__36752__1.call(this,n);
case 2:
return G__36752__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36752.cljs$core$IFn$_invoke$arity$1 = G__36752__1;
G__36752.cljs$core$IFn$_invoke$arity$2 = G__36752__2;
return G__36752;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__36753 = null;
var G__36753__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__36753__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__36753 = function(n,coll){
switch(arguments.length){
case 1:
return G__36753__1.call(this,n);
case 2:
return G__36753__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36753.cljs$core$IFn$_invoke$arity$1 = G__36753__1;
G__36753.cljs$core$IFn$_invoke$arity$2 = G__36753__2;
return G__36753;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4221__auto__ = typeof x === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4221__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__36754 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36754,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36754,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36754,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__36757 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__36760 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__36760) : agg_fn.call(null,G__36760));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36757,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36757,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__36761 = agg;
var map__36761__$1 = cljs.core.__destructure_map(map__36761);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36761__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36761__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36761__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__36763 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36763,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36763,(1),null);
var map__36766 = res__$1;
var map__36766__$1 = cljs.core.__destructure_map(map__36766);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36766__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36766__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36762_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__36762_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36767_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__36767_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36768_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__36768_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__36769_SHARP_,p2__36770_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__36769_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__36770_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36771_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__36771_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__36774,row,b_tuple){
var vec__36775 = p__36774;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36775,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36775,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36772_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__36772_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = acc;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36773_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__36773_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36778_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__36778_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36779_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__36779_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__36784 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__36786 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__36785 = (function (p1__36780_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__36780_SHARP_);
});
return fexpr__36785(G__36786);
})()),cljs.core.set(b_idxs));
var fexpr__36783 = (function (p1__36781_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__36781_SHARP_);
});
return fexpr__36783(G__36784);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36782_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__36782_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36787_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__36787_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36788_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__36788_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__36793 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__36795 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__36794 = (function (p1__36789_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__36789_SHARP_);
});
return fexpr__36794(G__36795);
})()),cljs.core.set(b_idxs));
var fexpr__36792 = (function (p1__36790_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__36790_SHARP_);
});
return fexpr__36792(G__36793);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36791_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__36791_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36796_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__36796_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36797_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__36797_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__36806 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__36808 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__36807 = (function (p1__36798_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__36798_SHARP_);
});
return fexpr__36807(G__36808);
})()),cljs.core.set(b_idxs));
var fexpr__36805 = (function (p1__36799_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__36799_SHARP_);
});
return fexpr__36805(G__36806);
})();
var vec__36802 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__36809,a_tuple){
var vec__36810 = p__36809;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36810,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36810,(1),null);
var vec__36813 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36813,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36813,(1),null);
var matches__$1 = (function (){var or__4223__auto__ = matches;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(c_tuples),matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36802,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36802,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36800_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__36800_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36801_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__36801_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__36817 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36817,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36817,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__36816_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__36816_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__36822 = (function (){var or__4223__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36822,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36822,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36820_SHARP_){
return fluree.db.util.core.index_of(headers,p1__36820_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__36821_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__36821_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__36825,filters,optional_QMARK_){
var map__36826 = p__36825;
var map__36826__$1 = cljs.core.__destructure_map(map__36826);
var tuple_map = map__36826__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36826__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36826__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36826__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__36827 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36827,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36827,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__36830 = res;
var map__36830__$1 = cljs.core.__destructure_map(map__36830);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36830__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36830__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_36886){
var state_val_36887 = (state_36886[(1)]);
if((state_val_36887 === (7))){
var inst_36860 = (state_36886[(7)]);
var inst_36858 = (state_36886[(2)]);
var inst_36859 = fluree.db.util.async.throw_err(inst_36858);
var inst_36860__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36859,(0),null);
var inst_36861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36859,(1),null);
var inst_36862 = (inst_36860__$1 == null);
var state_36886__$1 = (function (){var statearr_36888 = state_36886;
(statearr_36888[(8)] = inst_36861);

(statearr_36888[(7)] = inst_36860__$1);

return statearr_36888;
})();
if(cljs.core.truth_(inst_36862)){
var statearr_36889_36918 = state_36886__$1;
(statearr_36889_36918[(1)] = (8));

} else {
var statearr_36890_36919 = state_36886__$1;
(statearr_36890_36919[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (1))){
var inst_36838 = optional_clauses;
var inst_36839 = cljs.core.seq(inst_36838);
var inst_36840 = cljs.core.first(inst_36839);
var inst_36841 = cljs.core.next(inst_36839);
var inst_36842 = where_tuples;
var inst_36843 = inst_36838;
var inst_36844 = inst_36842;
var state_36886__$1 = (function (){var statearr_36891 = state_36886;
(statearr_36891[(9)] = inst_36840);

(statearr_36891[(10)] = inst_36843);

(statearr_36891[(11)] = inst_36841);

(statearr_36891[(12)] = inst_36844);

return statearr_36891;
})();
var statearr_36892_36920 = state_36886__$1;
(statearr_36892_36920[(2)] = null);

(statearr_36892_36920[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (4))){
var inst_36851 = (state_36886[(13)]);
var inst_36850 = (state_36886[(14)]);
var inst_36844 = (state_36886[(12)]);
var inst_36856 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_36844,inst_36850,inst_36851,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_36844,inst_36850,inst_36851,true,fuel,max_fuel,opts));
var state_36886__$1 = state_36886;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36886__$1,(7),inst_36856);
} else {
if((state_val_36887 === (15))){
var state_36886__$1 = state_36886;
var statearr_36893_36921 = state_36886__$1;
(statearr_36893_36921[(2)] = null);

(statearr_36893_36921[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (13))){
var inst_36877 = (state_36886[(2)]);
var state_36886__$1 = state_36886;
var statearr_36894_36922 = state_36886__$1;
(statearr_36894_36922[(2)] = inst_36877);

(statearr_36894_36922[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (6))){
var inst_36882 = (state_36886[(2)]);
var state_36886__$1 = state_36886;
var statearr_36895_36923 = state_36886__$1;
(statearr_36895_36923[(2)] = inst_36882);

(statearr_36895_36923[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (3))){
var inst_36884 = (state_36886[(2)]);
var state_36886__$1 = state_36886;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36886__$1,inst_36884);
} else {
if((state_val_36887 === (12))){
var state_36886__$1 = state_36886;
var statearr_36896_36924 = state_36886__$1;
(statearr_36896_36924[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (2))){
var inst_36843 = (state_36886[(10)]);
var inst_36850 = (state_36886[(14)]);
var inst_36849 = cljs.core.seq(inst_36843);
var inst_36850__$1 = cljs.core.first(inst_36849);
var inst_36851 = cljs.core.next(inst_36849);
var state_36886__$1 = (function (){var statearr_36898 = state_36886;
(statearr_36898[(13)] = inst_36851);

(statearr_36898[(14)] = inst_36850__$1);

return statearr_36898;
})();
if(cljs.core.truth_(inst_36850__$1)){
var statearr_36899_36925 = state_36886__$1;
(statearr_36899_36925[(1)] = (4));

} else {
var statearr_36900_36926 = state_36886__$1;
(statearr_36900_36926[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (11))){
var inst_36861 = (state_36886[(8)]);
var inst_36860 = (state_36886[(7)]);
var inst_36843 = inst_36861;
var inst_36844 = inst_36860;
var state_36886__$1 = (function (){var statearr_36901 = state_36886;
(statearr_36901[(10)] = inst_36843);

(statearr_36901[(12)] = inst_36844);

return statearr_36901;
})();
var statearr_36902_36927 = state_36886__$1;
(statearr_36902_36927[(2)] = null);

(statearr_36902_36927[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (9))){
var inst_36850 = (state_36886[(14)]);
var inst_36866 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_36850);
var state_36886__$1 = state_36886;
if(cljs.core.truth_(inst_36866)){
var statearr_36903_36928 = state_36886__$1;
(statearr_36903_36928[(1)] = (11));

} else {
var statearr_36904_36929 = state_36886__$1;
(statearr_36904_36929[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (5))){
var inst_36844 = (state_36886[(12)]);
var state_36886__$1 = state_36886;
var statearr_36905_36930 = state_36886__$1;
(statearr_36905_36930[(2)] = inst_36844);

(statearr_36905_36930[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (14))){
var inst_36861 = (state_36886[(8)]);
var inst_36844 = (state_36886[(12)]);
var inst_36860 = (state_36886[(7)]);
var inst_36871 = fluree.db.query.analytical.left_outer_join(inst_36844,inst_36860);
var inst_36843 = inst_36861;
var inst_36844__$1 = inst_36871;
var state_36886__$1 = (function (){var statearr_36906 = state_36886;
(statearr_36906[(10)] = inst_36843);

(statearr_36906[(12)] = inst_36844__$1);

return statearr_36906;
})();
var statearr_36907_36931 = state_36886__$1;
(statearr_36907_36931[(2)] = null);

(statearr_36907_36931[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (16))){
var inst_36875 = (state_36886[(2)]);
var state_36886__$1 = state_36886;
var statearr_36909_36932 = state_36886__$1;
(statearr_36909_36932[(2)] = inst_36875);

(statearr_36909_36932[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (10))){
var inst_36879 = (state_36886[(2)]);
var state_36886__$1 = state_36886;
var statearr_36910_36933 = state_36886__$1;
(statearr_36910_36933[(2)] = inst_36879);

(statearr_36910_36933[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36887 === (8))){
var inst_36861 = (state_36886[(8)]);
var inst_36844 = (state_36886[(12)]);
var tmp36908 = inst_36844;
var inst_36843 = inst_36861;
var inst_36844__$1 = tmp36908;
var state_36886__$1 = (function (){var statearr_36911 = state_36886;
(statearr_36911[(10)] = inst_36843);

(statearr_36911[(12)] = inst_36844__$1);

return statearr_36911;
})();
var statearr_36912_36934 = state_36886__$1;
(statearr_36912_36934[(2)] = null);

(statearr_36912_36934[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16153__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16153__auto____0 = (function (){
var statearr_36913 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36913[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16153__auto__);

(statearr_36913[(1)] = (1));

return statearr_36913;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16153__auto____1 = (function (state_36886){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_36886);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e36914){var ex__16156__auto__ = e36914;
var statearr_36915_36935 = state_36886;
(statearr_36915_36935[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_36886[(4)]))){
var statearr_36916_36936 = state_36886;
(statearr_36916_36936[(1)] = cljs.core.first((state_36886[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__36937 = state_36886;
state_36886 = G__36937;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16153__auto__ = function(state_36886){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16153__auto____1.call(this,state_36886);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16153__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16153__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_36917 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_36917[(6)] = c__16227__auto__);

return statearr_36917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__36939){
var vec__36940 = p__36939;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36940,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36940,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36938_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__36938_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__36944,p__36945,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__36946 = p__36944;
var map__36946__$1 = cljs.core.__destructure_map(map__36946);
var q_map = map__36946__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36946__$1,cljs.core.cst$kw$prefixes);
var map__36947 = p__36945;
var map__36947__$1 = cljs.core.__destructure_map(map__36947);
var res = map__36947__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36947__$1,cljs.core.cst$kw$vars);
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_37160){
var state_val_37161 = (state_37160[(1)]);
if((state_val_37161 === (65))){
var inst_37129 = (state_37160[(7)]);
var inst_37132 = (state_37160[(2)]);
var inst_37133 = fluree.db.util.async.throw_err(inst_37132);
var inst_37134 = [inst_37133,r];
var inst_37135 = (new cljs.core.PersistentVector(null,2,(5),inst_37129,inst_37134,null));
var state_37160__$1 = state_37160;
var statearr_37162_37267 = state_37160__$1;
(statearr_37162_37267[(2)] = inst_37135);

(statearr_37162_37267[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (62))){
var inst_37112 = (state_37160[(8)]);
var inst_37111 = (state_37160[(9)]);
var inst_37129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37130 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_37111,res,inst_37112,fuel,max_fuel);
var state_37160__$1 = (function (){var statearr_37163 = state_37160;
(statearr_37163[(7)] = inst_37129);

return statearr_37163;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37160__$1,(65),inst_37130);
} else {
if((state_val_37161 === (7))){
var inst_37053 = (state_37160[(10)]);
var inst_37052 = cljs.core.count(clause);
var inst_37053__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_37052);
var state_37160__$1 = (function (){var statearr_37164 = state_37160;
(statearr_37164[(10)] = inst_37053__$1);

return statearr_37164;
})();
if(inst_37053__$1){
var statearr_37165_37268 = state_37160__$1;
(statearr_37165_37268[(1)] = (31));

} else {
var statearr_37166_37269 = state_37160__$1;
(statearr_37166_37269[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (59))){
var inst_37112 = (state_37160[(8)]);
var inst_37111 = (state_37160[(9)]);
var inst_37123 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37124 = fluree.db.query.analytical.full_text__GT_tuples(inst_37111,res,inst_37112);
var inst_37125 = [inst_37124,r];
var inst_37126 = (new cljs.core.PersistentVector(null,2,(5),inst_37123,inst_37125,null));
var state_37160__$1 = state_37160;
var statearr_37167_37270 = state_37160__$1;
(statearr_37167_37270[(2)] = inst_37126);

(statearr_37167_37270[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (20))){
var inst_37016 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37168_37271 = state_37160__$1;
(statearr_37168_37271[(2)] = inst_37016);

(statearr_37168_37271[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (58))){
var inst_37117 = (state_37160[(2)]);
var inst_37118 = fluree.db.util.async.throw_err(inst_37117);
var state_37160__$1 = state_37160;
var statearr_37169_37272 = state_37160__$1;
(statearr_37169_37272[(2)] = inst_37118);

(statearr_37169_37272[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (60))){
var state_37160__$1 = state_37160;
var statearr_37170_37273 = state_37160__$1;
(statearr_37170_37273[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (27))){
var inst_37046 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37172_37274 = state_37160__$1;
(statearr_37172_37274[(2)] = inst_37046);

(statearr_37172_37274[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (1))){
var state_37160__$1 = state_37160;
var statearr_37173_37275 = state_37160__$1;
(statearr_37173_37275[(2)] = null);

(statearr_37173_37275[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (24))){
var inst_37010 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37174_37276 = state_37160__$1;
(statearr_37174_37276[(2)] = inst_37010);

(statearr_37174_37276[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (55))){
var inst_37112 = (state_37160[(8)]);
var inst_37115 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_37112,r,res,optional_QMARK_,fuel,max_fuel);
var state_37160__$1 = state_37160;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37160__$1,(58),inst_37115);
} else {
if((state_val_37161 === (39))){
var inst_37073 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
if(cljs.core.truth_(inst_37073)){
var statearr_37175_37277 = state_37160__$1;
(statearr_37175_37277[(1)] = (40));

} else {
var statearr_37176_37278 = state_37160__$1;
(statearr_37176_37278[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (46))){
var inst_37149 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37177_37279 = state_37160__$1;
(statearr_37177_37279[(2)] = inst_37149);

(statearr_37177_37279[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (4))){
var inst_36948 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37178_37280 = state_37160__$1;
(statearr_37178_37280[(2)] = inst_36948);

(statearr_37178_37280[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (54))){
var inst_37111 = (state_37160[(9)]);
var inst_37109 = (state_37160[(2)]);
var inst_37110 = fluree.db.util.async.throw_err(inst_37109);
var inst_37111__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37110,(0),null);
var inst_37112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37110,(1),null);
var inst_37113 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_37111__$1);
var state_37160__$1 = (function (){var statearr_37179 = state_37160;
(statearr_37179[(8)] = inst_37112);

(statearr_37179[(9)] = inst_37111__$1);

return statearr_37179;
})();
if(inst_37113){
var statearr_37180_37281 = state_37160__$1;
(statearr_37180_37281[(1)] = (55));

} else {
var statearr_37181_37282 = state_37160__$1;
(statearr_37181_37282[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (15))){
var inst_37048 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37182_37283 = state_37160__$1;
(statearr_37182_37283[(2)] = inst_37048);

(statearr_37182_37283[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (48))){
var inst_37097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37098 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_37099 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_37098);
var inst_37100 = [inst_37099,r];
var inst_37101 = (new cljs.core.PersistentVector(null,2,(5),inst_37097,inst_37100,null));
var state_37160__$1 = state_37160;
var statearr_37183_37284 = state_37160__$1;
(statearr_37183_37284[(2)] = inst_37101);

(statearr_37183_37284[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (50))){
var inst_37147 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37184_37285 = state_37160__$1;
(statearr_37184_37285[(2)] = inst_37147);

(statearr_37184_37285[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (21))){
var inst_36984 = (state_37160[(11)]);
var inst_36985 = (state_37160[(12)]);
var inst_36961 = (state_37160[(13)]);
var inst_36993 = (state_37160[(14)]);
var inst_36982 = (state_37160[(15)]);
var inst_36987 = (state_37160[(16)]);
var inst_36957 = (state_37160[(17)]);
var inst_36986 = (state_37160[(18)]);
var inst_36994 = (state_37160[(19)]);
var inst_36998 = (state_37160[(2)]);
var inst_36999 = fluree.db.util.async.throw_err(inst_36998);
var inst_37000 = (function (){var new_res = inst_36999;
var rest = inst_36994;
var first__36991 = inst_36993;
var tuples = inst_36987;
var seq__36990 = inst_36994;
var pred__36958 = inst_36961;
var first__36981 = inst_36984;
var expr__36959 = inst_36957;
var seq__36980 = inst_36985;
var vec__36979 = inst_36982;
var vec__36989 = inst_36986;
var G__36978 = inst_36986;
var segment_type = inst_36957;
var clause_group = inst_36993;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_37001 = cljs.core.keys(vars);
var inst_37002 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_37000,inst_36999,inst_37001);
var inst_37003 = fluree.db.query.analytical.res_absorb_vars(inst_37002);
var state_37160__$1 = (function (){var statearr_37185 = state_37160;
(statearr_37185[(20)] = inst_37003);

return statearr_37185;
})();
if(cljs.core.truth_(inst_36987)){
var statearr_37186_37286 = state_37160__$1;
(statearr_37186_37286[(1)] = (22));

} else {
var statearr_37187_37287 = state_37160__$1;
(statearr_37187_37287[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (31))){
var inst_37055 = cljs.core.second(clause);
var inst_37056 = clojure.string.starts_with_QMARK_(inst_37055,"fullText:");
var state_37160__$1 = state_37160;
var statearr_37188_37288 = state_37160__$1;
(statearr_37188_37288[(2)] = inst_37056);

(statearr_37188_37288[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (32))){
var inst_37053 = (state_37160[(10)]);
var state_37160__$1 = state_37160;
var statearr_37189_37289 = state_37160__$1;
(statearr_37189_37289[(2)] = inst_37053);

(statearr_37189_37289[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (40))){
var inst_37075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37076 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_37160__$1 = (function (){var statearr_37190 = state_37160;
(statearr_37190[(21)] = inst_37075);

return statearr_37190;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37160__$1,(43),inst_37076);
} else {
if((state_val_37161 === (56))){
var inst_37112 = (state_37160[(8)]);
var inst_37120 = cljs.core.second(inst_37112);
var inst_37121 = clojure.string.starts_with_QMARK_(inst_37120,"fullText:");
var state_37160__$1 = state_37160;
if(inst_37121){
var statearr_37191_37290 = state_37160__$1;
(statearr_37191_37290[(1)] = (59));

} else {
var statearr_37192_37291 = state_37160__$1;
(statearr_37192_37291[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (33))){
var inst_37059 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
if(cljs.core.truth_(inst_37059)){
var statearr_37193_37292 = state_37160__$1;
(statearr_37193_37292[(1)] = (34));

} else {
var statearr_37194_37293 = state_37160__$1;
(statearr_37194_37293[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (13))){
var inst_36982 = (state_37160[(15)]);
var inst_36982__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_36983 = cljs.core.seq(inst_36982__$1);
var inst_36984 = cljs.core.first(inst_36983);
var inst_36985 = cljs.core.next(inst_36983);
var inst_36986 = inst_36982__$1;
var inst_36987 = null;
var state_37160__$1 = (function (){var statearr_37195 = state_37160;
(statearr_37195[(11)] = inst_36984);

(statearr_37195[(12)] = inst_36985);

(statearr_37195[(15)] = inst_36982__$1);

(statearr_37195[(16)] = inst_36987);

(statearr_37195[(18)] = inst_36986);

return statearr_37195;
})();
var statearr_37196_37294 = state_37160__$1;
(statearr_37196_37294[(2)] = null);

(statearr_37196_37294[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (22))){
var inst_36987 = (state_37160[(16)]);
var inst_36994 = (state_37160[(19)]);
var inst_37003 = (state_37160[(20)]);
var inst_37005 = fluree.db.query.analytical.outer_union(inst_36987,inst_37003);
var inst_36986 = inst_36994;
var inst_36987__$1 = inst_37005;
var state_37160__$1 = (function (){var statearr_37197 = state_37160;
(statearr_37197[(16)] = inst_36987__$1);

(statearr_37197[(18)] = inst_36986);

return statearr_37197;
})();
var statearr_37198_37295 = state_37160__$1;
(statearr_37198_37295[(2)] = null);

(statearr_37198_37295[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (36))){
var inst_37153 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37199_37296 = state_37160__$1;
(statearr_37199_37296[(2)] = inst_37153);

(statearr_37199_37296[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (41))){
var inst_37083 = cljs.core.count(clause);
var inst_37084 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_37083);
var state_37160__$1 = state_37160;
if(inst_37084){
var statearr_37200_37297 = state_37160__$1;
(statearr_37200_37297[(1)] = (44));

} else {
var statearr_37201_37298 = state_37160__$1;
(statearr_37201_37298[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (43))){
var inst_37075 = (state_37160[(21)]);
var inst_37078 = (state_37160[(2)]);
var inst_37079 = fluree.db.util.async.throw_err(inst_37078);
var inst_37080 = [inst_37079,r];
var inst_37081 = (new cljs.core.PersistentVector(null,2,(5),inst_37075,inst_37080,null));
var state_37160__$1 = state_37160;
var statearr_37202_37299 = state_37160__$1;
(statearr_37202_37299[(2)] = inst_37081);

(statearr_37202_37299[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (61))){
var inst_37140 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37203_37300 = state_37160__$1;
(statearr_37203_37300[(2)] = inst_37140);

(statearr_37203_37300[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (29))){
var inst_36957 = (state_37160[(17)]);
var inst_37040 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36957)].join('');
var inst_37041 = (new Error(inst_37040));
var inst_37042 = (function(){throw inst_37041})();
var state_37160__$1 = state_37160;
var statearr_37204_37301 = state_37160__$1;
(statearr_37204_37301[(2)] = inst_37042);

(statearr_37204_37301[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (44))){
var inst_37086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37087 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_37160__$1 = (function (){var statearr_37205 = state_37160;
(statearr_37205[(22)] = inst_37086);

return statearr_37205;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37160__$1,(47),inst_37087);
} else {
if((state_val_37161 === (6))){
var inst_36961 = (state_37160[(13)]);
var inst_36957 = (state_37160[(17)]);
var inst_36956 = cljs.core.keys(clause);
var inst_36957__$1 = cljs.core.first(inst_36956);
var inst_36961__$1 = cljs.core._EQ_;
var inst_36962 = (function (){var G__37206 = cljs.core.cst$kw$optional;
var G__37207 = inst_36957__$1;
return (inst_36961__$1.cljs$core$IFn$_invoke$arity$2 ? inst_36961__$1.cljs$core$IFn$_invoke$arity$2(G__37206,G__37207) : inst_36961__$1.call(null,G__37206,G__37207));
})();
var state_37160__$1 = (function (){var statearr_37208 = state_37160;
(statearr_37208[(13)] = inst_36961__$1);

(statearr_37208[(17)] = inst_36957__$1);

return statearr_37208;
})();
if(cljs.core.truth_(inst_36962)){
var statearr_37209_37302 = state_37160__$1;
(statearr_37209_37302[(1)] = (9));

} else {
var statearr_37210_37303 = state_37160__$1;
(statearr_37210_37303[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (28))){
var inst_37034 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37035 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_37036 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_37035,optional_QMARK_);
var inst_37037 = [inst_37036,r];
var inst_37038 = (new cljs.core.PersistentVector(null,2,(5),inst_37034,inst_37037,null));
var state_37160__$1 = state_37160;
var statearr_37211_37304 = state_37160__$1;
(statearr_37211_37304[(2)] = inst_37038);

(statearr_37211_37304[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (64))){
var inst_37138 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37212_37305 = state_37160__$1;
(statearr_37212_37305[(2)] = inst_37138);

(statearr_37212_37305[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (51))){
var inst_37107 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_37160__$1 = state_37160;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37160__$1,(54),inst_37107);
} else {
if((state_val_37161 === (25))){
var inst_36961 = (state_37160[(13)]);
var inst_36957 = (state_37160[(17)]);
var inst_37022 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_37023 = (function (){var segment_type = inst_36957;
var pred__36958 = inst_36961;
var expr__36959 = inst_36957;
var bindings = inst_37022;
return (function (p1__36943_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__36943_SHARP_);
});
})();
var inst_37024 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_37023,inst_37022);
var inst_37025 = cljs.core.PersistentHashMap.EMPTY;
var inst_37026 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37025,inst_37024);
var inst_37027 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37028 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_37026);
var inst_37029 = [inst_37028,r];
var inst_37030 = (new cljs.core.PersistentVector(null,2,(5),inst_37027,inst_37029,null));
var state_37160__$1 = state_37160;
var statearr_37213_37306 = state_37160__$1;
(statearr_37213_37306[(2)] = inst_37030);

(statearr_37213_37306[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (34))){
var inst_37061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37062 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_37063 = [inst_37062,r];
var inst_37064 = (new cljs.core.PersistentVector(null,2,(5),inst_37061,inst_37063,null));
var state_37160__$1 = state_37160;
var statearr_37214_37307 = state_37160__$1;
(statearr_37214_37307[(2)] = inst_37064);

(statearr_37214_37307[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (17))){
var inst_37018 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37215_37308 = state_37160__$1;
(statearr_37215_37308[(2)] = inst_37018);

(statearr_37215_37308[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (3))){
var inst_37158 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37160__$1,inst_37158);
} else {
if((state_val_37161 === (12))){
var inst_36964 = (state_37160[(23)]);
var inst_36968 = (state_37160[(2)]);
var inst_36969 = fluree.db.util.async.throw_err(inst_36968);
var inst_36970 = [inst_36969,r];
var inst_36971 = (new cljs.core.PersistentVector(null,2,(5),inst_36964,inst_36970,null));
var state_37160__$1 = state_37160;
var statearr_37216_37309 = state_37160__$1;
(statearr_37216_37309[(2)] = inst_36971);

(statearr_37216_37309[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (2))){
var _ = (function (){var statearr_37217 = state_37160;
(statearr_37217[(4)] = cljs.core.cons((5),(state_37160[(4)])));

return statearr_37217;
})();
var inst_36954 = cljs.core.map_QMARK_(clause);
var state_37160__$1 = state_37160;
if(inst_36954){
var statearr_37218_37310 = state_37160__$1;
(statearr_37218_37310[(1)] = (6));

} else {
var statearr_37219_37311 = state_37160__$1;
(statearr_37219_37311[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (23))){
var inst_36994 = (state_37160[(19)]);
var inst_37003 = (state_37160[(20)]);
var inst_36986 = inst_36994;
var inst_36987 = inst_37003;
var state_37160__$1 = (function (){var statearr_37220 = state_37160;
(statearr_37220[(16)] = inst_36987);

(statearr_37220[(18)] = inst_36986);

return statearr_37220;
})();
var statearr_37221_37312 = state_37160__$1;
(statearr_37221_37312[(2)] = null);

(statearr_37221_37312[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (47))){
var inst_37086 = (state_37160[(22)]);
var inst_37089 = (state_37160[(2)]);
var inst_37090 = fluree.db.util.async.throw_err(inst_37089);
var inst_37091 = [inst_37090,r];
var inst_37092 = (new cljs.core.PersistentVector(null,2,(5),inst_37086,inst_37091,null));
var state_37160__$1 = state_37160;
var statearr_37222_37313 = state_37160__$1;
(statearr_37222_37313[(2)] = inst_37092);

(statearr_37222_37313[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (35))){
var inst_37067 = (state_37160[(24)]);
var inst_37066 = cljs.core.count(clause);
var inst_37067__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_37066);
var state_37160__$1 = (function (){var statearr_37223 = state_37160;
(statearr_37223[(24)] = inst_37067__$1);

return statearr_37223;
})();
if(inst_37067__$1){
var statearr_37224_37314 = state_37160__$1;
(statearr_37224_37314[(1)] = (37));

} else {
var statearr_37225_37315 = state_37160__$1;
(statearr_37225_37315[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (19))){
var inst_36987 = (state_37160[(16)]);
var inst_37012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37013 = [inst_36987,r];
var inst_37014 = (new cljs.core.PersistentVector(null,2,(5),inst_37012,inst_37013,null));
var state_37160__$1 = state_37160;
var statearr_37226_37316 = state_37160__$1;
(statearr_37226_37316[(2)] = inst_37014);

(statearr_37226_37316[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (57))){
var inst_37142 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37227_37317 = state_37160__$1;
(statearr_37227_37317[(2)] = inst_37142);

(statearr_37227_37317[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (11))){
var inst_37050 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37229_37318 = state_37160__$1;
(statearr_37229_37318[(2)] = inst_37050);

(statearr_37229_37318[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (9))){
var inst_36964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36965 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_36966 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_36965,res,fuel,max_fuel,opts);
var state_37160__$1 = (function (){var statearr_37230 = state_37160;
(statearr_37230[(23)] = inst_36964);

return statearr_37230;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37160__$1,(12),inst_36966);
} else {
if((state_val_37161 === (5))){
var _ = (function (){var statearr_37231 = state_37160;
(statearr_37231[(4)] = cljs.core.rest((state_37160[(4)])));

return statearr_37231;
})();
var state_37160__$1 = state_37160;
var ex37228 = (state_37160__$1[(2)]);
var statearr_37232_37319 = state_37160__$1;
(statearr_37232_37319[(5)] = ex37228);


if((ex37228 instanceof Error)){
var statearr_37233_37320 = state_37160__$1;
(statearr_37233_37320[(1)] = (4));

(statearr_37233_37320[(5)] = null);

} else {
throw ex37228;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (14))){
var inst_36961 = (state_37160[(13)]);
var inst_36957 = (state_37160[(17)]);
var inst_37020 = (function (){var G__37234 = cljs.core.cst$kw$bind;
var G__37235 = inst_36957;
return (inst_36961.cljs$core$IFn$_invoke$arity$2 ? inst_36961.cljs$core$IFn$_invoke$arity$2(G__37234,G__37235) : inst_36961.call(null,G__37234,G__37235));
})();
var state_37160__$1 = state_37160;
if(cljs.core.truth_(inst_37020)){
var statearr_37236_37321 = state_37160__$1;
(statearr_37236_37321[(1)] = (25));

} else {
var statearr_37237_37322 = state_37160__$1;
(statearr_37237_37322[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (45))){
var inst_37094 = cljs.core.count(clause);
var inst_37095 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_37094);
var state_37160__$1 = state_37160;
if(inst_37095){
var statearr_37238_37323 = state_37160__$1;
(statearr_37238_37323[(1)] = (48));

} else {
var statearr_37239_37324 = state_37160__$1;
(statearr_37239_37324[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (53))){
var inst_37145 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37240_37325 = state_37160__$1;
(statearr_37240_37325[(2)] = inst_37145);

(statearr_37240_37325[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (26))){
var inst_36961 = (state_37160[(13)]);
var inst_36957 = (state_37160[(17)]);
var inst_37032 = (function (){var G__37241 = cljs.core.cst$kw$filter;
var G__37242 = inst_36957;
return (inst_36961.cljs$core$IFn$_invoke$arity$2 ? inst_36961.cljs$core$IFn$_invoke$arity$2(G__37241,G__37242) : inst_36961.call(null,G__37241,G__37242));
})();
var state_37160__$1 = state_37160;
if(cljs.core.truth_(inst_37032)){
var statearr_37243_37326 = state_37160__$1;
(statearr_37243_37326[(1)] = (28));

} else {
var statearr_37244_37327 = state_37160__$1;
(statearr_37244_37327[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (16))){
var inst_36993 = (state_37160[(14)]);
var inst_36986 = (state_37160[(18)]);
var inst_36992 = cljs.core.seq(inst_36986);
var inst_36993__$1 = cljs.core.first(inst_36992);
var inst_36994 = cljs.core.next(inst_36992);
var state_37160__$1 = (function (){var statearr_37245 = state_37160;
(statearr_37245[(14)] = inst_36993__$1);

(statearr_37245[(19)] = inst_36994);

return statearr_37245;
})();
if(cljs.core.truth_(inst_36993__$1)){
var statearr_37246_37328 = state_37160__$1;
(statearr_37246_37328[(1)] = (18));

} else {
var statearr_37247_37329 = state_37160__$1;
(statearr_37247_37329[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (38))){
var inst_37067 = (state_37160[(24)]);
var state_37160__$1 = state_37160;
var statearr_37248_37330 = state_37160__$1;
(statearr_37248_37330[(2)] = inst_37067);

(statearr_37248_37330[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (30))){
var inst_37044 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37249_37331 = state_37160__$1;
(statearr_37249_37331[(2)] = inst_37044);

(statearr_37249_37331[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (10))){
var inst_36961 = (state_37160[(13)]);
var inst_36957 = (state_37160[(17)]);
var inst_36973 = (function (){var G__37250 = cljs.core.cst$kw$union;
var G__37251 = inst_36957;
return (inst_36961.cljs$core$IFn$_invoke$arity$2 ? inst_36961.cljs$core$IFn$_invoke$arity$2(G__37250,G__37251) : inst_36961.call(null,G__37250,G__37251));
})();
var state_37160__$1 = state_37160;
if(cljs.core.truth_(inst_36973)){
var statearr_37252_37332 = state_37160__$1;
(statearr_37252_37332[(1)] = (13));

} else {
var statearr_37253_37333 = state_37160__$1;
(statearr_37253_37333[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (18))){
var inst_36993 = (state_37160[(14)]);
var inst_36996 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_36993,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_36993,q_map,vars,fuel,max_fuel,opts));
var state_37160__$1 = state_37160;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37160__$1,(21),inst_36996);
} else {
if((state_val_37161 === (52))){
var state_37160__$1 = state_37160;
var statearr_37254_37334 = state_37160__$1;
(statearr_37254_37334[(2)] = null);

(statearr_37254_37334[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (42))){
var inst_37151 = (state_37160[(2)]);
var state_37160__$1 = state_37160;
var statearr_37255_37335 = state_37160__$1;
(statearr_37255_37335[(2)] = inst_37151);

(statearr_37255_37335[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (37))){
var inst_37069 = cljs.core.second(clause);
var inst_37070 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37069,"rdf:type");
var state_37160__$1 = state_37160;
var statearr_37256_37336 = state_37160__$1;
(statearr_37256_37336[(2)] = inst_37070);

(statearr_37256_37336[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (63))){
var state_37160__$1 = state_37160;
var statearr_37257_37337 = state_37160__$1;
(statearr_37257_37337[(2)] = null);

(statearr_37257_37337[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (8))){
var inst_37155 = (state_37160[(2)]);
var _ = (function (){var statearr_37258 = state_37160;
(statearr_37258[(4)] = cljs.core.rest((state_37160[(4)])));

return statearr_37258;
})();
var state_37160__$1 = state_37160;
var statearr_37259_37338 = state_37160__$1;
(statearr_37259_37338[(2)] = inst_37155);

(statearr_37259_37338[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37161 === (49))){
var state_37160__$1 = state_37160;
var statearr_37260_37339 = state_37160__$1;
(statearr_37260_37339[(1)] = (51));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16153__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16153__auto____0 = (function (){
var statearr_37262 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37262[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16153__auto__);

(statearr_37262[(1)] = (1));

return statearr_37262;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16153__auto____1 = (function (state_37160){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_37160);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e37263){var ex__16156__auto__ = e37263;
var statearr_37264_37340 = state_37160;
(statearr_37264_37340[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_37160[(4)]))){
var statearr_37265_37341 = state_37160;
(statearr_37265_37341[(1)] = cljs.core.first((state_37160[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__37342 = state_37160;
state_37160 = G__37342;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16153__auto__ = function(state_37160){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16153__auto____1.call(this,state_37160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16153__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16153__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_37266 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_37266[(6)] = c__16227__auto__);

return statearr_37266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__37344 = arguments.length;
switch (G__37344) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_37424){
var state_val_37425 = (state_37424[(1)]);
if((state_val_37425 === (7))){
var inst_37419 = (state_37424[(2)]);
var _ = (function (){var statearr_37426 = state_37424;
(statearr_37426[(4)] = cljs.core.rest((state_37424[(4)])));

return statearr_37426;
})();
var state_37424__$1 = state_37424;
var statearr_37427_37475 = state_37424__$1;
(statearr_37427_37475[(2)] = inst_37419);

(statearr_37427_37475[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (20))){
var inst_37384 = (state_37424[(7)]);
var inst_37396 = (state_37424[(2)]);
var inst_37366 = inst_37384;
var inst_37367 = inst_37396;
var state_37424__$1 = (function (){var statearr_37428 = state_37424;
(statearr_37428[(8)] = inst_37366);

(statearr_37428[(9)] = inst_37367);

return statearr_37428;
})();
var statearr_37429_37476 = state_37424__$1;
(statearr_37429_37476[(2)] = null);

(statearr_37429_37476[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (1))){
var state_37424__$1 = state_37424;
var statearr_37430_37477 = state_37424__$1;
(statearr_37430_37477[(2)] = null);

(statearr_37430_37477[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (24))){
var inst_37367 = (state_37424[(9)]);
var inst_37383 = (state_37424[(10)]);
var inst_37384 = (state_37424[(7)]);
var inst_37404 = fluree.db.query.analytical.inner_join(inst_37367,inst_37383);
var inst_37366 = inst_37384;
var inst_37367__$1 = inst_37404;
var state_37424__$1 = (function (){var statearr_37431 = state_37424;
(statearr_37431[(8)] = inst_37366);

(statearr_37431[(9)] = inst_37367__$1);

return statearr_37431;
})();
var statearr_37432_37478 = state_37424__$1;
(statearr_37432_37478[(2)] = null);

(statearr_37432_37478[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (4))){
var inst_37345 = (state_37424[(2)]);
var state_37424__$1 = state_37424;
var statearr_37434_37479 = state_37424__$1;
(statearr_37434_37479[(2)] = inst_37345);

(statearr_37434_37479[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (15))){
var inst_37383 = (state_37424[(10)]);
var state_37424__$1 = state_37424;
if(cljs.core.truth_(inst_37383)){
var statearr_37435_37480 = state_37424__$1;
(statearr_37435_37480[(1)] = (18));

} else {
var statearr_37436_37481 = state_37424__$1;
(statearr_37436_37481[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (21))){
var inst_37367 = (state_37424[(9)]);
var inst_37384 = (state_37424[(7)]);
var tmp37433 = inst_37367;
var inst_37366 = inst_37384;
var inst_37367__$1 = tmp37433;
var state_37424__$1 = (function (){var statearr_37437 = state_37424;
(statearr_37437[(8)] = inst_37366);

(statearr_37437[(9)] = inst_37367__$1);

return statearr_37437;
})();
var statearr_37438_37482 = state_37424__$1;
(statearr_37438_37482[(2)] = null);

(statearr_37438_37482[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (13))){
var inst_37367 = (state_37424[(9)]);
var inst_37390 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_37367,cljs.core.cst$kw$vars);
var inst_37391 = cljs.core.empty_QMARK_(inst_37390);
var state_37424__$1 = state_37424;
if(inst_37391){
var statearr_37439_37483 = state_37424__$1;
(statearr_37439_37483[(1)] = (15));

} else {
var statearr_37440_37484 = state_37424__$1;
(statearr_37440_37484[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (22))){
var state_37424__$1 = state_37424;
var statearr_37441_37485 = state_37424__$1;
(statearr_37441_37485[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (6))){
var inst_37366 = (state_37424[(8)]);
var inst_37373 = (state_37424[(11)]);
var inst_37372 = cljs.core.seq(inst_37366);
var inst_37373__$1 = cljs.core.first(inst_37372);
var inst_37374 = cljs.core.next(inst_37372);
var state_37424__$1 = (function (){var statearr_37443 = state_37424;
(statearr_37443[(12)] = inst_37374);

(statearr_37443[(11)] = inst_37373__$1);

return statearr_37443;
})();
if(cljs.core.truth_(inst_37373__$1)){
var statearr_37444_37486 = state_37424__$1;
(statearr_37444_37486[(1)] = (8));

} else {
var statearr_37445_37487 = state_37424__$1;
(statearr_37445_37487[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (25))){
var state_37424__$1 = state_37424;
var statearr_37446_37488 = state_37424__$1;
(statearr_37446_37488[(2)] = null);

(statearr_37446_37488[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (17))){
var inst_37412 = (state_37424[(2)]);
var state_37424__$1 = state_37424;
var statearr_37447_37489 = state_37424__$1;
(statearr_37447_37489[(2)] = inst_37412);

(statearr_37447_37489[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (3))){
var inst_37422 = (state_37424[(2)]);
var state_37424__$1 = state_37424;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37424__$1,inst_37422);
} else {
if((state_val_37425 === (12))){
var inst_37383 = (state_37424[(10)]);
var inst_37384 = (state_37424[(7)]);
var inst_37366 = inst_37384;
var inst_37367 = inst_37383;
var state_37424__$1 = (function (){var statearr_37448 = state_37424;
(statearr_37448[(8)] = inst_37366);

(statearr_37448[(9)] = inst_37367);

return statearr_37448;
})();
var statearr_37449_37490 = state_37424__$1;
(statearr_37449_37490[(2)] = null);

(statearr_37449_37490[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (2))){
var _ = (function (){var statearr_37450 = state_37424;
(statearr_37450[(4)] = cljs.core.cons((5),(state_37424[(4)])));

return statearr_37450;
})();
var inst_37358 = where;
var inst_37359 = cljs.core.seq(inst_37358);
var inst_37360 = cljs.core.first(inst_37359);
var inst_37361 = cljs.core.next(inst_37359);
var inst_37362 = [cljs.core.cst$kw$vars];
var inst_37363 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_37364 = [inst_37363];
var inst_37365 = cljs.core.PersistentHashMap.fromArrays(inst_37362,inst_37364);
var inst_37366 = inst_37358;
var inst_37367 = inst_37365;
var state_37424__$1 = (function (){var statearr_37451 = state_37424;
(statearr_37451[(8)] = inst_37366);

(statearr_37451[(9)] = inst_37367);

(statearr_37451[(13)] = inst_37361);

(statearr_37451[(14)] = inst_37360);

return statearr_37451;
})();
var statearr_37452_37491 = state_37424__$1;
(statearr_37452_37491[(2)] = null);

(statearr_37452_37491[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (23))){
var inst_37410 = (state_37424[(2)]);
var state_37424__$1 = state_37424;
var statearr_37453_37492 = state_37424__$1;
(statearr_37453_37492[(2)] = inst_37410);

(statearr_37453_37492[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (19))){
var inst_37367 = (state_37424[(9)]);
var state_37424__$1 = state_37424;
var statearr_37454_37493 = state_37424__$1;
(statearr_37454_37493[(2)] = inst_37367);

(statearr_37454_37493[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (11))){
var inst_37373 = (state_37424[(11)]);
var inst_37381 = (state_37424[(2)]);
var inst_37382 = fluree.db.util.async.throw_err(inst_37381);
var inst_37383 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37382,(0),null);
var inst_37384 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37382,(1),null);
var inst_37385 = cljs.core.count(inst_37373);
var inst_37386 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_37385);
var state_37424__$1 = (function (){var statearr_37456 = state_37424;
(statearr_37456[(10)] = inst_37383);

(statearr_37456[(7)] = inst_37384);

return statearr_37456;
})();
if(inst_37386){
var statearr_37457_37494 = state_37424__$1;
(statearr_37457_37494[(1)] = (12));

} else {
var statearr_37458_37495 = state_37424__$1;
(statearr_37458_37495[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (9))){
var inst_37367 = (state_37424[(9)]);
var state_37424__$1 = state_37424;
var statearr_37459_37496 = state_37424__$1;
(statearr_37459_37496[(2)] = inst_37367);

(statearr_37459_37496[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (5))){
var _ = (function (){var statearr_37460 = state_37424;
(statearr_37460[(4)] = cljs.core.rest((state_37424[(4)])));

return statearr_37460;
})();
var state_37424__$1 = state_37424;
var ex37455 = (state_37424__$1[(2)]);
var statearr_37461_37497 = state_37424__$1;
(statearr_37461_37497[(5)] = ex37455);


if((ex37455 instanceof Error)){
var statearr_37462_37498 = state_37424__$1;
(statearr_37462_37498[(1)] = (4));

(statearr_37462_37498[(5)] = null);

} else {
throw ex37455;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (14))){
var inst_37414 = (state_37424[(2)]);
var state_37424__$1 = state_37424;
var statearr_37463_37499 = state_37424__$1;
(statearr_37463_37499[(2)] = inst_37414);

(statearr_37463_37499[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (26))){
var inst_37408 = (state_37424[(2)]);
var state_37424__$1 = state_37424;
var statearr_37464_37500 = state_37424__$1;
(statearr_37464_37500[(2)] = inst_37408);

(statearr_37464_37500[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (16))){
var inst_37383 = (state_37424[(10)]);
var inst_37399 = (inst_37383 == null);
var state_37424__$1 = state_37424;
if(cljs.core.truth_(inst_37399)){
var statearr_37465_37501 = state_37424__$1;
(statearr_37465_37501[(1)] = (21));

} else {
var statearr_37466_37502 = state_37424__$1;
(statearr_37466_37502[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (10))){
var inst_37417 = (state_37424[(2)]);
var state_37424__$1 = state_37424;
var statearr_37467_37503 = state_37424__$1;
(statearr_37467_37503[(2)] = inst_37417);

(statearr_37467_37503[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (18))){
var inst_37383 = (state_37424[(10)]);
var state_37424__$1 = state_37424;
var statearr_37468_37504 = state_37424__$1;
(statearr_37468_37504[(2)] = inst_37383);

(statearr_37468_37504[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37425 === (8))){
var inst_37374 = (state_37424[(12)]);
var inst_37367 = (state_37424[(9)]);
var inst_37373 = (state_37424[(11)]);
var inst_37379 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_37367,inst_37373,inst_37374,false,fuel,max_fuel,opts);
var state_37424__$1 = state_37424;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37424__$1,(11),inst_37379);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16153__auto__ = null;
var fluree$db$query$analytical$state_machine__16153__auto____0 = (function (){
var statearr_37469 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37469[(0)] = fluree$db$query$analytical$state_machine__16153__auto__);

(statearr_37469[(1)] = (1));

return statearr_37469;
});
var fluree$db$query$analytical$state_machine__16153__auto____1 = (function (state_37424){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_37424);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e37470){var ex__16156__auto__ = e37470;
var statearr_37471_37505 = state_37424;
(statearr_37471_37505[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_37424[(4)]))){
var statearr_37472_37506 = state_37424;
(statearr_37472_37506[(1)] = cljs.core.first((state_37424[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__37507 = state_37424;
state_37424 = G__37507;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16153__auto__ = function(state_37424){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16153__auto____1.call(this,state_37424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16153__auto____0;
fluree$db$query$analytical$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16153__auto____1;
return fluree$db$query$analytical$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_37473 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_37473[(6)] = c__16227__auto__);

return statearr_37473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_37542){
var state_val_37543 = (state_37542[(1)]);
if((state_val_37543 === (7))){
var inst_37524 = (state_37542[(7)]);
var inst_37519 = (state_37542[(8)]);
var inst_37526 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_37519,inst_37524,fuel,max_fuel,opts);
var state_37542__$1 = state_37542;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37542__$1,(10),inst_37526);
} else {
if((state_val_37543 === (1))){
var state_37542__$1 = state_37542;
var statearr_37544_37569 = state_37542__$1;
(statearr_37544_37569[(2)] = null);

(statearr_37544_37569[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37543 === (4))){
var inst_37508 = (state_37542[(2)]);
var state_37542__$1 = state_37542;
var statearr_37545_37570 = state_37542__$1;
(statearr_37545_37570[(2)] = inst_37508);

(statearr_37545_37570[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37543 === (13))){
var inst_37537 = (state_37542[(2)]);
var _ = (function (){var statearr_37546 = state_37542;
(statearr_37546[(4)] = cljs.core.rest((state_37542[(4)])));

return statearr_37546;
})();
var state_37542__$1 = state_37542;
var statearr_37547_37571 = state_37542__$1;
(statearr_37547_37571[(2)] = inst_37537);

(statearr_37547_37571[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37543 === (6))){
var inst_37519 = (state_37542[(8)]);
var inst_37523 = (state_37542[(2)]);
var inst_37524 = fluree.db.util.async.throw_err(inst_37523);
var state_37542__$1 = (function (){var statearr_37548 = state_37542;
(statearr_37548[(7)] = inst_37524);

return statearr_37548;
})();
if(cljs.core.truth_(inst_37519)){
var statearr_37549_37572 = state_37542__$1;
(statearr_37549_37572[(1)] = (7));

} else {
var statearr_37550_37573 = state_37542__$1;
(statearr_37550_37573[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37543 === (3))){
var inst_37540 = (state_37542[(2)]);
var state_37542__$1 = state_37542;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37542__$1,inst_37540);
} else {
if((state_val_37543 === (12))){
var inst_37532 = (state_37542[(9)]);
var state_37542__$1 = state_37542;
var statearr_37551_37574 = state_37542__$1;
(statearr_37551_37574[(2)] = inst_37532);

(statearr_37551_37574[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37543 === (2))){
var _ = (function (){var statearr_37552 = state_37542;
(statearr_37552[(4)] = cljs.core.cons((5),(state_37542[(4)])));

return statearr_37552;
})();
var inst_37515 = q_map;
var inst_37516 = cljs.core.__destructure_map(inst_37515);
var inst_37517 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37516,cljs.core.cst$kw$vars);
var inst_37518 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37516,cljs.core.cst$kw$where);
var inst_37519 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37516,cljs.core.cst$kw$optional);
var inst_37520 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37516,cljs.core.cst$kw$filter);
var inst_37521 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_37518,q_map,inst_37517,fuel,max_fuel,opts);
var state_37542__$1 = (function (){var statearr_37553 = state_37542;
(statearr_37553[(10)] = inst_37520);

(statearr_37553[(8)] = inst_37519);

return statearr_37553;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37542__$1,(6),inst_37521);
} else {
if((state_val_37543 === (11))){
var inst_37520 = (state_37542[(10)]);
var inst_37532 = (state_37542[(9)]);
var inst_37534 = fluree.db.query.analytical.tuples__GT_filtered(inst_37532,inst_37520,null);
var state_37542__$1 = state_37542;
var statearr_37555_37575 = state_37542__$1;
(statearr_37555_37575[(2)] = inst_37534);

(statearr_37555_37575[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37543 === (9))){
var inst_37520 = (state_37542[(10)]);
var inst_37532 = (state_37542[(2)]);
var state_37542__$1 = (function (){var statearr_37556 = state_37542;
(statearr_37556[(9)] = inst_37532);

return statearr_37556;
})();
if(cljs.core.truth_(inst_37520)){
var statearr_37557_37576 = state_37542__$1;
(statearr_37557_37576[(1)] = (11));

} else {
var statearr_37558_37577 = state_37542__$1;
(statearr_37558_37577[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37543 === (5))){
var _ = (function (){var statearr_37559 = state_37542;
(statearr_37559[(4)] = cljs.core.rest((state_37542[(4)])));

return statearr_37559;
})();
var state_37542__$1 = state_37542;
var ex37554 = (state_37542__$1[(2)]);
var statearr_37560_37578 = state_37542__$1;
(statearr_37560_37578[(5)] = ex37554);


if((ex37554 instanceof Error)){
var statearr_37561_37579 = state_37542__$1;
(statearr_37561_37579[(1)] = (4));

(statearr_37561_37579[(5)] = null);

} else {
throw ex37554;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37543 === (10))){
var inst_37528 = (state_37542[(2)]);
var inst_37529 = fluree.db.util.async.throw_err(inst_37528);
var state_37542__$1 = state_37542;
var statearr_37562_37580 = state_37542__$1;
(statearr_37562_37580[(2)] = inst_37529);

(statearr_37562_37580[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37543 === (8))){
var inst_37524 = (state_37542[(7)]);
var state_37542__$1 = state_37542;
var statearr_37563_37581 = state_37542__$1;
(statearr_37563_37581[(2)] = inst_37524);

(statearr_37563_37581[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__16153__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__16153__auto____0 = (function (){
var statearr_37564 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37564[(0)] = fluree$db$query$analytical$q_$_state_machine__16153__auto__);

(statearr_37564[(1)] = (1));

return statearr_37564;
});
var fluree$db$query$analytical$q_$_state_machine__16153__auto____1 = (function (state_37542){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_37542);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e37565){var ex__16156__auto__ = e37565;
var statearr_37566_37582 = state_37542;
(statearr_37566_37582[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_37542[(4)]))){
var statearr_37567_37583 = state_37542;
(statearr_37567_37583[(1)] = cljs.core.first((state_37542[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__37584 = state_37542;
state_37542 = G__37584;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__16153__auto__ = function(state_37542){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__16153__auto____1.call(this,state_37542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__16153__auto____0;
fluree$db$query$analytical$q_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__16153__auto____1;
return fluree$db$query$analytical$q_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_37568 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_37568[(6)] = c__16227__auto__);

return statearr_37568;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
