// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__34486 = arguments.length;
switch (G__34486) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__34489 = arguments.length;
switch (G__34489) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16227__auto___34542 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_34520){
var state_val_34521 = (state_34520[(1)]);
if((state_val_34521 === (1))){
var state_34520__$1 = state_34520;
var statearr_34522_34543 = state_34520__$1;
(statearr_34522_34543[(2)] = null);

(statearr_34522_34543[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34521 === (2))){
var _ = (function (){var statearr_34523 = state_34520;
(statearr_34523[(4)] = cljs.core.cons((5),(state_34520[(4)])));

return statearr_34523;
})();
var inst_34497 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_34520__$1 = state_34520;
if(cljs.core.truth_(inst_34497)){
var statearr_34524_34544 = state_34520__$1;
(statearr_34524_34544[(1)] = (6));

} else {
var statearr_34525_34545 = state_34520__$1;
(statearr_34525_34545[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34521 === (3))){
var inst_34518 = (state_34520[(2)]);
var state_34520__$1 = state_34520;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34520__$1,inst_34518);
} else {
if((state_val_34521 === (4))){
var inst_34490 = (state_34520[(2)]);
var inst_34491 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_34490);
var state_34520__$1 = state_34520;
var statearr_34527_34546 = state_34520__$1;
(statearr_34527_34546[(2)] = inst_34491);

(statearr_34527_34546[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34521 === (5))){
var _ = (function (){var statearr_34528 = state_34520;
(statearr_34528[(4)] = cljs.core.rest((state_34520[(4)])));

return statearr_34528;
})();
var state_34520__$1 = state_34520;
var ex34526 = (state_34520__$1[(2)]);
var statearr_34529_34547 = state_34520__$1;
(statearr_34529_34547[(5)] = ex34526);


var statearr_34530_34548 = state_34520__$1;
(statearr_34530_34548[(1)] = (4));

(statearr_34530_34548[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_34521 === (6))){
var inst_34499 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34500 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_34501 = cljs.core.PersistentHashMap.fromArrays(inst_34499,inst_34500);
var inst_34502 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_34501);
var inst_34503 = (function(){throw inst_34502})();
var state_34520__$1 = state_34520;
var statearr_34531_34549 = state_34520__$1;
(statearr_34531_34549[(2)] = inst_34503);

(statearr_34531_34549[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34521 === (7))){
var inst_34505 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_34506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34507 = [operation,data,pc,opts];
var inst_34508 = (new cljs.core.PersistentVector(null,4,(5),inst_34506,inst_34507,null));
var inst_34509 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_34505,inst_34508);
var inst_34510 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34511 = [operation,data,pc,opts];
var inst_34512 = (new cljs.core.PersistentVector(null,4,(5),inst_34510,inst_34511,null));
var inst_34513 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_34512], 0));
var state_34520__$1 = (function (){var statearr_34532 = state_34520;
(statearr_34532[(7)] = inst_34509);

return statearr_34532;
})();
var statearr_34533_34550 = state_34520__$1;
(statearr_34533_34550[(2)] = inst_34513);

(statearr_34533_34550[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34521 === (8))){
var inst_34515 = (state_34520[(2)]);
var _ = (function (){var statearr_34534 = state_34520;
(statearr_34534[(4)] = cljs.core.rest((state_34520[(4)])));

return statearr_34534;
})();
var state_34520__$1 = state_34520;
var statearr_34535_34551 = state_34520__$1;
(statearr_34535_34551[(2)] = inst_34515);

(statearr_34535_34551[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__16153__auto__ = null;
var fluree$db$operations$state_machine__16153__auto____0 = (function (){
var statearr_34536 = [null,null,null,null,null,null,null,null];
(statearr_34536[(0)] = fluree$db$operations$state_machine__16153__auto__);

(statearr_34536[(1)] = (1));

return statearr_34536;
});
var fluree$db$operations$state_machine__16153__auto____1 = (function (state_34520){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_34520);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e34537){var ex__16156__auto__ = e34537;
var statearr_34538_34552 = state_34520;
(statearr_34538_34552[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_34520[(4)]))){
var statearr_34539_34553 = state_34520;
(statearr_34539_34553[(1)] = cljs.core.first((state_34520[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__34554 = state_34520;
state_34520 = G__34554;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$operations$state_machine__16153__auto__ = function(state_34520){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__16153__auto____1.call(this,state_34520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__16153__auto____0;
fluree$db$operations$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__16153__auto____1;
return fluree$db$operations$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_34540 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_34540[(6)] = c__16227__auto___34542);

return statearr_34540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__34556 = arguments.length;
switch (G__34556) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__34557){
var map__34558 = p__34557;
var map__34558__$1 = cljs.core.__destructure_map(map__34558);
var opts = map__34558__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34558__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__34559 = session;
var map__34559__$1 = cljs.core.__destructure_map(map__34559);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34559__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34559__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34559__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4835__auto__ = [];
var len__4829__auto___34586 = arguments.length;
var i__4830__auto___34587 = (0);
while(true){
if((i__4830__auto___34587 < len__4829__auto___34586)){
args__4835__auto__.push((arguments[i__4830__auto___34587]));

var G__34588 = (i__4830__auto___34587 + (1));
i__4830__auto___34587 = G__34588;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__34563){
var vec__34564 = p__34563;
var map__34567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34564,(0),null);
var map__34567__$1 = cljs.core.__destructure_map(map__34567);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34567__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34567__$1,cljs.core.cst$kw$toTime);
var opts = vec__34564;
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_34579){
var state_val_34580 = (state_34579[(1)]);
if((state_val_34580 === (1))){
var inst_34569 = session;
var inst_34570 = cljs.core.__destructure_map(inst_34569);
var inst_34571 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34570,cljs.core.cst$kw$network);
var inst_34572 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34570,cljs.core.cst$kw$dbid);
var inst_34573 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34570,cljs.core.cst$kw$conn);
var inst_34574 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_34575 = [inst_34571,inst_34572,toBlock,toTime];
var inst_34576 = cljs.core.PersistentHashMap.fromArrays(inst_34574,inst_34575);
var inst_34577 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_34573,cljs.core.cst$kw$garbage,inst_34576);
var state_34579__$1 = state_34579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34579__$1,inst_34577);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__16153__auto__ = null;
var fluree$db$operations$state_machine__16153__auto____0 = (function (){
var statearr_34581 = [null,null,null,null,null,null,null];
(statearr_34581[(0)] = fluree$db$operations$state_machine__16153__auto__);

(statearr_34581[(1)] = (1));

return statearr_34581;
});
var fluree$db$operations$state_machine__16153__auto____1 = (function (state_34579){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_34579);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e34582){var ex__16156__auto__ = e34582;
var statearr_34583_34589 = state_34579;
(statearr_34583_34589[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_34579[(4)]))){
var statearr_34584_34590 = state_34579;
(statearr_34584_34590[(1)] = cljs.core.first((state_34579[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__34591 = state_34579;
state_34579 = G__34591;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$operations$state_machine__16153__auto__ = function(state_34579){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__16153__auto____1.call(this,state_34579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__16153__auto____0;
fluree$db$operations$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__16153__auto____1;
return fluree$db$operations$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_34585 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_34585[(6)] = c__16227__auto__);

return statearr_34585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq34561){
var G__34562 = cljs.core.first(seq34561);
var seq34561__$1 = cljs.core.next(seq34561);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34562,seq34561__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__34592 = session;
var map__34592__$1 = cljs.core.__destructure_map(map__34592);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34592__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34592__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34592__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__34594 = arguments.length;
switch (G__34594) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__34595 = opts;
var map__34595__$1 = cljs.core.__destructure_map(map__34595);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34595__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34595__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4223__auto__ = auth;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
