// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k32693,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__32697 = k32693;
var G__32697__$1 = (((G__32697 instanceof cljs.core.Keyword))?G__32697.fqn:null);
switch (G__32697__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32693,else__4475__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__32698){
var vec__32699 = p__32698;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32699,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32699,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32692){
var self__ = this;
var G__32692__$1 = this;
return (new cljs.core.RecordIter((0),G__32692__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__32702 = (function (coll__4469__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__32702(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32694,other32695){
var self__ = this;
var this32694__$1 = this;
return (((!((other32695 == null)))) && ((((this32694__$1.constructor === other32695.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32694__$1.index_type,other32695.index_type)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32694__$1.comparator,other32695.comparator)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32694__$1.historyComparator,other32695.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32694__$1.__extmap,other32695.__extmap)))))))))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k32693){
var self__ = this;
var this__4479__auto____$1 = this;
var G__32703 = k32693;
var G__32703__$1 = (((G__32703 instanceof cljs.core.Keyword))?G__32703.fqn:null);
switch (G__32703__$1) {
case "index-type":
case "comparator":
case "historyComparator":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k32693);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__32692){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__32704 = cljs.core.keyword_identical_QMARK_;
var expr__32705 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__32707 = cljs.core.cst$kw$index_DASH_type;
var G__32708 = expr__32705;
return (pred__32704.cljs$core$IFn$_invoke$arity$2 ? pred__32704.cljs$core$IFn$_invoke$arity$2(G__32707,G__32708) : pred__32704.call(null,G__32707,G__32708));
})())){
return (new fluree.db.index.IndexConfig(G__32692,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32709 = cljs.core.cst$kw$comparator;
var G__32710 = expr__32705;
return (pred__32704.cljs$core$IFn$_invoke$arity$2 ? pred__32704.cljs$core$IFn$_invoke$arity$2(G__32709,G__32710) : pred__32704.call(null,G__32709,G__32710));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__32692,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32711 = cljs.core.cst$kw$historyComparator;
var G__32712 = expr__32705;
return (pred__32704.cljs$core$IFn$_invoke$arity$2 ? pred__32704.cljs$core$IFn$_invoke$arity$2(G__32711,G__32712) : pred__32704.call(null,G__32711,G__32712));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__32692,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__32692),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__32692){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__32692,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__32696){
var extmap__4512__auto__ = (function (){var G__32713 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32696,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__32696)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32713);
} else {
return G__32713;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__32696),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__32696),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__32696),null,cljs.core.not_empty(extmap__4512__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k32717,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__32721 = k32717;
var G__32721__$1 = (((G__32721 instanceof cljs.core.Keyword))?G__32721.fqn:null);
switch (G__32721__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32717,else__4475__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__32722){
var vec__32723 = p__32722;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32723,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32723,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32716){
var self__ = this;
var G__32716__$1 = this;
return (new cljs.core.RecordIter((0),G__32716__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_32727){
var state_val_32728 = (state_32727[(1)]);
if((state_val_32728 === (1))){
var state_32727__$1 = state_32727;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32727__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__16153__auto__ = null;
var fluree$db$index$state_machine__16153__auto____0 = (function (){
var statearr_32729 = [null,null,null,null,null,null,null];
(statearr_32729[(0)] = fluree$db$index$state_machine__16153__auto__);

(statearr_32729[(1)] = (1));

return statearr_32729;
});
var fluree$db$index$state_machine__16153__auto____1 = (function (state_32727){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_32727);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e32730){var ex__16156__auto__ = e32730;
var statearr_32731_32843 = state_32727;
(statearr_32731_32843[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_32727[(4)]))){
var statearr_32732_32844 = state_32727;
(statearr_32732_32844[(1)] = cljs.core.first((state_32727[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__32845 = state_32727;
state_32727 = G__32845;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$index$state_machine__16153__auto__ = function(state_32727){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16153__auto____1.call(this,state_32727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16153__auto____0;
fluree$db$index$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16153__auto____1;
return fluree$db$index$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_32733 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_32733[(6)] = c__16227__auto__);

return statearr_32733;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4223__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4223__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_32758){
var state_val_32759 = (state_32758[(1)]);
if((state_val_32759 === (7))){
var inst_32740 = (state_32758[(7)]);
var inst_32744 = fluree.db.dbproto._resolve(inst_32740);
var state_32758__$1 = state_32758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32758__$1,(10),inst_32744);
} else {
if((state_val_32759 === (1))){
var state_32758__$1 = state_32758;
var statearr_32760_32846 = state_32758__$1;
(statearr_32760_32846[(2)] = null);

(statearr_32760_32846[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32759 === (4))){
var inst_32734 = (state_32758[(2)]);
var state_32758__$1 = state_32758;
var statearr_32761_32847 = state_32758__$1;
(statearr_32761_32847[(2)] = inst_32734);

(statearr_32761_32847[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32759 === (6))){
var inst_32740 = (state_32758[(7)]);
var state_32758__$1 = state_32758;
var statearr_32762_32848 = state_32758__$1;
(statearr_32762_32848[(2)] = inst_32740);

(statearr_32762_32848[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32759 === (3))){
var inst_32756 = (state_32758[(2)]);
var state_32758__$1 = state_32758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32758__$1,inst_32756);
} else {
if((state_val_32759 === (2))){
var inst_32740 = (state_32758[(7)]);
var _ = (function (){var statearr_32764 = state_32758;
(statearr_32764[(4)] = cljs.core.cons((5),(state_32758[(4)])));

return statearr_32764;
})();
var inst_32740__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_32741 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_32740__$1);
var state_32758__$1 = (function (){var statearr_32765 = state_32758;
(statearr_32765[(7)] = inst_32740__$1);

return statearr_32765;
})();
if(cljs.core.truth_(inst_32741)){
var statearr_32766_32849 = state_32758__$1;
(statearr_32766_32849[(1)] = (6));

} else {
var statearr_32767_32850 = state_32758__$1;
(statearr_32767_32850[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32759 === (9))){
var inst_32750 = (state_32758[(2)]);
var inst_32751 = fluree.db.util.async.throw_err(inst_32750);
var state_32758__$1 = state_32758;
var statearr_32768_32851 = state_32758__$1;
(statearr_32768_32851[(2)] = inst_32751);

(statearr_32768_32851[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32759 === (5))){
var _ = (function (){var statearr_32769 = state_32758;
(statearr_32769[(4)] = cljs.core.rest((state_32758[(4)])));

return statearr_32769;
})();
var state_32758__$1 = state_32758;
var ex32763 = (state_32758__$1[(2)]);
var statearr_32770_32852 = state_32758__$1;
(statearr_32770_32852[(5)] = ex32763);


if((ex32763 instanceof Error)){
var statearr_32771_32853 = state_32758__$1;
(statearr_32771_32853[(1)] = (4));

(statearr_32771_32853[(5)] = null);

} else {
throw ex32763;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32759 === (10))){
var inst_32746 = (state_32758[(2)]);
var inst_32747 = fluree.db.util.async.throw_err(inst_32746);
var inst_32748 = fluree.db.dbproto._lookup_leaf(inst_32747,flake);
var state_32758__$1 = state_32758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32758__$1,(9),inst_32748);
} else {
if((state_val_32759 === (8))){
var inst_32753 = (state_32758[(2)]);
var _ = (function (){var statearr_32772 = state_32758;
(statearr_32772[(4)] = cljs.core.rest((state_32758[(4)])));

return statearr_32772;
})();
var state_32758__$1 = state_32758;
var statearr_32773_32854 = state_32758__$1;
(statearr_32773_32854[(2)] = inst_32753);

(statearr_32773_32854[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__16153__auto__ = null;
var fluree$db$index$state_machine__16153__auto____0 = (function (){
var statearr_32774 = [null,null,null,null,null,null,null,null];
(statearr_32774[(0)] = fluree$db$index$state_machine__16153__auto__);

(statearr_32774[(1)] = (1));

return statearr_32774;
});
var fluree$db$index$state_machine__16153__auto____1 = (function (state_32758){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_32758);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e32775){var ex__16156__auto__ = e32775;
var statearr_32776_32855 = state_32758;
(statearr_32776_32855[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_32758[(4)]))){
var statearr_32777_32856 = state_32758;
(statearr_32777_32856[(1)] = cljs.core.first((state_32758[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__32857 = state_32758;
state_32758 = G__32857;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$index$state_machine__16153__auto__ = function(state_32758){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16153__auto____1.call(this,state_32758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16153__auto____0;
fluree$db$index$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16153__auto____1;
return fluree$db$index$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_32778 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_32778[(6)] = c__16227__auto__);

return statearr_32778;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_32803){
var state_val_32804 = (state_32803[(1)]);
if((state_val_32804 === (7))){
var inst_32785 = (state_32803[(7)]);
var inst_32789 = fluree.db.dbproto._resolve(inst_32785);
var state_32803__$1 = state_32803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32803__$1,(10),inst_32789);
} else {
if((state_val_32804 === (1))){
var state_32803__$1 = state_32803;
var statearr_32805_32858 = state_32803__$1;
(statearr_32805_32858[(2)] = null);

(statearr_32805_32858[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32804 === (4))){
var inst_32779 = (state_32803[(2)]);
var state_32803__$1 = state_32803;
var statearr_32806_32859 = state_32803__$1;
(statearr_32806_32859[(2)] = inst_32779);

(statearr_32806_32859[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32804 === (6))){
var inst_32785 = (state_32803[(7)]);
var state_32803__$1 = state_32803;
var statearr_32807_32860 = state_32803__$1;
(statearr_32807_32860[(2)] = inst_32785);

(statearr_32807_32860[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32804 === (3))){
var inst_32801 = (state_32803[(2)]);
var state_32803__$1 = state_32803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32803__$1,inst_32801);
} else {
if((state_val_32804 === (2))){
var inst_32785 = (state_32803[(7)]);
var _ = (function (){var statearr_32809 = state_32803;
(statearr_32809[(4)] = cljs.core.cons((5),(state_32803[(4)])));

return statearr_32809;
})();
var inst_32785__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_32786 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_32785__$1);
var state_32803__$1 = (function (){var statearr_32810 = state_32803;
(statearr_32810[(7)] = inst_32785__$1);

return statearr_32810;
})();
if(cljs.core.truth_(inst_32786)){
var statearr_32811_32861 = state_32803__$1;
(statearr_32811_32861[(1)] = (6));

} else {
var statearr_32812_32862 = state_32803__$1;
(statearr_32812_32862[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32804 === (9))){
var inst_32795 = (state_32803[(2)]);
var inst_32796 = fluree.db.util.async.throw_err(inst_32795);
var state_32803__$1 = state_32803;
var statearr_32813_32863 = state_32803__$1;
(statearr_32813_32863[(2)] = inst_32796);

(statearr_32813_32863[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32804 === (5))){
var _ = (function (){var statearr_32814 = state_32803;
(statearr_32814[(4)] = cljs.core.rest((state_32803[(4)])));

return statearr_32814;
})();
var state_32803__$1 = state_32803;
var ex32808 = (state_32803__$1[(2)]);
var statearr_32815_32864 = state_32803__$1;
(statearr_32815_32864[(5)] = ex32808);


if((ex32808 instanceof Error)){
var statearr_32816_32865 = state_32803__$1;
(statearr_32816_32865[(1)] = (4));

(statearr_32816_32865[(5)] = null);

} else {
throw ex32808;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32804 === (10))){
var inst_32791 = (state_32803[(2)]);
var inst_32792 = fluree.db.util.async.throw_err(inst_32791);
var inst_32793 = fluree.db.dbproto._lookup_leaf_after(inst_32792,flake);
var state_32803__$1 = state_32803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32803__$1,(9),inst_32793);
} else {
if((state_val_32804 === (8))){
var inst_32798 = (state_32803[(2)]);
var _ = (function (){var statearr_32817 = state_32803;
(statearr_32817[(4)] = cljs.core.rest((state_32803[(4)])));

return statearr_32817;
})();
var state_32803__$1 = state_32803;
var statearr_32818_32866 = state_32803__$1;
(statearr_32818_32866[(2)] = inst_32798);

(statearr_32818_32866[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__16153__auto__ = null;
var fluree$db$index$state_machine__16153__auto____0 = (function (){
var statearr_32819 = [null,null,null,null,null,null,null,null];
(statearr_32819[(0)] = fluree$db$index$state_machine__16153__auto__);

(statearr_32819[(1)] = (1));

return statearr_32819;
});
var fluree$db$index$state_machine__16153__auto____1 = (function (state_32803){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_32803);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e32820){var ex__16156__auto__ = e32820;
var statearr_32821_32867 = state_32803;
(statearr_32821_32867[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_32803[(4)]))){
var statearr_32822_32868 = state_32803;
(statearr_32822_32868[(1)] = cljs.core.first((state_32803[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__32869 = state_32803;
state_32803 = G__32869;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$index$state_machine__16153__auto__ = function(state_32803){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16153__auto____1.call(this,state_32803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16153__auto____0;
fluree$db$index$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16153__auto____1;
return fluree$db$index$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_32823 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_32823[(6)] = c__16227__auto__);

return statearr_32823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__32824 = (function (coll__4469__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__32824(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32718,other32719){
var self__ = this;
var this32718__$1 = this;
return (((!((other32719 == null)))) && ((((this32718__$1.constructor === other32719.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32718__$1.block,other32719.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32718__$1.t,other32719.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32718__$1.rhs,other32719.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32718__$1.children,other32719.children)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32718__$1.config,other32719.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32718__$1.leftmost_QMARK_,other32719.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32718__$1.__extmap,other32719.__extmap)))))))))))))))));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k32717){
var self__ = this;
var this__4479__auto____$1 = this;
var G__32825 = k32717;
var G__32825__$1 = (((G__32825 instanceof cljs.core.Keyword))?G__32825.fqn:null);
switch (G__32825__$1) {
case "block":
case "t":
case "rhs":
case "children":
case "config":
case "leftmost?":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k32717);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__32716){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__32826 = cljs.core.keyword_identical_QMARK_;
var expr__32827 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__32829 = cljs.core.cst$kw$block;
var G__32830 = expr__32827;
return (pred__32826.cljs$core$IFn$_invoke$arity$2 ? pred__32826.cljs$core$IFn$_invoke$arity$2(G__32829,G__32830) : pred__32826.call(null,G__32829,G__32830));
})())){
return (new fluree.db.index.IndexNode(G__32716,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32831 = cljs.core.cst$kw$t;
var G__32832 = expr__32827;
return (pred__32826.cljs$core$IFn$_invoke$arity$2 ? pred__32826.cljs$core$IFn$_invoke$arity$2(G__32831,G__32832) : pred__32826.call(null,G__32831,G__32832));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__32716,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32833 = cljs.core.cst$kw$rhs;
var G__32834 = expr__32827;
return (pred__32826.cljs$core$IFn$_invoke$arity$2 ? pred__32826.cljs$core$IFn$_invoke$arity$2(G__32833,G__32834) : pred__32826.call(null,G__32833,G__32834));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__32716,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32835 = cljs.core.cst$kw$children;
var G__32836 = expr__32827;
return (pred__32826.cljs$core$IFn$_invoke$arity$2 ? pred__32826.cljs$core$IFn$_invoke$arity$2(G__32835,G__32836) : pred__32826.call(null,G__32835,G__32836));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__32716,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32837 = cljs.core.cst$kw$config;
var G__32838 = expr__32827;
return (pred__32826.cljs$core$IFn$_invoke$arity$2 ? pred__32826.cljs$core$IFn$_invoke$arity$2(G__32837,G__32838) : pred__32826.call(null,G__32837,G__32838));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__32716,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32839 = cljs.core.cst$kw$leftmost_QMARK_;
var G__32840 = expr__32827;
return (pred__32826.cljs$core$IFn$_invoke$arity$2 ? pred__32826.cljs$core$IFn$_invoke$arity$2(G__32839,G__32840) : pred__32826.call(null,G__32839,G__32840));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__32716,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__32716),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__32716){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__32716,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__32720){
var extmap__4512__auto__ = (function (){var G__32841 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32720,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__32720)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32841);
} else {
return G__32841;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__32720),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__32720),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__32720),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__32720),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__32720),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__32720),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k32872,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__32876 = k32872;
var G__32876__$1 = (((G__32876 instanceof cljs.core.Keyword))?G__32876.fqn:null);
switch (G__32876__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32872,else__4475__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__32877){
var vec__32878 = p__32877;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32878,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32878,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32871){
var self__ = this;
var G__32871__$1 = this;
return (new cljs.core.RecordIter((0),G__32871__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_32882){
var state_val_32883 = (state_32882[(1)]);
if((state_val_32883 === (1))){
var state_32882__$1 = state_32882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32882__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__16153__auto__ = null;
var fluree$db$index$state_machine__16153__auto____0 = (function (){
var statearr_32884 = [null,null,null,null,null,null,null];
(statearr_32884[(0)] = fluree$db$index$state_machine__16153__auto__);

(statearr_32884[(1)] = (1));

return statearr_32884;
});
var fluree$db$index$state_machine__16153__auto____1 = (function (state_32882){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_32882);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e32885){var ex__16156__auto__ = e32885;
var statearr_32886_32918 = state_32882;
(statearr_32886_32918[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_32882[(4)]))){
var statearr_32887_32919 = state_32882;
(statearr_32887_32919[(1)] = cljs.core.first((state_32882[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__32920 = state_32882;
state_32882 = G__32920;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$index$state_machine__16153__auto__ = function(state_32882){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16153__auto____1.call(this,state_32882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16153__auto____0;
fluree$db$index$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16153__auto____1;
return fluree$db$index$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_32888 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_32888[(6)] = c__16227__auto__);

return statearr_32888;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_32894){
var state_val_32895 = (state_32894[(1)]);
if((state_val_32895 === (1))){
var inst_32889 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32890 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_32891 = cljs.core.PersistentHashMap.fromArrays(inst_32889,inst_32890);
var inst_32892 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_32891);
var state_32894__$1 = state_32894;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32894__$1,inst_32892);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__16153__auto__ = null;
var fluree$db$index$state_machine__16153__auto____0 = (function (){
var statearr_32896 = [null,null,null,null,null,null,null];
(statearr_32896[(0)] = fluree$db$index$state_machine__16153__auto__);

(statearr_32896[(1)] = (1));

return statearr_32896;
});
var fluree$db$index$state_machine__16153__auto____1 = (function (state_32894){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_32894);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e32897){var ex__16156__auto__ = e32897;
var statearr_32898_32921 = state_32894;
(statearr_32898_32921[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_32894[(4)]))){
var statearr_32899_32922 = state_32894;
(statearr_32899_32922[(1)] = cljs.core.first((state_32894[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__32923 = state_32894;
state_32894 = G__32923;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$index$state_machine__16153__auto__ = function(state_32894){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16153__auto____1.call(this,state_32894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16153__auto____0;
fluree$db$index$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16153__auto____1;
return fluree$db$index$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_32900 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_32900[(6)] = c__16227__auto__);

return statearr_32900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__32901 = (function (coll__4469__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__32901(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32873,other32874){
var self__ = this;
var this32873__$1 = this;
return (((!((other32874 == null)))) && ((((this32873__$1.constructor === other32874.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32873__$1.block,other32874.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32873__$1.t,other32874.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32873__$1.flakes,other32874.flakes)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32873__$1.rhs,other32874.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32873__$1.config,other32874.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32873__$1.__extmap,other32874.__extmap)))))))))))))));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k32872){
var self__ = this;
var this__4479__auto____$1 = this;
var G__32902 = k32872;
var G__32902__$1 = (((G__32902 instanceof cljs.core.Keyword))?G__32902.fqn:null);
switch (G__32902__$1) {
case "block":
case "t":
case "flakes":
case "rhs":
case "config":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k32872);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__32871){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__32903 = cljs.core.keyword_identical_QMARK_;
var expr__32904 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__32906 = cljs.core.cst$kw$block;
var G__32907 = expr__32904;
return (pred__32903.cljs$core$IFn$_invoke$arity$2 ? pred__32903.cljs$core$IFn$_invoke$arity$2(G__32906,G__32907) : pred__32903.call(null,G__32906,G__32907));
})())){
return (new fluree.db.index.DataNode(G__32871,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32908 = cljs.core.cst$kw$t;
var G__32909 = expr__32904;
return (pred__32903.cljs$core$IFn$_invoke$arity$2 ? pred__32903.cljs$core$IFn$_invoke$arity$2(G__32908,G__32909) : pred__32903.call(null,G__32908,G__32909));
})())){
return (new fluree.db.index.DataNode(self__.block,G__32871,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32910 = cljs.core.cst$kw$flakes;
var G__32911 = expr__32904;
return (pred__32903.cljs$core$IFn$_invoke$arity$2 ? pred__32903.cljs$core$IFn$_invoke$arity$2(G__32910,G__32911) : pred__32903.call(null,G__32910,G__32911));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__32871,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32912 = cljs.core.cst$kw$rhs;
var G__32913 = expr__32904;
return (pred__32903.cljs$core$IFn$_invoke$arity$2 ? pred__32903.cljs$core$IFn$_invoke$arity$2(G__32912,G__32913) : pred__32903.call(null,G__32912,G__32913));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__32871,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32914 = cljs.core.cst$kw$config;
var G__32915 = expr__32904;
return (pred__32903.cljs$core$IFn$_invoke$arity$2 ? pred__32903.cljs$core$IFn$_invoke$arity$2(G__32914,G__32915) : pred__32903.call(null,G__32914,G__32915));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__32871,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__32871),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__32871){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__32871,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__32875){
var extmap__4512__auto__ = (function (){var G__32916 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32875,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__32875)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32916);
} else {
return G__32916;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__32875),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__32875),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__32875),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__32875),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__32875),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
