// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__41714 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41714,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41714,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41714,(2),null);
if(cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__41717){
var map__41718 = p__41717;
var map__41718__$1 = cljs.core.__destructure_map(map__41718);
var opts = map__41718__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41718__$1,cljs.core.cst$kw$reindex_QMARK_);
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_41778){
var state_val_41779 = (state_41778[(1)]);
if((state_val_41779 === (7))){
var inst_41749 = cljs.core.not(reindex_QMARK_);
var state_41778__$1 = state_41778;
var statearr_41780_41804 = state_41778__$1;
(statearr_41780_41804[(2)] = inst_41749);

(statearr_41780_41804[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (1))){
var state_41778__$1 = state_41778;
var statearr_41781_41805 = state_41778__$1;
(statearr_41781_41805[(2)] = null);

(statearr_41781_41805[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (4))){
var inst_41719 = (state_41778[(2)]);
var state_41778__$1 = state_41778;
var statearr_41782_41806 = state_41778__$1;
(statearr_41782_41806[(2)] = inst_41719);

(statearr_41782_41806[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (6))){
var inst_41747 = (state_41778[(7)]);
var inst_41739 = (state_41778[(8)]);
var inst_41733 = (state_41778[(9)]);
var inst_41732 = (state_41778[(2)]);
var inst_41733__$1 = fluree.db.util.async.throw_err(inst_41732);
var inst_41734 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_41735 = cljs.core.__destructure_map(inst_41734);
var inst_41736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41735,cljs.core.cst$kw$post);
var inst_41737 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41735,cljs.core.cst$kw$size);
var inst_41738 = fluree.db.flake.size_bytes(inst_41733__$1);
var inst_41739__$1 = (inst_41737 + inst_41738);
var inst_41740 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41741 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_41742 = (new cljs.core.PersistentVector(null,2,(5),inst_41740,inst_41741,null));
var inst_41743 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_41742);
var inst_41744 = cljs.core.__destructure_map(inst_41743);
var inst_41745 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41744,cljs.core.cst$kw$novelty_DASH_min);
var inst_41746 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41744,cljs.core.cst$kw$novelty_DASH_max);
var inst_41747__$1 = (inst_41739__$1 > inst_41746);
var state_41778__$1 = (function (){var statearr_41783 = state_41778;
(statearr_41783[(7)] = inst_41747__$1);

(statearr_41783[(10)] = inst_41736);

(statearr_41783[(8)] = inst_41739__$1);

(statearr_41783[(11)] = inst_41745);

(statearr_41783[(9)] = inst_41733__$1);

return statearr_41783;
})();
if(cljs.core.truth_(inst_41747__$1)){
var statearr_41784_41807 = state_41778__$1;
(statearr_41784_41807[(1)] = (7));

} else {
var statearr_41785_41808 = state_41778__$1;
(statearr_41785_41808[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (3))){
var inst_41776 = (state_41778[(2)]);
var state_41778__$1 = state_41778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41778__$1,inst_41776);
} else {
if((state_val_41779 === (12))){
var inst_41736 = (state_41778[(10)]);
var inst_41739 = (state_41778[(8)]);
var inst_41733 = (state_41778[(9)]);
var inst_41762 = (state_41778[(2)]);
var inst_41763 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41736,inst_41733);
var inst_41764 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_41765 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_41764,cljs.core.empty);
var inst_41766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41767 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_41768 = (new cljs.core.PersistentVector(null,2,(5),inst_41766,inst_41767,null));
var inst_41769 = cljs.core.assoc_in(db,inst_41768,inst_41763);
var inst_41770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41771 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_41772 = (new cljs.core.PersistentVector(null,2,(5),inst_41770,inst_41771,null));
var inst_41773 = cljs.core.assoc_in(inst_41769,inst_41772,inst_41739);
var _ = (function (){var statearr_41786 = state_41778;
(statearr_41786[(4)] = cljs.core.rest((state_41778[(4)])));

return statearr_41786;
})();
var state_41778__$1 = (function (){var statearr_41787 = state_41778;
(statearr_41787[(12)] = inst_41765);

(statearr_41787[(13)] = inst_41762);

return statearr_41787;
})();
var statearr_41788_41809 = state_41778__$1;
(statearr_41788_41809[(2)] = inst_41773);

(statearr_41788_41809[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (2))){
var _ = (function (){var statearr_41789 = state_41778;
(statearr_41789[(4)] = cljs.core.cons((5),(state_41778[(4)])));

return statearr_41789;
})();
var inst_41727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41728 = [pred_id];
var inst_41729 = (new cljs.core.PersistentVector(null,1,(5),inst_41727,inst_41728,null));
var inst_41730 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_41729);
var state_41778__$1 = state_41778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41778__$1,(6),inst_41730);
} else {
if((state_val_41779 === (11))){
var state_41778__$1 = state_41778;
var statearr_41791_41810 = state_41778__$1;
(statearr_41791_41810[(2)] = null);

(statearr_41791_41810[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (9))){
var inst_41752 = (state_41778[(2)]);
var state_41778__$1 = state_41778;
if(cljs.core.truth_(inst_41752)){
var statearr_41792_41811 = state_41778__$1;
(statearr_41792_41811[(1)] = (10));

} else {
var statearr_41793_41812 = state_41778__$1;
(statearr_41793_41812[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (5))){
var _ = (function (){var statearr_41794 = state_41778;
(statearr_41794[(4)] = cljs.core.rest((state_41778[(4)])));

return statearr_41794;
})();
var state_41778__$1 = state_41778;
var ex41790 = (state_41778__$1[(2)]);
var statearr_41795_41813 = state_41778__$1;
(statearr_41795_41813[(5)] = ex41790);


if((ex41790 instanceof Error)){
var statearr_41796_41814 = state_41778__$1;
(statearr_41796_41814[(1)] = (4));

(statearr_41796_41814[(5)] = null);

} else {
throw ex41790;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (10))){
var inst_41754 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_41755 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_41756 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_41757 = cljs.core.PersistentHashMap.fromArrays(inst_41755,inst_41756);
var inst_41758 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41754,inst_41757);
var inst_41759 = (function(){throw inst_41758})();
var state_41778__$1 = state_41778;
var statearr_41797_41815 = state_41778__$1;
(statearr_41797_41815[(2)] = inst_41759);

(statearr_41797_41815[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (8))){
var inst_41747 = (state_41778[(7)]);
var state_41778__$1 = state_41778;
var statearr_41798_41816 = state_41778__$1;
(statearr_41798_41816[(2)] = inst_41747);

(statearr_41798_41816[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16153__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16153__auto____0 = (function (){
var statearr_41799 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41799[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16153__auto__);

(statearr_41799[(1)] = (1));

return statearr_41799;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16153__auto____1 = (function (state_41778){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_41778);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e41800){var ex__16156__auto__ = e41800;
var statearr_41801_41817 = state_41778;
(statearr_41801_41817[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_41778[(4)]))){
var statearr_41802_41818 = state_41778;
(statearr_41802_41818[(1)] = cljs.core.first((state_41778[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__41819 = state_41778;
state_41778 = G__41819;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16153__auto__ = function(state_41778){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16153__auto____1.call(this,state_41778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16153__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16153__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_41803 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_41803[(6)] = c__16227__auto__);

return statearr_41803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__41824 = arguments.length;
switch (G__41824) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_42020){
var state_val_42021 = (state_42020[(1)]);
if((state_val_42021 === (7))){
var state_42020__$1 = state_42020;
var statearr_42022_42090 = state_42020__$1;
(statearr_42022_42090[(2)] = null);

(statearr_42022_42090[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (20))){
var inst_41943 = (state_42020[(7)]);
var inst_41862 = (state_42020[(8)]);
var inst_41863 = (state_42020[(9)]);
var inst_41945 = (state_42020[(10)]);
var inst_41913 = (state_42020[(11)]);
var inst_41942 = (state_42020[(12)]);
var inst_41944 = (state_42020[(13)]);
var inst_41946 = (state_42020[(14)]);
var inst_41956 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_41957 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41958 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_41959 = (new cljs.core.PersistentVector(null,2,(5),inst_41957,inst_41958,null));
var inst_41960 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_41913,inst_41959);
var inst_41961 = (inst_41862 + inst_41960);
var inst_41962 = [inst_41942,inst_41943,inst_41944,inst_41945,inst_41961];
var inst_41963 = cljs.core.PersistentHashMap.fromArrays(inst_41956,inst_41962);
var inst_41964 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_41913,cljs.core.cst$kw$ecount,inst_41946,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_41963], 0));
var state_42020__$1 = (function (){var statearr_42023 = state_42020;
(statearr_42023[(15)] = inst_41964);

return statearr_42023;
})();
if(cljs.core.truth_(inst_41863)){
var statearr_42024_42091 = state_42020__$1;
(statearr_42024_42091[(1)] = (23));

} else {
var statearr_42025_42092 = state_42020__$1;
(statearr_42025_42092[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (27))){
var inst_41964 = (state_42020[(15)]);
var state_42020__$1 = state_42020;
var statearr_42026_42093 = state_42020__$1;
(statearr_42026_42093[(2)] = inst_41964);

(statearr_42026_42093[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (1))){
var state_42020__$1 = state_42020;
var statearr_42027_42094 = state_42020__$1;
(statearr_42027_42094[(2)] = null);

(statearr_42027_42094[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (24))){
var inst_41964 = (state_42020[(15)]);
var inst_41967 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_41964);
var inst_41968 = (inst_41967 == null);
var state_42020__$1 = state_42020;
var statearr_42028_42095 = state_42020__$1;
(statearr_42028_42095[(2)] = inst_41968);

(statearr_42028_42095[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (39))){
var inst_41994 = (state_42020[(16)]);
var inst_41995 = (state_42020[(17)]);
var inst_42003 = (state_42020[(18)]);
var inst_41996 = (state_42020[(19)]);
var inst_41953 = (state_42020[(20)]);
var inst_42010 = (state_42020[(2)]);
var inst_41941 = inst_41953;
var inst_41942 = inst_41995;
var inst_41943 = inst_41996;
var inst_41944 = inst_42003;
var inst_41945 = inst_42010;
var inst_41946 = inst_41994;
var state_42020__$1 = (function (){var statearr_42029 = state_42020;
(statearr_42029[(7)] = inst_41943);

(statearr_42029[(10)] = inst_41945);

(statearr_42029[(21)] = inst_41941);

(statearr_42029[(12)] = inst_41942);

(statearr_42029[(13)] = inst_41944);

(statearr_42029[(14)] = inst_41946);

return statearr_42029;
})();
var statearr_42030_42096 = state_42020__$1;
(statearr_42030_42096[(2)] = null);

(statearr_42030_42096[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (4))){
var inst_41825 = (state_42020[(2)]);
var state_42020__$1 = state_42020;
var statearr_42031_42097 = state_42020__$1;
(statearr_42031_42097[(2)] = inst_41825);

(statearr_42031_42097[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (15))){
var inst_41885 = (state_42020[(22)]);
var state_42020__$1 = state_42020;
var statearr_42032_42098 = state_42020__$1;
(statearr_42032_42098[(2)] = inst_41885);

(statearr_42032_42098[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (21))){
var inst_41952 = (state_42020[(23)]);
var inst_41943 = (state_42020[(7)]);
var inst_41849 = (state_42020[(24)]);
var inst_41862 = (state_42020[(8)]);
var inst_41866 = (state_42020[(25)]);
var inst_41847 = (state_42020[(26)]);
var inst_41872 = (state_42020[(27)]);
var inst_41863 = (state_42020[(9)]);
var inst_41832 = (state_42020[(28)]);
var inst_41922 = (state_42020[(29)]);
var inst_41945 = (state_42020[(10)]);
var inst_41941 = (state_42020[(21)]);
var inst_41864 = (state_42020[(30)]);
var inst_41853 = (state_42020[(31)]);
var inst_41857 = (state_42020[(32)]);
var inst_41913 = (state_42020[(11)]);
var inst_41942 = (state_42020[(12)]);
var inst_41944 = (state_42020[(13)]);
var inst_41923 = (state_42020[(33)]);
var inst_41861 = (state_42020[(34)]);
var inst_41946 = (state_42020[(14)]);
var inst_41953 = (state_42020[(20)]);
var inst_41991 = inst_41952.s;
var inst_41992 = fluree.db.flake.sid__GT_cid(inst_41991);
var inst_41993 = (function (){var flakes_bytes = inst_41862;
var t = inst_41832;
var spot = inst_41942;
var first__41920 = inst_41922;
var add_flakes = inst_41849;
var vec__41948 = inst_41941;
var root_setting_change_QMARK_ = inst_41864;
var ref_QMARK__map = inst_41861;
var r = inst_41953;
var psot = inst_41943;
var add_pred_to_idx_QMARK_ = inst_41872;
var G__41917 = inst_41941;
var _ = inst_41847;
var cid = inst_41992;
var ecount = inst_41946;
var pred_ecount = inst_41866;
var seq__41919 = inst_41923;
var db_STAR_ = inst_41913;
var schema_change_QMARK_ = inst_41863;
var seq__41949 = inst_41953;
var vec__41918 = inst_41849;
var add_preds = inst_41853;
var opst = inst_41945;
var idx_QMARK__map = inst_41857;
var first__41950 = inst_41952;
var post = inst_41944;
var f = inst_41952;
return (function (p1__41822_SHARP_){
if(cljs.core.truth_(p1__41822_SHARP_)){
var x__4306__auto__ = p1__41822_SHARP_;
var y__4307__auto__ = f.s;
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
} else {
return f.s;
}
});
})();
var inst_41994 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_41946,inst_41992,inst_41993);
var inst_41995 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41942,inst_41952);
var inst_41996 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41943,inst_41952);
var inst_41997 = inst_41952.p;
var inst_41998 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41857,inst_41997);
var state_42020__$1 = (function (){var statearr_42033 = state_42020;
(statearr_42033[(16)] = inst_41994);

(statearr_42033[(17)] = inst_41995);

(statearr_42033[(19)] = inst_41996);

return statearr_42033;
})();
if(cljs.core.truth_(inst_41998)){
var statearr_42034_42099 = state_42020__$1;
(statearr_42034_42099[(1)] = (34));

} else {
var statearr_42035_42100 = state_42020__$1;
(statearr_42035_42100[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (31))){
var inst_41979 = (state_42020[(35)]);
var state_42020__$1 = state_42020;
var statearr_42036_42101 = state_42020__$1;
(statearr_42036_42101[(2)] = inst_41979);

(statearr_42036_42101[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (32))){
var inst_41989 = (state_42020[(2)]);
var state_42020__$1 = state_42020;
var statearr_42037_42102 = state_42020__$1;
(statearr_42037_42102[(2)] = inst_41989);

(statearr_42037_42102[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (33))){
var inst_41979 = (state_42020[(35)]);
var inst_41984 = (state_42020[(2)]);
var inst_41985 = fluree.db.util.async.throw_err(inst_41984);
var inst_41986 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41979,cljs.core.cst$kw$settings,inst_41985);
var state_42020__$1 = state_42020;
var statearr_42038_42103 = state_42020__$1;
(statearr_42038_42103[(2)] = inst_41986);

(statearr_42038_42103[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (13))){
var inst_41849 = (state_42020[(24)]);
var inst_41862 = (state_42020[(8)]);
var inst_41832 = (state_42020[(28)]);
var inst_41913 = (state_42020[(11)]);
var inst_41903 = (state_42020[(2)]);
var inst_41904 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41903,cljs.core.cst$kw$t,inst_41832);
var inst_41905 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41906 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_41907 = (new cljs.core.PersistentVector(null,2,(5),inst_41905,inst_41906,null));
var inst_41908 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_41904,inst_41907,cljs.core._PLUS_,inst_41862);
var inst_41909 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41910 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_41911 = (new cljs.core.PersistentVector(null,2,(5),inst_41909,inst_41910,null));
var inst_41912 = cljs.core.count(inst_41849);
var inst_41913__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_41908,inst_41911,cljs.core._PLUS_,inst_41912);
var inst_41921 = cljs.core.seq(inst_41849);
var inst_41922 = cljs.core.first(inst_41921);
var inst_41923 = cljs.core.next(inst_41921);
var inst_41924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41925 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_41926 = (new cljs.core.PersistentVector(null,2,(5),inst_41924,inst_41925,null));
var inst_41927 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_41913__$1,inst_41926);
var inst_41928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41929 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_41930 = (new cljs.core.PersistentVector(null,2,(5),inst_41928,inst_41929,null));
var inst_41931 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_41913__$1,inst_41930);
var inst_41932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41933 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_41934 = (new cljs.core.PersistentVector(null,2,(5),inst_41932,inst_41933,null));
var inst_41935 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_41913__$1,inst_41934);
var inst_41936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41937 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_41938 = (new cljs.core.PersistentVector(null,2,(5),inst_41936,inst_41937,null));
var inst_41939 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_41913__$1,inst_41938);
var inst_41940 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_41941 = inst_41849;
var inst_41942 = inst_41927;
var inst_41943 = inst_41931;
var inst_41944 = inst_41935;
var inst_41945 = inst_41939;
var inst_41946 = inst_41940;
var state_42020__$1 = (function (){var statearr_42039 = state_42020;
(statearr_42039[(7)] = inst_41943);

(statearr_42039[(29)] = inst_41922);

(statearr_42039[(10)] = inst_41945);

(statearr_42039[(21)] = inst_41941);

(statearr_42039[(11)] = inst_41913__$1);

(statearr_42039[(12)] = inst_41942);

(statearr_42039[(13)] = inst_41944);

(statearr_42039[(33)] = inst_41923);

(statearr_42039[(14)] = inst_41946);

return statearr_42039;
})();
var statearr_42040_42104 = state_42020__$1;
(statearr_42040_42104[(2)] = null);

(statearr_42040_42104[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (22))){
var inst_42013 = (state_42020[(2)]);
var state_42020__$1 = state_42020;
var statearr_42041_42105 = state_42020__$1;
(statearr_42041_42105[(2)] = inst_42013);

(statearr_42041_42105[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (36))){
var inst_41952 = (state_42020[(23)]);
var inst_41861 = (state_42020[(34)]);
var inst_42003 = (state_42020[(2)]);
var inst_42004 = inst_41952.p;
var inst_42005 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41861,inst_42004);
var state_42020__$1 = (function (){var statearr_42042 = state_42020;
(statearr_42042[(18)] = inst_42003);

return statearr_42042;
})();
if(cljs.core.truth_(inst_42005)){
var statearr_42043_42106 = state_42020__$1;
(statearr_42043_42106[(1)] = (37));

} else {
var statearr_42044_42107 = state_42020__$1;
(statearr_42044_42107[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (29))){
var inst_41964 = (state_42020[(15)]);
var inst_41974 = (state_42020[(2)]);
var inst_41975 = fluree.db.util.async.throw_err(inst_41974);
var inst_41976 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41964,cljs.core.cst$kw$schema,inst_41975);
var state_42020__$1 = state_42020;
var statearr_42045_42108 = state_42020__$1;
(statearr_42045_42108[(2)] = inst_41976);

(statearr_42045_42108[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (6))){
var inst_41832 = (state_42020[(28)]);
var inst_41837 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_41838 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_41839 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41837)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41838)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41832),"."].join('');
var inst_41840 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41841 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_41842 = cljs.core.PersistentHashMap.fromArrays(inst_41840,inst_41841);
var inst_41843 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41839,inst_41842);
var inst_41844 = (function(){throw inst_41843})();
var state_42020__$1 = state_42020;
var statearr_42046_42109 = state_42020__$1;
(statearr_42046_42109[(2)] = inst_41844);

(statearr_42046_42109[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (28))){
var inst_41864 = (state_42020[(30)]);
var inst_41979 = (state_42020[(2)]);
var state_42020__$1 = (function (){var statearr_42047 = state_42020;
(statearr_42047[(35)] = inst_41979);

return statearr_42047;
})();
if(cljs.core.truth_(inst_41864)){
var statearr_42048_42110 = state_42020__$1;
(statearr_42048_42110[(1)] = (30));

} else {
var statearr_42049_42111 = state_42020__$1;
(statearr_42049_42111[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (25))){
var inst_41970 = (state_42020[(2)]);
var state_42020__$1 = state_42020;
if(cljs.core.truth_(inst_41970)){
var statearr_42050_42112 = state_42020__$1;
(statearr_42050_42112[(1)] = (26));

} else {
var statearr_42051_42113 = state_42020__$1;
(statearr_42051_42113[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (34))){
var inst_41952 = (state_42020[(23)]);
var inst_41944 = (state_42020[(13)]);
var inst_42000 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41944,inst_41952);
var state_42020__$1 = state_42020;
var statearr_42052_42114 = state_42020__$1;
(statearr_42052_42114[(2)] = inst_42000);

(statearr_42052_42114[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (17))){
var inst_41892 = (state_42020[(36)]);
var inst_41896 = (state_42020[(2)]);
var inst_41897 = fluree.db.util.async.throw_err(inst_41896);
var inst_41884 = inst_41892;
var inst_41885 = inst_41897;
var state_42020__$1 = (function (){var statearr_42053 = state_42020;
(statearr_42053[(37)] = inst_41884);

(statearr_42053[(22)] = inst_41885);

return statearr_42053;
})();
var statearr_42054_42115 = state_42020__$1;
(statearr_42054_42115[(2)] = null);

(statearr_42054_42115[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (3))){
var inst_42018 = (state_42020[(2)]);
var state_42020__$1 = state_42020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42020__$1,inst_42018);
} else {
if((state_val_42021 === (12))){
var inst_41891 = (state_42020[(38)]);
var inst_41884 = (state_42020[(37)]);
var inst_41890 = cljs.core.seq(inst_41884);
var inst_41891__$1 = cljs.core.first(inst_41890);
var inst_41892 = cljs.core.next(inst_41890);
var state_42020__$1 = (function (){var statearr_42055 = state_42020;
(statearr_42055[(38)] = inst_41891__$1);

(statearr_42055[(36)] = inst_41892);

return statearr_42055;
})();
if(cljs.core.truth_(inst_41891__$1)){
var statearr_42056_42116 = state_42020__$1;
(statearr_42056_42116[(1)] = (14));

} else {
var statearr_42057_42117 = state_42020__$1;
(statearr_42057_42117[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (2))){
var inst_41832 = (state_42020[(28)]);
var _ = (function (){var statearr_42058 = state_42020;
(statearr_42058[(4)] = cljs.core.cons((5),(state_42020[(4)])));

return statearr_42058;
})();
var inst_41831 = cljs.core.first(flakes);
var inst_41832__$1 = inst_41831.t;
var inst_41833 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_41834 = (inst_41833 - (1));
var inst_41835 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_41832__$1,inst_41834);
var state_42020__$1 = (function (){var statearr_42059 = state_42020;
(statearr_42059[(28)] = inst_41832__$1);

return statearr_42059;
})();
if(inst_41835){
var statearr_42060_42118 = state_42020__$1;
(statearr_42060_42118[(1)] = (6));

} else {
var statearr_42061_42119 = state_42020__$1;
(statearr_42061_42119[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (23))){
var inst_41863 = (state_42020[(9)]);
var state_42020__$1 = state_42020;
var statearr_42062_42120 = state_42020__$1;
(statearr_42062_42120[(2)] = inst_41863);

(statearr_42062_42120[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (35))){
var inst_41944 = (state_42020[(13)]);
var state_42020__$1 = state_42020;
var statearr_42063_42121 = state_42020__$1;
(statearr_42063_42121[(2)] = inst_41944);

(statearr_42063_42121[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (19))){
var inst_42015 = (state_42020[(2)]);
var _ = (function (){var statearr_42064 = state_42020;
(statearr_42064[(4)] = cljs.core.rest((state_42020[(4)])));

return statearr_42064;
})();
var state_42020__$1 = state_42020;
var statearr_42065_42122 = state_42020__$1;
(statearr_42065_42122[(2)] = inst_42015);

(statearr_42065_42122[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (11))){
var inst_41872 = (state_42020[(27)]);
var inst_41872__$1 = (state_42020[(2)]);
var inst_41880 = cljs.core.seq(inst_41872__$1);
var inst_41881 = cljs.core.first(inst_41880);
var inst_41882 = cljs.core.next(inst_41880);
var inst_41883 = db;
var inst_41884 = inst_41872__$1;
var inst_41885 = inst_41883;
var state_42020__$1 = (function (){var statearr_42067 = state_42020;
(statearr_42067[(27)] = inst_41872__$1);

(statearr_42067[(37)] = inst_41884);

(statearr_42067[(39)] = inst_41882);

(statearr_42067[(22)] = inst_41885);

(statearr_42067[(40)] = inst_41881);

return statearr_42067;
})();
var statearr_42068_42123 = state_42020__$1;
(statearr_42068_42123[(2)] = null);

(statearr_42068_42123[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (9))){
var inst_41849 = (state_42020[(24)]);
var inst_41866 = (state_42020[(25)]);
var inst_41868 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_41849,inst_41866);
var state_42020__$1 = state_42020;
var statearr_42069_42124 = state_42020__$1;
(statearr_42069_42124[(2)] = inst_41868);

(statearr_42069_42124[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (5))){
var _ = (function (){var statearr_42070 = state_42020;
(statearr_42070[(4)] = cljs.core.rest((state_42020[(4)])));

return statearr_42070;
})();
var state_42020__$1 = state_42020;
var ex42066 = (state_42020__$1[(2)]);
var statearr_42071_42125 = state_42020__$1;
(statearr_42071_42125[(5)] = ex42066);


if((ex42066 instanceof Error)){
var statearr_42072_42126 = state_42020__$1;
(statearr_42072_42126[(1)] = (4));

(statearr_42072_42126[(5)] = null);

} else {
throw ex42066;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (14))){
var inst_41891 = (state_42020[(38)]);
var inst_41885 = (state_42020[(22)]);
var inst_41894 = fluree.db.graphdb.add_predicate_to_idx(inst_41885,inst_41891,opts);
var state_42020__$1 = state_42020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42020__$1,(17),inst_41894);
} else {
if((state_val_42021 === (26))){
var inst_41964 = (state_42020[(15)]);
var inst_41972 = fluree.db.query.schema.schema_map(inst_41964);
var state_42020__$1 = state_42020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42020__$1,(29),inst_41972);
} else {
if((state_val_42021 === (16))){
var inst_41901 = (state_42020[(2)]);
var state_42020__$1 = state_42020;
var statearr_42073_42127 = state_42020__$1;
(statearr_42073_42127[(2)] = inst_41901);

(statearr_42073_42127[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (38))){
var inst_41945 = (state_42020[(10)]);
var state_42020__$1 = state_42020;
var statearr_42074_42128 = state_42020__$1;
(statearr_42074_42128[(2)] = inst_41945);

(statearr_42074_42128[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (30))){
var inst_41979 = (state_42020[(35)]);
var inst_41982 = fluree.db.query.schema.setting_map(inst_41979);
var state_42020__$1 = state_42020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42020__$1,(33),inst_41982);
} else {
if((state_val_42021 === (10))){
var inst_41870 = cljs.core.PersistentVector.EMPTY;
var state_42020__$1 = state_42020;
var statearr_42075_42129 = state_42020__$1;
(statearr_42075_42129[(2)] = inst_41870);

(statearr_42075_42129[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (18))){
var inst_41952 = (state_42020[(23)]);
var inst_41941 = (state_42020[(21)]);
var inst_41951 = cljs.core.seq(inst_41941);
var inst_41952__$1 = cljs.core.first(inst_41951);
var inst_41953 = cljs.core.next(inst_41951);
var inst_41954 = cljs.core.not(inst_41952__$1);
var state_42020__$1 = (function (){var statearr_42076 = state_42020;
(statearr_42076[(23)] = inst_41952__$1);

(statearr_42076[(20)] = inst_41953);

return statearr_42076;
})();
if(inst_41954){
var statearr_42077_42130 = state_42020__$1;
(statearr_42077_42130[(1)] = (20));

} else {
var statearr_42078_42131 = state_42020__$1;
(statearr_42078_42131[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (37))){
var inst_41952 = (state_42020[(23)]);
var inst_41945 = (state_42020[(10)]);
var inst_42007 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41945,inst_41952);
var state_42020__$1 = state_42020;
var statearr_42079_42132 = state_42020__$1;
(statearr_42079_42132[(2)] = inst_42007);

(statearr_42079_42132[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42021 === (8))){
var inst_41849 = (state_42020[(24)]);
var inst_41847 = (state_42020[(26)]);
var inst_41863 = (state_42020[(9)]);
var inst_41832 = (state_42020[(28)]);
var inst_41853 = (state_42020[(31)]);
var inst_41857 = (state_42020[(32)]);
var inst_41847__$1 = (state_42020[(2)]);
var inst_41848 = (function (){var t = inst_41832;
var _ = inst_41847__$1;
return (function (p1__41820_SHARP_){
return cljs.core.not((function (){var G__42080 = p1__41820_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__42080) : fluree.db.graphdb.exclude_predicates.call(null,G__42080));
})());
});
})();
var inst_41849__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_41848,flakes);
var inst_41850 = cljs.core.PersistentHashSet.EMPTY;
var inst_41851 = (function (){var t = inst_41832;
var _ = inst_41847__$1;
var add_flakes = inst_41849__$1;
return (function (p1__41821_SHARP_){
return p1__41821_SHARP_.p;
});
})();
var inst_41852 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_41851,inst_41849__$1);
var inst_41853__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41850,inst_41852);
var inst_41854 = cljs.core.PersistentHashMap.EMPTY;
var inst_41855 = (function (){var t = inst_41832;
var _ = inst_41847__$1;
var add_flakes = inst_41849__$1;
var add_preds = inst_41853__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_41856 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_41855,inst_41853__$1);
var inst_41857__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41854,inst_41856);
var inst_41858 = cljs.core.PersistentHashMap.EMPTY;
var inst_41859 = (function (){var t = inst_41832;
var _ = inst_41847__$1;
var add_flakes = inst_41849__$1;
var add_preds = inst_41853__$1;
var idx_QMARK__map = inst_41857__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_41860 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_41859,inst_41853__$1);
var inst_41861 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41858,inst_41860);
var inst_41862 = fluree.db.flake.size_bytes(inst_41849__$1);
var inst_41863__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_41849__$1);
var inst_41864 = fluree.db.util.schema.setting_change_QMARK_(inst_41849__$1);
var inst_41865 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_41866 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41865,(0));
var state_42020__$1 = (function (){var statearr_42081 = state_42020;
(statearr_42081[(24)] = inst_41849__$1);

(statearr_42081[(8)] = inst_41862);

(statearr_42081[(25)] = inst_41866);

(statearr_42081[(26)] = inst_41847__$1);

(statearr_42081[(9)] = inst_41863__$1);

(statearr_42081[(30)] = inst_41864);

(statearr_42081[(31)] = inst_41853__$1);

(statearr_42081[(32)] = inst_41857__$1);

(statearr_42081[(34)] = inst_41861);

return statearr_42081;
})();
if(cljs.core.truth_(inst_41863__$1)){
var statearr_42082_42133 = state_42020__$1;
(statearr_42082_42133[(1)] = (9));

} else {
var statearr_42083_42134 = state_42020__$1;
(statearr_42083_42134[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16153__auto__ = null;
var fluree$db$graphdb$state_machine__16153__auto____0 = (function (){
var statearr_42084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42084[(0)] = fluree$db$graphdb$state_machine__16153__auto__);

(statearr_42084[(1)] = (1));

return statearr_42084;
});
var fluree$db$graphdb$state_machine__16153__auto____1 = (function (state_42020){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_42020);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e42085){var ex__16156__auto__ = e42085;
var statearr_42086_42135 = state_42020;
(statearr_42086_42135[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_42020[(4)]))){
var statearr_42087_42136 = state_42020;
(statearr_42087_42136[(1)] = cljs.core.first((state_42020[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__42137 = state_42020;
state_42020 = G__42137;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16153__auto__ = function(state_42020){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16153__auto____1.call(this,state_42020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16153__auto____0;
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16153__auto____1;
return fluree$db$graphdb$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_42088 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_42088[(6)] = c__16227__auto__);

return statearr_42088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__42139 = arguments.length;
switch (G__42139) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16227__auto___42286 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_42235){
var state_val_42236 = (state_42235[(1)]);
if((state_val_42236 === (7))){
var state_42235__$1 = state_42235;
var statearr_42237_42287 = state_42235__$1;
(statearr_42237_42287[(2)] = null);

(statearr_42237_42287[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (20))){
var inst_42184 = (state_42235[(7)]);
var inst_42185 = (state_42235[(8)]);
var inst_42183 = (state_42235[(9)]);
var inst_42204 = (inst_42183 + (1));
var inst_42205 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42185,cljs.core.cst$kw$t,inst_42204);
var inst_42206 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_42205,inst_42184,opts);
var state_42235__$1 = state_42235;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42235__$1,(23),inst_42206);
} else {
if((state_val_42236 === (1))){
var state_42235__$1 = state_42235;
var statearr_42238_42288 = state_42235__$1;
(statearr_42238_42288[(2)] = null);

(statearr_42238_42288[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (24))){
var inst_42209 = (state_42235[(10)]);
var inst_42212 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42209,cljs.core.cst$kw$block,block);
var state_42235__$1 = state_42235;
var statearr_42239_42289 = state_42235__$1;
(statearr_42239_42289[(2)] = inst_42212);

(statearr_42239_42289[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (4))){
var inst_42140 = (state_42235[(2)]);
var inst_42141 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_42140);
var state_42235__$1 = state_42235;
var statearr_42240_42290 = state_42235__$1;
(statearr_42240_42290[(2)] = inst_42141);

(statearr_42240_42290[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (15))){
var inst_42191 = (state_42235[(11)]);
var state_42235__$1 = state_42235;
var statearr_42241_42291 = state_42235__$1;
(statearr_42241_42291[(2)] = inst_42191);

(statearr_42241_42291[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (21))){
var state_42235__$1 = state_42235;
var statearr_42242_42292 = state_42235__$1;
(statearr_42242_42292[(2)] = null);

(statearr_42242_42292[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (13))){
var inst_42227 = (state_42235[(2)]);
var inst_42228 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_42227);
var state_42235__$1 = state_42235;
var statearr_42243_42293 = state_42235__$1;
(statearr_42243_42293[(2)] = inst_42228);

(statearr_42243_42293[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (22))){
var inst_42223 = (state_42235[(2)]);
var state_42235__$1 = state_42235;
var statearr_42244_42294 = state_42235__$1;
(statearr_42244_42294[(2)] = inst_42223);

(statearr_42244_42294[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (6))){
var inst_42151 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_42152 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_42153 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42151)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42152)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_42154 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42155 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_42156 = cljs.core.PersistentHashMap.fromArrays(inst_42154,inst_42155);
var inst_42157 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42153,inst_42156);
var inst_42158 = (function(){throw inst_42157})();
var state_42235__$1 = state_42235;
var statearr_42247_42295 = state_42235__$1;
(statearr_42247_42295[(2)] = inst_42158);

(statearr_42247_42295[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (25))){
var inst_42209 = (state_42235[(10)]);
var inst_42191 = (state_42235[(11)]);
var inst_42192 = (state_42235[(12)]);
var inst_42214 = inst_42191.t;
var inst_42215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42216 = [inst_42191];
var inst_42217 = (new cljs.core.PersistentVector(null,1,(5),inst_42215,inst_42216,null));
var inst_42182 = inst_42192;
var inst_42183 = inst_42214;
var inst_42184 = inst_42217;
var inst_42185 = inst_42209;
var state_42235__$1 = (function (){var statearr_42248 = state_42235;
(statearr_42248[(13)] = inst_42182);

(statearr_42248[(7)] = inst_42184);

(statearr_42248[(8)] = inst_42185);

(statearr_42248[(9)] = inst_42183);

return statearr_42248;
})();
var statearr_42249_42296 = state_42235__$1;
(statearr_42249_42296[(2)] = null);

(statearr_42249_42296[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (17))){
var inst_42184 = (state_42235[(7)]);
var inst_42185 = (state_42235[(8)]);
var inst_42191 = (state_42235[(11)]);
var inst_42192 = (state_42235[(12)]);
var inst_42183 = (state_42235[(9)]);
var inst_42200 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42184,inst_42191);
var tmp42245 = inst_42185;
var tmp42246 = inst_42183;
var inst_42182 = inst_42192;
var inst_42183__$1 = tmp42246;
var inst_42184__$1 = inst_42200;
var inst_42185__$1 = tmp42245;
var state_42235__$1 = (function (){var statearr_42250 = state_42235;
(statearr_42250[(13)] = inst_42182);

(statearr_42250[(7)] = inst_42184__$1);

(statearr_42250[(8)] = inst_42185__$1);

(statearr_42250[(9)] = inst_42183__$1);

return statearr_42250;
})();
var statearr_42251_42297 = state_42235__$1;
(statearr_42251_42297[(2)] = null);

(statearr_42251_42297[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (3))){
var inst_42233 = (state_42235[(2)]);
var state_42235__$1 = state_42235;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42235__$1,inst_42233);
} else {
if((state_val_42236 === (12))){
var inst_42182 = (state_42235[(13)]);
var inst_42191 = (state_42235[(11)]);
var inst_42190 = cljs.core.seq(inst_42182);
var inst_42191__$1 = cljs.core.first(inst_42190);
var inst_42192 = cljs.core.next(inst_42190);
var state_42235__$1 = (function (){var statearr_42252 = state_42235;
(statearr_42252[(11)] = inst_42191__$1);

(statearr_42252[(12)] = inst_42192);

return statearr_42252;
})();
if(cljs.core.truth_(inst_42191__$1)){
var statearr_42253_42298 = state_42235__$1;
(statearr_42253_42298[(1)] = (14));

} else {
var statearr_42254_42299 = state_42235__$1;
(statearr_42254_42299[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (2))){
var _ = (function (){var statearr_42255 = state_42235;
(statearr_42255[(4)] = cljs.core.cons((5),(state_42235[(4)])));

return statearr_42255;
})();
var inst_42147 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_42148 = (inst_42147 + (1));
var inst_42149 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_42148);
var state_42235__$1 = state_42235;
if(inst_42149){
var statearr_42256_42300 = state_42235__$1;
(statearr_42256_42300[(1)] = (6));

} else {
var statearr_42257_42301 = state_42235__$1;
(statearr_42257_42301[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (23))){
var inst_42191 = (state_42235[(11)]);
var inst_42208 = (state_42235[(2)]);
var inst_42209 = fluree.db.util.async.throw_err(inst_42208);
var inst_42210 = (inst_42191 == null);
var state_42235__$1 = (function (){var statearr_42258 = state_42235;
(statearr_42258[(10)] = inst_42209);

return statearr_42258;
})();
if(cljs.core.truth_(inst_42210)){
var statearr_42259_42302 = state_42235__$1;
(statearr_42259_42302[(1)] = (24));

} else {
var statearr_42260_42303 = state_42235__$1;
(statearr_42260_42303[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (19))){
var inst_42225 = (state_42235[(2)]);
var state_42235__$1 = state_42235;
var statearr_42261_42304 = state_42235__$1;
(statearr_42261_42304[(2)] = inst_42225);

(statearr_42261_42304[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (11))){
var inst_42230 = (state_42235[(2)]);
var _ = (function (){var statearr_42263 = state_42235;
(statearr_42263[(4)] = cljs.core.rest((state_42235[(4)])));

return statearr_42263;
})();
var state_42235__$1 = state_42235;
var statearr_42264_42305 = state_42235__$1;
(statearr_42264_42305[(2)] = inst_42230);

(statearr_42264_42305[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (9))){
var inst_42164 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_42165 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_42164);
var state_42235__$1 = state_42235;
var statearr_42265_42306 = state_42235__$1;
(statearr_42265_42306[(2)] = inst_42165);

(statearr_42265_42306[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (5))){
var _ = (function (){var statearr_42266 = state_42235;
(statearr_42266[(4)] = cljs.core.rest((state_42235[(4)])));

return statearr_42266;
})();
var state_42235__$1 = state_42235;
var ex42262 = (state_42235__$1[(2)]);
var statearr_42267_42307 = state_42235__$1;
(statearr_42267_42307[(5)] = ex42262);


var statearr_42268_42308 = state_42235__$1;
(statearr_42268_42308[(1)] = (4));

(statearr_42268_42308[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (14))){
var inst_42191 = (state_42235[(11)]);
var inst_42183 = (state_42235[(9)]);
var inst_42194 = inst_42191.t;
var inst_42195 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42183,inst_42194);
var state_42235__$1 = state_42235;
var statearr_42269_42309 = state_42235__$1;
(statearr_42269_42309[(2)] = inst_42195);

(statearr_42269_42309[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (26))){
var inst_42220 = (state_42235[(2)]);
var state_42235__$1 = state_42235;
var statearr_42270_42310 = state_42235__$1;
(statearr_42270_42310[(2)] = inst_42220);

(statearr_42270_42310[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (16))){
var inst_42198 = (state_42235[(2)]);
var state_42235__$1 = state_42235;
if(cljs.core.truth_(inst_42198)){
var statearr_42271_42311 = state_42235__$1;
(statearr_42271_42311[(1)] = (17));

} else {
var statearr_42272_42312 = state_42235__$1;
(statearr_42272_42312[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (10))){
var inst_42167 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_42175 = cljs.core.seq(inst_42167);
var inst_42176 = cljs.core.first(inst_42175);
var inst_42177 = cljs.core.next(inst_42175);
var inst_42178 = cljs.core.first(inst_42167);
var inst_42179 = inst_42178.t;
var inst_42180 = cljs.core.PersistentVector.EMPTY;
var inst_42181 = db;
var inst_42182 = inst_42167;
var inst_42183 = inst_42179;
var inst_42184 = inst_42180;
var inst_42185 = inst_42181;
var state_42235__$1 = (function (){var statearr_42273 = state_42235;
(statearr_42273[(14)] = inst_42176);

(statearr_42273[(13)] = inst_42182);

(statearr_42273[(7)] = inst_42184);

(statearr_42273[(8)] = inst_42185);

(statearr_42273[(9)] = inst_42183);

(statearr_42273[(15)] = inst_42177);

return statearr_42273;
})();
var statearr_42274_42313 = state_42235__$1;
(statearr_42274_42313[(2)] = null);

(statearr_42274_42313[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (18))){
var state_42235__$1 = state_42235;
var statearr_42275_42314 = state_42235__$1;
(statearr_42275_42314[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42236 === (8))){
var inst_42161 = (state_42235[(2)]);
var inst_42162 = cljs.core.empty_QMARK_(flakes);
var state_42235__$1 = (function (){var statearr_42277 = state_42235;
(statearr_42277[(16)] = inst_42161);

return statearr_42277;
})();
if(inst_42162){
var statearr_42278_42315 = state_42235__$1;
(statearr_42278_42315[(1)] = (9));

} else {
var statearr_42279_42316 = state_42235__$1;
(statearr_42279_42316[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16153__auto__ = null;
var fluree$db$graphdb$state_machine__16153__auto____0 = (function (){
var statearr_42280 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42280[(0)] = fluree$db$graphdb$state_machine__16153__auto__);

(statearr_42280[(1)] = (1));

return statearr_42280;
});
var fluree$db$graphdb$state_machine__16153__auto____1 = (function (state_42235){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_42235);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e42281){var ex__16156__auto__ = e42281;
var statearr_42282_42317 = state_42235;
(statearr_42282_42317[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_42235[(4)]))){
var statearr_42283_42318 = state_42235;
(statearr_42283_42318[(1)] = cljs.core.first((state_42235[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__42319 = state_42235;
state_42235 = G__42319;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16153__auto__ = function(state_42235){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16153__auto____1.call(this,state_42235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16153__auto____0;
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16153__auto____1;
return fluree$db$graphdb$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_42284 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_42284[(6)] = c__16227__auto___42286);

return statearr_42284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_42375){
var state_val_42376 = (state_42375[(1)]);
if((state_val_42376 === (7))){
var state_42375__$1 = state_42375;
var statearr_42377_42404 = state_42375__$1;
(statearr_42377_42404[(2)] = tt_id);

(statearr_42377_42404[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42376 === (1))){
var state_42375__$1 = state_42375;
var statearr_42378_42405 = state_42375__$1;
(statearr_42378_42405[(2)] = null);

(statearr_42378_42405[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42376 === (4))){
var inst_42320 = (state_42375[(2)]);
var state_42375__$1 = state_42375;
var statearr_42379_42406 = state_42375__$1;
(statearr_42379_42406[(2)] = inst_42320);

(statearr_42379_42406[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42376 === (13))){
var inst_42368 = (state_42375[(2)]);
var state_42375__$1 = state_42375;
var statearr_42380_42407 = state_42375__$1;
(statearr_42380_42407[(2)] = inst_42368);

(statearr_42380_42407[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42376 === (6))){
var inst_42328 = fluree.db.util.core.random_uuid();
var state_42375__$1 = state_42375;
var statearr_42381_42408 = state_42375__$1;
(statearr_42381_42408[(2)] = inst_42328);

(statearr_42381_42408[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42376 === (3))){
var inst_42373 = (state_42375[(2)]);
var state_42375__$1 = state_42375;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42375__$1,inst_42373);
} else {
if((state_val_42376 === (12))){
var inst_42351 = (state_42375[(7)]);
var state_42375__$1 = state_42375;
var statearr_42382_42409 = state_42375__$1;
(statearr_42382_42409[(2)] = inst_42351);

(statearr_42382_42409[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42376 === (2))){
var _ = (function (){var statearr_42383 = state_42375;
(statearr_42383[(4)] = cljs.core.cons((5),(state_42375[(4)])));

return statearr_42383;
})();
var inst_42326 = (tt_id == null);
var state_42375__$1 = state_42375;
if(cljs.core.truth_(inst_42326)){
var statearr_42384_42410 = state_42375__$1;
(statearr_42384_42410[(1)] = (6));

} else {
var statearr_42385_42411 = state_42375__$1;
(statearr_42385_42411[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42376 === (11))){
var inst_42358 = (state_42375[(8)]);
var inst_42351 = (state_42375[(7)]);
var inst_42361 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_42351,inst_42358);
var state_42375__$1 = state_42375;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42375__$1,(14),inst_42361);
} else {
if((state_val_42376 === (9))){
var inst_42358 = (state_42375[(8)]);
var inst_42352 = (state_42375[(9)]);
var inst_42357 = cljs.core.seq(inst_42352);
var inst_42358__$1 = cljs.core.first(inst_42357);
var inst_42359 = cljs.core.next(inst_42357);
var state_42375__$1 = (function (){var statearr_42387 = state_42375;
(statearr_42387[(10)] = inst_42359);

(statearr_42387[(8)] = inst_42358__$1);

return statearr_42387;
})();
if(cljs.core.truth_(inst_42358__$1)){
var statearr_42388_42412 = state_42375__$1;
(statearr_42388_42412[(1)] = (11));

} else {
var statearr_42389_42413 = state_42375__$1;
(statearr_42389_42413[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42376 === (5))){
var _ = (function (){var statearr_42390 = state_42375;
(statearr_42390[(4)] = cljs.core.rest((state_42375[(4)])));

return statearr_42390;
})();
var state_42375__$1 = state_42375;
var ex42386 = (state_42375__$1[(2)]);
var statearr_42391_42414 = state_42375__$1;
(statearr_42391_42414[(5)] = ex42386);


if((ex42386 instanceof Error)){
var statearr_42392_42415 = state_42375__$1;
(statearr_42392_42415[(1)] = (4));

(statearr_42392_42415[(5)] = null);

} else {
throw ex42386;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42376 === (14))){
var inst_42359 = (state_42375[(10)]);
var inst_42363 = (state_42375[(2)]);
var inst_42364 = fluree.db.util.async.throw_err(inst_42363);
var inst_42351 = inst_42364;
var inst_42352 = inst_42359;
var state_42375__$1 = (function (){var statearr_42393 = state_42375;
(statearr_42393[(7)] = inst_42351);

(statearr_42393[(9)] = inst_42352);

return statearr_42393;
})();
var statearr_42394_42416 = state_42375__$1;
(statearr_42394_42416[(2)] = null);

(statearr_42394_42416[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42376 === (10))){
var inst_42370 = (state_42375[(2)]);
var _ = (function (){var statearr_42395 = state_42375;
(statearr_42395[(4)] = cljs.core.rest((state_42375[(4)])));

return statearr_42395;
})();
var state_42375__$1 = state_42375;
var statearr_42396_42417 = state_42375__$1;
(statearr_42396_42417[(2)] = inst_42370);

(statearr_42396_42417[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42376 === (8))){
var inst_42331 = (state_42375[(2)]);
var inst_42332 = (function (){var tt_id_SINGLEQUOTE_ = inst_42331;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_42333 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_42331);
var inst_42334 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42335 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_42336 = (new cljs.core.PersistentVector(null,4,(5),inst_42334,inst_42335,null));
var inst_42337 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_42332,inst_42333,inst_42336);
var inst_42338 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_42339 = cljs.core.reverse(inst_42338);
var inst_42340 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_42339);
var inst_42348 = cljs.core.seq(inst_42340);
var inst_42349 = cljs.core.first(inst_42348);
var inst_42350 = cljs.core.next(inst_42348);
var inst_42351 = inst_42337;
var inst_42352 = inst_42340;
var state_42375__$1 = (function (){var statearr_42397 = state_42375;
(statearr_42397[(11)] = inst_42350);

(statearr_42397[(7)] = inst_42351);

(statearr_42397[(12)] = inst_42349);

(statearr_42397[(9)] = inst_42352);

return statearr_42397;
})();
var statearr_42398_42418 = state_42375__$1;
(statearr_42398_42418[(2)] = null);

(statearr_42398_42418[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__16153__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__16153__auto____0 = (function (){
var statearr_42399 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42399[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__16153__auto__);

(statearr_42399[(1)] = (1));

return statearr_42399;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__16153__auto____1 = (function (state_42375){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_42375);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e42400){var ex__16156__auto__ = e42400;
var statearr_42401_42419 = state_42375;
(statearr_42401_42419[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_42375[(4)]))){
var statearr_42402_42420 = state_42375;
(statearr_42402_42420[(1)] = cljs.core.first((state_42375[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__42421 = state_42375;
state_42375 = G__42421;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__16153__auto__ = function(state_42375){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__16153__auto____1.call(this,state_42375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__16153__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__16153__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_42403 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_42403[(6)] = c__16227__auto__);

return statearr_42403;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16227__auto___42608 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_42539){
var state_val_42540 = (state_42539[(1)]);
if((state_val_42540 === (7))){
var inst_42449 = (state_42539[(7)]);
var inst_42449__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_42539__$1 = (function (){var statearr_42541 = state_42539;
(statearr_42541[(7)] = inst_42449__$1);

return statearr_42541;
})();
if(inst_42449__$1){
var statearr_42542_42609 = state_42539__$1;
(statearr_42542_42609[(1)] = (13));

} else {
var statearr_42543_42610 = state_42539__$1;
(statearr_42543_42610[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (20))){
var state_42539__$1 = state_42539;
var statearr_42544_42611 = state_42539__$1;
(statearr_42544_42611[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (27))){
var inst_42485 = (state_42539[(8)]);
var inst_42489 = inst_42485.s;
var state_42539__$1 = state_42539;
var statearr_42546_42612 = state_42539__$1;
(statearr_42546_42612[(2)] = inst_42489);

(statearr_42546_42612[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (1))){
var state_42539__$1 = state_42539;
var statearr_42547_42613 = state_42539__$1;
(statearr_42547_42613[(2)] = null);

(statearr_42547_42613[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (24))){
var inst_42479 = (state_42539[(9)]);
var inst_42483 = cljs.core.first(inst_42479);
var state_42539__$1 = state_42539;
var statearr_42548_42614 = state_42539__$1;
(statearr_42548_42614[(2)] = inst_42483);

(statearr_42548_42614[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (39))){
var state_42539__$1 = state_42539;
var statearr_42549_42615 = state_42539__$1;
(statearr_42549_42615[(1)] = (41));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (4))){
var inst_42422 = (state_42539[(2)]);
var inst_42423 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_42424 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42425 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_42426 = cljs.core.PersistentHashMap.fromArrays(inst_42424,inst_42425);
var inst_42427 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_42423,inst_42426,inst_42422);
var inst_42428 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_42427);
var state_42539__$1 = state_42539;
var statearr_42551_42616 = state_42539__$1;
(statearr_42551_42616[(2)] = inst_42428);

(statearr_42551_42616[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (15))){
var inst_42456 = (state_42539[(2)]);
var state_42539__$1 = state_42539;
if(cljs.core.truth_(inst_42456)){
var statearr_42552_42617 = state_42539__$1;
(statearr_42552_42617[(1)] = (16));

} else {
var statearr_42553_42618 = state_42539__$1;
(statearr_42553_42618[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (21))){
var inst_42505 = (state_42539[(2)]);
var state_42539__$1 = state_42539;
var statearr_42554_42619 = state_42539__$1;
(statearr_42554_42619[(2)] = inst_42505);

(statearr_42554_42619[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (31))){
var inst_42503 = (state_42539[(2)]);
var state_42539__$1 = state_42539;
var statearr_42555_42620 = state_42539__$1;
(statearr_42555_42620[(2)] = inst_42503);

(statearr_42555_42620[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (32))){
var inst_42509 = (state_42539[(10)]);
var inst_42511 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_42509);
var state_42539__$1 = state_42539;
var statearr_42556_42621 = state_42539__$1;
(statearr_42556_42621[(2)] = inst_42511);

(statearr_42556_42621[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (40))){
var inst_42532 = (state_42539[(2)]);
var state_42539__$1 = state_42539;
var statearr_42557_42622 = state_42539__$1;
(statearr_42557_42622[(2)] = inst_42532);

(statearr_42557_42622[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (33))){
var inst_42509 = (state_42539[(10)]);
var inst_42513 = (state_42539[(11)]);
var inst_42513__$1 = (inst_42509 == null);
var state_42539__$1 = (function (){var statearr_42558 = state_42539;
(statearr_42558[(11)] = inst_42513__$1);

return statearr_42558;
})();
if(cljs.core.truth_(inst_42513__$1)){
var statearr_42559_42623 = state_42539__$1;
(statearr_42559_42623[(1)] = (35));

} else {
var statearr_42560_42624 = state_42539__$1;
(statearr_42560_42624[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (13))){
var inst_42451 = cljs.core.first(ident);
var inst_42452 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_42451);
var inst_42453 = (inst_42452 == null);
var state_42539__$1 = state_42539;
var statearr_42561_42625 = state_42539__$1;
(statearr_42561_42625[(2)] = inst_42453);

(statearr_42561_42625[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (22))){
var inst_42479 = (state_42539[(9)]);
var inst_42478 = (state_42539[(2)]);
var inst_42479__$1 = fluree.db.util.async.throw_err(inst_42478);
var inst_42480 = (inst_42479__$1 == null);
var state_42539__$1 = (function (){var statearr_42562 = state_42539;
(statearr_42562[(9)] = inst_42479__$1);

return statearr_42562;
})();
if(cljs.core.truth_(inst_42480)){
var statearr_42563_42626 = state_42539__$1;
(statearr_42563_42626[(1)] = (23));

} else {
var statearr_42564_42627 = state_42539__$1;
(statearr_42564_42627[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (36))){
var inst_42513 = (state_42539[(11)]);
var state_42539__$1 = state_42539;
var statearr_42565_42628 = state_42539__$1;
(statearr_42565_42628[(2)] = inst_42513);

(statearr_42565_42628[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (41))){
var inst_42527 = cljs.core.async.close_BANG_(return_chan);
var state_42539__$1 = state_42539;
var statearr_42566_42629 = state_42539__$1;
(statearr_42566_42629[(2)] = inst_42527);

(statearr_42566_42629[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (43))){
var inst_42530 = (state_42539[(2)]);
var state_42539__$1 = state_42539;
var statearr_42567_42630 = state_42539__$1;
(statearr_42567_42630[(2)] = inst_42530);

(statearr_42567_42630[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (29))){
var inst_42494 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_42495 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_42494].join('');
var inst_42496 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42497 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_42498 = cljs.core.PersistentHashMap.fromArrays(inst_42496,inst_42497);
var inst_42499 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42495,inst_42498);
var inst_42500 = (function(){throw inst_42499})();
var state_42539__$1 = state_42539;
var statearr_42568_42631 = state_42539__$1;
(statearr_42568_42631[(2)] = inst_42500);

(statearr_42568_42631[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (6))){
var inst_42436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42437 = [ident];
var inst_42438 = (new cljs.core.PersistentVector(null,1,(5),inst_42436,inst_42437,null));
var inst_42439 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_42438);
var state_42539__$1 = state_42539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42539__$1,(9),inst_42439);
} else {
if((state_val_42540 === (28))){
var inst_42491 = (state_42539[(2)]);
var state_42539__$1 = state_42539;
var statearr_42569_42632 = state_42539__$1;
(statearr_42569_42632[(2)] = inst_42491);

(statearr_42569_42632[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (25))){
var inst_42485 = (state_42539[(8)]);
var inst_42485__$1 = (state_42539[(2)]);
var inst_42486 = (inst_42485__$1 == null);
var state_42539__$1 = (function (){var statearr_42570 = state_42539;
(statearr_42570[(8)] = inst_42485__$1);

return statearr_42570;
})();
if(cljs.core.truth_(inst_42486)){
var statearr_42571_42633 = state_42539__$1;
(statearr_42571_42633[(1)] = (26));

} else {
var statearr_42572_42634 = state_42539__$1;
(statearr_42572_42634[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (34))){
var inst_42534 = (state_42539[(2)]);
var _ = (function (){var statearr_42573 = state_42539;
(statearr_42573[(4)] = cljs.core.rest((state_42539[(4)])));

return statearr_42573;
})();
var state_42539__$1 = state_42539;
var statearr_42574_42635 = state_42539__$1;
(statearr_42574_42635[(2)] = inst_42534);

(statearr_42574_42635[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (17))){
var inst_42467 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_42539__$1 = state_42539;
if(inst_42467){
var statearr_42575_42636 = state_42539__$1;
(statearr_42575_42636[(1)] = (19));

} else {
var statearr_42576_42637 = state_42539__$1;
(statearr_42576_42637[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (3))){
var inst_42537 = (state_42539[(2)]);
var state_42539__$1 = state_42539;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42539__$1,inst_42537);
} else {
if((state_val_42540 === (12))){
var inst_42447 = (state_42539[(2)]);
var state_42539__$1 = state_42539;
var statearr_42577_42638 = state_42539__$1;
(statearr_42577_42638[(2)] = inst_42447);

(statearr_42577_42638[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (2))){
var _ = (function (){var statearr_42578 = state_42539;
(statearr_42578[(4)] = cljs.core.cons((5),(state_42539[(4)])));

return statearr_42578;
})();
var inst_42434 = typeof ident === 'number';
var state_42539__$1 = state_42539;
if(cljs.core.truth_(inst_42434)){
var statearr_42579_42639 = state_42539__$1;
(statearr_42579_42639[(1)] = (6));

} else {
var statearr_42580_42640 = state_42539__$1;
(statearr_42580_42640[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (23))){
var state_42539__$1 = state_42539;
var statearr_42581_42641 = state_42539__$1;
(statearr_42581_42641[(2)] = null);

(statearr_42581_42641[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (35))){
var state_42539__$1 = state_42539;
var statearr_42582_42642 = state_42539__$1;
(statearr_42582_42642[(2)] = strict_QMARK_);

(statearr_42582_42642[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (19))){
var inst_42470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42471 = cljs.core.first(ident);
var inst_42472 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_42471);
var inst_42473 = cljs.core.second(ident);
var inst_42474 = [inst_42472,inst_42473];
var inst_42475 = (new cljs.core.PersistentVector(null,2,(5),inst_42470,inst_42474,null));
var inst_42476 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_42475);
var state_42539__$1 = state_42539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42539__$1,(22),inst_42476);
} else {
if((state_val_42540 === (11))){
var state_42539__$1 = state_42539;
var statearr_42584_42643 = state_42539__$1;
(statearr_42584_42643[(2)] = null);

(statearr_42584_42643[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (9))){
var inst_42441 = (state_42539[(2)]);
var inst_42442 = fluree.db.util.async.throw_err(inst_42441);
var inst_42443 = cljs.core.not_empty(inst_42442);
var state_42539__$1 = state_42539;
if(cljs.core.truth_(inst_42443)){
var statearr_42585_42644 = state_42539__$1;
(statearr_42585_42644[(1)] = (10));

} else {
var statearr_42586_42645 = state_42539__$1;
(statearr_42586_42645[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (5))){
var _ = (function (){var statearr_42587 = state_42539;
(statearr_42587[(4)] = cljs.core.rest((state_42539[(4)])));

return statearr_42587;
})();
var state_42539__$1 = state_42539;
var ex42583 = (state_42539__$1[(2)]);
var statearr_42588_42646 = state_42539__$1;
(statearr_42588_42646[(5)] = ex42583);


var statearr_42589_42647 = state_42539__$1;
(statearr_42589_42647[(1)] = (4));

(statearr_42589_42647[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (14))){
var inst_42449 = (state_42539[(7)]);
var state_42539__$1 = state_42539;
var statearr_42590_42648 = state_42539__$1;
(statearr_42590_42648[(2)] = inst_42449);

(statearr_42590_42648[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (26))){
var state_42539__$1 = state_42539;
var statearr_42591_42649 = state_42539__$1;
(statearr_42591_42649[(2)] = null);

(statearr_42591_42649[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (16))){
var inst_42458 = cljs.core.first(ident);
var inst_42459 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42458], 0));
var inst_42460 = ["Subject ID lookup failed. The predicate ",inst_42459," does not exist."].join('');
var inst_42461 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42462 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_42463 = cljs.core.PersistentHashMap.fromArrays(inst_42461,inst_42462);
var inst_42464 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42460,inst_42463);
var inst_42465 = (function(){throw inst_42464})();
var state_42539__$1 = state_42539;
var statearr_42592_42650 = state_42539__$1;
(statearr_42592_42650[(2)] = inst_42465);

(statearr_42592_42650[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (38))){
var inst_42519 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_42520 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42521 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_42522 = cljs.core.PersistentHashMap.fromArrays(inst_42520,inst_42521);
var inst_42523 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42519,inst_42522);
var inst_42524 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_42523);
var state_42539__$1 = state_42539;
var statearr_42593_42651 = state_42539__$1;
(statearr_42593_42651[(2)] = inst_42524);

(statearr_42593_42651[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (30))){
var state_42539__$1 = state_42539;
var statearr_42594_42652 = state_42539__$1;
(statearr_42594_42652[(2)] = null);

(statearr_42594_42652[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (10))){
var state_42539__$1 = state_42539;
var statearr_42595_42653 = state_42539__$1;
(statearr_42595_42653[(2)] = ident);

(statearr_42595_42653[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (18))){
var inst_42507 = (state_42539[(2)]);
var state_42539__$1 = state_42539;
var statearr_42596_42654 = state_42539__$1;
(statearr_42596_42654[(2)] = inst_42507);

(statearr_42596_42654[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (42))){
var state_42539__$1 = state_42539;
var statearr_42597_42655 = state_42539__$1;
(statearr_42597_42655[(2)] = null);

(statearr_42597_42655[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (37))){
var inst_42517 = (state_42539[(2)]);
var state_42539__$1 = state_42539;
if(cljs.core.truth_(inst_42517)){
var statearr_42598_42656 = state_42539__$1;
(statearr_42598_42656[(1)] = (38));

} else {
var statearr_42599_42657 = state_42539__$1;
(statearr_42599_42657[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42540 === (8))){
var inst_42509 = (state_42539[(10)]);
var inst_42509__$1 = (state_42539[(2)]);
var state_42539__$1 = (function (){var statearr_42600 = state_42539;
(statearr_42600[(10)] = inst_42509__$1);

return statearr_42600;
})();
if(cljs.core.truth_(inst_42509__$1)){
var statearr_42601_42658 = state_42539__$1;
(statearr_42601_42658[(1)] = (32));

} else {
var statearr_42602_42659 = state_42539__$1;
(statearr_42602_42659[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__16153__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__16153__auto____0 = (function (){
var statearr_42603 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42603[(0)] = fluree$db$graphdb$subid_$_state_machine__16153__auto__);

(statearr_42603[(1)] = (1));

return statearr_42603;
});
var fluree$db$graphdb$subid_$_state_machine__16153__auto____1 = (function (state_42539){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_42539);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e42604){var ex__16156__auto__ = e42604;
var statearr_42605_42660 = state_42539;
(statearr_42605_42660[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_42539[(4)]))){
var statearr_42606_42661 = state_42539;
(statearr_42606_42661[(1)] = cljs.core.first((state_42539[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__42662 = state_42539;
state_42539 = G__42662;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__16153__auto__ = function(state_42539){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__16153__auto____1.call(this,state_42539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__16153__auto____0;
fluree$db$graphdb$subid_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__16153__auto____1;
return fluree$db$graphdb$subid_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_42607 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_42607[(6)] = c__16227__auto___42608);

return statearr_42607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k42664,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__42668 = k42664;
var G__42668__$1 = (((G__42668 instanceof cljs.core.Keyword))?G__42668.fqn:null);
switch (G__42668__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k42664,else__4475__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__42669){
var vec__42670 = p__42669;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42670,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42670,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__42663){
var self__ = this;
var G__42663__$1 = this;
return (new cljs.core.RecordIter((0),G__42663__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__42673 = (function (coll__4469__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__42673(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this42665,other42666){
var self__ = this;
var this42665__$1 = this;
return (((!((other42666 == null)))) && ((((this42665__$1.constructor === other42666.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.conn,other42666.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.network,other42666.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.dbid,other42666.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.block,other42666.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.t,other42666.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.tt_id,other42666.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.stats,other42666.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.spot,other42666.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.psot,other42666.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.post,other42666.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.opst,other42666.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.schema,other42666.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.settings,other42666.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.index_configs,other42666.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.schema_cache,other42666.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.novelty,other42666.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.permissions,other42666.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.fork,other42666.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.fork_block,other42666.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.current_db_fn,other42666.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this42665__$1.__extmap,other42666.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k42664){
var self__ = this;
var this__4479__auto____$1 = this;
var G__42674 = k42664;
var G__42674__$1 = (((G__42674 instanceof cljs.core.Keyword))?G__42674.fqn:null);
switch (G__42674__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k42664);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__42663){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__42675 = cljs.core.keyword_identical_QMARK_;
var expr__42676 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__42678 = cljs.core.cst$kw$conn;
var G__42679 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42678,G__42679) : pred__42675.call(null,G__42678,G__42679));
})())){
return (new fluree.db.graphdb.GraphDb(G__42663,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42680 = cljs.core.cst$kw$network;
var G__42681 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42680,G__42681) : pred__42675.call(null,G__42680,G__42681));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__42663,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42682 = cljs.core.cst$kw$dbid;
var G__42683 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42682,G__42683) : pred__42675.call(null,G__42682,G__42683));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__42663,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42684 = cljs.core.cst$kw$block;
var G__42685 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42684,G__42685) : pred__42675.call(null,G__42684,G__42685));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__42663,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42686 = cljs.core.cst$kw$t;
var G__42687 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42686,G__42687) : pred__42675.call(null,G__42686,G__42687));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__42663,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42688 = cljs.core.cst$kw$tt_DASH_id;
var G__42689 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42688,G__42689) : pred__42675.call(null,G__42688,G__42689));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__42663,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42690 = cljs.core.cst$kw$stats;
var G__42691 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42690,G__42691) : pred__42675.call(null,G__42690,G__42691));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__42663,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42692 = cljs.core.cst$kw$spot;
var G__42693 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42692,G__42693) : pred__42675.call(null,G__42692,G__42693));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__42663,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42694 = cljs.core.cst$kw$psot;
var G__42695 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42694,G__42695) : pred__42675.call(null,G__42694,G__42695));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__42663,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42696 = cljs.core.cst$kw$post;
var G__42697 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42696,G__42697) : pred__42675.call(null,G__42696,G__42697));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__42663,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42698 = cljs.core.cst$kw$opst;
var G__42699 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42698,G__42699) : pred__42675.call(null,G__42698,G__42699));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__42663,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42700 = cljs.core.cst$kw$schema;
var G__42701 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42700,G__42701) : pred__42675.call(null,G__42700,G__42701));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__42663,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42702 = cljs.core.cst$kw$settings;
var G__42703 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42702,G__42703) : pred__42675.call(null,G__42702,G__42703));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__42663,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42704 = cljs.core.cst$kw$index_DASH_configs;
var G__42705 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42704,G__42705) : pred__42675.call(null,G__42704,G__42705));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__42663,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42706 = cljs.core.cst$kw$schema_DASH_cache;
var G__42707 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42706,G__42707) : pred__42675.call(null,G__42706,G__42707));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__42663,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42708 = cljs.core.cst$kw$novelty;
var G__42709 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42708,G__42709) : pred__42675.call(null,G__42708,G__42709));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__42663,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42710 = cljs.core.cst$kw$permissions;
var G__42711 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42710,G__42711) : pred__42675.call(null,G__42710,G__42711));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__42663,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42712 = cljs.core.cst$kw$fork;
var G__42713 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42712,G__42713) : pred__42675.call(null,G__42712,G__42713));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__42663,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42714 = cljs.core.cst$kw$fork_DASH_block;
var G__42715 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42714,G__42715) : pred__42675.call(null,G__42714,G__42715));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__42663,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__42716 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__42717 = expr__42676;
return (pred__42675.cljs$core$IFn$_invoke$arity$2 ? pred__42675.cljs$core$IFn$_invoke$arity$2(G__42716,G__42717) : pred__42675.call(null,G__42716,G__42717));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__42663,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__42663),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__42663){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__42663,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_42733){
var state_val_42734 = (state_42733[(1)]);
if((state_val_42734 === (1))){
var state_42733__$1 = state_42733;
var statearr_42735_43002 = state_42733__$1;
(statearr_42735_43002[(2)] = null);

(statearr_42735_43002[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42734 === (2))){
var _ = (function (){var statearr_42736 = state_42733;
(statearr_42736[(4)] = cljs.core.cons((5),(state_42733[(4)])));

return statearr_42736;
})();
var inst_42724 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_42733__$1 = state_42733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42733__$1,(6),inst_42724);
} else {
if((state_val_42734 === (3))){
var inst_42731 = (state_42733[(2)]);
var state_42733__$1 = state_42733;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42733__$1,inst_42731);
} else {
if((state_val_42734 === (4))){
var inst_42718 = (state_42733[(2)]);
var state_42733__$1 = state_42733;
var statearr_42738_43003 = state_42733__$1;
(statearr_42738_43003[(2)] = inst_42718);

(statearr_42738_43003[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42734 === (5))){
var _ = (function (){var statearr_42739 = state_42733;
(statearr_42739[(4)] = cljs.core.rest((state_42733[(4)])));

return statearr_42739;
})();
var state_42733__$1 = state_42733;
var ex42737 = (state_42733__$1[(2)]);
var statearr_42740_43004 = state_42733__$1;
(statearr_42740_43004[(5)] = ex42737);


if((ex42737 instanceof Error)){
var statearr_42741_43005 = state_42733__$1;
(statearr_42741_43005[(1)] = (4));

(statearr_42741_43005[(5)] = null);

} else {
throw ex42737;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42734 === (6))){
var inst_42726 = (state_42733[(2)]);
var inst_42727 = fluree.db.util.async.throw_err(inst_42726);
var inst_42728 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42727,cljs.core.cst$kw$permissions,self__.permissions);
var _ = (function (){var statearr_42742 = state_42733;
(statearr_42742[(4)] = cljs.core.rest((state_42733[(4)])));

return statearr_42742;
})();
var state_42733__$1 = state_42733;
var statearr_42743_43006 = state_42733__$1;
(statearr_42743_43006[(2)] = inst_42728);

(statearr_42743_43006[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16153__auto__ = null;
var fluree$db$graphdb$state_machine__16153__auto____0 = (function (){
var statearr_42744 = [null,null,null,null,null,null,null];
(statearr_42744[(0)] = fluree$db$graphdb$state_machine__16153__auto__);

(statearr_42744[(1)] = (1));

return statearr_42744;
});
var fluree$db$graphdb$state_machine__16153__auto____1 = (function (state_42733){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_42733);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e42745){var ex__16156__auto__ = e42745;
var statearr_42746_43007 = state_42733;
(statearr_42746_43007[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_42733[(4)]))){
var statearr_42747_43008 = state_42733;
(statearr_42747_43008[(1)] = cljs.core.first((state_42733[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__43009 = state_42733;
state_42733 = G__43009;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16153__auto__ = function(state_42733){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16153__auto____1.call(this,state_42733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16153__auto____0;
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16153__auto____1;
return fluree$db$graphdb$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_42748 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_42748[(6)] = c__16227__auto__);

return statearr_42748;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__42749 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$partition,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__42749.cljs$core$IFn$_invoke$arity$1 ? fexpr__42749.cljs$core$IFn$_invoke$arity$1(property) : fexpr__42749.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__42750 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$retractDuplicates,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__42750.cljs$core$IFn$_invoke$arity$1 ? fexpr__42750.cljs$core$IFn$_invoke$arity$1(property) : fexpr__42750.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__42751 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,cljs.core.cst$kw$partition,G__42751);
} else {
return G__42751;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_42783){
var state_val_42784 = (state_42783[(1)]);
if((state_val_42784 === (7))){
var state_42783__$1 = state_42783;
var statearr_42785_43010 = state_42783__$1;
(statearr_42785_43010[(2)] = null);

(statearr_42785_43010[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42784 === (1))){
var state_42783__$1 = state_42783;
var statearr_42786_43011 = state_42783__$1;
(statearr_42786_43011[(2)] = null);

(statearr_42786_43011[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42784 === (4))){
var inst_42752 = (state_42783[(2)]);
var state_42783__$1 = state_42783;
var statearr_42787_43012 = state_42783__$1;
(statearr_42787_43012[(2)] = inst_42752);

(statearr_42787_43012[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42784 === (6))){
var inst_42766 = (state_42783[(7)]);
var inst_42765 = (state_42783[(2)]);
var inst_42766__$1 = fluree.db.util.async.throw_err(inst_42765);
var inst_42767 = (inst_42766__$1 == null);
var state_42783__$1 = (function (){var statearr_42788 = state_42783;
(statearr_42788[(7)] = inst_42766__$1);

return statearr_42788;
})();
if(cljs.core.truth_(inst_42767)){
var statearr_42789_43013 = state_42783__$1;
(statearr_42789_43013[(1)] = (7));

} else {
var statearr_42790_43014 = state_42783__$1;
(statearr_42790_43014[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42784 === (3))){
var inst_42781 = (state_42783[(2)]);
var state_42783__$1 = state_42783;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42783__$1,inst_42781);
} else {
if((state_val_42784 === (12))){
var inst_42778 = (state_42783[(2)]);
var _ = (function (){var statearr_42791 = state_42783;
(statearr_42791[(4)] = cljs.core.rest((state_42783[(4)])));

return statearr_42791;
})();
var state_42783__$1 = state_42783;
var statearr_42792_43015 = state_42783__$1;
(statearr_42792_43015[(2)] = inst_42778);

(statearr_42792_43015[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42784 === (2))){
var _ = (function (){var statearr_42793 = state_42783;
(statearr_42793[(4)] = cljs.core.cons((5),(state_42783[(4)])));

return statearr_42793;
})();
var inst_42759 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_42760 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42761 = [tag_id,(30)];
var inst_42762 = (new cljs.core.PersistentVector(null,2,(5),inst_42760,inst_42761,null));
var inst_42763 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_42759,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_42762);
var state_42783__$1 = state_42783;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42783__$1,(6),inst_42763);
} else {
if((state_val_42784 === (11))){
var inst_42772 = (state_42783[(8)]);
var inst_42776 = inst_42772.o;
var state_42783__$1 = state_42783;
var statearr_42795_43016 = state_42783__$1;
(statearr_42795_43016[(2)] = inst_42776);

(statearr_42795_43016[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42784 === (9))){
var inst_42772 = (state_42783[(8)]);
var inst_42772__$1 = (state_42783[(2)]);
var inst_42773 = (inst_42772__$1 == null);
var state_42783__$1 = (function (){var statearr_42796 = state_42783;
(statearr_42796[(8)] = inst_42772__$1);

return statearr_42796;
})();
if(cljs.core.truth_(inst_42773)){
var statearr_42797_43017 = state_42783__$1;
(statearr_42797_43017[(1)] = (10));

} else {
var statearr_42798_43018 = state_42783__$1;
(statearr_42798_43018[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42784 === (5))){
var _ = (function (){var statearr_42799 = state_42783;
(statearr_42799[(4)] = cljs.core.rest((state_42783[(4)])));

return statearr_42799;
})();
var state_42783__$1 = state_42783;
var ex42794 = (state_42783__$1[(2)]);
var statearr_42800_43019 = state_42783__$1;
(statearr_42800_43019[(5)] = ex42794);


if((ex42794 instanceof Error)){
var statearr_42801_43020 = state_42783__$1;
(statearr_42801_43020[(1)] = (4));

(statearr_42801_43020[(5)] = null);

} else {
throw ex42794;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42784 === (10))){
var state_42783__$1 = state_42783;
var statearr_42802_43021 = state_42783__$1;
(statearr_42802_43021[(2)] = null);

(statearr_42802_43021[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42784 === (8))){
var inst_42766 = (state_42783[(7)]);
var inst_42770 = cljs.core.first(inst_42766);
var state_42783__$1 = state_42783;
var statearr_42803_43022 = state_42783__$1;
(statearr_42803_43022[(2)] = inst_42770);

(statearr_42803_43022[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16153__auto__ = null;
var fluree$db$graphdb$state_machine__16153__auto____0 = (function (){
var statearr_42804 = [null,null,null,null,null,null,null,null,null];
(statearr_42804[(0)] = fluree$db$graphdb$state_machine__16153__auto__);

(statearr_42804[(1)] = (1));

return statearr_42804;
});
var fluree$db$graphdb$state_machine__16153__auto____1 = (function (state_42783){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_42783);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e42805){var ex__16156__auto__ = e42805;
var statearr_42806_43023 = state_42783;
(statearr_42806_43023[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_42783[(4)]))){
var statearr_42807_43024 = state_42783;
(statearr_42807_43024[(1)] = cljs.core.first((state_42783[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__43025 = state_42783;
state_42783 = G__43025;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16153__auto__ = function(state_42783){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16153__auto____1.call(this,state_42783);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16153__auto____0;
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16153__auto____1;
return fluree$db$graphdb$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_42808 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_42808[(6)] = c__16227__auto__);

return statearr_42808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_42844){
var state_val_42845 = (state_42844[(1)]);
if((state_val_42845 === (7))){
var inst_42818 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_42844__$1 = state_42844;
var statearr_42846_43026 = state_42844__$1;
(statearr_42846_43026[(2)] = inst_42818);

(statearr_42846_43026[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (1))){
var state_42844__$1 = state_42844;
var statearr_42847_43027 = state_42844__$1;
(statearr_42847_43027[(2)] = null);

(statearr_42847_43027[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (4))){
var inst_42809 = (state_42844[(2)]);
var state_42844__$1 = state_42844;
var statearr_42848_43028 = state_42844__$1;
(statearr_42848_43028[(2)] = inst_42809);

(statearr_42848_43028[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (15))){
var inst_42839 = (state_42844[(2)]);
var _ = (function (){var statearr_42849 = state_42844;
(statearr_42849[(4)] = cljs.core.rest((state_42844[(4)])));

return statearr_42849;
})();
var state_42844__$1 = state_42844;
var statearr_42850_43029 = state_42844__$1;
(statearr_42850_43029[(2)] = inst_42839);

(statearr_42850_43029[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (13))){
var inst_42824 = (state_42844[(7)]);
var inst_42830 = clojure.string.includes_QMARK_(inst_42824,":");
var state_42844__$1 = state_42844;
if(inst_42830){
var statearr_42851_43030 = state_42844__$1;
(statearr_42851_43030[(1)] = (16));

} else {
var statearr_42852_43031 = state_42844__$1;
(statearr_42852_43031[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (6))){
var state_42844__$1 = state_42844;
var statearr_42853_43032 = state_42844__$1;
(statearr_42853_43032[(2)] = pred);

(statearr_42853_43032[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (17))){
var inst_42824 = (state_42844[(7)]);
var state_42844__$1 = state_42844;
var statearr_42854_43033 = state_42844__$1;
(statearr_42854_43033[(2)] = inst_42824);

(statearr_42854_43033[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (3))){
var inst_42842 = (state_42844[(2)]);
var state_42844__$1 = state_42844;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42844__$1,inst_42842);
} else {
if((state_val_42845 === (12))){
var inst_42828 = (state_42844[(2)]);
var state_42844__$1 = state_42844;
if(cljs.core.truth_(inst_42828)){
var statearr_42855_43034 = state_42844__$1;
(statearr_42855_43034[(1)] = (13));

} else {
var statearr_42856_43035 = state_42844__$1;
(statearr_42856_43035[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (2))){
var _ = (function (){var statearr_42857 = state_42844;
(statearr_42857[(4)] = cljs.core.cons((5),(state_42844[(4)])));

return statearr_42857;
})();
var inst_42815 = typeof pred === 'string';
var state_42844__$1 = state_42844;
if(cljs.core.truth_(inst_42815)){
var statearr_42858_43036 = state_42844__$1;
(statearr_42858_43036[(1)] = (6));

} else {
var statearr_42859_43037 = state_42844__$1;
(statearr_42859_43037[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (11))){
var inst_42820 = (state_42844[(8)]);
var state_42844__$1 = state_42844;
var statearr_42861_43038 = state_42844__$1;
(statearr_42861_43038[(2)] = inst_42820);

(statearr_42861_43038[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (9))){
var inst_42820 = (state_42844[(8)]);
var inst_42823 = (state_42844[(2)]);
var inst_42824 = fluree.db.util.async.throw_err(inst_42823);
var state_42844__$1 = (function (){var statearr_42862 = state_42844;
(statearr_42862[(7)] = inst_42824);

return statearr_42862;
})();
if(cljs.core.truth_(inst_42820)){
var statearr_42863_43039 = state_42844__$1;
(statearr_42863_43039[(1)] = (10));

} else {
var statearr_42864_43040 = state_42844__$1;
(statearr_42864_43040[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (5))){
var _ = (function (){var statearr_42865 = state_42844;
(statearr_42865[(4)] = cljs.core.rest((state_42844[(4)])));

return statearr_42865;
})();
var state_42844__$1 = state_42844;
var ex42860 = (state_42844__$1[(2)]);
var statearr_42866_43041 = state_42844__$1;
(statearr_42866_43041[(5)] = ex42860);


if((ex42860 instanceof Error)){
var statearr_42867_43042 = state_42844__$1;
(statearr_42867_43042[(1)] = (4));

(statearr_42867_43042[(5)] = null);

} else {
throw ex42860;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (14))){
var state_42844__$1 = state_42844;
var statearr_42868_43043 = state_42844__$1;
(statearr_42868_43043[(2)] = null);

(statearr_42868_43043[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (16))){
var inst_42824 = (state_42844[(7)]);
var inst_42832 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_42824,/:/);
var inst_42833 = cljs.core.second(inst_42832);
var state_42844__$1 = state_42844;
var statearr_42869_43044 = state_42844__$1;
(statearr_42869_43044[(2)] = inst_42833);

(statearr_42869_43044[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (10))){
var inst_42824 = (state_42844[(7)]);
var state_42844__$1 = state_42844;
var statearr_42870_43045 = state_42844__$1;
(statearr_42870_43045[(2)] = inst_42824);

(statearr_42870_43045[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (18))){
var inst_42836 = (state_42844[(2)]);
var state_42844__$1 = state_42844;
var statearr_42871_43046 = state_42844__$1;
(statearr_42871_43046[(2)] = inst_42836);

(statearr_42871_43046[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42845 === (8))){
var inst_42820 = (state_42844[(2)]);
var inst_42821 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_42844__$1 = (function (){var statearr_42872 = state_42844;
(statearr_42872[(8)] = inst_42820);

return statearr_42872;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42844__$1,(9),inst_42821);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16153__auto__ = null;
var fluree$db$graphdb$state_machine__16153__auto____0 = (function (){
var statearr_42873 = [null,null,null,null,null,null,null,null,null];
(statearr_42873[(0)] = fluree$db$graphdb$state_machine__16153__auto__);

(statearr_42873[(1)] = (1));

return statearr_42873;
});
var fluree$db$graphdb$state_machine__16153__auto____1 = (function (state_42844){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_42844);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e42874){var ex__16156__auto__ = e42874;
var statearr_42875_43047 = state_42844;
(statearr_42875_43047[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_42844[(4)]))){
var statearr_42876_43048 = state_42844;
(statearr_42876_43048[(1)] = cljs.core.first((state_42844[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__43049 = state_42844;
state_42844 = G__43049;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16153__auto__ = function(state_42844){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16153__auto____1.call(this,state_42844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16153__auto____0;
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16153__auto____1;
return fluree$db$graphdb$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_42877 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_42877[(6)] = c__16227__auto__);

return statearr_42877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_42910){
var state_val_42911 = (state_42910[(1)]);
if((state_val_42911 === (7))){
var state_42910__$1 = state_42910;
var statearr_42912_43050 = state_42910__$1;
(statearr_42912_43050[(2)] = null);

(statearr_42912_43050[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42911 === (1))){
var state_42910__$1 = state_42910;
var statearr_42913_43051 = state_42910__$1;
(statearr_42913_43051[(2)] = null);

(statearr_42913_43051[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42911 === (4))){
var inst_42878 = (state_42910[(2)]);
var state_42910__$1 = state_42910;
var statearr_42914_43052 = state_42910__$1;
(statearr_42914_43052[(2)] = inst_42878);

(statearr_42914_43052[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42911 === (6))){
var inst_42893 = (state_42910[(7)]);
var inst_42892 = (state_42910[(2)]);
var inst_42893__$1 = fluree.db.util.async.throw_err(inst_42892);
var inst_42894 = (inst_42893__$1 == null);
var state_42910__$1 = (function (){var statearr_42915 = state_42910;
(statearr_42915[(7)] = inst_42893__$1);

return statearr_42915;
})();
if(cljs.core.truth_(inst_42894)){
var statearr_42916_43053 = state_42910__$1;
(statearr_42916_43053[(1)] = (7));

} else {
var statearr_42917_43054 = state_42910__$1;
(statearr_42917_43054[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42911 === (3))){
var inst_42908 = (state_42910[(2)]);
var state_42910__$1 = state_42910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42910__$1,inst_42908);
} else {
if((state_val_42911 === (12))){
var inst_42905 = (state_42910[(2)]);
var _ = (function (){var statearr_42918 = state_42910;
(statearr_42918[(4)] = cljs.core.rest((state_42910[(4)])));

return statearr_42918;
})();
var state_42910__$1 = state_42910;
var statearr_42919_43055 = state_42910__$1;
(statearr_42919_43055[(2)] = inst_42905);

(statearr_42919_43055[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42911 === (2))){
var _ = (function (){var statearr_42920 = state_42910;
(statearr_42920[(4)] = cljs.core.cons((5),(state_42910[(4)])));

return statearr_42920;
})();
var inst_42884 = (30);
var inst_42886 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_42887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42888 = [inst_42884,tag_name];
var inst_42889 = (new cljs.core.PersistentVector(null,2,(5),inst_42887,inst_42888,null));
var inst_42890 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_42886,cljs.core.cst$kw$post,cljs.core._EQ_,inst_42889);
var state_42910__$1 = state_42910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42910__$1,(6),inst_42890);
} else {
if((state_val_42911 === (11))){
var inst_42899 = (state_42910[(8)]);
var inst_42903 = inst_42899.s;
var state_42910__$1 = state_42910;
var statearr_42922_43056 = state_42910__$1;
(statearr_42922_43056[(2)] = inst_42903);

(statearr_42922_43056[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42911 === (9))){
var inst_42899 = (state_42910[(8)]);
var inst_42899__$1 = (state_42910[(2)]);
var inst_42900 = (inst_42899__$1 == null);
var state_42910__$1 = (function (){var statearr_42923 = state_42910;
(statearr_42923[(8)] = inst_42899__$1);

return statearr_42923;
})();
if(cljs.core.truth_(inst_42900)){
var statearr_42924_43057 = state_42910__$1;
(statearr_42924_43057[(1)] = (10));

} else {
var statearr_42925_43058 = state_42910__$1;
(statearr_42925_43058[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42911 === (5))){
var _ = (function (){var statearr_42926 = state_42910;
(statearr_42926[(4)] = cljs.core.rest((state_42910[(4)])));

return statearr_42926;
})();
var state_42910__$1 = state_42910;
var ex42921 = (state_42910__$1[(2)]);
var statearr_42927_43059 = state_42910__$1;
(statearr_42927_43059[(5)] = ex42921);


if((ex42921 instanceof Error)){
var statearr_42928_43060 = state_42910__$1;
(statearr_42928_43060[(1)] = (4));

(statearr_42928_43060[(5)] = null);

} else {
throw ex42921;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42911 === (10))){
var state_42910__$1 = state_42910;
var statearr_42929_43061 = state_42910__$1;
(statearr_42929_43061[(2)] = null);

(statearr_42929_43061[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42911 === (8))){
var inst_42893 = (state_42910[(7)]);
var inst_42897 = cljs.core.first(inst_42893);
var state_42910__$1 = state_42910;
var statearr_42930_43062 = state_42910__$1;
(statearr_42930_43062[(2)] = inst_42897);

(statearr_42930_43062[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16153__auto__ = null;
var fluree$db$graphdb$state_machine__16153__auto____0 = (function (){
var statearr_42931 = [null,null,null,null,null,null,null,null,null];
(statearr_42931[(0)] = fluree$db$graphdb$state_machine__16153__auto__);

(statearr_42931[(1)] = (1));

return statearr_42931;
});
var fluree$db$graphdb$state_machine__16153__auto____1 = (function (state_42910){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_42910);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e42932){var ex__16156__auto__ = e42932;
var statearr_42933_43063 = state_42910;
(statearr_42933_43063[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_42910[(4)]))){
var statearr_42934_43064 = state_42910;
(statearr_42934_43064[(1)] = cljs.core.first((state_42910[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__43065 = state_42910;
state_42910 = G__43065;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16153__auto__ = function(state_42910){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16153__auto____1.call(this,state_42910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16153__auto____0;
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16153__auto____1;
return fluree$db$graphdb$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_42935 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_42935[(6)] = c__16227__auto__);

return statearr_42935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_42970){
var state_val_42971 = (state_42970[(1)]);
if((state_val_42971 === (7))){
var inst_42949 = typeof pred === 'string';
var state_42970__$1 = state_42970;
if(cljs.core.truth_(inst_42949)){
var statearr_42972_43066 = state_42970__$1;
(statearr_42972_43066[(1)] = (10));

} else {
var statearr_42973_43067 = state_42970__$1;
(statearr_42973_43067[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42971 === (1))){
var state_42970__$1 = state_42970;
var statearr_42974_43068 = state_42970__$1;
(statearr_42974_43068[(2)] = null);

(statearr_42974_43068[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42971 === (4))){
var inst_42936 = (state_42970[(2)]);
var state_42970__$1 = state_42970;
var statearr_42975_43069 = state_42970__$1;
(statearr_42975_43069[(2)] = inst_42936);

(statearr_42975_43069[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42971 === (15))){
var inst_42963 = (state_42970[(2)]);
var state_42970__$1 = state_42970;
var statearr_42976_43070 = state_42970__$1;
(statearr_42976_43070[(2)] = inst_42963);

(statearr_42976_43070[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42971 === (13))){
var inst_42954 = (state_42970[(7)]);
var inst_42956 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42954),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_42957 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_42956);
var state_42970__$1 = state_42970;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42970__$1,(16),inst_42957);
} else {
if((state_val_42971 === (6))){
var inst_42944 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_42970__$1 = state_42970;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42970__$1,(9),inst_42944);
} else {
if((state_val_42971 === (3))){
var inst_42968 = (state_42970[(2)]);
var state_42970__$1 = state_42970;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42970__$1,inst_42968);
} else {
if((state_val_42971 === (12))){
var inst_42954 = (state_42970[(7)]);
var inst_42954__$1 = (state_42970[(2)]);
var state_42970__$1 = (function (){var statearr_42977 = state_42970;
(statearr_42977[(7)] = inst_42954__$1);

return statearr_42977;
})();
if(cljs.core.truth_(inst_42954__$1)){
var statearr_42978_43071 = state_42970__$1;
(statearr_42978_43071[(1)] = (13));

} else {
var statearr_42979_43072 = state_42970__$1;
(statearr_42979_43072[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42971 === (2))){
var _ = (function (){var statearr_42980 = state_42970;
(statearr_42980[(4)] = cljs.core.cons((5),(state_42970[(4)])));

return statearr_42980;
})();
var inst_42942 = clojure.string.includes_QMARK_(tag_name,"/");
var state_42970__$1 = state_42970;
if(inst_42942){
var statearr_42981_43073 = state_42970__$1;
(statearr_42981_43073[(1)] = (6));

} else {
var statearr_42982_43074 = state_42970__$1;
(statearr_42982_43074[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42971 === (11))){
var inst_42952 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_42970__$1 = state_42970;
var statearr_42984_43075 = state_42970__$1;
(statearr_42984_43075[(2)] = inst_42952);

(statearr_42984_43075[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42971 === (9))){
var inst_42946 = (state_42970[(2)]);
var inst_42947 = fluree.db.util.async.throw_err(inst_42946);
var state_42970__$1 = state_42970;
var statearr_42985_43076 = state_42970__$1;
(statearr_42985_43076[(2)] = inst_42947);

(statearr_42985_43076[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42971 === (5))){
var _ = (function (){var statearr_42986 = state_42970;
(statearr_42986[(4)] = cljs.core.rest((state_42970[(4)])));

return statearr_42986;
})();
var state_42970__$1 = state_42970;
var ex42983 = (state_42970__$1[(2)]);
var statearr_42987_43077 = state_42970__$1;
(statearr_42987_43077[(5)] = ex42983);


if((ex42983 instanceof Error)){
var statearr_42988_43078 = state_42970__$1;
(statearr_42988_43078[(1)] = (4));

(statearr_42988_43078[(5)] = null);

} else {
throw ex42983;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42971 === (14))){
var state_42970__$1 = state_42970;
var statearr_42989_43079 = state_42970__$1;
(statearr_42989_43079[(2)] = null);

(statearr_42989_43079[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42971 === (16))){
var inst_42959 = (state_42970[(2)]);
var inst_42960 = fluree.db.util.async.throw_err(inst_42959);
var state_42970__$1 = state_42970;
var statearr_42990_43080 = state_42970__$1;
(statearr_42990_43080[(2)] = inst_42960);

(statearr_42990_43080[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42971 === (10))){
var state_42970__$1 = state_42970;
var statearr_42991_43081 = state_42970__$1;
(statearr_42991_43081[(2)] = pred);

(statearr_42991_43081[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42971 === (8))){
var inst_42965 = (state_42970[(2)]);
var _ = (function (){var statearr_42992 = state_42970;
(statearr_42992[(4)] = cljs.core.rest((state_42970[(4)])));

return statearr_42992;
})();
var state_42970__$1 = state_42970;
var statearr_42993_43082 = state_42970__$1;
(statearr_42993_43082[(2)] = inst_42965);

(statearr_42993_43082[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16153__auto__ = null;
var fluree$db$graphdb$state_machine__16153__auto____0 = (function (){
var statearr_42994 = [null,null,null,null,null,null,null,null];
(statearr_42994[(0)] = fluree$db$graphdb$state_machine__16153__auto__);

(statearr_42994[(1)] = (1));

return statearr_42994;
});
var fluree$db$graphdb$state_machine__16153__auto____1 = (function (state_42970){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_42970);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e42995){var ex__16156__auto__ = e42995;
var statearr_42996_43083 = state_42970;
(statearr_42996_43083[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_42970[(4)]))){
var statearr_42997_43084 = state_42970;
(statearr_42997_43084[(1)] = cljs.core.first((state_42970[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__43085 = state_42970;
state_42970 = G__43085;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16153__auto__ = function(state_42970){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16153__auto____1.call(this,state_42970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16153__auto____0;
fluree$db$graphdb$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16153__auto____1;
return fluree$db$graphdb$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_42998 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_42998[(6)] = c__16227__auto__);

return statearr_42998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__42667){
var extmap__4512__auto__ = (function (){var G__42999 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__42667,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__42667)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__42999);
} else {
return G__42999;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__42667),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__42667),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
