// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4878__auto___72366 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_72417){
var state_val_72418 = (state_72417[(1)]);
if((state_val_72418 === (7))){
var inst_72412 = (state_72417[(2)]);
var _ = (function (){var statearr_72419 = state_72417;
(statearr_72419[(4)] = cljs.core.rest((state_72417[(4)])));

return statearr_72419;
})();
var state_72417__$1 = state_72417;
var statearr_72420_72447 = state_72417__$1;
(statearr_72420_72447[(2)] = inst_72412);

(statearr_72420_72447[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72418 === (1))){
var state_72417__$1 = state_72417;
var statearr_72421_72448 = state_72417__$1;
(statearr_72421_72448[(2)] = null);

(statearr_72421_72448[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72418 === (4))){
var inst_72367 = (state_72417[(2)]);
var state_72417__$1 = state_72417;
var statearr_72422_72449 = state_72417__$1;
(statearr_72422_72449[(2)] = inst_72367);

(statearr_72422_72449[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72418 === (13))){
var inst_72408 = (state_72417[(2)]);
var state_72417__$1 = state_72417;
var statearr_72423_72450 = state_72417__$1;
(statearr_72423_72450[(2)] = inst_72408);

(statearr_72423_72450[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72418 === (6))){
var inst_72385 = (state_72417[(7)]);
var inst_72392 = (state_72417[(8)]);
var inst_72391 = cljs.core.seq(inst_72385);
var inst_72392__$1 = cljs.core.first(inst_72391);
var inst_72393 = cljs.core.next(inst_72391);
var inst_72394 = cljs.core.not(inst_72392__$1);
var state_72417__$1 = (function (){var statearr_72424 = state_72417;
(statearr_72424[(8)] = inst_72392__$1);

(statearr_72424[(9)] = inst_72393);

return statearr_72424;
})();
if(inst_72394){
var statearr_72425_72451 = state_72417__$1;
(statearr_72425_72451[(1)] = (8));

} else {
var statearr_72426_72452 = state_72417__$1;
(statearr_72426_72452[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72418 === (3))){
var inst_72415 = (state_72417[(2)]);
var state_72417__$1 = state_72417;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72417__$1,inst_72415);
} else {
if((state_val_72418 === (12))){
var inst_72392 = (state_72417[(8)]);
var inst_72393 = (state_72417[(9)]);
var inst_72386 = (state_72417[(10)]);
var inst_72405 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_72386,inst_72392);
var inst_72385 = inst_72393;
var inst_72386__$1 = inst_72405;
var state_72417__$1 = (function (){var statearr_72427 = state_72417;
(statearr_72427[(7)] = inst_72385);

(statearr_72427[(10)] = inst_72386__$1);

return statearr_72427;
})();
var statearr_72428_72453 = state_72417__$1;
(statearr_72428_72453[(2)] = null);

(statearr_72428_72453[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72418 === (2))){
var _ = (function (){var statearr_72429 = state_72417;
(statearr_72429[(4)] = cljs.core.cons((5),(state_72417[(4)])));

return statearr_72429;
})();
var inst_72380 = args;
var inst_72381 = cljs.core.seq(inst_72380);
var inst_72382 = cljs.core.first(inst_72381);
var inst_72383 = cljs.core.next(inst_72381);
var inst_72384 = cljs.core.PersistentVector.EMPTY;
var inst_72385 = inst_72380;
var inst_72386 = inst_72384;
var state_72417__$1 = (function (){var statearr_72430 = state_72417;
(statearr_72430[(11)] = inst_72382);

(statearr_72430[(7)] = inst_72385);

(statearr_72430[(12)] = inst_72383);

(statearr_72430[(10)] = inst_72386);

return statearr_72430;
})();
var statearr_72431_72454 = state_72417__$1;
(statearr_72431_72454[(2)] = null);

(statearr_72431_72454[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72418 === (11))){
var inst_72392 = (state_72417[(8)]);
var state_72417__$1 = state_72417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72417__$1,(14),inst_72392);
} else {
if((state_val_72418 === (9))){
var inst_72392 = (state_72417[(8)]);
var inst_72397 = fluree.db.util.async.channel_QMARK_(inst_72392);
var state_72417__$1 = state_72417;
if(inst_72397){
var statearr_72433_72455 = state_72417__$1;
(statearr_72433_72455[(1)] = (11));

} else {
var statearr_72434_72456 = state_72417__$1;
(statearr_72434_72456[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72418 === (5))){
var _ = (function (){var statearr_72435 = state_72417;
(statearr_72435[(4)] = cljs.core.rest((state_72417[(4)])));

return statearr_72435;
})();
var state_72417__$1 = state_72417;
var ex72432 = (state_72417__$1[(2)]);
var statearr_72436_72457 = state_72417__$1;
(statearr_72436_72457[(5)] = ex72432);


if((ex72432 instanceof Error)){
var statearr_72437_72458 = state_72417__$1;
(statearr_72437_72458[(1)] = (4));

(statearr_72437_72458[(5)] = null);

} else {
throw ex72432;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72418 === (14))){
var inst_72393 = (state_72417[(9)]);
var inst_72386 = (state_72417[(10)]);
var inst_72400 = (state_72417[(2)]);
var inst_72401 = fluree.db.util.async.throw_err(inst_72400);
var inst_72402 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_72386,inst_72401);
var inst_72385 = inst_72393;
var inst_72386__$1 = inst_72402;
var state_72417__$1 = (function (){var statearr_72438 = state_72417;
(statearr_72438[(7)] = inst_72385);

(statearr_72438[(10)] = inst_72386__$1);

return statearr_72438;
})();
var statearr_72439_72459 = state_72417__$1;
(statearr_72439_72459[(2)] = null);

(statearr_72439_72459[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72418 === (10))){
var inst_72410 = (state_72417[(2)]);
var state_72417__$1 = state_72417;
var statearr_72440_72460 = state_72417__$1;
(statearr_72440_72460[(2)] = inst_72410);

(statearr_72440_72460[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72418 === (8))){
var inst_72386 = (state_72417[(10)]);
var state_72417__$1 = state_72417;
var statearr_72441_72461 = state_72417__$1;
(statearr_72441_72461[(2)] = inst_72386);

(statearr_72441_72461[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16153__auto____0 = (function (){
var statearr_72442 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72442[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16153__auto__);

(statearr_72442[(1)] = (1));

return statearr_72442;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16153__auto____1 = (function (state_72417){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_72417);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e72443){var ex__16156__auto__ = e72443;
var statearr_72444_72462 = state_72417;
(statearr_72444_72462[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_72417[(4)]))){
var statearr_72445_72463 = state_72417;
(statearr_72445_72463[(1)] = cljs.core.first((state_72417[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__72464 = state_72417;
state_72417 = G__72464;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16153__auto__ = function(state_72417){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16153__auto____1.call(this,state_72417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_72446 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_72446[(6)] = c__16227__auto__);

return statearr_72446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__72465 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72465,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__72465,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_72513){
var state_val_72514 = (state_72513[(1)]);
if((state_val_72514 === (7))){
var state_72513__$1 = state_72513;
var statearr_72515_72544 = state_72513__$1;
(statearr_72515_72544[(2)] = coll);

(statearr_72515_72544[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72514 === (1))){
var state_72513__$1 = state_72513;
var statearr_72516_72545 = state_72513__$1;
(statearr_72516_72545[(2)] = null);

(statearr_72516_72545[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72514 === (4))){
var inst_72468 = (state_72513[(2)]);
var state_72513__$1 = state_72513;
var statearr_72517_72546 = state_72513__$1;
(statearr_72517_72546[(2)] = inst_72468);

(statearr_72517_72546[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72514 === (15))){
var inst_72487 = (state_72513[(7)]);
var inst_72495 = (state_72513[(2)]);
var inst_72496 = fluree.db.dbfunctions.internal.nth(inst_72487,inst_72495);
var inst_72497 = cljs.core.count(inst_72487);
var inst_72498 = ((9) + inst_72497);
var inst_72499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72500 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72502 = [inst_72487,inst_72495];
var inst_72503 = (new cljs.core.PersistentVector(null,2,(5),inst_72501,inst_72502,null));
var inst_72504 = ["nth",inst_72503,inst_72496];
var inst_72505 = cljs.core.PersistentHashMap.fromArrays(inst_72500,inst_72504);
var inst_72506 = [inst_72505,inst_72498];
var inst_72507 = (new cljs.core.PersistentVector(null,2,(5),inst_72499,inst_72506,null));
var inst_72508 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72507);
var _ = (function (){var statearr_72518 = state_72513;
(statearr_72518[(4)] = cljs.core.rest((state_72513[(4)])));

return statearr_72518;
})();
var state_72513__$1 = (function (){var statearr_72519 = state_72513;
(statearr_72519[(8)] = inst_72508);

return statearr_72519;
})();
var statearr_72520_72547 = state_72513__$1;
(statearr_72520_72547[(2)] = inst_72496);

(statearr_72520_72547[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72514 === (13))){
var state_72513__$1 = state_72513;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72513__$1,(16),key);
} else {
if((state_val_72514 === (6))){
var state_72513__$1 = state_72513;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72513__$1,(9),coll);
} else {
if((state_val_72514 === (3))){
var inst_72511 = (state_72513[(2)]);
var state_72513__$1 = state_72513;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72513__$1,inst_72511);
} else {
if((state_val_72514 === (12))){
var inst_72487 = (state_72513[(2)]);
var inst_72488 = fluree.db.util.async.channel_QMARK_(key);
var state_72513__$1 = (function (){var statearr_72521 = state_72513;
(statearr_72521[(7)] = inst_72487);

return statearr_72521;
})();
if(inst_72488){
var statearr_72522_72548 = state_72513__$1;
(statearr_72522_72548[(1)] = (13));

} else {
var statearr_72523_72549 = state_72513__$1;
(statearr_72523_72549[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72514 === (2))){
var _ = (function (){var statearr_72524 = state_72513;
(statearr_72524[(4)] = cljs.core.cons((5),(state_72513[(4)])));

return statearr_72524;
})();
var inst_72474 = fluree.db.util.async.channel_QMARK_(coll);
var state_72513__$1 = state_72513;
if(inst_72474){
var statearr_72525_72550 = state_72513__$1;
(statearr_72525_72550[(1)] = (6));

} else {
var statearr_72526_72551 = state_72513__$1;
(statearr_72526_72551[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72514 === (11))){
var inst_72481 = (state_72513[(9)]);
var state_72513__$1 = state_72513;
var statearr_72528_72552 = state_72513__$1;
(statearr_72528_72552[(2)] = inst_72481);

(statearr_72528_72552[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72514 === (9))){
var inst_72477 = (state_72513[(2)]);
var inst_72478 = fluree.db.util.async.throw_err(inst_72477);
var state_72513__$1 = state_72513;
var statearr_72529_72553 = state_72513__$1;
(statearr_72529_72553[(2)] = inst_72478);

(statearr_72529_72553[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72514 === (5))){
var _ = (function (){var statearr_72530 = state_72513;
(statearr_72530[(4)] = cljs.core.rest((state_72513[(4)])));

return statearr_72530;
})();
var state_72513__$1 = state_72513;
var ex72527 = (state_72513__$1[(2)]);
var statearr_72531_72554 = state_72513__$1;
(statearr_72531_72554[(5)] = ex72527);


if((ex72527 instanceof Error)){
var statearr_72532_72555 = state_72513__$1;
(statearr_72532_72555[(1)] = (4));

(statearr_72532_72555[(5)] = null);

} else {
throw ex72527;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72514 === (14))){
var state_72513__$1 = state_72513;
var statearr_72533_72556 = state_72513__$1;
(statearr_72533_72556[(2)] = key);

(statearr_72533_72556[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72514 === (16))){
var inst_72491 = (state_72513[(2)]);
var inst_72492 = fluree.db.util.async.throw_err(inst_72491);
var state_72513__$1 = state_72513;
var statearr_72534_72557 = state_72513__$1;
(statearr_72534_72557[(2)] = inst_72492);

(statearr_72534_72557[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72514 === (10))){
var inst_72481 = (state_72513[(9)]);
var inst_72484 = cljs.core.vec(inst_72481);
var state_72513__$1 = state_72513;
var statearr_72535_72558 = state_72513__$1;
(statearr_72535_72558[(2)] = inst_72484);

(statearr_72535_72558[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72514 === (8))){
var inst_72481 = (state_72513[(9)]);
var inst_72481__$1 = (state_72513[(2)]);
var inst_72482 = cljs.core.set_QMARK_(inst_72481__$1);
var state_72513__$1 = (function (){var statearr_72536 = state_72513;
(statearr_72536[(9)] = inst_72481__$1);

return statearr_72536;
})();
if(inst_72482){
var statearr_72537_72559 = state_72513__$1;
(statearr_72537_72559[(1)] = (10));

} else {
var statearr_72538_72560 = state_72513__$1;
(statearr_72538_72560[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__16153__auto____0 = (function (){
var statearr_72539 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72539[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__16153__auto__);

(statearr_72539[(1)] = (1));

return statearr_72539;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__16153__auto____1 = (function (state_72513){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_72513);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e72540){var ex__16156__auto__ = e72540;
var statearr_72541_72561 = state_72513;
(statearr_72541_72561[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_72513[(4)]))){
var statearr_72542_72562 = state_72513;
(statearr_72542_72562[(1)] = cljs.core.first((state_72513[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__72563 = state_72513;
state_72513 = G__72563;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__16153__auto__ = function(state_72513){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__16153__auto____1.call(this,state_72513);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_72543 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_72543[(6)] = c__16227__auto__);

return statearr_72543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_72624){
var state_val_72625 = (state_72624[(1)]);
if((state_val_72625 === (7))){
var state_72624__$1 = state_72624;
var statearr_72626_72660 = state_72624__$1;
(statearr_72626_72660[(2)] = test);

(statearr_72626_72660[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (20))){
var inst_72598 = (state_72624[(2)]);
var inst_72599 = fluree.db.util.async.throw_err(inst_72598);
var state_72624__$1 = state_72624;
var statearr_72627_72661 = state_72624__$1;
(statearr_72627_72661[(2)] = inst_72599);

(statearr_72627_72661[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (1))){
var state_72624__$1 = state_72624;
var statearr_72628_72662 = state_72624__$1;
(statearr_72628_72662[(2)] = null);

(statearr_72628_72662[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (4))){
var inst_72564 = (state_72624[(2)]);
var state_72624__$1 = state_72624;
var statearr_72629_72663 = state_72624__$1;
(statearr_72629_72663[(2)] = inst_72564);

(statearr_72629_72663[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (15))){
var inst_72582 = (state_72624[(7)]);
var inst_72590 = (state_72624[(2)]);
var inst_72591 = [inst_72590,f];
var inst_72592 = (new cljs.core.PersistentVector(null,2,(5),inst_72582,inst_72591,null));
var state_72624__$1 = state_72624;
var statearr_72630_72664 = state_72624__$1;
(statearr_72630_72664[(2)] = inst_72592);

(statearr_72630_72664[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (13))){
var state_72624__$1 = state_72624;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72624__$1,(16),t);
} else {
if((state_val_72625 === (6))){
var state_72624__$1 = state_72624;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72624__$1,(9),test);
} else {
if((state_val_72625 === (17))){
var state_72624__$1 = state_72624;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72624__$1,(20),f);
} else {
if((state_val_72625 === (3))){
var inst_72622 = (state_72624[(2)]);
var state_72624__$1 = state_72624;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72624__$1,inst_72622);
} else {
if((state_val_72625 === (12))){
var inst_72580 = (state_72624[(8)]);
var inst_72606 = (state_72624[(2)]);
var inst_72607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72606,(0),null);
var inst_72608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72606,(1),null);
var inst_72609 = fluree.db.dbfunctions.internal.if_else(inst_72580,inst_72607,inst_72608);
var inst_72610 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72611 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72613 = [inst_72580,inst_72607,inst_72608];
var inst_72614 = (new cljs.core.PersistentVector(null,3,(5),inst_72612,inst_72613,null));
var inst_72615 = ["if-else",inst_72614,inst_72609];
var inst_72616 = cljs.core.PersistentHashMap.fromArrays(inst_72611,inst_72615);
var inst_72617 = [inst_72616,(10)];
var inst_72618 = (new cljs.core.PersistentVector(null,2,(5),inst_72610,inst_72617,null));
var inst_72619 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72618);
var _ = (function (){var statearr_72631 = state_72624;
(statearr_72631[(4)] = cljs.core.rest((state_72624[(4)])));

return statearr_72631;
})();
var state_72624__$1 = (function (){var statearr_72632 = state_72624;
(statearr_72632[(9)] = inst_72619);

return statearr_72632;
})();
var statearr_72633_72665 = state_72624__$1;
(statearr_72633_72665[(2)] = inst_72609);

(statearr_72633_72665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (2))){
var _ = (function (){var statearr_72634 = state_72624;
(statearr_72634[(4)] = cljs.core.cons((5),(state_72624[(4)])));

return statearr_72634;
})();
var inst_72573 = fluree.db.util.async.channel_QMARK_(test);
var state_72624__$1 = state_72624;
if(inst_72573){
var statearr_72635_72666 = state_72624__$1;
(statearr_72635_72666[(1)] = (6));

} else {
var statearr_72636_72667 = state_72624__$1;
(statearr_72636_72667[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (19))){
var inst_72594 = (state_72624[(10)]);
var inst_72602 = (state_72624[(2)]);
var inst_72603 = [f,inst_72602];
var inst_72604 = (new cljs.core.PersistentVector(null,2,(5),inst_72594,inst_72603,null));
var state_72624__$1 = state_72624;
var statearr_72637_72668 = state_72624__$1;
(statearr_72637_72668[(2)] = inst_72604);

(statearr_72637_72668[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (11))){
var inst_72594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72595 = fluree.db.util.async.channel_QMARK_(f);
var state_72624__$1 = (function (){var statearr_72639 = state_72624;
(statearr_72639[(10)] = inst_72594);

return statearr_72639;
})();
if(inst_72595){
var statearr_72640_72669 = state_72624__$1;
(statearr_72640_72669[(1)] = (17));

} else {
var statearr_72641_72670 = state_72624__$1;
(statearr_72641_72670[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (9))){
var inst_72576 = (state_72624[(2)]);
var inst_72577 = fluree.db.util.async.throw_err(inst_72576);
var state_72624__$1 = state_72624;
var statearr_72642_72671 = state_72624__$1;
(statearr_72642_72671[(2)] = inst_72577);

(statearr_72642_72671[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (5))){
var _ = (function (){var statearr_72643 = state_72624;
(statearr_72643[(4)] = cljs.core.rest((state_72624[(4)])));

return statearr_72643;
})();
var state_72624__$1 = state_72624;
var ex72638 = (state_72624__$1[(2)]);
var statearr_72644_72672 = state_72624__$1;
(statearr_72644_72672[(5)] = ex72638);


if((ex72638 instanceof Error)){
var statearr_72645_72673 = state_72624__$1;
(statearr_72645_72673[(1)] = (4));

(statearr_72645_72673[(5)] = null);

} else {
throw ex72638;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (14))){
var state_72624__$1 = state_72624;
var statearr_72646_72674 = state_72624__$1;
(statearr_72646_72674[(2)] = t);

(statearr_72646_72674[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (16))){
var inst_72586 = (state_72624[(2)]);
var inst_72587 = fluree.db.util.async.throw_err(inst_72586);
var state_72624__$1 = state_72624;
var statearr_72647_72675 = state_72624__$1;
(statearr_72647_72675[(2)] = inst_72587);

(statearr_72647_72675[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (10))){
var inst_72582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72583 = fluree.db.util.async.channel_QMARK_(t);
var state_72624__$1 = (function (){var statearr_72648 = state_72624;
(statearr_72648[(7)] = inst_72582);

return statearr_72648;
})();
if(inst_72583){
var statearr_72649_72676 = state_72624__$1;
(statearr_72649_72676[(1)] = (13));

} else {
var statearr_72650_72677 = state_72624__$1;
(statearr_72650_72677[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (18))){
var state_72624__$1 = state_72624;
var statearr_72651_72678 = state_72624__$1;
(statearr_72651_72678[(2)] = f);

(statearr_72651_72678[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72625 === (8))){
var inst_72580 = (state_72624[(8)]);
var inst_72580__$1 = (state_72624[(2)]);
var state_72624__$1 = (function (){var statearr_72652 = state_72624;
(statearr_72652[(8)] = inst_72580__$1);

return statearr_72652;
})();
if(cljs.core.truth_(inst_72580__$1)){
var statearr_72653_72679 = state_72624__$1;
(statearr_72653_72679[(1)] = (10));

} else {
var statearr_72654_72680 = state_72624__$1;
(statearr_72654_72680[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__16153__auto____0 = (function (){
var statearr_72655 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_72655[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__16153__auto__);

(statearr_72655[(1)] = (1));

return statearr_72655;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__16153__auto____1 = (function (state_72624){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_72624);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e72656){var ex__16156__auto__ = e72656;
var statearr_72657_72681 = state_72624;
(statearr_72657_72681[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_72624[(4)]))){
var statearr_72658_72682 = state_72624;
(statearr_72658_72682[(1)] = cljs.core.first((state_72624[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__72683 = state_72624;
state_72624 = G__72683;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__16153__auto__ = function(state_72624){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__16153__auto____1.call(this,state_72624);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_72659 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_72659[(6)] = c__16227__auto__);

return statearr_72659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_72713){
var state_val_72714 = (state_72713[(1)]);
if((state_val_72714 === (7))){
var state_72713__$1 = state_72713;
var statearr_72715_72734 = state_72713__$1;
(statearr_72715_72734[(2)] = arg);

(statearr_72715_72734[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72714 === (1))){
var state_72713__$1 = state_72713;
var statearr_72716_72735 = state_72713__$1;
(statearr_72716_72735[(2)] = null);

(statearr_72716_72735[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72714 === (4))){
var inst_72684 = (state_72713[(2)]);
var state_72713__$1 = state_72713;
var statearr_72717_72736 = state_72713__$1;
(statearr_72717_72736[(2)] = inst_72684);

(statearr_72717_72736[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72714 === (6))){
var state_72713__$1 = state_72713;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72713__$1,(9),arg);
} else {
if((state_val_72714 === (3))){
var inst_72711 = (state_72713[(2)]);
var state_72713__$1 = state_72713;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72713__$1,inst_72711);
} else {
if((state_val_72714 === (2))){
var _ = (function (){var statearr_72719 = state_72713;
(statearr_72719[(4)] = cljs.core.cons((5),(state_72713[(4)])));

return statearr_72719;
})();
var inst_72690 = fluree.db.util.async.channel_QMARK_(arg);
var state_72713__$1 = state_72713;
if(inst_72690){
var statearr_72720_72737 = state_72713__$1;
(statearr_72720_72737[(1)] = (6));

} else {
var statearr_72721_72738 = state_72713__$1;
(statearr_72721_72738[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72714 === (9))){
var inst_72693 = (state_72713[(2)]);
var inst_72694 = fluree.db.util.async.throw_err(inst_72693);
var state_72713__$1 = state_72713;
var statearr_72722_72739 = state_72713__$1;
(statearr_72722_72739[(2)] = inst_72694);

(statearr_72722_72739[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72714 === (5))){
var _ = (function (){var statearr_72723 = state_72713;
(statearr_72723[(4)] = cljs.core.rest((state_72713[(4)])));

return statearr_72723;
})();
var state_72713__$1 = state_72713;
var ex72718 = (state_72713__$1[(2)]);
var statearr_72724_72740 = state_72713__$1;
(statearr_72724_72740[(5)] = ex72718);


if((ex72718 instanceof Error)){
var statearr_72725_72741 = state_72713__$1;
(statearr_72725_72741[(1)] = (4));

(statearr_72725_72741[(5)] = null);

} else {
throw ex72718;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72714 === (8))){
var inst_72697 = (state_72713[(2)]);
var inst_72698 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_72697);
var inst_72699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72700 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72702 = [inst_72697];
var inst_72703 = (new cljs.core.PersistentVector(null,1,(5),inst_72701,inst_72702,null));
var inst_72704 = ["nil?",inst_72703,inst_72698];
var inst_72705 = cljs.core.PersistentHashMap.fromArrays(inst_72700,inst_72704);
var inst_72706 = [inst_72705,(10)];
var inst_72707 = (new cljs.core.PersistentVector(null,2,(5),inst_72699,inst_72706,null));
var inst_72708 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72707);
var _ = (function (){var statearr_72726 = state_72713;
(statearr_72726[(4)] = cljs.core.rest((state_72713[(4)])));

return statearr_72726;
})();
var state_72713__$1 = (function (){var statearr_72727 = state_72713;
(statearr_72727[(7)] = inst_72708);

return statearr_72727;
})();
var statearr_72728_72742 = state_72713__$1;
(statearr_72728_72742[(2)] = inst_72698);

(statearr_72728_72742[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16153__auto____0 = (function (){
var statearr_72729 = [null,null,null,null,null,null,null,null];
(statearr_72729[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16153__auto__);

(statearr_72729[(1)] = (1));

return statearr_72729;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16153__auto____1 = (function (state_72713){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_72713);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e72730){var ex__16156__auto__ = e72730;
var statearr_72731_72743 = state_72713;
(statearr_72731_72743[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_72713[(4)]))){
var statearr_72732_72744 = state_72713;
(statearr_72732_72744[(1)] = cljs.core.first((state_72713[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__72745 = state_72713;
state_72713 = G__72745;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16153__auto__ = function(state_72713){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16153__auto____1.call(this,state_72713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_72733 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_72733[(6)] = c__16227__auto__);

return statearr_72733;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_72775){
var state_val_72776 = (state_72775[(1)]);
if((state_val_72776 === (7))){
var state_72775__$1 = state_72775;
var statearr_72777_72796 = state_72775__$1;
(statearr_72777_72796[(2)] = arg);

(statearr_72777_72796[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72776 === (1))){
var state_72775__$1 = state_72775;
var statearr_72778_72797 = state_72775__$1;
(statearr_72778_72797[(2)] = null);

(statearr_72778_72797[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72776 === (4))){
var inst_72746 = (state_72775[(2)]);
var state_72775__$1 = state_72775;
var statearr_72779_72798 = state_72775__$1;
(statearr_72779_72798[(2)] = inst_72746);

(statearr_72779_72798[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72776 === (6))){
var state_72775__$1 = state_72775;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72775__$1,(9),arg);
} else {
if((state_val_72776 === (3))){
var inst_72773 = (state_72775[(2)]);
var state_72775__$1 = state_72775;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72775__$1,inst_72773);
} else {
if((state_val_72776 === (2))){
var _ = (function (){var statearr_72781 = state_72775;
(statearr_72781[(4)] = cljs.core.cons((5),(state_72775[(4)])));

return statearr_72781;
})();
var inst_72752 = fluree.db.util.async.channel_QMARK_(arg);
var state_72775__$1 = state_72775;
if(inst_72752){
var statearr_72782_72799 = state_72775__$1;
(statearr_72782_72799[(1)] = (6));

} else {
var statearr_72783_72800 = state_72775__$1;
(statearr_72783_72800[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72776 === (9))){
var inst_72755 = (state_72775[(2)]);
var inst_72756 = fluree.db.util.async.throw_err(inst_72755);
var state_72775__$1 = state_72775;
var statearr_72784_72801 = state_72775__$1;
(statearr_72784_72801[(2)] = inst_72756);

(statearr_72784_72801[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72776 === (5))){
var _ = (function (){var statearr_72785 = state_72775;
(statearr_72785[(4)] = cljs.core.rest((state_72775[(4)])));

return statearr_72785;
})();
var state_72775__$1 = state_72775;
var ex72780 = (state_72775__$1[(2)]);
var statearr_72786_72802 = state_72775__$1;
(statearr_72786_72802[(5)] = ex72780);


if((ex72780 instanceof Error)){
var statearr_72787_72803 = state_72775__$1;
(statearr_72787_72803[(1)] = (4));

(statearr_72787_72803[(5)] = null);

} else {
throw ex72780;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72776 === (8))){
var inst_72759 = (state_72775[(2)]);
var inst_72760 = fluree.db.dbfunctions.internal.not(inst_72759);
var inst_72761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72762 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72764 = [inst_72759];
var inst_72765 = (new cljs.core.PersistentVector(null,1,(5),inst_72763,inst_72764,null));
var inst_72766 = ["not?",inst_72765,inst_72760];
var inst_72767 = cljs.core.PersistentHashMap.fromArrays(inst_72762,inst_72766);
var inst_72768 = [inst_72767,(10)];
var inst_72769 = (new cljs.core.PersistentVector(null,2,(5),inst_72761,inst_72768,null));
var inst_72770 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72769);
var _ = (function (){var statearr_72788 = state_72775;
(statearr_72788[(4)] = cljs.core.rest((state_72775[(4)])));

return statearr_72788;
})();
var state_72775__$1 = (function (){var statearr_72789 = state_72775;
(statearr_72789[(7)] = inst_72770);

return statearr_72789;
})();
var statearr_72790_72804 = state_72775__$1;
(statearr_72790_72804[(2)] = inst_72760);

(statearr_72790_72804[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__16153__auto____0 = (function (){
var statearr_72791 = [null,null,null,null,null,null,null,null];
(statearr_72791[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__16153__auto__);

(statearr_72791[(1)] = (1));

return statearr_72791;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__16153__auto____1 = (function (state_72775){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_72775);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e72792){var ex__16156__auto__ = e72792;
var statearr_72793_72805 = state_72775;
(statearr_72793_72805[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_72775[(4)]))){
var statearr_72794_72806 = state_72775;
(statearr_72794_72806[(1)] = cljs.core.first((state_72775[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__72807 = state_72775;
state_72775 = G__72807;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__16153__auto__ = function(state_72775){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__16153__auto____1.call(this,state_72775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_72795 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_72795[(6)] = c__16227__auto__);

return statearr_72795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_72837){
var state_val_72838 = (state_72837[(1)]);
if((state_val_72838 === (7))){
var state_72837__$1 = state_72837;
var statearr_72839_72858 = state_72837__$1;
(statearr_72839_72858[(2)] = arg);

(statearr_72839_72858[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72838 === (1))){
var state_72837__$1 = state_72837;
var statearr_72840_72859 = state_72837__$1;
(statearr_72840_72859[(2)] = null);

(statearr_72840_72859[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72838 === (4))){
var inst_72808 = (state_72837[(2)]);
var state_72837__$1 = state_72837;
var statearr_72841_72860 = state_72837__$1;
(statearr_72841_72860[(2)] = inst_72808);

(statearr_72841_72860[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72838 === (6))){
var state_72837__$1 = state_72837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72837__$1,(9),arg);
} else {
if((state_val_72838 === (3))){
var inst_72835 = (state_72837[(2)]);
var state_72837__$1 = state_72837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72837__$1,inst_72835);
} else {
if((state_val_72838 === (2))){
var _ = (function (){var statearr_72843 = state_72837;
(statearr_72843[(4)] = cljs.core.cons((5),(state_72837[(4)])));

return statearr_72843;
})();
var inst_72814 = fluree.db.util.async.channel_QMARK_(arg);
var state_72837__$1 = state_72837;
if(inst_72814){
var statearr_72844_72861 = state_72837__$1;
(statearr_72844_72861[(1)] = (6));

} else {
var statearr_72845_72862 = state_72837__$1;
(statearr_72845_72862[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72838 === (9))){
var inst_72817 = (state_72837[(2)]);
var inst_72818 = fluree.db.util.async.throw_err(inst_72817);
var state_72837__$1 = state_72837;
var statearr_72846_72863 = state_72837__$1;
(statearr_72846_72863[(2)] = inst_72818);

(statearr_72846_72863[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72838 === (5))){
var _ = (function (){var statearr_72847 = state_72837;
(statearr_72847[(4)] = cljs.core.rest((state_72837[(4)])));

return statearr_72847;
})();
var state_72837__$1 = state_72837;
var ex72842 = (state_72837__$1[(2)]);
var statearr_72848_72864 = state_72837__$1;
(statearr_72848_72864[(5)] = ex72842);


if((ex72842 instanceof Error)){
var statearr_72849_72865 = state_72837__$1;
(statearr_72849_72865[(1)] = (4));

(statearr_72849_72865[(5)] = null);

} else {
throw ex72842;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72838 === (8))){
var inst_72821 = (state_72837[(2)]);
var inst_72822 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_72821);
var inst_72823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72824 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72826 = [inst_72821];
var inst_72827 = (new cljs.core.PersistentVector(null,1,(5),inst_72825,inst_72826,null));
var inst_72828 = ["empty?",inst_72827,inst_72822];
var inst_72829 = cljs.core.PersistentHashMap.fromArrays(inst_72824,inst_72828);
var inst_72830 = [inst_72829,(10)];
var inst_72831 = (new cljs.core.PersistentVector(null,2,(5),inst_72823,inst_72830,null));
var inst_72832 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72831);
var _ = (function (){var statearr_72850 = state_72837;
(statearr_72850[(4)] = cljs.core.rest((state_72837[(4)])));

return statearr_72850;
})();
var state_72837__$1 = (function (){var statearr_72851 = state_72837;
(statearr_72851[(7)] = inst_72832);

return statearr_72851;
})();
var statearr_72852_72866 = state_72837__$1;
(statearr_72852_72866[(2)] = inst_72822);

(statearr_72852_72866[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16153__auto____0 = (function (){
var statearr_72853 = [null,null,null,null,null,null,null,null];
(statearr_72853[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16153__auto__);

(statearr_72853[(1)] = (1));

return statearr_72853;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16153__auto____1 = (function (state_72837){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_72837);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e72854){var ex__16156__auto__ = e72854;
var statearr_72855_72867 = state_72837;
(statearr_72855_72867[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_72837[(4)]))){
var statearr_72856_72868 = state_72837;
(statearr_72856_72868[(1)] = cljs.core.first((state_72837[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__72869 = state_72837;
state_72837 = G__72869;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16153__auto__ = function(state_72837){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16153__auto____1.call(this,state_72837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_72857 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_72857[(6)] = c__16227__auto__);

return statearr_72857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___72914 = arguments.length;
var i__4830__auto___72915 = (0);
while(true){
if((i__4830__auto___72915 < len__4829__auto___72914)){
args__4835__auto__.push((arguments[i__4830__auto___72915]));

var G__72916 = (i__4830__auto___72915 + (1));
i__4830__auto___72915 = G__72916;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_72897){
var state_val_72898 = (state_72897[(1)]);
if((state_val_72898 === (1))){
var state_72897__$1 = state_72897;
var statearr_72899_72917 = state_72897__$1;
(statearr_72899_72917[(2)] = null);

(statearr_72899_72917[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72898 === (2))){
var _ = (function (){var statearr_72900 = state_72897;
(statearr_72900[(4)] = cljs.core.cons((5),(state_72897[(4)])));

return statearr_72900;
})();
var inst_72878 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72897__$1 = state_72897;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72897__$1,(6),inst_72878);
} else {
if((state_val_72898 === (3))){
var inst_72895 = (state_72897[(2)]);
var state_72897__$1 = state_72897;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72897__$1,inst_72895);
} else {
if((state_val_72898 === (4))){
var inst_72872 = (state_72897[(2)]);
var state_72897__$1 = state_72897;
var statearr_72902_72918 = state_72897__$1;
(statearr_72902_72918[(2)] = inst_72872);

(statearr_72902_72918[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72898 === (5))){
var _ = (function (){var statearr_72903 = state_72897;
(statearr_72903[(4)] = cljs.core.rest((state_72897[(4)])));

return statearr_72903;
})();
var state_72897__$1 = state_72897;
var ex72901 = (state_72897__$1[(2)]);
var statearr_72904_72919 = state_72897__$1;
(statearr_72904_72919[(5)] = ex72901);


if((ex72901 instanceof Error)){
var statearr_72905_72920 = state_72897__$1;
(statearr_72905_72920[(1)] = (4));

(statearr_72905_72920[(5)] = null);

} else {
throw ex72901;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72898 === (6))){
var inst_72880 = (state_72897[(2)]);
var inst_72881 = fluree.db.util.async.throw_err(inst_72880);
var inst_72882 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_72881);
var inst_72883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72884 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72886 = [inst_72881];
var inst_72887 = (new cljs.core.PersistentVector(null,1,(5),inst_72885,inst_72886,null));
var inst_72888 = ["str",inst_72887,inst_72882];
var inst_72889 = cljs.core.PersistentHashMap.fromArrays(inst_72884,inst_72888);
var inst_72890 = [inst_72889,(10)];
var inst_72891 = (new cljs.core.PersistentVector(null,2,(5),inst_72883,inst_72890,null));
var inst_72892 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72891);
var _ = (function (){var statearr_72906 = state_72897;
(statearr_72906[(4)] = cljs.core.rest((state_72897[(4)])));

return statearr_72906;
})();
var state_72897__$1 = (function (){var statearr_72907 = state_72897;
(statearr_72907[(7)] = inst_72892);

return statearr_72907;
})();
var statearr_72908_72921 = state_72897__$1;
(statearr_72908_72921[(2)] = inst_72882);

(statearr_72908_72921[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_72909 = [null,null,null,null,null,null,null,null];
(statearr_72909[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_72909[(1)] = (1));

return statearr_72909;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_72897){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_72897);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e72910){var ex__16156__auto__ = e72910;
var statearr_72911_72922 = state_72897;
(statearr_72911_72922[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_72897[(4)]))){
var statearr_72912_72923 = state_72897;
(statearr_72912_72923[(1)] = cljs.core.first((state_72897[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__72924 = state_72897;
state_72897 = G__72924;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_72897){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_72897);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_72913 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_72913[(6)] = c__16227__auto__);

return statearr_72913;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq72870){
var G__72871 = cljs.core.first(seq72870);
var seq72870__$1 = cljs.core.next(seq72870);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__72871,seq72870__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_72950){
var state_val_72951 = (state_72950[(1)]);
if((state_val_72951 === (1))){
var state_72950__$1 = state_72950;
var statearr_72952_72967 = state_72950__$1;
(statearr_72952_72967[(2)] = null);

(statearr_72952_72967[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72951 === (2))){
var _ = (function (){var statearr_72953 = state_72950;
(statearr_72953[(4)] = cljs.core.cons((5),(state_72950[(4)])));

return statearr_72953;
})();
var inst_72931 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72950__$1 = state_72950;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72950__$1,(6),inst_72931);
} else {
if((state_val_72951 === (3))){
var inst_72948 = (state_72950[(2)]);
var state_72950__$1 = state_72950;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72950__$1,inst_72948);
} else {
if((state_val_72951 === (4))){
var inst_72925 = (state_72950[(2)]);
var state_72950__$1 = state_72950;
var statearr_72955_72968 = state_72950__$1;
(statearr_72955_72968[(2)] = inst_72925);

(statearr_72955_72968[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72951 === (5))){
var _ = (function (){var statearr_72956 = state_72950;
(statearr_72956[(4)] = cljs.core.rest((state_72950[(4)])));

return statearr_72956;
})();
var state_72950__$1 = state_72950;
var ex72954 = (state_72950__$1[(2)]);
var statearr_72957_72969 = state_72950__$1;
(statearr_72957_72969[(5)] = ex72954);


if((ex72954 instanceof Error)){
var statearr_72958_72970 = state_72950__$1;
(statearr_72958_72970[(1)] = (4));

(statearr_72958_72970[(5)] = null);

} else {
throw ex72954;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72951 === (6))){
var inst_72933 = (state_72950[(2)]);
var inst_72934 = fluree.db.util.async.throw_err(inst_72933);
var inst_72935 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_72934);
var inst_72936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72937 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72939 = [inst_72934];
var inst_72940 = (new cljs.core.PersistentVector(null,1,(5),inst_72938,inst_72939,null));
var inst_72941 = ["subs",inst_72940,inst_72935];
var inst_72942 = cljs.core.PersistentHashMap.fromArrays(inst_72937,inst_72941);
var inst_72943 = [inst_72942,(30)];
var inst_72944 = (new cljs.core.PersistentVector(null,2,(5),inst_72936,inst_72943,null));
var inst_72945 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72944);
var _ = (function (){var statearr_72959 = state_72950;
(statearr_72959[(4)] = cljs.core.rest((state_72950[(4)])));

return statearr_72959;
})();
var state_72950__$1 = (function (){var statearr_72960 = state_72950;
(statearr_72960[(7)] = inst_72945);

return statearr_72960;
})();
var statearr_72961_72971 = state_72950__$1;
(statearr_72961_72971[(2)] = inst_72935);

(statearr_72961_72971[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__16153__auto____0 = (function (){
var statearr_72962 = [null,null,null,null,null,null,null,null];
(statearr_72962[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__16153__auto__);

(statearr_72962[(1)] = (1));

return statearr_72962;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__16153__auto____1 = (function (state_72950){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_72950);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e72963){var ex__16156__auto__ = e72963;
var statearr_72964_72972 = state_72950;
(statearr_72964_72972[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_72950[(4)]))){
var statearr_72965_72973 = state_72950;
(statearr_72965_72973[(1)] = cljs.core.first((state_72950[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__72974 = state_72950;
state_72950 = G__72974;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__16153__auto__ = function(state_72950){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__16153__auto____1.call(this,state_72950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_72966 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_72966[(6)] = c__16227__auto__);

return statearr_72966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73004){
var state_val_73005 = (state_73004[(1)]);
if((state_val_73005 === (7))){
var state_73004__$1 = state_73004;
var statearr_73006_73025 = state_73004__$1;
(statearr_73006_73025[(2)] = str);

(statearr_73006_73025[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73005 === (1))){
var state_73004__$1 = state_73004;
var statearr_73007_73026 = state_73004__$1;
(statearr_73007_73026[(2)] = null);

(statearr_73007_73026[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73005 === (4))){
var inst_72975 = (state_73004[(2)]);
var state_73004__$1 = state_73004;
var statearr_73008_73027 = state_73004__$1;
(statearr_73008_73027[(2)] = inst_72975);

(statearr_73008_73027[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73005 === (6))){
var state_73004__$1 = state_73004;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73004__$1,(9),str);
} else {
if((state_val_73005 === (3))){
var inst_73002 = (state_73004[(2)]);
var state_73004__$1 = state_73004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73004__$1,inst_73002);
} else {
if((state_val_73005 === (2))){
var _ = (function (){var statearr_73010 = state_73004;
(statearr_73010[(4)] = cljs.core.cons((5),(state_73004[(4)])));

return statearr_73010;
})();
var inst_72981 = fluree.db.util.async.channel_QMARK_(str);
var state_73004__$1 = state_73004;
if(inst_72981){
var statearr_73011_73028 = state_73004__$1;
(statearr_73011_73028[(1)] = (6));

} else {
var statearr_73012_73029 = state_73004__$1;
(statearr_73012_73029[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73005 === (9))){
var inst_72984 = (state_73004[(2)]);
var inst_72985 = fluree.db.util.async.throw_err(inst_72984);
var state_73004__$1 = state_73004;
var statearr_73013_73030 = state_73004__$1;
(statearr_73013_73030[(2)] = inst_72985);

(statearr_73013_73030[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73005 === (5))){
var _ = (function (){var statearr_73014 = state_73004;
(statearr_73014[(4)] = cljs.core.rest((state_73004[(4)])));

return statearr_73014;
})();
var state_73004__$1 = state_73004;
var ex73009 = (state_73004__$1[(2)]);
var statearr_73015_73031 = state_73004__$1;
(statearr_73015_73031[(5)] = ex73009);


if((ex73009 instanceof Error)){
var statearr_73016_73032 = state_73004__$1;
(statearr_73016_73032[(1)] = (4));

(statearr_73016_73032[(5)] = null);

} else {
throw ex73009;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73005 === (8))){
var inst_72988 = (state_73004[(2)]);
var inst_72989 = fluree.db.dbfunctions.internal.lower_case(inst_72988);
var inst_72990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72991 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72993 = [inst_72988];
var inst_72994 = (new cljs.core.PersistentVector(null,1,(5),inst_72992,inst_72993,null));
var inst_72995 = ["lower-case",inst_72994,inst_72989];
var inst_72996 = cljs.core.PersistentHashMap.fromArrays(inst_72991,inst_72995);
var inst_72997 = [inst_72996,(10)];
var inst_72998 = (new cljs.core.PersistentVector(null,2,(5),inst_72990,inst_72997,null));
var inst_72999 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72998);
var _ = (function (){var statearr_73017 = state_73004;
(statearr_73017[(4)] = cljs.core.rest((state_73004[(4)])));

return statearr_73017;
})();
var state_73004__$1 = (function (){var statearr_73018 = state_73004;
(statearr_73018[(7)] = inst_72999);

return statearr_73018;
})();
var statearr_73019_73033 = state_73004__$1;
(statearr_73019_73033[(2)] = inst_72989);

(statearr_73019_73033[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__16153__auto____0 = (function (){
var statearr_73020 = [null,null,null,null,null,null,null,null];
(statearr_73020[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__16153__auto__);

(statearr_73020[(1)] = (1));

return statearr_73020;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__16153__auto____1 = (function (state_73004){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73004);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73021){var ex__16156__auto__ = e73021;
var statearr_73022_73034 = state_73004;
(statearr_73022_73034[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73004[(4)]))){
var statearr_73023_73035 = state_73004;
(statearr_73023_73035[(1)] = cljs.core.first((state_73004[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73036 = state_73004;
state_73004 = G__73036;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__16153__auto__ = function(state_73004){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__16153__auto____1.call(this,state_73004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73024 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73024[(6)] = c__16227__auto__);

return statearr_73024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73066){
var state_val_73067 = (state_73066[(1)]);
if((state_val_73067 === (7))){
var state_73066__$1 = state_73066;
var statearr_73068_73087 = state_73066__$1;
(statearr_73068_73087[(2)] = str);

(statearr_73068_73087[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73067 === (1))){
var state_73066__$1 = state_73066;
var statearr_73069_73088 = state_73066__$1;
(statearr_73069_73088[(2)] = null);

(statearr_73069_73088[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73067 === (4))){
var inst_73037 = (state_73066[(2)]);
var state_73066__$1 = state_73066;
var statearr_73070_73089 = state_73066__$1;
(statearr_73070_73089[(2)] = inst_73037);

(statearr_73070_73089[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73067 === (6))){
var state_73066__$1 = state_73066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73066__$1,(9),str);
} else {
if((state_val_73067 === (3))){
var inst_73064 = (state_73066[(2)]);
var state_73066__$1 = state_73066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73066__$1,inst_73064);
} else {
if((state_val_73067 === (2))){
var _ = (function (){var statearr_73072 = state_73066;
(statearr_73072[(4)] = cljs.core.cons((5),(state_73066[(4)])));

return statearr_73072;
})();
var inst_73043 = fluree.db.util.async.channel_QMARK_(str);
var state_73066__$1 = state_73066;
if(inst_73043){
var statearr_73073_73090 = state_73066__$1;
(statearr_73073_73090[(1)] = (6));

} else {
var statearr_73074_73091 = state_73066__$1;
(statearr_73074_73091[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73067 === (9))){
var inst_73046 = (state_73066[(2)]);
var inst_73047 = fluree.db.util.async.throw_err(inst_73046);
var state_73066__$1 = state_73066;
var statearr_73075_73092 = state_73066__$1;
(statearr_73075_73092[(2)] = inst_73047);

(statearr_73075_73092[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73067 === (5))){
var _ = (function (){var statearr_73076 = state_73066;
(statearr_73076[(4)] = cljs.core.rest((state_73066[(4)])));

return statearr_73076;
})();
var state_73066__$1 = state_73066;
var ex73071 = (state_73066__$1[(2)]);
var statearr_73077_73093 = state_73066__$1;
(statearr_73077_73093[(5)] = ex73071);


if((ex73071 instanceof Error)){
var statearr_73078_73094 = state_73066__$1;
(statearr_73078_73094[(1)] = (4));

(statearr_73078_73094[(5)] = null);

} else {
throw ex73071;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73067 === (8))){
var inst_73050 = (state_73066[(2)]);
var inst_73051 = fluree.db.dbfunctions.internal.upper_case(inst_73050);
var inst_73052 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73053 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73055 = [inst_73050];
var inst_73056 = (new cljs.core.PersistentVector(null,1,(5),inst_73054,inst_73055,null));
var inst_73057 = ["upper-case",inst_73056,inst_73051];
var inst_73058 = cljs.core.PersistentHashMap.fromArrays(inst_73053,inst_73057);
var inst_73059 = [inst_73058,(10)];
var inst_73060 = (new cljs.core.PersistentVector(null,2,(5),inst_73052,inst_73059,null));
var inst_73061 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73060);
var _ = (function (){var statearr_73079 = state_73066;
(statearr_73079[(4)] = cljs.core.rest((state_73066[(4)])));

return statearr_73079;
})();
var state_73066__$1 = (function (){var statearr_73080 = state_73066;
(statearr_73080[(7)] = inst_73061);

return statearr_73080;
})();
var statearr_73081_73095 = state_73066__$1;
(statearr_73081_73095[(2)] = inst_73051);

(statearr_73081_73095[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__16153__auto____0 = (function (){
var statearr_73082 = [null,null,null,null,null,null,null,null];
(statearr_73082[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__16153__auto__);

(statearr_73082[(1)] = (1));

return statearr_73082;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__16153__auto____1 = (function (state_73066){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73066);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73083){var ex__16156__auto__ = e73083;
var statearr_73084_73096 = state_73066;
(statearr_73084_73096[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73066[(4)]))){
var statearr_73085_73097 = state_73066;
(statearr_73085_73097[(1)] = cljs.core.first((state_73066[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73098 = state_73066;
state_73066 = G__73098;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__16153__auto__ = function(state_73066){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__16153__auto____1.call(this,state_73066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73086 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73086[(6)] = c__16227__auto__);

return statearr_73086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4221__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4221__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__73100 = arguments.length;
switch (G__73100) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73128){
var state_val_73129 = (state_73128[(1)]);
if((state_val_73129 === (1))){
var state_73128__$1 = state_73128;
var statearr_73130_73146 = state_73128__$1;
(statearr_73130_73146[(2)] = null);

(statearr_73130_73146[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73129 === (2))){
var _ = (function (){var statearr_73131 = state_73128;
(statearr_73131[(4)] = cljs.core.cons((5),(state_73128[(4)])));

return statearr_73131;
})();
var inst_73110 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_73128__$1 = state_73128;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73128__$1,(6),inst_73110);
} else {
if((state_val_73129 === (3))){
var inst_73126 = (state_73128[(2)]);
var state_73128__$1 = state_73128;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73128__$1,inst_73126);
} else {
if((state_val_73129 === (4))){
var inst_73101 = (state_73128[(2)]);
var state_73128__$1 = state_73128;
var statearr_73133_73147 = state_73128__$1;
(statearr_73133_73147[(2)] = inst_73101);

(statearr_73133_73147[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73129 === (5))){
var _ = (function (){var statearr_73134 = state_73128;
(statearr_73134[(4)] = cljs.core.rest((state_73128[(4)])));

return statearr_73134;
})();
var state_73128__$1 = state_73128;
var ex73132 = (state_73128__$1[(2)]);
var statearr_73135_73148 = state_73128__$1;
(statearr_73135_73148[(5)] = ex73132);


if((ex73132 instanceof Error)){
var statearr_73136_73149 = state_73128__$1;
(statearr_73136_73149[(1)] = (4));

(statearr_73136_73149[(5)] = null);

} else {
throw ex73132;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73129 === (6))){
var inst_73112 = (state_73128[(2)]);
var inst_73113 = fluree.db.util.async.throw_err(inst_73112);
var inst_73114 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73113,(0),null);
var inst_73115 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73113,(1),null);
var inst_73116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73117 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73118 = ["?s","?ctx",inst_73114];
var inst_73119 = cljs.core.PersistentHashMap.fromArrays(inst_73117,inst_73118);
var inst_73120 = ((10) + inst_73115);
var inst_73121 = [inst_73119,inst_73120];
var inst_73122 = (new cljs.core.PersistentVector(null,2,(5),inst_73116,inst_73121,null));
var inst_73123 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73122);
var _ = (function (){var statearr_73137 = state_73128;
(statearr_73137[(4)] = cljs.core.rest((state_73128[(4)])));

return statearr_73137;
})();
var state_73128__$1 = (function (){var statearr_73138 = state_73128;
(statearr_73138[(7)] = inst_73123);

return statearr_73138;
})();
var statearr_73139_73150 = state_73128__$1;
(statearr_73139_73150[(2)] = inst_73114);

(statearr_73139_73150[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_73140 = [null,null,null,null,null,null,null,null];
(statearr_73140[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_73140[(1)] = (1));

return statearr_73140;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_73128){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73128);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73141){var ex__16156__auto__ = e73141;
var statearr_73142_73151 = state_73128;
(statearr_73142_73151[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73128[(4)]))){
var statearr_73143_73152 = state_73128;
(statearr_73143_73152[(1)] = cljs.core.first((state_73128[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73153 = state_73128;
state_73128 = G__73153;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_73128){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_73128);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73144 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73144[(6)] = c__16227__auto__);

return statearr_73144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__73155 = arguments.length;
switch (G__73155) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73193){
var state_val_73194 = (state_73193[(1)]);
if((state_val_73194 === (7))){
var inst_73186 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_73193__$1 = state_73193;
var statearr_73195_73215 = state_73193__$1;
(statearr_73195_73215[(2)] = inst_73186);

(statearr_73195_73215[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73194 === (1))){
var state_73193__$1 = state_73193;
var statearr_73196_73216 = state_73193__$1;
(statearr_73196_73216[(2)] = null);

(statearr_73196_73216[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73194 === (4))){
var inst_73156 = (state_73193[(2)]);
var state_73193__$1 = state_73193;
var statearr_73197_73217 = state_73193__$1;
(statearr_73197_73217[(2)] = inst_73156);

(statearr_73197_73217[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73194 === (6))){
var inst_73167 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_73193__$1 = state_73193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73193__$1,(10),inst_73167);
} else {
if((state_val_73194 === (3))){
var inst_73191 = (state_73193[(2)]);
var state_73193__$1 = state_73193;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73193__$1,inst_73191);
} else {
if((state_val_73194 === (2))){
var _ = (function (){var statearr_73199 = state_73193;
(statearr_73199[(4)] = cljs.core.cons((5),(state_73193[(4)])));

return statearr_73199;
})();
var inst_73162 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73193__$1 = state_73193;
if(cljs.core.truth_(inst_73162)){
var statearr_73200_73218 = state_73193__$1;
(statearr_73200_73218[(1)] = (6));

} else {
var statearr_73201_73219 = state_73193__$1;
(statearr_73201_73219[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73194 === (9))){
var inst_73173 = (state_73193[(2)]);
var inst_73174 = fluree.db.util.async.throw_err(inst_73173);
var inst_73175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73174,(0),null);
var inst_73176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73174,(1),null);
var inst_73177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73178 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73179 = ["?p","?ctx",inst_73175];
var inst_73180 = cljs.core.PersistentHashMap.fromArrays(inst_73178,inst_73179);
var inst_73181 = ((10) + inst_73176);
var inst_73182 = [inst_73180,inst_73181];
var inst_73183 = (new cljs.core.PersistentVector(null,2,(5),inst_73177,inst_73182,null));
var inst_73184 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73183);
var state_73193__$1 = (function (){var statearr_73202 = state_73193;
(statearr_73202[(7)] = inst_73184);

return statearr_73202;
})();
var statearr_73203_73220 = state_73193__$1;
(statearr_73203_73220[(2)] = inst_73175);

(statearr_73203_73220[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73194 === (5))){
var _ = (function (){var statearr_73204 = state_73193;
(statearr_73204[(4)] = cljs.core.rest((state_73193[(4)])));

return statearr_73204;
})();
var state_73193__$1 = state_73193;
var ex73198 = (state_73193__$1[(2)]);
var statearr_73205_73221 = state_73193__$1;
(statearr_73205_73221[(5)] = ex73198);


if((ex73198 instanceof Error)){
var statearr_73206_73222 = state_73193__$1;
(statearr_73206_73222[(1)] = (4));

(statearr_73206_73222[(5)] = null);

} else {
throw ex73198;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73194 === (10))){
var inst_73169 = (state_73193[(2)]);
var inst_73170 = fluree.db.util.async.throw_err(inst_73169);
var inst_73171 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_73170);
var state_73193__$1 = state_73193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73193__$1,(9),inst_73171);
} else {
if((state_val_73194 === (8))){
var inst_73188 = (state_73193[(2)]);
var _ = (function (){var statearr_73207 = state_73193;
(statearr_73207[(4)] = cljs.core.rest((state_73193[(4)])));

return statearr_73207;
})();
var state_73193__$1 = state_73193;
var statearr_73208_73223 = state_73193__$1;
(statearr_73208_73223[(2)] = inst_73188);

(statearr_73208_73223[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_73209 = [null,null,null,null,null,null,null,null];
(statearr_73209[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_73209[(1)] = (1));

return statearr_73209;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_73193){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73193);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73210){var ex__16156__auto__ = e73210;
var statearr_73211_73224 = state_73193;
(statearr_73211_73224[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73193[(4)]))){
var statearr_73212_73225 = state_73193;
(statearr_73212_73225[(1)] = cljs.core.first((state_73193[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73226 = state_73193;
state_73193 = G__73226;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_73193){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_73193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73213 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73213[(6)] = c__16227__auto__);

return statearr_73213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___73275 = arguments.length;
var i__4830__auto___73276 = (0);
while(true){
if((i__4830__auto___73276 < len__4829__auto___73275)){
args__4835__auto__.push((arguments[i__4830__auto___73276]));

var G__73277 = (i__4830__auto___73276 + (1));
i__4830__auto___73276 = G__73277;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73258){
var state_val_73259 = (state_73258[(1)]);
if((state_val_73259 === (1))){
var state_73258__$1 = state_73258;
var statearr_73260_73278 = state_73258__$1;
(statearr_73260_73278[(2)] = null);

(statearr_73260_73278[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73259 === (2))){
var _ = (function (){var statearr_73261 = state_73258;
(statearr_73261[(4)] = cljs.core.cons((5),(state_73258[(4)])));

return statearr_73261;
})();
var inst_73235 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73258__$1 = state_73258;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73258__$1,(6),inst_73235);
} else {
if((state_val_73259 === (3))){
var inst_73256 = (state_73258[(2)]);
var state_73258__$1 = state_73258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73258__$1,inst_73256);
} else {
if((state_val_73259 === (4))){
var inst_73229 = (state_73258[(2)]);
var state_73258__$1 = state_73258;
var statearr_73263_73279 = state_73258__$1;
(statearr_73263_73279[(2)] = inst_73229);

(statearr_73263_73279[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73259 === (5))){
var _ = (function (){var statearr_73264 = state_73258;
(statearr_73264[(4)] = cljs.core.rest((state_73258[(4)])));

return statearr_73264;
})();
var state_73258__$1 = state_73258;
var ex73262 = (state_73258__$1[(2)]);
var statearr_73265_73280 = state_73258__$1;
(statearr_73265_73280[(5)] = ex73262);


if((ex73262 instanceof Error)){
var statearr_73266_73281 = state_73258__$1;
(statearr_73266_73281[(1)] = (4));

(statearr_73266_73281[(5)] = null);

} else {
throw ex73262;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73259 === (6))){
var inst_73237 = (state_73258[(2)]);
var inst_73238 = fluree.db.util.async.throw_err(inst_73237);
var inst_73239 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_73238);
var inst_73240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73241 = [inst_73238];
var inst_73242 = (new cljs.core.PersistentVector(null,1,(5),inst_73240,inst_73241,null));
var inst_73243 = cljs.core.count(inst_73242);
var inst_73244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73245 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73247 = [inst_73238];
var inst_73248 = (new cljs.core.PersistentVector(null,1,(5),inst_73246,inst_73247,null));
var inst_73249 = ["and",inst_73248,inst_73239];
var inst_73250 = cljs.core.PersistentHashMap.fromArrays(inst_73245,inst_73249);
var inst_73251 = [inst_73250,inst_73243];
var inst_73252 = (new cljs.core.PersistentVector(null,2,(5),inst_73244,inst_73251,null));
var inst_73253 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73252);
var _ = (function (){var statearr_73267 = state_73258;
(statearr_73267[(4)] = cljs.core.rest((state_73258[(4)])));

return statearr_73267;
})();
var state_73258__$1 = (function (){var statearr_73268 = state_73258;
(statearr_73268[(7)] = inst_73253);

return statearr_73268;
})();
var statearr_73269_73282 = state_73258__$1;
(statearr_73269_73282[(2)] = inst_73239);

(statearr_73269_73282[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_73270 = [null,null,null,null,null,null,null,null];
(statearr_73270[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_73270[(1)] = (1));

return statearr_73270;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_73258){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73258);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73271){var ex__16156__auto__ = e73271;
var statearr_73272_73283 = state_73258;
(statearr_73272_73283[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73258[(4)]))){
var statearr_73273_73284 = state_73258;
(statearr_73273_73284[(1)] = cljs.core.first((state_73258[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73285 = state_73258;
state_73258 = G__73285;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_73258){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_73258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73274 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73274[(6)] = c__16227__auto__);

return statearr_73274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq73227){
var G__73228 = cljs.core.first(seq73227);
var seq73227__$1 = cljs.core.next(seq73227);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73228,seq73227__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___73334 = arguments.length;
var i__4830__auto___73335 = (0);
while(true){
if((i__4830__auto___73335 < len__4829__auto___73334)){
args__4835__auto__.push((arguments[i__4830__auto___73335]));

var G__73336 = (i__4830__auto___73335 + (1));
i__4830__auto___73335 = G__73336;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73317){
var state_val_73318 = (state_73317[(1)]);
if((state_val_73318 === (1))){
var state_73317__$1 = state_73317;
var statearr_73319_73337 = state_73317__$1;
(statearr_73319_73337[(2)] = null);

(statearr_73319_73337[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73318 === (2))){
var _ = (function (){var statearr_73320 = state_73317;
(statearr_73320[(4)] = cljs.core.cons((5),(state_73317[(4)])));

return statearr_73320;
})();
var inst_73294 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73317__$1 = state_73317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73317__$1,(6),inst_73294);
} else {
if((state_val_73318 === (3))){
var inst_73315 = (state_73317[(2)]);
var state_73317__$1 = state_73317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73317__$1,inst_73315);
} else {
if((state_val_73318 === (4))){
var inst_73288 = (state_73317[(2)]);
var state_73317__$1 = state_73317;
var statearr_73322_73338 = state_73317__$1;
(statearr_73322_73338[(2)] = inst_73288);

(statearr_73322_73338[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73318 === (5))){
var _ = (function (){var statearr_73323 = state_73317;
(statearr_73323[(4)] = cljs.core.rest((state_73317[(4)])));

return statearr_73323;
})();
var state_73317__$1 = state_73317;
var ex73321 = (state_73317__$1[(2)]);
var statearr_73324_73339 = state_73317__$1;
(statearr_73324_73339[(5)] = ex73321);


if((ex73321 instanceof Error)){
var statearr_73325_73340 = state_73317__$1;
(statearr_73325_73340[(1)] = (4));

(statearr_73325_73340[(5)] = null);

} else {
throw ex73321;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73318 === (6))){
var inst_73296 = (state_73317[(2)]);
var inst_73297 = fluree.db.util.async.throw_err(inst_73296);
var inst_73298 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_73297);
var inst_73299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73300 = [inst_73297];
var inst_73301 = (new cljs.core.PersistentVector(null,1,(5),inst_73299,inst_73300,null));
var inst_73302 = cljs.core.count(inst_73301);
var inst_73303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73304 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73306 = [inst_73297];
var inst_73307 = (new cljs.core.PersistentVector(null,1,(5),inst_73305,inst_73306,null));
var inst_73308 = ["or",inst_73307,inst_73298];
var inst_73309 = cljs.core.PersistentHashMap.fromArrays(inst_73304,inst_73308);
var inst_73310 = [inst_73309,inst_73302];
var inst_73311 = (new cljs.core.PersistentVector(null,2,(5),inst_73303,inst_73310,null));
var inst_73312 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73311);
var _ = (function (){var statearr_73326 = state_73317;
(statearr_73326[(4)] = cljs.core.rest((state_73317[(4)])));

return statearr_73326;
})();
var state_73317__$1 = (function (){var statearr_73327 = state_73317;
(statearr_73327[(7)] = inst_73312);

return statearr_73327;
})();
var statearr_73328_73341 = state_73317__$1;
(statearr_73328_73341[(2)] = inst_73298);

(statearr_73328_73341[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_73329 = [null,null,null,null,null,null,null,null];
(statearr_73329[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_73329[(1)] = (1));

return statearr_73329;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_73317){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73317);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73330){var ex__16156__auto__ = e73330;
var statearr_73331_73342 = state_73317;
(statearr_73331_73342[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73317[(4)]))){
var statearr_73332_73343 = state_73317;
(statearr_73332_73343[(1)] = cljs.core.first((state_73317[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73344 = state_73317;
state_73317 = G__73344;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_73317){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_73317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73333 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73333[(6)] = c__16227__auto__);

return statearr_73333;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq73286){
var G__73287 = cljs.core.first(seq73286);
var seq73286__$1 = cljs.core.next(seq73286);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73287,seq73286__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73382){
var state_val_73383 = (state_73382[(1)]);
if((state_val_73383 === (7))){
var inst_73358 = fluree.db.util.async.channel_QMARK_(coll);
var state_73382__$1 = state_73382;
if(inst_73358){
var statearr_73384_73407 = state_73382__$1;
(statearr_73384_73407[(1)] = (10));

} else {
var statearr_73385_73408 = state_73382__$1;
(statearr_73385_73408[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73383 === (1))){
var state_73382__$1 = state_73382;
var statearr_73386_73409 = state_73382__$1;
(statearr_73386_73409[(2)] = null);

(statearr_73386_73409[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73383 === (4))){
var inst_73345 = (state_73382[(2)]);
var state_73382__$1 = state_73382;
var statearr_73387_73410 = state_73382__$1;
(statearr_73387_73410[(2)] = inst_73345);

(statearr_73387_73410[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73383 === (13))){
var inst_73361 = (state_73382[(2)]);
var inst_73362 = fluree.db.util.async.throw_err(inst_73361);
var state_73382__$1 = state_73382;
var statearr_73388_73411 = state_73382__$1;
(statearr_73388_73411[(2)] = inst_73362);

(statearr_73388_73411[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73383 === (6))){
var inst_73353 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_73382__$1 = state_73382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73382__$1,(9),inst_73353);
} else {
if((state_val_73383 === (3))){
var inst_73380 = (state_73382[(2)]);
var state_73382__$1 = state_73382;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73382__$1,inst_73380);
} else {
if((state_val_73383 === (12))){
var inst_73365 = (state_73382[(2)]);
var state_73382__$1 = state_73382;
var statearr_73389_73412 = state_73382__$1;
(statearr_73389_73412[(2)] = inst_73365);

(statearr_73389_73412[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73383 === (2))){
var _ = (function (){var statearr_73390 = state_73382;
(statearr_73390[(4)] = cljs.core.cons((5),(state_73382[(4)])));

return statearr_73390;
})();
var inst_73351 = cljs.core.vector_QMARK_(coll);
var state_73382__$1 = state_73382;
if(inst_73351){
var statearr_73391_73413 = state_73382__$1;
(statearr_73391_73413[(1)] = (6));

} else {
var statearr_73392_73414 = state_73382__$1;
(statearr_73392_73414[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73383 === (11))){
var state_73382__$1 = state_73382;
var statearr_73394_73415 = state_73382__$1;
(statearr_73394_73415[(2)] = coll);

(statearr_73394_73415[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73383 === (9))){
var inst_73355 = (state_73382[(2)]);
var inst_73356 = fluree.db.util.async.throw_err(inst_73355);
var state_73382__$1 = state_73382;
var statearr_73395_73416 = state_73382__$1;
(statearr_73395_73416[(2)] = inst_73356);

(statearr_73395_73416[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73383 === (5))){
var _ = (function (){var statearr_73396 = state_73382;
(statearr_73396[(4)] = cljs.core.rest((state_73382[(4)])));

return statearr_73396;
})();
var state_73382__$1 = state_73382;
var ex73393 = (state_73382__$1[(2)]);
var statearr_73397_73417 = state_73382__$1;
(statearr_73397_73417[(5)] = ex73393);


if((ex73393 instanceof Error)){
var statearr_73398_73418 = state_73382__$1;
(statearr_73398_73418[(1)] = (4));

(statearr_73398_73418[(5)] = null);

} else {
throw ex73393;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73383 === (10))){
var state_73382__$1 = state_73382;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73382__$1,(13),coll);
} else {
if((state_val_73383 === (8))){
var inst_73367 = (state_73382[(2)]);
var inst_73368 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_73367);
var inst_73369 = cljs.core.count(inst_73368);
var inst_73370 = ((9) + inst_73369);
var inst_73371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73372 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73373 = ["count",inst_73367,inst_73369];
var inst_73374 = cljs.core.PersistentHashMap.fromArrays(inst_73372,inst_73373);
var inst_73375 = [inst_73374,inst_73370];
var inst_73376 = (new cljs.core.PersistentVector(null,2,(5),inst_73371,inst_73375,null));
var inst_73377 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73376);
var _ = (function (){var statearr_73399 = state_73382;
(statearr_73399[(4)] = cljs.core.rest((state_73382[(4)])));

return statearr_73399;
})();
var state_73382__$1 = (function (){var statearr_73400 = state_73382;
(statearr_73400[(7)] = inst_73377);

return statearr_73400;
})();
var statearr_73401_73419 = state_73382__$1;
(statearr_73401_73419[(2)] = inst_73369);

(statearr_73401_73419[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__16153__auto____0 = (function (){
var statearr_73402 = [null,null,null,null,null,null,null,null];
(statearr_73402[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__16153__auto__);

(statearr_73402[(1)] = (1));

return statearr_73402;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__16153__auto____1 = (function (state_73382){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73382);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73403){var ex__16156__auto__ = e73403;
var statearr_73404_73420 = state_73382;
(statearr_73404_73420[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73382[(4)]))){
var statearr_73405_73421 = state_73382;
(statearr_73405_73421[(1)] = cljs.core.first((state_73382[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73422 = state_73382;
state_73382 = G__73422;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__16153__auto__ = function(state_73382){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__16153__auto____1.call(this,state_73382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73406 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73406[(6)] = c__16227__auto__);

return statearr_73406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73472){
var state_val_73473 = (state_73472[(1)]);
if((state_val_73473 === (7))){
var state_73472__$1 = state_73472;
var statearr_73474_73507 = state_73472__$1;
(statearr_73474_73507[(2)] = subject);

(statearr_73474_73507[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (1))){
var state_73472__$1 = state_73472;
var statearr_73475_73508 = state_73472__$1;
(statearr_73475_73508[(2)] = null);

(statearr_73475_73508[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (4))){
var inst_73423 = (state_73472[(2)]);
var state_73472__$1 = state_73472;
var statearr_73476_73509 = state_73472__$1;
(statearr_73476_73509[(2)] = inst_73423);

(statearr_73476_73509[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (15))){
var inst_73436 = (state_73472[(7)]);
var state_73472__$1 = state_73472;
var statearr_73477_73510 = state_73472__$1;
(statearr_73477_73510[(2)] = inst_73436);

(statearr_73477_73510[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (13))){
var inst_73440 = (state_73472[(2)]);
var inst_73441 = fluree.db.util.async.throw_err(inst_73440);
var state_73472__$1 = state_73472;
var statearr_73478_73511 = state_73472__$1;
(statearr_73478_73511[(2)] = inst_73441);

(statearr_73478_73511[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (6))){
var state_73472__$1 = state_73472;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73472__$1,(9),subject);
} else {
if((state_val_73473 === (17))){
var inst_73436 = (state_73472[(7)]);
var inst_73450 = cljs.core.first(inst_73436);
var state_73472__$1 = state_73472;
var statearr_73479_73512 = state_73472__$1;
(statearr_73479_73512[(2)] = inst_73450);

(statearr_73479_73512[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (3))){
var inst_73470 = (state_73472[(2)]);
var state_73472__$1 = state_73472;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73472__$1,inst_73470);
} else {
if((state_val_73473 === (12))){
var inst_73436 = (state_73472[(7)]);
var inst_73444 = (state_73472[(2)]);
var inst_73445 = cljs.core.vector_QMARK_(inst_73436);
var state_73472__$1 = (function (){var statearr_73480 = state_73472;
(statearr_73480[(8)] = inst_73444);

return statearr_73480;
})();
if(inst_73445){
var statearr_73481_73513 = state_73472__$1;
(statearr_73481_73513[(1)] = (14));

} else {
var statearr_73482_73514 = state_73472__$1;
(statearr_73482_73514[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (2))){
var _ = (function (){var statearr_73483 = state_73472;
(statearr_73483[(4)] = cljs.core.cons((5),(state_73472[(4)])));

return statearr_73483;
})();
var inst_73429 = fluree.db.util.async.channel_QMARK_(subject);
var state_73472__$1 = state_73472;
if(inst_73429){
var statearr_73484_73515 = state_73472__$1;
(statearr_73484_73515[(1)] = (6));

} else {
var statearr_73485_73516 = state_73472__$1;
(statearr_73485_73516[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (19))){
var inst_73453 = (state_73472[(2)]);
var state_73472__$1 = state_73472;
var statearr_73486_73517 = state_73472__$1;
(statearr_73486_73517[(2)] = inst_73453);

(statearr_73486_73517[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (11))){
var state_73472__$1 = state_73472;
var statearr_73488_73518 = state_73472__$1;
(statearr_73488_73518[(2)] = pred);

(statearr_73488_73518[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (9))){
var inst_73432 = (state_73472[(2)]);
var inst_73433 = fluree.db.util.async.throw_err(inst_73432);
var state_73472__$1 = state_73472;
var statearr_73489_73519 = state_73472__$1;
(statearr_73489_73519[(2)] = inst_73433);

(statearr_73489_73519[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (5))){
var _ = (function (){var statearr_73490 = state_73472;
(statearr_73490[(4)] = cljs.core.rest((state_73472[(4)])));

return statearr_73490;
})();
var state_73472__$1 = state_73472;
var ex73487 = (state_73472__$1[(2)]);
var statearr_73491_73520 = state_73472__$1;
(statearr_73491_73520[(5)] = ex73487);


if((ex73487 instanceof Error)){
var statearr_73492_73521 = state_73472__$1;
(statearr_73492_73521[(1)] = (4));

(statearr_73492_73521[(5)] = null);

} else {
throw ex73487;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (14))){
var inst_73436 = (state_73472[(7)]);
var inst_73447 = cljs.core.count(inst_73436);
var inst_73448 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_73447);
var state_73472__$1 = state_73472;
if(inst_73448){
var statearr_73493_73522 = state_73472__$1;
(statearr_73493_73522[(1)] = (17));

} else {
var statearr_73494_73523 = state_73472__$1;
(statearr_73494_73523[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (16))){
var inst_73436 = (state_73472[(7)]);
var inst_73444 = (state_73472[(8)]);
var inst_73456 = (state_73472[(2)]);
var inst_73457 = fluree.db.dbfunctions.internal.get(inst_73456,inst_73444);
var inst_73458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73459 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73461 = [inst_73436,inst_73444];
var inst_73462 = (new cljs.core.PersistentVector(null,2,(5),inst_73460,inst_73461,null));
var inst_73463 = ["get",inst_73462,inst_73457];
var inst_73464 = cljs.core.PersistentHashMap.fromArrays(inst_73459,inst_73463);
var inst_73465 = [inst_73464,(10)];
var inst_73466 = (new cljs.core.PersistentVector(null,2,(5),inst_73458,inst_73465,null));
var inst_73467 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73466);
var _ = (function (){var statearr_73495 = state_73472;
(statearr_73495[(4)] = cljs.core.rest((state_73472[(4)])));

return statearr_73495;
})();
var state_73472__$1 = (function (){var statearr_73496 = state_73472;
(statearr_73496[(9)] = inst_73467);

return statearr_73496;
})();
var statearr_73497_73524 = state_73472__$1;
(statearr_73497_73524[(2)] = inst_73457);

(statearr_73497_73524[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (10))){
var state_73472__$1 = state_73472;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73472__$1,(13),pred);
} else {
if((state_val_73473 === (18))){
var inst_73436 = (state_73472[(7)]);
var state_73472__$1 = state_73472;
var statearr_73498_73525 = state_73472__$1;
(statearr_73498_73525[(2)] = inst_73436);

(statearr_73498_73525[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73473 === (8))){
var inst_73436 = (state_73472[(2)]);
var inst_73437 = fluree.db.util.async.channel_QMARK_(pred);
var state_73472__$1 = (function (){var statearr_73499 = state_73472;
(statearr_73499[(7)] = inst_73436);

return statearr_73499;
})();
if(inst_73437){
var statearr_73500_73526 = state_73472__$1;
(statearr_73500_73526[(1)] = (10));

} else {
var statearr_73501_73527 = state_73472__$1;
(statearr_73501_73527[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__16153__auto____0 = (function (){
var statearr_73502 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73502[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__16153__auto__);

(statearr_73502[(1)] = (1));

return statearr_73502;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__16153__auto____1 = (function (state_73472){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73472);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73503){var ex__16156__auto__ = e73503;
var statearr_73504_73528 = state_73472;
(statearr_73504_73528[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73472[(4)]))){
var statearr_73505_73529 = state_73472;
(statearr_73505_73529[(1)] = cljs.core.first((state_73472[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73530 = state_73472;
state_73472 = G__73530;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__16153__auto__ = function(state_73472){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__16153__auto____1.call(this,state_73472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73506 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73506[(6)] = c__16227__auto__);

return statearr_73506;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73569){
var state_val_73570 = (state_73569[(1)]);
if((state_val_73570 === (7))){
var inst_73537 = (state_73569[(7)]);
var state_73569__$1 = state_73569;
var statearr_73571_73595 = state_73569__$1;
(statearr_73571_73595[(2)] = inst_73537);

(statearr_73571_73595[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73570 === (1))){
var state_73569__$1 = state_73569;
var statearr_73572_73596 = state_73569__$1;
(statearr_73572_73596[(2)] = null);

(statearr_73572_73596[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73570 === (4))){
var inst_73531 = (state_73569[(2)]);
var state_73569__$1 = state_73569;
var statearr_73573_73597 = state_73569__$1;
(statearr_73573_73597[(2)] = inst_73531);

(statearr_73573_73597[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73570 === (6))){
var inst_73539 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73569__$1 = state_73569;
var statearr_73574_73598 = state_73569__$1;
(statearr_73574_73598[(2)] = inst_73539);

(statearr_73574_73598[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73570 === (3))){
var inst_73567 = (state_73569[(2)]);
var state_73569__$1 = state_73569;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73569__$1,inst_73567);
} else {
if((state_val_73570 === (12))){
var inst_73549 = (state_73569[(2)]);
var inst_73550 = fluree.db.util.async.throw_err(inst_73549);
var inst_73551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73550,(0),null);
var inst_73552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73550,(1),null);
var inst_73553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73554 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73555 = ["?pO","?ctx",inst_73551];
var inst_73556 = cljs.core.PersistentHashMap.fromArrays(inst_73554,inst_73555);
var inst_73557 = ((10) + inst_73552);
var inst_73558 = [inst_73556,inst_73557];
var inst_73559 = (new cljs.core.PersistentVector(null,2,(5),inst_73553,inst_73558,null));
var inst_73560 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73559);
var state_73569__$1 = (function (){var statearr_73575 = state_73569;
(statearr_73575[(8)] = inst_73560);

return statearr_73575;
})();
var statearr_73576_73599 = state_73569__$1;
(statearr_73576_73599[(2)] = inst_73551);

(statearr_73576_73599[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73570 === (2))){
var inst_73537 = (state_73569[(7)]);
var _ = (function (){var statearr_73577 = state_73569;
(statearr_73577[(4)] = cljs.core.cons((5),(state_73569[(4)])));

return statearr_73577;
})();
var inst_73537__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_73569__$1 = (function (){var statearr_73578 = state_73569;
(statearr_73578[(7)] = inst_73537__$1);

return statearr_73578;
})();
if(cljs.core.truth_(inst_73537__$1)){
var statearr_73579_73600 = state_73569__$1;
(statearr_73579_73600[(1)] = (6));

} else {
var statearr_73580_73601 = state_73569__$1;
(statearr_73580_73601[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73570 === (11))){
var inst_73564 = (state_73569[(2)]);
var _ = (function (){var statearr_73582 = state_73569;
(statearr_73582[(4)] = cljs.core.rest((state_73569[(4)])));

return statearr_73582;
})();
var state_73569__$1 = state_73569;
var statearr_73583_73602 = state_73569__$1;
(statearr_73583_73602[(2)] = inst_73564);

(statearr_73583_73602[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73570 === (9))){
var inst_73547 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_73569__$1 = state_73569;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73569__$1,(12),inst_73547);
} else {
if((state_val_73570 === (5))){
var _ = (function (){var statearr_73584 = state_73569;
(statearr_73584[(4)] = cljs.core.rest((state_73569[(4)])));

return statearr_73584;
})();
var state_73569__$1 = state_73569;
var ex73581 = (state_73569__$1[(2)]);
var statearr_73585_73603 = state_73569__$1;
(statearr_73585_73603[(5)] = ex73581);


if((ex73581 instanceof Error)){
var statearr_73586_73604 = state_73569__$1;
(statearr_73586_73604[(1)] = (4));

(statearr_73586_73604[(5)] = null);

} else {
throw ex73581;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73570 === (10))){
var inst_73562 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_73569__$1 = state_73569;
var statearr_73587_73605 = state_73569__$1;
(statearr_73587_73605[(2)] = inst_73562);

(statearr_73587_73605[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73570 === (8))){
var inst_73542 = (state_73569[(2)]);
var state_73569__$1 = state_73569;
if(cljs.core.truth_(inst_73542)){
var statearr_73588_73606 = state_73569__$1;
(statearr_73588_73606[(1)] = (9));

} else {
var statearr_73589_73607 = state_73569__$1;
(statearr_73589_73607[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16153__auto____0 = (function (){
var statearr_73590 = [null,null,null,null,null,null,null,null,null];
(statearr_73590[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16153__auto__);

(statearr_73590[(1)] = (1));

return statearr_73590;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16153__auto____1 = (function (state_73569){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73569);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73591){var ex__16156__auto__ = e73591;
var statearr_73592_73608 = state_73569;
(statearr_73592_73608[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73569[(4)]))){
var statearr_73593_73609 = state_73569;
(statearr_73593_73609[(1)] = cljs.core.first((state_73569[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73610 = state_73569;
state_73569 = G__73610;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16153__auto__ = function(state_73569){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16153__auto____1.call(this,state_73569);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73594 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73594[(6)] = c__16227__auto__);

return statearr_73594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73662){
var state_val_73663 = (state_73662[(1)]);
if((state_val_73663 === (7))){
var state_73662__$1 = state_73662;
var statearr_73664_73697 = state_73662__$1;
(statearr_73664_73697[(2)] = subject);

(statearr_73664_73697[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (1))){
var state_73662__$1 = state_73662;
var statearr_73665_73698 = state_73662__$1;
(statearr_73665_73698[(2)] = null);

(statearr_73665_73698[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (4))){
var inst_73611 = (state_73662[(2)]);
var state_73662__$1 = state_73662;
var statearr_73666_73699 = state_73662__$1;
(statearr_73666_73699[(2)] = inst_73611);

(statearr_73666_73699[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (15))){
var inst_73624 = (state_73662[(7)]);
var state_73662__$1 = state_73662;
var statearr_73667_73700 = state_73662__$1;
(statearr_73667_73700[(2)] = inst_73624);

(statearr_73667_73700[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (13))){
var inst_73628 = (state_73662[(2)]);
var inst_73629 = fluree.db.util.async.throw_err(inst_73628);
var state_73662__$1 = state_73662;
var statearr_73668_73701 = state_73662__$1;
(statearr_73668_73701[(2)] = inst_73629);

(statearr_73668_73701[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (6))){
var state_73662__$1 = state_73662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73662__$1,(9),subject);
} else {
if((state_val_73663 === (17))){
var inst_73624 = (state_73662[(7)]);
var inst_73638 = cljs.core.first(inst_73624);
var state_73662__$1 = state_73662;
var statearr_73669_73702 = state_73662__$1;
(statearr_73669_73702[(2)] = inst_73638);

(statearr_73669_73702[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (3))){
var inst_73660 = (state_73662[(2)]);
var state_73662__$1 = state_73662;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73662__$1,inst_73660);
} else {
if((state_val_73663 === (12))){
var inst_73624 = (state_73662[(7)]);
var inst_73632 = (state_73662[(2)]);
var inst_73633 = cljs.core.vector_QMARK_(inst_73624);
var state_73662__$1 = (function (){var statearr_73670 = state_73662;
(statearr_73670[(8)] = inst_73632);

return statearr_73670;
})();
if(inst_73633){
var statearr_73671_73703 = state_73662__$1;
(statearr_73671_73703[(1)] = (14));

} else {
var statearr_73672_73704 = state_73662__$1;
(statearr_73672_73704[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (2))){
var _ = (function (){var statearr_73673 = state_73662;
(statearr_73673[(4)] = cljs.core.cons((5),(state_73662[(4)])));

return statearr_73673;
})();
var inst_73617 = fluree.db.util.async.channel_QMARK_(subject);
var state_73662__$1 = state_73662;
if(inst_73617){
var statearr_73674_73705 = state_73662__$1;
(statearr_73674_73705[(1)] = (6));

} else {
var statearr_73675_73706 = state_73662__$1;
(statearr_73675_73706[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (19))){
var inst_73641 = (state_73662[(2)]);
var state_73662__$1 = state_73662;
var statearr_73676_73707 = state_73662__$1;
(statearr_73676_73707[(2)] = inst_73641);

(statearr_73676_73707[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (11))){
var state_73662__$1 = state_73662;
var statearr_73678_73708 = state_73662__$1;
(statearr_73678_73708[(2)] = path);

(statearr_73678_73708[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (9))){
var inst_73620 = (state_73662[(2)]);
var inst_73621 = fluree.db.util.async.throw_err(inst_73620);
var state_73662__$1 = state_73662;
var statearr_73679_73709 = state_73662__$1;
(statearr_73679_73709[(2)] = inst_73621);

(statearr_73679_73709[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (5))){
var _ = (function (){var statearr_73680 = state_73662;
(statearr_73680[(4)] = cljs.core.rest((state_73662[(4)])));

return statearr_73680;
})();
var state_73662__$1 = state_73662;
var ex73677 = (state_73662__$1[(2)]);
var statearr_73681_73710 = state_73662__$1;
(statearr_73681_73710[(5)] = ex73677);


if((ex73677 instanceof Error)){
var statearr_73682_73711 = state_73662__$1;
(statearr_73682_73711[(1)] = (4));

(statearr_73682_73711[(5)] = null);

} else {
throw ex73677;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (14))){
var inst_73624 = (state_73662[(7)]);
var inst_73635 = cljs.core.count(inst_73624);
var inst_73636 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_73635);
var state_73662__$1 = state_73662;
if(inst_73636){
var statearr_73683_73712 = state_73662__$1;
(statearr_73683_73712[(1)] = (17));

} else {
var statearr_73684_73713 = state_73662__$1;
(statearr_73684_73713[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (16))){
var inst_73624 = (state_73662[(7)]);
var inst_73632 = (state_73662[(8)]);
var inst_73644 = (state_73662[(2)]);
var inst_73645 = fluree.db.dbfunctions.internal.get_all(inst_73644,inst_73632);
var inst_73646 = cljs.core.count(inst_73632);
var inst_73647 = ((9) + inst_73646);
var inst_73648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73649 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73651 = [inst_73624,inst_73632];
var inst_73652 = (new cljs.core.PersistentVector(null,2,(5),inst_73650,inst_73651,null));
var inst_73653 = ["get-all",inst_73652,inst_73645];
var inst_73654 = cljs.core.PersistentHashMap.fromArrays(inst_73649,inst_73653);
var inst_73655 = [inst_73654,inst_73647];
var inst_73656 = (new cljs.core.PersistentVector(null,2,(5),inst_73648,inst_73655,null));
var inst_73657 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73656);
var _ = (function (){var statearr_73685 = state_73662;
(statearr_73685[(4)] = cljs.core.rest((state_73662[(4)])));

return statearr_73685;
})();
var state_73662__$1 = (function (){var statearr_73686 = state_73662;
(statearr_73686[(9)] = inst_73657);

return statearr_73686;
})();
var statearr_73687_73714 = state_73662__$1;
(statearr_73687_73714[(2)] = inst_73645);

(statearr_73687_73714[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (10))){
var state_73662__$1 = state_73662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73662__$1,(13),path);
} else {
if((state_val_73663 === (18))){
var inst_73624 = (state_73662[(7)]);
var state_73662__$1 = state_73662;
var statearr_73688_73715 = state_73662__$1;
(statearr_73688_73715[(2)] = inst_73624);

(statearr_73688_73715[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73663 === (8))){
var inst_73624 = (state_73662[(2)]);
var inst_73625 = fluree.db.util.async.channel_QMARK_(path);
var state_73662__$1 = (function (){var statearr_73689 = state_73662;
(statearr_73689[(7)] = inst_73624);

return statearr_73689;
})();
if(inst_73625){
var statearr_73690_73716 = state_73662__$1;
(statearr_73690_73716[(1)] = (10));

} else {
var statearr_73691_73717 = state_73662__$1;
(statearr_73691_73717[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__16153__auto____0 = (function (){
var statearr_73692 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73692[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__16153__auto__);

(statearr_73692[(1)] = (1));

return statearr_73692;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__16153__auto____1 = (function (state_73662){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73662);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73693){var ex__16156__auto__ = e73693;
var statearr_73694_73718 = state_73662;
(statearr_73694_73718[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73662[(4)]))){
var statearr_73695_73719 = state_73662;
(statearr_73695_73719[(1)] = cljs.core.first((state_73662[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73720 = state_73662;
state_73662 = G__73720;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__16153__auto__ = function(state_73662){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__16153__auto____1.call(this,state_73662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73696 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73696[(6)] = c__16227__auto__);

return statearr_73696;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73759){
var state_val_73760 = (state_73759[(1)]);
if((state_val_73760 === (7))){
var state_73759__$1 = state_73759;
var statearr_73761_73785 = state_73759__$1;
(statearr_73761_73785[(2)] = subject);

(statearr_73761_73785[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73760 === (1))){
var state_73759__$1 = state_73759;
var statearr_73762_73786 = state_73759__$1;
(statearr_73762_73786[(2)] = null);

(statearr_73762_73786[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73760 === (4))){
var inst_73721 = (state_73759[(2)]);
var state_73759__$1 = state_73759;
var statearr_73763_73787 = state_73759__$1;
(statearr_73763_73787[(2)] = inst_73721);

(statearr_73763_73787[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73760 === (13))){
var inst_73738 = (state_73759[(2)]);
var inst_73739 = fluree.db.util.async.throw_err(inst_73738);
var state_73759__$1 = state_73759;
var statearr_73764_73788 = state_73759__$1;
(statearr_73764_73788[(2)] = inst_73739);

(statearr_73764_73788[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73760 === (6))){
var state_73759__$1 = state_73759;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73759__$1,(9),subject);
} else {
if((state_val_73760 === (3))){
var inst_73757 = (state_73759[(2)]);
var state_73759__$1 = state_73759;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73759__$1,inst_73757);
} else {
if((state_val_73760 === (12))){
var inst_73734 = (state_73759[(7)]);
var inst_73742 = (state_73759[(2)]);
var inst_73743 = fluree.db.dbfunctions.internal.get_in(inst_73734,inst_73742);
var inst_73744 = cljs.core.count(inst_73742);
var inst_73745 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73746 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73748 = [inst_73734,inst_73742];
var inst_73749 = (new cljs.core.PersistentVector(null,2,(5),inst_73747,inst_73748,null));
var inst_73750 = ["get-in",inst_73749,inst_73743];
var inst_73751 = cljs.core.PersistentHashMap.fromArrays(inst_73746,inst_73750);
var inst_73752 = [inst_73751,inst_73744];
var inst_73753 = (new cljs.core.PersistentVector(null,2,(5),inst_73745,inst_73752,null));
var inst_73754 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73753);
var _ = (function (){var statearr_73765 = state_73759;
(statearr_73765[(4)] = cljs.core.rest((state_73759[(4)])));

return statearr_73765;
})();
var state_73759__$1 = (function (){var statearr_73766 = state_73759;
(statearr_73766[(8)] = inst_73754);

return statearr_73766;
})();
var statearr_73767_73789 = state_73759__$1;
(statearr_73767_73789[(2)] = inst_73743);

(statearr_73767_73789[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73760 === (2))){
var _ = (function (){var statearr_73768 = state_73759;
(statearr_73768[(4)] = cljs.core.cons((5),(state_73759[(4)])));

return statearr_73768;
})();
var inst_73727 = fluree.db.util.async.channel_QMARK_(subject);
var state_73759__$1 = state_73759;
if(inst_73727){
var statearr_73769_73790 = state_73759__$1;
(statearr_73769_73790[(1)] = (6));

} else {
var statearr_73770_73791 = state_73759__$1;
(statearr_73770_73791[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73760 === (11))){
var state_73759__$1 = state_73759;
var statearr_73772_73792 = state_73759__$1;
(statearr_73772_73792[(2)] = path);

(statearr_73772_73792[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73760 === (9))){
var inst_73730 = (state_73759[(2)]);
var inst_73731 = fluree.db.util.async.throw_err(inst_73730);
var state_73759__$1 = state_73759;
var statearr_73773_73793 = state_73759__$1;
(statearr_73773_73793[(2)] = inst_73731);

(statearr_73773_73793[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73760 === (5))){
var _ = (function (){var statearr_73774 = state_73759;
(statearr_73774[(4)] = cljs.core.rest((state_73759[(4)])));

return statearr_73774;
})();
var state_73759__$1 = state_73759;
var ex73771 = (state_73759__$1[(2)]);
var statearr_73775_73794 = state_73759__$1;
(statearr_73775_73794[(5)] = ex73771);


if((ex73771 instanceof Error)){
var statearr_73776_73795 = state_73759__$1;
(statearr_73776_73795[(1)] = (4));

(statearr_73776_73795[(5)] = null);

} else {
throw ex73771;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73760 === (10))){
var state_73759__$1 = state_73759;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73759__$1,(13),path);
} else {
if((state_val_73760 === (8))){
var inst_73734 = (state_73759[(2)]);
var inst_73735 = fluree.db.util.async.channel_QMARK_(path);
var state_73759__$1 = (function (){var statearr_73777 = state_73759;
(statearr_73777[(7)] = inst_73734);

return statearr_73777;
})();
if(inst_73735){
var statearr_73778_73796 = state_73759__$1;
(statearr_73778_73796[(1)] = (10));

} else {
var statearr_73779_73797 = state_73759__$1;
(statearr_73779_73797[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__16153__auto____0 = (function (){
var statearr_73780 = [null,null,null,null,null,null,null,null,null];
(statearr_73780[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__16153__auto__);

(statearr_73780[(1)] = (1));

return statearr_73780;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__16153__auto____1 = (function (state_73759){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73759);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73781){var ex__16156__auto__ = e73781;
var statearr_73782_73798 = state_73759;
(statearr_73782_73798[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73759[(4)]))){
var statearr_73783_73799 = state_73759;
(statearr_73783_73799[(1)] = cljs.core.first((state_73759[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73800 = state_73759;
state_73759 = G__73800;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__16153__auto__ = function(state_73759){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__16153__auto____1.call(this,state_73759);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73784 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73784[(6)] = c__16227__auto__);

return statearr_73784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73845){
var state_val_73846 = (state_73845[(1)]);
if((state_val_73846 === (7))){
var state_73845__$1 = state_73845;
var statearr_73847_73876 = state_73845__$1;
(statearr_73847_73876[(2)] = coll);

(statearr_73847_73876[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73846 === (1))){
var state_73845__$1 = state_73845;
var statearr_73848_73877 = state_73845__$1;
(statearr_73848_73877[(2)] = null);

(statearr_73848_73877[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73846 === (4))){
var inst_73801 = (state_73845[(2)]);
var state_73845__$1 = state_73845;
var statearr_73849_73878 = state_73845__$1;
(statearr_73849_73878[(2)] = inst_73801);

(statearr_73849_73878[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73846 === (15))){
var inst_73821 = (state_73845[(7)]);
var inst_73829 = (state_73845[(2)]);
var inst_73830 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_73821,inst_73829);
var inst_73831 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73832 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73833 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73834 = [inst_73821,inst_73829];
var inst_73835 = (new cljs.core.PersistentVector(null,2,(5),inst_73833,inst_73834,null));
var inst_73836 = ["contains?",inst_73835,inst_73830];
var inst_73837 = cljs.core.PersistentHashMap.fromArrays(inst_73832,inst_73836);
var inst_73838 = [inst_73837,(10)];
var inst_73839 = (new cljs.core.PersistentVector(null,2,(5),inst_73831,inst_73838,null));
var inst_73840 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73839);
var _ = (function (){var statearr_73850 = state_73845;
(statearr_73850[(4)] = cljs.core.rest((state_73845[(4)])));

return statearr_73850;
})();
var state_73845__$1 = (function (){var statearr_73851 = state_73845;
(statearr_73851[(8)] = inst_73840);

return statearr_73851;
})();
var statearr_73852_73879 = state_73845__$1;
(statearr_73852_73879[(2)] = inst_73830);

(statearr_73852_73879[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73846 === (13))){
var state_73845__$1 = state_73845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73845__$1,(16),key);
} else {
if((state_val_73846 === (6))){
var state_73845__$1 = state_73845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73845__$1,(9),coll);
} else {
if((state_val_73846 === (3))){
var inst_73843 = (state_73845[(2)]);
var state_73845__$1 = state_73845;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73845__$1,inst_73843);
} else {
if((state_val_73846 === (12))){
var inst_73821 = (state_73845[(2)]);
var inst_73822 = fluree.db.util.async.channel_QMARK_(key);
var state_73845__$1 = (function (){var statearr_73853 = state_73845;
(statearr_73853[(7)] = inst_73821);

return statearr_73853;
})();
if(inst_73822){
var statearr_73854_73880 = state_73845__$1;
(statearr_73854_73880[(1)] = (13));

} else {
var statearr_73855_73881 = state_73845__$1;
(statearr_73855_73881[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73846 === (2))){
var _ = (function (){var statearr_73856 = state_73845;
(statearr_73856[(4)] = cljs.core.cons((5),(state_73845[(4)])));

return statearr_73856;
})();
var inst_73807 = fluree.db.util.async.channel_QMARK_(coll);
var state_73845__$1 = state_73845;
if(inst_73807){
var statearr_73857_73882 = state_73845__$1;
(statearr_73857_73882[(1)] = (6));

} else {
var statearr_73858_73883 = state_73845__$1;
(statearr_73858_73883[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73846 === (11))){
var inst_73814 = (state_73845[(9)]);
var inst_73818 = cljs.core.flatten(inst_73814);
var inst_73819 = cljs.core.set(inst_73818);
var state_73845__$1 = state_73845;
var statearr_73860_73884 = state_73845__$1;
(statearr_73860_73884[(2)] = inst_73819);

(statearr_73860_73884[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73846 === (9))){
var inst_73810 = (state_73845[(2)]);
var inst_73811 = fluree.db.util.async.throw_err(inst_73810);
var state_73845__$1 = state_73845;
var statearr_73861_73885 = state_73845__$1;
(statearr_73861_73885[(2)] = inst_73811);

(statearr_73861_73885[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73846 === (5))){
var _ = (function (){var statearr_73862 = state_73845;
(statearr_73862[(4)] = cljs.core.rest((state_73845[(4)])));

return statearr_73862;
})();
var state_73845__$1 = state_73845;
var ex73859 = (state_73845__$1[(2)]);
var statearr_73863_73886 = state_73845__$1;
(statearr_73863_73886[(5)] = ex73859);


if((ex73859 instanceof Error)){
var statearr_73864_73887 = state_73845__$1;
(statearr_73864_73887[(1)] = (4));

(statearr_73864_73887[(5)] = null);

} else {
throw ex73859;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73846 === (14))){
var state_73845__$1 = state_73845;
var statearr_73865_73888 = state_73845__$1;
(statearr_73865_73888[(2)] = key);

(statearr_73865_73888[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73846 === (16))){
var inst_73825 = (state_73845[(2)]);
var inst_73826 = fluree.db.util.async.throw_err(inst_73825);
var state_73845__$1 = state_73845;
var statearr_73866_73889 = state_73845__$1;
(statearr_73866_73889[(2)] = inst_73826);

(statearr_73866_73889[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73846 === (10))){
var inst_73814 = (state_73845[(9)]);
var state_73845__$1 = state_73845;
var statearr_73867_73890 = state_73845__$1;
(statearr_73867_73890[(2)] = inst_73814);

(statearr_73867_73890[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73846 === (8))){
var inst_73814 = (state_73845[(9)]);
var inst_73814__$1 = (state_73845[(2)]);
var inst_73815 = cljs.core.set_QMARK_(inst_73814__$1);
var state_73845__$1 = (function (){var statearr_73868 = state_73845;
(statearr_73868[(9)] = inst_73814__$1);

return statearr_73868;
})();
if(inst_73815){
var statearr_73869_73891 = state_73845__$1;
(statearr_73869_73891[(1)] = (10));

} else {
var statearr_73870_73892 = state_73845__$1;
(statearr_73870_73892[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16153__auto____0 = (function (){
var statearr_73871 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73871[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16153__auto__);

(statearr_73871[(1)] = (1));

return statearr_73871;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16153__auto____1 = (function (state_73845){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73845);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73872){var ex__16156__auto__ = e73872;
var statearr_73873_73893 = state_73845;
(statearr_73873_73893[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73845[(4)]))){
var statearr_73874_73894 = state_73845;
(statearr_73874_73894[(1)] = cljs.core.first((state_73845[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73895 = state_73845;
state_73845 = G__73895;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16153__auto__ = function(state_73845){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16153__auto____1.call(this,state_73845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73875 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73875[(6)] = c__16227__auto__);

return statearr_73875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___73967 = arguments.length;
var i__4830__auto___73968 = (0);
while(true){
if((i__4830__auto___73968 < len__4829__auto___73967)){
args__4835__auto__.push((arguments[i__4830__auto___73968]));

var G__73969 = (i__4830__auto___73968 + (1));
i__4830__auto___73968 = G__73969;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_73941){
var state_val_73942 = (state_73941[(1)]);
if((state_val_73942 === (7))){
var inst_73907 = (state_73941[(7)]);
var inst_73911 = cljs.core.first(inst_73907);
var inst_73912 = cljs.core.coll_QMARK_(inst_73911);
var state_73941__$1 = state_73941;
var statearr_73943_73970 = state_73941__$1;
(statearr_73943_73970[(2)] = inst_73912);

(statearr_73943_73970[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73942 === (1))){
var state_73941__$1 = state_73941;
var statearr_73944_73971 = state_73941__$1;
(statearr_73944_73971[(2)] = null);

(statearr_73944_73971[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73942 === (4))){
var inst_73898 = (state_73941[(2)]);
var state_73941__$1 = state_73941;
var statearr_73945_73972 = state_73941__$1;
(statearr_73945_73972[(2)] = inst_73898);

(statearr_73945_73972[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73942 === (6))){
var inst_73907 = (state_73941[(7)]);
var inst_73909 = (state_73941[(8)]);
var inst_73906 = (state_73941[(2)]);
var inst_73907__$1 = fluree.db.util.async.throw_err(inst_73906);
var inst_73908 = cljs.core.count(inst_73907__$1);
var inst_73909__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_73908);
var state_73941__$1 = (function (){var statearr_73946 = state_73941;
(statearr_73946[(7)] = inst_73907__$1);

(statearr_73946[(8)] = inst_73909__$1);

return statearr_73946;
})();
if(inst_73909__$1){
var statearr_73947_73973 = state_73941__$1;
(statearr_73947_73973[(1)] = (7));

} else {
var statearr_73948_73974 = state_73941__$1;
(statearr_73948_73974[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73942 === (3))){
var inst_73939 = (state_73941[(2)]);
var state_73941__$1 = state_73941;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73941__$1,inst_73939);
} else {
if((state_val_73942 === (12))){
var inst_73920 = (state_73941[(2)]);
var inst_73921 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_73920);
var inst_73922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73923 = [inst_73920];
var inst_73924 = (new cljs.core.PersistentVector(null,1,(5),inst_73922,inst_73923,null));
var inst_73925 = cljs.core.count(inst_73924);
var inst_73926 = ((9) + inst_73925);
var inst_73927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73928 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_73929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73930 = [inst_73920];
var inst_73931 = (new cljs.core.PersistentVector(null,1,(5),inst_73929,inst_73930,null));
var inst_73932 = ["hash-set",inst_73931,inst_73921];
var inst_73933 = cljs.core.PersistentHashMap.fromArrays(inst_73928,inst_73932);
var inst_73934 = [inst_73933,inst_73926];
var inst_73935 = (new cljs.core.PersistentVector(null,2,(5),inst_73927,inst_73934,null));
var inst_73936 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_73935);
var _ = (function (){var statearr_73949 = state_73941;
(statearr_73949[(4)] = cljs.core.rest((state_73941[(4)])));

return statearr_73949;
})();
var state_73941__$1 = (function (){var statearr_73950 = state_73941;
(statearr_73950[(9)] = inst_73936);

return statearr_73950;
})();
var statearr_73951_73975 = state_73941__$1;
(statearr_73951_73975[(2)] = inst_73921);

(statearr_73951_73975[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73942 === (2))){
var _ = (function (){var statearr_73952 = state_73941;
(statearr_73952[(4)] = cljs.core.cons((5),(state_73941[(4)])));

return statearr_73952;
})();
var inst_73904 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_73941__$1 = state_73941;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73941__$1,(6),inst_73904);
} else {
if((state_val_73942 === (11))){
var inst_73907 = (state_73941[(7)]);
var state_73941__$1 = state_73941;
var statearr_73954_73976 = state_73941__$1;
(statearr_73954_73976[(2)] = inst_73907);

(statearr_73954_73976[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73942 === (9))){
var inst_73915 = (state_73941[(2)]);
var state_73941__$1 = state_73941;
if(cljs.core.truth_(inst_73915)){
var statearr_73955_73977 = state_73941__$1;
(statearr_73955_73977[(1)] = (10));

} else {
var statearr_73956_73978 = state_73941__$1;
(statearr_73956_73978[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73942 === (5))){
var _ = (function (){var statearr_73957 = state_73941;
(statearr_73957[(4)] = cljs.core.rest((state_73941[(4)])));

return statearr_73957;
})();
var state_73941__$1 = state_73941;
var ex73953 = (state_73941__$1[(2)]);
var statearr_73958_73979 = state_73941__$1;
(statearr_73958_73979[(5)] = ex73953);


if((ex73953 instanceof Error)){
var statearr_73959_73980 = state_73941__$1;
(statearr_73959_73980[(1)] = (4));

(statearr_73959_73980[(5)] = null);

} else {
throw ex73953;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73942 === (10))){
var inst_73907 = (state_73941[(7)]);
var inst_73917 = cljs.core.first(inst_73907);
var state_73941__$1 = state_73941;
var statearr_73960_73981 = state_73941__$1;
(statearr_73960_73981[(2)] = inst_73917);

(statearr_73960_73981[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73942 === (8))){
var inst_73909 = (state_73941[(8)]);
var state_73941__$1 = state_73941;
var statearr_73961_73982 = state_73941__$1;
(statearr_73961_73982[(2)] = inst_73909);

(statearr_73961_73982[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_73962 = [null,null,null,null,null,null,null,null,null,null];
(statearr_73962[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_73962[(1)] = (1));

return statearr_73962;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_73941){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_73941);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e73963){var ex__16156__auto__ = e73963;
var statearr_73964_73983 = state_73941;
(statearr_73964_73983[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_73941[(4)]))){
var statearr_73965_73984 = state_73941;
(statearr_73965_73984[(1)] = cljs.core.first((state_73941[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__73985 = state_73941;
state_73941 = G__73985;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_73941){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_73941);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_73966 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_73966[(6)] = c__16227__auto__);

return statearr_73966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq73896){
var G__73897 = cljs.core.first(seq73896);
var seq73896__$1 = cljs.core.next(seq73896);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73897,seq73896__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___74035 = arguments.length;
var i__4830__auto___74036 = (0);
while(true){
if((i__4830__auto___74036 < len__4829__auto___74035)){
args__4835__auto__.push((arguments[i__4830__auto___74036]));

var G__74037 = (i__4830__auto___74036 + (1));
i__4830__auto___74036 = G__74037;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74018){
var state_val_74019 = (state_74018[(1)]);
if((state_val_74019 === (1))){
var state_74018__$1 = state_74018;
var statearr_74020_74038 = state_74018__$1;
(statearr_74020_74038[(2)] = null);

(statearr_74020_74038[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74019 === (2))){
var _ = (function (){var statearr_74021 = state_74018;
(statearr_74021[(4)] = cljs.core.cons((5),(state_74018[(4)])));

return statearr_74021;
})();
var inst_73994 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74018__$1 = state_74018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74018__$1,(6),inst_73994);
} else {
if((state_val_74019 === (3))){
var inst_74016 = (state_74018[(2)]);
var state_74018__$1 = state_74018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74018__$1,inst_74016);
} else {
if((state_val_74019 === (4))){
var inst_73988 = (state_74018[(2)]);
var state_74018__$1 = state_74018;
var statearr_74023_74039 = state_74018__$1;
(statearr_74023_74039[(2)] = inst_73988);

(statearr_74023_74039[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74019 === (5))){
var _ = (function (){var statearr_74024 = state_74018;
(statearr_74024[(4)] = cljs.core.rest((state_74018[(4)])));

return statearr_74024;
})();
var state_74018__$1 = state_74018;
var ex74022 = (state_74018__$1[(2)]);
var statearr_74025_74040 = state_74018__$1;
(statearr_74025_74040[(5)] = ex74022);


if((ex74022 instanceof Error)){
var statearr_74026_74041 = state_74018__$1;
(statearr_74026_74041[(1)] = (4));

(statearr_74026_74041[(5)] = null);

} else {
throw ex74022;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74019 === (6))){
var inst_73996 = (state_74018[(2)]);
var inst_73997 = fluree.db.util.async.throw_err(inst_73996);
var inst_73998 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_73997);
var inst_73999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74000 = [inst_73997];
var inst_74001 = (new cljs.core.PersistentVector(null,1,(5),inst_73999,inst_74000,null));
var inst_74002 = cljs.core.count(inst_74001);
var inst_74003 = ((9) + inst_74002);
var inst_74004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74005 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74007 = [inst_73997];
var inst_74008 = (new cljs.core.PersistentVector(null,1,(5),inst_74006,inst_74007,null));
var inst_74009 = ["==",inst_74008,inst_73998];
var inst_74010 = cljs.core.PersistentHashMap.fromArrays(inst_74005,inst_74009);
var inst_74011 = [inst_74010,inst_74003];
var inst_74012 = (new cljs.core.PersistentVector(null,2,(5),inst_74004,inst_74011,null));
var inst_74013 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74012);
var _ = (function (){var statearr_74027 = state_74018;
(statearr_74027[(4)] = cljs.core.rest((state_74018[(4)])));

return statearr_74027;
})();
var state_74018__$1 = (function (){var statearr_74028 = state_74018;
(statearr_74028[(7)] = inst_74013);

return statearr_74028;
})();
var statearr_74029_74042 = state_74018__$1;
(statearr_74029_74042[(2)] = inst_73998);

(statearr_74029_74042[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_74030 = [null,null,null,null,null,null,null,null];
(statearr_74030[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_74030[(1)] = (1));

return statearr_74030;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_74018){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74018);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74031){var ex__16156__auto__ = e74031;
var statearr_74032_74043 = state_74018;
(statearr_74032_74043[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74018[(4)]))){
var statearr_74033_74044 = state_74018;
(statearr_74033_74044[(1)] = cljs.core.first((state_74018[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74045 = state_74018;
state_74018 = G__74045;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_74018){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_74018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74034 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74034[(6)] = c__16227__auto__);

return statearr_74034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq73986){
var G__73987 = cljs.core.first(seq73986);
var seq73986__$1 = cljs.core.next(seq73986);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__73987,seq73986__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___74095 = arguments.length;
var i__4830__auto___74096 = (0);
while(true){
if((i__4830__auto___74096 < len__4829__auto___74095)){
args__4835__auto__.push((arguments[i__4830__auto___74096]));

var G__74097 = (i__4830__auto___74096 + (1));
i__4830__auto___74096 = G__74097;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74078){
var state_val_74079 = (state_74078[(1)]);
if((state_val_74079 === (1))){
var state_74078__$1 = state_74078;
var statearr_74080_74098 = state_74078__$1;
(statearr_74080_74098[(2)] = null);

(statearr_74080_74098[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74079 === (2))){
var _ = (function (){var statearr_74081 = state_74078;
(statearr_74081[(4)] = cljs.core.cons((5),(state_74078[(4)])));

return statearr_74081;
})();
var inst_74054 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74078__$1 = state_74078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74078__$1,(6),inst_74054);
} else {
if((state_val_74079 === (3))){
var inst_74076 = (state_74078[(2)]);
var state_74078__$1 = state_74078;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74078__$1,inst_74076);
} else {
if((state_val_74079 === (4))){
var inst_74048 = (state_74078[(2)]);
var state_74078__$1 = state_74078;
var statearr_74083_74099 = state_74078__$1;
(statearr_74083_74099[(2)] = inst_74048);

(statearr_74083_74099[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74079 === (5))){
var _ = (function (){var statearr_74084 = state_74078;
(statearr_74084[(4)] = cljs.core.rest((state_74078[(4)])));

return statearr_74084;
})();
var state_74078__$1 = state_74078;
var ex74082 = (state_74078__$1[(2)]);
var statearr_74085_74100 = state_74078__$1;
(statearr_74085_74100[(5)] = ex74082);


if((ex74082 instanceof Error)){
var statearr_74086_74101 = state_74078__$1;
(statearr_74086_74101[(1)] = (4));

(statearr_74086_74101[(5)] = null);

} else {
throw ex74082;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74079 === (6))){
var inst_74056 = (state_74078[(2)]);
var inst_74057 = fluree.db.util.async.throw_err(inst_74056);
var inst_74058 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_74057);
var inst_74059 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74060 = [inst_74057];
var inst_74061 = (new cljs.core.PersistentVector(null,1,(5),inst_74059,inst_74060,null));
var inst_74062 = cljs.core.count(inst_74061);
var inst_74063 = ((9) + inst_74062);
var inst_74064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74065 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74067 = [inst_74057];
var inst_74068 = (new cljs.core.PersistentVector(null,1,(5),inst_74066,inst_74067,null));
var inst_74069 = [">",inst_74068,inst_74058];
var inst_74070 = cljs.core.PersistentHashMap.fromArrays(inst_74065,inst_74069);
var inst_74071 = [inst_74070,inst_74063];
var inst_74072 = (new cljs.core.PersistentVector(null,2,(5),inst_74064,inst_74071,null));
var inst_74073 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74072);
var _ = (function (){var statearr_74087 = state_74078;
(statearr_74087[(4)] = cljs.core.rest((state_74078[(4)])));

return statearr_74087;
})();
var state_74078__$1 = (function (){var statearr_74088 = state_74078;
(statearr_74088[(7)] = inst_74073);

return statearr_74088;
})();
var statearr_74089_74102 = state_74078__$1;
(statearr_74089_74102[(2)] = inst_74058);

(statearr_74089_74102[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_74090 = [null,null,null,null,null,null,null,null];
(statearr_74090[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_74090[(1)] = (1));

return statearr_74090;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_74078){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74078);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74091){var ex__16156__auto__ = e74091;
var statearr_74092_74103 = state_74078;
(statearr_74092_74103[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74078[(4)]))){
var statearr_74093_74104 = state_74078;
(statearr_74093_74104[(1)] = cljs.core.first((state_74078[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74105 = state_74078;
state_74078 = G__74105;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_74078){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_74078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74094 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74094[(6)] = c__16227__auto__);

return statearr_74094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq74046){
var G__74047 = cljs.core.first(seq74046);
var seq74046__$1 = cljs.core.next(seq74046);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74047,seq74046__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___74155 = arguments.length;
var i__4830__auto___74156 = (0);
while(true){
if((i__4830__auto___74156 < len__4829__auto___74155)){
args__4835__auto__.push((arguments[i__4830__auto___74156]));

var G__74157 = (i__4830__auto___74156 + (1));
i__4830__auto___74156 = G__74157;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74138){
var state_val_74139 = (state_74138[(1)]);
if((state_val_74139 === (1))){
var state_74138__$1 = state_74138;
var statearr_74140_74158 = state_74138__$1;
(statearr_74140_74158[(2)] = null);

(statearr_74140_74158[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74139 === (2))){
var _ = (function (){var statearr_74141 = state_74138;
(statearr_74141[(4)] = cljs.core.cons((5),(state_74138[(4)])));

return statearr_74141;
})();
var inst_74114 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74138__$1 = state_74138;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74138__$1,(6),inst_74114);
} else {
if((state_val_74139 === (3))){
var inst_74136 = (state_74138[(2)]);
var state_74138__$1 = state_74138;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74138__$1,inst_74136);
} else {
if((state_val_74139 === (4))){
var inst_74108 = (state_74138[(2)]);
var state_74138__$1 = state_74138;
var statearr_74143_74159 = state_74138__$1;
(statearr_74143_74159[(2)] = inst_74108);

(statearr_74143_74159[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74139 === (5))){
var _ = (function (){var statearr_74144 = state_74138;
(statearr_74144[(4)] = cljs.core.rest((state_74138[(4)])));

return statearr_74144;
})();
var state_74138__$1 = state_74138;
var ex74142 = (state_74138__$1[(2)]);
var statearr_74145_74160 = state_74138__$1;
(statearr_74145_74160[(5)] = ex74142);


if((ex74142 instanceof Error)){
var statearr_74146_74161 = state_74138__$1;
(statearr_74146_74161[(1)] = (4));

(statearr_74146_74161[(5)] = null);

} else {
throw ex74142;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74139 === (6))){
var inst_74116 = (state_74138[(2)]);
var inst_74117 = fluree.db.util.async.throw_err(inst_74116);
var inst_74118 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_74117);
var inst_74119 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74120 = [inst_74117];
var inst_74121 = (new cljs.core.PersistentVector(null,1,(5),inst_74119,inst_74120,null));
var inst_74122 = cljs.core.count(inst_74121);
var inst_74123 = ((9) + inst_74122);
var inst_74124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74125 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74127 = [inst_74117];
var inst_74128 = (new cljs.core.PersistentVector(null,1,(5),inst_74126,inst_74127,null));
var inst_74129 = ["<",inst_74128,inst_74118];
var inst_74130 = cljs.core.PersistentHashMap.fromArrays(inst_74125,inst_74129);
var inst_74131 = [inst_74130,inst_74123];
var inst_74132 = (new cljs.core.PersistentVector(null,2,(5),inst_74124,inst_74131,null));
var inst_74133 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74132);
var _ = (function (){var statearr_74147 = state_74138;
(statearr_74147[(4)] = cljs.core.rest((state_74138[(4)])));

return statearr_74147;
})();
var state_74138__$1 = (function (){var statearr_74148 = state_74138;
(statearr_74148[(7)] = inst_74133);

return statearr_74148;
})();
var statearr_74149_74162 = state_74138__$1;
(statearr_74149_74162[(2)] = inst_74118);

(statearr_74149_74162[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_74150 = [null,null,null,null,null,null,null,null];
(statearr_74150[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_74150[(1)] = (1));

return statearr_74150;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_74138){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74138);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74151){var ex__16156__auto__ = e74151;
var statearr_74152_74163 = state_74138;
(statearr_74152_74163[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74138[(4)]))){
var statearr_74153_74164 = state_74138;
(statearr_74153_74164[(1)] = cljs.core.first((state_74138[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74165 = state_74138;
state_74138 = G__74165;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_74138){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_74138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74154 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74154[(6)] = c__16227__auto__);

return statearr_74154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq74106){
var G__74107 = cljs.core.first(seq74106);
var seq74106__$1 = cljs.core.next(seq74106);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74107,seq74106__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___74215 = arguments.length;
var i__4830__auto___74216 = (0);
while(true){
if((i__4830__auto___74216 < len__4829__auto___74215)){
args__4835__auto__.push((arguments[i__4830__auto___74216]));

var G__74217 = (i__4830__auto___74216 + (1));
i__4830__auto___74216 = G__74217;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74198){
var state_val_74199 = (state_74198[(1)]);
if((state_val_74199 === (1))){
var state_74198__$1 = state_74198;
var statearr_74200_74218 = state_74198__$1;
(statearr_74200_74218[(2)] = null);

(statearr_74200_74218[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74199 === (2))){
var _ = (function (){var statearr_74201 = state_74198;
(statearr_74201[(4)] = cljs.core.cons((5),(state_74198[(4)])));

return statearr_74201;
})();
var inst_74174 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74198__$1 = state_74198;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74198__$1,(6),inst_74174);
} else {
if((state_val_74199 === (3))){
var inst_74196 = (state_74198[(2)]);
var state_74198__$1 = state_74198;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74198__$1,inst_74196);
} else {
if((state_val_74199 === (4))){
var inst_74168 = (state_74198[(2)]);
var state_74198__$1 = state_74198;
var statearr_74203_74219 = state_74198__$1;
(statearr_74203_74219[(2)] = inst_74168);

(statearr_74203_74219[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74199 === (5))){
var _ = (function (){var statearr_74204 = state_74198;
(statearr_74204[(4)] = cljs.core.rest((state_74198[(4)])));

return statearr_74204;
})();
var state_74198__$1 = state_74198;
var ex74202 = (state_74198__$1[(2)]);
var statearr_74205_74220 = state_74198__$1;
(statearr_74205_74220[(5)] = ex74202);


if((ex74202 instanceof Error)){
var statearr_74206_74221 = state_74198__$1;
(statearr_74206_74221[(1)] = (4));

(statearr_74206_74221[(5)] = null);

} else {
throw ex74202;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74199 === (6))){
var inst_74176 = (state_74198[(2)]);
var inst_74177 = fluree.db.util.async.throw_err(inst_74176);
var inst_74178 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_74177);
var inst_74179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74180 = [inst_74177];
var inst_74181 = (new cljs.core.PersistentVector(null,1,(5),inst_74179,inst_74180,null));
var inst_74182 = cljs.core.count(inst_74181);
var inst_74183 = ((9) + inst_74182);
var inst_74184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74185 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74186 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74187 = [inst_74177];
var inst_74188 = (new cljs.core.PersistentVector(null,1,(5),inst_74186,inst_74187,null));
var inst_74189 = ["<=",inst_74188,inst_74178];
var inst_74190 = cljs.core.PersistentHashMap.fromArrays(inst_74185,inst_74189);
var inst_74191 = [inst_74190,inst_74183];
var inst_74192 = (new cljs.core.PersistentVector(null,2,(5),inst_74184,inst_74191,null));
var inst_74193 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74192);
var _ = (function (){var statearr_74207 = state_74198;
(statearr_74207[(4)] = cljs.core.rest((state_74198[(4)])));

return statearr_74207;
})();
var state_74198__$1 = (function (){var statearr_74208 = state_74198;
(statearr_74208[(7)] = inst_74193);

return statearr_74208;
})();
var statearr_74209_74222 = state_74198__$1;
(statearr_74209_74222[(2)] = inst_74178);

(statearr_74209_74222[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_74210 = [null,null,null,null,null,null,null,null];
(statearr_74210[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_74210[(1)] = (1));

return statearr_74210;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_74198){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74198);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74211){var ex__16156__auto__ = e74211;
var statearr_74212_74223 = state_74198;
(statearr_74212_74223[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74198[(4)]))){
var statearr_74213_74224 = state_74198;
(statearr_74213_74224[(1)] = cljs.core.first((state_74198[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74225 = state_74198;
state_74198 = G__74225;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_74198){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_74198);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74214 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74214[(6)] = c__16227__auto__);

return statearr_74214;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq74166){
var G__74167 = cljs.core.first(seq74166);
var seq74166__$1 = cljs.core.next(seq74166);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74167,seq74166__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___74275 = arguments.length;
var i__4830__auto___74276 = (0);
while(true){
if((i__4830__auto___74276 < len__4829__auto___74275)){
args__4835__auto__.push((arguments[i__4830__auto___74276]));

var G__74277 = (i__4830__auto___74276 + (1));
i__4830__auto___74276 = G__74277;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74258){
var state_val_74259 = (state_74258[(1)]);
if((state_val_74259 === (1))){
var state_74258__$1 = state_74258;
var statearr_74260_74278 = state_74258__$1;
(statearr_74260_74278[(2)] = null);

(statearr_74260_74278[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74259 === (2))){
var _ = (function (){var statearr_74261 = state_74258;
(statearr_74261[(4)] = cljs.core.cons((5),(state_74258[(4)])));

return statearr_74261;
})();
var inst_74234 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74258__$1 = state_74258;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74258__$1,(6),inst_74234);
} else {
if((state_val_74259 === (3))){
var inst_74256 = (state_74258[(2)]);
var state_74258__$1 = state_74258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74258__$1,inst_74256);
} else {
if((state_val_74259 === (4))){
var inst_74228 = (state_74258[(2)]);
var state_74258__$1 = state_74258;
var statearr_74263_74279 = state_74258__$1;
(statearr_74263_74279[(2)] = inst_74228);

(statearr_74263_74279[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74259 === (5))){
var _ = (function (){var statearr_74264 = state_74258;
(statearr_74264[(4)] = cljs.core.rest((state_74258[(4)])));

return statearr_74264;
})();
var state_74258__$1 = state_74258;
var ex74262 = (state_74258__$1[(2)]);
var statearr_74265_74280 = state_74258__$1;
(statearr_74265_74280[(5)] = ex74262);


if((ex74262 instanceof Error)){
var statearr_74266_74281 = state_74258__$1;
(statearr_74266_74281[(1)] = (4));

(statearr_74266_74281[(5)] = null);

} else {
throw ex74262;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74259 === (6))){
var inst_74236 = (state_74258[(2)]);
var inst_74237 = fluree.db.util.async.throw_err(inst_74236);
var inst_74238 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_74237);
var inst_74239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74240 = [inst_74237];
var inst_74241 = (new cljs.core.PersistentVector(null,1,(5),inst_74239,inst_74240,null));
var inst_74242 = cljs.core.count(inst_74241);
var inst_74243 = ((9) + inst_74242);
var inst_74244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74245 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74247 = [inst_74237];
var inst_74248 = (new cljs.core.PersistentVector(null,1,(5),inst_74246,inst_74247,null));
var inst_74249 = [">=",inst_74248,inst_74238];
var inst_74250 = cljs.core.PersistentHashMap.fromArrays(inst_74245,inst_74249);
var inst_74251 = [inst_74250,inst_74243];
var inst_74252 = (new cljs.core.PersistentVector(null,2,(5),inst_74244,inst_74251,null));
var inst_74253 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74252);
var _ = (function (){var statearr_74267 = state_74258;
(statearr_74267[(4)] = cljs.core.rest((state_74258[(4)])));

return statearr_74267;
})();
var state_74258__$1 = (function (){var statearr_74268 = state_74258;
(statearr_74268[(7)] = inst_74253);

return statearr_74268;
})();
var statearr_74269_74282 = state_74258__$1;
(statearr_74269_74282[(2)] = inst_74238);

(statearr_74269_74282[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_74270 = [null,null,null,null,null,null,null,null];
(statearr_74270[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_74270[(1)] = (1));

return statearr_74270;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_74258){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74258);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74271){var ex__16156__auto__ = e74271;
var statearr_74272_74283 = state_74258;
(statearr_74272_74283[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74258[(4)]))){
var statearr_74273_74284 = state_74258;
(statearr_74273_74284[(1)] = cljs.core.first((state_74258[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74285 = state_74258;
state_74258 = G__74285;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_74258){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_74258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74274 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74274[(6)] = c__16227__auto__);

return statearr_74274;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq74226){
var G__74227 = cljs.core.first(seq74226);
var seq74226__$1 = cljs.core.next(seq74226);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74227,seq74226__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___74335 = arguments.length;
var i__4830__auto___74336 = (0);
while(true){
if((i__4830__auto___74336 < len__4829__auto___74335)){
args__4835__auto__.push((arguments[i__4830__auto___74336]));

var G__74337 = (i__4830__auto___74336 + (1));
i__4830__auto___74336 = G__74337;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74318){
var state_val_74319 = (state_74318[(1)]);
if((state_val_74319 === (1))){
var state_74318__$1 = state_74318;
var statearr_74320_74338 = state_74318__$1;
(statearr_74320_74338[(2)] = null);

(statearr_74320_74338[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74319 === (2))){
var _ = (function (){var statearr_74321 = state_74318;
(statearr_74321[(4)] = cljs.core.cons((5),(state_74318[(4)])));

return statearr_74321;
})();
var inst_74294 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74318__$1 = state_74318;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74318__$1,(6),inst_74294);
} else {
if((state_val_74319 === (3))){
var inst_74316 = (state_74318[(2)]);
var state_74318__$1 = state_74318;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74318__$1,inst_74316);
} else {
if((state_val_74319 === (4))){
var inst_74288 = (state_74318[(2)]);
var state_74318__$1 = state_74318;
var statearr_74323_74339 = state_74318__$1;
(statearr_74323_74339[(2)] = inst_74288);

(statearr_74323_74339[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74319 === (5))){
var _ = (function (){var statearr_74324 = state_74318;
(statearr_74324[(4)] = cljs.core.rest((state_74318[(4)])));

return statearr_74324;
})();
var state_74318__$1 = state_74318;
var ex74322 = (state_74318__$1[(2)]);
var statearr_74325_74340 = state_74318__$1;
(statearr_74325_74340[(5)] = ex74322);


if((ex74322 instanceof Error)){
var statearr_74326_74341 = state_74318__$1;
(statearr_74326_74341[(1)] = (4));

(statearr_74326_74341[(5)] = null);

} else {
throw ex74322;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74319 === (6))){
var inst_74296 = (state_74318[(2)]);
var inst_74297 = fluree.db.util.async.throw_err(inst_74296);
var inst_74298 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_74297);
var inst_74299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74300 = [inst_74297];
var inst_74301 = (new cljs.core.PersistentVector(null,1,(5),inst_74299,inst_74300,null));
var inst_74302 = cljs.core.count(inst_74301);
var inst_74303 = ((9) + inst_74302);
var inst_74304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74305 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74307 = [inst_74297];
var inst_74308 = (new cljs.core.PersistentVector(null,1,(5),inst_74306,inst_74307,null));
var inst_74309 = ["not=",inst_74308,inst_74298];
var inst_74310 = cljs.core.PersistentHashMap.fromArrays(inst_74305,inst_74309);
var inst_74311 = [inst_74310,inst_74303];
var inst_74312 = (new cljs.core.PersistentVector(null,2,(5),inst_74304,inst_74311,null));
var inst_74313 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74312);
var _ = (function (){var statearr_74327 = state_74318;
(statearr_74327[(4)] = cljs.core.rest((state_74318[(4)])));

return statearr_74327;
})();
var state_74318__$1 = (function (){var statearr_74328 = state_74318;
(statearr_74328[(7)] = inst_74313);

return statearr_74328;
})();
var statearr_74329_74342 = state_74318__$1;
(statearr_74329_74342[(2)] = inst_74298);

(statearr_74329_74342[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_74330 = [null,null,null,null,null,null,null,null];
(statearr_74330[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_74330[(1)] = (1));

return statearr_74330;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_74318){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74318);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74331){var ex__16156__auto__ = e74331;
var statearr_74332_74343 = state_74318;
(statearr_74332_74343[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74318[(4)]))){
var statearr_74333_74344 = state_74318;
(statearr_74333_74344[(1)] = cljs.core.first((state_74318[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74345 = state_74318;
state_74318 = G__74345;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_74318){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_74318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74334 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74334[(6)] = c__16227__auto__);

return statearr_74334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq74286){
var G__74287 = cljs.core.first(seq74286);
var seq74286__$1 = cljs.core.next(seq74286);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74287,seq74286__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___74395 = arguments.length;
var i__4830__auto___74396 = (0);
while(true){
if((i__4830__auto___74396 < len__4829__auto___74395)){
args__4835__auto__.push((arguments[i__4830__auto___74396]));

var G__74397 = (i__4830__auto___74396 + (1));
i__4830__auto___74396 = G__74397;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74378){
var state_val_74379 = (state_74378[(1)]);
if((state_val_74379 === (1))){
var state_74378__$1 = state_74378;
var statearr_74380_74398 = state_74378__$1;
(statearr_74380_74398[(2)] = null);

(statearr_74380_74398[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74379 === (2))){
var _ = (function (){var statearr_74381 = state_74378;
(statearr_74381[(4)] = cljs.core.cons((5),(state_74378[(4)])));

return statearr_74381;
})();
var inst_74354 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74378__$1 = state_74378;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74378__$1,(6),inst_74354);
} else {
if((state_val_74379 === (3))){
var inst_74376 = (state_74378[(2)]);
var state_74378__$1 = state_74378;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74378__$1,inst_74376);
} else {
if((state_val_74379 === (4))){
var inst_74348 = (state_74378[(2)]);
var state_74378__$1 = state_74378;
var statearr_74383_74399 = state_74378__$1;
(statearr_74383_74399[(2)] = inst_74348);

(statearr_74383_74399[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74379 === (5))){
var _ = (function (){var statearr_74384 = state_74378;
(statearr_74384[(4)] = cljs.core.rest((state_74378[(4)])));

return statearr_74384;
})();
var state_74378__$1 = state_74378;
var ex74382 = (state_74378__$1[(2)]);
var statearr_74385_74400 = state_74378__$1;
(statearr_74385_74400[(5)] = ex74382);


if((ex74382 instanceof Error)){
var statearr_74386_74401 = state_74378__$1;
(statearr_74386_74401[(1)] = (4));

(statearr_74386_74401[(5)] = null);

} else {
throw ex74382;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74379 === (6))){
var inst_74356 = (state_74378[(2)]);
var inst_74357 = fluree.db.util.async.throw_err(inst_74356);
var inst_74358 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_74357);
var inst_74359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74360 = [inst_74357];
var inst_74361 = (new cljs.core.PersistentVector(null,1,(5),inst_74359,inst_74360,null));
var inst_74362 = cljs.core.count(inst_74361);
var inst_74363 = ((9) + inst_74362);
var inst_74364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74365 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74367 = [inst_74357];
var inst_74368 = (new cljs.core.PersistentVector(null,1,(5),inst_74366,inst_74367,null));
var inst_74369 = ["max",inst_74368,inst_74358];
var inst_74370 = cljs.core.PersistentHashMap.fromArrays(inst_74365,inst_74369);
var inst_74371 = [inst_74370,inst_74363];
var inst_74372 = (new cljs.core.PersistentVector(null,2,(5),inst_74364,inst_74371,null));
var inst_74373 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74372);
var _ = (function (){var statearr_74387 = state_74378;
(statearr_74387[(4)] = cljs.core.rest((state_74378[(4)])));

return statearr_74387;
})();
var state_74378__$1 = (function (){var statearr_74388 = state_74378;
(statearr_74388[(7)] = inst_74373);

return statearr_74388;
})();
var statearr_74389_74402 = state_74378__$1;
(statearr_74389_74402[(2)] = inst_74358);

(statearr_74389_74402[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_74390 = [null,null,null,null,null,null,null,null];
(statearr_74390[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_74390[(1)] = (1));

return statearr_74390;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_74378){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74378);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74391){var ex__16156__auto__ = e74391;
var statearr_74392_74403 = state_74378;
(statearr_74392_74403[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74378[(4)]))){
var statearr_74393_74404 = state_74378;
(statearr_74393_74404[(1)] = cljs.core.first((state_74378[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74405 = state_74378;
state_74378 = G__74405;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_74378){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_74378);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74394 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74394[(6)] = c__16227__auto__);

return statearr_74394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq74346){
var G__74347 = cljs.core.first(seq74346);
var seq74346__$1 = cljs.core.next(seq74346);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74347,seq74346__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___74455 = arguments.length;
var i__4830__auto___74456 = (0);
while(true){
if((i__4830__auto___74456 < len__4829__auto___74455)){
args__4835__auto__.push((arguments[i__4830__auto___74456]));

var G__74457 = (i__4830__auto___74456 + (1));
i__4830__auto___74456 = G__74457;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74438){
var state_val_74439 = (state_74438[(1)]);
if((state_val_74439 === (1))){
var state_74438__$1 = state_74438;
var statearr_74440_74458 = state_74438__$1;
(statearr_74440_74458[(2)] = null);

(statearr_74440_74458[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74439 === (2))){
var _ = (function (){var statearr_74441 = state_74438;
(statearr_74441[(4)] = cljs.core.cons((5),(state_74438[(4)])));

return statearr_74441;
})();
var inst_74414 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_74438__$1 = state_74438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74438__$1,(6),inst_74414);
} else {
if((state_val_74439 === (3))){
var inst_74436 = (state_74438[(2)]);
var state_74438__$1 = state_74438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74438__$1,inst_74436);
} else {
if((state_val_74439 === (4))){
var inst_74408 = (state_74438[(2)]);
var state_74438__$1 = state_74438;
var statearr_74443_74459 = state_74438__$1;
(statearr_74443_74459[(2)] = inst_74408);

(statearr_74443_74459[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74439 === (5))){
var _ = (function (){var statearr_74444 = state_74438;
(statearr_74444[(4)] = cljs.core.rest((state_74438[(4)])));

return statearr_74444;
})();
var state_74438__$1 = state_74438;
var ex74442 = (state_74438__$1[(2)]);
var statearr_74445_74460 = state_74438__$1;
(statearr_74445_74460[(5)] = ex74442);


if((ex74442 instanceof Error)){
var statearr_74446_74461 = state_74438__$1;
(statearr_74446_74461[(1)] = (4));

(statearr_74446_74461[(5)] = null);

} else {
throw ex74442;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74439 === (6))){
var inst_74416 = (state_74438[(2)]);
var inst_74417 = fluree.db.util.async.throw_err(inst_74416);
var inst_74418 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_74417);
var inst_74419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74420 = [inst_74417];
var inst_74421 = (new cljs.core.PersistentVector(null,1,(5),inst_74419,inst_74420,null));
var inst_74422 = cljs.core.count(inst_74421);
var inst_74423 = ((9) + inst_74422);
var inst_74424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74425 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74427 = [inst_74417];
var inst_74428 = (new cljs.core.PersistentVector(null,1,(5),inst_74426,inst_74427,null));
var inst_74429 = ["min",inst_74428,inst_74418];
var inst_74430 = cljs.core.PersistentHashMap.fromArrays(inst_74425,inst_74429);
var inst_74431 = [inst_74430,inst_74423];
var inst_74432 = (new cljs.core.PersistentVector(null,2,(5),inst_74424,inst_74431,null));
var inst_74433 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74432);
var _ = (function (){var statearr_74447 = state_74438;
(statearr_74447[(4)] = cljs.core.rest((state_74438[(4)])));

return statearr_74447;
})();
var state_74438__$1 = (function (){var statearr_74448 = state_74438;
(statearr_74448[(7)] = inst_74433);

return statearr_74448;
})();
var statearr_74449_74462 = state_74438__$1;
(statearr_74449_74462[(2)] = inst_74418);

(statearr_74449_74462[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_74450 = [null,null,null,null,null,null,null,null];
(statearr_74450[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_74450[(1)] = (1));

return statearr_74450;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_74438){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74438);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74451){var ex__16156__auto__ = e74451;
var statearr_74452_74463 = state_74438;
(statearr_74452_74463[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74438[(4)]))){
var statearr_74453_74464 = state_74438;
(statearr_74453_74464[(1)] = cljs.core.first((state_74438[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74465 = state_74438;
state_74438 = G__74465;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_74438){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_74438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74454 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74454[(6)] = c__16227__auto__);

return statearr_74454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq74406){
var G__74407 = cljs.core.first(seq74406);
var seq74406__$1 = cljs.core.next(seq74406);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74407,seq74406__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__74467 = arguments.length;
switch (G__74467) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74512){
var state_val_74513 = (state_74512[(1)]);
if((state_val_74513 === (7))){
var state_74512__$1 = state_74512;
var statearr_74514_74651 = state_74512__$1;
(statearr_74514_74651[(2)] = query_map);

(statearr_74514_74651[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74513 === (1))){
var state_74512__$1 = state_74512;
var statearr_74515_74652 = state_74512__$1;
(statearr_74515_74652[(2)] = null);

(statearr_74515_74652[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74513 === (4))){
var inst_74468 = (state_74512[(2)]);
var state_74512__$1 = state_74512;
var statearr_74516_74653 = state_74512__$1;
(statearr_74516_74653[(2)] = inst_74468);

(statearr_74516_74653[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74513 === (13))){
var inst_74490 = (state_74512[(7)]);
var inst_74494 = (state_74512[(2)]);
var inst_74495 = fluree.db.util.async.throw_err(inst_74494);
var inst_74496 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74495,(0),null);
var inst_74497 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74495,(1),null);
var inst_74498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74499 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74501 = [inst_74490];
var inst_74502 = (new cljs.core.PersistentVector(null,1,(5),inst_74500,inst_74501,null));
var inst_74503 = ["query",inst_74502,inst_74496];
var inst_74504 = cljs.core.PersistentHashMap.fromArrays(inst_74499,inst_74503);
var inst_74505 = [inst_74504,inst_74497];
var inst_74506 = (new cljs.core.PersistentVector(null,2,(5),inst_74498,inst_74505,null));
var inst_74507 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74506);
var _ = (function (){var statearr_74517 = state_74512;
(statearr_74517[(4)] = cljs.core.rest((state_74512[(4)])));

return statearr_74517;
})();
var state_74512__$1 = (function (){var statearr_74518 = state_74512;
(statearr_74518[(8)] = inst_74507);

return statearr_74518;
})();
var statearr_74519_74654 = state_74512__$1;
(statearr_74519_74654[(2)] = inst_74496);

(statearr_74519_74654[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74513 === (6))){
var state_74512__$1 = state_74512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74512__$1,(9),query_map);
} else {
if((state_val_74513 === (3))){
var inst_74510 = (state_74512[(2)]);
var state_74512__$1 = state_74512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74512__$1,inst_74510);
} else {
if((state_val_74513 === (12))){
var inst_74490 = (state_74512[(7)]);
var inst_74490__$1 = (state_74512[(2)]);
var inst_74491 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_74492 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_74491,inst_74490__$1);
var state_74512__$1 = (function (){var statearr_74520 = state_74512;
(statearr_74520[(7)] = inst_74490__$1);

return statearr_74520;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74512__$1,(13),inst_74492);
} else {
if((state_val_74513 === (2))){
var _ = (function (){var statearr_74521 = state_74512;
(statearr_74521[(4)] = cljs.core.cons((5),(state_74512[(4)])));

return statearr_74521;
})();
var inst_74477 = fluree.db.util.async.channel_QMARK_(query_map);
var state_74512__$1 = state_74512;
if(inst_74477){
var statearr_74522_74655 = state_74512__$1;
(statearr_74522_74655[(1)] = (6));

} else {
var statearr_74523_74656 = state_74512__$1;
(statearr_74523_74656[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74513 === (11))){
var inst_74484 = (state_74512[(9)]);
var state_74512__$1 = state_74512;
var statearr_74525_74657 = state_74512__$1;
(statearr_74525_74657[(2)] = inst_74484);

(statearr_74525_74657[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74513 === (9))){
var inst_74480 = (state_74512[(2)]);
var inst_74481 = fluree.db.util.async.throw_err(inst_74480);
var state_74512__$1 = state_74512;
var statearr_74526_74658 = state_74512__$1;
(statearr_74526_74658[(2)] = inst_74481);

(statearr_74526_74658[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74513 === (5))){
var _ = (function (){var statearr_74527 = state_74512;
(statearr_74527[(4)] = cljs.core.rest((state_74512[(4)])));

return statearr_74527;
})();
var state_74512__$1 = state_74512;
var ex74524 = (state_74512__$1[(2)]);
var statearr_74528_74659 = state_74512__$1;
(statearr_74528_74659[(5)] = ex74524);


if((ex74524 instanceof Error)){
var statearr_74529_74660 = state_74512__$1;
(statearr_74529_74660[(1)] = (4));

(statearr_74529_74660[(5)] = null);

} else {
throw ex74524;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74513 === (10))){
var inst_74484 = (state_74512[(9)]);
var inst_74487 = fluree.db.util.json.parse(inst_74484);
var state_74512__$1 = state_74512;
var statearr_74530_74661 = state_74512__$1;
(statearr_74530_74661[(2)] = inst_74487);

(statearr_74530_74661[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74513 === (8))){
var inst_74484 = (state_74512[(9)]);
var inst_74484__$1 = (state_74512[(2)]);
var inst_74485 = typeof inst_74484__$1 === 'string';
var state_74512__$1 = (function (){var statearr_74531 = state_74512;
(statearr_74531[(9)] = inst_74484__$1);

return statearr_74531;
})();
if(cljs.core.truth_(inst_74485)){
var statearr_74532_74662 = state_74512__$1;
(statearr_74532_74662[(1)] = (10));

} else {
var statearr_74533_74663 = state_74512__$1;
(statearr_74533_74663[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_74534 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74534[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_74534[(1)] = (1));

return statearr_74534;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_74512){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74512);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74535){var ex__16156__auto__ = e74535;
var statearr_74536_74664 = state_74512;
(statearr_74536_74664[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74512[(4)]))){
var statearr_74537_74665 = state_74512;
(statearr_74537_74665[(1)] = cljs.core.first((state_74512[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74666 = state_74512;
state_74512 = G__74666;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_74512){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_74512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74538 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74538[(6)] = c__16227__auto__);

return statearr_74538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74609){
var state_val_74610 = (state_74609[(1)]);
if((state_val_74610 === (7))){
var state_74609__$1 = state_74609;
var statearr_74611_74667 = state_74609__$1;
(statearr_74611_74667[(2)] = select);

(statearr_74611_74667[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (20))){
var inst_74579 = (state_74609[(2)]);
var inst_74580 = fluree.db.util.async.channel_QMARK_(limit);
var state_74609__$1 = (function (){var statearr_74612 = state_74609;
(statearr_74612[(7)] = inst_74579);

return statearr_74612;
})();
if(inst_74580){
var statearr_74613_74668 = state_74609__$1;
(statearr_74613_74668[(1)] = (22));

} else {
var statearr_74614_74669 = state_74609__$1;
(statearr_74614_74669[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (1))){
var state_74609__$1 = state_74609;
var statearr_74615_74670 = state_74609__$1;
(statearr_74615_74670[(2)] = null);

(statearr_74615_74670[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (24))){
var inst_74563 = (state_74609[(8)]);
var inst_74579 = (state_74609[(7)]);
var inst_74555 = (state_74609[(9)]);
var inst_74571 = (state_74609[(10)]);
var inst_74587 = (state_74609[(2)]);
var inst_74588 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_74589 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_74588,inst_74555,inst_74563,inst_74571,inst_74579,inst_74587);
var state_74609__$1 = state_74609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74609__$1,(26),inst_74589);
} else {
if((state_val_74610 === (4))){
var inst_74539 = (state_74609[(2)]);
var state_74609__$1 = state_74609;
var statearr_74616_74671 = state_74609__$1;
(statearr_74616_74671[(2)] = inst_74539);

(statearr_74616_74671[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (15))){
var state_74609__$1 = state_74609;
var statearr_74617_74672 = state_74609__$1;
(statearr_74617_74672[(2)] = where);

(statearr_74617_74672[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (21))){
var inst_74575 = (state_74609[(2)]);
var inst_74576 = fluree.db.util.async.throw_err(inst_74575);
var state_74609__$1 = state_74609;
var statearr_74618_74673 = state_74609__$1;
(statearr_74618_74673[(2)] = inst_74576);

(statearr_74618_74673[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (13))){
var inst_74559 = (state_74609[(2)]);
var inst_74560 = fluree.db.util.async.throw_err(inst_74559);
var state_74609__$1 = state_74609;
var statearr_74619_74674 = state_74609__$1;
(statearr_74619_74674[(2)] = inst_74560);

(statearr_74619_74674[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (22))){
var state_74609__$1 = state_74609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74609__$1,(25),limit);
} else {
if((state_val_74610 === (6))){
var state_74609__$1 = state_74609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74609__$1,(9),select);
} else {
if((state_val_74610 === (25))){
var inst_74583 = (state_74609[(2)]);
var inst_74584 = fluree.db.util.async.throw_err(inst_74583);
var state_74609__$1 = state_74609;
var statearr_74620_74675 = state_74609__$1;
(statearr_74620_74675[(2)] = inst_74584);

(statearr_74620_74675[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (17))){
var inst_74567 = (state_74609[(2)]);
var inst_74568 = fluree.db.util.async.throw_err(inst_74567);
var state_74609__$1 = state_74609;
var statearr_74621_74676 = state_74609__$1;
(statearr_74621_74676[(2)] = inst_74568);

(statearr_74621_74676[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (3))){
var inst_74607 = (state_74609[(2)]);
var state_74609__$1 = state_74609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74609__$1,inst_74607);
} else {
if((state_val_74610 === (12))){
var inst_74563 = (state_74609[(2)]);
var inst_74564 = fluree.db.util.async.channel_QMARK_(where);
var state_74609__$1 = (function (){var statearr_74622 = state_74609;
(statearr_74622[(8)] = inst_74563);

return statearr_74622;
})();
if(inst_74564){
var statearr_74623_74677 = state_74609__$1;
(statearr_74623_74677[(1)] = (14));

} else {
var statearr_74624_74678 = state_74609__$1;
(statearr_74624_74678[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (2))){
var _ = (function (){var statearr_74625 = state_74609;
(statearr_74625[(4)] = cljs.core.cons((5),(state_74609[(4)])));

return statearr_74625;
})();
var inst_74548 = fluree.db.util.async.channel_QMARK_(select);
var state_74609__$1 = state_74609;
if(inst_74548){
var statearr_74626_74679 = state_74609__$1;
(statearr_74626_74679[(1)] = (6));

} else {
var statearr_74627_74680 = state_74609__$1;
(statearr_74627_74680[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (23))){
var state_74609__$1 = state_74609;
var statearr_74628_74681 = state_74609__$1;
(statearr_74628_74681[(2)] = limit);

(statearr_74628_74681[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (19))){
var state_74609__$1 = state_74609;
var statearr_74629_74682 = state_74609__$1;
(statearr_74629_74682[(2)] = block);

(statearr_74629_74682[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (11))){
var state_74609__$1 = state_74609;
var statearr_74631_74683 = state_74609__$1;
(statearr_74631_74683[(2)] = from);

(statearr_74631_74683[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (9))){
var inst_74551 = (state_74609[(2)]);
var inst_74552 = fluree.db.util.async.throw_err(inst_74551);
var state_74609__$1 = state_74609;
var statearr_74632_74684 = state_74609__$1;
(statearr_74632_74684[(2)] = inst_74552);

(statearr_74632_74684[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (5))){
var _ = (function (){var statearr_74633 = state_74609;
(statearr_74633[(4)] = cljs.core.rest((state_74609[(4)])));

return statearr_74633;
})();
var state_74609__$1 = state_74609;
var ex74630 = (state_74609__$1[(2)]);
var statearr_74634_74685 = state_74609__$1;
(statearr_74634_74685[(5)] = ex74630);


if((ex74630 instanceof Error)){
var statearr_74635_74686 = state_74609__$1;
(statearr_74635_74686[(1)] = (4));

(statearr_74635_74686[(5)] = null);

} else {
throw ex74630;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (14))){
var state_74609__$1 = state_74609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74609__$1,(17),where);
} else {
if((state_val_74610 === (26))){
var inst_74563 = (state_74609[(8)]);
var inst_74579 = (state_74609[(7)]);
var inst_74555 = (state_74609[(9)]);
var inst_74571 = (state_74609[(10)]);
var inst_74591 = (state_74609[(2)]);
var inst_74592 = fluree.db.util.async.throw_err(inst_74591);
var inst_74593 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74592,(0),null);
var inst_74594 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74592,(1),null);
var inst_74595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74596 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74598 = [inst_74555,inst_74563,inst_74571,inst_74579];
var inst_74599 = (new cljs.core.PersistentVector(null,4,(5),inst_74597,inst_74598,null));
var inst_74600 = ["query",inst_74599,inst_74593];
var inst_74601 = cljs.core.PersistentHashMap.fromArrays(inst_74596,inst_74600);
var inst_74602 = [inst_74601,inst_74594];
var inst_74603 = (new cljs.core.PersistentVector(null,2,(5),inst_74595,inst_74602,null));
var inst_74604 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74603);
var _ = (function (){var statearr_74636 = state_74609;
(statearr_74636[(4)] = cljs.core.rest((state_74609[(4)])));

return statearr_74636;
})();
var state_74609__$1 = (function (){var statearr_74637 = state_74609;
(statearr_74637[(11)] = inst_74604);

return statearr_74637;
})();
var statearr_74638_74687 = state_74609__$1;
(statearr_74638_74687[(2)] = inst_74593);

(statearr_74638_74687[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (16))){
var inst_74571 = (state_74609[(2)]);
var inst_74572 = fluree.db.util.async.channel_QMARK_(block);
var state_74609__$1 = (function (){var statearr_74639 = state_74609;
(statearr_74639[(10)] = inst_74571);

return statearr_74639;
})();
if(inst_74572){
var statearr_74640_74688 = state_74609__$1;
(statearr_74640_74688[(1)] = (18));

} else {
var statearr_74641_74689 = state_74609__$1;
(statearr_74641_74689[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74610 === (10))){
var state_74609__$1 = state_74609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74609__$1,(13),from);
} else {
if((state_val_74610 === (18))){
var state_74609__$1 = state_74609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74609__$1,(21),block);
} else {
if((state_val_74610 === (8))){
var inst_74555 = (state_74609[(2)]);
var inst_74556 = fluree.db.util.async.channel_QMARK_(from);
var state_74609__$1 = (function (){var statearr_74642 = state_74609;
(statearr_74642[(9)] = inst_74555);

return statearr_74642;
})();
if(inst_74556){
var statearr_74643_74690 = state_74609__$1;
(statearr_74643_74690[(1)] = (10));

} else {
var statearr_74644_74691 = state_74609__$1;
(statearr_74644_74691[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_74645 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74645[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_74645[(1)] = (1));

return statearr_74645;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_74609){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74609);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74646){var ex__16156__auto__ = e74646;
var statearr_74647_74692 = state_74609;
(statearr_74647_74692[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74609[(4)]))){
var statearr_74648_74693 = state_74609;
(statearr_74648_74693[(1)] = cljs.core.first((state_74609[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74694 = state_74609;
state_74609 = G__74694;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_74609){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_74609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74649 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74649[(6)] = c__16227__auto__);

return statearr_74649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74750){
var state_val_74751 = (state_74750[(1)]);
if((state_val_74751 === (7))){
var state_74750__$1 = state_74750;
var statearr_74752_74783 = state_74750__$1;
(statearr_74752_74783[(2)] = startSubject);

(statearr_74752_74783[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (1))){
var state_74750__$1 = state_74750;
var statearr_74753_74784 = state_74750__$1;
(statearr_74753_74784[(2)] = null);

(statearr_74753_74784[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (4))){
var inst_74695 = (state_74750[(2)]);
var state_74750__$1 = state_74750;
var statearr_74754_74785 = state_74750__$1;
(statearr_74754_74785[(2)] = inst_74695);

(statearr_74754_74785[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (15))){
var inst_74727 = (state_74750[(2)]);
var inst_74728 = fluree.db.util.async.throw_err(inst_74727);
var inst_74729 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74728,(0),null);
var inst_74730 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74728,(1),null);
var inst_74731 = cljs.core.empty_QMARK_(inst_74729);
var state_74750__$1 = (function (){var statearr_74755 = state_74750;
(statearr_74755[(7)] = inst_74730);

return statearr_74755;
})();
if(inst_74731){
var statearr_74756_74786 = state_74750__$1;
(statearr_74756_74786[(1)] = (16));

} else {
var statearr_74757_74787 = state_74750__$1;
(statearr_74757_74787[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (13))){
var inst_74715 = (state_74750[(8)]);
var inst_74723 = (state_74750[(9)]);
var inst_74711 = (state_74750[(10)]);
var inst_74723__$1 = (state_74750[(2)]);
var inst_74724 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_74725 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_74724,inst_74711,inst_74715,inst_74723__$1);
var state_74750__$1 = (function (){var statearr_74758 = state_74750;
(statearr_74758[(9)] = inst_74723__$1);

return statearr_74758;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74750__$1,(15),inst_74725);
} else {
if((state_val_74751 === (6))){
var state_74750__$1 = state_74750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74750__$1,(9),startSubject);
} else {
if((state_val_74751 === (17))){
var state_74750__$1 = state_74750;
var statearr_74759_74788 = state_74750__$1;
(statearr_74759_74788[(2)] = true);

(statearr_74759_74788[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (3))){
var inst_74748 = (state_74750[(2)]);
var state_74750__$1 = state_74750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74750__$1,inst_74748);
} else {
if((state_val_74751 === (12))){
var state_74750__$1 = state_74750;
var statearr_74760_74789 = state_74750__$1;
(statearr_74760_74789[(2)] = endSubject);

(statearr_74760_74789[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (2))){
var _ = (function (){var statearr_74761 = state_74750;
(statearr_74761[(4)] = cljs.core.cons((5),(state_74750[(4)])));

return statearr_74761;
})();
var inst_74704 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_74750__$1 = state_74750;
if(inst_74704){
var statearr_74762_74790 = state_74750__$1;
(statearr_74762_74790[(1)] = (6));

} else {
var statearr_74763_74791 = state_74750__$1;
(statearr_74763_74791[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (11))){
var state_74750__$1 = state_74750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74750__$1,(14),endSubject);
} else {
if((state_val_74751 === (9))){
var inst_74707 = (state_74750[(2)]);
var inst_74708 = fluree.db.util.async.throw_err(inst_74707);
var state_74750__$1 = state_74750;
var statearr_74765_74792 = state_74750__$1;
(statearr_74765_74792[(2)] = inst_74708);

(statearr_74765_74792[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (5))){
var _ = (function (){var statearr_74766 = state_74750;
(statearr_74766[(4)] = cljs.core.rest((state_74750[(4)])));

return statearr_74766;
})();
var state_74750__$1 = state_74750;
var ex74764 = (state_74750__$1[(2)]);
var statearr_74767_74793 = state_74750__$1;
(statearr_74767_74793[(5)] = ex74764);


if((ex74764 instanceof Error)){
var statearr_74768_74794 = state_74750__$1;
(statearr_74768_74794[(1)] = (4));

(statearr_74768_74794[(5)] = null);

} else {
throw ex74764;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (14))){
var inst_74719 = (state_74750[(2)]);
var inst_74720 = fluree.db.util.async.throw_err(inst_74719);
var state_74750__$1 = state_74750;
var statearr_74769_74795 = state_74750__$1;
(statearr_74769_74795[(2)] = inst_74720);

(statearr_74769_74795[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (16))){
var state_74750__$1 = state_74750;
var statearr_74770_74796 = state_74750__$1;
(statearr_74770_74796[(2)] = false);

(statearr_74770_74796[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (10))){
var inst_74714 = (state_74750[(2)]);
var inst_74715 = fluree.db.util.async.throw_err(inst_74714);
var inst_74716 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_74750__$1 = (function (){var statearr_74771 = state_74750;
(statearr_74771[(8)] = inst_74715);

return statearr_74771;
})();
if(inst_74716){
var statearr_74772_74797 = state_74750__$1;
(statearr_74772_74797[(1)] = (11));

} else {
var statearr_74773_74798 = state_74750__$1;
(statearr_74773_74798[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (18))){
var inst_74730 = (state_74750[(7)]);
var inst_74715 = (state_74750[(8)]);
var inst_74723 = (state_74750[(9)]);
var inst_74711 = (state_74750[(10)]);
var inst_74735 = (state_74750[(2)]);
var inst_74736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74737 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74739 = [inst_74711,inst_74715,inst_74723];
var inst_74740 = (new cljs.core.PersistentVector(null,3,(5),inst_74738,inst_74739,null));
var inst_74741 = ["relationship?",inst_74740,inst_74735];
var inst_74742 = cljs.core.PersistentHashMap.fromArrays(inst_74737,inst_74741);
var inst_74743 = [inst_74742,inst_74730];
var inst_74744 = (new cljs.core.PersistentVector(null,2,(5),inst_74736,inst_74743,null));
var inst_74745 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74744);
var _ = (function (){var statearr_74774 = state_74750;
(statearr_74774[(4)] = cljs.core.rest((state_74750[(4)])));

return statearr_74774;
})();
var state_74750__$1 = (function (){var statearr_74775 = state_74750;
(statearr_74775[(11)] = inst_74745);

return statearr_74775;
})();
var statearr_74776_74799 = state_74750__$1;
(statearr_74776_74799[(2)] = inst_74735);

(statearr_74776_74799[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74751 === (8))){
var inst_74711 = (state_74750[(2)]);
var inst_74712 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_74750__$1 = (function (){var statearr_74777 = state_74750;
(statearr_74777[(10)] = inst_74711);

return statearr_74777;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74750__$1,(10),inst_74712);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16153__auto____0 = (function (){
var statearr_74778 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74778[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16153__auto__);

(statearr_74778[(1)] = (1));

return statearr_74778;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16153__auto____1 = (function (state_74750){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74750);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74779){var ex__16156__auto__ = e74779;
var statearr_74780_74800 = state_74750;
(statearr_74780_74800[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74750[(4)]))){
var statearr_74781_74801 = state_74750;
(statearr_74781_74801[(1)] = cljs.core.first((state_74750[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74802 = state_74750;
state_74750 = G__74802;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16153__auto__ = function(state_74750){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16153__auto____1.call(this,state_74750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74782 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74782[(6)] = c__16227__auto__);

return statearr_74782;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74839){
var state_val_74840 = (state_74839[(1)]);
if((state_val_74840 === (7))){
var state_74839__$1 = state_74839;
var statearr_74841_74861 = state_74839__$1;
(statearr_74841_74861[(2)] = pred_name);

(statearr_74841_74861[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74840 === (1))){
var state_74839__$1 = state_74839;
var statearr_74842_74862 = state_74839__$1;
(statearr_74842_74862[(2)] = null);

(statearr_74842_74862[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74840 === (4))){
var inst_74803 = (state_74839[(2)]);
var state_74839__$1 = state_74839;
var statearr_74843_74863 = state_74839__$1;
(statearr_74843_74863[(2)] = inst_74803);

(statearr_74843_74863[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74840 === (6))){
var state_74839__$1 = state_74839;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74839__$1,(9),pred_name);
} else {
if((state_val_74840 === (3))){
var inst_74837 = (state_74839[(2)]);
var state_74839__$1 = state_74839;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74839__$1,inst_74837);
} else {
if((state_val_74840 === (2))){
var _ = (function (){var statearr_74845 = state_74839;
(statearr_74845[(4)] = cljs.core.cons((5),(state_74839[(4)])));

return statearr_74845;
})();
var inst_74812 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_74839__$1 = state_74839;
if(inst_74812){
var statearr_74846_74864 = state_74839__$1;
(statearr_74846_74864[(1)] = (6));

} else {
var statearr_74847_74865 = state_74839__$1;
(statearr_74847_74865[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74840 === (9))){
var inst_74815 = (state_74839[(2)]);
var inst_74816 = fluree.db.util.async.throw_err(inst_74815);
var state_74839__$1 = state_74839;
var statearr_74848_74866 = state_74839__$1;
(statearr_74848_74866[(2)] = inst_74816);

(statearr_74848_74866[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74840 === (5))){
var _ = (function (){var statearr_74849 = state_74839;
(statearr_74849[(4)] = cljs.core.rest((state_74839[(4)])));

return statearr_74849;
})();
var state_74839__$1 = state_74839;
var ex74844 = (state_74839__$1[(2)]);
var statearr_74850_74867 = state_74839__$1;
(statearr_74850_74867[(5)] = ex74844);


if((ex74844 instanceof Error)){
var statearr_74851_74868 = state_74839__$1;
(statearr_74851_74868[(1)] = (4));

(statearr_74851_74868[(5)] = null);

} else {
throw ex74844;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74840 === (10))){
var inst_74819 = (state_74839[(7)]);
var inst_74823 = (state_74839[(2)]);
var inst_74824 = fluree.db.util.async.throw_err(inst_74823);
var inst_74825 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74824,(0),null);
var inst_74826 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74824,(1),null);
var inst_74827 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74828 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74829 = ["max-pred-val",inst_74819,inst_74825];
var inst_74830 = cljs.core.PersistentHashMap.fromArrays(inst_74828,inst_74829);
var inst_74831 = (inst_74826 + (10));
var inst_74832 = [inst_74830,inst_74831];
var inst_74833 = (new cljs.core.PersistentVector(null,2,(5),inst_74827,inst_74832,null));
var inst_74834 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74833);
var _ = (function (){var statearr_74852 = state_74839;
(statearr_74852[(4)] = cljs.core.rest((state_74839[(4)])));

return statearr_74852;
})();
var state_74839__$1 = (function (){var statearr_74853 = state_74839;
(statearr_74853[(8)] = inst_74834);

return statearr_74853;
})();
var statearr_74854_74869 = state_74839__$1;
(statearr_74854_74869[(2)] = inst_74825);

(statearr_74854_74869[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74840 === (8))){
var inst_74819 = (state_74839[(7)]);
var inst_74819__$1 = (state_74839[(2)]);
var inst_74820 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_74821 = fluree.db.dbfunctions.internal.max_pred_val(inst_74820,inst_74819__$1,null);
var state_74839__$1 = (function (){var statearr_74855 = state_74839;
(statearr_74855[(7)] = inst_74819__$1);

return statearr_74855;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74839__$1,(10),inst_74821);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16153__auto____0 = (function (){
var statearr_74856 = [null,null,null,null,null,null,null,null,null];
(statearr_74856[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16153__auto__);

(statearr_74856[(1)] = (1));

return statearr_74856;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16153__auto____1 = (function (state_74839){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74839);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74857){var ex__16156__auto__ = e74857;
var statearr_74858_74870 = state_74839;
(statearr_74858_74870[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74839[(4)]))){
var statearr_74859_74871 = state_74839;
(statearr_74859_74871[(1)] = cljs.core.first((state_74839[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74872 = state_74839;
state_74839 = G__74872;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16153__auto__ = function(state_74839){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16153__auto____1.call(this,state_74839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74860 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74860[(6)] = c__16227__auto__);

return statearr_74860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74899){
var state_val_74900 = (state_74899[(1)]);
if((state_val_74900 === (7))){
var state_74899__$1 = state_74899;
var statearr_74901_74920 = state_74899__$1;
(statearr_74901_74920[(2)] = n);

(statearr_74901_74920[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74900 === (1))){
var state_74899__$1 = state_74899;
var statearr_74902_74921 = state_74899__$1;
(statearr_74902_74921[(2)] = null);

(statearr_74902_74921[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74900 === (4))){
var inst_74873 = (state_74899[(2)]);
var state_74899__$1 = state_74899;
var statearr_74903_74922 = state_74899__$1;
(statearr_74903_74922[(2)] = inst_74873);

(statearr_74903_74922[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74900 === (6))){
var state_74899__$1 = state_74899;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74899__$1,(9),n);
} else {
if((state_val_74900 === (3))){
var inst_74897 = (state_74899[(2)]);
var state_74899__$1 = state_74899;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74899__$1,inst_74897);
} else {
if((state_val_74900 === (2))){
var _ = (function (){var statearr_74905 = state_74899;
(statearr_74905[(4)] = cljs.core.cons((5),(state_74899[(4)])));

return statearr_74905;
})();
var inst_74879 = fluree.db.util.async.channel_QMARK_(n);
var state_74899__$1 = state_74899;
if(inst_74879){
var statearr_74906_74923 = state_74899__$1;
(statearr_74906_74923[(1)] = (6));

} else {
var statearr_74907_74924 = state_74899__$1;
(statearr_74907_74924[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74900 === (9))){
var inst_74882 = (state_74899[(2)]);
var inst_74883 = fluree.db.util.async.throw_err(inst_74882);
var state_74899__$1 = state_74899;
var statearr_74908_74925 = state_74899__$1;
(statearr_74908_74925[(2)] = inst_74883);

(statearr_74908_74925[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74900 === (5))){
var _ = (function (){var statearr_74909 = state_74899;
(statearr_74909[(4)] = cljs.core.rest((state_74899[(4)])));

return statearr_74909;
})();
var state_74899__$1 = state_74899;
var ex74904 = (state_74899__$1[(2)]);
var statearr_74910_74926 = state_74899__$1;
(statearr_74910_74926[(5)] = ex74904);


if((ex74904 instanceof Error)){
var statearr_74911_74927 = state_74899__$1;
(statearr_74911_74927[(1)] = (4));

(statearr_74911_74927[(5)] = null);

} else {
throw ex74904;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74900 === (8))){
var inst_74886 = (state_74899[(2)]);
var inst_74887 = fluree.db.dbfunctions.internal.inc(inst_74886);
var inst_74888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74889 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74890 = ["inc",inst_74886,inst_74887];
var inst_74891 = cljs.core.PersistentHashMap.fromArrays(inst_74889,inst_74890);
var inst_74892 = [inst_74891,(10)];
var inst_74893 = (new cljs.core.PersistentVector(null,2,(5),inst_74888,inst_74892,null));
var inst_74894 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74893);
var _ = (function (){var statearr_74912 = state_74899;
(statearr_74912[(4)] = cljs.core.rest((state_74899[(4)])));

return statearr_74912;
})();
var state_74899__$1 = (function (){var statearr_74913 = state_74899;
(statearr_74913[(7)] = inst_74894);

return statearr_74913;
})();
var statearr_74914_74928 = state_74899__$1;
(statearr_74914_74928[(2)] = inst_74887);

(statearr_74914_74928[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__16153__auto____0 = (function (){
var statearr_74915 = [null,null,null,null,null,null,null,null];
(statearr_74915[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__16153__auto__);

(statearr_74915[(1)] = (1));

return statearr_74915;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__16153__auto____1 = (function (state_74899){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74899);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74916){var ex__16156__auto__ = e74916;
var statearr_74917_74929 = state_74899;
(statearr_74917_74929[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74899[(4)]))){
var statearr_74918_74930 = state_74899;
(statearr_74918_74930[(1)] = cljs.core.first((state_74899[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74931 = state_74899;
state_74899 = G__74931;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__16153__auto__ = function(state_74899){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__16153__auto____1.call(this,state_74899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74919 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74919[(6)] = c__16227__auto__);

return statearr_74919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_74958){
var state_val_74959 = (state_74958[(1)]);
if((state_val_74959 === (7))){
var state_74958__$1 = state_74958;
var statearr_74960_74979 = state_74958__$1;
(statearr_74960_74979[(2)] = n);

(statearr_74960_74979[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74959 === (1))){
var state_74958__$1 = state_74958;
var statearr_74961_74980 = state_74958__$1;
(statearr_74961_74980[(2)] = null);

(statearr_74961_74980[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74959 === (4))){
var inst_74932 = (state_74958[(2)]);
var state_74958__$1 = state_74958;
var statearr_74962_74981 = state_74958__$1;
(statearr_74962_74981[(2)] = inst_74932);

(statearr_74962_74981[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74959 === (6))){
var state_74958__$1 = state_74958;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74958__$1,(9),n);
} else {
if((state_val_74959 === (3))){
var inst_74956 = (state_74958[(2)]);
var state_74958__$1 = state_74958;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74958__$1,inst_74956);
} else {
if((state_val_74959 === (2))){
var _ = (function (){var statearr_74964 = state_74958;
(statearr_74964[(4)] = cljs.core.cons((5),(state_74958[(4)])));

return statearr_74964;
})();
var inst_74938 = fluree.db.util.async.channel_QMARK_(n);
var state_74958__$1 = state_74958;
if(inst_74938){
var statearr_74965_74982 = state_74958__$1;
(statearr_74965_74982[(1)] = (6));

} else {
var statearr_74966_74983 = state_74958__$1;
(statearr_74966_74983[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74959 === (9))){
var inst_74941 = (state_74958[(2)]);
var inst_74942 = fluree.db.util.async.throw_err(inst_74941);
var state_74958__$1 = state_74958;
var statearr_74967_74984 = state_74958__$1;
(statearr_74967_74984[(2)] = inst_74942);

(statearr_74967_74984[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74959 === (5))){
var _ = (function (){var statearr_74968 = state_74958;
(statearr_74968[(4)] = cljs.core.rest((state_74958[(4)])));

return statearr_74968;
})();
var state_74958__$1 = state_74958;
var ex74963 = (state_74958__$1[(2)]);
var statearr_74969_74985 = state_74958__$1;
(statearr_74969_74985[(5)] = ex74963);


if((ex74963 instanceof Error)){
var statearr_74970_74986 = state_74958__$1;
(statearr_74970_74986[(1)] = (4));

(statearr_74970_74986[(5)] = null);

} else {
throw ex74963;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74959 === (8))){
var inst_74945 = (state_74958[(2)]);
var inst_74946 = fluree.db.dbfunctions.internal.dec(inst_74945);
var inst_74947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74948 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_74949 = ["dec",inst_74945,inst_74946];
var inst_74950 = cljs.core.PersistentHashMap.fromArrays(inst_74948,inst_74949);
var inst_74951 = [inst_74950,(10)];
var inst_74952 = (new cljs.core.PersistentVector(null,2,(5),inst_74947,inst_74951,null));
var inst_74953 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_74952);
var _ = (function (){var statearr_74971 = state_74958;
(statearr_74971[(4)] = cljs.core.rest((state_74958[(4)])));

return statearr_74971;
})();
var state_74958__$1 = (function (){var statearr_74972 = state_74958;
(statearr_74972[(7)] = inst_74953);

return statearr_74972;
})();
var statearr_74973_74987 = state_74958__$1;
(statearr_74973_74987[(2)] = inst_74946);

(statearr_74973_74987[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__16153__auto____0 = (function (){
var statearr_74974 = [null,null,null,null,null,null,null,null];
(statearr_74974[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__16153__auto__);

(statearr_74974[(1)] = (1));

return statearr_74974;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__16153__auto____1 = (function (state_74958){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_74958);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e74975){var ex__16156__auto__ = e74975;
var statearr_74976_74988 = state_74958;
(statearr_74976_74988[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_74958[(4)]))){
var statearr_74977_74989 = state_74958;
(statearr_74977_74989[(1)] = cljs.core.first((state_74958[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__74990 = state_74958;
state_74958 = G__74990;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__16153__auto__ = function(state_74958){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__16153__auto____1.call(this,state_74958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_74978 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_74978[(6)] = c__16227__auto__);

return statearr_74978;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___75040 = arguments.length;
var i__4830__auto___75041 = (0);
while(true){
if((i__4830__auto___75041 < len__4829__auto___75040)){
args__4835__auto__.push((arguments[i__4830__auto___75041]));

var G__75042 = (i__4830__auto___75041 + (1));
i__4830__auto___75041 = G__75042;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75023){
var state_val_75024 = (state_75023[(1)]);
if((state_val_75024 === (1))){
var state_75023__$1 = state_75023;
var statearr_75025_75043 = state_75023__$1;
(statearr_75025_75043[(2)] = null);

(statearr_75025_75043[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75024 === (2))){
var _ = (function (){var statearr_75026 = state_75023;
(statearr_75026[(4)] = cljs.core.cons((5),(state_75023[(4)])));

return statearr_75026;
})();
var inst_74999 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_75023__$1 = state_75023;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75023__$1,(6),inst_74999);
} else {
if((state_val_75024 === (3))){
var inst_75021 = (state_75023[(2)]);
var state_75023__$1 = state_75023;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75023__$1,inst_75021);
} else {
if((state_val_75024 === (4))){
var inst_74993 = (state_75023[(2)]);
var state_75023__$1 = state_75023;
var statearr_75028_75044 = state_75023__$1;
(statearr_75028_75044[(2)] = inst_74993);

(statearr_75028_75044[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75024 === (5))){
var _ = (function (){var statearr_75029 = state_75023;
(statearr_75029[(4)] = cljs.core.rest((state_75023[(4)])));

return statearr_75029;
})();
var state_75023__$1 = state_75023;
var ex75027 = (state_75023__$1[(2)]);
var statearr_75030_75045 = state_75023__$1;
(statearr_75030_75045[(5)] = ex75027);


if((ex75027 instanceof Error)){
var statearr_75031_75046 = state_75023__$1;
(statearr_75031_75046[(1)] = (4));

(statearr_75031_75046[(5)] = null);

} else {
throw ex75027;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75024 === (6))){
var inst_75001 = (state_75023[(2)]);
var inst_75002 = fluree.db.util.async.throw_err(inst_75001);
var inst_75003 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_75002);
var inst_75004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75005 = [inst_75002];
var inst_75006 = (new cljs.core.PersistentVector(null,1,(5),inst_75004,inst_75005,null));
var inst_75007 = cljs.core.count(inst_75006);
var inst_75008 = ((9) + inst_75007);
var inst_75009 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75010 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75012 = [inst_75002];
var inst_75013 = (new cljs.core.PersistentVector(null,1,(5),inst_75011,inst_75012,null));
var inst_75014 = ["+",inst_75013,inst_75003];
var inst_75015 = cljs.core.PersistentHashMap.fromArrays(inst_75010,inst_75014);
var inst_75016 = [inst_75015,inst_75008];
var inst_75017 = (new cljs.core.PersistentVector(null,2,(5),inst_75009,inst_75016,null));
var inst_75018 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75017);
var _ = (function (){var statearr_75032 = state_75023;
(statearr_75032[(4)] = cljs.core.rest((state_75023[(4)])));

return statearr_75032;
})();
var state_75023__$1 = (function (){var statearr_75033 = state_75023;
(statearr_75033[(7)] = inst_75018);

return statearr_75033;
})();
var statearr_75034_75047 = state_75023__$1;
(statearr_75034_75047[(2)] = inst_75003);

(statearr_75034_75047[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_75035 = [null,null,null,null,null,null,null,null];
(statearr_75035[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_75035[(1)] = (1));

return statearr_75035;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_75023){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75023);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75036){var ex__16156__auto__ = e75036;
var statearr_75037_75048 = state_75023;
(statearr_75037_75048[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75023[(4)]))){
var statearr_75038_75049 = state_75023;
(statearr_75038_75049[(1)] = cljs.core.first((state_75023[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75050 = state_75023;
state_75023 = G__75050;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_75023){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_75023);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75039 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75039[(6)] = c__16227__auto__);

return statearr_75039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq74991){
var G__74992 = cljs.core.first(seq74991);
var seq74991__$1 = cljs.core.next(seq74991);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74992,seq74991__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___75100 = arguments.length;
var i__4830__auto___75101 = (0);
while(true){
if((i__4830__auto___75101 < len__4829__auto___75100)){
args__4835__auto__.push((arguments[i__4830__auto___75101]));

var G__75102 = (i__4830__auto___75101 + (1));
i__4830__auto___75101 = G__75102;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75083){
var state_val_75084 = (state_75083[(1)]);
if((state_val_75084 === (1))){
var state_75083__$1 = state_75083;
var statearr_75085_75103 = state_75083__$1;
(statearr_75085_75103[(2)] = null);

(statearr_75085_75103[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75084 === (2))){
var _ = (function (){var statearr_75086 = state_75083;
(statearr_75086[(4)] = cljs.core.cons((5),(state_75083[(4)])));

return statearr_75086;
})();
var inst_75059 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_75083__$1 = state_75083;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75083__$1,(6),inst_75059);
} else {
if((state_val_75084 === (3))){
var inst_75081 = (state_75083[(2)]);
var state_75083__$1 = state_75083;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75083__$1,inst_75081);
} else {
if((state_val_75084 === (4))){
var inst_75053 = (state_75083[(2)]);
var state_75083__$1 = state_75083;
var statearr_75088_75104 = state_75083__$1;
(statearr_75088_75104[(2)] = inst_75053);

(statearr_75088_75104[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75084 === (5))){
var _ = (function (){var statearr_75089 = state_75083;
(statearr_75089[(4)] = cljs.core.rest((state_75083[(4)])));

return statearr_75089;
})();
var state_75083__$1 = state_75083;
var ex75087 = (state_75083__$1[(2)]);
var statearr_75090_75105 = state_75083__$1;
(statearr_75090_75105[(5)] = ex75087);


if((ex75087 instanceof Error)){
var statearr_75091_75106 = state_75083__$1;
(statearr_75091_75106[(1)] = (4));

(statearr_75091_75106[(5)] = null);

} else {
throw ex75087;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75084 === (6))){
var inst_75061 = (state_75083[(2)]);
var inst_75062 = fluree.db.util.async.throw_err(inst_75061);
var inst_75063 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_75062);
var inst_75064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75065 = [inst_75062];
var inst_75066 = (new cljs.core.PersistentVector(null,1,(5),inst_75064,inst_75065,null));
var inst_75067 = cljs.core.count(inst_75066);
var inst_75068 = ((9) + inst_75067);
var inst_75069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75070 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75071 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75072 = [inst_75062];
var inst_75073 = (new cljs.core.PersistentVector(null,1,(5),inst_75071,inst_75072,null));
var inst_75074 = ["-",inst_75073,inst_75063];
var inst_75075 = cljs.core.PersistentHashMap.fromArrays(inst_75070,inst_75074);
var inst_75076 = [inst_75075,inst_75068];
var inst_75077 = (new cljs.core.PersistentVector(null,2,(5),inst_75069,inst_75076,null));
var inst_75078 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75077);
var _ = (function (){var statearr_75092 = state_75083;
(statearr_75092[(4)] = cljs.core.rest((state_75083[(4)])));

return statearr_75092;
})();
var state_75083__$1 = (function (){var statearr_75093 = state_75083;
(statearr_75093[(7)] = inst_75078);

return statearr_75093;
})();
var statearr_75094_75107 = state_75083__$1;
(statearr_75094_75107[(2)] = inst_75063);

(statearr_75094_75107[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_75095 = [null,null,null,null,null,null,null,null];
(statearr_75095[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_75095[(1)] = (1));

return statearr_75095;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_75083){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75083);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75096){var ex__16156__auto__ = e75096;
var statearr_75097_75108 = state_75083;
(statearr_75097_75108[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75083[(4)]))){
var statearr_75098_75109 = state_75083;
(statearr_75098_75109[(1)] = cljs.core.first((state_75083[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75110 = state_75083;
state_75083 = G__75110;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_75083){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_75083);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75099 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75099[(6)] = c__16227__auto__);

return statearr_75099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq75051){
var G__75052 = cljs.core.first(seq75051);
var seq75051__$1 = cljs.core.next(seq75051);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__75052,seq75051__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___75160 = arguments.length;
var i__4830__auto___75161 = (0);
while(true){
if((i__4830__auto___75161 < len__4829__auto___75160)){
args__4835__auto__.push((arguments[i__4830__auto___75161]));

var G__75162 = (i__4830__auto___75161 + (1));
i__4830__auto___75161 = G__75162;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75143){
var state_val_75144 = (state_75143[(1)]);
if((state_val_75144 === (1))){
var state_75143__$1 = state_75143;
var statearr_75145_75163 = state_75143__$1;
(statearr_75145_75163[(2)] = null);

(statearr_75145_75163[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75144 === (2))){
var _ = (function (){var statearr_75146 = state_75143;
(statearr_75146[(4)] = cljs.core.cons((5),(state_75143[(4)])));

return statearr_75146;
})();
var inst_75119 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_75143__$1 = state_75143;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75143__$1,(6),inst_75119);
} else {
if((state_val_75144 === (3))){
var inst_75141 = (state_75143[(2)]);
var state_75143__$1 = state_75143;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75143__$1,inst_75141);
} else {
if((state_val_75144 === (4))){
var inst_75113 = (state_75143[(2)]);
var state_75143__$1 = state_75143;
var statearr_75148_75164 = state_75143__$1;
(statearr_75148_75164[(2)] = inst_75113);

(statearr_75148_75164[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75144 === (5))){
var _ = (function (){var statearr_75149 = state_75143;
(statearr_75149[(4)] = cljs.core.rest((state_75143[(4)])));

return statearr_75149;
})();
var state_75143__$1 = state_75143;
var ex75147 = (state_75143__$1[(2)]);
var statearr_75150_75165 = state_75143__$1;
(statearr_75150_75165[(5)] = ex75147);


if((ex75147 instanceof Error)){
var statearr_75151_75166 = state_75143__$1;
(statearr_75151_75166[(1)] = (4));

(statearr_75151_75166[(5)] = null);

} else {
throw ex75147;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75144 === (6))){
var inst_75121 = (state_75143[(2)]);
var inst_75122 = fluree.db.util.async.throw_err(inst_75121);
var inst_75123 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_75122);
var inst_75124 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75125 = [inst_75122];
var inst_75126 = (new cljs.core.PersistentVector(null,1,(5),inst_75124,inst_75125,null));
var inst_75127 = cljs.core.count(inst_75126);
var inst_75128 = ((9) + inst_75127);
var inst_75129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75130 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75132 = [inst_75122];
var inst_75133 = (new cljs.core.PersistentVector(null,1,(5),inst_75131,inst_75132,null));
var inst_75134 = ["*",inst_75133,inst_75123];
var inst_75135 = cljs.core.PersistentHashMap.fromArrays(inst_75130,inst_75134);
var inst_75136 = [inst_75135,inst_75128];
var inst_75137 = (new cljs.core.PersistentVector(null,2,(5),inst_75129,inst_75136,null));
var inst_75138 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75137);
var _ = (function (){var statearr_75152 = state_75143;
(statearr_75152[(4)] = cljs.core.rest((state_75143[(4)])));

return statearr_75152;
})();
var state_75143__$1 = (function (){var statearr_75153 = state_75143;
(statearr_75153[(7)] = inst_75138);

return statearr_75153;
})();
var statearr_75154_75167 = state_75143__$1;
(statearr_75154_75167[(2)] = inst_75123);

(statearr_75154_75167[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_75155 = [null,null,null,null,null,null,null,null];
(statearr_75155[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_75155[(1)] = (1));

return statearr_75155;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_75143){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75143);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75156){var ex__16156__auto__ = e75156;
var statearr_75157_75168 = state_75143;
(statearr_75157_75168[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75143[(4)]))){
var statearr_75158_75169 = state_75143;
(statearr_75158_75169[(1)] = cljs.core.first((state_75143[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75170 = state_75143;
state_75143 = G__75170;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_75143){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_75143);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75159 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75159[(6)] = c__16227__auto__);

return statearr_75159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq75111){
var G__75112 = cljs.core.first(seq75111);
var seq75111__$1 = cljs.core.next(seq75111);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__75112,seq75111__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___75220 = arguments.length;
var i__4830__auto___75221 = (0);
while(true){
if((i__4830__auto___75221 < len__4829__auto___75220)){
args__4835__auto__.push((arguments[i__4830__auto___75221]));

var G__75222 = (i__4830__auto___75221 + (1));
i__4830__auto___75221 = G__75222;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75203){
var state_val_75204 = (state_75203[(1)]);
if((state_val_75204 === (1))){
var state_75203__$1 = state_75203;
var statearr_75205_75223 = state_75203__$1;
(statearr_75205_75223[(2)] = null);

(statearr_75205_75223[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75204 === (2))){
var _ = (function (){var statearr_75206 = state_75203;
(statearr_75206[(4)] = cljs.core.cons((5),(state_75203[(4)])));

return statearr_75206;
})();
var inst_75179 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_75203__$1 = state_75203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75203__$1,(6),inst_75179);
} else {
if((state_val_75204 === (3))){
var inst_75201 = (state_75203[(2)]);
var state_75203__$1 = state_75203;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75203__$1,inst_75201);
} else {
if((state_val_75204 === (4))){
var inst_75173 = (state_75203[(2)]);
var state_75203__$1 = state_75203;
var statearr_75208_75224 = state_75203__$1;
(statearr_75208_75224[(2)] = inst_75173);

(statearr_75208_75224[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75204 === (5))){
var _ = (function (){var statearr_75209 = state_75203;
(statearr_75209[(4)] = cljs.core.rest((state_75203[(4)])));

return statearr_75209;
})();
var state_75203__$1 = state_75203;
var ex75207 = (state_75203__$1[(2)]);
var statearr_75210_75225 = state_75203__$1;
(statearr_75210_75225[(5)] = ex75207);


if((ex75207 instanceof Error)){
var statearr_75211_75226 = state_75203__$1;
(statearr_75211_75226[(1)] = (4));

(statearr_75211_75226[(5)] = null);

} else {
throw ex75207;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75204 === (6))){
var inst_75181 = (state_75203[(2)]);
var inst_75182 = fluree.db.util.async.throw_err(inst_75181);
var inst_75183 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_75182);
var inst_75184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75185 = [inst_75182];
var inst_75186 = (new cljs.core.PersistentVector(null,1,(5),inst_75184,inst_75185,null));
var inst_75187 = cljs.core.count(inst_75186);
var inst_75188 = ((9) + inst_75187);
var inst_75189 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75190 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75191 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75192 = [inst_75182];
var inst_75193 = (new cljs.core.PersistentVector(null,1,(5),inst_75191,inst_75192,null));
var inst_75194 = ["/",inst_75193,inst_75183];
var inst_75195 = cljs.core.PersistentHashMap.fromArrays(inst_75190,inst_75194);
var inst_75196 = [inst_75195,inst_75188];
var inst_75197 = (new cljs.core.PersistentVector(null,2,(5),inst_75189,inst_75196,null));
var inst_75198 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75197);
var _ = (function (){var statearr_75212 = state_75203;
(statearr_75212[(4)] = cljs.core.rest((state_75203[(4)])));

return statearr_75212;
})();
var state_75203__$1 = (function (){var statearr_75213 = state_75203;
(statearr_75213[(7)] = inst_75198);

return statearr_75213;
})();
var statearr_75214_75227 = state_75203__$1;
(statearr_75214_75227[(2)] = inst_75183);

(statearr_75214_75227[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_75215 = [null,null,null,null,null,null,null,null];
(statearr_75215[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_75215[(1)] = (1));

return statearr_75215;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_75203){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75203);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75216){var ex__16156__auto__ = e75216;
var statearr_75217_75228 = state_75203;
(statearr_75217_75228[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75203[(4)]))){
var statearr_75218_75229 = state_75203;
(statearr_75218_75229[(1)] = cljs.core.first((state_75203[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75230 = state_75203;
state_75203 = G__75230;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_75203){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_75203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75219 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75219[(6)] = c__16227__auto__);

return statearr_75219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq75171){
var G__75172 = cljs.core.first(seq75171);
var seq75171__$1 = cljs.core.next(seq75171);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__75172,seq75171__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75268){
var state_val_75269 = (state_75268[(1)]);
if((state_val_75269 === (7))){
var state_75268__$1 = state_75268;
var statearr_75270_75294 = state_75268__$1;
(statearr_75270_75294[(2)] = n);

(statearr_75270_75294[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75269 === (1))){
var state_75268__$1 = state_75268;
var statearr_75271_75295 = state_75268__$1;
(statearr_75271_75295[(2)] = null);

(statearr_75271_75295[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75269 === (4))){
var inst_75231 = (state_75268[(2)]);
var state_75268__$1 = state_75268;
var statearr_75272_75296 = state_75268__$1;
(statearr_75272_75296[(2)] = inst_75231);

(statearr_75272_75296[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75269 === (13))){
var inst_75248 = (state_75268[(2)]);
var inst_75249 = fluree.db.util.async.throw_err(inst_75248);
var state_75268__$1 = state_75268;
var statearr_75273_75297 = state_75268__$1;
(statearr_75273_75297[(2)] = inst_75249);

(statearr_75273_75297[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75269 === (6))){
var state_75268__$1 = state_75268;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75268__$1,(9),n);
} else {
if((state_val_75269 === (3))){
var inst_75266 = (state_75268[(2)]);
var state_75268__$1 = state_75268;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75268__$1,inst_75266);
} else {
if((state_val_75269 === (12))){
var inst_75244 = (state_75268[(7)]);
var inst_75252 = (state_75268[(2)]);
var inst_75253 = fluree.db.dbfunctions.internal.quot(inst_75244,inst_75252);
var inst_75254 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75255 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75257 = [inst_75244,inst_75252];
var inst_75258 = (new cljs.core.PersistentVector(null,2,(5),inst_75256,inst_75257,null));
var inst_75259 = ["quot",inst_75258,inst_75253];
var inst_75260 = cljs.core.PersistentHashMap.fromArrays(inst_75255,inst_75259);
var inst_75261 = [inst_75260,(2)];
var inst_75262 = (new cljs.core.PersistentVector(null,2,(5),inst_75254,inst_75261,null));
var inst_75263 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75262);
var _ = (function (){var statearr_75274 = state_75268;
(statearr_75274[(4)] = cljs.core.rest((state_75268[(4)])));

return statearr_75274;
})();
var state_75268__$1 = (function (){var statearr_75275 = state_75268;
(statearr_75275[(8)] = inst_75263);

return statearr_75275;
})();
var statearr_75276_75298 = state_75268__$1;
(statearr_75276_75298[(2)] = inst_75253);

(statearr_75276_75298[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75269 === (2))){
var _ = (function (){var statearr_75277 = state_75268;
(statearr_75277[(4)] = cljs.core.cons((5),(state_75268[(4)])));

return statearr_75277;
})();
var inst_75237 = fluree.db.util.async.channel_QMARK_(n);
var state_75268__$1 = state_75268;
if(inst_75237){
var statearr_75278_75299 = state_75268__$1;
(statearr_75278_75299[(1)] = (6));

} else {
var statearr_75279_75300 = state_75268__$1;
(statearr_75279_75300[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75269 === (11))){
var state_75268__$1 = state_75268;
var statearr_75281_75301 = state_75268__$1;
(statearr_75281_75301[(2)] = d);

(statearr_75281_75301[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75269 === (9))){
var inst_75240 = (state_75268[(2)]);
var inst_75241 = fluree.db.util.async.throw_err(inst_75240);
var state_75268__$1 = state_75268;
var statearr_75282_75302 = state_75268__$1;
(statearr_75282_75302[(2)] = inst_75241);

(statearr_75282_75302[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75269 === (5))){
var _ = (function (){var statearr_75283 = state_75268;
(statearr_75283[(4)] = cljs.core.rest((state_75268[(4)])));

return statearr_75283;
})();
var state_75268__$1 = state_75268;
var ex75280 = (state_75268__$1[(2)]);
var statearr_75284_75303 = state_75268__$1;
(statearr_75284_75303[(5)] = ex75280);


if((ex75280 instanceof Error)){
var statearr_75285_75304 = state_75268__$1;
(statearr_75285_75304[(1)] = (4));

(statearr_75285_75304[(5)] = null);

} else {
throw ex75280;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75269 === (10))){
var state_75268__$1 = state_75268;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75268__$1,(13),d);
} else {
if((state_val_75269 === (8))){
var inst_75244 = (state_75268[(2)]);
var inst_75245 = fluree.db.util.async.channel_QMARK_(d);
var state_75268__$1 = (function (){var statearr_75286 = state_75268;
(statearr_75286[(7)] = inst_75244);

return statearr_75286;
})();
if(inst_75245){
var statearr_75287_75305 = state_75268__$1;
(statearr_75287_75305[(1)] = (10));

} else {
var statearr_75288_75306 = state_75268__$1;
(statearr_75288_75306[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__16153__auto____0 = (function (){
var statearr_75289 = [null,null,null,null,null,null,null,null,null];
(statearr_75289[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__16153__auto__);

(statearr_75289[(1)] = (1));

return statearr_75289;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__16153__auto____1 = (function (state_75268){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75268);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75290){var ex__16156__auto__ = e75290;
var statearr_75291_75307 = state_75268;
(statearr_75291_75307[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75268[(4)]))){
var statearr_75292_75308 = state_75268;
(statearr_75292_75308[(1)] = cljs.core.first((state_75268[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75309 = state_75268;
state_75268 = G__75309;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__16153__auto__ = function(state_75268){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__16153__auto____1.call(this,state_75268);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75293 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75293[(6)] = c__16227__auto__);

return statearr_75293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75347){
var state_val_75348 = (state_75347[(1)]);
if((state_val_75348 === (7))){
var state_75347__$1 = state_75347;
var statearr_75349_75373 = state_75347__$1;
(statearr_75349_75373[(2)] = n);

(statearr_75349_75373[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75348 === (1))){
var state_75347__$1 = state_75347;
var statearr_75350_75374 = state_75347__$1;
(statearr_75350_75374[(2)] = null);

(statearr_75350_75374[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75348 === (4))){
var inst_75310 = (state_75347[(2)]);
var state_75347__$1 = state_75347;
var statearr_75351_75375 = state_75347__$1;
(statearr_75351_75375[(2)] = inst_75310);

(statearr_75351_75375[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75348 === (13))){
var inst_75327 = (state_75347[(2)]);
var inst_75328 = fluree.db.util.async.throw_err(inst_75327);
var state_75347__$1 = state_75347;
var statearr_75352_75376 = state_75347__$1;
(statearr_75352_75376[(2)] = inst_75328);

(statearr_75352_75376[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75348 === (6))){
var state_75347__$1 = state_75347;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75347__$1,(9),n);
} else {
if((state_val_75348 === (3))){
var inst_75345 = (state_75347[(2)]);
var state_75347__$1 = state_75347;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75347__$1,inst_75345);
} else {
if((state_val_75348 === (12))){
var inst_75323 = (state_75347[(7)]);
var inst_75331 = (state_75347[(2)]);
var inst_75332 = fluree.db.dbfunctions.internal.mod(inst_75323,inst_75331);
var inst_75333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75334 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75335 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75336 = [inst_75323,inst_75331];
var inst_75337 = (new cljs.core.PersistentVector(null,2,(5),inst_75335,inst_75336,null));
var inst_75338 = ["mod",inst_75337,inst_75332];
var inst_75339 = cljs.core.PersistentHashMap.fromArrays(inst_75334,inst_75338);
var inst_75340 = [inst_75339,(2)];
var inst_75341 = (new cljs.core.PersistentVector(null,2,(5),inst_75333,inst_75340,null));
var inst_75342 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75341);
var _ = (function (){var statearr_75353 = state_75347;
(statearr_75353[(4)] = cljs.core.rest((state_75347[(4)])));

return statearr_75353;
})();
var state_75347__$1 = (function (){var statearr_75354 = state_75347;
(statearr_75354[(8)] = inst_75342);

return statearr_75354;
})();
var statearr_75355_75377 = state_75347__$1;
(statearr_75355_75377[(2)] = inst_75332);

(statearr_75355_75377[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75348 === (2))){
var _ = (function (){var statearr_75356 = state_75347;
(statearr_75356[(4)] = cljs.core.cons((5),(state_75347[(4)])));

return statearr_75356;
})();
var inst_75316 = fluree.db.util.async.channel_QMARK_(n);
var state_75347__$1 = state_75347;
if(inst_75316){
var statearr_75357_75378 = state_75347__$1;
(statearr_75357_75378[(1)] = (6));

} else {
var statearr_75358_75379 = state_75347__$1;
(statearr_75358_75379[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75348 === (11))){
var state_75347__$1 = state_75347;
var statearr_75360_75380 = state_75347__$1;
(statearr_75360_75380[(2)] = d);

(statearr_75360_75380[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75348 === (9))){
var inst_75319 = (state_75347[(2)]);
var inst_75320 = fluree.db.util.async.throw_err(inst_75319);
var state_75347__$1 = state_75347;
var statearr_75361_75381 = state_75347__$1;
(statearr_75361_75381[(2)] = inst_75320);

(statearr_75361_75381[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75348 === (5))){
var _ = (function (){var statearr_75362 = state_75347;
(statearr_75362[(4)] = cljs.core.rest((state_75347[(4)])));

return statearr_75362;
})();
var state_75347__$1 = state_75347;
var ex75359 = (state_75347__$1[(2)]);
var statearr_75363_75382 = state_75347__$1;
(statearr_75363_75382[(5)] = ex75359);


if((ex75359 instanceof Error)){
var statearr_75364_75383 = state_75347__$1;
(statearr_75364_75383[(1)] = (4));

(statearr_75364_75383[(5)] = null);

} else {
throw ex75359;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75348 === (10))){
var state_75347__$1 = state_75347;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75347__$1,(13),d);
} else {
if((state_val_75348 === (8))){
var inst_75323 = (state_75347[(2)]);
var inst_75324 = fluree.db.util.async.channel_QMARK_(d);
var state_75347__$1 = (function (){var statearr_75365 = state_75347;
(statearr_75365[(7)] = inst_75323);

return statearr_75365;
})();
if(inst_75324){
var statearr_75366_75384 = state_75347__$1;
(statearr_75366_75384[(1)] = (10));

} else {
var statearr_75367_75385 = state_75347__$1;
(statearr_75367_75385[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__16153__auto____0 = (function (){
var statearr_75368 = [null,null,null,null,null,null,null,null,null];
(statearr_75368[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__16153__auto__);

(statearr_75368[(1)] = (1));

return statearr_75368;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__16153__auto____1 = (function (state_75347){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75347);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75369){var ex__16156__auto__ = e75369;
var statearr_75370_75386 = state_75347;
(statearr_75370_75386[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75347[(4)]))){
var statearr_75371_75387 = state_75347;
(statearr_75371_75387[(1)] = cljs.core.first((state_75347[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75388 = state_75347;
state_75347 = G__75388;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__16153__auto__ = function(state_75347){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__16153__auto____1.call(this,state_75347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75372 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75372[(6)] = c__16227__auto__);

return statearr_75372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75426){
var state_val_75427 = (state_75426[(1)]);
if((state_val_75427 === (7))){
var state_75426__$1 = state_75426;
var statearr_75428_75452 = state_75426__$1;
(statearr_75428_75452[(2)] = n);

(statearr_75428_75452[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75427 === (1))){
var state_75426__$1 = state_75426;
var statearr_75429_75453 = state_75426__$1;
(statearr_75429_75453[(2)] = null);

(statearr_75429_75453[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75427 === (4))){
var inst_75389 = (state_75426[(2)]);
var state_75426__$1 = state_75426;
var statearr_75430_75454 = state_75426__$1;
(statearr_75430_75454[(2)] = inst_75389);

(statearr_75430_75454[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75427 === (13))){
var inst_75406 = (state_75426[(2)]);
var inst_75407 = fluree.db.util.async.throw_err(inst_75406);
var state_75426__$1 = state_75426;
var statearr_75431_75455 = state_75426__$1;
(statearr_75431_75455[(2)] = inst_75407);

(statearr_75431_75455[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75427 === (6))){
var state_75426__$1 = state_75426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75426__$1,(9),n);
} else {
if((state_val_75427 === (3))){
var inst_75424 = (state_75426[(2)]);
var state_75426__$1 = state_75426;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75426__$1,inst_75424);
} else {
if((state_val_75427 === (12))){
var inst_75402 = (state_75426[(7)]);
var inst_75410 = (state_75426[(2)]);
var inst_75411 = fluree.db.dbfunctions.internal.rem(inst_75402,inst_75410);
var inst_75412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75413 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75415 = [inst_75402,inst_75410];
var inst_75416 = (new cljs.core.PersistentVector(null,2,(5),inst_75414,inst_75415,null));
var inst_75417 = ["rem",inst_75416,inst_75411];
var inst_75418 = cljs.core.PersistentHashMap.fromArrays(inst_75413,inst_75417);
var inst_75419 = [inst_75418,(2)];
var inst_75420 = (new cljs.core.PersistentVector(null,2,(5),inst_75412,inst_75419,null));
var inst_75421 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75420);
var _ = (function (){var statearr_75432 = state_75426;
(statearr_75432[(4)] = cljs.core.rest((state_75426[(4)])));

return statearr_75432;
})();
var state_75426__$1 = (function (){var statearr_75433 = state_75426;
(statearr_75433[(8)] = inst_75421);

return statearr_75433;
})();
var statearr_75434_75456 = state_75426__$1;
(statearr_75434_75456[(2)] = inst_75411);

(statearr_75434_75456[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75427 === (2))){
var _ = (function (){var statearr_75435 = state_75426;
(statearr_75435[(4)] = cljs.core.cons((5),(state_75426[(4)])));

return statearr_75435;
})();
var inst_75395 = fluree.db.util.async.channel_QMARK_(n);
var state_75426__$1 = state_75426;
if(inst_75395){
var statearr_75436_75457 = state_75426__$1;
(statearr_75436_75457[(1)] = (6));

} else {
var statearr_75437_75458 = state_75426__$1;
(statearr_75437_75458[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75427 === (11))){
var state_75426__$1 = state_75426;
var statearr_75439_75459 = state_75426__$1;
(statearr_75439_75459[(2)] = d);

(statearr_75439_75459[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75427 === (9))){
var inst_75398 = (state_75426[(2)]);
var inst_75399 = fluree.db.util.async.throw_err(inst_75398);
var state_75426__$1 = state_75426;
var statearr_75440_75460 = state_75426__$1;
(statearr_75440_75460[(2)] = inst_75399);

(statearr_75440_75460[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75427 === (5))){
var _ = (function (){var statearr_75441 = state_75426;
(statearr_75441[(4)] = cljs.core.rest((state_75426[(4)])));

return statearr_75441;
})();
var state_75426__$1 = state_75426;
var ex75438 = (state_75426__$1[(2)]);
var statearr_75442_75461 = state_75426__$1;
(statearr_75442_75461[(5)] = ex75438);


if((ex75438 instanceof Error)){
var statearr_75443_75462 = state_75426__$1;
(statearr_75443_75462[(1)] = (4));

(statearr_75443_75462[(5)] = null);

} else {
throw ex75438;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75427 === (10))){
var state_75426__$1 = state_75426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75426__$1,(13),d);
} else {
if((state_val_75427 === (8))){
var inst_75402 = (state_75426[(2)]);
var inst_75403 = fluree.db.util.async.channel_QMARK_(d);
var state_75426__$1 = (function (){var statearr_75444 = state_75426;
(statearr_75444[(7)] = inst_75402);

return statearr_75444;
})();
if(inst_75403){
var statearr_75445_75463 = state_75426__$1;
(statearr_75445_75463[(1)] = (10));

} else {
var statearr_75446_75464 = state_75426__$1;
(statearr_75446_75464[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__16153__auto____0 = (function (){
var statearr_75447 = [null,null,null,null,null,null,null,null,null];
(statearr_75447[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__16153__auto__);

(statearr_75447[(1)] = (1));

return statearr_75447;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__16153__auto____1 = (function (state_75426){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75426);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75448){var ex__16156__auto__ = e75448;
var statearr_75449_75465 = state_75426;
(statearr_75449_75465[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75426[(4)]))){
var statearr_75450_75466 = state_75426;
(statearr_75450_75466[(1)] = cljs.core.first((state_75426[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75467 = state_75426;
state_75426 = G__75467;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__16153__auto__ = function(state_75426){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__16153__auto____1.call(this,state_75426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75451 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75451[(6)] = c__16227__auto__);

return statearr_75451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75494){
var state_val_75495 = (state_75494[(1)]);
if((state_val_75495 === (7))){
var state_75494__$1 = state_75494;
var statearr_75496_75515 = state_75494__$1;
(statearr_75496_75515[(2)] = x);

(statearr_75496_75515[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75495 === (1))){
var state_75494__$1 = state_75494;
var statearr_75497_75516 = state_75494__$1;
(statearr_75497_75516[(2)] = null);

(statearr_75497_75516[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75495 === (4))){
var inst_75468 = (state_75494[(2)]);
var state_75494__$1 = state_75494;
var statearr_75498_75517 = state_75494__$1;
(statearr_75498_75517[(2)] = inst_75468);

(statearr_75498_75517[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75495 === (6))){
var state_75494__$1 = state_75494;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75494__$1,(9),x);
} else {
if((state_val_75495 === (3))){
var inst_75492 = (state_75494[(2)]);
var state_75494__$1 = state_75494;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75494__$1,inst_75492);
} else {
if((state_val_75495 === (2))){
var _ = (function (){var statearr_75500 = state_75494;
(statearr_75500[(4)] = cljs.core.cons((5),(state_75494[(4)])));

return statearr_75500;
})();
var inst_75474 = fluree.db.util.async.channel_QMARK_(x);
var state_75494__$1 = state_75494;
if(inst_75474){
var statearr_75501_75518 = state_75494__$1;
(statearr_75501_75518[(1)] = (6));

} else {
var statearr_75502_75519 = state_75494__$1;
(statearr_75502_75519[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75495 === (9))){
var inst_75477 = (state_75494[(2)]);
var inst_75478 = fluree.db.util.async.throw_err(inst_75477);
var state_75494__$1 = state_75494;
var statearr_75503_75520 = state_75494__$1;
(statearr_75503_75520[(2)] = inst_75478);

(statearr_75503_75520[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75495 === (5))){
var _ = (function (){var statearr_75504 = state_75494;
(statearr_75504[(4)] = cljs.core.rest((state_75494[(4)])));

return statearr_75504;
})();
var state_75494__$1 = state_75494;
var ex75499 = (state_75494__$1[(2)]);
var statearr_75505_75521 = state_75494__$1;
(statearr_75505_75521[(5)] = ex75499);


if((ex75499 instanceof Error)){
var statearr_75506_75522 = state_75494__$1;
(statearr_75506_75522[(1)] = (4));

(statearr_75506_75522[(5)] = null);

} else {
throw ex75499;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75495 === (8))){
var inst_75481 = (state_75494[(2)]);
var inst_75482 = fluree.db.dbfunctions.internal.boolean$(inst_75481);
var inst_75483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75484 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75485 = ["boolean",inst_75481,inst_75482];
var inst_75486 = cljs.core.PersistentHashMap.fromArrays(inst_75484,inst_75485);
var inst_75487 = [inst_75486,(10)];
var inst_75488 = (new cljs.core.PersistentVector(null,2,(5),inst_75483,inst_75487,null));
var inst_75489 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75488);
var _ = (function (){var statearr_75507 = state_75494;
(statearr_75507[(4)] = cljs.core.rest((state_75494[(4)])));

return statearr_75507;
})();
var state_75494__$1 = (function (){var statearr_75508 = state_75494;
(statearr_75508[(7)] = inst_75489);

return statearr_75508;
})();
var statearr_75509_75523 = state_75494__$1;
(statearr_75509_75523[(2)] = inst_75482);

(statearr_75509_75523[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__16153__auto____0 = (function (){
var statearr_75510 = [null,null,null,null,null,null,null,null];
(statearr_75510[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__16153__auto__);

(statearr_75510[(1)] = (1));

return statearr_75510;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__16153__auto____1 = (function (state_75494){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75494);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75511){var ex__16156__auto__ = e75511;
var statearr_75512_75524 = state_75494;
(statearr_75512_75524[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75494[(4)]))){
var statearr_75513_75525 = state_75494;
(statearr_75513_75525[(1)] = cljs.core.first((state_75494[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75526 = state_75494;
state_75494 = G__75526;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__16153__auto__ = function(state_75494){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__16153__auto____1.call(this,state_75494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75514 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75514[(6)] = c__16227__auto__);

return statearr_75514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75564){
var state_val_75565 = (state_75564[(1)]);
if((state_val_75565 === (7))){
var state_75564__$1 = state_75564;
var statearr_75566_75590 = state_75564__$1;
(statearr_75566_75590[(2)] = pattern);

(statearr_75566_75590[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75565 === (1))){
var state_75564__$1 = state_75564;
var statearr_75567_75591 = state_75564__$1;
(statearr_75567_75591[(2)] = null);

(statearr_75567_75591[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75565 === (4))){
var inst_75527 = (state_75564[(2)]);
var state_75564__$1 = state_75564;
var statearr_75568_75592 = state_75564__$1;
(statearr_75568_75592[(2)] = inst_75527);

(statearr_75568_75592[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75565 === (13))){
var inst_75544 = (state_75564[(2)]);
var inst_75545 = fluree.db.util.async.throw_err(inst_75544);
var state_75564__$1 = state_75564;
var statearr_75569_75593 = state_75564__$1;
(statearr_75569_75593[(2)] = inst_75545);

(statearr_75569_75593[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75565 === (6))){
var state_75564__$1 = state_75564;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75564__$1,(9),pattern);
} else {
if((state_val_75565 === (3))){
var inst_75562 = (state_75564[(2)]);
var state_75564__$1 = state_75564;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75564__$1,inst_75562);
} else {
if((state_val_75565 === (12))){
var inst_75540 = (state_75564[(7)]);
var inst_75548 = (state_75564[(2)]);
var inst_75549 = fluree.db.dbfunctions.internal.re_find(inst_75540,inst_75548);
var inst_75550 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75551 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75553 = [inst_75540,inst_75548];
var inst_75554 = (new cljs.core.PersistentVector(null,2,(5),inst_75552,inst_75553,null));
var inst_75555 = ["re-find",inst_75554,inst_75549];
var inst_75556 = cljs.core.PersistentHashMap.fromArrays(inst_75551,inst_75555);
var inst_75557 = [inst_75556,(10)];
var inst_75558 = (new cljs.core.PersistentVector(null,2,(5),inst_75550,inst_75557,null));
var inst_75559 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75558);
var _ = (function (){var statearr_75570 = state_75564;
(statearr_75570[(4)] = cljs.core.rest((state_75564[(4)])));

return statearr_75570;
})();
var state_75564__$1 = (function (){var statearr_75571 = state_75564;
(statearr_75571[(8)] = inst_75559);

return statearr_75571;
})();
var statearr_75572_75594 = state_75564__$1;
(statearr_75572_75594[(2)] = inst_75549);

(statearr_75572_75594[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75565 === (2))){
var _ = (function (){var statearr_75573 = state_75564;
(statearr_75573[(4)] = cljs.core.cons((5),(state_75564[(4)])));

return statearr_75573;
})();
var inst_75533 = fluree.db.util.async.channel_QMARK_(pattern);
var state_75564__$1 = state_75564;
if(inst_75533){
var statearr_75574_75595 = state_75564__$1;
(statearr_75574_75595[(1)] = (6));

} else {
var statearr_75575_75596 = state_75564__$1;
(statearr_75575_75596[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75565 === (11))){
var state_75564__$1 = state_75564;
var statearr_75577_75597 = state_75564__$1;
(statearr_75577_75597[(2)] = string);

(statearr_75577_75597[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75565 === (9))){
var inst_75536 = (state_75564[(2)]);
var inst_75537 = fluree.db.util.async.throw_err(inst_75536);
var state_75564__$1 = state_75564;
var statearr_75578_75598 = state_75564__$1;
(statearr_75578_75598[(2)] = inst_75537);

(statearr_75578_75598[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75565 === (5))){
var _ = (function (){var statearr_75579 = state_75564;
(statearr_75579[(4)] = cljs.core.rest((state_75564[(4)])));

return statearr_75579;
})();
var state_75564__$1 = state_75564;
var ex75576 = (state_75564__$1[(2)]);
var statearr_75580_75599 = state_75564__$1;
(statearr_75580_75599[(5)] = ex75576);


if((ex75576 instanceof Error)){
var statearr_75581_75600 = state_75564__$1;
(statearr_75581_75600[(1)] = (4));

(statearr_75581_75600[(5)] = null);

} else {
throw ex75576;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75565 === (10))){
var state_75564__$1 = state_75564;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75564__$1,(13),string);
} else {
if((state_val_75565 === (8))){
var inst_75540 = (state_75564[(2)]);
var inst_75541 = fluree.db.util.async.channel_QMARK_(string);
var state_75564__$1 = (function (){var statearr_75582 = state_75564;
(statearr_75582[(7)] = inst_75540);

return statearr_75582;
})();
if(inst_75541){
var statearr_75583_75601 = state_75564__$1;
(statearr_75583_75601[(1)] = (10));

} else {
var statearr_75584_75602 = state_75564__$1;
(statearr_75584_75602[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__16153__auto____0 = (function (){
var statearr_75585 = [null,null,null,null,null,null,null,null,null];
(statearr_75585[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__16153__auto__);

(statearr_75585[(1)] = (1));

return statearr_75585;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__16153__auto____1 = (function (state_75564){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75564);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75586){var ex__16156__auto__ = e75586;
var statearr_75587_75603 = state_75564;
(statearr_75587_75603[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75564[(4)]))){
var statearr_75588_75604 = state_75564;
(statearr_75588_75604[(1)] = cljs.core.first((state_75564[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75605 = state_75564;
state_75564 = G__75605;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__16153__auto__ = function(state_75564){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__16153__auto____1.call(this,state_75564);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75589 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75589[(6)] = c__16227__auto__);

return statearr_75589;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75632){
var state_val_75633 = (state_75632[(1)]);
if((state_val_75633 === (7))){
var state_75632__$1 = state_75632;
var statearr_75634_75653 = state_75632__$1;
(statearr_75634_75653[(2)] = email);

(statearr_75634_75653[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75633 === (1))){
var state_75632__$1 = state_75632;
var statearr_75635_75654 = state_75632__$1;
(statearr_75635_75654[(2)] = null);

(statearr_75635_75654[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75633 === (4))){
var inst_75606 = (state_75632[(2)]);
var state_75632__$1 = state_75632;
var statearr_75636_75655 = state_75632__$1;
(statearr_75636_75655[(2)] = inst_75606);

(statearr_75636_75655[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75633 === (6))){
var state_75632__$1 = state_75632;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75632__$1,(9),email);
} else {
if((state_val_75633 === (3))){
var inst_75630 = (state_75632[(2)]);
var state_75632__$1 = state_75632;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75632__$1,inst_75630);
} else {
if((state_val_75633 === (2))){
var _ = (function (){var statearr_75638 = state_75632;
(statearr_75638[(4)] = cljs.core.cons((5),(state_75632[(4)])));

return statearr_75638;
})();
var inst_75612 = fluree.db.util.async.channel_QMARK_(email);
var state_75632__$1 = state_75632;
if(inst_75612){
var statearr_75639_75656 = state_75632__$1;
(statearr_75639_75656[(1)] = (6));

} else {
var statearr_75640_75657 = state_75632__$1;
(statearr_75640_75657[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75633 === (9))){
var inst_75615 = (state_75632[(2)]);
var inst_75616 = fluree.db.util.async.throw_err(inst_75615);
var state_75632__$1 = state_75632;
var statearr_75641_75658 = state_75632__$1;
(statearr_75641_75658[(2)] = inst_75616);

(statearr_75641_75658[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75633 === (5))){
var _ = (function (){var statearr_75642 = state_75632;
(statearr_75642[(4)] = cljs.core.rest((state_75632[(4)])));

return statearr_75642;
})();
var state_75632__$1 = state_75632;
var ex75637 = (state_75632__$1[(2)]);
var statearr_75643_75659 = state_75632__$1;
(statearr_75643_75659[(5)] = ex75637);


if((ex75637 instanceof Error)){
var statearr_75644_75660 = state_75632__$1;
(statearr_75644_75660[(1)] = (4));

(statearr_75644_75660[(5)] = null);

} else {
throw ex75637;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75633 === (8))){
var inst_75619 = (state_75632[(2)]);
var inst_75620 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_75619);
var inst_75621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75622 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75623 = ["re-find",inst_75619,inst_75620];
var inst_75624 = cljs.core.PersistentHashMap.fromArrays(inst_75622,inst_75623);
var inst_75625 = [inst_75624,(10)];
var inst_75626 = (new cljs.core.PersistentVector(null,2,(5),inst_75621,inst_75625,null));
var inst_75627 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75626);
var _ = (function (){var statearr_75645 = state_75632;
(statearr_75645[(4)] = cljs.core.rest((state_75632[(4)])));

return statearr_75645;
})();
var state_75632__$1 = (function (){var statearr_75646 = state_75632;
(statearr_75646[(7)] = inst_75627);

return statearr_75646;
})();
var statearr_75647_75661 = state_75632__$1;
(statearr_75647_75661[(2)] = inst_75620);

(statearr_75647_75661[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16153__auto____0 = (function (){
var statearr_75648 = [null,null,null,null,null,null,null,null];
(statearr_75648[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16153__auto__);

(statearr_75648[(1)] = (1));

return statearr_75648;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16153__auto____1 = (function (state_75632){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75632);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75649){var ex__16156__auto__ = e75649;
var statearr_75650_75662 = state_75632;
(statearr_75650_75662[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75632[(4)]))){
var statearr_75651_75663 = state_75632;
(statearr_75651_75663[(1)] = cljs.core.first((state_75632[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75664 = state_75632;
state_75632 = G__75664;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16153__auto__ = function(state_75632){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16153__auto____1.call(this,state_75632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75652 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75652[(6)] = c__16227__auto__);

return statearr_75652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75711){
var state_val_75712 = (state_75711[(1)]);
if((state_val_75712 === (7))){
var inst_75681 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_75711__$1 = state_75711;
if(cljs.core.truth_(inst_75681)){
var statearr_75713_75740 = state_75711__$1;
(statearr_75713_75740[(1)] = (9));

} else {
var statearr_75714_75741 = state_75711__$1;
(statearr_75714_75741[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75712 === (1))){
var state_75711__$1 = state_75711;
var statearr_75715_75742 = state_75711__$1;
(statearr_75715_75742[(2)] = null);

(statearr_75715_75742[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75712 === (4))){
var inst_75665 = (state_75711[(2)]);
var state_75711__$1 = state_75711;
var statearr_75716_75743 = state_75711__$1;
(statearr_75716_75743[(2)] = inst_75665);

(statearr_75716_75743[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75712 === (15))){
var inst_75692 = (state_75711[(2)]);
var state_75711__$1 = state_75711;
var statearr_75717_75744 = state_75711__$1;
(statearr_75717_75744[(2)] = inst_75692);

(statearr_75717_75744[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75712 === (13))){
var inst_75689 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_75711__$1 = state_75711;
var statearr_75718_75745 = state_75711__$1;
(statearr_75718_75745[(2)] = inst_75689);

(statearr_75718_75745[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75712 === (6))){
var inst_75676 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75677 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_75678 = [inst_75677,(0)];
var inst_75679 = (new cljs.core.PersistentVector(null,2,(5),inst_75676,inst_75678,null));
var state_75711__$1 = state_75711;
var statearr_75719_75746 = state_75711__$1;
(statearr_75719_75746[(2)] = inst_75679);

(statearr_75719_75746[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75712 === (3))){
var inst_75709 = (state_75711[(2)]);
var state_75711__$1 = state_75711;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75711__$1,inst_75709);
} else {
if((state_val_75712 === (12))){
var inst_75685 = (state_75711[(2)]);
var inst_75686 = fluree.db.util.async.throw_err(inst_75685);
var state_75711__$1 = state_75711;
var statearr_75720_75747 = state_75711__$1;
(statearr_75720_75747[(2)] = inst_75686);

(statearr_75720_75747[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75712 === (2))){
var _ = (function (){var statearr_75721 = state_75711;
(statearr_75721[(4)] = cljs.core.cons((5),(state_75711[(4)])));

return statearr_75721;
})();
var inst_75674 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_75711__$1 = state_75711;
if(cljs.core.truth_(inst_75674)){
var statearr_75722_75748 = state_75711__$1;
(statearr_75722_75748[(1)] = (6));

} else {
var statearr_75723_75749 = state_75711__$1;
(statearr_75723_75749[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75712 === (11))){
var inst_75694 = (state_75711[(2)]);
var state_75711__$1 = state_75711;
var statearr_75725_75750 = state_75711__$1;
(statearr_75725_75750[(2)] = inst_75694);

(statearr_75725_75750[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75712 === (9))){
var inst_75683 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_75711__$1 = state_75711;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75711__$1,(12),inst_75683);
} else {
if((state_val_75712 === (5))){
var _ = (function (){var statearr_75726 = state_75711;
(statearr_75726[(4)] = cljs.core.rest((state_75711[(4)])));

return statearr_75726;
})();
var state_75711__$1 = state_75711;
var ex75724 = (state_75711__$1[(2)]);
var statearr_75727_75751 = state_75711__$1;
(statearr_75727_75751[(5)] = ex75724);


if((ex75724 instanceof Error)){
var statearr_75728_75752 = state_75711__$1;
(statearr_75728_75752[(1)] = (4));

(statearr_75728_75752[(5)] = null);

} else {
throw ex75724;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75712 === (14))){
var state_75711__$1 = state_75711;
var statearr_75729_75753 = state_75711__$1;
(statearr_75729_75753[(2)] = null);

(statearr_75729_75753[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75712 === (10))){
var state_75711__$1 = state_75711;
var statearr_75730_75754 = state_75711__$1;
(statearr_75730_75754[(1)] = (13));



return cljs.core.cst$kw$recur;
} else {
if((state_val_75712 === (8))){
var inst_75696 = (state_75711[(2)]);
var inst_75697 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75696,(0),null);
var inst_75698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75696,(1),null);
var inst_75699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75700 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75701 = ["?user_id","?ctx",inst_75697];
var inst_75702 = cljs.core.PersistentHashMap.fromArrays(inst_75700,inst_75701);
var inst_75703 = ((10) + inst_75698);
var inst_75704 = [inst_75702,inst_75703];
var inst_75705 = (new cljs.core.PersistentVector(null,2,(5),inst_75699,inst_75704,null));
var inst_75706 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75705);
var _ = (function (){var statearr_75732 = state_75711;
(statearr_75732[(4)] = cljs.core.rest((state_75711[(4)])));

return statearr_75732;
})();
var state_75711__$1 = (function (){var statearr_75733 = state_75711;
(statearr_75733[(7)] = inst_75706);

return statearr_75733;
})();
var statearr_75734_75755 = state_75711__$1;
(statearr_75734_75755[(2)] = inst_75697);

(statearr_75734_75755[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16153__auto____0 = (function (){
var statearr_75735 = [null,null,null,null,null,null,null,null];
(statearr_75735[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16153__auto__);

(statearr_75735[(1)] = (1));

return statearr_75735;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16153__auto____1 = (function (state_75711){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75711);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75736){var ex__16156__auto__ = e75736;
var statearr_75737_75756 = state_75711;
(statearr_75737_75756[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75711[(4)]))){
var statearr_75738_75757 = state_75711;
(statearr_75738_75757[(1)] = cljs.core.first((state_75711[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75758 = state_75711;
state_75711 = G__75758;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16153__auto__ = function(state_75711){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16153__auto____1.call(this,state_75711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75739 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75739[(6)] = c__16227__auto__);

return statearr_75739;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75786){
var state_val_75787 = (state_75786[(1)]);
if((state_val_75787 === (7))){
var inst_75779 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_75786__$1 = state_75786;
var statearr_75788_75807 = state_75786__$1;
(statearr_75788_75807[(2)] = inst_75779);

(statearr_75788_75807[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75787 === (1))){
var state_75786__$1 = state_75786;
var statearr_75789_75808 = state_75786__$1;
(statearr_75789_75808[(2)] = null);

(statearr_75789_75808[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75787 === (4))){
var inst_75759 = (state_75786[(2)]);
var state_75786__$1 = state_75786;
var statearr_75790_75809 = state_75786__$1;
(statearr_75790_75809[(2)] = inst_75759);

(statearr_75790_75809[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75787 === (6))){
var inst_75767 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_75786__$1 = state_75786;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75786__$1,(9),inst_75767);
} else {
if((state_val_75787 === (3))){
var inst_75784 = (state_75786[(2)]);
var state_75786__$1 = state_75786;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75786__$1,inst_75784);
} else {
if((state_val_75787 === (2))){
var _ = (function (){var statearr_75792 = state_75786;
(statearr_75792[(4)] = cljs.core.cons((5),(state_75786[(4)])));

return statearr_75792;
})();
var inst_75765 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_75786__$1 = state_75786;
if(cljs.core.truth_(inst_75765)){
var statearr_75793_75810 = state_75786__$1;
(statearr_75793_75810[(1)] = (6));

} else {
var statearr_75794_75811 = state_75786__$1;
(statearr_75794_75811[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75787 === (9))){
var inst_75769 = (state_75786[(2)]);
var inst_75770 = fluree.db.util.async.throw_err(inst_75769);
var inst_75771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75772 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75773 = ["?auth_id","?ctx",inst_75770];
var inst_75774 = cljs.core.PersistentHashMap.fromArrays(inst_75772,inst_75773);
var inst_75775 = [inst_75774,(10)];
var inst_75776 = (new cljs.core.PersistentVector(null,2,(5),inst_75771,inst_75775,null));
var inst_75777 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75776);
var state_75786__$1 = (function (){var statearr_75795 = state_75786;
(statearr_75795[(7)] = inst_75777);

return statearr_75795;
})();
var statearr_75796_75812 = state_75786__$1;
(statearr_75796_75812[(2)] = inst_75770);

(statearr_75796_75812[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75787 === (5))){
var _ = (function (){var statearr_75797 = state_75786;
(statearr_75797[(4)] = cljs.core.rest((state_75786[(4)])));

return statearr_75797;
})();
var state_75786__$1 = state_75786;
var ex75791 = (state_75786__$1[(2)]);
var statearr_75798_75813 = state_75786__$1;
(statearr_75798_75813[(5)] = ex75791);


if((ex75791 instanceof Error)){
var statearr_75799_75814 = state_75786__$1;
(statearr_75799_75814[(1)] = (4));

(statearr_75799_75814[(5)] = null);

} else {
throw ex75791;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75787 === (8))){
var inst_75781 = (state_75786[(2)]);
var _ = (function (){var statearr_75800 = state_75786;
(statearr_75800[(4)] = cljs.core.rest((state_75786[(4)])));

return statearr_75800;
})();
var state_75786__$1 = state_75786;
var statearr_75801_75815 = state_75786__$1;
(statearr_75801_75815[(2)] = inst_75781);

(statearr_75801_75815[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16153__auto____0 = (function (){
var statearr_75802 = [null,null,null,null,null,null,null,null];
(statearr_75802[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16153__auto__);

(statearr_75802[(1)] = (1));

return statearr_75802;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16153__auto____1 = (function (state_75786){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75786);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75803){var ex__16156__auto__ = e75803;
var statearr_75804_75816 = state_75786;
(statearr_75804_75816[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75786[(4)]))){
var statearr_75805_75817 = state_75786;
(statearr_75805_75817[(1)] = cljs.core.first((state_75786[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75818 = state_75786;
state_75786 = G__75818;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16153__auto__ = function(state_75786){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16153__auto____1.call(this,state_75786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75806 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75806[(6)] = c__16227__auto__);

return statearr_75806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__75820 = arguments.length;
switch (G__75820) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75862){
var state_val_75863 = (state_75862[(1)]);
if((state_val_75863 === (7))){
var state_75862__$1 = state_75862;
var statearr_75864_75894 = state_75862__$1;
(statearr_75864_75894[(2)] = seed);

(statearr_75864_75894[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75863 === (1))){
var state_75862__$1 = state_75862;
var statearr_75865_75895 = state_75862__$1;
(statearr_75865_75895[(2)] = null);

(statearr_75865_75895[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75863 === (4))){
var inst_75821 = (state_75862[(2)]);
var state_75862__$1 = state_75862;
var statearr_75866_75896 = state_75862__$1;
(statearr_75866_75896[(2)] = inst_75821);

(statearr_75866_75896[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75863 === (15))){
var state_75862__$1 = state_75862;
var statearr_75867_75897 = state_75862__$1;
(statearr_75867_75897[(2)] = (10));

(statearr_75867_75897[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75863 === (13))){
var inst_75838 = (state_75862[(2)]);
var inst_75839 = fluree.db.util.async.throw_err(inst_75838);
var state_75862__$1 = state_75862;
var statearr_75868_75898 = state_75862__$1;
(statearr_75868_75898[(2)] = inst_75839);

(statearr_75868_75898[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75863 === (6))){
var state_75862__$1 = state_75862;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75862__$1,(9),seed);
} else {
if((state_val_75863 === (3))){
var inst_75860 = (state_75862[(2)]);
var state_75862__$1 = state_75862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75862__$1,inst_75860);
} else {
if((state_val_75863 === (12))){
var inst_75842 = (state_75862[(7)]);
var inst_75842__$1 = (state_75862[(2)]);
var state_75862__$1 = (function (){var statearr_75869 = state_75862;
(statearr_75869[(7)] = inst_75842__$1);

return statearr_75869;
})();
if(cljs.core.truth_(inst_75842__$1)){
var statearr_75870_75899 = state_75862__$1;
(statearr_75870_75899[(1)] = (14));

} else {
var statearr_75871_75900 = state_75862__$1;
(statearr_75871_75900[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75863 === (2))){
var _ = (function (){var statearr_75872 = state_75862;
(statearr_75872[(4)] = cljs.core.cons((5),(state_75862[(4)])));

return statearr_75872;
})();
var inst_75827 = fluree.db.util.async.channel_QMARK_(seed);
var state_75862__$1 = state_75862;
if(inst_75827){
var statearr_75873_75901 = state_75862__$1;
(statearr_75873_75901[(1)] = (6));

} else {
var statearr_75874_75902 = state_75862__$1;
(statearr_75874_75902[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75863 === (11))){
var state_75862__$1 = state_75862;
var statearr_75876_75903 = state_75862__$1;
(statearr_75876_75903[(2)] = max);

(statearr_75876_75903[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75863 === (9))){
var inst_75830 = (state_75862[(2)]);
var inst_75831 = fluree.db.util.async.throw_err(inst_75830);
var state_75862__$1 = state_75862;
var statearr_75877_75904 = state_75862__$1;
(statearr_75877_75904[(2)] = inst_75831);

(statearr_75877_75904[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75863 === (5))){
var _ = (function (){var statearr_75878 = state_75862;
(statearr_75878[(4)] = cljs.core.rest((state_75862[(4)])));

return statearr_75878;
})();
var state_75862__$1 = state_75862;
var ex75875 = (state_75862__$1[(2)]);
var statearr_75879_75905 = state_75862__$1;
(statearr_75879_75905[(5)] = ex75875);


if((ex75875 instanceof Error)){
var statearr_75880_75906 = state_75862__$1;
(statearr_75880_75906[(1)] = (4));

(statearr_75880_75906[(5)] = null);

} else {
throw ex75875;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75863 === (14))){
var inst_75842 = (state_75862[(7)]);
var state_75862__$1 = state_75862;
var statearr_75881_75907 = state_75862__$1;
(statearr_75881_75907[(2)] = inst_75842);

(statearr_75881_75907[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75863 === (16))){
var inst_75834 = (state_75862[(8)]);
var inst_75846 = (state_75862[(2)]);
var inst_75847 = fluree.db.dbfunctions.internal.rand(inst_75834,inst_75846);
var inst_75848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75849 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75851 = [max,seed];
var inst_75852 = (new cljs.core.PersistentVector(null,2,(5),inst_75850,inst_75851,null));
var inst_75853 = ["rand",inst_75852,inst_75847];
var inst_75854 = cljs.core.PersistentHashMap.fromArrays(inst_75849,inst_75853);
var inst_75855 = [inst_75854,(10)];
var inst_75856 = (new cljs.core.PersistentVector(null,2,(5),inst_75848,inst_75855,null));
var inst_75857 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75856);
var _ = (function (){var statearr_75882 = state_75862;
(statearr_75882[(4)] = cljs.core.rest((state_75862[(4)])));

return statearr_75882;
})();
var state_75862__$1 = (function (){var statearr_75883 = state_75862;
(statearr_75883[(9)] = inst_75857);

return statearr_75883;
})();
var statearr_75884_75908 = state_75862__$1;
(statearr_75884_75908[(2)] = inst_75847);

(statearr_75884_75908[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75863 === (10))){
var state_75862__$1 = state_75862;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75862__$1,(13),max);
} else {
if((state_val_75863 === (8))){
var inst_75834 = (state_75862[(2)]);
var inst_75835 = fluree.db.util.async.channel_QMARK_(max);
var state_75862__$1 = (function (){var statearr_75885 = state_75862;
(statearr_75885[(8)] = inst_75834);

return statearr_75885;
})();
if(inst_75835){
var statearr_75886_75909 = state_75862__$1;
(statearr_75886_75909[(1)] = (10));

} else {
var statearr_75887_75910 = state_75862__$1;
(statearr_75887_75910[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16153__auto____0 = (function (){
var statearr_75888 = [null,null,null,null,null,null,null,null,null,null];
(statearr_75888[(0)] = fluree$db$dbfunctions$fns$state_machine__16153__auto__);

(statearr_75888[(1)] = (1));

return statearr_75888;
});
var fluree$db$dbfunctions$fns$state_machine__16153__auto____1 = (function (state_75862){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75862);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75889){var ex__16156__auto__ = e75889;
var statearr_75890_75911 = state_75862;
(statearr_75890_75911[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75862[(4)]))){
var statearr_75891_75912 = state_75862;
(statearr_75891_75912[(1)] = cljs.core.first((state_75862[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75913 = state_75862;
state_75862 = G__75913;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16153__auto__ = function(state_75862){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16153__auto____1.call(this,state_75862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75892 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75892[(6)] = c__16227__auto__);

return statearr_75892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75934){
var state_val_75935 = (state_75934[(1)]);
if((state_val_75935 === (1))){
var state_75934__$1 = state_75934;
var statearr_75936_75951 = state_75934__$1;
(statearr_75936_75951[(2)] = null);

(statearr_75936_75951[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75935 === (2))){
var _ = (function (){var statearr_75937 = state_75934;
(statearr_75937[(4)] = cljs.core.cons((5),(state_75934[(4)])));

return statearr_75937;
})();
var inst_75920 = fluree.db.util.core.random_uuid();
var inst_75921 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75920);
var inst_75922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75923 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75924 = cljs.core.PersistentVector.EMPTY;
var inst_75925 = ["uuid",inst_75924,inst_75921];
var inst_75926 = cljs.core.PersistentHashMap.fromArrays(inst_75923,inst_75925);
var inst_75927 = [inst_75926,(10)];
var inst_75928 = (new cljs.core.PersistentVector(null,2,(5),inst_75922,inst_75927,null));
var inst_75929 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75928);
var ___$1 = (function (){var statearr_75938 = state_75934;
(statearr_75938[(4)] = cljs.core.rest((state_75934[(4)])));

return statearr_75938;
})();
var state_75934__$1 = (function (){var statearr_75939 = state_75934;
(statearr_75939[(7)] = inst_75929);

return statearr_75939;
})();
var statearr_75940_75952 = state_75934__$1;
(statearr_75940_75952[(2)] = inst_75921);

(statearr_75940_75952[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75935 === (3))){
var inst_75932 = (state_75934[(2)]);
var state_75934__$1 = state_75934;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75934__$1,inst_75932);
} else {
if((state_val_75935 === (4))){
var inst_75914 = (state_75934[(2)]);
var state_75934__$1 = state_75934;
var statearr_75942_75953 = state_75934__$1;
(statearr_75942_75953[(2)] = inst_75914);

(statearr_75942_75953[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75935 === (5))){
var _ = (function (){var statearr_75943 = state_75934;
(statearr_75943[(4)] = cljs.core.rest((state_75934[(4)])));

return statearr_75943;
})();
var state_75934__$1 = state_75934;
var ex75941 = (state_75934__$1[(2)]);
var statearr_75944_75954 = state_75934__$1;
(statearr_75944_75954[(5)] = ex75941);


if((ex75941 instanceof Error)){
var statearr_75945_75955 = state_75934__$1;
(statearr_75945_75955[(1)] = (4));

(statearr_75945_75955[(5)] = null);

} else {
throw ex75941;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__16153__auto____0 = (function (){
var statearr_75946 = [null,null,null,null,null,null,null,null];
(statearr_75946[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__16153__auto__);

(statearr_75946[(1)] = (1));

return statearr_75946;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__16153__auto____1 = (function (state_75934){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75934);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e75947){var ex__16156__auto__ = e75947;
var statearr_75948_75956 = state_75934;
(statearr_75948_75956[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75934[(4)]))){
var statearr_75949_75957 = state_75934;
(statearr_75949_75957[(1)] = cljs.core.first((state_75934[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__75958 = state_75934;
state_75934 = G__75958;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__16153__auto__ = function(state_75934){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__16153__auto____1.call(this,state_75934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_75950 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_75950[(6)] = c__16227__auto__);

return statearr_75950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_75988){
var state_val_75989 = (state_75988[(1)]);
if((state_val_75989 === (7))){
var state_75988__$1 = state_75988;
var statearr_75990_76009 = state_75988__$1;
(statearr_75990_76009[(2)] = num);

(statearr_75990_76009[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75989 === (1))){
var state_75988__$1 = state_75988;
var statearr_75991_76010 = state_75988__$1;
(statearr_75991_76010[(2)] = null);

(statearr_75991_76010[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75989 === (4))){
var inst_75959 = (state_75988[(2)]);
var state_75988__$1 = state_75988;
var statearr_75992_76011 = state_75988__$1;
(statearr_75992_76011[(2)] = inst_75959);

(statearr_75992_76011[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75989 === (6))){
var state_75988__$1 = state_75988;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75988__$1,(9),num);
} else {
if((state_val_75989 === (3))){
var inst_75986 = (state_75988[(2)]);
var state_75988__$1 = state_75988;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75988__$1,inst_75986);
} else {
if((state_val_75989 === (2))){
var _ = (function (){var statearr_75994 = state_75988;
(statearr_75994[(4)] = cljs.core.cons((5),(state_75988[(4)])));

return statearr_75994;
})();
var inst_75965 = fluree.db.util.async.channel_QMARK_(num);
var state_75988__$1 = state_75988;
if(inst_75965){
var statearr_75995_76012 = state_75988__$1;
(statearr_75995_76012[(1)] = (6));

} else {
var statearr_75996_76013 = state_75988__$1;
(statearr_75996_76013[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75989 === (9))){
var inst_75968 = (state_75988[(2)]);
var inst_75969 = fluree.db.util.async.throw_err(inst_75968);
var state_75988__$1 = state_75988;
var statearr_75997_76014 = state_75988__$1;
(statearr_75997_76014[(2)] = inst_75969);

(statearr_75997_76014[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75989 === (5))){
var _ = (function (){var statearr_75998 = state_75988;
(statearr_75998[(4)] = cljs.core.rest((state_75988[(4)])));

return statearr_75998;
})();
var state_75988__$1 = state_75988;
var ex75993 = (state_75988__$1[(2)]);
var statearr_75999_76015 = state_75988__$1;
(statearr_75999_76015[(5)] = ex75993);


if((ex75993 instanceof Error)){
var statearr_76000_76016 = state_75988__$1;
(statearr_76000_76016[(1)] = (4));

(statearr_76000_76016[(5)] = null);

} else {
throw ex75993;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75989 === (8))){
var inst_75972 = (state_75988[(2)]);
var inst_75973 = fluree.db.dbfunctions.internal.ceil(inst_75972);
var inst_75974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75975 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_75976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75977 = [fluree.db.dbfunctions.fns.ceil];
var inst_75978 = (new cljs.core.PersistentVector(null,1,(5),inst_75976,inst_75977,null));
var inst_75979 = ["",inst_75978,inst_75973];
var inst_75980 = cljs.core.PersistentHashMap.fromArrays(inst_75975,inst_75979);
var inst_75981 = [inst_75980,(10)];
var inst_75982 = (new cljs.core.PersistentVector(null,2,(5),inst_75974,inst_75981,null));
var inst_75983 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_75982);
var _ = (function (){var statearr_76001 = state_75988;
(statearr_76001[(4)] = cljs.core.rest((state_75988[(4)])));

return statearr_76001;
})();
var state_75988__$1 = (function (){var statearr_76002 = state_75988;
(statearr_76002[(7)] = inst_75983);

return statearr_76002;
})();
var statearr_76003_76017 = state_75988__$1;
(statearr_76003_76017[(2)] = inst_75973);

(statearr_76003_76017[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__16153__auto____0 = (function (){
var statearr_76004 = [null,null,null,null,null,null,null,null];
(statearr_76004[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__16153__auto__);

(statearr_76004[(1)] = (1));

return statearr_76004;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__16153__auto____1 = (function (state_75988){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_75988);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e76005){var ex__16156__auto__ = e76005;
var statearr_76006_76018 = state_75988;
(statearr_76006_76018[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_75988[(4)]))){
var statearr_76007_76019 = state_75988;
(statearr_76007_76019[(1)] = cljs.core.first((state_75988[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__76020 = state_75988;
state_75988 = G__76020;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__16153__auto__ = function(state_75988){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__16153__auto____1.call(this,state_75988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_76008 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_76008[(6)] = c__16227__auto__);

return statearr_76008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_76050){
var state_val_76051 = (state_76050[(1)]);
if((state_val_76051 === (7))){
var state_76050__$1 = state_76050;
var statearr_76052_76071 = state_76050__$1;
(statearr_76052_76071[(2)] = num);

(statearr_76052_76071[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76051 === (1))){
var state_76050__$1 = state_76050;
var statearr_76053_76072 = state_76050__$1;
(statearr_76053_76072[(2)] = null);

(statearr_76053_76072[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76051 === (4))){
var inst_76021 = (state_76050[(2)]);
var state_76050__$1 = state_76050;
var statearr_76054_76073 = state_76050__$1;
(statearr_76054_76073[(2)] = inst_76021);

(statearr_76054_76073[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76051 === (6))){
var state_76050__$1 = state_76050;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76050__$1,(9),num);
} else {
if((state_val_76051 === (3))){
var inst_76048 = (state_76050[(2)]);
var state_76050__$1 = state_76050;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76050__$1,inst_76048);
} else {
if((state_val_76051 === (2))){
var _ = (function (){var statearr_76056 = state_76050;
(statearr_76056[(4)] = cljs.core.cons((5),(state_76050[(4)])));

return statearr_76056;
})();
var inst_76027 = fluree.db.util.async.channel_QMARK_(num);
var state_76050__$1 = state_76050;
if(inst_76027){
var statearr_76057_76074 = state_76050__$1;
(statearr_76057_76074[(1)] = (6));

} else {
var statearr_76058_76075 = state_76050__$1;
(statearr_76058_76075[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76051 === (9))){
var inst_76030 = (state_76050[(2)]);
var inst_76031 = fluree.db.util.async.throw_err(inst_76030);
var state_76050__$1 = state_76050;
var statearr_76059_76076 = state_76050__$1;
(statearr_76059_76076[(2)] = inst_76031);

(statearr_76059_76076[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76051 === (5))){
var _ = (function (){var statearr_76060 = state_76050;
(statearr_76060[(4)] = cljs.core.rest((state_76050[(4)])));

return statearr_76060;
})();
var state_76050__$1 = state_76050;
var ex76055 = (state_76050__$1[(2)]);
var statearr_76061_76077 = state_76050__$1;
(statearr_76061_76077[(5)] = ex76055);


if((ex76055 instanceof Error)){
var statearr_76062_76078 = state_76050__$1;
(statearr_76062_76078[(1)] = (4));

(statearr_76062_76078[(5)] = null);

} else {
throw ex76055;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76051 === (8))){
var inst_76034 = (state_76050[(2)]);
var inst_76035 = fluree.db.dbfunctions.internal.floor(inst_76034);
var inst_76036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76037 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_76038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76039 = [fluree.db.dbfunctions.fns.floor];
var inst_76040 = (new cljs.core.PersistentVector(null,1,(5),inst_76038,inst_76039,null));
var inst_76041 = ["",inst_76040,inst_76035];
var inst_76042 = cljs.core.PersistentHashMap.fromArrays(inst_76037,inst_76041);
var inst_76043 = [inst_76042,(10)];
var inst_76044 = (new cljs.core.PersistentVector(null,2,(5),inst_76036,inst_76043,null));
var inst_76045 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_76044);
var _ = (function (){var statearr_76063 = state_76050;
(statearr_76063[(4)] = cljs.core.rest((state_76050[(4)])));

return statearr_76063;
})();
var state_76050__$1 = (function (){var statearr_76064 = state_76050;
(statearr_76064[(7)] = inst_76045);

return statearr_76064;
})();
var statearr_76065_76079 = state_76050__$1;
(statearr_76065_76079[(2)] = inst_76035);

(statearr_76065_76079[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__16153__auto____0 = (function (){
var statearr_76066 = [null,null,null,null,null,null,null,null];
(statearr_76066[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__16153__auto__);

(statearr_76066[(1)] = (1));

return statearr_76066;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__16153__auto____1 = (function (state_76050){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_76050);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e76067){var ex__16156__auto__ = e76067;
var statearr_76068_76080 = state_76050;
(statearr_76068_76080[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_76050[(4)]))){
var statearr_76069_76081 = state_76050;
(statearr_76069_76081[(1)] = cljs.core.first((state_76050[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__76082 = state_76050;
state_76050 = G__76082;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__16153__auto__ = function(state_76050){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__16153__auto____1.call(this,state_76050);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_76070 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_76070[(6)] = c__16227__auto__);

return statearr_76070;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_76107){
var state_val_76108 = (state_76107[(1)]);
if((state_val_76108 === (1))){
var state_76107__$1 = state_76107;
var statearr_76109_76124 = state_76107__$1;
(statearr_76109_76124[(2)] = null);

(statearr_76109_76124[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76108 === (2))){
var _ = (function (){var statearr_76110 = state_76107;
(statearr_76110[(4)] = cljs.core.cons((5),(state_76107[(4)])));

return statearr_76110;
})();
var inst_76089 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_76107__$1 = state_76107;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_76107__$1,(6),inst_76089);
} else {
if((state_val_76108 === (3))){
var inst_76105 = (state_76107[(2)]);
var state_76107__$1 = state_76107;
return cljs.core.async.impl.ioc_helpers.return_chan(state_76107__$1,inst_76105);
} else {
if((state_val_76108 === (4))){
var inst_76083 = (state_76107[(2)]);
var state_76107__$1 = state_76107;
var statearr_76112_76125 = state_76107__$1;
(statearr_76112_76125[(2)] = inst_76083);

(statearr_76112_76125[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_76108 === (5))){
var _ = (function (){var statearr_76113 = state_76107;
(statearr_76113[(4)] = cljs.core.rest((state_76107[(4)])));

return statearr_76113;
})();
var state_76107__$1 = state_76107;
var ex76111 = (state_76107__$1[(2)]);
var statearr_76114_76126 = state_76107__$1;
(statearr_76114_76126[(5)] = ex76111);


if((ex76111 instanceof Error)){
var statearr_76115_76127 = state_76107__$1;
(statearr_76115_76127[(1)] = (4));

(statearr_76115_76127[(5)] = null);

} else {
throw ex76111;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_76108 === (6))){
var inst_76091 = (state_76107[(2)]);
var inst_76092 = fluree.db.util.async.throw_err(inst_76091);
var inst_76093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76094 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_76095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_76096 = [compare_val,new_val];
var inst_76097 = (new cljs.core.PersistentVector(null,2,(5),inst_76095,inst_76096,null));
var inst_76098 = ["",inst_76097,inst_76092];
var inst_76099 = cljs.core.PersistentHashMap.fromArrays(inst_76094,inst_76098);
var inst_76100 = [inst_76099,(10)];
var inst_76101 = (new cljs.core.PersistentVector(null,2,(5),inst_76093,inst_76100,null));
var inst_76102 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_76101);
var _ = (function (){var statearr_76116 = state_76107;
(statearr_76116[(4)] = cljs.core.rest((state_76107[(4)])));

return statearr_76116;
})();
var state_76107__$1 = (function (){var statearr_76117 = state_76107;
(statearr_76117[(7)] = inst_76102);

return statearr_76117;
})();
var statearr_76118_76128 = state_76107__$1;
(statearr_76118_76128[(2)] = inst_76092);

(statearr_76118_76128[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__16153__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__16153__auto____0 = (function (){
var statearr_76119 = [null,null,null,null,null,null,null,null];
(statearr_76119[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__16153__auto__);

(statearr_76119[(1)] = (1));

return statearr_76119;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__16153__auto____1 = (function (state_76107){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_76107);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e76120){var ex__16156__auto__ = e76120;
var statearr_76121_76129 = state_76107;
(statearr_76121_76129[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_76107[(4)]))){
var statearr_76122_76130 = state_76107;
(statearr_76122_76130[(1)] = cljs.core.first((state_76107[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__76131 = state_76107;
state_76107 = G__76131;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__16153__auto__ = function(state_76107){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__16153__auto____1.call(this,state_76107);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__16153__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__16153__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_76123 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_76123[(6)] = c__16227__auto__);

return statearr_76123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
