// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__77179_77348 = cljs.core.seq(servers);
var chunk__77180_77349 = null;
var count__77181_77350 = (0);
var i__77182_77351 = (0);
while(true){
if((i__77182_77351 < count__77181_77350)){
var server_77352 = chunk__77180_77349.cljs$core$IIndexed$_nth$arity$2(null,i__77182_77351);
var healthcheck_uri_77353 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_77352),"/fdb/health"].join('');
var resp_chan_77354 = fluree.db.util.xhttp.post_json(healthcheck_uri_77353,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__16227__auto___77355 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__77179_77348,chunk__77180_77349,count__77181_77350,i__77182_77351,c__16227__auto___77355,healthcheck_uri_77353,resp_chan_77354,server_77352){
return (function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = ((function (seq__77179_77348,chunk__77180_77349,count__77181_77350,i__77182_77351,c__16227__auto___77355,healthcheck_uri_77353,resp_chan_77354,server_77352){
return (function (state_77243){
var state_val_77244 = (state_77243[(1)]);
if((state_val_77244 === (1))){
var state_77243__$1 = state_77243;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77243__$1,(2),resp_chan_77354);
} else {
if((state_val_77244 === (2))){
var inst_77232 = (state_77243[(7)]);
var inst_77232__$1 = (state_77243[(2)]);
var inst_77233 = fluree.db.util.core.exception_QMARK_(inst_77232__$1);
var state_77243__$1 = (function (){var statearr_77245 = state_77243;
(statearr_77245[(7)] = inst_77232__$1);

return statearr_77245;
})();
if(inst_77233){
var statearr_77246_77356 = state_77243__$1;
(statearr_77246_77356[(1)] = (3));

} else {
var statearr_77247_77357 = state_77243__$1;
(statearr_77247_77357[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77244 === (3))){
var inst_77232 = (state_77243[(7)]);
var inst_77235 = cljs.core.ex_message(inst_77232);
var inst_77236 = cljs.core.ex_data(inst_77232);
var inst_77237 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_77235,inst_77236], 0));
var state_77243__$1 = state_77243;
var statearr_77248_77358 = state_77243__$1;
(statearr_77248_77358[(2)] = inst_77237);

(statearr_77248_77358[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77244 === (4))){
var inst_77239 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_77352);
var state_77243__$1 = state_77243;
var statearr_77249_77359 = state_77243__$1;
(statearr_77249_77359[(2)] = inst_77239);

(statearr_77249_77359[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77244 === (5))){
var inst_77241 = (state_77243[(2)]);
var state_77243__$1 = state_77243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77243__$1,inst_77241);
} else {
return null;
}
}
}
}
}
});})(seq__77179_77348,chunk__77180_77349,count__77181_77350,i__77182_77351,c__16227__auto___77355,healthcheck_uri_77353,resp_chan_77354,server_77352))
;
return ((function (seq__77179_77348,chunk__77180_77349,count__77181_77350,i__77182_77351,switch__16152__auto__,c__16227__auto___77355,healthcheck_uri_77353,resp_chan_77354,server_77352){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____0 = (function (){
var statearr_77250 = [null,null,null,null,null,null,null,null];
(statearr_77250[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__);

(statearr_77250[(1)] = (1));

return statearr_77250;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____1 = (function (state_77243){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_77243);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e77251){var ex__16156__auto__ = e77251;
var statearr_77252_77360 = state_77243;
(statearr_77252_77360[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_77243[(4)]))){
var statearr_77253_77361 = state_77243;
(statearr_77253_77361[(1)] = cljs.core.first((state_77243[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__77362 = state_77243;
state_77243 = G__77362;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__ = function(state_77243){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____1.call(this,state_77243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__;
})()
;})(seq__77179_77348,chunk__77180_77349,count__77181_77350,i__77182_77351,switch__16152__auto__,c__16227__auto___77355,healthcheck_uri_77353,resp_chan_77354,server_77352))
})();
var state__16229__auto__ = (function (){var statearr_77254 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_77254[(6)] = c__16227__auto___77355);

return statearr_77254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
});})(seq__77179_77348,chunk__77180_77349,count__77181_77350,i__77182_77351,c__16227__auto___77355,healthcheck_uri_77353,resp_chan_77354,server_77352))
);



var G__77363 = seq__77179_77348;
var G__77364 = chunk__77180_77349;
var G__77365 = count__77181_77350;
var G__77366 = (i__77182_77351 + (1));
seq__77179_77348 = G__77363;
chunk__77180_77349 = G__77364;
count__77181_77350 = G__77365;
i__77182_77351 = G__77366;
continue;
} else {
var temp__5753__auto___77367 = cljs.core.seq(seq__77179_77348);
if(temp__5753__auto___77367){
var seq__77179_77368__$1 = temp__5753__auto___77367;
if(cljs.core.chunked_seq_QMARK_(seq__77179_77368__$1)){
var c__4649__auto___77369 = cljs.core.chunk_first(seq__77179_77368__$1);
var G__77370 = cljs.core.chunk_rest(seq__77179_77368__$1);
var G__77371 = c__4649__auto___77369;
var G__77372 = cljs.core.count(c__4649__auto___77369);
var G__77373 = (0);
seq__77179_77348 = G__77370;
chunk__77180_77349 = G__77371;
count__77181_77350 = G__77372;
i__77182_77351 = G__77373;
continue;
} else {
var server_77374 = cljs.core.first(seq__77179_77368__$1);
var healthcheck_uri_77375 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_77374),"/fdb/health"].join('');
var resp_chan_77376 = fluree.db.util.xhttp.post_json(healthcheck_uri_77375,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__16227__auto___77377 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__77179_77348,chunk__77180_77349,count__77181_77350,i__77182_77351,c__16227__auto___77377,healthcheck_uri_77375,resp_chan_77376,server_77374,seq__77179_77368__$1,temp__5753__auto___77367){
return (function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = ((function (seq__77179_77348,chunk__77180_77349,count__77181_77350,i__77182_77351,c__16227__auto___77377,healthcheck_uri_77375,resp_chan_77376,server_77374,seq__77179_77368__$1,temp__5753__auto___77367){
return (function (state_77267){
var state_val_77268 = (state_77267[(1)]);
if((state_val_77268 === (1))){
var state_77267__$1 = state_77267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77267__$1,(2),resp_chan_77376);
} else {
if((state_val_77268 === (2))){
var inst_77256 = (state_77267[(7)]);
var inst_77256__$1 = (state_77267[(2)]);
var inst_77257 = fluree.db.util.core.exception_QMARK_(inst_77256__$1);
var state_77267__$1 = (function (){var statearr_77269 = state_77267;
(statearr_77269[(7)] = inst_77256__$1);

return statearr_77269;
})();
if(inst_77257){
var statearr_77270_77378 = state_77267__$1;
(statearr_77270_77378[(1)] = (3));

} else {
var statearr_77271_77379 = state_77267__$1;
(statearr_77271_77379[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77268 === (3))){
var inst_77256 = (state_77267[(7)]);
var inst_77259 = cljs.core.ex_message(inst_77256);
var inst_77260 = cljs.core.ex_data(inst_77256);
var inst_77261 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_77259,inst_77260], 0));
var state_77267__$1 = state_77267;
var statearr_77272_77380 = state_77267__$1;
(statearr_77272_77380[(2)] = inst_77261);

(statearr_77272_77380[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77268 === (4))){
var inst_77263 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_77374);
var state_77267__$1 = state_77267;
var statearr_77273_77381 = state_77267__$1;
(statearr_77273_77381[(2)] = inst_77263);

(statearr_77273_77381[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77268 === (5))){
var inst_77265 = (state_77267[(2)]);
var state_77267__$1 = state_77267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77267__$1,inst_77265);
} else {
return null;
}
}
}
}
}
});})(seq__77179_77348,chunk__77180_77349,count__77181_77350,i__77182_77351,c__16227__auto___77377,healthcheck_uri_77375,resp_chan_77376,server_77374,seq__77179_77368__$1,temp__5753__auto___77367))
;
return ((function (seq__77179_77348,chunk__77180_77349,count__77181_77350,i__77182_77351,switch__16152__auto__,c__16227__auto___77377,healthcheck_uri_77375,resp_chan_77376,server_77374,seq__77179_77368__$1,temp__5753__auto___77367){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____0 = (function (){
var statearr_77274 = [null,null,null,null,null,null,null,null];
(statearr_77274[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__);

(statearr_77274[(1)] = (1));

return statearr_77274;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____1 = (function (state_77267){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_77267);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e77275){var ex__16156__auto__ = e77275;
var statearr_77276_77382 = state_77267;
(statearr_77276_77382[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_77267[(4)]))){
var statearr_77277_77383 = state_77267;
(statearr_77277_77383[(1)] = cljs.core.first((state_77267[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__77384 = state_77267;
state_77267 = G__77384;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__ = function(state_77267){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____1.call(this,state_77267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__;
})()
;})(seq__77179_77348,chunk__77180_77349,count__77181_77350,i__77182_77351,switch__16152__auto__,c__16227__auto___77377,healthcheck_uri_77375,resp_chan_77376,server_77374,seq__77179_77368__$1,temp__5753__auto___77367))
})();
var state__16229__auto__ = (function (){var statearr_77278 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_77278[(6)] = c__16227__auto___77377);

return statearr_77278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
});})(seq__77179_77348,chunk__77180_77349,count__77181_77350,i__77182_77351,c__16227__auto___77377,healthcheck_uri_77375,resp_chan_77376,server_77374,seq__77179_77368__$1,temp__5753__auto___77367))
);



var G__77385 = cljs.core.next(seq__77179_77368__$1);
var G__77386 = null;
var G__77387 = (0);
var G__77388 = (0);
seq__77179_77348 = G__77385;
chunk__77180_77349 = G__77386;
count__77181_77350 = G__77387;
i__77182_77351 = G__77388;
continue;
}
} else {
}
}
break;
}

var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_77322){
var state_val_77323 = (state_77322[(1)]);
if((state_val_77323 === (7))){
var inst_77294 = (state_77322[(7)]);
var inst_77301 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77294,cljs.core.cst$kw$default);
var state_77322__$1 = state_77322;
if(inst_77301){
var statearr_77324_77389 = state_77322__$1;
(statearr_77324_77389[(1)] = (9));

} else {
var statearr_77325_77390 = state_77322__$1;
(statearr_77325_77390[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77323 === (1))){
var inst_77286 = (state_77322[(8)]);
var inst_77287 = (state_77322[(9)]);
var inst_77286__$1 = promise_chan;
var inst_77287__$1 = cljs.core.async.timeout((60000));
var inst_77288 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77289 = [inst_77286__$1,inst_77287__$1];
var inst_77290 = (new cljs.core.PersistentVector(null,2,(5),inst_77288,inst_77289,null));
var state_77322__$1 = (function (){var statearr_77326 = state_77322;
(statearr_77326[(8)] = inst_77286__$1);

(statearr_77326[(9)] = inst_77287__$1);

return statearr_77326;
})();
return cljs.core.async.ioc_alts_BANG_(state_77322__$1,(2),inst_77290);
} else {
if((state_val_77323 === (4))){
var inst_77287 = (state_77322[(9)]);
var inst_77294 = (state_77322[(7)]);
var inst_77298 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77294,inst_77287);
var state_77322__$1 = state_77322;
if(inst_77298){
var statearr_77327_77391 = state_77322__$1;
(statearr_77327_77391[(1)] = (6));

} else {
var statearr_77328_77392 = state_77322__$1;
(statearr_77328_77392[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77323 === (13))){
var state_77322__$1 = state_77322;
var statearr_77329_77393 = state_77322__$1;
(statearr_77329_77393[(2)] = null);

(statearr_77329_77393[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77323 === (6))){
var state_77322__$1 = state_77322;
var statearr_77330_77394 = state_77322__$1;
(statearr_77330_77394[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_77330_77394[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77323 === (3))){
var state_77322__$1 = state_77322;
var statearr_77331_77395 = state_77322__$1;
(statearr_77331_77395[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_77331_77395[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77323 === (12))){
var inst_77312 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_77313 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_77314 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_77315 = cljs.core.PersistentHashMap.fromArrays(inst_77313,inst_77314);
var inst_77316 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_77315);
var inst_77317 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_77316);
var state_77322__$1 = (function (){var statearr_77332 = state_77322;
(statearr_77332[(10)] = inst_77312);

return statearr_77332;
})();
var statearr_77333_77396 = state_77322__$1;
(statearr_77333_77396[(2)] = inst_77317);

(statearr_77333_77396[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77323 === (2))){
var inst_77286 = (state_77322[(8)]);
var inst_77294 = (state_77322[(7)]);
var inst_77292 = (state_77322[(2)]);
var inst_77293 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77292,(0),null);
var inst_77294__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77292,(1),null);
var inst_77295 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77294__$1,inst_77286);
var state_77322__$1 = (function (){var statearr_77334 = state_77322;
(statearr_77334[(11)] = inst_77293);

(statearr_77334[(7)] = inst_77294__$1);

return statearr_77334;
})();
if(inst_77295){
var statearr_77335_77397 = state_77322__$1;
(statearr_77335_77397[(1)] = (3));

} else {
var statearr_77336_77398 = state_77322__$1;
(statearr_77336_77398[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77323 === (11))){
var inst_77305 = (state_77322[(2)]);
var state_77322__$1 = state_77322;
var statearr_77337_77399 = state_77322__$1;
(statearr_77337_77399[(2)] = inst_77305);

(statearr_77337_77399[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77323 === (9))){
var inst_77293 = (state_77322[(11)]);
var state_77322__$1 = state_77322;
var statearr_77338_77400 = state_77322__$1;
(statearr_77338_77400[(2)] = inst_77293);

(statearr_77338_77400[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77323 === (5))){
var inst_77309 = (state_77322[(2)]);
var inst_77310 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_77309);
var state_77322__$1 = state_77322;
if(inst_77310){
var statearr_77339_77401 = state_77322__$1;
(statearr_77339_77401[(1)] = (12));

} else {
var statearr_77340_77402 = state_77322__$1;
(statearr_77340_77402[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77323 === (14))){
var inst_77320 = (state_77322[(2)]);
var state_77322__$1 = state_77322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77322__$1,inst_77320);
} else {
if((state_val_77323 === (10))){
var state_77322__$1 = state_77322;
var statearr_77341_77403 = state_77322__$1;
(statearr_77341_77403[(2)] = null);

(statearr_77341_77403[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77323 === (8))){
var inst_77307 = (state_77322[(2)]);
var state_77322__$1 = state_77322;
var statearr_77342_77404 = state_77322__$1;
(statearr_77342_77404[(2)] = inst_77307);

(statearr_77342_77404[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____0 = (function (){
var statearr_77343 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77343[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__);

(statearr_77343[(1)] = (1));

return statearr_77343;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____1 = (function (state_77322){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_77322);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e77344){var ex__16156__auto__ = e77344;
var statearr_77345_77405 = state_77322;
(statearr_77345_77405[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_77322[(4)]))){
var statearr_77346_77406 = state_77322;
(statearr_77346_77406[(1)] = cljs.core.first((state_77322[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__77407 = state_77322;
state_77322 = G__77407;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__ = function(state_77322){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____1.call(this,state_77322);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_77347 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_77347[(6)] = c__16227__auto__);

return statearr_77347;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_77451){
var state_val_77452 = (state_77451[(1)]);
if((state_val_77452 === (7))){
var state_77451__$1 = state_77451;
var statearr_77453_77479 = state_77451__$1;
(statearr_77453_77479[(2)] = null);

(statearr_77453_77479[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77452 === (1))){
var state_77451__$1 = state_77451;
var statearr_77454_77480 = state_77451__$1;
(statearr_77454_77480[(2)] = null);

(statearr_77454_77480[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77452 === (4))){
var inst_77408 = (state_77451[(2)]);
var state_77451__$1 = state_77451;
var statearr_77455_77481 = state_77451__$1;
(statearr_77455_77481[(2)] = inst_77408);

(statearr_77455_77481[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77452 === (6))){
var inst_77430 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_77451__$1 = state_77451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77451__$1,(9),inst_77430);
} else {
if((state_val_77452 === (3))){
var inst_77449 = (state_77451[(2)]);
var state_77451__$1 = state_77451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77451__$1,inst_77449);
} else {
if((state_val_77452 === (12))){
var inst_77443 = (state_77451[(2)]);
var state_77451__$1 = state_77451;
var statearr_77456_77482 = state_77451__$1;
(statearr_77456_77482[(2)] = inst_77443);

(statearr_77456_77482[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77452 === (2))){
var inst_77424 = (state_77451[(7)]);
var inst_77419 = (state_77451[(8)]);
var inst_77414 = (state_77451[(9)]);
var _ = (function (){var statearr_77457 = state_77451;
(statearr_77457[(4)] = cljs.core.cons((5),(state_77451[(4)])));

return statearr_77457;
})();
var inst_77414__$1 = fluree.db.util.core.random_uuid();
var inst_77415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77416 = [conn_id,cljs.core.cst$kw$ws];
var inst_77417 = (new cljs.core.PersistentVector(null,2,(5),inst_77415,inst_77416,null));
var inst_77418 = (function (){var lock_id = inst_77414__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_77419__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_77417,inst_77418);
var inst_77420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77421 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_77422 = (new cljs.core.PersistentVector(null,3,(5),inst_77420,inst_77421,null));
var inst_77423 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_77419__$1,inst_77422);
var inst_77424__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77414__$1,inst_77423);
var inst_77425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77426 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_77427 = (new cljs.core.PersistentVector(null,3,(5),inst_77425,inst_77426,null));
var inst_77428 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_77419__$1,inst_77427);
var state_77451__$1 = (function (){var statearr_77458 = state_77451;
(statearr_77458[(7)] = inst_77424__$1);

(statearr_77458[(8)] = inst_77419__$1);

(statearr_77458[(10)] = inst_77428);

(statearr_77458[(9)] = inst_77414__$1);

return statearr_77458;
})();
if(inst_77424__$1){
var statearr_77459_77483 = state_77451__$1;
(statearr_77459_77483[(1)] = (6));

} else {
var statearr_77460_77484 = state_77451__$1;
(statearr_77460_77484[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77452 === (11))){
var inst_77428 = (state_77451[(10)]);
var inst_77435 = (state_77451[(11)]);
var inst_77434 = (state_77451[(12)]);
var inst_77441 = fluree.db.util.xhttp.try_socket(inst_77434,sub_chan,pub_chan,inst_77428,(60000),inst_77435);
var state_77451__$1 = state_77451;
var statearr_77462_77485 = state_77451__$1;
(statearr_77462_77485[(2)] = inst_77441);

(statearr_77462_77485[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77452 === (9))){
var inst_77432 = (state_77451[(13)]);
var inst_77424 = (state_77451[(7)]);
var inst_77419 = (state_77451[(8)]);
var inst_77428 = (state_77451[(10)]);
var inst_77414 = (state_77451[(9)]);
var inst_77434 = (state_77451[(12)]);
var inst_77432__$1 = (state_77451[(2)]);
var inst_77433 = clojure.string.replace(inst_77432__$1,"http","ws");
var inst_77434__$1 = [inst_77433,"/fdb/ws"].join('');
var inst_77435 = (function (){var lock_id = inst_77414;
var state = inst_77419;
var have_lock_QMARK_ = inst_77424;
var resp_chan = inst_77428;
var healthy_server = inst_77432__$1;
var ws_url = inst_77434__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_77436 = fluree.db.util.core.exception_QMARK_(inst_77432__$1);
var state_77451__$1 = (function (){var statearr_77463 = state_77451;
(statearr_77463[(13)] = inst_77432__$1);

(statearr_77463[(11)] = inst_77435);

(statearr_77463[(12)] = inst_77434__$1);

return statearr_77463;
})();
if(inst_77436){
var statearr_77464_77486 = state_77451__$1;
(statearr_77464_77486[(1)] = (10));

} else {
var statearr_77465_77487 = state_77451__$1;
(statearr_77465_77487[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77452 === (5))){
var _ = (function (){var statearr_77466 = state_77451;
(statearr_77466[(4)] = cljs.core.rest((state_77451[(4)])));

return statearr_77466;
})();
var state_77451__$1 = state_77451;
var ex77461 = (state_77451__$1[(2)]);
var statearr_77467_77488 = state_77451__$1;
(statearr_77467_77488[(5)] = ex77461);


if((ex77461 instanceof Error)){
var statearr_77468_77489 = state_77451__$1;
(statearr_77468_77489[(1)] = (4));

(statearr_77468_77489[(5)] = null);

} else {
throw ex77461;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77452 === (10))){
var inst_77432 = (state_77451[(13)]);
var inst_77428 = (state_77451[(10)]);
var inst_77438 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_77439 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_77428,inst_77432);
var state_77451__$1 = (function (){var statearr_77469 = state_77451;
(statearr_77469[(14)] = inst_77438);

return statearr_77469;
})();
var statearr_77470_77490 = state_77451__$1;
(statearr_77470_77490[(2)] = inst_77439);

(statearr_77470_77490[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77452 === (8))){
var inst_77428 = (state_77451[(10)]);
var inst_77446 = (state_77451[(2)]);
var _ = (function (){var statearr_77471 = state_77451;
(statearr_77471[(4)] = cljs.core.rest((state_77451[(4)])));

return statearr_77471;
})();
var state_77451__$1 = (function (){var statearr_77472 = state_77451;
(statearr_77472[(15)] = inst_77446);

return statearr_77472;
})();
var statearr_77473_77491 = state_77451__$1;
(statearr_77473_77491[(2)] = inst_77428);

(statearr_77473_77491[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__16153__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__16153__auto____0 = (function (){
var statearr_77474 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77474[(0)] = fluree$db$connection$establish_socket_$_state_machine__16153__auto__);

(statearr_77474[(1)] = (1));

return statearr_77474;
});
var fluree$db$connection$establish_socket_$_state_machine__16153__auto____1 = (function (state_77451){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_77451);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e77475){var ex__16156__auto__ = e77475;
var statearr_77476_77492 = state_77451;
(statearr_77476_77492[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_77451[(4)]))){
var statearr_77477_77493 = state_77451;
(statearr_77477_77493[(1)] = cljs.core.first((state_77451[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__77494 = state_77451;
state_77451 = G__77494;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__16153__auto__ = function(state_77451){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__16153__auto____1.call(this,state_77451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__16153__auto____0;
fluree$db$connection$establish_socket_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__16153__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_77478 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_77478[(6)] = c__16227__auto__);

return statearr_77478;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k77496,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__77500 = k77496;
var G__77500__$1 = (((G__77500 instanceof cljs.core.Keyword))?G__77500.fqn:null);
switch (G__77500__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k77496,else__4475__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__77501){
var vec__77502 = p__77501;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__77502,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__77502,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__77495){
var self__ = this;
var G__77495__$1 = this;
return (new cljs.core.RecordIter((0),G__77495__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__77505 = (function (coll__4469__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__77505(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this77497,other77498){
var self__ = this;
var this77497__$1 = this;
return (((!((other77498 == null)))) && ((((this77497__$1.constructor === other77498.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.id,other77498.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.servers,other77498.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.state,other77498.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.req_chan,other77498.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.sub_chan,other77498.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.pub_chan,other77498.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.storage_read,other77498.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.storage_write,other77498.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.object_cache,other77498.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.parallelism,other77498.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.serializer,other77498.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.default_network,other77498.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.transactor_QMARK_,other77498.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.publish,other77498.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.transact_handler,other77498.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.tx_private_key,other77498.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.tx_key_id,other77498.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.meta,other77498.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.add_listener,other77498.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.remove_listener,other77498.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.close,other77498.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this77497__$1.__extmap,other77498.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k77496){
var self__ = this;
var this__4479__auto____$1 = this;
var G__77506 = k77496;
var G__77506__$1 = (((G__77506 instanceof cljs.core.Keyword))?G__77506.fqn:null);
switch (G__77506__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k77496);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__77495){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__77507 = cljs.core.keyword_identical_QMARK_;
var expr__77508 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__77510 = cljs.core.cst$kw$id;
var G__77511 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77510,G__77511) : pred__77507.call(null,G__77510,G__77511));
})())){
return (new fluree.db.connection.Connection(G__77495,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77512 = cljs.core.cst$kw$servers;
var G__77513 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77512,G__77513) : pred__77507.call(null,G__77512,G__77513));
})())){
return (new fluree.db.connection.Connection(self__.id,G__77495,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77514 = cljs.core.cst$kw$state;
var G__77515 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77514,G__77515) : pred__77507.call(null,G__77514,G__77515));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__77495,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77516 = cljs.core.cst$kw$req_DASH_chan;
var G__77517 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77516,G__77517) : pred__77507.call(null,G__77516,G__77517));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__77495,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77518 = cljs.core.cst$kw$sub_DASH_chan;
var G__77519 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77518,G__77519) : pred__77507.call(null,G__77518,G__77519));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__77495,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77520 = cljs.core.cst$kw$pub_DASH_chan;
var G__77521 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77520,G__77521) : pred__77507.call(null,G__77520,G__77521));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__77495,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77522 = cljs.core.cst$kw$storage_DASH_read;
var G__77523 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77522,G__77523) : pred__77507.call(null,G__77522,G__77523));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__77495,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77524 = cljs.core.cst$kw$storage_DASH_write;
var G__77525 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77524,G__77525) : pred__77507.call(null,G__77524,G__77525));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__77495,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77526 = cljs.core.cst$kw$object_DASH_cache;
var G__77527 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77526,G__77527) : pred__77507.call(null,G__77526,G__77527));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__77495,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77528 = cljs.core.cst$kw$parallelism;
var G__77529 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77528,G__77529) : pred__77507.call(null,G__77528,G__77529));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__77495,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77530 = cljs.core.cst$kw$serializer;
var G__77531 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77530,G__77531) : pred__77507.call(null,G__77530,G__77531));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__77495,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77532 = cljs.core.cst$kw$default_DASH_network;
var G__77533 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77532,G__77533) : pred__77507.call(null,G__77532,G__77533));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__77495,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77534 = cljs.core.cst$kw$transactor_QMARK_;
var G__77535 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77534,G__77535) : pred__77507.call(null,G__77534,G__77535));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__77495,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77536 = cljs.core.cst$kw$publish;
var G__77537 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77536,G__77537) : pred__77507.call(null,G__77536,G__77537));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__77495,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77538 = cljs.core.cst$kw$transact_DASH_handler;
var G__77539 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77538,G__77539) : pred__77507.call(null,G__77538,G__77539));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__77495,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77540 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__77541 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77540,G__77541) : pred__77507.call(null,G__77540,G__77541));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__77495,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77542 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__77543 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77542,G__77543) : pred__77507.call(null,G__77542,G__77543));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__77495,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77544 = cljs.core.cst$kw$meta;
var G__77545 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77544,G__77545) : pred__77507.call(null,G__77544,G__77545));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__77495,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77546 = cljs.core.cst$kw$add_DASH_listener;
var G__77547 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77546,G__77547) : pred__77507.call(null,G__77546,G__77547));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__77495,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77548 = cljs.core.cst$kw$remove_DASH_listener;
var G__77549 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77548,G__77549) : pred__77507.call(null,G__77548,G__77549));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__77495,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__77550 = cljs.core.cst$kw$close;
var G__77551 = expr__77508;
return (pred__77507.cljs$core$IFn$_invoke$arity$2 ? pred__77507.cljs$core$IFn$_invoke$arity$2(G__77550,G__77551) : pred__77507.call(null,G__77550,G__77551));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__77495,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__77495),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__77495){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__77495,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__77499){
var extmap__4512__auto__ = (function (){var G__77552 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__77499,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__77499)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__77552);
} else {
return G__77552;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__77499),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__77499),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__77558 = servers_STAR_;
var vec__77559 = G__77558;
var seq__77560 = cljs.core.seq(vec__77559);
var first__77561 = cljs.core.first(seq__77560);
var seq__77560__$1 = cljs.core.next(seq__77560);
var server = first__77561;
var r = seq__77560__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__77558__$1 = G__77558;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__77565 = G__77558__$1;
var seq__77566 = cljs.core.seq(vec__77565);
var first__77567 = cljs.core.first(seq__77566);
var seq__77566__$1 = cljs.core.next(seq__77566);
var server__$1 = first__77567;
var r__$1 = seq__77566__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__4221__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__77568 = r__$1;
var G__77569 = is_https_QMARK_;
var G__77570 = result_STAR_;
G__77558__$1 = G__77568;
https_QMARK___$1 = G__77569;
result__$1 = G__77570;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__77571 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__77571 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__77571);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_77600){
var state_val_77601 = (state_77600[(1)]);
if((state_val_77601 === (7))){
var inst_77586 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_77587 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_77588 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_77589 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_77590 = fluree.db.connection.establish_socket(inst_77586,inst_77587,inst_77588,inst_77589);
var state_77600__$1 = state_77600;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77600__$1,(9),inst_77590);
} else {
if((state_val_77601 === (1))){
var state_77600__$1 = state_77600;
var statearr_77602_77621 = state_77600__$1;
(statearr_77602_77621[(2)] = null);

(statearr_77602_77621[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77601 === (4))){
var inst_77572 = (state_77600[(2)]);
var state_77600__$1 = state_77600;
var statearr_77603_77622 = state_77600__$1;
(statearr_77603_77622[(2)] = inst_77572);

(statearr_77603_77622[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77601 === (6))){
var inst_77583 = (state_77600[(7)]);
var state_77600__$1 = state_77600;
var statearr_77604_77623 = state_77600__$1;
(statearr_77604_77623[(2)] = inst_77583);

(statearr_77604_77623[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77601 === (3))){
var inst_77598 = (state_77600[(2)]);
var state_77600__$1 = state_77600;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77600__$1,inst_77598);
} else {
if((state_val_77601 === (2))){
var inst_77583 = (state_77600[(7)]);
var _ = (function (){var statearr_77606 = state_77600;
(statearr_77606[(4)] = cljs.core.cons((5),(state_77600[(4)])));

return statearr_77606;
})();
var inst_77578 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_77579 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77580 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_77581 = [inst_77580,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_77582 = (new cljs.core.PersistentVector(null,3,(5),inst_77579,inst_77581,null));
var inst_77583__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_77578,inst_77582);
var state_77600__$1 = (function (){var statearr_77607 = state_77600;
(statearr_77607[(7)] = inst_77583__$1);

return statearr_77607;
})();
if(cljs.core.truth_(inst_77583__$1)){
var statearr_77608_77624 = state_77600__$1;
(statearr_77608_77624[(1)] = (6));

} else {
var statearr_77609_77625 = state_77600__$1;
(statearr_77609_77625[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77601 === (9))){
var inst_77592 = (state_77600[(2)]);
var inst_77593 = fluree.db.util.async.throw_err(inst_77592);
var state_77600__$1 = state_77600;
var statearr_77610_77626 = state_77600__$1;
(statearr_77610_77626[(2)] = inst_77593);

(statearr_77610_77626[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77601 === (5))){
var _ = (function (){var statearr_77611 = state_77600;
(statearr_77611[(4)] = cljs.core.rest((state_77600[(4)])));

return statearr_77611;
})();
var state_77600__$1 = state_77600;
var ex77605 = (state_77600__$1[(2)]);
var statearr_77612_77627 = state_77600__$1;
(statearr_77612_77627[(5)] = ex77605);


if((ex77605 instanceof Error)){
var statearr_77613_77628 = state_77600__$1;
(statearr_77613_77628[(1)] = (4));

(statearr_77613_77628[(5)] = null);

} else {
throw ex77605;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77601 === (8))){
var inst_77595 = (state_77600[(2)]);
var _ = (function (){var statearr_77614 = state_77600;
(statearr_77614[(4)] = cljs.core.rest((state_77600[(4)])));

return statearr_77614;
})();
var state_77600__$1 = state_77600;
var statearr_77615_77629 = state_77600__$1;
(statearr_77615_77629[(2)] = inst_77595);

(statearr_77615_77629[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__16153__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__16153__auto____0 = (function (){
var statearr_77616 = [null,null,null,null,null,null,null,null];
(statearr_77616[(0)] = fluree$db$connection$get_socket_$_state_machine__16153__auto__);

(statearr_77616[(1)] = (1));

return statearr_77616;
});
var fluree$db$connection$get_socket_$_state_machine__16153__auto____1 = (function (state_77600){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_77600);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e77617){var ex__16156__auto__ = e77617;
var statearr_77618_77630 = state_77600;
(statearr_77618_77630[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_77600[(4)]))){
var statearr_77619_77631 = state_77600;
(statearr_77619_77631[(1)] = cljs.core.first((state_77600[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__77632 = state_77600;
state_77600 = G__77632;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__16153__auto__ = function(state_77600){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__16153__auto____1.call(this,state_77600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__16153__auto____0;
fluree$db$connection$get_socket_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__16153__auto____1;
return fluree$db$connection$get_socket_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_77620 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_77620[(6)] = c__16227__auto__);

return statearr_77620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e77633){var e = e77633;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4223__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_77760){
var state_val_77761 = (state_77760[(1)]);
if((state_val_77761 === (7))){
var inst_77756 = (state_77760[(2)]);
var state_77760__$1 = state_77760;
var statearr_77763_77833 = state_77760__$1;
(statearr_77763_77833[(2)] = inst_77756);

(statearr_77763_77833[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (20))){
var _ = (function (){var statearr_77764 = state_77760;
(statearr_77764[(4)] = cljs.core.rest((state_77760[(4)])));

return statearr_77764;
})();
var state_77760__$1 = state_77760;
var ex77762 = (state_77760__$1[(2)]);
var statearr_77765_77834 = state_77760__$1;
(statearr_77765_77834[(5)] = ex77762);


var statearr_77766_77835 = state_77760__$1;
(statearr_77766_77835[(1)] = (10));

(statearr_77766_77835[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (27))){
var inst_77748 = (state_77760[(2)]);
var _ = (function (){var statearr_77767 = state_77760;
(statearr_77767[(4)] = cljs.core.rest((state_77760[(4)])));

return statearr_77767;
})();
var state_77760__$1 = state_77760;
var statearr_77768_77836 = state_77760__$1;
(statearr_77768_77836[(2)] = inst_77748);

(statearr_77768_77836[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (1))){
var inst_77635 = (0);
var state_77760__$1 = (function (){var statearr_77769 = state_77760;
(statearr_77769[(7)] = inst_77635);

return statearr_77769;
})();
var statearr_77770_77837 = state_77760__$1;
(statearr_77770_77837[(2)] = null);

(statearr_77770_77837[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (24))){
var inst_77726 = (state_77760[(8)]);
var inst_77726__$1 = (state_77760[(2)]);
var inst_77727 = inst_77726__$1 === true;
var state_77760__$1 = (function (){var statearr_77771 = state_77760;
(statearr_77771[(8)] = inst_77726__$1);

return statearr_77771;
})();
if(cljs.core.truth_(inst_77727)){
var statearr_77772_77838 = state_77760__$1;
(statearr_77772_77838[(1)] = (25));

} else {
var statearr_77773_77839 = state_77760__$1;
(statearr_77773_77839[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (4))){
var inst_77638 = (state_77760[(9)]);
var inst_77638__$1 = (state_77760[(2)]);
var state_77760__$1 = (function (){var statearr_77774 = state_77760;
(statearr_77774[(9)] = inst_77638__$1);

return statearr_77774;
})();
if(cljs.core.truth_(inst_77638__$1)){
var statearr_77775_77840 = state_77760__$1;
(statearr_77775_77840[(1)] = (5));

} else {
var statearr_77776_77841 = state_77760__$1;
(statearr_77776_77841[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (15))){
var inst_77651 = (state_77760[(10)]);
var state_77760__$1 = state_77760;
var statearr_77777_77842 = state_77760__$1;
(statearr_77777_77842[(2)] = inst_77651);

(statearr_77777_77842[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (21))){
var inst_77674 = (state_77760[(11)]);
var inst_77683 = (state_77760[(12)]);
var inst_77678 = (state_77760[(13)]);
var inst_77677 = (state_77760[(14)]);
var inst_77635 = (state_77760[(7)]);
var inst_77638 = (state_77760[(9)]);
var inst_77682 = (state_77760[(15)]);
var inst_77676 = (state_77760[(16)]);
var inst_77675 = (state_77760[(17)]);
var inst_77679 = (state_77760[(18)]);
var inst_77685 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77686 = [cljs.core.cst$kw$pending_DASH_req,inst_77682];
var inst_77687 = (new cljs.core.PersistentVector(null,2,(5),inst_77685,inst_77686,null));
var inst_77688 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_77687,inst_77677);
var inst_77715 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_77716 = (function (){var resp_chan = inst_77677;
var timeout = inst_77683;
var i = inst_77635;
var data = inst_77676;
var _ = inst_77674;
var req_id = inst_77682;
var operation = inst_77675;
var c__16227__auto____$1 = inst_77715;
var map__77673 = inst_77679;
var msg = inst_77638;
var vec__77670 = inst_77638;
var opts = inst_77678;
return (function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_77713){
var state_val_77714 = (state_77713[(1)]);
if((state_val_77714 === (1))){
var inst_77692 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77693 = cljs.core.async.timeout(timeout);
var inst_77694 = [resp_chan,inst_77693];
var inst_77695 = (new cljs.core.PersistentVector(null,2,(5),inst_77692,inst_77694,null));
var state_77713__$1 = state_77713;
return cljs.core.async.ioc_alts_BANG_(state_77713__$1,(2),inst_77695);
} else {
if((state_val_77714 === (2))){
var inst_77698 = (state_77713[(7)]);
var inst_77697 = (state_77713[(2)]);
var inst_77698__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77697,(0),null);
var inst_77699 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77697,(1),null);
var inst_77700 = (function (){var vec__77689 = inst_77697;
var resp = inst_77698__$1;
var c = inst_77699;
return (function (p1__77634_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__77634_SHARP_,req_id);
});
})();
var inst_77701 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_77700);
var inst_77702 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77699,resp_chan);
var state_77713__$1 = (function (){var statearr_77778 = state_77713;
(statearr_77778[(7)] = inst_77698__$1);

(statearr_77778[(8)] = inst_77701);

return statearr_77778;
})();
if(inst_77702){
var statearr_77779_77843 = state_77713__$1;
(statearr_77779_77843[(1)] = (3));

} else {
var statearr_77780_77844 = state_77713__$1;
(statearr_77780_77844[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77714 === (3))){
var inst_77698 = (state_77713[(7)]);
var state_77713__$1 = state_77713;
var statearr_77781_77845 = state_77713__$1;
(statearr_77781_77845[(2)] = inst_77698);

(statearr_77781_77845[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77714 === (4))){
var inst_77705 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_77706 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_77707 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_77708 = cljs.core.PersistentHashMap.fromArrays(inst_77706,inst_77707);
var inst_77709 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_77705,inst_77708);
var state_77713__$1 = state_77713;
var statearr_77782_77846 = state_77713__$1;
(statearr_77782_77846[(2)] = inst_77709);

(statearr_77782_77846[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77714 === (5))){
var inst_77711 = (state_77713[(2)]);
var state_77713__$1 = state_77713;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77713__$1,inst_77711);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__16153__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__16153__auto____0 = (function (){
var statearr_77783 = [null,null,null,null,null,null,null,null,null];
(statearr_77783[(0)] = fluree$db$connection$msg_producer_$_state_machine__16153__auto__);

(statearr_77783[(1)] = (1));

return statearr_77783;
});
var fluree$db$connection$msg_producer_$_state_machine__16153__auto____1 = (function (state_77713){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_77713);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e77784){var ex__16156__auto__ = e77784;
var statearr_77785_77847 = state_77713;
(statearr_77785_77847[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_77713[(4)]))){
var statearr_77786_77848 = state_77713;
(statearr_77786_77848[(1)] = cljs.core.first((state_77713[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__77849 = state_77713;
state_77713 = G__77849;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__16153__auto__ = function(state_77713){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__16153__auto____1.call(this,state_77713);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__16153__auto____0;
fluree$db$connection$msg_producer_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__16153__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_77787 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_77787[(6)] = c__16227__auto____$1);

return statearr_77787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
});
})();
var inst_77717 = cljs.core.async.impl.dispatch.run(inst_77716);
var state_77760__$1 = (function (){var statearr_77788 = state_77760;
(statearr_77788[(19)] = inst_77717);

(statearr_77788[(20)] = inst_77688);

return statearr_77788;
})();
var statearr_77789_77850 = state_77760__$1;
(statearr_77789_77850[(2)] = inst_77715);

(statearr_77789_77850[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (31))){
var inst_77736 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_77760__$1 = state_77760;
var statearr_77790_77851 = state_77760__$1;
(statearr_77790_77851[(2)] = inst_77736);

(statearr_77790_77851[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (32))){
var state_77760__$1 = state_77760;
var statearr_77791_77852 = state_77760__$1;
(statearr_77791_77852[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (33))){
var inst_77744 = (state_77760[(2)]);
var state_77760__$1 = state_77760;
var statearr_77793_77853 = state_77760__$1;
(statearr_77793_77853[(2)] = inst_77744);

(statearr_77793_77853[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (13))){
var inst_77651 = (state_77760[(10)]);
var inst_77648 = (state_77760[(2)]);
var inst_77649 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77648,(0),null);
var inst_77650 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77648,(1),null);
var inst_77651__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77648,(2),null);
var state_77760__$1 = (function (){var statearr_77794 = state_77760;
(statearr_77794[(21)] = inst_77649);

(statearr_77794[(10)] = inst_77651__$1);

(statearr_77794[(22)] = inst_77650);

return statearr_77794;
})();
if(cljs.core.truth_(inst_77651__$1)){
var statearr_77795_77854 = state_77760__$1;
(statearr_77795_77854[(1)] = (14));

} else {
var statearr_77796_77855 = state_77760__$1;
(statearr_77796_77855[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (22))){
var state_77760__$1 = state_77760;
var statearr_77797_77856 = state_77760__$1;
(statearr_77797_77856[(2)] = null);

(statearr_77797_77856[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (36))){
var inst_77742 = (state_77760[(2)]);
var state_77760__$1 = state_77760;
var statearr_77798_77857 = state_77760__$1;
(statearr_77798_77857[(2)] = inst_77742);

(statearr_77798_77857[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (29))){
var inst_77726 = (state_77760[(8)]);
var inst_77734 = (inst_77726 == null);
var state_77760__$1 = state_77760;
if(cljs.core.truth_(inst_77734)){
var statearr_77799_77858 = state_77760__$1;
(statearr_77799_77858[(1)] = (31));

} else {
var statearr_77800_77859 = state_77760__$1;
(statearr_77800_77859[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (6))){
var state_77760__$1 = state_77760;
var statearr_77801_77860 = state_77760__$1;
(statearr_77801_77860[(2)] = null);

(statearr_77801_77860[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (28))){
var inst_77726 = (state_77760[(8)]);
var inst_77732 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_77726,"Error processing message in producer."], 0));
var state_77760__$1 = state_77760;
var statearr_77802_77861 = state_77760__$1;
(statearr_77802_77861[(2)] = inst_77732);

(statearr_77802_77861[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (25))){
var state_77760__$1 = state_77760;
var statearr_77803_77862 = state_77760__$1;
(statearr_77803_77862[(2)] = null);

(statearr_77803_77862[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (34))){
var inst_77726 = (state_77760[(8)]);
var inst_77739 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_77726], 0));
var state_77760__$1 = state_77760;
var statearr_77804_77863 = state_77760__$1;
(statearr_77804_77863[(2)] = inst_77739);

(statearr_77804_77863[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (17))){
var inst_77640 = (state_77760[(23)]);
var inst_77651 = (state_77760[(10)]);
var inst_77658 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_77651,inst_77640);
var state_77760__$1 = state_77760;
var statearr_77805_77864 = state_77760__$1;
(statearr_77805_77864[(2)] = inst_77658);

(statearr_77805_77864[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (3))){
var inst_77758 = (state_77760[(2)]);
var state_77760__$1 = state_77760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77760__$1,inst_77758);
} else {
if((state_val_77761 === (12))){
var state_77760__$1 = state_77760;
var statearr_77806_77865 = state_77760__$1;
(statearr_77806_77865[(2)] = null);

(statearr_77806_77865[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (2))){
var state_77760__$1 = state_77760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77760__$1,(4),req_chan);
} else {
if((state_val_77761 === (23))){
var inst_77682 = (state_77760[(15)]);
var inst_77676 = (state_77760[(16)]);
var inst_77675 = (state_77760[(17)]);
var inst_77720 = (state_77760[(2)]);
var inst_77721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77722 = [inst_77675,inst_77682,inst_77676];
var inst_77723 = (new cljs.core.PersistentVector(null,3,(5),inst_77721,inst_77722,null));
var inst_77724 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_77723) : publish_fn.call(null,conn,inst_77723));
var state_77760__$1 = (function (){var statearr_77807 = state_77760;
(statearr_77807[(24)] = inst_77720);

return statearr_77807;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_77760__$1,(24),inst_77724);
} else {
if((state_val_77761 === (35))){
var state_77760__$1 = state_77760;
var statearr_77808_77866 = state_77760__$1;
(statearr_77808_77866[(2)] = null);

(statearr_77808_77866[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (19))){
var inst_77664 = (state_77760[(2)]);
var state_77760__$1 = state_77760;
var statearr_77809_77867 = state_77760__$1;
(statearr_77809_77867[(2)] = inst_77664);

(statearr_77809_77867[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (11))){
var inst_77638 = (state_77760[(9)]);
var state_77760__$1 = state_77760;
var statearr_77810_77868 = state_77760__$1;
(statearr_77810_77868[(2)] = inst_77638);

(statearr_77810_77868[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (9))){
var inst_77635 = (state_77760[(7)]);
var inst_77751 = (state_77760[(2)]);
var inst_77752 = (inst_77635 + (1));
var inst_77635__$1 = inst_77752;
var state_77760__$1 = (function (){var statearr_77811 = state_77760;
(statearr_77811[(7)] = inst_77635__$1);

(statearr_77811[(25)] = inst_77751);

return statearr_77811;
})();
var statearr_77812_77869 = state_77760__$1;
(statearr_77812_77869[(2)] = null);

(statearr_77812_77869[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (5))){
var state_77760__$1 = state_77760;
var statearr_77813_77870 = state_77760__$1;
(statearr_77813_77870[(2)] = null);

(statearr_77813_77870[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (14))){
var inst_77651 = (state_77760[(10)]);
var inst_77653 = fluree.db.util.async.channel_QMARK_(inst_77651);
var state_77760__$1 = state_77760;
var statearr_77814_77871 = state_77760__$1;
(statearr_77814_77871[(2)] = inst_77653);

(statearr_77814_77871[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (26))){
var inst_77726 = (state_77760[(8)]);
var inst_77730 = fluree.db.util.core.exception_QMARK_(inst_77726);
var state_77760__$1 = state_77760;
if(inst_77730){
var statearr_77815_77872 = state_77760__$1;
(statearr_77815_77872[(1)] = (28));

} else {
var statearr_77816_77873 = state_77760__$1;
(statearr_77816_77873[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (16))){
var inst_77656 = (state_77760[(2)]);
var state_77760__$1 = state_77760;
if(cljs.core.truth_(inst_77656)){
var statearr_77817_77874 = state_77760__$1;
(statearr_77817_77874[(1)] = (17));

} else {
var statearr_77818_77875 = state_77760__$1;
(statearr_77818_77875[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (30))){
var inst_77746 = (state_77760[(2)]);
var state_77760__$1 = state_77760;
var statearr_77819_77876 = state_77760__$1;
(statearr_77819_77876[(2)] = inst_77746);

(statearr_77819_77876[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (10))){
var inst_77638 = (state_77760[(9)]);
var inst_77640 = (state_77760[(2)]);
var inst_77644 = cljs.core.sequential_QMARK_(inst_77638);
var state_77760__$1 = (function (){var statearr_77820 = state_77760;
(statearr_77820[(23)] = inst_77640);

return statearr_77820;
})();
if(inst_77644){
var statearr_77821_77877 = state_77760__$1;
(statearr_77821_77877[(1)] = (11));

} else {
var statearr_77822_77878 = state_77760__$1;
(statearr_77822_77878[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (18))){
var inst_77640 = (state_77760[(23)]);
var inst_77638 = (state_77760[(9)]);
var inst_77660 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_77638], 0));
var inst_77661 = ["Error processing ledger request, no valid return channel: ",inst_77660].join('');
var inst_77662 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_77640,inst_77661], 0));
var state_77760__$1 = state_77760;
var statearr_77823_77879 = state_77760__$1;
(statearr_77823_77879[(2)] = inst_77662);

(statearr_77823_77879[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77761 === (8))){
var inst_77678 = (state_77760[(13)]);
var inst_77677 = (state_77760[(14)]);
var inst_77638 = (state_77760[(9)]);
var inst_77679 = (state_77760[(18)]);
var _ = (function (){var statearr_77824 = state_77760;
(statearr_77824[(4)] = cljs.core.cons((20),(state_77760[(4)])));

return statearr_77824;
})();
var inst_77674 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_77638], 0));
var inst_77675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77638,(0),null);
var inst_77676 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77638,(1),null);
var inst_77677__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77638,(2),null);
var inst_77678__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77638,(3),null);
var inst_77679__$1 = cljs.core.__destructure_map(inst_77678__$1);
var inst_77680 = fluree.db.util.core.random_uuid();
var inst_77681 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_77680);
var inst_77682 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_77679__$1,cljs.core.cst$kw$req_DASH_id,inst_77681);
var inst_77683 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_77679__$1,cljs.core.cst$kw$timeout,(60000));
var state_77760__$1 = (function (){var statearr_77825 = state_77760;
(statearr_77825[(11)] = inst_77674);

(statearr_77825[(12)] = inst_77683);

(statearr_77825[(13)] = inst_77678__$1);

(statearr_77825[(14)] = inst_77677__$1);

(statearr_77825[(15)] = inst_77682);

(statearr_77825[(16)] = inst_77676);

(statearr_77825[(17)] = inst_77675);

(statearr_77825[(18)] = inst_77679__$1);

return statearr_77825;
})();
if(cljs.core.truth_(inst_77677__$1)){
var statearr_77826_77880 = state_77760__$1;
(statearr_77826_77880[(1)] = (21));

} else {
var statearr_77827_77881 = state_77760__$1;
(statearr_77827_77881[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__16153__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__16153__auto____0 = (function (){
var statearr_77828 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_77828[(0)] = fluree$db$connection$msg_producer_$_state_machine__16153__auto__);

(statearr_77828[(1)] = (1));

return statearr_77828;
});
var fluree$db$connection$msg_producer_$_state_machine__16153__auto____1 = (function (state_77760){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_77760);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e77829){var ex__16156__auto__ = e77829;
var statearr_77830_77882 = state_77760;
(statearr_77830_77882[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_77760[(4)]))){
var statearr_77831_77883 = state_77760;
(statearr_77831_77883[(1)] = cljs.core.first((state_77760[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__77884 = state_77760;
state_77760 = G__77884;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__16153__auto__ = function(state_77760){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__16153__auto____1.call(this,state_77760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__16153__auto____0;
fluree$db$connection$msg_producer_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__16153__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_77832 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_77832[(6)] = c__16227__auto__);

return statearr_77832;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__77885 = conn;
var map__77885__$1 = cljs.core.__destructure_map(map__77885);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77885__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_77967){
var state_val_77968 = (state_77967[(1)]);
if((state_val_77968 === (7))){
var inst_77963 = (state_77967[(2)]);
var state_77967__$1 = state_77967;
var statearr_77969_78020 = state_77967__$1;
(statearr_77969_78020[(2)] = inst_77963);

(statearr_77969_78020[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (20))){
var inst_77904 = (state_77967[(7)]);
var inst_77918 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_77919 = [inst_77904];
var inst_77920 = cljs.core.PersistentHashMap.fromArrays(inst_77918,inst_77919);
var inst_77921 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_77920], 0));
var state_77967__$1 = state_77967;
var statearr_77970_78021 = state_77967__$1;
(statearr_77970_78021[(2)] = inst_77921);

(statearr_77970_78021[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (27))){
var state_77967__$1 = state_77967;
var statearr_77971_78022 = state_77967__$1;
(statearr_77971_78022[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (1))){
var inst_77886 = (0);
var state_77967__$1 = (function (){var statearr_77973 = state_77967;
(statearr_77973[(8)] = inst_77886);

return statearr_77973;
})();
var statearr_77974_78023 = state_77967__$1;
(statearr_77974_78023[(2)] = null);

(statearr_77974_78023[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (24))){
var inst_77897 = (state_77967[(9)]);
var inst_77946 = fluree.db.util.core.exception_QMARK_(inst_77897);
var state_77967__$1 = state_77967;
if(inst_77946){
var statearr_77975_78024 = state_77967__$1;
(statearr_77975_78024[(1)] = (26));

} else {
var statearr_77976_78025 = state_77967__$1;
(statearr_77976_78025[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (4))){
var inst_77891 = (state_77967[(10)]);
var inst_77896 = (state_77967[(2)]);
var inst_77897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77896,(0),null);
var inst_77898 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_77896,(1),null);
var inst_77899 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_77898,inst_77891);
var state_77967__$1 = (function (){var statearr_77977 = state_77967;
(statearr_77977[(9)] = inst_77897);

return statearr_77977;
})();
if(inst_77899){
var statearr_77978_78026 = state_77967__$1;
(statearr_77978_78026[(1)] = (5));

} else {
var statearr_77979_78027 = state_77967__$1;
(statearr_77979_78027[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (15))){
var inst_77904 = (state_77967[(7)]);
var inst_77913 = typeof inst_77904 === 'string';
var state_77967__$1 = state_77967;
if(cljs.core.truth_(inst_77913)){
var statearr_77980_78028 = state_77967__$1;
(statearr_77980_78028[(1)] = (17));

} else {
var statearr_77981_78029 = state_77967__$1;
(statearr_77981_78029[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (21))){
var state_77967__$1 = state_77967;
var statearr_77982_78030 = state_77967__$1;
(statearr_77982_78030[(2)] = null);

(statearr_77982_78030[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (31))){
var inst_77957 = (state_77967[(2)]);
var state_77967__$1 = state_77967;
var statearr_77983_78031 = state_77967__$1;
(statearr_77983_78031[(2)] = inst_77957);

(statearr_77983_78031[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (13))){
var inst_77930 = (state_77967[(2)]);
var inst_77931 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_77932 = fluree.db.connection.close_websocket(inst_77931);
var inst_77933 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_77934 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_77933);
var state_77967__$1 = (function (){var statearr_77984 = state_77967;
(statearr_77984[(11)] = inst_77930);

(statearr_77984[(12)] = inst_77932);

return statearr_77984;
})();
var statearr_77985_78032 = state_77967__$1;
(statearr_77985_78032[(2)] = inst_77934);

(statearr_77985_78032[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (22))){
var inst_77924 = (state_77967[(2)]);
var state_77967__$1 = state_77967;
var statearr_77986_78033 = state_77967__$1;
(statearr_77986_78033[(2)] = inst_77924);

(statearr_77986_78033[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (29))){
var inst_77897 = (state_77967[(9)]);
var inst_77952 = fluree.db.util.json.parse(inst_77897);
var inst_77953 = fluree.db.conn_events.process_events(conn,inst_77952);
var inst_77886 = (0);
var state_77967__$1 = (function (){var statearr_77987 = state_77967;
(statearr_77987[(13)] = inst_77953);

(statearr_77987[(8)] = inst_77886);

return statearr_77987;
})();
var statearr_77988_78034 = state_77967__$1;
(statearr_77988_78034[(2)] = null);

(statearr_77988_78034[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (6))){
var inst_77897 = (state_77967[(9)]);
var inst_77942 = (inst_77897 == null);
var state_77967__$1 = state_77967;
if(cljs.core.truth_(inst_77942)){
var statearr_77989_78035 = state_77967__$1;
(statearr_77989_78035[(1)] = (23));

} else {
var statearr_77990_78036 = state_77967__$1;
(statearr_77990_78036[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (28))){
var inst_77959 = (state_77967[(2)]);
var state_77967__$1 = state_77967;
var statearr_77991_78037 = state_77967__$1;
(statearr_77991_78037[(2)] = inst_77959);

(statearr_77991_78037[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (25))){
var inst_77961 = (state_77967[(2)]);
var state_77967__$1 = state_77967;
var statearr_77992_78038 = state_77967__$1;
(statearr_77992_78038[(2)] = inst_77961);

(statearr_77992_78038[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (17))){
var inst_77904 = (state_77967[(7)]);
var inst_77915 = cljs.core.eval(inst_77904);
var state_77967__$1 = state_77967;
var statearr_77993_78039 = state_77967__$1;
(statearr_77993_78039[(2)] = inst_77915);

(statearr_77993_78039[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (3))){
var inst_77965 = (state_77967[(2)]);
var state_77967__$1 = state_77967;
return cljs.core.async.impl.ioc_helpers.return_chan(state_77967__$1,inst_77965);
} else {
if((state_val_77968 === (12))){
var inst_77904 = (state_77967[(7)]);
var inst_77909 = cljs.core.fn_QMARK_(inst_77904);
var state_77967__$1 = state_77967;
if(inst_77909){
var statearr_77994_78040 = state_77967__$1;
(statearr_77994_78040[(1)] = (14));

} else {
var statearr_77995_78041 = state_77967__$1;
(statearr_77995_78041[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (2))){
var inst_77891 = (state_77967[(10)]);
var inst_77891__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_77892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_77893 = [sub_chan,inst_77891__$1];
var inst_77894 = (new cljs.core.PersistentVector(null,2,(5),inst_77892,inst_77893,null));
var state_77967__$1 = (function (){var statearr_77996 = state_77967;
(statearr_77996[(10)] = inst_77891__$1);

return statearr_77996;
})();
return cljs.core.async.ioc_alts_BANG_(state_77967__$1,(4),inst_77894);
} else {
if((state_val_77968 === (23))){
var inst_77944 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_77967__$1 = state_77967;
var statearr_77997_78042 = state_77967__$1;
(statearr_77997_78042[(2)] = inst_77944);

(statearr_77997_78042[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (19))){
var inst_77926 = (state_77967[(2)]);
var state_77967__$1 = state_77967;
var statearr_77998_78043 = state_77967__$1;
(statearr_77998_78043[(2)] = inst_77926);

(statearr_77998_78043[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (11))){
var inst_77907 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_77967__$1 = state_77967;
var statearr_77999_78044 = state_77967__$1;
(statearr_77999_78044[(2)] = inst_77907);

(statearr_77999_78044[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (9))){
var inst_77886 = (state_77967[(8)]);
var inst_77936 = fluree.db.connection.ping_transactor(conn);
var inst_77937 = (inst_77886 + (1));
var inst_77886__$1 = inst_77937;
var state_77967__$1 = (function (){var statearr_78000 = state_77967;
(statearr_78000[(14)] = inst_77936);

(statearr_78000[(8)] = inst_77886__$1);

return statearr_78000;
})();
var statearr_78001_78045 = state_77967__$1;
(statearr_78001_78045[(2)] = null);

(statearr_78001_78045[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (5))){
var inst_77886 = (state_77967[(8)]);
var inst_77901 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_77886);
var state_77967__$1 = state_77967;
if(inst_77901){
var statearr_78002_78046 = state_77967__$1;
(statearr_78002_78046[(1)] = (8));

} else {
var statearr_78003_78047 = state_77967__$1;
(statearr_78003_78047[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (14))){
var inst_77904 = (state_77967[(7)]);
var inst_77911 = (inst_77904.cljs$core$IFn$_invoke$arity$0 ? inst_77904.cljs$core$IFn$_invoke$arity$0() : inst_77904.call(null));
var state_77967__$1 = state_77967;
var statearr_78004_78048 = state_77967__$1;
(statearr_78004_78048[(2)] = inst_77911);

(statearr_78004_78048[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (26))){
var inst_77897 = (state_77967[(9)]);
var inst_77948 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_77897], 0));
var inst_77886 = (0);
var state_77967__$1 = (function (){var statearr_78005 = state_77967;
(statearr_78005[(15)] = inst_77948);

(statearr_78005[(8)] = inst_77886);

return statearr_78005;
})();
var statearr_78006_78049 = state_77967__$1;
(statearr_78006_78049[(2)] = null);

(statearr_78006_78049[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (16))){
var inst_77928 = (state_77967[(2)]);
var state_77967__$1 = state_77967;
var statearr_78007_78050 = state_77967__$1;
(statearr_78007_78050[(2)] = inst_77928);

(statearr_78007_78050[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (30))){
var state_77967__$1 = state_77967;
var statearr_78008_78051 = state_77967__$1;
(statearr_78008_78051[(2)] = null);

(statearr_78008_78051[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (10))){
var inst_77940 = (state_77967[(2)]);
var state_77967__$1 = state_77967;
var statearr_78009_78052 = state_77967__$1;
(statearr_78009_78052[(2)] = inst_77940);

(statearr_78009_78052[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (18))){
var state_77967__$1 = state_77967;
var statearr_78010_78053 = state_77967__$1;
(statearr_78010_78053[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_77968 === (8))){
var inst_77904 = (state_77967[(7)]);
var inst_77903 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_77904__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_77905 = (inst_77904__$1 == null);
var state_77967__$1 = (function (){var statearr_78012 = state_77967;
(statearr_78012[(7)] = inst_77904__$1);

(statearr_78012[(16)] = inst_77903);

return statearr_78012;
})();
if(cljs.core.truth_(inst_77905)){
var statearr_78013_78054 = state_77967__$1;
(statearr_78013_78054[(1)] = (11));

} else {
var statearr_78014_78055 = state_77967__$1;
(statearr_78014_78055[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__16153__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__16153__auto____0 = (function (){
var statearr_78015 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78015[(0)] = fluree$db$connection$msg_consumer_$_state_machine__16153__auto__);

(statearr_78015[(1)] = (1));

return statearr_78015;
});
var fluree$db$connection$msg_consumer_$_state_machine__16153__auto____1 = (function (state_77967){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_77967);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e78016){var ex__16156__auto__ = e78016;
var statearr_78017_78056 = state_77967;
(statearr_78017_78056[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_77967[(4)]))){
var statearr_78018_78057 = state_77967;
(statearr_78018_78057[(1)] = cljs.core.first((state_77967[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__78058 = state_77967;
state_77967 = G__78058;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__16153__auto__ = function(state_77967){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__16153__auto____1.call(this,state_77967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__16153__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__16153__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_78019 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_78019[(6)] = c__16227__auto__);

return statearr_78019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__78060 = arguments.length;
switch (G__78060) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__78061 = opts;
var map__78061__$1 = cljs.core.__destructure_map(map__78061);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78061__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78061__$1,cljs.core.cst$kw$jwt);
return (function (k){
var c__16227__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_78113){
var state_val_78114 = (state_78113[(1)]);
if((state_val_78114 === (7))){
var inst_78071 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_78072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_78073 = [conn_id,cljs.core.cst$kw$token];
var inst_78074 = (new cljs.core.PersistentVector(null,2,(5),inst_78072,inst_78073,null));
var inst_78075 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_78071,inst_78074);
var state_78113__$1 = state_78113;
var statearr_78115_78146 = state_78113__$1;
(statearr_78115_78146[(2)] = inst_78075);

(statearr_78115_78146[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (1))){
var state_78113__$1 = state_78113;
var statearr_78116_78147 = state_78113__$1;
(statearr_78116_78147[(2)] = null);

(statearr_78116_78147[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (4))){
var inst_78062 = (state_78113[(2)]);
var state_78113__$1 = state_78113;
var statearr_78117_78148 = state_78113__$1;
(statearr_78117_78148[(2)] = inst_78062);

(statearr_78117_78148[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (15))){
var inst_78082 = (state_78113[(7)]);
var inst_78101 = (state_78113[(2)]);
var inst_78102 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_78103 = [(5000),inst_78101,cljs.core.cst$kw$text];
var inst_78104 = cljs.core.PersistentHashMap.fromArrays(inst_78102,inst_78103);
var inst_78105 = fluree.db.util.xhttp.get(inst_78082,inst_78104);
var state_78113__$1 = state_78113;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78113__$1,(16),inst_78105);
} else {
if((state_val_78114 === (13))){
var inst_78082 = (state_78113[(7)]);
var inst_78092 = (state_78113[(8)]);
var inst_78094 = [cljs.core.cst$kw$headers];
var inst_78095 = [inst_78092];
var inst_78096 = cljs.core.PersistentHashMap.fromArrays(inst_78094,inst_78095);
var inst_78097 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_78082,inst_78096,private$);
var inst_78098 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_78097);
var state_78113__$1 = state_78113;
var statearr_78118_78149 = state_78113__$1;
(statearr_78118_78149[(2)] = inst_78098);

(statearr_78118_78149[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (6))){
var inst_78068 = (state_78113[(9)]);
var state_78113__$1 = state_78113;
var statearr_78119_78150 = state_78113__$1;
(statearr_78119_78150[(2)] = inst_78068);

(statearr_78119_78150[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (3))){
var inst_78111 = (state_78113[(2)]);
var state_78113__$1 = state_78113;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78113__$1,inst_78111);
} else {
if((state_val_78114 === (12))){
var inst_78092 = (state_78113[(2)]);
var state_78113__$1 = (function (){var statearr_78120 = state_78113;
(statearr_78120[(8)] = inst_78092);

return statearr_78120;
})();
if(cljs.core.truth_(private$)){
var statearr_78121_78151 = state_78113__$1;
(statearr_78121_78151[(1)] = (13));

} else {
var statearr_78122_78152 = state_78113__$1;
(statearr_78122_78152[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (2))){
var inst_78068 = (state_78113[(9)]);
var _ = (function (){var statearr_78123 = state_78113;
(statearr_78123[(4)] = cljs.core.cons((5),(state_78113[(4)])));

return statearr_78123;
})();
var inst_78068__$1 = jwt;
var state_78113__$1 = (function (){var statearr_78124 = state_78113;
(statearr_78124[(9)] = inst_78068__$1);

return statearr_78124;
})();
if(cljs.core.truth_(inst_78068__$1)){
var statearr_78125_78153 = state_78113__$1;
(statearr_78125_78153[(1)] = (6));

} else {
var statearr_78126_78154 = state_78113__$1;
(statearr_78126_78154[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (11))){
var inst_78086 = (state_78113[(10)]);
var state_78113__$1 = state_78113;
var statearr_78128_78155 = state_78113__$1;
(statearr_78128_78155[(2)] = inst_78086);

(statearr_78128_78155[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (9))){
var inst_78078 = (state_78113[(11)]);
var inst_78077 = (state_78113[(12)]);
var inst_78081 = (state_78113[(2)]);
var inst_78082 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78081),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78078)].join('');
var inst_78084 = ["Accept"];
var inst_78085 = ["application/json"];
var inst_78086 = cljs.core.PersistentHashMap.fromArrays(inst_78084,inst_78085);
var state_78113__$1 = (function (){var statearr_78129 = state_78113;
(statearr_78129[(7)] = inst_78082);

(statearr_78129[(10)] = inst_78086);

return statearr_78129;
})();
if(cljs.core.truth_(inst_78077)){
var statearr_78130_78156 = state_78113__$1;
(statearr_78130_78156[(1)] = (10));

} else {
var statearr_78131_78157 = state_78113__$1;
(statearr_78131_78157[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (5))){
var _ = (function (){var statearr_78132 = state_78113;
(statearr_78132[(4)] = cljs.core.rest((state_78113[(4)])));

return statearr_78132;
})();
var state_78113__$1 = state_78113;
var ex78127 = (state_78113__$1[(2)]);
var statearr_78133_78158 = state_78113__$1;
(statearr_78133_78158[(5)] = ex78127);


if((ex78127 instanceof Error)){
var statearr_78134_78159 = state_78113__$1;
(statearr_78134_78159[(1)] = (4));

(statearr_78134_78159[(5)] = null);

} else {
throw ex78127;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (14))){
var inst_78092 = (state_78113[(8)]);
var state_78113__$1 = state_78113;
var statearr_78135_78160 = state_78113__$1;
(statearr_78135_78160[(2)] = inst_78092);

(statearr_78135_78160[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (16))){
var inst_78107 = (state_78113[(2)]);
var inst_78108 = fluree.db.util.async.throw_err(inst_78107);
var _ = (function (){var statearr_78136 = state_78113;
(statearr_78136[(4)] = cljs.core.rest((state_78113[(4)])));

return statearr_78136;
})();
var state_78113__$1 = state_78113;
var statearr_78137_78161 = state_78113__$1;
(statearr_78137_78161[(2)] = inst_78108);

(statearr_78137_78161[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (10))){
var inst_78077 = (state_78113[(12)]);
var inst_78086 = (state_78113[(10)]);
var inst_78088 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_78077)].join('');
var inst_78089 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_78086,"Authorization",inst_78088);
var state_78113__$1 = state_78113;
var statearr_78138_78162 = state_78113__$1;
(statearr_78138_78162[(2)] = inst_78089);

(statearr_78138_78162[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78114 === (8))){
var inst_78077 = (state_78113[(2)]);
var inst_78078 = clojure.string.replace(k,"_","/");
var inst_78079 = fluree.db.connection.get_server(conn_id,servers);
var state_78113__$1 = (function (){var statearr_78139 = state_78113;
(statearr_78139[(11)] = inst_78078);

(statearr_78139[(12)] = inst_78077);

return statearr_78139;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78113__$1,(9),inst_78079);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__16153__auto__ = null;
var fluree$db$connection$state_machine__16153__auto____0 = (function (){
var statearr_78140 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_78140[(0)] = fluree$db$connection$state_machine__16153__auto__);

(statearr_78140[(1)] = (1));

return statearr_78140;
});
var fluree$db$connection$state_machine__16153__auto____1 = (function (state_78113){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_78113);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e78141){var ex__16156__auto__ = e78141;
var statearr_78142_78163 = state_78113;
(statearr_78142_78163[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_78113[(4)]))){
var statearr_78143_78164 = state_78113;
(statearr_78143_78164[(1)] = cljs.core.first((state_78113[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__78165 = state_78113;
state_78113 = G__78165;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$connection$state_machine__16153__auto__ = function(state_78113){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__16153__auto____1.call(this,state_78113);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__16153__auto____0;
fluree$db$connection$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__16153__auto____1;
return fluree$db$connection$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_78144 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_78144[(6)] = c__16227__auto__);

return statearr_78144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

return c__16227__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__78166_SHARP_){
if(cljs.core.truth_(p1__78166_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),(function (p1__78167_SHARP_){
var or__4223__auto__ = p1__78167_SHARP_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return token;
}
}));

return true;
}catch (e78168){var e = e78168;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__78169 = opts;
var map__78169__$1 = cljs.core.__destructure_map(map__78169);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78169__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78169__$1,cljs.core.cst$kw$parallelism,(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78169__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78169__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78169__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78169__$1,cljs.core.cst$kw$storage_DASH_write,(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78169__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78169__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78169__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__78169__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__78169__$1,cljs.core.cst$kw$storage_DASH_list);
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4223__auto__ = object_cache;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4223__auto__ = storage_read;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4223__auto__ = storage_exists;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = storage_read;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4221__auto__ = storage_write;
if(cljs.core.truth_(and__4221__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_list,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__78170_78171 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__78170_78171.cljs$core$IFn$_invoke$arity$0 ? fexpr__78170_78171.cljs$core$IFn$_invoke$arity$0() : fexpr__78170_78171.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4835__auto__ = [];
var len__4829__auto___78212 = arguments.length;
var i__4830__auto___78213 = (0);
while(true){
if((i__4830__auto___78213 < len__4829__auto___78212)){
args__4835__auto__.push((arguments[i__4830__auto___78213]));

var G__78214 = (i__4830__auto___78213 + (1));
i__4830__auto___78213 = G__78214;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__78174){
var vec__78175 = p__78174;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__78175,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = cljs.core.cst$kw$dev_QMARK_.cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__16227__auto___78215 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16228__auto__ = (function (){var switch__16152__auto__ = (function (state_78195){
var state_val_78196 = (state_78195[(1)]);
if((state_val_78196 === (1))){
var inst_78178 = fluree.db.connection.get_socket(conn);
var state_78195__$1 = state_78195;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_78195__$1,(2),inst_78178);
} else {
if((state_val_78196 === (2))){
var inst_78180 = (state_78195[(7)]);
var inst_78181 = (state_78195[(8)]);
var inst_78180__$1 = (state_78195[(2)]);
var inst_78181__$1 = (inst_78180__$1 == null);
var state_78195__$1 = (function (){var statearr_78197 = state_78195;
(statearr_78197[(7)] = inst_78180__$1);

(statearr_78197[(8)] = inst_78181__$1);

return statearr_78197;
})();
if(cljs.core.truth_(inst_78181__$1)){
var statearr_78198_78216 = state_78195__$1;
(statearr_78198_78216[(1)] = (3));

} else {
var statearr_78199_78217 = state_78195__$1;
(statearr_78199_78217[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_78196 === (3))){
var inst_78181 = (state_78195[(8)]);
var state_78195__$1 = state_78195;
var statearr_78200_78218 = state_78195__$1;
(statearr_78200_78218[(2)] = inst_78181);

(statearr_78200_78218[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78196 === (4))){
var inst_78180 = (state_78195[(7)]);
var inst_78184 = fluree.db.util.core.exception_QMARK_(inst_78180);
var state_78195__$1 = state_78195;
var statearr_78201_78219 = state_78195__$1;
(statearr_78201_78219[(2)] = inst_78184);

(statearr_78201_78219[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78196 === (5))){
var inst_78186 = (state_78195[(2)]);
var state_78195__$1 = state_78195;
if(cljs.core.truth_(inst_78186)){
var statearr_78202_78220 = state_78195__$1;
(statearr_78202_78220[(1)] = (6));

} else {
var statearr_78203_78221 = state_78195__$1;
(statearr_78203_78221[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_78196 === (6))){
var inst_78188 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_78189 = cljs.core.async.close_BANG_(conn);
var state_78195__$1 = (function (){var statearr_78204 = state_78195;
(statearr_78204[(9)] = inst_78188);

return statearr_78204;
})();
var statearr_78205_78222 = state_78195__$1;
(statearr_78205_78222[(2)] = inst_78189);

(statearr_78205_78222[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78196 === (7))){
var inst_78191 = fluree.db.connection.msg_consumer(conn);
var state_78195__$1 = state_78195;
var statearr_78206_78223 = state_78195__$1;
(statearr_78206_78223[(2)] = inst_78191);

(statearr_78206_78223[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_78196 === (8))){
var inst_78193 = (state_78195[(2)]);
var state_78195__$1 = state_78195;
return cljs.core.async.impl.ioc_helpers.return_chan(state_78195__$1,inst_78193);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__16153__auto__ = null;
var fluree$db$connection$state_machine__16153__auto____0 = (function (){
var statearr_78207 = [null,null,null,null,null,null,null,null,null,null];
(statearr_78207[(0)] = fluree$db$connection$state_machine__16153__auto__);

(statearr_78207[(1)] = (1));

return statearr_78207;
});
var fluree$db$connection$state_machine__16153__auto____1 = (function (state_78195){
while(true){
var ret_value__16154__auto__ = (function (){try{while(true){
var result__16155__auto__ = switch__16152__auto__(state_78195);
if(cljs.core.keyword_identical_QMARK_(result__16155__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16155__auto__;
}
break;
}
}catch (e78208){var ex__16156__auto__ = e78208;
var statearr_78209_78224 = state_78195;
(statearr_78209_78224[(2)] = ex__16156__auto__);


if(cljs.core.seq((state_78195[(4)]))){
var statearr_78210_78225 = state_78195;
(statearr_78210_78225[(1)] = cljs.core.first((state_78195[(4)])));

} else {
throw ex__16156__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16154__auto__,cljs.core.cst$kw$recur)){
var G__78226 = state_78195;
state_78195 = G__78226;
continue;
} else {
return ret_value__16154__auto__;
}
break;
}
});
fluree$db$connection$state_machine__16153__auto__ = function(state_78195){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__16153__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__16153__auto____1.call(this,state_78195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__16153__auto____0;
fluree$db$connection$state_machine__16153__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__16153__auto____1;
return fluree$db$connection$state_machine__16153__auto__;
})()
})();
var state__16229__auto__ = (function (){var statearr_78211 = (f__16228__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16228__auto__.cljs$core$IFn$_invoke$arity$0() : f__16228__auto__.call(null));
(statearr_78211[(6)] = c__16227__auto___78215);

return statearr_78211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16229__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq78172){
var G__78173 = cljs.core.first(seq78172);
var seq78172__$1 = cljs.core.next(seq78172);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__78173,seq78172__$1);
}));

