// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__28716 = cljs.core.get_global_hierarchy;
return (fexpr__28716.cljs$core$IFn$_invoke$arity$0 ? fexpr__28716.cljs$core$IFn$_invoke$arity$0() : fexpr__28716.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_DASH_ws_DASH_id,(function (conn,_,___$1,ws_id){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,cljs.core.cst$kw$socket_DASH_id,ws_id);
}));
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (conn,event_type,subject,event_data){
var callbacks = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,subject], null));
var seq__28717 = cljs.core.seq(callbacks);
var chunk__28718 = null;
var count__28719 = (0);
var i__28720 = (0);
while(true){
if((i__28720 < count__28719)){
var vec__28729 = chunk__28718.cljs$core$IIndexed$_nth$arity$2(null,i__28720);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28729,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28729,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e28732){var e_28737 = e28732;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28737,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__28738 = seq__28717;
var G__28739 = chunk__28718;
var G__28740 = count__28719;
var G__28741 = (i__28720 + (1));
seq__28717 = G__28738;
chunk__28718 = G__28739;
count__28719 = G__28740;
i__28720 = G__28741;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__28717);
if(temp__5753__auto__){
var seq__28717__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__28717__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__28717__$1);
var G__28742 = cljs.core.chunk_rest(seq__28717__$1);
var G__28743 = c__4649__auto__;
var G__28744 = cljs.core.count(c__4649__auto__);
var G__28745 = (0);
seq__28717 = G__28742;
chunk__28718 = G__28743;
count__28719 = G__28744;
i__28720 = G__28745;
continue;
} else {
var vec__28733 = cljs.core.first(seq__28717__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28733,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28733,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e28736){var e_28746 = e28736;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_28746,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__28747 = cljs.core.next(seq__28717__$1);
var G__28748 = null;
var G__28749 = (0);
var G__28750 = (0);
seq__28717 = G__28747;
chunk__28718 = G__28748;
count__28719 = G__28749;
i__28720 = G__28750;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Process events: ",msg], 0));
var vec__28753 = msg;
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28753,(0),null);
var subject = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28753,(1),null);
var event_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28753,(2),null);
var error_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28753,(3),null);
var event_type__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(event_type);
var map__28756 = conn;
var map__28756__$1 = cljs.core.__destructure_map(map__28756);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28756__$1,cljs.core.cst$kw$state);
var G__28757 = event_type__$1;
var G__28757__$1 = (((G__28757 instanceof cljs.core.Keyword))?G__28757.fqn:null);
switch (G__28757__$1) {
case "response":
var temp__5753__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pending_DASH_req,subject], null));
if(cljs.core.truth_(temp__5753__auto__)){
var res_chan = temp__5753__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,(function (p1__28751_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__28751_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__28758 = error_data;
var map__28758__$1 = cljs.core.__destructure_map(map__28758);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__28758__$1,cljs.core.cst$kw$message);
var exception = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = message;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0));
}
})(),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(error_data,cljs.core.cst$kw$message));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,event_data);
} else {
return cljs.core.async.close_BANG_(res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(conn,event_type__$1,subject,event_data) : fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data));

}
}catch (e28752){var e = e28752;
return fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
