// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__10222){
var vec__10223 = p__10222;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10223,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10223,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__10226 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10226,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10226,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10226,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10226,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10226,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(goog.object.get(source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5753__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__10229 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10229,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10229,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10229,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10229,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10229,(4),null);
var vec__10232 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10232,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10232,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10232,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10232,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10232,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4223__auto__ = source;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4223__auto__ = line;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4223__auto__ = col;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__10235 = segmap;
var map__10235__$1 = cljs.core.__destructure_map(map__10235);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10235__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10235__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10235__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10235__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10235__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__10237 = arguments.length;
switch (G__10237) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__10241 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__10245 = cljs.core.next(segs__$1);
var G__10246 = nrelseg;
var G__10247 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__10245;
relseg__$1 = G__10246;
result__$1 = G__10247;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10241,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10241,(1),null);
var G__10248 = (gline + (1));
var G__10249 = cljs.core.next(lines__$1);
var G__10250 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__10251 = result__$1;
gline = G__10248;
lines__$1 = G__10249;
relseg = G__10250;
result = G__10251;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__10253 = segmap;
var map__10253__$1 = cljs.core.__destructure_map(map__10253);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10253__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10253__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10253__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10253__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10253__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__10252_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__10252_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__10255 = arguments.length;
switch (G__10255) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__10259 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__10263 = cljs.core.next(segs__$1);
var G__10264 = nrelseg;
var G__10265 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__10263;
relseg__$1 = G__10264;
result__$1 = G__10265;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10259,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10259,(1),null);
var G__10266 = (gline + (1));
var G__10267 = cljs.core.next(lines__$1);
var G__10268 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__10269 = result__$1;
gline = G__10266;
lines__$1 = G__10267;
relseg = G__10268;
result = G__10269;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__10270){
var vec__10271 = p__10270;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10271,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10271,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10271,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10271,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10271,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__10274){
var vec__10275 = p__10274;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10275,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10275,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10275,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10275,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10275,(4),null);
var seg = vec__10275;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__10278){
var vec__10279 = p__10278;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10279,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10279,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10279,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10279,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10279,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__10285 = cljs.core.seq(infos);
var chunk__10286 = null;
var count__10287 = (0);
var i__10288 = (0);
while(true){
if((i__10288 < count__10287)){
var info = chunk__10286.cljs$core$IIndexed$_nth$arity$2(null,i__10288);
var segv_10639 = info__GT_segv(info,source_idx,line,col);
var gline_10640 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_10641 = cljs.core.count(cljs.core.deref(lines));
if((gline_10640 > (lc_10641 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__10285,chunk__10286,count__10287,i__10288,segv_10639,gline_10640,lc_10641,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_10640 - (lc_10641 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_10639], null));
});})(seq__10285,chunk__10286,count__10287,i__10288,segv_10639,gline_10640,lc_10641,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__10285,chunk__10286,count__10287,i__10288,segv_10639,gline_10640,lc_10641,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_10640], null),cljs.core.conj,segv_10639);
});})(seq__10285,chunk__10286,count__10287,i__10288,segv_10639,gline_10640,lc_10641,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__10642 = seq__10285;
var G__10643 = chunk__10286;
var G__10644 = count__10287;
var G__10645 = (i__10288 + (1));
seq__10285 = G__10642;
chunk__10286 = G__10643;
count__10287 = G__10644;
i__10288 = G__10645;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__10285);
if(temp__5753__auto__){
var seq__10285__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10285__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__10285__$1);
var G__10646 = cljs.core.chunk_rest(seq__10285__$1);
var G__10647 = c__4649__auto__;
var G__10648 = cljs.core.count(c__4649__auto__);
var G__10649 = (0);
seq__10285 = G__10646;
chunk__10286 = G__10647;
count__10287 = G__10648;
i__10288 = G__10649;
continue;
} else {
var info = cljs.core.first(seq__10285__$1);
var segv_10650 = info__GT_segv(info,source_idx,line,col);
var gline_10651 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_10652 = cljs.core.count(cljs.core.deref(lines));
if((gline_10651 > (lc_10652 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__10285,chunk__10286,count__10287,i__10288,segv_10650,gline_10651,lc_10652,info,seq__10285__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_10651 - (lc_10652 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_10650], null));
});})(seq__10285,chunk__10286,count__10287,i__10288,segv_10650,gline_10651,lc_10652,info,seq__10285__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__10285,chunk__10286,count__10287,i__10288,segv_10650,gline_10651,lc_10652,info,seq__10285__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_10651], null),cljs.core.conj,segv_10650);
});})(seq__10285,chunk__10286,count__10287,i__10288,segv_10650,gline_10651,lc_10652,info,seq__10285__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__10653 = cljs.core.next(seq__10285__$1);
var G__10654 = null;
var G__10655 = (0);
var G__10656 = (0);
seq__10285 = G__10653;
chunk__10286 = G__10654;
count__10287 = G__10655;
i__10288 = G__10656;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__10289_10657 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__10290_10658 = null;
var count__10291_10659 = (0);
var i__10292_10660 = (0);
while(true){
if((i__10292_10660 < count__10291_10659)){
var vec__10465_10661 = chunk__10290_10658.cljs$core$IIndexed$_nth$arity$2(null,i__10292_10660);
var source_idx_10662 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10465_10661,(0),null);
var vec__10468_10663 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10465_10661,(1),null);
var __10664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10468_10663,(0),null);
var lines_10665__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10468_10663,(1),null);
var seq__10471_10666 = cljs.core.seq(lines_10665__$1);
var chunk__10472_10667 = null;
var count__10473_10668 = (0);
var i__10474_10669 = (0);
while(true){
if((i__10474_10669 < count__10473_10668)){
var vec__10513_10670 = chunk__10472_10667.cljs$core$IIndexed$_nth$arity$2(null,i__10474_10669);
var line_10671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10513_10670,(0),null);
var cols_10672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10513_10670,(1),null);
var seq__10516_10673 = cljs.core.seq(cols_10672);
var chunk__10517_10674 = null;
var count__10518_10675 = (0);
var i__10519_10676 = (0);
while(true){
if((i__10519_10676 < count__10518_10675)){
var vec__10526_10677 = chunk__10517_10674.cljs$core$IIndexed$_nth$arity$2(null,i__10519_10676);
var col_10678 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10526_10677,(0),null);
var infos_10679 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10526_10677,(1),null);
encode_cols(infos_10679,source_idx_10662,line_10671,col_10678);


var G__10680 = seq__10516_10673;
var G__10681 = chunk__10517_10674;
var G__10682 = count__10518_10675;
var G__10683 = (i__10519_10676 + (1));
seq__10516_10673 = G__10680;
chunk__10517_10674 = G__10681;
count__10518_10675 = G__10682;
i__10519_10676 = G__10683;
continue;
} else {
var temp__5753__auto___10684 = cljs.core.seq(seq__10516_10673);
if(temp__5753__auto___10684){
var seq__10516_10685__$1 = temp__5753__auto___10684;
if(cljs.core.chunked_seq_QMARK_(seq__10516_10685__$1)){
var c__4649__auto___10686 = cljs.core.chunk_first(seq__10516_10685__$1);
var G__10687 = cljs.core.chunk_rest(seq__10516_10685__$1);
var G__10688 = c__4649__auto___10686;
var G__10689 = cljs.core.count(c__4649__auto___10686);
var G__10690 = (0);
seq__10516_10673 = G__10687;
chunk__10517_10674 = G__10688;
count__10518_10675 = G__10689;
i__10519_10676 = G__10690;
continue;
} else {
var vec__10529_10691 = cljs.core.first(seq__10516_10685__$1);
var col_10692 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10529_10691,(0),null);
var infos_10693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10529_10691,(1),null);
encode_cols(infos_10693,source_idx_10662,line_10671,col_10692);


var G__10694 = cljs.core.next(seq__10516_10685__$1);
var G__10695 = null;
var G__10696 = (0);
var G__10697 = (0);
seq__10516_10673 = G__10694;
chunk__10517_10674 = G__10695;
count__10518_10675 = G__10696;
i__10519_10676 = G__10697;
continue;
}
} else {
}
}
break;
}


var G__10698 = seq__10471_10666;
var G__10699 = chunk__10472_10667;
var G__10700 = count__10473_10668;
var G__10701 = (i__10474_10669 + (1));
seq__10471_10666 = G__10698;
chunk__10472_10667 = G__10699;
count__10473_10668 = G__10700;
i__10474_10669 = G__10701;
continue;
} else {
var temp__5753__auto___10702 = cljs.core.seq(seq__10471_10666);
if(temp__5753__auto___10702){
var seq__10471_10703__$1 = temp__5753__auto___10702;
if(cljs.core.chunked_seq_QMARK_(seq__10471_10703__$1)){
var c__4649__auto___10704 = cljs.core.chunk_first(seq__10471_10703__$1);
var G__10705 = cljs.core.chunk_rest(seq__10471_10703__$1);
var G__10706 = c__4649__auto___10704;
var G__10707 = cljs.core.count(c__4649__auto___10704);
var G__10708 = (0);
seq__10471_10666 = G__10705;
chunk__10472_10667 = G__10706;
count__10473_10668 = G__10707;
i__10474_10669 = G__10708;
continue;
} else {
var vec__10532_10709 = cljs.core.first(seq__10471_10703__$1);
var line_10710 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10532_10709,(0),null);
var cols_10711 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10532_10709,(1),null);
var seq__10535_10712 = cljs.core.seq(cols_10711);
var chunk__10536_10713 = null;
var count__10537_10714 = (0);
var i__10538_10715 = (0);
while(true){
if((i__10538_10715 < count__10537_10714)){
var vec__10545_10716 = chunk__10536_10713.cljs$core$IIndexed$_nth$arity$2(null,i__10538_10715);
var col_10717 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10545_10716,(0),null);
var infos_10718 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10545_10716,(1),null);
encode_cols(infos_10718,source_idx_10662,line_10710,col_10717);


var G__10719 = seq__10535_10712;
var G__10720 = chunk__10536_10713;
var G__10721 = count__10537_10714;
var G__10722 = (i__10538_10715 + (1));
seq__10535_10712 = G__10719;
chunk__10536_10713 = G__10720;
count__10537_10714 = G__10721;
i__10538_10715 = G__10722;
continue;
} else {
var temp__5753__auto___10723__$1 = cljs.core.seq(seq__10535_10712);
if(temp__5753__auto___10723__$1){
var seq__10535_10724__$1 = temp__5753__auto___10723__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10535_10724__$1)){
var c__4649__auto___10725 = cljs.core.chunk_first(seq__10535_10724__$1);
var G__10726 = cljs.core.chunk_rest(seq__10535_10724__$1);
var G__10727 = c__4649__auto___10725;
var G__10728 = cljs.core.count(c__4649__auto___10725);
var G__10729 = (0);
seq__10535_10712 = G__10726;
chunk__10536_10713 = G__10727;
count__10537_10714 = G__10728;
i__10538_10715 = G__10729;
continue;
} else {
var vec__10548_10730 = cljs.core.first(seq__10535_10724__$1);
var col_10731 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10548_10730,(0),null);
var infos_10732 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10548_10730,(1),null);
encode_cols(infos_10732,source_idx_10662,line_10710,col_10731);


var G__10733 = cljs.core.next(seq__10535_10724__$1);
var G__10734 = null;
var G__10735 = (0);
var G__10736 = (0);
seq__10535_10712 = G__10733;
chunk__10536_10713 = G__10734;
count__10537_10714 = G__10735;
i__10538_10715 = G__10736;
continue;
}
} else {
}
}
break;
}


var G__10737 = cljs.core.next(seq__10471_10703__$1);
var G__10738 = null;
var G__10739 = (0);
var G__10740 = (0);
seq__10471_10666 = G__10737;
chunk__10472_10667 = G__10738;
count__10473_10668 = G__10739;
i__10474_10669 = G__10740;
continue;
}
} else {
}
}
break;
}


var G__10741 = seq__10289_10657;
var G__10742 = chunk__10290_10658;
var G__10743 = count__10291_10659;
var G__10744 = (i__10292_10660 + (1));
seq__10289_10657 = G__10741;
chunk__10290_10658 = G__10742;
count__10291_10659 = G__10743;
i__10292_10660 = G__10744;
continue;
} else {
var temp__5753__auto___10745 = cljs.core.seq(seq__10289_10657);
if(temp__5753__auto___10745){
var seq__10289_10746__$1 = temp__5753__auto___10745;
if(cljs.core.chunked_seq_QMARK_(seq__10289_10746__$1)){
var c__4649__auto___10747 = cljs.core.chunk_first(seq__10289_10746__$1);
var G__10748 = cljs.core.chunk_rest(seq__10289_10746__$1);
var G__10749 = c__4649__auto___10747;
var G__10750 = cljs.core.count(c__4649__auto___10747);
var G__10751 = (0);
seq__10289_10657 = G__10748;
chunk__10290_10658 = G__10749;
count__10291_10659 = G__10750;
i__10292_10660 = G__10751;
continue;
} else {
var vec__10551_10752 = cljs.core.first(seq__10289_10746__$1);
var source_idx_10753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10551_10752,(0),null);
var vec__10554_10754 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10551_10752,(1),null);
var __10755 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10554_10754,(0),null);
var lines_10756__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10554_10754,(1),null);
var seq__10557_10757 = cljs.core.seq(lines_10756__$1);
var chunk__10558_10758 = null;
var count__10559_10759 = (0);
var i__10560_10760 = (0);
while(true){
if((i__10560_10760 < count__10559_10759)){
var vec__10599_10761 = chunk__10558_10758.cljs$core$IIndexed$_nth$arity$2(null,i__10560_10760);
var line_10762 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10599_10761,(0),null);
var cols_10763 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10599_10761,(1),null);
var seq__10602_10764 = cljs.core.seq(cols_10763);
var chunk__10603_10765 = null;
var count__10604_10766 = (0);
var i__10605_10767 = (0);
while(true){
if((i__10605_10767 < count__10604_10766)){
var vec__10612_10768 = chunk__10603_10765.cljs$core$IIndexed$_nth$arity$2(null,i__10605_10767);
var col_10769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10612_10768,(0),null);
var infos_10770 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10612_10768,(1),null);
encode_cols(infos_10770,source_idx_10753,line_10762,col_10769);


var G__10771 = seq__10602_10764;
var G__10772 = chunk__10603_10765;
var G__10773 = count__10604_10766;
var G__10774 = (i__10605_10767 + (1));
seq__10602_10764 = G__10771;
chunk__10603_10765 = G__10772;
count__10604_10766 = G__10773;
i__10605_10767 = G__10774;
continue;
} else {
var temp__5753__auto___10775__$1 = cljs.core.seq(seq__10602_10764);
if(temp__5753__auto___10775__$1){
var seq__10602_10776__$1 = temp__5753__auto___10775__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10602_10776__$1)){
var c__4649__auto___10777 = cljs.core.chunk_first(seq__10602_10776__$1);
var G__10778 = cljs.core.chunk_rest(seq__10602_10776__$1);
var G__10779 = c__4649__auto___10777;
var G__10780 = cljs.core.count(c__4649__auto___10777);
var G__10781 = (0);
seq__10602_10764 = G__10778;
chunk__10603_10765 = G__10779;
count__10604_10766 = G__10780;
i__10605_10767 = G__10781;
continue;
} else {
var vec__10615_10782 = cljs.core.first(seq__10602_10776__$1);
var col_10783 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10615_10782,(0),null);
var infos_10784 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10615_10782,(1),null);
encode_cols(infos_10784,source_idx_10753,line_10762,col_10783);


var G__10785 = cljs.core.next(seq__10602_10776__$1);
var G__10786 = null;
var G__10787 = (0);
var G__10788 = (0);
seq__10602_10764 = G__10785;
chunk__10603_10765 = G__10786;
count__10604_10766 = G__10787;
i__10605_10767 = G__10788;
continue;
}
} else {
}
}
break;
}


var G__10789 = seq__10557_10757;
var G__10790 = chunk__10558_10758;
var G__10791 = count__10559_10759;
var G__10792 = (i__10560_10760 + (1));
seq__10557_10757 = G__10789;
chunk__10558_10758 = G__10790;
count__10559_10759 = G__10791;
i__10560_10760 = G__10792;
continue;
} else {
var temp__5753__auto___10793__$1 = cljs.core.seq(seq__10557_10757);
if(temp__5753__auto___10793__$1){
var seq__10557_10794__$1 = temp__5753__auto___10793__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10557_10794__$1)){
var c__4649__auto___10795 = cljs.core.chunk_first(seq__10557_10794__$1);
var G__10796 = cljs.core.chunk_rest(seq__10557_10794__$1);
var G__10797 = c__4649__auto___10795;
var G__10798 = cljs.core.count(c__4649__auto___10795);
var G__10799 = (0);
seq__10557_10757 = G__10796;
chunk__10558_10758 = G__10797;
count__10559_10759 = G__10798;
i__10560_10760 = G__10799;
continue;
} else {
var vec__10618_10800 = cljs.core.first(seq__10557_10794__$1);
var line_10801 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10618_10800,(0),null);
var cols_10802 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10618_10800,(1),null);
var seq__10621_10803 = cljs.core.seq(cols_10802);
var chunk__10622_10804 = null;
var count__10623_10805 = (0);
var i__10624_10806 = (0);
while(true){
if((i__10624_10806 < count__10623_10805)){
var vec__10631_10807 = chunk__10622_10804.cljs$core$IIndexed$_nth$arity$2(null,i__10624_10806);
var col_10808 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10631_10807,(0),null);
var infos_10809 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10631_10807,(1),null);
encode_cols(infos_10809,source_idx_10753,line_10801,col_10808);


var G__10810 = seq__10621_10803;
var G__10811 = chunk__10622_10804;
var G__10812 = count__10623_10805;
var G__10813 = (i__10624_10806 + (1));
seq__10621_10803 = G__10810;
chunk__10622_10804 = G__10811;
count__10623_10805 = G__10812;
i__10624_10806 = G__10813;
continue;
} else {
var temp__5753__auto___10814__$2 = cljs.core.seq(seq__10621_10803);
if(temp__5753__auto___10814__$2){
var seq__10621_10815__$1 = temp__5753__auto___10814__$2;
if(cljs.core.chunked_seq_QMARK_(seq__10621_10815__$1)){
var c__4649__auto___10816 = cljs.core.chunk_first(seq__10621_10815__$1);
var G__10817 = cljs.core.chunk_rest(seq__10621_10815__$1);
var G__10818 = c__4649__auto___10816;
var G__10819 = cljs.core.count(c__4649__auto___10816);
var G__10820 = (0);
seq__10621_10803 = G__10817;
chunk__10622_10804 = G__10818;
count__10623_10805 = G__10819;
i__10624_10806 = G__10820;
continue;
} else {
var vec__10634_10821 = cljs.core.first(seq__10621_10815__$1);
var col_10822 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10634_10821,(0),null);
var infos_10823 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10634_10821,(1),null);
encode_cols(infos_10823,source_idx_10753,line_10801,col_10822);


var G__10824 = cljs.core.next(seq__10621_10815__$1);
var G__10825 = null;
var G__10826 = (0);
var G__10827 = (0);
seq__10621_10803 = G__10824;
chunk__10622_10804 = G__10825;
count__10623_10805 = G__10826;
i__10624_10806 = G__10827;
continue;
}
} else {
}
}
break;
}


var G__10828 = cljs.core.next(seq__10557_10794__$1);
var G__10829 = null;
var G__10830 = (0);
var G__10831 = (0);
seq__10557_10757 = G__10828;
chunk__10558_10758 = G__10829;
count__10559_10759 = G__10830;
i__10560_10760 = G__10831;
continue;
}
} else {
}
}
break;
}


var G__10832 = cljs.core.next(seq__10289_10746__$1);
var G__10833 = null;
var G__10834 = (0);
var G__10835 = (0);
seq__10289_10657 = G__10832;
chunk__10290_10658 = G__10833;
count__10291_10659 = G__10834;
i__10292_10660 = G__10835;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__10637 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__10282_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__10282_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__10283_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__10283_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__10284_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__10284_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__10638 = G__10637;
goog.object.set(G__10638,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts)));

return G__10638;
} else {
return G__10637;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__10836 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10836,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10836,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__10839 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10839,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10839,(1),null);
var G__10844 = cljs.core.next(col_map_seq);
var G__10845 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__10839,col,infos,vec__10836,line,col_map){
return (function (v,p__10842){
var map__10843 = p__10842;
var map__10843__$1 = cljs.core.__destructure_map(map__10843);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10843__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10843__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__10839,col,infos,vec__10836,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__10844;
new_cols = G__10845;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__10846 = cljs.core.next(line_map_seq);
var G__10847 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__10846;
new_lines = G__10847;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__10848_11056 = cljs.core.seq(reverse_map);
var chunk__10849_11057 = null;
var count__10850_11058 = (0);
var i__10851_11059 = (0);
while(true){
if((i__10851_11059 < count__10850_11058)){
var vec__10954_11060 = chunk__10849_11057.cljs$core$IIndexed$_nth$arity$2(null,i__10851_11059);
var line_11061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10954_11060,(0),null);
var columns_11062 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10954_11060,(1),null);
var seq__10957_11063 = cljs.core.seq(columns_11062);
var chunk__10958_11064 = null;
var count__10959_11065 = (0);
var i__10960_11066 = (0);
while(true){
if((i__10960_11066 < count__10959_11065)){
var vec__10983_11067 = chunk__10958_11064.cljs$core$IIndexed$_nth$arity$2(null,i__10960_11066);
var column_11068 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10983_11067,(0),null);
var column_info_11069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10983_11067,(1),null);
var seq__10986_11070 = cljs.core.seq(column_info_11069);
var chunk__10987_11071 = null;
var count__10988_11072 = (0);
var i__10989_11073 = (0);
while(true){
if((i__10989_11073 < count__10988_11072)){
var map__10992_11074 = chunk__10987_11071.cljs$core$IIndexed$_nth$arity$2(null,i__10989_11073);
var map__10992_11075__$1 = cljs.core.__destructure_map(map__10992_11074);
var gline_11076 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10992_11075__$1,cljs.core.cst$kw$gline);
var gcol_11077 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10992_11075__$1,cljs.core.cst$kw$gcol);
var name_11078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10992_11075__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11076], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__10986_11070,chunk__10987_11071,count__10988_11072,i__10989_11073,seq__10957_11063,chunk__10958_11064,count__10959_11065,i__10960_11066,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__10992_11074,map__10992_11075__$1,gline_11076,gcol_11077,name_11078,vec__10983_11067,column_11068,column_info_11069,vec__10954_11060,line_11061,columns_11062,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11077], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11061,cljs.core.cst$kw$col,column_11068,cljs.core.cst$kw$name,name_11078], null));
});})(seq__10986_11070,chunk__10987_11071,count__10988_11072,i__10989_11073,seq__10957_11063,chunk__10958_11064,count__10959_11065,i__10960_11066,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__10992_11074,map__10992_11075__$1,gline_11076,gcol_11077,name_11078,vec__10983_11067,column_11068,column_info_11069,vec__10954_11060,line_11061,columns_11062,inverted))
,cljs.core.sorted_map()));


var G__11079 = seq__10986_11070;
var G__11080 = chunk__10987_11071;
var G__11081 = count__10988_11072;
var G__11082 = (i__10989_11073 + (1));
seq__10986_11070 = G__11079;
chunk__10987_11071 = G__11080;
count__10988_11072 = G__11081;
i__10989_11073 = G__11082;
continue;
} else {
var temp__5753__auto___11083 = cljs.core.seq(seq__10986_11070);
if(temp__5753__auto___11083){
var seq__10986_11084__$1 = temp__5753__auto___11083;
if(cljs.core.chunked_seq_QMARK_(seq__10986_11084__$1)){
var c__4649__auto___11085 = cljs.core.chunk_first(seq__10986_11084__$1);
var G__11086 = cljs.core.chunk_rest(seq__10986_11084__$1);
var G__11087 = c__4649__auto___11085;
var G__11088 = cljs.core.count(c__4649__auto___11085);
var G__11089 = (0);
seq__10986_11070 = G__11086;
chunk__10987_11071 = G__11087;
count__10988_11072 = G__11088;
i__10989_11073 = G__11089;
continue;
} else {
var map__10993_11090 = cljs.core.first(seq__10986_11084__$1);
var map__10993_11091__$1 = cljs.core.__destructure_map(map__10993_11090);
var gline_11092 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10993_11091__$1,cljs.core.cst$kw$gline);
var gcol_11093 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10993_11091__$1,cljs.core.cst$kw$gcol);
var name_11094 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10993_11091__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11092], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__10986_11070,chunk__10987_11071,count__10988_11072,i__10989_11073,seq__10957_11063,chunk__10958_11064,count__10959_11065,i__10960_11066,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__10993_11090,map__10993_11091__$1,gline_11092,gcol_11093,name_11094,seq__10986_11084__$1,temp__5753__auto___11083,vec__10983_11067,column_11068,column_info_11069,vec__10954_11060,line_11061,columns_11062,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11093], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11061,cljs.core.cst$kw$col,column_11068,cljs.core.cst$kw$name,name_11094], null));
});})(seq__10986_11070,chunk__10987_11071,count__10988_11072,i__10989_11073,seq__10957_11063,chunk__10958_11064,count__10959_11065,i__10960_11066,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__10993_11090,map__10993_11091__$1,gline_11092,gcol_11093,name_11094,seq__10986_11084__$1,temp__5753__auto___11083,vec__10983_11067,column_11068,column_info_11069,vec__10954_11060,line_11061,columns_11062,inverted))
,cljs.core.sorted_map()));


var G__11095 = cljs.core.next(seq__10986_11084__$1);
var G__11096 = null;
var G__11097 = (0);
var G__11098 = (0);
seq__10986_11070 = G__11095;
chunk__10987_11071 = G__11096;
count__10988_11072 = G__11097;
i__10989_11073 = G__11098;
continue;
}
} else {
}
}
break;
}


var G__11099 = seq__10957_11063;
var G__11100 = chunk__10958_11064;
var G__11101 = count__10959_11065;
var G__11102 = (i__10960_11066 + (1));
seq__10957_11063 = G__11099;
chunk__10958_11064 = G__11100;
count__10959_11065 = G__11101;
i__10960_11066 = G__11102;
continue;
} else {
var temp__5753__auto___11103 = cljs.core.seq(seq__10957_11063);
if(temp__5753__auto___11103){
var seq__10957_11104__$1 = temp__5753__auto___11103;
if(cljs.core.chunked_seq_QMARK_(seq__10957_11104__$1)){
var c__4649__auto___11105 = cljs.core.chunk_first(seq__10957_11104__$1);
var G__11106 = cljs.core.chunk_rest(seq__10957_11104__$1);
var G__11107 = c__4649__auto___11105;
var G__11108 = cljs.core.count(c__4649__auto___11105);
var G__11109 = (0);
seq__10957_11063 = G__11106;
chunk__10958_11064 = G__11107;
count__10959_11065 = G__11108;
i__10960_11066 = G__11109;
continue;
} else {
var vec__10994_11110 = cljs.core.first(seq__10957_11104__$1);
var column_11111 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10994_11110,(0),null);
var column_info_11112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10994_11110,(1),null);
var seq__10997_11113 = cljs.core.seq(column_info_11112);
var chunk__10998_11114 = null;
var count__10999_11115 = (0);
var i__11000_11116 = (0);
while(true){
if((i__11000_11116 < count__10999_11115)){
var map__11003_11117 = chunk__10998_11114.cljs$core$IIndexed$_nth$arity$2(null,i__11000_11116);
var map__11003_11118__$1 = cljs.core.__destructure_map(map__11003_11117);
var gline_11119 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11003_11118__$1,cljs.core.cst$kw$gline);
var gcol_11120 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11003_11118__$1,cljs.core.cst$kw$gcol);
var name_11121 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11003_11118__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11119], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__10997_11113,chunk__10998_11114,count__10999_11115,i__11000_11116,seq__10957_11063,chunk__10958_11064,count__10959_11065,i__10960_11066,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__11003_11117,map__11003_11118__$1,gline_11119,gcol_11120,name_11121,vec__10994_11110,column_11111,column_info_11112,seq__10957_11104__$1,temp__5753__auto___11103,vec__10954_11060,line_11061,columns_11062,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11120], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11061,cljs.core.cst$kw$col,column_11111,cljs.core.cst$kw$name,name_11121], null));
});})(seq__10997_11113,chunk__10998_11114,count__10999_11115,i__11000_11116,seq__10957_11063,chunk__10958_11064,count__10959_11065,i__10960_11066,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__11003_11117,map__11003_11118__$1,gline_11119,gcol_11120,name_11121,vec__10994_11110,column_11111,column_info_11112,seq__10957_11104__$1,temp__5753__auto___11103,vec__10954_11060,line_11061,columns_11062,inverted))
,cljs.core.sorted_map()));


var G__11122 = seq__10997_11113;
var G__11123 = chunk__10998_11114;
var G__11124 = count__10999_11115;
var G__11125 = (i__11000_11116 + (1));
seq__10997_11113 = G__11122;
chunk__10998_11114 = G__11123;
count__10999_11115 = G__11124;
i__11000_11116 = G__11125;
continue;
} else {
var temp__5753__auto___11126__$1 = cljs.core.seq(seq__10997_11113);
if(temp__5753__auto___11126__$1){
var seq__10997_11127__$1 = temp__5753__auto___11126__$1;
if(cljs.core.chunked_seq_QMARK_(seq__10997_11127__$1)){
var c__4649__auto___11128 = cljs.core.chunk_first(seq__10997_11127__$1);
var G__11129 = cljs.core.chunk_rest(seq__10997_11127__$1);
var G__11130 = c__4649__auto___11128;
var G__11131 = cljs.core.count(c__4649__auto___11128);
var G__11132 = (0);
seq__10997_11113 = G__11129;
chunk__10998_11114 = G__11130;
count__10999_11115 = G__11131;
i__11000_11116 = G__11132;
continue;
} else {
var map__11004_11133 = cljs.core.first(seq__10997_11127__$1);
var map__11004_11134__$1 = cljs.core.__destructure_map(map__11004_11133);
var gline_11135 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11004_11134__$1,cljs.core.cst$kw$gline);
var gcol_11136 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11004_11134__$1,cljs.core.cst$kw$gcol);
var name_11137 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11004_11134__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11135], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__10997_11113,chunk__10998_11114,count__10999_11115,i__11000_11116,seq__10957_11063,chunk__10958_11064,count__10959_11065,i__10960_11066,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__11004_11133,map__11004_11134__$1,gline_11135,gcol_11136,name_11137,seq__10997_11127__$1,temp__5753__auto___11126__$1,vec__10994_11110,column_11111,column_info_11112,seq__10957_11104__$1,temp__5753__auto___11103,vec__10954_11060,line_11061,columns_11062,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11136], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11061,cljs.core.cst$kw$col,column_11111,cljs.core.cst$kw$name,name_11137], null));
});})(seq__10997_11113,chunk__10998_11114,count__10999_11115,i__11000_11116,seq__10957_11063,chunk__10958_11064,count__10959_11065,i__10960_11066,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__11004_11133,map__11004_11134__$1,gline_11135,gcol_11136,name_11137,seq__10997_11127__$1,temp__5753__auto___11126__$1,vec__10994_11110,column_11111,column_info_11112,seq__10957_11104__$1,temp__5753__auto___11103,vec__10954_11060,line_11061,columns_11062,inverted))
,cljs.core.sorted_map()));


var G__11138 = cljs.core.next(seq__10997_11127__$1);
var G__11139 = null;
var G__11140 = (0);
var G__11141 = (0);
seq__10997_11113 = G__11138;
chunk__10998_11114 = G__11139;
count__10999_11115 = G__11140;
i__11000_11116 = G__11141;
continue;
}
} else {
}
}
break;
}


var G__11142 = cljs.core.next(seq__10957_11104__$1);
var G__11143 = null;
var G__11144 = (0);
var G__11145 = (0);
seq__10957_11063 = G__11142;
chunk__10958_11064 = G__11143;
count__10959_11065 = G__11144;
i__10960_11066 = G__11145;
continue;
}
} else {
}
}
break;
}


var G__11146 = seq__10848_11056;
var G__11147 = chunk__10849_11057;
var G__11148 = count__10850_11058;
var G__11149 = (i__10851_11059 + (1));
seq__10848_11056 = G__11146;
chunk__10849_11057 = G__11147;
count__10850_11058 = G__11148;
i__10851_11059 = G__11149;
continue;
} else {
var temp__5753__auto___11150 = cljs.core.seq(seq__10848_11056);
if(temp__5753__auto___11150){
var seq__10848_11151__$1 = temp__5753__auto___11150;
if(cljs.core.chunked_seq_QMARK_(seq__10848_11151__$1)){
var c__4649__auto___11152 = cljs.core.chunk_first(seq__10848_11151__$1);
var G__11153 = cljs.core.chunk_rest(seq__10848_11151__$1);
var G__11154 = c__4649__auto___11152;
var G__11155 = cljs.core.count(c__4649__auto___11152);
var G__11156 = (0);
seq__10848_11056 = G__11153;
chunk__10849_11057 = G__11154;
count__10850_11058 = G__11155;
i__10851_11059 = G__11156;
continue;
} else {
var vec__11005_11157 = cljs.core.first(seq__10848_11151__$1);
var line_11158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11005_11157,(0),null);
var columns_11159 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11005_11157,(1),null);
var seq__11008_11160 = cljs.core.seq(columns_11159);
var chunk__11009_11161 = null;
var count__11010_11162 = (0);
var i__11011_11163 = (0);
while(true){
if((i__11011_11163 < count__11010_11162)){
var vec__11034_11164 = chunk__11009_11161.cljs$core$IIndexed$_nth$arity$2(null,i__11011_11163);
var column_11165 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11034_11164,(0),null);
var column_info_11166 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11034_11164,(1),null);
var seq__11037_11167 = cljs.core.seq(column_info_11166);
var chunk__11038_11168 = null;
var count__11039_11169 = (0);
var i__11040_11170 = (0);
while(true){
if((i__11040_11170 < count__11039_11169)){
var map__11043_11171 = chunk__11038_11168.cljs$core$IIndexed$_nth$arity$2(null,i__11040_11170);
var map__11043_11172__$1 = cljs.core.__destructure_map(map__11043_11171);
var gline_11173 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11043_11172__$1,cljs.core.cst$kw$gline);
var gcol_11174 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11043_11172__$1,cljs.core.cst$kw$gcol);
var name_11175 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11043_11172__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11173], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11037_11167,chunk__11038_11168,count__11039_11169,i__11040_11170,seq__11008_11160,chunk__11009_11161,count__11010_11162,i__11011_11163,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__11043_11171,map__11043_11172__$1,gline_11173,gcol_11174,name_11175,vec__11034_11164,column_11165,column_info_11166,vec__11005_11157,line_11158,columns_11159,seq__10848_11151__$1,temp__5753__auto___11150,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11174], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11158,cljs.core.cst$kw$col,column_11165,cljs.core.cst$kw$name,name_11175], null));
});})(seq__11037_11167,chunk__11038_11168,count__11039_11169,i__11040_11170,seq__11008_11160,chunk__11009_11161,count__11010_11162,i__11011_11163,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__11043_11171,map__11043_11172__$1,gline_11173,gcol_11174,name_11175,vec__11034_11164,column_11165,column_info_11166,vec__11005_11157,line_11158,columns_11159,seq__10848_11151__$1,temp__5753__auto___11150,inverted))
,cljs.core.sorted_map()));


var G__11176 = seq__11037_11167;
var G__11177 = chunk__11038_11168;
var G__11178 = count__11039_11169;
var G__11179 = (i__11040_11170 + (1));
seq__11037_11167 = G__11176;
chunk__11038_11168 = G__11177;
count__11039_11169 = G__11178;
i__11040_11170 = G__11179;
continue;
} else {
var temp__5753__auto___11180__$1 = cljs.core.seq(seq__11037_11167);
if(temp__5753__auto___11180__$1){
var seq__11037_11181__$1 = temp__5753__auto___11180__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11037_11181__$1)){
var c__4649__auto___11182 = cljs.core.chunk_first(seq__11037_11181__$1);
var G__11183 = cljs.core.chunk_rest(seq__11037_11181__$1);
var G__11184 = c__4649__auto___11182;
var G__11185 = cljs.core.count(c__4649__auto___11182);
var G__11186 = (0);
seq__11037_11167 = G__11183;
chunk__11038_11168 = G__11184;
count__11039_11169 = G__11185;
i__11040_11170 = G__11186;
continue;
} else {
var map__11044_11187 = cljs.core.first(seq__11037_11181__$1);
var map__11044_11188__$1 = cljs.core.__destructure_map(map__11044_11187);
var gline_11189 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11044_11188__$1,cljs.core.cst$kw$gline);
var gcol_11190 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11044_11188__$1,cljs.core.cst$kw$gcol);
var name_11191 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11044_11188__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11189], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11037_11167,chunk__11038_11168,count__11039_11169,i__11040_11170,seq__11008_11160,chunk__11009_11161,count__11010_11162,i__11011_11163,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__11044_11187,map__11044_11188__$1,gline_11189,gcol_11190,name_11191,seq__11037_11181__$1,temp__5753__auto___11180__$1,vec__11034_11164,column_11165,column_info_11166,vec__11005_11157,line_11158,columns_11159,seq__10848_11151__$1,temp__5753__auto___11150,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11190], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11158,cljs.core.cst$kw$col,column_11165,cljs.core.cst$kw$name,name_11191], null));
});})(seq__11037_11167,chunk__11038_11168,count__11039_11169,i__11040_11170,seq__11008_11160,chunk__11009_11161,count__11010_11162,i__11011_11163,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__11044_11187,map__11044_11188__$1,gline_11189,gcol_11190,name_11191,seq__11037_11181__$1,temp__5753__auto___11180__$1,vec__11034_11164,column_11165,column_info_11166,vec__11005_11157,line_11158,columns_11159,seq__10848_11151__$1,temp__5753__auto___11150,inverted))
,cljs.core.sorted_map()));


var G__11192 = cljs.core.next(seq__11037_11181__$1);
var G__11193 = null;
var G__11194 = (0);
var G__11195 = (0);
seq__11037_11167 = G__11192;
chunk__11038_11168 = G__11193;
count__11039_11169 = G__11194;
i__11040_11170 = G__11195;
continue;
}
} else {
}
}
break;
}


var G__11196 = seq__11008_11160;
var G__11197 = chunk__11009_11161;
var G__11198 = count__11010_11162;
var G__11199 = (i__11011_11163 + (1));
seq__11008_11160 = G__11196;
chunk__11009_11161 = G__11197;
count__11010_11162 = G__11198;
i__11011_11163 = G__11199;
continue;
} else {
var temp__5753__auto___11200__$1 = cljs.core.seq(seq__11008_11160);
if(temp__5753__auto___11200__$1){
var seq__11008_11201__$1 = temp__5753__auto___11200__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11008_11201__$1)){
var c__4649__auto___11202 = cljs.core.chunk_first(seq__11008_11201__$1);
var G__11203 = cljs.core.chunk_rest(seq__11008_11201__$1);
var G__11204 = c__4649__auto___11202;
var G__11205 = cljs.core.count(c__4649__auto___11202);
var G__11206 = (0);
seq__11008_11160 = G__11203;
chunk__11009_11161 = G__11204;
count__11010_11162 = G__11205;
i__11011_11163 = G__11206;
continue;
} else {
var vec__11045_11207 = cljs.core.first(seq__11008_11201__$1);
var column_11208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11045_11207,(0),null);
var column_info_11209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11045_11207,(1),null);
var seq__11048_11210 = cljs.core.seq(column_info_11209);
var chunk__11049_11211 = null;
var count__11050_11212 = (0);
var i__11051_11213 = (0);
while(true){
if((i__11051_11213 < count__11050_11212)){
var map__11054_11214 = chunk__11049_11211.cljs$core$IIndexed$_nth$arity$2(null,i__11051_11213);
var map__11054_11215__$1 = cljs.core.__destructure_map(map__11054_11214);
var gline_11216 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11054_11215__$1,cljs.core.cst$kw$gline);
var gcol_11217 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11054_11215__$1,cljs.core.cst$kw$gcol);
var name_11218 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11054_11215__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11216], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11048_11210,chunk__11049_11211,count__11050_11212,i__11051_11213,seq__11008_11160,chunk__11009_11161,count__11010_11162,i__11011_11163,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__11054_11214,map__11054_11215__$1,gline_11216,gcol_11217,name_11218,vec__11045_11207,column_11208,column_info_11209,seq__11008_11201__$1,temp__5753__auto___11200__$1,vec__11005_11157,line_11158,columns_11159,seq__10848_11151__$1,temp__5753__auto___11150,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11217], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11158,cljs.core.cst$kw$col,column_11208,cljs.core.cst$kw$name,name_11218], null));
});})(seq__11048_11210,chunk__11049_11211,count__11050_11212,i__11051_11213,seq__11008_11160,chunk__11009_11161,count__11010_11162,i__11011_11163,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__11054_11214,map__11054_11215__$1,gline_11216,gcol_11217,name_11218,vec__11045_11207,column_11208,column_info_11209,seq__11008_11201__$1,temp__5753__auto___11200__$1,vec__11005_11157,line_11158,columns_11159,seq__10848_11151__$1,temp__5753__auto___11150,inverted))
,cljs.core.sorted_map()));


var G__11219 = seq__11048_11210;
var G__11220 = chunk__11049_11211;
var G__11221 = count__11050_11212;
var G__11222 = (i__11051_11213 + (1));
seq__11048_11210 = G__11219;
chunk__11049_11211 = G__11220;
count__11050_11212 = G__11221;
i__11051_11213 = G__11222;
continue;
} else {
var temp__5753__auto___11223__$2 = cljs.core.seq(seq__11048_11210);
if(temp__5753__auto___11223__$2){
var seq__11048_11224__$1 = temp__5753__auto___11223__$2;
if(cljs.core.chunked_seq_QMARK_(seq__11048_11224__$1)){
var c__4649__auto___11225 = cljs.core.chunk_first(seq__11048_11224__$1);
var G__11226 = cljs.core.chunk_rest(seq__11048_11224__$1);
var G__11227 = c__4649__auto___11225;
var G__11228 = cljs.core.count(c__4649__auto___11225);
var G__11229 = (0);
seq__11048_11210 = G__11226;
chunk__11049_11211 = G__11227;
count__11050_11212 = G__11228;
i__11051_11213 = G__11229;
continue;
} else {
var map__11055_11230 = cljs.core.first(seq__11048_11224__$1);
var map__11055_11231__$1 = cljs.core.__destructure_map(map__11055_11230);
var gline_11232 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11055_11231__$1,cljs.core.cst$kw$gline);
var gcol_11233 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11055_11231__$1,cljs.core.cst$kw$gcol);
var name_11234 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11055_11231__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_11232], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__11048_11210,chunk__11049_11211,count__11050_11212,i__11051_11213,seq__11008_11160,chunk__11009_11161,count__11010_11162,i__11011_11163,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__11055_11230,map__11055_11231__$1,gline_11232,gcol_11233,name_11234,seq__11048_11224__$1,temp__5753__auto___11223__$2,vec__11045_11207,column_11208,column_info_11209,seq__11008_11201__$1,temp__5753__auto___11200__$1,vec__11005_11157,line_11158,columns_11159,seq__10848_11151__$1,temp__5753__auto___11150,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_11233], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_11158,cljs.core.cst$kw$col,column_11208,cljs.core.cst$kw$name,name_11234], null));
});})(seq__11048_11210,chunk__11049_11211,count__11050_11212,i__11051_11213,seq__11008_11160,chunk__11009_11161,count__11010_11162,i__11011_11163,seq__10848_11056,chunk__10849_11057,count__10850_11058,i__10851_11059,map__11055_11230,map__11055_11231__$1,gline_11232,gcol_11233,name_11234,seq__11048_11224__$1,temp__5753__auto___11223__$2,vec__11045_11207,column_11208,column_info_11209,seq__11008_11201__$1,temp__5753__auto___11200__$1,vec__11005_11157,line_11158,columns_11159,seq__10848_11151__$1,temp__5753__auto___11150,inverted))
,cljs.core.sorted_map()));


var G__11235 = cljs.core.next(seq__11048_11224__$1);
var G__11236 = null;
var G__11237 = (0);
var G__11238 = (0);
seq__11048_11210 = G__11235;
chunk__11049_11211 = G__11236;
count__11050_11212 = G__11237;
i__11051_11213 = G__11238;
continue;
}
} else {
}
}
break;
}


var G__11239 = cljs.core.next(seq__11008_11201__$1);
var G__11240 = null;
var G__11241 = (0);
var G__11242 = (0);
seq__11008_11160 = G__11239;
chunk__11009_11161 = G__11240;
count__11010_11162 = G__11241;
i__11011_11163 = G__11242;
continue;
}
} else {
}
}
break;
}


var G__11243 = cljs.core.next(seq__10848_11151__$1);
var G__11244 = null;
var G__11245 = (0);
var G__11246 = (0);
seq__10848_11056 = G__11243;
chunk__10849_11057 = G__11244;
count__10850_11058 = G__11245;
i__10851_11059 = G__11246;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
