// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__11265 = s;
var map__11265__$1 = cljs.core.__destructure_map(map__11265);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11265__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11265__$1,cljs.core.cst$kw$info);
var d = (0);
var G__11267 = info;
var map__11268 = G__11267;
var map__11268__$1 = cljs.core.__destructure_map(map__11268);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11268__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__11267__$1 = G__11267;
while(true){
var d__$2 = d__$1;
var map__11270 = G__11267__$1;
var map__11270__$1 = cljs.core.__destructure_map(map__11270);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11270__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__11271 = (d__$2 + (1));
var G__11272 = shadow__$1;
d__$1 = G__11271;
G__11267__$1 = G__11272;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__11273){
var map__11274 = p__11273;
var map__11274__$1 = cljs.core.__destructure_map(map__11274);
var name_var = map__11274__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11274__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11274__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__11275 = info;
var map__11275__$1 = cljs.core.__destructure_map(map__11275);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11275__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11275__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__11276 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__11276) : cljs.compiler.munge.call(null,G__11276));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__11278 = arguments.length;
switch (G__11278) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__11279 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",25,1,11639,11639,cljs.core.cst$sym$string,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__11279.cljs$core$IFn$_invoke$arity$1 ? fexpr__11279.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__11279.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__11281 = cp;
switch (G__11281) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__11283_11287 = cljs.core.seq(s);
var chunk__11284_11288 = null;
var count__11285_11289 = (0);
var i__11286_11290 = (0);
while(true){
if((i__11286_11290 < count__11285_11289)){
var c_11291 = chunk__11284_11288.cljs$core$IIndexed$_nth$arity$2(null,i__11286_11290);
sb.append(cljs.compiler.escape_char(c_11291));


var G__11292 = seq__11283_11287;
var G__11293 = chunk__11284_11288;
var G__11294 = count__11285_11289;
var G__11295 = (i__11286_11290 + (1));
seq__11283_11287 = G__11292;
chunk__11284_11288 = G__11293;
count__11285_11289 = G__11294;
i__11286_11290 = G__11295;
continue;
} else {
var temp__5753__auto___11296 = cljs.core.seq(seq__11283_11287);
if(temp__5753__auto___11296){
var seq__11283_11297__$1 = temp__5753__auto___11296;
if(cljs.core.chunked_seq_QMARK_(seq__11283_11297__$1)){
var c__4649__auto___11298 = cljs.core.chunk_first(seq__11283_11297__$1);
var G__11299 = cljs.core.chunk_rest(seq__11283_11297__$1);
var G__11300 = c__4649__auto___11298;
var G__11301 = cljs.core.count(c__4649__auto___11298);
var G__11302 = (0);
seq__11283_11287 = G__11299;
chunk__11284_11288 = G__11300;
count__11285_11289 = G__11301;
i__11286_11290 = G__11302;
continue;
} else {
var c_11303 = cljs.core.first(seq__11283_11297__$1);
sb.append(cljs.compiler.escape_char(c_11303));


var G__11304 = cljs.core.next(seq__11283_11297__$1);
var G__11305 = null;
var G__11306 = (0);
var G__11307 = (0);
seq__11283_11287 = G__11304;
chunk__11284_11288 = G__11305;
count__11285_11289 = G__11306;
i__11286_11290 = G__11307;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__11308 = cljs.core.get_global_hierarchy;
return (fexpr__11308.cljs$core$IFn$_invoke$arity$0 ? fexpr__11308.cljs$core$IFn$_invoke$arity$0() : fexpr__11308.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__11309_11314 = ast;
var map__11309_11315__$1 = cljs.core.__destructure_map(map__11309_11314);
var env_11316 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11309_11315__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_11316))){
var map__11310_11317 = env_11316;
var map__11310_11318__$1 = cljs.core.__destructure_map(map__11310_11317);
var line_11319 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11310_11318__$1,cljs.core.cst$kw$line);
var column_11320 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11310_11318__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__11311 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__11313 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__11312 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__11312.cljs$core$IFn$_invoke$arity$1 ? fexpr__11312.cljs$core$IFn$_invoke$arity$1(G__11313) : fexpr__11312.call(null,G__11313));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__11311,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__11311;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_11319 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_11320)?(column_11320 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__11329 = arguments.length;
switch (G__11329) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4850__auto__ = [];
var len__4829__auto___11336 = arguments.length;
var i__4830__auto___11337 = (0);
while(true){
if((i__4830__auto___11337 < len__4829__auto___11336)){
args_arr__4850__auto__.push((arguments[i__4830__auto___11337]));

var G__11338 = (i__4830__auto___11337 + (1));
i__4830__auto___11337 = G__11338;
continue;
} else {
}
break;
}

var argseq__4851__auto__ = (new cljs.core.IndexedSeq(args_arr__4850__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4851__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_11339 = (function (){var G__11330 = a;
if((!(typeof a === 'string'))){
return G__11330.toString();
} else {
return G__11330;
}
})();
var temp__5757__auto___11340 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___11340 == null)){
} else {
var sm_data_11341 = temp__5757__auto___11340;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_11341,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,(function (p1__11321_SHARP_){
return (p1__11321_SHARP_ + s_11339.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_11339], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__11331 = cljs.core.seq(xs);
var chunk__11332 = null;
var count__11333 = (0);
var i__11334 = (0);
while(true){
if((i__11334 < count__11333)){
var x = chunk__11332.cljs$core$IIndexed$_nth$arity$2(null,i__11334);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__11342 = seq__11331;
var G__11343 = chunk__11332;
var G__11344 = count__11333;
var G__11345 = (i__11334 + (1));
seq__11331 = G__11342;
chunk__11332 = G__11343;
count__11333 = G__11344;
i__11334 = G__11345;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__11331);
if(temp__5753__auto__){
var seq__11331__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11331__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__11331__$1);
var G__11346 = cljs.core.chunk_rest(seq__11331__$1);
var G__11347 = c__4649__auto__;
var G__11348 = cljs.core.count(c__4649__auto__);
var G__11349 = (0);
seq__11331 = G__11346;
chunk__11332 = G__11347;
count__11333 = G__11348;
i__11334 = G__11349;
continue;
} else {
var x = cljs.core.first(seq__11331__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__11350 = cljs.core.next(seq__11331__$1);
var G__11351 = null;
var G__11352 = (0);
var G__11353 = (0);
seq__11331 = G__11350;
chunk__11332 = G__11351;
count__11333 = G__11352;
i__11334 = G__11353;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq11323){
var G__11324 = cljs.core.first(seq11323);
var seq11323__$1 = cljs.core.next(seq11323);
var G__11325 = cljs.core.first(seq11323__$1);
var seq11323__$2 = cljs.core.next(seq11323__$1);
var G__11326 = cljs.core.first(seq11323__$2);
var seq11323__$3 = cljs.core.next(seq11323__$2);
var G__11327 = cljs.core.first(seq11323__$3);
var seq11323__$4 = cljs.core.next(seq11323__$3);
var G__11328 = cljs.core.first(seq11323__$4);
var seq11323__$5 = cljs.core.next(seq11323__$4);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11324,G__11325,G__11326,G__11327,G__11328,seq11323__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__11354){
var map__11355 = p__11354;
var map__11355__$1 = cljs.core.__destructure_map(map__11355);
var m = map__11355__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11355__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__11363 = arguments.length;
switch (G__11363) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4850__auto__ = [];
var len__4829__auto___11369 = arguments.length;
var i__4830__auto___11370 = (0);
while(true){
if((i__4830__auto___11370 < len__4829__auto___11369)){
args_arr__4850__auto__.push((arguments[i__4830__auto___11370]));

var G__11371 = (i__4830__auto___11370 + (1));
i__4830__auto___11370 = G__11371;
continue;
} else {
}
break;
}

var argseq__4851__auto__ = (new cljs.core.IndexedSeq(args_arr__4850__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4851__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__11364_11372 = cljs.core.seq(xs);
var chunk__11365_11373 = null;
var count__11366_11374 = (0);
var i__11367_11375 = (0);
while(true){
if((i__11367_11375 < count__11366_11374)){
var x_11376 = chunk__11365_11373.cljs$core$IIndexed$_nth$arity$2(null,i__11367_11375);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_11376);


var G__11377 = seq__11364_11372;
var G__11378 = chunk__11365_11373;
var G__11379 = count__11366_11374;
var G__11380 = (i__11367_11375 + (1));
seq__11364_11372 = G__11377;
chunk__11365_11373 = G__11378;
count__11366_11374 = G__11379;
i__11367_11375 = G__11380;
continue;
} else {
var temp__5753__auto___11381 = cljs.core.seq(seq__11364_11372);
if(temp__5753__auto___11381){
var seq__11364_11382__$1 = temp__5753__auto___11381;
if(cljs.core.chunked_seq_QMARK_(seq__11364_11382__$1)){
var c__4649__auto___11383 = cljs.core.chunk_first(seq__11364_11382__$1);
var G__11384 = cljs.core.chunk_rest(seq__11364_11382__$1);
var G__11385 = c__4649__auto___11383;
var G__11386 = cljs.core.count(c__4649__auto___11383);
var G__11387 = (0);
seq__11364_11372 = G__11384;
chunk__11365_11373 = G__11385;
count__11366_11374 = G__11386;
i__11367_11375 = G__11387;
continue;
} else {
var x_11388 = cljs.core.first(seq__11364_11382__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_11388);


var G__11389 = cljs.core.next(seq__11364_11382__$1);
var G__11390 = null;
var G__11391 = (0);
var G__11392 = (0);
seq__11364_11372 = G__11389;
chunk__11365_11373 = G__11390;
count__11366_11374 = G__11391;
i__11367_11375 = G__11392;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq11357){
var G__11358 = cljs.core.first(seq11357);
var seq11357__$1 = cljs.core.next(seq11357);
var G__11359 = cljs.core.first(seq11357__$1);
var seq11357__$2 = cljs.core.next(seq11357__$1);
var G__11360 = cljs.core.first(seq11357__$2);
var seq11357__$3 = cljs.core.next(seq11357__$2);
var G__11361 = cljs.core.first(seq11357__$3);
var seq11357__$4 = cljs.core.next(seq11357__$3);
var G__11362 = cljs.core.first(seq11357__$4);
var seq11357__$5 = cljs.core.next(seq11357__$4);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11358,G__11359,G__11360,G__11361,G__11362,seq11357__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4760__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__11393_11397 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__11394_11398 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__11395_11399 = true;
var _STAR_print_fn_STAR__temp_val__11396_11400 = (function (x__4761__auto__){
return sb__4760__auto__.append(x__4761__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__11395_11399);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__11396_11400);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__11394_11398);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__11393_11397);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4760__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__11401 = cljs.core.get_global_hierarchy;
return (fexpr__11401.cljs$core$IFn$_invoke$arity$0 ? fexpr__11401.cljs$core$IFn$_invoke$arity$0() : fexpr__11401.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__11402 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11402,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11402,(1),null);
var G__11405 = ns;
var G__11406 = name;
var G__11407 = (function (){
var G__11408 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__11408) : cljs.compiler.emit_constant.call(null,G__11408));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__11405,G__11406,G__11407) : cljs.compiler.emit_record_value.call(null,G__11405,G__11406,G__11407));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__11409 = cljs.core.keys(x);
var G__11410 = cljs.core.vals(x);
var G__11411 = cljs.compiler.emit_constants_comma_sep;
var G__11412 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__11409,G__11410,G__11411,G__11412) : cljs.compiler.emit_map.call(null,G__11409,G__11410,G__11411,G__11412));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__11413 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__11414 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__11413,G__11414) : cljs.compiler.emit_with_meta.call(null,G__11413,G__11414));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__11415 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11415,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11415,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11415,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4221__auto__)){
var G__11418 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__11418) : x.call(null,G__11418));
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4221__auto__)){
var G__11419 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__11419) : x.call(null,G__11419));
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__11421 = items;
var G__11422 = (function (p1__11420_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__11420_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__11421,G__11422) : cljs.compiler.emit_js_object.call(null,G__11421,G__11422));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__11424){
var map__11425 = p__11424;
var map__11425__$1 = cljs.core.__destructure_map(map__11425);
var ast = map__11425__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11425__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11425__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11425__$1,cljs.core.cst$kw$form);
var temp__5751__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__11426 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__11426__$1 = cljs.core.__destructure_map(map__11426);
var cenv = map__11426__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11426__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__4223__auto__ = js_module_name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__11427 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4221__auto__ = (function (){var G__11428 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__11428) : cljs.compiler.es5_GT__EQ_.call(null,G__11428));
})();
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4221__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__11427,cljs.analyzer.es5_allowed);
} else {
return G__11427;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__4223__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__11429 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__11429,reserved);
} else {
return G__11429;
}
})();
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__11430_11431 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__11430_11432__$1 = (((G__11430_11431 instanceof cljs.core.Keyword))?G__11430_11431.fqn:null);
switch (G__11430_11432__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4221__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__11434){
var map__11435 = p__11434;
var map__11435__$1 = cljs.core.__destructure_map(map__11435);
var arg = map__11435__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11435__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11435__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11435__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11435__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__11436 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__11436__$1 = cljs.core.__destructure_map(map__11436);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11436__$1,cljs.core.cst$kw$name);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__11437){
var map__11438 = p__11437;
var map__11438__$1 = cljs.core.__destructure_map(map__11438);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11438__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11438__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11438__$1,cljs.core.cst$kw$env);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__11439_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__11439_SHARP_),cljs.core.cst$kw$const);
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__11440 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11440) : comma_sep.call(null,G__11440));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__11441 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11441) : comma_sep.call(null,G__11441));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__11442){
var map__11443 = p__11442;
var map__11443__$1 = cljs.core.__destructure_map(map__11443);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11443__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11443__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11443__$1,cljs.core.cst$kw$vals);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__11444){
var map__11445 = p__11444;
var map__11445__$1 = cljs.core.__destructure_map(map__11445);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11445__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11445__$1,cljs.core.cst$kw$env);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__11446_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__11446_SHARP_),cljs.core.cst$kw$const);
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__11447 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11447) : comma_sep.call(null,G__11447));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__11448){
var map__11449 = p__11448;
var map__11449__$1 = cljs.core.__destructure_map(map__11449);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11449__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11449__$1,cljs.core.cst$kw$env);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5753__auto___11472 = cljs.core.seq(items);
if(temp__5753__auto___11472){
var items_11473__$1 = temp__5753__auto___11472;
var vec__11450_11474 = items_11473__$1;
var seq__11451_11475 = cljs.core.seq(vec__11450_11474);
var first__11452_11476 = cljs.core.first(seq__11451_11475);
var seq__11451_11477__$1 = cljs.core.next(seq__11451_11475);
var vec__11453_11478 = first__11452_11476;
var k_11479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11453_11478,(0),null);
var v_11480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11453_11478,(1),null);
var r_11481 = seq__11451_11477__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_11479),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11480) : emit_js_object_val.call(null,v_11480)));

var seq__11456_11482 = cljs.core.seq(r_11481);
var chunk__11457_11483 = null;
var count__11458_11484 = (0);
var i__11459_11485 = (0);
while(true){
if((i__11459_11485 < count__11458_11484)){
var vec__11466_11486 = chunk__11457_11483.cljs$core$IIndexed$_nth$arity$2(null,i__11459_11485);
var k_11487__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11466_11486,(0),null);
var v_11488__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11466_11486,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_11487__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11488__$1) : emit_js_object_val.call(null,v_11488__$1)));


var G__11489 = seq__11456_11482;
var G__11490 = chunk__11457_11483;
var G__11491 = count__11458_11484;
var G__11492 = (i__11459_11485 + (1));
seq__11456_11482 = G__11489;
chunk__11457_11483 = G__11490;
count__11458_11484 = G__11491;
i__11459_11485 = G__11492;
continue;
} else {
var temp__5753__auto___11493__$1 = cljs.core.seq(seq__11456_11482);
if(temp__5753__auto___11493__$1){
var seq__11456_11494__$1 = temp__5753__auto___11493__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11456_11494__$1)){
var c__4649__auto___11495 = cljs.core.chunk_first(seq__11456_11494__$1);
var G__11496 = cljs.core.chunk_rest(seq__11456_11494__$1);
var G__11497 = c__4649__auto___11495;
var G__11498 = cljs.core.count(c__4649__auto___11495);
var G__11499 = (0);
seq__11456_11482 = G__11496;
chunk__11457_11483 = G__11497;
count__11458_11484 = G__11498;
i__11459_11485 = G__11499;
continue;
} else {
var vec__11469_11500 = cljs.core.first(seq__11456_11494__$1);
var k_11501__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11469_11500,(0),null);
var v_11502__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11469_11500,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_11501__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11502__$1) : emit_js_object_val.call(null,v_11502__$1)));


var G__11503 = cljs.core.next(seq__11456_11494__$1);
var G__11504 = null;
var G__11505 = (0);
var G__11506 = (0);
seq__11456_11482 = G__11503;
chunk__11457_11483 = G__11504;
count__11458_11484 = G__11505;
i__11459_11485 = G__11506;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__11507){
var map__11508 = p__11507;
var map__11508__$1 = cljs.core.__destructure_map(map__11508);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11508__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11508__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11508__$1,cljs.core.cst$kw$env);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__11509){
var map__11510 = p__11509;
var map__11510__$1 = cljs.core.__destructure_map(map__11510);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11510__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11510__$1,cljs.core.cst$kw$env);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__11511){
var map__11512 = p__11511;
var map__11512__$1 = cljs.core.__destructure_map(map__11512);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11512__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__11513){
var map__11514 = p__11513;
var map__11514__$1 = cljs.core.__destructure_map(map__11514);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11514__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11514__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__11515 = cljs.analyzer.unwrap_quote(expr);
var map__11515__$1 = cljs.core.__destructure_map(map__11515);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11515__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11515__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11515__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4223__auto__ = (function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const);
if(and__4221__auto__){
var and__4221__auto____$1 = form;
if(cljs.core.truth_(and__4221__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = (!((const_expr == null)));
if(and__4221__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4221__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__11516 = cljs.analyzer.unwrap_quote(expr);
var map__11516__$1 = cljs.core.__destructure_map(map__11516);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11516__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11516__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11516__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4223__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = (!((const_expr == null)));
if(and__4221__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4221__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4223__auto__ = (function (){var fexpr__11517 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__11517.cljs$core$IFn$_invoke$arity$1 ? fexpr__11517.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__11517.call(null,tag));
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__11518){
var map__11519 = p__11518;
var map__11519__$1 = cljs.core.__destructure_map(map__11519);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11519__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11519__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11519__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11519__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11519__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4223__auto__ = unchecked;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__11520){
var map__11521 = p__11520;
var map__11521__$1 = cljs.core.__destructure_map(map__11521);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11521__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11521__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11521__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11521__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__11522_11550 = cljs.core.seq(nodes);
var chunk__11523_11551 = null;
var count__11524_11552 = (0);
var i__11525_11553 = (0);
while(true){
if((i__11525_11553 < count__11524_11552)){
var map__11538_11554 = chunk__11523_11551.cljs$core$IIndexed$_nth$arity$2(null,i__11525_11553);
var map__11538_11555__$1 = cljs.core.__destructure_map(map__11538_11554);
var ts_11556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11538_11555__$1,cljs.core.cst$kw$tests);
var map__11539_11557 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11538_11555__$1,cljs.core.cst$kw$then);
var map__11539_11558__$1 = cljs.core.__destructure_map(map__11539_11557);
var then_11559 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11539_11558__$1,cljs.core.cst$kw$then);
var seq__11540_11560 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_11556));
var chunk__11541_11561 = null;
var count__11542_11562 = (0);
var i__11543_11563 = (0);
while(true){
if((i__11543_11563 < count__11542_11562)){
var test_11564 = chunk__11541_11561.cljs$core$IIndexed$_nth$arity$2(null,i__11543_11563);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11564,":");


var G__11565 = seq__11540_11560;
var G__11566 = chunk__11541_11561;
var G__11567 = count__11542_11562;
var G__11568 = (i__11543_11563 + (1));
seq__11540_11560 = G__11565;
chunk__11541_11561 = G__11566;
count__11542_11562 = G__11567;
i__11543_11563 = G__11568;
continue;
} else {
var temp__5753__auto___11569 = cljs.core.seq(seq__11540_11560);
if(temp__5753__auto___11569){
var seq__11540_11570__$1 = temp__5753__auto___11569;
if(cljs.core.chunked_seq_QMARK_(seq__11540_11570__$1)){
var c__4649__auto___11571 = cljs.core.chunk_first(seq__11540_11570__$1);
var G__11572 = cljs.core.chunk_rest(seq__11540_11570__$1);
var G__11573 = c__4649__auto___11571;
var G__11574 = cljs.core.count(c__4649__auto___11571);
var G__11575 = (0);
seq__11540_11560 = G__11572;
chunk__11541_11561 = G__11573;
count__11542_11562 = G__11574;
i__11543_11563 = G__11575;
continue;
} else {
var test_11576 = cljs.core.first(seq__11540_11570__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11576,":");


var G__11577 = cljs.core.next(seq__11540_11570__$1);
var G__11578 = null;
var G__11579 = (0);
var G__11580 = (0);
seq__11540_11560 = G__11577;
chunk__11541_11561 = G__11578;
count__11542_11562 = G__11579;
i__11543_11563 = G__11580;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_11559);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_11559);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__11581 = seq__11522_11550;
var G__11582 = chunk__11523_11551;
var G__11583 = count__11524_11552;
var G__11584 = (i__11525_11553 + (1));
seq__11522_11550 = G__11581;
chunk__11523_11551 = G__11582;
count__11524_11552 = G__11583;
i__11525_11553 = G__11584;
continue;
} else {
var temp__5753__auto___11585 = cljs.core.seq(seq__11522_11550);
if(temp__5753__auto___11585){
var seq__11522_11586__$1 = temp__5753__auto___11585;
if(cljs.core.chunked_seq_QMARK_(seq__11522_11586__$1)){
var c__4649__auto___11587 = cljs.core.chunk_first(seq__11522_11586__$1);
var G__11588 = cljs.core.chunk_rest(seq__11522_11586__$1);
var G__11589 = c__4649__auto___11587;
var G__11590 = cljs.core.count(c__4649__auto___11587);
var G__11591 = (0);
seq__11522_11550 = G__11588;
chunk__11523_11551 = G__11589;
count__11524_11552 = G__11590;
i__11525_11553 = G__11591;
continue;
} else {
var map__11544_11592 = cljs.core.first(seq__11522_11586__$1);
var map__11544_11593__$1 = cljs.core.__destructure_map(map__11544_11592);
var ts_11594 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11544_11593__$1,cljs.core.cst$kw$tests);
var map__11545_11595 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11544_11593__$1,cljs.core.cst$kw$then);
var map__11545_11596__$1 = cljs.core.__destructure_map(map__11545_11595);
var then_11597 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11545_11596__$1,cljs.core.cst$kw$then);
var seq__11546_11598 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_11594));
var chunk__11547_11599 = null;
var count__11548_11600 = (0);
var i__11549_11601 = (0);
while(true){
if((i__11549_11601 < count__11548_11600)){
var test_11602 = chunk__11547_11599.cljs$core$IIndexed$_nth$arity$2(null,i__11549_11601);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11602,":");


var G__11603 = seq__11546_11598;
var G__11604 = chunk__11547_11599;
var G__11605 = count__11548_11600;
var G__11606 = (i__11549_11601 + (1));
seq__11546_11598 = G__11603;
chunk__11547_11599 = G__11604;
count__11548_11600 = G__11605;
i__11549_11601 = G__11606;
continue;
} else {
var temp__5753__auto___11607__$1 = cljs.core.seq(seq__11546_11598);
if(temp__5753__auto___11607__$1){
var seq__11546_11608__$1 = temp__5753__auto___11607__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11546_11608__$1)){
var c__4649__auto___11609 = cljs.core.chunk_first(seq__11546_11608__$1);
var G__11610 = cljs.core.chunk_rest(seq__11546_11608__$1);
var G__11611 = c__4649__auto___11609;
var G__11612 = cljs.core.count(c__4649__auto___11609);
var G__11613 = (0);
seq__11546_11598 = G__11610;
chunk__11547_11599 = G__11611;
count__11548_11600 = G__11612;
i__11549_11601 = G__11613;
continue;
} else {
var test_11614 = cljs.core.first(seq__11546_11608__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11614,":");


var G__11615 = cljs.core.next(seq__11546_11608__$1);
var G__11616 = null;
var G__11617 = (0);
var G__11618 = (0);
seq__11546_11598 = G__11615;
chunk__11547_11599 = G__11616;
count__11548_11600 = G__11617;
i__11549_11601 = G__11618;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_11597);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_11597);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__11619 = cljs.core.next(seq__11522_11586__$1);
var G__11620 = null;
var G__11621 = (0);
var G__11622 = (0);
seq__11522_11550 = G__11619;
chunk__11523_11551 = G__11620;
count__11524_11552 = G__11621;
i__11525_11553 = G__11622;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__11623){
var map__11624 = p__11623;
var map__11624__$1 = cljs.core.__destructure_map(map__11624);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11624__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11624__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__11628 = env;
var G__11629 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__11628,G__11629) : cljs.compiler.resolve_type.call(null,G__11628,G__11629));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__11630 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11630,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11630,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__11625_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__11625_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__11625_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__11633 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__11633,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__11633;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__11636 = env;
var G__11637 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__11636,G__11637) : cljs.compiler.resolve_type.call(null,G__11636,G__11637));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11638_SHARP_){
return cljs.compiler.resolve_type(env,p1__11638_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__11639 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__11640 = cljs.core.seq(vec__11639);
var first__11641 = cljs.core.first(seq__11640);
var seq__11640__$1 = cljs.core.next(seq__11640);
var p = first__11641;
var first__11641__$1 = cljs.core.first(seq__11640__$1);
var seq__11640__$2 = cljs.core.next(seq__11640__$1);
var ts = first__11641__$1;
var first__11641__$2 = cljs.core.first(seq__11640__$2);
var seq__11640__$3 = cljs.core.next(seq__11640__$2);
var n = first__11641__$2;
var xs = seq__11640__$3;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4221__auto__){
var and__4221__auto____$1 = ts;
if(cljs.core.truth_(and__4221__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__11642 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__11643 = cljs.core.seq(vec__11642);
var first__11644 = cljs.core.first(seq__11643);
var seq__11643__$1 = cljs.core.next(seq__11643);
var p = first__11644;
var first__11644__$1 = cljs.core.first(seq__11643__$1);
var seq__11643__$2 = cljs.core.next(seq__11643__$1);
var ts = first__11644__$1;
var xs = seq__11643__$2;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4221__auto__){
var and__4221__auto____$1 = ts;
if(cljs.core.truth_(and__4221__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__11646 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__11645 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__11645.cljs$core$IFn$_invoke$arity$1 ? fexpr__11645.cljs$core$IFn$_invoke$arity$1(G__11646) : fexpr__11645.call(null,G__11646));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__11649 = arguments.length;
switch (G__11649) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__11657 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11647_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__11647_SHARP_);
} else {
return p1__11647_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__11658 = cljs.core.seq(vec__11657);
var first__11659 = cljs.core.first(seq__11658);
var seq__11658__$1 = cljs.core.next(seq__11658);
var x = first__11659;
var ys = seq__11658__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__11660 = cljs.core.seq(ys);
var chunk__11661 = null;
var count__11662 = (0);
var i__11663 = (0);
while(true){
if((i__11663 < count__11662)){
var next_line = chunk__11661.cljs$core$IIndexed$_nth$arity$2(null,i__11663);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__11669 = seq__11660;
var G__11670 = chunk__11661;
var G__11671 = count__11662;
var G__11672 = (i__11663 + (1));
seq__11660 = G__11669;
chunk__11661 = G__11670;
count__11662 = G__11671;
i__11663 = G__11672;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__11660);
if(temp__5753__auto__){
var seq__11660__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11660__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__11660__$1);
var G__11673 = cljs.core.chunk_rest(seq__11660__$1);
var G__11674 = c__4649__auto__;
var G__11675 = cljs.core.count(c__4649__auto__);
var G__11676 = (0);
seq__11660 = G__11673;
chunk__11661 = G__11674;
count__11662 = G__11675;
i__11663 = G__11676;
continue;
} else {
var next_line = cljs.core.first(seq__11660__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__11677 = cljs.core.next(seq__11660__$1);
var G__11678 = null;
var G__11679 = (0);
var G__11680 = (0);
seq__11660 = G__11677;
chunk__11661 = G__11678;
count__11662 = G__11679;
i__11663 = G__11680;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__11664_11681 = cljs.core.seq(docs__$2);
var chunk__11665_11682 = null;
var count__11666_11683 = (0);
var i__11667_11684 = (0);
while(true){
if((i__11667_11684 < count__11666_11683)){
var e_11685 = chunk__11665_11682.cljs$core$IIndexed$_nth$arity$2(null,i__11667_11684);
if(cljs.core.truth_(e_11685)){
print_comment_lines(e_11685);
} else {
}


var G__11686 = seq__11664_11681;
var G__11687 = chunk__11665_11682;
var G__11688 = count__11666_11683;
var G__11689 = (i__11667_11684 + (1));
seq__11664_11681 = G__11686;
chunk__11665_11682 = G__11687;
count__11666_11683 = G__11688;
i__11667_11684 = G__11689;
continue;
} else {
var temp__5753__auto___11690 = cljs.core.seq(seq__11664_11681);
if(temp__5753__auto___11690){
var seq__11664_11691__$1 = temp__5753__auto___11690;
if(cljs.core.chunked_seq_QMARK_(seq__11664_11691__$1)){
var c__4649__auto___11692 = cljs.core.chunk_first(seq__11664_11691__$1);
var G__11693 = cljs.core.chunk_rest(seq__11664_11691__$1);
var G__11694 = c__4649__auto___11692;
var G__11695 = cljs.core.count(c__4649__auto___11692);
var G__11696 = (0);
seq__11664_11681 = G__11693;
chunk__11665_11682 = G__11694;
count__11666_11683 = G__11695;
i__11667_11684 = G__11696;
continue;
} else {
var e_11697 = cljs.core.first(seq__11664_11691__$1);
if(cljs.core.truth_(e_11697)){
print_comment_lines(e_11697);
} else {
}


var G__11698 = cljs.core.next(seq__11664_11691__$1);
var G__11699 = null;
var G__11700 = (0);
var G__11701 = (0);
seq__11664_11681 = G__11698;
chunk__11665_11682 = G__11699;
count__11666_11683 = G__11700;
i__11667_11684 = G__11701;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__4221__auto__ = cljs.core.some((function (p1__11703_SHARP_){
return goog.string.startsWith(p1__11703_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = opts;
if(cljs.core.truth_(and__4221__auto____$1)){
var and__4221__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none);
if(and__4221__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4221__auto____$2;
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__11704){
var map__11705 = p__11704;
var map__11705__$1 = cljs.core.__destructure_map(map__11705);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11705__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11705__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11705__$1,cljs.core.cst$kw$test);
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11705__$1,cljs.core.cst$kw$goog_DASH_define);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11705__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11705__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11705__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11705__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11705__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11705__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__4223__auto__ = init;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
return test;
} else {
return and__4221__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__11706){
var map__11707 = p__11706;
var map__11707__$1 = cljs.core.__destructure_map(map__11707);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11707__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11707__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11707__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__11708_11732 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__11709_11733 = null;
var count__11710_11734 = (0);
var i__11711_11735 = (0);
while(true){
if((i__11711_11735 < count__11710_11734)){
var vec__11718_11736 = chunk__11709_11733.cljs$core$IIndexed$_nth$arity$2(null,i__11711_11735);
var i_11737 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11718_11736,(0),null);
var param_11738 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11718_11736,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_11738);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__11739 = seq__11708_11732;
var G__11740 = chunk__11709_11733;
var G__11741 = count__11710_11734;
var G__11742 = (i__11711_11735 + (1));
seq__11708_11732 = G__11739;
chunk__11709_11733 = G__11740;
count__11710_11734 = G__11741;
i__11711_11735 = G__11742;
continue;
} else {
var temp__5753__auto___11743 = cljs.core.seq(seq__11708_11732);
if(temp__5753__auto___11743){
var seq__11708_11744__$1 = temp__5753__auto___11743;
if(cljs.core.chunked_seq_QMARK_(seq__11708_11744__$1)){
var c__4649__auto___11745 = cljs.core.chunk_first(seq__11708_11744__$1);
var G__11746 = cljs.core.chunk_rest(seq__11708_11744__$1);
var G__11747 = c__4649__auto___11745;
var G__11748 = cljs.core.count(c__4649__auto___11745);
var G__11749 = (0);
seq__11708_11732 = G__11746;
chunk__11709_11733 = G__11747;
count__11710_11734 = G__11748;
i__11711_11735 = G__11749;
continue;
} else {
var vec__11721_11750 = cljs.core.first(seq__11708_11744__$1);
var i_11751 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11721_11750,(0),null);
var param_11752 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11721_11750,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_11752);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__11753 = cljs.core.next(seq__11708_11744__$1);
var G__11754 = null;
var G__11755 = (0);
var G__11756 = (0);
seq__11708_11732 = G__11753;
chunk__11709_11733 = G__11754;
count__11710_11734 = G__11755;
i__11711_11735 = G__11756;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__11724_11757 = cljs.core.seq(params);
var chunk__11725_11758 = null;
var count__11726_11759 = (0);
var i__11727_11760 = (0);
while(true){
if((i__11727_11760 < count__11726_11759)){
var param_11761 = chunk__11725_11758.cljs$core$IIndexed$_nth$arity$2(null,i__11727_11760);
cljs.compiler.emit(param_11761);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11761,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11762 = seq__11724_11757;
var G__11763 = chunk__11725_11758;
var G__11764 = count__11726_11759;
var G__11765 = (i__11727_11760 + (1));
seq__11724_11757 = G__11762;
chunk__11725_11758 = G__11763;
count__11726_11759 = G__11764;
i__11727_11760 = G__11765;
continue;
} else {
var temp__5753__auto___11766 = cljs.core.seq(seq__11724_11757);
if(temp__5753__auto___11766){
var seq__11724_11767__$1 = temp__5753__auto___11766;
if(cljs.core.chunked_seq_QMARK_(seq__11724_11767__$1)){
var c__4649__auto___11768 = cljs.core.chunk_first(seq__11724_11767__$1);
var G__11769 = cljs.core.chunk_rest(seq__11724_11767__$1);
var G__11770 = c__4649__auto___11768;
var G__11771 = cljs.core.count(c__4649__auto___11768);
var G__11772 = (0);
seq__11724_11757 = G__11769;
chunk__11725_11758 = G__11770;
count__11726_11759 = G__11771;
i__11727_11760 = G__11772;
continue;
} else {
var param_11773 = cljs.core.first(seq__11724_11767__$1);
cljs.compiler.emit(param_11773);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11773,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11774 = cljs.core.next(seq__11724_11767__$1);
var G__11775 = null;
var G__11776 = (0);
var G__11777 = (0);
seq__11724_11757 = G__11774;
chunk__11725_11758 = G__11775;
count__11726_11759 = G__11776;
i__11727_11760 = G__11777;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__11728_11778 = cljs.core.seq(params);
var chunk__11729_11779 = null;
var count__11730_11780 = (0);
var i__11731_11781 = (0);
while(true){
if((i__11731_11781 < count__11730_11780)){
var param_11782 = chunk__11729_11779.cljs$core$IIndexed$_nth$arity$2(null,i__11731_11781);
cljs.compiler.emit(param_11782);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11782,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11783 = seq__11728_11778;
var G__11784 = chunk__11729_11779;
var G__11785 = count__11730_11780;
var G__11786 = (i__11731_11781 + (1));
seq__11728_11778 = G__11783;
chunk__11729_11779 = G__11784;
count__11730_11780 = G__11785;
i__11731_11781 = G__11786;
continue;
} else {
var temp__5753__auto___11787 = cljs.core.seq(seq__11728_11778);
if(temp__5753__auto___11787){
var seq__11728_11788__$1 = temp__5753__auto___11787;
if(cljs.core.chunked_seq_QMARK_(seq__11728_11788__$1)){
var c__4649__auto___11789 = cljs.core.chunk_first(seq__11728_11788__$1);
var G__11790 = cljs.core.chunk_rest(seq__11728_11788__$1);
var G__11791 = c__4649__auto___11789;
var G__11792 = cljs.core.count(c__4649__auto___11789);
var G__11793 = (0);
seq__11728_11778 = G__11790;
chunk__11729_11779 = G__11791;
count__11730_11780 = G__11792;
i__11731_11781 = G__11793;
continue;
} else {
var param_11794 = cljs.core.first(seq__11728_11788__$1);
cljs.compiler.emit(param_11794);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11794,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11795 = cljs.core.next(seq__11728_11788__$1);
var G__11796 = null;
var G__11797 = (0);
var G__11798 = (0);
seq__11728_11778 = G__11795;
chunk__11729_11779 = G__11796;
count__11730_11780 = G__11797;
i__11731_11781 = G__11798;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__11799 = cljs.core.seq(params);
var chunk__11800 = null;
var count__11801 = (0);
var i__11802 = (0);
while(true){
if((i__11802 < count__11801)){
var param = chunk__11800.cljs$core$IIndexed$_nth$arity$2(null,i__11802);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11803 = seq__11799;
var G__11804 = chunk__11800;
var G__11805 = count__11801;
var G__11806 = (i__11802 + (1));
seq__11799 = G__11803;
chunk__11800 = G__11804;
count__11801 = G__11805;
i__11802 = G__11806;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__11799);
if(temp__5753__auto__){
var seq__11799__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11799__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__11799__$1);
var G__11807 = cljs.core.chunk_rest(seq__11799__$1);
var G__11808 = c__4649__auto__;
var G__11809 = cljs.core.count(c__4649__auto__);
var G__11810 = (0);
seq__11799 = G__11807;
chunk__11800 = G__11808;
count__11801 = G__11809;
i__11802 = G__11810;
continue;
} else {
var param = cljs.core.first(seq__11799__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11811 = cljs.core.next(seq__11799__$1);
var G__11812 = null;
var G__11813 = (0);
var G__11814 = (0);
seq__11799 = G__11811;
chunk__11800 = G__11812;
count__11801 = G__11813;
i__11802 = G__11814;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__11815){
var map__11816 = p__11815;
var map__11816__$1 = cljs.core.__destructure_map(map__11816);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11816__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11816__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11816__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11816__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11816__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11816__$1,cljs.core.cst$kw$recurs);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__11817){
var map__11818 = p__11817;
var map__11818__$1 = cljs.core.__destructure_map(map__11818);
var f = map__11818__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11818__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11818__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11818__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11818__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11818__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11818__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11818__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11818__$1,cljs.core.cst$kw$recurs);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_11827__$1 = (function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_11828 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_11827__$1);
var delegate_name_11829 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_11828),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_11829," = function (");

var seq__11819_11830 = cljs.core.seq(params);
var chunk__11820_11831 = null;
var count__11821_11832 = (0);
var i__11822_11833 = (0);
while(true){
if((i__11822_11833 < count__11821_11832)){
var param_11834 = chunk__11820_11831.cljs$core$IIndexed$_nth$arity$2(null,i__11822_11833);
cljs.compiler.emit(param_11834);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11834,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11835 = seq__11819_11830;
var G__11836 = chunk__11820_11831;
var G__11837 = count__11821_11832;
var G__11838 = (i__11822_11833 + (1));
seq__11819_11830 = G__11835;
chunk__11820_11831 = G__11836;
count__11821_11832 = G__11837;
i__11822_11833 = G__11838;
continue;
} else {
var temp__5753__auto___11839 = cljs.core.seq(seq__11819_11830);
if(temp__5753__auto___11839){
var seq__11819_11840__$1 = temp__5753__auto___11839;
if(cljs.core.chunked_seq_QMARK_(seq__11819_11840__$1)){
var c__4649__auto___11841 = cljs.core.chunk_first(seq__11819_11840__$1);
var G__11842 = cljs.core.chunk_rest(seq__11819_11840__$1);
var G__11843 = c__4649__auto___11841;
var G__11844 = cljs.core.count(c__4649__auto___11841);
var G__11845 = (0);
seq__11819_11830 = G__11842;
chunk__11820_11831 = G__11843;
count__11821_11832 = G__11844;
i__11822_11833 = G__11845;
continue;
} else {
var param_11846 = cljs.core.first(seq__11819_11840__$1);
cljs.compiler.emit(param_11846);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11846,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11847 = cljs.core.next(seq__11819_11840__$1);
var G__11848 = null;
var G__11849 = (0);
var G__11850 = (0);
seq__11819_11830 = G__11847;
chunk__11820_11831 = G__11848;
count__11821_11832 = G__11849;
i__11822_11833 = G__11850;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_11828," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_11851 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_11851,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_11829,".call(this,");

var seq__11823_11852 = cljs.core.seq(params);
var chunk__11824_11853 = null;
var count__11825_11854 = (0);
var i__11826_11855 = (0);
while(true){
if((i__11826_11855 < count__11825_11854)){
var param_11856 = chunk__11824_11853.cljs$core$IIndexed$_nth$arity$2(null,i__11826_11855);
cljs.compiler.emit(param_11856);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11856,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11857 = seq__11823_11852;
var G__11858 = chunk__11824_11853;
var G__11859 = count__11825_11854;
var G__11860 = (i__11826_11855 + (1));
seq__11823_11852 = G__11857;
chunk__11824_11853 = G__11858;
count__11825_11854 = G__11859;
i__11826_11855 = G__11860;
continue;
} else {
var temp__5753__auto___11861 = cljs.core.seq(seq__11823_11852);
if(temp__5753__auto___11861){
var seq__11823_11862__$1 = temp__5753__auto___11861;
if(cljs.core.chunked_seq_QMARK_(seq__11823_11862__$1)){
var c__4649__auto___11863 = cljs.core.chunk_first(seq__11823_11862__$1);
var G__11864 = cljs.core.chunk_rest(seq__11823_11862__$1);
var G__11865 = c__4649__auto___11863;
var G__11866 = cljs.core.count(c__4649__auto___11863);
var G__11867 = (0);
seq__11823_11852 = G__11864;
chunk__11824_11853 = G__11865;
count__11825_11854 = G__11866;
i__11826_11855 = G__11867;
continue;
} else {
var param_11868 = cljs.core.first(seq__11823_11862__$1);
cljs.compiler.emit(param_11868);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_11868,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__11869 = cljs.core.next(seq__11823_11862__$1);
var G__11870 = null;
var G__11871 = (0);
var G__11872 = (0);
seq__11823_11852 = G__11869;
chunk__11824_11853 = G__11870;
count__11825_11854 = G__11871;
i__11826_11855 = G__11872;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11828,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_11828,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_11827__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11828,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_11829,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_11828,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__11876){
var map__11877 = p__11876;
var map__11877__$1 = cljs.core.__destructure_map(map__11877);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11877__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11877__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11877__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11877__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11877__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11877__$1,cljs.core.cst$kw$recur_DASH_frames);
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11877__$1,cljs.core.cst$kw$in_DASH_loop);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11877__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__11873_SHARP_){
var and__4221__auto__ = p1__11873_SHARP_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__11873_SHARP_));
} else {
return and__4221__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4223__auto__ = in_loop;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_11929__$1 = (function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_11930 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_11929__$1);
var maxparams_11931 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_11932 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_11930),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_11933 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__11874_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__11874_SHARP_)));
}),cljs.core.seq(mmap_11932));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_11930," = null;");

var seq__11878_11934 = cljs.core.seq(ms_11933);
var chunk__11879_11935 = null;
var count__11880_11936 = (0);
var i__11881_11937 = (0);
while(true){
if((i__11881_11937 < count__11880_11936)){
var vec__11888_11938 = chunk__11879_11935.cljs$core$IIndexed$_nth$arity$2(null,i__11881_11937);
var n_11939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11888_11938,(0),null);
var meth_11940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11888_11938,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_11939," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_11940))){
cljs.compiler.emit_variadic_fn_method(meth_11940);
} else {
cljs.compiler.emit_fn_method(meth_11940);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__11941 = seq__11878_11934;
var G__11942 = chunk__11879_11935;
var G__11943 = count__11880_11936;
var G__11944 = (i__11881_11937 + (1));
seq__11878_11934 = G__11941;
chunk__11879_11935 = G__11942;
count__11880_11936 = G__11943;
i__11881_11937 = G__11944;
continue;
} else {
var temp__5753__auto___11945 = cljs.core.seq(seq__11878_11934);
if(temp__5753__auto___11945){
var seq__11878_11946__$1 = temp__5753__auto___11945;
if(cljs.core.chunked_seq_QMARK_(seq__11878_11946__$1)){
var c__4649__auto___11947 = cljs.core.chunk_first(seq__11878_11946__$1);
var G__11948 = cljs.core.chunk_rest(seq__11878_11946__$1);
var G__11949 = c__4649__auto___11947;
var G__11950 = cljs.core.count(c__4649__auto___11947);
var G__11951 = (0);
seq__11878_11934 = G__11948;
chunk__11879_11935 = G__11949;
count__11880_11936 = G__11950;
i__11881_11937 = G__11951;
continue;
} else {
var vec__11891_11952 = cljs.core.first(seq__11878_11946__$1);
var n_11953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11891_11952,(0),null);
var meth_11954 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11891_11952,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_11953," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_11954))){
cljs.compiler.emit_variadic_fn_method(meth_11954);
} else {
cljs.compiler.emit_fn_method(meth_11954);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__11955 = cljs.core.next(seq__11878_11946__$1);
var G__11956 = null;
var G__11957 = (0);
var G__11958 = (0);
seq__11878_11934 = G__11955;
chunk__11879_11935 = G__11956;
count__11880_11936 = G__11957;
i__11881_11937 = G__11958;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11930," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_11931),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_11931)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_11931));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__11894_11959 = cljs.core.seq(ms_11933);
var chunk__11895_11960 = null;
var count__11896_11961 = (0);
var i__11897_11962 = (0);
while(true){
if((i__11897_11962 < count__11896_11961)){
var vec__11904_11963 = chunk__11895_11960.cljs$core$IIndexed$_nth$arity$2(null,i__11897_11962);
var n_11964 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11904_11963,(0),null);
var meth_11965 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11904_11963,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_11965))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_11966 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_11966," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_11967 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_11966," = new cljs.core.IndexedSeq(",a_11967,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_11964,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_11931)),(((cljs.core.count(maxparams_11931) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_11966,");"], 0));
} else {
var pcnt_11968 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_11965));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_11968,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_11964,".call(this",(((pcnt_11968 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_11968,maxparams_11931)),null,(1),null)),(2),null))),");");
}


var G__11969 = seq__11894_11959;
var G__11970 = chunk__11895_11960;
var G__11971 = count__11896_11961;
var G__11972 = (i__11897_11962 + (1));
seq__11894_11959 = G__11969;
chunk__11895_11960 = G__11970;
count__11896_11961 = G__11971;
i__11897_11962 = G__11972;
continue;
} else {
var temp__5753__auto___11973 = cljs.core.seq(seq__11894_11959);
if(temp__5753__auto___11973){
var seq__11894_11974__$1 = temp__5753__auto___11973;
if(cljs.core.chunked_seq_QMARK_(seq__11894_11974__$1)){
var c__4649__auto___11975 = cljs.core.chunk_first(seq__11894_11974__$1);
var G__11976 = cljs.core.chunk_rest(seq__11894_11974__$1);
var G__11977 = c__4649__auto___11975;
var G__11978 = cljs.core.count(c__4649__auto___11975);
var G__11979 = (0);
seq__11894_11959 = G__11976;
chunk__11895_11960 = G__11977;
count__11896_11961 = G__11978;
i__11897_11962 = G__11979;
continue;
} else {
var vec__11907_11980 = cljs.core.first(seq__11894_11974__$1);
var n_11981 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11907_11980,(0),null);
var meth_11982 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11907_11980,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_11982))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_11983 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_11983," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_11984 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_11983," = new cljs.core.IndexedSeq(",a_11984,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_11981,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_11931)),(((cljs.core.count(maxparams_11931) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_11983,");"], 0));
} else {
var pcnt_11985 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_11982));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_11985,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_11981,".call(this",(((pcnt_11985 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_11985,maxparams_11931)),null,(1),null)),(2),null))),");");
}


var G__11986 = cljs.core.next(seq__11894_11974__$1);
var G__11987 = null;
var G__11988 = (0);
var G__11989 = (0);
seq__11894_11959 = G__11986;
chunk__11895_11960 = G__11987;
count__11896_11961 = G__11988;
i__11897_11962 = G__11989;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_11990 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_11933)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_11990,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11930,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11930,".cljs$lang$applyTo = ",cljs.core.some((function (p1__11875_SHARP_){
var vec__11910 = p1__11875_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11910,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11910,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_11933),".cljs$lang$applyTo;");
} else {
}

var seq__11913_11991 = cljs.core.seq(ms_11933);
var chunk__11914_11992 = null;
var count__11915_11993 = (0);
var i__11916_11994 = (0);
while(true){
if((i__11916_11994 < count__11915_11993)){
var vec__11923_11995 = chunk__11914_11992.cljs$core$IIndexed$_nth$arity$2(null,i__11916_11994);
var n_11996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11923_11995,(0),null);
var meth_11997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11923_11995,(1),null);
var c_11998 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_11997));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_11997))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11930,".cljs$core$IFn$_invoke$arity$variadic = ",n_11996,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_11930,".cljs$core$IFn$_invoke$arity$",c_11998," = ",n_11996,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__11999 = seq__11913_11991;
var G__12000 = chunk__11914_11992;
var G__12001 = count__11915_11993;
var G__12002 = (i__11916_11994 + (1));
seq__11913_11991 = G__11999;
chunk__11914_11992 = G__12000;
count__11915_11993 = G__12001;
i__11916_11994 = G__12002;
continue;
} else {
var temp__5753__auto___12003 = cljs.core.seq(seq__11913_11991);
if(temp__5753__auto___12003){
var seq__11913_12004__$1 = temp__5753__auto___12003;
if(cljs.core.chunked_seq_QMARK_(seq__11913_12004__$1)){
var c__4649__auto___12005 = cljs.core.chunk_first(seq__11913_12004__$1);
var G__12006 = cljs.core.chunk_rest(seq__11913_12004__$1);
var G__12007 = c__4649__auto___12005;
var G__12008 = cljs.core.count(c__4649__auto___12005);
var G__12009 = (0);
seq__11913_11991 = G__12006;
chunk__11914_11992 = G__12007;
count__11915_11993 = G__12008;
i__11916_11994 = G__12009;
continue;
} else {
var vec__11926_12010 = cljs.core.first(seq__11913_12004__$1);
var n_12011 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11926_12010,(0),null);
var meth_12012 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11926_12010,(1),null);
var c_12013 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_12012));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12012))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_11930,".cljs$core$IFn$_invoke$arity$variadic = ",n_12011,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_11930,".cljs$core$IFn$_invoke$arity$",c_12013," = ",n_12011,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__12014 = cljs.core.next(seq__11913_12004__$1);
var G__12015 = null;
var G__12016 = (0);
var G__12017 = (0);
seq__11913_11991 = G__12014;
chunk__11914_11992 = G__12015;
count__11915_11993 = G__12016;
i__11916_11994 = G__12017;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_11930,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__12018){
var map__12019 = p__12018;
var map__12019__$1 = cljs.core.__destructure_map(map__12019);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12019__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12019__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12019__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__12020_12024 = cljs.core.seq(statements);
var chunk__12021_12025 = null;
var count__12022_12026 = (0);
var i__12023_12027 = (0);
while(true){
if((i__12023_12027 < count__12022_12026)){
var s_12028 = chunk__12021_12025.cljs$core$IIndexed$_nth$arity$2(null,i__12023_12027);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_12028);


var G__12029 = seq__12020_12024;
var G__12030 = chunk__12021_12025;
var G__12031 = count__12022_12026;
var G__12032 = (i__12023_12027 + (1));
seq__12020_12024 = G__12029;
chunk__12021_12025 = G__12030;
count__12022_12026 = G__12031;
i__12023_12027 = G__12032;
continue;
} else {
var temp__5753__auto___12033 = cljs.core.seq(seq__12020_12024);
if(temp__5753__auto___12033){
var seq__12020_12034__$1 = temp__5753__auto___12033;
if(cljs.core.chunked_seq_QMARK_(seq__12020_12034__$1)){
var c__4649__auto___12035 = cljs.core.chunk_first(seq__12020_12034__$1);
var G__12036 = cljs.core.chunk_rest(seq__12020_12034__$1);
var G__12037 = c__4649__auto___12035;
var G__12038 = cljs.core.count(c__4649__auto___12035);
var G__12039 = (0);
seq__12020_12024 = G__12036;
chunk__12021_12025 = G__12037;
count__12022_12026 = G__12038;
i__12023_12027 = G__12039;
continue;
} else {
var s_12040 = cljs.core.first(seq__12020_12034__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_12040);


var G__12041 = cljs.core.next(seq__12020_12034__$1);
var G__12042 = null;
var G__12043 = (0);
var G__12044 = (0);
seq__12020_12024 = G__12041;
chunk__12021_12025 = G__12042;
count__12022_12026 = G__12043;
i__12023_12027 = G__12044;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__12045){
var map__12046 = p__12045;
var map__12046__$1 = cljs.core.__destructure_map(map__12046);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12046__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12046__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12046__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12046__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12046__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__12047,is_loop){
var map__12048 = p__12047;
var map__12048__$1 = cljs.core.__destructure_map(map__12048);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12048__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12048__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12048__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__12049_12059 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__12050_12060 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__12050_12060);

try{var seq__12051_12061 = cljs.core.seq(bindings);
var chunk__12052_12062 = null;
var count__12053_12063 = (0);
var i__12054_12064 = (0);
while(true){
if((i__12054_12064 < count__12053_12063)){
var map__12057_12065 = chunk__12052_12062.cljs$core$IIndexed$_nth$arity$2(null,i__12054_12064);
var map__12057_12066__$1 = cljs.core.__destructure_map(map__12057_12065);
var binding_12067 = map__12057_12066__$1;
var init_12068 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12057_12066__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_12067);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_12068,";");


var G__12069 = seq__12051_12061;
var G__12070 = chunk__12052_12062;
var G__12071 = count__12053_12063;
var G__12072 = (i__12054_12064 + (1));
seq__12051_12061 = G__12069;
chunk__12052_12062 = G__12070;
count__12053_12063 = G__12071;
i__12054_12064 = G__12072;
continue;
} else {
var temp__5753__auto___12073 = cljs.core.seq(seq__12051_12061);
if(temp__5753__auto___12073){
var seq__12051_12074__$1 = temp__5753__auto___12073;
if(cljs.core.chunked_seq_QMARK_(seq__12051_12074__$1)){
var c__4649__auto___12075 = cljs.core.chunk_first(seq__12051_12074__$1);
var G__12076 = cljs.core.chunk_rest(seq__12051_12074__$1);
var G__12077 = c__4649__auto___12075;
var G__12078 = cljs.core.count(c__4649__auto___12075);
var G__12079 = (0);
seq__12051_12061 = G__12076;
chunk__12052_12062 = G__12077;
count__12053_12063 = G__12078;
i__12054_12064 = G__12079;
continue;
} else {
var map__12058_12080 = cljs.core.first(seq__12051_12074__$1);
var map__12058_12081__$1 = cljs.core.__destructure_map(map__12058_12080);
var binding_12082 = map__12058_12081__$1;
var init_12083 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12058_12081__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_12082);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_12083,";");


var G__12084 = cljs.core.next(seq__12051_12074__$1);
var G__12085 = null;
var G__12086 = (0);
var G__12087 = (0);
seq__12051_12061 = G__12084;
chunk__12052_12062 = G__12085;
count__12053_12063 = G__12086;
i__12054_12064 = G__12087;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__12049_12059);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__12088){
var map__12089 = p__12088;
var map__12089__$1 = cljs.core.__destructure_map(map__12089);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12089__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12089__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12089__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__4706__auto___12090 = cljs.core.count(exprs);
var i_12091 = (0);
while(true){
if((i_12091 < n__4706__auto___12090)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_12091) : temps.call(null,i_12091))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_12091) : exprs.call(null,i_12091)),";");

var G__12092 = (i_12091 + (1));
i_12091 = G__12092;
continue;
} else {
}
break;
}

var n__4706__auto___12093 = cljs.core.count(exprs);
var i_12094 = (0);
while(true){
if((i_12094 < n__4706__auto___12093)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_12094) : params.call(null,i_12094)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_12094) : temps.call(null,i_12094)),";");

var G__12095 = (i_12094 + (1));
i_12094 = G__12095;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__12096){
var map__12097 = p__12096;
var map__12097__$1 = cljs.core.__destructure_map(map__12097);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12097__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12097__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12097__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__12098_12106 = cljs.core.seq(bindings);
var chunk__12099_12107 = null;
var count__12100_12108 = (0);
var i__12101_12109 = (0);
while(true){
if((i__12101_12109 < count__12100_12108)){
var map__12104_12110 = chunk__12099_12107.cljs$core$IIndexed$_nth$arity$2(null,i__12101_12109);
var map__12104_12111__$1 = cljs.core.__destructure_map(map__12104_12110);
var binding_12112 = map__12104_12111__$1;
var init_12113 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12104_12111__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_12112)," = ",init_12113,";");


var G__12114 = seq__12098_12106;
var G__12115 = chunk__12099_12107;
var G__12116 = count__12100_12108;
var G__12117 = (i__12101_12109 + (1));
seq__12098_12106 = G__12114;
chunk__12099_12107 = G__12115;
count__12100_12108 = G__12116;
i__12101_12109 = G__12117;
continue;
} else {
var temp__5753__auto___12118 = cljs.core.seq(seq__12098_12106);
if(temp__5753__auto___12118){
var seq__12098_12119__$1 = temp__5753__auto___12118;
if(cljs.core.chunked_seq_QMARK_(seq__12098_12119__$1)){
var c__4649__auto___12120 = cljs.core.chunk_first(seq__12098_12119__$1);
var G__12121 = cljs.core.chunk_rest(seq__12098_12119__$1);
var G__12122 = c__4649__auto___12120;
var G__12123 = cljs.core.count(c__4649__auto___12120);
var G__12124 = (0);
seq__12098_12106 = G__12121;
chunk__12099_12107 = G__12122;
count__12100_12108 = G__12123;
i__12101_12109 = G__12124;
continue;
} else {
var map__12105_12125 = cljs.core.first(seq__12098_12119__$1);
var map__12105_12126__$1 = cljs.core.__destructure_map(map__12105_12125);
var binding_12127 = map__12105_12126__$1;
var init_12128 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12105_12126__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_12127)," = ",init_12128,";");


var G__12129 = cljs.core.next(seq__12098_12119__$1);
var G__12130 = null;
var G__12131 = (0);
var G__12132 = (0);
seq__12098_12106 = G__12129;
chunk__12099_12107 = G__12130;
count__12100_12108 = G__12131;
i__12101_12109 = G__12132;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__12135){
var map__12136 = p__12135;
var map__12136__$1 = cljs.core.__destructure_map(map__12136);
var expr = map__12136__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4221__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info));
if(and__4221__auto____$1){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4221__auto__ = protocol;
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = tag;
if(cljs.core.truth_(and__4221__auto____$1)){
var or__4223__auto__ = (function (){var and__4221__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto____$2)){
var and__4221__auto____$3 = protocol;
if(cljs.core.truth_(and__4221__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__4221__auto____$3;
}
} else {
return and__4221__auto____$2;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto____$2 = (function (){var or__4223__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4221__auto____$2)){
var or__4223__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4223__auto____$1){
return or__4223__auto____$1;
} else {
var and__4221__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4221__auto____$3){
var and__4221__auto____$4 = cljs.core.not((function (){var fexpr__12140 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__12140.cljs$core$IFn$_invoke$arity$1 ? fexpr__12140.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__12140.call(null,tag));
})());
if(and__4221__auto____$4){
var temp__5753__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4221__auto____$4;
}
} else {
return and__4221__auto____$3;
}
}
} else {
return and__4221__auto____$2;
}
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,cljs.core.cst$sym$boolean)));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_count)) && (cljs.core.boolean$((function (){var fexpr__12141 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null"], null), null);
return (fexpr__12141.cljs$core$IFn$_invoke$arity$1 ? fexpr__12141.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__12141.call(null,first_arg_tag));
})())));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math);
if(or__4223__auto____$1){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$foreign.cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,ftag);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__12137 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (arity > mfa);
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__12133_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__12133_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__12134_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__12134_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12137,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12137,(1),null);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_12144 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_12144,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_12145 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_12145,args)),(((mfa_12145 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_12145,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
var G__12143 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__12142 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__12142.cljs$core$IFn$_invoke$arity$1 ? fexpr__12142.cljs$core$IFn$_invoke$arity$1(G__12143) : fexpr__12142.call(null,G__12143));
} else {
return and__4221__auto__;
}
})())){
var fprop_12146 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_12146," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_12146,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_12146," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_12146,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__12147){
var map__12148 = p__12147;
var map__12148__$1 = cljs.core.__destructure_map(map__12148);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12148__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12148__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12148__$1,cljs.core.cst$kw$env);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__12149){
var map__12150 = p__12149;
var map__12150__$1 = cljs.core.__destructure_map(map__12150);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12150__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12150__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12150__$1,cljs.core.cst$kw$env);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__12151_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__12151_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__12152 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12152,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12152,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__12155 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__12155__$1 = cljs.core.__destructure_map(map__12155);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12155__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12155__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__12156 = options;
var map__12156__$1 = cljs.core.__destructure_map(map__12156);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12156__$1,cljs.core.cst$kw$target);
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12156__$1,cljs.core.cst$kw$nodejs_DASH_rt);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12156__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__12157 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__12160 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__12160__$1 = cljs.core.__destructure_map(map__12160);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12160__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12160__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12157,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12157,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__12161_12189 = cljs.core.seq(libs_to_load);
var chunk__12162_12190 = null;
var count__12163_12191 = (0);
var i__12164_12192 = (0);
while(true){
if((i__12164_12192 < count__12163_12191)){
var lib_12193 = chunk__12162_12190.cljs$core$IIndexed$_nth$arity$2(null,i__12164_12192);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_12193)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_12193),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12193),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_12193),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12193),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_12193,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12193),"');");
}

}
}
}


var G__12194 = seq__12161_12189;
var G__12195 = chunk__12162_12190;
var G__12196 = count__12163_12191;
var G__12197 = (i__12164_12192 + (1));
seq__12161_12189 = G__12194;
chunk__12162_12190 = G__12195;
count__12163_12191 = G__12196;
i__12164_12192 = G__12197;
continue;
} else {
var temp__5753__auto___12198 = cljs.core.seq(seq__12161_12189);
if(temp__5753__auto___12198){
var seq__12161_12199__$1 = temp__5753__auto___12198;
if(cljs.core.chunked_seq_QMARK_(seq__12161_12199__$1)){
var c__4649__auto___12200 = cljs.core.chunk_first(seq__12161_12199__$1);
var G__12201 = cljs.core.chunk_rest(seq__12161_12199__$1);
var G__12202 = c__4649__auto___12200;
var G__12203 = cljs.core.count(c__4649__auto___12200);
var G__12204 = (0);
seq__12161_12189 = G__12201;
chunk__12162_12190 = G__12202;
count__12163_12191 = G__12203;
i__12164_12192 = G__12204;
continue;
} else {
var lib_12205 = cljs.core.first(seq__12161_12199__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_12205)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_12205),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12205),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_12205),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12205),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_12205,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12205),"');");
}

}
}
}


var G__12206 = cljs.core.next(seq__12161_12199__$1);
var G__12207 = null;
var G__12208 = (0);
var G__12209 = (0);
seq__12161_12189 = G__12206;
chunk__12162_12190 = G__12207;
count__12163_12191 = G__12208;
i__12164_12192 = G__12209;
continue;
}
} else {
}
}
break;
}

var seq__12165_12210 = cljs.core.seq(node_libs);
var chunk__12166_12211 = null;
var count__12167_12212 = (0);
var i__12168_12213 = (0);
while(true){
if((i__12168_12213 < count__12167_12212)){
var lib_12214 = chunk__12166_12211.cljs$core$IIndexed$_nth$arity$2(null,i__12168_12213);
var vec__12175_12215 = cljs.analyzer.lib_AMPERSAND_sublib(lib_12214);
var lib_SINGLEQUOTE__12216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12175_12215,(0),null);
var sublib_12217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12175_12215,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_12214)," = require('",lib_SINGLEQUOTE__12216,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_12217),";"], 0));


var G__12218 = seq__12165_12210;
var G__12219 = chunk__12166_12211;
var G__12220 = count__12167_12212;
var G__12221 = (i__12168_12213 + (1));
seq__12165_12210 = G__12218;
chunk__12166_12211 = G__12219;
count__12167_12212 = G__12220;
i__12168_12213 = G__12221;
continue;
} else {
var temp__5753__auto___12222 = cljs.core.seq(seq__12165_12210);
if(temp__5753__auto___12222){
var seq__12165_12223__$1 = temp__5753__auto___12222;
if(cljs.core.chunked_seq_QMARK_(seq__12165_12223__$1)){
var c__4649__auto___12224 = cljs.core.chunk_first(seq__12165_12223__$1);
var G__12225 = cljs.core.chunk_rest(seq__12165_12223__$1);
var G__12226 = c__4649__auto___12224;
var G__12227 = cljs.core.count(c__4649__auto___12224);
var G__12228 = (0);
seq__12165_12210 = G__12225;
chunk__12166_12211 = G__12226;
count__12167_12212 = G__12227;
i__12168_12213 = G__12228;
continue;
} else {
var lib_12229 = cljs.core.first(seq__12165_12223__$1);
var vec__12178_12230 = cljs.analyzer.lib_AMPERSAND_sublib(lib_12229);
var lib_SINGLEQUOTE__12231 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12178_12230,(0),null);
var sublib_12232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12178_12230,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_12229)," = require('",lib_SINGLEQUOTE__12231,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_12232),";"], 0));


var G__12233 = cljs.core.next(seq__12165_12223__$1);
var G__12234 = null;
var G__12235 = (0);
var G__12236 = (0);
seq__12165_12210 = G__12233;
chunk__12166_12211 = G__12234;
count__12167_12212 = G__12235;
i__12168_12213 = G__12236;
continue;
}
} else {
}
}
break;
}

var seq__12181_12237 = cljs.core.seq(global_exports_libs);
var chunk__12182_12238 = null;
var count__12183_12239 = (0);
var i__12184_12240 = (0);
while(true){
if((i__12184_12240 < count__12183_12239)){
var lib_12241 = chunk__12182_12238.cljs$core$IIndexed$_nth$arity$2(null,i__12184_12240);
var map__12187_12242 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_12241))));
var map__12187_12243__$1 = cljs.core.__destructure_map(map__12187_12242);
var global_exports_12244 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12187_12243__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_12244,lib_12241);


var G__12245 = seq__12181_12237;
var G__12246 = chunk__12182_12238;
var G__12247 = count__12183_12239;
var G__12248 = (i__12184_12240 + (1));
seq__12181_12237 = G__12245;
chunk__12182_12238 = G__12246;
count__12183_12239 = G__12247;
i__12184_12240 = G__12248;
continue;
} else {
var temp__5753__auto___12249 = cljs.core.seq(seq__12181_12237);
if(temp__5753__auto___12249){
var seq__12181_12250__$1 = temp__5753__auto___12249;
if(cljs.core.chunked_seq_QMARK_(seq__12181_12250__$1)){
var c__4649__auto___12251 = cljs.core.chunk_first(seq__12181_12250__$1);
var G__12252 = cljs.core.chunk_rest(seq__12181_12250__$1);
var G__12253 = c__4649__auto___12251;
var G__12254 = cljs.core.count(c__4649__auto___12251);
var G__12255 = (0);
seq__12181_12237 = G__12252;
chunk__12182_12238 = G__12253;
count__12183_12239 = G__12254;
i__12184_12240 = G__12255;
continue;
} else {
var lib_12256 = cljs.core.first(seq__12181_12250__$1);
var map__12188_12257 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_12256))));
var map__12188_12258__$1 = cljs.core.__destructure_map(map__12188_12257);
var global_exports_12259 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12188_12258__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_12259,lib_12256);


var G__12260 = cljs.core.next(seq__12181_12250__$1);
var G__12261 = null;
var G__12262 = (0);
var G__12263 = (0);
seq__12181_12237 = G__12260;
chunk__12182_12238 = G__12261;
count__12183_12239 = G__12262;
i__12184_12240 = G__12263;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__12264){
var map__12265 = p__12264;
var map__12265__$1 = cljs.core.__destructure_map(map__12265);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12265__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12265__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12265__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12265__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12265__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12265__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12265__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__12266){
var map__12267 = p__12266;
var map__12267__$1 = cljs.core.__destructure_map(map__12267);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12267__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12267__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12267__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12267__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12267__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12267__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12267__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__12268){
var map__12269 = p__12268;
var map__12269__$1 = cljs.core.__destructure_map(map__12269);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12269__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12269__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12269__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12269__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12269__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__12270_12294 = cljs.core.seq(protocols);
var chunk__12271_12295 = null;
var count__12272_12296 = (0);
var i__12273_12297 = (0);
while(true){
if((i__12273_12297 < count__12272_12296)){
var protocol_12298 = chunk__12271_12295.cljs$core$IIndexed$_nth$arity$2(null,i__12273_12297);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12298)),"}");


var G__12299 = seq__12270_12294;
var G__12300 = chunk__12271_12295;
var G__12301 = count__12272_12296;
var G__12302 = (i__12273_12297 + (1));
seq__12270_12294 = G__12299;
chunk__12271_12295 = G__12300;
count__12272_12296 = G__12301;
i__12273_12297 = G__12302;
continue;
} else {
var temp__5753__auto___12303 = cljs.core.seq(seq__12270_12294);
if(temp__5753__auto___12303){
var seq__12270_12304__$1 = temp__5753__auto___12303;
if(cljs.core.chunked_seq_QMARK_(seq__12270_12304__$1)){
var c__4649__auto___12305 = cljs.core.chunk_first(seq__12270_12304__$1);
var G__12306 = cljs.core.chunk_rest(seq__12270_12304__$1);
var G__12307 = c__4649__auto___12305;
var G__12308 = cljs.core.count(c__4649__auto___12305);
var G__12309 = (0);
seq__12270_12294 = G__12306;
chunk__12271_12295 = G__12307;
count__12272_12296 = G__12308;
i__12273_12297 = G__12309;
continue;
} else {
var protocol_12310 = cljs.core.first(seq__12270_12304__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12310)),"}");


var G__12311 = cljs.core.next(seq__12270_12304__$1);
var G__12312 = null;
var G__12313 = (0);
var G__12314 = (0);
seq__12270_12294 = G__12311;
chunk__12271_12295 = G__12312;
count__12272_12296 = G__12313;
i__12273_12297 = G__12314;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__12274_12315 = cljs.core.seq(fields__$1);
var chunk__12275_12316 = null;
var count__12276_12317 = (0);
var i__12277_12318 = (0);
while(true){
if((i__12277_12318 < count__12276_12317)){
var fld_12319 = chunk__12275_12316.cljs$core$IIndexed$_nth$arity$2(null,i__12277_12318);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12319," = ",fld_12319,";");


var G__12320 = seq__12274_12315;
var G__12321 = chunk__12275_12316;
var G__12322 = count__12276_12317;
var G__12323 = (i__12277_12318 + (1));
seq__12274_12315 = G__12320;
chunk__12275_12316 = G__12321;
count__12276_12317 = G__12322;
i__12277_12318 = G__12323;
continue;
} else {
var temp__5753__auto___12324 = cljs.core.seq(seq__12274_12315);
if(temp__5753__auto___12324){
var seq__12274_12325__$1 = temp__5753__auto___12324;
if(cljs.core.chunked_seq_QMARK_(seq__12274_12325__$1)){
var c__4649__auto___12326 = cljs.core.chunk_first(seq__12274_12325__$1);
var G__12327 = cljs.core.chunk_rest(seq__12274_12325__$1);
var G__12328 = c__4649__auto___12326;
var G__12329 = cljs.core.count(c__4649__auto___12326);
var G__12330 = (0);
seq__12274_12315 = G__12327;
chunk__12275_12316 = G__12328;
count__12276_12317 = G__12329;
i__12277_12318 = G__12330;
continue;
} else {
var fld_12331 = cljs.core.first(seq__12274_12325__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12331," = ",fld_12331,";");


var G__12332 = cljs.core.next(seq__12274_12325__$1);
var G__12333 = null;
var G__12334 = (0);
var G__12335 = (0);
seq__12274_12315 = G__12332;
chunk__12275_12316 = G__12333;
count__12276_12317 = G__12334;
i__12277_12318 = G__12335;
continue;
}
} else {
}
}
break;
}

var seq__12278_12336 = cljs.core.seq(pmasks);
var chunk__12279_12337 = null;
var count__12280_12338 = (0);
var i__12281_12339 = (0);
while(true){
if((i__12281_12339 < count__12280_12338)){
var vec__12288_12340 = chunk__12279_12337.cljs$core$IIndexed$_nth$arity$2(null,i__12281_12339);
var pno_12341 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12288_12340,(0),null);
var pmask_12342 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12288_12340,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12341,"$ = ",pmask_12342,";");


var G__12343 = seq__12278_12336;
var G__12344 = chunk__12279_12337;
var G__12345 = count__12280_12338;
var G__12346 = (i__12281_12339 + (1));
seq__12278_12336 = G__12343;
chunk__12279_12337 = G__12344;
count__12280_12338 = G__12345;
i__12281_12339 = G__12346;
continue;
} else {
var temp__5753__auto___12347 = cljs.core.seq(seq__12278_12336);
if(temp__5753__auto___12347){
var seq__12278_12348__$1 = temp__5753__auto___12347;
if(cljs.core.chunked_seq_QMARK_(seq__12278_12348__$1)){
var c__4649__auto___12349 = cljs.core.chunk_first(seq__12278_12348__$1);
var G__12350 = cljs.core.chunk_rest(seq__12278_12348__$1);
var G__12351 = c__4649__auto___12349;
var G__12352 = cljs.core.count(c__4649__auto___12349);
var G__12353 = (0);
seq__12278_12336 = G__12350;
chunk__12279_12337 = G__12351;
count__12280_12338 = G__12352;
i__12281_12339 = G__12353;
continue;
} else {
var vec__12291_12354 = cljs.core.first(seq__12278_12348__$1);
var pno_12355 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12291_12354,(0),null);
var pmask_12356 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12291_12354,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12355,"$ = ",pmask_12356,";");


var G__12357 = cljs.core.next(seq__12278_12348__$1);
var G__12358 = null;
var G__12359 = (0);
var G__12360 = (0);
seq__12278_12336 = G__12357;
chunk__12279_12337 = G__12358;
count__12280_12338 = G__12359;
i__12281_12339 = G__12360;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__12361){
var map__12362 = p__12361;
var map__12362__$1 = cljs.core.__destructure_map(map__12362);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12362__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12362__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12362__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12362__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12362__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__12363_12387 = cljs.core.seq(protocols);
var chunk__12364_12388 = null;
var count__12365_12389 = (0);
var i__12366_12390 = (0);
while(true){
if((i__12366_12390 < count__12365_12389)){
var protocol_12391 = chunk__12364_12388.cljs$core$IIndexed$_nth$arity$2(null,i__12366_12390);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12391)),"}");


var G__12392 = seq__12363_12387;
var G__12393 = chunk__12364_12388;
var G__12394 = count__12365_12389;
var G__12395 = (i__12366_12390 + (1));
seq__12363_12387 = G__12392;
chunk__12364_12388 = G__12393;
count__12365_12389 = G__12394;
i__12366_12390 = G__12395;
continue;
} else {
var temp__5753__auto___12396 = cljs.core.seq(seq__12363_12387);
if(temp__5753__auto___12396){
var seq__12363_12397__$1 = temp__5753__auto___12396;
if(cljs.core.chunked_seq_QMARK_(seq__12363_12397__$1)){
var c__4649__auto___12398 = cljs.core.chunk_first(seq__12363_12397__$1);
var G__12399 = cljs.core.chunk_rest(seq__12363_12397__$1);
var G__12400 = c__4649__auto___12398;
var G__12401 = cljs.core.count(c__4649__auto___12398);
var G__12402 = (0);
seq__12363_12387 = G__12399;
chunk__12364_12388 = G__12400;
count__12365_12389 = G__12401;
i__12366_12390 = G__12402;
continue;
} else {
var protocol_12403 = cljs.core.first(seq__12363_12397__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12403)),"}");


var G__12404 = cljs.core.next(seq__12363_12397__$1);
var G__12405 = null;
var G__12406 = (0);
var G__12407 = (0);
seq__12363_12387 = G__12404;
chunk__12364_12388 = G__12405;
count__12365_12389 = G__12406;
i__12366_12390 = G__12407;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__12367_12408 = cljs.core.seq(fields__$1);
var chunk__12368_12409 = null;
var count__12369_12410 = (0);
var i__12370_12411 = (0);
while(true){
if((i__12370_12411 < count__12369_12410)){
var fld_12412 = chunk__12368_12409.cljs$core$IIndexed$_nth$arity$2(null,i__12370_12411);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12412," = ",fld_12412,";");


var G__12413 = seq__12367_12408;
var G__12414 = chunk__12368_12409;
var G__12415 = count__12369_12410;
var G__12416 = (i__12370_12411 + (1));
seq__12367_12408 = G__12413;
chunk__12368_12409 = G__12414;
count__12369_12410 = G__12415;
i__12370_12411 = G__12416;
continue;
} else {
var temp__5753__auto___12417 = cljs.core.seq(seq__12367_12408);
if(temp__5753__auto___12417){
var seq__12367_12418__$1 = temp__5753__auto___12417;
if(cljs.core.chunked_seq_QMARK_(seq__12367_12418__$1)){
var c__4649__auto___12419 = cljs.core.chunk_first(seq__12367_12418__$1);
var G__12420 = cljs.core.chunk_rest(seq__12367_12418__$1);
var G__12421 = c__4649__auto___12419;
var G__12422 = cljs.core.count(c__4649__auto___12419);
var G__12423 = (0);
seq__12367_12408 = G__12420;
chunk__12368_12409 = G__12421;
count__12369_12410 = G__12422;
i__12370_12411 = G__12423;
continue;
} else {
var fld_12424 = cljs.core.first(seq__12367_12418__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12424," = ",fld_12424,";");


var G__12425 = cljs.core.next(seq__12367_12418__$1);
var G__12426 = null;
var G__12427 = (0);
var G__12428 = (0);
seq__12367_12408 = G__12425;
chunk__12368_12409 = G__12426;
count__12369_12410 = G__12427;
i__12370_12411 = G__12428;
continue;
}
} else {
}
}
break;
}

var seq__12371_12429 = cljs.core.seq(pmasks);
var chunk__12372_12430 = null;
var count__12373_12431 = (0);
var i__12374_12432 = (0);
while(true){
if((i__12374_12432 < count__12373_12431)){
var vec__12381_12433 = chunk__12372_12430.cljs$core$IIndexed$_nth$arity$2(null,i__12374_12432);
var pno_12434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12381_12433,(0),null);
var pmask_12435 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12381_12433,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12434,"$ = ",pmask_12435,";");


var G__12436 = seq__12371_12429;
var G__12437 = chunk__12372_12430;
var G__12438 = count__12373_12431;
var G__12439 = (i__12374_12432 + (1));
seq__12371_12429 = G__12436;
chunk__12372_12430 = G__12437;
count__12373_12431 = G__12438;
i__12374_12432 = G__12439;
continue;
} else {
var temp__5753__auto___12440 = cljs.core.seq(seq__12371_12429);
if(temp__5753__auto___12440){
var seq__12371_12441__$1 = temp__5753__auto___12440;
if(cljs.core.chunked_seq_QMARK_(seq__12371_12441__$1)){
var c__4649__auto___12442 = cljs.core.chunk_first(seq__12371_12441__$1);
var G__12443 = cljs.core.chunk_rest(seq__12371_12441__$1);
var G__12444 = c__4649__auto___12442;
var G__12445 = cljs.core.count(c__4649__auto___12442);
var G__12446 = (0);
seq__12371_12429 = G__12443;
chunk__12372_12430 = G__12444;
count__12373_12431 = G__12445;
i__12374_12432 = G__12446;
continue;
} else {
var vec__12384_12447 = cljs.core.first(seq__12371_12441__$1);
var pno_12448 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12384_12447,(0),null);
var pmask_12449 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12384_12447,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12448,"$ = ",pmask_12449,";");


var G__12450 = cljs.core.next(seq__12371_12441__$1);
var G__12451 = null;
var G__12452 = (0);
var G__12453 = (0);
seq__12371_12429 = G__12450;
chunk__12372_12430 = G__12451;
count__12373_12431 = G__12452;
i__12374_12432 = G__12453;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__12454){
var map__12455 = p__12454;
var map__12455__$1 = cljs.core.__destructure_map(map__12455);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12455__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12455__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12455__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12455__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12455__$1,cljs.core.cst$kw$env);
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__12456){
var map__12457 = p__12456;
var map__12457__$1 = cljs.core.__destructure_map(map__12457);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12457__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12457__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12457__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12457__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12457__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__4221__auto__ = code;
if(cljs.core.truth_(and__4221__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4221__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__11257__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11257__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__12462 = cljs.core.seq(table);
var chunk__12463 = null;
var count__12464 = (0);
var i__12465 = (0);
while(true){
if((i__12465 < count__12464)){
var vec__12472 = chunk__12463.cljs$core$IIndexed$_nth$arity$2(null,i__12465);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12472,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12472,(1),null);
var ns_12478 = cljs.core.namespace(sym);
var name_12479 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__12480 = seq__12462;
var G__12481 = chunk__12463;
var G__12482 = count__12464;
var G__12483 = (i__12465 + (1));
seq__12462 = G__12480;
chunk__12463 = G__12481;
count__12464 = G__12482;
i__12465 = G__12483;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__12462);
if(temp__5753__auto__){
var seq__12462__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12462__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__12462__$1);
var G__12484 = cljs.core.chunk_rest(seq__12462__$1);
var G__12485 = c__4649__auto__;
var G__12486 = cljs.core.count(c__4649__auto__);
var G__12487 = (0);
seq__12462 = G__12484;
chunk__12463 = G__12485;
count__12464 = G__12486;
i__12465 = G__12487;
continue;
} else {
var vec__12475 = cljs.core.first(seq__12462__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12475,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12475,(1),null);
var ns_12488 = cljs.core.namespace(sym);
var name_12489 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__12490 = cljs.core.next(seq__12462__$1);
var G__12491 = null;
var G__12492 = (0);
var G__12493 = (0);
seq__12462 = G__12490;
chunk__12463 = G__12491;
count__12464 = G__12492;
i__12465 = G__12493;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__12495 = arguments.length;
switch (G__12495) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_12500 = cljs.core.first(ks);
var vec__12496_12501 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_12500);
var top_12502 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12496_12501,(0),null);
var prefix_SINGLEQUOTE__12503 = vec__12496_12501;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_12500)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__12503) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_12502)) || (cljs.core.contains_QMARK_(known_externs,top_12502)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__12503)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_12502);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__12503)),";");
}
} else {
}

var m_12504 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_12500);
if(cljs.core.empty_QMARK_(m_12504)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__12503,m_12504,top_level,known_externs);
}

var G__12505 = cljs.core.next(ks);
ks = G__12505;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

