// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__49757(s__49758){
return (new cljs.core.LazySeq(null,(function (){
var s__49758__$1 = s__49758;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__49758__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__49763 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49763,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49763,(1),null);
var iterys__4618__auto__ = ((function (s__49758__$1,vec__49763,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__49757_$_iter__49759(s__49760){
return (new cljs.core.LazySeq(null,((function (s__49758__$1,vec__49763,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__49760__$1 = s__49760;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__49760__$1);
if(temp__5753__auto____$1){
var s__49760__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__49760__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__49760__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__49762 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__49761 = (0);
while(true){
if((i__49761 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__49761);
cljs.core.chunk_append(b__49762,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__49815 = (i__49761 + (1));
i__49761 = G__49815;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__49762),tailrecursion$priority_map$iter__49757_$_iter__49759(cljs.core.chunk_rest(s__49760__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__49762),null);
}
} else {
var item = cljs.core.first(s__49760__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__49757_$_iter__49759(cljs.core.rest(s__49760__$2)));
}
} else {
return null;
}
break;
}
});})(s__49758__$1,vec__49763,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__49758__$1,vec__49763,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__49757(cljs.core.rest(s__49758__$1)));
} else {
var G__49816 = cljs.core.rest(s__49758__$1);
s__49758__$1 = G__49816;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__49766(s__49767){
return (new cljs.core.LazySeq(null,(function (){
var s__49767__$1 = s__49767;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__49767__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__49772 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49772,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49772,(1),null);
var iterys__4618__auto__ = ((function (s__49767__$1,vec__49772,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__49766_$_iter__49768(s__49769){
return (new cljs.core.LazySeq(null,((function (s__49767__$1,vec__49772,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__49769__$1 = s__49769;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__49769__$1);
if(temp__5753__auto____$1){
var s__49769__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__49769__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__49769__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__49771 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__49770 = (0);
while(true){
if((i__49770 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__49770);
cljs.core.chunk_append(b__49771,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__49817 = (i__49770 + (1));
i__49770 = G__49817;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__49771),tailrecursion$priority_map$iter__49766_$_iter__49768(cljs.core.chunk_rest(s__49769__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__49771),null);
}
} else {
var item = cljs.core.first(s__49769__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__49766_$_iter__49768(cljs.core.rest(s__49769__$2)));
}
} else {
return null;
}
break;
}
});})(s__49767__$1,vec__49772,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__49767__$1,vec__49772,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__49766(cljs.core.rest(s__49767__$1)));
} else {
var G__49818 = cljs.core.rest(s__49767__$1);
s__49767__$1 = G__49818;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__49775 = item;
var G__49776 = cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found;
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__49775,G__49776) : self__.item__GT_priority.call(null,G__49775,G__49776));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__49777(s__49778){
return (new cljs.core.LazySeq(null,(function (){
var s__49778__$1 = s__49778;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__49778__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__49783 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49783,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49783,(1),null);
var iterys__4618__auto__ = ((function (s__49778__$1,vec__49783,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__49777_$_iter__49779(s__49780){
return (new cljs.core.LazySeq(null,((function (s__49778__$1,vec__49783,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__49780__$1 = s__49780;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__49780__$1);
if(temp__5753__auto____$1){
var s__49780__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__49780__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__49780__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__49782 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__49781 = (0);
while(true){
if((i__49781 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__49781);
cljs.core.chunk_append(b__49782,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__49819 = (i__49781 + (1));
i__49781 = G__49819;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__49782),tailrecursion$priority_map$iter__49777_$_iter__49779(cljs.core.chunk_rest(s__49780__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__49782),null);
}
} else {
var item = cljs.core.first(s__49780__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__49777_$_iter__49779(cljs.core.rest(s__49780__$2)));
}
} else {
return null;
}
break;
}
});})(s__49778__$1,vec__49783,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__49778__$1,vec__49783,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__49777(cljs.core.rest(s__49778__$1)));
} else {
var G__49820 = cljs.core.rest(s__49778__$1);
s__49778__$1 = G__49820;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__49786(s__49787){
return (new cljs.core.LazySeq(null,(function (){
var s__49787__$1 = s__49787;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__49787__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__49792 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49792,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49792,(1),null);
var iterys__4618__auto__ = ((function (s__49787__$1,vec__49792,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__49786_$_iter__49788(s__49789){
return (new cljs.core.LazySeq(null,((function (s__49787__$1,vec__49792,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__49789__$1 = s__49789;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__49789__$1);
if(temp__5753__auto____$1){
var s__49789__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__49789__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__49789__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__49791 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__49790 = (0);
while(true){
if((i__49790 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__49790);
cljs.core.chunk_append(b__49791,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__49821 = (i__49790 + (1));
i__49790 = G__49821;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__49791),tailrecursion$priority_map$iter__49786_$_iter__49788(cljs.core.chunk_rest(s__49789__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__49791),null);
}
} else {
var item = cljs.core.first(s__49789__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__49786_$_iter__49788(cljs.core.rest(s__49789__$2)));
}
} else {
return null;
}
break;
}
});})(s__49787__$1,vec__49792,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__49787__$1,vec__49792,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__49786(cljs.core.rest(s__49787__$1)));
} else {
var G__49822 = cljs.core.rest(s__49787__$1);
s__49787__$1 = G__49822;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__49823 = null;
var G__49823__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__49823__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__49823 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__49823__2.call(this,self__,item);
case 3:
return G__49823__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__49823.cljs$core$IFn$_invoke$arity$2 = G__49823__2;
G__49823.cljs$core$IFn$_invoke$arity$3 = G__49823__3;
return G__49823;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args49756){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args49756)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__49795 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__49795.cljs$core$IFn$_invoke$arity$1 ? fexpr__49795.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__49795.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__49796(s__49797){
return (new cljs.core.LazySeq(null,(function (){
var s__49797__$1 = s__49797;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__49797__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__49802 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49802,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49802,(1),null);
var iterys__4618__auto__ = ((function (s__49797__$1,vec__49802,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__49796_$_iter__49798(s__49799){
return (new cljs.core.LazySeq(null,((function (s__49797__$1,vec__49802,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__49799__$1 = s__49799;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__49799__$1);
if(temp__5753__auto____$1){
var s__49799__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__49799__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__49799__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__49801 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__49800 = (0);
while(true){
if((i__49800 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__49800);
cljs.core.chunk_append(b__49801,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__49824 = (i__49800 + (1));
i__49800 = G__49824;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__49801),tailrecursion$priority_map$iter__49796_$_iter__49798(cljs.core.chunk_rest(s__49799__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__49801),null);
}
} else {
var item = cljs.core.first(s__49799__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__49796_$_iter__49798(cljs.core.rest(s__49799__$2)));
}
} else {
return null;
}
break;
}
});})(s__49797__$1,vec__49802,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__49797__$1,vec__49802,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__49796(cljs.core.rest(s__49797__$1)));
} else {
var G__49825 = cljs.core.rest(s__49797__$1);
s__49797__$1 = G__49825;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__49805(s__49806){
return (new cljs.core.LazySeq(null,(function (){
var s__49806__$1 = s__49806;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__49806__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__49811 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49811,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49811,(1),null);
var iterys__4618__auto__ = ((function (s__49806__$1,vec__49811,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__49805_$_iter__49807(s__49808){
return (new cljs.core.LazySeq(null,((function (s__49806__$1,vec__49811,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__49808__$1 = s__49808;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__49808__$1);
if(temp__5753__auto____$1){
var s__49808__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__49808__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__49808__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__49810 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__49809 = (0);
while(true){
if((i__49809 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__49809);
cljs.core.chunk_append(b__49810,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__49826 = (i__49809 + (1));
i__49809 = G__49826;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__49810),tailrecursion$priority_map$iter__49805_$_iter__49807(cljs.core.chunk_rest(s__49808__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__49810),null);
}
} else {
var item = cljs.core.first(s__49808__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__49805_$_iter__49807(cljs.core.rest(s__49808__$2)));
}
} else {
return null;
}
break;
}
});})(s__49806__$1,vec__49811,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__49806__$1,vec__49811,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__49805(cljs.core.rest(s__49806__$1)));
} else {
var G__49827 = cljs.core.rest(s__49806__$1);
s__49806__$1 = G__49827;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__49814 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__49814) : self__.keyfn.call(null,G__49814));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$priority_DASH__GT_set_DASH_of_DASH_items,cljs.core.cst$sym$item_DASH__GT_priority,cljs.core.cst$sym$meta,cljs.core.cst$sym$keyfn,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__49829 = arguments.length;
switch (G__49829) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4835__auto__ = [];
var len__4829__auto___49832 = arguments.length;
var i__4830__auto___49833 = (0);
while(true){
if((i__4830__auto___49833 < len__4829__auto___49832)){
args__4835__auto__.push((arguments[i__4830__auto___49833]));

var G__49834 = (i__4830__auto___49833 + (1));
i__4830__auto___49833 = G__49834;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__49835 = cljs.core.nnext(in$);
var G__49836 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__49835;
out = G__49836;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq49831){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq49831));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4835__auto__ = [];
var len__4829__auto___49839 = arguments.length;
var i__4830__auto___49840 = (0);
while(true){
if((i__4830__auto___49840 < len__4829__auto___49839)){
args__4835__auto__.push((arguments[i__4830__auto___49840]));

var G__49841 = (i__4830__auto___49840 + (1));
i__4830__auto___49840 = G__49841;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__49842 = cljs.core.nnext(in$);
var G__49843 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__49842;
out = G__49843;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq49837){
var G__49838 = cljs.core.first(seq49837);
var seq49837__$1 = cljs.core.next(seq49837);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49838,seq49837__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4835__auto__ = [];
var len__4829__auto___49846 = arguments.length;
var i__4830__auto___49847 = (0);
while(true){
if((i__4830__auto___49847 < len__4829__auto___49846)){
args__4835__auto__.push((arguments[i__4830__auto___49847]));

var G__49848 = (i__4830__auto___49847 + (1));
i__4830__auto___49847 = G__49848;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__49849 = cljs.core.nnext(in$);
var G__49850 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__49849;
out = G__49850;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq49844){
var G__49845 = cljs.core.first(seq49844);
var seq49844__$1 = cljs.core.next(seq49844);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49845,seq49844__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4835__auto__ = [];
var len__4829__auto___49854 = arguments.length;
var i__4830__auto___49855 = (0);
while(true){
if((i__4830__auto___49855 < len__4829__auto___49854)){
args__4835__auto__.push((arguments[i__4830__auto___49855]));

var G__49856 = (i__4830__auto___49855 + (1));
i__4830__auto___49855 = G__49856;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__49857 = cljs.core.nnext(in$);
var G__49858 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__49857;
out = G__49858;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq49851){
var G__49852 = cljs.core.first(seq49851);
var seq49851__$1 = cljs.core.next(seq49851);
var G__49853 = cljs.core.first(seq49851__$1);
var seq49851__$2 = cljs.core.next(seq49851__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49852,G__49853,seq49851__$2);
}));

