// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__91050 = (line + (1));
var G__91051 = (1);
var G__91052 = (counter + (1));
line = G__91050;
col = G__91051;
counter = G__91052;
continue;
} else {
var G__91053 = line;
var G__91054 = (col + (1));
var G__91055 = (counter + (1));
line = G__91053;
col = G__91054;
counter = G__91055;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__91056 = cljs.core.next(chars);
var G__91057 = (n__$1 - (1));
chars = G__91056;
n__$1 = G__91057;
continue;
} else {
var G__91058 = cljs.core.next(chars);
var G__91059 = n__$1;
chars = G__91058;
n__$1 = G__91059;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__91060){
var map__91061 = p__91060;
var map__91061__$1 = cljs.core.__destructure_map(map__91061);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__91061__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__91061__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__91061__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__91061__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__91062_91070 = cljs.core.seq(full_reasons);
var chunk__91063_91071 = null;
var count__91064_91072 = (0);
var i__91065_91073 = (0);
while(true){
if((i__91065_91073 < count__91064_91072)){
var r_91074 = chunk__91063_91071.cljs$core$IIndexed$_nth$arity$2(null,i__91065_91073);
instaparse.failure.print_reason(r_91074);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__91075 = seq__91062_91070;
var G__91076 = chunk__91063_91071;
var G__91077 = count__91064_91072;
var G__91078 = (i__91065_91073 + (1));
seq__91062_91070 = G__91075;
chunk__91063_91071 = G__91076;
count__91064_91072 = G__91077;
i__91065_91073 = G__91078;
continue;
} else {
var temp__5753__auto___91079 = cljs.core.seq(seq__91062_91070);
if(temp__5753__auto___91079){
var seq__91062_91080__$1 = temp__5753__auto___91079;
if(cljs.core.chunked_seq_QMARK_(seq__91062_91080__$1)){
var c__4649__auto___91081 = cljs.core.chunk_first(seq__91062_91080__$1);
var G__91082 = cljs.core.chunk_rest(seq__91062_91080__$1);
var G__91083 = c__4649__auto___91081;
var G__91084 = cljs.core.count(c__4649__auto___91081);
var G__91085 = (0);
seq__91062_91070 = G__91082;
chunk__91063_91071 = G__91083;
count__91064_91072 = G__91084;
i__91065_91073 = G__91085;
continue;
} else {
var r_91086 = cljs.core.first(seq__91062_91080__$1);
instaparse.failure.print_reason(r_91086);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__91087 = cljs.core.next(seq__91062_91080__$1);
var G__91088 = null;
var G__91089 = (0);
var G__91090 = (0);
seq__91062_91070 = G__91087;
chunk__91063_91071 = G__91088;
count__91064_91072 = G__91089;
i__91065_91073 = G__91090;
continue;
}
} else {
}
}
break;
}

var seq__91066 = cljs.core.seq(partial_reasons);
var chunk__91067 = null;
var count__91068 = (0);
var i__91069 = (0);
while(true){
if((i__91069 < count__91068)){
var r = chunk__91067.cljs$core$IIndexed$_nth$arity$2(null,i__91069);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__91091 = seq__91066;
var G__91092 = chunk__91067;
var G__91093 = count__91068;
var G__91094 = (i__91069 + (1));
seq__91066 = G__91091;
chunk__91067 = G__91092;
count__91068 = G__91093;
i__91069 = G__91094;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__91066);
if(temp__5753__auto__){
var seq__91066__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__91066__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__91066__$1);
var G__91095 = cljs.core.chunk_rest(seq__91066__$1);
var G__91096 = c__4649__auto__;
var G__91097 = cljs.core.count(c__4649__auto__);
var G__91098 = (0);
seq__91066 = G__91095;
chunk__91067 = G__91096;
count__91068 = G__91097;
i__91069 = G__91098;
continue;
} else {
var r = cljs.core.first(seq__91066__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__91099 = cljs.core.next(seq__91066__$1);
var G__91100 = null;
var G__91101 = (0);
var G__91102 = (0);
seq__91066 = G__91099;
chunk__91067 = G__91100;
count__91068 = G__91101;
i__91069 = G__91102;
continue;
}
} else {
return null;
}
}
break;
}
});
