// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__35825 = arguments.length;
switch (G__35825) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(x,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$keyword_DASH_fn,fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__35826 = options;
var map__35826__$1 = cljs.core.__destructure_map(map__35826);
var keyword_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35826__$1,cljs.core.cst$kw$keyword_DASH_fn);
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.cljs$core$IFn$_invoke$arity$2(k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js(x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return (keyword_fn.cljs$core$IFn$_invoke$arity$1 ? keyword_fn.cljs$core$IFn$_invoke$arity$1(x__$1) : keyword_fn.call(null,x__$1));
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_(x__$1)){
var m = ({});
var seq__35853_35874 = cljs.core.seq(x__$1);
var chunk__35854_35875 = null;
var count__35855_35876 = (0);
var i__35856_35877 = (0);
while(true){
if((i__35856_35877 < count__35855_35876)){
var vec__35863_35878 = chunk__35854_35875.cljs$core$IIndexed$_nth$arity$2(null,i__35856_35877);
var k_35879 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35863_35878,(0),null);
var v_35880 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35863_35878,(1),null);
goog.object.set(m,keyfn(k_35879),fluree$db$util$json$thisfn(v_35880));


var G__35881 = seq__35853_35874;
var G__35882 = chunk__35854_35875;
var G__35883 = count__35855_35876;
var G__35884 = (i__35856_35877 + (1));
seq__35853_35874 = G__35881;
chunk__35854_35875 = G__35882;
count__35855_35876 = G__35883;
i__35856_35877 = G__35884;
continue;
} else {
var temp__5753__auto___35885 = cljs.core.seq(seq__35853_35874);
if(temp__5753__auto___35885){
var seq__35853_35886__$1 = temp__5753__auto___35885;
if(cljs.core.chunked_seq_QMARK_(seq__35853_35886__$1)){
var c__4649__auto___35887 = cljs.core.chunk_first(seq__35853_35886__$1);
var G__35888 = cljs.core.chunk_rest(seq__35853_35886__$1);
var G__35889 = c__4649__auto___35887;
var G__35890 = cljs.core.count(c__4649__auto___35887);
var G__35891 = (0);
seq__35853_35874 = G__35888;
chunk__35854_35875 = G__35889;
count__35855_35876 = G__35890;
i__35856_35877 = G__35891;
continue;
} else {
var vec__35866_35892 = cljs.core.first(seq__35853_35886__$1);
var k_35893 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35866_35892,(0),null);
var v_35894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35866_35892,(1),null);
goog.object.set(m,keyfn(k_35893),fluree$db$util$json$thisfn(v_35894));


var G__35895 = cljs.core.next(seq__35853_35886__$1);
var G__35896 = null;
var G__35897 = (0);
var G__35898 = (0);
seq__35853_35874 = G__35895;
chunk__35854_35875 = G__35896;
count__35855_35876 = G__35897;
i__35856_35877 = G__35898;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x__$1)){
var arr = [];
var seq__35869_35899 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree$db$util$json$thisfn,x__$1));
var chunk__35870_35900 = null;
var count__35871_35901 = (0);
var i__35872_35902 = (0);
while(true){
if((i__35872_35902 < count__35871_35901)){
var x_35903__$2 = chunk__35870_35900.cljs$core$IIndexed$_nth$arity$2(null,i__35872_35902);
arr.push(x_35903__$2);


var G__35904 = seq__35869_35899;
var G__35905 = chunk__35870_35900;
var G__35906 = count__35871_35901;
var G__35907 = (i__35872_35902 + (1));
seq__35869_35899 = G__35904;
chunk__35870_35900 = G__35905;
count__35871_35901 = G__35906;
i__35872_35902 = G__35907;
continue;
} else {
var temp__5753__auto___35908 = cljs.core.seq(seq__35869_35899);
if(temp__5753__auto___35908){
var seq__35869_35909__$1 = temp__5753__auto___35908;
if(cljs.core.chunked_seq_QMARK_(seq__35869_35909__$1)){
var c__4649__auto___35910 = cljs.core.chunk_first(seq__35869_35909__$1);
var G__35911 = cljs.core.chunk_rest(seq__35869_35909__$1);
var G__35912 = c__4649__auto___35910;
var G__35913 = cljs.core.count(c__4649__auto___35910);
var G__35914 = (0);
seq__35869_35899 = G__35911;
chunk__35870_35900 = G__35912;
count__35871_35901 = G__35913;
i__35872_35902 = G__35914;
continue;
} else {
var x_35915__$2 = cljs.core.first(seq__35869_35909__$1);
arr.push(x_35915__$2);


var G__35916 = cljs.core.next(seq__35869_35909__$1);
var G__35917 = null;
var G__35918 = (0);
var G__35919 = (0);
seq__35869_35899 = G__35916;
chunk__35870_35900 = G__35917;
count__35871_35901 = G__35918;
i__35872_35902 = G__35919;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn(x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string(x))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0));
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1(x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js(x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8(fluree.db.util.json.stringify(x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),depth)){
return ((cljs.core.every_QMARK_(cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count(coordinates))));
} else {
return (((!((coordinates == null)))) && (((cljs.core.every_QMARK_(cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35920_SHARP_){
var G__35921 = (depth - (1));
var G__35922 = p1__35920_SHARP_;
return (fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2 ? fluree.db.util.json.valid_coordinates_QMARK_.cljs$core$IFn$_invoke$arity$2(G__35921,G__35922) : fluree.db.util.json.valid_coordinates_QMARK_.call(null,G__35921,G__35922));
}),coordinates))))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_(coordinates)) && (((((4) <= cljs.core.count(coordinates))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(coordinates),cljs.core.last(coordinates))))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__35923 = cljs.core.get_global_hierarchy;
return (fexpr__35923.cljs$core$IFn$_invoke$arity$0 ? fexpr__35923.cljs$core$IFn$_invoke$arity$0() : fexpr__35923.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.util.json","valid-geojson?"),cljs.core.cst$kw$type,cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Feature",(function (geometry){
var and__4221__auto__ = (function (){var or__4223__auto__ = (function (){var G__35924 = cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(geometry);
return (fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1 ? fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IFn$_invoke$arity$1(G__35924) : fluree.db.util.json.valid_geojson_QMARK_.call(null,G__35924));
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return (cljs.core.cst$kw$geometry.cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__4221__auto__)){
return ((cljs.core.map_QMARK_(cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(geometry))) || ((cljs.core.cst$kw$properties.cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__4221__auto__;
}
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,cljs.core.cst$kw$features.cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_(cljs.core.cst$kw$geometries.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(cljs.core.true_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.util.json.valid_geojson_QMARK_,cljs.core.cst$kw$geometries.cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((1),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((3),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((2),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_((3),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_((4),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_((function (p1__35925_SHARP_){
return cljs.core.every_QMARK_(fluree.db.util.json.linear_ring_QMARK_,p1__35925_SHARP_);
}),cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(geometry))));
}));
fluree.db.util.json.valid_geojson_QMARK_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (geometry){
return false;
}));
