// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4223__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_32936){
var state_val_32937 = (state_32936[(1)]);
if((state_val_32937 === (7))){
var inst_32931 = (state_32936[(2)]);
var _ = (function (){var statearr_32938 = state_32936;
(statearr_32938[(4)] = cljs.core.rest((state_32936[(4)])));

return statearr_32938;
})();
var state_32936__$1 = state_32936;
var statearr_32939_32961 = state_32936__$1;
(statearr_32939_32961[(2)] = inst_32931);

(statearr_32939_32961[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32937 === (1))){
var state_32936__$1 = state_32936;
var statearr_32940_32962 = state_32936__$1;
(statearr_32940_32962[(2)] = null);

(statearr_32940_32962[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32937 === (4))){
var inst_32893 = (state_32936[(2)]);
var state_32936__$1 = state_32936;
var statearr_32941_32963 = state_32936__$1;
(statearr_32941_32963[(2)] = inst_32893);

(statearr_32941_32963[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32937 === (6))){
var inst_32918 = (state_32936[(7)]);
var inst_32911 = (state_32936[(8)]);
var inst_32917 = cljs.core.seq(inst_32911);
var inst_32918__$1 = cljs.core.first(inst_32917);
var inst_32919 = cljs.core.next(inst_32917);
var inst_32920 = cljs.core.not(inst_32918__$1);
var state_32936__$1 = (function (){var statearr_32942 = state_32936;
(statearr_32942[(7)] = inst_32918__$1);

(statearr_32942[(9)] = inst_32919);

return statearr_32942;
})();
if(inst_32920){
var statearr_32943_32964 = state_32936__$1;
(statearr_32943_32964[(1)] = (8));

} else {
var statearr_32944_32965 = state_32936__$1;
(statearr_32944_32965[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32937 === (3))){
var inst_32934 = (state_32936[(2)]);
var state_32936__$1 = state_32936;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32936__$1,inst_32934);
} else {
if((state_val_32937 === (2))){
var _ = (function (){var statearr_32945 = state_32936;
(statearr_32945[(4)] = cljs.core.cons((5),(state_32936[(4)])));

return statearr_32945;
})();
var inst_32906 = chs;
var inst_32907 = cljs.core.seq(inst_32906);
var inst_32908 = cljs.core.first(inst_32907);
var inst_32909 = cljs.core.next(inst_32907);
var inst_32910 = coll;
var inst_32911 = inst_32906;
var inst_32912 = inst_32910;
var state_32936__$1 = (function (){var statearr_32946 = state_32936;
(statearr_32946[(8)] = inst_32911);

(statearr_32946[(10)] = inst_32908);

(statearr_32946[(11)] = inst_32909);

(statearr_32946[(12)] = inst_32912);

return statearr_32946;
})();
var statearr_32947_32966 = state_32936__$1;
(statearr_32947_32966[(2)] = null);

(statearr_32947_32966[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32937 === (11))){
var inst_32919 = (state_32936[(9)]);
var inst_32912 = (state_32936[(12)]);
var inst_32924 = (state_32936[(2)]);
var inst_32925 = fluree.db.util.async.throw_err(inst_32924);
var inst_32926 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32912,inst_32925);
var inst_32911 = inst_32919;
var inst_32912__$1 = inst_32926;
var state_32936__$1 = (function (){var statearr_32949 = state_32936;
(statearr_32949[(8)] = inst_32911);

(statearr_32949[(12)] = inst_32912__$1);

return statearr_32949;
})();
var statearr_32950_32967 = state_32936__$1;
(statearr_32950_32967[(2)] = null);

(statearr_32950_32967[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32937 === (9))){
var inst_32918 = (state_32936[(7)]);
var state_32936__$1 = state_32936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32936__$1,(11),inst_32918);
} else {
if((state_val_32937 === (5))){
var _ = (function (){var statearr_32951 = state_32936;
(statearr_32951[(4)] = cljs.core.rest((state_32936[(4)])));

return statearr_32951;
})();
var state_32936__$1 = state_32936;
var ex32948 = (state_32936__$1[(2)]);
var statearr_32952_32968 = state_32936__$1;
(statearr_32952_32968[(5)] = ex32948);


var statearr_32953_32969 = state_32936__$1;
(statearr_32953_32969[(1)] = (4));

(statearr_32953_32969[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32937 === (10))){
var inst_32929 = (state_32936[(2)]);
var state_32936__$1 = state_32936;
var statearr_32954_32970 = state_32936__$1;
(statearr_32954_32970[(2)] = inst_32929);

(statearr_32954_32970[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32937 === (8))){
var inst_32912 = (state_32936[(12)]);
var state_32936__$1 = state_32936;
var statearr_32955_32971 = state_32936__$1;
(statearr_32955_32971[(2)] = inst_32912);

(statearr_32955_32971[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__20477__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__20477__auto____0 = (function (){
var statearr_32956 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32956[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__20477__auto__);

(statearr_32956[(1)] = (1));

return statearr_32956;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__20477__auto____1 = (function (state_32936){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_32936);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e32957){var ex__20480__auto__ = e32957;
var statearr_32958_32972 = state_32936;
(statearr_32958_32972[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_32936[(4)]))){
var statearr_32959_32973 = state_32936;
(statearr_32959_32973[(1)] = cljs.core.first((state_32936[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__32974 = state_32936;
state_32936 = G__32974;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__20477__auto__ = function(state_32936){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__20477__auto____1.call(this,state_32936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__20477__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__20477__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_32960 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_32960[(6)] = c__20603__auto__);

return statearr_32960;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_33000){
var state_val_33001 = (state_33000[(1)]);
if((state_val_33001 === (7))){
var inst_32995 = (state_33000[(2)]);
var _ = (function (){var statearr_33002 = state_33000;
(statearr_33002[(4)] = cljs.core.rest((state_33000[(4)])));

return statearr_33002;
})();
var state_33000__$1 = state_33000;
var statearr_33003_33025 = state_33000__$1;
(statearr_33003_33025[(2)] = inst_32995);

(statearr_33003_33025[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (1))){
var state_33000__$1 = state_33000;
var statearr_33004_33026 = state_33000__$1;
(statearr_33004_33026[(2)] = null);

(statearr_33004_33026[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (4))){
var inst_32975 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
var statearr_33005_33027 = state_33000__$1;
(statearr_33005_33027[(2)] = inst_32975);

(statearr_33005_33027[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (6))){
var state_33000__$1 = state_33000;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33000__$1,(8),chan);
} else {
if((state_val_33001 === (3))){
var inst_32998 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33000__$1,inst_32998);
} else {
if((state_val_33001 === (2))){
var _ = (function (){var statearr_33006 = state_33000;
(statearr_33006[(4)] = cljs.core.cons((5),(state_33000[(4)])));

return statearr_33006;
})();
var inst_32981 = coll;
var inst_32982 = inst_32981;
var state_33000__$1 = (function (){var statearr_33007 = state_33000;
(statearr_33007[(7)] = inst_32982);

return statearr_33007;
})();
var statearr_33008_33028 = state_33000__$1;
(statearr_33008_33028[(2)] = null);

(statearr_33008_33028[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (11))){
var inst_32993 = (state_33000[(2)]);
var state_33000__$1 = state_33000;
var statearr_33010_33029 = state_33000__$1;
(statearr_33010_33029[(2)] = inst_32993);

(statearr_33010_33029[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (9))){
var inst_32982 = (state_33000[(7)]);
var state_33000__$1 = state_33000;
var statearr_33011_33030 = state_33000__$1;
(statearr_33011_33030[(2)] = inst_32982);

(statearr_33011_33030[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (5))){
var _ = (function (){var statearr_33012 = state_33000;
(statearr_33012[(4)] = cljs.core.rest((state_33000[(4)])));

return statearr_33012;
})();
var state_33000__$1 = state_33000;
var ex33009 = (state_33000__$1[(2)]);
var statearr_33013_33031 = state_33000__$1;
(statearr_33013_33031[(5)] = ex33009);


var statearr_33014_33032 = state_33000__$1;
(statearr_33014_33032[(1)] = (4));

(statearr_33014_33032[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (10))){
var inst_32986 = (state_33000[(8)]);
var inst_32982 = (state_33000[(7)]);
var inst_32990 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32982,inst_32986);
var inst_32982__$1 = inst_32990;
var state_33000__$1 = (function (){var statearr_33015 = state_33000;
(statearr_33015[(7)] = inst_32982__$1);

return statearr_33015;
})();
var statearr_33016_33033 = state_33000__$1;
(statearr_33016_33033[(2)] = null);

(statearr_33016_33033[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33001 === (8))){
var inst_32986 = (state_33000[(8)]);
var inst_32985 = (state_33000[(2)]);
var inst_32986__$1 = fluree.db.util.async.throw_err(inst_32985);
var inst_32987 = (inst_32986__$1 == null);
var state_33000__$1 = (function (){var statearr_33017 = state_33000;
(statearr_33017[(8)] = inst_32986__$1);

return statearr_33017;
})();
if(cljs.core.truth_(inst_32987)){
var statearr_33018_33034 = state_33000__$1;
(statearr_33018_33034[(1)] = (9));

} else {
var statearr_33019_33035 = state_33000__$1;
(statearr_33019_33035[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__20477__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__20477__auto____0 = (function (){
var statearr_33020 = [null,null,null,null,null,null,null,null,null];
(statearr_33020[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__20477__auto__);

(statearr_33020[(1)] = (1));

return statearr_33020;
});
var fluree$db$util$async$into_QMARK__$_state_machine__20477__auto____1 = (function (state_33000){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_33000);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e33021){var ex__20480__auto__ = e33021;
var statearr_33022_33036 = state_33000;
(statearr_33022_33036[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_33000[(4)]))){
var statearr_33023_33037 = state_33000;
(statearr_33023_33037[(1)] = cljs.core.first((state_33000[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__33038 = state_33000;
state_33000 = G__33038;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__20477__auto__ = function(state_33000){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__20477__auto____1.call(this,state_33000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__20477__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__20477__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_33024 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_33024[(6)] = c__20603__auto__);

return statearr_33024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
