// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.time_travel');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.range');
goog.require('clojure.string');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
/**
 * Given a duration, returns a ISO-8601 formatted time string of now minus duration
 */
fluree.db.time_travel.duration_parse = (function fluree$db$time_travel$duration_parse(time_str){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Duration timeframes not yet supported in javascript.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_platform_DASH_support], null));
});
fluree.db.time_travel.time_to_t = (function fluree$db$time_travel$time_to_t(db,time_str){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_38041){
var state_val_38042 = (state_38041[(1)]);
if((state_val_38042 === (7))){
var state_38041__$1 = state_38041;
var statearr_38043_38085 = state_38041__$1;
(statearr_38043_38085[(2)] = time_str);

(statearr_38043_38085[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (20))){
var inst_38026 = (state_38041[(7)]);
var state_38041__$1 = state_38041;
if(cljs.core.truth_(inst_38026)){
var statearr_38044_38086 = state_38041__$1;
(statearr_38044_38086[(1)] = (22));

} else {
var statearr_38045_38087 = state_38041__$1;
(statearr_38045_38087[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (1))){
var state_38041__$1 = state_38041;
var statearr_38046_38088 = state_38041__$1;
(statearr_38046_38088[(2)] = null);

(statearr_38046_38088[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (24))){
var inst_38034 = (state_38041[(2)]);
var state_38041__$1 = state_38041;
var statearr_38047_38089 = state_38041__$1;
(statearr_38047_38089[(2)] = inst_38034);

(statearr_38047_38089[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (4))){
var inst_37980 = (state_38041[(2)]);
var state_38041__$1 = state_38041;
var statearr_38048_38090 = state_38041__$1;
(statearr_38048_38090[(2)] = inst_37980);

(statearr_38048_38090[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (15))){
var inst_38010 = (state_38041[(2)]);
var inst_38011 = fluree.db.util.async.throw_err(inst_38010);
var state_38041__$1 = state_38041;
var statearr_38049_38091 = state_38041__$1;
(statearr_38049_38091[(2)] = inst_38011);

(statearr_38049_38091[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (21))){
var inst_38036 = (state_38041[(2)]);
var _ = (function (){var statearr_38050 = state_38041;
(statearr_38050[(4)] = cljs.core.rest((state_38041[(4)])));

return statearr_38050;
})();
var state_38041__$1 = state_38041;
var statearr_38051_38092 = state_38041__$1;
(statearr_38051_38092[(2)] = inst_38036);

(statearr_38051_38092[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (13))){
var inst_38005 = (state_38041[(8)]);
var state_38041__$1 = state_38041;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38041__$1,(15),inst_38005);
} else {
if((state_val_38042 === (22))){
var inst_38026 = (state_38041[(7)]);
var state_38041__$1 = state_38041;
var statearr_38052_38093 = state_38041__$1;
(statearr_38052_38093[(2)] = inst_38026);

(statearr_38052_38093[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (6))){
var inst_37988 = fluree.db.util.core.str__GT_epoch_ms(time_str);
var state_38041__$1 = state_38041;
var statearr_38053_38094 = state_38041__$1;
(statearr_38053_38094[(2)] = inst_37988);

(statearr_38053_38094[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (17))){
var state_38041__$1 = state_38041;
var statearr_38054_38095 = state_38041__$1;
(statearr_38054_38095[(2)] = null);

(statearr_38054_38095[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (3))){
var inst_38039 = (state_38041[(2)]);
var state_38041__$1 = state_38041;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38041__$1,inst_38039);
} else {
if((state_val_38042 === (12))){
var state_38041__$1 = state_38041;
var statearr_38055_38096 = state_38041__$1;
(statearr_38055_38096[(2)] = null);

(statearr_38055_38096[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (2))){
var _ = (function (){var statearr_38056 = state_38041;
(statearr_38056[(4)] = cljs.core.cons((5),(state_38041[(4)])));

return statearr_38056;
})();
var inst_37986 = typeof time_str === 'string';
var state_38041__$1 = state_38041;
if(cljs.core.truth_(inst_37986)){
var statearr_38057_38097 = state_38041__$1;
(statearr_38057_38097[(1)] = (6));

} else {
var statearr_38058_38098 = state_38041__$1;
(statearr_38058_38098[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (23))){
var inst_38032 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_38041__$1 = state_38041;
var statearr_38059_38099 = state_38041__$1;
(statearr_38059_38099[(2)] = inst_38032);

(statearr_38059_38099[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (19))){
var inst_38027 = (state_38041[(9)]);
var state_38041__$1 = state_38041;
var statearr_38060_38100 = state_38041__$1;
(statearr_38060_38100[(2)] = inst_38027);

(statearr_38060_38100[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (11))){
var inst_38005 = (state_38041[(8)]);
var inst_38005__$1 = (state_38041[(2)]);
var inst_38006 = (inst_38005__$1 == null);
var state_38041__$1 = (function (){var statearr_38062 = state_38041;
(statearr_38062[(8)] = inst_38005__$1);

return statearr_38062;
})();
if(cljs.core.truth_(inst_38006)){
var statearr_38063_38101 = state_38041__$1;
(statearr_38063_38101[(1)] = (12));

} else {
var statearr_38064_38102 = state_38041__$1;
(statearr_38064_38102[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (9))){
var state_38041__$1 = state_38041;
var statearr_38065_38103 = state_38041__$1;
(statearr_38065_38103[(2)] = null);

(statearr_38065_38103[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (5))){
var _ = (function (){var statearr_38066 = state_38041;
(statearr_38066[(4)] = cljs.core.rest((state_38041[(4)])));

return statearr_38066;
})();
var state_38041__$1 = state_38041;
var ex38061 = (state_38041__$1[(2)]);
var statearr_38067_38104 = state_38041__$1;
(statearr_38067_38104[(5)] = ex38061);


if((ex38061 instanceof Error)){
var statearr_38068_38105 = state_38041__$1;
(statearr_38068_38105[(1)] = (4));

(statearr_38068_38105[(5)] = null);

} else {
throw ex38061;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (14))){
var inst_38013 = (state_38041[(10)]);
var inst_38013__$1 = (state_38041[(2)]);
var inst_38014 = cljs.core.empty_QMARK_(inst_38013__$1);
var state_38041__$1 = (function (){var statearr_38069 = state_38041;
(statearr_38069[(10)] = inst_38013__$1);

return statearr_38069;
})();
if(inst_38014){
var statearr_38070_38106 = state_38041__$1;
(statearr_38070_38106[(1)] = (16));

} else {
var statearr_38071_38107 = state_38041__$1;
(statearr_38071_38107[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (16))){
var inst_37991 = (state_38041[(11)]);
var inst_38016 = ["There is no data as of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_37991)].join('');
var inst_38017 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38018 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_block];
var inst_38019 = cljs.core.PersistentHashMap.fromArrays(inst_38017,inst_38018);
var inst_38020 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38016,inst_38019);
var inst_38021 = (function(){throw inst_38020})();
var state_38041__$1 = state_38041;
var statearr_38072_38108 = state_38041__$1;
(statearr_38072_38108[(2)] = inst_38021);

(statearr_38072_38108[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (10))){
var inst_37993 = (state_38041[(12)]);
var inst_37991 = (state_38041[(11)]);
var inst_37997 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37998 = ["_block/instant",(0)];
var inst_37999 = (new cljs.core.PersistentVector(null,2,(5),inst_37997,inst_37998,null));
var inst_38000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38001 = ["_block/instant",inst_37991];
var inst_38002 = (new cljs.core.PersistentVector(null,2,(5),inst_38000,inst_38001,null));
var inst_38003 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(inst_37993,cljs.core.cst$kw$post,cljs.core._GT_,inst_37999,cljs.core._LT_,inst_38002);
var state_38041__$1 = state_38041;
var statearr_38073_38109 = state_38041__$1;
(statearr_38073_38109[(2)] = inst_38003);

(statearr_38073_38109[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (18))){
var inst_38013 = (state_38041[(10)]);
var inst_38026 = (state_38041[(7)]);
var inst_38027 = (state_38041[(9)]);
var inst_37991 = (state_38041[(11)]);
var inst_38024 = (state_38041[(2)]);
var inst_38025 = (function (){var epoch_as_of = inst_37991;
var ts = inst_38013;
var _ = inst_38024;
return (function (p1__37979_SHARP_){
return p1__37979_SHARP_.s;
});
})();
var inst_38026__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.min_key,inst_38025,inst_38013);
var inst_38027__$1 = inst_38026__$1.s;
var state_38041__$1 = (function (){var statearr_38074 = state_38041;
(statearr_38074[(7)] = inst_38026__$1);

(statearr_38074[(9)] = inst_38027__$1);

return statearr_38074;
})();
if(cljs.core.truth_(inst_38027__$1)){
var statearr_38075_38110 = state_38041__$1;
(statearr_38075_38110[(1)] = (19));

} else {
var statearr_38076_38111 = state_38041__$1;
(statearr_38076_38111[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38042 === (8))){
var inst_37993 = (state_38041[(12)]);
var inst_37991 = (state_38041[(2)]);
var inst_37993__$1 = fluree.db.dbproto._rootdb(db);
var inst_37994 = (inst_37993__$1 == null);
var state_38041__$1 = (function (){var statearr_38077 = state_38041;
(statearr_38077[(12)] = inst_37993__$1);

(statearr_38077[(11)] = inst_37991);

return statearr_38077;
})();
if(cljs.core.truth_(inst_37994)){
var statearr_38078_38112 = state_38041__$1;
(statearr_38078_38112[(1)] = (9));

} else {
var statearr_38079_38113 = state_38041__$1;
(statearr_38079_38113[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$time_to_t_$_state_machine__20477__auto__ = null;
var fluree$db$time_travel$time_to_t_$_state_machine__20477__auto____0 = (function (){
var statearr_38080 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38080[(0)] = fluree$db$time_travel$time_to_t_$_state_machine__20477__auto__);

(statearr_38080[(1)] = (1));

return statearr_38080;
});
var fluree$db$time_travel$time_to_t_$_state_machine__20477__auto____1 = (function (state_38041){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_38041);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e38081){var ex__20480__auto__ = e38081;
var statearr_38082_38114 = state_38041;
(statearr_38082_38114[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_38041[(4)]))){
var statearr_38083_38115 = state_38041;
(statearr_38083_38115[(1)] = cljs.core.first((state_38041[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__38116 = state_38041;
state_38041 = G__38116;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$time_travel$time_to_t_$_state_machine__20477__auto__ = function(state_38041){
switch(arguments.length){
case 0:
return fluree$db$time_travel$time_to_t_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$time_travel$time_to_t_$_state_machine__20477__auto____1.call(this,state_38041);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$time_to_t_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$time_to_t_$_state_machine__20477__auto____0;
fluree$db$time_travel$time_to_t_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$time_to_t_$_state_machine__20477__auto____1;
return fluree$db$time_travel$time_to_t_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_38084 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_38084[(6)] = c__20603__auto__);

return statearr_38084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.time_travel.t_to_block = (function fluree$db$time_travel$t_to_block(db,t){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_38169){
var state_val_38170 = (state_38169[(1)]);
if((state_val_38170 === (7))){
var inst_38124 = (state_38169[(7)]);
var inst_38128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38129 = ["_block/number",t];
var inst_38130 = (new cljs.core.PersistentVector(null,2,(5),inst_38128,inst_38129,null));
var inst_38131 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38132 = ["_block/number"];
var inst_38133 = (new cljs.core.PersistentVector(null,1,(5),inst_38131,inst_38132,null));
var inst_38134 = [cljs.core.cst$kw$limit];
var inst_38135 = [(1)];
var inst_38136 = cljs.core.PersistentHashMap.fromArrays(inst_38134,inst_38135);
var inst_38137 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(inst_38124,cljs.core.cst$kw$psot,cljs.core._GT__EQ_,inst_38130,cljs.core._LT__EQ_,inst_38133,inst_38136);
var state_38169__$1 = state_38169;
var statearr_38171_38210 = state_38169__$1;
(statearr_38171_38210[(2)] = inst_38137);

(statearr_38171_38210[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (20))){
var state_38169__$1 = state_38169;
var statearr_38172_38211 = state_38169__$1;
(statearr_38172_38211[(2)] = (1));

(statearr_38172_38211[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (1))){
var state_38169__$1 = state_38169;
var statearr_38173_38212 = state_38169__$1;
(statearr_38173_38212[(2)] = null);

(statearr_38173_38212[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (4))){
var inst_38117 = (state_38169[(2)]);
var state_38169__$1 = state_38169;
var statearr_38174_38213 = state_38169__$1;
(statearr_38174_38213[(2)] = inst_38117);

(statearr_38174_38213[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (15))){
var inst_38153 = (state_38169[(8)]);
var inst_38153__$1 = (state_38169[(2)]);
var inst_38154 = (inst_38153__$1 == null);
var state_38169__$1 = (function (){var statearr_38175 = state_38169;
(statearr_38175[(8)] = inst_38153__$1);

return statearr_38175;
})();
if(cljs.core.truth_(inst_38154)){
var statearr_38176_38214 = state_38169__$1;
(statearr_38176_38214[(1)] = (16));

} else {
var statearr_38177_38215 = state_38169__$1;
(statearr_38177_38215[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (21))){
var inst_38164 = (state_38169[(2)]);
var _ = (function (){var statearr_38178 = state_38169;
(statearr_38178[(4)] = cljs.core.rest((state_38169[(4)])));

return statearr_38178;
})();
var state_38169__$1 = state_38169;
var statearr_38179_38216 = state_38169__$1;
(statearr_38179_38216[(2)] = inst_38164);

(statearr_38179_38216[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (13))){
var state_38169__$1 = state_38169;
var statearr_38180_38217 = state_38169__$1;
(statearr_38180_38217[(2)] = null);

(statearr_38180_38217[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (6))){
var state_38169__$1 = state_38169;
var statearr_38181_38218 = state_38169__$1;
(statearr_38181_38218[(2)] = null);

(statearr_38181_38218[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (17))){
var inst_38153 = (state_38169[(8)]);
var inst_38157 = inst_38153.o;
var state_38169__$1 = state_38169;
var statearr_38182_38219 = state_38169__$1;
(statearr_38182_38219[(2)] = inst_38157);

(statearr_38182_38219[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (3))){
var inst_38167 = (state_38169[(2)]);
var state_38169__$1 = state_38169;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38169__$1,inst_38167);
} else {
if((state_val_38170 === (12))){
var inst_38144 = (state_38169[(2)]);
var inst_38145 = fluree.db.util.async.throw_err(inst_38144);
var state_38169__$1 = state_38169;
var statearr_38183_38220 = state_38169__$1;
(statearr_38183_38220[(2)] = inst_38145);

(statearr_38183_38220[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (2))){
var inst_38124 = (state_38169[(7)]);
var _ = (function (){var statearr_38184 = state_38169;
(statearr_38184[(4)] = cljs.core.cons((5),(state_38169[(4)])));

return statearr_38184;
})();
var inst_38124__$1 = fluree.db.dbproto._rootdb(db);
var inst_38125 = (inst_38124__$1 == null);
var state_38169__$1 = (function (){var statearr_38185 = state_38169;
(statearr_38185[(7)] = inst_38124__$1);

return statearr_38185;
})();
if(cljs.core.truth_(inst_38125)){
var statearr_38186_38221 = state_38169__$1;
(statearr_38186_38221[(1)] = (6));

} else {
var statearr_38187_38222 = state_38169__$1;
(statearr_38187_38222[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (19))){
var inst_38159 = (state_38169[(9)]);
var state_38169__$1 = state_38169;
var statearr_38188_38223 = state_38169__$1;
(statearr_38188_38223[(2)] = inst_38159);

(statearr_38188_38223[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (11))){
var inst_38147 = (state_38169[(10)]);
var inst_38147__$1 = (state_38169[(2)]);
var inst_38148 = (inst_38147__$1 == null);
var state_38169__$1 = (function (){var statearr_38190 = state_38169;
(statearr_38190[(10)] = inst_38147__$1);

return statearr_38190;
})();
if(cljs.core.truth_(inst_38148)){
var statearr_38191_38224 = state_38169__$1;
(statearr_38191_38224[(1)] = (13));

} else {
var statearr_38192_38225 = state_38169__$1;
(statearr_38192_38225[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (9))){
var state_38169__$1 = state_38169;
var statearr_38193_38226 = state_38169__$1;
(statearr_38193_38226[(2)] = null);

(statearr_38193_38226[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (5))){
var _ = (function (){var statearr_38194 = state_38169;
(statearr_38194[(4)] = cljs.core.rest((state_38169[(4)])));

return statearr_38194;
})();
var state_38169__$1 = state_38169;
var ex38189 = (state_38169__$1[(2)]);
var statearr_38195_38227 = state_38169__$1;
(statearr_38195_38227[(5)] = ex38189);


if((ex38189 instanceof Error)){
var statearr_38196_38228 = state_38169__$1;
(statearr_38196_38228[(1)] = (4));

(statearr_38196_38228[(5)] = null);

} else {
throw ex38189;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (14))){
var inst_38147 = (state_38169[(10)]);
var inst_38151 = cljs.core.first(inst_38147);
var state_38169__$1 = state_38169;
var statearr_38197_38229 = state_38169__$1;
(statearr_38197_38229[(2)] = inst_38151);

(statearr_38197_38229[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (16))){
var state_38169__$1 = state_38169;
var statearr_38198_38230 = state_38169__$1;
(statearr_38198_38230[(2)] = null);

(statearr_38198_38230[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (10))){
var inst_38139 = (state_38169[(11)]);
var state_38169__$1 = state_38169;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38169__$1,(12),inst_38139);
} else {
if((state_val_38170 === (18))){
var inst_38159 = (state_38169[(9)]);
var inst_38159__$1 = (state_38169[(2)]);
var inst_38160 = (inst_38159__$1 > (1));
var state_38169__$1 = (function (){var statearr_38199 = state_38169;
(statearr_38199[(9)] = inst_38159__$1);

return statearr_38199;
})();
if(cljs.core.truth_(inst_38160)){
var statearr_38200_38231 = state_38169__$1;
(statearr_38200_38231[(1)] = (19));

} else {
var statearr_38201_38232 = state_38169__$1;
(statearr_38201_38232[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38170 === (8))){
var inst_38139 = (state_38169[(11)]);
var inst_38139__$1 = (state_38169[(2)]);
var inst_38140 = (inst_38139__$1 == null);
var state_38169__$1 = (function (){var statearr_38202 = state_38169;
(statearr_38202[(11)] = inst_38139__$1);

return statearr_38202;
})();
if(cljs.core.truth_(inst_38140)){
var statearr_38203_38233 = state_38169__$1;
(statearr_38203_38233[(1)] = (9));

} else {
var statearr_38204_38234 = state_38169__$1;
(statearr_38204_38234[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$t_to_block_$_state_machine__20477__auto__ = null;
var fluree$db$time_travel$t_to_block_$_state_machine__20477__auto____0 = (function (){
var statearr_38205 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38205[(0)] = fluree$db$time_travel$t_to_block_$_state_machine__20477__auto__);

(statearr_38205[(1)] = (1));

return statearr_38205;
});
var fluree$db$time_travel$t_to_block_$_state_machine__20477__auto____1 = (function (state_38169){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_38169);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e38206){var ex__20480__auto__ = e38206;
var statearr_38207_38235 = state_38169;
(statearr_38207_38235[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_38169[(4)]))){
var statearr_38208_38236 = state_38169;
(statearr_38208_38236[(1)] = cljs.core.first((state_38169[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__38237 = state_38169;
state_38169 = G__38237;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$time_travel$t_to_block_$_state_machine__20477__auto__ = function(state_38169){
switch(arguments.length){
case 0:
return fluree$db$time_travel$t_to_block_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$time_travel$t_to_block_$_state_machine__20477__auto____1.call(this,state_38169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$t_to_block_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$t_to_block_$_state_machine__20477__auto____0;
fluree$db$time_travel$t_to_block_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$t_to_block_$_state_machine__20477__auto____1;
return fluree$db$time_travel$t_to_block_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_38209 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_38209[(6)] = c__20603__auto__);

return statearr_38209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns the block that any given 't' is contained within.
 */
fluree.db.time_travel.non_border_t_to_block = (function fluree$db$time_travel$non_border_t_to_block(db,t){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_38288){
var state_val_38289 = (state_38288[(1)]);
if((state_val_38289 === (7))){
var inst_38245 = (state_38288[(7)]);
var inst_38249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38250 = [t,"_block/transactions"];
var inst_38251 = (new cljs.core.PersistentVector(null,2,(5),inst_38249,inst_38250,null));
var inst_38252 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_38245,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_38251);
var state_38288__$1 = state_38288;
var statearr_38290_38329 = state_38288__$1;
(statearr_38290_38329[(2)] = inst_38252);

(statearr_38290_38329[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (20))){
var inst_38278 = (state_38288[(8)]);
var state_38288__$1 = state_38288;
var statearr_38291_38330 = state_38288__$1;
(statearr_38291_38330[(2)] = inst_38278);

(statearr_38291_38330[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (1))){
var state_38288__$1 = state_38288;
var statearr_38292_38331 = state_38288__$1;
(statearr_38292_38331[(2)] = null);

(statearr_38292_38331[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (4))){
var inst_38238 = (state_38288[(2)]);
var state_38288__$1 = state_38288;
var statearr_38293_38332 = state_38288__$1;
(statearr_38293_38332[(2)] = inst_38238);

(statearr_38293_38332[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (15))){
var inst_38268 = (state_38288[(9)]);
var inst_38268__$1 = (state_38288[(2)]);
var inst_38269 = (inst_38268__$1 == null);
var state_38288__$1 = (function (){var statearr_38294 = state_38288;
(statearr_38294[(9)] = inst_38268__$1);

return statearr_38294;
})();
if(cljs.core.truth_(inst_38269)){
var statearr_38295_38333 = state_38288__$1;
(statearr_38295_38333[(1)] = (16));

} else {
var statearr_38296_38334 = state_38288__$1;
(statearr_38296_38334[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (21))){
var state_38288__$1 = state_38288;
var statearr_38297_38335 = state_38288__$1;
(statearr_38297_38335[(2)] = (1));

(statearr_38297_38335[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (13))){
var state_38288__$1 = state_38288;
var statearr_38298_38336 = state_38288__$1;
(statearr_38298_38336[(2)] = null);

(statearr_38298_38336[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (22))){
var inst_38283 = (state_38288[(2)]);
var _ = (function (){var statearr_38299 = state_38288;
(statearr_38299[(4)] = cljs.core.rest((state_38288[(4)])));

return statearr_38299;
})();
var state_38288__$1 = state_38288;
var statearr_38300_38337 = state_38288__$1;
(statearr_38300_38337[(2)] = inst_38283);

(statearr_38300_38337[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (6))){
var state_38288__$1 = state_38288;
var statearr_38301_38338 = state_38288__$1;
(statearr_38301_38338[(2)] = null);

(statearr_38301_38338[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (17))){
var inst_38268 = (state_38288[(9)]);
var inst_38272 = inst_38268.s;
var state_38288__$1 = state_38288;
var statearr_38302_38339 = state_38288__$1;
(statearr_38302_38339[(2)] = inst_38272);

(statearr_38302_38339[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (3))){
var inst_38286 = (state_38288[(2)]);
var state_38288__$1 = state_38288;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38288__$1,inst_38286);
} else {
if((state_val_38289 === (12))){
var inst_38259 = (state_38288[(2)]);
var inst_38260 = fluree.db.util.async.throw_err(inst_38259);
var state_38288__$1 = state_38288;
var statearr_38303_38340 = state_38288__$1;
(statearr_38303_38340[(2)] = inst_38260);

(statearr_38303_38340[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (2))){
var inst_38245 = (state_38288[(7)]);
var _ = (function (){var statearr_38304 = state_38288;
(statearr_38304[(4)] = cljs.core.cons((5),(state_38288[(4)])));

return statearr_38304;
})();
var inst_38245__$1 = fluree.db.dbproto._rootdb(db);
var inst_38246 = (inst_38245__$1 == null);
var state_38288__$1 = (function (){var statearr_38305 = state_38288;
(statearr_38305[(7)] = inst_38245__$1);

return statearr_38305;
})();
if(cljs.core.truth_(inst_38246)){
var statearr_38306_38341 = state_38288__$1;
(statearr_38306_38341[(1)] = (6));

} else {
var statearr_38307_38342 = state_38288__$1;
(statearr_38307_38342[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (19))){
var inst_38278 = (state_38288[(8)]);
var inst_38277 = (state_38288[(2)]);
var inst_38278__$1 = fluree.db.util.async.throw_err(inst_38277);
var inst_38279 = (inst_38278__$1 > (1));
var state_38288__$1 = (function (){var statearr_38308 = state_38288;
(statearr_38308[(8)] = inst_38278__$1);

return statearr_38308;
})();
if(cljs.core.truth_(inst_38279)){
var statearr_38309_38343 = state_38288__$1;
(statearr_38309_38343[(1)] = (20));

} else {
var statearr_38310_38344 = state_38288__$1;
(statearr_38310_38344[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (11))){
var inst_38262 = (state_38288[(10)]);
var inst_38262__$1 = (state_38288[(2)]);
var inst_38263 = (inst_38262__$1 == null);
var state_38288__$1 = (function (){var statearr_38312 = state_38288;
(statearr_38312[(10)] = inst_38262__$1);

return statearr_38312;
})();
if(cljs.core.truth_(inst_38263)){
var statearr_38313_38345 = state_38288__$1;
(statearr_38313_38345[(1)] = (13));

} else {
var statearr_38314_38346 = state_38288__$1;
(statearr_38314_38346[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (9))){
var state_38288__$1 = state_38288;
var statearr_38315_38347 = state_38288__$1;
(statearr_38315_38347[(2)] = null);

(statearr_38315_38347[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (5))){
var _ = (function (){var statearr_38316 = state_38288;
(statearr_38316[(4)] = cljs.core.rest((state_38288[(4)])));

return statearr_38316;
})();
var state_38288__$1 = state_38288;
var ex38311 = (state_38288__$1[(2)]);
var statearr_38317_38348 = state_38288__$1;
(statearr_38317_38348[(5)] = ex38311);


if((ex38311 instanceof Error)){
var statearr_38318_38349 = state_38288__$1;
(statearr_38318_38349[(1)] = (4));

(statearr_38318_38349[(5)] = null);

} else {
throw ex38311;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (14))){
var inst_38262 = (state_38288[(10)]);
var inst_38266 = cljs.core.first(inst_38262);
var state_38288__$1 = state_38288;
var statearr_38319_38350 = state_38288__$1;
(statearr_38319_38350[(2)] = inst_38266);

(statearr_38319_38350[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (16))){
var state_38288__$1 = state_38288;
var statearr_38320_38351 = state_38288__$1;
(statearr_38320_38351[(2)] = null);

(statearr_38320_38351[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38289 === (10))){
var inst_38254 = (state_38288[(11)]);
var state_38288__$1 = state_38288;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38288__$1,(12),inst_38254);
} else {
if((state_val_38289 === (18))){
var inst_38274 = (state_38288[(2)]);
var inst_38275 = fluree.db.time_travel.t_to_block(db,inst_38274);
var state_38288__$1 = state_38288;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38288__$1,(19),inst_38275);
} else {
if((state_val_38289 === (8))){
var inst_38254 = (state_38288[(11)]);
var inst_38254__$1 = (state_38288[(2)]);
var inst_38255 = (inst_38254__$1 == null);
var state_38288__$1 = (function (){var statearr_38321 = state_38288;
(statearr_38321[(11)] = inst_38254__$1);

return statearr_38321;
})();
if(cljs.core.truth_(inst_38255)){
var statearr_38322_38352 = state_38288__$1;
(statearr_38322_38352[(1)] = (9));

} else {
var statearr_38323_38353 = state_38288__$1;
(statearr_38323_38353[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__20477__auto__ = null;
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__20477__auto____0 = (function (){
var statearr_38324 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38324[(0)] = fluree$db$time_travel$non_border_t_to_block_$_state_machine__20477__auto__);

(statearr_38324[(1)] = (1));

return statearr_38324;
});
var fluree$db$time_travel$non_border_t_to_block_$_state_machine__20477__auto____1 = (function (state_38288){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_38288);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e38325){var ex__20480__auto__ = e38325;
var statearr_38326_38354 = state_38288;
(statearr_38326_38354[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_38288[(4)]))){
var statearr_38327_38355 = state_38288;
(statearr_38327_38355[(1)] = cljs.core.first((state_38288[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__38356 = state_38288;
state_38288 = G__38356;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$time_travel$non_border_t_to_block_$_state_machine__20477__auto__ = function(state_38288){
switch(arguments.length){
case 0:
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__20477__auto____1.call(this,state_38288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$non_border_t_to_block_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$non_border_t_to_block_$_state_machine__20477__auto____0;
fluree$db$time_travel$non_border_t_to_block_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$non_border_t_to_block_$_state_machine__20477__auto____1;
return fluree$db$time_travel$non_border_t_to_block_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_38328 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_38328[(6)] = c__20603__auto__);

return statearr_38328;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns the block for a given time as a string (ISO-8601 formatted time or a duration).
 *   If a block (positive integer) is provided, returns it unmodified.
 */
fluree.db.time_travel.block_to_int_format = (function fluree$db$time_travel$block_to_int_format(db,time_str){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_38417){
var state_val_38418 = (state_38417[(1)]);
if((state_val_38418 === (7))){
var inst_38366 = (state_38417[(7)]);
var inst_38366__$1 = typeof time_str === 'string';
var state_38417__$1 = (function (){var statearr_38419 = state_38417;
(statearr_38419[(7)] = inst_38366__$1);

return statearr_38419;
})();
if(cljs.core.truth_(inst_38366__$1)){
var statearr_38420_38454 = state_38417__$1;
(statearr_38420_38454[(1)] = (9));

} else {
var statearr_38421_38455 = state_38417__$1;
(statearr_38421_38455[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (20))){
var inst_38389 = (state_38417[(2)]);
var inst_38390 = fluree.db.util.async.throw_err(inst_38389);
var inst_38391 = fluree.db.time_travel.t_to_block(db,inst_38390);
var state_38417__$1 = state_38417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38417__$1,(21),inst_38391);
} else {
if((state_val_38418 === (1))){
var state_38417__$1 = state_38417;
var statearr_38422_38456 = state_38417__$1;
(statearr_38422_38456[(2)] = null);

(statearr_38422_38456[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (24))){
var inst_38406 = (state_38417[(2)]);
var state_38417__$1 = state_38417;
var statearr_38423_38457 = state_38417__$1;
(statearr_38423_38457[(2)] = inst_38406);

(statearr_38423_38457[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (4))){
var inst_38357 = (state_38417[(2)]);
var state_38417__$1 = state_38417;
var statearr_38424_38458 = state_38417__$1;
(statearr_38424_38458[(2)] = inst_38357);

(statearr_38424_38458[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (15))){
var inst_38378 = (state_38417[(2)]);
var inst_38379 = fluree.db.util.async.throw_err(inst_38378);
var inst_38380 = fluree.db.time_travel.t_to_block(db,inst_38379);
var state_38417__$1 = state_38417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38417__$1,(16),inst_38380);
} else {
if((state_val_38418 === (21))){
var inst_38393 = (state_38417[(2)]);
var inst_38394 = fluree.db.util.async.throw_err(inst_38393);
var state_38417__$1 = state_38417;
var statearr_38425_38459 = state_38417__$1;
(statearr_38425_38459[(2)] = inst_38394);

(statearr_38425_38459[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (13))){
var inst_38385 = typeof time_str === 'string';
var state_38417__$1 = state_38417;
if(cljs.core.truth_(inst_38385)){
var statearr_38426_38460 = state_38417__$1;
(statearr_38426_38460[(1)] = (17));

} else {
var statearr_38427_38461 = state_38417__$1;
(statearr_38427_38461[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (22))){
var inst_38397 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([time_str], 0));
var inst_38398 = ["Invalid block key provided: ",inst_38397].join('');
var inst_38399 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38400 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_38401 = cljs.core.PersistentHashMap.fromArrays(inst_38399,inst_38400);
var inst_38402 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38398,inst_38401);
var inst_38403 = (function(){throw inst_38402})();
var state_38417__$1 = state_38417;
var statearr_38428_38462 = state_38417__$1;
(statearr_38428_38462[(2)] = inst_38403);

(statearr_38428_38462[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (6))){
var state_38417__$1 = state_38417;
var statearr_38429_38463 = state_38417__$1;
(statearr_38429_38463[(2)] = time_str);

(statearr_38429_38463[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (17))){
var inst_38387 = fluree.db.time_travel.time_to_t(db,time_str);
var state_38417__$1 = state_38417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38417__$1,(20),inst_38387);
} else {
if((state_val_38418 === (3))){
var inst_38415 = (state_38417[(2)]);
var state_38417__$1 = state_38417;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38417__$1,inst_38415);
} else {
if((state_val_38418 === (12))){
var inst_38375 = fluree.db.time_travel.duration_parse(time_str);
var inst_38376 = fluree.db.time_travel.time_to_t(db,inst_38375);
var state_38417__$1 = state_38417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38417__$1,(15),inst_38376);
} else {
if((state_val_38418 === (2))){
var _ = (function (){var statearr_38430 = state_38417;
(statearr_38430[(4)] = cljs.core.cons((5),(state_38417[(4)])));

return statearr_38430;
})();
var inst_38363 = cljs.core.pos_int_QMARK_(time_str);
var state_38417__$1 = state_38417;
if(inst_38363){
var statearr_38431_38464 = state_38417__$1;
(statearr_38431_38464[(1)] = (6));

} else {
var statearr_38432_38465 = state_38417__$1;
(statearr_38432_38465[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (23))){
var state_38417__$1 = state_38417;
var statearr_38433_38466 = state_38417__$1;
(statearr_38433_38466[(2)] = null);

(statearr_38433_38466[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (19))){
var inst_38408 = (state_38417[(2)]);
var state_38417__$1 = state_38417;
var statearr_38434_38467 = state_38417__$1;
(statearr_38434_38467[(2)] = inst_38408);

(statearr_38434_38467[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (11))){
var inst_38373 = (state_38417[(2)]);
var state_38417__$1 = state_38417;
if(cljs.core.truth_(inst_38373)){
var statearr_38436_38468 = state_38417__$1;
(statearr_38436_38468[(1)] = (12));

} else {
var statearr_38437_38469 = state_38417__$1;
(statearr_38437_38469[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (9))){
var inst_38368 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(time_str,(0));
var inst_38369 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38368);
var inst_38370 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("P",inst_38369);
var state_38417__$1 = state_38417;
var statearr_38438_38470 = state_38417__$1;
(statearr_38438_38470[(2)] = inst_38370);

(statearr_38438_38470[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (5))){
var _ = (function (){var statearr_38439 = state_38417;
(statearr_38439[(4)] = cljs.core.rest((state_38417[(4)])));

return statearr_38439;
})();
var state_38417__$1 = state_38417;
var ex38435 = (state_38417__$1[(2)]);
var statearr_38440_38471 = state_38417__$1;
(statearr_38440_38471[(5)] = ex38435);


if((ex38435 instanceof Error)){
var statearr_38441_38472 = state_38417__$1;
(statearr_38441_38472[(1)] = (4));

(statearr_38441_38472[(5)] = null);

} else {
throw ex38435;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (14))){
var inst_38410 = (state_38417[(2)]);
var state_38417__$1 = state_38417;
var statearr_38442_38473 = state_38417__$1;
(statearr_38442_38473[(2)] = inst_38410);

(statearr_38442_38473[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (16))){
var inst_38382 = (state_38417[(2)]);
var inst_38383 = fluree.db.util.async.throw_err(inst_38382);
var state_38417__$1 = state_38417;
var statearr_38443_38474 = state_38417__$1;
(statearr_38443_38474[(2)] = inst_38383);

(statearr_38443_38474[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (10))){
var inst_38366 = (state_38417[(7)]);
var state_38417__$1 = state_38417;
var statearr_38444_38475 = state_38417__$1;
(statearr_38444_38475[(2)] = inst_38366);

(statearr_38444_38475[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (18))){
var state_38417__$1 = state_38417;
var statearr_38445_38476 = state_38417__$1;
(statearr_38445_38476[(1)] = (22));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38418 === (8))){
var inst_38412 = (state_38417[(2)]);
var _ = (function (){var statearr_38447 = state_38417;
(statearr_38447[(4)] = cljs.core.rest((state_38417[(4)])));

return statearr_38447;
})();
var state_38417__$1 = state_38417;
var statearr_38448_38477 = state_38417__$1;
(statearr_38448_38477[(2)] = inst_38412);

(statearr_38448_38477[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$block_to_int_format_$_state_machine__20477__auto__ = null;
var fluree$db$time_travel$block_to_int_format_$_state_machine__20477__auto____0 = (function (){
var statearr_38449 = [null,null,null,null,null,null,null,null];
(statearr_38449[(0)] = fluree$db$time_travel$block_to_int_format_$_state_machine__20477__auto__);

(statearr_38449[(1)] = (1));

return statearr_38449;
});
var fluree$db$time_travel$block_to_int_format_$_state_machine__20477__auto____1 = (function (state_38417){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_38417);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e38450){var ex__20480__auto__ = e38450;
var statearr_38451_38478 = state_38417;
(statearr_38451_38478[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_38417[(4)]))){
var statearr_38452_38479 = state_38417;
(statearr_38452_38479[(1)] = cljs.core.first((state_38417[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__38480 = state_38417;
state_38417 = G__38480;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$time_travel$block_to_int_format_$_state_machine__20477__auto__ = function(state_38417){
switch(arguments.length){
case 0:
return fluree$db$time_travel$block_to_int_format_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$time_travel$block_to_int_format_$_state_machine__20477__auto____1.call(this,state_38417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$block_to_int_format_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$block_to_int_format_$_state_machine__20477__auto____0;
fluree$db$time_travel$block_to_int_format_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$block_to_int_format_$_state_machine__20477__auto____1;
return fluree$db$time_travel$block_to_int_format_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_38453 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_38453[(6)] = c__20603__auto__);

return statearr_38453;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Given a positive integer block, returns the t (negative integer) associated.
 *   If block does not exist, throws.
 */
fluree.db.time_travel.block_to_t = (function fluree$db$time_travel$block_to_t(db,block){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_38533){
var state_val_38534 = (state_38533[(1)]);
if((state_val_38534 === (7))){
var inst_38488 = (state_38533[(7)]);
var inst_38492 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38493 = ["_block/number",block];
var inst_38494 = (new cljs.core.PersistentVector(null,2,(5),inst_38492,inst_38493,null));
var inst_38495 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_38488,cljs.core.cst$kw$post,cljs.core._EQ_,inst_38494);
var state_38533__$1 = state_38533;
var statearr_38535_38575 = state_38533__$1;
(statearr_38535_38575[(2)] = inst_38495);

(statearr_38535_38575[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (20))){
var inst_38520 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block], 0));
var inst_38521 = ["Invalid block key provided: ",inst_38520].join('');
var inst_38522 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38523 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_38524 = cljs.core.PersistentHashMap.fromArrays(inst_38522,inst_38523);
var inst_38525 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38521,inst_38524);
var inst_38526 = (function(){throw inst_38525})();
var state_38533__$1 = state_38533;
var statearr_38536_38576 = state_38533__$1;
(statearr_38536_38576[(2)] = inst_38526);

(statearr_38536_38576[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (1))){
var state_38533__$1 = state_38533;
var statearr_38537_38577 = state_38533__$1;
(statearr_38537_38577[(2)] = null);

(statearr_38537_38577[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (4))){
var inst_38481 = (state_38533[(2)]);
var state_38533__$1 = state_38533;
var statearr_38538_38578 = state_38533__$1;
(statearr_38538_38578[(2)] = inst_38481);

(statearr_38538_38578[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (15))){
var inst_38511 = (state_38533[(8)]);
var inst_38511__$1 = (state_38533[(2)]);
var inst_38512 = (inst_38511__$1 == null);
var state_38533__$1 = (function (){var statearr_38539 = state_38533;
(statearr_38539[(8)] = inst_38511__$1);

return statearr_38539;
})();
if(cljs.core.truth_(inst_38512)){
var statearr_38540_38579 = state_38533__$1;
(statearr_38540_38579[(1)] = (16));

} else {
var statearr_38541_38580 = state_38533__$1;
(statearr_38541_38580[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (21))){
var inst_38517 = (state_38533[(9)]);
var inst_38528 = (state_38533[(2)]);
var _ = (function (){var statearr_38542 = state_38533;
(statearr_38542[(4)] = cljs.core.rest((state_38533[(4)])));

return statearr_38542;
})();
var state_38533__$1 = (function (){var statearr_38543 = state_38533;
(statearr_38543[(10)] = inst_38528);

return statearr_38543;
})();
var statearr_38544_38581 = state_38533__$1;
(statearr_38544_38581[(2)] = inst_38517);

(statearr_38544_38581[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (13))){
var state_38533__$1 = state_38533;
var statearr_38545_38582 = state_38533__$1;
(statearr_38545_38582[(2)] = null);

(statearr_38545_38582[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (6))){
var state_38533__$1 = state_38533;
var statearr_38546_38583 = state_38533__$1;
(statearr_38546_38583[(2)] = null);

(statearr_38546_38583[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (17))){
var inst_38511 = (state_38533[(8)]);
var inst_38515 = inst_38511.t;
var state_38533__$1 = state_38533;
var statearr_38547_38584 = state_38533__$1;
(statearr_38547_38584[(2)] = inst_38515);

(statearr_38547_38584[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (3))){
var inst_38531 = (state_38533[(2)]);
var state_38533__$1 = state_38533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38533__$1,inst_38531);
} else {
if((state_val_38534 === (12))){
var inst_38502 = (state_38533[(2)]);
var inst_38503 = fluree.db.util.async.throw_err(inst_38502);
var state_38533__$1 = state_38533;
var statearr_38548_38585 = state_38533__$1;
(statearr_38548_38585[(2)] = inst_38503);

(statearr_38548_38585[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (2))){
var inst_38488 = (state_38533[(7)]);
var _ = (function (){var statearr_38549 = state_38533;
(statearr_38549[(4)] = cljs.core.cons((5),(state_38533[(4)])));

return statearr_38549;
})();
var inst_38488__$1 = fluree.db.dbproto._rootdb(db);
var inst_38489 = (inst_38488__$1 == null);
var state_38533__$1 = (function (){var statearr_38550 = state_38533;
(statearr_38550[(7)] = inst_38488__$1);

return statearr_38550;
})();
if(cljs.core.truth_(inst_38489)){
var statearr_38551_38586 = state_38533__$1;
(statearr_38551_38586[(1)] = (6));

} else {
var statearr_38552_38587 = state_38533__$1;
(statearr_38552_38587[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (19))){
var state_38533__$1 = state_38533;
var statearr_38553_38588 = state_38533__$1;
(statearr_38553_38588[(2)] = null);

(statearr_38553_38588[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (11))){
var inst_38505 = (state_38533[(11)]);
var inst_38505__$1 = (state_38533[(2)]);
var inst_38506 = (inst_38505__$1 == null);
var state_38533__$1 = (function (){var statearr_38555 = state_38533;
(statearr_38555[(11)] = inst_38505__$1);

return statearr_38555;
})();
if(cljs.core.truth_(inst_38506)){
var statearr_38556_38589 = state_38533__$1;
(statearr_38556_38589[(1)] = (13));

} else {
var statearr_38557_38590 = state_38533__$1;
(statearr_38557_38590[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (9))){
var state_38533__$1 = state_38533;
var statearr_38558_38591 = state_38533__$1;
(statearr_38558_38591[(2)] = null);

(statearr_38558_38591[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (5))){
var _ = (function (){var statearr_38559 = state_38533;
(statearr_38559[(4)] = cljs.core.rest((state_38533[(4)])));

return statearr_38559;
})();
var state_38533__$1 = state_38533;
var ex38554 = (state_38533__$1[(2)]);
var statearr_38560_38592 = state_38533__$1;
(statearr_38560_38592[(5)] = ex38554);


if((ex38554 instanceof Error)){
var statearr_38561_38593 = state_38533__$1;
(statearr_38561_38593[(1)] = (4));

(statearr_38561_38593[(5)] = null);

} else {
throw ex38554;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (14))){
var inst_38505 = (state_38533[(11)]);
var inst_38509 = cljs.core.first(inst_38505);
var state_38533__$1 = state_38533;
var statearr_38562_38594 = state_38533__$1;
(statearr_38562_38594[(2)] = inst_38509);

(statearr_38562_38594[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (16))){
var state_38533__$1 = state_38533;
var statearr_38563_38595 = state_38533__$1;
(statearr_38563_38595[(2)] = null);

(statearr_38563_38595[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (10))){
var inst_38497 = (state_38533[(12)]);
var state_38533__$1 = state_38533;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38533__$1,(12),inst_38497);
} else {
if((state_val_38534 === (18))){
var inst_38517 = (state_38533[(9)]);
var inst_38517__$1 = (state_38533[(2)]);
var state_38533__$1 = (function (){var statearr_38564 = state_38533;
(statearr_38564[(9)] = inst_38517__$1);

return statearr_38564;
})();
if(cljs.core.truth_(inst_38517__$1)){
var statearr_38565_38596 = state_38533__$1;
(statearr_38565_38596[(1)] = (19));

} else {
var statearr_38566_38597 = state_38533__$1;
(statearr_38566_38597[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38534 === (8))){
var inst_38497 = (state_38533[(12)]);
var inst_38497__$1 = (state_38533[(2)]);
var inst_38498 = (inst_38497__$1 == null);
var state_38533__$1 = (function (){var statearr_38567 = state_38533;
(statearr_38567[(12)] = inst_38497__$1);

return statearr_38567;
})();
if(cljs.core.truth_(inst_38498)){
var statearr_38568_38598 = state_38533__$1;
(statearr_38568_38598[(1)] = (9));

} else {
var statearr_38569_38599 = state_38533__$1;
(statearr_38569_38599[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$block_to_t_$_state_machine__20477__auto__ = null;
var fluree$db$time_travel$block_to_t_$_state_machine__20477__auto____0 = (function (){
var statearr_38570 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38570[(0)] = fluree$db$time_travel$block_to_t_$_state_machine__20477__auto__);

(statearr_38570[(1)] = (1));

return statearr_38570;
});
var fluree$db$time_travel$block_to_t_$_state_machine__20477__auto____1 = (function (state_38533){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_38533);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e38571){var ex__20480__auto__ = e38571;
var statearr_38572_38600 = state_38533;
(statearr_38572_38600[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_38533[(4)]))){
var statearr_38573_38601 = state_38533;
(statearr_38573_38601[(1)] = cljs.core.first((state_38533[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__38602 = state_38533;
state_38533 = G__38602;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$time_travel$block_to_t_$_state_machine__20477__auto__ = function(state_38533){
switch(arguments.length){
case 0:
return fluree$db$time_travel$block_to_t_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$time_travel$block_to_t_$_state_machine__20477__auto____1.call(this,state_38533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$block_to_t_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$block_to_t_$_state_machine__20477__auto____0;
fluree$db$time_travel$block_to_t_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$block_to_t_$_state_machine__20477__auto____1;
return fluree$db$time_travel$block_to_t_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_38574 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_38574[(6)] = c__20603__auto__);

return statearr_38574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Takes any time value: block, ISO-8601 time or duration string, or t
 *   and returns the exact 't' as of that value into a core async channel.
 */
fluree.db.time_travel.to_t = (function fluree$db$time_travel$to_t(db,block_or_t_or_time){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_38673){
var state_val_38674 = (state_38673[(1)]);
if((state_val_38674 === (7))){
var state_38673__$1 = state_38673;
var statearr_38675_38720 = state_38673__$1;
(statearr_38675_38720[(2)] = null);

(statearr_38675_38720[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (20))){
var inst_38664 = (state_38673[(2)]);
var state_38673__$1 = state_38673;
var statearr_38676_38721 = state_38673__$1;
(statearr_38676_38721[(2)] = inst_38664);

(statearr_38676_38721[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (27))){
var state_38673__$1 = state_38673;
var statearr_38677_38722 = state_38673__$1;
(statearr_38677_38722[(2)] = null);

(statearr_38677_38722[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (1))){
var state_38673__$1 = state_38673;
var statearr_38678_38723 = state_38673__$1;
(statearr_38678_38723[(2)] = null);

(statearr_38678_38723[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (24))){
var inst_38642 = (state_38673[(2)]);
var inst_38643 = fluree.db.util.async.throw_err(inst_38642);
var state_38673__$1 = state_38673;
var statearr_38679_38724 = state_38673__$1;
(statearr_38679_38724[(2)] = inst_38643);

(statearr_38679_38724[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (4))){
var inst_38603 = (state_38673[(2)]);
var state_38673__$1 = state_38673;
var statearr_38680_38725 = state_38673__$1;
(statearr_38680_38725[(2)] = inst_38603);

(statearr_38680_38725[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (15))){
var state_38673__$1 = state_38673;
var statearr_38682_38726 = state_38673__$1;
(statearr_38682_38726[(2)] = block_or_t_or_time);

(statearr_38682_38726[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (21))){
var inst_38612 = (state_38673[(7)]);
var inst_38639 = fluree.db.time_travel.duration_parse(block_or_t_or_time);
var inst_38640 = fluree.db.time_travel.time_to_t(inst_38612,inst_38639);
var state_38673__$1 = state_38673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38673__$1,(24),inst_38640);
} else {
if((state_val_38674 === (13))){
var _ = (function (){var statearr_38683 = state_38673;
(statearr_38683[(4)] = cljs.core.rest((state_38673[(4)])));

return statearr_38683;
})();
var state_38673__$1 = state_38673;
var ex38681 = (state_38673__$1[(2)]);
var statearr_38684_38727 = state_38673__$1;
(statearr_38684_38727[(5)] = ex38681);


var statearr_38685_38728 = state_38673__$1;
(statearr_38685_38728[(1)] = (12));

(statearr_38685_38728[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (22))){
var inst_38612 = (state_38673[(7)]);
var inst_38645 = fluree.db.time_travel.time_to_t(inst_38612,block_or_t_or_time);
var state_38673__$1 = state_38673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38673__$1,(25),inst_38645);
} else {
if((state_val_38674 === (6))){
var inst_38611 = (state_38673[(2)]);
var inst_38612 = fluree.db.util.async.throw_err(inst_38611);
var inst_38613 = cljs.core.pos_int_QMARK_(block_or_t_or_time);
var state_38673__$1 = (function (){var statearr_38686 = state_38673;
(statearr_38686[(7)] = inst_38612);

return statearr_38686;
})();
if(inst_38613){
var statearr_38687_38729 = state_38673__$1;
(statearr_38687_38729[(1)] = (7));

} else {
var statearr_38688_38730 = state_38673__$1;
(statearr_38688_38730[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (28))){
var inst_38662 = (state_38673[(2)]);
var state_38673__$1 = state_38673;
var statearr_38689_38731 = state_38673__$1;
(statearr_38689_38731[(2)] = inst_38662);

(statearr_38689_38731[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (25))){
var inst_38647 = (state_38673[(2)]);
var inst_38648 = fluree.db.util.async.throw_err(inst_38647);
var state_38673__$1 = state_38673;
var statearr_38690_38732 = state_38673__$1;
(statearr_38690_38732[(2)] = inst_38648);

(statearr_38690_38732[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (17))){
var inst_38666 = (state_38673[(2)]);
var state_38673__$1 = state_38673;
var statearr_38691_38733 = state_38673__$1;
(statearr_38691_38733[(2)] = inst_38666);

(statearr_38691_38733[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (3))){
var inst_38671 = (state_38673[(2)]);
var state_38673__$1 = state_38673;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38673__$1,inst_38671);
} else {
if((state_val_38674 === (12))){
var inst_38612 = (state_38673[(7)]);
var inst_38615 = (state_38673[(2)]);
var inst_38616 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_38612);
var state_38673__$1 = (function (){var statearr_38692 = state_38673;
(statearr_38692[(8)] = inst_38615);

return statearr_38692;
})();
var statearr_38693_38734 = state_38673__$1;
(statearr_38693_38734[(2)] = inst_38616);

(statearr_38693_38734[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (2))){
var _ = (function (){var statearr_38694 = state_38673;
(statearr_38694[(4)] = cljs.core.cons((5),(state_38673[(4)])));

return statearr_38694;
})();
var inst_38609 = fluree.db.dbproto._latest_db(db);
var state_38673__$1 = state_38673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38673__$1,(6),inst_38609);
} else {
if((state_val_38674 === (23))){
var inst_38650 = (state_38673[(2)]);
var state_38673__$1 = state_38673;
var statearr_38695_38735 = state_38673__$1;
(statearr_38695_38735[(2)] = inst_38650);

(statearr_38695_38735[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (19))){
var state_38673__$1 = state_38673;
var statearr_38696_38736 = state_38673__$1;
(statearr_38696_38736[(1)] = (26));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (11))){
var inst_38628 = (state_38673[(2)]);
var state_38673__$1 = state_38673;
var statearr_38699_38737 = state_38673__$1;
(statearr_38699_38737[(2)] = inst_38628);

(statearr_38699_38737[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (9))){
var inst_38668 = (state_38673[(2)]);
var _ = (function (){var statearr_38700 = state_38673;
(statearr_38700[(4)] = cljs.core.rest((state_38673[(4)])));

return statearr_38700;
})();
var state_38673__$1 = state_38673;
var statearr_38701_38738 = state_38673__$1;
(statearr_38701_38738[(2)] = inst_38668);

(statearr_38701_38738[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (5))){
var _ = (function (){var statearr_38702 = state_38673;
(statearr_38702[(4)] = cljs.core.rest((state_38673[(4)])));

return statearr_38702;
})();
var state_38673__$1 = state_38673;
var ex38698 = (state_38673__$1[(2)]);
var statearr_38703_38739 = state_38673__$1;
(statearr_38703_38739[(5)] = ex38698);


if((ex38698 instanceof Error)){
var statearr_38704_38740 = state_38673__$1;
(statearr_38704_38740[(1)] = (4));

(statearr_38704_38740[(5)] = null);

} else {
throw ex38698;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (14))){
var inst_38624 = (state_38673[(2)]);
var inst_38625 = fluree.db.util.async.throw_err(inst_38624);
var _ = (function (){var statearr_38705 = state_38673;
(statearr_38705[(4)] = cljs.core.rest((state_38673[(4)])));

return statearr_38705;
})();
var state_38673__$1 = state_38673;
var statearr_38706_38741 = state_38673__$1;
(statearr_38706_38741[(2)] = inst_38625);

(statearr_38706_38741[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (26))){
var inst_38653 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_or_t_or_time], 0));
var inst_38654 = ["Invalid time value provided: ",inst_38653].join('');
var inst_38655 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38656 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_time];
var inst_38657 = cljs.core.PersistentHashMap.fromArrays(inst_38655,inst_38656);
var inst_38658 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38654,inst_38657);
var inst_38659 = (function(){throw inst_38658})();
var state_38673__$1 = state_38673;
var statearr_38707_38742 = state_38673__$1;
(statearr_38707_38742[(2)] = inst_38659);

(statearr_38707_38742[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (16))){
var inst_38633 = typeof block_or_t_or_time === 'string';
var state_38673__$1 = state_38673;
if(cljs.core.truth_(inst_38633)){
var statearr_38708_38743 = state_38673__$1;
(statearr_38708_38743[(1)] = (18));

} else {
var statearr_38709_38744 = state_38673__$1;
(statearr_38709_38744[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (10))){
var inst_38612 = (state_38673[(7)]);
var _ = (function (){var statearr_38710 = state_38673;
(statearr_38710[(4)] = cljs.core.cons((13),(state_38673[(4)])));

return statearr_38710;
})();
var inst_38622 = fluree.db.time_travel.block_to_t(inst_38612,block_or_t_or_time);
var state_38673__$1 = state_38673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38673__$1,(14),inst_38622);
} else {
if((state_val_38674 === (18))){
var inst_38635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(block_or_t_or_time,(0));
var inst_38636 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38635);
var inst_38637 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("P",inst_38636);
var state_38673__$1 = state_38673;
if(inst_38637){
var statearr_38711_38745 = state_38673__$1;
(statearr_38711_38745[(1)] = (21));

} else {
var statearr_38712_38746 = state_38673__$1;
(statearr_38712_38746[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38674 === (8))){
var inst_38630 = cljs.core.neg_int_QMARK_(block_or_t_or_time);
var state_38673__$1 = state_38673;
if(inst_38630){
var statearr_38713_38747 = state_38673__$1;
(statearr_38713_38747[(1)] = (15));

} else {
var statearr_38714_38748 = state_38673__$1;
(statearr_38714_38748[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$to_t_$_state_machine__20477__auto__ = null;
var fluree$db$time_travel$to_t_$_state_machine__20477__auto____0 = (function (){
var statearr_38715 = [null,null,null,null,null,null,null,null,null];
(statearr_38715[(0)] = fluree$db$time_travel$to_t_$_state_machine__20477__auto__);

(statearr_38715[(1)] = (1));

return statearr_38715;
});
var fluree$db$time_travel$to_t_$_state_machine__20477__auto____1 = (function (state_38673){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_38673);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e38716){var ex__20480__auto__ = e38716;
var statearr_38717_38749 = state_38673;
(statearr_38717_38749[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_38673[(4)]))){
var statearr_38718_38750 = state_38673;
(statearr_38718_38750[(1)] = cljs.core.first((state_38673[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__38751 = state_38673;
state_38673 = G__38751;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$time_travel$to_t_$_state_machine__20477__auto__ = function(state_38673){
switch(arguments.length){
case 0:
return fluree$db$time_travel$to_t_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$time_travel$to_t_$_state_machine__20477__auto____1.call(this,state_38673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$to_t_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$to_t_$_state_machine__20477__auto____0;
fluree$db$time_travel$to_t_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$to_t_$_state_machine__20477__auto____1;
return fluree$db$time_travel$to_t_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_38719 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_38719[(6)] = c__20603__auto__);

return statearr_38719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Gets the database as-of a specified block. Either block number or a time string in ISO-8601 format.
 *   Returns db as a promise channel
 */
fluree.db.time_travel.as_of_block = (function fluree$db$time_travel$as_of_block(db,block_or_t_or_time){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__20603__auto___38795 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_38777){
var state_val_38778 = (state_38777[(1)]);
if((state_val_38778 === (1))){
var state_38777__$1 = state_38777;
var statearr_38779_38796 = state_38777__$1;
(statearr_38779_38796[(2)] = null);

(statearr_38779_38796[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38778 === (2))){
var _ = (function (){var statearr_38780 = state_38777;
(statearr_38780[(4)] = cljs.core.cons((5),(state_38777[(4)])));

return statearr_38780;
})();
var inst_38759 = fluree.db.dbproto._latest_db(db);
var state_38777__$1 = state_38777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38777__$1,(6),inst_38759);
} else {
if((state_val_38778 === (3))){
var inst_38775 = (state_38777[(2)]);
var state_38777__$1 = state_38777;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38777__$1,inst_38775);
} else {
if((state_val_38778 === (4))){
var inst_38752 = (state_38777[(2)]);
var inst_38753 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_38752);
var state_38777__$1 = state_38777;
var statearr_38782_38797 = state_38777__$1;
(statearr_38782_38797[(2)] = inst_38753);

(statearr_38782_38797[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38778 === (5))){
var _ = (function (){var statearr_38783 = state_38777;
(statearr_38783[(4)] = cljs.core.rest((state_38777[(4)])));

return statearr_38783;
})();
var state_38777__$1 = state_38777;
var ex38781 = (state_38777__$1[(2)]);
var statearr_38784_38798 = state_38777__$1;
(statearr_38784_38798[(5)] = ex38781);


var statearr_38785_38799 = state_38777__$1;
(statearr_38785_38799[(1)] = (4));

(statearr_38785_38799[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38778 === (6))){
var inst_38762 = (state_38777[(7)]);
var inst_38761 = (state_38777[(2)]);
var inst_38762__$1 = fluree.db.util.async.throw_err(inst_38761);
var inst_38763 = fluree.db.time_travel.to_t(inst_38762__$1,block_or_t_or_time);
var state_38777__$1 = (function (){var statearr_38786 = state_38777;
(statearr_38786[(7)] = inst_38762__$1);

return statearr_38786;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38777__$1,(7),inst_38763);
} else {
if((state_val_38778 === (7))){
var inst_38766 = (state_38777[(8)]);
var inst_38762 = (state_38777[(7)]);
var inst_38765 = (state_38777[(2)]);
var inst_38766__$1 = fluree.db.util.async.throw_err(inst_38765);
var inst_38767 = fluree.db.time_travel.t_to_block(inst_38762,inst_38766__$1);
var state_38777__$1 = (function (){var statearr_38787 = state_38777;
(statearr_38787[(8)] = inst_38766__$1);

return statearr_38787;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38777__$1,(8),inst_38767);
} else {
if((state_val_38778 === (8))){
var inst_38766 = (state_38777[(8)]);
var inst_38769 = (state_38777[(2)]);
var inst_38770 = fluree.db.util.async.throw_err(inst_38769);
var inst_38771 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,cljs.core.cst$kw$t,inst_38766,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$block,inst_38770], 0));
var inst_38772 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_38771);
var _ = (function (){var statearr_38788 = state_38777;
(statearr_38788[(4)] = cljs.core.rest((state_38777[(4)])));

return statearr_38788;
})();
var state_38777__$1 = state_38777;
var statearr_38789_38800 = state_38777__$1;
(statearr_38789_38800[(2)] = inst_38772);

(statearr_38789_38800[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$time_travel$as_of_block_$_state_machine__20477__auto__ = null;
var fluree$db$time_travel$as_of_block_$_state_machine__20477__auto____0 = (function (){
var statearr_38790 = [null,null,null,null,null,null,null,null,null];
(statearr_38790[(0)] = fluree$db$time_travel$as_of_block_$_state_machine__20477__auto__);

(statearr_38790[(1)] = (1));

return statearr_38790;
});
var fluree$db$time_travel$as_of_block_$_state_machine__20477__auto____1 = (function (state_38777){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_38777);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e38791){var ex__20480__auto__ = e38791;
var statearr_38792_38801 = state_38777;
(statearr_38792_38801[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_38777[(4)]))){
var statearr_38793_38802 = state_38777;
(statearr_38793_38802[(1)] = cljs.core.first((state_38777[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__38803 = state_38777;
state_38777 = G__38803;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$time_travel$as_of_block_$_state_machine__20477__auto__ = function(state_38777){
switch(arguments.length){
case 0:
return fluree$db$time_travel$as_of_block_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$time_travel$as_of_block_$_state_machine__20477__auto____1.call(this,state_38777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$time_travel$as_of_block_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$time_travel$as_of_block_$_state_machine__20477__auto____0;
fluree$db$time_travel$as_of_block_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$time_travel$as_of_block_$_state_machine__20477__auto____1;
return fluree$db$time_travel$as_of_block_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_38794 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_38794[(6)] = c__20603__auto___38795);

return statearr_38794;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return pc;
});
