// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46563){
var state_val_46564 = (state_46563[(1)]);
if((state_val_46564 === (7))){
var inst_46552 = (state_46563[(7)]);
var inst_46554 = fluree.db.storage.core.serde(conn);
var inst_46555 = fluree.db.serde.protocol._deserialize_block(inst_46554,inst_46552);
var state_46563__$1 = state_46563;
var statearr_46565_46584 = state_46563__$1;
(statearr_46565_46584[(2)] = inst_46555);

(statearr_46565_46584[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46564 === (1))){
var state_46563__$1 = state_46563;
var statearr_46566_46585 = state_46563__$1;
(statearr_46566_46585[(2)] = null);

(statearr_46566_46585[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46564 === (4))){
var inst_46542 = (state_46563[(2)]);
var state_46563__$1 = state_46563;
var statearr_46567_46586 = state_46563__$1;
(statearr_46567_46586[(2)] = inst_46542);

(statearr_46567_46586[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46564 === (6))){
var inst_46552 = (state_46563[(7)]);
var inst_46551 = (state_46563[(2)]);
var inst_46552__$1 = fluree.db.util.async.throw_err(inst_46551);
var state_46563__$1 = (function (){var statearr_46568 = state_46563;
(statearr_46568[(7)] = inst_46552__$1);

return statearr_46568;
})();
if(cljs.core.truth_(inst_46552__$1)){
var statearr_46569_46587 = state_46563__$1;
(statearr_46569_46587[(1)] = (7));

} else {
var statearr_46570_46588 = state_46563__$1;
(statearr_46570_46588[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46564 === (3))){
var inst_46561 = (state_46563[(2)]);
var state_46563__$1 = state_46563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46563__$1,inst_46561);
} else {
if((state_val_46564 === (2))){
var _ = (function (){var statearr_46572 = state_46563;
(statearr_46572[(4)] = cljs.core.cons((5),(state_46563[(4)])));

return statearr_46572;
})();
var inst_46548 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_46549 = fluree.db.storage.core.storage_read(conn,inst_46548);
var state_46563__$1 = state_46563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46563__$1,(6),inst_46549);
} else {
if((state_val_46564 === (9))){
var inst_46558 = (state_46563[(2)]);
var _ = (function (){var statearr_46573 = state_46563;
(statearr_46573[(4)] = cljs.core.rest((state_46563[(4)])));

return statearr_46573;
})();
var state_46563__$1 = state_46563;
var statearr_46574_46589 = state_46563__$1;
(statearr_46574_46589[(2)] = inst_46558);

(statearr_46574_46589[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46564 === (5))){
var _ = (function (){var statearr_46575 = state_46563;
(statearr_46575[(4)] = cljs.core.rest((state_46563[(4)])));

return statearr_46575;
})();
var state_46563__$1 = state_46563;
var ex46571 = (state_46563__$1[(2)]);
var statearr_46576_46590 = state_46563__$1;
(statearr_46576_46590[(5)] = ex46571);


if((ex46571 instanceof Error)){
var statearr_46577_46591 = state_46563__$1;
(statearr_46577_46591[(1)] = (4));

(statearr_46577_46591[(5)] = null);

} else {
throw ex46571;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46564 === (8))){
var state_46563__$1 = state_46563;
var statearr_46578_46592 = state_46563__$1;
(statearr_46578_46592[(2)] = null);

(statearr_46578_46592[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__20477__auto____0 = (function (){
var statearr_46579 = [null,null,null,null,null,null,null,null];
(statearr_46579[(0)] = fluree$db$storage$core$read_block_$_state_machine__20477__auto__);

(statearr_46579[(1)] = (1));

return statearr_46579;
});
var fluree$db$storage$core$read_block_$_state_machine__20477__auto____1 = (function (state_46563){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46563);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46580){var ex__20480__auto__ = e46580;
var statearr_46581_46593 = state_46563;
(statearr_46581_46593[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46563[(4)]))){
var statearr_46582_46594 = state_46563;
(statearr_46582_46594[(1)] = cljs.core.first((state_46563[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46595 = state_46563;
state_46563 = G__46595;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__20477__auto__ = function(state_46563){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__20477__auto____1.call(this,state_46563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__20477__auto____0;
fluree$db$storage$core$read_block_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__20477__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46583 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46583[(6)] = c__20603__auto__);

return statearr_46583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46618){
var state_val_46619 = (state_46618[(1)]);
if((state_val_46619 === (7))){
var inst_46607 = (state_46618[(7)]);
var inst_46609 = fluree.db.storage.core.serde(conn);
var inst_46610 = fluree.db.serde.protocol._deserialize_block(inst_46609,inst_46607);
var state_46618__$1 = state_46618;
var statearr_46620_46639 = state_46618__$1;
(statearr_46620_46639[(2)] = inst_46610);

(statearr_46620_46639[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46619 === (1))){
var state_46618__$1 = state_46618;
var statearr_46621_46640 = state_46618__$1;
(statearr_46621_46640[(2)] = null);

(statearr_46621_46640[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46619 === (4))){
var inst_46596 = (state_46618[(2)]);
var state_46618__$1 = state_46618;
var statearr_46622_46641 = state_46618__$1;
(statearr_46622_46641[(2)] = inst_46596);

(statearr_46622_46641[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46619 === (6))){
var inst_46607 = (state_46618[(7)]);
var inst_46606 = (state_46618[(2)]);
var inst_46607__$1 = fluree.db.util.async.throw_err(inst_46606);
var state_46618__$1 = (function (){var statearr_46623 = state_46618;
(statearr_46623[(7)] = inst_46607__$1);

return statearr_46623;
})();
if(cljs.core.truth_(inst_46607__$1)){
var statearr_46624_46642 = state_46618__$1;
(statearr_46624_46642[(1)] = (7));

} else {
var statearr_46625_46643 = state_46618__$1;
(statearr_46625_46643[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46619 === (3))){
var inst_46616 = (state_46618[(2)]);
var state_46618__$1 = state_46618;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46618__$1,inst_46616);
} else {
if((state_val_46619 === (2))){
var _ = (function (){var statearr_46627 = state_46618;
(statearr_46627[(4)] = cljs.core.cons((5),(state_46618[(4)])));

return statearr_46627;
})();
var inst_46602 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_46603 = [inst_46602,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_46604 = fluree.db.storage.core.storage_read(conn,inst_46603);
var state_46618__$1 = state_46618;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46618__$1,(6),inst_46604);
} else {
if((state_val_46619 === (9))){
var inst_46613 = (state_46618[(2)]);
var _ = (function (){var statearr_46628 = state_46618;
(statearr_46628[(4)] = cljs.core.rest((state_46618[(4)])));

return statearr_46628;
})();
var state_46618__$1 = state_46618;
var statearr_46629_46644 = state_46618__$1;
(statearr_46629_46644[(2)] = inst_46613);

(statearr_46629_46644[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46619 === (5))){
var _ = (function (){var statearr_46630 = state_46618;
(statearr_46630[(4)] = cljs.core.rest((state_46618[(4)])));

return statearr_46630;
})();
var state_46618__$1 = state_46618;
var ex46626 = (state_46618__$1[(2)]);
var statearr_46631_46645 = state_46618__$1;
(statearr_46631_46645[(5)] = ex46626);


if((ex46626 instanceof Error)){
var statearr_46632_46646 = state_46618__$1;
(statearr_46632_46646[(1)] = (4));

(statearr_46632_46646[(5)] = null);

} else {
throw ex46626;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46619 === (8))){
var state_46618__$1 = state_46618;
var statearr_46633_46647 = state_46618__$1;
(statearr_46633_46647[(2)] = null);

(statearr_46633_46647[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__20477__auto____0 = (function (){
var statearr_46634 = [null,null,null,null,null,null,null,null];
(statearr_46634[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__20477__auto__);

(statearr_46634[(1)] = (1));

return statearr_46634;
});
var fluree$db$storage$core$read_block_version_$_state_machine__20477__auto____1 = (function (state_46618){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46618);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46635){var ex__20480__auto__ = e46635;
var statearr_46636_46648 = state_46618;
(statearr_46636_46648[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46618[(4)]))){
var statearr_46637_46649 = state_46618;
(statearr_46637_46649[(1)] = cljs.core.first((state_46618[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46650 = state_46618;
state_46618 = G__46650;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__20477__auto__ = function(state_46618){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__20477__auto____1.call(this,state_46618);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__20477__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__20477__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46638 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46638[(6)] = c__20603__auto__);

return statearr_46638;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46674){
var state_val_46675 = (state_46674[(1)]);
if((state_val_46675 === (1))){
var state_46674__$1 = state_46674;
var statearr_46676_46690 = state_46674__$1;
(statearr_46676_46690[(2)] = null);

(statearr_46676_46690[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46675 === (2))){
var _ = (function (){var statearr_46677 = state_46674;
(statearr_46677[(4)] = cljs.core.cons((5),(state_46674[(4)])));

return statearr_46677;
})();
var inst_46657 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46658 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_46659 = (new cljs.core.PersistentVector(null,3,(5),inst_46657,inst_46658,null));
var inst_46660 = cljs.core.select_keys(block_data,inst_46659);
var inst_46661 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_46660);
var inst_46662 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_46661);
var inst_46663 = [inst_46662,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_46664 = fluree.db.storage.core.serde(conn);
var inst_46665 = fluree.db.serde.protocol._serialize_block(inst_46664,inst_46660);
var inst_46666 = fluree.db.storage.core.storage_write(conn,inst_46663,inst_46665);
var state_46674__$1 = state_46674;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46674__$1,(6),inst_46666);
} else {
if((state_val_46675 === (3))){
var inst_46672 = (state_46674[(2)]);
var state_46674__$1 = state_46674;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46674__$1,inst_46672);
} else {
if((state_val_46675 === (4))){
var inst_46651 = (state_46674[(2)]);
var state_46674__$1 = state_46674;
var statearr_46679_46691 = state_46674__$1;
(statearr_46679_46691[(2)] = inst_46651);

(statearr_46679_46691[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46675 === (5))){
var _ = (function (){var statearr_46680 = state_46674;
(statearr_46680[(4)] = cljs.core.rest((state_46674[(4)])));

return statearr_46680;
})();
var state_46674__$1 = state_46674;
var ex46678 = (state_46674__$1[(2)]);
var statearr_46681_46692 = state_46674__$1;
(statearr_46681_46692[(5)] = ex46678);


if((ex46678 instanceof Error)){
var statearr_46682_46693 = state_46674__$1;
(statearr_46682_46693[(1)] = (4));

(statearr_46682_46693[(5)] = null);

} else {
throw ex46678;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46675 === (6))){
var inst_46668 = (state_46674[(2)]);
var inst_46669 = fluree.db.util.async.throw_err(inst_46668);
var _ = (function (){var statearr_46683 = state_46674;
(statearr_46683[(4)] = cljs.core.rest((state_46674[(4)])));

return statearr_46683;
})();
var state_46674__$1 = state_46674;
var statearr_46684_46694 = state_46674__$1;
(statearr_46684_46694[(2)] = inst_46669);

(statearr_46684_46694[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__20477__auto____0 = (function (){
var statearr_46685 = [null,null,null,null,null,null,null];
(statearr_46685[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__20477__auto__);

(statearr_46685[(1)] = (1));

return statearr_46685;
});
var fluree$db$storage$core$write_block_version_$_state_machine__20477__auto____1 = (function (state_46674){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46674);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46686){var ex__20480__auto__ = e46686;
var statearr_46687_46695 = state_46674;
(statearr_46687_46695[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46674[(4)]))){
var statearr_46688_46696 = state_46674;
(statearr_46688_46696[(1)] = cljs.core.first((state_46674[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46697 = state_46674;
state_46674 = G__46697;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__20477__auto__ = function(state_46674){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__20477__auto____1.call(this,state_46674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__20477__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__20477__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46689 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46689[(6)] = c__20603__auto__);

return statearr_46689;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46720){
var state_val_46721 = (state_46720[(1)]);
if((state_val_46721 === (1))){
var state_46720__$1 = state_46720;
var statearr_46722_46736 = state_46720__$1;
(statearr_46722_46736[(2)] = null);

(statearr_46722_46736[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46721 === (2))){
var _ = (function (){var statearr_46723 = state_46720;
(statearr_46723[(4)] = cljs.core.cons((5),(state_46720[(4)])));

return statearr_46723;
})();
var inst_46704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46705 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_46706 = (new cljs.core.PersistentVector(null,3,(5),inst_46704,inst_46705,null));
var inst_46707 = cljs.core.select_keys(block_data,inst_46706);
var inst_46708 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_46707);
var inst_46709 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_46708);
var inst_46710 = fluree.db.storage.core.serde(conn);
var inst_46711 = fluree.db.serde.protocol._serialize_block(inst_46710,inst_46707);
var inst_46712 = fluree.db.storage.core.storage_write(conn,inst_46709,inst_46711);
var state_46720__$1 = state_46720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46720__$1,(6),inst_46712);
} else {
if((state_val_46721 === (3))){
var inst_46718 = (state_46720[(2)]);
var state_46720__$1 = state_46720;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46720__$1,inst_46718);
} else {
if((state_val_46721 === (4))){
var inst_46698 = (state_46720[(2)]);
var state_46720__$1 = state_46720;
var statearr_46725_46737 = state_46720__$1;
(statearr_46725_46737[(2)] = inst_46698);

(statearr_46725_46737[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46721 === (5))){
var _ = (function (){var statearr_46726 = state_46720;
(statearr_46726[(4)] = cljs.core.rest((state_46720[(4)])));

return statearr_46726;
})();
var state_46720__$1 = state_46720;
var ex46724 = (state_46720__$1[(2)]);
var statearr_46727_46738 = state_46720__$1;
(statearr_46727_46738[(5)] = ex46724);


if((ex46724 instanceof Error)){
var statearr_46728_46739 = state_46720__$1;
(statearr_46728_46739[(1)] = (4));

(statearr_46728_46739[(5)] = null);

} else {
throw ex46724;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46721 === (6))){
var inst_46714 = (state_46720[(2)]);
var inst_46715 = fluree.db.util.async.throw_err(inst_46714);
var _ = (function (){var statearr_46729 = state_46720;
(statearr_46729[(4)] = cljs.core.rest((state_46720[(4)])));

return statearr_46729;
})();
var state_46720__$1 = state_46720;
var statearr_46730_46740 = state_46720__$1;
(statearr_46730_46740[(2)] = inst_46715);

(statearr_46730_46740[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__20477__auto____0 = (function (){
var statearr_46731 = [null,null,null,null,null,null,null];
(statearr_46731[(0)] = fluree$db$storage$core$write_block_$_state_machine__20477__auto__);

(statearr_46731[(1)] = (1));

return statearr_46731;
});
var fluree$db$storage$core$write_block_$_state_machine__20477__auto____1 = (function (state_46720){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46720);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46732){var ex__20480__auto__ = e46732;
var statearr_46733_46741 = state_46720;
(statearr_46733_46741[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46720[(4)]))){
var statearr_46734_46742 = state_46720;
(statearr_46734_46742[(1)] = cljs.core.first((state_46720[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46743 = state_46720;
state_46720 = G__46743;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__20477__auto__ = function(state_46720){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__20477__auto____1.call(this,state_46720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__20477__auto____0;
fluree$db$storage$core$write_block_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__20477__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46735 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46735[(6)] = c__20603__auto__);

return statearr_46735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46763){
var state_val_46764 = (state_46763[(1)]);
if((state_val_46764 === (1))){
var state_46763__$1 = state_46763;
var statearr_46765_46779 = state_46763__$1;
(statearr_46765_46779[(2)] = null);

(statearr_46765_46779[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46764 === (2))){
var _ = (function (){var statearr_46766 = state_46763;
(statearr_46766[(4)] = cljs.core.cons((5),(state_46763[(4)])));

return statearr_46766;
})();
var inst_46750 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_46751 = [history,next_his_key];
var inst_46752 = cljs.core.PersistentHashMap.fromArrays(inst_46750,inst_46751);
var inst_46753 = fluree.db.storage.core.serde(conn);
var inst_46754 = fluree.db.serde.protocol._serialize_leaf(inst_46753,inst_46752);
var inst_46755 = fluree.db.storage.core.storage_write(conn,his_key,inst_46754);
var state_46763__$1 = state_46763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46763__$1,(6),inst_46755);
} else {
if((state_val_46764 === (3))){
var inst_46761 = (state_46763[(2)]);
var state_46763__$1 = state_46763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46763__$1,inst_46761);
} else {
if((state_val_46764 === (4))){
var inst_46744 = (state_46763[(2)]);
var state_46763__$1 = state_46763;
var statearr_46768_46780 = state_46763__$1;
(statearr_46768_46780[(2)] = inst_46744);

(statearr_46768_46780[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46764 === (5))){
var _ = (function (){var statearr_46769 = state_46763;
(statearr_46769[(4)] = cljs.core.rest((state_46763[(4)])));

return statearr_46769;
})();
var state_46763__$1 = state_46763;
var ex46767 = (state_46763__$1[(2)]);
var statearr_46770_46781 = state_46763__$1;
(statearr_46770_46781[(5)] = ex46767);


if((ex46767 instanceof Error)){
var statearr_46771_46782 = state_46763__$1;
(statearr_46771_46782[(1)] = (4));

(statearr_46771_46782[(5)] = null);

} else {
throw ex46767;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46764 === (6))){
var inst_46757 = (state_46763[(2)]);
var inst_46758 = fluree.db.util.async.throw_err(inst_46757);
var _ = (function (){var statearr_46772 = state_46763;
(statearr_46772[(4)] = cljs.core.rest((state_46763[(4)])));

return statearr_46772;
})();
var state_46763__$1 = state_46763;
var statearr_46773_46783 = state_46763__$1;
(statearr_46773_46783[(2)] = inst_46758);

(statearr_46773_46783[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__20477__auto____0 = (function (){
var statearr_46774 = [null,null,null,null,null,null,null];
(statearr_46774[(0)] = fluree$db$storage$core$write_history_$_state_machine__20477__auto__);

(statearr_46774[(1)] = (1));

return statearr_46774;
});
var fluree$db$storage$core$write_history_$_state_machine__20477__auto____1 = (function (state_46763){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46763);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46775){var ex__20480__auto__ = e46775;
var statearr_46776_46784 = state_46763;
(statearr_46776_46784[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46763[(4)]))){
var statearr_46777_46785 = state_46763;
(statearr_46777_46785[(1)] = cljs.core.first((state_46763[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46786 = state_46763;
state_46763 = G__46786;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__20477__auto__ = function(state_46763){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__20477__auto____1.call(this,state_46763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__20477__auto____0;
fluree$db$storage$core$write_history_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__20477__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46778 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46778[(6)] = c__20603__auto__);

return statearr_46778;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46812){
var state_val_46813 = (state_46812[(1)]);
if((state_val_46813 === (1))){
var state_46812__$1 = state_46812;
var statearr_46814_46831 = state_46812__$1;
(statearr_46814_46831[(2)] = null);

(statearr_46814_46831[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46813 === (2))){
var inst_46793 = (state_46812[(7)]);
var _ = (function (){var statearr_46815 = state_46812;
(statearr_46815[(4)] = cljs.core.cons((5),(state_46812[(4)])));

return statearr_46815;
})();
var inst_46793__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_46794 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_46793__$1),"-his"].join('');
var inst_46795 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_46796 = [flakes,inst_46794];
var inst_46797 = cljs.core.PersistentHashMap.fromArrays(inst_46795,inst_46796);
var inst_46798 = fluree.db.storage.core.serde(conn);
var inst_46799 = fluree.db.serde.protocol._serialize_leaf(inst_46798,inst_46797);
var inst_46800 = fluree.db.storage.core.write_history(conn,history,inst_46794,null);
var inst_46801 = fluree.db.storage.core.storage_write(conn,inst_46793__$1,inst_46799);
var state_46812__$1 = (function (){var statearr_46816 = state_46812;
(statearr_46816[(7)] = inst_46793__$1);

(statearr_46816[(8)] = inst_46801);

return statearr_46816;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46812__$1,(6),inst_46800);
} else {
if((state_val_46813 === (3))){
var inst_46810 = (state_46812[(2)]);
var state_46812__$1 = state_46812;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46812__$1,inst_46810);
} else {
if((state_val_46813 === (4))){
var inst_46787 = (state_46812[(2)]);
var state_46812__$1 = state_46812;
var statearr_46818_46832 = state_46812__$1;
(statearr_46818_46832[(2)] = inst_46787);

(statearr_46818_46832[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46813 === (5))){
var _ = (function (){var statearr_46819 = state_46812;
(statearr_46819[(4)] = cljs.core.rest((state_46812[(4)])));

return statearr_46819;
})();
var state_46812__$1 = state_46812;
var ex46817 = (state_46812__$1[(2)]);
var statearr_46820_46833 = state_46812__$1;
(statearr_46820_46833[(5)] = ex46817);


if((ex46817 instanceof Error)){
var statearr_46821_46834 = state_46812__$1;
(statearr_46821_46834[(1)] = (4));

(statearr_46821_46834[(5)] = null);

} else {
throw ex46817;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46813 === (6))){
var inst_46801 = (state_46812[(8)]);
var inst_46803 = (state_46812[(2)]);
var inst_46804 = fluree.db.util.async.throw_err(inst_46803);
var state_46812__$1 = (function (){var statearr_46822 = state_46812;
(statearr_46822[(9)] = inst_46804);

return statearr_46822;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46812__$1,(7),inst_46801);
} else {
if((state_val_46813 === (7))){
var inst_46793 = (state_46812[(7)]);
var inst_46806 = (state_46812[(2)]);
var inst_46807 = fluree.db.util.async.throw_err(inst_46806);
var _ = (function (){var statearr_46823 = state_46812;
(statearr_46823[(4)] = cljs.core.rest((state_46812[(4)])));

return statearr_46823;
})();
var state_46812__$1 = (function (){var statearr_46824 = state_46812;
(statearr_46824[(10)] = inst_46807);

return statearr_46824;
})();
var statearr_46825_46835 = state_46812__$1;
(statearr_46825_46835[(2)] = inst_46793);

(statearr_46825_46835[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__20477__auto____0 = (function (){
var statearr_46826 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_46826[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__20477__auto__);

(statearr_46826[(1)] = (1));

return statearr_46826;
});
var fluree$db$storage$core$write_leaf_$_state_machine__20477__auto____1 = (function (state_46812){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46812);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46827){var ex__20480__auto__ = e46827;
var statearr_46828_46836 = state_46812;
(statearr_46828_46836[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46812[(4)]))){
var statearr_46829_46837 = state_46812;
(statearr_46829_46837[(1)] = cljs.core.first((state_46812[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46838 = state_46812;
state_46812 = G__46838;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__20477__auto__ = function(state_46812){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__20477__auto____1.call(this,state_46812);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__20477__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__20477__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46830 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46830[(6)] = c__20603__auto__);

return statearr_46830;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46855){
var state_val_46856 = (state_46855[(1)]);
if((state_val_46856 === (1))){
var state_46855__$1 = state_46855;
var statearr_46857_46872 = state_46855__$1;
(statearr_46857_46872[(2)] = null);

(statearr_46857_46872[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46856 === (2))){
var _ = (function (){var statearr_46858 = state_46855;
(statearr_46858[(4)] = cljs.core.cons((5),(state_46855[(4)])));

return statearr_46858;
})();
var inst_46845 = fluree.db.storage.core.serde(conn);
var inst_46846 = fluree.db.serde.protocol._serialize_branch(inst_46845,data);
var inst_46847 = fluree.db.storage.core.storage_write(conn,key,inst_46846);
var state_46855__$1 = state_46855;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46855__$1,(6),inst_46847);
} else {
if((state_val_46856 === (3))){
var inst_46853 = (state_46855[(2)]);
var state_46855__$1 = state_46855;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46855__$1,inst_46853);
} else {
if((state_val_46856 === (4))){
var inst_46839 = (state_46855[(2)]);
var state_46855__$1 = state_46855;
var statearr_46860_46873 = state_46855__$1;
(statearr_46860_46873[(2)] = inst_46839);

(statearr_46860_46873[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46856 === (5))){
var _ = (function (){var statearr_46861 = state_46855;
(statearr_46861[(4)] = cljs.core.rest((state_46855[(4)])));

return statearr_46861;
})();
var state_46855__$1 = state_46855;
var ex46859 = (state_46855__$1[(2)]);
var statearr_46862_46874 = state_46855__$1;
(statearr_46862_46874[(5)] = ex46859);


if((ex46859 instanceof Error)){
var statearr_46863_46875 = state_46855__$1;
(statearr_46863_46875[(1)] = (4));

(statearr_46863_46875[(5)] = null);

} else {
throw ex46859;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46856 === (6))){
var inst_46849 = (state_46855[(2)]);
var inst_46850 = fluree.db.util.async.throw_err(inst_46849);
var _ = (function (){var statearr_46864 = state_46855;
(statearr_46864[(4)] = cljs.core.rest((state_46855[(4)])));

return statearr_46864;
})();
var state_46855__$1 = (function (){var statearr_46865 = state_46855;
(statearr_46865[(7)] = inst_46850);

return statearr_46865;
})();
var statearr_46866_46876 = state_46855__$1;
(statearr_46866_46876[(2)] = key);

(statearr_46866_46876[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__20477__auto____0 = (function (){
var statearr_46867 = [null,null,null,null,null,null,null,null];
(statearr_46867[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__20477__auto__);

(statearr_46867[(1)] = (1));

return statearr_46867;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__20477__auto____1 = (function (state_46855){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46855);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46868){var ex__20480__auto__ = e46868;
var statearr_46869_46877 = state_46855;
(statearr_46869_46877[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46855[(4)]))){
var statearr_46870_46878 = state_46855;
(statearr_46870_46878[(1)] = cljs.core.first((state_46855[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46879 = state_46855;
state_46855 = G__46879;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__20477__auto__ = function(state_46855){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__20477__auto____1.call(this,state_46855);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__20477__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__20477__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46871 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46871[(6)] = c__20603__auto__);

return statearr_46871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__46880_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__46880_SHARP_));
}),children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__46881){
var map__46882 = p__46881;
var map__46882__$1 = cljs.core.__destructure_map(map__46882);
var progress = map__46882__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46882__$1,cljs.core.cst$kw$garbage);
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46910){
var state_val_46911 = (state_46910[(1)]);
if((state_val_46911 === (1))){
var state_46910__$1 = state_46910;
var statearr_46912_46928 = state_46910__$1;
(statearr_46912_46928[(2)] = null);

(statearr_46912_46928[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46911 === (2))){
var inst_46896 = (state_46910[(7)]);
var _ = (function (){var statearr_46913 = state_46910;
(statearr_46913[(4)] = cljs.core.cons((5),(state_46910[(4)])));

return statearr_46913;
})();
var inst_46890 = db;
var inst_46891 = cljs.core.__destructure_map(inst_46890);
var inst_46892 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46891,cljs.core.cst$kw$conn);
var inst_46893 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46891,cljs.core.cst$kw$network);
var inst_46894 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46891,cljs.core.cst$kw$dbid);
var inst_46895 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46891,cljs.core.cst$kw$block);
var inst_46896__$1 = fluree.db.storage.core.ledger_garbage_key(inst_46893,inst_46894,inst_46895);
var inst_46897 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_46898 = [inst_46894,inst_46895,garbage];
var inst_46899 = cljs.core.PersistentHashMap.fromArrays(inst_46897,inst_46898);
var inst_46900 = fluree.db.storage.core.serde(inst_46892);
var inst_46901 = fluree.db.serde.protocol._serialize_garbage(inst_46900,inst_46899);
var inst_46902 = fluree.db.storage.core.storage_write(inst_46892,inst_46896__$1,inst_46901);
var state_46910__$1 = (function (){var statearr_46914 = state_46910;
(statearr_46914[(7)] = inst_46896__$1);

return statearr_46914;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46910__$1,(6),inst_46902);
} else {
if((state_val_46911 === (3))){
var inst_46908 = (state_46910[(2)]);
var state_46910__$1 = state_46910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46910__$1,inst_46908);
} else {
if((state_val_46911 === (4))){
var inst_46883 = (state_46910[(2)]);
var state_46910__$1 = state_46910;
var statearr_46916_46929 = state_46910__$1;
(statearr_46916_46929[(2)] = inst_46883);

(statearr_46916_46929[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46911 === (5))){
var _ = (function (){var statearr_46917 = state_46910;
(statearr_46917[(4)] = cljs.core.rest((state_46910[(4)])));

return statearr_46917;
})();
var state_46910__$1 = state_46910;
var ex46915 = (state_46910__$1[(2)]);
var statearr_46918_46930 = state_46910__$1;
(statearr_46918_46930[(5)] = ex46915);


if((ex46915 instanceof Error)){
var statearr_46919_46931 = state_46910__$1;
(statearr_46919_46931[(1)] = (4));

(statearr_46919_46931[(5)] = null);

} else {
throw ex46915;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46911 === (6))){
var inst_46896 = (state_46910[(7)]);
var inst_46904 = (state_46910[(2)]);
var inst_46905 = fluree.db.util.async.throw_err(inst_46904);
var _ = (function (){var statearr_46920 = state_46910;
(statearr_46920[(4)] = cljs.core.rest((state_46910[(4)])));

return statearr_46920;
})();
var state_46910__$1 = (function (){var statearr_46921 = state_46910;
(statearr_46921[(8)] = inst_46905);

return statearr_46921;
})();
var statearr_46922_46932 = state_46910__$1;
(statearr_46922_46932[(2)] = inst_46896);

(statearr_46922_46932[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__20477__auto____0 = (function (){
var statearr_46923 = [null,null,null,null,null,null,null,null,null];
(statearr_46923[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__20477__auto__);

(statearr_46923[(1)] = (1));

return statearr_46923;
});
var fluree$db$storage$core$write_garbage_$_state_machine__20477__auto____1 = (function (state_46910){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46910);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e46924){var ex__20480__auto__ = e46924;
var statearr_46925_46933 = state_46910;
(statearr_46925_46933[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46910[(4)]))){
var statearr_46926_46934 = state_46910;
(statearr_46926_46934[(1)] = cljs.core.first((state_46910[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__46935 = state_46910;
state_46910 = G__46935;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__20477__auto__ = function(state_46910){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__20477__auto____1.call(this,state_46910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__20477__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__20477__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_46927 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_46927[(6)] = c__20603__auto__);

return statearr_46927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__46937 = arguments.length;
switch (G__46937) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_46993){
var state_val_46994 = (state_46993[(1)]);
if((state_val_46994 === (7))){
var state_46993__$1 = state_46993;
var statearr_46995_47021 = state_46993__$1;
(statearr_46995_47021[(2)] = (0));

(statearr_46995_47021[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46994 === (1))){
var state_46993__$1 = state_46993;
var statearr_46996_47022 = state_46993__$1;
(statearr_46996_47022[(2)] = null);

(statearr_46996_47022[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46994 === (4))){
var inst_46938 = (state_46993[(2)]);
var state_46993__$1 = state_46993;
var statearr_46997_47023 = state_46993__$1;
(statearr_46997_47023[(2)] = inst_46938);

(statearr_46997_47023[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46994 === (6))){
var inst_46963 = (state_46993[(7)]);
var state_46993__$1 = state_46993;
var statearr_46998_47024 = state_46993__$1;
(statearr_46998_47024[(2)] = inst_46963);

(statearr_46998_47024[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46994 === (3))){
var inst_46991 = (state_46993[(2)]);
var state_46993__$1 = state_46993;
return cljs.core.async.impl.ioc_helpers.return_chan(state_46993__$1,inst_46991);
} else {
if((state_val_46994 === (12))){
var inst_46960 = (state_46993[(8)]);
var inst_46987 = (state_46993[(2)]);
var inst_46988 = fluree.db.util.async.throw_err(inst_46987);
var _ = (function (){var statearr_46999 = state_46993;
(statearr_46999[(4)] = cljs.core.rest((state_46993[(4)])));

return statearr_46999;
})();
var state_46993__$1 = (function (){var statearr_47000 = state_46993;
(statearr_47000[(9)] = inst_46988);

return statearr_47000;
})();
var statearr_47001_47025 = state_46993__$1;
(statearr_47001_47025[(2)] = inst_46960);

(statearr_47001_47025[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46994 === (2))){
var inst_46953 = (state_46993[(10)]);
var inst_46951 = (state_46993[(11)]);
var inst_46963 = (state_46993[(7)]);
var inst_46955 = (state_46993[(12)]);
var _ = (function (){var statearr_47002 = state_46993;
(statearr_47002[(4)] = cljs.core.cons((5),(state_46993[(4)])));

return statearr_47002;
})();
var inst_46945 = db;
var inst_46946 = cljs.core.__destructure_map(inst_46945);
var inst_46947 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$network);
var inst_46948 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$t);
var inst_46949 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$fork);
var inst_46950 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$spot);
var inst_46951__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$stats);
var inst_46952 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$conn);
var inst_46953__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$block);
var inst_46954 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$psot);
var inst_46955__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$dbid);
var inst_46956 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$ecount);
var inst_46957 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$opst);
var inst_46958 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$fork_DASH_block);
var inst_46959 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_46946,cljs.core.cst$kw$post);
var inst_46960 = fluree.db.storage.core.ledger_root_key(inst_46947,inst_46955__$1,inst_46953__$1);
var inst_46961 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_46962 = fluree.db.storage.core.child_data(inst_46954);
var inst_46963__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_46951__$1);
var state_46993__$1 = (function (){var statearr_47003 = state_46993;
(statearr_47003[(10)] = inst_46953__$1);

(statearr_47003[(11)] = inst_46951__$1);

(statearr_47003[(8)] = inst_46960);

(statearr_47003[(13)] = inst_46961);

(statearr_47003[(7)] = inst_46963__$1);

(statearr_47003[(12)] = inst_46955__$1);

(statearr_47003[(14)] = inst_46958);

(statearr_47003[(15)] = inst_46949);

(statearr_47003[(16)] = inst_46948);

(statearr_47003[(17)] = inst_46952);

(statearr_47003[(18)] = inst_46950);

(statearr_47003[(19)] = inst_46956);

(statearr_47003[(20)] = inst_46957);

(statearr_47003[(21)] = inst_46959);

(statearr_47003[(22)] = inst_46962);

return statearr_47003;
})();
if(cljs.core.truth_(inst_46963__$1)){
var statearr_47004_47026 = state_46993__$1;
(statearr_47004_47026[(1)] = (6));

} else {
var statearr_47005_47027 = state_46993__$1;
(statearr_47005_47027[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46994 === (11))){
var inst_46953 = (state_46993[(10)]);
var inst_46951 = (state_46993[(11)]);
var inst_46960 = (state_46993[(8)]);
var inst_46961 = (state_46993[(13)]);
var inst_46955 = (state_46993[(12)]);
var inst_46958 = (state_46993[(14)]);
var inst_46949 = (state_46993[(15)]);
var inst_46967 = (state_46993[(23)]);
var inst_46948 = (state_46993[(16)]);
var inst_46952 = (state_46993[(17)]);
var inst_46950 = (state_46993[(18)]);
var inst_46957 = (state_46993[(20)]);
var inst_46959 = (state_46993[(21)]);
var inst_46962 = (state_46993[(22)]);
var inst_46972 = (state_46993[(2)]);
var inst_46973 = fluree.db.storage.core.child_data(inst_46957);
var inst_46974 = fluree.db.storage.core.child_data(inst_46959);
var inst_46975 = fluree.db.util.core.current_time_millis();
var inst_46976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_46977 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_46978 = (new cljs.core.PersistentVector(null,2,(5),inst_46976,inst_46977,null));
var inst_46979 = cljs.core.select_keys(inst_46951,inst_46978);
var inst_46980 = fluree.db.storage.core.child_data(inst_46950);
var inst_46981 = [inst_46953,inst_46962,inst_46955,inst_46967,inst_46972,inst_46973,inst_46974,inst_46948,inst_46975,inst_46949,inst_46958,inst_46979,inst_46980];
var inst_46982 = cljs.core.PersistentHashMap.fromArrays(inst_46961,inst_46981);
var inst_46983 = fluree.db.storage.core.serde(inst_46952);
var inst_46984 = fluree.db.serde.protocol._serialize_db_root(inst_46983,inst_46982);
var inst_46985 = fluree.db.storage.core.storage_write(inst_46952,inst_46960,inst_46984);
var state_46993__$1 = state_46993;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_46993__$1,(12),inst_46985);
} else {
if((state_val_46994 === (9))){
var inst_46968 = (state_46993[(24)]);
var state_46993__$1 = state_46993;
var statearr_47007_47028 = state_46993__$1;
(statearr_47007_47028[(2)] = inst_46968);

(statearr_47007_47028[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46994 === (5))){
var _ = (function (){var statearr_47008 = state_46993;
(statearr_47008[(4)] = cljs.core.rest((state_46993[(4)])));

return statearr_47008;
})();
var state_46993__$1 = state_46993;
var ex47006 = (state_46993__$1[(2)]);
var statearr_47009_47029 = state_46993__$1;
(statearr_47009_47029[(5)] = ex47006);


if((ex47006 instanceof Error)){
var statearr_47010_47030 = state_46993__$1;
(statearr_47010_47030[(1)] = (4));

(statearr_47010_47030[(5)] = null);

} else {
throw ex47006;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_46994 === (10))){
var inst_46956 = (state_46993[(19)]);
var state_46993__$1 = state_46993;
var statearr_47011_47031 = state_46993__$1;
(statearr_47011_47031[(2)] = inst_46956);

(statearr_47011_47031[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_46994 === (8))){
var inst_46968 = (state_46993[(24)]);
var inst_46967 = (state_46993[(2)]);
var inst_46968__$1 = custom_ecount;
var state_46993__$1 = (function (){var statearr_47012 = state_46993;
(statearr_47012[(23)] = inst_46967);

(statearr_47012[(24)] = inst_46968__$1);

return statearr_47012;
})();
if(cljs.core.truth_(inst_46968__$1)){
var statearr_47013_47032 = state_46993__$1;
(statearr_47013_47032[(1)] = (9));

} else {
var statearr_47014_47033 = state_46993__$1;
(statearr_47014_47033[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__20477__auto__ = null;
var fluree$db$storage$core$state_machine__20477__auto____0 = (function (){
var statearr_47015 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47015[(0)] = fluree$db$storage$core$state_machine__20477__auto__);

(statearr_47015[(1)] = (1));

return statearr_47015;
});
var fluree$db$storage$core$state_machine__20477__auto____1 = (function (state_46993){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_46993);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e47016){var ex__20480__auto__ = e47016;
var statearr_47017_47034 = state_46993;
(statearr_47017_47034[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_46993[(4)]))){
var statearr_47018_47035 = state_46993;
(statearr_47018_47035[(1)] = cljs.core.first((state_46993[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__47036 = state_46993;
state_46993 = G__47036;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__20477__auto__ = function(state_46993){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__20477__auto____1.call(this,state_46993);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__20477__auto____0;
fluree$db$storage$core$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__20477__auto____1;
return fluree$db$storage$core$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_47019 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_47019[(6)] = c__20603__auto__);

return statearr_47019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__20603__auto___47095 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_47069){
var state_val_47070 = (state_47069[(1)]);
if((state_val_47070 === (7))){
var inst_47049 = (state_47069[(7)]);
var state_47069__$1 = state_47069;
var statearr_47071_47096 = state_47069__$1;
(statearr_47071_47096[(2)] = inst_47049);

(statearr_47071_47096[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47070 === (1))){
var state_47069__$1 = state_47069;
var statearr_47072_47097 = state_47069__$1;
(statearr_47072_47097[(2)] = null);

(statearr_47072_47097[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47070 === (4))){
var inst_47037 = (state_47069[(2)]);
var inst_47038 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_47039 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_47037);
var inst_47040 = cljs.core.async.close_BANG_(return_ch);
var state_47069__$1 = (function (){var statearr_47073 = state_47069;
(statearr_47073[(8)] = inst_47038);

(statearr_47073[(9)] = inst_47039);

return statearr_47073;
})();
var statearr_47074_47098 = state_47069__$1;
(statearr_47074_47098[(2)] = inst_47040);

(statearr_47074_47098[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47070 === (6))){
var inst_47049 = (state_47069[(7)]);
var inst_47048 = (state_47069[(10)]);
var inst_47048__$1 = (state_47069[(2)]);
var inst_47049__$1 = (inst_47048__$1 == null);
var state_47069__$1 = (function (){var statearr_47075 = state_47069;
(statearr_47075[(7)] = inst_47049__$1);

(statearr_47075[(10)] = inst_47048__$1);

return statearr_47075;
})();
if(cljs.core.truth_(inst_47049__$1)){
var statearr_47076_47099 = state_47069__$1;
(statearr_47076_47099[(1)] = (7));

} else {
var statearr_47077_47100 = state_47069__$1;
(statearr_47077_47100[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47070 === (3))){
var inst_47067 = (state_47069[(2)]);
var state_47069__$1 = state_47069;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47069__$1,inst_47067);
} else {
if((state_val_47070 === (12))){
var inst_47064 = (state_47069[(2)]);
var _ = (function (){var statearr_47078 = state_47069;
(statearr_47078[(4)] = cljs.core.rest((state_47069[(4)])));

return statearr_47078;
})();
var state_47069__$1 = state_47069;
var statearr_47079_47101 = state_47069__$1;
(statearr_47079_47101[(2)] = inst_47064);

(statearr_47079_47101[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47070 === (2))){
var _ = (function (){var statearr_47080 = state_47069;
(statearr_47080[(4)] = cljs.core.cons((5),(state_47069[(4)])));

return statearr_47080;
})();
var inst_47046 = fluree.db.storage.core.storage_read(conn,key);
var state_47069__$1 = state_47069;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47069__$1,(6),inst_47046);
} else {
if((state_val_47070 === (11))){
var inst_47048 = (state_47069[(10)]);
var inst_47058 = fluree.db.storage.core.serde(conn);
var inst_47059 = fluree.db.serde.protocol._deserialize_leaf(inst_47058,inst_47048);
var inst_47060 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_47059);
var inst_47061 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_47060);
var inst_47062 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_47061);
var state_47069__$1 = state_47069;
var statearr_47082_47102 = state_47069__$1;
(statearr_47082_47102[(2)] = inst_47062);

(statearr_47082_47102[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47070 === (9))){
var inst_47054 = (state_47069[(2)]);
var state_47069__$1 = state_47069;
if(cljs.core.truth_(inst_47054)){
var statearr_47083_47103 = state_47069__$1;
(statearr_47083_47103[(1)] = (10));

} else {
var statearr_47084_47104 = state_47069__$1;
(statearr_47084_47104[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47070 === (5))){
var _ = (function (){var statearr_47085 = state_47069;
(statearr_47085[(4)] = cljs.core.rest((state_47069[(4)])));

return statearr_47085;
})();
var state_47069__$1 = state_47069;
var ex47081 = (state_47069__$1[(2)]);
var statearr_47086_47105 = state_47069__$1;
(statearr_47086_47105[(5)] = ex47081);


var statearr_47087_47106 = state_47069__$1;
(statearr_47087_47106[(1)] = (4));

(statearr_47087_47106[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47070 === (10))){
var inst_47056 = cljs.core.async.close_BANG_(return_ch);
var state_47069__$1 = state_47069;
var statearr_47088_47107 = state_47069__$1;
(statearr_47088_47107[(2)] = inst_47056);

(statearr_47088_47107[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47070 === (8))){
var inst_47048 = (state_47069[(10)]);
var inst_47052 = (inst_47048 instanceof Error);
var state_47069__$1 = state_47069;
var statearr_47089_47108 = state_47069__$1;
(statearr_47089_47108[(2)] = inst_47052);

(statearr_47089_47108[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__20477__auto____0 = (function (){
var statearr_47090 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47090[(0)] = fluree$db$storage$core$reify_history_$_state_machine__20477__auto__);

(statearr_47090[(1)] = (1));

return statearr_47090;
});
var fluree$db$storage$core$reify_history_$_state_machine__20477__auto____1 = (function (state_47069){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_47069);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e47091){var ex__20480__auto__ = e47091;
var statearr_47092_47109 = state_47069;
(statearr_47092_47109[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_47069[(4)]))){
var statearr_47093_47110 = state_47069;
(statearr_47093_47110[(1)] = cljs.core.first((state_47069[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__47111 = state_47069;
state_47069 = G__47111;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__20477__auto__ = function(state_47069){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__20477__auto____1.call(this,state_47069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__20477__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__20477__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_47094 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_47094[(6)] = c__20603__auto___47095);

return statearr_47094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__47113 = arguments.length;
switch (G__47113) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4221__auto__ = rhs;
if(cljs.core.truth_(and__4221__auto__)){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4221__auto__ = (rhs == null);
if(and__4221__auto__){
return leftmost_QMARK_;
} else {
return and__4221__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__20603__auto___47225 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_47176){
var state_val_47177 = (state_47176[(1)]);
if((state_val_47177 === (7))){
var state_47176__$1 = state_47176;
var statearr_47178_47226 = state_47176__$1;
(statearr_47178_47226[(2)] = cljs.core.cst$kw$novelty);

(statearr_47178_47226[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (20))){
var inst_47155 = cljs.core.PersistentVector.EMPTY;
var state_47176__$1 = state_47176;
var statearr_47179_47227 = state_47176__$1;
(statearr_47179_47227[(2)] = inst_47155);

(statearr_47179_47227[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (1))){
var state_47176__$1 = state_47176;
var statearr_47180_47228 = state_47176__$1;
(statearr_47180_47228[(2)] = null);

(statearr_47180_47228[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (24))){
var state_47176__$1 = state_47176;
var statearr_47181_47229 = state_47176__$1;
(statearr_47181_47229[(2)] = null);

(statearr_47181_47229[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (4))){
var inst_47116 = (state_47176[(2)]);
var inst_47117 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_47118 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_47116);
var inst_47119 = cljs.core.async.close_BANG_(result_ch);
var state_47176__$1 = (function (){var statearr_47182 = state_47176;
(statearr_47182[(7)] = inst_47117);

(statearr_47182[(8)] = inst_47118);

return statearr_47182;
})();
var statearr_47183_47230 = state_47176__$1;
(statearr_47183_47230[(2)] = inst_47119);

(statearr_47183_47230[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (15))){
var inst_47141 = (state_47176[(2)]);
var state_47176__$1 = state_47176;
var statearr_47184_47231 = state_47176__$1;
(statearr_47184_47231[(2)] = inst_47141);

(statearr_47184_47231[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (21))){
var inst_47129 = (state_47176[(9)]);
var inst_47158 = (state_47176[(10)]);
var inst_47145 = (state_47176[(11)]);
var inst_47130 = (state_47176[(12)]);
var inst_47128 = (state_47176[(13)]);
var inst_47165 = (state_47176[(2)]);
var inst_47166 = (function (){var base_node = inst_47128;
var first_flake = inst_47129;
var node_t = inst_47130;
var source = inst_47145;
var coll = inst_47158;
var conj_QMARK_ = inst_47165;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__47186 = f.p;
var fexpr__47185 = (function (){var or__4223__auto__ = remove_preds;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__47185.cljs$core$IFn$_invoke$arity$1 ? fexpr__47185.cljs$core$IFn$_invoke$arity$1(G__47186) : fexpr__47185.call(null,G__47186));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_47167 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_47128);
var inst_47168 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_47166,inst_47167,inst_47158);
var inst_47169 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_47168);
var inst_47170 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_47128,cljs.core.cst$kw$flakes,inst_47169);
var inst_47171 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_47170);
var _ = (function (){var statearr_47187 = state_47176;
(statearr_47187[(4)] = cljs.core.rest((state_47176[(4)])));

return statearr_47187;
})();
var state_47176__$1 = state_47176;
var statearr_47188_47232 = state_47176__$1;
(statearr_47188_47232[(2)] = inst_47171);

(statearr_47188_47232[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (13))){
var state_47176__$1 = state_47176;
var statearr_47189_47233 = state_47176__$1;
(statearr_47189_47233[(2)] = cljs.core.cst$kw$none);

(statearr_47189_47233[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (22))){
var inst_47129 = (state_47176[(9)]);
var inst_47158 = (state_47176[(10)]);
var inst_47145 = (state_47176[(11)]);
var inst_47130 = (state_47176[(12)]);
var inst_47128 = (state_47176[(13)]);
var inst_47159 = (function (){var base_node = inst_47128;
var first_flake = inst_47129;
var node_t = inst_47130;
var source = inst_47145;
var coll = inst_47158;
return (function (f){
return f.op === true;
});
})();
var state_47176__$1 = state_47176;
var statearr_47190_47234 = state_47176__$1;
(statearr_47190_47234[(2)] = inst_47159);

(statearr_47190_47234[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (6))){
var inst_47130 = (state_47176[(12)]);
var inst_47128 = (state_47176[(13)]);
var inst_47127 = (state_47176[(2)]);
var inst_47128__$1 = fluree.db.util.async.throw_err(inst_47127);
var inst_47129 = fluree.db.dbproto._first_flake(inst_47128__$1);
var inst_47130__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_47128__$1);
var inst_47131 = (inst_47130__$1 > t);
var state_47176__$1 = (function (){var statearr_47191 = state_47176;
(statearr_47191[(9)] = inst_47129);

(statearr_47191[(12)] = inst_47130__$1);

(statearr_47191[(13)] = inst_47128__$1);

return statearr_47191;
})();
if(cljs.core.truth_(inst_47131)){
var statearr_47192_47235 = state_47176__$1;
(statearr_47192_47235[(1)] = (7));

} else {
var statearr_47193_47236 = state_47176__$1;
(statearr_47193_47236[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (17))){
var inst_47129 = (state_47176[(9)]);
var inst_47146 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_47129,rhs,leftmost_QMARK_,t);
var state_47176__$1 = state_47176;
var statearr_47194_47237 = state_47176__$1;
(statearr_47194_47237[(2)] = inst_47146);

(statearr_47194_47237[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (3))){
var inst_47174 = (state_47176[(2)]);
var state_47176__$1 = state_47176;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47176__$1,inst_47174);
} else {
if((state_val_47177 === (12))){
var inst_47143 = (state_47176[(2)]);
var state_47176__$1 = state_47176;
var statearr_47195_47238 = state_47176__$1;
(statearr_47195_47238[(2)] = inst_47143);

(statearr_47195_47238[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (2))){
var _ = (function (){var statearr_47196 = state_47176;
(statearr_47196[(4)] = cljs.core.cons((5),(state_47176[(4)])));

return statearr_47196;
})();
var inst_47125 = fluree.db.dbproto._resolve(node);
var state_47176__$1 = state_47176;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47176__$1,(6),inst_47125);
} else {
if((state_val_47177 === (23))){
var inst_47129 = (state_47176[(9)]);
var inst_47158 = (state_47176[(10)]);
var inst_47145 = (state_47176[(11)]);
var inst_47130 = (state_47176[(12)]);
var inst_47128 = (state_47176[(13)]);
var inst_47161 = (function (){var base_node = inst_47128;
var first_flake = inst_47129;
var node_t = inst_47130;
var source = inst_47145;
var coll = inst_47158;
return (function (f){
return f.op === false;
});
})();
var state_47176__$1 = state_47176;
var statearr_47197_47239 = state_47176__$1;
(statearr_47197_47239[(2)] = inst_47161);

(statearr_47197_47239[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (19))){
var inst_47148 = (state_47176[(14)]);
var inst_47151 = (state_47176[(2)]);
var inst_47152 = fluree.db.util.async.throw_err(inst_47151);
var inst_47153 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_47148,inst_47152);
var state_47176__$1 = state_47176;
var statearr_47198_47240 = state_47176__$1;
(statearr_47198_47240[(2)] = inst_47153);

(statearr_47198_47240[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (11))){
var inst_47130 = (state_47176[(12)]);
var inst_47137 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47130,t);
var state_47176__$1 = state_47176;
if(inst_47137){
var statearr_47200_47241 = state_47176__$1;
(statearr_47200_47241[(1)] = (13));

} else {
var statearr_47201_47242 = state_47176__$1;
(statearr_47201_47242[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (9))){
var inst_47145 = (state_47176[(11)]);
var inst_47145__$1 = (state_47176[(2)]);
var state_47176__$1 = (function (){var statearr_47202 = state_47176;
(statearr_47202[(11)] = inst_47145__$1);

return statearr_47202;
})();
var G__47203_47243 = inst_47145__$1;
var G__47203_47244__$1 = (((G__47203_47243 instanceof cljs.core.Keyword))?G__47203_47243.fqn:null);
switch (G__47203_47244__$1) {
case "novelty":
var statearr_47204_47246 = state_47176__$1;
(statearr_47204_47246[(1)] = (17));


break;
case "history":
var statearr_47205_47247 = state_47176__$1;
(statearr_47205_47247[(1)] = (18));


break;
case "none":
var statearr_47206_47248 = state_47176__$1;
(statearr_47206_47248[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__47203_47244__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (5))){
var _ = (function (){var statearr_47207 = state_47176;
(statearr_47207[(4)] = cljs.core.rest((state_47176[(4)])));

return statearr_47207;
})();
var state_47176__$1 = state_47176;
var ex47199 = (state_47176__$1[(2)]);
var statearr_47208_47249 = state_47176__$1;
(statearr_47208_47249[(5)] = ex47199);


var statearr_47209_47250 = state_47176__$1;
(statearr_47209_47250[(1)] = (4));

(statearr_47209_47250[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (14))){
var state_47176__$1 = state_47176;
var statearr_47210_47251 = state_47176__$1;
(statearr_47210_47251[(2)] = null);

(statearr_47210_47251[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (16))){
var inst_47145 = (state_47176[(11)]);
var inst_47158 = (state_47176[(2)]);
var state_47176__$1 = (function (){var statearr_47211 = state_47176;
(statearr_47211[(10)] = inst_47158);

return statearr_47211;
})();
var G__47212_47252 = inst_47145;
var G__47212_47253__$1 = (((G__47212_47252 instanceof cljs.core.Keyword))?G__47212_47252.fqn:null);
switch (G__47212_47253__$1) {
case "novelty":
var statearr_47213_47255 = state_47176__$1;
(statearr_47213_47255[(1)] = (22));


break;
case "history":
var statearr_47214_47256 = state_47176__$1;
(statearr_47214_47256[(1)] = (23));


break;
case "none":
var statearr_47215_47257 = state_47176__$1;
(statearr_47215_47257[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__47212_47253__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (10))){
var state_47176__$1 = state_47176;
var statearr_47216_47258 = state_47176__$1;
(statearr_47216_47258[(2)] = cljs.core.cst$kw$history);

(statearr_47216_47258[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47177 === (18))){
var inst_47129 = (state_47176[(9)]);
var inst_47145 = (state_47176[(11)]);
var inst_47130 = (state_47176[(12)]);
var inst_47128 = (state_47176[(13)]);
var inst_47148 = (function (){var base_node = inst_47128;
var first_flake = inst_47129;
var node_t = inst_47130;
var source = inst_47145;
return (function (p1__47115_SHARP_){
return (p1__47115_SHARP_.t <= t);
});
})();
var inst_47149 = fluree.db.dbproto._resolve_history(node);
var state_47176__$1 = (function (){var statearr_47217 = state_47176;
(statearr_47217[(14)] = inst_47148);

return statearr_47217;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47176__$1,(19),inst_47149);
} else {
if((state_val_47177 === (8))){
var inst_47130 = (state_47176[(12)]);
var inst_47134 = (inst_47130 < t);
var state_47176__$1 = state_47176;
if(cljs.core.truth_(inst_47134)){
var statearr_47218_47259 = state_47176__$1;
(statearr_47218_47259[(1)] = (10));

} else {
var statearr_47219_47260 = state_47176__$1;
(statearr_47219_47260[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__20477__auto____0 = (function (){
var statearr_47220 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47220[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__20477__auto__);

(statearr_47220[(1)] = (1));

return statearr_47220;
});
var fluree$db$storage$core$resolve_t_$_state_machine__20477__auto____1 = (function (state_47176){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_47176);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e47221){var ex__20480__auto__ = e47221;
var statearr_47222_47261 = state_47176;
(statearr_47222_47261[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_47176[(4)]))){
var statearr_47223_47262 = state_47176;
(statearr_47223_47262[(1)] = cljs.core.first((state_47176[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__47263 = state_47176;
state_47176 = G__47263;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__20477__auto__ = function(state_47176){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__20477__auto____1.call(this,state_47176);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__20477__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__20477__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_47224 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_47224[(6)] = c__20603__auto___47225);

return statearr_47224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_47323){
var state_val_47324 = (state_47323[(1)]);
if((state_val_47324 === (7))){
var inst_47274 = (state_47323[(7)]);
var inst_47278 = (inst_47274 <= from_t);
var state_47323__$1 = state_47323;
var statearr_47325_47365 = state_47323__$1;
(statearr_47325_47365[(2)] = inst_47278);

(statearr_47325_47365[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (20))){
var inst_47308 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_47309 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_47308)].join('');
var inst_47310 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47311 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_47312 = cljs.core.PersistentHashMap.fromArrays(inst_47310,inst_47311);
var inst_47313 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47309,inst_47312);
var inst_47314 = (function(){throw inst_47313})();
var state_47323__$1 = state_47323;
var statearr_47326_47366 = state_47323__$1;
(statearr_47326_47366[(2)] = inst_47314);

(statearr_47326_47366[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (1))){
var state_47323__$1 = state_47323;
var statearr_47327_47367 = state_47323__$1;
(statearr_47327_47367[(2)] = null);

(statearr_47327_47367[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (4))){
var inst_47266 = (state_47323[(2)]);
var inst_47267 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_47266], 0));
var inst_47268 = (function(){throw inst_47266})();
var state_47323__$1 = (function (){var statearr_47328 = state_47323;
(statearr_47328[(8)] = inst_47267);

return statearr_47328;
})();
var statearr_47329_47368 = state_47323__$1;
(statearr_47329_47368[(2)] = inst_47268);

(statearr_47329_47368[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (15))){
var inst_47293 = (state_47323[(2)]);
var state_47323__$1 = (function (){var statearr_47330 = state_47323;
(statearr_47330[(9)] = inst_47293);

return statearr_47330;
})();
if(cljs.core.truth_(from_t)){
var statearr_47331_47369 = state_47323__$1;
(statearr_47331_47369[(1)] = (16));

} else {
var statearr_47332_47370 = state_47323__$1;
(statearr_47332_47370[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (21))){
var inst_47302 = (state_47323[(10)]);
var inst_47304 = (state_47323[(11)]);
var inst_47303 = (state_47323[(12)]);
var inst_47316 = (state_47323[(2)]);
var inst_47317 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_47303,inst_47304,leftmost_QMARK_,to_t);
var inst_47318 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_47317,inst_47302);
var _ = (function (){var statearr_47333 = state_47323;
(statearr_47333[(4)] = cljs.core.rest((state_47323[(4)])));

return statearr_47333;
})();
var state_47323__$1 = (function (){var statearr_47334 = state_47323;
(statearr_47334[(13)] = inst_47316);

return statearr_47334;
})();
var statearr_47335_47371 = state_47323__$1;
(statearr_47335_47371[(2)] = inst_47318);

(statearr_47335_47371[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (13))){
var inst_47286 = (state_47323[(14)]);
var inst_47274 = (state_47323[(7)]);
var inst_47289 = (function (){var node_t = inst_47274;
var G__47282 = inst_47286;
return (function (p1__47264_SHARP_){
return (p1__47264_SHARP_.t < to_t);
});
})();
var inst_47290 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_47289,inst_47286);
var state_47323__$1 = state_47323;
var statearr_47336_47372 = state_47323__$1;
(statearr_47336_47372[(2)] = inst_47290);

(statearr_47336_47372[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (6))){
var inst_47275 = (state_47323[(15)]);
var state_47323__$1 = state_47323;
var statearr_47337_47373 = state_47323__$1;
(statearr_47337_47373[(2)] = inst_47275);

(statearr_47337_47373[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (17))){
var inst_47293 = (state_47323[(9)]);
var state_47323__$1 = state_47323;
var statearr_47338_47374 = state_47323__$1;
(statearr_47338_47374[(2)] = inst_47293);

(statearr_47338_47374[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (3))){
var inst_47321 = (state_47323[(2)]);
var state_47323__$1 = state_47323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47323__$1,inst_47321);
} else {
if((state_val_47324 === (12))){
var inst_47274 = (state_47323[(7)]);
var inst_47285 = (state_47323[(2)]);
var inst_47286 = fluree.db.util.async.throw_err(inst_47285);
var inst_47287 = (to_t > inst_47274);
var state_47323__$1 = (function (){var statearr_47339 = state_47323;
(statearr_47339[(14)] = inst_47286);

return statearr_47339;
})();
if(cljs.core.truth_(inst_47287)){
var statearr_47340_47375 = state_47323__$1;
(statearr_47340_47375[(1)] = (13));

} else {
var statearr_47341_47376 = state_47323__$1;
(statearr_47341_47376[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (2))){
var inst_47275 = (state_47323[(15)]);
var _ = (function (){var statearr_47342 = state_47323;
(statearr_47342[(4)] = cljs.core.cons((5),(state_47323[(4)])));

return statearr_47342;
})();
var inst_47274 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_47275__$1 = (from_t == null);
var state_47323__$1 = (function (){var statearr_47343 = state_47323;
(statearr_47343[(15)] = inst_47275__$1);

(statearr_47343[(7)] = inst_47274);

return statearr_47343;
})();
if(cljs.core.truth_(inst_47275__$1)){
var statearr_47344_47377 = state_47323__$1;
(statearr_47344_47377[(1)] = (6));

} else {
var statearr_47345_47378 = state_47323__$1;
(statearr_47345_47378[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (19))){
var state_47323__$1 = state_47323;
var statearr_47346_47379 = state_47323__$1;
(statearr_47346_47379[(2)] = null);

(statearr_47346_47379[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (11))){
var inst_47302 = (state_47323[(2)]);
var inst_47303 = fluree.db.dbproto._first_flake(node);
var inst_47304 = fluree.db.dbproto._rhs(node);
var inst_47305 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_47323__$1 = (function (){var statearr_47348 = state_47323;
(statearr_47348[(10)] = inst_47302);

(statearr_47348[(11)] = inst_47304);

(statearr_47348[(12)] = inst_47303);

return statearr_47348;
})();
if(cljs.core.truth_(inst_47305)){
var statearr_47349_47380 = state_47323__$1;
(statearr_47349_47380[(1)] = (19));

} else {
var statearr_47350_47381 = state_47323__$1;
(statearr_47350_47381[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (9))){
var inst_47283 = fluree.db.dbproto._resolve_history(node);
var state_47323__$1 = state_47323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47323__$1,(12),inst_47283);
} else {
if((state_val_47324 === (5))){
var _ = (function (){var statearr_47351 = state_47323;
(statearr_47351[(4)] = cljs.core.rest((state_47323[(4)])));

return statearr_47351;
})();
var state_47323__$1 = state_47323;
var ex47347 = (state_47323__$1[(2)]);
var statearr_47352_47382 = state_47323__$1;
(statearr_47352_47382[(5)] = ex47347);


var statearr_47353_47383 = state_47323__$1;
(statearr_47353_47383[(1)] = (4));

(statearr_47353_47383[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (14))){
var inst_47286 = (state_47323[(14)]);
var state_47323__$1 = state_47323;
var statearr_47354_47384 = state_47323__$1;
(statearr_47354_47384[(2)] = inst_47286);

(statearr_47354_47384[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (16))){
var inst_47274 = (state_47323[(7)]);
var inst_47293 = (state_47323[(9)]);
var inst_47295 = (function (){var node_t = inst_47274;
var G__47282 = inst_47293;
return (function (p1__47265_SHARP_){
return (p1__47265_SHARP_.t <= from_t);
});
})();
var inst_47296 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_47295,inst_47293);
var state_47323__$1 = state_47323;
var statearr_47355_47385 = state_47323__$1;
(statearr_47355_47385[(2)] = inst_47296);

(statearr_47355_47385[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (10))){
var state_47323__$1 = state_47323;
var statearr_47356_47386 = state_47323__$1;
(statearr_47356_47386[(2)] = null);

(statearr_47356_47386[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (18))){
var inst_47299 = (state_47323[(2)]);
var state_47323__$1 = state_47323;
var statearr_47357_47387 = state_47323__$1;
(statearr_47357_47387[(2)] = inst_47299);

(statearr_47357_47387[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47324 === (8))){
var inst_47280 = (state_47323[(2)]);
var state_47323__$1 = state_47323;
if(cljs.core.truth_(inst_47280)){
var statearr_47358_47388 = state_47323__$1;
(statearr_47358_47388[(1)] = (9));

} else {
var statearr_47359_47389 = state_47323__$1;
(statearr_47359_47389[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__20477__auto____0 = (function (){
var statearr_47360 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47360[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__20477__auto__);

(statearr_47360[(1)] = (1));

return statearr_47360;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__20477__auto____1 = (function (state_47323){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_47323);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e47361){var ex__20480__auto__ = e47361;
var statearr_47362_47390 = state_47323;
(statearr_47362_47390[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_47323[(4)]))){
var statearr_47363_47391 = state_47323;
(statearr_47363_47391[(1)] = cljs.core.first((state_47323[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__47392 = state_47323;
state_47323 = G__47392;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__20477__auto__ = function(state_47323){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__20477__auto____1.call(this,state_47323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__20477__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__20477__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_47364 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_47364[(6)] = c__20603__auto__);

return statearr_47364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4223__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__47393_47403 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__47394_47404 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__47393_47403,G__47394_47404) : object_cache.call(null,G__47393_47403,G__47394_47404));

var G__47395 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__47396 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__47397 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__47398 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__47397,G__47398) : object_cache.call(null,G__47397,G__47398));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__47395,G__47396) : object_cache.call(null,G__47395,G__47396));
} else {
var G__47399 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__47400 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__47401 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__47402 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__47401,G__47402) : object_cache.call(null,G__47401,G__47402));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__47399,G__47400) : object_cache.call(null,G__47399,G__47400));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_47425){
var state_val_47426 = (state_47425[(1)]);
if((state_val_47426 === (7))){
var state_47425__$1 = state_47425;
var statearr_47427_47447 = state_47425__$1;
(statearr_47427_47447[(2)] = null);

(statearr_47427_47447[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47426 === (1))){
var state_47425__$1 = state_47425;
var statearr_47428_47448 = state_47425__$1;
(statearr_47428_47448[(2)] = null);

(statearr_47428_47448[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47426 === (4))){
var inst_47405 = (state_47425[(2)]);
var state_47425__$1 = state_47425;
var statearr_47429_47449 = state_47425__$1;
(statearr_47429_47449[(2)] = inst_47405);

(statearr_47429_47449[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47426 === (6))){
var inst_47411 = (state_47425[(7)]);
var inst_47413 = fluree.db.storage.core.serde(conn);
var state_47425__$1 = (function (){var statearr_47430 = state_47425;
(statearr_47430[(8)] = inst_47413);

return statearr_47430;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47425__$1,(9),inst_47411);
} else {
if((state_val_47426 === (3))){
var inst_47423 = (state_47425[(2)]);
var state_47425__$1 = state_47425;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47425__$1,inst_47423);
} else {
if((state_val_47426 === (2))){
var inst_47411 = (state_47425[(7)]);
var _ = (function (){var statearr_47432 = state_47425;
(statearr_47432[(4)] = cljs.core.cons((5),(state_47425[(4)])));

return statearr_47432;
})();
var inst_47411__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_47425__$1 = (function (){var statearr_47433 = state_47425;
(statearr_47433[(7)] = inst_47411__$1);

return statearr_47433;
})();
if(cljs.core.truth_(inst_47411__$1)){
var statearr_47434_47450 = state_47425__$1;
(statearr_47434_47450[(1)] = (6));

} else {
var statearr_47435_47451 = state_47425__$1;
(statearr_47435_47451[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47426 === (9))){
var inst_47413 = (state_47425[(8)]);
var inst_47415 = (state_47425[(2)]);
var inst_47416 = fluree.db.util.async.throw_err(inst_47415);
var inst_47417 = fluree.db.serde.protocol._deserialize_branch(inst_47413,inst_47416);
var state_47425__$1 = state_47425;
var statearr_47436_47452 = state_47425__$1;
(statearr_47436_47452[(2)] = inst_47417);

(statearr_47436_47452[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47426 === (5))){
var _ = (function (){var statearr_47437 = state_47425;
(statearr_47437[(4)] = cljs.core.rest((state_47425[(4)])));

return statearr_47437;
})();
var state_47425__$1 = state_47425;
var ex47431 = (state_47425__$1[(2)]);
var statearr_47438_47453 = state_47425__$1;
(statearr_47438_47453[(5)] = ex47431);


if((ex47431 instanceof Error)){
var statearr_47439_47454 = state_47425__$1;
(statearr_47439_47454[(1)] = (4));

(statearr_47439_47454[(5)] = null);

} else {
throw ex47431;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47426 === (8))){
var inst_47420 = (state_47425[(2)]);
var _ = (function (){var statearr_47440 = state_47425;
(statearr_47440[(4)] = cljs.core.rest((state_47425[(4)])));

return statearr_47440;
})();
var state_47425__$1 = state_47425;
var statearr_47441_47455 = state_47425__$1;
(statearr_47441_47455[(2)] = inst_47420);

(statearr_47441_47455[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__20477__auto____0 = (function (){
var statearr_47442 = [null,null,null,null,null,null,null,null,null];
(statearr_47442[(0)] = fluree$db$storage$core$read_branch_$_state_machine__20477__auto__);

(statearr_47442[(1)] = (1));

return statearr_47442;
});
var fluree$db$storage$core$read_branch_$_state_machine__20477__auto____1 = (function (state_47425){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_47425);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e47443){var ex__20480__auto__ = e47443;
var statearr_47444_47456 = state_47425;
(statearr_47444_47456[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_47425[(4)]))){
var statearr_47445_47457 = state_47425;
(statearr_47445_47457[(1)] = cljs.core.first((state_47425[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__47458 = state_47425;
state_47425 = G__47458;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__20477__auto__ = function(state_47425){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__20477__auto____1.call(this,state_47425);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__20477__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__20477__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_47446 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_47446[(6)] = c__20603__auto__);

return statearr_47446;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__20603__auto___47537 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_47509){
var state_val_47510 = (state_47509[(1)]);
if((state_val_47510 === (7))){
var inst_47476 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_47477 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47478 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_47479 = cljs.core.PersistentHashMap.fromArrays(inst_47477,inst_47478);
var inst_47480 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47476,inst_47479);
var inst_47481 = (function(){throw inst_47480})();
var state_47509__$1 = state_47509;
var statearr_47511_47538 = state_47509__$1;
(statearr_47511_47538[(2)] = inst_47481);

(statearr_47511_47538[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47510 === (1))){
var state_47509__$1 = state_47509;
var statearr_47512_47539 = state_47509__$1;
(statearr_47512_47539[(2)] = null);

(statearr_47512_47539[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47510 === (4))){
var inst_47459 = (state_47509[(2)]);
var inst_47460 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_47461 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_47459);
var inst_47462 = cljs.core.async.close_BANG_(return_ch);
var state_47509__$1 = (function (){var statearr_47513 = state_47509;
(statearr_47513[(7)] = inst_47460);

(statearr_47513[(8)] = inst_47461);

return statearr_47513;
})();
var statearr_47514_47540 = state_47509__$1;
(statearr_47514_47540[(2)] = inst_47462);

(statearr_47514_47540[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47510 === (6))){
var inst_47473 = (state_47509[(9)]);
var inst_47472 = (state_47509[(2)]);
var inst_47473__$1 = fluree.db.util.async.throw_err(inst_47472);
var inst_47474 = (inst_47473__$1 == null);
var state_47509__$1 = (function (){var statearr_47515 = state_47509;
(statearr_47515[(9)] = inst_47473__$1);

return statearr_47515;
})();
if(cljs.core.truth_(inst_47474)){
var statearr_47516_47541 = state_47509__$1;
(statearr_47516_47541[(1)] = (7));

} else {
var statearr_47517_47542 = state_47509__$1;
(statearr_47517_47542[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47510 === (3))){
var inst_47507 = (state_47509[(2)]);
var state_47509__$1 = state_47509;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47509__$1,inst_47507);
} else {
if((state_val_47510 === (12))){
var inst_47473 = (state_47509[(9)]);
var inst_47490 = (state_47509[(2)]);
var inst_47491 = cljs.core.__destructure_map(inst_47473);
var inst_47492 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47491,cljs.core.cst$kw$children);
var inst_47493 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47491,cljs.core.cst$kw$rhs);
var inst_47494 = config;
var inst_47495 = cljs.core.__destructure_map(inst_47494);
var inst_47496 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47495,cljs.core.cst$kw$comparator);
var inst_47498 = (function (){var data = inst_47473;
var _ = inst_47490;
var map__47468 = inst_47491;
var children = inst_47492;
var rhs = inst_47493;
var map__47469 = inst_47495;
var comparator = inst_47496;
return (function (idx,p__47497){
var map__47518 = p__47497;
var map__47518__$1 = cljs.core.__destructure_map(map__47518);
var child = map__47518__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47518__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47518__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47518__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47518__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47518__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4221__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (idx === (0));
} else {
return and__4221__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_47499 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_47498,inst_47492);
var inst_47500 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_47499);
var inst_47501 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_47500,inst_47499);
var inst_47502 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_47496,inst_47501);
var inst_47503 = fluree.db.index.__GT_IndexNode(block,t,inst_47493,inst_47502,config,leftmost_QMARK_);
var inst_47504 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_47503);
var _ = (function (){var statearr_47519 = state_47509;
(statearr_47519[(4)] = cljs.core.rest((state_47509[(4)])));

return statearr_47519;
})();
var state_47509__$1 = state_47509;
var statearr_47520_47543 = state_47509__$1;
(statearr_47520_47543[(2)] = inst_47504);

(statearr_47520_47543[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47510 === (2))){
var _ = (function (){var statearr_47521 = state_47509;
(statearr_47521[(4)] = cljs.core.cons((5),(state_47509[(4)])));

return statearr_47521;
})();
var inst_47470 = fluree.db.storage.core.read_branch(conn,key);
var state_47509__$1 = state_47509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47509__$1,(6),inst_47470);
} else {
if((state_val_47510 === (11))){
var state_47509__$1 = state_47509;
var statearr_47523_47544 = state_47509__$1;
(statearr_47523_47544[(2)] = null);

(statearr_47523_47544[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47510 === (9))){
var inst_47473 = (state_47509[(9)]);
var inst_47484 = (state_47509[(2)]);
var inst_47485 = fluree.db.util.core.exception_QMARK_(inst_47473);
var state_47509__$1 = (function (){var statearr_47524 = state_47509;
(statearr_47524[(10)] = inst_47484);

return statearr_47524;
})();
if(inst_47485){
var statearr_47525_47545 = state_47509__$1;
(statearr_47525_47545[(1)] = (10));

} else {
var statearr_47526_47546 = state_47509__$1;
(statearr_47526_47546[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47510 === (5))){
var _ = (function (){var statearr_47527 = state_47509;
(statearr_47527[(4)] = cljs.core.rest((state_47509[(4)])));

return statearr_47527;
})();
var state_47509__$1 = state_47509;
var ex47522 = (state_47509__$1[(2)]);
var statearr_47528_47547 = state_47509__$1;
(statearr_47528_47547[(5)] = ex47522);


var statearr_47529_47548 = state_47509__$1;
(statearr_47529_47548[(1)] = (4));

(statearr_47529_47548[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47510 === (10))){
var inst_47473 = (state_47509[(9)]);
var inst_47487 = (function(){throw inst_47473})();
var state_47509__$1 = state_47509;
var statearr_47530_47549 = state_47509__$1;
(statearr_47530_47549[(2)] = inst_47487);

(statearr_47530_47549[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47510 === (8))){
var state_47509__$1 = state_47509;
var statearr_47531_47550 = state_47509__$1;
(statearr_47531_47550[(2)] = null);

(statearr_47531_47550[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__20477__auto____0 = (function (){
var statearr_47532 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47532[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__20477__auto__);

(statearr_47532[(1)] = (1));

return statearr_47532;
});
var fluree$db$storage$core$reify_branch_$_state_machine__20477__auto____1 = (function (state_47509){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_47509);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e47533){var ex__20480__auto__ = e47533;
var statearr_47534_47551 = state_47509;
(statearr_47534_47551[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_47509[(4)]))){
var statearr_47535_47552 = state_47509;
(statearr_47535_47552[(1)] = cljs.core.first((state_47509[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__47553 = state_47509;
state_47509 = G__47553;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__20477__auto__ = function(state_47509){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__20477__auto____1.call(this,state_47509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__20477__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__20477__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_47536 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_47536[(6)] = c__20603__auto___47537);

return statearr_47536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_47574){
var state_val_47575 = (state_47574[(1)]);
if((state_val_47575 === (7))){
var state_47574__$1 = state_47574;
var statearr_47576_47596 = state_47574__$1;
(statearr_47576_47596[(2)] = null);

(statearr_47576_47596[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47575 === (1))){
var state_47574__$1 = state_47574;
var statearr_47577_47597 = state_47574__$1;
(statearr_47577_47597[(2)] = null);

(statearr_47577_47597[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47575 === (4))){
var inst_47554 = (state_47574[(2)]);
var state_47574__$1 = state_47574;
var statearr_47578_47598 = state_47574__$1;
(statearr_47578_47598[(2)] = inst_47554);

(statearr_47578_47598[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47575 === (6))){
var inst_47560 = (state_47574[(7)]);
var inst_47562 = fluree.db.storage.core.serde(conn);
var state_47574__$1 = (function (){var statearr_47579 = state_47574;
(statearr_47579[(8)] = inst_47562);

return statearr_47579;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47574__$1,(9),inst_47560);
} else {
if((state_val_47575 === (3))){
var inst_47572 = (state_47574[(2)]);
var state_47574__$1 = state_47574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47574__$1,inst_47572);
} else {
if((state_val_47575 === (2))){
var inst_47560 = (state_47574[(7)]);
var _ = (function (){var statearr_47581 = state_47574;
(statearr_47581[(4)] = cljs.core.cons((5),(state_47574[(4)])));

return statearr_47581;
})();
var inst_47560__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_47574__$1 = (function (){var statearr_47582 = state_47574;
(statearr_47582[(7)] = inst_47560__$1);

return statearr_47582;
})();
if(cljs.core.truth_(inst_47560__$1)){
var statearr_47583_47599 = state_47574__$1;
(statearr_47583_47599[(1)] = (6));

} else {
var statearr_47584_47600 = state_47574__$1;
(statearr_47584_47600[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47575 === (9))){
var inst_47562 = (state_47574[(8)]);
var inst_47564 = (state_47574[(2)]);
var inst_47565 = fluree.db.util.async.throw_err(inst_47564);
var inst_47566 = fluree.db.serde.protocol._deserialize_leaf(inst_47562,inst_47565);
var state_47574__$1 = state_47574;
var statearr_47585_47601 = state_47574__$1;
(statearr_47585_47601[(2)] = inst_47566);

(statearr_47585_47601[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47575 === (5))){
var _ = (function (){var statearr_47586 = state_47574;
(statearr_47586[(4)] = cljs.core.rest((state_47574[(4)])));

return statearr_47586;
})();
var state_47574__$1 = state_47574;
var ex47580 = (state_47574__$1[(2)]);
var statearr_47587_47602 = state_47574__$1;
(statearr_47587_47602[(5)] = ex47580);


if((ex47580 instanceof Error)){
var statearr_47588_47603 = state_47574__$1;
(statearr_47588_47603[(1)] = (4));

(statearr_47588_47603[(5)] = null);

} else {
throw ex47580;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47575 === (8))){
var inst_47569 = (state_47574[(2)]);
var _ = (function (){var statearr_47589 = state_47574;
(statearr_47589[(4)] = cljs.core.rest((state_47574[(4)])));

return statearr_47589;
})();
var state_47574__$1 = state_47574;
var statearr_47590_47604 = state_47574__$1;
(statearr_47590_47604[(2)] = inst_47569);

(statearr_47590_47604[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__20477__auto____0 = (function (){
var statearr_47591 = [null,null,null,null,null,null,null,null,null];
(statearr_47591[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__20477__auto__);

(statearr_47591[(1)] = (1));

return statearr_47591;
});
var fluree$db$storage$core$read_leaf_$_state_machine__20477__auto____1 = (function (state_47574){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_47574);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e47592){var ex__20480__auto__ = e47592;
var statearr_47593_47605 = state_47574;
(statearr_47593_47605[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_47574[(4)]))){
var statearr_47594_47606 = state_47574;
(statearr_47594_47606[(1)] = cljs.core.first((state_47574[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__47607 = state_47574;
state_47574 = G__47607;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__20477__auto__ = function(state_47574){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__20477__auto____1.call(this,state_47574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__20477__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__20477__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_47595 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_47595[(6)] = c__20603__auto__);

return statearr_47595;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__20603__auto___47680 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_47652){
var state_val_47653 = (state_47652[(1)]);
if((state_val_47653 === (7))){
var inst_47624 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_47625 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47626 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_47627 = cljs.core.PersistentHashMap.fromArrays(inst_47625,inst_47626);
var inst_47628 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47624,inst_47627);
var inst_47629 = (function(){throw inst_47628})();
var state_47652__$1 = state_47652;
var statearr_47654_47681 = state_47652__$1;
(statearr_47654_47681[(2)] = inst_47629);

(statearr_47654_47681[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47653 === (1))){
var state_47652__$1 = state_47652;
var statearr_47655_47682 = state_47652__$1;
(statearr_47655_47682[(2)] = null);

(statearr_47655_47682[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47653 === (4))){
var inst_47608 = (state_47652[(2)]);
var inst_47609 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_47610 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_47608);
var inst_47611 = cljs.core.async.close_BANG_(return_ch);
var state_47652__$1 = (function (){var statearr_47656 = state_47652;
(statearr_47656[(7)] = inst_47609);

(statearr_47656[(8)] = inst_47610);

return statearr_47656;
})();
var statearr_47657_47683 = state_47652__$1;
(statearr_47657_47683[(2)] = inst_47611);

(statearr_47657_47683[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47653 === (6))){
var inst_47621 = (state_47652[(9)]);
var inst_47621__$1 = (state_47652[(2)]);
var inst_47622 = (inst_47621__$1 == null);
var state_47652__$1 = (function (){var statearr_47658 = state_47652;
(statearr_47658[(9)] = inst_47621__$1);

return statearr_47658;
})();
if(cljs.core.truth_(inst_47622)){
var statearr_47659_47684 = state_47652__$1;
(statearr_47659_47684[(1)] = (7));

} else {
var statearr_47660_47685 = state_47652__$1;
(statearr_47660_47685[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47653 === (3))){
var inst_47650 = (state_47652[(2)]);
var state_47652__$1 = state_47652;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47652__$1,inst_47650);
} else {
if((state_val_47653 === (12))){
var inst_47621 = (state_47652[(9)]);
var inst_47638 = (state_47652[(2)]);
var inst_47639 = cljs.core.__destructure_map(inst_47621);
var inst_47640 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47639,cljs.core.cst$kw$flakes);
var inst_47641 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47639,cljs.core.cst$kw$his);
var inst_47642 = config;
var inst_47643 = cljs.core.__destructure_map(inst_47642);
var inst_47644 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_47643,cljs.core.cst$kw$comparator);
var inst_47645 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_47644,inst_47640);
var inst_47646 = fluree.db.index.data_node(block,t,inst_47645,rhs,config);
var inst_47647 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_47646);
var _ = (function (){var statearr_47661 = state_47652;
(statearr_47661[(4)] = cljs.core.rest((state_47652[(4)])));

return statearr_47661;
})();
var state_47652__$1 = (function (){var statearr_47662 = state_47652;
(statearr_47662[(10)] = inst_47641);

(statearr_47662[(11)] = inst_47638);

return statearr_47662;
})();
var statearr_47663_47686 = state_47652__$1;
(statearr_47663_47686[(2)] = inst_47647);

(statearr_47663_47686[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47653 === (2))){
var _ = (function (){var statearr_47664 = state_47652;
(statearr_47664[(4)] = cljs.core.cons((5),(state_47652[(4)])));

return statearr_47664;
})();
var inst_47619 = fluree.db.storage.core.read_leaf(conn,key);
var state_47652__$1 = state_47652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47652__$1,(6),inst_47619);
} else {
if((state_val_47653 === (11))){
var state_47652__$1 = state_47652;
var statearr_47666_47687 = state_47652__$1;
(statearr_47666_47687[(2)] = null);

(statearr_47666_47687[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47653 === (9))){
var inst_47621 = (state_47652[(9)]);
var inst_47632 = (state_47652[(2)]);
var inst_47633 = fluree.db.util.core.exception_QMARK_(inst_47621);
var state_47652__$1 = (function (){var statearr_47667 = state_47652;
(statearr_47667[(12)] = inst_47632);

return statearr_47667;
})();
if(inst_47633){
var statearr_47668_47688 = state_47652__$1;
(statearr_47668_47688[(1)] = (10));

} else {
var statearr_47669_47689 = state_47652__$1;
(statearr_47669_47689[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47653 === (5))){
var _ = (function (){var statearr_47670 = state_47652;
(statearr_47670[(4)] = cljs.core.rest((state_47652[(4)])));

return statearr_47670;
})();
var state_47652__$1 = state_47652;
var ex47665 = (state_47652__$1[(2)]);
var statearr_47671_47690 = state_47652__$1;
(statearr_47671_47690[(5)] = ex47665);


var statearr_47672_47691 = state_47652__$1;
(statearr_47672_47691[(1)] = (4));

(statearr_47672_47691[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_47653 === (10))){
var inst_47621 = (state_47652[(9)]);
var inst_47635 = (function(){throw inst_47621})();
var state_47652__$1 = state_47652;
var statearr_47673_47692 = state_47652__$1;
(statearr_47673_47692[(2)] = inst_47635);

(statearr_47673_47692[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47653 === (8))){
var state_47652__$1 = state_47652;
var statearr_47674_47693 = state_47652__$1;
(statearr_47674_47693[(2)] = null);

(statearr_47674_47693[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__20477__auto____0 = (function (){
var statearr_47675 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47675[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__20477__auto__);

(statearr_47675[(1)] = (1));

return statearr_47675;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__20477__auto____1 = (function (state_47652){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_47652);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e47676){var ex__20480__auto__ = e47676;
var statearr_47677_47694 = state_47652;
(statearr_47677_47694[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_47652[(4)]))){
var statearr_47678_47695 = state_47652;
(statearr_47678_47695[(1)] = cljs.core.first((state_47652[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__47696 = state_47652;
state_47652 = G__47696;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__20477__auto__ = function(state_47652){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__20477__auto____1.call(this,state_47652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__20477__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__20477__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_47679 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_47679[(6)] = c__20603__auto___47680);

return statearr_47679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k47698,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__47702 = k47698;
var G__47702__$1 = (((G__47702 instanceof cljs.core.Keyword))?G__47702.fqn:null);
switch (G__47702__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k47698,else__4475__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__47703){
var vec__47704 = p__47703;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47704,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47704,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47697){
var self__ = this;
var G__47697__$1 = this;
return (new cljs.core.RecordIter((0),G__47697__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__47707 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__47708 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__47709 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__47710 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__47709,G__47710) : object_cache.call(null,G__47709,G__47710));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__47711 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__47712 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__47711,G__47712) : object_cache.call(null,G__47711,G__47712));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__47707,G__47708) : object_cache.call(null,G__47707,G__47708));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__47713 = history_id;
var G__47714 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__47713,G__47714) : object_cache.call(null,G__47713,G__47714));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__47715 = (function (coll__4469__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__47715(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47699,other47700){
var self__ = this;
var this47699__$1 = this;
return (((!((other47700 == null)))) && ((((this47699__$1.constructor === other47700.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.conn,other47700.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.config,other47700.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.network,other47700.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.dbid,other47700.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.id,other47700.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.leaf,other47700.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.first,other47700.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.rhs,other47700.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.size,other47700.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.block,other47700.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.t,other47700.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.tt_id,other47700.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.leftmost_QMARK_,other47700.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.tempid,other47700.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47699__$1.__extmap,other47700.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k47698){
var self__ = this;
var this__4479__auto____$1 = this;
var G__47716 = k47698;
var G__47716__$1 = (((G__47716 instanceof cljs.core.Keyword))?G__47716.fqn:null);
switch (G__47716__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k47698);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__47697){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__47717 = cljs.core.keyword_identical_QMARK_;
var expr__47718 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__47720 = cljs.core.cst$kw$conn;
var G__47721 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47720,G__47721) : pred__47717.call(null,G__47720,G__47721));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__47697,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47722 = cljs.core.cst$kw$config;
var G__47723 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47722,G__47723) : pred__47717.call(null,G__47722,G__47723));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__47697,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47724 = cljs.core.cst$kw$network;
var G__47725 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47724,G__47725) : pred__47717.call(null,G__47724,G__47725));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__47697,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47726 = cljs.core.cst$kw$dbid;
var G__47727 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47726,G__47727) : pred__47717.call(null,G__47726,G__47727));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__47697,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47728 = cljs.core.cst$kw$id;
var G__47729 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47728,G__47729) : pred__47717.call(null,G__47728,G__47729));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__47697,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47730 = cljs.core.cst$kw$leaf;
var G__47731 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47730,G__47731) : pred__47717.call(null,G__47730,G__47731));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__47697,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47732 = cljs.core.cst$kw$first;
var G__47733 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47732,G__47733) : pred__47717.call(null,G__47732,G__47733));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__47697,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47734 = cljs.core.cst$kw$rhs;
var G__47735 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47734,G__47735) : pred__47717.call(null,G__47734,G__47735));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__47697,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47736 = cljs.core.cst$kw$size;
var G__47737 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47736,G__47737) : pred__47717.call(null,G__47736,G__47737));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__47697,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47738 = cljs.core.cst$kw$block;
var G__47739 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47738,G__47739) : pred__47717.call(null,G__47738,G__47739));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__47697,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47740 = cljs.core.cst$kw$t;
var G__47741 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47740,G__47741) : pred__47717.call(null,G__47740,G__47741));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__47697,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47742 = cljs.core.cst$kw$tt_DASH_id;
var G__47743 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47742,G__47743) : pred__47717.call(null,G__47742,G__47743));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__47697,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47744 = cljs.core.cst$kw$leftmost_QMARK_;
var G__47745 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47744,G__47745) : pred__47717.call(null,G__47744,G__47745));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__47697,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__47746 = cljs.core.cst$kw$tempid;
var G__47747 = expr__47718;
return (pred__47717.cljs$core$IFn$_invoke$arity$2 ? pred__47717.cljs$core$IFn$_invoke$arity$2(G__47746,G__47747) : pred__47717.call(null,G__47746,G__47747));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__47697,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__47697),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__47697){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__47697,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__47701){
var extmap__4512__auto__ = (function (){var G__47748 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__47701,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__47701)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__47748);
} else {
return G__47748;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__47701),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__47701),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__47751 = blank_db;
var map__47751__$1 = cljs.core.__destructure_map(map__47751);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47751__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47751__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47751__$1,cljs.core.cst$kw$index_DASH_configs);
var map__47752 = root_data;
var map__47752__$1 = cljs.core.__destructure_map(map__47752);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47752__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47752__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47752__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__47752__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_47774){
var state_val_47775 = (state_47774[(1)]);
if((state_val_47775 === (7))){
var state_47774__$1 = state_47774;
var statearr_47776_47796 = state_47774__$1;
(statearr_47776_47796[(2)] = null);

(statearr_47776_47796[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47775 === (1))){
var state_47774__$1 = state_47774;
var statearr_47777_47797 = state_47774__$1;
(statearr_47777_47797[(2)] = null);

(statearr_47777_47797[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47775 === (4))){
var inst_47753 = (state_47774[(2)]);
var state_47774__$1 = state_47774;
var statearr_47778_47798 = state_47774__$1;
(statearr_47778_47798[(2)] = inst_47753);

(statearr_47778_47798[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47775 === (6))){
var inst_47760 = (state_47774[(7)]);
var inst_47762 = fluree.db.storage.core.serde(conn);
var state_47774__$1 = (function (){var statearr_47779 = state_47774;
(statearr_47779[(8)] = inst_47762);

return statearr_47779;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47774__$1,(9),inst_47760);
} else {
if((state_val_47775 === (3))){
var inst_47772 = (state_47774[(2)]);
var state_47774__$1 = state_47774;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47774__$1,inst_47772);
} else {
if((state_val_47775 === (2))){
var inst_47760 = (state_47774[(7)]);
var _ = (function (){var statearr_47781 = state_47774;
(statearr_47781[(4)] = cljs.core.cons((5),(state_47774[(4)])));

return statearr_47781;
})();
var inst_47759 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_47760__$1 = fluree.db.storage.core.storage_read(conn,inst_47759);
var state_47774__$1 = (function (){var statearr_47782 = state_47774;
(statearr_47782[(7)] = inst_47760__$1);

return statearr_47782;
})();
if(cljs.core.truth_(inst_47760__$1)){
var statearr_47783_47799 = state_47774__$1;
(statearr_47783_47799[(1)] = (6));

} else {
var statearr_47784_47800 = state_47774__$1;
(statearr_47784_47800[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47775 === (9))){
var inst_47762 = (state_47774[(8)]);
var inst_47764 = (state_47774[(2)]);
var inst_47765 = fluree.db.util.async.throw_err(inst_47764);
var inst_47766 = fluree.db.serde.protocol._deserialize_garbage(inst_47762,inst_47765);
var state_47774__$1 = state_47774;
var statearr_47785_47801 = state_47774__$1;
(statearr_47785_47801[(2)] = inst_47766);

(statearr_47785_47801[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47775 === (5))){
var _ = (function (){var statearr_47786 = state_47774;
(statearr_47786[(4)] = cljs.core.rest((state_47774[(4)])));

return statearr_47786;
})();
var state_47774__$1 = state_47774;
var ex47780 = (state_47774__$1[(2)]);
var statearr_47787_47802 = state_47774__$1;
(statearr_47787_47802[(5)] = ex47780);


if((ex47780 instanceof Error)){
var statearr_47788_47803 = state_47774__$1;
(statearr_47788_47803[(1)] = (4));

(statearr_47788_47803[(5)] = null);

} else {
throw ex47780;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47775 === (8))){
var inst_47769 = (state_47774[(2)]);
var _ = (function (){var statearr_47789 = state_47774;
(statearr_47789[(4)] = cljs.core.rest((state_47774[(4)])));

return statearr_47789;
})();
var state_47774__$1 = state_47774;
var statearr_47790_47804 = state_47774__$1;
(statearr_47790_47804[(2)] = inst_47769);

(statearr_47790_47804[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__20477__auto____0 = (function (){
var statearr_47791 = [null,null,null,null,null,null,null,null,null];
(statearr_47791[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__20477__auto__);

(statearr_47791[(1)] = (1));

return statearr_47791;
});
var fluree$db$storage$core$read_garbage_$_state_machine__20477__auto____1 = (function (state_47774){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_47774);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e47792){var ex__20480__auto__ = e47792;
var statearr_47793_47805 = state_47774;
(statearr_47793_47805[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_47774[(4)]))){
var statearr_47794_47806 = state_47774;
(statearr_47794_47806[(1)] = cljs.core.first((state_47774[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__47807 = state_47774;
state_47774 = G__47807;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__20477__auto__ = function(state_47774){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__20477__auto____1.call(this,state_47774);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__20477__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__20477__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_47795 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_47795[(6)] = c__20603__auto__);

return statearr_47795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_47829){
var state_val_47830 = (state_47829[(1)]);
if((state_val_47830 === (7))){
var state_47829__$1 = state_47829;
var statearr_47831_47851 = state_47829__$1;
(statearr_47831_47851[(2)] = null);

(statearr_47831_47851[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47830 === (1))){
var state_47829__$1 = state_47829;
var statearr_47832_47852 = state_47829__$1;
(statearr_47832_47852[(2)] = null);

(statearr_47832_47852[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47830 === (4))){
var inst_47808 = (state_47829[(2)]);
var state_47829__$1 = state_47829;
var statearr_47833_47853 = state_47829__$1;
(statearr_47833_47853[(2)] = inst_47808);

(statearr_47833_47853[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47830 === (6))){
var inst_47815 = (state_47829[(7)]);
var inst_47817 = fluree.db.storage.core.serde(conn);
var state_47829__$1 = (function (){var statearr_47834 = state_47829;
(statearr_47834[(8)] = inst_47817);

return statearr_47834;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47829__$1,(9),inst_47815);
} else {
if((state_val_47830 === (3))){
var inst_47827 = (state_47829[(2)]);
var state_47829__$1 = state_47829;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47829__$1,inst_47827);
} else {
if((state_val_47830 === (2))){
var inst_47815 = (state_47829[(7)]);
var _ = (function (){var statearr_47836 = state_47829;
(statearr_47836[(4)] = cljs.core.cons((5),(state_47829[(4)])));

return statearr_47836;
})();
var inst_47814 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_47815__$1 = fluree.db.storage.core.storage_read(conn,inst_47814);
var state_47829__$1 = (function (){var statearr_47837 = state_47829;
(statearr_47837[(7)] = inst_47815__$1);

return statearr_47837;
})();
if(cljs.core.truth_(inst_47815__$1)){
var statearr_47838_47854 = state_47829__$1;
(statearr_47838_47854[(1)] = (6));

} else {
var statearr_47839_47855 = state_47829__$1;
(statearr_47839_47855[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47830 === (9))){
var inst_47817 = (state_47829[(8)]);
var inst_47819 = (state_47829[(2)]);
var inst_47820 = fluree.db.util.async.throw_err(inst_47819);
var inst_47821 = fluree.db.serde.protocol._deserialize_db_root(inst_47817,inst_47820);
var state_47829__$1 = state_47829;
var statearr_47840_47856 = state_47829__$1;
(statearr_47840_47856[(2)] = inst_47821);

(statearr_47840_47856[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47830 === (5))){
var _ = (function (){var statearr_47841 = state_47829;
(statearr_47841[(4)] = cljs.core.rest((state_47829[(4)])));

return statearr_47841;
})();
var state_47829__$1 = state_47829;
var ex47835 = (state_47829__$1[(2)]);
var statearr_47842_47857 = state_47829__$1;
(statearr_47842_47857[(5)] = ex47835);


if((ex47835 instanceof Error)){
var statearr_47843_47858 = state_47829__$1;
(statearr_47843_47858[(1)] = (4));

(statearr_47843_47858[(5)] = null);

} else {
throw ex47835;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47830 === (8))){
var inst_47824 = (state_47829[(2)]);
var _ = (function (){var statearr_47844 = state_47829;
(statearr_47844[(4)] = cljs.core.rest((state_47829[(4)])));

return statearr_47844;
})();
var state_47829__$1 = state_47829;
var statearr_47845_47859 = state_47829__$1;
(statearr_47845_47859[(2)] = inst_47824);

(statearr_47845_47859[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__20477__auto____0 = (function (){
var statearr_47846 = [null,null,null,null,null,null,null,null,null];
(statearr_47846[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__20477__auto__);

(statearr_47846[(1)] = (1));

return statearr_47846;
});
var fluree$db$storage$core$read_db_root_$_state_machine__20477__auto____1 = (function (state_47829){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_47829);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e47847){var ex__20480__auto__ = e47847;
var statearr_47848_47860 = state_47829;
(statearr_47848_47860[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_47829[(4)]))){
var statearr_47849_47861 = state_47829;
(statearr_47849_47861[(1)] = cljs.core.first((state_47829[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__47862 = state_47829;
state_47829 = G__47862;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__20477__auto__ = function(state_47829){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__20477__auto____1.call(this,state_47829);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__20477__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__20477__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_47850 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_47850[(6)] = c__20603__auto__);

return statearr_47850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_47898){
var state_val_47899 = (state_47898[(1)]);
if((state_val_47899 === (7))){
var inst_47872 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_47873 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_47874 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_47875 = cljs.core.PersistentHashMap.fromArrays(inst_47873,inst_47874);
var inst_47876 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_47872,inst_47875);
var inst_47877 = (function(){throw inst_47876})();
var state_47898__$1 = state_47898;
var statearr_47900_47922 = state_47898__$1;
(statearr_47900_47922[(2)] = inst_47877);

(statearr_47900_47922[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47899 === (1))){
var state_47898__$1 = state_47898;
var statearr_47901_47923 = state_47898__$1;
(statearr_47901_47923[(2)] = null);

(statearr_47901_47923[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47899 === (4))){
var inst_47863 = (state_47898[(2)]);
var state_47898__$1 = state_47898;
var statearr_47902_47924 = state_47898__$1;
(statearr_47902_47924[(2)] = inst_47863);

(statearr_47902_47924[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47899 === (6))){
var state_47898__$1 = state_47898;
var statearr_47903_47925 = state_47898__$1;
(statearr_47903_47925[(2)] = null);

(statearr_47903_47925[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47899 === (3))){
var inst_47896 = (state_47898[(2)]);
var state_47898__$1 = state_47898;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47898__$1,inst_47896);
} else {
if((state_val_47899 === (2))){
var inst_47869 = (state_47898[(7)]);
var _ = (function (){var statearr_47904 = state_47898;
(statearr_47904[(4)] = cljs.core.cons((5),(state_47898[(4)])));

return statearr_47904;
})();
var inst_47869__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_47898__$1 = (function (){var statearr_47905 = state_47898;
(statearr_47905[(7)] = inst_47869__$1);

return statearr_47905;
})();
if(cljs.core.truth_(inst_47869__$1)){
var statearr_47906_47926 = state_47898__$1;
(statearr_47906_47926[(1)] = (6));

} else {
var statearr_47907_47927 = state_47898__$1;
(statearr_47907_47927[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47899 === (11))){
var inst_47888 = (state_47898[(8)]);
var inst_47891 = (state_47898[(2)]);
var inst_47892 = fluree.db.util.async.throw_err(inst_47891);
var inst_47893 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_47888,cljs.core.cst$kw$settings,inst_47892);
var _ = (function (){var statearr_47909 = state_47898;
(statearr_47909[(4)] = cljs.core.rest((state_47898[(4)])));

return statearr_47909;
})();
var state_47898__$1 = state_47898;
var statearr_47910_47928 = state_47898__$1;
(statearr_47910_47928[(2)] = inst_47893);

(statearr_47910_47928[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47899 === (9))){
var inst_47883 = (state_47898[(9)]);
var inst_47881 = (state_47898[(2)]);
var inst_47882 = fluree.db.util.async.throw_err(inst_47881);
var inst_47883__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_47882);
var inst_47884 = fluree.db.query.schema.schema_map(inst_47883__$1);
var state_47898__$1 = (function (){var statearr_47911 = state_47898;
(statearr_47911[(9)] = inst_47883__$1);

return statearr_47911;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47898__$1,(10),inst_47884);
} else {
if((state_val_47899 === (5))){
var _ = (function (){var statearr_47912 = state_47898;
(statearr_47912[(4)] = cljs.core.rest((state_47898[(4)])));

return statearr_47912;
})();
var state_47898__$1 = state_47898;
var ex47908 = (state_47898__$1[(2)]);
var statearr_47913_47929 = state_47898__$1;
(statearr_47913_47929[(5)] = ex47908);


if((ex47908 instanceof Error)){
var statearr_47914_47930 = state_47898__$1;
(statearr_47914_47930[(1)] = (4));

(statearr_47914_47930[(5)] = null);

} else {
throw ex47908;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47899 === (10))){
var inst_47888 = (state_47898[(8)]);
var inst_47883 = (state_47898[(9)]);
var inst_47886 = (state_47898[(2)]);
var inst_47887 = fluree.db.util.async.throw_err(inst_47886);
var inst_47888__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_47883,cljs.core.cst$kw$schema,inst_47887);
var inst_47889 = fluree.db.query.schema.setting_map(inst_47888__$1);
var state_47898__$1 = (function (){var statearr_47915 = state_47898;
(statearr_47915[(8)] = inst_47888__$1);

return statearr_47915;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47898__$1,(11),inst_47889);
} else {
if((state_val_47899 === (8))){
var inst_47869 = (state_47898[(7)]);
var inst_47879 = (state_47898[(2)]);
var state_47898__$1 = (function (){var statearr_47916 = state_47898;
(statearr_47916[(10)] = inst_47879);

return statearr_47916;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47898__$1,(9),inst_47869);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__20477__auto____0 = (function (){
var statearr_47917 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_47917[(0)] = fluree$db$storage$core$reify_db_$_state_machine__20477__auto__);

(statearr_47917[(1)] = (1));

return statearr_47917;
});
var fluree$db$storage$core$reify_db_$_state_machine__20477__auto____1 = (function (state_47898){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_47898);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e47918){var ex__20480__auto__ = e47918;
var statearr_47919_47931 = state_47898;
(statearr_47919_47931[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_47898[(4)]))){
var statearr_47920_47932 = state_47898;
(statearr_47920_47932[(1)] = cljs.core.first((state_47898[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__47933 = state_47898;
state_47898 = G__47933;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__20477__auto__ = function(state_47898){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__20477__auto____1.call(this,state_47898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__20477__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__20477__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_47921 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_47921[(6)] = c__20603__auto__);

return statearr_47921;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__47935 = arguments.length;
switch (G__47935) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_47988){
var state_val_47989 = (state_47988[(1)]);
if((state_val_47989 === (7))){
var inst_47945 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_47946 = (new Error(inst_47945));
var inst_47947 = (function(){throw inst_47946})();
var state_47988__$1 = state_47988;
var statearr_47990_48030 = state_47988__$1;
(statearr_47990_48030[(2)] = inst_47947);

(statearr_47990_48030[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (20))){
var inst_47979 = (state_47988[(2)]);
var state_47988__$1 = state_47988;
var statearr_47991_48031 = state_47988__$1;
(statearr_47991_48031[(2)] = inst_47979);

(statearr_47991_48031[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (1))){
var state_47988__$1 = state_47988;
var statearr_47992_48032 = state_47988__$1;
(statearr_47992_48032[(2)] = null);

(statearr_47992_48032[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (4))){
var inst_47936 = (state_47988[(2)]);
var state_47988__$1 = state_47988;
var statearr_47993_48033 = state_47988__$1;
(statearr_47993_48033[(2)] = inst_47936);

(statearr_47993_48033[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (15))){
var inst_47954 = (state_47988[(7)]);
var state_47988__$1 = state_47988;
var statearr_47994_48034 = state_47988__$1;
(statearr_47994_48034[(2)] = inst_47954);

(statearr_47994_48034[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (21))){
var inst_47958 = (state_47988[(8)]);
var inst_47954 = (state_47988[(7)]);
var inst_47953 = (state_47988[(9)]);
var inst_47972 = (inst_47953 + (1));
var inst_47973 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_47954,inst_47958);
var inst_47953__$1 = inst_47972;
var inst_47954__$1 = inst_47973;
var state_47988__$1 = (function (){var statearr_47995 = state_47988;
(statearr_47995[(7)] = inst_47954__$1);

(statearr_47995[(9)] = inst_47953__$1);

return statearr_47995;
})();
var statearr_47996_48035 = state_47988__$1;
(statearr_47996_48035[(2)] = null);

(statearr_47996_48035[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (13))){
var inst_47958 = (state_47988[(8)]);
var inst_47962 = (inst_47958 instanceof Error);
var state_47988__$1 = state_47988;
var statearr_47997_48036 = state_47988__$1;
(statearr_47997_48036[(2)] = inst_47962);

(statearr_47997_48036[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (22))){
var state_47988__$1 = state_47988;
var statearr_47998_48037 = state_47988__$1;
(statearr_47998_48037[(2)] = null);

(statearr_47998_48037[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (6))){
var state_47988__$1 = state_47988;
var statearr_47999_48038 = state_47988__$1;
(statearr_47999_48038[(2)] = null);

(statearr_47999_48038[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (17))){
var inst_47981 = (state_47988[(2)]);
var state_47988__$1 = state_47988;
var statearr_48000_48039 = state_47988__$1;
(statearr_48000_48039[(2)] = inst_47981);

(statearr_48000_48039[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (3))){
var inst_47986 = (state_47988[(2)]);
var state_47988__$1 = state_47988;
return cljs.core.async.impl.ioc_helpers.return_chan(state_47988__$1,inst_47986);
} else {
if((state_val_47989 === (12))){
var inst_47959 = (state_47988[(10)]);
var state_47988__$1 = state_47988;
var statearr_48001_48040 = state_47988__$1;
(statearr_48001_48040[(2)] = inst_47959);

(statearr_48001_48040[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (2))){
var _ = (function (){var statearr_48002 = state_47988;
(statearr_48002[(4)] = cljs.core.cons((5),(state_47988[(4)])));

return statearr_48002;
})();
var inst_47942 = (end >= start);
var state_47988__$1 = state_47988;
if(cljs.core.truth_(inst_47942)){
var statearr_48003_48041 = state_47988__$1;
(statearr_48003_48041[(1)] = (6));

} else {
var statearr_48004_48042 = state_47988__$1;
(statearr_48004_48042[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (23))){
var inst_47977 = (state_47988[(2)]);
var state_47988__$1 = state_47988;
var statearr_48005_48043 = state_47988__$1;
(statearr_48005_48043[(2)] = inst_47977);

(statearr_48005_48043[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (19))){
var state_47988__$1 = state_47988;
var statearr_48006_48044 = state_47988__$1;
(statearr_48006_48044[(1)] = (21));



return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (11))){
var inst_47958 = (state_47988[(8)]);
var inst_47959 = (state_47988[(10)]);
var inst_47958__$1 = (state_47988[(2)]);
var inst_47959__$1 = (inst_47958__$1 == null);
var state_47988__$1 = (function (){var statearr_48009 = state_47988;
(statearr_48009[(8)] = inst_47958__$1);

(statearr_48009[(10)] = inst_47959__$1);

return statearr_48009;
})();
if(cljs.core.truth_(inst_47959__$1)){
var statearr_48010_48045 = state_47988__$1;
(statearr_48010_48045[(1)] = (12));

} else {
var statearr_48011_48046 = state_47988__$1;
(statearr_48011_48046[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (9))){
var inst_47953 = (state_47988[(9)]);
var inst_47956 = fluree.db.storage.core.read_block(conn,network,dbid,inst_47953);
var state_47988__$1 = state_47988;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47988__$1,(11),inst_47956);
} else {
if((state_val_47989 === (5))){
var _ = (function (){var statearr_48012 = state_47988;
(statearr_48012[(4)] = cljs.core.rest((state_47988[(4)])));

return statearr_48012;
})();
var state_47988__$1 = state_47988;
var ex48008 = (state_47988__$1[(2)]);
var statearr_48013_48047 = state_47988__$1;
(statearr_48013_48047[(5)] = ex48008);


if((ex48008 instanceof Error)){
var statearr_48014_48048 = state_47988__$1;
(statearr_48014_48048[(1)] = (4));

(statearr_48014_48048[(5)] = null);

} else {
throw ex48008;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (14))){
var inst_47964 = (state_47988[(2)]);
var state_47988__$1 = state_47988;
if(cljs.core.truth_(inst_47964)){
var statearr_48015_48049 = state_47988__$1;
(statearr_48015_48049[(1)] = (15));

} else {
var statearr_48016_48050 = state_47988__$1;
(statearr_48016_48050[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (16))){
var inst_47953 = (state_47988[(9)]);
var inst_47967 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_47953,end);
var state_47988__$1 = state_47988;
if(inst_47967){
var statearr_48017_48051 = state_47988__$1;
(statearr_48017_48051[(1)] = (18));

} else {
var statearr_48018_48052 = state_47988__$1;
(statearr_48018_48052[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (10))){
var inst_47983 = (state_47988[(2)]);
var _ = (function (){var statearr_48019 = state_47988;
(statearr_48019[(4)] = cljs.core.rest((state_47988[(4)])));

return statearr_48019;
})();
var state_47988__$1 = state_47988;
var statearr_48020_48053 = state_47988__$1;
(statearr_48020_48053[(2)] = inst_47983);

(statearr_48020_48053[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (18))){
var inst_47958 = (state_47988[(8)]);
var inst_47954 = (state_47988[(7)]);
var inst_47969 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_47954,inst_47958);
var state_47988__$1 = state_47988;
var statearr_48021_48054 = state_47988__$1;
(statearr_48021_48054[(2)] = inst_47969);

(statearr_48021_48054[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_47989 === (8))){
var inst_47949 = (state_47988[(2)]);
var inst_47950 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_47951 = start;
var inst_47952 = cljs.core.PersistentVector.EMPTY;
var inst_47953 = inst_47951;
var inst_47954 = inst_47952;
var state_47988__$1 = (function (){var statearr_48022 = state_47988;
(statearr_48022[(7)] = inst_47954);

(statearr_48022[(11)] = inst_47950);

(statearr_48022[(9)] = inst_47953);

(statearr_48022[(12)] = inst_47949);

return statearr_48022;
})();
var statearr_48023_48055 = state_47988__$1;
(statearr_48023_48055[(2)] = null);

(statearr_48023_48055[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__20477__auto__ = null;
var fluree$db$storage$core$state_machine__20477__auto____0 = (function (){
var statearr_48024 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48024[(0)] = fluree$db$storage$core$state_machine__20477__auto__);

(statearr_48024[(1)] = (1));

return statearr_48024;
});
var fluree$db$storage$core$state_machine__20477__auto____1 = (function (state_47988){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_47988);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e48025){var ex__20480__auto__ = e48025;
var statearr_48026_48056 = state_47988;
(statearr_48026_48056[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_47988[(4)]))){
var statearr_48027_48057 = state_47988;
(statearr_48027_48057[(1)] = cljs.core.first((state_47988[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__48058 = state_47988;
state_47988 = G__48058;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__20477__auto__ = function(state_47988){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__20477__auto____1.call(this,state_47988);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__20477__auto____0;
fluree$db$storage$core$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__20477__auto____1;
return fluree$db$storage$core$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_48028 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_48028[(6)] = c__20603__auto__);

return statearr_48028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_48074){
var state_val_48075 = (state_48074[(1)]);
if((state_val_48075 === (1))){
var state_48074__$1 = state_48074;
var statearr_48076_48090 = state_48074__$1;
(statearr_48076_48090[(2)] = null);

(statearr_48076_48090[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48075 === (2))){
var _ = (function (){var statearr_48077 = state_48074;
(statearr_48077[(4)] = cljs.core.cons((5),(state_48074[(4)])));

return statearr_48077;
})();
var inst_48065 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_48074__$1 = state_48074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48074__$1,(6),inst_48065);
} else {
if((state_val_48075 === (3))){
var inst_48072 = (state_48074[(2)]);
var state_48074__$1 = state_48074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48074__$1,inst_48072);
} else {
if((state_val_48075 === (4))){
var inst_48059 = (state_48074[(2)]);
var state_48074__$1 = state_48074;
var statearr_48079_48091 = state_48074__$1;
(statearr_48079_48091[(2)] = inst_48059);

(statearr_48079_48091[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48075 === (5))){
var _ = (function (){var statearr_48080 = state_48074;
(statearr_48080[(4)] = cljs.core.rest((state_48074[(4)])));

return statearr_48080;
})();
var state_48074__$1 = state_48074;
var ex48078 = (state_48074__$1[(2)]);
var statearr_48081_48092 = state_48074__$1;
(statearr_48081_48092[(5)] = ex48078);


if((ex48078 instanceof Error)){
var statearr_48082_48093 = state_48074__$1;
(statearr_48082_48093[(1)] = (4));

(statearr_48082_48093[(5)] = null);

} else {
throw ex48078;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48075 === (6))){
var inst_48067 = (state_48074[(2)]);
var inst_48068 = fluree.db.util.async.throw_err(inst_48067);
var inst_48069 = cljs.core.first(inst_48068);
var _ = (function (){var statearr_48083 = state_48074;
(statearr_48083[(4)] = cljs.core.rest((state_48074[(4)])));

return statearr_48083;
})();
var state_48074__$1 = state_48074;
var statearr_48084_48094 = state_48074__$1;
(statearr_48084_48094[(2)] = inst_48069);

(statearr_48084_48094[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__20477__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__20477__auto____0 = (function (){
var statearr_48085 = [null,null,null,null,null,null,null];
(statearr_48085[(0)] = fluree$db$storage$core$block_$_state_machine__20477__auto__);

(statearr_48085[(1)] = (1));

return statearr_48085;
});
var fluree$db$storage$core$block_$_state_machine__20477__auto____1 = (function (state_48074){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_48074);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e48086){var ex__20480__auto__ = e48086;
var statearr_48087_48095 = state_48074;
(statearr_48087_48095[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_48074[(4)]))){
var statearr_48088_48096 = state_48074;
(statearr_48088_48096[(1)] = cljs.core.first((state_48074[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__48097 = state_48074;
state_48074 = G__48097;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__20477__auto__ = function(state_48074){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__20477__auto____1.call(this,state_48074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__20477__auto____0;
fluree$db$storage$core$block_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__20477__auto____1;
return fluree$db$storage$core$block_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_48089 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_48089[(6)] = c__20603__auto__);

return statearr_48089;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
