// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k50014,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__50018 = k50014;
var G__50018__$1 = (((G__50018 instanceof cljs.core.Keyword))?G__50018.fqn:null);
switch (G__50018__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k50014,else__4475__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__50019){
var vec__50020 = p__50019;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50020,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50020,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__50013){
var self__ = this;
var G__50013__$1 = this;
return (new cljs.core.RecordIter((0),G__50013__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__50023 = (function (coll__4469__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__50023(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this50015,other50016){
var self__ = this;
var this50015__$1 = this;
return (((!((other50016 == null)))) && ((((this50015__$1.constructor === other50016.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50015__$1.conn,other50016.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50015__$1.network,other50016.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50015__$1.dbid,other50016.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50015__$1.db_name,other50016.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50015__$1.update_chan,other50016.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50015__$1.transact_chan,other50016.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50015__$1.state,other50016.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50015__$1.schema_cache,other50016.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50015__$1.blank_db,other50016.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50015__$1.close,other50016.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50015__$1.id,other50016.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this50015__$1.__extmap,other50016.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k50014){
var self__ = this;
var this__4479__auto____$1 = this;
var G__50024 = k50014;
var G__50024__$1 = (((G__50024 instanceof cljs.core.Keyword))?G__50024.fqn:null);
switch (G__50024__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k50014);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__50013){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__50025 = cljs.core.keyword_identical_QMARK_;
var expr__50026 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__50028 = cljs.core.cst$kw$conn;
var G__50029 = expr__50026;
return (pred__50025.cljs$core$IFn$_invoke$arity$2 ? pred__50025.cljs$core$IFn$_invoke$arity$2(G__50028,G__50029) : pred__50025.call(null,G__50028,G__50029));
})())){
return (new fluree.db.session.DbSession(G__50013,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__50030 = cljs.core.cst$kw$network;
var G__50031 = expr__50026;
return (pred__50025.cljs$core$IFn$_invoke$arity$2 ? pred__50025.cljs$core$IFn$_invoke$arity$2(G__50030,G__50031) : pred__50025.call(null,G__50030,G__50031));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__50013,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__50032 = cljs.core.cst$kw$dbid;
var G__50033 = expr__50026;
return (pred__50025.cljs$core$IFn$_invoke$arity$2 ? pred__50025.cljs$core$IFn$_invoke$arity$2(G__50032,G__50033) : pred__50025.call(null,G__50032,G__50033));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__50013,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__50034 = cljs.core.cst$kw$db_DASH_name;
var G__50035 = expr__50026;
return (pred__50025.cljs$core$IFn$_invoke$arity$2 ? pred__50025.cljs$core$IFn$_invoke$arity$2(G__50034,G__50035) : pred__50025.call(null,G__50034,G__50035));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__50013,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__50036 = cljs.core.cst$kw$update_DASH_chan;
var G__50037 = expr__50026;
return (pred__50025.cljs$core$IFn$_invoke$arity$2 ? pred__50025.cljs$core$IFn$_invoke$arity$2(G__50036,G__50037) : pred__50025.call(null,G__50036,G__50037));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__50013,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__50038 = cljs.core.cst$kw$transact_DASH_chan;
var G__50039 = expr__50026;
return (pred__50025.cljs$core$IFn$_invoke$arity$2 ? pred__50025.cljs$core$IFn$_invoke$arity$2(G__50038,G__50039) : pred__50025.call(null,G__50038,G__50039));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__50013,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__50040 = cljs.core.cst$kw$state;
var G__50041 = expr__50026;
return (pred__50025.cljs$core$IFn$_invoke$arity$2 ? pred__50025.cljs$core$IFn$_invoke$arity$2(G__50040,G__50041) : pred__50025.call(null,G__50040,G__50041));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__50013,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__50042 = cljs.core.cst$kw$schema_DASH_cache;
var G__50043 = expr__50026;
return (pred__50025.cljs$core$IFn$_invoke$arity$2 ? pred__50025.cljs$core$IFn$_invoke$arity$2(G__50042,G__50043) : pred__50025.call(null,G__50042,G__50043));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__50013,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__50044 = cljs.core.cst$kw$blank_DASH_db;
var G__50045 = expr__50026;
return (pred__50025.cljs$core$IFn$_invoke$arity$2 ? pred__50025.cljs$core$IFn$_invoke$arity$2(G__50044,G__50045) : pred__50025.call(null,G__50044,G__50045));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__50013,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__50046 = cljs.core.cst$kw$close;
var G__50047 = expr__50026;
return (pred__50025.cljs$core$IFn$_invoke$arity$2 ? pred__50025.cljs$core$IFn$_invoke$arity$2(G__50046,G__50047) : pred__50025.call(null,G__50046,G__50047));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__50013,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__50048 = cljs.core.cst$kw$id;
var G__50049 = expr__50026;
return (pred__50025.cljs$core$IFn$_invoke$arity$2 ? pred__50025.cljs$core$IFn$_invoke$arity$2(G__50048,G__50049) : pred__50025.call(null,G__50048,G__50049));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__50013,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__50013),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__50013){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__50013,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__50017){
var extmap__4512__auto__ = (function (){var G__50050 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__50017,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__50017)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__50050);
} else {
return G__50050;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__50017),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__50017),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__50017),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__50017),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__50017),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__50017),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__50017),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__50017),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__50017),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__50017),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__50017),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__50053 = session;
var map__50053__$1 = cljs.core.__destructure_map(map__50053);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50053__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50053__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__20603__auto___50205 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_50157){
var state_val_50158 = (state_50157[(1)]);
if((state_val_50158 === (7))){
var inst_50074 = (state_50157[(7)]);
var inst_50079 = cljs.core.empty_QMARK_(inst_50074);
var state_50157__$1 = state_50157;
if(inst_50079){
var statearr_50159_50206 = state_50157__$1;
(statearr_50159_50206[(1)] = (10));

} else {
var statearr_50160_50207 = state_50157__$1;
(statearr_50160_50207[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (20))){
var inst_50105 = (state_50157[(8)]);
var inst_50066 = (state_50157[(9)]);
var inst_50067 = (state_50157[(10)]);
var inst_50065 = (state_50157[(11)]);
var inst_50110 = fluree.db.storage.core.read_block(inst_50065,inst_50066,inst_50067,inst_50105);
var state_50157__$1 = state_50157;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50157__$1,(22),inst_50110);
} else {
if((state_val_50158 === (27))){
var inst_50146 = (state_50157[(12)]);
var inst_50141 = (state_50157[(13)]);
var inst_50144 = (state_50157[(2)]);
var inst_50145 = fluree.db.util.async.throw_err(inst_50144);
var inst_50146__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_50141,cljs.core.cst$kw$schema,inst_50145);
var inst_50147 = fluree.db.query.schema.setting_map(inst_50146__$1);
var state_50157__$1 = (function (){var statearr_50161 = state_50157;
(statearr_50161[(12)] = inst_50146__$1);

return statearr_50161;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50157__$1,(28),inst_50147);
} else {
if((state_val_50158 === (1))){
var state_50157__$1 = state_50157;
var statearr_50162_50208 = state_50157__$1;
(statearr_50162_50208[(2)] = null);

(statearr_50162_50208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (24))){
var inst_50105 = (state_50157[(8)]);
var inst_50066 = (state_50157[(9)]);
var inst_50067 = (state_50157[(10)]);
var inst_50127 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50105)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50066),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50067),"."].join('');
var inst_50128 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_50129 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_50130 = cljs.core.PersistentHashMap.fromArrays(inst_50128,inst_50129);
var inst_50131 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_50127,inst_50130);
var inst_50132 = (function(){throw inst_50131})();
var state_50157__$1 = state_50157;
var statearr_50163_50209 = state_50157__$1;
(statearr_50163_50209[(2)] = inst_50132);

(statearr_50163_50209[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (4))){
var inst_50054 = (state_50157[(2)]);
var inst_50055 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_50054);
var state_50157__$1 = state_50157;
var statearr_50164_50210 = state_50157__$1;
(statearr_50164_50210[(2)] = inst_50055);

(statearr_50164_50210[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (15))){
var state_50157__$1 = state_50157;
var statearr_50165_50211 = state_50157__$1;
(statearr_50165_50211[(2)] = null);

(statearr_50165_50211[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (21))){
var inst_50136 = (state_50157[(2)]);
var state_50157__$1 = state_50157;
var statearr_50166_50212 = state_50157__$1;
(statearr_50166_50212[(2)] = inst_50136);

(statearr_50166_50212[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (13))){
var inst_50074 = (state_50157[(7)]);
var inst_50099 = (state_50157[(14)]);
var inst_50098 = (state_50157[(2)]);
var inst_50099__$1 = fluree.db.util.async.throw_err(inst_50098);
var inst_50100 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_50074);
var state_50157__$1 = (function (){var statearr_50167 = state_50157;
(statearr_50167[(15)] = inst_50100);

(statearr_50167[(14)] = inst_50099__$1);

return statearr_50167;
})();
if(cljs.core.truth_(inst_50099__$1)){
var statearr_50168_50213 = state_50157__$1;
(statearr_50168_50213[(1)] = (14));

} else {
var statearr_50169_50214 = state_50157__$1;
(statearr_50169_50214[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (22))){
var inst_50113 = (state_50157[(16)]);
var inst_50112 = (state_50157[(2)]);
var inst_50113__$1 = fluree.db.util.async.throw_err(inst_50112);
var state_50157__$1 = (function (){var statearr_50170 = state_50157;
(statearr_50170[(16)] = inst_50113__$1);

return statearr_50170;
})();
if(cljs.core.truth_(inst_50113__$1)){
var statearr_50171_50215 = state_50157__$1;
(statearr_50171_50215[(1)] = (23));

} else {
var statearr_50172_50216 = state_50157__$1;
(statearr_50172_50216[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (6))){
var inst_50074 = (state_50157[(7)]);
var inst_50073 = (state_50157[(2)]);
var inst_50074__$1 = fluree.db.util.async.throw_err(inst_50073);
var inst_50075 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_50074__$1);
var inst_50076 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_50075);
var inst_50077 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_50076);
var state_50157__$1 = (function (){var statearr_50173 = state_50157;
(statearr_50173[(7)] = inst_50074__$1);

return statearr_50173;
})();
if(inst_50077){
var statearr_50174_50217 = state_50157__$1;
(statearr_50174_50217[(1)] = (7));

} else {
var statearr_50175_50218 = state_50157__$1;
(statearr_50175_50218[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (28))){
var inst_50146 = (state_50157[(12)]);
var inst_50149 = (state_50157[(2)]);
var inst_50150 = fluree.db.util.async.throw_err(inst_50149);
var inst_50151 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_50146,cljs.core.cst$kw$settings,inst_50150);
var inst_50152 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_50151);
var _ = (function (){var statearr_50176 = state_50157;
(statearr_50176[(4)] = cljs.core.rest((state_50157[(4)])));

return statearr_50176;
})();
var state_50157__$1 = state_50157;
var statearr_50177_50219 = state_50157__$1;
(statearr_50177_50219[(2)] = inst_50152);

(statearr_50177_50219[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (25))){
var inst_50134 = (state_50157[(2)]);
var state_50157__$1 = state_50157;
var statearr_50178_50220 = state_50157__$1;
(statearr_50178_50220[(2)] = inst_50134);

(statearr_50178_50220[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (17))){
var inst_50105 = (state_50157[(8)]);
var inst_50100 = (state_50157[(15)]);
var inst_50107 = (inst_50105 > inst_50100);
var state_50157__$1 = state_50157;
if(cljs.core.truth_(inst_50107)){
var statearr_50179_50221 = state_50157__$1;
(statearr_50179_50221[(1)] = (19));

} else {
var statearr_50180_50222 = state_50157__$1;
(statearr_50180_50222[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (3))){
var inst_50155 = (state_50157[(2)]);
var state_50157__$1 = state_50157;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50157__$1,inst_50155);
} else {
if((state_val_50158 === (12))){
var inst_50086 = (state_50157[(2)]);
var inst_50087 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_50088 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_50089 = cljs.core.PersistentHashMap.fromArrays(inst_50087,inst_50088);
var inst_50090 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_50086,inst_50089);
var inst_50091 = (function(){throw inst_50090})();
var state_50157__$1 = state_50157;
var statearr_50181_50223 = state_50157__$1;
(statearr_50181_50223[(2)] = inst_50091);

(statearr_50181_50223[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (2))){
var inst_50066 = (state_50157[(9)]);
var inst_50067 = (state_50157[(10)]);
var inst_50065 = (state_50157[(11)]);
var _ = (function (){var statearr_50182 = state_50157;
(statearr_50182[(4)] = cljs.core.cons((5),(state_50157[(4)])));

return statearr_50182;
})();
var inst_50062 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_50063 = session;
var inst_50064 = cljs.core.__destructure_map(inst_50063);
var inst_50065__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50064,cljs.core.cst$kw$conn);
var inst_50066__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50064,cljs.core.cst$kw$network);
var inst_50067__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50064,cljs.core.cst$kw$dbid);
var inst_50068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50069 = [inst_50066__$1,inst_50067__$1];
var inst_50070 = (new cljs.core.PersistentVector(null,2,(5),inst_50068,inst_50069,null));
var inst_50071 = fluree.db.operations.ledger_info_async(inst_50065__$1,inst_50070);
var state_50157__$1 = (function (){var statearr_50183 = state_50157;
(statearr_50183[(9)] = inst_50066__$1);

(statearr_50183[(10)] = inst_50067__$1);

(statearr_50183[(11)] = inst_50065__$1);

(statearr_50183[(17)] = inst_50062);

return statearr_50183;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50157__$1,(6),inst_50071);
} else {
if((state_val_50158 === (23))){
var inst_50113 = (state_50157[(16)]);
var inst_50104 = (state_50157[(18)]);
var inst_50116 = cljs.core.__destructure_map(inst_50113);
var inst_50117 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50116,cljs.core.cst$kw$flakes);
var inst_50118 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50116,cljs.core.cst$kw$block);
var inst_50119 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50116,cljs.core.cst$kw$t);
var inst_50120 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_50104,inst_50118,inst_50117);
var state_50157__$1 = (function (){var statearr_50184 = state_50157;
(statearr_50184[(19)] = inst_50119);

return statearr_50184;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50157__$1,(26),inst_50120);
} else {
if((state_val_50158 === (19))){
var inst_50104 = (state_50157[(18)]);
var state_50157__$1 = state_50157;
var statearr_50185_50224 = state_50157__$1;
(statearr_50185_50224[(2)] = inst_50104);

(statearr_50185_50224[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (11))){
var inst_50074 = (state_50157[(7)]);
var inst_50066 = (state_50157[(9)]);
var inst_50067 = (state_50157[(10)]);
var inst_50083 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_50074);
var inst_50084 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50066),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50067)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50083),"."].join('');
var state_50157__$1 = state_50157;
var statearr_50187_50225 = state_50157__$1;
(statearr_50187_50225[(2)] = inst_50084);

(statearr_50187_50225[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (9))){
var inst_50074 = (state_50157[(7)]);
var inst_50066 = (state_50157[(9)]);
var inst_50067 = (state_50157[(10)]);
var inst_50065 = (state_50157[(11)]);
var inst_50062 = (state_50157[(17)]);
var inst_50094 = (state_50157[(2)]);
var inst_50095 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_50074);
var inst_50096 = fluree.db.storage.core.reify_db(inst_50065,inst_50066,inst_50067,inst_50062,inst_50095);
var state_50157__$1 = (function (){var statearr_50188 = state_50157;
(statearr_50188[(20)] = inst_50094);

return statearr_50188;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50157__$1,(13),inst_50096);
} else {
if((state_val_50158 === (5))){
var _ = (function (){var statearr_50189 = state_50157;
(statearr_50189[(4)] = cljs.core.rest((state_50157[(4)])));

return statearr_50189;
})();
var state_50157__$1 = state_50157;
var ex50186 = (state_50157__$1[(2)]);
var statearr_50190_50226 = state_50157__$1;
(statearr_50190_50226[(5)] = ex50186);


var statearr_50191_50227 = state_50157__$1;
(statearr_50191_50227[(1)] = (4));

(statearr_50191_50227[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (14))){
var inst_50099 = (state_50157[(14)]);
var inst_50102 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_50099);
var inst_50103 = (inst_50102 + (1));
var inst_50104 = inst_50099;
var inst_50105 = inst_50103;
var state_50157__$1 = (function (){var statearr_50192 = state_50157;
(statearr_50192[(18)] = inst_50104);

(statearr_50192[(8)] = inst_50105);

return statearr_50192;
})();
var statearr_50193_50228 = state_50157__$1;
(statearr_50193_50228[(2)] = null);

(statearr_50193_50228[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (26))){
var inst_50105 = (state_50157[(8)]);
var inst_50122 = (state_50157[(2)]);
var inst_50123 = fluree.db.util.async.throw_err(inst_50122);
var inst_50124 = (inst_50105 + (1));
var inst_50104 = inst_50123;
var inst_50105__$1 = inst_50124;
var state_50157__$1 = (function (){var statearr_50194 = state_50157;
(statearr_50194[(18)] = inst_50104);

(statearr_50194[(8)] = inst_50105__$1);

return statearr_50194;
})();
var statearr_50195_50229 = state_50157__$1;
(statearr_50195_50229[(2)] = null);

(statearr_50195_50229[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (16))){
var inst_50141 = (state_50157[(13)]);
var inst_50141__$1 = (state_50157[(2)]);
var inst_50142 = fluree.db.query.schema.schema_map(inst_50141__$1);
var state_50157__$1 = (function (){var statearr_50196 = state_50157;
(statearr_50196[(13)] = inst_50141__$1);

return statearr_50196;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50157__$1,(27),inst_50142);
} else {
if((state_val_50158 === (10))){
var inst_50066 = (state_50157[(9)]);
var inst_50067 = (state_50157[(10)]);
var inst_50081 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50066),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50067)," is not found on this ledger group."].join('');
var state_50157__$1 = state_50157;
var statearr_50197_50230 = state_50157__$1;
(statearr_50197_50230[(2)] = inst_50081);

(statearr_50197_50230[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (18))){
var inst_50138 = (state_50157[(2)]);
var state_50157__$1 = state_50157;
var statearr_50198_50231 = state_50157__$1;
(statearr_50198_50231[(2)] = inst_50138);

(statearr_50198_50231[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50158 === (8))){
var state_50157__$1 = state_50157;
var statearr_50199_50232 = state_50157__$1;
(statearr_50199_50232[(2)] = null);

(statearr_50199_50232[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__20477__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__20477__auto____0 = (function (){
var statearr_50200 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50200[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__20477__auto__);

(statearr_50200[(1)] = (1));

return statearr_50200;
});
var fluree$db$session$full_load_existing_db_$_state_machine__20477__auto____1 = (function (state_50157){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_50157);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e50201){var ex__20480__auto__ = e50201;
var statearr_50202_50233 = state_50157;
(statearr_50202_50233[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_50157[(4)]))){
var statearr_50203_50234 = state_50157;
(statearr_50203_50234[(1)] = cljs.core.first((state_50157[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__50235 = state_50157;
state_50157 = G__50235;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__20477__auto__ = function(state_50157){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__20477__auto____1.call(this,state_50157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__20477__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__20477__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_50204 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_50204[(6)] = c__20603__auto___50205);

return statearr_50204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__50236 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__50236,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__50236;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__50237 = cljs.core.get_global_hierarchy;
return (fexpr__50237.cljs$core$IFn$_invoke$arity$0 ? fexpr__50237.cljs$core$IFn$_invoke$arity$0() : fexpr__50237.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_ledger_DASH_update,(function (_,___$1,___$2){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_50239){
var state_val_50240 = (state_50239[(1)]);
if((state_val_50240 === (1))){
var state_50239__$1 = state_50239;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50239__$1,cljs.core.cst$kw$fluree$db$session_SLASH_no_DASH_op);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__20477__auto__ = null;
var fluree$db$session$state_machine__20477__auto____0 = (function (){
var statearr_50241 = [null,null,null,null,null,null,null];
(statearr_50241[(0)] = fluree$db$session$state_machine__20477__auto__);

(statearr_50241[(1)] = (1));

return statearr_50241;
});
var fluree$db$session$state_machine__20477__auto____1 = (function (state_50239){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_50239);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e50242){var ex__20480__auto__ = e50242;
var statearr_50243_50246 = state_50239;
(statearr_50243_50246[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_50239[(4)]))){
var statearr_50244_50247 = state_50239;
(statearr_50244_50247[(1)] = cljs.core.first((state_50239[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__50248 = state_50239;
state_50239 = G__50248;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$session$state_machine__20477__auto__ = function(state_50239){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__20477__auto____1.call(this,state_50239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__20477__auto____0;
fluree$db$session$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__20477__auto____1;
return fluree$db$session$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_50245 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_50245[(6)] = c__20603__auto__);

return statearr_50245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__50250){
var map__50251 = p__50250;
var map__50251__$1 = cljs.core.__destructure_map(map__50251);
var data = map__50251__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50251__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50251__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50251__$1,cljs.core.cst$kw$flakes);
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_50310){
var state_val_50311 = (state_50310[(1)]);
if((state_val_50311 === (7))){
var inst_50265 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_50266 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_50267 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50265),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50266),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_50268 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_50267], 0));
var state_50310__$1 = state_50310;
var statearr_50312_50350 = state_50310__$1;
(statearr_50312_50350[(2)] = inst_50268);

(statearr_50312_50350[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (1))){
var state_50310__$1 = state_50310;
var statearr_50313_50351 = state_50310__$1;
(statearr_50313_50351[(2)] = null);

(statearr_50313_50351[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (4))){
var inst_50252 = (state_50310[(2)]);
var state_50310__$1 = state_50310;
var statearr_50314_50352 = state_50310__$1;
(statearr_50314_50352[(2)] = inst_50252);

(statearr_50314_50352[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (15))){
var inst_50291 = (state_50310[(2)]);
var state_50310__$1 = state_50310;
var statearr_50315_50353 = state_50310__$1;
(statearr_50315_50353[(2)] = inst_50291);

(statearr_50315_50353[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (13))){
var inst_50282 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var inst_50283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_50284 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_50285 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_50286 = [inst_50284,inst_50285];
var inst_50287 = (new cljs.core.PersistentVector(null,2,(5),inst_50283,inst_50286,null));
var inst_50288 = (function (){var G__50316 = inst_50282;
var G__50317 = cljs.core.cst$kw$local_DASH_ledger_DASH_update;
var G__50318 = inst_50287;
var G__50319 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__50316,G__50317,G__50318,G__50319) : fluree.db.conn_events.process_event.call(null,G__50316,G__50317,G__50318,G__50319));
})();
var state_50310__$1 = state_50310;
var statearr_50320_50354 = state_50310__$1;
(statearr_50320_50354[(2)] = inst_50288);

(statearr_50320_50354[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (6))){
var inst_50262 = (state_50310[(7)]);
var inst_50261 = (state_50310[(8)]);
var inst_50260 = (state_50310[(2)]);
var inst_50261__$1 = fluree.db.util.async.throw_err(inst_50260);
var inst_50262__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_50261__$1);
var inst_50263 = (block <= inst_50262__$1);
var state_50310__$1 = (function (){var statearr_50321 = state_50310;
(statearr_50321[(7)] = inst_50262__$1);

(statearr_50321[(8)] = inst_50261__$1);

return statearr_50321;
})();
if(cljs.core.truth_(inst_50263)){
var statearr_50322_50355 = state_50310__$1;
(statearr_50322_50355[(1)] = (7));

} else {
var statearr_50323_50356 = state_50310__$1;
(statearr_50323_50356[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (17))){
var state_50310__$1 = state_50310;
var statearr_50324_50357 = state_50310__$1;
(statearr_50324_50357[(2)] = null);

(statearr_50324_50357[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (3))){
var inst_50308 = (state_50310[(2)]);
var state_50310__$1 = state_50310;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50310__$1,inst_50308);
} else {
if((state_val_50311 === (12))){
var inst_50303 = (state_50310[(2)]);
var state_50310__$1 = state_50310;
var statearr_50325_50358 = state_50310__$1;
(statearr_50325_50358[(2)] = inst_50303);

(statearr_50325_50358[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (2))){
var inst_50258 = (state_50310[(9)]);
var _ = (function (){var statearr_50326 = state_50310;
(statearr_50326[(4)] = cljs.core.cons((5),(state_50310[(4)])));

return statearr_50326;
})();
var inst_50258__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_50310__$1 = (function (){var statearr_50327 = state_50310;
(statearr_50327[(9)] = inst_50258__$1);

return statearr_50327;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50310__$1,(6),inst_50258__$1);
} else {
if((state_val_50311 === (11))){
var state_50310__$1 = state_50310;
var statearr_50329_50359 = state_50310__$1;
(statearr_50329_50359[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (9))){
var inst_50305 = (state_50310[(2)]);
var _ = (function (){var statearr_50331 = state_50310;
(statearr_50331[(4)] = cljs.core.rest((state_50310[(4)])));

return statearr_50331;
})();
var state_50310__$1 = state_50310;
var statearr_50332_50360 = state_50310__$1;
(statearr_50332_50360[(2)] = inst_50305);

(statearr_50332_50360[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (5))){
var _ = (function (){var statearr_50333 = state_50310;
(statearr_50333[(4)] = cljs.core.rest((state_50310[(4)])));

return statearr_50333;
})();
var state_50310__$1 = state_50310;
var ex50328 = (state_50310__$1[(2)]);
var statearr_50334_50361 = state_50310__$1;
(statearr_50334_50361[(5)] = ex50328);


if((ex50328 instanceof Error)){
var statearr_50335_50362 = state_50310__$1;
(statearr_50335_50362[(1)] = (4));

(statearr_50335_50362[(5)] = null);

} else {
throw ex50328;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (14))){
var state_50310__$1 = state_50310;
var statearr_50336_50363 = state_50310__$1;
(statearr_50336_50363[(2)] = null);

(statearr_50336_50363[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (16))){
var inst_50262 = (state_50310[(7)]);
var inst_50294 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_50295 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_50296 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50294),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50295),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50262),". Forcing a db reload."].join('');
var inst_50297 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_50296], 0));
var inst_50298 = fluree.db.session.reload_db_BANG_(session);
var state_50310__$1 = (function (){var statearr_50337 = state_50310;
(statearr_50337[(10)] = inst_50297);

return statearr_50337;
})();
var statearr_50338_50364 = state_50310__$1;
(statearr_50338_50364[(2)] = inst_50298);

(statearr_50338_50364[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (10))){
var inst_50262 = (state_50310[(7)]);
var inst_50261 = (state_50310[(8)]);
var inst_50258 = (state_50310[(9)]);
var inst_50273 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_50274 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_50275 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50273),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50274),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_50276 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_50275], 0));
var inst_50277 = (function (){var current_db_ch = inst_50258;
var current_db = inst_50261;
var current_block = inst_50262;
return (function (p1__50249_SHARP_){
if((p1__50249_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__50249_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__50249_SHARP_);
}
});
})();
var inst_50278 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_50277,flakes);
var inst_50279 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_50261,block,inst_50278);
var inst_50280 = fluree.db.session.cas_db_BANG_(session,inst_50258,inst_50279);
var state_50310__$1 = (function (){var statearr_50339 = state_50310;
(statearr_50339[(11)] = inst_50276);

return statearr_50339;
})();
if(inst_50280){
var statearr_50340_50365 = state_50310__$1;
(statearr_50340_50365[(1)] = (13));

} else {
var statearr_50341_50366 = state_50310__$1;
(statearr_50341_50366[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (18))){
var inst_50301 = (state_50310[(2)]);
var state_50310__$1 = state_50310;
var statearr_50342_50367 = state_50310__$1;
(statearr_50342_50367[(2)] = inst_50301);

(statearr_50342_50367[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50311 === (8))){
var inst_50262 = (state_50310[(7)]);
var inst_50270 = ((1) + inst_50262);
var inst_50271 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_50270);
var state_50310__$1 = state_50310;
if(inst_50271){
var statearr_50343_50368 = state_50310__$1;
(statearr_50343_50368[(1)] = (10));

} else {
var statearr_50344_50369 = state_50310__$1;
(statearr_50344_50369[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__20477__auto__ = null;
var fluree$db$session$state_machine__20477__auto____0 = (function (){
var statearr_50345 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_50345[(0)] = fluree$db$session$state_machine__20477__auto__);

(statearr_50345[(1)] = (1));

return statearr_50345;
});
var fluree$db$session$state_machine__20477__auto____1 = (function (state_50310){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_50310);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e50346){var ex__20480__auto__ = e50346;
var statearr_50347_50370 = state_50310;
(statearr_50347_50370[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_50310[(4)]))){
var statearr_50348_50371 = state_50310;
(statearr_50348_50371[(1)] = cljs.core.first((state_50310[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__50372 = state_50310;
state_50310 = G__50372;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$session$state_machine__20477__auto__ = function(state_50310){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__20477__auto____1.call(this,state_50310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__20477__auto____0;
fluree$db$session$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__20477__auto____1;
return fluree$db$session$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_50349 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_50349[(6)] = c__20603__auto__);

return statearr_50349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_50379){
var state_val_50380 = (state_50379[(1)]);
if((state_val_50380 === (1))){
var inst_50373 = fluree.db.session.clear_db_BANG_(session);
var inst_50374 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_50375 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_50376 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50374),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_50375)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_50377 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_50376], 0));
var state_50379__$1 = (function (){var statearr_50381 = state_50379;
(statearr_50381[(7)] = inst_50377);

(statearr_50381[(8)] = inst_50373);

return statearr_50381;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_50379__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__20477__auto__ = null;
var fluree$db$session$state_machine__20477__auto____0 = (function (){
var statearr_50382 = [null,null,null,null,null,null,null,null,null];
(statearr_50382[(0)] = fluree$db$session$state_machine__20477__auto__);

(statearr_50382[(1)] = (1));

return statearr_50382;
});
var fluree$db$session$state_machine__20477__auto____1 = (function (state_50379){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_50379);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e50383){var ex__20480__auto__ = e50383;
var statearr_50384_50387 = state_50379;
(statearr_50384_50387[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_50379[(4)]))){
var statearr_50385_50388 = state_50379;
(statearr_50385_50388[(1)] = cljs.core.first((state_50379[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__50389 = state_50379;
state_50379 = G__50389;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$session$state_machine__20477__auto__ = function(state_50379){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__20477__auto____1.call(this,state_50379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__20477__auto____0;
fluree$db$session$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__20477__auto____1;
return fluree$db$session$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_50386 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_50386[(6)] = c__20603__auto__);

return statearr_50386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__50391 = arguments.length;
switch (G__50391) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__50392 = session;
var map__50392__$1 = cljs.core.__destructure_map(map__50392);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50392__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50392__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50392__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50392__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50392__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50392__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50392__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__50393_50396 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__50393_50396.cljs$core$IFn$_invoke$arity$3 ? fexpr__50393_50396.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__50393_50396.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__50394_50397 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__50394_50397.cljs$core$IFn$_invoke$arity$0 ? fexpr__50394_50397.cljs$core$IFn$_invoke$arity$0() : fexpr__50394_50397.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_50450){
var state_val_50451 = (state_50450[(1)]);
if((state_val_50451 === (7))){
var inst_50446 = (state_50450[(2)]);
var state_50450__$1 = state_50450;
var statearr_50452_50483 = state_50450__$1;
(statearr_50452_50483[(2)] = inst_50446);

(statearr_50452_50483[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (1))){
var state_50450__$1 = state_50450;
var statearr_50453_50484 = state_50450__$1;
(statearr_50453_50484[(2)] = null);

(statearr_50453_50484[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (4))){
var inst_50401 = (state_50450[(7)]);
var inst_50400 = (state_50450[(2)]);
var inst_50401__$1 = fluree.db.util.async.throw_err(inst_50400);
var inst_50402 = fluree.db.session.from_cache(network,ledger_id);
var inst_50403 = (inst_50401__$1 == null);
var state_50450__$1 = (function (){var statearr_50454 = state_50450;
(statearr_50454[(7)] = inst_50401__$1);

(statearr_50454[(8)] = inst_50402);

return statearr_50454;
})();
if(cljs.core.truth_(inst_50403)){
var statearr_50455_50485 = state_50450__$1;
(statearr_50455_50485[(1)] = (5));

} else {
var statearr_50456_50486 = state_50450__$1;
(statearr_50456_50486[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (15))){
var inst_50438 = (state_50450[(2)]);
var state_50450__$1 = (function (){var statearr_50457 = state_50450;
(statearr_50457[(9)] = inst_50438);

return statearr_50457;
})();
var statearr_50458_50487 = state_50450__$1;
(statearr_50458_50487[(2)] = null);

(statearr_50458_50487[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (13))){
var inst_50442 = (state_50450[(2)]);
var state_50450__$1 = state_50450;
var statearr_50460_50488 = state_50450__$1;
(statearr_50460_50488[(2)] = inst_50442);

(statearr_50460_50488[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (6))){
var inst_50402 = (state_50450[(8)]);
var inst_50408 = (inst_50402 == null);
var state_50450__$1 = state_50450;
if(cljs.core.truth_(inst_50408)){
var statearr_50461_50489 = state_50450__$1;
(statearr_50461_50489[(1)] = (8));

} else {
var statearr_50462_50490 = state_50450__$1;
(statearr_50462_50490[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (17))){
var _ = (function (){var statearr_50463 = state_50450;
(statearr_50463[(4)] = cljs.core.rest((state_50450[(4)])));

return statearr_50463;
})();
var state_50450__$1 = state_50450;
var ex50459 = (state_50450__$1[(2)]);
var statearr_50464_50491 = state_50450__$1;
(statearr_50464_50491[(5)] = ex50459);


var statearr_50465_50492 = state_50450__$1;
(statearr_50465_50492[(1)] = (16));

(statearr_50465_50492[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (3))){
var inst_50448 = (state_50450[(2)]);
var state_50450__$1 = state_50450;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50450__$1,inst_50448);
} else {
if((state_val_50451 === (12))){
var state_50450__$1 = state_50450;
var statearr_50466_50493 = state_50450__$1;
(statearr_50466_50493[(2)] = null);

(statearr_50466_50493[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (2))){
var state_50450__$1 = state_50450;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50450__$1,(4),update_chan);
} else {
if((state_val_50451 === (11))){
var state_50450__$1 = state_50450;
var statearr_50467_50494 = state_50450__$1;
(statearr_50467_50494[(2)] = null);

(statearr_50467_50494[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (9))){
var state_50450__$1 = state_50450;
var statearr_50468_50495 = state_50450__$1;
(statearr_50468_50495[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (5))){
var inst_50405 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_50406 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_50405], 0));
var state_50450__$1 = state_50450;
var statearr_50470_50496 = state_50450__$1;
(statearr_50470_50496[(2)] = inst_50406);

(statearr_50470_50496[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (14))){
var inst_50401 = (state_50450[(7)]);
var inst_50402 = (state_50450[(8)]);
var _ = (function (){var statearr_50471 = state_50450;
(statearr_50471[(4)] = cljs.core.cons((17),(state_50450[(4)])));

return statearr_50471;
})();
var inst_50426 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_50401,(0),null);
var inst_50427 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_50401,(1),null);
var inst_50428 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_50429 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_50401], 0));
var inst_50430 = fluree.db.util.core.trunc(inst_50429,(200));
var inst_50431 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_50428,inst_50430], 0));
var inst_50432 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_50402,inst_50426,inst_50427) : fluree.db.session.process_ledger_update.call(null,inst_50402,inst_50426,inst_50427));
var state_50450__$1 = (function (){var statearr_50472 = state_50450;
(statearr_50472[(10)] = inst_50431);

return statearr_50472;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50450__$1,(18),inst_50432);
} else {
if((state_val_50451 === (16))){
var inst_50401 = (state_50450[(7)]);
var inst_50416 = (state_50450[(2)]);
var inst_50417 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_50416,"Exception processing ledger updates for message: ",inst_50401], 0));
var state_50450__$1 = state_50450;
var statearr_50473_50497 = state_50450__$1;
(statearr_50473_50497[(2)] = inst_50417);

(statearr_50473_50497[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (10))){
var inst_50444 = (state_50450[(2)]);
var state_50450__$1 = state_50450;
var statearr_50474_50498 = state_50450__$1;
(statearr_50474_50498[(2)] = inst_50444);

(statearr_50474_50498[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (18))){
var inst_50434 = (state_50450[(2)]);
var inst_50435 = fluree.db.util.async.throw_err(inst_50434);
var _ = (function (){var statearr_50475 = state_50450;
(statearr_50475[(4)] = cljs.core.rest((state_50450[(4)])));

return statearr_50475;
})();
var state_50450__$1 = state_50450;
var statearr_50476_50499 = state_50450__$1;
(statearr_50476_50499[(2)] = inst_50435);

(statearr_50476_50499[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50451 === (8))){
var inst_50401 = (state_50450[(7)]);
var inst_50410 = cljs.core.first(inst_50401);
var inst_50411 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_50410], 0));
var inst_50412 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_50411].join('');
var inst_50413 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_50412], 0));
var state_50450__$1 = state_50450;
var statearr_50477_50500 = state_50450__$1;
(statearr_50477_50500[(2)] = inst_50413);

(statearr_50477_50500[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__20477__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__20477__auto____0 = (function (){
var statearr_50478 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_50478[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__20477__auto__);

(statearr_50478[(1)] = (1));

return statearr_50478;
});
var fluree$db$session$process_ledger_updates_$_state_machine__20477__auto____1 = (function (state_50450){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_50450);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e50479){var ex__20480__auto__ = e50479;
var statearr_50480_50501 = state_50450;
(statearr_50480_50501[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_50450[(4)]))){
var statearr_50481_50502 = state_50450;
(statearr_50481_50502[(1)] = cljs.core.first((state_50450[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__50503 = state_50450;
state_50450 = G__50503;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__20477__auto__ = function(state_50450){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__20477__auto____1.call(this,state_50450);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__20477__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__20477__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_50482 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_50482[(6)] = c__20603__auto__);

return statearr_50482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__50504){
var map__50505 = p__50504;
var map__50505__$1 = cljs.core.__destructure_map(map__50505);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50505__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50505__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50505__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50505__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50505__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50505__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50505__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50505__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50505__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__50509 = block_result;
var map__50509__$1 = cljs.core.__destructure_map(map__50509);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50509__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50509__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50509__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50509__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50509__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__50510 = tx_result;
var map__50510__$1 = cljs.core.__destructure_map(map__50510);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50510__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50510__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__50506_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__50506_SHARP_.t);
}):(function (p1__50507_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__50507_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__50508_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__50508_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__50508_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__50511 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50511,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50511,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50511,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50511,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4223__auto__ = message;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__50515 = arguments.length;
switch (G__50515) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__50516){
var map__50517 = p__50516;
var map__50517__$1 = cljs.core.__destructure_map(map__50517);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50517__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50517__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50517__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50517__$1,cljs.core.cst$kw$jwt);
var vec__50518 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50518,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50518,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50518,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4223__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4223__auto____$1 = state;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__50522_50642 = network;
var G__50523_50643 = ledger_id;
var G__50524_50644 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__50525_50645 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__50526 = cljs.core.seq(tids);
var chunk__50527 = null;
var count__50528 = (0);
var i__50529 = (0);
while(true){
if((i__50529 < count__50528)){
var tid = chunk__50527.cljs$core$IIndexed$_nth$arity$2(null,i__50529);
var temp__5753__auto___50647__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___50647__$1)){
var keyed_callbacks_50648 = temp__5753__auto___50647__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_50649 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__50570_50650 = cljs.core.seq(keyed_callbacks_50648);
var chunk__50571_50651 = null;
var count__50572_50652 = (0);
var i__50573_50653 = (0);
while(true){
if((i__50573_50653 < count__50572_50652)){
var vec__50582_50654 = chunk__50571_50651.cljs$core$IIndexed$_nth$arity$2(null,i__50573_50653);
var k_50655 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50582_50654,(0),null);
var f_50656 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50582_50654,(1),null);
try{(f_50656.cljs$core$IFn$_invoke$arity$1 ? f_50656.cljs$core$IFn$_invoke$arity$1(tx_response_50649) : f_50656.call(null,tx_response_50649));
}catch (e50585){var e_50657 = e50585;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_50657,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__50658 = seq__50570_50650;
var G__50659 = chunk__50571_50651;
var G__50660 = count__50572_50652;
var G__50661 = (i__50573_50653 + (1));
seq__50570_50650 = G__50658;
chunk__50571_50651 = G__50659;
count__50572_50652 = G__50660;
i__50573_50653 = G__50661;
continue;
} else {
var temp__5753__auto___50662__$2 = cljs.core.seq(seq__50570_50650);
if(temp__5753__auto___50662__$2){
var seq__50570_50663__$1 = temp__5753__auto___50662__$2;
if(cljs.core.chunked_seq_QMARK_(seq__50570_50663__$1)){
var c__4649__auto___50664 = cljs.core.chunk_first(seq__50570_50663__$1);
var G__50665 = cljs.core.chunk_rest(seq__50570_50663__$1);
var G__50666 = c__4649__auto___50664;
var G__50667 = cljs.core.count(c__4649__auto___50664);
var G__50668 = (0);
seq__50570_50650 = G__50665;
chunk__50571_50651 = G__50666;
count__50572_50652 = G__50667;
i__50573_50653 = G__50668;
continue;
} else {
var vec__50586_50669 = cljs.core.first(seq__50570_50663__$1);
var k_50670 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50586_50669,(0),null);
var f_50671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50586_50669,(1),null);
try{(f_50671.cljs$core$IFn$_invoke$arity$1 ? f_50671.cljs$core$IFn$_invoke$arity$1(tx_response_50649) : f_50671.call(null,tx_response_50649));
}catch (e50589){var e_50672 = e50589;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_50672,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__50673 = cljs.core.next(seq__50570_50663__$1);
var G__50674 = null;
var G__50675 = (0);
var G__50676 = (0);
seq__50570_50650 = G__50673;
chunk__50571_50651 = G__50674;
count__50572_50652 = G__50675;
i__50573_50653 = G__50676;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__50677 = seq__50526;
var G__50678 = chunk__50527;
var G__50679 = count__50528;
var G__50680 = (i__50529 + (1));
seq__50526 = G__50677;
chunk__50527 = G__50678;
count__50528 = G__50679;
i__50529 = G__50680;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__50526);
if(temp__5753__auto____$1){
var seq__50526__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__50526__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__50526__$1);
var G__50681 = cljs.core.chunk_rest(seq__50526__$1);
var G__50682 = c__4649__auto__;
var G__50683 = cljs.core.count(c__4649__auto__);
var G__50684 = (0);
seq__50526 = G__50681;
chunk__50527 = G__50682;
count__50528 = G__50683;
i__50529 = G__50684;
continue;
} else {
var tid = cljs.core.first(seq__50526__$1);
var temp__5753__auto___50685__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___50685__$2)){
var keyed_callbacks_50686 = temp__5753__auto___50685__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_50687 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__50590_50688 = cljs.core.seq(keyed_callbacks_50686);
var chunk__50591_50689 = null;
var count__50592_50690 = (0);
var i__50593_50691 = (0);
while(true){
if((i__50593_50691 < count__50592_50690)){
var vec__50602_50692 = chunk__50591_50689.cljs$core$IIndexed$_nth$arity$2(null,i__50593_50691);
var k_50693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50602_50692,(0),null);
var f_50694 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50602_50692,(1),null);
try{(f_50694.cljs$core$IFn$_invoke$arity$1 ? f_50694.cljs$core$IFn$_invoke$arity$1(tx_response_50687) : f_50694.call(null,tx_response_50687));
}catch (e50605){var e_50695 = e50605;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_50695,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__50696 = seq__50590_50688;
var G__50697 = chunk__50591_50689;
var G__50698 = count__50592_50690;
var G__50699 = (i__50593_50691 + (1));
seq__50590_50688 = G__50696;
chunk__50591_50689 = G__50697;
count__50592_50690 = G__50698;
i__50593_50691 = G__50699;
continue;
} else {
var temp__5753__auto___50700__$3 = cljs.core.seq(seq__50590_50688);
if(temp__5753__auto___50700__$3){
var seq__50590_50701__$1 = temp__5753__auto___50700__$3;
if(cljs.core.chunked_seq_QMARK_(seq__50590_50701__$1)){
var c__4649__auto___50702 = cljs.core.chunk_first(seq__50590_50701__$1);
var G__50703 = cljs.core.chunk_rest(seq__50590_50701__$1);
var G__50704 = c__4649__auto___50702;
var G__50705 = cljs.core.count(c__4649__auto___50702);
var G__50706 = (0);
seq__50590_50688 = G__50703;
chunk__50591_50689 = G__50704;
count__50592_50690 = G__50705;
i__50593_50691 = G__50706;
continue;
} else {
var vec__50606_50707 = cljs.core.first(seq__50590_50701__$1);
var k_50708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50606_50707,(0),null);
var f_50709 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50606_50707,(1),null);
try{(f_50709.cljs$core$IFn$_invoke$arity$1 ? f_50709.cljs$core$IFn$_invoke$arity$1(tx_response_50687) : f_50709.call(null,tx_response_50687));
}catch (e50609){var e_50710 = e50609;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_50710,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__50711 = cljs.core.next(seq__50590_50701__$1);
var G__50712 = null;
var G__50713 = (0);
var G__50714 = (0);
seq__50590_50688 = G__50711;
chunk__50591_50689 = G__50712;
count__50592_50690 = G__50713;
i__50593_50691 = G__50714;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__50715 = cljs.core.next(seq__50526__$1);
var G__50716 = null;
var G__50717 = (0);
var G__50718 = (0);
seq__50526 = G__50715;
chunk__50527 = G__50716;
count__50528 = G__50717;
i__50529 = G__50718;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__50521_50646 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__50521_50646.cljs$core$IFn$_invoke$arity$4 ? fexpr__50521_50646.cljs$core$IFn$_invoke$arity$4(G__50522_50642,G__50523_50643,G__50524_50644,G__50525_50645) : fexpr__50521_50646.call(null,G__50522_50642,G__50523_50643,G__50524_50644,G__50525_50645));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_50719 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__20603__auto___50720 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_50626){
var state_val_50627 = (state_50626[(1)]);
if((state_val_50627 === (1))){
var state_50626__$1 = state_50626;
var statearr_50628_50721 = state_50626__$1;
(statearr_50628_50721[(2)] = null);

(statearr_50628_50721[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50627 === (2))){
var inst_50611 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_50626__$1 = state_50626;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50626__$1,(4),inst_50611);
} else {
if((state_val_50627 === (3))){
var inst_50624 = (state_50626[(2)]);
var state_50626__$1 = state_50626;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50626__$1,inst_50624);
} else {
if((state_val_50627 === (4))){
var inst_50613 = (state_50626[(7)]);
var inst_50613__$1 = (state_50626[(2)]);
var inst_50614 = (inst_50613__$1 == null);
var state_50626__$1 = (function (){var statearr_50629 = state_50626;
(statearr_50629[(7)] = inst_50613__$1);

return statearr_50629;
})();
if(cljs.core.truth_(inst_50614)){
var statearr_50630_50722 = state_50626__$1;
(statearr_50630_50722[(1)] = (5));

} else {
var statearr_50631_50723 = state_50626__$1;
(statearr_50631_50723[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50627 === (5))){
var inst_50616 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_50617 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_50616], 0));
var state_50626__$1 = state_50626;
var statearr_50632_50724 = state_50626__$1;
(statearr_50632_50724[(2)] = inst_50617);

(statearr_50632_50724[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50627 === (6))){
var inst_50613 = (state_50626[(7)]);
var inst_50619 = (transact_handler_50719.cljs$core$IFn$_invoke$arity$2 ? transact_handler_50719.cljs$core$IFn$_invoke$arity$2(conn,inst_50613) : transact_handler_50719.call(null,conn,inst_50613));
var state_50626__$1 = (function (){var statearr_50633 = state_50626;
(statearr_50633[(8)] = inst_50619);

return statearr_50633;
})();
var statearr_50634_50725 = state_50626__$1;
(statearr_50634_50725[(2)] = null);

(statearr_50634_50725[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50627 === (7))){
var inst_50622 = (state_50626[(2)]);
var state_50626__$1 = state_50626;
var statearr_50635_50726 = state_50626__$1;
(statearr_50635_50726[(2)] = inst_50622);

(statearr_50635_50726[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__20477__auto__ = null;
var fluree$db$session$state_machine__20477__auto____0 = (function (){
var statearr_50636 = [null,null,null,null,null,null,null,null,null];
(statearr_50636[(0)] = fluree$db$session$state_machine__20477__auto__);

(statearr_50636[(1)] = (1));

return statearr_50636;
});
var fluree$db$session$state_machine__20477__auto____1 = (function (state_50626){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_50626);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e50637){var ex__20480__auto__ = e50637;
var statearr_50638_50727 = state_50626;
(statearr_50638_50727[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_50626[(4)]))){
var statearr_50639_50728 = state_50626;
(statearr_50639_50728[(1)] = cljs.core.first((state_50626[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__50729 = state_50626;
state_50626 = G__50729;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$session$state_machine__20477__auto__ = function(state_50626){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__20477__auto____1.call(this,state_50626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__20477__auto____0;
fluree$db$session$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__20477__auto____1;
return fluree$db$session$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_50640 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_50640[(6)] = c__20603__auto___50720);

return statearr_50640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__50730_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__50730_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__50730_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__50731_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__50731_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
}));

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__50734 = arguments.length;
switch (G__50734) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__50735 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__50732_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__50732_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__50735);
} else {
return G__50735;
}
})();
var seq__50736 = cljs.core.seq(sessions);
var chunk__50737 = null;
var count__50738 = (0);
var i__50739 = (0);
while(true){
if((i__50739 < count__50738)){
var session = chunk__50737.cljs$core$IIndexed$_nth$arity$2(null,i__50739);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__50741 = seq__50736;
var G__50742 = chunk__50737;
var G__50743 = count__50738;
var G__50744 = (i__50739 + (1));
seq__50736 = G__50741;
chunk__50737 = G__50742;
count__50738 = G__50743;
i__50739 = G__50744;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__50736);
if(temp__5753__auto__){
var seq__50736__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__50736__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__50736__$1);
var G__50745 = cljs.core.chunk_rest(seq__50736__$1);
var G__50746 = c__4649__auto__;
var G__50747 = cljs.core.count(c__4649__auto__);
var G__50748 = (0);
seq__50736 = G__50745;
chunk__50737 = G__50746;
count__50738 = G__50747;
i__50739 = G__50748;
continue;
} else {
var session = cljs.core.first(seq__50736__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__50749 = cljs.core.next(seq__50736__$1);
var G__50750 = null;
var G__50751 = (0);
var G__50752 = (0);
seq__50736 = G__50749;
chunk__50737 = G__50750;
count__50738 = G__50751;
i__50739 = G__50752;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
