// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_41086){
var state_val_41087 = (state_41086[(1)]);
if((state_val_41087 === (1))){
var state_41086__$1 = state_41086;
var statearr_41088_41102 = state_41086__$1;
(statearr_41088_41102[(2)] = null);

(statearr_41088_41102[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41087 === (2))){
var _ = (function (){var statearr_41089 = state_41086;
(statearr_41089[(4)] = cljs.core.cons((5),(state_41086[(4)])));

return statearr_41089;
})();
var inst_41077 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_41086__$1 = state_41086;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41086__$1,(6),inst_41077);
} else {
if((state_val_41087 === (3))){
var inst_41084 = (state_41086[(2)]);
var state_41086__$1 = state_41086;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41086__$1,inst_41084);
} else {
if((state_val_41087 === (4))){
var inst_41071 = (state_41086[(2)]);
var state_41086__$1 = state_41086;
var statearr_41091_41103 = state_41086__$1;
(statearr_41091_41103[(2)] = inst_41071);

(statearr_41091_41103[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41087 === (5))){
var _ = (function (){var statearr_41092 = state_41086;
(statearr_41092[(4)] = cljs.core.rest((state_41086[(4)])));

return statearr_41092;
})();
var state_41086__$1 = state_41086;
var ex41090 = (state_41086__$1[(2)]);
var statearr_41093_41104 = state_41086__$1;
(statearr_41093_41104[(5)] = ex41090);


if((ex41090 instanceof Error)){
var statearr_41094_41105 = state_41086__$1;
(statearr_41094_41105[(1)] = (4));

(statearr_41094_41105[(5)] = null);

} else {
throw ex41090;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41087 === (6))){
var inst_41079 = (state_41086[(2)]);
var inst_41080 = fluree.db.util.async.throw_err(inst_41079);
var inst_41081 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_41080);
var _ = (function (){var statearr_41095 = state_41086;
(statearr_41095[(4)] = cljs.core.rest((state_41086[(4)])));

return statearr_41095;
})();
var state_41086__$1 = state_41086;
var statearr_41096_41106 = state_41086__$1;
(statearr_41096_41106[(2)] = inst_41081);

(statearr_41096_41106[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__20477__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__20477__auto____0 = (function (){
var statearr_41097 = [null,null,null,null,null,null,null];
(statearr_41097[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__20477__auto__);

(statearr_41097[(1)] = (1));

return statearr_41097;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__20477__auto____1 = (function (state_41086){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_41086);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e41098){var ex__20480__auto__ = e41098;
var statearr_41099_41107 = state_41086;
(statearr_41099_41107[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_41086[(4)]))){
var statearr_41100_41108 = state_41086;
(statearr_41100_41108[(1)] = cljs.core.first((state_41086[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__41109 = state_41086;
state_41086 = G__41109;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__20477__auto__ = function(state_41086){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__20477__auto____1.call(this,state_41086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__20477__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__20477__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_41101 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_41101[(6)] = c__20603__auto__);

return statearr_41101;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_41141){
var state_val_41142 = (state_41141[(1)]);
if((state_val_41142 === (7))){
var inst_41125 = (state_41141[(7)]);
var inst_41127 = cljs.core.empty_QMARK_(inst_41125);
var inst_41128 = (!(inst_41127));
var state_41141__$1 = state_41141;
var statearr_41143_41167 = state_41141__$1;
(statearr_41143_41167[(2)] = inst_41128);

(statearr_41143_41167[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41142 === (1))){
var state_41141__$1 = state_41141;
var statearr_41144_41168 = state_41141__$1;
(statearr_41144_41168[(2)] = null);

(statearr_41144_41168[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41142 === (4))){
var inst_41111 = (state_41141[(2)]);
var state_41141__$1 = state_41141;
var statearr_41145_41169 = state_41141__$1;
(statearr_41145_41169[(2)] = inst_41111);

(statearr_41145_41169[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41142 === (6))){
var inst_41117 = (state_41141[(8)]);
var inst_41125 = (state_41141[(7)]);
var inst_41123 = (state_41141[(2)]);
var inst_41124 = fluree.db.util.async.throw_err(inst_41123);
var inst_41125__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_41117,inst_41124);
var state_41141__$1 = (function (){var statearr_41146 = state_41141;
(statearr_41146[(7)] = inst_41125__$1);

return statearr_41146;
})();
if(cljs.core.truth_(inst_41125__$1)){
var statearr_41147_41170 = state_41141__$1;
(statearr_41147_41170[(1)] = (7));

} else {
var statearr_41148_41171 = state_41141__$1;
(statearr_41148_41171[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41142 === (3))){
var inst_41139 = (state_41141[(2)]);
var state_41141__$1 = state_41141;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41141__$1,inst_41139);
} else {
if((state_val_41142 === (12))){
var inst_41136 = (state_41141[(2)]);
var _ = (function (){var statearr_41149 = state_41141;
(statearr_41149[(4)] = cljs.core.rest((state_41141[(4)])));

return statearr_41149;
})();
var state_41141__$1 = state_41141;
var statearr_41150_41172 = state_41141__$1;
(statearr_41150_41172[(2)] = inst_41136);

(statearr_41150_41172[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41142 === (2))){
var _ = (function (){var statearr_41151 = state_41141;
(statearr_41151[(4)] = cljs.core.cons((5),(state_41141[(4)])));

return statearr_41151;
})();
var inst_41117 = (function (){return (function (p1__41110_SHARP_){
return p1__41110_SHARP_.o;
});
})();
var inst_41118 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41119 = [pred_id];
var inst_41120 = (new cljs.core.PersistentVector(null,1,(5),inst_41118,inst_41119,null));
var inst_41121 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_41120);
var state_41141__$1 = (function (){var statearr_41152 = state_41141;
(statearr_41152[(8)] = inst_41117);

return statearr_41152;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41141__$1,(6),inst_41121);
} else {
if((state_val_41142 === (11))){
var state_41141__$1 = state_41141;
var statearr_41154_41173 = state_41141__$1;
(statearr_41154_41173[(2)] = true);

(statearr_41154_41173[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41142 === (9))){
var inst_41131 = (state_41141[(2)]);
var state_41141__$1 = state_41141;
if(cljs.core.truth_(inst_41131)){
var statearr_41155_41174 = state_41141__$1;
(statearr_41155_41174[(1)] = (10));

} else {
var statearr_41156_41175 = state_41141__$1;
(statearr_41156_41175[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41142 === (5))){
var _ = (function (){var statearr_41157 = state_41141;
(statearr_41157[(4)] = cljs.core.rest((state_41141[(4)])));

return statearr_41157;
})();
var state_41141__$1 = state_41141;
var ex41153 = (state_41141__$1[(2)]);
var statearr_41158_41176 = state_41141__$1;
(statearr_41158_41176[(5)] = ex41153);


if((ex41153 instanceof Error)){
var statearr_41159_41177 = state_41141__$1;
(statearr_41159_41177[(1)] = (4));

(statearr_41159_41177[(5)] = null);

} else {
throw ex41153;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41142 === (10))){
var inst_41125 = (state_41141[(7)]);
var inst_41133 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_41125);
var state_41141__$1 = state_41141;
var statearr_41160_41178 = state_41141__$1;
(statearr_41160_41178[(2)] = inst_41133);

(statearr_41160_41178[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41142 === (8))){
var inst_41125 = (state_41141[(7)]);
var state_41141__$1 = state_41141;
var statearr_41161_41179 = state_41141__$1;
(statearr_41161_41179[(2)] = inst_41125);

(statearr_41161_41179[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__20477__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__20477__auto____0 = (function (){
var statearr_41162 = [null,null,null,null,null,null,null,null,null];
(statearr_41162[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__20477__auto__);

(statearr_41162[(1)] = (1));

return statearr_41162;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__20477__auto____1 = (function (state_41141){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_41141);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e41163){var ex__20480__auto__ = e41163;
var statearr_41164_41180 = state_41141;
(statearr_41164_41180[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_41141[(4)]))){
var statearr_41165_41181 = state_41141;
(statearr_41165_41181[(1)] = cljs.core.first((state_41141[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__41182 = state_41141;
state_41141 = G__41182;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__20477__auto__ = function(state_41141){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__20477__auto____1.call(this,state_41141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__20477__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__20477__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_41166 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_41166[(6)] = c__20603__auto__);

return statearr_41166;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_41263){
var state_val_41264 = (state_41263[(1)]);
if((state_val_41264 === (7))){
var state_41263__$1 = state_41263;
var statearr_41265_41303 = state_41263__$1;
(statearr_41265_41303[(2)] = flakes);

(statearr_41265_41303[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (20))){
var inst_41220 = (state_41263[(7)]);
var inst_41253 = (state_41263[(2)]);
var inst_41212 = inst_41220;
var inst_41213 = inst_41253;
var state_41263__$1 = (function (){var statearr_41266 = state_41263;
(statearr_41266[(8)] = inst_41212);

(statearr_41266[(9)] = inst_41213);

return statearr_41266;
})();
var statearr_41267_41304 = state_41263__$1;
(statearr_41267_41304[(2)] = null);

(statearr_41267_41304[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (1))){
var state_41263__$1 = state_41263;
var statearr_41268_41305 = state_41263__$1;
(statearr_41268_41305[(2)] = null);

(statearr_41268_41305[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (4))){
var inst_41185 = (state_41263[(2)]);
var state_41263__$1 = state_41263;
var statearr_41269_41306 = state_41263__$1;
(statearr_41269_41306[(2)] = inst_41185);

(statearr_41269_41306[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (15))){
var inst_41219 = (state_41263[(10)]);
var inst_41237 = inst_41219.o;
var state_41263__$1 = state_41263;
var statearr_41270_41307 = state_41263__$1;
(statearr_41270_41307[(2)] = inst_41237);

(statearr_41270_41307[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (13))){
var inst_41256 = (state_41263[(2)]);
var state_41263__$1 = state_41263;
var statearr_41271_41308 = state_41263__$1;
(statearr_41271_41308[(2)] = inst_41256);

(statearr_41271_41308[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (6))){
var inst_41192 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_41263__$1 = state_41263;
var statearr_41272_41309 = state_41263__$1;
(statearr_41272_41309[(2)] = inst_41192);

(statearr_41272_41309[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (17))){
var inst_41234 = (state_41263[(2)]);
var inst_41235 = fluree.db.util.async.throw_err(inst_41234);
var state_41263__$1 = state_41263;
var statearr_41273_41310 = state_41263__$1;
(statearr_41273_41310[(2)] = inst_41235);

(statearr_41273_41310[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (3))){
var inst_41261 = (state_41263[(2)]);
var state_41263__$1 = state_41263;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41263__$1,inst_41261);
} else {
if((state_val_41264 === (12))){
var inst_41219 = (state_41263[(10)]);
var inst_41226 = (state_41263[(11)]);
var inst_41224 = inst_41219.p;
var inst_41225 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_41224);
var inst_41226__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_41225);
var inst_41227 = inst_41219.op;
var inst_41228 = inst_41227 === false;
var inst_41229 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_41226__$1);
var state_41263__$1 = (function (){var statearr_41274 = state_41263;
(statearr_41274[(12)] = inst_41228);

(statearr_41274[(11)] = inst_41226__$1);

return statearr_41274;
})();
if(inst_41229){
var statearr_41275_41311 = state_41263__$1;
(statearr_41275_41311[(1)] = (14));

} else {
var statearr_41276_41312 = state_41263__$1;
(statearr_41276_41312[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (2))){
var _ = (function (){var statearr_41277 = state_41263;
(statearr_41277[(4)] = cljs.core.cons((5),(state_41263[(4)])));

return statearr_41277;
})();
var state_41263__$1 = state_41263;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_41278_41313 = state_41263__$1;
(statearr_41278_41313[(1)] = (6));

} else {
var statearr_41279_41314 = state_41263__$1;
(statearr_41279_41314[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (19))){
var inst_41239 = (state_41263[(13)]);
var inst_41219 = (state_41263[(10)]);
var inst_41213 = (state_41263[(9)]);
var inst_41226 = (state_41263[(11)]);
var inst_41247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41248 = inst_41219.s;
var inst_41249 = [inst_41248,inst_41226,cljs.core.cst$kw$new];
var inst_41250 = (new cljs.core.PersistentVector(null,3,(5),inst_41247,inst_41249,null));
var inst_41251 = cljs.core.assoc_in(inst_41213,inst_41250,inst_41239);
var state_41263__$1 = state_41263;
var statearr_41280_41315 = state_41263__$1;
(statearr_41280_41315[(2)] = inst_41251);

(statearr_41280_41315[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (11))){
var inst_41213 = (state_41263[(9)]);
var state_41263__$1 = state_41263;
var statearr_41282_41316 = state_41263__$1;
(statearr_41282_41316[(2)] = inst_41213);

(statearr_41282_41316[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (9))){
var inst_41212 = (state_41263[(8)]);
var inst_41219 = (state_41263[(10)]);
var inst_41218 = cljs.core.seq(inst_41212);
var inst_41219__$1 = cljs.core.first(inst_41218);
var inst_41220 = cljs.core.next(inst_41218);
var inst_41221 = cljs.core.not(inst_41219__$1);
var state_41263__$1 = (function (){var statearr_41283 = state_41263;
(statearr_41283[(10)] = inst_41219__$1);

(statearr_41283[(7)] = inst_41220);

return statearr_41283;
})();
if(inst_41221){
var statearr_41284_41317 = state_41263__$1;
(statearr_41284_41317[(1)] = (11));

} else {
var statearr_41285_41318 = state_41263__$1;
(statearr_41285_41318[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (5))){
var _ = (function (){var statearr_41286 = state_41263;
(statearr_41286[(4)] = cljs.core.rest((state_41263[(4)])));

return statearr_41286;
})();
var state_41263__$1 = state_41263;
var ex41281 = (state_41263__$1[(2)]);
var statearr_41287_41319 = state_41263__$1;
(statearr_41287_41319[(5)] = ex41281);


if((ex41281 instanceof Error)){
var statearr_41288_41320 = state_41263__$1;
(statearr_41288_41320[(1)] = (4));

(statearr_41288_41320[(5)] = null);

} else {
throw ex41281;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (14))){
var inst_41219 = (state_41263[(10)]);
var inst_41231 = inst_41219.o;
var inst_41232 = fluree.db.query.schema.convert_type_to_kw(inst_41231,db);
var state_41263__$1 = state_41263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41263__$1,(17),inst_41232);
} else {
if((state_val_41264 === (16))){
var inst_41228 = (state_41263[(12)]);
var inst_41239 = (state_41263[(2)]);
var state_41263__$1 = (function (){var statearr_41289 = state_41263;
(statearr_41289[(13)] = inst_41239);

return statearr_41289;
})();
if(cljs.core.truth_(inst_41228)){
var statearr_41290_41321 = state_41263__$1;
(statearr_41290_41321[(1)] = (18));

} else {
var statearr_41291_41322 = state_41263__$1;
(statearr_41291_41322[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (10))){
var inst_41258 = (state_41263[(2)]);
var _ = (function (){var statearr_41292 = state_41263;
(statearr_41292[(4)] = cljs.core.rest((state_41263[(4)])));

return statearr_41292;
})();
var state_41263__$1 = state_41263;
var statearr_41293_41323 = state_41263__$1;
(statearr_41293_41323[(2)] = inst_41258);

(statearr_41293_41323[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (18))){
var inst_41239 = (state_41263[(13)]);
var inst_41219 = (state_41263[(10)]);
var inst_41213 = (state_41263[(9)]);
var inst_41226 = (state_41263[(11)]);
var inst_41241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41242 = inst_41219.s;
var inst_41243 = [inst_41242,inst_41226,cljs.core.cst$kw$old];
var inst_41244 = (new cljs.core.PersistentVector(null,3,(5),inst_41241,inst_41243,null));
var inst_41245 = cljs.core.assoc_in(inst_41213,inst_41244,inst_41239);
var state_41263__$1 = state_41263;
var statearr_41294_41324 = state_41263__$1;
(statearr_41294_41324[(2)] = inst_41245);

(statearr_41294_41324[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41264 === (8))){
var inst_41195 = (state_41263[(2)]);
var inst_41196 = cljs.core.PersistentHashSet.EMPTY;
var inst_41197 = cljs.core.vals(tempids);
var inst_41198 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41196,inst_41197);
var inst_41199 = (function (){var pred_flakes = inst_41195;
var is_new_QMARK_ = inst_41198;
return (function (p1__41183_SHARP_,p2__41184_SHARP_){
return cljs.core.assoc_in(p1__41183_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__41184_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__41295 = p2__41184_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__41295) : is_new_QMARK_.call(null,G__41295));
})()));
});
})();
var inst_41200 = cljs.core.PersistentHashMap.EMPTY;
var inst_41201 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_41199,inst_41200,inst_41195);
var inst_41209 = cljs.core.seq(inst_41195);
var inst_41210 = cljs.core.first(inst_41209);
var inst_41211 = cljs.core.next(inst_41209);
var inst_41212 = inst_41195;
var inst_41213 = inst_41201;
var state_41263__$1 = (function (){var statearr_41296 = state_41263;
(statearr_41296[(8)] = inst_41212);

(statearr_41296[(9)] = inst_41213);

(statearr_41296[(14)] = inst_41211);

(statearr_41296[(15)] = inst_41210);

return statearr_41296;
})();
var statearr_41297_41325 = state_41263__$1;
(statearr_41297_41325[(2)] = null);

(statearr_41297_41325[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__20477__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__20477__auto____0 = (function (){
var statearr_41298 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41298[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__20477__auto__);

(statearr_41298[(1)] = (1));

return statearr_41298;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__20477__auto____1 = (function (state_41263){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_41263);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e41299){var ex__20480__auto__ = e41299;
var statearr_41300_41326 = state_41263;
(statearr_41300_41326[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_41263[(4)]))){
var statearr_41301_41327 = state_41263;
(statearr_41301_41327[(1)] = cljs.core.first((state_41263[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__41328 = state_41263;
state_41263 = G__41328;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__20477__auto__ = function(state_41263){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__20477__auto____1.call(this,state_41263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__20477__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__20477__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_41302 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_41302[(6)] = c__20603__auto__);

return statearr_41302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__41330 = arguments.length;
switch (G__41330) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__41333 = arguments.length;
switch (G__41333) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_41645){
var state_val_41646 = (state_41645[(1)]);
if((state_val_41646 === (121))){
var inst_41600 = (state_41645[(7)]);
var state_41645__$1 = state_41645;
var statearr_41647_41840 = state_41645__$1;
(statearr_41647_41840[(2)] = inst_41600);

(statearr_41647_41840[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (65))){
var inst_41499 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41499)){
var statearr_41648_41841 = state_41645__$1;
(statearr_41648_41841[(1)] = (66));

} else {
var statearr_41649_41842 = state_41645__$1;
(statearr_41649_41842[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (70))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41509 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_41510 = (inst_41505.cljs$core$IFn$_invoke$arity$5 ? inst_41505.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_41509,null) : inst_41505.call(null,cljs.core.PersistentArrayMap,null,3,inst_41509,null));
var inst_41511 = (inst_41505.cljs$core$IFn$_invoke$arity$4 ? inst_41505.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_41510,null) : inst_41505.call(null,cljs.core.PersistentHashSet,null,inst_41510,null));
var inst_41512 = (inst_41511.cljs$core$IFn$_invoke$arity$1 ? inst_41511.cljs$core$IFn$_invoke$arity$1(inst_41504) : inst_41511.call(null,inst_41504));
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41512)){
var statearr_41650_41843 = state_41645__$1;
(statearr_41650_41843[(1)] = (72));

} else {
var statearr_41651_41844 = state_41645__$1;
(statearr_41651_41844[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (62))){
var inst_41489 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41652_41845 = state_41645__$1;
(statearr_41652_41845[(2)] = inst_41489);

(statearr_41652_41845[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (74))){
var inst_41595 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41653_41846 = state_41645__$1;
(statearr_41653_41846[(2)] = inst_41595);

(statearr_41653_41846[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (110))){
var inst_41622 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41622)){
var statearr_41654_41847 = state_41645__$1;
(statearr_41654_41847[(1)] = (117));

} else {
var statearr_41655_41848 = state_41645__$1;
(statearr_41655_41848[(1)] = (118));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (7))){
var inst_41640 = (state_41645[(2)]);
var _ = (function (){var statearr_41656 = state_41645;
(statearr_41656[(4)] = cljs.core.rest((state_41645[(4)])));

return statearr_41656;
})();
var state_41645__$1 = state_41645;
var statearr_41657_41849 = state_41645__$1;
(statearr_41657_41849[(2)] = inst_41640);

(statearr_41657_41849[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (59))){
var inst_41373 = (state_41645[(10)]);
var inst_41493 = (state_41645[(11)]);
var inst_41492 = (state_41645[(2)]);
var inst_41493__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_41373);
var state_41645__$1 = (function (){var statearr_41658 = state_41645;
(statearr_41658[(11)] = inst_41493__$1);

(statearr_41658[(12)] = inst_41492);

return statearr_41658;
})();
if(cljs.core.truth_(inst_41493__$1)){
var statearr_41659_41850 = state_41645__$1;
(statearr_41659_41850[(1)] = (63));

} else {
var statearr_41660_41851 = state_41645__$1;
(statearr_41660_41851[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (86))){
var inst_41535 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41661_41852 = state_41645__$1;
(statearr_41661_41852[(2)] = inst_41535);

(statearr_41661_41852[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (20))){
var inst_41373 = (state_41645[(10)]);
var inst_41399 = (state_41645[(13)]);
var inst_41399__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_41373);
var state_41645__$1 = (function (){var statearr_41662 = state_41645;
(statearr_41662[(13)] = inst_41399__$1);

return statearr_41662;
})();
if(cljs.core.truth_(inst_41399__$1)){
var statearr_41663_41853 = state_41645__$1;
(statearr_41663_41853[(1)] = (23));

} else {
var statearr_41664_41854 = state_41645__$1;
(statearr_41664_41854[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (72))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41514 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41504,inst_41505,throw_QMARK_);
var state_41645__$1 = state_41645;
var statearr_41665_41855 = state_41645__$1;
(statearr_41665_41855[(2)] = inst_41514);

(statearr_41665_41855[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (58))){
var inst_41454 = (state_41645[(14)]);
var state_41645__$1 = state_41645;
var statearr_41666_41856 = state_41645__$1;
(statearr_41666_41856[(2)] = inst_41454);

(statearr_41666_41856[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (60))){
var inst_41361 = (state_41645[(15)]);
var inst_41372 = (state_41645[(16)]);
var inst_41480 = fluree.db.dbproto._p_prop(inst_41361,cljs.core.cst$kw$name,inst_41372);
var inst_41481 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41480)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_41482 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41483 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_41484 = cljs.core.PersistentHashMap.fromArrays(inst_41482,inst_41483);
var inst_41485 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41481,inst_41484);
var inst_41486 = (function(){throw inst_41485})();
var state_41645__$1 = state_41645;
var statearr_41667_41857 = state_41645__$1;
(statearr_41667_41857[(2)] = inst_41486);

(statearr_41667_41857[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (27))){
var inst_41402 = (state_41645[(17)]);
var state_41645__$1 = state_41645;
var statearr_41668_41858 = state_41645__$1;
(statearr_41668_41858[(2)] = inst_41402);

(statearr_41668_41858[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (1))){
var state_41645__$1 = state_41645;
var statearr_41669_41859 = state_41645__$1;
(statearr_41669_41859[(2)] = null);

(statearr_41669_41859[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (69))){
var inst_41492 = (state_41645[(12)]);
var state_41645__$1 = state_41645;
var statearr_41670_41860 = state_41645__$1;
(statearr_41670_41860[(2)] = inst_41492);

(statearr_41670_41860[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (101))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41573 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41504,inst_41505,throw_QMARK_);
var state_41645__$1 = state_41645;
var statearr_41671_41861 = state_41645__$1;
(statearr_41671_41861[(2)] = inst_41573);

(statearr_41671_41861[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (24))){
var inst_41399 = (state_41645[(13)]);
var state_41645__$1 = state_41645;
var statearr_41672_41862 = state_41645__$1;
(statearr_41672_41862[(2)] = inst_41399);

(statearr_41672_41862[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (102))){
var inst_41575 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41673_41863 = state_41645__$1;
(statearr_41673_41863[(2)] = inst_41575);

(statearr_41673_41863[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (55))){
var inst_41471 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41674_41864 = state_41645__$1;
(statearr_41674_41864[(2)] = inst_41471);

(statearr_41674_41864[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (85))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41533 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41504,inst_41505,throw_QMARK_);
var state_41645__$1 = state_41645;
var statearr_41675_41865 = state_41645__$1;
(statearr_41675_41865[(2)] = inst_41533);

(statearr_41675_41865[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (39))){
var inst_41436 = (state_41645[(18)]);
var state_41645__$1 = state_41645;
var statearr_41676_41866 = state_41645__$1;
(statearr_41676_41866[(2)] = inst_41436);

(statearr_41676_41866[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (88))){
var inst_41492 = (state_41645[(12)]);
var state_41645__$1 = state_41645;
var statearr_41677_41867 = state_41645__$1;
(statearr_41677_41867[(2)] = inst_41492);

(statearr_41677_41867[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (46))){
var inst_41373 = (state_41645[(10)]);
var inst_41455 = (state_41645[(19)]);
var inst_41454 = (state_41645[(2)]);
var inst_41455__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_41373);
var state_41645__$1 = (function (){var statearr_41678 = state_41645;
(statearr_41678[(14)] = inst_41454);

(statearr_41678[(19)] = inst_41455__$1);

return statearr_41678;
})();
if(cljs.core.truth_(inst_41455__$1)){
var statearr_41679_41868 = state_41645__$1;
(statearr_41679_41868[(1)] = (47));

} else {
var statearr_41680_41869 = state_41645__$1;
(statearr_41680_41869[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (4))){
var inst_41334 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41681_41870 = state_41645__$1;
(statearr_41681_41870[(2)] = inst_41334);

(statearr_41681_41870[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (77))){
var inst_41593 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41682_41871 = state_41645__$1;
(statearr_41682_41871[(2)] = inst_41593);

(statearr_41682_41871[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (106))){
var inst_41585 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41683_41872 = state_41645__$1;
(statearr_41683_41872[(2)] = inst_41585);

(statearr_41683_41872[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (119))){
var inst_41371 = (state_41645[(20)]);
var inst_41635 = (state_41645[(2)]);
var inst_41360 = inst_41371;
var inst_41361 = inst_41635;
var state_41645__$1 = (function (){var statearr_41684 = state_41645;
(statearr_41684[(21)] = inst_41360);

(statearr_41684[(15)] = inst_41361);

return statearr_41684;
})();
var statearr_41685_41873 = state_41645__$1;
(statearr_41685_41873[(2)] = null);

(statearr_41685_41873[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (95))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41557 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_41558 = (inst_41505.cljs$core$IFn$_invoke$arity$5 ? inst_41505.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_41557,null) : inst_41505.call(null,cljs.core.PersistentArrayMap,null,5,inst_41557,null));
var inst_41559 = (inst_41505.cljs$core$IFn$_invoke$arity$4 ? inst_41505.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_41558,null) : inst_41505.call(null,cljs.core.PersistentHashSet,null,inst_41558,null));
var inst_41560 = (inst_41559.cljs$core$IFn$_invoke$arity$1 ? inst_41559.cljs$core$IFn$_invoke$arity$1(inst_41504) : inst_41559.call(null,inst_41504));
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41560)){
var statearr_41686_41874 = state_41645__$1;
(statearr_41686_41874[(1)] = (96));

} else {
var statearr_41687_41875 = state_41645__$1;
(statearr_41687_41875[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (54))){
var inst_41462 = (state_41645[(22)]);
var state_41645__$1 = state_41645;
var statearr_41688_41876 = state_41645__$1;
(statearr_41688_41876[(2)] = inst_41462);

(statearr_41688_41876[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (92))){
var inst_41492 = (state_41645[(12)]);
var state_41645__$1 = state_41645;
var statearr_41689_41877 = state_41645__$1;
(statearr_41689_41877[(2)] = inst_41492);

(statearr_41689_41877[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (104))){
var inst_41492 = (state_41645[(12)]);
var state_41645__$1 = state_41645;
var statearr_41690_41878 = state_41645__$1;
(statearr_41690_41878[(2)] = inst_41492);

(statearr_41690_41878[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (15))){
var inst_41381 = (state_41645[(23)]);
var state_41645__$1 = state_41645;
var statearr_41691_41879 = state_41645__$1;
(statearr_41691_41879[(2)] = inst_41381);

(statearr_41691_41879[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (48))){
var inst_41455 = (state_41645[(19)]);
var state_41645__$1 = state_41645;
var statearr_41692_41880 = state_41645__$1;
(statearr_41692_41880[(2)] = inst_41455);

(statearr_41692_41880[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (50))){
var inst_41373 = (state_41645[(10)]);
var inst_41462 = (state_41645[(22)]);
var inst_41460 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41461 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_41460);
var inst_41462__$1 = inst_41461 === true;
var state_41645__$1 = (function (){var statearr_41693 = state_41645;
(statearr_41693[(22)] = inst_41462__$1);

return statearr_41693;
})();
if(cljs.core.truth_(inst_41462__$1)){
var statearr_41694_41881 = state_41645__$1;
(statearr_41694_41881[(1)] = (53));

} else {
var statearr_41695_41882 = state_41645__$1;
(statearr_41695_41882[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (116))){
var inst_41616 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41696_41883 = state_41645__$1;
(statearr_41696_41883[(2)] = inst_41616);

(statearr_41696_41883[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (75))){
var inst_41505 = (state_41645[(9)]);
var state_41645__$1 = state_41645;
var G__41697_41884 = inst_41505;
var G__41697_41885__$1 = (((G__41697_41884 instanceof cljs.core.Keyword))?G__41697_41884.fqn:null);
switch (G__41697_41885__$1) {
case "long":
var statearr_41698_41887 = state_41645__$1;
(statearr_41698_41887[(1)] = (79));


break;
case "bigint":
var statearr_41699_41888 = state_41645__$1;
(statearr_41699_41888[(1)] = (83));


break;
case "double":
var statearr_41700_41889 = state_41645__$1;
(statearr_41700_41889[(1)] = (87));


break;
case "float":
var statearr_41701_41890 = state_41645__$1;
(statearr_41701_41890[(1)] = (91));


break;
case "bigdec":
var statearr_41702_41891 = state_41645__$1;
(statearr_41702_41891[(1)] = (95));


break;
case "string":
var statearr_41703_41892 = state_41645__$1;
(statearr_41703_41892[(1)] = (99));


break;
case "instant":
var statearr_41704_41893 = state_41645__$1;
(statearr_41704_41893[(1)] = (103));


break;
default:
var statearr_41705_41894 = state_41645__$1;
(statearr_41705_41894[(1)] = (107));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (99))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41567 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_41568 = (inst_41505.cljs$core$IFn$_invoke$arity$5 ? inst_41505.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_41567,null) : inst_41505.call(null,cljs.core.PersistentArrayMap,null,5,inst_41567,null));
var inst_41569 = (inst_41505.cljs$core$IFn$_invoke$arity$4 ? inst_41505.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_41568,null) : inst_41505.call(null,cljs.core.PersistentHashSet,null,inst_41568,null));
var inst_41570 = (inst_41569.cljs$core$IFn$_invoke$arity$1 ? inst_41569.cljs$core$IFn$_invoke$arity$1(inst_41504) : inst_41569.call(null,inst_41504));
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41570)){
var statearr_41706_41895 = state_41645__$1;
(statearr_41706_41895[(1)] = (100));

} else {
var statearr_41707_41896 = state_41645__$1;
(statearr_41707_41896[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (21))){
var inst_41397 = (state_41645[(24)]);
var state_41645__$1 = state_41645;
var statearr_41708_41897 = state_41645__$1;
(statearr_41708_41897[(2)] = inst_41397);

(statearr_41708_41897[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (31))){
var inst_41413 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41709_41898 = state_41645__$1;
(statearr_41709_41898[(2)] = inst_41413);

(statearr_41709_41898[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (113))){
var inst_41619 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41710_41899 = state_41645__$1;
(statearr_41710_41899[(2)] = inst_41619);

(statearr_41710_41899[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (32))){
var state_41645__$1 = state_41645;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_41711_41900 = state_41645__$1;
(statearr_41711_41900[(1)] = (35));

} else {
var statearr_41712_41901 = state_41645__$1;
(statearr_41712_41901[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (40))){
var inst_41449 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41449)){
var statearr_41713_41902 = state_41645__$1;
(statearr_41713_41902[(1)] = (44));

} else {
var statearr_41714_41903 = state_41645__$1;
(statearr_41714_41903[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (91))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41547 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_41548 = (inst_41505.cljs$core$IFn$_invoke$arity$5 ? inst_41505.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_41547,null) : inst_41505.call(null,cljs.core.PersistentArrayMap,null,3,inst_41547,null));
var inst_41549 = (inst_41505.cljs$core$IFn$_invoke$arity$4 ? inst_41505.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_41548,null) : inst_41505.call(null,cljs.core.PersistentHashSet,null,inst_41548,null));
var inst_41550 = (inst_41549.cljs$core$IFn$_invoke$arity$1 ? inst_41549.cljs$core$IFn$_invoke$arity$1(inst_41504) : inst_41549.call(null,inst_41504));
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41550)){
var statearr_41715_41904 = state_41645__$1;
(statearr_41715_41904[(1)] = (92));

} else {
var statearr_41716_41905 = state_41645__$1;
(statearr_41716_41905[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (117))){
var state_41645__$1 = state_41645;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_41717_41906 = state_41645__$1;
(statearr_41717_41906[(1)] = (120));

} else {
var statearr_41718_41907 = state_41645__$1;
(statearr_41718_41907[(1)] = (121));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (108))){
var inst_41373 = (state_41645[(10)]);
var inst_41604 = (state_41645[(25)]);
var inst_41604__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_41373);
var state_41645__$1 = (function (){var statearr_41719 = state_41645;
(statearr_41719[(25)] = inst_41604__$1);

return statearr_41719;
})();
if(cljs.core.truth_(inst_41604__$1)){
var statearr_41720_41908 = state_41645__$1;
(statearr_41720_41908[(1)] = (111));

} else {
var statearr_41721_41909 = state_41645__$1;
(statearr_41721_41909[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (56))){
var inst_41466 = (state_41645[(2)]);
var inst_41467 = fluree.db.util.async.throw_err(inst_41466);
var inst_41468 = cljs.core.not(inst_41467);
var state_41645__$1 = state_41645;
var statearr_41722_41910 = state_41645__$1;
(statearr_41722_41910[(2)] = inst_41468);

(statearr_41722_41910[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (33))){
var inst_41396 = (state_41645[(26)]);
var state_41645__$1 = state_41645;
var statearr_41723_41911 = state_41645__$1;
(statearr_41723_41911[(2)] = inst_41396);

(statearr_41723_41911[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (13))){
var inst_41391 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41391)){
var statearr_41724_41912 = state_41645__$1;
(statearr_41724_41912[(1)] = (17));

} else {
var statearr_41725_41913 = state_41645__$1;
(statearr_41725_41913[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (22))){
var inst_41422 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41422)){
var statearr_41726_41914 = state_41645__$1;
(statearr_41726_41914[(1)] = (32));

} else {
var statearr_41727_41915 = state_41645__$1;
(statearr_41727_41915[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (90))){
var inst_41545 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41728_41916 = state_41645__$1;
(statearr_41728_41916[(2)] = inst_41545);

(statearr_41728_41916[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (109))){
var inst_41602 = (state_41645[(27)]);
var state_41645__$1 = state_41645;
var statearr_41729_41917 = state_41645__$1;
(statearr_41729_41917[(2)] = inst_41602);

(statearr_41729_41917[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (36))){
var inst_41396 = (state_41645[(26)]);
var state_41645__$1 = state_41645;
var statearr_41730_41918 = state_41645__$1;
(statearr_41730_41918[(2)] = inst_41396);

(statearr_41730_41918[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (41))){
var inst_41373 = (state_41645[(10)]);
var inst_41441 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41442 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_41441);
var inst_41443 = inst_41442 === true;
var state_41645__$1 = state_41645;
var statearr_41731_41919 = state_41645__$1;
(statearr_41731_41919[(2)] = inst_41443);

(statearr_41731_41919[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (118))){
var inst_41600 = (state_41645[(7)]);
var state_41645__$1 = state_41645;
var statearr_41732_41920 = state_41645__$1;
(statearr_41732_41920[(2)] = inst_41600);

(statearr_41732_41920[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (89))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41543 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41504,inst_41505,throw_QMARK_);
var state_41645__$1 = state_41645;
var statearr_41733_41921 = state_41645__$1;
(statearr_41733_41921[(2)] = inst_41543);

(statearr_41733_41921[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (100))){
var inst_41492 = (state_41645[(12)]);
var state_41645__$1 = state_41645;
var statearr_41734_41922 = state_41645__$1;
(statearr_41734_41922[(2)] = inst_41492);

(statearr_41734_41922[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (122))){
var inst_41632 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41735_41923 = state_41645__$1;
(statearr_41735_41923[(2)] = inst_41632);

(statearr_41735_41923[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (43))){
var inst_41446 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41736_41924 = state_41645__$1;
(statearr_41736_41924[(2)] = inst_41446);

(statearr_41736_41924[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (61))){
var inst_41454 = (state_41645[(14)]);
var state_41645__$1 = state_41645;
var statearr_41737_41925 = state_41645__$1;
(statearr_41737_41925[(2)] = inst_41454);

(statearr_41737_41925[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (29))){
var inst_41373 = (state_41645[(10)]);
var inst_41408 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41409 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_41408);
var inst_41410 = inst_41409 === true;
var state_41645__$1 = state_41645;
var statearr_41738_41926 = state_41645__$1;
(statearr_41738_41926[(2)] = inst_41410);

(statearr_41738_41926[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (44))){
var inst_41435 = (state_41645[(28)]);
var inst_41451 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_41435,"a component","a non-component",throw_QMARK_);
var state_41645__$1 = state_41645;
var statearr_41739_41927 = state_41645__$1;
(statearr_41739_41927[(2)] = inst_41451);

(statearr_41739_41927[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (93))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41553 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41504,inst_41505,throw_QMARK_);
var state_41645__$1 = state_41645;
var statearr_41740_41928 = state_41645__$1;
(statearr_41740_41928[(2)] = inst_41553);

(statearr_41740_41928[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (6))){
var inst_41360 = (state_41645[(21)]);
var inst_41372 = (state_41645[(16)]);
var inst_41369 = cljs.core.seq(inst_41360);
var inst_41370 = cljs.core.first(inst_41369);
var inst_41371 = cljs.core.next(inst_41369);
var inst_41372__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41370,(0),null);
var inst_41373 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41370,(1),null);
var inst_41374 = cljs.core.not(inst_41372__$1);
var state_41645__$1 = (function (){var statearr_41741 = state_41645;
(statearr_41741[(10)] = inst_41373);

(statearr_41741[(20)] = inst_41371);

(statearr_41741[(16)] = inst_41372__$1);

return statearr_41741;
})();
if(inst_41374){
var statearr_41742_41929 = state_41645__$1;
(statearr_41742_41929[(1)] = (8));

} else {
var statearr_41743_41930 = state_41645__$1;
(statearr_41743_41930[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (111))){
var inst_41373 = (state_41645[(10)]);
var inst_41608 = (state_41645[(29)]);
var inst_41606 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41607 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_41606);
var inst_41608__$1 = inst_41607 === true;
var state_41645__$1 = (function (){var statearr_41744 = state_41645;
(statearr_41744[(29)] = inst_41608__$1);

return statearr_41744;
})();
if(cljs.core.truth_(inst_41608__$1)){
var statearr_41745_41931 = state_41645__$1;
(statearr_41745_41931[(1)] = (114));

} else {
var statearr_41746_41932 = state_41645__$1;
(statearr_41746_41932[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (28))){
var inst_41416 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41747_41933 = state_41645__$1;
(statearr_41747_41933[(2)] = inst_41416);

(statearr_41747_41933[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (64))){
var inst_41493 = (state_41645[(11)]);
var state_41645__$1 = state_41645;
var statearr_41748_41934 = state_41645__$1;
(statearr_41748_41934[(2)] = inst_41493);

(statearr_41748_41934[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (103))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41577 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_41578 = (inst_41505.cljs$core$IFn$_invoke$arity$5 ? inst_41505.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_41577,null) : inst_41505.call(null,cljs.core.PersistentArrayMap,null,2,inst_41577,null));
var inst_41579 = (inst_41505.cljs$core$IFn$_invoke$arity$4 ? inst_41505.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_41578,null) : inst_41505.call(null,cljs.core.PersistentHashSet,null,inst_41578,null));
var inst_41580 = (inst_41579.cljs$core$IFn$_invoke$arity$1 ? inst_41579.cljs$core$IFn$_invoke$arity$1(inst_41504) : inst_41579.call(null,inst_41504));
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41580)){
var statearr_41749_41935 = state_41645__$1;
(statearr_41749_41935[(1)] = (104));

} else {
var statearr_41750_41936 = state_41645__$1;
(statearr_41750_41936[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (51))){
var inst_41458 = (state_41645[(30)]);
var state_41645__$1 = state_41645;
var statearr_41751_41937 = state_41645__$1;
(statearr_41751_41937[(2)] = inst_41458);

(statearr_41751_41937[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (25))){
var inst_41419 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41752_41938 = state_41645__$1;
(statearr_41752_41938[(2)] = inst_41419);

(statearr_41752_41938[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (34))){
var inst_41373 = (state_41645[(10)]);
var inst_41436 = (state_41645[(18)]);
var inst_41435 = (state_41645[(2)]);
var inst_41436__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_41373);
var state_41645__$1 = (function (){var statearr_41753 = state_41645;
(statearr_41753[(28)] = inst_41435);

(statearr_41753[(18)] = inst_41436__$1);

return statearr_41753;
})();
if(cljs.core.truth_(inst_41436__$1)){
var statearr_41754_41939 = state_41645__$1;
(statearr_41754_41939[(1)] = (38));

} else {
var statearr_41755_41940 = state_41645__$1;
(statearr_41755_41940[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (17))){
var inst_41361 = (state_41645[(15)]);
var inst_41393 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_41361,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_41645__$1 = state_41645;
var statearr_41756_41941 = state_41645__$1;
(statearr_41756_41941[(2)] = inst_41393);

(statearr_41756_41941[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (3))){
var inst_41643 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41645__$1,inst_41643);
} else {
if((state_val_41646 === (12))){
var inst_41377 = (state_41645[(31)]);
var state_41645__$1 = state_41645;
var statearr_41757_41942 = state_41645__$1;
(statearr_41757_41942[(2)] = inst_41377);

(statearr_41757_41942[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (2))){
var _ = (function (){var statearr_41758 = state_41645;
(statearr_41758[(4)] = cljs.core.cons((5),(state_41645[(4)])));

return statearr_41758;
})();
var inst_41353 = pred_changes;
var inst_41354 = cljs.core.seq(inst_41353);
var inst_41355 = cljs.core.first(inst_41354);
var inst_41356 = cljs.core.next(inst_41354);
var inst_41357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41355,(0),null);
var inst_41358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41355,(1),null);
var inst_41359 = db;
var inst_41360 = inst_41353;
var inst_41361 = inst_41359;
var state_41645__$1 = (function (){var statearr_41759 = state_41645;
(statearr_41759[(32)] = inst_41356);

(statearr_41759[(33)] = inst_41357);

(statearr_41759[(21)] = inst_41360);

(statearr_41759[(34)] = inst_41358);

(statearr_41759[(15)] = inst_41361);

return statearr_41759;
})();
var statearr_41760_41943 = state_41645__$1;
(statearr_41760_41943[(2)] = null);

(statearr_41760_41943[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (66))){
var inst_41373 = (state_41645[(10)]);
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41502 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41503 = cljs.core.__destructure_map(inst_41502);
var inst_41504__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41503,cljs.core.cst$kw$old);
var inst_41505__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41503,cljs.core.cst$kw$new);
var inst_41506 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41505__$1,inst_41504__$1);
var state_41645__$1 = (function (){var statearr_41761 = state_41645;
(statearr_41761[(8)] = inst_41504__$1);

(statearr_41761[(9)] = inst_41505__$1);

return statearr_41761;
})();
if(inst_41506){
var statearr_41762_41944 = state_41645__$1;
(statearr_41762_41944[(1)] = (69));

} else {
var statearr_41763_41945 = state_41645__$1;
(statearr_41763_41945[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (107))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41587 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41504,inst_41505,throw_QMARK_);
var state_41645__$1 = state_41645;
var statearr_41764_41946 = state_41645__$1;
(statearr_41764_41946[(2)] = inst_41587);

(statearr_41764_41946[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (23))){
var inst_41373 = (state_41645[(10)]);
var inst_41402 = (state_41645[(17)]);
var inst_41401 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41402__$1 = inst_41401 === true;
var state_41645__$1 = (function (){var statearr_41765 = state_41645;
(statearr_41765[(17)] = inst_41402__$1);

return statearr_41765;
})();
if(cljs.core.truth_(inst_41402__$1)){
var statearr_41766_41947 = state_41645__$1;
(statearr_41766_41947[(1)] = (26));

} else {
var statearr_41767_41948 = state_41645__$1;
(statearr_41767_41948[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (47))){
var inst_41373 = (state_41645[(10)]);
var inst_41458 = (state_41645[(30)]);
var inst_41457 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41458__$1 = cljs.core.not(inst_41457);
var state_41645__$1 = (function (){var statearr_41768 = state_41645;
(statearr_41768[(30)] = inst_41458__$1);

return statearr_41768;
})();
if(inst_41458__$1){
var statearr_41769_41949 = state_41645__$1;
(statearr_41769_41949[(1)] = (50));

} else {
var statearr_41770_41950 = state_41645__$1;
(statearr_41770_41950[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (35))){
var inst_41425 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41426 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_41427 = cljs.core.PersistentHashMap.fromArrays(inst_41425,inst_41426);
var inst_41428 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_41427);
var inst_41429 = (function(){throw inst_41428})();
var state_41645__$1 = state_41645;
var statearr_41771_41951 = state_41645__$1;
(statearr_41771_41951[(2)] = inst_41429);

(statearr_41771_41951[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (82))){
var inst_41525 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41772_41952 = state_41645__$1;
(statearr_41772_41952[(2)] = inst_41525);

(statearr_41772_41952[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (76))){
var state_41645__$1 = state_41645;
var statearr_41773_41953 = state_41645__$1;
(statearr_41773_41953[(2)] = null);

(statearr_41773_41953[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (97))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41563 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41504,inst_41505,throw_QMARK_);
var state_41645__$1 = state_41645;
var statearr_41774_41954 = state_41645__$1;
(statearr_41774_41954[(2)] = inst_41563);

(statearr_41774_41954[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (19))){
var inst_41373 = (state_41645[(10)]);
var inst_41397 = (state_41645[(24)]);
var inst_41396 = (state_41645[(2)]);
var inst_41397__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_41373);
var state_41645__$1 = (function (){var statearr_41775 = state_41645;
(statearr_41775[(24)] = inst_41397__$1);

(statearr_41775[(26)] = inst_41396);

return statearr_41775;
})();
if(cljs.core.truth_(inst_41397__$1)){
var statearr_41776_41955 = state_41645__$1;
(statearr_41776_41955[(1)] = (20));

} else {
var statearr_41777_41956 = state_41645__$1;
(statearr_41777_41956[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (57))){
var state_41645__$1 = state_41645;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_41778_41957 = state_41645__$1;
(statearr_41778_41957[(1)] = (60));

} else {
var statearr_41779_41958 = state_41645__$1;
(statearr_41779_41958[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (68))){
var inst_41373 = (state_41645[(10)]);
var inst_41602 = (state_41645[(27)]);
var inst_41600 = (state_41645[(2)]);
var inst_41601 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41602__$1 = inst_41601 === true;
var state_41645__$1 = (function (){var statearr_41780 = state_41645;
(statearr_41780[(27)] = inst_41602__$1);

(statearr_41780[(7)] = inst_41600);

return statearr_41780;
})();
if(cljs.core.truth_(inst_41602__$1)){
var statearr_41781_41959 = state_41645__$1;
(statearr_41781_41959[(1)] = (108));

} else {
var statearr_41782_41960 = state_41645__$1;
(statearr_41782_41960[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (11))){
var inst_41381 = (state_41645[(23)]);
var inst_41373 = (state_41645[(10)]);
var inst_41379 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41380 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_41379);
var inst_41381__$1 = inst_41380 === false;
var state_41645__$1 = (function (){var statearr_41783 = state_41645;
(statearr_41783[(23)] = inst_41381__$1);

return statearr_41783;
})();
if(cljs.core.truth_(inst_41381__$1)){
var statearr_41784_41961 = state_41645__$1;
(statearr_41784_41961[(1)] = (14));

} else {
var statearr_41785_41962 = state_41645__$1;
(statearr_41785_41962[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (115))){
var inst_41608 = (state_41645[(29)]);
var state_41645__$1 = state_41645;
var statearr_41787_41963 = state_41645__$1;
(statearr_41787_41963[(2)] = inst_41608);

(statearr_41787_41963[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (9))){
var inst_41373 = (state_41645[(10)]);
var inst_41377 = (state_41645[(31)]);
var inst_41377__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_41373);
var state_41645__$1 = (function (){var statearr_41788 = state_41645;
(statearr_41788[(31)] = inst_41377__$1);

return statearr_41788;
})();
if(cljs.core.truth_(inst_41377__$1)){
var statearr_41789_41964 = state_41645__$1;
(statearr_41789_41964[(1)] = (11));

} else {
var statearr_41790_41965 = state_41645__$1;
(statearr_41790_41965[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (5))){
var _ = (function (){var statearr_41791 = state_41645;
(statearr_41791[(4)] = cljs.core.rest((state_41645[(4)])));

return statearr_41791;
})();
var state_41645__$1 = state_41645;
var ex41786 = (state_41645__$1[(2)]);
var statearr_41792_41966 = state_41645__$1;
(statearr_41792_41966[(5)] = ex41786);


if((ex41786 instanceof Error)){
var statearr_41793_41967 = state_41645__$1;
(statearr_41793_41967[(1)] = (4));

(statearr_41793_41967[(5)] = null);

} else {
throw ex41786;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (112))){
var inst_41604 = (state_41645[(25)]);
var state_41645__$1 = state_41645;
var statearr_41794_41968 = state_41645__$1;
(statearr_41794_41968[(2)] = inst_41604);

(statearr_41794_41968[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (83))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41527 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_41528 = (inst_41505.cljs$core$IFn$_invoke$arity$5 ? inst_41505.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_41527,null) : inst_41505.call(null,cljs.core.PersistentArrayMap,null,3,inst_41527,null));
var inst_41529 = (inst_41505.cljs$core$IFn$_invoke$arity$4 ? inst_41505.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_41528,null) : inst_41505.call(null,cljs.core.PersistentHashSet,null,inst_41528,null));
var inst_41530 = (inst_41529.cljs$core$IFn$_invoke$arity$1 ? inst_41529.cljs$core$IFn$_invoke$arity$1(inst_41504) : inst_41529.call(null,inst_41504));
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41530)){
var statearr_41795_41969 = state_41645__$1;
(statearr_41795_41969[(1)] = (84));

} else {
var statearr_41796_41970 = state_41645__$1;
(statearr_41796_41970[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (14))){
var inst_41373 = (state_41645[(10)]);
var inst_41383 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41384 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_41383);
var inst_41385 = inst_41384 === true;
var state_41645__$1 = state_41645;
var statearr_41797_41971 = state_41645__$1;
(statearr_41797_41971[(2)] = inst_41385);

(statearr_41797_41971[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (45))){
var inst_41435 = (state_41645[(28)]);
var state_41645__$1 = state_41645;
var statearr_41798_41972 = state_41645__$1;
(statearr_41798_41972[(2)] = inst_41435);

(statearr_41798_41972[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (53))){
var inst_41361 = (state_41645[(15)]);
var inst_41372 = (state_41645[(16)]);
var inst_41464 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_41361,inst_41372);
var state_41645__$1 = state_41645;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41645__$1,(56),inst_41464);
} else {
if((state_val_41646 === (78))){
var inst_41590 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41799_41973 = state_41645__$1;
(statearr_41799_41973[(2)] = inst_41590);

(statearr_41799_41973[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (26))){
var inst_41373 = (state_41645[(10)]);
var inst_41406 = (state_41645[(35)]);
var inst_41404 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41405 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_41404);
var inst_41406__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_41405);
var state_41645__$1 = (function (){var statearr_41800 = state_41645;
(statearr_41800[(35)] = inst_41406__$1);

return statearr_41800;
})();
if(inst_41406__$1){
var statearr_41801_41974 = state_41645__$1;
(statearr_41801_41974[(1)] = (29));

} else {
var statearr_41802_41975 = state_41645__$1;
(statearr_41802_41975[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (16))){
var inst_41388 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41803_41976 = state_41645__$1;
(statearr_41803_41976[(2)] = inst_41388);

(statearr_41803_41976[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (81))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41523 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41504,inst_41505,throw_QMARK_);
var state_41645__$1 = state_41645;
var statearr_41804_41977 = state_41645__$1;
(statearr_41804_41977[(2)] = inst_41523);

(statearr_41804_41977[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (120))){
var inst_41625 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41626 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_41627 = cljs.core.PersistentHashMap.fromArrays(inst_41625,inst_41626);
var inst_41628 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_41627);
var inst_41629 = (function(){throw inst_41628})();
var state_41645__$1 = state_41645;
var statearr_41805_41978 = state_41645__$1;
(statearr_41805_41978[(2)] = inst_41629);

(statearr_41805_41978[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (79))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41517 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_41518 = (inst_41505.cljs$core$IFn$_invoke$arity$5 ? inst_41505.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_41517,null) : inst_41505.call(null,cljs.core.PersistentArrayMap,null,2,inst_41517,null));
var inst_41519 = (inst_41505.cljs$core$IFn$_invoke$arity$4 ? inst_41505.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_41518,null) : inst_41505.call(null,cljs.core.PersistentHashSet,null,inst_41518,null));
var inst_41520 = (inst_41519.cljs$core$IFn$_invoke$arity$1 ? inst_41519.cljs$core$IFn$_invoke$arity$1(inst_41504) : inst_41519.call(null,inst_41504));
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41520)){
var statearr_41806_41979 = state_41645__$1;
(statearr_41806_41979[(1)] = (80));

} else {
var statearr_41807_41980 = state_41645__$1;
(statearr_41807_41980[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (38))){
var inst_41373 = (state_41645[(10)]);
var inst_41439 = (state_41645[(36)]);
var inst_41438 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41439__$1 = cljs.core.not(inst_41438);
var state_41645__$1 = (function (){var statearr_41808 = state_41645;
(statearr_41808[(36)] = inst_41439__$1);

return statearr_41808;
})();
if(inst_41439__$1){
var statearr_41809_41981 = state_41645__$1;
(statearr_41809_41981[(1)] = (41));

} else {
var statearr_41810_41982 = state_41645__$1;
(statearr_41810_41982[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (98))){
var inst_41565 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41811_41983 = state_41645__$1;
(statearr_41811_41983[(2)] = inst_41565);

(statearr_41811_41983[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (87))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41537 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_41538 = (inst_41505.cljs$core$IFn$_invoke$arity$5 ? inst_41505.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_41537,null) : inst_41505.call(null,cljs.core.PersistentArrayMap,null,3,inst_41537,null));
var inst_41539 = (inst_41505.cljs$core$IFn$_invoke$arity$4 ? inst_41505.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_41538,null) : inst_41505.call(null,cljs.core.PersistentHashSet,null,inst_41538,null));
var inst_41540 = (inst_41539.cljs$core$IFn$_invoke$arity$1 ? inst_41539.cljs$core$IFn$_invoke$arity$1(inst_41504) : inst_41539.call(null,inst_41504));
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41540)){
var statearr_41812_41984 = state_41645__$1;
(statearr_41812_41984[(1)] = (88));

} else {
var statearr_41813_41985 = state_41645__$1;
(statearr_41813_41985[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (30))){
var inst_41406 = (state_41645[(35)]);
var state_41645__$1 = state_41645;
var statearr_41814_41986 = state_41645__$1;
(statearr_41814_41986[(2)] = inst_41406);

(statearr_41814_41986[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (73))){
var state_41645__$1 = state_41645;
var statearr_41815_41987 = state_41645__$1;
(statearr_41815_41987[(1)] = (75));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (96))){
var inst_41492 = (state_41645[(12)]);
var state_41645__$1 = state_41645;
var statearr_41817_41988 = state_41645__$1;
(statearr_41817_41988[(2)] = inst_41492);

(statearr_41817_41988[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (10))){
var inst_41638 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41818_41989 = state_41645__$1;
(statearr_41818_41989[(2)] = inst_41638);

(statearr_41818_41989[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (18))){
var inst_41361 = (state_41645[(15)]);
var state_41645__$1 = state_41645;
var statearr_41819_41990 = state_41645__$1;
(statearr_41819_41990[(2)] = inst_41361);

(statearr_41819_41990[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (105))){
var inst_41504 = (state_41645[(8)]);
var inst_41505 = (state_41645[(9)]);
var inst_41583 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41504,inst_41505,throw_QMARK_);
var state_41645__$1 = state_41645;
var statearr_41820_41991 = state_41645__$1;
(statearr_41820_41991[(2)] = inst_41583);

(statearr_41820_41991[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (52))){
var inst_41474 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41821_41992 = state_41645__$1;
(statearr_41821_41992[(2)] = inst_41474);

(statearr_41821_41992[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (114))){
var inst_41373 = (state_41645[(10)]);
var inst_41610 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41611 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_41610);
var inst_41612 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_41611);
var inst_41613 = (!(inst_41612));
var state_41645__$1 = state_41645;
var statearr_41822_41993 = state_41645__$1;
(statearr_41822_41993[(2)] = inst_41613);

(statearr_41822_41993[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (67))){
var inst_41492 = (state_41645[(12)]);
var state_41645__$1 = state_41645;
var statearr_41823_41994 = state_41645__$1;
(statearr_41823_41994[(2)] = inst_41492);

(statearr_41823_41994[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (71))){
var inst_41597 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41824_41995 = state_41645__$1;
(statearr_41824_41995[(2)] = inst_41597);

(statearr_41824_41995[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (42))){
var inst_41439 = (state_41645[(36)]);
var state_41645__$1 = state_41645;
var statearr_41825_41996 = state_41645__$1;
(statearr_41825_41996[(2)] = inst_41439);

(statearr_41825_41996[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (80))){
var inst_41492 = (state_41645[(12)]);
var state_41645__$1 = state_41645;
var statearr_41826_41997 = state_41645__$1;
(statearr_41826_41997[(2)] = inst_41492);

(statearr_41826_41997[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (37))){
var inst_41432 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41827_41998 = state_41645__$1;
(statearr_41827_41998[(2)] = inst_41432);

(statearr_41827_41998[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (63))){
var inst_41373 = (state_41645[(10)]);
var inst_41495 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_41373);
var inst_41496 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_41495);
var state_41645__$1 = state_41645;
var statearr_41828_41999 = state_41645__$1;
(statearr_41828_41999[(2)] = inst_41496);

(statearr_41828_41999[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (94))){
var inst_41555 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
var statearr_41829_42000 = state_41645__$1;
(statearr_41829_42000[(2)] = inst_41555);

(statearr_41829_42000[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (8))){
var inst_41361 = (state_41645[(15)]);
var state_41645__$1 = state_41645;
var statearr_41830_42001 = state_41645__$1;
(statearr_41830_42001[(2)] = inst_41361);

(statearr_41830_42001[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (49))){
var inst_41477 = (state_41645[(2)]);
var state_41645__$1 = state_41645;
if(cljs.core.truth_(inst_41477)){
var statearr_41831_42002 = state_41645__$1;
(statearr_41831_42002[(1)] = (57));

} else {
var statearr_41832_42003 = state_41645__$1;
(statearr_41832_42003[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41646 === (84))){
var inst_41492 = (state_41645[(12)]);
var state_41645__$1 = state_41645;
var statearr_41833_42004 = state_41645__$1;
(statearr_41833_42004[(2)] = inst_41492);

(statearr_41833_42004[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__20477__auto__ = null;
var fluree$db$query$schema$state_machine__20477__auto____0 = (function (){
var statearr_41834 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41834[(0)] = fluree$db$query$schema$state_machine__20477__auto__);

(statearr_41834[(1)] = (1));

return statearr_41834;
});
var fluree$db$query$schema$state_machine__20477__auto____1 = (function (state_41645){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_41645);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e41835){var ex__20480__auto__ = e41835;
var statearr_41836_42005 = state_41645;
(statearr_41836_42005[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_41645[(4)]))){
var statearr_41837_42006 = state_41645;
(statearr_41837_42006[(1)] = cljs.core.first((state_41645[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__42007 = state_41645;
state_41645 = G__42007;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__20477__auto__ = function(state_41645){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__20477__auto____1.call(this,state_41645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__20477__auto____0;
fluree$db$query$schema$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__20477__auto____1;
return fluree$db$query$schema$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_41838 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_41838[(6)] = c__20603__auto__);

return statearr_41838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__42009 = arguments.length;
switch (G__42009) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_42033){
var state_val_42034 = (state_42033[(1)]);
if((state_val_42034 === (7))){
var state_42033__$1 = state_42033;
var statearr_42035_42055 = state_42033__$1;
(statearr_42035_42055[(2)] = db);

(statearr_42035_42055[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42034 === (1))){
var state_42033__$1 = state_42033;
var statearr_42036_42056 = state_42033__$1;
(statearr_42036_42056[(2)] = null);

(statearr_42036_42056[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42034 === (4))){
var inst_42010 = (state_42033[(2)]);
var state_42033__$1 = state_42033;
var statearr_42037_42057 = state_42033__$1;
(statearr_42037_42057[(2)] = inst_42010);

(statearr_42037_42057[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42034 === (6))){
var inst_42019 = (state_42033[(7)]);
var inst_42018 = (state_42033[(2)]);
var inst_42019__$1 = fluree.db.util.async.throw_err(inst_42018);
var inst_42020 = cljs.core.empty_QMARK_(inst_42019__$1);
var state_42033__$1 = (function (){var statearr_42038 = state_42033;
(statearr_42038[(7)] = inst_42019__$1);

return statearr_42038;
})();
if(inst_42020){
var statearr_42039_42058 = state_42033__$1;
(statearr_42039_42058[(1)] = (7));

} else {
var statearr_42040_42059 = state_42033__$1;
(statearr_42040_42059[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42034 === (3))){
var inst_42031 = (state_42033[(2)]);
var state_42033__$1 = state_42033;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42033__$1,inst_42031);
} else {
if((state_val_42034 === (2))){
var _ = (function (){var statearr_42042 = state_42033;
(statearr_42042[(4)] = cljs.core.cons((5),(state_42033[(4)])));

return statearr_42042;
})();
var inst_42016 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_42033__$1 = state_42033;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42033__$1,(6),inst_42016);
} else {
if((state_val_42034 === (9))){
var inst_42028 = (state_42033[(2)]);
var _ = (function (){var statearr_42043 = state_42033;
(statearr_42043[(4)] = cljs.core.rest((state_42033[(4)])));

return statearr_42043;
})();
var state_42033__$1 = state_42033;
var statearr_42044_42060 = state_42033__$1;
(statearr_42044_42060[(2)] = inst_42028);

(statearr_42044_42060[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42034 === (5))){
var _ = (function (){var statearr_42045 = state_42033;
(statearr_42045[(4)] = cljs.core.rest((state_42033[(4)])));

return statearr_42045;
})();
var state_42033__$1 = state_42033;
var ex42041 = (state_42033__$1[(2)]);
var statearr_42046_42061 = state_42033__$1;
(statearr_42046_42061[(5)] = ex42041);


if((ex42041 instanceof Error)){
var statearr_42047_42062 = state_42033__$1;
(statearr_42047_42062[(1)] = (4));

(statearr_42047_42062[(5)] = null);

} else {
throw ex42041;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42034 === (10))){
var inst_42025 = (state_42033[(2)]);
var inst_42026 = fluree.db.util.async.throw_err(inst_42025);
var state_42033__$1 = state_42033;
var statearr_42048_42063 = state_42033__$1;
(statearr_42048_42063[(2)] = inst_42026);

(statearr_42048_42063[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42034 === (8))){
var inst_42019 = (state_42033[(7)]);
var inst_42023 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_42019,db,true);
var state_42033__$1 = state_42033;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42033__$1,(10),inst_42023);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__20477__auto__ = null;
var fluree$db$query$schema$state_machine__20477__auto____0 = (function (){
var statearr_42049 = [null,null,null,null,null,null,null,null];
(statearr_42049[(0)] = fluree$db$query$schema$state_machine__20477__auto__);

(statearr_42049[(1)] = (1));

return statearr_42049;
});
var fluree$db$query$schema$state_machine__20477__auto____1 = (function (state_42033){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_42033);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e42050){var ex__20480__auto__ = e42050;
var statearr_42051_42064 = state_42033;
(statearr_42051_42064[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_42033[(4)]))){
var statearr_42052_42065 = state_42033;
(statearr_42052_42065[(1)] = cljs.core.first((state_42033[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__42066 = state_42033;
state_42033 = G__42066;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__20477__auto__ = function(state_42033){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__20477__auto____1.call(this,state_42033);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__20477__auto____0;
fluree$db$query$schema$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__20477__auto____1;
return fluree$db$query$schema$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_42053 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_42053[(6)] = c__20603__auto__);

return statearr_42053;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__42068 = arguments.length;
switch (G__42068) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__42070 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42070,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42070,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42070,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4221__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4221__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__42073_SHARP_,p2__42074_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42073_SHARP_,p2__42074_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__42075_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,p1__42075_SHARP_.p)){
return p1__42075_SHARP_.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_42141){
var state_val_42142 = (state_42141[(1)]);
if((state_val_42142 === (1))){
var state_42141__$1 = state_42141;
var statearr_42143_42161 = state_42141__$1;
(statearr_42143_42161[(2)] = null);

(statearr_42143_42161[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42142 === (2))){
var _ = (function (){var statearr_42144 = state_42141;
(statearr_42144[(4)] = cljs.core.cons((5),(state_42141[(4)])));

return statearr_42144;
})();
var inst_42093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42094 = fluree.db.flake.max_subject_id((1));
var inst_42095 = [inst_42094];
var inst_42096 = (new cljs.core.PersistentVector(null,1,(5),inst_42093,inst_42095,null));
var inst_42097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42098 = [(0)];
var inst_42099 = (new cljs.core.PersistentVector(null,1,(5),inst_42097,inst_42098,null));
var inst_42100 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_42096,cljs.core._LT__EQ_,inst_42099);
var state_42141__$1 = state_42141;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42141__$1,(6),inst_42100);
} else {
if((state_val_42142 === (3))){
var inst_42139 = (state_42141[(2)]);
var state_42141__$1 = state_42141;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42141__$1,inst_42139);
} else {
if((state_val_42142 === (4))){
var inst_42081 = (state_42141[(2)]);
var state_42141__$1 = state_42141;
var statearr_42146_42162 = state_42141__$1;
(statearr_42146_42162[(2)] = inst_42081);

(statearr_42146_42162[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42142 === (5))){
var _ = (function (){var statearr_42147 = state_42141;
(statearr_42147[(4)] = cljs.core.rest((state_42141[(4)])));

return statearr_42147;
})();
var state_42141__$1 = state_42141;
var ex42145 = (state_42141__$1[(2)]);
var statearr_42148_42163 = state_42141__$1;
(statearr_42148_42163[(5)] = ex42145);


if((ex42145 instanceof Error)){
var statearr_42149_42164 = state_42141__$1;
(statearr_42149_42164[(1)] = (4));

(statearr_42149_42164[(5)] = null);

} else {
throw ex42145;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42142 === (6))){
var inst_42102 = (state_42141[(2)]);
var inst_42103 = fluree.db.util.async.throw_err(inst_42102);
var inst_42104 = (function (){var schema_flakes = inst_42103;
return (function (p1__42076_SHARP_){
return (p1__42076_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_42105 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_42104,inst_42103);
var inst_42106 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42105,(0),null);
var inst_42107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42105,(1),null);
var inst_42108 = (function (){var schema_flakes = inst_42103;
var vec__42087 = inst_42105;
var collection_flakes = inst_42106;
var predicate_flakes = inst_42107;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__42078_SHARP_,p2__42079_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__42078_SHARP_,p2__42079_SHARP_.p,p2__42079_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,specs,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,partition,cljs.core.cst$kw$partition,partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_42109 = [(-1),"_tx"];
var inst_42110 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_42111 = ["_tx",(-1),(-1)];
var inst_42112 = cljs.core.PersistentHashMap.fromArrays(inst_42110,inst_42111);
var inst_42113 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_42114 = ["_tx",(-1),(-1)];
var inst_42115 = cljs.core.PersistentHashMap.fromArrays(inst_42113,inst_42114);
var inst_42116 = [inst_42112,inst_42115];
var inst_42117 = cljs.core.PersistentHashMap.fromArrays(inst_42109,inst_42116);
var inst_42118 = (function (){var schema_flakes = inst_42103;
var vec__42087 = inst_42105;
var collection_flakes = inst_42106;
var predicate_flakes = inst_42107;
return (function (p1__42077_SHARP_){
return p1__42077_SHARP_.s;
});
})();
var inst_42119 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_42118,inst_42106);
var inst_42120 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_42108,inst_42117,inst_42119);
var inst_42122 = (function (){var schema_flakes = inst_42103;
var vec__42087 = inst_42105;
var collection_flakes = inst_42106;
var predicate_flakes = inst_42107;
var coll = inst_42120;
return (function (p__42121,pred_flakes){
var vec__42150 = p__42121;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42150,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42150,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__42153 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__42153.cljs$core$IFn$_invoke$arity$1 ? fexpr__42153.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__42153.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4223__auto__ = ref_QMARK_;
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$retractDuplicates,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_42123 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42124 = cljs.core.PersistentHashMap.EMPTY;
var inst_42125 = cljs.core.PersistentHashSet.EMPTY;
var inst_42126 = [inst_42124,inst_42125];
var inst_42127 = (new cljs.core.PersistentVector(null,2,(5),inst_42123,inst_42126,null));
var inst_42128 = (function (){var schema_flakes = inst_42103;
var vec__42087 = inst_42105;
var collection_flakes = inst_42106;
var predicate_flakes = inst_42107;
var coll = inst_42120;
return (function (p1__42080_SHARP_){
return p1__42080_SHARP_.s;
});
})();
var inst_42129 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_42128,inst_42107);
var inst_42130 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_42122,inst_42127,inst_42129);
var inst_42131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42130,(0),null);
var inst_42132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42130,(1),null);
var inst_42133 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_42134 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_42135 = [inst_42134,inst_42120,inst_42131,inst_42132];
var inst_42136 = cljs.core.PersistentHashMap.fromArrays(inst_42133,inst_42135);
var _ = (function (){var statearr_42154 = state_42141;
(statearr_42154[(4)] = cljs.core.rest((state_42141[(4)])));

return statearr_42154;
})();
var state_42141__$1 = state_42141;
var statearr_42155_42165 = state_42141__$1;
(statearr_42155_42165[(2)] = inst_42136);

(statearr_42155_42165[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__20477__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__20477__auto____0 = (function (){
var statearr_42156 = [null,null,null,null,null,null,null];
(statearr_42156[(0)] = fluree$db$query$schema$schema_map_$_state_machine__20477__auto__);

(statearr_42156[(1)] = (1));

return statearr_42156;
});
var fluree$db$query$schema$schema_map_$_state_machine__20477__auto____1 = (function (state_42141){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_42141);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e42157){var ex__20480__auto__ = e42157;
var statearr_42158_42166 = state_42141;
(statearr_42158_42166[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_42141[(4)]))){
var statearr_42159_42167 = state_42141;
(statearr_42159_42167[(1)] = cljs.core.first((state_42141[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__42168 = state_42141;
state_42141 = G__42168;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__20477__auto__ = function(state_42141){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__20477__auto____1.call(this,state_42141);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__20477__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__20477__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_42160 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_42160[(6)] = c__20603__auto__);

return statearr_42160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_42210){
var state_val_42211 = (state_42210[(1)]);
if((state_val_42211 === (7))){
var inst_42193 = (state_42210[(2)]);
var inst_42194 = fluree.db.query.schema.flake__GT_pred_map(inst_42193);
var inst_42195 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_42196 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42194,(114));
var inst_42197 = cljs.core.boolean$(inst_42196);
var inst_42198 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42194,(110));
var inst_42199 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42194,(117));
var inst_42200 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_42199);
var inst_42201 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42194,(111));
var inst_42202 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42194,(115));
var inst_42203 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42194,(112));
var inst_42204 = [inst_42197,inst_42198,inst_42200,inst_42201,inst_42202,inst_42203];
var inst_42205 = cljs.core.PersistentHashMap.fromArrays(inst_42195,inst_42204);
var _ = (function (){var statearr_42212 = state_42210;
(statearr_42212[(4)] = cljs.core.rest((state_42210[(4)])));

return statearr_42212;
})();
var state_42210__$1 = state_42210;
var statearr_42213_42236 = state_42210__$1;
(statearr_42213_42236[(2)] = inst_42205);

(statearr_42213_42236[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42211 === (1))){
var state_42210__$1 = state_42210;
var statearr_42214_42237 = state_42210__$1;
(statearr_42214_42237[(2)] = null);

(statearr_42214_42237[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42211 === (4))){
var inst_42169 = (state_42210[(2)]);
var state_42210__$1 = state_42210;
var statearr_42215_42238 = state_42210__$1;
(statearr_42215_42238[(2)] = inst_42169);

(statearr_42215_42238[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42211 === (6))){
var _ = (function (){var statearr_42216 = state_42210;
(statearr_42216[(4)] = cljs.core.cons((9),(state_42210[(4)])));

return statearr_42216;
})();
var inst_42181 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42183 = ["_setting/id","root"];
var inst_42184 = (new cljs.core.PersistentVector(null,2,(5),inst_42182,inst_42183,null));
var inst_42185 = [inst_42184];
var inst_42186 = (new cljs.core.PersistentVector(null,1,(5),inst_42181,inst_42185,null));
var inst_42187 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_42186);
var state_42210__$1 = state_42210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42210__$1,(10),inst_42187);
} else {
if((state_val_42211 === (3))){
var inst_42208 = (state_42210[(2)]);
var state_42210__$1 = state_42210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42210__$1,inst_42208);
} else {
if((state_val_42211 === (2))){
var _ = (function (){var statearr_42219 = state_42210;
(statearr_42219[(4)] = cljs.core.cons((5),(state_42210[(4)])));

return statearr_42219;
})();
var state_42210__$1 = state_42210;
var statearr_42220_42239 = state_42210__$1;
(statearr_42220_42239[(2)] = null);

(statearr_42220_42239[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42211 === (9))){
var _ = (function (){var statearr_42221 = state_42210;
(statearr_42221[(4)] = cljs.core.rest((state_42210[(4)])));

return statearr_42221;
})();
var state_42210__$1 = state_42210;
var ex42217 = (state_42210__$1[(2)]);
var statearr_42222_42240 = state_42210__$1;
(statearr_42222_42240[(5)] = ex42217);


var statearr_42223_42241 = state_42210__$1;
(statearr_42223_42241[(1)] = (8));

(statearr_42223_42241[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42211 === (5))){
var _ = (function (){var statearr_42224 = state_42210;
(statearr_42224[(4)] = cljs.core.rest((state_42210[(4)])));

return statearr_42224;
})();
var state_42210__$1 = state_42210;
var ex42218 = (state_42210__$1[(2)]);
var statearr_42225_42242 = state_42210__$1;
(statearr_42225_42242[(5)] = ex42218);


if((ex42218 instanceof Error)){
var statearr_42226_42243 = state_42210__$1;
(statearr_42226_42243[(1)] = (4));

(statearr_42226_42243[(5)] = null);

} else {
throw ex42218;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42211 === (10))){
var inst_42189 = (state_42210[(2)]);
var inst_42190 = fluree.db.util.async.throw_err(inst_42189);
var _ = (function (){var statearr_42227 = state_42210;
(statearr_42227[(4)] = cljs.core.rest((state_42210[(4)])));

return statearr_42227;
})();
var state_42210__$1 = state_42210;
var statearr_42228_42244 = state_42210__$1;
(statearr_42228_42244[(2)] = inst_42190);

(statearr_42228_42244[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42211 === (8))){
var inst_42175 = (state_42210[(2)]);
var state_42210__$1 = (function (){var statearr_42229 = state_42210;
(statearr_42229[(7)] = inst_42175);

return statearr_42229;
})();
var statearr_42230_42245 = state_42210__$1;
(statearr_42230_42245[(2)] = null);

(statearr_42230_42245[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__20477__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__20477__auto____0 = (function (){
var statearr_42231 = [null,null,null,null,null,null,null,null];
(statearr_42231[(0)] = fluree$db$query$schema$setting_map_$_state_machine__20477__auto__);

(statearr_42231[(1)] = (1));

return statearr_42231;
});
var fluree$db$query$schema$setting_map_$_state_machine__20477__auto____1 = (function (state_42210){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_42210);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e42232){var ex__20480__auto__ = e42232;
var statearr_42233_42246 = state_42210;
(statearr_42233_42246[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_42210[(4)]))){
var statearr_42234_42247 = state_42210;
(statearr_42234_42247[(1)] = cljs.core.first((state_42210[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__42248 = state_42210;
state_42210 = G__42248;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__20477__auto__ = function(state_42210){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__20477__auto____1.call(this,state_42210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__20477__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__20477__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_42235 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_42235[(6)] = c__20603__auto__);

return statearr_42235;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
