// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__38966_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__38966_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__38970 = coll;
var vec__38971 = G__38970;
var seq__38972 = cljs.core.seq(vec__38971);
var first__38973 = cljs.core.first(seq__38972);
var seq__38972__$1 = cljs.core.next(seq__38972);
var clause = first__38973;
var r = seq__38972__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__38970__$1 = G__38970;
var res__$1 = res;
while(true){
var vec__38977 = G__38970__$1;
var seq__38978 = cljs.core.seq(vec__38977);
var first__38979 = cljs.core.first(seq__38978);
var seq__38978__$1 = cljs.core.next(seq__38978);
var clause__$1 = first__38979;
var r__$1 = seq__38978__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__38980 = r__$1;
var G__38981 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__38970__$1 = G__38980;
res__$1 = G__38981;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__38982){
var map__38983 = p__38982;
var map__38983__$1 = cljs.core.__destructure_map(map__38983);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38983__$1,cljs.core.cst$kw$optional);
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__38987 = coll;
var vec__38988 = G__38987;
var seq__38989 = cljs.core.seq(vec__38988);
var first__38990 = cljs.core.first(seq__38989);
var seq__38989__$1 = cljs.core.next(seq__38989);
var clause = first__38990;
var r = seq__38989__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__38987__$1 = G__38987;
var res__$1 = res;
while(true){
var vec__38994 = G__38987__$1;
var seq__38995 = cljs.core.seq(vec__38994);
var first__38996 = cljs.core.first(seq__38995);
var seq__38995__$1 = cljs.core.next(seq__38995);
var clause__$1 = first__38996;
var r__$1 = seq__38995__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__38997 = r__$1;
var G__38998 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__38987__$1 = G__38997;
res__$1 = G__38998;
continue;
} else {
var G__38999 = r__$1;
var G__39000 = res__$2;
G__38987__$1 = G__38999;
res__$1 = G__39000;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__39004 = coll;
var vec__39005 = G__39004;
var seq__39006 = cljs.core.seq(vec__39005);
var first__39007 = cljs.core.first(seq__39006);
var seq__39006__$1 = cljs.core.next(seq__39006);
var clause = first__39007;
var r = seq__39006__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__39004__$1 = G__39004;
var res__$1 = res;
while(true){
var vec__39011 = G__39004__$1;
var seq__39012 = cljs.core.seq(vec__39011);
var first__39013 = cljs.core.first(seq__39012);
var seq__39012__$1 = cljs.core.next(seq__39012);
var clause__$1 = first__39013;
var r__$1 = seq__39012__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__39014 = r__$1;
var G__39015 = res__$2;
G__39004__$1 = G__39014;
res__$1 = G__39015;
continue;
} else {
var G__39016 = r__$1;
var G__39017 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__39004__$1 = G__39016;
res__$1 = G__39017;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_((function (){var and__4221__auto__ = typeof string === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string);
} else {
return and__4221__auto__;
}
})())){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__39018 = clause;
var G__39018__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__39018):G__39018);
var G__39018__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,G__39018__$1)
;
var G__39018__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__39018__$2)
;
var G__39018__$4 = goog.string.format("%s .",G__39018__$3)
;
if(cljs.core.truth_(optional_QMARK_)){
return goog.string.format("OPTIONAL {%s}",G__39018__$4);
} else {
return G__39018__$4;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__39022 = opts;
var map__39022__$1 = cljs.core.__destructure_map(map__39022);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39022__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39022__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39022__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39022__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39022__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39019_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__39019_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__39020_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__39020_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__39021_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__39021_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4223__auto__ = language;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_39036){
var state_val_39037 = (state_39036[(1)]);
if((state_val_39037 === (1))){
var inst_39023 = fluree.db.util.core.url_encode(query);
var inst_39024 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39023)].join('');
var inst_39025 = ["User-Agent","Accept"];
var inst_39026 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_39027 = cljs.core.PersistentHashMap.fromArrays(inst_39025,inst_39026);
var inst_39028 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_39029 = [inst_39027,(30000),cljs.core.cst$kw$wikidata];
var inst_39030 = cljs.core.PersistentHashMap.fromArrays(inst_39028,inst_39029);
var inst_39031 = fluree.db.util.xhttp.get(inst_39024,inst_39030);
var state_39036__$1 = state_39036;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39036__$1,(2),inst_39031);
} else {
if((state_val_39037 === (2))){
var inst_39033 = (state_39036[(2)]);
var inst_39034 = fluree.db.util.async.throw_err(inst_39033);
var state_39036__$1 = state_39036;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39036__$1,inst_39034);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__20477__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__20477__auto____0 = (function (){
var statearr_39038 = [null,null,null,null,null,null,null];
(statearr_39038[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__20477__auto__);

(statearr_39038[(1)] = (1));

return statearr_39038;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__20477__auto____1 = (function (state_39036){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_39036);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e39039){var ex__20480__auto__ = e39039;
var statearr_39040_39043 = state_39036;
(statearr_39040_39043[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_39036[(4)]))){
var statearr_39041_39044 = state_39036;
(statearr_39041_39044[(1)] = cljs.core.first((state_39036[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__39045 = state_39036;
state_39036 = G__39045;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__20477__auto__ = function(state_39036){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__20477__auto____1.call(this,state_39036);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__20477__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__20477__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_39042 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_39042[(6)] = c__20603__auto__);

return statearr_39042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_39063){
var state_val_39064 = (state_39063[(1)]);
if((state_val_39064 === (1))){
var inst_39046 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_39063__$1 = state_39063;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39063__$1,(2),inst_39046);
} else {
if((state_val_39064 === (2))){
var inst_39049 = (state_39063[(7)]);
var inst_39048 = (state_39063[(2)]);
var inst_39049__$1 = fluree.db.util.async.throw_err(inst_39048);
var inst_39050 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_39049__$1);
var inst_39051 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_39050);
var state_39063__$1 = (function (){var statearr_39065 = state_39063;
(statearr_39065[(7)] = inst_39049__$1);

return statearr_39065;
})();
if(inst_39051){
var statearr_39066_39075 = state_39063__$1;
(statearr_39066_39075[(1)] = (3));

} else {
var statearr_39067_39076 = state_39063__$1;
(statearr_39067_39076[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39064 === (3))){
var inst_39049 = (state_39063[(7)]);
var state_39063__$1 = state_39063;
var statearr_39068_39077 = state_39063__$1;
(statearr_39068_39077[(2)] = inst_39049);

(statearr_39068_39077[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39064 === (4))){
var inst_39049 = (state_39063[(7)]);
var inst_39054 = (function (){var body = inst_39049;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_39055 = cljs.core.second(inst_39049);
var inst_39056 = cljs.core.second(inst_39055);
var inst_39057 = cljs.core.first(inst_39056);
var inst_39058 = cljs.core.second(inst_39057);
var inst_39059 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_39054,inst_39058);
var state_39063__$1 = state_39063;
var statearr_39069_39078 = state_39063__$1;
(statearr_39069_39078[(2)] = inst_39059);

(statearr_39069_39078[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39064 === (5))){
var inst_39061 = (state_39063[(2)]);
var state_39063__$1 = state_39063;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39063__$1,inst_39061);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__20477__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__20477__auto____0 = (function (){
var statearr_39070 = [null,null,null,null,null,null,null,null];
(statearr_39070[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__20477__auto__);

(statearr_39070[(1)] = (1));

return statearr_39070;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__20477__auto____1 = (function (state_39063){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_39063);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e39071){var ex__20480__auto__ = e39071;
var statearr_39072_39079 = state_39063;
(statearr_39072_39079[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_39063[(4)]))){
var statearr_39073_39080 = state_39063;
(statearr_39073_39080[(1)] = cljs.core.first((state_39063[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__39081 = state_39063;
state_39063 = G__39081;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__20477__auto__ = function(state_39063){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__20477__auto____1.call(this,state_39063);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__20477__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__20477__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_39074 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_39074[(6)] = c__20603__auto__);

return statearr_39074;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39082_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__39082_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39083_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__39083_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39084_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__39084_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__39084_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__39084_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_39130){
var state_val_39131 = (state_39130[(1)]);
if((state_val_39131 === (7))){
var inst_39095 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_39130__$1 = state_39130;
var statearr_39132_39160 = state_39130__$1;
(statearr_39132_39160[(2)] = inst_39095);

(statearr_39132_39160[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (1))){
var state_39130__$1 = state_39130;
var statearr_39133_39161 = state_39130__$1;
(statearr_39133_39161[(2)] = null);

(statearr_39133_39161[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (4))){
var inst_39085 = (state_39130[(2)]);
var state_39130__$1 = state_39130;
var statearr_39134_39162 = state_39130__$1;
(statearr_39134_39162[(2)] = inst_39085);

(statearr_39134_39162[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (15))){
var inst_39104 = (state_39130[(7)]);
var inst_39109 = (state_39130[(8)]);
var inst_39103 = (state_39130[(9)]);
var inst_39114 = (state_39130[(2)]);
var inst_39115 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_39109,(0),inst_39114);
var inst_39116 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39117 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_39103);
var inst_39118 = [inst_39104,inst_39117];
var inst_39119 = cljs.core.PersistentHashMap.fromArrays(inst_39116,inst_39118);
var inst_39120 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39115,inst_39119);
var inst_39121 = (function(){throw inst_39120})();
var state_39130__$1 = state_39130;
var statearr_39135_39163 = state_39130__$1;
(statearr_39135_39163[(2)] = inst_39121);

(statearr_39135_39163[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (13))){
var inst_39108 = (state_39130[(10)]);
var state_39130__$1 = state_39130;
var statearr_39136_39164 = state_39130__$1;
(statearr_39136_39164[(2)] = inst_39108);

(statearr_39136_39164[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (6))){
var state_39130__$1 = state_39130;
var statearr_39137_39165 = state_39130__$1;
(statearr_39137_39165[(2)] = null);

(statearr_39137_39165[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (3))){
var inst_39128 = (state_39130[(2)]);
var state_39130__$1 = state_39130;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39130__$1,inst_39128);
} else {
if((state_val_39131 === (12))){
var inst_39125 = (state_39130[(2)]);
var _ = (function (){var statearr_39138 = state_39130;
(statearr_39138[(4)] = cljs.core.rest((state_39130[(4)])));

return statearr_39138;
})();
var state_39130__$1 = state_39130;
var statearr_39139_39166 = state_39130__$1;
(statearr_39139_39166[(2)] = inst_39125);

(statearr_39139_39166[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (2))){
var _ = (function (){var statearr_39140 = state_39130;
(statearr_39140[(4)] = cljs.core.cons((5),(state_39130[(4)])));

return statearr_39140;
})();
var inst_39092 = cljs.core.empty_QMARK_(matching_vars);
var state_39130__$1 = state_39130;
if(inst_39092){
var statearr_39141_39167 = state_39130__$1;
(statearr_39141_39167[(1)] = (6));

} else {
var statearr_39142_39168 = state_39130__$1;
(statearr_39142_39168[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (11))){
var inst_39103 = (state_39130[(9)]);
var inst_39123 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_39103,all_vars);
var state_39130__$1 = state_39130;
var statearr_39144_39169 = state_39130__$1;
(statearr_39144_39169[(2)] = inst_39123);

(statearr_39144_39169[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (9))){
var inst_39104 = (state_39130[(7)]);
var inst_39103 = (state_39130[(9)]);
var inst_39101 = (state_39130[(2)]);
var inst_39102 = fluree.db.util.async.throw_err(inst_39101);
var inst_39103__$1 = cljs.core.__destructure_map(inst_39102);
var inst_39104__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39103__$1,cljs.core.cst$kw$status);
var inst_39105 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39103__$1,cljs.core.cst$kw$message);
var inst_39106 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_39104__$1);
var state_39130__$1 = (function (){var statearr_39145 = state_39130;
(statearr_39145[(11)] = inst_39105);

(statearr_39145[(7)] = inst_39104__$1);

(statearr_39145[(9)] = inst_39103__$1);

return statearr_39145;
})();
if(inst_39106){
var statearr_39146_39170 = state_39130__$1;
(statearr_39146_39170[(1)] = (10));

} else {
var statearr_39147_39171 = state_39130__$1;
(statearr_39147_39171[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (5))){
var _ = (function (){var statearr_39148 = state_39130;
(statearr_39148[(4)] = cljs.core.rest((state_39130[(4)])));

return statearr_39148;
})();
var state_39130__$1 = state_39130;
var ex39143 = (state_39130__$1[(2)]);
var statearr_39149_39172 = state_39130__$1;
(statearr_39149_39172[(5)] = ex39143);


if((ex39143 instanceof Error)){
var statearr_39150_39173 = state_39130__$1;
(statearr_39150_39173[(1)] = (4));

(statearr_39150_39173[(5)] = null);

} else {
throw ex39143;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (14))){
var state_39130__$1 = state_39130;
var statearr_39151_39174 = state_39130__$1;
(statearr_39151_39174[(2)] = (1000));

(statearr_39151_39174[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (10))){
var inst_39105 = (state_39130[(11)]);
var inst_39108 = (state_39130[(10)]);
var inst_39103 = (state_39130[(9)]);
var inst_39108__$1 = cljs.core.count(inst_39105);
var inst_39109 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_39103);
var inst_39110 = (inst_39108__$1 < (1000));
var state_39130__$1 = (function (){var statearr_39152 = state_39130;
(statearr_39152[(10)] = inst_39108__$1);

(statearr_39152[(8)] = inst_39109);

return statearr_39152;
})();
if(cljs.core.truth_(inst_39110)){
var statearr_39153_39175 = state_39130__$1;
(statearr_39153_39175[(1)] = (13));

} else {
var statearr_39154_39176 = state_39130__$1;
(statearr_39154_39176[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39131 === (8))){
var inst_39097 = (state_39130[(2)]);
var inst_39098 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_39097,optional_clauses);
var inst_39099 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_39098);
var state_39130__$1 = state_39130;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39130__$1,(9),inst_39099);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__20477__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__20477__auto____0 = (function (){
var statearr_39155 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39155[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__20477__auto__);

(statearr_39155[(1)] = (1));

return statearr_39155;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__20477__auto____1 = (function (state_39130){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_39130);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e39156){var ex__20480__auto__ = e39156;
var statearr_39157_39177 = state_39130;
(statearr_39157_39177[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_39130[(4)]))){
var statearr_39158_39178 = state_39130;
(statearr_39158_39178[(1)] = cljs.core.first((state_39130[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__39179 = state_39130;
state_39130 = G__39179;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__20477__auto__ = function(state_39130){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__20477__auto____1.call(this,state_39130);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__20477__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__20477__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_39159 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_39159[(6)] = c__20603__auto__);

return statearr_39159;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
