// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__49538 = arguments.length;
switch (G__49538) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__49541 = arguments.length;
switch (G__49541) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__20603__auto___49594 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_49572){
var state_val_49573 = (state_49572[(1)]);
if((state_val_49573 === (1))){
var state_49572__$1 = state_49572;
var statearr_49574_49595 = state_49572__$1;
(statearr_49574_49595[(2)] = null);

(statearr_49574_49595[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49573 === (2))){
var _ = (function (){var statearr_49575 = state_49572;
(statearr_49575[(4)] = cljs.core.cons((5),(state_49572[(4)])));

return statearr_49575;
})();
var inst_49549 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_49572__$1 = state_49572;
if(cljs.core.truth_(inst_49549)){
var statearr_49576_49596 = state_49572__$1;
(statearr_49576_49596[(1)] = (6));

} else {
var statearr_49577_49597 = state_49572__$1;
(statearr_49577_49597[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49573 === (3))){
var inst_49570 = (state_49572[(2)]);
var state_49572__$1 = state_49572;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49572__$1,inst_49570);
} else {
if((state_val_49573 === (4))){
var inst_49542 = (state_49572[(2)]);
var inst_49543 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_49542);
var state_49572__$1 = state_49572;
var statearr_49579_49598 = state_49572__$1;
(statearr_49579_49598[(2)] = inst_49543);

(statearr_49579_49598[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49573 === (5))){
var _ = (function (){var statearr_49580 = state_49572;
(statearr_49580[(4)] = cljs.core.rest((state_49572[(4)])));

return statearr_49580;
})();
var state_49572__$1 = state_49572;
var ex49578 = (state_49572__$1[(2)]);
var statearr_49581_49599 = state_49572__$1;
(statearr_49581_49599[(5)] = ex49578);


var statearr_49582_49600 = state_49572__$1;
(statearr_49582_49600[(1)] = (4));

(statearr_49582_49600[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_49573 === (6))){
var inst_49551 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_49552 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_49553 = cljs.core.PersistentHashMap.fromArrays(inst_49551,inst_49552);
var inst_49554 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_49553);
var inst_49555 = (function(){throw inst_49554})();
var state_49572__$1 = state_49572;
var statearr_49583_49601 = state_49572__$1;
(statearr_49583_49601[(2)] = inst_49555);

(statearr_49583_49601[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49573 === (7))){
var inst_49557 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_49558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49559 = [operation,data,pc,opts];
var inst_49560 = (new cljs.core.PersistentVector(null,4,(5),inst_49558,inst_49559,null));
var inst_49561 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_49557,inst_49560);
var inst_49562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49563 = [operation,data,pc,opts];
var inst_49564 = (new cljs.core.PersistentVector(null,4,(5),inst_49562,inst_49563,null));
var inst_49565 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_49564], 0));
var state_49572__$1 = (function (){var statearr_49584 = state_49572;
(statearr_49584[(7)] = inst_49561);

return statearr_49584;
})();
var statearr_49585_49602 = state_49572__$1;
(statearr_49585_49602[(2)] = inst_49565);

(statearr_49585_49602[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49573 === (8))){
var inst_49567 = (state_49572[(2)]);
var _ = (function (){var statearr_49586 = state_49572;
(statearr_49586[(4)] = cljs.core.rest((state_49572[(4)])));

return statearr_49586;
})();
var state_49572__$1 = state_49572;
var statearr_49587_49603 = state_49572__$1;
(statearr_49587_49603[(2)] = inst_49567);

(statearr_49587_49603[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__20477__auto__ = null;
var fluree$db$operations$state_machine__20477__auto____0 = (function (){
var statearr_49588 = [null,null,null,null,null,null,null,null];
(statearr_49588[(0)] = fluree$db$operations$state_machine__20477__auto__);

(statearr_49588[(1)] = (1));

return statearr_49588;
});
var fluree$db$operations$state_machine__20477__auto____1 = (function (state_49572){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_49572);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e49589){var ex__20480__auto__ = e49589;
var statearr_49590_49604 = state_49572;
(statearr_49590_49604[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_49572[(4)]))){
var statearr_49591_49605 = state_49572;
(statearr_49591_49605[(1)] = cljs.core.first((state_49572[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__49606 = state_49572;
state_49572 = G__49606;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$operations$state_machine__20477__auto__ = function(state_49572){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__20477__auto____1.call(this,state_49572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__20477__auto____0;
fluree$db$operations$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__20477__auto____1;
return fluree$db$operations$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_49592 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_49592[(6)] = c__20603__auto___49594);

return statearr_49592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__49608 = arguments.length;
switch (G__49608) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__49609){
var map__49610 = p__49609;
var map__49610__$1 = cljs.core.__destructure_map(map__49610);
var opts = map__49610__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49610__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__49611 = session;
var map__49611__$1 = cljs.core.__destructure_map(map__49611);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49611__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49611__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49611__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4835__auto__ = [];
var len__4829__auto___49638 = arguments.length;
var i__4830__auto___49639 = (0);
while(true){
if((i__4830__auto___49639 < len__4829__auto___49638)){
args__4835__auto__.push((arguments[i__4830__auto___49639]));

var G__49640 = (i__4830__auto___49639 + (1));
i__4830__auto___49639 = G__49640;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__49615){
var vec__49616 = p__49615;
var map__49619 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49616,(0),null);
var map__49619__$1 = cljs.core.__destructure_map(map__49619);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49619__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49619__$1,cljs.core.cst$kw$toTime);
var opts = vec__49616;
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_49631){
var state_val_49632 = (state_49631[(1)]);
if((state_val_49632 === (1))){
var inst_49621 = session;
var inst_49622 = cljs.core.__destructure_map(inst_49621);
var inst_49623 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_49622,cljs.core.cst$kw$network);
var inst_49624 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_49622,cljs.core.cst$kw$dbid);
var inst_49625 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_49622,cljs.core.cst$kw$conn);
var inst_49626 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_49627 = [inst_49623,inst_49624,toBlock,toTime];
var inst_49628 = cljs.core.PersistentHashMap.fromArrays(inst_49626,inst_49627);
var inst_49629 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_49625,cljs.core.cst$kw$garbage,inst_49628);
var state_49631__$1 = state_49631;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49631__$1,inst_49629);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__20477__auto__ = null;
var fluree$db$operations$state_machine__20477__auto____0 = (function (){
var statearr_49633 = [null,null,null,null,null,null,null];
(statearr_49633[(0)] = fluree$db$operations$state_machine__20477__auto__);

(statearr_49633[(1)] = (1));

return statearr_49633;
});
var fluree$db$operations$state_machine__20477__auto____1 = (function (state_49631){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_49631);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e49634){var ex__20480__auto__ = e49634;
var statearr_49635_49641 = state_49631;
(statearr_49635_49641[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_49631[(4)]))){
var statearr_49636_49642 = state_49631;
(statearr_49636_49642[(1)] = cljs.core.first((state_49631[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__49643 = state_49631;
state_49631 = G__49643;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$operations$state_machine__20477__auto__ = function(state_49631){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__20477__auto____1.call(this,state_49631);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__20477__auto____0;
fluree$db$operations$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__20477__auto____1;
return fluree$db$operations$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_49637 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_49637[(6)] = c__20603__auto__);

return statearr_49637;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq49613){
var G__49614 = cljs.core.first(seq49613);
var seq49613__$1 = cljs.core.next(seq49613);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__49614,seq49613__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__49644 = session;
var map__49644__$1 = cljs.core.__destructure_map(map__49644);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49644__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49644__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49644__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__49646 = arguments.length;
switch (G__49646) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__49647 = opts;
var map__49647__$1 = cljs.core.__destructure_map(map__49647);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49647__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49647__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4223__auto__ = auth;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
