// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__48100 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48100,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48100,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__48100,(2),null);
if(cljs.core.truth_((function (){var and__4221__auto__ = network;
if(cljs.core.truth_(and__4221__auto__)){
return maybe_alias;
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__48103){
var map__48104 = p__48103;
var map__48104__$1 = cljs.core.__destructure_map(map__48104);
var opts = map__48104__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__48104__$1,cljs.core.cst$kw$reindex_QMARK_);
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_48164){
var state_val_48165 = (state_48164[(1)]);
if((state_val_48165 === (7))){
var inst_48135 = cljs.core.not(reindex_QMARK_);
var state_48164__$1 = state_48164;
var statearr_48166_48190 = state_48164__$1;
(statearr_48166_48190[(2)] = inst_48135);

(statearr_48166_48190[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48165 === (1))){
var state_48164__$1 = state_48164;
var statearr_48167_48191 = state_48164__$1;
(statearr_48167_48191[(2)] = null);

(statearr_48167_48191[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48165 === (4))){
var inst_48105 = (state_48164[(2)]);
var state_48164__$1 = state_48164;
var statearr_48168_48192 = state_48164__$1;
(statearr_48168_48192[(2)] = inst_48105);

(statearr_48168_48192[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48165 === (6))){
var inst_48133 = (state_48164[(7)]);
var inst_48125 = (state_48164[(8)]);
var inst_48119 = (state_48164[(9)]);
var inst_48118 = (state_48164[(2)]);
var inst_48119__$1 = fluree.db.util.async.throw_err(inst_48118);
var inst_48120 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_48121 = cljs.core.__destructure_map(inst_48120);
var inst_48122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48121,cljs.core.cst$kw$post);
var inst_48123 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48121,cljs.core.cst$kw$size);
var inst_48124 = fluree.db.flake.size_bytes(inst_48119__$1);
var inst_48125__$1 = (inst_48123 + inst_48124);
var inst_48126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48127 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_48128 = (new cljs.core.PersistentVector(null,2,(5),inst_48126,inst_48127,null));
var inst_48129 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_48128);
var inst_48130 = cljs.core.__destructure_map(inst_48129);
var inst_48131 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48130,cljs.core.cst$kw$novelty_DASH_min);
var inst_48132 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48130,cljs.core.cst$kw$novelty_DASH_max);
var inst_48133__$1 = (inst_48125__$1 > inst_48132);
var state_48164__$1 = (function (){var statearr_48169 = state_48164;
(statearr_48169[(7)] = inst_48133__$1);

(statearr_48169[(10)] = inst_48131);

(statearr_48169[(11)] = inst_48122);

(statearr_48169[(8)] = inst_48125__$1);

(statearr_48169[(9)] = inst_48119__$1);

return statearr_48169;
})();
if(cljs.core.truth_(inst_48133__$1)){
var statearr_48170_48193 = state_48164__$1;
(statearr_48170_48193[(1)] = (7));

} else {
var statearr_48171_48194 = state_48164__$1;
(statearr_48171_48194[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48165 === (3))){
var inst_48162 = (state_48164[(2)]);
var state_48164__$1 = state_48164;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48164__$1,inst_48162);
} else {
if((state_val_48165 === (12))){
var inst_48122 = (state_48164[(11)]);
var inst_48125 = (state_48164[(8)]);
var inst_48119 = (state_48164[(9)]);
var inst_48148 = (state_48164[(2)]);
var inst_48149 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_48122,inst_48119);
var inst_48150 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_48151 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_48150,cljs.core.empty);
var inst_48152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48153 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_48154 = (new cljs.core.PersistentVector(null,2,(5),inst_48152,inst_48153,null));
var inst_48155 = cljs.core.assoc_in(db,inst_48154,inst_48149);
var inst_48156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48157 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_48158 = (new cljs.core.PersistentVector(null,2,(5),inst_48156,inst_48157,null));
var inst_48159 = cljs.core.assoc_in(inst_48155,inst_48158,inst_48125);
var _ = (function (){var statearr_48172 = state_48164;
(statearr_48172[(4)] = cljs.core.rest((state_48164[(4)])));

return statearr_48172;
})();
var state_48164__$1 = (function (){var statearr_48173 = state_48164;
(statearr_48173[(12)] = inst_48148);

(statearr_48173[(13)] = inst_48151);

return statearr_48173;
})();
var statearr_48174_48195 = state_48164__$1;
(statearr_48174_48195[(2)] = inst_48159);

(statearr_48174_48195[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48165 === (2))){
var _ = (function (){var statearr_48175 = state_48164;
(statearr_48175[(4)] = cljs.core.cons((5),(state_48164[(4)])));

return statearr_48175;
})();
var inst_48113 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48114 = [pred_id];
var inst_48115 = (new cljs.core.PersistentVector(null,1,(5),inst_48113,inst_48114,null));
var inst_48116 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_48115);
var state_48164__$1 = state_48164;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48164__$1,(6),inst_48116);
} else {
if((state_val_48165 === (11))){
var state_48164__$1 = state_48164;
var statearr_48177_48196 = state_48164__$1;
(statearr_48177_48196[(2)] = null);

(statearr_48177_48196[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48165 === (9))){
var inst_48138 = (state_48164[(2)]);
var state_48164__$1 = state_48164;
if(cljs.core.truth_(inst_48138)){
var statearr_48178_48197 = state_48164__$1;
(statearr_48178_48197[(1)] = (10));

} else {
var statearr_48179_48198 = state_48164__$1;
(statearr_48179_48198[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48165 === (5))){
var _ = (function (){var statearr_48180 = state_48164;
(statearr_48180[(4)] = cljs.core.rest((state_48164[(4)])));

return statearr_48180;
})();
var state_48164__$1 = state_48164;
var ex48176 = (state_48164__$1[(2)]);
var statearr_48181_48199 = state_48164__$1;
(statearr_48181_48199[(5)] = ex48176);


if((ex48176 instanceof Error)){
var statearr_48182_48200 = state_48164__$1;
(statearr_48182_48200[(1)] = (4));

(statearr_48182_48200[(5)] = null);

} else {
throw ex48176;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48165 === (10))){
var inst_48140 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_48141 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_48142 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_48143 = cljs.core.PersistentHashMap.fromArrays(inst_48141,inst_48142);
var inst_48144 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_48140,inst_48143);
var inst_48145 = (function(){throw inst_48144})();
var state_48164__$1 = state_48164;
var statearr_48183_48201 = state_48164__$1;
(statearr_48183_48201[(2)] = inst_48145);

(statearr_48183_48201[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48165 === (8))){
var inst_48133 = (state_48164[(7)]);
var state_48164__$1 = state_48164;
var statearr_48184_48202 = state_48164__$1;
(statearr_48184_48202[(2)] = inst_48133);

(statearr_48184_48202[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__20477__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__20477__auto____0 = (function (){
var statearr_48185 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48185[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__20477__auto__);

(statearr_48185[(1)] = (1));

return statearr_48185;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__20477__auto____1 = (function (state_48164){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_48164);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e48186){var ex__20480__auto__ = e48186;
var statearr_48187_48203 = state_48164;
(statearr_48187_48203[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_48164[(4)]))){
var statearr_48188_48204 = state_48164;
(statearr_48188_48204[(1)] = cljs.core.first((state_48164[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__48205 = state_48164;
state_48164 = G__48205;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__20477__auto__ = function(state_48164){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__20477__auto____1.call(this,state_48164);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__20477__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__20477__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_48189 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_48189[(6)] = c__20603__auto__);

return statearr_48189;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__48210 = arguments.length;
switch (G__48210) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_48406){
var state_val_48407 = (state_48406[(1)]);
if((state_val_48407 === (7))){
var state_48406__$1 = state_48406;
var statearr_48408_48476 = state_48406__$1;
(statearr_48408_48476[(2)] = null);

(statearr_48408_48476[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (20))){
var inst_48249 = (state_48406[(7)]);
var inst_48332 = (state_48406[(8)]);
var inst_48331 = (state_48406[(9)]);
var inst_48330 = (state_48406[(10)]);
var inst_48328 = (state_48406[(11)]);
var inst_48299 = (state_48406[(12)]);
var inst_48248 = (state_48406[(13)]);
var inst_48329 = (state_48406[(14)]);
var inst_48342 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_48343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48344 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_48345 = (new cljs.core.PersistentVector(null,2,(5),inst_48343,inst_48344,null));
var inst_48346 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_48299,inst_48345);
var inst_48347 = (inst_48248 + inst_48346);
var inst_48348 = [inst_48328,inst_48329,inst_48330,inst_48331,inst_48347];
var inst_48349 = cljs.core.PersistentHashMap.fromArrays(inst_48342,inst_48348);
var inst_48350 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_48299,cljs.core.cst$kw$ecount,inst_48332,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_48349], 0));
var state_48406__$1 = (function (){var statearr_48409 = state_48406;
(statearr_48409[(15)] = inst_48350);

return statearr_48409;
})();
if(cljs.core.truth_(inst_48249)){
var statearr_48410_48477 = state_48406__$1;
(statearr_48410_48477[(1)] = (23));

} else {
var statearr_48411_48478 = state_48406__$1;
(statearr_48411_48478[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (27))){
var inst_48350 = (state_48406[(15)]);
var state_48406__$1 = state_48406;
var statearr_48412_48479 = state_48406__$1;
(statearr_48412_48479[(2)] = inst_48350);

(statearr_48412_48479[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (1))){
var state_48406__$1 = state_48406;
var statearr_48413_48480 = state_48406__$1;
(statearr_48413_48480[(2)] = null);

(statearr_48413_48480[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (24))){
var inst_48350 = (state_48406[(15)]);
var inst_48353 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_48350);
var inst_48354 = (inst_48353 == null);
var state_48406__$1 = state_48406;
var statearr_48414_48481 = state_48406__$1;
(statearr_48414_48481[(2)] = inst_48354);

(statearr_48414_48481[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (39))){
var inst_48380 = (state_48406[(16)]);
var inst_48382 = (state_48406[(17)]);
var inst_48381 = (state_48406[(18)]);
var inst_48339 = (state_48406[(19)]);
var inst_48389 = (state_48406[(20)]);
var inst_48396 = (state_48406[(2)]);
var inst_48327 = inst_48339;
var inst_48328 = inst_48381;
var inst_48329 = inst_48382;
var inst_48330 = inst_48389;
var inst_48331 = inst_48396;
var inst_48332 = inst_48380;
var state_48406__$1 = (function (){var statearr_48415 = state_48406;
(statearr_48415[(21)] = inst_48327);

(statearr_48415[(8)] = inst_48332);

(statearr_48415[(9)] = inst_48331);

(statearr_48415[(10)] = inst_48330);

(statearr_48415[(11)] = inst_48328);

(statearr_48415[(14)] = inst_48329);

return statearr_48415;
})();
var statearr_48416_48482 = state_48406__$1;
(statearr_48416_48482[(2)] = null);

(statearr_48416_48482[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (4))){
var inst_48211 = (state_48406[(2)]);
var state_48406__$1 = state_48406;
var statearr_48417_48483 = state_48406__$1;
(statearr_48417_48483[(2)] = inst_48211);

(statearr_48417_48483[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (15))){
var inst_48271 = (state_48406[(22)]);
var state_48406__$1 = state_48406;
var statearr_48418_48484 = state_48406__$1;
(statearr_48418_48484[(2)] = inst_48271);

(statearr_48418_48484[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (21))){
var inst_48327 = (state_48406[(21)]);
var inst_48249 = (state_48406[(7)]);
var inst_48243 = (state_48406[(23)]);
var inst_48309 = (state_48406[(24)]);
var inst_48247 = (state_48406[(25)]);
var inst_48332 = (state_48406[(8)]);
var inst_48218 = (state_48406[(26)]);
var inst_48233 = (state_48406[(27)]);
var inst_48250 = (state_48406[(28)]);
var inst_48331 = (state_48406[(9)]);
var inst_48308 = (state_48406[(29)]);
var inst_48252 = (state_48406[(30)]);
var inst_48330 = (state_48406[(10)]);
var inst_48239 = (state_48406[(31)]);
var inst_48328 = (state_48406[(11)]);
var inst_48338 = (state_48406[(32)]);
var inst_48339 = (state_48406[(19)]);
var inst_48299 = (state_48406[(12)]);
var inst_48258 = (state_48406[(33)]);
var inst_48235 = (state_48406[(34)]);
var inst_48248 = (state_48406[(13)]);
var inst_48329 = (state_48406[(14)]);
var inst_48377 = inst_48338.s;
var inst_48378 = fluree.db.flake.sid__GT_cid(inst_48377);
var inst_48379 = (function (){var flakes_bytes = inst_48248;
var t = inst_48218;
var seq__48335 = inst_48339;
var first__48336 = inst_48338;
var spot = inst_48328;
var add_flakes = inst_48235;
var vec__48334 = inst_48327;
var G__48303 = inst_48327;
var root_setting_change_QMARK_ = inst_48250;
var ref_QMARK__map = inst_48247;
var r = inst_48339;
var psot = inst_48329;
var add_pred_to_idx_QMARK_ = inst_48258;
var _ = inst_48233;
var cid = inst_48378;
var ecount = inst_48332;
var pred_ecount = inst_48252;
var vec__48304 = inst_48235;
var db_STAR_ = inst_48299;
var schema_change_QMARK_ = inst_48249;
var add_preds = inst_48239;
var opst = inst_48331;
var first__48306 = inst_48308;
var idx_QMARK__map = inst_48243;
var post = inst_48330;
var seq__48305 = inst_48309;
var f = inst_48338;
return (function (p1__48208_SHARP_){
if(cljs.core.truth_(p1__48208_SHARP_)){
var x__4306__auto__ = p1__48208_SHARP_;
var y__4307__auto__ = f.s;
return ((x__4306__auto__ > y__4307__auto__) ? x__4306__auto__ : y__4307__auto__);
} else {
return f.s;
}
});
})();
var inst_48380 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_48332,inst_48378,inst_48379);
var inst_48381 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_48328,inst_48338);
var inst_48382 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_48329,inst_48338);
var inst_48383 = inst_48338.p;
var inst_48384 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48243,inst_48383);
var state_48406__$1 = (function (){var statearr_48419 = state_48406;
(statearr_48419[(16)] = inst_48380);

(statearr_48419[(17)] = inst_48382);

(statearr_48419[(18)] = inst_48381);

return statearr_48419;
})();
if(cljs.core.truth_(inst_48384)){
var statearr_48420_48485 = state_48406__$1;
(statearr_48420_48485[(1)] = (34));

} else {
var statearr_48421_48486 = state_48406__$1;
(statearr_48421_48486[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (31))){
var inst_48365 = (state_48406[(35)]);
var state_48406__$1 = state_48406;
var statearr_48422_48487 = state_48406__$1;
(statearr_48422_48487[(2)] = inst_48365);

(statearr_48422_48487[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (32))){
var inst_48375 = (state_48406[(2)]);
var state_48406__$1 = state_48406;
var statearr_48423_48488 = state_48406__$1;
(statearr_48423_48488[(2)] = inst_48375);

(statearr_48423_48488[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (33))){
var inst_48365 = (state_48406[(35)]);
var inst_48370 = (state_48406[(2)]);
var inst_48371 = fluree.db.util.async.throw_err(inst_48370);
var inst_48372 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_48365,cljs.core.cst$kw$settings,inst_48371);
var state_48406__$1 = state_48406;
var statearr_48424_48489 = state_48406__$1;
(statearr_48424_48489[(2)] = inst_48372);

(statearr_48424_48489[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (13))){
var inst_48218 = (state_48406[(26)]);
var inst_48299 = (state_48406[(12)]);
var inst_48235 = (state_48406[(34)]);
var inst_48248 = (state_48406[(13)]);
var inst_48289 = (state_48406[(2)]);
var inst_48290 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_48289,cljs.core.cst$kw$t,inst_48218);
var inst_48291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48292 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_48293 = (new cljs.core.PersistentVector(null,2,(5),inst_48291,inst_48292,null));
var inst_48294 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_48290,inst_48293,cljs.core._PLUS_,inst_48248);
var inst_48295 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48296 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_48297 = (new cljs.core.PersistentVector(null,2,(5),inst_48295,inst_48296,null));
var inst_48298 = cljs.core.count(inst_48235);
var inst_48299__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_48294,inst_48297,cljs.core._PLUS_,inst_48298);
var inst_48307 = cljs.core.seq(inst_48235);
var inst_48308 = cljs.core.first(inst_48307);
var inst_48309 = cljs.core.next(inst_48307);
var inst_48310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48311 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_48312 = (new cljs.core.PersistentVector(null,2,(5),inst_48310,inst_48311,null));
var inst_48313 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_48299__$1,inst_48312);
var inst_48314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48315 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_48316 = (new cljs.core.PersistentVector(null,2,(5),inst_48314,inst_48315,null));
var inst_48317 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_48299__$1,inst_48316);
var inst_48318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48319 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_48320 = (new cljs.core.PersistentVector(null,2,(5),inst_48318,inst_48319,null));
var inst_48321 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_48299__$1,inst_48320);
var inst_48322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48323 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_48324 = (new cljs.core.PersistentVector(null,2,(5),inst_48322,inst_48323,null));
var inst_48325 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_48299__$1,inst_48324);
var inst_48326 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_48327 = inst_48235;
var inst_48328 = inst_48313;
var inst_48329 = inst_48317;
var inst_48330 = inst_48321;
var inst_48331 = inst_48325;
var inst_48332 = inst_48326;
var state_48406__$1 = (function (){var statearr_48425 = state_48406;
(statearr_48425[(21)] = inst_48327);

(statearr_48425[(24)] = inst_48309);

(statearr_48425[(8)] = inst_48332);

(statearr_48425[(9)] = inst_48331);

(statearr_48425[(29)] = inst_48308);

(statearr_48425[(10)] = inst_48330);

(statearr_48425[(11)] = inst_48328);

(statearr_48425[(12)] = inst_48299__$1);

(statearr_48425[(14)] = inst_48329);

return statearr_48425;
})();
var statearr_48426_48490 = state_48406__$1;
(statearr_48426_48490[(2)] = null);

(statearr_48426_48490[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (22))){
var inst_48399 = (state_48406[(2)]);
var state_48406__$1 = state_48406;
var statearr_48427_48491 = state_48406__$1;
(statearr_48427_48491[(2)] = inst_48399);

(statearr_48427_48491[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (36))){
var inst_48247 = (state_48406[(25)]);
var inst_48338 = (state_48406[(32)]);
var inst_48389 = (state_48406[(2)]);
var inst_48390 = inst_48338.p;
var inst_48391 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48247,inst_48390);
var state_48406__$1 = (function (){var statearr_48428 = state_48406;
(statearr_48428[(20)] = inst_48389);

return statearr_48428;
})();
if(cljs.core.truth_(inst_48391)){
var statearr_48429_48492 = state_48406__$1;
(statearr_48429_48492[(1)] = (37));

} else {
var statearr_48430_48493 = state_48406__$1;
(statearr_48430_48493[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (29))){
var inst_48350 = (state_48406[(15)]);
var inst_48360 = (state_48406[(2)]);
var inst_48361 = fluree.db.util.async.throw_err(inst_48360);
var inst_48362 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_48350,cljs.core.cst$kw$schema,inst_48361);
var state_48406__$1 = state_48406;
var statearr_48431_48494 = state_48406__$1;
(statearr_48431_48494[(2)] = inst_48362);

(statearr_48431_48494[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (6))){
var inst_48218 = (state_48406[(26)]);
var inst_48223 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_48224 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_48225 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_48223)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_48224)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_48218),"."].join('');
var inst_48226 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_48227 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_48228 = cljs.core.PersistentHashMap.fromArrays(inst_48226,inst_48227);
var inst_48229 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_48225,inst_48228);
var inst_48230 = (function(){throw inst_48229})();
var state_48406__$1 = state_48406;
var statearr_48432_48495 = state_48406__$1;
(statearr_48432_48495[(2)] = inst_48230);

(statearr_48432_48495[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (28))){
var inst_48250 = (state_48406[(28)]);
var inst_48365 = (state_48406[(2)]);
var state_48406__$1 = (function (){var statearr_48433 = state_48406;
(statearr_48433[(35)] = inst_48365);

return statearr_48433;
})();
if(cljs.core.truth_(inst_48250)){
var statearr_48434_48496 = state_48406__$1;
(statearr_48434_48496[(1)] = (30));

} else {
var statearr_48435_48497 = state_48406__$1;
(statearr_48435_48497[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (25))){
var inst_48356 = (state_48406[(2)]);
var state_48406__$1 = state_48406;
if(cljs.core.truth_(inst_48356)){
var statearr_48436_48498 = state_48406__$1;
(statearr_48436_48498[(1)] = (26));

} else {
var statearr_48437_48499 = state_48406__$1;
(statearr_48437_48499[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (34))){
var inst_48330 = (state_48406[(10)]);
var inst_48338 = (state_48406[(32)]);
var inst_48386 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_48330,inst_48338);
var state_48406__$1 = state_48406;
var statearr_48438_48500 = state_48406__$1;
(statearr_48438_48500[(2)] = inst_48386);

(statearr_48438_48500[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (17))){
var inst_48278 = (state_48406[(36)]);
var inst_48282 = (state_48406[(2)]);
var inst_48283 = fluree.db.util.async.throw_err(inst_48282);
var inst_48270 = inst_48278;
var inst_48271 = inst_48283;
var state_48406__$1 = (function (){var statearr_48439 = state_48406;
(statearr_48439[(37)] = inst_48270);

(statearr_48439[(22)] = inst_48271);

return statearr_48439;
})();
var statearr_48440_48501 = state_48406__$1;
(statearr_48440_48501[(2)] = null);

(statearr_48440_48501[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (3))){
var inst_48404 = (state_48406[(2)]);
var state_48406__$1 = state_48406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48406__$1,inst_48404);
} else {
if((state_val_48407 === (12))){
var inst_48270 = (state_48406[(37)]);
var inst_48277 = (state_48406[(38)]);
var inst_48276 = cljs.core.seq(inst_48270);
var inst_48277__$1 = cljs.core.first(inst_48276);
var inst_48278 = cljs.core.next(inst_48276);
var state_48406__$1 = (function (){var statearr_48441 = state_48406;
(statearr_48441[(38)] = inst_48277__$1);

(statearr_48441[(36)] = inst_48278);

return statearr_48441;
})();
if(cljs.core.truth_(inst_48277__$1)){
var statearr_48442_48502 = state_48406__$1;
(statearr_48442_48502[(1)] = (14));

} else {
var statearr_48443_48503 = state_48406__$1;
(statearr_48443_48503[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (2))){
var inst_48218 = (state_48406[(26)]);
var _ = (function (){var statearr_48444 = state_48406;
(statearr_48444[(4)] = cljs.core.cons((5),(state_48406[(4)])));

return statearr_48444;
})();
var inst_48217 = cljs.core.first(flakes);
var inst_48218__$1 = inst_48217.t;
var inst_48219 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_48220 = (inst_48219 - (1));
var inst_48221 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_48218__$1,inst_48220);
var state_48406__$1 = (function (){var statearr_48445 = state_48406;
(statearr_48445[(26)] = inst_48218__$1);

return statearr_48445;
})();
if(inst_48221){
var statearr_48446_48504 = state_48406__$1;
(statearr_48446_48504[(1)] = (6));

} else {
var statearr_48447_48505 = state_48406__$1;
(statearr_48447_48505[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (23))){
var inst_48249 = (state_48406[(7)]);
var state_48406__$1 = state_48406;
var statearr_48448_48506 = state_48406__$1;
(statearr_48448_48506[(2)] = inst_48249);

(statearr_48448_48506[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (35))){
var inst_48330 = (state_48406[(10)]);
var state_48406__$1 = state_48406;
var statearr_48449_48507 = state_48406__$1;
(statearr_48449_48507[(2)] = inst_48330);

(statearr_48449_48507[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (19))){
var inst_48401 = (state_48406[(2)]);
var _ = (function (){var statearr_48450 = state_48406;
(statearr_48450[(4)] = cljs.core.rest((state_48406[(4)])));

return statearr_48450;
})();
var state_48406__$1 = state_48406;
var statearr_48451_48508 = state_48406__$1;
(statearr_48451_48508[(2)] = inst_48401);

(statearr_48451_48508[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (11))){
var inst_48258 = (state_48406[(33)]);
var inst_48258__$1 = (state_48406[(2)]);
var inst_48266 = cljs.core.seq(inst_48258__$1);
var inst_48267 = cljs.core.first(inst_48266);
var inst_48268 = cljs.core.next(inst_48266);
var inst_48269 = db;
var inst_48270 = inst_48258__$1;
var inst_48271 = inst_48269;
var state_48406__$1 = (function (){var statearr_48453 = state_48406;
(statearr_48453[(39)] = inst_48268);

(statearr_48453[(37)] = inst_48270);

(statearr_48453[(33)] = inst_48258__$1);

(statearr_48453[(40)] = inst_48267);

(statearr_48453[(22)] = inst_48271);

return statearr_48453;
})();
var statearr_48454_48509 = state_48406__$1;
(statearr_48454_48509[(2)] = null);

(statearr_48454_48509[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (9))){
var inst_48252 = (state_48406[(30)]);
var inst_48235 = (state_48406[(34)]);
var inst_48254 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_48235,inst_48252);
var state_48406__$1 = state_48406;
var statearr_48455_48510 = state_48406__$1;
(statearr_48455_48510[(2)] = inst_48254);

(statearr_48455_48510[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (5))){
var _ = (function (){var statearr_48456 = state_48406;
(statearr_48456[(4)] = cljs.core.rest((state_48406[(4)])));

return statearr_48456;
})();
var state_48406__$1 = state_48406;
var ex48452 = (state_48406__$1[(2)]);
var statearr_48457_48511 = state_48406__$1;
(statearr_48457_48511[(5)] = ex48452);


if((ex48452 instanceof Error)){
var statearr_48458_48512 = state_48406__$1;
(statearr_48458_48512[(1)] = (4));

(statearr_48458_48512[(5)] = null);

} else {
throw ex48452;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (14))){
var inst_48277 = (state_48406[(38)]);
var inst_48271 = (state_48406[(22)]);
var inst_48280 = fluree.db.graphdb.add_predicate_to_idx(inst_48271,inst_48277,opts);
var state_48406__$1 = state_48406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48406__$1,(17),inst_48280);
} else {
if((state_val_48407 === (26))){
var inst_48350 = (state_48406[(15)]);
var inst_48358 = fluree.db.query.schema.schema_map(inst_48350);
var state_48406__$1 = state_48406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48406__$1,(29),inst_48358);
} else {
if((state_val_48407 === (16))){
var inst_48287 = (state_48406[(2)]);
var state_48406__$1 = state_48406;
var statearr_48459_48513 = state_48406__$1;
(statearr_48459_48513[(2)] = inst_48287);

(statearr_48459_48513[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (38))){
var inst_48331 = (state_48406[(9)]);
var state_48406__$1 = state_48406;
var statearr_48460_48514 = state_48406__$1;
(statearr_48460_48514[(2)] = inst_48331);

(statearr_48460_48514[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (30))){
var inst_48365 = (state_48406[(35)]);
var inst_48368 = fluree.db.query.schema.setting_map(inst_48365);
var state_48406__$1 = state_48406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48406__$1,(33),inst_48368);
} else {
if((state_val_48407 === (10))){
var inst_48256 = cljs.core.PersistentVector.EMPTY;
var state_48406__$1 = state_48406;
var statearr_48461_48515 = state_48406__$1;
(statearr_48461_48515[(2)] = inst_48256);

(statearr_48461_48515[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (18))){
var inst_48327 = (state_48406[(21)]);
var inst_48338 = (state_48406[(32)]);
var inst_48337 = cljs.core.seq(inst_48327);
var inst_48338__$1 = cljs.core.first(inst_48337);
var inst_48339 = cljs.core.next(inst_48337);
var inst_48340 = cljs.core.not(inst_48338__$1);
var state_48406__$1 = (function (){var statearr_48462 = state_48406;
(statearr_48462[(32)] = inst_48338__$1);

(statearr_48462[(19)] = inst_48339);

return statearr_48462;
})();
if(inst_48340){
var statearr_48463_48516 = state_48406__$1;
(statearr_48463_48516[(1)] = (20));

} else {
var statearr_48464_48517 = state_48406__$1;
(statearr_48464_48517[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (37))){
var inst_48331 = (state_48406[(9)]);
var inst_48338 = (state_48406[(32)]);
var inst_48393 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_48331,inst_48338);
var state_48406__$1 = state_48406;
var statearr_48465_48518 = state_48406__$1;
(statearr_48465_48518[(2)] = inst_48393);

(statearr_48465_48518[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48407 === (8))){
var inst_48249 = (state_48406[(7)]);
var inst_48243 = (state_48406[(23)]);
var inst_48218 = (state_48406[(26)]);
var inst_48233 = (state_48406[(27)]);
var inst_48239 = (state_48406[(31)]);
var inst_48235 = (state_48406[(34)]);
var inst_48233__$1 = (state_48406[(2)]);
var inst_48234 = (function (){var t = inst_48218;
var _ = inst_48233__$1;
return (function (p1__48206_SHARP_){
return cljs.core.not((function (){var G__48466 = p1__48206_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__48466) : fluree.db.graphdb.exclude_predicates.call(null,G__48466));
})());
});
})();
var inst_48235__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_48234,flakes);
var inst_48236 = cljs.core.PersistentHashSet.EMPTY;
var inst_48237 = (function (){var t = inst_48218;
var _ = inst_48233__$1;
var add_flakes = inst_48235__$1;
return (function (p1__48207_SHARP_){
return p1__48207_SHARP_.p;
});
})();
var inst_48238 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_48237,inst_48235__$1);
var inst_48239__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_48236,inst_48238);
var inst_48240 = cljs.core.PersistentHashMap.EMPTY;
var inst_48241 = (function (){var t = inst_48218;
var _ = inst_48233__$1;
var add_flakes = inst_48235__$1;
var add_preds = inst_48239__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_48242 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_48241,inst_48239__$1);
var inst_48243__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_48240,inst_48242);
var inst_48244 = cljs.core.PersistentHashMap.EMPTY;
var inst_48245 = (function (){var t = inst_48218;
var _ = inst_48233__$1;
var add_flakes = inst_48235__$1;
var add_preds = inst_48239__$1;
var idx_QMARK__map = inst_48243__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_48246 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_48245,inst_48239__$1);
var inst_48247 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_48244,inst_48246);
var inst_48248 = fluree.db.flake.size_bytes(inst_48235__$1);
var inst_48249__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_48235__$1);
var inst_48250 = fluree.db.util.schema.setting_change_QMARK_(inst_48235__$1);
var inst_48251 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_48252 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_48251,(0));
var state_48406__$1 = (function (){var statearr_48467 = state_48406;
(statearr_48467[(7)] = inst_48249__$1);

(statearr_48467[(23)] = inst_48243__$1);

(statearr_48467[(25)] = inst_48247);

(statearr_48467[(27)] = inst_48233__$1);

(statearr_48467[(28)] = inst_48250);

(statearr_48467[(30)] = inst_48252);

(statearr_48467[(31)] = inst_48239__$1);

(statearr_48467[(34)] = inst_48235__$1);

(statearr_48467[(13)] = inst_48248);

return statearr_48467;
})();
if(cljs.core.truth_(inst_48249__$1)){
var statearr_48468_48519 = state_48406__$1;
(statearr_48468_48519[(1)] = (9));

} else {
var statearr_48469_48520 = state_48406__$1;
(statearr_48469_48520[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__20477__auto__ = null;
var fluree$db$graphdb$state_machine__20477__auto____0 = (function (){
var statearr_48470 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48470[(0)] = fluree$db$graphdb$state_machine__20477__auto__);

(statearr_48470[(1)] = (1));

return statearr_48470;
});
var fluree$db$graphdb$state_machine__20477__auto____1 = (function (state_48406){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_48406);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e48471){var ex__20480__auto__ = e48471;
var statearr_48472_48521 = state_48406;
(statearr_48472_48521[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_48406[(4)]))){
var statearr_48473_48522 = state_48406;
(statearr_48473_48522[(1)] = cljs.core.first((state_48406[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__48523 = state_48406;
state_48406 = G__48523;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__20477__auto__ = function(state_48406){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__20477__auto____1.call(this,state_48406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__20477__auto____0;
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__20477__auto____1;
return fluree$db$graphdb$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_48474 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_48474[(6)] = c__20603__auto__);

return statearr_48474;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__48525 = arguments.length;
switch (G__48525) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__20603__auto___48672 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_48621){
var state_val_48622 = (state_48621[(1)]);
if((state_val_48622 === (7))){
var state_48621__$1 = state_48621;
var statearr_48623_48673 = state_48621__$1;
(statearr_48623_48673[(2)] = null);

(statearr_48623_48673[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (20))){
var inst_48569 = (state_48621[(7)]);
var inst_48570 = (state_48621[(8)]);
var inst_48571 = (state_48621[(9)]);
var inst_48590 = (inst_48569 + (1));
var inst_48591 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_48571,cljs.core.cst$kw$t,inst_48590);
var inst_48592 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_48591,inst_48570,opts);
var state_48621__$1 = state_48621;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48621__$1,(23),inst_48592);
} else {
if((state_val_48622 === (1))){
var state_48621__$1 = state_48621;
var statearr_48624_48674 = state_48621__$1;
(statearr_48624_48674[(2)] = null);

(statearr_48624_48674[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (24))){
var inst_48595 = (state_48621[(10)]);
var inst_48598 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_48595,cljs.core.cst$kw$block,block);
var state_48621__$1 = state_48621;
var statearr_48625_48675 = state_48621__$1;
(statearr_48625_48675[(2)] = inst_48598);

(statearr_48625_48675[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (4))){
var inst_48526 = (state_48621[(2)]);
var inst_48527 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_48526);
var state_48621__$1 = state_48621;
var statearr_48626_48676 = state_48621__$1;
(statearr_48626_48676[(2)] = inst_48527);

(statearr_48626_48676[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (15))){
var inst_48577 = (state_48621[(11)]);
var state_48621__$1 = state_48621;
var statearr_48627_48677 = state_48621__$1;
(statearr_48627_48677[(2)] = inst_48577);

(statearr_48627_48677[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (21))){
var state_48621__$1 = state_48621;
var statearr_48628_48678 = state_48621__$1;
(statearr_48628_48678[(2)] = null);

(statearr_48628_48678[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (13))){
var inst_48613 = (state_48621[(2)]);
var inst_48614 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_48613);
var state_48621__$1 = state_48621;
var statearr_48629_48679 = state_48621__$1;
(statearr_48629_48679[(2)] = inst_48614);

(statearr_48629_48679[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (22))){
var inst_48609 = (state_48621[(2)]);
var state_48621__$1 = state_48621;
var statearr_48630_48680 = state_48621__$1;
(statearr_48630_48680[(2)] = inst_48609);

(statearr_48630_48680[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (6))){
var inst_48537 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_48538 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_48539 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_48537)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_48538)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_48540 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_48541 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_48542 = cljs.core.PersistentHashMap.fromArrays(inst_48540,inst_48541);
var inst_48543 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_48539,inst_48542);
var inst_48544 = (function(){throw inst_48543})();
var state_48621__$1 = state_48621;
var statearr_48633_48681 = state_48621__$1;
(statearr_48633_48681[(2)] = inst_48544);

(statearr_48633_48681[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (25))){
var inst_48578 = (state_48621[(12)]);
var inst_48577 = (state_48621[(11)]);
var inst_48595 = (state_48621[(10)]);
var inst_48600 = inst_48577.t;
var inst_48601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48602 = [inst_48577];
var inst_48603 = (new cljs.core.PersistentVector(null,1,(5),inst_48601,inst_48602,null));
var inst_48568 = inst_48578;
var inst_48569 = inst_48600;
var inst_48570 = inst_48603;
var inst_48571 = inst_48595;
var state_48621__$1 = (function (){var statearr_48634 = state_48621;
(statearr_48634[(7)] = inst_48569);

(statearr_48634[(13)] = inst_48568);

(statearr_48634[(8)] = inst_48570);

(statearr_48634[(9)] = inst_48571);

return statearr_48634;
})();
var statearr_48635_48682 = state_48621__$1;
(statearr_48635_48682[(2)] = null);

(statearr_48635_48682[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (17))){
var inst_48569 = (state_48621[(7)]);
var inst_48578 = (state_48621[(12)]);
var inst_48577 = (state_48621[(11)]);
var inst_48570 = (state_48621[(8)]);
var inst_48571 = (state_48621[(9)]);
var inst_48586 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_48570,inst_48577);
var tmp48631 = inst_48569;
var tmp48632 = inst_48571;
var inst_48568 = inst_48578;
var inst_48569__$1 = tmp48631;
var inst_48570__$1 = inst_48586;
var inst_48571__$1 = tmp48632;
var state_48621__$1 = (function (){var statearr_48636 = state_48621;
(statearr_48636[(7)] = inst_48569__$1);

(statearr_48636[(13)] = inst_48568);

(statearr_48636[(8)] = inst_48570__$1);

(statearr_48636[(9)] = inst_48571__$1);

return statearr_48636;
})();
var statearr_48637_48683 = state_48621__$1;
(statearr_48637_48683[(2)] = null);

(statearr_48637_48683[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (3))){
var inst_48619 = (state_48621[(2)]);
var state_48621__$1 = state_48621;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48621__$1,inst_48619);
} else {
if((state_val_48622 === (12))){
var inst_48568 = (state_48621[(13)]);
var inst_48577 = (state_48621[(11)]);
var inst_48576 = cljs.core.seq(inst_48568);
var inst_48577__$1 = cljs.core.first(inst_48576);
var inst_48578 = cljs.core.next(inst_48576);
var state_48621__$1 = (function (){var statearr_48638 = state_48621;
(statearr_48638[(12)] = inst_48578);

(statearr_48638[(11)] = inst_48577__$1);

return statearr_48638;
})();
if(cljs.core.truth_(inst_48577__$1)){
var statearr_48639_48684 = state_48621__$1;
(statearr_48639_48684[(1)] = (14));

} else {
var statearr_48640_48685 = state_48621__$1;
(statearr_48640_48685[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (2))){
var _ = (function (){var statearr_48641 = state_48621;
(statearr_48641[(4)] = cljs.core.cons((5),(state_48621[(4)])));

return statearr_48641;
})();
var inst_48533 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_48534 = (inst_48533 + (1));
var inst_48535 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_48534);
var state_48621__$1 = state_48621;
if(inst_48535){
var statearr_48642_48686 = state_48621__$1;
(statearr_48642_48686[(1)] = (6));

} else {
var statearr_48643_48687 = state_48621__$1;
(statearr_48643_48687[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (23))){
var inst_48577 = (state_48621[(11)]);
var inst_48594 = (state_48621[(2)]);
var inst_48595 = fluree.db.util.async.throw_err(inst_48594);
var inst_48596 = (inst_48577 == null);
var state_48621__$1 = (function (){var statearr_48644 = state_48621;
(statearr_48644[(10)] = inst_48595);

return statearr_48644;
})();
if(cljs.core.truth_(inst_48596)){
var statearr_48645_48688 = state_48621__$1;
(statearr_48645_48688[(1)] = (24));

} else {
var statearr_48646_48689 = state_48621__$1;
(statearr_48646_48689[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (19))){
var inst_48611 = (state_48621[(2)]);
var state_48621__$1 = state_48621;
var statearr_48647_48690 = state_48621__$1;
(statearr_48647_48690[(2)] = inst_48611);

(statearr_48647_48690[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (11))){
var inst_48616 = (state_48621[(2)]);
var _ = (function (){var statearr_48649 = state_48621;
(statearr_48649[(4)] = cljs.core.rest((state_48621[(4)])));

return statearr_48649;
})();
var state_48621__$1 = state_48621;
var statearr_48650_48691 = state_48621__$1;
(statearr_48650_48691[(2)] = inst_48616);

(statearr_48650_48691[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (9))){
var inst_48550 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_48551 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_48550);
var state_48621__$1 = state_48621;
var statearr_48651_48692 = state_48621__$1;
(statearr_48651_48692[(2)] = inst_48551);

(statearr_48651_48692[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (5))){
var _ = (function (){var statearr_48652 = state_48621;
(statearr_48652[(4)] = cljs.core.rest((state_48621[(4)])));

return statearr_48652;
})();
var state_48621__$1 = state_48621;
var ex48648 = (state_48621__$1[(2)]);
var statearr_48653_48693 = state_48621__$1;
(statearr_48653_48693[(5)] = ex48648);


var statearr_48654_48694 = state_48621__$1;
(statearr_48654_48694[(1)] = (4));

(statearr_48654_48694[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (14))){
var inst_48569 = (state_48621[(7)]);
var inst_48577 = (state_48621[(11)]);
var inst_48580 = inst_48577.t;
var inst_48581 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_48569,inst_48580);
var state_48621__$1 = state_48621;
var statearr_48655_48695 = state_48621__$1;
(statearr_48655_48695[(2)] = inst_48581);

(statearr_48655_48695[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (26))){
var inst_48606 = (state_48621[(2)]);
var state_48621__$1 = state_48621;
var statearr_48656_48696 = state_48621__$1;
(statearr_48656_48696[(2)] = inst_48606);

(statearr_48656_48696[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (16))){
var inst_48584 = (state_48621[(2)]);
var state_48621__$1 = state_48621;
if(cljs.core.truth_(inst_48584)){
var statearr_48657_48697 = state_48621__$1;
(statearr_48657_48697[(1)] = (17));

} else {
var statearr_48658_48698 = state_48621__$1;
(statearr_48658_48698[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (10))){
var inst_48553 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_48561 = cljs.core.seq(inst_48553);
var inst_48562 = cljs.core.first(inst_48561);
var inst_48563 = cljs.core.next(inst_48561);
var inst_48564 = cljs.core.first(inst_48553);
var inst_48565 = inst_48564.t;
var inst_48566 = cljs.core.PersistentVector.EMPTY;
var inst_48567 = db;
var inst_48568 = inst_48553;
var inst_48569 = inst_48565;
var inst_48570 = inst_48566;
var inst_48571 = inst_48567;
var state_48621__$1 = (function (){var statearr_48659 = state_48621;
(statearr_48659[(7)] = inst_48569);

(statearr_48659[(14)] = inst_48563);

(statearr_48659[(13)] = inst_48568);

(statearr_48659[(15)] = inst_48562);

(statearr_48659[(8)] = inst_48570);

(statearr_48659[(9)] = inst_48571);

return statearr_48659;
})();
var statearr_48660_48699 = state_48621__$1;
(statearr_48660_48699[(2)] = null);

(statearr_48660_48699[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (18))){
var state_48621__$1 = state_48621;
var statearr_48661_48700 = state_48621__$1;
(statearr_48661_48700[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_48622 === (8))){
var inst_48547 = (state_48621[(2)]);
var inst_48548 = cljs.core.empty_QMARK_(flakes);
var state_48621__$1 = (function (){var statearr_48663 = state_48621;
(statearr_48663[(16)] = inst_48547);

return statearr_48663;
})();
if(inst_48548){
var statearr_48664_48701 = state_48621__$1;
(statearr_48664_48701[(1)] = (9));

} else {
var statearr_48665_48702 = state_48621__$1;
(statearr_48665_48702[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__20477__auto__ = null;
var fluree$db$graphdb$state_machine__20477__auto____0 = (function (){
var statearr_48666 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48666[(0)] = fluree$db$graphdb$state_machine__20477__auto__);

(statearr_48666[(1)] = (1));

return statearr_48666;
});
var fluree$db$graphdb$state_machine__20477__auto____1 = (function (state_48621){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_48621);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e48667){var ex__20480__auto__ = e48667;
var statearr_48668_48703 = state_48621;
(statearr_48668_48703[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_48621[(4)]))){
var statearr_48669_48704 = state_48621;
(statearr_48669_48704[(1)] = cljs.core.first((state_48621[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__48705 = state_48621;
state_48621 = G__48705;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__20477__auto__ = function(state_48621){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__20477__auto____1.call(this,state_48621);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__20477__auto____0;
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__20477__auto____1;
return fluree$db$graphdb$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_48670 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_48670[(6)] = c__20603__auto___48672);

return statearr_48670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_48761){
var state_val_48762 = (state_48761[(1)]);
if((state_val_48762 === (7))){
var state_48761__$1 = state_48761;
var statearr_48763_48790 = state_48761__$1;
(statearr_48763_48790[(2)] = tt_id);

(statearr_48763_48790[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48762 === (1))){
var state_48761__$1 = state_48761;
var statearr_48764_48791 = state_48761__$1;
(statearr_48764_48791[(2)] = null);

(statearr_48764_48791[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48762 === (4))){
var inst_48706 = (state_48761[(2)]);
var state_48761__$1 = state_48761;
var statearr_48765_48792 = state_48761__$1;
(statearr_48765_48792[(2)] = inst_48706);

(statearr_48765_48792[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48762 === (13))){
var inst_48754 = (state_48761[(2)]);
var state_48761__$1 = state_48761;
var statearr_48766_48793 = state_48761__$1;
(statearr_48766_48793[(2)] = inst_48754);

(statearr_48766_48793[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48762 === (6))){
var inst_48714 = fluree.db.util.core.random_uuid();
var state_48761__$1 = state_48761;
var statearr_48767_48794 = state_48761__$1;
(statearr_48767_48794[(2)] = inst_48714);

(statearr_48767_48794[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48762 === (3))){
var inst_48759 = (state_48761[(2)]);
var state_48761__$1 = state_48761;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48761__$1,inst_48759);
} else {
if((state_val_48762 === (12))){
var inst_48737 = (state_48761[(7)]);
var state_48761__$1 = state_48761;
var statearr_48768_48795 = state_48761__$1;
(statearr_48768_48795[(2)] = inst_48737);

(statearr_48768_48795[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48762 === (2))){
var _ = (function (){var statearr_48769 = state_48761;
(statearr_48769[(4)] = cljs.core.cons((5),(state_48761[(4)])));

return statearr_48769;
})();
var inst_48712 = (tt_id == null);
var state_48761__$1 = state_48761;
if(cljs.core.truth_(inst_48712)){
var statearr_48770_48796 = state_48761__$1;
(statearr_48770_48796[(1)] = (6));

} else {
var statearr_48771_48797 = state_48761__$1;
(statearr_48771_48797[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48762 === (11))){
var inst_48737 = (state_48761[(7)]);
var inst_48744 = (state_48761[(8)]);
var inst_48747 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_48737,inst_48744);
var state_48761__$1 = state_48761;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48761__$1,(14),inst_48747);
} else {
if((state_val_48762 === (9))){
var inst_48738 = (state_48761[(9)]);
var inst_48744 = (state_48761[(8)]);
var inst_48743 = cljs.core.seq(inst_48738);
var inst_48744__$1 = cljs.core.first(inst_48743);
var inst_48745 = cljs.core.next(inst_48743);
var state_48761__$1 = (function (){var statearr_48773 = state_48761;
(statearr_48773[(10)] = inst_48745);

(statearr_48773[(8)] = inst_48744__$1);

return statearr_48773;
})();
if(cljs.core.truth_(inst_48744__$1)){
var statearr_48774_48798 = state_48761__$1;
(statearr_48774_48798[(1)] = (11));

} else {
var statearr_48775_48799 = state_48761__$1;
(statearr_48775_48799[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48762 === (5))){
var _ = (function (){var statearr_48776 = state_48761;
(statearr_48776[(4)] = cljs.core.rest((state_48761[(4)])));

return statearr_48776;
})();
var state_48761__$1 = state_48761;
var ex48772 = (state_48761__$1[(2)]);
var statearr_48777_48800 = state_48761__$1;
(statearr_48777_48800[(5)] = ex48772);


if((ex48772 instanceof Error)){
var statearr_48778_48801 = state_48761__$1;
(statearr_48778_48801[(1)] = (4));

(statearr_48778_48801[(5)] = null);

} else {
throw ex48772;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48762 === (14))){
var inst_48745 = (state_48761[(10)]);
var inst_48749 = (state_48761[(2)]);
var inst_48750 = fluree.db.util.async.throw_err(inst_48749);
var inst_48737 = inst_48750;
var inst_48738 = inst_48745;
var state_48761__$1 = (function (){var statearr_48779 = state_48761;
(statearr_48779[(7)] = inst_48737);

(statearr_48779[(9)] = inst_48738);

return statearr_48779;
})();
var statearr_48780_48802 = state_48761__$1;
(statearr_48780_48802[(2)] = null);

(statearr_48780_48802[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48762 === (10))){
var inst_48756 = (state_48761[(2)]);
var _ = (function (){var statearr_48781 = state_48761;
(statearr_48781[(4)] = cljs.core.rest((state_48761[(4)])));

return statearr_48781;
})();
var state_48761__$1 = state_48761;
var statearr_48782_48803 = state_48761__$1;
(statearr_48782_48803[(2)] = inst_48756);

(statearr_48782_48803[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48762 === (8))){
var inst_48717 = (state_48761[(2)]);
var inst_48718 = (function (){var tt_id_SINGLEQUOTE_ = inst_48717;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_48719 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_48717);
var inst_48720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48721 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_48722 = (new cljs.core.PersistentVector(null,4,(5),inst_48720,inst_48721,null));
var inst_48723 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_48718,inst_48719,inst_48722);
var inst_48724 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_48725 = cljs.core.reverse(inst_48724);
var inst_48726 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_48725);
var inst_48734 = cljs.core.seq(inst_48726);
var inst_48735 = cljs.core.first(inst_48734);
var inst_48736 = cljs.core.next(inst_48734);
var inst_48737 = inst_48723;
var inst_48738 = inst_48726;
var state_48761__$1 = (function (){var statearr_48783 = state_48761;
(statearr_48783[(11)] = inst_48735);

(statearr_48783[(7)] = inst_48737);

(statearr_48783[(9)] = inst_48738);

(statearr_48783[(12)] = inst_48736);

return statearr_48783;
})();
var statearr_48784_48804 = state_48761__$1;
(statearr_48784_48804[(2)] = null);

(statearr_48784_48804[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__20477__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__20477__auto____0 = (function (){
var statearr_48785 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48785[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__20477__auto__);

(statearr_48785[(1)] = (1));

return statearr_48785;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__20477__auto____1 = (function (state_48761){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_48761);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e48786){var ex__20480__auto__ = e48786;
var statearr_48787_48805 = state_48761;
(statearr_48787_48805[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_48761[(4)]))){
var statearr_48788_48806 = state_48761;
(statearr_48788_48806[(1)] = cljs.core.first((state_48761[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__48807 = state_48761;
state_48761 = G__48807;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__20477__auto__ = function(state_48761){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__20477__auto____1.call(this,state_48761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__20477__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__20477__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_48789 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_48789[(6)] = c__20603__auto__);

return statearr_48789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__20603__auto___48994 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_48925){
var state_val_48926 = (state_48925[(1)]);
if((state_val_48926 === (7))){
var inst_48835 = (state_48925[(7)]);
var inst_48835__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_48925__$1 = (function (){var statearr_48927 = state_48925;
(statearr_48927[(7)] = inst_48835__$1);

return statearr_48927;
})();
if(inst_48835__$1){
var statearr_48928_48995 = state_48925__$1;
(statearr_48928_48995[(1)] = (13));

} else {
var statearr_48929_48996 = state_48925__$1;
(statearr_48929_48996[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (20))){
var state_48925__$1 = state_48925;
var statearr_48930_48997 = state_48925__$1;
(statearr_48930_48997[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (27))){
var inst_48871 = (state_48925[(8)]);
var inst_48875 = inst_48871.s;
var state_48925__$1 = state_48925;
var statearr_48932_48998 = state_48925__$1;
(statearr_48932_48998[(2)] = inst_48875);

(statearr_48932_48998[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (1))){
var state_48925__$1 = state_48925;
var statearr_48933_48999 = state_48925__$1;
(statearr_48933_48999[(2)] = null);

(statearr_48933_48999[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (24))){
var inst_48865 = (state_48925[(9)]);
var inst_48869 = cljs.core.first(inst_48865);
var state_48925__$1 = state_48925;
var statearr_48934_49000 = state_48925__$1;
(statearr_48934_49000[(2)] = inst_48869);

(statearr_48934_49000[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (39))){
var state_48925__$1 = state_48925;
var statearr_48935_49001 = state_48925__$1;
(statearr_48935_49001[(1)] = (41));



return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (4))){
var inst_48808 = (state_48925[(2)]);
var inst_48809 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_48810 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_48811 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_48812 = cljs.core.PersistentHashMap.fromArrays(inst_48810,inst_48811);
var inst_48813 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_48809,inst_48812,inst_48808);
var inst_48814 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_48813);
var state_48925__$1 = state_48925;
var statearr_48937_49002 = state_48925__$1;
(statearr_48937_49002[(2)] = inst_48814);

(statearr_48937_49002[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (15))){
var inst_48842 = (state_48925[(2)]);
var state_48925__$1 = state_48925;
if(cljs.core.truth_(inst_48842)){
var statearr_48938_49003 = state_48925__$1;
(statearr_48938_49003[(1)] = (16));

} else {
var statearr_48939_49004 = state_48925__$1;
(statearr_48939_49004[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (21))){
var inst_48891 = (state_48925[(2)]);
var state_48925__$1 = state_48925;
var statearr_48940_49005 = state_48925__$1;
(statearr_48940_49005[(2)] = inst_48891);

(statearr_48940_49005[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (31))){
var inst_48889 = (state_48925[(2)]);
var state_48925__$1 = state_48925;
var statearr_48941_49006 = state_48925__$1;
(statearr_48941_49006[(2)] = inst_48889);

(statearr_48941_49006[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (32))){
var inst_48895 = (state_48925[(10)]);
var inst_48897 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_48895);
var state_48925__$1 = state_48925;
var statearr_48942_49007 = state_48925__$1;
(statearr_48942_49007[(2)] = inst_48897);

(statearr_48942_49007[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (40))){
var inst_48918 = (state_48925[(2)]);
var state_48925__$1 = state_48925;
var statearr_48943_49008 = state_48925__$1;
(statearr_48943_49008[(2)] = inst_48918);

(statearr_48943_49008[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (33))){
var inst_48899 = (state_48925[(11)]);
var inst_48895 = (state_48925[(10)]);
var inst_48899__$1 = (inst_48895 == null);
var state_48925__$1 = (function (){var statearr_48944 = state_48925;
(statearr_48944[(11)] = inst_48899__$1);

return statearr_48944;
})();
if(cljs.core.truth_(inst_48899__$1)){
var statearr_48945_49009 = state_48925__$1;
(statearr_48945_49009[(1)] = (35));

} else {
var statearr_48946_49010 = state_48925__$1;
(statearr_48946_49010[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (13))){
var inst_48837 = cljs.core.first(ident);
var inst_48838 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_48837);
var inst_48839 = (inst_48838 == null);
var state_48925__$1 = state_48925;
var statearr_48947_49011 = state_48925__$1;
(statearr_48947_49011[(2)] = inst_48839);

(statearr_48947_49011[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (22))){
var inst_48865 = (state_48925[(9)]);
var inst_48864 = (state_48925[(2)]);
var inst_48865__$1 = fluree.db.util.async.throw_err(inst_48864);
var inst_48866 = (inst_48865__$1 == null);
var state_48925__$1 = (function (){var statearr_48948 = state_48925;
(statearr_48948[(9)] = inst_48865__$1);

return statearr_48948;
})();
if(cljs.core.truth_(inst_48866)){
var statearr_48949_49012 = state_48925__$1;
(statearr_48949_49012[(1)] = (23));

} else {
var statearr_48950_49013 = state_48925__$1;
(statearr_48950_49013[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (36))){
var inst_48899 = (state_48925[(11)]);
var state_48925__$1 = state_48925;
var statearr_48951_49014 = state_48925__$1;
(statearr_48951_49014[(2)] = inst_48899);

(statearr_48951_49014[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (41))){
var inst_48913 = cljs.core.async.close_BANG_(return_chan);
var state_48925__$1 = state_48925;
var statearr_48952_49015 = state_48925__$1;
(statearr_48952_49015[(2)] = inst_48913);

(statearr_48952_49015[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (43))){
var inst_48916 = (state_48925[(2)]);
var state_48925__$1 = state_48925;
var statearr_48953_49016 = state_48925__$1;
(statearr_48953_49016[(2)] = inst_48916);

(statearr_48953_49016[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (29))){
var inst_48880 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_48881 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_48880].join('');
var inst_48882 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_48883 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_48884 = cljs.core.PersistentHashMap.fromArrays(inst_48882,inst_48883);
var inst_48885 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_48881,inst_48884);
var inst_48886 = (function(){throw inst_48885})();
var state_48925__$1 = state_48925;
var statearr_48954_49017 = state_48925__$1;
(statearr_48954_49017[(2)] = inst_48886);

(statearr_48954_49017[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (6))){
var inst_48822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48823 = [ident];
var inst_48824 = (new cljs.core.PersistentVector(null,1,(5),inst_48822,inst_48823,null));
var inst_48825 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_48824);
var state_48925__$1 = state_48925;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48925__$1,(9),inst_48825);
} else {
if((state_val_48926 === (28))){
var inst_48877 = (state_48925[(2)]);
var state_48925__$1 = state_48925;
var statearr_48955_49018 = state_48925__$1;
(statearr_48955_49018[(2)] = inst_48877);

(statearr_48955_49018[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (25))){
var inst_48871 = (state_48925[(8)]);
var inst_48871__$1 = (state_48925[(2)]);
var inst_48872 = (inst_48871__$1 == null);
var state_48925__$1 = (function (){var statearr_48956 = state_48925;
(statearr_48956[(8)] = inst_48871__$1);

return statearr_48956;
})();
if(cljs.core.truth_(inst_48872)){
var statearr_48957_49019 = state_48925__$1;
(statearr_48957_49019[(1)] = (26));

} else {
var statearr_48958_49020 = state_48925__$1;
(statearr_48958_49020[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (34))){
var inst_48920 = (state_48925[(2)]);
var _ = (function (){var statearr_48959 = state_48925;
(statearr_48959[(4)] = cljs.core.rest((state_48925[(4)])));

return statearr_48959;
})();
var state_48925__$1 = state_48925;
var statearr_48960_49021 = state_48925__$1;
(statearr_48960_49021[(2)] = inst_48920);

(statearr_48960_49021[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (17))){
var inst_48853 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_48925__$1 = state_48925;
if(inst_48853){
var statearr_48961_49022 = state_48925__$1;
(statearr_48961_49022[(1)] = (19));

} else {
var statearr_48962_49023 = state_48925__$1;
(statearr_48962_49023[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (3))){
var inst_48923 = (state_48925[(2)]);
var state_48925__$1 = state_48925;
return cljs.core.async.impl.ioc_helpers.return_chan(state_48925__$1,inst_48923);
} else {
if((state_val_48926 === (12))){
var inst_48833 = (state_48925[(2)]);
var state_48925__$1 = state_48925;
var statearr_48963_49024 = state_48925__$1;
(statearr_48963_49024[(2)] = inst_48833);

(statearr_48963_49024[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (2))){
var _ = (function (){var statearr_48964 = state_48925;
(statearr_48964[(4)] = cljs.core.cons((5),(state_48925[(4)])));

return statearr_48964;
})();
var inst_48820 = typeof ident === 'number';
var state_48925__$1 = state_48925;
if(cljs.core.truth_(inst_48820)){
var statearr_48965_49025 = state_48925__$1;
(statearr_48965_49025[(1)] = (6));

} else {
var statearr_48966_49026 = state_48925__$1;
(statearr_48966_49026[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (23))){
var state_48925__$1 = state_48925;
var statearr_48967_49027 = state_48925__$1;
(statearr_48967_49027[(2)] = null);

(statearr_48967_49027[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (35))){
var state_48925__$1 = state_48925;
var statearr_48968_49028 = state_48925__$1;
(statearr_48968_49028[(2)] = strict_QMARK_);

(statearr_48968_49028[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (19))){
var inst_48856 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48857 = cljs.core.first(ident);
var inst_48858 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_48857);
var inst_48859 = cljs.core.second(ident);
var inst_48860 = [inst_48858,inst_48859];
var inst_48861 = (new cljs.core.PersistentVector(null,2,(5),inst_48856,inst_48860,null));
var inst_48862 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_48861);
var state_48925__$1 = state_48925;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_48925__$1,(22),inst_48862);
} else {
if((state_val_48926 === (11))){
var state_48925__$1 = state_48925;
var statearr_48970_49029 = state_48925__$1;
(statearr_48970_49029[(2)] = null);

(statearr_48970_49029[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (9))){
var inst_48827 = (state_48925[(2)]);
var inst_48828 = fluree.db.util.async.throw_err(inst_48827);
var inst_48829 = cljs.core.not_empty(inst_48828);
var state_48925__$1 = state_48925;
if(cljs.core.truth_(inst_48829)){
var statearr_48971_49030 = state_48925__$1;
(statearr_48971_49030[(1)] = (10));

} else {
var statearr_48972_49031 = state_48925__$1;
(statearr_48972_49031[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (5))){
var _ = (function (){var statearr_48973 = state_48925;
(statearr_48973[(4)] = cljs.core.rest((state_48925[(4)])));

return statearr_48973;
})();
var state_48925__$1 = state_48925;
var ex48969 = (state_48925__$1[(2)]);
var statearr_48974_49032 = state_48925__$1;
(statearr_48974_49032[(5)] = ex48969);


var statearr_48975_49033 = state_48925__$1;
(statearr_48975_49033[(1)] = (4));

(statearr_48975_49033[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (14))){
var inst_48835 = (state_48925[(7)]);
var state_48925__$1 = state_48925;
var statearr_48976_49034 = state_48925__$1;
(statearr_48976_49034[(2)] = inst_48835);

(statearr_48976_49034[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (26))){
var state_48925__$1 = state_48925;
var statearr_48977_49035 = state_48925__$1;
(statearr_48977_49035[(2)] = null);

(statearr_48977_49035[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (16))){
var inst_48844 = cljs.core.first(ident);
var inst_48845 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_48844], 0));
var inst_48846 = ["Subject ID lookup failed. The predicate ",inst_48845," does not exist."].join('');
var inst_48847 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_48848 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_48849 = cljs.core.PersistentHashMap.fromArrays(inst_48847,inst_48848);
var inst_48850 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_48846,inst_48849);
var inst_48851 = (function(){throw inst_48850})();
var state_48925__$1 = state_48925;
var statearr_48978_49036 = state_48925__$1;
(statearr_48978_49036[(2)] = inst_48851);

(statearr_48978_49036[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (38))){
var inst_48905 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_48906 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_48907 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_48908 = cljs.core.PersistentHashMap.fromArrays(inst_48906,inst_48907);
var inst_48909 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_48905,inst_48908);
var inst_48910 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_48909);
var state_48925__$1 = state_48925;
var statearr_48979_49037 = state_48925__$1;
(statearr_48979_49037[(2)] = inst_48910);

(statearr_48979_49037[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (30))){
var state_48925__$1 = state_48925;
var statearr_48980_49038 = state_48925__$1;
(statearr_48980_49038[(2)] = null);

(statearr_48980_49038[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (10))){
var state_48925__$1 = state_48925;
var statearr_48981_49039 = state_48925__$1;
(statearr_48981_49039[(2)] = ident);

(statearr_48981_49039[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (18))){
var inst_48893 = (state_48925[(2)]);
var state_48925__$1 = state_48925;
var statearr_48982_49040 = state_48925__$1;
(statearr_48982_49040[(2)] = inst_48893);

(statearr_48982_49040[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (42))){
var state_48925__$1 = state_48925;
var statearr_48983_49041 = state_48925__$1;
(statearr_48983_49041[(2)] = null);

(statearr_48983_49041[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (37))){
var inst_48903 = (state_48925[(2)]);
var state_48925__$1 = state_48925;
if(cljs.core.truth_(inst_48903)){
var statearr_48984_49042 = state_48925__$1;
(statearr_48984_49042[(1)] = (38));

} else {
var statearr_48985_49043 = state_48925__$1;
(statearr_48985_49043[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_48926 === (8))){
var inst_48895 = (state_48925[(10)]);
var inst_48895__$1 = (state_48925[(2)]);
var state_48925__$1 = (function (){var statearr_48986 = state_48925;
(statearr_48986[(10)] = inst_48895__$1);

return statearr_48986;
})();
if(cljs.core.truth_(inst_48895__$1)){
var statearr_48987_49044 = state_48925__$1;
(statearr_48987_49044[(1)] = (32));

} else {
var statearr_48988_49045 = state_48925__$1;
(statearr_48988_49045[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__20477__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__20477__auto____0 = (function (){
var statearr_48989 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48989[(0)] = fluree$db$graphdb$subid_$_state_machine__20477__auto__);

(statearr_48989[(1)] = (1));

return statearr_48989;
});
var fluree$db$graphdb$subid_$_state_machine__20477__auto____1 = (function (state_48925){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_48925);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e48990){var ex__20480__auto__ = e48990;
var statearr_48991_49046 = state_48925;
(statearr_48991_49046[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_48925[(4)]))){
var statearr_48992_49047 = state_48925;
(statearr_48992_49047[(1)] = cljs.core.first((state_48925[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__49048 = state_48925;
state_48925 = G__49048;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__20477__auto__ = function(state_48925){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__20477__auto____1.call(this,state_48925);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__20477__auto____0;
fluree$db$graphdb$subid_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__20477__auto____1;
return fluree$db$graphdb$subid_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_48993 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_48993[(6)] = c__20603__auto___48994);

return statearr_48993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k49050,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__49054 = k49050;
var G__49054__$1 = (((G__49054 instanceof cljs.core.Keyword))?G__49054.fqn:null);
switch (G__49054__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49050,else__4475__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__49055){
var vec__49056 = p__49055;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49056,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49056,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49049){
var self__ = this;
var G__49049__$1 = this;
return (new cljs.core.RecordIter((0),G__49049__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__49059 = (function (coll__4469__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__49059(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49051,other49052){
var self__ = this;
var this49051__$1 = this;
return (((!((other49052 == null)))) && ((((this49051__$1.constructor === other49052.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.conn,other49052.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.network,other49052.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.dbid,other49052.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.block,other49052.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.t,other49052.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.tt_id,other49052.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.stats,other49052.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.spot,other49052.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.psot,other49052.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.post,other49052.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.opst,other49052.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.schema,other49052.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.settings,other49052.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.index_configs,other49052.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.schema_cache,other49052.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.novelty,other49052.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.permissions,other49052.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.fork,other49052.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.fork_block,other49052.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.current_db_fn,other49052.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49051__$1.__extmap,other49052.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k49050){
var self__ = this;
var this__4479__auto____$1 = this;
var G__49060 = k49050;
var G__49060__$1 = (((G__49060 instanceof cljs.core.Keyword))?G__49060.fqn:null);
switch (G__49060__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k49050);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__49049){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__49061 = cljs.core.keyword_identical_QMARK_;
var expr__49062 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__49064 = cljs.core.cst$kw$conn;
var G__49065 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49064,G__49065) : pred__49061.call(null,G__49064,G__49065));
})())){
return (new fluree.db.graphdb.GraphDb(G__49049,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49066 = cljs.core.cst$kw$network;
var G__49067 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49066,G__49067) : pred__49061.call(null,G__49066,G__49067));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__49049,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49068 = cljs.core.cst$kw$dbid;
var G__49069 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49068,G__49069) : pred__49061.call(null,G__49068,G__49069));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__49049,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49070 = cljs.core.cst$kw$block;
var G__49071 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49070,G__49071) : pred__49061.call(null,G__49070,G__49071));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__49049,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49072 = cljs.core.cst$kw$t;
var G__49073 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49072,G__49073) : pred__49061.call(null,G__49072,G__49073));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__49049,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49074 = cljs.core.cst$kw$tt_DASH_id;
var G__49075 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49074,G__49075) : pred__49061.call(null,G__49074,G__49075));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__49049,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49076 = cljs.core.cst$kw$stats;
var G__49077 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49076,G__49077) : pred__49061.call(null,G__49076,G__49077));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__49049,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49078 = cljs.core.cst$kw$spot;
var G__49079 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49078,G__49079) : pred__49061.call(null,G__49078,G__49079));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__49049,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49080 = cljs.core.cst$kw$psot;
var G__49081 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49080,G__49081) : pred__49061.call(null,G__49080,G__49081));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__49049,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49082 = cljs.core.cst$kw$post;
var G__49083 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49082,G__49083) : pred__49061.call(null,G__49082,G__49083));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__49049,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49084 = cljs.core.cst$kw$opst;
var G__49085 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49084,G__49085) : pred__49061.call(null,G__49084,G__49085));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__49049,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49086 = cljs.core.cst$kw$schema;
var G__49087 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49086,G__49087) : pred__49061.call(null,G__49086,G__49087));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__49049,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49088 = cljs.core.cst$kw$settings;
var G__49089 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49088,G__49089) : pred__49061.call(null,G__49088,G__49089));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__49049,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49090 = cljs.core.cst$kw$index_DASH_configs;
var G__49091 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49090,G__49091) : pred__49061.call(null,G__49090,G__49091));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__49049,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49092 = cljs.core.cst$kw$schema_DASH_cache;
var G__49093 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49092,G__49093) : pred__49061.call(null,G__49092,G__49093));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__49049,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49094 = cljs.core.cst$kw$novelty;
var G__49095 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49094,G__49095) : pred__49061.call(null,G__49094,G__49095));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__49049,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49096 = cljs.core.cst$kw$permissions;
var G__49097 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49096,G__49097) : pred__49061.call(null,G__49096,G__49097));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__49049,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49098 = cljs.core.cst$kw$fork;
var G__49099 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49098,G__49099) : pred__49061.call(null,G__49098,G__49099));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__49049,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49100 = cljs.core.cst$kw$fork_DASH_block;
var G__49101 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49100,G__49101) : pred__49061.call(null,G__49100,G__49101));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__49049,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__49102 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__49103 = expr__49062;
return (pred__49061.cljs$core$IFn$_invoke$arity$2 ? pred__49061.cljs$core$IFn$_invoke$arity$2(G__49102,G__49103) : pred__49061.call(null,G__49102,G__49103));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__49049,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__49049),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__49049){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__49049,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_49119){
var state_val_49120 = (state_49119[(1)]);
if((state_val_49120 === (1))){
var state_49119__$1 = state_49119;
var statearr_49121_49388 = state_49119__$1;
(statearr_49121_49388[(2)] = null);

(statearr_49121_49388[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49120 === (2))){
var _ = (function (){var statearr_49122 = state_49119;
(statearr_49122[(4)] = cljs.core.cons((5),(state_49119[(4)])));

return statearr_49122;
})();
var inst_49110 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_49119__$1 = state_49119;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49119__$1,(6),inst_49110);
} else {
if((state_val_49120 === (3))){
var inst_49117 = (state_49119[(2)]);
var state_49119__$1 = state_49119;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49119__$1,inst_49117);
} else {
if((state_val_49120 === (4))){
var inst_49104 = (state_49119[(2)]);
var state_49119__$1 = state_49119;
var statearr_49124_49389 = state_49119__$1;
(statearr_49124_49389[(2)] = inst_49104);

(statearr_49124_49389[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49120 === (5))){
var _ = (function (){var statearr_49125 = state_49119;
(statearr_49125[(4)] = cljs.core.rest((state_49119[(4)])));

return statearr_49125;
})();
var state_49119__$1 = state_49119;
var ex49123 = (state_49119__$1[(2)]);
var statearr_49126_49390 = state_49119__$1;
(statearr_49126_49390[(5)] = ex49123);


if((ex49123 instanceof Error)){
var statearr_49127_49391 = state_49119__$1;
(statearr_49127_49391[(1)] = (4));

(statearr_49127_49391[(5)] = null);

} else {
throw ex49123;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49120 === (6))){
var inst_49112 = (state_49119[(2)]);
var inst_49113 = fluree.db.util.async.throw_err(inst_49112);
var inst_49114 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_49113,cljs.core.cst$kw$permissions,self__.permissions);
var _ = (function (){var statearr_49128 = state_49119;
(statearr_49128[(4)] = cljs.core.rest((state_49119[(4)])));

return statearr_49128;
})();
var state_49119__$1 = state_49119;
var statearr_49129_49392 = state_49119__$1;
(statearr_49129_49392[(2)] = inst_49114);

(statearr_49129_49392[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__20477__auto__ = null;
var fluree$db$graphdb$state_machine__20477__auto____0 = (function (){
var statearr_49130 = [null,null,null,null,null,null,null];
(statearr_49130[(0)] = fluree$db$graphdb$state_machine__20477__auto__);

(statearr_49130[(1)] = (1));

return statearr_49130;
});
var fluree$db$graphdb$state_machine__20477__auto____1 = (function (state_49119){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_49119);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e49131){var ex__20480__auto__ = e49131;
var statearr_49132_49393 = state_49119;
(statearr_49132_49393[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_49119[(4)]))){
var statearr_49133_49394 = state_49119;
(statearr_49133_49394[(1)] = cljs.core.first((state_49119[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__49395 = state_49119;
state_49119 = G__49395;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__20477__auto__ = function(state_49119){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__20477__auto____1.call(this,state_49119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__20477__auto____0;
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__20477__auto____1;
return fluree$db$graphdb$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_49134 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_49134[(6)] = c__20603__auto__);

return statearr_49134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__49135 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$partition,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__49135.cljs$core$IFn$_invoke$arity$1 ? fexpr__49135.cljs$core$IFn$_invoke$arity$1(property) : fexpr__49135.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__49136 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$retractDuplicates,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__49136.cljs$core$IFn$_invoke$arity$1 ? fexpr__49136.cljs$core$IFn$_invoke$arity$1(property) : fexpr__49136.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__49137 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,cljs.core.cst$kw$partition,G__49137);
} else {
return G__49137;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_49169){
var state_val_49170 = (state_49169[(1)]);
if((state_val_49170 === (7))){
var state_49169__$1 = state_49169;
var statearr_49171_49396 = state_49169__$1;
(statearr_49171_49396[(2)] = null);

(statearr_49171_49396[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49170 === (1))){
var state_49169__$1 = state_49169;
var statearr_49172_49397 = state_49169__$1;
(statearr_49172_49397[(2)] = null);

(statearr_49172_49397[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49170 === (4))){
var inst_49138 = (state_49169[(2)]);
var state_49169__$1 = state_49169;
var statearr_49173_49398 = state_49169__$1;
(statearr_49173_49398[(2)] = inst_49138);

(statearr_49173_49398[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49170 === (6))){
var inst_49152 = (state_49169[(7)]);
var inst_49151 = (state_49169[(2)]);
var inst_49152__$1 = fluree.db.util.async.throw_err(inst_49151);
var inst_49153 = (inst_49152__$1 == null);
var state_49169__$1 = (function (){var statearr_49174 = state_49169;
(statearr_49174[(7)] = inst_49152__$1);

return statearr_49174;
})();
if(cljs.core.truth_(inst_49153)){
var statearr_49175_49399 = state_49169__$1;
(statearr_49175_49399[(1)] = (7));

} else {
var statearr_49176_49400 = state_49169__$1;
(statearr_49176_49400[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49170 === (3))){
var inst_49167 = (state_49169[(2)]);
var state_49169__$1 = state_49169;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49169__$1,inst_49167);
} else {
if((state_val_49170 === (12))){
var inst_49164 = (state_49169[(2)]);
var _ = (function (){var statearr_49177 = state_49169;
(statearr_49177[(4)] = cljs.core.rest((state_49169[(4)])));

return statearr_49177;
})();
var state_49169__$1 = state_49169;
var statearr_49178_49401 = state_49169__$1;
(statearr_49178_49401[(2)] = inst_49164);

(statearr_49178_49401[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49170 === (2))){
var _ = (function (){var statearr_49179 = state_49169;
(statearr_49179[(4)] = cljs.core.cons((5),(state_49169[(4)])));

return statearr_49179;
})();
var inst_49145 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_49146 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49147 = [tag_id,(30)];
var inst_49148 = (new cljs.core.PersistentVector(null,2,(5),inst_49146,inst_49147,null));
var inst_49149 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_49145,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_49148);
var state_49169__$1 = state_49169;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49169__$1,(6),inst_49149);
} else {
if((state_val_49170 === (11))){
var inst_49158 = (state_49169[(8)]);
var inst_49162 = inst_49158.o;
var state_49169__$1 = state_49169;
var statearr_49181_49402 = state_49169__$1;
(statearr_49181_49402[(2)] = inst_49162);

(statearr_49181_49402[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49170 === (9))){
var inst_49158 = (state_49169[(8)]);
var inst_49158__$1 = (state_49169[(2)]);
var inst_49159 = (inst_49158__$1 == null);
var state_49169__$1 = (function (){var statearr_49182 = state_49169;
(statearr_49182[(8)] = inst_49158__$1);

return statearr_49182;
})();
if(cljs.core.truth_(inst_49159)){
var statearr_49183_49403 = state_49169__$1;
(statearr_49183_49403[(1)] = (10));

} else {
var statearr_49184_49404 = state_49169__$1;
(statearr_49184_49404[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49170 === (5))){
var _ = (function (){var statearr_49185 = state_49169;
(statearr_49185[(4)] = cljs.core.rest((state_49169[(4)])));

return statearr_49185;
})();
var state_49169__$1 = state_49169;
var ex49180 = (state_49169__$1[(2)]);
var statearr_49186_49405 = state_49169__$1;
(statearr_49186_49405[(5)] = ex49180);


if((ex49180 instanceof Error)){
var statearr_49187_49406 = state_49169__$1;
(statearr_49187_49406[(1)] = (4));

(statearr_49187_49406[(5)] = null);

} else {
throw ex49180;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49170 === (10))){
var state_49169__$1 = state_49169;
var statearr_49188_49407 = state_49169__$1;
(statearr_49188_49407[(2)] = null);

(statearr_49188_49407[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49170 === (8))){
var inst_49152 = (state_49169[(7)]);
var inst_49156 = cljs.core.first(inst_49152);
var state_49169__$1 = state_49169;
var statearr_49189_49408 = state_49169__$1;
(statearr_49189_49408[(2)] = inst_49156);

(statearr_49189_49408[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__20477__auto__ = null;
var fluree$db$graphdb$state_machine__20477__auto____0 = (function (){
var statearr_49190 = [null,null,null,null,null,null,null,null,null];
(statearr_49190[(0)] = fluree$db$graphdb$state_machine__20477__auto__);

(statearr_49190[(1)] = (1));

return statearr_49190;
});
var fluree$db$graphdb$state_machine__20477__auto____1 = (function (state_49169){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_49169);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e49191){var ex__20480__auto__ = e49191;
var statearr_49192_49409 = state_49169;
(statearr_49192_49409[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_49169[(4)]))){
var statearr_49193_49410 = state_49169;
(statearr_49193_49410[(1)] = cljs.core.first((state_49169[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__49411 = state_49169;
state_49169 = G__49411;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__20477__auto__ = function(state_49169){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__20477__auto____1.call(this,state_49169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__20477__auto____0;
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__20477__auto____1;
return fluree$db$graphdb$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_49194 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_49194[(6)] = c__20603__auto__);

return statearr_49194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_49230){
var state_val_49231 = (state_49230[(1)]);
if((state_val_49231 === (7))){
var inst_49204 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_49230__$1 = state_49230;
var statearr_49232_49412 = state_49230__$1;
(statearr_49232_49412[(2)] = inst_49204);

(statearr_49232_49412[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (1))){
var state_49230__$1 = state_49230;
var statearr_49233_49413 = state_49230__$1;
(statearr_49233_49413[(2)] = null);

(statearr_49233_49413[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (4))){
var inst_49195 = (state_49230[(2)]);
var state_49230__$1 = state_49230;
var statearr_49234_49414 = state_49230__$1;
(statearr_49234_49414[(2)] = inst_49195);

(statearr_49234_49414[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (15))){
var inst_49225 = (state_49230[(2)]);
var _ = (function (){var statearr_49235 = state_49230;
(statearr_49235[(4)] = cljs.core.rest((state_49230[(4)])));

return statearr_49235;
})();
var state_49230__$1 = state_49230;
var statearr_49236_49415 = state_49230__$1;
(statearr_49236_49415[(2)] = inst_49225);

(statearr_49236_49415[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (13))){
var inst_49210 = (state_49230[(7)]);
var inst_49216 = clojure.string.includes_QMARK_(inst_49210,":");
var state_49230__$1 = state_49230;
if(inst_49216){
var statearr_49237_49416 = state_49230__$1;
(statearr_49237_49416[(1)] = (16));

} else {
var statearr_49238_49417 = state_49230__$1;
(statearr_49238_49417[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (6))){
var state_49230__$1 = state_49230;
var statearr_49239_49418 = state_49230__$1;
(statearr_49239_49418[(2)] = pred);

(statearr_49239_49418[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (17))){
var inst_49210 = (state_49230[(7)]);
var state_49230__$1 = state_49230;
var statearr_49240_49419 = state_49230__$1;
(statearr_49240_49419[(2)] = inst_49210);

(statearr_49240_49419[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (3))){
var inst_49228 = (state_49230[(2)]);
var state_49230__$1 = state_49230;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49230__$1,inst_49228);
} else {
if((state_val_49231 === (12))){
var inst_49214 = (state_49230[(2)]);
var state_49230__$1 = state_49230;
if(cljs.core.truth_(inst_49214)){
var statearr_49241_49420 = state_49230__$1;
(statearr_49241_49420[(1)] = (13));

} else {
var statearr_49242_49421 = state_49230__$1;
(statearr_49242_49421[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (2))){
var _ = (function (){var statearr_49243 = state_49230;
(statearr_49243[(4)] = cljs.core.cons((5),(state_49230[(4)])));

return statearr_49243;
})();
var inst_49201 = typeof pred === 'string';
var state_49230__$1 = state_49230;
if(cljs.core.truth_(inst_49201)){
var statearr_49244_49422 = state_49230__$1;
(statearr_49244_49422[(1)] = (6));

} else {
var statearr_49245_49423 = state_49230__$1;
(statearr_49245_49423[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (11))){
var inst_49206 = (state_49230[(8)]);
var state_49230__$1 = state_49230;
var statearr_49247_49424 = state_49230__$1;
(statearr_49247_49424[(2)] = inst_49206);

(statearr_49247_49424[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (9))){
var inst_49206 = (state_49230[(8)]);
var inst_49209 = (state_49230[(2)]);
var inst_49210 = fluree.db.util.async.throw_err(inst_49209);
var state_49230__$1 = (function (){var statearr_49248 = state_49230;
(statearr_49248[(7)] = inst_49210);

return statearr_49248;
})();
if(cljs.core.truth_(inst_49206)){
var statearr_49249_49425 = state_49230__$1;
(statearr_49249_49425[(1)] = (10));

} else {
var statearr_49250_49426 = state_49230__$1;
(statearr_49250_49426[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (5))){
var _ = (function (){var statearr_49251 = state_49230;
(statearr_49251[(4)] = cljs.core.rest((state_49230[(4)])));

return statearr_49251;
})();
var state_49230__$1 = state_49230;
var ex49246 = (state_49230__$1[(2)]);
var statearr_49252_49427 = state_49230__$1;
(statearr_49252_49427[(5)] = ex49246);


if((ex49246 instanceof Error)){
var statearr_49253_49428 = state_49230__$1;
(statearr_49253_49428[(1)] = (4));

(statearr_49253_49428[(5)] = null);

} else {
throw ex49246;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (14))){
var state_49230__$1 = state_49230;
var statearr_49254_49429 = state_49230__$1;
(statearr_49254_49429[(2)] = null);

(statearr_49254_49429[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (16))){
var inst_49210 = (state_49230[(7)]);
var inst_49218 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_49210,/:/);
var inst_49219 = cljs.core.second(inst_49218);
var state_49230__$1 = state_49230;
var statearr_49255_49430 = state_49230__$1;
(statearr_49255_49430[(2)] = inst_49219);

(statearr_49255_49430[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (10))){
var inst_49210 = (state_49230[(7)]);
var state_49230__$1 = state_49230;
var statearr_49256_49431 = state_49230__$1;
(statearr_49256_49431[(2)] = inst_49210);

(statearr_49256_49431[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (18))){
var inst_49222 = (state_49230[(2)]);
var state_49230__$1 = state_49230;
var statearr_49257_49432 = state_49230__$1;
(statearr_49257_49432[(2)] = inst_49222);

(statearr_49257_49432[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49231 === (8))){
var inst_49206 = (state_49230[(2)]);
var inst_49207 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_49230__$1 = (function (){var statearr_49258 = state_49230;
(statearr_49258[(8)] = inst_49206);

return statearr_49258;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49230__$1,(9),inst_49207);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__20477__auto__ = null;
var fluree$db$graphdb$state_machine__20477__auto____0 = (function (){
var statearr_49259 = [null,null,null,null,null,null,null,null,null];
(statearr_49259[(0)] = fluree$db$graphdb$state_machine__20477__auto__);

(statearr_49259[(1)] = (1));

return statearr_49259;
});
var fluree$db$graphdb$state_machine__20477__auto____1 = (function (state_49230){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_49230);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e49260){var ex__20480__auto__ = e49260;
var statearr_49261_49433 = state_49230;
(statearr_49261_49433[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_49230[(4)]))){
var statearr_49262_49434 = state_49230;
(statearr_49262_49434[(1)] = cljs.core.first((state_49230[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__49435 = state_49230;
state_49230 = G__49435;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__20477__auto__ = function(state_49230){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__20477__auto____1.call(this,state_49230);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__20477__auto____0;
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__20477__auto____1;
return fluree$db$graphdb$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_49263 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_49263[(6)] = c__20603__auto__);

return statearr_49263;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_49296){
var state_val_49297 = (state_49296[(1)]);
if((state_val_49297 === (7))){
var state_49296__$1 = state_49296;
var statearr_49298_49436 = state_49296__$1;
(statearr_49298_49436[(2)] = null);

(statearr_49298_49436[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49297 === (1))){
var state_49296__$1 = state_49296;
var statearr_49299_49437 = state_49296__$1;
(statearr_49299_49437[(2)] = null);

(statearr_49299_49437[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49297 === (4))){
var inst_49264 = (state_49296[(2)]);
var state_49296__$1 = state_49296;
var statearr_49300_49438 = state_49296__$1;
(statearr_49300_49438[(2)] = inst_49264);

(statearr_49300_49438[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49297 === (6))){
var inst_49279 = (state_49296[(7)]);
var inst_49278 = (state_49296[(2)]);
var inst_49279__$1 = fluree.db.util.async.throw_err(inst_49278);
var inst_49280 = (inst_49279__$1 == null);
var state_49296__$1 = (function (){var statearr_49301 = state_49296;
(statearr_49301[(7)] = inst_49279__$1);

return statearr_49301;
})();
if(cljs.core.truth_(inst_49280)){
var statearr_49302_49439 = state_49296__$1;
(statearr_49302_49439[(1)] = (7));

} else {
var statearr_49303_49440 = state_49296__$1;
(statearr_49303_49440[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49297 === (3))){
var inst_49294 = (state_49296[(2)]);
var state_49296__$1 = state_49296;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49296__$1,inst_49294);
} else {
if((state_val_49297 === (12))){
var inst_49291 = (state_49296[(2)]);
var _ = (function (){var statearr_49304 = state_49296;
(statearr_49304[(4)] = cljs.core.rest((state_49296[(4)])));

return statearr_49304;
})();
var state_49296__$1 = state_49296;
var statearr_49305_49441 = state_49296__$1;
(statearr_49305_49441[(2)] = inst_49291);

(statearr_49305_49441[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49297 === (2))){
var _ = (function (){var statearr_49306 = state_49296;
(statearr_49306[(4)] = cljs.core.cons((5),(state_49296[(4)])));

return statearr_49306;
})();
var inst_49270 = (30);
var inst_49272 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_49273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_49274 = [inst_49270,tag_name];
var inst_49275 = (new cljs.core.PersistentVector(null,2,(5),inst_49273,inst_49274,null));
var inst_49276 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_49272,cljs.core.cst$kw$post,cljs.core._EQ_,inst_49275);
var state_49296__$1 = state_49296;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49296__$1,(6),inst_49276);
} else {
if((state_val_49297 === (11))){
var inst_49285 = (state_49296[(8)]);
var inst_49289 = inst_49285.s;
var state_49296__$1 = state_49296;
var statearr_49308_49442 = state_49296__$1;
(statearr_49308_49442[(2)] = inst_49289);

(statearr_49308_49442[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49297 === (9))){
var inst_49285 = (state_49296[(8)]);
var inst_49285__$1 = (state_49296[(2)]);
var inst_49286 = (inst_49285__$1 == null);
var state_49296__$1 = (function (){var statearr_49309 = state_49296;
(statearr_49309[(8)] = inst_49285__$1);

return statearr_49309;
})();
if(cljs.core.truth_(inst_49286)){
var statearr_49310_49443 = state_49296__$1;
(statearr_49310_49443[(1)] = (10));

} else {
var statearr_49311_49444 = state_49296__$1;
(statearr_49311_49444[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49297 === (5))){
var _ = (function (){var statearr_49312 = state_49296;
(statearr_49312[(4)] = cljs.core.rest((state_49296[(4)])));

return statearr_49312;
})();
var state_49296__$1 = state_49296;
var ex49307 = (state_49296__$1[(2)]);
var statearr_49313_49445 = state_49296__$1;
(statearr_49313_49445[(5)] = ex49307);


if((ex49307 instanceof Error)){
var statearr_49314_49446 = state_49296__$1;
(statearr_49314_49446[(1)] = (4));

(statearr_49314_49446[(5)] = null);

} else {
throw ex49307;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49297 === (10))){
var state_49296__$1 = state_49296;
var statearr_49315_49447 = state_49296__$1;
(statearr_49315_49447[(2)] = null);

(statearr_49315_49447[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49297 === (8))){
var inst_49279 = (state_49296[(7)]);
var inst_49283 = cljs.core.first(inst_49279);
var state_49296__$1 = state_49296;
var statearr_49316_49448 = state_49296__$1;
(statearr_49316_49448[(2)] = inst_49283);

(statearr_49316_49448[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__20477__auto__ = null;
var fluree$db$graphdb$state_machine__20477__auto____0 = (function (){
var statearr_49317 = [null,null,null,null,null,null,null,null,null];
(statearr_49317[(0)] = fluree$db$graphdb$state_machine__20477__auto__);

(statearr_49317[(1)] = (1));

return statearr_49317;
});
var fluree$db$graphdb$state_machine__20477__auto____1 = (function (state_49296){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_49296);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e49318){var ex__20480__auto__ = e49318;
var statearr_49319_49449 = state_49296;
(statearr_49319_49449[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_49296[(4)]))){
var statearr_49320_49450 = state_49296;
(statearr_49320_49450[(1)] = cljs.core.first((state_49296[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__49451 = state_49296;
state_49296 = G__49451;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__20477__auto__ = function(state_49296){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__20477__auto____1.call(this,state_49296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__20477__auto____0;
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__20477__auto____1;
return fluree$db$graphdb$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_49321 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_49321[(6)] = c__20603__auto__);

return statearr_49321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_49356){
var state_val_49357 = (state_49356[(1)]);
if((state_val_49357 === (7))){
var inst_49335 = typeof pred === 'string';
var state_49356__$1 = state_49356;
if(cljs.core.truth_(inst_49335)){
var statearr_49358_49452 = state_49356__$1;
(statearr_49358_49452[(1)] = (10));

} else {
var statearr_49359_49453 = state_49356__$1;
(statearr_49359_49453[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49357 === (1))){
var state_49356__$1 = state_49356;
var statearr_49360_49454 = state_49356__$1;
(statearr_49360_49454[(2)] = null);

(statearr_49360_49454[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49357 === (4))){
var inst_49322 = (state_49356[(2)]);
var state_49356__$1 = state_49356;
var statearr_49361_49455 = state_49356__$1;
(statearr_49361_49455[(2)] = inst_49322);

(statearr_49361_49455[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49357 === (15))){
var inst_49349 = (state_49356[(2)]);
var state_49356__$1 = state_49356;
var statearr_49362_49456 = state_49356__$1;
(statearr_49362_49456[(2)] = inst_49349);

(statearr_49362_49456[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49357 === (13))){
var inst_49340 = (state_49356[(7)]);
var inst_49342 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_49340),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_49343 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_49342);
var state_49356__$1 = state_49356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49356__$1,(16),inst_49343);
} else {
if((state_val_49357 === (6))){
var inst_49330 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_49356__$1 = state_49356;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_49356__$1,(9),inst_49330);
} else {
if((state_val_49357 === (3))){
var inst_49354 = (state_49356[(2)]);
var state_49356__$1 = state_49356;
return cljs.core.async.impl.ioc_helpers.return_chan(state_49356__$1,inst_49354);
} else {
if((state_val_49357 === (12))){
var inst_49340 = (state_49356[(7)]);
var inst_49340__$1 = (state_49356[(2)]);
var state_49356__$1 = (function (){var statearr_49363 = state_49356;
(statearr_49363[(7)] = inst_49340__$1);

return statearr_49363;
})();
if(cljs.core.truth_(inst_49340__$1)){
var statearr_49364_49457 = state_49356__$1;
(statearr_49364_49457[(1)] = (13));

} else {
var statearr_49365_49458 = state_49356__$1;
(statearr_49365_49458[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49357 === (2))){
var _ = (function (){var statearr_49366 = state_49356;
(statearr_49366[(4)] = cljs.core.cons((5),(state_49356[(4)])));

return statearr_49366;
})();
var inst_49328 = clojure.string.includes_QMARK_(tag_name,"/");
var state_49356__$1 = state_49356;
if(inst_49328){
var statearr_49367_49459 = state_49356__$1;
(statearr_49367_49459[(1)] = (6));

} else {
var statearr_49368_49460 = state_49356__$1;
(statearr_49368_49460[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49357 === (11))){
var inst_49338 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_49356__$1 = state_49356;
var statearr_49370_49461 = state_49356__$1;
(statearr_49370_49461[(2)] = inst_49338);

(statearr_49370_49461[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49357 === (9))){
var inst_49332 = (state_49356[(2)]);
var inst_49333 = fluree.db.util.async.throw_err(inst_49332);
var state_49356__$1 = state_49356;
var statearr_49371_49462 = state_49356__$1;
(statearr_49371_49462[(2)] = inst_49333);

(statearr_49371_49462[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49357 === (5))){
var _ = (function (){var statearr_49372 = state_49356;
(statearr_49372[(4)] = cljs.core.rest((state_49356[(4)])));

return statearr_49372;
})();
var state_49356__$1 = state_49356;
var ex49369 = (state_49356__$1[(2)]);
var statearr_49373_49463 = state_49356__$1;
(statearr_49373_49463[(5)] = ex49369);


if((ex49369 instanceof Error)){
var statearr_49374_49464 = state_49356__$1;
(statearr_49374_49464[(1)] = (4));

(statearr_49374_49464[(5)] = null);

} else {
throw ex49369;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_49357 === (14))){
var state_49356__$1 = state_49356;
var statearr_49375_49465 = state_49356__$1;
(statearr_49375_49465[(2)] = null);

(statearr_49375_49465[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49357 === (16))){
var inst_49345 = (state_49356[(2)]);
var inst_49346 = fluree.db.util.async.throw_err(inst_49345);
var state_49356__$1 = state_49356;
var statearr_49376_49466 = state_49356__$1;
(statearr_49376_49466[(2)] = inst_49346);

(statearr_49376_49466[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49357 === (10))){
var state_49356__$1 = state_49356;
var statearr_49377_49467 = state_49356__$1;
(statearr_49377_49467[(2)] = pred);

(statearr_49377_49467[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_49357 === (8))){
var inst_49351 = (state_49356[(2)]);
var _ = (function (){var statearr_49378 = state_49356;
(statearr_49378[(4)] = cljs.core.rest((state_49356[(4)])));

return statearr_49378;
})();
var state_49356__$1 = state_49356;
var statearr_49379_49468 = state_49356__$1;
(statearr_49379_49468[(2)] = inst_49351);

(statearr_49379_49468[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__20477__auto__ = null;
var fluree$db$graphdb$state_machine__20477__auto____0 = (function (){
var statearr_49380 = [null,null,null,null,null,null,null,null];
(statearr_49380[(0)] = fluree$db$graphdb$state_machine__20477__auto__);

(statearr_49380[(1)] = (1));

return statearr_49380;
});
var fluree$db$graphdb$state_machine__20477__auto____1 = (function (state_49356){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_49356);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e49381){var ex__20480__auto__ = e49381;
var statearr_49382_49469 = state_49356;
(statearr_49382_49469[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_49356[(4)]))){
var statearr_49383_49470 = state_49356;
(statearr_49383_49470[(1)] = cljs.core.first((state_49356[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__49471 = state_49356;
state_49356 = G__49471;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__20477__auto__ = function(state_49356){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__20477__auto____1.call(this,state_49356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__20477__auto____0;
fluree$db$graphdb$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__20477__auto____1;
return fluree$db$graphdb$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_49384 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_49384[(6)] = c__20603__auto__);

return statearr_49384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__49053){
var extmap__4512__auto__ = (function (){var G__49385 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49053,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__49053)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49385);
} else {
return G__49385;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__49053),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__49053),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
