// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56004 = arguments.length;
var i__4830__auto___56005 = (0);
while(true){
if((i__4830__auto___56005 < len__4829__auto___56004)){
args__4835__auto__.push((arguments[i__4830__auto___56005]));

var G__56006 = (i__4830__auto___56005 + (1));
i__4830__auto___56005 = G__56006;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq56001){
var G__56002 = cljs.core.first(seq56001);
var seq56001__$1 = cljs.core.next(seq56001);
var G__56003 = cljs.core.first(seq56001__$1);
var seq56001__$2 = cljs.core.next(seq56001__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56002,G__56003,seq56001__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e56007){var e = e56007;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e56008){var e = e56008;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e56009){var e = e56009;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e56010){var e = e56010;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e56011){var e = e56011;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56014 = arguments.length;
var i__4830__auto___56015 = (0);
while(true){
if((i__4830__auto___56015 < len__4829__auto___56014)){
args__4835__auto__.push((arguments[i__4830__auto___56015]));

var G__56016 = (i__4830__auto___56015 + (1));
i__4830__auto___56015 = G__56016;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e56013){var e = e56013;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq56012){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56012));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56019 = arguments.length;
var i__4830__auto___56020 = (0);
while(true){
if((i__4830__auto___56020 < len__4829__auto___56019)){
args__4835__auto__.push((arguments[i__4830__auto___56020]));

var G__56021 = (i__4830__auto___56020 + (1));
i__4830__auto___56020 = G__56021;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e56018){var e = e56018;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq56017){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56017));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e56022){var e = e56022;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56025 = arguments.length;
var i__4830__auto___56026 = (0);
while(true){
if((i__4830__auto___56026 < len__4829__auto___56025)){
args__4835__auto__.push((arguments[i__4830__auto___56026]));

var G__56027 = (i__4830__auto___56026 + (1));
i__4830__auto___56026 = G__56027;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e56024){var e = e56024;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq56023){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56023));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56030 = arguments.length;
var i__4830__auto___56031 = (0);
while(true){
if((i__4830__auto___56031 < len__4829__auto___56030)){
args__4835__auto__.push((arguments[i__4830__auto___56031]));

var G__56032 = (i__4830__auto___56031 + (1));
i__4830__auto___56031 = G__56032;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e56029){var e = e56029;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq56028){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56028));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e56033){var e = e56033;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e56034){var e = e56034;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56037 = arguments.length;
var i__4830__auto___56038 = (0);
while(true){
if((i__4830__auto___56038 < len__4829__auto___56037)){
args__4835__auto__.push((arguments[i__4830__auto___56038]));

var G__56039 = (i__4830__auto___56038 + (1));
i__4830__auto___56038 = G__56039;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e56036){var e = e56036;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq56035){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56035));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56042 = arguments.length;
var i__4830__auto___56043 = (0);
while(true){
if((i__4830__auto___56043 < len__4829__auto___56042)){
args__4835__auto__.push((arguments[i__4830__auto___56043]));

var G__56044 = (i__4830__auto___56043 + (1));
i__4830__auto___56043 = G__56044;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e56041){var e = e56041;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq56040){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56040));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56047 = arguments.length;
var i__4830__auto___56048 = (0);
while(true){
if((i__4830__auto___56048 < len__4829__auto___56047)){
args__4835__auto__.push((arguments[i__4830__auto___56048]));

var G__56049 = (i__4830__auto___56048 + (1));
i__4830__auto___56048 = G__56049;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e56046){var e = e56046;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq56045){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56045));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56052 = arguments.length;
var i__4830__auto___56053 = (0);
while(true){
if((i__4830__auto___56053 < len__4829__auto___56052)){
args__4835__auto__.push((arguments[i__4830__auto___56053]));

var G__56054 = (i__4830__auto___56053 + (1));
i__4830__auto___56053 = G__56054;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e56051){var e = e56051;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq56050){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56050));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56057 = arguments.length;
var i__4830__auto___56058 = (0);
while(true){
if((i__4830__auto___56058 < len__4829__auto___56057)){
args__4835__auto__.push((arguments[i__4830__auto___56058]));

var G__56059 = (i__4830__auto___56058 + (1));
i__4830__auto___56058 = G__56059;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e56056){var e = e56056;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq56055){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56055));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56062 = arguments.length;
var i__4830__auto___56063 = (0);
while(true){
if((i__4830__auto___56063 < len__4829__auto___56062)){
args__4835__auto__.push((arguments[i__4830__auto___56063]));

var G__56064 = (i__4830__auto___56063 + (1));
i__4830__auto___56063 = G__56064;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e56061){var e = e56061;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq56060){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56060));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56067 = arguments.length;
var i__4830__auto___56068 = (0);
while(true){
if((i__4830__auto___56068 < len__4829__auto___56067)){
args__4835__auto__.push((arguments[i__4830__auto___56068]));

var G__56069 = (i__4830__auto___56068 + (1));
i__4830__auto___56068 = G__56069;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e56066){var e = e56066;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq56065){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56065));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__56071 = arguments.length;
switch (G__56071) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_56099){
var state_val_56100 = (state_56099[(1)]);
if((state_val_56100 === (7))){
var inst_56084 = (state_56099[(7)]);
var inst_56087 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_56084,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_56099__$1 = state_56099;
var statearr_56101_56187 = state_56099__$1;
(statearr_56101_56187[(2)] = inst_56087);

(statearr_56101_56187[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56100 === (1))){
var state_56099__$1 = state_56099;
var statearr_56102_56188 = state_56099__$1;
(statearr_56102_56188[(2)] = null);

(statearr_56102_56188[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56100 === (4))){
var inst_56072 = (state_56099[(2)]);
var state_56099__$1 = state_56099;
var statearr_56103_56189 = state_56099__$1;
(statearr_56103_56189[(2)] = inst_56072);

(statearr_56103_56189[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56100 === (6))){
var inst_56084 = (state_56099[(7)]);
var inst_56084__$1 = (state_56099[(2)]);
var inst_56085 = fluree.db.util.core.exception_QMARK_(inst_56084__$1);
var state_56099__$1 = (function (){var statearr_56104 = state_56099;
(statearr_56104[(7)] = inst_56084__$1);

return statearr_56104;
})();
if(inst_56085){
var statearr_56105_56190 = state_56099__$1;
(statearr_56105_56190[(1)] = (7));

} else {
var statearr_56106_56191 = state_56099__$1;
(statearr_56106_56191[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56100 === (3))){
var inst_56097 = (state_56099[(2)]);
var state_56099__$1 = state_56099;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56099__$1,inst_56097);
} else {
if((state_val_56100 === (2))){
var inst_56078 = (state_56099[(8)]);
var _ = (function (){var statearr_56108 = state_56099;
(statearr_56108[(4)] = cljs.core.cons((5),(state_56099[(4)])));

return statearr_56108;
})();
var inst_56078__$1 = cljs.core.volatile_BANG_((0));
var inst_56079 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_56080 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_56079,cljs.core.cst$kw$fuel,inst_56078__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_56081 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_56080);
var inst_56082 = fluree.db.query.fql.query(db,inst_56081);
var state_56099__$1 = (function (){var statearr_56109 = state_56099;
(statearr_56109[(8)] = inst_56078__$1);

return statearr_56109;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56099__$1,(6),inst_56082);
} else {
if((state_val_56100 === (9))){
var inst_56094 = (state_56099[(2)]);
var _ = (function (){var statearr_56110 = state_56099;
(statearr_56110[(4)] = cljs.core.rest((state_56099[(4)])));

return statearr_56110;
})();
var state_56099__$1 = state_56099;
var statearr_56111_56192 = state_56099__$1;
(statearr_56111_56192[(2)] = inst_56094);

(statearr_56111_56192[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56100 === (5))){
var _ = (function (){var statearr_56112 = state_56099;
(statearr_56112[(4)] = cljs.core.rest((state_56099[(4)])));

return statearr_56112;
})();
var state_56099__$1 = state_56099;
var ex56107 = (state_56099__$1[(2)]);
var statearr_56113_56193 = state_56099__$1;
(statearr_56113_56193[(5)] = ex56107);


if((ex56107 instanceof Error)){
var statearr_56114_56194 = state_56099__$1;
(statearr_56114_56194[(1)] = (4));

(statearr_56114_56194[(5)] = null);

} else {
throw ex56107;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56100 === (8))){
var inst_56084 = (state_56099[(7)]);
var inst_56078 = (state_56099[(8)]);
var inst_56089 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56090 = cljs.core.deref(inst_56078);
var inst_56091 = [inst_56084,inst_56090];
var inst_56092 = (new cljs.core.PersistentVector(null,2,(5),inst_56089,inst_56091,null));
var state_56099__$1 = state_56099;
var statearr_56115_56195 = state_56099__$1;
(statearr_56115_56195[(2)] = inst_56092);

(statearr_56115_56195[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__20477__auto____0 = (function (){
var statearr_56116 = [null,null,null,null,null,null,null,null,null];
(statearr_56116[(0)] = fluree$db$dbfunctions$internal$state_machine__20477__auto__);

(statearr_56116[(1)] = (1));

return statearr_56116;
});
var fluree$db$dbfunctions$internal$state_machine__20477__auto____1 = (function (state_56099){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_56099);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e56117){var ex__20480__auto__ = e56117;
var statearr_56118_56196 = state_56099;
(statearr_56118_56196[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_56099[(4)]))){
var statearr_56119_56197 = state_56099;
(statearr_56119_56197[(1)] = cljs.core.first((state_56099[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__56198 = state_56099;
state_56099 = G__56198;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__20477__auto__ = function(state_56099){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__20477__auto____1.call(this,state_56099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__20477__auto____0;
fluree$db$dbfunctions$internal$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__20477__auto____1;
return fluree$db$dbfunctions$internal$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_56120 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_56120[(6)] = c__20603__auto__);

return statearr_56120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_56165){
var state_val_56166 = (state_56165[(1)]);
if((state_val_56166 === (7))){
var inst_56151 = (state_56165[(2)]);
var inst_56152 = fluree.db.query.fql.query(db,inst_56151);
var state_56165__$1 = state_56165;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56165__$1,(8),inst_56152);
} else {
if((state_val_56166 === (1))){
var inst_56121 = typeof select === 'string';
var state_56165__$1 = state_56165;
if(cljs.core.truth_(inst_56121)){
var statearr_56167_56199 = state_56165__$1;
(statearr_56167_56199[(1)] = (2));

} else {
var statearr_56168_56200 = state_56165__$1;
(statearr_56168_56200[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56166 === (4))){
var inst_56134 = (state_56165[(7)]);
var inst_56127 = (state_56165[(8)]);
var inst_56126 = (state_56165[(2)]);
var inst_56127__$1 = cljs.core.volatile_BANG_((0));
var inst_56128 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_56129 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_56130 = [inst_56127__$1,(100000)];
var inst_56131 = cljs.core.PersistentHashMap.fromArrays(inst_56129,inst_56130);
var inst_56132 = [inst_56126,from,where,block,limit,inst_56131];
var inst_56133 = cljs.core.PersistentHashMap.fromArrays(inst_56128,inst_56132);
var inst_56134__$1 = fluree.db.util.core.without_nils(inst_56133);
var inst_56135 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_56134__$1);
var inst_56136 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_56134__$1);
var inst_56137 = cljs.core.first(inst_56136);
var inst_56138 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_56137], 0));
var inst_56139 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_56138);
var inst_56140 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_56134__$1);
var inst_56141 = cljs.core.last(inst_56140);
var inst_56142 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_56141], 0));
var inst_56143 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_56142);
var inst_56144 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_56135,inst_56139,inst_56143], 0));
var state_56165__$1 = (function (){var statearr_56169 = state_56165;
(statearr_56169[(7)] = inst_56134__$1);

(statearr_56169[(8)] = inst_56127__$1);

return statearr_56169;
})();
if(cljs.core.truth_(inst_56144)){
var statearr_56170_56201 = state_56165__$1;
(statearr_56170_56201[(1)] = (5));

} else {
var statearr_56171_56202 = state_56165__$1;
(statearr_56171_56202[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56166 === (6))){
var inst_56134 = (state_56165[(7)]);
var state_56165__$1 = state_56165;
var statearr_56172_56203 = state_56165__$1;
(statearr_56172_56203[(2)] = inst_56134);

(statearr_56172_56203[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56166 === (3))){
var state_56165__$1 = state_56165;
var statearr_56173_56204 = state_56165__$1;
(statearr_56173_56204[(2)] = select);

(statearr_56173_56204[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56166 === (2))){
var inst_56123 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_56165__$1 = state_56165;
var statearr_56174_56205 = state_56165__$1;
(statearr_56174_56205[(2)] = inst_56123);

(statearr_56174_56205[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56166 === (11))){
var inst_56163 = (state_56165[(2)]);
var state_56165__$1 = state_56165;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56165__$1,inst_56163);
} else {
if((state_val_56166 === (9))){
var inst_56154 = (state_56165[(9)]);
var state_56165__$1 = state_56165;
var statearr_56175_56206 = state_56165__$1;
(statearr_56175_56206[(2)] = inst_56154);

(statearr_56175_56206[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56166 === (5))){
var inst_56134 = (state_56165[(7)]);
var inst_56146 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_56134);
var inst_56147 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_56146);
var inst_56148 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_56134,cljs.core.cst$kw$where,inst_56147);
var state_56165__$1 = state_56165;
var statearr_56176_56207 = state_56165__$1;
(statearr_56176_56207[(2)] = inst_56148);

(statearr_56176_56207[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56166 === (10))){
var inst_56154 = (state_56165[(9)]);
var inst_56127 = (state_56165[(8)]);
var inst_56158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56159 = cljs.core.deref(inst_56127);
var inst_56160 = [inst_56154,inst_56159];
var inst_56161 = (new cljs.core.PersistentVector(null,2,(5),inst_56158,inst_56160,null));
var state_56165__$1 = state_56165;
var statearr_56177_56208 = state_56165__$1;
(statearr_56177_56208[(2)] = inst_56161);

(statearr_56177_56208[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56166 === (8))){
var inst_56154 = (state_56165[(9)]);
var inst_56154__$1 = (state_56165[(2)]);
var inst_56155 = fluree.db.util.core.exception_QMARK_(inst_56154__$1);
var state_56165__$1 = (function (){var statearr_56178 = state_56165;
(statearr_56178[(9)] = inst_56154__$1);

return statearr_56178;
})();
if(inst_56155){
var statearr_56179_56209 = state_56165__$1;
(statearr_56179_56209[(1)] = (9));

} else {
var statearr_56180_56210 = state_56165__$1;
(statearr_56180_56210[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__20477__auto____0 = (function (){
var statearr_56181 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56181[(0)] = fluree$db$dbfunctions$internal$state_machine__20477__auto__);

(statearr_56181[(1)] = (1));

return statearr_56181;
});
var fluree$db$dbfunctions$internal$state_machine__20477__auto____1 = (function (state_56165){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_56165);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e56182){var ex__20480__auto__ = e56182;
var statearr_56183_56211 = state_56165;
(statearr_56183_56211[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_56165[(4)]))){
var statearr_56184_56212 = state_56165;
(statearr_56184_56212[(1)] = cljs.core.first((state_56165[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__56213 = state_56165;
state_56165 = G__56213;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__20477__auto__ = function(state_56165){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__20477__auto____1.call(this,state_56165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__20477__auto____0;
fluree$db$dbfunctions$internal$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__20477__auto____1;
return fluree$db$dbfunctions$internal$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_56185 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_56185[(6)] = c__20603__auto__);

return statearr_56185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__56217 = path;
var vec__56218 = G__56217;
var seq__56219 = cljs.core.seq(vec__56218);
var first__56220 = cljs.core.first(seq__56219);
var seq__56219__$1 = cljs.core.next(seq__56219);
var var$ = first__56220;
var r = seq__56219__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__56217__$1 = G__56217;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__56224 = G__56217__$1;
var seq__56225 = cljs.core.seq(vec__56224);
var first__56226 = cljs.core.first(seq__56225);
var seq__56225__$1 = cljs.core.next(seq__56225);
var var$__$1 = first__56226;
var r__$1 = seq__56225__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__56227 = r__$1;
var G__56228 = n__$2;
var G__56229 = next_clauses;
G__56217__$1 = G__56227;
n__$1 = G__56228;
where_clauses__$1 = G__56229;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__56230 = r__$1;
var G__56231 = next_n;
var G__56232 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__56217__$1 = G__56230;
n__$1 = G__56231;
where_clauses__$1 = G__56232;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_56269){
var state_val_56270 = (state_56269[(1)]);
if((state_val_56270 === (7))){
var inst_56242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56243 = [path];
var inst_56244 = (new cljs.core.PersistentVector(null,1,(5),inst_56242,inst_56243,null));
var state_56269__$1 = state_56269;
var statearr_56271_56299 = state_56269__$1;
(statearr_56271_56299[(2)] = inst_56244);

(statearr_56271_56299[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56270 === (1))){
var state_56269__$1 = state_56269;
var statearr_56272_56300 = state_56269__$1;
(statearr_56272_56300[(2)] = null);

(statearr_56272_56300[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56270 === (4))){
var inst_56233 = (state_56269[(2)]);
var state_56269__$1 = state_56269;
var statearr_56273_56301 = state_56269__$1;
(statearr_56273_56301[(2)] = inst_56233);

(statearr_56273_56301[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56270 === (13))){
var inst_56260 = (state_56269[(2)]);
var inst_56261 = fluree.db.util.async.throw_err(inst_56260);
var _ = (function (){var statearr_56274 = state_56269;
(statearr_56274[(4)] = cljs.core.rest((state_56269[(4)])));

return statearr_56274;
})();
var state_56269__$1 = state_56269;
var statearr_56275_56302 = state_56269__$1;
(statearr_56275_56302[(2)] = inst_56261);

(statearr_56275_56302[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56270 === (6))){
var state_56269__$1 = state_56269;
var statearr_56277_56303 = state_56269__$1;
(statearr_56277_56303[(2)] = path);

(statearr_56277_56303[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56270 === (3))){
var inst_56267 = (state_56269[(2)]);
var state_56269__$1 = state_56269;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56269__$1,inst_56267);
} else {
if((state_val_56270 === (12))){
var _ = (function (){var statearr_56278 = state_56269;
(statearr_56278[(4)] = cljs.core.rest((state_56269[(4)])));

return statearr_56278;
})();
var state_56269__$1 = state_56269;
var ex56276 = (state_56269__$1[(2)]);
var statearr_56279_56304 = state_56269__$1;
(statearr_56279_56304[(5)] = ex56276);


var statearr_56280_56305 = state_56269__$1;
(statearr_56280_56305[(1)] = (11));

(statearr_56280_56305[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_56270 === (2))){
var _ = (function (){var statearr_56281 = state_56269;
(statearr_56281[(4)] = cljs.core.cons((5),(state_56269[(4)])));

return statearr_56281;
})();
var inst_56239 = cljs.core.vector_QMARK_(path);
var state_56269__$1 = state_56269;
if(inst_56239){
var statearr_56282_56306 = state_56269__$1;
(statearr_56282_56306[(1)] = (6));

} else {
var statearr_56283_56307 = state_56269__$1;
(statearr_56283_56307[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56270 === (11))){
var inst_56246 = (state_56269[(7)]);
var inst_56251 = (state_56269[(2)]);
var inst_56252 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_56251,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_56246,endSubject], 0));
var state_56269__$1 = state_56269;
var statearr_56285_56308 = state_56269__$1;
(statearr_56285_56308[(2)] = inst_56252);

(statearr_56285_56308[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56270 === (9))){
var inst_56250 = (state_56269[(8)]);
var _ = (function (){var statearr_56286 = state_56269;
(statearr_56286[(4)] = cljs.core.cons((12),(state_56269[(4)])));

return statearr_56286;
})();
var inst_56258 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_56250);
var state_56269__$1 = state_56269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56269__$1,(13),inst_56258);
} else {
if((state_val_56270 === (5))){
var _ = (function (){var statearr_56287 = state_56269;
(statearr_56287[(4)] = cljs.core.rest((state_56269[(4)])));

return statearr_56287;
})();
var state_56269__$1 = state_56269;
var ex56284 = (state_56269__$1[(2)]);
var statearr_56288_56309 = state_56269__$1;
(statearr_56288_56309[(5)] = ex56284);


if((ex56284 instanceof Error)){
var statearr_56289_56310 = state_56269__$1;
(statearr_56289_56310[(1)] = (4));

(statearr_56289_56310[(5)] = null);

} else {
throw ex56284;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56270 === (10))){
var inst_56264 = (state_56269[(2)]);
var _ = (function (){var statearr_56290 = state_56269;
(statearr_56290[(4)] = cljs.core.rest((state_56269[(4)])));

return statearr_56290;
})();
var state_56269__$1 = state_56269;
var statearr_56291_56311 = state_56269__$1;
(statearr_56291_56311[(2)] = inst_56264);

(statearr_56291_56311[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56270 === (8))){
var inst_56246 = (state_56269[(7)]);
var inst_56246__$1 = (state_56269[(2)]);
var inst_56247 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_56246__$1,endSubject);
var inst_56248 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_56249 = ["?var1",inst_56247];
var inst_56250 = cljs.core.PersistentHashMap.fromArrays(inst_56248,inst_56249);
var state_56269__$1 = (function (){var statearr_56292 = state_56269;
(statearr_56292[(8)] = inst_56250);

(statearr_56292[(7)] = inst_56246__$1);

return statearr_56292;
})();
var statearr_56293_56312 = state_56269__$1;
(statearr_56293_56312[(2)] = null);

(statearr_56293_56312[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__20477__auto____0 = (function (){
var statearr_56294 = [null,null,null,null,null,null,null,null,null];
(statearr_56294[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__20477__auto__);

(statearr_56294[(1)] = (1));

return statearr_56294;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__20477__auto____1 = (function (state_56269){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_56269);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e56295){var ex__20480__auto__ = e56295;
var statearr_56296_56313 = state_56269;
(statearr_56296_56313[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_56269[(4)]))){
var statearr_56297_56314 = state_56269;
(statearr_56297_56314[(1)] = cljs.core.first((state_56269[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__56315 = state_56269;
state_56269 = G__56315;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__20477__auto__ = function(state_56269){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__20477__auto____1.call(this,state_56269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__20477__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_56298 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_56298[(6)] = c__20603__auto__);

return statearr_56298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e56316){var e = e56316;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e56317){var e = e56317;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e56318){var e = e56318;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e56319){var e = e56319;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56322 = arguments.length;
var i__4830__auto___56323 = (0);
while(true){
if((i__4830__auto___56323 < len__4829__auto___56322)){
args__4835__auto__.push((arguments[i__4830__auto___56323]));

var G__56324 = (i__4830__auto___56323 + (1));
i__4830__auto___56323 = G__56324;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e56321){var e = e56321;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq56320){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56320));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56327 = arguments.length;
var i__4830__auto___56328 = (0);
while(true){
if((i__4830__auto___56328 < len__4829__auto___56327)){
args__4835__auto__.push((arguments[i__4830__auto___56328]));

var G__56329 = (i__4830__auto___56328 + (1));
i__4830__auto___56328 = G__56329;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e56326){var e = e56326;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq56325){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56325));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56332 = arguments.length;
var i__4830__auto___56333 = (0);
while(true){
if((i__4830__auto___56333 < len__4829__auto___56332)){
args__4835__auto__.push((arguments[i__4830__auto___56333]));

var G__56334 = (i__4830__auto___56333 + (1));
i__4830__auto___56333 = G__56334;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4223__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e56331){var e = e56331;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq56330){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56330));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56337 = arguments.length;
var i__4830__auto___56338 = (0);
while(true){
if((i__4830__auto___56338 < len__4829__auto___56337)){
args__4835__auto__.push((arguments[i__4830__auto___56338]));

var G__56339 = (i__4830__auto___56338 + (1));
i__4830__auto___56338 = G__56339;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e56336){var e = e56336;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq56335){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56335));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e56340){var e = e56340;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e56341){var e = e56341;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e56342){var e = e56342;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e56343){var e = e56343;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e56344){var e = e56344;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__56350 = path;
var vec__56351 = G__56350;
var seq__56352 = cljs.core.seq(vec__56351);
var first__56353 = cljs.core.first(seq__56352);
var seq__56352__$1 = cljs.core.next(seq__56352);
var pred = first__56353;
var r = seq__56352__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__56350__$1 = G__56350;
var subjects__$1 = subjects;
while(true){
var vec__56357 = G__56350__$1;
var seq__56358 = cljs.core.seq(vec__56357);
var first__56359 = cljs.core.first(seq__56358);
var seq__56358__$1 = cljs.core.next(seq__56358);
var pred__$1 = first__56359;
var r__$1 = seq__56358__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__56350__$1,subjects__$1,vec__56357,seq__56358,first__56359,seq__56358__$1,pred__$1,r__$1,subjects__$2,G__56350,vec__56351,seq__56352,first__56353,seq__56352__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__56350__$1,subjects__$1,vec__56357,seq__56358,first__56359,seq__56358__$1,pred__$1,r__$1,subjects__$2,G__56350,vec__56351,seq__56352,first__56353,seq__56352__$1,pred,r,subjects){
return (function (p1__56345_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__56345_SHARP_,pred__$1);
});})(G__56350__$1,subjects__$1,vec__56357,seq__56358,first__56359,seq__56358__$1,pred__$1,r__$1,subjects__$2,G__56350,vec__56351,seq__56352,first__56353,seq__56352__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__56350__$1,subjects__$1,vec__56357,seq__56358,first__56359,seq__56358__$1,pred__$1,r__$1,subjects__$2,G__56350,vec__56351,seq__56352,first__56353,seq__56352__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4221__auto__ = r__$1;
if(and__4221__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4221__auto__;
}
})())){
var G__56360 = r__$1;
var G__56361 = next_subjects;
G__56350__$1 = G__56360;
subjects__$1 = G__56361;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e56346){var e = e56346;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e56362){var e = e56362;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e56363){var e = e56363;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56366 = arguments.length;
var i__4830__auto___56367 = (0);
while(true){
if((i__4830__auto___56367 < len__4829__auto___56366)){
args__4835__auto__.push((arguments[i__4830__auto___56367]));

var G__56368 = (i__4830__auto___56367 + (1));
i__4830__auto___56367 = G__56368;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e56365){var e = e56365;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq56364){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56364));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e56369){var e = e56369;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___56372 = arguments.length;
var i__4830__auto___56373 = (0);
while(true){
if((i__4830__auto___56373 < len__4829__auto___56372)){
args__4835__auto__.push((arguments[i__4830__auto___56373]));

var G__56374 = (i__4830__auto___56373 + (1));
i__4830__auto___56373 = G__56374;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e56371){var e = e56371;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq56370){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq56370));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e56375){var e = e56375;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_56430){
var state_val_56431 = (state_56430[(1)]);
if((state_val_56431 === (7))){
var inst_56377 = (state_56430[(2)]);
var state_56430__$1 = state_56430;
var statearr_56432_56465 = state_56430__$1;
(statearr_56432_56465[(2)] = inst_56377);

(statearr_56432_56465[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (1))){
var state_56430__$1 = state_56430;
var statearr_56433_56466 = state_56430__$1;
(statearr_56433_56466[(2)] = null);

(statearr_56433_56466[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (4))){
var inst_56376 = (state_56430[(2)]);
var state_56430__$1 = (function (){var statearr_56434 = state_56430;
(statearr_56434[(7)] = inst_56376);

return statearr_56434;
})();
var statearr_56435_56467 = state_56430__$1;
(statearr_56435_56467[(2)] = null);

(statearr_56435_56467[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (15))){
var inst_56414 = (state_56430[(8)]);
var inst_56418 = inst_56414.o;
var state_56430__$1 = state_56430;
var statearr_56436_56468 = state_56430__$1;
(statearr_56436_56468[(2)] = inst_56418);

(statearr_56436_56468[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (13))){
var inst_56414 = (state_56430[(8)]);
var inst_56410 = (state_56430[(2)]);
var inst_56411 = fluree.db.util.async.throw_err(inst_56410);
var inst_56412 = fluree.db.dbfunctions.internal.count(inst_56411);
var inst_56414__$1 = cljs.core.first(inst_56411);
var inst_56415 = (inst_56414__$1 == null);
var state_56430__$1 = (function (){var statearr_56437 = state_56430;
(statearr_56437[(8)] = inst_56414__$1);

(statearr_56437[(9)] = inst_56412);

return statearr_56437;
})();
if(cljs.core.truth_(inst_56415)){
var statearr_56438_56469 = state_56430__$1;
(statearr_56438_56469[(1)] = (14));

} else {
var statearr_56439_56470 = state_56430__$1;
(statearr_56439_56470[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (6))){
var inst_56386 = (state_56430[(2)]);
var state_56430__$1 = state_56430;
var statearr_56440_56471 = state_56430__$1;
(statearr_56440_56471[(2)] = inst_56386);

(statearr_56440_56471[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (3))){
var inst_56428 = (state_56430[(2)]);
var state_56430__$1 = state_56430;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56430__$1,inst_56428);
} else {
if((state_val_56431 === (12))){
var inst_56425 = (state_56430[(2)]);
var _ = (function (){var statearr_56441 = state_56430;
(statearr_56441[(4)] = cljs.core.rest((state_56430[(4)])));

return statearr_56441;
})();
var state_56430__$1 = state_56430;
var statearr_56442_56472 = state_56430__$1;
(statearr_56442_56472[(2)] = inst_56425);

(statearr_56442_56472[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (2))){
var _ = (function (){var statearr_56444 = state_56430;
(statearr_56444[(4)] = cljs.core.cons((9),(state_56430[(4)])));

return statearr_56444;
})();
var inst_56392 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56393 = typeof inst_56392 === 'string';
var state_56430__$1 = state_56430;
if(cljs.core.truth_(inst_56393)){
var statearr_56445_56473 = state_56430__$1;
(statearr_56445_56473[(1)] = (10));

} else {
var statearr_56446_56474 = state_56430__$1;
(statearr_56446_56474[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (11))){
var inst_56399 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56400 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_56399);
var inst_56401 = fluree.db.dbfunctions.internal.inc(inst_56400);
var inst_56402 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_56399,cljs.core.cst$kw$t,inst_56401);
var inst_56403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56404 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56405 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56406 = [inst_56404,inst_56405];
var inst_56407 = (new cljs.core.PersistentVector(null,2,(5),inst_56403,inst_56406,null));
var inst_56408 = fluree.db.dbproto._search(inst_56402,inst_56407);
var state_56430__$1 = state_56430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56430__$1,(13),inst_56408);
} else {
if((state_val_56431 === (9))){
var _ = (function (){var statearr_56447 = state_56430;
(statearr_56447[(4)] = cljs.core.rest((state_56430[(4)])));

return statearr_56447;
})();
var state_56430__$1 = state_56430;
var ex56443 = (state_56430__$1[(2)]);
var statearr_56448_56475 = state_56430__$1;
(statearr_56448_56475[(5)] = ex56443);


var statearr_56449_56476 = state_56430__$1;
(statearr_56449_56476[(1)] = (4));

(statearr_56449_56476[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (5))){
var inst_56376 = (state_56430[(7)]);
var _ = (function (){var statearr_56450 = state_56430;
(statearr_56450[(4)] = cljs.core.cons((8),(state_56430[(4)])));

return statearr_56450;
})();
var inst_56383 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_56376,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_56451 = state_56430;
(statearr_56451[(4)] = cljs.core.rest((state_56430[(4)])));

return statearr_56451;
})();
var state_56430__$1 = state_56430;
var statearr_56452_56477 = state_56430__$1;
(statearr_56452_56477[(2)] = inst_56383);

(statearr_56452_56477[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (14))){
var state_56430__$1 = state_56430;
var statearr_56453_56478 = state_56430__$1;
(statearr_56453_56478[(2)] = null);

(statearr_56453_56478[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (16))){
var inst_56412 = (state_56430[(9)]);
var inst_56420 = (state_56430[(2)]);
var inst_56421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56422 = [inst_56420,inst_56412];
var inst_56423 = (new cljs.core.PersistentVector(null,2,(5),inst_56421,inst_56422,null));
var state_56430__$1 = state_56430;
var statearr_56455_56479 = state_56430__$1;
(statearr_56455_56479[(2)] = inst_56423);

(statearr_56455_56479[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (10))){
var inst_56395 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56396 = [null,(0)];
var inst_56397 = (new cljs.core.PersistentVector(null,2,(5),inst_56395,inst_56396,null));
var state_56430__$1 = state_56430;
var statearr_56456_56480 = state_56430__$1;
(statearr_56456_56480[(2)] = inst_56397);

(statearr_56456_56480[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56431 === (8))){
var _ = (function (){var statearr_56457 = state_56430;
(statearr_56457[(4)] = cljs.core.rest((state_56430[(4)])));

return statearr_56457;
})();
var state_56430__$1 = state_56430;
var ex56454 = (state_56430__$1[(2)]);
var statearr_56458_56481 = state_56430__$1;
(statearr_56458_56481[(5)] = ex56454);


var statearr_56459_56482 = state_56430__$1;
(statearr_56459_56482[(1)] = (7));

(statearr_56459_56482[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__20477__auto____0 = (function (){
var statearr_56460 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56460[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__20477__auto__);

(statearr_56460[(1)] = (1));

return statearr_56460;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__20477__auto____1 = (function (state_56430){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_56430);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e56461){var ex__20480__auto__ = e56461;
var statearr_56462_56483 = state_56430;
(statearr_56462_56483[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_56430[(4)]))){
var statearr_56463_56484 = state_56430;
(statearr_56463_56484[(1)] = cljs.core.first((state_56430[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__56485 = state_56430;
state_56430 = G__56485;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__20477__auto__ = function(state_56430){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__20477__auto____1.call(this,state_56430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_56464 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_56464[(6)] = c__20603__auto__);

return statearr_56464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_56537){
var state_val_56538 = (state_56537[(1)]);
if((state_val_56538 === (7))){
var inst_56487 = (state_56537[(2)]);
var state_56537__$1 = state_56537;
var statearr_56539_56568 = state_56537__$1;
(statearr_56539_56568[(2)] = inst_56487);

(statearr_56539_56568[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56538 === (1))){
var state_56537__$1 = state_56537;
var statearr_56540_56569 = state_56537__$1;
(statearr_56540_56569[(2)] = null);

(statearr_56540_56569[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56538 === (4))){
var inst_56486 = (state_56537[(2)]);
var state_56537__$1 = (function (){var statearr_56541 = state_56537;
(statearr_56541[(7)] = inst_56486);

return statearr_56541;
})();
var statearr_56542_56570 = state_56537__$1;
(statearr_56542_56570[(2)] = null);

(statearr_56542_56570[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56538 === (13))){
var inst_56532 = (state_56537[(2)]);
var _ = (function (){var statearr_56543 = state_56537;
(statearr_56543[(4)] = cljs.core.rest((state_56537[(4)])));

return statearr_56543;
})();
var state_56537__$1 = state_56537;
var statearr_56544_56571 = state_56537__$1;
(statearr_56544_56571[(2)] = inst_56532);

(statearr_56544_56571[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56538 === (6))){
var inst_56496 = (state_56537[(2)]);
var state_56537__$1 = state_56537;
var statearr_56545_56572 = state_56537__$1;
(statearr_56545_56572[(2)] = inst_56496);

(statearr_56545_56572[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56538 === (3))){
var inst_56535 = (state_56537[(2)]);
var state_56537__$1 = state_56537;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56537__$1,inst_56535);
} else {
if((state_val_56538 === (12))){
var inst_56519 = (state_56537[(8)]);
var inst_56528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56529 = [null,inst_56519];
var inst_56530 = (new cljs.core.PersistentVector(null,2,(5),inst_56528,inst_56529,null));
var state_56537__$1 = state_56537;
var statearr_56546_56573 = state_56537__$1;
(statearr_56546_56573[(2)] = inst_56530);

(statearr_56546_56573[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56538 === (2))){
var _ = (function (){var statearr_56548 = state_56537;
(statearr_56548[(4)] = cljs.core.cons((9),(state_56537[(4)])));

return statearr_56548;
})();
var inst_56505 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_56506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56508 = [null,pred_name,"?o"];
var inst_56509 = (new cljs.core.PersistentVector(null,3,(5),inst_56507,inst_56508,null));
var inst_56510 = [inst_56509];
var inst_56511 = (new cljs.core.PersistentVector(null,1,(5),inst_56506,inst_56510,null));
var inst_56512 = ["?o",inst_56511,opts];
var inst_56513 = cljs.core.PersistentHashMap.fromArrays(inst_56505,inst_56512);
var inst_56514 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_56513);
var state_56537__$1 = state_56537;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56537__$1,(10),inst_56514);
} else {
if((state_val_56538 === (11))){
var inst_56518 = (state_56537[(9)]);
var inst_56519 = (state_56537[(8)]);
var inst_56523 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56524 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_56518);
var inst_56525 = [inst_56524,inst_56519];
var inst_56526 = (new cljs.core.PersistentVector(null,2,(5),inst_56523,inst_56525,null));
var state_56537__$1 = state_56537;
var statearr_56549_56574 = state_56537__$1;
(statearr_56549_56574[(2)] = inst_56526);

(statearr_56549_56574[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56538 === (9))){
var _ = (function (){var statearr_56550 = state_56537;
(statearr_56550[(4)] = cljs.core.rest((state_56537[(4)])));

return statearr_56550;
})();
var state_56537__$1 = state_56537;
var ex56547 = (state_56537__$1[(2)]);
var statearr_56551_56575 = state_56537__$1;
(statearr_56551_56575[(5)] = ex56547);


var statearr_56552_56576 = state_56537__$1;
(statearr_56552_56576[(1)] = (4));

(statearr_56552_56576[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_56538 === (5))){
var inst_56486 = (state_56537[(7)]);
var _ = (function (){var statearr_56554 = state_56537;
(statearr_56554[(4)] = cljs.core.cons((8),(state_56537[(4)])));

return statearr_56554;
})();
var inst_56493 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_56486,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_56555 = state_56537;
(statearr_56555[(4)] = cljs.core.rest((state_56537[(4)])));

return statearr_56555;
})();
var state_56537__$1 = state_56537;
var statearr_56556_56577 = state_56537__$1;
(statearr_56556_56577[(2)] = inst_56493);

(statearr_56556_56577[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56538 === (10))){
var inst_56518 = (state_56537[(9)]);
var inst_56516 = (state_56537[(2)]);
var inst_56517 = fluree.db.util.async.throw_err(inst_56516);
var inst_56518__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56517,(0),null);
var inst_56519 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56517,(1),null);
var inst_56520 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_56518__$1);
var inst_56521 = cljs.core.not(inst_56520);
var state_56537__$1 = (function (){var statearr_56557 = state_56537;
(statearr_56557[(9)] = inst_56518__$1);

(statearr_56557[(8)] = inst_56519);

return statearr_56557;
})();
if(inst_56521){
var statearr_56558_56578 = state_56537__$1;
(statearr_56558_56578[(1)] = (11));

} else {
var statearr_56559_56579 = state_56537__$1;
(statearr_56559_56579[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56538 === (8))){
var _ = (function (){var statearr_56560 = state_56537;
(statearr_56560[(4)] = cljs.core.rest((state_56537[(4)])));

return statearr_56560;
})();
var state_56537__$1 = state_56537;
var ex56553 = (state_56537__$1[(2)]);
var statearr_56561_56580 = state_56537__$1;
(statearr_56561_56580[(5)] = ex56553);


var statearr_56562_56581 = state_56537__$1;
(statearr_56562_56581[(1)] = (7));

(statearr_56562_56581[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__20477__auto____0 = (function (){
var statearr_56563 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56563[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__20477__auto__);

(statearr_56563[(1)] = (1));

return statearr_56563;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__20477__auto____1 = (function (state_56537){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_56537);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e56564){var ex__20480__auto__ = e56564;
var statearr_56565_56582 = state_56537;
(statearr_56565_56582[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_56537[(4)]))){
var statearr_56566_56583 = state_56537;
(statearr_56566_56583[(1)] = cljs.core.first((state_56537[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__56584 = state_56537;
state_56537 = G__56584;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__20477__auto__ = function(state_56537){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__20477__auto____1.call(this,state_56537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_56567 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_56567[(6)] = c__20603__auto__);

return statearr_56567;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4221__auto__ = typeof email === 'string';
if(and__4221__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4221__auto__;
}
})());
}catch (e56585){var e = e56585;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__56587 = arguments.length;
switch (G__56587) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_56657){
var state_val_56658 = (state_56657[(1)]);
if((state_val_56658 === (7))){
var inst_56589 = (state_56657[(2)]);
var state_56657__$1 = state_56657;
var statearr_56659_56703 = state_56657__$1;
(statearr_56659_56703[(2)] = inst_56589);

(statearr_56659_56703[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (20))){
var inst_56633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56634 = ["*"];
var inst_56635 = (new cljs.core.PersistentVector(null,1,(5),inst_56633,inst_56634,null));
var state_56657__$1 = state_56657;
var statearr_56660_56704 = state_56657__$1;
(statearr_56660_56704[(2)] = inst_56635);

(statearr_56660_56704[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (1))){
var state_56657__$1 = state_56657;
var statearr_56661_56705 = state_56657__$1;
(statearr_56661_56705[(2)] = null);

(statearr_56661_56705[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (4))){
var inst_56588 = (state_56657[(2)]);
var state_56657__$1 = (function (){var statearr_56662 = state_56657;
(statearr_56662[(7)] = inst_56588);

return statearr_56662;
})();
var statearr_56663_56706 = state_56657__$1;
(statearr_56663_56706[(2)] = null);

(statearr_56663_56706[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (15))){
var inst_56652 = (state_56657[(2)]);
var _ = (function (){var statearr_56664 = state_56657;
(statearr_56664[(4)] = cljs.core.rest((state_56657[(4)])));

return statearr_56664;
})();
var state_56657__$1 = state_56657;
var statearr_56665_56707 = state_56657__$1;
(statearr_56665_56707[(2)] = inst_56652);

(statearr_56665_56707[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (21))){
var inst_56616 = (state_56657[(8)]);
var inst_56623 = (state_56657[(9)]);
var inst_56637 = (state_56657[(2)]);
var inst_56638 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_56639 = cljs.core.PersistentHashMap.EMPTY;
var inst_56640 = [inst_56637,inst_56623,inst_56639];
var inst_56641 = cljs.core.PersistentHashMap.fromArrays(inst_56638,inst_56640);
var inst_56642 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56616,inst_56641);
var state_56657__$1 = state_56657;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56657__$1,(22),inst_56642);
} else {
if((state_val_56658 === (13))){
var inst_56611 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56657__$1 = state_56657;
var statearr_56666_56708 = state_56657__$1;
(statearr_56666_56708[(2)] = inst_56611);

(statearr_56666_56708[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (22))){
var inst_56644 = (state_56657[(2)]);
var inst_56645 = fluree.db.util.async.throw_err(inst_56644);
var inst_56646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56645,(0),null);
var inst_56647 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56645,(1),null);
var inst_56648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56649 = [inst_56646,inst_56647];
var inst_56650 = (new cljs.core.PersistentVector(null,2,(5),inst_56648,inst_56649,null));
var state_56657__$1 = state_56657;
var statearr_56667_56709 = state_56657__$1;
(statearr_56667_56709[(2)] = inst_56650);

(statearr_56667_56709[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (6))){
var inst_56598 = (state_56657[(2)]);
var state_56657__$1 = state_56657;
var statearr_56668_56710 = state_56657__$1;
(statearr_56668_56710[(2)] = inst_56598);

(statearr_56668_56710[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (17))){
var inst_56620 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56621 = fluree.db.dbfunctions.internal.get(inst_56620,cljs.core.cst$kw$_id);
var state_56657__$1 = state_56657;
var statearr_56669_56711 = state_56657__$1;
(statearr_56669_56711[(2)] = inst_56621);

(statearr_56669_56711[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (3))){
var inst_56655 = (state_56657[(2)]);
var state_56657__$1 = state_56657;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56657__$1,inst_56655);
} else {
if((state_val_56658 === (12))){
var inst_56609 = (state_56657[(2)]);
var state_56657__$1 = state_56657;
if(cljs.core.truth_(inst_56609)){
var statearr_56670_56712 = state_56657__$1;
(statearr_56670_56712[(1)] = (13));

} else {
var statearr_56671_56713 = state_56657__$1;
(statearr_56671_56713[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (2))){
var inst_56604 = (state_56657[(10)]);
var _ = (function (){var statearr_56672 = state_56657;
(statearr_56672[(4)] = cljs.core.cons((9),(state_56657[(4)])));

return statearr_56672;
})();
var inst_56604__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56657__$1 = (function (){var statearr_56673 = state_56657;
(statearr_56673[(10)] = inst_56604__$1);

return statearr_56673;
})();
if(cljs.core.truth_(inst_56604__$1)){
var statearr_56674_56714 = state_56657__$1;
(statearr_56674_56714[(1)] = (10));

} else {
var statearr_56675_56715 = state_56657__$1;
(statearr_56675_56715[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (19))){
var inst_56625 = cljs.core.PersistentVector.EMPTY;
var inst_56626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56627 = ["*"];
var inst_56628 = (new cljs.core.PersistentVector(null,1,(5),inst_56626,inst_56627,null));
var inst_56629 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_56630 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_56628,inst_56629);
var inst_56631 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_56625,inst_56630);
var state_56657__$1 = state_56657;
var statearr_56677_56716 = state_56657__$1;
(statearr_56677_56716[(2)] = inst_56631);

(statearr_56677_56716[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (11))){
var inst_56604 = (state_56657[(10)]);
var state_56657__$1 = state_56657;
var statearr_56678_56717 = state_56657__$1;
(statearr_56678_56717[(2)] = inst_56604);

(statearr_56678_56717[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (9))){
var _ = (function (){var statearr_56679 = state_56657;
(statearr_56679[(4)] = cljs.core.rest((state_56657[(4)])));

return statearr_56679;
})();
var state_56657__$1 = state_56657;
var ex56676 = (state_56657__$1[(2)]);
var statearr_56680_56718 = state_56657__$1;
(statearr_56680_56718[(5)] = ex56676);


var statearr_56681_56719 = state_56657__$1;
(statearr_56681_56719[(1)] = (4));

(statearr_56681_56719[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (5))){
var inst_56588 = (state_56657[(7)]);
var _ = (function (){var statearr_56682 = state_56657;
(statearr_56682[(4)] = cljs.core.cons((8),(state_56657[(4)])));

return statearr_56682;
})();
var inst_56595 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_56588,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_56683 = state_56657;
(statearr_56683[(4)] = cljs.core.rest((state_56657[(4)])));

return statearr_56683;
})();
var state_56657__$1 = state_56657;
var statearr_56684_56720 = state_56657__$1;
(statearr_56684_56720[(2)] = inst_56595);

(statearr_56684_56720[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (14))){
var inst_56617 = (state_56657[(11)]);
var inst_56616 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56617__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56657__$1 = (function (){var statearr_56685 = state_56657;
(statearr_56685[(8)] = inst_56616);

(statearr_56685[(11)] = inst_56617__$1);

return statearr_56685;
})();
if(cljs.core.truth_(inst_56617__$1)){
var statearr_56686_56721 = state_56657__$1;
(statearr_56686_56721[(1)] = (16));

} else {
var statearr_56687_56722 = state_56657__$1;
(statearr_56687_56722[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (16))){
var inst_56617 = (state_56657[(11)]);
var state_56657__$1 = state_56657;
var statearr_56688_56723 = state_56657__$1;
(statearr_56688_56723[(2)] = inst_56617);

(statearr_56688_56723[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (10))){
var inst_56606 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_56657__$1 = state_56657;
var statearr_56690_56724 = state_56657__$1;
(statearr_56690_56724[(2)] = inst_56606);

(statearr_56690_56724[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (18))){
var inst_56623 = (state_56657[(2)]);
var state_56657__$1 = (function (){var statearr_56691 = state_56657;
(statearr_56691[(9)] = inst_56623);

return statearr_56691;
})();
if(cljs.core.truth_(additional_params)){
var statearr_56692_56725 = state_56657__$1;
(statearr_56692_56725[(1)] = (19));

} else {
var statearr_56693_56726 = state_56657__$1;
(statearr_56693_56726[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56658 === (8))){
var _ = (function (){var statearr_56694 = state_56657;
(statearr_56694[(4)] = cljs.core.rest((state_56657[(4)])));

return statearr_56694;
})();
var state_56657__$1 = state_56657;
var ex56689 = (state_56657__$1[(2)]);
var statearr_56695_56727 = state_56657__$1;
(statearr_56695_56727[(5)] = ex56689);


var statearr_56696_56728 = state_56657__$1;
(statearr_56696_56728[(1)] = (7));

(statearr_56696_56728[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__20477__auto____0 = (function (){
var statearr_56697 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56697[(0)] = fluree$db$dbfunctions$internal$state_machine__20477__auto__);

(statearr_56697[(1)] = (1));

return statearr_56697;
});
var fluree$db$dbfunctions$internal$state_machine__20477__auto____1 = (function (state_56657){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_56657);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e56698){var ex__20480__auto__ = e56698;
var statearr_56699_56729 = state_56657;
(statearr_56699_56729[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_56657[(4)]))){
var statearr_56700_56730 = state_56657;
(statearr_56700_56730[(1)] = cljs.core.first((state_56657[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__56731 = state_56657;
state_56657 = G__56731;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__20477__auto__ = function(state_56657){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__20477__auto____1.call(this,state_56657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__20477__auto____0;
fluree$db$dbfunctions$internal$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__20477__auto____1;
return fluree$db$dbfunctions$internal$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_56701 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_56701[(6)] = c__20603__auto__);

return statearr_56701;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__56733 = arguments.length;
switch (G__56733) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_56777){
var state_val_56778 = (state_56777[(1)]);
if((state_val_56778 === (7))){
var inst_56755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56756 = ["*"];
var inst_56757 = (new cljs.core.PersistentVector(null,1,(5),inst_56755,inst_56756,null));
var state_56777__$1 = state_56777;
var statearr_56779_56799 = state_56777__$1;
(statearr_56779_56799[(2)] = inst_56757);

(statearr_56779_56799[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56778 === (1))){
var state_56777__$1 = state_56777;
var statearr_56780_56800 = state_56777__$1;
(statearr_56780_56800[(2)] = null);

(statearr_56780_56800[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56778 === (4))){
var inst_56734 = (state_56777[(2)]);
var inst_56735 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_56734,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_56777__$1 = state_56777;
var statearr_56781_56801 = state_56777__$1;
(statearr_56781_56801[(2)] = inst_56735);

(statearr_56781_56801[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56778 === (6))){
var inst_56747 = cljs.core.PersistentVector.EMPTY;
var inst_56748 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56749 = ["*"];
var inst_56750 = (new cljs.core.PersistentVector(null,1,(5),inst_56748,inst_56749,null));
var inst_56751 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_56752 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_56750,inst_56751);
var inst_56753 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_56747,inst_56752);
var state_56777__$1 = state_56777;
var statearr_56782_56802 = state_56777__$1;
(statearr_56782_56802[(2)] = inst_56753);

(statearr_56782_56802[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56778 === (3))){
var inst_56775 = (state_56777[(2)]);
var state_56777__$1 = state_56777;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56777__$1,inst_56775);
} else {
if((state_val_56778 === (2))){
var _ = (function (){var statearr_56784 = state_56777;
(statearr_56784[(4)] = cljs.core.cons((5),(state_56777[(4)])));

return statearr_56784;
})();
var inst_56744 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56745 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_56777__$1 = (function (){var statearr_56785 = state_56777;
(statearr_56785[(7)] = inst_56745);

(statearr_56785[(8)] = inst_56744);

return statearr_56785;
})();
if(cljs.core.truth_(additional_params)){
var statearr_56786_56803 = state_56777__$1;
(statearr_56786_56803[(1)] = (6));

} else {
var statearr_56787_56804 = state_56777__$1;
(statearr_56787_56804[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56778 === (9))){
var inst_56766 = (state_56777[(2)]);
var inst_56767 = fluree.db.util.async.throw_err(inst_56766);
var inst_56768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56767,(0),null);
var inst_56769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56767,(1),null);
var inst_56770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56771 = [inst_56768,inst_56769];
var inst_56772 = (new cljs.core.PersistentVector(null,2,(5),inst_56770,inst_56771,null));
var _ = (function (){var statearr_56788 = state_56777;
(statearr_56788[(4)] = cljs.core.rest((state_56777[(4)])));

return statearr_56788;
})();
var state_56777__$1 = state_56777;
var statearr_56789_56805 = state_56777__$1;
(statearr_56789_56805[(2)] = inst_56772);

(statearr_56789_56805[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56778 === (5))){
var _ = (function (){var statearr_56790 = state_56777;
(statearr_56790[(4)] = cljs.core.rest((state_56777[(4)])));

return statearr_56790;
})();
var state_56777__$1 = state_56777;
var ex56783 = (state_56777__$1[(2)]);
var statearr_56791_56806 = state_56777__$1;
(statearr_56791_56806[(5)] = ex56783);


var statearr_56792_56807 = state_56777__$1;
(statearr_56792_56807[(1)] = (4));

(statearr_56792_56807[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_56778 === (8))){
var inst_56745 = (state_56777[(7)]);
var inst_56744 = (state_56777[(8)]);
var inst_56759 = (state_56777[(2)]);
var inst_56760 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_56761 = cljs.core.PersistentHashMap.EMPTY;
var inst_56762 = [inst_56759,inst_56745,inst_56761];
var inst_56763 = cljs.core.PersistentHashMap.fromArrays(inst_56760,inst_56762);
var inst_56764 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56744,inst_56763);
var state_56777__$1 = state_56777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56777__$1,(9),inst_56764);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__20477__auto____0 = (function (){
var statearr_56793 = [null,null,null,null,null,null,null,null,null];
(statearr_56793[(0)] = fluree$db$dbfunctions$internal$state_machine__20477__auto__);

(statearr_56793[(1)] = (1));

return statearr_56793;
});
var fluree$db$dbfunctions$internal$state_machine__20477__auto____1 = (function (state_56777){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_56777);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e56794){var ex__20480__auto__ = e56794;
var statearr_56795_56808 = state_56777;
(statearr_56795_56808[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_56777[(4)]))){
var statearr_56796_56809 = state_56777;
(statearr_56796_56809[(1)] = cljs.core.first((state_56777[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__56810 = state_56777;
state_56777 = G__56810;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__20477__auto__ = function(state_56777){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__20477__auto____1.call(this,state_56777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__20477__auto____0;
fluree$db$dbfunctions$internal$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__20477__auto____1;
return fluree$db$dbfunctions$internal$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_56797 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_56797[(6)] = c__20603__auto__);

return statearr_56797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_56854){
var state_val_56855 = (state_56854[(1)]);
if((state_val_56855 === (1))){
var state_56854__$1 = state_56854;
var statearr_56856_56870 = state_56854__$1;
(statearr_56856_56870[(2)] = null);

(statearr_56856_56870[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56855 === (2))){
var _ = (function (){var statearr_56857 = state_56854;
(statearr_56857[(4)] = cljs.core.cons((5),(state_56854[(4)])));

return statearr_56857;
})();
var inst_56821 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_56822 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56823 = ["_user/_auth"];
var inst_56824 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56825 = ["*"];
var inst_56826 = (new cljs.core.PersistentVector(null,1,(5),inst_56824,inst_56825,null));
var inst_56827 = [inst_56826];
var inst_56828 = cljs.core.PersistentHashMap.fromArrays(inst_56823,inst_56827);
var inst_56829 = [inst_56828];
var inst_56830 = (new cljs.core.PersistentVector(null,1,(5),inst_56822,inst_56829,null));
var inst_56831 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56832 = cljs.core.PersistentHashMap.EMPTY;
var inst_56833 = [inst_56830,inst_56831,inst_56832];
var inst_56834 = cljs.core.PersistentHashMap.fromArrays(inst_56821,inst_56833);
var inst_56835 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56836 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56835,inst_56834);
var state_56854__$1 = state_56854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56854__$1,(6),inst_56836);
} else {
if((state_val_56855 === (3))){
var inst_56852 = (state_56854[(2)]);
var state_56854__$1 = state_56854;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56854__$1,inst_56852);
} else {
if((state_val_56855 === (4))){
var inst_56811 = (state_56854[(2)]);
var inst_56812 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_56811,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_56854__$1 = state_56854;
var statearr_56859_56871 = state_56854__$1;
(statearr_56859_56871[(2)] = inst_56812);

(statearr_56859_56871[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56855 === (5))){
var _ = (function (){var statearr_56860 = state_56854;
(statearr_56860[(4)] = cljs.core.rest((state_56854[(4)])));

return statearr_56860;
})();
var state_56854__$1 = state_56854;
var ex56858 = (state_56854__$1[(2)]);
var statearr_56861_56872 = state_56854__$1;
(statearr_56861_56872[(5)] = ex56858);


var statearr_56862_56873 = state_56854__$1;
(statearr_56862_56873[(1)] = (4));

(statearr_56862_56873[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_56855 === (6))){
var inst_56838 = (state_56854[(2)]);
var inst_56839 = fluree.db.util.async.throw_err(inst_56838);
var inst_56840 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56839,(0),null);
var inst_56841 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56839,(1),null);
var inst_56842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56843 = ["_user/_auth","_id"];
var inst_56844 = (new cljs.core.PersistentVector(null,2,(5),inst_56842,inst_56843,null));
var inst_56845 = fluree.db.dbfunctions.internal.get_in(inst_56840,inst_56844);
var inst_56846 = cljs.core.first(inst_56845);
var inst_56847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56848 = [inst_56846,inst_56841];
var inst_56849 = (new cljs.core.PersistentVector(null,2,(5),inst_56847,inst_56848,null));
var _ = (function (){var statearr_56863 = state_56854;
(statearr_56863[(4)] = cljs.core.rest((state_56854[(4)])));

return statearr_56863;
})();
var state_56854__$1 = state_56854;
var statearr_56864_56874 = state_56854__$1;
(statearr_56864_56874[(2)] = inst_56849);

(statearr_56864_56874[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__20477__auto____0 = (function (){
var statearr_56865 = [null,null,null,null,null,null,null];
(statearr_56865[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__20477__auto__);

(statearr_56865[(1)] = (1));

return statearr_56865;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__20477__auto____1 = (function (state_56854){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_56854);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e56866){var ex__20480__auto__ = e56866;
var statearr_56867_56875 = state_56854;
(statearr_56867_56875[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_56854[(4)]))){
var statearr_56868_56876 = state_56854;
(statearr_56868_56876[(1)] = cljs.core.first((state_56854[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__56877 = state_56854;
state_56854 = G__56877;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__20477__auto__ = function(state_56854){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__20477__auto____1.call(this,state_56854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_56869 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_56869[(6)] = c__20603__auto__);

return statearr_56869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_56894){
var state_val_56895 = (state_56894[(1)]);
if((state_val_56895 === (1))){
var state_56894__$1 = state_56894;
var statearr_56896_56910 = state_56894__$1;
(statearr_56896_56910[(2)] = null);

(statearr_56896_56910[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56895 === (2))){
var _ = (function (){var statearr_56897 = state_56894;
(statearr_56897[(4)] = cljs.core.cons((5),(state_56894[(4)])));

return statearr_56897;
})();
var inst_56884 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56885 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56886 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_56885,inst_56884);
var state_56894__$1 = state_56894;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_56894__$1,(6),inst_56886);
} else {
if((state_val_56895 === (3))){
var inst_56892 = (state_56894[(2)]);
var state_56894__$1 = state_56894;
return cljs.core.async.impl.ioc_helpers.return_chan(state_56894__$1,inst_56892);
} else {
if((state_val_56895 === (4))){
var inst_56878 = (state_56894[(2)]);
var state_56894__$1 = state_56894;
var statearr_56899_56911 = state_56894__$1;
(statearr_56899_56911[(2)] = inst_56878);

(statearr_56899_56911[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_56895 === (5))){
var _ = (function (){var statearr_56900 = state_56894;
(statearr_56900[(4)] = cljs.core.rest((state_56894[(4)])));

return statearr_56900;
})();
var state_56894__$1 = state_56894;
var ex56898 = (state_56894__$1[(2)]);
var statearr_56901_56912 = state_56894__$1;
(statearr_56901_56912[(5)] = ex56898);


if((ex56898 instanceof Error)){
var statearr_56902_56913 = state_56894__$1;
(statearr_56902_56913[(1)] = (4));

(statearr_56902_56913[(5)] = null);

} else {
throw ex56898;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_56895 === (6))){
var inst_56888 = (state_56894[(2)]);
var inst_56889 = fluree.db.util.async.throw_err(inst_56888);
var _ = (function (){var statearr_56903 = state_56894;
(statearr_56903[(4)] = cljs.core.rest((state_56894[(4)])));

return statearr_56903;
})();
var state_56894__$1 = state_56894;
var statearr_56904_56914 = state_56894__$1;
(statearr_56904_56914[(2)] = inst_56889);

(statearr_56904_56914[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__20477__auto____0 = (function (){
var statearr_56905 = [null,null,null,null,null,null,null];
(statearr_56905[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__20477__auto__);

(statearr_56905[(1)] = (1));

return statearr_56905;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__20477__auto____1 = (function (state_56894){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_56894);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e56906){var ex__20480__auto__ = e56906;
var statearr_56907_56915 = state_56894;
(statearr_56907_56915[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_56894[(4)]))){
var statearr_56908_56916 = state_56894;
(statearr_56908_56916[(1)] = cljs.core.first((state_56894[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__56917 = state_56894;
state_56894 = G__56917;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__20477__auto__ = function(state_56894){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__20477__auto____1.call(this,state_56894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_56909 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_56909[(6)] = c__20603__auto__);

return statearr_56909;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__56918_SHARP_){
return p1__56918_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__56919_SHARP_){
return p1__56919_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e56920){var e = e56920;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__56921_SHARP_){
return p1__56921_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__56922_SHARP_){
return p1__56922_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e56923){var e = e56923;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__56925 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__56925);
})() | (0));
return num;
}catch (e56924){var e = e56924;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_57005){
var state_val_57006 = (state_57005[(1)]);
if((state_val_57006 === (7))){
var inst_56944 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_56945 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_56946 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_56947 = cljs.core.PersistentHashMap.fromArrays(inst_56945,inst_56946);
var inst_56948 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_56944,inst_56947);
var inst_56949 = (function(){throw inst_56948})();
var state_57005__$1 = state_57005;
var statearr_57007_57042 = state_57005__$1;
(statearr_57007_57042[(2)] = inst_56949);

(statearr_57007_57042[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (1))){
var state_57005__$1 = state_57005;
var statearr_57008_57043 = state_57005__$1;
(statearr_57008_57043[(2)] = null);

(statearr_57008_57043[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (4))){
var inst_56926 = (state_57005[(2)]);
var state_57005__$1 = state_57005;
var statearr_57009_57044 = state_57005__$1;
(statearr_57009_57044[(2)] = inst_56926);

(statearr_57009_57044[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (15))){
var inst_56989 = (state_57005[(7)]);
var inst_56985 = (state_57005[(2)]);
var inst_56986 = fluree.db.util.async.throw_err(inst_56985);
var inst_56987 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56986,(0),null);
var inst_56988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_56986,(1),null);
var inst_56989__$1 = cljs.core.first(inst_56987);
var inst_56990 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_56989__$1,compare_val);
var state_57005__$1 = (function (){var statearr_57010 = state_57005;
(statearr_57010[(8)] = inst_56988);

(statearr_57010[(7)] = inst_56989__$1);

return statearr_57010;
})();
if(inst_56990){
var statearr_57011_57045 = state_57005__$1;
(statearr_57011_57045[(1)] = (16));

} else {
var statearr_57012_57046 = state_57005__$1;
(statearr_57012_57046[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (13))){
var state_57005__$1 = state_57005;
var statearr_57013_57047 = state_57005__$1;
(statearr_57013_57047[(2)] = null);

(statearr_57013_57047[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (6))){
var state_57005__$1 = state_57005;
var statearr_57014_57048 = state_57005__$1;
(statearr_57014_57048[(2)] = null);

(statearr_57014_57048[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (17))){
var inst_56989 = (state_57005[(7)]);
var inst_56993 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_56989)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_56994 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_56995 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_56996 = cljs.core.PersistentHashMap.fromArrays(inst_56994,inst_56995);
var inst_56997 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_56993,inst_56996);
var inst_56998 = (function(){throw inst_56997})();
var state_57005__$1 = state_57005;
var statearr_57015_57049 = state_57005__$1;
(statearr_57015_57049[(2)] = inst_56998);

(statearr_57015_57049[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (3))){
var inst_57003 = (state_57005[(2)]);
var state_57005__$1 = state_57005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_57005__$1,inst_57003);
} else {
if((state_val_57006 === (12))){
var inst_56941 = (state_57005[(9)]);
var inst_56964 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_56941], 0));
var inst_56965 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_56966 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_56967 = cljs.core.PersistentHashMap.fromArrays(inst_56965,inst_56966);
var inst_56968 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_56964,inst_56967);
var inst_56969 = (function(){throw inst_56968})();
var state_57005__$1 = state_57005;
var statearr_57016_57050 = state_57005__$1;
(statearr_57016_57050[(2)] = inst_56969);

(statearr_57016_57050[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (2))){
var inst_56940 = (state_57005[(10)]);
var inst_56938 = (state_57005[(11)]);
var inst_56939 = (state_57005[(12)]);
var _ = (function (){var statearr_57017 = state_57005;
(statearr_57017[(4)] = cljs.core.cons((5),(state_57005[(4)])));

return statearr_57017;
})();
var inst_56936 = _QMARK_ctx;
var inst_56937 = cljs.core.__destructure_map(inst_56936);
var inst_56938__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56937,cljs.core.cst$kw$sid);
var inst_56939__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56937,cljs.core.cst$kw$pid);
var inst_56940__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_56937,cljs.core.cst$kw$db);
var inst_56941 = fluree.db.dbproto._p_prop(inst_56940__$1,cljs.core.cst$kw$name,inst_56939__$1);
var state_57005__$1 = (function (){var statearr_57018 = state_57005;
(statearr_57018[(10)] = inst_56940__$1);

(statearr_57018[(11)] = inst_56938__$1);

(statearr_57018[(9)] = inst_56941);

(statearr_57018[(12)] = inst_56939__$1);

return statearr_57018;
})();
if(cljs.core.truth_(inst_56938__$1)){
var statearr_57019_57051 = state_57005__$1;
(statearr_57019_57051[(1)] = (6));

} else {
var statearr_57020_57052 = state_57005__$1;
(statearr_57020_57052[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (11))){
var inst_56940 = (state_57005[(10)]);
var inst_56939 = (state_57005[(12)]);
var inst_56961 = (state_57005[(2)]);
var inst_56962 = fluree.db.dbproto._p_prop(inst_56940,cljs.core.cst$kw$multi,inst_56939);
var state_57005__$1 = (function (){var statearr_57022 = state_57005;
(statearr_57022[(13)] = inst_56961);

return statearr_57022;
})();
if(cljs.core.truth_(inst_56962)){
var statearr_57023_57053 = state_57005__$1;
(statearr_57023_57053[(1)] = (12));

} else {
var statearr_57024_57054 = state_57005__$1;
(statearr_57024_57054[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (9))){
var state_57005__$1 = state_57005;
var statearr_57025_57055 = state_57005__$1;
(statearr_57025_57055[(2)] = null);

(statearr_57025_57055[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (5))){
var _ = (function (){var statearr_57026 = state_57005;
(statearr_57026[(4)] = cljs.core.rest((state_57005[(4)])));

return statearr_57026;
})();
var state_57005__$1 = state_57005;
var ex57021 = (state_57005__$1[(2)]);
var statearr_57027_57056 = state_57005__$1;
(statearr_57027_57056[(5)] = ex57021);


if((ex57021 instanceof Error)){
var statearr_57028_57057 = state_57005__$1;
(statearr_57028_57057[(1)] = (4));

(statearr_57028_57057[(5)] = null);

} else {
throw ex57021;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (14))){
var inst_56940 = (state_57005[(10)]);
var inst_56938 = (state_57005[(11)]);
var inst_56941 = (state_57005[(9)]);
var inst_56972 = (state_57005[(2)]);
var inst_56973 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_56974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56976 = [inst_56938,inst_56941,"?current-val"];
var inst_56977 = (new cljs.core.PersistentVector(null,3,(5),inst_56975,inst_56976,null));
var inst_56978 = [inst_56977];
var inst_56979 = (new cljs.core.PersistentVector(null,1,(5),inst_56974,inst_56978,null));
var inst_56980 = cljs.core.PersistentHashMap.EMPTY;
var inst_56981 = ["?current-val",inst_56979,inst_56980];
var inst_56982 = cljs.core.PersistentHashMap.fromArrays(inst_56973,inst_56981);
var inst_56983 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_56940,inst_56982);
var state_57005__$1 = (function (){var statearr_57029 = state_57005;
(statearr_57029[(14)] = inst_56972);

return statearr_57029;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_57005__$1,(15),inst_56983);
} else {
if((state_val_57006 === (16))){
var state_57005__$1 = state_57005;
var statearr_57030_57058 = state_57005__$1;
(statearr_57030_57058[(2)] = new_val);

(statearr_57030_57058[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (10))){
var inst_56954 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_56955 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_56956 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_56957 = cljs.core.PersistentHashMap.fromArrays(inst_56955,inst_56956);
var inst_56958 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_56954,inst_56957);
var inst_56959 = (function(){throw inst_56958})();
var state_57005__$1 = state_57005;
var statearr_57031_57059 = state_57005__$1;
(statearr_57031_57059[(2)] = inst_56959);

(statearr_57031_57059[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (18))){
var inst_57000 = (state_57005[(2)]);
var _ = (function (){var statearr_57032 = state_57005;
(statearr_57032[(4)] = cljs.core.rest((state_57005[(4)])));

return statearr_57032;
})();
var state_57005__$1 = state_57005;
var statearr_57033_57060 = state_57005__$1;
(statearr_57033_57060[(2)] = inst_57000);

(statearr_57033_57060[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_57006 === (8))){
var inst_56941 = (state_57005[(9)]);
var inst_56951 = (state_57005[(2)]);
var state_57005__$1 = (function (){var statearr_57034 = state_57005;
(statearr_57034[(15)] = inst_56951);

return statearr_57034;
})();
if(cljs.core.truth_(inst_56941)){
var statearr_57035_57061 = state_57005__$1;
(statearr_57035_57061[(1)] = (9));

} else {
var statearr_57036_57062 = state_57005__$1;
(statearr_57036_57062[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__20477__auto____0 = (function (){
var statearr_57037 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_57037[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__20477__auto__);

(statearr_57037[(1)] = (1));

return statearr_57037;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__20477__auto____1 = (function (state_57005){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_57005);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e57038){var ex__20480__auto__ = e57038;
var statearr_57039_57063 = state_57005;
(statearr_57039_57063[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_57005[(4)]))){
var statearr_57040_57064 = state_57005;
(statearr_57040_57064[(1)] = cljs.core.first((state_57005[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__57065 = state_57005;
state_57005 = G__57065;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__20477__auto__ = function(state_57005){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__20477__auto____1.call(this,state_57005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_57041 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_57041[(6)] = c__20603__auto__);

return statearr_57041;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
