// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4878__auto___81712 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_81763){
var state_val_81764 = (state_81763[(1)]);
if((state_val_81764 === (7))){
var inst_81758 = (state_81763[(2)]);
var _ = (function (){var statearr_81765 = state_81763;
(statearr_81765[(4)] = cljs.core.rest((state_81763[(4)])));

return statearr_81765;
})();
var state_81763__$1 = state_81763;
var statearr_81766_81793 = state_81763__$1;
(statearr_81766_81793[(2)] = inst_81758);

(statearr_81766_81793[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81764 === (1))){
var state_81763__$1 = state_81763;
var statearr_81767_81794 = state_81763__$1;
(statearr_81767_81794[(2)] = null);

(statearr_81767_81794[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81764 === (4))){
var inst_81713 = (state_81763[(2)]);
var state_81763__$1 = state_81763;
var statearr_81768_81795 = state_81763__$1;
(statearr_81768_81795[(2)] = inst_81713);

(statearr_81768_81795[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81764 === (13))){
var inst_81754 = (state_81763[(2)]);
var state_81763__$1 = state_81763;
var statearr_81769_81796 = state_81763__$1;
(statearr_81769_81796[(2)] = inst_81754);

(statearr_81769_81796[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81764 === (6))){
var inst_81731 = (state_81763[(7)]);
var inst_81738 = (state_81763[(8)]);
var inst_81737 = cljs.core.seq(inst_81731);
var inst_81738__$1 = cljs.core.first(inst_81737);
var inst_81739 = cljs.core.next(inst_81737);
var inst_81740 = cljs.core.not(inst_81738__$1);
var state_81763__$1 = (function (){var statearr_81770 = state_81763;
(statearr_81770[(9)] = inst_81739);

(statearr_81770[(8)] = inst_81738__$1);

return statearr_81770;
})();
if(inst_81740){
var statearr_81771_81797 = state_81763__$1;
(statearr_81771_81797[(1)] = (8));

} else {
var statearr_81772_81798 = state_81763__$1;
(statearr_81772_81798[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81764 === (3))){
var inst_81761 = (state_81763[(2)]);
var state_81763__$1 = state_81763;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81763__$1,inst_81761);
} else {
if((state_val_81764 === (12))){
var inst_81732 = (state_81763[(10)]);
var inst_81739 = (state_81763[(9)]);
var inst_81738 = (state_81763[(8)]);
var inst_81751 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_81732,inst_81738);
var inst_81731 = inst_81739;
var inst_81732__$1 = inst_81751;
var state_81763__$1 = (function (){var statearr_81773 = state_81763;
(statearr_81773[(10)] = inst_81732__$1);

(statearr_81773[(7)] = inst_81731);

return statearr_81773;
})();
var statearr_81774_81799 = state_81763__$1;
(statearr_81774_81799[(2)] = null);

(statearr_81774_81799[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81764 === (2))){
var _ = (function (){var statearr_81775 = state_81763;
(statearr_81775[(4)] = cljs.core.cons((5),(state_81763[(4)])));

return statearr_81775;
})();
var inst_81726 = args;
var inst_81727 = cljs.core.seq(inst_81726);
var inst_81728 = cljs.core.first(inst_81727);
var inst_81729 = cljs.core.next(inst_81727);
var inst_81730 = cljs.core.PersistentVector.EMPTY;
var inst_81731 = inst_81726;
var inst_81732 = inst_81730;
var state_81763__$1 = (function (){var statearr_81776 = state_81763;
(statearr_81776[(10)] = inst_81732);

(statearr_81776[(7)] = inst_81731);

(statearr_81776[(11)] = inst_81728);

(statearr_81776[(12)] = inst_81729);

return statearr_81776;
})();
var statearr_81777_81800 = state_81763__$1;
(statearr_81777_81800[(2)] = null);

(statearr_81777_81800[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81764 === (11))){
var inst_81738 = (state_81763[(8)]);
var state_81763__$1 = state_81763;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81763__$1,(14),inst_81738);
} else {
if((state_val_81764 === (9))){
var inst_81738 = (state_81763[(8)]);
var inst_81743 = fluree.db.util.async.channel_QMARK_(inst_81738);
var state_81763__$1 = state_81763;
if(inst_81743){
var statearr_81779_81801 = state_81763__$1;
(statearr_81779_81801[(1)] = (11));

} else {
var statearr_81780_81802 = state_81763__$1;
(statearr_81780_81802[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81764 === (5))){
var _ = (function (){var statearr_81781 = state_81763;
(statearr_81781[(4)] = cljs.core.rest((state_81763[(4)])));

return statearr_81781;
})();
var state_81763__$1 = state_81763;
var ex81778 = (state_81763__$1[(2)]);
var statearr_81782_81803 = state_81763__$1;
(statearr_81782_81803[(5)] = ex81778);


if((ex81778 instanceof Error)){
var statearr_81783_81804 = state_81763__$1;
(statearr_81783_81804[(1)] = (4));

(statearr_81783_81804[(5)] = null);

} else {
throw ex81778;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81764 === (14))){
var inst_81732 = (state_81763[(10)]);
var inst_81739 = (state_81763[(9)]);
var inst_81746 = (state_81763[(2)]);
var inst_81747 = fluree.db.util.async.throw_err(inst_81746);
var inst_81748 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_81732,inst_81747);
var inst_81731 = inst_81739;
var inst_81732__$1 = inst_81748;
var state_81763__$1 = (function (){var statearr_81784 = state_81763;
(statearr_81784[(10)] = inst_81732__$1);

(statearr_81784[(7)] = inst_81731);

return statearr_81784;
})();
var statearr_81785_81805 = state_81763__$1;
(statearr_81785_81805[(2)] = null);

(statearr_81785_81805[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81764 === (10))){
var inst_81756 = (state_81763[(2)]);
var state_81763__$1 = state_81763;
var statearr_81786_81806 = state_81763__$1;
(statearr_81786_81806[(2)] = inst_81756);

(statearr_81786_81806[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81764 === (8))){
var inst_81732 = (state_81763[(10)]);
var state_81763__$1 = state_81763;
var statearr_81787_81807 = state_81763__$1;
(statearr_81787_81807[(2)] = inst_81732);

(statearr_81787_81807[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__20477__auto____0 = (function (){
var statearr_81788 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81788[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__20477__auto__);

(statearr_81788[(1)] = (1));

return statearr_81788;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__20477__auto____1 = (function (state_81763){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_81763);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e81789){var ex__20480__auto__ = e81789;
var statearr_81790_81808 = state_81763;
(statearr_81790_81808[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_81763[(4)]))){
var statearr_81791_81809 = state_81763;
(statearr_81791_81809[(1)] = cljs.core.first((state_81763[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__81810 = state_81763;
state_81763 = G__81810;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__20477__auto__ = function(state_81763){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__20477__auto____1.call(this,state_81763);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_81792 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_81792[(6)] = c__20603__auto__);

return statearr_81792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__81811 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__81811,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__81811,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_81859){
var state_val_81860 = (state_81859[(1)]);
if((state_val_81860 === (7))){
var state_81859__$1 = state_81859;
var statearr_81861_81890 = state_81859__$1;
(statearr_81861_81890[(2)] = coll);

(statearr_81861_81890[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81860 === (1))){
var state_81859__$1 = state_81859;
var statearr_81862_81891 = state_81859__$1;
(statearr_81862_81891[(2)] = null);

(statearr_81862_81891[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81860 === (4))){
var inst_81814 = (state_81859[(2)]);
var state_81859__$1 = state_81859;
var statearr_81863_81892 = state_81859__$1;
(statearr_81863_81892[(2)] = inst_81814);

(statearr_81863_81892[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81860 === (15))){
var inst_81833 = (state_81859[(7)]);
var inst_81841 = (state_81859[(2)]);
var inst_81842 = fluree.db.dbfunctions.internal.nth(inst_81833,inst_81841);
var inst_81843 = cljs.core.count(inst_81833);
var inst_81844 = ((9) + inst_81843);
var inst_81845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81846 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81847 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81848 = [inst_81833,inst_81841];
var inst_81849 = (new cljs.core.PersistentVector(null,2,(5),inst_81847,inst_81848,null));
var inst_81850 = ["nth",inst_81849,inst_81842];
var inst_81851 = cljs.core.PersistentHashMap.fromArrays(inst_81846,inst_81850);
var inst_81852 = [inst_81851,inst_81844];
var inst_81853 = (new cljs.core.PersistentVector(null,2,(5),inst_81845,inst_81852,null));
var inst_81854 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81853);
var _ = (function (){var statearr_81864 = state_81859;
(statearr_81864[(4)] = cljs.core.rest((state_81859[(4)])));

return statearr_81864;
})();
var state_81859__$1 = (function (){var statearr_81865 = state_81859;
(statearr_81865[(8)] = inst_81854);

return statearr_81865;
})();
var statearr_81866_81893 = state_81859__$1;
(statearr_81866_81893[(2)] = inst_81842);

(statearr_81866_81893[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81860 === (13))){
var state_81859__$1 = state_81859;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81859__$1,(16),key);
} else {
if((state_val_81860 === (6))){
var state_81859__$1 = state_81859;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81859__$1,(9),coll);
} else {
if((state_val_81860 === (3))){
var inst_81857 = (state_81859[(2)]);
var state_81859__$1 = state_81859;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81859__$1,inst_81857);
} else {
if((state_val_81860 === (12))){
var inst_81833 = (state_81859[(2)]);
var inst_81834 = fluree.db.util.async.channel_QMARK_(key);
var state_81859__$1 = (function (){var statearr_81867 = state_81859;
(statearr_81867[(7)] = inst_81833);

return statearr_81867;
})();
if(inst_81834){
var statearr_81868_81894 = state_81859__$1;
(statearr_81868_81894[(1)] = (13));

} else {
var statearr_81869_81895 = state_81859__$1;
(statearr_81869_81895[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81860 === (2))){
var _ = (function (){var statearr_81870 = state_81859;
(statearr_81870[(4)] = cljs.core.cons((5),(state_81859[(4)])));

return statearr_81870;
})();
var inst_81820 = fluree.db.util.async.channel_QMARK_(coll);
var state_81859__$1 = state_81859;
if(inst_81820){
var statearr_81871_81896 = state_81859__$1;
(statearr_81871_81896[(1)] = (6));

} else {
var statearr_81872_81897 = state_81859__$1;
(statearr_81872_81897[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81860 === (11))){
var inst_81827 = (state_81859[(9)]);
var state_81859__$1 = state_81859;
var statearr_81874_81898 = state_81859__$1;
(statearr_81874_81898[(2)] = inst_81827);

(statearr_81874_81898[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81860 === (9))){
var inst_81823 = (state_81859[(2)]);
var inst_81824 = fluree.db.util.async.throw_err(inst_81823);
var state_81859__$1 = state_81859;
var statearr_81875_81899 = state_81859__$1;
(statearr_81875_81899[(2)] = inst_81824);

(statearr_81875_81899[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81860 === (5))){
var _ = (function (){var statearr_81876 = state_81859;
(statearr_81876[(4)] = cljs.core.rest((state_81859[(4)])));

return statearr_81876;
})();
var state_81859__$1 = state_81859;
var ex81873 = (state_81859__$1[(2)]);
var statearr_81877_81900 = state_81859__$1;
(statearr_81877_81900[(5)] = ex81873);


if((ex81873 instanceof Error)){
var statearr_81878_81901 = state_81859__$1;
(statearr_81878_81901[(1)] = (4));

(statearr_81878_81901[(5)] = null);

} else {
throw ex81873;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81860 === (14))){
var state_81859__$1 = state_81859;
var statearr_81879_81902 = state_81859__$1;
(statearr_81879_81902[(2)] = key);

(statearr_81879_81902[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81860 === (16))){
var inst_81837 = (state_81859[(2)]);
var inst_81838 = fluree.db.util.async.throw_err(inst_81837);
var state_81859__$1 = state_81859;
var statearr_81880_81903 = state_81859__$1;
(statearr_81880_81903[(2)] = inst_81838);

(statearr_81880_81903[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81860 === (10))){
var inst_81827 = (state_81859[(9)]);
var inst_81830 = cljs.core.vec(inst_81827);
var state_81859__$1 = state_81859;
var statearr_81881_81904 = state_81859__$1;
(statearr_81881_81904[(2)] = inst_81830);

(statearr_81881_81904[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81860 === (8))){
var inst_81827 = (state_81859[(9)]);
var inst_81827__$1 = (state_81859[(2)]);
var inst_81828 = cljs.core.set_QMARK_(inst_81827__$1);
var state_81859__$1 = (function (){var statearr_81882 = state_81859;
(statearr_81882[(9)] = inst_81827__$1);

return statearr_81882;
})();
if(inst_81828){
var statearr_81883_81905 = state_81859__$1;
(statearr_81883_81905[(1)] = (10));

} else {
var statearr_81884_81906 = state_81859__$1;
(statearr_81884_81906[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__20477__auto____0 = (function (){
var statearr_81885 = [null,null,null,null,null,null,null,null,null,null];
(statearr_81885[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__20477__auto__);

(statearr_81885[(1)] = (1));

return statearr_81885;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__20477__auto____1 = (function (state_81859){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_81859);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e81886){var ex__20480__auto__ = e81886;
var statearr_81887_81907 = state_81859;
(statearr_81887_81907[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_81859[(4)]))){
var statearr_81888_81908 = state_81859;
(statearr_81888_81908[(1)] = cljs.core.first((state_81859[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__81909 = state_81859;
state_81859 = G__81909;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__20477__auto__ = function(state_81859){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__20477__auto____1.call(this,state_81859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_81889 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_81889[(6)] = c__20603__auto__);

return statearr_81889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_81970){
var state_val_81971 = (state_81970[(1)]);
if((state_val_81971 === (7))){
var state_81970__$1 = state_81970;
var statearr_81972_82006 = state_81970__$1;
(statearr_81972_82006[(2)] = test);

(statearr_81972_82006[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (20))){
var inst_81944 = (state_81970[(2)]);
var inst_81945 = fluree.db.util.async.throw_err(inst_81944);
var state_81970__$1 = state_81970;
var statearr_81973_82007 = state_81970__$1;
(statearr_81973_82007[(2)] = inst_81945);

(statearr_81973_82007[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (1))){
var state_81970__$1 = state_81970;
var statearr_81974_82008 = state_81970__$1;
(statearr_81974_82008[(2)] = null);

(statearr_81974_82008[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (4))){
var inst_81910 = (state_81970[(2)]);
var state_81970__$1 = state_81970;
var statearr_81975_82009 = state_81970__$1;
(statearr_81975_82009[(2)] = inst_81910);

(statearr_81975_82009[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (15))){
var inst_81928 = (state_81970[(7)]);
var inst_81936 = (state_81970[(2)]);
var inst_81937 = [inst_81936,f];
var inst_81938 = (new cljs.core.PersistentVector(null,2,(5),inst_81928,inst_81937,null));
var state_81970__$1 = state_81970;
var statearr_81976_82010 = state_81970__$1;
(statearr_81976_82010[(2)] = inst_81938);

(statearr_81976_82010[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (13))){
var state_81970__$1 = state_81970;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81970__$1,(16),t);
} else {
if((state_val_81971 === (6))){
var state_81970__$1 = state_81970;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81970__$1,(9),test);
} else {
if((state_val_81971 === (17))){
var state_81970__$1 = state_81970;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81970__$1,(20),f);
} else {
if((state_val_81971 === (3))){
var inst_81968 = (state_81970[(2)]);
var state_81970__$1 = state_81970;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81970__$1,inst_81968);
} else {
if((state_val_81971 === (12))){
var inst_81926 = (state_81970[(8)]);
var inst_81952 = (state_81970[(2)]);
var inst_81953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81952,(0),null);
var inst_81954 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81952,(1),null);
var inst_81955 = fluree.db.dbfunctions.internal.if_else(inst_81926,inst_81953,inst_81954);
var inst_81956 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81957 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81959 = [inst_81926,inst_81953,inst_81954];
var inst_81960 = (new cljs.core.PersistentVector(null,3,(5),inst_81958,inst_81959,null));
var inst_81961 = ["if-else",inst_81960,inst_81955];
var inst_81962 = cljs.core.PersistentHashMap.fromArrays(inst_81957,inst_81961);
var inst_81963 = [inst_81962,(10)];
var inst_81964 = (new cljs.core.PersistentVector(null,2,(5),inst_81956,inst_81963,null));
var inst_81965 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81964);
var _ = (function (){var statearr_81977 = state_81970;
(statearr_81977[(4)] = cljs.core.rest((state_81970[(4)])));

return statearr_81977;
})();
var state_81970__$1 = (function (){var statearr_81978 = state_81970;
(statearr_81978[(9)] = inst_81965);

return statearr_81978;
})();
var statearr_81979_82011 = state_81970__$1;
(statearr_81979_82011[(2)] = inst_81955);

(statearr_81979_82011[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (2))){
var _ = (function (){var statearr_81980 = state_81970;
(statearr_81980[(4)] = cljs.core.cons((5),(state_81970[(4)])));

return statearr_81980;
})();
var inst_81919 = fluree.db.util.async.channel_QMARK_(test);
var state_81970__$1 = state_81970;
if(inst_81919){
var statearr_81981_82012 = state_81970__$1;
(statearr_81981_82012[(1)] = (6));

} else {
var statearr_81982_82013 = state_81970__$1;
(statearr_81982_82013[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (19))){
var inst_81940 = (state_81970[(10)]);
var inst_81948 = (state_81970[(2)]);
var inst_81949 = [f,inst_81948];
var inst_81950 = (new cljs.core.PersistentVector(null,2,(5),inst_81940,inst_81949,null));
var state_81970__$1 = state_81970;
var statearr_81983_82014 = state_81970__$1;
(statearr_81983_82014[(2)] = inst_81950);

(statearr_81983_82014[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (11))){
var inst_81940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81941 = fluree.db.util.async.channel_QMARK_(f);
var state_81970__$1 = (function (){var statearr_81985 = state_81970;
(statearr_81985[(10)] = inst_81940);

return statearr_81985;
})();
if(inst_81941){
var statearr_81986_82015 = state_81970__$1;
(statearr_81986_82015[(1)] = (17));

} else {
var statearr_81987_82016 = state_81970__$1;
(statearr_81987_82016[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (9))){
var inst_81922 = (state_81970[(2)]);
var inst_81923 = fluree.db.util.async.throw_err(inst_81922);
var state_81970__$1 = state_81970;
var statearr_81988_82017 = state_81970__$1;
(statearr_81988_82017[(2)] = inst_81923);

(statearr_81988_82017[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (5))){
var _ = (function (){var statearr_81989 = state_81970;
(statearr_81989[(4)] = cljs.core.rest((state_81970[(4)])));

return statearr_81989;
})();
var state_81970__$1 = state_81970;
var ex81984 = (state_81970__$1[(2)]);
var statearr_81990_82018 = state_81970__$1;
(statearr_81990_82018[(5)] = ex81984);


if((ex81984 instanceof Error)){
var statearr_81991_82019 = state_81970__$1;
(statearr_81991_82019[(1)] = (4));

(statearr_81991_82019[(5)] = null);

} else {
throw ex81984;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (14))){
var state_81970__$1 = state_81970;
var statearr_81992_82020 = state_81970__$1;
(statearr_81992_82020[(2)] = t);

(statearr_81992_82020[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (16))){
var inst_81932 = (state_81970[(2)]);
var inst_81933 = fluree.db.util.async.throw_err(inst_81932);
var state_81970__$1 = state_81970;
var statearr_81993_82021 = state_81970__$1;
(statearr_81993_82021[(2)] = inst_81933);

(statearr_81993_82021[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (10))){
var inst_81928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81929 = fluree.db.util.async.channel_QMARK_(t);
var state_81970__$1 = (function (){var statearr_81994 = state_81970;
(statearr_81994[(7)] = inst_81928);

return statearr_81994;
})();
if(inst_81929){
var statearr_81995_82022 = state_81970__$1;
(statearr_81995_82022[(1)] = (13));

} else {
var statearr_81996_82023 = state_81970__$1;
(statearr_81996_82023[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (18))){
var state_81970__$1 = state_81970;
var statearr_81997_82024 = state_81970__$1;
(statearr_81997_82024[(2)] = f);

(statearr_81997_82024[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81971 === (8))){
var inst_81926 = (state_81970[(8)]);
var inst_81926__$1 = (state_81970[(2)]);
var state_81970__$1 = (function (){var statearr_81998 = state_81970;
(statearr_81998[(8)] = inst_81926__$1);

return statearr_81998;
})();
if(cljs.core.truth_(inst_81926__$1)){
var statearr_81999_82025 = state_81970__$1;
(statearr_81999_82025[(1)] = (10));

} else {
var statearr_82000_82026 = state_81970__$1;
(statearr_82000_82026[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__20477__auto____0 = (function (){
var statearr_82001 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_82001[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__20477__auto__);

(statearr_82001[(1)] = (1));

return statearr_82001;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__20477__auto____1 = (function (state_81970){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_81970);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82002){var ex__20480__auto__ = e82002;
var statearr_82003_82027 = state_81970;
(statearr_82003_82027[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_81970[(4)]))){
var statearr_82004_82028 = state_81970;
(statearr_82004_82028[(1)] = cljs.core.first((state_81970[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82029 = state_81970;
state_81970 = G__82029;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__20477__auto__ = function(state_81970){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__20477__auto____1.call(this,state_81970);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82005 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82005[(6)] = c__20603__auto__);

return statearr_82005;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82059){
var state_val_82060 = (state_82059[(1)]);
if((state_val_82060 === (7))){
var state_82059__$1 = state_82059;
var statearr_82061_82080 = state_82059__$1;
(statearr_82061_82080[(2)] = arg);

(statearr_82061_82080[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82060 === (1))){
var state_82059__$1 = state_82059;
var statearr_82062_82081 = state_82059__$1;
(statearr_82062_82081[(2)] = null);

(statearr_82062_82081[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82060 === (4))){
var inst_82030 = (state_82059[(2)]);
var state_82059__$1 = state_82059;
var statearr_82063_82082 = state_82059__$1;
(statearr_82063_82082[(2)] = inst_82030);

(statearr_82063_82082[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82060 === (6))){
var state_82059__$1 = state_82059;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82059__$1,(9),arg);
} else {
if((state_val_82060 === (3))){
var inst_82057 = (state_82059[(2)]);
var state_82059__$1 = state_82059;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82059__$1,inst_82057);
} else {
if((state_val_82060 === (2))){
var _ = (function (){var statearr_82065 = state_82059;
(statearr_82065[(4)] = cljs.core.cons((5),(state_82059[(4)])));

return statearr_82065;
})();
var inst_82036 = fluree.db.util.async.channel_QMARK_(arg);
var state_82059__$1 = state_82059;
if(inst_82036){
var statearr_82066_82083 = state_82059__$1;
(statearr_82066_82083[(1)] = (6));

} else {
var statearr_82067_82084 = state_82059__$1;
(statearr_82067_82084[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82060 === (9))){
var inst_82039 = (state_82059[(2)]);
var inst_82040 = fluree.db.util.async.throw_err(inst_82039);
var state_82059__$1 = state_82059;
var statearr_82068_82085 = state_82059__$1;
(statearr_82068_82085[(2)] = inst_82040);

(statearr_82068_82085[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82060 === (5))){
var _ = (function (){var statearr_82069 = state_82059;
(statearr_82069[(4)] = cljs.core.rest((state_82059[(4)])));

return statearr_82069;
})();
var state_82059__$1 = state_82059;
var ex82064 = (state_82059__$1[(2)]);
var statearr_82070_82086 = state_82059__$1;
(statearr_82070_82086[(5)] = ex82064);


if((ex82064 instanceof Error)){
var statearr_82071_82087 = state_82059__$1;
(statearr_82071_82087[(1)] = (4));

(statearr_82071_82087[(5)] = null);

} else {
throw ex82064;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82060 === (8))){
var inst_82043 = (state_82059[(2)]);
var inst_82044 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_82043);
var inst_82045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82046 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82047 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82048 = [inst_82043];
var inst_82049 = (new cljs.core.PersistentVector(null,1,(5),inst_82047,inst_82048,null));
var inst_82050 = ["nil?",inst_82049,inst_82044];
var inst_82051 = cljs.core.PersistentHashMap.fromArrays(inst_82046,inst_82050);
var inst_82052 = [inst_82051,(10)];
var inst_82053 = (new cljs.core.PersistentVector(null,2,(5),inst_82045,inst_82052,null));
var inst_82054 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82053);
var _ = (function (){var statearr_82072 = state_82059;
(statearr_82072[(4)] = cljs.core.rest((state_82059[(4)])));

return statearr_82072;
})();
var state_82059__$1 = (function (){var statearr_82073 = state_82059;
(statearr_82073[(7)] = inst_82054);

return statearr_82073;
})();
var statearr_82074_82088 = state_82059__$1;
(statearr_82074_82088[(2)] = inst_82044);

(statearr_82074_82088[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__20477__auto____0 = (function (){
var statearr_82075 = [null,null,null,null,null,null,null,null];
(statearr_82075[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__20477__auto__);

(statearr_82075[(1)] = (1));

return statearr_82075;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__20477__auto____1 = (function (state_82059){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82059);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82076){var ex__20480__auto__ = e82076;
var statearr_82077_82089 = state_82059;
(statearr_82077_82089[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82059[(4)]))){
var statearr_82078_82090 = state_82059;
(statearr_82078_82090[(1)] = cljs.core.first((state_82059[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82091 = state_82059;
state_82059 = G__82091;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__20477__auto__ = function(state_82059){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__20477__auto____1.call(this,state_82059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82079 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82079[(6)] = c__20603__auto__);

return statearr_82079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82121){
var state_val_82122 = (state_82121[(1)]);
if((state_val_82122 === (7))){
var state_82121__$1 = state_82121;
var statearr_82123_82142 = state_82121__$1;
(statearr_82123_82142[(2)] = arg);

(statearr_82123_82142[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82122 === (1))){
var state_82121__$1 = state_82121;
var statearr_82124_82143 = state_82121__$1;
(statearr_82124_82143[(2)] = null);

(statearr_82124_82143[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82122 === (4))){
var inst_82092 = (state_82121[(2)]);
var state_82121__$1 = state_82121;
var statearr_82125_82144 = state_82121__$1;
(statearr_82125_82144[(2)] = inst_82092);

(statearr_82125_82144[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82122 === (6))){
var state_82121__$1 = state_82121;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82121__$1,(9),arg);
} else {
if((state_val_82122 === (3))){
var inst_82119 = (state_82121[(2)]);
var state_82121__$1 = state_82121;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82121__$1,inst_82119);
} else {
if((state_val_82122 === (2))){
var _ = (function (){var statearr_82127 = state_82121;
(statearr_82127[(4)] = cljs.core.cons((5),(state_82121[(4)])));

return statearr_82127;
})();
var inst_82098 = fluree.db.util.async.channel_QMARK_(arg);
var state_82121__$1 = state_82121;
if(inst_82098){
var statearr_82128_82145 = state_82121__$1;
(statearr_82128_82145[(1)] = (6));

} else {
var statearr_82129_82146 = state_82121__$1;
(statearr_82129_82146[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82122 === (9))){
var inst_82101 = (state_82121[(2)]);
var inst_82102 = fluree.db.util.async.throw_err(inst_82101);
var state_82121__$1 = state_82121;
var statearr_82130_82147 = state_82121__$1;
(statearr_82130_82147[(2)] = inst_82102);

(statearr_82130_82147[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82122 === (5))){
var _ = (function (){var statearr_82131 = state_82121;
(statearr_82131[(4)] = cljs.core.rest((state_82121[(4)])));

return statearr_82131;
})();
var state_82121__$1 = state_82121;
var ex82126 = (state_82121__$1[(2)]);
var statearr_82132_82148 = state_82121__$1;
(statearr_82132_82148[(5)] = ex82126);


if((ex82126 instanceof Error)){
var statearr_82133_82149 = state_82121__$1;
(statearr_82133_82149[(1)] = (4));

(statearr_82133_82149[(5)] = null);

} else {
throw ex82126;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82122 === (8))){
var inst_82105 = (state_82121[(2)]);
var inst_82106 = fluree.db.dbfunctions.internal.not(inst_82105);
var inst_82107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82108 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82110 = [inst_82105];
var inst_82111 = (new cljs.core.PersistentVector(null,1,(5),inst_82109,inst_82110,null));
var inst_82112 = ["not?",inst_82111,inst_82106];
var inst_82113 = cljs.core.PersistentHashMap.fromArrays(inst_82108,inst_82112);
var inst_82114 = [inst_82113,(10)];
var inst_82115 = (new cljs.core.PersistentVector(null,2,(5),inst_82107,inst_82114,null));
var inst_82116 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82115);
var _ = (function (){var statearr_82134 = state_82121;
(statearr_82134[(4)] = cljs.core.rest((state_82121[(4)])));

return statearr_82134;
})();
var state_82121__$1 = (function (){var statearr_82135 = state_82121;
(statearr_82135[(7)] = inst_82116);

return statearr_82135;
})();
var statearr_82136_82150 = state_82121__$1;
(statearr_82136_82150[(2)] = inst_82106);

(statearr_82136_82150[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__20477__auto____0 = (function (){
var statearr_82137 = [null,null,null,null,null,null,null,null];
(statearr_82137[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__20477__auto__);

(statearr_82137[(1)] = (1));

return statearr_82137;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__20477__auto____1 = (function (state_82121){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82121);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82138){var ex__20480__auto__ = e82138;
var statearr_82139_82151 = state_82121;
(statearr_82139_82151[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82121[(4)]))){
var statearr_82140_82152 = state_82121;
(statearr_82140_82152[(1)] = cljs.core.first((state_82121[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82153 = state_82121;
state_82121 = G__82153;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__20477__auto__ = function(state_82121){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__20477__auto____1.call(this,state_82121);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82141 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82141[(6)] = c__20603__auto__);

return statearr_82141;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82183){
var state_val_82184 = (state_82183[(1)]);
if((state_val_82184 === (7))){
var state_82183__$1 = state_82183;
var statearr_82185_82204 = state_82183__$1;
(statearr_82185_82204[(2)] = arg);

(statearr_82185_82204[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82184 === (1))){
var state_82183__$1 = state_82183;
var statearr_82186_82205 = state_82183__$1;
(statearr_82186_82205[(2)] = null);

(statearr_82186_82205[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82184 === (4))){
var inst_82154 = (state_82183[(2)]);
var state_82183__$1 = state_82183;
var statearr_82187_82206 = state_82183__$1;
(statearr_82187_82206[(2)] = inst_82154);

(statearr_82187_82206[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82184 === (6))){
var state_82183__$1 = state_82183;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82183__$1,(9),arg);
} else {
if((state_val_82184 === (3))){
var inst_82181 = (state_82183[(2)]);
var state_82183__$1 = state_82183;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82183__$1,inst_82181);
} else {
if((state_val_82184 === (2))){
var _ = (function (){var statearr_82189 = state_82183;
(statearr_82189[(4)] = cljs.core.cons((5),(state_82183[(4)])));

return statearr_82189;
})();
var inst_82160 = fluree.db.util.async.channel_QMARK_(arg);
var state_82183__$1 = state_82183;
if(inst_82160){
var statearr_82190_82207 = state_82183__$1;
(statearr_82190_82207[(1)] = (6));

} else {
var statearr_82191_82208 = state_82183__$1;
(statearr_82191_82208[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82184 === (9))){
var inst_82163 = (state_82183[(2)]);
var inst_82164 = fluree.db.util.async.throw_err(inst_82163);
var state_82183__$1 = state_82183;
var statearr_82192_82209 = state_82183__$1;
(statearr_82192_82209[(2)] = inst_82164);

(statearr_82192_82209[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82184 === (5))){
var _ = (function (){var statearr_82193 = state_82183;
(statearr_82193[(4)] = cljs.core.rest((state_82183[(4)])));

return statearr_82193;
})();
var state_82183__$1 = state_82183;
var ex82188 = (state_82183__$1[(2)]);
var statearr_82194_82210 = state_82183__$1;
(statearr_82194_82210[(5)] = ex82188);


if((ex82188 instanceof Error)){
var statearr_82195_82211 = state_82183__$1;
(statearr_82195_82211[(1)] = (4));

(statearr_82195_82211[(5)] = null);

} else {
throw ex82188;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82184 === (8))){
var inst_82167 = (state_82183[(2)]);
var inst_82168 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_82167);
var inst_82169 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82170 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82172 = [inst_82167];
var inst_82173 = (new cljs.core.PersistentVector(null,1,(5),inst_82171,inst_82172,null));
var inst_82174 = ["empty?",inst_82173,inst_82168];
var inst_82175 = cljs.core.PersistentHashMap.fromArrays(inst_82170,inst_82174);
var inst_82176 = [inst_82175,(10)];
var inst_82177 = (new cljs.core.PersistentVector(null,2,(5),inst_82169,inst_82176,null));
var inst_82178 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82177);
var _ = (function (){var statearr_82196 = state_82183;
(statearr_82196[(4)] = cljs.core.rest((state_82183[(4)])));

return statearr_82196;
})();
var state_82183__$1 = (function (){var statearr_82197 = state_82183;
(statearr_82197[(7)] = inst_82178);

return statearr_82197;
})();
var statearr_82198_82212 = state_82183__$1;
(statearr_82198_82212[(2)] = inst_82168);

(statearr_82198_82212[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__20477__auto____0 = (function (){
var statearr_82199 = [null,null,null,null,null,null,null,null];
(statearr_82199[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__20477__auto__);

(statearr_82199[(1)] = (1));

return statearr_82199;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__20477__auto____1 = (function (state_82183){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82183);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82200){var ex__20480__auto__ = e82200;
var statearr_82201_82213 = state_82183;
(statearr_82201_82213[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82183[(4)]))){
var statearr_82202_82214 = state_82183;
(statearr_82202_82214[(1)] = cljs.core.first((state_82183[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82215 = state_82183;
state_82183 = G__82215;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__20477__auto__ = function(state_82183){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__20477__auto____1.call(this,state_82183);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82203 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82203[(6)] = c__20603__auto__);

return statearr_82203;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4835__auto__ = [];
var len__4829__auto___82260 = arguments.length;
var i__4830__auto___82261 = (0);
while(true){
if((i__4830__auto___82261 < len__4829__auto___82260)){
args__4835__auto__.push((arguments[i__4830__auto___82261]));

var G__82262 = (i__4830__auto___82261 + (1));
i__4830__auto___82261 = G__82262;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82243){
var state_val_82244 = (state_82243[(1)]);
if((state_val_82244 === (1))){
var state_82243__$1 = state_82243;
var statearr_82245_82263 = state_82243__$1;
(statearr_82245_82263[(2)] = null);

(statearr_82245_82263[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82244 === (2))){
var _ = (function (){var statearr_82246 = state_82243;
(statearr_82246[(4)] = cljs.core.cons((5),(state_82243[(4)])));

return statearr_82246;
})();
var inst_82224 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_82243__$1 = state_82243;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82243__$1,(6),inst_82224);
} else {
if((state_val_82244 === (3))){
var inst_82241 = (state_82243[(2)]);
var state_82243__$1 = state_82243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82243__$1,inst_82241);
} else {
if((state_val_82244 === (4))){
var inst_82218 = (state_82243[(2)]);
var state_82243__$1 = state_82243;
var statearr_82248_82264 = state_82243__$1;
(statearr_82248_82264[(2)] = inst_82218);

(statearr_82248_82264[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82244 === (5))){
var _ = (function (){var statearr_82249 = state_82243;
(statearr_82249[(4)] = cljs.core.rest((state_82243[(4)])));

return statearr_82249;
})();
var state_82243__$1 = state_82243;
var ex82247 = (state_82243__$1[(2)]);
var statearr_82250_82265 = state_82243__$1;
(statearr_82250_82265[(5)] = ex82247);


if((ex82247 instanceof Error)){
var statearr_82251_82266 = state_82243__$1;
(statearr_82251_82266[(1)] = (4));

(statearr_82251_82266[(5)] = null);

} else {
throw ex82247;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82244 === (6))){
var inst_82226 = (state_82243[(2)]);
var inst_82227 = fluree.db.util.async.throw_err(inst_82226);
var inst_82228 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_82227);
var inst_82229 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82230 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82231 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82232 = [inst_82227];
var inst_82233 = (new cljs.core.PersistentVector(null,1,(5),inst_82231,inst_82232,null));
var inst_82234 = ["str",inst_82233,inst_82228];
var inst_82235 = cljs.core.PersistentHashMap.fromArrays(inst_82230,inst_82234);
var inst_82236 = [inst_82235,(10)];
var inst_82237 = (new cljs.core.PersistentVector(null,2,(5),inst_82229,inst_82236,null));
var inst_82238 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82237);
var _ = (function (){var statearr_82252 = state_82243;
(statearr_82252[(4)] = cljs.core.rest((state_82243[(4)])));

return statearr_82252;
})();
var state_82243__$1 = (function (){var statearr_82253 = state_82243;
(statearr_82253[(7)] = inst_82238);

return statearr_82253;
})();
var statearr_82254_82267 = state_82243__$1;
(statearr_82254_82267[(2)] = inst_82228);

(statearr_82254_82267[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_82255 = [null,null,null,null,null,null,null,null];
(statearr_82255[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_82255[(1)] = (1));

return statearr_82255;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_82243){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82243);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82256){var ex__20480__auto__ = e82256;
var statearr_82257_82268 = state_82243;
(statearr_82257_82268[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82243[(4)]))){
var statearr_82258_82269 = state_82243;
(statearr_82258_82269[(1)] = cljs.core.first((state_82243[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82270 = state_82243;
state_82243 = G__82270;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_82243){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_82243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82259 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82259[(6)] = c__20603__auto__);

return statearr_82259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq82216){
var G__82217 = cljs.core.first(seq82216);
var seq82216__$1 = cljs.core.next(seq82216);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82217,seq82216__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82296){
var state_val_82297 = (state_82296[(1)]);
if((state_val_82297 === (1))){
var state_82296__$1 = state_82296;
var statearr_82298_82313 = state_82296__$1;
(statearr_82298_82313[(2)] = null);

(statearr_82298_82313[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82297 === (2))){
var _ = (function (){var statearr_82299 = state_82296;
(statearr_82299[(4)] = cljs.core.cons((5),(state_82296[(4)])));

return statearr_82299;
})();
var inst_82277 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_82296__$1 = state_82296;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82296__$1,(6),inst_82277);
} else {
if((state_val_82297 === (3))){
var inst_82294 = (state_82296[(2)]);
var state_82296__$1 = state_82296;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82296__$1,inst_82294);
} else {
if((state_val_82297 === (4))){
var inst_82271 = (state_82296[(2)]);
var state_82296__$1 = state_82296;
var statearr_82301_82314 = state_82296__$1;
(statearr_82301_82314[(2)] = inst_82271);

(statearr_82301_82314[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82297 === (5))){
var _ = (function (){var statearr_82302 = state_82296;
(statearr_82302[(4)] = cljs.core.rest((state_82296[(4)])));

return statearr_82302;
})();
var state_82296__$1 = state_82296;
var ex82300 = (state_82296__$1[(2)]);
var statearr_82303_82315 = state_82296__$1;
(statearr_82303_82315[(5)] = ex82300);


if((ex82300 instanceof Error)){
var statearr_82304_82316 = state_82296__$1;
(statearr_82304_82316[(1)] = (4));

(statearr_82304_82316[(5)] = null);

} else {
throw ex82300;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82297 === (6))){
var inst_82279 = (state_82296[(2)]);
var inst_82280 = fluree.db.util.async.throw_err(inst_82279);
var inst_82281 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_82280);
var inst_82282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82283 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82285 = [inst_82280];
var inst_82286 = (new cljs.core.PersistentVector(null,1,(5),inst_82284,inst_82285,null));
var inst_82287 = ["subs",inst_82286,inst_82281];
var inst_82288 = cljs.core.PersistentHashMap.fromArrays(inst_82283,inst_82287);
var inst_82289 = [inst_82288,(30)];
var inst_82290 = (new cljs.core.PersistentVector(null,2,(5),inst_82282,inst_82289,null));
var inst_82291 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82290);
var _ = (function (){var statearr_82305 = state_82296;
(statearr_82305[(4)] = cljs.core.rest((state_82296[(4)])));

return statearr_82305;
})();
var state_82296__$1 = (function (){var statearr_82306 = state_82296;
(statearr_82306[(7)] = inst_82291);

return statearr_82306;
})();
var statearr_82307_82317 = state_82296__$1;
(statearr_82307_82317[(2)] = inst_82281);

(statearr_82307_82317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__20477__auto____0 = (function (){
var statearr_82308 = [null,null,null,null,null,null,null,null];
(statearr_82308[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__20477__auto__);

(statearr_82308[(1)] = (1));

return statearr_82308;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__20477__auto____1 = (function (state_82296){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82296);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82309){var ex__20480__auto__ = e82309;
var statearr_82310_82318 = state_82296;
(statearr_82310_82318[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82296[(4)]))){
var statearr_82311_82319 = state_82296;
(statearr_82311_82319[(1)] = cljs.core.first((state_82296[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82320 = state_82296;
state_82296 = G__82320;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__20477__auto__ = function(state_82296){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__20477__auto____1.call(this,state_82296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82312 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82312[(6)] = c__20603__auto__);

return statearr_82312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82350){
var state_val_82351 = (state_82350[(1)]);
if((state_val_82351 === (7))){
var state_82350__$1 = state_82350;
var statearr_82352_82371 = state_82350__$1;
(statearr_82352_82371[(2)] = str);

(statearr_82352_82371[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82351 === (1))){
var state_82350__$1 = state_82350;
var statearr_82353_82372 = state_82350__$1;
(statearr_82353_82372[(2)] = null);

(statearr_82353_82372[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82351 === (4))){
var inst_82321 = (state_82350[(2)]);
var state_82350__$1 = state_82350;
var statearr_82354_82373 = state_82350__$1;
(statearr_82354_82373[(2)] = inst_82321);

(statearr_82354_82373[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82351 === (6))){
var state_82350__$1 = state_82350;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82350__$1,(9),str);
} else {
if((state_val_82351 === (3))){
var inst_82348 = (state_82350[(2)]);
var state_82350__$1 = state_82350;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82350__$1,inst_82348);
} else {
if((state_val_82351 === (2))){
var _ = (function (){var statearr_82356 = state_82350;
(statearr_82356[(4)] = cljs.core.cons((5),(state_82350[(4)])));

return statearr_82356;
})();
var inst_82327 = fluree.db.util.async.channel_QMARK_(str);
var state_82350__$1 = state_82350;
if(inst_82327){
var statearr_82357_82374 = state_82350__$1;
(statearr_82357_82374[(1)] = (6));

} else {
var statearr_82358_82375 = state_82350__$1;
(statearr_82358_82375[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82351 === (9))){
var inst_82330 = (state_82350[(2)]);
var inst_82331 = fluree.db.util.async.throw_err(inst_82330);
var state_82350__$1 = state_82350;
var statearr_82359_82376 = state_82350__$1;
(statearr_82359_82376[(2)] = inst_82331);

(statearr_82359_82376[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82351 === (5))){
var _ = (function (){var statearr_82360 = state_82350;
(statearr_82360[(4)] = cljs.core.rest((state_82350[(4)])));

return statearr_82360;
})();
var state_82350__$1 = state_82350;
var ex82355 = (state_82350__$1[(2)]);
var statearr_82361_82377 = state_82350__$1;
(statearr_82361_82377[(5)] = ex82355);


if((ex82355 instanceof Error)){
var statearr_82362_82378 = state_82350__$1;
(statearr_82362_82378[(1)] = (4));

(statearr_82362_82378[(5)] = null);

} else {
throw ex82355;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82351 === (8))){
var inst_82334 = (state_82350[(2)]);
var inst_82335 = fluree.db.dbfunctions.internal.lower_case(inst_82334);
var inst_82336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82337 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82338 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82339 = [inst_82334];
var inst_82340 = (new cljs.core.PersistentVector(null,1,(5),inst_82338,inst_82339,null));
var inst_82341 = ["lower-case",inst_82340,inst_82335];
var inst_82342 = cljs.core.PersistentHashMap.fromArrays(inst_82337,inst_82341);
var inst_82343 = [inst_82342,(10)];
var inst_82344 = (new cljs.core.PersistentVector(null,2,(5),inst_82336,inst_82343,null));
var inst_82345 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82344);
var _ = (function (){var statearr_82363 = state_82350;
(statearr_82363[(4)] = cljs.core.rest((state_82350[(4)])));

return statearr_82363;
})();
var state_82350__$1 = (function (){var statearr_82364 = state_82350;
(statearr_82364[(7)] = inst_82345);

return statearr_82364;
})();
var statearr_82365_82379 = state_82350__$1;
(statearr_82365_82379[(2)] = inst_82335);

(statearr_82365_82379[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__20477__auto____0 = (function (){
var statearr_82366 = [null,null,null,null,null,null,null,null];
(statearr_82366[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__20477__auto__);

(statearr_82366[(1)] = (1));

return statearr_82366;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__20477__auto____1 = (function (state_82350){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82350);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82367){var ex__20480__auto__ = e82367;
var statearr_82368_82380 = state_82350;
(statearr_82368_82380[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82350[(4)]))){
var statearr_82369_82381 = state_82350;
(statearr_82369_82381[(1)] = cljs.core.first((state_82350[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82382 = state_82350;
state_82350 = G__82382;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__20477__auto__ = function(state_82350){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__20477__auto____1.call(this,state_82350);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82370 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82370[(6)] = c__20603__auto__);

return statearr_82370;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82412){
var state_val_82413 = (state_82412[(1)]);
if((state_val_82413 === (7))){
var state_82412__$1 = state_82412;
var statearr_82414_82433 = state_82412__$1;
(statearr_82414_82433[(2)] = str);

(statearr_82414_82433[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82413 === (1))){
var state_82412__$1 = state_82412;
var statearr_82415_82434 = state_82412__$1;
(statearr_82415_82434[(2)] = null);

(statearr_82415_82434[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82413 === (4))){
var inst_82383 = (state_82412[(2)]);
var state_82412__$1 = state_82412;
var statearr_82416_82435 = state_82412__$1;
(statearr_82416_82435[(2)] = inst_82383);

(statearr_82416_82435[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82413 === (6))){
var state_82412__$1 = state_82412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82412__$1,(9),str);
} else {
if((state_val_82413 === (3))){
var inst_82410 = (state_82412[(2)]);
var state_82412__$1 = state_82412;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82412__$1,inst_82410);
} else {
if((state_val_82413 === (2))){
var _ = (function (){var statearr_82418 = state_82412;
(statearr_82418[(4)] = cljs.core.cons((5),(state_82412[(4)])));

return statearr_82418;
})();
var inst_82389 = fluree.db.util.async.channel_QMARK_(str);
var state_82412__$1 = state_82412;
if(inst_82389){
var statearr_82419_82436 = state_82412__$1;
(statearr_82419_82436[(1)] = (6));

} else {
var statearr_82420_82437 = state_82412__$1;
(statearr_82420_82437[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82413 === (9))){
var inst_82392 = (state_82412[(2)]);
var inst_82393 = fluree.db.util.async.throw_err(inst_82392);
var state_82412__$1 = state_82412;
var statearr_82421_82438 = state_82412__$1;
(statearr_82421_82438[(2)] = inst_82393);

(statearr_82421_82438[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82413 === (5))){
var _ = (function (){var statearr_82422 = state_82412;
(statearr_82422[(4)] = cljs.core.rest((state_82412[(4)])));

return statearr_82422;
})();
var state_82412__$1 = state_82412;
var ex82417 = (state_82412__$1[(2)]);
var statearr_82423_82439 = state_82412__$1;
(statearr_82423_82439[(5)] = ex82417);


if((ex82417 instanceof Error)){
var statearr_82424_82440 = state_82412__$1;
(statearr_82424_82440[(1)] = (4));

(statearr_82424_82440[(5)] = null);

} else {
throw ex82417;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82413 === (8))){
var inst_82396 = (state_82412[(2)]);
var inst_82397 = fluree.db.dbfunctions.internal.upper_case(inst_82396);
var inst_82398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82399 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82400 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82401 = [inst_82396];
var inst_82402 = (new cljs.core.PersistentVector(null,1,(5),inst_82400,inst_82401,null));
var inst_82403 = ["upper-case",inst_82402,inst_82397];
var inst_82404 = cljs.core.PersistentHashMap.fromArrays(inst_82399,inst_82403);
var inst_82405 = [inst_82404,(10)];
var inst_82406 = (new cljs.core.PersistentVector(null,2,(5),inst_82398,inst_82405,null));
var inst_82407 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82406);
var _ = (function (){var statearr_82425 = state_82412;
(statearr_82425[(4)] = cljs.core.rest((state_82412[(4)])));

return statearr_82425;
})();
var state_82412__$1 = (function (){var statearr_82426 = state_82412;
(statearr_82426[(7)] = inst_82407);

return statearr_82426;
})();
var statearr_82427_82441 = state_82412__$1;
(statearr_82427_82441[(2)] = inst_82397);

(statearr_82427_82441[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__20477__auto____0 = (function (){
var statearr_82428 = [null,null,null,null,null,null,null,null];
(statearr_82428[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__20477__auto__);

(statearr_82428[(1)] = (1));

return statearr_82428;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__20477__auto____1 = (function (state_82412){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82412);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82429){var ex__20480__auto__ = e82429;
var statearr_82430_82442 = state_82412;
(statearr_82430_82442[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82412[(4)]))){
var statearr_82431_82443 = state_82412;
(statearr_82431_82443[(1)] = cljs.core.first((state_82412[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82444 = state_82412;
state_82412 = G__82444;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__20477__auto__ = function(state_82412){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__20477__auto____1.call(this,state_82412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82432 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82432[(6)] = c__20603__auto__);

return statearr_82432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4221__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4221__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__82446 = arguments.length;
switch (G__82446) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82474){
var state_val_82475 = (state_82474[(1)]);
if((state_val_82475 === (1))){
var state_82474__$1 = state_82474;
var statearr_82476_82492 = state_82474__$1;
(statearr_82476_82492[(2)] = null);

(statearr_82476_82492[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82475 === (2))){
var _ = (function (){var statearr_82477 = state_82474;
(statearr_82477[(4)] = cljs.core.cons((5),(state_82474[(4)])));

return statearr_82477;
})();
var inst_82456 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_82474__$1 = state_82474;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82474__$1,(6),inst_82456);
} else {
if((state_val_82475 === (3))){
var inst_82472 = (state_82474[(2)]);
var state_82474__$1 = state_82474;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82474__$1,inst_82472);
} else {
if((state_val_82475 === (4))){
var inst_82447 = (state_82474[(2)]);
var state_82474__$1 = state_82474;
var statearr_82479_82493 = state_82474__$1;
(statearr_82479_82493[(2)] = inst_82447);

(statearr_82479_82493[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82475 === (5))){
var _ = (function (){var statearr_82480 = state_82474;
(statearr_82480[(4)] = cljs.core.rest((state_82474[(4)])));

return statearr_82480;
})();
var state_82474__$1 = state_82474;
var ex82478 = (state_82474__$1[(2)]);
var statearr_82481_82494 = state_82474__$1;
(statearr_82481_82494[(5)] = ex82478);


if((ex82478 instanceof Error)){
var statearr_82482_82495 = state_82474__$1;
(statearr_82482_82495[(1)] = (4));

(statearr_82482_82495[(5)] = null);

} else {
throw ex82478;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82475 === (6))){
var inst_82458 = (state_82474[(2)]);
var inst_82459 = fluree.db.util.async.throw_err(inst_82458);
var inst_82460 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_82459,(0),null);
var inst_82461 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_82459,(1),null);
var inst_82462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82463 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82464 = ["?s","?ctx",inst_82460];
var inst_82465 = cljs.core.PersistentHashMap.fromArrays(inst_82463,inst_82464);
var inst_82466 = ((10) + inst_82461);
var inst_82467 = [inst_82465,inst_82466];
var inst_82468 = (new cljs.core.PersistentVector(null,2,(5),inst_82462,inst_82467,null));
var inst_82469 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82468);
var _ = (function (){var statearr_82483 = state_82474;
(statearr_82483[(4)] = cljs.core.rest((state_82474[(4)])));

return statearr_82483;
})();
var state_82474__$1 = (function (){var statearr_82484 = state_82474;
(statearr_82484[(7)] = inst_82469);

return statearr_82484;
})();
var statearr_82485_82496 = state_82474__$1;
(statearr_82485_82496[(2)] = inst_82460);

(statearr_82485_82496[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_82486 = [null,null,null,null,null,null,null,null];
(statearr_82486[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_82486[(1)] = (1));

return statearr_82486;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_82474){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82474);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82487){var ex__20480__auto__ = e82487;
var statearr_82488_82497 = state_82474;
(statearr_82488_82497[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82474[(4)]))){
var statearr_82489_82498 = state_82474;
(statearr_82489_82498[(1)] = cljs.core.first((state_82474[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82499 = state_82474;
state_82474 = G__82499;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_82474){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_82474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82490 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82490[(6)] = c__20603__auto__);

return statearr_82490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__82501 = arguments.length;
switch (G__82501) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82539){
var state_val_82540 = (state_82539[(1)]);
if((state_val_82540 === (7))){
var inst_82532 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_82539__$1 = state_82539;
var statearr_82541_82561 = state_82539__$1;
(statearr_82541_82561[(2)] = inst_82532);

(statearr_82541_82561[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82540 === (1))){
var state_82539__$1 = state_82539;
var statearr_82542_82562 = state_82539__$1;
(statearr_82542_82562[(2)] = null);

(statearr_82542_82562[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82540 === (4))){
var inst_82502 = (state_82539[(2)]);
var state_82539__$1 = state_82539;
var statearr_82543_82563 = state_82539__$1;
(statearr_82543_82563[(2)] = inst_82502);

(statearr_82543_82563[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82540 === (6))){
var inst_82513 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_82539__$1 = state_82539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82539__$1,(10),inst_82513);
} else {
if((state_val_82540 === (3))){
var inst_82537 = (state_82539[(2)]);
var state_82539__$1 = state_82539;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82539__$1,inst_82537);
} else {
if((state_val_82540 === (2))){
var _ = (function (){var statearr_82545 = state_82539;
(statearr_82545[(4)] = cljs.core.cons((5),(state_82539[(4)])));

return statearr_82545;
})();
var inst_82508 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_82539__$1 = state_82539;
if(cljs.core.truth_(inst_82508)){
var statearr_82546_82564 = state_82539__$1;
(statearr_82546_82564[(1)] = (6));

} else {
var statearr_82547_82565 = state_82539__$1;
(statearr_82547_82565[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82540 === (9))){
var inst_82519 = (state_82539[(2)]);
var inst_82520 = fluree.db.util.async.throw_err(inst_82519);
var inst_82521 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_82520,(0),null);
var inst_82522 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_82520,(1),null);
var inst_82523 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82524 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82525 = ["?p","?ctx",inst_82521];
var inst_82526 = cljs.core.PersistentHashMap.fromArrays(inst_82524,inst_82525);
var inst_82527 = ((10) + inst_82522);
var inst_82528 = [inst_82526,inst_82527];
var inst_82529 = (new cljs.core.PersistentVector(null,2,(5),inst_82523,inst_82528,null));
var inst_82530 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82529);
var state_82539__$1 = (function (){var statearr_82548 = state_82539;
(statearr_82548[(7)] = inst_82530);

return statearr_82548;
})();
var statearr_82549_82566 = state_82539__$1;
(statearr_82549_82566[(2)] = inst_82521);

(statearr_82549_82566[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82540 === (5))){
var _ = (function (){var statearr_82550 = state_82539;
(statearr_82550[(4)] = cljs.core.rest((state_82539[(4)])));

return statearr_82550;
})();
var state_82539__$1 = state_82539;
var ex82544 = (state_82539__$1[(2)]);
var statearr_82551_82567 = state_82539__$1;
(statearr_82551_82567[(5)] = ex82544);


if((ex82544 instanceof Error)){
var statearr_82552_82568 = state_82539__$1;
(statearr_82552_82568[(1)] = (4));

(statearr_82552_82568[(5)] = null);

} else {
throw ex82544;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82540 === (10))){
var inst_82515 = (state_82539[(2)]);
var inst_82516 = fluree.db.util.async.throw_err(inst_82515);
var inst_82517 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_82516);
var state_82539__$1 = state_82539;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82539__$1,(9),inst_82517);
} else {
if((state_val_82540 === (8))){
var inst_82534 = (state_82539[(2)]);
var _ = (function (){var statearr_82553 = state_82539;
(statearr_82553[(4)] = cljs.core.rest((state_82539[(4)])));

return statearr_82553;
})();
var state_82539__$1 = state_82539;
var statearr_82554_82569 = state_82539__$1;
(statearr_82554_82569[(2)] = inst_82534);

(statearr_82554_82569[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_82555 = [null,null,null,null,null,null,null,null];
(statearr_82555[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_82555[(1)] = (1));

return statearr_82555;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_82539){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82539);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82556){var ex__20480__auto__ = e82556;
var statearr_82557_82570 = state_82539;
(statearr_82557_82570[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82539[(4)]))){
var statearr_82558_82571 = state_82539;
(statearr_82558_82571[(1)] = cljs.core.first((state_82539[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82572 = state_82539;
state_82539 = G__82572;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_82539){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_82539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82559 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82559[(6)] = c__20603__auto__);

return statearr_82559;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4835__auto__ = [];
var len__4829__auto___82621 = arguments.length;
var i__4830__auto___82622 = (0);
while(true){
if((i__4830__auto___82622 < len__4829__auto___82621)){
args__4835__auto__.push((arguments[i__4830__auto___82622]));

var G__82623 = (i__4830__auto___82622 + (1));
i__4830__auto___82622 = G__82623;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82604){
var state_val_82605 = (state_82604[(1)]);
if((state_val_82605 === (1))){
var state_82604__$1 = state_82604;
var statearr_82606_82624 = state_82604__$1;
(statearr_82606_82624[(2)] = null);

(statearr_82606_82624[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82605 === (2))){
var _ = (function (){var statearr_82607 = state_82604;
(statearr_82607[(4)] = cljs.core.cons((5),(state_82604[(4)])));

return statearr_82607;
})();
var inst_82581 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_82604__$1 = state_82604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82604__$1,(6),inst_82581);
} else {
if((state_val_82605 === (3))){
var inst_82602 = (state_82604[(2)]);
var state_82604__$1 = state_82604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82604__$1,inst_82602);
} else {
if((state_val_82605 === (4))){
var inst_82575 = (state_82604[(2)]);
var state_82604__$1 = state_82604;
var statearr_82609_82625 = state_82604__$1;
(statearr_82609_82625[(2)] = inst_82575);

(statearr_82609_82625[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82605 === (5))){
var _ = (function (){var statearr_82610 = state_82604;
(statearr_82610[(4)] = cljs.core.rest((state_82604[(4)])));

return statearr_82610;
})();
var state_82604__$1 = state_82604;
var ex82608 = (state_82604__$1[(2)]);
var statearr_82611_82626 = state_82604__$1;
(statearr_82611_82626[(5)] = ex82608);


if((ex82608 instanceof Error)){
var statearr_82612_82627 = state_82604__$1;
(statearr_82612_82627[(1)] = (4));

(statearr_82612_82627[(5)] = null);

} else {
throw ex82608;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82605 === (6))){
var inst_82583 = (state_82604[(2)]);
var inst_82584 = fluree.db.util.async.throw_err(inst_82583);
var inst_82585 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_82584);
var inst_82586 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82587 = [inst_82584];
var inst_82588 = (new cljs.core.PersistentVector(null,1,(5),inst_82586,inst_82587,null));
var inst_82589 = cljs.core.count(inst_82588);
var inst_82590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82591 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82593 = [inst_82584];
var inst_82594 = (new cljs.core.PersistentVector(null,1,(5),inst_82592,inst_82593,null));
var inst_82595 = ["and",inst_82594,inst_82585];
var inst_82596 = cljs.core.PersistentHashMap.fromArrays(inst_82591,inst_82595);
var inst_82597 = [inst_82596,inst_82589];
var inst_82598 = (new cljs.core.PersistentVector(null,2,(5),inst_82590,inst_82597,null));
var inst_82599 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82598);
var _ = (function (){var statearr_82613 = state_82604;
(statearr_82613[(4)] = cljs.core.rest((state_82604[(4)])));

return statearr_82613;
})();
var state_82604__$1 = (function (){var statearr_82614 = state_82604;
(statearr_82614[(7)] = inst_82599);

return statearr_82614;
})();
var statearr_82615_82628 = state_82604__$1;
(statearr_82615_82628[(2)] = inst_82585);

(statearr_82615_82628[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_82616 = [null,null,null,null,null,null,null,null];
(statearr_82616[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_82616[(1)] = (1));

return statearr_82616;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_82604){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82604);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82617){var ex__20480__auto__ = e82617;
var statearr_82618_82629 = state_82604;
(statearr_82618_82629[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82604[(4)]))){
var statearr_82619_82630 = state_82604;
(statearr_82619_82630[(1)] = cljs.core.first((state_82604[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82631 = state_82604;
state_82604 = G__82631;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_82604){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_82604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82620 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82620[(6)] = c__20603__auto__);

return statearr_82620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq82573){
var G__82574 = cljs.core.first(seq82573);
var seq82573__$1 = cljs.core.next(seq82573);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82574,seq82573__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4835__auto__ = [];
var len__4829__auto___82680 = arguments.length;
var i__4830__auto___82681 = (0);
while(true){
if((i__4830__auto___82681 < len__4829__auto___82680)){
args__4835__auto__.push((arguments[i__4830__auto___82681]));

var G__82682 = (i__4830__auto___82681 + (1));
i__4830__auto___82681 = G__82682;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82663){
var state_val_82664 = (state_82663[(1)]);
if((state_val_82664 === (1))){
var state_82663__$1 = state_82663;
var statearr_82665_82683 = state_82663__$1;
(statearr_82665_82683[(2)] = null);

(statearr_82665_82683[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82664 === (2))){
var _ = (function (){var statearr_82666 = state_82663;
(statearr_82666[(4)] = cljs.core.cons((5),(state_82663[(4)])));

return statearr_82666;
})();
var inst_82640 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_82663__$1 = state_82663;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82663__$1,(6),inst_82640);
} else {
if((state_val_82664 === (3))){
var inst_82661 = (state_82663[(2)]);
var state_82663__$1 = state_82663;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82663__$1,inst_82661);
} else {
if((state_val_82664 === (4))){
var inst_82634 = (state_82663[(2)]);
var state_82663__$1 = state_82663;
var statearr_82668_82684 = state_82663__$1;
(statearr_82668_82684[(2)] = inst_82634);

(statearr_82668_82684[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82664 === (5))){
var _ = (function (){var statearr_82669 = state_82663;
(statearr_82669[(4)] = cljs.core.rest((state_82663[(4)])));

return statearr_82669;
})();
var state_82663__$1 = state_82663;
var ex82667 = (state_82663__$1[(2)]);
var statearr_82670_82685 = state_82663__$1;
(statearr_82670_82685[(5)] = ex82667);


if((ex82667 instanceof Error)){
var statearr_82671_82686 = state_82663__$1;
(statearr_82671_82686[(1)] = (4));

(statearr_82671_82686[(5)] = null);

} else {
throw ex82667;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82664 === (6))){
var inst_82642 = (state_82663[(2)]);
var inst_82643 = fluree.db.util.async.throw_err(inst_82642);
var inst_82644 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_82643);
var inst_82645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82646 = [inst_82643];
var inst_82647 = (new cljs.core.PersistentVector(null,1,(5),inst_82645,inst_82646,null));
var inst_82648 = cljs.core.count(inst_82647);
var inst_82649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82650 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82652 = [inst_82643];
var inst_82653 = (new cljs.core.PersistentVector(null,1,(5),inst_82651,inst_82652,null));
var inst_82654 = ["or",inst_82653,inst_82644];
var inst_82655 = cljs.core.PersistentHashMap.fromArrays(inst_82650,inst_82654);
var inst_82656 = [inst_82655,inst_82648];
var inst_82657 = (new cljs.core.PersistentVector(null,2,(5),inst_82649,inst_82656,null));
var inst_82658 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82657);
var _ = (function (){var statearr_82672 = state_82663;
(statearr_82672[(4)] = cljs.core.rest((state_82663[(4)])));

return statearr_82672;
})();
var state_82663__$1 = (function (){var statearr_82673 = state_82663;
(statearr_82673[(7)] = inst_82658);

return statearr_82673;
})();
var statearr_82674_82687 = state_82663__$1;
(statearr_82674_82687[(2)] = inst_82644);

(statearr_82674_82687[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_82675 = [null,null,null,null,null,null,null,null];
(statearr_82675[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_82675[(1)] = (1));

return statearr_82675;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_82663){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82663);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82676){var ex__20480__auto__ = e82676;
var statearr_82677_82688 = state_82663;
(statearr_82677_82688[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82663[(4)]))){
var statearr_82678_82689 = state_82663;
(statearr_82678_82689[(1)] = cljs.core.first((state_82663[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82690 = state_82663;
state_82663 = G__82690;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_82663){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_82663);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82679 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82679[(6)] = c__20603__auto__);

return statearr_82679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq82632){
var G__82633 = cljs.core.first(seq82632);
var seq82632__$1 = cljs.core.next(seq82632);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82633,seq82632__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82728){
var state_val_82729 = (state_82728[(1)]);
if((state_val_82729 === (7))){
var inst_82704 = fluree.db.util.async.channel_QMARK_(coll);
var state_82728__$1 = state_82728;
if(inst_82704){
var statearr_82730_82753 = state_82728__$1;
(statearr_82730_82753[(1)] = (10));

} else {
var statearr_82731_82754 = state_82728__$1;
(statearr_82731_82754[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82729 === (1))){
var state_82728__$1 = state_82728;
var statearr_82732_82755 = state_82728__$1;
(statearr_82732_82755[(2)] = null);

(statearr_82732_82755[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82729 === (4))){
var inst_82691 = (state_82728[(2)]);
var state_82728__$1 = state_82728;
var statearr_82733_82756 = state_82728__$1;
(statearr_82733_82756[(2)] = inst_82691);

(statearr_82733_82756[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82729 === (13))){
var inst_82707 = (state_82728[(2)]);
var inst_82708 = fluree.db.util.async.throw_err(inst_82707);
var state_82728__$1 = state_82728;
var statearr_82734_82757 = state_82728__$1;
(statearr_82734_82757[(2)] = inst_82708);

(statearr_82734_82757[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82729 === (6))){
var inst_82699 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_82728__$1 = state_82728;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82728__$1,(9),inst_82699);
} else {
if((state_val_82729 === (3))){
var inst_82726 = (state_82728[(2)]);
var state_82728__$1 = state_82728;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82728__$1,inst_82726);
} else {
if((state_val_82729 === (12))){
var inst_82711 = (state_82728[(2)]);
var state_82728__$1 = state_82728;
var statearr_82735_82758 = state_82728__$1;
(statearr_82735_82758[(2)] = inst_82711);

(statearr_82735_82758[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82729 === (2))){
var _ = (function (){var statearr_82736 = state_82728;
(statearr_82736[(4)] = cljs.core.cons((5),(state_82728[(4)])));

return statearr_82736;
})();
var inst_82697 = cljs.core.vector_QMARK_(coll);
var state_82728__$1 = state_82728;
if(inst_82697){
var statearr_82737_82759 = state_82728__$1;
(statearr_82737_82759[(1)] = (6));

} else {
var statearr_82738_82760 = state_82728__$1;
(statearr_82738_82760[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82729 === (11))){
var state_82728__$1 = state_82728;
var statearr_82740_82761 = state_82728__$1;
(statearr_82740_82761[(2)] = coll);

(statearr_82740_82761[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82729 === (9))){
var inst_82701 = (state_82728[(2)]);
var inst_82702 = fluree.db.util.async.throw_err(inst_82701);
var state_82728__$1 = state_82728;
var statearr_82741_82762 = state_82728__$1;
(statearr_82741_82762[(2)] = inst_82702);

(statearr_82741_82762[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82729 === (5))){
var _ = (function (){var statearr_82742 = state_82728;
(statearr_82742[(4)] = cljs.core.rest((state_82728[(4)])));

return statearr_82742;
})();
var state_82728__$1 = state_82728;
var ex82739 = (state_82728__$1[(2)]);
var statearr_82743_82763 = state_82728__$1;
(statearr_82743_82763[(5)] = ex82739);


if((ex82739 instanceof Error)){
var statearr_82744_82764 = state_82728__$1;
(statearr_82744_82764[(1)] = (4));

(statearr_82744_82764[(5)] = null);

} else {
throw ex82739;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82729 === (10))){
var state_82728__$1 = state_82728;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82728__$1,(13),coll);
} else {
if((state_val_82729 === (8))){
var inst_82713 = (state_82728[(2)]);
var inst_82714 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_82713);
var inst_82715 = cljs.core.count(inst_82714);
var inst_82716 = ((9) + inst_82715);
var inst_82717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82718 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82719 = ["count",inst_82713,inst_82715];
var inst_82720 = cljs.core.PersistentHashMap.fromArrays(inst_82718,inst_82719);
var inst_82721 = [inst_82720,inst_82716];
var inst_82722 = (new cljs.core.PersistentVector(null,2,(5),inst_82717,inst_82721,null));
var inst_82723 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82722);
var _ = (function (){var statearr_82745 = state_82728;
(statearr_82745[(4)] = cljs.core.rest((state_82728[(4)])));

return statearr_82745;
})();
var state_82728__$1 = (function (){var statearr_82746 = state_82728;
(statearr_82746[(7)] = inst_82723);

return statearr_82746;
})();
var statearr_82747_82765 = state_82728__$1;
(statearr_82747_82765[(2)] = inst_82715);

(statearr_82747_82765[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__20477__auto____0 = (function (){
var statearr_82748 = [null,null,null,null,null,null,null,null];
(statearr_82748[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__20477__auto__);

(statearr_82748[(1)] = (1));

return statearr_82748;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__20477__auto____1 = (function (state_82728){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82728);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82749){var ex__20480__auto__ = e82749;
var statearr_82750_82766 = state_82728;
(statearr_82750_82766[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82728[(4)]))){
var statearr_82751_82767 = state_82728;
(statearr_82751_82767[(1)] = cljs.core.first((state_82728[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82768 = state_82728;
state_82728 = G__82768;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__20477__auto__ = function(state_82728){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__20477__auto____1.call(this,state_82728);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82752 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82752[(6)] = c__20603__auto__);

return statearr_82752;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82818){
var state_val_82819 = (state_82818[(1)]);
if((state_val_82819 === (7))){
var state_82818__$1 = state_82818;
var statearr_82820_82853 = state_82818__$1;
(statearr_82820_82853[(2)] = subject);

(statearr_82820_82853[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (1))){
var state_82818__$1 = state_82818;
var statearr_82821_82854 = state_82818__$1;
(statearr_82821_82854[(2)] = null);

(statearr_82821_82854[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (4))){
var inst_82769 = (state_82818[(2)]);
var state_82818__$1 = state_82818;
var statearr_82822_82855 = state_82818__$1;
(statearr_82822_82855[(2)] = inst_82769);

(statearr_82822_82855[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (15))){
var inst_82782 = (state_82818[(7)]);
var state_82818__$1 = state_82818;
var statearr_82823_82856 = state_82818__$1;
(statearr_82823_82856[(2)] = inst_82782);

(statearr_82823_82856[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (13))){
var inst_82786 = (state_82818[(2)]);
var inst_82787 = fluree.db.util.async.throw_err(inst_82786);
var state_82818__$1 = state_82818;
var statearr_82824_82857 = state_82818__$1;
(statearr_82824_82857[(2)] = inst_82787);

(statearr_82824_82857[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (6))){
var state_82818__$1 = state_82818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82818__$1,(9),subject);
} else {
if((state_val_82819 === (17))){
var inst_82782 = (state_82818[(7)]);
var inst_82796 = cljs.core.first(inst_82782);
var state_82818__$1 = state_82818;
var statearr_82825_82858 = state_82818__$1;
(statearr_82825_82858[(2)] = inst_82796);

(statearr_82825_82858[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (3))){
var inst_82816 = (state_82818[(2)]);
var state_82818__$1 = state_82818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82818__$1,inst_82816);
} else {
if((state_val_82819 === (12))){
var inst_82782 = (state_82818[(7)]);
var inst_82790 = (state_82818[(2)]);
var inst_82791 = cljs.core.vector_QMARK_(inst_82782);
var state_82818__$1 = (function (){var statearr_82826 = state_82818;
(statearr_82826[(8)] = inst_82790);

return statearr_82826;
})();
if(inst_82791){
var statearr_82827_82859 = state_82818__$1;
(statearr_82827_82859[(1)] = (14));

} else {
var statearr_82828_82860 = state_82818__$1;
(statearr_82828_82860[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (2))){
var _ = (function (){var statearr_82829 = state_82818;
(statearr_82829[(4)] = cljs.core.cons((5),(state_82818[(4)])));

return statearr_82829;
})();
var inst_82775 = fluree.db.util.async.channel_QMARK_(subject);
var state_82818__$1 = state_82818;
if(inst_82775){
var statearr_82830_82861 = state_82818__$1;
(statearr_82830_82861[(1)] = (6));

} else {
var statearr_82831_82862 = state_82818__$1;
(statearr_82831_82862[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (19))){
var inst_82799 = (state_82818[(2)]);
var state_82818__$1 = state_82818;
var statearr_82832_82863 = state_82818__$1;
(statearr_82832_82863[(2)] = inst_82799);

(statearr_82832_82863[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (11))){
var state_82818__$1 = state_82818;
var statearr_82834_82864 = state_82818__$1;
(statearr_82834_82864[(2)] = pred);

(statearr_82834_82864[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (9))){
var inst_82778 = (state_82818[(2)]);
var inst_82779 = fluree.db.util.async.throw_err(inst_82778);
var state_82818__$1 = state_82818;
var statearr_82835_82865 = state_82818__$1;
(statearr_82835_82865[(2)] = inst_82779);

(statearr_82835_82865[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (5))){
var _ = (function (){var statearr_82836 = state_82818;
(statearr_82836[(4)] = cljs.core.rest((state_82818[(4)])));

return statearr_82836;
})();
var state_82818__$1 = state_82818;
var ex82833 = (state_82818__$1[(2)]);
var statearr_82837_82866 = state_82818__$1;
(statearr_82837_82866[(5)] = ex82833);


if((ex82833 instanceof Error)){
var statearr_82838_82867 = state_82818__$1;
(statearr_82838_82867[(1)] = (4));

(statearr_82838_82867[(5)] = null);

} else {
throw ex82833;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (14))){
var inst_82782 = (state_82818[(7)]);
var inst_82793 = cljs.core.count(inst_82782);
var inst_82794 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_82793);
var state_82818__$1 = state_82818;
if(inst_82794){
var statearr_82839_82868 = state_82818__$1;
(statearr_82839_82868[(1)] = (17));

} else {
var statearr_82840_82869 = state_82818__$1;
(statearr_82840_82869[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (16))){
var inst_82782 = (state_82818[(7)]);
var inst_82790 = (state_82818[(8)]);
var inst_82802 = (state_82818[(2)]);
var inst_82803 = fluree.db.dbfunctions.internal.get(inst_82802,inst_82790);
var inst_82804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82805 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82806 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82807 = [inst_82782,inst_82790];
var inst_82808 = (new cljs.core.PersistentVector(null,2,(5),inst_82806,inst_82807,null));
var inst_82809 = ["get",inst_82808,inst_82803];
var inst_82810 = cljs.core.PersistentHashMap.fromArrays(inst_82805,inst_82809);
var inst_82811 = [inst_82810,(10)];
var inst_82812 = (new cljs.core.PersistentVector(null,2,(5),inst_82804,inst_82811,null));
var inst_82813 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82812);
var _ = (function (){var statearr_82841 = state_82818;
(statearr_82841[(4)] = cljs.core.rest((state_82818[(4)])));

return statearr_82841;
})();
var state_82818__$1 = (function (){var statearr_82842 = state_82818;
(statearr_82842[(9)] = inst_82813);

return statearr_82842;
})();
var statearr_82843_82870 = state_82818__$1;
(statearr_82843_82870[(2)] = inst_82803);

(statearr_82843_82870[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (10))){
var state_82818__$1 = state_82818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82818__$1,(13),pred);
} else {
if((state_val_82819 === (18))){
var inst_82782 = (state_82818[(7)]);
var state_82818__$1 = state_82818;
var statearr_82844_82871 = state_82818__$1;
(statearr_82844_82871[(2)] = inst_82782);

(statearr_82844_82871[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82819 === (8))){
var inst_82782 = (state_82818[(2)]);
var inst_82783 = fluree.db.util.async.channel_QMARK_(pred);
var state_82818__$1 = (function (){var statearr_82845 = state_82818;
(statearr_82845[(7)] = inst_82782);

return statearr_82845;
})();
if(inst_82783){
var statearr_82846_82872 = state_82818__$1;
(statearr_82846_82872[(1)] = (10));

} else {
var statearr_82847_82873 = state_82818__$1;
(statearr_82847_82873[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__20477__auto____0 = (function (){
var statearr_82848 = [null,null,null,null,null,null,null,null,null,null];
(statearr_82848[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__20477__auto__);

(statearr_82848[(1)] = (1));

return statearr_82848;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__20477__auto____1 = (function (state_82818){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82818);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82849){var ex__20480__auto__ = e82849;
var statearr_82850_82874 = state_82818;
(statearr_82850_82874[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82818[(4)]))){
var statearr_82851_82875 = state_82818;
(statearr_82851_82875[(1)] = cljs.core.first((state_82818[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82876 = state_82818;
state_82818 = G__82876;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__20477__auto__ = function(state_82818){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__20477__auto____1.call(this,state_82818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82852 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82852[(6)] = c__20603__auto__);

return statearr_82852;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_82915){
var state_val_82916 = (state_82915[(1)]);
if((state_val_82916 === (7))){
var inst_82883 = (state_82915[(7)]);
var state_82915__$1 = state_82915;
var statearr_82917_82941 = state_82915__$1;
(statearr_82917_82941[(2)] = inst_82883);

(statearr_82917_82941[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82916 === (1))){
var state_82915__$1 = state_82915;
var statearr_82918_82942 = state_82915__$1;
(statearr_82918_82942[(2)] = null);

(statearr_82918_82942[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82916 === (4))){
var inst_82877 = (state_82915[(2)]);
var state_82915__$1 = state_82915;
var statearr_82919_82943 = state_82915__$1;
(statearr_82919_82943[(2)] = inst_82877);

(statearr_82919_82943[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82916 === (6))){
var inst_82885 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_82915__$1 = state_82915;
var statearr_82920_82944 = state_82915__$1;
(statearr_82920_82944[(2)] = inst_82885);

(statearr_82920_82944[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82916 === (3))){
var inst_82913 = (state_82915[(2)]);
var state_82915__$1 = state_82915;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82915__$1,inst_82913);
} else {
if((state_val_82916 === (12))){
var inst_82895 = (state_82915[(2)]);
var inst_82896 = fluree.db.util.async.throw_err(inst_82895);
var inst_82897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_82896,(0),null);
var inst_82898 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_82896,(1),null);
var inst_82899 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82900 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82901 = ["?pO","?ctx",inst_82897];
var inst_82902 = cljs.core.PersistentHashMap.fromArrays(inst_82900,inst_82901);
var inst_82903 = ((10) + inst_82898);
var inst_82904 = [inst_82902,inst_82903];
var inst_82905 = (new cljs.core.PersistentVector(null,2,(5),inst_82899,inst_82904,null));
var inst_82906 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82905);
var state_82915__$1 = (function (){var statearr_82921 = state_82915;
(statearr_82921[(8)] = inst_82906);

return statearr_82921;
})();
var statearr_82922_82945 = state_82915__$1;
(statearr_82922_82945[(2)] = inst_82897);

(statearr_82922_82945[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82916 === (2))){
var inst_82883 = (state_82915[(7)]);
var _ = (function (){var statearr_82923 = state_82915;
(statearr_82923[(4)] = cljs.core.cons((5),(state_82915[(4)])));

return statearr_82923;
})();
var inst_82883__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_82915__$1 = (function (){var statearr_82924 = state_82915;
(statearr_82924[(7)] = inst_82883__$1);

return statearr_82924;
})();
if(cljs.core.truth_(inst_82883__$1)){
var statearr_82925_82946 = state_82915__$1;
(statearr_82925_82946[(1)] = (6));

} else {
var statearr_82926_82947 = state_82915__$1;
(statearr_82926_82947[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82916 === (11))){
var inst_82910 = (state_82915[(2)]);
var _ = (function (){var statearr_82928 = state_82915;
(statearr_82928[(4)] = cljs.core.rest((state_82915[(4)])));

return statearr_82928;
})();
var state_82915__$1 = state_82915;
var statearr_82929_82948 = state_82915__$1;
(statearr_82929_82948[(2)] = inst_82910);

(statearr_82929_82948[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82916 === (9))){
var inst_82893 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_82915__$1 = state_82915;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82915__$1,(12),inst_82893);
} else {
if((state_val_82916 === (5))){
var _ = (function (){var statearr_82930 = state_82915;
(statearr_82930[(4)] = cljs.core.rest((state_82915[(4)])));

return statearr_82930;
})();
var state_82915__$1 = state_82915;
var ex82927 = (state_82915__$1[(2)]);
var statearr_82931_82949 = state_82915__$1;
(statearr_82931_82949[(5)] = ex82927);


if((ex82927 instanceof Error)){
var statearr_82932_82950 = state_82915__$1;
(statearr_82932_82950[(1)] = (4));

(statearr_82932_82950[(5)] = null);

} else {
throw ex82927;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82916 === (10))){
var inst_82908 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_82915__$1 = state_82915;
var statearr_82933_82951 = state_82915__$1;
(statearr_82933_82951[(2)] = inst_82908);

(statearr_82933_82951[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82916 === (8))){
var inst_82888 = (state_82915[(2)]);
var state_82915__$1 = state_82915;
if(cljs.core.truth_(inst_82888)){
var statearr_82934_82952 = state_82915__$1;
(statearr_82934_82952[(1)] = (9));

} else {
var statearr_82935_82953 = state_82915__$1;
(statearr_82935_82953[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__20477__auto____0 = (function (){
var statearr_82936 = [null,null,null,null,null,null,null,null,null];
(statearr_82936[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__20477__auto__);

(statearr_82936[(1)] = (1));

return statearr_82936;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__20477__auto____1 = (function (state_82915){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_82915);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e82937){var ex__20480__auto__ = e82937;
var statearr_82938_82954 = state_82915;
(statearr_82938_82954[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_82915[(4)]))){
var statearr_82939_82955 = state_82915;
(statearr_82939_82955[(1)] = cljs.core.first((state_82915[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__82956 = state_82915;
state_82915 = G__82956;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__20477__auto__ = function(state_82915){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__20477__auto____1.call(this,state_82915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_82940 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_82940[(6)] = c__20603__auto__);

return statearr_82940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83008){
var state_val_83009 = (state_83008[(1)]);
if((state_val_83009 === (7))){
var state_83008__$1 = state_83008;
var statearr_83010_83043 = state_83008__$1;
(statearr_83010_83043[(2)] = subject);

(statearr_83010_83043[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (1))){
var state_83008__$1 = state_83008;
var statearr_83011_83044 = state_83008__$1;
(statearr_83011_83044[(2)] = null);

(statearr_83011_83044[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (4))){
var inst_82957 = (state_83008[(2)]);
var state_83008__$1 = state_83008;
var statearr_83012_83045 = state_83008__$1;
(statearr_83012_83045[(2)] = inst_82957);

(statearr_83012_83045[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (15))){
var inst_82970 = (state_83008[(7)]);
var state_83008__$1 = state_83008;
var statearr_83013_83046 = state_83008__$1;
(statearr_83013_83046[(2)] = inst_82970);

(statearr_83013_83046[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (13))){
var inst_82974 = (state_83008[(2)]);
var inst_82975 = fluree.db.util.async.throw_err(inst_82974);
var state_83008__$1 = state_83008;
var statearr_83014_83047 = state_83008__$1;
(statearr_83014_83047[(2)] = inst_82975);

(statearr_83014_83047[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (6))){
var state_83008__$1 = state_83008;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83008__$1,(9),subject);
} else {
if((state_val_83009 === (17))){
var inst_82970 = (state_83008[(7)]);
var inst_82984 = cljs.core.first(inst_82970);
var state_83008__$1 = state_83008;
var statearr_83015_83048 = state_83008__$1;
(statearr_83015_83048[(2)] = inst_82984);

(statearr_83015_83048[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (3))){
var inst_83006 = (state_83008[(2)]);
var state_83008__$1 = state_83008;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83008__$1,inst_83006);
} else {
if((state_val_83009 === (12))){
var inst_82970 = (state_83008[(7)]);
var inst_82978 = (state_83008[(2)]);
var inst_82979 = cljs.core.vector_QMARK_(inst_82970);
var state_83008__$1 = (function (){var statearr_83016 = state_83008;
(statearr_83016[(8)] = inst_82978);

return statearr_83016;
})();
if(inst_82979){
var statearr_83017_83049 = state_83008__$1;
(statearr_83017_83049[(1)] = (14));

} else {
var statearr_83018_83050 = state_83008__$1;
(statearr_83018_83050[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (2))){
var _ = (function (){var statearr_83019 = state_83008;
(statearr_83019[(4)] = cljs.core.cons((5),(state_83008[(4)])));

return statearr_83019;
})();
var inst_82963 = fluree.db.util.async.channel_QMARK_(subject);
var state_83008__$1 = state_83008;
if(inst_82963){
var statearr_83020_83051 = state_83008__$1;
(statearr_83020_83051[(1)] = (6));

} else {
var statearr_83021_83052 = state_83008__$1;
(statearr_83021_83052[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (19))){
var inst_82987 = (state_83008[(2)]);
var state_83008__$1 = state_83008;
var statearr_83022_83053 = state_83008__$1;
(statearr_83022_83053[(2)] = inst_82987);

(statearr_83022_83053[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (11))){
var state_83008__$1 = state_83008;
var statearr_83024_83054 = state_83008__$1;
(statearr_83024_83054[(2)] = path);

(statearr_83024_83054[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (9))){
var inst_82966 = (state_83008[(2)]);
var inst_82967 = fluree.db.util.async.throw_err(inst_82966);
var state_83008__$1 = state_83008;
var statearr_83025_83055 = state_83008__$1;
(statearr_83025_83055[(2)] = inst_82967);

(statearr_83025_83055[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (5))){
var _ = (function (){var statearr_83026 = state_83008;
(statearr_83026[(4)] = cljs.core.rest((state_83008[(4)])));

return statearr_83026;
})();
var state_83008__$1 = state_83008;
var ex83023 = (state_83008__$1[(2)]);
var statearr_83027_83056 = state_83008__$1;
(statearr_83027_83056[(5)] = ex83023);


if((ex83023 instanceof Error)){
var statearr_83028_83057 = state_83008__$1;
(statearr_83028_83057[(1)] = (4));

(statearr_83028_83057[(5)] = null);

} else {
throw ex83023;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (14))){
var inst_82970 = (state_83008[(7)]);
var inst_82981 = cljs.core.count(inst_82970);
var inst_82982 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_82981);
var state_83008__$1 = state_83008;
if(inst_82982){
var statearr_83029_83058 = state_83008__$1;
(statearr_83029_83058[(1)] = (17));

} else {
var statearr_83030_83059 = state_83008__$1;
(statearr_83030_83059[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (16))){
var inst_82970 = (state_83008[(7)]);
var inst_82978 = (state_83008[(8)]);
var inst_82990 = (state_83008[(2)]);
var inst_82991 = fluree.db.dbfunctions.internal.get_all(inst_82990,inst_82978);
var inst_82992 = cljs.core.count(inst_82978);
var inst_82993 = ((9) + inst_82992);
var inst_82994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82995 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82997 = [inst_82970,inst_82978];
var inst_82998 = (new cljs.core.PersistentVector(null,2,(5),inst_82996,inst_82997,null));
var inst_82999 = ["get-all",inst_82998,inst_82991];
var inst_83000 = cljs.core.PersistentHashMap.fromArrays(inst_82995,inst_82999);
var inst_83001 = [inst_83000,inst_82993];
var inst_83002 = (new cljs.core.PersistentVector(null,2,(5),inst_82994,inst_83001,null));
var inst_83003 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83002);
var _ = (function (){var statearr_83031 = state_83008;
(statearr_83031[(4)] = cljs.core.rest((state_83008[(4)])));

return statearr_83031;
})();
var state_83008__$1 = (function (){var statearr_83032 = state_83008;
(statearr_83032[(9)] = inst_83003);

return statearr_83032;
})();
var statearr_83033_83060 = state_83008__$1;
(statearr_83033_83060[(2)] = inst_82991);

(statearr_83033_83060[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (10))){
var state_83008__$1 = state_83008;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83008__$1,(13),path);
} else {
if((state_val_83009 === (18))){
var inst_82970 = (state_83008[(7)]);
var state_83008__$1 = state_83008;
var statearr_83034_83061 = state_83008__$1;
(statearr_83034_83061[(2)] = inst_82970);

(statearr_83034_83061[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83009 === (8))){
var inst_82970 = (state_83008[(2)]);
var inst_82971 = fluree.db.util.async.channel_QMARK_(path);
var state_83008__$1 = (function (){var statearr_83035 = state_83008;
(statearr_83035[(7)] = inst_82970);

return statearr_83035;
})();
if(inst_82971){
var statearr_83036_83062 = state_83008__$1;
(statearr_83036_83062[(1)] = (10));

} else {
var statearr_83037_83063 = state_83008__$1;
(statearr_83037_83063[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__20477__auto____0 = (function (){
var statearr_83038 = [null,null,null,null,null,null,null,null,null,null];
(statearr_83038[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__20477__auto__);

(statearr_83038[(1)] = (1));

return statearr_83038;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__20477__auto____1 = (function (state_83008){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83008);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83039){var ex__20480__auto__ = e83039;
var statearr_83040_83064 = state_83008;
(statearr_83040_83064[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83008[(4)]))){
var statearr_83041_83065 = state_83008;
(statearr_83041_83065[(1)] = cljs.core.first((state_83008[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__83066 = state_83008;
state_83008 = G__83066;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__20477__auto__ = function(state_83008){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__20477__auto____1.call(this,state_83008);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83042 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83042[(6)] = c__20603__auto__);

return statearr_83042;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83105){
var state_val_83106 = (state_83105[(1)]);
if((state_val_83106 === (7))){
var state_83105__$1 = state_83105;
var statearr_83107_83131 = state_83105__$1;
(statearr_83107_83131[(2)] = subject);

(statearr_83107_83131[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83106 === (1))){
var state_83105__$1 = state_83105;
var statearr_83108_83132 = state_83105__$1;
(statearr_83108_83132[(2)] = null);

(statearr_83108_83132[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83106 === (4))){
var inst_83067 = (state_83105[(2)]);
var state_83105__$1 = state_83105;
var statearr_83109_83133 = state_83105__$1;
(statearr_83109_83133[(2)] = inst_83067);

(statearr_83109_83133[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83106 === (13))){
var inst_83084 = (state_83105[(2)]);
var inst_83085 = fluree.db.util.async.throw_err(inst_83084);
var state_83105__$1 = state_83105;
var statearr_83110_83134 = state_83105__$1;
(statearr_83110_83134[(2)] = inst_83085);

(statearr_83110_83134[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83106 === (6))){
var state_83105__$1 = state_83105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83105__$1,(9),subject);
} else {
if((state_val_83106 === (3))){
var inst_83103 = (state_83105[(2)]);
var state_83105__$1 = state_83105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83105__$1,inst_83103);
} else {
if((state_val_83106 === (12))){
var inst_83080 = (state_83105[(7)]);
var inst_83088 = (state_83105[(2)]);
var inst_83089 = fluree.db.dbfunctions.internal.get_in(inst_83080,inst_83088);
var inst_83090 = cljs.core.count(inst_83088);
var inst_83091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83092 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83094 = [inst_83080,inst_83088];
var inst_83095 = (new cljs.core.PersistentVector(null,2,(5),inst_83093,inst_83094,null));
var inst_83096 = ["get-in",inst_83095,inst_83089];
var inst_83097 = cljs.core.PersistentHashMap.fromArrays(inst_83092,inst_83096);
var inst_83098 = [inst_83097,inst_83090];
var inst_83099 = (new cljs.core.PersistentVector(null,2,(5),inst_83091,inst_83098,null));
var inst_83100 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83099);
var _ = (function (){var statearr_83111 = state_83105;
(statearr_83111[(4)] = cljs.core.rest((state_83105[(4)])));

return statearr_83111;
})();
var state_83105__$1 = (function (){var statearr_83112 = state_83105;
(statearr_83112[(8)] = inst_83100);

return statearr_83112;
})();
var statearr_83113_83135 = state_83105__$1;
(statearr_83113_83135[(2)] = inst_83089);

(statearr_83113_83135[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83106 === (2))){
var _ = (function (){var statearr_83114 = state_83105;
(statearr_83114[(4)] = cljs.core.cons((5),(state_83105[(4)])));

return statearr_83114;
})();
var inst_83073 = fluree.db.util.async.channel_QMARK_(subject);
var state_83105__$1 = state_83105;
if(inst_83073){
var statearr_83115_83136 = state_83105__$1;
(statearr_83115_83136[(1)] = (6));

} else {
var statearr_83116_83137 = state_83105__$1;
(statearr_83116_83137[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83106 === (11))){
var state_83105__$1 = state_83105;
var statearr_83118_83138 = state_83105__$1;
(statearr_83118_83138[(2)] = path);

(statearr_83118_83138[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83106 === (9))){
var inst_83076 = (state_83105[(2)]);
var inst_83077 = fluree.db.util.async.throw_err(inst_83076);
var state_83105__$1 = state_83105;
var statearr_83119_83139 = state_83105__$1;
(statearr_83119_83139[(2)] = inst_83077);

(statearr_83119_83139[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83106 === (5))){
var _ = (function (){var statearr_83120 = state_83105;
(statearr_83120[(4)] = cljs.core.rest((state_83105[(4)])));

return statearr_83120;
})();
var state_83105__$1 = state_83105;
var ex83117 = (state_83105__$1[(2)]);
var statearr_83121_83140 = state_83105__$1;
(statearr_83121_83140[(5)] = ex83117);


if((ex83117 instanceof Error)){
var statearr_83122_83141 = state_83105__$1;
(statearr_83122_83141[(1)] = (4));

(statearr_83122_83141[(5)] = null);

} else {
throw ex83117;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83106 === (10))){
var state_83105__$1 = state_83105;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83105__$1,(13),path);
} else {
if((state_val_83106 === (8))){
var inst_83080 = (state_83105[(2)]);
var inst_83081 = fluree.db.util.async.channel_QMARK_(path);
var state_83105__$1 = (function (){var statearr_83123 = state_83105;
(statearr_83123[(7)] = inst_83080);

return statearr_83123;
})();
if(inst_83081){
var statearr_83124_83142 = state_83105__$1;
(statearr_83124_83142[(1)] = (10));

} else {
var statearr_83125_83143 = state_83105__$1;
(statearr_83125_83143[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__20477__auto____0 = (function (){
var statearr_83126 = [null,null,null,null,null,null,null,null,null];
(statearr_83126[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__20477__auto__);

(statearr_83126[(1)] = (1));

return statearr_83126;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__20477__auto____1 = (function (state_83105){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83105);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83127){var ex__20480__auto__ = e83127;
var statearr_83128_83144 = state_83105;
(statearr_83128_83144[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83105[(4)]))){
var statearr_83129_83145 = state_83105;
(statearr_83129_83145[(1)] = cljs.core.first((state_83105[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__83146 = state_83105;
state_83105 = G__83146;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__20477__auto__ = function(state_83105){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__20477__auto____1.call(this,state_83105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83130 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83130[(6)] = c__20603__auto__);

return statearr_83130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83191){
var state_val_83192 = (state_83191[(1)]);
if((state_val_83192 === (7))){
var state_83191__$1 = state_83191;
var statearr_83193_83222 = state_83191__$1;
(statearr_83193_83222[(2)] = coll);

(statearr_83193_83222[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83192 === (1))){
var state_83191__$1 = state_83191;
var statearr_83194_83223 = state_83191__$1;
(statearr_83194_83223[(2)] = null);

(statearr_83194_83223[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83192 === (4))){
var inst_83147 = (state_83191[(2)]);
var state_83191__$1 = state_83191;
var statearr_83195_83224 = state_83191__$1;
(statearr_83195_83224[(2)] = inst_83147);

(statearr_83195_83224[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83192 === (15))){
var inst_83167 = (state_83191[(7)]);
var inst_83175 = (state_83191[(2)]);
var inst_83176 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_83167,inst_83175);
var inst_83177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83178 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83180 = [inst_83167,inst_83175];
var inst_83181 = (new cljs.core.PersistentVector(null,2,(5),inst_83179,inst_83180,null));
var inst_83182 = ["contains?",inst_83181,inst_83176];
var inst_83183 = cljs.core.PersistentHashMap.fromArrays(inst_83178,inst_83182);
var inst_83184 = [inst_83183,(10)];
var inst_83185 = (new cljs.core.PersistentVector(null,2,(5),inst_83177,inst_83184,null));
var inst_83186 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83185);
var _ = (function (){var statearr_83196 = state_83191;
(statearr_83196[(4)] = cljs.core.rest((state_83191[(4)])));

return statearr_83196;
})();
var state_83191__$1 = (function (){var statearr_83197 = state_83191;
(statearr_83197[(8)] = inst_83186);

return statearr_83197;
})();
var statearr_83198_83225 = state_83191__$1;
(statearr_83198_83225[(2)] = inst_83176);

(statearr_83198_83225[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83192 === (13))){
var state_83191__$1 = state_83191;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83191__$1,(16),key);
} else {
if((state_val_83192 === (6))){
var state_83191__$1 = state_83191;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83191__$1,(9),coll);
} else {
if((state_val_83192 === (3))){
var inst_83189 = (state_83191[(2)]);
var state_83191__$1 = state_83191;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83191__$1,inst_83189);
} else {
if((state_val_83192 === (12))){
var inst_83167 = (state_83191[(2)]);
var inst_83168 = fluree.db.util.async.channel_QMARK_(key);
var state_83191__$1 = (function (){var statearr_83199 = state_83191;
(statearr_83199[(7)] = inst_83167);

return statearr_83199;
})();
if(inst_83168){
var statearr_83200_83226 = state_83191__$1;
(statearr_83200_83226[(1)] = (13));

} else {
var statearr_83201_83227 = state_83191__$1;
(statearr_83201_83227[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83192 === (2))){
var _ = (function (){var statearr_83202 = state_83191;
(statearr_83202[(4)] = cljs.core.cons((5),(state_83191[(4)])));

return statearr_83202;
})();
var inst_83153 = fluree.db.util.async.channel_QMARK_(coll);
var state_83191__$1 = state_83191;
if(inst_83153){
var statearr_83203_83228 = state_83191__$1;
(statearr_83203_83228[(1)] = (6));

} else {
var statearr_83204_83229 = state_83191__$1;
(statearr_83204_83229[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83192 === (11))){
var inst_83160 = (state_83191[(9)]);
var inst_83164 = cljs.core.flatten(inst_83160);
var inst_83165 = cljs.core.set(inst_83164);
var state_83191__$1 = state_83191;
var statearr_83206_83230 = state_83191__$1;
(statearr_83206_83230[(2)] = inst_83165);

(statearr_83206_83230[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83192 === (9))){
var inst_83156 = (state_83191[(2)]);
var inst_83157 = fluree.db.util.async.throw_err(inst_83156);
var state_83191__$1 = state_83191;
var statearr_83207_83231 = state_83191__$1;
(statearr_83207_83231[(2)] = inst_83157);

(statearr_83207_83231[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83192 === (5))){
var _ = (function (){var statearr_83208 = state_83191;
(statearr_83208[(4)] = cljs.core.rest((state_83191[(4)])));

return statearr_83208;
})();
var state_83191__$1 = state_83191;
var ex83205 = (state_83191__$1[(2)]);
var statearr_83209_83232 = state_83191__$1;
(statearr_83209_83232[(5)] = ex83205);


if((ex83205 instanceof Error)){
var statearr_83210_83233 = state_83191__$1;
(statearr_83210_83233[(1)] = (4));

(statearr_83210_83233[(5)] = null);

} else {
throw ex83205;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83192 === (14))){
var state_83191__$1 = state_83191;
var statearr_83211_83234 = state_83191__$1;
(statearr_83211_83234[(2)] = key);

(statearr_83211_83234[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83192 === (16))){
var inst_83171 = (state_83191[(2)]);
var inst_83172 = fluree.db.util.async.throw_err(inst_83171);
var state_83191__$1 = state_83191;
var statearr_83212_83235 = state_83191__$1;
(statearr_83212_83235[(2)] = inst_83172);

(statearr_83212_83235[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83192 === (10))){
var inst_83160 = (state_83191[(9)]);
var state_83191__$1 = state_83191;
var statearr_83213_83236 = state_83191__$1;
(statearr_83213_83236[(2)] = inst_83160);

(statearr_83213_83236[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83192 === (8))){
var inst_83160 = (state_83191[(9)]);
var inst_83160__$1 = (state_83191[(2)]);
var inst_83161 = cljs.core.set_QMARK_(inst_83160__$1);
var state_83191__$1 = (function (){var statearr_83214 = state_83191;
(statearr_83214[(9)] = inst_83160__$1);

return statearr_83214;
})();
if(inst_83161){
var statearr_83215_83237 = state_83191__$1;
(statearr_83215_83237[(1)] = (10));

} else {
var statearr_83216_83238 = state_83191__$1;
(statearr_83216_83238[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__20477__auto____0 = (function (){
var statearr_83217 = [null,null,null,null,null,null,null,null,null,null];
(statearr_83217[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__20477__auto__);

(statearr_83217[(1)] = (1));

return statearr_83217;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__20477__auto____1 = (function (state_83191){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83191);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83218){var ex__20480__auto__ = e83218;
var statearr_83219_83239 = state_83191;
(statearr_83219_83239[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83191[(4)]))){
var statearr_83220_83240 = state_83191;
(statearr_83220_83240[(1)] = cljs.core.first((state_83191[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__83241 = state_83191;
state_83191 = G__83241;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__20477__auto__ = function(state_83191){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__20477__auto____1.call(this,state_83191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83221 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83221[(6)] = c__20603__auto__);

return statearr_83221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4835__auto__ = [];
var len__4829__auto___83313 = arguments.length;
var i__4830__auto___83314 = (0);
while(true){
if((i__4830__auto___83314 < len__4829__auto___83313)){
args__4835__auto__.push((arguments[i__4830__auto___83314]));

var G__83315 = (i__4830__auto___83314 + (1));
i__4830__auto___83314 = G__83315;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83287){
var state_val_83288 = (state_83287[(1)]);
if((state_val_83288 === (7))){
var inst_83253 = (state_83287[(7)]);
var inst_83257 = cljs.core.first(inst_83253);
var inst_83258 = cljs.core.coll_QMARK_(inst_83257);
var state_83287__$1 = state_83287;
var statearr_83289_83316 = state_83287__$1;
(statearr_83289_83316[(2)] = inst_83258);

(statearr_83289_83316[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83288 === (1))){
var state_83287__$1 = state_83287;
var statearr_83290_83317 = state_83287__$1;
(statearr_83290_83317[(2)] = null);

(statearr_83290_83317[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83288 === (4))){
var inst_83244 = (state_83287[(2)]);
var state_83287__$1 = state_83287;
var statearr_83291_83318 = state_83287__$1;
(statearr_83291_83318[(2)] = inst_83244);

(statearr_83291_83318[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83288 === (6))){
var inst_83255 = (state_83287[(8)]);
var inst_83253 = (state_83287[(7)]);
var inst_83252 = (state_83287[(2)]);
var inst_83253__$1 = fluree.db.util.async.throw_err(inst_83252);
var inst_83254 = cljs.core.count(inst_83253__$1);
var inst_83255__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_83254);
var state_83287__$1 = (function (){var statearr_83292 = state_83287;
(statearr_83292[(8)] = inst_83255__$1);

(statearr_83292[(7)] = inst_83253__$1);

return statearr_83292;
})();
if(inst_83255__$1){
var statearr_83293_83319 = state_83287__$1;
(statearr_83293_83319[(1)] = (7));

} else {
var statearr_83294_83320 = state_83287__$1;
(statearr_83294_83320[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83288 === (3))){
var inst_83285 = (state_83287[(2)]);
var state_83287__$1 = state_83287;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83287__$1,inst_83285);
} else {
if((state_val_83288 === (12))){
var inst_83266 = (state_83287[(2)]);
var inst_83267 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_83266);
var inst_83268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83269 = [inst_83266];
var inst_83270 = (new cljs.core.PersistentVector(null,1,(5),inst_83268,inst_83269,null));
var inst_83271 = cljs.core.count(inst_83270);
var inst_83272 = ((9) + inst_83271);
var inst_83273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83274 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83275 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83276 = [inst_83266];
var inst_83277 = (new cljs.core.PersistentVector(null,1,(5),inst_83275,inst_83276,null));
var inst_83278 = ["hash-set",inst_83277,inst_83267];
var inst_83279 = cljs.core.PersistentHashMap.fromArrays(inst_83274,inst_83278);
var inst_83280 = [inst_83279,inst_83272];
var inst_83281 = (new cljs.core.PersistentVector(null,2,(5),inst_83273,inst_83280,null));
var inst_83282 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83281);
var _ = (function (){var statearr_83295 = state_83287;
(statearr_83295[(4)] = cljs.core.rest((state_83287[(4)])));

return statearr_83295;
})();
var state_83287__$1 = (function (){var statearr_83296 = state_83287;
(statearr_83296[(9)] = inst_83282);

return statearr_83296;
})();
var statearr_83297_83321 = state_83287__$1;
(statearr_83297_83321[(2)] = inst_83267);

(statearr_83297_83321[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83288 === (2))){
var _ = (function (){var statearr_83298 = state_83287;
(statearr_83298[(4)] = cljs.core.cons((5),(state_83287[(4)])));

return statearr_83298;
})();
var inst_83250 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_83287__$1 = state_83287;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83287__$1,(6),inst_83250);
} else {
if((state_val_83288 === (11))){
var inst_83253 = (state_83287[(7)]);
var state_83287__$1 = state_83287;
var statearr_83300_83322 = state_83287__$1;
(statearr_83300_83322[(2)] = inst_83253);

(statearr_83300_83322[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83288 === (9))){
var inst_83261 = (state_83287[(2)]);
var state_83287__$1 = state_83287;
if(cljs.core.truth_(inst_83261)){
var statearr_83301_83323 = state_83287__$1;
(statearr_83301_83323[(1)] = (10));

} else {
var statearr_83302_83324 = state_83287__$1;
(statearr_83302_83324[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83288 === (5))){
var _ = (function (){var statearr_83303 = state_83287;
(statearr_83303[(4)] = cljs.core.rest((state_83287[(4)])));

return statearr_83303;
})();
var state_83287__$1 = state_83287;
var ex83299 = (state_83287__$1[(2)]);
var statearr_83304_83325 = state_83287__$1;
(statearr_83304_83325[(5)] = ex83299);


if((ex83299 instanceof Error)){
var statearr_83305_83326 = state_83287__$1;
(statearr_83305_83326[(1)] = (4));

(statearr_83305_83326[(5)] = null);

} else {
throw ex83299;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83288 === (10))){
var inst_83253 = (state_83287[(7)]);
var inst_83263 = cljs.core.first(inst_83253);
var state_83287__$1 = state_83287;
var statearr_83306_83327 = state_83287__$1;
(statearr_83306_83327[(2)] = inst_83263);

(statearr_83306_83327[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83288 === (8))){
var inst_83255 = (state_83287[(8)]);
var state_83287__$1 = state_83287;
var statearr_83307_83328 = state_83287__$1;
(statearr_83307_83328[(2)] = inst_83255);

(statearr_83307_83328[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_83308 = [null,null,null,null,null,null,null,null,null,null];
(statearr_83308[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_83308[(1)] = (1));

return statearr_83308;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_83287){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83287);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83309){var ex__20480__auto__ = e83309;
var statearr_83310_83329 = state_83287;
(statearr_83310_83329[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83287[(4)]))){
var statearr_83311_83330 = state_83287;
(statearr_83311_83330[(1)] = cljs.core.first((state_83287[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__83331 = state_83287;
state_83287 = G__83331;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_83287){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_83287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83312 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83312[(6)] = c__20603__auto__);

return statearr_83312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq83242){
var G__83243 = cljs.core.first(seq83242);
var seq83242__$1 = cljs.core.next(seq83242);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__83243,seq83242__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___83381 = arguments.length;
var i__4830__auto___83382 = (0);
while(true){
if((i__4830__auto___83382 < len__4829__auto___83381)){
args__4835__auto__.push((arguments[i__4830__auto___83382]));

var G__83383 = (i__4830__auto___83382 + (1));
i__4830__auto___83382 = G__83383;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83364){
var state_val_83365 = (state_83364[(1)]);
if((state_val_83365 === (1))){
var state_83364__$1 = state_83364;
var statearr_83366_83384 = state_83364__$1;
(statearr_83366_83384[(2)] = null);

(statearr_83366_83384[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83365 === (2))){
var _ = (function (){var statearr_83367 = state_83364;
(statearr_83367[(4)] = cljs.core.cons((5),(state_83364[(4)])));

return statearr_83367;
})();
var inst_83340 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_83364__$1 = state_83364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83364__$1,(6),inst_83340);
} else {
if((state_val_83365 === (3))){
var inst_83362 = (state_83364[(2)]);
var state_83364__$1 = state_83364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83364__$1,inst_83362);
} else {
if((state_val_83365 === (4))){
var inst_83334 = (state_83364[(2)]);
var state_83364__$1 = state_83364;
var statearr_83369_83385 = state_83364__$1;
(statearr_83369_83385[(2)] = inst_83334);

(statearr_83369_83385[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83365 === (5))){
var _ = (function (){var statearr_83370 = state_83364;
(statearr_83370[(4)] = cljs.core.rest((state_83364[(4)])));

return statearr_83370;
})();
var state_83364__$1 = state_83364;
var ex83368 = (state_83364__$1[(2)]);
var statearr_83371_83386 = state_83364__$1;
(statearr_83371_83386[(5)] = ex83368);


if((ex83368 instanceof Error)){
var statearr_83372_83387 = state_83364__$1;
(statearr_83372_83387[(1)] = (4));

(statearr_83372_83387[(5)] = null);

} else {
throw ex83368;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83365 === (6))){
var inst_83342 = (state_83364[(2)]);
var inst_83343 = fluree.db.util.async.throw_err(inst_83342);
var inst_83344 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_83343);
var inst_83345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83346 = [inst_83343];
var inst_83347 = (new cljs.core.PersistentVector(null,1,(5),inst_83345,inst_83346,null));
var inst_83348 = cljs.core.count(inst_83347);
var inst_83349 = ((9) + inst_83348);
var inst_83350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83351 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83353 = [inst_83343];
var inst_83354 = (new cljs.core.PersistentVector(null,1,(5),inst_83352,inst_83353,null));
var inst_83355 = ["==",inst_83354,inst_83344];
var inst_83356 = cljs.core.PersistentHashMap.fromArrays(inst_83351,inst_83355);
var inst_83357 = [inst_83356,inst_83349];
var inst_83358 = (new cljs.core.PersistentVector(null,2,(5),inst_83350,inst_83357,null));
var inst_83359 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83358);
var _ = (function (){var statearr_83373 = state_83364;
(statearr_83373[(4)] = cljs.core.rest((state_83364[(4)])));

return statearr_83373;
})();
var state_83364__$1 = (function (){var statearr_83374 = state_83364;
(statearr_83374[(7)] = inst_83359);

return statearr_83374;
})();
var statearr_83375_83388 = state_83364__$1;
(statearr_83375_83388[(2)] = inst_83344);

(statearr_83375_83388[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_83376 = [null,null,null,null,null,null,null,null];
(statearr_83376[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_83376[(1)] = (1));

return statearr_83376;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_83364){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83364);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83377){var ex__20480__auto__ = e83377;
var statearr_83378_83389 = state_83364;
(statearr_83378_83389[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83364[(4)]))){
var statearr_83379_83390 = state_83364;
(statearr_83379_83390[(1)] = cljs.core.first((state_83364[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__83391 = state_83364;
state_83364 = G__83391;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_83364){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_83364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83380 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83380[(6)] = c__20603__auto__);

return statearr_83380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq83332){
var G__83333 = cljs.core.first(seq83332);
var seq83332__$1 = cljs.core.next(seq83332);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__83333,seq83332__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___83441 = arguments.length;
var i__4830__auto___83442 = (0);
while(true){
if((i__4830__auto___83442 < len__4829__auto___83441)){
args__4835__auto__.push((arguments[i__4830__auto___83442]));

var G__83443 = (i__4830__auto___83442 + (1));
i__4830__auto___83442 = G__83443;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83424){
var state_val_83425 = (state_83424[(1)]);
if((state_val_83425 === (1))){
var state_83424__$1 = state_83424;
var statearr_83426_83444 = state_83424__$1;
(statearr_83426_83444[(2)] = null);

(statearr_83426_83444[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83425 === (2))){
var _ = (function (){var statearr_83427 = state_83424;
(statearr_83427[(4)] = cljs.core.cons((5),(state_83424[(4)])));

return statearr_83427;
})();
var inst_83400 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_83424__$1 = state_83424;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83424__$1,(6),inst_83400);
} else {
if((state_val_83425 === (3))){
var inst_83422 = (state_83424[(2)]);
var state_83424__$1 = state_83424;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83424__$1,inst_83422);
} else {
if((state_val_83425 === (4))){
var inst_83394 = (state_83424[(2)]);
var state_83424__$1 = state_83424;
var statearr_83429_83445 = state_83424__$1;
(statearr_83429_83445[(2)] = inst_83394);

(statearr_83429_83445[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83425 === (5))){
var _ = (function (){var statearr_83430 = state_83424;
(statearr_83430[(4)] = cljs.core.rest((state_83424[(4)])));

return statearr_83430;
})();
var state_83424__$1 = state_83424;
var ex83428 = (state_83424__$1[(2)]);
var statearr_83431_83446 = state_83424__$1;
(statearr_83431_83446[(5)] = ex83428);


if((ex83428 instanceof Error)){
var statearr_83432_83447 = state_83424__$1;
(statearr_83432_83447[(1)] = (4));

(statearr_83432_83447[(5)] = null);

} else {
throw ex83428;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83425 === (6))){
var inst_83402 = (state_83424[(2)]);
var inst_83403 = fluree.db.util.async.throw_err(inst_83402);
var inst_83404 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_83403);
var inst_83405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83406 = [inst_83403];
var inst_83407 = (new cljs.core.PersistentVector(null,1,(5),inst_83405,inst_83406,null));
var inst_83408 = cljs.core.count(inst_83407);
var inst_83409 = ((9) + inst_83408);
var inst_83410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83411 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83413 = [inst_83403];
var inst_83414 = (new cljs.core.PersistentVector(null,1,(5),inst_83412,inst_83413,null));
var inst_83415 = [">",inst_83414,inst_83404];
var inst_83416 = cljs.core.PersistentHashMap.fromArrays(inst_83411,inst_83415);
var inst_83417 = [inst_83416,inst_83409];
var inst_83418 = (new cljs.core.PersistentVector(null,2,(5),inst_83410,inst_83417,null));
var inst_83419 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83418);
var _ = (function (){var statearr_83433 = state_83424;
(statearr_83433[(4)] = cljs.core.rest((state_83424[(4)])));

return statearr_83433;
})();
var state_83424__$1 = (function (){var statearr_83434 = state_83424;
(statearr_83434[(7)] = inst_83419);

return statearr_83434;
})();
var statearr_83435_83448 = state_83424__$1;
(statearr_83435_83448[(2)] = inst_83404);

(statearr_83435_83448[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_83436 = [null,null,null,null,null,null,null,null];
(statearr_83436[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_83436[(1)] = (1));

return statearr_83436;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_83424){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83424);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83437){var ex__20480__auto__ = e83437;
var statearr_83438_83449 = state_83424;
(statearr_83438_83449[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83424[(4)]))){
var statearr_83439_83450 = state_83424;
(statearr_83439_83450[(1)] = cljs.core.first((state_83424[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__83451 = state_83424;
state_83424 = G__83451;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_83424){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_83424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83440 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83440[(6)] = c__20603__auto__);

return statearr_83440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq83392){
var G__83393 = cljs.core.first(seq83392);
var seq83392__$1 = cljs.core.next(seq83392);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__83393,seq83392__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___83501 = arguments.length;
var i__4830__auto___83502 = (0);
while(true){
if((i__4830__auto___83502 < len__4829__auto___83501)){
args__4835__auto__.push((arguments[i__4830__auto___83502]));

var G__83503 = (i__4830__auto___83502 + (1));
i__4830__auto___83502 = G__83503;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83484){
var state_val_83485 = (state_83484[(1)]);
if((state_val_83485 === (1))){
var state_83484__$1 = state_83484;
var statearr_83486_83504 = state_83484__$1;
(statearr_83486_83504[(2)] = null);

(statearr_83486_83504[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83485 === (2))){
var _ = (function (){var statearr_83487 = state_83484;
(statearr_83487[(4)] = cljs.core.cons((5),(state_83484[(4)])));

return statearr_83487;
})();
var inst_83460 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_83484__$1 = state_83484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83484__$1,(6),inst_83460);
} else {
if((state_val_83485 === (3))){
var inst_83482 = (state_83484[(2)]);
var state_83484__$1 = state_83484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83484__$1,inst_83482);
} else {
if((state_val_83485 === (4))){
var inst_83454 = (state_83484[(2)]);
var state_83484__$1 = state_83484;
var statearr_83489_83505 = state_83484__$1;
(statearr_83489_83505[(2)] = inst_83454);

(statearr_83489_83505[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83485 === (5))){
var _ = (function (){var statearr_83490 = state_83484;
(statearr_83490[(4)] = cljs.core.rest((state_83484[(4)])));

return statearr_83490;
})();
var state_83484__$1 = state_83484;
var ex83488 = (state_83484__$1[(2)]);
var statearr_83491_83506 = state_83484__$1;
(statearr_83491_83506[(5)] = ex83488);


if((ex83488 instanceof Error)){
var statearr_83492_83507 = state_83484__$1;
(statearr_83492_83507[(1)] = (4));

(statearr_83492_83507[(5)] = null);

} else {
throw ex83488;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83485 === (6))){
var inst_83462 = (state_83484[(2)]);
var inst_83463 = fluree.db.util.async.throw_err(inst_83462);
var inst_83464 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_83463);
var inst_83465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83466 = [inst_83463];
var inst_83467 = (new cljs.core.PersistentVector(null,1,(5),inst_83465,inst_83466,null));
var inst_83468 = cljs.core.count(inst_83467);
var inst_83469 = ((9) + inst_83468);
var inst_83470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83471 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83473 = [inst_83463];
var inst_83474 = (new cljs.core.PersistentVector(null,1,(5),inst_83472,inst_83473,null));
var inst_83475 = ["<",inst_83474,inst_83464];
var inst_83476 = cljs.core.PersistentHashMap.fromArrays(inst_83471,inst_83475);
var inst_83477 = [inst_83476,inst_83469];
var inst_83478 = (new cljs.core.PersistentVector(null,2,(5),inst_83470,inst_83477,null));
var inst_83479 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83478);
var _ = (function (){var statearr_83493 = state_83484;
(statearr_83493[(4)] = cljs.core.rest((state_83484[(4)])));

return statearr_83493;
})();
var state_83484__$1 = (function (){var statearr_83494 = state_83484;
(statearr_83494[(7)] = inst_83479);

return statearr_83494;
})();
var statearr_83495_83508 = state_83484__$1;
(statearr_83495_83508[(2)] = inst_83464);

(statearr_83495_83508[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_83496 = [null,null,null,null,null,null,null,null];
(statearr_83496[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_83496[(1)] = (1));

return statearr_83496;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_83484){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83484);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83497){var ex__20480__auto__ = e83497;
var statearr_83498_83509 = state_83484;
(statearr_83498_83509[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83484[(4)]))){
var statearr_83499_83510 = state_83484;
(statearr_83499_83510[(1)] = cljs.core.first((state_83484[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__83511 = state_83484;
state_83484 = G__83511;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_83484){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_83484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83500 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83500[(6)] = c__20603__auto__);

return statearr_83500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq83452){
var G__83453 = cljs.core.first(seq83452);
var seq83452__$1 = cljs.core.next(seq83452);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__83453,seq83452__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___83561 = arguments.length;
var i__4830__auto___83562 = (0);
while(true){
if((i__4830__auto___83562 < len__4829__auto___83561)){
args__4835__auto__.push((arguments[i__4830__auto___83562]));

var G__83563 = (i__4830__auto___83562 + (1));
i__4830__auto___83562 = G__83563;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83544){
var state_val_83545 = (state_83544[(1)]);
if((state_val_83545 === (1))){
var state_83544__$1 = state_83544;
var statearr_83546_83564 = state_83544__$1;
(statearr_83546_83564[(2)] = null);

(statearr_83546_83564[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83545 === (2))){
var _ = (function (){var statearr_83547 = state_83544;
(statearr_83547[(4)] = cljs.core.cons((5),(state_83544[(4)])));

return statearr_83547;
})();
var inst_83520 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_83544__$1 = state_83544;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83544__$1,(6),inst_83520);
} else {
if((state_val_83545 === (3))){
var inst_83542 = (state_83544[(2)]);
var state_83544__$1 = state_83544;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83544__$1,inst_83542);
} else {
if((state_val_83545 === (4))){
var inst_83514 = (state_83544[(2)]);
var state_83544__$1 = state_83544;
var statearr_83549_83565 = state_83544__$1;
(statearr_83549_83565[(2)] = inst_83514);

(statearr_83549_83565[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83545 === (5))){
var _ = (function (){var statearr_83550 = state_83544;
(statearr_83550[(4)] = cljs.core.rest((state_83544[(4)])));

return statearr_83550;
})();
var state_83544__$1 = state_83544;
var ex83548 = (state_83544__$1[(2)]);
var statearr_83551_83566 = state_83544__$1;
(statearr_83551_83566[(5)] = ex83548);


if((ex83548 instanceof Error)){
var statearr_83552_83567 = state_83544__$1;
(statearr_83552_83567[(1)] = (4));

(statearr_83552_83567[(5)] = null);

} else {
throw ex83548;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83545 === (6))){
var inst_83522 = (state_83544[(2)]);
var inst_83523 = fluree.db.util.async.throw_err(inst_83522);
var inst_83524 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_83523);
var inst_83525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83526 = [inst_83523];
var inst_83527 = (new cljs.core.PersistentVector(null,1,(5),inst_83525,inst_83526,null));
var inst_83528 = cljs.core.count(inst_83527);
var inst_83529 = ((9) + inst_83528);
var inst_83530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83531 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83533 = [inst_83523];
var inst_83534 = (new cljs.core.PersistentVector(null,1,(5),inst_83532,inst_83533,null));
var inst_83535 = ["<=",inst_83534,inst_83524];
var inst_83536 = cljs.core.PersistentHashMap.fromArrays(inst_83531,inst_83535);
var inst_83537 = [inst_83536,inst_83529];
var inst_83538 = (new cljs.core.PersistentVector(null,2,(5),inst_83530,inst_83537,null));
var inst_83539 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83538);
var _ = (function (){var statearr_83553 = state_83544;
(statearr_83553[(4)] = cljs.core.rest((state_83544[(4)])));

return statearr_83553;
})();
var state_83544__$1 = (function (){var statearr_83554 = state_83544;
(statearr_83554[(7)] = inst_83539);

return statearr_83554;
})();
var statearr_83555_83568 = state_83544__$1;
(statearr_83555_83568[(2)] = inst_83524);

(statearr_83555_83568[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_83556 = [null,null,null,null,null,null,null,null];
(statearr_83556[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_83556[(1)] = (1));

return statearr_83556;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_83544){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83544);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83557){var ex__20480__auto__ = e83557;
var statearr_83558_83569 = state_83544;
(statearr_83558_83569[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83544[(4)]))){
var statearr_83559_83570 = state_83544;
(statearr_83559_83570[(1)] = cljs.core.first((state_83544[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__83571 = state_83544;
state_83544 = G__83571;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_83544){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_83544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83560 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83560[(6)] = c__20603__auto__);

return statearr_83560;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq83512){
var G__83513 = cljs.core.first(seq83512);
var seq83512__$1 = cljs.core.next(seq83512);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__83513,seq83512__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___83621 = arguments.length;
var i__4830__auto___83622 = (0);
while(true){
if((i__4830__auto___83622 < len__4829__auto___83621)){
args__4835__auto__.push((arguments[i__4830__auto___83622]));

var G__83623 = (i__4830__auto___83622 + (1));
i__4830__auto___83622 = G__83623;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83604){
var state_val_83605 = (state_83604[(1)]);
if((state_val_83605 === (1))){
var state_83604__$1 = state_83604;
var statearr_83606_83624 = state_83604__$1;
(statearr_83606_83624[(2)] = null);

(statearr_83606_83624[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83605 === (2))){
var _ = (function (){var statearr_83607 = state_83604;
(statearr_83607[(4)] = cljs.core.cons((5),(state_83604[(4)])));

return statearr_83607;
})();
var inst_83580 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_83604__$1 = state_83604;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83604__$1,(6),inst_83580);
} else {
if((state_val_83605 === (3))){
var inst_83602 = (state_83604[(2)]);
var state_83604__$1 = state_83604;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83604__$1,inst_83602);
} else {
if((state_val_83605 === (4))){
var inst_83574 = (state_83604[(2)]);
var state_83604__$1 = state_83604;
var statearr_83609_83625 = state_83604__$1;
(statearr_83609_83625[(2)] = inst_83574);

(statearr_83609_83625[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83605 === (5))){
var _ = (function (){var statearr_83610 = state_83604;
(statearr_83610[(4)] = cljs.core.rest((state_83604[(4)])));

return statearr_83610;
})();
var state_83604__$1 = state_83604;
var ex83608 = (state_83604__$1[(2)]);
var statearr_83611_83626 = state_83604__$1;
(statearr_83611_83626[(5)] = ex83608);


if((ex83608 instanceof Error)){
var statearr_83612_83627 = state_83604__$1;
(statearr_83612_83627[(1)] = (4));

(statearr_83612_83627[(5)] = null);

} else {
throw ex83608;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83605 === (6))){
var inst_83582 = (state_83604[(2)]);
var inst_83583 = fluree.db.util.async.throw_err(inst_83582);
var inst_83584 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_83583);
var inst_83585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83586 = [inst_83583];
var inst_83587 = (new cljs.core.PersistentVector(null,1,(5),inst_83585,inst_83586,null));
var inst_83588 = cljs.core.count(inst_83587);
var inst_83589 = ((9) + inst_83588);
var inst_83590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83591 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83593 = [inst_83583];
var inst_83594 = (new cljs.core.PersistentVector(null,1,(5),inst_83592,inst_83593,null));
var inst_83595 = [">=",inst_83594,inst_83584];
var inst_83596 = cljs.core.PersistentHashMap.fromArrays(inst_83591,inst_83595);
var inst_83597 = [inst_83596,inst_83589];
var inst_83598 = (new cljs.core.PersistentVector(null,2,(5),inst_83590,inst_83597,null));
var inst_83599 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83598);
var _ = (function (){var statearr_83613 = state_83604;
(statearr_83613[(4)] = cljs.core.rest((state_83604[(4)])));

return statearr_83613;
})();
var state_83604__$1 = (function (){var statearr_83614 = state_83604;
(statearr_83614[(7)] = inst_83599);

return statearr_83614;
})();
var statearr_83615_83628 = state_83604__$1;
(statearr_83615_83628[(2)] = inst_83584);

(statearr_83615_83628[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_83616 = [null,null,null,null,null,null,null,null];
(statearr_83616[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_83616[(1)] = (1));

return statearr_83616;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_83604){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83604);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83617){var ex__20480__auto__ = e83617;
var statearr_83618_83629 = state_83604;
(statearr_83618_83629[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83604[(4)]))){
var statearr_83619_83630 = state_83604;
(statearr_83619_83630[(1)] = cljs.core.first((state_83604[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__83631 = state_83604;
state_83604 = G__83631;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_83604){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_83604);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83620 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83620[(6)] = c__20603__auto__);

return statearr_83620;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq83572){
var G__83573 = cljs.core.first(seq83572);
var seq83572__$1 = cljs.core.next(seq83572);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__83573,seq83572__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___83681 = arguments.length;
var i__4830__auto___83682 = (0);
while(true){
if((i__4830__auto___83682 < len__4829__auto___83681)){
args__4835__auto__.push((arguments[i__4830__auto___83682]));

var G__83683 = (i__4830__auto___83682 + (1));
i__4830__auto___83682 = G__83683;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83664){
var state_val_83665 = (state_83664[(1)]);
if((state_val_83665 === (1))){
var state_83664__$1 = state_83664;
var statearr_83666_83684 = state_83664__$1;
(statearr_83666_83684[(2)] = null);

(statearr_83666_83684[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83665 === (2))){
var _ = (function (){var statearr_83667 = state_83664;
(statearr_83667[(4)] = cljs.core.cons((5),(state_83664[(4)])));

return statearr_83667;
})();
var inst_83640 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_83664__$1 = state_83664;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83664__$1,(6),inst_83640);
} else {
if((state_val_83665 === (3))){
var inst_83662 = (state_83664[(2)]);
var state_83664__$1 = state_83664;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83664__$1,inst_83662);
} else {
if((state_val_83665 === (4))){
var inst_83634 = (state_83664[(2)]);
var state_83664__$1 = state_83664;
var statearr_83669_83685 = state_83664__$1;
(statearr_83669_83685[(2)] = inst_83634);

(statearr_83669_83685[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83665 === (5))){
var _ = (function (){var statearr_83670 = state_83664;
(statearr_83670[(4)] = cljs.core.rest((state_83664[(4)])));

return statearr_83670;
})();
var state_83664__$1 = state_83664;
var ex83668 = (state_83664__$1[(2)]);
var statearr_83671_83686 = state_83664__$1;
(statearr_83671_83686[(5)] = ex83668);


if((ex83668 instanceof Error)){
var statearr_83672_83687 = state_83664__$1;
(statearr_83672_83687[(1)] = (4));

(statearr_83672_83687[(5)] = null);

} else {
throw ex83668;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83665 === (6))){
var inst_83642 = (state_83664[(2)]);
var inst_83643 = fluree.db.util.async.throw_err(inst_83642);
var inst_83644 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_83643);
var inst_83645 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83646 = [inst_83643];
var inst_83647 = (new cljs.core.PersistentVector(null,1,(5),inst_83645,inst_83646,null));
var inst_83648 = cljs.core.count(inst_83647);
var inst_83649 = ((9) + inst_83648);
var inst_83650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83651 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83652 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83653 = [inst_83643];
var inst_83654 = (new cljs.core.PersistentVector(null,1,(5),inst_83652,inst_83653,null));
var inst_83655 = ["not=",inst_83654,inst_83644];
var inst_83656 = cljs.core.PersistentHashMap.fromArrays(inst_83651,inst_83655);
var inst_83657 = [inst_83656,inst_83649];
var inst_83658 = (new cljs.core.PersistentVector(null,2,(5),inst_83650,inst_83657,null));
var inst_83659 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83658);
var _ = (function (){var statearr_83673 = state_83664;
(statearr_83673[(4)] = cljs.core.rest((state_83664[(4)])));

return statearr_83673;
})();
var state_83664__$1 = (function (){var statearr_83674 = state_83664;
(statearr_83674[(7)] = inst_83659);

return statearr_83674;
})();
var statearr_83675_83688 = state_83664__$1;
(statearr_83675_83688[(2)] = inst_83644);

(statearr_83675_83688[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_83676 = [null,null,null,null,null,null,null,null];
(statearr_83676[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_83676[(1)] = (1));

return statearr_83676;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_83664){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83664);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83677){var ex__20480__auto__ = e83677;
var statearr_83678_83689 = state_83664;
(statearr_83678_83689[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83664[(4)]))){
var statearr_83679_83690 = state_83664;
(statearr_83679_83690[(1)] = cljs.core.first((state_83664[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__83691 = state_83664;
state_83664 = G__83691;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_83664){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_83664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83680 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83680[(6)] = c__20603__auto__);

return statearr_83680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq83632){
var G__83633 = cljs.core.first(seq83632);
var seq83632__$1 = cljs.core.next(seq83632);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__83633,seq83632__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4835__auto__ = [];
var len__4829__auto___83741 = arguments.length;
var i__4830__auto___83742 = (0);
while(true){
if((i__4830__auto___83742 < len__4829__auto___83741)){
args__4835__auto__.push((arguments[i__4830__auto___83742]));

var G__83743 = (i__4830__auto___83742 + (1));
i__4830__auto___83742 = G__83743;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83724){
var state_val_83725 = (state_83724[(1)]);
if((state_val_83725 === (1))){
var state_83724__$1 = state_83724;
var statearr_83726_83744 = state_83724__$1;
(statearr_83726_83744[(2)] = null);

(statearr_83726_83744[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83725 === (2))){
var _ = (function (){var statearr_83727 = state_83724;
(statearr_83727[(4)] = cljs.core.cons((5),(state_83724[(4)])));

return statearr_83727;
})();
var inst_83700 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_83724__$1 = state_83724;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83724__$1,(6),inst_83700);
} else {
if((state_val_83725 === (3))){
var inst_83722 = (state_83724[(2)]);
var state_83724__$1 = state_83724;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83724__$1,inst_83722);
} else {
if((state_val_83725 === (4))){
var inst_83694 = (state_83724[(2)]);
var state_83724__$1 = state_83724;
var statearr_83729_83745 = state_83724__$1;
(statearr_83729_83745[(2)] = inst_83694);

(statearr_83729_83745[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83725 === (5))){
var _ = (function (){var statearr_83730 = state_83724;
(statearr_83730[(4)] = cljs.core.rest((state_83724[(4)])));

return statearr_83730;
})();
var state_83724__$1 = state_83724;
var ex83728 = (state_83724__$1[(2)]);
var statearr_83731_83746 = state_83724__$1;
(statearr_83731_83746[(5)] = ex83728);


if((ex83728 instanceof Error)){
var statearr_83732_83747 = state_83724__$1;
(statearr_83732_83747[(1)] = (4));

(statearr_83732_83747[(5)] = null);

} else {
throw ex83728;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83725 === (6))){
var inst_83702 = (state_83724[(2)]);
var inst_83703 = fluree.db.util.async.throw_err(inst_83702);
var inst_83704 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_83703);
var inst_83705 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83706 = [inst_83703];
var inst_83707 = (new cljs.core.PersistentVector(null,1,(5),inst_83705,inst_83706,null));
var inst_83708 = cljs.core.count(inst_83707);
var inst_83709 = ((9) + inst_83708);
var inst_83710 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83711 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83713 = [inst_83703];
var inst_83714 = (new cljs.core.PersistentVector(null,1,(5),inst_83712,inst_83713,null));
var inst_83715 = ["max",inst_83714,inst_83704];
var inst_83716 = cljs.core.PersistentHashMap.fromArrays(inst_83711,inst_83715);
var inst_83717 = [inst_83716,inst_83709];
var inst_83718 = (new cljs.core.PersistentVector(null,2,(5),inst_83710,inst_83717,null));
var inst_83719 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83718);
var _ = (function (){var statearr_83733 = state_83724;
(statearr_83733[(4)] = cljs.core.rest((state_83724[(4)])));

return statearr_83733;
})();
var state_83724__$1 = (function (){var statearr_83734 = state_83724;
(statearr_83734[(7)] = inst_83719);

return statearr_83734;
})();
var statearr_83735_83748 = state_83724__$1;
(statearr_83735_83748[(2)] = inst_83704);

(statearr_83735_83748[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_83736 = [null,null,null,null,null,null,null,null];
(statearr_83736[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_83736[(1)] = (1));

return statearr_83736;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_83724){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83724);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83737){var ex__20480__auto__ = e83737;
var statearr_83738_83749 = state_83724;
(statearr_83738_83749[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83724[(4)]))){
var statearr_83739_83750 = state_83724;
(statearr_83739_83750[(1)] = cljs.core.first((state_83724[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__83751 = state_83724;
state_83724 = G__83751;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_83724){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_83724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83740 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83740[(6)] = c__20603__auto__);

return statearr_83740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq83692){
var G__83693 = cljs.core.first(seq83692);
var seq83692__$1 = cljs.core.next(seq83692);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__83693,seq83692__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4835__auto__ = [];
var len__4829__auto___83801 = arguments.length;
var i__4830__auto___83802 = (0);
while(true){
if((i__4830__auto___83802 < len__4829__auto___83801)){
args__4835__auto__.push((arguments[i__4830__auto___83802]));

var G__83803 = (i__4830__auto___83802 + (1));
i__4830__auto___83802 = G__83803;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83784){
var state_val_83785 = (state_83784[(1)]);
if((state_val_83785 === (1))){
var state_83784__$1 = state_83784;
var statearr_83786_83804 = state_83784__$1;
(statearr_83786_83804[(2)] = null);

(statearr_83786_83804[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83785 === (2))){
var _ = (function (){var statearr_83787 = state_83784;
(statearr_83787[(4)] = cljs.core.cons((5),(state_83784[(4)])));

return statearr_83787;
})();
var inst_83760 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_83784__$1 = state_83784;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83784__$1,(6),inst_83760);
} else {
if((state_val_83785 === (3))){
var inst_83782 = (state_83784[(2)]);
var state_83784__$1 = state_83784;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83784__$1,inst_83782);
} else {
if((state_val_83785 === (4))){
var inst_83754 = (state_83784[(2)]);
var state_83784__$1 = state_83784;
var statearr_83789_83805 = state_83784__$1;
(statearr_83789_83805[(2)] = inst_83754);

(statearr_83789_83805[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83785 === (5))){
var _ = (function (){var statearr_83790 = state_83784;
(statearr_83790[(4)] = cljs.core.rest((state_83784[(4)])));

return statearr_83790;
})();
var state_83784__$1 = state_83784;
var ex83788 = (state_83784__$1[(2)]);
var statearr_83791_83806 = state_83784__$1;
(statearr_83791_83806[(5)] = ex83788);


if((ex83788 instanceof Error)){
var statearr_83792_83807 = state_83784__$1;
(statearr_83792_83807[(1)] = (4));

(statearr_83792_83807[(5)] = null);

} else {
throw ex83788;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83785 === (6))){
var inst_83762 = (state_83784[(2)]);
var inst_83763 = fluree.db.util.async.throw_err(inst_83762);
var inst_83764 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_83763);
var inst_83765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83766 = [inst_83763];
var inst_83767 = (new cljs.core.PersistentVector(null,1,(5),inst_83765,inst_83766,null));
var inst_83768 = cljs.core.count(inst_83767);
var inst_83769 = ((9) + inst_83768);
var inst_83770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83771 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83772 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83773 = [inst_83763];
var inst_83774 = (new cljs.core.PersistentVector(null,1,(5),inst_83772,inst_83773,null));
var inst_83775 = ["min",inst_83774,inst_83764];
var inst_83776 = cljs.core.PersistentHashMap.fromArrays(inst_83771,inst_83775);
var inst_83777 = [inst_83776,inst_83769];
var inst_83778 = (new cljs.core.PersistentVector(null,2,(5),inst_83770,inst_83777,null));
var inst_83779 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83778);
var _ = (function (){var statearr_83793 = state_83784;
(statearr_83793[(4)] = cljs.core.rest((state_83784[(4)])));

return statearr_83793;
})();
var state_83784__$1 = (function (){var statearr_83794 = state_83784;
(statearr_83794[(7)] = inst_83779);

return statearr_83794;
})();
var statearr_83795_83808 = state_83784__$1;
(statearr_83795_83808[(2)] = inst_83764);

(statearr_83795_83808[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_83796 = [null,null,null,null,null,null,null,null];
(statearr_83796[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_83796[(1)] = (1));

return statearr_83796;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_83784){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83784);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83797){var ex__20480__auto__ = e83797;
var statearr_83798_83809 = state_83784;
(statearr_83798_83809[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83784[(4)]))){
var statearr_83799_83810 = state_83784;
(statearr_83799_83810[(1)] = cljs.core.first((state_83784[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__83811 = state_83784;
state_83784 = G__83811;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_83784){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_83784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83800 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83800[(6)] = c__20603__auto__);

return statearr_83800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq83752){
var G__83753 = cljs.core.first(seq83752);
var seq83752__$1 = cljs.core.next(seq83752);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__83753,seq83752__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__83813 = arguments.length;
switch (G__83813) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83858){
var state_val_83859 = (state_83858[(1)]);
if((state_val_83859 === (7))){
var state_83858__$1 = state_83858;
var statearr_83860_83997 = state_83858__$1;
(statearr_83860_83997[(2)] = query_map);

(statearr_83860_83997[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83859 === (1))){
var state_83858__$1 = state_83858;
var statearr_83861_83998 = state_83858__$1;
(statearr_83861_83998[(2)] = null);

(statearr_83861_83998[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83859 === (4))){
var inst_83814 = (state_83858[(2)]);
var state_83858__$1 = state_83858;
var statearr_83862_83999 = state_83858__$1;
(statearr_83862_83999[(2)] = inst_83814);

(statearr_83862_83999[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83859 === (13))){
var inst_83836 = (state_83858[(7)]);
var inst_83840 = (state_83858[(2)]);
var inst_83841 = fluree.db.util.async.throw_err(inst_83840);
var inst_83842 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83841,(0),null);
var inst_83843 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83841,(1),null);
var inst_83844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83845 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83846 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83847 = [inst_83836];
var inst_83848 = (new cljs.core.PersistentVector(null,1,(5),inst_83846,inst_83847,null));
var inst_83849 = ["query",inst_83848,inst_83842];
var inst_83850 = cljs.core.PersistentHashMap.fromArrays(inst_83845,inst_83849);
var inst_83851 = [inst_83850,inst_83843];
var inst_83852 = (new cljs.core.PersistentVector(null,2,(5),inst_83844,inst_83851,null));
var inst_83853 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83852);
var _ = (function (){var statearr_83863 = state_83858;
(statearr_83863[(4)] = cljs.core.rest((state_83858[(4)])));

return statearr_83863;
})();
var state_83858__$1 = (function (){var statearr_83864 = state_83858;
(statearr_83864[(8)] = inst_83853);

return statearr_83864;
})();
var statearr_83865_84000 = state_83858__$1;
(statearr_83865_84000[(2)] = inst_83842);

(statearr_83865_84000[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83859 === (6))){
var state_83858__$1 = state_83858;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83858__$1,(9),query_map);
} else {
if((state_val_83859 === (3))){
var inst_83856 = (state_83858[(2)]);
var state_83858__$1 = state_83858;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83858__$1,inst_83856);
} else {
if((state_val_83859 === (12))){
var inst_83836 = (state_83858[(7)]);
var inst_83836__$1 = (state_83858[(2)]);
var inst_83837 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_83838 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_83837,inst_83836__$1);
var state_83858__$1 = (function (){var statearr_83866 = state_83858;
(statearr_83866[(7)] = inst_83836__$1);

return statearr_83866;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83858__$1,(13),inst_83838);
} else {
if((state_val_83859 === (2))){
var _ = (function (){var statearr_83867 = state_83858;
(statearr_83867[(4)] = cljs.core.cons((5),(state_83858[(4)])));

return statearr_83867;
})();
var inst_83823 = fluree.db.util.async.channel_QMARK_(query_map);
var state_83858__$1 = state_83858;
if(inst_83823){
var statearr_83868_84001 = state_83858__$1;
(statearr_83868_84001[(1)] = (6));

} else {
var statearr_83869_84002 = state_83858__$1;
(statearr_83869_84002[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83859 === (11))){
var inst_83830 = (state_83858[(9)]);
var state_83858__$1 = state_83858;
var statearr_83871_84003 = state_83858__$1;
(statearr_83871_84003[(2)] = inst_83830);

(statearr_83871_84003[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83859 === (9))){
var inst_83826 = (state_83858[(2)]);
var inst_83827 = fluree.db.util.async.throw_err(inst_83826);
var state_83858__$1 = state_83858;
var statearr_83872_84004 = state_83858__$1;
(statearr_83872_84004[(2)] = inst_83827);

(statearr_83872_84004[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83859 === (5))){
var _ = (function (){var statearr_83873 = state_83858;
(statearr_83873[(4)] = cljs.core.rest((state_83858[(4)])));

return statearr_83873;
})();
var state_83858__$1 = state_83858;
var ex83870 = (state_83858__$1[(2)]);
var statearr_83874_84005 = state_83858__$1;
(statearr_83874_84005[(5)] = ex83870);


if((ex83870 instanceof Error)){
var statearr_83875_84006 = state_83858__$1;
(statearr_83875_84006[(1)] = (4));

(statearr_83875_84006[(5)] = null);

} else {
throw ex83870;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83859 === (10))){
var inst_83830 = (state_83858[(9)]);
var inst_83833 = fluree.db.util.json.parse(inst_83830);
var state_83858__$1 = state_83858;
var statearr_83876_84007 = state_83858__$1;
(statearr_83876_84007[(2)] = inst_83833);

(statearr_83876_84007[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83859 === (8))){
var inst_83830 = (state_83858[(9)]);
var inst_83830__$1 = (state_83858[(2)]);
var inst_83831 = typeof inst_83830__$1 === 'string';
var state_83858__$1 = (function (){var statearr_83877 = state_83858;
(statearr_83877[(9)] = inst_83830__$1);

return statearr_83877;
})();
if(cljs.core.truth_(inst_83831)){
var statearr_83878_84008 = state_83858__$1;
(statearr_83878_84008[(1)] = (10));

} else {
var statearr_83879_84009 = state_83858__$1;
(statearr_83879_84009[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_83880 = [null,null,null,null,null,null,null,null,null,null];
(statearr_83880[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_83880[(1)] = (1));

return statearr_83880;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_83858){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83858);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83881){var ex__20480__auto__ = e83881;
var statearr_83882_84010 = state_83858;
(statearr_83882_84010[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83858[(4)]))){
var statearr_83883_84011 = state_83858;
(statearr_83883_84011[(1)] = cljs.core.first((state_83858[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84012 = state_83858;
state_83858 = G__84012;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_83858){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_83858);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83884 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83884[(6)] = c__20603__auto__);

return statearr_83884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_83955){
var state_val_83956 = (state_83955[(1)]);
if((state_val_83956 === (7))){
var state_83955__$1 = state_83955;
var statearr_83957_84013 = state_83955__$1;
(statearr_83957_84013[(2)] = select);

(statearr_83957_84013[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (20))){
var inst_83925 = (state_83955[(2)]);
var inst_83926 = fluree.db.util.async.channel_QMARK_(limit);
var state_83955__$1 = (function (){var statearr_83958 = state_83955;
(statearr_83958[(7)] = inst_83925);

return statearr_83958;
})();
if(inst_83926){
var statearr_83959_84014 = state_83955__$1;
(statearr_83959_84014[(1)] = (22));

} else {
var statearr_83960_84015 = state_83955__$1;
(statearr_83960_84015[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (1))){
var state_83955__$1 = state_83955;
var statearr_83961_84016 = state_83955__$1;
(statearr_83961_84016[(2)] = null);

(statearr_83961_84016[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (24))){
var inst_83925 = (state_83955[(7)]);
var inst_83917 = (state_83955[(8)]);
var inst_83909 = (state_83955[(9)]);
var inst_83901 = (state_83955[(10)]);
var inst_83933 = (state_83955[(2)]);
var inst_83934 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_83935 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_83934,inst_83901,inst_83909,inst_83917,inst_83925,inst_83933);
var state_83955__$1 = state_83955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83955__$1,(26),inst_83935);
} else {
if((state_val_83956 === (4))){
var inst_83885 = (state_83955[(2)]);
var state_83955__$1 = state_83955;
var statearr_83962_84017 = state_83955__$1;
(statearr_83962_84017[(2)] = inst_83885);

(statearr_83962_84017[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (15))){
var state_83955__$1 = state_83955;
var statearr_83963_84018 = state_83955__$1;
(statearr_83963_84018[(2)] = where);

(statearr_83963_84018[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (21))){
var inst_83921 = (state_83955[(2)]);
var inst_83922 = fluree.db.util.async.throw_err(inst_83921);
var state_83955__$1 = state_83955;
var statearr_83964_84019 = state_83955__$1;
(statearr_83964_84019[(2)] = inst_83922);

(statearr_83964_84019[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (13))){
var inst_83905 = (state_83955[(2)]);
var inst_83906 = fluree.db.util.async.throw_err(inst_83905);
var state_83955__$1 = state_83955;
var statearr_83965_84020 = state_83955__$1;
(statearr_83965_84020[(2)] = inst_83906);

(statearr_83965_84020[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (22))){
var state_83955__$1 = state_83955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83955__$1,(25),limit);
} else {
if((state_val_83956 === (6))){
var state_83955__$1 = state_83955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83955__$1,(9),select);
} else {
if((state_val_83956 === (25))){
var inst_83929 = (state_83955[(2)]);
var inst_83930 = fluree.db.util.async.throw_err(inst_83929);
var state_83955__$1 = state_83955;
var statearr_83966_84021 = state_83955__$1;
(statearr_83966_84021[(2)] = inst_83930);

(statearr_83966_84021[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (17))){
var inst_83913 = (state_83955[(2)]);
var inst_83914 = fluree.db.util.async.throw_err(inst_83913);
var state_83955__$1 = state_83955;
var statearr_83967_84022 = state_83955__$1;
(statearr_83967_84022[(2)] = inst_83914);

(statearr_83967_84022[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (3))){
var inst_83953 = (state_83955[(2)]);
var state_83955__$1 = state_83955;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83955__$1,inst_83953);
} else {
if((state_val_83956 === (12))){
var inst_83909 = (state_83955[(2)]);
var inst_83910 = fluree.db.util.async.channel_QMARK_(where);
var state_83955__$1 = (function (){var statearr_83968 = state_83955;
(statearr_83968[(9)] = inst_83909);

return statearr_83968;
})();
if(inst_83910){
var statearr_83969_84023 = state_83955__$1;
(statearr_83969_84023[(1)] = (14));

} else {
var statearr_83970_84024 = state_83955__$1;
(statearr_83970_84024[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (2))){
var _ = (function (){var statearr_83971 = state_83955;
(statearr_83971[(4)] = cljs.core.cons((5),(state_83955[(4)])));

return statearr_83971;
})();
var inst_83894 = fluree.db.util.async.channel_QMARK_(select);
var state_83955__$1 = state_83955;
if(inst_83894){
var statearr_83972_84025 = state_83955__$1;
(statearr_83972_84025[(1)] = (6));

} else {
var statearr_83973_84026 = state_83955__$1;
(statearr_83973_84026[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (23))){
var state_83955__$1 = state_83955;
var statearr_83974_84027 = state_83955__$1;
(statearr_83974_84027[(2)] = limit);

(statearr_83974_84027[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (19))){
var state_83955__$1 = state_83955;
var statearr_83975_84028 = state_83955__$1;
(statearr_83975_84028[(2)] = block);

(statearr_83975_84028[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (11))){
var state_83955__$1 = state_83955;
var statearr_83977_84029 = state_83955__$1;
(statearr_83977_84029[(2)] = from);

(statearr_83977_84029[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (9))){
var inst_83897 = (state_83955[(2)]);
var inst_83898 = fluree.db.util.async.throw_err(inst_83897);
var state_83955__$1 = state_83955;
var statearr_83978_84030 = state_83955__$1;
(statearr_83978_84030[(2)] = inst_83898);

(statearr_83978_84030[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (5))){
var _ = (function (){var statearr_83979 = state_83955;
(statearr_83979[(4)] = cljs.core.rest((state_83955[(4)])));

return statearr_83979;
})();
var state_83955__$1 = state_83955;
var ex83976 = (state_83955__$1[(2)]);
var statearr_83980_84031 = state_83955__$1;
(statearr_83980_84031[(5)] = ex83976);


if((ex83976 instanceof Error)){
var statearr_83981_84032 = state_83955__$1;
(statearr_83981_84032[(1)] = (4));

(statearr_83981_84032[(5)] = null);

} else {
throw ex83976;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (14))){
var state_83955__$1 = state_83955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83955__$1,(17),where);
} else {
if((state_val_83956 === (26))){
var inst_83925 = (state_83955[(7)]);
var inst_83917 = (state_83955[(8)]);
var inst_83909 = (state_83955[(9)]);
var inst_83901 = (state_83955[(10)]);
var inst_83937 = (state_83955[(2)]);
var inst_83938 = fluree.db.util.async.throw_err(inst_83937);
var inst_83939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83938,(0),null);
var inst_83940 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_83938,(1),null);
var inst_83941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83942 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83943 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83944 = [inst_83901,inst_83909,inst_83917,inst_83925];
var inst_83945 = (new cljs.core.PersistentVector(null,4,(5),inst_83943,inst_83944,null));
var inst_83946 = ["query",inst_83945,inst_83939];
var inst_83947 = cljs.core.PersistentHashMap.fromArrays(inst_83942,inst_83946);
var inst_83948 = [inst_83947,inst_83940];
var inst_83949 = (new cljs.core.PersistentVector(null,2,(5),inst_83941,inst_83948,null));
var inst_83950 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83949);
var _ = (function (){var statearr_83982 = state_83955;
(statearr_83982[(4)] = cljs.core.rest((state_83955[(4)])));

return statearr_83982;
})();
var state_83955__$1 = (function (){var statearr_83983 = state_83955;
(statearr_83983[(11)] = inst_83950);

return statearr_83983;
})();
var statearr_83984_84033 = state_83955__$1;
(statearr_83984_84033[(2)] = inst_83939);

(statearr_83984_84033[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (16))){
var inst_83917 = (state_83955[(2)]);
var inst_83918 = fluree.db.util.async.channel_QMARK_(block);
var state_83955__$1 = (function (){var statearr_83985 = state_83955;
(statearr_83985[(8)] = inst_83917);

return statearr_83985;
})();
if(inst_83918){
var statearr_83986_84034 = state_83955__$1;
(statearr_83986_84034[(1)] = (18));

} else {
var statearr_83987_84035 = state_83955__$1;
(statearr_83987_84035[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83956 === (10))){
var state_83955__$1 = state_83955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83955__$1,(13),from);
} else {
if((state_val_83956 === (18))){
var state_83955__$1 = state_83955;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83955__$1,(21),block);
} else {
if((state_val_83956 === (8))){
var inst_83901 = (state_83955[(2)]);
var inst_83902 = fluree.db.util.async.channel_QMARK_(from);
var state_83955__$1 = (function (){var statearr_83988 = state_83955;
(statearr_83988[(10)] = inst_83901);

return statearr_83988;
})();
if(inst_83902){
var statearr_83989_84036 = state_83955__$1;
(statearr_83989_84036[(1)] = (10));

} else {
var statearr_83990_84037 = state_83955__$1;
(statearr_83990_84037[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_83991 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83991[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_83991[(1)] = (1));

return statearr_83991;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_83955){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_83955);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e83992){var ex__20480__auto__ = e83992;
var statearr_83993_84038 = state_83955;
(statearr_83993_84038[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_83955[(4)]))){
var statearr_83994_84039 = state_83955;
(statearr_83994_84039[(1)] = cljs.core.first((state_83955[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84040 = state_83955;
state_83955 = G__84040;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_83955){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_83955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_83995 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_83995[(6)] = c__20603__auto__);

return statearr_83995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84096){
var state_val_84097 = (state_84096[(1)]);
if((state_val_84097 === (7))){
var state_84096__$1 = state_84096;
var statearr_84098_84129 = state_84096__$1;
(statearr_84098_84129[(2)] = startSubject);

(statearr_84098_84129[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (1))){
var state_84096__$1 = state_84096;
var statearr_84099_84130 = state_84096__$1;
(statearr_84099_84130[(2)] = null);

(statearr_84099_84130[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (4))){
var inst_84041 = (state_84096[(2)]);
var state_84096__$1 = state_84096;
var statearr_84100_84131 = state_84096__$1;
(statearr_84100_84131[(2)] = inst_84041);

(statearr_84100_84131[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (15))){
var inst_84073 = (state_84096[(2)]);
var inst_84074 = fluree.db.util.async.throw_err(inst_84073);
var inst_84075 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84074,(0),null);
var inst_84076 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84074,(1),null);
var inst_84077 = cljs.core.empty_QMARK_(inst_84075);
var state_84096__$1 = (function (){var statearr_84101 = state_84096;
(statearr_84101[(7)] = inst_84076);

return statearr_84101;
})();
if(inst_84077){
var statearr_84102_84132 = state_84096__$1;
(statearr_84102_84132[(1)] = (16));

} else {
var statearr_84103_84133 = state_84096__$1;
(statearr_84103_84133[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (13))){
var inst_84069 = (state_84096[(8)]);
var inst_84057 = (state_84096[(9)]);
var inst_84061 = (state_84096[(10)]);
var inst_84069__$1 = (state_84096[(2)]);
var inst_84070 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_84071 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_84070,inst_84057,inst_84061,inst_84069__$1);
var state_84096__$1 = (function (){var statearr_84104 = state_84096;
(statearr_84104[(8)] = inst_84069__$1);

return statearr_84104;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84096__$1,(15),inst_84071);
} else {
if((state_val_84097 === (6))){
var state_84096__$1 = state_84096;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84096__$1,(9),startSubject);
} else {
if((state_val_84097 === (17))){
var state_84096__$1 = state_84096;
var statearr_84105_84134 = state_84096__$1;
(statearr_84105_84134[(2)] = true);

(statearr_84105_84134[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (3))){
var inst_84094 = (state_84096[(2)]);
var state_84096__$1 = state_84096;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84096__$1,inst_84094);
} else {
if((state_val_84097 === (12))){
var state_84096__$1 = state_84096;
var statearr_84106_84135 = state_84096__$1;
(statearr_84106_84135[(2)] = endSubject);

(statearr_84106_84135[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (2))){
var _ = (function (){var statearr_84107 = state_84096;
(statearr_84107[(4)] = cljs.core.cons((5),(state_84096[(4)])));

return statearr_84107;
})();
var inst_84050 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_84096__$1 = state_84096;
if(inst_84050){
var statearr_84108_84136 = state_84096__$1;
(statearr_84108_84136[(1)] = (6));

} else {
var statearr_84109_84137 = state_84096__$1;
(statearr_84109_84137[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (11))){
var state_84096__$1 = state_84096;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84096__$1,(14),endSubject);
} else {
if((state_val_84097 === (9))){
var inst_84053 = (state_84096[(2)]);
var inst_84054 = fluree.db.util.async.throw_err(inst_84053);
var state_84096__$1 = state_84096;
var statearr_84111_84138 = state_84096__$1;
(statearr_84111_84138[(2)] = inst_84054);

(statearr_84111_84138[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (5))){
var _ = (function (){var statearr_84112 = state_84096;
(statearr_84112[(4)] = cljs.core.rest((state_84096[(4)])));

return statearr_84112;
})();
var state_84096__$1 = state_84096;
var ex84110 = (state_84096__$1[(2)]);
var statearr_84113_84139 = state_84096__$1;
(statearr_84113_84139[(5)] = ex84110);


if((ex84110 instanceof Error)){
var statearr_84114_84140 = state_84096__$1;
(statearr_84114_84140[(1)] = (4));

(statearr_84114_84140[(5)] = null);

} else {
throw ex84110;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (14))){
var inst_84065 = (state_84096[(2)]);
var inst_84066 = fluree.db.util.async.throw_err(inst_84065);
var state_84096__$1 = state_84096;
var statearr_84115_84141 = state_84096__$1;
(statearr_84115_84141[(2)] = inst_84066);

(statearr_84115_84141[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (16))){
var state_84096__$1 = state_84096;
var statearr_84116_84142 = state_84096__$1;
(statearr_84116_84142[(2)] = false);

(statearr_84116_84142[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (10))){
var inst_84060 = (state_84096[(2)]);
var inst_84061 = fluree.db.util.async.throw_err(inst_84060);
var inst_84062 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_84096__$1 = (function (){var statearr_84117 = state_84096;
(statearr_84117[(10)] = inst_84061);

return statearr_84117;
})();
if(inst_84062){
var statearr_84118_84143 = state_84096__$1;
(statearr_84118_84143[(1)] = (11));

} else {
var statearr_84119_84144 = state_84096__$1;
(statearr_84119_84144[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (18))){
var inst_84069 = (state_84096[(8)]);
var inst_84076 = (state_84096[(7)]);
var inst_84057 = (state_84096[(9)]);
var inst_84061 = (state_84096[(10)]);
var inst_84081 = (state_84096[(2)]);
var inst_84082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84083 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84084 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84085 = [inst_84057,inst_84061,inst_84069];
var inst_84086 = (new cljs.core.PersistentVector(null,3,(5),inst_84084,inst_84085,null));
var inst_84087 = ["relationship?",inst_84086,inst_84081];
var inst_84088 = cljs.core.PersistentHashMap.fromArrays(inst_84083,inst_84087);
var inst_84089 = [inst_84088,inst_84076];
var inst_84090 = (new cljs.core.PersistentVector(null,2,(5),inst_84082,inst_84089,null));
var inst_84091 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84090);
var _ = (function (){var statearr_84120 = state_84096;
(statearr_84120[(4)] = cljs.core.rest((state_84096[(4)])));

return statearr_84120;
})();
var state_84096__$1 = (function (){var statearr_84121 = state_84096;
(statearr_84121[(11)] = inst_84091);

return statearr_84121;
})();
var statearr_84122_84145 = state_84096__$1;
(statearr_84122_84145[(2)] = inst_84081);

(statearr_84122_84145[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84097 === (8))){
var inst_84057 = (state_84096[(2)]);
var inst_84058 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_84096__$1 = (function (){var statearr_84123 = state_84096;
(statearr_84123[(9)] = inst_84057);

return statearr_84123;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84096__$1,(10),inst_84058);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__20477__auto____0 = (function (){
var statearr_84124 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_84124[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__20477__auto__);

(statearr_84124[(1)] = (1));

return statearr_84124;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__20477__auto____1 = (function (state_84096){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84096);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84125){var ex__20480__auto__ = e84125;
var statearr_84126_84146 = state_84096;
(statearr_84126_84146[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84096[(4)]))){
var statearr_84127_84147 = state_84096;
(statearr_84127_84147[(1)] = cljs.core.first((state_84096[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84148 = state_84096;
state_84096 = G__84148;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__20477__auto__ = function(state_84096){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__20477__auto____1.call(this,state_84096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84128 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84128[(6)] = c__20603__auto__);

return statearr_84128;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84185){
var state_val_84186 = (state_84185[(1)]);
if((state_val_84186 === (7))){
var state_84185__$1 = state_84185;
var statearr_84187_84207 = state_84185__$1;
(statearr_84187_84207[(2)] = pred_name);

(statearr_84187_84207[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84186 === (1))){
var state_84185__$1 = state_84185;
var statearr_84188_84208 = state_84185__$1;
(statearr_84188_84208[(2)] = null);

(statearr_84188_84208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84186 === (4))){
var inst_84149 = (state_84185[(2)]);
var state_84185__$1 = state_84185;
var statearr_84189_84209 = state_84185__$1;
(statearr_84189_84209[(2)] = inst_84149);

(statearr_84189_84209[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84186 === (6))){
var state_84185__$1 = state_84185;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84185__$1,(9),pred_name);
} else {
if((state_val_84186 === (3))){
var inst_84183 = (state_84185[(2)]);
var state_84185__$1 = state_84185;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84185__$1,inst_84183);
} else {
if((state_val_84186 === (2))){
var _ = (function (){var statearr_84191 = state_84185;
(statearr_84191[(4)] = cljs.core.cons((5),(state_84185[(4)])));

return statearr_84191;
})();
var inst_84158 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_84185__$1 = state_84185;
if(inst_84158){
var statearr_84192_84210 = state_84185__$1;
(statearr_84192_84210[(1)] = (6));

} else {
var statearr_84193_84211 = state_84185__$1;
(statearr_84193_84211[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84186 === (9))){
var inst_84161 = (state_84185[(2)]);
var inst_84162 = fluree.db.util.async.throw_err(inst_84161);
var state_84185__$1 = state_84185;
var statearr_84194_84212 = state_84185__$1;
(statearr_84194_84212[(2)] = inst_84162);

(statearr_84194_84212[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84186 === (5))){
var _ = (function (){var statearr_84195 = state_84185;
(statearr_84195[(4)] = cljs.core.rest((state_84185[(4)])));

return statearr_84195;
})();
var state_84185__$1 = state_84185;
var ex84190 = (state_84185__$1[(2)]);
var statearr_84196_84213 = state_84185__$1;
(statearr_84196_84213[(5)] = ex84190);


if((ex84190 instanceof Error)){
var statearr_84197_84214 = state_84185__$1;
(statearr_84197_84214[(1)] = (4));

(statearr_84197_84214[(5)] = null);

} else {
throw ex84190;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84186 === (10))){
var inst_84165 = (state_84185[(7)]);
var inst_84169 = (state_84185[(2)]);
var inst_84170 = fluree.db.util.async.throw_err(inst_84169);
var inst_84171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84170,(0),null);
var inst_84172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84170,(1),null);
var inst_84173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84174 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84175 = ["max-pred-val",inst_84165,inst_84171];
var inst_84176 = cljs.core.PersistentHashMap.fromArrays(inst_84174,inst_84175);
var inst_84177 = (inst_84172 + (10));
var inst_84178 = [inst_84176,inst_84177];
var inst_84179 = (new cljs.core.PersistentVector(null,2,(5),inst_84173,inst_84178,null));
var inst_84180 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84179);
var _ = (function (){var statearr_84198 = state_84185;
(statearr_84198[(4)] = cljs.core.rest((state_84185[(4)])));

return statearr_84198;
})();
var state_84185__$1 = (function (){var statearr_84199 = state_84185;
(statearr_84199[(8)] = inst_84180);

return statearr_84199;
})();
var statearr_84200_84215 = state_84185__$1;
(statearr_84200_84215[(2)] = inst_84171);

(statearr_84200_84215[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84186 === (8))){
var inst_84165 = (state_84185[(7)]);
var inst_84165__$1 = (state_84185[(2)]);
var inst_84166 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_84167 = fluree.db.dbfunctions.internal.max_pred_val(inst_84166,inst_84165__$1,null);
var state_84185__$1 = (function (){var statearr_84201 = state_84185;
(statearr_84201[(7)] = inst_84165__$1);

return statearr_84201;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84185__$1,(10),inst_84167);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__20477__auto____0 = (function (){
var statearr_84202 = [null,null,null,null,null,null,null,null,null];
(statearr_84202[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__20477__auto__);

(statearr_84202[(1)] = (1));

return statearr_84202;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__20477__auto____1 = (function (state_84185){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84185);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84203){var ex__20480__auto__ = e84203;
var statearr_84204_84216 = state_84185;
(statearr_84204_84216[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84185[(4)]))){
var statearr_84205_84217 = state_84185;
(statearr_84205_84217[(1)] = cljs.core.first((state_84185[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84218 = state_84185;
state_84185 = G__84218;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__20477__auto__ = function(state_84185){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__20477__auto____1.call(this,state_84185);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84206 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84206[(6)] = c__20603__auto__);

return statearr_84206;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84245){
var state_val_84246 = (state_84245[(1)]);
if((state_val_84246 === (7))){
var state_84245__$1 = state_84245;
var statearr_84247_84266 = state_84245__$1;
(statearr_84247_84266[(2)] = n);

(statearr_84247_84266[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84246 === (1))){
var state_84245__$1 = state_84245;
var statearr_84248_84267 = state_84245__$1;
(statearr_84248_84267[(2)] = null);

(statearr_84248_84267[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84246 === (4))){
var inst_84219 = (state_84245[(2)]);
var state_84245__$1 = state_84245;
var statearr_84249_84268 = state_84245__$1;
(statearr_84249_84268[(2)] = inst_84219);

(statearr_84249_84268[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84246 === (6))){
var state_84245__$1 = state_84245;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84245__$1,(9),n);
} else {
if((state_val_84246 === (3))){
var inst_84243 = (state_84245[(2)]);
var state_84245__$1 = state_84245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84245__$1,inst_84243);
} else {
if((state_val_84246 === (2))){
var _ = (function (){var statearr_84251 = state_84245;
(statearr_84251[(4)] = cljs.core.cons((5),(state_84245[(4)])));

return statearr_84251;
})();
var inst_84225 = fluree.db.util.async.channel_QMARK_(n);
var state_84245__$1 = state_84245;
if(inst_84225){
var statearr_84252_84269 = state_84245__$1;
(statearr_84252_84269[(1)] = (6));

} else {
var statearr_84253_84270 = state_84245__$1;
(statearr_84253_84270[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84246 === (9))){
var inst_84228 = (state_84245[(2)]);
var inst_84229 = fluree.db.util.async.throw_err(inst_84228);
var state_84245__$1 = state_84245;
var statearr_84254_84271 = state_84245__$1;
(statearr_84254_84271[(2)] = inst_84229);

(statearr_84254_84271[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84246 === (5))){
var _ = (function (){var statearr_84255 = state_84245;
(statearr_84255[(4)] = cljs.core.rest((state_84245[(4)])));

return statearr_84255;
})();
var state_84245__$1 = state_84245;
var ex84250 = (state_84245__$1[(2)]);
var statearr_84256_84272 = state_84245__$1;
(statearr_84256_84272[(5)] = ex84250);


if((ex84250 instanceof Error)){
var statearr_84257_84273 = state_84245__$1;
(statearr_84257_84273[(1)] = (4));

(statearr_84257_84273[(5)] = null);

} else {
throw ex84250;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84246 === (8))){
var inst_84232 = (state_84245[(2)]);
var inst_84233 = fluree.db.dbfunctions.internal.inc(inst_84232);
var inst_84234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84235 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84236 = ["inc",inst_84232,inst_84233];
var inst_84237 = cljs.core.PersistentHashMap.fromArrays(inst_84235,inst_84236);
var inst_84238 = [inst_84237,(10)];
var inst_84239 = (new cljs.core.PersistentVector(null,2,(5),inst_84234,inst_84238,null));
var inst_84240 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84239);
var _ = (function (){var statearr_84258 = state_84245;
(statearr_84258[(4)] = cljs.core.rest((state_84245[(4)])));

return statearr_84258;
})();
var state_84245__$1 = (function (){var statearr_84259 = state_84245;
(statearr_84259[(7)] = inst_84240);

return statearr_84259;
})();
var statearr_84260_84274 = state_84245__$1;
(statearr_84260_84274[(2)] = inst_84233);

(statearr_84260_84274[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__20477__auto____0 = (function (){
var statearr_84261 = [null,null,null,null,null,null,null,null];
(statearr_84261[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__20477__auto__);

(statearr_84261[(1)] = (1));

return statearr_84261;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__20477__auto____1 = (function (state_84245){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84245);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84262){var ex__20480__auto__ = e84262;
var statearr_84263_84275 = state_84245;
(statearr_84263_84275[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84245[(4)]))){
var statearr_84264_84276 = state_84245;
(statearr_84264_84276[(1)] = cljs.core.first((state_84245[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84277 = state_84245;
state_84245 = G__84277;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__20477__auto__ = function(state_84245){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__20477__auto____1.call(this,state_84245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84265 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84265[(6)] = c__20603__auto__);

return statearr_84265;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84304){
var state_val_84305 = (state_84304[(1)]);
if((state_val_84305 === (7))){
var state_84304__$1 = state_84304;
var statearr_84306_84325 = state_84304__$1;
(statearr_84306_84325[(2)] = n);

(statearr_84306_84325[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84305 === (1))){
var state_84304__$1 = state_84304;
var statearr_84307_84326 = state_84304__$1;
(statearr_84307_84326[(2)] = null);

(statearr_84307_84326[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84305 === (4))){
var inst_84278 = (state_84304[(2)]);
var state_84304__$1 = state_84304;
var statearr_84308_84327 = state_84304__$1;
(statearr_84308_84327[(2)] = inst_84278);

(statearr_84308_84327[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84305 === (6))){
var state_84304__$1 = state_84304;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84304__$1,(9),n);
} else {
if((state_val_84305 === (3))){
var inst_84302 = (state_84304[(2)]);
var state_84304__$1 = state_84304;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84304__$1,inst_84302);
} else {
if((state_val_84305 === (2))){
var _ = (function (){var statearr_84310 = state_84304;
(statearr_84310[(4)] = cljs.core.cons((5),(state_84304[(4)])));

return statearr_84310;
})();
var inst_84284 = fluree.db.util.async.channel_QMARK_(n);
var state_84304__$1 = state_84304;
if(inst_84284){
var statearr_84311_84328 = state_84304__$1;
(statearr_84311_84328[(1)] = (6));

} else {
var statearr_84312_84329 = state_84304__$1;
(statearr_84312_84329[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84305 === (9))){
var inst_84287 = (state_84304[(2)]);
var inst_84288 = fluree.db.util.async.throw_err(inst_84287);
var state_84304__$1 = state_84304;
var statearr_84313_84330 = state_84304__$1;
(statearr_84313_84330[(2)] = inst_84288);

(statearr_84313_84330[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84305 === (5))){
var _ = (function (){var statearr_84314 = state_84304;
(statearr_84314[(4)] = cljs.core.rest((state_84304[(4)])));

return statearr_84314;
})();
var state_84304__$1 = state_84304;
var ex84309 = (state_84304__$1[(2)]);
var statearr_84315_84331 = state_84304__$1;
(statearr_84315_84331[(5)] = ex84309);


if((ex84309 instanceof Error)){
var statearr_84316_84332 = state_84304__$1;
(statearr_84316_84332[(1)] = (4));

(statearr_84316_84332[(5)] = null);

} else {
throw ex84309;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84305 === (8))){
var inst_84291 = (state_84304[(2)]);
var inst_84292 = fluree.db.dbfunctions.internal.dec(inst_84291);
var inst_84293 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84294 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84295 = ["dec",inst_84291,inst_84292];
var inst_84296 = cljs.core.PersistentHashMap.fromArrays(inst_84294,inst_84295);
var inst_84297 = [inst_84296,(10)];
var inst_84298 = (new cljs.core.PersistentVector(null,2,(5),inst_84293,inst_84297,null));
var inst_84299 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84298);
var _ = (function (){var statearr_84317 = state_84304;
(statearr_84317[(4)] = cljs.core.rest((state_84304[(4)])));

return statearr_84317;
})();
var state_84304__$1 = (function (){var statearr_84318 = state_84304;
(statearr_84318[(7)] = inst_84299);

return statearr_84318;
})();
var statearr_84319_84333 = state_84304__$1;
(statearr_84319_84333[(2)] = inst_84292);

(statearr_84319_84333[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__20477__auto____0 = (function (){
var statearr_84320 = [null,null,null,null,null,null,null,null];
(statearr_84320[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__20477__auto__);

(statearr_84320[(1)] = (1));

return statearr_84320;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__20477__auto____1 = (function (state_84304){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84304);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84321){var ex__20480__auto__ = e84321;
var statearr_84322_84334 = state_84304;
(statearr_84322_84334[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84304[(4)]))){
var statearr_84323_84335 = state_84304;
(statearr_84323_84335[(1)] = cljs.core.first((state_84304[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84336 = state_84304;
state_84304 = G__84336;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__20477__auto__ = function(state_84304){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__20477__auto____1.call(this,state_84304);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84324 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84324[(6)] = c__20603__auto__);

return statearr_84324;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___84386 = arguments.length;
var i__4830__auto___84387 = (0);
while(true){
if((i__4830__auto___84387 < len__4829__auto___84386)){
args__4835__auto__.push((arguments[i__4830__auto___84387]));

var G__84388 = (i__4830__auto___84387 + (1));
i__4830__auto___84387 = G__84388;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84369){
var state_val_84370 = (state_84369[(1)]);
if((state_val_84370 === (1))){
var state_84369__$1 = state_84369;
var statearr_84371_84389 = state_84369__$1;
(statearr_84371_84389[(2)] = null);

(statearr_84371_84389[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84370 === (2))){
var _ = (function (){var statearr_84372 = state_84369;
(statearr_84372[(4)] = cljs.core.cons((5),(state_84369[(4)])));

return statearr_84372;
})();
var inst_84345 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_84369__$1 = state_84369;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84369__$1,(6),inst_84345);
} else {
if((state_val_84370 === (3))){
var inst_84367 = (state_84369[(2)]);
var state_84369__$1 = state_84369;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84369__$1,inst_84367);
} else {
if((state_val_84370 === (4))){
var inst_84339 = (state_84369[(2)]);
var state_84369__$1 = state_84369;
var statearr_84374_84390 = state_84369__$1;
(statearr_84374_84390[(2)] = inst_84339);

(statearr_84374_84390[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84370 === (5))){
var _ = (function (){var statearr_84375 = state_84369;
(statearr_84375[(4)] = cljs.core.rest((state_84369[(4)])));

return statearr_84375;
})();
var state_84369__$1 = state_84369;
var ex84373 = (state_84369__$1[(2)]);
var statearr_84376_84391 = state_84369__$1;
(statearr_84376_84391[(5)] = ex84373);


if((ex84373 instanceof Error)){
var statearr_84377_84392 = state_84369__$1;
(statearr_84377_84392[(1)] = (4));

(statearr_84377_84392[(5)] = null);

} else {
throw ex84373;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84370 === (6))){
var inst_84347 = (state_84369[(2)]);
var inst_84348 = fluree.db.util.async.throw_err(inst_84347);
var inst_84349 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_84348);
var inst_84350 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84351 = [inst_84348];
var inst_84352 = (new cljs.core.PersistentVector(null,1,(5),inst_84350,inst_84351,null));
var inst_84353 = cljs.core.count(inst_84352);
var inst_84354 = ((9) + inst_84353);
var inst_84355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84356 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84358 = [inst_84348];
var inst_84359 = (new cljs.core.PersistentVector(null,1,(5),inst_84357,inst_84358,null));
var inst_84360 = ["+",inst_84359,inst_84349];
var inst_84361 = cljs.core.PersistentHashMap.fromArrays(inst_84356,inst_84360);
var inst_84362 = [inst_84361,inst_84354];
var inst_84363 = (new cljs.core.PersistentVector(null,2,(5),inst_84355,inst_84362,null));
var inst_84364 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84363);
var _ = (function (){var statearr_84378 = state_84369;
(statearr_84378[(4)] = cljs.core.rest((state_84369[(4)])));

return statearr_84378;
})();
var state_84369__$1 = (function (){var statearr_84379 = state_84369;
(statearr_84379[(7)] = inst_84364);

return statearr_84379;
})();
var statearr_84380_84393 = state_84369__$1;
(statearr_84380_84393[(2)] = inst_84349);

(statearr_84380_84393[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_84381 = [null,null,null,null,null,null,null,null];
(statearr_84381[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_84381[(1)] = (1));

return statearr_84381;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_84369){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84369);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84382){var ex__20480__auto__ = e84382;
var statearr_84383_84394 = state_84369;
(statearr_84383_84394[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84369[(4)]))){
var statearr_84384_84395 = state_84369;
(statearr_84384_84395[(1)] = cljs.core.first((state_84369[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84396 = state_84369;
state_84369 = G__84396;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_84369){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_84369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84385 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84385[(6)] = c__20603__auto__);

return statearr_84385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq84337){
var G__84338 = cljs.core.first(seq84337);
var seq84337__$1 = cljs.core.next(seq84337);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__84338,seq84337__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___84446 = arguments.length;
var i__4830__auto___84447 = (0);
while(true){
if((i__4830__auto___84447 < len__4829__auto___84446)){
args__4835__auto__.push((arguments[i__4830__auto___84447]));

var G__84448 = (i__4830__auto___84447 + (1));
i__4830__auto___84447 = G__84448;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84429){
var state_val_84430 = (state_84429[(1)]);
if((state_val_84430 === (1))){
var state_84429__$1 = state_84429;
var statearr_84431_84449 = state_84429__$1;
(statearr_84431_84449[(2)] = null);

(statearr_84431_84449[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84430 === (2))){
var _ = (function (){var statearr_84432 = state_84429;
(statearr_84432[(4)] = cljs.core.cons((5),(state_84429[(4)])));

return statearr_84432;
})();
var inst_84405 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_84429__$1 = state_84429;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84429__$1,(6),inst_84405);
} else {
if((state_val_84430 === (3))){
var inst_84427 = (state_84429[(2)]);
var state_84429__$1 = state_84429;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84429__$1,inst_84427);
} else {
if((state_val_84430 === (4))){
var inst_84399 = (state_84429[(2)]);
var state_84429__$1 = state_84429;
var statearr_84434_84450 = state_84429__$1;
(statearr_84434_84450[(2)] = inst_84399);

(statearr_84434_84450[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84430 === (5))){
var _ = (function (){var statearr_84435 = state_84429;
(statearr_84435[(4)] = cljs.core.rest((state_84429[(4)])));

return statearr_84435;
})();
var state_84429__$1 = state_84429;
var ex84433 = (state_84429__$1[(2)]);
var statearr_84436_84451 = state_84429__$1;
(statearr_84436_84451[(5)] = ex84433);


if((ex84433 instanceof Error)){
var statearr_84437_84452 = state_84429__$1;
(statearr_84437_84452[(1)] = (4));

(statearr_84437_84452[(5)] = null);

} else {
throw ex84433;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84430 === (6))){
var inst_84407 = (state_84429[(2)]);
var inst_84408 = fluree.db.util.async.throw_err(inst_84407);
var inst_84409 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_84408);
var inst_84410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84411 = [inst_84408];
var inst_84412 = (new cljs.core.PersistentVector(null,1,(5),inst_84410,inst_84411,null));
var inst_84413 = cljs.core.count(inst_84412);
var inst_84414 = ((9) + inst_84413);
var inst_84415 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84416 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84418 = [inst_84408];
var inst_84419 = (new cljs.core.PersistentVector(null,1,(5),inst_84417,inst_84418,null));
var inst_84420 = ["-",inst_84419,inst_84409];
var inst_84421 = cljs.core.PersistentHashMap.fromArrays(inst_84416,inst_84420);
var inst_84422 = [inst_84421,inst_84414];
var inst_84423 = (new cljs.core.PersistentVector(null,2,(5),inst_84415,inst_84422,null));
var inst_84424 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84423);
var _ = (function (){var statearr_84438 = state_84429;
(statearr_84438[(4)] = cljs.core.rest((state_84429[(4)])));

return statearr_84438;
})();
var state_84429__$1 = (function (){var statearr_84439 = state_84429;
(statearr_84439[(7)] = inst_84424);

return statearr_84439;
})();
var statearr_84440_84453 = state_84429__$1;
(statearr_84440_84453[(2)] = inst_84409);

(statearr_84440_84453[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_84441 = [null,null,null,null,null,null,null,null];
(statearr_84441[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_84441[(1)] = (1));

return statearr_84441;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_84429){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84429);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84442){var ex__20480__auto__ = e84442;
var statearr_84443_84454 = state_84429;
(statearr_84443_84454[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84429[(4)]))){
var statearr_84444_84455 = state_84429;
(statearr_84444_84455[(1)] = cljs.core.first((state_84429[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84456 = state_84429;
state_84429 = G__84456;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_84429){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_84429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84445 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84445[(6)] = c__20603__auto__);

return statearr_84445;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq84397){
var G__84398 = cljs.core.first(seq84397);
var seq84397__$1 = cljs.core.next(seq84397);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__84398,seq84397__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___84506 = arguments.length;
var i__4830__auto___84507 = (0);
while(true){
if((i__4830__auto___84507 < len__4829__auto___84506)){
args__4835__auto__.push((arguments[i__4830__auto___84507]));

var G__84508 = (i__4830__auto___84507 + (1));
i__4830__auto___84507 = G__84508;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84489){
var state_val_84490 = (state_84489[(1)]);
if((state_val_84490 === (1))){
var state_84489__$1 = state_84489;
var statearr_84491_84509 = state_84489__$1;
(statearr_84491_84509[(2)] = null);

(statearr_84491_84509[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84490 === (2))){
var _ = (function (){var statearr_84492 = state_84489;
(statearr_84492[(4)] = cljs.core.cons((5),(state_84489[(4)])));

return statearr_84492;
})();
var inst_84465 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_84489__$1 = state_84489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84489__$1,(6),inst_84465);
} else {
if((state_val_84490 === (3))){
var inst_84487 = (state_84489[(2)]);
var state_84489__$1 = state_84489;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84489__$1,inst_84487);
} else {
if((state_val_84490 === (4))){
var inst_84459 = (state_84489[(2)]);
var state_84489__$1 = state_84489;
var statearr_84494_84510 = state_84489__$1;
(statearr_84494_84510[(2)] = inst_84459);

(statearr_84494_84510[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84490 === (5))){
var _ = (function (){var statearr_84495 = state_84489;
(statearr_84495[(4)] = cljs.core.rest((state_84489[(4)])));

return statearr_84495;
})();
var state_84489__$1 = state_84489;
var ex84493 = (state_84489__$1[(2)]);
var statearr_84496_84511 = state_84489__$1;
(statearr_84496_84511[(5)] = ex84493);


if((ex84493 instanceof Error)){
var statearr_84497_84512 = state_84489__$1;
(statearr_84497_84512[(1)] = (4));

(statearr_84497_84512[(5)] = null);

} else {
throw ex84493;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84490 === (6))){
var inst_84467 = (state_84489[(2)]);
var inst_84468 = fluree.db.util.async.throw_err(inst_84467);
var inst_84469 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_84468);
var inst_84470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84471 = [inst_84468];
var inst_84472 = (new cljs.core.PersistentVector(null,1,(5),inst_84470,inst_84471,null));
var inst_84473 = cljs.core.count(inst_84472);
var inst_84474 = ((9) + inst_84473);
var inst_84475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84476 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84478 = [inst_84468];
var inst_84479 = (new cljs.core.PersistentVector(null,1,(5),inst_84477,inst_84478,null));
var inst_84480 = ["*",inst_84479,inst_84469];
var inst_84481 = cljs.core.PersistentHashMap.fromArrays(inst_84476,inst_84480);
var inst_84482 = [inst_84481,inst_84474];
var inst_84483 = (new cljs.core.PersistentVector(null,2,(5),inst_84475,inst_84482,null));
var inst_84484 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84483);
var _ = (function (){var statearr_84498 = state_84489;
(statearr_84498[(4)] = cljs.core.rest((state_84489[(4)])));

return statearr_84498;
})();
var state_84489__$1 = (function (){var statearr_84499 = state_84489;
(statearr_84499[(7)] = inst_84484);

return statearr_84499;
})();
var statearr_84500_84513 = state_84489__$1;
(statearr_84500_84513[(2)] = inst_84469);

(statearr_84500_84513[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_84501 = [null,null,null,null,null,null,null,null];
(statearr_84501[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_84501[(1)] = (1));

return statearr_84501;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_84489){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84489);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84502){var ex__20480__auto__ = e84502;
var statearr_84503_84514 = state_84489;
(statearr_84503_84514[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84489[(4)]))){
var statearr_84504_84515 = state_84489;
(statearr_84504_84515[(1)] = cljs.core.first((state_84489[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84516 = state_84489;
state_84489 = G__84516;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_84489){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_84489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84505 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84505[(6)] = c__20603__auto__);

return statearr_84505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq84457){
var G__84458 = cljs.core.first(seq84457);
var seq84457__$1 = cljs.core.next(seq84457);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__84458,seq84457__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___84566 = arguments.length;
var i__4830__auto___84567 = (0);
while(true){
if((i__4830__auto___84567 < len__4829__auto___84566)){
args__4835__auto__.push((arguments[i__4830__auto___84567]));

var G__84568 = (i__4830__auto___84567 + (1));
i__4830__auto___84567 = G__84568;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84549){
var state_val_84550 = (state_84549[(1)]);
if((state_val_84550 === (1))){
var state_84549__$1 = state_84549;
var statearr_84551_84569 = state_84549__$1;
(statearr_84551_84569[(2)] = null);

(statearr_84551_84569[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84550 === (2))){
var _ = (function (){var statearr_84552 = state_84549;
(statearr_84552[(4)] = cljs.core.cons((5),(state_84549[(4)])));

return statearr_84552;
})();
var inst_84525 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_84549__$1 = state_84549;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84549__$1,(6),inst_84525);
} else {
if((state_val_84550 === (3))){
var inst_84547 = (state_84549[(2)]);
var state_84549__$1 = state_84549;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84549__$1,inst_84547);
} else {
if((state_val_84550 === (4))){
var inst_84519 = (state_84549[(2)]);
var state_84549__$1 = state_84549;
var statearr_84554_84570 = state_84549__$1;
(statearr_84554_84570[(2)] = inst_84519);

(statearr_84554_84570[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84550 === (5))){
var _ = (function (){var statearr_84555 = state_84549;
(statearr_84555[(4)] = cljs.core.rest((state_84549[(4)])));

return statearr_84555;
})();
var state_84549__$1 = state_84549;
var ex84553 = (state_84549__$1[(2)]);
var statearr_84556_84571 = state_84549__$1;
(statearr_84556_84571[(5)] = ex84553);


if((ex84553 instanceof Error)){
var statearr_84557_84572 = state_84549__$1;
(statearr_84557_84572[(1)] = (4));

(statearr_84557_84572[(5)] = null);

} else {
throw ex84553;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84550 === (6))){
var inst_84527 = (state_84549[(2)]);
var inst_84528 = fluree.db.util.async.throw_err(inst_84527);
var inst_84529 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_84528);
var inst_84530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84531 = [inst_84528];
var inst_84532 = (new cljs.core.PersistentVector(null,1,(5),inst_84530,inst_84531,null));
var inst_84533 = cljs.core.count(inst_84532);
var inst_84534 = ((9) + inst_84533);
var inst_84535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84536 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84538 = [inst_84528];
var inst_84539 = (new cljs.core.PersistentVector(null,1,(5),inst_84537,inst_84538,null));
var inst_84540 = ["/",inst_84539,inst_84529];
var inst_84541 = cljs.core.PersistentHashMap.fromArrays(inst_84536,inst_84540);
var inst_84542 = [inst_84541,inst_84534];
var inst_84543 = (new cljs.core.PersistentVector(null,2,(5),inst_84535,inst_84542,null));
var inst_84544 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84543);
var _ = (function (){var statearr_84558 = state_84549;
(statearr_84558[(4)] = cljs.core.rest((state_84549[(4)])));

return statearr_84558;
})();
var state_84549__$1 = (function (){var statearr_84559 = state_84549;
(statearr_84559[(7)] = inst_84544);

return statearr_84559;
})();
var statearr_84560_84573 = state_84549__$1;
(statearr_84560_84573[(2)] = inst_84529);

(statearr_84560_84573[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_84561 = [null,null,null,null,null,null,null,null];
(statearr_84561[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_84561[(1)] = (1));

return statearr_84561;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_84549){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84549);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84562){var ex__20480__auto__ = e84562;
var statearr_84563_84574 = state_84549;
(statearr_84563_84574[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84549[(4)]))){
var statearr_84564_84575 = state_84549;
(statearr_84564_84575[(1)] = cljs.core.first((state_84549[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84576 = state_84549;
state_84549 = G__84576;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_84549){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_84549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84565 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84565[(6)] = c__20603__auto__);

return statearr_84565;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq84517){
var G__84518 = cljs.core.first(seq84517);
var seq84517__$1 = cljs.core.next(seq84517);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__84518,seq84517__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84614){
var state_val_84615 = (state_84614[(1)]);
if((state_val_84615 === (7))){
var state_84614__$1 = state_84614;
var statearr_84616_84640 = state_84614__$1;
(statearr_84616_84640[(2)] = n);

(statearr_84616_84640[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84615 === (1))){
var state_84614__$1 = state_84614;
var statearr_84617_84641 = state_84614__$1;
(statearr_84617_84641[(2)] = null);

(statearr_84617_84641[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84615 === (4))){
var inst_84577 = (state_84614[(2)]);
var state_84614__$1 = state_84614;
var statearr_84618_84642 = state_84614__$1;
(statearr_84618_84642[(2)] = inst_84577);

(statearr_84618_84642[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84615 === (13))){
var inst_84594 = (state_84614[(2)]);
var inst_84595 = fluree.db.util.async.throw_err(inst_84594);
var state_84614__$1 = state_84614;
var statearr_84619_84643 = state_84614__$1;
(statearr_84619_84643[(2)] = inst_84595);

(statearr_84619_84643[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84615 === (6))){
var state_84614__$1 = state_84614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84614__$1,(9),n);
} else {
if((state_val_84615 === (3))){
var inst_84612 = (state_84614[(2)]);
var state_84614__$1 = state_84614;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84614__$1,inst_84612);
} else {
if((state_val_84615 === (12))){
var inst_84590 = (state_84614[(7)]);
var inst_84598 = (state_84614[(2)]);
var inst_84599 = fluree.db.dbfunctions.internal.quot(inst_84590,inst_84598);
var inst_84600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84601 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84603 = [inst_84590,inst_84598];
var inst_84604 = (new cljs.core.PersistentVector(null,2,(5),inst_84602,inst_84603,null));
var inst_84605 = ["quot",inst_84604,inst_84599];
var inst_84606 = cljs.core.PersistentHashMap.fromArrays(inst_84601,inst_84605);
var inst_84607 = [inst_84606,(2)];
var inst_84608 = (new cljs.core.PersistentVector(null,2,(5),inst_84600,inst_84607,null));
var inst_84609 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84608);
var _ = (function (){var statearr_84620 = state_84614;
(statearr_84620[(4)] = cljs.core.rest((state_84614[(4)])));

return statearr_84620;
})();
var state_84614__$1 = (function (){var statearr_84621 = state_84614;
(statearr_84621[(8)] = inst_84609);

return statearr_84621;
})();
var statearr_84622_84644 = state_84614__$1;
(statearr_84622_84644[(2)] = inst_84599);

(statearr_84622_84644[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84615 === (2))){
var _ = (function (){var statearr_84623 = state_84614;
(statearr_84623[(4)] = cljs.core.cons((5),(state_84614[(4)])));

return statearr_84623;
})();
var inst_84583 = fluree.db.util.async.channel_QMARK_(n);
var state_84614__$1 = state_84614;
if(inst_84583){
var statearr_84624_84645 = state_84614__$1;
(statearr_84624_84645[(1)] = (6));

} else {
var statearr_84625_84646 = state_84614__$1;
(statearr_84625_84646[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84615 === (11))){
var state_84614__$1 = state_84614;
var statearr_84627_84647 = state_84614__$1;
(statearr_84627_84647[(2)] = d);

(statearr_84627_84647[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84615 === (9))){
var inst_84586 = (state_84614[(2)]);
var inst_84587 = fluree.db.util.async.throw_err(inst_84586);
var state_84614__$1 = state_84614;
var statearr_84628_84648 = state_84614__$1;
(statearr_84628_84648[(2)] = inst_84587);

(statearr_84628_84648[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84615 === (5))){
var _ = (function (){var statearr_84629 = state_84614;
(statearr_84629[(4)] = cljs.core.rest((state_84614[(4)])));

return statearr_84629;
})();
var state_84614__$1 = state_84614;
var ex84626 = (state_84614__$1[(2)]);
var statearr_84630_84649 = state_84614__$1;
(statearr_84630_84649[(5)] = ex84626);


if((ex84626 instanceof Error)){
var statearr_84631_84650 = state_84614__$1;
(statearr_84631_84650[(1)] = (4));

(statearr_84631_84650[(5)] = null);

} else {
throw ex84626;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84615 === (10))){
var state_84614__$1 = state_84614;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84614__$1,(13),d);
} else {
if((state_val_84615 === (8))){
var inst_84590 = (state_84614[(2)]);
var inst_84591 = fluree.db.util.async.channel_QMARK_(d);
var state_84614__$1 = (function (){var statearr_84632 = state_84614;
(statearr_84632[(7)] = inst_84590);

return statearr_84632;
})();
if(inst_84591){
var statearr_84633_84651 = state_84614__$1;
(statearr_84633_84651[(1)] = (10));

} else {
var statearr_84634_84652 = state_84614__$1;
(statearr_84634_84652[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__20477__auto____0 = (function (){
var statearr_84635 = [null,null,null,null,null,null,null,null,null];
(statearr_84635[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__20477__auto__);

(statearr_84635[(1)] = (1));

return statearr_84635;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__20477__auto____1 = (function (state_84614){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84614);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84636){var ex__20480__auto__ = e84636;
var statearr_84637_84653 = state_84614;
(statearr_84637_84653[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84614[(4)]))){
var statearr_84638_84654 = state_84614;
(statearr_84638_84654[(1)] = cljs.core.first((state_84614[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84655 = state_84614;
state_84614 = G__84655;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__20477__auto__ = function(state_84614){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__20477__auto____1.call(this,state_84614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84639 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84639[(6)] = c__20603__auto__);

return statearr_84639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84693){
var state_val_84694 = (state_84693[(1)]);
if((state_val_84694 === (7))){
var state_84693__$1 = state_84693;
var statearr_84695_84719 = state_84693__$1;
(statearr_84695_84719[(2)] = n);

(statearr_84695_84719[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84694 === (1))){
var state_84693__$1 = state_84693;
var statearr_84696_84720 = state_84693__$1;
(statearr_84696_84720[(2)] = null);

(statearr_84696_84720[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84694 === (4))){
var inst_84656 = (state_84693[(2)]);
var state_84693__$1 = state_84693;
var statearr_84697_84721 = state_84693__$1;
(statearr_84697_84721[(2)] = inst_84656);

(statearr_84697_84721[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84694 === (13))){
var inst_84673 = (state_84693[(2)]);
var inst_84674 = fluree.db.util.async.throw_err(inst_84673);
var state_84693__$1 = state_84693;
var statearr_84698_84722 = state_84693__$1;
(statearr_84698_84722[(2)] = inst_84674);

(statearr_84698_84722[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84694 === (6))){
var state_84693__$1 = state_84693;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84693__$1,(9),n);
} else {
if((state_val_84694 === (3))){
var inst_84691 = (state_84693[(2)]);
var state_84693__$1 = state_84693;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84693__$1,inst_84691);
} else {
if((state_val_84694 === (12))){
var inst_84669 = (state_84693[(7)]);
var inst_84677 = (state_84693[(2)]);
var inst_84678 = fluree.db.dbfunctions.internal.mod(inst_84669,inst_84677);
var inst_84679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84680 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84682 = [inst_84669,inst_84677];
var inst_84683 = (new cljs.core.PersistentVector(null,2,(5),inst_84681,inst_84682,null));
var inst_84684 = ["mod",inst_84683,inst_84678];
var inst_84685 = cljs.core.PersistentHashMap.fromArrays(inst_84680,inst_84684);
var inst_84686 = [inst_84685,(2)];
var inst_84687 = (new cljs.core.PersistentVector(null,2,(5),inst_84679,inst_84686,null));
var inst_84688 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84687);
var _ = (function (){var statearr_84699 = state_84693;
(statearr_84699[(4)] = cljs.core.rest((state_84693[(4)])));

return statearr_84699;
})();
var state_84693__$1 = (function (){var statearr_84700 = state_84693;
(statearr_84700[(8)] = inst_84688);

return statearr_84700;
})();
var statearr_84701_84723 = state_84693__$1;
(statearr_84701_84723[(2)] = inst_84678);

(statearr_84701_84723[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84694 === (2))){
var _ = (function (){var statearr_84702 = state_84693;
(statearr_84702[(4)] = cljs.core.cons((5),(state_84693[(4)])));

return statearr_84702;
})();
var inst_84662 = fluree.db.util.async.channel_QMARK_(n);
var state_84693__$1 = state_84693;
if(inst_84662){
var statearr_84703_84724 = state_84693__$1;
(statearr_84703_84724[(1)] = (6));

} else {
var statearr_84704_84725 = state_84693__$1;
(statearr_84704_84725[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84694 === (11))){
var state_84693__$1 = state_84693;
var statearr_84706_84726 = state_84693__$1;
(statearr_84706_84726[(2)] = d);

(statearr_84706_84726[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84694 === (9))){
var inst_84665 = (state_84693[(2)]);
var inst_84666 = fluree.db.util.async.throw_err(inst_84665);
var state_84693__$1 = state_84693;
var statearr_84707_84727 = state_84693__$1;
(statearr_84707_84727[(2)] = inst_84666);

(statearr_84707_84727[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84694 === (5))){
var _ = (function (){var statearr_84708 = state_84693;
(statearr_84708[(4)] = cljs.core.rest((state_84693[(4)])));

return statearr_84708;
})();
var state_84693__$1 = state_84693;
var ex84705 = (state_84693__$1[(2)]);
var statearr_84709_84728 = state_84693__$1;
(statearr_84709_84728[(5)] = ex84705);


if((ex84705 instanceof Error)){
var statearr_84710_84729 = state_84693__$1;
(statearr_84710_84729[(1)] = (4));

(statearr_84710_84729[(5)] = null);

} else {
throw ex84705;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84694 === (10))){
var state_84693__$1 = state_84693;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84693__$1,(13),d);
} else {
if((state_val_84694 === (8))){
var inst_84669 = (state_84693[(2)]);
var inst_84670 = fluree.db.util.async.channel_QMARK_(d);
var state_84693__$1 = (function (){var statearr_84711 = state_84693;
(statearr_84711[(7)] = inst_84669);

return statearr_84711;
})();
if(inst_84670){
var statearr_84712_84730 = state_84693__$1;
(statearr_84712_84730[(1)] = (10));

} else {
var statearr_84713_84731 = state_84693__$1;
(statearr_84713_84731[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__20477__auto____0 = (function (){
var statearr_84714 = [null,null,null,null,null,null,null,null,null];
(statearr_84714[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__20477__auto__);

(statearr_84714[(1)] = (1));

return statearr_84714;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__20477__auto____1 = (function (state_84693){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84693);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84715){var ex__20480__auto__ = e84715;
var statearr_84716_84732 = state_84693;
(statearr_84716_84732[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84693[(4)]))){
var statearr_84717_84733 = state_84693;
(statearr_84717_84733[(1)] = cljs.core.first((state_84693[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84734 = state_84693;
state_84693 = G__84734;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__20477__auto__ = function(state_84693){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__20477__auto____1.call(this,state_84693);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84718 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84718[(6)] = c__20603__auto__);

return statearr_84718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84772){
var state_val_84773 = (state_84772[(1)]);
if((state_val_84773 === (7))){
var state_84772__$1 = state_84772;
var statearr_84774_84798 = state_84772__$1;
(statearr_84774_84798[(2)] = n);

(statearr_84774_84798[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84773 === (1))){
var state_84772__$1 = state_84772;
var statearr_84775_84799 = state_84772__$1;
(statearr_84775_84799[(2)] = null);

(statearr_84775_84799[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84773 === (4))){
var inst_84735 = (state_84772[(2)]);
var state_84772__$1 = state_84772;
var statearr_84776_84800 = state_84772__$1;
(statearr_84776_84800[(2)] = inst_84735);

(statearr_84776_84800[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84773 === (13))){
var inst_84752 = (state_84772[(2)]);
var inst_84753 = fluree.db.util.async.throw_err(inst_84752);
var state_84772__$1 = state_84772;
var statearr_84777_84801 = state_84772__$1;
(statearr_84777_84801[(2)] = inst_84753);

(statearr_84777_84801[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84773 === (6))){
var state_84772__$1 = state_84772;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84772__$1,(9),n);
} else {
if((state_val_84773 === (3))){
var inst_84770 = (state_84772[(2)]);
var state_84772__$1 = state_84772;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84772__$1,inst_84770);
} else {
if((state_val_84773 === (12))){
var inst_84748 = (state_84772[(7)]);
var inst_84756 = (state_84772[(2)]);
var inst_84757 = fluree.db.dbfunctions.internal.rem(inst_84748,inst_84756);
var inst_84758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84759 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84760 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84761 = [inst_84748,inst_84756];
var inst_84762 = (new cljs.core.PersistentVector(null,2,(5),inst_84760,inst_84761,null));
var inst_84763 = ["rem",inst_84762,inst_84757];
var inst_84764 = cljs.core.PersistentHashMap.fromArrays(inst_84759,inst_84763);
var inst_84765 = [inst_84764,(2)];
var inst_84766 = (new cljs.core.PersistentVector(null,2,(5),inst_84758,inst_84765,null));
var inst_84767 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84766);
var _ = (function (){var statearr_84778 = state_84772;
(statearr_84778[(4)] = cljs.core.rest((state_84772[(4)])));

return statearr_84778;
})();
var state_84772__$1 = (function (){var statearr_84779 = state_84772;
(statearr_84779[(8)] = inst_84767);

return statearr_84779;
})();
var statearr_84780_84802 = state_84772__$1;
(statearr_84780_84802[(2)] = inst_84757);

(statearr_84780_84802[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84773 === (2))){
var _ = (function (){var statearr_84781 = state_84772;
(statearr_84781[(4)] = cljs.core.cons((5),(state_84772[(4)])));

return statearr_84781;
})();
var inst_84741 = fluree.db.util.async.channel_QMARK_(n);
var state_84772__$1 = state_84772;
if(inst_84741){
var statearr_84782_84803 = state_84772__$1;
(statearr_84782_84803[(1)] = (6));

} else {
var statearr_84783_84804 = state_84772__$1;
(statearr_84783_84804[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84773 === (11))){
var state_84772__$1 = state_84772;
var statearr_84785_84805 = state_84772__$1;
(statearr_84785_84805[(2)] = d);

(statearr_84785_84805[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84773 === (9))){
var inst_84744 = (state_84772[(2)]);
var inst_84745 = fluree.db.util.async.throw_err(inst_84744);
var state_84772__$1 = state_84772;
var statearr_84786_84806 = state_84772__$1;
(statearr_84786_84806[(2)] = inst_84745);

(statearr_84786_84806[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84773 === (5))){
var _ = (function (){var statearr_84787 = state_84772;
(statearr_84787[(4)] = cljs.core.rest((state_84772[(4)])));

return statearr_84787;
})();
var state_84772__$1 = state_84772;
var ex84784 = (state_84772__$1[(2)]);
var statearr_84788_84807 = state_84772__$1;
(statearr_84788_84807[(5)] = ex84784);


if((ex84784 instanceof Error)){
var statearr_84789_84808 = state_84772__$1;
(statearr_84789_84808[(1)] = (4));

(statearr_84789_84808[(5)] = null);

} else {
throw ex84784;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84773 === (10))){
var state_84772__$1 = state_84772;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84772__$1,(13),d);
} else {
if((state_val_84773 === (8))){
var inst_84748 = (state_84772[(2)]);
var inst_84749 = fluree.db.util.async.channel_QMARK_(d);
var state_84772__$1 = (function (){var statearr_84790 = state_84772;
(statearr_84790[(7)] = inst_84748);

return statearr_84790;
})();
if(inst_84749){
var statearr_84791_84809 = state_84772__$1;
(statearr_84791_84809[(1)] = (10));

} else {
var statearr_84792_84810 = state_84772__$1;
(statearr_84792_84810[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__20477__auto____0 = (function (){
var statearr_84793 = [null,null,null,null,null,null,null,null,null];
(statearr_84793[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__20477__auto__);

(statearr_84793[(1)] = (1));

return statearr_84793;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__20477__auto____1 = (function (state_84772){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84772);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84794){var ex__20480__auto__ = e84794;
var statearr_84795_84811 = state_84772;
(statearr_84795_84811[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84772[(4)]))){
var statearr_84796_84812 = state_84772;
(statearr_84796_84812[(1)] = cljs.core.first((state_84772[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84813 = state_84772;
state_84772 = G__84813;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__20477__auto__ = function(state_84772){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__20477__auto____1.call(this,state_84772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84797 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84797[(6)] = c__20603__auto__);

return statearr_84797;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84840){
var state_val_84841 = (state_84840[(1)]);
if((state_val_84841 === (7))){
var state_84840__$1 = state_84840;
var statearr_84842_84861 = state_84840__$1;
(statearr_84842_84861[(2)] = x);

(statearr_84842_84861[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84841 === (1))){
var state_84840__$1 = state_84840;
var statearr_84843_84862 = state_84840__$1;
(statearr_84843_84862[(2)] = null);

(statearr_84843_84862[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84841 === (4))){
var inst_84814 = (state_84840[(2)]);
var state_84840__$1 = state_84840;
var statearr_84844_84863 = state_84840__$1;
(statearr_84844_84863[(2)] = inst_84814);

(statearr_84844_84863[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84841 === (6))){
var state_84840__$1 = state_84840;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84840__$1,(9),x);
} else {
if((state_val_84841 === (3))){
var inst_84838 = (state_84840[(2)]);
var state_84840__$1 = state_84840;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84840__$1,inst_84838);
} else {
if((state_val_84841 === (2))){
var _ = (function (){var statearr_84846 = state_84840;
(statearr_84846[(4)] = cljs.core.cons((5),(state_84840[(4)])));

return statearr_84846;
})();
var inst_84820 = fluree.db.util.async.channel_QMARK_(x);
var state_84840__$1 = state_84840;
if(inst_84820){
var statearr_84847_84864 = state_84840__$1;
(statearr_84847_84864[(1)] = (6));

} else {
var statearr_84848_84865 = state_84840__$1;
(statearr_84848_84865[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84841 === (9))){
var inst_84823 = (state_84840[(2)]);
var inst_84824 = fluree.db.util.async.throw_err(inst_84823);
var state_84840__$1 = state_84840;
var statearr_84849_84866 = state_84840__$1;
(statearr_84849_84866[(2)] = inst_84824);

(statearr_84849_84866[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84841 === (5))){
var _ = (function (){var statearr_84850 = state_84840;
(statearr_84850[(4)] = cljs.core.rest((state_84840[(4)])));

return statearr_84850;
})();
var state_84840__$1 = state_84840;
var ex84845 = (state_84840__$1[(2)]);
var statearr_84851_84867 = state_84840__$1;
(statearr_84851_84867[(5)] = ex84845);


if((ex84845 instanceof Error)){
var statearr_84852_84868 = state_84840__$1;
(statearr_84852_84868[(1)] = (4));

(statearr_84852_84868[(5)] = null);

} else {
throw ex84845;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84841 === (8))){
var inst_84827 = (state_84840[(2)]);
var inst_84828 = fluree.db.dbfunctions.internal.boolean$(inst_84827);
var inst_84829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84830 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84831 = ["boolean",inst_84827,inst_84828];
var inst_84832 = cljs.core.PersistentHashMap.fromArrays(inst_84830,inst_84831);
var inst_84833 = [inst_84832,(10)];
var inst_84834 = (new cljs.core.PersistentVector(null,2,(5),inst_84829,inst_84833,null));
var inst_84835 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84834);
var _ = (function (){var statearr_84853 = state_84840;
(statearr_84853[(4)] = cljs.core.rest((state_84840[(4)])));

return statearr_84853;
})();
var state_84840__$1 = (function (){var statearr_84854 = state_84840;
(statearr_84854[(7)] = inst_84835);

return statearr_84854;
})();
var statearr_84855_84869 = state_84840__$1;
(statearr_84855_84869[(2)] = inst_84828);

(statearr_84855_84869[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__20477__auto____0 = (function (){
var statearr_84856 = [null,null,null,null,null,null,null,null];
(statearr_84856[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__20477__auto__);

(statearr_84856[(1)] = (1));

return statearr_84856;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__20477__auto____1 = (function (state_84840){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84840);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84857){var ex__20480__auto__ = e84857;
var statearr_84858_84870 = state_84840;
(statearr_84858_84870[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84840[(4)]))){
var statearr_84859_84871 = state_84840;
(statearr_84859_84871[(1)] = cljs.core.first((state_84840[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84872 = state_84840;
state_84840 = G__84872;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__20477__auto__ = function(state_84840){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__20477__auto____1.call(this,state_84840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84860 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84860[(6)] = c__20603__auto__);

return statearr_84860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84910){
var state_val_84911 = (state_84910[(1)]);
if((state_val_84911 === (7))){
var state_84910__$1 = state_84910;
var statearr_84912_84936 = state_84910__$1;
(statearr_84912_84936[(2)] = pattern);

(statearr_84912_84936[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (1))){
var state_84910__$1 = state_84910;
var statearr_84913_84937 = state_84910__$1;
(statearr_84913_84937[(2)] = null);

(statearr_84913_84937[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (4))){
var inst_84873 = (state_84910[(2)]);
var state_84910__$1 = state_84910;
var statearr_84914_84938 = state_84910__$1;
(statearr_84914_84938[(2)] = inst_84873);

(statearr_84914_84938[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (13))){
var inst_84890 = (state_84910[(2)]);
var inst_84891 = fluree.db.util.async.throw_err(inst_84890);
var state_84910__$1 = state_84910;
var statearr_84915_84939 = state_84910__$1;
(statearr_84915_84939[(2)] = inst_84891);

(statearr_84915_84939[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (6))){
var state_84910__$1 = state_84910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84910__$1,(9),pattern);
} else {
if((state_val_84911 === (3))){
var inst_84908 = (state_84910[(2)]);
var state_84910__$1 = state_84910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84910__$1,inst_84908);
} else {
if((state_val_84911 === (12))){
var inst_84886 = (state_84910[(7)]);
var inst_84894 = (state_84910[(2)]);
var inst_84895 = fluree.db.dbfunctions.internal.re_find(inst_84886,inst_84894);
var inst_84896 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84897 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84898 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84899 = [inst_84886,inst_84894];
var inst_84900 = (new cljs.core.PersistentVector(null,2,(5),inst_84898,inst_84899,null));
var inst_84901 = ["re-find",inst_84900,inst_84895];
var inst_84902 = cljs.core.PersistentHashMap.fromArrays(inst_84897,inst_84901);
var inst_84903 = [inst_84902,(10)];
var inst_84904 = (new cljs.core.PersistentVector(null,2,(5),inst_84896,inst_84903,null));
var inst_84905 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84904);
var _ = (function (){var statearr_84916 = state_84910;
(statearr_84916[(4)] = cljs.core.rest((state_84910[(4)])));

return statearr_84916;
})();
var state_84910__$1 = (function (){var statearr_84917 = state_84910;
(statearr_84917[(8)] = inst_84905);

return statearr_84917;
})();
var statearr_84918_84940 = state_84910__$1;
(statearr_84918_84940[(2)] = inst_84895);

(statearr_84918_84940[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (2))){
var _ = (function (){var statearr_84919 = state_84910;
(statearr_84919[(4)] = cljs.core.cons((5),(state_84910[(4)])));

return statearr_84919;
})();
var inst_84879 = fluree.db.util.async.channel_QMARK_(pattern);
var state_84910__$1 = state_84910;
if(inst_84879){
var statearr_84920_84941 = state_84910__$1;
(statearr_84920_84941[(1)] = (6));

} else {
var statearr_84921_84942 = state_84910__$1;
(statearr_84921_84942[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (11))){
var state_84910__$1 = state_84910;
var statearr_84923_84943 = state_84910__$1;
(statearr_84923_84943[(2)] = string);

(statearr_84923_84943[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (9))){
var inst_84882 = (state_84910[(2)]);
var inst_84883 = fluree.db.util.async.throw_err(inst_84882);
var state_84910__$1 = state_84910;
var statearr_84924_84944 = state_84910__$1;
(statearr_84924_84944[(2)] = inst_84883);

(statearr_84924_84944[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (5))){
var _ = (function (){var statearr_84925 = state_84910;
(statearr_84925[(4)] = cljs.core.rest((state_84910[(4)])));

return statearr_84925;
})();
var state_84910__$1 = state_84910;
var ex84922 = (state_84910__$1[(2)]);
var statearr_84926_84945 = state_84910__$1;
(statearr_84926_84945[(5)] = ex84922);


if((ex84922 instanceof Error)){
var statearr_84927_84946 = state_84910__$1;
(statearr_84927_84946[(1)] = (4));

(statearr_84927_84946[(5)] = null);

} else {
throw ex84922;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (10))){
var state_84910__$1 = state_84910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84910__$1,(13),string);
} else {
if((state_val_84911 === (8))){
var inst_84886 = (state_84910[(2)]);
var inst_84887 = fluree.db.util.async.channel_QMARK_(string);
var state_84910__$1 = (function (){var statearr_84928 = state_84910;
(statearr_84928[(7)] = inst_84886);

return statearr_84928;
})();
if(inst_84887){
var statearr_84929_84947 = state_84910__$1;
(statearr_84929_84947[(1)] = (10));

} else {
var statearr_84930_84948 = state_84910__$1;
(statearr_84930_84948[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__20477__auto____0 = (function (){
var statearr_84931 = [null,null,null,null,null,null,null,null,null];
(statearr_84931[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__20477__auto__);

(statearr_84931[(1)] = (1));

return statearr_84931;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__20477__auto____1 = (function (state_84910){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84910);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84932){var ex__20480__auto__ = e84932;
var statearr_84933_84949 = state_84910;
(statearr_84933_84949[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84910[(4)]))){
var statearr_84934_84950 = state_84910;
(statearr_84934_84950[(1)] = cljs.core.first((state_84910[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__84951 = state_84910;
state_84910 = G__84951;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__20477__auto__ = function(state_84910){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__20477__auto____1.call(this,state_84910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84935 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84935[(6)] = c__20603__auto__);

return statearr_84935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_84978){
var state_val_84979 = (state_84978[(1)]);
if((state_val_84979 === (7))){
var state_84978__$1 = state_84978;
var statearr_84980_84999 = state_84978__$1;
(statearr_84980_84999[(2)] = email);

(statearr_84980_84999[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84979 === (1))){
var state_84978__$1 = state_84978;
var statearr_84981_85000 = state_84978__$1;
(statearr_84981_85000[(2)] = null);

(statearr_84981_85000[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84979 === (4))){
var inst_84952 = (state_84978[(2)]);
var state_84978__$1 = state_84978;
var statearr_84982_85001 = state_84978__$1;
(statearr_84982_85001[(2)] = inst_84952);

(statearr_84982_85001[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84979 === (6))){
var state_84978__$1 = state_84978;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84978__$1,(9),email);
} else {
if((state_val_84979 === (3))){
var inst_84976 = (state_84978[(2)]);
var state_84978__$1 = state_84978;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84978__$1,inst_84976);
} else {
if((state_val_84979 === (2))){
var _ = (function (){var statearr_84984 = state_84978;
(statearr_84984[(4)] = cljs.core.cons((5),(state_84978[(4)])));

return statearr_84984;
})();
var inst_84958 = fluree.db.util.async.channel_QMARK_(email);
var state_84978__$1 = state_84978;
if(inst_84958){
var statearr_84985_85002 = state_84978__$1;
(statearr_84985_85002[(1)] = (6));

} else {
var statearr_84986_85003 = state_84978__$1;
(statearr_84986_85003[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84979 === (9))){
var inst_84961 = (state_84978[(2)]);
var inst_84962 = fluree.db.util.async.throw_err(inst_84961);
var state_84978__$1 = state_84978;
var statearr_84987_85004 = state_84978__$1;
(statearr_84987_85004[(2)] = inst_84962);

(statearr_84987_85004[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84979 === (5))){
var _ = (function (){var statearr_84988 = state_84978;
(statearr_84988[(4)] = cljs.core.rest((state_84978[(4)])));

return statearr_84988;
})();
var state_84978__$1 = state_84978;
var ex84983 = (state_84978__$1[(2)]);
var statearr_84989_85005 = state_84978__$1;
(statearr_84989_85005[(5)] = ex84983);


if((ex84983 instanceof Error)){
var statearr_84990_85006 = state_84978__$1;
(statearr_84990_85006[(1)] = (4));

(statearr_84990_85006[(5)] = null);

} else {
throw ex84983;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84979 === (8))){
var inst_84965 = (state_84978[(2)]);
var inst_84966 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_84965);
var inst_84967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84968 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_84969 = ["re-find",inst_84965,inst_84966];
var inst_84970 = cljs.core.PersistentHashMap.fromArrays(inst_84968,inst_84969);
var inst_84971 = [inst_84970,(10)];
var inst_84972 = (new cljs.core.PersistentVector(null,2,(5),inst_84967,inst_84971,null));
var inst_84973 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_84972);
var _ = (function (){var statearr_84991 = state_84978;
(statearr_84991[(4)] = cljs.core.rest((state_84978[(4)])));

return statearr_84991;
})();
var state_84978__$1 = (function (){var statearr_84992 = state_84978;
(statearr_84992[(7)] = inst_84973);

return statearr_84992;
})();
var statearr_84993_85007 = state_84978__$1;
(statearr_84993_85007[(2)] = inst_84966);

(statearr_84993_85007[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__20477__auto____0 = (function (){
var statearr_84994 = [null,null,null,null,null,null,null,null];
(statearr_84994[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__20477__auto__);

(statearr_84994[(1)] = (1));

return statearr_84994;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__20477__auto____1 = (function (state_84978){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_84978);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e84995){var ex__20480__auto__ = e84995;
var statearr_84996_85008 = state_84978;
(statearr_84996_85008[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_84978[(4)]))){
var statearr_84997_85009 = state_84978;
(statearr_84997_85009[(1)] = cljs.core.first((state_84978[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__85010 = state_84978;
state_84978 = G__85010;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__20477__auto__ = function(state_84978){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__20477__auto____1.call(this,state_84978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_84998 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_84998[(6)] = c__20603__auto__);

return statearr_84998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_85057){
var state_val_85058 = (state_85057[(1)]);
if((state_val_85058 === (7))){
var inst_85027 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_85057__$1 = state_85057;
if(cljs.core.truth_(inst_85027)){
var statearr_85059_85086 = state_85057__$1;
(statearr_85059_85086[(1)] = (9));

} else {
var statearr_85060_85087 = state_85057__$1;
(statearr_85060_85087[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85058 === (1))){
var state_85057__$1 = state_85057;
var statearr_85061_85088 = state_85057__$1;
(statearr_85061_85088[(2)] = null);

(statearr_85061_85088[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85058 === (4))){
var inst_85011 = (state_85057[(2)]);
var state_85057__$1 = state_85057;
var statearr_85062_85089 = state_85057__$1;
(statearr_85062_85089[(2)] = inst_85011);

(statearr_85062_85089[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85058 === (15))){
var inst_85038 = (state_85057[(2)]);
var state_85057__$1 = state_85057;
var statearr_85063_85090 = state_85057__$1;
(statearr_85063_85090[(2)] = inst_85038);

(statearr_85063_85090[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85058 === (13))){
var inst_85035 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_85057__$1 = state_85057;
var statearr_85064_85091 = state_85057__$1;
(statearr_85064_85091[(2)] = inst_85035);

(statearr_85064_85091[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85058 === (6))){
var inst_85022 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85023 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_85024 = [inst_85023,(0)];
var inst_85025 = (new cljs.core.PersistentVector(null,2,(5),inst_85022,inst_85024,null));
var state_85057__$1 = state_85057;
var statearr_85065_85092 = state_85057__$1;
(statearr_85065_85092[(2)] = inst_85025);

(statearr_85065_85092[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85058 === (3))){
var inst_85055 = (state_85057[(2)]);
var state_85057__$1 = state_85057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85057__$1,inst_85055);
} else {
if((state_val_85058 === (12))){
var inst_85031 = (state_85057[(2)]);
var inst_85032 = fluree.db.util.async.throw_err(inst_85031);
var state_85057__$1 = state_85057;
var statearr_85066_85093 = state_85057__$1;
(statearr_85066_85093[(2)] = inst_85032);

(statearr_85066_85093[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85058 === (2))){
var _ = (function (){var statearr_85067 = state_85057;
(statearr_85067[(4)] = cljs.core.cons((5),(state_85057[(4)])));

return statearr_85067;
})();
var inst_85020 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_85057__$1 = state_85057;
if(cljs.core.truth_(inst_85020)){
var statearr_85068_85094 = state_85057__$1;
(statearr_85068_85094[(1)] = (6));

} else {
var statearr_85069_85095 = state_85057__$1;
(statearr_85069_85095[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85058 === (11))){
var inst_85040 = (state_85057[(2)]);
var state_85057__$1 = state_85057;
var statearr_85071_85096 = state_85057__$1;
(statearr_85071_85096[(2)] = inst_85040);

(statearr_85071_85096[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85058 === (9))){
var inst_85029 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_85057__$1 = state_85057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85057__$1,(12),inst_85029);
} else {
if((state_val_85058 === (5))){
var _ = (function (){var statearr_85072 = state_85057;
(statearr_85072[(4)] = cljs.core.rest((state_85057[(4)])));

return statearr_85072;
})();
var state_85057__$1 = state_85057;
var ex85070 = (state_85057__$1[(2)]);
var statearr_85073_85097 = state_85057__$1;
(statearr_85073_85097[(5)] = ex85070);


if((ex85070 instanceof Error)){
var statearr_85074_85098 = state_85057__$1;
(statearr_85074_85098[(1)] = (4));

(statearr_85074_85098[(5)] = null);

} else {
throw ex85070;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85058 === (14))){
var state_85057__$1 = state_85057;
var statearr_85075_85099 = state_85057__$1;
(statearr_85075_85099[(2)] = null);

(statearr_85075_85099[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85058 === (10))){
var state_85057__$1 = state_85057;
var statearr_85076_85100 = state_85057__$1;
(statearr_85076_85100[(1)] = (13));



return cljs.core.cst$kw$recur;
} else {
if((state_val_85058 === (8))){
var inst_85042 = (state_85057[(2)]);
var inst_85043 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_85042,(0),null);
var inst_85044 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_85042,(1),null);
var inst_85045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85046 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_85047 = ["?user_id","?ctx",inst_85043];
var inst_85048 = cljs.core.PersistentHashMap.fromArrays(inst_85046,inst_85047);
var inst_85049 = ((10) + inst_85044);
var inst_85050 = [inst_85048,inst_85049];
var inst_85051 = (new cljs.core.PersistentVector(null,2,(5),inst_85045,inst_85050,null));
var inst_85052 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_85051);
var _ = (function (){var statearr_85078 = state_85057;
(statearr_85078[(4)] = cljs.core.rest((state_85057[(4)])));

return statearr_85078;
})();
var state_85057__$1 = (function (){var statearr_85079 = state_85057;
(statearr_85079[(7)] = inst_85052);

return statearr_85079;
})();
var statearr_85080_85101 = state_85057__$1;
(statearr_85080_85101[(2)] = inst_85043);

(statearr_85080_85101[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__20477__auto____0 = (function (){
var statearr_85081 = [null,null,null,null,null,null,null,null];
(statearr_85081[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__20477__auto__);

(statearr_85081[(1)] = (1));

return statearr_85081;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__20477__auto____1 = (function (state_85057){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_85057);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e85082){var ex__20480__auto__ = e85082;
var statearr_85083_85102 = state_85057;
(statearr_85083_85102[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_85057[(4)]))){
var statearr_85084_85103 = state_85057;
(statearr_85084_85103[(1)] = cljs.core.first((state_85057[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__85104 = state_85057;
state_85057 = G__85104;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__20477__auto__ = function(state_85057){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__20477__auto____1.call(this,state_85057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_85085 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_85085[(6)] = c__20603__auto__);

return statearr_85085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_85132){
var state_val_85133 = (state_85132[(1)]);
if((state_val_85133 === (7))){
var inst_85125 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_85132__$1 = state_85132;
var statearr_85134_85153 = state_85132__$1;
(statearr_85134_85153[(2)] = inst_85125);

(statearr_85134_85153[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85133 === (1))){
var state_85132__$1 = state_85132;
var statearr_85135_85154 = state_85132__$1;
(statearr_85135_85154[(2)] = null);

(statearr_85135_85154[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85133 === (4))){
var inst_85105 = (state_85132[(2)]);
var state_85132__$1 = state_85132;
var statearr_85136_85155 = state_85132__$1;
(statearr_85136_85155[(2)] = inst_85105);

(statearr_85136_85155[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85133 === (6))){
var inst_85113 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_85132__$1 = state_85132;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85132__$1,(9),inst_85113);
} else {
if((state_val_85133 === (3))){
var inst_85130 = (state_85132[(2)]);
var state_85132__$1 = state_85132;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85132__$1,inst_85130);
} else {
if((state_val_85133 === (2))){
var _ = (function (){var statearr_85138 = state_85132;
(statearr_85138[(4)] = cljs.core.cons((5),(state_85132[(4)])));

return statearr_85138;
})();
var inst_85111 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_85132__$1 = state_85132;
if(cljs.core.truth_(inst_85111)){
var statearr_85139_85156 = state_85132__$1;
(statearr_85139_85156[(1)] = (6));

} else {
var statearr_85140_85157 = state_85132__$1;
(statearr_85140_85157[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85133 === (9))){
var inst_85115 = (state_85132[(2)]);
var inst_85116 = fluree.db.util.async.throw_err(inst_85115);
var inst_85117 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85118 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_85119 = ["?auth_id","?ctx",inst_85116];
var inst_85120 = cljs.core.PersistentHashMap.fromArrays(inst_85118,inst_85119);
var inst_85121 = [inst_85120,(10)];
var inst_85122 = (new cljs.core.PersistentVector(null,2,(5),inst_85117,inst_85121,null));
var inst_85123 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_85122);
var state_85132__$1 = (function (){var statearr_85141 = state_85132;
(statearr_85141[(7)] = inst_85123);

return statearr_85141;
})();
var statearr_85142_85158 = state_85132__$1;
(statearr_85142_85158[(2)] = inst_85116);

(statearr_85142_85158[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85133 === (5))){
var _ = (function (){var statearr_85143 = state_85132;
(statearr_85143[(4)] = cljs.core.rest((state_85132[(4)])));

return statearr_85143;
})();
var state_85132__$1 = state_85132;
var ex85137 = (state_85132__$1[(2)]);
var statearr_85144_85159 = state_85132__$1;
(statearr_85144_85159[(5)] = ex85137);


if((ex85137 instanceof Error)){
var statearr_85145_85160 = state_85132__$1;
(statearr_85145_85160[(1)] = (4));

(statearr_85145_85160[(5)] = null);

} else {
throw ex85137;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85133 === (8))){
var inst_85127 = (state_85132[(2)]);
var _ = (function (){var statearr_85146 = state_85132;
(statearr_85146[(4)] = cljs.core.rest((state_85132[(4)])));

return statearr_85146;
})();
var state_85132__$1 = state_85132;
var statearr_85147_85161 = state_85132__$1;
(statearr_85147_85161[(2)] = inst_85127);

(statearr_85147_85161[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__20477__auto____0 = (function (){
var statearr_85148 = [null,null,null,null,null,null,null,null];
(statearr_85148[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__20477__auto__);

(statearr_85148[(1)] = (1));

return statearr_85148;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__20477__auto____1 = (function (state_85132){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_85132);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e85149){var ex__20480__auto__ = e85149;
var statearr_85150_85162 = state_85132;
(statearr_85150_85162[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_85132[(4)]))){
var statearr_85151_85163 = state_85132;
(statearr_85151_85163[(1)] = cljs.core.first((state_85132[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__85164 = state_85132;
state_85132 = G__85164;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__20477__auto__ = function(state_85132){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__20477__auto____1.call(this,state_85132);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_85152 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_85152[(6)] = c__20603__auto__);

return statearr_85152;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__85166 = arguments.length;
switch (G__85166) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_85208){
var state_val_85209 = (state_85208[(1)]);
if((state_val_85209 === (7))){
var state_85208__$1 = state_85208;
var statearr_85210_85240 = state_85208__$1;
(statearr_85210_85240[(2)] = seed);

(statearr_85210_85240[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85209 === (1))){
var state_85208__$1 = state_85208;
var statearr_85211_85241 = state_85208__$1;
(statearr_85211_85241[(2)] = null);

(statearr_85211_85241[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85209 === (4))){
var inst_85167 = (state_85208[(2)]);
var state_85208__$1 = state_85208;
var statearr_85212_85242 = state_85208__$1;
(statearr_85212_85242[(2)] = inst_85167);

(statearr_85212_85242[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85209 === (15))){
var state_85208__$1 = state_85208;
var statearr_85213_85243 = state_85208__$1;
(statearr_85213_85243[(2)] = (10));

(statearr_85213_85243[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85209 === (13))){
var inst_85184 = (state_85208[(2)]);
var inst_85185 = fluree.db.util.async.throw_err(inst_85184);
var state_85208__$1 = state_85208;
var statearr_85214_85244 = state_85208__$1;
(statearr_85214_85244[(2)] = inst_85185);

(statearr_85214_85244[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85209 === (6))){
var state_85208__$1 = state_85208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85208__$1,(9),seed);
} else {
if((state_val_85209 === (3))){
var inst_85206 = (state_85208[(2)]);
var state_85208__$1 = state_85208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85208__$1,inst_85206);
} else {
if((state_val_85209 === (12))){
var inst_85188 = (state_85208[(7)]);
var inst_85188__$1 = (state_85208[(2)]);
var state_85208__$1 = (function (){var statearr_85215 = state_85208;
(statearr_85215[(7)] = inst_85188__$1);

return statearr_85215;
})();
if(cljs.core.truth_(inst_85188__$1)){
var statearr_85216_85245 = state_85208__$1;
(statearr_85216_85245[(1)] = (14));

} else {
var statearr_85217_85246 = state_85208__$1;
(statearr_85217_85246[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85209 === (2))){
var _ = (function (){var statearr_85218 = state_85208;
(statearr_85218[(4)] = cljs.core.cons((5),(state_85208[(4)])));

return statearr_85218;
})();
var inst_85173 = fluree.db.util.async.channel_QMARK_(seed);
var state_85208__$1 = state_85208;
if(inst_85173){
var statearr_85219_85247 = state_85208__$1;
(statearr_85219_85247[(1)] = (6));

} else {
var statearr_85220_85248 = state_85208__$1;
(statearr_85220_85248[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85209 === (11))){
var state_85208__$1 = state_85208;
var statearr_85222_85249 = state_85208__$1;
(statearr_85222_85249[(2)] = max);

(statearr_85222_85249[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85209 === (9))){
var inst_85176 = (state_85208[(2)]);
var inst_85177 = fluree.db.util.async.throw_err(inst_85176);
var state_85208__$1 = state_85208;
var statearr_85223_85250 = state_85208__$1;
(statearr_85223_85250[(2)] = inst_85177);

(statearr_85223_85250[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85209 === (5))){
var _ = (function (){var statearr_85224 = state_85208;
(statearr_85224[(4)] = cljs.core.rest((state_85208[(4)])));

return statearr_85224;
})();
var state_85208__$1 = state_85208;
var ex85221 = (state_85208__$1[(2)]);
var statearr_85225_85251 = state_85208__$1;
(statearr_85225_85251[(5)] = ex85221);


if((ex85221 instanceof Error)){
var statearr_85226_85252 = state_85208__$1;
(statearr_85226_85252[(1)] = (4));

(statearr_85226_85252[(5)] = null);

} else {
throw ex85221;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85209 === (14))){
var inst_85188 = (state_85208[(7)]);
var state_85208__$1 = state_85208;
var statearr_85227_85253 = state_85208__$1;
(statearr_85227_85253[(2)] = inst_85188);

(statearr_85227_85253[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85209 === (16))){
var inst_85180 = (state_85208[(8)]);
var inst_85192 = (state_85208[(2)]);
var inst_85193 = fluree.db.dbfunctions.internal.rand(inst_85180,inst_85192);
var inst_85194 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85195 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_85196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85197 = [max,seed];
var inst_85198 = (new cljs.core.PersistentVector(null,2,(5),inst_85196,inst_85197,null));
var inst_85199 = ["rand",inst_85198,inst_85193];
var inst_85200 = cljs.core.PersistentHashMap.fromArrays(inst_85195,inst_85199);
var inst_85201 = [inst_85200,(10)];
var inst_85202 = (new cljs.core.PersistentVector(null,2,(5),inst_85194,inst_85201,null));
var inst_85203 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_85202);
var _ = (function (){var statearr_85228 = state_85208;
(statearr_85228[(4)] = cljs.core.rest((state_85208[(4)])));

return statearr_85228;
})();
var state_85208__$1 = (function (){var statearr_85229 = state_85208;
(statearr_85229[(9)] = inst_85203);

return statearr_85229;
})();
var statearr_85230_85254 = state_85208__$1;
(statearr_85230_85254[(2)] = inst_85193);

(statearr_85230_85254[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85209 === (10))){
var state_85208__$1 = state_85208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85208__$1,(13),max);
} else {
if((state_val_85209 === (8))){
var inst_85180 = (state_85208[(2)]);
var inst_85181 = fluree.db.util.async.channel_QMARK_(max);
var state_85208__$1 = (function (){var statearr_85231 = state_85208;
(statearr_85231[(8)] = inst_85180);

return statearr_85231;
})();
if(inst_85181){
var statearr_85232_85255 = state_85208__$1;
(statearr_85232_85255[(1)] = (10));

} else {
var statearr_85233_85256 = state_85208__$1;
(statearr_85233_85256[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__20477__auto____0 = (function (){
var statearr_85234 = [null,null,null,null,null,null,null,null,null,null];
(statearr_85234[(0)] = fluree$db$dbfunctions$fns$state_machine__20477__auto__);

(statearr_85234[(1)] = (1));

return statearr_85234;
});
var fluree$db$dbfunctions$fns$state_machine__20477__auto____1 = (function (state_85208){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_85208);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e85235){var ex__20480__auto__ = e85235;
var statearr_85236_85257 = state_85208;
(statearr_85236_85257[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_85208[(4)]))){
var statearr_85237_85258 = state_85208;
(statearr_85237_85258[(1)] = cljs.core.first((state_85208[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__85259 = state_85208;
state_85208 = G__85259;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__20477__auto__ = function(state_85208){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__20477__auto____1.call(this,state_85208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_85238 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_85238[(6)] = c__20603__auto__);

return statearr_85238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_85280){
var state_val_85281 = (state_85280[(1)]);
if((state_val_85281 === (1))){
var state_85280__$1 = state_85280;
var statearr_85282_85297 = state_85280__$1;
(statearr_85282_85297[(2)] = null);

(statearr_85282_85297[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85281 === (2))){
var _ = (function (){var statearr_85283 = state_85280;
(statearr_85283[(4)] = cljs.core.cons((5),(state_85280[(4)])));

return statearr_85283;
})();
var inst_85266 = fluree.db.util.core.random_uuid();
var inst_85267 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_85266);
var inst_85268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85269 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_85270 = cljs.core.PersistentVector.EMPTY;
var inst_85271 = ["uuid",inst_85270,inst_85267];
var inst_85272 = cljs.core.PersistentHashMap.fromArrays(inst_85269,inst_85271);
var inst_85273 = [inst_85272,(10)];
var inst_85274 = (new cljs.core.PersistentVector(null,2,(5),inst_85268,inst_85273,null));
var inst_85275 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_85274);
var ___$1 = (function (){var statearr_85284 = state_85280;
(statearr_85284[(4)] = cljs.core.rest((state_85280[(4)])));

return statearr_85284;
})();
var state_85280__$1 = (function (){var statearr_85285 = state_85280;
(statearr_85285[(7)] = inst_85275);

return statearr_85285;
})();
var statearr_85286_85298 = state_85280__$1;
(statearr_85286_85298[(2)] = inst_85267);

(statearr_85286_85298[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85281 === (3))){
var inst_85278 = (state_85280[(2)]);
var state_85280__$1 = state_85280;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85280__$1,inst_85278);
} else {
if((state_val_85281 === (4))){
var inst_85260 = (state_85280[(2)]);
var state_85280__$1 = state_85280;
var statearr_85288_85299 = state_85280__$1;
(statearr_85288_85299[(2)] = inst_85260);

(statearr_85288_85299[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85281 === (5))){
var _ = (function (){var statearr_85289 = state_85280;
(statearr_85289[(4)] = cljs.core.rest((state_85280[(4)])));

return statearr_85289;
})();
var state_85280__$1 = state_85280;
var ex85287 = (state_85280__$1[(2)]);
var statearr_85290_85300 = state_85280__$1;
(statearr_85290_85300[(5)] = ex85287);


if((ex85287 instanceof Error)){
var statearr_85291_85301 = state_85280__$1;
(statearr_85291_85301[(1)] = (4));

(statearr_85291_85301[(5)] = null);

} else {
throw ex85287;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__20477__auto____0 = (function (){
var statearr_85292 = [null,null,null,null,null,null,null,null];
(statearr_85292[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__20477__auto__);

(statearr_85292[(1)] = (1));

return statearr_85292;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__20477__auto____1 = (function (state_85280){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_85280);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e85293){var ex__20480__auto__ = e85293;
var statearr_85294_85302 = state_85280;
(statearr_85294_85302[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_85280[(4)]))){
var statearr_85295_85303 = state_85280;
(statearr_85295_85303[(1)] = cljs.core.first((state_85280[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__85304 = state_85280;
state_85280 = G__85304;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__20477__auto__ = function(state_85280){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__20477__auto____1.call(this,state_85280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_85296 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_85296[(6)] = c__20603__auto__);

return statearr_85296;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_85334){
var state_val_85335 = (state_85334[(1)]);
if((state_val_85335 === (7))){
var state_85334__$1 = state_85334;
var statearr_85336_85355 = state_85334__$1;
(statearr_85336_85355[(2)] = num);

(statearr_85336_85355[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85335 === (1))){
var state_85334__$1 = state_85334;
var statearr_85337_85356 = state_85334__$1;
(statearr_85337_85356[(2)] = null);

(statearr_85337_85356[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85335 === (4))){
var inst_85305 = (state_85334[(2)]);
var state_85334__$1 = state_85334;
var statearr_85338_85357 = state_85334__$1;
(statearr_85338_85357[(2)] = inst_85305);

(statearr_85338_85357[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85335 === (6))){
var state_85334__$1 = state_85334;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85334__$1,(9),num);
} else {
if((state_val_85335 === (3))){
var inst_85332 = (state_85334[(2)]);
var state_85334__$1 = state_85334;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85334__$1,inst_85332);
} else {
if((state_val_85335 === (2))){
var _ = (function (){var statearr_85340 = state_85334;
(statearr_85340[(4)] = cljs.core.cons((5),(state_85334[(4)])));

return statearr_85340;
})();
var inst_85311 = fluree.db.util.async.channel_QMARK_(num);
var state_85334__$1 = state_85334;
if(inst_85311){
var statearr_85341_85358 = state_85334__$1;
(statearr_85341_85358[(1)] = (6));

} else {
var statearr_85342_85359 = state_85334__$1;
(statearr_85342_85359[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85335 === (9))){
var inst_85314 = (state_85334[(2)]);
var inst_85315 = fluree.db.util.async.throw_err(inst_85314);
var state_85334__$1 = state_85334;
var statearr_85343_85360 = state_85334__$1;
(statearr_85343_85360[(2)] = inst_85315);

(statearr_85343_85360[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85335 === (5))){
var _ = (function (){var statearr_85344 = state_85334;
(statearr_85344[(4)] = cljs.core.rest((state_85334[(4)])));

return statearr_85344;
})();
var state_85334__$1 = state_85334;
var ex85339 = (state_85334__$1[(2)]);
var statearr_85345_85361 = state_85334__$1;
(statearr_85345_85361[(5)] = ex85339);


if((ex85339 instanceof Error)){
var statearr_85346_85362 = state_85334__$1;
(statearr_85346_85362[(1)] = (4));

(statearr_85346_85362[(5)] = null);

} else {
throw ex85339;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85335 === (8))){
var inst_85318 = (state_85334[(2)]);
var inst_85319 = fluree.db.dbfunctions.internal.ceil(inst_85318);
var inst_85320 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85321 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_85322 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85323 = [fluree.db.dbfunctions.fns.ceil];
var inst_85324 = (new cljs.core.PersistentVector(null,1,(5),inst_85322,inst_85323,null));
var inst_85325 = ["",inst_85324,inst_85319];
var inst_85326 = cljs.core.PersistentHashMap.fromArrays(inst_85321,inst_85325);
var inst_85327 = [inst_85326,(10)];
var inst_85328 = (new cljs.core.PersistentVector(null,2,(5),inst_85320,inst_85327,null));
var inst_85329 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_85328);
var _ = (function (){var statearr_85347 = state_85334;
(statearr_85347[(4)] = cljs.core.rest((state_85334[(4)])));

return statearr_85347;
})();
var state_85334__$1 = (function (){var statearr_85348 = state_85334;
(statearr_85348[(7)] = inst_85329);

return statearr_85348;
})();
var statearr_85349_85363 = state_85334__$1;
(statearr_85349_85363[(2)] = inst_85319);

(statearr_85349_85363[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__20477__auto____0 = (function (){
var statearr_85350 = [null,null,null,null,null,null,null,null];
(statearr_85350[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__20477__auto__);

(statearr_85350[(1)] = (1));

return statearr_85350;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__20477__auto____1 = (function (state_85334){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_85334);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e85351){var ex__20480__auto__ = e85351;
var statearr_85352_85364 = state_85334;
(statearr_85352_85364[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_85334[(4)]))){
var statearr_85353_85365 = state_85334;
(statearr_85353_85365[(1)] = cljs.core.first((state_85334[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__85366 = state_85334;
state_85334 = G__85366;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__20477__auto__ = function(state_85334){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__20477__auto____1.call(this,state_85334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_85354 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_85354[(6)] = c__20603__auto__);

return statearr_85354;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_85396){
var state_val_85397 = (state_85396[(1)]);
if((state_val_85397 === (7))){
var state_85396__$1 = state_85396;
var statearr_85398_85417 = state_85396__$1;
(statearr_85398_85417[(2)] = num);

(statearr_85398_85417[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85397 === (1))){
var state_85396__$1 = state_85396;
var statearr_85399_85418 = state_85396__$1;
(statearr_85399_85418[(2)] = null);

(statearr_85399_85418[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85397 === (4))){
var inst_85367 = (state_85396[(2)]);
var state_85396__$1 = state_85396;
var statearr_85400_85419 = state_85396__$1;
(statearr_85400_85419[(2)] = inst_85367);

(statearr_85400_85419[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85397 === (6))){
var state_85396__$1 = state_85396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85396__$1,(9),num);
} else {
if((state_val_85397 === (3))){
var inst_85394 = (state_85396[(2)]);
var state_85396__$1 = state_85396;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85396__$1,inst_85394);
} else {
if((state_val_85397 === (2))){
var _ = (function (){var statearr_85402 = state_85396;
(statearr_85402[(4)] = cljs.core.cons((5),(state_85396[(4)])));

return statearr_85402;
})();
var inst_85373 = fluree.db.util.async.channel_QMARK_(num);
var state_85396__$1 = state_85396;
if(inst_85373){
var statearr_85403_85420 = state_85396__$1;
(statearr_85403_85420[(1)] = (6));

} else {
var statearr_85404_85421 = state_85396__$1;
(statearr_85404_85421[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85397 === (9))){
var inst_85376 = (state_85396[(2)]);
var inst_85377 = fluree.db.util.async.throw_err(inst_85376);
var state_85396__$1 = state_85396;
var statearr_85405_85422 = state_85396__$1;
(statearr_85405_85422[(2)] = inst_85377);

(statearr_85405_85422[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85397 === (5))){
var _ = (function (){var statearr_85406 = state_85396;
(statearr_85406[(4)] = cljs.core.rest((state_85396[(4)])));

return statearr_85406;
})();
var state_85396__$1 = state_85396;
var ex85401 = (state_85396__$1[(2)]);
var statearr_85407_85423 = state_85396__$1;
(statearr_85407_85423[(5)] = ex85401);


if((ex85401 instanceof Error)){
var statearr_85408_85424 = state_85396__$1;
(statearr_85408_85424[(1)] = (4));

(statearr_85408_85424[(5)] = null);

} else {
throw ex85401;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85397 === (8))){
var inst_85380 = (state_85396[(2)]);
var inst_85381 = fluree.db.dbfunctions.internal.floor(inst_85380);
var inst_85382 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85383 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_85384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85385 = [fluree.db.dbfunctions.fns.floor];
var inst_85386 = (new cljs.core.PersistentVector(null,1,(5),inst_85384,inst_85385,null));
var inst_85387 = ["",inst_85386,inst_85381];
var inst_85388 = cljs.core.PersistentHashMap.fromArrays(inst_85383,inst_85387);
var inst_85389 = [inst_85388,(10)];
var inst_85390 = (new cljs.core.PersistentVector(null,2,(5),inst_85382,inst_85389,null));
var inst_85391 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_85390);
var _ = (function (){var statearr_85409 = state_85396;
(statearr_85409[(4)] = cljs.core.rest((state_85396[(4)])));

return statearr_85409;
})();
var state_85396__$1 = (function (){var statearr_85410 = state_85396;
(statearr_85410[(7)] = inst_85391);

return statearr_85410;
})();
var statearr_85411_85425 = state_85396__$1;
(statearr_85411_85425[(2)] = inst_85381);

(statearr_85411_85425[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__20477__auto____0 = (function (){
var statearr_85412 = [null,null,null,null,null,null,null,null];
(statearr_85412[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__20477__auto__);

(statearr_85412[(1)] = (1));

return statearr_85412;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__20477__auto____1 = (function (state_85396){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_85396);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e85413){var ex__20480__auto__ = e85413;
var statearr_85414_85426 = state_85396;
(statearr_85414_85426[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_85396[(4)]))){
var statearr_85415_85427 = state_85396;
(statearr_85415_85427[(1)] = cljs.core.first((state_85396[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__85428 = state_85396;
state_85396 = G__85428;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__20477__auto__ = function(state_85396){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__20477__auto____1.call(this,state_85396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_85416 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_85416[(6)] = c__20603__auto__);

return statearr_85416;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_85453){
var state_val_85454 = (state_85453[(1)]);
if((state_val_85454 === (1))){
var state_85453__$1 = state_85453;
var statearr_85455_85470 = state_85453__$1;
(statearr_85455_85470[(2)] = null);

(statearr_85455_85470[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85454 === (2))){
var _ = (function (){var statearr_85456 = state_85453;
(statearr_85456[(4)] = cljs.core.cons((5),(state_85453[(4)])));

return statearr_85456;
})();
var inst_85435 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_85453__$1 = state_85453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85453__$1,(6),inst_85435);
} else {
if((state_val_85454 === (3))){
var inst_85451 = (state_85453[(2)]);
var state_85453__$1 = state_85453;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85453__$1,inst_85451);
} else {
if((state_val_85454 === (4))){
var inst_85429 = (state_85453[(2)]);
var state_85453__$1 = state_85453;
var statearr_85458_85471 = state_85453__$1;
(statearr_85458_85471[(2)] = inst_85429);

(statearr_85458_85471[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85454 === (5))){
var _ = (function (){var statearr_85459 = state_85453;
(statearr_85459[(4)] = cljs.core.rest((state_85453[(4)])));

return statearr_85459;
})();
var state_85453__$1 = state_85453;
var ex85457 = (state_85453__$1[(2)]);
var statearr_85460_85472 = state_85453__$1;
(statearr_85460_85472[(5)] = ex85457);


if((ex85457 instanceof Error)){
var statearr_85461_85473 = state_85453__$1;
(statearr_85461_85473[(1)] = (4));

(statearr_85461_85473[(5)] = null);

} else {
throw ex85457;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85454 === (6))){
var inst_85437 = (state_85453[(2)]);
var inst_85438 = fluree.db.util.async.throw_err(inst_85437);
var inst_85439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85440 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_85441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85442 = [compare_val,new_val];
var inst_85443 = (new cljs.core.PersistentVector(null,2,(5),inst_85441,inst_85442,null));
var inst_85444 = ["",inst_85443,inst_85438];
var inst_85445 = cljs.core.PersistentHashMap.fromArrays(inst_85440,inst_85444);
var inst_85446 = [inst_85445,(10)];
var inst_85447 = (new cljs.core.PersistentVector(null,2,(5),inst_85439,inst_85446,null));
var inst_85448 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_85447);
var _ = (function (){var statearr_85462 = state_85453;
(statearr_85462[(4)] = cljs.core.rest((state_85453[(4)])));

return statearr_85462;
})();
var state_85453__$1 = (function (){var statearr_85463 = state_85453;
(statearr_85463[(7)] = inst_85448);

return statearr_85463;
})();
var statearr_85464_85474 = state_85453__$1;
(statearr_85464_85474[(2)] = inst_85438);

(statearr_85464_85474[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__20477__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__20477__auto____0 = (function (){
var statearr_85465 = [null,null,null,null,null,null,null,null];
(statearr_85465[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__20477__auto__);

(statearr_85465[(1)] = (1));

return statearr_85465;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__20477__auto____1 = (function (state_85453){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_85453);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e85466){var ex__20480__auto__ = e85466;
var statearr_85467_85475 = state_85453;
(statearr_85467_85475[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_85453[(4)]))){
var statearr_85468_85476 = state_85453;
(statearr_85468_85476[(1)] = cljs.core.first((state_85453[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__85477 = state_85453;
state_85453 = G__85477;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__20477__auto__ = function(state_85453){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__20477__auto____1.call(this,state_85453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__20477__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__20477__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_85469 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_85469[(6)] = c__20603__auto__);

return statearr_85469;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
