// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__86525_86694 = cljs.core.seq(servers);
var chunk__86526_86695 = null;
var count__86527_86696 = (0);
var i__86528_86697 = (0);
while(true){
if((i__86528_86697 < count__86527_86696)){
var server_86698 = chunk__86526_86695.cljs$core$IIndexed$_nth$arity$2(null,i__86528_86697);
var healthcheck_uri_86699 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_86698),"/fdb/health"].join('');
var resp_chan_86700 = fluree.db.util.xhttp.post_json(healthcheck_uri_86699,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__20603__auto___86701 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__86525_86694,chunk__86526_86695,count__86527_86696,i__86528_86697,c__20603__auto___86701,healthcheck_uri_86699,resp_chan_86700,server_86698){
return (function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = ((function (seq__86525_86694,chunk__86526_86695,count__86527_86696,i__86528_86697,c__20603__auto___86701,healthcheck_uri_86699,resp_chan_86700,server_86698){
return (function (state_86589){
var state_val_86590 = (state_86589[(1)]);
if((state_val_86590 === (1))){
var state_86589__$1 = state_86589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86589__$1,(2),resp_chan_86700);
} else {
if((state_val_86590 === (2))){
var inst_86578 = (state_86589[(7)]);
var inst_86578__$1 = (state_86589[(2)]);
var inst_86579 = fluree.db.util.core.exception_QMARK_(inst_86578__$1);
var state_86589__$1 = (function (){var statearr_86591 = state_86589;
(statearr_86591[(7)] = inst_86578__$1);

return statearr_86591;
})();
if(inst_86579){
var statearr_86592_86702 = state_86589__$1;
(statearr_86592_86702[(1)] = (3));

} else {
var statearr_86593_86703 = state_86589__$1;
(statearr_86593_86703[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86590 === (3))){
var inst_86578 = (state_86589[(7)]);
var inst_86581 = cljs.core.ex_message(inst_86578);
var inst_86582 = cljs.core.ex_data(inst_86578);
var inst_86583 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_86581,inst_86582], 0));
var state_86589__$1 = state_86589;
var statearr_86594_86704 = state_86589__$1;
(statearr_86594_86704[(2)] = inst_86583);

(statearr_86594_86704[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86590 === (4))){
var inst_86585 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_86698);
var state_86589__$1 = state_86589;
var statearr_86595_86705 = state_86589__$1;
(statearr_86595_86705[(2)] = inst_86585);

(statearr_86595_86705[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86590 === (5))){
var inst_86587 = (state_86589[(2)]);
var state_86589__$1 = state_86589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86589__$1,inst_86587);
} else {
return null;
}
}
}
}
}
});})(seq__86525_86694,chunk__86526_86695,count__86527_86696,i__86528_86697,c__20603__auto___86701,healthcheck_uri_86699,resp_chan_86700,server_86698))
;
return ((function (seq__86525_86694,chunk__86526_86695,count__86527_86696,i__86528_86697,switch__20476__auto__,c__20603__auto___86701,healthcheck_uri_86699,resp_chan_86700,server_86698){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____0 = (function (){
var statearr_86596 = [null,null,null,null,null,null,null,null];
(statearr_86596[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__);

(statearr_86596[(1)] = (1));

return statearr_86596;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____1 = (function (state_86589){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_86589);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e86597){var ex__20480__auto__ = e86597;
var statearr_86598_86706 = state_86589;
(statearr_86598_86706[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_86589[(4)]))){
var statearr_86599_86707 = state_86589;
(statearr_86599_86707[(1)] = cljs.core.first((state_86589[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__86708 = state_86589;
state_86589 = G__86708;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__ = function(state_86589){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____1.call(this,state_86589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__;
})()
;})(seq__86525_86694,chunk__86526_86695,count__86527_86696,i__86528_86697,switch__20476__auto__,c__20603__auto___86701,healthcheck_uri_86699,resp_chan_86700,server_86698))
})();
var state__20605__auto__ = (function (){var statearr_86600 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_86600[(6)] = c__20603__auto___86701);

return statearr_86600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
});})(seq__86525_86694,chunk__86526_86695,count__86527_86696,i__86528_86697,c__20603__auto___86701,healthcheck_uri_86699,resp_chan_86700,server_86698))
);



var G__86709 = seq__86525_86694;
var G__86710 = chunk__86526_86695;
var G__86711 = count__86527_86696;
var G__86712 = (i__86528_86697 + (1));
seq__86525_86694 = G__86709;
chunk__86526_86695 = G__86710;
count__86527_86696 = G__86711;
i__86528_86697 = G__86712;
continue;
} else {
var temp__5753__auto___86713 = cljs.core.seq(seq__86525_86694);
if(temp__5753__auto___86713){
var seq__86525_86714__$1 = temp__5753__auto___86713;
if(cljs.core.chunked_seq_QMARK_(seq__86525_86714__$1)){
var c__4649__auto___86715 = cljs.core.chunk_first(seq__86525_86714__$1);
var G__86716 = cljs.core.chunk_rest(seq__86525_86714__$1);
var G__86717 = c__4649__auto___86715;
var G__86718 = cljs.core.count(c__4649__auto___86715);
var G__86719 = (0);
seq__86525_86694 = G__86716;
chunk__86526_86695 = G__86717;
count__86527_86696 = G__86718;
i__86528_86697 = G__86719;
continue;
} else {
var server_86720 = cljs.core.first(seq__86525_86714__$1);
var healthcheck_uri_86721 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_86720),"/fdb/health"].join('');
var resp_chan_86722 = fluree.db.util.xhttp.post_json(healthcheck_uri_86721,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__20603__auto___86723 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__86525_86694,chunk__86526_86695,count__86527_86696,i__86528_86697,c__20603__auto___86723,healthcheck_uri_86721,resp_chan_86722,server_86720,seq__86525_86714__$1,temp__5753__auto___86713){
return (function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = ((function (seq__86525_86694,chunk__86526_86695,count__86527_86696,i__86528_86697,c__20603__auto___86723,healthcheck_uri_86721,resp_chan_86722,server_86720,seq__86525_86714__$1,temp__5753__auto___86713){
return (function (state_86613){
var state_val_86614 = (state_86613[(1)]);
if((state_val_86614 === (1))){
var state_86613__$1 = state_86613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86613__$1,(2),resp_chan_86722);
} else {
if((state_val_86614 === (2))){
var inst_86602 = (state_86613[(7)]);
var inst_86602__$1 = (state_86613[(2)]);
var inst_86603 = fluree.db.util.core.exception_QMARK_(inst_86602__$1);
var state_86613__$1 = (function (){var statearr_86615 = state_86613;
(statearr_86615[(7)] = inst_86602__$1);

return statearr_86615;
})();
if(inst_86603){
var statearr_86616_86724 = state_86613__$1;
(statearr_86616_86724[(1)] = (3));

} else {
var statearr_86617_86725 = state_86613__$1;
(statearr_86617_86725[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86614 === (3))){
var inst_86602 = (state_86613[(7)]);
var inst_86605 = cljs.core.ex_message(inst_86602);
var inst_86606 = cljs.core.ex_data(inst_86602);
var inst_86607 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_86605,inst_86606], 0));
var state_86613__$1 = state_86613;
var statearr_86618_86726 = state_86613__$1;
(statearr_86618_86726[(2)] = inst_86607);

(statearr_86618_86726[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86614 === (4))){
var inst_86609 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_86720);
var state_86613__$1 = state_86613;
var statearr_86619_86727 = state_86613__$1;
(statearr_86619_86727[(2)] = inst_86609);

(statearr_86619_86727[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86614 === (5))){
var inst_86611 = (state_86613[(2)]);
var state_86613__$1 = state_86613;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86613__$1,inst_86611);
} else {
return null;
}
}
}
}
}
});})(seq__86525_86694,chunk__86526_86695,count__86527_86696,i__86528_86697,c__20603__auto___86723,healthcheck_uri_86721,resp_chan_86722,server_86720,seq__86525_86714__$1,temp__5753__auto___86713))
;
return ((function (seq__86525_86694,chunk__86526_86695,count__86527_86696,i__86528_86697,switch__20476__auto__,c__20603__auto___86723,healthcheck_uri_86721,resp_chan_86722,server_86720,seq__86525_86714__$1,temp__5753__auto___86713){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____0 = (function (){
var statearr_86620 = [null,null,null,null,null,null,null,null];
(statearr_86620[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__);

(statearr_86620[(1)] = (1));

return statearr_86620;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____1 = (function (state_86613){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_86613);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e86621){var ex__20480__auto__ = e86621;
var statearr_86622_86728 = state_86613;
(statearr_86622_86728[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_86613[(4)]))){
var statearr_86623_86729 = state_86613;
(statearr_86623_86729[(1)] = cljs.core.first((state_86613[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__86730 = state_86613;
state_86613 = G__86730;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__ = function(state_86613){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____1.call(this,state_86613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__;
})()
;})(seq__86525_86694,chunk__86526_86695,count__86527_86696,i__86528_86697,switch__20476__auto__,c__20603__auto___86723,healthcheck_uri_86721,resp_chan_86722,server_86720,seq__86525_86714__$1,temp__5753__auto___86713))
})();
var state__20605__auto__ = (function (){var statearr_86624 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_86624[(6)] = c__20603__auto___86723);

return statearr_86624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
});})(seq__86525_86694,chunk__86526_86695,count__86527_86696,i__86528_86697,c__20603__auto___86723,healthcheck_uri_86721,resp_chan_86722,server_86720,seq__86525_86714__$1,temp__5753__auto___86713))
);



var G__86731 = cljs.core.next(seq__86525_86714__$1);
var G__86732 = null;
var G__86733 = (0);
var G__86734 = (0);
seq__86525_86694 = G__86731;
chunk__86526_86695 = G__86732;
count__86527_86696 = G__86733;
i__86528_86697 = G__86734;
continue;
}
} else {
}
}
break;
}

var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_86668){
var state_val_86669 = (state_86668[(1)]);
if((state_val_86669 === (7))){
var inst_86640 = (state_86668[(7)]);
var inst_86647 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_86640,cljs.core.cst$kw$default);
var state_86668__$1 = state_86668;
if(inst_86647){
var statearr_86670_86735 = state_86668__$1;
(statearr_86670_86735[(1)] = (9));

} else {
var statearr_86671_86736 = state_86668__$1;
(statearr_86671_86736[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86669 === (1))){
var inst_86633 = (state_86668[(8)]);
var inst_86632 = (state_86668[(9)]);
var inst_86632__$1 = promise_chan;
var inst_86633__$1 = cljs.core.async.timeout((60000));
var inst_86634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_86635 = [inst_86632__$1,inst_86633__$1];
var inst_86636 = (new cljs.core.PersistentVector(null,2,(5),inst_86634,inst_86635,null));
var state_86668__$1 = (function (){var statearr_86672 = state_86668;
(statearr_86672[(8)] = inst_86633__$1);

(statearr_86672[(9)] = inst_86632__$1);

return statearr_86672;
})();
return cljs.core.async.ioc_alts_BANG_(state_86668__$1,(2),inst_86636);
} else {
if((state_val_86669 === (4))){
var inst_86633 = (state_86668[(8)]);
var inst_86640 = (state_86668[(7)]);
var inst_86644 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_86640,inst_86633);
var state_86668__$1 = state_86668;
if(inst_86644){
var statearr_86673_86737 = state_86668__$1;
(statearr_86673_86737[(1)] = (6));

} else {
var statearr_86674_86738 = state_86668__$1;
(statearr_86674_86738[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86669 === (13))){
var state_86668__$1 = state_86668;
var statearr_86675_86739 = state_86668__$1;
(statearr_86675_86739[(2)] = null);

(statearr_86675_86739[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86669 === (6))){
var state_86668__$1 = state_86668;
var statearr_86676_86740 = state_86668__$1;
(statearr_86676_86740[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_86676_86740[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86669 === (3))){
var state_86668__$1 = state_86668;
var statearr_86677_86741 = state_86668__$1;
(statearr_86677_86741[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_86677_86741[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86669 === (12))){
var inst_86658 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_86659 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_86660 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_86661 = cljs.core.PersistentHashMap.fromArrays(inst_86659,inst_86660);
var inst_86662 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_86661);
var inst_86663 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_86662);
var state_86668__$1 = (function (){var statearr_86678 = state_86668;
(statearr_86678[(10)] = inst_86658);

return statearr_86678;
})();
var statearr_86679_86742 = state_86668__$1;
(statearr_86679_86742[(2)] = inst_86663);

(statearr_86679_86742[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86669 === (2))){
var inst_86640 = (state_86668[(7)]);
var inst_86632 = (state_86668[(9)]);
var inst_86638 = (state_86668[(2)]);
var inst_86639 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_86638,(0),null);
var inst_86640__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_86638,(1),null);
var inst_86641 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_86640__$1,inst_86632);
var state_86668__$1 = (function (){var statearr_86680 = state_86668;
(statearr_86680[(7)] = inst_86640__$1);

(statearr_86680[(11)] = inst_86639);

return statearr_86680;
})();
if(inst_86641){
var statearr_86681_86743 = state_86668__$1;
(statearr_86681_86743[(1)] = (3));

} else {
var statearr_86682_86744 = state_86668__$1;
(statearr_86682_86744[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86669 === (11))){
var inst_86651 = (state_86668[(2)]);
var state_86668__$1 = state_86668;
var statearr_86683_86745 = state_86668__$1;
(statearr_86683_86745[(2)] = inst_86651);

(statearr_86683_86745[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86669 === (9))){
var inst_86639 = (state_86668[(11)]);
var state_86668__$1 = state_86668;
var statearr_86684_86746 = state_86668__$1;
(statearr_86684_86746[(2)] = inst_86639);

(statearr_86684_86746[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86669 === (5))){
var inst_86655 = (state_86668[(2)]);
var inst_86656 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_86655);
var state_86668__$1 = state_86668;
if(inst_86656){
var statearr_86685_86747 = state_86668__$1;
(statearr_86685_86747[(1)] = (12));

} else {
var statearr_86686_86748 = state_86668__$1;
(statearr_86686_86748[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86669 === (14))){
var inst_86666 = (state_86668[(2)]);
var state_86668__$1 = state_86668;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86668__$1,inst_86666);
} else {
if((state_val_86669 === (10))){
var state_86668__$1 = state_86668;
var statearr_86687_86749 = state_86668__$1;
(statearr_86687_86749[(2)] = null);

(statearr_86687_86749[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86669 === (8))){
var inst_86653 = (state_86668[(2)]);
var state_86668__$1 = state_86668;
var statearr_86688_86750 = state_86668__$1;
(statearr_86688_86750[(2)] = inst_86653);

(statearr_86688_86750[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____0 = (function (){
var statearr_86689 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_86689[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__);

(statearr_86689[(1)] = (1));

return statearr_86689;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____1 = (function (state_86668){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_86668);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e86690){var ex__20480__auto__ = e86690;
var statearr_86691_86751 = state_86668;
(statearr_86691_86751[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_86668[(4)]))){
var statearr_86692_86752 = state_86668;
(statearr_86692_86752[(1)] = cljs.core.first((state_86668[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__86753 = state_86668;
state_86668 = G__86753;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__ = function(state_86668){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____1.call(this,state_86668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_86693 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_86693[(6)] = c__20603__auto__);

return statearr_86693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_86797){
var state_val_86798 = (state_86797[(1)]);
if((state_val_86798 === (7))){
var state_86797__$1 = state_86797;
var statearr_86799_86825 = state_86797__$1;
(statearr_86799_86825[(2)] = null);

(statearr_86799_86825[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86798 === (1))){
var state_86797__$1 = state_86797;
var statearr_86800_86826 = state_86797__$1;
(statearr_86800_86826[(2)] = null);

(statearr_86800_86826[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86798 === (4))){
var inst_86754 = (state_86797[(2)]);
var state_86797__$1 = state_86797;
var statearr_86801_86827 = state_86797__$1;
(statearr_86801_86827[(2)] = inst_86754);

(statearr_86801_86827[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86798 === (6))){
var inst_86776 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_86797__$1 = state_86797;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86797__$1,(9),inst_86776);
} else {
if((state_val_86798 === (3))){
var inst_86795 = (state_86797[(2)]);
var state_86797__$1 = state_86797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86797__$1,inst_86795);
} else {
if((state_val_86798 === (12))){
var inst_86789 = (state_86797[(2)]);
var state_86797__$1 = state_86797;
var statearr_86802_86828 = state_86797__$1;
(statearr_86802_86828[(2)] = inst_86789);

(statearr_86802_86828[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86798 === (2))){
var inst_86760 = (state_86797[(7)]);
var inst_86770 = (state_86797[(8)]);
var inst_86765 = (state_86797[(9)]);
var _ = (function (){var statearr_86803 = state_86797;
(statearr_86803[(4)] = cljs.core.cons((5),(state_86797[(4)])));

return statearr_86803;
})();
var inst_86760__$1 = fluree.db.util.core.random_uuid();
var inst_86761 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_86762 = [conn_id,cljs.core.cst$kw$ws];
var inst_86763 = (new cljs.core.PersistentVector(null,2,(5),inst_86761,inst_86762,null));
var inst_86764 = (function (){var lock_id = inst_86760__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_86765__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_86763,inst_86764);
var inst_86766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_86767 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_86768 = (new cljs.core.PersistentVector(null,3,(5),inst_86766,inst_86767,null));
var inst_86769 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_86765__$1,inst_86768);
var inst_86770__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_86760__$1,inst_86769);
var inst_86771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_86772 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_86773 = (new cljs.core.PersistentVector(null,3,(5),inst_86771,inst_86772,null));
var inst_86774 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_86765__$1,inst_86773);
var state_86797__$1 = (function (){var statearr_86804 = state_86797;
(statearr_86804[(7)] = inst_86760__$1);

(statearr_86804[(8)] = inst_86770__$1);

(statearr_86804[(10)] = inst_86774);

(statearr_86804[(9)] = inst_86765__$1);

return statearr_86804;
})();
if(inst_86770__$1){
var statearr_86805_86829 = state_86797__$1;
(statearr_86805_86829[(1)] = (6));

} else {
var statearr_86806_86830 = state_86797__$1;
(statearr_86806_86830[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86798 === (11))){
var inst_86781 = (state_86797[(11)]);
var inst_86774 = (state_86797[(10)]);
var inst_86780 = (state_86797[(12)]);
var inst_86787 = fluree.db.util.xhttp.try_socket(inst_86780,sub_chan,pub_chan,inst_86774,(60000),inst_86781);
var state_86797__$1 = state_86797;
var statearr_86808_86831 = state_86797__$1;
(statearr_86808_86831[(2)] = inst_86787);

(statearr_86808_86831[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86798 === (9))){
var inst_86760 = (state_86797[(7)]);
var inst_86770 = (state_86797[(8)]);
var inst_86778 = (state_86797[(13)]);
var inst_86774 = (state_86797[(10)]);
var inst_86765 = (state_86797[(9)]);
var inst_86780 = (state_86797[(12)]);
var inst_86778__$1 = (state_86797[(2)]);
var inst_86779 = clojure.string.replace(inst_86778__$1,"http","ws");
var inst_86780__$1 = [inst_86779,"/fdb/ws"].join('');
var inst_86781 = (function (){var lock_id = inst_86760;
var state = inst_86765;
var have_lock_QMARK_ = inst_86770;
var resp_chan = inst_86774;
var healthy_server = inst_86778__$1;
var ws_url = inst_86780__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_86782 = fluree.db.util.core.exception_QMARK_(inst_86778__$1);
var state_86797__$1 = (function (){var statearr_86809 = state_86797;
(statearr_86809[(13)] = inst_86778__$1);

(statearr_86809[(11)] = inst_86781);

(statearr_86809[(12)] = inst_86780__$1);

return statearr_86809;
})();
if(inst_86782){
var statearr_86810_86832 = state_86797__$1;
(statearr_86810_86832[(1)] = (10));

} else {
var statearr_86811_86833 = state_86797__$1;
(statearr_86811_86833[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86798 === (5))){
var _ = (function (){var statearr_86812 = state_86797;
(statearr_86812[(4)] = cljs.core.rest((state_86797[(4)])));

return statearr_86812;
})();
var state_86797__$1 = state_86797;
var ex86807 = (state_86797__$1[(2)]);
var statearr_86813_86834 = state_86797__$1;
(statearr_86813_86834[(5)] = ex86807);


if((ex86807 instanceof Error)){
var statearr_86814_86835 = state_86797__$1;
(statearr_86814_86835[(1)] = (4));

(statearr_86814_86835[(5)] = null);

} else {
throw ex86807;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86798 === (10))){
var inst_86778 = (state_86797[(13)]);
var inst_86774 = (state_86797[(10)]);
var inst_86784 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_86785 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_86774,inst_86778);
var state_86797__$1 = (function (){var statearr_86815 = state_86797;
(statearr_86815[(14)] = inst_86784);

return statearr_86815;
})();
var statearr_86816_86836 = state_86797__$1;
(statearr_86816_86836[(2)] = inst_86785);

(statearr_86816_86836[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86798 === (8))){
var inst_86774 = (state_86797[(10)]);
var inst_86792 = (state_86797[(2)]);
var _ = (function (){var statearr_86817 = state_86797;
(statearr_86817[(4)] = cljs.core.rest((state_86797[(4)])));

return statearr_86817;
})();
var state_86797__$1 = (function (){var statearr_86818 = state_86797;
(statearr_86818[(15)] = inst_86792);

return statearr_86818;
})();
var statearr_86819_86837 = state_86797__$1;
(statearr_86819_86837[(2)] = inst_86774);

(statearr_86819_86837[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__20477__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__20477__auto____0 = (function (){
var statearr_86820 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_86820[(0)] = fluree$db$connection$establish_socket_$_state_machine__20477__auto__);

(statearr_86820[(1)] = (1));

return statearr_86820;
});
var fluree$db$connection$establish_socket_$_state_machine__20477__auto____1 = (function (state_86797){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_86797);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e86821){var ex__20480__auto__ = e86821;
var statearr_86822_86838 = state_86797;
(statearr_86822_86838[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_86797[(4)]))){
var statearr_86823_86839 = state_86797;
(statearr_86823_86839[(1)] = cljs.core.first((state_86797[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__86840 = state_86797;
state_86797 = G__86840;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__20477__auto__ = function(state_86797){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__20477__auto____1.call(this,state_86797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__20477__auto____0;
fluree$db$connection$establish_socket_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__20477__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_86824 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_86824[(6)] = c__20603__auto__);

return statearr_86824;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4472__auto__,k__4473__auto__){
var self__ = this;
var this__4472__auto____$1 = this;
return this__4472__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4473__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4474__auto__,k86842,else__4475__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
var G__86846 = k86842;
var G__86846__$1 = (((G__86846 instanceof cljs.core.Keyword))?G__86846.fqn:null);
switch (G__86846__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k86842,else__4475__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4492__auto__,f__4493__auto__,init__4494__auto__){
var self__ = this;
var this__4492__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4495__auto__,p__86847){
var vec__86848 = p__86847;
var k__4496__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86848,(0),null);
var v__4497__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__86848,(1),null);
return (f__4493__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4493__auto__.cljs$core$IFn$_invoke$arity$3(ret__4495__auto__,k__4496__auto__,v__4497__auto__) : f__4493__auto__.call(null,ret__4495__auto__,k__4496__auto__,v__4497__auto__));
}),init__4494__auto__,this__4492__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4487__auto__,writer__4488__auto__,opts__4489__auto__){
var self__ = this;
var this__4487__auto____$1 = this;
var pr_pair__4490__auto__ = (function (keyval__4491__auto__){
return cljs.core.pr_sequential_writer(writer__4488__auto__,cljs.core.pr_writer,""," ","",opts__4489__auto__,keyval__4491__auto__);
});
return cljs.core.pr_sequential_writer(writer__4488__auto__,pr_pair__4490__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4489__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__86841){
var self__ = this;
var G__86841__$1 = this;
return (new cljs.core.RecordIter((0),G__86841__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4470__auto__){
var self__ = this;
var this__4470__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4467__auto__){
var self__ = this;
var this__4467__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4476__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4468__auto__){
var self__ = this;
var this__4468__auto____$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = (function (){var fexpr__86851 = (function (coll__4469__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4469__auto__));
});
return fexpr__86851(this__4468__auto____$1);
})();
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this86843,other86844){
var self__ = this;
var this86843__$1 = this;
return (((!((other86844 == null)))) && ((((this86843__$1.constructor === other86844.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.id,other86844.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.servers,other86844.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.state,other86844.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.req_chan,other86844.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.sub_chan,other86844.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.pub_chan,other86844.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.storage_read,other86844.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.storage_write,other86844.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.object_cache,other86844.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.parallelism,other86844.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.serializer,other86844.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.default_network,other86844.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.transactor_QMARK_,other86844.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.publish,other86844.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.transact_handler,other86844.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.tx_private_key,other86844.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.tx_key_id,other86844.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.meta,other86844.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.add_listener,other86844.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.remove_listener,other86844.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.close,other86844.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this86843__$1.__extmap,other86844.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4482__auto__,k__4483__auto__){
var self__ = this;
var this__4482__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__4483__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4482__auto____$1),self__.__meta),k__4483__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4483__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4479__auto__,k86842){
var self__ = this;
var this__4479__auto____$1 = this;
var G__86852 = k86842;
var G__86852__$1 = (((G__86852 instanceof cljs.core.Keyword))?G__86852.fqn:null);
switch (G__86852__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k86842);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4480__auto__,k__4481__auto__,G__86841){
var self__ = this;
var this__4480__auto____$1 = this;
var pred__86853 = cljs.core.keyword_identical_QMARK_;
var expr__86854 = k__4481__auto__;
if(cljs.core.truth_((function (){var G__86856 = cljs.core.cst$kw$id;
var G__86857 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86856,G__86857) : pred__86853.call(null,G__86856,G__86857));
})())){
return (new fluree.db.connection.Connection(G__86841,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86858 = cljs.core.cst$kw$servers;
var G__86859 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86858,G__86859) : pred__86853.call(null,G__86858,G__86859));
})())){
return (new fluree.db.connection.Connection(self__.id,G__86841,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86860 = cljs.core.cst$kw$state;
var G__86861 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86860,G__86861) : pred__86853.call(null,G__86860,G__86861));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__86841,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86862 = cljs.core.cst$kw$req_DASH_chan;
var G__86863 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86862,G__86863) : pred__86853.call(null,G__86862,G__86863));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__86841,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86864 = cljs.core.cst$kw$sub_DASH_chan;
var G__86865 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86864,G__86865) : pred__86853.call(null,G__86864,G__86865));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__86841,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86866 = cljs.core.cst$kw$pub_DASH_chan;
var G__86867 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86866,G__86867) : pred__86853.call(null,G__86866,G__86867));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__86841,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86868 = cljs.core.cst$kw$storage_DASH_read;
var G__86869 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86868,G__86869) : pred__86853.call(null,G__86868,G__86869));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__86841,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86870 = cljs.core.cst$kw$storage_DASH_write;
var G__86871 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86870,G__86871) : pred__86853.call(null,G__86870,G__86871));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__86841,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86872 = cljs.core.cst$kw$object_DASH_cache;
var G__86873 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86872,G__86873) : pred__86853.call(null,G__86872,G__86873));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__86841,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86874 = cljs.core.cst$kw$parallelism;
var G__86875 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86874,G__86875) : pred__86853.call(null,G__86874,G__86875));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__86841,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86876 = cljs.core.cst$kw$serializer;
var G__86877 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86876,G__86877) : pred__86853.call(null,G__86876,G__86877));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__86841,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86878 = cljs.core.cst$kw$default_DASH_network;
var G__86879 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86878,G__86879) : pred__86853.call(null,G__86878,G__86879));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__86841,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86880 = cljs.core.cst$kw$transactor_QMARK_;
var G__86881 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86880,G__86881) : pred__86853.call(null,G__86880,G__86881));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__86841,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86882 = cljs.core.cst$kw$publish;
var G__86883 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86882,G__86883) : pred__86853.call(null,G__86882,G__86883));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__86841,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86884 = cljs.core.cst$kw$transact_DASH_handler;
var G__86885 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86884,G__86885) : pred__86853.call(null,G__86884,G__86885));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__86841,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86886 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__86887 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86886,G__86887) : pred__86853.call(null,G__86886,G__86887));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__86841,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86888 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__86889 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86888,G__86889) : pred__86853.call(null,G__86888,G__86889));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__86841,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86890 = cljs.core.cst$kw$meta;
var G__86891 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86890,G__86891) : pred__86853.call(null,G__86890,G__86891));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__86841,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86892 = cljs.core.cst$kw$add_DASH_listener;
var G__86893 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86892,G__86893) : pred__86853.call(null,G__86892,G__86893));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__86841,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86894 = cljs.core.cst$kw$remove_DASH_listener;
var G__86895 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86894,G__86895) : pred__86853.call(null,G__86894,G__86895));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__86841,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__86896 = cljs.core.cst$kw$close;
var G__86897 = expr__86854;
return (pred__86853.cljs$core$IFn$_invoke$arity$2 ? pred__86853.cljs$core$IFn$_invoke$arity$2(G__86896,G__86897) : pred__86853.call(null,G__86896,G__86897));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__86841,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4481__auto__,G__86841),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4485__auto__){
var self__ = this;
var this__4485__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4471__auto__,G__86841){
var self__ = this;
var this__4471__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__86841,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4477__auto__,entry__4478__auto__){
var self__ = this;
var this__4477__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4478__auto__)){
return this__4477__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4478__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4477__auto____$1,entry__4478__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4516__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4516__auto__,writer__4517__auto__){
return cljs.core._write(writer__4517__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__86845){
var extmap__4512__auto__ = (function (){var G__86898 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__86845,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__86845)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__86898);
} else {
return G__86898;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__86845),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__86845),null,cljs.core.not_empty(extmap__4512__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__86904 = servers_STAR_;
var vec__86905 = G__86904;
var seq__86906 = cljs.core.seq(vec__86905);
var first__86907 = cljs.core.first(seq__86906);
var seq__86906__$1 = cljs.core.next(seq__86906);
var server = first__86907;
var r = seq__86906__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__86904__$1 = G__86904;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__86911 = G__86904__$1;
var seq__86912 = cljs.core.seq(vec__86911);
var first__86913 = cljs.core.first(seq__86912);
var seq__86912__$1 = cljs.core.next(seq__86912);
var server__$1 = first__86913;
var r__$1 = seq__86912__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__4221__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4221__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__86914 = r__$1;
var G__86915 = is_https_QMARK_;
var G__86916 = result_STAR_;
G__86904__$1 = G__86914;
https_QMARK___$1 = G__86915;
result__$1 = G__86916;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__86917 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__86917 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__86917);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_86946){
var state_val_86947 = (state_86946[(1)]);
if((state_val_86947 === (7))){
var inst_86932 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_86933 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_86934 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_86935 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_86936 = fluree.db.connection.establish_socket(inst_86932,inst_86933,inst_86934,inst_86935);
var state_86946__$1 = state_86946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_86946__$1,(9),inst_86936);
} else {
if((state_val_86947 === (1))){
var state_86946__$1 = state_86946;
var statearr_86948_86967 = state_86946__$1;
(statearr_86948_86967[(2)] = null);

(statearr_86948_86967[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86947 === (4))){
var inst_86918 = (state_86946[(2)]);
var state_86946__$1 = state_86946;
var statearr_86949_86968 = state_86946__$1;
(statearr_86949_86968[(2)] = inst_86918);

(statearr_86949_86968[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86947 === (6))){
var inst_86929 = (state_86946[(7)]);
var state_86946__$1 = state_86946;
var statearr_86950_86969 = state_86946__$1;
(statearr_86950_86969[(2)] = inst_86929);

(statearr_86950_86969[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86947 === (3))){
var inst_86944 = (state_86946[(2)]);
var state_86946__$1 = state_86946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_86946__$1,inst_86944);
} else {
if((state_val_86947 === (2))){
var inst_86929 = (state_86946[(7)]);
var _ = (function (){var statearr_86952 = state_86946;
(statearr_86952[(4)] = cljs.core.cons((5),(state_86946[(4)])));

return statearr_86952;
})();
var inst_86924 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_86925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_86926 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_86927 = [inst_86926,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_86928 = (new cljs.core.PersistentVector(null,3,(5),inst_86925,inst_86927,null));
var inst_86929__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_86924,inst_86928);
var state_86946__$1 = (function (){var statearr_86953 = state_86946;
(statearr_86953[(7)] = inst_86929__$1);

return statearr_86953;
})();
if(cljs.core.truth_(inst_86929__$1)){
var statearr_86954_86970 = state_86946__$1;
(statearr_86954_86970[(1)] = (6));

} else {
var statearr_86955_86971 = state_86946__$1;
(statearr_86955_86971[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86947 === (9))){
var inst_86938 = (state_86946[(2)]);
var inst_86939 = fluree.db.util.async.throw_err(inst_86938);
var state_86946__$1 = state_86946;
var statearr_86956_86972 = state_86946__$1;
(statearr_86956_86972[(2)] = inst_86939);

(statearr_86956_86972[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_86947 === (5))){
var _ = (function (){var statearr_86957 = state_86946;
(statearr_86957[(4)] = cljs.core.rest((state_86946[(4)])));

return statearr_86957;
})();
var state_86946__$1 = state_86946;
var ex86951 = (state_86946__$1[(2)]);
var statearr_86958_86973 = state_86946__$1;
(statearr_86958_86973[(5)] = ex86951);


if((ex86951 instanceof Error)){
var statearr_86959_86974 = state_86946__$1;
(statearr_86959_86974[(1)] = (4));

(statearr_86959_86974[(5)] = null);

} else {
throw ex86951;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_86947 === (8))){
var inst_86941 = (state_86946[(2)]);
var _ = (function (){var statearr_86960 = state_86946;
(statearr_86960[(4)] = cljs.core.rest((state_86946[(4)])));

return statearr_86960;
})();
var state_86946__$1 = state_86946;
var statearr_86961_86975 = state_86946__$1;
(statearr_86961_86975[(2)] = inst_86941);

(statearr_86961_86975[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__20477__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__20477__auto____0 = (function (){
var statearr_86962 = [null,null,null,null,null,null,null,null];
(statearr_86962[(0)] = fluree$db$connection$get_socket_$_state_machine__20477__auto__);

(statearr_86962[(1)] = (1));

return statearr_86962;
});
var fluree$db$connection$get_socket_$_state_machine__20477__auto____1 = (function (state_86946){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_86946);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e86963){var ex__20480__auto__ = e86963;
var statearr_86964_86976 = state_86946;
(statearr_86964_86976[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_86946[(4)]))){
var statearr_86965_86977 = state_86946;
(statearr_86965_86977[(1)] = cljs.core.first((state_86946[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__86978 = state_86946;
state_86946 = G__86978;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__20477__auto__ = function(state_86946){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__20477__auto____1.call(this,state_86946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__20477__auto____0;
fluree$db$connection$get_socket_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__20477__auto____1;
return fluree$db$connection$get_socket_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_86966 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_86966[(6)] = c__20603__auto__);

return statearr_86966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4223__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e86979){var e = e86979;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4223__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_87106){
var state_val_87107 = (state_87106[(1)]);
if((state_val_87107 === (7))){
var inst_87102 = (state_87106[(2)]);
var state_87106__$1 = state_87106;
var statearr_87109_87179 = state_87106__$1;
(statearr_87109_87179[(2)] = inst_87102);

(statearr_87109_87179[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (20))){
var _ = (function (){var statearr_87110 = state_87106;
(statearr_87110[(4)] = cljs.core.rest((state_87106[(4)])));

return statearr_87110;
})();
var state_87106__$1 = state_87106;
var ex87108 = (state_87106__$1[(2)]);
var statearr_87111_87180 = state_87106__$1;
(statearr_87111_87180[(5)] = ex87108);


var statearr_87112_87181 = state_87106__$1;
(statearr_87112_87181[(1)] = (10));

(statearr_87112_87181[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (27))){
var inst_87094 = (state_87106[(2)]);
var _ = (function (){var statearr_87113 = state_87106;
(statearr_87113[(4)] = cljs.core.rest((state_87106[(4)])));

return statearr_87113;
})();
var state_87106__$1 = state_87106;
var statearr_87114_87182 = state_87106__$1;
(statearr_87114_87182[(2)] = inst_87094);

(statearr_87114_87182[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (1))){
var inst_86981 = (0);
var state_87106__$1 = (function (){var statearr_87115 = state_87106;
(statearr_87115[(7)] = inst_86981);

return statearr_87115;
})();
var statearr_87116_87183 = state_87106__$1;
(statearr_87116_87183[(2)] = null);

(statearr_87116_87183[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (24))){
var inst_87072 = (state_87106[(8)]);
var inst_87072__$1 = (state_87106[(2)]);
var inst_87073 = inst_87072__$1 === true;
var state_87106__$1 = (function (){var statearr_87117 = state_87106;
(statearr_87117[(8)] = inst_87072__$1);

return statearr_87117;
})();
if(cljs.core.truth_(inst_87073)){
var statearr_87118_87184 = state_87106__$1;
(statearr_87118_87184[(1)] = (25));

} else {
var statearr_87119_87185 = state_87106__$1;
(statearr_87119_87185[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (4))){
var inst_86984 = (state_87106[(9)]);
var inst_86984__$1 = (state_87106[(2)]);
var state_87106__$1 = (function (){var statearr_87120 = state_87106;
(statearr_87120[(9)] = inst_86984__$1);

return statearr_87120;
})();
if(cljs.core.truth_(inst_86984__$1)){
var statearr_87121_87186 = state_87106__$1;
(statearr_87121_87186[(1)] = (5));

} else {
var statearr_87122_87187 = state_87106__$1;
(statearr_87122_87187[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (15))){
var inst_86997 = (state_87106[(10)]);
var state_87106__$1 = state_87106;
var statearr_87123_87188 = state_87106__$1;
(statearr_87123_87188[(2)] = inst_86997);

(statearr_87123_87188[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (21))){
var inst_87024 = (state_87106[(11)]);
var inst_87028 = (state_87106[(12)]);
var inst_86984 = (state_87106[(9)]);
var inst_87021 = (state_87106[(13)]);
var inst_86981 = (state_87106[(7)]);
var inst_87023 = (state_87106[(14)]);
var inst_87022 = (state_87106[(15)]);
var inst_87020 = (state_87106[(16)]);
var inst_87029 = (state_87106[(17)]);
var inst_87025 = (state_87106[(18)]);
var inst_87031 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_87032 = [cljs.core.cst$kw$pending_DASH_req,inst_87028];
var inst_87033 = (new cljs.core.PersistentVector(null,2,(5),inst_87031,inst_87032,null));
var inst_87034 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_87033,inst_87023);
var inst_87061 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_87062 = (function (){var resp_chan = inst_87023;
var timeout = inst_87029;
var i = inst_86981;
var data = inst_87022;
var map__87019 = inst_87025;
var _ = inst_87020;
var req_id = inst_87028;
var operation = inst_87021;
var vec__87016 = inst_86984;
var msg = inst_86984;
var opts = inst_87024;
var c__20603__auto____$1 = inst_87061;
return (function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_87059){
var state_val_87060 = (state_87059[(1)]);
if((state_val_87060 === (1))){
var inst_87038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_87039 = cljs.core.async.timeout(timeout);
var inst_87040 = [resp_chan,inst_87039];
var inst_87041 = (new cljs.core.PersistentVector(null,2,(5),inst_87038,inst_87040,null));
var state_87059__$1 = state_87059;
return cljs.core.async.ioc_alts_BANG_(state_87059__$1,(2),inst_87041);
} else {
if((state_val_87060 === (2))){
var inst_87044 = (state_87059[(7)]);
var inst_87043 = (state_87059[(2)]);
var inst_87044__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_87043,(0),null);
var inst_87045 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_87043,(1),null);
var inst_87046 = (function (){var vec__87035 = inst_87043;
var resp = inst_87044__$1;
var c = inst_87045;
return (function (p1__86980_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__86980_SHARP_,req_id);
});
})();
var inst_87047 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_87046);
var inst_87048 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_87045,resp_chan);
var state_87059__$1 = (function (){var statearr_87124 = state_87059;
(statearr_87124[(7)] = inst_87044__$1);

(statearr_87124[(8)] = inst_87047);

return statearr_87124;
})();
if(inst_87048){
var statearr_87125_87189 = state_87059__$1;
(statearr_87125_87189[(1)] = (3));

} else {
var statearr_87126_87190 = state_87059__$1;
(statearr_87126_87190[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87060 === (3))){
var inst_87044 = (state_87059[(7)]);
var state_87059__$1 = state_87059;
var statearr_87127_87191 = state_87059__$1;
(statearr_87127_87191[(2)] = inst_87044);

(statearr_87127_87191[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87060 === (4))){
var inst_87051 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_87052 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_87053 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_87054 = cljs.core.PersistentHashMap.fromArrays(inst_87052,inst_87053);
var inst_87055 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_87051,inst_87054);
var state_87059__$1 = state_87059;
var statearr_87128_87192 = state_87059__$1;
(statearr_87128_87192[(2)] = inst_87055);

(statearr_87128_87192[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87060 === (5))){
var inst_87057 = (state_87059[(2)]);
var state_87059__$1 = state_87059;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87059__$1,inst_87057);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__20477__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__20477__auto____0 = (function (){
var statearr_87129 = [null,null,null,null,null,null,null,null,null];
(statearr_87129[(0)] = fluree$db$connection$msg_producer_$_state_machine__20477__auto__);

(statearr_87129[(1)] = (1));

return statearr_87129;
});
var fluree$db$connection$msg_producer_$_state_machine__20477__auto____1 = (function (state_87059){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_87059);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e87130){var ex__20480__auto__ = e87130;
var statearr_87131_87193 = state_87059;
(statearr_87131_87193[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_87059[(4)]))){
var statearr_87132_87194 = state_87059;
(statearr_87132_87194[(1)] = cljs.core.first((state_87059[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__87195 = state_87059;
state_87059 = G__87195;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__20477__auto__ = function(state_87059){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__20477__auto____1.call(this,state_87059);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__20477__auto____0;
fluree$db$connection$msg_producer_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__20477__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_87133 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_87133[(6)] = c__20603__auto____$1);

return statearr_87133;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
});
})();
var inst_87063 = cljs.core.async.impl.dispatch.run(inst_87062);
var state_87106__$1 = (function (){var statearr_87134 = state_87106;
(statearr_87134[(19)] = inst_87034);

(statearr_87134[(20)] = inst_87063);

return statearr_87134;
})();
var statearr_87135_87196 = state_87106__$1;
(statearr_87135_87196[(2)] = inst_87061);

(statearr_87135_87196[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (31))){
var inst_87082 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_87106__$1 = state_87106;
var statearr_87136_87197 = state_87106__$1;
(statearr_87136_87197[(2)] = inst_87082);

(statearr_87136_87197[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (32))){
var state_87106__$1 = state_87106;
var statearr_87137_87198 = state_87106__$1;
(statearr_87137_87198[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (33))){
var inst_87090 = (state_87106[(2)]);
var state_87106__$1 = state_87106;
var statearr_87139_87199 = state_87106__$1;
(statearr_87139_87199[(2)] = inst_87090);

(statearr_87139_87199[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (13))){
var inst_86997 = (state_87106[(10)]);
var inst_86994 = (state_87106[(2)]);
var inst_86995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_86994,(0),null);
var inst_86996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_86994,(1),null);
var inst_86997__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_86994,(2),null);
var state_87106__$1 = (function (){var statearr_87140 = state_87106;
(statearr_87140[(21)] = inst_86996);

(statearr_87140[(22)] = inst_86995);

(statearr_87140[(10)] = inst_86997__$1);

return statearr_87140;
})();
if(cljs.core.truth_(inst_86997__$1)){
var statearr_87141_87200 = state_87106__$1;
(statearr_87141_87200[(1)] = (14));

} else {
var statearr_87142_87201 = state_87106__$1;
(statearr_87142_87201[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (22))){
var state_87106__$1 = state_87106;
var statearr_87143_87202 = state_87106__$1;
(statearr_87143_87202[(2)] = null);

(statearr_87143_87202[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (36))){
var inst_87088 = (state_87106[(2)]);
var state_87106__$1 = state_87106;
var statearr_87144_87203 = state_87106__$1;
(statearr_87144_87203[(2)] = inst_87088);

(statearr_87144_87203[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (29))){
var inst_87072 = (state_87106[(8)]);
var inst_87080 = (inst_87072 == null);
var state_87106__$1 = state_87106;
if(cljs.core.truth_(inst_87080)){
var statearr_87145_87204 = state_87106__$1;
(statearr_87145_87204[(1)] = (31));

} else {
var statearr_87146_87205 = state_87106__$1;
(statearr_87146_87205[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (6))){
var state_87106__$1 = state_87106;
var statearr_87147_87206 = state_87106__$1;
(statearr_87147_87206[(2)] = null);

(statearr_87147_87206[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (28))){
var inst_87072 = (state_87106[(8)]);
var inst_87078 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_87072,"Error processing message in producer."], 0));
var state_87106__$1 = state_87106;
var statearr_87148_87207 = state_87106__$1;
(statearr_87148_87207[(2)] = inst_87078);

(statearr_87148_87207[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (25))){
var state_87106__$1 = state_87106;
var statearr_87149_87208 = state_87106__$1;
(statearr_87149_87208[(2)] = null);

(statearr_87149_87208[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (34))){
var inst_87072 = (state_87106[(8)]);
var inst_87085 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_87072], 0));
var state_87106__$1 = state_87106;
var statearr_87150_87209 = state_87106__$1;
(statearr_87150_87209[(2)] = inst_87085);

(statearr_87150_87209[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (17))){
var inst_86986 = (state_87106[(23)]);
var inst_86997 = (state_87106[(10)]);
var inst_87004 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_86997,inst_86986);
var state_87106__$1 = state_87106;
var statearr_87151_87210 = state_87106__$1;
(statearr_87151_87210[(2)] = inst_87004);

(statearr_87151_87210[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (3))){
var inst_87104 = (state_87106[(2)]);
var state_87106__$1 = state_87106;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87106__$1,inst_87104);
} else {
if((state_val_87107 === (12))){
var state_87106__$1 = state_87106;
var statearr_87152_87211 = state_87106__$1;
(statearr_87152_87211[(2)] = null);

(statearr_87152_87211[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (2))){
var state_87106__$1 = state_87106;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87106__$1,(4),req_chan);
} else {
if((state_val_87107 === (23))){
var inst_87028 = (state_87106[(12)]);
var inst_87021 = (state_87106[(13)]);
var inst_87022 = (state_87106[(15)]);
var inst_87066 = (state_87106[(2)]);
var inst_87067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_87068 = [inst_87021,inst_87028,inst_87022];
var inst_87069 = (new cljs.core.PersistentVector(null,3,(5),inst_87067,inst_87068,null));
var inst_87070 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_87069) : publish_fn.call(null,conn,inst_87069));
var state_87106__$1 = (function (){var statearr_87153 = state_87106;
(statearr_87153[(24)] = inst_87066);

return statearr_87153;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87106__$1,(24),inst_87070);
} else {
if((state_val_87107 === (35))){
var state_87106__$1 = state_87106;
var statearr_87154_87212 = state_87106__$1;
(statearr_87154_87212[(2)] = null);

(statearr_87154_87212[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (19))){
var inst_87010 = (state_87106[(2)]);
var state_87106__$1 = state_87106;
var statearr_87155_87213 = state_87106__$1;
(statearr_87155_87213[(2)] = inst_87010);

(statearr_87155_87213[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (11))){
var inst_86984 = (state_87106[(9)]);
var state_87106__$1 = state_87106;
var statearr_87156_87214 = state_87106__$1;
(statearr_87156_87214[(2)] = inst_86984);

(statearr_87156_87214[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (9))){
var inst_86981 = (state_87106[(7)]);
var inst_87097 = (state_87106[(2)]);
var inst_87098 = (inst_86981 + (1));
var inst_86981__$1 = inst_87098;
var state_87106__$1 = (function (){var statearr_87157 = state_87106;
(statearr_87157[(25)] = inst_87097);

(statearr_87157[(7)] = inst_86981__$1);

return statearr_87157;
})();
var statearr_87158_87215 = state_87106__$1;
(statearr_87158_87215[(2)] = null);

(statearr_87158_87215[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (5))){
var state_87106__$1 = state_87106;
var statearr_87159_87216 = state_87106__$1;
(statearr_87159_87216[(2)] = null);

(statearr_87159_87216[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (14))){
var inst_86997 = (state_87106[(10)]);
var inst_86999 = fluree.db.util.async.channel_QMARK_(inst_86997);
var state_87106__$1 = state_87106;
var statearr_87160_87217 = state_87106__$1;
(statearr_87160_87217[(2)] = inst_86999);

(statearr_87160_87217[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (26))){
var inst_87072 = (state_87106[(8)]);
var inst_87076 = fluree.db.util.core.exception_QMARK_(inst_87072);
var state_87106__$1 = state_87106;
if(inst_87076){
var statearr_87161_87218 = state_87106__$1;
(statearr_87161_87218[(1)] = (28));

} else {
var statearr_87162_87219 = state_87106__$1;
(statearr_87162_87219[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (16))){
var inst_87002 = (state_87106[(2)]);
var state_87106__$1 = state_87106;
if(cljs.core.truth_(inst_87002)){
var statearr_87163_87220 = state_87106__$1;
(statearr_87163_87220[(1)] = (17));

} else {
var statearr_87164_87221 = state_87106__$1;
(statearr_87164_87221[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (30))){
var inst_87092 = (state_87106[(2)]);
var state_87106__$1 = state_87106;
var statearr_87165_87222 = state_87106__$1;
(statearr_87165_87222[(2)] = inst_87092);

(statearr_87165_87222[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (10))){
var inst_86984 = (state_87106[(9)]);
var inst_86986 = (state_87106[(2)]);
var inst_86990 = cljs.core.sequential_QMARK_(inst_86984);
var state_87106__$1 = (function (){var statearr_87166 = state_87106;
(statearr_87166[(23)] = inst_86986);

return statearr_87166;
})();
if(inst_86990){
var statearr_87167_87223 = state_87106__$1;
(statearr_87167_87223[(1)] = (11));

} else {
var statearr_87168_87224 = state_87106__$1;
(statearr_87168_87224[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (18))){
var inst_86984 = (state_87106[(9)]);
var inst_86986 = (state_87106[(23)]);
var inst_87006 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_86984], 0));
var inst_87007 = ["Error processing ledger request, no valid return channel: ",inst_87006].join('');
var inst_87008 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_86986,inst_87007], 0));
var state_87106__$1 = state_87106;
var statearr_87169_87225 = state_87106__$1;
(statearr_87169_87225[(2)] = inst_87008);

(statearr_87169_87225[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87107 === (8))){
var inst_87024 = (state_87106[(11)]);
var inst_86984 = (state_87106[(9)]);
var inst_87023 = (state_87106[(14)]);
var inst_87025 = (state_87106[(18)]);
var _ = (function (){var statearr_87170 = state_87106;
(statearr_87170[(4)] = cljs.core.cons((20),(state_87106[(4)])));

return statearr_87170;
})();
var inst_87020 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_86984], 0));
var inst_87021 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_86984,(0),null);
var inst_87022 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_86984,(1),null);
var inst_87023__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_86984,(2),null);
var inst_87024__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_86984,(3),null);
var inst_87025__$1 = cljs.core.__destructure_map(inst_87024__$1);
var inst_87026 = fluree.db.util.core.random_uuid();
var inst_87027 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_87026);
var inst_87028 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_87025__$1,cljs.core.cst$kw$req_DASH_id,inst_87027);
var inst_87029 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_87025__$1,cljs.core.cst$kw$timeout,(60000));
var state_87106__$1 = (function (){var statearr_87171 = state_87106;
(statearr_87171[(11)] = inst_87024__$1);

(statearr_87171[(12)] = inst_87028);

(statearr_87171[(13)] = inst_87021);

(statearr_87171[(14)] = inst_87023__$1);

(statearr_87171[(15)] = inst_87022);

(statearr_87171[(16)] = inst_87020);

(statearr_87171[(17)] = inst_87029);

(statearr_87171[(18)] = inst_87025__$1);

return statearr_87171;
})();
if(cljs.core.truth_(inst_87023__$1)){
var statearr_87172_87226 = state_87106__$1;
(statearr_87172_87226[(1)] = (21));

} else {
var statearr_87173_87227 = state_87106__$1;
(statearr_87173_87227[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__20477__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__20477__auto____0 = (function (){
var statearr_87174 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_87174[(0)] = fluree$db$connection$msg_producer_$_state_machine__20477__auto__);

(statearr_87174[(1)] = (1));

return statearr_87174;
});
var fluree$db$connection$msg_producer_$_state_machine__20477__auto____1 = (function (state_87106){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_87106);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e87175){var ex__20480__auto__ = e87175;
var statearr_87176_87228 = state_87106;
(statearr_87176_87228[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_87106[(4)]))){
var statearr_87177_87229 = state_87106;
(statearr_87177_87229[(1)] = cljs.core.first((state_87106[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__87230 = state_87106;
state_87106 = G__87230;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__20477__auto__ = function(state_87106){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__20477__auto____1.call(this,state_87106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__20477__auto____0;
fluree$db$connection$msg_producer_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__20477__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_87178 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_87178[(6)] = c__20603__auto__);

return statearr_87178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__87231 = conn;
var map__87231__$1 = cljs.core.__destructure_map(map__87231);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87231__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_87313){
var state_val_87314 = (state_87313[(1)]);
if((state_val_87314 === (7))){
var inst_87309 = (state_87313[(2)]);
var state_87313__$1 = state_87313;
var statearr_87315_87366 = state_87313__$1;
(statearr_87315_87366[(2)] = inst_87309);

(statearr_87315_87366[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (20))){
var inst_87250 = (state_87313[(7)]);
var inst_87264 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_87265 = [inst_87250];
var inst_87266 = cljs.core.PersistentHashMap.fromArrays(inst_87264,inst_87265);
var inst_87267 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_87266], 0));
var state_87313__$1 = state_87313;
var statearr_87316_87367 = state_87313__$1;
(statearr_87316_87367[(2)] = inst_87267);

(statearr_87316_87367[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (27))){
var state_87313__$1 = state_87313;
var statearr_87317_87368 = state_87313__$1;
(statearr_87317_87368[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (1))){
var inst_87232 = (0);
var state_87313__$1 = (function (){var statearr_87319 = state_87313;
(statearr_87319[(8)] = inst_87232);

return statearr_87319;
})();
var statearr_87320_87369 = state_87313__$1;
(statearr_87320_87369[(2)] = null);

(statearr_87320_87369[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (24))){
var inst_87243 = (state_87313[(9)]);
var inst_87292 = fluree.db.util.core.exception_QMARK_(inst_87243);
var state_87313__$1 = state_87313;
if(inst_87292){
var statearr_87321_87370 = state_87313__$1;
(statearr_87321_87370[(1)] = (26));

} else {
var statearr_87322_87371 = state_87313__$1;
(statearr_87322_87371[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (4))){
var inst_87237 = (state_87313[(10)]);
var inst_87242 = (state_87313[(2)]);
var inst_87243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_87242,(0),null);
var inst_87244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_87242,(1),null);
var inst_87245 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_87244,inst_87237);
var state_87313__$1 = (function (){var statearr_87323 = state_87313;
(statearr_87323[(9)] = inst_87243);

return statearr_87323;
})();
if(inst_87245){
var statearr_87324_87372 = state_87313__$1;
(statearr_87324_87372[(1)] = (5));

} else {
var statearr_87325_87373 = state_87313__$1;
(statearr_87325_87373[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (15))){
var inst_87250 = (state_87313[(7)]);
var inst_87259 = typeof inst_87250 === 'string';
var state_87313__$1 = state_87313;
if(cljs.core.truth_(inst_87259)){
var statearr_87326_87374 = state_87313__$1;
(statearr_87326_87374[(1)] = (17));

} else {
var statearr_87327_87375 = state_87313__$1;
(statearr_87327_87375[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (21))){
var state_87313__$1 = state_87313;
var statearr_87328_87376 = state_87313__$1;
(statearr_87328_87376[(2)] = null);

(statearr_87328_87376[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (31))){
var inst_87303 = (state_87313[(2)]);
var state_87313__$1 = state_87313;
var statearr_87329_87377 = state_87313__$1;
(statearr_87329_87377[(2)] = inst_87303);

(statearr_87329_87377[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (13))){
var inst_87276 = (state_87313[(2)]);
var inst_87277 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_87278 = fluree.db.connection.close_websocket(inst_87277);
var inst_87279 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_87280 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_87279);
var state_87313__$1 = (function (){var statearr_87330 = state_87313;
(statearr_87330[(11)] = inst_87278);

(statearr_87330[(12)] = inst_87276);

return statearr_87330;
})();
var statearr_87331_87378 = state_87313__$1;
(statearr_87331_87378[(2)] = inst_87280);

(statearr_87331_87378[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (22))){
var inst_87270 = (state_87313[(2)]);
var state_87313__$1 = state_87313;
var statearr_87332_87379 = state_87313__$1;
(statearr_87332_87379[(2)] = inst_87270);

(statearr_87332_87379[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (29))){
var inst_87243 = (state_87313[(9)]);
var inst_87298 = fluree.db.util.json.parse(inst_87243);
var inst_87299 = fluree.db.conn_events.process_events(conn,inst_87298);
var inst_87232 = (0);
var state_87313__$1 = (function (){var statearr_87333 = state_87313;
(statearr_87333[(8)] = inst_87232);

(statearr_87333[(13)] = inst_87299);

return statearr_87333;
})();
var statearr_87334_87380 = state_87313__$1;
(statearr_87334_87380[(2)] = null);

(statearr_87334_87380[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (6))){
var inst_87243 = (state_87313[(9)]);
var inst_87288 = (inst_87243 == null);
var state_87313__$1 = state_87313;
if(cljs.core.truth_(inst_87288)){
var statearr_87335_87381 = state_87313__$1;
(statearr_87335_87381[(1)] = (23));

} else {
var statearr_87336_87382 = state_87313__$1;
(statearr_87336_87382[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (28))){
var inst_87305 = (state_87313[(2)]);
var state_87313__$1 = state_87313;
var statearr_87337_87383 = state_87313__$1;
(statearr_87337_87383[(2)] = inst_87305);

(statearr_87337_87383[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (25))){
var inst_87307 = (state_87313[(2)]);
var state_87313__$1 = state_87313;
var statearr_87338_87384 = state_87313__$1;
(statearr_87338_87384[(2)] = inst_87307);

(statearr_87338_87384[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (17))){
var inst_87250 = (state_87313[(7)]);
var inst_87261 = cljs.core.eval(inst_87250);
var state_87313__$1 = state_87313;
var statearr_87339_87385 = state_87313__$1;
(statearr_87339_87385[(2)] = inst_87261);

(statearr_87339_87385[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (3))){
var inst_87311 = (state_87313[(2)]);
var state_87313__$1 = state_87313;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87313__$1,inst_87311);
} else {
if((state_val_87314 === (12))){
var inst_87250 = (state_87313[(7)]);
var inst_87255 = cljs.core.fn_QMARK_(inst_87250);
var state_87313__$1 = state_87313;
if(inst_87255){
var statearr_87340_87386 = state_87313__$1;
(statearr_87340_87386[(1)] = (14));

} else {
var statearr_87341_87387 = state_87313__$1;
(statearr_87341_87387[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (2))){
var inst_87237 = (state_87313[(10)]);
var inst_87237__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_87238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_87239 = [sub_chan,inst_87237__$1];
var inst_87240 = (new cljs.core.PersistentVector(null,2,(5),inst_87238,inst_87239,null));
var state_87313__$1 = (function (){var statearr_87342 = state_87313;
(statearr_87342[(10)] = inst_87237__$1);

return statearr_87342;
})();
return cljs.core.async.ioc_alts_BANG_(state_87313__$1,(4),inst_87240);
} else {
if((state_val_87314 === (23))){
var inst_87290 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_87313__$1 = state_87313;
var statearr_87343_87388 = state_87313__$1;
(statearr_87343_87388[(2)] = inst_87290);

(statearr_87343_87388[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (19))){
var inst_87272 = (state_87313[(2)]);
var state_87313__$1 = state_87313;
var statearr_87344_87389 = state_87313__$1;
(statearr_87344_87389[(2)] = inst_87272);

(statearr_87344_87389[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (11))){
var inst_87253 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_87313__$1 = state_87313;
var statearr_87345_87390 = state_87313__$1;
(statearr_87345_87390[(2)] = inst_87253);

(statearr_87345_87390[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (9))){
var inst_87232 = (state_87313[(8)]);
var inst_87282 = fluree.db.connection.ping_transactor(conn);
var inst_87283 = (inst_87232 + (1));
var inst_87232__$1 = inst_87283;
var state_87313__$1 = (function (){var statearr_87346 = state_87313;
(statearr_87346[(14)] = inst_87282);

(statearr_87346[(8)] = inst_87232__$1);

return statearr_87346;
})();
var statearr_87347_87391 = state_87313__$1;
(statearr_87347_87391[(2)] = null);

(statearr_87347_87391[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (5))){
var inst_87232 = (state_87313[(8)]);
var inst_87247 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_87232);
var state_87313__$1 = state_87313;
if(inst_87247){
var statearr_87348_87392 = state_87313__$1;
(statearr_87348_87392[(1)] = (8));

} else {
var statearr_87349_87393 = state_87313__$1;
(statearr_87349_87393[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (14))){
var inst_87250 = (state_87313[(7)]);
var inst_87257 = (inst_87250.cljs$core$IFn$_invoke$arity$0 ? inst_87250.cljs$core$IFn$_invoke$arity$0() : inst_87250.call(null));
var state_87313__$1 = state_87313;
var statearr_87350_87394 = state_87313__$1;
(statearr_87350_87394[(2)] = inst_87257);

(statearr_87350_87394[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (26))){
var inst_87243 = (state_87313[(9)]);
var inst_87294 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_87243], 0));
var inst_87232 = (0);
var state_87313__$1 = (function (){var statearr_87351 = state_87313;
(statearr_87351[(8)] = inst_87232);

(statearr_87351[(15)] = inst_87294);

return statearr_87351;
})();
var statearr_87352_87395 = state_87313__$1;
(statearr_87352_87395[(2)] = null);

(statearr_87352_87395[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (16))){
var inst_87274 = (state_87313[(2)]);
var state_87313__$1 = state_87313;
var statearr_87353_87396 = state_87313__$1;
(statearr_87353_87396[(2)] = inst_87274);

(statearr_87353_87396[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (30))){
var state_87313__$1 = state_87313;
var statearr_87354_87397 = state_87313__$1;
(statearr_87354_87397[(2)] = null);

(statearr_87354_87397[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (10))){
var inst_87286 = (state_87313[(2)]);
var state_87313__$1 = state_87313;
var statearr_87355_87398 = state_87313__$1;
(statearr_87355_87398[(2)] = inst_87286);

(statearr_87355_87398[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (18))){
var state_87313__$1 = state_87313;
var statearr_87356_87399 = state_87313__$1;
(statearr_87356_87399[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_87314 === (8))){
var inst_87250 = (state_87313[(7)]);
var inst_87249 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_87250__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_87251 = (inst_87250__$1 == null);
var state_87313__$1 = (function (){var statearr_87358 = state_87313;
(statearr_87358[(7)] = inst_87250__$1);

(statearr_87358[(16)] = inst_87249);

return statearr_87358;
})();
if(cljs.core.truth_(inst_87251)){
var statearr_87359_87400 = state_87313__$1;
(statearr_87359_87400[(1)] = (11));

} else {
var statearr_87360_87401 = state_87313__$1;
(statearr_87360_87401[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__20477__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__20477__auto____0 = (function (){
var statearr_87361 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_87361[(0)] = fluree$db$connection$msg_consumer_$_state_machine__20477__auto__);

(statearr_87361[(1)] = (1));

return statearr_87361;
});
var fluree$db$connection$msg_consumer_$_state_machine__20477__auto____1 = (function (state_87313){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_87313);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e87362){var ex__20480__auto__ = e87362;
var statearr_87363_87402 = state_87313;
(statearr_87363_87402[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_87313[(4)]))){
var statearr_87364_87403 = state_87313;
(statearr_87364_87403[(1)] = cljs.core.first((state_87313[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__87404 = state_87313;
state_87313 = G__87404;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__20477__auto__ = function(state_87313){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__20477__auto____1.call(this,state_87313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__20477__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__20477__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_87365 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_87365[(6)] = c__20603__auto__);

return statearr_87365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__87406 = arguments.length;
switch (G__87406) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__87407 = opts;
var map__87407__$1 = cljs.core.__destructure_map(map__87407);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87407__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87407__$1,cljs.core.cst$kw$jwt);
return (function (k){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_87459){
var state_val_87460 = (state_87459[(1)]);
if((state_val_87460 === (7))){
var inst_87417 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_87418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_87419 = [conn_id,cljs.core.cst$kw$token];
var inst_87420 = (new cljs.core.PersistentVector(null,2,(5),inst_87418,inst_87419,null));
var inst_87421 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_87417,inst_87420);
var state_87459__$1 = state_87459;
var statearr_87461_87492 = state_87459__$1;
(statearr_87461_87492[(2)] = inst_87421);

(statearr_87461_87492[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (1))){
var state_87459__$1 = state_87459;
var statearr_87462_87493 = state_87459__$1;
(statearr_87462_87493[(2)] = null);

(statearr_87462_87493[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (4))){
var inst_87408 = (state_87459[(2)]);
var state_87459__$1 = state_87459;
var statearr_87463_87494 = state_87459__$1;
(statearr_87463_87494[(2)] = inst_87408);

(statearr_87463_87494[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (15))){
var inst_87428 = (state_87459[(7)]);
var inst_87447 = (state_87459[(2)]);
var inst_87448 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_87449 = [(5000),inst_87447,cljs.core.cst$kw$text];
var inst_87450 = cljs.core.PersistentHashMap.fromArrays(inst_87448,inst_87449);
var inst_87451 = fluree.db.util.xhttp.get(inst_87428,inst_87450);
var state_87459__$1 = state_87459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87459__$1,(16),inst_87451);
} else {
if((state_val_87460 === (13))){
var inst_87428 = (state_87459[(7)]);
var inst_87438 = (state_87459[(8)]);
var inst_87440 = [cljs.core.cst$kw$headers];
var inst_87441 = [inst_87438];
var inst_87442 = cljs.core.PersistentHashMap.fromArrays(inst_87440,inst_87441);
var inst_87443 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_87428,inst_87442,private$);
var inst_87444 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_87443);
var state_87459__$1 = state_87459;
var statearr_87464_87495 = state_87459__$1;
(statearr_87464_87495[(2)] = inst_87444);

(statearr_87464_87495[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (6))){
var inst_87414 = (state_87459[(9)]);
var state_87459__$1 = state_87459;
var statearr_87465_87496 = state_87459__$1;
(statearr_87465_87496[(2)] = inst_87414);

(statearr_87465_87496[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (3))){
var inst_87457 = (state_87459[(2)]);
var state_87459__$1 = state_87459;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87459__$1,inst_87457);
} else {
if((state_val_87460 === (12))){
var inst_87438 = (state_87459[(2)]);
var state_87459__$1 = (function (){var statearr_87466 = state_87459;
(statearr_87466[(8)] = inst_87438);

return statearr_87466;
})();
if(cljs.core.truth_(private$)){
var statearr_87467_87497 = state_87459__$1;
(statearr_87467_87497[(1)] = (13));

} else {
var statearr_87468_87498 = state_87459__$1;
(statearr_87468_87498[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (2))){
var inst_87414 = (state_87459[(9)]);
var _ = (function (){var statearr_87469 = state_87459;
(statearr_87469[(4)] = cljs.core.cons((5),(state_87459[(4)])));

return statearr_87469;
})();
var inst_87414__$1 = jwt;
var state_87459__$1 = (function (){var statearr_87470 = state_87459;
(statearr_87470[(9)] = inst_87414__$1);

return statearr_87470;
})();
if(cljs.core.truth_(inst_87414__$1)){
var statearr_87471_87499 = state_87459__$1;
(statearr_87471_87499[(1)] = (6));

} else {
var statearr_87472_87500 = state_87459__$1;
(statearr_87472_87500[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (11))){
var inst_87432 = (state_87459[(10)]);
var state_87459__$1 = state_87459;
var statearr_87474_87501 = state_87459__$1;
(statearr_87474_87501[(2)] = inst_87432);

(statearr_87474_87501[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (9))){
var inst_87424 = (state_87459[(11)]);
var inst_87423 = (state_87459[(12)]);
var inst_87427 = (state_87459[(2)]);
var inst_87428 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_87427),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_87424)].join('');
var inst_87430 = ["Accept"];
var inst_87431 = ["application/json"];
var inst_87432 = cljs.core.PersistentHashMap.fromArrays(inst_87430,inst_87431);
var state_87459__$1 = (function (){var statearr_87475 = state_87459;
(statearr_87475[(10)] = inst_87432);

(statearr_87475[(7)] = inst_87428);

return statearr_87475;
})();
if(cljs.core.truth_(inst_87423)){
var statearr_87476_87502 = state_87459__$1;
(statearr_87476_87502[(1)] = (10));

} else {
var statearr_87477_87503 = state_87459__$1;
(statearr_87477_87503[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (5))){
var _ = (function (){var statearr_87478 = state_87459;
(statearr_87478[(4)] = cljs.core.rest((state_87459[(4)])));

return statearr_87478;
})();
var state_87459__$1 = state_87459;
var ex87473 = (state_87459__$1[(2)]);
var statearr_87479_87504 = state_87459__$1;
(statearr_87479_87504[(5)] = ex87473);


if((ex87473 instanceof Error)){
var statearr_87480_87505 = state_87459__$1;
(statearr_87480_87505[(1)] = (4));

(statearr_87480_87505[(5)] = null);

} else {
throw ex87473;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (14))){
var inst_87438 = (state_87459[(8)]);
var state_87459__$1 = state_87459;
var statearr_87481_87506 = state_87459__$1;
(statearr_87481_87506[(2)] = inst_87438);

(statearr_87481_87506[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (16))){
var inst_87453 = (state_87459[(2)]);
var inst_87454 = fluree.db.util.async.throw_err(inst_87453);
var _ = (function (){var statearr_87482 = state_87459;
(statearr_87482[(4)] = cljs.core.rest((state_87459[(4)])));

return statearr_87482;
})();
var state_87459__$1 = state_87459;
var statearr_87483_87507 = state_87459__$1;
(statearr_87483_87507[(2)] = inst_87454);

(statearr_87483_87507[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (10))){
var inst_87432 = (state_87459[(10)]);
var inst_87423 = (state_87459[(12)]);
var inst_87434 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_87423)].join('');
var inst_87435 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_87432,"Authorization",inst_87434);
var state_87459__$1 = state_87459;
var statearr_87484_87508 = state_87459__$1;
(statearr_87484_87508[(2)] = inst_87435);

(statearr_87484_87508[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87460 === (8))){
var inst_87423 = (state_87459[(2)]);
var inst_87424 = clojure.string.replace(k,"_","/");
var inst_87425 = fluree.db.connection.get_server(conn_id,servers);
var state_87459__$1 = (function (){var statearr_87485 = state_87459;
(statearr_87485[(11)] = inst_87424);

(statearr_87485[(12)] = inst_87423);

return statearr_87485;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87459__$1,(9),inst_87425);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__20477__auto__ = null;
var fluree$db$connection$state_machine__20477__auto____0 = (function (){
var statearr_87486 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_87486[(0)] = fluree$db$connection$state_machine__20477__auto__);

(statearr_87486[(1)] = (1));

return statearr_87486;
});
var fluree$db$connection$state_machine__20477__auto____1 = (function (state_87459){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_87459);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e87487){var ex__20480__auto__ = e87487;
var statearr_87488_87509 = state_87459;
(statearr_87488_87509[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_87459[(4)]))){
var statearr_87489_87510 = state_87459;
(statearr_87489_87510[(1)] = cljs.core.first((state_87459[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__87511 = state_87459;
state_87459 = G__87511;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$connection$state_machine__20477__auto__ = function(state_87459){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__20477__auto____1.call(this,state_87459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__20477__auto____0;
fluree$db$connection$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__20477__auto____1;
return fluree$db$connection$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_87490 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_87490[(6)] = c__20603__auto__);

return statearr_87490;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__87512_SHARP_){
if(cljs.core.truth_(p1__87512_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),(function (p1__87513_SHARP_){
var or__4223__auto__ = p1__87513_SHARP_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return token;
}
}));

return true;
}catch (e87514){var e = e87514;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__87515 = opts;
var map__87515__$1 = cljs.core.__destructure_map(map__87515);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87515__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87515__$1,cljs.core.cst$kw$parallelism,(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87515__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87515__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87515__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87515__$1,cljs.core.cst$kw$storage_DASH_write,(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87515__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87515__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87515__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__87515__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__87515__$1,cljs.core.cst$kw$storage_DASH_list);
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4223__auto__ = object_cache;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4223__auto__ = storage_read;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4223__auto__ = storage_exists;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = storage_read;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4221__auto__ = storage_write;
if(cljs.core.truth_(and__4221__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4221__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_list,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__87516_87517 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__87516_87517.cljs$core$IFn$_invoke$arity$0 ? fexpr__87516_87517.cljs$core$IFn$_invoke$arity$0() : fexpr__87516_87517.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4835__auto__ = [];
var len__4829__auto___87558 = arguments.length;
var i__4830__auto___87559 = (0);
while(true){
if((i__4830__auto___87559 < len__4829__auto___87558)){
args__4835__auto__.push((arguments[i__4830__auto___87559]));

var G__87560 = (i__4830__auto___87559 + (1));
i__4830__auto___87559 = G__87560;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__87520){
var vec__87521 = p__87520;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__87521,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = cljs.core.cst$kw$dev_QMARK_.cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__20603__auto___87561 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_87541){
var state_val_87542 = (state_87541[(1)]);
if((state_val_87542 === (1))){
var inst_87524 = fluree.db.connection.get_socket(conn);
var state_87541__$1 = state_87541;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_87541__$1,(2),inst_87524);
} else {
if((state_val_87542 === (2))){
var inst_87526 = (state_87541[(7)]);
var inst_87527 = (state_87541[(8)]);
var inst_87526__$1 = (state_87541[(2)]);
var inst_87527__$1 = (inst_87526__$1 == null);
var state_87541__$1 = (function (){var statearr_87543 = state_87541;
(statearr_87543[(7)] = inst_87526__$1);

(statearr_87543[(8)] = inst_87527__$1);

return statearr_87543;
})();
if(cljs.core.truth_(inst_87527__$1)){
var statearr_87544_87562 = state_87541__$1;
(statearr_87544_87562[(1)] = (3));

} else {
var statearr_87545_87563 = state_87541__$1;
(statearr_87545_87563[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87542 === (3))){
var inst_87527 = (state_87541[(8)]);
var state_87541__$1 = state_87541;
var statearr_87546_87564 = state_87541__$1;
(statearr_87546_87564[(2)] = inst_87527);

(statearr_87546_87564[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87542 === (4))){
var inst_87526 = (state_87541[(7)]);
var inst_87530 = fluree.db.util.core.exception_QMARK_(inst_87526);
var state_87541__$1 = state_87541;
var statearr_87547_87565 = state_87541__$1;
(statearr_87547_87565[(2)] = inst_87530);

(statearr_87547_87565[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87542 === (5))){
var inst_87532 = (state_87541[(2)]);
var state_87541__$1 = state_87541;
if(cljs.core.truth_(inst_87532)){
var statearr_87548_87566 = state_87541__$1;
(statearr_87548_87566[(1)] = (6));

} else {
var statearr_87549_87567 = state_87541__$1;
(statearr_87549_87567[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_87542 === (6))){
var inst_87534 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_87535 = cljs.core.async.close_BANG_(conn);
var state_87541__$1 = (function (){var statearr_87550 = state_87541;
(statearr_87550[(9)] = inst_87534);

return statearr_87550;
})();
var statearr_87551_87568 = state_87541__$1;
(statearr_87551_87568[(2)] = inst_87535);

(statearr_87551_87568[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87542 === (7))){
var inst_87537 = fluree.db.connection.msg_consumer(conn);
var state_87541__$1 = state_87541;
var statearr_87552_87569 = state_87541__$1;
(statearr_87552_87569[(2)] = inst_87537);

(statearr_87552_87569[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_87542 === (8))){
var inst_87539 = (state_87541[(2)]);
var state_87541__$1 = state_87541;
return cljs.core.async.impl.ioc_helpers.return_chan(state_87541__$1,inst_87539);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__20477__auto__ = null;
var fluree$db$connection$state_machine__20477__auto____0 = (function (){
var statearr_87553 = [null,null,null,null,null,null,null,null,null,null];
(statearr_87553[(0)] = fluree$db$connection$state_machine__20477__auto__);

(statearr_87553[(1)] = (1));

return statearr_87553;
});
var fluree$db$connection$state_machine__20477__auto____1 = (function (state_87541){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_87541);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e87554){var ex__20480__auto__ = e87554;
var statearr_87555_87570 = state_87541;
(statearr_87555_87570[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_87541[(4)]))){
var statearr_87556_87571 = state_87541;
(statearr_87556_87571[(1)] = cljs.core.first((state_87541[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__87572 = state_87541;
state_87541 = G__87572;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
fluree$db$connection$state_machine__20477__auto__ = function(state_87541){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__20477__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__20477__auto____1.call(this,state_87541);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__20477__auto____0;
fluree$db$connection$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__20477__auto____1;
return fluree$db$connection$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_87557 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_87557[(6)] = c__20603__auto___87561);

return statearr_87557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq87518){
var G__87519 = cljs.core.first(seq87518);
var seq87518__$1 = cljs.core.next(seq87518);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__87519,seq87518__$1);
}));

