// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('alphabase.core');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('fluree.crypto.pkcs7');
fluree.crypto.aes.encrypt_STAR_ = (function fluree$crypto$aes$encrypt_STAR_(iv,key_ba,ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var padded = fluree.crypto.pkcs7.encode((16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js(iv));
});
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55686 = arguments.length;
var i__4830__auto___55687 = (0);
while(true){
if((i__4830__auto___55687 < len__4829__auto___55686)){
args__4835__auto__.push((arguments[i__4830__auto___55687]));

var G__55688 = (i__4830__auto___55687 + (1));
i__4830__auto___55687 = G__55688;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

(fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__55680){
var vec__55681 = p__55680;
var map__55684 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55681,(0),null);
var map__55684__$1 = cljs.core.__destructure_map(map__55684);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__55684__$1,cljs.core.cst$kw$iv,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__55684__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$hex);
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes(x):x);
var encrypted = fluree.crypto.aes.encrypt_STAR_(iv,key_ba,ba);
var G__55685 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__55685__$1 = (((G__55685 instanceof cljs.core.Keyword))?G__55685.fqn:null);
switch (G__55685__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex(encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64(encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55685__$1)].join('')));

}
}));

(fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq55677){
var G__55678 = cljs.core.first(seq55677);
var seq55677__$1 = cljs.core.next(seq55677);
var G__55679 = cljs.core.first(seq55677__$1);
var seq55677__$2 = cljs.core.next(seq55677__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55678,G__55679,seq55677__$2);
}));

fluree.crypto.aes.decrypt_STAR_ = (function fluree$crypto$aes$decrypt_STAR_(iv,key_ba,x_ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
return fluree.crypto.pkcs7.decode((16),cbc.decrypt(x_ba,cljs.core.clj__GT_js(iv)));
});
/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__4835__auto__ = [];
var len__4829__auto___55701 = arguments.length;
var i__4830__auto___55702 = (0);
while(true){
if((i__4830__auto___55702 < len__4829__auto___55701)){
args__4835__auto__.push((arguments[i__4830__auto___55702]));

var G__55703 = (i__4830__auto___55702 + (1));
i__4830__auto___55702 = G__55703;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

(fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__55694){
var vec__55695 = p__55694;
var map__55698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__55695,(0),null);
var map__55698__$1 = cljs.core.__destructure_map(map__55698);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__55698__$1,cljs.core.cst$kw$iv,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__55698__$1,cljs.core.cst$kw$input_DASH_format,cljs.core.cst$kw$hex);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__55698__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$string);
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__55699 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(input_format);
var G__55699__$1 = (((G__55699 instanceof cljs.core.Keyword))?G__55699.fqn:null);
switch (G__55699__$1) {
case "hex":
return alphabase.core.hex__GT_bytes(x);

break;
case "base64":
return alphabase.core.base64__GT_bytes(x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55699__$1)].join('')));

}
})():x);
var decrypt_ba = fluree.crypto.aes.decrypt_STAR_(iv,key_ba,x_ba);
var G__55700 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__55700__$1 = (((G__55700 instanceof cljs.core.Keyword))?G__55700.fqn:null);
switch (G__55700__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex(decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string(decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__55700__$1)].join('')));

}
}));

(fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq55691){
var G__55692 = cljs.core.first(seq55691);
var seq55691__$1 = cljs.core.next(seq55691);
var G__55693 = cljs.core.first(seq55691__$1);
var seq55691__$2 = cljs.core.next(seq55691__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55692,G__55693,seq55691__$2);
}));

