// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__22540 = arguments.length;
switch (G__22540) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async22541 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22541 = (function (f,blockable,meta22542){
this.f = f;
this.blockable = blockable;
this.meta22542 = meta22542;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async22541.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22543,meta22542__$1){
var self__ = this;
var _22543__$1 = this;
return (new cljs.core.async.t_cljs$core$async22541(self__.f,self__.blockable,meta22542__$1));
}));

(cljs.core.async.t_cljs$core$async22541.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22543){
var self__ = this;
var _22543__$1 = this;
return self__.meta22542;
}));

(cljs.core.async.t_cljs$core$async22541.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async22541.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async22541.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async22541.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async22541.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta22542], null);
}));

(cljs.core.async.t_cljs$core$async22541.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async22541.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22541");

(cljs.core.async.t_cljs$core$async22541.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async22541");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async22541.
 */
cljs.core.async.__GT_t_cljs$core$async22541 = (function cljs$core$async$__GT_t_cljs$core$async22541(f__$1,blockable__$1,meta22542){
return (new cljs.core.async.t_cljs$core$async22541(f__$1,blockable__$1,meta22542));
});

}

return (new cljs.core.async.t_cljs$core$async22541(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__22547 = arguments.length;
switch (G__22547) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__22550 = arguments.length;
switch (G__22550) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__22553 = arguments.length;
switch (G__22553) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_22555 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_22555) : fn1.call(null,val_22555));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_22555) : fn1.call(null,val_22555));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__22557 = arguments.length;
switch (G__22557) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4706__auto___22559 = n;
var x_22560 = (0);
while(true){
if((x_22560 < n__4706__auto___22559)){
(a[x_22560] = x_22560);

var G__22561 = (x_22560 + (1));
x_22560 = G__22561;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async22562 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22562 = (function (flag,meta22563){
this.flag = flag;
this.meta22563 = meta22563;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async22562.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22564,meta22563__$1){
var self__ = this;
var _22564__$1 = this;
return (new cljs.core.async.t_cljs$core$async22562(self__.flag,meta22563__$1));
}));

(cljs.core.async.t_cljs$core$async22562.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22564){
var self__ = this;
var _22564__$1 = this;
return self__.meta22563;
}));

(cljs.core.async.t_cljs$core$async22562.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async22562.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async22562.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async22562.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async22562.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta22563], null);
}));

(cljs.core.async.t_cljs$core$async22562.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async22562.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22562");

(cljs.core.async.t_cljs$core$async22562.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async22562");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async22562.
 */
cljs.core.async.__GT_t_cljs$core$async22562 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async22562(flag__$1,meta22563){
return (new cljs.core.async.t_cljs$core$async22562(flag__$1,meta22563));
});

}

return (new cljs.core.async.t_cljs$core$async22562(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async22565 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async22565 = (function (flag,cb,meta22566){
this.flag = flag;
this.cb = cb;
this.meta22566 = meta22566;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async22565.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_22567,meta22566__$1){
var self__ = this;
var _22567__$1 = this;
return (new cljs.core.async.t_cljs$core$async22565(self__.flag,self__.cb,meta22566__$1));
}));

(cljs.core.async.t_cljs$core$async22565.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_22567){
var self__ = this;
var _22567__$1 = this;
return self__.meta22566;
}));

(cljs.core.async.t_cljs$core$async22565.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async22565.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async22565.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async22565.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async22565.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta22566], null);
}));

(cljs.core.async.t_cljs$core$async22565.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async22565.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async22565");

(cljs.core.async.t_cljs$core$async22565.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async22565");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async22565.
 */
cljs.core.async.__GT_t_cljs$core$async22565 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async22565(flag__$1,cb__$1,meta22566){
return (new cljs.core.async.t_cljs$core$async22565(flag__$1,cb__$1,meta22566));
});

}

return (new cljs.core.async.t_cljs$core$async22565(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__22568_SHARP_){
var G__22570 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22568_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__22570) : fret.call(null,G__22570));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__22569_SHARP_){
var G__22571 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__22569_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__22571) : fret.call(null,G__22571));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4223__auto__ = wport;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return port;
}
})()], null));
} else {
var G__22572 = (i + (1));
i = G__22572;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4223__auto__ = ret;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5753__auto__ = (function (){var and__4221__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4221__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___22577 = arguments.length;
var i__4830__auto___22578 = (0);
while(true){
if((i__4830__auto___22578 < len__4829__auto___22577)){
args__4835__auto__.push((arguments[i__4830__auto___22578]));

var G__22579 = (i__4830__auto___22578 + (1));
i__4830__auto___22578 = G__22579;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__22575){
var map__22576 = p__22575;
var map__22576__$1 = cljs.core.__destructure_map(map__22576);
var opts = map__22576__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq22573){
var G__22574 = cljs.core.first(seq22573);
var seq22573__$1 = cljs.core.next(seq22573);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__22574,seq22573__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__22581 = arguments.length;
switch (G__22581) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__20603__auto___22628 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_22605){
var state_val_22606 = (state_22605[(1)]);
if((state_val_22606 === (7))){
var inst_22601 = (state_22605[(2)]);
var state_22605__$1 = state_22605;
var statearr_22607_22629 = state_22605__$1;
(statearr_22607_22629[(2)] = inst_22601);

(statearr_22607_22629[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22606 === (1))){
var state_22605__$1 = state_22605;
var statearr_22608_22630 = state_22605__$1;
(statearr_22608_22630[(2)] = null);

(statearr_22608_22630[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22606 === (4))){
var inst_22584 = (state_22605[(7)]);
var inst_22584__$1 = (state_22605[(2)]);
var inst_22585 = (inst_22584__$1 == null);
var state_22605__$1 = (function (){var statearr_22609 = state_22605;
(statearr_22609[(7)] = inst_22584__$1);

return statearr_22609;
})();
if(cljs.core.truth_(inst_22585)){
var statearr_22610_22631 = state_22605__$1;
(statearr_22610_22631[(1)] = (5));

} else {
var statearr_22611_22632 = state_22605__$1;
(statearr_22611_22632[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22606 === (13))){
var state_22605__$1 = state_22605;
var statearr_22612_22633 = state_22605__$1;
(statearr_22612_22633[(2)] = null);

(statearr_22612_22633[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22606 === (6))){
var inst_22584 = (state_22605[(7)]);
var state_22605__$1 = state_22605;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22605__$1,(11),to,inst_22584);
} else {
if((state_val_22606 === (3))){
var inst_22603 = (state_22605[(2)]);
var state_22605__$1 = state_22605;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22605__$1,inst_22603);
} else {
if((state_val_22606 === (12))){
var state_22605__$1 = state_22605;
var statearr_22613_22634 = state_22605__$1;
(statearr_22613_22634[(2)] = null);

(statearr_22613_22634[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22606 === (2))){
var state_22605__$1 = state_22605;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22605__$1,(4),from);
} else {
if((state_val_22606 === (11))){
var inst_22594 = (state_22605[(2)]);
var state_22605__$1 = state_22605;
if(cljs.core.truth_(inst_22594)){
var statearr_22614_22635 = state_22605__$1;
(statearr_22614_22635[(1)] = (12));

} else {
var statearr_22615_22636 = state_22605__$1;
(statearr_22615_22636[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22606 === (9))){
var state_22605__$1 = state_22605;
var statearr_22616_22637 = state_22605__$1;
(statearr_22616_22637[(2)] = null);

(statearr_22616_22637[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22606 === (5))){
var state_22605__$1 = state_22605;
if(cljs.core.truth_(close_QMARK_)){
var statearr_22617_22638 = state_22605__$1;
(statearr_22617_22638[(1)] = (8));

} else {
var statearr_22618_22639 = state_22605__$1;
(statearr_22618_22639[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22606 === (14))){
var inst_22599 = (state_22605[(2)]);
var state_22605__$1 = state_22605;
var statearr_22619_22640 = state_22605__$1;
(statearr_22619_22640[(2)] = inst_22599);

(statearr_22619_22640[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22606 === (10))){
var inst_22591 = (state_22605[(2)]);
var state_22605__$1 = state_22605;
var statearr_22620_22641 = state_22605__$1;
(statearr_22620_22641[(2)] = inst_22591);

(statearr_22620_22641[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22606 === (8))){
var inst_22588 = cljs.core.async.close_BANG_(to);
var state_22605__$1 = state_22605;
var statearr_22621_22642 = state_22605__$1;
(statearr_22621_22642[(2)] = inst_22588);

(statearr_22621_22642[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20477__auto__ = null;
var cljs$core$async$state_machine__20477__auto____0 = (function (){
var statearr_22622 = [null,null,null,null,null,null,null,null];
(statearr_22622[(0)] = cljs$core$async$state_machine__20477__auto__);

(statearr_22622[(1)] = (1));

return statearr_22622;
});
var cljs$core$async$state_machine__20477__auto____1 = (function (state_22605){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_22605);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e22623){var ex__20480__auto__ = e22623;
var statearr_22624_22643 = state_22605;
(statearr_22624_22643[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_22605[(4)]))){
var statearr_22625_22644 = state_22605;
(statearr_22625_22644[(1)] = cljs.core.first((state_22605[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__22645 = state_22605;
state_22605 = G__22645;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$state_machine__20477__auto__ = function(state_22605){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20477__auto____1.call(this,state_22605);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20477__auto____0;
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20477__auto____1;
return cljs$core$async$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_22626 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_22626[(6)] = c__20603__auto___22628);

return statearr_22626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__22646){
var vec__22647 = p__22646;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22647,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22647,(1),null);
var job = vec__22647;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__20603__auto___22823 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_22654){
var state_val_22655 = (state_22654[(1)]);
if((state_val_22655 === (1))){
var state_22654__$1 = state_22654;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22654__$1,(2),res,v);
} else {
if((state_val_22655 === (2))){
var inst_22651 = (state_22654[(2)]);
var inst_22652 = cljs.core.async.close_BANG_(res);
var state_22654__$1 = (function (){var statearr_22656 = state_22654;
(statearr_22656[(7)] = inst_22651);

return statearr_22656;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_22654__$1,inst_22652);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0 = (function (){
var statearr_22657 = [null,null,null,null,null,null,null,null];
(statearr_22657[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__);

(statearr_22657[(1)] = (1));

return statearr_22657;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1 = (function (state_22654){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_22654);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e22658){var ex__20480__auto__ = e22658;
var statearr_22659_22824 = state_22654;
(statearr_22659_22824[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_22654[(4)]))){
var statearr_22660_22825 = state_22654;
(statearr_22660_22825[(1)] = cljs.core.first((state_22654[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__22826 = state_22654;
state_22654 = G__22826;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__ = function(state_22654){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1.call(this,state_22654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_22661 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_22661[(6)] = c__20603__auto___22823);

return statearr_22661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__22662){
var vec__22663 = p__22662;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22663,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__22663,(1),null);
var job = vec__22663;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4706__auto___22827 = n;
var __22828 = (0);
while(true){
if((__22828 < n__4706__auto___22827)){
var G__22666_22829 = type;
var G__22666_22830__$1 = (((G__22666_22829 instanceof cljs.core.Keyword))?G__22666_22829.fqn:null);
switch (G__22666_22830__$1) {
case "compute":
var c__20603__auto___22832 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__22828,c__20603__auto___22832,G__22666_22829,G__22666_22830__$1,n__4706__auto___22827,jobs,results,process,async){
return (function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = ((function (__22828,c__20603__auto___22832,G__22666_22829,G__22666_22830__$1,n__4706__auto___22827,jobs,results,process,async){
return (function (state_22679){
var state_val_22680 = (state_22679[(1)]);
if((state_val_22680 === (1))){
var state_22679__$1 = state_22679;
var statearr_22681_22833 = state_22679__$1;
(statearr_22681_22833[(2)] = null);

(statearr_22681_22833[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22680 === (2))){
var state_22679__$1 = state_22679;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22679__$1,(4),jobs);
} else {
if((state_val_22680 === (3))){
var inst_22677 = (state_22679[(2)]);
var state_22679__$1 = state_22679;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22679__$1,inst_22677);
} else {
if((state_val_22680 === (4))){
var inst_22669 = (state_22679[(2)]);
var inst_22670 = process(inst_22669);
var state_22679__$1 = state_22679;
if(cljs.core.truth_(inst_22670)){
var statearr_22682_22834 = state_22679__$1;
(statearr_22682_22834[(1)] = (5));

} else {
var statearr_22683_22835 = state_22679__$1;
(statearr_22683_22835[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22680 === (5))){
var state_22679__$1 = state_22679;
var statearr_22684_22836 = state_22679__$1;
(statearr_22684_22836[(2)] = null);

(statearr_22684_22836[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22680 === (6))){
var state_22679__$1 = state_22679;
var statearr_22685_22837 = state_22679__$1;
(statearr_22685_22837[(2)] = null);

(statearr_22685_22837[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22680 === (7))){
var inst_22675 = (state_22679[(2)]);
var state_22679__$1 = state_22679;
var statearr_22686_22838 = state_22679__$1;
(statearr_22686_22838[(2)] = inst_22675);

(statearr_22686_22838[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__22828,c__20603__auto___22832,G__22666_22829,G__22666_22830__$1,n__4706__auto___22827,jobs,results,process,async))
;
return ((function (__22828,switch__20476__auto__,c__20603__auto___22832,G__22666_22829,G__22666_22830__$1,n__4706__auto___22827,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0 = (function (){
var statearr_22687 = [null,null,null,null,null,null,null];
(statearr_22687[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__);

(statearr_22687[(1)] = (1));

return statearr_22687;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1 = (function (state_22679){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_22679);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e22688){var ex__20480__auto__ = e22688;
var statearr_22689_22839 = state_22679;
(statearr_22689_22839[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_22679[(4)]))){
var statearr_22690_22840 = state_22679;
(statearr_22690_22840[(1)] = cljs.core.first((state_22679[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__22841 = state_22679;
state_22679 = G__22841;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__ = function(state_22679){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1.call(this,state_22679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__;
})()
;})(__22828,switch__20476__auto__,c__20603__auto___22832,G__22666_22829,G__22666_22830__$1,n__4706__auto___22827,jobs,results,process,async))
})();
var state__20605__auto__ = (function (){var statearr_22691 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_22691[(6)] = c__20603__auto___22832);

return statearr_22691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
});})(__22828,c__20603__auto___22832,G__22666_22829,G__22666_22830__$1,n__4706__auto___22827,jobs,results,process,async))
);


break;
case "async":
var c__20603__auto___22842 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__22828,c__20603__auto___22842,G__22666_22829,G__22666_22830__$1,n__4706__auto___22827,jobs,results,process,async){
return (function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = ((function (__22828,c__20603__auto___22842,G__22666_22829,G__22666_22830__$1,n__4706__auto___22827,jobs,results,process,async){
return (function (state_22704){
var state_val_22705 = (state_22704[(1)]);
if((state_val_22705 === (1))){
var state_22704__$1 = state_22704;
var statearr_22706_22843 = state_22704__$1;
(statearr_22706_22843[(2)] = null);

(statearr_22706_22843[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22705 === (2))){
var state_22704__$1 = state_22704;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22704__$1,(4),jobs);
} else {
if((state_val_22705 === (3))){
var inst_22702 = (state_22704[(2)]);
var state_22704__$1 = state_22704;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22704__$1,inst_22702);
} else {
if((state_val_22705 === (4))){
var inst_22694 = (state_22704[(2)]);
var inst_22695 = async(inst_22694);
var state_22704__$1 = state_22704;
if(cljs.core.truth_(inst_22695)){
var statearr_22707_22844 = state_22704__$1;
(statearr_22707_22844[(1)] = (5));

} else {
var statearr_22708_22845 = state_22704__$1;
(statearr_22708_22845[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22705 === (5))){
var state_22704__$1 = state_22704;
var statearr_22709_22846 = state_22704__$1;
(statearr_22709_22846[(2)] = null);

(statearr_22709_22846[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22705 === (6))){
var state_22704__$1 = state_22704;
var statearr_22710_22847 = state_22704__$1;
(statearr_22710_22847[(2)] = null);

(statearr_22710_22847[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22705 === (7))){
var inst_22700 = (state_22704[(2)]);
var state_22704__$1 = state_22704;
var statearr_22711_22848 = state_22704__$1;
(statearr_22711_22848[(2)] = inst_22700);

(statearr_22711_22848[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__22828,c__20603__auto___22842,G__22666_22829,G__22666_22830__$1,n__4706__auto___22827,jobs,results,process,async))
;
return ((function (__22828,switch__20476__auto__,c__20603__auto___22842,G__22666_22829,G__22666_22830__$1,n__4706__auto___22827,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0 = (function (){
var statearr_22712 = [null,null,null,null,null,null,null];
(statearr_22712[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__);

(statearr_22712[(1)] = (1));

return statearr_22712;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1 = (function (state_22704){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_22704);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e22713){var ex__20480__auto__ = e22713;
var statearr_22714_22849 = state_22704;
(statearr_22714_22849[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_22704[(4)]))){
var statearr_22715_22850 = state_22704;
(statearr_22715_22850[(1)] = cljs.core.first((state_22704[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__22851 = state_22704;
state_22704 = G__22851;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__ = function(state_22704){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1.call(this,state_22704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__;
})()
;})(__22828,switch__20476__auto__,c__20603__auto___22842,G__22666_22829,G__22666_22830__$1,n__4706__auto___22827,jobs,results,process,async))
})();
var state__20605__auto__ = (function (){var statearr_22716 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_22716[(6)] = c__20603__auto___22842);

return statearr_22716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
});})(__22828,c__20603__auto___22842,G__22666_22829,G__22666_22830__$1,n__4706__auto___22827,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__22666_22830__$1)].join('')));

}

var G__22852 = (__22828 + (1));
__22828 = G__22852;
continue;
} else {
}
break;
}

var c__20603__auto___22853 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_22738){
var state_val_22739 = (state_22738[(1)]);
if((state_val_22739 === (7))){
var inst_22734 = (state_22738[(2)]);
var state_22738__$1 = state_22738;
var statearr_22740_22854 = state_22738__$1;
(statearr_22740_22854[(2)] = inst_22734);

(statearr_22740_22854[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22739 === (1))){
var state_22738__$1 = state_22738;
var statearr_22741_22855 = state_22738__$1;
(statearr_22741_22855[(2)] = null);

(statearr_22741_22855[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22739 === (4))){
var inst_22719 = (state_22738[(7)]);
var inst_22719__$1 = (state_22738[(2)]);
var inst_22720 = (inst_22719__$1 == null);
var state_22738__$1 = (function (){var statearr_22742 = state_22738;
(statearr_22742[(7)] = inst_22719__$1);

return statearr_22742;
})();
if(cljs.core.truth_(inst_22720)){
var statearr_22743_22856 = state_22738__$1;
(statearr_22743_22856[(1)] = (5));

} else {
var statearr_22744_22857 = state_22738__$1;
(statearr_22744_22857[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22739 === (6))){
var inst_22724 = (state_22738[(8)]);
var inst_22719 = (state_22738[(7)]);
var inst_22724__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_22725 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22726 = [inst_22719,inst_22724__$1];
var inst_22727 = (new cljs.core.PersistentVector(null,2,(5),inst_22725,inst_22726,null));
var state_22738__$1 = (function (){var statearr_22745 = state_22738;
(statearr_22745[(8)] = inst_22724__$1);

return statearr_22745;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22738__$1,(8),jobs,inst_22727);
} else {
if((state_val_22739 === (3))){
var inst_22736 = (state_22738[(2)]);
var state_22738__$1 = state_22738;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22738__$1,inst_22736);
} else {
if((state_val_22739 === (2))){
var state_22738__$1 = state_22738;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22738__$1,(4),from);
} else {
if((state_val_22739 === (9))){
var inst_22731 = (state_22738[(2)]);
var state_22738__$1 = (function (){var statearr_22746 = state_22738;
(statearr_22746[(9)] = inst_22731);

return statearr_22746;
})();
var statearr_22747_22858 = state_22738__$1;
(statearr_22747_22858[(2)] = null);

(statearr_22747_22858[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22739 === (5))){
var inst_22722 = cljs.core.async.close_BANG_(jobs);
var state_22738__$1 = state_22738;
var statearr_22748_22859 = state_22738__$1;
(statearr_22748_22859[(2)] = inst_22722);

(statearr_22748_22859[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22739 === (8))){
var inst_22724 = (state_22738[(8)]);
var inst_22729 = (state_22738[(2)]);
var state_22738__$1 = (function (){var statearr_22749 = state_22738;
(statearr_22749[(10)] = inst_22729);

return statearr_22749;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22738__$1,(9),results,inst_22724);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0 = (function (){
var statearr_22750 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_22750[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__);

(statearr_22750[(1)] = (1));

return statearr_22750;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1 = (function (state_22738){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_22738);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e22751){var ex__20480__auto__ = e22751;
var statearr_22752_22860 = state_22738;
(statearr_22752_22860[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_22738[(4)]))){
var statearr_22753_22861 = state_22738;
(statearr_22753_22861[(1)] = cljs.core.first((state_22738[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__22862 = state_22738;
state_22738 = G__22862;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__ = function(state_22738){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1.call(this,state_22738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_22754 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_22754[(6)] = c__20603__auto___22853);

return statearr_22754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_22792){
var state_val_22793 = (state_22792[(1)]);
if((state_val_22793 === (7))){
var inst_22788 = (state_22792[(2)]);
var state_22792__$1 = state_22792;
var statearr_22794_22863 = state_22792__$1;
(statearr_22794_22863[(2)] = inst_22788);

(statearr_22794_22863[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (20))){
var state_22792__$1 = state_22792;
var statearr_22795_22864 = state_22792__$1;
(statearr_22795_22864[(2)] = null);

(statearr_22795_22864[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (1))){
var state_22792__$1 = state_22792;
var statearr_22796_22865 = state_22792__$1;
(statearr_22796_22865[(2)] = null);

(statearr_22796_22865[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (4))){
var inst_22757 = (state_22792[(7)]);
var inst_22757__$1 = (state_22792[(2)]);
var inst_22758 = (inst_22757__$1 == null);
var state_22792__$1 = (function (){var statearr_22797 = state_22792;
(statearr_22797[(7)] = inst_22757__$1);

return statearr_22797;
})();
if(cljs.core.truth_(inst_22758)){
var statearr_22798_22866 = state_22792__$1;
(statearr_22798_22866[(1)] = (5));

} else {
var statearr_22799_22867 = state_22792__$1;
(statearr_22799_22867[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (15))){
var inst_22770 = (state_22792[(8)]);
var state_22792__$1 = state_22792;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22792__$1,(18),to,inst_22770);
} else {
if((state_val_22793 === (21))){
var inst_22783 = (state_22792[(2)]);
var state_22792__$1 = state_22792;
var statearr_22800_22868 = state_22792__$1;
(statearr_22800_22868[(2)] = inst_22783);

(statearr_22800_22868[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (13))){
var inst_22785 = (state_22792[(2)]);
var state_22792__$1 = (function (){var statearr_22801 = state_22792;
(statearr_22801[(9)] = inst_22785);

return statearr_22801;
})();
var statearr_22802_22869 = state_22792__$1;
(statearr_22802_22869[(2)] = null);

(statearr_22802_22869[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (6))){
var inst_22757 = (state_22792[(7)]);
var state_22792__$1 = state_22792;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22792__$1,(11),inst_22757);
} else {
if((state_val_22793 === (17))){
var inst_22778 = (state_22792[(2)]);
var state_22792__$1 = state_22792;
if(cljs.core.truth_(inst_22778)){
var statearr_22803_22870 = state_22792__$1;
(statearr_22803_22870[(1)] = (19));

} else {
var statearr_22804_22871 = state_22792__$1;
(statearr_22804_22871[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (3))){
var inst_22790 = (state_22792[(2)]);
var state_22792__$1 = state_22792;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22792__$1,inst_22790);
} else {
if((state_val_22793 === (12))){
var inst_22767 = (state_22792[(10)]);
var state_22792__$1 = state_22792;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22792__$1,(14),inst_22767);
} else {
if((state_val_22793 === (2))){
var state_22792__$1 = state_22792;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22792__$1,(4),results);
} else {
if((state_val_22793 === (19))){
var state_22792__$1 = state_22792;
var statearr_22805_22872 = state_22792__$1;
(statearr_22805_22872[(2)] = null);

(statearr_22805_22872[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (11))){
var inst_22767 = (state_22792[(2)]);
var state_22792__$1 = (function (){var statearr_22806 = state_22792;
(statearr_22806[(10)] = inst_22767);

return statearr_22806;
})();
var statearr_22807_22873 = state_22792__$1;
(statearr_22807_22873[(2)] = null);

(statearr_22807_22873[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (9))){
var state_22792__$1 = state_22792;
var statearr_22808_22874 = state_22792__$1;
(statearr_22808_22874[(2)] = null);

(statearr_22808_22874[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (5))){
var state_22792__$1 = state_22792;
if(cljs.core.truth_(close_QMARK_)){
var statearr_22809_22875 = state_22792__$1;
(statearr_22809_22875[(1)] = (8));

} else {
var statearr_22810_22876 = state_22792__$1;
(statearr_22810_22876[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (14))){
var inst_22772 = (state_22792[(11)]);
var inst_22770 = (state_22792[(8)]);
var inst_22770__$1 = (state_22792[(2)]);
var inst_22771 = (inst_22770__$1 == null);
var inst_22772__$1 = cljs.core.not(inst_22771);
var state_22792__$1 = (function (){var statearr_22811 = state_22792;
(statearr_22811[(11)] = inst_22772__$1);

(statearr_22811[(8)] = inst_22770__$1);

return statearr_22811;
})();
if(inst_22772__$1){
var statearr_22812_22877 = state_22792__$1;
(statearr_22812_22877[(1)] = (15));

} else {
var statearr_22813_22878 = state_22792__$1;
(statearr_22813_22878[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (16))){
var inst_22772 = (state_22792[(11)]);
var state_22792__$1 = state_22792;
var statearr_22814_22879 = state_22792__$1;
(statearr_22814_22879[(2)] = inst_22772);

(statearr_22814_22879[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (10))){
var inst_22764 = (state_22792[(2)]);
var state_22792__$1 = state_22792;
var statearr_22815_22880 = state_22792__$1;
(statearr_22815_22880[(2)] = inst_22764);

(statearr_22815_22880[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (18))){
var inst_22775 = (state_22792[(2)]);
var state_22792__$1 = state_22792;
var statearr_22816_22881 = state_22792__$1;
(statearr_22816_22881[(2)] = inst_22775);

(statearr_22816_22881[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22793 === (8))){
var inst_22761 = cljs.core.async.close_BANG_(to);
var state_22792__$1 = state_22792;
var statearr_22817_22882 = state_22792__$1;
(statearr_22817_22882[(2)] = inst_22761);

(statearr_22817_22882[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0 = (function (){
var statearr_22818 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22818[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__);

(statearr_22818[(1)] = (1));

return statearr_22818;
});
var cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1 = (function (state_22792){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_22792);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e22819){var ex__20480__auto__ = e22819;
var statearr_22820_22883 = state_22792;
(statearr_22820_22883[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_22792[(4)]))){
var statearr_22821_22884 = state_22792;
(statearr_22821_22884[(1)] = cljs.core.first((state_22792[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__22885 = state_22792;
state_22792 = G__22885;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__ = function(state_22792){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1.call(this,state_22792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__20477__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_22822 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_22822[(6)] = c__20603__auto__);

return statearr_22822;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__22887 = arguments.length;
switch (G__22887) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__22890 = arguments.length;
switch (G__22890) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__22893 = arguments.length;
switch (G__22893) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__20603__auto___22943 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_22919){
var state_val_22920 = (state_22919[(1)]);
if((state_val_22920 === (7))){
var inst_22915 = (state_22919[(2)]);
var state_22919__$1 = state_22919;
var statearr_22921_22944 = state_22919__$1;
(statearr_22921_22944[(2)] = inst_22915);

(statearr_22921_22944[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22920 === (1))){
var state_22919__$1 = state_22919;
var statearr_22922_22945 = state_22919__$1;
(statearr_22922_22945[(2)] = null);

(statearr_22922_22945[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22920 === (4))){
var inst_22896 = (state_22919[(7)]);
var inst_22896__$1 = (state_22919[(2)]);
var inst_22897 = (inst_22896__$1 == null);
var state_22919__$1 = (function (){var statearr_22923 = state_22919;
(statearr_22923[(7)] = inst_22896__$1);

return statearr_22923;
})();
if(cljs.core.truth_(inst_22897)){
var statearr_22924_22946 = state_22919__$1;
(statearr_22924_22946[(1)] = (5));

} else {
var statearr_22925_22947 = state_22919__$1;
(statearr_22925_22947[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22920 === (13))){
var state_22919__$1 = state_22919;
var statearr_22926_22948 = state_22919__$1;
(statearr_22926_22948[(2)] = null);

(statearr_22926_22948[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22920 === (6))){
var inst_22896 = (state_22919[(7)]);
var inst_22902 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_22896) : p.call(null,inst_22896));
var state_22919__$1 = state_22919;
if(cljs.core.truth_(inst_22902)){
var statearr_22927_22949 = state_22919__$1;
(statearr_22927_22949[(1)] = (9));

} else {
var statearr_22928_22950 = state_22919__$1;
(statearr_22928_22950[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22920 === (3))){
var inst_22917 = (state_22919[(2)]);
var state_22919__$1 = state_22919;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22919__$1,inst_22917);
} else {
if((state_val_22920 === (12))){
var state_22919__$1 = state_22919;
var statearr_22929_22951 = state_22919__$1;
(statearr_22929_22951[(2)] = null);

(statearr_22929_22951[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22920 === (2))){
var state_22919__$1 = state_22919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22919__$1,(4),ch);
} else {
if((state_val_22920 === (11))){
var inst_22896 = (state_22919[(7)]);
var inst_22906 = (state_22919[(2)]);
var state_22919__$1 = state_22919;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_22919__$1,(8),inst_22906,inst_22896);
} else {
if((state_val_22920 === (9))){
var state_22919__$1 = state_22919;
var statearr_22930_22952 = state_22919__$1;
(statearr_22930_22952[(2)] = tc);

(statearr_22930_22952[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22920 === (5))){
var inst_22899 = cljs.core.async.close_BANG_(tc);
var inst_22900 = cljs.core.async.close_BANG_(fc);
var state_22919__$1 = (function (){var statearr_22931 = state_22919;
(statearr_22931[(8)] = inst_22899);

return statearr_22931;
})();
var statearr_22932_22953 = state_22919__$1;
(statearr_22932_22953[(2)] = inst_22900);

(statearr_22932_22953[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22920 === (14))){
var inst_22913 = (state_22919[(2)]);
var state_22919__$1 = state_22919;
var statearr_22933_22954 = state_22919__$1;
(statearr_22933_22954[(2)] = inst_22913);

(statearr_22933_22954[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22920 === (10))){
var state_22919__$1 = state_22919;
var statearr_22934_22955 = state_22919__$1;
(statearr_22934_22955[(2)] = fc);

(statearr_22934_22955[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22920 === (8))){
var inst_22908 = (state_22919[(2)]);
var state_22919__$1 = state_22919;
if(cljs.core.truth_(inst_22908)){
var statearr_22935_22956 = state_22919__$1;
(statearr_22935_22956[(1)] = (12));

} else {
var statearr_22936_22957 = state_22919__$1;
(statearr_22936_22957[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20477__auto__ = null;
var cljs$core$async$state_machine__20477__auto____0 = (function (){
var statearr_22937 = [null,null,null,null,null,null,null,null,null];
(statearr_22937[(0)] = cljs$core$async$state_machine__20477__auto__);

(statearr_22937[(1)] = (1));

return statearr_22937;
});
var cljs$core$async$state_machine__20477__auto____1 = (function (state_22919){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_22919);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e22938){var ex__20480__auto__ = e22938;
var statearr_22939_22958 = state_22919;
(statearr_22939_22958[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_22919[(4)]))){
var statearr_22940_22959 = state_22919;
(statearr_22940_22959[(1)] = cljs.core.first((state_22919[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__22960 = state_22919;
state_22919 = G__22960;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$state_machine__20477__auto__ = function(state_22919){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20477__auto____1.call(this,state_22919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20477__auto____0;
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20477__auto____1;
return cljs$core$async$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_22941 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_22941[(6)] = c__20603__auto___22943);

return statearr_22941;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_22982){
var state_val_22983 = (state_22982[(1)]);
if((state_val_22983 === (7))){
var inst_22978 = (state_22982[(2)]);
var state_22982__$1 = state_22982;
var statearr_22984_23003 = state_22982__$1;
(statearr_22984_23003[(2)] = inst_22978);

(statearr_22984_23003[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22983 === (1))){
var inst_22961 = init;
var inst_22962 = inst_22961;
var state_22982__$1 = (function (){var statearr_22985 = state_22982;
(statearr_22985[(7)] = inst_22962);

return statearr_22985;
})();
var statearr_22986_23004 = state_22982__$1;
(statearr_22986_23004[(2)] = null);

(statearr_22986_23004[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22983 === (4))){
var inst_22965 = (state_22982[(8)]);
var inst_22965__$1 = (state_22982[(2)]);
var inst_22966 = (inst_22965__$1 == null);
var state_22982__$1 = (function (){var statearr_22987 = state_22982;
(statearr_22987[(8)] = inst_22965__$1);

return statearr_22987;
})();
if(cljs.core.truth_(inst_22966)){
var statearr_22988_23005 = state_22982__$1;
(statearr_22988_23005[(1)] = (5));

} else {
var statearr_22989_23006 = state_22982__$1;
(statearr_22989_23006[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22983 === (6))){
var inst_22965 = (state_22982[(8)]);
var inst_22969 = (state_22982[(9)]);
var inst_22962 = (state_22982[(7)]);
var inst_22969__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_22962,inst_22965) : f.call(null,inst_22962,inst_22965));
var inst_22970 = cljs.core.reduced_QMARK_(inst_22969__$1);
var state_22982__$1 = (function (){var statearr_22990 = state_22982;
(statearr_22990[(9)] = inst_22969__$1);

return statearr_22990;
})();
if(inst_22970){
var statearr_22991_23007 = state_22982__$1;
(statearr_22991_23007[(1)] = (8));

} else {
var statearr_22992_23008 = state_22982__$1;
(statearr_22992_23008[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_22983 === (3))){
var inst_22980 = (state_22982[(2)]);
var state_22982__$1 = state_22982;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22982__$1,inst_22980);
} else {
if((state_val_22983 === (2))){
var state_22982__$1 = state_22982;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22982__$1,(4),ch);
} else {
if((state_val_22983 === (9))){
var inst_22969 = (state_22982[(9)]);
var inst_22962 = inst_22969;
var state_22982__$1 = (function (){var statearr_22993 = state_22982;
(statearr_22993[(7)] = inst_22962);

return statearr_22993;
})();
var statearr_22994_23009 = state_22982__$1;
(statearr_22994_23009[(2)] = null);

(statearr_22994_23009[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22983 === (5))){
var inst_22962 = (state_22982[(7)]);
var state_22982__$1 = state_22982;
var statearr_22995_23010 = state_22982__$1;
(statearr_22995_23010[(2)] = inst_22962);

(statearr_22995_23010[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22983 === (10))){
var inst_22976 = (state_22982[(2)]);
var state_22982__$1 = state_22982;
var statearr_22996_23011 = state_22982__$1;
(statearr_22996_23011[(2)] = inst_22976);

(statearr_22996_23011[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_22983 === (8))){
var inst_22969 = (state_22982[(9)]);
var inst_22972 = cljs.core.deref(inst_22969);
var state_22982__$1 = state_22982;
var statearr_22997_23012 = state_22982__$1;
(statearr_22997_23012[(2)] = inst_22972);

(statearr_22997_23012[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__20477__auto__ = null;
var cljs$core$async$reduce_$_state_machine__20477__auto____0 = (function (){
var statearr_22998 = [null,null,null,null,null,null,null,null,null,null];
(statearr_22998[(0)] = cljs$core$async$reduce_$_state_machine__20477__auto__);

(statearr_22998[(1)] = (1));

return statearr_22998;
});
var cljs$core$async$reduce_$_state_machine__20477__auto____1 = (function (state_22982){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_22982);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e22999){var ex__20480__auto__ = e22999;
var statearr_23000_23013 = state_22982;
(statearr_23000_23013[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_22982[(4)]))){
var statearr_23001_23014 = state_22982;
(statearr_23001_23014[(1)] = cljs.core.first((state_22982[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__23015 = state_22982;
state_22982 = G__23015;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__20477__auto__ = function(state_22982){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__20477__auto____1.call(this,state_22982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__20477__auto____0;
cljs$core$async$reduce_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__20477__auto____1;
return cljs$core$async$reduce_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_23002 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_23002[(6)] = c__20603__auto__);

return statearr_23002;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_23021){
var state_val_23022 = (state_23021[(1)]);
if((state_val_23022 === (1))){
var inst_23016 = cljs.core.async.reduce(f__$1,init,ch);
var state_23021__$1 = state_23021;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23021__$1,(2),inst_23016);
} else {
if((state_val_23022 === (2))){
var inst_23018 = (state_23021[(2)]);
var inst_23019 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_23018) : f__$1.call(null,inst_23018));
var state_23021__$1 = state_23021;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23021__$1,inst_23019);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__20477__auto__ = null;
var cljs$core$async$transduce_$_state_machine__20477__auto____0 = (function (){
var statearr_23023 = [null,null,null,null,null,null,null];
(statearr_23023[(0)] = cljs$core$async$transduce_$_state_machine__20477__auto__);

(statearr_23023[(1)] = (1));

return statearr_23023;
});
var cljs$core$async$transduce_$_state_machine__20477__auto____1 = (function (state_23021){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_23021);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e23024){var ex__20480__auto__ = e23024;
var statearr_23025_23028 = state_23021;
(statearr_23025_23028[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_23021[(4)]))){
var statearr_23026_23029 = state_23021;
(statearr_23026_23029[(1)] = cljs.core.first((state_23021[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__23030 = state_23021;
state_23021 = G__23030;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__20477__auto__ = function(state_23021){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__20477__auto____1.call(this,state_23021);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__20477__auto____0;
cljs$core$async$transduce_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__20477__auto____1;
return cljs$core$async$transduce_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_23027 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_23027[(6)] = c__20603__auto__);

return statearr_23027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__23032 = arguments.length;
switch (G__23032) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_23057){
var state_val_23058 = (state_23057[(1)]);
if((state_val_23058 === (7))){
var inst_23039 = (state_23057[(2)]);
var state_23057__$1 = state_23057;
var statearr_23059_23081 = state_23057__$1;
(statearr_23059_23081[(2)] = inst_23039);

(statearr_23059_23081[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23058 === (1))){
var inst_23033 = cljs.core.seq(coll);
var inst_23034 = inst_23033;
var state_23057__$1 = (function (){var statearr_23060 = state_23057;
(statearr_23060[(7)] = inst_23034);

return statearr_23060;
})();
var statearr_23061_23082 = state_23057__$1;
(statearr_23061_23082[(2)] = null);

(statearr_23061_23082[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23058 === (4))){
var inst_23034 = (state_23057[(7)]);
var inst_23037 = cljs.core.first(inst_23034);
var state_23057__$1 = state_23057;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23057__$1,(7),ch,inst_23037);
} else {
if((state_val_23058 === (13))){
var inst_23051 = (state_23057[(2)]);
var state_23057__$1 = state_23057;
var statearr_23062_23083 = state_23057__$1;
(statearr_23062_23083[(2)] = inst_23051);

(statearr_23062_23083[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23058 === (6))){
var inst_23042 = (state_23057[(2)]);
var state_23057__$1 = state_23057;
if(cljs.core.truth_(inst_23042)){
var statearr_23063_23084 = state_23057__$1;
(statearr_23063_23084[(1)] = (8));

} else {
var statearr_23064_23085 = state_23057__$1;
(statearr_23064_23085[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23058 === (3))){
var inst_23055 = (state_23057[(2)]);
var state_23057__$1 = state_23057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23057__$1,inst_23055);
} else {
if((state_val_23058 === (12))){
var state_23057__$1 = state_23057;
var statearr_23065_23086 = state_23057__$1;
(statearr_23065_23086[(2)] = null);

(statearr_23065_23086[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23058 === (2))){
var inst_23034 = (state_23057[(7)]);
var state_23057__$1 = state_23057;
if(cljs.core.truth_(inst_23034)){
var statearr_23066_23087 = state_23057__$1;
(statearr_23066_23087[(1)] = (4));

} else {
var statearr_23067_23088 = state_23057__$1;
(statearr_23067_23088[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23058 === (11))){
var inst_23048 = cljs.core.async.close_BANG_(ch);
var state_23057__$1 = state_23057;
var statearr_23068_23089 = state_23057__$1;
(statearr_23068_23089[(2)] = inst_23048);

(statearr_23068_23089[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23058 === (9))){
var state_23057__$1 = state_23057;
if(cljs.core.truth_(close_QMARK_)){
var statearr_23069_23090 = state_23057__$1;
(statearr_23069_23090[(1)] = (11));

} else {
var statearr_23070_23091 = state_23057__$1;
(statearr_23070_23091[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23058 === (5))){
var inst_23034 = (state_23057[(7)]);
var state_23057__$1 = state_23057;
var statearr_23071_23092 = state_23057__$1;
(statearr_23071_23092[(2)] = inst_23034);

(statearr_23071_23092[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23058 === (10))){
var inst_23053 = (state_23057[(2)]);
var state_23057__$1 = state_23057;
var statearr_23072_23093 = state_23057__$1;
(statearr_23072_23093[(2)] = inst_23053);

(statearr_23072_23093[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23058 === (8))){
var inst_23034 = (state_23057[(7)]);
var inst_23044 = cljs.core.next(inst_23034);
var inst_23034__$1 = inst_23044;
var state_23057__$1 = (function (){var statearr_23073 = state_23057;
(statearr_23073[(7)] = inst_23034__$1);

return statearr_23073;
})();
var statearr_23074_23094 = state_23057__$1;
(statearr_23074_23094[(2)] = null);

(statearr_23074_23094[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20477__auto__ = null;
var cljs$core$async$state_machine__20477__auto____0 = (function (){
var statearr_23075 = [null,null,null,null,null,null,null,null];
(statearr_23075[(0)] = cljs$core$async$state_machine__20477__auto__);

(statearr_23075[(1)] = (1));

return statearr_23075;
});
var cljs$core$async$state_machine__20477__auto____1 = (function (state_23057){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_23057);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e23076){var ex__20480__auto__ = e23076;
var statearr_23077_23095 = state_23057;
(statearr_23077_23095[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_23057[(4)]))){
var statearr_23078_23096 = state_23057;
(statearr_23078_23096[(1)] = cljs.core.first((state_23057[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__23097 = state_23057;
state_23057 = G__23097;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$state_machine__20477__auto__ = function(state_23057){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20477__auto____1.call(this,state_23057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20477__auto____0;
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20477__auto____1;
return cljs$core$async$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_23079 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_23079[(6)] = c__20603__auto__);

return statearr_23079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__23099 = arguments.length;
switch (G__23099) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_23101 = (function (_){
var x__4521__auto__ = (((_ == null))?null:_);
var m__4522__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4522__auto__.call(null,_));
} else {
var m__4519__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4519__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_23101(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_23102 = (function (m,ch,close_QMARK_){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4522__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4519__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4519__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_23102(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_23103 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_23103(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_23104 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4522__auto__.call(null,m));
} else {
var m__4519__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4519__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_23104(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23105 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23105 = (function (ch,cs,meta23106){
this.ch = ch;
this.cs = cs;
this.meta23106 = meta23106;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23105.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23107,meta23106__$1){
var self__ = this;
var _23107__$1 = this;
return (new cljs.core.async.t_cljs$core$async23105(self__.ch,self__.cs,meta23106__$1));
}));

(cljs.core.async.t_cljs$core$async23105.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23107){
var self__ = this;
var _23107__$1 = this;
return self__.meta23106;
}));

(cljs.core.async.t_cljs$core$async23105.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23105.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async23105.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23105.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async23105.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async23105.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async23105.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta23106], null);
}));

(cljs.core.async.t_cljs$core$async23105.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23105.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23105");

(cljs.core.async.t_cljs$core$async23105.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async23105");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23105.
 */
cljs.core.async.__GT_t_cljs$core$async23105 = (function cljs$core$async$mult_$___GT_t_cljs$core$async23105(ch__$1,cs__$1,meta23106){
return (new cljs.core.async.t_cljs$core$async23105(ch__$1,cs__$1,meta23106));
});

}

return (new cljs.core.async.t_cljs$core$async23105(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__20603__auto___23324 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_23240){
var state_val_23241 = (state_23240[(1)]);
if((state_val_23241 === (7))){
var inst_23236 = (state_23240[(2)]);
var state_23240__$1 = state_23240;
var statearr_23242_23325 = state_23240__$1;
(statearr_23242_23325[(2)] = inst_23236);

(statearr_23242_23325[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (20))){
var inst_23141 = (state_23240[(7)]);
var inst_23153 = cljs.core.first(inst_23141);
var inst_23154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23153,(0),null);
var inst_23155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23153,(1),null);
var state_23240__$1 = (function (){var statearr_23243 = state_23240;
(statearr_23243[(8)] = inst_23154);

return statearr_23243;
})();
if(cljs.core.truth_(inst_23155)){
var statearr_23244_23326 = state_23240__$1;
(statearr_23244_23326[(1)] = (22));

} else {
var statearr_23245_23327 = state_23240__$1;
(statearr_23245_23327[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (27))){
var inst_23110 = (state_23240[(9)]);
var inst_23183 = (state_23240[(10)]);
var inst_23185 = (state_23240[(11)]);
var inst_23190 = (state_23240[(12)]);
var inst_23190__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_23183,inst_23185);
var inst_23191 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_23190__$1,inst_23110,done);
var state_23240__$1 = (function (){var statearr_23246 = state_23240;
(statearr_23246[(12)] = inst_23190__$1);

return statearr_23246;
})();
if(cljs.core.truth_(inst_23191)){
var statearr_23247_23328 = state_23240__$1;
(statearr_23247_23328[(1)] = (30));

} else {
var statearr_23248_23329 = state_23240__$1;
(statearr_23248_23329[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (1))){
var state_23240__$1 = state_23240;
var statearr_23249_23330 = state_23240__$1;
(statearr_23249_23330[(2)] = null);

(statearr_23249_23330[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (24))){
var inst_23141 = (state_23240[(7)]);
var inst_23160 = (state_23240[(2)]);
var inst_23161 = cljs.core.next(inst_23141);
var inst_23119 = inst_23161;
var inst_23120 = null;
var inst_23121 = (0);
var inst_23122 = (0);
var state_23240__$1 = (function (){var statearr_23250 = state_23240;
(statearr_23250[(13)] = inst_23121);

(statearr_23250[(14)] = inst_23160);

(statearr_23250[(15)] = inst_23122);

(statearr_23250[(16)] = inst_23120);

(statearr_23250[(17)] = inst_23119);

return statearr_23250;
})();
var statearr_23251_23331 = state_23240__$1;
(statearr_23251_23331[(2)] = null);

(statearr_23251_23331[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (39))){
var state_23240__$1 = state_23240;
var statearr_23255_23332 = state_23240__$1;
(statearr_23255_23332[(2)] = null);

(statearr_23255_23332[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (4))){
var inst_23110 = (state_23240[(9)]);
var inst_23110__$1 = (state_23240[(2)]);
var inst_23111 = (inst_23110__$1 == null);
var state_23240__$1 = (function (){var statearr_23256 = state_23240;
(statearr_23256[(9)] = inst_23110__$1);

return statearr_23256;
})();
if(cljs.core.truth_(inst_23111)){
var statearr_23257_23333 = state_23240__$1;
(statearr_23257_23333[(1)] = (5));

} else {
var statearr_23258_23334 = state_23240__$1;
(statearr_23258_23334[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (15))){
var inst_23121 = (state_23240[(13)]);
var inst_23122 = (state_23240[(15)]);
var inst_23120 = (state_23240[(16)]);
var inst_23119 = (state_23240[(17)]);
var inst_23137 = (state_23240[(2)]);
var inst_23138 = (inst_23122 + (1));
var tmp23252 = inst_23121;
var tmp23253 = inst_23120;
var tmp23254 = inst_23119;
var inst_23119__$1 = tmp23254;
var inst_23120__$1 = tmp23253;
var inst_23121__$1 = tmp23252;
var inst_23122__$1 = inst_23138;
var state_23240__$1 = (function (){var statearr_23259 = state_23240;
(statearr_23259[(18)] = inst_23137);

(statearr_23259[(13)] = inst_23121__$1);

(statearr_23259[(15)] = inst_23122__$1);

(statearr_23259[(16)] = inst_23120__$1);

(statearr_23259[(17)] = inst_23119__$1);

return statearr_23259;
})();
var statearr_23260_23335 = state_23240__$1;
(statearr_23260_23335[(2)] = null);

(statearr_23260_23335[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (21))){
var inst_23164 = (state_23240[(2)]);
var state_23240__$1 = state_23240;
var statearr_23264_23336 = state_23240__$1;
(statearr_23264_23336[(2)] = inst_23164);

(statearr_23264_23336[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (31))){
var inst_23190 = (state_23240[(12)]);
var inst_23194 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_23190);
var state_23240__$1 = state_23240;
var statearr_23265_23337 = state_23240__$1;
(statearr_23265_23337[(2)] = inst_23194);

(statearr_23265_23337[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (32))){
var inst_23182 = (state_23240[(19)]);
var inst_23183 = (state_23240[(10)]);
var inst_23185 = (state_23240[(11)]);
var inst_23184 = (state_23240[(20)]);
var inst_23196 = (state_23240[(2)]);
var inst_23197 = (inst_23185 + (1));
var tmp23261 = inst_23182;
var tmp23262 = inst_23183;
var tmp23263 = inst_23184;
var inst_23182__$1 = tmp23261;
var inst_23183__$1 = tmp23262;
var inst_23184__$1 = tmp23263;
var inst_23185__$1 = inst_23197;
var state_23240__$1 = (function (){var statearr_23266 = state_23240;
(statearr_23266[(19)] = inst_23182__$1);

(statearr_23266[(10)] = inst_23183__$1);

(statearr_23266[(21)] = inst_23196);

(statearr_23266[(11)] = inst_23185__$1);

(statearr_23266[(20)] = inst_23184__$1);

return statearr_23266;
})();
var statearr_23267_23338 = state_23240__$1;
(statearr_23267_23338[(2)] = null);

(statearr_23267_23338[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (40))){
var inst_23209 = (state_23240[(22)]);
var inst_23213 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_23209);
var state_23240__$1 = state_23240;
var statearr_23268_23339 = state_23240__$1;
(statearr_23268_23339[(2)] = inst_23213);

(statearr_23268_23339[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (33))){
var inst_23200 = (state_23240[(23)]);
var inst_23202 = cljs.core.chunked_seq_QMARK_(inst_23200);
var state_23240__$1 = state_23240;
if(inst_23202){
var statearr_23269_23340 = state_23240__$1;
(statearr_23269_23340[(1)] = (36));

} else {
var statearr_23270_23341 = state_23240__$1;
(statearr_23270_23341[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (13))){
var inst_23131 = (state_23240[(24)]);
var inst_23134 = cljs.core.async.close_BANG_(inst_23131);
var state_23240__$1 = state_23240;
var statearr_23271_23342 = state_23240__$1;
(statearr_23271_23342[(2)] = inst_23134);

(statearr_23271_23342[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (22))){
var inst_23154 = (state_23240[(8)]);
var inst_23157 = cljs.core.async.close_BANG_(inst_23154);
var state_23240__$1 = state_23240;
var statearr_23272_23343 = state_23240__$1;
(statearr_23272_23343[(2)] = inst_23157);

(statearr_23272_23343[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (36))){
var inst_23200 = (state_23240[(23)]);
var inst_23204 = cljs.core.chunk_first(inst_23200);
var inst_23205 = cljs.core.chunk_rest(inst_23200);
var inst_23206 = cljs.core.count(inst_23204);
var inst_23182 = inst_23205;
var inst_23183 = inst_23204;
var inst_23184 = inst_23206;
var inst_23185 = (0);
var state_23240__$1 = (function (){var statearr_23273 = state_23240;
(statearr_23273[(19)] = inst_23182);

(statearr_23273[(10)] = inst_23183);

(statearr_23273[(11)] = inst_23185);

(statearr_23273[(20)] = inst_23184);

return statearr_23273;
})();
var statearr_23274_23344 = state_23240__$1;
(statearr_23274_23344[(2)] = null);

(statearr_23274_23344[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (41))){
var inst_23200 = (state_23240[(23)]);
var inst_23215 = (state_23240[(2)]);
var inst_23216 = cljs.core.next(inst_23200);
var inst_23182 = inst_23216;
var inst_23183 = null;
var inst_23184 = (0);
var inst_23185 = (0);
var state_23240__$1 = (function (){var statearr_23275 = state_23240;
(statearr_23275[(19)] = inst_23182);

(statearr_23275[(10)] = inst_23183);

(statearr_23275[(25)] = inst_23215);

(statearr_23275[(11)] = inst_23185);

(statearr_23275[(20)] = inst_23184);

return statearr_23275;
})();
var statearr_23276_23345 = state_23240__$1;
(statearr_23276_23345[(2)] = null);

(statearr_23276_23345[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (43))){
var state_23240__$1 = state_23240;
var statearr_23277_23346 = state_23240__$1;
(statearr_23277_23346[(2)] = null);

(statearr_23277_23346[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (29))){
var inst_23224 = (state_23240[(2)]);
var state_23240__$1 = state_23240;
var statearr_23278_23347 = state_23240__$1;
(statearr_23278_23347[(2)] = inst_23224);

(statearr_23278_23347[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (44))){
var inst_23233 = (state_23240[(2)]);
var state_23240__$1 = (function (){var statearr_23279 = state_23240;
(statearr_23279[(26)] = inst_23233);

return statearr_23279;
})();
var statearr_23280_23348 = state_23240__$1;
(statearr_23280_23348[(2)] = null);

(statearr_23280_23348[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (6))){
var inst_23174 = (state_23240[(27)]);
var inst_23173 = cljs.core.deref(cs);
var inst_23174__$1 = cljs.core.keys(inst_23173);
var inst_23175 = cljs.core.count(inst_23174__$1);
var inst_23176 = cljs.core.reset_BANG_(dctr,inst_23175);
var inst_23181 = cljs.core.seq(inst_23174__$1);
var inst_23182 = inst_23181;
var inst_23183 = null;
var inst_23184 = (0);
var inst_23185 = (0);
var state_23240__$1 = (function (){var statearr_23281 = state_23240;
(statearr_23281[(19)] = inst_23182);

(statearr_23281[(10)] = inst_23183);

(statearr_23281[(28)] = inst_23176);

(statearr_23281[(27)] = inst_23174__$1);

(statearr_23281[(11)] = inst_23185);

(statearr_23281[(20)] = inst_23184);

return statearr_23281;
})();
var statearr_23282_23349 = state_23240__$1;
(statearr_23282_23349[(2)] = null);

(statearr_23282_23349[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (28))){
var inst_23200 = (state_23240[(23)]);
var inst_23182 = (state_23240[(19)]);
var inst_23200__$1 = cljs.core.seq(inst_23182);
var state_23240__$1 = (function (){var statearr_23283 = state_23240;
(statearr_23283[(23)] = inst_23200__$1);

return statearr_23283;
})();
if(inst_23200__$1){
var statearr_23284_23350 = state_23240__$1;
(statearr_23284_23350[(1)] = (33));

} else {
var statearr_23285_23351 = state_23240__$1;
(statearr_23285_23351[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (25))){
var inst_23185 = (state_23240[(11)]);
var inst_23184 = (state_23240[(20)]);
var inst_23187 = (inst_23185 < inst_23184);
var inst_23188 = inst_23187;
var state_23240__$1 = state_23240;
if(cljs.core.truth_(inst_23188)){
var statearr_23286_23352 = state_23240__$1;
(statearr_23286_23352[(1)] = (27));

} else {
var statearr_23287_23353 = state_23240__$1;
(statearr_23287_23353[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (34))){
var state_23240__$1 = state_23240;
var statearr_23288_23354 = state_23240__$1;
(statearr_23288_23354[(2)] = null);

(statearr_23288_23354[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (17))){
var state_23240__$1 = state_23240;
var statearr_23289_23355 = state_23240__$1;
(statearr_23289_23355[(2)] = null);

(statearr_23289_23355[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (3))){
var inst_23238 = (state_23240[(2)]);
var state_23240__$1 = state_23240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23240__$1,inst_23238);
} else {
if((state_val_23241 === (12))){
var inst_23169 = (state_23240[(2)]);
var state_23240__$1 = state_23240;
var statearr_23290_23356 = state_23240__$1;
(statearr_23290_23356[(2)] = inst_23169);

(statearr_23290_23356[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (2))){
var state_23240__$1 = state_23240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23240__$1,(4),ch);
} else {
if((state_val_23241 === (23))){
var state_23240__$1 = state_23240;
var statearr_23291_23357 = state_23240__$1;
(statearr_23291_23357[(2)] = null);

(statearr_23291_23357[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (35))){
var inst_23222 = (state_23240[(2)]);
var state_23240__$1 = state_23240;
var statearr_23292_23358 = state_23240__$1;
(statearr_23292_23358[(2)] = inst_23222);

(statearr_23292_23358[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (19))){
var inst_23141 = (state_23240[(7)]);
var inst_23145 = cljs.core.chunk_first(inst_23141);
var inst_23146 = cljs.core.chunk_rest(inst_23141);
var inst_23147 = cljs.core.count(inst_23145);
var inst_23119 = inst_23146;
var inst_23120 = inst_23145;
var inst_23121 = inst_23147;
var inst_23122 = (0);
var state_23240__$1 = (function (){var statearr_23293 = state_23240;
(statearr_23293[(13)] = inst_23121);

(statearr_23293[(15)] = inst_23122);

(statearr_23293[(16)] = inst_23120);

(statearr_23293[(17)] = inst_23119);

return statearr_23293;
})();
var statearr_23294_23359 = state_23240__$1;
(statearr_23294_23359[(2)] = null);

(statearr_23294_23359[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (11))){
var inst_23141 = (state_23240[(7)]);
var inst_23119 = (state_23240[(17)]);
var inst_23141__$1 = cljs.core.seq(inst_23119);
var state_23240__$1 = (function (){var statearr_23295 = state_23240;
(statearr_23295[(7)] = inst_23141__$1);

return statearr_23295;
})();
if(inst_23141__$1){
var statearr_23296_23360 = state_23240__$1;
(statearr_23296_23360[(1)] = (16));

} else {
var statearr_23297_23361 = state_23240__$1;
(statearr_23297_23361[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (9))){
var inst_23171 = (state_23240[(2)]);
var state_23240__$1 = state_23240;
var statearr_23298_23362 = state_23240__$1;
(statearr_23298_23362[(2)] = inst_23171);

(statearr_23298_23362[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (5))){
var inst_23117 = cljs.core.deref(cs);
var inst_23118 = cljs.core.seq(inst_23117);
var inst_23119 = inst_23118;
var inst_23120 = null;
var inst_23121 = (0);
var inst_23122 = (0);
var state_23240__$1 = (function (){var statearr_23299 = state_23240;
(statearr_23299[(13)] = inst_23121);

(statearr_23299[(15)] = inst_23122);

(statearr_23299[(16)] = inst_23120);

(statearr_23299[(17)] = inst_23119);

return statearr_23299;
})();
var statearr_23300_23363 = state_23240__$1;
(statearr_23300_23363[(2)] = null);

(statearr_23300_23363[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (14))){
var state_23240__$1 = state_23240;
var statearr_23301_23364 = state_23240__$1;
(statearr_23301_23364[(2)] = null);

(statearr_23301_23364[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (45))){
var inst_23230 = (state_23240[(2)]);
var state_23240__$1 = state_23240;
var statearr_23302_23365 = state_23240__$1;
(statearr_23302_23365[(2)] = inst_23230);

(statearr_23302_23365[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (26))){
var inst_23174 = (state_23240[(27)]);
var inst_23226 = (state_23240[(2)]);
var inst_23227 = cljs.core.seq(inst_23174);
var state_23240__$1 = (function (){var statearr_23303 = state_23240;
(statearr_23303[(29)] = inst_23226);

return statearr_23303;
})();
if(inst_23227){
var statearr_23304_23366 = state_23240__$1;
(statearr_23304_23366[(1)] = (42));

} else {
var statearr_23305_23367 = state_23240__$1;
(statearr_23305_23367[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (16))){
var inst_23141 = (state_23240[(7)]);
var inst_23143 = cljs.core.chunked_seq_QMARK_(inst_23141);
var state_23240__$1 = state_23240;
if(inst_23143){
var statearr_23306_23368 = state_23240__$1;
(statearr_23306_23368[(1)] = (19));

} else {
var statearr_23307_23369 = state_23240__$1;
(statearr_23307_23369[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (38))){
var inst_23219 = (state_23240[(2)]);
var state_23240__$1 = state_23240;
var statearr_23308_23370 = state_23240__$1;
(statearr_23308_23370[(2)] = inst_23219);

(statearr_23308_23370[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (30))){
var state_23240__$1 = state_23240;
var statearr_23309_23371 = state_23240__$1;
(statearr_23309_23371[(2)] = null);

(statearr_23309_23371[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (10))){
var inst_23122 = (state_23240[(15)]);
var inst_23120 = (state_23240[(16)]);
var inst_23130 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_23120,inst_23122);
var inst_23131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23130,(0),null);
var inst_23132 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23130,(1),null);
var state_23240__$1 = (function (){var statearr_23310 = state_23240;
(statearr_23310[(24)] = inst_23131);

return statearr_23310;
})();
if(cljs.core.truth_(inst_23132)){
var statearr_23311_23372 = state_23240__$1;
(statearr_23311_23372[(1)] = (13));

} else {
var statearr_23312_23373 = state_23240__$1;
(statearr_23312_23373[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (18))){
var inst_23167 = (state_23240[(2)]);
var state_23240__$1 = state_23240;
var statearr_23313_23374 = state_23240__$1;
(statearr_23313_23374[(2)] = inst_23167);

(statearr_23313_23374[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (42))){
var state_23240__$1 = state_23240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23240__$1,(45),dchan);
} else {
if((state_val_23241 === (37))){
var inst_23200 = (state_23240[(23)]);
var inst_23110 = (state_23240[(9)]);
var inst_23209 = (state_23240[(22)]);
var inst_23209__$1 = cljs.core.first(inst_23200);
var inst_23210 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_23209__$1,inst_23110,done);
var state_23240__$1 = (function (){var statearr_23314 = state_23240;
(statearr_23314[(22)] = inst_23209__$1);

return statearr_23314;
})();
if(cljs.core.truth_(inst_23210)){
var statearr_23315_23375 = state_23240__$1;
(statearr_23315_23375[(1)] = (39));

} else {
var statearr_23316_23376 = state_23240__$1;
(statearr_23316_23376[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23241 === (8))){
var inst_23121 = (state_23240[(13)]);
var inst_23122 = (state_23240[(15)]);
var inst_23124 = (inst_23122 < inst_23121);
var inst_23125 = inst_23124;
var state_23240__$1 = state_23240;
if(cljs.core.truth_(inst_23125)){
var statearr_23317_23377 = state_23240__$1;
(statearr_23317_23377[(1)] = (10));

} else {
var statearr_23318_23378 = state_23240__$1;
(statearr_23318_23378[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__20477__auto__ = null;
var cljs$core$async$mult_$_state_machine__20477__auto____0 = (function (){
var statearr_23319 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23319[(0)] = cljs$core$async$mult_$_state_machine__20477__auto__);

(statearr_23319[(1)] = (1));

return statearr_23319;
});
var cljs$core$async$mult_$_state_machine__20477__auto____1 = (function (state_23240){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_23240);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e23320){var ex__20480__auto__ = e23320;
var statearr_23321_23379 = state_23240;
(statearr_23321_23379[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_23240[(4)]))){
var statearr_23322_23380 = state_23240;
(statearr_23322_23380[(1)] = cljs.core.first((state_23240[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__23381 = state_23240;
state_23240 = G__23381;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__20477__auto__ = function(state_23240){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__20477__auto____1.call(this,state_23240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__20477__auto____0;
cljs$core$async$mult_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__20477__auto____1;
return cljs$core$async$mult_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_23323 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_23323[(6)] = c__20603__auto___23324);

return statearr_23323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__23383 = arguments.length;
switch (G__23383) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_23385 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_23385(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_23386 = (function (m,ch){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4522__auto__.call(null,m,ch));
} else {
var m__4519__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4519__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_23386(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_23387 = (function (m){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4522__auto__.call(null,m));
} else {
var m__4519__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4519__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_23387(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_23388 = (function (m,state_map){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4522__auto__.call(null,m,state_map));
} else {
var m__4519__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4519__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_23388(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_23389 = (function (m,mode){
var x__4521__auto__ = (((m == null))?null:m);
var m__4522__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4522__auto__.call(null,m,mode));
} else {
var m__4519__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4519__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_23389(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4835__auto__ = [];
var len__4829__auto___23399 = arguments.length;
var i__4830__auto___23400 = (0);
while(true){
if((i__4830__auto___23400 < len__4829__auto___23399)){
args__4835__auto__.push((arguments[i__4830__auto___23400]));

var G__23401 = (i__4830__auto___23400 + (1));
i__4830__auto___23400 = G__23401;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((3) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4836__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__23394){
var map__23395 = p__23394;
var map__23395__$1 = cljs.core.__destructure_map(map__23395);
var opts = map__23395__$1;
var statearr_23396_23402 = state;
(statearr_23396_23402[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_23397_23403 = state;
(statearr_23397_23403[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_23398_23404 = state;
(statearr_23398_23404[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq23390){
var G__23391 = cljs.core.first(seq23390);
var seq23390__$1 = cljs.core.next(seq23390);
var G__23392 = cljs.core.first(seq23390__$1);
var seq23390__$2 = cljs.core.next(seq23390__$1);
var G__23393 = cljs.core.first(seq23390__$2);
var seq23390__$3 = cljs.core.next(seq23390__$2);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__23391,G__23392,G__23393,seq23390__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23405 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23405 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta23406){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta23406 = meta23406;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23405.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23407,meta23406__$1){
var self__ = this;
var _23407__$1 = this;
return (new cljs.core.async.t_cljs$core$async23405(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta23406__$1));
}));

(cljs.core.async.t_cljs$core$async23405.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23407){
var self__ = this;
var _23407__$1 = this;
return self__.meta23406;
}));

(cljs.core.async.t_cljs$core$async23405.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23405.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async23405.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23405.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async23405.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async23405.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async23405.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async23405.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async23405.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta23406], null);
}));

(cljs.core.async.t_cljs$core$async23405.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23405.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23405");

(cljs.core.async.t_cljs$core$async23405.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async23405");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23405.
 */
cljs.core.async.__GT_t_cljs$core$async23405 = (function cljs$core$async$mix_$___GT_t_cljs$core$async23405(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta23406){
return (new cljs.core.async.t_cljs$core$async23405(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta23406));
});

}

return (new cljs.core.async.t_cljs$core$async23405(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20603__auto___23520 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_23475){
var state_val_23476 = (state_23475[(1)]);
if((state_val_23476 === (7))){
var inst_23435 = (state_23475[(2)]);
var state_23475__$1 = state_23475;
if(cljs.core.truth_(inst_23435)){
var statearr_23477_23521 = state_23475__$1;
(statearr_23477_23521[(1)] = (8));

} else {
var statearr_23478_23522 = state_23475__$1;
(statearr_23478_23522[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (20))){
var inst_23428 = (state_23475[(7)]);
var state_23475__$1 = state_23475;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23475__$1,(23),out,inst_23428);
} else {
if((state_val_23476 === (1))){
var inst_23411 = calc_state();
var inst_23412 = cljs.core.__destructure_map(inst_23411);
var inst_23413 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23412,cljs.core.cst$kw$solos);
var inst_23414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23412,cljs.core.cst$kw$mutes);
var inst_23415 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23412,cljs.core.cst$kw$reads);
var inst_23416 = inst_23411;
var state_23475__$1 = (function (){var statearr_23479 = state_23475;
(statearr_23479[(8)] = inst_23415);

(statearr_23479[(9)] = inst_23413);

(statearr_23479[(10)] = inst_23414);

(statearr_23479[(11)] = inst_23416);

return statearr_23479;
})();
var statearr_23480_23523 = state_23475__$1;
(statearr_23480_23523[(2)] = null);

(statearr_23480_23523[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (24))){
var inst_23419 = (state_23475[(12)]);
var inst_23416 = inst_23419;
var state_23475__$1 = (function (){var statearr_23481 = state_23475;
(statearr_23481[(11)] = inst_23416);

return statearr_23481;
})();
var statearr_23482_23524 = state_23475__$1;
(statearr_23482_23524[(2)] = null);

(statearr_23482_23524[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (4))){
var inst_23428 = (state_23475[(7)]);
var inst_23430 = (state_23475[(13)]);
var inst_23427 = (state_23475[(2)]);
var inst_23428__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23427,(0),null);
var inst_23429 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23427,(1),null);
var inst_23430__$1 = (inst_23428__$1 == null);
var state_23475__$1 = (function (){var statearr_23483 = state_23475;
(statearr_23483[(14)] = inst_23429);

(statearr_23483[(7)] = inst_23428__$1);

(statearr_23483[(13)] = inst_23430__$1);

return statearr_23483;
})();
if(cljs.core.truth_(inst_23430__$1)){
var statearr_23484_23525 = state_23475__$1;
(statearr_23484_23525[(1)] = (5));

} else {
var statearr_23485_23526 = state_23475__$1;
(statearr_23485_23526[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (15))){
var inst_23420 = (state_23475[(15)]);
var inst_23449 = (state_23475[(16)]);
var inst_23449__$1 = cljs.core.empty_QMARK_(inst_23420);
var state_23475__$1 = (function (){var statearr_23486 = state_23475;
(statearr_23486[(16)] = inst_23449__$1);

return statearr_23486;
})();
if(inst_23449__$1){
var statearr_23487_23527 = state_23475__$1;
(statearr_23487_23527[(1)] = (17));

} else {
var statearr_23488_23528 = state_23475__$1;
(statearr_23488_23528[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (21))){
var inst_23419 = (state_23475[(12)]);
var inst_23416 = inst_23419;
var state_23475__$1 = (function (){var statearr_23489 = state_23475;
(statearr_23489[(11)] = inst_23416);

return statearr_23489;
})();
var statearr_23490_23529 = state_23475__$1;
(statearr_23490_23529[(2)] = null);

(statearr_23490_23529[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (13))){
var inst_23442 = (state_23475[(2)]);
var inst_23443 = calc_state();
var inst_23416 = inst_23443;
var state_23475__$1 = (function (){var statearr_23491 = state_23475;
(statearr_23491[(17)] = inst_23442);

(statearr_23491[(11)] = inst_23416);

return statearr_23491;
})();
var statearr_23492_23530 = state_23475__$1;
(statearr_23492_23530[(2)] = null);

(statearr_23492_23530[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (22))){
var inst_23469 = (state_23475[(2)]);
var state_23475__$1 = state_23475;
var statearr_23493_23531 = state_23475__$1;
(statearr_23493_23531[(2)] = inst_23469);

(statearr_23493_23531[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (6))){
var inst_23429 = (state_23475[(14)]);
var inst_23433 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_23429,change);
var state_23475__$1 = state_23475;
var statearr_23494_23532 = state_23475__$1;
(statearr_23494_23532[(2)] = inst_23433);

(statearr_23494_23532[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (25))){
var state_23475__$1 = state_23475;
var statearr_23495_23533 = state_23475__$1;
(statearr_23495_23533[(2)] = null);

(statearr_23495_23533[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (17))){
var inst_23429 = (state_23475[(14)]);
var inst_23421 = (state_23475[(18)]);
var inst_23451 = (inst_23421.cljs$core$IFn$_invoke$arity$1 ? inst_23421.cljs$core$IFn$_invoke$arity$1(inst_23429) : inst_23421.call(null,inst_23429));
var inst_23452 = cljs.core.not(inst_23451);
var state_23475__$1 = state_23475;
var statearr_23496_23534 = state_23475__$1;
(statearr_23496_23534[(2)] = inst_23452);

(statearr_23496_23534[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (3))){
var inst_23473 = (state_23475[(2)]);
var state_23475__$1 = state_23475;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23475__$1,inst_23473);
} else {
if((state_val_23476 === (12))){
var state_23475__$1 = state_23475;
var statearr_23497_23535 = state_23475__$1;
(statearr_23497_23535[(2)] = null);

(statearr_23497_23535[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (2))){
var inst_23419 = (state_23475[(12)]);
var inst_23416 = (state_23475[(11)]);
var inst_23419__$1 = cljs.core.__destructure_map(inst_23416);
var inst_23420 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23419__$1,cljs.core.cst$kw$solos);
var inst_23421 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23419__$1,cljs.core.cst$kw$mutes);
var inst_23422 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23419__$1,cljs.core.cst$kw$reads);
var state_23475__$1 = (function (){var statearr_23498 = state_23475;
(statearr_23498[(15)] = inst_23420);

(statearr_23498[(12)] = inst_23419__$1);

(statearr_23498[(18)] = inst_23421);

return statearr_23498;
})();
return cljs.core.async.ioc_alts_BANG_(state_23475__$1,(4),inst_23422);
} else {
if((state_val_23476 === (23))){
var inst_23460 = (state_23475[(2)]);
var state_23475__$1 = state_23475;
if(cljs.core.truth_(inst_23460)){
var statearr_23499_23536 = state_23475__$1;
(statearr_23499_23536[(1)] = (24));

} else {
var statearr_23500_23537 = state_23475__$1;
(statearr_23500_23537[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (19))){
var inst_23455 = (state_23475[(2)]);
var state_23475__$1 = state_23475;
var statearr_23501_23538 = state_23475__$1;
(statearr_23501_23538[(2)] = inst_23455);

(statearr_23501_23538[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (11))){
var inst_23429 = (state_23475[(14)]);
var inst_23439 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_23429);
var state_23475__$1 = state_23475;
var statearr_23502_23539 = state_23475__$1;
(statearr_23502_23539[(2)] = inst_23439);

(statearr_23502_23539[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (9))){
var inst_23429 = (state_23475[(14)]);
var inst_23420 = (state_23475[(15)]);
var inst_23446 = (state_23475[(19)]);
var inst_23446__$1 = (inst_23420.cljs$core$IFn$_invoke$arity$1 ? inst_23420.cljs$core$IFn$_invoke$arity$1(inst_23429) : inst_23420.call(null,inst_23429));
var state_23475__$1 = (function (){var statearr_23503 = state_23475;
(statearr_23503[(19)] = inst_23446__$1);

return statearr_23503;
})();
if(cljs.core.truth_(inst_23446__$1)){
var statearr_23504_23540 = state_23475__$1;
(statearr_23504_23540[(1)] = (14));

} else {
var statearr_23505_23541 = state_23475__$1;
(statearr_23505_23541[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (5))){
var inst_23430 = (state_23475[(13)]);
var state_23475__$1 = state_23475;
var statearr_23506_23542 = state_23475__$1;
(statearr_23506_23542[(2)] = inst_23430);

(statearr_23506_23542[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (14))){
var inst_23446 = (state_23475[(19)]);
var state_23475__$1 = state_23475;
var statearr_23507_23543 = state_23475__$1;
(statearr_23507_23543[(2)] = inst_23446);

(statearr_23507_23543[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (26))){
var inst_23465 = (state_23475[(2)]);
var state_23475__$1 = state_23475;
var statearr_23508_23544 = state_23475__$1;
(statearr_23508_23544[(2)] = inst_23465);

(statearr_23508_23544[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (16))){
var inst_23457 = (state_23475[(2)]);
var state_23475__$1 = state_23475;
if(cljs.core.truth_(inst_23457)){
var statearr_23509_23545 = state_23475__$1;
(statearr_23509_23545[(1)] = (20));

} else {
var statearr_23510_23546 = state_23475__$1;
(statearr_23510_23546[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (10))){
var inst_23471 = (state_23475[(2)]);
var state_23475__$1 = state_23475;
var statearr_23511_23547 = state_23475__$1;
(statearr_23511_23547[(2)] = inst_23471);

(statearr_23511_23547[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (18))){
var inst_23449 = (state_23475[(16)]);
var state_23475__$1 = state_23475;
var statearr_23512_23548 = state_23475__$1;
(statearr_23512_23548[(2)] = inst_23449);

(statearr_23512_23548[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23476 === (8))){
var inst_23428 = (state_23475[(7)]);
var inst_23437 = (inst_23428 == null);
var state_23475__$1 = state_23475;
if(cljs.core.truth_(inst_23437)){
var statearr_23513_23549 = state_23475__$1;
(statearr_23513_23549[(1)] = (11));

} else {
var statearr_23514_23550 = state_23475__$1;
(statearr_23514_23550[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__20477__auto__ = null;
var cljs$core$async$mix_$_state_machine__20477__auto____0 = (function (){
var statearr_23515 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23515[(0)] = cljs$core$async$mix_$_state_machine__20477__auto__);

(statearr_23515[(1)] = (1));

return statearr_23515;
});
var cljs$core$async$mix_$_state_machine__20477__auto____1 = (function (state_23475){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_23475);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e23516){var ex__20480__auto__ = e23516;
var statearr_23517_23551 = state_23475;
(statearr_23517_23551[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_23475[(4)]))){
var statearr_23518_23552 = state_23475;
(statearr_23518_23552[(1)] = cljs.core.first((state_23475[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__23553 = state_23475;
state_23475 = G__23553;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__20477__auto__ = function(state_23475){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__20477__auto____1.call(this,state_23475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__20477__auto____0;
cljs$core$async$mix_$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__20477__auto____1;
return cljs$core$async$mix_$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_23519 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_23519[(6)] = c__20603__auto___23520);

return statearr_23519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_23556 = (function (p,v,ch,close_QMARK_){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4522__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4519__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4519__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_23556(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_23557 = (function (p,v,ch){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4522__auto__.call(null,p,v,ch));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4519__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_23557(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_23558 = (function() {
var G__23559 = null;
var G__23559__1 = (function (p){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4522__auto__.call(null,p));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4519__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__23559__2 = (function (p,v){
var x__4521__auto__ = (((p == null))?null:p);
var m__4522__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4521__auto__)]);
if((!((m__4522__auto__ == null)))){
return (m__4522__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4522__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4522__auto__.call(null,p,v));
} else {
var m__4519__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4519__auto__ == null)))){
return (m__4519__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4519__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4519__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__23559 = function(p,v){
switch(arguments.length){
case 1:
return G__23559__1.call(this,p);
case 2:
return G__23559__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__23559.cljs$core$IFn$_invoke$arity$1 = G__23559__1;
G__23559.cljs$core$IFn$_invoke$arity$2 = G__23559__2;
return G__23559;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__23555 = arguments.length;
switch (G__23555) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_23558.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_23558.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__23563 = arguments.length;
switch (G__23563) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__23561_SHARP_){
if(cljs.core.truth_((p1__23561_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__23561_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__23561_SHARP_.call(null,topic)))){
return p1__23561_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__23561_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23564 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23564 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta23565){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta23565 = meta23565;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23564.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23566,meta23565__$1){
var self__ = this;
var _23566__$1 = this;
return (new cljs.core.async.t_cljs$core$async23564(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta23565__$1));
}));

(cljs.core.async.t_cljs$core$async23564.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23566){
var self__ = this;
var _23566__$1 = this;
return self__.meta23565;
}));

(cljs.core.async.t_cljs$core$async23564.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23564.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async23564.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23564.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async23564.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async23564.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async23564.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async23564.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta23565], null);
}));

(cljs.core.async.t_cljs$core$async23564.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23564.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23564");

(cljs.core.async.t_cljs$core$async23564.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async23564");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23564.
 */
cljs.core.async.__GT_t_cljs$core$async23564 = (function cljs$core$async$__GT_t_cljs$core$async23564(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta23565){
return (new cljs.core.async.t_cljs$core$async23564(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta23565));
});

}

return (new cljs.core.async.t_cljs$core$async23564(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__20603__auto___23685 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_23638){
var state_val_23639 = (state_23638[(1)]);
if((state_val_23639 === (7))){
var inst_23634 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
var statearr_23640_23686 = state_23638__$1;
(statearr_23640_23686[(2)] = inst_23634);

(statearr_23640_23686[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (20))){
var state_23638__$1 = state_23638;
var statearr_23641_23687 = state_23638__$1;
(statearr_23641_23687[(2)] = null);

(statearr_23641_23687[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (1))){
var state_23638__$1 = state_23638;
var statearr_23642_23688 = state_23638__$1;
(statearr_23642_23688[(2)] = null);

(statearr_23642_23688[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (24))){
var inst_23617 = (state_23638[(7)]);
var inst_23626 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_23617);
var state_23638__$1 = state_23638;
var statearr_23643_23689 = state_23638__$1;
(statearr_23643_23689[(2)] = inst_23626);

(statearr_23643_23689[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (4))){
var inst_23569 = (state_23638[(8)]);
var inst_23569__$1 = (state_23638[(2)]);
var inst_23570 = (inst_23569__$1 == null);
var state_23638__$1 = (function (){var statearr_23644 = state_23638;
(statearr_23644[(8)] = inst_23569__$1);

return statearr_23644;
})();
if(cljs.core.truth_(inst_23570)){
var statearr_23645_23690 = state_23638__$1;
(statearr_23645_23690[(1)] = (5));

} else {
var statearr_23646_23691 = state_23638__$1;
(statearr_23646_23691[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (15))){
var inst_23611 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
var statearr_23647_23692 = state_23638__$1;
(statearr_23647_23692[(2)] = inst_23611);

(statearr_23647_23692[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (21))){
var inst_23631 = (state_23638[(2)]);
var state_23638__$1 = (function (){var statearr_23648 = state_23638;
(statearr_23648[(9)] = inst_23631);

return statearr_23648;
})();
var statearr_23649_23693 = state_23638__$1;
(statearr_23649_23693[(2)] = null);

(statearr_23649_23693[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (13))){
var inst_23593 = (state_23638[(10)]);
var inst_23595 = cljs.core.chunked_seq_QMARK_(inst_23593);
var state_23638__$1 = state_23638;
if(inst_23595){
var statearr_23650_23694 = state_23638__$1;
(statearr_23650_23694[(1)] = (16));

} else {
var statearr_23651_23695 = state_23638__$1;
(statearr_23651_23695[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (22))){
var inst_23623 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
if(cljs.core.truth_(inst_23623)){
var statearr_23652_23696 = state_23638__$1;
(statearr_23652_23696[(1)] = (23));

} else {
var statearr_23653_23697 = state_23638__$1;
(statearr_23653_23697[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (6))){
var inst_23619 = (state_23638[(11)]);
var inst_23569 = (state_23638[(8)]);
var inst_23617 = (state_23638[(7)]);
var inst_23617__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_23569) : topic_fn.call(null,inst_23569));
var inst_23618 = cljs.core.deref(mults);
var inst_23619__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23618,inst_23617__$1);
var state_23638__$1 = (function (){var statearr_23654 = state_23638;
(statearr_23654[(11)] = inst_23619__$1);

(statearr_23654[(7)] = inst_23617__$1);

return statearr_23654;
})();
if(cljs.core.truth_(inst_23619__$1)){
var statearr_23655_23698 = state_23638__$1;
(statearr_23655_23698[(1)] = (19));

} else {
var statearr_23656_23699 = state_23638__$1;
(statearr_23656_23699[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (25))){
var inst_23628 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
var statearr_23657_23700 = state_23638__$1;
(statearr_23657_23700[(2)] = inst_23628);

(statearr_23657_23700[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (17))){
var inst_23593 = (state_23638[(10)]);
var inst_23602 = cljs.core.first(inst_23593);
var inst_23603 = cljs.core.async.muxch_STAR_(inst_23602);
var inst_23604 = cljs.core.async.close_BANG_(inst_23603);
var inst_23605 = cljs.core.next(inst_23593);
var inst_23579 = inst_23605;
var inst_23580 = null;
var inst_23581 = (0);
var inst_23582 = (0);
var state_23638__$1 = (function (){var statearr_23658 = state_23638;
(statearr_23658[(12)] = inst_23581);

(statearr_23658[(13)] = inst_23580);

(statearr_23658[(14)] = inst_23604);

(statearr_23658[(15)] = inst_23582);

(statearr_23658[(16)] = inst_23579);

return statearr_23658;
})();
var statearr_23659_23701 = state_23638__$1;
(statearr_23659_23701[(2)] = null);

(statearr_23659_23701[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (3))){
var inst_23636 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23638__$1,inst_23636);
} else {
if((state_val_23639 === (12))){
var inst_23613 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
var statearr_23660_23702 = state_23638__$1;
(statearr_23660_23702[(2)] = inst_23613);

(statearr_23660_23702[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (2))){
var state_23638__$1 = state_23638;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23638__$1,(4),ch);
} else {
if((state_val_23639 === (23))){
var state_23638__$1 = state_23638;
var statearr_23661_23703 = state_23638__$1;
(statearr_23661_23703[(2)] = null);

(statearr_23661_23703[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (19))){
var inst_23619 = (state_23638[(11)]);
var inst_23569 = (state_23638[(8)]);
var inst_23621 = cljs.core.async.muxch_STAR_(inst_23619);
var state_23638__$1 = state_23638;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23638__$1,(22),inst_23621,inst_23569);
} else {
if((state_val_23639 === (11))){
var inst_23579 = (state_23638[(16)]);
var inst_23593 = (state_23638[(10)]);
var inst_23593__$1 = cljs.core.seq(inst_23579);
var state_23638__$1 = (function (){var statearr_23662 = state_23638;
(statearr_23662[(10)] = inst_23593__$1);

return statearr_23662;
})();
if(inst_23593__$1){
var statearr_23663_23704 = state_23638__$1;
(statearr_23663_23704[(1)] = (13));

} else {
var statearr_23664_23705 = state_23638__$1;
(statearr_23664_23705[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (9))){
var inst_23615 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
var statearr_23665_23706 = state_23638__$1;
(statearr_23665_23706[(2)] = inst_23615);

(statearr_23665_23706[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (5))){
var inst_23576 = cljs.core.deref(mults);
var inst_23577 = cljs.core.vals(inst_23576);
var inst_23578 = cljs.core.seq(inst_23577);
var inst_23579 = inst_23578;
var inst_23580 = null;
var inst_23581 = (0);
var inst_23582 = (0);
var state_23638__$1 = (function (){var statearr_23666 = state_23638;
(statearr_23666[(12)] = inst_23581);

(statearr_23666[(13)] = inst_23580);

(statearr_23666[(15)] = inst_23582);

(statearr_23666[(16)] = inst_23579);

return statearr_23666;
})();
var statearr_23667_23707 = state_23638__$1;
(statearr_23667_23707[(2)] = null);

(statearr_23667_23707[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (14))){
var state_23638__$1 = state_23638;
var statearr_23671_23708 = state_23638__$1;
(statearr_23671_23708[(2)] = null);

(statearr_23671_23708[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (16))){
var inst_23593 = (state_23638[(10)]);
var inst_23597 = cljs.core.chunk_first(inst_23593);
var inst_23598 = cljs.core.chunk_rest(inst_23593);
var inst_23599 = cljs.core.count(inst_23597);
var inst_23579 = inst_23598;
var inst_23580 = inst_23597;
var inst_23581 = inst_23599;
var inst_23582 = (0);
var state_23638__$1 = (function (){var statearr_23672 = state_23638;
(statearr_23672[(12)] = inst_23581);

(statearr_23672[(13)] = inst_23580);

(statearr_23672[(15)] = inst_23582);

(statearr_23672[(16)] = inst_23579);

return statearr_23672;
})();
var statearr_23673_23709 = state_23638__$1;
(statearr_23673_23709[(2)] = null);

(statearr_23673_23709[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (10))){
var inst_23581 = (state_23638[(12)]);
var inst_23580 = (state_23638[(13)]);
var inst_23582 = (state_23638[(15)]);
var inst_23579 = (state_23638[(16)]);
var inst_23587 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_23580,inst_23582);
var inst_23588 = cljs.core.async.muxch_STAR_(inst_23587);
var inst_23589 = cljs.core.async.close_BANG_(inst_23588);
var inst_23590 = (inst_23582 + (1));
var tmp23668 = inst_23581;
var tmp23669 = inst_23580;
var tmp23670 = inst_23579;
var inst_23579__$1 = tmp23670;
var inst_23580__$1 = tmp23669;
var inst_23581__$1 = tmp23668;
var inst_23582__$1 = inst_23590;
var state_23638__$1 = (function (){var statearr_23674 = state_23638;
(statearr_23674[(12)] = inst_23581__$1);

(statearr_23674[(13)] = inst_23580__$1);

(statearr_23674[(15)] = inst_23582__$1);

(statearr_23674[(16)] = inst_23579__$1);

(statearr_23674[(17)] = inst_23589);

return statearr_23674;
})();
var statearr_23675_23710 = state_23638__$1;
(statearr_23675_23710[(2)] = null);

(statearr_23675_23710[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (18))){
var inst_23608 = (state_23638[(2)]);
var state_23638__$1 = state_23638;
var statearr_23676_23711 = state_23638__$1;
(statearr_23676_23711[(2)] = inst_23608);

(statearr_23676_23711[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23639 === (8))){
var inst_23581 = (state_23638[(12)]);
var inst_23582 = (state_23638[(15)]);
var inst_23584 = (inst_23582 < inst_23581);
var inst_23585 = inst_23584;
var state_23638__$1 = state_23638;
if(cljs.core.truth_(inst_23585)){
var statearr_23677_23712 = state_23638__$1;
(statearr_23677_23712[(1)] = (10));

} else {
var statearr_23678_23713 = state_23638__$1;
(statearr_23678_23713[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20477__auto__ = null;
var cljs$core$async$state_machine__20477__auto____0 = (function (){
var statearr_23679 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23679[(0)] = cljs$core$async$state_machine__20477__auto__);

(statearr_23679[(1)] = (1));

return statearr_23679;
});
var cljs$core$async$state_machine__20477__auto____1 = (function (state_23638){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_23638);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e23680){var ex__20480__auto__ = e23680;
var statearr_23681_23714 = state_23638;
(statearr_23681_23714[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_23638[(4)]))){
var statearr_23682_23715 = state_23638;
(statearr_23682_23715[(1)] = cljs.core.first((state_23638[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__23716 = state_23638;
state_23638 = G__23716;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$state_machine__20477__auto__ = function(state_23638){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20477__auto____1.call(this,state_23638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20477__auto____0;
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20477__auto____1;
return cljs$core$async$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_23683 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_23683[(6)] = c__20603__auto___23685);

return statearr_23683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__23718 = arguments.length;
switch (G__23718) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__23721 = arguments.length;
switch (G__23721) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__23724 = arguments.length;
switch (G__23724) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__20603__auto___23802 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_23767){
var state_val_23768 = (state_23767[(1)]);
if((state_val_23768 === (7))){
var state_23767__$1 = state_23767;
var statearr_23769_23803 = state_23767__$1;
(statearr_23769_23803[(2)] = null);

(statearr_23769_23803[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (1))){
var state_23767__$1 = state_23767;
var statearr_23770_23804 = state_23767__$1;
(statearr_23770_23804[(2)] = null);

(statearr_23770_23804[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (4))){
var inst_23727 = (state_23767[(7)]);
var inst_23728 = (state_23767[(8)]);
var inst_23730 = (inst_23728 < inst_23727);
var state_23767__$1 = state_23767;
if(cljs.core.truth_(inst_23730)){
var statearr_23771_23805 = state_23767__$1;
(statearr_23771_23805[(1)] = (6));

} else {
var statearr_23772_23806 = state_23767__$1;
(statearr_23772_23806[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (15))){
var inst_23753 = (state_23767[(9)]);
var inst_23758 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_23753);
var state_23767__$1 = state_23767;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23767__$1,(17),out,inst_23758);
} else {
if((state_val_23768 === (13))){
var inst_23753 = (state_23767[(9)]);
var inst_23753__$1 = (state_23767[(2)]);
var inst_23754 = cljs.core.some(cljs.core.nil_QMARK_,inst_23753__$1);
var state_23767__$1 = (function (){var statearr_23773 = state_23767;
(statearr_23773[(9)] = inst_23753__$1);

return statearr_23773;
})();
if(cljs.core.truth_(inst_23754)){
var statearr_23774_23807 = state_23767__$1;
(statearr_23774_23807[(1)] = (14));

} else {
var statearr_23775_23808 = state_23767__$1;
(statearr_23775_23808[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (6))){
var state_23767__$1 = state_23767;
var statearr_23776_23809 = state_23767__$1;
(statearr_23776_23809[(2)] = null);

(statearr_23776_23809[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (17))){
var inst_23760 = (state_23767[(2)]);
var state_23767__$1 = (function (){var statearr_23778 = state_23767;
(statearr_23778[(10)] = inst_23760);

return statearr_23778;
})();
var statearr_23779_23810 = state_23767__$1;
(statearr_23779_23810[(2)] = null);

(statearr_23779_23810[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (3))){
var inst_23765 = (state_23767[(2)]);
var state_23767__$1 = state_23767;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23767__$1,inst_23765);
} else {
if((state_val_23768 === (12))){
var _ = (function (){var statearr_23780 = state_23767;
(statearr_23780[(4)] = cljs.core.rest((state_23767[(4)])));

return statearr_23780;
})();
var state_23767__$1 = state_23767;
var ex23777 = (state_23767__$1[(2)]);
var statearr_23781_23811 = state_23767__$1;
(statearr_23781_23811[(5)] = ex23777);


if((ex23777 instanceof Object)){
var statearr_23782_23812 = state_23767__$1;
(statearr_23782_23812[(1)] = (11));

(statearr_23782_23812[(5)] = null);

} else {
throw ex23777;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (2))){
var inst_23726 = cljs.core.reset_BANG_(dctr,cnt);
var inst_23727 = cnt;
var inst_23728 = (0);
var state_23767__$1 = (function (){var statearr_23783 = state_23767;
(statearr_23783[(11)] = inst_23726);

(statearr_23783[(7)] = inst_23727);

(statearr_23783[(8)] = inst_23728);

return statearr_23783;
})();
var statearr_23784_23813 = state_23767__$1;
(statearr_23784_23813[(2)] = null);

(statearr_23784_23813[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (11))){
var inst_23732 = (state_23767[(2)]);
var inst_23733 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_23767__$1 = (function (){var statearr_23785 = state_23767;
(statearr_23785[(12)] = inst_23732);

return statearr_23785;
})();
var statearr_23786_23814 = state_23767__$1;
(statearr_23786_23814[(2)] = inst_23733);

(statearr_23786_23814[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (9))){
var inst_23728 = (state_23767[(8)]);
var _ = (function (){var statearr_23787 = state_23767;
(statearr_23787[(4)] = cljs.core.cons((12),(state_23767[(4)])));

return statearr_23787;
})();
var inst_23739 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_23728) : chs__$1.call(null,inst_23728));
var inst_23740 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_23728) : done.call(null,inst_23728));
var inst_23741 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_23739,inst_23740);
var ___$1 = (function (){var statearr_23788 = state_23767;
(statearr_23788[(4)] = cljs.core.rest((state_23767[(4)])));

return statearr_23788;
})();
var state_23767__$1 = state_23767;
var statearr_23789_23815 = state_23767__$1;
(statearr_23789_23815[(2)] = inst_23741);

(statearr_23789_23815[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (5))){
var inst_23751 = (state_23767[(2)]);
var state_23767__$1 = (function (){var statearr_23790 = state_23767;
(statearr_23790[(13)] = inst_23751);

return statearr_23790;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23767__$1,(13),dchan);
} else {
if((state_val_23768 === (14))){
var inst_23756 = cljs.core.async.close_BANG_(out);
var state_23767__$1 = state_23767;
var statearr_23791_23816 = state_23767__$1;
(statearr_23791_23816[(2)] = inst_23756);

(statearr_23791_23816[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (16))){
var inst_23763 = (state_23767[(2)]);
var state_23767__$1 = state_23767;
var statearr_23792_23817 = state_23767__$1;
(statearr_23792_23817[(2)] = inst_23763);

(statearr_23792_23817[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (10))){
var inst_23728 = (state_23767[(8)]);
var inst_23744 = (state_23767[(2)]);
var inst_23745 = (inst_23728 + (1));
var inst_23728__$1 = inst_23745;
var state_23767__$1 = (function (){var statearr_23793 = state_23767;
(statearr_23793[(14)] = inst_23744);

(statearr_23793[(8)] = inst_23728__$1);

return statearr_23793;
})();
var statearr_23794_23818 = state_23767__$1;
(statearr_23794_23818[(2)] = null);

(statearr_23794_23818[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23768 === (8))){
var inst_23749 = (state_23767[(2)]);
var state_23767__$1 = state_23767;
var statearr_23795_23819 = state_23767__$1;
(statearr_23795_23819[(2)] = inst_23749);

(statearr_23795_23819[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20477__auto__ = null;
var cljs$core$async$state_machine__20477__auto____0 = (function (){
var statearr_23796 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23796[(0)] = cljs$core$async$state_machine__20477__auto__);

(statearr_23796[(1)] = (1));

return statearr_23796;
});
var cljs$core$async$state_machine__20477__auto____1 = (function (state_23767){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_23767);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e23797){var ex__20480__auto__ = e23797;
var statearr_23798_23820 = state_23767;
(statearr_23798_23820[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_23767[(4)]))){
var statearr_23799_23821 = state_23767;
(statearr_23799_23821[(1)] = cljs.core.first((state_23767[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__23822 = state_23767;
state_23767 = G__23822;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$state_machine__20477__auto__ = function(state_23767){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20477__auto____1.call(this,state_23767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20477__auto____0;
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20477__auto____1;
return cljs$core$async$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_23800 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_23800[(6)] = c__20603__auto___23802);

return statearr_23800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__23825 = arguments.length;
switch (G__23825) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20603__auto___23880 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_23857){
var state_val_23858 = (state_23857[(1)]);
if((state_val_23858 === (7))){
var inst_23836 = (state_23857[(7)]);
var inst_23837 = (state_23857[(8)]);
var inst_23836__$1 = (state_23857[(2)]);
var inst_23837__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23836__$1,(0),null);
var inst_23838 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23836__$1,(1),null);
var inst_23839 = (inst_23837__$1 == null);
var state_23857__$1 = (function (){var statearr_23859 = state_23857;
(statearr_23859[(9)] = inst_23838);

(statearr_23859[(7)] = inst_23836__$1);

(statearr_23859[(8)] = inst_23837__$1);

return statearr_23859;
})();
if(cljs.core.truth_(inst_23839)){
var statearr_23860_23881 = state_23857__$1;
(statearr_23860_23881[(1)] = (8));

} else {
var statearr_23861_23882 = state_23857__$1;
(statearr_23861_23882[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23858 === (1))){
var inst_23826 = cljs.core.vec(chs);
var inst_23827 = inst_23826;
var state_23857__$1 = (function (){var statearr_23862 = state_23857;
(statearr_23862[(10)] = inst_23827);

return statearr_23862;
})();
var statearr_23863_23883 = state_23857__$1;
(statearr_23863_23883[(2)] = null);

(statearr_23863_23883[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23858 === (4))){
var inst_23827 = (state_23857[(10)]);
var state_23857__$1 = state_23857;
return cljs.core.async.ioc_alts_BANG_(state_23857__$1,(7),inst_23827);
} else {
if((state_val_23858 === (6))){
var inst_23853 = (state_23857[(2)]);
var state_23857__$1 = state_23857;
var statearr_23864_23884 = state_23857__$1;
(statearr_23864_23884[(2)] = inst_23853);

(statearr_23864_23884[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23858 === (3))){
var inst_23855 = (state_23857[(2)]);
var state_23857__$1 = state_23857;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23857__$1,inst_23855);
} else {
if((state_val_23858 === (2))){
var inst_23827 = (state_23857[(10)]);
var inst_23829 = cljs.core.count(inst_23827);
var inst_23830 = (inst_23829 > (0));
var state_23857__$1 = state_23857;
if(cljs.core.truth_(inst_23830)){
var statearr_23866_23885 = state_23857__$1;
(statearr_23866_23885[(1)] = (4));

} else {
var statearr_23867_23886 = state_23857__$1;
(statearr_23867_23886[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23858 === (11))){
var inst_23827 = (state_23857[(10)]);
var inst_23846 = (state_23857[(2)]);
var tmp23865 = inst_23827;
var inst_23827__$1 = tmp23865;
var state_23857__$1 = (function (){var statearr_23868 = state_23857;
(statearr_23868[(10)] = inst_23827__$1);

(statearr_23868[(11)] = inst_23846);

return statearr_23868;
})();
var statearr_23869_23887 = state_23857__$1;
(statearr_23869_23887[(2)] = null);

(statearr_23869_23887[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23858 === (9))){
var inst_23837 = (state_23857[(8)]);
var state_23857__$1 = state_23857;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23857__$1,(11),out,inst_23837);
} else {
if((state_val_23858 === (5))){
var inst_23851 = cljs.core.async.close_BANG_(out);
var state_23857__$1 = state_23857;
var statearr_23870_23888 = state_23857__$1;
(statearr_23870_23888[(2)] = inst_23851);

(statearr_23870_23888[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23858 === (10))){
var inst_23849 = (state_23857[(2)]);
var state_23857__$1 = state_23857;
var statearr_23871_23889 = state_23857__$1;
(statearr_23871_23889[(2)] = inst_23849);

(statearr_23871_23889[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23858 === (8))){
var inst_23827 = (state_23857[(10)]);
var inst_23838 = (state_23857[(9)]);
var inst_23836 = (state_23857[(7)]);
var inst_23837 = (state_23857[(8)]);
var inst_23841 = (function (){var cs = inst_23827;
var vec__23832 = inst_23836;
var v = inst_23837;
var c = inst_23838;
return (function (p1__23823_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__23823_SHARP_);
});
})();
var inst_23842 = cljs.core.filterv(inst_23841,inst_23827);
var inst_23827__$1 = inst_23842;
var state_23857__$1 = (function (){var statearr_23872 = state_23857;
(statearr_23872[(10)] = inst_23827__$1);

return statearr_23872;
})();
var statearr_23873_23890 = state_23857__$1;
(statearr_23873_23890[(2)] = null);

(statearr_23873_23890[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20477__auto__ = null;
var cljs$core$async$state_machine__20477__auto____0 = (function (){
var statearr_23874 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23874[(0)] = cljs$core$async$state_machine__20477__auto__);

(statearr_23874[(1)] = (1));

return statearr_23874;
});
var cljs$core$async$state_machine__20477__auto____1 = (function (state_23857){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_23857);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e23875){var ex__20480__auto__ = e23875;
var statearr_23876_23891 = state_23857;
(statearr_23876_23891[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_23857[(4)]))){
var statearr_23877_23892 = state_23857;
(statearr_23877_23892[(1)] = cljs.core.first((state_23857[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__23893 = state_23857;
state_23857 = G__23893;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$state_machine__20477__auto__ = function(state_23857){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20477__auto____1.call(this,state_23857);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20477__auto____0;
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20477__auto____1;
return cljs$core$async$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_23878 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_23878[(6)] = c__20603__auto___23880);

return statearr_23878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__23895 = arguments.length;
switch (G__23895) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20603__auto___23941 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_23919){
var state_val_23920 = (state_23919[(1)]);
if((state_val_23920 === (7))){
var inst_23901 = (state_23919[(7)]);
var inst_23901__$1 = (state_23919[(2)]);
var inst_23902 = (inst_23901__$1 == null);
var inst_23903 = cljs.core.not(inst_23902);
var state_23919__$1 = (function (){var statearr_23921 = state_23919;
(statearr_23921[(7)] = inst_23901__$1);

return statearr_23921;
})();
if(inst_23903){
var statearr_23922_23942 = state_23919__$1;
(statearr_23922_23942[(1)] = (8));

} else {
var statearr_23923_23943 = state_23919__$1;
(statearr_23923_23943[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23920 === (1))){
var inst_23896 = (0);
var state_23919__$1 = (function (){var statearr_23924 = state_23919;
(statearr_23924[(8)] = inst_23896);

return statearr_23924;
})();
var statearr_23925_23944 = state_23919__$1;
(statearr_23925_23944[(2)] = null);

(statearr_23925_23944[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23920 === (4))){
var state_23919__$1 = state_23919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23919__$1,(7),ch);
} else {
if((state_val_23920 === (6))){
var inst_23914 = (state_23919[(2)]);
var state_23919__$1 = state_23919;
var statearr_23926_23945 = state_23919__$1;
(statearr_23926_23945[(2)] = inst_23914);

(statearr_23926_23945[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23920 === (3))){
var inst_23916 = (state_23919[(2)]);
var inst_23917 = cljs.core.async.close_BANG_(out);
var state_23919__$1 = (function (){var statearr_23927 = state_23919;
(statearr_23927[(9)] = inst_23916);

return statearr_23927;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_23919__$1,inst_23917);
} else {
if((state_val_23920 === (2))){
var inst_23896 = (state_23919[(8)]);
var inst_23898 = (inst_23896 < n);
var state_23919__$1 = state_23919;
if(cljs.core.truth_(inst_23898)){
var statearr_23928_23946 = state_23919__$1;
(statearr_23928_23946[(1)] = (4));

} else {
var statearr_23929_23947 = state_23919__$1;
(statearr_23929_23947[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23920 === (11))){
var inst_23896 = (state_23919[(8)]);
var inst_23906 = (state_23919[(2)]);
var inst_23907 = (inst_23896 + (1));
var inst_23896__$1 = inst_23907;
var state_23919__$1 = (function (){var statearr_23930 = state_23919;
(statearr_23930[(10)] = inst_23906);

(statearr_23930[(8)] = inst_23896__$1);

return statearr_23930;
})();
var statearr_23931_23948 = state_23919__$1;
(statearr_23931_23948[(2)] = null);

(statearr_23931_23948[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23920 === (9))){
var state_23919__$1 = state_23919;
var statearr_23932_23949 = state_23919__$1;
(statearr_23932_23949[(2)] = null);

(statearr_23932_23949[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23920 === (5))){
var state_23919__$1 = state_23919;
var statearr_23933_23950 = state_23919__$1;
(statearr_23933_23950[(2)] = null);

(statearr_23933_23950[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23920 === (10))){
var inst_23911 = (state_23919[(2)]);
var state_23919__$1 = state_23919;
var statearr_23934_23951 = state_23919__$1;
(statearr_23934_23951[(2)] = inst_23911);

(statearr_23934_23951[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23920 === (8))){
var inst_23901 = (state_23919[(7)]);
var state_23919__$1 = state_23919;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23919__$1,(11),out,inst_23901);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20477__auto__ = null;
var cljs$core$async$state_machine__20477__auto____0 = (function (){
var statearr_23935 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_23935[(0)] = cljs$core$async$state_machine__20477__auto__);

(statearr_23935[(1)] = (1));

return statearr_23935;
});
var cljs$core$async$state_machine__20477__auto____1 = (function (state_23919){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_23919);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e23936){var ex__20480__auto__ = e23936;
var statearr_23937_23952 = state_23919;
(statearr_23937_23952[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_23919[(4)]))){
var statearr_23938_23953 = state_23919;
(statearr_23938_23953[(1)] = cljs.core.first((state_23919[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__23954 = state_23919;
state_23919 = G__23954;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$state_machine__20477__auto__ = function(state_23919){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20477__auto____1.call(this,state_23919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20477__auto____0;
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20477__auto____1;
return cljs$core$async$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_23939 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_23939[(6)] = c__20603__auto___23941);

return statearr_23939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23956 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23956 = (function (f,ch,meta23957){
this.f = f;
this.ch = ch;
this.meta23957 = meta23957;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23956.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23958,meta23957__$1){
var self__ = this;
var _23958__$1 = this;
return (new cljs.core.async.t_cljs$core$async23956(self__.f,self__.ch,meta23957__$1));
}));

(cljs.core.async.t_cljs$core$async23956.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23958){
var self__ = this;
var _23958__$1 = this;
return self__.meta23957;
}));

(cljs.core.async.t_cljs$core$async23956.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23956.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async23956.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async23956.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23956.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23959 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23959 = (function (f,ch,meta23957,_,fn1,meta23960){
this.f = f;
this.ch = ch;
this.meta23957 = meta23957;
this._ = _;
this.fn1 = fn1;
this.meta23960 = meta23960;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23959.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23961,meta23960__$1){
var self__ = this;
var _23961__$1 = this;
return (new cljs.core.async.t_cljs$core$async23959(self__.f,self__.ch,self__.meta23957,self__._,self__.fn1,meta23960__$1));
}));

(cljs.core.async.t_cljs$core$async23959.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23961){
var self__ = this;
var _23961__$1 = this;
return self__.meta23960;
}));

(cljs.core.async.t_cljs$core$async23959.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23959.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async23959.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async23959.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__23955_SHARP_){
var G__23962 = (((p1__23955_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__23955_SHARP_) : self__.f.call(null,p1__23955_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__23962) : f1.call(null,G__23962));
});
}));

(cljs.core.async.t_cljs$core$async23959.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta23957,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async23956], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta23960], null);
}));

(cljs.core.async.t_cljs$core$async23959.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23959.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23959");

(cljs.core.async.t_cljs$core$async23959.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async23959");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23959.
 */
cljs.core.async.__GT_t_cljs$core$async23959 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async23959(f__$1,ch__$1,meta23957__$1,___$2,fn1__$1,meta23960){
return (new cljs.core.async.t_cljs$core$async23959(f__$1,ch__$1,meta23957__$1,___$2,fn1__$1,meta23960));
});

}

return (new cljs.core.async.t_cljs$core$async23959(self__.f,self__.ch,self__.meta23957,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4221__auto__ = ret;
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4221__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__23963 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__23963) : self__.f.call(null,G__23963));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async23956.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23956.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async23956.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta23957], null);
}));

(cljs.core.async.t_cljs$core$async23956.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23956.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23956");

(cljs.core.async.t_cljs$core$async23956.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async23956");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23956.
 */
cljs.core.async.__GT_t_cljs$core$async23956 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async23956(f__$1,ch__$1,meta23957){
return (new cljs.core.async.t_cljs$core$async23956(f__$1,ch__$1,meta23957));
});

}

return (new cljs.core.async.t_cljs$core$async23956(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23964 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23964 = (function (f,ch,meta23965){
this.f = f;
this.ch = ch;
this.meta23965 = meta23965;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23964.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23966,meta23965__$1){
var self__ = this;
var _23966__$1 = this;
return (new cljs.core.async.t_cljs$core$async23964(self__.f,self__.ch,meta23965__$1));
}));

(cljs.core.async.t_cljs$core$async23964.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23966){
var self__ = this;
var _23966__$1 = this;
return self__.meta23965;
}));

(cljs.core.async.t_cljs$core$async23964.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23964.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async23964.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23964.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async23964.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23964.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async23964.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta23965], null);
}));

(cljs.core.async.t_cljs$core$async23964.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23964.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23964");

(cljs.core.async.t_cljs$core$async23964.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async23964");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23964.
 */
cljs.core.async.__GT_t_cljs$core$async23964 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async23964(f__$1,ch__$1,meta23965){
return (new cljs.core.async.t_cljs$core$async23964(f__$1,ch__$1,meta23965));
});

}

return (new cljs.core.async.t_cljs$core$async23964(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async23967 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async23967 = (function (p,ch,meta23968){
this.p = p;
this.ch = ch;
this.meta23968 = meta23968;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async23967.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_23969,meta23968__$1){
var self__ = this;
var _23969__$1 = this;
return (new cljs.core.async.t_cljs$core$async23967(self__.p,self__.ch,meta23968__$1));
}));

(cljs.core.async.t_cljs$core$async23967.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_23969){
var self__ = this;
var _23969__$1 = this;
return self__.meta23968;
}));

(cljs.core.async.t_cljs$core$async23967.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23967.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async23967.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async23967.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23967.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async23967.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async23967.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async23967.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta23968], null);
}));

(cljs.core.async.t_cljs$core$async23967.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async23967.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async23967");

(cljs.core.async.t_cljs$core$async23967.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"cljs.core.async/t_cljs$core$async23967");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async23967.
 */
cljs.core.async.__GT_t_cljs$core$async23967 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async23967(p__$1,ch__$1,meta23968){
return (new cljs.core.async.t_cljs$core$async23967(p__$1,ch__$1,meta23968));
});

}

return (new cljs.core.async.t_cljs$core$async23967(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__23971 = arguments.length;
switch (G__23971) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20603__auto___24012 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_23992){
var state_val_23993 = (state_23992[(1)]);
if((state_val_23993 === (7))){
var inst_23988 = (state_23992[(2)]);
var state_23992__$1 = state_23992;
var statearr_23994_24013 = state_23992__$1;
(statearr_23994_24013[(2)] = inst_23988);

(statearr_23994_24013[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23993 === (1))){
var state_23992__$1 = state_23992;
var statearr_23995_24014 = state_23992__$1;
(statearr_23995_24014[(2)] = null);

(statearr_23995_24014[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23993 === (4))){
var inst_23974 = (state_23992[(7)]);
var inst_23974__$1 = (state_23992[(2)]);
var inst_23975 = (inst_23974__$1 == null);
var state_23992__$1 = (function (){var statearr_23996 = state_23992;
(statearr_23996[(7)] = inst_23974__$1);

return statearr_23996;
})();
if(cljs.core.truth_(inst_23975)){
var statearr_23997_24015 = state_23992__$1;
(statearr_23997_24015[(1)] = (5));

} else {
var statearr_23998_24016 = state_23992__$1;
(statearr_23998_24016[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23993 === (6))){
var inst_23974 = (state_23992[(7)]);
var inst_23979 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_23974) : p.call(null,inst_23974));
var state_23992__$1 = state_23992;
if(cljs.core.truth_(inst_23979)){
var statearr_23999_24017 = state_23992__$1;
(statearr_23999_24017[(1)] = (8));

} else {
var statearr_24000_24018 = state_23992__$1;
(statearr_24000_24018[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23993 === (3))){
var inst_23990 = (state_23992[(2)]);
var state_23992__$1 = state_23992;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23992__$1,inst_23990);
} else {
if((state_val_23993 === (2))){
var state_23992__$1 = state_23992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23992__$1,(4),ch);
} else {
if((state_val_23993 === (11))){
var inst_23982 = (state_23992[(2)]);
var state_23992__$1 = state_23992;
var statearr_24001_24019 = state_23992__$1;
(statearr_24001_24019[(2)] = inst_23982);

(statearr_24001_24019[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23993 === (9))){
var state_23992__$1 = state_23992;
var statearr_24002_24020 = state_23992__$1;
(statearr_24002_24020[(2)] = null);

(statearr_24002_24020[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23993 === (5))){
var inst_23977 = cljs.core.async.close_BANG_(out);
var state_23992__$1 = state_23992;
var statearr_24003_24021 = state_23992__$1;
(statearr_24003_24021[(2)] = inst_23977);

(statearr_24003_24021[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23993 === (10))){
var inst_23985 = (state_23992[(2)]);
var state_23992__$1 = (function (){var statearr_24004 = state_23992;
(statearr_24004[(8)] = inst_23985);

return statearr_24004;
})();
var statearr_24005_24022 = state_23992__$1;
(statearr_24005_24022[(2)] = null);

(statearr_24005_24022[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23993 === (8))){
var inst_23974 = (state_23992[(7)]);
var state_23992__$1 = state_23992;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_23992__$1,(11),out,inst_23974);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20477__auto__ = null;
var cljs$core$async$state_machine__20477__auto____0 = (function (){
var statearr_24006 = [null,null,null,null,null,null,null,null,null];
(statearr_24006[(0)] = cljs$core$async$state_machine__20477__auto__);

(statearr_24006[(1)] = (1));

return statearr_24006;
});
var cljs$core$async$state_machine__20477__auto____1 = (function (state_23992){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_23992);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e24007){var ex__20480__auto__ = e24007;
var statearr_24008_24023 = state_23992;
(statearr_24008_24023[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_23992[(4)]))){
var statearr_24009_24024 = state_23992;
(statearr_24009_24024[(1)] = cljs.core.first((state_23992[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__24025 = state_23992;
state_23992 = G__24025;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$state_machine__20477__auto__ = function(state_23992){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20477__auto____1.call(this,state_23992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20477__auto____0;
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20477__auto____1;
return cljs$core$async$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_24010 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_24010[(6)] = c__20603__auto___24012);

return statearr_24010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__24027 = arguments.length;
switch (G__24027) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__20603__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_24090){
var state_val_24091 = (state_24090[(1)]);
if((state_val_24091 === (7))){
var inst_24086 = (state_24090[(2)]);
var state_24090__$1 = state_24090;
var statearr_24092_24131 = state_24090__$1;
(statearr_24092_24131[(2)] = inst_24086);

(statearr_24092_24131[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (20))){
var inst_24056 = (state_24090[(7)]);
var inst_24067 = (state_24090[(2)]);
var inst_24068 = cljs.core.next(inst_24056);
var inst_24042 = inst_24068;
var inst_24043 = null;
var inst_24044 = (0);
var inst_24045 = (0);
var state_24090__$1 = (function (){var statearr_24093 = state_24090;
(statearr_24093[(8)] = inst_24044);

(statearr_24093[(9)] = inst_24045);

(statearr_24093[(10)] = inst_24043);

(statearr_24093[(11)] = inst_24067);

(statearr_24093[(12)] = inst_24042);

return statearr_24093;
})();
var statearr_24094_24132 = state_24090__$1;
(statearr_24094_24132[(2)] = null);

(statearr_24094_24132[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (1))){
var state_24090__$1 = state_24090;
var statearr_24095_24133 = state_24090__$1;
(statearr_24095_24133[(2)] = null);

(statearr_24095_24133[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (4))){
var inst_24031 = (state_24090[(13)]);
var inst_24031__$1 = (state_24090[(2)]);
var inst_24032 = (inst_24031__$1 == null);
var state_24090__$1 = (function (){var statearr_24096 = state_24090;
(statearr_24096[(13)] = inst_24031__$1);

return statearr_24096;
})();
if(cljs.core.truth_(inst_24032)){
var statearr_24097_24134 = state_24090__$1;
(statearr_24097_24134[(1)] = (5));

} else {
var statearr_24098_24135 = state_24090__$1;
(statearr_24098_24135[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (15))){
var state_24090__$1 = state_24090;
var statearr_24102_24136 = state_24090__$1;
(statearr_24102_24136[(2)] = null);

(statearr_24102_24136[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (21))){
var state_24090__$1 = state_24090;
var statearr_24103_24137 = state_24090__$1;
(statearr_24103_24137[(2)] = null);

(statearr_24103_24137[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (13))){
var inst_24044 = (state_24090[(8)]);
var inst_24045 = (state_24090[(9)]);
var inst_24043 = (state_24090[(10)]);
var inst_24042 = (state_24090[(12)]);
var inst_24052 = (state_24090[(2)]);
var inst_24053 = (inst_24045 + (1));
var tmp24099 = inst_24044;
var tmp24100 = inst_24043;
var tmp24101 = inst_24042;
var inst_24042__$1 = tmp24101;
var inst_24043__$1 = tmp24100;
var inst_24044__$1 = tmp24099;
var inst_24045__$1 = inst_24053;
var state_24090__$1 = (function (){var statearr_24104 = state_24090;
(statearr_24104[(14)] = inst_24052);

(statearr_24104[(8)] = inst_24044__$1);

(statearr_24104[(9)] = inst_24045__$1);

(statearr_24104[(10)] = inst_24043__$1);

(statearr_24104[(12)] = inst_24042__$1);

return statearr_24104;
})();
var statearr_24105_24138 = state_24090__$1;
(statearr_24105_24138[(2)] = null);

(statearr_24105_24138[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (22))){
var state_24090__$1 = state_24090;
var statearr_24106_24139 = state_24090__$1;
(statearr_24106_24139[(2)] = null);

(statearr_24106_24139[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (6))){
var inst_24031 = (state_24090[(13)]);
var inst_24040 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_24031) : f.call(null,inst_24031));
var inst_24041 = cljs.core.seq(inst_24040);
var inst_24042 = inst_24041;
var inst_24043 = null;
var inst_24044 = (0);
var inst_24045 = (0);
var state_24090__$1 = (function (){var statearr_24107 = state_24090;
(statearr_24107[(8)] = inst_24044);

(statearr_24107[(9)] = inst_24045);

(statearr_24107[(10)] = inst_24043);

(statearr_24107[(12)] = inst_24042);

return statearr_24107;
})();
var statearr_24108_24140 = state_24090__$1;
(statearr_24108_24140[(2)] = null);

(statearr_24108_24140[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (17))){
var inst_24056 = (state_24090[(7)]);
var inst_24060 = cljs.core.chunk_first(inst_24056);
var inst_24061 = cljs.core.chunk_rest(inst_24056);
var inst_24062 = cljs.core.count(inst_24060);
var inst_24042 = inst_24061;
var inst_24043 = inst_24060;
var inst_24044 = inst_24062;
var inst_24045 = (0);
var state_24090__$1 = (function (){var statearr_24109 = state_24090;
(statearr_24109[(8)] = inst_24044);

(statearr_24109[(9)] = inst_24045);

(statearr_24109[(10)] = inst_24043);

(statearr_24109[(12)] = inst_24042);

return statearr_24109;
})();
var statearr_24110_24141 = state_24090__$1;
(statearr_24110_24141[(2)] = null);

(statearr_24110_24141[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (3))){
var inst_24088 = (state_24090[(2)]);
var state_24090__$1 = state_24090;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24090__$1,inst_24088);
} else {
if((state_val_24091 === (12))){
var inst_24076 = (state_24090[(2)]);
var state_24090__$1 = state_24090;
var statearr_24111_24142 = state_24090__$1;
(statearr_24111_24142[(2)] = inst_24076);

(statearr_24111_24142[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (2))){
var state_24090__$1 = state_24090;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24090__$1,(4),in$);
} else {
if((state_val_24091 === (23))){
var inst_24084 = (state_24090[(2)]);
var state_24090__$1 = state_24090;
var statearr_24112_24143 = state_24090__$1;
(statearr_24112_24143[(2)] = inst_24084);

(statearr_24112_24143[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (19))){
var inst_24071 = (state_24090[(2)]);
var state_24090__$1 = state_24090;
var statearr_24113_24144 = state_24090__$1;
(statearr_24113_24144[(2)] = inst_24071);

(statearr_24113_24144[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (11))){
var inst_24056 = (state_24090[(7)]);
var inst_24042 = (state_24090[(12)]);
var inst_24056__$1 = cljs.core.seq(inst_24042);
var state_24090__$1 = (function (){var statearr_24114 = state_24090;
(statearr_24114[(7)] = inst_24056__$1);

return statearr_24114;
})();
if(inst_24056__$1){
var statearr_24115_24145 = state_24090__$1;
(statearr_24115_24145[(1)] = (14));

} else {
var statearr_24116_24146 = state_24090__$1;
(statearr_24116_24146[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (9))){
var inst_24078 = (state_24090[(2)]);
var inst_24079 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_24090__$1 = (function (){var statearr_24117 = state_24090;
(statearr_24117[(15)] = inst_24078);

return statearr_24117;
})();
if(cljs.core.truth_(inst_24079)){
var statearr_24118_24147 = state_24090__$1;
(statearr_24118_24147[(1)] = (21));

} else {
var statearr_24119_24148 = state_24090__$1;
(statearr_24119_24148[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (5))){
var inst_24034 = cljs.core.async.close_BANG_(out);
var state_24090__$1 = state_24090;
var statearr_24120_24149 = state_24090__$1;
(statearr_24120_24149[(2)] = inst_24034);

(statearr_24120_24149[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (14))){
var inst_24056 = (state_24090[(7)]);
var inst_24058 = cljs.core.chunked_seq_QMARK_(inst_24056);
var state_24090__$1 = state_24090;
if(inst_24058){
var statearr_24121_24150 = state_24090__$1;
(statearr_24121_24150[(1)] = (17));

} else {
var statearr_24122_24151 = state_24090__$1;
(statearr_24122_24151[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (16))){
var inst_24074 = (state_24090[(2)]);
var state_24090__$1 = state_24090;
var statearr_24123_24152 = state_24090__$1;
(statearr_24123_24152[(2)] = inst_24074);

(statearr_24123_24152[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24091 === (10))){
var inst_24045 = (state_24090[(9)]);
var inst_24043 = (state_24090[(10)]);
var inst_24050 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_24043,inst_24045);
var state_24090__$1 = state_24090;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24090__$1,(13),out,inst_24050);
} else {
if((state_val_24091 === (18))){
var inst_24056 = (state_24090[(7)]);
var inst_24065 = cljs.core.first(inst_24056);
var state_24090__$1 = state_24090;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24090__$1,(20),out,inst_24065);
} else {
if((state_val_24091 === (8))){
var inst_24044 = (state_24090[(8)]);
var inst_24045 = (state_24090[(9)]);
var inst_24047 = (inst_24045 < inst_24044);
var inst_24048 = inst_24047;
var state_24090__$1 = state_24090;
if(cljs.core.truth_(inst_24048)){
var statearr_24124_24153 = state_24090__$1;
(statearr_24124_24153[(1)] = (10));

} else {
var statearr_24125_24154 = state_24090__$1;
(statearr_24125_24154[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__20477__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__20477__auto____0 = (function (){
var statearr_24126 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24126[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__20477__auto__);

(statearr_24126[(1)] = (1));

return statearr_24126;
});
var cljs$core$async$mapcat_STAR__$_state_machine__20477__auto____1 = (function (state_24090){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_24090);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e24127){var ex__20480__auto__ = e24127;
var statearr_24128_24155 = state_24090;
(statearr_24128_24155[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_24090[(4)]))){
var statearr_24129_24156 = state_24090;
(statearr_24129_24156[(1)] = cljs.core.first((state_24090[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__24157 = state_24090;
state_24090 = G__24157;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__20477__auto__ = function(state_24090){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__20477__auto____1.call(this,state_24090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__20477__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__20477__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_24130 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_24130[(6)] = c__20603__auto__);

return statearr_24130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));

return c__20603__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__24159 = arguments.length;
switch (G__24159) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__24162 = arguments.length;
switch (G__24162) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__24165 = arguments.length;
switch (G__24165) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20603__auto___24213 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_24189){
var state_val_24190 = (state_24189[(1)]);
if((state_val_24190 === (7))){
var inst_24184 = (state_24189[(2)]);
var state_24189__$1 = state_24189;
var statearr_24191_24214 = state_24189__$1;
(statearr_24191_24214[(2)] = inst_24184);

(statearr_24191_24214[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24190 === (1))){
var inst_24166 = null;
var state_24189__$1 = (function (){var statearr_24192 = state_24189;
(statearr_24192[(7)] = inst_24166);

return statearr_24192;
})();
var statearr_24193_24215 = state_24189__$1;
(statearr_24193_24215[(2)] = null);

(statearr_24193_24215[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24190 === (4))){
var inst_24169 = (state_24189[(8)]);
var inst_24169__$1 = (state_24189[(2)]);
var inst_24170 = (inst_24169__$1 == null);
var inst_24171 = cljs.core.not(inst_24170);
var state_24189__$1 = (function (){var statearr_24194 = state_24189;
(statearr_24194[(8)] = inst_24169__$1);

return statearr_24194;
})();
if(inst_24171){
var statearr_24195_24216 = state_24189__$1;
(statearr_24195_24216[(1)] = (5));

} else {
var statearr_24196_24217 = state_24189__$1;
(statearr_24196_24217[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24190 === (6))){
var state_24189__$1 = state_24189;
var statearr_24197_24218 = state_24189__$1;
(statearr_24197_24218[(2)] = null);

(statearr_24197_24218[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24190 === (3))){
var inst_24186 = (state_24189[(2)]);
var inst_24187 = cljs.core.async.close_BANG_(out);
var state_24189__$1 = (function (){var statearr_24198 = state_24189;
(statearr_24198[(9)] = inst_24186);

return statearr_24198;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_24189__$1,inst_24187);
} else {
if((state_val_24190 === (2))){
var state_24189__$1 = state_24189;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24189__$1,(4),ch);
} else {
if((state_val_24190 === (11))){
var inst_24169 = (state_24189[(8)]);
var inst_24178 = (state_24189[(2)]);
var inst_24166 = inst_24169;
var state_24189__$1 = (function (){var statearr_24199 = state_24189;
(statearr_24199[(10)] = inst_24178);

(statearr_24199[(7)] = inst_24166);

return statearr_24199;
})();
var statearr_24200_24219 = state_24189__$1;
(statearr_24200_24219[(2)] = null);

(statearr_24200_24219[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24190 === (9))){
var inst_24169 = (state_24189[(8)]);
var state_24189__$1 = state_24189;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24189__$1,(11),out,inst_24169);
} else {
if((state_val_24190 === (5))){
var inst_24169 = (state_24189[(8)]);
var inst_24166 = (state_24189[(7)]);
var inst_24173 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24169,inst_24166);
var state_24189__$1 = state_24189;
if(inst_24173){
var statearr_24202_24220 = state_24189__$1;
(statearr_24202_24220[(1)] = (8));

} else {
var statearr_24203_24221 = state_24189__$1;
(statearr_24203_24221[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24190 === (10))){
var inst_24181 = (state_24189[(2)]);
var state_24189__$1 = state_24189;
var statearr_24204_24222 = state_24189__$1;
(statearr_24204_24222[(2)] = inst_24181);

(statearr_24204_24222[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24190 === (8))){
var inst_24166 = (state_24189[(7)]);
var tmp24201 = inst_24166;
var inst_24166__$1 = tmp24201;
var state_24189__$1 = (function (){var statearr_24205 = state_24189;
(statearr_24205[(7)] = inst_24166__$1);

return statearr_24205;
})();
var statearr_24206_24223 = state_24189__$1;
(statearr_24206_24223[(2)] = null);

(statearr_24206_24223[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20477__auto__ = null;
var cljs$core$async$state_machine__20477__auto____0 = (function (){
var statearr_24207 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_24207[(0)] = cljs$core$async$state_machine__20477__auto__);

(statearr_24207[(1)] = (1));

return statearr_24207;
});
var cljs$core$async$state_machine__20477__auto____1 = (function (state_24189){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_24189);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e24208){var ex__20480__auto__ = e24208;
var statearr_24209_24224 = state_24189;
(statearr_24209_24224[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_24189[(4)]))){
var statearr_24210_24225 = state_24189;
(statearr_24210_24225[(1)] = cljs.core.first((state_24189[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__24226 = state_24189;
state_24189 = G__24226;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$state_machine__20477__auto__ = function(state_24189){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20477__auto____1.call(this,state_24189);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20477__auto____0;
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20477__auto____1;
return cljs$core$async$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_24211 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_24211[(6)] = c__20603__auto___24213);

return statearr_24211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__24228 = arguments.length;
switch (G__24228) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20603__auto___24295 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_24266){
var state_val_24267 = (state_24266[(1)]);
if((state_val_24267 === (7))){
var inst_24262 = (state_24266[(2)]);
var state_24266__$1 = state_24266;
var statearr_24268_24296 = state_24266__$1;
(statearr_24268_24296[(2)] = inst_24262);

(statearr_24268_24296[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24267 === (1))){
var inst_24229 = (new Array(n));
var inst_24230 = inst_24229;
var inst_24231 = (0);
var state_24266__$1 = (function (){var statearr_24269 = state_24266;
(statearr_24269[(7)] = inst_24230);

(statearr_24269[(8)] = inst_24231);

return statearr_24269;
})();
var statearr_24270_24297 = state_24266__$1;
(statearr_24270_24297[(2)] = null);

(statearr_24270_24297[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24267 === (4))){
var inst_24234 = (state_24266[(9)]);
var inst_24234__$1 = (state_24266[(2)]);
var inst_24235 = (inst_24234__$1 == null);
var inst_24236 = cljs.core.not(inst_24235);
var state_24266__$1 = (function (){var statearr_24271 = state_24266;
(statearr_24271[(9)] = inst_24234__$1);

return statearr_24271;
})();
if(inst_24236){
var statearr_24272_24298 = state_24266__$1;
(statearr_24272_24298[(1)] = (5));

} else {
var statearr_24273_24299 = state_24266__$1;
(statearr_24273_24299[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24267 === (15))){
var inst_24256 = (state_24266[(2)]);
var state_24266__$1 = state_24266;
var statearr_24274_24300 = state_24266__$1;
(statearr_24274_24300[(2)] = inst_24256);

(statearr_24274_24300[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24267 === (13))){
var state_24266__$1 = state_24266;
var statearr_24275_24301 = state_24266__$1;
(statearr_24275_24301[(2)] = null);

(statearr_24275_24301[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24267 === (6))){
var inst_24231 = (state_24266[(8)]);
var inst_24252 = (inst_24231 > (0));
var state_24266__$1 = state_24266;
if(cljs.core.truth_(inst_24252)){
var statearr_24276_24302 = state_24266__$1;
(statearr_24276_24302[(1)] = (12));

} else {
var statearr_24277_24303 = state_24266__$1;
(statearr_24277_24303[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24267 === (3))){
var inst_24264 = (state_24266[(2)]);
var state_24266__$1 = state_24266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24266__$1,inst_24264);
} else {
if((state_val_24267 === (12))){
var inst_24230 = (state_24266[(7)]);
var inst_24254 = cljs.core.vec(inst_24230);
var state_24266__$1 = state_24266;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24266__$1,(15),out,inst_24254);
} else {
if((state_val_24267 === (2))){
var state_24266__$1 = state_24266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24266__$1,(4),ch);
} else {
if((state_val_24267 === (11))){
var inst_24246 = (state_24266[(2)]);
var inst_24247 = (new Array(n));
var inst_24230 = inst_24247;
var inst_24231 = (0);
var state_24266__$1 = (function (){var statearr_24278 = state_24266;
(statearr_24278[(7)] = inst_24230);

(statearr_24278[(10)] = inst_24246);

(statearr_24278[(8)] = inst_24231);

return statearr_24278;
})();
var statearr_24279_24304 = state_24266__$1;
(statearr_24279_24304[(2)] = null);

(statearr_24279_24304[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24267 === (9))){
var inst_24230 = (state_24266[(7)]);
var inst_24244 = cljs.core.vec(inst_24230);
var state_24266__$1 = state_24266;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24266__$1,(11),out,inst_24244);
} else {
if((state_val_24267 === (5))){
var inst_24239 = (state_24266[(11)]);
var inst_24234 = (state_24266[(9)]);
var inst_24230 = (state_24266[(7)]);
var inst_24231 = (state_24266[(8)]);
var inst_24238 = (inst_24230[inst_24231] = inst_24234);
var inst_24239__$1 = (inst_24231 + (1));
var inst_24240 = (inst_24239__$1 < n);
var state_24266__$1 = (function (){var statearr_24280 = state_24266;
(statearr_24280[(12)] = inst_24238);

(statearr_24280[(11)] = inst_24239__$1);

return statearr_24280;
})();
if(cljs.core.truth_(inst_24240)){
var statearr_24281_24305 = state_24266__$1;
(statearr_24281_24305[(1)] = (8));

} else {
var statearr_24282_24306 = state_24266__$1;
(statearr_24282_24306[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24267 === (14))){
var inst_24259 = (state_24266[(2)]);
var inst_24260 = cljs.core.async.close_BANG_(out);
var state_24266__$1 = (function (){var statearr_24284 = state_24266;
(statearr_24284[(13)] = inst_24259);

return statearr_24284;
})();
var statearr_24285_24307 = state_24266__$1;
(statearr_24285_24307[(2)] = inst_24260);

(statearr_24285_24307[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24267 === (10))){
var inst_24250 = (state_24266[(2)]);
var state_24266__$1 = state_24266;
var statearr_24286_24308 = state_24266__$1;
(statearr_24286_24308[(2)] = inst_24250);

(statearr_24286_24308[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24267 === (8))){
var inst_24239 = (state_24266[(11)]);
var inst_24230 = (state_24266[(7)]);
var tmp24283 = inst_24230;
var inst_24230__$1 = tmp24283;
var inst_24231 = inst_24239;
var state_24266__$1 = (function (){var statearr_24287 = state_24266;
(statearr_24287[(7)] = inst_24230__$1);

(statearr_24287[(8)] = inst_24231);

return statearr_24287;
})();
var statearr_24288_24309 = state_24266__$1;
(statearr_24288_24309[(2)] = null);

(statearr_24288_24309[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20477__auto__ = null;
var cljs$core$async$state_machine__20477__auto____0 = (function (){
var statearr_24289 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24289[(0)] = cljs$core$async$state_machine__20477__auto__);

(statearr_24289[(1)] = (1));

return statearr_24289;
});
var cljs$core$async$state_machine__20477__auto____1 = (function (state_24266){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_24266);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e24290){var ex__20480__auto__ = e24290;
var statearr_24291_24310 = state_24266;
(statearr_24291_24310[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_24266[(4)]))){
var statearr_24292_24311 = state_24266;
(statearr_24292_24311[(1)] = cljs.core.first((state_24266[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__24312 = state_24266;
state_24266 = G__24312;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$state_machine__20477__auto__ = function(state_24266){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20477__auto____1.call(this,state_24266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20477__auto____0;
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20477__auto____1;
return cljs$core$async$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_24293 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_24293[(6)] = c__20603__auto___24295);

return statearr_24293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__24314 = arguments.length;
switch (G__24314) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__20603__auto___24392 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__20604__auto__ = (function (){var switch__20476__auto__ = (function (state_24359){
var state_val_24360 = (state_24359[(1)]);
if((state_val_24360 === (7))){
var inst_24355 = (state_24359[(2)]);
var state_24359__$1 = state_24359;
var statearr_24361_24393 = state_24359__$1;
(statearr_24361_24393[(2)] = inst_24355);

(statearr_24361_24393[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (1))){
var inst_24315 = [];
var inst_24316 = inst_24315;
var inst_24317 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_24359__$1 = (function (){var statearr_24362 = state_24359;
(statearr_24362[(7)] = inst_24317);

(statearr_24362[(8)] = inst_24316);

return statearr_24362;
})();
var statearr_24363_24394 = state_24359__$1;
(statearr_24363_24394[(2)] = null);

(statearr_24363_24394[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (4))){
var inst_24320 = (state_24359[(9)]);
var inst_24320__$1 = (state_24359[(2)]);
var inst_24321 = (inst_24320__$1 == null);
var inst_24322 = cljs.core.not(inst_24321);
var state_24359__$1 = (function (){var statearr_24364 = state_24359;
(statearr_24364[(9)] = inst_24320__$1);

return statearr_24364;
})();
if(inst_24322){
var statearr_24365_24395 = state_24359__$1;
(statearr_24365_24395[(1)] = (5));

} else {
var statearr_24366_24396 = state_24359__$1;
(statearr_24366_24396[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (15))){
var inst_24316 = (state_24359[(8)]);
var inst_24347 = cljs.core.vec(inst_24316);
var state_24359__$1 = state_24359;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24359__$1,(18),out,inst_24347);
} else {
if((state_val_24360 === (13))){
var inst_24342 = (state_24359[(2)]);
var state_24359__$1 = state_24359;
var statearr_24367_24397 = state_24359__$1;
(statearr_24367_24397[(2)] = inst_24342);

(statearr_24367_24397[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (6))){
var inst_24316 = (state_24359[(8)]);
var inst_24344 = inst_24316.length;
var inst_24345 = (inst_24344 > (0));
var state_24359__$1 = state_24359;
if(cljs.core.truth_(inst_24345)){
var statearr_24368_24398 = state_24359__$1;
(statearr_24368_24398[(1)] = (15));

} else {
var statearr_24369_24399 = state_24359__$1;
(statearr_24369_24399[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (17))){
var inst_24352 = (state_24359[(2)]);
var inst_24353 = cljs.core.async.close_BANG_(out);
var state_24359__$1 = (function (){var statearr_24370 = state_24359;
(statearr_24370[(10)] = inst_24352);

return statearr_24370;
})();
var statearr_24371_24400 = state_24359__$1;
(statearr_24371_24400[(2)] = inst_24353);

(statearr_24371_24400[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (3))){
var inst_24357 = (state_24359[(2)]);
var state_24359__$1 = state_24359;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24359__$1,inst_24357);
} else {
if((state_val_24360 === (12))){
var inst_24316 = (state_24359[(8)]);
var inst_24335 = cljs.core.vec(inst_24316);
var state_24359__$1 = state_24359;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_24359__$1,(14),out,inst_24335);
} else {
if((state_val_24360 === (2))){
var state_24359__$1 = state_24359;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24359__$1,(4),ch);
} else {
if((state_val_24360 === (11))){
var inst_24320 = (state_24359[(9)]);
var inst_24324 = (state_24359[(11)]);
var inst_24316 = (state_24359[(8)]);
var inst_24332 = inst_24316.push(inst_24320);
var tmp24372 = inst_24316;
var inst_24316__$1 = tmp24372;
var inst_24317 = inst_24324;
var state_24359__$1 = (function (){var statearr_24373 = state_24359;
(statearr_24373[(12)] = inst_24332);

(statearr_24373[(7)] = inst_24317);

(statearr_24373[(8)] = inst_24316__$1);

return statearr_24373;
})();
var statearr_24374_24401 = state_24359__$1;
(statearr_24374_24401[(2)] = null);

(statearr_24374_24401[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (9))){
var inst_24317 = (state_24359[(7)]);
var inst_24328 = cljs.core.keyword_identical_QMARK_(inst_24317,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var state_24359__$1 = state_24359;
var statearr_24375_24402 = state_24359__$1;
(statearr_24375_24402[(2)] = inst_24328);

(statearr_24375_24402[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (5))){
var inst_24320 = (state_24359[(9)]);
var inst_24324 = (state_24359[(11)]);
var inst_24325 = (state_24359[(13)]);
var inst_24317 = (state_24359[(7)]);
var inst_24324__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_24320) : f.call(null,inst_24320));
var inst_24325__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_24324__$1,inst_24317);
var state_24359__$1 = (function (){var statearr_24376 = state_24359;
(statearr_24376[(11)] = inst_24324__$1);

(statearr_24376[(13)] = inst_24325__$1);

return statearr_24376;
})();
if(inst_24325__$1){
var statearr_24377_24403 = state_24359__$1;
(statearr_24377_24403[(1)] = (8));

} else {
var statearr_24378_24404 = state_24359__$1;
(statearr_24378_24404[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (14))){
var inst_24320 = (state_24359[(9)]);
var inst_24324 = (state_24359[(11)]);
var inst_24337 = (state_24359[(2)]);
var inst_24338 = [];
var inst_24339 = inst_24338.push(inst_24320);
var inst_24316 = inst_24338;
var inst_24317 = inst_24324;
var state_24359__$1 = (function (){var statearr_24379 = state_24359;
(statearr_24379[(14)] = inst_24339);

(statearr_24379[(15)] = inst_24337);

(statearr_24379[(7)] = inst_24317);

(statearr_24379[(8)] = inst_24316);

return statearr_24379;
})();
var statearr_24380_24405 = state_24359__$1;
(statearr_24380_24405[(2)] = null);

(statearr_24380_24405[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (16))){
var state_24359__$1 = state_24359;
var statearr_24381_24406 = state_24359__$1;
(statearr_24381_24406[(2)] = null);

(statearr_24381_24406[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (10))){
var inst_24330 = (state_24359[(2)]);
var state_24359__$1 = state_24359;
if(cljs.core.truth_(inst_24330)){
var statearr_24382_24407 = state_24359__$1;
(statearr_24382_24407[(1)] = (11));

} else {
var statearr_24383_24408 = state_24359__$1;
(statearr_24383_24408[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (18))){
var inst_24349 = (state_24359[(2)]);
var state_24359__$1 = state_24359;
var statearr_24384_24409 = state_24359__$1;
(statearr_24384_24409[(2)] = inst_24349);

(statearr_24384_24409[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_24360 === (8))){
var inst_24325 = (state_24359[(13)]);
var state_24359__$1 = state_24359;
var statearr_24385_24410 = state_24359__$1;
(statearr_24385_24410[(2)] = inst_24325);

(statearr_24385_24410[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__20477__auto__ = null;
var cljs$core$async$state_machine__20477__auto____0 = (function (){
var statearr_24386 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24386[(0)] = cljs$core$async$state_machine__20477__auto__);

(statearr_24386[(1)] = (1));

return statearr_24386;
});
var cljs$core$async$state_machine__20477__auto____1 = (function (state_24359){
while(true){
var ret_value__20478__auto__ = (function (){try{while(true){
var result__20479__auto__ = switch__20476__auto__(state_24359);
if(cljs.core.keyword_identical_QMARK_(result__20479__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__20479__auto__;
}
break;
}
}catch (e24387){var ex__20480__auto__ = e24387;
var statearr_24388_24411 = state_24359;
(statearr_24388_24411[(2)] = ex__20480__auto__);


if(cljs.core.seq((state_24359[(4)]))){
var statearr_24389_24412 = state_24359;
(statearr_24389_24412[(1)] = cljs.core.first((state_24359[(4)])));

} else {
throw ex__20480__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__20478__auto__,cljs.core.cst$kw$recur)){
var G__24413 = state_24359;
state_24359 = G__24413;
continue;
} else {
return ret_value__20478__auto__;
}
break;
}
});
cljs$core$async$state_machine__20477__auto__ = function(state_24359){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__20477__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__20477__auto____1.call(this,state_24359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__20477__auto____0;
cljs$core$async$state_machine__20477__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__20477__auto____1;
return cljs$core$async$state_machine__20477__auto__;
})()
})();
var state__20605__auto__ = (function (){var statearr_24390 = (f__20604__auto__.cljs$core$IFn$_invoke$arity$0 ? f__20604__auto__.cljs$core$IFn$_invoke$arity$0() : f__20604__auto__.call(null));
(statearr_24390[(6)] = c__20603__auto___24392);

return statearr_24390;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__20605__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

