// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__14007 = s;
var map__14007__$1 = cljs.core.__destructure_map(map__14007);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14007__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14007__$1,cljs.core.cst$kw$info);
var d = (0);
var G__14009 = info;
var map__14010 = G__14009;
var map__14010__$1 = cljs.core.__destructure_map(map__14010);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14010__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__14009__$1 = G__14009;
while(true){
var d__$2 = d__$1;
var map__14012 = G__14009__$1;
var map__14012__$1 = cljs.core.__destructure_map(map__14012);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14012__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__14013 = (d__$2 + (1));
var G__14014 = shadow__$1;
d__$1 = G__14013;
G__14009__$1 = G__14014;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__14015){
var map__14016 = p__14015;
var map__14016__$1 = cljs.core.__destructure_map(map__14016);
var name_var = map__14016__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14016__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14016__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__14017 = info;
var map__14017__$1 = cljs.core.__destructure_map(map__14017);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14017__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14017__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__14018 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__14018) : cljs.compiler.munge.call(null,G__14018));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__14020 = arguments.length;
switch (G__14020) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__14021 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",25,1,11639,11639,cljs.core.cst$sym$string,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__14021.cljs$core$IFn$_invoke$arity$1 ? fexpr__14021.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__14021.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__14023 = cp;
switch (G__14023) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__14025_14029 = cljs.core.seq(s);
var chunk__14026_14030 = null;
var count__14027_14031 = (0);
var i__14028_14032 = (0);
while(true){
if((i__14028_14032 < count__14027_14031)){
var c_14033 = chunk__14026_14030.cljs$core$IIndexed$_nth$arity$2(null,i__14028_14032);
sb.append(cljs.compiler.escape_char(c_14033));


var G__14034 = seq__14025_14029;
var G__14035 = chunk__14026_14030;
var G__14036 = count__14027_14031;
var G__14037 = (i__14028_14032 + (1));
seq__14025_14029 = G__14034;
chunk__14026_14030 = G__14035;
count__14027_14031 = G__14036;
i__14028_14032 = G__14037;
continue;
} else {
var temp__5753__auto___14038 = cljs.core.seq(seq__14025_14029);
if(temp__5753__auto___14038){
var seq__14025_14039__$1 = temp__5753__auto___14038;
if(cljs.core.chunked_seq_QMARK_(seq__14025_14039__$1)){
var c__4649__auto___14040 = cljs.core.chunk_first(seq__14025_14039__$1);
var G__14041 = cljs.core.chunk_rest(seq__14025_14039__$1);
var G__14042 = c__4649__auto___14040;
var G__14043 = cljs.core.count(c__4649__auto___14040);
var G__14044 = (0);
seq__14025_14029 = G__14041;
chunk__14026_14030 = G__14042;
count__14027_14031 = G__14043;
i__14028_14032 = G__14044;
continue;
} else {
var c_14045 = cljs.core.first(seq__14025_14039__$1);
sb.append(cljs.compiler.escape_char(c_14045));


var G__14046 = cljs.core.next(seq__14025_14039__$1);
var G__14047 = null;
var G__14048 = (0);
var G__14049 = (0);
seq__14025_14029 = G__14046;
chunk__14026_14030 = G__14047;
count__14027_14031 = G__14048;
i__14028_14032 = G__14049;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__14050 = cljs.core.get_global_hierarchy;
return (fexpr__14050.cljs$core$IFn$_invoke$arity$0 ? fexpr__14050.cljs$core$IFn$_invoke$arity$0() : fexpr__14050.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__14051_14056 = ast;
var map__14051_14057__$1 = cljs.core.__destructure_map(map__14051_14056);
var env_14058 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14051_14057__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_14058))){
var map__14052_14059 = env_14058;
var map__14052_14060__$1 = cljs.core.__destructure_map(map__14052_14059);
var line_14061 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14052_14060__$1,cljs.core.cst$kw$line);
var column_14062 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14052_14060__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__14053 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__14055 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__14054 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__14054.cljs$core$IFn$_invoke$arity$1 ? fexpr__14054.cljs$core$IFn$_invoke$arity$1(G__14055) : fexpr__14054.call(null,G__14055));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__14053,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__14053;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_14061 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_14062)?(column_14062 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__14071 = arguments.length;
switch (G__14071) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4850__auto__ = [];
var len__4829__auto___14078 = arguments.length;
var i__4830__auto___14079 = (0);
while(true){
if((i__4830__auto___14079 < len__4829__auto___14078)){
args_arr__4850__auto__.push((arguments[i__4830__auto___14079]));

var G__14080 = (i__4830__auto___14079 + (1));
i__4830__auto___14079 = G__14080;
continue;
} else {
}
break;
}

var argseq__4851__auto__ = (new cljs.core.IndexedSeq(args_arr__4850__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4851__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_14081 = (function (){var G__14072 = a;
if((!(typeof a === 'string'))){
return G__14072.toString();
} else {
return G__14072;
}
})();
var temp__5757__auto___14082 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___14082 == null)){
} else {
var sm_data_14083 = temp__5757__auto___14082;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_14083,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,(function (p1__14063_SHARP_){
return (p1__14063_SHARP_ + s_14081.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_14081], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__14073 = cljs.core.seq(xs);
var chunk__14074 = null;
var count__14075 = (0);
var i__14076 = (0);
while(true){
if((i__14076 < count__14075)){
var x = chunk__14074.cljs$core$IIndexed$_nth$arity$2(null,i__14076);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__14084 = seq__14073;
var G__14085 = chunk__14074;
var G__14086 = count__14075;
var G__14087 = (i__14076 + (1));
seq__14073 = G__14084;
chunk__14074 = G__14085;
count__14075 = G__14086;
i__14076 = G__14087;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14073);
if(temp__5753__auto__){
var seq__14073__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14073__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__14073__$1);
var G__14088 = cljs.core.chunk_rest(seq__14073__$1);
var G__14089 = c__4649__auto__;
var G__14090 = cljs.core.count(c__4649__auto__);
var G__14091 = (0);
seq__14073 = G__14088;
chunk__14074 = G__14089;
count__14075 = G__14090;
i__14076 = G__14091;
continue;
} else {
var x = cljs.core.first(seq__14073__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__14092 = cljs.core.next(seq__14073__$1);
var G__14093 = null;
var G__14094 = (0);
var G__14095 = (0);
seq__14073 = G__14092;
chunk__14074 = G__14093;
count__14075 = G__14094;
i__14076 = G__14095;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq14065){
var G__14066 = cljs.core.first(seq14065);
var seq14065__$1 = cljs.core.next(seq14065);
var G__14067 = cljs.core.first(seq14065__$1);
var seq14065__$2 = cljs.core.next(seq14065__$1);
var G__14068 = cljs.core.first(seq14065__$2);
var seq14065__$3 = cljs.core.next(seq14065__$2);
var G__14069 = cljs.core.first(seq14065__$3);
var seq14065__$4 = cljs.core.next(seq14065__$3);
var G__14070 = cljs.core.first(seq14065__$4);
var seq14065__$5 = cljs.core.next(seq14065__$4);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14066,G__14067,G__14068,G__14069,G__14070,seq14065__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__14096){
var map__14097 = p__14096;
var map__14097__$1 = cljs.core.__destructure_map(map__14097);
var m = map__14097__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14097__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__14105 = arguments.length;
switch (G__14105) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4850__auto__ = [];
var len__4829__auto___14111 = arguments.length;
var i__4830__auto___14112 = (0);
while(true){
if((i__4830__auto___14112 < len__4829__auto___14111)){
args_arr__4850__auto__.push((arguments[i__4830__auto___14112]));

var G__14113 = (i__4830__auto___14112 + (1));
i__4830__auto___14112 = G__14113;
continue;
} else {
}
break;
}

var argseq__4851__auto__ = (new cljs.core.IndexedSeq(args_arr__4850__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4851__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__14106_14114 = cljs.core.seq(xs);
var chunk__14107_14115 = null;
var count__14108_14116 = (0);
var i__14109_14117 = (0);
while(true){
if((i__14109_14117 < count__14108_14116)){
var x_14118 = chunk__14107_14115.cljs$core$IIndexed$_nth$arity$2(null,i__14109_14117);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_14118);


var G__14119 = seq__14106_14114;
var G__14120 = chunk__14107_14115;
var G__14121 = count__14108_14116;
var G__14122 = (i__14109_14117 + (1));
seq__14106_14114 = G__14119;
chunk__14107_14115 = G__14120;
count__14108_14116 = G__14121;
i__14109_14117 = G__14122;
continue;
} else {
var temp__5753__auto___14123 = cljs.core.seq(seq__14106_14114);
if(temp__5753__auto___14123){
var seq__14106_14124__$1 = temp__5753__auto___14123;
if(cljs.core.chunked_seq_QMARK_(seq__14106_14124__$1)){
var c__4649__auto___14125 = cljs.core.chunk_first(seq__14106_14124__$1);
var G__14126 = cljs.core.chunk_rest(seq__14106_14124__$1);
var G__14127 = c__4649__auto___14125;
var G__14128 = cljs.core.count(c__4649__auto___14125);
var G__14129 = (0);
seq__14106_14114 = G__14126;
chunk__14107_14115 = G__14127;
count__14108_14116 = G__14128;
i__14109_14117 = G__14129;
continue;
} else {
var x_14130 = cljs.core.first(seq__14106_14124__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_14130);


var G__14131 = cljs.core.next(seq__14106_14124__$1);
var G__14132 = null;
var G__14133 = (0);
var G__14134 = (0);
seq__14106_14114 = G__14131;
chunk__14107_14115 = G__14132;
count__14108_14116 = G__14133;
i__14109_14117 = G__14134;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq14099){
var G__14100 = cljs.core.first(seq14099);
var seq14099__$1 = cljs.core.next(seq14099);
var G__14101 = cljs.core.first(seq14099__$1);
var seq14099__$2 = cljs.core.next(seq14099__$1);
var G__14102 = cljs.core.first(seq14099__$2);
var seq14099__$3 = cljs.core.next(seq14099__$2);
var G__14103 = cljs.core.first(seq14099__$3);
var seq14099__$4 = cljs.core.next(seq14099__$3);
var G__14104 = cljs.core.first(seq14099__$4);
var seq14099__$5 = cljs.core.next(seq14099__$4);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14100,G__14101,G__14102,G__14103,G__14104,seq14099__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4760__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__14135_14139 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__14136_14140 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__14137_14141 = true;
var _STAR_print_fn_STAR__temp_val__14138_14142 = (function (x__4761__auto__){
return sb__4760__auto__.append(x__4761__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__14137_14141);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__14138_14142);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__14136_14140);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__14135_14139);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4760__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4712__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4713__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4714__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4715__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4716__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__14143 = cljs.core.get_global_hierarchy;
return (fexpr__14143.cljs$core$IFn$_invoke$arity$0 ? fexpr__14143.cljs$core$IFn$_invoke$arity$0() : fexpr__14143.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__4716__auto__,method_table__4712__auto__,prefer_table__4713__auto__,method_cache__4714__auto__,cached_hierarchy__4715__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__14144 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14144,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14144,(1),null);
var G__14147 = ns;
var G__14148 = name;
var G__14149 = (function (){
var G__14150 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__14150) : cljs.compiler.emit_constant.call(null,G__14150));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__14147,G__14148,G__14149) : cljs.compiler.emit_record_value.call(null,G__14147,G__14148,G__14149));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__14151 = cljs.core.keys(x);
var G__14152 = cljs.core.vals(x);
var G__14153 = cljs.compiler.emit_constants_comma_sep;
var G__14154 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__14151,G__14152,G__14153,G__14154) : cljs.compiler.emit_map.call(null,G__14151,G__14152,G__14153,G__14154));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__14155 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__14156 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__14155,G__14156) : cljs.compiler.emit_with_meta.call(null,G__14155,G__14156));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__14157 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14157,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14157,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14157,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4221__auto__)){
var G__14160 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__14160) : x.call(null,G__14160));
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4221__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4221__auto__)){
var G__14161 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__14161) : x.call(null,G__14161));
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__14163 = items;
var G__14164 = (function (p1__14162_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__14162_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__14163,G__14164) : cljs.compiler.emit_js_object.call(null,G__14163,G__14164));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__14166){
var map__14167 = p__14166;
var map__14167__$1 = cljs.core.__destructure_map(map__14167);
var ast = map__14167__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14167__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14167__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14167__$1,cljs.core.cst$kw$form);
var temp__5751__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__14168 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__14168__$1 = cljs.core.__destructure_map(map__14168);
var cenv = map__14168__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14168__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__4223__auto__ = js_module_name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__14169 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4221__auto__ = (function (){var G__14170 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__14170) : cljs.compiler.es5_GT__EQ_.call(null,G__14170));
})();
if(cljs.core.truth_(and__4221__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4221__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__14169,cljs.analyzer.es5_allowed);
} else {
return G__14169;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__4223__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__14171 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__14171,reserved);
} else {
return G__14171;
}
})();
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__14172_14173 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__14172_14174__$1 = (((G__14172_14173 instanceof cljs.core.Keyword))?G__14172_14173.fqn:null);
switch (G__14172_14174__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4221__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__14176){
var map__14177 = p__14176;
var map__14177__$1 = cljs.core.__destructure_map(map__14177);
var arg = map__14177__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14177__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14177__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14177__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14177__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__14178 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__14178__$1 = cljs.core.__destructure_map(map__14178);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14178__$1,cljs.core.cst$kw$name);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__14179){
var map__14180 = p__14179;
var map__14180__$1 = cljs.core.__destructure_map(map__14180);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14180__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14180__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14180__$1,cljs.core.cst$kw$env);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__14181_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__14181_SHARP_),cljs.core.cst$kw$const);
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__14182 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__14182) : comma_sep.call(null,G__14182));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__14183 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__14183) : comma_sep.call(null,G__14183));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__14184){
var map__14185 = p__14184;
var map__14185__$1 = cljs.core.__destructure_map(map__14185);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14185__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14185__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14185__$1,cljs.core.cst$kw$vals);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__14186){
var map__14187 = p__14186;
var map__14187__$1 = cljs.core.__destructure_map(map__14187);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14187__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14187__$1,cljs.core.cst$kw$env);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__14188_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__14188_SHARP_),cljs.core.cst$kw$const);
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__14189 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__14189) : comma_sep.call(null,G__14189));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__14190){
var map__14191 = p__14190;
var map__14191__$1 = cljs.core.__destructure_map(map__14191);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14191__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14191__$1,cljs.core.cst$kw$env);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5753__auto___14214 = cljs.core.seq(items);
if(temp__5753__auto___14214){
var items_14215__$1 = temp__5753__auto___14214;
var vec__14192_14216 = items_14215__$1;
var seq__14193_14217 = cljs.core.seq(vec__14192_14216);
var first__14194_14218 = cljs.core.first(seq__14193_14217);
var seq__14193_14219__$1 = cljs.core.next(seq__14193_14217);
var vec__14195_14220 = first__14194_14218;
var k_14221 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14195_14220,(0),null);
var v_14222 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14195_14220,(1),null);
var r_14223 = seq__14193_14219__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_14221),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_14222) : emit_js_object_val.call(null,v_14222)));

var seq__14198_14224 = cljs.core.seq(r_14223);
var chunk__14199_14225 = null;
var count__14200_14226 = (0);
var i__14201_14227 = (0);
while(true){
if((i__14201_14227 < count__14200_14226)){
var vec__14208_14228 = chunk__14199_14225.cljs$core$IIndexed$_nth$arity$2(null,i__14201_14227);
var k_14229__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14208_14228,(0),null);
var v_14230__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14208_14228,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_14229__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_14230__$1) : emit_js_object_val.call(null,v_14230__$1)));


var G__14231 = seq__14198_14224;
var G__14232 = chunk__14199_14225;
var G__14233 = count__14200_14226;
var G__14234 = (i__14201_14227 + (1));
seq__14198_14224 = G__14231;
chunk__14199_14225 = G__14232;
count__14200_14226 = G__14233;
i__14201_14227 = G__14234;
continue;
} else {
var temp__5753__auto___14235__$1 = cljs.core.seq(seq__14198_14224);
if(temp__5753__auto___14235__$1){
var seq__14198_14236__$1 = temp__5753__auto___14235__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14198_14236__$1)){
var c__4649__auto___14237 = cljs.core.chunk_first(seq__14198_14236__$1);
var G__14238 = cljs.core.chunk_rest(seq__14198_14236__$1);
var G__14239 = c__4649__auto___14237;
var G__14240 = cljs.core.count(c__4649__auto___14237);
var G__14241 = (0);
seq__14198_14224 = G__14238;
chunk__14199_14225 = G__14239;
count__14200_14226 = G__14240;
i__14201_14227 = G__14241;
continue;
} else {
var vec__14211_14242 = cljs.core.first(seq__14198_14236__$1);
var k_14243__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14211_14242,(0),null);
var v_14244__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14211_14242,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_14243__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_14244__$1) : emit_js_object_val.call(null,v_14244__$1)));


var G__14245 = cljs.core.next(seq__14198_14236__$1);
var G__14246 = null;
var G__14247 = (0);
var G__14248 = (0);
seq__14198_14224 = G__14245;
chunk__14199_14225 = G__14246;
count__14200_14226 = G__14247;
i__14201_14227 = G__14248;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__14249){
var map__14250 = p__14249;
var map__14250__$1 = cljs.core.__destructure_map(map__14250);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14250__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14250__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14250__$1,cljs.core.cst$kw$env);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__14251){
var map__14252 = p__14251;
var map__14252__$1 = cljs.core.__destructure_map(map__14252);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14252__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14252__$1,cljs.core.cst$kw$env);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__14253){
var map__14254 = p__14253;
var map__14254__$1 = cljs.core.__destructure_map(map__14254);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14254__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__14255){
var map__14256 = p__14255;
var map__14256__$1 = cljs.core.__destructure_map(map__14256);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14256__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14256__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__14257 = cljs.analyzer.unwrap_quote(expr);
var map__14257__$1 = cljs.core.__destructure_map(map__14257);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14257__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14257__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14257__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4223__auto__ = (function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const);
if(and__4221__auto__){
var and__4221__auto____$1 = form;
if(cljs.core.truth_(and__4221__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto__ = (!((const_expr == null)));
if(and__4221__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4221__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__14258 = cljs.analyzer.unwrap_quote(expr);
var map__14258__$1 = cljs.core.__destructure_map(map__14258);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14258__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14258__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14258__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4223__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__4223__auto__){
return or__4223__auto__;
} else {
var and__4221__auto__ = (!((const_expr == null)));
if(and__4221__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4221__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4223__auto__ = (function (){var fexpr__14259 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__14259.cljs$core$IFn$_invoke$arity$1 ? fexpr__14259.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__14259.call(null,tag));
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__14260){
var map__14261 = p__14260;
var map__14261__$1 = cljs.core.__destructure_map(map__14261);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14261__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14261__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14261__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14261__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14261__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4223__auto__ = unchecked;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__14262){
var map__14263 = p__14262;
var map__14263__$1 = cljs.core.__destructure_map(map__14263);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14263__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14263__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14263__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14263__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__14264_14292 = cljs.core.seq(nodes);
var chunk__14265_14293 = null;
var count__14266_14294 = (0);
var i__14267_14295 = (0);
while(true){
if((i__14267_14295 < count__14266_14294)){
var map__14280_14296 = chunk__14265_14293.cljs$core$IIndexed$_nth$arity$2(null,i__14267_14295);
var map__14280_14297__$1 = cljs.core.__destructure_map(map__14280_14296);
var ts_14298 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14280_14297__$1,cljs.core.cst$kw$tests);
var map__14281_14299 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14280_14297__$1,cljs.core.cst$kw$then);
var map__14281_14300__$1 = cljs.core.__destructure_map(map__14281_14299);
var then_14301 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14281_14300__$1,cljs.core.cst$kw$then);
var seq__14282_14302 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_14298));
var chunk__14283_14303 = null;
var count__14284_14304 = (0);
var i__14285_14305 = (0);
while(true){
if((i__14285_14305 < count__14284_14304)){
var test_14306 = chunk__14283_14303.cljs$core$IIndexed$_nth$arity$2(null,i__14285_14305);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_14306,":");


var G__14307 = seq__14282_14302;
var G__14308 = chunk__14283_14303;
var G__14309 = count__14284_14304;
var G__14310 = (i__14285_14305 + (1));
seq__14282_14302 = G__14307;
chunk__14283_14303 = G__14308;
count__14284_14304 = G__14309;
i__14285_14305 = G__14310;
continue;
} else {
var temp__5753__auto___14311 = cljs.core.seq(seq__14282_14302);
if(temp__5753__auto___14311){
var seq__14282_14312__$1 = temp__5753__auto___14311;
if(cljs.core.chunked_seq_QMARK_(seq__14282_14312__$1)){
var c__4649__auto___14313 = cljs.core.chunk_first(seq__14282_14312__$1);
var G__14314 = cljs.core.chunk_rest(seq__14282_14312__$1);
var G__14315 = c__4649__auto___14313;
var G__14316 = cljs.core.count(c__4649__auto___14313);
var G__14317 = (0);
seq__14282_14302 = G__14314;
chunk__14283_14303 = G__14315;
count__14284_14304 = G__14316;
i__14285_14305 = G__14317;
continue;
} else {
var test_14318 = cljs.core.first(seq__14282_14312__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_14318,":");


var G__14319 = cljs.core.next(seq__14282_14312__$1);
var G__14320 = null;
var G__14321 = (0);
var G__14322 = (0);
seq__14282_14302 = G__14319;
chunk__14283_14303 = G__14320;
count__14284_14304 = G__14321;
i__14285_14305 = G__14322;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_14301);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_14301);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__14323 = seq__14264_14292;
var G__14324 = chunk__14265_14293;
var G__14325 = count__14266_14294;
var G__14326 = (i__14267_14295 + (1));
seq__14264_14292 = G__14323;
chunk__14265_14293 = G__14324;
count__14266_14294 = G__14325;
i__14267_14295 = G__14326;
continue;
} else {
var temp__5753__auto___14327 = cljs.core.seq(seq__14264_14292);
if(temp__5753__auto___14327){
var seq__14264_14328__$1 = temp__5753__auto___14327;
if(cljs.core.chunked_seq_QMARK_(seq__14264_14328__$1)){
var c__4649__auto___14329 = cljs.core.chunk_first(seq__14264_14328__$1);
var G__14330 = cljs.core.chunk_rest(seq__14264_14328__$1);
var G__14331 = c__4649__auto___14329;
var G__14332 = cljs.core.count(c__4649__auto___14329);
var G__14333 = (0);
seq__14264_14292 = G__14330;
chunk__14265_14293 = G__14331;
count__14266_14294 = G__14332;
i__14267_14295 = G__14333;
continue;
} else {
var map__14286_14334 = cljs.core.first(seq__14264_14328__$1);
var map__14286_14335__$1 = cljs.core.__destructure_map(map__14286_14334);
var ts_14336 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14286_14335__$1,cljs.core.cst$kw$tests);
var map__14287_14337 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14286_14335__$1,cljs.core.cst$kw$then);
var map__14287_14338__$1 = cljs.core.__destructure_map(map__14287_14337);
var then_14339 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14287_14338__$1,cljs.core.cst$kw$then);
var seq__14288_14340 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_14336));
var chunk__14289_14341 = null;
var count__14290_14342 = (0);
var i__14291_14343 = (0);
while(true){
if((i__14291_14343 < count__14290_14342)){
var test_14344 = chunk__14289_14341.cljs$core$IIndexed$_nth$arity$2(null,i__14291_14343);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_14344,":");


var G__14345 = seq__14288_14340;
var G__14346 = chunk__14289_14341;
var G__14347 = count__14290_14342;
var G__14348 = (i__14291_14343 + (1));
seq__14288_14340 = G__14345;
chunk__14289_14341 = G__14346;
count__14290_14342 = G__14347;
i__14291_14343 = G__14348;
continue;
} else {
var temp__5753__auto___14349__$1 = cljs.core.seq(seq__14288_14340);
if(temp__5753__auto___14349__$1){
var seq__14288_14350__$1 = temp__5753__auto___14349__$1;
if(cljs.core.chunked_seq_QMARK_(seq__14288_14350__$1)){
var c__4649__auto___14351 = cljs.core.chunk_first(seq__14288_14350__$1);
var G__14352 = cljs.core.chunk_rest(seq__14288_14350__$1);
var G__14353 = c__4649__auto___14351;
var G__14354 = cljs.core.count(c__4649__auto___14351);
var G__14355 = (0);
seq__14288_14340 = G__14352;
chunk__14289_14341 = G__14353;
count__14290_14342 = G__14354;
i__14291_14343 = G__14355;
continue;
} else {
var test_14356 = cljs.core.first(seq__14288_14350__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_14356,":");


var G__14357 = cljs.core.next(seq__14288_14350__$1);
var G__14358 = null;
var G__14359 = (0);
var G__14360 = (0);
seq__14288_14340 = G__14357;
chunk__14289_14341 = G__14358;
count__14290_14342 = G__14359;
i__14291_14343 = G__14360;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_14339);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_14339);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__14361 = cljs.core.next(seq__14264_14328__$1);
var G__14362 = null;
var G__14363 = (0);
var G__14364 = (0);
seq__14264_14292 = G__14361;
chunk__14265_14293 = G__14362;
count__14266_14294 = G__14363;
i__14267_14295 = G__14364;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__14365){
var map__14366 = p__14365;
var map__14366__$1 = cljs.core.__destructure_map(map__14366);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14366__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14366__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__14370 = env;
var G__14371 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__14370,G__14371) : cljs.compiler.resolve_type.call(null,G__14370,G__14371));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__14372 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14372,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14372,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__14367_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__14367_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__14367_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__14375 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__14375,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__14375;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__14378 = env;
var G__14379 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__14378,G__14379) : cljs.compiler.resolve_type.call(null,G__14378,G__14379));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__14380_SHARP_){
return cljs.compiler.resolve_type(env,p1__14380_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__14381 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__14382 = cljs.core.seq(vec__14381);
var first__14383 = cljs.core.first(seq__14382);
var seq__14382__$1 = cljs.core.next(seq__14382);
var p = first__14383;
var first__14383__$1 = cljs.core.first(seq__14382__$1);
var seq__14382__$2 = cljs.core.next(seq__14382__$1);
var ts = first__14383__$1;
var first__14383__$2 = cljs.core.first(seq__14382__$2);
var seq__14382__$3 = cljs.core.next(seq__14382__$2);
var n = first__14383__$2;
var xs = seq__14382__$3;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4221__auto__){
var and__4221__auto____$1 = ts;
if(cljs.core.truth_(and__4221__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__14384 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__14385 = cljs.core.seq(vec__14384);
var first__14386 = cljs.core.first(seq__14385);
var seq__14385__$1 = cljs.core.next(seq__14385);
var p = first__14386;
var first__14386__$1 = cljs.core.first(seq__14385__$1);
var seq__14385__$2 = cljs.core.next(seq__14385__$1);
var ts = first__14386__$1;
var xs = seq__14385__$2;
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4221__auto__){
var and__4221__auto____$1 = ts;
if(cljs.core.truth_(and__4221__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__14388 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__14387 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__14387.cljs$core$IFn$_invoke$arity$1 ? fexpr__14387.cljs$core$IFn$_invoke$arity$1(G__14388) : fexpr__14387.call(null,G__14388));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__14391 = arguments.length;
switch (G__14391) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__14399 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__14389_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__14389_SHARP_);
} else {
return p1__14389_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__14400 = cljs.core.seq(vec__14399);
var first__14401 = cljs.core.first(seq__14400);
var seq__14400__$1 = cljs.core.next(seq__14400);
var x = first__14401;
var ys = seq__14400__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__14402 = cljs.core.seq(ys);
var chunk__14403 = null;
var count__14404 = (0);
var i__14405 = (0);
while(true){
if((i__14405 < count__14404)){
var next_line = chunk__14403.cljs$core$IIndexed$_nth$arity$2(null,i__14405);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__14411 = seq__14402;
var G__14412 = chunk__14403;
var G__14413 = count__14404;
var G__14414 = (i__14405 + (1));
seq__14402 = G__14411;
chunk__14403 = G__14412;
count__14404 = G__14413;
i__14405 = G__14414;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14402);
if(temp__5753__auto__){
var seq__14402__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14402__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__14402__$1);
var G__14415 = cljs.core.chunk_rest(seq__14402__$1);
var G__14416 = c__4649__auto__;
var G__14417 = cljs.core.count(c__4649__auto__);
var G__14418 = (0);
seq__14402 = G__14415;
chunk__14403 = G__14416;
count__14404 = G__14417;
i__14405 = G__14418;
continue;
} else {
var next_line = cljs.core.first(seq__14402__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__14419 = cljs.core.next(seq__14402__$1);
var G__14420 = null;
var G__14421 = (0);
var G__14422 = (0);
seq__14402 = G__14419;
chunk__14403 = G__14420;
count__14404 = G__14421;
i__14405 = G__14422;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__14406_14423 = cljs.core.seq(docs__$2);
var chunk__14407_14424 = null;
var count__14408_14425 = (0);
var i__14409_14426 = (0);
while(true){
if((i__14409_14426 < count__14408_14425)){
var e_14427 = chunk__14407_14424.cljs$core$IIndexed$_nth$arity$2(null,i__14409_14426);
if(cljs.core.truth_(e_14427)){
print_comment_lines(e_14427);
} else {
}


var G__14428 = seq__14406_14423;
var G__14429 = chunk__14407_14424;
var G__14430 = count__14408_14425;
var G__14431 = (i__14409_14426 + (1));
seq__14406_14423 = G__14428;
chunk__14407_14424 = G__14429;
count__14408_14425 = G__14430;
i__14409_14426 = G__14431;
continue;
} else {
var temp__5753__auto___14432 = cljs.core.seq(seq__14406_14423);
if(temp__5753__auto___14432){
var seq__14406_14433__$1 = temp__5753__auto___14432;
if(cljs.core.chunked_seq_QMARK_(seq__14406_14433__$1)){
var c__4649__auto___14434 = cljs.core.chunk_first(seq__14406_14433__$1);
var G__14435 = cljs.core.chunk_rest(seq__14406_14433__$1);
var G__14436 = c__4649__auto___14434;
var G__14437 = cljs.core.count(c__4649__auto___14434);
var G__14438 = (0);
seq__14406_14423 = G__14435;
chunk__14407_14424 = G__14436;
count__14408_14425 = G__14437;
i__14409_14426 = G__14438;
continue;
} else {
var e_14439 = cljs.core.first(seq__14406_14433__$1);
if(cljs.core.truth_(e_14439)){
print_comment_lines(e_14439);
} else {
}


var G__14440 = cljs.core.next(seq__14406_14433__$1);
var G__14441 = null;
var G__14442 = (0);
var G__14443 = (0);
seq__14406_14423 = G__14440;
chunk__14407_14424 = G__14441;
count__14408_14425 = G__14442;
i__14409_14426 = G__14443;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__4221__auto__ = cljs.core.some((function (p1__14445_SHARP_){
return goog.string.startsWith(p1__14445_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = opts;
if(cljs.core.truth_(and__4221__auto____$1)){
var and__4221__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none);
if(and__4221__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4221__auto____$2;
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__14446){
var map__14447 = p__14446;
var map__14447__$1 = cljs.core.__destructure_map(map__14447);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14447__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14447__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14447__$1,cljs.core.cst$kw$test);
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14447__$1,cljs.core.cst$kw$goog_DASH_define);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14447__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14447__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14447__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14447__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14447__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14447__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__4223__auto__ = init;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
return test;
} else {
return and__4221__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__14448){
var map__14449 = p__14448;
var map__14449__$1 = cljs.core.__destructure_map(map__14449);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14449__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14449__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14449__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__14450_14474 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__14451_14475 = null;
var count__14452_14476 = (0);
var i__14453_14477 = (0);
while(true){
if((i__14453_14477 < count__14452_14476)){
var vec__14460_14478 = chunk__14451_14475.cljs$core$IIndexed$_nth$arity$2(null,i__14453_14477);
var i_14479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14460_14478,(0),null);
var param_14480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14460_14478,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_14480);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__14481 = seq__14450_14474;
var G__14482 = chunk__14451_14475;
var G__14483 = count__14452_14476;
var G__14484 = (i__14453_14477 + (1));
seq__14450_14474 = G__14481;
chunk__14451_14475 = G__14482;
count__14452_14476 = G__14483;
i__14453_14477 = G__14484;
continue;
} else {
var temp__5753__auto___14485 = cljs.core.seq(seq__14450_14474);
if(temp__5753__auto___14485){
var seq__14450_14486__$1 = temp__5753__auto___14485;
if(cljs.core.chunked_seq_QMARK_(seq__14450_14486__$1)){
var c__4649__auto___14487 = cljs.core.chunk_first(seq__14450_14486__$1);
var G__14488 = cljs.core.chunk_rest(seq__14450_14486__$1);
var G__14489 = c__4649__auto___14487;
var G__14490 = cljs.core.count(c__4649__auto___14487);
var G__14491 = (0);
seq__14450_14474 = G__14488;
chunk__14451_14475 = G__14489;
count__14452_14476 = G__14490;
i__14453_14477 = G__14491;
continue;
} else {
var vec__14463_14492 = cljs.core.first(seq__14450_14486__$1);
var i_14493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14463_14492,(0),null);
var param_14494 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14463_14492,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_14494);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__14495 = cljs.core.next(seq__14450_14486__$1);
var G__14496 = null;
var G__14497 = (0);
var G__14498 = (0);
seq__14450_14474 = G__14495;
chunk__14451_14475 = G__14496;
count__14452_14476 = G__14497;
i__14453_14477 = G__14498;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__14466_14499 = cljs.core.seq(params);
var chunk__14467_14500 = null;
var count__14468_14501 = (0);
var i__14469_14502 = (0);
while(true){
if((i__14469_14502 < count__14468_14501)){
var param_14503 = chunk__14467_14500.cljs$core$IIndexed$_nth$arity$2(null,i__14469_14502);
cljs.compiler.emit(param_14503);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_14503,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__14504 = seq__14466_14499;
var G__14505 = chunk__14467_14500;
var G__14506 = count__14468_14501;
var G__14507 = (i__14469_14502 + (1));
seq__14466_14499 = G__14504;
chunk__14467_14500 = G__14505;
count__14468_14501 = G__14506;
i__14469_14502 = G__14507;
continue;
} else {
var temp__5753__auto___14508 = cljs.core.seq(seq__14466_14499);
if(temp__5753__auto___14508){
var seq__14466_14509__$1 = temp__5753__auto___14508;
if(cljs.core.chunked_seq_QMARK_(seq__14466_14509__$1)){
var c__4649__auto___14510 = cljs.core.chunk_first(seq__14466_14509__$1);
var G__14511 = cljs.core.chunk_rest(seq__14466_14509__$1);
var G__14512 = c__4649__auto___14510;
var G__14513 = cljs.core.count(c__4649__auto___14510);
var G__14514 = (0);
seq__14466_14499 = G__14511;
chunk__14467_14500 = G__14512;
count__14468_14501 = G__14513;
i__14469_14502 = G__14514;
continue;
} else {
var param_14515 = cljs.core.first(seq__14466_14509__$1);
cljs.compiler.emit(param_14515);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_14515,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__14516 = cljs.core.next(seq__14466_14509__$1);
var G__14517 = null;
var G__14518 = (0);
var G__14519 = (0);
seq__14466_14499 = G__14516;
chunk__14467_14500 = G__14517;
count__14468_14501 = G__14518;
i__14469_14502 = G__14519;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__14470_14520 = cljs.core.seq(params);
var chunk__14471_14521 = null;
var count__14472_14522 = (0);
var i__14473_14523 = (0);
while(true){
if((i__14473_14523 < count__14472_14522)){
var param_14524 = chunk__14471_14521.cljs$core$IIndexed$_nth$arity$2(null,i__14473_14523);
cljs.compiler.emit(param_14524);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_14524,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__14525 = seq__14470_14520;
var G__14526 = chunk__14471_14521;
var G__14527 = count__14472_14522;
var G__14528 = (i__14473_14523 + (1));
seq__14470_14520 = G__14525;
chunk__14471_14521 = G__14526;
count__14472_14522 = G__14527;
i__14473_14523 = G__14528;
continue;
} else {
var temp__5753__auto___14529 = cljs.core.seq(seq__14470_14520);
if(temp__5753__auto___14529){
var seq__14470_14530__$1 = temp__5753__auto___14529;
if(cljs.core.chunked_seq_QMARK_(seq__14470_14530__$1)){
var c__4649__auto___14531 = cljs.core.chunk_first(seq__14470_14530__$1);
var G__14532 = cljs.core.chunk_rest(seq__14470_14530__$1);
var G__14533 = c__4649__auto___14531;
var G__14534 = cljs.core.count(c__4649__auto___14531);
var G__14535 = (0);
seq__14470_14520 = G__14532;
chunk__14471_14521 = G__14533;
count__14472_14522 = G__14534;
i__14473_14523 = G__14535;
continue;
} else {
var param_14536 = cljs.core.first(seq__14470_14530__$1);
cljs.compiler.emit(param_14536);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_14536,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__14537 = cljs.core.next(seq__14470_14530__$1);
var G__14538 = null;
var G__14539 = (0);
var G__14540 = (0);
seq__14470_14520 = G__14537;
chunk__14471_14521 = G__14538;
count__14472_14522 = G__14539;
i__14473_14523 = G__14540;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__14541 = cljs.core.seq(params);
var chunk__14542 = null;
var count__14543 = (0);
var i__14544 = (0);
while(true){
if((i__14544 < count__14543)){
var param = chunk__14542.cljs$core$IIndexed$_nth$arity$2(null,i__14544);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__14545 = seq__14541;
var G__14546 = chunk__14542;
var G__14547 = count__14543;
var G__14548 = (i__14544 + (1));
seq__14541 = G__14545;
chunk__14542 = G__14546;
count__14543 = G__14547;
i__14544 = G__14548;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__14541);
if(temp__5753__auto__){
var seq__14541__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__14541__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__14541__$1);
var G__14549 = cljs.core.chunk_rest(seq__14541__$1);
var G__14550 = c__4649__auto__;
var G__14551 = cljs.core.count(c__4649__auto__);
var G__14552 = (0);
seq__14541 = G__14549;
chunk__14542 = G__14550;
count__14543 = G__14551;
i__14544 = G__14552;
continue;
} else {
var param = cljs.core.first(seq__14541__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__14553 = cljs.core.next(seq__14541__$1);
var G__14554 = null;
var G__14555 = (0);
var G__14556 = (0);
seq__14541 = G__14553;
chunk__14542 = G__14554;
count__14543 = G__14555;
i__14544 = G__14556;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__14557){
var map__14558 = p__14557;
var map__14558__$1 = cljs.core.__destructure_map(map__14558);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14558__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14558__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14558__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14558__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14558__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14558__$1,cljs.core.cst$kw$recurs);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__14559){
var map__14560 = p__14559;
var map__14560__$1 = cljs.core.__destructure_map(map__14560);
var f = map__14560__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14560__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14560__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14560__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14560__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14560__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14560__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14560__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14560__$1,cljs.core.cst$kw$recurs);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_14569__$1 = (function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_14570 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_14569__$1);
var delegate_name_14571 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_14570),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_14571," = function (");

var seq__14561_14572 = cljs.core.seq(params);
var chunk__14562_14573 = null;
var count__14563_14574 = (0);
var i__14564_14575 = (0);
while(true){
if((i__14564_14575 < count__14563_14574)){
var param_14576 = chunk__14562_14573.cljs$core$IIndexed$_nth$arity$2(null,i__14564_14575);
cljs.compiler.emit(param_14576);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_14576,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__14577 = seq__14561_14572;
var G__14578 = chunk__14562_14573;
var G__14579 = count__14563_14574;
var G__14580 = (i__14564_14575 + (1));
seq__14561_14572 = G__14577;
chunk__14562_14573 = G__14578;
count__14563_14574 = G__14579;
i__14564_14575 = G__14580;
continue;
} else {
var temp__5753__auto___14581 = cljs.core.seq(seq__14561_14572);
if(temp__5753__auto___14581){
var seq__14561_14582__$1 = temp__5753__auto___14581;
if(cljs.core.chunked_seq_QMARK_(seq__14561_14582__$1)){
var c__4649__auto___14583 = cljs.core.chunk_first(seq__14561_14582__$1);
var G__14584 = cljs.core.chunk_rest(seq__14561_14582__$1);
var G__14585 = c__4649__auto___14583;
var G__14586 = cljs.core.count(c__4649__auto___14583);
var G__14587 = (0);
seq__14561_14572 = G__14584;
chunk__14562_14573 = G__14585;
count__14563_14574 = G__14586;
i__14564_14575 = G__14587;
continue;
} else {
var param_14588 = cljs.core.first(seq__14561_14582__$1);
cljs.compiler.emit(param_14588);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_14588,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__14589 = cljs.core.next(seq__14561_14582__$1);
var G__14590 = null;
var G__14591 = (0);
var G__14592 = (0);
seq__14561_14572 = G__14589;
chunk__14562_14573 = G__14590;
count__14563_14574 = G__14591;
i__14564_14575 = G__14592;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_14570," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_14593 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_14593,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_14571,".call(this,");

var seq__14565_14594 = cljs.core.seq(params);
var chunk__14566_14595 = null;
var count__14567_14596 = (0);
var i__14568_14597 = (0);
while(true){
if((i__14568_14597 < count__14567_14596)){
var param_14598 = chunk__14566_14595.cljs$core$IIndexed$_nth$arity$2(null,i__14568_14597);
cljs.compiler.emit(param_14598);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_14598,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__14599 = seq__14565_14594;
var G__14600 = chunk__14566_14595;
var G__14601 = count__14567_14596;
var G__14602 = (i__14568_14597 + (1));
seq__14565_14594 = G__14599;
chunk__14566_14595 = G__14600;
count__14567_14596 = G__14601;
i__14568_14597 = G__14602;
continue;
} else {
var temp__5753__auto___14603 = cljs.core.seq(seq__14565_14594);
if(temp__5753__auto___14603){
var seq__14565_14604__$1 = temp__5753__auto___14603;
if(cljs.core.chunked_seq_QMARK_(seq__14565_14604__$1)){
var c__4649__auto___14605 = cljs.core.chunk_first(seq__14565_14604__$1);
var G__14606 = cljs.core.chunk_rest(seq__14565_14604__$1);
var G__14607 = c__4649__auto___14605;
var G__14608 = cljs.core.count(c__4649__auto___14605);
var G__14609 = (0);
seq__14565_14594 = G__14606;
chunk__14566_14595 = G__14607;
count__14567_14596 = G__14608;
i__14568_14597 = G__14609;
continue;
} else {
var param_14610 = cljs.core.first(seq__14565_14604__$1);
cljs.compiler.emit(param_14610);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_14610,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__14611 = cljs.core.next(seq__14565_14604__$1);
var G__14612 = null;
var G__14613 = (0);
var G__14614 = (0);
seq__14565_14594 = G__14611;
chunk__14566_14595 = G__14612;
count__14567_14596 = G__14613;
i__14568_14597 = G__14614;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_14570,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_14570,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_14569__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_14570,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_14571,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_14570,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__14618){
var map__14619 = p__14618;
var map__14619__$1 = cljs.core.__destructure_map(map__14619);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14619__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14619__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14619__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14619__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14619__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14619__$1,cljs.core.cst$kw$recur_DASH_frames);
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14619__$1,cljs.core.cst$kw$in_DASH_loop);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14619__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__14615_SHARP_){
var and__4221__auto__ = p1__14615_SHARP_;
if(cljs.core.truth_(and__4221__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__14615_SHARP_));
} else {
return and__4221__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4223__auto__ = in_loop;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_14671__$1 = (function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_14672 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_14671__$1);
var maxparams_14673 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_14674 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_14672),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_14675 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__14616_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__14616_SHARP_)));
}),cljs.core.seq(mmap_14674));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_14672," = null;");

var seq__14620_14676 = cljs.core.seq(ms_14675);
var chunk__14621_14677 = null;
var count__14622_14678 = (0);
var i__14623_14679 = (0);
while(true){
if((i__14623_14679 < count__14622_14678)){
var vec__14630_14680 = chunk__14621_14677.cljs$core$IIndexed$_nth$arity$2(null,i__14623_14679);
var n_14681 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14630_14680,(0),null);
var meth_14682 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14630_14680,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_14681," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_14682))){
cljs.compiler.emit_variadic_fn_method(meth_14682);
} else {
cljs.compiler.emit_fn_method(meth_14682);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__14683 = seq__14620_14676;
var G__14684 = chunk__14621_14677;
var G__14685 = count__14622_14678;
var G__14686 = (i__14623_14679 + (1));
seq__14620_14676 = G__14683;
chunk__14621_14677 = G__14684;
count__14622_14678 = G__14685;
i__14623_14679 = G__14686;
continue;
} else {
var temp__5753__auto___14687 = cljs.core.seq(seq__14620_14676);
if(temp__5753__auto___14687){
var seq__14620_14688__$1 = temp__5753__auto___14687;
if(cljs.core.chunked_seq_QMARK_(seq__14620_14688__$1)){
var c__4649__auto___14689 = cljs.core.chunk_first(seq__14620_14688__$1);
var G__14690 = cljs.core.chunk_rest(seq__14620_14688__$1);
var G__14691 = c__4649__auto___14689;
var G__14692 = cljs.core.count(c__4649__auto___14689);
var G__14693 = (0);
seq__14620_14676 = G__14690;
chunk__14621_14677 = G__14691;
count__14622_14678 = G__14692;
i__14623_14679 = G__14693;
continue;
} else {
var vec__14633_14694 = cljs.core.first(seq__14620_14688__$1);
var n_14695 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14633_14694,(0),null);
var meth_14696 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14633_14694,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_14695," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_14696))){
cljs.compiler.emit_variadic_fn_method(meth_14696);
} else {
cljs.compiler.emit_fn_method(meth_14696);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__14697 = cljs.core.next(seq__14620_14688__$1);
var G__14698 = null;
var G__14699 = (0);
var G__14700 = (0);
seq__14620_14676 = G__14697;
chunk__14621_14677 = G__14698;
count__14622_14678 = G__14699;
i__14623_14679 = G__14700;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_14672," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_14673),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_14673)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_14673));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__14636_14701 = cljs.core.seq(ms_14675);
var chunk__14637_14702 = null;
var count__14638_14703 = (0);
var i__14639_14704 = (0);
while(true){
if((i__14639_14704 < count__14638_14703)){
var vec__14646_14705 = chunk__14637_14702.cljs$core$IIndexed$_nth$arity$2(null,i__14639_14704);
var n_14706 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14646_14705,(0),null);
var meth_14707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14646_14705,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_14707))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_14708 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_14708," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_14709 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_14708," = new cljs.core.IndexedSeq(",a_14709,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_14706,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_14673)),(((cljs.core.count(maxparams_14673) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_14708,");"], 0));
} else {
var pcnt_14710 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_14707));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_14710,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_14706,".call(this",(((pcnt_14710 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_14710,maxparams_14673)),null,(1),null)),(2),null))),");");
}


var G__14711 = seq__14636_14701;
var G__14712 = chunk__14637_14702;
var G__14713 = count__14638_14703;
var G__14714 = (i__14639_14704 + (1));
seq__14636_14701 = G__14711;
chunk__14637_14702 = G__14712;
count__14638_14703 = G__14713;
i__14639_14704 = G__14714;
continue;
} else {
var temp__5753__auto___14715 = cljs.core.seq(seq__14636_14701);
if(temp__5753__auto___14715){
var seq__14636_14716__$1 = temp__5753__auto___14715;
if(cljs.core.chunked_seq_QMARK_(seq__14636_14716__$1)){
var c__4649__auto___14717 = cljs.core.chunk_first(seq__14636_14716__$1);
var G__14718 = cljs.core.chunk_rest(seq__14636_14716__$1);
var G__14719 = c__4649__auto___14717;
var G__14720 = cljs.core.count(c__4649__auto___14717);
var G__14721 = (0);
seq__14636_14701 = G__14718;
chunk__14637_14702 = G__14719;
count__14638_14703 = G__14720;
i__14639_14704 = G__14721;
continue;
} else {
var vec__14649_14722 = cljs.core.first(seq__14636_14716__$1);
var n_14723 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14649_14722,(0),null);
var meth_14724 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14649_14722,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_14724))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_14725 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_14725," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_14726 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_14725," = new cljs.core.IndexedSeq(",a_14726,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_14723,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_14673)),(((cljs.core.count(maxparams_14673) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_14725,");"], 0));
} else {
var pcnt_14727 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_14724));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_14727,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_14723,".call(this",(((pcnt_14727 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_14727,maxparams_14673)),null,(1),null)),(2),null))),");");
}


var G__14728 = cljs.core.next(seq__14636_14716__$1);
var G__14729 = null;
var G__14730 = (0);
var G__14731 = (0);
seq__14636_14701 = G__14728;
chunk__14637_14702 = G__14729;
count__14638_14703 = G__14730;
i__14639_14704 = G__14731;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_14732 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_14675)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_14732,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_14672,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_14672,".cljs$lang$applyTo = ",cljs.core.some((function (p1__14617_SHARP_){
var vec__14652 = p1__14617_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14652,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14652,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_14675),".cljs$lang$applyTo;");
} else {
}

var seq__14655_14733 = cljs.core.seq(ms_14675);
var chunk__14656_14734 = null;
var count__14657_14735 = (0);
var i__14658_14736 = (0);
while(true){
if((i__14658_14736 < count__14657_14735)){
var vec__14665_14737 = chunk__14656_14734.cljs$core$IIndexed$_nth$arity$2(null,i__14658_14736);
var n_14738 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14665_14737,(0),null);
var meth_14739 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14665_14737,(1),null);
var c_14740 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_14739));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_14739))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_14672,".cljs$core$IFn$_invoke$arity$variadic = ",n_14738,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_14672,".cljs$core$IFn$_invoke$arity$",c_14740," = ",n_14738,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__14741 = seq__14655_14733;
var G__14742 = chunk__14656_14734;
var G__14743 = count__14657_14735;
var G__14744 = (i__14658_14736 + (1));
seq__14655_14733 = G__14741;
chunk__14656_14734 = G__14742;
count__14657_14735 = G__14743;
i__14658_14736 = G__14744;
continue;
} else {
var temp__5753__auto___14745 = cljs.core.seq(seq__14655_14733);
if(temp__5753__auto___14745){
var seq__14655_14746__$1 = temp__5753__auto___14745;
if(cljs.core.chunked_seq_QMARK_(seq__14655_14746__$1)){
var c__4649__auto___14747 = cljs.core.chunk_first(seq__14655_14746__$1);
var G__14748 = cljs.core.chunk_rest(seq__14655_14746__$1);
var G__14749 = c__4649__auto___14747;
var G__14750 = cljs.core.count(c__4649__auto___14747);
var G__14751 = (0);
seq__14655_14733 = G__14748;
chunk__14656_14734 = G__14749;
count__14657_14735 = G__14750;
i__14658_14736 = G__14751;
continue;
} else {
var vec__14668_14752 = cljs.core.first(seq__14655_14746__$1);
var n_14753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14668_14752,(0),null);
var meth_14754 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14668_14752,(1),null);
var c_14755 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_14754));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_14754))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_14672,".cljs$core$IFn$_invoke$arity$variadic = ",n_14753,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_14672,".cljs$core$IFn$_invoke$arity$",c_14755," = ",n_14753,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__14756 = cljs.core.next(seq__14655_14746__$1);
var G__14757 = null;
var G__14758 = (0);
var G__14759 = (0);
seq__14655_14733 = G__14756;
chunk__14656_14734 = G__14757;
count__14657_14735 = G__14758;
i__14658_14736 = G__14759;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_14672,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__14760){
var map__14761 = p__14760;
var map__14761__$1 = cljs.core.__destructure_map(map__14761);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14761__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14761__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14761__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__14762_14766 = cljs.core.seq(statements);
var chunk__14763_14767 = null;
var count__14764_14768 = (0);
var i__14765_14769 = (0);
while(true){
if((i__14765_14769 < count__14764_14768)){
var s_14770 = chunk__14763_14767.cljs$core$IIndexed$_nth$arity$2(null,i__14765_14769);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_14770);


var G__14771 = seq__14762_14766;
var G__14772 = chunk__14763_14767;
var G__14773 = count__14764_14768;
var G__14774 = (i__14765_14769 + (1));
seq__14762_14766 = G__14771;
chunk__14763_14767 = G__14772;
count__14764_14768 = G__14773;
i__14765_14769 = G__14774;
continue;
} else {
var temp__5753__auto___14775 = cljs.core.seq(seq__14762_14766);
if(temp__5753__auto___14775){
var seq__14762_14776__$1 = temp__5753__auto___14775;
if(cljs.core.chunked_seq_QMARK_(seq__14762_14776__$1)){
var c__4649__auto___14777 = cljs.core.chunk_first(seq__14762_14776__$1);
var G__14778 = cljs.core.chunk_rest(seq__14762_14776__$1);
var G__14779 = c__4649__auto___14777;
var G__14780 = cljs.core.count(c__4649__auto___14777);
var G__14781 = (0);
seq__14762_14766 = G__14778;
chunk__14763_14767 = G__14779;
count__14764_14768 = G__14780;
i__14765_14769 = G__14781;
continue;
} else {
var s_14782 = cljs.core.first(seq__14762_14776__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_14782);


var G__14783 = cljs.core.next(seq__14762_14776__$1);
var G__14784 = null;
var G__14785 = (0);
var G__14786 = (0);
seq__14762_14766 = G__14783;
chunk__14763_14767 = G__14784;
count__14764_14768 = G__14785;
i__14765_14769 = G__14786;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__14787){
var map__14788 = p__14787;
var map__14788__$1 = cljs.core.__destructure_map(map__14788);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14788__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14788__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14788__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14788__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14788__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4223__auto__ = name;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__14789,is_loop){
var map__14790 = p__14789;
var map__14790__$1 = cljs.core.__destructure_map(map__14790);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14790__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14790__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14790__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__14791_14801 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__14792_14802 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__14792_14802);

try{var seq__14793_14803 = cljs.core.seq(bindings);
var chunk__14794_14804 = null;
var count__14795_14805 = (0);
var i__14796_14806 = (0);
while(true){
if((i__14796_14806 < count__14795_14805)){
var map__14799_14807 = chunk__14794_14804.cljs$core$IIndexed$_nth$arity$2(null,i__14796_14806);
var map__14799_14808__$1 = cljs.core.__destructure_map(map__14799_14807);
var binding_14809 = map__14799_14808__$1;
var init_14810 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14799_14808__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_14809);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_14810,";");


var G__14811 = seq__14793_14803;
var G__14812 = chunk__14794_14804;
var G__14813 = count__14795_14805;
var G__14814 = (i__14796_14806 + (1));
seq__14793_14803 = G__14811;
chunk__14794_14804 = G__14812;
count__14795_14805 = G__14813;
i__14796_14806 = G__14814;
continue;
} else {
var temp__5753__auto___14815 = cljs.core.seq(seq__14793_14803);
if(temp__5753__auto___14815){
var seq__14793_14816__$1 = temp__5753__auto___14815;
if(cljs.core.chunked_seq_QMARK_(seq__14793_14816__$1)){
var c__4649__auto___14817 = cljs.core.chunk_first(seq__14793_14816__$1);
var G__14818 = cljs.core.chunk_rest(seq__14793_14816__$1);
var G__14819 = c__4649__auto___14817;
var G__14820 = cljs.core.count(c__4649__auto___14817);
var G__14821 = (0);
seq__14793_14803 = G__14818;
chunk__14794_14804 = G__14819;
count__14795_14805 = G__14820;
i__14796_14806 = G__14821;
continue;
} else {
var map__14800_14822 = cljs.core.first(seq__14793_14816__$1);
var map__14800_14823__$1 = cljs.core.__destructure_map(map__14800_14822);
var binding_14824 = map__14800_14823__$1;
var init_14825 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14800_14823__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_14824);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_14825,";");


var G__14826 = cljs.core.next(seq__14793_14816__$1);
var G__14827 = null;
var G__14828 = (0);
var G__14829 = (0);
seq__14793_14803 = G__14826;
chunk__14794_14804 = G__14827;
count__14795_14805 = G__14828;
i__14796_14806 = G__14829;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__14791_14801);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__14830){
var map__14831 = p__14830;
var map__14831__$1 = cljs.core.__destructure_map(map__14831);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14831__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14831__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14831__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__4706__auto___14832 = cljs.core.count(exprs);
var i_14833 = (0);
while(true){
if((i_14833 < n__4706__auto___14832)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_14833) : temps.call(null,i_14833))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_14833) : exprs.call(null,i_14833)),";");

var G__14834 = (i_14833 + (1));
i_14833 = G__14834;
continue;
} else {
}
break;
}

var n__4706__auto___14835 = cljs.core.count(exprs);
var i_14836 = (0);
while(true){
if((i_14836 < n__4706__auto___14835)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_14836) : params.call(null,i_14836)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_14836) : temps.call(null,i_14836)),";");

var G__14837 = (i_14836 + (1));
i_14836 = G__14837;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__14838){
var map__14839 = p__14838;
var map__14839__$1 = cljs.core.__destructure_map(map__14839);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14839__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14839__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14839__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__14840_14848 = cljs.core.seq(bindings);
var chunk__14841_14849 = null;
var count__14842_14850 = (0);
var i__14843_14851 = (0);
while(true){
if((i__14843_14851 < count__14842_14850)){
var map__14846_14852 = chunk__14841_14849.cljs$core$IIndexed$_nth$arity$2(null,i__14843_14851);
var map__14846_14853__$1 = cljs.core.__destructure_map(map__14846_14852);
var binding_14854 = map__14846_14853__$1;
var init_14855 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14846_14853__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_14854)," = ",init_14855,";");


var G__14856 = seq__14840_14848;
var G__14857 = chunk__14841_14849;
var G__14858 = count__14842_14850;
var G__14859 = (i__14843_14851 + (1));
seq__14840_14848 = G__14856;
chunk__14841_14849 = G__14857;
count__14842_14850 = G__14858;
i__14843_14851 = G__14859;
continue;
} else {
var temp__5753__auto___14860 = cljs.core.seq(seq__14840_14848);
if(temp__5753__auto___14860){
var seq__14840_14861__$1 = temp__5753__auto___14860;
if(cljs.core.chunked_seq_QMARK_(seq__14840_14861__$1)){
var c__4649__auto___14862 = cljs.core.chunk_first(seq__14840_14861__$1);
var G__14863 = cljs.core.chunk_rest(seq__14840_14861__$1);
var G__14864 = c__4649__auto___14862;
var G__14865 = cljs.core.count(c__4649__auto___14862);
var G__14866 = (0);
seq__14840_14848 = G__14863;
chunk__14841_14849 = G__14864;
count__14842_14850 = G__14865;
i__14843_14851 = G__14866;
continue;
} else {
var map__14847_14867 = cljs.core.first(seq__14840_14861__$1);
var map__14847_14868__$1 = cljs.core.__destructure_map(map__14847_14867);
var binding_14869 = map__14847_14868__$1;
var init_14870 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14847_14868__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_14869)," = ",init_14870,";");


var G__14871 = cljs.core.next(seq__14840_14861__$1);
var G__14872 = null;
var G__14873 = (0);
var G__14874 = (0);
seq__14840_14848 = G__14871;
chunk__14841_14849 = G__14872;
count__14842_14850 = G__14873;
i__14843_14851 = G__14874;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__14877){
var map__14878 = p__14877;
var map__14878__$1 = cljs.core.__destructure_map(map__14878);
var expr = map__14878__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14878__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14878__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14878__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4221__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info));
if(and__4221__auto____$1){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4221__auto__ = protocol;
if(cljs.core.truth_(and__4221__auto__)){
var and__4221__auto____$1 = tag;
if(cljs.core.truth_(and__4221__auto____$1)){
var or__4223__auto__ = (function (){var and__4221__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto____$2)){
var and__4221__auto____$3 = protocol;
if(cljs.core.truth_(and__4221__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__4221__auto____$3;
}
} else {
return and__4221__auto____$2;
}
})();
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var and__4221__auto____$2 = (function (){var or__4223__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4221__auto____$2)){
var or__4223__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4223__auto____$1){
return or__4223__auto____$1;
} else {
var and__4221__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4221__auto____$3){
var and__4221__auto____$4 = cljs.core.not((function (){var fexpr__14882 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__14882.cljs$core$IFn$_invoke$arity$1 ? fexpr__14882.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__14882.call(null,tag));
})());
if(and__4221__auto____$4){
var temp__5753__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4221__auto____$4;
}
} else {
return and__4221__auto____$3;
}
}
} else {
return and__4221__auto____$2;
}
}
} else {
return and__4221__auto____$1;
}
} else {
return and__4221__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,cljs.core.cst$sym$boolean)));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_count)) && (cljs.core.boolean$((function (){var fexpr__14883 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null"], null), null);
return (fexpr__14883.cljs$core$IFn$_invoke$arity$1 ? fexpr__14883.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__14883.call(null,first_arg_tag));
})())));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math);
if(or__4223__auto____$1){
return or__4223__auto____$1;
} else {
return cljs.core.cst$kw$foreign.cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4223__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,ftag);
if(or__4223__auto__){
return or__4223__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__14879 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4221__auto__)){
return (arity > mfa);
} else {
return and__4221__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__14875_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__14875_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__14876_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__14876_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14879,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14879,(1),null);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_14886 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_14886,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_14887 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_14887,args)),(((mfa_14887 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_14887,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
var or__4223__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4223__auto____$1)){
return or__4223__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4221__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4221__auto__)){
var G__14885 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__14884 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__14884.cljs$core$IFn$_invoke$arity$1 ? fexpr__14884.cljs$core$IFn$_invoke$arity$1(G__14885) : fexpr__14884.call(null,G__14885));
} else {
return and__4221__auto__;
}
})())){
var fprop_14888 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_14888," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_14888,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_14888," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_14888,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__14889){
var map__14890 = p__14889;
var map__14890__$1 = cljs.core.__destructure_map(map__14890);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14890__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14890__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14890__$1,cljs.core.cst$kw$env);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__14891){
var map__14892 = p__14891;
var map__14892__$1 = cljs.core.__destructure_map(map__14892);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14892__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14892__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14892__$1,cljs.core.cst$kw$env);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__14893_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__14893_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__14894 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14894,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14894,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4223__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__14897 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__14897__$1 = cljs.core.__destructure_map(map__14897);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14897__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14897__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__14898 = options;
var map__14898__$1 = cljs.core.__destructure_map(map__14898);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14898__$1,cljs.core.cst$kw$target);
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14898__$1,cljs.core.cst$kw$nodejs_DASH_rt);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14898__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__14899 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__14902 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__14902__$1 = cljs.core.__destructure_map(map__14902);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14902__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14902__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14899,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14899,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__14903_14931 = cljs.core.seq(libs_to_load);
var chunk__14904_14932 = null;
var count__14905_14933 = (0);
var i__14906_14934 = (0);
while(true){
if((i__14906_14934 < count__14905_14933)){
var lib_14935 = chunk__14904_14932.cljs$core$IIndexed$_nth$arity$2(null,i__14906_14934);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_14935)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_14935),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_14935),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_14935),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_14935),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_14935,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_14935),"');");
}

}
}
}


var G__14936 = seq__14903_14931;
var G__14937 = chunk__14904_14932;
var G__14938 = count__14905_14933;
var G__14939 = (i__14906_14934 + (1));
seq__14903_14931 = G__14936;
chunk__14904_14932 = G__14937;
count__14905_14933 = G__14938;
i__14906_14934 = G__14939;
continue;
} else {
var temp__5753__auto___14940 = cljs.core.seq(seq__14903_14931);
if(temp__5753__auto___14940){
var seq__14903_14941__$1 = temp__5753__auto___14940;
if(cljs.core.chunked_seq_QMARK_(seq__14903_14941__$1)){
var c__4649__auto___14942 = cljs.core.chunk_first(seq__14903_14941__$1);
var G__14943 = cljs.core.chunk_rest(seq__14903_14941__$1);
var G__14944 = c__4649__auto___14942;
var G__14945 = cljs.core.count(c__4649__auto___14942);
var G__14946 = (0);
seq__14903_14931 = G__14943;
chunk__14904_14932 = G__14944;
count__14905_14933 = G__14945;
i__14906_14934 = G__14946;
continue;
} else {
var lib_14947 = cljs.core.first(seq__14903_14941__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_14947)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_14947),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_14947),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4223__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4223__auto__)){
return or__4223__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_14947),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_14947),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_14947,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_14947),"');");
}

}
}
}


var G__14948 = cljs.core.next(seq__14903_14941__$1);
var G__14949 = null;
var G__14950 = (0);
var G__14951 = (0);
seq__14903_14931 = G__14948;
chunk__14904_14932 = G__14949;
count__14905_14933 = G__14950;
i__14906_14934 = G__14951;
continue;
}
} else {
}
}
break;
}

var seq__14907_14952 = cljs.core.seq(node_libs);
var chunk__14908_14953 = null;
var count__14909_14954 = (0);
var i__14910_14955 = (0);
while(true){
if((i__14910_14955 < count__14909_14954)){
var lib_14956 = chunk__14908_14953.cljs$core$IIndexed$_nth$arity$2(null,i__14910_14955);
var vec__14917_14957 = cljs.analyzer.lib_AMPERSAND_sublib(lib_14956);
var lib_SINGLEQUOTE__14958 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14917_14957,(0),null);
var sublib_14959 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14917_14957,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_14956)," = require('",lib_SINGLEQUOTE__14958,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_14959),";"], 0));


var G__14960 = seq__14907_14952;
var G__14961 = chunk__14908_14953;
var G__14962 = count__14909_14954;
var G__14963 = (i__14910_14955 + (1));
seq__14907_14952 = G__14960;
chunk__14908_14953 = G__14961;
count__14909_14954 = G__14962;
i__14910_14955 = G__14963;
continue;
} else {
var temp__5753__auto___14964 = cljs.core.seq(seq__14907_14952);
if(temp__5753__auto___14964){
var seq__14907_14965__$1 = temp__5753__auto___14964;
if(cljs.core.chunked_seq_QMARK_(seq__14907_14965__$1)){
var c__4649__auto___14966 = cljs.core.chunk_first(seq__14907_14965__$1);
var G__14967 = cljs.core.chunk_rest(seq__14907_14965__$1);
var G__14968 = c__4649__auto___14966;
var G__14969 = cljs.core.count(c__4649__auto___14966);
var G__14970 = (0);
seq__14907_14952 = G__14967;
chunk__14908_14953 = G__14968;
count__14909_14954 = G__14969;
i__14910_14955 = G__14970;
continue;
} else {
var lib_14971 = cljs.core.first(seq__14907_14965__$1);
var vec__14920_14972 = cljs.analyzer.lib_AMPERSAND_sublib(lib_14971);
var lib_SINGLEQUOTE__14973 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14920_14972,(0),null);
var sublib_14974 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14920_14972,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_14971)," = require('",lib_SINGLEQUOTE__14973,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_14974),";"], 0));


var G__14975 = cljs.core.next(seq__14907_14965__$1);
var G__14976 = null;
var G__14977 = (0);
var G__14978 = (0);
seq__14907_14952 = G__14975;
chunk__14908_14953 = G__14976;
count__14909_14954 = G__14977;
i__14910_14955 = G__14978;
continue;
}
} else {
}
}
break;
}

var seq__14923_14979 = cljs.core.seq(global_exports_libs);
var chunk__14924_14980 = null;
var count__14925_14981 = (0);
var i__14926_14982 = (0);
while(true){
if((i__14926_14982 < count__14925_14981)){
var lib_14983 = chunk__14924_14980.cljs$core$IIndexed$_nth$arity$2(null,i__14926_14982);
var map__14929_14984 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_14983))));
var map__14929_14985__$1 = cljs.core.__destructure_map(map__14929_14984);
var global_exports_14986 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14929_14985__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_14986,lib_14983);


var G__14987 = seq__14923_14979;
var G__14988 = chunk__14924_14980;
var G__14989 = count__14925_14981;
var G__14990 = (i__14926_14982 + (1));
seq__14923_14979 = G__14987;
chunk__14924_14980 = G__14988;
count__14925_14981 = G__14989;
i__14926_14982 = G__14990;
continue;
} else {
var temp__5753__auto___14991 = cljs.core.seq(seq__14923_14979);
if(temp__5753__auto___14991){
var seq__14923_14992__$1 = temp__5753__auto___14991;
if(cljs.core.chunked_seq_QMARK_(seq__14923_14992__$1)){
var c__4649__auto___14993 = cljs.core.chunk_first(seq__14923_14992__$1);
var G__14994 = cljs.core.chunk_rest(seq__14923_14992__$1);
var G__14995 = c__4649__auto___14993;
var G__14996 = cljs.core.count(c__4649__auto___14993);
var G__14997 = (0);
seq__14923_14979 = G__14994;
chunk__14924_14980 = G__14995;
count__14925_14981 = G__14996;
i__14926_14982 = G__14997;
continue;
} else {
var lib_14998 = cljs.core.first(seq__14923_14992__$1);
var map__14930_14999 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_14998))));
var map__14930_15000__$1 = cljs.core.__destructure_map(map__14930_14999);
var global_exports_15001 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__14930_15000__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_15001,lib_14998);


var G__15002 = cljs.core.next(seq__14923_14992__$1);
var G__15003 = null;
var G__15004 = (0);
var G__15005 = (0);
seq__14923_14979 = G__15002;
chunk__14924_14980 = G__15003;
count__14925_14981 = G__15004;
i__14926_14982 = G__15005;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__15006){
var map__15007 = p__15006;
var map__15007__$1 = cljs.core.__destructure_map(map__15007);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15007__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15007__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15007__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15007__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15007__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15007__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15007__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__15008){
var map__15009 = p__15008;
var map__15009__$1 = cljs.core.__destructure_map(map__15009);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15009__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15009__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15009__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15009__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15009__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15009__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15009__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__15010){
var map__15011 = p__15010;
var map__15011__$1 = cljs.core.__destructure_map(map__15011);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15011__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__15012_15036 = cljs.core.seq(protocols);
var chunk__15013_15037 = null;
var count__15014_15038 = (0);
var i__15015_15039 = (0);
while(true){
if((i__15015_15039 < count__15014_15038)){
var protocol_15040 = chunk__15013_15037.cljs$core$IIndexed$_nth$arity$2(null,i__15015_15039);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_15040)),"}");


var G__15041 = seq__15012_15036;
var G__15042 = chunk__15013_15037;
var G__15043 = count__15014_15038;
var G__15044 = (i__15015_15039 + (1));
seq__15012_15036 = G__15041;
chunk__15013_15037 = G__15042;
count__15014_15038 = G__15043;
i__15015_15039 = G__15044;
continue;
} else {
var temp__5753__auto___15045 = cljs.core.seq(seq__15012_15036);
if(temp__5753__auto___15045){
var seq__15012_15046__$1 = temp__5753__auto___15045;
if(cljs.core.chunked_seq_QMARK_(seq__15012_15046__$1)){
var c__4649__auto___15047 = cljs.core.chunk_first(seq__15012_15046__$1);
var G__15048 = cljs.core.chunk_rest(seq__15012_15046__$1);
var G__15049 = c__4649__auto___15047;
var G__15050 = cljs.core.count(c__4649__auto___15047);
var G__15051 = (0);
seq__15012_15036 = G__15048;
chunk__15013_15037 = G__15049;
count__15014_15038 = G__15050;
i__15015_15039 = G__15051;
continue;
} else {
var protocol_15052 = cljs.core.first(seq__15012_15046__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_15052)),"}");


var G__15053 = cljs.core.next(seq__15012_15046__$1);
var G__15054 = null;
var G__15055 = (0);
var G__15056 = (0);
seq__15012_15036 = G__15053;
chunk__15013_15037 = G__15054;
count__15014_15038 = G__15055;
i__15015_15039 = G__15056;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__15016_15057 = cljs.core.seq(fields__$1);
var chunk__15017_15058 = null;
var count__15018_15059 = (0);
var i__15019_15060 = (0);
while(true){
if((i__15019_15060 < count__15018_15059)){
var fld_15061 = chunk__15017_15058.cljs$core$IIndexed$_nth$arity$2(null,i__15019_15060);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_15061," = ",fld_15061,";");


var G__15062 = seq__15016_15057;
var G__15063 = chunk__15017_15058;
var G__15064 = count__15018_15059;
var G__15065 = (i__15019_15060 + (1));
seq__15016_15057 = G__15062;
chunk__15017_15058 = G__15063;
count__15018_15059 = G__15064;
i__15019_15060 = G__15065;
continue;
} else {
var temp__5753__auto___15066 = cljs.core.seq(seq__15016_15057);
if(temp__5753__auto___15066){
var seq__15016_15067__$1 = temp__5753__auto___15066;
if(cljs.core.chunked_seq_QMARK_(seq__15016_15067__$1)){
var c__4649__auto___15068 = cljs.core.chunk_first(seq__15016_15067__$1);
var G__15069 = cljs.core.chunk_rest(seq__15016_15067__$1);
var G__15070 = c__4649__auto___15068;
var G__15071 = cljs.core.count(c__4649__auto___15068);
var G__15072 = (0);
seq__15016_15057 = G__15069;
chunk__15017_15058 = G__15070;
count__15018_15059 = G__15071;
i__15019_15060 = G__15072;
continue;
} else {
var fld_15073 = cljs.core.first(seq__15016_15067__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_15073," = ",fld_15073,";");


var G__15074 = cljs.core.next(seq__15016_15067__$1);
var G__15075 = null;
var G__15076 = (0);
var G__15077 = (0);
seq__15016_15057 = G__15074;
chunk__15017_15058 = G__15075;
count__15018_15059 = G__15076;
i__15019_15060 = G__15077;
continue;
}
} else {
}
}
break;
}

var seq__15020_15078 = cljs.core.seq(pmasks);
var chunk__15021_15079 = null;
var count__15022_15080 = (0);
var i__15023_15081 = (0);
while(true){
if((i__15023_15081 < count__15022_15080)){
var vec__15030_15082 = chunk__15021_15079.cljs$core$IIndexed$_nth$arity$2(null,i__15023_15081);
var pno_15083 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15030_15082,(0),null);
var pmask_15084 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15030_15082,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_15083,"$ = ",pmask_15084,";");


var G__15085 = seq__15020_15078;
var G__15086 = chunk__15021_15079;
var G__15087 = count__15022_15080;
var G__15088 = (i__15023_15081 + (1));
seq__15020_15078 = G__15085;
chunk__15021_15079 = G__15086;
count__15022_15080 = G__15087;
i__15023_15081 = G__15088;
continue;
} else {
var temp__5753__auto___15089 = cljs.core.seq(seq__15020_15078);
if(temp__5753__auto___15089){
var seq__15020_15090__$1 = temp__5753__auto___15089;
if(cljs.core.chunked_seq_QMARK_(seq__15020_15090__$1)){
var c__4649__auto___15091 = cljs.core.chunk_first(seq__15020_15090__$1);
var G__15092 = cljs.core.chunk_rest(seq__15020_15090__$1);
var G__15093 = c__4649__auto___15091;
var G__15094 = cljs.core.count(c__4649__auto___15091);
var G__15095 = (0);
seq__15020_15078 = G__15092;
chunk__15021_15079 = G__15093;
count__15022_15080 = G__15094;
i__15023_15081 = G__15095;
continue;
} else {
var vec__15033_15096 = cljs.core.first(seq__15020_15090__$1);
var pno_15097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15033_15096,(0),null);
var pmask_15098 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15033_15096,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_15097,"$ = ",pmask_15098,";");


var G__15099 = cljs.core.next(seq__15020_15090__$1);
var G__15100 = null;
var G__15101 = (0);
var G__15102 = (0);
seq__15020_15078 = G__15099;
chunk__15021_15079 = G__15100;
count__15022_15080 = G__15101;
i__15023_15081 = G__15102;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__15103){
var map__15104 = p__15103;
var map__15104__$1 = cljs.core.__destructure_map(map__15104);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15104__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15104__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15104__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15104__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15104__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__15105_15129 = cljs.core.seq(protocols);
var chunk__15106_15130 = null;
var count__15107_15131 = (0);
var i__15108_15132 = (0);
while(true){
if((i__15108_15132 < count__15107_15131)){
var protocol_15133 = chunk__15106_15130.cljs$core$IIndexed$_nth$arity$2(null,i__15108_15132);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_15133)),"}");


var G__15134 = seq__15105_15129;
var G__15135 = chunk__15106_15130;
var G__15136 = count__15107_15131;
var G__15137 = (i__15108_15132 + (1));
seq__15105_15129 = G__15134;
chunk__15106_15130 = G__15135;
count__15107_15131 = G__15136;
i__15108_15132 = G__15137;
continue;
} else {
var temp__5753__auto___15138 = cljs.core.seq(seq__15105_15129);
if(temp__5753__auto___15138){
var seq__15105_15139__$1 = temp__5753__auto___15138;
if(cljs.core.chunked_seq_QMARK_(seq__15105_15139__$1)){
var c__4649__auto___15140 = cljs.core.chunk_first(seq__15105_15139__$1);
var G__15141 = cljs.core.chunk_rest(seq__15105_15139__$1);
var G__15142 = c__4649__auto___15140;
var G__15143 = cljs.core.count(c__4649__auto___15140);
var G__15144 = (0);
seq__15105_15129 = G__15141;
chunk__15106_15130 = G__15142;
count__15107_15131 = G__15143;
i__15108_15132 = G__15144;
continue;
} else {
var protocol_15145 = cljs.core.first(seq__15105_15139__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_15145)),"}");


var G__15146 = cljs.core.next(seq__15105_15139__$1);
var G__15147 = null;
var G__15148 = (0);
var G__15149 = (0);
seq__15105_15129 = G__15146;
chunk__15106_15130 = G__15147;
count__15107_15131 = G__15148;
i__15108_15132 = G__15149;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__15109_15150 = cljs.core.seq(fields__$1);
var chunk__15110_15151 = null;
var count__15111_15152 = (0);
var i__15112_15153 = (0);
while(true){
if((i__15112_15153 < count__15111_15152)){
var fld_15154 = chunk__15110_15151.cljs$core$IIndexed$_nth$arity$2(null,i__15112_15153);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_15154," = ",fld_15154,";");


var G__15155 = seq__15109_15150;
var G__15156 = chunk__15110_15151;
var G__15157 = count__15111_15152;
var G__15158 = (i__15112_15153 + (1));
seq__15109_15150 = G__15155;
chunk__15110_15151 = G__15156;
count__15111_15152 = G__15157;
i__15112_15153 = G__15158;
continue;
} else {
var temp__5753__auto___15159 = cljs.core.seq(seq__15109_15150);
if(temp__5753__auto___15159){
var seq__15109_15160__$1 = temp__5753__auto___15159;
if(cljs.core.chunked_seq_QMARK_(seq__15109_15160__$1)){
var c__4649__auto___15161 = cljs.core.chunk_first(seq__15109_15160__$1);
var G__15162 = cljs.core.chunk_rest(seq__15109_15160__$1);
var G__15163 = c__4649__auto___15161;
var G__15164 = cljs.core.count(c__4649__auto___15161);
var G__15165 = (0);
seq__15109_15150 = G__15162;
chunk__15110_15151 = G__15163;
count__15111_15152 = G__15164;
i__15112_15153 = G__15165;
continue;
} else {
var fld_15166 = cljs.core.first(seq__15109_15160__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_15166," = ",fld_15166,";");


var G__15167 = cljs.core.next(seq__15109_15160__$1);
var G__15168 = null;
var G__15169 = (0);
var G__15170 = (0);
seq__15109_15150 = G__15167;
chunk__15110_15151 = G__15168;
count__15111_15152 = G__15169;
i__15112_15153 = G__15170;
continue;
}
} else {
}
}
break;
}

var seq__15113_15171 = cljs.core.seq(pmasks);
var chunk__15114_15172 = null;
var count__15115_15173 = (0);
var i__15116_15174 = (0);
while(true){
if((i__15116_15174 < count__15115_15173)){
var vec__15123_15175 = chunk__15114_15172.cljs$core$IIndexed$_nth$arity$2(null,i__15116_15174);
var pno_15176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15123_15175,(0),null);
var pmask_15177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15123_15175,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_15176,"$ = ",pmask_15177,";");


var G__15178 = seq__15113_15171;
var G__15179 = chunk__15114_15172;
var G__15180 = count__15115_15173;
var G__15181 = (i__15116_15174 + (1));
seq__15113_15171 = G__15178;
chunk__15114_15172 = G__15179;
count__15115_15173 = G__15180;
i__15116_15174 = G__15181;
continue;
} else {
var temp__5753__auto___15182 = cljs.core.seq(seq__15113_15171);
if(temp__5753__auto___15182){
var seq__15113_15183__$1 = temp__5753__auto___15182;
if(cljs.core.chunked_seq_QMARK_(seq__15113_15183__$1)){
var c__4649__auto___15184 = cljs.core.chunk_first(seq__15113_15183__$1);
var G__15185 = cljs.core.chunk_rest(seq__15113_15183__$1);
var G__15186 = c__4649__auto___15184;
var G__15187 = cljs.core.count(c__4649__auto___15184);
var G__15188 = (0);
seq__15113_15171 = G__15185;
chunk__15114_15172 = G__15186;
count__15115_15173 = G__15187;
i__15116_15174 = G__15188;
continue;
} else {
var vec__15126_15189 = cljs.core.first(seq__15113_15183__$1);
var pno_15190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15126_15189,(0),null);
var pmask_15191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15126_15189,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_15190,"$ = ",pmask_15191,";");


var G__15192 = cljs.core.next(seq__15113_15183__$1);
var G__15193 = null;
var G__15194 = (0);
var G__15195 = (0);
seq__15113_15171 = G__15192;
chunk__15114_15172 = G__15193;
count__15115_15173 = G__15194;
i__15116_15174 = G__15195;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__15196){
var map__15197 = p__15196;
var map__15197__$1 = cljs.core.__destructure_map(map__15197);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15197__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15197__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15197__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15197__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15197__$1,cljs.core.cst$kw$env);
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__15198){
var map__15199 = p__15198;
var map__15199__$1 = cljs.core.__destructure_map(map__15199);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15199__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15199__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15199__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15199__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15199__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__4221__auto__ = code;
if(cljs.core.truth_(and__4221__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4221__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__12756__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__12756__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__15204 = cljs.core.seq(table);
var chunk__15205 = null;
var count__15206 = (0);
var i__15207 = (0);
while(true){
if((i__15207 < count__15206)){
var vec__15214 = chunk__15205.cljs$core$IIndexed$_nth$arity$2(null,i__15207);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15214,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15214,(1),null);
var ns_15220 = cljs.core.namespace(sym);
var name_15221 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__15222 = seq__15204;
var G__15223 = chunk__15205;
var G__15224 = count__15206;
var G__15225 = (i__15207 + (1));
seq__15204 = G__15222;
chunk__15205 = G__15223;
count__15206 = G__15224;
i__15207 = G__15225;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__15204);
if(temp__5753__auto__){
var seq__15204__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15204__$1)){
var c__4649__auto__ = cljs.core.chunk_first(seq__15204__$1);
var G__15226 = cljs.core.chunk_rest(seq__15204__$1);
var G__15227 = c__4649__auto__;
var G__15228 = cljs.core.count(c__4649__auto__);
var G__15229 = (0);
seq__15204 = G__15226;
chunk__15205 = G__15227;
count__15206 = G__15228;
i__15207 = G__15229;
continue;
} else {
var vec__15217 = cljs.core.first(seq__15204__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15217,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15217,(1),null);
var ns_15230 = cljs.core.namespace(sym);
var name_15231 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__15232 = cljs.core.next(seq__15204__$1);
var G__15233 = null;
var G__15234 = (0);
var G__15235 = (0);
seq__15204 = G__15232;
chunk__15205 = G__15233;
count__15206 = G__15234;
i__15207 = G__15235;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__15237 = arguments.length;
switch (G__15237) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_15242 = cljs.core.first(ks);
var vec__15238_15243 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_15242);
var top_15244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15238_15243,(0),null);
var prefix_SINGLEQUOTE__15245 = vec__15238_15243;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_15242)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__15245) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_15244)) || (cljs.core.contains_QMARK_(known_externs,top_15244)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__15245)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_15244);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__15245)),";");
}
} else {
}

var m_15246 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_15242);
if(cljs.core.empty_QMARK_(m_15246)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__15245,m_15246,top_level,known_externs);
}

var G__15247 = cljs.core.next(ks);
ks = G__15247;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

