// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('jx.reporter.karma');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.test');
goog.require('clojure.data');
goog.require('fipp.clojure');
goog.require('clojure.string');
goog.require('goog.object');
jx.reporter.karma.karma = cljs.core.volatile_BANG_(null);
jx.reporter.karma.karma_QMARK_ = (function jx$reporter$karma$karma_QMARK_(){
return (!((cljs.core.deref(jx.reporter.karma.karma) == null)));
});
jx.reporter.karma.karma_info_BANG_ = (function jx$reporter$karma$karma_info_BANG_(m){
if(jx.reporter.karma.karma_QMARK_()){
return cljs.core.deref(jx.reporter.karma.karma).info(cljs.core.clj__GT_js(m));
} else {
return null;
}
});
jx.reporter.karma.karma_result_BANG_ = (function jx$reporter$karma$karma_result_BANG_(m){
if(jx.reporter.karma.karma_QMARK_()){
return cljs.core.deref(jx.reporter.karma.karma).result(cljs.core.clj__GT_js(m));
} else {
return null;
}
});
jx.reporter.karma.coverage_result = (function jx$reporter$karma$coverage_result(){
return ({"coverage": goog.object.get(window,"__coverage__")});
});
jx.reporter.karma.karma_complete_BANG_ = (function jx$reporter$karma$karma_complete_BANG_(){
if(jx.reporter.karma.karma_QMARK_()){
return cljs.core.deref(jx.reporter.karma.karma).complete(jx.reporter.karma.coverage_result());
} else {
return null;
}
});
jx.reporter.karma.now = (function jx$reporter$karma$now(){
return (new Date()).getTime();
});
jx.reporter.karma.indent = (function jx$reporter$karma$indent(n,s){
var indentation = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.str,"",cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(n," "));
return clojure.string.replace(s,/\n/,["\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(indentation)].join(''));
});
jx.reporter.karma.remove_last_new_line = (function jx$reporter$karma$remove_last_new_line(s){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),(cljs.core.count(s) - (1)));
});
jx.reporter.karma.format_fn = (function jx$reporter$karma$format_fn(indentation,p__43853){
var vec__43854 = p__43853;
var seq__43855 = cljs.core.seq(vec__43854);
var first__43856 = cljs.core.first(seq__43855);
var seq__43855__$1 = cljs.core.next(seq__43855);
var c = first__43856;
var q = seq__43855__$1;
var e = ["\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__43852_SHARP_){
var sb__4702__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__43861_43865 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__43862_43866 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__43863_43867 = true;
var _STAR_print_fn_STAR__temp_val__43864_43868 = (function (x__4703__auto__){
return sb__4702__auto__.append(x__4703__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__43863_43867);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__43864_43868);

try{fipp.clojure.pprint.cljs$core$IFn$_invoke$arity$1(p1__43852_SHARP_);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__43862_43866);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__43861_43865);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4702__auto__);
}),q)))].join('');
return ["(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c),jx.reporter.karma.indent((indentation + (2)),jx.reporter.karma.remove_last_new_line(e)),")"].join('');
});
jx.reporter.karma.format_diff = (function jx$reporter$karma$format_diff(indentation,assert,p__43869){
var vec__43870 = p__43869;
var seq__43871 = cljs.core.seq(vec__43870);
var first__43872 = cljs.core.first(seq__43871);
var seq__43871__$1 = cljs.core.next(seq__43871);
var c = first__43872;
var first__43872__$1 = cljs.core.first(seq__43871__$1);
var seq__43871__$2 = cljs.core.next(seq__43871__$1);
var a = first__43872__$1;
var first__43872__$2 = cljs.core.first(seq__43871__$2);
var seq__43871__$3 = cljs.core.next(seq__43871__$2);
var b = first__43872__$2;
var q = seq__43871__$3;
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c,cljs.core.cst$sym$_EQ_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(assert),(3))) && ((q == null)))){
var format = (function (sign,value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sign)," ",(cljs.core.truth_(value)?jx.reporter.karma.indent((indentation + (2)),jx.reporter.karma.remove_last_new_line((function (){var sb__4702__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__43880_43884 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__43881_43885 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__43882_43886 = true;
var _STAR_print_fn_STAR__temp_val__43883_43887 = (function (x__4703__auto__){
return sb__4702__auto__.append(x__4703__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__43882_43886);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__43883_43887);

try{fipp.clojure.pprint.cljs$core$IFn$_invoke$arity$1(value);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__43881_43885);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__43880_43884);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4702__auto__);
})())):"\n")].join('');
});
var vec__43873 = clojure.data.diff(a,b);
var removed = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43873,(0),null);
var added = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43873,(1),null);
return [format("-",removed),format(["\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(indentation," "))),"+"].join(''),added)].join('');
} else {
return null;
}
});
jx.reporter.karma.format_log = (function jx$reporter$karma$format_log(p__43888){
var map__43889 = p__43888;
var map__43889__$1 = cljs.core.__destructure_map(map__43889);
var result = map__43889__$1;
var expected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43889__$1,cljs.core.cst$kw$expected);
var actual = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43889__$1,cljs.core.cst$kw$actual);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43889__$1,cljs.core.cst$kw$message);
var testing_contexts_str = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43889__$1,cljs.core.cst$kw$testing_DASH_contexts_DASH_str);
var indentation = (("expected: ").length);
return ["FAIL in   ",cljs.test.testing_vars_str(result),"\n",((clojure.string.blank_QMARK_(testing_contexts_str))?null:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(testing_contexts_str),"\"\n"].join('')),((((cljs.core.seq_QMARK_(expected)) && (cljs.core.seq_QMARK_(actual))))?["expected: ",jx.reporter.karma.format_fn(indentation,expected),"\n","  actual: ",jx.reporter.karma.format_fn(indentation,cljs.core.second(actual)),"\n",(function (){var temp__5753__auto__ = jx.reporter.karma.format_diff(indentation,expected,cljs.core.second(actual));
if(cljs.core.truth_(temp__5753__auto__)){
var diff = temp__5753__auto__;
return ["    diff: ",diff,"\n"].join('');
} else {
return null;
}
})()].join(''):[cljs.core.str.cljs$core$IFn$_invoke$arity$1(expected)," failed with ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(actual),"\n"].join('')),(cljs.core.truth_(message)?[" message: ",jx.reporter.karma.indent(indentation,message),"\n"].join(''):null)].join('');
});
jx.reporter.karma.test_var_result = cljs.core.volatile_BANG_(cljs.core.PersistentVector.EMPTY);
jx.reporter.karma.test_var_time_start = cljs.core.volatile_BANG_(jx.reporter.karma.now());
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$karma,(function (_){
return null;
}));
cljs.core.derive.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$cljs$test_SLASH_default);
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$summary], null),(function (_){
return null;
}));
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$begin_DASH_test_DASH_ns], null),(function (m){
return null;
}));
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$begin_DASH_test_DASH_var], null),(function (_){
cljs.core.vreset_BANG_(jx.reporter.karma.test_var_time_start,jx.reporter.karma.now());

return cljs.core.vreset_BANG_(jx.reporter.karma.test_var_result,cljs.core.PersistentVector.EMPTY);
}));
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$end_DASH_test_DASH_var], null),(function (m){
var var_meta = cljs.core.meta(cljs.core.cst$kw$var.cljs$core$IFn$_invoke$arity$1(m));
var result = new cljs.core.PersistentArrayMap(null, 6, ["suite",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(var_meta)], null),"description",cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(var_meta),"success",(cljs.core.count(cljs.core.deref(jx.reporter.karma.test_var_result)) === (0)),"skipped",null,"time",(jx.reporter.karma.now() - cljs.core.deref(jx.reporter.karma.test_var_time_start)),"log",cljs.core.map.cljs$core$IFn$_invoke$arity$2(jx.reporter.karma.format_log,cljs.core.deref(jx.reporter.karma.test_var_result))], null);
return jx.reporter.karma.karma_result_BANG_(result);
}));
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$fail], null),(function (m){
cljs.test.inc_report_counter_BANG_(cljs.core.cst$kw$fail);

return jx.reporter.karma.test_var_result.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(jx.reporter.karma.test_var_result.cljs$core$IDeref$_deref$arity$1(null),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,cljs.core.cst$kw$testing_DASH_contexts_DASH_str,cljs.test.testing_contexts_str())));
}));
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$error], null),(function (m){
cljs.test.inc_report_counter_BANG_(cljs.core.cst$kw$error);

return jx.reporter.karma.test_var_result.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(jx.reporter.karma.test_var_result.cljs$core$IDeref$_deref$arity$1(null),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,cljs.core.cst$kw$testing_DASH_contexts_DASH_str,cljs.test.testing_contexts_str())));
}));
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$end_DASH_run_DASH_tests], null),(function (_){
return jx.reporter.karma.karma_complete_BANG_();
}));
jx.reporter.karma.start = (function jx$reporter$karma$start(tc,total_count){
cljs.core.vreset_BANG_(jx.reporter.karma.karma,tc);

return jx.reporter.karma.karma_info_BANG_(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,total_count], null));
});
