// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('instaparse.transform');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.gll');
goog.require('instaparse.util');
instaparse.transform.map_preserving_meta = (function instaparse$transform$map_preserving_meta(f,l){
return cljs.core.with_meta(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,l),cljs.core.meta(l));
});
/**
 * This variation of the merge-meta in gll does nothing if obj is not
 * something that can have a metamap attached.
 */
instaparse.transform.merge_meta = (function instaparse$transform$merge_meta(obj,metamap){
if((((!((obj == null))))?(((((obj.cljs$lang$protocol_mask$partition0$ & (262144))) || ((cljs.core.PROTOCOL_SENTINEL === obj.cljs$core$IWithMeta$))))?true:(((!obj.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,obj):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,obj))){
return instaparse.gll.merge_meta(obj,metamap);
} else {
return obj;
}
});
instaparse.transform.enlive_transform = (function instaparse$transform$enlive_transform(transform_map,parse_tree){
var transform = (function (){var G__78603 = cljs.core.cst$kw$tag.cljs$core$IFn$_invoke$arity$1(parse_tree);
return (transform_map.cljs$core$IFn$_invoke$arity$1 ? transform_map.cljs$core$IFn$_invoke$arity$1(G__78603) : transform_map.call(null,G__78603));
})();
if(cljs.core.truth_(transform)){
return instaparse.transform.merge_meta(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(transform,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(instaparse.transform.enlive_transform,transform_map),cljs.core.cst$kw$content.cljs$core$IFn$_invoke$arity$1(parse_tree))),cljs.core.meta(parse_tree));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$tag.cljs$core$IFn$_invoke$arity$1(parse_tree))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(parse_tree,cljs.core.cst$kw$content,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(instaparse.transform.enlive_transform,transform_map),cljs.core.cst$kw$content.cljs$core$IFn$_invoke$arity$1(parse_tree)));
} else {
return parse_tree;

}
}
});
instaparse.transform.hiccup_transform = (function instaparse$transform$hiccup_transform(transform_map,parse_tree){
if(((cljs.core.sequential_QMARK_(parse_tree)) && (cljs.core.seq(parse_tree)))){
var temp__5751__auto__ = (function (){var G__78604 = cljs.core.first(parse_tree);
return (transform_map.cljs$core$IFn$_invoke$arity$1 ? transform_map.cljs$core$IFn$_invoke$arity$1(G__78604) : transform_map.call(null,G__78604));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var transform = temp__5751__auto__;
return instaparse.transform.merge_meta(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(transform,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(instaparse.transform.hiccup_transform,transform_map),cljs.core.next(parse_tree))),cljs.core.meta(parse_tree));
} else {
return cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(parse_tree)], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(instaparse.transform.hiccup_transform,transform_map),cljs.core.next(parse_tree))),cljs.core.meta(parse_tree));
}
} else {
return parse_tree;
}
});
/**
 * Takes a transform map and a parse tree (or seq of parse-trees).
 * A transform map is a mapping from tags to 
 * functions that take a node's contents and return
 * a replacement for the node, i.e.,
 * {:node-tag (fn [child1 child2 ...] node-replacement),
 *  :another-node-tag (fn [child1 child2 ...] node-replacement)}
 */
instaparse.transform.transform = (function instaparse$transform$transform(transform_map,parse_tree){
if(typeof parse_tree === 'string'){
return parse_tree;
} else {
if(cljs.core.truth_(((cljs.core.map_QMARK_(parse_tree))?cljs.core.cst$kw$tag.cljs$core$IFn$_invoke$arity$1(parse_tree):false))){
return instaparse.transform.enlive_transform(transform_map,parse_tree);
} else {
if(((cljs.core.vector_QMARK_(parse_tree)) && ((cljs.core.first(parse_tree) instanceof cljs.core.Keyword)))){
return instaparse.transform.hiccup_transform(transform_map,parse_tree);
} else {
if(cljs.core.sequential_QMARK_(parse_tree)){
return instaparse.transform.map_preserving_meta(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(instaparse.transform.transform,transform_map),parse_tree);
} else {
if((parse_tree instanceof instaparse.gll.Failure)){
return parse_tree;
} else {
return instaparse.util.throw_illegal_argument_exception.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Invalid parse-tree, not recognized as either enlive or hiccup format."], 0));

}
}
}
}
}
});
