// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k40596,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__40600 = k40596;
var G__40600__$1 = (((G__40600 instanceof cljs.core.Keyword))?G__40600.fqn:null);
switch (G__40600__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k40596,else__4418__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__40601){
var vec__40602 = p__40601;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40602,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40602,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__40595){
var self__ = this;
var G__40595__$1 = this;
return (new cljs.core.RecordIter((0),G__40595__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__40605 = (function (coll__4412__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__40605(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this40597,other40598){
var self__ = this;
var this40597__$1 = this;
return (((!((other40598 == null)))) && ((this40597__$1.constructor === other40598.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40597__$1.conn,other40598.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40597__$1.network,other40598.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40597__$1.dbid,other40598.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40597__$1.db_name,other40598.db_name)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40597__$1.update_chan,other40598.update_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40597__$1.transact_chan,other40598.transact_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40597__$1.state,other40598.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40597__$1.schema_cache,other40598.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40597__$1.blank_db,other40598.blank_db)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40597__$1.close,other40598.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40597__$1.id,other40598.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this40597__$1.__extmap,other40598.__extmap)));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__40595){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__40606 = cljs.core.keyword_identical_QMARK_;
var expr__40607 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__40609 = cljs.core.cst$kw$conn;
var G__40610 = expr__40607;
return (pred__40606.cljs$core$IFn$_invoke$arity$2 ? pred__40606.cljs$core$IFn$_invoke$arity$2(G__40609,G__40610) : pred__40606.call(null,G__40609,G__40610));
})())){
return (new fluree.db.session.DbSession(G__40595,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40611 = cljs.core.cst$kw$network;
var G__40612 = expr__40607;
return (pred__40606.cljs$core$IFn$_invoke$arity$2 ? pred__40606.cljs$core$IFn$_invoke$arity$2(G__40611,G__40612) : pred__40606.call(null,G__40611,G__40612));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__40595,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40613 = cljs.core.cst$kw$dbid;
var G__40614 = expr__40607;
return (pred__40606.cljs$core$IFn$_invoke$arity$2 ? pred__40606.cljs$core$IFn$_invoke$arity$2(G__40613,G__40614) : pred__40606.call(null,G__40613,G__40614));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__40595,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40615 = cljs.core.cst$kw$db_DASH_name;
var G__40616 = expr__40607;
return (pred__40606.cljs$core$IFn$_invoke$arity$2 ? pred__40606.cljs$core$IFn$_invoke$arity$2(G__40615,G__40616) : pred__40606.call(null,G__40615,G__40616));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__40595,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40617 = cljs.core.cst$kw$update_DASH_chan;
var G__40618 = expr__40607;
return (pred__40606.cljs$core$IFn$_invoke$arity$2 ? pred__40606.cljs$core$IFn$_invoke$arity$2(G__40617,G__40618) : pred__40606.call(null,G__40617,G__40618));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__40595,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40619 = cljs.core.cst$kw$transact_DASH_chan;
var G__40620 = expr__40607;
return (pred__40606.cljs$core$IFn$_invoke$arity$2 ? pred__40606.cljs$core$IFn$_invoke$arity$2(G__40619,G__40620) : pred__40606.call(null,G__40619,G__40620));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__40595,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40621 = cljs.core.cst$kw$state;
var G__40622 = expr__40607;
return (pred__40606.cljs$core$IFn$_invoke$arity$2 ? pred__40606.cljs$core$IFn$_invoke$arity$2(G__40621,G__40622) : pred__40606.call(null,G__40621,G__40622));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__40595,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40623 = cljs.core.cst$kw$schema_DASH_cache;
var G__40624 = expr__40607;
return (pred__40606.cljs$core$IFn$_invoke$arity$2 ? pred__40606.cljs$core$IFn$_invoke$arity$2(G__40623,G__40624) : pred__40606.call(null,G__40623,G__40624));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__40595,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40625 = cljs.core.cst$kw$blank_DASH_db;
var G__40626 = expr__40607;
return (pred__40606.cljs$core$IFn$_invoke$arity$2 ? pred__40606.cljs$core$IFn$_invoke$arity$2(G__40625,G__40626) : pred__40606.call(null,G__40625,G__40626));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__40595,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40627 = cljs.core.cst$kw$close;
var G__40628 = expr__40607;
return (pred__40606.cljs$core$IFn$_invoke$arity$2 ? pred__40606.cljs$core$IFn$_invoke$arity$2(G__40627,G__40628) : pred__40606.call(null,G__40627,G__40628));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__40595,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__40629 = cljs.core.cst$kw$id;
var G__40630 = expr__40607;
return (pred__40606.cljs$core$IFn$_invoke$arity$2 ? pred__40606.cljs$core$IFn$_invoke$arity$2(G__40629,G__40630) : pred__40606.call(null,G__40629,G__40630));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__40595,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__40595),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__40595){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__40595,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__40599){
var extmap__4454__auto__ = (function (){var G__40631 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__40599,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__40599)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__40631);
} else {
return G__40631;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__40599),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__40599),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__40599),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__40599),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__40599),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__40599),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__40599),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__40599),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__40599),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__40599),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__40599),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__40633 = session;
var map__40633__$1 = cljs.core.__destructure_map(map__40633);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40633__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40633__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___40785 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40737){
var state_val_40738 = (state_40737[(1)]);
if((state_val_40738 === (7))){
var inst_40654 = (state_40737[(7)]);
var inst_40659 = cljs.core.empty_QMARK_(inst_40654);
var state_40737__$1 = state_40737;
if(inst_40659){
var statearr_40739_40786 = state_40737__$1;
(statearr_40739_40786[(1)] = (10));

} else {
var statearr_40740_40787 = state_40737__$1;
(statearr_40740_40787[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (20))){
var inst_40685 = (state_40737[(8)]);
var inst_40646 = (state_40737[(9)]);
var inst_40647 = (state_40737[(10)]);
var inst_40645 = (state_40737[(11)]);
var inst_40690 = fluree.db.storage.core.read_block(inst_40645,inst_40646,inst_40647,inst_40685);
var state_40737__$1 = state_40737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40737__$1,(22),inst_40690);
} else {
if((state_val_40738 === (27))){
var inst_40726 = (state_40737[(12)]);
var inst_40721 = (state_40737[(13)]);
var inst_40724 = (state_40737[(2)]);
var inst_40725 = fluree.db.util.async.throw_err(inst_40724);
var inst_40726__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40721,cljs.core.cst$kw$schema,inst_40725);
var inst_40727 = fluree.db.query.schema.setting_map(inst_40726__$1);
var state_40737__$1 = (function (){var statearr_40741 = state_40737;
(statearr_40741[(12)] = inst_40726__$1);

return statearr_40741;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40737__$1,(28),inst_40727);
} else {
if((state_val_40738 === (1))){
var state_40737__$1 = state_40737;
var statearr_40742_40788 = state_40737__$1;
(statearr_40742_40788[(2)] = null);

(statearr_40742_40788[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (24))){
var inst_40685 = (state_40737[(8)]);
var inst_40646 = (state_40737[(9)]);
var inst_40647 = (state_40737[(10)]);
var inst_40707 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40685)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40646),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40647),"."].join('');
var inst_40708 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40709 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_40710 = cljs.core.PersistentHashMap.fromArrays(inst_40708,inst_40709);
var inst_40711 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40707,inst_40710);
var inst_40712 = (function(){throw inst_40711})();
var state_40737__$1 = state_40737;
var statearr_40743_40789 = state_40737__$1;
(statearr_40743_40789[(2)] = inst_40712);

(statearr_40743_40789[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (4))){
var inst_40634 = (state_40737[(2)]);
var inst_40635 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_40634);
var state_40737__$1 = state_40737;
var statearr_40744_40790 = state_40737__$1;
(statearr_40744_40790[(2)] = inst_40635);

(statearr_40744_40790[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (15))){
var state_40737__$1 = state_40737;
var statearr_40745_40791 = state_40737__$1;
(statearr_40745_40791[(2)] = null);

(statearr_40745_40791[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (21))){
var inst_40716 = (state_40737[(2)]);
var state_40737__$1 = state_40737;
var statearr_40746_40792 = state_40737__$1;
(statearr_40746_40792[(2)] = inst_40716);

(statearr_40746_40792[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (13))){
var inst_40654 = (state_40737[(7)]);
var inst_40679 = (state_40737[(14)]);
var inst_40678 = (state_40737[(2)]);
var inst_40679__$1 = fluree.db.util.async.throw_err(inst_40678);
var inst_40680 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_40654);
var state_40737__$1 = (function (){var statearr_40747 = state_40737;
(statearr_40747[(14)] = inst_40679__$1);

(statearr_40747[(15)] = inst_40680);

return statearr_40747;
})();
if(cljs.core.truth_(inst_40679__$1)){
var statearr_40748_40793 = state_40737__$1;
(statearr_40748_40793[(1)] = (14));

} else {
var statearr_40749_40794 = state_40737__$1;
(statearr_40749_40794[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (22))){
var inst_40693 = (state_40737[(16)]);
var inst_40692 = (state_40737[(2)]);
var inst_40693__$1 = fluree.db.util.async.throw_err(inst_40692);
var state_40737__$1 = (function (){var statearr_40750 = state_40737;
(statearr_40750[(16)] = inst_40693__$1);

return statearr_40750;
})();
if(cljs.core.truth_(inst_40693__$1)){
var statearr_40751_40795 = state_40737__$1;
(statearr_40751_40795[(1)] = (23));

} else {
var statearr_40752_40796 = state_40737__$1;
(statearr_40752_40796[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (6))){
var inst_40654 = (state_40737[(7)]);
var inst_40653 = (state_40737[(2)]);
var inst_40654__$1 = fluree.db.util.async.throw_err(inst_40653);
var inst_40655 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_40654__$1);
var inst_40656 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_40655);
var inst_40657 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_40656);
var state_40737__$1 = (function (){var statearr_40753 = state_40737;
(statearr_40753[(7)] = inst_40654__$1);

return statearr_40753;
})();
if(inst_40657){
var statearr_40754_40797 = state_40737__$1;
(statearr_40754_40797[(1)] = (7));

} else {
var statearr_40755_40798 = state_40737__$1;
(statearr_40755_40798[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (28))){
var inst_40726 = (state_40737[(12)]);
var inst_40729 = (state_40737[(2)]);
var inst_40730 = fluree.db.util.async.throw_err(inst_40729);
var inst_40731 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40726,cljs.core.cst$kw$settings,inst_40730);
var inst_40732 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_40731);
var _ = (function (){var statearr_40756 = state_40737;
(statearr_40756[(4)] = cljs.core.rest((state_40737[(4)])));

return statearr_40756;
})();
var state_40737__$1 = state_40737;
var statearr_40757_40799 = state_40737__$1;
(statearr_40757_40799[(2)] = inst_40732);

(statearr_40757_40799[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (25))){
var inst_40714 = (state_40737[(2)]);
var state_40737__$1 = state_40737;
var statearr_40758_40800 = state_40737__$1;
(statearr_40758_40800[(2)] = inst_40714);

(statearr_40758_40800[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (17))){
var inst_40685 = (state_40737[(8)]);
var inst_40680 = (state_40737[(15)]);
var inst_40687 = (inst_40685 > inst_40680);
var state_40737__$1 = state_40737;
if(cljs.core.truth_(inst_40687)){
var statearr_40759_40801 = state_40737__$1;
(statearr_40759_40801[(1)] = (19));

} else {
var statearr_40760_40802 = state_40737__$1;
(statearr_40760_40802[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (3))){
var inst_40735 = (state_40737[(2)]);
var state_40737__$1 = state_40737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40737__$1,inst_40735);
} else {
if((state_val_40738 === (12))){
var inst_40666 = (state_40737[(2)]);
var inst_40667 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40668 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_40669 = cljs.core.PersistentHashMap.fromArrays(inst_40667,inst_40668);
var inst_40670 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40666,inst_40669);
var inst_40671 = (function(){throw inst_40670})();
var state_40737__$1 = state_40737;
var statearr_40761_40803 = state_40737__$1;
(statearr_40761_40803[(2)] = inst_40671);

(statearr_40761_40803[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (2))){
var inst_40646 = (state_40737[(9)]);
var inst_40647 = (state_40737[(10)]);
var inst_40645 = (state_40737[(11)]);
var _ = (function (){var statearr_40762 = state_40737;
(statearr_40762[(4)] = cljs.core.cons((5),(state_40737[(4)])));

return statearr_40762;
})();
var inst_40642 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_40643 = session;
var inst_40644 = cljs.core.__destructure_map(inst_40643);
var inst_40645__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40644,cljs.core.cst$kw$conn);
var inst_40646__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40644,cljs.core.cst$kw$network);
var inst_40647__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40644,cljs.core.cst$kw$dbid);
var inst_40648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40649 = [inst_40646__$1,inst_40647__$1];
var inst_40650 = (new cljs.core.PersistentVector(null,2,(5),inst_40648,inst_40649,null));
var inst_40651 = fluree.db.operations.ledger_info_async(inst_40645__$1,inst_40650);
var state_40737__$1 = (function (){var statearr_40763 = state_40737;
(statearr_40763[(17)] = inst_40642);

(statearr_40763[(9)] = inst_40646__$1);

(statearr_40763[(10)] = inst_40647__$1);

(statearr_40763[(11)] = inst_40645__$1);

return statearr_40763;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40737__$1,(6),inst_40651);
} else {
if((state_val_40738 === (23))){
var inst_40693 = (state_40737[(16)]);
var inst_40684 = (state_40737[(18)]);
var inst_40696 = cljs.core.__destructure_map(inst_40693);
var inst_40697 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40696,cljs.core.cst$kw$flakes);
var inst_40698 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40696,cljs.core.cst$kw$block);
var inst_40699 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40696,cljs.core.cst$kw$t);
var inst_40700 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_40684,inst_40698,inst_40697);
var state_40737__$1 = (function (){var statearr_40764 = state_40737;
(statearr_40764[(19)] = inst_40699);

return statearr_40764;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40737__$1,(26),inst_40700);
} else {
if((state_val_40738 === (19))){
var inst_40684 = (state_40737[(18)]);
var state_40737__$1 = state_40737;
var statearr_40765_40804 = state_40737__$1;
(statearr_40765_40804[(2)] = inst_40684);

(statearr_40765_40804[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (11))){
var inst_40654 = (state_40737[(7)]);
var inst_40646 = (state_40737[(9)]);
var inst_40647 = (state_40737[(10)]);
var inst_40663 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_40654);
var inst_40664 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40646),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40647)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40663),"."].join('');
var state_40737__$1 = state_40737;
var statearr_40767_40805 = state_40737__$1;
(statearr_40767_40805[(2)] = inst_40664);

(statearr_40767_40805[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (9))){
var inst_40654 = (state_40737[(7)]);
var inst_40642 = (state_40737[(17)]);
var inst_40646 = (state_40737[(9)]);
var inst_40647 = (state_40737[(10)]);
var inst_40645 = (state_40737[(11)]);
var inst_40674 = (state_40737[(2)]);
var inst_40675 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_40654);
var inst_40676 = fluree.db.storage.core.reify_db(inst_40645,inst_40646,inst_40647,inst_40642,inst_40675);
var state_40737__$1 = (function (){var statearr_40768 = state_40737;
(statearr_40768[(20)] = inst_40674);

return statearr_40768;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40737__$1,(13),inst_40676);
} else {
if((state_val_40738 === (5))){
var _ = (function (){var statearr_40769 = state_40737;
(statearr_40769[(4)] = cljs.core.rest((state_40737[(4)])));

return statearr_40769;
})();
var state_40737__$1 = state_40737;
var ex40766 = (state_40737__$1[(2)]);
var statearr_40770_40806 = state_40737__$1;
(statearr_40770_40806[(5)] = ex40766);


var statearr_40771_40807 = state_40737__$1;
(statearr_40771_40807[(1)] = (4));

(statearr_40771_40807[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (14))){
var inst_40679 = (state_40737[(14)]);
var inst_40682 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_40679);
var inst_40683 = (inst_40682 + (1));
var inst_40684 = inst_40679;
var inst_40685 = inst_40683;
var state_40737__$1 = (function (){var statearr_40772 = state_40737;
(statearr_40772[(18)] = inst_40684);

(statearr_40772[(8)] = inst_40685);

return statearr_40772;
})();
var statearr_40773_40808 = state_40737__$1;
(statearr_40773_40808[(2)] = null);

(statearr_40773_40808[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (26))){
var inst_40685 = (state_40737[(8)]);
var inst_40702 = (state_40737[(2)]);
var inst_40703 = fluree.db.util.async.throw_err(inst_40702);
var inst_40704 = (inst_40685 + (1));
var inst_40684 = inst_40703;
var inst_40685__$1 = inst_40704;
var state_40737__$1 = (function (){var statearr_40774 = state_40737;
(statearr_40774[(18)] = inst_40684);

(statearr_40774[(8)] = inst_40685__$1);

return statearr_40774;
})();
var statearr_40775_40809 = state_40737__$1;
(statearr_40775_40809[(2)] = null);

(statearr_40775_40809[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (16))){
var inst_40721 = (state_40737[(13)]);
var inst_40721__$1 = (state_40737[(2)]);
var inst_40722 = fluree.db.query.schema.schema_map(inst_40721__$1);
var state_40737__$1 = (function (){var statearr_40776 = state_40737;
(statearr_40776[(13)] = inst_40721__$1);

return statearr_40776;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40737__$1,(27),inst_40722);
} else {
if((state_val_40738 === (10))){
var inst_40646 = (state_40737[(9)]);
var inst_40647 = (state_40737[(10)]);
var inst_40661 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40646),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40647)," is not found on this ledger group."].join('');
var state_40737__$1 = state_40737;
var statearr_40777_40810 = state_40737__$1;
(statearr_40777_40810[(2)] = inst_40661);

(statearr_40777_40810[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (18))){
var inst_40718 = (state_40737[(2)]);
var state_40737__$1 = state_40737;
var statearr_40778_40811 = state_40737__$1;
(statearr_40778_40811[(2)] = inst_40718);

(statearr_40778_40811[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40738 === (8))){
var state_40737__$1 = state_40737;
var statearr_40779_40812 = state_40737__$1;
(statearr_40779_40812[(2)] = null);

(statearr_40779_40812[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__13883__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__13883__auto____0 = (function (){
var statearr_40780 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40780[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__13883__auto__);

(statearr_40780[(1)] = (1));

return statearr_40780;
});
var fluree$db$session$full_load_existing_db_$_state_machine__13883__auto____1 = (function (state_40737){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40737);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40781){var ex__13886__auto__ = e40781;
var statearr_40782_40813 = state_40737;
(statearr_40782_40813[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40737[(4)]))){
var statearr_40783_40814 = state_40737;
(statearr_40783_40814[(1)] = cljs.core.first((state_40737[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40815 = state_40737;
state_40737 = G__40815;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__13883__auto__ = function(state_40737){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__13883__auto____1.call(this,state_40737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__13883__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__13883__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40784 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40784[(6)] = c__13957__auto___40785);

return statearr_40784;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__40816 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__40816,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__40816;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4160__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4149__auto__ = network;
if(cljs.core.truth_(and__4149__auto__)){
return maybe_alias;
} else {
return and__4149__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4654__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4655__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4656__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4657__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4658__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__40817 = cljs.core.get_global_hierarchy;
return (fexpr__40817.cljs$core$IFn$_invoke$arity$0 ? fexpr__40817.cljs$core$IFn$_invoke$arity$0() : fexpr__40817.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4658__auto__,method_table__4654__auto__,prefer_table__4655__auto__,method_cache__4656__auto__,cached_hierarchy__4657__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_ledger_DASH_update,(function (_,___$1,___$2){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40819){
var state_val_40820 = (state_40819[(1)]);
if((state_val_40820 === (1))){
var state_40819__$1 = state_40819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40819__$1,cljs.core.cst$kw$fluree$db$session_SLASH_no_DASH_op);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__13883__auto__ = null;
var fluree$db$session$state_machine__13883__auto____0 = (function (){
var statearr_40821 = [null,null,null,null,null,null,null];
(statearr_40821[(0)] = fluree$db$session$state_machine__13883__auto__);

(statearr_40821[(1)] = (1));

return statearr_40821;
});
var fluree$db$session$state_machine__13883__auto____1 = (function (state_40819){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40819);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40822){var ex__13886__auto__ = e40822;
var statearr_40823_40826 = state_40819;
(statearr_40823_40826[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40819[(4)]))){
var statearr_40824_40827 = state_40819;
(statearr_40824_40827[(1)] = cljs.core.first((state_40819[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40828 = state_40819;
state_40819 = G__40828;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$session$state_machine__13883__auto__ = function(state_40819){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__13883__auto____1.call(this,state_40819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__13883__auto____0;
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__13883__auto____1;
return fluree$db$session$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40825 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40825[(6)] = c__13957__auto__);

return statearr_40825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__40830){
var map__40831 = p__40830;
var map__40831__$1 = cljs.core.__destructure_map(map__40831);
var data = map__40831__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40831__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40831__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40831__$1,cljs.core.cst$kw$flakes);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40890){
var state_val_40891 = (state_40890[(1)]);
if((state_val_40891 === (7))){
var inst_40845 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_40846 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_40847 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40845),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40846),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_40848 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40847], 0));
var state_40890__$1 = state_40890;
var statearr_40892_40930 = state_40890__$1;
(statearr_40892_40930[(2)] = inst_40848);

(statearr_40892_40930[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (1))){
var state_40890__$1 = state_40890;
var statearr_40893_40931 = state_40890__$1;
(statearr_40893_40931[(2)] = null);

(statearr_40893_40931[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (4))){
var inst_40832 = (state_40890[(2)]);
var state_40890__$1 = state_40890;
var statearr_40894_40932 = state_40890__$1;
(statearr_40894_40932[(2)] = inst_40832);

(statearr_40894_40932[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (15))){
var inst_40871 = (state_40890[(2)]);
var state_40890__$1 = state_40890;
var statearr_40895_40933 = state_40890__$1;
(statearr_40895_40933[(2)] = inst_40871);

(statearr_40895_40933[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (13))){
var inst_40862 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var inst_40863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40864 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_40865 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_40866 = [inst_40864,inst_40865];
var inst_40867 = (new cljs.core.PersistentVector(null,2,(5),inst_40863,inst_40866,null));
var inst_40868 = (function (){var G__40896 = inst_40862;
var G__40897 = cljs.core.cst$kw$local_DASH_ledger_DASH_update;
var G__40898 = inst_40867;
var G__40899 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__40896,G__40897,G__40898,G__40899) : fluree.db.conn_events.process_event.call(null,G__40896,G__40897,G__40898,G__40899));
})();
var state_40890__$1 = state_40890;
var statearr_40900_40934 = state_40890__$1;
(statearr_40900_40934[(2)] = inst_40868);

(statearr_40900_40934[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (6))){
var inst_40841 = (state_40890[(7)]);
var inst_40842 = (state_40890[(8)]);
var inst_40840 = (state_40890[(2)]);
var inst_40841__$1 = fluree.db.util.async.throw_err(inst_40840);
var inst_40842__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_40841__$1);
var inst_40843 = (block <= inst_40842__$1);
var state_40890__$1 = (function (){var statearr_40901 = state_40890;
(statearr_40901[(7)] = inst_40841__$1);

(statearr_40901[(8)] = inst_40842__$1);

return statearr_40901;
})();
if(cljs.core.truth_(inst_40843)){
var statearr_40902_40935 = state_40890__$1;
(statearr_40902_40935[(1)] = (7));

} else {
var statearr_40903_40936 = state_40890__$1;
(statearr_40903_40936[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (17))){
var state_40890__$1 = state_40890;
var statearr_40904_40937 = state_40890__$1;
(statearr_40904_40937[(2)] = null);

(statearr_40904_40937[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (3))){
var inst_40888 = (state_40890[(2)]);
var state_40890__$1 = state_40890;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40890__$1,inst_40888);
} else {
if((state_val_40891 === (12))){
var inst_40883 = (state_40890[(2)]);
var state_40890__$1 = state_40890;
var statearr_40905_40938 = state_40890__$1;
(statearr_40905_40938[(2)] = inst_40883);

(statearr_40905_40938[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (2))){
var inst_40838 = (state_40890[(9)]);
var _ = (function (){var statearr_40906 = state_40890;
(statearr_40906[(4)] = cljs.core.cons((5),(state_40890[(4)])));

return statearr_40906;
})();
var inst_40838__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_40890__$1 = (function (){var statearr_40907 = state_40890;
(statearr_40907[(9)] = inst_40838__$1);

return statearr_40907;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40890__$1,(6),inst_40838__$1);
} else {
if((state_val_40891 === (11))){
var state_40890__$1 = state_40890;
var statearr_40909_40939 = state_40890__$1;
(statearr_40909_40939[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (9))){
var inst_40885 = (state_40890[(2)]);
var _ = (function (){var statearr_40911 = state_40890;
(statearr_40911[(4)] = cljs.core.rest((state_40890[(4)])));

return statearr_40911;
})();
var state_40890__$1 = state_40890;
var statearr_40912_40940 = state_40890__$1;
(statearr_40912_40940[(2)] = inst_40885);

(statearr_40912_40940[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (5))){
var _ = (function (){var statearr_40913 = state_40890;
(statearr_40913[(4)] = cljs.core.rest((state_40890[(4)])));

return statearr_40913;
})();
var state_40890__$1 = state_40890;
var ex40908 = (state_40890__$1[(2)]);
var statearr_40914_40941 = state_40890__$1;
(statearr_40914_40941[(5)] = ex40908);


if((ex40908 instanceof Error)){
var statearr_40915_40942 = state_40890__$1;
(statearr_40915_40942[(1)] = (4));

(statearr_40915_40942[(5)] = null);

} else {
throw ex40908;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (14))){
var state_40890__$1 = state_40890;
var statearr_40916_40943 = state_40890__$1;
(statearr_40916_40943[(2)] = null);

(statearr_40916_40943[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (16))){
var inst_40842 = (state_40890[(8)]);
var inst_40874 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_40875 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_40876 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40874),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40875),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40842),". Forcing a db reload."].join('');
var inst_40877 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40876], 0));
var inst_40878 = fluree.db.session.reload_db_BANG_(session);
var state_40890__$1 = (function (){var statearr_40917 = state_40890;
(statearr_40917[(10)] = inst_40877);

return statearr_40917;
})();
var statearr_40918_40944 = state_40890__$1;
(statearr_40918_40944[(2)] = inst_40878);

(statearr_40918_40944[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (10))){
var inst_40841 = (state_40890[(7)]);
var inst_40838 = (state_40890[(9)]);
var inst_40842 = (state_40890[(8)]);
var inst_40853 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_40854 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_40855 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40853),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40854),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_40856 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40855], 0));
var inst_40857 = (function (){var current_db_ch = inst_40838;
var current_db = inst_40841;
var current_block = inst_40842;
return (function (p1__40829_SHARP_){
if((p1__40829_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__40829_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__40829_SHARP_);
}
});
})();
var inst_40858 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_40857,flakes);
var inst_40859 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_40841,block,inst_40858);
var inst_40860 = fluree.db.session.cas_db_BANG_(session,inst_40838,inst_40859);
var state_40890__$1 = (function (){var statearr_40919 = state_40890;
(statearr_40919[(11)] = inst_40856);

return statearr_40919;
})();
if(inst_40860){
var statearr_40920_40945 = state_40890__$1;
(statearr_40920_40945[(1)] = (13));

} else {
var statearr_40921_40946 = state_40890__$1;
(statearr_40921_40946[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (18))){
var inst_40881 = (state_40890[(2)]);
var state_40890__$1 = state_40890;
var statearr_40922_40947 = state_40890__$1;
(statearr_40922_40947[(2)] = inst_40881);

(statearr_40922_40947[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40891 === (8))){
var inst_40842 = (state_40890[(8)]);
var inst_40850 = ((1) + inst_40842);
var inst_40851 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_40850);
var state_40890__$1 = state_40890;
if(inst_40851){
var statearr_40923_40948 = state_40890__$1;
(statearr_40923_40948[(1)] = (10));

} else {
var statearr_40924_40949 = state_40890__$1;
(statearr_40924_40949[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__13883__auto__ = null;
var fluree$db$session$state_machine__13883__auto____0 = (function (){
var statearr_40925 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40925[(0)] = fluree$db$session$state_machine__13883__auto__);

(statearr_40925[(1)] = (1));

return statearr_40925;
});
var fluree$db$session$state_machine__13883__auto____1 = (function (state_40890){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40890);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40926){var ex__13886__auto__ = e40926;
var statearr_40927_40950 = state_40890;
(statearr_40927_40950[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40890[(4)]))){
var statearr_40928_40951 = state_40890;
(statearr_40928_40951[(1)] = cljs.core.first((state_40890[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40952 = state_40890;
state_40890 = G__40952;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$session$state_machine__13883__auto__ = function(state_40890){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__13883__auto____1.call(this,state_40890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__13883__auto____0;
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__13883__auto____1;
return fluree$db$session$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40929 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40929[(6)] = c__13957__auto__);

return statearr_40929;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40959){
var state_val_40960 = (state_40959[(1)]);
if((state_val_40960 === (1))){
var inst_40953 = fluree.db.session.clear_db_BANG_(session);
var inst_40954 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_40955 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_40956 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40954),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40955)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_40957 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40956], 0));
var state_40959__$1 = (function (){var statearr_40961 = state_40959;
(statearr_40961[(7)] = inst_40957);

(statearr_40961[(8)] = inst_40953);

return statearr_40961;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_40959__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__13883__auto__ = null;
var fluree$db$session$state_machine__13883__auto____0 = (function (){
var statearr_40962 = [null,null,null,null,null,null,null,null,null];
(statearr_40962[(0)] = fluree$db$session$state_machine__13883__auto__);

(statearr_40962[(1)] = (1));

return statearr_40962;
});
var fluree$db$session$state_machine__13883__auto____1 = (function (state_40959){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40959);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40963){var ex__13886__auto__ = e40963;
var statearr_40964_40967 = state_40959;
(statearr_40964_40967[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40959[(4)]))){
var statearr_40965_40968 = state_40959;
(statearr_40965_40968[(1)] = cljs.core.first((state_40959[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40969 = state_40959;
state_40959 = G__40969;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$session$state_machine__13883__auto__ = function(state_40959){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__13883__auto____1.call(this,state_40959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__13883__auto____0;
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__13883__auto____1;
return fluree$db$session$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40966 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40966[(6)] = c__13957__auto__);

return statearr_40966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__40971 = arguments.length;
switch (G__40971) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__40972 = session;
var map__40972__$1 = cljs.core.__destructure_map(map__40972);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40972__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40972__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40972__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40972__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40972__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40972__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40972__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__40973_40976 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__40973_40976.cljs$core$IFn$_invoke$arity$3 ? fexpr__40973_40976.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__40973_40976.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__40974_40977 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__40974_40977.cljs$core$IFn$_invoke$arity$0 ? fexpr__40974_40977.cljs$core$IFn$_invoke$arity$0() : fexpr__40974_40977.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_41030){
var state_val_41031 = (state_41030[(1)]);
if((state_val_41031 === (7))){
var inst_41026 = (state_41030[(2)]);
var state_41030__$1 = state_41030;
var statearr_41032_41063 = state_41030__$1;
(statearr_41032_41063[(2)] = inst_41026);

(statearr_41032_41063[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (1))){
var state_41030__$1 = state_41030;
var statearr_41033_41064 = state_41030__$1;
(statearr_41033_41064[(2)] = null);

(statearr_41033_41064[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (4))){
var inst_40981 = (state_41030[(7)]);
var inst_40980 = (state_41030[(2)]);
var inst_40981__$1 = fluree.db.util.async.throw_err(inst_40980);
var inst_40982 = fluree.db.session.from_cache(network,ledger_id);
var inst_40983 = (inst_40981__$1 == null);
var state_41030__$1 = (function (){var statearr_41034 = state_41030;
(statearr_41034[(8)] = inst_40982);

(statearr_41034[(7)] = inst_40981__$1);

return statearr_41034;
})();
if(cljs.core.truth_(inst_40983)){
var statearr_41035_41065 = state_41030__$1;
(statearr_41035_41065[(1)] = (5));

} else {
var statearr_41036_41066 = state_41030__$1;
(statearr_41036_41066[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (15))){
var inst_41018 = (state_41030[(2)]);
var state_41030__$1 = (function (){var statearr_41037 = state_41030;
(statearr_41037[(9)] = inst_41018);

return statearr_41037;
})();
var statearr_41038_41067 = state_41030__$1;
(statearr_41038_41067[(2)] = null);

(statearr_41038_41067[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (13))){
var inst_41022 = (state_41030[(2)]);
var state_41030__$1 = state_41030;
var statearr_41040_41068 = state_41030__$1;
(statearr_41040_41068[(2)] = inst_41022);

(statearr_41040_41068[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (6))){
var inst_40982 = (state_41030[(8)]);
var inst_40988 = (inst_40982 == null);
var state_41030__$1 = state_41030;
if(cljs.core.truth_(inst_40988)){
var statearr_41041_41069 = state_41030__$1;
(statearr_41041_41069[(1)] = (8));

} else {
var statearr_41042_41070 = state_41030__$1;
(statearr_41042_41070[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (17))){
var _ = (function (){var statearr_41043 = state_41030;
(statearr_41043[(4)] = cljs.core.rest((state_41030[(4)])));

return statearr_41043;
})();
var state_41030__$1 = state_41030;
var ex41039 = (state_41030__$1[(2)]);
var statearr_41044_41071 = state_41030__$1;
(statearr_41044_41071[(5)] = ex41039);


var statearr_41045_41072 = state_41030__$1;
(statearr_41045_41072[(1)] = (16));

(statearr_41045_41072[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (3))){
var inst_41028 = (state_41030[(2)]);
var state_41030__$1 = state_41030;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41030__$1,inst_41028);
} else {
if((state_val_41031 === (12))){
var state_41030__$1 = state_41030;
var statearr_41046_41073 = state_41030__$1;
(statearr_41046_41073[(2)] = null);

(statearr_41046_41073[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (2))){
var state_41030__$1 = state_41030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41030__$1,(4),update_chan);
} else {
if((state_val_41031 === (11))){
var state_41030__$1 = state_41030;
var statearr_41047_41074 = state_41030__$1;
(statearr_41047_41074[(2)] = null);

(statearr_41047_41074[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (9))){
var state_41030__$1 = state_41030;
var statearr_41048_41075 = state_41030__$1;
(statearr_41048_41075[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (5))){
var inst_40985 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_40986 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40985], 0));
var state_41030__$1 = state_41030;
var statearr_41050_41076 = state_41030__$1;
(statearr_41050_41076[(2)] = inst_40986);

(statearr_41050_41076[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (14))){
var inst_40982 = (state_41030[(8)]);
var inst_40981 = (state_41030[(7)]);
var _ = (function (){var statearr_41051 = state_41030;
(statearr_41051[(4)] = cljs.core.cons((17),(state_41030[(4)])));

return statearr_41051;
})();
var inst_41006 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40981,(0),null);
var inst_41007 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40981,(1),null);
var inst_41008 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_41009 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40981], 0));
var inst_41010 = fluree.db.util.core.trunc(inst_41009,(200));
var inst_41011 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41008,inst_41010], 0));
var inst_41012 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_40982,inst_41006,inst_41007) : fluree.db.session.process_ledger_update.call(null,inst_40982,inst_41006,inst_41007));
var state_41030__$1 = (function (){var statearr_41052 = state_41030;
(statearr_41052[(10)] = inst_41011);

return statearr_41052;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41030__$1,(18),inst_41012);
} else {
if((state_val_41031 === (16))){
var inst_40981 = (state_41030[(7)]);
var inst_40996 = (state_41030[(2)]);
var inst_40997 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40996,"Exception processing ledger updates for message: ",inst_40981], 0));
var state_41030__$1 = state_41030;
var statearr_41053_41077 = state_41030__$1;
(statearr_41053_41077[(2)] = inst_40997);

(statearr_41053_41077[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (10))){
var inst_41024 = (state_41030[(2)]);
var state_41030__$1 = state_41030;
var statearr_41054_41078 = state_41030__$1;
(statearr_41054_41078[(2)] = inst_41024);

(statearr_41054_41078[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (18))){
var inst_41014 = (state_41030[(2)]);
var inst_41015 = fluree.db.util.async.throw_err(inst_41014);
var _ = (function (){var statearr_41055 = state_41030;
(statearr_41055[(4)] = cljs.core.rest((state_41030[(4)])));

return statearr_41055;
})();
var state_41030__$1 = state_41030;
var statearr_41056_41079 = state_41030__$1;
(statearr_41056_41079[(2)] = inst_41015);

(statearr_41056_41079[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41031 === (8))){
var inst_40981 = (state_41030[(7)]);
var inst_40990 = cljs.core.first(inst_40981);
var inst_40991 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40990], 0));
var inst_40992 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_40991].join('');
var inst_40993 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40992], 0));
var state_41030__$1 = state_41030;
var statearr_41057_41080 = state_41030__$1;
(statearr_41057_41080[(2)] = inst_40993);

(statearr_41057_41080[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__13883__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__13883__auto____0 = (function (){
var statearr_41058 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_41058[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__13883__auto__);

(statearr_41058[(1)] = (1));

return statearr_41058;
});
var fluree$db$session$process_ledger_updates_$_state_machine__13883__auto____1 = (function (state_41030){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_41030);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e41059){var ex__13886__auto__ = e41059;
var statearr_41060_41081 = state_41030;
(statearr_41060_41081[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_41030[(4)]))){
var statearr_41061_41082 = state_41030;
(statearr_41061_41082[(1)] = cljs.core.first((state_41030[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__41083 = state_41030;
state_41030 = G__41083;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__13883__auto__ = function(state_41030){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__13883__auto____1.call(this,state_41030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__13883__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__13883__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_41062 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_41062[(6)] = c__13957__auto__);

return statearr_41062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__41084){
var map__41085 = p__41084;
var map__41085__$1 = cljs.core.__destructure_map(map__41085);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41085__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41085__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41085__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41085__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41085__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41085__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41085__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41085__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41085__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__41089 = block_result;
var map__41089__$1 = cljs.core.__destructure_map(map__41089);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41089__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41089__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41089__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41089__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41089__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__41090 = tx_result;
var map__41090__$1 = cljs.core.__destructure_map(map__41090);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41090__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41090__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__41086_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__41086_SHARP_.t);
}):(function (p1__41087_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__41087_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__41088_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__41088_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__41088_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__41091 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41091,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41091,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41091,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41091,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4160__auto__ = message;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__41095 = arguments.length;
switch (G__41095) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__41096){
var map__41097 = p__41096;
var map__41097__$1 = cljs.core.__destructure_map(map__41097);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41097__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41097__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41097__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41097__$1,cljs.core.cst$kw$jwt);
var vec__41098 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41098,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41098,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41098,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4160__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4160__auto____$1 = state;
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__41102_41222 = network;
var G__41103_41223 = ledger_id;
var G__41104_41224 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__41105_41225 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__41106 = cljs.core.seq(tids);
var chunk__41107 = null;
var count__41108 = (0);
var i__41109 = (0);
while(true){
if((i__41109 < count__41108)){
var tid = chunk__41107.cljs$core$IIndexed$_nth$arity$2(null,i__41109);
var temp__5753__auto___41227__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___41227__$1)){
var keyed_callbacks_41228 = temp__5753__auto___41227__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_41229 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__41150_41230 = cljs.core.seq(keyed_callbacks_41228);
var chunk__41151_41231 = null;
var count__41152_41232 = (0);
var i__41153_41233 = (0);
while(true){
if((i__41153_41233 < count__41152_41232)){
var vec__41162_41234 = chunk__41151_41231.cljs$core$IIndexed$_nth$arity$2(null,i__41153_41233);
var k_41235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41162_41234,(0),null);
var f_41236 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41162_41234,(1),null);
try{(f_41236.cljs$core$IFn$_invoke$arity$1 ? f_41236.cljs$core$IFn$_invoke$arity$1(tx_response_41229) : f_41236.call(null,tx_response_41229));
}catch (e41165){var e_41237 = e41165;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_41237,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__41238 = seq__41150_41230;
var G__41239 = chunk__41151_41231;
var G__41240 = count__41152_41232;
var G__41241 = (i__41153_41233 + (1));
seq__41150_41230 = G__41238;
chunk__41151_41231 = G__41239;
count__41152_41232 = G__41240;
i__41153_41233 = G__41241;
continue;
} else {
var temp__5753__auto___41242__$2 = cljs.core.seq(seq__41150_41230);
if(temp__5753__auto___41242__$2){
var seq__41150_41243__$1 = temp__5753__auto___41242__$2;
if(cljs.core.chunked_seq_QMARK_(seq__41150_41243__$1)){
var c__4591__auto___41244 = cljs.core.chunk_first(seq__41150_41243__$1);
var G__41245 = cljs.core.chunk_rest(seq__41150_41243__$1);
var G__41246 = c__4591__auto___41244;
var G__41247 = cljs.core.count(c__4591__auto___41244);
var G__41248 = (0);
seq__41150_41230 = G__41245;
chunk__41151_41231 = G__41246;
count__41152_41232 = G__41247;
i__41153_41233 = G__41248;
continue;
} else {
var vec__41166_41249 = cljs.core.first(seq__41150_41243__$1);
var k_41250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41166_41249,(0),null);
var f_41251 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41166_41249,(1),null);
try{(f_41251.cljs$core$IFn$_invoke$arity$1 ? f_41251.cljs$core$IFn$_invoke$arity$1(tx_response_41229) : f_41251.call(null,tx_response_41229));
}catch (e41169){var e_41252 = e41169;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_41252,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__41253 = cljs.core.next(seq__41150_41243__$1);
var G__41254 = null;
var G__41255 = (0);
var G__41256 = (0);
seq__41150_41230 = G__41253;
chunk__41151_41231 = G__41254;
count__41152_41232 = G__41255;
i__41153_41233 = G__41256;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__41257 = seq__41106;
var G__41258 = chunk__41107;
var G__41259 = count__41108;
var G__41260 = (i__41109 + (1));
seq__41106 = G__41257;
chunk__41107 = G__41258;
count__41108 = G__41259;
i__41109 = G__41260;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__41106);
if(temp__5753__auto____$1){
var seq__41106__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__41106__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__41106__$1);
var G__41261 = cljs.core.chunk_rest(seq__41106__$1);
var G__41262 = c__4591__auto__;
var G__41263 = cljs.core.count(c__4591__auto__);
var G__41264 = (0);
seq__41106 = G__41261;
chunk__41107 = G__41262;
count__41108 = G__41263;
i__41109 = G__41264;
continue;
} else {
var tid = cljs.core.first(seq__41106__$1);
var temp__5753__auto___41265__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___41265__$2)){
var keyed_callbacks_41266 = temp__5753__auto___41265__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_41267 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__41170_41268 = cljs.core.seq(keyed_callbacks_41266);
var chunk__41171_41269 = null;
var count__41172_41270 = (0);
var i__41173_41271 = (0);
while(true){
if((i__41173_41271 < count__41172_41270)){
var vec__41182_41272 = chunk__41171_41269.cljs$core$IIndexed$_nth$arity$2(null,i__41173_41271);
var k_41273 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41182_41272,(0),null);
var f_41274 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41182_41272,(1),null);
try{(f_41274.cljs$core$IFn$_invoke$arity$1 ? f_41274.cljs$core$IFn$_invoke$arity$1(tx_response_41267) : f_41274.call(null,tx_response_41267));
}catch (e41185){var e_41275 = e41185;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_41275,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__41276 = seq__41170_41268;
var G__41277 = chunk__41171_41269;
var G__41278 = count__41172_41270;
var G__41279 = (i__41173_41271 + (1));
seq__41170_41268 = G__41276;
chunk__41171_41269 = G__41277;
count__41172_41270 = G__41278;
i__41173_41271 = G__41279;
continue;
} else {
var temp__5753__auto___41280__$3 = cljs.core.seq(seq__41170_41268);
if(temp__5753__auto___41280__$3){
var seq__41170_41281__$1 = temp__5753__auto___41280__$3;
if(cljs.core.chunked_seq_QMARK_(seq__41170_41281__$1)){
var c__4591__auto___41282 = cljs.core.chunk_first(seq__41170_41281__$1);
var G__41283 = cljs.core.chunk_rest(seq__41170_41281__$1);
var G__41284 = c__4591__auto___41282;
var G__41285 = cljs.core.count(c__4591__auto___41282);
var G__41286 = (0);
seq__41170_41268 = G__41283;
chunk__41171_41269 = G__41284;
count__41172_41270 = G__41285;
i__41173_41271 = G__41286;
continue;
} else {
var vec__41186_41287 = cljs.core.first(seq__41170_41281__$1);
var k_41288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41186_41287,(0),null);
var f_41289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41186_41287,(1),null);
try{(f_41289.cljs$core$IFn$_invoke$arity$1 ? f_41289.cljs$core$IFn$_invoke$arity$1(tx_response_41267) : f_41289.call(null,tx_response_41267));
}catch (e41189){var e_41290 = e41189;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_41290,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__41291 = cljs.core.next(seq__41170_41281__$1);
var G__41292 = null;
var G__41293 = (0);
var G__41294 = (0);
seq__41170_41268 = G__41291;
chunk__41171_41269 = G__41292;
count__41172_41270 = G__41293;
i__41173_41271 = G__41294;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__41295 = cljs.core.next(seq__41106__$1);
var G__41296 = null;
var G__41297 = (0);
var G__41298 = (0);
seq__41106 = G__41295;
chunk__41107 = G__41296;
count__41108 = G__41297;
i__41109 = G__41298;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__41101_41226 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__41101_41226.cljs$core$IFn$_invoke$arity$4 ? fexpr__41101_41226.cljs$core$IFn$_invoke$arity$4(G__41102_41222,G__41103_41223,G__41104_41224,G__41105_41225) : fexpr__41101_41226.call(null,G__41102_41222,G__41103_41223,G__41104_41224,G__41105_41225));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_41299 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__13957__auto___41300 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_41206){
var state_val_41207 = (state_41206[(1)]);
if((state_val_41207 === (1))){
var state_41206__$1 = state_41206;
var statearr_41208_41301 = state_41206__$1;
(statearr_41208_41301[(2)] = null);

(statearr_41208_41301[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41207 === (2))){
var inst_41191 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_41206__$1 = state_41206;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41206__$1,(4),inst_41191);
} else {
if((state_val_41207 === (3))){
var inst_41204 = (state_41206[(2)]);
var state_41206__$1 = state_41206;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41206__$1,inst_41204);
} else {
if((state_val_41207 === (4))){
var inst_41193 = (state_41206[(7)]);
var inst_41193__$1 = (state_41206[(2)]);
var inst_41194 = (inst_41193__$1 == null);
var state_41206__$1 = (function (){var statearr_41209 = state_41206;
(statearr_41209[(7)] = inst_41193__$1);

return statearr_41209;
})();
if(cljs.core.truth_(inst_41194)){
var statearr_41210_41302 = state_41206__$1;
(statearr_41210_41302[(1)] = (5));

} else {
var statearr_41211_41303 = state_41206__$1;
(statearr_41211_41303[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41207 === (5))){
var inst_41196 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_41197 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41196], 0));
var state_41206__$1 = state_41206;
var statearr_41212_41304 = state_41206__$1;
(statearr_41212_41304[(2)] = inst_41197);

(statearr_41212_41304[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41207 === (6))){
var inst_41193 = (state_41206[(7)]);
var inst_41199 = (transact_handler_41299.cljs$core$IFn$_invoke$arity$2 ? transact_handler_41299.cljs$core$IFn$_invoke$arity$2(conn,inst_41193) : transact_handler_41299.call(null,conn,inst_41193));
var state_41206__$1 = (function (){var statearr_41213 = state_41206;
(statearr_41213[(8)] = inst_41199);

return statearr_41213;
})();
var statearr_41214_41305 = state_41206__$1;
(statearr_41214_41305[(2)] = null);

(statearr_41214_41305[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41207 === (7))){
var inst_41202 = (state_41206[(2)]);
var state_41206__$1 = state_41206;
var statearr_41215_41306 = state_41206__$1;
(statearr_41215_41306[(2)] = inst_41202);

(statearr_41215_41306[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__13883__auto__ = null;
var fluree$db$session$state_machine__13883__auto____0 = (function (){
var statearr_41216 = [null,null,null,null,null,null,null,null,null];
(statearr_41216[(0)] = fluree$db$session$state_machine__13883__auto__);

(statearr_41216[(1)] = (1));

return statearr_41216;
});
var fluree$db$session$state_machine__13883__auto____1 = (function (state_41206){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_41206);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e41217){var ex__13886__auto__ = e41217;
var statearr_41218_41307 = state_41206;
(statearr_41218_41307[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_41206[(4)]))){
var statearr_41219_41308 = state_41206;
(statearr_41219_41308[(1)] = cljs.core.first((state_41206[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__41309 = state_41206;
state_41206 = G__41309;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$session$state_machine__13883__auto__ = function(state_41206){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__13883__auto____1.call(this,state_41206);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__13883__auto____0;
fluree$db$session$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__13883__auto____1;
return fluree$db$session$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_41220 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_41220[(6)] = c__13957__auto___41300);

return statearr_41220;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__41310_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__41310_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__41310_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__41311_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__41311_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
}));

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__41314 = arguments.length;
switch (G__41314) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__41315 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__41312_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__41312_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__41315);
} else {
return G__41315;
}
})();
var seq__41316 = cljs.core.seq(sessions);
var chunk__41317 = null;
var count__41318 = (0);
var i__41319 = (0);
while(true){
if((i__41319 < count__41318)){
var session = chunk__41317.cljs$core$IIndexed$_nth$arity$2(null,i__41319);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__41321 = seq__41316;
var G__41322 = chunk__41317;
var G__41323 = count__41318;
var G__41324 = (i__41319 + (1));
seq__41316 = G__41321;
chunk__41317 = G__41322;
count__41318 = G__41323;
i__41319 = G__41324;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__41316);
if(temp__5753__auto__){
var seq__41316__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__41316__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__41316__$1);
var G__41325 = cljs.core.chunk_rest(seq__41316__$1);
var G__41326 = c__4591__auto__;
var G__41327 = cljs.core.count(c__4591__auto__);
var G__41328 = (0);
seq__41316 = G__41325;
chunk__41317 = G__41326;
count__41318 = G__41327;
i__41319 = G__41328;
continue;
} else {
var session = cljs.core.first(seq__41316__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__41329 = cljs.core.next(seq__41316__$1);
var G__41330 = null;
var G__41331 = (0);
var G__41332 = (0);
seq__41316 = G__41329;
chunk__41317 = G__41330;
count__41318 = G__41331;
i__41319 = G__41332;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
