// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_29498){
var state_val_29499 = (state_29498[(1)]);
if((state_val_29499 === (1))){
var state_29498__$1 = state_29498;
var statearr_29500_29514 = state_29498__$1;
(statearr_29500_29514[(2)] = null);

(statearr_29500_29514[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29499 === (2))){
var _ = (function (){var statearr_29501 = state_29498;
(statearr_29501[(4)] = cljs.core.cons((5),(state_29498[(4)])));

return statearr_29501;
})();
var inst_29489 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_29498__$1 = state_29498;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29498__$1,(6),inst_29489);
} else {
if((state_val_29499 === (3))){
var inst_29496 = (state_29498[(2)]);
var state_29498__$1 = state_29498;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29498__$1,inst_29496);
} else {
if((state_val_29499 === (4))){
var inst_29483 = (state_29498[(2)]);
var state_29498__$1 = state_29498;
var statearr_29503_29515 = state_29498__$1;
(statearr_29503_29515[(2)] = inst_29483);

(statearr_29503_29515[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29499 === (5))){
var _ = (function (){var statearr_29504 = state_29498;
(statearr_29504[(4)] = cljs.core.rest((state_29498[(4)])));

return statearr_29504;
})();
var state_29498__$1 = state_29498;
var ex29502 = (state_29498__$1[(2)]);
var statearr_29505_29516 = state_29498__$1;
(statearr_29505_29516[(5)] = ex29502);


if((ex29502 instanceof Error)){
var statearr_29506_29517 = state_29498__$1;
(statearr_29506_29517[(1)] = (4));

(statearr_29506_29517[(5)] = null);

} else {
throw ex29502;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29499 === (6))){
var inst_29491 = (state_29498[(2)]);
var inst_29492 = fluree.db.util.async.throw_err(inst_29491);
var inst_29493 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_29492);
var _ = (function (){var statearr_29507 = state_29498;
(statearr_29507[(4)] = cljs.core.rest((state_29498[(4)])));

return statearr_29507;
})();
var state_29498__$1 = state_29498;
var statearr_29508_29518 = state_29498__$1;
(statearr_29508_29518[(2)] = inst_29493);

(statearr_29508_29518[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto____0 = (function (){
var statearr_29509 = [null,null,null,null,null,null,null];
(statearr_29509[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto__);

(statearr_29509[(1)] = (1));

return statearr_29509;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto____1 = (function (state_29498){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_29498);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e29510){var ex__13886__auto__ = e29510;
var statearr_29511_29519 = state_29498;
(statearr_29511_29519[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_29498[(4)]))){
var statearr_29512_29520 = state_29498;
(statearr_29512_29520[(1)] = cljs.core.first((state_29498[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__29521 = state_29498;
state_29498 = G__29521;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto__ = function(state_29498){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto____1.call(this,state_29498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_29513 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_29513[(6)] = c__13957__auto__);

return statearr_29513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_29553){
var state_val_29554 = (state_29553[(1)]);
if((state_val_29554 === (7))){
var inst_29537 = (state_29553[(7)]);
var inst_29539 = cljs.core.empty_QMARK_(inst_29537);
var inst_29540 = (!(inst_29539));
var state_29553__$1 = state_29553;
var statearr_29555_29579 = state_29553__$1;
(statearr_29555_29579[(2)] = inst_29540);

(statearr_29555_29579[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29554 === (1))){
var state_29553__$1 = state_29553;
var statearr_29556_29580 = state_29553__$1;
(statearr_29556_29580[(2)] = null);

(statearr_29556_29580[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29554 === (4))){
var inst_29523 = (state_29553[(2)]);
var state_29553__$1 = state_29553;
var statearr_29557_29581 = state_29553__$1;
(statearr_29557_29581[(2)] = inst_29523);

(statearr_29557_29581[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29554 === (6))){
var inst_29529 = (state_29553[(8)]);
var inst_29537 = (state_29553[(7)]);
var inst_29535 = (state_29553[(2)]);
var inst_29536 = fluree.db.util.async.throw_err(inst_29535);
var inst_29537__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_29529,inst_29536);
var state_29553__$1 = (function (){var statearr_29558 = state_29553;
(statearr_29558[(7)] = inst_29537__$1);

return statearr_29558;
})();
if(cljs.core.truth_(inst_29537__$1)){
var statearr_29559_29582 = state_29553__$1;
(statearr_29559_29582[(1)] = (7));

} else {
var statearr_29560_29583 = state_29553__$1;
(statearr_29560_29583[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29554 === (3))){
var inst_29551 = (state_29553[(2)]);
var state_29553__$1 = state_29553;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29553__$1,inst_29551);
} else {
if((state_val_29554 === (12))){
var inst_29548 = (state_29553[(2)]);
var _ = (function (){var statearr_29561 = state_29553;
(statearr_29561[(4)] = cljs.core.rest((state_29553[(4)])));

return statearr_29561;
})();
var state_29553__$1 = state_29553;
var statearr_29562_29584 = state_29553__$1;
(statearr_29562_29584[(2)] = inst_29548);

(statearr_29562_29584[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29554 === (2))){
var _ = (function (){var statearr_29563 = state_29553;
(statearr_29563[(4)] = cljs.core.cons((5),(state_29553[(4)])));

return statearr_29563;
})();
var inst_29529 = (function (){return (function (p1__29522_SHARP_){
return p1__29522_SHARP_.o;
});
})();
var inst_29530 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29531 = [pred_id];
var inst_29532 = (new cljs.core.PersistentVector(null,1,(5),inst_29530,inst_29531,null));
var inst_29533 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_29532);
var state_29553__$1 = (function (){var statearr_29564 = state_29553;
(statearr_29564[(8)] = inst_29529);

return statearr_29564;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29553__$1,(6),inst_29533);
} else {
if((state_val_29554 === (11))){
var state_29553__$1 = state_29553;
var statearr_29566_29585 = state_29553__$1;
(statearr_29566_29585[(2)] = true);

(statearr_29566_29585[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29554 === (9))){
var inst_29543 = (state_29553[(2)]);
var state_29553__$1 = state_29553;
if(cljs.core.truth_(inst_29543)){
var statearr_29567_29586 = state_29553__$1;
(statearr_29567_29586[(1)] = (10));

} else {
var statearr_29568_29587 = state_29553__$1;
(statearr_29568_29587[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29554 === (5))){
var _ = (function (){var statearr_29569 = state_29553;
(statearr_29569[(4)] = cljs.core.rest((state_29553[(4)])));

return statearr_29569;
})();
var state_29553__$1 = state_29553;
var ex29565 = (state_29553__$1[(2)]);
var statearr_29570_29588 = state_29553__$1;
(statearr_29570_29588[(5)] = ex29565);


if((ex29565 instanceof Error)){
var statearr_29571_29589 = state_29553__$1;
(statearr_29571_29589[(1)] = (4));

(statearr_29571_29589[(5)] = null);

} else {
throw ex29565;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29554 === (10))){
var inst_29537 = (state_29553[(7)]);
var inst_29545 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_29537);
var state_29553__$1 = state_29553;
var statearr_29572_29590 = state_29553__$1;
(statearr_29572_29590[(2)] = inst_29545);

(statearr_29572_29590[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29554 === (8))){
var inst_29537 = (state_29553[(7)]);
var state_29553__$1 = state_29553;
var statearr_29573_29591 = state_29553__$1;
(statearr_29573_29591[(2)] = inst_29537);

(statearr_29573_29591[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto____0 = (function (){
var statearr_29574 = [null,null,null,null,null,null,null,null,null];
(statearr_29574[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto__);

(statearr_29574[(1)] = (1));

return statearr_29574;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto____1 = (function (state_29553){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_29553);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e29575){var ex__13886__auto__ = e29575;
var statearr_29576_29592 = state_29553;
(statearr_29576_29592[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_29553[(4)]))){
var statearr_29577_29593 = state_29553;
(statearr_29577_29593[(1)] = cljs.core.first((state_29553[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__29594 = state_29553;
state_29553 = G__29594;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto__ = function(state_29553){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto____1.call(this,state_29553);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_29578 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_29578[(6)] = c__13957__auto__);

return statearr_29578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_29675){
var state_val_29676 = (state_29675[(1)]);
if((state_val_29676 === (7))){
var state_29675__$1 = state_29675;
var statearr_29677_29715 = state_29675__$1;
(statearr_29677_29715[(2)] = flakes);

(statearr_29677_29715[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (20))){
var inst_29632 = (state_29675[(7)]);
var inst_29665 = (state_29675[(2)]);
var inst_29624 = inst_29632;
var inst_29625 = inst_29665;
var state_29675__$1 = (function (){var statearr_29678 = state_29675;
(statearr_29678[(8)] = inst_29624);

(statearr_29678[(9)] = inst_29625);

return statearr_29678;
})();
var statearr_29679_29716 = state_29675__$1;
(statearr_29679_29716[(2)] = null);

(statearr_29679_29716[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (1))){
var state_29675__$1 = state_29675;
var statearr_29680_29717 = state_29675__$1;
(statearr_29680_29717[(2)] = null);

(statearr_29680_29717[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (4))){
var inst_29597 = (state_29675[(2)]);
var state_29675__$1 = state_29675;
var statearr_29681_29718 = state_29675__$1;
(statearr_29681_29718[(2)] = inst_29597);

(statearr_29681_29718[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (15))){
var inst_29631 = (state_29675[(10)]);
var inst_29649 = inst_29631.o;
var state_29675__$1 = state_29675;
var statearr_29682_29719 = state_29675__$1;
(statearr_29682_29719[(2)] = inst_29649);

(statearr_29682_29719[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (13))){
var inst_29668 = (state_29675[(2)]);
var state_29675__$1 = state_29675;
var statearr_29683_29720 = state_29675__$1;
(statearr_29683_29720[(2)] = inst_29668);

(statearr_29683_29720[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (6))){
var inst_29604 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_29675__$1 = state_29675;
var statearr_29684_29721 = state_29675__$1;
(statearr_29684_29721[(2)] = inst_29604);

(statearr_29684_29721[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (17))){
var inst_29646 = (state_29675[(2)]);
var inst_29647 = fluree.db.util.async.throw_err(inst_29646);
var state_29675__$1 = state_29675;
var statearr_29685_29722 = state_29675__$1;
(statearr_29685_29722[(2)] = inst_29647);

(statearr_29685_29722[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (3))){
var inst_29673 = (state_29675[(2)]);
var state_29675__$1 = state_29675;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29675__$1,inst_29673);
} else {
if((state_val_29676 === (12))){
var inst_29638 = (state_29675[(11)]);
var inst_29631 = (state_29675[(10)]);
var inst_29636 = inst_29631.p;
var inst_29637 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_29636);
var inst_29638__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_29637);
var inst_29639 = inst_29631.op;
var inst_29640 = inst_29639 === false;
var inst_29641 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_29638__$1);
var state_29675__$1 = (function (){var statearr_29686 = state_29675;
(statearr_29686[(11)] = inst_29638__$1);

(statearr_29686[(12)] = inst_29640);

return statearr_29686;
})();
if(inst_29641){
var statearr_29687_29723 = state_29675__$1;
(statearr_29687_29723[(1)] = (14));

} else {
var statearr_29688_29724 = state_29675__$1;
(statearr_29688_29724[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (2))){
var _ = (function (){var statearr_29689 = state_29675;
(statearr_29689[(4)] = cljs.core.cons((5),(state_29675[(4)])));

return statearr_29689;
})();
var state_29675__$1 = state_29675;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_29690_29725 = state_29675__$1;
(statearr_29690_29725[(1)] = (6));

} else {
var statearr_29691_29726 = state_29675__$1;
(statearr_29691_29726[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (19))){
var inst_29638 = (state_29675[(11)]);
var inst_29651 = (state_29675[(13)]);
var inst_29631 = (state_29675[(10)]);
var inst_29625 = (state_29675[(9)]);
var inst_29659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29660 = inst_29631.s;
var inst_29661 = [inst_29660,inst_29638,cljs.core.cst$kw$new];
var inst_29662 = (new cljs.core.PersistentVector(null,3,(5),inst_29659,inst_29661,null));
var inst_29663 = cljs.core.assoc_in(inst_29625,inst_29662,inst_29651);
var state_29675__$1 = state_29675;
var statearr_29692_29727 = state_29675__$1;
(statearr_29692_29727[(2)] = inst_29663);

(statearr_29692_29727[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (11))){
var inst_29625 = (state_29675[(9)]);
var state_29675__$1 = state_29675;
var statearr_29694_29728 = state_29675__$1;
(statearr_29694_29728[(2)] = inst_29625);

(statearr_29694_29728[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (9))){
var inst_29624 = (state_29675[(8)]);
var inst_29631 = (state_29675[(10)]);
var inst_29630 = cljs.core.seq(inst_29624);
var inst_29631__$1 = cljs.core.first(inst_29630);
var inst_29632 = cljs.core.next(inst_29630);
var inst_29633 = cljs.core.not(inst_29631__$1);
var state_29675__$1 = (function (){var statearr_29695 = state_29675;
(statearr_29695[(7)] = inst_29632);

(statearr_29695[(10)] = inst_29631__$1);

return statearr_29695;
})();
if(inst_29633){
var statearr_29696_29729 = state_29675__$1;
(statearr_29696_29729[(1)] = (11));

} else {
var statearr_29697_29730 = state_29675__$1;
(statearr_29697_29730[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (5))){
var _ = (function (){var statearr_29698 = state_29675;
(statearr_29698[(4)] = cljs.core.rest((state_29675[(4)])));

return statearr_29698;
})();
var state_29675__$1 = state_29675;
var ex29693 = (state_29675__$1[(2)]);
var statearr_29699_29731 = state_29675__$1;
(statearr_29699_29731[(5)] = ex29693);


if((ex29693 instanceof Error)){
var statearr_29700_29732 = state_29675__$1;
(statearr_29700_29732[(1)] = (4));

(statearr_29700_29732[(5)] = null);

} else {
throw ex29693;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (14))){
var inst_29631 = (state_29675[(10)]);
var inst_29643 = inst_29631.o;
var inst_29644 = fluree.db.query.schema.convert_type_to_kw(inst_29643,db);
var state_29675__$1 = state_29675;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29675__$1,(17),inst_29644);
} else {
if((state_val_29676 === (16))){
var inst_29640 = (state_29675[(12)]);
var inst_29651 = (state_29675[(2)]);
var state_29675__$1 = (function (){var statearr_29701 = state_29675;
(statearr_29701[(13)] = inst_29651);

return statearr_29701;
})();
if(cljs.core.truth_(inst_29640)){
var statearr_29702_29733 = state_29675__$1;
(statearr_29702_29733[(1)] = (18));

} else {
var statearr_29703_29734 = state_29675__$1;
(statearr_29703_29734[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (10))){
var inst_29670 = (state_29675[(2)]);
var _ = (function (){var statearr_29704 = state_29675;
(statearr_29704[(4)] = cljs.core.rest((state_29675[(4)])));

return statearr_29704;
})();
var state_29675__$1 = state_29675;
var statearr_29705_29735 = state_29675__$1;
(statearr_29705_29735[(2)] = inst_29670);

(statearr_29705_29735[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (18))){
var inst_29638 = (state_29675[(11)]);
var inst_29651 = (state_29675[(13)]);
var inst_29631 = (state_29675[(10)]);
var inst_29625 = (state_29675[(9)]);
var inst_29653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29654 = inst_29631.s;
var inst_29655 = [inst_29654,inst_29638,cljs.core.cst$kw$old];
var inst_29656 = (new cljs.core.PersistentVector(null,3,(5),inst_29653,inst_29655,null));
var inst_29657 = cljs.core.assoc_in(inst_29625,inst_29656,inst_29651);
var state_29675__$1 = state_29675;
var statearr_29706_29736 = state_29675__$1;
(statearr_29706_29736[(2)] = inst_29657);

(statearr_29706_29736[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29676 === (8))){
var inst_29607 = (state_29675[(2)]);
var inst_29608 = cljs.core.PersistentHashSet.EMPTY;
var inst_29609 = cljs.core.vals(tempids);
var inst_29610 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29608,inst_29609);
var inst_29611 = (function (){var pred_flakes = inst_29607;
var is_new_QMARK_ = inst_29610;
return (function (p1__29595_SHARP_,p2__29596_SHARP_){
return cljs.core.assoc_in(p1__29595_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__29596_SHARP_.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__29707 = p2__29596_SHARP_.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__29707) : is_new_QMARK_.call(null,G__29707));
})()));
});
})();
var inst_29612 = cljs.core.PersistentHashMap.EMPTY;
var inst_29613 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_29611,inst_29612,inst_29607);
var inst_29621 = cljs.core.seq(inst_29607);
var inst_29622 = cljs.core.first(inst_29621);
var inst_29623 = cljs.core.next(inst_29621);
var inst_29624 = inst_29607;
var inst_29625 = inst_29613;
var state_29675__$1 = (function (){var statearr_29708 = state_29675;
(statearr_29708[(14)] = inst_29623);

(statearr_29708[(8)] = inst_29624);

(statearr_29708[(9)] = inst_29625);

(statearr_29708[(15)] = inst_29622);

return statearr_29708;
})();
var statearr_29709_29737 = state_29675__$1;
(statearr_29709_29737[(2)] = null);

(statearr_29709_29737[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto____0 = (function (){
var statearr_29710 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29710[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto__);

(statearr_29710[(1)] = (1));

return statearr_29710;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto____1 = (function (state_29675){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_29675);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e29711){var ex__13886__auto__ = e29711;
var statearr_29712_29738 = state_29675;
(statearr_29712_29738[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_29675[(4)]))){
var statearr_29713_29739 = state_29675;
(statearr_29713_29739[(1)] = cljs.core.first((state_29675[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__29740 = state_29675;
state_29675 = G__29740;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto__ = function(state_29675){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto____1.call(this,state_29675);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_29714 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_29714[(6)] = c__13957__auto__);

return statearr_29714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__29742 = arguments.length;
switch (G__29742) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__29745 = arguments.length;
switch (G__29745) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30034){
var state_val_30035 = (state_30034[(1)]);
if((state_val_30035 === (65))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29919 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_29920 = (inst_29897.cljs$core$IFn$_invoke$arity$5 ? inst_29897.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_29919,null) : inst_29897.call(null,cljs.core.PersistentArrayMap,null,3,inst_29919,null));
var inst_29921 = (inst_29897.cljs$core$IFn$_invoke$arity$4 ? inst_29897.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_29920,null) : inst_29897.call(null,cljs.core.PersistentHashSet,null,inst_29920,null));
var inst_29922 = (inst_29921.cljs$core$IFn$_invoke$arity$1 ? inst_29921.cljs$core$IFn$_invoke$arity$1(inst_29896) : inst_29921.call(null,inst_29896));
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29922)){
var statearr_30036_30195 = state_30034__$1;
(statearr_30036_30195[(1)] = (66));

} else {
var statearr_30037_30196 = state_30034__$1;
(statearr_30037_30196[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (70))){
var inst_29884 = (state_30034[(9)]);
var state_30034__$1 = state_30034;
var statearr_30038_30197 = state_30034__$1;
(statearr_30038_30197[(2)] = inst_29884);

(statearr_30038_30197[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (62))){
var inst_29884 = (state_30034[(9)]);
var state_30034__$1 = state_30034;
var statearr_30039_30198 = state_30034__$1;
(statearr_30039_30198[(2)] = inst_29884);

(statearr_30039_30198[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (74))){
var inst_29884 = (state_30034[(9)]);
var state_30034__$1 = state_30034;
var statearr_30040_30199 = state_30034__$1;
(statearr_30040_30199[(2)] = inst_29884);

(statearr_30040_30199[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (7))){
var inst_30029 = (state_30034[(2)]);
var _ = (function (){var statearr_30041 = state_30034;
(statearr_30041[(4)] = cljs.core.rest((state_30034[(4)])));

return statearr_30041;
})();
var state_30034__$1 = state_30034;
var statearr_30042_30200 = state_30034__$1;
(statearr_30042_30200[(2)] = inst_30029);

(statearr_30042_30200[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (59))){
var inst_29985 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30043_30201 = state_30034__$1;
(statearr_30043_30201[(2)] = inst_29985);

(statearr_30043_30201[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (86))){
var inst_29884 = (state_30034[(9)]);
var state_30034__$1 = state_30034;
var statearr_30044_30202 = state_30034__$1;
(statearr_30044_30202[(2)] = inst_29884);

(statearr_30044_30202[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (20))){
var inst_29785 = (state_30034[(10)]);
var inst_29810 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29811 = inst_29810 === true;
var inst_29812 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29813 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_29812);
var inst_29814 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_29813);
var inst_29815 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29816 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_29815);
var inst_29817 = inst_29816 === true;
var inst_29818 = ((inst_29811) && (inst_29814) && (inst_29817));
var state_30034__$1 = state_30034;
var statearr_30045_30203 = state_30034__$1;
(statearr_30045_30203[(2)] = inst_29818);

(statearr_30045_30203[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (72))){
var inst_29937 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30046_30204 = state_30034__$1;
(statearr_30046_30204[(2)] = inst_29937);

(statearr_30046_30204[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (58))){
var state_30034__$1 = state_30034;
var statearr_30047_30205 = state_30034__$1;
(statearr_30047_30205[(2)] = null);

(statearr_30047_30205[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (60))){
var inst_29982 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30048_30206 = state_30034__$1;
(statearr_30048_30206[(2)] = inst_29982);

(statearr_30048_30206[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (27))){
var inst_29805 = (state_30034[(11)]);
var state_30034__$1 = state_30034;
var statearr_30049_30207 = state_30034__$1;
(statearr_30049_30207[(2)] = inst_29805);

(statearr_30049_30207[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (1))){
var state_30034__$1 = state_30034;
var statearr_30050_30208 = state_30034__$1;
(statearr_30050_30208[(2)] = null);

(statearr_30050_30208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (69))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29929 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_29930 = (inst_29897.cljs$core$IFn$_invoke$arity$5 ? inst_29897.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_29929,null) : inst_29897.call(null,cljs.core.PersistentArrayMap,null,3,inst_29929,null));
var inst_29931 = (inst_29897.cljs$core$IFn$_invoke$arity$4 ? inst_29897.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_29930,null) : inst_29897.call(null,cljs.core.PersistentHashSet,null,inst_29930,null));
var inst_29932 = (inst_29931.cljs$core$IFn$_invoke$arity$1 ? inst_29931.cljs$core$IFn$_invoke$arity$1(inst_29896) : inst_29931.call(null,inst_29896));
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29932)){
var statearr_30051_30209 = state_30034__$1;
(statearr_30051_30209[(1)] = (70));

} else {
var statearr_30052_30210 = state_30034__$1;
(statearr_30052_30210[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (101))){
var inst_30021 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30053_30211 = state_30034__$1;
(statearr_30053_30211[(2)] = inst_30021);

(statearr_30053_30211[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (24))){
var inst_29805 = (state_30034[(11)]);
var state_30034__$1 = state_30034;
var statearr_30054_30212 = state_30034__$1;
(statearr_30054_30212[(2)] = inst_29805);

(statearr_30054_30212[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (55))){
var state_30034__$1 = state_30034;
var statearr_30055_30213 = state_30034__$1;
(statearr_30055_30213[(1)] = (57));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (85))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29969 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_29970 = (inst_29897.cljs$core$IFn$_invoke$arity$5 ? inst_29897.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_29969,null) : inst_29897.call(null,cljs.core.PersistentArrayMap,null,2,inst_29969,null));
var inst_29971 = (inst_29897.cljs$core$IFn$_invoke$arity$4 ? inst_29897.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_29970,null) : inst_29897.call(null,cljs.core.PersistentHashSet,null,inst_29970,null));
var inst_29972 = (inst_29971.cljs$core$IFn$_invoke$arity$1 ? inst_29971.cljs$core$IFn$_invoke$arity$1(inst_29896) : inst_29971.call(null,inst_29896));
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29972)){
var statearr_30057_30214 = state_30034__$1;
(statearr_30057_30214[(1)] = (86));

} else {
var statearr_30058_30215 = state_30034__$1;
(statearr_30058_30215[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (39))){
var state_30034__$1 = state_30034;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_30059_30216 = state_30034__$1;
(statearr_30059_30216[(1)] = (42));

} else {
var statearr_30060_30217 = state_30034__$1;
(statearr_30060_30217[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (88))){
var inst_29977 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30061_30218 = state_30034__$1;
(statearr_30061_30218[(2)] = inst_29977);

(statearr_30061_30218[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (46))){
var inst_29885 = (state_30034[(12)]);
var state_30034__$1 = state_30034;
var statearr_30062_30219 = state_30034__$1;
(statearr_30062_30219[(2)] = inst_29885);

(statearr_30062_30219[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (4))){
var inst_29746 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30063_30220 = state_30034__$1;
(statearr_30063_30220[(2)] = inst_29746);

(statearr_30063_30220[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (77))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29949 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_29950 = (inst_29897.cljs$core$IFn$_invoke$arity$5 ? inst_29897.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_29949,null) : inst_29897.call(null,cljs.core.PersistentArrayMap,null,5,inst_29949,null));
var inst_29951 = (inst_29897.cljs$core$IFn$_invoke$arity$4 ? inst_29897.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_29950,null) : inst_29897.call(null,cljs.core.PersistentHashSet,null,inst_29950,null));
var inst_29952 = (inst_29951.cljs$core$IFn$_invoke$arity$1 ? inst_29951.cljs$core$IFn$_invoke$arity$1(inst_29896) : inst_29951.call(null,inst_29896));
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29952)){
var statearr_30064_30221 = state_30034__$1;
(statearr_30064_30221[(1)] = (78));

} else {
var statearr_30065_30222 = state_30034__$1;
(statearr_30065_30222[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (95))){
var inst_30008 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30066_30223 = state_30034__$1;
(statearr_30066_30223[(2)] = inst_30008);

(statearr_30066_30223[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (54))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29906 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_29896,inst_29897,throw_QMARK_);
var state_30034__$1 = state_30034;
var statearr_30067_30224 = state_30034__$1;
(statearr_30067_30224[(2)] = inst_29906);

(statearr_30067_30224[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (92))){
var inst_30011 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_30011)){
var statearr_30068_30225 = state_30034__$1;
(statearr_30068_30225[(1)] = (96));

} else {
var statearr_30069_30226 = state_30034__$1;
(statearr_30069_30226[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (15))){
var inst_29773 = (state_30034[(13)]);
var state_30034__$1 = state_30034;
var statearr_30070_30227 = state_30034__$1;
(statearr_30070_30227[(2)] = inst_29773);

(statearr_30070_30227[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (48))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29785 = (state_30034[(10)]);
var inst_29894 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29895 = cljs.core.__destructure_map(inst_29894);
var inst_29896__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29895,cljs.core.cst$kw$old);
var inst_29897__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29895,cljs.core.cst$kw$new);
var inst_29898 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29897__$1,inst_29896__$1);
var state_30034__$1 = (function (){var statearr_30071 = state_30034;
(statearr_30071[(7)] = inst_29896__$1);

(statearr_30071[(8)] = inst_29897__$1);

return statearr_30071;
})();
if(inst_29898){
var statearr_30072_30228 = state_30034__$1;
(statearr_30072_30228[(1)] = (51));

} else {
var statearr_30073_30229 = state_30034__$1;
(statearr_30073_30229[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (50))){
var inst_29785 = (state_30034[(10)]);
var inst_29992 = (state_30034[(2)]);
var inst_29993 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29994 = inst_29993 === true;
var state_30034__$1 = (function (){var statearr_30074 = state_30034;
(statearr_30074[(14)] = inst_29992);

return statearr_30074;
})();
if(cljs.core.truth_(inst_29994)){
var statearr_30075_30230 = state_30034__$1;
(statearr_30075_30230[(1)] = (90));

} else {
var statearr_30076_30231 = state_30034__$1;
(statearr_30076_30231[(1)] = (91));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (75))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29945 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_29896,inst_29897,throw_QMARK_);
var state_30034__$1 = state_30034;
var statearr_30077_30232 = state_30034__$1;
(statearr_30077_30232[(2)] = inst_29945);

(statearr_30077_30232[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (99))){
var inst_30014 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_30015 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_30016 = cljs.core.PersistentHashMap.fromArrays(inst_30014,inst_30015);
var inst_30017 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_30016);
var inst_30018 = (function(){throw inst_30017})();
var state_30034__$1 = state_30034;
var statearr_30078_30233 = state_30034__$1;
(statearr_30078_30233[(2)] = inst_30018);

(statearr_30078_30233[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (21))){
var inst_29808 = (state_30034[(15)]);
var state_30034__$1 = state_30034;
var statearr_30079_30234 = state_30034__$1;
(statearr_30079_30234[(2)] = inst_29808);

(statearr_30079_30234[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (31))){
var inst_29848 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29848)){
var statearr_30080_30235 = state_30034__$1;
(statearr_30080_30235[(1)] = (32));

} else {
var statearr_30081_30236 = state_30034__$1;
(statearr_30081_30236[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (32))){
var inst_29837 = (state_30034[(16)]);
var inst_29850 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_29837,"a component","a non-component",throw_QMARK_);
var state_30034__$1 = state_30034;
var statearr_30082_30237 = state_30034__$1;
(statearr_30082_30237[(2)] = inst_29850);

(statearr_30082_30237[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (40))){
var inst_29853 = (state_30034[(17)]);
var state_30034__$1 = state_30034;
var statearr_30083_30238 = state_30034__$1;
(statearr_30083_30238[(2)] = inst_29853);

(statearr_30083_30238[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (91))){
var state_30034__$1 = state_30034;
var statearr_30084_30239 = state_30034__$1;
(statearr_30084_30239[(2)] = false);

(statearr_30084_30239[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (56))){
var inst_29987 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30085_30240 = state_30034__$1;
(statearr_30085_30240[(2)] = inst_29987);

(statearr_30085_30240[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (33))){
var inst_29837 = (state_30034[(16)]);
var state_30034__$1 = state_30034;
var statearr_30086_30241 = state_30034__$1;
(statearr_30086_30241[(2)] = inst_29837);

(statearr_30086_30241[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (13))){
var inst_29800 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29800)){
var statearr_30087_30242 = state_30034__$1;
(statearr_30087_30242[(1)] = (14));

} else {
var statearr_30088_30243 = state_30034__$1;
(statearr_30088_30243[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (22))){
var inst_29821 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30089_30244 = state_30034__$1;
(statearr_30089_30244[(2)] = inst_29821);

(statearr_30089_30244[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (90))){
var inst_29996 = (state_30034[(18)]);
var inst_29785 = (state_30034[(10)]);
var inst_29996__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_29785);
var state_30034__$1 = (function (){var statearr_30090 = state_30034;
(statearr_30090[(18)] = inst_29996__$1);

return statearr_30090;
})();
if(cljs.core.truth_(inst_29996__$1)){
var statearr_30091_30245 = state_30034__$1;
(statearr_30091_30245[(1)] = (93));

} else {
var statearr_30092_30246 = state_30034__$1;
(statearr_30092_30246[(1)] = (94));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (36))){
var inst_29854 = (state_30034[(19)]);
var state_30034__$1 = state_30034;
var statearr_30093_30247 = state_30034__$1;
(statearr_30093_30247[(2)] = inst_29854);

(statearr_30093_30247[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (41))){
var inst_29885 = (state_30034[(12)]);
var inst_29785 = (state_30034[(10)]);
var inst_29884 = (state_30034[(2)]);
var inst_29885__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_29785);
var state_30034__$1 = (function (){var statearr_30094 = state_30034;
(statearr_30094[(9)] = inst_29884);

(statearr_30094[(12)] = inst_29885__$1);

return statearr_30094;
})();
if(cljs.core.truth_(inst_29885__$1)){
var statearr_30095_30248 = state_30034__$1;
(statearr_30095_30248[(1)] = (45));

} else {
var statearr_30096_30249 = state_30034__$1;
(statearr_30096_30249[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (89))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29979 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_29896,inst_29897,throw_QMARK_);
var state_30034__$1 = state_30034;
var statearr_30097_30250 = state_30034__$1;
(statearr_30097_30250[(2)] = inst_29979);

(statearr_30097_30250[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (100))){
var inst_29992 = (state_30034[(14)]);
var state_30034__$1 = state_30034;
var statearr_30098_30251 = state_30034__$1;
(statearr_30098_30251[(2)] = inst_29992);

(statearr_30098_30251[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (43))){
var inst_29853 = (state_30034[(17)]);
var state_30034__$1 = state_30034;
var statearr_30099_30252 = state_30034__$1;
(statearr_30099_30252[(2)] = inst_29853);

(statearr_30099_30252[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (61))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29909 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_29910 = (inst_29897.cljs$core$IFn$_invoke$arity$5 ? inst_29897.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_29909,null) : inst_29897.call(null,cljs.core.PersistentArrayMap,null,2,inst_29909,null));
var inst_29911 = (inst_29897.cljs$core$IFn$_invoke$arity$4 ? inst_29897.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_29910,null) : inst_29897.call(null,cljs.core.PersistentHashSet,null,inst_29910,null));
var inst_29912 = (inst_29911.cljs$core$IFn$_invoke$arity$1 ? inst_29911.cljs$core$IFn$_invoke$arity$1(inst_29896) : inst_29911.call(null,inst_29896));
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29912)){
var statearr_30100_30253 = state_30034__$1;
(statearr_30100_30253[(1)] = (62));

} else {
var statearr_30101_30254 = state_30034__$1;
(statearr_30101_30254[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (29))){
var inst_29785 = (state_30034[(10)]);
var inst_29840 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29841 = cljs.core.not(inst_29840);
var inst_29842 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29843 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_29842);
var inst_29844 = inst_29843 === true;
var inst_29845 = ((inst_29841) && (inst_29844));
var state_30034__$1 = state_30034;
var statearr_30102_30255 = state_30034__$1;
(statearr_30102_30255[(2)] = inst_29845);

(statearr_30102_30255[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (44))){
var inst_29881 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30103_30256 = state_30034__$1;
(statearr_30103_30256[(2)] = inst_29881);

(statearr_30103_30256[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (93))){
var inst_29785 = (state_30034[(10)]);
var inst_29998 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29999 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_29998);
var inst_30000 = inst_29999 === true;
var inst_30001 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_30002 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_30001);
var inst_30003 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_30002);
var inst_30004 = (!(inst_30003));
var inst_30005 = ((inst_30000) && (inst_30004));
var state_30034__$1 = state_30034;
var statearr_30104_30257 = state_30034__$1;
(statearr_30104_30257[(2)] = inst_30005);

(statearr_30104_30257[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (6))){
var inst_29772 = (state_30034[(20)]);
var inst_29784 = (state_30034[(21)]);
var inst_29781 = cljs.core.seq(inst_29772);
var inst_29782 = cljs.core.first(inst_29781);
var inst_29783 = cljs.core.next(inst_29781);
var inst_29784__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29782,(0),null);
var inst_29785 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29782,(1),null);
var inst_29786 = cljs.core.not(inst_29784__$1);
var state_30034__$1 = (function (){var statearr_30105 = state_30034;
(statearr_30105[(22)] = inst_29783);

(statearr_30105[(10)] = inst_29785);

(statearr_30105[(21)] = inst_29784__$1);

return statearr_30105;
})();
if(inst_29786){
var statearr_30106_30258 = state_30034__$1;
(statearr_30106_30258[(1)] = (8));

} else {
var statearr_30107_30259 = state_30034__$1;
(statearr_30107_30259[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (28))){
var inst_29834 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30108_30260 = state_30034__$1;
(statearr_30108_30260[(2)] = inst_29834);

(statearr_30108_30260[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (64))){
var inst_29917 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30109_30261 = state_30034__$1;
(statearr_30109_30261[(2)] = inst_29917);

(statearr_30109_30261[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (51))){
var inst_29884 = (state_30034[(9)]);
var state_30034__$1 = state_30034;
var statearr_30110_30262 = state_30034__$1;
(statearr_30110_30262[(2)] = inst_29884);

(statearr_30110_30262[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (25))){
var inst_29838 = (state_30034[(23)]);
var inst_29785 = (state_30034[(10)]);
var inst_29837 = (state_30034[(2)]);
var inst_29838__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_29785);
var state_30034__$1 = (function (){var statearr_30111 = state_30034;
(statearr_30111[(23)] = inst_29838__$1);

(statearr_30111[(16)] = inst_29837);

return statearr_30111;
})();
if(cljs.core.truth_(inst_29838__$1)){
var statearr_30112_30263 = state_30034__$1;
(statearr_30112_30263[(1)] = (29));

} else {
var statearr_30113_30264 = state_30034__$1;
(statearr_30113_30264[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (34))){
var inst_29854 = (state_30034[(19)]);
var inst_29785 = (state_30034[(10)]);
var inst_29853 = (state_30034[(2)]);
var inst_29854__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_29785);
var state_30034__$1 = (function (){var statearr_30114 = state_30034;
(statearr_30114[(19)] = inst_29854__$1);

(statearr_30114[(17)] = inst_29853);

return statearr_30114;
})();
if(cljs.core.truth_(inst_29854__$1)){
var statearr_30115_30265 = state_30034__$1;
(statearr_30115_30265[(1)] = (35));

} else {
var statearr_30116_30266 = state_30034__$1;
(statearr_30116_30266[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (17))){
var inst_29808 = (state_30034[(15)]);
var inst_29785 = (state_30034[(10)]);
var inst_29808__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_29785);
var state_30034__$1 = (function (){var statearr_30117 = state_30034;
(statearr_30117[(15)] = inst_29808__$1);

return statearr_30117;
})();
if(cljs.core.truth_(inst_29808__$1)){
var statearr_30118_30267 = state_30034__$1;
(statearr_30118_30267[(1)] = (20));

} else {
var statearr_30119_30268 = state_30034__$1;
(statearr_30119_30268[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (3))){
var inst_30032 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30034__$1,inst_30032);
} else {
if((state_val_30035 === (12))){
var inst_29789 = (state_30034[(24)]);
var state_30034__$1 = state_30034;
var statearr_30120_30269 = state_30034__$1;
(statearr_30120_30269[(2)] = inst_29789);

(statearr_30120_30269[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (2))){
var _ = (function (){var statearr_30121 = state_30034;
(statearr_30121[(4)] = cljs.core.cons((5),(state_30034[(4)])));

return statearr_30121;
})();
var inst_29765 = pred_changes;
var inst_29766 = cljs.core.seq(inst_29765);
var inst_29767 = cljs.core.first(inst_29766);
var inst_29768 = cljs.core.next(inst_29766);
var inst_29769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29767,(0),null);
var inst_29770 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29767,(1),null);
var inst_29771 = db;
var inst_29772 = inst_29765;
var inst_29773 = inst_29771;
var state_30034__$1 = (function (){var statearr_30122 = state_30034;
(statearr_30122[(25)] = inst_29769);

(statearr_30122[(26)] = inst_29768);

(statearr_30122[(13)] = inst_29773);

(statearr_30122[(20)] = inst_29772);

(statearr_30122[(27)] = inst_29770);

return statearr_30122;
})();
var statearr_30123_30270 = state_30034__$1;
(statearr_30123_30270[(2)] = null);

(statearr_30123_30270[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (66))){
var inst_29884 = (state_30034[(9)]);
var state_30034__$1 = state_30034;
var statearr_30124_30271 = state_30034__$1;
(statearr_30124_30271[(2)] = inst_29884);

(statearr_30124_30271[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (23))){
var state_30034__$1 = state_30034;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_30125_30272 = state_30034__$1;
(statearr_30125_30272[(1)] = (26));

} else {
var statearr_30126_30273 = state_30034__$1;
(statearr_30126_30273[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (47))){
var inst_29891 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29891)){
var statearr_30127_30274 = state_30034__$1;
(statearr_30127_30274[(1)] = (48));

} else {
var statearr_30128_30275 = state_30034__$1;
(statearr_30128_30275[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (35))){
var inst_29773 = (state_30034[(13)]);
var inst_29785 = (state_30034[(10)]);
var inst_29784 = (state_30034[(21)]);
var inst_29856 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29857 = cljs.core.not(inst_29856);
var inst_29858 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29859 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_29858);
var inst_29860 = inst_29859 === true;
var inst_29861 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_29773,inst_29784);
var state_30034__$1 = (function (){var statearr_30129 = state_30034;
(statearr_30129[(28)] = inst_29860);

(statearr_30129[(29)] = inst_29857);

return statearr_30129;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30034__$1,(38),inst_29861);
} else {
if((state_val_30035 === (82))){
var inst_29884 = (state_30034[(9)]);
var state_30034__$1 = state_30034;
var statearr_30130_30276 = state_30034__$1;
(statearr_30130_30276[(2)] = inst_29884);

(statearr_30130_30276[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (76))){
var inst_29947 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30131_30277 = state_30034__$1;
(statearr_30131_30277[(2)] = inst_29947);

(statearr_30131_30277[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (97))){
var inst_29992 = (state_30034[(14)]);
var state_30034__$1 = state_30034;
var statearr_30132_30278 = state_30034__$1;
(statearr_30132_30278[(2)] = inst_29992);

(statearr_30132_30278[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (19))){
var inst_29824 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29824)){
var statearr_30133_30279 = state_30034__$1;
(statearr_30133_30279[(1)] = (23));

} else {
var statearr_30134_30280 = state_30034__$1;
(statearr_30134_30280[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (57))){
var inst_29897 = (state_30034[(8)]);
var state_30034__$1 = state_30034;
var G__30135_30281 = inst_29897;
var G__30135_30282__$1 = (((G__30135_30281 instanceof cljs.core.Keyword))?G__30135_30281.fqn:null);
switch (G__30135_30282__$1) {
case "long":
var statearr_30136_30284 = state_30034__$1;
(statearr_30136_30284[(1)] = (61));


break;
case "bigint":
var statearr_30137_30285 = state_30034__$1;
(statearr_30137_30285[(1)] = (65));


break;
case "double":
var statearr_30138_30286 = state_30034__$1;
(statearr_30138_30286[(1)] = (69));


break;
case "float":
var statearr_30139_30287 = state_30034__$1;
(statearr_30139_30287[(1)] = (73));


break;
case "bigdec":
var statearr_30140_30288 = state_30034__$1;
(statearr_30140_30288[(1)] = (77));


break;
case "string":
var statearr_30141_30289 = state_30034__$1;
(statearr_30141_30289[(1)] = (81));


break;
case "instant":
var statearr_30142_30290 = state_30034__$1;
(statearr_30142_30290[(1)] = (85));


break;
default:
var statearr_30143_30291 = state_30034__$1;
(statearr_30143_30291[(1)] = (89));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (68))){
var inst_29927 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30144_30292 = state_30034__$1;
(statearr_30144_30292[(2)] = inst_29927);

(statearr_30144_30292[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (11))){
var inst_29785 = (state_30034[(10)]);
var inst_29791 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29792 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_29791);
var inst_29793 = inst_29792 === false;
var inst_29794 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29795 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_29794);
var inst_29796 = inst_29795 === true;
var inst_29797 = ((inst_29793) && (inst_29796));
var state_30034__$1 = state_30034;
var statearr_30146_30293 = state_30034__$1;
(statearr_30146_30293[(2)] = inst_29797);

(statearr_30146_30293[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (9))){
var inst_29789 = (state_30034[(24)]);
var inst_29785 = (state_30034[(10)]);
var inst_29789__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_29785);
var state_30034__$1 = (function (){var statearr_30147 = state_30034;
(statearr_30147[(24)] = inst_29789__$1);

return statearr_30147;
})();
if(cljs.core.truth_(inst_29789__$1)){
var statearr_30148_30294 = state_30034__$1;
(statearr_30148_30294[(1)] = (11));

} else {
var statearr_30149_30295 = state_30034__$1;
(statearr_30149_30295[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (5))){
var _ = (function (){var statearr_30150 = state_30034;
(statearr_30150[(4)] = cljs.core.rest((state_30034[(4)])));

return statearr_30150;
})();
var state_30034__$1 = state_30034;
var ex30145 = (state_30034__$1[(2)]);
var statearr_30151_30296 = state_30034__$1;
(statearr_30151_30296[(5)] = ex30145);


if((ex30145 instanceof Error)){
var statearr_30152_30297 = state_30034__$1;
(statearr_30152_30297[(1)] = (4));

(statearr_30152_30297[(5)] = null);

} else {
throw ex30145;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (83))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29965 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_29896,inst_29897,throw_QMARK_);
var state_30034__$1 = state_30034;
var statearr_30153_30298 = state_30034__$1;
(statearr_30153_30298[(2)] = inst_29965);

(statearr_30153_30298[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (14))){
var inst_29773 = (state_30034[(13)]);
var inst_29802 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_29773,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_30034__$1 = state_30034;
var statearr_30154_30299 = state_30034__$1;
(statearr_30154_30299[(2)] = inst_29802);

(statearr_30154_30299[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (45))){
var inst_29785 = (state_30034[(10)]);
var inst_29887 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_29785);
var inst_29888 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_29887);
var state_30034__$1 = state_30034;
var statearr_30155_30300 = state_30034__$1;
(statearr_30155_30300[(2)] = inst_29888);

(statearr_30155_30300[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (53))){
var inst_29989 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30156_30301 = state_30034__$1;
(statearr_30156_30301[(2)] = inst_29989);

(statearr_30156_30301[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (78))){
var inst_29884 = (state_30034[(9)]);
var state_30034__$1 = state_30034;
var statearr_30157_30302 = state_30034__$1;
(statearr_30157_30302[(2)] = inst_29884);

(statearr_30157_30302[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (26))){
var inst_29827 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_29828 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_29829 = cljs.core.PersistentHashMap.fromArrays(inst_29827,inst_29828);
var inst_29830 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_29829);
var inst_29831 = (function(){throw inst_29830})();
var state_30034__$1 = state_30034;
var statearr_30158_30303 = state_30034__$1;
(statearr_30158_30303[(2)] = inst_29831);

(statearr_30158_30303[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (16))){
var inst_29806 = (state_30034[(30)]);
var inst_29785 = (state_30034[(10)]);
var inst_29805 = (state_30034[(2)]);
var inst_29806__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_29785);
var state_30034__$1 = (function (){var statearr_30159 = state_30034;
(statearr_30159[(11)] = inst_29805);

(statearr_30159[(30)] = inst_29806__$1);

return statearr_30159;
})();
if(cljs.core.truth_(inst_29806__$1)){
var statearr_30160_30304 = state_30034__$1;
(statearr_30160_30304[(1)] = (17));

} else {
var statearr_30161_30305 = state_30034__$1;
(statearr_30161_30305[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (81))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29959 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_29960 = (inst_29897.cljs$core$IFn$_invoke$arity$5 ? inst_29897.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_29959,null) : inst_29897.call(null,cljs.core.PersistentArrayMap,null,5,inst_29959,null));
var inst_29961 = (inst_29897.cljs$core$IFn$_invoke$arity$4 ? inst_29897.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_29960,null) : inst_29897.call(null,cljs.core.PersistentHashSet,null,inst_29960,null));
var inst_29962 = (inst_29961.cljs$core$IFn$_invoke$arity$1 ? inst_29961.cljs$core$IFn$_invoke$arity$1(inst_29896) : inst_29961.call(null,inst_29896));
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29962)){
var statearr_30162_30306 = state_30034__$1;
(statearr_30162_30306[(1)] = (82));

} else {
var statearr_30163_30307 = state_30034__$1;
(statearr_30163_30307[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (79))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29955 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_29896,inst_29897,throw_QMARK_);
var state_30034__$1 = state_30034;
var statearr_30164_30308 = state_30034__$1;
(statearr_30164_30308[(2)] = inst_29955);

(statearr_30164_30308[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (38))){
var inst_29860 = (state_30034[(28)]);
var inst_29857 = (state_30034[(29)]);
var inst_29863 = (state_30034[(2)]);
var inst_29864 = fluree.db.util.async.throw_err(inst_29863);
var inst_29865 = cljs.core.not(inst_29864);
var inst_29866 = ((inst_29857) && (inst_29860) && (inst_29865));
var state_30034__$1 = state_30034;
var statearr_30165_30309 = state_30034__$1;
(statearr_30165_30309[(2)] = inst_29866);

(statearr_30165_30309[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (98))){
var inst_29783 = (state_30034[(22)]);
var inst_30024 = (state_30034[(2)]);
var inst_29772 = inst_29783;
var inst_29773 = inst_30024;
var state_30034__$1 = (function (){var statearr_30166 = state_30034;
(statearr_30166[(13)] = inst_29773);

(statearr_30166[(20)] = inst_29772);

return statearr_30166;
})();
var statearr_30167_30310 = state_30034__$1;
(statearr_30167_30310[(2)] = null);

(statearr_30167_30310[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (87))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29975 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_29896,inst_29897,throw_QMARK_);
var state_30034__$1 = state_30034;
var statearr_30168_30311 = state_30034__$1;
(statearr_30168_30311[(2)] = inst_29975);

(statearr_30168_30311[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (30))){
var inst_29838 = (state_30034[(23)]);
var state_30034__$1 = state_30034;
var statearr_30169_30312 = state_30034__$1;
(statearr_30169_30312[(2)] = inst_29838);

(statearr_30169_30312[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (73))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29939 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_29940 = (inst_29897.cljs$core$IFn$_invoke$arity$5 ? inst_29897.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_29939,null) : inst_29897.call(null,cljs.core.PersistentArrayMap,null,3,inst_29939,null));
var inst_29941 = (inst_29897.cljs$core$IFn$_invoke$arity$4 ? inst_29897.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_29940,null) : inst_29897.call(null,cljs.core.PersistentHashSet,null,inst_29940,null));
var inst_29942 = (inst_29941.cljs$core$IFn$_invoke$arity$1 ? inst_29941.cljs$core$IFn$_invoke$arity$1(inst_29896) : inst_29941.call(null,inst_29896));
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29942)){
var statearr_30170_30313 = state_30034__$1;
(statearr_30170_30313[(1)] = (74));

} else {
var statearr_30171_30314 = state_30034__$1;
(statearr_30171_30314[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (96))){
var state_30034__$1 = state_30034;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_30172_30315 = state_30034__$1;
(statearr_30172_30315[(1)] = (99));

} else {
var statearr_30173_30316 = state_30034__$1;
(statearr_30173_30316[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (10))){
var inst_30027 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30174_30317 = state_30034__$1;
(statearr_30174_30317[(2)] = inst_30027);

(statearr_30174_30317[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (18))){
var inst_29806 = (state_30034[(30)]);
var state_30034__$1 = state_30034;
var statearr_30175_30318 = state_30034__$1;
(statearr_30175_30318[(2)] = inst_29806);

(statearr_30175_30318[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (52))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29901 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_29902 = (inst_29897.cljs$core$IFn$_invoke$arity$5 ? inst_29897.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_29901,null) : inst_29897.call(null,cljs.core.PersistentArrayMap,null,3,inst_29901,null));
var inst_29903 = (inst_29897.cljs$core$IFn$_invoke$arity$4 ? inst_29897.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_29902,null) : inst_29897.call(null,cljs.core.PersistentHashSet,null,inst_29902,null));
var inst_29904 = (inst_29903.cljs$core$IFn$_invoke$arity$1 ? inst_29903.cljs$core$IFn$_invoke$arity$1(inst_29896) : inst_29903.call(null,inst_29896));
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29904)){
var statearr_30176_30319 = state_30034__$1;
(statearr_30176_30319[(1)] = (54));

} else {
var statearr_30177_30320 = state_30034__$1;
(statearr_30177_30320[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (67))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29925 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_29896,inst_29897,throw_QMARK_);
var state_30034__$1 = state_30034;
var statearr_30178_30321 = state_30034__$1;
(statearr_30178_30321[(2)] = inst_29925);

(statearr_30178_30321[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (71))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29935 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_29896,inst_29897,throw_QMARK_);
var state_30034__$1 = state_30034;
var statearr_30179_30322 = state_30034__$1;
(statearr_30179_30322[(2)] = inst_29935);

(statearr_30179_30322[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (42))){
var inst_29773 = (state_30034[(13)]);
var inst_29784 = (state_30034[(21)]);
var inst_29872 = fluree.db.dbproto._p_prop(inst_29773,cljs.core.cst$kw$name,inst_29784);
var inst_29873 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29872)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_29874 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_29875 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_29876 = cljs.core.PersistentHashMap.fromArrays(inst_29874,inst_29875);
var inst_29877 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29873,inst_29876);
var inst_29878 = (function(){throw inst_29877})();
var state_30034__$1 = state_30034;
var statearr_30180_30323 = state_30034__$1;
(statearr_30180_30323[(2)] = inst_29878);

(statearr_30180_30323[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (80))){
var inst_29957 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30181_30324 = state_30034__$1;
(statearr_30181_30324[(2)] = inst_29957);

(statearr_30181_30324[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (37))){
var inst_29869 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
if(cljs.core.truth_(inst_29869)){
var statearr_30182_30325 = state_30034__$1;
(statearr_30182_30325[(1)] = (39));

} else {
var statearr_30183_30326 = state_30034__$1;
(statearr_30183_30326[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (63))){
var inst_29896 = (state_30034[(7)]);
var inst_29897 = (state_30034[(8)]);
var inst_29915 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_29896,inst_29897,throw_QMARK_);
var state_30034__$1 = state_30034;
var statearr_30184_30327 = state_30034__$1;
(statearr_30184_30327[(2)] = inst_29915);

(statearr_30184_30327[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (94))){
var inst_29996 = (state_30034[(18)]);
var state_30034__$1 = state_30034;
var statearr_30185_30328 = state_30034__$1;
(statearr_30185_30328[(2)] = inst_29996);

(statearr_30185_30328[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (8))){
var inst_29773 = (state_30034[(13)]);
var state_30034__$1 = state_30034;
var statearr_30186_30329 = state_30034__$1;
(statearr_30186_30329[(2)] = inst_29773);

(statearr_30186_30329[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (49))){
var inst_29884 = (state_30034[(9)]);
var state_30034__$1 = state_30034;
var statearr_30187_30330 = state_30034__$1;
(statearr_30187_30330[(2)] = inst_29884);

(statearr_30187_30330[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30035 === (84))){
var inst_29967 = (state_30034[(2)]);
var state_30034__$1 = state_30034;
var statearr_30188_30331 = state_30034__$1;
(statearr_30188_30331[(2)] = inst_29967);

(statearr_30188_30331[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__13883__auto__ = null;
var fluree$db$query$schema$state_machine__13883__auto____0 = (function (){
var statearr_30189 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30189[(0)] = fluree$db$query$schema$state_machine__13883__auto__);

(statearr_30189[(1)] = (1));

return statearr_30189;
});
var fluree$db$query$schema$state_machine__13883__auto____1 = (function (state_30034){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30034);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30190){var ex__13886__auto__ = e30190;
var statearr_30191_30332 = state_30034;
(statearr_30191_30332[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30034[(4)]))){
var statearr_30192_30333 = state_30034;
(statearr_30192_30333[(1)] = cljs.core.first((state_30034[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30334 = state_30034;
state_30034 = G__30334;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__13883__auto__ = function(state_30034){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__13883__auto____1.call(this,state_30034);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__13883__auto____0;
fluree$db$query$schema$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__13883__auto____1;
return fluree$db$query$schema$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30193 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30193[(6)] = c__13957__auto__);

return statearr_30193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__30336 = arguments.length;
switch (G__30336) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30360){
var state_val_30361 = (state_30360[(1)]);
if((state_val_30361 === (7))){
var state_30360__$1 = state_30360;
var statearr_30362_30382 = state_30360__$1;
(statearr_30362_30382[(2)] = db);

(statearr_30362_30382[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30361 === (1))){
var state_30360__$1 = state_30360;
var statearr_30363_30383 = state_30360__$1;
(statearr_30363_30383[(2)] = null);

(statearr_30363_30383[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30361 === (4))){
var inst_30337 = (state_30360[(2)]);
var state_30360__$1 = state_30360;
var statearr_30364_30384 = state_30360__$1;
(statearr_30364_30384[(2)] = inst_30337);

(statearr_30364_30384[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30361 === (6))){
var inst_30346 = (state_30360[(7)]);
var inst_30345 = (state_30360[(2)]);
var inst_30346__$1 = fluree.db.util.async.throw_err(inst_30345);
var inst_30347 = cljs.core.empty_QMARK_(inst_30346__$1);
var state_30360__$1 = (function (){var statearr_30365 = state_30360;
(statearr_30365[(7)] = inst_30346__$1);

return statearr_30365;
})();
if(inst_30347){
var statearr_30366_30385 = state_30360__$1;
(statearr_30366_30385[(1)] = (7));

} else {
var statearr_30367_30386 = state_30360__$1;
(statearr_30367_30386[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30361 === (3))){
var inst_30358 = (state_30360[(2)]);
var state_30360__$1 = state_30360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30360__$1,inst_30358);
} else {
if((state_val_30361 === (2))){
var _ = (function (){var statearr_30369 = state_30360;
(statearr_30369[(4)] = cljs.core.cons((5),(state_30360[(4)])));

return statearr_30369;
})();
var inst_30343 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_30360__$1 = state_30360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30360__$1,(6),inst_30343);
} else {
if((state_val_30361 === (9))){
var inst_30355 = (state_30360[(2)]);
var _ = (function (){var statearr_30370 = state_30360;
(statearr_30370[(4)] = cljs.core.rest((state_30360[(4)])));

return statearr_30370;
})();
var state_30360__$1 = state_30360;
var statearr_30371_30387 = state_30360__$1;
(statearr_30371_30387[(2)] = inst_30355);

(statearr_30371_30387[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30361 === (5))){
var _ = (function (){var statearr_30372 = state_30360;
(statearr_30372[(4)] = cljs.core.rest((state_30360[(4)])));

return statearr_30372;
})();
var state_30360__$1 = state_30360;
var ex30368 = (state_30360__$1[(2)]);
var statearr_30373_30388 = state_30360__$1;
(statearr_30373_30388[(5)] = ex30368);


if((ex30368 instanceof Error)){
var statearr_30374_30389 = state_30360__$1;
(statearr_30374_30389[(1)] = (4));

(statearr_30374_30389[(5)] = null);

} else {
throw ex30368;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30361 === (10))){
var inst_30352 = (state_30360[(2)]);
var inst_30353 = fluree.db.util.async.throw_err(inst_30352);
var state_30360__$1 = state_30360;
var statearr_30375_30390 = state_30360__$1;
(statearr_30375_30390[(2)] = inst_30353);

(statearr_30375_30390[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30361 === (8))){
var inst_30346 = (state_30360[(7)]);
var inst_30350 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_30346,db,true);
var state_30360__$1 = state_30360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30360__$1,(10),inst_30350);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__13883__auto__ = null;
var fluree$db$query$schema$state_machine__13883__auto____0 = (function (){
var statearr_30376 = [null,null,null,null,null,null,null,null];
(statearr_30376[(0)] = fluree$db$query$schema$state_machine__13883__auto__);

(statearr_30376[(1)] = (1));

return statearr_30376;
});
var fluree$db$query$schema$state_machine__13883__auto____1 = (function (state_30360){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30360);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30377){var ex__13886__auto__ = e30377;
var statearr_30378_30391 = state_30360;
(statearr_30378_30391[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30360[(4)]))){
var statearr_30379_30392 = state_30360;
(statearr_30379_30392[(1)] = cljs.core.first((state_30360[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30393 = state_30360;
state_30360 = G__30393;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__13883__auto__ = function(state_30360){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__13883__auto____1.call(this,state_30360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__13883__auto____0;
fluree$db$query$schema$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__13883__auto____1;
return fluree$db$query$schema$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30380 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30380[(6)] = c__13957__auto__);

return statearr_30380;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__30395 = arguments.length;
switch (G__30395) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__30397 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30397,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30397,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30397,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4149__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4149__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__30400_SHARP_,p2__30401_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30400_SHARP_,p2__30401_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__30402_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,p1__30402_SHARP_.p)){
return p1__30402_SHARP_.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30468){
var state_val_30469 = (state_30468[(1)]);
if((state_val_30469 === (1))){
var state_30468__$1 = state_30468;
var statearr_30470_30488 = state_30468__$1;
(statearr_30470_30488[(2)] = null);

(statearr_30470_30488[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (2))){
var _ = (function (){var statearr_30471 = state_30468;
(statearr_30471[(4)] = cljs.core.cons((5),(state_30468[(4)])));

return statearr_30471;
})();
var inst_30420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30421 = fluree.db.flake.max_subject_id((1));
var inst_30422 = [inst_30421];
var inst_30423 = (new cljs.core.PersistentVector(null,1,(5),inst_30420,inst_30422,null));
var inst_30424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30425 = [(0)];
var inst_30426 = (new cljs.core.PersistentVector(null,1,(5),inst_30424,inst_30425,null));
var inst_30427 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_30423,cljs.core._LT__EQ_,inst_30426);
var state_30468__$1 = state_30468;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30468__$1,(6),inst_30427);
} else {
if((state_val_30469 === (3))){
var inst_30466 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30468__$1,inst_30466);
} else {
if((state_val_30469 === (4))){
var inst_30408 = (state_30468[(2)]);
var state_30468__$1 = state_30468;
var statearr_30473_30489 = state_30468__$1;
(statearr_30473_30489[(2)] = inst_30408);

(statearr_30473_30489[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (5))){
var _ = (function (){var statearr_30474 = state_30468;
(statearr_30474[(4)] = cljs.core.rest((state_30468[(4)])));

return statearr_30474;
})();
var state_30468__$1 = state_30468;
var ex30472 = (state_30468__$1[(2)]);
var statearr_30475_30490 = state_30468__$1;
(statearr_30475_30490[(5)] = ex30472);


if((ex30472 instanceof Error)){
var statearr_30476_30491 = state_30468__$1;
(statearr_30476_30491[(1)] = (4));

(statearr_30476_30491[(5)] = null);

} else {
throw ex30472;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30469 === (6))){
var inst_30429 = (state_30468[(2)]);
var inst_30430 = fluree.db.util.async.throw_err(inst_30429);
var inst_30431 = (function (){var schema_flakes = inst_30430;
return (function (p1__30403_SHARP_){
return (p1__30403_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_30432 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_30431,inst_30430);
var inst_30433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30432,(0),null);
var inst_30434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30432,(1),null);
var inst_30435 = (function (){var schema_flakes = inst_30430;
var vec__30414 = inst_30432;
var collection_flakes = inst_30433;
var predicate_flakes = inst_30434;
return (function (acc,coll_flakes){
var sid = cljs.core.first(coll_flakes).s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__30405_SHARP_,p2__30406_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__30405_SHARP_,p2__30406_SHARP_.p,p2__30406_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,specs,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,partition,cljs.core.cst$kw$partition,partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_30436 = [(-1),"_tx"];
var inst_30437 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_30438 = ["_tx",(-1),(-1)];
var inst_30439 = cljs.core.PersistentHashMap.fromArrays(inst_30437,inst_30438);
var inst_30440 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid];
var inst_30441 = ["_tx",(-1),(-1)];
var inst_30442 = cljs.core.PersistentHashMap.fromArrays(inst_30440,inst_30441);
var inst_30443 = [inst_30439,inst_30442];
var inst_30444 = cljs.core.PersistentHashMap.fromArrays(inst_30436,inst_30443);
var inst_30445 = (function (){var schema_flakes = inst_30430;
var vec__30414 = inst_30432;
var collection_flakes = inst_30433;
var predicate_flakes = inst_30434;
return (function (p1__30404_SHARP_){
return p1__30404_SHARP_.s;
});
})();
var inst_30446 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_30445,inst_30433);
var inst_30447 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_30435,inst_30444,inst_30446);
var inst_30449 = (function (){var schema_flakes = inst_30430;
var vec__30414 = inst_30432;
var collection_flakes = inst_30433;
var predicate_flakes = inst_30434;
var coll = inst_30447;
return (function (p__30448,pred_flakes){
var vec__30477 = p__30448;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30477,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30477,(1),null);
var id = cljs.core.first(pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__30480 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__30480.cljs$core$IFn$_invoke$arity$1 ? fexpr__30480.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__30480.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4160__auto__ = ref_QMARK_;
if(or__4160__auto__){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$retractDuplicates,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_30450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30451 = cljs.core.PersistentHashMap.EMPTY;
var inst_30452 = cljs.core.PersistentHashSet.EMPTY;
var inst_30453 = [inst_30451,inst_30452];
var inst_30454 = (new cljs.core.PersistentVector(null,2,(5),inst_30450,inst_30453,null));
var inst_30455 = (function (){var schema_flakes = inst_30430;
var vec__30414 = inst_30432;
var collection_flakes = inst_30433;
var predicate_flakes = inst_30434;
var coll = inst_30447;
return (function (p1__30407_SHARP_){
return p1__30407_SHARP_.s;
});
})();
var inst_30456 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_30455,inst_30434);
var inst_30457 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_30449,inst_30454,inst_30456);
var inst_30458 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30457,(0),null);
var inst_30459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30457,(1),null);
var inst_30460 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_30461 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_30462 = [inst_30461,inst_30447,inst_30458,inst_30459];
var inst_30463 = cljs.core.PersistentHashMap.fromArrays(inst_30460,inst_30462);
var _ = (function (){var statearr_30481 = state_30468;
(statearr_30481[(4)] = cljs.core.rest((state_30468[(4)])));

return statearr_30481;
})();
var state_30468__$1 = state_30468;
var statearr_30482_30492 = state_30468__$1;
(statearr_30482_30492[(2)] = inst_30463);

(statearr_30482_30492[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__13883__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__13883__auto____0 = (function (){
var statearr_30483 = [null,null,null,null,null,null,null];
(statearr_30483[(0)] = fluree$db$query$schema$schema_map_$_state_machine__13883__auto__);

(statearr_30483[(1)] = (1));

return statearr_30483;
});
var fluree$db$query$schema$schema_map_$_state_machine__13883__auto____1 = (function (state_30468){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30468);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30484){var ex__13886__auto__ = e30484;
var statearr_30485_30493 = state_30468;
(statearr_30485_30493[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30468[(4)]))){
var statearr_30486_30494 = state_30468;
(statearr_30486_30494[(1)] = cljs.core.first((state_30468[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30495 = state_30468;
state_30468 = G__30495;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__13883__auto__ = function(state_30468){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__13883__auto____1.call(this,state_30468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__13883__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__13883__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30487 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30487[(6)] = c__13957__auto__);

return statearr_30487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_30537){
var state_val_30538 = (state_30537[(1)]);
if((state_val_30538 === (7))){
var inst_30520 = (state_30537[(2)]);
var inst_30521 = fluree.db.query.schema.flake__GT_pred_map(inst_30520);
var inst_30522 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_30523 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30521,(114));
var inst_30524 = cljs.core.boolean$(inst_30523);
var inst_30525 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30521,(110));
var inst_30526 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30521,(117));
var inst_30527 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_30526);
var inst_30528 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30521,(111));
var inst_30529 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30521,(115));
var inst_30530 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30521,(112));
var inst_30531 = [inst_30524,inst_30525,inst_30527,inst_30528,inst_30529,inst_30530];
var inst_30532 = cljs.core.PersistentHashMap.fromArrays(inst_30522,inst_30531);
var _ = (function (){var statearr_30539 = state_30537;
(statearr_30539[(4)] = cljs.core.rest((state_30537[(4)])));

return statearr_30539;
})();
var state_30537__$1 = state_30537;
var statearr_30540_30563 = state_30537__$1;
(statearr_30540_30563[(2)] = inst_30532);

(statearr_30540_30563[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30538 === (1))){
var state_30537__$1 = state_30537;
var statearr_30541_30564 = state_30537__$1;
(statearr_30541_30564[(2)] = null);

(statearr_30541_30564[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30538 === (4))){
var inst_30496 = (state_30537[(2)]);
var state_30537__$1 = state_30537;
var statearr_30542_30565 = state_30537__$1;
(statearr_30542_30565[(2)] = inst_30496);

(statearr_30542_30565[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30538 === (6))){
var _ = (function (){var statearr_30543 = state_30537;
(statearr_30543[(4)] = cljs.core.cons((9),(state_30537[(4)])));

return statearr_30543;
})();
var inst_30508 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30510 = ["_setting/id","root"];
var inst_30511 = (new cljs.core.PersistentVector(null,2,(5),inst_30509,inst_30510,null));
var inst_30512 = [inst_30511];
var inst_30513 = (new cljs.core.PersistentVector(null,1,(5),inst_30508,inst_30512,null));
var inst_30514 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_30513);
var state_30537__$1 = state_30537;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30537__$1,(10),inst_30514);
} else {
if((state_val_30538 === (3))){
var inst_30535 = (state_30537[(2)]);
var state_30537__$1 = state_30537;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30537__$1,inst_30535);
} else {
if((state_val_30538 === (2))){
var _ = (function (){var statearr_30546 = state_30537;
(statearr_30546[(4)] = cljs.core.cons((5),(state_30537[(4)])));

return statearr_30546;
})();
var state_30537__$1 = state_30537;
var statearr_30547_30566 = state_30537__$1;
(statearr_30547_30566[(2)] = null);

(statearr_30547_30566[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30538 === (9))){
var _ = (function (){var statearr_30548 = state_30537;
(statearr_30548[(4)] = cljs.core.rest((state_30537[(4)])));

return statearr_30548;
})();
var state_30537__$1 = state_30537;
var ex30544 = (state_30537__$1[(2)]);
var statearr_30549_30567 = state_30537__$1;
(statearr_30549_30567[(5)] = ex30544);


var statearr_30550_30568 = state_30537__$1;
(statearr_30550_30568[(1)] = (8));

(statearr_30550_30568[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_30538 === (5))){
var _ = (function (){var statearr_30551 = state_30537;
(statearr_30551[(4)] = cljs.core.rest((state_30537[(4)])));

return statearr_30551;
})();
var state_30537__$1 = state_30537;
var ex30545 = (state_30537__$1[(2)]);
var statearr_30552_30569 = state_30537__$1;
(statearr_30552_30569[(5)] = ex30545);


if((ex30545 instanceof Error)){
var statearr_30553_30570 = state_30537__$1;
(statearr_30553_30570[(1)] = (4));

(statearr_30553_30570[(5)] = null);

} else {
throw ex30545;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30538 === (10))){
var inst_30516 = (state_30537[(2)]);
var inst_30517 = fluree.db.util.async.throw_err(inst_30516);
var _ = (function (){var statearr_30554 = state_30537;
(statearr_30554[(4)] = cljs.core.rest((state_30537[(4)])));

return statearr_30554;
})();
var state_30537__$1 = state_30537;
var statearr_30555_30571 = state_30537__$1;
(statearr_30555_30571[(2)] = inst_30517);

(statearr_30555_30571[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30538 === (8))){
var inst_30502 = (state_30537[(2)]);
var state_30537__$1 = (function (){var statearr_30556 = state_30537;
(statearr_30556[(7)] = inst_30502);

return statearr_30556;
})();
var statearr_30557_30572 = state_30537__$1;
(statearr_30557_30572[(2)] = null);

(statearr_30557_30572[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__13883__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__13883__auto____0 = (function (){
var statearr_30558 = [null,null,null,null,null,null,null,null];
(statearr_30558[(0)] = fluree$db$query$schema$setting_map_$_state_machine__13883__auto__);

(statearr_30558[(1)] = (1));

return statearr_30558;
});
var fluree$db$query$schema$setting_map_$_state_machine__13883__auto____1 = (function (state_30537){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_30537);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e30559){var ex__13886__auto__ = e30559;
var statearr_30560_30573 = state_30537;
(statearr_30560_30573[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_30537[(4)]))){
var statearr_30561_30574 = state_30537;
(statearr_30561_30574[(1)] = cljs.core.first((state_30537[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__30575 = state_30537;
state_30537 = G__30575;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__13883__auto__ = function(state_30537){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__13883__auto____1.call(this,state_30537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__13883__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__13883__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_30562 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_30562[(6)] = c__13957__auto__);

return statearr_30562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
