// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4160__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__27543 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27543,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27543,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27543,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27543,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27543,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27543,(5),null);
var G__27546 = idx;
var G__27546__$1 = (((G__27546 instanceof cljs.core.Keyword))?G__27546.fqn:null);
switch (G__27546__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27546__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__27548 = idx;
var G__27548__$1 = (((G__27548 instanceof cljs.core.Keyword))?G__27548.fqn:null);
switch (G__27548__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27548__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__27550 = idx;
var G__27550__$1 = (((G__27550 instanceof cljs.core.Keyword))?G__27550.fqn:null);
switch (G__27550__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__27550__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__27553 = arguments.length;
switch (G__27553) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__27554 = (function (){var pred__27557 = cljs.core.identical_QMARK_;
var expr__27558 = test;
if(cljs.core.truth_((pred__27557.cljs$core$IFn$_invoke$arity$2 ? pred__27557.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__27558) : pred__27557.call(null,cljs.core._EQ_,expr__27558)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__27557.cljs$core$IFn$_invoke$arity$2 ? pred__27557.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__27558) : pred__27557.call(null,cljs.core._LT_,expr__27558)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__27557.cljs$core$IFn$_invoke$arity$2 ? pred__27557.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__27558) : pred__27557.call(null,cljs.core._LT__EQ_,expr__27558)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__27557.cljs$core$IFn$_invoke$arity$2 ? pred__27557.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__27558) : pred__27557.call(null,cljs.core._GT_,expr__27558)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__27557.cljs$core$IFn$_invoke$arity$2 ? pred__27557.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__27558) : pred__27557.call(null,cljs.core._GT__EQ_,expr__27558)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__27558)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27554,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27554,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27554,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__27554,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_27791){
var state_val_27792 = (state_27791[(1)]);
if((state_val_27792 === (65))){
var inst_27765 = (state_27791[(7)]);
var inst_27712 = (state_27791[(8)]);
var inst_27765__$1 = (state_27791[(2)]);
var inst_27766 = cljs.core.count(inst_27765__$1);
var state_27791__$1 = (function (){var statearr_27793 = state_27791;
(statearr_27793[(7)] = inst_27765__$1);

(statearr_27793[(9)] = inst_27766);

return statearr_27793;
})();
if(cljs.core.truth_(inst_27712)){
var statearr_27794_27922 = state_27791__$1;
(statearr_27794_27922[(1)] = (78));

} else {
var statearr_27795_27923 = state_27791__$1;
(statearr_27795_27923[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (70))){
var inst_27761 = (state_27791[(2)]);
var state_27791__$1 = state_27791;
var statearr_27796_27924 = state_27791__$1;
(statearr_27796_27924[(2)] = inst_27761);

(statearr_27796_27924[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (62))){
var inst_27682 = (state_27791[(10)]);
var inst_27696 = (state_27791[(11)]);
var inst_27711 = (state_27791[(2)]);
var inst_27712 = fluree.db.dbproto._rhs(inst_27696);
var state_27791__$1 = (function (){var statearr_27797 = state_27791;
(statearr_27797[(12)] = inst_27711);

(statearr_27797[(8)] = inst_27712);

return statearr_27797;
})();
if(cljs.core.truth_(inst_27682)){
var statearr_27798_27925 = state_27791__$1;
(statearr_27798_27925[(1)] = (63));

} else {
var statearr_27799_27926 = state_27791__$1;
(statearr_27799_27926[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (74))){
var inst_27749 = (state_27791[(2)]);
var inst_27750 = fluree.db.util.async.throw_err(inst_27749);
var state_27791__$1 = state_27791;
if(cljs.core.truth_(inst_27750)){
var statearr_27800_27927 = state_27791__$1;
(statearr_27800_27927[(1)] = (75));

} else {
var statearr_27801_27928 = state_27791__$1;
(statearr_27801_27928[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (7))){
var inst_27573 = (state_27791[(13)]);
var state_27791__$1 = state_27791;
var statearr_27802_27929 = state_27791__$1;
(statearr_27802_27929[(2)] = inst_27573);

(statearr_27802_27929[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (59))){
var inst_27658 = (state_27791[(14)]);
var inst_27703 = (state_27791[(15)]);
var inst_27659 = (state_27791[(16)]);
var inst_27702 = (state_27791[(2)]);
var inst_27703__$1 = fluree.db.util.async.throw_err(inst_27702);
var inst_27704 = fluree.db.flake.subrange(inst_27703__$1,start_test,inst_27658,end_test,inst_27659);
var inst_27705 = fluree.db.query.range.value_with_nil_pred(idx,inst_27658,inst_27659);
var state_27791__$1 = (function (){var statearr_27803 = state_27791;
(statearr_27803[(15)] = inst_27703__$1);

(statearr_27803[(17)] = inst_27704);

return statearr_27803;
})();
if(inst_27705){
var statearr_27804_27930 = state_27791__$1;
(statearr_27804_27930[(1)] = (60));

} else {
var statearr_27805_27931 = state_27791__$1;
(statearr_27805_27931[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (20))){
var inst_27574 = (state_27791[(18)]);
var inst_27621 = (state_27791[(2)]);
var inst_27622 = (inst_27574 == null);
var state_27791__$1 = (function (){var statearr_27806 = state_27791;
(statearr_27806[(19)] = inst_27621);

return statearr_27806;
})();
if(cljs.core.truth_(inst_27622)){
var statearr_27807_27932 = state_27791__$1;
(statearr_27807_27932[(1)] = (22));

} else {
var statearr_27808_27933 = state_27791__$1;
(statearr_27808_27933[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (72))){
var inst_27730 = (state_27791[(20)]);
var state_27791__$1 = state_27791;
var statearr_27809_27934 = state_27791__$1;
(statearr_27809_27934[(2)] = inst_27730);

(statearr_27809_27934[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (58))){
var inst_27786 = (state_27791[(2)]);
var _ = (function (){var statearr_27810 = state_27791;
(statearr_27810[(4)] = cljs.core.rest((state_27791[(4)])));

return statearr_27810;
})();
var state_27791__$1 = state_27791;
var statearr_27811_27935 = state_27791__$1;
(statearr_27811_27935[(2)] = inst_27786);

(statearr_27811_27935[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (60))){
var inst_27579 = (state_27791[(21)]);
var inst_27664 = (state_27791[(22)]);
var inst_27577 = (state_27791[(23)]);
var inst_27603 = (state_27791[(24)]);
var inst_27658 = (state_27791[(14)]);
var inst_27612 = (state_27791[(25)]);
var inst_27648 = (state_27791[(26)]);
var inst_27665 = (state_27791[(27)]);
var inst_27691 = (state_27791[(28)]);
var inst_27682 = (state_27791[(10)]);
var inst_27639 = (state_27791[(29)]);
var inst_27572 = (state_27791[(30)]);
var inst_27703 = (state_27791[(15)]);
var inst_27657 = (state_27791[(31)]);
var inst_27669 = (state_27791[(32)]);
var inst_27576 = (state_27791[(33)]);
var inst_27676 = (state_27791[(34)]);
var inst_27583 = (state_27791[(35)]);
var inst_27659 = (state_27791[(16)]);
var inst_27621 = (state_27791[(19)]);
var inst_27675 = (state_27791[(36)]);
var inst_27686 = (state_27791[(37)]);
var inst_27584 = (state_27791[(38)]);
var inst_27704 = (state_27791[(17)]);
var inst_27594 = (state_27791[(39)]);
var inst_27698 = (state_27791[(40)]);
var inst_27696 = (state_27791[(11)]);
var inst_27697 = (state_27791[(41)]);
var inst_27630 = (state_27791[(42)]);
var inst_27707 = (function (){var no_filter_QMARK_ = inst_27682;
var next_node = inst_27696;
var flakes = inst_27703;
var s1 = inst_27594;
var o2 = inst_27621;
var t1 = inst_27576;
var i = inst_27697;
var m1 = inst_27648;
var root_node = inst_27691;
var to_t = inst_27676;
var s2 = inst_27603;
var p2 = inst_27639;
var permissions = inst_27665;
var vec__27566 = inst_27572;
var vec__27569 = inst_27579;
var limit = inst_27664;
var start_flake = inst_27658;
var acc = inst_27698;
var t2 = inst_27583;
var op1 = inst_27577;
var o1 = inst_27612;
var end_flake = inst_27659;
var base_result = inst_27704;
var p1 = inst_27630;
var idx_compare = inst_27669;
var op2 = inst_27584;
var from_t = inst_27675;
var m2 = inst_27657;
var novelty = inst_27686;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_27708 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_27707,inst_27704,inst_27704);
var state_27791__$1 = state_27791;
var statearr_27812_27936 = state_27791__$1;
(statearr_27812_27936[(2)] = inst_27708);

(statearr_27812_27936[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (27))){
var inst_27581 = (state_27791[(43)]);
var inst_27630 = (state_27791[(2)]);
var inst_27631 = (inst_27581 == null);
var state_27791__$1 = (function (){var statearr_27813 = state_27791;
(statearr_27813[(42)] = inst_27630);

return statearr_27813;
})();
if(cljs.core.truth_(inst_27631)){
var statearr_27814_27937 = state_27791__$1;
(statearr_27814_27937[(1)] = (28));

} else {
var statearr_27815_27938 = state_27791__$1;
(statearr_27815_27938[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (1))){
var state_27791__$1 = state_27791;
var statearr_27816_27939 = state_27791__$1;
(statearr_27816_27939[(2)] = null);

(statearr_27816_27939[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (69))){
var inst_27729 = (state_27791[(44)]);
var inst_27744 = (inst_27729 + (1));
var inst_27745 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_27791__$1 = (function (){var statearr_27817 = state_27791;
(statearr_27817[(45)] = inst_27744);

return statearr_27817;
})();
if(cljs.core.truth_(inst_27745)){
var statearr_27818_27940 = state_27791__$1;
(statearr_27818_27940[(1)] = (71));

} else {
var statearr_27819_27941 = state_27791__$1;
(statearr_27819_27941[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (24))){
var inst_27626 = (state_27791[(2)]);
var state_27791__$1 = state_27791;
if(cljs.core.truth_(inst_27626)){
var statearr_27820_27942 = state_27791__$1;
(statearr_27820_27942[(1)] = (25));

} else {
var statearr_27821_27943 = state_27791__$1;
(statearr_27821_27943[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (55))){
var inst_27658 = (state_27791[(14)]);
var inst_27691 = (state_27791[(28)]);
var inst_27690 = (state_27791[(2)]);
var inst_27691__$1 = fluree.db.util.async.throw_err(inst_27690);
var inst_27692 = fluree.db.dbproto._lookup_leaf(inst_27691__$1,inst_27658);
var state_27791__$1 = (function (){var statearr_27822 = state_27791;
(statearr_27822[(28)] = inst_27691__$1);

return statearr_27822;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27791__$1,(56),inst_27692);
} else {
if((state_val_27792 === (39))){
var inst_27646 = (state_27791[(2)]);
var state_27791__$1 = state_27791;
var statearr_27823_27944 = state_27791__$1;
(statearr_27823_27944[(2)] = inst_27646);

(statearr_27823_27944[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (46))){
var inst_27660 = (state_27791[(46)]);
var state_27791__$1 = state_27791;
var statearr_27824_27945 = state_27791__$1;
(statearr_27824_27945[(2)] = inst_27660);

(statearr_27824_27945[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (4))){
var inst_27560 = (state_27791[(2)]);
var state_27791__$1 = state_27791;
var statearr_27825_27946 = state_27791__$1;
(statearr_27825_27946[(2)] = inst_27560);

(statearr_27825_27946[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (77))){
var inst_27755 = (state_27791[(2)]);
var state_27791__$1 = state_27791;
var statearr_27826_27947 = state_27791__$1;
(statearr_27826_27947[(2)] = inst_27755);

(statearr_27826_27947[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (54))){
var inst_27682 = (state_27791[(2)]);
var inst_27683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27684 = [cljs.core.cst$kw$novelty,idx];
var inst_27685 = (new cljs.core.PersistentVector(null,2,(5),inst_27683,inst_27684,null));
var inst_27686 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_27685);
var inst_27687 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_27688 = fluree.db.dbproto._resolve(inst_27687);
var state_27791__$1 = (function (){var statearr_27827 = state_27791;
(statearr_27827[(10)] = inst_27682);

(statearr_27827[(37)] = inst_27686);

return statearr_27827;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27791__$1,(55),inst_27688);
} else {
if((state_val_27792 === (15))){
var inst_27575 = (state_27791[(47)]);
var state_27791__$1 = state_27791;
var statearr_27828_27948 = state_27791__$1;
(statearr_27828_27948[(2)] = inst_27575);

(statearr_27828_27948[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (48))){
var inst_27670 = (state_27791[(48)]);
var inst_27664 = (state_27791[(2)]);
var inst_27665 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_27666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27667 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_27668 = (new cljs.core.PersistentVector(null,3,(5),inst_27666,inst_27667,null));
var inst_27669 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_27668);
var inst_27670__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_27791__$1 = (function (){var statearr_27829 = state_27791;
(statearr_27829[(22)] = inst_27664);

(statearr_27829[(27)] = inst_27665);

(statearr_27829[(48)] = inst_27670__$1);

(statearr_27829[(32)] = inst_27669);

return statearr_27829;
})();
if(cljs.core.truth_(inst_27670__$1)){
var statearr_27830_27949 = state_27791__$1;
(statearr_27830_27949[(1)] = (49));

} else {
var statearr_27831_27950 = state_27791__$1;
(statearr_27831_27950[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (50))){
var inst_27673 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_27791__$1 = state_27791;
var statearr_27832_27951 = state_27791__$1;
(statearr_27832_27951[(2)] = inst_27673);

(statearr_27832_27951[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (75))){
var inst_27730 = (state_27791[(20)]);
var state_27791__$1 = state_27791;
var statearr_27833_27952 = state_27791__$1;
(statearr_27833_27952[(2)] = inst_27730);

(statearr_27833_27952[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (21))){
var inst_27617 = (state_27791[(2)]);
var inst_27618 = fluree.db.util.async.throw_err(inst_27617);
var state_27791__$1 = state_27791;
var statearr_27834_27953 = state_27791__$1;
(statearr_27834_27953[(2)] = inst_27618);

(statearr_27834_27953[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (31))){
var state_27791__$1 = state_27791;
var statearr_27835_27954 = state_27791__$1;
(statearr_27835_27954[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_27835_27954[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (32))){
var inst_27581 = (state_27791[(43)]);
var state_27791__$1 = state_27791;
var statearr_27836_27955 = state_27791__$1;
(statearr_27836_27955[(2)] = inst_27581);

(statearr_27836_27955[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (40))){
var inst_27585 = (state_27791[(49)]);
var state_27791__$1 = state_27791;
var statearr_27837_27956 = state_27791__$1;
(statearr_27837_27956[(2)] = inst_27585);

(statearr_27837_27956[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (56))){
var inst_27694 = (state_27791[(2)]);
var inst_27695 = fluree.db.util.async.throw_err(inst_27694);
var inst_27696 = inst_27695;
var inst_27697 = (0);
var inst_27698 = null;
var state_27791__$1 = (function (){var statearr_27838 = state_27791;
(statearr_27838[(40)] = inst_27698);

(statearr_27838[(11)] = inst_27696);

(statearr_27838[(41)] = inst_27697);

return statearr_27838;
})();
var statearr_27839_27957 = state_27791__$1;
(statearr_27839_27957[(2)] = null);

(statearr_27839_27957[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (33))){
var inst_27578 = (state_27791[(50)]);
var inst_27639 = (state_27791[(2)]);
var state_27791__$1 = (function (){var statearr_27840 = state_27791;
(statearr_27840[(29)] = inst_27639);

return statearr_27840;
})();
if(cljs.core.truth_(inst_27578)){
var statearr_27841_27958 = state_27791__$1;
(statearr_27841_27958[(1)] = (34));

} else {
var statearr_27842_27959 = state_27791__$1;
(statearr_27842_27959[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (13))){
var inst_27599 = (state_27791[(2)]);
var inst_27600 = fluree.db.util.async.throw_err(inst_27599);
var state_27791__$1 = state_27791;
var statearr_27843_27960 = state_27791__$1;
(statearr_27843_27960[(2)] = inst_27600);

(statearr_27843_27960[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (22))){
var inst_27612 = (state_27791[(25)]);
var state_27791__$1 = state_27791;
var statearr_27844_27961 = state_27791__$1;
(statearr_27844_27961[(2)] = inst_27612);

(statearr_27844_27961[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (36))){
var inst_27585 = (state_27791[(49)]);
var inst_27648 = (state_27791[(2)]);
var state_27791__$1 = (function (){var statearr_27845 = state_27791;
(statearr_27845[(26)] = inst_27648);

return statearr_27845;
})();
if(cljs.core.truth_(inst_27585)){
var statearr_27846_27962 = state_27791__$1;
(statearr_27846_27962[(1)] = (40));

} else {
var statearr_27847_27963 = state_27791__$1;
(statearr_27847_27963[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (41))){
var inst_27651 = (cljs.core._LT__EQ_ === end_test);
var state_27791__$1 = state_27791;
if(cljs.core.truth_(inst_27651)){
var statearr_27848_27964 = state_27791__$1;
(statearr_27848_27964[(1)] = (43));

} else {
var statearr_27849_27965 = state_27791__$1;
(statearr_27849_27965[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (43))){
var state_27791__$1 = state_27791;
var statearr_27850_27966 = state_27791__$1;
(statearr_27850_27966[(2)] = (2147483647));

(statearr_27850_27966[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (61))){
var inst_27704 = (state_27791[(17)]);
var state_27791__$1 = state_27791;
var statearr_27851_27967 = state_27791__$1;
(statearr_27851_27967[(2)] = inst_27704);

(statearr_27851_27967[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (29))){
var state_27791__$1 = state_27791;
var statearr_27852_27968 = state_27791__$1;
(statearr_27852_27968[(2)] = false);

(statearr_27852_27968[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (44))){
var state_27791__$1 = state_27791;
var statearr_27853_27969 = state_27791__$1;
(statearr_27853_27969[(2)] = fluree.db.util.core.min_integer);

(statearr_27853_27969[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (6))){
var inst_27573 = (state_27791[(13)]);
var inst_27588 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_27573);
var state_27791__$1 = state_27791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27791__$1,(9),inst_27588);
} else {
if((state_val_27792 === (28))){
var inst_27621 = (state_27791[(19)]);
var state_27791__$1 = state_27791;
var statearr_27854_27970 = state_27791__$1;
(statearr_27854_27970[(2)] = inst_27621);

(statearr_27854_27970[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (64))){
var inst_27711 = (state_27791[(12)]);
var inst_27697 = (state_27791[(41)]);
var inst_27725 = cljs.core.seq(inst_27711);
var inst_27726 = cljs.core.first(inst_27725);
var inst_27727 = cljs.core.next(inst_27725);
var inst_27728 = inst_27711;
var inst_27729 = inst_27697;
var inst_27730 = inst_27711;
var state_27791__$1 = (function (){var statearr_27855 = state_27791;
(statearr_27855[(51)] = inst_27727);

(statearr_27855[(52)] = inst_27726);

(statearr_27855[(53)] = inst_27728);

(statearr_27855[(44)] = inst_27729);

(statearr_27855[(20)] = inst_27730);

return statearr_27855;
})();
var statearr_27856_27971 = state_27791__$1;
(statearr_27856_27971[(2)] = null);

(statearr_27856_27971[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (51))){
var inst_27675 = (state_27791[(2)]);
var inst_27676 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_27677 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_27791__$1 = (function (){var statearr_27857 = state_27791;
(statearr_27857[(34)] = inst_27676);

(statearr_27857[(36)] = inst_27675);

return statearr_27857;
})();
if(cljs.core.truth_(inst_27677)){
var statearr_27858_27972 = state_27791__$1;
(statearr_27858_27972[(1)] = (52));

} else {
var statearr_27859_27973 = state_27791__$1;
(statearr_27859_27973[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (25))){
var state_27791__$1 = state_27791;
var statearr_27860_27974 = state_27791__$1;
(statearr_27860_27974[(2)] = (-1));

(statearr_27860_27974[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (34))){
var inst_27578 = (state_27791[(50)]);
var state_27791__$1 = state_27791;
var statearr_27861_27975 = state_27791__$1;
(statearr_27861_27975[(2)] = inst_27578);

(statearr_27861_27975[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (17))){
var inst_27608 = (state_27791[(2)]);
var inst_27609 = fluree.db.util.async.throw_err(inst_27608);
var state_27791__$1 = state_27791;
var statearr_27862_27976 = state_27791__$1;
(statearr_27862_27976[(2)] = inst_27609);

(statearr_27862_27976[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (3))){
var inst_27789 = (state_27791[(2)]);
var state_27791__$1 = state_27791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27791__$1,inst_27789);
} else {
if((state_val_27792 === (12))){
var inst_27575 = (state_27791[(47)]);
var inst_27603 = (state_27791[(2)]);
var inst_27604 = fluree.db.util.core.pred_ident_QMARK_(inst_27575);
var state_27791__$1 = (function (){var statearr_27863 = state_27791;
(statearr_27863[(24)] = inst_27603);

return statearr_27863;
})();
if(inst_27604){
var statearr_27864_27977 = state_27791__$1;
(statearr_27864_27977[(1)] = (14));

} else {
var statearr_27865_27978 = state_27791__$1;
(statearr_27865_27978[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (2))){
var inst_27579 = (state_27791[(21)]);
var inst_27572 = (state_27791[(30)]);
var inst_27573 = (state_27791[(13)]);
var _ = (function (){var statearr_27866 = state_27791;
(statearr_27866[(4)] = cljs.core.cons((5),(state_27791[(4)])));

return statearr_27866;
})();
var inst_27572__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_27573__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27572__$1,(0),null);
var inst_27574 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27572__$1,(1),null);
var inst_27575 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27572__$1,(2),null);
var inst_27576 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27572__$1,(3),null);
var inst_27577 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27572__$1,(4),null);
var inst_27578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27572__$1,(5),null);
var inst_27579__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_27580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27579__$1,(0),null);
var inst_27581 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27579__$1,(1),null);
var inst_27582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27579__$1,(2),null);
var inst_27583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27579__$1,(3),null);
var inst_27584 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27579__$1,(4),null);
var inst_27585 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27579__$1,(5),null);
var inst_27586 = fluree.db.util.core.pred_ident_QMARK_(inst_27573__$1);
var state_27791__$1 = (function (){var statearr_27867 = state_27791;
(statearr_27867[(43)] = inst_27581);

(statearr_27867[(21)] = inst_27579__$1);

(statearr_27867[(23)] = inst_27577);

(statearr_27867[(54)] = inst_27582);

(statearr_27867[(30)] = inst_27572__$1);

(statearr_27867[(33)] = inst_27576);

(statearr_27867[(50)] = inst_27578);

(statearr_27867[(35)] = inst_27583);

(statearr_27867[(18)] = inst_27574);

(statearr_27867[(38)] = inst_27584);

(statearr_27867[(55)] = inst_27580);

(statearr_27867[(49)] = inst_27585);

(statearr_27867[(13)] = inst_27573__$1);

(statearr_27867[(47)] = inst_27575);

return statearr_27867;
})();
if(inst_27586){
var statearr_27868_27979 = state_27791__$1;
(statearr_27868_27979[(1)] = (6));

} else {
var statearr_27869_27980 = state_27791__$1;
(statearr_27869_27980[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (66))){
var inst_27664 = (state_27791[(22)]);
var inst_27736 = (state_27791[(56)]);
var inst_27728 = (state_27791[(53)]);
var inst_27729 = (state_27791[(44)]);
var inst_27735 = cljs.core.seq(inst_27728);
var inst_27736__$1 = cljs.core.first(inst_27735);
var inst_27737 = cljs.core.next(inst_27735);
var inst_27738 = (inst_27736__$1 == null);
var inst_27739 = (inst_27729 > inst_27664);
var inst_27740 = ((inst_27738) || (inst_27739));
var state_27791__$1 = (function (){var statearr_27870 = state_27791;
(statearr_27870[(56)] = inst_27736__$1);

(statearr_27870[(57)] = inst_27737);

return statearr_27870;
})();
if(cljs.core.truth_(inst_27740)){
var statearr_27871_27981 = state_27791__$1;
(statearr_27871_27981[(1)] = (68));

} else {
var statearr_27872_27982 = state_27791__$1;
(statearr_27872_27982[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (23))){
var state_27791__$1 = state_27791;
var statearr_27873_27983 = state_27791__$1;
(statearr_27873_27983[(2)] = false);

(statearr_27873_27983[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (47))){
var state_27791__$1 = state_27791;
var statearr_27874_27984 = state_27791__$1;
(statearr_27874_27984[(2)] = fluree.db.util.core.max_long);

(statearr_27874_27984[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (35))){
var inst_27642 = (cljs.core._GT__EQ_ === start_test);
var state_27791__$1 = state_27791;
if(cljs.core.truth_(inst_27642)){
var statearr_27875_27985 = state_27791__$1;
(statearr_27875_27985[(1)] = (37));

} else {
var statearr_27876_27986 = state_27791__$1;
(statearr_27876_27986[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (82))){
var inst_27691 = (state_27791[(28)]);
var inst_27712 = (state_27791[(8)]);
var inst_27778 = fluree.db.dbproto._lookup_leaf(inst_27691,inst_27712);
var state_27791__$1 = state_27791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27791__$1,(84),inst_27778);
} else {
if((state_val_27792 === (76))){
var inst_27736 = (state_27791[(56)]);
var inst_27730 = (state_27791[(20)]);
var inst_27753 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_27730,inst_27736);
var state_27791__$1 = state_27791;
var statearr_27877_27987 = state_27791__$1;
(statearr_27877_27987[(2)] = inst_27753);

(statearr_27877_27987[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (19))){
var inst_27582 = (state_27791[(54)]);
var state_27791__$1 = state_27791;
var statearr_27878_27988 = state_27791__$1;
(statearr_27878_27988[(2)] = inst_27582);

(statearr_27878_27988[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (57))){
var inst_27676 = (state_27791[(34)]);
var inst_27675 = (state_27791[(36)]);
var inst_27686 = (state_27791[(37)]);
var inst_27696 = (state_27791[(11)]);
var inst_27700 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_27696,inst_27675,inst_27676,inst_27686);
var state_27791__$1 = state_27791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27791__$1,(59),inst_27700);
} else {
if((state_val_27792 === (68))){
var inst_27698 = (state_27791[(40)]);
var inst_27730 = (state_27791[(20)]);
var inst_27742 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27730,inst_27698);
var state_27791__$1 = state_27791;
var statearr_27879_27989 = state_27791__$1;
(statearr_27879_27989[(2)] = inst_27742);

(statearr_27879_27989[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (11))){
var inst_27580 = (state_27791[(55)]);
var state_27791__$1 = state_27791;
var statearr_27881_27990 = state_27791__$1;
(statearr_27881_27990[(2)] = inst_27580);

(statearr_27881_27990[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (9))){
var inst_27590 = (state_27791[(2)]);
var inst_27591 = fluree.db.util.async.throw_err(inst_27590);
var state_27791__$1 = state_27791;
var statearr_27882_27991 = state_27791__$1;
(statearr_27882_27991[(2)] = inst_27591);

(statearr_27882_27991[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (5))){
var _ = (function (){var statearr_27883 = state_27791;
(statearr_27883[(4)] = cljs.core.rest((state_27791[(4)])));

return statearr_27883;
})();
var state_27791__$1 = state_27791;
var ex27880 = (state_27791__$1[(2)]);
var statearr_27884_27992 = state_27791__$1;
(statearr_27884_27992[(5)] = ex27880);


if((ex27880 instanceof Error)){
var statearr_27885_27993 = state_27791__$1;
(statearr_27885_27993[(1)] = (4));

(statearr_27885_27993[(5)] = null);

} else {
throw ex27880;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (83))){
var inst_27784 = (state_27791[(2)]);
var state_27791__$1 = state_27791;
var statearr_27886_27994 = state_27791__$1;
(statearr_27886_27994[(2)] = inst_27784);

(statearr_27886_27994[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (14))){
var inst_27575 = (state_27791[(47)]);
var inst_27606 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_27575);
var state_27791__$1 = state_27791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27791__$1,(17),inst_27606);
} else {
if((state_val_27792 === (45))){
var inst_27655 = (state_27791[(2)]);
var state_27791__$1 = state_27791;
var statearr_27887_27995 = state_27791__$1;
(statearr_27887_27995[(2)] = inst_27655);

(statearr_27887_27995[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (53))){
var state_27791__$1 = state_27791;
var statearr_27888_27996 = state_27791__$1;
(statearr_27888_27996[(2)] = true);

(statearr_27888_27996[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (78))){
var inst_27664 = (state_27791[(22)]);
var inst_27669 = (state_27791[(32)]);
var inst_27659 = (state_27791[(16)]);
var inst_27766 = (state_27791[(9)]);
var inst_27712 = (state_27791[(8)]);
var inst_27768 = (inst_27669.cljs$core$IFn$_invoke$arity$2 ? inst_27669.cljs$core$IFn$_invoke$arity$2(inst_27712,inst_27659) : inst_27669.call(null,inst_27712,inst_27659));
var inst_27769 = (inst_27768 < (0));
var inst_27770 = (inst_27766 < inst_27664);
var inst_27771 = ((inst_27769) && (inst_27770));
var state_27791__$1 = state_27791;
var statearr_27889_27997 = state_27791__$1;
(statearr_27889_27997[(2)] = inst_27771);

(statearr_27889_27997[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (26))){
var inst_27574 = (state_27791[(18)]);
var state_27791__$1 = state_27791;
var statearr_27890_27998 = state_27791__$1;
(statearr_27890_27998[(2)] = inst_27574);

(statearr_27890_27998[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (16))){
var inst_27582 = (state_27791[(54)]);
var inst_27612 = (state_27791[(2)]);
var inst_27613 = fluree.db.util.core.pred_ident_QMARK_(inst_27582);
var state_27791__$1 = (function (){var statearr_27891 = state_27791;
(statearr_27891[(25)] = inst_27612);

return statearr_27891;
})();
if(inst_27613){
var statearr_27892_27999 = state_27791__$1;
(statearr_27892_27999[(1)] = (18));

} else {
var statearr_27893_28000 = state_27791__$1;
(statearr_27893_28000[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (81))){
var inst_27765 = (state_27791[(7)]);
var state_27791__$1 = state_27791;
var statearr_27894_28001 = state_27791__$1;
(statearr_27894_28001[(2)] = inst_27765);

(statearr_27894_28001[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (79))){
var inst_27712 = (state_27791[(8)]);
var state_27791__$1 = state_27791;
var statearr_27895_28002 = state_27791__$1;
(statearr_27895_28002[(2)] = inst_27712);

(statearr_27895_28002[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (38))){
var state_27791__$1 = state_27791;
var statearr_27896_28003 = state_27791__$1;
(statearr_27896_28003[(2)] = (2147483647));

(statearr_27896_28003[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (30))){
var inst_27635 = (state_27791[(2)]);
var state_27791__$1 = state_27791;
if(cljs.core.truth_(inst_27635)){
var statearr_27897_28004 = state_27791__$1;
(statearr_27897_28004[(1)] = (31));

} else {
var statearr_27898_28005 = state_27791__$1;
(statearr_27898_28005[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (73))){
var inst_27744 = (state_27791[(45)]);
var inst_27737 = (state_27791[(57)]);
var inst_27758 = (state_27791[(2)]);
var inst_27728 = inst_27737;
var inst_27729 = inst_27744;
var inst_27730 = inst_27758;
var state_27791__$1 = (function (){var statearr_27899 = state_27791;
(statearr_27899[(53)] = inst_27728);

(statearr_27899[(44)] = inst_27729);

(statearr_27899[(20)] = inst_27730);

return statearr_27899;
})();
var statearr_27900_28006 = state_27791__$1;
(statearr_27900_28006[(2)] = null);

(statearr_27900_28006[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (10))){
var inst_27580 = (state_27791[(55)]);
var inst_27597 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_27580);
var state_27791__$1 = state_27791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27791__$1,(13),inst_27597);
} else {
if((state_val_27792 === (18))){
var inst_27582 = (state_27791[(54)]);
var inst_27615 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_27582);
var state_27791__$1 = state_27791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27791__$1,(21),inst_27615);
} else {
if((state_val_27792 === (52))){
var inst_27603 = (state_27791[(24)]);
var inst_27665 = (state_27791[(27)]);
var inst_27639 = (state_27791[(29)]);
var inst_27594 = (state_27791[(39)]);
var inst_27630 = (state_27791[(42)]);
var inst_27679 = fluree.db.permissions_validate.no_filter_QMARK_(inst_27665,inst_27594,inst_27603,inst_27630,inst_27639);
var state_27791__$1 = state_27791;
var statearr_27901_28007 = state_27791__$1;
(statearr_27901_28007[(2)] = inst_27679);

(statearr_27901_28007[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (67))){
var inst_27763 = (state_27791[(2)]);
var state_27791__$1 = state_27791;
var statearr_27902_28008 = state_27791__$1;
(statearr_27902_28008[(2)] = inst_27763);

(statearr_27902_28008[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (71))){
var inst_27736 = (state_27791[(56)]);
var inst_27747 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_27736);
var state_27791__$1 = state_27791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27791__$1,(74),inst_27747);
} else {
if((state_val_27792 === (42))){
var inst_27577 = (state_27791[(23)]);
var inst_27603 = (state_27791[(24)]);
var inst_27612 = (state_27791[(25)]);
var inst_27648 = (state_27791[(26)]);
var inst_27639 = (state_27791[(29)]);
var inst_27657 = (state_27791[(31)]);
var inst_27576 = (state_27791[(33)]);
var inst_27583 = (state_27791[(35)]);
var inst_27621 = (state_27791[(19)]);
var inst_27584 = (state_27791[(38)]);
var inst_27594 = (state_27791[(39)]);
var inst_27630 = (state_27791[(42)]);
var inst_27660 = (state_27791[(46)]);
var inst_27657__$1 = (state_27791[(2)]);
var inst_27658 = fluree.db.flake.__GT_Flake(inst_27594,inst_27630,inst_27612,inst_27576,inst_27577,inst_27648);
var inst_27659 = fluree.db.flake.__GT_Flake(inst_27603,inst_27639,inst_27621,inst_27583,inst_27584,inst_27657__$1);
var inst_27660__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_27791__$1 = (function (){var statearr_27903 = state_27791;
(statearr_27903[(14)] = inst_27658);

(statearr_27903[(31)] = inst_27657__$1);

(statearr_27903[(16)] = inst_27659);

(statearr_27903[(46)] = inst_27660__$1);

return statearr_27903;
})();
if(cljs.core.truth_(inst_27660__$1)){
var statearr_27904_28009 = state_27791__$1;
(statearr_27904_28009[(1)] = (46));

} else {
var statearr_27905_28010 = state_27791__$1;
(statearr_27905_28010[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (80))){
var inst_27774 = (state_27791[(2)]);
var inst_27775 = cljs.core.not(inst_27774);
var state_27791__$1 = state_27791;
if(inst_27775){
var statearr_27906_28011 = state_27791__$1;
(statearr_27906_28011[(1)] = (81));

} else {
var statearr_27907_28012 = state_27791__$1;
(statearr_27907_28012[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (37))){
var state_27791__$1 = state_27791;
var statearr_27908_28013 = state_27791__$1;
(statearr_27908_28013[(2)] = fluree.db.util.core.min_integer);

(statearr_27908_28013[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (63))){
var inst_27664 = (state_27791[(22)]);
var inst_27711 = (state_27791[(12)]);
var inst_27698 = (state_27791[(40)]);
var inst_27697 = (state_27791[(41)]);
var inst_27714 = (inst_27664 - inst_27697);
var inst_27715 = fluree.db.flake.take(inst_27714,inst_27711);
var inst_27716 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27715,inst_27698);
var state_27791__$1 = state_27791;
var statearr_27909_28014 = state_27791__$1;
(statearr_27909_28014[(2)] = inst_27716);

(statearr_27909_28014[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (8))){
var inst_27580 = (state_27791[(55)]);
var inst_27594 = (state_27791[(2)]);
var inst_27595 = fluree.db.util.core.pred_ident_QMARK_(inst_27580);
var state_27791__$1 = (function (){var statearr_27910 = state_27791;
(statearr_27910[(39)] = inst_27594);

return statearr_27910;
})();
if(inst_27595){
var statearr_27911_28015 = state_27791__$1;
(statearr_27911_28015[(1)] = (10));

} else {
var statearr_27912_28016 = state_27791__$1;
(statearr_27912_28016[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (49))){
var inst_27670 = (state_27791[(48)]);
var state_27791__$1 = state_27791;
var statearr_27913_28017 = state_27791__$1;
(statearr_27913_28017[(2)] = inst_27670);

(statearr_27913_28017[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27792 === (84))){
var inst_27765 = (state_27791[(7)]);
var inst_27766 = (state_27791[(9)]);
var inst_27780 = (state_27791[(2)]);
var inst_27781 = fluree.db.util.async.throw_err(inst_27780);
var inst_27696 = inst_27781;
var inst_27697 = inst_27766;
var inst_27698 = inst_27765;
var state_27791__$1 = (function (){var statearr_27914 = state_27791;
(statearr_27914[(40)] = inst_27698);

(statearr_27914[(11)] = inst_27696);

(statearr_27914[(41)] = inst_27697);

return statearr_27914;
})();
var statearr_27915_28018 = state_27791__$1;
(statearr_27915_28018[(2)] = null);

(statearr_27915_28018[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__13883__auto__ = null;
var fluree$db$query$range$state_machine__13883__auto____0 = (function (){
var statearr_27916 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27916[(0)] = fluree$db$query$range$state_machine__13883__auto__);

(statearr_27916[(1)] = (1));

return statearr_27916;
});
var fluree$db$query$range$state_machine__13883__auto____1 = (function (state_27791){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_27791);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e27917){var ex__13886__auto__ = e27917;
var statearr_27918_28019 = state_27791;
(statearr_27918_28019[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_27791[(4)]))){
var statearr_27919_28020 = state_27791;
(statearr_27919_28020[(1)] = cljs.core.first((state_27791[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__28021 = state_27791;
state_27791 = G__28021;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__13883__auto__ = function(state_27791){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__13883__auto____1.call(this,state_27791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__13883__auto____0;
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__13883__auto____1;
return fluree$db$query$range$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_27920 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_27920[(6)] = c__13957__auto__);

return statearr_27920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_28089){
var state_val_28090 = (state_28089[(1)]);
if((state_val_28090 === (7))){
var inst_28084 = (state_28089[(2)]);
var _ = (function (){var statearr_28091 = state_28089;
(statearr_28091[(4)] = cljs.core.rest((state_28089[(4)])));

return statearr_28091;
})();
var state_28089__$1 = state_28089;
var statearr_28092_28123 = state_28089__$1;
(statearr_28092_28123[(2)] = inst_28084);

(statearr_28092_28123[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (1))){
var state_28089__$1 = state_28089;
var statearr_28093_28124 = state_28089__$1;
(statearr_28093_28124[(2)] = null);

(statearr_28093_28124[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (4))){
var inst_28022 = (state_28089[(2)]);
var state_28089__$1 = state_28089;
var statearr_28094_28125 = state_28089__$1;
(statearr_28094_28125[(2)] = inst_28022);

(statearr_28094_28125[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (15))){
var state_28089__$1 = state_28089;
var statearr_28095_28126 = state_28089__$1;
(statearr_28095_28126[(2)] = (0));

(statearr_28095_28126[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (13))){
var inst_28071 = (state_28089[(7)]);
var inst_28070 = (state_28089[(8)]);
var inst_28070__$1 = (state_28089[(2)]);
var inst_28071__$1 = cljs.core.count(inst_28070__$1);
var inst_28072 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_28071__$1);
var state_28089__$1 = (function (){var statearr_28096 = state_28089;
(statearr_28096[(7)] = inst_28071__$1);

(statearr_28096[(8)] = inst_28070__$1);

return statearr_28096;
})();
if(inst_28072){
var statearr_28097_28127 = state_28089__$1;
(statearr_28097_28127[(1)] = (15));

} else {
var statearr_28098_28128 = state_28089__$1;
(statearr_28098_28128[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (6))){
var inst_28043 = (state_28089[(9)]);
var inst_28042 = (state_28089[(10)]);
var inst_28051 = (state_28089[(11)]);
var inst_28044 = (state_28089[(12)]);
var inst_28050 = cljs.core.seq(inst_28042);
var inst_28051__$1 = cljs.core.first(inst_28050);
var inst_28052 = cljs.core.next(inst_28050);
var inst_28053 = (inst_28051__$1 == null);
var inst_28054 = (inst_28043 >= flake_limit);
var inst_28055 = (inst_28044 >= subject_limit);
var inst_28056 = ((inst_28053) || (inst_28054) || (inst_28055));
var state_28089__$1 = (function (){var statearr_28099 = state_28089;
(statearr_28099[(13)] = inst_28052);

(statearr_28099[(11)] = inst_28051__$1);

return statearr_28099;
})();
if(cljs.core.truth_(inst_28056)){
var statearr_28100_28129 = state_28089__$1;
(statearr_28100_28129[(1)] = (8));

} else {
var statearr_28101_28130 = state_28089__$1;
(statearr_28101_28130[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (17))){
var inst_28071 = (state_28089[(7)]);
var inst_28052 = (state_28089[(13)]);
var inst_28045 = (state_28089[(14)]);
var inst_28043 = (state_28089[(9)]);
var inst_28070 = (state_28089[(8)]);
var inst_28044 = (state_28089[(12)]);
var inst_28076 = (state_28089[(2)]);
var inst_28077 = (inst_28043 + inst_28071);
var inst_28078 = (inst_28044 + inst_28076);
var inst_28079 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28045,inst_28070);
var inst_28042 = inst_28052;
var inst_28043__$1 = inst_28077;
var inst_28044__$1 = inst_28078;
var inst_28045__$1 = inst_28079;
var state_28089__$1 = (function (){var statearr_28102 = state_28089;
(statearr_28102[(14)] = inst_28045__$1);

(statearr_28102[(9)] = inst_28043__$1);

(statearr_28102[(10)] = inst_28042);

(statearr_28102[(12)] = inst_28044__$1);

return statearr_28102;
})();
var statearr_28103_28131 = state_28089__$1;
(statearr_28103_28131[(2)] = null);

(statearr_28103_28131[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (3))){
var inst_28087 = (state_28089[(2)]);
var state_28089__$1 = state_28089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28089__$1,inst_28087);
} else {
if((state_val_28090 === (12))){
var inst_28051 = (state_28089[(11)]);
var state_28089__$1 = state_28089;
var statearr_28104_28132 = state_28089__$1;
(statearr_28104_28132[(2)] = inst_28051);

(statearr_28104_28132[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (2))){
var _ = (function (){var statearr_28105 = state_28089;
(statearr_28105[(4)] = cljs.core.cons((5),(state_28089[(4)])));

return statearr_28105;
})();
var inst_28035 = subject_groups;
var inst_28036 = cljs.core.seq(inst_28035);
var inst_28037 = cljs.core.first(inst_28036);
var inst_28038 = cljs.core.next(inst_28036);
var inst_28039 = flake_start;
var inst_28040 = subject_start;
var inst_28041 = cljs.core.PersistentVector.EMPTY;
var inst_28042 = inst_28035;
var inst_28043 = inst_28039;
var inst_28044 = inst_28040;
var inst_28045 = inst_28041;
var state_28089__$1 = (function (){var statearr_28106 = state_28089;
(statearr_28106[(15)] = inst_28038);

(statearr_28106[(14)] = inst_28045);

(statearr_28106[(16)] = inst_28037);

(statearr_28106[(9)] = inst_28043);

(statearr_28106[(10)] = inst_28042);

(statearr_28106[(12)] = inst_28044);

return statearr_28106;
})();
var statearr_28107_28133 = state_28089__$1;
(statearr_28107_28133[(2)] = null);

(statearr_28107_28133[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (11))){
var inst_28051 = (state_28089[(11)]);
var inst_28064 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_28051);
var state_28089__$1 = state_28089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28089__$1,(14),inst_28064);
} else {
if((state_val_28090 === (9))){
var inst_28062 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_28089__$1 = state_28089;
if(cljs.core.truth_(inst_28062)){
var statearr_28109_28134 = state_28089__$1;
(statearr_28109_28134[(1)] = (11));

} else {
var statearr_28110_28135 = state_28089__$1;
(statearr_28110_28135[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (5))){
var _ = (function (){var statearr_28111 = state_28089;
(statearr_28111[(4)] = cljs.core.rest((state_28089[(4)])));

return statearr_28111;
})();
var state_28089__$1 = state_28089;
var ex28108 = (state_28089__$1[(2)]);
var statearr_28112_28136 = state_28089__$1;
(statearr_28112_28136[(5)] = ex28108);


if((ex28108 instanceof Error)){
var statearr_28113_28137 = state_28089__$1;
(statearr_28113_28137[(1)] = (4));

(statearr_28113_28137[(5)] = null);

} else {
throw ex28108;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (14))){
var inst_28066 = (state_28089[(2)]);
var inst_28067 = fluree.db.util.async.throw_err(inst_28066);
var state_28089__$1 = state_28089;
var statearr_28114_28138 = state_28089__$1;
(statearr_28114_28138[(2)] = inst_28067);

(statearr_28114_28138[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (16))){
var state_28089__$1 = state_28089;
var statearr_28115_28139 = state_28089__$1;
(statearr_28115_28139[(2)] = (1));

(statearr_28115_28139[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (10))){
var inst_28082 = (state_28089[(2)]);
var state_28089__$1 = state_28089;
var statearr_28116_28140 = state_28089__$1;
(statearr_28116_28140[(2)] = inst_28082);

(statearr_28116_28140[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28090 === (8))){
var inst_28045 = (state_28089[(14)]);
var inst_28043 = (state_28089[(9)]);
var inst_28044 = (state_28089[(12)]);
var inst_28058 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28059 = [inst_28043,inst_28044,inst_28045];
var inst_28060 = (new cljs.core.PersistentVector(null,3,(5),inst_28058,inst_28059,null));
var state_28089__$1 = state_28089;
var statearr_28117_28141 = state_28089__$1;
(statearr_28117_28141[(2)] = inst_28060);

(statearr_28117_28141[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto____0 = (function (){
var statearr_28118 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28118[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto__);

(statearr_28118[(1)] = (1));

return statearr_28118;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto____1 = (function (state_28089){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_28089);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e28119){var ex__13886__auto__ = e28119;
var statearr_28120_28142 = state_28089;
(statearr_28120_28142[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_28089[(4)]))){
var statearr_28121_28143 = state_28089;
(statearr_28121_28143[(1)] = cljs.core.first((state_28089[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__28144 = state_28089;
state_28089 = G__28144;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto__ = function(state_28089){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto____1.call(this,state_28089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_28122 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_28122[(6)] = c__13957__auto__);

return statearr_28122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_28190){
var state_val_28191 = (state_28190[(1)]);
if((state_val_28191 === (7))){
var state_28190__$1 = state_28190;
var statearr_28192_28230 = state_28190__$1;
(statearr_28192_28230[(2)] = null);

(statearr_28192_28230[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (20))){
var inst_28176 = (state_28190[(2)]);
var inst_28177 = fluree.db.util.async.throw_err(inst_28176);
var inst_28155 = inst_28177;
var state_28190__$1 = (function (){var statearr_28193 = state_28190;
(statearr_28193[(7)] = inst_28155);

return statearr_28193;
})();
var statearr_28194_28231 = state_28190__$1;
(statearr_28194_28231[(2)] = null);

(statearr_28194_28231[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (1))){
var state_28190__$1 = state_28190;
var statearr_28195_28232 = state_28190__$1;
(statearr_28195_28232[(2)] = null);

(statearr_28195_28232[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (4))){
var inst_28145 = (state_28190[(2)]);
var state_28190__$1 = state_28190;
var statearr_28196_28233 = state_28190__$1;
(statearr_28196_28233[(2)] = inst_28145);

(statearr_28196_28233[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (15))){
var inst_28172 = (state_28190[(8)]);
var inst_28155 = (state_28190[(7)]);
var inst_28172__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_28155);
var state_28190__$1 = (function (){var statearr_28197 = state_28190;
(statearr_28197[(8)] = inst_28172__$1);

return statearr_28197;
})();
if(cljs.core.truth_(inst_28172__$1)){
var statearr_28198_28234 = state_28190__$1;
(statearr_28198_28234[(1)] = (17));

} else {
var statearr_28199_28235 = state_28190__$1;
(statearr_28199_28235[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (13))){
var inst_28165 = (state_28190[(2)]);
var inst_28166 = fluree.db.util.async.throw_err(inst_28165);
var _ = (function (){var statearr_28200 = state_28190;
(statearr_28200[(4)] = cljs.core.rest((state_28190[(4)])));

return statearr_28200;
})();
var state_28190__$1 = state_28190;
var statearr_28201_28236 = state_28190__$1;
(statearr_28201_28236[(2)] = inst_28166);

(statearr_28201_28236[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (6))){
var inst_28153 = (state_28190[(2)]);
var inst_28154 = fluree.db.util.async.throw_err(inst_28153);
var inst_28155 = inst_28154;
var state_28190__$1 = (function (){var statearr_28202 = state_28190;
(statearr_28202[(7)] = inst_28155);

return statearr_28202;
})();
var statearr_28203_28237 = state_28190__$1;
(statearr_28203_28237[(2)] = null);

(statearr_28203_28237[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (17))){
var inst_28172 = (state_28190[(8)]);
var inst_28174 = fluree.db.dbproto._lookup_leaf(root_node,inst_28172);
var state_28190__$1 = state_28190;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28190__$1,(20),inst_28174);
} else {
if((state_val_28191 === (3))){
var inst_28188 = (state_28190[(2)]);
var state_28190__$1 = state_28190;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28190__$1,inst_28188);
} else {
if((state_val_28191 === (12))){
var _ = (function (){var statearr_28205 = state_28190;
(statearr_28205[(4)] = cljs.core.rest((state_28190[(4)])));

return statearr_28205;
})();
var state_28190__$1 = state_28190;
var ex28204 = (state_28190__$1[(2)]);
var statearr_28206_28238 = state_28190__$1;
(statearr_28206_28238[(5)] = ex28204);


var statearr_28207_28239 = state_28190__$1;
(statearr_28207_28239[(1)] = (11));

(statearr_28207_28239[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (2))){
var _ = (function (){var statearr_28208 = state_28190;
(statearr_28208[(4)] = cljs.core.cons((5),(state_28190[(4)])));

return statearr_28208;
})();
var inst_28151 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_28190__$1 = state_28190;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28190__$1,(6),inst_28151);
} else {
if((state_val_28191 === (19))){
var inst_28181 = (state_28190[(2)]);
var state_28190__$1 = state_28190;
var statearr_28209_28240 = state_28190__$1;
(statearr_28209_28240[(2)] = inst_28181);

(statearr_28209_28240[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (11))){
var inst_28157 = (state_28190[(2)]);
var state_28190__$1 = (function (){var statearr_28211 = state_28190;
(statearr_28211[(9)] = inst_28157);

return statearr_28211;
})();
var statearr_28212_28241 = state_28190__$1;
(statearr_28212_28241[(2)] = null);

(statearr_28212_28241[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (9))){
var inst_28155 = (state_28190[(7)]);
var _ = (function (){var statearr_28213 = state_28190;
(statearr_28213[(4)] = cljs.core.cons((12),(state_28190[(4)])));

return statearr_28213;
})();
var inst_28163 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_28155,t,novelty,fast_forward_db_QMARK_);
var state_28190__$1 = state_28190;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28190__$1,(13),inst_28163);
} else {
if((state_val_28191 === (5))){
var _ = (function (){var statearr_28214 = state_28190;
(statearr_28214[(4)] = cljs.core.rest((state_28190[(4)])));

return statearr_28214;
})();
var state_28190__$1 = state_28190;
var ex28210 = (state_28190__$1[(2)]);
var statearr_28215_28242 = state_28190__$1;
(statearr_28215_28242[(5)] = ex28210);


if((ex28210 instanceof Error)){
var statearr_28216_28243 = state_28190__$1;
(statearr_28216_28243[(1)] = (4));

(statearr_28216_28243[(5)] = null);

} else {
throw ex28210;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (14))){
var inst_28169 = (state_28190[(10)]);
var state_28190__$1 = state_28190;
var statearr_28217_28244 = state_28190__$1;
(statearr_28217_28244[(2)] = inst_28169);

(statearr_28217_28244[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (16))){
var inst_28183 = (state_28190[(2)]);
var state_28190__$1 = state_28190;
var statearr_28218_28245 = state_28190__$1;
(statearr_28218_28245[(2)] = inst_28183);

(statearr_28218_28245[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (10))){
var inst_28169 = (state_28190[(10)]);
var inst_28169__$1 = (state_28190[(2)]);
var state_28190__$1 = (function (){var statearr_28219 = state_28190;
(statearr_28219[(10)] = inst_28169__$1);

return statearr_28219;
})();
if(cljs.core.truth_(inst_28169__$1)){
var statearr_28220_28246 = state_28190__$1;
(statearr_28220_28246[(1)] = (14));

} else {
var statearr_28221_28247 = state_28190__$1;
(statearr_28221_28247[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (18))){
var state_28190__$1 = state_28190;
var statearr_28222_28248 = state_28190__$1;
(statearr_28222_28248[(2)] = null);

(statearr_28222_28248[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28191 === (8))){
var inst_28185 = (state_28190[(2)]);
var _ = (function (){var statearr_28223 = state_28190;
(statearr_28223[(4)] = cljs.core.rest((state_28190[(4)])));

return statearr_28223;
})();
var state_28190__$1 = state_28190;
var statearr_28224_28249 = state_28190__$1;
(statearr_28224_28249[(2)] = inst_28185);

(statearr_28224_28249[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto____0 = (function (){
var statearr_28225 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28225[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto__);

(statearr_28225[(1)] = (1));

return statearr_28225;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto____1 = (function (state_28190){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_28190);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e28226){var ex__13886__auto__ = e28226;
var statearr_28227_28250 = state_28190;
(statearr_28227_28250[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_28190[(4)]))){
var statearr_28228_28251 = state_28190;
(statearr_28228_28251[(1)] = cljs.core.first((state_28190[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__28252 = state_28190;
state_28190 = G__28252;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto__ = function(state_28190){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto____1.call(this,state_28190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_28229 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_28229[(6)] = c__13957__auto__);

return statearr_28229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__28259 = arguments.length;
switch (G__28259) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__28260 = (function (){var pred__28263 = cljs.core.identical_QMARK_;
var expr__28264 = test;
if(cljs.core.truth_((pred__28263.cljs$core$IFn$_invoke$arity$2 ? pred__28263.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__28264) : pred__28263.call(null,cljs.core._EQ_,expr__28264)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__28263.cljs$core$IFn$_invoke$arity$2 ? pred__28263.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__28264) : pred__28263.call(null,cljs.core._LT_,expr__28264)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__28263.cljs$core$IFn$_invoke$arity$2 ? pred__28263.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__28264) : pred__28263.call(null,cljs.core._LT__EQ_,expr__28264)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__28263.cljs$core$IFn$_invoke$arity$2 ? pred__28263.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__28264) : pred__28263.call(null,cljs.core._GT_,expr__28264)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__28263.cljs$core$IFn$_invoke$arity$2 ? pred__28263.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__28264) : pred__28263.call(null,cljs.core._GT__EQ_,expr__28264)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__28264)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28260,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28260,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28260,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28260,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_28629){
var state_val_28630 = (state_28629[(1)]);
if((state_val_28630 === (65))){
var inst_28444 = (state_28629[(7)]);
var inst_28450 = (state_28629[(2)]);
var state_28629__$1 = (function (){var statearr_28631 = state_28629;
(statearr_28631[(8)] = inst_28450);

return statearr_28631;
})();
if(cljs.core.truth_(inst_28444)){
var statearr_28632_28816 = state_28629__$1;
(statearr_28632_28816[(1)] = (66));

} else {
var statearr_28633_28817 = state_28629__$1;
(statearr_28633_28817[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (70))){
var inst_28621 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
var statearr_28634_28818 = state_28629__$1;
(statearr_28634_28818[(2)] = inst_28621);

(statearr_28634_28818[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (62))){
var inst_28443 = (state_28629[(2)]);
var inst_28444 = fluree.db.util.async.throw_err(inst_28443);
var inst_28445 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_28629__$1 = (function (){var statearr_28635 = state_28629;
(statearr_28635[(7)] = inst_28444);

return statearr_28635;
})();
if(cljs.core.truth_(inst_28445)){
var statearr_28636_28819 = state_28629__$1;
(statearr_28636_28819[(1)] = (63));

} else {
var statearr_28637_28820 = state_28629__$1;
(statearr_28637_28820[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (74))){
var inst_28385 = (state_28629[(9)]);
var inst_28424 = (state_28629[(10)]);
var inst_28455 = (state_28629[(11)]);
var inst_28463 = (state_28629[(12)]);
var inst_28425 = (state_28629[(13)]);
var inst_28297 = (state_28629[(14)]);
var inst_28440 = (state_28629[(15)]);
var inst_28450 = (state_28629[(8)]);
var inst_28403 = (state_28629[(16)]);
var inst_28367 = (state_28629[(17)]);
var inst_28471 = (state_28629[(18)]);
var inst_28322 = (state_28629[(19)]);
var inst_28435 = (state_28629[(20)]);
var inst_28434 = (state_28629[(21)]);
var inst_28417 = (state_28629[(22)]);
var inst_28293 = (state_28629[(23)]);
var inst_28303 = (state_28629[(24)]);
var inst_28429 = (state_28629[(25)]);
var inst_28414 = (state_28629[(26)]);
var inst_28355 = (state_28629[(27)]);
var inst_28457 = (state_28629[(28)]);
var inst_28454 = (state_28629[(29)]);
var inst_28301 = (state_28629[(30)]);
var inst_28456 = (state_28629[(31)]);
var inst_28302 = (state_28629[(32)]);
var inst_28412 = (state_28629[(33)]);
var inst_28423 = (state_28629[(34)]);
var inst_28354 = (state_28629[(35)]);
var inst_28394 = (state_28629[(36)]);
var inst_28416 = (state_28629[(37)]);
var inst_28444 = (state_28629[(7)]);
var inst_28376 = (state_28629[(38)]);
var inst_28291 = (state_28629[(39)]);
var inst_28453 = (state_28629[(40)]);
var inst_28413 = (state_28629[(41)]);
var inst_28298 = (state_28629[(42)]);
var inst_28430 = (state_28629[(43)]);
var inst_28286 = (state_28629[(44)]);
var inst_28313 = (state_28629[(45)]);
var inst_28290 = (state_28629[(46)]);
var inst_28358 = (state_28629[(47)]);
var inst_28473 = (function (){var no_filter_QMARK_ = inst_28450;
var G__28464 = inst_28471;
var t = inst_28430;
var max_limit_QMARK_ = inst_28424;
var next_node = inst_28453;
var fast_forward_db_QMARK_ = inst_28435;
var s1 = inst_28313;
var o2 = inst_28376;
var vec__28282 = inst_28355;
var t1 = inst_28290;
var predicate_fn = inst_28303;
var i = inst_28455;
var m1 = inst_28403;
var root_node = inst_28440;
var s2 = inst_28322;
var vec__28272 = inst_28286;
var p2 = inst_28394;
var permissions = inst_28425;
var limit = inst_28423;
var start_flake = inst_28413;
var flake_limit = inst_28417;
var offset = inst_28454;
var acc = inst_28457;
var t2 = inst_28297;
var map__28285 = inst_28416;
var op1 = inst_28291;
var o1 = inst_28367;
var end_flake = inst_28414;
var base_result = inst_28463;
var s = inst_28456;
var node_start = inst_28444;
var p1 = inst_28385;
var subject_fn = inst_28302;
var vec__28279 = inst_28354;
var object_fn = inst_28358;
var idx_compare = inst_28429;
var op2 = inst_28298;
var m2 = inst_28412;
var map__28278 = inst_28301;
var vec__28275 = inst_28293;
var novelty = inst_28434;
return (function (p1__28254_SHARP_){
var G__28638 = p1__28254_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__28638) : subject_fn.call(null,G__28638));
});
})();
var inst_28474 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_28473,inst_28471);
var state_28629__$1 = state_28629;
var statearr_28639_28821 = state_28629__$1;
(statearr_28639_28821[(2)] = inst_28474);

(statearr_28639_28821[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (110))){
var inst_28601 = (state_28629[(48)]);
var inst_28609 = (state_28629[(2)]);
var state_28629__$1 = (function (){var statearr_28640 = state_28629;
(statearr_28640[(49)] = inst_28609);

return statearr_28640;
})();
if(cljs.core.truth_(inst_28601)){
var statearr_28641_28822 = state_28629__$1;
(statearr_28641_28822[(1)] = (112));

} else {
var statearr_28642_28823 = state_28629__$1;
(statearr_28642_28823[(1)] = (113));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (7))){
var inst_28287 = (state_28629[(50)]);
var state_28629__$1 = state_28629;
var statearr_28643_28824 = state_28629__$1;
(statearr_28643_28824[(2)] = inst_28287);

(statearr_28643_28824[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (59))){
var state_28629__$1 = state_28629;
var statearr_28644_28825 = state_28629__$1;
(statearr_28644_28825[(2)] = fluree.db.util.core.max_long);

(statearr_28644_28825[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (86))){
var inst_28450 = (state_28629[(8)]);
var state_28629__$1 = state_28629;
var statearr_28645_28826 = state_28629__$1;
(statearr_28645_28826[(2)] = inst_28450);

(statearr_28645_28826[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (20))){
var state_28629__$1 = state_28629;
var statearr_28646_28827 = state_28629__$1;
(statearr_28646_28827[(2)] = null);

(statearr_28646_28827[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (72))){
var inst_28463 = (state_28629[(12)]);
var state_28629__$1 = state_28629;
var statearr_28647_28828 = state_28629__$1;
(statearr_28647_28828[(2)] = inst_28463);

(statearr_28647_28828[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (58))){
var inst_28418 = (state_28629[(51)]);
var state_28629__$1 = state_28629;
var statearr_28648_28829 = state_28629__$1;
(statearr_28648_28829[(2)] = inst_28418);

(statearr_28648_28829[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (60))){
var inst_28423 = (state_28629[(34)]);
var inst_28423__$1 = (state_28629[(2)]);
var inst_28424 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28423__$1,fluree.db.util.core.max_long);
var inst_28425 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_28426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28427 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_28428 = (new cljs.core.PersistentVector(null,3,(5),inst_28426,inst_28427,null));
var inst_28429 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_28428);
var inst_28430 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_28431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28432 = [cljs.core.cst$kw$novelty,idx];
var inst_28433 = (new cljs.core.PersistentVector(null,2,(5),inst_28431,inst_28432,null));
var inst_28434 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_28433);
var inst_28435 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_28436 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_28437 = fluree.db.dbproto._resolve(inst_28436);
var state_28629__$1 = (function (){var statearr_28649 = state_28629;
(statearr_28649[(10)] = inst_28424);

(statearr_28649[(13)] = inst_28425);

(statearr_28649[(20)] = inst_28435);

(statearr_28649[(21)] = inst_28434);

(statearr_28649[(25)] = inst_28429);

(statearr_28649[(34)] = inst_28423__$1);

(statearr_28649[(43)] = inst_28430);

return statearr_28649;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28629__$1,(61),inst_28437);
} else {
if((state_val_28630 === (27))){
var inst_28356 = (state_28629[(52)]);
var state_28629__$1 = state_28629;
var statearr_28650_28830 = state_28629__$1;
(statearr_28650_28830[(2)] = inst_28356);

(statearr_28650_28830[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (1))){
var state_28629__$1 = state_28629;
var statearr_28651_28831 = state_28629__$1;
(statearr_28651_28831[(2)] = null);

(statearr_28651_28831[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (69))){
var inst_28414 = (state_28629[(26)]);
var inst_28453 = (state_28629[(40)]);
var inst_28413 = (state_28629[(41)]);
var inst_28462 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_28453);
var inst_28463 = fluree.db.flake.subrange(inst_28462,start_test,inst_28413,end_test,inst_28414);
var inst_28465 = fluree.db.query.range.value_with_nil_pred(idx,inst_28413,inst_28414);
var state_28629__$1 = (function (){var statearr_28652 = state_28629;
(statearr_28652[(12)] = inst_28463);

return statearr_28652;
})();
if(inst_28465){
var statearr_28653_28832 = state_28629__$1;
(statearr_28653_28832[(1)] = (71));

} else {
var statearr_28654_28833 = state_28629__$1;
(statearr_28654_28833[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (101))){
var inst_28417 = (state_28629[(22)]);
var inst_28550 = (state_28629[(53)]);
var inst_28549 = (state_28629[(54)]);
var inst_28551 = (state_28629[(55)]);
var inst_28554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28555 = (inst_28551 - inst_28417);
var inst_28556 = (inst_28550 - inst_28555);
var inst_28557 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_28556,inst_28549);
var inst_28558 = [inst_28417,inst_28557];
var inst_28559 = (new cljs.core.PersistentVector(null,2,(5),inst_28554,inst_28558,null));
var state_28629__$1 = state_28629;
var statearr_28655_28834 = state_28629__$1;
(statearr_28655_28834[(2)] = inst_28559);

(statearr_28655_28834[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (24))){
var inst_28296 = (state_28629[(56)]);
var inst_28297 = (state_28629[(14)]);
var inst_28336 = (state_28629[(57)]);
var inst_28304 = (state_28629[(58)]);
var inst_28322 = (state_28629[(19)]);
var inst_28292 = (state_28629[(59)]);
var inst_28293 = (state_28629[(23)]);
var inst_28289 = (state_28629[(60)]);
var inst_28303 = (state_28629[(24)]);
var inst_28301 = (state_28629[(30)]);
var inst_28302 = (state_28629[(32)]);
var inst_28299 = (state_28629[(61)]);
var inst_28288 = (state_28629[(62)]);
var inst_28295 = (state_28629[(63)]);
var inst_28291 = (state_28629[(39)]);
var inst_28298 = (state_28629[(42)]);
var inst_28286 = (state_28629[(44)]);
var inst_28313 = (state_28629[(45)]);
var inst_28290 = (state_28629[(46)]);
var inst_28346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28348 = [null,null];
var inst_28349 = (new cljs.core.PersistentVector(null,2,(5),inst_28347,inst_28348,null));
var inst_28350 = (function (){var bool = inst_28336;
var s1 = inst_28313;
var o2 = inst_28296;
var t1 = inst_28290;
var predicate_fn = inst_28303;
var m1 = inst_28292;
var s2 = inst_28322;
var vec__28272 = inst_28286;
var p2 = inst_28295;
var t2 = inst_28297;
var op1 = inst_28291;
var o1 = inst_28289;
var p1 = inst_28288;
var subject_fn = inst_28302;
var object_fn = inst_28304;
var op2 = inst_28298;
var m2 = inst_28299;
var map__28278 = inst_28301;
var vec__28275 = inst_28293;
var temp__5755__auto__ = inst_28336;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_28351 = [inst_28349,inst_28350];
var inst_28352 = (new cljs.core.PersistentVector(null,2,(5),inst_28346,inst_28351,null));
var state_28629__$1 = state_28629;
var statearr_28656_28835 = state_28629__$1;
(statearr_28656_28835[(2)] = inst_28352);

(statearr_28656_28835[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (102))){
var inst_28549 = (state_28629[(54)]);
var inst_28551 = (state_28629[(55)]);
var inst_28561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28562 = [inst_28551,inst_28549];
var inst_28563 = (new cljs.core.PersistentVector(null,2,(5),inst_28561,inst_28562,null));
var state_28629__$1 = state_28629;
var statearr_28657_28836 = state_28629__$1;
(statearr_28657_28836[(2)] = inst_28563);

(statearr_28657_28836[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (55))){
var state_28629__$1 = state_28629;
var statearr_28658_28837 = state_28629__$1;
(statearr_28658_28837[(2)] = (2147483647));

(statearr_28658_28837[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (85))){
var inst_28499 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
if(cljs.core.truth_(inst_28499)){
var statearr_28659_28838 = state_28629__$1;
(statearr_28659_28838[(1)] = (89));

} else {
var statearr_28660_28839 = state_28629__$1;
(statearr_28660_28839[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (39))){
var inst_28295 = (state_28629[(63)]);
var inst_28385 = (state_28629[(2)]);
var inst_28386 = (inst_28295 == null);
var state_28629__$1 = (function (){var statearr_28661 = state_28629;
(statearr_28661[(9)] = inst_28385);

return statearr_28661;
})();
if(cljs.core.truth_(inst_28386)){
var statearr_28662_28840 = state_28629__$1;
(statearr_28662_28840[(1)] = (40));

} else {
var statearr_28663_28841 = state_28629__$1;
(statearr_28663_28841[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (88))){
var inst_28496 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
var statearr_28664_28842 = state_28629__$1;
(statearr_28664_28842[(2)] = inst_28496);

(statearr_28664_28842[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (46))){
var inst_28292 = (state_28629[(59)]);
var state_28629__$1 = state_28629;
var statearr_28665_28843 = state_28629__$1;
(statearr_28665_28843[(2)] = inst_28292);

(statearr_28665_28843[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (4))){
var inst_28266 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
var statearr_28666_28844 = state_28629__$1;
(statearr_28666_28844[(2)] = inst_28266);

(statearr_28666_28844[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (77))){
var inst_28385 = (state_28629[(9)]);
var inst_28424 = (state_28629[(10)]);
var inst_28455 = (state_28629[(11)]);
var inst_28463 = (state_28629[(12)]);
var inst_28425 = (state_28629[(13)]);
var inst_28297 = (state_28629[(14)]);
var inst_28440 = (state_28629[(15)]);
var inst_28450 = (state_28629[(8)]);
var inst_28403 = (state_28629[(16)]);
var inst_28367 = (state_28629[(17)]);
var inst_28322 = (state_28629[(19)]);
var inst_28435 = (state_28629[(20)]);
var inst_28434 = (state_28629[(21)]);
var inst_28417 = (state_28629[(22)]);
var inst_28293 = (state_28629[(23)]);
var inst_28303 = (state_28629[(24)]);
var inst_28429 = (state_28629[(25)]);
var inst_28414 = (state_28629[(26)]);
var inst_28355 = (state_28629[(27)]);
var inst_28457 = (state_28629[(28)]);
var inst_28454 = (state_28629[(29)]);
var inst_28301 = (state_28629[(30)]);
var inst_28456 = (state_28629[(31)]);
var inst_28302 = (state_28629[(32)]);
var inst_28412 = (state_28629[(33)]);
var inst_28423 = (state_28629[(34)]);
var inst_28354 = (state_28629[(35)]);
var inst_28394 = (state_28629[(36)]);
var inst_28416 = (state_28629[(37)]);
var inst_28444 = (state_28629[(7)]);
var inst_28376 = (state_28629[(38)]);
var inst_28291 = (state_28629[(39)]);
var inst_28453 = (state_28629[(40)]);
var inst_28477 = (state_28629[(64)]);
var inst_28413 = (state_28629[(41)]);
var inst_28298 = (state_28629[(42)]);
var inst_28430 = (state_28629[(43)]);
var inst_28286 = (state_28629[(44)]);
var inst_28313 = (state_28629[(45)]);
var inst_28290 = (state_28629[(46)]);
var inst_28358 = (state_28629[(47)]);
var inst_28479 = (function (){var no_filter_QMARK_ = inst_28450;
var G__28464 = inst_28477;
var t = inst_28430;
var max_limit_QMARK_ = inst_28424;
var next_node = inst_28453;
var fast_forward_db_QMARK_ = inst_28435;
var s1 = inst_28313;
var o2 = inst_28376;
var vec__28282 = inst_28355;
var t1 = inst_28290;
var predicate_fn = inst_28303;
var i = inst_28455;
var m1 = inst_28403;
var root_node = inst_28440;
var s2 = inst_28322;
var vec__28272 = inst_28286;
var p2 = inst_28394;
var permissions = inst_28425;
var limit = inst_28423;
var start_flake = inst_28413;
var flake_limit = inst_28417;
var offset = inst_28454;
var acc = inst_28457;
var t2 = inst_28297;
var map__28285 = inst_28416;
var op1 = inst_28291;
var o1 = inst_28367;
var end_flake = inst_28414;
var base_result = inst_28463;
var s = inst_28456;
var node_start = inst_28444;
var p1 = inst_28385;
var subject_fn = inst_28302;
var vec__28279 = inst_28354;
var object_fn = inst_28358;
var idx_compare = inst_28429;
var op2 = inst_28298;
var m2 = inst_28412;
var map__28278 = inst_28301;
var vec__28275 = inst_28293;
var novelty = inst_28434;
return (function (p1__28255_SHARP_){
var G__28667 = p1__28255_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__28667) : predicate_fn.call(null,G__28667));
});
})();
var inst_28480 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_28479,inst_28477);
var state_28629__$1 = state_28629;
var statearr_28668_28845 = state_28629__$1;
(statearr_28668_28845[(2)] = inst_28480);

(statearr_28668_28845[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (106))){
var inst_28490 = (state_28629[(65)]);
var state_28629__$1 = state_28629;
var statearr_28669_28846 = state_28629__$1;
(statearr_28669_28846[(2)] = inst_28490);

(statearr_28669_28846[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (95))){
var inst_28532 = (state_28629[(66)]);
var inst_28531 = (state_28629[(67)]);
var inst_28456 = (state_28629[(31)]);
var inst_28423 = (state_28629[(34)]);
var inst_28523 = (state_28629[(68)]);
var inst_28533 = (state_28629[(69)]);
var inst_28531__$1 = cljs.core.count(inst_28523);
var inst_28532__$1 = (inst_28456 + inst_28531__$1);
var inst_28533__$1 = (inst_28532__$1 - inst_28423);
var inst_28534 = cljs.core.pos_int_QMARK_(inst_28533__$1);
var state_28629__$1 = (function (){var statearr_28670 = state_28629;
(statearr_28670[(66)] = inst_28532__$1);

(statearr_28670[(67)] = inst_28531__$1);

(statearr_28670[(69)] = inst_28533__$1);

return statearr_28670;
})();
if(inst_28534){
var statearr_28671_28847 = state_28629__$1;
(statearr_28671_28847[(1)] = (98));

} else {
var statearr_28672_28848 = state_28629__$1;
(statearr_28672_28848[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (54))){
var inst_28385 = (state_28629[(9)]);
var inst_28418 = (state_28629[(51)]);
var inst_28297 = (state_28629[(14)]);
var inst_28403 = (state_28629[(16)]);
var inst_28367 = (state_28629[(17)]);
var inst_28322 = (state_28629[(19)]);
var inst_28412 = (state_28629[(33)]);
var inst_28394 = (state_28629[(36)]);
var inst_28416 = (state_28629[(37)]);
var inst_28376 = (state_28629[(38)]);
var inst_28291 = (state_28629[(39)]);
var inst_28298 = (state_28629[(42)]);
var inst_28313 = (state_28629[(45)]);
var inst_28290 = (state_28629[(46)]);
var inst_28412__$1 = (state_28629[(2)]);
var inst_28413 = fluree.db.flake.__GT_Flake(inst_28313,inst_28385,inst_28367,inst_28290,inst_28291,inst_28403);
var inst_28414 = fluree.db.flake.__GT_Flake(inst_28322,inst_28394,inst_28376,inst_28297,inst_28298,inst_28412__$1);
var inst_28415 = opts;
var inst_28416__$1 = cljs.core.__destructure_map(inst_28415);
var inst_28417 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_28416__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_28418__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28416__$1,cljs.core.cst$kw$limit);
var inst_28419 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_28416__$1,cljs.core.cst$kw$offset,(0));
var state_28629__$1 = (function (){var statearr_28673 = state_28629;
(statearr_28673[(51)] = inst_28418__$1);

(statearr_28673[(22)] = inst_28417);

(statearr_28673[(26)] = inst_28414);

(statearr_28673[(33)] = inst_28412__$1);

(statearr_28673[(37)] = inst_28416__$1);

(statearr_28673[(70)] = inst_28419);

(statearr_28673[(41)] = inst_28413);

return statearr_28673;
})();
if(cljs.core.truth_(inst_28418__$1)){
var statearr_28674_28849 = state_28629__$1;
(statearr_28674_28849[(1)] = (58));

} else {
var statearr_28675_28850 = state_28629__$1;
(statearr_28675_28850[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (92))){
var inst_28455 = (state_28629[(11)]);
var inst_28512 = (state_28629[(71)]);
var inst_28457 = (state_28629[(28)]);
var inst_28454 = (state_28629[(29)]);
var inst_28456 = (state_28629[(31)]);
var inst_28515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28516 = (inst_28454 - inst_28512);
var inst_28517 = [inst_28516,inst_28455,inst_28456,inst_28457];
var inst_28518 = (new cljs.core.PersistentVector(null,4,(5),inst_28515,inst_28517,null));
var state_28629__$1 = state_28629;
var statearr_28676_28851 = state_28629__$1;
(statearr_28676_28851[(2)] = inst_28518);

(statearr_28676_28851[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (104))){
var inst_28574 = (state_28629[(2)]);
var inst_28575 = fluree.db.util.async.throw_err(inst_28574);
var state_28629__$1 = state_28629;
var statearr_28677_28852 = state_28629__$1;
(statearr_28677_28852[(2)] = inst_28575);

(statearr_28677_28852[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (15))){
var inst_28296 = (state_28629[(56)]);
var inst_28326 = cljs.core.boolean_QMARK_(inst_28296);
var state_28629__$1 = state_28629;
if(inst_28326){
var statearr_28678_28853 = state_28629__$1;
(statearr_28678_28853[(1)] = (17));

} else {
var statearr_28679_28854 = state_28629__$1;
(statearr_28679_28854[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (48))){
var inst_28299 = (state_28629[(61)]);
var inst_28403 = (state_28629[(2)]);
var state_28629__$1 = (function (){var statearr_28680 = state_28629;
(statearr_28680[(16)] = inst_28403);

return statearr_28680;
})();
if(cljs.core.truth_(inst_28299)){
var statearr_28681_28855 = state_28629__$1;
(statearr_28681_28855[(1)] = (52));

} else {
var statearr_28682_28856 = state_28629__$1;
(statearr_28682_28856[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (50))){
var state_28629__$1 = state_28629;
var statearr_28683_28857 = state_28629__$1;
(statearr_28683_28857[(2)] = (2147483647));

(statearr_28683_28857[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (116))){
var inst_28609 = (state_28629[(49)]);
var inst_28592 = (state_28629[(72)]);
var inst_28591 = (state_28629[(73)]);
var inst_28590 = (state_28629[(74)]);
var inst_28589 = (state_28629[(75)]);
var inst_28453 = inst_28609;
var inst_28454 = inst_28589;
var inst_28455 = inst_28590;
var inst_28456 = inst_28591;
var inst_28457 = inst_28592;
var state_28629__$1 = (function (){var statearr_28684 = state_28629;
(statearr_28684[(11)] = inst_28455);

(statearr_28684[(28)] = inst_28457);

(statearr_28684[(29)] = inst_28454);

(statearr_28684[(31)] = inst_28456);

(statearr_28684[(40)] = inst_28453);

return statearr_28684;
})();
var statearr_28685_28858 = state_28629__$1;
(statearr_28685_28858[(2)] = null);

(statearr_28685_28858[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (75))){
var inst_28471 = (state_28629[(18)]);
var state_28629__$1 = state_28629;
var statearr_28686_28859 = state_28629__$1;
(statearr_28686_28859[(2)] = inst_28471);

(statearr_28686_28859[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (99))){
var inst_28532 = (state_28629[(66)]);
var inst_28541 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28542 = [inst_28532,inst_28532];
var inst_28543 = (new cljs.core.PersistentVector(null,2,(5),inst_28541,inst_28542,null));
var state_28629__$1 = state_28629;
var statearr_28687_28860 = state_28629__$1;
(statearr_28687_28860[(2)] = inst_28543);

(statearr_28687_28860[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (21))){
var state_28629__$1 = state_28629;
var statearr_28688_28861 = state_28629__$1;
(statearr_28688_28861[(2)] = null);

(statearr_28688_28861[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (31))){
var inst_28357 = (state_28629[(76)]);
var state_28629__$1 = state_28629;
var statearr_28689_28862 = state_28629__$1;
(statearr_28689_28862[(2)] = inst_28357);

(statearr_28689_28862[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (113))){
var inst_28601 = (state_28629[(48)]);
var state_28629__$1 = state_28629;
var statearr_28690_28863 = state_28629__$1;
(statearr_28690_28863[(2)] = inst_28601);

(statearr_28690_28863[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (32))){
var inst_28288 = (state_28629[(62)]);
var inst_28376 = (state_28629[(2)]);
var inst_28377 = (inst_28288 == null);
var state_28629__$1 = (function (){var statearr_28691 = state_28629;
(statearr_28691[(38)] = inst_28376);

return statearr_28691;
})();
if(cljs.core.truth_(inst_28377)){
var statearr_28692_28864 = state_28629__$1;
(statearr_28692_28864[(1)] = (34));

} else {
var statearr_28693_28865 = state_28629__$1;
(statearr_28693_28865[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (40))){
var inst_28376 = (state_28629[(38)]);
var state_28629__$1 = state_28629;
var statearr_28694_28866 = state_28629__$1;
(statearr_28694_28866[(2)] = inst_28376);

(statearr_28694_28866[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (91))){
var inst_28490 = (state_28629[(65)]);
var inst_28588 = (state_28629[(2)]);
var inst_28589 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28588,(0),null);
var inst_28590 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28588,(1),null);
var inst_28591 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28588,(2),null);
var inst_28592 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28588,(3),null);
var state_28629__$1 = (function (){var statearr_28695 = state_28629;
(statearr_28695[(72)] = inst_28592);

(statearr_28695[(73)] = inst_28591);

(statearr_28695[(74)] = inst_28590);

(statearr_28695[(75)] = inst_28589);

return statearr_28695;
})();
if(cljs.core.truth_(inst_28490)){
var statearr_28696_28867 = state_28629__$1;
(statearr_28696_28867[(1)] = (105));

} else {
var statearr_28697_28868 = state_28629__$1;
(statearr_28697_28868[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (117))){
var inst_28619 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
var statearr_28698_28869 = state_28629__$1;
(statearr_28698_28869[(2)] = inst_28619);

(statearr_28698_28869[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (108))){
var inst_28440 = (state_28629[(15)]);
var inst_28435 = (state_28629[(20)]);
var inst_28434 = (state_28629[(21)]);
var inst_28490 = (state_28629[(65)]);
var inst_28430 = (state_28629[(43)]);
var inst_28603 = fluree.db.query.range.find_next_valid_node(inst_28440,inst_28490,inst_28430,inst_28434,inst_28435);
var state_28629__$1 = state_28629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28629__$1,(111),inst_28603);
} else {
if((state_val_28630 === (56))){
var state_28629__$1 = state_28629;
var statearr_28699_28870 = state_28629__$1;
(statearr_28699_28870[(2)] = fluree.db.util.core.min_integer);

(statearr_28699_28870[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (33))){
var inst_28372 = (state_28629[(2)]);
var inst_28373 = fluree.db.util.async.throw_err(inst_28372);
var state_28629__$1 = state_28629;
var statearr_28700_28871 = state_28629__$1;
(statearr_28700_28871[(2)] = inst_28373);

(statearr_28700_28871[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (13))){
var inst_28318 = (state_28629[(2)]);
var inst_28319 = fluree.db.util.async.throw_err(inst_28318);
var state_28629__$1 = state_28629;
var statearr_28701_28872 = state_28629__$1;
(statearr_28701_28872[(2)] = inst_28319);

(statearr_28701_28872[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (22))){
var inst_28332 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
var statearr_28702_28873 = state_28629__$1;
(statearr_28702_28873[(2)] = inst_28332);

(statearr_28702_28873[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (90))){
var inst_28385 = (state_28629[(9)]);
var inst_28424 = (state_28629[(10)]);
var inst_28455 = (state_28629[(11)]);
var inst_28463 = (state_28629[(12)]);
var inst_28425 = (state_28629[(13)]);
var inst_28297 = (state_28629[(14)]);
var inst_28440 = (state_28629[(15)]);
var inst_28450 = (state_28629[(8)]);
var inst_28403 = (state_28629[(16)]);
var inst_28367 = (state_28629[(17)]);
var inst_28322 = (state_28629[(19)]);
var inst_28435 = (state_28629[(20)]);
var inst_28434 = (state_28629[(21)]);
var inst_28417 = (state_28629[(22)]);
var inst_28490 = (state_28629[(65)]);
var inst_28293 = (state_28629[(23)]);
var inst_28303 = (state_28629[(24)]);
var inst_28429 = (state_28629[(25)]);
var inst_28414 = (state_28629[(26)]);
var inst_28512 = (state_28629[(71)]);
var inst_28355 = (state_28629[(27)]);
var inst_28457 = (state_28629[(28)]);
var inst_28454 = (state_28629[(29)]);
var inst_28301 = (state_28629[(30)]);
var inst_28456 = (state_28629[(31)]);
var inst_28302 = (state_28629[(32)]);
var inst_28412 = (state_28629[(33)]);
var inst_28423 = (state_28629[(34)]);
var inst_28354 = (state_28629[(35)]);
var inst_28394 = (state_28629[(36)]);
var inst_28416 = (state_28629[(37)]);
var inst_28444 = (state_28629[(7)]);
var inst_28376 = (state_28629[(38)]);
var inst_28291 = (state_28629[(39)]);
var inst_28453 = (state_28629[(40)]);
var inst_28489 = (state_28629[(78)]);
var inst_28511 = (state_28629[(77)]);
var inst_28413 = (state_28629[(41)]);
var inst_28298 = (state_28629[(42)]);
var inst_28430 = (state_28629[(43)]);
var inst_28286 = (state_28629[(44)]);
var inst_28313 = (state_28629[(45)]);
var inst_28290 = (state_28629[(46)]);
var inst_28358 = (state_28629[(47)]);
var inst_28510 = (function (){var no_filter_QMARK_ = inst_28450;
var base_result_SINGLEQUOTE_ = inst_28489;
var t = inst_28430;
var max_limit_QMARK_ = inst_28424;
var next_node = inst_28453;
var fast_forward_db_QMARK_ = inst_28435;
var s1 = inst_28313;
var o2 = inst_28376;
var vec__28282 = inst_28355;
var t1 = inst_28290;
var predicate_fn = inst_28303;
var i = inst_28455;
var rhs = inst_28490;
var m1 = inst_28403;
var root_node = inst_28440;
var s2 = inst_28322;
var vec__28272 = inst_28286;
var p2 = inst_28394;
var permissions = inst_28425;
var limit = inst_28423;
var start_flake = inst_28413;
var flake_limit = inst_28417;
var offset = inst_28454;
var acc = inst_28457;
var t2 = inst_28297;
var map__28285 = inst_28416;
var op1 = inst_28291;
var o1 = inst_28367;
var end_flake = inst_28414;
var base_result = inst_28463;
var s = inst_28456;
var node_start = inst_28444;
var p1 = inst_28385;
var subject_fn = inst_28302;
var vec__28279 = inst_28354;
var object_fn = inst_28358;
var idx_compare = inst_28429;
var op2 = inst_28298;
var m2 = inst_28412;
var map__28278 = inst_28301;
var vec__28275 = inst_28293;
var novelty = inst_28434;
return (function (p1__28257_SHARP_){
return p1__28257_SHARP_.s;
});
})();
var inst_28511__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_28510,inst_28489);
var inst_28512__$1 = cljs.core.count(inst_28511__$1);
var inst_28513 = (inst_28454 > inst_28512__$1);
var state_28629__$1 = (function (){var statearr_28703 = state_28629;
(statearr_28703[(71)] = inst_28512__$1);

(statearr_28703[(77)] = inst_28511__$1);

return statearr_28703;
})();
if(cljs.core.truth_(inst_28513)){
var statearr_28704_28874 = state_28629__$1;
(statearr_28704_28874[(1)] = (92));

} else {
var statearr_28705_28875 = state_28629__$1;
(statearr_28705_28875[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (109))){
var state_28629__$1 = state_28629;
var statearr_28706_28876 = state_28629__$1;
(statearr_28706_28876[(2)] = null);

(statearr_28706_28876[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (36))){
var inst_28381 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
if(cljs.core.truth_(inst_28381)){
var statearr_28707_28877 = state_28629__$1;
(statearr_28707_28877[(1)] = (37));

} else {
var statearr_28708_28878 = state_28629__$1;
(statearr_28708_28878[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (41))){
var state_28629__$1 = state_28629;
var statearr_28709_28879 = state_28629__$1;
(statearr_28709_28879[(2)] = false);

(statearr_28709_28879[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (89))){
var inst_28455 = (state_28629[(11)]);
var inst_28417 = (state_28629[(22)]);
var inst_28457 = (state_28629[(28)]);
var inst_28456 = (state_28629[(31)]);
var inst_28489 = (state_28629[(78)]);
var inst_28501 = cljs.core.count(inst_28489);
var inst_28502 = (inst_28417 - inst_28455);
var inst_28503 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_28502,inst_28489);
var inst_28504 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28457,inst_28503);
var inst_28505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28506 = (inst_28455 + inst_28501);
var inst_28507 = [(0),inst_28506,inst_28456,inst_28504];
var inst_28508 = (new cljs.core.PersistentVector(null,4,(5),inst_28505,inst_28507,null));
var state_28629__$1 = state_28629;
var statearr_28710_28880 = state_28629__$1;
(statearr_28710_28880[(2)] = inst_28508);

(statearr_28710_28880[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (100))){
var inst_28455 = (state_28629[(11)]);
var inst_28417 = (state_28629[(22)]);
var inst_28550 = (state_28629[(53)]);
var inst_28549 = (state_28629[(54)]);
var inst_28551 = (state_28629[(55)]);
var inst_28523 = (state_28629[(68)]);
var inst_28545 = (state_28629[(2)]);
var inst_28546 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28545,(0),null);
var inst_28547 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28545,(1),null);
var inst_28548 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_28547,inst_28523);
var inst_28549__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_28548);
var inst_28550__$1 = cljs.core.count(inst_28549__$1);
var inst_28551__$1 = (inst_28455 + inst_28550__$1);
var inst_28552 = (inst_28551__$1 > inst_28417);
var state_28629__$1 = (function (){var statearr_28711 = state_28629;
(statearr_28711[(53)] = inst_28550__$1);

(statearr_28711[(79)] = inst_28546);

(statearr_28711[(54)] = inst_28549__$1);

(statearr_28711[(55)] = inst_28551__$1);

return statearr_28711;
})();
if(cljs.core.truth_(inst_28552)){
var statearr_28712_28881 = state_28629__$1;
(statearr_28712_28881[(1)] = (101));

} else {
var statearr_28713_28882 = state_28629__$1;
(statearr_28713_28882[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (43))){
var state_28629__$1 = state_28629;
var statearr_28714_28883 = state_28629__$1;
(statearr_28714_28883[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_28714_28883[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (61))){
var inst_28440 = (state_28629[(15)]);
var inst_28435 = (state_28629[(20)]);
var inst_28434 = (state_28629[(21)]);
var inst_28413 = (state_28629[(41)]);
var inst_28430 = (state_28629[(43)]);
var inst_28439 = (state_28629[(2)]);
var inst_28440__$1 = fluree.db.util.async.throw_err(inst_28439);
var inst_28441 = fluree.db.query.range.find_next_valid_node(inst_28440__$1,inst_28413,inst_28430,inst_28434,inst_28435);
var state_28629__$1 = (function (){var statearr_28715 = state_28629;
(statearr_28715[(15)] = inst_28440__$1);

return statearr_28715;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28629__$1,(62),inst_28441);
} else {
if((state_val_28630 === (29))){
var inst_28363 = (state_28629[(2)]);
var inst_28364 = fluree.db.util.async.throw_err(inst_28363);
var state_28629__$1 = state_28629;
var statearr_28716_28884 = state_28629__$1;
(statearr_28716_28884[(2)] = inst_28364);

(statearr_28716_28884[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (44))){
var inst_28295 = (state_28629[(63)]);
var state_28629__$1 = state_28629;
var statearr_28717_28885 = state_28629__$1;
(statearr_28717_28885[(2)] = inst_28295);

(statearr_28717_28885[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (93))){
var inst_28450 = (state_28629[(8)]);
var inst_28454 = (state_28629[(29)]);
var inst_28511 = (state_28629[(77)]);
var inst_28523 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_28454,inst_28511);
var state_28629__$1 = (function (){var statearr_28718 = state_28629;
(statearr_28718[(68)] = inst_28523);

return statearr_28718;
})();
if(cljs.core.truth_(inst_28450)){
var statearr_28719_28886 = state_28629__$1;
(statearr_28719_28886[(1)] = (95));

} else {
var statearr_28720_28887 = state_28629__$1;
(statearr_28720_28887[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (6))){
var inst_28287 = (state_28629[(50)]);
var inst_28307 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28287);
var state_28629__$1 = state_28629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28629__$1,(9),inst_28307);
} else {
if((state_val_28630 === (111))){
var inst_28605 = (state_28629[(2)]);
var inst_28606 = fluree.db.util.async.throw_err(inst_28605);
var state_28629__$1 = state_28629;
var statearr_28721_28888 = state_28629__$1;
(statearr_28721_28888[(2)] = inst_28606);

(statearr_28721_28888[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (28))){
var inst_28357 = (state_28629[(76)]);
var inst_28367 = (state_28629[(2)]);
var inst_28368 = fluree.db.util.core.pred_ident_QMARK_(inst_28357);
var state_28629__$1 = (function (){var statearr_28722 = state_28629;
(statearr_28722[(17)] = inst_28367);

return statearr_28722;
})();
if(inst_28368){
var statearr_28723_28889 = state_28629__$1;
(statearr_28723_28889[(1)] = (30));

} else {
var statearr_28724_28890 = state_28629__$1;
(statearr_28724_28890[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (64))){
var state_28629__$1 = state_28629;
var statearr_28725_28891 = state_28629__$1;
(statearr_28725_28891[(2)] = true);

(statearr_28725_28891[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (103))){
var inst_28546 = (state_28629[(79)]);
var inst_28565 = (state_28629[(2)]);
var inst_28566 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28565,(0),null);
var inst_28567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28565,(1),null);
var inst_28568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28569 = [inst_28566,inst_28546,inst_28567];
var inst_28570 = (new cljs.core.PersistentVector(null,3,(5),inst_28568,inst_28569,null));
var state_28629__$1 = state_28629;
var statearr_28726_28892 = state_28629__$1;
(statearr_28726_28892[(2)] = inst_28570);

(statearr_28726_28892[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (51))){
var inst_28401 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
var statearr_28727_28893 = state_28629__$1;
(statearr_28727_28893[(2)] = inst_28401);

(statearr_28727_28893[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (25))){
var inst_28356 = (state_28629[(52)]);
var inst_28355 = (state_28629[(27)]);
var inst_28354 = (state_28629[(35)]);
var inst_28354__$1 = (state_28629[(2)]);
var inst_28355__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28354__$1,(0),null);
var inst_28356__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28355__$1,(0),null);
var inst_28357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28355__$1,(1),null);
var inst_28358 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28354__$1,(1),null);
var inst_28359 = fluree.db.util.core.pred_ident_QMARK_(inst_28356__$1);
var state_28629__$1 = (function (){var statearr_28728 = state_28629;
(statearr_28728[(52)] = inst_28356__$1);

(statearr_28728[(27)] = inst_28355__$1);

(statearr_28728[(35)] = inst_28354__$1);

(statearr_28728[(76)] = inst_28357);

(statearr_28728[(47)] = inst_28358);

return statearr_28728;
})();
if(inst_28359){
var statearr_28729_28894 = state_28629__$1;
(statearr_28729_28894[(1)] = (26));

} else {
var statearr_28730_28895 = state_28629__$1;
(statearr_28730_28895[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (34))){
var inst_28367 = (state_28629[(17)]);
var state_28629__$1 = state_28629;
var statearr_28731_28896 = state_28629__$1;
(statearr_28731_28896[(2)] = inst_28367);

(statearr_28731_28896[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (17))){
var inst_28296 = (state_28629[(56)]);
var state_28629__$1 = state_28629;
var statearr_28732_28897 = state_28629__$1;
(statearr_28732_28897[(2)] = inst_28296);

(statearr_28732_28897[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (3))){
var inst_28627 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28629__$1,inst_28627);
} else {
if((state_val_28630 === (12))){
var inst_28289 = (state_28629[(60)]);
var inst_28322 = (state_28629[(2)]);
var inst_28323 = cljs.core.boolean_QMARK_(inst_28289);
var state_28629__$1 = (function (){var statearr_28733 = state_28629;
(statearr_28733[(19)] = inst_28322);

return statearr_28733;
})();
if(inst_28323){
var statearr_28734_28898 = state_28629__$1;
(statearr_28734_28898[(1)] = (14));

} else {
var statearr_28735_28899 = state_28629__$1;
(statearr_28735_28899[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (2))){
var inst_28293 = (state_28629[(23)]);
var inst_28287 = (state_28629[(50)]);
var inst_28301 = (state_28629[(30)]);
var inst_28286 = (state_28629[(44)]);
var _ = (function (){var statearr_28736 = state_28629;
(statearr_28736[(4)] = cljs.core.cons((5),(state_28629[(4)])));

return statearr_28736;
})();
var inst_28286__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_28287__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28286__$1,(0),null);
var inst_28288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28286__$1,(1),null);
var inst_28289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28286__$1,(2),null);
var inst_28290 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28286__$1,(3),null);
var inst_28291 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28286__$1,(4),null);
var inst_28292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28286__$1,(5),null);
var inst_28293__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_28294 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28293__$1,(0),null);
var inst_28295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28293__$1,(1),null);
var inst_28296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28293__$1,(2),null);
var inst_28297 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28293__$1,(3),null);
var inst_28298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28293__$1,(4),null);
var inst_28299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28293__$1,(5),null);
var inst_28300 = opts;
var inst_28301__$1 = cljs.core.__destructure_map(inst_28300);
var inst_28302 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28301__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_28303 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28301__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_28304 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28301__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_28305 = fluree.db.util.core.pred_ident_QMARK_(inst_28287__$1);
var state_28629__$1 = (function (){var statearr_28737 = state_28629;
(statearr_28737[(56)] = inst_28296);

(statearr_28737[(14)] = inst_28297);

(statearr_28737[(80)] = inst_28294);

(statearr_28737[(58)] = inst_28304);

(statearr_28737[(59)] = inst_28292);

(statearr_28737[(23)] = inst_28293__$1);

(statearr_28737[(50)] = inst_28287__$1);

(statearr_28737[(60)] = inst_28289);

(statearr_28737[(24)] = inst_28303);

(statearr_28737[(30)] = inst_28301__$1);

(statearr_28737[(32)] = inst_28302);

(statearr_28737[(61)] = inst_28299);

(statearr_28737[(62)] = inst_28288);

(statearr_28737[(63)] = inst_28295);

(statearr_28737[(39)] = inst_28291);

(statearr_28737[(42)] = inst_28298);

(statearr_28737[(44)] = inst_28286__$1);

(statearr_28737[(46)] = inst_28290);

return statearr_28737;
})();
if(inst_28305){
var statearr_28738_28900 = state_28629__$1;
(statearr_28738_28900[(1)] = (6));

} else {
var statearr_28739_28901 = state_28629__$1;
(statearr_28739_28901[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (66))){
var inst_28444 = (state_28629[(7)]);
var inst_28419 = (state_28629[(70)]);
var inst_28452 = cljs.core.PersistentVector.EMPTY;
var inst_28453 = inst_28444;
var inst_28454 = inst_28419;
var inst_28455 = (0);
var inst_28456 = (0);
var inst_28457 = inst_28452;
var state_28629__$1 = (function (){var statearr_28740 = state_28629;
(statearr_28740[(11)] = inst_28455);

(statearr_28740[(28)] = inst_28457);

(statearr_28740[(29)] = inst_28454);

(statearr_28740[(31)] = inst_28456);

(statearr_28740[(40)] = inst_28453);

return statearr_28740;
})();
var statearr_28741_28902 = state_28629__$1;
(statearr_28741_28902[(2)] = null);

(statearr_28741_28902[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (107))){
var inst_28601 = (state_28629[(48)]);
var inst_28601__$1 = (state_28629[(2)]);
var state_28629__$1 = (function (){var statearr_28742 = state_28629;
(statearr_28742[(48)] = inst_28601__$1);

return statearr_28742;
})();
if(cljs.core.truth_(inst_28601__$1)){
var statearr_28743_28903 = state_28629__$1;
(statearr_28743_28903[(1)] = (108));

} else {
var statearr_28744_28904 = state_28629__$1;
(statearr_28744_28904[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (23))){
var inst_28296 = (state_28629[(56)]);
var inst_28304 = (state_28629[(58)]);
var inst_28289 = (state_28629[(60)]);
var inst_28339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28341 = [inst_28289,inst_28296];
var inst_28342 = (new cljs.core.PersistentVector(null,2,(5),inst_28340,inst_28341,null));
var inst_28343 = [inst_28342,inst_28304];
var inst_28344 = (new cljs.core.PersistentVector(null,2,(5),inst_28339,inst_28343,null));
var state_28629__$1 = state_28629;
var statearr_28745_28905 = state_28629__$1;
(statearr_28745_28905[(2)] = inst_28344);

(statearr_28745_28905[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (47))){
var inst_28397 = (cljs.core._GT__EQ_ === start_test);
var state_28629__$1 = state_28629;
if(cljs.core.truth_(inst_28397)){
var statearr_28746_28906 = state_28629__$1;
(statearr_28746_28906[(1)] = (49));

} else {
var statearr_28747_28907 = state_28629__$1;
(statearr_28747_28907[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (35))){
var state_28629__$1 = state_28629;
var statearr_28748_28908 = state_28629__$1;
(statearr_28748_28908[(2)] = false);

(statearr_28748_28908[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (82))){
var inst_28424 = (state_28629[(10)]);
var inst_28453 = (state_28629[(40)]);
var inst_28489 = (state_28629[(2)]);
var inst_28490 = fluree.db.dbproto._rhs(inst_28453);
var state_28629__$1 = (function (){var statearr_28749 = state_28629;
(statearr_28749[(65)] = inst_28490);

(statearr_28749[(78)] = inst_28489);

return statearr_28749;
})();
if(cljs.core.truth_(inst_28424)){
var statearr_28750_28909 = state_28629__$1;
(statearr_28750_28909[(1)] = (83));

} else {
var statearr_28751_28910 = state_28629__$1;
(statearr_28751_28910[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (76))){
var inst_28303 = (state_28629[(24)]);
var inst_28477 = (state_28629[(2)]);
var state_28629__$1 = (function (){var statearr_28752 = state_28629;
(statearr_28752[(64)] = inst_28477);

return statearr_28752;
})();
if(cljs.core.truth_(inst_28303)){
var statearr_28753_28911 = state_28629__$1;
(statearr_28753_28911[(1)] = (77));

} else {
var statearr_28754_28912 = state_28629__$1;
(statearr_28754_28912[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (97))){
var inst_28457 = (state_28629[(28)]);
var inst_28577 = (state_28629[(2)]);
var inst_28578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28577,(0),null);
var inst_28579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28577,(1),null);
var inst_28580 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28577,(2),null);
var inst_28581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28582 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_28457,inst_28580);
var inst_28583 = [(0),inst_28578,inst_28579,inst_28582];
var inst_28584 = (new cljs.core.PersistentVector(null,4,(5),inst_28581,inst_28583,null));
var state_28629__$1 = state_28629;
var statearr_28755_28913 = state_28629__$1;
(statearr_28755_28913[(2)] = inst_28584);

(statearr_28755_28913[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (19))){
var inst_28334 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
var statearr_28756_28914 = state_28629__$1;
(statearr_28756_28914[(2)] = inst_28334);

(statearr_28756_28914[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (57))){
var inst_28410 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
var statearr_28757_28915 = state_28629__$1;
(statearr_28757_28915[(2)] = inst_28410);

(statearr_28757_28915[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (68))){
var inst_28624 = (state_28629[(2)]);
var _ = (function (){var statearr_28758 = state_28629;
(statearr_28758[(4)] = cljs.core.rest((state_28629[(4)])));

return statearr_28758;
})();
var state_28629__$1 = state_28629;
var statearr_28759_28916 = state_28629__$1;
(statearr_28759_28916[(2)] = inst_28624);

(statearr_28759_28916[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (11))){
var inst_28294 = (state_28629[(80)]);
var state_28629__$1 = state_28629;
var statearr_28760_28917 = state_28629__$1;
(statearr_28760_28917[(2)] = inst_28294);

(statearr_28760_28917[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (115))){
var inst_28592 = (state_28629[(72)]);
var state_28629__$1 = state_28629;
var statearr_28762_28918 = state_28629__$1;
(statearr_28762_28918[(2)] = inst_28592);

(statearr_28762_28918[(1)] = (117));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (9))){
var inst_28309 = (state_28629[(2)]);
var inst_28310 = fluree.db.util.async.throw_err(inst_28309);
var state_28629__$1 = state_28629;
var statearr_28763_28919 = state_28629__$1;
(statearr_28763_28919[(2)] = inst_28310);

(statearr_28763_28919[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (5))){
var _ = (function (){var statearr_28764 = state_28629;
(statearr_28764[(4)] = cljs.core.rest((state_28629[(4)])));

return statearr_28764;
})();
var state_28629__$1 = state_28629;
var ex28761 = (state_28629__$1[(2)]);
var statearr_28765_28920 = state_28629__$1;
(statearr_28765_28920[(5)] = ex28761);


if((ex28761 instanceof Error)){
var statearr_28766_28921 = state_28629__$1;
(statearr_28766_28921[(1)] = (4));

(statearr_28766_28921[(5)] = null);

} else {
throw ex28761;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (112))){
var inst_28609 = (state_28629[(49)]);
var state_28629__$1 = state_28629;
var statearr_28767_28922 = state_28629__$1;
(statearr_28767_28922[(2)] = inst_28609);

(statearr_28767_28922[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (83))){
var inst_28454 = (state_28629[(29)]);
var inst_28492 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_28454);
var state_28629__$1 = state_28629;
if(inst_28492){
var statearr_28768_28923 = state_28629__$1;
(statearr_28768_28923[(1)] = (86));

} else {
var statearr_28769_28924 = state_28629__$1;
(statearr_28769_28924[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (14))){
var inst_28289 = (state_28629[(60)]);
var state_28629__$1 = state_28629;
var statearr_28770_28925 = state_28629__$1;
(statearr_28770_28925[(2)] = inst_28289);

(statearr_28770_28925[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (45))){
var inst_28292 = (state_28629[(59)]);
var inst_28394 = (state_28629[(2)]);
var state_28629__$1 = (function (){var statearr_28771 = state_28629;
(statearr_28771[(36)] = inst_28394);

return statearr_28771;
})();
if(cljs.core.truth_(inst_28292)){
var statearr_28772_28926 = state_28629__$1;
(statearr_28772_28926[(1)] = (46));

} else {
var statearr_28773_28927 = state_28629__$1;
(statearr_28773_28927[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (53))){
var inst_28406 = (cljs.core._LT__EQ_ === end_test);
var state_28629__$1 = state_28629;
if(cljs.core.truth_(inst_28406)){
var statearr_28774_28928 = state_28629__$1;
(statearr_28774_28928[(1)] = (55));

} else {
var statearr_28775_28929 = state_28629__$1;
(statearr_28775_28929[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (78))){
var inst_28477 = (state_28629[(64)]);
var state_28629__$1 = state_28629;
var statearr_28776_28930 = state_28629__$1;
(statearr_28776_28930[(2)] = inst_28477);

(statearr_28776_28930[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (26))){
var inst_28356 = (state_28629[(52)]);
var inst_28361 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28356);
var state_28629__$1 = state_28629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28629__$1,(29),inst_28361);
} else {
if((state_val_28630 === (16))){
var inst_28336 = (state_28629[(57)]);
var inst_28336__$1 = (state_28629[(2)]);
var inst_28337 = (inst_28336__$1 == null);
var state_28629__$1 = (function (){var statearr_28777 = state_28629;
(statearr_28777[(57)] = inst_28336__$1);

return statearr_28777;
})();
if(cljs.core.truth_(inst_28337)){
var statearr_28778_28931 = state_28629__$1;
(statearr_28778_28931[(1)] = (23));

} else {
var statearr_28779_28932 = state_28629__$1;
(statearr_28779_28932[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (81))){
var inst_28483 = (state_28629[(81)]);
var state_28629__$1 = state_28629;
var statearr_28780_28933 = state_28629__$1;
(statearr_28780_28933[(2)] = inst_28483);

(statearr_28780_28933[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (79))){
var inst_28358 = (state_28629[(47)]);
var inst_28483 = (state_28629[(2)]);
var state_28629__$1 = (function (){var statearr_28781 = state_28629;
(statearr_28781[(81)] = inst_28483);

return statearr_28781;
})();
if(cljs.core.truth_(inst_28358)){
var statearr_28782_28934 = state_28629__$1;
(statearr_28782_28934[(1)] = (80));

} else {
var statearr_28783_28935 = state_28629__$1;
(statearr_28783_28935[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (38))){
var inst_28288 = (state_28629[(62)]);
var state_28629__$1 = state_28629;
var statearr_28784_28936 = state_28629__$1;
(statearr_28784_28936[(2)] = inst_28288);

(statearr_28784_28936[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (98))){
var inst_28531 = (state_28629[(67)]);
var inst_28423 = (state_28629[(34)]);
var inst_28533 = (state_28629[(69)]);
var inst_28536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28537 = (inst_28531 - inst_28533);
var inst_28538 = [inst_28423,inst_28537];
var inst_28539 = (new cljs.core.PersistentVector(null,2,(5),inst_28536,inst_28538,null));
var state_28629__$1 = state_28629;
var statearr_28785_28937 = state_28629__$1;
(statearr_28785_28937[(2)] = inst_28539);

(statearr_28785_28937[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (87))){
var state_28629__$1 = state_28629;
var statearr_28786_28938 = state_28629__$1;
(statearr_28786_28938[(2)] = false);

(statearr_28786_28938[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (30))){
var inst_28357 = (state_28629[(76)]);
var inst_28370 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28357);
var state_28629__$1 = state_28629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28629__$1,(33),inst_28370);
} else {
if((state_val_28630 === (73))){
var inst_28302 = (state_28629[(32)]);
var inst_28471 = (state_28629[(2)]);
var state_28629__$1 = (function (){var statearr_28787 = state_28629;
(statearr_28787[(18)] = inst_28471);

return statearr_28787;
})();
if(cljs.core.truth_(inst_28302)){
var statearr_28788_28939 = state_28629__$1;
(statearr_28788_28939[(1)] = (74));

} else {
var statearr_28789_28940 = state_28629__$1;
(statearr_28789_28940[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (96))){
var inst_28455 = (state_28629[(11)]);
var inst_28417 = (state_28629[(22)]);
var inst_28456 = (state_28629[(31)]);
var inst_28423 = (state_28629[(34)]);
var inst_28523 = (state_28629[(68)]);
var inst_28572 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_28523,inst_28455,inst_28456,inst_28417,inst_28423);
var state_28629__$1 = state_28629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28629__$1,(104),inst_28572);
} else {
if((state_val_28630 === (10))){
var inst_28294 = (state_28629[(80)]);
var inst_28316 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_28294);
var state_28629__$1 = state_28629;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28629__$1,(13),inst_28316);
} else {
if((state_val_28630 === (18))){
var state_28629__$1 = state_28629;
var statearr_28790_28941 = state_28629__$1;
(statearr_28790_28941[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (105))){
var inst_28591 = (state_28629[(73)]);
var inst_28417 = (state_28629[(22)]);
var inst_28490 = (state_28629[(65)]);
var inst_28429 = (state_28629[(25)]);
var inst_28414 = (state_28629[(26)]);
var inst_28590 = (state_28629[(74)]);
var inst_28423 = (state_28629[(34)]);
var inst_28594 = (inst_28429.cljs$core$IFn$_invoke$arity$2 ? inst_28429.cljs$core$IFn$_invoke$arity$2(inst_28490,inst_28414) : inst_28429.call(null,inst_28490,inst_28414));
var inst_28595 = (inst_28594 < (0));
var inst_28596 = (inst_28590 < inst_28417);
var inst_28597 = (inst_28591 < inst_28423);
var inst_28598 = ((inst_28595) && (inst_28596) && (inst_28597));
var state_28629__$1 = state_28629;
var statearr_28792_28942 = state_28629__$1;
(statearr_28792_28942[(2)] = inst_28598);

(statearr_28792_28942[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (52))){
var inst_28299 = (state_28629[(61)]);
var state_28629__$1 = state_28629;
var statearr_28793_28943 = state_28629__$1;
(statearr_28793_28943[(2)] = inst_28299);

(statearr_28793_28943[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (114))){
var inst_28613 = (state_28629[(2)]);
var inst_28614 = cljs.core.not(inst_28613);
var state_28629__$1 = state_28629;
if(inst_28614){
var statearr_28794_28944 = state_28629__$1;
(statearr_28794_28944[(1)] = (115));

} else {
var statearr_28795_28945 = state_28629__$1;
(statearr_28795_28945[(1)] = (116));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (67))){
var state_28629__$1 = state_28629;
var statearr_28796_28946 = state_28629__$1;
(statearr_28796_28946[(2)] = null);

(statearr_28796_28946[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (71))){
var inst_28385 = (state_28629[(9)]);
var inst_28424 = (state_28629[(10)]);
var inst_28455 = (state_28629[(11)]);
var inst_28463 = (state_28629[(12)]);
var inst_28425 = (state_28629[(13)]);
var inst_28297 = (state_28629[(14)]);
var inst_28440 = (state_28629[(15)]);
var inst_28450 = (state_28629[(8)]);
var inst_28403 = (state_28629[(16)]);
var inst_28367 = (state_28629[(17)]);
var inst_28322 = (state_28629[(19)]);
var inst_28435 = (state_28629[(20)]);
var inst_28434 = (state_28629[(21)]);
var inst_28417 = (state_28629[(22)]);
var inst_28293 = (state_28629[(23)]);
var inst_28303 = (state_28629[(24)]);
var inst_28429 = (state_28629[(25)]);
var inst_28414 = (state_28629[(26)]);
var inst_28355 = (state_28629[(27)]);
var inst_28457 = (state_28629[(28)]);
var inst_28454 = (state_28629[(29)]);
var inst_28301 = (state_28629[(30)]);
var inst_28456 = (state_28629[(31)]);
var inst_28302 = (state_28629[(32)]);
var inst_28412 = (state_28629[(33)]);
var inst_28423 = (state_28629[(34)]);
var inst_28354 = (state_28629[(35)]);
var inst_28394 = (state_28629[(36)]);
var inst_28416 = (state_28629[(37)]);
var inst_28444 = (state_28629[(7)]);
var inst_28376 = (state_28629[(38)]);
var inst_28291 = (state_28629[(39)]);
var inst_28453 = (state_28629[(40)]);
var inst_28413 = (state_28629[(41)]);
var inst_28298 = (state_28629[(42)]);
var inst_28430 = (state_28629[(43)]);
var inst_28286 = (state_28629[(44)]);
var inst_28313 = (state_28629[(45)]);
var inst_28290 = (state_28629[(46)]);
var inst_28358 = (state_28629[(47)]);
var inst_28467 = (function (){var no_filter_QMARK_ = inst_28450;
var G__28464 = inst_28463;
var t = inst_28430;
var max_limit_QMARK_ = inst_28424;
var next_node = inst_28453;
var fast_forward_db_QMARK_ = inst_28435;
var s1 = inst_28313;
var o2 = inst_28376;
var vec__28282 = inst_28355;
var t1 = inst_28290;
var predicate_fn = inst_28303;
var i = inst_28455;
var m1 = inst_28403;
var root_node = inst_28440;
var s2 = inst_28322;
var vec__28272 = inst_28286;
var p2 = inst_28394;
var permissions = inst_28425;
var limit = inst_28423;
var start_flake = inst_28413;
var flake_limit = inst_28417;
var offset = inst_28454;
var acc = inst_28457;
var t2 = inst_28297;
var map__28285 = inst_28416;
var op1 = inst_28291;
var o1 = inst_28367;
var end_flake = inst_28414;
var base_result = inst_28463;
var s = inst_28456;
var node_start = inst_28444;
var p1 = inst_28385;
var subject_fn = inst_28302;
var vec__28279 = inst_28354;
var object_fn = inst_28358;
var idx_compare = inst_28429;
var op2 = inst_28298;
var m2 = inst_28412;
var map__28278 = inst_28301;
var vec__28275 = inst_28293;
var novelty = inst_28434;
return (function (p1__28253_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__28253_SHARP_.o,start_flake.o);
});
})();
var inst_28468 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_28467,inst_28463);
var state_28629__$1 = state_28629;
var statearr_28797_28947 = state_28629__$1;
(statearr_28797_28947[(2)] = inst_28468);

(statearr_28797_28947[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (42))){
var inst_28390 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
if(cljs.core.truth_(inst_28390)){
var statearr_28798_28948 = state_28629__$1;
(statearr_28798_28948[(1)] = (43));

} else {
var statearr_28799_28949 = state_28629__$1;
(statearr_28799_28949[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (80))){
var inst_28385 = (state_28629[(9)]);
var inst_28424 = (state_28629[(10)]);
var inst_28455 = (state_28629[(11)]);
var inst_28463 = (state_28629[(12)]);
var inst_28425 = (state_28629[(13)]);
var inst_28297 = (state_28629[(14)]);
var inst_28440 = (state_28629[(15)]);
var inst_28450 = (state_28629[(8)]);
var inst_28403 = (state_28629[(16)]);
var inst_28367 = (state_28629[(17)]);
var inst_28322 = (state_28629[(19)]);
var inst_28435 = (state_28629[(20)]);
var inst_28434 = (state_28629[(21)]);
var inst_28417 = (state_28629[(22)]);
var inst_28293 = (state_28629[(23)]);
var inst_28483 = (state_28629[(81)]);
var inst_28303 = (state_28629[(24)]);
var inst_28429 = (state_28629[(25)]);
var inst_28414 = (state_28629[(26)]);
var inst_28355 = (state_28629[(27)]);
var inst_28457 = (state_28629[(28)]);
var inst_28454 = (state_28629[(29)]);
var inst_28301 = (state_28629[(30)]);
var inst_28456 = (state_28629[(31)]);
var inst_28302 = (state_28629[(32)]);
var inst_28412 = (state_28629[(33)]);
var inst_28423 = (state_28629[(34)]);
var inst_28354 = (state_28629[(35)]);
var inst_28394 = (state_28629[(36)]);
var inst_28416 = (state_28629[(37)]);
var inst_28444 = (state_28629[(7)]);
var inst_28376 = (state_28629[(38)]);
var inst_28291 = (state_28629[(39)]);
var inst_28453 = (state_28629[(40)]);
var inst_28413 = (state_28629[(41)]);
var inst_28298 = (state_28629[(42)]);
var inst_28430 = (state_28629[(43)]);
var inst_28286 = (state_28629[(44)]);
var inst_28313 = (state_28629[(45)]);
var inst_28290 = (state_28629[(46)]);
var inst_28358 = (state_28629[(47)]);
var inst_28485 = (function (){var no_filter_QMARK_ = inst_28450;
var G__28464 = inst_28483;
var t = inst_28430;
var max_limit_QMARK_ = inst_28424;
var next_node = inst_28453;
var fast_forward_db_QMARK_ = inst_28435;
var s1 = inst_28313;
var o2 = inst_28376;
var vec__28282 = inst_28355;
var t1 = inst_28290;
var predicate_fn = inst_28303;
var i = inst_28455;
var m1 = inst_28403;
var root_node = inst_28440;
var s2 = inst_28322;
var vec__28272 = inst_28286;
var p2 = inst_28394;
var permissions = inst_28425;
var limit = inst_28423;
var start_flake = inst_28413;
var flake_limit = inst_28417;
var offset = inst_28454;
var acc = inst_28457;
var t2 = inst_28297;
var map__28285 = inst_28416;
var op1 = inst_28291;
var o1 = inst_28367;
var end_flake = inst_28414;
var base_result = inst_28463;
var s = inst_28456;
var node_start = inst_28444;
var p1 = inst_28385;
var subject_fn = inst_28302;
var vec__28279 = inst_28354;
var object_fn = inst_28358;
var idx_compare = inst_28429;
var op2 = inst_28298;
var m2 = inst_28412;
var map__28278 = inst_28301;
var vec__28275 = inst_28293;
var novelty = inst_28434;
return (function (p1__28256_SHARP_){
var G__28800 = p1__28256_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__28800) : object_fn.call(null,G__28800));
});
})();
var inst_28486 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_28485,inst_28483);
var state_28629__$1 = state_28629;
var statearr_28801_28950 = state_28629__$1;
(statearr_28801_28950[(2)] = inst_28486);

(statearr_28801_28950[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (37))){
var state_28629__$1 = state_28629;
var statearr_28802_28951 = state_28629__$1;
(statearr_28802_28951[(2)] = (-1));

(statearr_28802_28951[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (63))){
var inst_28385 = (state_28629[(9)]);
var inst_28425 = (state_28629[(13)]);
var inst_28322 = (state_28629[(19)]);
var inst_28394 = (state_28629[(36)]);
var inst_28313 = (state_28629[(45)]);
var inst_28447 = fluree.db.permissions_validate.no_filter_QMARK_(inst_28425,inst_28313,inst_28322,inst_28385,inst_28394);
var state_28629__$1 = state_28629;
var statearr_28803_28952 = state_28629__$1;
(statearr_28803_28952[(2)] = inst_28447);

(statearr_28803_28952[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (94))){
var inst_28586 = (state_28629[(2)]);
var state_28629__$1 = state_28629;
var statearr_28804_28953 = state_28629__$1;
(statearr_28804_28953[(2)] = inst_28586);

(statearr_28804_28953[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (8))){
var inst_28294 = (state_28629[(80)]);
var inst_28313 = (state_28629[(2)]);
var inst_28314 = fluree.db.util.core.pred_ident_QMARK_(inst_28294);
var state_28629__$1 = (function (){var statearr_28805 = state_28629;
(statearr_28805[(45)] = inst_28313);

return statearr_28805;
})();
if(inst_28314){
var statearr_28806_28954 = state_28629__$1;
(statearr_28806_28954[(1)] = (10));

} else {
var statearr_28807_28955 = state_28629__$1;
(statearr_28807_28955[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (49))){
var state_28629__$1 = state_28629;
var statearr_28808_28956 = state_28629__$1;
(statearr_28808_28956[(2)] = fluree.db.util.core.min_integer);

(statearr_28808_28956[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28630 === (84))){
var inst_28424 = (state_28629[(10)]);
var state_28629__$1 = state_28629;
var statearr_28809_28957 = state_28629__$1;
(statearr_28809_28957[(2)] = inst_28424);

(statearr_28809_28957[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__13883__auto__ = null;
var fluree$db$query$range$state_machine__13883__auto____0 = (function (){
var statearr_28810 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28810[(0)] = fluree$db$query$range$state_machine__13883__auto__);

(statearr_28810[(1)] = (1));

return statearr_28810;
});
var fluree$db$query$range$state_machine__13883__auto____1 = (function (state_28629){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_28629);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e28811){var ex__13886__auto__ = e28811;
var statearr_28812_28958 = state_28629;
(statearr_28812_28958[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_28629[(4)]))){
var statearr_28813_28959 = state_28629;
(statearr_28813_28959[(1)] = cljs.core.first((state_28629[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__28960 = state_28629;
state_28629 = G__28960;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__13883__auto__ = function(state_28629){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__13883__auto____1.call(this,state_28629);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__13883__auto____0;
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__13883__auto____1;
return fluree$db$query$range$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_28814 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_28814[(6)] = c__13957__auto__);

return statearr_28814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_29016){
var state_val_29017 = (state_29016[(1)]);
if((state_val_29017 === (7))){
var inst_28980 = (state_29016[(7)]);
var inst_28990 = (state_29016[(8)]);
var inst_28988 = fluree.db.flake.Flake__GT_parts(inst_28980);
var inst_28989 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28988,(0),null);
var inst_28990__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28988,(1),null);
var inst_28991 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28988,(2),null);
var inst_28992 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28988,(3),null);
var inst_28993 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28988,(4),null);
var inst_28994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28988,(5),null);
var inst_28995 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_28991,inst_28990__$1);
var state_29016__$1 = (function (){var statearr_29018 = state_29016;
(statearr_29018[(9)] = inst_28994);

(statearr_29018[(10)] = inst_28993);

(statearr_29018[(11)] = inst_28989);

(statearr_29018[(12)] = inst_28992);

(statearr_29018[(8)] = inst_28990__$1);

return statearr_29018;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29016__$1,(10),inst_28995);
} else {
if((state_val_29017 === (1))){
var inst_28968 = flakes;
var inst_28969 = cljs.core.seq(inst_28968);
var inst_28970 = cljs.core.first(inst_28969);
var inst_28971 = cljs.core.next(inst_28969);
var inst_28972 = cljs.core.PersistentVector.EMPTY;
var inst_28973 = inst_28968;
var inst_28974 = inst_28972;
var state_29016__$1 = (function (){var statearr_29019 = state_29016;
(statearr_29019[(13)] = inst_28973);

(statearr_29019[(14)] = inst_28970);

(statearr_29019[(15)] = inst_28974);

(statearr_29019[(16)] = inst_28971);

return statearr_29019;
})();
var statearr_29020_29038 = state_29016__$1;
(statearr_29020_29038[(2)] = null);

(statearr_29020_29038[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29017 === (4))){
var inst_28980 = (state_29016[(7)]);
var inst_28983 = fluree.db.query.range.is_tag_flake_QMARK_(inst_28980);
var state_29016__$1 = state_29016;
if(inst_28983){
var statearr_29021_29039 = state_29016__$1;
(statearr_29021_29039[(1)] = (7));

} else {
var statearr_29022_29040 = state_29016__$1;
(statearr_29022_29040[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29017 === (6))){
var inst_29012 = (state_29016[(2)]);
var state_29016__$1 = state_29016;
var statearr_29023_29041 = state_29016__$1;
(statearr_29023_29041[(2)] = inst_29012);

(statearr_29023_29041[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29017 === (3))){
var inst_29014 = (state_29016[(2)]);
var state_29016__$1 = state_29016;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29016__$1,inst_29014);
} else {
if((state_val_29017 === (2))){
var inst_28973 = (state_29016[(13)]);
var inst_28980 = (state_29016[(7)]);
var inst_28979 = cljs.core.seq(inst_28973);
var inst_28980__$1 = cljs.core.first(inst_28979);
var inst_28981 = cljs.core.next(inst_28979);
var state_29016__$1 = (function (){var statearr_29024 = state_29016;
(statearr_29024[(7)] = inst_28980__$1);

(statearr_29024[(17)] = inst_28981);

return statearr_29024;
})();
if(cljs.core.truth_(inst_28980__$1)){
var statearr_29025_29042 = state_29016__$1;
(statearr_29025_29042[(1)] = (4));

} else {
var statearr_29026_29043 = state_29016__$1;
(statearr_29026_29043[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29017 === (9))){
var inst_29009 = (state_29016[(2)]);
var state_29016__$1 = state_29016;
var statearr_29027_29044 = state_29016__$1;
(statearr_29027_29044[(2)] = inst_29009);

(statearr_29027_29044[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29017 === (5))){
var inst_28974 = (state_29016[(15)]);
var state_29016__$1 = state_29016;
var statearr_29028_29045 = state_29016__$1;
(statearr_29028_29045[(2)] = inst_28974);

(statearr_29028_29045[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29017 === (10))){
var inst_28994 = (state_29016[(9)]);
var inst_28974 = (state_29016[(15)]);
var inst_28993 = (state_29016[(10)]);
var inst_28989 = (state_29016[(11)]);
var inst_28992 = (state_29016[(12)]);
var inst_28990 = (state_29016[(8)]);
var inst_28981 = (state_29016[(17)]);
var inst_28997 = (state_29016[(2)]);
var inst_28998 = fluree.db.util.async.throw_err(inst_28997);
var inst_28999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29000 = [inst_28989,inst_28990,inst_28998,inst_28992,inst_28993,inst_28994];
var inst_29001 = (new cljs.core.PersistentVector(null,6,(5),inst_28999,inst_29000,null));
var inst_29002 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_29001);
var inst_29003 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_28974,inst_29002);
var inst_28973 = inst_28981;
var inst_28974__$1 = inst_29003;
var state_29016__$1 = (function (){var statearr_29029 = state_29016;
(statearr_29029[(13)] = inst_28973);

(statearr_29029[(15)] = inst_28974__$1);

return statearr_29029;
})();
var statearr_29030_29046 = state_29016__$1;
(statearr_29030_29046[(2)] = null);

(statearr_29030_29046[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29017 === (8))){
var inst_28974 = (state_29016[(15)]);
var inst_28980 = (state_29016[(7)]);
var inst_28981 = (state_29016[(17)]);
var inst_29006 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_28974,inst_28980);
var inst_28973 = inst_28981;
var inst_28974__$1 = inst_29006;
var state_29016__$1 = (function (){var statearr_29031 = state_29016;
(statearr_29031[(13)] = inst_28973);

(statearr_29031[(15)] = inst_28974__$1);

return statearr_29031;
})();
var statearr_29032_29047 = state_29016__$1;
(statearr_29032_29047[(2)] = null);

(statearr_29032_29047[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto____0 = (function (){
var statearr_29033 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29033[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto__);

(statearr_29033[(1)] = (1));

return statearr_29033;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto____1 = (function (state_29016){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_29016);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e29034){var ex__13886__auto__ = e29034;
var statearr_29035_29048 = state_29016;
(statearr_29035_29048[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_29016[(4)]))){
var statearr_29036_29049 = state_29016;
(statearr_29036_29049[(1)] = cljs.core.first((state_29016[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__29050 = state_29016;
state_29016 = G__29050;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto__ = function(state_29016){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto____1.call(this,state_29016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_29037 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_29037[(6)] = c__13957__auto__);

return statearr_29037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__29052 = arguments.length;
switch (G__29052) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_29203){
var state_val_29204 = (state_29203[(1)]);
if((state_val_29204 === (62))){
var inst_29190 = (state_29203[(7)]);
var state_29203__$1 = state_29203;
var statearr_29205_29294 = state_29203__$1;
(statearr_29205_29294[(2)] = inst_29190);

(statearr_29205_29294[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (7))){
var state_29203__$1 = state_29203;
var statearr_29206_29295 = state_29203__$1;
(statearr_29206_29295[(2)] = false);

(statearr_29206_29295[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (59))){
var inst_29182 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
var statearr_29207_29296 = state_29203__$1;
(statearr_29207_29296[(2)] = inst_29182);

(statearr_29207_29296[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (20))){
var state_29203__$1 = state_29203;
var statearr_29208_29297 = state_29203__$1;
(statearr_29208_29297[(2)] = null);

(statearr_29208_29297[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (58))){
var state_29203__$1 = state_29203;
var statearr_29209_29298 = state_29203__$1;
(statearr_29209_29298[(2)] = null);

(statearr_29209_29298[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (60))){
var inst_29178 = (state_29203[(2)]);
var inst_29179 = fluree.db.util.async.throw_err(inst_29178);
var state_29203__$1 = state_29203;
var statearr_29210_29299 = state_29203__$1;
(statearr_29210_29299[(2)] = inst_29179);

(statearr_29210_29299[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (27))){
var inst_29103 = (state_29203[(8)]);
var inst_29114 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_29103);
var state_29203__$1 = state_29203;
if(inst_29114){
var statearr_29211_29300 = state_29203__$1;
(statearr_29211_29300[(1)] = (30));

} else {
var statearr_29212_29301 = state_29203__$1;
(statearr_29212_29301[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (1))){
var state_29203__$1 = state_29203;
var statearr_29213_29302 = state_29203__$1;
(statearr_29213_29302[(2)] = null);

(statearr_29213_29302[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (24))){
var inst_29064 = (state_29203[(9)]);
var state_29203__$1 = state_29203;
if(cljs.core.truth_(inst_29064)){
var statearr_29214_29303 = state_29203__$1;
(statearr_29214_29303[(1)] = (27));

} else {
var statearr_29215_29304 = state_29203__$1;
(statearr_29215_29304[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (55))){
var inst_29184 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
var statearr_29216_29305 = state_29203__$1;
(statearr_29216_29305[(2)] = inst_29184);

(statearr_29216_29305[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (39))){
var inst_29134 = (state_29203[(2)]);
var inst_29135 = fluree.db.util.async.throw_err(inst_29134);
var state_29203__$1 = state_29203;
var statearr_29217_29306 = state_29203__$1;
(statearr_29217_29306[(2)] = inst_29135);

(statearr_29217_29306[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (46))){
var inst_29147 = (state_29203[(10)]);
var inst_29147__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_29203__$1 = (function (){var statearr_29218 = state_29203;
(statearr_29218[(10)] = inst_29147__$1);

return statearr_29218;
})();
if(cljs.core.truth_(inst_29147__$1)){
var statearr_29219_29307 = state_29203__$1;
(statearr_29219_29307[(1)] = (49));

} else {
var statearr_29220_29308 = state_29203__$1;
(statearr_29220_29308[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (4))){
var inst_29053 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
var statearr_29221_29309 = state_29203__$1;
(statearr_29221_29309[(2)] = inst_29053);

(statearr_29221_29309[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (54))){
var inst_29103 = (state_29203[(8)]);
var state_29203__$1 = state_29203;
if(cljs.core.truth_(inst_29103)){
var statearr_29222_29310 = state_29203__$1;
(statearr_29222_29310[(1)] = (57));

} else {
var statearr_29223_29311 = state_29203__$1;
(statearr_29223_29311[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (15))){
var inst_29065 = (state_29203[(11)]);
var inst_29084 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_29065);
var state_29203__$1 = state_29203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29203__$1,(18),inst_29084);
} else {
if((state_val_29204 === (48))){
var inst_29186 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
var statearr_29224_29312 = state_29203__$1;
(statearr_29224_29312[(2)] = inst_29186);

(statearr_29224_29312[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (50))){
var inst_29147 = (state_29203[(10)]);
var inst_29067 = (state_29203[(12)]);
var inst_29064 = (state_29203[(9)]);
var inst_29062 = (state_29203[(13)]);
var inst_29066 = (state_29203[(14)]);
var inst_29103 = (state_29203[(8)]);
var inst_29078 = (state_29203[(15)]);
var inst_29073 = (state_29203[(16)]);
var inst_29063 = (state_29203[(17)]);
var inst_29151 = (function (){var t = inst_29066;
var p = inst_29064;
var idx_predicate_QMARK_ = inst_29067;
var vec__29059 = inst_29062;
var o = inst_29103;
var tag_predicate_QMARK_ = inst_29073;
var temp__5751__auto__ = inst_29147;
var s = inst_29063;
var o_coerce_QMARK_ = inst_29078;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_29203__$1 = state_29203;
var statearr_29225_29313 = state_29203__$1;
(statearr_29225_29313[(2)] = inst_29151);

(statearr_29225_29313[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (21))){
var inst_29099 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
var statearr_29226_29314 = state_29203__$1;
(statearr_29226_29314[(2)] = inst_29099);

(statearr_29226_29314[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (31))){
var state_29203__$1 = state_29203;
var statearr_29227_29315 = state_29203__$1;
(statearr_29227_29315[(2)] = false);

(statearr_29227_29315[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (32))){
var inst_29124 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
var statearr_29228_29316 = state_29203__$1;
(statearr_29228_29316[(2)] = inst_29124);

(statearr_29228_29316[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (40))){
var inst_29067 = (state_29203[(12)]);
var inst_29138 = cljs.core.not(inst_29067);
var state_29203__$1 = state_29203;
if(inst_29138){
var statearr_29229_29317 = state_29203__$1;
(statearr_29229_29317[(1)] = (43));

} else {
var statearr_29230_29318 = state_29203__$1;
(statearr_29230_29318[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (56))){
var inst_29169 = (state_29203[(2)]);
var inst_29170 = fluree.db.util.async.throw_err(inst_29169);
var state_29203__$1 = state_29203;
var statearr_29231_29319 = state_29203__$1;
(statearr_29231_29319[(2)] = inst_29170);

(statearr_29231_29319[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (33))){
var inst_29103 = (state_29203[(8)]);
var inst_29117 = cljs.core.fn_QMARK_(inst_29103);
var inst_29118 = (!(inst_29117));
var state_29203__$1 = state_29203;
var statearr_29232_29320 = state_29203__$1;
(statearr_29232_29320[(2)] = inst_29118);

(statearr_29232_29320[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (13))){
var inst_29065 = (state_29203[(11)]);
var inst_29082 = fluree.db.query.range.tag_string_QMARK_(inst_29065);
var state_29203__$1 = state_29203;
if(cljs.core.truth_(inst_29082)){
var statearr_29233_29321 = state_29203__$1;
(statearr_29233_29321[(1)] = (15));

} else {
var statearr_29234_29322 = state_29203__$1;
(statearr_29234_29322[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (22))){
var inst_29095 = (state_29203[(2)]);
var inst_29096 = fluree.db.util.async.throw_err(inst_29095);
var state_29203__$1 = state_29203;
var statearr_29235_29323 = state_29203__$1;
(statearr_29235_29323[(2)] = inst_29096);

(statearr_29235_29323[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (36))){
var inst_29064 = (state_29203[(9)]);
var inst_29066 = (state_29203[(14)]);
var inst_29103 = (state_29203[(8)]);
var inst_29063 = (state_29203[(17)]);
var inst_29129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29130 = [inst_29064,inst_29103,inst_29063,inst_29066];
var inst_29131 = (new cljs.core.PersistentVector(null,4,(5),inst_29129,inst_29130,null));
var inst_29132 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_29131,opts);
var state_29203__$1 = state_29203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29203__$1,(39),inst_29132);
} else {
if((state_val_29204 === (41))){
var inst_29064 = (state_29203[(9)]);
var state_29203__$1 = state_29203;
var statearr_29236_29324 = state_29203__$1;
(statearr_29236_29324[(2)] = inst_29064);

(statearr_29236_29324[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (43))){
var inst_29103 = (state_29203[(8)]);
var state_29203__$1 = state_29203;
var statearr_29237_29325 = state_29203__$1;
(statearr_29237_29325[(2)] = inst_29103);

(statearr_29237_29325[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (61))){
var inst_29190 = (state_29203[(7)]);
var inst_29192 = fluree.db.query.range.coerce_tag_flakes(db,inst_29190);
var state_29203__$1 = state_29203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29203__$1,(64),inst_29192);
} else {
if((state_val_29204 === (29))){
var inst_29127 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
if(cljs.core.truth_(inst_29127)){
var statearr_29238_29326 = state_29203__$1;
(statearr_29238_29326[(1)] = (36));

} else {
var statearr_29239_29327 = state_29203__$1;
(statearr_29239_29327[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (44))){
var state_29203__$1 = state_29203;
var statearr_29240_29328 = state_29203__$1;
(statearr_29240_29328[(2)] = false);

(statearr_29240_29328[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (6))){
var inst_29064 = (state_29203[(9)]);
var inst_29069 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_29064);
var inst_29070 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_29069);
var state_29203__$1 = state_29203;
var statearr_29241_29329 = state_29203__$1;
(statearr_29241_29329[(2)] = inst_29070);

(statearr_29241_29329[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (28))){
var inst_29064 = (state_29203[(9)]);
var state_29203__$1 = state_29203;
var statearr_29242_29330 = state_29203__$1;
(statearr_29242_29330[(2)] = inst_29064);

(statearr_29242_29330[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (64))){
var inst_29194 = (state_29203[(2)]);
var inst_29195 = fluree.db.util.async.throw_err(inst_29194);
var state_29203__$1 = state_29203;
var statearr_29243_29331 = state_29203__$1;
(statearr_29243_29331[(2)] = inst_29195);

(statearr_29243_29331[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (51))){
var inst_29064 = (state_29203[(9)]);
var inst_29066 = (state_29203[(14)]);
var inst_29063 = (state_29203[(17)]);
var inst_29153 = (state_29203[(2)]);
var inst_29154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29155 = [inst_29064,inst_29063,null,inst_29066];
var inst_29156 = (new cljs.core.PersistentVector(null,4,(5),inst_29154,inst_29155,null));
var inst_29157 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_29153);
var inst_29158 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_29156,inst_29157);
var state_29203__$1 = state_29203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29203__$1,(52),inst_29158);
} else {
if((state_val_29204 === (25))){
var inst_29073 = (state_29203[(16)]);
var inst_29190 = (state_29203[(2)]);
var state_29203__$1 = (function (){var statearr_29244 = state_29203;
(statearr_29244[(7)] = inst_29190);

return statearr_29244;
})();
if(cljs.core.truth_(inst_29073)){
var statearr_29245_29332 = state_29203__$1;
(statearr_29245_29332[(1)] = (61));

} else {
var statearr_29246_29333 = state_29203__$1;
(statearr_29246_29333[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (34))){
var inst_29067 = (state_29203[(12)]);
var state_29203__$1 = state_29203;
var statearr_29247_29334 = state_29203__$1;
(statearr_29247_29334[(2)] = inst_29067);

(statearr_29247_29334[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (17))){
var inst_29101 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
var statearr_29248_29335 = state_29203__$1;
(statearr_29248_29335[(2)] = inst_29101);

(statearr_29248_29335[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (3))){
var inst_29201 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29203__$1,inst_29201);
} else {
if((state_val_29204 === (12))){
var inst_29065 = (state_29203[(11)]);
var state_29203__$1 = state_29203;
var statearr_29249_29336 = state_29203__$1;
(statearr_29249_29336[(2)] = inst_29065);

(statearr_29249_29336[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (2))){
var inst_29064 = (state_29203[(9)]);
var inst_29062 = (state_29203[(13)]);
var _ = (function (){var statearr_29250 = state_29203;
(statearr_29250[(4)] = cljs.core.cons((5),(state_29203[(4)])));

return statearr_29250;
})();
var inst_29062__$1 = fparts;
var inst_29063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29062__$1,(0),null);
var inst_29064__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29062__$1,(1),null);
var inst_29065 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29062__$1,(2),null);
var inst_29066 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29062__$1,(3),null);
var inst_29067 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_29064__$1);
var state_29203__$1 = (function (){var statearr_29251 = state_29203;
(statearr_29251[(12)] = inst_29067);

(statearr_29251[(9)] = inst_29064__$1);

(statearr_29251[(13)] = inst_29062__$1);

(statearr_29251[(11)] = inst_29065);

(statearr_29251[(14)] = inst_29066);

(statearr_29251[(17)] = inst_29063);

return statearr_29251;
})();
if(cljs.core.truth_(inst_29064__$1)){
var statearr_29252_29337 = state_29203__$1;
(statearr_29252_29337[(1)] = (6));

} else {
var statearr_29253_29338 = state_29203__$1;
(statearr_29253_29338[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (23))){
var inst_29064 = (state_29203[(9)]);
var inst_29066 = (state_29203[(14)]);
var inst_29103 = (state_29203[(8)]);
var inst_29063 = (state_29203[(17)]);
var inst_29105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29106 = [inst_29063,inst_29064,inst_29103,inst_29066];
var inst_29107 = (new cljs.core.PersistentVector(null,4,(5),inst_29105,inst_29106,null));
var inst_29108 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_29107,opts);
var state_29203__$1 = state_29203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29203__$1,(26),inst_29108);
} else {
if((state_val_29204 === (47))){
var inst_29064 = (state_29203[(9)]);
var state_29203__$1 = state_29203;
if(cljs.core.truth_(inst_29064)){
var statearr_29254_29339 = state_29203__$1;
(statearr_29254_29339[(1)] = (53));

} else {
var statearr_29255_29340 = state_29203__$1;
(statearr_29255_29340[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (35))){
var inst_29121 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
var statearr_29256_29341 = state_29203__$1;
(statearr_29256_29341[(2)] = inst_29121);

(statearr_29256_29341[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (19))){
var inst_29064 = (state_29203[(9)]);
var inst_29065 = (state_29203[(11)]);
var inst_29091 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_29064);
var inst_29092 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29091),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29065)].join('');
var inst_29093 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_29092);
var state_29203__$1 = state_29203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29203__$1,(22),inst_29093);
} else {
if((state_val_29204 === (57))){
var inst_29064 = (state_29203[(9)]);
var inst_29066 = (state_29203[(14)]);
var inst_29103 = (state_29203[(8)]);
var inst_29063 = (state_29203[(17)]);
var inst_29173 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29174 = [inst_29103,inst_29064,inst_29063,inst_29066];
var inst_29175 = (new cljs.core.PersistentVector(null,4,(5),inst_29173,inst_29174,null));
var inst_29176 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_29175,opts);
var state_29203__$1 = state_29203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29203__$1,(60),inst_29176);
} else {
if((state_val_29204 === (11))){
var inst_29078 = (state_29203[(15)]);
var inst_29078__$1 = (state_29203[(2)]);
var inst_29079 = cljs.core.not(inst_29078__$1);
var state_29203__$1 = (function (){var statearr_29258 = state_29203;
(statearr_29258[(15)] = inst_29078__$1);

return statearr_29258;
})();
if(inst_29079){
var statearr_29259_29342 = state_29203__$1;
(statearr_29259_29342[(1)] = (12));

} else {
var statearr_29260_29343 = state_29203__$1;
(statearr_29260_29343[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (9))){
var inst_29065 = (state_29203[(11)]);
var inst_29075 = typeof inst_29065 === 'string';
var state_29203__$1 = state_29203;
var statearr_29261_29344 = state_29203__$1;
(statearr_29261_29344[(2)] = inst_29075);

(statearr_29261_29344[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (5))){
var _ = (function (){var statearr_29262 = state_29203;
(statearr_29262[(4)] = cljs.core.rest((state_29203[(4)])));

return statearr_29262;
})();
var state_29203__$1 = state_29203;
var ex29257 = (state_29203__$1[(2)]);
var statearr_29263_29345 = state_29203__$1;
(statearr_29263_29345[(5)] = ex29257);


if((ex29257 instanceof Error)){
var statearr_29264_29346 = state_29203__$1;
(statearr_29264_29346[(1)] = (4));

(statearr_29264_29346[(5)] = null);

} else {
throw ex29257;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (14))){
var inst_29063 = (state_29203[(17)]);
var inst_29103 = (state_29203[(2)]);
var state_29203__$1 = (function (){var statearr_29265 = state_29203;
(statearr_29265[(8)] = inst_29103);

return statearr_29265;
})();
if(cljs.core.truth_(inst_29063)){
var statearr_29266_29347 = state_29203__$1;
(statearr_29266_29347[(1)] = (23));

} else {
var statearr_29267_29348 = state_29203__$1;
(statearr_29267_29348[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (45))){
var inst_29142 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
var statearr_29268_29349 = state_29203__$1;
(statearr_29268_29349[(2)] = inst_29142);

(statearr_29268_29349[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (53))){
var inst_29064 = (state_29203[(9)]);
var inst_29066 = (state_29203[(14)]);
var inst_29103 = (state_29203[(8)]);
var inst_29063 = (state_29203[(17)]);
var inst_29164 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29165 = [inst_29064,inst_29063,inst_29103,inst_29066];
var inst_29166 = (new cljs.core.PersistentVector(null,4,(5),inst_29164,inst_29165,null));
var inst_29167 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_29166,opts);
var state_29203__$1 = state_29203;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29203__$1,(56),inst_29167);
} else {
if((state_val_29204 === (26))){
var inst_29110 = (state_29203[(2)]);
var inst_29111 = fluree.db.util.async.throw_err(inst_29110);
var state_29203__$1 = state_29203;
var statearr_29269_29350 = state_29203__$1;
(statearr_29269_29350[(2)] = inst_29111);

(statearr_29269_29350[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (16))){
var inst_29065 = (state_29203[(11)]);
var inst_29089 = typeof inst_29065 === 'string';
var state_29203__$1 = state_29203;
if(cljs.core.truth_(inst_29089)){
var statearr_29270_29351 = state_29203__$1;
(statearr_29270_29351[(1)] = (19));

} else {
var statearr_29271_29352 = state_29203__$1;
(statearr_29271_29352[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (38))){
var inst_29188 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
var statearr_29272_29353 = state_29203__$1;
(statearr_29272_29353[(2)] = inst_29188);

(statearr_29272_29353[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (30))){
var inst_29067 = (state_29203[(12)]);
var state_29203__$1 = state_29203;
if(cljs.core.truth_(inst_29067)){
var statearr_29273_29354 = state_29203__$1;
(statearr_29273_29354[(1)] = (33));

} else {
var statearr_29274_29355 = state_29203__$1;
(statearr_29274_29355[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (10))){
var inst_29073 = (state_29203[(16)]);
var state_29203__$1 = state_29203;
var statearr_29275_29356 = state_29203__$1;
(statearr_29275_29356[(2)] = inst_29073);

(statearr_29275_29356[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (18))){
var inst_29086 = (state_29203[(2)]);
var inst_29087 = fluree.db.util.async.throw_err(inst_29086);
var state_29203__$1 = state_29203;
var statearr_29276_29357 = state_29203__$1;
(statearr_29276_29357[(2)] = inst_29087);

(statearr_29276_29357[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (52))){
var inst_29160 = (state_29203[(2)]);
var inst_29161 = fluree.db.util.async.throw_err(inst_29160);
var state_29203__$1 = state_29203;
var statearr_29277_29358 = state_29203__$1;
(statearr_29277_29358[(2)] = inst_29161);

(statearr_29277_29358[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (42))){
var inst_29145 = (state_29203[(2)]);
var state_29203__$1 = state_29203;
if(cljs.core.truth_(inst_29145)){
var statearr_29278_29359 = state_29203__$1;
(statearr_29278_29359[(1)] = (46));

} else {
var statearr_29279_29360 = state_29203__$1;
(statearr_29279_29360[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (37))){
var inst_29064 = (state_29203[(9)]);
var state_29203__$1 = state_29203;
if(cljs.core.truth_(inst_29064)){
var statearr_29280_29361 = state_29203__$1;
(statearr_29280_29361[(1)] = (40));

} else {
var statearr_29281_29362 = state_29203__$1;
(statearr_29281_29362[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (63))){
var inst_29198 = (state_29203[(2)]);
var _ = (function (){var statearr_29282 = state_29203;
(statearr_29282[(4)] = cljs.core.rest((state_29203[(4)])));

return statearr_29282;
})();
var state_29203__$1 = state_29203;
var statearr_29283_29363 = state_29203__$1;
(statearr_29283_29363[(2)] = inst_29198);

(statearr_29283_29363[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (8))){
var inst_29073 = (state_29203[(16)]);
var inst_29073__$1 = (state_29203[(2)]);
var state_29203__$1 = (function (){var statearr_29284 = state_29203;
(statearr_29284[(16)] = inst_29073__$1);

return statearr_29284;
})();
if(cljs.core.truth_(inst_29073__$1)){
var statearr_29285_29364 = state_29203__$1;
(statearr_29285_29364[(1)] = (9));

} else {
var statearr_29286_29365 = state_29203__$1;
(statearr_29286_29365[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29204 === (49))){
var inst_29147 = (state_29203[(10)]);
var inst_29067 = (state_29203[(12)]);
var inst_29064 = (state_29203[(9)]);
var inst_29062 = (state_29203[(13)]);
var inst_29066 = (state_29203[(14)]);
var inst_29103 = (state_29203[(8)]);
var inst_29078 = (state_29203[(15)]);
var inst_29073 = (state_29203[(16)]);
var inst_29063 = (state_29203[(17)]);
var inst_29149 = (function (){var obj_fn = inst_29147;
var t = inst_29066;
var p = inst_29064;
var idx_predicate_QMARK_ = inst_29067;
var vec__29059 = inst_29062;
var o = inst_29103;
var tag_predicate_QMARK_ = inst_29073;
var temp__5751__auto__ = inst_29147;
var s = inst_29063;
var o_coerce_QMARK_ = inst_29078;
return (function (x){
var and__4149__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4149__auto__;
}
});
})();
var state_29203__$1 = state_29203;
var statearr_29287_29366 = state_29203__$1;
(statearr_29287_29366[(2)] = inst_29149);

(statearr_29287_29366[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__13883__auto__ = null;
var fluree$db$query$range$state_machine__13883__auto____0 = (function (){
var statearr_29288 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29288[(0)] = fluree$db$query$range$state_machine__13883__auto__);

(statearr_29288[(1)] = (1));

return statearr_29288;
});
var fluree$db$query$range$state_machine__13883__auto____1 = (function (state_29203){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_29203);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e29289){var ex__13886__auto__ = e29289;
var statearr_29290_29367 = state_29203;
(statearr_29290_29367[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_29203[(4)]))){
var statearr_29291_29368 = state_29203;
(statearr_29291_29368[(1)] = cljs.core.first((state_29203[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__29369 = state_29203;
state_29203 = G__29369;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__13883__auto__ = function(state_29203){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__13883__auto____1.call(this,state_29203);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__13883__auto____0;
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__13883__auto____1;
return fluree$db$query$range$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_29292 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_29292[(6)] = c__13957__auto__);

return statearr_29292;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__29371 = arguments.length;
switch (G__29371) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_29406){
var state_val_29407 = (state_29406[(1)]);
if((state_val_29407 === (7))){
var inst_29393 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_29394 = ["Invalid collection name: ",inst_29393].join('');
var inst_29395 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_29396 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_29397 = cljs.core.PersistentHashMap.fromArrays(inst_29395,inst_29396);
var inst_29398 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29394,inst_29397);
var inst_29399 = (function(){throw inst_29398})();
var state_29406__$1 = state_29406;
var statearr_29408_29428 = state_29406__$1;
(statearr_29408_29428[(2)] = inst_29399);

(statearr_29408_29428[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29407 === (1))){
var state_29406__$1 = state_29406;
var statearr_29409_29429 = state_29406__$1;
(statearr_29409_29429[(2)] = null);

(statearr_29409_29429[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29407 === (4))){
var inst_29372 = (state_29406[(2)]);
var state_29406__$1 = state_29406;
var statearr_29410_29430 = state_29406__$1;
(statearr_29410_29430[(2)] = inst_29372);

(statearr_29410_29430[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29407 === (6))){
var inst_29378 = (state_29406[(7)]);
var inst_29380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29381 = fluree.db.flake.max_subject_id(inst_29378);
var inst_29382 = [inst_29381];
var inst_29383 = (new cljs.core.PersistentVector(null,1,(5),inst_29380,inst_29382,null));
var inst_29384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29385 = fluree.db.flake.min_subject_id(inst_29378);
var inst_29386 = [inst_29385];
var inst_29387 = (new cljs.core.PersistentVector(null,1,(5),inst_29384,inst_29386,null));
var inst_29388 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_29383,cljs.core._LT__EQ_,inst_29387,opts);
var state_29406__$1 = state_29406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29406__$1,(9),inst_29388);
} else {
if((state_val_29407 === (3))){
var inst_29404 = (state_29406[(2)]);
var state_29406__$1 = state_29406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29406__$1,inst_29404);
} else {
if((state_val_29407 === (2))){
var inst_29378 = (state_29406[(7)]);
var _ = (function (){var statearr_29412 = state_29406;
(statearr_29412[(4)] = cljs.core.cons((5),(state_29406[(4)])));

return statearr_29412;
})();
var inst_29378__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,name);
var state_29406__$1 = (function (){var statearr_29413 = state_29406;
(statearr_29413[(7)] = inst_29378__$1);

return statearr_29413;
})();
if(cljs.core.truth_(inst_29378__$1)){
var statearr_29414_29431 = state_29406__$1;
(statearr_29414_29431[(1)] = (6));

} else {
var statearr_29415_29432 = state_29406__$1;
(statearr_29415_29432[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29407 === (9))){
var inst_29390 = (state_29406[(2)]);
var inst_29391 = fluree.db.util.async.throw_err(inst_29390);
var state_29406__$1 = state_29406;
var statearr_29416_29433 = state_29406__$1;
(statearr_29416_29433[(2)] = inst_29391);

(statearr_29416_29433[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29407 === (5))){
var _ = (function (){var statearr_29417 = state_29406;
(statearr_29417[(4)] = cljs.core.rest((state_29406[(4)])));

return statearr_29417;
})();
var state_29406__$1 = state_29406;
var ex29411 = (state_29406__$1[(2)]);
var statearr_29418_29434 = state_29406__$1;
(statearr_29418_29434[(5)] = ex29411);


var statearr_29419_29435 = state_29406__$1;
(statearr_29419_29435[(1)] = (4));

(statearr_29419_29435[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_29407 === (8))){
var inst_29401 = (state_29406[(2)]);
var _ = (function (){var statearr_29420 = state_29406;
(statearr_29420[(4)] = cljs.core.rest((state_29406[(4)])));

return statearr_29420;
})();
var state_29406__$1 = state_29406;
var statearr_29421_29436 = state_29406__$1;
(statearr_29421_29436[(2)] = inst_29401);

(statearr_29421_29436[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__13883__auto__ = null;
var fluree$db$query$range$state_machine__13883__auto____0 = (function (){
var statearr_29422 = [null,null,null,null,null,null,null,null];
(statearr_29422[(0)] = fluree$db$query$range$state_machine__13883__auto__);

(statearr_29422[(1)] = (1));

return statearr_29422;
});
var fluree$db$query$range$state_machine__13883__auto____1 = (function (state_29406){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_29406);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e29423){var ex__13886__auto__ = e29423;
var statearr_29424_29437 = state_29406;
(statearr_29424_29437[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_29406[(4)]))){
var statearr_29425_29438 = state_29406;
(statearr_29425_29438[(1)] = cljs.core.first((state_29406[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__29439 = state_29406;
state_29406 = G__29439;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__13883__auto__ = function(state_29406){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__13883__auto____1.call(this,state_29406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__13883__auto____0;
fluree$db$query$range$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__13883__auto____1;
return fluree$db$query$range$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_29426 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_29426[(6)] = c__13957__auto__);

return statearr_29426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__29443 = flakes;
var vec__29444 = G__29443;
var seq__29445 = cljs.core.seq(vec__29444);
var first__29446 = cljs.core.first(seq__29445);
var seq__29445__$1 = cljs.core.next(seq__29445);
var flake_SINGLEQUOTE_ = first__29446;
var r = seq__29445__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__29443__$1 = G__29443;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__29452 = G__29443__$1;
var seq__29453 = cljs.core.seq(vec__29452);
var first__29454 = cljs.core.first(seq__29453);
var seq__29453__$1 = cljs.core.next(seq__29453);
var flake_SINGLEQUOTE___$1 = first__29454;
var r__$1 = seq__29453__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e29456){var e = e29456;
return null;
}})();
var map__29455 = cmd_map;
var map__29455__$1 = cljs.core.__destructure_map(map__29455);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29455__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29455__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29455__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29455__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29455__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29455__$1,cljs.core.cst$kw$expire);
var G__29457 = r__$1;
var G__29458 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__29443__$1 = G__29457;
result_STAR___$1 = G__29458;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__29467 = blocks;
var vec__29468 = G__29467;
var seq__29469 = cljs.core.seq(vec__29468);
var first__29470 = cljs.core.first(seq__29469);
var seq__29469__$1 = cljs.core.next(seq__29469);
var block_SINGLEQUOTE_ = first__29470;
var r = seq__29469__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__29467__$1 = G__29467;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__29475 = G__29467__$1;
var seq__29476 = cljs.core.seq(vec__29475);
var first__29477 = cljs.core.first(seq__29476);
var seq__29476__$1 = cljs.core.next(seq__29476);
var block_SINGLEQUOTE___$1 = first__29477;
var r__$1 = seq__29476__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__29478 = block_SINGLEQUOTE___$1;
var map__29478__$1 = cljs.core.__destructure_map(map__29478);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29478__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29478__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29478__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__29467__$1,result_STAR___$1,map__29478,map__29478__$1,block,t,flakes,vec__29475,seq__29476,first__29477,seq__29476__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29467,vec__29468,seq__29469,first__29470,seq__29469__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__29459_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__29459_SHARP_.p,(2))){
return p1__29459_SHARP_.o;
} else {
return null;
}
});})(G__29467__$1,result_STAR___$1,map__29478,map__29478__$1,block,t,flakes,vec__29475,seq__29476,first__29477,seq__29476__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29467,vec__29468,seq__29469,first__29470,seq__29469__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__29467__$1,result_STAR___$1,map__29478,map__29478__$1,block,t,flakes,prev_hash,vec__29475,seq__29476,first__29477,seq__29476__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29467,vec__29468,seq__29469,first__29470,seq__29469__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__29460_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__29460_SHARP_.p,(1))){
return p1__29460_SHARP_.o;
} else {
return null;
}
});})(G__29467__$1,result_STAR___$1,map__29478,map__29478__$1,block,t,flakes,prev_hash,vec__29475,seq__29476,first__29477,seq__29476__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29467,vec__29468,seq__29469,first__29470,seq__29469__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__29467__$1,result_STAR___$1,map__29478,map__29478__$1,block,t,flakes,prev_hash,hash,vec__29475,seq__29476,first__29477,seq__29476__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29467,vec__29468,seq__29469,first__29470,seq__29469__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__29461_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__29461_SHARP_.p,(5))){
return p1__29461_SHARP_.o;
} else {
return null;
}
});})(G__29467__$1,result_STAR___$1,map__29478,map__29478__$1,block,t,flakes,prev_hash,hash,vec__29475,seq__29476,first__29477,seq__29476__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29467,vec__29468,seq__29469,first__29470,seq__29469__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__29467__$1,result_STAR___$1,map__29478,map__29478__$1,block,t,flakes,prev_hash,hash,instant,vec__29475,seq__29476,first__29477,seq__29476__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29467,vec__29468,seq__29469,first__29470,seq__29469__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__29462_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__29462_SHARP_.p,(7))){
return p1__29462_SHARP_.o;
} else {
return null;
}
});})(G__29467__$1,result_STAR___$1,map__29478,map__29478__$1,block,t,flakes,prev_hash,hash,instant,vec__29475,seq__29476,first__29477,seq__29476__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29467,vec__29468,seq__29469,first__29470,seq__29469__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__29467__$1,result_STAR___$1,map__29478,map__29478__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__29475,seq__29476,first__29477,seq__29476__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29467,vec__29468,seq__29469,first__29470,seq__29469__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__29463_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__29463_SHARP_.p,(106));
});})(G__29467__$1,result_STAR___$1,map__29478,map__29478__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__29475,seq__29476,first__29477,seq__29476__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__29467,vec__29468,seq__29469,first__29470,seq__29469__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__29479 = r__$1;
var G__29480 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__29467__$1 = G__29479;
result_STAR___$1 = G__29480;
continue;
}
break;
}
});
