// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.query.http_signatures');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.crypto');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
/**
 * keys must include:
 *   method - post, get, etc. - used for (request-target) which is required
 *   path - path of the request
 *   
 */
fluree.db.query.http_signatures.generate_signing_string = (function fluree$db$query$http_signatures$generate_signing_string(val_map,ks){
if(cljs.core.truth_((function (){var and__4149__auto__ = cljs.core.some(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["(request-target)",null], null), null),ks);
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.some(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["mydate",null,"x-fluree-date",null,"date",null], null), null),ks);
} else {
return and__4149__auto__;
}
})())){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["A valid http-signature must sign at least (request-target), date (or x-fluree-date), ","and digest if the request has a body. You requested a signature based on: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ks], 0)),"."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_auth], null));
}

var get_or_throw = (function (m,k){
var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Signing string component ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)," is not present."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(401),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_auth], null));
}
});
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("(request-target)",k)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,["(request-target): ",clojure.string.lower_case(cljs.core.name(get_or_throw(val_map,"method")))," ",clojure.string.lower_case(get_or_throw(val_map,"path"))].join(''));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(k),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(get_or_throw(val_map,k))].join(''));
}
}),cljs.core.PersistentVector.EMPTY,ks));
});
fluree.db.query.http_signatures.verify_signature_header_STAR_ = (function fluree$db$query$http_signatures$verify_signature_header_STAR_(req,sig_header_str){
var map__44219 = req;
var map__44219__$1 = cljs.core.__destructure_map(map__44219);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44219__$1,cljs.core.cst$kw$request_DASH_method);
var uri = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44219__$1,cljs.core.cst$kw$uri);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44219__$1,cljs.core.cst$kw$headers);
var server_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44219__$1,cljs.core.cst$kw$server_DASH_name);
var sig_map = (function (){try{return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__44218_SHARP_){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.replace(p1__44218_SHARP_,/\"/,""),/=/);
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(sig_header_str,/\",/)));
}catch (e44220){var _ = e44220;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid Signature header. Ensure you have ","key1=value1,key2=value2 format and all string ","values are inside double-quotes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_auth], null));
}})();
var sig_parts = clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(sig_map,"headers",""),/ /);
var sign_string = fluree.db.query.http_signatures.generate_signing_string(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(headers,"method",request_method,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["path",uri,"host",server_name], 0)),sig_parts);
var signature = cljs.core.get.cljs$core$IFn$_invoke$arity$2(sig_map,"signature");
var authority = fluree.crypto.account_id_from_message(sign_string,signature);
var keyId = cljs.core.get.cljs$core$IFn$_invoke$arity$2(sig_map,"keyId");
var auth = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("na",keyId))?null:keyId);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Verifying signature. Sign string: ",sign_string," Signature: ",signature," Account Id: ",auth], 0));

return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$auth,(function (){var or__4160__auto__ = auth;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return authority;
}
})(),cljs.core.cst$kw$authority,authority,cljs.core.cst$kw$type,cljs.core.cst$kw$http_DASH_signature], null);
});
/**
 * Verifies signed http request. If signature header does not exist,
 *   returns nil. If it exists and is valid, returns the authid associated
 *   with it. If it exists and is invalid, throws exception.
 */
fluree.db.query.http_signatures.verify_signature_header = (function fluree$db$query$http_signatures$verify_signature_header(req){
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(req),"signature");
if(cljs.core.truth_(temp__5753__auto__)){
var sig_header_str = temp__5753__auto__;
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Verifying http signature header: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(sig_header_str)].join('')], 0));

return fluree.db.query.http_signatures.verify_signature_header_STAR_(req,sig_header_str);
} else {
return null;
}
});
/**
 * If a message digest is present, verifies it.
 */
fluree.db.query.http_signatures.verify_digest = (function fluree$db$query$http_signatures$verify_digest(req){
var digest = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"digest"], null));
if(cljs.core.truth_((function (){var and__4149__auto__ = digest;
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(digest,"null");
} else {
return and__4149__auto__;
}
})())){
var vec__44221 = cljs.core.re_find(/^([^=]+)=(.+)$/,digest);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44221,(0),null);
var hash_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44221,(1),null);
var hash = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44221,(2),null);
var ___$1 = (cljs.core.truth_((function (){var fexpr__44224 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["SHA-256",null], null), null);
return (fexpr__44224.cljs$core$IFn$_invoke$arity$1 ? fexpr__44224.cljs$core$IFn$_invoke$arity$1(hash_type) : fexpr__44224.call(null,hash_type));
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Digest type of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(hash_type)," is not supported."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(401),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_auth], null))})());
var body = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(req);
var body__$1 = ((typeof body === 'string')?body:fluree.db.util.json.stringify(body));
var calc_digest = (function (){var G__44225 = hash_type;
switch (G__44225) {
case "SHA-256":
return fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$2(body__$1,cljs.core.cst$kw$base64);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44225)].join('')));

}
})();
var valid_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(hash,calc_digest);
if((!(valid_QMARK_))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid digest.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(401),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_auth], null));
} else {
return req;
}
} else {
return req;
}
});
/**
 * Signs http request by creating required headers and using supplied private key.
 *   req-type should be :get, :post, etc.
 */
fluree.db.query.http_signatures.sign_request = (function fluree$db$query$http_signatures$sign_request(var_args){
var G__44228 = arguments.length;
switch (G__44228) {
case 4:
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4 = (function (req_method,url,request,private_key){
return fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5(req_method,url,request,private_key,null);
}));

(fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$5 = (function (req_method,url,request,private_key,auth){
var map__44229 = request;
var map__44229__$1 = cljs.core.__destructure_map(map__44229);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44229__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44229__$1,cljs.core.cst$kw$body);
var vec__44230 = (function (){var match = cljs.core.re_find(/^(https?\:)\/\/(([^:\/?#]*)(?:\:([0-9]+))?)([\/]{0,1}[^?#]*)$/,url);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(match,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(match,(5))], null);
})();
var host = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44230,(0),null);
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44230,(1),null);
var date = (function (){var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(headers,"date");
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (new Date()).toUTCString();
}
})();
var digest = (cljs.core.truth_(body)?["SHA-256=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.crypto.sha2_256.cljs$core$IFn$_invoke$arity$2(body,cljs.core.cst$kw$base64))].join(''):null);
var sign_headers = (cljs.core.truth_(body)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(request-target)","x-fluree-date","digest"], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["(request-target)","x-fluree-date"], null));
var sign_vals = (cljs.core.truth_(body)?new cljs.core.PersistentArrayMap(null, 4, ["x-fluree-date",date,"digest",digest,"method",req_method,"path",path], null):new cljs.core.PersistentArrayMap(null, 3, ["x-fluree-date",date,"method",req_method,"path",path], null));
var signing_string = fluree.db.query.http_signatures.generate_signing_string(sign_vals,sign_headers);
var sign_headers_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",sign_headers);
var sig = fluree.crypto.sign_message(signing_string,private_key);
var auth__$1 = (function (){var or__4160__auto__ = auth;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return "na";
}
})();
var sig_header = ["keyId=\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth__$1),"\",headers=\"",sign_headers_str,"\",algorithm=\"ecdsa-sha256\",signature=\"",sig,"\",date=\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(date),"\""].join('');
var headers_STAR_ = fluree.db.util.core.without_nils(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([headers,new cljs.core.PersistentArrayMap(null, 3, ["Digest",digest,"X-Fluree-Date",date,"Signature",sig_header], null)], 0)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(request,cljs.core.cst$kw$headers,headers_STAR_);
}));

(fluree.db.query.http_signatures.sign_request.cljs$lang$maxFixedArity = 5);

/**
 * Returns auth record from separated request parts.
 */
fluree.db.query.http_signatures.verify_request_STAR_ = (function fluree$db$query$http_signatures$verify_request_STAR_(var_args){
var G__44235 = arguments.length;
switch (G__44235) {
case 5:
return fluree.db.query.http_signatures.verify_request_STAR_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 4:
return fluree.db.query.http_signatures.verify_request_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.http_signatures.verify_request_STAR_.cljs$core$IFn$_invoke$arity$5 = (function (req,method,action,db_name,host){
return fluree.db.query.http_signatures.verify_request_STAR_.cljs$core$IFn$_invoke$arity$4(req,method,["/fdb/",fluree.db.util.core.keyword__GT_str(db_name),"/",fluree.db.util.core.keyword__GT_str(action)].join(''),host);
}));

(fluree.db.query.http_signatures.verify_request_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (req,method,uri,host){
return fluree.db.query.http_signatures.verify_signature_header(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(fluree.db.query.http_signatures.verify_digest(req),cljs.core.cst$kw$request_DASH_method,method,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$uri,uri,cljs.core.cst$kw$server_DASH_name,host], 0)));
}));

(fluree.db.query.http_signatures.verify_request_STAR_.cljs$lang$maxFixedArity = 5);

/**
 * Returns map of auth and authority from request.
 */
fluree.db.query.http_signatures.verify_request = (function fluree$db$query$http_signatures$verify_request(request){
return fluree.db.query.http_signatures.verify_signature_header(fluree.db.query.http_signatures.verify_digest(request));
});
